<?php
/**
 * Chinese (Simplified) texts
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2019 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @author PGV Developers
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: admin.zh-cn.php 7307 2021-07-11 11:22:17Z canajun2eh $
 * @translation mr_bobwang
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["full_name"]			= "全名";
$pgv_lang["error_header"] 		= "家谱文件,[#GEDCOM#], 文件位置不存在。";
$pgv_lang["PRIV_PUBLIC"]			= "公开";
$pgv_lang["manage_gedcoms"]		= "管理家谱文件";
$pgv_lang["label_ban_server"]			= "发送";
$pgv_lang["label_delete"]           	= "删除";
$pgv_lang["upload_replacement"]			= "上传替换";
$pgv_lang["access"]						= "允许查看";
$pgv_lang["add_gedcom"]			= "添加其它GEDCOM";
$pgv_lang["add_new_gedcom"] 			= "创建新的家谱";
$pgv_lang["add_new_language"]			= "加入一个新的语言";
$pgv_lang["add_user"]					= "加新用户";
$pgv_lang["admin_gedcom"]				= "管理家谱";
$pgv_lang["admin_gedcoms"]				= "管理家谱文件";
$pgv_lang["admin_geds"]					= "数据和家谱管理";
$pgv_lang["admin_site"]					= "网站管理";
$pgv_lang["admin_approved"]		= "你在#SERVER_NAME#的账户已经被批准通过";
$pgv_lang["administration"]		= "管理";
$pgv_lang["ALLOW_CHANGE_GEDCOM"]		= "可以换其它家谱";
$pgv_lang["ALLOW_REMEMBER_ME"]			= "在登录页显示 <b>记住我</b> ";
$pgv_lang["ALLOW_USER_THEMES"]			= "允许用户选择主题";
$pgv_lang["ansi_to_utf8"]		= "转换这个ANSI (ISO-8859-1) 编码GEDCOM 成UTF-8?";
$pgv_lang["apply_privacy"]				= "设置隐私？";
$pgv_lang["back_useradmin"]				= "回到用户管理";
$pgv_lang["bytes_read"] 				= "读起了Bytes:";
$pgv_lang["calc_marr_names"]			= "计算婚后的名字";
$pgv_lang["can_admin"]			= "设置用户为管理员";
$pgv_lang["can_edit"]			= "用户对家谱权限";
$pgv_lang["cleanup_places"] 			= "清理地方";
$pgv_lang["cleanup_users"]				= "清理用户";
$pgv_lang["click_here_to_continue"]		= "继续";
$pgv_lang["click_here_to_go_to_pedigree_tree"]	= "点击浏览家谱结构树。";
$pgv_lang["config_help"]						= "设置帮助";
$pgv_lang["configuration"]		= "设置";
$pgv_lang["configure"]							= "设置家谱";
$pgv_lang["configure_head"]						= "家谱设置";
$pgv_lang["confirm_gedcom_delete"]				= "确认删除这个家谱文件";
$pgv_lang["confirm_user_delete"]	= "确认删除用户";
$pgv_lang["create_user"]		= "创建用户";
$pgv_lang["current_users"]						= "用户表";
$pgv_lang["daily"]								= "每天";
$pgv_lang["dataset_exists"]		= "GEDCOM 以这个文件名已经被导入入资料库。";
$pgv_lang["date_registered"]					= "注册日";
$pgv_lang["day_before_month"]					= "在一个月前面的日子 (DD MM YYYY)";
$pgv_lang["DEFAULT_GEDCOM"]						= "设置默认显示家谱";
$pgv_lang["default_user"]						= "创建默认管理用户";
$pgv_lang["del_proceed"]						= "继续";
$pgv_lang["del_unvera"]							= "用户没有被管理员验证";
$pgv_lang["del_unveru"]							= "用户在七天内没有验证";
$pgv_lang["do_not_change"]						= "不要改";
$pgv_lang["download_gedcom"]		= "下载家谱文件";
$pgv_lang["download_here"]						= "下载文件";
$pgv_lang["editaccount"]						= "用户可以改自己的信息";
$pgv_lang["duplicate_username"]		= "用户名重复。其他用户已使用此用户名，请返回并选择其它用户名。";
$pgv_lang["empty_dataset"]		= "覆盖旧的信息吗？";
$pgv_lang["enable_disable_lang"]				= "设置语言";
$pgv_lang["found_record"]		= "被查找的记录";
$pgv_lang["ged_download"]						= "下载";
$pgv_lang["ged_import"]			= "导入文件";
$pgv_lang["ged_check"] 							= "检查";
$pgv_lang["gedcom_adm_head"]					= "家谱管理";
$pgv_lang["gedcom_file"]		= "GEDCOM 文件:";
$pgv_lang["gedcom_not_imported"]				= "家谱文件还没有被导入";
$pgv_lang["autoContinue"]						= "自动按《继续》";
$pgv_lang["import_complete"]		= "导入完全";
$pgv_lang["import_marr_names"]					= "导入婚后名字";
$pgv_lang["import_options"]						= "导入选项";
$pgv_lang["import_progress"]					= "正在导入...";
$pgv_lang["import_statistics"]					= "导入统计";
$pgv_lang["inc_languages"]						= "语言";
$pgv_lang["INDEX_DIRECTORY"]					= "索引目录";
$pgv_lang["label_families"]         			= "家庭";
$pgv_lang["label_gedcom_id2"]       			= "家谱代码：";
$pgv_lang["label_individuals"]      			= "个人";
$pgv_lang["label_password_id"]					= "密码";
$pgv_lang["label_username_id"]					= "用户名";
$pgv_lang["LANG_SELECTION"] 					= "支持的语言";
$pgv_lang["last_login"]							= "上次登录";
$pgv_lang["link_manage_servers"]   				= "管理网站";
$pgv_lang["logfile_content"]					= "日志文件";
$pgv_lang["mailto"]								= "发电子邮件";
$pgv_lang["merge_records"]						= "合并纪录";
$pgv_lang["message_to_all"]						= "发信息给所有的用户";
$pgv_lang["monthly"]							= "每月";
$pgv_lang["never"]								= "从没有";
$pgv_lang["PGV_MEMORY_LIMIT"]					= "内存限制";
$pgv_lang["PGV_SESSION_SAVE_PATH"]				= "工作的文件夹";
$pgv_lang["PGV_SESSION_TIME"]					= "用户时间限制";
$pgv_lang["phpinfo"]							= "PHP信息";
$pgv_lang["mysql"]								="MySQL数据库";
$pgv_lang["please_be_patient"]		= "请耐心";
$pgv_lang["privileges"]							= "特权";
$pgv_lang["reading_file"]		= "读取家谱文件";
$pgv_lang["readme_documentation"]	= "README 文件";
$pgv_lang["remove_ip"] 							= "删除IP地址";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION"] 	= "需要管理人员确认新用户注册";
$pgv_lang["rootid"]			= "家谱图表开始点";
$pgv_lang["seconds"]							= "&nbsp;&nbsp;秒";
$pgv_lang["select_an_option"]		= "选项：";
$pgv_lang["SERVER_URL"]							= "家谱网址";
$pgv_lang["show_phpinfo"]		= "显示PHP信息";
$pgv_lang["siteadmin"]							= "网站管理员";
$pgv_lang["time_limit"]							= "时限：";
$pgv_lang["translator_tools"]					= "翻译工具";
$pgv_lang["update_myaccount"]					= "更新用户帐号信息";
$pgv_lang["update_user"]		= "更新用户";
$pgv_lang["upload_gedcom"]		= "上传家谱文件";
$pgv_lang["USE_REGISTRATION_MODULE"]			= "允许申请注册";
$pgv_lang["user_auto_accept"]					= "自动接受用户的更改";
$pgv_lang["user_contact_method"]				= "首选联系方式";
$pgv_lang["user_create_error"]		= "无法增加用户。  请返回并再次尝试。";
$pgv_lang["user_created"]		= "用户成功地被创建。";
$pgv_lang["users_admin"]						= "网页管理员";
$pgv_lang["users_gedadmin"]						= "家谱管理员";
$pgv_lang["users_total"]						= "总共用户";
$pgv_lang["users_unver"]						= "未验证的用户";
$pgv_lang["users_unver_admin"]					= "没有被管理员验证";
$pgv_lang["usr_deleted"]						= "删除用户：";
$pgv_lang["verified"]			= "通过邮件验证:";
$pgv_lang["verified_by_admin"]		= "用户被管理员验证通过";
$pgv_lang["verify_gedcom"]						= "验证家谱文件";
$pgv_lang["visitor"]							= "游客";
$pgv_lang["weekly"]								= "每周";
$pgv_lang["welcome_new"]						= "欢迎来到你的家族网站。";
$pgv_lang["yearly"]								= "每年";
$pgv_lang["admin_OK_subject"]					= "允许账户在#PGV_SERVER_NAME##PGV_SCRIPT_PATH##";
$pgv_lang["gedcheck"]     = "家谱文件检查";
$pgv_lang["level"]        = "层次";
$pgv_lang["error"]        = "出错";
$pgv_lang["warning"]      = "警告";
$pgv_lang["info"]         = "信息";
$pgv_lang["all_rec"]      = "所有记录";
$pgv_lang["missing"]      = "丢失";
$pgv_lang["data"]         = "纪录";
$pgv_lang["SURNAME_TRADITION"] = "姓放在前后";
$pgv_lang["you_may_login"]		= " 由网站管理员。您现在可以通过以下链接登录PhpGedView站点:";


$pgv_lang["associated_files"]		= "有联系的文件：";
$pgv_lang["warn_file_delete"]		= "这个文件有重要的语言设置或等待改变的数据。你要删除它吗？";
$pgv_lang["deleted_files"]          = "被删除的文件：";
$pgv_lang["index_dir_cleanup_inst"]	= "如果想删除次文件夹的文件，请把它们拉到垃圾箱或者把它打上钩。按下删除便永久删除此文件。<br /><br />有<img src=\"./images/RESN_confidential.gif\" /> 标签的文件不能被删除，因为它被系统用。<br />有<img src=\"./images/RESN_locked.gif\" /> 标签的文件有重要的设置或等待改变的数据，所以建议不要删除。<br /><br />";
$pgv_lang["sanity_err0"]			= "错误：";
$pgv_lang["sanity_warn0"]			= "警告：";
$pgv_lang["refresh"]				= "刷新";
$pgv_lang["gedadmin"]				= "家谱管理员";
$pgv_lang["remove_all_files"]		= "删除没有必要的文件";
$pgv_lang["label_timedban_servers"] = "定时拒绝IP访问";
$pgv_lang["enter_banexpiry"] = "输入拒绝访问的到期日期和时间，例如：<br />2012.12.31@23:59";
$pgv_lang["analytics_config"] = "网络分析";
$pgv_lang["google_analytics"] = "谷歌分析";
$pgv_lang["USE_GOOGLE_ANALYTICS"] = "激活Google Analytics？";
$pgv_lang["PGV_GOOGLE_ANALYTICS"] = "Google Analytics帐号";
$pgv_lang["piwik_analytics"] = "Matomo Analytics";
$pgv_lang["USE_PIWIK_ANALYTICS"] = "激活Matomo Analytics？";
$pgv_lang["PGV_PIWIK_URL"] = "Matomo Analytics服务器URL";
$pgv_lang["PGV_PIWIK_SITE"] = "Matomo Analytics网站编号";
$pgv_lang["clustrmaps_analytics"] = "ClustrMaps Analytics";
$pgv_lang["USE_CLUSTRMAPS_ANALYTICS"] = "激活ClustrMaps Analytics？";
$pgv_lang["PGV_CLUSTRMAPS_SITE"] = "PhpGedView网址";
$pgv_lang["PGV_CLUSTRMAPS_SERVER"] = "ClustrMaps服务器号";
$pgv_lang["module_admin"] = "模块管理";
$pgv_lang["mod_admin_installed"] = "已安装的模块";
$pgv_lang["mod_admin_tabs"] = "管理标签";
$pgv_lang["mod_admin_menus"] = "管理菜单";
$pgv_lang["mod_admin_intro"] = "下面是PhpGedView实例中安装的所有模块的列表。模块通过将它们放在<i>modules</i>目录中来安装。在这里你可以为每个模块设置每个GEDCOM的访问级别。如果是模块包括单个页面的选项卡或菜单栏的菜单，您还可以设置每个页面的访问级别和顺序。";
$pgv_lang["mod_admin_active"] = "活性";
$pgv_lang["mod_admin_name"] = "模块名称";
$pgv_lang["mod_admin_description"] = "描述";
$pgv_lang["mod_admin_version"] = "版本/PGV";
$pgv_lang["mod_admin_hastab"] = "标签？";
$pgv_lang["mod_admin_hasmenu"] = "菜单？";
$pgv_lang["mod_admin_access_level"] = "访问权限";
$pgv_lang["mod_admin_order"] = "订购";
$pgv_lang["mod_admin_config"] = "Mod设置";
$pgv_lang["mod_admin_settings"] = "模块配置设置";
$pgv_lang["ret_module_admin"] = "返回模块管理页面";
$pgv_lang["ret_admin"] = "返回管理页面";
$pgv_lang["enter_comment"] = "你可以在这里输入评论。";
$pgv_lang["upload_a_gedcom"] = "上传GEDCOM文件";
$pgv_lang["start_entering"] = "开始输入数据";
$pgv_lang["add_gedcom_from_path"] = "从文件位置添加GEDCOM";
$pgv_lang["get_started_instructions"] = "选择其中一个选项开始使用PhpGedView";
$pgv_lang["admin_users_exists"] = "以下管理用户已经存在：";
$pgv_lang["install_step_1"] = "检查环境";
$pgv_lang["install_step_2"] = "数据库连接";
$pgv_lang["install_step_3"] = "创建表";
$pgv_lang["install_step_4"] = "网站配置";
$pgv_lang["install_step_5"] = "语言";
$pgv_lang["install_step_6"] = "保存配置";
$pgv_lang["install_step_7"] = "创建管理员用户";
$pgv_lang["install_wizard"] = "安装向导";
$pgv_lang["basic_site_config"] = "基本设置";
$pgv_lang["adv_site_config"] = "高级设置";
$pgv_lang["config_not_saved"] = "*您的设置将不会被保存，直到第6步";
$pgv_lang["download_config"] = "下载config.php";
$pgv_lang["site_unavailable"] = "网站目前无法使用";
$pgv_lang["to_manage_users"] = "要管理用户，请使用<a href=\"useradmin.php\">用户管理</a>页面。";
$pgv_lang["db_tables_created"] = "数据库表创建成功";
$pgv_lang["config_saved"] = "配置已成功保存";
$pgv_lang["checking_errors"] = "检查错误......";
$pgv_lang["checking_php_version"] = "检查所需的PHP版本：";
$pgv_lang["failed"] = "失败";
$pgv_lang["pgv_requires_version"] = "PhpGedView需要PHP版本#PGV_REQUIRED_PHP_VERSION#或更高版本。";
$pgv_lang["using_php_version"] = "您正在使用PHP版本#PGV_ACTUAL_PHP_VERSION#";
$pgv_lang["checking_db_support"] = "检查最低数据库支持：";
$pgv_lang["no_db_extensions"] = "您没有任何受支持的数据库扩展。";
$pgv_lang["db_ext_support"] = "你有#DBEXT#support";
$pgv_lang["checking_config.php"] = "检查config.php：";
$pgv_lang["config.php_missing"] = "找不到config.php文件。";
$pgv_lang["config.php_missing_instr"] = "此安装向导将无法将您的设置写入config.php文件。您可以复制config.dist文件并将其重命名为config.php。或者，完成此向导后，您可以选择下载您的设置并上传生成的config.php文件。";
$pgv_lang["config.php_not_writable"] = "config.php不可写。";
$pgv_lang["config.php_not_writable_instr"] = "此安装向导将无法将您的设置写入config.php文件。您可以在文件上设置写入权限，或者在完成此向导后，您可以选择下载设置并上传生成的config.php文件。";
$pgv_lang["passed"] = "通过。";
$pgv_lang["config.php_writable"] = "config.php存在且可写。";
$pgv_lang["checking_warnings"] = "检查警告......";
$pgv_lang["checking_timelimit"] = "检查改变时间限制的能力：";
$pgv_lang["cannot_change_timelimit"] = "无法改变时限。";
$pgv_lang["cannot_change_timelimit_instr"] = "你可能无法在拥有许多人的大型数据库上运行所有功能。";
$pgv_lang["current_max_timelimit"] = "你的最长期限是";
$pgv_lang["check_memlimit"] = "检查更改内存限制的能力：";
$pgv_lang["cannot_change_memlimit"] = "无法更改内存限制。";
$pgv_lang["cannot_change_memlimit_instr"] = "你可能无法在拥有许多人的大型数据库上运行所有功能。";
$pgv_lang["current_max_memlimit"] = "你目前的记忆限制是";
$pgv_lang["check_upload"] = "检查上传文件的能力：";
$pgv_lang["current_max_upload"] = "您的最大上传文件大小为：";
$pgv_lang["check_gd"] = "检查GD图像库：";
$pgv_lang["cannot_use_gd"] = "你没有GD图像库。你将无法自动创建图像缩略图。";
$pgv_lang["check_sax"] = "检查SAX XML库：";
$pgv_lang["cannot_use_sax"] = "你没有SAX XML库。你将无法运行任何报告或其他辅助功能。";
$pgv_lang["check_dom"] = "检查DOM XML库：";
$pgv_lang["cannot_use_dom"] = "你没有DOM XML库。你将无法导出XML。";
$pgv_lang["check_calendar"] = "检查高级日历库：";
$pgv_lang["cannot_use_calendar"] = "您没有高级日历支持。您将无法运行某些高级日历功能。";
$pgv_lang["warnings_passed"] = "所有警告检查均已通过。";
$pgv_lang["warning_instr"] = "如果没有通过任何警告，您仍然可以在此服务器上运行PhpGedView，但某些功能可能会被禁用，或者您可能会遇到性能不佳的情况。";
$pgv_lang["index_dir_cleanup"] = "清理索引目录";
$pgv_lang["clear_cache_succes"] = "缓存文件已被删除。";
$pgv_lang["clear_cache"] = "清除缓存文件";
$pgv_lang["sanity_err1"] = "你需要拥有PHP版本#PGV_REQUIRED_PHP_VERSION#或更高版本。";
$pgv_lang["sanity_err2"] = "文件或目录<i>#GLOBALS[whichFile]#</i>不存在。请验证文件或目录是否存在，没有错误命名，并且读取权限设置正确。";
$pgv_lang["sanity_err3"] = "文件<i>#GLOBALS[whichFile]#</i>没有正确上传。请尝试重新上传文件。";
$pgv_lang["sanity_err4"] = "文件<i>config.php</i>已损坏。";
$pgv_lang["sanity_err5"] = "<i>config.php</i>文件不可写。";
$pgv_lang["sanity_err6"] = "<i>#GLOBALS[INDEX_DIRECTORY]#</i>目录不可写。";
$pgv_lang["sanity_warn1"] = "<i>#GLOBALS[MEDIA_DIRECTORY]#</i>目录不可写。您将无法在PhpGedView中上传媒体文件或生成缩略图。";
$pgv_lang["sanity_warn2"] = "<i>#GLOBALS[MEDIA_DIRECTORY]#thumbs</i>目录不可写。您将无法在PhpGedView中上传缩略图或生成缩略图。";
$pgv_lang["sanity_warn3"] = "GD成像库不存在.PhpGedView仍然可以运行，但是一些功能，如缩略图生成和圆图，如果没有GD库，将无法工作。请参阅<a href='http://www.php.net/manual/en/ref.image.php'>http://www.php.net/manual/en/ref.image.php</a>了解更多信息。";
$pgv_lang["sanity_warn4"] = "XML Parser库不存在.PhpGedView仍然可以运行，但是如果没有XML Parser库，某些功能（如报告生成和Web服务）将无法运行。请参阅<a href='http://www.php.net/manual/en/ref.xml.php'>http://www.php.net/manual/en/ref.xml.php</a>了解更多信息。";
$pgv_lang["sanity_warn5"] = "DOM XML库不存在.PhpGedView仍然可以运行，但是一些功能，例如剪报购物车中的Gramps Export功能，下载和Web服务，将无法正常工作。请参阅<a href='http://www.php.net/manual/en/ref.domxml.php'>http://www.php.net/manual/en/ref.domxml.php</a>了解更多信息。";
$pgv_lang["sanity_warn6"] = "日历库不存在.PhpGedView仍然可以运行，但某些功能，例如转换为其他日历，如希伯来语或法语，将无法正常工作。运行PhpGedView并不是必需的。请参阅<a href='http://www.php.net/manual/en/ref.calendar.php'>http://www.php.net/manual/en/ref.calendar.php</a>了解更多信息。";
$pgv_lang["ip_address"] = "IP地址";
$pgv_lang["date_time"] = "日期和时间";
$pgv_lang["log_message"] = "日志消息";
$pgv_lang["searchtype"] = "搜索类型";
$pgv_lang["query"] = "查询";
$pgv_lang["user"] = "认证用户";
$pgv_lang["editors"] = "修编员";
$pgv_lang["gedcom_admins"] = "GEDCOM管理员";
$pgv_lang["site_admins"] = "网站管理员";
$pgv_lang["nobody"] = "没有人";
$pgv_lang["thumbnail_deleted"] = "缩略图文件已成功删除。";
$pgv_lang["thumbnail_not_deleted"] = "无法删除缩略图文件。";
$pgv_lang["step2"] = "第2步，共4步：";
$pgv_lang["move_file_success"] = "媒体和缩略图文件已成功移动。";
$pgv_lang["media_folder_corrupt"] = "媒体文件夹已损坏。";
$pgv_lang["media_file_not_deleted"] = "无法删除媒体文件。";
$pgv_lang["gedcom_deleted"] = "GEDCOM[#GED#]已成功删除。";
$pgv_lang["confirm_delete_file"] = "你确定要删除这个文件吗？";
$pgv_lang["confirm_folder_delete"] = "你确定要删除这个文件夹吗？";
$pgv_lang["confirm_remove_links"] = "您确定要删除此对象的所有链接吗？";
$pgv_lang["PRIV_USER"] = "仅向经过身份验证的用户显示";
$pgv_lang["PRIV_NONE"] = "仅向管理员用户显示";
$pgv_lang["PRIV_HIDE"] = "甚至隐藏来自管理员用户";
$pgv_lang["keep_media"] = "保持媒体链接";
$pgv_lang["current_links"] = "链接";
$pgv_lang["add_more_links"] = "添加链接";
$pgv_lang["enter_pid_or_name"] = "输入个人ID或姓名";
$pgv_lang["set_links"] = "设置链接";
$pgv_lang["add_or_remove_links"] = "管理链接";
$pgv_lang["keep"] = "保持";
$pgv_lang["unlink"] = "取消";
$pgv_lang["nav"] = "航海家";
$pgv_lang["fam_nav"] = "家庭导航员";
$pgv_lang["remove"] = "去掉";
$pgv_lang["keep_link"] = "将链接保留在列表中";
$pgv_lang["remove_link"] = "从列表中删除链接";
$pgv_lang["open_nav"] = "开放家庭导航员";
$pgv_lang["link_exists"] = "这个链接已经存在";
$pgv_lang["id_not_valid"] = "不是有效的个人，家庭或来源ID";
$pgv_lang["add_fam_other_links"] = "添加家庭和搜索链接";
$pgv_lang["search_add_links"] = "搜索人员添加到添加链接列表。";
$pgv_lang["enter_name"] = "输入名称";
$pgv_lang["add_indi_to_link_list"] = "单击名称将人员添加到添加链接列表。";
$pgv_lang["click_choose_head"] = "点击#GLOBALS[tempStringHead]#选择人为家长。";
$pgv_lang["click_choose_head_text"] = "点击选择人为家长。";
$pgv_lang["head"] = "头";
$pgv_lang["id_empty"] = "添加链接时，ID字段不能为空。";
$pgv_lang["link_deleted"] = "链接到#GLOBALS[remLinkId]#删除";
$pgv_lang["link_added"] = "链接到#GLOBALS[addLinkId]#添加";
$pgv_lang["no_update_CHANs"] = "不要更新CHAN（最后更改）记录";
$pgv_lang["no_CHANs_update"] = "没有陈（最后更改）记录已更新";
$pgv_lang["files_in_backup"] = "此备份中包含的文件";
$pgv_lang["created_remotelinks"] = "成功创建了<i>Remotelinks</i>表。";
$pgv_lang["created_remotelinks_fail"] = "无法创建<i>Remotelinks</i>表。";
$pgv_lang["created_indis"] = "成功创建<i>个人</i>表。";
$pgv_lang["created_indis_fail"] = "无法创建<i>个人</i>表。";
$pgv_lang["created_fams"] = "成功创建<i>家庭</i>表。";
$pgv_lang["created_fams_fail"] = "无法创建<i>Families</i>表。";
$pgv_lang["created_sources"] = "成功创建了<i>Sources</i>表。";
$pgv_lang["created_sources_fail"] = "无法创建<i>Sources</i>表。";
$pgv_lang["created_other"] = "成功创建<i>其他</i>表。";
$pgv_lang["created_other_fail"] = "无法创建<i>其他</i>表。";
$pgv_lang["created_places"] = "成功创建<i>地方</i>表。";
$pgv_lang["created_places_fail"] = "无法创建<i>地方</i>表。";
$pgv_lang["created_placelinks"] = "已成功创建<i>放置链接</i>表。";
$pgv_lang["created_placelinks_fail"] = "无法创建<i>放置链接</i>表。";
$pgv_lang["created_media_fail"] = "无法创建<i>Media</i>表。";
$pgv_lang["created_media_mapping_fail"] = "无法创建<i>媒体映射</i>表。";
$pgv_lang["no_thumb_dir"] = "缩略图目录不存在，无法创建。";
$pgv_lang["folder_created"] = "目录创建";
$pgv_lang["folder_no_create"] = "无法创建目录";
$pgv_lang["security_no_create"] = "安全警告：无法在中创建文件<b><i>index.php</i></b>";
$pgv_lang["security_not_exist"] = "安全警告：文件<b><i>index.php</i></b>不存在于";
$pgv_lang["progress_bars_info"] = "下面的状态栏将告诉您导入的进度。如果时间限制用完，导入将停止，并且将要求您按<b>继续</b>按钮。如果您没有看到<b>继续</b>按钮，您必须以较小的时间限制值重新启动导入。";
$pgv_lang["about_user"] = "您必须首先创建主管理用户。此用户将有权更新配置文件，查看私有数据以及创建其他用户。";
$pgv_lang["admin_info"] = "信息化";
$pgv_lang["admin_user_warnings"] = "一个或多个用户帐户有警告";
$pgv_lang["admin_verification_waiting"] = "用户帐户正在等待管理员验证";
$pgv_lang["ansi_encoding_detected"] = "检测到ANSI文件编码。";
$pgv_lang["change_id"] = "将个人ID更改为";
$pgv_lang["choose_priv"] = "选择隐私级别：";
$pgv_lang["comment"] = "管理员对用户的评论";
$pgv_lang["comment_exp"] = "日期管理员警告";
$pgv_lang["config_still_writable"] = "您的<i>config.php</i>文件仍然可写。为了安全起见，您应该在完成站点配置后将此文件的权限设置为只读。";
$pgv_lang["unsync_warning"] = "此GEDCOM文件<em>不</em>与数据库同步。它可能不包含最新版本的数据。要从数据库而不是文件重新导入，您应该下载并重新上传。";
$pgv_lang["del_gedrights"] = "GEDCOM不再有效，删除用户引用。";
$pgv_lang["download_note"] = "注意：大型数据库在下载之前可能需要很长时间才能处理。如果PHP在下载完成之前超时，则下载的文件可能不完整。<br /><br />要确保文件已正确下载，检查GEDCOM格式的文​​件的最后一行是<b>0&nbsp;TRLR</b>，或者XML格式的文件的最后一行是<b>&lt;/database&gt;</b>。这些文件是文本;您可以使用任何合适的文本编辑器，但在检查后确保<u>不</u>保存下载的文件。<br /><br />一般来说，可能需要花费很多时间下载导入原始GEDCOM文件。";
$pgv_lang["empty_lines_detected"] = "在您的GEDCOM文件中检测到空行。";
$pgv_lang["error_ban_server"] = "无效的IP地址。";
$pgv_lang["error_delete_person"] = "您必须选择要删除其远程链接的人。";
$pgv_lang["error_header_write"] = "GEDCOM文件<b>#GEDCOM#</b>不可写。请检查属性和访问权限。";
$pgv_lang["error_remove_site"] = "无法删除远程服务器。";
$pgv_lang["error_remove_site_linked"] = "无法删除远程服务器，因为其Connections列表不为空。";
$pgv_lang["error_remote_duplicate"] = "这个远程数据库已作为<i>#GLOBALS[whichFile]#</i>列在列表中";
$pgv_lang["error_siteauth_failed"] = "无法对远程站点进行身份验证";
$pgv_lang["error_url_blank"] = "请不要将远程站点标题或URL留空";
$pgv_lang["error_view_info"] = "你必须选择你想要查看其信息的人。";
$pgv_lang["example_date"] = "来自GEDCOM的无效日期示例：";
$pgv_lang["example_place"] = "你的GEDCOM无效地点的例子：";
$pgv_lang["fbsql"] = "FrontBase";
$pgv_lang["ged_export"] = "导出";
$pgv_lang["gedcom_config_write_error"] = "错误!!!<br />无法写入文件<i>#GLOBALS[whichFile]#</i>。请检查它是否有正确的写入权限。";
$pgv_lang["gedcom_downloadable"] = "此GEDCOM文件可通过互联网下载！<br />请参阅<a href=\"readme.txt\"> <b>readme.txt</b></a>文件的安全部分以修复这个问题";
$pgv_lang["ibase"] = "InterBase的";
$pgv_lang["ifx"] = "Informix的";
$pgv_lang["img_admin_settings"] = "编辑图像处理配置";
$pgv_lang["import_time_exceeded"] = "达到了执行时间限制。单击下面的继续按钮继续导入GEDCOM文件。";
$pgv_lang["invalid_dates"] = "检测到无效日期格式，清理后这些格式将更改为DD MMM YYYY格式（例如2004年1月1日）。";
$pgv_lang["BOM_detected"] = "在文件开头检测到字节顺序标记（BOM）。在清理时，将删除此特殊代码。";
$pgv_lang["invalid_header"] = "在GEDCOM标题之前检测到行<b>0&nbsp;HEAD</b>。在清理时，这些行将被删除。";
$pgv_lang["label_added_servers"] = "远程服务器";
$pgv_lang["label_banned_servers"] = "拒绝IP访问";
$pgv_lang["label_manual_search_engines"] = "使用IP地址标记搜索引擎";
$pgv_lang["label_new_server"] = "添加新网站";
$pgv_lang["label_server_info"] = "所有通过网站远程链接的人和家庭：";
$pgv_lang["label_server_url"] = "网站网址/IP";
$pgv_lang["label_view_local"] = "查看关于人的当地信息";
$pgv_lang["label_view_remote"] = "查看关于人的远程信息";
$pgv_lang["LANGUAGE_DEFAULT"] = "您尚未配置您的网站将支持的语言。<br />PhpGedView将使用其默认操作。";
$pgv_lang["lasttab"] = "最后访问个人标签";
$pgv_lang["leave_blank"] = "如果要保留当前密码，请将密码留空。";
$pgv_lang["macfile_detected"] = "检测到Macintosh文件。在清理时，您的文件将转换为DOS文件。";
$pgv_lang["messaging"] = "PhpGedView内部消息";
$pgv_lang["messaging2"] = "通过电子邮件发送内部消息";
$pgv_lang["messaging3"] = "电子邮件";
$pgv_lang["month_before_day"] = "前一天（MM DD YYYY）";
$pgv_lang["msql"] = "迷你SQL";
$pgv_lang["mssql"] = "Microsoft SQL服务器";
$pgv_lang["no_logs"] = "禁用日志记录";
$pgv_lang["no_messaging"] = "没有联系方式";
$pgv_lang["oci8"] = "Oracle 7+";
$pgv_lang["page_views"] = "&nbsp;&nbsp;page views in&nbsp;&nbsp";
$pgv_lang["performing_validation"] = "执行GEDCOM验证......";
$pgv_lang["pgsql"] = "PostgreSQL的";
$pgv_lang["pgv_config_write_error"] = "错误!!!无法写入PhpGedView配置文件。请检查文件和目录权限，然后重试。";
$pgv_lang["PGV_SIMPLE_MAIL"] = "在外部邮件中使用简单的邮件标题";
$pgv_lang["PGV_SMTP_ACTIVE"] = "使用SMTP发送外部邮件";
$pgv_lang["PGV_SMTP_HOST"] = "发送服务器（SMTP）名称";
$pgv_lang["PGV_SMTP_HELO"] = "发送域名";
$pgv_lang["PGV_SMTP_PORT"] = "SMTP端口";
$pgv_lang["PGV_SMTP_AUTH"] = "使用名称和密码";
$pgv_lang["PGV_SMTP_AUTH_USER"] = "用户名";
$pgv_lang["PGV_SMTP_AUTH_PASS"] = "密码";
$pgv_lang["PGV_SMTP_SSL"] = "安全连接";
$pgv_lang["PGV_SMTP_FROM_NAME"] = "发件人姓名";
$pgv_lang["PGV_STORE_MESSAGES"] = "允许在线存储消息";
$pgv_lang["place_cleanup_detected"] = "检测到无效的地点编码。这些错误应该是固定的。";
$pgv_lang["review_readme"] = "在继续配置PhpGedView之前，您应该查看<a href=\"readme.txt\" target=\"_blank\">readme.txt</a>文件。<br /><br />";
$pgv_lang["sqlite"] = "SQLite";
$pgv_lang["sybase"] = "Sybase";
$pgv_lang["sync_gedcom"] = "将用户设置与GEDCOM数据同步";
$pgv_lang["system_time"] = "当前服务器时间：";
$pgv_lang["user_time"] = "当前用户时间：";
$pgv_lang["TBLPREFIX"] = "数据库表前缀";
$pgv_lang["themecustomization"] = "主题定制";
$pgv_lang["title_manage_servers"] = "管理网站";
$pgv_lang["title_view_conns"] = "查看连接";
$pgv_lang["user_default_tab"] = "默认选项卡显示在个人信息页面上";
$pgv_lang["user_path_length"] = "最大关系隐私路径长度";
$pgv_lang["user_relationship_priv"] = "限制对相关人员的访问";
$pgv_lang["usr_idle"] = "自上次登录以来用户帐户被视为非活动状态的月数：";
$pgv_lang["usr_idle_toolong"] = "用户的帐户已停用太长时间：";
$pgv_lang["usr_no_cleanup"] = "没有找到清理工作";
$pgv_lang["usr_unset_gedcomid"] = "取消GEDCOM ID";
$pgv_lang["usr_unset_rights"] = "取消GEDCOM的权利";
$pgv_lang["usr_unset_rootid"] = "取消设置根ID";
$pgv_lang["valid_gedcom"] = "检测到有效的GEDCOM。无需清理。";
$pgv_lang["validate_gedcom"] = "验证GEDCOM";
$pgv_lang["verify_upload_instructions"] = "找到了一个同名的GEDCOM文件。如果你选择继续，旧的GEDCOM文件将替换为你上传的文件，导入过程将重新开始。如果你选择取消，旧的GEDCOM将保留不变。";
$pgv_lang["view_changelog"] = "查看changelog.txt文件";
$pgv_lang["view_logs"] = "查看日志文件";
$pgv_lang["view_readme"] = "查看readme.txt文件";
$pgv_lang["visibleonline"] = "在线时可见其他用户";
$pgv_lang["warn_users"] = "有警告的用户";
$pgv_lang["admin_OK_message"] = "网站 #PGV_SERVER_NAME##PGV_SCRIPT_PATH# 的管理员已经批淮了您的帐户申请。\r\n\r\n您现在可以通过访问以下链接登录：#PGV_SERVER_NAME##PGV_SCRIPT_PATH#";
$pgv_lang["batch_update"] = 	"在GEDCOM上执行批量更新/编辑";
//Text for the Gedcom Checker
$pgv_lang["gedcheck_text"] = "该模块根据<a href=\"http://phpgedview.sourceforge.net/ged551-5.pdf\">5.5.1 GEDCOM规范</a>检查GEDCOM文件的格式。它还检查您的数据中存在许多常见错误。请注意，规范中有许多版本，扩展和变体，因此除了标记为严重的问题之外，您不应该关注任何问题。所有行的解释 - 在规范中可以找到线上错误，因此请在寻求帮助前查看。";
$pgv_lang["gedcheck_sync"] = "对数据库所做的编辑不会同步到文件#GLOBALS[ged]#。文件内容可能已过时。您现在可以通过执行<b><a \"#GLOBALS[ged_link]#\">出口</a></b>。";
$pgv_lang["gedcheck_nothing"] = "检查没有发现任何错误。";
$pgv_lang["critical"] = "危急";
$pgv_lang["open_link"] = "打开链接"; //在哪里打开链接
$pgv_lang["same_win"] = "相同标签/窗口";
$pgv_lang["new_win"] = "新标签/窗口";
$pgv_lang["context_lines"] = "GEDCOM背景线"; //错误的任一侧的行数
$pgv_lang["err_rec"] = "有错误的记录";
$pgv_lang["multiple"] = "多";
$pgv_lang["invalid"] = "无效";
$pgv_lang["too_many"] = "太多";
$pgv_lang["too_few"] = "太少了";
$pgv_lang["no_link"] = "没有回链接";
$pgv_lang["see"] = "看到";
$pgv_lang["noref"] = "没有人提到这条记录";
$pgv_lang["tag"] = "标签";
$pgv_lang["spacing"] = "间距";
$pgv_lang["ADVANCED_NAME_FACTS"] = "高级名称事件";
$pgv_lang["ADVANCED_PLAC_FACTS"] = "高级地名事件";
$pgv_lang["tradition_spanish"] = "西班牙";
$pgv_lang["tradition_portuguese"] = "葡萄牙语";
$pgv_lang["tradition_icelandic"] = "冰岛";
$pgv_lang["tradition_paternal"] = "继承父姓";
$pgv_lang["tradition_polish"] = "波兰";
$pgv_lang["tradition_none"] = "没有";

?>
