<?php
/**
 * Catalan texts
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2022  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @author Antoni Planas i Vilà
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: configure_help.ca.php 7328 2022-01-12 18:30:53Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["google_analytics_help"]			= "~#pgv_lang[google_analytics]#~<br /><br />El servei #pgv_lang[google_analytics]# es descriu en aquest <a href='https://ca.wikipedia.org/wiki/Google_Analytics' target='_blank' title='Google Analytics'>article de Viquipèdiae</a>.<br /><br />Tingueu en compte que, si decidiu utilitzar aquest servei, Google adquireix els drets de totes les dades que recopila sobre l’activitat dels visitants al vostre lloc.";
$pgv_lang["USE_GOOGLE_ANALYTICS_help"]		= "~#pgv_lang[USE_GOOGLE_ANALYTICS]#~<br /><br />Seleccioneu <b>#pgv_lang[yes]#</b> per habilitar el seguiment de l'activitat al vostre lloc mitjançant el servei #pgv_lang[google_analytics]#. Heu de subscriure-us a aquest servei abans d’activar aquesta opció.";
$pgv_lang["PGV_GOOGLE_ANALYTICS_help"]		= "~#pgv_lang[PGV_GOOGLE_ANALYTICS]#~<br /><br />Introduïu el número de compte assignat al vostre lloc quan us hàgiu subscrit al servei #pgv_lang[google_analytics]#. Aquest número de compte té el format <b>UA-xxxxxx-x</b>.";
$pgv_lang["piwik_analytics_help"]			= "~#pgv_lang[piwik_analytics]#~<br /><br /><a href='https://matomo.org/' target='_blank' title='Lloc web oficial de Matomo'>Aquí</a> es descriu, en anglès, el projecte de codi obert #pgv_lang[piwik_analytics]#, anomenat originalment «Piwik».<br /><br />Matomo és una alternativa a #pgv_lang[google_analytics]# que elimina moltes de les preocupacions de privadesa. Podeu installar l’aplicació Matomo al vostre propi servidor web o al vostre propi domini, de manera que assegureu-vos que teniu un control complet sobre les dades d’activitat que s’han recopilat.";
$pgv_lang["USE_PIWIK_ANALYTICS_help"]		= "~#pgv_lang[USE_PIWIK_ANALYTICS]#~<br /><br />Seleccioneu <b>#pgv_lang[yes]#</b> per habilitar el seguiment de l'activitat al vostre lloc mitjançant un servidor #pgv_lang[piwik_analytics]#. El vostre lloc PhpGedView ha d’estar registrat en un servidor Matomo.";
$pgv_lang["PGV_PIWIK_URL_help"]				= "~#pgv_lang[PGV_PIWIK_URL]#~<br /><br />Introduïu l'URL d'un servidor Matomo on estigui registrat el vostre lloc PhpGedView.";
$pgv_lang["PGV_PIWIK_SITE_help"]			= "~#pgv_lang[PGV_PIWIK_SITE]#~<br /><br />Introduïu l'identificador numèric de lloc assignat al vostre lloc PhpGedView pel servidor Matomo.";
$pgv_lang["clustrmaps_analytics_help"]		= "~#pgv_lang[clustrmaps_analytics]#~<br /><br />#pgv_lang[clustrmaps_analytics]# és un comptador de visites combinat, un seguiment de visitants i una eina de visualització geogràfica.<br /><br />Cada pàgina inclou una imatge de mapa en miniatura generada per #pgv_lang[clustrmaps_analytics]#. Quan es carrega aquesta imatge, s'incrementa un comptador al lloc de #pgv_lang[clustrmaps_analytics]#. Quan el mapa, que és visible per a tots els vostres visitants, s’actualitza (diàriament, setmanalment o mensualment, en funció del trànsit), mostra la ubicació de tots els visitants a la vostra pàgina des del començament d’un interval de temps específic.<br /><br />Si heu pagat el servei #pgv_lang[clustrmaps_analytics]#, en fer clic a la imatge del mapa en miniatura es mostrarà una visualització més gran del mapa del món.<br /><br />Podeu obtenir més informació al <a href='http://www.clustrmaps.com/' target='_blank' title='lloc de #pgv_lang[clustrmaps_analytics]#'>lloc de #pgv_lang[clustrmaps_analytics]#</a>.";
$pgv_lang["USE_CLUSTRMAPS_ANALYTICS_help"]	= "~#pgv_lang[USE_CLUSTRMAPS_ANALYTICS]#~<br /><br />Seleccioneu <b>#pgv_lang[yes]#</b> per habilitar el seguiment de l'activitat al vostre lloc mitjançant un servidor #pgv_lang[clustrmaps_analytics]#.";
$pgv_lang["PGV_CLUSTRMAPS_SITE_help"]		= "~#pgv_lang[PGV_CLUSTRMAPS_SITE]#~<br /><br />Introduïu l'URL del vostre lloc PhpGedView. Aquest valor s'ha omplert per a vosaltres i normalment no caldria canviar-lo.";
$pgv_lang["PGV_CLUSTRMAPS_SERVER_help"]		= "~#pgv_lang[PGV_CLUSTRMAPS_SERVER]#~<br /><br />Introduïu el número de servidor assignat pel servei #pgv_lang[clustrmaps_analytics]# quan vau activar el compte.";

$pgv_lang["SHOW_LIST_PLACES"]	= "Nivells de lloc a mostrar a les llistes";
$pgv_lang["SHOW_LIST_PLACES_help"]	= "~ #pgv_lang[SHOW_LIST_PLACES]#~<br /><br />Això determina la quantitat d'informació que es mostrarà als camps de llocs de les llistes.<br /><br />Establint el valor a <b>9</b> garantireu que es vegi tota la informació dels llocs. Posant-ho a <b>0</b> (zero), s'oculten completament els llocs. Ajustant el valor a <b>1</b> es mostrarà el nivell més alt, que normalment és el país. Establint-lo <b>2</b> es mostraran dos nivells. El segon nivell més alt, per sota del país, sovint és l'estat, província o territori. Etc ";

$pgv_lang["new_gedcom_title"]		= "Genealogia de #GEDCOMFILE#";
$pgv_lang["keep_media_help"]			= "~#pgv_lang[keep_media]#~<br /><br />Cal conservar (o no) els enllaços multimèdia existents a la base de dades quan s'està carregant un GEDCOM de substitució. La opció <b>#pgv_lang[no]#</b> elimina de la base de dades els enllaços multimèdia existents, mentre que l'opció <b>#pgv_lang[yes]#</b> els conserva.<br /><br />És útil quan exporteu el vostre GEDCOM des de PhpGedView a un programa de manteniment GEDCOM fora de línea, que no gestioni correctament els punters d'enllaços multimèdia i posteriorment, reimporteu aquell GEDCOM modificat a PhpGedView. En aquestes circumstàncies circumstàncies, els punters multimèdia dins del GEDCOM que heu exportat al vostre programa d'edició fora de línea es perden i us caldrà re-enllaçar tots els fitxers multimèdia a les seves corresponents Persones, Famílies i Fonts, un cop hagueu reimportat el GEDCOM al PhpGedView.<br /><br />La opció <b>#pgv_lang[yes]#</b> ordena al PhpGedView mantenir els enllaços multimèdia existents per a que no us calgui tornar-los a crear desprès d'importar el GEDCOM modificat, però això exigeix que el programa d'edició fora de línea produeixi sempre els mateixos números d'identificació de Persones, Famílies i Fonts.<br /><br /><i>Family Tree Maker</i> és un dels programes d'edició fora de línea que <u>no</u> gestiona correctament els punters multimèdia del GEDCOM. <i>Legacy</i> i alguns altres, <u>si</u> que els gestiona correctament.<br />";
$pgv_lang["USE_MEDIA_VIEWER"]			= "Empra el visor multimèdia";
$pgv_lang["USE_MEDIA_VIEWER_help"]		= "~#pgv_lang[USE_MEDIA_VIEWER]#~<br /><br />Quan aquesta opció és a <b>#pgv_lang[yes]#</b>, polsant les imatges apareixerà la pàgina del Visor Multimèdia que mostra els detalls de la imatge. Si teniu atribucions, podreu també editar--la.<br /><br />Quan aquesta opció és  a <b>#pgv_lang[no]#</b>, polsant les imatges se'n produeixen a mida real dins una nova finestra.";
$pgv_lang["USE_MEDIA_FIREWALL"]			= "Empra el Tallafocs Multimèdia";
$pgv_lang["USE_MEDIA_FIREWALL_help"]	= "~#pgv_lang[USE_MEDIA_FIREWALL]#~<br /><br />Accediu a Wiki per a obtenir una descripció de com emprar el Tallafoc Multimèdia. <a href=\"http://wiki.phpgedview.net/en/index.php?title=Media_Firewall\" target=\"_blank\">http://wiki.phpgedview.net/en/index.php?title=Media_Firewall</a>";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR"]			= "Directori arrel del Tallafoc Multimèdia";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_help"]	= "~#pgv_lang[MEDIA_FIREWALL_ROOTDIR]#~<br /><br />Directori en el que pot crear-se el directori multimèdia protegit. #pgv_lang[MEDIA_FIREWALL_ROOTDIR_note]#";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_note"]	= "Quan aquest camp és buit pot emprar-se el directori <b>#GLOBALS[INDEX_DIRECTORY]#</b>";
$pgv_lang["MEDIA_FIREWALL_THUMBS"]			= "Protegeix les miniatures d'imatges protegides";
$pgv_lang["MEDIA_FIREWALL_THUMBS_help"]	= "~#pgv_lang[MEDIA_FIREWALL_THUMBS]#~<br /><br />Quan una imatge és al directori Multimèdia protegit, cal protegir també la seva miniatura?";
$pgv_lang["SHOW_SPIDER_TAGLINE"]		= "Mostra l'aranya d'etiquetes";
$pgv_lang["SHOW_SPIDER_TAGLINE_help"]		= "~#pgv_lang[SHOW_SPIDER_TAGLINE]#~<br /><br />En pàgines generades per motors de recerca mostra a la darrera línea el motor de recerca particular que ha detectat la pàgina. Si s'activa aquesta opció, predisposa Google&reg; AdSense per a eines d'optimització del motor de recerca.";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS_help"] = "~#pgv_lang[SHOW_PRIVATE_RELATIONSHIPS]#~<br /><br />Aquesta opció retindrà vincles familiars en registres privatitzats. Això farà que vegeu caixetins  «#pgv_lang[private]#» buits a l'arbre genealògic i a altres gràfics amb persones privades.<br /><br />Aquest paràmetre és desactivat per defecte. Us recomanem que, per comptes d'activar-lo, configureu al vostre GEDCOM la persona arrel de l'arbre genealògic, com a persona no privada.";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS"]	= "Mostra relacions de privadesa";
$pgv_lang["SYNC_GEDCOM_FILE_help"] 			= "~#pgv_lang[SYNC_GEDCOM_FILE]#~<br /><br />Si configureu aquest valor a <b>#pgv_lang[yes]#</b>, s'actualitzarà automàticament el fitxer GEDCOM quan s'acceptin canvis a la base de dades. Això mantindrà el fitxer GEDCOM sincronitzat amb la base de dades.<br /><br />És possible que vulgueu convertir-lo a <b>#pgv_lang[no]#</b> per millorar la velocitat del programa i conservar la memòria quan accepteu canvis.";
$pgv_lang["SYNC_GEDCOM_FILE"]			= "Sincronitza el que s'ha editat amb el fitxer GEDCOM";
$pgv_lang["SHOW_MULTISITE_SEARCH_help"]	= "~#pgv_lang[SHOW_MULTISITE_SEARCH]#~<br /><br />La recerca a múltiples llocs permet als usuaris cercar entre les múltiples pàgines web PhpGedView que hagueu configurat a l'àrea d'administració de Gestió de Llocs o enllaçat remotament. Aquesta opció controla si la recerca a múltiples llocs és accessible a tothom o solament als amb accés.";
$pgv_lang["SHOW_MULTISITE_SEARCH"]		= "Mostra cercar a múltiples llocs";
$pgv_lang["SHOW_NO_WATERMARK"]			= "Qui pot veure imatges sense marca d'aigua digital?";
$pgv_lang["SHOW_NO_WATERMARK_help"]		= "~#pgv_lang[SHOW_NO_WATERMARK]#~<br /><br />Si s'ha activat el Tallafocs Multimèdia, els usuaris poden veure marques d'aigua digitals si no tenen el nivells d'atribucions especificat aquí.";
$pgv_lang["WATERMARK_THUMB"]			= "Afegir marques d'aigua digitals a les miniatures?";
$pgv_lang["WATERMARK_THUMB_help"]		= "~#pgv_lang[WATERMARK_THUMB]#~<br /><br />Si s'ha activat el Tallafocs Multimèdia, cal posar marques d'aigua digitals a les miniatures? La vostres llistes multimèdia es carregaran més ràpid si no cal fer-ho.";
$pgv_lang["SAVE_WATERMARK_THUMB"]		= "Emmagatzemar les miniatures amb marques d'aigua digitals al servidor?";
$pgv_lang["SAVE_WATERMARK_THUMB_help"]	= "~#pgv_lang[SAVE_WATERMARK_THUMB]#~<br /><br />Si s'ha activat el Tallafocs Multimèdia, cal emmagatzemar còpies de les miniatures amb marques d'aigua digitals al servidor a més de les mateixes miniatures sense aquestes marques?<br /><br />Si no poseu a <b>#pgv_lang[yes]#</b>, les llistes multimèdia es generaran més de pressa a expenses d'una major ocupació d'espai de disc al servidor.";
$pgv_lang["SAVE_WATERMARK_IMAGE"]		= "Emmagatzemar imatges de mida natural amb marques d'aigua digitals al servidor?";
$pgv_lang["SAVE_WATERMARK_IMAGE_help"]	= "~#pgv_lang[SAVE_WATERMARK_IMAGE]#~<br /><br />Si el Tallafocs Multimèdia és activat, cal que les còpies d'imatges de mida natural amb marques d'aigua digitals siguin emmagatzemades al servidor?<br /><br />Si es marca <b>#pgv_lang[yes]#</b>, les imatges de mides natural apareixeran més de pressa a expenses de més requeriment d'espai de disc al servidor.";
$pgv_lang["DB_UTF8_COLLATION"]			= "Utilitza la base de dades per proporcionar confronmtació UTF-8";
$pgv_lang["DB_UTF8_COLLATION_help"]		= "Controla si el PhpGedView ha d'emprar les eines incorporades a la base de dades per classificar. Sol ser més ràpid emprar la base de dades per ordenar i filtar dades que fer-ho amb PHP, malgrat que no totes les bases de dades o versions ofereixen aquesta possibilitat. La seqüència d'ordenació per a cada idioma es fixa a la pàgina de paràmetres de l'idioma.<br /><br /><span class=\"warning\">IMPORTANT: Solament cal posar aquest valor a SÍ si ho feu ABANS de crear les taules de la base de dades per primer cop. Fer-ho amb una base de dades ja existent pot comportar la corrupció de llurs dades.</span><br /><br />MySQL proporciona bon suport per a UTF-8, malgrat que, en versions anteriors, no hi ha disponibles totes les seqüències de classificació. Altres bases de dades proporcionen poca o nul·la cobertura per a UTF-8. Si no esteu segur de la cobertura de la vostra base de dades, deixeu aquest valor a <b>#pgv_lang[no]#</b>.<br /><br />Aquest <a href='http://es.wikipedia.org/wiki/UTF-8' target='_blank' title='artícle de Wikipedia'><b>artícle de Wikipedia</b></a> conté completa informació i vincles sobre l'UTF-8.";
$pgv_lang["INDI_FACTS_ADD"] 			= "Addició d'esdeveniments personals";
$pgv_lang["INDI_FACTS_ADD_help"]		= "~#pgv_lang[INDI_FACTS_ADD]#~<br /><br />Aquesta és la llista d'esdeveniments GEDCOM que els vostres usuaris poden afegir a persones. Podeu modificar-la traient o afegint noms d'esdeveniments i fins i tot personalitzar-ne si cal. Els noms que surten aquí no han de figurar a la llista <i>#pgv_lang[INDI_FACTS_UNIQUE]#</i>.";
$pgv_lang["INDI_FACTS_UNIQUE"] 			= "Esdeveniments personals únics";
$pgv_lang["INDI_FACTS_UNIQUE_help"]		= "~#pgv_lang[INDI_FACTS_UNIQUE]#~<br /><br />Aquesta és la llista que els vostres usuaris poden afegir <u>un cop</u> a persones. Per exemple, si BIRT és en aquesta llista, els usuaris no poden afegir més d'un registre BIRT a una persona. Els noms d'esdeveniments que apareixen aquí no han de figurar a la llista <i>#pgv_lang[INDI_FACTS_ADD]#</i>.";
$pgv_lang["INDI_FACTS_QUICK"] 			= "Esdeveniments personals immediats";
$pgv_lang["INDI_FACTS_QUICK_help"]	= "~#pgv_lang[INDI_FACTS_QUICK]#~<br /><br />Aquesta és una breu llista d'esdeveniments de persones que surt al costat de la completa i que poden afegir-se amb un simple clic.";
$pgv_lang["FAM_FACTS_ADD"] 			= "Addició d'esdeveniments familiars";
$pgv_lang["FAM_FACTS_ADD_help"]		= "~#pgv_lang[FAM_FACTS_ADD]#~<br /><br />Aquesta és la llista dels esdeveniments GEDCOM que els vostres usuaris poden afegir a les famílies. Podeu modificar-la traient-ne o posant-ne i personalitzar-los si cal. Els noms que apareixen aquí no han de figurar a la llista  <i>#pgv_lang[FAM_FACTS_UNIQUE]#</i>.";
$pgv_lang["FAM_FACTS_UNIQUE"] 			= "Esdeveniments familiars únics";
$pgv_lang["FAM_FACTS_UNIQUE_help"]		= "~#pgv_lang[FAM_FACTS_UNIQUE]#~<br /><br />Aquesta és la llista d'esdeveniments  GEDCOM que els vostres usuaris poden afegir <u>un cop</u> a famílies. Per exemple, si MARR és a la llista, els usuaris no poden afegir més d'un registre MARR a la família. Els noms que apareixen en aquesta llista no han de figurar a la  <i>#pgv_lang[FAM_FACTS_ADD]#</i>.";
$pgv_lang["FAM_FACTS_QUICK"] 			= "Esdeveniments familiars immediats";
$pgv_lang["FAM_FACTS_QUICK_help"]	= "~#pgv_lang[FAM_FACTS_QUICK]#~<br /><br />Aquesta és una breu llista d'esdeveniments familiars GEDCOM que surt al costat de la completa i que poden afegir-se amb un simple clic.";
$pgv_lang["SOUR_FACTS_ADD"] 			= "Addició d'esdeveniments de fonts";
$pgv_lang["SOUR_FACTS_ADD_help"]		= "~#pgv_lang[SOUR_FACTS_ADD]#~<br /><br />Aquesta és la llista d'esdeveniments GEDCOM que els vostre usuaris poden afegir a les fonts. Podeu modificar-la afegint o traient noms d'esdeveniments, també personalitzar-ne, si cal. Els noms d'esdeveniments que surtin en aquesta llista no han de sortir a la <i>#pgv_lang[SOUR_FACTS_UNIQUE]#</i>.";
$pgv_lang["SOUR_FACTS_UNIQUE"] 			= "Esdeveniments de fonts únics";
$pgv_lang["SOUR_FACTS_UNIQUE_help"]		= "~#pgv_lang[SOUR_FACTS_UNIQUE]#~<br /><br />Aquesta és la llista d'esdeveniments GEDCOM que els vostres usuaris poden afegir <u>un sol cop</u> a les fonts. Per exemple, si TITL és a la llista, els usuaris no poden afegir més d'un camp TITL a la font. El noms d'esdeveniment d'aquesta llista no han de figurar a la <i>#pgv_lang[SOUR_FACTS_ADD]#</i>.";
$pgv_lang["SOUR_FACTS_QUICK"] 			= "Esdeveniments de fonts immediats";
$pgv_lang["SOUR_FACTS_QUICK_help"]	= "~#pgv_lang[SOUR_FACTS_QUICK]#~<br /><br />Aquesta és una llista breu d'esdeveniments de fonts del GEDCOM que surt al costat de la llista sencera i que poden escollir-se amb un simple clic.";
$pgv_lang["REPO_FACTS_ADD"] 			= "Addició d'esdeveniments d'arxius";
$pgv_lang["REPO_FACTS_ADD_help"]		= "~#pgv_lang[REPO_FACTS_ADD]#~<br /><br />Aquesta és la llista d'esdeveniments GEDCOM que els vostres usuaris poden afegir als arxius. Podeu modificar-la traient-ne o posant-ne i fins i tot personalitzant-ne, si cal. El noms que apareguin a aquesta llista no han de sortir a la  <i>#pgv_lang[REPO_FACTS_UNIQUE]#</i>.";
$pgv_lang["REPO_FACTS_UNIQUE"] 			= "Esdeveniments d'arxiu únics";
$pgv_lang["REPO_FACTS_UNIQUE_help"]		= "~#pgv_lang[REPO_FACTS_UNIQUE]#~<br /><br />Aquesta és la llista d'esdeveniments GEDCOM que els vostre usuaris poden afegir <u>un sol cop</u> als arxius. Per exemple, si NAME és a la llista, els usuaris no podem afegir més d'un camp NAME al registre de l'arxiu. Els noms d'esdeveniments que apareguin en aquesta llista no han de sortir a la <i>#pgv_lang[REPO_FACTS_ADD]#</i>.";
$pgv_lang["REPO_FACTS_QUICK"] 			= "Esdeveniments d'arxiu immediats";
$pgv_lang["REPO_FACTS_QUICK_help"]	= "~#pgv_lang[REPO_FACTS_QUICK]#~<br /><br />Aquesta és una breu llista d'esdeveniments GEDCOM d'arxiu que surt al costat de la complerta i que poden escollir-se amb un simple clic.";
$pgv_lang["LANG_SELECTION_help"]		= "~#pgv_lang[LANG_SELECTION]#~<br /><br />Podeu canviar la llista d'idiomes suportats pel vostre lloc PhpGedView afegint o traient marques com us plagui. Això canvia lles opcions d'elecció d'idiomes disponibles als usuaris.<br /><br />Podeu feu el mateix mitjançant l'enllaç <b>#pgv_lang[enable_disable_lang]#</b> al menú #pgv_lang[admin]#, on podeu també canviar-hi coses com la icona de bandera de l'idioma, el format de data o l'ordre de llistat de cognoms.";
$pgv_lang["MEDIA_ID_PREFIX"]		= "Prefix ID multimèdia";
$pgv_lang["MEDIA_ID_PREFIX_help"]	= "~#pgv_lang[MEDIA_ID_PREFIX]#~<br /><br />Quan s'afegeix en línea un registre multimèdia nou es genera automàticament un ID per a aquest registre. El nou ID tindrà aquest prefix.";
$pgv_lang["FAM_ID_PREFIX"]		= "Prefix ID de família";
$pgv_lang["FAM_ID_PREFIX_help"]	= "~#pgv_lang[FAM_ID_PREFIX]#~<br /><br />Quan s'afegeix en línea un nou registre de família a PhpGedView, es genera automàticament un ID per a ella. El nou ID tindrà aquest prefix.";
$pgv_lang["QUICK_REQUIRED_FAMFACTS"]			= "Esdeveniments de famílies a mostrar sempre en l'edició ràpida";
$pgv_lang["QUICK_REQUIRED_FAMFACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FAMFACTS]#~<br /><br />És una llista d'etiquetes d'esdeveniments GEDCOM, separades per comes, que sempre sortiran a la llista d'etiquetes del formulari d'edició ràpida, tant si ja existeixen com si no al registre de les persones. Per exemple, si MARR és a la llista, els camps de data i lloc de casament es mostraran sempre al formulari.";
$pgv_lang["QUICK_ADD_FAMFACTS"]			= "Esdeveniments de famílies a mostrar en l'edició ràpida";
$pgv_lang["QUICK_ADD_FAMFACTS_help"]		= "~#pgv_lang[QUICK_ADD_FAMFACTS]#~<br /><br />És una llista de les etiquetes d'esdeveniments GEDCOM, separades per comes, que sortiran a la llista d'etiquetes del formulari  d'edició ràpida. Solament es mostraran els esdeveniments d'aquesta llista o estaran disponibles per seleccionar-les a l'àrea del formulari on afegiu nous esdeveniments.";
$pgv_lang["QUICK_REQUIRED_FACTS"]			= "Esdeveniments a mostrar sempre en l'edició ràpida";
$pgv_lang["QUICK_REQUIRED_FACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FACTS]#~<br /><br />És una llista d'etiquetes d'esdeveniments GEDCOM, separada per comes, que sempre sortiran al formulari d'edició ràpida tant si ja existeixen com si no al registre individual. Per exemple, si BIRT és a la llista, els camps de data i lloc de naixement apareixeran sempre al formulari.";
$pgv_lang["QUICK_ADD_FACTS"]			= "Esdeveniments a mostrar en l'edició ràpida";
$pgv_lang["QUICK_ADD_FACTS_help"]		= "~#pgv_lang[QUICK_ADD_FACTS]#~<br /><br />És una llista d'etiquetes d'esdeveniments GEDCOM, separades per comes, que es mostraran al formulari d'edició ràpida. Solament es mostraran els esdeveniments de la llista al formulari o estaran disponibles per a seleccionar-los a l'àrea on afegiu nous esdeveniments.";
$pgv_lang["SURNAME_TRADITION_help"] = "~#pgv_lang[SURNAME_TRADITION]#~<br /><br />Quan afegiu nous membres a la família, el PhpGedView pot fornir-vos dades per defecte d'acord amb la tradició regional.<br /><br /><ul><li>A la tradició <b>Paterna</b> tots els membres de la família adopten el cognom del pare.</li><li>A la <b>Espanyola</b> i la <b>Portuguesa</b>, la mainada rep un cognom de cada progenitor.</li><li>A la <b>Islandesa</b>, la mainada rep com a cognom el nom de pila del pare, amb un sufix que denota el gènere.</li><li>Segons la tradició <b>polonesa</b>, tots els membres de la família comparteixen el cognom del pare. Per a alguns cognoms, el sufix indica gènere. Els sufixos <i>ski</i>, <i>cki</i>, i <i>dzki</i> indiquen masculí, mentre que els sufixos corresponents <i>ska</i>, <i>cka</i>, i <i>dzka</i> indiquen femení.</li></ul>";
$pgv_lang["ADVANCED_NAME_FACTS_help"] = "~#pgv_lang[ADVANCED_NAME_FACTS]#~<br /><br />És una llista d'etiquetes d'esdeveniments GEDCOM, separades per comes, que es mostrarà al formulari d'afegir/editar noms. Si empreu idiomes no llatins tals com l'Hebreu, Grec, Ciríl·lic o Aràbic potser us caldrà afegir etiquetes com _HEB, ROMN, FONE, etc. per a permetre-us emmagatzemar noms diversos alfabets.";
$pgv_lang["ADVANCED_PLAC_FACTS_help"] = "~#pgv_lang[ADVANCED_PLAC_FACTS]#~<br /><br />És una llista d'etiquetes d'esdeveniments GEDCOM que es mostrarà quan afegiu o editeu noms de llocs. Si empreu un alfabet no llatí tal com l'Hebreu, Grec, Cirí·lic o Aràbic, us caldrà afegir etiquetes com  _HEB, ROMN, FONE, etc. per poder emmagatzemar noms de llocs en els diferents alfabets.";
$pgv_lang["GEONAMES_KEY"]				= "geonames.org nom d'usuari";
$pgv_lang["GEONAMES_KEY_help"]			= "~#pgv_lang[GEONAMES_KEY]#~<br /><br />Aquest nom d'usuari és necessari per accedir a la base de dades gratuïta de noms geogràfics geonames.org. Si no proporcioneu un nom d'usuari vàlid, no podreu fer cerques en aquesta base de dades.<br /><br />Podeu sollicitar un nom d'usuari geonames.org a la <a href='http://www.geonames.org/login' target='_blank'><b>pàgina d'inici de sessió de geonames.org</b></a>.<br /><br /> Rebrà un correu electrònic amb un enllaç de confirmació i, després de confirmar-lo, podrà activar el seu compte per al servei web a la pàgina <a href='http://www.geonames.org/manageaccount' target='_blank'><b>el teu compte</b></a>.";
$pgv_lang["GEONAMES_BIAS"]				= "geonames.org biaix de país";
$pgv_lang["GEONAMES_BIAS_help"]			= "~#pgv_lang[GEONAMES_BIAS]#~<br /><br />Normalment, la cerca a la base de dades GeoNames presenta els seus resultats en ordre alfabètic sense tenir en compte el país on es troba un lloc. Aquesta opció especifica que els llocs situats al país seleccionat s'han d'informar a la part superior de la llista de resultats.";
$pgv_lang["GEONAMES_BIAS_no_preference"]= "Cap preferència";
$pgv_lang["GEOCODE_KEY"]				= "Clau del servidor de geocodi de Google";
$pgv_lang["GEOCODE_KEY_help"]			= "~#pgv_lang[GEOCODE_KEY]#~<br /><br />Aquesta clau és necessària per accedir a la base de dades gratuïta de noms geogràfics de Google. Si no proporcioneu una clau vàlida, no podreu fer cerques en aquesta base de dades.<br /><br />Podeu sol·licitar una clau mitjançant el vostre <a href='https://developers.google.com/maps/documentation/geocoding/get-api-key' target='_blank'><b>Google Developer Console</b></a>. Podeu veure aquesta pàgina en un idioma diferent de l’anglès triant l’idioma desitjat al final de la pàgina.";
$pgv_lang["AUTO_GENERATE_THUMBS"]			= "Genera miniatures automàticament";
$pgv_lang["AUTO_GENERATE_THUMBS_help"]		= "~#pgv_lang[AUTO_GENERATE_THUMBS]#~<br /><br />Cal que el sistema generi automàticament miniatures de les imatges que no en tinguin? La vostra instal·lació PHP podria no suportar aquesta funcionalitat.";
$pgv_lang["phpinfo_help"]				= "~#pgv_lang[phpinfo]#~<br /><br />Aquesta pàgina forneix àmplia informació sobre el servidor on teniu hostatjat el PhpGedView. S'hi poden veure alguns detalls sobre el programari del servidor com els relatius a PHP i PhpGedView.";
$pgv_lang["config_help_help"]			= "~#pgv_lang[config_help]#~<br /><br />Aquesta pàgina és un recull de la majoria de temes de l'ajuda de configuració d'un lloc. Podeu veure la informació per pantalla o imprimir-la per a ús posterior.";
$pgv_lang["more_help_advice"]			= "<b>Més ajuda</b><br />Disposeu de més ajuda polsant l'interrogant <b>#pgv_lang[qm]#</b> del costat dels ítems de la pàgina.";
$pgv_lang["THUMBNAIL_WIDTH"]			= "Amplada de les miniatures generades";
$pgv_lang["THUMBNAIL_WIDTH_help"]		= "~#pgv_lang[THUMBNAIL_WIDTH]#~<br /><br />És l'amplada (en píxels) que el programa farà servir quan generi les miniatures automàticament. Es paràmetre per defecte és 100.";
$pgv_lang["USE_SILHOUETTE"]				= "Utilitzeu siluetes";
$pgv_lang["USE_SILHOUETTE_help"]		= "~#pgv_lang[USE_SILHOUETTE]#~<br /><br />Utilitzeu imatges de silueta quan no s'hagi especificat cap imatge ressaltada per a aquesta persona. Les imatges utilitzades són específiques del gènere de la persona en qüestió.<br /><br /><table><tr><td wrap valign=\"middle\">Aquesta imatge es pot utilitzar quan es desconeix el gènere de la persona: </td><td><img src=\"images/silhouette_unknown.gif\" width=\"40\" alt=\"Silhouette image\" title=\"Silhouette image\" /></td></tr></table>";
$pgv_lang["SHOW_SOURCES"]			= "Mostra fonts";
$pgv_lang["SHOW_SOURCES_help"]		= "~#pgv_lang[SHOW_SOURCES]#~<br /><br />Determina el nivell de privadesa d'accés per a totes les fonts. Si l'usuari no ha de tenir accés a les fonts, aquesta desapareixerà de les del menú i la pestanya de fonts tampoc apareixerà a la pàgina <i>#pgv_lang[personal_details]#</i>.";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION_help"]	= "~#pgv_lang[REQUIRE_ADMIN_AUTH_REGISTRATION]#~<br /><br />Si hi ha activada l'opció <b>#pgv_lang[USE_REGISTRATION_MODULE]#</b> aquest paràmetre controla  si l'administrador ha d'autoritzar el registre.<br /><br />Posant-ho a <b>#pgv_lang[yes]#</b> fa que qualsevol nou usuari, abans de disposar d'accés, primer s'hagi d'autoverificar i desprès ésser autoritzat per un administrador. Amb aquest paràmetre a <b>#pgv_lang[no]#</b>, el caixetí <b>#pgv_lang[verified_by_admin]#</b> es marca automàticament quan un usuari confirma o verifica el seu compte, permetent la connexió immediata sense la intervenció de l'administrador.";
$pgv_lang["SPLIT_PLACES"]		= "Subdivideix els llocs en el mode d'edició";
$pgv_lang["SPLIT_PLACES_help"]	= "~#pgv_lang[SPLIT_PLACES]#~<br /><br />Poseu-ho a  <b>#pgv_lang[yes]#</b> per dividir les comes dels noms de lloc en sotscamps separats, per fer l'edició més fàcil. Exemple :<br /><ol><li>Mode per defecte<br /><u>Lloc</u>: Half Moon Bay, San Mateo, California, USA</li><br /><li>Mode dividit<br /><u>País</u>: USA<br /><u>Estat</u>: California<br /><u>Comtat</u>: San Mateo<br /><u>Ciutat</u>: Half Moon Bay</li></ol>";
$pgv_lang["UNDERLINE_NAME_QUOTES"]		= "Noms subratllats entre cometes";
$pgv_lang["UNDERLINE_NAME_QUOTES_help"]	= "~#pgv_lang[UNDERLINE_NAME_QUOTES]#~<br /><br />Alguns programes posen el nom de pila principal entre cometes (<b>\"</b>) al GEDCOM. La convenció usual per això és subratllar-lo. Activant aquesta opció es convertiran tots els noms entre cometes a <span> amb una classe CSS de \"nom ressaltat\".<br /><br />Per exemple, si el nom al GEDCOM fos 1&nbsp;NAME&nbsp;Gustave&nbsp;\"Jean&nbsp;Paul\"&nbsp;Charles&nbsp;/Wilson/ activant aquesta opció canviarà la part del nom inclosa dins les cometes a <span&nbsp;class=\"starredname\">Jean&nbsp;Paul</span> pel que fa a la impressió. Depenent d'altres paràmetres, el navegador també pot mostrar el nom com <b>Gustave&nbsp;<u>Jean&nbsp;Paul</u>&nbsp;Charles&nbsp;Wilson</b> o <b>Wilson,&nbsp;Gustave&nbsp;<u>Jean&nbsp;Paul</u>&nbsp;Charles</b>";
$pgv_lang["PRIVACY_BY_RESN"]		= "Empra la restricció de privadesa GEDCOM (RESN)";
$pgv_lang["PRIVACY_BY_RESN_help"]	= "~#pgv_lang[PRIVACY_BY_RESN]#~<br /><br />La especificació GEDCOM 5.5.1 inclou l'opció d'emprar etiquetes RESN per a fixar opcions de privadesa per a persones i esdeveniments al fitxer GEDCOM. Activant aquesta opció fa que el programa cerqui el nivell 1 de les etiquetes RESN als registres GEDCOM records. El nivell 2+ d'etiquetes s'aplica automàticament i no és afectat per aquest paràmetre. Noteu que això pot alentir algunes funcions del PhpGedView com els llistats de persones.";
$pgv_lang["SHOW_LDS_AT_GLANCE"]			= "Mostra els codis d’ordenança de l’església SUD als quadres gràfics";
$pgv_lang["SHOW_LDS_AT_GLANCE_help"]	= "~#pgv_lang[SHOW_LDS_AT_GLANCE]#~<br /><br />Posant aquest paràmetre a <b>#pgv_lang[yes]#</b> es mostrarà l'estatus dels codis rituals SUD, als caixetins dels gràfics.<ul><li><b>B</b> - Bateig</li><li><b>E</b> - Dot (per Endowed)</li><li><b>S</b> - Segellament al cònjuge</li><li><b>P</b> - Segellament als Pares</li></ul>Una persona que disposi de tots els rituals tindrà <b>BESP</b> imprès desprès del seu nom. Els rituals pendents s'indiquen amb <b>_</b> en lloc de la seva corresponent lletra de codi. Per exemple, <b>BE__</b> indica com a pendents els rituals <b>S</b> i <b>P</b>.";
$pgv_lang["GEDCOM_DEFAULT_TAB"]			= "Apèndix per defecte a mostrar a la pàgina «Dades personals#»";
$pgv_lang["GEDCOM_DEFAULT_TAB_help"]	= "~#pgv_lang[GEDCOM_DEFAULT_TAB]#~<br /><br />Aquesta opció us permet quin apèndix de la pàgina «Dades personals#» s'obrirà automàticament quan s'hi accedeixi.";
$pgv_lang["SHOW_MARRIED_NAMES"]			= "Mostra els noms de casada a la llista de persones";
$pgv_lang["SHOW_MARRIED_NAMES_help"]	= "~#pgv_lang[SHOW_MARRIED_NAMES]#~<br /><br />Aquesta opció farà que es mostrin els noms de casada de les dones a la llista de persones. Requereix però que hagueu calculat aquests noms al importar el fitxer GEDCOM file.";
$pgv_lang["SHOW_QUICK_RESN"]		= "Mostra el camps de privadesa al formulari #pgv_lang[quick_update_title]#";
$pgv_lang["SHOW_QUICK_RESN_help"]		= "~#pgv_lang[SHOW_QUICK_RESN]#~<br /><br />Aquesta opció us permet activar o desactivar els camps de privadesa al formulari #pgv_lang[quick_update_title]#. Els camps de privadesa permeten a l'usuari que entre informació mitjançant el formulari, saltar-se el nivell de privadesa per defecte de l'esdeveniment que estigui entrant.";
$pgv_lang["USE_QUICK_UPDATE"]		= "Empra el formulari #pgv_lang[quick_update_title]#";
$pgv_lang["USE_QUICK_UPDATE_help"]		= "~#pgv_lang[USE_QUICK_UPDATE]#~<br /><br />Aquesta opció determina els atributs d'usuari necessaris per autoritzar canvis mitjançant el formulari #pgv_lang[quick_update_title]#.<br /><br />L'elecció <b>#pgv_lang[nobody]#</b> fa que aquest formulari no el pugui emprar ningú.";
$pgv_lang["SEARCHLOG_CREATE"]		= "Arxiva els fitxers de registre de recerca";
$pgv_lang["SEARCHLOG_CREATE_help"]	= "~#pgv_lang[SEARCHLOG_CREATE]#~<br /><br />Freqüència amb la que el programa ha d'arxivar els fitxers de registre de recerca.";
$pgv_lang["CHANGELOG_CREATE"]		= "Arxiva els fitxers ChangeLog";
$pgv_lang["CHANGELOG_CREATE_help"]	= "~#pgv_lang[CHANGELOG_CREATE]#~<br /><br />Freqüència amb la que el programa ha d'arxivar els fitxers Changelog.";
$pgv_lang["CHART_BOX_TAGS"]		= "Altres esdeveniments a mostrar als gràfics";
$pgv_lang["CHART_BOX_TAGS_help"]		= "~#pgv_lang[CHART_BOX_TAGS]#~<br /><br />Aquesta ha d'ésser una llista d'esdeveniments, separats per una coma o un espai, afegida als de Naixement i Defunció, que voleu que apareguin als caixetins dels gràfics com l'arbre genealògic. Aquesta llista requereix que empreu etiquetes d'esdeveniments tal i com s'han definit a l'estàndard GEDCOM 5.5.1. Per exemple, si voleu que es mostri la professió, heu de posar  «OCCU» en aquest camp.";
$pgv_lang["FULL_SOURCES"]		= "Empra citacions de font completes";
$pgv_lang["FULL_SOURCES_help"]		= "~#pgv_lang[FULL_SOURCES]#~<br /><br /> Les citacions de font poden incloure camps per deixar constància de la qualitat de les dades (primària, secundària, etc) i la data en què l'esdeveniment es va enregistrar a la font. Si no empreu aquests camps, podeu inhabilitar-los quan creeu noves citacions de font. ";
$pgv_lang["PREFER_LEVEL2_SOURCES"]		= "Tipus de font";
$pgv_lang["PREFER_LEVEL2_SOURCES_help"]		= "~#pgv_lang[PREFER_LEVEL2_SOURCES]#~<br /><br /> Quan afegiu nous parents propers, podeu afegir citacions de font als registres (per exemple, INDI, FAM) o als esdeveniments (BIRT, MARR, DEAT). Aquesta opció controla les caselles que estan marcades per defecte. ";


//-- CONFIGURE FILE MESSAGES
$pgv_lang["gedcom_conf"]		= "Camps GEDCOM bàsics";
$pgv_lang["media_conf"]			= "Multimèdia";
$pgv_lang["media_general_conf"]	= "General";
$pgv_lang["media_firewall_conf"]	= "Tallafoc Multimèdia";
$pgv_lang["accpriv_conf"]		= "Accés i privadesa";
$pgv_lang["displ_conf"]			= "Desplegament, Disposició, i Informes";
$pgv_lang["displ_names_conf"]	= "Noms";
$pgv_lang["displ_comsurn_conf"] = "Cognoms habituals";
$pgv_lang["displ_layout_conf"]	= "Disposició";
$pgv_lang["displ_hide_conf"]	= "Amagar i mostrar";
$pgv_lang["displ_reports"]		= "Informes";
$pgv_lang["editopt_conf"]		= "Opcions d'edició";
$pgv_lang["contact_conf"]		= "Informació de contacte";
$pgv_lang["useropt_conf"]		= "Opcions d'usuari";
$pgv_lang["meta_conf"]			= "Paràmetres del lloc web i etiquetes META ";
$pgv_lang["gedconf_head"]		= "Configuració del GEDCOM";
$pgv_lang["other_theme"]		= "Un altre, escriviu si us plau";
$pgv_lang["performing_update"]	= "Modificant.";
$pgv_lang["config_file_read"]		= "S'ha llegit el fitxer config.";
$pgv_lang["does_not_exist"]		= "no hi és";
$pgv_lang["media_drive_letter"]		= "El camí al directori Mèdia no ha de contenir la lletra del disc. Els fitxers no es veurien.";
$pgv_lang["db_setup_bad"]		= "La vostra configuració actual de la base de dades és incorrecta.  Repasseu la connexió a la base de dades i configureu de nou.";
$pgv_lang["bad_host_user_pass"]		= "PhpGedView no pot iniciar la connexió amb l'amfitrió de la base de dades MySQL. Reviseu a l'amfitrió que el nom d'usuari i la contrasenya siguin els correctes.";
$pgv_lang["bad_database_name"]		= "PhpGedView intenta la connexió amb la base de dades de l'amfitrió però és impossible emprar-la amb el nom que heu entrat. Comproveu que la base de dades existeixi i que el nom d'usuari que entreu hi disposi del permisos apropiats.";
$pgv_lang["db"]				= "Base de dades";
$pgv_lang["current_gedcoms"]		= "Gedcoms disponibles";
$pgv_lang["ged_gedcom"]			= "Arxiu Gedcom";
$pgv_lang["ged_title"]			= "Títol del Gedcom";
$pgv_lang["ged_config"]			= "Arxiu de Configuració";
$pgv_lang["ged_search"]			= "Fitxers SearchLog";
$pgv_lang["ged_change"]			= "Fitxers ChangeLog";
$pgv_lang["ged_privacy"]		= "Fitxer de privadesa";
$pgv_lang["disabled"]			= "Desactivat";
$pgv_lang["mouseover"]			= "Passant el ratolí per sobre";
$pgv_lang["mousedown"]			= "Mantenint polsat el ratolí";
$pgv_lang["click"]			= "Polsant el ratolí";
$pgv_lang["enter_db_pass"]		= "Per seguretat, heu d'entrar el Nom d'Usuari de la Base de Dades i la contrasenya abans de canviar els valors de configuraci&oacute;";
$pgv_lang["server_url_note"]	= "A d'ésser l'URL per la vostra carpeta PhpGedView. Canvieu solament aquest paràmetre si esteu ben segur del que feu. PhpGedView ha determinat que aquest valor ha d'ésser <b>#GUESS_URL#</b>";

$pgv_lang["DBTYPE"]			= "Tipus de base de dades";
$pgv_lang["DBTYPE_help"]		= "~#pgv_lang[DBTYPE]#~<br /><br />El tipus de base de dades a la qual us heu de connectar.<br /><br />PhpGedView pot utilitzar qualsevol base de dades que tingui disponible un controlador PDO. Heu d’assegurar-vos que el fitxer php.ini carrega tant la biblioteca <b>php_pdo</b> com el controlador adequat per a la vostra base de dades, per exemple, <b>php_pdo_mysql</b>.<br /><br />La majoria de bases de dades requereixen un nom d'usuari i una contrasenya. També heu de crear la base de dades abans d’instal·lar PhpGedView. Tot i això, SQLite no necessita #pgv_lang[DBHOST]#, #pgv_lang[DBUSER]#, o #pgv_lang[DBPASS]#, però haureu d’establir un camí d’arxiu per a la vostra base de dades al camp #pgv_lang[DBNAME]#. PhpGedView us crearà el fitxer de base de dades SQLite.";
$pgv_lang["DBHOST"] 			= "Amfitrió de la base de dades";
$pgv_lang["DBHOST_help"] 		= "~#pgv_lang[DBHOST]#~<br /><br />El DNS o adreça IP de l'ordinador amfitrió que hostatja el servidor de base de dades. Aquest paràmetre s'ignorarà si esteu emprant una base de dades SQLite.";
$pgv_lang["DBPORT"]			= "Port de la base de dades";
$pgv_lang["DBPORT_help"]		= "~#pgv_lang[DBPORT]#~<br /><br /> El port TCP que s'ha d'utilitzar per connectar amb el vostre servidor de Base de Dades. Deixeu aquesta opció en blanc per utilitzar el port predeterminat per al seu tipus particular de la base de dades. Aquest valor s'ignora si esteu utilitzant una base de dades SQLite. ";
$pgv_lang["DBUSER"] 			= "Nom d'usuari de la base de dades";
$pgv_lang["DBUSER_help"] 		= "~#pgv_lang[DBUSER]#~<br /><br />Nom d'usuari de la base de dades que cal per connectar-s'hi. Aquest paràmetre s'ignorarà si esteu emprant una base de dades SQLite.";
$pgv_lang["DBPASS"] 			= "Contrasenya de la base de dades";
$pgv_lang["DBPASS_help"] 		= "~#pgv_lang[DBPASS]#~<br /><br />La contrasenya per a l'usuari que heu entrat al camp #pgv_lang[DBUSER]#. Aquest paràmetre serà ignorat si esteu emprant una base de dades SQLite.";
$pgv_lang["DBNAME"] 			= "Nom de la Base de Dades:";
$pgv_lang["DBNAME_help"] 		= "~#pgv_lang[DBNAME]#~<br /><br />La base de dades al servidor que voleu que PhpGedView faci servir.<br /><br />L'usuari que entreu al camp #pgv_lang[DBUSER]# cal que disposi de privilegis per Crear, Inserir, Actualitzar, Esborrar i Seleccionar en aquesta base de dades. Amb SQLite us cal configurar això en un nom de fitxer en un directori que on pugui escriure-hi el PHP com el directori índex (index/phpgedview.db).";
$pgv_lang["TBLPREFIX_help"] 		= "~#pgv_lang[TBLPREFIX]#~<br /><br />Un prefix als noms de les taules creades per PhpGedView. Canviant aquest valor podeu configurar múltiples llocs PhpGedView per a emprar físicament la mateixa base de dades però diferents taules. Per exemple, el mateix lloc pot hostatjar una instal·lació \"test\" i també una \"production\" de PhpGedView amb taules de dades completament independents.";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"] = "~#pgv_lang[ALLOW_CHANGE_GEDCOM]#~<br /><br />Si teniu un entorn amb múltiples GEDCOMs, posant aquest valor a  <b>#pgv_lang[yes]#</b> permeteu als visitants del vostre lloc <u>i</u> als usuaris de canviar-se de GEDCOMs. Posant-lo a <b>#pgv_lang[no]#</b> desactiveu el canvi entre un GEDCOM a un altre tant per als visitants  <u>com pels</u> usuaris amb accés.";
$pgv_lang["upload_path"]			= "Camí de càrrega";
$pgv_lang["upload_path_help"]		= "~#pgv_lang[upload_path]#~<br /><br />És el camí on pot localitzar-se el fitxer GEDCOM que voleu carregar. Per seleccionar el camí, polseu a <b>Cercar</b> i navegueu fins al vostre fitxer GEDCOM i llavors polseu <b>Obrir</b>.";
$pgv_lang["gedcom_path"]			= "Camí i nom del GEDCOM al servidor";
$pgv_lang["gedcom_path_help"] 	= "~#pgv_lang[gedcom_path]#~<br /><br />Hi ha dues maneres d'importar el vostre fitxer GEDCOM al PhpGedView. Son:<ol><li>FTP del fitxer al servidor</li><li>Càrrega mitjançant el PhpGedView</li></ol>Quan el fitxer ja existeix prèviament al servidor crideu el procediment  <i>#pgv_lang[add_gedcom]#</i> i ompliu el camí i el nom del vostre GEDCOM tal i com estigui prèviament al servidor. El nom pot ésser amb o sense extensió. Si no hi poseu extensió s'assumirà que és  .ged. El camí  és opcional. Si no n'hi poseu prendrà el valor de <i>#pgv_lang[INDEX_DIRECTORY]#</i> tal i com teniu definit a la configuració del lloc del vostre PhpGedView. Tingueu en compte que a molts servidors el camí i el nom es distingeix entre majúscules i minúscules.<br /><br />Quan crideu el procediment <i>#pgv_lang[upload_gedcom]#</i> incorporat dins de PhpGedView, podeu fer servir el botó <b>Cerca</b> per a localitzar al vostre ordinador el fitxer que us cal. Pot ésser un fitxer GEDCOM normal o un ZIP contenint-lo. El PhpGedView l'extraurà automàticament.<br /><br />Quan carregeu un fitxer és possible especificar un camí alternatiu i/o nom de fitxer per a desar-lo al servidor.<br /><br />Mireu-vos el fitxer <a href=\"readme.txt\">Readme.txt</a> per a més informació.";
$pgv_lang["CHARACTER_SET"] 		= "Codificació del joc de caràcters";
$pgv_lang["CHARACTER_SET_help"] 	= "~#pgv_lang[CHARACTER_SET]#~<br /><br />És el joc de caràcters del vostre fitxer GEDCOM. Per defecte és UTF-8 i és compatible a la majoria de llocs. Si exporteu el vostre GEDCOM emprant codificació IBM Windows, heu de posar WINDOWS aquí.<br /><br />NOTA: PhpGedView no suporta UNICODE (UTF-16) perquè no es contempla en PHP.";
$pgv_lang["LANGUAGE"] 			= "Idioma";
$pgv_lang["LANGUAGE_help"] 		= "~#pgv_lang[LANGUAGE]#~<br /><br />Assigna l'idioma per defecte del lloc.<br /><br />Quan hi ha activada la opció <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b>, els usuaris poden saltar-se aquest paràmetre mitjançant la configuració de l'idioma preferit al seu navegador, les opcions de configuració de la seva pàgina de compte o mitjançant enllaços i botons que trobaran a la majoria de pàgines del PhpGedView.";
$pgv_lang["ENABLE_MULTI_LANGUAGE"] 			= "Permetre als usuaris escollir l'idioma";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"] 		= "~#pgv_lang[ENABLE_MULTI_LANGUAGE]#~<br /><br />Posant-ho a <b>#pgv_lang[yes]#</b> permetreu als usuaris canviar l'idioma per defecte del lloc. Poden fer-ho mitjançant l'idioma preferit configurat al seu navegador, les opcions de configuració de la seva pàgina de compte o mitjançant enllaços i botons que hi ha a la majoria de pàgines del PhpGedView.";
$pgv_lang["CALENDAR_FORMAT"] 				= "Format del calendari";
$pgv_lang["CALENDAR_FORMAT_help"] 			= "~#pgv_lang[CALENDAR_FORMAT]#~<br /><br />Les dates poden enregistrar-se en diversos formats de calendari com el Gregorià, Julià o el Jueu. Aquesta opció us permet convertir-les al format de calendari preferit. Per exemple, podeu seleccionar Gregorià per convertir dates julianes o jueves a gregorianes. La data convertida es mostrarà entre parèntesi desprès de la regular.<br /><br />Solament es convertiran si tenen un valor vàlid del calendari. Per exemple, solament podran convertir-se les dates entre el 22&nbsp;SET&nbsp;1792 i el  31&nbsp;DES&nbsp;1805 al calendari Republicà Francès i solament dates posteriors al 15&nbsp;OCT&nbsp;1582 poden convertir-se al calendari Gregori.<br /><br />L'Hebreu és el mateix que el Jueu, però empre caràcters hebreus. L'Aràbic és el mateix que el Hijri, però amb caràcters aràbics.<br /><br />Nota: Atès que els calendaris Jueu i Hijri comencen el dia al capvespre, qualsevol esdeveniment que tingui lloc entre el capvespre i la mitjanit es mostrarà un ocorregut un dia abans de la data correcta. La presentació en Hebreu i Aràbic pot resultar problemàtica en navegadors antics que solament admetin text d'esquerra a dreta.";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"] 		= "Mostra milers jueus";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"] 	= "~#pgv_lang[DISPLAY_JEWISH_THOUSANDS]#~<br /><br />Mostra Alafim als calendaris hebreus.<br /><br />Posant-ho a <b>#pgv_lang[yes]#</b> l'any 1969 es mostrarà com <span lang=\"he-IL\" dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; metre que si es posa a <b>#pgv_lang[no]#</b> es mostrarà com <span lang=\"he-IL\" dir='rtl'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;. Això no afecte al paràmetre de l'any jueu. L'any es mostrarà com a 5729 independentment d'aquest paràmetre.<br /><br />Nota: És equivalent a la constant de Calendari CAL_JEWISH_ADD_ALAFIM.";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]		= "Mostra el Gereshayim hebreu";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"]	= "~#pgv_lang[DISPLAY_JEWISH_GERESHAYIM]#~<br /><br />Mostra simples i dobles cometes («'» i «\"») quan es presentin dates hebrees.<br /><br />Posant-ho a <b>#pgv_lang[yes]#</b> presentarà el 8 de febrer de 1969 com a <span lang='he-IL' dir='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; en canvi si es posa a <b>#pgv_lang[no]#</b> apareixerà com <span lang='he-IL' dir='rtl'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;. Això no afecta al paràmetre de l'any jueu doncs les cometes no s'empren per les dates jueves presentades amb caràcters llatins.<br /><br />Nota: Aquest paràmetre és semblant a lles constant de Calendari  CAL_JEWISH_ADD_ALAFIM_GERESH i CAL_JEWISH_ADD_GERESHAYIM. Aquest únic paràmetre les afecta a totes dues.";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"] 	= "Pronunciació jueva Ashkenazi:";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"] = "~#pgv_lang[JEWISH_ASHKENAZ_PRONUNCIATION]#~<br /><br />Posant-ho a <b>#pgv_lang[yes]#</b> s'empraran els mesos Cheshvan i Teves de pronunciació Ashkenazi. Mentre que si es posa a <b>#pgv_lang[no]#</b> canviaran a Hesvan i Tevet. Solament afecta a la configuració jueva. La configuració hebrea utilitza sempre l'alfabet hebreu.";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"] 	= "Nombre de generacions d'avantpassats";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"] 	= "~#pgv_lang[DEFAULT_PEDIGREE_GENERATIONS]#~<br /><br />Ajusta el nombre de generacions que, per defecte, es mostraran a l'arbre genealògic i al diagrama descendents.";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"] 		= "Nombre màxim de generacions d'avantpassats";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"] 	= "~#pgv_lang[MAX_PEDIGREE_GENERATIONS]#~<br /><br />Fixa el nombre màxim de generacions a mostrar a l'arbre genealògic.";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"] 		= "Nombre màxim de generacions de descendents";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"] 	= "~#pgv_lang[MAX_DESCENDANCY_GENERATIONS]#~<br /><br />Fixa el nombre màxim de generacions a mostrar al gràfic de descendents.";
$pgv_lang["SOSA_WIDTH_NORMAL"]		= "Amplada normal dels números SOSA";
$pgv_lang["SOSA_WIDTH_NORMAL_help"]	= "~#pgv_lang[SOSA_WIDTH_NORMAL]#~<br /><br />La quantitat d'espai que s'ha de reservar per als números SOSA als gràfics<br /><br /><b>#pgv_lang[variable]#</b> indica que l'amplada no està fixa i que el número SOSA imprès ocuparà tant espai segons sigui necessari. La resta del gràfic es posicionarà en conseqüència.";
$pgv_lang["SOSA_WIDTH_WIDE"]		= "Amplada addicional dels números SOSA";
$pgv_lang["SOSA_WIDTH_WIDE_help"]	= "~#pgv_lang[SOSA_WIDTH_WIDE]#~<br /><br />La quantitat d’espai que s’ha de reservar per als números SOSA a la vista Fulletó del gràfic de descendència<br /><br /><b>#pgv_lang[variable]#</b> indica que l'amplada no està fixa i que el número SOSA imprès ocuparà tant espai segons sigui necessari. La resta del gràfic es posicionarà en conseqüència.";
$pgv_lang["USE_RIN"] 					= "Emprar el RIN# en lloc de l'ID del GEDCOM:";
$pgv_lang["USE_RIN_help"] 				= "~#pgv_lang[USE_RIN]#~<br /><br />Poseu-ho a <b>#pgv_lang[yes]#</b> per fer servir el número RIN per comptes del número d'ID del GEDCOM ID quan es demani per ID personals als fitxers de configuració, paràmetres d'usuari i gràfics. És útil per a programes genealògics que a les exportacions no respecten l'ID assignat a cada persona però que si que conserven llur RIN.";
$pgv_lang["GENERATE_GUID"]		= "Crea automàticament ID globals únics";
$pgv_lang["GENERATE_GUID_help"]	= "~#pgv_lang[GENERATE_GUID]#~<br /><br /><b>GUID</b> és en aquest context l'acrònim de «Globally Unique ID».<br /><br />El GUID va proposar-se per ajudar a identificar cada persona de forma que sigui repetible tant per organitzacions centrals com el Family History Center de l'església SUD a Salt Lake City, com compatible amb programes que funcionin al vostre servidor, per determinar si es tracta de la mateixa persona. L'avantatge del  Family History Center és disposar d'un arxiu central de dades genealògiques i facilitar-ne l'accés mitjançant serveis web. Això permet a qualsevol programa accedir a aquestes dades i actualitzar les seves.<br /><br />Si no penseu compartir el vostre GEDCOM amb ningú més no us cal que el PhpGedView creï aquests GUIDs; solament aconseguireu incrementar el volum del vostre GEDCOM.";
$pgv_lang["PEDIGREE_ROOT_ID"] 			= "Persona arrel a l'arbre genealògic i de descendents";
$pgv_lang["PEDIGREE_ROOT_ID_help"] 			= "~#pgv_lang[PEDIGREE_ROOT_ID]#~<br /><br />Fixa l'ID de la persona arrel per defecte a l'arbre genealògic i gràfic de descendents.";
$pgv_lang["GEDCOM_ID_PREFIX"]				= "Prefix de l'ID personal";
$pgv_lang["GEDCOM_ID_PREFIX_help"]			= "~#pgv_lang[GEDCOM_ID_PREFIX]#~<br /><br />Quan s'afegeix en línea un nou registre de persona al PhpGedView, es genera automàticament per a ella un nou ID. Aquest nou ID personal portarà aquell prefix.";
$pgv_lang["SOURCE_ID_PREFIX"]		= "Prefix de l'ID de fonts";
$pgv_lang["SOURCE_ID_PREFIX_help"]	= "~#pgv_lang[SOURCE_ID_PREFIX]#~<br /><br />Quan s'afegeix en línea un nou registre de font al PhpGedView, es genera automàticament un nou ID per a ella. Aquest nou ID de font portarà aquell prefix.";
$pgv_lang["REPO_ID_PREFIX"]		= "Prefix de l'ID d'arxius";
$pgv_lang["REPO_ID_PREFIX_help"]	= "~#pgv_lang[REPO_ID_PREFIX]#~<br /><br />Quan s'afegeix en línea un nou registre d'arxiu al PhpGedView, es genera automàticament un nou ID per a ell. Aquest nou ID d'arxiu portarà aquell prefix.";
$pgv_lang["PEDIGREE_FULL_DETAILS"] 			= "Mostra detalls de naixement i defunció als gràfics";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"] 		= "~#pgv_lang[PEDIGREE_FULL_DETAILS]#~<br /><br />Aquest paràmetre controla si es mostren o no els detalls de naixement i defunció als diagrames de persones.";
$pgv_lang["PEDIGREE_SHOW_GENDER"]	= "Mostra la icona de gènere als gràfics";
$pgv_lang["PEDIGREE_SHOW_GENDER_help"]	= "~#pgv_lang[PEDIGREE_SHOW_GENDER]#~<br /><br />Aquesta opció controla si es mostra o no la icona del gènere (sexe) de les persones als gràfics.<br /><br />Atès que el gènere també s'indica mitjançant el color dels caixetins aqueta opció no fa que s'amagui aquesta dada, senzillament estalvia informació duplicada al caixetí.";
$pgv_lang["PEDIGREE_LAYOUT"]				= "Format (per defecte) de sortida de l'arbre genealògic";
$pgv_lang["PEDIGREE_LAYOUT_help"]			= "~#pgv_lang[PEDIGREE_LAYOUT]#~<br /><br />Aquesta opció fixa si l'arbre genealògic es presentarà (per defecte) plantat o apaïsat.";
$pgv_lang["SHOW_EMPTY_BOXES"] 			= "Mostrar caixetins buits en Avantpassats:";
$pgv_lang["SHOW_EMPTY_BOXES_help"]	= "~#pgv_lang[SHOW_EMPTY_BOXES]#~<br /><br />Aquesta opció controla si es mostren o no caixetins buits a l'arbre genealògic.";
$pgv_lang["ZOOM_BOXES"]					= "Ampliar els caixetins dels diagrames";
$pgv_lang["ZOOM_BOXES_help"]				= "~#pgv_lang[ZOOM_BOXES]#~<br /><br />Permet a l'usuari ampliar els caixetins dels diagrames per veure més informació.<br /><br />Poseu-ho a <b>#pgv_lang[disabled]#</b> per desactivar aquesta opció. Poseu-ho a <b>#pgv_lang[mouseover]#</b> per ampliar-los en passar el punter del ratolí per sobre la icona del caixetí. Poseu-ho a <b>#pgv_lang[click]#</b> per ampliar-los quan l'usuari la polsi (clic).";
$pgv_lang["LINK_ICONS"]					= "Finestres d'enllaç als diagrames:";
$pgv_lang["LINK_ICONS_help"]				= "~#pgv_lang[LINK_ICONS]#~<br /><br />Permet a l'usuari seleccionar enllaços a altres gràfics i parents directes de la persona.<br /><br />Poseu-ho a <b>#pgv_lang[disabled]#</b> per desactivar aquesta opció. Poseu-ho a <b>#pgv_lang[mouseover]#</b> per obrir l'enllaç en una nova finestra quan passi el punter del ratolí per sobra la icona del caixetí. Poseu-ho a  <b>#pgv_lang[click]#</b> per obrir-lo quan polsi (clic) la icona.";
$pgv_lang["ABBREVIATE_CHART_LABELS"]			= "Etiquetes de gràfics abreujades";
$pgv_lang["ABBREVIATE_CHART_LABELS_help"]		= "~#pgv_lang[ABBREVIATE_CHART_LABELS]#~<br /><br />Aquesta opció controla si abreuja o no als gràfics etiquetes com <b>Naixement</b> amb la inicial, com per exemple <b>N</b>.<br /><br />Podeu personalitzar els abreujaments fornint els valors que calgui al fitxer <i>languages/extra.xx.php</i> per a cada idioma. Per exemple, si voleu fer servir <b>#</b> per comptes de <b>N</b> per abreujar l'esdeveniment NAIXEMENT en idioma català, heu de posar aquesta entrada al fitxer <i>languages/extra.ca.php</i>:<br /><code>\$factAbbrev[\"BIRT\"]&nbsp;=&nbsp;\"#\";</code><br /><br />No cal limitar-ho a un sol caràcter.";
$pgv_lang["SHOW_AGE_DIFF"]			= "Mostra diferència entre dates";
$pgv_lang["SHOW_AGE_DIFF_help"]		= "~#pgv_lang[SHOW_AGE_DIFF]#~<br /><br />Aquesta opció controla si la pestanya de parents directes mostra o no la diferència entre dates de naixement del cònjuges, entre casament i data de naixement del primer fill i entre dates de naixement de la mainada.";
$pgv_lang["SHOW_PARENTS_AGE"]			= "Mostra l'edat dels pares al costat de la data de naixement de la mainada";
$pgv_lang["SHOW_PARENTS_AGE_help"]		= "~#pgv_lang[SHOW_PARENTS_AGE]#~<br /><br />Aquesta opció controla si es mostra als gràfics o no, l'edat dels pares al costat de la data de naixement de llurs fills..";
$pgv_lang["SHOW_RELATIVES_EVENTS"]      = "Mostra els esdeveniments dels parents directes a la pàgina «Dades personals»";
$pgv_lang["SHOW_RELATIVES_EVENTS_help"] = "~#pgv_lang[SHOW_RELATIVES_EVENTS]#~<br /><br />Els naixements, casaments i defuncions dels parents directes son esdeveniments importants en la vida d'un mateix. Aquesta opció controla si es mostren o no aquests esdeveniments a la pestanya «Dades personals i detalls» de la pàgina «Dades personals».<br /><br />Els esdeveniments afectats per aquesta opció son:<ul><li>Defunció de cònjuge</li><li>Naixement i defunció de fills</li><li>Defunció de pares</li><li>Naixements i defuncions de germans</li><li>Defunció d'avis</li></ul>";
$pgv_lang["EXPAND_RELATIVES_EVENTS"]      = "Obre automàticament la llista d'esdeveniments de parents directes";
$pgv_lang["EXPAND_RELATIVES_EVENTS_help"] = "~#pgv_lang[EXPAND_RELATIVES_EVENTS]#~<br /><br />Aquesta opció controla si s'obre automàticament o no la llista d'<i>Esdeveniments de parents directes</i>.";
$pgv_lang["EXPAND_SOURCES"]      = "Obre automàticament les fonts";
$pgv_lang["EXPAND_SOURCES_help"] = "~#pgv_lang[EXPAND_SOURCES]#~<br /><br />Aquesta opció controla si es mostra automàticament o no el contingut dels registres de <i>SOUR</i> a la pàgina <i>#pgv_lang[personal_details]#</i>.";
$pgv_lang["EXPAND_NOTES"]      = "Obre automàticament les notes";
$pgv_lang["EXPAND_NOTES_help"] = "~#pgv_lang[EXPAND_NOTES]#~<br /><br />Aquesta opció controla si es mostren automàticament o no els continguts dels registres de <i>Notes</i> a la pàgina <i>#pgv_lang[personal_details]#</i>.";
$pgv_lang["SHOW_LEVEL2_NOTES"]      = "Mostra totes les notes i referències de font a les pestanyes de notes i fonts";
$pgv_lang["SHOW_LEVEL2_NOTES_help"] = "~#pgv_lang[SHOW_LEVEL2_NOTES]#~<br /><br />Aquesta opció controla si les notes i les referències de font vinculades a esdeveniments han de mostrar-se a les pestanyes de notes i fonts de la pàgina <i>#pgv_lang[personal_details]#</i>.<br /><br />Generalment, les pestanyes de notes i fonts mostren solament les referències que hi ha vinculades directament al registre de la persona, a la base de dades. Aquest és el <i>nivell 1</i> de notes i referències de font.<br /><br />La opció <b>#pgv_lang[yes]#</b> fa que aquestes pestanyes també mostrin notes i referències de font que formen part de diversos esdeveniments al registre de la persona a la base de dades. Aquest és el <i>nivell 2</i> de notes i referències de font perquè els diversos esdeveniments conformen el nivell 1.";
$pgv_lang["HIDE_LIVE_PEOPLE"] 			= "Activa la privadesa";
$pgv_lang["HIDE_LIVE_PEOPLE_help"] 			= "~#pgv_lang[HIDE_LIVE_PEOPLE]#~<br /><br />Aquesta opció activa tots els paràmetres de privadesa i oculta els detalls de la gent viva.<br /><br />Es defineix com a persones vives aquelles que no tenen cap esdeveniment més recent que el nombre d’anys que s’especifica el paràmetre <b>#pgv_lang[MAX_ALIVE_AGE]#</b>, que actualment és <b>#GLOBALS[MAX_ALIVE_AGE]#</b>. Amb aquest fi, la data de naixement de la mainada és considerada també com a tal esdeveniment.";
$pgv_lang["REQUIRE_AUTHENTICATION"]			= "Requereix validació als visitants";
$pgv_lang["REQUIRE_AUTHENTICATION_help"]		= "~#pgv_lang[REQUIRE_AUTHENTICATION]#~<br /><br />Activant aquesta opció s'obliga als visitants a accedir (amb nom d'usuari i contrasenya) per poder veure qualsevol dada del lloc.";
$pgv_lang["PAGE_AFTER_LOGIN"]		= "Pàgina a mostrar desprès de l'accés";
$pgv_lang["PAGE_AFTER_LOGIN_help"]	= "~#pgv_lang[PAGE_AFTER_LOGIN]#~<br /><br />Quina pàgina veruran els usuaris desprès d'haver-se identificat?<br /><br />L'elecció que feu aquí determina si desprès d'un accés correcte, els hi aparegui la pàgina d'acollida o la del portal MyGedView, sempre que aquest accés s'hagi fet des de la pàgina #pgv_lang[welcome_page]#.<br /><br />Quan es fa des qualsevol altra, mitjançant l'enllaç del capdamunt de totes, es retorna a l'esmentada pàgina.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"]	= "Text de benvinguda a la pàgina d'accés";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE]#~<br /><br />Aquí podeu escollir el text que apareixerà a la pantalla d'accés. Heu de determinar quin text dels predefinits és més apropiat.<br /><br />També podeu optar per posar-hi un text de benvinguda personalitzat, però no es traduirà quan als usuaris canviïn d'idioma. Tanmateix, si aquest text personalitzat conté referències a variables d'idioma que podeu definir a diversos fitxers <i>languages/extra.xx.php</i>, llavors si que es durà a terme la traducció. Per a més informació mireu-vos l'ajuda associada al camp  <b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#</b>.<br /><br />Els texts predefinits son:<ul><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT1]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_1]#</div><br /></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT2]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_2]#</div><br /></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT3]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_3]#</div></li></ul>";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT0"]	= "Sense text predefinit";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"]	= "Text predefinit que informa que tots els usuaris poden demanar accés.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"]	= "Text predefinit que informa que l'administrador decideix si autoritza o no les sol·licituds";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"]	= "Text predefinit que informa que solament els membres de la família poden demanar accés.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"]	= "Escull el text de benvinguda escrit més avall";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"]	= "Text de benvinguda personalitzat";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#~<br /><br />Si heu optat per personalitzar el text de benvinguda, podeu escriure'l aquí. Aquest text NO es traduirà al idioma del visitant, doncs es mostrarà tal i com l'hàgiu escrit. Tanmateix, si conté referències a variables d'idioma que podeu definir als diversos fitxers <i>languages/extra.xx.php</i>, si que se'n farà la traducció.<br /><br />També podeu inserir-hi etiquetes HTML.<br /><br />La següent descripció extreta del text d'ajuda de la llista de preguntes més freqüents, és igualment aplicable al text de benvinguda personalitzat.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"] = "Capçalera estàndard per al text de benvinguda personalitzat";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD_help"] = "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST_HEAD]#~<br /><br />Escolliu mostrar una capçalera estàndard per al vostre text de benvinguda personalitzat. Quan els vostre usuaris canviïn d'idioma, aquesta capçalera sortirà en el nou idioma.<br /><br />Si es posa a  <b>#pgv_lang[yes]#</b>, la capçalera es veurà així:<div class=\"list_value_wrap\">#pgv_lang[welcome_text_cust_head]#</div>";
$pgv_lang["SHOW_REGISTER_CAUTION"]			= "Mostrar que l'acceptació de les condicions d'ús a la pàgina «sol·licitud d'accés»";
$pgv_lang["SHOW_REGISTER_CAUTION_help"]		= "~#pgv_lang[SHOW_REGISTER_CAUTION]#~<br /><br />Posant-ho a <b>#pgv_lang[yes]#</b>, sortirà el següent missatge sobre els camps a omplir a la pàgina <i>#pgv_lang[requestaccount]#</i> :<div class=\"list_value_wrap\">#pgv_lang[acceptable_use]#</div>";
$pgv_lang["CHECK_CHILD_DATES"] 			= "Comprova dates de la mainada";
$pgv_lang["CHECK_CHILD_DATES_help"] 		= "~#pgv_lang[CHECK_CHILD_DATES]#~<br /><br />Comprova les dates de la mainada en determinar si una persona és difunta. En sistemes antics i/o GEDCOMs voluminosos això pot alentir el temps de resposta del vostre lloc.";
$pgv_lang["MAX_ALIVE_AGE"] 				= "Edat a partir de la que una persona s'ha de considerar difunta";
$pgv_lang["MAX_ALIVE_AGE_help"] 			= "~#pgv_lang[MAX_ALIVE_AGE]#~<br /><br />Si una persona té algun esdeveniment que no sigui defunció, enterrament o cremació, més recent que aquest nombre d'anys, se la considerarà com a \"viva\". La data de naixement de la mainada és considerada com a tal a aquest efecte.";
$pgv_lang["SHOW_GEDCOM_RECORD"] 			= "Permetre als usuaris veure el registre primari de l'arxiu GEDCOM";
$pgv_lang["SHOW_GEDCOM_RECORD_help"] 		= "~#pgv_lang[SHOW_GEDCOM_RECORD]#~<br /><br />Posant-ho a <b>#pgv_lang[yes]#</b> a les pàgines de persones, fonts i famílies s'hi mostren enllaços que permeten als usuaris veure les dades del registre primari tal i com s'emmagatzemen al fitxer GEDCOM.";
$pgv_lang["ALLOW_EDIT_GEDCOM"] 			= "Activa l'edició en línea";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"] 		= "~#pgv_lang[ALLOW_EDIT_GEDCOM]#~<br /><br />Aquesta opció activa les característiques d'edició en línea per a que els usuaris amb prerrogatives d'edició puguin actualitzar dades.";
$pgv_lang["ENABLE_AUTOCOMPLETE"]	= "Activa autocompleta";
$pgv_lang["ENABLE_AUTOCOMPLETE_help"]	= "~#pgv_lang[ENABLE_AUTOCOMPLETE]#~<br /><br />Aquesta opció determina si s'activa o no la funció d'autocompletar a l'introduir informació ens alguns formularis d'entrada.  Si es posa a  <b>#pgv_lang[yes]#</b>, els camps d'entrada en els que es possible autocompletar s'indicaran amb un color de fons diferent.<br /><br />Llavors PhpGedView cercarà a la seva base de dades les possibles coincidències en funció del que es vagi introduint. A mesura que s'entri més informació, la llista de possibles coincidències es reduirà. Si apareix l'entrada desitjada al llistat de coincidències, podeu moure el cursor cap a aquesta línea de la llista, polsant-la amb el botó esquerra del ratolí per a completar l'entrada.<br /><br />L'inconvenient d'autocompletar és que alenteix el programa és que alenteix el programa, implica força activitat de la base de dades i augmenta el tràfec de dades vers el navegador.";
$pgv_lang["USE_REFN"]		= "Utilitzeu el Número de referència";
$pgv_lang["USE_REFN_help"]	= "~#pgv_lang[USE_REFN]#~<br /><br />Aquesta opció determina si el #factarray[REFN]# introduït a la informació d'una persona <u>nova</u> s'ha d'utilitzar com a número d'identificació d'aquesta persona nova.<br /><br />Quan aquesta opció s'estableix en <b>#pgv_lang[yes]#</b>, el #factarray[REFN]# introduït ha de seguir les regles establertes per a tots els números d'identificació i una persona amb aquest identificador no ha d'existir base de dades. Si no es compleixen aquestes condicions o quan aquesta opció s'estableix en <b>#pgv_lang[no]#</b>, PhpGedView assignarà automàticament el següent número d'identificació disponible a aquesta nova persona.<br /><br />Els números d'identificació vàlids només poden contenir les lletres <b>A</b> a <b>Z</b>, <b>a</b> a <b>z</b>, dígits <b>0</b> a <b>9</b> i els símbols especials <b>. : - </b> i <b>_</b><br /><br />També heu d'activar la visualització del #factarray[REFN]# afegint l'entrada <b>REFN</b> al <b>#pgv_lang[INDI_FACTS_UNIQUE]#</b>, <b>#pgv_lang[INDI_FACTS_QUICK]#</b> i <b>#pgv_lang[QUICK_REQUIRED_FACTS]#</b> opcions de configuració següents.";
$pgv_lang["EDIT_AUTOCLOSE"]		= "Tenca automàticament la finestra d'edició";
$pgv_lang["EDIT_AUTOCLOSE_help"]	= "~#pgv_lang[EDIT_AUTOCLOSE]#~<br /><br />Aquesta opció controla si es tenca automàticament o no la finestra d'edició desprès d'una actualització correcta.";
$pgv_lang["INDEX_DIRECTORY_help"] 			= "~#pgv_lang[INDEX_DIRECTORY]#~<br /><br />El camí al directori amb permisos de lectura/escriptura on el PhpGedView emmagatzamarà els fitxers d'índex (cal també posar-hi els \"/\"). No cal que el nom d'aquest directori sigui necessàriament \"index\". Podeu escollir qualsevol altre nom.<br /><br />Per seguretat, aquest directori hauria de posar-se a qualsevol punt de l'espai reservat a fitxers del servidor no accessibles des d'Internet. Un exemple pot ésser el segent:<br /><b>PhpGedView:</b> dir1/dir2/dir3/PhpGedView<br /><b>Index:</b> dir1/dir4/dir5/dir6/index<br /><br />Per a l'exemple mostrat, us caldria entrar <b>../../dir4/dir5/dir6/index/</b> en aquest camp.";
$pgv_lang["POSTAL_CODE"]  = "Posició del codi postal";
$pgv_lang["POSTAL_CODE_help"] = "~#pgv_lang[POSTAL_CODE]#~<br /><br />Diferents països empren diferents formes d'escriure l'adreça. Aquesta opció us permet posar el codi postal abans o després del nom de la població.";
$pgv_lang["SUBLIST_TRIGGER_I"]		= "Nombre màxim de cognoms";
$pgv_lang["SUBLIST_TRIGGER_I_help"]	= "~#pgv_lang[SUBLIST_TRIGGER_I]#~<br /><br />Les llistes massa llargues de persones amb el mateix cognom poden dividir-se en petites subllistes ordenades per la inicial del nom de pila.<br /><br />Aquesta opció determina a partir de quin nombre cal fer-ho. Per desactivar completament les subllistes, poseu aquesta opció a zero.";
$pgv_lang["SUBLIST_TRIGGER_F"]		= "Nombre màxim de noms de família";
$pgv_lang["SUBLIST_TRIGGER_F_help"]	= "~#pgv_lang[SUBLIST_TRIGGER_F]#~<br /><br />Les llistes massa llargues de famílies amb el mateix nom poden dividir-se en petites subllistes ordenades per la inicial del nom de pila.<br /><br />Aquesta opció determina a partir de quin nombre cal fer-ho. Per desactivar completament les subllistes, poseu aquesta opció a zero.";
$pgv_lang["SURNAME_LIST_STYLE"]		= "Estil de la llista de cognoms";
$pgv_lang["SURNAME_LIST_STYLE_help"]	= "~#pgv_lang[SURNAME_LIST_STYLE]#~<br /><br />Les llistes de cognoms que surten al bloc #pgv_lang[block_top10]#, a #pgv_lang[individual_list]#, i a #pgv_lang[family_list]#, poden veure's en diferents estils.<ul><li><b>#pgv_lang[style2]#</b>&nbsp;&nbsp;&nbsp;En aquest estil els cognoms surten en una taula que pot ordenar-se be per cognom o per nombre.</li><li><b>#pgv_lang[style3]#</b>&nbsp;&nbsp;&nbsp;En aquest es mostren en una llista on la mida de la font depèn del nombre d'ocurrències d'aquest nom a la base de dades. En aquest format no poden ordenar-se.</li></ul>";
$pgv_lang["SHOW_ID_NUMBERS_help"] 			= "~#pgv_lang[SHOW_ID_NUMBERS]#~<br /><br />Aquesta opció controla si han de sortir o no els número d'ID entre parèntesi desprès dels noms, als gràfics i llistes.";
$pgv_lang["SHOW_LAST_CHANGE"]		= "Mostra la data del darrer canvi del registre del GEDCOM";
$pgv_lang["SHOW_LAST_CHANGE_help"]	= "~#pgv_lang[SHOW_LAST_CHANGE]#~<br /><br />Aquesta opció controla si ha de sortir o no la data del darrer canvi del dels registres del GEDCOM.";
$pgv_lang["SHOW_EST_LIST_DATES"]		= "Mostra dates estimades per al naixement i la mort";
$pgv_lang["SHOW_EST_LIST_DATES_help"]	= "~#pgv_lang[SHOW_EST_LIST_DATES]#~<br /><br />Aquesta opció controla si es mostraran o no les dates estimades de naixement i mort, en lloc de deixar espais en blanc, a cadascuna de les llistes i gràfics de persones, de les que en desconeixem aquestes dades.";
$pgv_lang["SHOW_PEDIGREE_PLACES"] 			= "Nivell de llocs que sortirà al caixetins de les persones";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"] 		= "~#pgv_lang[SHOW_PEDIGREE_PLACES]#~<br /><br />Fixa el nivell de detall d'informació de llocs que sortirà als caixetins de les persones dels gràfics.<br /><br />Posant-ho a 9 garanteix que sortiran tots els nivells de lloc. Posant-ho a 0, ocultarà completament els llocs. Poseu-ho a 1 per veure solament el primer nivell, a 2 per veure 2 nivells, etc.";
$pgv_lang["pageSizeDefault"]			= "Mida de pàgina predeterminada";
$pgv_lang["pageSizeDefault_help"]		= "~#pgv_lang[pageSizeDefault]#~<br /><br />Aquesta és la mida de pàgina predeterminada per a tots els informes. La selecció es pot anul·lar als informes individuals.";
$pgv_lang["pageSizeOptions"]			= "Mides de pàgina";
$pgv_lang["pageSizeOptions_help"]		= "~#pgv_lang[pageSizeOptions]#~<br /><br />Aquesta és la llista de mides de pàgina admeses actualment per PhpGedView quan genera informes. Podeu ampliar aquesta llista afegint altres mides de pàgina estàndard tal i com es mostren a la <a href='https://ca.wikipedia.org/wiki/Mida_de_paper' title='Article de Wikipedia' target='_blank'><b>Article de Wikipedia</b></a><br /><ul><li>La mida de pàgina estàndard per a la majoria del món és <b>A4</b>, que correspon a 210 x 297 mm (8,3 x 11,7 pol.)</li><li>La mida de pàgina estàndard nord-americana és <b>letter</b>, que correspon a 216 x 279 mm (8,5 x 11,0 pol.)</li><li>Altres mides disponibles són <b>A3</b>, que correspon a 297 x 420 mm (11,7 x 16,5 pol.)</li><li>i <b>legal</b>, que correspon a 216 x 356 mm (8,5 x 14,0 pol.)</li></ul><br />Es recomana tenir precaució quan afegiu mides de paper diferents de les de la llista ISO «A»; no s'han provat totes les mides estàndard ISO.";
$pgv_lang["fontsDefault"]				= "Tipus de lletra per defecte";
$pgv_lang["fontsDefault_help"]			= "~#pgv_lang[fontsDefault]#~<br /><br />Aquest és el tipus de lletra predeterminat per a tots els informes. La selecció es pot anul·lar als informes individuals.";
$pgv_lang["fontsOptions"]				= "Tipus de lletra";
$pgv_lang["fontsOptions_help"]			= "~#pgv_lang[fontsOptions]#~<br /><br />Aquesta és la llista de tipus de lletra que actualment admet PhpGedView quan genera informes.<br /><br />Podeu ampliar aquesta llista o escurçar-la si cal. Es recomana tenir precaució quan amplieu aquesta llista; no s'han provat tots els tipus de lletra que es troben a la biblioteca <i>includes/tcpdf/fonts</i>.";
$pgv_lang["MULTI_MEDIA"] 				= "Activa les característiques multimèdia";
$pgv_lang["MULTI_MEDIA_help"] 			= "~#pgv_lang[MULTI_MEDIA]#~<br /><br />El GEDCOM 5.5.1 us permet enllaçar imatges, vídeos i altres objectes multimèdia al vostre GEDCOM. Si no n'incloeu podeu desactivar aquesta característica posant aquest valor a <b>#pgv_lang[no]#</b>.<br /><br />Mireu-vos la secció de multimèdia al fitxer <a href=\"readme.txt\">readme.txt</a> per saber-ne més sobre la inclusió de multimèdia al vostre lloc.";
$pgv_lang["MEDIA_EXTERNAL"]			= "Mantén els enllaços";
$pgv_lang["MEDIA_EXTERNAL_help"]	= "~#pgv_lang[MEDIA_EXTERNAL]#~<br /><br />Quan es localitza un vincle multimèdia començant, per exemple amb http://, ftp://, mms:// no es modificarà si ho poseu a <b>#pgv_lang[yes]#</b>. Per exemple, http://www.lamevafamilia.cat/fotos/ton.jpg romandrà com http://www.lamevafamilia.cat/fotos/ton.jpg. En canvi si ho poseu a <b>#pgv_lang[no]#</b>, l'enllaç es tractarà com una referència estàndard de l'estructura multimèdia. Per exemple, en el cas d'abans sortirà com ./media/ton.jpg";
$pgv_lang["MEDIA_DIRECTORY"] 				= "Directori Multimèdia";
$pgv_lang["MEDIA_DIRECTORY_help"] 			= "~#pgv_lang[MEDIA_DIRECTORY]#~<br /><br />El camí del directori amb permís de lectura i escriptura on el PhpGedView emmagatzemarà els fitxers multimèdia (cal incloure les \"/\"). A PhpGedView no cal que aquest directori tingui precisament el nom de \"media\". Podeu escollir qualsevol altre nom.<br /><br />Per seguretat, aquest directori caldria ubicar-lo en algun lloc del servidor destinat a fitxers, no accessible des d'Internet. Un exemple d'ubicació pot ésser aquesta:<br /><b>PhpGedView:</b> dir1/dir2/dir3/PhpGedView<br /><b>Media:</b> dir1/dir4/dir5/dir6/media<br /><br />En aquest cas de l'exemple, hauríeu de posar-ho així <b>../../dir4/dir5/dir6/media/</b> en aquest camp.";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"] 		= "Nivells de directori Multimèdia permesos";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"] 		= "~#pgv_lang[MEDIA_DIRECTORY_LEVELS]#~<br /><br />Un valor de 0 ignorarà tots els directoris en la ubicació dels fitxers multimèdia. Un valor de 1 permet accedir a un primer sots-directori per encabir-hi els fitxers. Incrementant aquest nombre s'augmenta el de sots-carpetes permeses.<br /><br />Per exemple, si enllaceu una imatge al vostre GEDCOM amb un camí com ara <b>C:\\Documents&nbsp;and&nbsp;Settings\\User\\My&nbsp;Documents\\My&nbsp;Pictures\\Genealogy\\Surname&nbsp;Line\\grandpa.jpg</b>, un valor de 0 traduirà aquest camí a <b>./media/grandpa.jpg</b>. Un valor de 1 el traduirà a <b>./media/Surname&nbsp;Line/grandpa.jpg</b>, etc. Generalment es podrà deixar-ho a 0. Tanmateix, és possible que alguns fitxers multimèdia emmagatzemats a diferents directoris tinguin un mateix nom hi podrien solapar-se els uns als altres amb aquesta opció posada a 0. Valors més alts us permetran fer una mica d'organització i evitar col·lisions de noms de fitxer.";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"] 		= "~#pgv_lang[SHOW_HIGHLIGHT_IMAGES]#~<br /><br />Si teniu activada la característica multimèdia per al vostre lloc, podeu fer sortir al PhpGedView imatges en miniatura al costat de noms de les persones, als gràfics i caixetins.<br /><br />Mireu-vos la secció de Multimèdia al fitxer <a href=\"readme.txt\">readme.txt</a> per saber-ne més sobre com incloure multimèdia al vostre lloc.";
$pgv_lang["USE_THUMBS_MAIN"]	= "Empra miniatures";
$pgv_lang["USE_THUMBS_MAIN_help"]	= "~#pgv_lang[USE_THUMBS_MAIN]#~<br /><br />Aquesta opció determina si PhpGedView enviarà la imatge gran o la miniatura al navegador cada cop que un diagrama o la pàgina <i>#pgv_lang[personal_details]#</i> necessiti una miniatura.<br /><br />El valor <b>#pgv_lang[no]#</b> farà que PhpGedView envií la imatge gran, mientres que el valor <b>#pgv_lang[yes]#</b> farà que s'envií la miniatura. Cada imatge individual també te l'opció  «#factarray[_THUM]#» que, si es fixa a <b>#pgv_lang[yes]#</b>, farà que s'envií la imatge gran independentment del valor de l'opció «#pgv_lang[USE_THUMBS_MAIN]#» en la configuració del GEDCOM.  No aconseguireu que PhpGedView envií la miniatura si la configuració del GEDCOM especifica que sempre cal emprar les imatges grans.<br /><br />PhpGedView no canvia la mida de la imatge enviada; és el navegador qui ho fa segons les especificacions de la pàgina que ha rebut. Això pot comportar conseqüències indesitjables si la imatge enviada no és realment una miniatura, quani PhpGedView espera enviar una imatge petita. Això és un error: Alguns cops pot ésser desitjable mostrar una imatge de mida gran en llocs en que normalment hi aniria una imatge miniatura.<br /><br />Hauríeu d'evitar deixar l'opció «#pgv_lang[USE_THUMBS_MAIN]#» a <b>#pgv_lang[no]#</b>. Aquest ajustament causarà l'enviament d'un excessiu detall de les imatges al navegador que aquest haurà de descartar. Les descàrregues de pàgines, especialment els diagrames amb moltes imatges poden enlentir-se molt.";
$pgv_lang["SHOW_MEDIA_FILENAME"]		= "Mostra el nom del fitxer al visor multimèdia";
$pgv_lang["SHOW_MEDIA_FILENAME_help"]	= "~#pgv_lang[SHOW_MEDIA_FILENAME]#~<br /><br />El visor multimèdia pot mostrar el nom del fitxer mentre s'està visionant. Aquesta opció determina si es mostra o no aquest nom als usuaris.<br /><br />Podeu optar per amagar-lo per qüestions de seguretat.";
$pgv_lang["SHOW_MEDIA_DOWNLOAD"]		= "Mostra l'enllaç de descàrrega al visor multimèdia";
$pgv_lang["SHOW_MEDIA_DOWNLOAD_help"]	= "~#pgv_lang[SHOW_MEDIA_DOWNLOAD]#~<br /><br />El visor multimèdia pot presentar un enllaç que, polsant-lo, descarregarà el fitxer multimèdia al PC local.<br /><br />Podeu fer ocultar aquest enllaç per qüestions de seguretat. ";
$pgv_lang["ENABLE_CLIPPINGS_CART"] 			= "Activa el Cistell Genealògic";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"] 		= "~#pgv_lang[ENABLE_CLIPPINGS_CART]#~<br /><br />El Cistell Genealògic permet als usuaris posar gent a un fitxer temporal que pot descarregar-se en format GEDCOM per a importar-lo posteriorment als seu programari genealògic.";
$pgv_lang["HIDE_GEDCOM_ERRORS"] 			= "Oculta els errors GEDCOM:";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"] 		= "~#pgv_lang[HIDE_GEDCOM_ERRORS]#~<br /><br />Posant-ho a <b>#pgv_lang[yes]#</b> ocultarà els missatges d'error produïts pel PhpGedView quan no entengui alguna etiqueta del vostre fitxer GEDCOM. El PhpGedView procura adequar-se a l'estàndard GEDCOM 5.5.1, però hi ha programari genealògic que inclouen etiquetes pròpies i particulars. Mireu-vos el fitxer <a href=\"readme.txt\">readme.txt</a> per a més informació.";
$pgv_lang["WORD_WRAPPED_NOTES"] 			= "Afegeix espais on les notes s'han comprimit:";
$pgv_lang["WORD_WRAPPED_NOTES_help"] 		= "~#pgv_lang[WORD_WRAPPED_NOTES]#~<br /><br />Algun programari genealògic comprimeix les notes pels marges de les paraules, mentre que altre no ho fa mai. Això pot fer que el PhpGedView tregui paraules enganxades. Posant-ho a  <b>#pgv_lang[yes]#</b> afegirà un espai entre paraules que s'hagin comprimit al GEDCOM original.";
$pgv_lang["SHOW_CONTEXT_HELP"]			= "Mostrar els enllaços d'ajuda contextual";
$pgv_lang["SHOW_CONTEXT_HELP_help"]			= "~#pgv_lang[SHOW_CONTEXT_HELP]#~<br /><br />Aquesta opció activa els enllaços, identificats amb un caràcter d'interrogació <b>#pgv_lang[qm]#</b> al costat del ítems de moltes pàgines. Aquest enllaços permeten als usuaris obtenir informació sobre cada un dels ítems.";
$pgv_lang["DAYS_TO_SHOW_LIMIT"]		= "Data límit d'esdeveniments propers";
$pgv_lang["DAYS_TO_SHOW_LIMIT_help"] = "~#pgv_lang[DAYS_TO_SHOW_LIMIT]#~<br /><br />Entreu el màxim nombre de dies a mostrar al bloc d'esdeveniments propers. No por ésser més gran de 30. Si n'hi poseu més, prendrà 30.<br /><br />El valor que entreu aquí determina quan de temps endavant mirarà el PhpGedView cercant esdeveniments propers. El resultat d'aquesta recerca -es fa un cop al dia- s'emmagatzema en un fitxer temporal.<br /><br />Ni a les pàgines d'Índex o al Portal, es poden demanar més dies que aquest valor prefixat. Com més gran sigui el valor, més estona es trigarà a construir la base de dades diària i més estona caldrà per mostrar-lo al bloc, el mateix passa si demaneu veure un nombre de dies menor.";
$pgv_lang["COMMON_NAMES_THRESHOLD"]	= "Mínim nombre d'ocurrències per considerar-se \"Cognom freqüent\"";
$pgv_lang["COMMON_NAMES_THRESHOLD_help"]	= "~#pgv_lang[COMMON_NAMES_THRESHOLD]#~<br /><br />És el nombre de cops que un cognom ha de repetir-se per a incloure'l a la llista de cognoms més corrents de la pàgina d'inici.";
$pgv_lang["COMMON_NAMES_ADD"]	= "Cognoms a afegir a la llista de cognoms més habituals";
$pgv_lang["COMMON_NAMES_ADD_help"]	= "~#pgv_lang[COMMON_NAMES_ADD]#~<br /><br />Si el nombre de vegades que un cognom es repeteix és inferior al prefixat, no sortirà a la llista. Però podeu afegir-n'hi manualment. Si hi entreu més d'un cognom, cal que els separeu entre si amb una coma. <b>Cal respectar les majúscules i minúscules.</b>";
$pgv_lang["COMMON_NAMES_REMOVE"]	= "Cognoms a treure de la llista de cognoms més habituals";
$pgv_lang["COMMON_NAMES_REMOVE_help"]	= "~#pgv_lang[COMMON_NAMES_REMOVE]#~<br /><br />Si voleu treure cognoms de la llista del més habituals, sense que calgui per això augmentar el valor del tall per entra-hi, podeu fer-ho posant-los aquí. Si n'hi ha més d'un, heu de separar-los entre sí per comes. <b>Cal respectar les majúscules, minúscules i accents.</b> Els cognoms que entreu aquí també s'eliminaran de la llista Top-10 de la pàgina d'inici.";
$pgv_lang["HOME_SITE_URL"] 				= "URL principal del web";
$pgv_lang["HOME_SITE_URL_help"] 			= "~#pgv_lang[HOME_SITE_URL]#~<br /><br />Cada pàgina del PhpGedView inclou un enllaç a la pàgina principal (la d'accés al vostre lloc web). La forma en que surt aquest enllaç ho controla la presentació que es faci servir. Entreu aquí  l'adreça URL de la vostra pàgina.";
$pgv_lang["HOME_SITE_TEXT"] 				= "Text de la pàgina principal";
$pgv_lang["HOME_SITE_TEXT_help"] 			= "~#pgv_lang[HOME_SITE_TEXT]#~<br /><br />El text que vulgueu fer servir per identificar l'enllaç a la pàgina principal del vostre lloc web.";
$pgv_lang["CONTACT_EMAIL"] 				= "Contacte genealògic";
$pgv_lang["CONTACT_EMAIL_help"] 			= "~#pgv_lang[CONTACT_EMAIL]#~<br /><br />La persona a contactar per a qüestions genealògiques relacionades amb aquest lloc.";
$pgv_lang["CONTACT_METHOD"]				= "Forma de contacte per a temes genealògics";
$pgv_lang["CONTACT_METHOD_help"]			= "~#pgv_lang[CONTACT_METHOD]#~<br /><br />La forma que cal fer servir per contactar amb #pgv_lang[CONTACT_EMAIL]# per a qüestions genealògiques.#pgv_lang[CONTACT_METHOD_desc]#";
$pgv_lang["CONTACT_METHOD_desc"] = "<ul><li>L'opció <b>#pgv_lang[mailto]#</b> crea un enllaç \"mailto\" que pot polsar-se per enviar un correu electrònic fent servir el client de correu electrònic del PC de l'usuari.</li><li>L'opció <b>#pgv_lang[messaging]#</b> fa servir el sistema intern de missatgeria del PhpGedView i no envia correus electrònics.</li><li>L'opció per defecte és la  <b>#pgv_lang[messaging2]#</b>. Fa servir el sistema intern de missatgeria del PhpGedView però també n'envia una còpia per correu electrònic.</li><li>L'opció <b>#pgv_lang[messaging3]#</b> permet al PhpGedView gestionat els missatges i enviar-los per correu electrònic, però no els emmagatzema internament. És semblant a la <b>#pgv_lang[mailto]#</b>, excepte que el missatge l'envia el PhpGedView per comptes del PC de l'usuari.</li><li>L'opció <b>#pgv_lang[no_messaging]#</b> fa que els usuaris no disposin de mètode de contacte.</li></ul>";
$pgv_lang["PHPGEDVIEW_EMAIL"]		= "Adreça de resposta PhpGedView";
$pgv_lang["PHPGEDVIEW_EMAIL_help"]	= "~#pgv_lang[PHPGEDVIEW_EMAIL]#~<br /><br />Adreça de correu electrònic a posar al camp «De:» dels correus que el PhpGedView generi automàticament.<br /><br />El PhpGedView pot generar automàticament correus electrònics notificant als administradors canvis que cal revisar. També envia notificacions per aquest conducte, als usuaris que ham demanat enregistrar-se.<br /><br />Generalment, el camp  «De:» d'aquests correus generats automàticament és quelcom així com <i>De: phpgedview-norespongueu@elvostrelloc</i> per mostrar que no cal respondre al missatge. Per prevenció contra l'spam i altres abusos per correu electrònic, molts sistemes obliguen que cada missatge porti un camp «De:» que reflecteixi un compte de correu electrònic vàlid i no acceptaran missatges que s'originin d'un compte  <i>phpgedview-norespongueu</i>.";
$pgv_lang["WEBMASTER_EMAIL"] 				= "Persona de suport";
$pgv_lang["WEBMASTER_EMAIL_help"] 			= "~#pgv_lang[WEBMASTER_EMAIL]#~<br /><br />La persona a contactar per a qüestions tècniques, errors o problemes amb que es trobin els usuaris.";
$pgv_lang["SUPPORT_METHOD"]				= "Forma de contacte per a qüestions tècniques";
$pgv_lang["SUPPORT_METHOD_help"]			= "~#pgv_lang[SUPPORT_METHOD]#~<br /><br />La forma de contacte amb el #pgv_lang[WEBMASTER_EMAIL]# per a qüestions tècniques.#pgv_lang[CONTACT_METHOD_desc]#";
$pgv_lang["SHOW_FACT_ICONS"] 		= "Mostra icones d'esdeveniments";
$pgv_lang["SHOW_FACT_ICONS_help"]	= "~#pgv_lang[SHOW_FACT_ICONS]#~<br /><br />Poseu-ho a <b>#pgv_lang[yes]#</b> per mostrar icones al costat dels noms d'esdeveniments a la pàgina  #pgv_lang[personal_facts]#. Les icones d'esdeveniments es mostraran sempre i quan existeixin al directori <i>images/facts</i> de la presentació utilitzada.";
$pgv_lang["FAVICON"] 					= "Icona per a Favorits";
$pgv_lang["FAVICON_help"] 				= "~#pgv_lang[FAVICON]#~<br /><br />Canvieu-ho per posar-hi la icona que preferiu que es vegi al menú de favorits de la gent que hi posi el vostre lloc web.";
$pgv_lang["THEME_DIR"] 					= "Directori de Presentacions";
$pgv_lang["THEME_DIR_help"] 				= "~#pgv_lang[THEME_DIR]#~<br /><br />És el directori a on s'emmagatzemin els fitxers de les presentacions del PhpGedView.<br /><br />Podeu personalitzar-vos algun dels temes que venen amb el PhpGedView i fer que el vostre lloc tingui una aparença original i única. Mireu-vos la secció de Personalització de Presentacions al fitxer <a href=\"readme.txt\"></a> per informar-vos de com fer-ho.";
$pgv_lang["TIME_LIMIT"] 				= "Temps límit PHP:";
$pgv_lang["TIME_LIMIT_help"] 				= "~#pgv_lang[TIME_LIMIT]#~<br /><br />El temps màxim en segons que es permet al PhpGedView estar funcionant.<br /><br />Per defecte és 1 minut. Depenent del volum del vostre fitxer GEDCOM, potser us caldrà incrementar-lo quan calgui generar índexs. Posant-ho a 0 fa que el PHP funcioni sempre.<br /><br />COMPTE! Posant-lo a 0 o a un valor molt alt, pot provocar que el vostre lloc es pengi en alguns sistemes operatius abans de que l'script acabi. Posant-lo a 0 fa que no acabi mai fins que l'administrador del servidor mati el procés o reinicialitzi el servidor. Un arbre genealògic gran pot requerir força temps de funcionament; deixant-lo en un valor tan baix com sigui possible, assegureu que ningú penja el vostre servidor demanant un gràfic excessivament llarg.";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"] 		= "~#pgv_lang[PGV_SESSION_SAVE_PATH]#~<br /><br />El directori on emmagatzemar els fitxers de sessions del PhpGedView.<br /><br />Alguns amfitrions no tenen configurat correctament el PHP i les sessions no es conserven entre comandes de pàgina. Aquesta opció permet als administrador del lloc eludir aquest problema desant els fitxers en un dels seus directoris locals. El directori ./index/ és una bona elecció si us cal canviar-ho. Per defecte es deixa aquest camp en blanc amb el que es fa servir el camí configurat a <i>php.ini</i>.";
$pgv_lang["SERVER_URL_help"]		= "~#pgv_lang[SERVER_URL]#~<br /><br />Si utilitzeu https o un port diferent del que hi ha per defecte, us caldrà entrar aquí l'URL per accedir al servidor.";
$pgv_lang["LOGIN_URL"]			= "URL d'accés";
$pgv_lang["LOGIN_URL_help"]		= "~#pgv_lang[LOGIN_URL]#~<br /><br />Solament us caldrà entrar un URL d'accés si voleu redireccionar els usuaris a un lloc diferent quan accedeixin. Això és molt útil si us cal passar de http a https quan els vostres usuaris s'hagin acreditat. Inclou el URL complert a <i>login.php</i>. Per exemple, https://www.elvostreservidor.cat/phpgedview/login.php .";
$pgv_lang["PGV_SESSION_TIME_help"]	= "~#pgv_lang[PGV_SESSION_TIME]#~<br /><br />El temps en segons que una sessió PhpGedView roman activa abans de requerir un nou accés. Per defecte és de 7200 (2 hores).";
$pgv_lang["SHOW_STATS"] 				= "Mostra estadístiques d'execució";
$pgv_lang["SHOW_STATS_help"] 				= "~#pgv_lang[SHOW_STATS]#~<br /><br />Treu estadístiques de temps d'execució i de consultes a la base de dades al final de cada pàgina.";
$pgv_lang["SHOW_COUNTER"]		= "Mostra els comptadors";
$pgv_lang["SHOW_COUNTER_help"]		= "~#pgv_lang[SHOW_COUNTER]#~<br /><br />Mostra els comptadors al portal i a les pàgines <i>#pgv_lang[personal_details]#</i>.";
$pgv_lang["USE_REGISTRATION_MODULE_help"]		= "~#pgv_lang[USE_REGISTRATION_MODULE]#~<br /><br />Dóna als visitants l'opció d'autoverificar-se per disposar d'accés al lloc.<br /><br />El visitant rebrà un correu electrònic amb un codi per confirmar i verificar la bondat de la seva comanda d'accés. Desprès de la verificació l'Administrador ho ha d'autoritzar abans que pugui disposar d'accés..";
$pgv_lang["ALLOW_USER_THEMES_help"]			= "~#pgv_lang[ALLOW_USER_THEMES]#~<br /><br />Dóna als usuaris l'opció de seleccionar la presentació que més els plagui.";
$pgv_lang["PGV_SIMPLE_MAIL_help"] = "~#pgv_lang[PGV_SIMPLE_MAIL]#~<br /><br />A les capçaleres de correu normals per a missatges externs, hi va el nom i l'adreça de correu. Alguns sistemes de correu no ho accepten. Posant-ho a <b>#pgv_lang[yes]#</b>, solament es farà servir l'adreça de correu.";
$pgv_lang["PGV_SMTP_ACTIVE_help"] = "~#pgv_lang[PGV_SMTP_ACTIVE]#~<br /><br />Empra SMTP per enviar correus electrònics des de PhpGedView.<br /><br />Aquesta opció requereix accés a un servidor de correu SMTP. Quan es posa a  <b>#pgv_lang[no]#</b> el PhpGedView fa servir el sistema de correu electrònic incorporat al PHP d'aquest servidorr.";
$pgv_lang["PGV_SMTP_DEBUG_help"] = "~#pgv_lang[PGV_SMTP_DEBUG]#~<br /><br />Quan l'opció <b>#pgv_lang[PGV_SMTP_ACTIVE]#</b> s'estableix en <b>#pgv_lang[yes]#</b>, PhpGedView utilitzarà el programa PHPMailer per enviar correus electrònics. Aquest programa produeix missatges d'error quan troba problemes mentre intenta enviar correus electrònics.<br /><br />Aquesta opció, que és útil en intentar resoldre problemes d’enviament de correu electrònic, determina els tipus d’errors que informarà PHPMailer. Els tipus d'error que podeu seleccionar són:<ul><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION0]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION1]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION2]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION3]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION4]#</li></ul>";
$pgv_lang["PGV_SMTP_HOST_help"] = "~#pgv_lang[PGV_SMTP_HOST]#~<br /><br />Aquest és el nom del servidor de correu SMTP. Exemple: <b>smtp.foo.bar.com</b>.<br /><br />Valors de configuració per alguns servidors de correu electrònic:<br /><br /><b>Gmail</b><br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_HOST]#:&nbsp;&nbsp;smtp.gmail.com<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_PORT]#:&nbsp;&nbsp;465 o 587<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_SSL]#:&nbsp;&nbsp;SSL<br /><br /><b>Hotmail</b><br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_HOST]#:&nbsp;&nbsp;smtp.live.com<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_PORT]#:&nbsp;&nbsp;25 o 587<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_SSL]#:&nbsp;&nbsp;TLS<br /><br /><b>Yahoo Mail Plus</b> (actualment de pagament)<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_HOST]#:&nbsp;&nbsp;smtp.mail.yahoo.com<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_PORT]#:&nbsp;&nbsp;25";
$pgv_lang["PGV_SMTP_HELO_help"] = "~#pgv_lang[PGV_SMTP_HELO]#~<br /><br />Aquesta és la part del domini d'una adreça vàlida de correu electrònic al servidor SMTP.<br /><br />Per exemple, si teniu un compte de correu electrònic com aquest <b>elvostrenom@abc.xyz.com</b>, cal que entreu  <b>abc.xyz.com</b> aquí.";
$pgv_lang["PGV_SMTP_PORT_help"] = "~#pgv_lang[PGV_SMTP_PORT]#~<br /><br />El número de port a fer servir per a les connexions al servidor SMTP. Generalment és el port número <b>25</b>.";
$pgv_lang["PGV_SMTP_AUTH_help"] = "~#pgv_lang[PGV_SMTP_AUTH]#~<br /><br />Nom d'usuari i contrasenya per a connectar al servidor SMTP.<br /><br />Alguns servidors requereixen connexions autenticades abans d'acceptar correus electrònics de sortida.";
$pgv_lang["PGV_SMTP_AUTH_USER_help"] = "~#pgv_lang[PGV_SMTP_AUTH_USER]#~<br /><br />El nom d'usuari requerit per a l'autenticació al servidor SMTP.";
$pgv_lang["PGV_SMTP_AUTH_PASS_help"] = "~#pgv_lang[PGV_SMTP_AUTH_PASS]#~<br /><br />La contrasenya requerida per a l'autenticació al servidor SMTP.";
$pgv_lang["PGV_SMTP_SSL_help"]		 = "~#pgv_lang[PGV_SMTP_SSL]#~<br /><br />Transport Layer Security (TLS) i Secure Sockets Layer (SSL) son protocols per al xifratge de dades a Internet.<br /><br />TLS 1.0, 1.1 y 1.2 son evolucions estandaritzades de SSL 3.0. TLS 1.0 i SSL 3.1 son equivalents. L'evolució de SSL es realitza amb el nou nom de TLS.<br /><br />Si el vostre servidor SMTP requereixl protocol TLS durant l'autenticació, haureu d'escollir l'opció <b>TLS</b>.";
$pgv_lang["PGV_SMTP_FROM_NAME_help"] = "~#pgv_lang[PGV_SMTP_FROM_NAME]#~<br /><br />Introduïu el nom a posar al camp «De:» dels missatges originats en aquest lloc.<br /><br />Per exemple, si us dieu <b>Joan Smith</b> i sou administrador d'un lloc conegut com <b>Genealogia d'en Joan</b>, podrieu posar-hi quelcom així <b>Joan Smith</b> o be <b>Genealogia d'en Joan</b> o fins i tot <b>Joan Smith, Administrador: Genealogia d'en Joan</b>. Podeu posar-hi el que vulgueu però no es permet  HTML.";
$pgv_lang["gedcom_title"]			= "#pgv_lang[ged_title]#";
$pgv_lang["gedcom_title_help"]			= "~#pgv_lang[gedcom_title]#~<br /><br />Entreu un títol descriptiu a mostrar quan els usuaris estiguin triant entre les bases de dades GEDCOM del vostre lloc.";
$pgv_lang["LOGFILE_CREATE"]				= "Arxiva els fitxers de registre";
$pgv_lang["LOGFILE_CREATE_help"]			= "~#pgv_lang[LOGFILE_CREATE]#~<br /><br />Periodicitat amb que el programa arxiva els fitxers de registre.";
$pgv_lang["REMINDER_FREQ"] 			= "Freqüència dels correus electrònics de recordatori «Revisió els canvis»";
$pgv_lang["REMINDER_FREQ_help"]		= "~#pgv_lang[REMINDER_FREQ]#~<br /><br />Aquesta opció controla la freqüència amb què s'enviaran els missatges de correu electrònic de recordatori «Revisa els canvis». <b>zero</b>: mai;&nbsp;&nbsp;<b>1</b>: diàriament;&nbsp;&nbsp;<b>2</b>: cada 2n dia, etc.";
$pgv_lang["PGV_MEMORY_LIMIT_help"]	= "~#pgv_lang[PGV_MEMORY_LIMIT]#~<br /><br />La quantitat màxima de memòria que pot ésser consumida pels scripts del PhpGedView. Per defecte és 64 Mb. Alguns amfitrions desactiven aquesta opció de la seva configuració de PHP.";
$pgv_lang["PGV_STORE_MESSAGES_help"]	= "~#pgv_lang[PGV_STORE_MESSAGES]#~<br /><br />Especifica si els missatges enviats mitjançant el PhpGedView han d'emmagatzemar-se a la base de dades. Posant-ho a <b>#pgv_lang[yes]#</b> els usuaris poden recuperar llurs missatges quan accedeixin al PhpGedView. Posant-ho a <b>#pgv_lang[no]#</b> els missatges solament s'envien per correu electrònic.";
$pgv_lang["ALLOW_THEME_DROPDOWN"]		= "Mostra la persiana per seleccionar i canviar la presentació";
$pgv_lang["ALLOW_THEME_DROPDOWN_help"]	= "~#pgv_lang[ALLOW_THEME_DROPDOWN]#~<br /><br />Dóna als usuaris l'opció de seleccionar des d'un menú la presentació preferida.<br /><br />No n'hi ha prou amb activar aquest paràmetre. Per a que els usuaris puguin canviar-se efectivament la presentació cal activar també l'opció <b>#pgv_lang[ALLOW_USER_THEMES]#</b>.";
$pgv_lang["MAX_VIEW_RATE"]		= "Màxim rati de visualització de pàgines";
$pgv_lang["MAX_VIEW_RATE_help"]	= "~#pgv_lang[MAX_VIEW_RATE]#~<br /><br />Aquesta opció limita el rati amb el que un usuari pot visionar pàgines.<br /><br />Si s'excedeix, el PhpGedView tracta la sessió com un intent de hacking i la interromp amb un missatge. Cal posar un límit raonable entre l'ample de banda i els  bytes descarregats del servidor. Podeu desactivar-la posant l'interval de temps a 0.";
$pgv_lang["META_AUTHOR"]		= "METAetiqueta de l'autor";
$pgv_lang["META_AUTHOR_help"]	= "~#pgv_lang[META_AUTHOR]#~<br /><br />El contingut a posar a la meta-etiqueta d'autor a la capçalera de la pàgina HTML. Deixant-ho en blanc agafa, per a aquest efecte, el nom complet del #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_AUTHOR_descr"]	= "Deixeu aquest camp en blanc si voleu que hi surti el nom complet del  #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_PUBLISHER"]		= "METAetiqueta de l'editor";
$pgv_lang["META_PUBLISHER_help"]	= "~#pgv_lang[META_PUBLISHER]#~<br /><br />El contingut a posar a la meta-etiqueta d'editor a la capçalera de la pàgina HTML. Deixant-ho en blanc agafa, per a aquest efecte, el nom complet del #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_PUBLISHER_descr"]	= "Deixeu aquest camp en blanc si voleu que hi surti el nom complet del  #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_COPYRIGHT"]		= "METAetiqueta de Copyright";
$pgv_lang["META_COPYRIGHT_help"]	= "~#pgv_lang[META_COPYRIGHT]#~<br /><br />El contingut a posar a la meta-etiqueta de Copyrigh a la capçalera de la pàgina HTML. Deixant-ho en blanc agafa, per a aquest efecte, el nom complet del #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_COPYRIGHT_descr"]	= "Deixeu aquest camp en blanc si voleu que hi surti el nom complet del  #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_DESCRIPTION"]		= "METAetiqueta de descripció";
$pgv_lang["META_DESCRIPTION_help"]	= "~#pgv_lang[META_DESCRIPTION]#~<br /><br />El contingut a posar a la meta-etiqueta de descripció a la capçalera de la pàgina HTML. Deixant-ho en blanc agafa, per a aquest efecte, el títol de la base de dades activa.";
$pgv_lang["META_DESCRIPTION_descr"]	= "Deixeu aquest camp en blanc si voleu que hi surti el títol de la base de dades activa.";
$pgv_lang["META_PAGE_TOPIC"]		= "METAetiqueta d'assumpte";
$pgv_lang["META_PAGE_TOPIC_help"]	= "~#pgv_lang[META_PAGE_TOPIC]#~<br /><br />El contingut a posar a la meta-etiqueta d'assumpte a la capçalera de la pàgina HTML. Deixant-ho en blanc agafa, per a aquest efecte, el títol de la base de dades activa.";
$pgv_lang["META_PAGE_TOPIC_descr"]	= "Deixeu aquest camp en blanc si voleu que hi surti el títol de la base de dades activa.";
$pgv_lang["META_AUDIENCE"]		= "METAetiqueta de públic";
$pgv_lang["META_AUDIENCE_help"]	= "~#pgv_lang[META_AUDIENCE]#~<br /><br />El contingut a posar a la meta-etiqueta d'audiència a la capçalera de la pàgina HTML";
$pgv_lang["META_PAGE_TYPE"]		= "METAetiqueta de tipus de pàgina";
$pgv_lang["META_PAGE_TYPE_help"]	= "~#pgv_lang[META_PAGE_TYPE]#~<br /><br />El contingut a posar a la meta-etiqueta de tipus de pàgina a la capçalera de la pàgina HTML.";
$pgv_lang["META_ROBOTS"]		= "METAetiqueta de robots";
$pgv_lang["META_ROBOTS_help"]	= "~#pgv_lang[META_ROBOTS]#~<br /><br />El contingut a posar al la meta-etiqueta de robots a la capçalera de la pàgina HTML. Alguns robots o motors de recerca web ignoren aquest contingut.";
$pgv_lang["META_REVISIT"]		= "Freqüència amb que els motors de recerca tornaran a visitar les METAetiquetes";
$pgv_lang["META_REVISIT_help"]	= "~#pgv_lang[META_REVISIT]#~<br /><br />El valor a posar a la meta-etiqueta de re-visita a la capçalera de la pàgina HTML. Alguns motors de recerca l'ignoren.";
$pgv_lang["META_KEYWORDS"]		= "METAetiqueta de paraules clau";
$pgv_lang["META_KEYWORDS_help"]	= "~#pgv_lang[META_KEYWORDS]#~<br /><br />El contingut a posar al la meta-etiqueta de paraules clau a la capçalera de la pàgina HTML. Alguns motors de recerca fan servir les paraules clau com a índex d'ajuda de la pàgina.<br /><br />La llista #pgv_lang[common_surnames]# que surt al bloc #pgv_lang[gedcom_stats]#  de la vostra pàgina d'inici també podreu afegir-la automàtica i opcionalment al que entreu aquí.";
$pgv_lang["META_TITLE"]		= "Afegeix-ho a l'etiqueta de capçalera TÍTOL";
$pgv_lang["META_TITLE_help"]	=	"~#pgv_lang[META_TITLE]#~<br /><br />Quelcom entrat en aquesta línea s'afegirà a l'etiqueta de TÍTOL de la capçalera de la pàgina HTML, desprès del títol de pàgina regular i abans dels crèdits PhpGedView.";

$pgv_lang["ENABLE_RSS"]				= "Activa RSS";
$pgv_lang["ENABLE_RSS_help"]		= "~#pgv_lang[ENABLE_RSS]#~<br /><br />Aquesta opció us permet desactivar la funció RSS.<br /><br />La subscripció de fils RSS permet als usuaris monitoritzar els canvis de la pàgina índex del vostre lloc web sense que els calgui visitar-la periòdicament. Si molts usuaris fan servir aquesta funció o si la freqüència de refresc d'aquests usuaris és molt alta, l'RSS pot consumir molt ample de banda i capacitat del servidor.<br /><br />Aquest <a href='http://en.wikipedia.org/wiki/RSS_(file_format)' target='_blank' alt='article Wikipedia' title='article Wikipedia'><b>Artícle Wikipedia</b></a> conté informació i enllaços sobre l'RSS i els seus diferents formats.";
$pgv_lang["RSS_FORMAT"]				= "Format RSS";
$pgv_lang["RSS_FORMAT_help"]		= "~#pgv_lang[RSS_FORMAT]#~<br /><br />El format RSS que es farà servir per defecte al lloc. Els sufixes numèrics <u>no</u> indiquen la versió: identifiquen formats. Per exemple, RSS 2.0 no és més nou que l'RSS 1.0, però té un format diferent. Els lectors de fils poden llegir qualsevol format.<br /><br />Aquests <a href='http://en.wikipedia.org/wiki/RSS_(file_format)' target='_blank' alt='article Wikipedia' title='article Wikipedia article'><b>article Wikipedia</b></a> conté informació i enllaços sobre l'RSS i els seus diversos formats.";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE"] = "Comprova si es poden descarregar els fitxers GEDCOM";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE_help"] = "~#pgv_lang[SECURITY_CHECK_GEDCOM_DOWNLOADABLE]#~<br /><br />Per qüestions de seguretat els fitxers GEDCOM no han d'ésser en un lloc on puguin descarregar-se directament, saltant-se els controls de privadesa. Polsant aquest enllaç es comprova si els vostres fitxers GEDCOM poden descarregar-se des de la xarxa.<br /><br />És conegut que en alguns sistemes aquesta comprovació pot portar molt de temps o no acabar mai de completar-se. Si és el vostre cas, apunteu directament amb el navegador al vostre fitxer GEDCOM, per veure si podeu baixar-vos-el.";
$pgv_lang["gedcom_download_secure"]	= "El #GEDCOM# no pot descarregar-se.";

$pgv_lang["welcome_new_help"]		= "~#pgv_lang[welcome_new]#~<br /><br />Si esteu veient aquesta pàgina, vol dir que heu instal·lat correctament el PhpGedView al vostre servidor i esteu a punt per començar a configurar-lo d'acord amb els vostres requeriments.<br /><br />Aquesta pàgina d'ajuda us guiarà a través del procés de configuració. Tal com aneu entrant en diferents camps, aquesta finestra us fornirà informació d'ajuda sobre el camp on esteu. Podeu tancar aquesta finestra. Per tornar-la a obrir polseu algun dels <b>#pgv_lang[qm]#</b> interrogants al costat de l'etiqueta del camp.";
$pgv_lang["return_editconfig"]		= "Podeu retornar a aquesta configuració en qualsevol moment adreçant el vostre navegador a <i>editconfig.php</i> o be polsant l'enllaç de <b>Configuració</b> de la pàgina <b>Administració PhpGedView</b>";
$pgv_lang["return_editconfig_gedcom"]	= "Podeu retornar a aquesta configuració en qualsevol moment, polsant l'enllaç <b>Editar</b> a la taula <b>#pgv_lang[current_gedcoms]#</b> de la pàgina <b>#pgv_lang[gedcom_adm_head]#</b> o apuntant amb el vostre navegador a <i>editconfig_gedcom.php</i>.";
$pgv_lang["save_config"] 				= "Desa la configuració";
$pgv_lang["download_gedconf"]				= "Baixa la configuració GEDCOM.";
$pgv_lang["not_writable"]				= "Hem detectat que el PHP no pot escriure al vostre fitxer de configuració. Podeu fer servir el botó <b>#pgv_lang[download_file]#</b> per desar els vostres paràmetres en un fitxer que pugueu carregar manualment.";
$pgv_lang["upload_to_index"]				= "Carregueu el fitxer al vostre directori índex:";
$pgv_lang["import_sql"]			= "S'han detectat fitxers SQL al vostre directori índex. Si han sigut originats per #pgv_lang[um_header]#, teniu l'opció d'importar la informació a la base de dades. Voleu intentar importar aquest fitxers a la base de dades ara? Tota la informació relativa al usuaris ( (usuaris, notícies, favorits, formats de blocs i missatges) de la vostra base de dades es perdrà.<br /><br />Si opteu per procedir, el PhpGedView provarà d'importar les dades. Si no funciona, se us demanarà per obrir el compte del primer administrador.";

//-- edit privacy messages
$pgv_lang["edit_privacy"]				= "Edita privadesa";
$pgv_lang["edit_privacy_title"]			= "Edita els paràmetres de privadesa GEDCOM";
$pgv_lang["save_changed_settings"]			= "Desa els canvis";
$pgv_lang["add_new_pp_setting"]			= "Afegiu una nova configuració de privadesa total per ID de persona";
$pgv_lang["add_new_up_setting"]			= "Afegiu una nova configuració de privadesa per al nom d'usuari";
$pgv_lang["add_new_gf_setting"]			= "Afegiu una nova configuració de privadesa global de fets";
$pgv_lang["add_new_pf_setting"]			= "Afegiu una nova configuració de privadesa de fets per ID de persona";
$pgv_lang["file_read_error"]				= "E R R O R !!! No es por llegir el fitxer de privadesa!";
$pgv_lang["edit_exist_person_privacy_settings"]	= "Editeu la configuració existent de privadesa total per ID de persona";
$pgv_lang["edit_exist_user_privacy_settings"]	= "Editeu la configuració existent de privadesa per al nom d'usuari";
$pgv_lang["edit_exist_global_facts_settings"]	= "Editeu la configuració existent de privadesa global de fets";
$pgv_lang["edit_exist_person_facts_settings"]	= "Editeu la configuració existent de privadesa de fets per ID de persona";
$pgv_lang["general_privacy"]			= "Paràmetres generals de privadesa";
$pgv_lang["general_privacy_help"]		= "~#pgv_lang[general_privacy]#~<br /><br />Podeu tenir diferents paràmetres de privadesa per cada GEDCOM del vostre lloc web PhpGedView. Comproveu sota el títol de la pàgina si esteu editant el GEDCOM correcte.<br /><br />Podeu saltar-vos aquests paràmetres general de privadesa fent servir els formularis de privadesa a la pàgina #pgv_lang[edit_privacy_title]# .<br /><br />#pgv_lang[more_help_advice]#";
$pgv_lang["person_privacy"]				= "Configuració de privadesa total per ID de persona";
$pgv_lang["person_privacy_help"]			= "~#pgv_lang[person_privacy]#~<br /><br />Aquest paràmetre permeten als administradors saltar-se els que hi ha per defecte per a una persona, família, font o objecte multimèdia en particular.<br /><br />Suposem, per exemple, que teniu un nen que ha mort durant la infantesa. Habitualment, donat que el nen és mort, els seus detalls personals els veurà el públic usuari. Tanmateix les dades de la vostra família romanen privades. No voleu eliminar el registre de defunció però voleu fer que els detalls de l'infant restin privats. Si aquest nen té l'ID I100 podeu entrar el següent paràmetre de privadesa:<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I100<br />&nbsp;&nbsp;&nbsp;#pgv_lang[accessible_by]#:&nbsp;&nbsp;#pgv_lang[PRIV_USER]#<br /><br />Això funciona també al inrevés. Si voleu fer públics els detalls d'algu (ID I101) que sabeu positivament que és difunt, però en desconeixeu la data, podeu afegir el següent:<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I101<br />&nbsp;&nbsp;&nbsp;#pgv_lang[accessible_by]#:&nbsp;&nbsp;#pgv_lang[PRIV_PUBLIC]#";
$pgv_lang["user_privacy"]				= "Configuració de privadesa per al nom d'usuari";
$pgv_lang["user_privacy_help"]			= "~#pgv_lang[user_privacy]#~<br /><br />Aquests paràmetres donen als administradors la possibilitat de saltar-se els que hi ha per defecte per a persones al GEDCOM, en base als noms d'usuari. Suposem que no voleu que el nom d'usuari <b>Joan</b> pugui veure qualsevol detall de l'ID I100. Per fer-ho podeu configurar quelcom com això:<br />&nbsp;&nbsp;&nbsp;Nom d'usuari:&nbsp;&nbsp;Joan<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I100<br />&nbsp;&nbsp;&nbsp;#pgv_lang[show_question]#:&nbsp;&nbsp;#pgv_lang[hide]#<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;i els detalls de la persona especificada quedaran ocults per al nom d'usuari \"Joan\" solament.<br /><br />Per mostrar els detalls de I101 (que regularment restarien ocults perquè és viu) al nom d'usuari \"Joan\" poseu:<br />&nbsp;&nbsp;&nbsp;Nom d'usuari:&nbsp;&nbsp;Joan<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I101<br />&nbsp;&nbsp;&nbsp;#pgv_lang[show_question]#:&nbsp;&nbsp;#pgv_lang[show]#";
$pgv_lang["global_facts"]				= "Configuració de privadesa global de fets";
$pgv_lang["global_facts_help"]			= "~#pgv_lang[global_facts]#~<br /><br />Aquests paràmetres defineixen esdeveniments que s'ocultaran globalment per a totes les persones del GEDCOM. Això solament s'aplica al nivell 1del registre d'esdeveniments, com per exemple BIRT (Naixement) o DEAT (Mort), que apareixen a les pròpies capçaleres #pgv_lang[personal_facts]# de la pàgina <i>#pgv_lang[personal_details]#</i>.<br /><ul><li>L'element <b>#pgv_lang[name_of_fact]#</b> determina quins esdeveniments s'ocultaran.</li><li>L'element <b>#pgv_lang[choice]#</b> especifica si el propi esdeveniment o els detalls relatius.</li><li>L'element <b>#pgv_lang[accessible_by]#</b>  determina a quin nivell d'accés es permetrà veure l'esdeveniment.</li></ul><br />Aquesta característica existeix per ocultar certs esdeveniments, identificats per etiquetes GEDCOM, per a totes les persones vives o difuntes. Per defecte l'etiqueta SSN és opaca al públic usuari. Es fa per preservar la gent de furts de números de la seguretat social i suplantació de personalitat de difunts. Això és el més rellevant pel que fa als EUA.<br /><br />Si voleu ocultar al públic usuari tots els casaments del vostre GEDCOM heu de posar:<br />&nbsp;&nbsp;&nbsp;#pgv_lang[name_of_fact]#: (MARR) - Casament<br />&nbsp;&nbsp;&nbsp;#pgv_lang[choice]#: #pgv_lang[fact_details]#<br />&nbsp;&nbsp;&nbsp;#pgv_lang[accessible_by]#: #pgv_lang[PRIV_USER]#<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Aquests paràmetres amagarien els matrimonis i els detalls relacionats amb els visitants que no hagin iniciat la sessió.<br /><br />A diferència de tots els altres paràmetres, a <b>#pgv_lang[edit_exist_global_facts_settings]#</b> podeu ocultar esdeveniments fins i tot a usuaris administradors. Els esdeveniments no desitjats es suprimeixen completament.";
$pgv_lang["person_facts"]				= "Configuració de privadesa de fets per ID de persona";
$pgv_lang["person_facts_help"]			= "~#pgv_lang[person_facts]#~<br /><br />Aquests paràmetres defineixen els esdeveniments que s'ocultaran d'una determinada persona, família o font i el nivell al que restaran ocults. Això solament s'aplica al nivell 1 de registres d'esdeveniments com NAIXEMENT o DEFUNCIÓ, que apareixen a les pròpies capçaleres de la pàgina de detalls rellevants de la persona, família o font.<br /><br />El primer element és l'ID de la persona, família o font. El segon és l'esdeveniment. L'element <b>#pgv_lang[choice]#</b> especifica si l'esdeveniment en si mateix o els seus detalls relatius. L'element <b>#pgv_lang[accessible_by]#</b> determina a quin nivell d'accés es mostrarà l'esdeveniment. No tots els esdeveniments que surten a la llista son aplicables a tot tipus d'IDs. Per exemple, Naixement i Defunció no son rellevants pels registres de fonts.<br /><br />Aquesta llista és similar a la llista <b>#pgv_lang[global_facts]#</b>, tret que també especifiqueu l'identificador GEDCOM de la persona per a la qual voleu amagar els fets. Podeu, per exemple, ocultar el registre de casament d'una persona en concret.";
$pgv_lang["accessible_by"]				= "Mostrar-ho a?";
$pgv_lang["hide"]						= "Oculta";
$pgv_lang["show_question"]				= "Mostrar-ho?";
$pgv_lang["user_name"]					= "Nom d'usuari";
$pgv_lang["name_of_fact"]				= "Nom de l'esdeveniment";
$pgv_lang["choice"]					= "Elecció";
$pgv_lang["fact_show"]					= "Mostra l'esdeveniment";
$pgv_lang["fact_details"]				= "Mostra els detalls de l'esdeveniment";
$pgv_lang["privacy_header"]				= "Edita paràmetres de privadesa";
$pgv_lang["unable_to_find_privacy_indi"]		= "No s'ha trobat cap persona amb l'ID";
$pgv_lang["save_and_import"]				= "Desprès de desar aquesta configuració del GEDCOM us caldrà importar el GEDCOM polsant el botó <b>Importa GEDCOM</b> o anant a <b>Administració --> Gestiona Gedcoms --> Importa</b>";
$pgv_lang["help_info"]					= "Podeu disposar d'ajuda per a cada ítem polsant el <b>#pgv_lang[qm]#</b> vermell del costat de l'etiqueta de cada cel·la.";
$pgv_lang["SHOW_LIVING_NAMES"]			= "Mostra els noms dels vius";
$pgv_lang["SHOW_LIVING_NAMES_help"]			= "~#pgv_lang[SHOW_LIVING_NAMES]#~<br /><br />Han de mostrar-se els noms de les persones vives al públic?<br /><br />Normalment aquest paràmetre seria «#pgv_lang[PRIV_USER]#». Això serveix per protegir la privadesa de les persones vives a la vostra base de dades, ja que podeu determinar a qui doneu accés general a les vostres dades de genealogia.<br /><br />La configuració «#pgv_lang[PRIV_NONE]#» impedeix mostrar els noms de persones vives per a usuaris que no tenen drets d'administrador.";
$pgv_lang["SHOW_RESEARCH_ASSISTANT"]			= "Mostra l'assistent de recerca";
$pgv_lang["SHOW_RESEARCH_ASSISTANT_help"]		= "~#pgv_lang[SHOW_RESEARCH_ASSISTANT]#~<br /><br />Quin tipus d'usuari pot veure el mòdul de l'assistent de recerca si es que és instal·lat?";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]		= "Activa la privadesa de parentiu";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]	= "~#pgv_lang[USE_RELATIONSHIP_PRIVACY]#~<br /><br /><b>#pgv_lang[no]#</b> fa que els usuaris autenticats (que hagin efectuat l'accés) puguin veure els detalls de les persones vives. <b>#pgv_lang[yes]#</b> fa que solament puguin veure la de persones amb les que hi estiguin emparentats.<br /><br />Aquesta opció fixa el paràmetre per defecte per a tots els usuaris que tinguin accés a la base de dades genealògica. L'administrador pot saltar-se'l per a usuaris individualment, editant els detalls del seu compte.";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]		= "Grau màxim de llunyania de parentiu";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]	= "~#pgv_lang[MAX_RELATION_PATH_LENGTH]#~<br /><br />Si hi ha activada l'opció <i>#pgv_lang[USE_RELATIONSHIP_PRIVACY]#</i>, els usuaris amb accés podran veure o editar persones fins aquest nombre de graus de parentiu.<br /><br />Aquesta opció fixa el paràmetre per defecte per a tots els usuaris amb accés a la base de dades genealògica. L'administrador por saltar-se'l per a usuaris individualment editant els detalls del seu compte.";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]		= "Comprova parentiu per casament";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]	= "~#pgv_lang[CHECK_MARRIAGE_RELATIONS]#~<br /><br />Comprova el parentiu pervingut per casament.";
$pgv_lang["SHOW_DEAD_PEOPLE"]				= "Mostra les persones difuntes";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]			= "~#pgv_lang[SHOW_DEAD_PEOPLE]#~<br /><br />Posa el nivell de privadesa d'accés per a tota la gent difunta.";
$pgv_lang["select_privacyfile_button"]		= "Seleccioneu fitxer de privadesa";
$pgv_lang["PRIVACY_BY_YEAR"]		= "Limita la privadesa per l'antiguitat de l'esdeveniment";
$pgv_lang["PRIVACY_BY_YEAR_help"]	= "~#pgv_lang[PRIVACY_BY_YEAR]#~<br /><br />El paràmetre <b>#pgv_lang[PRIVACY_BY_YEAR]#</b> ocultarà els detalls de la gent basant-se llur antiguitat, a banda de si és viva o morta.<br /><br />Feu servir aquest paràmetre juntament amb el de <b>#pgv_lang[MAX_ALIVE_AGE]#</b>. Per exemple, si poseu l'edat a 100 i aquesta opció a <b>#pgv_lang[yes]#</b>, totes les persones, vives o mortes, nascudes fa menys de 100 anys esdevindran privades. Gent que s'hagi casat fa menys de 85 anys i gents que hagi mort fa menys de 75 anys, també es marcaran com a privada. Tingueu en compte que amb aquesta opció pot alentir-se el funcionament.";

//-- language edit utility
$pgv_lang["lang_edit_help"]			= "~#pgv_lang[translator_tools]#~<br /><br />Aquesta pàgina és pensada per a que la facin servir els traductors. Podeu traduir, comprar i exportar fitxers d'idioma. Hi ha també una opció per ajudar els traductors a determinar l'origen del text que va sortint pel PhpGedView.<br /><br />Podeu emprar les següents opcions i utilitats:";
$pgv_lang["edit_langdiff"]				= "Edita i configura fitxers d'idioma";
$pgv_lang["bom_check"]		= "Comprovació de la marca d'ordre de bytes (BOM en anglès)";
$pgv_lang["bom_check_help"]		= "~#pgv_lang[bom_check]#~<br /><br />#pgv_lang[bom_check_desc]#";
$pgv_lang["bom_check_desc"]		= "Aquesta comprovació analitza els fitxers d'idioma per localitzar-hi marques d'ordre de bytes (BOM Byte Order Mark, en anglès). Si en troba, les treu del fitxer afectat. Aquests caràcters especials poden causar un funcionament incorrecte en algunes parts del PhpGedView.";
$pgv_lang["lang_debug"]			= "Opció de depuració del text d'ajuda";
$pgv_lang["lang_debug_help"]	= "~#pgv_lang[lang_debug]#~<br /><br />#pgv_lang[lang_debug_desc]#";
$pgv_lang["lang_debug_desc"]	= "Quan activeu aquesta opció, els noms de les variable d'idioma que es fan servir al textos d'ajuda, sortiran a la finestra d'ajuda. Això guia als traductors per determinar el significat de la variable quan cal ajustar al text.<br /><br />Aquest paràmetre solament és vàlid durant la vostra sessió normal de PhpGedView.";
$pgv_lang["lang_debug_use"]		= "Utilitza la opció de depuració de text";
$pgv_lang["bom_not_found"]		= "No s'han localitzat marques d'ordre de bytes.";
$pgv_lang["bom_found"]			= "S'han localitzat marques d'ordre de bytes a";
$pgv_lang["edit_lang_utility"]			= "Eina d'edició d'idiomes";
$pgv_lang["edit_lang_utility_help"]			= "~#pgv_lang[edit_lang_utility]#~<br /><br />#pgv_lang[edit_lang_utility_desc]#";
$pgv_lang["edit_lang_utility_desc"]	= "Podeu fer servir aquesta eina per editar el contingut d'un fitxer d'idioma emprant el de l'anglès.<br /><br />Veureu el contingut de l'original anglès i el del mateix fitxer de l'idioma escollit. Polsant el text que surt sota de la versió anglesa, s'obrirà una finestra on podreu modificar-lo. Podreu desar els canvis o cancel·lar-los.";
$pgv_lang["edit_lang_utility_warning"]	= "ATENCIÓ!<br /><br />Si feu servir el botó <b>#pgv_lang[close_window_without_refresh]#</b>, no podreu veure el que heu canviat per pantalla mentre que no feu una actualització o recàrrega de pàgina manual. És possible que el vostre fitxer d'idioma es malmeti si afegiu un missatge que encara no sigui dins del fitxer o si en reediteu un que ja hagueu fet directament abans.<br /><br />Si no esteu ben segur del que esteu fent, no feu servir el botó <b>#pgv_lang[close_window_without_refresh]#</b>.";
$pgv_lang["language_to_edit"]				= "Idioma a editar";
$pgv_lang["language_to_edit_help"]		= "~#pgv_lang[language_to_edit]#~<br /><br />En aquesta finestra heu de seleccionar l'idioma quins textos voleu editar.";
$pgv_lang["file_to_edit"]				= "Tipus de fitxer d'idioma a editar";
$pgv_lang["file_to_edit_help"]			= "~#pgv_lang[file_to_edit]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["lang_file_descriptions"]		= "El PhpGedView ha implementat suport per a molt diversos idiomes. Això s'ha aconseguit posant tot el text visible als usuaris en fitxers completament separats del programa principal. Hi ha un joc de vuit fitxers per cada idioma suportat i els diversos textos s'han repartit entre aquests fitxers d'acord amb llur funció. <b>No cal disposar de tots els fitxers d'idiomes.</b> Quan un text determinat no està disponible traduït, el PhpGedView farà servir sempre la versi anglesa.<br /><br />Els fitxers que conformen el joc de cada idioma son:<ul><li><b><i>admin.xx.php</i></b>&nbsp;&nbsp;Conté els termes i expressions comunes que es fan servir durant l'administració del PhpGedView i les bases de dades genealògiques.</li><br /><li><b><i>configure_help.xx.php</i></b>&nbsp;&nbsp;Conté el text d'ajuda durant la configuració del PhpGedView. No està pensat per a que el visionin els usuaris ordinaris.</li><br /><li><b><i>countries.xx.php</i></b>&nbsp;&nbsp;s un llistat de noms de països presa del lloc Web de la Divisió d'Estadística del Departament d'Economia i Afers Socials de les Nacions Unides. Heus aquí l'<a href=\"http://unstats.un.org/unsd/methods/m49/m49alpha.htm\" target=\"_blank\"><b>enllaç</b></a> a la llista en anglès.  També és disponible en francès.</li><br /><li><b><i>editor.xx.php</i></b>&nbsp;&nbsp;Conté els termes i expressions comuns a emprar durant l'edició o entrades a les bases de dades genealògiques.</li><br /><li><b><i>facts.xx.php</i></b>&nbsp;&nbsp;Conté les equivalències textuals als codis d'esdeveniments GEDCOM basats en l'estàndard GEDCOM 5.5.1. També conté codis d'esdeveniments addicionals que no figuren a l'estàndard però que els fan servir diversos programes genealògics.<br /><br />Podeu baixar-vos una còpia en angles de l'<a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\"><b>Estàndard GEDCOM 5.5.1</b></a> en PDF (Portable Document Format).</li><br /><li><b><i>faqlist.xx.php</i></b>&nbsp;&nbsp;És un joc de <b>f</b>requently <b>a</b>sked <b>q</b>uestions (preguntés més freqüents) que ha recollit l'equip de desenvolupament del PhpGedView. Cada FAQ té dues entrades en aquest fitxer. Una és la capçalera (generalment la pregunta), i l'altra el cos (generalment la resposta). Els recanvis pels fitxers <b><i>faqlist.xx.php</i></b>, que s'han d'actualitzar sovint, poden descarregar-se del lloc web PhpGedView.<br /><br />L'administrador pot fer servir les qüestions d'aquesta llista per a fer-se'n una d'específica per al seu lloc.</li><br /><li><b><i>help_text.xx.php</i></b>&nbsp;&nbsp;Conté els textos d'ajuda per als usuaris ordinaris. Algunes entrades d'aquest fitxer van adreçades a les necessitats dels administradors i restaran ocultes als usuaris que no disposin de privilegis d'administració.</li><br /><li><b><i>lang.xx.php</i></b>&nbsp;&nbsp;Aquest fitxer conté molts termes i expressions comunes.</li></ul><br />El PhpGedView també suporta un novè i opcional fitxer d'idioma anomenat, <b><i>extra.xx.php</i></b>. Es carrega sempre desprès de tots els altres i forneix la forma de com l'administrador del lloc pot saltar-se o alterar qualsevol text estàndard de l'idioma seleccionat. També pot utilitzar-se per fornir un títol per a les bases de dades genealògiques que variï segons l'idioma escollit.<br /><br />Els continguts d'aquest depenen completament de l'administrador del lloc; <b>mai</b> a ha distribuir-se amb cap versió de PhpGedView. L'administrador no ha de fer mai canvis als fitxers estàndard d'idiomes; tots els canvis locals s'han de concentrar en aquest fitxer opcional.";
$pgv_lang["check"]			= "Comprova";
$pgv_lang["lang_save"]					= "Desa";
$pgv_lang["contents"]					= "Continguts";
$pgv_lang["listing"]					= "Llistant";
$pgv_lang["no_content"]					= "No hi ha contingut";
$pgv_lang["editlang"]			= "Edita";
$pgv_lang["editlang_help"]				= "~#pgv_lang[editlang]#~<br /><br />Edita el text del fitxer d'idioma.";
$pgv_lang["savelang"]			= "Desa";
$pgv_lang["savelang_help"]				= "~#pgv_lang[savelang]#~<br /><br />Desa el text editat al fitxer d'idioma.";
$pgv_lang["original_message"]				= "Missatge original";
$pgv_lang["message_to_edit"]				= "Missatge a editar";
$pgv_lang["changed_message"]				= "Contingut canviat";
$pgv_lang["message_empty_warning"]			= "-> Compte!!! Aquest missatge és buit al fitxer [#LANGUAGE_FILE#] <-";
$pgv_lang["language_to_export"]			= "Idioma a exportar";
$pgv_lang["language_to_export_help"]		= "~#pgv_lang[language_to_export]#~<br /><br />Des d'aquesta llista podeu seleccionar l'idioma i els fitxers d'idioma el text del qual voleu exportar.<br /><br />La sortida és un fitxer HTML que podeu imprimir des del navegador.";
$pgv_lang["export_lang_utility"]			= "Utilitat d'exportació d'idiomes";
$pgv_lang["export"]					= "Exporta";
$pgv_lang["export_lang_utility_help"]		= "~#pgv_lang[export_lang_utility]#~<br /><br />#pgv_lang[export_lang_utility_desc]#";
$pgv_lang["export_lang_utility_desc"]	= "Podeu crear documentació per a administradors.<br /><br />Aquesta utilitat produirà una versió HTML del fitxer d'idioma seleccionat. Podeu utilitzar el navegador per mirar aquest fitxer, formatat per imprimir.";
$pgv_lang["export_ok"]			= "S'ha exportat el text de l'idioma";
$pgv_lang["compare_lang_utility"]			= "Utilitat de comparació d'idiomes";
$pgv_lang["compare_lang_utility_help"]		= "~#pgv_lang[compare_lang_utility]#~<br /><br />#pgv_lang[compare_lang_utility_desc]#";
$pgv_lang["compare_lang_utility_desc"]	= "Aquesta eina compara dos jocs de fitxers d'idiomes per a produir un llistat d'addicions i subtraccions entre sí.<br /><br />Cal fer servir els fitxers anglesos com a referència de tots els altres.";
$pgv_lang["new_language"]				= "Idioma font";
$pgv_lang["new_language_help"]			= "~#pgv_lang[new_language]#~<br /><br />De la llista d'aquest caixetí en podeu seleccionar l'idioma quins textos voleu comparar amb els d'un altre.<br /><br />Tots els canvis i addicions als fitxers d'idioma es fan primerament en l'idioma <b>anglès</b>, per això normalment heu de seleccionar l'anglès com un dels idiomes a comparar.";
$pgv_lang["old_language"]				= "Idioma secundari";
$pgv_lang["old_language_help"]			= "~#pgv_lang[old_language]#~<br /><br />D'aquesta llista podeu escollir  l'idioma que vulgueu comparar amb el seleccionat a la llista de la finestra <b>#pgv_lang[new_language]#</b><br /><br />Un cop l'hàgiu escollit, polseu el botó <b>Compara</b> per obtenir un llistat d'addicions i subtraccions entre els fitxers d'ambdós idiomes.<br /><br />Per refrescar-vos la memòria:<br /><b>Addició</b> vol dir: És <u>al</u> fitxer font, però <u>no</u> al fitxer secundari.<br /><br /><b>Subtracció</b> vol dir: <u>No</u> és al fitxer font, però <u>és</u> al secundari. Això passa quan un text determinat ja no es fa servir i conseqüentment s'ha eliminat de la versió anglesa de fitxers. Podeu eliminar amb tranquil·litat el text del fitxer de l'idioma secundari.";
$pgv_lang["compare"]					= "Compara";
$pgv_lang["comparing"]					= "Fitxers d'idiomes comparats";
$pgv_lang["additions"]					= "Addicions";
$pgv_lang["no_additions"]				= "Sense addicions";
$pgv_lang["subtractions"]				= "Subtraccions";
$pgv_lang["no_subtractions"]				= "Sense subtraccions";
$pgv_lang["config_lang_utility"]			= "Configuració d'idiomes suportats";
$pgv_lang["config_lang_utility_help"]		= "~#pgv_lang[config_lang_utility]#~<br /><br />Aquesta pàgina es fa servir per controlar quines opcions d'idioma tenen disponibles els vostres usuaris. Per exemple, podeu configurar-la de tal forma que solament estiguin disponibles l'alemany i el francès. Això serà adequat si no us cal comunicar-vos amb els vostres usuaris en hongarès.<br /><br />Podeu també fer servir aquesta pàgina per modificar certs aspectes del PhpGedView que depenen de l'idioma seleccionat. Per exemple, aquí és on dieu al PhpGedView com formatar els camps de data i hora.<br /><br />Els idiomes actius que tenen el caixetí grisós no poden desactivar-se perquè s'estan fent servir. Mireu al capdavall de la pàgina per veure quins idiomes  es fan servir. Quan un idioma ja no es fa servir més pel GEDCOM o pels usuaris, podeu desactivar-lo.<br /><br />Tots els canvis es desen en un nou fitxer anomenat  <i>language_settings.php</i> creat al directori <b>#INDEX_DIRECTORY#</b>. Qualsevol canvi es farà en aquest nou fitxer i el PhpGedView farà servir solament <u>aquest</u> fitxer. Podeu tornar als paràmetres originals per defecte esborrant aquest fitxer.<br /><br />Si us cal comunicar problemes amb els vostres paràmetres d'idioma, contacteu amb l'equip de suport de PhpGedView tant si aquest fitxer és present con si no.";
$pgv_lang["active"]					= "Actiu";
$pgv_lang["active_help"]				= "~#pgv_lang[active]#~<br /><br />Permet als usuaris seleccionar aquest idioma si hi ha activa l'opció <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b>.";
$pgv_lang["edit_settings"]				= "Edita els paràmetres";
$pgv_lang["lang_edit"]					= "Edita";
$pgv_lang["lang_language"]				= "Idioma";
$pgv_lang["export_filename"]				= "Nom del fitxer de sortida:";
$pgv_lang["lang_back"]					= "Torna al menú principal per editar i configurar fitxers d'idioma";
$pgv_lang["lang_back_admin"]				= "Torna al menú d'Administració";
$pgv_lang["lang_back_manage_gedcoms"]	= "Torna al menú de gestió de GEDCOM";
$pgv_lang["lang_name_arabic"]		= "Aràbic";
$pgv_lang["lang_name_catalan"]			= "Català";
$pgv_lang["lang_name_chinese"]		= "Xinès (tradicional)";
$pgv_lang["lang_name_chinese-cn"]	= "Xinès (simplificat)";
$pgv_lang["lang_name_croatian"]		= "Croata";
$pgv_lang["lang_name_czech"]		= "Txec";
$pgv_lang["lang_name_danish"]				= "Danès";
$pgv_lang["lang_name_dutch"]				= "Holandès";
$pgv_lang["lang_name_english"]			= "Anglès";
$pgv_lang["lang_name_estonian"]		= "Estonià";
$pgv_lang["lang_name_finnish"]		= "Finès";
$pgv_lang["lang_name_french"]				= "Francès";
$pgv_lang["lang_name_german"]				= "Alemany";
$pgv_lang["lang_name_greek"]		= "Grec";
$pgv_lang["lang_name_hebrew"]				= "Hebreu";
$pgv_lang["lang_name_hungarian"]	= "Hongarès";
$pgv_lang["lang_name_indonesian"]	= "Indonesi";
$pgv_lang["lang_name_italian"]			= "Italià";
$pgv_lang["lang_name_lithuanian"]	= "Lituà";
$pgv_lang["lang_name_norwegian"]			= "Noruec";
$pgv_lang["lang_name_polish"]				= "Polonès";
$pgv_lang["lang_name_portuguese"]			= "Portuguès";
$pgv_lang["lang_name_romanian"]		= "Romanès";
$pgv_lang["lang_name_russian"]			= "Rus";
$pgv_lang["lang_name_serbian-la"]	= "Serbi (alfabet llatí)";
$pgv_lang["lang_name_slovak"]		= "Eslovac";
$pgv_lang["lang_name_slovenian"]	= "Eslovè";
$pgv_lang["lang_name_spanish"]			= "Castellà";
$pgv_lang["lang_name_spanish-ar"]			= "Castellà (Amèrica Llatina)";
$pgv_lang["lang_name_swedish"]			= "Suec";
$pgv_lang["lang_name_turkish"]			= "Turc";
$pgv_lang["lang_name_vietnamese"]	= "Vietnamita";
$pgv_lang["lang_name_unknown"]		= "Cap d'aquestes llengües";		// used ONLY in "Find Special Characters"
$pgv_lang["lang_new_language"]		= "Nou Idioma";
$pgv_lang["original_lang_name"]			= "Nom original de l'idioma #D_LANGNAME#";
$pgv_lang["original_lang_name_help"]		= "~Nom original de la llengua~<br /><br />Com es diu aquest idioma en el seu llenguatge?<br /><br />L'anglès s'anomena a sí mateix <b>English</b>; l'alemany <b>Deutsch</b>; l'holandès <b>Nederlands</b>; el txec <b>Ceština</b>, etc.";
$pgv_lang["lang_shortcut"]				= "Acrònim per a fitxers d'idioma";
$pgv_lang["lang_shortcut_help"]			= "~#pgv_lang[lang_shortcut]#~<br /><br />Aquest codi defineix un acrònim pel nom de l'idioma. Aquesta abreviació forma part del nom de cada fitxer d'idioma que fa servir el PhpGedView. Per exemple, l'abreviació pel francès és <b>fr</b> i en conseqüència tots els nom de fitxer pel francès son <i>admin.<b>fr</b>.php</i>, <i>configure_help.<b>fr</b>.php</i>, <i>countries.<b>fr</b>.php</i>, <i>editor.<b>fr</b>.php</i>, <i>facts.<b>fr</b>.php</i>, <i>help_text.<b>fr</b>.php</i>, i <i>lang.<b>fr</b>.php</i>";
$pgv_lang["lang_langcode"]		= "Codis de detecció d'idioma";
$pgv_lang["lang_langcode_help"]		= "~#pgv_lang[lang_langcode]#~<br /><br />Aquests codis permeten al PhpGedView detectar el paràmetre d'idioma preferit que els navegadors estan utilitzant. El PhpGedView determina l'idioma que li està demanant el navegador comparant el codi d'idioma del navegador amb aquesta llista. Les entrades de la llista cal que vagin separades entre sí per punt i coma.";
$pgv_lang["lang_filenames"]		= "Fitxers d'idioma";
$pgv_lang["lang_filenames_help"]		= "~#pgv_lang[lang_filenames]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["flagsfile"]					= "Fitxer de la bandera";
$pgv_lang["flagsfile_help"]				= "~#pgv_lang[flagsfile]#~<br /><br />Nom de la imatge de la bandera nacional de l'idioma seleccionat.<br /><br />Podeu trobar imatges de la majoria de països a <a href=\"http://w3f.com/gifs/index.html\"><b>The WWWeb Factory</b></a>.<br /><br />Quan localitzeu la imatge de la bandera que voleu, polseu el botó dret del ratolí i deseu-la en un fitxer temporal. Desprès, obriu la imatge desada amb un editor apropiat (es recomana IrfanView per a sistemes Windows), reduïu-li la mida a 50x32 píxels, que és la que fa servir normalment el PhpGedView i deseu-la en format GIF a la carpeta <i><b>images/flags</b></i>. Podeu fer servir qualsevol nom.";
$pgv_lang["text_direction"]				= "Direcció del text";
$pgv_lang["text_direction_help"]			= "~#pgv_lang[text_direction]#~<br /><br />Identifica la direcció que es fa servir per escriure text en l'idioma escollit. Molts idiomes s'escriuen d'esquerra a dreta. L'aràbic i l'hebreu son exemples d'idiomes que s'escriuen en direcció contrària (dreta a esquerra).";
$pgv_lang["date_format"]				= "Format de la data";
$pgv_lang["date_format_help"]				= "~#pgv_lang[date_format]#~<br /><br />Aquest camp defineix el format de data que farà servir el PhpGedView quan en mostri des de la base de dades. Podeu escollir entre el format <b>Estàndard</b> o l'<b>Avançat</b> .<ul><li><b>Estàndard</b><br />Es fan servir els següents codis per representar els diferents elements de la data. Preneu nota que <b>D</b> i <b>M</b> tenen un altre sentit al format <b>Avançat</b>.<p style=\"padding-left: 25px\"><b>D</b>&nbsp;&nbsp;dia del mes, sense zeros de farciment; p.e. 1 a 31<br /><b>M</b>&nbsp;&nbsp;nom del mes; p.e. gener, febrer, etc.<br /><b>Y</b>&nbsp;&nbsp;any complet, per exemple, 1999 o 44A.C.<br /><b>R</b>&nbsp;&nbsp;Conversió de calendari. Mireu-vos l'entrada <b>Conversió de Calendari</b> a baix per la descripció d'aquest codi.</p>Aquest codis es poden combinar en qualsevol ordre, intercalar-hi espais i signes de puntuació. Per exemple, suposem que el vostre GEDCOM conté la data del 20&nbsp;AUG&nbsp;1965.<p style=\"padding-left: 25px\">Un usuari <b>anglès</b> posarà el format a <b>D&nbsp;M&nbsp;Y</b> per que surti <b>20&nbsp;August&nbsp;1965</b>.<br />Un usuari <b>americà</b> posarà el format a <b>M&nbsp;D,&nbsp;Y</b> per que surti <b>August&nbsp;20,&nbsp;1965</b><br />Un usuari <b>alemany</b> posarà el format a <b>D.&nbsp;M&nbsp;Y</b> per que surti <b>20.&nbsp;August&nbsp;1965</b><br />Un usuari <b>hongarès</b> posarà el format a <b>Y.&nbsp;M&nbsp;D.</b> per que surti <b>1965.&nbsp;augusztus&nbsp;20.</b></p><br /></li><li><b>Avançat</b><br />Disposa d'opcions de format més complexes. Si el vostre format de data inclou una lletra diferent de <b>D</b>, <b>M</b>, <b>Y</b>, o <b>R</b>, s'assumeix que esteu fent servir el format <b>Avançat</b>.<br /><br />Es fan servir els següents codis per representar els diferents elements de la data. Preneu nota que <b>D</b> i <b>M</b> tenen diferent sentit que al format <b>Estàndard</b>.<p style=\"padding-left: 25px\"><b>d</b>&nbsp;&nbsp;dia del mes, amb zeros de farciment; p.e. 01 a 31<br /><b>j</b>&nbsp;&nbsp;dia del mes, sense zeros de farciment; p.e. 1 a 31<br /><b>S</b>&nbsp;&nbsp;sufix ordinal pel número del dia; per exemple, les lletres <b>th</b> del <b>4th&nbsp;July</b>.<br /><b>l</b> (minúscula de «L»)&nbsp;&nbsp;dia de la setmana; p.e. dilluns, dimarts, dimecres, etc.<br /><b>D</b>&nbsp;&nbsp;dia de la setmana abreujat; p.e. Dil, Dmt, Dim, Dij, Div, Dis, Diu<br /><b>N</b>&nbsp;&nbsp;número ISO del dia; p.e. 0 a 6<br /><b>w</b>&nbsp;&nbsp;dia numèric; p.e. 1 a 7<br /><b>z</b>&nbsp;&nbsp;dia de l'any; p.e 1 a 365<br /><b>F</b>&nbsp;&nbsp;nom del mes; p.e. gener, febrer, etc.<br /><b>M</b>&nbsp;&nbsp;nom del mes abreujat, p.e. gen, feb, etc.<br /><b>m</b>&nbsp;&nbsp;número del mes amb zeros de farciment; p.e. 01 a 12<br /><b>n</b>&nbsp;&nbsp;número del mes sense zeros de farciment; p.e. 1 a 12<br /><b>Y</b>&nbsp;&nbsp;any complert, per exemple, 1999 o 44A.C.<br /><b>y</b>&nbsp;&nbsp;any abreujat. Alguns calendaris permeten abreujar l'any. Pel calendari jueu això es fa sense els milers. Pel gregorià és el mateix que per l'any sencer.<br /><b>R</b>&nbsp;&nbsp;Conversió de calendari. Mireu-vos l'entrada <b>Conversió de Calendari</b> de sota per a una descripció d'aquest codi.<br /><b>@&nbsp;A&nbsp;O&nbsp;E</b>&nbsp;&nbsp;format intern GEDCOM</p><p style=\"padding-left: 50px\"><b>@</b>&nbsp;&nbsp;codi de calendari, p.e. @#DGREGORIAN@, @#DHEBREW@, etc.<br /><b>A</b>&nbsp;&nbsp;dia, p.e. 01 a 31<br /><b>O</b>&nbsp;&nbsp;mes, p.e. GEN, FEB, MAR, etc.<br /><b>E</b>&nbsp;&nbsp;any, p.e. 1776, 1867, 2007, etc.<br /><br />Per veure dates sense conversió empreu <b>A&nbsp;O&nbsp;E</b> o <b>@&nbsp;A&nbsp;O&nbsp;E</b></p><b>Alguns exemples</b>, fent servir la data del 08&nbsp;SEP&nbsp;1965:<p style=\"padding-left: 25px\"><b>d&nbsp;M&nbsp;Y</b> = 08&nbsp;Set&nbsp;1965<br /><b>D&nbsp;j&nbsp;F&nbsp;Y</b> = W&nbsp;8&nbsp;Setembre&nbsp;1965<br /><b>j&nbsp;M&nbsp;y</b> = 8&nbsp;Set&nbsp;65<br /><b>l&nbsp;-&nbsp;d&nbsp;-&nbsp;F&nbsp;-&nbsp;Y</b> = Divendres&nbsp;-&nbsp;08&nbsp;-&nbsp;Setembre&nbsp;-&nbsp;1965<br /><b>y/m/d</b> = 1965/09/08</p><br /></li></ul>#pgv_lang[date_format_help2]#";
$pgv_lang["date_format_help2"] = "<ul><li><b>Conversió de Calendari</b><br />El codi <b>R</b> té un funcionament poc usual. Quan apareix al format de data, la data normal sort dos cops, però al segon en un sistema de calendari diferent. Els elements d'aquest calendari alternatiu obeeixen les mateixes normes que els de la part principal de l'especificació del format, excepte que la sortida del format <b>R</b> va entre parèntesi per a distingir-la de la data regular. Els exemples que es donen més avall del calendari <b>Revolucionari Francès</b> poden ésser més esclaridors.<br /><br />El calendari alternatiu a emprar pel codi <b>R</b> va en funció de l'idioma de la pàgina activa. Si és en hebreu, es farà servir el <b>Jueu</b>. Si és en Aràbic, es farà servir el <b>Hijri</b>. Per a tots els altres idiomes es farà servir el  <b>Revolucionari Francès</b>.<br /><br />L'acció d'aquest codi és semblant a l'elecció de format de calendari que podeu fer a la pàgina de configuració del GEDCOM. La diferncia entre ambdós mètodes rau en que el codi <b>R</b>, al venir definit a nivell de Configuració d'Idioma, funciona únicament amb e l'idioma seleccionat però per a tots els fitxers GEDCOMs del lloc. En canvi, l'opció de calendari fixada a nivell de Configuració de GEDCOM  funciona per a tots els idiomes però únicament als fitxers  GEDCOM per als que s'hagi fixat aquesta opció.<br /><ul><li><b>Revolucionari Francès</b> &nbsp;&nbsp;&nbsp;Aquest calendari també s'anomena  <b>Republicà Francès</b>.<br /><br />Excepte per a un molt curt període al maig de 1871, aquest sistema va funcionar solament a França i encara entre el 22&nbsp;SEP&nbsp;1792 i el 31&nbsp;DEC&nbsp;1805. Conseqüentment, aquest format solament és aplicable a dates compreses dins d'aquest lapse de temps.<br /><br />Dos exemples de format de data, assumint que e l'idioma de la pàgina és l'anglès, podran illustrar la acció del codi <b>R</b>:<br /><b>Y.m.d&nbsp;R</b> donarà <b>1805.04.26&nbsp;(XIII.08.06)</b> o <b>1806.01.01</b>;&nbsp; <b>j&nbsp;F&nbsp;Y&nbsp;R</b> donarà <b>13&nbsp;October&nbsp;1797&nbsp;(22&nbsp;Vendémiaire&nbsp;VI)</b> o <b>1&nbsp;January&nbsp;1806</b>.</li></ul><br /></li><li><b>Alternatives d'idioma</b><br />Els textos abreujats per als codis del format Avançat <b>D</b> i <b>M</b> es fixen al fitxer <i>languages/lang.xx.php</i>, fent servir declaracions com<br /><code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"Su\";<br />\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"April\";</code><br /><br />Poden canviar-se mitjançant el fitxer <i>languages/extra.xx.php</i> tal com es descriu a Wiki i al text ReadMe per a ajustaments d'idioma, per exemple:<br /><code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"Sun\";<br />\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"Apr\";</code></li><br /><li><b>Localització</b><br />Hi ha normes especials de format per a diversos idiomes, particularment en la declinació dels acabament de mes segons com es construeixi la data. Aquestes normes especials s'han implementat en diversos fitxers a <i>includes/extras/functions.xx.php</i>.</li></ul>";
$pgv_lang["time_format"]		= "Format horari";
$pgv_lang["time_format_help"]		= "~#pgv_lang[time_format]#~<br /><br />Aquest camp defineix el format horari que farà servir el PhpGedView.<br /><br />Els símbols que podeu emprar son:<br /><b>a</b> - minúscula Abans de migdia o desprès; p.e. <b>am</b> o <b>pm</b><br /><b>A</b> - majúscula Abans de migdia o desprès; p.e. <b>AM</b> o <b>PM</b><br /><b>B</b> - Hora d'Internet Swatch; p.e. de <b>000</b> a <b>999</b><br /><b>c</b> - Data ISO 8601; p.e. <b>2004-02-12T15:19:21+00:00</b><br /><b>d</b> - dia del mes, 2 dígits, amb zeros de farciment; p.e. <b>01</b> a <b>31</b><br /><b>D</b> - dia, textual, tres lletres; p.e. <b>Dim</b><br /><b>F</b> - mes, textual, llarg; p.e. <b>gener</b><br /><b>g</b> - hora, format-12-hores, sense zeros de farciment; p.e. <b>1</b> a <b>12</b><br /><b>G</b> - hora, format 24-hores, sense zeros de farciment; p.e. <b>0</b> a <b>23</b><br /><b>h</b> - hora, format 12-hores, amb zeros de farciment; p.e. <b>01</b> a <b>12</b><br /><b>H</b> - hora, format 24-hores, amb zeros de farciment; p.e. <b>00</b> a <b>23</b><br /><b>i</b> - minuts, amb zeros de farciment; p.e. <b>00</b> a <b>59</b><br /><b>I</b> (majúscula «i») - indicador d'horari d'estiu; <b>1</b> dins del període d'horari estiuenc, <b>0</b> al hivern.<br /><b>j</b> - dia del mes, sense zeros de farciment; p.e. <b>1</b> a <b>31</b><br /><b>l</b> (minúscula «L») - dia de la setmana, textual, llarg; p.e. <b>Divendres</b><br /><b>L</b> - indicador d'any de traspàs; <b>1</b> si és any de traspàs, <b>0</b> si no ho és.<br /><b>m</b> - mes, numèric, amb zeros de farciment; p.e. <b>01</b> a <b>12</b><br /><b>M</b> - mes, textual, 3 lletres; p.e. <b>gen</b><br /><b>n</b> - mes, numèric, sense zeros de farciment; p.e. <b>1</b> a <b>12</b><br /><b>O</b> (majúscula «o») - diferència en hores entre l'hora local i la de Greenwich (GMT); p.e. <b>+0200</b><br /><b>r</b> - Data en format RFC 2822; p.e. <b>Dij,&nbsp;21&nbsp;Des&nbsp;2000&nbsp;16:01:07&nbsp;+0200</b><br /> <b>s</b> - segons, amb zeros de farciment; p.e. <b>00</b> a <b>59</b><br /><b>S</b> - sufix del dia del mes, solament en anglès, 2 caràcters; p.e. <b>st</b>, <b>nd</b>, <b>rd</b> o <b>th</b>. Funciona be amb  <b>j</b><br /><b>t</b> - número de dies en determinats mesos; p.e. <b>28</b> a <b>31</b><br /><b>T</b> - paràmetres de zona horària d'aquesta màquina; p.e. <b>CEST</b>, <b>EST</b>, <b>MDT</b><br /><b>U</b> - segons des de l'inici del Temps UNIX (1&nbsp;gener&nbsp;1970&nbsp;00:00:00 GMT)<br /><b>w</b> - dia de la setmana, numèric; p.e. <b>0</b> (diumenge) a <b>6</b> (dissabte)<br /><b>W</b> - número de la setmana ISO 8601, començant la setmana en dilluns; p.e. <b>42</b> (la 42ena setmana de l'any)<br /><b>Y</b> - any, 4 dígits; p.e. <b>1999</b><br /><b>y</b> - any, 2 dígits; p.e. <b>99</b><br /><b>z</b> - dia de l'any, numèric, sense zeros de farciment; p.e. <b>0</b> (1 gen) a <b>364</b> (31 des si no és any de traspàs) o <b>365</b> (31 des els anys de traspàs)<br /><b>Z</b> - diferència horària zonal en segons. A l'oest de Greenwich és sempre negativa i pels que estan a l'est, sempre positiva. p.e. <b>-43200</b> a <b>43200</b><br /><br />Podeu escollir l'ordre d'aquests símbols i afegir-hi delimitadors al format.<br />Per exemple, en alemany aquest camp normalment conté <b>H:i:s</b> que dóna un resultant així <b>09:01:25</b>.<br />Els anglesos generalment defineixen el format de temps així <b>g:i:sa</b> que surt d'aquesta forma <b>9:01:25am</b>.<br /><br />Al sistema de 24 hores, mitjanit son les 00:00. Al de 12 hores 12:00am i migdia son les 12:00pm.";
$pgv_lang["week_start"]					= "Dia de començament de la setmana";
$pgv_lang["week_start_help"]				= "~#pgv_lang[week_start]#~<br /><br />El dia que comença una nova setmana en aquest idioma. Molts idiomes comencen del diumenge, però alguns altres dies.";
$pgv_lang["name_reverse"]				= "Primer el cognom";
$pgv_lang["name_reverse_help"]			= "~#pgv_lang[name_reverse]#~<br /><br />En alguns idiomes el cognoms ha de precedir el nom per comptes del que hi ha fixat per defecte que és que el cognom surti al darrera. Activant aquesta opció sortirà primer el cognom. Hongaresos, xinesos i japonesos son exemples on el cognom (nom de la família) es posa primerament.";
$pgv_lang["ltr"]						= "D'esquerra a dreta";
$pgv_lang["rtl"]						= "De dreta a esquerra";
$pgv_lang["file_does_not_exist"]			= "ERROR! El fitxer no existeix...";
$pgv_lang["optional_file_not_exist"]	= "Aquest fitxer opcional no hi és";
$pgv_lang["alphabet_upper"]				= "Alfabet de majúscules";
$pgv_lang["alphabet_upper_help"]			= "~#pgv_lang[alphabet_upper]#~<br /><br />Alfabet de lletres majúscules en aquest idioma. S'utilitza per ordenar les llistes de noms.";
$pgv_lang["alphabet_lower"]				= "Alfabet de minúscules";
$pgv_lang["alphabet_lower_help"]			= "~#pgv_lang[alphabet_lower]#~<br /><br />Alfabet de minúscules en aquest idioma. S'utilitza per ordenar llistes de noms.";
$pgv_lang["multi_letter_alphabet"]		= "Alfabet multi-caràcters";
$pgv_lang["multi_letter_alphabet_help"]	= "~#pgv_lang[multi_letter_alphabet]#~<br /><br />Combinacions multi-caràcters que cal tractar com a una sola lletra i diferent quan s'ordenin les llistes de noms i títols en aquest idioma.<br /><br />Alguns idiomes, l'hongarès i l'eslovac per exemple, consideren una determinada cadena de lletres com a lletres diferents amb el seu propi significat. L'ordre en el que especifiqueu aquestes cadenes de lletres determina l'ordre en el que s'inseriran a l'alfabet normal durant la ordenació. És important quan diverses combinacions de caràcters tenen la mateixa inicial. Excepte per la <b>ch</b>, aquestes combinacions s'inseriran dins de l'alfabet normal d'acord amb llur inicial. La <b>ch</b> va sempre desprès de la <b>h</b>.";
$pgv_lang["multi_letter_equiv"]		= "Equivalències de grups de lletres";
$pgv_lang["multi_letter_equiv_help"]	= "~#pgv_lang[multi_letter_equiv]#~<br /><br />En alguns idiomes cal que certs grups de lletres hagin de tractar-se com si fos una únic caràcter al generar llistats de noms.<br /><br />Per exemple, en holandès, els noms que comencen per <b>IJ</b> han de llistar-se al costat dels que ho fan amb <b>Y</b>. En norueg, els noms que comencen per <b>Aa</b> es llisten al costat dels que ho fan amb <b>&Aring;</b>. En alguns idiomes, hi ha lletres que poden escriure's amb un caràcter o amb dos. Per exemple, en eslovac, els dos caràcters D i \xC5\xBE poden escriure's amb el caràcter \xC7\x85. Especificant aquí les equivalències podeu fer que els noms que continguin aquestes lletres surtin junts a les pàgines de llistats de persones o llocs.<br /><br />El format és una llista d'equivalents separada per comes. Per a que funcioni correctament amb bases de dades que reconeixen la codificació UTF-8, cal que especifiqueu les equivalències tant en majúscules com en minúscules. Aquest exemple mostra el format a utilitzar.<br /><br />Aa=&Aring;,aa=&aring;";
$pgv_lang["dictionary_sort"]		= "Fes servir les regles del diccionari per ordenar";
$pgv_lang["dictionary_sort_help"]	= "~#pgv_lang[dictionary_sort]#~<br /><br />Aquesta opció controla com es tracten els caràcters amb signes diacrítics a l'ordenar llistes de noms i títols.<br /><br />Posant-ho a <b>#pgv_lang[yes]#</b>, tots els caràcters amb signes diacrítics es tracten com si no tinguessin cap signes. Els signes diacrítics solament es tenen en compte solament quan les dues paraules son idèntiques sense ells. Posant-ho a <b>#pgv_lang[no]#</b>, totes les lletres son diferents independentment de la presència o absència dels signes diacrítics.";
$pgv_lang["collation"]		= "Seqüència de classificació de la base de dades";
$pgv_lang["collation_help"]	= "~#pgv_lang[collation]#~<br /><br />Si empreu les regles pròpies de la base de dades per a ordenar-la, aquesta opció especifica la seqüència d'ordenació que cal emprar en aquest idioma. Cal que us assegureu que la vostra base de dades contempla totes les seqüències d'ordenació que planegeu emprar.<br /><br />L’ús de classificació per la base de dades es controla en els paràmetres de configuració del lloc.";
$pgv_lang["lang_config_write_error"]		= "Error en desar els paràmetres d'idioma al fitxer <i>language_settings.php</i>. Comproveu els permisos i torneu-ho a provar.";
$pgv_lang["lang_set_file_read_error"]		= "E R R O R !!! impossible llegir <i>language_settings.php</i>!";
$pgv_lang["add_new_language_help"]	= "~#pgv_lang[add_new_language]#~<br /><br />#pgv_lang[add_new_language_desc]#";
$pgv_lang["add_new_language_desc"]	= "Aquesta rutina us permet afegir un idioma, prèviament indisponible i completament no suportat, al PhpGedView.<br /><br />Heu de fixar els paràmetres estàndard d'aquest nou idioma, que inclouen codi de detecció, direcció d'escriptura, dia de començament de la setmana, paràmetres horaris, alfabet, etc.<br /><br />Obtindreu més ajuda sobre els paràmetres dels idiomes suportats pel  PhpGedView desprès de seleccionar l'idioma i polsar el botó <b>#pgv_lang[add_new_lang_button]#</b>.<br /><br />Hi ha més ajuda disponibles a la pàgina de configuració de l'idioma.";
$pgv_lang["add_new_lang_button"]	= "Afegeix un idioma nou";
$pgv_lang["hide_translated"]		= "Amaga els ja traduïts";
$pgv_lang["hide_translated_help"]		= "~#pgv_lang[hide_translated]#~<br /><br />Si es posa a <b>#pgv_lang[yes]#</b> solament veureu els textos del fitxer d'idioma seleccionat pendents de traducció. Això obliga a que els textos nous <u>no</u> han de figurar al fitxer d'idioma que s'està editant.<br /><br />Alguns fitxers d'idioma contenen textos en anglès a alguns camps pendents de traduir. Aquesta rutina no identifica aquestes entrades no traduïdes doncs figuren presents al fitxer en edició. S'assumeix que, «Si el text és present al fitxer en edició, és que ja s'ha traduït.»";
$pgv_lang["lang_file_write_error"]	= "E R R O R !!! No es poden desar els canvis al fitxer de l'idioma seleccionat. Reviseu el permís d'escriptura de <b>#lang_filename#</b>";
$pgv_lang["no_open"]	= "E R R O R !!! El fitxer <b>#lang_filename#</b> no s'ha pogut obrir.";
$pgv_lang["users_langs"]			= "Idioma de l'usuari";
$pgv_lang["configured_languages"]	= "Idiomes utilitzats";

//-- User Migration Tool messages
$pgv_lang["um_header"] = "Eina de migració d'informació d'usuaris";
$pgv_lang["um_proceed"] = "Escolliu una opció o polseu l'enllaç de sota per tornar al menú d'administració ";
$pgv_lang["um_creating"] = "Creant";
$pgv_lang["um_sql_index"] = "Aquesta utilitat crearà el fitxer <i>authenticate.php</i> i diversos <i>.dat</i> al vostre directori índex.<br /><br />Un cop correctament creta, podeu passar al mode Índex tots els usuaris i llurs missatges, favorits, notícies i formats MyGedview disponibles.<br /><br />Nota: Desprès de passar al mode Índex, us caldrà reimportar també els fitxers GEDCOM.";
$pgv_lang["um_file_create_fail1"] = "Ha fallat la creació del nou fitxer. Ja n'hi ha un amb el mateix nom:";
$pgv_lang["um_file_create_fail2"] = "No puc crear-lo";
$pgv_lang["um_file_create_fail3"] = "Comprova els drets d'accés d'aquest directori.";
$pgv_lang["um_file_create_succ1"] = "S'ha creat correctament el nou fitxer:";
$pgv_lang["um_file_not_created"] = "El fitxer no s'ha creat.";
$pgv_lang["um_nomsg"] = "No sembla haver-hi missatges presents al sistema.";
$pgv_lang["um_nofav"] = "No sembla haver-hi favorits presents al sistema.";
$pgv_lang["um_nonews"] = "No sembla haver-hi notícies presents al sistema.";
$pgv_lang["um_noblocks"] = "No sembla haver-hi blocs presents al sistema.";
$pgv_lang["um_index_sql"] = "Aquesta eina importarà <i>authenticate.php</i> i altres fitxers <i>.dat</i> del vostre directori d'índex a la base de dades.";
$pgv_lang["um_noaction"] = "No s'ha de fer res per migrar la informació d'usuari al mode SQL.<br /><br />Un cop passat a SQ, heu de fer córrer l'<b>#pgv_lang[um_header]#</b> per importar totes les dades a la base de dades SQL. El PhpGedView utilitzarà els fitxers existents del mode Índex.<br /><br /><b><u>No</u> esborreu els fitxers <i>authenticate.php</i> i <i>.dat</i> del directori índex en el traspàs.</b>";
$pgv_lang["um_import"] = "Importa";
$pgv_lang["um_export"] = "Exporta";
$pgv_lang["um_explain"] = "Aquesta utilitat tant pot exportar dades d'usuari dels mode SQL a l'Índex com importar-ne del mode índex a les taules SQL<br /><br />Dades d'usuari, favorits, definicions de bloc, missatges i notícies tornaran a restar disponibles desprès de la migració.<br /><br /><b>COMPTE</b><br />No podeu fer servir aquesta eina per migrar dades d'usuari entre diferents versions del PhpGedView. Assegureu-vos que les dades s'han originat o son importades a la mateixa versió de PhpGedView.<br /><br /><b>IMPORTAR</b><br />Si escolliu importar fitxers de dades d'usuari des del mode Índex, totes les dades presents a les taules de la base de dades es <u>sobreescriuran</u>. Aquesta utilitat <u>no</u> barreja informació. Un cop efectuada la Importació no hi haurà forma de recuperar la informació antiga mitjançant el PhpGedView.<br /><br /><b>EXPORTAR</b><br />Si exporteu informació d'usuaris des de la base de dades SQL al mode de fitxers Índex, aquesta utilitat crearà el fitxer <i>authenticate.php</i> i alguns <i>.dat</i> al vostre directori índex. Si hi ha presents fitxers amb noms idèntics, us demanarà si voleu sobreescriure'ls. Desprès de canviar al mode Índex, tota la informació restarà disponible directament.<br /><br /><b>Nota:</b> Desprès de canviar a mode Índex, us caldrà importar també els vostres fitxers GEDCOM.";
$pgv_lang["um_tool_help"] = "~#pgv_lang[um_header]#~<br /><br />#pgv_lang[um_explain]#";
$pgv_lang["um_sql_index_help"] = "~Usuaris migrats des de SQL al mode Índex ~<br /><br />#pgv_lang[um_sql_index]#";
$pgv_lang["um_index_sql_help"] = "~Usuaris migrats des de l'Índex al mode SQL ~<br /><br />#pgv_lang[um_index_sql]#";
$pgv_lang["um_imp_users"] = "Important usuaris";
$pgv_lang["um_imp_blocks"] = "Important blocs";
$pgv_lang["um_imp_favorites"] = "Important favorits";
$pgv_lang["um_imp_messages"] = "Important missatges";
$pgv_lang["um_imp_news"] = "Important notícies";
$pgv_lang["um_nousers"] = "No es localitza el fitxer <i>authenticate.php</i> al vostre directori índex. S'ha cancel·lat la Migració.";
$pgv_lang["um_imp_succ"] = "Importació correcta";
$pgv_lang["um_imp_fail"] = "Ha fallat la importació";
$pgv_lang["um_backup"] = "Còpia de seguretat";
$pgv_lang["um_zip_succ"] = "S'ha creat correctament el fitxer ZIP.";
$pgv_lang["um_zip_dl"] = "Descarrega la còpia de seguretat en format ZIP";
$pgv_lang["um_bu_explain"] = "Aquesta utilitat fa una còpia de seguretat de dades i informació rellevants del PhpGedView.<br /><br />El que escolliu per desar, es comprimirà en un fitxer ZIP que podreu descarregar polsant l'enllaç del final de la pàgina, un cop la còpia de seguretat hagi acabat.<br /><br />El fitxer ZIP romandrà al vostre directori Índex mentre no l'elimineu manualment.";
$pgv_lang["um_bu_help"] = "~#pgv_lang[um_backup]#~<br /><br />#pgv_lang[um_bu_explain]#";
$pgv_lang["um_bu_config"] = "Fitxer de Configuració PhpGedView";
$pgv_lang["um_bu_gedcoms"] = "Fitxers GEDCOM";
$pgv_lang["um_bu_gedsets"] = "Paràmetres GEDCOM, fitxers de configuració i privadesa";
$pgv_lang["um_bu_logs"] = "Comptadors GEDCOM, fitxers SearchLogs i Logfiles";
$pgv_lang["um_bu_usinfo"] = "Definicions d'usuari, paràmetres de blocs, favorits, missatges, notícies";
$pgv_lang["um_bu_media"]	= "Fitxers multimèdia";
$pgv_lang["um_mk_bu"] = "Fes la còpia de seguretat";
$pgv_lang["um_nofiles"] = "No s'han localitzat fitxers per guardar";
$pgv_lang["um_files_exist"] = "Un o més fitxers ja existeixen. Voleu sobreescriure'ls?";
$pgv_lang["um_results"]		= "Resultats";
$pgv_lang["preview_faq_item"] = "Previsualitza les entrades de preguntes més freqüents";
$pgv_lang["preview_faq_item_help"] = "~#pgv_lang[preview_faq_item]#~<br /><br />Aquesta opció permet a un usuari administrador veure les pàgines de preguntes més freqüents sense les opcions d'edició i els enllaços.<br /><br />Excepte per un simple enllaç <b>Edita</b> sobre el primer ítem, la sortida de la pàgina és idèntica a la que pot veure un usuari ordinari. Aquest enllaç especial <b>Edita</b> restaura completament la funcionalitat d'edició de la pàgina.";
$pgv_lang["restore_faq_edits"] = "Restaura la funcionalitat d'edició de les preguntes més freqüents";
$pgv_lang["restore_faq_edits_help"] = "~#pgv_lang[restore_faq_edits]#~<br /><br />Aquesta opció restaura a la pàgina de preguntes més freqüents que un usuari administrador pot veure normalment, la possibilitat d'edició d'ítems.";
$pgv_lang["add_faq_item"] = "Afegeix entrades a preguntes més freqüents";
$pgv_lang["add_faq_item_help"] = "~#pgv_lang[add_faq_item]#~<br /><br />Aquesta opció us permet afegir ítems a la pàgina FAQ.";
$pgv_lang["edit_faq_item"] = "Edita l'ítem";
$pgv_lang["edit_faq_item_help"] = "~#pgv_lang[edit_faq_item]#~<br /><br />Aquesta opció us permet editar un ítem de la pàgina preguntes més freqüents.";
$pgv_lang["delete_faq_item"] = "Elimina l'ítem";
$pgv_lang["delete_faq_item_help"] = "~#pgv_lang[delete_faq_item]#~<br /><br />Aquesta opció us permet eliminar un ítem de la pàgina preguntes més freqüents";
$pgv_lang["moveup_faq_item"] = "Mou l'ítem amunt";
$pgv_lang["moveup_faq_item_help"] = "~#pgv_lang[moveup_faq_item]#~<br /><br />Aquesta opció us permet fer córrer amunt els ítems dins de la pàgina de preguntes més freqüents.<br /><br />Cada cop que la feu servir, la posició de l'ítem es reduirà un lloc. Podeu obtenir el mateix efecte editant l'ítem en qüestió i canviant el camp de posició. Quan més d'un ítem té el mateix número de posició, solament se'n veurà un d'ells.";
$pgv_lang["movedown_faq_item"] = "Mou l'ítem avall";
$pgv_lang["movedown_faq_item_help"] = "~#pgv_lang[movedown_faq_item]#~<br /><br />Aquesta opció us permet fer córrer avall els ítems dins de la pàgina de preguntes més freqüents.<br /><br />Cada cop que la feu servir, la posició de l'ítem augmentarà un lloc. Podeu obtenir el mateix efecte editant l'ítem en qüestió i canviant el camp de posició. Quan més d'un ítem té el mateix número de posició, solament se'n veurà un d'ells.";
$pgv_lang["add_faq_header_help"] = "~#pgv_lang[add_faq_header]#~<br /><br />Aquest és el títol o subjecte de l'ítem preguntes més freqüents.<br /><br />El que entreu aquí pot formatar-se. Es permeten etiquetes HTML com &lt;b&gt; i &lt;br /&gt;, també entitats HTML com &amp;amp; i &amp;nbsp;.  Altres etiquetes HTML com &lt;br /&gt; probablement no son gaire apropiades per al títol i és millor rebutjar-les.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["add_faq_body_help"] = "~#pgv_lang[add_faq_body]#~<br /><br />El text de l'ítem s'entra aquí.<br /><br />El text pot formatar-se. Es permeten etiquetes HTML com &lt;b&gt; i &lt;br /&gt;, també entitats HTML com &amp;amp; i &amp;nbsp;.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["add_faq_HTML"] = "Les entitats HTML son una forma fàcil d'afegir caràcters especials als vostres títols i textos de les preguntes més freqüents.  Podeu fer servir noms simbòlics, números decimals o hexadecimals.  Podeu obtenir una llista completa de entitats HTML, llur codificació i representació pel vostre navegador aquí:  <a href=\"http://htmlhelp.com/reference/html40/entities/\" target=\"_blank\">llista entitats HTML</a><br /><br />En ocasions us pot caldre mostrar el caràcter Tilde&nbsp;&nbsp;<b>&#x7E;</b>&nbsp;&nbsp;o el símbol de número&nbsp;&nbsp;<b>&#x23;</b>&nbsp;&nbsp;als vostres URL o textos.  Aquests caràcters tenen un tractament especial al sistema d'ajuda de PhpGedView i solament poden entrar-se en llur forma hexadecimal o decimal.  Igualment, els caràcters&nbsp;&nbsp;<b>&lt;</b>&nbsp;&nbsp;i&nbsp;&nbsp;<b>&gt;</b>&nbsp;&nbsp;que habitualment emmarquen etiquetes HTML, cal que s'entril en llur forma hexadecimal o decimal si cal considerar-los com a text normal per comptes de senyalitzar una etiqueta HTML.<ul><li><b>&amp;&#x23;35;</b>&nbsp;&nbsp;o&nbsp;&nbsp;<b>&amp;&#x23;x23;</b>&nbsp;&nbsp;es convertirà en&nbsp;&nbsp;<b>&#x23;</b></li><li><b>&amp;&#x23;60;</b>&nbsp;&nbsp;o&nbsp;&nbsp;<b>&amp;&#x23;x3C;</b>&nbsp;&nbsp;es convertirà en&nbsp;&nbsp;<b>&#x3C;</b></li><li><b>&amp;&#x23;62;</b>&nbsp;&nbsp;o&nbsp;&nbsp;<b>&amp;&#x23;x3E;</b>&nbsp;&nbsp;es convertirà en&nbsp;&nbsp;<b>&#x3E;</b></li><li><b>&amp;&#x23;126;</b>&nbsp;&nbsp;o&nbsp;&nbsp;<b>&amp;&#x23;x7E;</b>&nbsp;&nbsp;es convertirà en&nbsp;&nbsp;<b>&#x7E;</b></li></ul>Aquesta és una mostra de entitat HTML&nbsp;&nbsp;<b>&amp;tilde;</b>&nbsp;&nbsp;, però el símbol no s'interpreta com un Tilde quan va codificat dins d'un URL.";
$pgv_lang["add_faq_pgvLangRefs"] = "Podeu inserir referències a entrades dels fitxers d'idiomes o a valors de variables globals. Exemples: <ul><li><b>&#x23;pgv_lang[add_to_cart]&#x23;</b>&nbsp;&nbsp;&nbsp;és una referència a la variable d'idioma \$pgv_lang[\"add_to_cart\"], i si apareix en aquest camp, ho farà així <b>#pgv_lang[add_to_cart]#</b> quan la llista preguntes més freqüents es presenti en l'idioma actiu.</li><li><b>&#x23;factarray[AFN]&#x23;</b>&nbsp;&nbsp;&nbsp;és una referència al nom d'esdeveniment \$factarray[\"AFN\"], i si apareix en aquest camp, ho farà així <b>#factarray[AFN]#</b> quan la llista preguntes més freqüents es presenti en l'idioma actiu.</li><li><b>&#x23;PGV_VERSION&#x23;&nbsp;&#x23;PGV_VERSION_RELEASE&#x23;</b>&nbsp;&nbsp;&nbsp;és una referència a la constant PGV_VERSION, un espai i una referència a la constant PGV_VERSION_RELEASE, i si apareix en aquest camp, ho farà així <b>#PGV_VERSION#&nbsp;#PGV_VERSION_RELEASE#</b> quan la llista preguntes més freqüents es presenti en l'idioma actiu.</li><li><b>&#x23;GLOBALS[GEDCOM]&#x23</b>&nbsp;&nbsp;&nbsp;és una referència a la variable global \$GEDCOM, que és el nom del fitxer actiu GEDCOM. Si apareix en aquest camp, ho farà així <b>#GLOBALS[GEDCOM]#</b>.</li><li><b>&#x23;GLOBALS[GEDCOM_TITLE]&#x23</b>&nbsp;&nbsp;&nbsp;és una referència a la variable global  \$GEDCOM_TITLE, que és el títol del fitxer GEDCOM actiu. Si apareix en aquest camp, ho farà així <b>#GLOBALS[GEDCOM_TITLE]#</b>.</li></ul><br />Aquesta característica és útil quan voleu crear llistes preguntes més freqüents diferents per a cada idioma que suporti el vostre lloc. Podeu posar els vostres títols i entrades preguntes més freqüents personalitzats als fitxers <i>languages/extra.xx.php</i> (<i>xx</i> és el codi per a cada idioma), fent servir el format següent:<br /><code>\$pgv_lang[\"faq_title1\"]&nbsp;=&nbsp;\"Això és un exemple de títol preguntes més freqüents\";<br />\$pgv_lang[\"faq_body1\"]&nbsp;=&nbsp;\"Això és un exemple de text preguntes més freqüents.\";</code>";
$pgv_lang["add_faq_order_help"] = "~#pgv_lang[add_faq_order]#~<br /><br />Aquest camp controla l'ordre amb el que sortiran les entrades preguntes més freqüents.<br /><br />No cal que entreu els números seqüencialment. Si deixeu forat a l'esquema de numeració, podeu inserir-hi ítems més endavant. Per exemple, si feu servir els números  1, 6, 11, 16, podeu posteriorment inserir entrades amb els números de seqüència perduts. Es permeten números negatius i el zero i poden utilitzar-se per inserir entrades davant del primer.<br /><br />Quan més d'un ítem té els mateix número de posició, solament se'n veurà un d'ells.";
$pgv_lang["add_faq_visibility_help"] = "~#pgv_lang[add_faq_visibility]#~<br /><br />Podeu determinar si aquesta pregunta més freqüent és visible independentment del GEDCOM o si solament ho és per al GEDCOM actual.<br /><ul><li><b>#pgv_lang[all]#</b>&nbsp;&nbsp;&nbsp;La pregunta més freqüent sortirà a toles les llistes preguntes més freqüents, independentment del GEDCOM.</li><li><b>#GLOBALS[GEDCOM]#</b>&nbsp;&nbsp;&nbsp;La pregunta més freqüent es mostrarà solament en la llista activa actualment pel GEDCOM.</li></ul>";
$pgv_lang["index_gedcom_news_adm_help"]		= "Els textos de notícies GEDCOM us permeten fer servir  <b>etiquetes HTML</b> i <b>entitats HTML</b>. L'HTML pot fer-se servir als títols.<br /><br />Assegureu-vos de posar sempre les etiquetes inicial i final. Anirà be que l'administrador del lloc web tingui un correcte coneixement d'HTML. Aquest programa fa servir  <b>Fulls d'Estil / Cascading Style Sheets (CSS)</b>. Hi ha implementats diferents CSS per a cada tema. Podeu fer servir classes d'aquest fulls d'estil per controlar l'aparença dels vostres missatges.<br /><br />Si us cal més ajuda de com fer-ho, al web de PhpGedView hi ha alguns exemples de com emprar aquestes etiquetes al vostre bloc de notícies GEDCOM.<br /><br />Igual que a les llistes preguntes més freqüents, els títols i texts de Notícies GEDCOM  permeten referències incrustades a variables \$pgv_lang, \$factarray i \$GLOBALS per fornir una completa flexibilitat en la creació d'ítems de Notícies que seran sensibles a idioma actualment actiu.<br /><br />La descripció següent presa del text d'ajuda per les llistes preguntes més freqüents, és igualment aplicable als ítems Notícies GEDCOM.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["time_limit_help"]			= "~#pgv_lang[time_limit]#~<br /><br />El temps màxim que es permet córrer la importació per processar el fitxer GEDCOM.";

// editconfig_gedcom.php Option Filter
$pgv_lang["ged_filter_results"] = "Resultats localitzats";
$pgv_lang["ged_filter_reset"] = "Neteja la recerca";
$pgv_lang["ged_filter_description"] = "Opció de recerca de text";
$pgv_lang["ged_filter_description_help"] = "~#pgv_lang[ged_filter_description]#~<br /><br />Aquesta opció us permet localitzar text associat a opcions de configuració.<br /><br />Si hi entreu lletres, la recerca intentarà localitzar totes les opcions de configuració que contingui aquesta seqüència de lletres. La recerca esdevé més precisa si hi entreu més caràcters.";

?>
