<?php
/*
 * Danish Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2022  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your choice) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @translator Jørgen Hansen
 * @version $Id: configure_help.da.php 7328 2022-01-12 18:30:53Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["google_analytics_help"]			= "~#pgv_lang[google_analytics]#~<br /><br />#pgv_lang[google_analytics]# tjenesten er beskrevet i denne <a href='https://da.wikipedia.org/wiki/Google_Analytics' target='_blank' title='Google Analytics'>Wikipedia-artikel</a>.<br /><br />Vær opmærksom på, at hvis du vælger at bruge denne tjeneste, erhverver Google rettighederne til alle data, den indsamler om besøgende på dit websted.";
$pgv_lang["USE_GOOGLE_ANALYTICS_help"]		= "~#pgv_lang[USE_GOOGLE_ANALYTICS]#~<br /><br />Vælg <b>#pgv_lang[yes]#</b> for at aktivere sporing af aktivitet på dit websted af #pgv_lang[google_analytics]# tjenesten. Du skal abonnere på denne tjeneste, før du aktiverer denne mulighed.";
$pgv_lang["PGV_GOOGLE_ANALYTICS_help"]		= "~#pgv_lang[PGV_GOOGLE_ANALYTICS]#~<br /><br />Indtast det kontonummer, der er tildelt dit websted, da du abonnerede på #pgv_lang[google_analytics]# tjenesten. Dette kontonummer har formatet <b>UA-xxxxxx-x</b>.";
$pgv_lang["piwik_analytics_help"]			= "~#pgv_lang[piwik_analytics]#~<br /><br />#pgv_lang[piwik_analytics]# open source-projektet, oprindeligt kaldet «Piwik», er beskrevet <a href='https://matomo.org/' target='_blank' title='Matomo officielle websted'>her</a> på engelsk.<br /><br />Matomo er et alternativ til #pgv_lang[google_analytics]#, der eliminerer mange af privatlivets bekymringer. Du kan installere Matomo-applikationen på din egen webserver eller i dit eget domæne og dermed sikre dig, at du har fuld kontrol over de indsamlede aktivitetsdata.";
$pgv_lang["USE_PIWIK_ANALYTICS_help"]		= "~#pgv_lang[USE_PIWIK_ANALYTICS]#~<br /><br />Vælg <b>#pgv_lang[yes]#</b> for at aktivere sporing af aktivitet på dit websted af en #pgv_lang[piwik_analytics]# server. Dit PhpGedView-websted skal være registreret på en Matomo-server.";
$pgv_lang["PGV_PIWIK_URL_help"]				= "~#pgv_lang[PGV_PIWIK_URL]#~<br /><br />Indtast URL'en til en Matomo-server, hvor dit PhpGedView-websted er registreret.";
$pgv_lang["PGV_PIWIK_SITE_help"]			= "~#pgv_lang[PGV_PIWIK_SITE]#~<br /><br />Indtast det numeriske sted-id, der er tildelt dit PhpGedView-websted af Matomo-serveren.";
$pgv_lang["clustrmaps_analytics_help"]		= "~#pgv_lang[clustrmaps_analytics]#~<br /><br />#pgv_lang[clustrmaps_analytics]# er et kombineret hit-tæller, gæstetracker og geografisk visualiseringsværktøj.<br /><br />Hver side indeholder et miniaturekortbillede, der er genereret af #pgv_lang[clustrmaps_analytics]#. Når billedet indlæses, øges en tæller på #pgv_lang[clustrmaps_analytics]#-webstedet. Når kortet, der er synligt for alle dine besøgende, opdateres (dagligt, ugentligt eller månedligt, Afhængigt af din trafik), viser det placeringen af alle de besøgende på din side siden begyndelsen af et specifikt tidsinterval.<br /><br />Hvis du har betalt for #pgv_lang[clustrmaps_analytics]# tjenesten, vises et større verdenskortvisning ved at klikke på dette miniaturekortbillede.<br /><br />Flere detaljer findes på engelsk på <a href='http://www.clustrmaps.com/' target='_blank' title='#pgv_lang[clustrmaps_analytics]#-siden'>#pgv_lang[clustrmaps_analytics]#-siden</a>.";
$pgv_lang["USE_CLUSTRMAPS_ANALYTICS_help"]	= "~#pgv_lang[USE_CLUSTRMAPS_ANALYTICS]#~<br /><br />Vælg <b>#pgv_lang[yes]#</b> for at aktivere sporing af aktivitet på dit websted af en #pgv_lang[clustrmaps_analytics]# server.";
$pgv_lang["PGV_CLUSTRMAPS_SITE_help"]		= "~#pgv_lang[PGV_CLUSTRMAPS_SITE]#~<br /><br />Indtast URL'en til dit PhpGedView-websted. Denne værdi er udfyldt for dig, og du behøver normalt ikke ændre den.";
$pgv_lang["PGV_CLUSTRMAPS_SERVER_help"]		= "~#pgv_lang[PGV_CLUSTRMAPS_SERVER]#~<br /><br />Indtast det servernummer, der er tildelt af #pgv_lang[clustrmaps_analytics]# tjenesten, da du aktiverede din konto.";

$pgv_lang["SHOW_LIST_PLACES"]	= "Antal stedniveauer, der skal vises på lister";
$pgv_lang["SHOW_LIST_PLACES_help"]	= "~#pgv_lang[SHOW_LIST_PLACES]#~<br /><br />Dette bestemmer, hvor meget af stedoplysningerne, der vises i felterne Sted på lister.<br /><br />Hvis værdien indstilles til <b>9</b>, sikres det, at alle stedoplysninger vises. Hvis du indstiller værdien til <b>0</b> (nul), skjules steder fuldstændigt. Hvis værdien indstilles til <b>1</b>, vises det øverste niveau, som normalt er landet. Hvis du indstiller den til <b>2</b>, vises de to øverste niveauer. Det andet øverste niveau under landet er ofte staten, provinsen eller territoriet. Etc.";

$pgv_lang["new_gedcom_title"]		= "Slægtsoplysninger fra #GEDCOMFILE#";
$pgv_lang["keep_media_help"]		= "~#pgv_lang[keep_media]#~<br /><br />Skal eksisterende medielinks opretholdes i databasen, når en ny GEDCOM uploades. Indstillingen <b> Nej </b> fjerner eksisterende medielinks fra databasen, mens indstillingen <b>Ja</b> holder dem.<br /><br />Denne indstilling er nyttig, når du eksporterer din GEDCOM fra PhpGedView til et offline GEDCOM-vedligeholdelsesprogram, der ikke håndterer indlejrede mediepeger korrekt, og derefter derefter genimportere det, der ændrede GEDCOM til PhpGedView. Under sådanne omstændigheder ødelægges mediepekerne i GEDCOM, som du eksporterede til dit offline redigeringsprogram, og du bliver nødt til at linke alle dine mediefiler til de rette person-, familie- og kildeposter, når du har importeret GEDCOM til PhpGedView.<br /><br />Indstillingen <b>Ja</b> fortæller PhpGedView at beholde de eksisterende medielinks, så du ikke behøver at genskabe dem, efter at du har importeret den ændrede GEDCOM, men dette kræver, at redigeringsprogrammet til offline altid producerer de samme identifikationsnumre for person, familie og kilde.<br /><br /><i>Family Tree Maker</i> er et af flere offline redigeringsprogrammer, der håndterer <u>ikke</u> ordentligt medieobjektmarkører i GEDCOM. <i>Legacy</i>, blandt mange andre, håndterer disse ordentligt.";
$pgv_lang["USE_MEDIA_VIEWER"]			= "Brug mediefremviser";
$pgv_lang["USE_MEDIA_VIEWER_help"]		= "~#pgv_lang[USE_MEDIA_VIEWER]#~<br /><br />Når denne indstilling er <b>#pgv_lang[yes]#</b>, frembringes siden Media Viewer ved at klikke på billeder. Denne side viser detaljerne i billedet. Hvis du har tilstrækkelige rettigheder, kan du også redigere disse detaljer.<br /><br />Når denne indstilling er <b>#pgv_lang[no]#</b>, vil et klik på billeder give et billede i fuld størrelse i et nyt vindue.";
$pgv_lang["USE_MEDIA_FIREWALL"]			= "Brug medie firewall";
$pgv_lang["USE_MEDIA_FIREWALL_help"]	= "~#pgv_lang[USE_MEDIA_FIREWALL]#~<br /><br />Se Wiki for en beskrivelse af, hvordan du bruger medie firewall. <a href=\"#PGV_PHPGEDVIEW_WIKI#/en/index.php?title=Media_Firewall\" target=\"_blank\">#PGV_PHPGEDVIEW_WIKI#</a>";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR"]			= "rodmappe til mediefirewall";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_help"]	= "~#pgv_lang[MEDIA_FIREWALL_ROOTDIR]#~<br /><br />Mappe, hvor det beskyttede mediekatalog kan oprettes.  #pgv_lang[MEDIA_FIREWALL_ROOTDIR_note]#";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_note"]	= "Når dette felt er tomt, bruges mappe <b>#GLOBALS[INDEX_DIRECTORY]#</b>.";
$pgv_lang["MEDIA_FIREWALL_THUMBS"]			= "beskyt miniaturer af beskyttede billeder";
$pgv_lang["MEDIA_FIREWALL_THUMBS_help"]	= "~#pgv_lang[MEDIA_FIREWALL_THUMBS]#~<br /><br />Når et billede er i det beskyttede mediekatalog, skal dets miniaturebillede også beskyttes?";
$pgv_lang["SHOW_SPIDER_TAGLINE"]		= "Vis søgemaskinens taglinje";
$pgv_lang["SHOW_SPIDER_TAGLINE_help"]		= "~#pgv_lang[SHOW_SPIDER_TAGLINE]#~<br /><br />På sider, der er genereret til søgemaskiner, skal du som sidste linje vise den bestemte søgemaskine, den side, der blev fundet. Hvis denne indstilling er aktiveret, kan den påvirke Google&reg; AdSense mod søgemaskineoptimeringsværktøjer.";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS_help"] = "~#pgv_lang[SHOW_PRIVATE_RELATIONSHIPS]#~<br /><br />Dette valg bevarer familieforbindelser i privatiserede optegnelser. Dette betyder, at du vil se tomme «#pgv_lang[private]#» felter på stamtavle og på andre diagrammer med private personer.<br /><br />Denne indstilling er som standard slået fra. Det anbefales i stedet for at tænde dette for at pege din stamtavle i din GEDCOM-konfiguration til en person, der ikke er privat.";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS"]	= "Vis private forhold";
$pgv_lang["SYNC_GEDCOM_FILE_help"] 			= "~#pgv_lang[SYNC_GEDCOM_FILE]#~<br /><br />Indstilling af denne værdi til <b>#pgv_lang[yes]#</b> opdaterer automatisk GEDCOM-filen, når ændringer accepteres i databasen. Dette holder GEDCOM-filen synkroniseret med databasen.<br /><br />Det kan være en god idé at dreje den til <b>#pgv_lang[no]#</b> for at forbedre programmets hastighed og spare hukommelse, når du accepterer ændringer.";
$pgv_lang["SYNC_GEDCOM_FILE"]			= "Synkroniser databaseændringer i GEDCOM-fil";
$pgv_lang["SHOW_MULTISITE_SEARCH_help"]	= "~#pgv_lang[SHOW_MULTISITE_SEARCH]#~<br /><br />Multi-site-søgning giver brugerne mulighed for at søge på tværs af flere PhpGedView-websteder, som du har opsat i Administrer websteder-administrationsområdet eller eksternt linket til. Dette valg styrer, om funktionen Multi-site-søgning er tilgængelig for alle eller kun for godkendte brugere.";
$pgv_lang["SHOW_MULTISITE_SEARCH"]		= "vis søgning på flere sider";
$pgv_lang["SHOW_NO_WATERMARK"]			= "Hvem kan se billeder, der ikke er vandmærket?";
$pgv_lang["SHOW_NO_WATERMARK_help"]		= "~#pgv_lang[SHOW_NO_WATERMARK]#~<br /><br />Hvis mediefirewallen er aktiveret, vil brugerne se vandmærker, hvis de ikke har det privilegieniveau, der er angivet her.";
$pgv_lang["WATERMARK_THUMB"]			= "Føj vandmærker til miniaturer?";
$pgv_lang["WATERMARK_THUMB_help"]		= "~#pgv_lang[WATERMARK_THUMB]#~<br /><br />Hvis mediefirewall er aktiveret, skal miniaturer da være vandmærket? Dine medielister indlæses hurtigere, hvis du ikke vandmærker miniaturebillederne.";
$pgv_lang["SAVE_WATERMARK_THUMB"]		= "Gemme vandmærke miniaturer på serveren?";
$pgv_lang["SAVE_WATERMARK_THUMB_help"]	= "~#pgv_lang[SAVE_WATERMARK_THUMB]#~<br /><br />Hvis mediefirewall er aktiveret, skal kopier af vandmærket miniaturebilleder gemmes på serveren ud over de samme miniaturer uden vandmærker?<br /><br />Når det er indstillet til <b>#pgv_lang[yes]#</b>, produceres medielister indeholdende vandmærke miniaturer hurtigere kl. bekostning af højere serverdiskpladsbehov.";
$pgv_lang["SAVE_WATERMARK_IMAGE"]		= "Gemme vandmærke billeder i fuld størrelse på serveren?";
$pgv_lang["SAVE_WATERMARK_IMAGE_help"]	= "~#pgv_lang[SAVE_WATERMARK_IMAGE]#~<br /><br />Hvis mediefirewall er aktiveret, skal kopier af vandmærket billeder i fuld størrelse gemmes på serveren ud over de samme billeder uden vandmærker?<br /><br />Når indstillet til <b>#pgv_lang[yes]#</b>, vandmærkebilleder i fuld størrelse produceres hurtigere på bekostning af højere serverdiskpladsbehov.";
$pgv_lang["DB_UTF8_COLLATION"]			= "Brug databasen til at levere UTF-8-sortering";
$pgv_lang["DB_UTF8_COLLATION_help"]		= "Styrer, om PhpGedView skal bruge databasens indbyggede sorterings- og sorteringsfaciliteter. Det er generelt hurtigere at bruge databasen til at sortere og filtrere data i stedet for PHP, selvom ikke alle databaser / versioner indeholder denne funktion. Sorteringssekvensen, der bruges for hvert sprog, indstilles på sprogets indstillingsside.<br /><br /><span class=\"warning\">VIGTIGT: Du skal kun indstille denne værdi til <b>#pgv_lang[yes]#</b>, hvis du gør det FØR databasetabellerne oprettes for første gang. Hvis du vælger det i en eksisterende database, kan dine data blive ødelagt.</span><br /><br />MySQL og PostgreSQL tilbyder begge god support til UTF-8, selvom ikke alle sorteringssekvenser er tilgængelige i tidligere versioner af MySQL. Andre databaser tilbyder ringe eller ingen support til UTF-8. Hvis du er usikker på din databases understøttelse af UTF-8, skal du indstille denne værdi til <b>#pgv_lang[no]#</b>.<br /><br />Denne <a href='https://da.wikipedia.org/wiki/UTF-8' target='_blank' title='Wikipedia-artikel'><b>Wikipedia-artikel</b></a> indeholder omfattende oplysninger og links om UTF-8.";
$pgv_lang["INDI_FACTS_ADD"] 			= "fakta at tilføje til personer";
$pgv_lang["INDI_FACTS_ADD_help"]		= "~#pgv_lang[INDI_FACTS_ADD]#~<br /><br />Dette er listen over GEDCOM-fakta, som dine brugere kan tilføje til personer. Du kan ændre denne liste ved at fjerne eller tilføje kendsgerningsnavne, selv tilpassede, efter behov. Fakta navne, der vises på denne liste, må ikke også vises på <i>#pgv_lang[INDI_FACTS_UNIQUE]#</i> listen.";
$pgv_lang["INDI_FACTS_UNIQUE"] 			= "unikke personfakta";
$pgv_lang["INDI_FACTS_UNIQUE_help"]		= "~#pgv_lang[INDI_FACTS_UNIQUE]#~<br /><br />Dette er listen over GEDCOM-fakta, som dine brugere kun kan tilføje <u>en gang</u> til personer. For eksempel, hvis BIRT er på denne liste, vil brugerne ikke være i stand til at tilføje mere end en BIRT-post til en person. Fakta navne, der vises på denne liste, må ikke også vises på <i>#pgv_lang[INDI_FACTS_ADD]#</i> listen.";
$pgv_lang["INDI_FACTS_QUICK"] 			= "hurtige personfakta";
$pgv_lang["INDI_FACTS_QUICK_help"]	= "~#pgv_lang[INDI_FACTS_QUICK]#~<br /><br />Dette er den korte liste over GEDCOM-personfakta, der vises ved siden af den fulde liste og kan tilføjes med et enkelt klik.";
$pgv_lang["FAM_FACTS_ADD"] 			= "fakta at tilføje til familier";
$pgv_lang["FAM_FACTS_ADD_help"]		= "~#pgv_lang[FAM_FACTS_ADD]#~<br /><br />Dette er listen over GEDCOM-fakta, som dine brugere kan føje til familier. Du kan ændre denne liste ved at fjerne eller tilføje kendsgerningsnavne, selv tilpassede, efter behov. Fakta navne, der vises på denne liste, må ikke også vises på <i>#pgv_lang[FAM_FACTS_UNIQUE]#</i> listen.";
$pgv_lang["FAM_FACTS_UNIQUE"] 			= "unikke familiefakta";
$pgv_lang["FAM_FACTS_UNIQUE_help"]		= "~#pgv_lang[FAM_FACTS_UNIQUE]#~<br /><br />Dette er listen over GEDCOM-fakta, som dine brugere kun kan tilføje <u>en gang</u> til familier. For eksempel, hvis MARR er på denne liste, vil brugerne ikke være i stand til at føje mere end en MARR-post til en familie. Fakta navne, der vises på denne liste, må ikke også vises på <i>#pgv_lang[FAM_FACTS_ADD]#</i> listen.";
$pgv_lang["FAM_FACTS_QUICK"] 			= "hurtige familiefakta";
$pgv_lang["FAM_FACTS_QUICK_help"]	= "~#pgv_lang[FAM_FACTS_QUICK]#~<br /><br />Dette er den korte liste over GEDCOM-familiefakta, der vises ved siden af den fulde liste og kan tilføjes med et enkelt klik.";
$pgv_lang["SOUR_FACTS_ADD"] 			= "fakta at tilføje til kilder";
$pgv_lang["SOUR_FACTS_ADD_help"]		= "~#pgv_lang[SOUR_FACTS_ADD]#~<br /><br />Dette er listen over GEDCOM-fakta, som dine brugere kan føje til kilder. Du kan ændre denne liste ved at fjerne eller tilføje kendsgerningsnavne, selv tilpassede, efter behov. Fakta navne, der vises på denne liste, må ikke også vises på <i>#pgv_lang[SOUR_FACTS_UNIQUE]#</i> listen.";
$pgv_lang["SOUR_FACTS_UNIQUE"] 			= "unikke kildefakta";
$pgv_lang["SOUR_FACTS_UNIQUE_help"]		= "~#pgv_lang[SOUR_FACTS_UNIQUE]#~<br /><br />Dette er listen over GEDCOM-fakta, som dine brugere kun kan tilføje <u>en gang</u> til kilder. For eksempel, hvis TITL er på denne liste, vil brugerne ikke være i stand til at tilføje mere end en TITL-post til en kilde. Fakta navne, der vises på denne liste, må ikke også vises på <i>#pgv_lang[SOUR_FACTS_ADD]#</i> listen.";
$pgv_lang["SOUR_FACTS_QUICK"] 			= "hurtige kildefakta";
$pgv_lang["SOUR_FACTS_QUICK_help"]	= "~#pgv_lang[SOUR_FACTS_QUICK]#~<br /><br />Dette er den korte liste over GEDCOM-kildefakta, der vises ved siden af den fulde liste og kan tilføjes med et enkelt klik.";
$pgv_lang["REPO_FACTS_ADD"] 			= "fakta at tilføje til opbevaringssteder";
$pgv_lang["REPO_FACTS_ADD_help"]		= "~#pgv_lang[REPO_FACTS_ADD]#~<br /><br />Dette er listen over GEDCOM-fakta, som dine brugere kan føje til arkiver. Du kan ændre denne liste ved at fjerne eller tilføje kendsgerningsnavne, selv tilpassede, efter behov. Fakta navne, der vises på denne liste, må ikke også vises på <i>#pgv_lang[REPO_FACTS_UNIQUE]#</i> listen.";
$pgv_lang["REPO_FACTS_UNIQUE"] 			= "unikke opbevaringsfakta";
$pgv_lang["REPO_FACTS_UNIQUE_help"]		= "~#pgv_lang[REPO_FACTS_UNIQUE]#~<br /><br />Dette er listen over GEDCOM-fakta, som dine brugere kun kan tilføje <u>en gang</u> til opbevaringssteder. For eksempel, hvis NAME er på denne liste, kan brugerne ikke føje mere end én NAME-post til et lager. Fakta navne, der vises på denne liste, må ikke også vises på <i>#pgv_lang[REPO_FACTS_ADD]#</i> listen.";
$pgv_lang["REPO_FACTS_QUICK"] 			= "hurtige opbevaringsfakta";
$pgv_lang["REPO_FACTS_QUICK_help"]	= "~#pgv_lang[REPO_FACTS_QUICK]#~<br /><br />Dette er den korte liste over GEDCOM repository-fakta, der vises ved siden af den fulde liste og kan tilføjes med et enkelt klik.";
$pgv_lang["LANG_SELECTION_help"]		= "~#pgv_lang[LANG_SELECTION]#~<br /><br />Du kan ændre listen over sprog, der understøttes af dit PhpGedView-websted ved at tilføje eller fjerne markeringer efter behov. Dette ændrer de sprogvalg, der er tilgængelige for dine brugere.<br /><br />Du kan opnå det samme gennem <b>#pgv_lang[enable_disable_lang]#</b> linket i #pgv_lang[admin]# menuen, hvor du også kan ændre ting som sprogets flagikon, datoformat, eller om efternavnet altid skal udskrives først.";
$pgv_lang["MEDIA_ID_PREFIX"]		= "præfiks for medie-id";
$pgv_lang["MEDIA_ID_PREFIX_help"]	= "~#pgv_lang[MEDIA_ID_PREFIX]#~<br /><br />Når en ny medieoptegnelse tilføjes online i PhpGedView, genereres automatisk et nyt ID for dette medie. Medie-id'et har dette præfiks.";
$pgv_lang["FAM_ID_PREFIX"]		= "præfiks for familie-id";
$pgv_lang["FAM_ID_PREFIX_help"]	= "~#pgv_lang[FAM_ID_PREFIX]#~<br /><br />Når en ny familieoptegnelse tilføjes online i PhpGedView, genereres automatisk et nyt ID for den pågældende familie. Familie-id'et har dette præfiks.";
$pgv_lang["QUICK_REQUIRED_FAMFACTS"]			= "Fakta for familier, der altid skal vises på hurtig opdateringsformular";
$pgv_lang["QUICK_REQUIRED_FAMFACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FAMFACTS]#~<br /><br />Dette er en komma-adskilt liste over GEDCOM-faktatags, der altid vises på familiefaner på hurtig opdateringsformular, uanset om de allerede findes i familiens optegnelse. For eksempel, hvis MARR er på listen, vises felter for ægteskabsdato og ægteskabssted altid på formularen.";
$pgv_lang["QUICK_ADD_FAMFACTS"]			= "Fakta for familier, der kan vises på hurtig opdateringsformular";
$pgv_lang["QUICK_ADD_FAMFACTS_help"]		= "~#pgv_lang[QUICK_ADD_FAMFACTS]#~<br /><br />Dette er en komma-adskilt liste over GEDCOM-faktatags, der vises på familiefaner på hurtig opdateringsformular. Kun fakta på denne liste vises på formularen eller gøres tilgængelige for valg i det område, hvor du tilføjer nye fakta på formularen.";
$pgv_lang["QUICK_REQUIRED_FACTS"]			= "Fakta, der altid skal vises på hurtig opdateringsformular";
$pgv_lang["QUICK_REQUIRED_FACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FACTS]#~<br /><br />Dette er en komma-adskilt liste over GEDCOM-faktatags, der altid vises på hurtig opdateringsformular, uanset om de allerede findes i individets rekord eller ej. For eksempel, hvis BIRT er på listen, vises felter for fødselsdato og fødested altid på formularen.";
$pgv_lang["QUICK_ADD_FACTS"]			= "Fakta at vise på hurtig opdateringsformular";
$pgv_lang["QUICK_ADD_FACTS_help"]		= "~#pgv_lang[QUICK_ADD_FACTS]#~<br /><br />Dette er en komma-adskilt liste over GEDCOM-faktatags, der vises på hurtig opdateringsformular. Kun fakta på denne liste vises på formularen eller gøres tilgængelige for valg i det område, hvor du tilføjer nye fakta på formularen.";
$pgv_lang["SURNAME_TRADITION_help"] = "~#pgv_lang[SURNAME_TRADITION]#~<br /><br />Når du føjer nye medlemmer til en familie, kan PhpGedView levere standardværdier for efternavne i henhold til regional skik.<br /><br /><ul><li>I traditionen <b>Faderlig</b> deler alle familiemedlemmer farens efternavn.</li><li>I traditionen <b>spansk</b> og <b>portugisisk</b> får børn et efternavn fra hver forælder.</li><li>I <b>islandsk</b> tradition modtager børn deres mandlige forældres fornavn som efternavn med et suffiks, der angiver køn.</li><li>I den <b>polske</b> tradition deler alle familiemedlemmer farens efternavn. For nogle efternavne angiver suffikset køn. Suffikset <i>ski</i>, <i>cki</i>, og <i>dzki</i> angiver mand, mens de tilsvarende suffikser <i>ska</i>, <i>cka</i>, og <i>dzka</i> angiver hun.</li></ul>";
$pgv_lang["ADVANCED_NAME_FACTS_help"] = "~#pgv_lang[ADVANCED_NAME_FACTS]#~<br /><br />Dette er en komma-adskilt liste over GEDCOM-faktatags, der vises på formularen Tilføj / rediger navn. Hvis du bruger ikke-latinske alfabeter som hebraisk, græsk, kyrillisk eller arabisk, kan du tilføje tags som _HEB, ROMN, FONE osv. For at give dig mulighed for at gemme navne i flere forskellige alfabeter.";
$pgv_lang["ADVANCED_PLAC_FACTS_help"] = "~#pgv_lang[ADVANCED_PLAC_FACTS]#~<br /><br />Dette er en komma-adskilt liste over GEDCOM-faktatags, der vises, når du tilføjer eller redigerer stednavne. Hvis du bruger ikke-latinske alfabeter som hebraisk, græsk, kyrillisk eller arabisk, kan du tilføje tags som _HEB, ROMN, FONE osv., Så du kan gemme stednavne i flere forskellige alfabeter.";
$pgv_lang["GEONAMES_KEY"]				= "geonames.org bruger-id";
$pgv_lang["GEONAMES_KEY_help"]			= "~#pgv_lang[GEONAMES_KEY]#~<br /><br />Denne bruger-id kræves for at få adgang til den gratis geonames.org-database med geografiske navne. Hvis du ikke angiver en gyldig bruger-id, kan du ikke søge i denne database.<br /><br />Du kan anmode om en geonames.org-bruger-id på <a href='http://www.geonames.org/login' target='_blank'><b>geonames.org login-siden</b></a>.<br /><br />Du modtager derefter en e-mail med et bekræftelseslink, og når du har bekræftet e-mailen, kan du aktivere din konto for webservicen på <a href='http://www.geonames.org/manageaccount' target='_blank'><b>din kontoside</b></a>";
$pgv_lang["GEONAMES_BIAS"]				= "geonames.org land bias";
$pgv_lang["GEONAMES_BIAS_help"]			= "~#pgv_lang[GEONAMES_BIAS]#~<br /><br />Normalt viser GeoNames databasesøgningen sine resultater i alfabetisk rækkefølge uden hensyntagen til det land, hvor et sted er placeret. Dette valg specificerer, at steder i det valgte land skal rapporteres øverst på resultatlisten.";
$pgv_lang["GEONAMES_BIAS_no_preference"]= "Ingen præference";
$pgv_lang["GEOCODE_KEY"]				= "Google Geocode Server-nøgle";
$pgv_lang["GEOCODE_KEY_help"]			= "~#pgv_lang[GEOCODE_KEY]#~<br /><br />Denne nøgle kræves for at få adgang til den gratis Google-database med geografiske navne. Hvis du ikke angiver en gyldig nøgle, kan du ikke søge i denne database.<br /><br />Du kan anmode om en nøgle via din <a href='https://developers.google.com/maps/documentation/geocoding/get-api-key' target='_blank'><b>Google Developer Console</b></a>. Du kan se denne side på et andet sprog end engelsk ved at vælge det ønskede sprog nederst på siden.";
$pgv_lang["AUTO_GENERATE_THUMBS"]			= "Automatisk genererede miniaturer";
$pgv_lang["AUTO_GENERATE_THUMBS_help"]		= "~#pgv_lang[AUTO_GENERATE_THUMBS]#~<br /><br />Skulle systemet automatisk generere miniaturebilleder til billeder, der ikke har dem. Din PHP-installation understøtter muligvis ikke denne funktionalitet.";
$pgv_lang["phpinfo_help"]				= "~#pgv_lang[phpinfo]#~<br /><br />Denne side indeholder omfattende oplysninger om den server, som PhpGedView hostes på. Mange konfigurationsoplysninger om serverens software, da det vedrører PHP og PhpGedView, kan ses.";
$pgv_lang["config_help_help"]			= "~#pgv_lang[config_help]#~<br /><br />Denne side samler alle de store emner i konfigurationshjælp på et sted. Du kan se oplysningerne på din skærm, eller du kan udskrive dem til senere brug.";
$pgv_lang["more_help_advice"]			= "<b>Mere hjælp</b><br />Mere hjælp er tilgængelig ved at klikke på <b>#pgv_lang[qm]#</b> ud for elementerne på siden.";
$pgv_lang["THUMBNAIL_WIDTH"]			= "Bredden af genererede miniaturer";
$pgv_lang["THUMBNAIL_WIDTH_help"]		= "~#pgv_lang[THUMBNAIL_WIDTH]#~<br /><br />Dette er den bredde (i pixels), som programmet bruger, når der automatisk genereres miniaturebilleder. Standardindstillingen er 100.";
$pgv_lang["USE_SILHOUETTE"]				= "Brug silhuetter";
$pgv_lang["USE_SILHOUETTE_help"]		= "~#pgv_lang[USE_SILHOUETTE]#~<br /><br />Brug silhuetbilleder, når der ikke er angivet noget fremhævet billede for den person. De anvendte billeder er specifikke for kønnet på den pågældende person.<br /><br /><table><tr><td wrap valign=\"middle\">Dette billede kan bruges, når personens køn er ukendt:</td><td><img src=\"images/silhouette_unknown.gif\" width=\"40\" alt=\"Silhouette image\" title=\"Silhouette image\" /></td></tr></table>";
$pgv_lang["SHOW_SOURCES"]				= "Vis kilder";
$pgv_lang["SHOW_SOURCES_help"]			= "~#pgv_lang[SHOW_SOURCES]#~<br /><br />Indstil privatlivsniveauet for adgang til alle kilder. Hvis brugeren ikke har adgang til kilder, fjernes kildelisten fra menuen Lister, og fanen Kilder vises ikke på siden <i>#pgv_lang[personal_details]#</i>.";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION_help"]	= "~#pgv_lang[REQUIRE_ADMIN_AUTH_REGISTRATION]#~<br /><br />Hvis valget <b>#pgv_lang[USE_REGISTRATION_MODULE]#</b> er aktiveret, styrer denne indstilling, om administratoren skal godkende registreringen.<br /><br />Hvis dette indstilles til <b>#pgv_lang[yes]#</b>, kræves det, at alle nye brugere først bekræfter sig selv og derefter godkendes af en administrator, før de kan logge ind. Med denne indstilling på <b>#pgv_lang[no]#</b> vil <b>#pgv_lang[verified_by_admin]#</b> afkrydsningsfeltet blive markeret automatisk, når brugerne verificerer deres konto, hvilket giver mulighed for et øjeblikkeligt login derefter uden administrationens indblanding.";
$pgv_lang["SPLIT_PLACES"]		= "Opdel steder under redigering";
$pgv_lang["SPLIT_PLACES_help"]	= "~#pgv_lang[SPLIT_PLACES]#~<br /><br />Indstil dette til <b>#pgv_lang[yes]#</b> for at opdele hvert stednavn med kommaer i underfelter for lettere redigering. Eksempel :<br /><ol><li><b>Standard</b><br /><u>Sted</u>: Half Moon Bay, San Mateo, California, USA</li><br /><li><b>Delt</b><br /><u>Land</u>: USA<br /><u>Stat</u>: California<br /><u>Administrativ enhed</u>: San Mateo<br /><u>By</u>: Half Moon Bay</li></ol>";
$pgv_lang["UNDERLINE_NAME_QUOTES"]		= "Understreg navne i anførselstegn";
$pgv_lang["UNDERLINE_NAME_QUOTES_help"]	= "~#pgv_lang[UNDERLINE_NAME_QUOTES]#~<br /><br />Mange programmer placerer det foretrukne fornavn i anførselstegn (<b>\"</b>) i GEDCOM. Den sædvanlige konvention for dette er at understrege det foretrukne fornavn. Aktivering af dette valg konverterer alle navne omgivet af anførselstegn til &lt;span&gt; med en CSS-klasse af \"starredname\".<br /><br />For eksempel, hvis navnet i GEDCOM var 1&nbsp;NAME&nbsp;Gustave&nbsp;\"Jean&nbsp;Paul\"&nbsp;Charles&nbsp;/Wilson/ aktivering dette valg vil ændre den del af navnet, der er indeholdt i anførselstegn til &lt;span&nbsp;class=\"starredname\"&gt;Jean&nbsp;Paul&lt;/span&gt; til trykformål. Afhængig af andre indstillinger, vil browseren derefter vise dette navn som <b>Gustave&nbsp;<u>Jean&nbsp;Paul</u>&nbsp;Charles&nbsp;Wilson</b> eller <b>Wilson,&nbsp;Gustave&nbsp;<u>Jean&nbsp;Paul</u>&nbsp;Charles</b>";
$pgv_lang["PRIVACY_BY_RESN"]		= "Brug GEDCOM (RESN) privatlivsbegrænsning";
$pgv_lang["PRIVACY_BY_RESN_help"]	= "~#pgv_lang[PRIVACY_BY_RESN]#~<br /><br />GEDCOM 5.5.1 specifikationen inkluderer valget mellem at bruge RESN tags til at indstille fortrolighedsvalg for personer og fakta i GEDCOM-filen. Aktivering af dette valg fortæller programmet, at det skal kigge efter niveau 1 RESN tags i GEDCOM-poster. Niveau 2+ RESN tags anvendes automatisk og påvirkes ikke af denne indstilling. Bemærk, at dette muligvis bremser nogle af funktionerne i PhpGedView, f.eks. Personlisten.";
$pgv_lang["SHOW_LDS_AT_GLANCE"]			= "Vis ordineringskoder for SDH kirke i kortfelter";
$pgv_lang["SHOW_LDS_AT_GLANCE_help"]	= "~#pgv_lang[SHOW_LDS_AT_GLANCE]#~<br /><br />Hvis du indstiller dette valg til <b>#pgv_lang[yes]#</b>, vises statuskoder for SDH-ordinancer i diagramfelter.<ul><li><b>B</b> - Dåb</li><li><b>E</b> - Begavet</li><li><b>S</b> - Forseglet til ægtefælle</li><li><b>P</b> - Forseglet til forældre</li></ul>En person, der har udført alle ordinancerne, vil have <b>BESP</b> udskrevet efter deres navn. Manglende ordinancer er angivet med <b>_</b> i stedet for den tilsvarende bogstavkode. For eksempel angiver <b>BE__</b> manglende <b>S</b> og <b>P</b> ordinancer.";
$pgv_lang["GEDCOM_DEFAULT_TAB"]			= "Standardfane, der vises på siden «Personlige detaljer»";
$pgv_lang["GEDCOM_DEFAULT_TAB_help"]	= "~#pgv_lang[GEDCOM_DEFAULT_TAB]#~<br /><br />Dette valg giver dig mulighed for at vælge, hvilken fane der automatisk åbnes på siden «Personlige detaljer», når siden er åbnet.";
$pgv_lang["SHOW_MARRIED_NAMES"]			= "Vis gifte navne på personlisten";
$pgv_lang["SHOW_MARRIED_NAMES_help"]	= "~#pgv_lang[SHOW_MARRIED_NAMES]#~<br /><br />Dette valg viser de giftede navne på kvinder på personlisten. Dette valg kræver, at du beregner de gifte navne, når du importerer GEDCOM-filen.";
$pgv_lang["SHOW_QUICK_RESN"]		= "Vis privatlivsfelter på #pgv_lang[quick_update_title]# formularen";
$pgv_lang["SHOW_QUICK_RESN_help"]		= "~#pgv_lang[SHOW_QUICK_RESN]#~<br /><br />Dette valg giver dig mulighed for at slå privatlivsfelterne til eller fra på #pgv_lang[quick_update_title]# formularen. Privatlivsfelter tillader en bruger, der tilføjer oplysninger gennem formularen, at tilsidesætte standardbeskyttelse for det faktum, at de indtaster.";
$pgv_lang["USE_QUICK_UPDATE"]		= "Brug #pgv_lang[quick_update_title]# formularen";
$pgv_lang["USE_QUICK_UPDATE_help"]		= "~#pgv_lang[USE_QUICK_UPDATE]#~<br /><br />Dette valg bestemmer de brugerrettigheder, der kræves for at indsende ændringer gennem #pgv_lang[quick_update_title]# formularen.<br /><br />Valget <b>#pgv_lang[nobody]#</b> betyder, at denne formular slet ikke kan bruges.";
$pgv_lang["SEARCHLOG_CREATE"]		= "Arkiver søgningslogfiler";
$pgv_lang["SEARCHLOG_CREATE_help"]	= "~#pgv_lang[SEARCHLOG_CREATE]#~<br /><br />Hvor ofte skal programmet arkivere søgningslogfiler.";
$pgv_lang["CHANGELOG_CREATE"]		= "Arkiver ændringslogfiler";
$pgv_lang["CHANGELOG_CREATE_help"]	= "~#pgv_lang[CHANGELOG_CREATE]#~<br /><br />Hvor ofte skal programmet arkivere ændringslogfiler.";
$pgv_lang["CHART_BOX_TAGS"]		= "Andre fakta at vise i diagrammer";
$pgv_lang["CHART_BOX_TAGS_help"]		= "~#pgv_lang[CHART_BOX_TAGS]#~<br /><br />Dette skal være en komma- eller rumsepareret liste over fakta, ud over fødsel og død, som du vil have vist i diagramfelter som stamtavle. Denne liste kræver, at du bruger faktatags som defineret i GEDCOM 5.5.1-standarden. Hvis du f.eks. Vil have, at erhvervet skal vises i feltet, tilføjer du «OCCU» til dette felt.";
$pgv_lang["FULL_SOURCES"]		= "Brug komplette kilde citater";
$pgv_lang["FULL_SOURCES_help"]		= "~#pgv_lang[FULL_SOURCES]#~<br /><br />Kildeciteringer kan omfatte felter til registrering af datakvaliteten (primær, sekundær osv.) Og datoen for hændelsens optagelse i kilden. Hvis du ikke bruger disse felter, kan du deaktivere dem, når du opretter nye kildecitater.";
$pgv_lang["PREFER_LEVEL2_SOURCES"]		= "kildetype";
$pgv_lang["PREFER_LEVEL2_SOURCES_help"]		= "~#pgv_lang[PREFER_LEVEL2_SOURCES]#~<br /><br />Når du tilføjer nye nære slægtninge, kan du tilføje kildecitater til optegnelserne (f.eks. INDI, FAM) eller fakta (BIRT, MARR, DEAT). Dette valg styrer hvilke felter der er markeret som standard.";


//-- CONFIGURE FILE MESSAGES
$pgv_lang["gedcom_conf"]				= "GEDCOM basisvalg";
$pgv_lang["media_conf"]					= "Multimedier";
$pgv_lang["media_general_conf"]	= "Generel";
$pgv_lang["media_firewall_conf"]	= "Mediefirewall";
$pgv_lang["accpriv_conf"]				= "Adgang og privatliv";
$pgv_lang["displ_conf"]					= "Visning, Layout, og Udskrifter";
$pgv_lang["displ_names_conf"]		= "Navn";
$pgv_lang["displ_comsurn_conf"]	= "Oftest forekommende efternavne";
$pgv_lang["displ_layout_conf"]	= "Layout";
$pgv_lang["displ_hide_conf"]		= "Skjul & Vis";
$pgv_lang["displ_reports"]		= "Udskrifter";
$pgv_lang["editopt_conf"]		= "Brugeres redigering";
$pgv_lang["useropt_conf"]				= "Brugerindstillinger";
$pgv_lang["contact_conf"]				= "Kontaktinformation";
$pgv_lang["meta_conf"]			= "Websted og META-tag indstillinger";
$pgv_lang["gedconf_head"]				= "Opsætning af GEDCOM";
$pgv_lang["other_theme"]				= "Andet, indtast venligst";
$pgv_lang["performing_update"]			= "Opdaterer.";
$pgv_lang["config_file_read"]		= "Konfigurationsfil indlæst.";
$pgv_lang["does_not_exist"]				= "eksisterer ikke";
$pgv_lang["media_drive_letter"]		= "Mediestien bør ikke indeholde et drevbogstav; medier vises muligvis ikke.";
$pgv_lang["db_setup_bad"]		= "Din nuværende databasekonfiguration er dårlig. Kontroller dine databaseforbindelsesparametre, og konfigurer igen.";
$pgv_lang["bad_host_user_pass"]		= "PhpGedView kunne ikke oprette forbindelse til din databasehost. Kontroller værten, brugernavnet og adgangskoden for at sikre, at de er korrekte.";
$pgv_lang["bad_database_name"]		= "PhpGedView oprettede en forbindelse til din databasevært, men kunne ikke bruge databasen med det navn, du indtastede. Kontroller, at databasen findes, og at det brugernavn, du indtastede, har de relevante tilladelser til den pågældende database.";
$pgv_lang["db"]						     	= "Database";
$pgv_lang["current_gedcoms"]			= "Aktive slægtsdatabaser (GEDCOM-filer)";
$pgv_lang["ged_gedcom"]					= "GEDCOM-fil";
$pgv_lang["ged_title"]					= "Titel på slægtsdatabasen";
$pgv_lang["ged_config"]					= "Konfigurationsfil";
$pgv_lang["ged_search"]					= "Søgelogfiler";
$pgv_lang["ged_change"]			= "Ændringslogfiler";
$pgv_lang["ged_privacy"]				= "Privatlivsfil";
$pgv_lang["disabled"]					= "Ikke valgt";
$pgv_lang["mouseover"]					= "Ved at føre musen henover";
$pgv_lang["mousedown"]					= "Ved at holde museknappen nede";
$pgv_lang["click"]						= "Ved at klikke med musen";
$pgv_lang["enter_db_pass"]		= "Af sikkerhedshensyn skal du altid indtaste #pgv_lang[DBUSER]# og #pgv_lang[DBPASS]#, når du ændrer konfigurationsværdier.";
$pgv_lang["server_url_note"]	= "Dette skal være URL'en til din PhpGedView-mappe. Du bør kun ændre denne indstilling, hvis du er sikker på, at du ved, hvad du laver. PhpGedView har bestemt, at denne værdi er <b>#GUESS_URL#</b>";

$pgv_lang["DBTYPE"]			= "Database type";
$pgv_lang["DBTYPE_help"]		= "~#pgv_lang[DBTYPE]#~<br /><br />Den type database, der skal oprettes forbindelse til.<br /><br />PhpGedView kan bruge enhver database, der har en PDO-driver tilgængelig. Du skal sikre dig, at din php.ini-fil indlæser både <b>php_pdo</b> biblioteket og den relevante driver til din database, f.eks. <b>php_pdo_mysql</b>.<br /><br />De fleste databaser kræver et brugernavn og en adgangskode. Du skal også oprette databasen, før du installerer PhpGedView. SQLite har dog ikke brug for #pgv_lang[DBHOST]#, #pgv_lang[DBUSER]#, eller #pgv_lang[DBPASS]#, men du bliver nødt til at indstille en filsti til din database i feltet #pgv_lang[DBNAME]#. PhpGedView opretter SQLite-databasefilen til dig.";
$pgv_lang["DBHOST"]			= "Database vært";
$pgv_lang["DBHOST_help"]		= "~#pgv_lang[DBHOST]#~<br /><br />DNS- eller IP-adressen på computeren, der er vært for din databaseserver. Denne indstilling ignoreres, hvis du bruger en SQLite-database.";
$pgv_lang["DBPORT"]			= "Database port";
$pgv_lang["DBPORT_help"]		= "~#pgv_lang[DBPORT]#~<br /><br />TCP-porten, der skal bruges, når du opretter forbindelse til din databaseserver. Lad denne indstilling være tom for at bruge standardporten til din særlige databasetype. Denne indstilling ignoreres, hvis du bruger en SQLite-database.";
$pgv_lang["DBUSER"]			= "Database brugernavn";
$pgv_lang["DBUSER_help"]		= "~#pgv_lang[DBUSER]#~<br /><br />Databasens brugernavn, der kræves for at logge ind på din database. Denne indstilling ignoreres, hvis du bruger en SQLite-database.";
$pgv_lang["DBPASS"]			= "Database adgangskode";
$pgv_lang["DBPASS_help"]		= "~#pgv_lang[DBPASS]#~<br /><br />Database adgangskoden til den bruger, du indtastede i feltet #pgv_lang[DBUSER]#. Denne indstilling ignoreres, hvis du bruger en SQLite-database.";
$pgv_lang["DBNAME"]			= "Database navn";
$pgv_lang["DBNAME_help"]		= "~#pgv_lang[DBNAME]#~<br /><br />Databasen på den server, du vil have, at PhpGedView skal bruge.<br /><br />Brugernavnet, du indtaster i feltet #pgv_lang[DBUSER]#, skal have rettighederne Opret, Indsæt, Opdater, Slet og Vælg i denne database. I SQLite skal du indstille dette til et filnavn i et bibliotek, der kan skrives af PHP, såsom din index mappe (index/phpgedview.db).";
$pgv_lang["TBLPREFIX_help"]		= "~#pgv_lang[TBLPREFIX]#~<br /><br />Et præfiks til navnene på tabellerne oprettet af PhpGedView. Ved at ændre denne værdi kan du oprette flere PhpGedView-steder til at bruge den samme fysiske database, men forskellige tabeller. For eksempel kan det samme sted være vært for en \"test\" samt en \"produktion\" installation af PhpGedView med helt uafhængige datatabeller.";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"]	= "~#pgv_lang[ALLOW_CHANGE_GEDCOM]#~<br /><br />Hvis du har et miljø med flere GEDCOM'er, kan indstillingen af denne værdi til <b>#pgv_lang[yes]#</b> give dine besøgende <u>og</u> brugere mulighed for at vælge at ændre GEDCOM'er. Hvis du indstiller det til <b>#pgv_lang[no]#</b>, deaktiveres GEDCOM-skift for både besøgende <u>og</u> logget ind brugere.";
$pgv_lang["upload_path"]			= "Upload sti";
$pgv_lang["upload_path_help"]		= "~#pgv_lang[upload_path]#~<br /><br />Dette er stien, hvor GEDCOM-filen, du ønsker at uploade, kan findes. For at vælge stien skal du klikke på <b>Gennemse</b> og navigere til din GEDCOM-fil og derefter klikke på <b>Åbn</b>.";
$pgv_lang["gedcom_path"]			= "Sti og navn på GEDCOM på serveren";
$pgv_lang["gedcom_path_help"]		= "~#pgv_lang[gedcom_path]#~<br /><br />Der er to måder at importere din GEDCOM-fil til PhpGedView. De er:<ol><li>Brug et FTP-program til at kopiere filen til serveren</li><li>Upload i PhpGedView</li></ol>Når din fil allerede findes på serveren, aktiverer du proceduren <i>#pgv_lang[add_gedcom]#</i> og udfylder stien og navnet på din GEDCOM-fil, som de findes på serveren. Navnet kan være med eller uden udvidelse. Hvis der ikke gives nogen udvidelse, antages .ged. Stien er valgfri. Hvis der ikke er angivet nogen sti, bruges værdien af <i>#pgv_lang[INDEX_DIRECTORY]#</i> valget, som angivet i din PhpGedView-webstedskonfiguration. Bemærk, at på de fleste servere er fil- og stienavne store og små bogstaver.<br /><br />Når du bruger <i>#pgv_lang[upload_gedcom]#</i> proceduren indbygget i PhpGedView, kan du bruge <b>Gennemse</b> knappen for at finde den ønskede fil på din lokale computer. Dette kan være en almindelig GEDCOM-fil eller en ZIP-fil, der indeholder GEDCOM-filen. PhpGedView udpakker automatisk og bruger derefter GEDCOM-filen indeholdt i den ZIP-fil.<br /><br />Når du uploader en fil, er det muligt at angive en alternativ sti og / eller filnavn for at gemme den under på serveren.<br /><br />Se <a href=\"readme.txt\">Readme.txt</a> filen for at få flere oplysninger.";
$pgv_lang["CHARACTER_SET"]		= "Tegnsæt";
$pgv_lang["CHARACTER_SET_help"]		= "~#pgv_lang[CHARACTER_SET]#~<br /><br />Dette er tegnsættet for din GEDCOM-fil. UTF-8 er standard og skal fungere for næsten alle websteder. Hvis du eksporterer din GEDCOM ved hjælp af IBM Windows-kodning, skal du placere WINDOWS her.<br /><br />BEMÆRK: PhpGedView understøtter ikke UNICODE (UTF-16), fordi supporten mangler i PHP.";
$pgv_lang["LANGUAGE"]			= "Sprog";
$pgv_lang["LANGUAGE_help"]		= "~#pgv_lang[LANGUAGE]#~<br /><br />Tildel webstedets standardsprog.<br /><br />Når valget <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b> er indstillet, kan brugerne tilsidesætte denne indstilling gennem deres browsers foretrukne sprogkonfiguration, konfigurationsvalg på deres kontoside eller via links eller knapper på de fleste PhpGedView-sider.";
$pgv_lang["ENABLE_MULTI_LANGUAGE"]	= "Tillad brugeren at ændre sprog";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"]	= "~#pgv_lang[ENABLE_MULTI_LANGUAGE]#~<br /><br />Indstil til <b>#pgv_lang[yes]#</b> for at tillade brugere at tilsidesætte websteds standardsprog. De kan gøre dette gennem deres browsers foretrukne sprogkonfiguration, konfigurationsvalg på deres kontoside eller gennem links eller knapper på de fleste PhpGedView-sider.";
$pgv_lang["CALENDAR_FORMAT"]		= "Kalenderformat";
$pgv_lang["CALENDAR_FORMAT_help"]	= "~#pgv_lang[CALENDAR_FORMAT]#~<br /><br />Datoer kan registreres i forskellige kalendere som gregoriansk, julian eller den jødiske kalender. Dette valg giver dig mulighed for at konvertere datoer til en foretrukken kalender. For eksempel kan du vælge gregoriansk for at konvertere julianske og hebraiske datoer til gregorianske. Den konverterede dato vises i parentes efter den almindelige dato.<br /><br />Datoer konverteres kun, hvis de er gyldige i kalenderen. F.eks. Konverteres kun datoer mellem 22&nbsp;SEP&nbsp;1792 og 31&nbsp;DEC&nbsp;1805 til den franske republikanske kalender, og kun datoer efter 15&nbsp;OCT&nbsp;1582 konverteres til den gregorianske kalender.<br /><br />Hebraisk er det samme som jødisk, men bruger hebraiske tegn. Arabisk er det samme som Hijri, men bruger arabiske tegn.<br /><br />Bemærk: Da den jødiske og Hijri kalenderdag starter ved skumring, vises enhver begivenhed, der finder sted fra skumring til midnat, som en dag før den korrekte dato. Visningen af hebraisk og arabisk kan være problematisk i gamle browsere, som muligvis viser tekst baglæns (fra venstre mod højre) eller slet ikke.";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"]	= "Vis hebræiske tusindtal";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"]	= "~#pgv_lang[DISPLAY_JEWISH_THOUSANDS]#~<br /><br />Vis Alafim på hebraiske kalendere.<br /><br />Hvis du indstiller dette til <b>#pgv_lang[yes]#</b>, vises året 1969 som <span lang=\"he-IL\" dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; mens du indstiller det til <b>#pgv_lang[no]#</b>, vises året som <span lang=\"he-IL\" dir='rtl'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;.  Dette har ingen indflydelse på det jødiske år. Året vises som 5729 uanset denne indstilling.<br /><br />Bemærk: Denne indstilling svarer til kalenderkonstanten CAL_JEWISH_ADD_ALAFIM.";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]		= "Vis hebræisk Geyrshayim";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"]	= "~#pgv_lang[DISPLAY_JEWISH_GERESHAYIM]#~<br /><br />Vis enkelt- og dobbelt anførselstegn («'» og «\"») ved visning af hebraiske datoer.<br /><br />Indstilling af dette til <b>#pgv_lang[yes]#</b> vises 8. februar 1969 som <span lang='he-IL' dir='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; mens du indstiller det til <b>#pgv_lang[no]#</b>, vises det som <span lang='he-IL' dir='rtl'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;.  Dette har ingen indflydelse på indstillingen for jødisk år, da citater ikke bruges i jødiske datoer, der vises med latinske tegn.<br /><br />Bemærk: Denne indstilling svarer til kalenderkonstanterne CAL_JEWISH_ADD_ALAFIM_GERESH og CAL_JEWISH_ADD_GERESHAYIM. Denne enkelt indstilling påvirker begge dele.";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"]	= "Jødisk Ashkenazi udtale";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"]	= "~#pgv_lang[JEWISH_ASHKENAZ_PRONUNCIATION]#~<br /><br />Når det er indstillet til <b>#pgv_lang[yes]#</b>, stanses månederne Cheshvan og Teves med Ashkenazi-udtale. Hvis det indstilles til <b>#pgv_lang[no]#</b>, ændres månederne til Hesvan og Tevet. Dette påvirker kun den jødiske indstilling. Den hebraiske indstilling bruger altid det hebraiske alfabet.";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"]	= "Antal generationer i slægtstræer";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"]	= "~#pgv_lang[DEFAULT_PEDIGREE_GENERATIONS]#~<br /><br />Angiv antal generationer, der som standard skal vises i slægtstræer.";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"]	= "Maks antal generationer af aner";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"] 	= "~#pgv_lang[MAX_PEDIGREE_GENERATIONS]#~<br /><br />Her anføres det maksimale antal generationer, der skal vises i anetræer.";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"] 	= "Maks antal generationer af efterkommere";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"]	= "~#pgv_lang[MAX_DESCENDANCY_GENERATIONS]#~<br /><br />Her anføres det maksimale antal generationer, der skal vises i efterkommeroversigter.";
$pgv_lang["SOSA_WIDTH_NORMAL"]		= "Normal bredde på SOSA-numre";
$pgv_lang["SOSA_WIDTH_NORMAL_help"]	= "~#pgv_lang[SOSA_WIDTH_NORMAL]#~<br /><br />Hvor meget plads der skal reserveres til SOSA-numre på diagrammer<br /><br /><b>#pgv_lang[variable]#</b> angiver, at bredden ikke er fast, og det udskrevne SOSA-nummer tager så meget plads som det har brug for. Resten af diagrammet placeres i overensstemmelse hermed.";
$pgv_lang["SOSA_WIDTH_WIDE"]		= "Ekstra bredde på SOSA-numre";
$pgv_lang["SOSA_WIDTH_WIDE_help"]	= "~#pgv_lang[SOSA_WIDTH_WIDE]#~<br /><br />Hvor meget plads der skal reserveres til SOSA-numre i pjeceoversigten i efterkommerskemaet<br /><br /><b>#pgv_lang[variable]#</b> angiver, at bredden ikke er fast, og det udskrevne SOSA-nummer tager så meget plads som det har brug for. Resten af diagrammet placeres i overensstemmelse hermed.";
$pgv_lang["USE_RIN"]			= "Brug RIN-nummer i stedet for GEDCOM ID";
$pgv_lang["USE_RIN_help"]		= "~#pgv_lang[USE_RIN]#~<br /><br />Indstil til <b>#pgv_lang[yes]#</b> for at bruge RIN-nummeret i stedet for GEDCOM-id'et, når du bliver bedt om individuelle id'er i konfigurationsfiler, brugerindstillinger og diagrammer. Dette er nyttigt til slægtsforskningsprogrammer, der ikke konsekvent eksporterer GEDCOM'er med det samme ID tildelt hver enkelt, men altid bruger det samme RIN.";
$pgv_lang["GENERATE_GUID"]		= "Opret automatisk globalt unikke IDer";
$pgv_lang["GENERATE_GUID_help"]	= "~#pgv_lang[GENERATE_GUID]#~<br /><br /><b>GUID</b> er i denne sammenhæng et akronym for «Globalt unikt ID».<br /><br />GUID'er er beregnet til at hjælpe med at identificere hver enkelt på en måde, der kan gentages, så centrale organisationer som f.eks. Familiehistorisk center for SDH-kirken i Salt Lake City eller endda kompatible programmer, der kører på din egen server, kan afgøre, om de har at gøre med den samme person, uanset hvor GEDCOM stammer. Målet med Family History Center er at have et centralt arkiv med slægtsdata og udsætte dem via webservices. Dette gør det muligt for ethvert program at få adgang til dataene og opdatere deres data inden for det.<br /><br />Hvis du ikke har til hensigt at dele denne GEDCOM med nogen anden, behøver du ikke lade PhpGedView oprette disse GUID'er; dog vil det ikke skade andet end at øge størrelsen på din GEDCOM.";
$pgv_lang["PEDIGREE_ROOT_ID"] 			= "Standard startperson i slægtsdatabasen";
$pgv_lang["PEDIGREE_ROOT_ID_help"]	= "~#pgv_lang[PEDIGREE_ROOT_ID]#~<br /><br />Indstil identifikatoren for den standardperson, der skal vises på stamtavle og efterkommere.";
$pgv_lang["GEDCOM_ID_PREFIX"] 			= "person-id præfiks";
$pgv_lang["GEDCOM_ID_PREFIX_help"]	= "~#pgv_lang[GEDCOM_ID_PREFIX]#~<br /><br />Når en ny personregistrering tilføjes online i PhpGedView, genereres der automatisk en ny identifikator for den person. Identifikatoren har dette præfiks.";
$pgv_lang["SOURCE_ID_PREFIX"]		= "kilde-ID præfiks";
$pgv_lang["SOURCE_ID_PREFIX_help"]	= "~#pgv_lang[SOURCE_ID_PREFIX]#~<br /><br />Når en ny kildepost tilføjes online i PhpGedView, genereres der automatisk en ny identifikator for den kilde. Identifikatoren har dette præfiks.";
$pgv_lang["REPO_ID_PREFIX"]				= "Opbevaringssted-ID præfiks";
$pgv_lang["REPO_ID_PREFIX_help"]	= "~#pgv_lang[REPO_ID_PREFIX]#~<br /><br />Når en ny lagerregistrering tilføjes online i PhpGedView, genereres der automatisk en ny identifikator for det arkiv. Identifikatoren har dette præfiks.";
$pgv_lang["PEDIGREE_FULL_DETAILS"]	= "Vis detaljer om fødsel og død på diagrammer";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"]	= "~#pgv_lang[PEDIGREE_FULL_DETAILS]#~<br /><br />Dette valg styrer, om fødsels- og dødsoplysningerne skal vises i diagrammer eller ej.";
$pgv_lang["PEDIGREE_SHOW_GENDER"]	= "Vis kønsikon på diagrammer";
$pgv_lang["PEDIGREE_SHOW_GENDER_help"]	= "~#pgv_lang[PEDIGREE_SHOW_GENDER]#~<br /><br />Dette valg styrer, om individets kønsikon skal vises på diagrammer eller ikke.<br /><br />Da køn også er angivet med boksfarven, skjuler dette valg ikke køn. Valget fjerner simpelthen nogle duplikatoplysninger fra feltet.";
$pgv_lang["PEDIGREE_LAYOUT"]		= "Standard stamtavle layout";
$pgv_lang["PEDIGREE_LAYOUT_help"]	= "~#pgv_lang[PEDIGREE_LAYOUT]#~<br /><br />Dette valg indikerer, om stamtavlen skal genereres i liggende eller stående tilstand.";
$pgv_lang["SHOW_EMPTY_BOXES"]		= "Vis tomme felter på stamtavle";
$pgv_lang["SHOW_EMPTY_BOXES_help"]	= "~#pgv_lang[SHOW_EMPTY_BOXES]#~<br /><br />Dette valg styrer, om tomme felter skal vises i stamtavle eller ej.";
$pgv_lang["ZOOM_BOXES"]			= "Zoom bokse på diagrammer";
$pgv_lang["ZOOM_BOXES_help"]		= "~#pgv_lang[ZOOM_BOXES]#~<br /><br />Tillader en bruger at zoome i felter på diagrammer for at få flere oplysninger.<br /><br />Indstil til <b>#pgv_lang[disabled]#</b> for at deaktivere denne funktion. Indstil til <b>#pgv_lang[mouseover]#</b> for at zoome i felter, når brugeren holder musen over ikonet i feltet. Indstil til <b>#pgv_lang[click]#</b> for at zoome i felter, når brugeren klikker på ikonet i feltet.";
$pgv_lang["LINK_ICONS"]			= "vis links på diagrammer";
$pgv_lang["LINK_ICONS_help"]		= "~#pgv_lang[LINK_ICONS]#~<br /><br />Tillader brugeren at vælge links til andre diagrammer og nære slægtninge til personen.<br /><br />Indstil til <b>#pgv_lang[disabled]#</b> for at deaktivere denne funktion. Indstil til <b>#pgv_lang[mouseover]#</b> for at vise linkene, når brugeren holder musen over ikonet i feltet. Indstil til <b>#pgv_lang[click]#</b> for at vise linkene, når brugeren klikker på ikonet i feltet.";
$pgv_lang["ABBREVIATE_CHART_LABELS"]			= "Kortkortetiketter";
$pgv_lang["ABBREVIATE_CHART_LABELS_help"]		= "~#pgv_lang[ABBREVIATE_CHART_LABELS]#~<br /><br />Dette valg styrer, hvorvidt etiketter som <b>Fødsel</b> skal forkortes på diagrammer med kun det første bogstav som <b>F</b>.<br /><br />Du kan tilpasse forkortelserne ved at angive overordnede værdier i filen <i>languages/extra.xx.php</i> for hvert sprog. Hvis du f.eks. Vil bruge <b>*</b> i stedet for <b>N</b> til at forkorte BIRT-fakta på det franske sprog, skal du sætte følgende post i <i>languages/extra.fr.php</i> fil:<br /><code>\$factAbbrev[\"BIRT\"]&nbsp;=&nbsp;\"*\";</code><br /><br />Længden af forkortelser, der er angivet på denne måde, er ikke begrænset til 1 tegn.";
$pgv_lang["SHOW_AGE_DIFF"]			= "Vis forskelle i datoer";
$pgv_lang["SHOW_AGE_DIFF_help"]		= "~#pgv_lang[SHOW_AGE_DIFF]#~<br /><br />Dette valg styrer, om fanen Nære slægtninge skal vise forskelle mellem ægtefælles fødselsdato, mellem ægteskabsdato og fødselsdato for det første barn og mellem fødselsdatoer for børn.";
$pgv_lang["SHOW_PARENTS_AGE"]			= "Vis forældrenes alder ved siden af barnets fødselsdato";
$pgv_lang["SHOW_PARENTS_AGE_help"]		= "~#pgv_lang[SHOW_PARENTS_AGE]#~<br /><br />Dette valg styrer, om alderen på far og mor skal vises ved siden af barnets fødselsdato på kort.";
$pgv_lang["SHOW_RELATIVES_EVENTS"]      = "Vis nære slægtninges begivenheder på siden «Personlige detaljer»";
$pgv_lang["SHOW_RELATIVES_EVENTS_help"] = "~#pgv_lang[SHOW_RELATIVES_EVENTS]#~<br /><br />Fødsler, ægteskaber og slægtninges død er vigtige begivenheder i ens liv. Dette valg styrer, om disse begivenheder skal vises på fanen «Personlige fakta og detaljer» på siden «Personlige detaljer».<br /><br />Begivenhederne, der er berørt af dette valg, er:<ul><li>Ægtefælles død</li><li>Fødsel og død af børn</li><li>Forældres død</li><li>Søskendes fødsel og død</li><li>Bedsteforældres død</li><li>Fødsel og død af forældres søskende</li></ul>";
$pgv_lang["EXPAND_RELATIVES_EVENTS"]      = "Udvid automatisk listen over begivenheder hos nære slægtninge";
$pgv_lang["EXPAND_RELATIVES_EVENTS_help"] = "~#pgv_lang[EXPAND_RELATIVES_EVENTS]#~<br /><br />Dette valg styrer, om listen <i>Begivenheder for nære slægtninge</i> automatisk skal udvides.";
$pgv_lang["EXPAND_SOURCES"]      = "Udvid kilder automatisk";
$pgv_lang["EXPAND_SOURCES_help"] = "~#pgv_lang[EXPAND_SOURCES]#~<br /><br />Dette valg styrer, om indholdet af en <i>SOUR</i> post automatisk skal vises på siden <i>#pgv_lang[personal_details]#</i> eller ej.";
$pgv_lang["EXPAND_NOTES"]      = "Udvid automatisk noter";
$pgv_lang["EXPAND_NOTES_help"] = "~#pgv_lang[EXPAND_NOTES]#~<br /><br />Dette valg styrer, om indholdet af en <i>note</i> post automatisk skal vises på siden <i>#pgv_lang[personal_details]#</i> eller ej.";
$pgv_lang["SHOW_LEVEL2_NOTES"]      = "Vis alle referencer til noter og kilder på fanerne noter og kilder";
$pgv_lang["SHOW_LEVEL2_NOTES_help"] = "~#pgv_lang[SHOW_LEVEL2_NOTES]#~<br /><br />Dette valg styrer, om noter og kildereferencer, der er knyttet til fakta, skal vises på fanerne Noter og kilder på side <i>#pgv_lang[personal_details]#</i>.<br /><br />Normalt viser fanerne Noter og kilder kun noter og kildereferencer, der er vedhæftet direkte til den enkeltes databasepost. Disse er <i>niveau 1</i> Noter og kildehenvisninger.<br /><br />Valget <b>#pgv_lang[yes]#</b> får disse faner til at vise noter og kildehenvisninger, som er en del af de forskellige fakta i den enkeltes databasepost. Disse er <i>niveau 2</i> Noter og kildehenvisninger, fordi de forskellige fakta er på niveau 1.";
$pgv_lang["HIDE_LIVE_PEOPLE"]		= "Aktiver privatliv";
$pgv_lang["HIDE_LIVE_PEOPLE_help"]	= "~#pgv_lang[HIDE_LIVE_PEOPLE]#~<br /><br />Dette valg aktiverer alle privatlivsindstillinger og skjuler detaljerne for levende personer.<br /><br />Levende mennesker defineres som dem, der ikke har en begivenhed, der er nyere end det antal år, der er angivet indstillingen <b>#pgv_lang[MAX_ALIVE_AGE]#</b>, som i øjeblikket er <b>#GLOBALS[MAX_ALIVE_AGE]#</b>. Til dette formål betragtes fødsler af børn også som sådanne begivenheder.";
$pgv_lang["REQUIRE_AUTHENTICATION"]	= "Kræv godkendelse af besøgende";
$pgv_lang["REQUIRE_AUTHENTICATION_help"]	= "~#pgv_lang[REQUIRE_AUTHENTICATION]#~<br /><br />Aktivering af dette valg vil tvinge alle besøgende til at logge på, før de kan se data på webstedet.";
$pgv_lang["PAGE_AFTER_LOGIN"]		= "Side, der skal vises efter login";
$pgv_lang["PAGE_AFTER_LOGIN_help"]	= "~#pgv_lang[PAGE_AFTER_LOGIN]#~<br /><br />Hvilken side skal brugerne se, når de er logget ind?<br /><br />Valget her bestemmer, om et vellykket login får velkomst- eller MyGedView-siden til at vises, når login er udført fra #pgv_lang[welcome_page]#.<br /><br />Et login, der er foretaget fra linket øverst på hver anden side, returnerer brugeren til den side.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"]	= "Velkomsttekst på login-siden";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE]#~<br /><br />Her kan du vælge tekst, der skal vises på loginskærmen. Du skal bestemme, hvilken foruddefineret tekst der er mest passende.<br /><br />Du kan også vælge at indtaste din egen brugerdefinerede velkomsttekst, men den tekst, du indtaster, oversættes ikke, når dine brugere skifter sprog. Men hvis din brugerdefinerede tekst indeholder henvisninger til sprogvariabler, som du kan definere i de forskellige <i>languages/extra.xx.php</i> filer, kan dit websted vise oversat tekst. Se hjælpeteksten, der er tilknyttet <b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#</b> feltet for at få flere oplysninger.<br /><br />De foruddefinerede tekster er:<ul><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT1]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_1]#</div><br /></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT2]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_2]#</div><br /></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT3]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_3]#</div></li></ul>";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT0"]	= "Ingen foruddefineret tekst";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"]	= "Foruddefineret tekst, der angiver, at alle brugere kan anmode om en brugerkonto";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"]	= "Foruddefineret tekst, der angiver admin, beslutter hver anmodning om en brugerkonto";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"]	= "Foruddefineret tekst, der kun angiver familiemedlemmer, kan anmode om en brugerkonto";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"]	= "Vælg brugerdefineret velkomsttekst skrevet nedenfor";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"]	= "Brugerdefineret velkomsttekst";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#~<br /><br />Hvis du har valgt tilpasset velkomsttekst, kan du skrive teksten her. Teksten oversættes IKKE til den besøgendes sprog, men vises nøjagtigt, som du skrev den. Men hvis din brugerdefinerede tekst indeholder referencer til sprogvariabler, som du kan definere i de forskellige <i>languages/extra.xx.php</i> filer, kan dit websted vise oversat tekst.<br /><br />Du kan indsætte HTML-tags i din brugerdefinerede velkomsttekst.<br /><br />Følgende beskrivelse taget fra hjælpeteksten til FAQ-listen gælder også for den brugerdefinerede velkomsttekst.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"] = "Standard overskrift til tilpasset velkomsttekst";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD_help"] = "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST_HEAD]#~<br /><br />Vælg at vise et standardoverskrift til din brugerdefinerede velkomsttekst. Når dine brugere skifter sprog, vises denne overskrift på det nye sprog.<br /><br />Hvis den er indstillet til <b>#pgv_lang[yes]#</b>, ser overskriften ud:<div class=\"list_value_wrap\">#pgv_lang[welcome_text_cust_head]#</div>";
$pgv_lang["SHOW_REGISTER_CAUTION"]			= "Vis aftale om acceptabel brug på siden «Anmod om ny brugerkonto»";
$pgv_lang["SHOW_REGISTER_CAUTION_help"]		= "~#pgv_lang[SHOW_REGISTER_CAUTION]#~<br /><br />Når indstillet til <b>#pgv_lang[yes]#</b>, vises følgende meddelelse over indtastningsfelterne på siden <i>#pgv_lang[requestaccount]#</i>:<div class=\"list_value_wrap\"><br />#pgv_lang[acceptable_use]#</div>";
$pgv_lang["CHECK_CHILD_DATES"]		= "Kontroller børns datoer";
$pgv_lang["CHECK_CHILD_DATES_help"]	= "~#pgv_lang[CHECK_CHILD_DATES]#~<br /><br />Kontroller børns datoer, når du bestemmer, om en person er død. På ældre systemer og store GEDCOM'er kan dette nedsætte svartiden på dit websted.";
$pgv_lang["MAX_ALIVE_AGE"]		= "Alder, hvor man antager, at en person er død";
$pgv_lang["MAX_ALIVE_AGE_help"]		= "~#pgv_lang[MAX_ALIVE_AGE]#~<br /><br />Hvis denne person har andre begivenheder end død, begravelse eller kremering, der er nyere end dette antal år, anses han for at være \"levende\". Børns fødselsdatoer betragtes som sådanne begivenheder til dette formål.";
$pgv_lang["SHOW_GEDCOM_RECORD"]		= "Tillad brugere at se rå GEDCOM-poster";
$pgv_lang["SHOW_GEDCOM_RECORD_help"]	= "~#pgv_lang[SHOW_GEDCOM_RECORD]#~<br /><br />Hvis du indstiller dette til <b>#pgv_lang[yes]#</b>, placeres links på enkeltpersoner, kilder og familier, så brugerne kan åbne et andet vindue, der indeholder rådataene taget direkte ud af GEDCOM-filen.";
$pgv_lang["ALLOW_EDIT_GEDCOM"]		= "Aktivér online redigering";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"]	= "~#pgv_lang[ALLOW_EDIT_GEDCOM]#~<br /><br />Dette valg muliggør online redigeringsfunktioner for denne database, så brugere med redigeringsrettigheder kan opdatere data online.";
$pgv_lang["ENABLE_AUTOCOMPLETE"]	= "Aktivér Autofuldførelse";
$pgv_lang["ENABLE_AUTOCOMPLETE_help"]	= "~#pgv_lang[ENABLE_AUTOCOMPLETE]#~<br /><br />Dette valg bestemmer, om Autofuldførelse skal være aktiv, mens information indtastes i visse felter på inputformularer. Når dette valg er indstillet til <b>#pgv_lang[yes]#</b>, angives tekstinputfelter, som Autofuldførelse er mulig for, med en forskelligt farvet baggrund.<br /><br />Når Autofuldførelse er aktiv, er PhpGedView vil søge i dens database efter mulige match i henhold til det, du allerede har indtastet. Når du indtaster flere oplysninger, forbedres listen over mulige kampe. Når du ser det ønskede input på listen over matches, kan du flytte musemarkøren til den linje på listen og derefter klikke på venstre museknap for at fuldføre input.<br /><br />Ulemperne ved Autofuldførelse er, at det bremser programmet, indebærer betydelig databaseaktivitet og resulterer også i, at flere data sendes til browseren.";
$pgv_lang["USE_REFN"]		= "Brug Referencenummer";
$pgv_lang["USE_REFN_help"]	= "~#pgv_lang[USE_REFN]#~<br /><br />Denne mulighed bestemmer, om #factarray[REFN]# indtastet i detaljerne for en <u>ny</u> person skal bruges som ID-nummer for den nye person.<br /><br />Når denne indstilling er indstillet til <b>#pgv_lang[yes]#</b>, skal det indtastede #factarray[REFN]# følge de regler, der er oprettet for alle ID-numre, og en person med dette ID må ikke allerede eksistere database. Hvis disse betingelser ikke er opfyldt, eller hvis denne mulighed er indstillet til <b>#pgv_lang[no]#</b>, tildeler PhpGedView automatisk det næste tilgængelige ID-nummer til den nye person.<br /><br />Gyldige ID-numre kan kun indeholde bogstaverne <b>A</b> til <b>Z</b>, <b>a</b> til <b>z</b>, cifre <b>0</b> til <b>9</b>, og specialsymbolerne <b>. : -</b> og <b>_</b><br /><br />Du skal også aktivere visning af #factarray[REFN]# ved at tilføje posten <b>REFN</b> til <b>#pgv_lang[INDI_FACTS_UNIQUE]#</b>, <b>#pgv_lang[INDI_FACTS_QUICK]#</b> og <b>#pgv_lang[QUICK_REQUIRED_FACTS]#</b> konfigurationsmuligheder nedenfor.";
$pgv_lang["EDIT_AUTOCLOSE"]		= "Luk redigeringsvinduet automatisk";
$pgv_lang["EDIT_AUTOCLOSE_help"]	= "~#pgv_lang[EDIT_AUTOCLOSE]#~<br /><br />Dette valg styrer, om redigeringsvinduet automatisk skal lukkes efter en vellykket opdatering.";
$pgv_lang["INDEX_DIRECTORY_help"]	= "~#pgv_lang[INDEX_DIRECTORY]#~<br /><br />Stien til en læsbar og skrivbar mappe, hvor PhpGedView skal gemme indeksfiler (inkluderer den efterfølgende \"/\"). PhpGedView kræver ikke, at dette biblioteksnavn er \"index\". Du kan vælge et hvilket som helst navn, du kan lide.<br /><br />Af sikkerhedshensyn skal denne mappe placeres et eller andet sted i serverens filplads, der ikke er tilgængelig fra Internettet. Et eksempel på en sådan struktur følger:<br /><br /><b>PhpGedView:</b> dir1/dir2/dir3/PhpGedView <br /> <b>Index:</b> dir1/dir4/dir5/dir6/index<br /><br />For det viste eksempel skal du indtaste <b>../../dir4/dir5/dir6/index/</b> i dette felt.";
$pgv_lang["POSTAL_CODE"]  = "Postnummer position";
$pgv_lang["POSTAL_CODE_help"] = "~#pgv_lang[POSTAL_CODE]#~<br /><br />Forskellige lande bruger forskellige måder at skrive adressen på. Dette valg giver dig mulighed for at placere postnummeret enten før eller efter bynavnet.";
$pgv_lang["SUBLIST_TRIGGER_I"]		= "Maksimalt antal efternavne";
$pgv_lang["SUBLIST_TRIGGER_I_help"]	= "~#pgv_lang[SUBLIST_TRIGGER_I]#~<br /><br />Lange lister over personer med samme efternavn kan opdeles i mindre underlister i henhold til det første bogstav i individets fornavn.<br /><br />Dette valg bestemmer, hvornår underliste over efternavne skal forekomme. For at deaktivere underfortegnelse fuldstændigt skal du indstille dette valg til nul.";
$pgv_lang["SUBLIST_TRIGGER_F"]		= "Maksimalt antal familienavne";
$pgv_lang["SUBLIST_TRIGGER_F_help"]	= "~#pgv_lang[SUBLIST_TRIGGER_F]#~<br /><br />Lange lister over familier med samme navn kan opdeles i mindre underlister i henhold til det første bogstav i det givne navn.<br /><br />Dette valg bestemmer, hvornår underliste af familienavne skal forekomme. For at deaktivere underfortegnelse fuldstændigt skal du indstille dette valg til nul.";
$pgv_lang["SURNAME_LIST_STYLE"]		= "Efternavn liste stil";
$pgv_lang["SURNAME_LIST_STYLE_help"]	= "~#pgv_lang[SURNAME_LIST_STYLE]#~<br /><br />Lister over efternavne, som de vises i #pgv_lang[block_top10]# blok, #pgv_lang[individual_list]# og #pgv_lang[family_list]#, kan vises i forskellige stilarter.<ul><li><b>#pgv_lang[style2]#</b>&nbsp;&nbsp;&nbsp;I denne stil vises efternavne i en tabel, der kan sorteres efter efternavn eller antal.</li><li><b>#pgv_lang[style3]#</b>&nbsp;&nbsp;&nbsp;I denne stil vises efternavne på en liste, og den skriftstørrelse, der bruges til hvert navn, afhænger af antallet af forekomster af dette navn i databasen. Listen kan ikke sorteres.</li></ul>";
$pgv_lang["SHOW_ID_NUMBERS_help"]	= "~#pgv_lang[SHOW_ID_NUMBERS]#~<br /><br />Dette valg styrer, om identifikationsnumre skal vises i parentes efter navne på diagrammer og lister.";
$pgv_lang["SHOW_LAST_CHANGE"]		= "Vis dato for sidste ændring på lister";
$pgv_lang["SHOW_LAST_CHANGE_help"]	= "~#pgv_lang[SHOW_LAST_CHANGE]#~<br /><br />Dette valg styrer, om GEDCOM-registreringen skal vises for sidste ændringsdato på lister eller ej.";
$pgv_lang["SHOW_EST_LIST_DATES"]		= "Vis estimerede datoer for fødsel og død";
$pgv_lang["SHOW_EST_LIST_DATES_help"]	= "~#pgv_lang[SHOW_EST_LIST_DATES]#~<br /><br />Dette valg styrer, hvorvidt estimerede datoer for fødsel og død skal vises i stedet for at efterlade tomme felter på individuelle lister og diagrammer for personer, hvis datoer ikke er kendt.";
$pgv_lang["SHOW_PEDIGREE_PLACES"]	= "antal stedniveauer, der skal vises personligt i felter";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"]	= "~#pgv_lang[SHOW_PEDIGREE_PLACES]#~<br /><br />Dette indstiller, hvor meget af stedoplysningerne der vises i personfelterne på diagrammerne.<br /><br />Hvis du indstiller værdien til 9, vises alle stedniveauer. Hvis du indstiller værdien til 0, skjules steder fuldstændigt. Indstilling af værdien til 1 viser det første niveau, indstilling til 2 viser de to første niveauer osv.";
$pgv_lang["pageSizeDefault"]			= "Standard sidestørrelse";
$pgv_lang["pageSizeDefault_help"]		= "~#pgv_lang[pageSizeDefault]#~<br /><br />Dette er standardsidestørrelsen for alle rapporter. Dit valg kan tilsidesættes i de enkelte rapporter.";
$pgv_lang["pageSizeOptions"]			= "Sidestørrelser";
$pgv_lang["pageSizeOptions_help"]		= "~#pgv_lang[pageSizeOptions]#~<br /><br />Dette er listen over sidestørrelser, der aktuelt understøttes af PhpGedView, når der genereres rapporter. Du kan udvide denne liste ved at tilføje andre standard sidestørrelser som anført i <a href='https://da.wikipedia.org/wiki/Størrelser_(papir)' title='Wikipedia Artikel' target='_blank'><b>Wikipedia Artikel</b></a><br /><ul><li>Standardsidestørrelse for det meste af verden er <b>A4</b>, hvilket svarer til 210 x 297 mm (8,3 x 11,7 tom.)</li><li>Den nordamerikanske standardstørrelse på siden er <b>letter</b>, hvilket svarer til 216 x 279 mm (8,5 x 11,0 tom.)</li><li>Andre tilgængelige størrelser er <b>A3</b>, hvilket svarer til 297 x 420 mm (11,7 x 16,5 tom.)</li><li>og <b>legal</b>, hvilket svarer til 216 x 356 mm (8,5 x 14,0 tom.)</li></ul><br />Forsigtighed tilrådes, når der tilføjes andre papirstørrelser end dem, der er på ISO «A» listen; ikke alle ISO-standardstørrelser er blevet testet.";
$pgv_lang["fontsDefault"]				= "Standard skrifttype";
$pgv_lang["fontsDefault_help"]			= "~#pgv_lang[fontsDefault]#~<br /><br />Dette er standardskrifttypen for alle rapporter. Dit valg kan tilsidesættes i de enkelte rapporter.";
$pgv_lang["fontsOptions"]				= "Skrifttyper";
$pgv_lang["fontsOptions_help"]			= "~#pgv_lang[fontsOptions]#~<br /><br />Dette er listen over skrifttyper, der aktuelt understøttes af PhpGedView, når der genereres rapporter.<br /><br />Du kan udvide denne liste eller forkorte den efter behov. Forsigtighed tilrådes, når du udvider denne liste; ikke alle skrifttyper, der findes i <i>includes/tcpdf/fonts</i> biblioteket, er blevet testet.";
$pgv_lang["MULTI_MEDIA"]		= "Aktivér multimediefunktioner";
$pgv_lang["MULTI_MEDIA_help"]		= "~#pgv_lang[MULTI_MEDIA]#~<br /><br />GEDCOM 5.5.1 giver dig mulighed for at linke billeder, videoer og andre multimedieobjekter til din GEDCOM. Hvis du ikke inkluderer multimedieobjekter i din GEDCOM, kan du deaktivere multimediefunktionerne ved at indstille denne værdi til b>#pgv_lang[no]#</b>.<br /><br />Se afsnittet Multimedia i <a href=\"readme.txt\">readme.txt</a> filen for at få flere oplysninger om medtagelse af medier på dit websted.";
$pgv_lang["MEDIA_EXTERNAL"]			= "Behold links";
$pgv_lang["MEDIA_EXTERNAL_help"]	= "~#pgv_lang[MEDIA_EXTERNAL]#~<br /><br />Når der findes et multimedielink, der starter med for eksempel http://, ftp://, mms://, ændres det ikke, når det er indstillet til <b>#pgv_lang[yes]#</b>. For eksempel http://www.myfamily.com/photo/dad.jpg forbliver http://www.myfamily.com/photo/dad.jpg. Når den er indstillet til <b>#pgv_lang[no]#</b>, håndteres linket som en standardreference, og mediedybden vil blive brugt. For eksempel: http://www.myfamily.com/photo/dad.jpg ændres til ./media/dad.jpg";
$pgv_lang["MEDIA_DIRECTORY"]		= "MultiMedia-mappe";
$pgv_lang["MEDIA_DIRECTORY_help"]	= "~#pgv_lang[MEDIA_DIRECTORY]#~<br /><br />Stien til en læsbar og skrivbar mappe, hvor PhpGedView skal gemme mediefiler (inkluderer den efterfølgende \"/\"). PhpGedView kræver ikke, at dette biblioteksnavn er \"media\". Du kan vælge et hvilket som helst navn, du kan lide.<br /><br />Selvom mediefirewall-funktionen giver dig mulighed for at gemme mediefiler i et område af serverens filplads, der ikke er tilgængeligt fra Internettet, skal den katalog, der er nævnt her, stadig eksistere og skal kunne læses fra Internettet og skrives af PhpGedView. For mere information henvises til valg af konfiguration af mediefirewall i sektionen Multimedia på GEDCOM-konfigurationssiden.";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"]	= "Multi-Media-katalogniveauer at beholde";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"]	= "~#pgv_lang[MEDIA_DIRECTORY_LEVELS]#~<br /><br />En værdi på 0 ignorerer alle mapper i filstien til medieobjektet. En værdi på 1 bevarer den første mappe, der indeholder dette billede. Forøgelse af antallet øger antallet af overordnede mapper, der skal bevares i stien.<br /><br />Hvis du f.eks. Linker et billede i din GEDCOM med en sti som <b><b>C:\\Documents&nbsp;and&nbsp;Settings\\User\\My&nbsp;Documents\\My&nbsp;Pictures\\Genealogy\\Surname&nbsp;Line\\grandpa.jpg</b></b>, en værdi på 0 oversætter denne sti til <b>./media/grandpa.jpg</b>. En værdi på 1 oversætter dette til <b><b>./media/Surname&nbsp;Line/grandpa.jpg</b></b> osv. De fleste personer behøver kun at bruge en 0. Det er dog muligt, at nogle medieobjekter holdes i forskellige kataloger har identiske navne og vil overskrive hinanden, når dette valg er indstillet til 0. Ikke-nul-indstillinger giver dig mulighed for at beholde en organisation i dine medier og derved forhindre navnekollisioner.";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"]	= "~#pgv_lang[SHOW_HIGHLIGHT_IMAGES]#~<br /><br />Hvis du har aktiveret multimedie på dit websted, kan du få PhpGedView til at vise et miniaturebillede ved siden af personens navn i diagrammer og felter.<br /><br />Se afsnittet Multimedie i <a href=\"readme.txt\">readme.txt</a> fil for at få flere oplysninger om medtagelse af medier på dit websted.";
$pgv_lang["USE_THUMBS_MAIN"]	= "Brug miniaturebillede";
$pgv_lang["USE_THUMBS_MAIN_help"]	= "~#pgv_lang[USE_THUMBS_MAIN]#~<br /><br />Dette valg bestemmer, om PhpGedView skal sende det store eller det lille billede til browseren, når et diagram eller siden <i>#pgv_lang[personal_details]#</i> kræver en miniaturebillede.<br /><br /><b>#pgv_lang[no]#</b> valg vil medføre, at PhpGedView sender det store billede, mens valget <b>#pgv_lang[yes]#</b> får det lille billede til at blive sendt. Hvert enkelt billede har også «#factarray[_THUM]#» valg, som, når det er indstillet til <b>#pgv_lang[yes]#</b>, får det store billede til at blive sendt uanset indstillingen af «#pgv_lang[USE_THUMBS_MAIN]#» valg i GEDCOM-konfigurationen. Du kan ikke tvinge PhpGedView til at sende små billeder, når GEDCOM-konfigurationen angiver, at store billeder altid skal bruges.<br /><br />PhpGedView ændrer ikke størrelsen på det billede, der sendes; browseren gør dette i henhold til de sidespecifikationer, den også har modtaget. Dette kan have uønskede konsekvenser, når det billede, der sendes, ikke er en miniaturebillede, hvor PhpGedView forventer at sende et lille billede. Dette er ikke en fejl: Der er lejligheder, hvor det kan være ønskeligt at vise et stort billede steder, hvor man normalt forventer at se et billede i miniaturestørrelse.<br /><br />Du bør undgå at indstille «#pgv_lang[USE_THUMBS_MAIN]#» valg til <b>#pgv_lang[no]#</b>. Dette valg medfører, at der sendes for store mængder billedrelaterede data til browseren, kun for at browseren kasserer det overskydende. Sideindlæsninger, især af diagrammer med mange billeder, kan sænkes alvorligt.";
$pgv_lang["SHOW_MEDIA_FILENAME"]		= "Vis filnavn i mediefremviser";
$pgv_lang["SHOW_MEDIA_FILENAME_help"]	= "~#pgv_lang[SHOW_MEDIA_FILENAME]#~<br /><br />Medievisningen kan vise navnet på den mediefil, der vises. Dette valg bestemmer, om filnavnet vises for brugerne eller ej.<br /><br />Det kan være en god idé at skjule filnavnet af sikkerhedsmæssige årsager.";
$pgv_lang["SHOW_MEDIA_DOWNLOAD"]		= "Vis downloadlink i mediefremviser";
$pgv_lang["SHOW_MEDIA_DOWNLOAD_help"]	= "~#pgv_lang[SHOW_MEDIA_DOWNLOAD]#~<br /><br />Mediefremviseren kan vise et link, som, når der klikkes på det, downloader mediefilen til den lokale PC.<br /><br />Det kan være en god idé at skjule downloadlinket af sikkerhedsmæssige årsager.";
$pgv_lang["ENABLE_CLIPPINGS_CART"] 		= "Aktivere udklipsholderen";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"] = "~#pgv_lang[ENABLE_CLIPPINGS_CART]#~<br /><br />Udklipsholderen giver de besøgende på din side mulighed for at kopiere dine data og gemme dem i en udklipsfil, som de så senere kan downloade som en GEDCOM-fil og importere i deres eget slægtsprogram.";
$pgv_lang["HIDE_GEDCOM_ERRORS"] 		= "Skjul GEDCOM-fejlmeddelelser";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"]	= "~#pgv_lang[HIDE_GEDCOM_ERRORS]#~<br /><br />Hvis du indstiller dette til <b>#pgv_lang[yes]#</b>, skjules fejlmeddelelser produceret af PhpGedView, når det ikke forstår et tag i din GEDCOM-fil. PhpGedView gør alt for at overholde GEDCOM 5.5.1-standarden, men mange slægtsforskningsprogrammer inkluderer deres egne brugerdefinerede tags. Se <a href=\"readme.txt\">readme.txt</a> filen for at få flere oplysninger.";
$pgv_lang["WORD_WRAPPED_NOTES"]		= "Indsæt et mellemrum, hvor linier er delt";
$pgv_lang["WORD_WRAPPED_NOTES_help"]	= "~#pgv_lang[WORD_WRAPPED_NOTES]#~<br /><br />Nogle slægtsforskningsprogrammer pakker noter ved ordgrænser, mens andre pakker noter overalt. Dette kan få PhpGedView til at køre ord sammen. Hvis du indstiller dette til <b>#pgv_lang[yes]#</b>, tilføjes et mellemrum mellem ord, hvor de er pakket ind i den originale GEDCOM.";
$pgv_lang["SHOW_CONTEXT_HELP"]		= "Vis sammenhængende Hjælplinks";
$pgv_lang["SHOW_CONTEXT_HELP_help"]	= "~#pgv_lang[SHOW_CONTEXT_HELP]#~<br /><br />Dette valg giver links, identificeret ved spørgsmålstegn, ved siden af emner på mange sider. Disse links giver brugerne mulighed for at få information eller hjælp om disse emner.";
$pgv_lang["DAYS_TO_SHOW_LIMIT"]		= "Kommende begivenheder blokerer dagsgrænsen";
$pgv_lang["DAYS_TO_SHOW_LIMIT_help"] = "~#pgv_lang[DAYS_TO_SHOW_LIMIT]#~<br /><br />Indtast det maksimale antal dage, der skal vises i blokke for kommende begivenheder. Dette tal må ikke være større end 30. Hvis du indtaster en større værdi, vil der blive brugt 30.<br /><br />Den værdi, du indtaster her, bestemmer, hvor langt fremad PhpGedView ser ud, når du søger efter kommende begivenheder. Resultaterne af denne søgning, udført en gang dagligt, kopieres til en midlertidig fil.<br /><br />Ingen kommende hændelsesblokke på velkomst- eller MyDedView sider kan anmode om flere dage end denne værdi. Jo større du laver dette, jo længere tid vil det tage at opbygge den daglige databaseekstrakt, og jo længere tid vil det tage at vise blokken, selv når du anmoder om at få vist et antal dage mindre end denne indstilling.";
$pgv_lang["COMMON_NAMES_THRESHOLD"]	= "Antal Oftest forekommende efternavne";
$pgv_lang["COMMON_NAMES_THRESHOLD_help"]	= "~#pgv_lang[COMMON_NAMES_THRESHOLD]#~<br /><br />Dette er det antal gange, et efternavn skal forekomme, før det vises på listen over hyppigt forekommende efternavne på velkomstsiden.";
$pgv_lang["COMMON_NAMES_ADD"]	= "Navne, der skal tilføjes til hyppigt forekommende efternavneliste";
$pgv_lang["COMMON_NAMES_ADD_help"]	= "~#pgv_lang[COMMON_NAMES_ADD]#~<br /><br />Hvis antallet af gange, et bestemt efternavn forekommer, er lavere end tærsklen, vises det ikke på listen. Det kan tilføjes her manuelt. Hvis der er indtastet mere end et efternavn, skal de adskilles med et komma. <b>Efternavne er store og små bogstaver.</b>";
$pgv_lang["COMMON_NAMES_REMOVE"]	= "Navne, der skal fjernes fra hyppigt forekommende efternavneliste";
$pgv_lang["COMMON_NAMES_REMOVE_help"]	= "~#pgv_lang[COMMON_NAMES_REMOVE]#~<br /><br />Hvis du vil fjerne et efternavn fra listen Almindeligt efternavn uden at øge tærskelværdien, kan du gøre det ved at indtaste efternavnet her. Hvis der er indtastet mere end et efternavn, skal de adskilles med et komma. <b>Efternavne er store og små bogstaver.</b> Efternavne, der indtastes her, fjernes også fra Top 10-listen på velkomstsiden.";
$pgv_lang["HOME_SITE_URL"]		= "URL til hovedwebsted";
$pgv_lang["HOME_SITE_URL_help"]		= "~#pgv_lang[HOME_SITE_URL]#~<br /><br />Hver PhpGedView-side indeholder et link til din vigtigste startside. Udseendet på dette link styres af det tema, der bruges. Du indtaster den aktuelle URL til dit Hjemmeside her.";
$pgv_lang["HOME_SITE_TEXT"]		= "titel på hovedwebsted";
$pgv_lang["HOME_SITE_TEXT_help"]	= "~#pgv_lang[HOME_SITE_TEXT]#~<br /><br />Teksten, der bruges til at identificere linket til din hovedside.";
$pgv_lang["CONTACT_EMAIL"]		= "Slægtsforskningskontakt";
$pgv_lang["CONTACT_EMAIL_help"]		= "~#pgv_lang[CONTACT_EMAIL]#~<br /><br />Den person, der skal kontaktes om genealogiske data på dette websted.";
$pgv_lang["CONTACT_METHOD"]		= "Kontakt metode";
$pgv_lang["CONTACT_METHOD_help"]	= "~#pgv_lang[CONTACT_METHOD]#~<br /><br />Metoden, der skal bruges til at kontakte #pgv_lang[CONTACT_EMAIL]# om slægtsspørgsmål.#pgv_lang[CONTACT_METHOD_desc]#";
$pgv_lang["CONTACT_METHOD_desc"] = "<ul><li>Valget <b>#pgv_lang[mailto]#</b> vil oprette et \"mailto\" link, der kan klikkes for at sende en e-mail ved hjælp af mailklienten på brugerens pc.</li><li>Valget <b>#pgv_lang[messaging]#</b> bruger et internt meddelelsessystem til PhpGedView, og der sendes ingen e-mails.</li><li>Valget <b>#pgv_lang[messaging2]#</b> er standard. Det bruger PhpGedView-messaging-systemet og sender også kopier af meddelelserne via e-mail.</li><li>Valget <b>#pgv_lang[messaging3]#</b> giver PhpGedView mulighed for at håndtere beskederne og sender beskederne som e-mails, men gemmer ikke beskederne internt. Dette valg svarer til valget <b>#pgv_lang[mailto]#</b>, bortset fra at meddelelsen sendes af PhpGedView i stedet for brugerens arbejdsstation.</li><li>Valget <b>#pgv_lang[no_messaging]#</b> resulterer i, at dine brugere ikke har nogen måde at kontakte dig på.</li></ul>";
$pgv_lang["PHPGEDVIEW_EMAIL"]		= "PhpGedView-svaradresse";
$pgv_lang["PHPGEDVIEW_EMAIL_help"]	= "~#pgv_lang[PHPGEDVIEW_EMAIL]#~<br /><br />E-mail-adresse, der skal bruges i «Fra:» felt af e-mails, som PhpGedView opretter automatisk.<br /><br />PhpGedView kan automatisk oprette e-mails for at underrette administratorer om ændringer, der skal gennemgås. PhpGedView sender også e-mails med notifikationer til brugere, der har anmodet om en konto.<br /><br />Normalt vises «Fra:» felt med disse automatisk oprettede e-mails er noget som <i>Fra: phpgedview-noreply@dinside</i> for at vise, at der ikke kræves noget svar på e-mailen. For at beskytte mod spam eller andet misbrug af e-mail kræver nogle e-mail-systemer hver meddelelses «Fra:»; felt for at afspejle en gyldig e-mail-konto og accepterer ikke beskeder, der tilsyneladende kommer fra konto <i>phpgedview-noreply</i>. E-mail-adresse, der skal bruges i «Fra:» felt af e-mails, som PhpGedView opretter automatisk.<br /><br />PhpGedView kan automatisk oprette e-mails for at underrette administratorer om ændringer, der skal gennemgås. PhpGedView sender også e-mails med notifikationer til brugere, der har anmodet om en konto.<br /><br />Normalt vises «Fra:» felt med disse automatisk oprettede e-mails er noget som <i>Fra: phpgedview-noreply@dinside</i> for at vise, at der ikke kræves noget svar på e-mailen. For at beskytte mod spam eller andet misbrug af e-mail kræver nogle e-mail-systemer hver meddelelses «Fra:» felt for at afspejle en gyldig e-mail-konto og accepterer ikke beskeder, der tilsyneladende kommer fra konto <i>phpgedview-noreply</i>.";
$pgv_lang["WEBMASTER_EMAIL"]		= "Supportkontakt";
$pgv_lang["WEBMASTER_EMAIL_help"]	= "~#pgv_lang[WEBMASTER_EMAIL]#~<br /><br />Den person, der skal kontaktes om tekniske spørgsmål eller fejl på dit websted.";
$pgv_lang["SUPPORT_METHOD"]		= "Support metode";
$pgv_lang["SUPPORT_METHOD_help"]	= "~#pgv_lang[SUPPORT_METHOD]#~<br /><br />Metoden, der skal bruges til at kontakte #pgv_lang[WEBMASTER_EMAIL]# om tekniske spørgsmål.#pgv_lang[CONTACT_METHOD_desc]#";
$pgv_lang["SHOW_FACT_ICONS"] 		= "Vis ikoner med fakta";
$pgv_lang["SHOW_FACT_ICONS_help"]	= "~#pgv_lang[SHOW_FACT_ICONS]#~<br /><br />Indstil dette til <b>#pgv_lang[yes]#</b> for at få vist ikoner nær faktanavne på siden <i>#pgv_lang[personal_details]#</i>. Faktiske ikoner vises kun, hvis de findes i <i>images/facts</i> mappen for det aktuelle tema.";
$pgv_lang["FAVICON"]			= "favoritmenu ikon";
$pgv_lang["FAVICON_help"]		= "~#pgv_lang[FAVICON]#~<br /><br />Skift dette for at pege på det ikon, du vil have vist i folks favoritmenu, når de bogmærker dit websted.";
$pgv_lang["THEME_DIR"]			= "Tema mappe";
$pgv_lang["THEME_DIR_help"]		= "~#pgv_lang[THEME_DIR]#~<br /><br />Mappen, hvor dine PhpGedView-temafiler opbevares.<br /><br />Du kan tilpasse ethvert af de standardtemaer, der følger med PhpGedView for at give dit websted et unikt udseende. Se afsnittet Tematilpasning i <a href=\"readme.txt\">readme.txt</a> filen for at få flere oplysninger.";
$pgv_lang["TIME_LIMIT"]			= "PHP-tidsbegrænsning";
$pgv_lang["TIME_LIMIT_help"]		= "~#pgv_lang[TIME_LIMIT]#~<br /><br />Den maksimale tid i sekunder, som PhpGedView skal have lov til at køre.<br /><br />Standard er 1 minut. Afhængigt af størrelsen på din GEDCOM-fil skal du muligvis øge denne tidsfrist, når du har brug for at oprette indekserne. Indstil denne værdi til 0, så PHP kan køre for evigt.<br /><br />FORSIGTIG: Hvis du indstiller denne til 0 eller indstiller den for højt, kan dit websted hænge på bestemte operativsystemer, indtil scriptet er færdigt. At indstille det til 0 betyder, at det muligvis aldrig bliver færdigt, før en serveradministrator dræber processen eller genstarter serveren. Det kan tage meget lang tid at køre et stort stamtavle; at lade denne værdi være så lav som muligt sikrer, at nogen ikke kan gå ned på din server ved at anmode om et for stort diagram.";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"]	= "~#pgv_lang[PGV_SESSION_SAVE_PATH]#~<br /><br />Stien til lagring af PhpGedView-sessionsfiler.<br /><br />Nogle værter har ikke PHP konfigureret korrekt, og sessioner opretholdes ikke mellem sideanmodninger. Dette valg lader webstedsadministratorer overvinde dette problem ved at gemme filer i et af deres lokale kataloger. ./index/ mappen er et godt valg, hvis du har brug for at ændre dette. Standard er at lade feltet være tomt, som bruger stien Gem som konfigureret i <i>php.ini</i>.";
$pgv_lang["SERVER_URL_help"]		= "~#pgv_lang[SERVER_URL]#~<br /><br />Hvis du bruger https eller en anden port end standard, skal du indtaste URL'en for at få adgang til din server her.";
$pgv_lang["LOGIN_URL"]			= "Login-URL";
$pgv_lang["LOGIN_URL_help"]		= "~#pgv_lang[LOGIN_URL]#~<br /><br />Du skal kun indtaste en login-URL, hvis du vil omdirigere til et andet sted eller sted, når dine brugere logger ind. Dette er meget nyttigt, hvis du har brug for at skifte fra http til https, når dine brugere logger ind. Inkluder den fulde URL til <i>login.php</i>. For eksempel, https://www.dinserver.com/phpgedview/login.php .";
$pgv_lang["PGV_SESSION_TIME_help"]	= "~#pgv_lang[PGV_SESSION_TIME]#~<br /><br />Tiden i sekunder, hvor en PhpGedView-session forbliver aktiv, før der kræves et login. Standard er 7200, hvilket er 2 timer.";
$pgv_lang["SHOW_STATS"]			= "Vis udførelsesstatistikker";
$pgv_lang["SHOW_STATS_help"]		= "~#pgv_lang[SHOW_STATS]#~<br /><br />Vis runtime-statistik og antal databaseforespørgsler nederst på hver side.";
$pgv_lang["SHOW_COUNTER"]		= "Vis hit tællere";
$pgv_lang["SHOW_COUNTER_help"]		= "~#pgv_lang[SHOW_COUNTER]#~<br /><br />Vis hit-tællere på siderne MyGedView og <i>#pgv_lang[personal_details]#</i>.";
$pgv_lang["USE_REGISTRATION_MODULE_help"]	= "~#pgv_lang[USE_REGISTRATION_MODULE]#~<br /><br />Giver besøgende valget om at registrere sig selv til en konto på webstedet.<br /><br />Den besøgende modtager en e-mail med en kode for at bekræfte sin ansøgning om en konto. Efter verifikation skal administratoren godkende registreringen, før den bliver aktiv.";
$pgv_lang["ALLOW_USER_THEMES_help"]	= "~#pgv_lang[ALLOW_USER_THEMES]#~<br /><br />Giver brugerne valget mellem at vælge deres eget tema.";
$pgv_lang["PGV_SIMPLE_MAIL_help"] = "~#pgv_lang[PGV_SIMPLE_MAIL]#~<br /><br />I normale mailoverskrifter til eksterne mails bruges både e-mail-adressen og navnet. Nogle mailsystemer accepterer ikke dette. Når den er indstillet til <b>#pgv_lang[yes]#</b>, bruges kun e-mail-adressen.";
$pgv_lang["PGV_SMTP_ACTIVE_help"] = "~#pgv_lang[PGV_SMTP_ACTIVE]#~<br /><br />Brug SMTP til at sende e-mails fra PhpGedView.<br /><br />Dette valg kræver adgang til en SMTP-mailserver. Når den er indstillet til <b>#pgv_lang[no]#</b>, bruger PhpGedView det e-mail-system, der er indbygget i PHP på denne server.";
$pgv_lang["PGV_SMTP_DEBUG_help"] = "~#pgv_lang[PGV_SMTP_DEBUG]#~<br /><br />Når indstillingen <b>#pgv_lang[PGV_SMTP_ACTIVE]#</b> er indstillet til <b>#pgv_lang[yes]#</b>, bruger PhpGedView PHPMailer-programmet til at sende e-mails. Dette program producerer fejlmeddelelser, når det støder på problemer, mens du prøver at sende e-mails.<br /><br />Denne indstilling, som er nyttig, når du prøver at løse e-mail-afsendelsesproblemer, bestemmer de typer fejl, som PHPMailer vil rapportere. Fejltyperne du kan vælge er:<ul><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION0]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION1]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION2]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION3]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION4]#</li></ul>";
$pgv_lang["PGV_SMTP_HOST_help"] = "~#pgv_lang[PGV_SMTP_HOST]#~<br /><br />Dette er navnet på SMTP-mailserveren. Eksempel: <b>smtp.foo.bar.com</b>.<br /><br />Konfigurationsværdier for nogle e-mail-udbydere:<br /><br /><b>Gmail</b><br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_HOST]#:&nbsp;&nbsp;smtp.gmail.com<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_PORT]#:&nbsp;&nbsp;465 eller 587<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_SSL]#:&nbsp;&nbsp;SSL<br /><br /><b>Hotmail</b><br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_HOST]#:&nbsp;&nbsp;smtp.live.com<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_PORT]#:&nbsp;&nbsp;25 eller 587<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_SSL]#:&nbsp;&nbsp;TLS<br /><br /><b>Yahoo Mail Plus</b> (i øjeblikket en betalt tjeneste)<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_HOST]#:&nbsp;&nbsp;smtp.mail.yahoo.com<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_PORT]#:&nbsp;&nbsp;25";
$pgv_lang["PGV_SMTP_HELO_help"] = "~#pgv_lang[PGV_SMTP_HELO]#~<br /><br />Dette er domænedelen af en gyldig e-mail-adresse på SMTP-serveren.<br /><br />For eksempel, hvis du har en e-mail-konto som f.eks. <b>ditnavn@abc.xyz.com</b>, skal du indtaste <b>abc.xyz.com</b> her.";
$pgv_lang["PGV_SMTP_PORT_help"] = "~#pgv_lang[PGV_SMTP_PORT]#~<br /><br />Portnummeret, der skal bruges til forbindelser til SMTP-serveren. Generelt er dette port <b>25</b>.";
$pgv_lang["PGV_SMTP_AUTH_help"] = "~#pgv_lang[PGV_SMTP_AUTH]#~<br /><br />Brug godkendelse af navn og adgangskode til at oprette forbindelse til SMTP-serveren.<br /><br />Nogle SMTP-servere kræver, at alle forbindelser godkendes, før de accepterer udgående e-mails.";
$pgv_lang["PGV_SMTP_AUTH_USER_help"] = "~#pgv_lang[PGV_SMTP_AUTH_USER]#~<br /><br />Brugernavnet, der kræves til godkendelse med SMTP-serveren.";
$pgv_lang["PGV_SMTP_AUTH_PASS_help"] = "~#pgv_lang[PGV_SMTP_AUTH_PASS]#~<br /><br />Den adgangskode, der kræves til godkendelse med SMTP-serveren.";
$pgv_lang["PGV_SMTP_SSL_help"]		 = "~#pgv_lang[PGV_SMTP_SSL]#~<br /><br />Transport Layer Security (TLS) og Secure Sockets Layer (SSL) er internetdatakrypteringsprotokoller.<br /><br />TLS 1.0, 1.1 og 1.2 er standardiserede udviklinger af SSL 3.0. TLS 1.0 og SSL 3.1 er ækvivalente. Yderligere arbejde med SSL udføres nu under det nye navn, TLS.<br /><br />Hvis din SMTP-server kræver SSL-protokollen under login, skal du vælge <b>SSL</b>. Hvis din SMTP-server kræver TLS-protokollen under login, skal du vælge <b>TLS</b>.";
$pgv_lang["PGV_SMTP_FROM_NAME_help"] = "~#pgv_lang[PGV_SMTP_FROM_NAME]#~<br /><br />Indtast navnet, der skal bruges i «Fra:» felt med e-mails, der stammer fra dette websted.<br /><br />For eksempel, hvis dit navn er <b>John Smith</b> og du er webstedsadministrator for et websted, der er kendt som <b>Jones Genealogy</b>, du kan indtaste noget som <b>John&nbsp;Smith</b> eller <b>Jones&nbsp;Genealogy</b> eller endda <b>John&nbsp;Smith,&nbsp;administrator:&nbsp;Jones&nbsp;Genealogy</b>. Du kan indtaste hvad du vil, men HTML er ikke tilladt.";
$pgv_lang["gedcom_title"]			= "#pgv_lang[ged_title]#";
$pgv_lang["gedcom_title_help"]		= "~#pgv_lang[gedcom_title]#~<br /><br />Indtast en beskrivende titel, der skal vises, når brugerne vælger blandt GEDCOM datasæt på dit websted.";
$pgv_lang["LOGFILE_CREATE"]		= "Arkiver logfiler";
$pgv_lang["LOGFILE_CREATE_help"]	= "~#pgv_lang[LOGFILE_CREATE]#~<br /><br />Hvor ofte skal programmet arkivere logfiler.";
$pgv_lang["REMINDER_FREQ"] 			= "Hyppighed af påmindelses-e-mails «Gennemgå ændringer»";
$pgv_lang["REMINDER_FREQ_help"]		= "~#pgv_lang[REMINDER_FREQ]#~<br /><br />Denne indstilling styrer, hvor ofte påmindelses-e-mails «Gennemgå ændringer» sendes. <b>nul</b>: aldrig;&nbsp;&nbsp;<b>1</b>: dagligt;&nbsp;&nbsp;<b>2</b>: hver 2. dag; osv.";
$pgv_lang["PGV_MEMORY_LIMIT_help"]	= "~#pgv_lang[PGV_MEMORY_LIMIT]#~<br /><br />Den maksimale mængde hukommelse, der kan forbruges af PhpGedView-scripts. Standard er 64 Mb. Mange værter deaktiverer dette valg i deres PHP-konfiguration; ændring af denne værdi påvirker muligvis ikke den aktuelle maksimale hukommelsesindstilling.";
$pgv_lang["PGV_STORE_MESSAGES_help"]	= "~#pgv_lang[PGV_STORE_MESSAGES]#~<br /><br />Angiver, om meddelelser sendt via PhpGedView kan gemmes i databasen. Hvis indstillet til <b>#pgv_lang[yes]#</b> vil brugere være i stand til at hente deres beskeder, når de logger ind på PhpGedView. Hvis indstillet til <b>#pgv_lang[no]#</b>, sendes kun beskeder.";
$pgv_lang["ALLOW_THEME_DROPDOWN"]		= "Vis tememenu til temaændringer";
$pgv_lang["ALLOW_THEME_DROPDOWN_help"]	= "~#pgv_lang[ALLOW_THEME_DROPDOWN]#~<br /><br />Giver brugerne valget mellem at vælge deres eget tema fra en menu.<br /><br />Selv med dette valgsæt indeholder det aktuelle tema muligvis ikke en sådan menu. For at være effektiv kræver dette valg også valget <b>#pgv_lang[ALLOW_USER_THEMES]#</b>.";
$pgv_lang["MAX_VIEW_RATE"]		= "Maksimal sidevisningshastighed";
$pgv_lang["MAX_VIEW_RATE_help"]	= "~#pgv_lang[MAX_VIEW_RATE]#~<br /><br />Dette valg begrænser den hastighed, hvormed en bruger kan se sider.<br /><br />Hvis denne hastighed overskrides, behandler PhpGedView sessionen som et hackingsforsøg; sessionen afsluttes med en passende besked. Disse to værdier skal lægge en rimelig grænse for mængden af båndbredde og downloadede bytes fra serveren. Denne funktion kan slås fra ved at indstille tidsintervallet til 0.";
$pgv_lang["META_AUTHOR"]		= "METAtag: Forfatter";
$pgv_lang["META_AUTHOR_help"]	= "~#pgv_lang[META_AUTHOR]#~<br /><br />Den værdi, der skal placeres i metatagget Author i HTML-sideoverskriften. #pgv_lang[META_AUTHOR_descr]#";
$pgv_lang["META_AUTHOR_descr"]	= "Lad dette felt være tomt for at bruge det fulde navn på #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_PUBLISHER"]		= "META tag: Forlægger";
$pgv_lang["META_PUBLISHER_help"]	= "~#pgv_lang[META_PUBLISHER]#~<br /><br />Den værdi, der skal placeres i metatagget Publisher i HTML-sideoverskriften. #pgv_lang[META_PUBLISHER_descr]#";
$pgv_lang["META_PUBLISHER_descr"]	= "Lad dette felt være tomt for at bruge det fulde navn på #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_COPYRIGHT"]		= "META tag: ophavsret";
$pgv_lang["META_COPYRIGHT_help"]	= "~#pgv_lang[META_COPYRIGHT]#~<br /><br />Den værdi, der skal placeres i metatagget Copyright i HTML-sideoverskriften. #pgv_lang[META_COPYRIGHT_descr]#";
$pgv_lang["META_COPYRIGHT_descr"]	= "Lad dette felt være tomt for at bruge det fulde navn på #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_DESCRIPTION"]		= "META tag: Beskrivelse";
$pgv_lang["META_DESCRIPTION_help"]	= "~#pgv_lang[META_DESCRIPTION]#~<br /><br />Den værdi, der skal placeres i metatagget Description i HTML-sideoverskriften. #pgv_lang[META_DESCRIPTION_descr]#";
$pgv_lang["META_DESCRIPTION_descr"]	= "Lad dette felt være tomt for at bruge titlen på den aktuelt aktive database.";
$pgv_lang["META_PAGE_TOPIC"]		= "META tag: Sideemne";
$pgv_lang["META_PAGE_TOPIC_help"]	= "~#pgv_lang[META_PAGE_TOPIC]#~<br /><br />Værdien, der skal placeres i metatagget Page-topic i HTML-sideoverskriften. #pgv_lang[META_PAGE_TOPIC_descr]#";
$pgv_lang["META_PAGE_TOPIC_descr"]	= "Lad dette felt være tomt for at bruge titlen på den aktuelt aktive database.";
$pgv_lang["META_AUDIENCE"]		= "META tag: Publikum";
$pgv_lang["META_AUDIENCE_help"]	= "~#pgv_lang[META_AUDIENCE]#~<br /><br />Den værdi, der skal placeres i metatagget Audience i HTML-sideoverskriften.";
$pgv_lang["META_PAGE_TYPE"]		= "META tag: Sidetype";
$pgv_lang["META_PAGE_TYPE_help"]	= "~#pgv_lang[META_PAGE_TYPE]#~<br /><br />Den værdi, der skal placeres i metatagget Page-type i HTML-sideoverskriften.";
$pgv_lang["META_ROBOTS"]		= "META tag: Robotter";
$pgv_lang["META_ROBOTS_help"]	= "~#pgv_lang[META_ROBOTS]#~<br /><br />Den værdi, der skal placeres i metatagget Robots i HTML-sideoverskriften. Nogle søgemaskiner ignorerer denne værdi.";
$pgv_lang["META_REVISIT"]		= "META tag: besøg igen";
$pgv_lang["META_REVISIT_help"]	= "~#pgv_lang[META_REVISIT]#~<br /><br />Hvor ofte skal søgemaskiner besøge igen? Den værdi, der skal placeres i metatagget Revisit i HTML-sideoverskriften. Nogle søgemaskiner ignorerer denne værdi.";
$pgv_lang["META_KEYWORDS"]		= "META tag: Nøgleord";
$pgv_lang["META_KEYWORDS_help"]	= "~#pgv_lang[META_KEYWORDS]#~<br /><br />Den værdi, der skal placeres i metatagget Keywords i HTML-sideoverskriften. Nogle søgemaskiner bruger metatagget Keywords til at hjælpe med at indeksere din side.<br /><br />#pgv_lang[common_surnames]# listen, der vises i #pgv_lang[gedcom_stats]# blokken på din velkomstside, kan også tilføjes til alt hvad du indtaster her.";
$pgv_lang["META_TITLE"]		= "Føj til TITLE tag af sideoverskrift";
$pgv_lang["META_TITLE_help"]	=	"~#pgv_lang[META_TITLE]#~<br /><br />Alt på denne linje føjes til tagget TITLE i HTML-sideoverskriften efter den almindelige sidetitel og før PhpGedView-kredit.";

$pgv_lang["ENABLE_RSS"]				= "Aktivér RSS";
$pgv_lang["ENABLE_RSS_help"]		= "~#pgv_lang[ENABLE_RSS]#~<br /><br />Dette valg giver dig mulighed for at deaktivere RSS-funktionen.<br /><br />RSS giver brugerne mulighed for at overvåge dit websted for ændringer i indekssiden uden faktisk at besøge dit websted med jævne mellemrum. Hvis for mange brugere bruger denne funktion, eller hvis opdateringsfrekvensen, der er indstillet af disse brugere, er for høj, kan RSS bruge for meget båndbredde eller serverkapacitet.<br /><br />Denne <a href='https://da.wikipedia.org/wiki/RSS' target='_blank' title='Wikipedia-artikel'><b>Wikipedia-artikel</b></a> indeholder omfattende oplysninger og links om RSS og de forskellige RSS-formater.";
$pgv_lang["RSS_FORMAT"]				= "RSS-format";
$pgv_lang["RSS_FORMAT_help"]		= "~#pgv_lang[RSS_FORMAT]#~<br /><br />Det format, der skal bruges som standard feedformat for webstedet. De numeriske suffikser angiver <u>ikke</u> version: de identificerer formater. For eksempel er RSS 2.0 ikke nyere end RSS 1.0, men et andet format. Feedlæsere skal kunne læse ethvert format.<br /><br />Denne <a href='https://da.wikipedia.org/wiki/RSS' target='_blank' title='Wikipedia-artikel'><b>Wikipedia-artikel</b></a> indeholder omfattende oplysninger og links om RSS og de forskellige RSS-formater.";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE"] = "Kontroller, om GEDCOM-filer kan downloades";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE_help"] = "~#pgv_lang[SECURITY_CHECK_GEDCOM_DOWNLOADABLE]#~<br /><br />Af sikkerhedsmæssige årsager bør GEDCOM-filer ikke være et sted, hvor de kan downloades direkte og dermed omgå fortrolighedskontrol. Ved at klikke på dette link kontrolleres det, om dine GEDCOM-filer kan downloades over netværket.<br /><br />På nogle systemer har denne check været kendt for at tage meget lang tid eller ikke engang fuldført. Hvis det er tilfældet for dig, skal du prøve at pege din browser direkte på din GEDCOM for at se, om den kan downloades.";
$pgv_lang["gedcom_download_secure"]	= "#GEDCOM# kan ikke downloades.";

$pgv_lang["welcome_new_help"]		= "~#pgv_lang[welcome_new]#~<br /><br />Da du ser denne side, har du installeret PhpGedView med succes på din server og er klar til at begynde at konfigurere den til dine behov.br /><br />Denne hjælpeside vil guide dig gennem konfigurationsprocessen. Når du indtaster forskellige felter, giver dette vindue dig hjælpoplysninger om det felt, du befinder dig i. Du kan lukke dette vindue; for at åbne det igen skal du klikke på et af <b>#pgv_lang[qm]#</b> spørgsmålstegnene ved siden af feltetiketten.";
$pgv_lang["return_editconfig"]		= "Du kan når som helst vende tilbage til denne konfiguration ved at pege din browser på <i>editconfig.php</i> eller ved at klikke på linket til <b>Konfiguration</b> på siden <b>PhpGedView Administration</b>.";
$pgv_lang["return_editconfig_gedcom"]	= "Du kan når som helst vende tilbage til denne konfiguration ved at klikke på linket <b>Rediger</b> i tabellen <b>#pgv_lang[current_gedcoms]#</b> i <b>#pgv_lang[gedcom_adm_head]#</b> side eller ved at pege din browser på <i>editconfig_gedcom.php</i>.";
$pgv_lang["save_config"] 		= "Gem konfiguration";
$pgv_lang["download_gedconf"]		= "Download GEDCOM-konfiguration.";
$pgv_lang["not_writable"]		= "Vi har registreret, at din konfigurationsfil ikke kan skrives af PHP. Du kan bruge knappen <b>#pgv_lang[download_file]#</b> til at gemme dine indstillinger i en fil, som du kan uploade manuelt.";
$pgv_lang["upload_to_index"]		= "Upload filen til din index mappe: ";
$pgv_lang["import_sql"]			= "SQL-filer er fundet i din indeksmappe. Da de muligvis stammer fra #pgv_lang[um_header]#, har du valget om at importere oplysningerne til din database. Ønsker du at prøve at importere disse filer til din database nu? Alle eksisterende brugerrelaterede oplysninger (brugere, nyheder, favoritter, bloklayouter og meddelelser) i din database går tabt.<br /><br />Hvis du vælger at fortsætte, forsøger PhpGedView at importere dataene. Hvis dette ikke lykkes, bliver du alligevel bedt om at oprette den første administratorkonto.";

//-- edit privacy messages
$pgv_lang["edit_privacy"]			= "Rediger fortrolighed";
$pgv_lang["edit_privacy_title"]			= "Rediger GEDCOM fortrolighedsindstillinger";
$pgv_lang["save_changed_settings"]		= "Gem ændringer";
$pgv_lang["add_new_pp_setting"]			= "Tilføj ny indstilling af total fortrolighed efter person-id";
$pgv_lang["add_new_up_setting"]			= "Tilføj ny indstilling af fortrolighed for brugernavn";
$pgv_lang["add_new_gf_setting"]			= "Tilføj ny indstilling af globale fortrolighed for fakta";
$pgv_lang["add_new_pf_setting"]			= "Tilføj ny indstilling af fortrolighed af fakta efter person-id";
$pgv_lang["file_read_error"]			= "F E J L !!! Kunne ikke læse privatlivsfilen!";
$pgv_lang["edit_exist_person_privacy_settings"]	= "Rediger eksisterende indstillinger af total fortrolighed efter person-id";
$pgv_lang["edit_exist_user_privacy_settings"]	= "Rediger eksisterende indstillinger af fortrolighed for brugernavn";
$pgv_lang["edit_exist_global_facts_settings"]	= "Rediger eksisterende indstillinger af globale fortrolighed for fakta";
$pgv_lang["edit_exist_person_facts_settings"]	= "Rediger eksisterende indstillinger af fortrolighed af fakta efter person-id";
$pgv_lang["general_privacy"]			= "Generelle fortrolighedsindstillinger";
$pgv_lang["general_privacy_help"]		= "~#pgv_lang[general_privacy]#~<br /><br />Du kan have forskellige fortrolighedsindstillinger for hver GEDCOM på dit PhpGedView-websted. Kontroller under sidetitlen, om du redigerer den korrekte GEDCOM.<br /><br />Du kan tilsidesætte disse generelle indstillinger ved at bruge de andre fortrolighedsformularer på siden #pgv_lang[edit_privacy_title]#.<br /><br />#pgv_lang[more_help_advice]#";
$pgv_lang["person_privacy"]				= "Fortrolighed efter person-id";
$pgv_lang["person_privacy_help"]		= "~#pgv_lang[person_privacy]#~<br /><br />Disse indstillinger giver administratorer mulighed for at tilsidesætte standardindstillingerne for privatlivets fred for en bestemt person, familie, kilde eller medieobjekt.<br /><br />Antag for eksempel, at du har et barn, der døde i barndommen. Normalt fordi barnet er død, vil dets detaljer blive vist for offentlige brugere. Dog er du og alle andre i din familie stadig private. Du ønsker ikke at fjerne dødsoptegnelsen for barnet, men du vil skjule detaljerne og gøre dem private. Hvis dette barn havde id'et I100, skal du indtaste følgende fortrolighedsindstillinger:<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I100<br />&nbsp;&nbsp;&nbsp;#pgv_lang[accessible_by]#:&nbsp;&nbsp;#pgv_lang[PRIV_USER]#<br /><br />Dette fungerer den anden vej også. Hvis du ville offentliggøre detaljerne for en person (ID I101), som du ved er død, men ikke har en dødsdato for, kan du tilføje følgende:<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I101<br />&nbsp;&nbsp;&nbsp;#pgv_lang[accessible_by]#:&nbsp;&nbsp;#pgv_lang[PRIV_PUBLIC]#";
$pgv_lang["user_privacy"]				= "Fortrolighed for brugernavn";
$pgv_lang["user_privacy_help"]			= "~#pgv_lang[user_privacy]#~<br /><br />Disse indstillinger giver administratorer mulighed for at tilsidesætte standardindstillingerne for privatlivets fred for enkeltpersoner i GEDCOM baseret på brugernavn. Antag, at du ikke vil have brugernavnet <b>John</b> til at kunne se detaljer om ID I100 i GEDCOM, du kan konfigurere det således:<br />&nbsp;&nbsp;&nbsp;Bruger:&nbsp;&nbsp;John<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I100<br />&nbsp;&nbsp;&nbsp;#pgv_lang[show_question]#:&nbsp;&nbsp;#pgv_lang[hide]#<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;og detaljer for den angivne person vil kun være skjult for brugernavnet \"John\".<br /><br />Til vis detaljerne i I101 (som normalt ville være skjult, fordi I101 stadig er i live) til Brugernavn \"John\" sæt:<br />&nbsp;&nbsp;&nbsp;Bruger:&nbsp;&nbsp;John<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I101<br />&nbsp;&nbsp;&nbsp;#pgv_lang[show_question]#:&nbsp;&nbsp;#pgv_lang[show]#";
$pgv_lang["global_facts"]				= "Globale fortrolighed for fakta";
$pgv_lang["global_facts_help"]			= "~#pgv_lang[global_facts]#~<br /><br />Disse indstillinger definerer fakta på et globalt niveau, der skal skjules for alle personer i GEDCOM. Dette gælder kun niveau 1 faktaposter såsom BIRT eller DEAT, der vises med deres egne overskrifter på fanen #pgv_lang[personal_facts]# på siden <i>#pgv_lang[personal_details]#</i>.<br /><ul><li>Elementet <b>#pgv_lang[name_of_fact]#</b> bestemmer, hvilken kendsgerning der skal skjules.</li><li>Elementet <b>#pgv_lang[choice]#</b> angiver selve fakta eller relaterede detaljer.</li><li>Elementet <b>#pgv_lang[accessible_by]#</b> bestemmer på hvilket adgangsniveau fakta vises.</li></ul><br />Denne funktion er beregnet til at skjule visse fakta, identificeret ved GEDCOM-tags, for alle personer, der er levende eller døde. Som standard er SSN-tagget skjult for offentlige brugere. Dette er for at forhindre folk i at stjæle personnumre og begå identitetstyveri af døde personer. Dette er sandsynligvis mest relevant for USA.<br /><br />Hvis du vil skjule alle ægteskaber fra offentlige brugere i din GEDCOM, kan du indstille:<br />&nbsp;&nbsp;&nbsp;#pgv_lang[name_of_fact]#: (MARR) - Ægteskab<br />&nbsp;&nbsp;&nbsp;#pgv_lang[choice]#: #pgv_lang[fact_show]#<br />&nbsp;&nbsp;&nbsp;#pgv_lang[accessible_by]#: #pgv_lang[PRIV_USER]#<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Disse indstillinger skjuler ægteskaber og relaterede detaljer for besøgende, der ikke er logget ind.<br /><br />I modsætning til alle andre indstillinger kan du i <b>#pgv_lang[edit_exist_global_facts_settings]#</b> skjule fakta selv fra admin brugere. Uønskede fakta undertrykkes fuldstændigt.";
$pgv_lang["person_facts"]				= "Fortrolighed af fakta efter person-id";
$pgv_lang["person_facts_help"]			= "~#pgv_lang[person_facts]#~<br /><br />Disse indstillinger definerer fakta, der er skjult for en bestemt person, familie eller kilde og det niveau, som de skjules på. Dette gælder kun for faktaoptegnelser på niveau 1 såsom BIRT eller DEAT, der vises med deres egne overskrifter på den relevante informationsside for personen, familien eller kilden.<br /><br />Det første element er ID'et for person, familie eller kilde. Det andet element er kendsgerningen. Elementet <b>#pgv_lang[choice]#</b> angiver selve fakta eller relaterede detaljer. Elementet <b>#pgv_lang[accessible_by]#</b> bestemmer på hvilket adgangsniveau fakta vises. Ikke alle fakta, der er vist på listen, gælder for alle typer id'er. Fødsels- og dødsfakta er for eksempel ikke relevante for kildeposter.<br /><br />Denne liste svarer til listen <b>#pgv_lang[global_facts]#</b>, bortset fra at du også angiver GEDCOM ID for den person, du vil skjule fakta for. Du kunne for eksempel skjule ægteskabsoptegnelsen for en bestemt person.";
$pgv_lang["accessible_by"]			= "Vis til?";
$pgv_lang["hide"]				= "Skjule";
$pgv_lang["show_question"]			= "Vise?";
$pgv_lang["user_name"]				= "Brugernavn";
$pgv_lang["name_of_fact"]			= "Fakta navn";
$pgv_lang["choice"]				= "Valg";
$pgv_lang["fact_show"]				= "Vis fakta";
$pgv_lang["fact_details"]			= "Vis faktadetaljer";
$pgv_lang["privacy_header"]			= "Rediger fortrolighedsindstillinger";
$pgv_lang["unable_to_find_privacy_indi"]	= "Kan ikke finde en person med id";
$pgv_lang["save_and_import"]			= "Når du har gemt denne GEDCOM-konfiguration, skal du importere GEDCOM ved at klikke på knappen <b>Importer GEDCOM</b> eller ved at gå til <b>Administration --> Administrer GEDCOM'er --> Importer</b>";
$pgv_lang["help_info"]				= "Du kan få hjælp til hvert emne ved at klikke på det røde <b>#pgv_lang[qm]#</b> ved siden af etiketten for hver celle.";
$pgv_lang["SHOW_LIVING_NAMES"]			= "Vis navne på levende personer";
$pgv_lang["SHOW_LIVING_NAMES_help"]		= "~#pgv_lang[SHOW_LIVING_NAMES]#~<br /><br />Bør navnene på levende personer vises for offentligheden?<br /><br />Normalt vil denne indstilling være «#pgv_lang[PRIV_USER]#». Dette tjener til at beskytte private personers privatliv i din database, fordi du kan bestemme, hvem du giver generel adgang til dine slægtsforskningsdata.<br /><br />Indstillingen «#pgv_lang[PRIV_NONE]#» forhindrer visning af navnene af levende mennesker til brugere, der ikke har administratorrettigheder.";
$pgv_lang["SHOW_RESEARCH_ASSISTANT"]			= "Vis forskningsassistent";
$pgv_lang["SHOW_RESEARCH_ASSISTANT_help"]		= "~#pgv_lang[SHOW_RESEARCH_ASSISTANT]#~<br /><br />Hvilken type bruger kan se forskningsassistentmodulet, hvis det er installeret?";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]		= "Brug forholdet fortrolighed";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]	= "~#pgv_lang[USE_RELATIONSHIP_PRIVACY]#~<br /><br /><b>#pgv_lang[no]#</b> betyder, at godkendte brugere kan se detaljerne for alle levende personer. <b>#pgv_lang[yes]#</b> betyder, at brugerne kun kan se de private oplysninger om levende personer, de er relateret til.<br /><br />Dette valg indstiller standard for alle brugere, der har adgang til denne slægtsdatabase. Administratoren kan tilsidesætte dette valg for individuelle brugere ved at redigere brugerens kontooplysninger.";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]		= "Maksimal længde på forholdsstien";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]	= "~#pgv_lang[MAX_RELATION_PATH_LENGTH]#~<br /><br />Hvis valget <i>#pgv_lang[USE_RELATIONSHIP_PRIVACY]#</i> er aktiveret, kan indloggede brugere kun se eller redigere personer inden for dette antal forholdstrin.<br /><br />Dette valg indstiller standard for alle brugere, der har adgang til denne slægtsdatabase. Administratoren kan tilsidesætte dette valg for individuelle brugere ved at redigere brugerens kontooplysninger.";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]		= "Kontroller ægteskabsforhold";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]	= "~#pgv_lang[CHECK_MARRIAGE_RELATIONS]#~<br /><br />Kontroller forhold, der er forbundet med ægteskab.";
$pgv_lang["SHOW_DEAD_PEOPLE"]			= "Vis døde personer";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]		= "~#pgv_lang[SHOW_DEAD_PEOPLE]#~<br /><br />Indstil niveauet for adgang til privatliv for alle døde personer.";
$pgv_lang["select_privacyfile_button"]		= "Vælg privatlivsfil";
$pgv_lang["PRIVACY_BY_YEAR"]		= "Begræns fortrolighed fred efter begivenhedsalder";
$pgv_lang["PRIVACY_BY_YEAR_help"]	= "~#pgv_lang[PRIVACY_BY_YEAR]#~<br /><br />Indstillingen <b>#pgv_lang[PRIVACY_BY_YEAR]#</b> skjuler detaljerne for personer baseret på hvor gamle de var ved bestemte begivenheder, uanset om de er døde eller i live.<br /><br />Brug denne indstilling sammen med indstillingen <b>#pgv_lang[MAX_ALIVE_AGE]#</b>. For eksempel, hvis du foretog aldersindstillingen 100 og indstillede dette valg til <b>#pgv_lang[yes]#</b>, ville alle personer, levende eller døde, født for mindre end 100 år siden, blive indstillet til private. Personer, der blev gift for mindre end 85 år siden, og mennesker, der døde for mindre end 75 år siden, ville også blive markeret som private. Bemærk, at brugen af dette valg vil sænke din præstation noget.";

//-- language edit utility
$pgv_lang["lang_edit_help"]			= "~#pgv_lang[translator_tools]#~<br /><br />Denne side er beregnet til at blive brugt af oversættere. Du kan oversætte, sammenligne og eksportere sprogfiler. Der er også et valg at hjælpe oversættere med at bestemme oprindelsen af tekst, der sendes ud af PhpGedView.<br /><br />Du kan bruge følgende valg og hjælpeprogrammer:";
$pgv_lang["edit_langdiff"]		= "Rediger og konfigurer sprogfiler";
$pgv_lang["bom_check"]		= "Kontrol af byteordermærke (BOM)";
$pgv_lang["bom_check_help"]		= "~#pgv_lang[bom_check]#~<br /><br />#pgv_lang[bom_check_desc]#";
$pgv_lang["bom_check_desc"]		= "Denne check analyserer alle sprogfilerne til BOM (Byte Order Mark). Hvis den findes, fjerner den styklisten fra den berørte fil. Disse specielle koder kan forårsage funktionsfejl i nogle dele af PhpGedView.";
$pgv_lang["lang_debug"]			= "hjælp fejlretning af tekst";
$pgv_lang["lang_debug_help"]	= "~#pgv_lang[lang_debug]#~<br /><br />#pgv_lang[lang_debug_desc]#";
$pgv_lang["lang_debug_desc"]	= "Når du aktiverer dette valg, udskrives navnene på de sprogvariabler, der bruges i hjælpeteksten, i popup-vinduet i hjælpeteksten. Dette hjælper oversættere med at bestemme variabelnavnet, når teksten skal justeres.<br /><br />Denne indstilling er kun gyldig under din nuværende PhpGedView-session.";
$pgv_lang["lang_debug_use"]		= "Brug fejlretning af hjælpetekster";
$pgv_lang["bom_not_found"]		= "Ingen byteordermærke (BOM) er fundet.";
$pgv_lang["bom_found"]			= "Byteordermærke (BOM) er fundet i ";
$pgv_lang["edit_lang_utility"]		= "Sprogfil redigeringsværktøj";
$pgv_lang["edit_lang_utility_help"]	= "~#pgv_lang[edit_lang_utility]#~<br /><br />#pgv_lang[edit_lang_utility_desc]#";
$pgv_lang["edit_lang_utility_desc"]	= "Du kan bruge dette værktøj til at redigere indholdet af en sprogfil ved hjælp af indholdet af den engelske.<br /><br />Du vil se indholdet af den originale engelsksprogede fil og indholdet af den samme filtype (der er ni af disse) på dit valgte sprog. Du klikker på beskedteksten vist under den engelske version. Dette åbner et nyt vindue, hvor du kan ændre teksten. Du kan gemme ændringerne eller opgive dem.";
$pgv_lang["edit_lang_utility_warning"]	= "FORSIGTIG!<br /><br />Hvis du bruger knappen <b>#pgv_lang[close_window_without_refresh]#</b>, kan du muligvis ikke se dine ændringer på skærmen, før du laver en manuel sideindlæsning. Det er muligt, at din sprogfil kan blive ødelagt, hvis du tilføjer en besked, der endnu ikke er vist inde i sprogfilen, eller hvis du bare redigerer en besked, du har redigeret direkte før.<br /><br />Hvis du ikke rigtig gør det ved hvad du laver. Brug ikke knappen <b>#pgv_lang[close_window_without_refresh]#</b>.";
$pgv_lang["language_to_edit"]		= "Sprog, der skal redigeres";
$pgv_lang["language_to_edit_help"]		= "~#pgv_lang[language_to_edit]#~<br /><br />I denne listeboks vælger du det sprog, hvis meddelelser du vil redigere.";
$pgv_lang["file_to_edit"]		= "Sprog filtype, der skal redigeres";
$pgv_lang["file_to_edit_help"]			= "~#pgv_lang[file_to_edit]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["lang_file_descriptions"]		= "PhpGedView har implementeret support til mange forskellige sprog. Dette er opnået ved at holde al tekst, der er synlig for brugere i filer, helt adskilt fra hovedprogrammet. Der er et sæt på otte filer for hvert understøttede sprog, og de forskellige tekster er blevet adskilt i en af disse filer alt efter funktion. <b>Ikke alle sprogfiler skal være til stede.</b> Når en given tekst endnu ikke er tilgængelig i oversat form, bruger PhpGedView altid den engelske version.<br /><br />Filerne i hvert sprog er:<br /><ul><li><b><i>admin.xx.php</i></b>&nbsp;&nbsp;Denne fil indeholder udtryk og almindelige udtryk til brug under administrationen af PhpGedView og de genealogiske databaser.</li><br /><li><b><i>configure_help.xx.php</i></b>&nbsp;&nbsp;Denne fil indeholder hjælpetekst til brug under konfiguration af PhpGedView. Hjælpsteksten er ikke beregnet til at blive set af almindelige brugere.</li><br /><li><b><i>countries.xx.php</i></b>&nbsp;&nbsp;Dette er en liste over landsnavne, hentet fra webstedet for Statistikafdelingen, De Forenede Nationers Afdeling for Økonomiske og Sociale Anliggender. Dette er det relevante <a href=\"http://unstats.un.org/unsd/methods/m49/m49alpha.htm\" target=\"_blank\"><b>link</b></a> til den engelske liste. Listen er tilgængelig på enten engelsk eller fransk.</li><br /><li><b><i>editor.xx.php</i></b>&nbsp;&nbsp;Denne fil indeholder udtryk og almindelige udtryk til brug under redigering af poster i genealogiske databaser.</li><br /><li><b><i>facts.xx.php</i></b>&nbsp;&nbsp;Denne fil indeholder tekstækvivalenterne af GEDCOM-faktakoder, der findes i GEDCOM 5.5.1-standarden. Den indeholder også yderligere faktakoder, der ikke findes i standarden, men bruges af forskellige slægtsforskningsprogrammer.<br /><br />En engelsk kopi af <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\"><b>GEDCOM 5.5.1 Standard</b></a> kan downloades i PDF (Portable Document Format = Bærbart dokumentformat).</li><br /><li><b><i>faqlist.xx.php</i></b>&nbsp;&nbsp;Denne fil er et sæt af <b>f</b>requently <b>a</b>sked <b>q</b>uestions (ofte stillede spørgsmål), der er blevet samlet af PhpGedView-udviklingsteamet. Hver FAQ har to poster i denne fil. Den ene post er FAQ-overskriften (normalt spørgsmålet), og den anden er FAQ-organet (normalt svaret). Udskiftninger af filerne <b><i>faqlist.xx.php</i></b>, der opdateres ofte, kan downloades fra PhpGedView-hjemmesiden.<br /><br />Administratoren kan bruge ofte stillede spørgsmål i denne fil for at oprette en FAQ-liste, der er specifik for hans websted.</li><br /><li><b><i>help_text.xx.php</i></b>&nbsp;&nbsp;Denne fil indeholder hjælpetekst til almindelige brugere. Nogle hjælpeemner i denne fil imødekommer administratørernes behov og er skjult for brugere, der ikke har administratorrettigheder.</li><br /><li><b><i>lang.xx.php</i></b>&nbsp;&nbsp;Mange udtryk og almindelige udtryk findes i denne fil.</li></ul><br />PhpGedView understøtter også en valgfri niende sprogfil, <b><i>extra.xx.php</i></b>. Denne fil indlæses altid efter alle de andre og giver et middel, hvorved en webstedsadministrator kan tilsidesætte eller ændre enhver standardtekst på det valgte sprog. Det kan også bruges til at give en titel til de slægtsforskningsdatabaser, der varierer alt efter det aktuelt aktive sprog.<br /><br />Indholdet af denne ekstra fil er helt op til webstedsadministratoren; denne fil vil <b>aldrig</b> distribueres med nogen version af PhpGedView. Administratoren bør aldrig foretage ændringer i standardsprogfiler; alle lokale ændringer skal koncentreres i denne valgfri fil.";
$pgv_lang["check"]			= "Kontrollere";
$pgv_lang["lang_save"]			= "Gemme";
$pgv_lang["contents"]			= "Indhold";
$pgv_lang["listing"]			= "Notering";
$pgv_lang["no_content"]			= "Intet indhold";
$pgv_lang["editlang"]			= "Redigere";
$pgv_lang["editlang_help"]		= "~#pgv_lang[editlang]#~<br /><br />Rediger besked fra sprogfil.";
$pgv_lang["savelang"]			= "Gemme";
$pgv_lang["savelang_help"]		= "~#pgv_lang[savelang]#~<br /><br />Gem redigeret besked i sprogfilen.";
$pgv_lang["original_message"]		= "Original besked";
$pgv_lang["message_to_edit"]		= "Besked til redigering";
$pgv_lang["changed_message"]		= "Ændret indhold";
$pgv_lang["message_empty_warning"]	= "-> Advarsel!!! Denne meddelelse er tom i #LANGUAGE_FILE# &lt;-";
$pgv_lang["language_to_export"]		= "Sprog, der skal eksporteres";
$pgv_lang["language_to_export_help"]		= "~#pgv_lang[language_to_export]#~<br /><br />Fra denne liste kan du vælge sproget og de sprogfiler, hvis tekst du vil eksportere.<br /><br />Outputtet er en HTML-fil, som du kan udskrive fra din browser.";
$pgv_lang["export_lang_utility"]	= "Sprogfileksportværktøj";
$pgv_lang["export"]			= "Eksport";
$pgv_lang["export_lang_utility_help"]	= "~#pgv_lang[export_lang_utility]#~<br /><br />#pgv_lang[export_lang_utility_desc]#";
$pgv_lang["export_lang_utility_desc"]	= "Du kan oprette dokumentation til administratorer.<br /><br />Dette værktøj producerer en HTML-version af den valgte sprogfil. Du kan bruge din browser til at se på denne fil, der er formateret til udskrivning.";
$pgv_lang["export_ok"]			= "Sprogtekst blev eksporteret";
$pgv_lang["compare_lang_utility"]	= "Sprogfil sammenligning nytte";
$pgv_lang["compare_lang_utility_help"]	= "~#pgv_lang[compare_lang_utility]#~<br /><br />#pgv_lang[compare_lang_utility_desc]#";
$pgv_lang["compare_lang_utility_desc"]	= "Dette værktøj sammenligner to sæt sprogfiler for at producere en liste over tilføjelser og subtraktioner mellem dem.<br /><br />De engelske filer skal bruges som reference, hvorfra alle andre er produceret.";
$pgv_lang["new_language"]		= "Kildesprog";
$pgv_lang["new_language_help"]			= "~#pgv_lang[new_language]#~<br /><br />Fra denne listeboks kan du vælge det sprog, hvis meddelelser du vil sammenligne med et andet sprog.<br /><br />Alle ændringer og tilføjelser til sprogfiler foretages først på <b>engelsk</b> sprog filer, så du vælger normalt engelsk som et af de sprog, du skal sammenligne.";
$pgv_lang["old_language"]		= "Sekundært sprog";
$pgv_lang["old_language_help"]			= "~#pgv_lang[old_language]#~<br /><br />Fra denne listeboks kan du vælge det sprog, du vil sammenligne med det valgte sprog i <b>#pgv_lang[new_language]#</b> liste.<br /><br />Når du har foretaget dit valg, skal du klikke på <b>Sammenlign</b> knap for at få en liste over alle tilføjelser og subtraktioner i alle filer på begge sprog.<br /><br />Sådan opdateres din hukommelse:<br /><b>Tilføjelse</b> betyder: Det er <u>i</u> kildefilen, men <u>ikke</u> i den sekundære fil.<br /><br /><b> Subtraktion</b>betyder: Det er <u>ikke</u> i kildefilen, men det <u>er</u> i den sekundære fil. Dette kan ske, når en given meddelelse ikke længere bruges og derfor blev fjernet fra de engelske filer. Du kan sikkert fjerne den tilsvarende besked fra sekundære sprogfiler.";
$pgv_lang["compare"]			= "Sammenligne";
$pgv_lang["comparing"]			= "Sprogfiler, der sammenlignes";
$pgv_lang["additions"]			= "Tilføjelser";
$pgv_lang["no_additions"]		= "Ingen tilføjelser";
$pgv_lang["subtractions"]		= "Subtraktioner";
$pgv_lang["no_subtractions"]		= "Ingen subtraktioner";
$pgv_lang["config_lang_utility"]	= "Konfiguration af understøttede sprog";
$pgv_lang["config_lang_utility_help"]	= "~#pgv_lang[config_lang_utility]#~<br /><br />Denne side bruges til at kontrollere, hvilke sprogvalg der er tilgængelige for dine brugere. For eksempel kan du indstille tingene, så kun tysk og fransk er tilgængelige. Dette kan være nyttigt, hvis du for eksempel ikke er i stand til at kommunikere med dine brugere på ungarsk.<br /><br />Du bruger også denne side til at ændre visse aspekter af PhpGedView, der afhænger af det valgte sprog. For eksempel er det her, hvor du fortæller PhpGedView, hvordan du formaterer dato- og tidsfelter.<br /><br />De sprog, der er aktive og nedtonede, kan ikke deaktiveres, fordi de er i brug. Se i nederste tabel for at se, hvor sproget bruges. Når et sprog ikke længere bruges af GEDCOM eller brugeren, kan du deaktivere det.<br /><br />Alle dine ændringer registreres i en ny fil kaldet <i>language_settings.php</i> oprettet i mappen <b>#INDEX_DIRECTORY#</b>. Alle dine yderligere ændringer foretages i denne nye fil, og PhpGedView bruger kun <u>denne</u> fil. Du kan vende tilbage til de originale standardsprogindstillinger ved at slette denne fil.<br /><br />Hvis du skal rapportere problemer med dine sprogindstillinger, bedes du fortælle PhpGedView supportteamet, om denne nye fil er til stede eller ej.";
$pgv_lang["active"]			= "Aktiv";
$pgv_lang["active_help"]		= "~#pgv_lang[active]#~<br /><br />Tillad brugere at vælge dette sprog, hvis valget <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b> er aktiveret.";
$pgv_lang["edit_settings"]		= "Rediger indstillinger";
$pgv_lang["lang_edit"]			= "Redigere";
$pgv_lang["lang_language"]		= "Sprog";
$pgv_lang["export_filename"]		= "Output filnavn:";
$pgv_lang["lang_back"]			= "Gå tilbage til hovedmenuen for at redigere og konfigurere sprogfiler";
$pgv_lang["lang_back_admin"]		= "Gå tilbage til Admin-menuen";
$pgv_lang["lang_back_manage_gedcoms"]	= "Gå tilbage til GEDCOM-styringsmenuen";
$pgv_lang["lang_name_arabic"]			= "Arabisk";
$pgv_lang["lang_name_catalan"]			= "Catalansk (Valenciansk)";
$pgv_lang["lang_name_chinese"]			= "Kinesisk (Traditionel)";
$pgv_lang["lang_name_chinese-cn"]		= "Kinesisk (Forenklet)";
$pgv_lang["lang_name_croatian"]			= "Kroatisk";
$pgv_lang["lang_name_czech"]			= "Tjekkisk";
$pgv_lang["lang_name_danish"]			= "Dansk";
$pgv_lang["lang_name_dutch"]			= "Hollandsk";
$pgv_lang["lang_name_english"]			= "Engelsk";
$pgv_lang["lang_name_estonian"]			= "Estonisk";
$pgv_lang["lang_name_finnish"]			= "Finsk";
$pgv_lang["lang_name_french"]			= "Fransk";
$pgv_lang["lang_name_german"]			= "Tysk";
$pgv_lang["lang_name_greek"]			= "Græsk";
$pgv_lang["lang_name_hebrew"]			= "Hebræisk";
$pgv_lang["lang_name_hungarian"]		= "Ungarsk";
$pgv_lang["lang_name_indonesian"]		= "Indonesisk";
$pgv_lang["lang_name_italian"]			= "Italiensk";
$pgv_lang["lang_name_lithuanian"]		= "Litauisk";
$pgv_lang["lang_name_norwegian"]		= "Norsk";
$pgv_lang["lang_name_polish"]			= "Polsk";
$pgv_lang["lang_name_portuguese"]		= "Portugisisk";
$pgv_lang["lang_name_romanian"]			= "Rumænsk";
$pgv_lang["lang_name_russian"]			= "Russisk";
$pgv_lang["lang_name_serbian-la"]		= "Serbisk (Latinsk alfabet)";
$pgv_lang["lang_name_slovak"]			= "Slovakisk";
$pgv_lang["lang_name_slovenian"]		= "Slovensk";
$pgv_lang["lang_name_spanish"]			= "Spansk";
$pgv_lang["lang_name_spanish-ar"]		= "Latin-amerikansk spansk";
$pgv_lang["lang_name_swedish"]			= "Svensk";
$pgv_lang["lang_name_turkish"]			= "Tyrkisk";
$pgv_lang["lang_name_vietnamese"]		= "Vietnamesisk";
$pgv_lang["lang_name_unknown"]			= "Ingen af disse sprog";		// used ONLY in "Find Special Characters"
$pgv_lang["lang_new_language"]		= "Nyt sprog";
$pgv_lang["original_lang_name"]		= "Oprindeligt navn på sprog i #D_LANGNAME#";
$pgv_lang["original_lang_name_help"]	= "~Oprindeligt navn på sprog~<br /><br />Hvordan navngives dette sprog på dette sprog?<br /><br />Engelsk kalder sig <b>English</b>; Tysk kalder sig <b>Deutsch</b>; Hollandsk kalder sig <b>Nederlands</b>; Tjekkisk kalder sig <b>Ceština</b> osv.";
$pgv_lang["lang_shortcut"]		= "Forkortelse for sprogfiler";
$pgv_lang["lang_shortcut_help"]		= "~#pgv_lang[lang_shortcut]#~<br /><br />Denne kode definerer en forkortelse for sprognavnet. Denne forkortelse er en del af navnet på hver af de sprogfiler, der bruges af PhpGedView. F.eks., forkortelsen der bruges til fransk er <b>fr</b>, og følgelig er filnavne til fransk er <i>admin.<b>fr</b>.php</i>, <i>configure_help.<b>fr</b>.php</i>, <i>countries.<b>fr</b>.php</i>, <i>editor.<b>fr</b>.php</i>, <i>facts.<b>fr</b>.php</i>, <i>help_text.<b>fr</b>.php</i>, og <i>lang.<b>fr</b>.php</i>";
$pgv_lang["lang_langcode"]		= "Sprogdetektionskoder";
$pgv_lang["lang_langcode_help"]		= "~#pgv_lang[lang_langcode]#~<br /><br />Disse koder gør det muligt for PhpGedView at registrere indstillingen Foretrukket sprog for den browser, der bruges. PhpGedView bestemmer det sprog, som browseren faktisk anmoder om, ved at matche browserens sprogkode med denne liste. Individuelle listeindgange skal adskilles med et semikolon.";
$pgv_lang["lang_filenames"]		= "Sprogfiler";
$pgv_lang["lang_filenames_help"]		= "~#pgv_lang[lang_filenames]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["flagsfile"]			= "Flag fil";
$pgv_lang["flagsfile_help"]		= "~#pgv_lang[flagsfile]#~<br /><br />Navnet på den nationale flagbilledfil for det valgte sprog.<br /><br />Billeder i mange lande er tilgængelige fra <a href=\"http://w3f.com/gifs/index.html\"><b>The WWWeb Factory</b></a>.<br /><br />Når du finder et flagbillede, du kan lide, skal du højreklikke på det og gemme billedet i en midlertidig mappe. Åbn derefter det gemte billede med en passende billededitor (IrfanView anbefales til Windows-systemer), reducer størrelsen 50x32 pixels, hvilket er den normale størrelse, der bruges i PhpGedView, og gem det derefter som en GIF-fil til <i><b>images/flags</b></i> mappe. Du kan bruge ethvert navn, du ønsker.";
$pgv_lang["text_direction"]		= "Tekstretning";
$pgv_lang["text_direction_help"]	= "~#pgv_lang[text_direction]#~<br /><br />Identificerer hvilken retning der bruges til at skrive tekst på det valgte sprog. De fleste sprog er skrevet fra venstre mod højre. Arabisk og hebraisk er eksempler på sprog, der er skrevet i den modsatte retning (højre mod venstre).";
$pgv_lang["date_format"]				= "Datoformat";
$pgv_lang["date_format_help"] 			= "~#pgv_lang[date_format]#~<br /><br />Dette felt definerer det datoformat, der skal bruges af PhpGedView, når der vises datoer fra databasen. Du kan bruge formatet <b>Standard</b> eller <b>Avanceret</b>.<ul><li><b>Standard</b><br />Følgende koder bruges til at repræsentere forskellige elementer i datoen. Bemærk, at <b>D</b> og <b>M</b> har forskellige betydninger i formatet <b>Avanceret</b>.<p style=\"padding-left: 25px\"><b>D</b>&nbsp;&nbsp;dag i måneden uden førende nuller; dvs. 1 til 31<br /><b>M</b>&nbsp;&nbsp;månedens navn dvs. januar, februar osv.<br /><b>Y</b>&nbsp;&nbsp;hele året for eksempel 1999 eller 44f.Kr.<br /><b>R</b>&nbsp;&nbsp;Kalenderkonvertering. Se emnet <b>Kalenderkonvertering</b> nedenfor for en beskrivelse af denne kode.</p>Disse koder kan kombineres i en hvilken som helst rækkefølge sammen med mellemrum og tegnsætning. Antag for eksempel, at din GEDCOM indeholder datoen 20&nbsp;AUG&nbsp;1965.<p style=\"padding-left: 25px\">En <b>engelsk</b> bruger kunne indstille formatet til <b>D&nbsp;M&nbsp;Y</b> for at få <b>20&nbsp;August&nbsp;1965</b>.<br />En <b>amerikansk</b> bruger kunne indstille formatet til <b>M&nbsp;D,&nbsp;Y</b> for at få <b>August&nbsp;20,&nbsp;1965</b><br />En <b>tysk</b> bruger kunne indstille formatet til <b>D.&nbsp;M&nbsp;Y</b> for at få <b>20.&nbsp;August&nbsp;1965</b><br />En <b>ungarsk</b> bruger kunne indstille formatet til <b>Y.&nbsp;M&nbsp;D.</b> for at få <b>1965.&nbsp;augusztus&nbsp;20.</b></p><br /></li><li><b>Avanceret</b><br />Mere komplekse formateringsmuligheder er tilgængelige. Hvis dit datoformat indeholder et andet bogstav end <b>D</b>, <b>M</b>, <b>Y</b> eller <b>R</b>, antages det at bruge formatet <b>Avanceret</b>.<br /><br />Følgende koder bruges til at repræsentere forskellige elementer i datoen. Bemærk, at <b>D</b> og <b>M</b> har forskellige betydninger i formatet <b>Standard</b>.<p style=\"padding-left: 25px\"><b>d</b>&nbsp;&nbsp;dag i måneden med ledende nuller; dvs. 01 til 31<br /><b>j</b>&nbsp;&nbsp;dag i måneden uden ledende nuller; dvs. 1 til 31<br /><b>S</b>&nbsp;&nbsp;ordinært suffiks for dagnummeret; for eksempel på engelsk bogstaverne <b>th</b> in <b>4th&nbsp;July</b>.<br /><b>l</b> (små «L»)&nbsp;&nbsp;dag i ugen; dvs. mandag, tirsdag osv.<br /><b>D</b>&nbsp;&nbsp;forkortet ugedag; dvs. m, ti, o, to, f, l, s<br /><b>N</b>&nbsp;&nbsp;ISO dagnummer dvs. 0 til 6<br /><b>w</b>&nbsp;&nbsp;dag nummer; dvs. 1 til 7<br /><b>z</b>&nbsp;&nbsp;årets dag dvs. 1 til 365 eller 366<br /><b>F</b>&nbsp;&nbsp;månedens navn dvs. januar, februar osv.<br /><b>M</b>&nbsp;&nbsp;forkortet måned, dvs. jan, feb osv.<br /><b>m</b>&nbsp;&nbsp;månedsnummer med ledende nuller; dvs. 01 til 12<br /><b>n</b>&nbsp;&nbsp;månedstal uden ledende nuller; dvs. 1 til 12<br /><b>Y</b>&nbsp;&nbsp;hele året for eksempel 1999 eller 44f.Kr.<br /><b>y</b>&nbsp;&nbsp;forkortet år. Nogle kalendere tillader forkortelse af år. For den jødiske kalender er dette året uden tusinder. For den gregorianske kalender er dette det samme som hele året.<br /><b>R</b>&nbsp;&nbsp;Kalenderkonvertering. Se emnet <b>Kalenderkonvertering</b> nedenfor for en beskrivelse af denne kode.<br /><b>@&nbsp;A&nbsp;O&nbsp;E</b>&nbsp;&nbsp;internt GEDCOM-format</p><p style=\"padding-left: 50px\"><b>@</b>&nbsp;&nbsp;kalenderkode, f.eks. @#DGREGORIAN@, @#DHEBREW@, osv.<br /><b>A</b>&nbsp;&nbsp;dag, dvs. 01 til 31<br /><b>O</b>&nbsp;&nbsp;måned, på engelsk, f.eks. JAN, FEB, MAR, osv.<br /><b>E</b>&nbsp;&nbsp;år, f.eks. 1776, 1867, 2007 osv.<br /><br />Brug for at se de ikke-konverterede datoer <b>A&nbsp;O&nbsp;E</b> eller <b>@&nbsp;A&nbsp;O&nbsp;E</b></p><b>Nogle eksempler</b> ved hjælp af datoen 08&nbsp;SEP&nbsp;1965:<p style=\"padding-left: 25px\"><b>d&nbsp;M&nbsp;Y</b> = 08&nbsp;sep&nbsp;1965<br /><b>D&nbsp;j&nbsp;F&nbsp;Y</b> = o&nbsp;8&nbsp;september&nbsp;1965<br /><b>j&nbsp;M&nbsp;y</b> = 8&nbsp;sep&nbsp;65<br /><b>l&nbsp;-&nbsp;d&nbsp;-&nbsp;F&nbsp;-&nbsp;Y</b> = onsdag&nbsp;-&nbsp;08&nbsp;-&nbsp;september&nbsp;-&nbsp;1965<br /><b>y/m/d</b> = 1965/09/08</p><br /></li></ul>#pgv_lang[date_format_help2]#";
$pgv_lang["date_format_help2"] 			= "<ul><li><b>Kalenderkonvertering</b><br /><b>R</b> koden er noget usædvanlig i sin opførsel. Når denne kode vises i datoformatet, vises den normale dato en anden gang, men i et andet kalendersystem. Elementerne i denne alternative kalenderdato overholder de samme regler som dem, der findes i hoveddelen af formatspecifikationen, bortset fra at output fra <b>R</b> formateringskoden er omgivet af parenteser for at skelne den fra den normale dato. Eksemplerne under <b>Fransk Revolutionerende</b> kalender vil gøre dette lidt klarere.<br /><br />Den alternative kalender, der skal bruges til <b>R</b> koden, bestemmes i henhold til det aktuelle sidesprog. Når sidesproget er hebraisk, bruges <b>jødisk</b> kalenderen. Når sidesproget er arabisk, bruges <b>Hijri</b> kalenderen. For alle andre sidesprog anvendes <b>Fransk Revolutionerende</b> kalenderen.<br /><br />Handlingen med denne kode svarer til det valg af kalenderformat, du kan lave på GEDCOM-konfigurationssiden. Forskellen mellem de to metoder er, at <b>R</b> koden, der defineres på sprogkonfigurationsniveau, kun fungerer på udvalgte sprog, men på tværs af alle GEDCOM'er på webstedet. Kalenderindstillingen, der er indstillet på GEDCOM-konfigurationsniveau, fungerer på alle sprog, men kun på de GEDCOM'er, som denne indstilling er indstillet til.<br /><ul><li><b>Fransk revolutionerende</b> kalender&nbsp;&nbsp;&nbsp;Denne kalender kaldes også <b>Fransk Republikansk</b> kalender.<br /><br />Bortset fra en meget kort periode i maj 1871 var dette kalendersystem kun i brug i Frankrig og kun mellem 22&nbsp;SEP&nbsp;1792 og 31&nbsp;DEC&nbsp;1805.  Følgelig vil det franske revolutionære kalenderformat kun være gældende, når datoen er inden for dette interval.<br /><br />To eksempler på datoformater, forudsat at sidesproget er engelsk, illustrerer handlingen af <b>R</b> kode:<br /><b>Y.m.d&nbsp;R</b> kunne producere <b>1805.04.26&nbsp;(XIII.08.06)</b> eller <b>1806.01.01</b>;&nbsp; <b>j&nbsp;F&nbsp;Y&nbsp;R</b> kunne producere <b>13&nbsp;October&nbsp;1797&nbsp;(22&nbsp;Vendémiaire&nbsp;VI)</b> eller <b>1&nbsp;January&nbsp;1806</b>.</li></ul><br /></li><li><b>Sprogalternativer</b><br />De forkortede tekster til de avancerede koder <b>D</b> og <b>M</b> er angivet i filen <i>languages/lang.xx.php</i>, ved hjælp af kommandoer som<br /><code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"Su\";<br />\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"April\";</code><br /><br />Disse kan ændres ved hjælp af en <i>languages/extra.xx.php</i> fil som beskrevet i Wiki og ReadMe-tekst til sprogjusteringer, for eksempel:<br /><code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"Sun\";<br />\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"Apr\";</code></li><br /><li><b>Lokalisering</b><br />Der findes særlige formateringsregler for et antal sprog, især afbøjning af måneders slutninger alt efter, hvordan datoen er formuleret. Disse særlige regler er implementeret i de forskellige <i>includes/extras/functions.xx.php</i> filer.</li></ul>";
$pgv_lang["time_format"]				= "Tidsformat";
$pgv_lang["time_format_help"]			= "~#pgv_lang[time_format]#~<br /><br />Dette felt definerer det tidsformat, der skal bruges af PhpGedView.<br /><br />De symboler, du kan bruge, er:<br /><b>a</b> - små bogstaver Ante meridiem og Post meridiem; dvs. <b>am</b> eller <b>pm</b><br /><b>A</b> - store bogstaver Ante meridiem og Post meridiem; dvs. <b>AM</b> eller <b>PM</b><br /><b>B</b> - Swatch Internet-tid; dvs. <b>000</b> til <b>999</b><br /><b>c</b> - ISO 8601 dato; for eksempel <b>2004-02-12T15:19:21+00:00</b><br /><b>d</b> - dag i måneden, 2 cifre, førende nul; dvs. <b>01</b> til <b>31</b><br /><b>D</b> - dag, tekst, tre bogstaver; for eksempel. <b>Man</b><br /><b>F</b> - måned, tekst, lang; for eksempel <b>januar</b><br /><b>g</b> - time, 12-timers format, ingen nul foran; dvs. <b>1</b> til <b>12</b><br /><b>G</b> - time, 24-timers format, ingen nul; dvs. <b>0</b> til <b>23</b><br /><b>h</b> - time, 12-timers format, førende nul; dvs. <b>01</b> til <b>12</b><br /><b>H</b> - time, 24-timers format, førende nul; dvs. <b>00</b> til <b>23</b><br /><b>i</b> - minutter, førende nul; dvs. <b>00</b> til <b>59</b><br /><b>I</b> (store «i») - indikator for sommertid <b>1</b> hvis sommertid, <b>0</b> ellers.<br /><b>j</b> - dag i måneden, ingen førende nul; dvs. <b>1</b> til <b>31</b><br /><b>l</b> (små «L») - ugedag, tekst, lang; for eksempel <b>Fredag</b><br /><b>L</b> - skudårsindikator; <b>1</b> hvis det er et skudår, <b>0</b> ellers.<br /><b>m</b> - måned, numerisk, førende nul; dvs. <b>01</b> til <b>12</b><br /><b>M</b> - måned, tekst, 3 bogstaver; for eksempel <b>Jan</b><br /><b>n</b> - måned, numerisk, ingen førende nul; dvs. <b>1</b> til <b>12</b><br /><b>O</b> (store «o») - forskel mellem lokal og Greenwich-tid (GMT) i timer; for eksempel. <b>+0200</b><br /><b>r</b> - RFC 2822 formateret dato; for eksempel <b>Tor,&nbsp;21&nbsp;Dec&nbsp;2000&nbsp;16:01:07&nbsp;+0200</b><br /><b>s</b> - sekunder, førende nul; dvs. <b>00</b> til <b>59</b><br /><b>S</b> - suffikset på månedsdagen, kun på engelsk, 2 tegn; dvs. <b>st</b>, <b>nd</b>, <b>rd</b> eller <b>th</b>. Fungerer godt med <b>j</b><br /><b>t</b> - antal dage i den givne måned dvs. <b>28</b> til <b>31</b><br /><b>T</b> - tidszoneindstilling for denne maskine for eksempel <b>CEST</b>, <b>EST</b>, <b>MDT</b><br /><b>U</b> - sekunder siden starten på Unix Epoch (1.&nbsp;januar&nbsp;1970&nbsp;00:00:00 GMT)<br /><b>w</b> - ugedag, numerisk; dvs. <b>0</b> (søndag) til <b>6</b> (lørdag)<br /><b>W</b> - ISO 8601 uges antal år, uger der starter mandag; for eksempel <b>42</b> (den 42. uge i året)<br /><b>Y</b> - år, 4 cifre for eksempel <b>1999</b><br /><b>y</b> - år, 2 cifre for eksempel <b>99</b><br /><b>z</b> - dag på året, numerisk, ingen førende nuller; dvs. <b>0</b> (1. januar) til <b>364</b> (31. december, når der ikke er et skudår) eller <b>365</b> (31. december i skudår)<br /><b>Z</b> - tidszone forskudt i sekunder. Forskydningen for tidszoner vest for Greenwich er altid negativ, og for dem øst for Greenwich er forskydningen altid positiv. dvs. <b>-43200</b> til <b>43200</b><br /><br />Du kan ændre rækkefølgen af disse symboler, og du kan tilføje afgrænsere til formatet.<br />For eksempel indeholder dette felt normalt på tysk <b>H:i:s</b> at producere et display som <b>09:01:25</b>.<br />Engelsk definerer normalt tidsformatet som <b>g:i:sa</b> at producere et display som <b>9:01:25am</b>.<br /><br />I 24-timerssystemet er midnat 00:00. I 12-timerssystemet er midnat 12:00am og middag 12:00pm.";
$pgv_lang["week_start"]			= "Uges startdag";
$pgv_lang["week_start_help"]		= "~#pgv_lang[week_start]#~<br /><br />Ugedagen, der starter en ny uge på dette sprog. De fleste sprog starter ugen søndag, men nogle starter mandag eller andre dage.";
$pgv_lang["name_reverse"]		= "Efternavn først";
$pgv_lang["name_reverse_help"]		= "~#pgv_lang[name_reverse]#~<br /><br />På nogle sprog skal efternavnet vises først i stedet for standard for at vise det sidst. Aktivering af dette valg viser efternavnet først. Ungarsk, kinesisk og japansk er eksempler, hvor efternavnet (familienavnet) normalt gives først.";
$pgv_lang["ltr"]			= "Venstre til højre";
$pgv_lang["rtl"]			= "Højre til venstre";
$pgv_lang["file_does_not_exist"]	= "FEJL! Filen findes ikke...";
$pgv_lang["optional_file_not_exist"]	= "Denne valgfri fil findes ikke.";
$pgv_lang["alphabet_upper"]		= "Alfabet store bogstaver";
$pgv_lang["alphabet_upper_help"]	= "~#pgv_lang[alphabet_upper]#~<br /><br />Store alfabetbogstaver på dette sprog. Dette alfabet bruges under sortering af lister over navne.";
$pgv_lang["alphabet_lower"]		= "Alfabet små bogstaver";
$pgv_lang["alphabet_lower_help"]	= "~#pgv_lang[alphabet_lower]#~<br /><br />Små alfabetbogstaver på dette sprog. Dette alfabet bruges under sortering af lister over navne.";
$pgv_lang["multi_letter_alphabet"]		= "Alfabet flere bogstaver";
$pgv_lang["multi_letter_alphabet_help"]	= "~#pgv_lang[multi_letter_alphabet]#~<br /><br />Multi-bogstavkombinationer, der skal behandles som et enkelt særskilt bogstav, når man sorterer lister over navne og titler på dette sprog.<br /><br />Nogle sprog, f.eks. Ungarsk og slovakisk, betragter visse kombinationer af bogstaver som forskellige bogstaver i deres egen ret. Den rækkefølge, som du angiver disse bogstavkombinationer, bestemmer rækkefølgen, i hvilken de indsættes i det normale alfabet under sortering. Dette er vigtigt, når flere kombinationer med flere bogstaver har det samme første bogstav. Bortset fra <b>ch</b> indsættes disse bogstavkombinationer i det normale alfabet i henhold til deres første bogstav. <b>ch</b> indsættes altid efter <b>h</b>.";
$pgv_lang["multi_letter_equiv"]		= "Flerbogstavsækvivalenter";
$pgv_lang["multi_letter_equiv_help"]	= "~#pgv_lang[multi_letter_equiv]#~<br /><br />På nogle sprog behandles flere bogstaver ofte som ækvivalente med et enkelt bogstav, når der genereres lister med navne.<br /><br />For eksempel vises på hollandsk navne, der begynder med <b>IJ</b>, sammen med navne, der begynder med <b>Y</b>. På norsk, navne der begynder med <b>Aa</b> er angivet med <b>&Aring;</b>. På nogle sprog er der bogstaver, der kan skrives som et eller to tegn. For eksempel på slovakisk kan de to tegn D og \xC5\xBE skrives som det enkelte tegn \xC7\x85. Ved at specificere ækvivalenter her kan du tillade, at navne, der begynder med disse bogstaver, grupperes på de enkelte listsider.<br /><br />Du skal angive en komma-adskilt liste med ækvivalenter. For at understøtte databaser, der ikke genkender UTF-8-kodning, skal du specificere både store og små ækvivalenter. Dette eksempel viser det format, der skal bruges.<br /><br />Aa=&Aring;,aa=&aring;";
$pgv_lang["dictionary_sort"]		= "Brug ordbogens regler under sortering";
$pgv_lang["dictionary_sort_help"]	= "~#pgv_lang[dictionary_sort]#~<br /><br />Dette valg styrer, hvordan tegn med diakritiske tegn håndteres ved sortering af lister med navne og titler.<br /><br />Når det er indstillet til <b>#pgv_lang[yes]#</b>, behandles alle tegn med diakritiske tegn som om de ikke havde nogen mærker. Diakritiske tegn betragtes kun, når de to ord, der betragtes, ellers er identiske. Når det er indstillet til <b>#pgv_lang[no]#</b>, er alle bogstaver forskellige, uanset om der er diakritiske tegn.";
$pgv_lang["collation"]		= "Databasekollationssekvens";
$pgv_lang["collation_help"]	= "~#pgv_lang[collation]#~<br /><br />Hvis du bruger databasens indbyggede sorteringsregler, specificerer dette valg den sorteringssekvens, der skal bruges til dette sprog. Du skal sikre dig, at din database understøtter alle de sorteringssekvenser, du har til hensigt at bruge.<br /><br />Brug af databasesortering styres i konfigurationsindstillingerne for webstedet.";
$pgv_lang["lang_config_write_error"]	= "Fejl ved skrivning af sprogindstillinger til filen <i>language_settings.php</i>. Kontroller tilladelserne, og prøv igen.";
$pgv_lang["lang_set_file_read_error"]	= "F E J L !!! Kunne ikke læse <i>language_settings.php</i>!";
$pgv_lang["add_new_language_help"]	= "~#pgv_lang[add_new_language]#~<br /><br />#pgv_lang[add_new_language_desc]#";
$pgv_lang["add_new_language_desc"]	= "Denne rutine giver dig mulighed for at tilføje et nyt, tidligere utilgængeligt og fuldstændigt ikke-understøttet sprog til PhpGedView.<br /><br />Du kan indstille standardindstillingerne for det nye sprog. Disse inkluderer sprogregistreringskode, sprogretning, ugens start for dette sprog, tidsindstillinger, alfabet osv.<br /><br />Du får mere hjælp til indstillingerne for sprog, der understøttes af PhpGedView efter valg af sprog og ved at klikke på knappen <b>#pgv_lang[add_new_lang_button]#</b>.<br /><br />Mere hjælp er tilgængelig på konfigurationssiden for sproget.";
$pgv_lang["add_new_lang_button"]	= "Tilføj nyt sprog";
$pgv_lang["hide_translated"]		= "Skjul oversat";
$pgv_lang["hide_translated_help"]		= "~#pgv_lang[hide_translated]#~<br /><br />Hvis indstillet til <b>#pgv_lang[yes]#</b>, vil du kun se de meddelelser fra din valgte sprogfil, som ikke er oversat. Dette betyder, at den nye besked <u>ikke</u> vises i målsprogfilen.<br /><br />Nogle sprogfiler indeholder engelsk tekst til forskellige ikke-oversatte meddelelser. Denne rutine kan ikke identificere disse ikke-oversatte elementer, da de allerede findes i målfilen. Antagelsen er: «Hvis meddelelsen findes i målfilen, skal den være oversat.»";
$pgv_lang["lang_file_write_error"]	= "F E J L !!! Kunne ikke skrive ændringer i den valgte sprogfil. Kontroller skriv tilladelser til <b>#lang_filename#</b>";
$pgv_lang["no_open"]	= "F E J L !!! Kan ikke åbne filen <b>#lang_filename#</b>";
$pgv_lang["users_langs"]			= "Brugers sprog";
$pgv_lang["configured_languages"]	= "Brugte sprog";

//-- User Migration Tool messages
$pgv_lang["um_header"] = "Værktøj til migrering af brugerinformation";
$pgv_lang["um_proceed"] = "Foretag et valg, eller klik på nedenstående link for at vende tilbage til menuen Administration";
$pgv_lang["um_creating"] = "Opretter";
$pgv_lang["um_sql_index"] = "Dette værktøj opretter <i>authenticate.php</i> og flere <i>.dat</i> filer i din indeksmappe.<br /><br />Efter vellykket oprettelse kan du skifte til indekstilstand med alle aktuelle brugere og deres beskeder, favoritter, nyheder og MyGedview-layout tilgængelige.<br /><br />Bemærk: Når du skifter til indekstilstand, skal du importere dine GEDCOM-filer igen.";
$pgv_lang["um_file_create_fail1"] = "Oprettelse af ny fil mislykkedes, en fil med det navn findes allerede:";
$pgv_lang["um_file_create_fail2"] = "Kan ikke oprette";
$pgv_lang["um_file_create_fail3"] = "Kontroller adgangsrettigheder i denne mappe.";
$pgv_lang["um_file_create_succ1"] = "Oprettelse af ny fil lykkedes:";
$pgv_lang["um_file_not_created"] = "Fil oprettes ikke.";
$pgv_lang["um_nomsg"] = "Ingen meddelelser ser ud til at være til stede i systemet.";
$pgv_lang["um_nofav"] = "Ingen favoritter ser ud til at være til stede i systemet.";
$pgv_lang["um_nonews"] = "Ingen nyheder ser ud til at være til stede i systemet.";
$pgv_lang["um_noblocks"] = "Ingen blokke ser ud til at være til stede i systemet.";
$pgv_lang["um_index_sql"] = "Dette værktøj importerer <i>authenticate.php</i> og andre <i>.dat</i> filer fra din indeksmappe til din database.";
$pgv_lang["um_noaction"] = "Der kræves ingen handling for at migrere brugeroplysninger til SQL-tilstand.<br /><br />Når du er skiftet til SQL-tilstand, skal du genstarte <b>#pgv_lang[um_header]#</b> for at importere alle data til SQL-databasen. PhpGedView bruger eksisterende filer fra indekstilstand.<br /><br /><b>Fjern <u>ikke</u> <i>authenticate.php</i> og <i>.dat</i> filer fra din indeksmappe, mens du skifter.</b>";
$pgv_lang["um_import"] = "Importere";
$pgv_lang["um_export"] = "Eksport";
$pgv_lang["um_explain"] = "Dette værktøj eksporterer enten brugerdata fra SQL til indekstilstand eller importerer brugerdata fra indeksfiler til SQL-tabeller.<br /><br />Brugerdata, favoritter, blokdefinitioner, meddelelser og nyheder vil være tilgængelige igen efter migrering.<br /><br /><b>FORSIGTIG</b><br />Du kan ikke bruge dette værktøj til at migrere brugerdata mellem forskellige versioner af PhpGedView. Sørg for, at dataene stammer fra eller importeres til den samme PhpGedView-version.<br /><br /><b>IMPORTERE</b><br />Hvis du vælger at importere brugerdatafiler fra indekstilstand, alle brugerdata, der findes i databasetabellerne, <u>overskrives</u>. Dette værktøj fusionerer <u>ikke</u> oplysningerne. Når du har kørt importen, er der ingen måde at hente de gamle oplysninger ved hjælp af PhpGedView.<br /><br /><b>EKSPORT</b><br />Hvis du eksporterer brugeroplysningerne fra din SQL-database til Index Mode-filer, dette værktøj opretter <i>authenticate.php</i> og flere <i>.dat</i> filer i din indeksmappe. Hvis der allerede findes identisk navngivne filer, bliver du bedt om, om de skal overskrives. Efter skift til indekstilstand vil alle oplysninger være tilgængelige direkte.<br /><br /><b>Bemærk:</b> Når du har skiftet til indekstilstand, skal du importere dine GEDCOM-filer igen.";
$pgv_lang["um_tool_help"] = "~#pgv_lang[um_header]#~<br /><br />#pgv_lang[um_explain]#";
$pgv_lang["um_sql_index_help"] = "~Migrer brugere fra SQL til Metode Index~<br /><br />#pgv_lang[um_sql_index]#";
$pgv_lang["um_index_sql_help"] = "~Migrer brugere fra Metode Index til SQL~<br /><br />#pgv_lang[um_index_sql]#";
$pgv_lang["um_imp_users"] = "Importerer brugere";
$pgv_lang["um_imp_blocks"] = "Importerer blokke";
$pgv_lang["um_imp_favorites"] = "Importerer favoritter";
$pgv_lang["um_imp_messages"] = "Importerer beskeder";
$pgv_lang["um_imp_news"] = "Importerer nyheder";
$pgv_lang["um_nousers"] = "Fil <i>authenticate.php</i> blev ikke fundet i din Index mappe. Migrering annulleres.";
$pgv_lang["um_imp_succ"] = "Importen blev gennemført";
$pgv_lang["um_imp_fail"] = "Import mislykkedes";
$pgv_lang["um_backup"] = "Backup";
$pgv_lang["um_zip_succ"] = "ZIP-fil blev oprettet.";
$pgv_lang["um_zip_dl"] = "Download ZIP-sikkerhedskopifil ";
$pgv_lang["um_bu_explain"] = "Dette værktøj kan tage en sikkerhedskopi af flere slags data i PhpGedView.<br /><br />De data, du vælger at tage backup af, samles i en ZIP-fil, som du kan downloade ved at klikke på linket i bunden af efter sikkerhedskopien er lavet.<br /><br />ZIP-filen forbliver i din indeksmappe, indtil du fjerner den manuelt.";
$pgv_lang["um_bu_help"] = "~#pgv_lang[um_backup]#~<br /><br />#pgv_lang[um_bu_explain]#";
$pgv_lang["um_bu_config"] = "PhpGedView konfigurationsfil";
$pgv_lang["um_bu_gedcoms"] = "GEDCOM filer";
$pgv_lang["um_bu_gedsets"] = "GEDCOM-indstillinger, konfigurations- og fortrolighedsfiler";
$pgv_lang["um_bu_logs"] = "GEDCOM-søgelogfiler og PhpGedView-logfiler";
$pgv_lang["um_bu_usinfo"] = "Brugerdefinitioner, Bloker indstillinger, Foretrukne, Beskeder, Nyheder";
$pgv_lang["um_bu_media"]	= "Mediefiler";
$pgv_lang["um_mk_bu"] = "Lav sikkerhedskopi";
$pgv_lang["um_nofiles"] = "Ingen filer fundet til sikkerhedskopiering.";
$pgv_lang["um_files_exist"] = "En eller flere filer findes allerede. Vil du overskrive dem?";
$pgv_lang["um_results"]		= "Resultater";
$pgv_lang["preview_faq_item"] = "Se alle FAQ-emner";
$pgv_lang["preview_faq_item_help"] = "~#pgv_lang[preview_faq_item]#~<br /><br />Dette valg gør det muligt for en administratorbruger at se FAQ-siden uden alle redigeringsvalg og links.<br /><br />Bortset fra et enkelt <b>Rediger</b> link over det første FAQ-punkt, udseendet af FAQ siden vil være identisk med, hvad en almindelig bruger ville se. Dette specielle <b>rediger</b> link gendanner den fulde redigeringsfunktionalitet til siden med ofte stillede spørgsmål.";
$pgv_lang["restore_faq_edits"] = "Gendan FAQ-redigeringsfunktionalitet";
$pgv_lang["restore_faq_edits_help"] = "~#pgv_lang[restore_faq_edits]#~<br /><br />Dette valg gendanner FAQ-siden til det, som en admin-bruger normalt ser, så individuelle FAQ-poster kan redigeres.";
$pgv_lang["add_faq_item"] = "Tilføj FAQ-spørgsmål";
$pgv_lang["add_faq_item_help"] = "~#pgv_lang[add_faq_item]#~<br /><br />Dette valg giver dig mulighed for at tilføje et element til siden med ofte stillede spørgsmål.";
$pgv_lang["edit_faq_item"] = "Rediger ofte stillede spørgsmål";
$pgv_lang["edit_faq_item_help"] = "~#pgv_lang[edit_faq_item]#~<br /><br />Dette valg giver dig mulighed for at redigere et element på siden FAQ.";
$pgv_lang["delete_faq_item"] = "Slet FAQ-element";
$pgv_lang["delete_faq_item_help"] = "~#pgv_lang[delete_faq_item]#~<br /><br />Dette valg giver dig mulighed for at slette et element fra siden FAQ";
$pgv_lang["moveup_faq_item"] = "Flyt ofte stillede spørgsmål op";
$pgv_lang["moveup_faq_item_help"] = "~#pgv_lang[moveup_faq_item]#~<br /><br />Dette valg giver dig mulighed for at flytte et element opad på FAQ-siden.<br /><br />Hver gang du bruger dette valg, reduceres FAQ-positionens nummer på dette element med et. Du kan opnå den samme effekt ved at redigere det pågældende emne og ændre feltet FAQ Position. Når mere end en FAQ-vare har det samme positionsnummer, er kun en af disse poster synlige.";
$pgv_lang["movedown_faq_item"] = "Flyt ofte stillede spørgsmål ned";
$pgv_lang["movedown_faq_item_help"] = "~#pgv_lang[movedown_faq_item]#~<br /><br />Dette valg giver dig mulighed for at flytte et element nedad på siden med ofte stillede spørgsmål.<br /><br />Hver gang du bruger dette valg, forøges FAQ-nummeret på denne vare med et. Du kan opnå den samme effekt ved at redigere det pågældende emne og ændre feltet FAQ Position. Når mere end en FAQ-vare har det samme positionsnummer, er kun en af disse poster synlige.";
$pgv_lang["add_faq_header_help"] = "~#pgv_lang[add_faq_header]#~<br /><br />Dette er titlen eller emnet på FAQ-emnet.<br /><br />Det, du indtaster her, kan formateres. HTML-tags som &lt;b&gt; og &lt;br /&gt; er tilladt, ligesom HTML-enheder som &amp;amp; og &amp;nbsp;. Andre HTML-tags end &lt;br /&gt; er sandsynligvis ikke særlig nyttige i FAQ-titlen og bør undgås.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["add_faq_body_help"] = "~#pgv_lang[add_faq_body]#~<br /><br />Teksten til FAQ-elementet indtastes her.<br /><br />Teksten kan formateres. HTML-tags som &lt;b&gt; og &lt;br /&gt; er tilladt, ligesom HTML-enheder som &amp;amp; og &amp;nbsp;.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["add_faq_HTML"] = "HTML-enheder er en meget nem måde at tilføje specialtegn til dine ofte titler og tekst. Du kan bruge symbolske navne, decimaltal eller hexadecimale tal. En komplet liste over HTML-enheder, deres kodning og deres repræsentation af din browser kan findes her: <a href=\"http://htmlhelp.com/reference/html40/entities/\" target=\"_blank\">HTML-enhedslister</a><br /><br />Af og til skal du muligvis vise et Tilde-tegn&nbsp;&nbsp;<b>&#x7E;</b>&nbsp;&nbsp;eller et taltegn&nbsp;&nbsp;<b>&#x23;</b>&nbsp;&nbsp;i dine webadresser eller tekst. Disse tegn har en særlig betydning for PhpGedView Help-systemet og kan kun indtastes i deres hexadecimale eller decimale form. Tilsvarende skal&nbsp;&nbsp;<b>&lt;</b>&nbsp;&nbsp;og&nbsp;&nbsp;<b>&gt;</b>&nbsp;&nbsp;tegn, der normalt omslutter HTML-tags, indtastes i deres hexadecimal eller decimal formularer, hvis de skal behandles som normal tekst i stedet for at signalere et HTML-tag.<ul><li><b>&amp;&#x23;35;</b>&nbsp;&nbsp;eller&nbsp;&nbsp;<b>&amp;&#x23;x23;</b>&nbsp;&nbsp;vil medføre&nbsp;&nbsp;<b>&#x23;</b></li><li><b>&amp;&#x23;60;</b>&nbsp;&nbsp;eller&nbsp;&nbsp;<b>&amp;&#x23;x3C;</b>&nbsp;&nbsp;vil medføre&nbsp;&nbsp;<b>&#x3C;</b></li><li><b>&amp;&#x23;62;</b>&nbsp;&nbsp;eller&nbsp;&nbsp;<b>&amp;&#x23;x3E;</b>&nbsp;&nbsp;vil medføre&nbsp;&nbsp;<b>&#x3E;</b></li><li><b>&amp;&#x23;126;</b>&nbsp;&nbsp;eller&nbsp;&nbsp;<b>&amp;&#x23;x7E;</b>&nbsp;&nbsp;vil medføre&nbsp;&nbsp;<b>&#x7E;</b></li></ul>Der er en&nbsp;&nbsp;<b>&amp;tilde;</b>&nbsp;&nbsp;HTML-enhed, men dette symbol fortolkes ikke som en Tilde, når den er kodet i URL'er.";
$pgv_lang["add_faq_pgvLangRefs"] = "Du kan indsætte referencer til poster i sprogfilerne eller til værdier for globale variabler. Eksempler:<ul><li><b>&#x23;pgv_lang[add_to_cart]&#x23;</b>&nbsp;&nbsp;&nbsp;er en henvisning til sprogvariablen \$pgv_lang[\"add_to_cart\"], og hvis det skulle vises i dette felt, ville vise som <b>#pgv_lang[add_to_cart]#</b> når FAQ-listen vises på dansk.</li><li><b>&#x23;factarray[AFN]&#x23;</b>&nbsp;&nbsp;&nbsp;er en henvisning til fakta navn \$factarray[\"AFN\"], og hvis det skulle vises i dette felt, ville vise som <b>#factarray[AFN]#</b> når FAQ-listen vises på dansk.</li><li><b>&#x23;PGV_VERSION&#x23;&nbsp;&#x23;PGV_VERSION_RELEASE&#x23;</b>&nbsp;&nbsp;&nbsp;er en henvisning til konstanten PGV_VERSION, et rum, og en henvisning til konstanten PGV_VERSION_RELEASE, og hvis de skulle vises i dette felt, ville vise som <b>#PGV_VERSION#&nbsp;#PGV_VERSION_RELEASE#</b> når FAQ-listen vises på dansk.</li><li><b>&#x23;GLOBALS[GEDCOM]&#x23;</b>&nbsp;&nbsp;&nbsp;er en henvisning til den globale variabel \$GEDCOM, som er navnet på den aktuelle GEDCOM-fil. Hvis det skulle vises i dette felt, ville det vise sig som <b>#GLOBALS[GEDCOM]#</b>.</li><li><b>&#x23;GLOBALS[GEDCOM_TITLE]&#x23;</b>&nbsp;&nbsp;&nbsp;er en henvisning til den globale variabel \$GEDCOM_TITLE, som er titlen på den aktuelle GEDCOM-fil. Hvis det skulle vises i dette felt, ville det vise sig som <b>#GLOBALS[GEDCOM_TITLE]#</b>.</li></ul><br />Denne funktion er nyttig, når du ønsker at oprette FAQ-lister, der er forskellige for hvert sprog, dit websted understøtter. Du skal placere dine tilpassede FAQ-titler og poster i <i>languages/extra.xx.php</i> filerne (<i>xx</i> er koden for hvert sprog) ved hjælp af følgende format:<br /><code>\$pgv_lang[\"faq_title1\"]&nbsp;=&nbsp;\"Dette er en eksempler på titlen på ofte stillede spørgsmål\";<br />\$pgv_lang[\"faq_body1\"]&nbsp;=&nbsp;\"Dette er et eksempel på ofte stillede spørgsmål.\";</code>";
$pgv_lang["add_faq_order_help"] = "~#pgv_lang[add_faq_order]#~<br /><br />TDette felt styrer rækkefølgen, som FAQ-emnerne vises i.<br /><br />Du behøver ikke indtaste numrene i rækkefølge. Hvis du efterlader huller i nummereringsskemaet, kan du indsætte andre emner senere. Hvis du f.eks. Bruger tallene 1, 6, 11, 16, kan du senere indsætte emner med de manglende sekvensnumre. Negative tal og nul er tilladt og kan bruges til at indsætte emner foran den første.<br /><br />Når mere end et FAQ-emne har det samme positionsnummer, vil kun en af disse emner være synlige.";
$pgv_lang["add_faq_visibility_help"] = "~#pgv_lang[add_faq_visibility]#~<br /><br />Du kan afgøre, om denne FAQ vil være synlig uanset GEDCOM, eller om den kun vil være synlig for den nuværende GEDCOM.<br /><ul><li><b>#pgv_lang[all]#</b>&nbsp;&nbsp;&nbsp;FAQ'en vises på alle FAQ-lister, uanset GEDCOM.</li><li><b>#GLOBALS[GEDCOM]#</b>&nbsp;&nbsp;&nbsp;FAQ vises kun i den aktuelt aktive GEDCOM's FAQ-liste.</li></ul>";
$pgv_lang["index_gedcom_news_adm_help"]		= "GEDCOM News-teksten tillader brug af <b>HTML tags</b> og <b>HTML enheder</b>. HTML bør ikke bruges i nyhedstitler.<br /><br />Sørg altid for at bruge både start- og slutkoder. Det kan hjælpe at have en forståelse af HTML, der passer til en webstedsadministrator. Dette program bruger også <b>Cascading Style Sheets (CSS)</b>. En forskellig CSS er implementeret for hvert tema. Du kan bruge klasser fra disse typografiark til at kontrollere udseendet af dine meddelelser.<br /><br />Hvis du har brug for mere hjælp til dette, har webstedet PhpGedView nogle eksempler på, hvordan du bruger disse tags i din GEDCOM News-blok.<br /><br />Som med FAQ-listen tillader GEDCOM News-titler og News-tekst indlejrede referencer til \$pgv_lang, \$factarray og \$GLOBALS variabler for at give fuldstændig fleksibilitet i oprettelsen af nyhedsartikler følsom over for det aktuelt aktive sprog.<br /><br />Følgende beskrivelse hentet fra hjælpeteksten til FAQ-listen gælder også for GEDCOM-nyheder.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["time_limit_help"]			= "~#pgv_lang[time_limit]#~<br /><br />Den maksimale tid, importen må køre til behandling af GEDCOM-filen.";

// editconfig_gedcom.php choice Filter
$pgv_lang["ged_filter_results"] = "Resultater fundet";
$pgv_lang["ged_filter_reset"] = "Ryd søgning";
$pgv_lang["ged_filter_description"] = "Søgetekst";
$pgv_lang["ged_filter_description_help"] = "~#pgv_lang[ged_filter_description]#~<br /><br />Dette valg giver dig mulighed for at søge i den tekst, der er knyttet til konfigurationsvalg.<br /><br />Når du skriver bogstaver, finder søgningen alle konfigurationsvalg, der indeholder bogstavsekvensen. Søgningen bliver mere præcis, når du skriver flere bogstaver.";

?>
