<?php
/**
 * German Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2022  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author Norgaz Kurt
 * @author Peter Pluntke
 * @author Gerd Kroll
 * @version $Id: configure_help.de.php 7338 2022-02-24 16:01:44Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["google_analytics_help"]			= "~#pgv_lang[google_analytics]#~<br /><br />Auskunft über den #pgv_lang[google_analytics]# Dienst ist in diesem <a href='https://de.wikipedia.org/wiki/Google_Analytics' target='_blank' title='Wikipedia Artikel'>Wikipedia Artikel</a> zu finden.<br /><br />Bitte beachten Sie, dass, wenn Sie diesen Dienst nutzen, besitzt Google die Rechte zu allen von ihr erhobenen Daten über die Aktivitäten Ihrer Webseitenbesucher.";
$pgv_lang["USE_GOOGLE_ANALYTICS_help"]		= "~#pgv_lang[USE_GOOGLE_ANALYTICS]#~<br /><br />Wählen Sie <b>#pgv_lang[yes]#</b> um die Überwachung Ihrer Webseiten mittels des #pgv_lang[google_analytics]# Dienstes zu ermöglichen. Sie müssen Ihre PhpGedView Webseite bei diesem Dienst anmelden, bevor Sie diese Option aktivieren.";
$pgv_lang["PGV_GOOGLE_ANALYTICS_help"]		= "~#pgv_lang[PGV_GOOGLE_ANALYTICS]#~<br /><br />Geben Sie Ihre Kontonummer beim #pgv_lang[google_analytics]# Dienst ein.  Die Kontonummer hat das Format <b>UA-xxxxxx-x</b>.";
$pgv_lang["piwik_analytics_help"]			= "~#pgv_lang[piwik_analytics]#~<br /><br />Das #pgv_lang[piwik_analytics]# Open-Source Projekt, ursprünglich als »Piwik« bekannt, wird <a href='https://matomo.org/' target='_blank' title='Matomo official web site'>hier</a> beschrieben.<br /><br />Matomo ist eine Alternative zu #pgv_lang[google_analytics]#, und entfernt viele Privatsphärenbedenken.  Sie können #pgv_lang[piwik_analytics]# auf Ihrem eigenen Webserver oder in Ihrem eigenen Domain installieren.  So sind Sie sicher, dass nur Sie und Andere, denen Sie entsprechendes Erlaubnis gegeben haben, Zugriff zu den gesammelten Aktivitätsdaten haben.";
$pgv_lang["USE_PIWIK_ANALYTICS_help"]		= "~#pgv_lang[USE_PIWIK_ANALYTICS]#~<br /><br />Wählen Sie <b>#pgv_lang[yes]#</b> um die Überwachung Ihrer Webseiten mittels eines #pgv_lang[piwik_analytics]# Servers zu ermöglichen.  Sie müssen Ihre PhpGedView Webseite bei solchem Server anmelden.";
$pgv_lang["PGV_PIWIK_URL_help"]				= "~#pgv_lang[PGV_PIWIK_URL]#~<br /><br />Geben Sie die URL zu einem Matomo Server, wo Ihre PhpGedView Webseite angemeldet ist, ein.";
$pgv_lang["PGV_PIWIK_SITE_help"]			= "~#pgv_lang[PGV_PIWIK_SITE]#~<br /><br />Geben Sie die ID-Nummer, die Ihrer PhpGedView Webseite beim Matomo Server entspricht, ein.";
$pgv_lang["clustrmaps_analytics_help"]		= "~#pgv_lang[clustrmaps_analytics]#~<br /><br />#pgv_lang[clustrmaps_analytics]# ist ein Werkzeug das Besucher Ihrer PhpGedView-Seite zählt, und deren geographische Verteilung andeuten kann.<br /><br />Jede Ihrer Seiten enthält eine, von #pgv_lang[clustrmaps_analytics]# erstellte, Miniaturlandkarte.  Nach dem Laden dieses Miniaturbildes zählt #pgv_lang[clustrmaps_analytics]# den Zugriff, und ermittelt auch den Wohnort des Besuchers.  Die Miniaturlandkarte, die allen Besuchern, aber nicht Suchmaschinen, sichtbar ist, wird täglich aktualisiert.<br /><br />Wenn Sie den erweiterten #pgv_lang[clustrmaps_analytics]# Dienst gekauft haben, können Ihre Besucher auf der Miniaturlandkarte klicken, um eine vergrösserte Karte und mehr Details zu erhalten.<br /><br />Mehr Details über den #pgv_lang[clustrmaps_analytics]# Dienst sind bei der <a href='http://www.clustrmaps.com/' target='_blank' title='#pgv_lang[clustrmaps_analytics]# site'>#pgv_lang[clustrmaps_analytics]# site</a> erhältlich.";
$pgv_lang["USE_CLUSTRMAPS_ANALYTICS_help"]	= "~#pgv_lang[USE_CLUSTRMAPS_ANALYTICS]#~<br /><br />Wählen Sie <b>#pgv_lang[yes]#</b> um die Überwachung Ihrer Webseiten mittels des #pgv_lang[clustrmaps_analytics]# Dienstes zu ermöglichen.";
$pgv_lang["PGV_CLUSTRMAPS_SITE_help"]		= "~#pgv_lang[PGV_CLUSTRMAPS_SITE]#~<br /><br />Geben Sie das URL Ihrer PhpGedView Webseite ein. Normalerweise ist es nicht notwending, diesen im Voraus eingetragenen Wert zu ändern.";
$pgv_lang["PGV_CLUSTRMAPS_SERVER_help"]		= "~#pgv_lang[PGV_CLUSTRMAPS_SERVER]#~<br /><br />Geben Sie die vom #pgv_lang[clustrmaps_analytics]# Dienst zugewiesene Servernummer ein.";

$pgv_lang["SHOW_LIST_PLACES"]			= "In Listen zu zeigende Ebenen der Ortsangaben";
$pgv_lang["SHOW_LIST_PLACES_help"]		= "~#pgv_lang[SHOW_LIST_PLACES]#~<br /><br />Diese Option bestimmt, wie viele Ebenen der Ortsangaben in Listen zu zeigen sind.<br /><br />Die Wahl <b>9</b> bestimmt, dass alle Ortsangaben gezeigt werden.  Wenn Sie <b>0</b> (Null) wählen, werden keine Orte gezeigt.  Die Wahl <b>1</b> bedeutet, dass nur die höchste Ebene (normalerweise das Land) gezeigt wird.  Wenn Sie <b>2</b> wählen, werden die zwei höchsten Ebenen gezeigt.  Die zweit-höchste Ebene (unter dem Land) könnte Staat, Bundesland oder Provinz sein.  Usw.";

$pgv_lang["new_gedcom_title"]			= "Genealogische Daten aus #GEDCOMFILE#";
$pgv_lang["keep_media_help"]			= "~#pgv_lang[keep_media]#~<br /><br />Diese Option bestimmt, ob bereits bestehende Verbindungen zu Medien-Objekten während dem Hochladen der GEDCOM-Datei behalten werden sollen oder nicht. Wenn Sie <b>#pgv_lang[no]#</b> wählen, werden alle Medien-Verbindungen vor dem Hochladen aus der Datenbank entfernt.  Die <b>#pgv_lang[yes]#</b> Wahl bestimmt, dass bereits bestehende Verbindungen nicht gelöscht werden.<br /><br />Diese Option ist nützlich, wenn Sie die Datenbank als GEDCOM-Datei in ein anderes Programm exportieren, und dieses Programm die von PhpGedView erstellten Medien-Referenzen nicht richtig behandelt.  Wenn Sie dann die, vom anderen Programm bearbeitete, GEDCOM-Datei wieder in PhpGedView importieren, ist es durchaus möglich dass die darin enthaltenen Medien-Referenzen fehlerhaft sind oder sogar fehlen. In diesem Fall müssen Sie die Medienobjekte dann neu erstellen und neu mit Personen, Familien, und Quellen verbinden.<br /><br />Die Option <b>#pgv_lang[yes]#</b> informiert PhpGedView dass die bereits vorhandenen Medienobjekte und Medienverbindungen erhalten sein sollen.  Eine wichtige Voraussetzung für diese Wahl ist dass das externe Programm immer die gleichen Identifikationsnummern für Personen, Familien, und Quellen ausgibt.<br /><br /><i>Family Tree Maker</i>, sowie auch andere Programme, behandelt in GEDCOM-Dateien enthaltene Medienobjekte <u>falsch</u>.  <i>Legacy</i>, wie manche andere Programme, behandelt solche Medienobjekte <u>richtig</u>.";
$pgv_lang["USE_MEDIA_VIEWER"]			= "Diabetrachter benutzen";
$pgv_lang["USE_MEDIA_VIEWER_help"]		= "~#pgv_lang[USE_MEDIA_VIEWER]#~<br /><br />Wenn <b>#pgv_lang[yes]#</b> gewählt ist, wird durch das Klicken auf Bildern die Diabetrachter-Seite gezeigt.  Diese Seite enthält Einzelheiten über das Bild, und falls erlaubt, können die Einzelheiten auch bearbeitet werden.<br /><br />Wenn <b>#pgv_lang[no]#</b> gewählt ist, wird das Bild in voller Größe gezeigt, wenn Sie das Miniaturbild klicken.";
$pgv_lang["USE_MEDIA_FIREWALL"]			= "Medien-Feuerwand benutzen";
$pgv_lang["USE_MEDIA_FIREWALL_help"]	= "~#pgv_lang[USE_MEDIA_FIREWALL]#~<br /><br />Die Medien-Feuerwand ist im Wikipedia beschrieben. <a href=\"#PGV_PHPGEDVIEW_WIKI#/en/index.php?title=Media_Firewall\" target=\"_blank\">#PGV_PHPGEDVIEW_WIKI#</a>";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR"]		= "Medien-Feuerwand Hauptverzeichnis";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_help"]	= "~#pgv_lang[MEDIA_FIREWALL_ROOTDIR]#~<br /><br />Verzeichnis, worin das geschützte Medien-Verzeichnis erstellt werden kann.  #pgv_lang[MEDIA_FIREWALL_ROOTDIR_note]#";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_note"]	= "Der leere Eintrag bedeutet, dass das <b>#GLOBALS[INDEX_DIRECTORY]#</b> Verzeichnis benutzt wird.";
$pgv_lang["MEDIA_FIREWALL_THUMBS"]		= "Miniaturbilder von geschützten Bildern auch schützen";
$pgv_lang["MEDIA_FIREWALL_THUMBS_help"]	= "~#pgv_lang[MEDIA_FIREWALL_THUMBS]#~<br /><br />Wenn das große Bild sich im geschützen Medien-Verzeichnis befindet, soll das dazugehörende Miniaturbild auch geschützt werden?";
$pgv_lang["SHOW_SPIDER_TAGLINE"]		= "Suchmaschinen-Namen zeigen";
$pgv_lang["SHOW_SPIDER_TAGLINE_help"]	= "~#pgv_lang[SHOW_SPIDER_TAGLINE]#~<br /><br />Wenn diese Option auf <b>#pgv_lang[yes]#</b> gestellt ist, ist unten auf jeder Seite, die Suchmaschinen zugeliefert ist, der Suchmaschinen-Name zu finden.  Das kann Google&reg; AdSense beeinflussen";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS_help"]	= "~#pgv_lang[SHOW_PRIVATE_RELATIONSHIPS]#~<br /><br />Diese Option informiert das Programm, dass Familienverbindungen von und zu privaten Personen gezeigt werden dürfen.  Das hat zur Folge, dass auf Diagrammen leere »#pgv_lang[private]#« Boxen gezeigt werden, wenn die Daten der entsprechenden Person geschützt sind.<br /><br />Diese Option ist normalerweise auf <b>#pgv_lang[no]#</b> gestellt.  Anstatt diese Option auf <b>#pgv_lang[yes]#</b> zu stellen, wäre es besser, als Startperson in Diagrammen eine Person zu wählen, dessen Daten nicht geschützt sind.";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS"]	= "Verwandtschaft zu privaten Personen zeigen";
$pgv_lang["SYNC_GEDCOM_FILE_help"] 			= "~#pgv_lang[SYNC_GEDCOM_FILE]#~<br /><br />Wenn Sie diesen Wert auf <b>#pgv_lang[yes]#</b> setzen, wird die GEDCOM-Datei automatisch aktualisiert, wenn Änderungen in die Datenbank übernommen werden. Dadurch bleibt die GEDCOM-Datei mit der Datenbank synchronisiert.<br /><br />Möglicherweise möchten Sie ihn auf <b>#pgv_lang[no]#</b> umstellen, um die Geschwindigkeit des Programms zu verbessern und Speicherplatz zu sparen, wenn Sie Änderungen akzeptieren.";
$pgv_lang["SYNC_GEDCOM_FILE"]			= "Änderungen sofort in der GEDCOM-Datei synchronisieren";
$pgv_lang["SHOW_MULTISITE_SEARCH_help"]	= "~#pgv_lang[SHOW_MULTISITE_SEARCH]#~<br /><br />Sie haben die Möglichkeit, andere Datenbanken zu durchsuchen.  Die Webseiten, zu denen Verbindungen hergestellt werden können, sind auf der »Internetseiten verwalten« Seite, zugänglich vom Verwaltungs-Menü, eingetragen. Diese Option bestimmt, wer fremde Webseiten durchsuchen darf.";
$pgv_lang["SHOW_MULTISITE_SEARCH"]		= "Fremde Webseiten durchsuchen";
$pgv_lang["SHOW_NO_WATERMARK"]			= "Wem Bilder ohne Wasserzeichen zeigen";
$pgv_lang["SHOW_NO_WATERMARK_help"]		= "~#pgv_lang[SHOW_NO_WATERMARK]#~<br /><br />Wenn die Medien-Feuerwand benutzt wird, werden Bilder mit Wasserzeichen versehen, wenn der Benutzer nicht genügende Rechte hat.";
$pgv_lang["WATERMARK_THUMB"]			= "Miniaturbilder mit Wasserzeichen versehen";
$pgv_lang["WATERMARK_THUMB_help"]		= "~#pgv_lang[WATERMARK_THUMB]#~<br /><br />Wenn die Medien-Feurwand benutzt wird, sollen Miniaturbilder auch mit Wasserzeichen versehen werden?  Medien-Listen laden langsamer wenn diese Option auf <b>#pgv_lang[yes]#</b> gestellt ist.";
$pgv_lang["SAVE_WATERMARK_THUMB"]		= "Mit Wasserzeichen versehene Miniaturbilder auf dem Server bewahren";
$pgv_lang["SAVE_WATERMARK_THUMB_help"]	= "~#pgv_lang[SAVE_WATERMARK_THUMB]#~<br /><br />Wenn die Medien-Feurwand benutzt wird und hier <b>#pgv_lang[yes]#</b> gewählt ist, werden alle mit Wasserzeichen versehene Miniaturbilder auf dem Server bewahrt.<br /><br />Der Vorteil dieser Option ist ein schnelleres Zeigen der Medienlisten;  der Nachteil ist ein erhöhter Festplatten-Speicherbedarf, da dann jedes Miniaturbild zweimal gespeichert werden muss.";
$pgv_lang["SAVE_WATERMARK_IMAGE"]		= "Mit Wasserzeichen versehene Bilder auf dem Server bewahren";
$pgv_lang["SAVE_WATERMARK_IMAGE_help"]	= "~#pgv_lang[SAVE_WATERMARK_IMAGE]#~<br /><br />Wenn die Medien-Feurwand benutzt wird und hier <b>#pgv_lang[yes]#</b> gewählt ist, sind alle mit Wasserzeichen versehene Bilder auf dem Server bewahrt.<br /><br />Der Vorteil dieser Option ist ein schnelleres Zeigen der Bilder;  der Nachteil ist ein erhöhter Festplatten-Speicherbedarf, da dann jedes Bild zweimal gespeichert werden muss.";
$pgv_lang["DB_UTF8_COLLATION"]			= "Datenbank zum Sortieren von UTF-8 Daten benutzen";
$pgv_lang["DB_UTF8_COLLATION_help"]		= "Bestimmt, ob PhpGedView die Datenbank zum Sortieren von UTF-8 Daten benutzen darf oder nicht.  Meistens kann das Datenbank-System Daten in UTF-8 Kodierung weitaus schneller sortieren und filtern als ein PHP-Programm.  Man muss dabei bedenken, dass nicht alle Datenbanksysteme die UTF-8 Kodierung vollkommen unterstützen.  Die Reihenfolge der Buchstaben, die beim Sortieren benutzt werden soll, wird auf der Konfigurations-Seite der jeweiligen Sprache bestimmt.<br /><br /><span class=\"warning\">WICHTIG: Sie sollten diese Einstellung nur während der Erst-Konfiguration, bevor die Datenbank-Tabellen erstellt sind, auf <b>#pgv_lang[yes]#</b> stellen.  Falls Sie diese Einstellung zu spät ändern, könnten Ihre Daten beschädigt werden.</span><br /><br />MySQL unterstützt UTF-8 gut, aber in älteren Versionen fehlt die Unterstützung der Sortierreihenfolge mancher Sprachen.  Falls Sie nicht sicher sind, ob Ihr Datenbanksystem die UTF-8 Kodierung unterstützt, sollten Sie hier <b>#pgv_lang[no]#</b> wählen.<br /><br />Ausführliche Informationen über UTF-8 können Sie in diesem <a href='http://de.wikipedia.org/wiki/UTF-8' target='_blank' title='Wikipedia Artikel'><b>Wikipedia Artikel</b></a> finden.";
$pgv_lang["INDI_FACTS_ADD"] 			= "Fakten zu Personen hinzufügen";
$pgv_lang["INDI_FACTS_ADD_help"]		= "~#pgv_lang[INDI_FACTS_ADD]#~<br /><br />Diese Liste enthält alle Fakte die diesem Personen-Datensatz hinzugefügt werden können.  Sie können diese Liste durch Entfernen oder Hinzufügen von Fakt-Codes nach Ihren Wünschen ändern.  Fakt-Codes dieser Liste dürfen <u>nicht</u> in der <i>#pgv_lang[INDI_FACTS_UNIQUE]#</i> Liste vorkommen.  D.h., jedes Faktum darf in nur einer Liste vorkommen.";
$pgv_lang["INDI_FACTS_UNIQUE"] 			= "Einmal vorkommende Personen-Fakte";
$pgv_lang["INDI_FACTS_UNIQUE_help"]		= "~#pgv_lang[INDI_FACTS_UNIQUE]#~<br /><br />Diese Liste enthält alle Fakte die im Personen-Datensatz nur <u>einmal</u> vorkommen dürfen.  Z.B., wenn BIRT hier eingegeben ist, darf jeder Personen-Datensatz nur eine BIRT Zeile enthalten. Fakt-Codes dieser Liste dürfen <u>nicht</u> in der <i>#pgv_lang[INDI_FACTS_ADD]#</i> Liste vorkommen.  D.h., jedes Faktum darf in nur einer Liste vorkommen.";
$pgv_lang["INDI_FACTS_QUICK"] 			= "Schnell hinzugefügte Personen-Fakte";
$pgv_lang["INDI_FACTS_QUICK_help"]		= "~#pgv_lang[INDI_FACTS_QUICK]#~<br /><br />Diese Liste, die neben der kompletten Fakten-Liste gezeigt wird, bestimmt welche Fakte durch Klicken des jeweiligen Links leicht zu dieser Person hinzugefügt werden können.";
$pgv_lang["FAM_FACTS_ADD"] 				= "Fakten zu Familien hinzufügen";
$pgv_lang["FAM_FACTS_ADD_help"]			= "~#pgv_lang[FAM_FACTS_ADD]#~<br /><br />Diese Liste enthält alle Fakte die diesem Familien-Datensatz hinzugefügt werden können.  Sie können diese Liste durch Entfernen oder Hinzufügen von Fakt-Codes nach Ihren Wünschen ändern.  Fakt-Codes dieser Liste dürfen <u>nicht</u> in der <i>#pgv_lang[FAM_FACTS_UNIQUE]#</i> Liste vorkommen.  D.h., jedes Faktum darf in nur einer Liste vorkommen.";
$pgv_lang["FAM_FACTS_UNIQUE"] 			= "Einmal vorkommende Familien-Fakte";
$pgv_lang["FAM_FACTS_UNIQUE_help"]		= "~#pgv_lang[FAM_FACTS_UNIQUE]#~<br /><br />Diese Liste enthält alle Fakte die im Familien-Datensatz nur <u>einmal</u> vorkommen dürfen.  Z.B., wenn MARR hier eingegeben ist, darf jeder Familien-Datensatz nur eine MARR Zeile enthalten. Fakt-Codes dieser Liste dürfen <u>nicht</u> in der <i>#pgv_lang[FAM_FACTS_ADD]#</i> Liste vorkommen.  D.h., jedes Faktum darf in nur einer Liste vorkommen.";
$pgv_lang["FAM_FACTS_QUICK"] 			= "Schnell hinzugefügte Familien-Fakte";
$pgv_lang["FAM_FACTS_QUICK_help"]		= "~#pgv_lang[FAM_FACTS_QUICK]#~<br /><br />Diese Liste, die neben der kompletten Fakt-Liste gezeigt wird, bestimmt welche Fakte durch Klicken des jeweiligen Links leicht zu dieser Familie hinzugefügt werden können.";
$pgv_lang["SOUR_FACTS_ADD"] 			= "Fakten zu Quellen hinzufügen";
$pgv_lang["SOUR_FACTS_ADD_help"]		= "~#pgv_lang[SOUR_FACTS_ADD]#~<br /><br />Diese Liste enthält alle Fakte die diesem Quellen-Datensatz hinzugefügt werden können.  Sie können diese Liste durch Entfernen oder Hinzufügen von Fakt-Codes nach Ihren Wünschen ändern.  Fakt-Codes dieser Liste dürfen <u>nicht</u> in der <i>#pgv_lang[SOUR_FACTS_UNIQUE]#</i> Liste vorkommen.  D.h., jedes Faktum darf in nur einer Liste vorkommen.";
$pgv_lang["SOUR_FACTS_UNIQUE"] 			= "Einmal vorkommende Quellen-Fakte";
$pgv_lang["SOUR_FACTS_UNIQUE_help"]		= "~#pgv_lang[SOUR_FACTS_UNIQUE]#~<br /><br />Diese Liste enthält alle Fakte die im Quellen-Datensatz nur <u>einmal</u> vorkommen dürfen.  Z.B., wenn TITL hier eingegeben ist, darf jeder Quellen-Datensatz nur eine TITL Zeile enthalten. Fakt-Codes dieser Liste dürfen <u>nicht</u> in der <i>#pgv_lang[SOUR_FACTS_ADD]#</i> Liste vorkommen.  D.h., jedes Faktum darf in nur einer Liste vorkommen.";
$pgv_lang["SOUR_FACTS_QUICK"] 			= "Schnell hinzugefügte Quellen-Fakte";
$pgv_lang["SOUR_FACTS_QUICK_help"]		= "~#pgv_lang[SOUR_FACTS_QUICK]#~<br /><br />Diese Liste, die neben der kompletten Fakt-Liste gezeigt wird, bestimmt welche Fakte durch Klicken des jeweiligen Links leicht zu dieser Quelle hinzugefügt werden können.";
$pgv_lang["REPO_FACTS_ADD"] 			= "Fakten zu Archiven hinzufügen";
$pgv_lang["REPO_FACTS_ADD_help"]		= "~#pgv_lang[REPO_FACTS_ADD]#~<br /><br />Diese Liste enthält alle Fakte die diesem Archiv-Datensatz hinzugefügt werden können.  Sie können diese Liste durch Entfernen oder Hinzufügen von Fakt-Codes nach Ihren Wünschen ändern.  Fakt-Codes dieser Liste dürfen <u>nicht</u> in der <i>#pgv_lang[REPO_FACTS_UNIQUE]#</i> Liste vorkommen.  D.h., jedes Faktum darf in nur einer Liste vorkommen.";
$pgv_lang["REPO_FACTS_UNIQUE"] 			= "Einmal vorkommende Archiv-Fakte";
$pgv_lang["REPO_FACTS_UNIQUE_help"]		= "~#pgv_lang[REPO_FACTS_UNIQUE]#~<br /><br />Diese Liste enthält alle Fakte die im Archiv-Datensatz nur <u>einmal</u> vorkommen dürfen.  Z.B., wenn NAME hier eingegeben ist, darf jeder Archiv-Datensatz nur eine NAME Zeile enthalten. Fakt-Codes dieser Liste dürfen <u>nicht</u> in der <i>#pgv_lang[REPO_FACTS_ADD]#</i> Liste vorkommen.  D.h., jedes Faktum darf in nur einer Liste vorkommen.";
$pgv_lang["REPO_FACTS_QUICK"] 			= "Schnell hinzugefügte Archiv-Fakte";
$pgv_lang["REPO_FACTS_QUICK_help"]		= "~#pgv_lang[REPO_FACTS_QUICK]#~<br /><br />Diese Liste, die neben der kompletten Fakt-Liste gezeigt wird, bestimmt welche Fakte durch Klicken des jeweiligen Links leicht zu diesem Archiv hinzugefügt werden können.";
$pgv_lang["LANG_SELECTION_help"]		= "~#pgv_lang[LANG_SELECTION]#~<br /><br />Sie können die Liste der von PhpGedView unterstützten und Benutzern zugängliche Sprachen ändern indem Sie die entsprechenden Boxen ankreuzen.<br /><br />Dasselbe können Sie auch durch das Link <b>#pgv_lang[enable_disable_lang]#</b> im #pgv_lang[admin]# Menü tun.  Hier können Sie auch andere Sprachoptionen ändern, wie zum Beispiel die Flagge, das Datumsformat, oder die Wahl, Nachnamen immer zuerst zeigen.";
$pgv_lang["MEDIA_ID_PREFIX"]			= "Medien ID-Nummer Präfix";
$pgv_lang["MEDIA_ID_PREFIX_help"]		= "~#pgv_lang[MEDIA_ID_PREFIX]#~<br /><br />Jedes neu erstellte Medien-Objekt bekommt automatisch eine neue Identifikations-Nummer mit diesem Präfix.";
$pgv_lang["FAM_ID_PREFIX"]				= "Familien ID-Nummer Präfix";
$pgv_lang["FAM_ID_PREFIX_help"]			= "~#pgv_lang[FAM_ID_PREFIX]#~<br /><br />Jeder neu erstellte Familien-Datensatz bekommt automatisch eine neue Identifikations-Nummer mit diesem Präfix.";
$pgv_lang["QUICK_REQUIRED_FAMFACTS"]	= "Immer im Schnell-Edit Formular zu zeigende Familien-Fakte";
$pgv_lang["QUICK_REQUIRED_FAMFACTS_help"]	= "~#pgv_lang[QUICK_REQUIRED_FAMFACTS]#~<br /><br />Dies ist eine Liste von Komma getrennten Fakten, die immer unter dem Familienordner im Schnell-Edit Formular gezeigt werden sollen, gleich ob solche Einträge schon im Datensatz vorhanden sind oder nicht.  Zum Beispiel, wenn MARR in der Liste vorkommt, werden die Felder für Ehedatum und Eheort immer im Formular gezeigt.";
$pgv_lang["QUICK_ADD_FAMFACTS"]			= "Im Schnell-Edit Formular zu zeigende Familien-Fakte";
$pgv_lang["QUICK_ADD_FAMFACTS_help"]	= "~#pgv_lang[QUICK_ADD_FAMFACTS]#~<br /><br />Dies ist eine Liste von Komma getrennten Fakten, die unter dem Familienordner im Schnell-Edit Formular gezeigt werden sollen.  Nur die Fakten die in dieser Liste vorkommen werden im Formular gezeigt.";
$pgv_lang["QUICK_REQUIRED_FACTS"]		= "Immer im Schnell-Edit Formular zu zeigende Fakte";
$pgv_lang["QUICK_REQUIRED_FACTS_help"]	= "~#pgv_lang[QUICK_REQUIRED_FACTS]#~<br /><br />Dies ist eine Liste von Komma getrennten Fakten, die immer im Schnell-Edit Formular gezeigt werden sollen, gleich ob solche Einträge schon im Datensatz vorhanden sind oder nicht.  Zum Beispiel, wenn BIRT in der Liste vorkommt, werden die Felder für Geburtsdatum und Geburtsort immer im Formular gezeigt.";
$pgv_lang["QUICK_ADD_FACTS"]			= "Im Schnell-Edit Formular zu zeigende Fakte";
$pgv_lang["QUICK_ADD_FACTS_help"]		= "~#pgv_lang[QUICK_ADD_FACTS]#~<br /><br />Dies ist eine Liste von Komma getrennten Fakten, die im Schnell-Edit Formular gezeigt werden sollen.  Nur die Fakten die in dieser Liste vorkommen werden im Formular gezeigt.";
$pgv_lang["SURNAME_TRADITION_help"] 	= "~#pgv_lang[SURNAME_TRADITION]#~<br /><br />Wenn Sie neue Familienmitglieder hinzufügen, kann PhpGedView je nach der gewählten Nachnamenstradition den Nachnamen der neuen Person automatisch ermitteln.<br /><br /><ul><li>Nach der <b>väterlichen</b> Tradition erhalten alle Kinder den Nachnamen des Vaters</li><li>Nach den <b>spanischen</b> und <b>portugiesischen</b> Traditionen erhalten Kinder einen doppelten Nachnamen von beiden Eltern</li><li>Nach der <b>isländischen</b> Tradition erhalten Kinder den väterlichen Vornamen als Nachname, mit Suffix der das Geschlecht des Kindes andeutet.</li><li>In der <b>polnischen</b> Tradition erhalten alle Familienmitglieder den Nachnamen des Vaters. Bei manchen Nachnamen deutet das Suffix das Geschlecht an.  Die Suffixe <i>ski</i>, <i>cki</i>, und <i>dzki</i> bedeuten männliches Geschlecht, und ähnliche Suffixe <i>ska</i>, <i>cka</i>, und <i>dzka</i> bedeuten weibliches Geschlecht.</li></ul>";
$pgv_lang["ADVANCED_NAME_FACTS_help"]	= "~#pgv_lang[ADVANCED_NAME_FACTS]#~<br /><br />Dies ist eine Komma getrennte Liste von Fakten die in dem Bearbeitungsformular für Namen gezeigt werden.  Wenn Sie Alphabete benutzen, die nicht vom lateinischen Alphabet stammen, z.B., die hebräischen, griechischen, russischen, oder arabischen Alphabete, möchten Sie wahrscheinlich Tags wie _HEB, ROM, FONE, usw. dem Formular hinzufügen.  Solche Tags ermöglichen Ihnen, Namen in verschiedenen Alphabeten zu speichern.";
$pgv_lang["ADVANCED_PLAC_FACTS_help"]	= "~#pgv_lang[ADVANCED_PLAC_FACTS]#~<br /><br />Dies ist eine Komma getrennte Liste von Fakten die in dem Bearbeitungsformular für Ortsnamen gezeigt werden.  Wenn Sie Alphabete benutzen, die nicht vom lateinischen Alphabet stammen, z.B., die hebräischen, griechischen, russischen, oder arabischen Alphabete, möchten Sie wahrscheinlich Tags wie _HEB, ROM, FONE, usw. dem Formular hinzufügen.  Solche Tags ermöglichen Ihnen, Ortsnamen in verschiedenen Alphabeten zu speichern.";
$pgv_lang["GEONAMES_KEY"]				= "geonames.org Benutzername";
$pgv_lang["GEONAMES_KEY_help"]			= "~#pgv_lang[GEONAMES_KEY]#~<br /><br />Diese Benutzer-ID ist erforderlich, um auf die kostenlose geonames.org-Datenbank mit geografischen Namen zuzugreifen. Wenn Sie kein gültiges Benutzer-ID angeben, können Sie diese Datenbank nicht durchsuchen.<br /><br />Sie können ein Benutzer-ID von geonames.org auf der <a href='http://www.geonames.org/login' target='_blank'><b>Anmeldeseite von geonames.org</b></a> anfordern.<br /><br />Sie erhalten dann eine E-Mail mit einem Bestätigungslink. Nachdem Sie die E-Mail bestätigt haben, können Sie Ihr Konto für den Webservice auf Ihrer <a href='http://www.geonames.org/manageaccount' target='_blank'><b>Kontoseite</b></a> aktivieren.";
$pgv_lang["GEONAMES_BIAS"]				= "geonames.org Länderbias";
$pgv_lang["GEONAMES_BIAS_help"]			= "~#pgv_lang[GEONAMES_BIAS]#~<br /><br />Normalerweise werden bei der GeoNames-Datenbanksuche die Ergebnisse in alphabetischer Reihenfolge angezeigt, unabhängig vom Land, in dem sich ein Ort befindet. Diese Wahl bestimmt, dass Orte im gewählten Land oben in der Ergebnisliste gemeldet werden sollen.";
$pgv_lang["GEONAMES_BIAS_no_preference"]= "Keine Präferenz";
$pgv_lang["GEOCODE_KEY"]				= "Geocode Server Schlüssel";
$pgv_lang["GEOCODE_KEY_help"]			= "~#pgv_lang[GEOCODE_KEY]#~<br/><br/>Ohne Schlüssel kann die Google Geocode Datenbank nicht durchsucht werden.  Den Schlüssel erhalten Sie in Ihrer <a href='https://developers.google.com/maps/documentation/geocoding/get-api-key' target='_blank'><b>Google Developer Console</b></a>.  Wenn Sie am unteren Seitenrand »Deutsch« wählen, erhalten Sie die deutsche Version dieser Seite.<br/>";
$pgv_lang["AUTO_GENERATE_THUMBS"]		= "Automatisch Miniaturbilder erstellen";
$pgv_lang["AUTO_GENERATE_THUMBS_help"]	= "~#pgv_lang[AUTO_GENERATE_THUMBS]#~<br /><br />Bestimmt ob PhpgedView automatisch fehlende Miniaturbilder erstellen darf oder nicht.  Es ist aber möglich dass Ihr PHP-Betriebssystem die Miniaturbilder-Erstellung nicht unterstützt.";
$pgv_lang["phpinfo_help"]				= "~#pgv_lang[phpinfo]#~<br /><br />Auf dieser Seite finden Sie ausführliche Auskunft über den Server wo PhpGedView sich befindet.  Sie finden dort viele Details über dessen Konfiguration, besonders wie sie die für PhpGedView erforderliche Betriebs-Systeme betreffen.";
$pgv_lang["config_help_help"]			= "~#pgv_lang[config_help]#~<br /><br />Auf dieser Seite sind die Haupt-Themen der Konfigurations-Hilfe von PhpGedView gesammelt.  Wenn Sie möchten, können Sie die Informationen drucken.";
$pgv_lang["more_help_advice"]			= "<b>Mehr Hilfe</b><br />Wenn sie das <b>#pgv_lang[qm]#</b> neben den Elementen klicken, können Sie mehr Hilfe erhalten.";
$pgv_lang["THUMBNAIL_WIDTH"]			= "Breite des erstellten Miniaturbildes";
$pgv_lang["THUMBNAIL_WIDTH_help"]		= "~#pgv_lang[THUMBNAIL_WIDTH]#~<br /><br />Automatisch erstellte Miniaturbilder werden in dieser Breite erstellt.  Die standardmäßige Breite ist 100px.";
$pgv_lang["USE_SILHOUETTE"]				= "Silhouetten verwenden";
$pgv_lang["USE_SILHOUETTE_help"]		= "~#pgv_lang[USE_SILHOUETTE]#~<br /><br />Bestimmt, ob Silhouetten benutzt werden sollen, wenn für die jeweilige Person kein Hauptbild bestimmt ist.  Die Silhouetten richten sich nach dem Geschlecht der Person.<br /><br /><table><tr><td wrap valign=\"middle\">Diese Silhouette könnte benutzt werden, wenn das Geschlecht der Person unbekannt ist:</td><td><img src=\"images/silhouette_unknown.gif\" width=\"40\" alt=\"Silhouette\" title=\"Silhouette\" /></td></tr</table>";
$pgv_lang["SHOW_SOURCES"]				= "Zeige Quellen";
$pgv_lang["SHOW_SOURCES_help"]			= "~#pgv_lang[SHOW_SOURCES]#~<br /><br />Diese Option bestimmt, wem Quellen gezeigt werden dürfen.  Wenn der Benutzer keinen Zugriff zu Quellen hat, fehlt die Quellen-Option im Listen-Menü, und der Quellen-Ordner fehlt dann auch auf der »Persönliche Details« Seite.";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION_help"]	= "~#pgv_lang[REQUIRE_ADMIN_AUTH_REGISTRATION]#~<br /><br />Wenn die Option <b>#pgv_lang[USE_REGISTRATION_MODULE]#</b> auf <b>#pgv_lang[yes]#</b> gestellt ist, bestimmt diese weitere Option ob der Verwalter jeden Benutzerantrag genehmigen muss oder nicht.<br /><br />Die Wahl <b>#pgv_lang[yes]#</b> bestimmt, dass neue Benutzer ihren Antrag erst bestätigen müssen.  Nach dieser Bestätigung muss der Antrag noch vom Verwalter genehmigt werden.  Erst nach der dieser Genehmigung kann der neue Benutzer sich anmelden.<br /><br />Die Wahl <b>#pgv_lang[no]#</b> bestimmt, dass das Kästchen <b>#pgv_lang[verified_by_admin]#</b> automatisch angekreuzt ist, und dass sofort nach der Bestätigung des Anwärters dieser sich anmelden kann.  Die Genehmigung des Verwalters ist also automatisch.";
$pgv_lang["SPLIT_PLACES"]				= "Orte während dem Bearbeiten teilen";
$pgv_lang["SPLIT_PLACES_help"]			= "~#pgv_lang[SPLIT_PLACES]#~<br /><br />Die Wahl <b>#pgv_lang[yes]#</b> bestimmt, dass während dem Bearbeiten Ortsangaben in ihre Bestandteile unterteilt werden.  Zum Beispiel:<br /><ol><li><b>#pgv_lang[no]#</b><br /><u>Ort</u>: Half Moon Bay, San Mateo, California, USA</li><br /><li><b>#pgv_lang[yes]#</b><br /><u>Land</u>: USA<br /><u>Staat</u>: California<br/><u>Kreis</u>: San Mateo<br/><u>Stadt</u>: Half Moon Bay</li></ol>";
$pgv_lang["UNDERLINE_NAME_QUOTES"]		= "Namen zwischen Anführungszeichen (\") unterstreichen";
$pgv_lang["UNDERLINE_NAME_QUOTES_help"]	= "~#pgv_lang[UNDERLINE_NAME_QUOTES]#~<br /><br />Viele Programme zeigen den Rufnamen zwischen Anführungszeichen (<b>\"</b>).  Normalerweise werden solche Rufnamen unterstrichen.<br /><br />Wenn diese Option auf <b>#pgv_lang[yes]#</b> gestellt ist, unterstreicht das Programm alle Namen die zwischen Anführungszeichen eingetragen sind.  Zum Beispiel, der Datenbank-Eintrag 1&nbsp;NAME&nbsp;Gustave&nbsp;\"Jean&nbsp;Paul\"&nbsp;Charles&nbsp;/Wilson/ wird auf dem Bildschirm oder in Berichten so: <b>Gustave&nbsp;<u>Jean&nbsp;Paul</u>&nbsp;Charles&nbsp;Wilson</b> oder so: <b>Wilson,&nbsp;Gustave&nbsp;<u>Jean&nbsp;Paul</u>&nbsp;Charles</b>&nbsp;gezeigt.";
$pgv_lang["PRIVACY_BY_RESN"]			= "Datenschutz je GEDCOM (RESN) benutzen";
$pgv_lang["PRIVACY_BY_RESN_help"]		= "~#pgv_lang[PRIVACY_BY_RESN]#~<br /><br />Im GEDCOM 5.5.1 Standard befindet sich eine Option wodurch RESN Einträge die Privatsphäre von Personen und Fakten andeuten.  Wenn diese Option auf <b>#pgv_lang[yes]#</b> gestellt ist, prüft das Programm jeden Datensatz der Datenbank nach niveau 1 RESN Zeilen.  Solche Zeilen beeinflussen den Datenschutz von Personen, Familien, and Quellen.  Datensätze werden immer nach niveau 2+ RESN Zeilen, die den Datenschutz von Fakten beeinflussen, geprüft.  Wenn diese Option auf <b>#pgv_lang[yes]#</b> gestellt ist, kann das Programm eventuell etwas langsamer laufen.";
$pgv_lang["SHOW_LDS_AT_GLANCE"]			= "Ordinanz-Codes der HLT-Kirche in Boxen zeigen";
$pgv_lang["SHOW_LDS_AT_GLANCE_help"]	= "~#pgv_lang[SHOW_LDS_AT_GLANCE]#~<br /><br />Wenn diese Option auf <b>#pgv_lang[yes]#</b> gestellt ist, wird der Stand der HLT-Ordinanzen als Codes gezeigt.<ul><li><b>B</b> - Taufe</li><li><b>E</b> - Stiftung</li><li><b>S</b> - Ehepartner-Siegelung</li><li><b>P</b> - Kindes-Siegelung</li></ul>Das Code <b>BESP</b> bedeutet, dass diese Person alle vier HLT Ordinanzen durchgeführt hat.  Fehlende Ordinanzen werden durch <b>_</b> angedeutet.  Zm Beispiel, das Code <b>BE__</b> deutet an, dass die <b>S</b> und <b>P</b> Ordinanzen noch nicht durchgeführt sind.";
$pgv_lang["GEDCOM_DEFAULT_TAB"]			= "Auf der »Persönliche Details« Seite zu zeigender Standard-Ordner";
$pgv_lang["GEDCOM_DEFAULT_TAB_help"]	= "~#pgv_lang[GEDCOM_DEFAULT_TAB]#~<br /><br />Diese Option gibt Ihnen die Möglichkeit, den Ordner zu wählen, der zuerst auf der »Persönliche Details« Seite gezeigt wird.";
$pgv_lang["SHOW_MARRIED_NAMES"]			= "Ehenamen in der Personenliste zeigen";
$pgv_lang["SHOW_MARRIED_NAMES_help"]	= "~#pgv_lang[SHOW_MARRIED_NAMES]#~<br /><br />Wenn diese Option auf <b>#pgv_lang[yes]#</b> gestellt ist, werden Ehenamen in Personenlisten gezeigt.  Solche Ehenamen müssen aber im voraus berechnet werden.";
$pgv_lang["SHOW_QUICK_RESN"]			= "Datenschutz-Felder im #pgv_lang[quick_update_title]# Formular zeigen";
$pgv_lang["SHOW_QUICK_RESN_help"]		= "~#pgv_lang[SHOW_QUICK_RESN]#~<br /><br />Diese Option ermöglicht Ihnen, die Datenschutz-Felder im #pgv_lang[quick_update_title]# Formular ein- oder auszuschalten.  Wenn diese Felder eingeschaltet sind, kann jeder editierender Benutzer die Standard-Datenschutzeinstellung der einzelnen Fakten außer Kraft stellen.";
$pgv_lang["USE_QUICK_UPDATE"]			= "#pgv_lang[quick_update_title]# Formular benutzen";
$pgv_lang["USE_QUICK_UPDATE_help"]		= "~#pgv_lang[USE_QUICK_UPDATE]#~<br /><br />Diese Option bestimmt die Benutzer-Rechte, die erforderlich sind, um das #pgv_lang[quick_update_title]# Formular für Änderungen in der Datenbank benutzen zu können.<br /><br />Die Wahl <b>#pgv_lang[nobody]#</b> bedeutet dass das Formular niemals benutzt werden darf.";
$pgv_lang["SEARCHLOG_CREATE"]			= "SearchLog-Dateien archivieren";
$pgv_lang["SEARCHLOG_CREATE_help"]		= "~#pgv_lang[SEARCHLOG_CREATE]#~<br /><br />Bestimmt wie oft Searchlog-Dateien archiviert werden sollen.";
$pgv_lang["CHANGELOG_CREATE"]			= "ChangeLog-Dateien archivieren";
$pgv_lang["CHANGELOG_CREATE_help"]		= "~#pgv_lang[SEARCHLOG_CREATE]#~<br /><br />Bestimmt wie oft Changelog-Dateien archiviert werden sollen.";
$pgv_lang["CHART_BOX_TAGS"]				= "Andere auf Diagrammen zu zeigende Fakte";
$pgv_lang["CHART_BOX_TAGS_help"]		= "~#pgv_lang[CHART_BOX_TAGS]#~<br /><br />Diese Liste, dessen Einträge durch Komma oder Leerzeichen getrennt sind, bestimmt die Fakten die in Boxen in Diagrammen auftreten dürfen.  Alle Einträge in dieser Liste müssen Fakten, wie sie im GEDCOM 5.5.1 Standard bestimmt sind, sein.  Zum Beispiel, falls der Beruf der Person in dessen Box zu zeigen ist, muss dieses Feld den Eintrag »OCCU« enthalten.";
$pgv_lang["FULL_SOURCES"]				= "Vollständige Quellen-Zitate benutzen";
$pgv_lang["FULL_SOURCES_help"]			= "~#pgv_lang[FULL_SOURCES]#~<br /><br />Quellen-Zitate können Felder enthalten, die die Qualität der Daten oder das Datum des Eintrages in der Quelle beschreiben.  Wenn Sie solche Felder nicht benutzen, können Sie sie in neuen Quellen-Zitaten verbergen.";
$pgv_lang["PREFER_LEVEL2_SOURCES"]		= "Quellen-Zitatentyp";
$pgv_lang["PREFER_LEVEL2_SOURCES_help"]	= "~#pgv_lang[PREFER_LEVEL2_SOURCES]#~<br /><br />Wenn Sie neue nahe Verwandte in die Datenbank eintragen, können Sie auch Quellen-Zitate den Datensätzen (INDI, FAM) hinzufügen.  Quellen-Zitate können auch den verschiedenen Fakten (BIRT, MARR, DEAT) hinzugefügt werden.  Diese Option bestimmt die ursprünglich angekreuzten Boxen.";


//-- CONFIGURE FILE MESSAGES
$pgv_lang["gedcom_conf"]				= "GEDCOM Grundlagen";
$pgv_lang["media_conf"]					= "Multimedia";
$pgv_lang["media_general_conf"]			= "Allgemeines";
$pgv_lang["media_firewall_conf"]		= "Medien-Feuerwand";
$pgv_lang["accpriv_conf"]				= "Zugang und Privatsphäre";
$pgv_lang["displ_conf"]					= "Bildschirm, Layout, und Berichte";
$pgv_lang["displ_names_conf"]			= "Namen";
$pgv_lang["displ_comsurn_conf"] 		= "Häufigste Familiennamen";
$pgv_lang["displ_layout_conf"]			= "Layout";
$pgv_lang["displ_hide_conf"]			= "Verbergen und Zeigen";
$pgv_lang["displ_reports"]				= "Berichte";
$pgv_lang["editopt_conf"]				= "Bearbeitungsoptionen";
$pgv_lang["useropt_conf"]				= "Benutzer Optionen";
$pgv_lang["contact_conf"]				= "Kontakt Information";
$pgv_lang["meta_conf"]					= "Konfiguration und META Tags";
$pgv_lang["gedconf_head"]				= "GEDCOM Konfiguration";
$pgv_lang["other_theme"]				= "Anderes Darstellungsthema. Bitte Verzeichnis eingeben.";
$pgv_lang["performing_update"]			= "Aktualisierung wird durchgeführt.";
$pgv_lang["config_file_read"]			= "Konfigurationsdatei wurde gelesen.";
$pgv_lang["does_not_exist"]				= "existiert nicht";
$pgv_lang["media_drive_letter"]			= "Der Pfad zur Medien-Datei sollte keinen Laufwerksbuchstaben enthalten. Diese Datei kann sonst eventuell nicht dargestellt werden.";
$pgv_lang["db_setup_bad"]				= "Ihre aktuelle Datenbank-Konfiguration ist unzulässig. Bitte überprüfen Sie ihre Datenbankverbindungsparameter und konfigurieren Sie diese erneut.";
$pgv_lang["bad_host_user_pass"]			= "PhpGedView konnte keine Verbindung zu Ihrem Datenbank Host aufbauen. Überprüfen Sie bitte den Host, Benutzernamen und Kennwort.";
$pgv_lang["bad_database_name"]			= "PhpGedView hat eine Verbindung zu Ihrem Datenbank Host hergestellt, konnte aber den von Ihnen angegebenen Datenbanknamen nicht verwenden. Bitte prüfen Sie, dass diese Datenbank existiert und dass der angegebene Benutzername die notwendigen Zugriffsrechte hat.";
$pgv_lang["db"]							= "Datenbank";
$pgv_lang["current_gedcoms"]			= "Vorhandene GEDCOMs";
$pgv_lang["ged_gedcom"]					= "GEDCOM-Datei";
$pgv_lang["ged_title"]					= "GEDCOM Bezeichnung";
$pgv_lang["ged_config"]					= "Konfigurations-Datei";
$pgv_lang["ged_search"]					= "SearchLog-Dateien";
$pgv_lang["ged_change"]					= "ChangeLog-Dateien";
$pgv_lang["ged_privacy"]				= "Datenschutzdatei";
$pgv_lang["disabled"]					= "Deaktiviert";
$pgv_lang["mouseover"]					= "Bei »Mouse Over«";
$pgv_lang["mousedown"]					= "Bei »Mouse Button Down«";
$pgv_lang["click"]						= "Bei »Mouse Button Click«";
$pgv_lang["enter_db_pass"]				= "Aus Sicherheitsgründen müssen Sie immer #pgv_lang[DBUSER]# und #pgv_lang[DBPASS]# eingeben, wenn Sie die Konfiguration ändern.";
$pgv_lang["server_url_note"]			= "Geben Sie das URL zu Ihrem PhpGedView-Ordner an. Sie sollten diesen Wert nur ändern, wenn Sie die Bedeutung verstehen. PhpGedView hat das SERVER_URL wie folgt ermittelt: #GUESS_URL#";

$pgv_lang["DBTYPE"]						= "Datenbank-Typ";
$pgv_lang["DBTYPE_help"]		= "~#pgv_lang[DBTYPE]#~<br /><br />Der Typ der Datenbank die benutzt werden soll.<br /><br />PhpGedView kann jede beliebige Datenbank benutzen, sofern sie durch einem PDO-Treiber unterstützt ist.  Sie müssen sicher sein, dass die php.ini Datei passende Zeilen enthält, die das Laden der PDO-Bibliothek und des Treibers des zu benutzenden Datenbanktyps (z.B. <b>php_pdo_mysql</b>) befehlen.<br /><br />Die meisten Datenbanken benötigen einen Nutzernamen und das dazu passende Kennwort.  Sie müssen auch die Datenbank erstellen, bevor Sie das PhpGedView Programm zum ersten Mal benutzen können. Im Gegenteil zu anderen Datenbanken, erfordert SQLite nicht die Eingaben #pgv_lang[DBHOST]#, #pgv_lang[DBUSER]#, und #pgv_lang[DBPASS]#, aber Sie müssen den Pfad zu Ihrer Datenbank im #pgv_lang[DBNAME]# Feld eingeben.  PhpGedView kann die SQLite Datenbank für Sie erstellen.";
$pgv_lang["DBHOST"]						= "Datenbank-Host";
$pgv_lang["DBHOST_help"]				= "~#pgv_lang[DBHOST]#~<br /><br />Die DNS- oder IP-Adresse Ihres Datenbank-Servers.  Bei SQLite Datenbanken hat dieses Feld keine Bedeutung.";
$pgv_lang["DBPORT"]						= "Datenbank Port";
$pgv_lang["DBPORT_help"]				= "~#pgv_lang[DBPORT]#~<br /><br />Das TCP Protokoll, das benutzt werden soll, um eine Verbindung zum Datenbank-Server herzustellen.  Lassen Sie dieses Feld leer, um das standardmäßige Protokoll zu benutzen.  Bei SQLite Datenbanken hat dieses Feld keine Bedeutung.";
$pgv_lang["DBUSER"]						= "Datenbank-Benutzername";
$pgv_lang["DBUSER_help"]				= "~#pgv_lang[DBUSER]#~<br /><br />Der Benutzername der benötigt wird, um eine Verbindung zu Ihrer Datenbank herzustellen. Bei SQLite Datenbanken hat dieses Feld keine Bedeutung.";
$pgv_lang["DBPASS"]						= "Datenbank-Kennwort";
$pgv_lang["DBPASS_help"]				= "~#pgv_lang[DBPASS]#~<br /><br />Das Kennwort das für den oben von Ihnen angegebenen Benutzernamen benötigt wird, um eine Verbindung zu Ihrer Datenbank herzustellen. Bei SQLite Datenbanken hat dieses Feld keine Bedeutung.";
$pgv_lang["DBNAME"]						= "Datenbank-Name";
$pgv_lang["DBNAME_help"]				= "~#pgv_lang[DBNAME]#~<br /><br />Die Datenbank auf Ihrem Server, die Sie mit PhpGedView nutzen möchten.<br /><br />Der Benutzername aus dem #pgv_lang[DBUSER]# feld muss über Generierungs-, Einfügungs-, Update-, Lösch- und Auswahlrechte innerhalb dieser Datenbank verfügen. In SQLite müssen Sie einen Dateinamen in einem von PHP beschreibbaren Ordner eingeben, z. B. der Index Ordner (index/phpgedview.db).";
$pgv_lang["TBLPREFIX_help"]				= "~#pgv_lang[TBLPREFIX]#~<br /><br />Ein Präfix der an die Tabellennamen angehängt wird, die von PhpGedView erstellt werden. Durch Ändern dieses Wertes können Sie mehrere PhpGedView-Sites unterstützen, die die gleiche Datenbank jedoch unterschiedliche Tabellen benutzen.";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"]	= "~#pgv_lang[ALLOW_CHANGE_GEDCOM]#~<br /><br />Die Einstellung <b>#pgv_lang[yes]#</b> erlaubt den Besuchern <b>und</b> angemeldeten Benutzern die verwendete GEDCOM-Datei selbst zu wählen, sofern Ihre Konfiguration mehrere GEDCOM-Dateien unterstützt.<br /><br />Bei Einstellung <b>#pgv_lang[no]#</b>, können <b>weder</b> Besucher, <b>noch</b> angemeldete Benutzer die GEDCOM-Datei wählen.";
$pgv_lang["upload_path"]				= "Pfad zur hochzuladenden Datei";
$pgv_lang["upload_path_help"]			= "~#pgv_lang[upload_path]#~<br /><br />Der Pfad auf Ihrem lokalen Rechner, wo die GEDCOM-Datei, die Sie hochladen möchten, sich befindet.  Um den Pfad und den Dateinamen einzugeben, clicken Sie den <b>Browse</b> Button.  Nachdem Sie die richtige GEDCOM-Datei gefunden haben, clicken Sie den <b>Open</b> Button.";
$pgv_lang["gedcom_path"]				= "Server-Pfad und Name der GEDCOM-Datei";
$pgv_lang["gedcom_path_help"]		= "~#pgv_lang[gedcom_path]#~<br /><br />Es gibt zwei Möglichkeiten, eine GEDCOM-Datei in PhpGedView zu importieren. Sie sind:<ol><li>Ein FTP-Programm verwenden, mit dem die Datei auf den Server hochgeladen werden kann</li><li>Mit PhpGedView hochladen</li></ol>Wenn die Datei bereits auf dem Server vorhanden ist, aktivieren Sie die Prozedur <i>#pgv_lang[add_gedcom]#</i> und geben den Pfad und den Namen der GEDCOM-Datei ein, wie sie auf dem Server vorhanden sind. Der Name kann mit oder ohne Suffix sein. Wenn kein Suffix angegeben ist, wird .ged angenommen. Der Pfad ist optional. Wenn kein Pfad angegeben wird, wird der Wert der Option <i>#pgv_lang[INDEX_DIRECTORY]#</i> verwendet, wie in der Konfiguration der PhpGedView-Site festgelegt. Bitte beachten Sie, dass bei den meisten Servern bei Datei- und Pfadnamen die Groß- und Kleinschreibung beachtet wird.<br /><br />Wenn Sie die PhpGedView Prozedur <i>#pgv_lang[upload_gedcom]#</i> aktivieren, können Sie mit dem Button <b>Durchsuchen</b> die gewünschte Datei auf dem lokalen Computer suchen. Dies kann eine normale GEDCOM-Datei oder eine ZIP-Datei sein, die die GEDCOM-Datei enthält. PhpGedView extrahiert automatisch die in dieser ZIP-Datei enthaltene GEDCOM-Datei und verwendet sie dann.<br /><br />Beim Hochladen einer Datei kann ein alternativer Pfad und / oder Dateiname angegeben werden, unter dem sie auf dem Server gespeichert werden soll.<br /><br />Weitere Informationen finden Sie in der Datei <a href=\"readme.txt\">Readme.txt</a>.";
$pgv_lang["CHARACTER_SET"]				= "Kodierung der Schriftzeichen";
$pgv_lang["CHARACTER_SET_help"]			= "~#pgv_lang[CHARACTER_SET]#~<br /><br />Dies ist die Bezeichnung für die Kodierung, mit der Sie Ihre GEDCOM-Datei gespeichert haben. UTF-8 ist die Standardeinstellung  und sollte auf fast allen Websites funktionieren. Falls Sie ihre GEDCOM-Datei mit IBM-Windows Kodierung exportiert haben, sollten Sie hier WINDOWS angeben.<br /><br />HINWEIS: PhpGedView kann UNICODE (UTF-16) nicht unterstützen, da die erforderliche Unterstützung in PHP fehlt.";
$pgv_lang["LANGUAGE"]					= "Sprache";
$pgv_lang["LANGUAGE_help"]		= "~#pgv_lang[LANGUAGE]#~<br /><br />Bestimmen Sie die Standardsprache für Ausgaben dieser Site.<br /><br />Wenn die Option <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b> auf <b>#pgv_lang[yes]#</b> konfiguriert ist, können Benutzer diese Einstellung durch die »Bevorzugte Sprachkonfiguration« ihres Browsers oder durch entsprechenden Eintrag ihrer Kontoseite oder mit Hilfe von Links auf den meisten PhpGedView-Seiten ändern."; 
$pgv_lang["ENABLE_MULTI_LANGUAGE"]		= "Besuchern den Sprachwechsel erlauben";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"]	= "~#pgv_lang[ENABLE_MULTI_LANGUAGE]#~<br /><br /><b>#pgv_lang[yes]#</b> erlaubt den Wechsel der Standardsprache. Benutzer können diese Einstellung durch die »Bevorzugte Sprachkonfiguration« ihres Browsers oder durch entsprechenden Eintrag ihrer Kontoseite oder mit Hilfe von Links auf den meisten PhpGedView-Seiten ändern.";
$pgv_lang["CALENDAR_FORMAT"]			= "Kalender Format";
$pgv_lang["CALENDAR_FORMAT_help"]	= "~#pgv_lang[CALENDAR_FORMAT]#~<br /><br />Daten können in verschiedenen Kalender-Systemen wie Gregorianisch, Julianisch, oder Jüdisch aufgezeichnet werden. Mit dieser Option können Sie Datumsangaben in einen bevorzugten Kalender konvertieren. Sie können beispielsweise Gregorianisch wählen, um julianische und hebräische Daten in Gregorianisch umzuwandeln. Das konvertierte Datum wird in Klammern hinter dem Original-Datum gezeigt.<br /><br />Daten werden nur konvertiert, wenn sie für den Kalender gültig sind. Beispielsweise werden nur Daten zwischen 22&nbsp;SEP&nbsp;1792 und 31&nbsp;DEC&nbsp;1805 in den französischen republikanischen Kalender konvertiert, und nur Daten nach 15&nbsp;OCT&nbsp;1582 werden in den gregorianischen Kalender konvertiert.<br /><br />Das Hebräische System ist das gleiche wie das Jüdische System, aber mit Hebräischen Schriftzeichen.  Das Arabische System ist das gleiche wie das Hijri-System, aber mit Arabischen Schriftzeichen.<br /><br />Bitte beachten Sie:  Im Jüdischen und Hijri Kalendersystem fängt der neue Tag nach Sonnenuntergang an.  Ereignisse, die zwischen Sonnenuntergang und Mitternacht statt finden, werden deshalb nach der Übersetzung einen Tag früher als erwartet gezeigt.  Sie sollten außerdem auch beachten, dass manche Browser die Arabischen und Hebräischen Schriftzeichen in falscher Richtung oder überhaupt nicht zeigen.";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"]	= "Hebräische Tausender zeigen";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"]	= "~#pgv_lang[DISPLAY_JEWISH_THOUSANDS]#~<br /><br />Alafim in Hebräischen Kalendern zeigen.<br /><br />Bei <b>#pgv_lang[yes]#</b> wird das Jahr 1969 als <span lang=\"he-IL\" dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; gezeigt, während es bei <b>#pgv_lang[no]#</b> als <span lang=\"he-IL\" dir='rtl'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; gezeigt wird. Dies hat keinen Einfluss auf die Jüdische Jahreseinstellung. Das Jahr wird als 5729 gezeigt, unabhängig von dieser Einstellung.<br /><br />Bitte beachten: Diese Einstellung entspricht dem Kalenderkonstanten CAL_JEWISH_ADD_ALAFIM.";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]	= "Hebräische Gershayim zeigen";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"]	= "~#pgv_lang[DISPLAY_JEWISH_GERESHAYIM]#~<br /><br />Einfache und doppelte Hochkommata (»'« und »\"«) in Hebräischen Daten zeigen.<br /><br />Bei <b>#pgv_lang[yes]#</b> wird der 8. Februar 1969 als <span lang='he-IL' dir='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; gezeigt, bei <b>#pgv_lang[no]#</b> als <span lang='he-IL' dir='rtl'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;. Dies hat keinen Einfluss auf das jüdische Jahr, da Hochkommata in jüdischen Daten, die mit lateinischen Zeichen gezeigt werden, nicht verwendet werden.<br /><br />Hinweis: Diese Einstellung ähnelt den Kalenderkonstanten CAL_JEWISH_ADD_ALAFIM_GERESH und CAL_JEWISH_ADD_GERESHAYIM. Diese einzelne Einstellung wirkt sich auf beide aus.";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"]	= "Jüdische Ashkenaz Schreibweise benutzen";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"]	= "~#pgv_lang[JEWISH_ASHKENAZ_PRONUNCIATION]#~<br /><br />Bei <b>#pgv_lang[yes]#</b> werden die Monate Cheshvan und Teves der Ashkenazi Schreibweise verwendet. Bei <b>#pgv_lang[no]#</b> werden diese Monate als Hesvan und Tevet angezeigt.<br /><br />Dies beeinflusst nur die Jüdische Einstellung. Im Hebräischen wird immer das Hebräische Alphabet benutzt.";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"]	= "Standardmäßige Anzahl Generationen im Stammbaum";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"]	= "~#pgv_lang[DEFAULT_PEDIGREE_GENERATIONS]#~<br /><br />Bestimmt die Anzahl standardmäßig dargestellter Generationen, die in Nachfahrenbaum- und Stammbaum-Darstellungen gezeigt werden.";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"]	= "Maximale Anzahl Generationen im Stammbaum";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"]	= "~#pgv_lang[MAX_PEDIGREE_GENERATIONS]#~<br /><br />Ändert die Anzahl der Generationen, die maximal in der Stammbaum Ansicht gezeigt werden.";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"]	= "Maximale Anzahl Generationen im Nachfahrenbaum";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"]	= "~#pgv_lang[MAX_DESCENDANCY_GENERATIONS]#~<br /><br />Ändert die Anzahl der Generationen, die maximal im Nachfahrenbaum gezeigt werden.";
$pgv_lang["SOSA_WIDTH_NORMAL"]		= "Normale Breite der SOSA-Nummern";
$pgv_lang["SOSA_WIDTH_NORMAL_help"]	= "~#pgv_lang[SOSA_WIDTH_NORMAL]#~<br /><br />Wie viel Platz für SOSA-Nummern in Diagrammen reserviert werden soll<br /><br /><b>#pgv_lang[variable]#</b> gibt an, dass die Breite nicht festgelegt ist und die gedruckte SOSA-Nummer genauso viel Platz benutzt wie sie braucht. Der Rest des Diagramms wird entsprechend positioniert.";
$pgv_lang["SOSA_WIDTH_WIDE"]		= "Zusätzliche Breite der SOSA-Nummern";
$pgv_lang["SOSA_WIDTH_WIDE_help"]	= "~#pgv_lang[SOSA_WIDTH_WIDE]#~<br /><br />Wie viel Platz für SOSA-Nummern in der Broschürenansicht der Nachfahrentabelle reserviert werden soll<br /><br /><b>#pgv_lang[variable]#</b> gibt an, dass die Breite nicht festgelegt ist und die gedruckte SOSA-Nummer genauso viel Platz benutzt wie sie braucht. Der Rest des Diagramms wird entsprechend positioniert.";
$pgv_lang["USE_RIN"]					= "RIN# anstelle von GEDCOM ID verwenden";
$pgv_lang["USE_RIN_help"]				= "~#pgv_lang[USE_RIN]#~<br /><br />Bei <b>#pgv_lang[yes]#</b> wird die RIN Nummer anstelle der GEDCOM ID verwendet, wenn in Konfigurationen, Benutzer-Einstellungen und Diagrammen nach Personen gefragt wird. Dies ist hilfreich für Genealogie Software die GEDCOM-Dateien nicht mit einheitlichen IDs aber immer mit der gleichen RIN für Personen exportiert.";
$pgv_lang["GENERATE_GUID"]				= "Global einmalig vorkommende ID-Nummern erstellen";
$pgv_lang["GENERATE_GUID_help"]			= "~#pgv_lang[GENERATE_GUID]#~<br /><br />In diesem Zusammenhang ist <b>GUID</b> ein Akronym für »Globally Unique ID«.<br /><br />Solche Nummern sollen Personen so identifizieren, dass jede Person immer die gleiche Nummer erhält.  Das hat zum Zweck dass zentrale Behörden, wie zum Beispiel der Familiengeschichtliches Zentrum der HLT-Kirche in Salt Lake City, oder sogar andere Programme die auf Ihrem Computer laufen, bestimmen können dass sie die gleiche Person behandeln, gleich der Ursprung der GEDCOM-Datei.  Eines der Ziele des Family History Centers ist eine einzige genealogische Datenbank, die über das Internet zugreifbar ist, und worin jedes Programm Zugriff zu den Daten hat, und worin jedes Programm auch seine eigene Daten ergänzen kann.<br /><br />Falls Sie Ihre Datenbank nicht mit Anderen tauschen wollen, ist es nicht notwending, dass PhpGedView solche ID-Nummern erstellt.  Es ist auch nicht falsch, dass PhpGedView diese Nummern immer erstellt.";
$pgv_lang["PEDIGREE_ROOT_ID"]			= "ID-Nummer der Startperson für Stammbaum und Nachfahrenbaum";
$pgv_lang["PEDIGREE_ROOT_ID_help"]		= "~#pgv_lang[PEDIGREE_ROOT_ID]#~<br /><br />Bestimmt die ID der Person, die standardmäßig als Startperson in der Stammbaum- und Nachfahrenbaum-Darstellung verwendet wird.";
$pgv_lang["GEDCOM_ID_PREFIX"]			= "Personen ID-Nummer Präfix";
$pgv_lang["GEDCOM_ID_PREFIX_help"]		= "~#pgv_lang[GEDCOM_ID_PREFIX]#~<br /><br />Jeder neu erstellte Personen-Datensatz bekommt automatisch eine neue Identifikations-Nummer mit diesem Präfix.";
$pgv_lang["SOURCE_ID_PREFIX"]			= "Quellen ID-Nummer Präfix";
$pgv_lang["SOURCE_ID_PREFIX_help"]		= "~#pgv_lang[SOURCE_ID_PREFIX]#~<br /><br />Jeder neu erstellte Quellen-Datensatz bekommt automatisch eine neue Identifikations-Nummer mit diesem Präfix.";
$pgv_lang["REPO_ID_PREFIX"]				= "Archiv ID-Nummer Präfix";
$pgv_lang["REPO_ID_PREFIX_help"]		= "~#pgv_lang[REPO_ID_PREFIX]#~<br /><br />Jeder neu erstellte Archiv-Datensatz bekommt automatisch eine neue Identifikations-Nummer mit diesem Präfix.";
$pgv_lang["PEDIGREE_FULL_DETAILS"]		= "Geburts- und Todesdetails in Diagrammen zeigen";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"]	= "~#pgv_lang[PEDIGREE_FULL_DETAILS]#~<br /><br />Diese Option bestimmt, ob die Einzelheiten der Geburts- und Sterbedaten in Diagrammen gezeigt werden oder nicht.";
$pgv_lang["PEDIGREE_SHOW_GENDER"]		= "Geschlecht mittels Ikon in Diagrammen zeigen";
$pgv_lang["PEDIGREE_SHOW_GENDER_help"]	= "~#pgv_lang[PEDIGREE_SHOW_GENDER]#~<br /><br />Diese Option bestimmt, ob das Geschlecht der Person mittels Ikon in Diagrammen gezeigt wird oder nicht.<br /><br />Da das Geschlecht auch durch die Farbe der Box angedeutet ist, verbirgt diese Option das Geschlecht nicht.  Diese Option verbirgt nur doppelte Information.";
$pgv_lang["PEDIGREE_LAYOUT"]			= "Standard Stammbaum Layout";
$pgv_lang["PEDIGREE_LAYOUT_help"]		= "~#pgv_lang[PEDIGREE_LAYOUT]#~<br /><br />Hier bestimmen Sie, ob der Stammbaum im Hochformat oder Querformat dargestellt werden soll.";
$pgv_lang["SHOW_EMPTY_BOXES"]			= "Leere Boxen im Stammbaum zeigen";
$pgv_lang["SHOW_EMPTY_BOXES_help"]		= "~#pgv_lang[SHOW_EMPTY_BOXES]#~<br /><br />Diese Option bestimmt, ob leere Boxen im Stammbaum gezeigt werden sollen.";
$pgv_lang["ZOOM_BOXES"]					= "Boxen in Diagrammen zoombar";
$pgv_lang["ZOOM_BOXES_help"]			= "~#pgv_lang[ZOOM_BOXES]#~<br /><br />Erlaubt dem Besucher in Boxen eines Diagramms für mehr Informationen hineinzuzoomen. Auf <b>#pgv_lang[disabled]#</b> stellen, um dieses Feature abzuschalten. Auf <b>#pgv_lang[mouseover]#</b> stellen, um den Zoom beim Überfahren des Ikons mit der Maus auszulösen. Auf <b>#pgv_lang[click]#</b> stellen, um den Zoom durch Klicken des Ikons auszulösen.";
$pgv_lang["LINK_ICONS"]					= "Links in Diagrammen zeigen";
$pgv_lang["LINK_ICONS_help"]			= "~#pgv_lang[LINK_ICONS]#~<br /><br />Erlaubt die Wahl von Links zu anderen Diagrammen und zu nahen Verwandten einer Person.<br /><br />Auf <b>#pgv_lang[disabled]#</b stellen, um dieses Feature abzuschalten. Auf <b>#pgv_lang[mouseover]#</b> stellen, um die Links zu zeigen, wenn der Benutzer mit der Maus über das Symbol in der Personen-Box fährt. Auf <b>#pgv_lang[click]#</b> stellen, um die Links durch Klicken des Symbols zu zeigen.";
$pgv_lang["ABBREVIATE_CHART_LABELS"]	= "Bezeichnungen in Diagrammen abkürzen";
$pgv_lang["ABBREVIATE_CHART_LABELS_help"]	= "~#pgv_lang[ABBREVIATE_CHART_LABELS]#~<br /><br />Bestimmt, ob in den Diagrammen Bezeichnungen wie <b>Geburt</b> nur mit ihrem Anfangsbuchstaben <b>G</b> abgekürzt werden.<br /><br />Sie können Ihre eigenen Abkürzungen durch entspechende Einträge in der <i>languages/extra.xx.php</i> Datei für jede Sprache bestimmen.  Zum Beispiel, wenn Sie in der deutschen Sprache das Zeichen <b>*</b> als Abkürzung für den BIRT Fakt benutzen möchten, müssen Sie folgende Zeile in die <i>languages/extra.de.php</i> Datei einfügen:<br /><code>\$factAbbrev[\"BIRT\"]&nbsp;=&nbsp;\"*\";</code><br /><br />Die Längen solcher Abkürzungen sind nicht auf ein Zeichen oder Buchstaben beschränkt.";
$pgv_lang["SHOW_AGE_DIFF"]				= "Datendifferenzen zeigen";
$pgv_lang["SHOW_AGE_DIFF_help"]			= "~#pgv_lang[SHOW_AGE_DIFF]#~<br /><br />Diese Option bestimmt, ob der »Direkte Verwandtschaft« Ordner der »»Persönliche Details«« Seite Differenzen zwischen Geburtsdaten der Gatten, zwischen Ehedatum und Geburtsdatum des ersten Kindes, und zwischen Geburtsdaten der Geschwister zeigen soll oder nicht.";
$pgv_lang["SHOW_PARENTS_AGE"]			= "Alter der Eltern bei der Geburt eines Kindes zeigen";
$pgv_lang["SHOW_PARENTS_AGE_help"]		= "~#pgv_lang[SHOW_PARENTS_AGE]#~<br /><br />Diese Option bestimmt, ob das Alter der Eltern neben dem Geburtsdatum des Kindes zu zeigen ist.";
$pgv_lang["SHOW_RELATIVES_EVENTS"]		= "Ereignisse naher Verwandten auf der »Persönliche Details« Seite zeigen";
$pgv_lang["SHOW_RELATIVES_EVENTS_help"]	= "~#pgv_lang[SHOW_RELATIVES_EVENTS]#~<br /><br />Geburten, Ehen, und Tode von Verwandten sind für jede Person wichtige Ereignisse.  Diese Option bestimmt, ob solche Ereignisse im »Persönliche Fakten und Details« Ordner der »Persönliche Details« Seite zu zeigen sind.<br /><br />Die betroffenen Ereignisse sind folgende:<ul><li>Tod des Ehepartners</li><li>Geburt und Tod der Kinder</li><li>Tod der Eltern</li><li>Geburt und Tod der Geschwister</li><li>Tod der Großeltern</li><li>Geburt und Tod von Onkeln und Tanten</li></ul>";
$pgv_lang["EXPAND_RELATIVES_EVENTS"]	= "Ereignis-Liste naher Verwandten automatisch erweitern";
$pgv_lang["EXPAND_RELATIVES_EVENTS_help"]	= "~#pgv_lang[EXPAND_RELATIVES_EVENTS]#~<br /><br />Diese Option bestimmt, ob die Liste der Ereignisse naher Verwandten im »Persönliche Fakten und Details« Ordner der »Persönliche Details« Seite zu zeigen sind.<br /><br />Die betroffenen Ereignisse sind fo Seite automatisch erweitert werden soll oder nicht.";
$pgv_lang["EXPAND_SOURCES"]				= "Quellenangaben automatisch erweitern";
$pgv_lang["EXPAND_SOURCES_help"]		= "~#pgv_lang[EXPAND_SOURCES]#~<br /><br />Diese Option bestimmt, ob der Inhalt von Quellenangaben auf der »Persönliche Details« Seite automatisch gezeigt werden soll oder nicht.";
$pgv_lang["EXPAND_NOTES"]				= "Bemerkungen automatisch erweitern";
$pgv_lang["EXPAND_NOTES_help"]			= "~#pgv_lang[EXPAND_NOTES]#~<br /><br />Diese Option bestimmt, ob der Inhalt von Bemerkungen auf der »Persönliche Details« Seite automatisch gezeigt werden soll oder nicht.";
$pgv_lang["SHOW_LEVEL2_NOTES"]      	= "Alle Bemerkungen und Quellenangaben im »Bemerkungen« oder »Quellen« Ordner zeigen";
$pgv_lang["SHOW_LEVEL2_NOTES_help"] 	= "~#pgv_lang[SHOW_LEVEL2_NOTES]#~<br /><br />Diese Option bestimmt, ob Bemerkungen und Quellenangaben die mit Fakten verbunden sind, in den »Bemerkungen« und »Quellen« Ordnern der »Persönliche Details« Seite gezeigt werden sollen oder nicht.<br /><br />Gewöhnlich zeigen diese Ordner nur direkt mit dem Datensatz verbundene Bemerkungen und Quellenangaben.  Solche befinden sich auf der <i>Ebene 1</i> des Datensatzes.<br /><br />Die Wahl <b>#pgv_lang[yes]#</b> bestimmt, dass auch mit Fakten verbundene Bemerkungen und Quellenangaben gezeigt werden sollen.  Solche befinden sich auf der <i>Ebene 2</i> des Datensatzes, da Fakte zur Ebene 1 gehören.";
$pgv_lang["HIDE_LIVE_PEOPLE"]			= "Lebende Personen verbergen";
$pgv_lang["HIDE_LIVE_PEOPLE_help"]	= "~#pgv_lang[HIDE_LIVE_PEOPLE]#~<br /><br />Diese Option aktiviert alle Datenschutzeinstellungen und verbirgt die Details lebender Personen.<br /><br />Unter lebenden Personen versteht man Personen, deren Ereignisse nicht aktueller sind als die in <b>#pgv_lang[MAX_ALIVE_AGE]#</b> angegebene Anzahl von Jahren, die derzeit <b>#GLOBALS[MAX_ALIVE_AGE]#</b> ist. Zu diesem Zweck werden auch Geburten von Kindern als solche Ereignisse angesehen.";
$pgv_lang["REQUIRE_AUTHENTICATION"]		= "Besucher Login notwendig";
$pgv_lang["REQUIRE_AUTHENTICATION_help"]	= "~#pgv_lang[REQUIRE_AUTHENTICATION]#~<br /><br />Wenn diese Einstellung aktiv ist, muss sich ein Besucher erst anmelden, bevor ihm irgendwelche Daten dieser Seite gezeigt werden.";
$pgv_lang["PAGE_AFTER_LOGIN"]			= "Nach dem Anmelden zu zeigende Seite";
$pgv_lang["PAGE_AFTER_LOGIN_help"]		= "~#pgv_lang[PAGE_AFTER_LOGIN]#~<br /><br />Welche Seite soll dem Nutzer nach dessen Anmeldung gezeigt werden?<br /><br />Ihre Wahl bestimmt, ob nach dem Anmelden von der #pgv_lang[welcome_page]# die Begrüßungs- oder die MyGedView-Seite gezeigt wird.<br /><br />Wenn der Nutzer sich von einer anderen Seite anmeldet, kehrt er dahin zurück.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"]		= "Begrüßungstext auf der Login-Seite";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE]#~<br /><br />Hier können Sie einen Text wählen, der auf der Login-Seite erscheint. Bitte prüfen Sie welcher vordefinierte Text am geeignesten ist.<br /><br />Sie können auch Ihren eigenen Willkommens-Text erstellen, aber dieser wird nicht in die anderen Sprachen übersetzt, es sei denn, dass Ihr Text Verweise auf Sprach-Variable enthält, die Sie in die verschiedenen <i>languages/extra.xx.php</i> Sprach-Dateien eingegeben haben.  Sie können im Hilfe-Text des <b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#</b> Feldes mehr darüber erfahren.<br /><br />Die vordefinierten Texte lauten:<ul><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT1]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_1]#</div><br/></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT2]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_2]#</div><br/></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT3]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_3]#</div></li></ul>";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT0"]	= "Kein vordefinierter Text";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"]	= "Vordefinierter Text, der erklärt, dass alle Benutzer einen Zugang beantragen können";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"]	= "Vordefinierter Text, der erklärt, dass der Verwalter über den Zugangs-Antrag entscheidet";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"]	= "Vordefinierter Text, der erklärt, dass nur Familienmitglieder einen Zugang beantragen dürfen";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"]	= "Selbsterstellter Text wie unten angegeben";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"]	= "Selbsterstellter Text";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#~<br /><br />Wenn Sie im vorigen Feld »Selbsterstellter Text« gewählt haben, können Sie hier diesen Text eingeben. Der Text wird NICHT in andere Sprachen übersetzt sondern erscheint für alle Benutzer nur in der Sprache, in der Sie ihn eintragen.  Trotzdem, falls Ihre Eingabe Verweise auf Sprach-Variable enthält, die Sie in den verschiedenen <i>languages/extra.xx.php</i> Dateien eingegeben haben, kann der Text unter Umständen übersetzt werden.<br /><br />Sie können im Text HTML-Tags verwenden.<br /><br />Die folgende Beschreibung, enthalten im Hilfe-Text über FAQ-Listen, ist ebenso für den selbsterstellen Text gültig.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"]	= "Standard Einleitung für selbsterstellten Text";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST_HEAD]#~<br /><br />Wählen Sie, ob ein mehrsprachiger Kopf für Ihren selbsterstellten Willkommens-Text gezeigt werden soll.<br /><br />Wenn Sie <b>#pgv_lang[yes]#</b> wählen, wird folgender Kopf angezeigt:<div class=\"list_value_wrap\">#pgv_lang[welcome_text_cust_head]#</div>";
$pgv_lang["SHOW_REGISTER_CAUTION"]		= "Bedingungen auf der »Benutzer Antrag« Seite zeigen";
$pgv_lang["SHOW_REGISTER_CAUTION_help"]	= "~#pgv_lang[SHOW_REGISTER_CAUTION]#~<br /><br />Wenn Sie <b>#pgv_lang[yes]#</b> wählen, wird folgende Notiz als Überschrift auf der <i>#pgv_lang[requestaccount]#</i> Seite gezeigt:<div class=\"list_value_wrap\">#pgv_lang[acceptable_use]#</div>";
$pgv_lang["CHECK_CHILD_DATES"]			= "Daten der Kinder überprüfen";
$pgv_lang["CHECK_CHILD_DATES_help"]		= "~#pgv_lang[CHECK_CHILD_DATES]#~<br /><br />Überprüft die Daten der Kinder, um zu bestimmen, ob die Person schon verstorben ist oder nicht. Falls sich Ihre Website auf einem älteren Server befindet und Sie eine große Datenbank haben, kann die Einstellung <b>#pgv_lang[yes]#</b> zur Folge haben, dass die Antwortzeit Ihres Servers verzögert wird.";
$pgv_lang["MAX_ALIVE_AGE"]				= "Alter, ab dem angenommen wird, dass die Person verstorben ist";
$pgv_lang["MAX_ALIVE_AGE_help"]		= "~#pgv_lang[MAX_ALIVE_AGE]#~<br /><br />Wenn diese Person andere Ereignisse als Tod, Bestattung oder Einäscherung in jüngerer Zeit als diese Anzahl von Jahren hat, wird sie als »lebend« angesehen. Geburtsdaten von Kindern gelten zu diesem Zweck als solche Ereignisse.";
$pgv_lang["SHOW_GEDCOM_RECORD"]			= "Besuchern erlauben die GEDCOM-Roh-Daten anzusehen";
$pgv_lang["SHOW_GEDCOM_RECORD_help"]	= "~#pgv_lang[SHOW_GEDCOM_RECORD]#~<br /><br />Bei <b>#pgv_lang[yes]#</b> wird eine Link auf den Seiten von Personen, Quellen und Familien eingefügt, das ein neues Fenster mit den Roh-Daten der GEDCOM-Datei öffnet.";
$pgv_lang["ALLOW_EDIT_GEDCOM"]			= "Online Editieren erlauben";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"]		= "~#pgv_lang[ALLOW_EDIT_GEDCOM]#~<br /><br />Ermöglicht das Online Editieren für diese GEDCOM-Datei, mittels dessen Besucher mit Edit-Rechten die GEDCOM-Datei online verändern können.";
$pgv_lang["ENABLE_AUTOCOMPLETE"]		= "Automatische Eingabe benutzen";
$pgv_lang["ENABLE_AUTOCOMPLETE_help"]	= "~#pgv_lang[ENABLE_AUTOCOMPLETE]#~<br /><br />Diese Option bestimmt, ob die automatische Texteingabe in bestimmten Feldern aktiviert werden soll oder nicht.  Mit der Wahl <b>#pgv_lang[yes]#</b> haben Felder, worin die automatische Texteingabe möglich ist, einen anderen Hintergrund als normale Textfelder.<br /><br />Wenn die automatische Texteingabe aktiviert ist, durchsucht das Programm die Datenbank nach passenden Texten.  Je mehr Text Sie engeben, desto genauer wird die Liste der in diesem Feld möglichen Eingaben.  Wenn der gewünschte Text sich in der Liste befindet, können Sie einfach darauf mit der linken Maustaste klicken um die Eingabe damit zu beenden.<br /><br />Die automatische Eingabe hat zum Nachteil dass das Programm langsamer läuft, und dass dem Browser viel mehr Daten übertragen werden.";
$pgv_lang["USE_REFN"]		= "Referenznummer verwenden";
$pgv_lang["USE_REFN_help"]	= "~#pgv_lang[USE_REFN]#~<br /><br />Diese Option bestimmt, ob das in den Details einer <u>neuen</u> Person eingegebene #factarray[REFN]# als ID-Nummer für diese neue Person verwendet werden soll.<br /><br />Wenn diese Option auf <b>#pgv_lang[yes]#</b> gesetzt ist, muss die eingegebene #factarray[REFN]# den für alle ID-Nummern festgelegten Regeln folgen, und eine Person mit dieser ID darf nicht bereits in der Datenbank vorhanden sein. Wenn diese Bedingungen nicht erfüllt sind oder wenn diese Option auf <b>#pgv_lang[no]#</b> gesetzt ist, weist PhpGedView dieser neuen Person automatisch die nächste verfügbare ID-Nummer zu.<br /><br />Gültige ID-Nummern dürfen nur die Buchstaben <b>A</b> bis <b>Z</b>, <b>a</b> bis <b>z</b>, die Ziffern <b>0</b> bis <b>9</b>, und die besonderen Symbole <b>. : -</b> und <b>_</b> enthalten.<br /><br />Sie müssen auch das Zeigen der #factarray[REFN]# aktivieren, indem Sie den Eintrag <b>REFN</b> den Konfigurationsoptionen <b>#pgv_lang[INDI_FACTS_UNIQUE]#</b>, <b>#pgv_lang[INDI_FACTS_QUICK]#</b> und <b>#pgv_lang[QUICK_REQUIRED_FACTS]#</b> (unten) hinzufügen.";
$pgv_lang["EDIT_AUTOCLOSE"]				= "Editier-Fenster automatisch schließen";
$pgv_lang["EDIT_AUTOCLOSE_help"]		= "~#pgv_lang[EDIT_AUTOCLOSE]#~<br /><br />Diese Option bestimmt, ob das Editier-Fenster nach erfolgreichem Bearbeiten automatisch geschlossen werden soll oder nicht.";
$pgv_lang["INDEX_DIRECTORY_help"]	= "~#pgv_lang[INDEX_DIRECTORY]#~<br /><br />Der Pfad zu einem lesbaren und beschreibbaren Ordner, in dem PhpGedView Index-Dateien speichern soll (einschließlich des nachfolgenden »/«). Der Name dieses Ordners darf anders als »index« sein. Sie können einen beliebigen Namen wählen.<br /><br />Aus Sicherheitsgründen sollte dieser Ordner an einer Stelle im Dateibereich des Servers abgelegt werden, auf die über das Internet nicht zugegriffen werden kann. Ein Beispiel für eine solche Struktur folgt:<br /><b>PhpGedView:</b> dir1/dir2/dir3/PhpGedView<br /><b>Index:</b> dir1/dir4/dir5/dir6/index<br /><br />Für das gezeigte Beispiel würden Sie hier <b>../../dir4/dir5/dir6/index/</b> eingeben.";
$pgv_lang["POSTAL_CODE"]				= "Position der Postleitzahl";
$pgv_lang["POSTAL_CODE_help"] 			= "~#pgv_lang[POSTAL_CODE]#~<br /><br />Es gibt viele verschiedene Adressen-Darstellungen.  Diese Option bestimmt, ob die Postleitzahl vor oder nach dem Ortsnamen gezeigt wird.";
$pgv_lang["SUBLIST_TRIGGER_I"]			= "Maximale Nachnamen";
$pgv_lang["SUBLIST_TRIGGER_I_help"]		= "~#pgv_lang[SUBLIST_TRIGGER_I]#~<br /><br />Lange Listen von Personen mit gleichem Nachnamen können nach dem Anfangsbuchstaben dessen Vornamen in kleinere Listen aufgeteilt werden.<br /><br />Mit dieser Option geben Sie die maximale Nachnamens-Listenlänge ein.  Wenn Sie diese Länge auf Null stellen, werden Nachnamenslisten nie in kleinere Listen aufgeteilt.";
$pgv_lang["SUBLIST_TRIGGER_F"]			= "Maximale Familiennamen";
$pgv_lang["SUBLIST_TRIGGER_F_help"]		= "~#pgv_lang[SUBLIST_TRIGGER_F]#~<br /><br />Lange Listen von Familien mit gleichem Namen können nach dem Anfangsbuchstaben dessen Vornamen in kleinere Listen aufgeteilt werden.<br /><br />Mit dieser Option geben Sie die maximale Familiennamens-Listenlänge ein.  Wenn Sie diese Länge auf Null stellen, werden Familiennamenslisten nie in kleinere Listen aufgeteilt.";
$pgv_lang["SURNAME_LIST_STYLE"]			= "Darstellung der Nachnamenslisten";
$pgv_lang["SURNAME_LIST_STYLE_help"]	= "~#pgv_lang[SURNAME_LIST_STYLE]#~<br /><br />Nachnamen, wie sie im #pgv_lang[block_top10]# Block, in der #pgv_lang[individual_list]#, und in der #pgv_lang[family_list]# erscheinen, können verschieden dargestellt werden.<ul><li><b>#pgv_lang[style2]#</b>&nbsp;&nbsp;&nbsp;In dieser Darstellung sind Nachnamen in einer Tabelle aufgezeichnet.  Diese Tabelle kann entweder nach den Namen oder nach deren Anzahl sortiert werden.</li><li><b>#pgv_lang[style3]#</b>&nbsp;&nbsp;&nbsp;In dieser Darstellung sind Nachnamen in einer Liste aufgezeichnet.  Die Größe der Namen hängt von deren Anzahl in der Datenbank ab.  Je öfter der Name vorkommt, desto größer ist seine Darstellung.  Die Liste kann nicht sortiert werden.</li></ul>";
$pgv_lang["SHOW_ID_NUMBERS_help"]		= "~#pgv_lang[SHOW_ID_NUMBERS]#~<br /><br />Anzeige der ID Nummern in Klammern hinter den Personen-Namen in Diagrammen.";
$pgv_lang["SHOW_LAST_CHANGE"]			= "Letztes Ändergungsdatum in Listen zeigen";
$pgv_lang["SHOW_LAST_CHANGE_help"]		= "~#pgv_lang[SHOW_LAST_CHANGE]#~<br /><br />Diese Option bestimmt, ob das letzte Änderungsdatum in Listen gezeigt werden soll.";
$pgv_lang["SHOW_EST_LIST_DATES"]		= "Geschätzte Geburts- und Todesdaten zeigen";
$pgv_lang["SHOW_EST_LIST_DATES_help"]	= "~#pgv_lang[SHOW_EST_LIST_DATES]#~<br /><br />Diese Option bestimmt, ob geschätzte Daten für Geburten und Tode in Listen gezeigt werden. Wenn nicht, bleiben unbekannte Daten leer.";
$pgv_lang["SHOW_PEDIGREE_PLACES"]		= "Anzahl der gezeigten Ebenen der hierarchischen Orts-Angaben";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"]	= "~#pgv_lang[SHOW_PEDIGREE_PLACES]#~<br /><br />Hier bestimmen Sie, wie viele Informationen zu den Orts-Angaben in den Personen-Boxen in Diagrammen gezeigt werden. Die Einstellung »9« sorgt für vollständige Orts-Angaben. Die Einstellung »0« (Null) unterdrückt die Orts-Angabe komplett. Die Einstellung »1« zeigt nur eine Ebene, die Einstellung »2« zeigt die ersten beiden Ebenen usw. (bezieht sich auf die Unterteilung durch Kommata, z.B. Bonn, Rheinland-Pfalz, Deutschland).";
$pgv_lang["pageSizeDefault"]			= "Standard-Seitengröße";
$pgv_lang["pageSizeDefault_help"]		= "~#pgv_lang[pageSizeDefault]#~<br /><br />Dies ist die Standardseitengröße für alle Berichte. Ihre Wahl kann in den einzelnen Berichten überschrieben werden.";
$pgv_lang["pageSizeOptions"]			= "Seitengrößen";
$pgv_lang["pageSizeOptions_help"]		= "~#pgv_lang[pageSizeOptions]#~<br /><br />Dies ist die Liste der Seitengrößen, die derzeit von PhpGedView beim Generieren von Berichten unterstützt werden. Sie können diese Liste erweitern, indem Sie andere Seitengrößen hinzufügen, die im <a href='https://de.wikipedia.org/wiki/Papierformat' title='Wikipedia Artikel' target='_blank'><b>Wikipedia Artikel</b></a> aufgeführt sind.<br /><ul><li>Die Seitengröße für den größten Teil der Welt ist <b>A4</b>, was 210 x 297 mm (8,5 x 11,0 Zo.) entspricht.</li><li>Die nordamerikanische Seitengröße ist <b>letter</b>, was 216 x 279 mm (8,5 x 11,0 Zo.) entspricht.</li><li>Andere verfügbare Größen sind <b>A3</b>, was 297 x 420 mm (11,7 x 16,5 Zo.) entspricht,</li><li>und <b>legal</b>, was 216 x 356 mm (8,5 x 14,0 Zo.) entspricht.</li></ul><br />Vorsicht ist geraten, wenn Sie andere Papierformate als die in der ISO-Liste »A« aufgeführten hinzufügen. Nicht alle ISO-Größen sind getestet.";
$pgv_lang["fontsDefault"]				= "Standardschriftart";
$pgv_lang["fontsDefault_help"]			= "~#pgv_lang[fontsDefault]#~<br /><br />Dies ist die Standardschriftart für alle Berichte. Ihre Wahl kann in den einzelnen Berichten überschrieben werden.";
$pgv_lang["fontsOptions"]				= "Schriftarten";
$pgv_lang["fontsOptions_help"]			= "~#pgv_lang[fontsOptions]#~<br /><br />Dies ist die Liste der Schriftarten, die derzeit von PhpGedView beim Generieren von Berichten unterstützt werden.<br /><br />Sie können diese Liste nach Bedarf erweitern oder kürzen. Bei der Erweiterung dieser Liste ist Vorsicht geraten. Nicht alle in der Bibliothek <i>includes/tcpdf/fonts</i> vorhandenen Schriftarten sind getestet.";
$pgv_lang["MULTI_MEDIA"]				= "Multimediaunterstützung aktivieren";
$pgv_lang["MULTI_MEDIA_help"]			= "~#pgv_lang[MULTI_MEDIA]#~<br /><br />Die Spezifikation von GEDCOM 5.5.1 erlaubt Hinzufügen von Fotos, Videos und anderen Multimedia-Objekten zur GEDCOM-Datenbank. Falls Sie keine Multimedia-Objekte Ihrer GEDCOM-Datenbank hinzugefügt haben, können Sie die Multimedia-Unterstützung in PhpGedView durch die Wahl <b>#pgv_lang[no]#</b> abschalten.<br /><br />Lesen Sie im Abschnitt »Multimedia« der Datei <a href=\"readme.txt\"><b>readme.txt</b></a>, um mehr darüber zu erfahren, wie Sie Multimedia-Dateien in Ihre Website einfügen können.";
$pgv_lang["MEDIA_EXTERNAL"]				= "Links behalten";
$pgv_lang["MEDIA_EXTERNAL_help"]	= "~#pgv_lang[MEDIA_EXTERNAL]#~<br /><br />Wenn eine Multimedia-Link gefunden wird, die beispielsweise mit http://, ftp://, mms:// beginnt, wird es nicht geändert, wenn die Option auf <b>#pgv_lang[yes]#</b> gesetzt ist. Beispielsweise wird http://www.myfamily.com/photo/dad.jpg unverändert als http://www.myfamily.com/photo/dad.jpg gespeichert. Bei der Einstellung <b>#pgv_lang[no]#</b> wird das Link als Standardreferenz behandelt und die Medientiefe verwendet. Beispiel: http://www.myfamily.com/photo/dad.jpg wird in ./media/dad.jpg geändert";
$pgv_lang["MEDIA_DIRECTORY"]			= "Verzeichnis der Multimedia-Dateien";
$pgv_lang["MEDIA_DIRECTORY_help"]	= "~#pgv_lang[MEDIA_DIRECTORY]#~<br /><br />Der Pfad zu einem lesbaren und beschreibbaren Ordner, in dem PhpGedView Mediendateien speichern soll (einschließlich des nachfolgenden »/«). Der Name dieses Ordners darf anders als »media« sein. Sie können einen beliebigen Namen auswählen.<br /><br />Obwohl die Medien-Feuerwand Ihnen erlaubt, Mediendateien in einem Bereich des Server-Dateibereichs zu speichern, auf den über das Internet nicht zugegriffen werden kann, muss der hier genannte Ordner trozdem vorhanden sein und muss vom Internet lesbar und von PhpGedView beschreibbar sein. Weitere Informationen finden Sie in den Konfigurationsoptionen der Media Firewall im Abschnitt Multimedia auf der GEDCOM-Konfigurationsseite.";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"]		= "Multimedia Verzeichnis-Tiefe";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"]	= "~#pgv_lang[MEDIA_DIRECTORY_LEVELS]#~<br /><br />Ein Wert von 0 (Null) wird alle Unterverzeichnisse im Verzeichnis für Multimedia-Objekte ignorieren. Ein Wert von 1 wird zusätzlich das erste Unterverzeichnis dieses Multimedia-Verzeichnisses beachten. Die Erhöhung dieser Zahl wird die Anzahl der übergeordneten zu überwachenden Verzeichnisse dieses Pfades erhöhen.<br /><br />Ein Beispiel: Wenn Sie innerhalb Ihrer GEDCOM-Datei auf ein Foto mit folgenden Pfad verweisen: C:\\Dokumente und Einstellungen\\BENUTZER\\Eigene Dateien\\Eigene Bilder\\Genealogie\\Nachname\\grossvater.jpg dann wird ein Wert von 0 diesen Pfad folgendermaßen interpretieren: ./media/grossvater.jpg. Ein Wert von 1 jedoch, wird diesen Pfad folgendermaßen interpretieren: ./media/Nachname/grossvater.jpg, usw. Den meisten Verwaltern von PhpGedView wird hier ein eingestellter Wert von 0 ausreichen. Es kann jedoch sein, dass einige Multimedia-Objekte den gleichen Namen haben können und sich somit gegenseitig aufheben. Dieser Wert ermöglicht Ihnen Ihre Multimedia-Objekte zu verwalten, ohne einen Namenskonflikt zu erzeugen.";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"]	= "~#pgv_lang[SHOW_HIGHLIGHT_IMAGES]#~<br /><br />Falls Sie die Darstellung für Multimedia-Dateien auf Ihrer Website aktiviert haben, können Sie PhpGedView veranlassen, neben dem Namen der in den Boxen des Stammbaumes oder Nachfahrenbaumes dargestellten Personen ein Miniaturbild zu zeigen.<br /><br />Lesen Sie im Abschnitt »multimedia« der Datei <a href=\"readme.txt\"><b>readme.txt</b></a>, um mehr darüber zu erfahren, wie Sie Multimedia-Dateien in Ihre Website einfügen können.";
$pgv_lang["USE_THUMBS_MAIN"]			= "Miniaturbilder verwenden";
$pgv_lang["USE_THUMBS_MAIN_help"]		= "~#pgv_lang[USE_THUMBS_MAIN]#~<br /><br />Diese Option bestimmt, ob PhpGedView Miniaturbilder oder Bilder in Original-Größe dem Browser übermitteln soll, wenn das Format der aktuellen Seite Miniaturbilder erfordert.<br /><br />Die Wahl <b>#pgv_lang[no]#</b> verursacht, dass PhpGedView Bilder in Original-Größe übermittelt, während die Wahl <b>#pgv_lang[yes]#</b> bestimmt, dass Miniaturbilder verwendet werden.  Jedes Bild hat auch die »#factarray[_THUM]#« Option, die, falls auf <b>#pgv_lang[yes]#</b> gestellt ist, verursacht dass immer das Bild in Original-Größe übermittelt wird, ohne Rücksicht auf die Einstellung der »#pgv_lang[USE_THUMBS_MAIN]#« Option der GEDCOM-Konfiguration.  Es ist nicht möglich, PhpGedView zu veranlassen, Miniaturbilder zu übermitteln wenn die GEDCOM-Konfiguration bestimmt, dass immer große Bilder verwendet werden sollen.<br /><br />PhpGedView ändert niemals die Größe der übermittelten Bilder; das geschieht im Browser nachdem er das Bild und die Beschreibung der zu darstellenden Seite empfangen hat.  Es besteht immer die Möglichkeit, dass die dargestellte Seite falsch aussieht, wenn das übermittelte Miniaturbild zu groß ist.  Dies ist kein Fehler:  Es kann durchaus vorkommen, dass der Verwalter manchmal ein großes Bild zeigen möchte, wo man normalerweise ein Miniaturbild erwartet.<br /><br />Sie sollten vermeiden, die »#pgv_lang[USE_THUMBS_MAIN]#« Option auf <b>#pgv_lang[no]#</b> zu stellen.  Diese Wahl verursacht die Übermittlung großer Dateien, wovon die meisten Daten nachher vom Browser verworfen werden müssen.  Das Laden von Diagrammen mit vielen Bildern wird so unnötig verzögert.";
$pgv_lang["SHOW_MEDIA_FILENAME"]		= "Diabetrachter erlauben, Dateinamen zu zeigen";
$pgv_lang["SHOW_MEDIA_FILENAME_help"]	= "~#pgv_lang[SHOW_MEDIA_FILENAME]#~<br /><br />Der Diabetrachter kann den Namen der aktuellen Medien-Datei zeigen.<br /><br />Möglicherweise möchten Sie den Dateinamen aus Sicherheitsgründen verbergen.";
$pgv_lang["SHOW_MEDIA_DOWNLOAD"]		= "Diabetrachter erlauben, Download-Links zu zeigen";
$pgv_lang["SHOW_MEDIA_DOWNLOAD_help"]	= "~#pgv_lang[SHOW_MEDIA_DOWNLOAD]#~<br /><br />Der Diabetrachter kann ein Link zeigen, das eine Übertragung der aktuellen Medien-Datei ermöglicht.<br /><br />Möglicherweise möchten Sie das Download-Link aus Sicherheitsgründen verbergen.";
$pgv_lang["ENABLE_CLIPPINGS_CART"]		= "Ausschnittssammelbehäter aktivieren";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"]	= "~#pgv_lang[ENABLE_CLIPPINGS_CART]#~<br /><br />Der Ausschnittssammelbehälter ermöglicht Besuchern Ihrer Website Datensätze zu gewählten Personen aus der gesamten Datenbank in eine neue GEDCOM-Datei zu exportieren, die diese dann auf ihren Computer übertragen (downloaden) können, um diese Datensätze in ihr eigenes Genealogie-Programm zu importieren.";
$pgv_lang["HIDE_GEDCOM_ERRORS"]			= "GEDCOM-Fehler verbergen";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"]	= "~#pgv_lang[HIDE_GEDCOM_ERRORS]#~<br /><br />Bei <b>#pgv_lang[yes]#</b> werden keine Fehlermeldungen von PhpGedView dargestellt. Solche Fehler können entstehen, wenn PhpGedView eine Anweisung innerhalb der von Ihnen gewählten GEDCOM-Datenbank nicht interpretieren kann. PhpGedView wurde so programmiert, dass möglichst alle Anweisungen des GEDCOM 5.5.1 Standards unterstützt werden. Jedoch verwenden einige Genealogie-Programme ihre eigenen Anweisungen (Tags). Schauen Sie in die Datei <a href=\"readme.txt\"><b>readme.txt</b></a> um mehr hierüber zu erfahren.";
$pgv_lang["WORD_WRAPPED_NOTES"]			= "Leerzeichen an umgebrochene Notizinformationen anfügen";
$pgv_lang["WORD_WRAPPED_NOTES_help"]	= "~#pgv_lang[WORD_WRAPPED_NOTES]#~<br /><br />Manche Genealogie-Programme kappen die Notizen zu Datensätzen am Ende von ganzen Wörtern, während andere an einer beliebigen Stelle des Textes einen Zeilenumbruch einfügen. Dies kann PhpGedView veranlassen, Wörter zusammenzufügen, ohne ein Leerzeichen zwischen diese zu setzen. Bei <b>#pgv_lang[yes]#</b> wird PhpGedView bei der Ausgabe von Notizen ein Leerzeichen zwischen zwei Wörter einfügen, die durch einen Zeilenumbruch getrennt wurden.";
$pgv_lang["SHOW_CONTEXT_HELP"]			= "Hilfe-Links standardmäßig zeigen";
$pgv_lang["SHOW_CONTEXT_HELP_help"]		= "~#pgv_lang[SHOW_CONTEXT_HELP]#~<br /><br />Diese Option aktiviert Fragezeichen als Hilfe-Links auf den Seiten, die Besucher klicken können, um einen Hilfe-Text für die jeweilige Funktion gezeigt zu bekommen.";
$pgv_lang["DAYS_TO_SHOW_LIMIT"]			= "Tageslimit des »Bevorstehende Ereignisse« Blocks";
$pgv_lang["DAYS_TO_SHOW_LIMIT_help"]	= "~#pgv_lang[DAYS_TO_SHOW_LIMIT]#~<br /><br />Hier bestimmen Sie, wie weit in die Zukunft der Block »Bevorstehende Ereignisse« die Datenbank nach betreffenden Ereignissen durchsuchen soll.  Die Resultate dieser Suche, die nur einmal am Tag läuft, werden in eine Datei kopiert.<br /><br />Sie können maximal <b>30</b> eingeben, und kein »Bevorstehende Ereignisse« Block kann mehr als diese Anzahl anfordern.  Je höher Ihre Eingabe, desto länger dauert die Durchsuche Ihrer Datenbank.";
$pgv_lang["COMMON_NAMES_THRESHOLD"]		= "Mindestanzahl eines Nachnamens, der in der Liste der häufigsten Nachnamen erscheinen soll";
$pgv_lang["COMMON_NAMES_THRESHOLD_help"]	= "~#pgv_lang[COMMON_NAMES_THRESHOLD]#~<br /><br />Dies ist die Anzahl, wie oft ein Nachname vorkommen muss, damit er in der Liste der häufigsten Nachnamen genannt wird.";
$pgv_lang["COMMON_NAMES_ADD"]			= "Namen, die zu der Liste der häufigsten Nachnamen hinzugefügt werden sollen.";
$pgv_lang["COMMON_NAMES_ADD_help"]		= "~#pgv_lang[COMMON_NAMES_ADD]#~<br /><br />Wenn ein Name nicht genügend oft vorkommt, erscheint er nicht in der Liste der häufigsten Nachnamen. Hier können Sie solche Namen manuell zur Liste hinzufügen. Wenn Sie mehrere Namen angeben, trennen Sie diese jeweils durch ein Komma. <b>Bitte beachten Sie die Groß- und Kleinschreibung.</b>";
$pgv_lang["COMMON_NAMES_REMOVE"]		= "Namen, die aus der Liste der häufigsten Nachnamen entfernt werden sollen";
$pgv_lang["COMMON_NAMES_REMOVE_help"]	= "~#pgv_lang[COMMON_NAMES_REMOVE]#~<br /><br />Wenn Sie einen Nachnamen aus der Liste der häufigsten Nachnamen entfernen möchten, ohne den Grenzwert für die Anzahl des Vorkommens verändern zu wollen, können Sie den Namen hier eingeben. Wenn Sie mehrere Namen angeben, trennen Sie diese jeweils durch ein Komma. <b>Bitte beachten Sie die Groß- und Kleinschreibung.</b> Hier eingegebene Nachnamen werden ebenfalls aus der Top-10-Liste auf der Begrüßungsseite entfernt.";
$pgv_lang["HOME_SITE_URL"]				= "URL der Hauptseite der WebSite";
$pgv_lang["HOME_SITE_URL_help"]			= "~#pgv_lang[HOME_SITE_URL]#~<br /><br />Eine URL die in den Kopfbereich des gewählten Darstellungsthemas hinzugefügt wird, um ein Link zur Startseite Ihrer Homepage zu erstellen.";
$pgv_lang["HOME_SITE_TEXT"]				= "Text für Hauptseite der WebSite";
$pgv_lang["HOME_SITE_TEXT_help"]		= "~#pgv_lang[HOME_SITE_TEXT]#~<br /><br />Textausgabe für das Link, die zur Startseite Ihrer Homepage verweist.";
$pgv_lang["CONTACT_EMAIL"]				= "Kontakt Mail-Adresse für genealogische Fragen";
$pgv_lang["CONTACT_EMAIL_help"]			= "~#pgv_lang[CONTACT_EMAIL]#~<br /><br />Die Person die Besucher kontaktieren sollen, falls sie Fragen zu den genealogischen Daten der Website haben.";
$pgv_lang["CONTACT_METHOD"]				= "Kontakt Methode";
$pgv_lang["CONTACT_METHOD_help"]	= "~#pgv_lang[CONTACT_METHOD]#~<br /><br />Die Methode, mit der Besucher sich bei genealogischen Fragen an #pgv_lang[CONTACT_EMAIL]# wenden können.#pgv_lang[CONTACT_METHOD_desc]#";
$pgv_lang["CONTACT_METHOD_desc"] = "<ul><li>Die Option <b>#pgv_lang[mailto]#</b> verursacht ein »mailto« Link, auf die geklickt werden kann, um eine E-Mail mit dem Mail-Programm des Computers des Benutzers zu senden.</li><li>Die Option <b>#pgv_lang[messaging]#</b> verwendet ein in PhpGedView internes Nachrichtensystem, und es werden keine E-Mails gesendet.</li><li><b>#pgv_lang[messaging2]#</b> ist die Standardeinstellung. Das PhpGedView-Nachrichtensystem wird verwendet, und Kopien der Nachrichten werden auch per E-Mail gesendet.</li><li><b>#pgv_lang[messaging3]#</b> veranlasst PhpGedView die Nachrichten selbst als E-Mails zu senden, aber die Nachrichten nicht intern zu speichern. Diese Option ähnelt der Option <b>#pgv_lang[mailto]#</b>, außer dass die Nachricht von PhpGedView an Stelle des Computers des Benutzers gesendet wird.</li><li>Die Option <b>#pgv_lang[no_messaging]#</b> führt dazu, dass Ihre Benutzer keine Möglichkeit haben, Sie zu kontaktieren.</li></ul>";
$pgv_lang["PHPGEDVIEW_EMAIL"]			= "Mail Antwort-Adresse";
$pgv_lang["PHPGEDVIEW_EMAIL_help"]		= "~#pgv_lang[PHPGEDVIEW_EMAIL]#~<br /><br />Die Mail-Adresse, die für das »Absender:« Feld von automatisch erstellten Mails benutzt werden soll.<br /><br />PhpGedView erstellt automatische Mails, die Verwalter darauf aufmerksam machen, dass Änderungen gemacht wurden, und dass diese noch kontrolliert werden müssen.  Automatische Mails werden auch erstellt, wenn neue Benutzer einen Zugriffsantrag gemacht haben.<br /><br />Das »Absender:« Feld dieser automatischen Mails ähnelt gewöhnlich <i>Abs: phpgedview-noreply@yoursite</i> und das bedeutet dass keine Antwort erwartet ist.  Um gültige Mails zu erkennen, erfordern manche Mail-Systeme dass jede Mail-Nachricht eine gültige Absender-Adresse hat.  Diese Mail-Systeme erkennen also keine Mails vom Absender <i>phpgedview-noreply</i> als gültig.";
$pgv_lang["WEBMASTER_EMAIL"]		= "Unterstützungs-Kontakt";
$pgv_lang["WEBMASTER_EMAIL_help"]		= "~#pgv_lang[WEBMASTER_EMAIL]#~<br /><br />Die Person die Besucher kontaktieren sollen, falls sie technische Fragen haben oder Fehler auf Ihrer Website finden und diese Ihnen mitteilen möchten.";
$pgv_lang["SUPPORT_METHOD"]				= "Support Kontakt Methode";
$pgv_lang["SUPPORT_METHOD_help"]	= "~#pgv_lang[SUPPORT_METHOD]#~<br /><br />Die Methode, mit der Besucher sich bei technischen Fragen an #pgv_lang[WEBMASTER_EMAIL]# wenden können.#pgv_lang[CONTACT_METHOD_desc]#";
$pgv_lang["SHOW_FACT_ICONS"] 			= "Fakt-Ikone zeigen";
$pgv_lang["SHOW_FACT_ICONS_help"]		= "~#pgv_lang[SHOW_FACT_ICONS]#~<br /><br />Die Wahl <b>#pgv_lang[yes]#</b> bedeutet dass PhpGedView Fakt-Ikone auf der »Persönliche Details« Seite zeigen soll.  Diese Ikone werden nur gezeigt, wenn sie im Verzeichnis <i>images/facts</i> der aktuellen Theme vorhanden sind.";
$pgv_lang["FAVICON"]					= "Pfad und Dateiname der FavIcon-Grafik";
$pgv_lang["FAVICON_help"]				= "~#pgv_lang[FAVICON]#~<br /><br />Ändern Sie diesen Wert, um auf das Ikon zu verweisen, das in der Liste der Favoriten/Lesezeichen derjenigen erscheinen, die diese Website zur Liste ihrer Favoriten/Lesezeichen hinzufügen.";
$pgv_lang["THEME_DIR"]					= "Themen Verzeichnis";
$pgv_lang["THEME_DIR_help"]				= "~#pgv_lang[THEME_DIR]#~<br /><br />Das Verzeichnis in dem Ihr gewünschtes Darstellungsthema für PhpGedView-Seiten abgelegt ist.<br /><br />Sie können ein beliebiges Standardthema, das mit PhpGedView geliefert wurde, so anpassen, dass Ihre Website ein einzigartiges Erscheinungsbild abgibt. Lesen Sie im Abschnitt »customization« der Datei <a href=\"readme.txt\"><b>readme.txt</b></a>, um mehr darüber zu erfahren.";
$pgv_lang["TIME_LIMIT"]					= "PHP Zeitlimit";
$pgv_lang["TIME_LIMIT_help"]			= "~#pgv_lang[TIME_LIMIT]#~<br /><br />Die maximale Laufzeit für das Programm (in Sekunden).<br /><br />Der Standardwert ist 60 Sek.  Wenn Ihre GEDCOM-Datei sehr groß ist, müssen Sie eventuell diesen Wert auch erhöhen, sonst kann möglicherweise dessen Bearbeitung unerwünscht abbrechen.  Der Wert 0 (Null) bedeutet, dass das Programm ohne Unterbrechung laufen darf.<br /><br />VORSICHT: Es ist durchaus möglich, dass der Wert 0 oder ein zu hoher Wert zur Folge hat, dass bei Programmstörungen auf falsch konfigurierten Servern, Ihre Site vom Serversupport neu gestartet werden muss.  Sie sollten diesen Wert so niedrig wie möglich stellen.";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"]	= "~#pgv_lang[PGV_SESSION_SAVE_PATH]#~<br /><br />Der Pfad zum Speichern der »Session«-Dateien. Auf einigen Hosts ist PHP nicht sorgfältig konfiguriert und die Sitzungs-Daten werden zwischen den Seiten-Aufrufen nicht gespeichert. Hier können Sie die Standard-Einstellung überschreiben um ein eigenes lokales Verzeichnis zu verwenden. Ein geeignetes Verzeichnis wäre ./index/, falls eine Änderung notwendig ist. Normalerweise bleibt dieses Feld leer und es wird ein Pfad verwendet, der in der php.ini-Datei eingetragen ist.";
$pgv_lang["SERVER_URL_help"]			= "~#pgv_lang[SERVER_URL]#~<br /><br />Wenn Sie https oder einen anderen Port benutzen, müssen Sie hier die URL eingeben, über die Ihr Server erreicht werden kann.";
$pgv_lang["LOGIN_URL"]			= "Login URL";
$pgv_lang["LOGIN_URL_help"]		= "~#pgv_lang[LOGIN_URL]#~<br /><br />Die Login URL muss nur dann angegeben werden, wenn Sie zu einer anderen Seite umleiten möchten, wenn die Benutzer sich anmelden. Dies ist dann sinnvoll, wenn Sie beim Benutzer-Login z.B. von http auf https wechseln möchten. Geben Sie die vollständige URL zur login.php-Datei an (z.B. https://www.ihrserver.de/phpgedview/login.php) .";
$pgv_lang["PGV_SESSION_TIME_help"]	= "~#pgv_lang[PGV_SESSION_TIME]#~<br /><br />Die Zeit in Sekunden, die eine PhpGedView-Sitzung aktiv bleibt, bevor eine Anmeldung erforderlich ist. Der Standardwert ist 7200, was 2 Stunden entspricht.";
$pgv_lang["SHOW_STATS"]					= "Ablauf-Statistiken zeigen";
$pgv_lang["SHOW_STATS_help"]			= "~#pgv_lang[SHOW_STATS]#~<br /><br />Ablauf-Statistiken und Datenbank-Abfragen am unteren Seitenrand aller Seiten einblenden.";
$pgv_lang["SHOW_COUNTER"]				= "Besucher-Zähler zeigen";
$pgv_lang["SHOW_COUNTER_help"]			= "~#pgv_lang[SHOW_COUNTER]#~<br /><br />Den Besucher-Zähler auf der Portalseite und auf #pgv_lang[personal_details]# Seiten zeigen.";
$pgv_lang["USE_REGISTRATION_MODULE_help"]	= "~#pgv_lang[USE_REGISTRATION_MODULE]#~<br /><br />Erlaubt den Benutzern, einen Benutzerzugang zu diesen Seiten anzutragen.<br /><br />Der Benutzer wird eine Mail erhalten mit einem Code zur Bestätigung des Antrages.<br /><br />Danach muss der Verwalter diesen Antrag noch bestätigen, bevor der neue Benutzer sich anmelden darf.";
$pgv_lang["ALLOW_USER_THEMES_help"]		= "~#pgv_lang[ALLOW_USER_THEMES]#~<br /><br />Erlaubt den Benutzern eigene Themen zu wählen.";
$pgv_lang["PGV_SIMPLE_MAIL_help"]		= "~#pgv_lang[PGV_SIMPLE_MAIL]#~<br /><br />Normalerweise enthält der Mail-Header die Mail-Adresse und den Namen des Absenders. Einige Mailsysteme akzeptieren diese Angaben nicht. Setzen Sie diesen Wert auf <b>#pgv_lang[yes]#</b>, damit nur die Mail-Adresse verwendet wird.";
$pgv_lang["PGV_SMTP_ACTIVE_help"]		= "~#pgv_lang[PGV_SMTP_ACTIVE]#~<br /><br />Soll SMTP für das Senden von Mails benutzt werden?<br /><br />Diese Option erfordert, dass ein SMTP Server zugänglich ist.  Die Wahl <b>#pgv_lang[no]#</b> bedeutet, dass PhpGedView das im PHP Betriebs-System eingebaute Mail-System benutzen soll.";
$pgv_lang["PGV_SMTP_DEBUG_help"] = "~#pgv_lang[PGV_SMTP_DEBUG]#~<br /><br />Wenn die Option <b>#pgv_lang[PGV_SMTP_ACTIVE]#</b> auf <b>#pgv_lang[yes]#</b> gestellt ist, verwendet PhpGedView das PHPMailer-Programm zum Senden von E-Mails. Dieses Programm erzeugt Fehlermeldungen, wenn beim Versuch, E-Mails zu senden, Probleme auftreten.<br /><br />Diese Option, die beim Versuch, Probleme des Sendens von E-Mails zu beheben, hilfreich ist, bestimmt die Fehlertypen, die PHPMailer meldet. Folgende Fehlertypen können gewählt werden:<ul><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION0]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION1]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION2]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION3]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION4]#</li></ul>";
$pgv_lang["PGV_SMTP_HOST_help"]			= "~#pgv_lang[PGV_SMTP_HOST]#~<br /><br />Hier geben Sie den Namen des SMTP Servers ein.  Beispiel: <b>smtp.foo.bar.com</b>.<br /><br />Einige Server benötigen folgende Einträge:<br /><br /><b>Gmail</b><br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_HOST]#:&nbsp;&nbsp;smtp.gmail.com<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_PORT]#:&nbsp;&nbsp;465 oder 587<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_SSL]#:&nbsp;&nbsp;SSL<br /><br /><b>Hotmail</b><br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_HOST]#:&nbsp;&nbsp;smtp.live.com<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_PORT]#:&nbsp;&nbsp;25 oder 587<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_SSL]#:&nbsp;&nbsp;TLS<br /><br /><b>Yahoo Mail Plus</b> (bisher Gebührenpflichtig)<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_HOST]#:&nbsp;&nbsp;smtp.mail.yahoo.com<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_PORT]#:&nbsp;&nbsp;25";
$pgv_lang["PGV_SMTP_HELO_help"]			= "~#pgv_lang[PGV_SMTP_HELO]#~<br /><br />Dies ist das Domain einer dem SMTP Server gültigen Mail-Adresse.<br /><br />Zum Beispiel, angenommen Sie haben eine Mail-Adresse wie <b>yourname@abc.xyz.com</b>, dann sollten Sie hier <b>abc.xyz.com</b> eingeben.";
$pgv_lang["PGV_SMTP_PORT_help"]			= "~#pgv_lang[PGV_SMTP_PORT]#~<br /><br />Das TCP Protokoll, das benutzt werden soll, um eine Verbindung zum SMTP Server herzustellen.  Gewöhnlich wird das Protokoll <b>25</b> benutzt.";
$pgv_lang["PGV_SMTP_AUTH_help"]			= "~#pgv_lang[PGV_SMTP_AUTH]#~<br /><br />Erfordert der SMTP Server die Eingabe eines Nutzernamens und dessen Kennwort?<br /><br />Manche SMTP Server erfordern dass Verbindungen authentifiziert sind, bevor sie das Senden von Mails erlauben.";
$pgv_lang["PGV_SMTP_AUTH_USER_help"]	= "~#pgv_lang[PGV_SMTP_AUTH_USER]#~<br /><br />Ein dem SMTP Server gültiger Nutzername.";
$pgv_lang["PGV_SMTP_AUTH_PASS_help"]	= "~#pgv_lang[PGV_SMTP_AUTH_PASS]#~<br /><br />Das zum Nutzernamen passende Kennwort.";
$pgv_lang["PGV_SMTP_SSL_help"]		 	= "~#pgv_lang[PGV_SMTP_SSL]#~<br /><br />Transport Layer Security (TLS) und Secure Sockets Layer (SSL) sind Verschlüsselungsprotokolle zur Datenübertragung im Internet.<br /><br />TLS 1.0, 1.1 und 1.2 sind die standardisierten Weiterentwicklungen von SSL 3.0. TLS 1.0 und SSL 3.1 sind sich gleich. SSL wird also nun unter dem neuen Namen TLS weiterentwickelt.<br /><br />Falls Ihr SMTP-Server das SSL Protokoll während dem Anmelden erfordert, sollten Sie <b>SSL</b> wählen. Falls Ihr SMTP-Server das TLS Protokoll während dem Anmelden erfordert, sollten Sie <b>TLS</b> wählen.";
$pgv_lang["PGV_SMTP_FROM_NAME_help"] 	= "~#pgv_lang[PGV_SMTP_FROM_NAME]#~<br /><br />Hier geben Sie den Namen ein, der im »Abs:« Feld aller Mails von dieser Site benutzt werden soll.<br /><br />Zum Beispiel, gegeben dass Sie <b>Johann Schmidt</b> heißen, und dass Sie Verwalter von der Site <b>Ahnenforschung Müller</b> sind, dann könnten Sie eventuell hier <b>Johann&nbsp;Schmidt</b> oder <b>Ahnenforschung&nbsp;Müller</b> oder vielleicht auch <b>Johann&nbsp;Schmidt,&nbsp;Verwalter:&nbsp;Ahnenforschung&nbsp;Müller</b> eingeben.  Sie können jeden beliebigen Text eingeben, aber beachten Sie bitte, dass HTML nicht erlaubt ist.";
$pgv_lang["gedcom_title"]			= "#pgv_lang[ged_title]#";
$pgv_lang["gedcom_title_help"]			= "~#pgv_lang[gedcom_title]#~<br /><br />Geben Sie eine Bezeichnung ein, die erscheint, wenn Besucher zwischen mehreren GEDCOM-Dateien auf Ihrer Seite wählen.";
$pgv_lang["LOGFILE_CREATE"]				= "Log-Dateien erzeugen";
$pgv_lang["LOGFILE_CREATE_help"]		= "~#pgv_lang[LOGFILE_CREATE]#~<br /><br />Bestimmt, wie oft eine neue Log-Datei erzeugt wird.";
$pgv_lang["REMINDER_FREQ"] 			= "Häufigkeit der Erinnerungs-E-Mails »Änderungen überprüfen«";
$pgv_lang["REMINDER_FREQ_help"]		= "~#pgv_lang[REMINDER_FREQ]#~<br /><br />Diese Option steuert, wie oft Erinnerungs-E-Mails »Änderungen überprüfen« versendet werden. <b>null</b>: nie;&nbsp;&nbsp;<b>1</b>: täglich;&nbsp;&nbsp;<b>2</b>: jeden 2. Tag; usw.";
$pgv_lang["PGV_MEMORY_LIMIT_help"]		= "~#pgv_lang[PGV_MEMORY_LIMIT]#~<br /><br />Stellt die maximale Menge an Arbeitsspeicher ein, die den PhpGedView Scripten zur Verfügung steht. Standardwert ist 64 MB.  Manche Host haben diese Option in der PHP-Konfiguration deaktiviert, so dass eine Veränderung dieses Wertes möglicherweise keinen Einfluss hat.";
$pgv_lang["PGV_STORE_MESSAGES_help"]	= "~#pgv_lang[PGV_STORE_MESSAGES]#~<br /><br />Stellt ein, ob Nachrichten, die über PhpGedView gesendet werden, in der Datenbank gespeichert werden. Bei <b>#pgv_lang[yes]#</b> können Benutzer ihre Nachrichten aufrufen, wenn sie sich bei PGV anmelden. Bei <b>#pgv_lang[no]#</b> werden die Nachrichten nur per Mail versendet.";
$pgv_lang["ALLOW_THEME_DROPDOWN"]		= "Themen-Wechsel erlauben";
$pgv_lang["ALLOW_THEME_DROPDOWN_help"]	= "~#pgv_lang[ALLOW_THEME_DROPDOWN]#~<br /><br />Bietet Benutzern die Möglichkeit, ihr eigenes Thema aus einem Menü zu wählen.<br /><br />Selbst wenn diese Option gesetzt ist, bietet das aktuell gültige Thema möglicherweise kein solches Menü. Um effektiv zu sein, muss die Option <b>#pgv_lang[ALLOW_USER_THEMES]#</b> auch gesetzt werden.";
$pgv_lang["MAX_VIEW_RATE"]				= "Geschwindigkeitslimit der Seiten-Darstellung";
$pgv_lang["MAX_VIEW_RATE_help"]			= "~#pgv_lang[MAX_VIEW_RATE]#~<br /><br />Diese Option beschränkt wie schnell Benutzer neue Seiten anfordern können.<br /><br />Beim Überschreiten dieser Geschwindigkeitslimit erkennt das Programm einen Hack-Versuch; die Verbindung wird mit einer passenden Nachricht abgebrochen.  Wenn Sie die Zeit auf Null stellen, wird diese Option abgeschaltet.";
$pgv_lang["META_AUTHOR"]		= "META tag: Author (Autor)";
$pgv_lang["META_AUTHOR_help"]			= "~#pgv_lang[META_AUTHOR]#~<br /><br />Der Wert für das META Tag Feld »Autor« im HTML-Seitenkopf. #pgv_lang[META_AUTHOR_descr]#";
$pgv_lang["META_AUTHOR_descr"]			= "Lassen Sie dieses Feld leer, um den vollständigen Namen der #pgv_lang[CONTACT_EMAIL]# zu verwenden.";
$pgv_lang["META_PUBLISHER"]		= "META tag: Publisher (Verfasser)";
$pgv_lang["META_PUBLISHER_help"]		= "~#pgv_lang[META_PUBLISHER]#~<br /><br />Der Wert für das META Tag Feld »Publisher« im HTML-Seitenkopf. #pgv_lang[META_PUBLISHER_descr]#";
$pgv_lang["META_PUBLISHER_descr"]			= "Lassen Sie dieses Feld leer, um den vollständigen Namen der #pgv_lang[CONTACT_EMAIL]# zu verwenden.";
$pgv_lang["META_COPYRIGHT"]		= "META tag: Copyright (Urheberrecht)";
$pgv_lang["META_COPYRIGHT_help"]		= "~#pgv_lang[META_COPYRIGHT]#~<br /><br />Der Wert für das META Tag Feld »Copyright« im HTML-Seitenkopf. #pgv_lang[META_COPYRIGHT_descr]#";
$pgv_lang["META_COPYRIGHT_descr"]			= "Lassen Sie dieses Feld leer, um den vollständigen Namen der #pgv_lang[CONTACT_EMAIL]# zu verwenden.";
$pgv_lang["META_DESCRIPTION"]		= "META tag: Description (Beschreibung)";
$pgv_lang["META_DESCRIPTION_help"]		= "~#pgv_lang[META_DESCRIPTION]#~<br /><br />Der Wert für das META Tag Feld »description« im HTML-Seitenkopf. #pgv_lang[META_DESCRIPTION_descr]#";
$pgv_lang["META_DESCRIPTION_descr"]		= "Lassen Sie dieses Feld leer, um den Titel der aktuellen GEDCOM-Datei zu verwenden.";
$pgv_lang["META_PAGE_TOPIC"]		= "META tag: Page-topic (Thema)";
$pgv_lang["META_PAGE_TOPIC_help"]		= "~#pgv_lang[META_PAGE_TOPIC]#~<br /><br />Der Wert für das META Tag Feld »Page-Topic« im HTML-Seitenkopf. #pgv_lang[META_PAGE_TOPIC_descr]#";
$pgv_lang["META_PAGE_TOPIC_descr"]		= "Lassen Sie dieses Feld leer, um den Titel der aktuellen GEDCOM-Datei zu verwenden.";
$pgv_lang["META_AUDIENCE"]		= "META tag: Audience (Publikum)";
$pgv_lang["META_AUDIENCE_help"]			= "~#pgv_lang[META_AUDIENCE]#~<br /><br />Der Wert für das META Tag Feld »Audience« im HTML-Seitenkopf.";
$pgv_lang["META_PAGE_TYPE"]		= "META tag: Page-type (Seitentyp)";
$pgv_lang["META_PAGE_TYPE_help"]		= "~#pgv_lang[META_PAGE_TYPE]#~<br /><br />Der Wert für das META Tag Feld »Page-Type« im HTML-Seitenkopf.";
$pgv_lang["META_ROBOTS"]		= "META tag: Robots (Suchmaschinen)";
$pgv_lang["META_ROBOTS_help"]			= "~#pgv_lang[META_ROBOTS]#~<br /><br />Der Wert für das META Tag Feld »Robots« im HTML-Seitenkopf. Manche Suchmaschinen missachten diesen Wert.";
$pgv_lang["META_REVISIT"]		= "META tag: Revisit (Rückkehren)";
$pgv_lang["META_REVISIT_help"]	= "~#pgv_lang[META_REVISIT]#~<br /><br />Wie oft sollen Suchmaschinen rückkehren? Der Wert für das META Tag Feld »Revisit« im HTML-Seitenkopf. Manche Suchmaschinen missachten diesen Wert.";
$pgv_lang["META_KEYWORDS"]		= "META tag: Keywords (Schlüsselwörter)";
$pgv_lang["META_KEYWORDS_help"]			= "~#pgv_lang[META_KEYWORDS]#~<br /><br />Der Wert für das META Tag Feld »Keywords« im HTML-Seitenkopf. Viele Suchmaschinen nutzen die Keyword-Meta-Tags zur Indizierung von Webseiten. Ihre Angabe hier wird ergänzt durch die Liste der häufigsten Nachnamen, so wie sie auf der Willkommens-Seite erscheint.";
$pgv_lang["META_TITLE"]					= "Zur »TITLE« Kennung im Kopfbereich hinzufügen";
$pgv_lang["META_TITLE_help"]			= "~#pgv_lang[META_TITLE]#~<br /><br />Was Sie hier eingeben wird in der TITLE-Kennung hinter dem regulären Seitentitel und vor dem PhpGedView-Hinweis eingefügt.";

$pgv_lang["ENABLE_RSS"]					= "RSS erlauben";
$pgv_lang["ENABLE_RSS_help"]		= "~#pgv_lang[ENABLE_RSS]#~<br /><br />Diese Option ermöglicht das Abschalten des RSS-Moduls.<br /><br />Mit RSS werden Benutzer nach Anfrage über Änderungen der Hauptseite benachrichtigt, ohne dass sie die Site gelegentlich selbst besuchen müssen.  Wenn zu viele Benutzer diese Funktion nutzen oder die von diesen Benutzern festgelegte Aktualisierungsfrequenz zu hoch ist, kann RSS zu viel Bandbreite oder Serverkapazität verbrauchen.<br /><br />Dieser <a href='https://de.wikipedia.org/wiki/RSS' target='_blank' title='Wikipedia Artikel'><b>Wikipedia Artikel</b></a> enthält ausführliche Informationen über RSS.";
$pgv_lang["RSS_FORMAT"]				= "RSS Format";
$pgv_lang["RSS_FORMAT_help"]			= "~#pgv_lang[RSS_FORMAT]#~<br /><br />Hier wählen Sie das Format der RSS-Nachrichten. Die Nummern bedeuten <u>keine</u> Version: sie dienen nur zur Identifizierung des Nachrichten-Formats.  Zum Beispiel, RSS 2.0 ist nicht neuer als RSS 1.0;  es ist ein anderes Format. Das Programm, das von der Site RSS-Nachrichten anfordert, muss alle Formate richtig bearbeiten. Dieser <a href='https://de.wikipedia.org/wiki/RSS' target='_blank' title='Wikipedia Artikel'><b>Wikipedia Artikel</b></a> enthält ausführliche Informationen über RSS.";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE"]	= "Prüfen ob GEDCOM-Dateien heruntergeladen werden können";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE_help"]	= "~#pgv_lang[SECURITY_CHECK_GEDCOM_DOWNLOADABLE]#~<br /><br />Aus Sicherheitsgründen sollten GEDCOM-Dateien nicht direkt vom Internet zugreifbar sein.  Wenn Sie dieses Link klicken, prüft das Programm ob die GEDCOM-Datei über das Internet heruntergeladen werden kann.<br /><br />Manche Betriebssysteme unterstützen diese Prüfe nur schlecht.  Wenn das Programm Ihnen keine Antwort liefert, können Sie mit Ihrem Browser die selbe Prüfe machen, indem Sie den Pfad und Namen Ihrer Datei eingeben.  Zum Beispiel: http://yoursite.com/phpgedview/index/yourfile.ged";
$pgv_lang["gedcom_download_secure"]		= "#GEDCOM# kann nicht heruntergeladen werden.";

$pgv_lang["welcome_new_help"]			= "~#pgv_lang[welcome_new]#~<br /><br />Da Sie diese Seite sehen, haben Sie PhpGedView richtig installiert, und können anfangen, die Einstellungen zu bearbeiten.<br /><br />Dieses Hilfe-Fenster wird Ihnen bei der Konfiguration zur Seite stehen. Wenn Sie das Eingabe-Feld wechseln erscheint hier jeweils ein Hilfetext zu dem Feld, in dem sich die Eingabemarke befindet. Sie können das Fenster schließen; um es wieder zu öffnen klicken Sie auf das <b>#pgv_lang[qm]#</b> neben einem Eingabefeld.";
$pgv_lang["return_editconfig"]			= "Sie können jederzeit diese Konfigurationsseite aufrufen, indem Sie auf der <b>Verwaltungsseite</b> auf <b>Konfiguration</b> klicken, oder im Browser die Seite <i>editconfig.php</i> aufrufen.";
$pgv_lang["return_editconfig_gedcom"]	= "Sie können zu dieser Konfiguration jederzeit zurückkehren, indem Sie das Link <b>Bearbeiten</b> in der Tabelle <b>#pgv_lang[current_gedcoms]#</b> auf der Seite <b>#pgv_lang[gedcom_adm_head]#</b> klicken, oder indem Sie in Ihrem Browser die Seite <i>editconfig_gedcom.php</i> aufrufen.";
$pgv_lang["save_config"]				= "Konfiguration speichern";
$pgv_lang["download_gedconf"]			= "GEDCOM Konfiguration herunterladen.";
$pgv_lang["not_writable"]				= "Die Konfiguration lässt sich nicht speichern. Mit dem <b>#pgv_lang[download_file]#</b> Button können Sie Ihre Einstellungen in eine Datei speichern, die Sie anschließend manuell hochladen müssen.";
$pgv_lang["upload_to_index"]			= "Datei in Ihr Index-Verzeichnis hochladen: ";
$pgv_lang["import_sql"]					= "Dateien mit SQL-Befehlen sind im »index« Verzeichnis vorhanden.  Diese Dateien könnten vom #pgv_lang[um_header]# stammen.  Möchten Sie diese Informationen in die Datenbank einführen? Alle bereits vorhandenen Benutzerdaten, wie Benutzernamen, Lesezeichen, Darstellung der Berüßungsseite, Nachrichten, usw. werden vorher gelöscht.<br /><br />Wenn beim Importieren Fehler auftreten, müssen Sie die Daten des Haupt-Verwalters erneut eingeben.";

//-- edit privacy messages
$pgv_lang["edit_privacy"]				= "Datenschutz Konfiguration";
$pgv_lang["edit_privacy_title"]			= "Datenschutz Konfiguration";
$pgv_lang["save_changed_settings"]		= "Änderungen speichern";
$pgv_lang["add_new_pp_setting"]			= "Neue Einstellung für den vollständigen Datenschutz nach Personen-ID hinzufügen";
$pgv_lang["add_new_up_setting"]			= "Neue Einstellung für den Datenschutz für Benutzernamen hinzufügen";
$pgv_lang["add_new_gf_setting"]			= "Neue Einstellung für den globalen Datenschutz von Fakten hinzufügen";
$pgv_lang["add_new_pf_setting"]			= "Neue Einstellung für den Datenschutz von Fakten nach Personen-ID hinzufügen";
$pgv_lang["file_read_error"]			= "F E H L E R !!! Die Datenschutz-Datei konnte nicht gelesen werden!";
$pgv_lang["edit_exist_person_privacy_settings"]	= "Vorhandene Einstellungen für den vollständigen Datenschutz nach Personen-ID bearbeiten";
$pgv_lang["edit_exist_user_privacy_settings"]	= "Vorhandene Einstellungen für den Datenschutz für Benutzernamen bearbeiten";
$pgv_lang["edit_exist_global_facts_settings"]	= "Vorhandene Einstellungen für den globalen Datenschutz von Fakten bearbeiten";
$pgv_lang["edit_exist_person_facts_settings"]	= "Vorhandene Einstellungen für den Datenschutz von Fakten nach Personen-ID bearbeiten";
$pgv_lang["general_privacy"]			= "Allgemeine Privatsphären Einstellungen";
$pgv_lang["general_privacy_help"]		= "~#pgv_lang[general_privacy]#~<br /><br />Diese Einstellungen sind die Grundeinstellungen für die jeweilige GEDCOM-Datei. Prüfen Sie, ob Sie die richtige GEDCOM-Datei bearbeiten; den Namen finden Sie unter der Überschrift.<br /><br />Sie können diese Grundeinstellungen überschreiben, indem Sie die anderen Bereiche auf der Seite »#pgv_lang[edit_privacy_title]#« benutzen.<br /><br />#pgv_lang[more_help_advice]#";
$pgv_lang["person_privacy"]				= "Einstellungen für den vollständigen Datenschutz nach Personen-ID";
$pgv_lang["person_privacy_help"]		= "~#pgv_lang[person_privacy]#~<br /><br />Diese Einstellung ermöglicht dem Verwalter, voreingestellte Datenschutz-Einstellungen für Personen aus der GEDCOM-Datenbank zu überschreiben.<br /><br />Wenn z.B. einer Person in der Datenbank ein Kind zugeordnet ist, das im Kleinkindalter verstarb, dann werden normalerweise die Daten dieses Kindes allen Besuchern, gleich ob sie angemeldet sind oder nicht, gezeigt, da es schon verstorben ist.<br /><br />Aber die Daten der Eltern sind nicht öffentlich zugänglich, da diese noch leben.<br /><br />Nun möchten Sie den Sterbe-Eintrag dieses Kindes nicht aus der Datenbank entfernen, jedoch alle Daten dieses Kindes unter Datenschutz stellen.<br /><br />Hat dieses Kind z.B. die ID I100, dann geben Sie folgendes ein:<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I100<br />&nbsp;&nbsp;&nbsp;#pgv_lang[accessible_by]#:&nbsp;&nbsp;#pgv_lang[PRIV_USER]#<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;dann bekommen nur angemeldete Benutzer die Daten dieses Kindes zu sehen.<br /><br />Dies funktioniert natürlich auch umgekehrt:<br /><br />Um alle Daten einer Person (ID I101), die z.B. nicht mehr lebt aber deren Sterbedaten unbekannt sind, dennoch für alle Benutzer sichtbar zu machen, bearbeiten Sie die Einstellungen wie folgt:<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I101<br />&nbsp;&nbsp;&nbsp;#pgv_lang[accessible_by]#:&nbsp;&nbsp;#pgv_lang[PRIV_PUBLIC]#<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;dann bekommen alle Benutzer die Daten dieser Person zu sehen.";
$pgv_lang["user_privacy"]				= "Einstellungen für den Datenschutz für Benutzernamen";
$pgv_lang["user_privacy_help"]			= "~#pgv_lang[user_privacy]#~<br /><br />Diese Einstellung ermöglicht dem Verwalter, voreingestellte Einstellungen zur Anzeige der Daten von Personen für gewählte registrierte Besucher zu ändern.<br /><br />Wenn z.B. ein registierter Benutzer mit dem Benutzernamen »John« die Daten einer bestimmten Person (z.B. ID I100) nicht sehen darf, dann geben Sie folgendes ein:<br />&nbsp;&nbsp;&nbsp;Benutzername:&nbsp;&nbsp;John<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I100<br />&nbsp;&nbsp;&nbsp;#pgv_lang[show_question]#:&nbsp;&nbsp;#pgv_lang[hide]#<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;dadurch erreichen Sie, dass alle Details der Person mit der ID I100 nur dem Besucher »John« verborgen sind.<br /><br />Um alle Daten einer Person (ID I101), die normalerweise verborgen blieben (Person lebt noch oder Verwandtschaftsgrad zu gering), dennoch für Benutzer »John« sichtbar zu machen, bearbeiten Sie die Einstellungen wie folgt:<br />&nbsp;&nbsp;&nbsp;Benutzername:&nbsp;&nbsp;John<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I101<br />&nbsp;&nbsp;&nbsp;#pgv_lang[show_question]#:&nbsp;&nbsp;#pgv_lang[show]#";
$pgv_lang["global_facts"]				= "Einstellungen für den globalen Datenschutz von Fakten";
$pgv_lang["global_facts_help"]			= "~#pgv_lang[global_facts]#~<br /><br />Diese Einstellungen definieren Fakten auf globaler Ebene, die für alle Personen verborgen werden sollen. Dies gilt nur für Fakten der Ebene 1 wie BIRT oder DEAT, die mit eigenen Überschriften auf dem Register #pgv_lang[personal_facts]# der Seite »Persönliche Details« angezeigt werden.<br /><ul><li>Das Element <b>#pgv_lang[name_of_fact]#</b> bestimmt, welches Faktum verborgen werden soll.</li><li>Das Element <b>#pgv_lang[choice]#</b> gibt das Faktum selbst oder verwandte Details an.</li><li>Das Element <b>#pgv_lang[accessible_by]#</b> bestimmt, auf welcher Zugriffsebene das Faktum gezeigt wird.</li></ul><br />Diese Funktion soll bestimmte Fakten, die durch GEDCOM-Tags gekennzeichnet sind, für alle lebenden oder toten Personen verbergen. Standardmäßig ist das SSN-Tag für öffentliche Benutzer verborgen. Dies soll verhindern, dass Personen Sozialversicherungsnummern stehlen und Identitätsdiebstahl von Toten begehen. Dies ist wahrscheinlich hauptsächlich für die USA relevant.<br /><br />Wenn Sie alle Ehen vor öffentlichen Benutzern in Ihrem GEDCOM verbergen möchten, können Sie Folgendes festlegen:<br />&nbsp;&nbsp;&nbsp;#pgv_lang[name_of_fact]#: (MARR) - Ehe<br />&nbsp;&nbsp;&nbsp;#pgv_lang[choice]#: #pgv_lang[fact_details]#<br />&nbsp;&nbsp;&nbsp;#pgv_lang[accessible_by]#: #pgv_lang[PRIV_USER]#<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Diese Einstellungen verbergen Ehen und verwandte Details für Besucher, die nicht angemeldet sind.<br /><br />Im Gegensatz zu allen anderen Einstellungen können Sie in <b>#pgv_lang[edit_exist_global_facts_settings]#</b> Fakten sogar vor dem Administrator verbergen. Unerwünschte Fakten werden vollständig unterdrückt.";
$pgv_lang["person_facts"]				= "Einstellungen für den Datenschutz von Fakten nach Personen-ID";
$pgv_lang["person_facts_help"]			= "~#pgv_lang[person_facts]#~<br /><br />Diese Einstellungen definieren Fakten, die für eine bestimmte Person, Familie oder Quelle verborgen sind, und die Ebene, auf der sie verborgen sind. Dies gilt nur für Fakten der Ebene 1 wie BIRT oder DEAT, die mit eigenen Überschriften auf der entsprechenden Detailseite der Person, Familie oder Quelle gezeigt werden.<br /><br />Das erste Element ist die ID der Person, Familie oder Quelle. Das zweite Element ist das Faktum.  Das Element <b>#pgv_lang[choice]#</b> gibt das Faktum selbst oder verwandte Details an. Das Element <b>#pgv_lang[accessible_by]#</b> bestimmt, auf welcher Zugriffsebene das Faktum gezeigt wird. Nicht alle in der Liste aufgeführten Fakten gelten für alle Arten von IDs. Zum Beispiel sind Fakten wie BIRT und DEAT für Quellen nicht relevant.<br /><br />Diese Liste ähnelt der Liste <b>#pgv_lang[global_facts]#</b>, außer dass Sie auch die GEDCOM-ID der Person angeben, für die Sie Fakten verbergen möchten. Sie können beispielsweise die Ehe einer bestimmten Person verbergen.";
$pgv_lang["accessible_by"]				= "Wem zeigen?";
$pgv_lang["hide"]						= "Verbergen";
$pgv_lang["show_question"]				= "Zeigen?";
$pgv_lang["user_name"]					= "Benutzername";
$pgv_lang["name_of_fact"]				= "Fakt-Bezeichnung";
$pgv_lang["choice"]						= "Wahl";
$pgv_lang["fact_show"]					= "Faktum zeigen";
$pgv_lang["fact_details"]				= "Fakt-Details zeigen";
$pgv_lang["privacy_header"]				= "Datenschutz-Einstellungen bearbeiten in";
$pgv_lang["unable_to_find_privacy_indi"]	= "Zu folgendem ID kann keine Person gefunden werden:";
$pgv_lang["save_and_import"]			= "Nach dem Speichern dieser GEDCOM Konfiguration müssen Sie die Daten importieren, indem Sie den <b>Diese GEDCOM-Datei importieren</b> Button klicken oder die Seiten <b>Administration --> GEDCOMs verwalten --> Import</b> besuchen.";
$pgv_lang["help_info"]					= "Hilfe erhalten Sie, wenn Sie das jeweilige Fragezeichen <b>#pgv_lang[qm]#</b> neben der Einstellungsbezeichnung klicken.";
$pgv_lang["SHOW_LIVING_NAMES"]			= "Namen lebender Personen zeigen";
$pgv_lang["SHOW_LIVING_NAMES_help"]		= "~#pgv_lang[SHOW_LIVING_NAMES]#~<br /><br />Mit dieser Einstellung können Sie bestimmen, wem die Namen lebender Personen gezeigt werden.<br /><br />Normalerweise wäre diese Einstellung »#pgv_lang[PRIV_USER]#«. Dies dient dem Schutz der Privatsphäre lebender Personen in Ihrer Datenbank, da Sie bestimmen können, wem Sie allgemeinen Zugriff auf Ihre Genealogie-Daten gewähren.<br /><br />Die Einstellung »#pgv_lang[PRIV_NONE]#« verhindert das Zeigen der Namen lebender Personen an Benutzer die keine Administratorrechte haben.";
$pgv_lang["SHOW_RESEARCH_ASSISTANT"]	= "Forschungs-Assistent zeigen";
$pgv_lang["SHOW_RESEARCH_ASSISTANT_help"]	= "~#pgv_lang[SHOW_RESEARCH_ASSISTANT]#~<br /><br />Bestimmt die Benutzer, die Zugriffsrechte zum Forschungs-Assistent haben.";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]	= "Verwandtschafts-Datenschutz einschalten";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]	= "~#pgv_lang[USE_RELATIONSHIP_PRIVACY]#~<br /><br /><b>#pgv_lang[no]#</b> bedeutet, dass alle angemeldeten Benutzer alle Daten lebender Personen zu sehen bekommen. <b>#pgv_lang[yes]#</b> bedeutet, dass angemeldete Benutzer nur die Daten lebender Personen zu sehen bekommen, mit denen sie verwandt sind.<br /><br />Diese Option bestimmt die Standard-Einstellung für alle Benutzer, die zu dieser genealogischen Datenbank Zugang haben.  Durch Bearbeiten der Benutzerdaten kann der Verwalter andere Einstellungen für einzelne Benutzer bestimmen.";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]	= "Maximale Länge der Verwandtschaftsberechnung";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]	= "~#pgv_lang[MAX_RELATION_PATH_LENGTH]#~<br /><br />Wenn die <i>#pgv_lang[USE_RELATIONSHIP_PRIVACY]#</i> Option aktiv ist, können angemeldete Benutzer nur die Daten lebender Personen bis zu diesem Verwandtschaftsgrad ansehen oder bearbeiten.<br /><br />Diese Option bestimmt die Standard-Einstellung für alle Benutzer, die zu dieser genealogischen Datenbank Zugang haben.  Durch Bearbeiten der Benutzerdaten kann der Verwalter andere Einstellungen für einzelne Benutzer bestimmen.";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]	= "Verwandtschaft anhand von Eheschließungen überprüfen";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]	= "~#pgv_lang[CHECK_MARRIAGE_RELATIONS]#~<br /><br />Soll der Verwandtschaftsgrad auch durch Zurhilfenahme von Eheschließungsdaten geprüft werden?";
$pgv_lang["SHOW_DEAD_PEOPLE"]			= "Verstorbene Personen zeigen";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]		= "~#pgv_lang[SHOW_DEAD_PEOPLE]#~<br /><br />Setzt die Datenschutz-Einstellungen für alle verstorbenen Personen.";
$pgv_lang["select_privacyfile_button"]	= "Datenschutzdatei wählen";
$pgv_lang["PRIVACY_BY_YEAR"]			= "Datenschutz mittels Alter eines Ereignisses begrenzen";
$pgv_lang["PRIVACY_BY_YEAR_help"]		= "~#pgv_lang[PRIVACY_BY_YEAR]#~<br /><br />Wenn Sie den <b>#pgv_lang[PRIVACY_BY_YEAR]#</b>, werden Details von Personen gezeigt oder verborgen in Abhängigkeit davon, wie alt die Person zum Zeitpunkt des Ereignisses war, unabhängig davon, ob die Person lebt oder verstorben ist. Verwenden Sie diese Einstellung in Verbindung mit <b>#pgv_lang[MAX_ALIVE_AGE]#</b>. Wenn Sie z.B. den Alters-Wert auf 100 einstellen und die eben genannte Option auf <b>#pgv_lang[yes]#</b>, werden alle Personen, gleich ob sie lebend oder verstorben sind, die vor weniger als 100 Jahren geboren wurden, als privat behandelt. Personen, die vor weniger als 85 Jahren geheiratet haben und Personen, die vor weniger als 75 Jahren verstorben sind, werden ebenfalls als privat behandelt. Beachten Sie bitte, dass diese Option den Seitenaufbau etwas verlangsamt.";

//-- language edit utility
$pgv_lang["lang_edit_help"]			= "~#pgv_lang[translator_tools]#~<br /><br />Diese Seite ist für Übersetzer gedacht. Sie können Sprachdateien übersetzen, vergleichen und exportieren. Es gibt auch eine Option, mit der Übersetzer die Herkunft des von PhpGedView ausgegebenen Texts bestimmen können.<br /><br />Sie können die folgenden Optionen und Dienstprogramme verwenden:";
$pgv_lang["edit_langdiff"]				= "Sprach-Dateien bearbeiten und konfigurieren";
$pgv_lang["bom_check"]		= "Byte Order Mark (BOM) Test";
$pgv_lang["bom_check_help"]		= "~#pgv_lang[bom_check]#~<br /><br />#pgv_lang[bom_check_desc]#";
$pgv_lang["bom_check_desc"]				= "Diese Option untersucht alle Sprachdateien nach dem BOM (Byte Order Mark) Zeichen. Solche Zeichen werden automatisch entfernt, sofern das <i>languages</i> Verzeichnis und alle darin vorkommende Sprach-Dateien Welt-schreibbar sind.  BOM Zeichen, falls vorhanden, verursachen Fehler in verschiedenen Teilen des Programmes.";
$pgv_lang["lang_debug"]					= "Debug-Option für Hilfe-Texte";
$pgv_lang["lang_debug_help"]	= "~#pgv_lang[lang_debug]#~<br /><br />#pgv_lang[lang_debug_desc]#";
$pgv_lang["lang_debug_desc"]	= "Wenn diese Option eingeschaltet ist, werden alle Sprach-Variablen die im Hilfe-Text vorkommen, in einem Popup-Fenster gezeigt.  Der Übersetzer kann dann ermitteln, welche Sprach-Variablen geändert werden müssen.<br /><br />Diese Einstellung ist nur während Ihrer aktuellen PhpGedView-Sitzung gültig.";
$pgv_lang["lang_debug_use"]				= "Benutze Hilfe-Text Debug-Option";
$pgv_lang["bom_not_found"]				= "Es wurde keine BOM gefunden.";
$pgv_lang["bom_found"]					= "BOM gefunden in ";
$pgv_lang["edit_lang_utility"]			= "Bearbeitungsmodul für Sprach-Dateien";
$pgv_lang["edit_lang_utility_help"]	= "~#pgv_lang[edit_lang_utility]#~<br /><br />#pgv_lang[edit_lang_utility_desc]#";
$pgv_lang["edit_lang_utility_desc"]	= "Mit diesem Mudul können Sie den Inhalt einer Sprachdatei mit Hilfe des Inhalts der englischen bearbeiten.<br /><br />Sie sehen den Inhalt der englischen Originaldatei und den Inhalt desselben Dateityps (es gibt neun davon) in der von Ihnen gewählten Sprache. Sie klicken den Text unter der englischen Version. Dies öffnet ein neues Fenster, worin Sie den Text ändern können. Sie können die Änderungen speichern oder abbrechen.";
$pgv_lang["edit_lang_utility_warning"]	= "ACHTUNG!<br /><br />Wenn Sie den Button »#pgv_lang[close_window_without_refresh]#« benutzen, werden Sie die Ihre Änderungen nicht sehen, es sei denn, Sie laden die Seite manuell neu. Außerdem kann die Sprachdatei zerstört werden, wenn Sie dann einen Eintrag hinzufügen, der noch nicht existierte, oder wenn Sie einen unmittelbar zuvor geänderten Eintrag erneut ändern!<br /><br />Wenn Sie nicht wirklich wissen, was Sie tun, verwenden Sie bitte nicht den <b>#pgv_lang[close_window_without_refresh]#</b> Button.";
$pgv_lang["language_to_edit"]			= "Zu bearbeitende Sprache";
$pgv_lang["language_to_edit_help"]		= "~#pgv_lang[language_to_edit]#~<br /><br />Hier können Sie die Sprache wählen, deren Texte Sie bearbeiten möchten.";
$pgv_lang["file_to_edit"]				= "Zu bearbeitende Sprachdatei";
$pgv_lang["file_to_edit_help"]			= "~#pgv_lang[file_to_edit]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["lang_file_descriptions"]		= "PhpGedView hat die Unterstützung vieler Sprachen implementiert. Dies ist erreicht, indem der gesamte Text, der für Benutzer sichtbar ist, vom Hauptprogramm vollkommen in Dateien getrennt gehalten sind. Für jede unterstützte Sprache gibt es einen Satz von acht Dateien, und die verschiedenen Texte sind je nach Funktion in eine dieser Dateien unterteilt. <b>Nicht alle Sprachdateien müssen vorhanden sein.</b> Wenn ein bestimmter Text noch nicht in übersetzter Form verfügbar ist, verwendet PhpGedView immer die englische Version.<br /><br />Die Dateien in den einzelnen Sprachensätzen sind:<br /><ul><li><b><i>admin.xx.php</i></b>&nbsp;&nbsp;Diese Datei enthält Begriffe und allgemeine Ausdrücke die während der Verwaltung von PhpGedView und den genealogischen Datenbanken verwendet sind.</li><br /><li><b><i>configure_help.xx.php</i></b>&nbsp;&nbsp;Diese Datei enthält Hilfetexte zur Verwendung bei der Konfiguration von PhpGedView. Diese Texte sind nicht für normale Benutzer gedacht.</li><br /><li><b><i>countries.xx.php</i></b>&nbsp;&nbsp;Dies ist eine Liste von Ländernamen, die der Website der Statistikabteilung des Ministeriums für Wirtschaft und Soziales der Vereinten Nationen entnommen ist. Dies ist das relevante <a href=\"http://unstats.un.org/unsd/methods/m49/m49alpha.htm\" target=\"_blank\"><b>Link</b></a> zur englischen Liste. Die Liste ist in Englisch und Französisch verfügbar.</li><br /><li><b><i>editor.xx.php</i></b>&nbsp;&nbsp;Diese Datei enthält Begriffe und allgemeine Ausdrücke zur Verwendung beim Bearbeiten von Einträgen in den genealogischen Datenbanken.</li><br /><li><b><i>facts.xx.php</i></b>&nbsp;&nbsp;Diese Datei enthält die Textäquivalente der GEDCOM-Faktcodes, die im GEDCOM 5.5.1-Standard enthalten sind. Es enthält auch zusätzliche Faktcodes, die nicht im Standard enthalten sind, aber von verschiedenen Genealogie-Programmen verwendet werden.<br /><br />Eine englische Kopie des <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\"><b>GEDCOM 5.5.1 Standard</b></a> kann als PDF (Portable Document Format == tragbares Dokumentformat) heruntergeladen werden.</li><br /><li><b><i>faqlist.xx.php</i></b>&nbsp;&nbsp;Diese Datei ist ein Satz von <b>f</b>requently <b>a</b>sked <b>q</b>uestions (oft gestelle Fragen), die vom PhpGedView-Entwicklungsteam gesammelt wurden. Jede FAQ enthält zwei Einträge in dieser Datei. Ein Eintrag ist die FAQ-Überschrift (normalerweise die Frage) und der andere ist der FAQ-Text (normalerweise die Antwort). Ersetzungen für die <b><i>faqlist.xx.php</i></b> Dateien, die gelegentlich aktualisiert werden, können von der PhpGedView-Homepage heruntergeladen werden.<br /><br />Der Administrator kann die FAQs in dieser Datei verwenden, um eine FAQ-Liste zu erstellen, die für seine Site spezifisch ist.</li><br /><li><b><i>help_text.xx.php</i></b>&nbsp;&nbsp;Diese Datei enthält Hilfetexte für normale Benutzer. Einige Hilfethemen in dieser Datei richten sich den Administratoren und sind für Benutzer ohne Administratorrechte verborgen.</li><br /><li><b><i>lang.xx.php</i></b>&nbsp;&nbsp;In dieser Datei befinden sich viele Begriffe und gebräuchliche Ausdrücke.</li></ul><br />PhpGedView unterstützt auch eine optionale neunte Sprachdatei, <b><i>extra.xx.php</i></b>. Diese Datei wird immer nach allen anderen geladen und bietet eine Möglichkeit, mit der ein Site-Administrator Standardtexte in der gewählten Sprache überschreiben oder ändern kann. Sie kann auch verwendet werden, einen Titel der genealogischen Datenbank bereitzustellen, der je nach der aktuellen Sprache variiert.<br /><br />Der Inhalt dieser zusätzlichen Datei liegt vollständig beim Site-Administrator. Diese Datei wird <b>niemals</b> mit neuen PhpGedView Versionen verteilt. Der Verwalter soll vermeiden, die normalen Sprach-Dateien zu ändern;  solche Änderungen sollten in dieser neunten Datei gesammelt werden.";
$pgv_lang["check"]						= "Prüfen";
$pgv_lang["lang_save"]					= "Speichern";
$pgv_lang["contents"]					= "Inhalt";
$pgv_lang["listing"]					= "Einträge";
$pgv_lang["no_content"]					= "Leer";
$pgv_lang["editlang"]					= "Bearbeiten";
$pgv_lang["editlang_help"]		= "~#pgv_lang[editlang]#~<br /><br />Sprachdatei bearbeiten";
$pgv_lang["savelang"]					= "Speichern";
$pgv_lang["savelang_help"]		= "~#pgv_lang[savelang]#~<br /><br />Änderungen speichern.";
$pgv_lang["original_message"]			= "Original Inhalt";
$pgv_lang["message_to_edit"]			= "Zu ändernder Inhalt";
$pgv_lang["changed_message"]			= "Geänderter Inhalt";
$pgv_lang["message_empty_warning"]		= "-&gt; Achtung!!! Dieser Eintrag ist in der Datei [#LANGUAGE_FILE#] leer &lt;-";
$pgv_lang["language_to_export"]			= "Zu exportierende Sprache";
$pgv_lang["language_to_export_help"]	= "~#pgv_lang[language_to_export]#~<br /><br />Aus dieser Liste können Sie die Sprache und die Sprachdateien wählen, deren Text Sie exportieren möchten.<br /><br />Die Ausgabe ist eine HTML-Datei, die Sie über Ihren Browser drucken können.";
$pgv_lang["export_lang_utility"]		= "Exportmodul für Sprach-Dateien";
$pgv_lang["export"]						= "Exportieren";
$pgv_lang["export_lang_utility_help"]	= "~#pgv_lang[export_lang_utility]#~<br /><br />#pgv_lang[export_lang_utility_desc]#";
$pgv_lang["export_lang_utility_desc"]	= "Sie können Dokumentation für Administratoren erstellen.<br /><br />Dieses Werkzeug erstellt eine HTML-Version der gewählten Sprachdatei. Sie können Ihren Browser verwenden, diese Datei zu besichtigen, die zum Drucken formatiert ist.";
$pgv_lang["export_ok"]					= "Sprachtext wurde exportiert";
$pgv_lang["compare_lang_utility"]		= "Vergleichsmodul für Sprach-Dateien";
$pgv_lang["compare_lang_utility_help"]	= "~#pgv_lang[compare_lang_utility]#~<br /><br />#pgv_lang[compare_lang_utility_desc]#";
$pgv_lang["compare_lang_utility_desc"]	= "Dieses Modul vergleicht alle Dateien von zwei Sprachen.  Eine Differenzen-Liste wird erstellt.  Diese Liste zeigt alle hinzugefügte und gelöschte oder fehlende Einträge in beiden Sprachen.<br /><br />Die englischen Sprach-Dateien sollen immer als Referenz dienen.";
$pgv_lang["new_language"]				= "Referenz-Sprache";
$pgv_lang["new_language_help"]			= "~#pgv_lang[new_language]#~<br /><br />Aus dieser Liste können Sie die Sprache wählen, dessen Texte Sie mit denen einer anderen Sprache vergleichen möchten.<br /><br />Alle Änderungen und Ergänzungen an Sprachdateien werden zuerst an den <b>englischen</b> Sprachdateien vorgenommen. Daher würden Sie normalerweise Englisch als eine der zu vergleichenden Sprachen wählen.";
$pgv_lang["old_language"]				= "Zweite Sprache";
$pgv_lang["old_language_help"]			= "~#pgv_lang[old_language]#~<br /><br />In dieser Liste können Sie die Sprache wählen, die Sie mit der in der Liste <b>#pgv_lang[new_language]#</b> gewählten Sprache vergleichen möchten.<br /><br />Nachdem Sie Ihre Auswahl getroffen haben, klicken Sie den Button <b>Vergleichen</b>, um eine Liste aller Additionen und Subtraktionen in allen Dateien beider Sprachen zu erhalten.<br /><br />Als Gedächtnishilfe:<br /><b>Ergänzt</b> bedeutet: Der Text befindet sich <u>in</u> der Quelldatei, aber <u>nicht</u> in der Sekundärdatei.<br /><br /><b>Entfernt</b> bedeutet: Der Text befindet sich <u>nicht</u> in der Quelldatei, aber <u>ist</u> in der Sekundärdatei. Dies kann passieren, wenn eine bestimmter Text nicht mehr verwendet wird und daher aus der englischen Datei entfernt wurde. Sie können den entsprechenden Text sicher aus den Sekundärsprachdatei entfernen.";
$pgv_lang["compare"]					= "Vergleichen";
$pgv_lang["comparing"]					= "Verglichene Sprach-Dateien";
$pgv_lang["additions"]					= "Ergänzungen";
$pgv_lang["no_additions"]				= "Keine Ergänzungen";
$pgv_lang["subtractions"]				= "Entfernte Teile";
$pgv_lang["no_subtractions"]			= "Keine entfernte Teile";
$pgv_lang["config_lang_utility"]		= "Konfiguration der unterstützten Sprachen";
$pgv_lang["config_lang_utility_help"]	= "~#pgv_lang[config_lang_utility]#~<br /><br />Auf dieser Seite können Sie festlegen, welche Sprachoptionen Ihren Benutzern zur Verfügung stehen. Sie können beispielsweise festlegen, dass nur Deutsch und Französisch verfügbar sind. Dies kann nützlich sein, wenn Sie beispielsweise nicht in der Lage sind, mit Ihren Benutzern auf Ungarisch zu kommunizieren.<br /><br />Auf dieser Seite können Sie auch bestimmte Aspekte von PhpGedView ändern, die von der gewählten Sprache abhängen. Hier teilen Sie PhpGedView beispielsweise mit, wie Datums- und Zeitfelder formatiert werden sollen.<br /><br />Die aktiven und ausgegrauten Sprachen können nicht deaktiviert werden, da sie verwendet werden. Sehen Sie in der unteren Tabelle nach, wo die Sprache verwendet wird. Wenn eine Sprache vom GEDCOM oder Benutzer nicht mehr verwendet wird, können Sie sie deaktivieren.<br /><br />Alle Ihre Änderungen werden in einer neuen Datei <i>language_settings.php</i> des Orders <b>#INDEX_DIRECTORY#</b> gespeichert. Alle weiteren Änderungen werden an dieser neuen Datei vorgenommen, und PhpGedView verwendet nur <u>diese</u> Datei. Sie können zu den ursprünglichen Einstellungen zurückkehren, indem Sie diese Datei löschen.<br /><br />Wenn Sie Probleme mit Ihren Spracheinstellungen melden müssen, teilen Sie dem PhpGedView-Supportteam mit, ob diese neue Datei vorhanden ist oder nicht.";
$pgv_lang["active"]						= "Aktiviert";
$pgv_lang["active_help"]				= "Den Besuchern erlauben diese Sprache zu wählen, sofern <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b> erlaubt ist.";
$pgv_lang["edit_settings"]				= "Einstellungen bearbeiten";
$pgv_lang["lang_edit"]					= "Bearbeiten";
$pgv_lang["lang_language"]				= "Sprache";
$pgv_lang["export_filename"]			= "Name der Datei, welche die exportierten Daten enthält:";
$pgv_lang["lang_back"]					= "Zurück zum Hauptmenü, um die Sprach-Dateien zu bearbeiten und zu konfigurieren";
$pgv_lang["lang_back_admin"]			= "Zurück zum Verwaltungs-Menü";
$pgv_lang["lang_back_manage_gedcoms"]	= "Zurück zum GEDCOM Verwaltungs-Menü";
$pgv_lang["lang_name_arabic"]			= "Arabisch";
$pgv_lang["lang_name_catalan"]			= "Katalanisch (Valenzianisch)";
$pgv_lang["lang_name_chinese"]			= "Chinesisch (Traditionell)";
$pgv_lang["lang_name_chinese-cn"]		= "Chinesisch (Vereinfacht)";
$pgv_lang["lang_name_croatian"]			= "Kroatisch";
$pgv_lang["lang_name_czech"]			= "Tschechisch";
$pgv_lang["lang_name_danish"]			= "Dänisch";
$pgv_lang["lang_name_dutch"]			= "Holländisch";
$pgv_lang["lang_name_english"]			= "Englisch";
$pgv_lang["lang_name_estonian"]			= "Estnisch";
$pgv_lang["lang_name_finnish"]			= "Finnisch";
$pgv_lang["lang_name_french"]			= "Französisch";
$pgv_lang["lang_name_german"]			= "Deutsch";
$pgv_lang["lang_name_greek"]			= "Griechisch";
$pgv_lang["lang_name_hebrew"]			= "Hebräisch";
$pgv_lang["lang_name_hungarian"]		= "Ungarisch";
$pgv_lang["lang_name_indonesian"]		= "Indonesisch";
$pgv_lang["lang_name_italian"]			= "Italienisch";
$pgv_lang["lang_name_lithuanian"]		= "Litauisch";
$pgv_lang["lang_name_norwegian"]		= "Norwegisch";
$pgv_lang["lang_name_polish"]			= "Polnisch";
$pgv_lang["lang_name_portuguese"]		= "Portugiesisch";
$pgv_lang["lang_name_romanian"]			= "Rumänisch";
$pgv_lang["lang_name_russian"]			= "Russisch";
$pgv_lang["lang_name_serbian-la"]		= "Serbisch (Lateinische Buchstaben)";
$pgv_lang["lang_name_slovak"]			= "Slowakisch";
$pgv_lang["lang_name_slovenian"]		= "Slowenisch";
$pgv_lang["lang_name_spanish"]			= "Spanisch";
$pgv_lang["lang_name_spanish-ar"]		= "Spanisch (Latein-Amerika)";
$pgv_lang["lang_name_swedish"]			= "Schwedisch";
$pgv_lang["lang_name_turkish"]			= "Türkisch";
$pgv_lang["lang_name_vietnamese"]		= "Vietnamesisch";
$pgv_lang["lang_name_unknown"]			= "Keine dieser Sprachen";		// used ONLY in "Find Special Characters"
$pgv_lang["lang_new_language"]			= "Neue Sprache";
$pgv_lang["original_lang_name"]			= "Original-Name der Sprache auf #D_LANGNAME#";
$pgv_lang["original_lang_name_help"]	= "~Ursprünglicher Name der Sprache~<br /><br />Wie heißt diese Sprache in dieser Sprache?<br /><br />Englisch nennt sich <b>english</b>; Deutsch nennt sich <b>Deutsch</b>; Niederländisch nennt sich <b>nederlands</b>; Tschechisch nennt sich <b>ceština</b> usw.";
$pgv_lang["lang_shortcut"]				= "Abkürzung für Sprachdateien";
$pgv_lang["lang_shortcut_help"]		= "~#pgv_lang[lang_shortcut]#~<br /><br />Dieses Kürzel wird verwendet, die Sprachdateien dieser Sprache in PhpGedView zu benennen.  Beispielsweise ist das französische Kürzel <b>fr</b>, und folglich sind die französische Dateinamen <i>admin.<b>fr</b>.php</i>, <i>configure_help.<b>fr</b>.php</i>, <i>countries.<b>fr</b>.php</i>, <i>editor.<b>fr</b>.php</i>, <i>facts.<b>fr</b>.php</i>, <i>help_text.<b>fr</b>.php</i>, und <i>lang.<b>fr</b>.php</i>";
$pgv_lang["lang_langcode"]				= "Sprachen Kenncodes";
$pgv_lang["lang_langcode_help"]		= "~#pgv_lang[lang_langcode]#~<br /><br />Mit diesen Codes kann PhpGedView die Einstellung für die bevorzugte Sprache des verwendeten Browsers erkennen. PhpGedView ermittelt die vom Browser geforderte Sprache, indem der Sprachcode des Browsers mit dieser Liste verglichen wird. Einzelne Listeneinträge müssen durch ein Semikolon getrennt werden.";
$pgv_lang["lang_filenames"]				= "Sprach-Dateien";
$pgv_lang["lang_filenames_help"]		= "~#pgv_lang[lang_filenames]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["flagsfile"]					= "Flaggendatei";
$pgv_lang["flagsfile_help"]		= "~#pgv_lang[flagsfile]#~<br /><br />Name der Flaggendatei der gewählten Sprache.<br /><br />Bilder für viele Länder sind von der Site <a href=\"http://w3f.com/gifs/index.html\"><b>The WWWeb Factory</b></a> verfügbar.<br /><br />Wenn Sie ein Flaggenbild finden, das Ihnen gefällt, klicken Sie mit der rechten Maustaste darauf und speichern Sie das Bild in einem temporären Ordner. Danach das gespeicherte Bild mit einem geeigneten Bildeditor (IrfanView wird für Windows-Systeme empfohlen), reduzieren Sie die Größe in PhpGedView auf 50 x 32 Pixel und speichern Sie es dann als GIF-Datei im <i><b>images/flags</b></i> Ordner. Sie können einen beliebigen Namen verwenden.";
$pgv_lang["text_direction"]				= "Schreibrichtung";
$pgv_lang["text_direction_help"]	= "~#pgv_lang[text_direction]#~<br /><br />Gibt an, in welcher Richtung Text in der gewählten Sprache geschrieben wird. Die meisten Sprachen werden von links nach rechts geschrieben. Arabisch und Hebräisch sind Beispiele, die in entgegengesetzter Richtung geschrieben sind (von rechts nach links).";
$pgv_lang["date_format"]				= "Datumsformat";
$pgv_lang["date_format_help"]			= "~#pgv_lang[date_format]#~<br /><br />Dieses Feld beschreibt das Datumsformat für genealogische Angaben. Durch die Wahl entsprechender Buchstaben entweder aus der <b>Standard</b> oder aus der <b>Erweiterten</b> Liste, ist es möglich, das Datumsformat genau zu beschreiben.<ul><li><b>Standard</b><br />Folgende Buchstaben symbolisieren verschiedene Teile der Datumsangabe.  Bitte beachten Sie, dass die Buchstaben <b>D</b> und <b>M</b> in diesem Format andere Bedeutungen haben als im <b>Erweiterten</b> Format.<p style=\"padding-left: 25px\"><b>D</b>&nbsp;&nbsp;Tag des Monats, ohne Null; d.h. 1 bis 31<br /><b>M</b>&nbsp;&nbsp;Monatsname; d.h. Januar, Februar, etc.<br /><b>Y</b>&nbsp;&nbsp;Jahreszahl; z.B. 1999 oder 44v.Chr.<br /><b>R</b>&nbsp;&nbsp;Kalender Umrechnung.  Bitte lesen Sie das Thema <b>Kalender Umrechnung</b>, unten.</p>Diese Buchstaben können in beliebiger Reihenfolge, zusammen mit Leerzeichen und anderer Punktierung angegeben werden.  Als Beispiel nehmen wir an, dass die Datenbank das Datum 20&nbsp;AUG&nbsp;1965 enthält.<p style=\"padding-left: 25px\"><b>Englische</b> Benutzer könnten das Datumsformat mit <b>D&nbsp;M&nbsp;Y</b> beschreiben, um dadurch Datumsangaben wie <b>20&nbsp;August&nbsp;1965</b> zu erhalten.<br /><b>Amerikanische</b> Benutzer könnten das Datumsformat mit <b>M&nbsp;D,&nbsp;Y</b> beschreiben, um dadurch Datumsangaben wie <b>August&nbsp;20,&nbsp;1965</b> zu erhalten.<br /><b>Deutsche</b> Benutzer könnten das Datumsformat mit <b>D.&nbsp;M&nbsp;Y</b> beschreiben, um dadurch Datumsangaben wie <b>20.&nbsp;August&nbsp;1965 zu erhalten.</b><br /><b>Ungarische</b> Benutzer könnten das Datumsformat mit <b>Y.&nbsp;M&nbsp;D.</b> beschreiben, um dadurch Datumsangaben wie <b>1965.&nbsp;augusztus&nbsp;20.</b> zu erhalten.</p><br /></li><li><b>Erweitert</b><br />Komplizierte Datendarstellungen können durch die Wahl anderer Buchstaben bewirklicht werden.  Wenn Sie in Ihrer Format-Angabe andere Buchstaben als nur <b>D</b>, <b>M</b>, <b>Y</b>, oder <b>R</b> benutzen, nimmt das Programm an, dass Sie das <b>Erweiterte</b> Datenformat benutzen möchten.<br /><br />Folgende Buchstaben symbolisieren verschiedene Teile der Datumsangabe.  Bitte beachten Sie, dass die Buchstaben <b>D</b> und <b>M</b> in diesem Format andere Bedeutungen haben als im <b>Standard</b> Format.<p style=\"padding-left: 25px\"><b>d</b>&nbsp;&nbsp;Tag des Monats, mit Null; d.h. 01 bis 31<br /><b>j</b>&nbsp;&nbsp;Tag des Monats, ohne Null; d.h. 1 bis 31<br /><b>S</b>&nbsp;&nbsp;Ordinalangabe des Tages; in Deutschen Daten bedeutungslos, aber als Englisches Beispiel: <b>th</b> wie im Datum <b>4th&nbsp;July</b>.<br /><b>l</b> (kleines »L«)&nbsp;&nbsp;Wochentag; d.h. Montag, Dienstag, etc.<br /><b>D</b>&nbsp;&nbsp;gekürzter Wochentag; d.h. Mo, Di, Mi, Do, F, Sa, So<br /><b>N</b>&nbsp;&nbsp;Wochentag, nach dem ISO Standard; d.h. 0 bis 6<br /><b>w</b>&nbsp;&nbsp;Wochentag, als Ziffer; d.h. 1 bis 7<br /><b>z</b>&nbsp;&nbsp;Jahrestag; d.h. 1 bis 365 oder 366<br /><b>F</b>&nbsp;&nbsp;Monatsname; d.h. Januar, Februar, etc.<br /><b>M</b>&nbsp;&nbsp;gekürzter Monatsname, d.h. Ja, Fe, etc.<br /><b>m</b>&nbsp;&nbsp;Monat, mit Null; d.h. 01 bis 12<br /><b>n</b>&nbsp;&nbsp;Monat, ohne Null; d.h. 1 bis 12<br /><b>Y</b>&nbsp;&nbsp;Jahreszahl; z.B. 1999 oder 44v.Chr.<br /><b>y</b>&nbsp;&nbsp;gekürztes Jahr.  Manche Kalender erlauben das Kürzen der Jahreszahl.  Im Jüdischen Kalender kann die Tausender-Zahl fortgelassen werden.  Im Gregorianischen Kalender ist die Kürzung der Jahreszahl nicht erlaubt, und deshalb funktioniert <b>y</b> genau wie <b>Y</b> wenn solche Daten dargestellt werden sollen.<br /><b>R</b>&nbsp;&nbsp;Kalender Umrechnung.  Bitte lesen Sie das Thema <b>Kalender Umrechnung</b>, unten.<br /><b>@&nbsp;A&nbsp;O&nbsp;E</b>&nbsp;&nbsp;Darstellung der einzelnen Datumsteile im internen Format der Datenbank.</p><p style=\"padding-left: 50px\"><b>@</b>&nbsp;&nbsp;Kalender-Code, z.B. @#DGREGORIAN@, @#DHEBREW@, etc.<br /><b>A</b>&nbsp;&nbsp;Tag des Monats, mit Null; d.h. 01 bis 31<br /><b>O</b>&nbsp;&nbsp;Monat, z.B. JAN, FEB, MAR, etc.<br /><b>E</b>&nbsp;&nbsp;Jahreszahl; z.B. 1999<br /><br />Um die rohen Daten zu sehen, sollten Sie <b>A&nbsp;O&nbsp;E</b> oder <b>@&nbsp;A&nbsp;O&nbsp;E</b> als Datumsformat eingeben.</p><b>Einige Beispiele</b> des Datums 08&nbsp;SEP&nbsp;1965:<p style=\"padding-left: 25px\"><b>d&nbsp;M&nbsp;Y</b> = 08&nbsp;Sep&nbsp;1965<br /><b>D&nbsp;j&nbsp;F&nbsp;Y</b> = Mi&nbsp;8&nbsp;September&nbsp;1965<br /><b>j&nbsp;M&nbsp;y</b> = 8&nbsp;Sep&nbsp;65<br /><b>l&nbsp;-&nbsp;d&nbsp;-&nbsp;F&nbsp;-&nbsp;Y</b> = Mittwoch&nbsp;-&nbsp;08&nbsp;-&nbsp;September&nbsp;-&nbsp;1965<br /><b>y/m/d</b> = 1965/09/08</p><br /></li></ul>#pgv_lang[date_format_help2]#";
$pgv_lang["date_format_help2"]			= "<ul><li><b>Kalender Umrechnung</b><br />Das <b>R</b> Code hat eine etwas ungewöhnliche Funktion.  Wenn dieses Code im Datums-Format vorhanden ist, wird das normale Datum ein zweites Mal, aber in einem anderen Kalendersystem dargestellt.  Die Elemente dieser zweiten Darstellung, die immer zwischen Klammern gezeigt wird, folgen den Regeln wie sie vom restlichen Datums-Format bestimmt sind.  Die Beispiele des Themas <b>Kalender der Französchen Republik</b> erklären dieses hoffentlich etwas besser.<br /><br />Die Umrechnung des Kalenders wird von der aktuellen Sprache bestimmt.  Wenn die Hebräische Sprache gewählt ist, werden alle normale Daten ein zweites mal im <b>Jüdischen Kalender</b> gezeigt.  Wenn die Arabische Sprache gewählt ist, werden alle normale Daten ein zweites mal im <b>Hijri Kalender</b> gezeigt.  In allen anderen Fällen folgt die zweite Darstellung im <b>Kalender der französchen Republik</b>.<br /><br />Das <b>R</b> Code hat eine ähnliche Folge wie die die Kalender-Wahl in der GEDCOM Konfiguration.  Der Unterschied ist dass das <b>R</b> Code, da es in den Sprachen konfiguriert wird, nur in gewählten Sprachen, aber in allen Datenbanken funktioniert, während die Kalender-Wahl, da sie in einzelnen GEDCOM-Konfigurationen gemacht wird, in allen Sprachen der jeweiligen GEDCOM funktioniert.<br /><ul><li><b>Kalender der französichen Republik</b><br />Außer einer kurzen Zeit im Mai 1871, war dieses Kalendersystem nur in Frankreich und zwischen dem 22.&nbsp;September&nbsp;1792 und dem 31.&nbsp;Dezember&nbsp;1805 in täglichem Gebrauch.  Deshalb sind nur Daten aus diesem Bereich im Kalender der französischen Republik möglich.<br /><br />Angenommen dass die Englische Sprache aktuell ist, hier sind einige Beispiele:<br />Das Datumsformat <b>Y.m.d&nbsp;R</b> könnte <b>1805.04.26&nbsp;(XIII.08.06)</b> oder <b>1806.01.01</b> als Resultat haben;&nbsp; <b>j&nbsp;F&nbsp;Y&nbsp;R</b> könnte <b>13&nbsp;October&nbsp;1797&nbsp;(22&nbsp;Vendémiaire&nbsp;VI)</b> oder <b>1&nbsp;January&nbsp;1806</b> als Resultat haben.</li></ul><br /></li><li><b>Sprachen Änderungen</b><br />Die gekürzten Texte der Codes <b>D</b> und <b>M</b> des erweiterten Formats befinden sich in der Datei <i>languages/lang.xx.php</i> wie, zum Beispiel,<br /><code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"Su\";<br />\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"April\";</code><br /><br />Sie haben die Möglichkeit, diese Abkürzungen durch Einträge in der Datei <i>languages/extra.xx.php</i> zu ändern.  Diese besondere Datei, und wie sie genutzt werden kann, ist auführlich in Wiki und der readme Datei beschrieben.  Zum Beispiel:<br /><code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"Sonn\";<br />\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"Apr\";</code></li><br /><li><b>Besondere Regeln</b><br />Besondere Regeln über Daten sind in einigen Sprachen üblich.  Diese besonderen Regeln sind durch verschiedene <i>includes/extras/functions.xx.php</i> programmiert.</li></ul>";
$pgv_lang["time_format"]				= "Zeitformat";
$pgv_lang["time_format_help"]			= "~#pgv_lang[time_format]#~<br /><br />Dieses Feld definiert das Zeitformat, das von PhpGedView verwendet werden soll.<br /><br />Folgende Symbole können verwendet werden:<br /><b>a</b> - klein geschrieben Ante meridiem und Post meridiem; d.h. <b>am</b> oder <b>pm</b><br /><b>A</b> - groß geschrieben Ante meridiem und Post meridiem; d.h. <b>AM</b> oder <b>PM</b><br /><b>B</b> - Swatch Internet Zeit; d.h. <b>000</b> bis <b>999</b><br /><b>c</b> - ISO 8601 Datum; z.B. <b>2004-02-12T15:19:21+00:00</b><br /><b>d</b> - Tag des Monats, 2 Ziffern, führende Null; d.h. <b>01</b> bis <b>31</b><br /><b>D</b> - Tag, Text, drei Buchstaben; z.B. <b>Mon</b><br /><b>F</b> - Monat, Text, lang; z.B. <b>Januar</b><br /><b>g</b> - Stunde, 12-Stunden-Format, keine führende Null; d.h. <b>1</b> bis <b>12</b><br /><b>G</b> - Stunde, 24-Stunden-Format, keine führende Null; d.h. <b>0</b> bis <b>23</b><br /><b>h</b> - Stunde, 12-Stunden-Format, führende Null; d.h. <b>01</b> bis <b>12</b><br /><b>H</b> - Stunde, 24-Stunden-Format, führende Null; d.h. <b>00</b> bis <b>23</b><br /><b>i</b> - Minuten, führende Null; d.h. <b>00</b> bis <b>59</b><br /><b>I</b> (Großes »i«) - Sommerzeitanzeige; <b>1</b> bei Sommerzeit, <b>0</b> andernfalls.<br /><b>j</b> - Tag des Monats, keine führende Null; d.h. <b>1</b> bis <b>31</b><br /><b>l</b> (Kleines »L«) - Wochentag, Text, lang; z.B. <b>Freitag</b><br /><b>L</b> - Schaltjahrindikator; <b>1</b> wenn es ein Schaltjahr ist, <b>0</b> andernfalls.<br /><b>m</b> - Monat, numerisch, führende Null; d.h. <b>01</b> bis <b>12</b><br /><b>M</b> - Monat, Text, 3 Buchstaben; z.B. <b>Jan</b><br /><b>n</b> - Monat, numerisch, keine führende Null; d.h. <b>1</b> bis <b>12</b><br /><b>O</b> (Großes »o«) - Differenz zwischen lokaler und Greenwich-Zeit (GMT) in Stunden; z.B. <b>+0200</b><br /><b>r</b> - Datum, nach RFC 2822 formatiert; z.B. <b>Do,&nbsp;21&nbsp;Dez&nbsp;2000&nbsp;16:01:07&nbsp;+0200</b><br /><b>s</b> - sSekunden, führende Null; d.h. <b>00</b> bis <b>59</b><br /><b>S</b> - Tag des Monats-Suffix, nur Englisch, 2 Zeichen; d.h. <b>st</b>, <b>nd</b>, <b>rd</b> oder <b>th</b>. Funktioniert gut mit <b>j</b><br /><b>t</b> - Anzahl der Tage im angegebenen Monat; d.h. <b>28</b> bis <b>31</b><br /><b>T</b> - Zeitzoneneinstellung dieser Maschine; z.B. <b>CEST</b>, <b>EST</b>, <b>MDT</b><br /><b>U</b> - Sekunden seit dem Start der Unix-Epoche (1.&nbsp;Januar&nbsp;1970&nbsp;00:00:00 GMT)<br /><b>w</b> - Wochentag, numerisch; d.h. <b>0</b> (Sonntag) bis <b>6</b> (Samstag)<br /><b>W</b> - ISO 8601 Wochenzahl des Jahres, Wochen ab Montag; z.B. <b>42</b> (die 42. Woche im Jahr)<br /><b>Y</b> - Jahr, 4 Ziffern; z.B. <b>1999</b><br /><b>y</b> - Jahr, 2 Ziffern; z.B. <b>99</b><br /><b>z</b> - Tag des Jahres, numerisch, keine führenden Nullen; d.h. <b>0</b> (1. Jan) bis <b>364</b> (31. Dez wenn nicht ein Schaltjahr) or <b>365</b> (31. Dez in Schaltjahren)<br /><b>Z</b> - Zeitzonenversatz in Sekunden. Der Versatz für Zeitzonen westlich von Greenwich ist immer negativ, und für diejenigen östlich von Greenwich ist der Versatz immer positiv. d.h. <b>-43200</b> bis <b>43200</b><br /><br />Sie können die Reihenfolge dieser Symbole ändern und dem Format Trennzeichen hinzufügen.<br />In Deutsch enthält dieses Feld normalerweise <b>H:i:s</b> um ein Display wie <b>09:01:25</b> zu erzeugen.<br />Englisch definiert normalerweise das Zeitformat als <b>g:i:sa</b> um ein Display wie <b>9:01:25am</b> zu erzeugen.<br /><br />Im 24-Stunden-System ist Mitternacht 00:00. Im 12-Stunden-System ist Mitternacht 12:00am und Mittag 12:00pm.";
$pgv_lang["week_start"]					= "1. Tag der Woche";
$pgv_lang["week_start_help"]			= "~#pgv_lang[week_start]#~<br /><br />Der Tag der Woche, mit dem in diesem Sprachraum eine neue Woche beginnt. In vielen Sprachen beginnt die Woche Sonntags, aber in anderen auch am Montag oder an anderen Tagen.";
$pgv_lang["name_reverse"]				= "Nachname zuerst";
$pgv_lang["name_reverse_help"]			= "~#pgv_lang[name_reverse]#~<br /><br />In einigen Sprachen wird üblicherweise der Nachname vor den Vornamen gestellt, während er normalerweise hinten steht. Wählen Sie diese Option, um den Nachnamen zuerst zu zeigen.";
$pgv_lang["ltr"]						= "Links nach rechts";
$pgv_lang["rtl"]						= "Rechts nach links";
$pgv_lang["file_does_not_exist"]		= "FEHLER! Diese Datei existiert nicht...";
$pgv_lang["optional_file_not_exist"]	= "Diese nicht erforderliche Datei fehlt.";
$pgv_lang["alphabet_upper"]				= "Alphabet Großbuchstaben";
$pgv_lang["alphabet_upper_help"]	= "~#pgv_lang[alphabet_upper]#~<br /><br />Großbuchstaben in dieser Sprache. Dieses Alphabet wird beim Sortieren von Namenslisten verwendet.";
$pgv_lang["alphabet_lower"]				= "Alphabet Kleinbuchstaben";
$pgv_lang["alphabet_lower_help"]	= "~#pgv_lang[alphabet_lower]#~<br /><br />Kleinbuchstaben in dieser Sprache. Dieses Alphabet wird beim Sortieren von Namenslisten verwendet.";
$pgv_lang["multi_letter_alphabet"]		= "Mehrstelliges Alphabet";
$pgv_lang["multi_letter_alphabet_help"]	= "~#pgv_lang[multi_letter_alphabet]#~<br /><br />Mehrstellige Buchstaben, die zusammen als ein Buchstabe behandelt werden.<br /><br />Einige Sprachen, wie Ungarisch und Slowakisch, behandeln einige Buchstaben, die in einer bestimmten Reihenfolge vorkommen, als ob sie ein einziger Buchstabe wären.  Die Reihenfolge, in der Sie diese mehrstelligen Buchstaben eingeben, bestimmt die Reihenfolge in der diese in das normale Alphabet zum Sortieren eingefügt werden.  Außer <b>ch</b>, werden diese mehrstelligen Buchstaben immer entspechend deren Anfangsbuchstaben in das normale Alphabet eingefügt.  Die Kombination <b>ch</b> wird immer hinter <b>h</b> eingefügt.";
$pgv_lang["multi_letter_equiv"]			= "Mehrstellige Äquivalente";
$pgv_lang["multi_letter_equiv_help"]	= "~#pgv_lang[multi_letter_equiv]#~<br /><br />In manchen Sprachen werden einige sich folgende Buchstaben in Listen so behandelt, als ob sie ein einstelliger Buchstabe wären.<br /><br />Zum Beispiel, in der Holländischen Sprache werden Namen, die <b>IJ</b> enthalten, so behandelt als ob diese Kombination der Buchstabe <b>Y</b> wäre.  Im Norwegischen wird die Kombination <b>Aa</b> als <b>&Aring;</b> behandelt.  In anderen Sprachen kann man einige Buchstabenkombinationen auch as ein enzelnen Buchstaben schreiben.  Zum Beispiel, im Deutschen sind <b>ss</b> und <b>ß</b> sich gleich; gleichfalls <b>ae</b> und <b>ä</b>, usw.<br /><br />Wenn Sie solche Äquivalente hier eingeben, sorgen Sie dafür, dass in Listen Namen mit diesen Anfangsbuchstaben zusammen aufgeführt sind.  Da einige Datenbank-Systeme den UTF-8 Zeichensatz nur schwach unterstützen, sollten Sie hier die Äquivalenten in Groß- und Kleinschrift eingeben.<br /><br />Zum Beispiel: <b>Aa=&Aring;,aa=&aring;</b>";
$pgv_lang["dictionary_sort"]			= "Benutze Wörterbuch-Regeln zum Sortieren";
$pgv_lang["dictionary_sort_help"]		= "~#pgv_lang[dictionary_sort]#~<br /><br />Diese Option bestimmt, wie Buchstaben mit diakritischen Zeichen während dem Sortieren behandelt werden sollen.<br /><br />Wenn <b>#pgv_lang[yes]#</b> gewählt ist, werden alle Buchstaben so behandelt, als ob diese diakritischen Zeichen fehlten.  Die diakritischen Zeichen haben nur Bedeutung, wenn die beiden zu sortierende Wörter ohne diese Zeichen gleich sind.  Die Wahl <b>#pgv_lang[no]#</b> bedeutet, dass keine Rücksicht auf diakritische Zeichen genommen werden soll, und dass alle Buchstaben, mit oder ohne Zeichen, verschieden sind.";
$pgv_lang["collation"]					= "Sortiersystem der Datenbank";
$pgv_lang["collation_help"]				= "~#pgv_lang[collation]#~<br /><br />Wenn Sie das im Datenbank-System eingebaute Sortiersystem benutzen möchten, geben Sie hier den Namen des Sortiersystems ein.  Sie müssen sicher sein, dass die Datenbank das von Ihnen bestimmte Sortiersystem auch unterstützt.<br /><br />Ob oder ob nicht das Sortiersystem der Datenbank benutzt werden darf wird in der Konfiguration der Site bestimmt.";
$pgv_lang["lang_config_write_error"]	= "Fehler beim Versuch, die Spracheinstellungen in die Datei <i>language_settings.php</i> zu schreiben. Prüfen Sie die Zugriffsrechte und probieren Sie es erneut.";
$pgv_lang["lang_set_file_read_error"]	= "F E H L E R !!! Die Datei <i>language_settings.php</i> konnte nicht gelesen werden!";
$pgv_lang["add_new_language_help"]		= "~#pgv_lang[add_new_language]#~<br /><br />#pgv_lang[add_new_language_desc]#";
$pgv_lang["add_new_language_desc"]		= "Mit Hilfe dieser Option können Sie neue Sprachen in PhpGedView unterstützen.<br /><br />Sie können die Standard-Einstellungen der neuen Sprache eingeben.  Diese Einstellungen sind, unter Anderen, das Sprach-Code, die Schreibrichtung, Wochenanfang, Format des Datums und der Uhrzeit, Alphabet, usw.<br /><br />Se erhalten mehr Hilfe über die Optionen der neuen Sprache nachdem Sie den <b>#pgv_lang[add_new_lang_button]#</b> Button geklickt haben.<br /><br />Mehr Hilfe ist auf der Konfigurations-Seite der neuen Sprache erhältlich.";
$pgv_lang["add_new_lang_button"]		= "Neue Sprache hinzufügen";
$pgv_lang["hide_translated"]			= "Übersetzte Texte verstecken";
$pgv_lang["hide_translated_help"]		= "~#pgv_lang[hide_translated]#~<br /><br />Wenn <b>#pgv_lang[yes]#</b> eingestellt ist, werden nur die Texte der gewählten Sprachdatei gezeigt, die noch nicht übersetzt sind. Dies bedeutet, dass der neue Text <u>noch nicht</u> in der Zielsprachendatei vorhanden ist.<br /><br />Einige Sprachdateien enthalten englischen Text für verschiedene nicht übersetzte Meldungen. Diese Routine kann diese nicht übersetzten Texte nicht identifizieren, da sie bereits in der Zieldatei vorhanden sind. Die Annahme lautet: »Wenn die Meldung in der Zieldatei vorhanden ist, muss sie übersetzt worden sein.«";
$pgv_lang["lang_file_write_error"]		= "F E H L E R !!! Die Änderungen können nicht in die gewählte Sprachdatei geschrieben werden!<br /><br />Prüfen Sie die Schreibrechte für (#lang_filename#).";
$pgv_lang["no_open"]					= "F E H L E R !!! Die Datei #lang_filename# kann nicht geöffnet werden.";
$pgv_lang["users_langs"]				= "Sprache des Benutzers";
$pgv_lang["configured_languages"]		= "Benutzte Sprachen";

//-- User Migration Tool messages
$pgv_lang["um_header"]					= "Benutzerdaten Migrations-Werkzeug";
$pgv_lang["um_proceed"] = "Wählen Sie eine Option oder klicken Sie auf dem folgenden Link, um zum Verwaltungsmenü zurückzukehren";
$pgv_lang["um_creating"]				= "Erstellen";
$pgv_lang["um_sql_index"]				= "Dieses Werkzeug erstellt die <i>authenticate.php</i> und verschiedene andere <i>.dat</i> Dateien im »index« Verzeichnis.<br /><br />Wenn erfolgreich, können Sie das Programm auf den Index-Modus umstellen.  Alle Benutzer und deren Nachrichten, Lesezeichen, persönliche Einstellungen, und Layout der persönlichen Begrüßungsseite sind dann bereit.<br /><br />Bitte beachten Sie:  Nachdem Sie das Programm auf den Index-Modus umgestellt haben, müssen Sie die GEDCOM-Datei neu importieren oder neu hochladen.";
$pgv_lang["um_file_create_fail1"] 		= "Die neue Datei konnte nicht erstellt werden, weil eine Datei mit gleichem Namen bereits existiert:";
$pgv_lang["um_file_create_fail2"] 		= "Erstellen fehlgeschlagen";
$pgv_lang["um_file_create_fail3"] 		= "Prüfen Sie die Zugriffsrechte dieses Verzeichnisses.";
$pgv_lang["um_file_create_succ1"] 		= "Erstellen der neuen Datei erfolgreich:";
$pgv_lang["um_file_not_created"]		= "Datei wurde nicht erstellt.";
$pgv_lang["um_nomsg"]					= "Es liegen keine Nachrichten vor.";
$pgv_lang["um_nofav"]					= "Es sind keine Lesezeichen vorhanden.";
$pgv_lang["um_nonews"]					= "Es liegen keine Neuigkeiten vor.";
$pgv_lang["um_noblocks"]				= "Es sind keine Blöcke vorhanden.";
$pgv_lang["um_index_sql"]				= "Dieses Werkzeug importiert die Datei <i>authenticate.php</i> und andere <i>.dat</i> Dateien in die Datenbank.";
$pgv_lang["um_noaction"]				= "Nichts ist zu tun, um Benutzerinformationen vom Index-Modus in den Datenbank-Modus einzuführen.<br /><br />Nachdem das PhpGedView-System auf den Datenbank-Modus umgestellt ist, müssen Sie das Programm neu starten, und danach das <b>#pgv_lang[um_header]#</b> benutzen, um alle Benutzer-Daten in die Datenbank einzuführen.  PhpGedView benutzt dafür die Dateien des Index-Modus.<br /><br /><b>Die <i>authenticate.php</i> und <i>.dat</i> Dateien dürfen während der Umstellung <u>nicht</u> entfernt werden.</b>";
$pgv_lang["um_import"] = "Import";
$pgv_lang["um_export"] = "Export";
$pgv_lang["um_explain"]					= "Dieses Werkzeug dient zum Exportieren der Benutzerdaten vom Datenbank-Modus zum Index-Modus oder umgekehrt.<br /><br />Benutzerdaten, Lesezeichen, individuelle Block-Konfigurationen, Nachrichten, usw. werden nach der Umstellung wieder zugänglich sein.<br /><br /><b>VORSICHT</b><br />Dieses Werkzeug kann <b>nur</b> zum Umstellen zwischen dem Index und dem Datenbank-Modus der <u>gleichen</u> Version benutzt werden.<br /><br /><b>IMPORT</b><br />Wenn Sie die Benutzer-Dateien aus dem Index-Modus in den Datenbank-Modus importieren, werden alle bereits in der Datenbank vorhandenen Benutzerdaten <u>überschrieben</u>. Dieses Werkzeug ist <u>nicht</u> dazu geeignet, beide Datentypen zusammenzufügen. Nachdem Sie die Benutzerdaten importiert haben, ist es nicht mehr möglich, die alten Daten der Datenbank zu retten.<br /><br /><b>EXPORT</b><br />Wenn Sie die Benutzerdaten der Datenbank in Dateien des Index-Modus exportieren, erstellt dieses Werkzeug die <i>authenticate.php</i> und einige <i>.dat</i> Dateien.  Dafür wird das »index« Verzeichnis benutzt.  Falls gleichnamige Dateien dort bereits vorhanden sind, werden Sie gefragt, ob Sie diese Dateien überschreiben möchten. Nach dem Umstellen auf den Index-Modus sind alle Informationen direkt zugreifbar.<br /><br /><b>Bitte beachten Sie:</b> Nach dem Umstellen müssen Sie die GEDCOM-Datei importieren oder neu hochladen.";
$pgv_lang["um_tool_help"]				= "~#pgv_lang[um_header]#~<br /><br />#pgv_lang[um_explain]#";
$pgv_lang["um_sql_index_help"]			= "~Benutzer-Datei auf den Index-Modus umstellen~<br /><br />#pgv_lang[um_sql_index]#";
$pgv_lang["um_index_sql_help"]			= "~Benutzer-Datei auf den SQL Modus umstellen~<br /><br />#pgv_lang[um_index_sql]#";
$pgv_lang["um_imp_users"]				= "Benutzer werden importiert";
$pgv_lang["um_imp_blocks"]				= "Blocks werden importiert";
$pgv_lang["um_imp_favorites"]			= "Lesezeichen werden importiert";
$pgv_lang["um_imp_messages"]			= "Mitteilungungen werden importiert";
$pgv_lang["um_imp_news"]				= "Nachrichten werden importiert";
$pgv_lang["um_nousers"]					= "Die <i>authenticate.php</i> Datei ist nicht in dem »index« Verzeichnis vorhanden.  Das Umstellen wird abgebrochen.";
$pgv_lang["um_imp_succ"]				= "Import erfolgreich";
$pgv_lang["um_imp_fail"]				= "Import gescheitert";
$pgv_lang["um_backup"]					= "Sicherheits-Kopie";
$pgv_lang["um_zip_succ"]				= "ZIP-Datei erstellt.";
$pgv_lang["um_zip_dl"]					= "ZIP Sicherheits-Kopie herunterladen";
$pgv_lang["um_bu_explain"]				= "Dieses Tool wird benutzt, Sicherheitskopien bestimmter Dateien oder Tabellen aus der Datenbank zu machen.<br /><br />Die Daten, die Sie dafür wählen werden in einer ZIP-Datei gesammelt.  Diese ZIP-Datei können Sie dann herunterladen, indem Sie das entsprechende Link unten auf der Seite klicken.<br /><br />Die erstellte ZIP-Datei bleibt in dem »index« Verzeichnis bis Sie sie löschen.";
$pgv_lang["um_bu_help"]					= "~#pgv_lang[um_backup]#~<br /><br />#pgv_lang[um_bu_explain]#";
$pgv_lang["um_bu_config"]				= "PhpGedView Konfigurationsdatei";
$pgv_lang["um_bu_gedcoms"]				= "GEDCOM-Dateien";
$pgv_lang["um_bu_gedsets"]				= "GEDCOM Einstellungen-, Konfiguration-, und Privatsphären-Dateien";
$pgv_lang["um_bu_logs"]					= "GEDCOM SearchLog-, und LogFile-Dateien";
$pgv_lang["um_bu_usinfo"]				= "Benutzer-Dateien, Konfiguration der Blöcke, Lesezeichen, Nachrichten, und Notizen";
$pgv_lang["um_bu_media"]				= "Medien-Dateien";
$pgv_lang["um_mk_bu"]					= "Sicherheits-Kopie erstellen";
$pgv_lang["um_nofiles"]					= "Keine Dateien für Sicherheitskopie gefunden.";
$pgv_lang["um_files_exist"] 			= "Möchten Sie bereits bestehenden Ausgangs-Dateien überschreiben?";
$pgv_lang["um_results"]					= "Ergebnisse";
$pgv_lang["preview_faq_item"]			= "FAQ-Einträge vorschauen";
$pgv_lang["preview_faq_item_help"]		= "~#pgv_lang[preview_faq_item]#~<br /><br />Diese Option ermöglicht Ihnen, die FAQ Liste ohne Bearbeitungsoptionen zu sehen.<br /><br />Abgesehen von einem <b>Bearbeiten</b> Link als Überschrift vor dem ersten FAQ Eintrag, ist die Darstellung der FAQ-Seite genau wie sie einem gewöhnlichen Benutzer gezeigt wird. Mit diesem <b>Bearbeiten</b> Link können Sie alle FAQ-Bearbeitungsoptionen wiederherstellen.";
$pgv_lang["restore_faq_edits"]			= "FAQ-Editieren erlauben";
$pgv_lang["restore_faq_edits_help"]		= "~#pgv_lang[restore_faq_edits]#~<br /><br />Diese Option stellt die FAQ-Seite zurück auf die normale Verwalter-Ansicht, mit allen FAQ-Bearbeitungsoptionen.";
$pgv_lang["add_faq_item"]				= "FAQ Eintrag hinzufügen";
$pgv_lang["add_faq_item_help"]			= "~#pgv_lang[add_faq_item]#~<br /><br />Mit dieser Option können Sie einen Eintrag der FAQ-Liste hinzufügen.";
$pgv_lang["edit_faq_item"]				= "FAQ-Eintrag bearbeiten";
$pgv_lang["edit_faq_item_help"]			= "~#pgv_lang[edit_faq_item]#~<br /><br />Mit dieser Option können Sie einen bereits bestehenden FAQ-Eintrag bearbeiten.";
$pgv_lang["delete_faq_item"]			= "FAQ-Eintrag löschen";
$pgv_lang["delete_faq_item_help"]		= "~#pgv_lang[delete_faq_item]#~<br /><br />Mit dieser Option können Sie einen FAQ-Eintrag löschen.";
$pgv_lang["moveup_faq_item"]			= "FAQ-Eintrag nach oben verschieben";
$pgv_lang["moveup_faq_item_help"]		= "~#pgv_lang[moveup_faq_item]#~<br /><br />Diese Option ermöglicht Ihnen, die Reihenfolge der FAQ-Einträge zu ändern.<br /><br />Jedes Mal, wenn Sie diese Option benutzen, wird die Ordnungsnummer dieses Eintrages um <b>1</b> verringert.  Anstatt dieser Option, können Sie auch den Eintrag bearbeiten, und das Feld »FAQ Reihenfolge« direkt ändern.  Wenn mehrere Einträge die selbe Ordnugsnummer haben, ist nur einer dieser Einträge sichtbar.  Welcher Eintrag dann sichtbar ist, ist unbestimmt.";
$pgv_lang["movedown_faq_item"]			= "FAQ-Eintrag nach unten verschieben";
$pgv_lang["movedown_faq_item_help"]		= "~#pgv_lang[movedown_faq_item]#~<br /><br />Diese Option ermöglicht Ihnen, die Reihenfolge der FAQ-Einträge zu ändern.<br /><br />Jedes Mal, wenn Sie diese Option benutzen, wird die Ordnungsnummer dieses Eintrages um <b>1</b> erhöht.  Anstatt dieser Option, können Sie auch den Eintrag bearbeiten, und das Feld »FAQ Reihenfolge« direkt ändern.  Wenn mehrere Einträge die selbe Ordnugsnummer haben, ist nur einer dieser Einträge sichtbar.  Welcher Eintrag dann sichtbar ist, ist unbestimmt.";
$pgv_lang["add_faq_header_help"]		= "~#pgv_lang[add_faq_header]#~<br /><br />Titel oder Thema des FAQ-Eintrages.<br /><br />Ihre Eingabe kann formatiert werden. HTML-Befehle wie &lt;b&gt; und &lt;br&gt; sowie HTML-Einheiten wie &amp;amp; und &amp;nbsp; sind erlaubt. HTML-Befehle anders als &lt;br /&gt; sind wahrscheinlich nicht sehr nützlich im FAQ-Titel und sollten vermieden werden.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["add_faq_body_help"]			= "~#pgv_lang[add_faq_body]#~<br /><br />Text des FAQ-Eintrages.<br /><br />Ihre Eingabe kann formatiert werden. HTML-Befehle wie &lt;b&gt; und &lt;br&gt; sowie HTML-Einheiten wie &amp;amp; und &amp;nbsp; sind erlaubt.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["add_faq_HTML"]				= "HTML-Einheiten ermöglichen das leichte Eingeben besonderer Zeichen.  Sie können solche Zeichen symbolisch oder als Dezimal- oder Hexadezimalnummern eingeben.  Die komplette Liste aller HTML-Einheiten, deren symbolische Codes, und Dezimal- und Hexadezimal Äquivalente, sowie deren Darstellungen in Ihrem Browser erhalten Sie hier: <a href=\"http://htmlhelp.com/reference/html40/entities/\" target=\"_blank\">HTML-Einheiten</a><br /><br />Gelegentlich möchten Sie bestimmt das Tilde-Zeichen&nbsp;&nbsp;<b>&#x7E;</b>&nbsp;&nbsp;oder ein Nummern-Zeichen&nbsp;&nbsp;<b>&#x23;</b>&nbsp;&nbsp;in URLs oder Text eingeben.  Diese Zeichen haben für das PhpGedView Hilfe-System besondere Bedeutung und können deshalb nur als Dezimal- oder Hexadezimalnummern eingegeben werden. Die Zeichen&nbsp;&nbsp;<b>&lt;</b>&nbsp;&nbsp;und&nbsp;&nbsp;<b>&gt;</b>&nbsp;&nbsp;, die gewöhnlich HTML-Befehle umgeben, können ebenfalls nur als Dezimal- oder Hexadezimalnummern eingegeben werden wenn sie nicht als HTML-Befehle sondern als Text erkannt werden sollen.<ul><li>Eingabe: <b>&amp;&#x23;35;</b>&nbsp;&nbsp;oder&nbsp;&nbsp;<b>&amp;&#x23;x23;</b>&nbsp;&nbsp;Resultat:&nbsp;&nbsp;<b>&#x23;</b></li><li>Eingabe: <b>&amp;&#x23;60;</b>&nbsp;&nbsp;oder&nbsp;&nbsp;<b>&amp;&#x23;x3C;</b>&nbsp;&nbsp;Resultat:&nbsp;&nbsp;<b>&#x3C;</b></li><li>Eingabe: <b>&amp;&#x23;62;</b>&nbsp;&nbsp;oder&nbsp;&nbsp;<b>&amp;&#x23;x3E;</b>&nbsp;&nbsp;Resultat:&nbsp;&nbsp;<b>&#x3E;</b></li><li>Eingabe: <b>&amp;&#x23;126;</b>&nbsp;&nbsp;oder&nbsp;&nbsp;<b>&amp;&#x23;x7E;</b>&nbsp;&nbsp;Resultat:&nbsp;&nbsp;<b>&#x7E;</b></li></ul>Die&nbsp;&nbsp;<b>&amp;tilde;</b>&nbsp;&nbsp;HTML-Einheit wird <u>nicht</u> als Tilde-Zeichen in URLs erkannt.";
$pgv_lang["add_faq_pgvLangRefs"]		= "Sie können im Text Einträge der Sprach-Dateien oder den Wert verschiedener Global-Variablen einfügen.  Beispiele:<ul><li><b>&#x23;pgv_lang[add_to_cart]&#x23;</b>&nbsp;&nbsp;&nbsp; erwähnt den Sprach-Variable \$pgv_lang[\"add_to_cart\"], und wenn so erwähnt, wird der Text mit <b>#pgv_lang[add_to_cart]#</b> ergänzt wenn die FAQ-Seite in der aktuellen Sprache dargestellt wird.</li><li><b>&#x23;factarray[AFN]&#x23;</b>&nbsp;&nbsp;&nbsp;erwähnt den Fakt-Namen \$factarray[\"AFN\"], und wenn so erwähnt, wird der Text mit <b>#factarray[AFN]#</b> ergänzt wenn die FAQ-Seite in der aktuellen Sprache dargestellt wird.</li><li><b>&#x23;PGV_VERSION&#x23;&nbsp;&#x23;PGV_VERSION_RELEASE&#x23;</b>&nbsp;&nbsp;&nbsp;erwähnt den Konstanten PGV_VERSION, ein Leerzeichen, und dann den Konstanten PGV_VERSION_RELEASE, und wenn so erwähnt, wird der Text mit <b>#PGV_VERSION#&nbsp;#PGV_VERSION_RELEASE#</b> ergänzt wenn die FAQ-Seite in der aktuellen Sprache dargestellt wird.</li><li><b>&#x23;GLOBALS[GEDCOM]&#x23</b>&nbsp;&nbsp;&nbsp;erwähnt den globalen Variable \$GEDCOM, (Name der aktuellen GEDCOM-Datei), und wenn so erwähnt, wird der Text mit <b>#GLOBALS[GEDCOM]#</b> ergänzt.</li><li><b>&#x23;GLOBALS[GEDCOM_TITLE]&#x23</b>&nbsp;&nbsp;&nbsp;erwähnt den globalen Variable \$GEDCOM_TITLE, (Titel der aktuellen GEDCOM-Datei), und wenn so erwähnt, wird der Text mit <b>#GLOBALS[GEDCOM_TITLE]#</b> ergänzt.</li></ul><br /><br />So können Sie FAQ-Listen erstellen, die sich nach der aktuellen Sprache richten.  Sie sollten Ihre eigenen FAQ-Titel und FAQ-Hauptteile in die <i>languages/extra.xx.php</i> Dateien (<i>xx</i> ist das Code der jeweiligen Sprache) im folgenden Format eingeben:<br /><br /><code>\$pgv_lang[\"faq_title1\"]&nbsp;=&nbsp;\"Beispiel eines FAQ-Titels\";<br />\$pgv_lang[\"faq_body1\"]&nbsp;=&nbsp;\"Beispiel eines FAQ-Hauptteils.\";</code>";
$pgv_lang["add_faq_order_help"]			= "~#pgv_lang[add_faq_order]#~<br /><br />Dieser Eintrag bestimmt die Reihenfolge, in der die FAQ-Einträge auf der FAQ-Seite dargestellt werden.<br /><br />Es ist nicht nötig, die Nummern sequentiell und ohne Löcher einzutragen.  Wenn die Reihenfolge der von Ihnen eingetragen Ordnungsnummern Löcher enthält, können Sie dann später andere Einträge in die FAQ-Liste einfügen. Zum Beispiel, wenn Sie die Ordnungsnummern 1, 6, 11, 16 benutzen, können Sie später andere Einträge mit den fehlenden Ordnungsnummern hinzufügen.  Negative Nummern und Null sind erlaubt, und ermöglichen Ihnen, Einträge <u>vor</u> dem jetzigen ersten Eintrag hinzuzufügen.<br /><br />Wenn mehrere Einträge die selbe Ordnugsnummer haben, ist nur einer dieser Einträge sichtbar.  Welcher Eintrag dann sichtbar ist, ist unbestimmt.";
$pgv_lang["add_faq_visibility_help"]	= "~#pgv_lang[add_faq_visibility]#~<br /><br />Sie können bestimmen, ob diese FAQ (oft gestellte Frage) immer sichtbar ist, oder ob sie nur der aktuellen GEDCOM-Datei sichtbar ist.<br /><br /><ul><li><b>#pgv_lang[all]#</b>&nbsp;&nbsp;&nbsp;Die FAQ ist in allen FAQ-Listen sichtbar, ohne Rücksicht auf die aktuelle GEDCOM-Datei.</li><li><b>#GLOBALS[GEDCOM]#</b>&nbsp;&nbsp;&nbsp;Die FAQ ist nur in der FAQ-Liste der aktuellen GEDCOM-Datei sichtbar.</li></ul>";
$pgv_lang["index_gedcom_news_adm_help"]	= "Der GEDCOM-Neuigkeiten Text erlaubt das Benutzen von <b>HTML-Befehlen</b> und <b>HTML-Codes</b>.  Sie sollten HTML <b>nicht</b> in den Überschriften benutzen.<br /><br />Anfangs- und End-Befehle sollten immer gepaart benutzt werden (z.B. &lt;u&gt; muss immer mit &lt;/u&gt; gepaart werden).  Es wäre vielleicht nützlich, HTML gut zu verstehen. Das Programm benutzt auch <b>Cascading Style Sheets (CSS)</b>.  Jede Darstellungstheme benutzt andere CSS.  Sie können auch »class« aus diesen CSS-Dateien benutzen, um die Darstellung der einzelnen Nachrichten zu beeinflussen.<br /><br />Falls Sie mehr Hilfe über dieses Thema benötigen, sollten Sie sich an die PhpGedView-Site wenden, wo einige Beispiele von GEDCOM-Tags in Neuigkeiten-Artikeln zu finden sind.<br /><br />Wie bei der FAQ-Liste, sind in Überschriften und Texten Verweise auf \$pgv_lang, \$factarray, und \$GLOBALS Variablen erlaubt.  Das ermöglicht Ihnen, die Neuigkeiten so zu formatieren, wie sie möchten.  Wenn Sie Verweise auf \$pgv_lang Variablen benutzen, sind die Texte auch der aktuellen Sprache angepasst.<br /><br />Folgende Beschreibung aus dem Hilfe-Text der FAQ-Liste, ist auch für GEDCOM-Neuigkeiten Artikel gültig.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["time_limit_help"]			= "~#pgv_lang[time_limit]#~<br /><br />Maximale Import-Laufzeit.";

// editconfig_gedcom.php Option Filter
$pgv_lang["ged_filter_results"]			= "Resultate";
$pgv_lang["ged_filter_reset"]			= "Neue Suche";
$pgv_lang["ged_filter_description"]		= "Optionen-Text durchsuchen";
$pgv_lang["ged_filter_description_help"]	= "~#pgv_lang[ged_filter_description]#~<br /><br />Diese Option ermöglicht das Durchsuchen der Optione-Texte.<br /><br />Je mehr Buchstaben Sie eingeben, desto präziser ist die Suche.";

?>
