<?php
/**
 * French Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2022  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: configure_help.fr.php 7328 2022-01-12 18:30:53Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["google_analytics_help"]			= "~#pgv_lang[google_analytics]#~<br /><br />Le service #pgv_lang[google_analytics]#  est décrit dans cet <a href='https://fr.wikipedia.org/wiki/Google_Analytics' target='_blank' title='Google Analytics'>article de Wikipédia</a>.<br /><br />Veuillez noter que si vous choisissez d'utiliser ce service, Google acquiert les droits sur toutes les données qu'il recueille sur l'activité des visiteurs sur votre site.";
$pgv_lang["USE_GOOGLE_ANALYTICS_help"]		= "~#pgv_lang[USE_GOOGLE_ANALYTICS]#~<br /><br />Sélectionnez <b>#pgv_lang[yes]#</b> pour activer le suivi de l'activité sur votre site par le service #pgv_lang[google_analytics]#. Vous devez vous abonner à ce service avant d'activer cette option.";
$pgv_lang["PGV_GOOGLE_ANALYTICS_help"]		= "~#pgv_lang[PGV_GOOGLE_ANALYTICS]#~<br /><br />Entrez le numéro de compte attribué à votre site lorsque vous vous êtes abonné au service #pgv_lang[google_analytics]#. Ce numéro de compte a le format <b>UA-xxxxxx-x</b>.";
$pgv_lang["piwik_analytics_help"]			= "~#pgv_lang[piwik_analytics]#~<br /><br />Le projet open-source #pgv_lang[piwik_analytics]#, appelé à l'origine «Piwik», est décrit, en anglais, <a href='https://matomo.org/' target='_blank' title='Matomo official web site'>ici</a>.<br /><br />Matomo est une alternative à #pgv_lang[google_analytics]# qui élimine de nombreux problèmes de confidentialité. Vous pouvez installer l'application Matomo sur votre propre serveur Web ou dans votre propre domaine, vous garantissant ainsi un contrôle total sur les données d'activité qui ont été collectées.";
$pgv_lang["USE_PIWIK_ANALYTICS_help"]		= "~#pgv_lang[USE_PIWIK_ANALYTICS]#~<br /><br />Sélectionnez <b>#pgv_lang[yes]#</b> pour activer le suivi de l'activité sur votre site par un serveur #pgv_lang[piwik_analytics]#. Votre site PhpGedView doit être enregistré sur un serveur Matomo.";
$pgv_lang["PGV_PIWIK_URL_help"]				= "~#pgv_lang[PGV_PIWIK_URL]#~<br /><br />Entrez l'URL d'un serveur Matomo sur lequel votre site PhpGedView est enregistré.";
$pgv_lang["PGV_PIWIK_SITE_help"]			= "~#pgv_lang[PGV_PIWIK_SITE]#~<br /><br />Entrez l'ID numérique de site attribué à votre site PhpGedView par le serveur Matomo.";
$pgv_lang["clustrmaps_analytics_help"]		= "~#pgv_lang[clustrmaps_analytics]#~<br /><br />#pgv_lang[clustrmaps_analytics]# est un compteur de visites combiné, un suivi des visiteurs et un outil de visualisation géographique.<br /><br />Chaque page comprend une image de carte miniature générée par #pgv_lang[clustrmaps_analytics]#. Lorsque cette image se charge, un compteur sur le site #pgv_lang[clustrmaps_analytics]# est incrémenté. Lorsque la carte, qui est visible par tous vos visiteurs, est mise à jour (quotidiennement, hebdomadairement ou mensuellement, selon votre trafic), elle montre les emplacements de tous les visiteurs de votre page depuis le début d'un intervalle de temps spécifique.<br /><br />Si vous avez payé pour le service #pgv_lang[clustrmaps_analytics]#, cliquer sur cette vignette de carte affiche une carte du monde plus grande.<br /><br />Plus de détails, en anglais, sont disponibles sur le <a href='http://www.clustrmaps.com/' target='_blank' title='site #pgv_lang[clustrmaps_analytics]#'>site #pgv_lang[clustrmaps_analytics]#</a>.";
$pgv_lang["USE_CLUSTRMAPS_ANALYTICS_help"]	= "~#pgv_lang[USE_CLUSTRMAPS_ANALYTICS]#~<br /><br />Sélectionnez <b>#pgv_lang[yes]#</b> pour activer le suivi de l'activité sur votre site par un serveur #pgv_lang[clustrmaps_analytics]#.";
$pgv_lang["PGV_CLUSTRMAPS_SITE_help"]		= "~#pgv_lang[PGV_CLUSTRMAPS_SITE]#~<br /><br />Entrez l'URL de votre site PhpGedView. Cette valeur a été renseignée pour vous et vous n'avez normalement pas besoin de la modifier.";
$pgv_lang["PGV_CLUSTRMAPS_SERVER_help"]		= "~#pgv_lang[PGV_CLUSTRMAPS_SERVER]#~<br /><br />Entrez le numéro de serveur attribué par le service #pgv_lang[clustrmaps_analytics]# lorsque vous avez activé votre compte.";

$pgv_lang["SHOW_LIST_PLACES"]           = "Afficher les niveaux de lieux sur des listes";
$pgv_lang["SHOW_LIST_PLACES_help"]      = "~#pgv_lang[SHOW_LIST_PLACES]#~<br /><br />Cette option détermine la granularité de l'information qui est affichée dans les listes des champs de lieux.<br /><br />Si vous paramétrez la valeur à <b>9</b> tous les détails de l'information du lieu seront affichés. Si vous paramétrez la valeur à <b>0</b> (zéro) cela masquera complètement les lieux. Si vous paramétrez la valeur à <b>1</b> cela n'affichera que le niveau supérieur de l'information de lieu, qui est en règle générale le pays. Si vous paramétrez la valeur à <b>2</b> cela affichera les deux niveaux supérieurs d'information de lieu. Le deuxième niveau supérieur, en dessous du pays, est en règle générale, la région ou l'Etat (pour les USA par exemple). Etc.";

$pgv_lang["new_gedcom_title"]		= "Généalogie de #GEDCOMFILE#";
$pgv_lang["keep_media_help"]		= "~#pgv_lang[keep_media]#~<br /><br />Les liens multimédias existants devraient-ils être conservés dans la base de données lors du téléchargement d'un GEDCOM de remplacement. L'option <b>#pgv_lang[no]#</b> supprime les liens multimédias existants de la base de données, tandis que l'option <b>#pgv_lang[yes]#</b> les conserve.<br /><br />Cette option est utile lorsque vous exportez votre GEDCOM de PhpGedView vers un programme de maintenance GEDCOM hors ligne qui ne gère pas correctement les pointeurs multimédias intégrés, puis que vous réimportez ultérieurement ce qui a changé GEDCOM dans PhpGedView. Dans de telles circonstances, les pointeurs multimédias dans le GEDCOM que vous avez exporté vers votre programme d'édition hors ligne sont détruits et vous devrez relier tous vos fichiers multimédias aux enregistrements de personne, de famille et de source appropriés après la réimportation du GEDCOM dans PhpGedView.<br /><br />L'option <b>#pgv_lang[yes]#</b> indique à PhpGedView de conserver les liens multimédias existants afin que vous n'ayez pas à les recréer après l'importation le GEDCOM modifié, mais cela nécessite que le programme d'édition hors ligne produise toujours les mêmes numéros d'identification de personne, de famille et de source.<br /><br /><i>Family Tree Maker</i> est l'un des nombreux les programmes d'édition en ligne qui ne gèrent <u>pas</u> correctement les pointeurs d'objets multimédias dans le GEDCOM. <i>Legacy</i>, entre autres, <u>gère</u> ces derniers correctement.";
$pgv_lang["USE_MEDIA_VIEWER"]			= "Utiliser la visionneuse multimédia";
$pgv_lang["USE_MEDIA_VIEWER_help"]		= "~#pgv_lang[USE_MEDIA_VIEWER]#~<br /><br />Lorsque cette option est <b>#pgv_lang[yes]#</b>, cliquer sur les images produira la page du visualiseur multimédia. Cette page montre les détails de l'image. Si vous disposez des droits suffisants, vous pouvez également modifier ces détails.<br /><br />Lorsque cette option est <b>#pgv_lang[no]#</b>, cliquer sur les images produira une image en taille réelle dans une nouvelle fenêtre.";
$pgv_lang["USE_MEDIA_FIREWALL"]			= "Utiliser le pare-feu multimédia";
$pgv_lang["USE_MEDIA_FIREWALL_help"]	= "~#pgv_lang[USE_MEDIA_FIREWALL]#~<br /><br />Voir le Wiki pour une description de la façon d'utiliser le pare-feu multimédia. <a href=\"#PGV_PHPGEDVIEW_WIKI#/en/index.php?title=Media_Firewall\" target=\"_blank\">#PGV_PHPGEDVIEW_WIKI#</a>";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR"]			= "Dossier racine du pare-feu multimédia";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_help"]	= "~#pgv_lang[MEDIA_FIREWALL_ROOTDIR]#~<br /><br />Dossier dans lequel le dossier Media protégé peut être créé.  #pgv_lang[MEDIA_FIREWALL_ROOTDIR_note]#";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_note"]	= "Lorsque ce champ est vide, le dossier <b>#GLOBALS[INDEX_DIRECTORY]#</b> sera utilisé.";
$pgv_lang["MEDIA_FIREWALL_THUMBS"]			= "Protégez les vignettes des images protégées";
$pgv_lang["MEDIA_FIREWALL_THUMBS_help"]	= "~#pgv_lang[MEDIA_FIREWALL_THUMBS]#~<br /><br />Lorsqu'une image se trouve dans le dossier Media protégé, sa vignette doit-elle également être protégée?";
$pgv_lang["SHOW_SPIDER_TAGLINE"]		= "Afficher le slogan du moteur de recherche";
$pgv_lang["SHOW_SPIDER_TAGLINE_help"]		= "~#pgv_lang[SHOW_SPIDER_TAGLINE]#~<br /><br />Sur les pages générées pour les moteurs de recherche, affichez comme dernière ligne le moteur de recherche particulier détecté par la page. Si cette option est activée, elle peut biaiser Google&reg; AdSense vers les outils d'optimisation des moteurs de recherche.";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS_help"] = "~#pgv_lang[SHOW_PRIVATE_RELATIONSHIPS]#~<br /><br />Cette option conservera les liens familiaux dans les archives privatisées. Cela signifie que vous verrez des cases «#pgv_lang[private]#» vides sur le tableau d'ascendance et sur d'autres graphiques avec des personnes privées.<br /><br />Ce paramètre est désactivé par défaut. Il est recommandé, au lieu de l'activer, de diriger la personne racine de votre pedigree dans votre configuration GEDCOM vers une personne qui n'est pas privée.";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS"]	= "Afficher les relations privées";
$pgv_lang["SYNC_GEDCOM_FILE_help"] 			= "~#pgv_lang[SYNC_GEDCOM_FILE]#~<br /><br />Définir cette valeur sur <b>#pgv_lang[yes]#</b> mettra automatiquement à jour le fichier GEDCOM lorsque les modifications sont acceptées dans la base de données. Cela maintiendra le fichier GEDCOM synchronisé avec la base de données.<br /><br />Vous voudrez peut-être le transformer en <b>#pgv_lang[no]#</b> pour améliorer la vitesse du programme et économiser la mémoire lors de l'acceptation des modifications.";
$pgv_lang["SYNC_GEDCOM_FILE"]			= "Synchroniser les modifications dans le fichier GEDCOM";
$pgv_lang["SHOW_MULTISITE_SEARCH_help"]	= "~#pgv_lang[SHOW_MULTISITE_SEARCH]#~<br /><br />La recherche multisite permet aux utilisateurs de rechercher sur plusieurs sites Web PhpGedView que vous avez configurés dans la zone d'administration Gérer les sites ou auxquels vous êtes lié à distance. Cette option contrôle si la fonction de recherche multisite est disponible pour tout le monde ou uniquement pour les utilisateurs authentifiés.";
$pgv_lang["SHOW_MULTISITE_SEARCH"]		= "Afficher la recherche multi-sites";
$pgv_lang["SHOW_NO_WATERMARK"]			= "Qui peut afficher des images sans filigrane?";
$pgv_lang["SHOW_NO_WATERMARK_help"]		= "~#pgv_lang[SHOW_NO_WATERMARK]#~<br /><br />Si le pare-feu multimédia est activé, les utilisateurs verront des filigranes s’ils n’ont pas le niveau de privilège spécifié ici.";
$pgv_lang["WATERMARK_THUMB"]			= "Ajouter des filigranes aux vignettes?";
$pgv_lang["WATERMARK_THUMB_help"]		= "~#pgv_lang[WATERMARK_THUMB]#~<br /><br />Si le pare-feu multimédia est activé, les miniatures doivent-elles être filigranées? Vos listes de médias se chargeront plus rapidement si vous ne filigranez pas les vignettes.";
$pgv_lang["SAVE_WATERMARK_THUMB"]		= "Stocker les miniatures filigranées sur le serveur?";
$pgv_lang["SAVE_WATERMARK_THUMB_help"]	= "~#pgv_lang[SAVE_WATERMARK_THUMB]#~<br /><br />Si le pare-feu multimédia est activé, les copies des vignettes filigranées doivent-elles être stockées sur le serveur en plus des mêmes vignettes sans filigranes?<br /><br />Si défini sur <b>#pgv_lang[yes]#</b>, les listes de médias contenant des miniatures filigranées seront produites plus rapidement au détriment des besoins d'espace disque du serveur plus élevés.";
$pgv_lang["SAVE_WATERMARK_IMAGE"]		= "Stocker des images pleine taille filigranées sur le serveur?";
$pgv_lang["SAVE_WATERMARK_IMAGE_help"]	= "~#pgv_lang[SAVE_WATERMARK_IMAGE]#~<br /><br />Si le pare-feu multimédia est activé, les copies des images en taille réelle avec filigrane doivent-elles être stockées sur le serveur en plus des mêmes images sans filigranes?<br /><br />Si défini sur <b>#pgv_lang[yes]#</b>, les images en filigrane de taille normale seront produites plus rapidement au détriment des exigences d'espace disque du serveur plus élevées.";
$pgv_lang["DB_UTF8_COLLATION"]			= "Utilisez la base de données pour fournir le classement UTF-8";
$pgv_lang["DB_UTF8_COLLATION_help"]		= "Contrôle si PhpGedView doit utiliser les fonctions de tri et de classement intégrées de la base de données. Il est généralement plus rapide d'utiliser la base de données pour trier et filtrer les données plutôt que PHP, bien que toutes les bases de données / versions ne fournissent pas cette fonctionnalité. La séquence de classement utilisée pour chaque langue est définie dans la page des paramètres de cette langue.<br /><br /><span class=\"warning\">IMPORTANT : vous ne devez définir cette valeur sur <b>#pgv_lang[yes]#</b> que si vous le faites AVANT que les tables de base de données ne soient créées pour la première fois. Le sélectionner sur une base de données existante pourrait endommager vos données.</span><br /><br />MySQL et PostgreSQL offrent tous deux un bon support pour UTF-8, bien que toutes les séquences de classement ne soient pas disponibles dans les versions antérieures de MySQL. D'autres bases de données offrent peu ou pas de support pour UTF-8. Si vous n'êtes pas sûr de la prise en charge de l'UTF-8 par votre base de données, vous devez définir cette valeur sur <b>#pgv_lang[no]#</b>.<br /><br />Cet <a href='https://fr.wikipedia.org/wiki/UTF-8' target='_blank' title='Article Wikipedia'><b>Article Wikipedia</b></a> contient des informations complètes et des liens sur UTF-8.";
$pgv_lang["INDI_FACTS_ADD"] 			= "Ajouter des faits aux personnes";
$pgv_lang["INDI_FACTS_ADD_help"]		= "~#pgv_lang[INDI_FACTS_ADD]#~<br /><br />Voici la liste des faits GEDCOM que vos utilisateurs peuvent ajouter aux personnes. Vous pouvez modifier cette liste en supprimant ou en ajoutant des noms de faits, même personnalisés, si nécessaire. Les noms de faits qui apparaissent dans cette liste ne doivent pas également apparaître dans la liste <i>#pgv_lang[INDI_FACTS_UNIQUE]#</i>.";
$pgv_lang["INDI_FACTS_UNIQUE"] 			= "Faits uniques de personnes";
$pgv_lang["INDI_FACTS_UNIQUE_help"]		= "~#pgv_lang[INDI_FACTS_UNIQUE]#~<br /><br />Il s'agit de la liste des faits GEDCOM que vos utilisateurs ne peuvent ajouter <u>qu'une fois</u> aux personnes. Par exemple, si BIRT figure dans cette liste, les utilisateurs ne pourront pas ajouter plus d'un enregistrement BIRT à une personne. Les noms de faits qui apparaissent dans cette liste ne doivent pas également apparaître dans la liste <i>#pgv_lang[INDI_FACTS_ADD]#</i>.";
$pgv_lang["INDI_FACTS_QUICK"] 			= "Faits rapides de personnes";
$pgv_lang["INDI_FACTS_QUICK_help"]	= "~#pgv_lang[INDI_FACTS_QUICK]#~<br /><br />Ceci est la courte liste des faits sur les personnes GEDCOM qui apparaît à côté de la liste complète et peut être ajoutée en un seul clic.";
$pgv_lang["FAM_FACTS_ADD"] 			= "Ajouter des faits aux familles";
$pgv_lang["FAM_FACTS_ADD_help"]		= "~#pgv_lang[FAM_FACTS_ADD]#~<br /><br />Voici la liste des faits GEDCOM que vos utilisateurs peuvent ajouter aux familles. Vous pouvez modifier cette liste en supprimant ou en ajoutant des noms de faits, même personnalisés, si nécessaire. Les noms de faits qui apparaissent dans cette liste ne doivent pas également apparaître dans la liste <i>#pgv_lang[FAM_FACTS_UNIQUE]#</i> list..";
$pgv_lang["FAM_FACTS_UNIQUE"] 			= "Faits uniques de familles";
$pgv_lang["FAM_FACTS_UNIQUE_help"]		= "~#pgv_lang[FAM_FACTS_UNIQUE]#~<br /><br />Voici la liste des faits GEDCOM que vos utilisateurs ne peuvent ajouter <u>qu'une fois</u> aux familles. Par exemple, si MARR figure dans cette liste, les utilisateurs ne pourront pas ajouter plus d'un enregistrement MARR à une famille. Les noms de faits qui apparaissent dans cette liste ne doivent pas également apparaître dans la liste <i>#pgv_lang[FAM_FACTS_ADD]#</i>.";
$pgv_lang["FAM_FACTS_QUICK"] 			= "Faits rapides de familles";
$pgv_lang["FAM_FACTS_QUICK_help"]	= "~#pgv_lang[FAM_FACTS_QUICK]#~<br /><br />Voici la courte liste des faits de la famille GEDCOM qui apparaît à côté de la liste complète et peut être ajoutée en un seul clic.";
$pgv_lang["SOUR_FACTS_ADD"] 			= "Ajouter des faits aux sources";
$pgv_lang["SOUR_FACTS_ADD_help"]		= "~#pgv_lang[SOUR_FACTS_ADD]#~<br /><br />Voici la liste des faits GEDCOM que vos utilisateurs peuvent ajouter aux sources. Vous pouvez modifier cette liste en supprimant ou en ajoutant des noms de faits, même personnalisés, si nécessaire. Les noms de faits qui apparaissent dans cette liste ne doivent pas également apparaître dans la liste <i>#pgv_lang[SOUR_FACTS_UNIQUE]#</i>";
$pgv_lang["SOUR_FACTS_UNIQUE"] 			= "Faits uniques de sources";
$pgv_lang["SOUR_FACTS_UNIQUE_help"]		= "~#pgv_lang[SOUR_FACTS_UNIQUE]#~<br /><br />Voici la liste des faits GEDCOM que vos utilisateurs ne peuvent ajouter <u>qu'une fois</u> aux sources. Par exemple, si TITL figure dans cette liste, les utilisateurs ne pourront pas ajouter plus d'un enregistrement TITL à une source. Les noms de faits qui apparaissent dans cette liste ne doivent pas également apparaître dans la liste <i>#pgv_lang[SOUR_FACTS_ADD]#</i>.";
$pgv_lang["SOUR_FACTS_QUICK"] 			= "Faits rapides de sources";
$pgv_lang["SOUR_FACTS_QUICK_help"]	= "~#pgv_lang[SOUR_FACTS_QUICK]#~<br /><br />Voici la courte liste de faits source GEDCOM qui apparaît à côté de la liste complète et peut être ajoutée en un seul clic.";
$pgv_lang["REPO_FACTS_ADD"] 			= "Ajouter des faits aux dépôts";
$pgv_lang["REPO_FACTS_ADD_help"]		= "~#pgv_lang[REPO_FACTS_ADD]#~<br /><br />Voici la liste des faits GEDCOM que vos utilisateurs peuvent ajouter aux dépôts. Vous pouvez modifier cette liste en supprimant ou en ajoutant des noms de faits, même personnalisés, si nécessaire. Les noms de faits qui apparaissent dans cette liste ne doivent pas également apparaître dans la liste <i>#pgv_lang[REPO_FACTS_UNIQUE]#</i>.";
$pgv_lang["REPO_FACTS_UNIQUE"] 			= "Faits uniques de dépôts";
$pgv_lang["REPO_FACTS_UNIQUE_help"]		= "~#pgv_lang[REPO_FACTS_UNIQUE]#~<br /><br />Voici la liste des faits GEDCOM que vos utilisateurs ne peuvent ajouter <u>qu'une seule fois</u> aux dépôts. Par exemple, si NAME figure dans cette liste, les utilisateurs ne pourront pas ajouter plus d'un enregistrement NAME à un dépôt. Les noms de faits qui apparaissent dans cette liste ne doivent pas également apparaître dans la liste <i>#pgv_lang[REPO_FACTS_ADD]#</i>.";
$pgv_lang["REPO_FACTS_QUICK"] 			= "Faits rapides de dépôts";
$pgv_lang["REPO_FACTS_QUICK_help"]	= "~#pgv_lang[REPO_FACTS_QUICK]#~<br /><br />Voici la courte liste des faits dépôt GEDCOM qui apparaît à côté de la liste complète et peut être ajoutée en un seul clic.";
$pgv_lang["LANG_SELECTION_help"]		= "~#pgv_lang[LANG_SELECTION]#~<br /><br />Vous pouvez modifier la liste des langues prises en charge par votre site PhpGedView en ajoutant ou en supprimant des coches selon le cas. Cela modifie les choix de langue disponibles à vos utilisateurs.<br /><br />Vous pouvez réaliser la même chose via le lien <b>#pgv_lang[enable_disable_lang]#</b> dans le menu #pgv_lang[admin]#, où vous pouvez également modifier des éléments tels que l'icône du drapeau de la langue, le format de la date ou si le nom de famille doit toujours être imprimé en premier.";
$pgv_lang["MEDIA_ID_PREFIX"]		= "Préfixe d'identifiant de média";
$pgv_lang["MEDIA_ID_PREFIX_help"]	= "~#pgv_lang[MEDIA_ID_PREFIX]#~<br /><br />Lorsqu'un nouvel enregistrement multimédia est ajouté en ligne dans PhpGedView, un nouvel identifiant pour ce support sera généré automatiquement. L'identifiant de média aura ce préfixe.";
$pgv_lang["FAM_ID_PREFIX"]		= "Préfixe d'identifiant de famille";
$pgv_lang["FAM_ID_PREFIX_help"]	= "~#pgv_lang[FAM_ID_PREFIX]#~<br /><br />Lorsqu'un nouvel enregistrement familial est ajouté en ligne dans PhpGedView, un nouvel identifiant pour cette famille sera généré automatiquement. L'identifiant de famille aura ce préfixe.";
$pgv_lang["QUICK_REQUIRED_FAMFACTS"]			= "Faits des familles qui doivent toujours être affiché sur le formulaire de mise à jour rapide";
$pgv_lang["QUICK_REQUIRED_FAMFACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FAMFACTS]#~<br /><br />C'est une liste d'étiquettes de faits GEDCOM séparées par des virgules qui seront toujours affichées dans les onglets Famille du formulaire de mise à jour rapide, qu'elles existent déjà ou non dans la fiche de la famille. Par exemple, si MARR est dans la liste, les champs pour la date du mariage et le lieu du mariage seront toujours affichés sur le formulaire.";
$pgv_lang["QUICK_ADD_FAMFACTS"]			= "Faits pour les familles à afficher sur le formulaire de mise à jour rapide";
$pgv_lang["QUICK_ADD_FAMFACTS_help"]		= "~#pgv_lang[QUICK_ADD_FAMFACTS]#~<br /><br />C'est une liste de balises de faits GEDCOM, séparées par des virgules, qui seront affichées dans les onglets Famille du formulaire de mise à jour rapide. Seuls les faits de cette liste seront affichés sur le formulaire ou mis à disposition pour la sélection dans la zone où vous ajoutez de nouveaux faits sur le formulaire.";
$pgv_lang["QUICK_REQUIRED_FACTS"]			= "Faits à toujours afficher sur le formulaire de mise à jour rapide";
$pgv_lang["QUICK_REQUIRED_FACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FACTS]#~<br /><br />C'est une liste de balises de faits GEDCOM, séparées par des virgules, qui seront toujours affichées sur le formulaire de mise à jour rapide, qu'elles existent déjà ou non dans l'enregistrement de la personne. Par exemple, si BIRT est dans la liste, les champs de date de naissance et de lieu de naissance seront toujours affichés sur le formulaire.";
$pgv_lang["QUICK_ADD_FACTS"]			= "Faits à afficher sur le formulaire de mise à jour rapide";
$pgv_lang["QUICK_ADD_FACTS_help"]		= "~#pgv_lang[QUICK_ADD_FACTS]#~<br /><br />C'est une liste de balises de faits GEDCOM, séparées par des virgules, qui seront affichées sur le formulaire de mise à jour rapide. Seuls les faits de cette liste seront affichés sur le formulaire ou mis à disposition pour la sélection dans la zone où vous ajoutez de nouveaux faits sur le formulaire.";
$pgv_lang["SURNAME_TRADITION_help"] = "~#pgv_lang[SURNAME_TRADITION]#~<br /><br />Lorsque vous ajoutez de nouveaux membres à une famille, PhpGedView peut fournir des valeurs par défaut pour les noms de famille selon la coutume régionale.<br /><br /><ul><li>Dans la tradition <b>paternelle</b>, tous les membres de la famille partagent le nom de famille du père.</li><li>Dans la tradition <b>espagnole</b> et <b>portugaise</b>, les enfants reçoivent un nom de famille de chaque parent.</li><li>Dans la tradition <b>islandaise</b>, les enfants reçoivent le prénom de leur parent masculin comme nom de famille, avec un suffixe indiquant le sexe.</li><li>Dans la tradition <b>polonaise</b>, tous les membres de la famille partagent le nom de famille du père. Pour certains noms de famille, le suffixe indique le sexe. Les suffixes <i>ski</i>, <i>cki</i>, et <i>dzki</i> indiquent masculin, tandis que les suffixes correspondants <i>ska</i>, <i>cka</i>, et <i>dzka</i> indiquent une femme.</li></ul>";
$pgv_lang["ADVANCED_NAME_FACTS_help"] = "~#pgv_lang[ADVANCED_NAME_FACTS]#~<br /><br />C'est une liste de balises de faits GEDCOM, séparées par des virgules, qui seront affichées sur le formulaire d'ajout / modification de nom. Si vous utilisez des alphabets non latins tels que l'hébreu, le grec, le cyrillique ou l'arabe, vous pouvez ajouter des balises telles que _HEB, ROMN, FONE, etc. pour vous permettre de stocker des noms dans plusieurs alphabets différents.";
$pgv_lang["ADVANCED_PLAC_FACTS_help"] = "~#pgv_lang[ADVANCED_PLAC_FACTS]#~<br /><br />C'est une liste de balises de faits GEDCOM, séparées par des virgules, qui seront affichées lorsque vous ajoutez ou modifiez des noms de lieux. Si vous utilisez des alphabets non latins tels que l'hébreu, le grec, le cyrillique ou l'arabe, vous souhaiterez peut-être ajouter des balises telles que _HEB, ROMN, FONE, etc. pour vous permettre de stocker des noms de lieux dans plusieurs alphabets différents.";
$pgv_lang["GEONAMES_KEY"]				= "ID utilisateur geonames.org";
$pgv_lang["GEONAMES_KEY_help"]			= "~#pgv_lang[GEONAMES_KEY]#~<br /><br />Cet identifiant est requis pour accéder à la base de données gratuite geonames.org des noms géographiques. Si vous ne fournissez pas d'ID utilisateur valide, vous ne pourrez pas rechercher dans cette base de données.<br /><br />Vous pouvez demander un ID utilisateur geonames.org sur le <a href='http://www.geonames.org/login' target='_blank'><b>page de connexion geonames.org</b></a>.<br /><br />Vous recevrez ensuite un e-mail avec un lien de confirmation et après avoir confirmé l'e-mail, vous pourrez activer votre compte pour le service Web sur <a href='http://www.geonames.org/manageaccount' target='_blank'><b>la page de votre compte</b></a>";
$pgv_lang["GEONAMES_BIAS"]				= "geonames.org biais de pays";
$pgv_lang["GEONAMES_BIAS_help"]			= "~#pgv_lang[GEONAMES_BIAS]#~<br /><br />Normalement, la recherche dans la base de données GeoNames présente ses résultats par ordre alphabétique sans régard au pays dans lequel un lieu est situé. Cette option spécifie que les lieux situés dans le pays sélectionné doivent être signalés en haut de la liste des résultats.";
$pgv_lang["GEONAMES_BIAS_no_preference"]= "Pas de préférence";
$pgv_lang["GEOCODE_KEY"]				= "Clé du serveur Google Geocode";
$pgv_lang["GEOCODE_KEY_help"]			= "~#pgv_lang[GEOCODE_KEY]#~<br /><br />Cette clé est nécessaire pour accéder à la base de données gratuite de noms géographiques de Google. Si vous ne fournissez pas de clé valide, vous ne pourrez pas rechercher cette base de données.<br /><br />Vous pouvez demander une clé via votre <a href='https://developers.google.com/maps/documentation/geocoding/get-api-key' target='_blank'><b>Google Developer Console</b></a>. Vous pouvez afficher cette page dans une langue autre que l'anglais en choisissant la langue souhaitée tout en bas de la page.";
$pgv_lang["AUTO_GENERATE_THUMBS"]			= "Vignettes générées automatiquement";
$pgv_lang["AUTO_GENERATE_THUMBS_help"]		= "~#pgv_lang[AUTO_GENERATE_THUMBS]#~<br /><br />Le système devrait-il générer automatiquement des miniatures pour les images qui n'en ont pas? Votre installation PHP peut ne pas prendre en charge cette fonctionnalité.";
$pgv_lang["phpinfo_help"]				= "~#pgv_lang[phpinfo]#~<br /><br />Cette page fournit des informations détaillées sur le serveur sur lequel PhpGedView est hébergé. De nombreux détails de configuration sur le logiciel du serveur, en ce qui concerne PHP et PhpGedView, peuvent être consultés.";
$pgv_lang["config_help_help"]			= "~#pgv_lang[config_help]#~<br /><br />Cette page rassemble toutes les rubriques principales de l'aide à la configuration en un seul endroit. Vous pouvez afficher les informations sur votre écran ou vous pouvez les imprimer pour une utilisation ultérieure.";
$pgv_lang["more_help_advice"]			= "<b>Aide supplémentaire</b><br />Une aide supplémentaire est disponible en cliquant sur le <b>#pgv_lang[qm]#</b> à côté des éléments de la page.";
$pgv_lang["THUMBNAIL_WIDTH"]			= "Largeur des vignettes générées";
$pgv_lang["THUMBNAIL_WIDTH_help"]		= "~#pgv_lang[THUMBNAIL_WIDTH]#~<br /><br />C'est la largeur (en pixels) que le programme utilisera lors de la génération automatique de vignettes. Le paramètre par défaut est 100.";
$pgv_lang["USE_SILHOUETTE"]				= "Utilisez des silhouettes";
$pgv_lang["USE_SILHOUETTE_help"]		= "~#pgv_lang[USE_SILHOUETTE]#~<br /><br />Utilisez des images de silhouette lorsqu'aucune image en surbrillance pour cette personne n'a été spécifiée. Les images utilisées sont spécifiques au sexe de la personne en question.<br /><br /><table><tr><td wrap valign=\"middle\">Cette image peut être utilisée lorsque le sexe de la personne est inconnu:</td><td><img src=\"images/silhouette_unknown.gif\" width=\"40\" alt=\"Silhouette image\" title=\"Silhouette image\" /></td></tr></table>";
$pgv_lang["SHOW_SOURCES"]				= "Afficher les sources";
$pgv_lang["SHOW_SOURCES_help"]			= "~#pgv_lang[SHOW_SOURCES]#~<br /><br />Définissez le niveau d'accès à la confidentialité pour toutes les sources. Si l'utilisateur n'a pas accès aux sources, la liste des sources sera supprimée du menu Listes et l'onglet Sources ne s'affichera pas sur la page <i>#pgv_lang[personal_details]#</i>.";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION_help"]	= "~#pgv_lang[REQUIRE_ADMIN_AUTH_REGISTRATION]#~<br /><br />Si l'option <b>#pgv_lang[USE_REGISTRATION_MODULE]#</b> est activée, ce paramètre contrôle si l'administrateur doit approuver l'enregistrement.<br /><br />Définir ceci sur <b>#pgv_lang[yes]#</b> exigera que tous les nouveaux utilisateurs se vérifient d'abord, puis soient approuvés par un administrateur avant de pouvoir se connecter. Avec ce paramètre sur <b>#pgv_lang[no]#</b>, la case <b>#pgv_lang[verified_by_admin]#</b> sera cochée automatiquement lorsque les utilisateurs vérifieront leur compte, permettant ainsi une connexion immédiate après sans intervention administrative.";
$pgv_lang["SPLIT_PLACES"]		= "Diviser des lieux en mode Édition";
$pgv_lang["SPLIT_PLACES_help"]	= "~#pgv_lang[SPLIT_PLACES]#~<br /><br />Définissez ceci sur <b>#pgv_lang[yes]#</b> pour diviser chaque nom de lieu par des virgules en sous-champs pour une édition plus facile. Exemple :<br /><ol><li>Défaut<br /><u>Lieu</u>: Half Moon Bay, San Mateo, California, USA</li><br /><li>Fractionné<br /><u>Pays</u>: USA<br /><u>État</u>: California<br /><u>Comté</u>: San Mateo<br /><u>Ville</u>: Half Moon Bay</li></ol>";
$pgv_lang["UNDERLINE_NAME_QUOTES"]		= "Souligner les noms entre guillemets";
$pgv_lang["UNDERLINE_NAME_QUOTES_help"]	= "~#pgv_lang[UNDERLINE_NAME_QUOTES]#~<br /><br />De nombreux programmes placeront le prénom préféré entre guillemets (<b>\"</b>) dans le GEDCOM. La convention habituelle pour cela est de souligner le prénom préféré. L'activation de cette option convertira tous les noms entourés de guillemets en &lt;span&gt; avec une classe CSS \"starredname\".<br /><br />Par exemple, si le nom dans le GEDCOM était 1&nbsp;NAME&nbsp;Gustave&nbsp;\"Jean&nbsp;Paul\"&nbsp;Charles&nbsp;/Wilson/ activer cette option changerait la partie du nom entre guillemets en &lt;span&nbsp;class=\"starredname\"&gt;Jean&nbsp;Paul&lt;/span&gt;aux fins d'impression. En fonction d'autres paramètres, le navigateur afficherait alors ce nom sous la forme <b>Gustave&nbsp;<u>Jean&nbsp;Paul</u>&nbsp;Charles&nbsp;Wilson</b> ou <b>Wilson,&nbsp;Gustave&nbsp;<u>Jean&nbsp;Paul</u>&nbsp;Charles</b>";
$pgv_lang["PRIVACY_BY_RESN"]		= "Utiliser la restriction de confidentialité GEDCOM (RESN)";
$pgv_lang["PRIVACY_BY_RESN_help"]	= "~#pgv_lang[PRIVACY_BY_RESN]#~<br /><br />La spécification GEDCOM 5.5.1 inclut la possibilité d'utiliser des balises RESN pour définir les options de confidentialité pour les personnes et les faits dans le fichier GEDCOM. L'activation de cette option indiquera au programme de rechercher les balises RESN de niveau 1 dans les enregistrements GEDCOM. Les balises RESN de niveau 2+ sont automatiquement appliquées et ne seront pas affectées par ce paramètre. Notez que cela peut ralentir certaines des fonctions de PhpGedView telles que la liste individuelle.";
$pgv_lang["SHOW_LDS_AT_GLANCE"]			= "Afficher les codes d'ordonnance de l'église SDJ dans les cases des graphiques";
$pgv_lang["SHOW_LDS_AT_GLANCE_help"]	= "~#pgv_lang[SHOW_LDS_AT_GLANCE]#~<br /><br />Si vous définissez cette option sur <b>#pgv_lang[yes]#</b>, les codes d’état des ordonnances SDJ s'affichent dans les cases du graphique.<ul><li><b>B</b> - Baptême</li><li><b>E</b> - Doté</li><li><b>S</b> - Scellé au conjoint</li><li><b>P</b> - Scellé aux parents</li></ul>Une personne qui a fait toutes les ordonnances aura <b>BESP</b> imprimé après son nom. Les ordonnances manquantes sont indiquées par <b>_</b> à la place du code alphabétique correspondant. Par exemple, <b>BE__</b> indique des ordonnances <b>S</b> et <b>P</b> manquantes.";
$pgv_lang["GEDCOM_DEFAULT_TAB"]			= "Onglet par défaut à afficher sur la page «Détails personnels»";
$pgv_lang["GEDCOM_DEFAULT_TAB_help"]	= "~#pgv_lang[GEDCOM_DEFAULT_TAB]#~<br /><br />Cette option vous permet de choisir l'onglet qui s'ouvre automatiquement sur la page «Détails personnels» lors de l'accès à cette page.";
$pgv_lang["SHOW_MARRIED_NAMES"]			= "Afficher les noms mariés sur la liste des personnes";
$pgv_lang["SHOW_MARRIED_NAMES_help"]	= "~#pgv_lang[SHOW_MARRIED_NAMES]#~<br /><br />Cette option affichera les noms mariés des femmes sur la liste des personnes. Cette option nécessite que vous calculiez les noms de mariés lorsque vous importez le fichier GEDCOM.";
$pgv_lang["SHOW_QUICK_RESN"]		= "Afficher les champs de confidentialité sur le formulaire #pgv_lang[quick_update_title]#";
$pgv_lang["SHOW_QUICK_RESN_help"]		= "~#pgv_lang[SHOW_QUICK_RESN]#~<br /><br />Cette option vous permet d'activer ou de désactiver les champs de confidentialité sur le formulaire #pgv_lang[quick_update_title]#. Les champs de confidentialité permettent à un utilisateur qui ajoute des informations via le formulaire de remplacer la confidentialité par défaut pour le fait qu'il saisit.";
$pgv_lang["USE_QUICK_UPDATE"]		= "Utilisez le formulaire #pgv_lang[quick_update_title]#";
$pgv_lang["USE_QUICK_UPDATE_help"]		= "~#pgv_lang[USE_QUICK_UPDATE]#~<br /><br />Cette option détermine les privilèges utilisateur requis pour soumettre des modifications via le formulaire #pgv_lang[quick_update_title]#.<br /><br />Le choix <b>#pgv_lang[nobody]#</b> signifie que ce formulaire ne peut pas être utilisé du tout.";
$pgv_lang["SEARCHLOG_CREATE"]		= "Archiver les fichiers journaux de recherche";
$pgv_lang["SEARCHLOG_CREATE_help"]	= "~#pgv_lang[SEARCHLOG_CREATE]#~<br /><br />À quelle fréquence le programme doit-il archiver les fichiers journaux de recherche.";
$pgv_lang["CHANGELOG_CREATE"]		= "Archiver les fichiers journaux des modifications";
$pgv_lang["CHANGELOG_CREATE_help"]	= "~#pgv_lang[CHANGELOG_CREATE]#~<br /><br />À quelle fréquence le programme doit-il archiver les fichiers journaux.";
$pgv_lang["CHART_BOX_TAGS"]		= "Autres faits à montrer dans les graphiques";
$pgv_lang["CHART_BOX_TAGS_help"]		= "~#pgv_lang[CHART_BOX_TAGS]#~<br /><br />C'est une liste de faits, séparés par des virgules ou des espaces, en plus de la naissance et de la mort, que vous souhaitez voir apparaître dans des boîtes de graphique telles que le tableau d'ascendance. Cette liste vous oblige à utiliser des balises de fait telles que définies dans la norme GEDCOM 5.5.1. Par exemple, si vous vouliez que la profession apparaisse dans la case, vous ajouteriez «OCCU» à ce champ.";
$pgv_lang["FULL_SOURCES"]		= "Utilisez des citations sources complètes";
$pgv_lang["FULL_SOURCES_help"]		= "~#pgv_lang[FULL_SOURCES]#~<br /><br />Les citations de source peuvent inclure des champs pour enregistrer la qualité des données (primaires, secondaires, etc.) et la date à laquelle l'événement a été enregistré dans la source. Si vous n'utilisez pas ces champs, vous pouvez les désactiver lors de la création de nouvelles citations sources.";
$pgv_lang["PREFER_LEVEL2_SOURCES"]		= "Type de Source";
$pgv_lang["PREFER_LEVEL2_SOURCES_help"]		= "~#pgv_lang[PREFER_LEVEL2_SOURCES]#~<br /><br />Lors de l'ajout de nouveaux parents proches, vous pouvez ajouter des citations de source aux enregistrements (par exemple INDI, FAM) ou aux faits (BIRT, MARR, DEAT). Cette option contrôle les cases cochées par défaut.";


//-- CONFIGURE FILE MESSAGES
$pgv_lang["gedcom_conf"]		= "Basiques du GEDCOM";
$pgv_lang["media_conf"]			= "Multimédia";
$pgv_lang["media_general_conf"]	= "Général";
$pgv_lang["media_firewall_conf"]	= "Pare-feu multimédia";
$pgv_lang["accpriv_conf"]		= "Accès et confidentialité";
$pgv_lang["displ_conf"]			= "Affichage, Layout, et Rapports";
$pgv_lang["displ_names_conf"]	= "Noms";
$pgv_lang["displ_comsurn_conf"] = "Noms de famille fréquents";
$pgv_lang["displ_layout_conf"]	= "Layout";
$pgv_lang["displ_hide_conf"]	= "Cacher et montrer";
$pgv_lang["displ_reports"]		= "Rapports";
$pgv_lang["editopt_conf"]		= "Options d'édition";
$pgv_lang["useropt_conf"]		= "Options utilisateur";
$pgv_lang["contact_conf"]		= "Contacter";
$pgv_lang["meta_conf"]			= "Paramètres du site Web et des balises META";
$pgv_lang["gedconf_head"]		= "Configuration GEDCOM";
$pgv_lang["other_theme"]		= "Autre, veuillez saisir";
$pgv_lang["performing_update"]		= "Mise à jour.";
$pgv_lang["config_file_read"]		= "Fichier de configuration lu.";
$pgv_lang["does_not_exist"]		= "n'existe pas";
$pgv_lang["media_drive_letter"]		= "Le chemin multimédia ne doit pas contenir de lettre de lecteur; le multimédia peut ne pas s'afficher.";
$pgv_lang["db_setup_bad"]		= "La configuration actuelle de votre base de données est incorrecte. Veuillez vérifier vos paramètres de connexion à la base de données et configurer à nouveau.";
$pgv_lang["bad_host_user_pass"]		= "PhpGedView n'a pas pu établir de connexion avec votre hôte de base de données. Vérifiez l'hôte, le nom d'utilisateur et le mot de passe pour vous assurer qu'ils sont corrects.";
$pgv_lang["bad_database_name"]		= "PhpGedView a établi une connexion à votre hôte de base de données, mais n'a pas pu utiliser la base de données avec le nom que vous avez entré. Vérifiez que la base de données existe et que le nom d'utilisateur que vous avez entré dispose des autorisations appropriées sur cette base de données.";
$pgv_lang["db"]				= "Base de données";
$pgv_lang["current_gedcoms"]		= "GEDCOM actuels";
$pgv_lang["ged_gedcom"]			= "Fichier GEDCOM";
$pgv_lang["ged_title"]			= "Titre GEDCOM";
$pgv_lang["ged_config"]			= "Fichier de configuration";
$pgv_lang["ged_search"]			= "Fichiers du journal de recherche";
$pgv_lang["ged_change"]			= "Fichiers du journal des modifications";
$pgv_lang["ged_privacy"]		= "Fichier de confidentialité";
$pgv_lang["disabled"]			= "Désactivé";
$pgv_lang["mouseover"]			= "Survol de la souris";
$pgv_lang["mousedown"]			= "Bouton de la souris enfoncé";
$pgv_lang["click"]			= "Clic de souris";
$pgv_lang["enter_db_pass"]		= "Pour des raisons de sécurité, vous devez toujours entrer les #pgv_lang[DBUSER]# et #pgv_lang[DBPASS]# lors de la modification des valeurs de configuration.";
$pgv_lang["server_url_note"]	= "Cela devrait être l'URL de votre dossier PhpGedView. Vous ne devez modifier ce paramètre que si vous êtes sûr de savoir ce que vous faites. PhpGedView a déterminé que cette valeur était <b>#GUESS_URL#</b>";

$pgv_lang["DBTYPE"]			= "Type de base de données";
$pgv_lang["DBTYPE_help"]		= "~#pgv_lang[DBTYPE]#~<br /><br />Le type de base de données à laquelle se connecter.<br /><br />PhpGedView peut utiliser n'importe quelle base de données disposant d'un pilote PDO. Vous devez vous assurer que votre fichier php.ini charge à la fois la bibliothèque <<b>php_pdo</b> et le pilote approprié pour votre base de données, par exemple <b>php_pdo_mysql</b>.<br /><br />La plupart des bases de données nécessitent un nom d’utilisateur et un mot de passe. Vous devez également créer la base de données avant d'installer PhpGedView. Cependant, SQLite n'a pas besoin de #pgv_lang[DBHOST]#, #pgv_lang[DBUSER]#, ou #pgv_lang[DBPASS]#, mais vous devrez définir un chemin de fichier pour votre base de données dans le champ #pgv_lang[DBNAME]#. PhpGedView créera le fichier de base de données SQLite pour vous.";
$pgv_lang["DBHOST"]			= "Hôte de la base de données";
$pgv_lang["DBHOST_help"]		= "~#pgv_lang[DBHOST]#~<br /><br />Le DNS ou l'adresse IP de l'ordinateur hébergeant votre serveur de base de données. Ce paramètre est ignoré si vous utilisez une base de données SQLite.";
$pgv_lang["DBPORT"]			= "Port de base de données";
$pgv_lang["DBPORT_help"]		= "~#pgv_lang[DBPORT]#~<br /><br />Le port TCP à utiliser lors de la connexion à votre serveur de base de données. Laissez ce paramètre vide pour utiliser le port par défaut pour votre type particulier de base de données. Ce paramètre est ignoré si vous utilisez une base de données SQLite.";
$pgv_lang["DBUSER"]			= "Nom d'utilisateur de la base de données";
$pgv_lang["DBUSER_help"]		= "~#pgv_lang[DBUSER]#~<br /><br />Le nom d'utilisateur de la base de données requis pour vous connecter à votre base de données. Ce paramètre est ignoré si vous utilisez une base de données SQLite.";
$pgv_lang["DBPASS"]			= "Mot de passe de la base de données";
$pgv_lang["DBPASS_help"]		= "~#pgv_lang[DBPASS]#~<br /><br />Le mot de passe de la base de données de l'utilisateur que vous avez entré dans le champ #pgv_lang[DBUSER]#. Ce paramètre est ignoré si vous utilisez une base de données SQLite.";
$pgv_lang["DBNAME"]			= "Nom de la base de données";
$pgv_lang["DBNAME_help"]		= "~#pgv_lang[DBNAME]#~<br /><br />La base de données du serveur que vous souhaitez que PhpGedView utilise.<br /><br />Le nom d'utilisateur que vous entrez dans le champ #pgv_lang[DBUSER]# doit avoir les privilèges Créer, Insérer, Mettre à jour, Supprimer et Sélectionner sur cette base de données. Dans SQLite, vous devez définir un nom de fichier dans un dossier accessible en écriture par PHP, tel que votre dossier index (index/phpgedview.db).";
$pgv_lang["TBLPREFIX_help"]		= "~#pgv_lang[TBLPREFIX]#~<br /><br />Un préfixe aux noms des tables créées par PhpGedView. En modifiant cette valeur, vous pouvez configurer plusieurs sites PhpGedView pour utiliser la même base de données physique mais des tables différentes. Par exemple, le même site pourrait héberger une «test» ainsi qu'une installation «production» de PhpGedView avec des tables de données totalement indépendantes.";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"]	= "~#pgv_lang[ALLOW_CHANGE_GEDCOM]#~<br /><br />Si vous avez un environnement avec plusieurs GEDCOM, la définition de cette valeur sur <b>#pgv_lang[yes]#</b> permet aux visiteurs de votre site <u>et</u> d’avoir la possibilité de modifier les GEDCOM. Le définir sur <b>#pgv_lang[no]#</b> désactive le basculement GEDCOM pour les visiteurs <u> et </u> utilisateurs connectés.";
$pgv_lang["upload_path"]			= "Chemin pour le téléchargement";
$pgv_lang["upload_path_help"]		= "~#pgv_lang[upload_path]#~<br /><br />C'est le chemin où se trouve le fichier GEDCOM que vous souhaitez télécharger. Pour sélectionner le chemin, cliquez sur <b>Parcourir</b> et accédez à votre fichier GEDCOM puis cliquez sur <b>Ouvrir</b>.";
$pgv_lang["gedcom_path"]			= "Chemin et nom de GEDCOM sur le serveur";
$pgv_lang["gedcom_path_help"]		= "~#pgv_lang[gedcom_path]#~<br /><br />Il existe deux façons d'importer votre fichier GEDCOM dans PhpGedView. Elles sont:<ol><li>Utilisez un programme FTP pour télécharger le fichier sur le serveur</li><li>Télécharger dans PhpGedView</li></ol>Lorsque votre fichier existe déjà sur le serveur, vous engagez la procédure <i>#pgv_lang[add_gedcom]#</i> et renseignez le chemin et le nom de votre fichier GEDCOM tels qu'ils existent sur le serveur. Le nom peut être avec ou sans extension. Si aucune extension n'est donnée, .ged sera utilisé. Le chemin est facultatif. Si aucun chemin n'est indiqué, la valeur de l'option <i>#pgv_lang[INDEX_DIRECTORY]#</i>, telle que définie dans la configuration de votre site PhpGedView, sera utilisée. Veuillez noter que sur la plupart des serveurs, les noms de fichier et de chemin sont sensibles à la casse.<br /><br />Lorsque vous lancez la procédure <i>#pgv_lang[upload_gedcom]#</i> intégrée à PhpGedView, vous pouvez utiliser le bouton <b>Parcourir</b> pour localiser le fichier souhaité sur votre ordinateur local. Cela peut être un fichier GEDCOM normal ou un fichier ZIP contenant le fichier GEDCOM. PhpGedView extraira automatiquement puis utilisera le fichier GEDCOM contenu dans ce fichier ZIP.<br /><br />Lors du téléchargement d'un fichier, il est possible de spécifier un autre chemin et / ou nom de fichier pour l'enregistrer sur le serveur.<br /><br />Consultez le fichier <a href=\"readme.txt\">Readme.txt</a> pour plus d'informations.";
$pgv_lang["CHARACTER_SET"]		= "Codage du jeu de caractères";
$pgv_lang["CHARACTER_SET_help"]		= "~#pgv_lang[CHARACTER_SET]#~<br /><br />Il s'agit du jeu de caractères de votre fichier GEDCOM. UTF-8 est la valeur par défaut et devrait fonctionner pour presque tous les sites. Si vous exportez votre GEDCOM en utilisant l'encodage IBM Windows, vous devez mettre WINDOWS ici.<br /><br />REMARQUE: PhpGedView ne peut pas prendre en charge UNICODE (UTF-16) car le support est absent de PHP.";
$pgv_lang["LANGUAGE"]			= "Langue";
$pgv_lang["LANGUAGE_help"]		= "~#pgv_lang[LANGUAGE]#~<br /><br />Attribuez la langue par défaut du site.<br /><br />Lorsque l'option <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b> est définie, les utilisateurs peuvent remplacer ce paramètre via la configuration de langue préférée de leur navigateur, les options de configuration sur leur page Compte, ou via des liens ou des boutons sur la plupart des pages PhpGedView.";
$pgv_lang["ENABLE_MULTI_LANGUAGE"]	= "Autoriser l'utilisateur à changer de langue";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"]	= "~#pgv_lang[ENABLE_MULTI_LANGUAGE]#~<br /><br />Définissez sur <b>#pgv_lang[yes]#</b> pour permettre aux utilisateurs de remplacer la langue par défaut du site. Ils peuvent le faire via la configuration de langue préférée de leur navigateur, les options de configuration sur leur page de compte ou via des liens ou des boutons sur la plupart des pages PhpGedView.";
$pgv_lang["CALENDAR_FORMAT"]		= "Format du calendrier";
$pgv_lang["CALENDAR_FORMAT_help"]	= "~#pgv_lang[CALENDAR_FORMAT]#~<br /><br />Les dates peuvent être enregistrées dans divers calendriers tels que le calendrier grégorien, julien ou juif. Cette option vous permet de convertir des dates dans un calendrier préféré. Par exemple, vous pouvez sélectionner Grégorien pour convertir les dates juliennes et hébraïques en grégorien. La date convertie est indiquée entre parenthèses après la date normale.<br /><br /> Les dates ne sont converties que si elles sont valides pour le calendrier. Par exemple, seules les dates comprises entre le 22&nbsp;SEP&nbsp;1792 et 31&nbsp;DEC&nbsp;1805 seront converties dans le calendrier républicain français et seules les dates postérieures au 15&nbsp;OCT&nbsp;1582 seront converties en calendrier grégorien.<br /><br />L'hébreu est le même que le juif, mais en utilisant des caractères hébreux. L'arabe est le même que le hijri, mais utilise des caractères arabes.<br /><br />Remarque: puisque le jour du calendrier juif et hijri commence au crépuscule, tout événement se déroulant du crépuscule à minuit s'affichera comme un jour avant le bon date. L'affichage de l'hébreu et de l'arabe peut être problématique dans les anciens navigateurs, qui peuvent afficher le texte à l'envers (de gauche à droite) ou pas du tout.";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"]	= "Afficher des milliers d'hébreux";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"]	= "~#pgv_lang[DISPLAY_JEWISH_THOUSANDS]#~<br /><br />Montrez Alafim dans les calendriers hébreux.<br /><br />Si vous définissez ceci sur <b>#pgv_lang[yes]#</b>, l’année 1969 sera affichée sous la forme <span lang=\"he-IL\" dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; en le réglant sur <b>#pgv_lang[no]#</b>, l’année sera affichée sous la forme <span lang=\"he-IL\" dir='rtl'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;.  Cela n'a aucun impact sur le cadre de l'année juive. L'année s'affichera comme 5729 quel que soit ce paramètre.<br /><br />Remarque: ce paramètre est similaire à la constante CAL_JEWISH_ADD_ALAFIM du calendrier.";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]		= "Afficher l'hébreu Gershayim";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"]	= "~#pgv_lang[DISPLAY_JEWISH_GERESHAYIM]#~<br /><br />Afficher les guillemets simples et doubles («'» et «\"») lors de l'affichage des dates hébraïques.<br /><br />Si vous définissez cette option sur <b>#pgv_lang[yes]#</b>, le 8 février 1969 sera affiché comme <span lang='he-IL' dir='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; en le définissant sur <b>#pgv_lang[no]#</b> l'affichera comme <span lang='he-IL' dir='rtl'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;.  Cela n'a aucun impact sur le paramètre de l'année juive car les guillemets ne sont pas utilisés dans les dates juives affichées avec des caractères latins.<br /><br />Remarque: ce paramètre est similaire aux constantes de calendrier CAL_JEWISH_ADD_ALAFIM_GERESH et CAL_JEWISH_ADD_GERESHAYIM. Ce paramètre unique affecte les deux.";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"]	= "Prononciation juive ashkénaze";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"]	= "~#pgv_lang[JEWISH_ASHKENAZ_PRONUNCIATION]#~<br /><br />Si réglé sur <b>#pgv_lang[yes]#</b> les mois Cheshvan et Teves seront épelés avec la prononciation ashkénaze. Le définir sur <b>#pgv_lang[no]#</b> changera les mois en Hesvan et Tevet. Cela n'affecte que le cadre juif. Le paramètre hébreu utilisera toujours l'alphabet hébreu.";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"]	= "Générations de pedigree";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"]	= "~#pgv_lang[DEFAULT_PEDIGREE_GENERATIONS]#~<br /><br />Définissez le nombre de générations par défaut à afficher sur les graphiques de descendance et d'ascendance.";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"]		= "Maximum générations de pedigree";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"]	= "~#pgv_lang[MAX_PEDIGREE_GENERATIONS]#~<br /><br />Définissez le nombre maximum de générations à afficher sur les tableaux d'ascendance.";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"]	= "Maximum générations de descendance";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"]	= "~#pgv_lang[MAX_DESCENDANCY_GENERATIONS]#~<br /><br />Définissez le nombre maximum de générations à afficher sur les graphiques de descendance.";
$pgv_lang["SOSA_WIDTH_NORMAL"]		= "Largeur normale des numéros SOSA";
$pgv_lang["SOSA_WIDTH_NORMAL_help"]	= "~#pgv_lang[SOSA_WIDTH_NORMAL]#~<br /><br />Combien d'espace doit être réservé aux numéros SOSA sur les graphiques<br /><br /><b>#pgv_lang[variable]#</b> indique que la largeur n'est pas fixe et que le numéro SOSA imprimé prendra autant de place comme il en a besoin. Le reste du graphique sera positionné en conséquence.";
$pgv_lang["SOSA_WIDTH_WIDE"]		= "Largeur supplémentaire des numéros SOSA";
$pgv_lang["SOSA_WIDTH_WIDE_help"]	= "~#pgv_lang[SOSA_WIDTH_WIDE]#~<br /><br />Combien d'espace doit être réservé pour les numéros SOSA dans la vue Livret du tableau de descendance<br /><br /><b>#pgv_lang[variable]#</b> indique que la largeur n'est pas fixe et que le numéro SOSA imprimé prendra autant de place comme il en a besoin. Le reste du graphique sera positionné en conséquence.";
$pgv_lang["USE_RIN"]			= "Utilisez le numéro RIN au lieu de l'ID GEDCOM";
$pgv_lang["USE_RIN_help"]		= "~#pgv_lang[USE_RIN]#~<br /><br />Réglez sur <b>#pgv_lang[yes]#</b> pour utiliser le numéro RIN au lieu de l'ID GEDCOM lorsqu'on vous demande des ID de personne dans les fichiers de configuration, les paramètres utilisateur et les graphiques. Ceci est utile pour les programmes de généalogie qui n'exportent pas systématiquement les GEDCOM avec le même ID attribué à chaque personne mais utilisent toujours le même RIN.";
$pgv_lang["GENERATE_GUID"]		= "Créez automatiquement des identifiants uniques au monde";
$pgv_lang["GENERATE_GUID_help"]	= "~#pgv_lang[GENERATE_GUID]#~<br /><br /><b>GUID</b> dans ce contexte est l'acronyme de «Global Unique ID» (identifiant unique au monde).<br /><br />Les GUID sont destinés à aider à identifier chaque personne d'une manière reproductible, de sorte que les organisations centrales telles que le Centre d'histoire familiale de l'Église SDJ à Salt Lake City, ou même des programmes compatibles exécutés sur votre propre serveur, peuvent déterminer s'ils traitent avec la même personne, peu importe d'où provient le GEDCOM. Le but du Centre d'histoire familiale est de disposer d'un dépot central de données généalogiques et de l'exposer via des services Web. Cela permettra à n'importe quel programme d'accéder aux données et de mettre à jour leurs données.<br /><br />Si vous n'avez pas l'intention de partager ce GEDCOM avec quelqu'un d'autre, vous n'avez pas besoin de laisser PhpGedView créer ces GUID; cependant, cela ne fera aucun mal autre que d'augmenter la taille de votre GEDCOM.";
$pgv_lang["PEDIGREE_ROOT_ID"]		= "Personne par défaut pour les tableaux d'ascendance et de descendance";
$pgv_lang["PEDIGREE_ROOT_ID_help"]	= "~#pgv_lang[PEDIGREE_ROOT_ID]#~<br /><br />Définissez l'ID de la personne par défaut à afficher sur les graphiques d'ascendance et de descendance.";
$pgv_lang["GEDCOM_ID_PREFIX"]		= "Préfixe d'identifiant de personne";
$pgv_lang["GEDCOM_ID_PREFIX_help"]	= "~#pgv_lang[GEDCOM_ID_PREFIX]#~<br /><br />Lorsqu'un nouvel enregistrement de personne est ajouté en ligne dans PhpGedView, un nouvel identifiant pour cette personne sera généré automatiquement. L'identifiant aura ce préfixe.";
$pgv_lang["SOURCE_ID_PREFIX"]		= "Préfixe d'identifiant de source";
$pgv_lang["SOURCE_ID_PREFIX_help"]	= "~#pgv_lang[SOURCE_ID_PREFIX]#~<br /><br />Lorsqu'un nouvel enregistrement source est ajouté en ligne dans PhpGedView, un nouvel identifiant pour cette source sera généré automatiquement. L'identifiant aura ce préfixe.";
$pgv_lang["REPO_ID_PREFIX"]		= "Préfixe d'identifiant du dépot";
$pgv_lang["REPO_ID_PREFIX_help"]	= "~#pgv_lang[REPO_ID_PREFIX]#~<br /><br />Lorsqu'un nouvel enregistrement de dépot est ajouté en ligne dans PhpGedView, un nouvel identifiant pour ce dépot sera généré automatiquement. L'identifiant aura ce préfixe.";
$pgv_lang["PEDIGREE_FULL_DETAILS"]	= "Afficher les détails de naissance et de décès sur les graphiques";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"]	= "~#pgv_lang[PEDIGREE_FULL_DETAILS]#~<br /><br />Cette option contrôle s'il faut ou non afficher les détails de naissance et de décès d'une personne sur les graphiques.";
$pgv_lang["PEDIGREE_SHOW_GENDER"]	= "Afficher l'icône de sexe sur les graphiques";
$pgv_lang["PEDIGREE_SHOW_GENDER_help"]	= "~#pgv_lang[PEDIGREE_SHOW_GENDER]#~<br /><br />Cette option contrôle l'affichage ou non de l'icône du sexe de la personne sur les graphiques.<br /><br />Puisque le sexe est également indiqué par la couleur de la case, cette option ne masque pas le sexe. L'option supprime simplement certaines informations en double de la boîte.";
$pgv_lang["PEDIGREE_LAYOUT"]		= "Disposition du graphique d'ascendance par défaut";
$pgv_lang["PEDIGREE_LAYOUT_help"]	= "~#pgv_lang[PEDIGREE_LAYOUT]#~<br /><br />Cette option indique si le tableau d'ascendance doit être généré en mode paysage ou portrait.";
$pgv_lang["SHOW_EMPTY_BOXES"]		= "Afficher les cases vides sur les tableaux d'ascendance";
$pgv_lang["SHOW_EMPTY_BOXES_help"]	= "~#pgv_lang[SHOW_EMPTY_BOXES]#~<br /><br />Cette option contrôle s'il faut ou non afficher les cases vides sur les arbres d'ascendance.";
$pgv_lang["ZOOM_BOXES"]			= "Zoom sur les graphiques";
$pgv_lang["ZOOM_BOXES_help"]		= "~#pgv_lang[ZOOM_BOXES]#~<br /><br />Permet à un utilisateur de zoomer sur les cases des graphiques pour obtenir plus d'informations.<br /><br />Réglez sur <b>#pgv_lang[disabled]#</b> pour désactiver cette fonctionnalité. Réglez sur <b>#pgv_lang[mouseover]#</b> pour zoomer sur les cases lorsque l'utilisateur passe la souris sur l'icône dans la case. Réglez sur <b>#pgv_lang[click]#</b> pour zoomer sur les cases lorsque l'utilisateur clique sur l'icône dans la case.";
$pgv_lang["LINK_ICONS"]			= "Liens sur les graphiques";
$pgv_lang["LINK_ICONS_help"]		= "~#pgv_lang[LINK_ICONS]#~<br /><br />Permet à l'utilisateur de sélectionner des liens vers d'autres graphiques et des proches parents de la personne.<br /><br />Réglez sur <b>#pgv_lang[disabled]#</b> pour désactiver cette fonctionnalité. Réglez sur <b>#pgv_lang[mouseover]#</b> pour faire apparaître les liens lorsque l'utilisateur passe la souris sur l'icône dans la boîte. Réglez sur <b>#pgv_lang[click]#</b> pour afficher les liens lorsque l'utilisateur clique sur l'icône dans la boîte.";
$pgv_lang["ABBREVIATE_CHART_LABELS"]			= "Abréger les libellés dans les graphiques";
$pgv_lang["ABBREVIATE_CHART_LABELS_help"]		= "~#pgv_lang[ABBREVIATE_CHART_LABELS]#~<br /><br />Cette option contrôle s'il faut ou non abréger les libellés comme <b>Naissance</b> sur les graphiques avec juste la première lettre comme <b>N</b>.<br /><br />Vous pouvez personnaliser les abréviations en fournissant remplacer les valeurs dans le fichier <i>languages/extra.xx.php</i> pour chaque langue. Par exemple, si vous souhaitez utiliser <b>*</b> au lieu de <b>N</b> pour abréger le fait BIRT dans la langue française, vous devez mettre l'entrée suivante dans le fichier <i>languages/extra.fr.php</i>:<br /><code>\$factAbbrev[\"BIRT\"]&nbsp;=&nbsp;\"*\";</code><br /><br />Les longueurs d'abréviations spécifiées de cette manière ne sont pas limitées à 1 caractère.";
$pgv_lang["SHOW_AGE_DIFF"]			= "Afficher les différences de date";
$pgv_lang["SHOW_AGE_DIFF_help"]		= "~#pgv_lang[SHOW_AGE_DIFF]#~<br /><br />Cette option contrôle si l’onglet Parents Proches doit afficher ou non les différences entre les dates de naissance des conjoints, entre la date de mariage et la date de naissance du premier enfant et entre les dates de naissance des enfants.";
$pgv_lang["SHOW_PARENTS_AGE"]			= "Afficher l'âge des parents à côté de la date de naissance de l'enfant";
$pgv_lang["SHOW_PARENTS_AGE_help"]		= "~#pgv_lang[SHOW_PARENTS_AGE]#~<br /><br />Cette option contrôle s'il faut ou non afficher l'âge du père et de la mère à côté de la date de naissance de l'enfant sur les graphiques.";
$pgv_lang["SHOW_RELATIVES_EVENTS"]      = "Afficher les événements de parents proches sur la page «Détails personnels»";
$pgv_lang["SHOW_RELATIVES_EVENTS_help"] = "~#pgv_lang[SHOW_RELATIVES_EVENTS]#~<br /><br />Les naissances, les mariages et les décès de parents sont des événements importants dans la vie d'une personne. Cette option détermine si ces événements doivent être affichés ou non dans l'onglet «Faits et détails personnels» de la page «Détails personnels».<br /><br />Les événements concernés par cette option sont:<ul><li>Décès du conjoint</li><li>Naissance et décès d'enfants</li><li>Décès des parents</li><li>Naissance et décès de frères et sœurs</li><li>Décès des grands-parents</li><li>Naissance et décès des frères et sœurs des parents</li></ul>";
$pgv_lang["EXPAND_RELATIVES_EVENTS"]      = "Développer automatiquement la liste des événements de proches parents";
$pgv_lang["EXPAND_RELATIVES_EVENTS_help"] = "~#pgv_lang[EXPAND_RELATIVES_EVENTS]#~<br /><br />Cette option contrôle s'il faut ou non développer automatiquement la liste des <i>Evénements des proches</i>.";
$pgv_lang["EXPAND_SOURCES"]      = "Développer automatiquement les sources";
$pgv_lang["EXPAND_SOURCES_help"] = "~#pgv_lang[EXPAND_SOURCES]#~<br /><br />Cette option contrôle s'il faut ou non afficher automatiquement le contenu d'un enregistrement <i>SOUR</i> sur la page <i>#pgv_lang[personal_details]#</i>.";
$pgv_lang["EXPAND_NOTES"]      = "Développer automatiquement les notes";
$pgv_lang["EXPAND_NOTES_help"] = "~#pgv_lang[EXPAND_NOTES]#~<br /><br />Cette option contrôle s'il faut ou non afficher automatiquement le contenu d'un enregistrement <i>Note</i> sur la page <i>#pgv_lang[personal_details]#</i>.";
$pgv_lang["SHOW_LEVEL2_NOTES"]      = "Afficher toutes les notes et références source dans les onglets Notes et Sources";
$pgv_lang["SHOW_LEVEL2_NOTES_help"] = "~#pgv_lang[SHOW_LEVEL2_NOTES]#~<br /><br />Cette option contrôle si les notes et les références source attachées aux faits doivent être affichées dans les onglets Notes et Sources de la page <i>#pgv_lang[personal_details]#</i>.<br /><br />En général, les onglets Notes et Sources affichent uniquement les notes et les références source qui sont attachés directement à l'enregistrement de la base de données de l'individu. Il s’agit de notes de <i>niveau 1</i> et de références source.<br /><br />L’option <b>#pgv_lang[yes]#</b> fait que ces onglets affichent également des notes et des références source qui font partie des divers faits dans la base de données de la personne. Il s'agit de notes de <i>niveau 2</i> et de références sources car les différents faits sont au niveau 1.";
$pgv_lang["HIDE_LIVE_PEOPLE"]		= "Activer la confidentialité";
$pgv_lang["HIDE_LIVE_PEOPLE_help"]	= "~#pgv_lang[HIDE_LIVE_PEOPLE]#~<br /><br />Cette option activera tous les paramètres de confidentialité et masquera les détails des personnes vivantes.<br /><br />Les personnes vivantes sont définies comme étant celles qui n'ont pas d'événement plus récent que le nombre d'années spécifié par le paramètre <b>#GLOBALS[MAX_ALIVE_AGE]#</b>, qui est actuellement <b>#GLOBALS[MAX_ALIVE_AGE]#</b>. À cette fin, les naissances d'enfants sont également considérées comme de tels événements.";
$pgv_lang["REQUIRE_AUTHENTICATION"]	= "Exiger l'authentification des visiteurs";
$pgv_lang["REQUIRE_AUTHENTICATION_help"]	= "~#pgv_lang[REQUIRE_AUTHENTICATION]#~<br /><br />L'activation de cette option obligera tous les visiteurs à se connecter avant de pouvoir consulter les données du site.";
$pgv_lang["PAGE_AFTER_LOGIN"]		= "Page à afficher après la connexion";
$pgv_lang["PAGE_AFTER_LOGIN_help"]	= "~#pgv_lang[PAGE_AFTER_LOGIN]#~<br /><br />Quelle page les utilisateurs doivent-ils voir après s'être connectés?<br /><br />Le choix effectué ici détermine si une connexion réussie fait apparaître la page Bienvenue ou MyGedView lorsque la connexion est effectuée à partir de la #pgv_lang[welcome_page]#.<br /><br />Une connexion effectuée à partir du lien en haut de chaque autre page ramènera l'utilisateur à cette page.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"]	= "Texte de bienvenue sur la page de connexion";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE]#~<br /><br />Ici, vous pouvez choisir le texte à afficher sur l'écran de connexion. Vous devez déterminer quel texte prédéfini est le plus approprié.<br /><br />Vous pouvez également choisir de saisir votre propre texte de bienvenue personnalisé, mais le texte que vous saisissez ne sera pas traduit lorsque vos utilisateurs changeront de langue. Cependant, si votre texte personnalisé contient des références à des variables de langue que vous pouvez définir dans les différents fichiers <i>languages/extra.xx.php</i>, votre site peut afficher le texte traduit. Veuillez vous reporter au texte d'aide associé au champ <b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#</b> pour plus d'informations.<br /><br />Les textes prédéfinis sont:<ul><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT1]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_1]#</div><br /></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT2]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_2]#</div><br /></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT3]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_3]#</div></li></ul>";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT0"]	= "Aucun texte prédéfini";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"]	= "Texte prédéfini indiquant que tous les utilisateurs peuvent demander un compte utilisateur";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"]	= "Texte prédéfini indiquant que l'administrateur décidera de chaque demande de compte utilisateur";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"]	= "Texte prédéfini indiquant que seuls les membres de la famille peuvent demander un compte d'utilisateur";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"]	= "Choisissez le texte de bienvenue défini par l'utilisateur saisi ci-dessous";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"]	= "Texte de bienvenue personnalisé";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#~<br /><br />Si vous avez opté pour un texte de bienvenue personnalisé, vous pouvez saisir ce texte ici. Le texte ne sera PAS traduit dans la langue du visiteur, mais sera affiché exactement comme vous l'avez tapé. Cependant, si votre texte personnalisé contient des références à des variables de langue que vous pouvez définir dans les différents fichiers <i>languages/extra.xx.php</i>, votre site peut afficher le texte traduit.<br /><br />Vous pouvez insérer des balises HTML dans votre texte d'accueil personnalisé.<br /><br />La description suivante, tirée du texte d'aide de la liste FAQ, s'applique également au texte d'accueil personnalisé.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"] = "En-tête standard pour le texte de bienvenue personnalisé";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD_help"] = "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST_HEAD]#~<br /><br />Choisissez d'afficher un en-tête standard pour votre texte de bienvenue personnalisé. Lorsque vos utilisateurs changent de langue, cet en-tête apparaîtra dans la nouvelle langue.<br /><br />Si défini sur <b>#pgv_lang[yes]#</b>, l'en-tête ressemblera à ceci:<div class=\"list_value_wrap\">#pgv_lang[welcome_text_cust_head]#</div>";
$pgv_lang["SHOW_REGISTER_CAUTION"]			= "Afficher l'accord d'utilisation acceptable sur la page «Demande d'un compte d'utilisateur]»";
$pgv_lang["SHOW_REGISTER_CAUTION_help"]		= "~#pgv_lang[SHOW_REGISTER_CAUTION]#~<br /><br />Si défini sur <b>#pgv_lang[yes]#</b>, le message suivant apparaîtra au-dessus des champs de saisie sur la page <i>#pgv_lang[requestaccount]#</i>:<div class=\"list_value_wrap\">#pgv_lang[acceptable_use]#</div>";
$pgv_lang["CHECK_CHILD_DATES"]		= "Vérifier les dates des enfants";
$pgv_lang["CHECK_CHILD_DATES_help"]	= "~#pgv_lang[CHECK_CHILD_DATES]#~<br /><br />Vérifiez les dates des enfants pour déterminer si une personne est décédée. Sur les systèmes plus anciens et les grands GEDCOM, cela peut ralentir le temps de réponse de votre site.";
$pgv_lang["MAX_ALIVE_AGE"]		= "Âge auquel supposer qu'une personne est décédée";
$pgv_lang["MAX_ALIVE_AGE_help"]		= "~#pgv_lang[MAX_ALIVE_AGE]#~<br /><br />Si cette personne a des événements autres que la mort, l'enterrement ou la crémation plus récents que ce nombre d'années, elle est considérée comme «vivante». Les dates de naissance des enfants sont considérées comme de tels événements à cette fin.";
$pgv_lang["SHOW_GEDCOM_RECORD"]		= "Permettre aux utilisateurs de voir les enregistrements GEDCOM bruts";
$pgv_lang["SHOW_GEDCOM_RECORD_help"]	= "~#pgv_lang[SHOW_GEDCOM_RECORD]#~<br /><br />Définir ceci sur <b>#pgv_lang[yes]#</b> placera des liens sur les personnes, les sources et les familles pour permettre aux utilisateurs d'afficher une autre fenêtre contenant les données brutes extraites du fichier GEDCOM.";
$pgv_lang["ALLOW_EDIT_GEDCOM"]		= "Activer l'édition en ligne";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"]	= "~#pgv_lang[ALLOW_EDIT_GEDCOM]#~<br /><br />Cette option active les fonctionnalités d'édition en ligne pour cette base de données afin que les utilisateurs disposant de privilèges d'édition puissent mettre à jour les données en ligne.";
$pgv_lang["ENABLE_AUTOCOMPLETE"]	= "Activer la saisie semi-automatique";
$pgv_lang["ENABLE_AUTOCOMPLETE_help"]	= "~#pgv_lang[ENABLE_AUTOCOMPLETE]#~<br /><br />Cette option détermine si la saisie semi-automatique doit être active lorsque des informations sont saisies dans certains champs des formulaires de saisie. Lorsque cette option est définie sur <b>#pgv_lang[yes]#</b>, les champs de saisie de texte pour lesquels la saisie semi-automatique est possible sont indiqués par un arrière-plan de couleur différente.<br /><br />Lorsque la saisie semi-automatique est active, PhpGedView recherchera dans sa base de données des correspondances possibles en fonction de ce que vous avez déjà saisi. Lorsque vous entrez plus d'informations, la liste des correspondances possibles est affinée. Lorsque vous voyez l'entrée souhaitée dans la liste des correspondances, vous pouvez déplacer le curseur de la souris sur cette ligne de la liste, puis cliquer sur le bouton gauche de la souris pour terminer la saisie.<br /><br />Les inconvénients de la saisie semi-automatique sont que cela ralentit le programme, entraîne une activité importante de la base de données et entraîne également l'envoi de plus de données au navigateur.";
$pgv_lang["USE_REFN"]		= "Utiliser le numéro de référence";
$pgv_lang["USE_REFN_help"]	= "~#pgv_lang[USE_REFN]#~<br /><br />Cette option détermine si le #factarray[REFN]# entré dans les détails d'une <u>nouvelle</u> personne doit être utilisé comme numéro d'identification de cette nouvelle personne.<br /><br />Lorsque cette option est définie sur <b>#pgv_lang[yes]#</b>, le #factarray[REFN]# entré doit suivre les règles établies pour tous les numéros d'identification, et une personne avec cet ID ne doit pas déjà exister dans le base de données. Si ces conditions ne sont pas remplies, ou lorsque cette option est définie sur <b>#pgv_lang[no]#</b>, PhpGedView attribuera automatiquement le prochain numéro d'identification disponible à cette nouvelle personne.<br /><br />Les numéros d'identification valides ne peuvent contenir que les lettres <b>A</b> à <b>Z</b>, <b>a</b> à <b>z</b>, les chiffres <b>0</b> à <b>9</b>, et les symboles spéciaux <b>. : -</b> et <b>_</b><br /><br />Vous devez également activer l'affichage du #factarray[REFN]# en ajoutant l'entrée <b>REFN</b> aux options de configuration <b>#pgv_lang[INDI_FACTS_UNIQUE]#</b>, <b>#pgv_lang[INDI_FACTS_QUICK]#</b> et <b>#pgv_lang[QUICK_REQUIRED_FACTS]#</b> ci-dessous.";
$pgv_lang["EDIT_AUTOCLOSE"]		= "Fermer automatiquement la fenêtre d'édition";
$pgv_lang["EDIT_AUTOCLOSE_help"]	= "~#pgv_lang[EDIT_AUTOCLOSE]#~<br /><br />Cette option contrôle s'il faut ou non fermer automatiquement la fenêtre d'édition après une mise à jour réussie.";
$pgv_lang["INDEX_DIRECTORY_help"]	= "~#pgv_lang[INDEX_DIRECTORY]#~<br /><br />Le chemin vers un dossier lisible et inscriptible dans lequel PhpGedView doit stocker les fichiers d'index (incluez le «/» de fin). PhpGedView ne nécessite pas que le nom de ce dossier soit «index». Vous pouvez choisir le nom de votre choix.<br /><br />Pour plus de sécurité, ce dossier doit être placé quelque part dans l'espace fichier du serveur qui n'est pas accessible depuis Internet. Un exemple d'une telle structure suit:<br /><b>PhpGedView:</b> dir1/dir2/dir3/PhpGedView<br /><b>Index:</b> dir1/dir4/dir5/dir6/index<br /><br />Pour l'exemple illustré, saisissez <b>../../dir4/dir5/dir6/index/</b> dans ce champ.";
$pgv_lang["POSTAL_CODE"]  = "Position du code postal";
$pgv_lang["POSTAL_CODE_help"] = "~#pgv_lang[POSTAL_CODE]#~<br /><br />Différents pays utilisent différentes manières d'écrire l'adresse. Cette option vous permettra de placer le code postal avant ou après le nom de la ville.";
$pgv_lang["SUBLIST_TRIGGER_I"]		= "Nombre maximum de noms de famille";
$pgv_lang["SUBLIST_TRIGGER_I_help"]	= "~#pgv_lang[SUBLIST_TRIGGER_I]#~<br /><br />Les longues listes de personnes portant le même nom de famille peuvent être divisées en sous-listes plus petites selon la première lettre du prénom de la personne.<br /><br />Cette option détermine quand la sous-liste des noms de famille se produira. Pour désactiver complètement la sous-liste, définissez cette option sur zéro.";
$pgv_lang["SUBLIST_TRIGGER_F"]		= "Nombre maximum de noms de famille";
$pgv_lang["SUBLIST_TRIGGER_F_help"]	= "~#pgv_lang[SUBLIST_TRIGGER_F]#~<br /><br />Les longues listes de familles portant le même nom peuvent être divisées en sous-listes plus petites selon la première lettre du nom donné.<br /><br />Cette option détermine quand la sous-liste des noms de famille se produira. Pour désactiver complètement la sous-liste, définissez cette option sur zéro.";
$pgv_lang["SURNAME_LIST_STYLE"]		= "Style de liste de noms";
$pgv_lang["SURNAME_LIST_STYLE_help"]	= "~#pgv_lang[SURNAME_LIST_STYLE]#~<br /><br />Les listes de noms de famille, telles qu'elles apparaissent dans le bloc #pgv_lang[block_top10]#, la #pgv_lang[individual_list]# et la #pgv_lang[family_list]#, peuvent être affichées dans différents styles.<ul><li><b>#pgv_lang[style2]#</b>&nbsp;&nbsp;&nbsp;Dans ce style, les noms de famille sont affichés dans un tableau qui peut être trié soit par nom de famille, soit par nombre.</li><li><b>#pgv_lang[style3]#</b>&nbsp;&nbsp;&nbsp;Dans ce style, les noms de famille sont affichés dans une liste et la taille de police utilisée pour chaque nom dépend du nombre d'occurrences de ce nom dans la base de données. La liste n'est pas triable.</li></ul>";
$pgv_lang["SHOW_ID_NUMBERS_help"]	= "~#pgv_lang[SHOW_ID_NUMBERS]#~<br /><br />Cette option contrôle s'il faut ou non afficher les numéros d'identification entre parenthèses après les noms sur les graphiques et les listes.";
$pgv_lang["SHOW_LAST_CHANGE"]		= "Afficher la date de la dernière modification sur les listes";
$pgv_lang["SHOW_LAST_CHANGE_help"]	= "~#pgv_lang[SHOW_LAST_CHANGE]#~<br /><br />Cette option contrôle s'il faut ou non afficher la date de la dernière modification sur les listes.";
$pgv_lang["SHOW_EST_LIST_DATES"]		= "Afficher les dates estimées de naissance et de décès";
$pgv_lang["SHOW_EST_LIST_DATES_help"]	= "~#pgv_lang[SHOW_EST_LIST_DATES]#~<br /><br />Cette option contrôle s'il faut ou non afficher les dates estimées de naissance et de décès au lieu de laisser des blancs sur les listes de personnes et les tableaux pour les personnes dont les dates ne sont pas connues.";
$pgv_lang["SHOW_PEDIGREE_PLACES"]	= "Nombre de niveaux de lieu à afficher dans les cases";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"]	= "~#pgv_lang[SHOW_PEDIGREE_PLACES]#~<br /><br />Ceci définit la quantité d'informations de lieu affichées dans les cases de personne sur les graphiques.<br /><br />La définition de la valeur sur 9 garantira l'affichage de tous les niveaux de lieu. Définir la valeur sur 0 masquera complètement les lieux. Régler la valeur sur 1 affichera le premier niveau, le régler sur 2 affichera les deux premiers niveaux, etc.";
$pgv_lang["pageSizeDefault"]			= "Taille de page par défaut";
$pgv_lang["pageSizeDefault_help"]		= "~#pgv_lang[pageSizeDefault]#~<br /><br />Voici la taille de page par défaut pour tous les rapports. Votre choix peut être annulé dans les rapports individuels.";
$pgv_lang["pageSizeOptions"]			= "Tailles de page";
$pgv_lang["pageSizeOptions_help"]		= "~#pgv_lang[pageSizeOptions]#~<br /><br />Voici la liste des tailles de page actuellement prises en charge par PhpGedView lors de la génération de rapports. Vous pouvez étendre cette liste en ajoutant d'autres tailles de page standard comme indiqué dans l'<a href='https://fr.wikipedia.org/wiki/Format_de_papier' title='Article Wikipedia' target='_blank'><b>Article Wikipedia</b></a><br /><ul><li>Le format de page standard pour la plupart des pays du monde est <b>A4</b>, correspondant à 210 x 297 mm (8,3 x 11,7 po.)</li><li>Le format de page standard nord-américain est <b>letter</b>, correspondant à 216 x 279 mm (8,5 x 11,0 po.)</li><li>Les autres formats disponibles sont <b>A3</b>, correspondant à 297 x 420 mm (11,7 x 16,5 po.)</li><li>et <b>legal</b>, correspondant à 216 x 356 mm (8,5 x 14,0 po.)</li></ul><br />La prudence est recommandée lors de l'ajout de formats de papier autres que ceux de la liste ISO «A»; toutes les tailles standard ISO n'ont pas été testées.";
$pgv_lang["fontsDefault"]				= "Police par défaut";
$pgv_lang["fontsDefault_help"]			= "~#pgv_lang[fontsDefault]#~<br /><br />Voici la police par défaut pour tous les rapports. Votre choix peut être annulé dans les rapports individuels.";
$pgv_lang["fontsOptions"]				= "Polices";
$pgv_lang["fontsOptions_help"]			= "~#pgv_lang[fontsOptions]#~<br /><br />Voici la liste des polices actuellement supportées par PhpGedView lors de la génération de rapports.<br /><br />Vous pouvez étendre cette liste ou la raccourcir si nécessaire. La prudence est recommandée lors de l'extension de cette liste; toutes les polices trouvées dans la bibliothèque <i>includes/tcpdf/fonts</i> n'ont pas été testées.";
$pgv_lang["MULTI_MEDIA"]		= "Activer les fonctionnalités multimédia";
$pgv_lang["MULTI_MEDIA_help"]		= "~#pgv_lang[MULTI_MEDIA]#~<br /><br />GEDCOM 5.5.1 vous permet de lier des images, des vidéos et d'autres objets multimédias dans votre GEDCOM. Si vous n'incluez pas d'objets multimédias dans votre GEDCOM, vous pouvez désactiver les fonctionnalités multimédias en définissant cette valeur sur <b>#pgv_lang[no]#</b>.<br /><br />Consultez la section Multimédia du fichier <a href=\"readme.txt\">readme.txt</a> pour plus d'informations sur l'inclusion de médias dans votre site.";
$pgv_lang["MEDIA_EXTERNAL"]			= "Gardez les liens";
$pgv_lang["MEDIA_EXTERNAL_help"]	= "~#pgv_lang[MEDIA_EXTERNAL]#~<br /><br />Lorsqu'un lien multimédia est trouvé commençant par exemple par http://, ftp://, mms://, il ne sera pas modifié Si défini sur <b>#pgv_lang[yes]#</b>. Par exemple, http://www.myfamily.com/photo/dad.jpg restera http://www.myfamily.com/photo/dad.jpg. Si défini sur <b>#pgv_lang[no]#</b>, le lien sera traité comme une référence standard et la profondeur du média sera utilisée. Par exemple: http://www.myfamily.com/photo/dad.jpg sera remplacé par ./media/dad.jpg";
$pgv_lang["MEDIA_DIRECTORY"]		= "Dossier MultiMedia";
$pgv_lang["MEDIA_DIRECTORY_help"]	= "~#pgv_lang[MEDIA_DIRECTORY]#~<br /><br />Le chemin vers un dossier lisible et inscriptible où PhpGedView doit stocker les fichiers multimédias (incluez le «/» de fin). PhpGedView n'exige pas que le nom de ce dossier soit «media». Vous pouvez choisir le nom de votre choix.<br /><br />Même si la fonction de pare-feu multimédia vous permet de stocker des fichiers multimédias dans une zone de l'espace fichier du serveur qui n'est pas accessible depuis Internet, le dossier nommé ici doit toujours exister et doit être lisible depuis Internet et accessible en écriture par PhpGedView. Pour plus d'informations, reportez-vous aux options de configuration du pare-feu multimédia dans la section Multimédia de la page de configuration GEDCOM.";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"]	= "nombre de niveaux de dossier multimédia à conserver";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"]	= "~#pgv_lang[MEDIA_DIRECTORY_LEVELS]#~<br /><br />Une valeur de 0 ignorera tous les répertoires dans le chemin de fichier de l'objet multimédia. Une valeur de 1 conservera le premier dossier contenant cette image. L'augmentation du nombre augmente le nombre de répertoires parents à conserver dans le chemin.<br /><br />Par exemple, si vous liez une image dans votre GEDCOM avec un chemin comme <b>C:\\Documents&nbsp;and&nbsp;Settings\\User\\My&nbsp;Documents\\My&nbsp;Pictures\\Genealogy\\Surname&nbsp;Line\\grandpa.jpg</b>, une valeur de 0 traduira ce chemin en <b>./media/grandpa.jpg</b>. Une valeur de 1 traduira ceci en <b>./media/Surname&nbsp;Line/grandpa.jpg</b>, etc. La plupart des gens n'auront besoin que d'un 0. Cependant, il est possible que certains objets multimédias soient conservés dans différents répertoires ont des noms identiques et se remplaceraient lorsque cette option est définie sur 0. Les paramètres différents de zéro vous permettent de conserver une certaine organisation dans votre média, évitant ainsi les collisions de noms.";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"]	= "~#pgv_lang[SHOW_HIGHLIGHT_IMAGES]#~<br /><br />Si vous avez activé le multimédia sur votre site, vous pouvez faire en sorte que PhpGedView affiche une image miniature à côté du nom de la personne dans les graphiques et les encadrés.<br /><br />Voir la section Multimédia dans le fichier <a href=\"readme.txt\">readme.txt</a> pour plus d'informations sur l'inclusion de contenu multimédia dans votre site.";
$pgv_lang["USE_THUMBS_MAIN"]	= "Utiliser la vignette";
$pgv_lang["USE_THUMBS_MAIN_help"]	= "~#pgv_lang[USE_THUMBS_MAIN]#~<br /><br />Cette option détermine si PhpGedView doit envoyer la grande ou la petite image au navigateur chaque fois qu'un graphique ou la page <i>#pgv_lang[personal_details]#</i> nécessite une miniature.<br /><br />Le choix <b>#pgv_lang[no]#</b> entraînera l'envoi de la grande image par PhpGedView, tandis que le choix <b>#pgv_lang[yes]#</b> provoquera l'envoi de la petite image. Chaque image individuelle a également l'option «#factarray[_THUM]#» qui, lorsqu'elle est réglée sur <b>#pgv_lang[yes]#</b>, provoquera l'envoi de la grande image quel que soit le réglage de l'option «#pgv_lang[USE_THUMBS_MAIN]#» dans la configuration GEDCOM. Vous ne pouvez pas forcer PhpGedView à envoyer de petites images lorsque la configuration GEDCOM spécifie que de grandes images doivent toujours être utilisées.<br /><br />PhpGedView ne redimensionne pas l'image envoyée; le navigateur le fait selon les spécifications de page qu'il a également reçues. Cela peut avoir des conséquences indésirables lorsque l'image envoyée n'est pas vraiment une vignette où PhpGedView s'attend à envoyer une petite image. Ce n'est pas une erreur: il y a des occasions où il peut être souhaitable d'afficher une grande image à des endroits où l'on s'attend normalement à voir une image de la taille d'une miniature.<br /><br />Vous devriez éviter de définir l'option «#pgv_lang[USE_THUMBS_MAIN]#» option à <b>#pgv_lang[no]#</b>. Ce choix entraînera l'envoi de quantités excessives de données liées à l'image au navigateur, uniquement pour que le navigateur rejette l'excédent. Le chargement des pages, en particulier des graphiques contenant de nombreuses images, peut être considérablement ralenti.";
$pgv_lang["SHOW_MEDIA_FILENAME"]		= "Afficher le nom du fichier dans le visualiseur multimédia";
$pgv_lang["SHOW_MEDIA_FILENAME_help"]	= "~#pgv_lang[SHOW_MEDIA_FILENAME]#~<br /><br />Le visualiseur multimédia peut afficher le nom du fichier multimédia en cours de visualisation. Cette option détermine si ce nom de fichier est présenté aux utilisateurs ou non.<br /><br />Vous pouvez masquer le nom de fichier pour des raisons de sécurité.";
$pgv_lang["SHOW_MEDIA_DOWNLOAD"]		= "Afficher le lien de téléchargement dans le visualiseur multimédia";
$pgv_lang["SHOW_MEDIA_DOWNLOAD_help"]	= "~#pgv_lang[SHOW_MEDIA_DOWNLOAD]#~<br /><br />Le visualiseur multimédia peut afficher un lien qui, une fois cliqué, téléchargera le fichier multimédia sur le PC local.<br /><br />Vous pouvez masquer le lien de téléchargement pour des raisons de sécurité.";
$pgv_lang["ENABLE_CLIPPINGS_CART"]	= "Enable Clippings Cart";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"]	= "~#pgv_lang[ENABLE_CLIPPINGS_CART]#~<br /><br />Le panier de coupures permet aux utilisateurs d'ajouter des personnes à un fichier temporaire qu'ils peuvent télécharger au format GEDCOM pour une importation ultérieure dans leur logiciel de généalogie.";
$pgv_lang["HIDE_GEDCOM_ERRORS"]		= "Masquer les erreurs GEDCOM";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"]	= "~#pgv_lang[HIDE_GEDCOM_ERRORS]#~<br /><br />Le paramétrer sur <b>#pgv_lang[yes]#</b> masquera les messages d'erreur produits par PhpGedView lorsqu'il ne comprend pas une balise dans votre fichier GEDCOM. PhpGedView met tout en œuvre pour se conformer à la norme GEDCOM 5.5.1, mais de nombreux logiciels de généalogie incluent leurs propres balises personnalisées. Consultez le fichier <a href=\"readme.txt\">readme.txt</a> pour plus d'informations.";
$pgv_lang["WORD_WRAPPED_NOTES"]		= "Ajouter des espaces où les notes ont été enveloppées";
$pgv_lang["WORD_WRAPPED_NOTES_help"]	= "~#pgv_lang[WORD_WRAPPED_NOTES]#~<br /><br />Certains programmes de généalogie enveloppent les notes aux limites des mots tandis que d'autres enveloppent les notes n'importe où. Cela peut amener PhpGedView à exécuter des mots ensemble. Définir ceci sur <b>#pgv_lang[yes]#</b> ajoutera un espace entre les mots là où ils sont enveloppés dans le GEDCOM original.";
$pgv_lang["SHOW_CONTEXT_HELP"]		= "Afficher les liens d'aide contextuels";
$pgv_lang["SHOW_CONTEXT_HELP_help"]	= "~#pgv_lang[SHOW_CONTEXT_HELP]#~<br /><br />Cette option activera les liens, identifiés par des points d'interrogation, à côté des éléments sur de nombreuses pages. Ces liens permettent aux utilisateurs d'obtenir des informations ou de l'aide sur ces éléments.";
$pgv_lang["DAYS_TO_SHOW_LIMIT"]		= "limite de jours du bloc Événements à venir";
$pgv_lang["DAYS_TO_SHOW_LIMIT_help"] = "~#pgv_lang[DAYS_TO_SHOW_LIMIT]#~<br /><br />Entrez le nombre maximum de jours à afficher dans les blocs Événements à venir. Ce nombre ne peut pas être supérieur à 30. Si vous entrez une valeur plus grande, 30 sera utilisé.<br /><br />La valeur que vous entrez ici détermine la distance à laquelle PhpGedView regarde lors de la recherche d'événements à venir. Les résultats de cette recherche, effectuée une fois par jour, sont copiés dans un fichier temporaire.<br /><br />Aucun bloc d'événements à venir sur les pages d'index ou de portail ne peut demander plus de jours que cette valeur. Plus vous faites cela, plus il faudra de temps pour créer l'extrait de base de données quotidien, et plus il faudra de temps pour afficher le bloc, même si vous demandez d'afficher un nombre de jours inférieur à ce paramètre.";
$pgv_lang["COMMON_NAMES_THRESHOLD"]	= "Nombre minimum d'occurrences pour être un «Nom de famille fréquent»";
$pgv_lang["COMMON_NAMES_THRESHOLD_help"]	= "~#pgv_lang[COMMON_NAMES_THRESHOLD]#~<br /><br />C'est le nombre de fois qu'un nom de famille doit apparaître avant qu'il n'apparaisse dans la liste des noms fréquents sur la page d'accueil.";
$pgv_lang["COMMON_NAMES_ADD"]	= "Noms à ajouter à la liste des noms de famille fréquents";
$pgv_lang["COMMON_NAMES_ADD_help"]	= "~#pgv_lang[COMMON_NAMES_ADD]#~<br /><br />Si le nombre de fois qu'un certain nom de famille apparaît est inférieur au seuil, il n'apparaîtra pas dans la liste. Il peut être ajouté ici manuellement. Si plusieurs noms de famille sont saisis, ils doivent être séparés par une virgule. <b>Les noms de famille sont sensibles aux majuscules et miniscules.</b>";
$pgv_lang["COMMON_NAMES_REMOVE"]	= "Noms à supprimer de la liste des noms de famille fréquents";
$pgv_lang["COMMON_NAMES_REMOVE_help"]	= "~#pgv_lang[COMMON_NAMES_REMOVE]#~<br /><br />Si vous souhaitez supprimer un nom de famille de la liste des noms fréquents sans augmenter la valeur de seuil, vous pouvez le faire en saisissant le nom ici. Si plusieurs noms de famille sont saisis, ils doivent être séparés par une virgule. <b>Les noms de famille sont sensibles aux majuscules et miniscules.</b> Les noms de famille saisis ici seront également supprimés de la liste des 10 fréquents sur la page d'accueil.";
$pgv_lang["HOME_SITE_URL"]		= "URL du site Web principal";
$pgv_lang["HOME_SITE_URL_help"]		= "~#pgv_lang[HOME_SITE_URL]#~<br /><br />Chaque page PhpGedView comprend un lien vers votre page d'accueil principale. L'apparence de ce lien est contrôlée par le thème utilisé. Vous entrez ici l'URL réelle de votre site d'accueil.";
$pgv_lang["HOME_SITE_TEXT"]		= "Texte du site Web principal";
$pgv_lang["HOME_SITE_TEXT_help"]	= "~#pgv_lang[HOME_SITE_TEXT]#~<br /><br />La légende utilisée pour identifier le lien vers votre page d'accueil principale.";
$pgv_lang["CONTACT_EMAIL"]		= "Contact pour la généalogie";
$pgv_lang["CONTACT_EMAIL_help"]		= "~#pgv_lang[CONTACT_EMAIL]#~<br /><br />La personne à contacter au sujet des données généalogiques sur ce site.";
$pgv_lang["CONTACT_METHOD"]		= "Méthode de contact";
$pgv_lang["CONTACT_METHOD_help"]	= "~#pgv_lang[CONTACT_METHOD]#~<br /><br />La méthode à utiliser pour contacter le #pgv_lang[CONTACT_EMAIL]# à propos des questions de généalogie.#pgv_lang[CONTACT_METHOD_desc]#";
$pgv_lang["CONTACT_METHOD_desc"] = "<ul><li>L'option <b>#pgv_lang[mailto]#</b> créera un lien «mailto» sur lequel on pourra cliquer pour envoyer un email en utilisant le client de messagerie sur le PC de l'utilisateur.</li><li>L'option <b>#pgv_lang[messaging]#</b> utilisera un système de messagerie interne à PhpGedView, et aucun e-mail ne sera envoyé.</li><li>L'option <b>#pgv_lang[messaging2]#</b> est la valeur par défaut. Il utilisera le système de messagerie PhpGedView et enverra également des copies des messages par e-mail.</li><li>L'option <b>#pgv_lang[messaging3]#</b> permet à PhpGedView de gérer la messagerie et enverra les messages sous forme d'e-mails, mais ne les stockera pas en interne. Cette option est similaire à l'option <b>#pgv_lang[mailto]#</b>, sauf que le message sera envoyé par PhpGedView au lieu du poste de travail de l'utilisateur.</li><li>L'option <b>#pgv_lang[no_messaging]#</b> empêche vos utilisateurs de vous contacter.</li></ul>";
$pgv_lang["PHPGEDVIEW_EMAIL"]		= "Adresse de réponse PhpGedView";
$pgv_lang["PHPGEDVIEW_EMAIL_help"]	= "~#pgv_lang[PHPGEDVIEW_EMAIL]#~<br /><br />Adresse e-mail à utiliser dans le champ «De:» des e-mails que PhpGedView crée automatiquement.<br /><br />PhpGedView peut créer automatiquement des e-mails pour informer les administrateurs des changements qui doivent être examinés. PhpGedView envoie également des e-mails de notification aux utilisateurs qui ont demandé un compte.<br /><br />Habituellement, le champ «De:» de ces e-mails créés automatiquement est quelque chose comme <i>De: phpgedview-noreply@votresite</i> pour montrer qu'aucune réponse à l'e-mail n'est requise. Pour se prémunir contre les spams ou autres abus de courrier électronique, certains systèmes de messagerie exigent que le champ «De:» de chaque message reflète un compte de messagerie valide et n'accepteront pas les messages qui proviennent apparemment du compte <i>phpgedview-noreply</i>.";
$pgv_lang["WEBMASTER_EMAIL"]		= "Contact pour l'assistance";
$pgv_lang["WEBMASTER_EMAIL_help"]	= "~#pgv_lang[WEBMASTER_EMAIL]#~<br /><br />La personne à contacter pour des questions techniques ou des erreurs rencontrées sur votre site.";
$pgv_lang["SUPPORT_METHOD"]		= "Méthode d'assistance";
$pgv_lang["SUPPORT_METHOD_help"]	= "~#pgv_lang[SUPPORT_METHOD]#~<br /><br />La méthode à utiliser pour contacter le #pgv_lang[WEBMASTER_EMAIL]# à propos de questions techniques.#pgv_lang[CONTACT_METHOD_desc]#";
$pgv_lang["SHOW_FACT_ICONS"] 		= "Afficher les icônes de faits";
$pgv_lang["SHOW_FACT_ICONS_help"]	= "~#pgv_lang[SHOW_FACT_ICONS]#~<br /><br />Définissez ceci sur <b>#pgv_lang[yes]#</b> pour afficher les icônes près des noms de faits sur la page <i>#pgv_lang[personal_details]#</i>. Les icônes de faits ne seront affichées que si elles existent dans le dossier <i>images/facts</i> du thème actuel.";
$pgv_lang["FAVICON"]			= "Icône Favoris";
$pgv_lang["FAVICON_help"]		= "~#pgv_lang[FAVICON]#~<br /><br />Modifiez-le pour qu'il pointe vers l'icône que vous souhaitez afficher dans le menu des favoris des visiteurs lorsqu'ils ajoutent un signet à votre site.";
$pgv_lang["THEME_DIR"]			= "Dossier de thème";
$pgv_lang["THEME_DIR_help"]		= "~#pgv_lang[THEME_DIR]#~<br /><br />Le dossier dans lequel sont conservés vos fichiers de thème PhpGedView.<br /><br />Vous pouvez personnaliser n'importe lequel des thèmes standard fournis avec PhpGedView pour donner à votre site une apparence et une sensation uniques. Consultez la section Personnalisation du thème du fichier <a href=\"readme.txt\">readme.txt</a> pour plus d'informations.";
$pgv_lang["TIME_LIMIT"]			= "Limite de temps PHP";
$pgv_lang["TIME_LIMIT_help"]		= "~#pgv_lang[TIME_LIMIT]#~<br /><br />Durée maximale en secondes pendant laquelle PhpGedView doit être autorisé à s'exécuter.<br /><br />La valeur par défaut est de 1 minute. En fonction de la taille de votre fichier GEDCOM, vous devrez peut-être augmenter cette limite de temps lorsque vous devrez créer les index. Définissez cette valeur sur 0 pour permettre à PHP de s'exécuter indéfiniment.<br /><br />ATTENTION: Si vous définissez cette valeur sur 0 ou si elle est trop élevée, votre site pourrait se bloquer sur certains systèmes d'exploitation jusqu'à la fin du script. Le définir sur 0 signifie qu'il peut ne jamais se terminer tant qu'un administrateur de serveur n'a pas tué le processus ou redémarré le serveur. Un grand tableau d'ascendance peut prendre beaucoup de temps à s'exécuter; laisser cette valeur aussi basse que possible garantit que quelqu'un ne peut pas planter votre serveur en demandant un graphique trop volumineux.";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"]	= "~#pgv_lang[PGV_SESSION_SAVE_PATH]#~<br /><br />Le chemin pour stocker les fichiers de session PhpGedView.<br /><br />Certains hôtes n'ont pas configuré PHP correctement et les sessions ne sont pas maintenues entre les requêtes de page. Cette option permet aux administrateurs de site de surmonter ce problème en enregistrant les fichiers dans l'un de leurs répertoires locaux. Le dossier ./index/ est un bon choix si vous devez changer cela. La valeur par défaut est de laisser le champ vide, qui utilisera le chemin de sauvegarde tel que configuré dans <i>php.ini</i>.";
$pgv_lang["SERVER_URL_help"]		= "~#pgv_lang[SERVER_URL]#~<br /><br />Si vous utilisez https ou un port autre que celui par défaut, vous devrez entrer l'URL pour accéder à votre serveur ici.";
$pgv_lang["LOGIN_URL"]			= "URL de connexion";
$pgv_lang["LOGIN_URL_help"]		= "~#pgv_lang[LOGIN_URL]#~<br /><br /> Vous ne devez entrer une URL de connexion que si vous souhaitez rediriger vers un site ou un emplacement différent lorsque vos utilisateurs se connectent. Ceci est très utile si vous devez passer de http à https lorsque vos utilisateurs se connectent. Incluez l'URL complète de <i>login.php</i>. Par exemple, https://www.votreserveur.com/phpgedview/login.php .";
$pgv_lang["PGV_SESSION_TIME_help"]	= "~#pgv_lang[PGV_SESSION_TIME]#~<br /><br />Durée en secondes pendant laquelle une session PhpGedView reste active avant d'exiger une connexion. La valeur par défaut est 7200, soit 2 heures.";
$pgv_lang["SHOW_STATS"]			= "Afficher les statistiques d'exécution";
$pgv_lang["SHOW_STATS_help"]		= "~#pgv_lang[SHOW_STATS]#~<br /><br />Afficher les statistiques d'exécution et les requêtes de base de données au bas de chaque page.";
$pgv_lang["SHOW_COUNTER"]		= "Afficher les compteurs d'accès";
$pgv_lang["SHOW_COUNTER_help"]		= "~#pgv_lang[SHOW_COUNTER]#~<br /><br />Afficher les compteurs d'accès sur les pages portail et <i>#pgv_lang[personal_details]#</i>.";
$pgv_lang["USE_REGISTRATION_MODULE_help"]	= "~#pgv_lang[USE_REGISTRATION_MODULE]#~<br /><br />Donne aux visiteurs la possibilité de s'inscrire eux-mêmes pour un compte sur le site.<br /><br />Le visiteur recevra un e-mail avec un code pour vérifier sa demande de compte. Après vérification, l'administrateur devra approuver l'enregistrement avant qu'il ne devienne actif.";
$pgv_lang["ALLOW_USER_THEMES_help"]	= "~#pgv_lang[ALLOW_USER_THEMES]#~<br /><br />Donne aux utilisateurs la possibilité de sélectionner leur propre thème.";
$pgv_lang["PGV_SIMPLE_MAIL_help"] = "~#pgv_lang[PGV_SIMPLE_MAIL]#~<br /><br />Dans les en-têtes de courrier normaux pour les courriers externes, l'adresse e-mail ainsi que le nom sont utilisés. Certains systèmes de messagerie n'accepteront pas cela. Si défini sur <b>#pgv_lang[yes]#</b>, seule l'adresse e-mail sera utilisée.";
$pgv_lang["PGV_SMTP_ACTIVE_help"] = "~#pgv_lang[PGV_SMTP_ACTIVE]#~<br /><br />Utilisez SMTP pour envoyer des e-mails depuis PhpGedView.<br /><br />Cette option nécessite l'accès à un serveur de messagerie SMTP. Si défini sur <b>#pgv_lang[no]#</b>, PhpGedView utilisera le système de messagerie intégré à PHP sur ce serveur.";
$pgv_lang["PGV_SMTP_DEBUG_help"] = "~#pgv_lang[PGV_SMTP_DEBUG]#~<br /><br />Lorsque l'option <b>#pgv_lang[PGV_SMTP_ACTIVE]#</b> est définie sur <b>#pgv_lang[yes]#</b>, PhpGedView utilisera le programme PHPMailer pour envoyer des e-mails. Ce programme génère des messages d'erreur lorsqu'il rencontre des problèmes lors de la tentative d'envoi d'e-mails.<br /><br />Cette option, qui est utile pour résoudre les problèmes d'envoi d'e-mails, détermine les types d'erreurs que PHPMailer signalera. Les types d'erreur que vous pouvez sélectionner sont:<ul><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION0]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION1]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION2]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION3]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION4]#</li></ul>";
$pgv_lang["PGV_SMTP_HOST_help"] = "~#pgv_lang[PGV_SMTP_HOST]#~<br /><br />C'est le nom du serveur de messagerie SMTP. Exemple: <b>smtp.foo.bar.com</b>.<br /><br />Valeurs de configuration pour certains fournisseurs de messagerie:<br /><br /><b>Gmail</b><br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_HOST]#:&nbsp;&nbsp;smtp.gmail.com<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_PORT]#:&nbsp;&nbsp;465 ou 587<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_SSL]#:&nbsp;&nbsp;SSL<br /><br /><b>Hotmail</b><br />&nbsp;&nbsp;&nbsp#pgv_lang[PGV_SMTP_HOST]#:&nbsp;&nbsp;smtp.live.com<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_PORT]#:&nbsp;&nbsp;25 ou 587<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_SSL]#:&nbsp;&nbsp;TLS<br /><br /><b>Yahoo Mail Plus</b> (currently a paid service)<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_HOST]#:&nbsp;&nbsp;smtp.mail.yahoo.com<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_PORT]#:&nbsp;&nbsp;25";
$pgv_lang["PGV_SMTP_HELO_help"] = "~#pgv_lang[PGV_SMTP_HELO]#~<br /><br />C'est le domain d'une adresse e-mail valide sur le serveur SMTP.<br /><br />Par exemple, si vous avez un compte e-mail tel que <b>votrenom@abc.xyz.com</b>, vous saisissez ici <b>abc.xyz.com</b>.";
$pgv_lang["PGV_SMTP_PORT_help"] = "~#pgv_lang[PGV_SMTP_PORT]#~<br /><br />Numéro de port à utiliser pour les connexions au serveur SMTP. Généralement, ic'est le port <b>25</b>.";
$pgv_lang["PGV_SMTP_AUTH_help"] = "~#pgv_lang[PGV_SMTP_AUTH]#~<br /><br />Utilisez l'authentification par nom et mot de passe pour vous connecter au serveur SMTP.<br /><br />Certains serveurs SMTP exigent que toutes les connexions soient authentifiées avant d'accepter les e-mails sortants.";
$pgv_lang["PGV_SMTP_AUTH_USER_help"] = "~#pgv_lang[PGV_SMTP_AUTH_USER]#~<br /><br />Le nom d'utilisateur requis pour l'authentification auprès du serveur SMTP.";
$pgv_lang["PGV_SMTP_AUTH_PASS_help"] = "~#pgv_lang[PGV_SMTP_AUTH_PASS]#~<br /><br />Le mot de passe requis pour l'authentification auprès du serveur SMTP.";
$pgv_lang["PGV_SMTP_SSL_help"]		 = "~#pgv_lang[PGV_SMTP_SSL]#~<br /><br />Transport Layer Security (TLS) et Secure Sockets Layer (SSL) sont des protocoles de cryptage de données Internet.<br /><br />TLS 1.0, 1.1 et 1.2 sont des développements standardisés de SSL 3.0. TLS 1.0 et SSL 3.1 sont équivalents. D'autres travaux sur SSL sont maintenant effectués sous le nouveau nom, TLS.<br /><br />Si votre serveur SMTP requiert le protocole SSL lors de la connexion, vous devez sélectionner l'option <b>SSL</b>. Si votre serveur SMTP nécessite le protocole TLS lors de la connexion, vous devez sélectionner l'option <b>TLS</b>.";
$pgv_lang["PGV_SMTP_FROM_NAME_help"] = "~#pgv_lang[PGV_SMTP_FROM_NAME]#~<br /><br />Entrez le nom à utiliser dans le champ «De:» des e-mails provenant de ce site.<br /><br />Par exemple, si votre nom est <b>John Smith</b> et que vous êtes le administrateur de site pour un site connu sous le nom de <b>Généalogie Jones</b>, vous pouvez saisir quelque chose comme <b>John&nbsp;Smith</b> ou <b>Généalogie&nbsp;Jones</b> ou même <b>John&nbsp;Smith&nbsp;Administrateur:&nbsp;Généalogie&nbsp;Jones</b>. Vous pouvez saisir ce que vous souhaitez, mais le HTML n'est pas autorisé.";
$pgv_lang["gedcom_title"]			= "#pgv_lang[ged_title]#";
$pgv_lang["gedcom_title_help"]		= "~#pgv_lang[gedcom_title]#~<br /><br />Saisissez un titre descriptif à afficher lorsque les utilisateurs choisissent parmi les ensembles de données GEDCOM de votre site.";
$pgv_lang["LOGFILE_CREATE"]		= "Archiver les fichiers journaux";
$pgv_lang["LOGFILE_CREATE_help"]	= "~#pgv_lang[LOGFILE_CREATE]#~<br /><br />À quelle fréquence le programme doit-il archiver les fichiers journaux?";
$pgv_lang["REMINDER_FREQ"] 			= "Fréquence des e-mails de rappel «Examiner les modifications»";
$pgv_lang["REMINDER_FREQ_help"]		= "~#pgv_lang[REMINDER_FREQ]#~<br /><br />Cette option contrôle la fréquence d'envoi des e-mails de rappel «Examiner les modifications». <b>zéro</b>: jamais;&nbsp;&nbsp;<b>1</b>: tous les jours;&nbsp;&nbsp;<b>2</b>: tous les 2 jours; etc.";
$pgv_lang["PGV_MEMORY_LIMIT_help"]	= "~#pgv_lang[PGV_MEMORY_LIMIT]#~<br /><br />La quantité maximale de mémoire qui peut être consommée par les scripts PhpGedView. La valeur par défaut est de 64 Mo. De nombreux hôtes désactivent cette option dans leur configuration PHP; la modification de cette valeur peut ne pas réellement affecter le paramètre de mémoire maximale actuelle.";
$pgv_lang["PGV_STORE_MESSAGES_help"]	= "~#pgv_lang[PGV_STORE_MESSAGES]#~<br /><br />Spécifie si les messages envoyés via PhpGedView peuvent être stockés dans la base de données. Si défini sur <b>#pgv_lang[yes]#</b>, les utilisateurs pourront récupérer leurs messages lorsqu'ils se connecteront à PhpGedView. Si défini sur <b>#pgv_lang[no]#</b>, les messages ne seront envoyés que par e-mail.";
$pgv_lang["ALLOW_THEME_DROPDOWN"]		= "Afficher le menu de thème pour les changements de thème";
$pgv_lang["ALLOW_THEME_DROPDOWN_help"]	= "~#pgv_lang[ALLOW_THEME_DROPDOWN]#~<br /><br />Donne aux utilisateurs la possibilité de sélectionner leur propre thème dans un menu.<br /><br />Même avec cet ensemble d'options, le thème actuellement en vigueur peut ne pas prévoir un tel menu. Pour être efficace, cette option nécessite que l'option <b>#pgv_lang[ALLOW_USER_THEMES]#</b> soit également définie.";
$pgv_lang["MAX_VIEW_RATE"]		= "Taux maximal d'affichage des pages";
$pgv_lang["MAX_VIEW_RATE_help"]	= "~#pgv_lang[MAX_VIEW_RATE]#~<br /><br />Cette option limite le taux auquel un utilisateur peut afficher les pages.<br /><br />Si ce taux est dépassé, PhpGedView traite la session comme une tentative de piratage; la session se terminera par un message approprié. Ces deux valeurs doivent placer une limite raisonnable sur la quantité de bande passante et les octets téléchargés à partir du serveur. Cette fonction peut être désactivée en réglant l'intervalle de temps sur 0.";
$pgv_lang["META_AUTHOR"]		= "META tag: Author (Auteur)";
$pgv_lang["META_AUTHOR_help"]	= "~#pgv_lang[META_AUTHOR]#~<br /><br />Valeur à placer dans la balise Meta Author (Auteur) dans l'en-tête de page HTML. #pgv_lang[META_AUTHOR_descr]#";
$pgv_lang["META_AUTHOR_descr"]	= "Laissez ce champ vide pour utiliser le nom complet du #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_PUBLISHER"]		= "META tag: Publisher (Éditeur)";
$pgv_lang["META_PUBLISHER_help"]	= "~#pgv_lang[META_PUBLISHER]#~<br /><br />Valeur à placer dans la balise Meta Publisher (Éditeur) dans l'en-tête de page HTML. #pgv_lang[META_PUBLISHER_descr]#";
$pgv_lang["META_PUBLISHER_descr"]	= "Laissez ce champ vide pour utiliser le nom complet du #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_COPYRIGHT"]		= "META tag: Copyright";
$pgv_lang["META_COPYRIGHT_help"]	= "~#pgv_lang[META_COPYRIGHT]#~<br /><br />Valeur à placer dans la balise Meta Copyright (Droits d'auteur) de l'en-tête de page HTML. #pgv_lang[META_COPYRIGHT_descr]#";
$pgv_lang["META_COPYRIGHT_descr"]	= "Laissez ce champ vide pour utiliser le nom complet du #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_DESCRIPTION"]		= "META tag: Description";
$pgv_lang["META_DESCRIPTION_help"]	= "~#pgv_lang[META_DESCRIPTION]#~<br /><br />Valeur à placer dans la balise meta Description de l'en-tête de page HTML. #pgv_lang[META_DESCRIPTION_descr]#";
$pgv_lang["META_DESCRIPTION_descr"]	= "Laissez ce champ vide pour utiliser le titre de la base de données actuellement active.";
$pgv_lang["META_PAGE_TOPIC"]		= "META tag: Page-Topic (Suject)";
$pgv_lang["META_PAGE_TOPIC_help"]	= "~#pgv_lang[META_PAGE_TOPIC]#~<br /><br />La valeur à placer dans la balise Meta Page-topic (Sujet) dans l'en-tête de page HTML. #pgv_lang[META_PAGE_TOPIC_descr]#";
$pgv_lang["META_PAGE_TOPIC_descr"]	= "Laissez ce champ vide pour utiliser le titre de la base de données actuellement active.";
$pgv_lang["META_AUDIENCE"]		= "META tag: Audience";
$pgv_lang["META_AUDIENCE_help"]	= "~#pgv_lang[META_AUDIENCE]#~<br /><br />Valeur à placer dans la balise Meta Audience (Public) de l'en-tête de page HTML.";
$pgv_lang["META_PAGE_TYPE"]		= "META tag: Page-type";
$pgv_lang["META_PAGE_TYPE_help"]	= "~#pgv_lang[META_PAGE_TYPE]#~<br /><br />Valeur à placer dans la balise Meta Page-type (Type de page) dans l'en-tête de page HTML.";
$pgv_lang["META_ROBOTS"]		= "META tag: Robots";
$pgv_lang["META_ROBOTS_help"]	= "~#pgv_lang[META_ROBOTS]#~<br /><br />Valeur à placer dans la balise Meta Robots (moteurs de recherche) dans l'en-tête de page HTML. Certains moteurs de recherche ignorent cette valeur.";
$pgv_lang["META_REVISIT"]		= "META tag: Revisit";
$pgv_lang["META_REVISIT_help"]	= "~#pgv_lang[META_REVISIT]#~<br /><br />À quelle fréquence les moteurs de recherche doivent-ils revenir? Valeur à placer dans la balise Meta Revisit (Revenir) dans l'en-tête de page HTML. Certains moteurs de recherche ignorent cette valeur.";
$pgv_lang["META_KEYWORDS"]		= "META tag: Keywords";
$pgv_lang["META_KEYWORDS_help"]	= "~#pgv_lang[META_KEYWORDS]#~<br /><br />Valeur à placer dans la balise Meta Keywords (mots clés) de l'en-tête de page HTML. Certains moteurs de recherche utiliseront la balise Meta Keywords pour indexer votre page.<br /><br />La liste #pgv_lang[common_surnames]# qui apparaît dans le bloc #pgv_lang[gedcom_stats]# sur votre page d'accueil peut également être ajoutée à tout ce que vous entrez ici.";
$pgv_lang["META_TITLE"]		= "Ajouts à la balise d'en-tête TITLE";
$pgv_lang["META_TITLE_help"]	=	"~#pgv_lang[META_TITLE]#~<br /><br />Tout ce qui se trouve sur cette ligne sera ajouté à la balise TITLE dans l'en-tête de la page HTML après le titre de la page normale et avant le crédit PhpGedView.";

$pgv_lang["ENABLE_RSS"]				= "Activer RSS";
$pgv_lang["ENABLE_RSS_help"]		= "~#pgv_lang[ENABLE_RSS]#~<br /><br />Cette option vous permet de désactiver la fonction RSS.<br /><br />RSS permet aux utilisateurs de surveiller votre site pour les modifications apportées à la page d'index sans réellement visiter votre site périodiquement. Si trop d'utilisateurs utilisent cette fonctionnalité ou si la fréquence de rafraîchissement définie par ces utilisateurs est trop élevée, RSS peut utiliser trop de bande passante ou de capacité du serveur.<br /><br />Cet <a href='https://fr.wikipedia.org/wiki/RSS' target='_blank' title='Article Wikipédia'><b>Article Wikipédia</b></a> contient des informations complètes et des liens sur RSS et les différents formats RSS.";
$pgv_lang["RSS_FORMAT"]				= "Format RSS";
$pgv_lang["RSS_FORMAT_help"]		= "~#pgv_lang[RSS_FORMAT]#~<br /><br />Format à utiliser comme format de flux par défaut pour le site. Les suffixes numériques <u>n'indiquent pas</u> la version: ils identifient les formats. Par exemple, RSS 2.0 n'est pas plus récent que RSS 1.0, mais dans un format différent. Les lecteurs de flux doivent pouvoir lire n'importe quel format.<br /><br />Cet <a href='https://fr.wikipedia.org/wiki/RSS' target='_blank' title='Article Wikipédia'><b>Article Wikipédia</b></a> contient des informations complètes et des liens sur RSS et les différents formats RSS.";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE"] = "Vérifiez si les fichiers GEDCOM sont téléchargeables";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE_help"] = "~#pgv_lang[SECURITY_CHECK_GEDCOM_DOWNLOADABLE]#~<br /><br />Pour des raisons de sécurité, les fichiers GEDCOM ne doivent pas se trouver dans un emplacement où ils peuvent être téléchargés directement, contournant ainsi les contrôles de confidentialité. En cliquant sur ce lien, vous vérifierez si vos fichiers GEDCOM peuvent être téléchargés sur le réseau.<br /><br />Sur certains systèmes, cette vérification est connue pour prendre très longtemps ou même pas être terminée. Si tel est le cas pour vous, vous devriez essayer de pointer votre navigateur directement vers votre GEDCOM pour voir s'il peut être téléchargé.";
$pgv_lang["gedcom_download_secure"]	= "#GEDCOM# ne peut pas être téléchargé.";

$pgv_lang["welcome_new_help"]		= "~#pgv_lang[welcome_new]#~<br /><br />Puisque vous voyez cette page, vous avez installé avec succès PhpGedView sur votre serveur et êtes prêt à commencer à le configurer selon vos besoins.<br /><br />Cette page d'aide vous guidera tout au long du processus de configuration. Lorsque vous entrez différents champs, cette fenêtre vous fournira des informations d'aide sur le champ dans lequel vous vous trouvez. Vous pouvez fermer cette fenêtre; pour l'ouvrir à nouveau cliquez sur l'un des points d'interrogation <b>#pgv_lang[qm]#</b> à côté de l'étiquette du champ.";
$pgv_lang["return_editconfig"]		= "Vous pouvez revenir à cette configuration à tout moment en pointant votre navigateur vers <i>editconfig.php</i> ou en cliquant sur le lien <b>Configuration</b> sur la page <b>Administration de PhpGedView</b>.";
$pgv_lang["return_editconfig_gedcom"]	= "Vous pouvez revenir à cette configuration à tout moment en cliquant sur le lien <b>Modifier</b> dans le tableau <b>#pgv_lang[current_gedcoms]#</b> sur le <b>#pgv_lang[gedcom_adm_head]#</b> ou en pointant votre navigateur vers <i>editconfig_gedcom.php</i>.";
$pgv_lang["save_config"] 		= "Enregistrer la configuration";
$pgv_lang["download_gedconf"]		= "Télécharger la configuration GEDCOM.";
$pgv_lang["not_writable"]		= "Nous avons détecté que votre fichier de configuration n'est pas accessible en écriture par PHP. Vous pouvez utiliser le bouton <b>#pgv_lang[download_file]#</b> pour enregistrer vos paramètres dans un fichier que vous pouvez télécharger manuellement.";
$pgv_lang["upload_to_index"]		= "Téléchargez le fichier dans votre dossier index: ";
$pgv_lang["import_sql"]			= "Des fichiers SQL ont été trouvés dans votre dossier d'index. Comme ils peuvent provenir de #pgv_lang[um_header]#, vous avez la possibilité d'importer les informations dans votre base de données. Souhaitez-vous essayer d'importer ces fichiers dans votre base de données maintenant? Toutes les informations existantes relatives aux utilisateurs (utilisateurs, actualités, favoris, mises en page de bloc et messages) dans votre base de données seront perdues.<br /><br />Si vous choisissez de continuer, PhpGedView tentera d'importer les données. Si cela échoue, il vous sera quand même demandé de créer le premier compte administrateur.";

//-- edit privacy messages
$pgv_lang["edit_privacy"]			= "Modifier la confidentialité";
$pgv_lang["edit_privacy_title"]			= "Modifier les paramètres de confidentialité de GEDCOM";
$pgv_lang["save_changed_settings"]		= "Sauvegarder les modifications";
$pgv_lang["add_new_pp_setting"]			= "Ajouter un nouveau paramètre de Confidentialité totale par ID de la personne";
$pgv_lang["add_new_up_setting"]			= "Ajouter un nouveau paramètre de Confidentialité selon ID utilisateur";
$pgv_lang["add_new_gf_setting"]			= "Ajouter un nouveau paramètre de Confidentialité globale des faits";
$pgv_lang["add_new_pf_setting"]			= "Ajouter un nouveau paramètre de Confidentialité des faits par ID de la personne";
$pgv_lang["file_read_error"]			= "E R R O R !!! Could not read privacy file!";
$pgv_lang["edit_exist_person_privacy_settings"]	= "Modifier les paramètres existants de Confidentialité totale par ID";
$pgv_lang["edit_exist_user_privacy_settings"]	= "Modifier les paramètres existants de Confidentialité selon ID utilisateur";
$pgv_lang["edit_exist_global_facts_settings"]	= "Modifier les paramètres existants de Confidentialité globale des faits";
$pgv_lang["edit_exist_person_facts_settings"]	= "Modifier les paramètres existants de Confidentialité des faits par ID de la personne";
$pgv_lang["general_privacy"]			= "Paramètres généraux de confidentialité";
$pgv_lang["general_privacy_help"]		= "~#pgv_lang[general_privacy]#~<br /><br />Vous pouvez avoir différents paramètres de confidentialité pour chaque GEDCOM sur votre site Web PhpGedView. Vérifiez sous le titre de la page si vous modifiez le bon GEDCOM.<br /><br />Vous pouvez remplacer ces paramètres généraux en utilisant les autres formulaires de confidentialité sur la page #pgv_lang[edit_privacy_title]#.<br /><br />#pgv_lang[more_help_advice]#";
$pgv_lang["person_privacy"]				= "Confidentialité totale par ID de la personne";
$pgv_lang["person_privacy_help"]		= "~#pgv_lang[person_privacy]#~<br /><br />Ces paramètres permettent aux administrateurs de remplacer les paramètres de confidentialité par défaut pour une personne, une famille, une source ou un objet multimédia en particulier.<br /><br />Supposons par exemple que vous ayez un enfant décédé en bas âge. Normalement, parce que l'enfant est mort, ses détails seraient montrés aux utilisateurs publics. Cependant, vous et tous les autres membres de votre famille êtes toujours privés. Vous ne souhaitez pas supprimer l'enregistrement de décès de l'enfant, mais vous souhaitez masquer les détails et les rendre privés. Si cet enfant avait l'ID I100, vous devez entrer les paramètres de confidentialité suivants:<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I100<br />&nbsp;&nbsp;&nbsp;#pgv_lang[accessible_by]#:&nbsp;&nbsp;#pgv_lang[PRIV_USER]#<br /><br />Cela fonctionne également dans l'autre sens. Si vous souhaitez rendre publics les détails d'une personne (ID I101) dont vous savez qu'elle est décédée mais dont vous n'avez pas de date de décès, vous pouvez ajouter ce qui suit:<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I101<br />&nbsp;&nbsp;&nbsp;#pgv_lang[accessible_by]#:&nbsp;&nbsp;#pgv_lang[PRIV_PUBLIC]#";
$pgv_lang["user_privacy"]				= "Confidentialité selon ID utilisateur";
$pgv_lang["user_privacy_help"]			= "~#pgv_lang[user_privacy]#~<br /><br />Ces paramètres donnent aux administrateurs la possibilité de remplacer les paramètres de confidentialité par défaut des personnes dans le GEDCOM en fonction du nom d'utilisateur. Supposons que vous ne vouliez pas que le nom d'utilisateur <b>John</b> puisse voir les détails de l'ID I100 dans le GEDCOM, vous pouvez le configurer comme ceci:<br />&nbsp;&nbsp;&nbsp;Username:&nbsp;&nbsp;John<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I100<br />&nbsp;&nbsp;&nbsp;#pgv_lang[show_question]#:&nbsp;&nbsp;#pgv_lang[hide]#<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;et les détails de la personne spécifiée ne seraient masqués que pour le nom d'utilisateur \"John\".<br /><br />Pour afficher les détails de I101 (généralement serait masqué car I101 est toujours actif) à Nom d'utilisateur \"John\" configurez:<br />&nbsp;&nbsp;&nbsp;Username:&nbsp;&nbsp;John<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I101<br />&nbsp;&nbsp;&nbsp;#pgv_lang[show_question]#:&nbsp;&nbsp;#pgv_lang[show]#";
$pgv_lang["global_facts"]				= "Confidentialité globale des faits";
$pgv_lang["global_facts_help"]			= "~#pgv_lang[global_facts]#~<br /><br />Ces paramètres définissent des faits à un niveau global qui doivent être masqués pour toutes les personnes dans le GEDCOM. Cela s'applique uniquement aux enregistrements de faits de niveau 1 tels que BIRT ou DEAT qui apparaîtront avec leurs propres en-têtes dans l'onglet #pgv_lang[personal_facts]# de la page <i>#pgv_lang[personal_details]#</i><br /><ul><li>L'élément <b>#pgv_lang[name_of_fact]#</b> détermine quel fait doit être caché.</li><li>L'élément <b>#pgv_lang[choice]#</b> spécifie le fait lui-même ou les détails associés.</li><li>L'élément <b>#pgv_lang[accessible_by]#</b> détermine à quel niveau d'accès le fait est affiché.</li></ul><br />Cette fonctionnalité est destinée à masquer certains faits, identifiés par des balises GEDCOM, pour toutes les personnes vivantes ou décédées. Par défaut, la balise SSN est masquée aux utilisateurs publics. Il s'agit d'empêcher les gens de voler les numéros de sécurité sociale et de commettre le vol d'identité de personnes décédées. Ceci est probablement principalement pertinent pour les États-Unis.<br /><br />Si vous souhaitez masquer tous les mariages des utilisateurs publics dans votre GEDCOM, vous pouvez définir:<br />&nbsp;&nbsp;&nbsp;#pgv_lang[name_of_fact]#: (MARR) - Mariage<br />&nbsp;&nbsp;&nbsp;#pgv_lang[choice]#: #pgv_lang[fact_details]#<br />&nbsp;&nbsp;&nbsp;#pgv_lang[accessible_by]#: #pgv_lang[PRIV_USER]#<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ces paramètres masqueraient les mariages et les détails associés aux visiteurs qui ne sont pas connectés.<br /><br />Contrairement à tous les autres paramètres, dans <b>#pgv_lang[edit_exist_global_facts_settings]#</b> vous pouvez cacher des faits même à l'administrateur utilisateurs. Les faits indésirables sont complètement supprimés. ";
$pgv_lang["person_facts"]				= "Confidentialité des faits par ID de la personne";
$pgv_lang["person_facts_help"]			= "~#pgv_lang[person_facts]#~<br /><br />Ces paramètres définissent les faits masqués pour une personne, une famille ou une source spécifique et le niveau auquel ils sont masqués. Cela ne s'applique qu'aux enregistrements de faits de niveau 1 tels que BIRT ou DEAT qui apparaîtront avec leurs propres en-têtes sur la page des détails pertinents de la personne, de la famille ou de la source.<br /><br />Le premier élément est l'ID du personne, famille ou source. Le deuxième élément est le fait. L'élément <b>#pgv_lang[choice]#</b> spécifie le fait lui-même ou les détails associés. L'élément <b>#pgv_lang[accessible_by]#</b> détermine à quel niveau d'accès le fait est affiché. Tous les faits indiqués dans la liste ne s'appliquent pas à tous les types d'identifiants. Par exemple, les faits Naissance et Décès ne sont pas pertinents pour les enregistrements source.<br /><br />Cette liste est similaire à la liste <b>#pgv_lang[global_facts]#</b> sauf que vous spécifiez également l'ID GEDCOM de la personne pour laquelle vous souhaitez masquer les faits. Vous pouvez, par exemple, masquer le fait de mariage d'une personne spécifique.";
$pgv_lang["accessible_by"]			= "Montrer à?";
$pgv_lang["hide"]				= "Cacher";
$pgv_lang["show_question"]			= "Montrer?";
$pgv_lang["user_name"]				= "Nom d'utilisateur";
$pgv_lang["name_of_fact"]			= "Nom du fait";
$pgv_lang["choice"]				= "Choix";
$pgv_lang["fact_show"]				= "Montrer le fait";
$pgv_lang["fact_details"]			= "Afficher les détails des faits";
$pgv_lang["privacy_header"]			= "Modifier les paramètres de confidentialité";
$pgv_lang["unable_to_find_privacy_indi"]	= "Impossible de trouver la personne avec l'identifiant";
$pgv_lang["save_and_import"]			= "Après avoir enregistré cette configuration GEDCOM, vous devrez importer le GEDCOM en cliquant sur le bouton <b>Importer GEDCOM</b> ou en allant vers <b>Administration --> Gérer les GEDCOM --> Importer</b>";
$pgv_lang["help_info"]				= "Vous pouvez obtenir de l'aide pour chaque élément en cliquant sur le bouton rouge «&» à côté de l'étiquette de chaque cellule.";
$pgv_lang["SHOW_LIVING_NAMES"]			= "Afficher les noms des vivants";
$pgv_lang["SHOW_LIVING_NAMES_help"]		= "~#pgv_lang[SHOW_LIVING_NAMES]#~<br /><br />Les noms des personnes vivantes devraient-ils être montrés au public?<br /><br />Normalement, ce paramètre serait «#pgv_lang[PRIV_USER]#». Cela sert à protéger la vie privée des personnes vivantes dans votre base de données, car vous pouvez déterminer à qui vous donnez un accès général à vos données généalogiques.<br /><br />Le choix «#pgv_lang[PRIV_NONE]#» empêche d'afficher les noms des personnes vivantes aux utilisateurs qui n'ont pas de droits d'administrateur.";
$pgv_lang["SHOW_RESEARCH_ASSISTANT"]			= "Afficher l'assistant de recherche";
$pgv_lang["SHOW_RESEARCH_ASSISTANT_help"]		= "~#pgv_lang[SHOW_RESEARCH_ASSISTANT]#~<br /><br />Quel type d'utilisateur peut afficher le module assistant de recherche Si installé?";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]		= "Utiliser la confidentialité des relations";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]	= "~#pgv_lang[USE_RELATIONSHIP_PRIVACY]#~<br /><br /><b>#pgv_lang[no]#</b> signifie que les utilisateurs authentifiés peuvent voir les détails de toutes les personnes vivantes. <b>#pgv_lang[yes]#</b> signifie que les utilisateurs ne peuvent voir que les informations privées des personnes vivantes auxquelles ils sont liés.<br /><br />Cette option définit la valeur par défaut pour tous les utilisateurs qui ont accès à cette base de données généalogique. L'administrateur peut remplacer cette option pour des utilisateurs individuels en modifiant les détails du compte de l'utilisateur.";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]		= "Longueur maximale du chemin de relation";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]	= "~#pgv_lang[MAX_RELATION_PATH_LENGTH]#~<br /><br />Si l'option <i>#pgv_lang[USE_RELATIONSHIP_PRIVACY]#</i> est activée, les utilisateurs connectés ne pourront voir ou modifier les personnes que dans ce nombre d'étapes de relation.<br /><br />Cette option est activée la valeur par défaut pour tous les utilisateurs qui ont accès à cette base de données généalogique. L'administrateur peut remplacer cette option pour des utilisateurs individuels en modifiant les détails du compte de l'utilisateur.";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]		= "Vérifier les relations de mariage";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]	= "~#pgv_lang[CHECK_MARRIAGE_RELATIONS]#~<br /><br />Vérifiez les relations liées par le mariage.";
$pgv_lang["SHOW_DEAD_PEOPLE"]			= "Montrer les morts";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]		= "~#pgv_lang[SHOW_DEAD_PEOPLE]#~<br /><br />Définissez le niveau d'accès à la confidentialité pour toutes les personnes décédées.";
$pgv_lang["select_privacyfile_button"]		= "Sélectionnez le fichier de confidentialité";
$pgv_lang["PRIVACY_BY_YEAR"]		= "Limiter la confidentialité selon l'âge de l'événement";
$pgv_lang["PRIVACY_BY_YEAR_help"]	= "~#pgv_lang[PRIVACY_BY_YEAR]#~<br /><br />Le paramètre <b>#pgv_lang[PRIVACY_BY_YEAR]#</b> masquera les détails des personnes en fonction de leur âge lors d'événements spécifiques, qu'elles soient mortes ou vivantes.<br /><br />Utilisez ce paramètre avec le paramètre <b>#pgv_lang[MAX_ALIVE_AGE]#</b>. Par exemple, si vous définissez le paramètre Âge sur 100 et définissez cette option sur <b>#pgv_lang[yes]#</b>, toutes les personnes, vivantes ou décédées, nées il y a moins de 100 ans seront définies comme privées. Les personnes mariées il y a moins de 85 ans et les personnes décédées il y a moins de 75 ans seraient également considérées comme privées. Veuillez noter que l'utilisation de cette option ralentira quelque peu vos performances.";

//-- language edit utility
$pgv_lang["lang_edit_help"]			= "~#pgv_lang[translator_tools]#~<br /><br />Cette page est destinée à être utilisée par les traducteurs. Vous pouvez traduire, comparer et exporter des fichiers de langue. Il existe également une option pour aider les traducteurs à déterminer l'origine du texte généré par PhpGedView.<br /><br />Vous pouvez utiliser les options et utilitaires suivants:";
$pgv_lang["edit_langdiff"]		= "Modifier et configurer les fichiers de langue";
$pgv_lang["bom_check"]		= "Contrôle de la marque d'ordre d'octet (BOM)";
$pgv_lang["bom_check_help"]		= "~#pgv_lang[bom_check]#~<br /><br />#pgv_lang[bom_check_desc]#";
$pgv_lang["bom_check_desc"]		= "Cette vérification analysera tous les fichiers de langue pour la nomenclature (Byte Order Mark). Si trouvé, il supprimera la nomenclature du fichier concerné. Ces codes spéciaux peuvent provoquer des dysfonctionnements dans certaines parties de PhpGedView.";
$pgv_lang["lang_debug"]			= "Aide au débogage du texte";
$pgv_lang["lang_debug_help"]	= "~#pgv_lang[lang_debug]#~<br /><br />#pgv_lang[lang_debug_desc]#";
$pgv_lang["lang_debug_desc"]	= "Lorsque vous activez cette option, les noms des variables de langue utilisées dans le texte d'aide s'impriment dans la fenêtre contextuelle du texte d'aide. Cela aidera les traducteurs à déterminer le nom de la variable lorsque le texte doit être ajusté.<br /><br />Ce paramètre ne sera valide que pendant votre session PhpGedView actuelle.";
$pgv_lang["lang_debug_use"]		= "Utiliser le débogage du texte d'aide";
$pgv_lang["bom_not_found"]		= "Aucun BOM n'a été trouvée.";
$pgv_lang["bom_found"]			= "BOM a été trouvé dans ";
$pgv_lang["edit_lang_utility"]		= "Utilitaire d'édition de fichiers de langue";
$pgv_lang["edit_lang_utility_help"]	= "~#pgv_lang[edit_lang_utility]#~<br /><br />#pgv_lang[edit_lang_utility_desc]#";
$pgv_lang["edit_lang_utility_desc"]	= "Vous pouvez utiliser cet utilitaire pour éditer le contenu d'un fichier de langue en utilisant le contenu du fichier anglais.<br /><br />Vous verrez le contenu du fichier original en anglais et le contenu du même type de fichier (il y en a neuf) dans la langue de votre choix. Vous cliquez sur le texte du message ci-dessous la version anglaise. Cela ouvre une nouvelle fenêtre dans laquelle vous pouvez modifier le texte. Vous pouvez enregistrer les modifications ou les abandonner.";
$pgv_lang["edit_lang_utility_warning"]	= "ATTENTION!<br /><br />Si vous utilisez le bouton <b>#pgv_lang[close_window_without_refresh]#</b>, vous risquez de ne pas voir vos modifications à l'écran tant que vous n'aurez pas rechargé la page manuellement. Il est possible que votre fichier de langue soit détruit si vous ajoutez un message qui n'est pas encore apparu dans le fichier de langue ou si vous modifiez simplement un message que vous avez modifié directement auparavant.<br /><br />Si vous ne savez pas vraiment ce que vous faites, veuillez ne pas utiliser le bouton <b>#pgv_lang[close_window_without_refresh]#</b>.";
$pgv_lang["language_to_edit"]		= "Langue à modifier";
$pgv_lang["language_to_edit_help"]		= "~#pgv_lang[language_to_edit]#~<br /><br />Dans cette zone de liste, vous sélectionnez la langue dont vous souhaitez modifier les messages.";
$pgv_lang["file_to_edit"]		= "Type de fichier de langue à modifier";
$pgv_lang["file_to_edit_help"]			= "~#pgv_lang[file_to_edit]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["lang_file_descriptions"]		= "PhpGedView a implémenté la prise en charge de nombreuses langues différentes. Ceci a été réalisé en gardant tout le texte visible par les utilisateurs dans des fichiers complètement séparés du programme principal. Il existe un ensemble de huit fichiers pour chaque langue prise en charge, et les différents textes ont été séparés dans l'un de ces fichiers en fonction de leur fonction. <b>Tous les fichiers de langue ne doivent pas nécessairement être présents.</b> Lorsqu'un texte donné n'est pas encore disponible sous forme de traduction, PhpGedView utilisera toujours la version anglaise.<br /><br />Les fichiers dans chaque ensemble de langues sont:<br /><ul><li><b><i>admin.xx.php</i></b>&nbsp;&nbsp;Ce fichier contient des termes et expressions courantes à utiliser lors de l'administration de PhpGedView et des bases de données généalogiques.</li><br /><li><b><i>configure_help.xx.php</i></b>&nbsp;&nbsp;Ce fichier contient des textes d'aide à utiliser lors de la configuration de PhpGedView. Ces textes ne sont pas destinés à être consulté par des utilisateurs ordinaires.</li><br /><li><b><i>countries.xx.php</i></b>&nbsp;&nbsp;Voici une liste de noms de pays, tirée du site Web de la Division de statistique du Département des affaires économiques et sociales des Nations Unies. Ceci est le <a href=\"http://unstats.un.org/unsd/methods/m49/m49alpha.htm\" target=\"_blank\"><b>lien</b></a> pertinent vers la liste anglaise. La liste est disponible en anglais ou en français.</li><br /><li><b><i>editor.xx.php</i></b>&nbsp;&nbsp;Ce fichier contient des termes et expressions courantes à utiliser lors de l'édition des entrées dans les bases de données généalogiques.</li><br /><li><b><i>facts.xx.php</i></b>&nbsp;&nbsp;Ce fichier contient les équivalents textuels des codes de faits GEDCOM trouvés dans la norme GEDCOM 5.5.1. Il contient également des codes de faits supplémentaires non trouvés dans la norme mais utilisés par divers programmes de généalogie.<br /><br />Une copie en anglais de la <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\"><b>norme GEDCOM 5.5.1</b></a> peut être téléchargée au format PDF (Portable Document Format).</li><br /><li><b><i>faqlist.xx.php</i></b>&nbsp;&nbsp;Ce fichier est un ensemble de <b>f</b>requently <b>a</b>sked <b>q</b>uestions (Questions fréquemment posées) qui ont été collectées par l'équipe de développement de PhpGedView. Chaque FAQ a deux entrées dans ce fichier. Une entrée est l'en-tête FAQ (généralement la question), et l'autre est le corps de la FAQ (généralement la réponse). Les remplacements des fichiers <b><i>faqlist.xx.php</i></b>, qui sont fréquemment mis à jour, peuvent être téléchargés à partir du site d'accueil de PhpGedView.<br /><br />L'administrateur peut utiliser les FAQ de ce fichier pour construire une liste de FAQ spécifique à son site.</li><br /><li><b><i>help_text.xx.php</i></b>&nbsp;&nbsp;Ce fichier contient des textes d'aide pour les utilisateurs ordinaires. Certaines rubriques d'aide de ce fichier répondent aux besoins des administrateurs et sont masquées aux utilisateurs qui ne disposent pas de droits d'administrateur.</li><br /><li><b><i>lang.xx.php</i></b>&nbsp;&nbsp;De nombreux termes et expressions courantes se trouvent dans ce fichier.</li></ul><br />PhpGedView prend également en charge un neuvième fichier, facultatif, de langue, <b><i>extra.xx.php</i></b>. Ce fichier est toujours chargé après tous les autres et fournit un moyen par lequel un administrateur de site peut remplacer ou modifier tout texte standard dans la langue sélectionnée. Il peut également être utilisé pour fournir un titre aux bases de données généalogiques qui varie selon la langue actuellement active.<br /><br />Le contenu de ce fichier supplémentaire est entièrement à la discrétion de l'administrateur du site; ce fichier ne sera <b>jamais</b> distribué avec aucune version de PhpGedView. L'administrateur ne doit jamais apporter de modifications aux fichiers de langue standard; toutes les modifications locales doivent être concentrées dans ce fichier facultatif.";
$pgv_lang["check"]			= "Vérifier";
$pgv_lang["lang_save"]			= "Sauvegarder";
$pgv_lang["contents"]			= "Contenu";
$pgv_lang["listing"]			= "Listage";
$pgv_lang["no_content"]			= "Pas de contenu";
$pgv_lang["editlang"]			= "Modifier";
$pgv_lang["editlang_help"]		= "~#pgv_lang[editlang]#~<br /><br />Modifier le message du fichier de langue.";
$pgv_lang["savelang"]			= "Enregister";
$pgv_lang["savelang_help"]		= "~#pgv_lang[savelang]#~<br /><br />Enregistrez le message modifié dans le fichier de langue.";
$pgv_lang["original_message"]		= "Message original";
$pgv_lang["message_to_edit"]		= "Message à modifier";
$pgv_lang["changed_message"]		= "Contenu modifié";
$pgv_lang["message_empty_warning"]	= "-&gt; Avertissement!!! Ce message est vide dans #LANGUAGE_FILE# &lt;-";
$pgv_lang["language_to_export"]		= "Langue à exporter";
$pgv_lang["language_to_export_help"]		= "~#pgv_lang[language_to_export]#~<br /><br />Dans cette liste, vous pouvez sélectionner la langue et les fichiers de langue dont vous souhaitez exporter le texte.<br /><br />Le résultat est un fichier HTML que vous pouvez imprimer depuis votre navigateur.";
$pgv_lang["export_lang_utility"]	= "Utilitaire d'exportation de fichiers de langue";
$pgv_lang["export"]			= "Exporter";
$pgv_lang["export_lang_utility_help"]	= "~#pgv_lang[export_lang_utility]#~<br /><br />#pgv_lang[export_lang_utility_desc]#";
$pgv_lang["export_lang_utility_desc"]	= "Vous pouvez créer de la documentation pour les administrateurs.<br /><br />Cet utilitaire produira une version HTML du fichier de langue sélectionné. Vous pouvez utiliser votre navigateur pour consulter ce fichier, qui est formaté pour l'impression.";
$pgv_lang["export_ok"]			= "Le texte de la langue a été exporté";
$pgv_lang["compare_lang_utility"]	= "Language File Comparison Utility";
$pgv_lang["compare_lang_utility_help"]	= "~#pgv_lang[compare_lang_utility]#~<br /><br />#pgv_lang[compare_lang_utility_desc]#";
$pgv_lang["compare_lang_utility_desc"]	= "Cet utilitaire comparera deux ensembles de fichiers de langue pour produire une liste des ajouts et des soustractions entre eux.<br /><br />Les fichiers en anglais doivent être utilisés comme référence à partir de laquelle tous les autres sont produits.";
$pgv_lang["new_language"]		= "Langue primaire";
$pgv_lang["new_language_help"]			= "~#pgv_lang[new_language]#~<br /><br />Dans cette liste, vous pouvez sélectionner la langue dont vous souhaitez comparer les messages avec ceux d’une autre langue.<br /><br />Tous les changements et ajouts aux fichiers de langue sont d'abord apportés aux fichiers de langue <b>anglais</b>, vous devez donc normalement sélectionner l'anglais comme l'une des langues à comparer.";
$pgv_lang["old_language"]		= "Langue secondaire";
$pgv_lang["old_language_help"]			= "~#pgv_lang[old_language]#~<br /><br />Dans cette zone de liste, vous pouvez sélectionner la langue que vous souhaitez comparer avec la langue sélectionnée dans la zone <b>#pgv_lang[new_language]#</b>.<br /><br />Après avoir fait votre choix, cliquez sur le bouton <b>Comparer</b> pour obtenir une liste de tous les ajouts et soustractions dans tous les fichiers des deux langues.<br /><br />Pour vous rafraîchir la mémoire:<br /><b>Addition</b> signifie: Il est <u>dans</u> le fichier source, mais <u>pas</u> dans le fichier secondaire.<br /><br /><b>Soustraction</b> signifie: C'est <u>pas</u> dans le fichier source, mais <u>est</u> dans le fichier secondaire. Cela peut se produire lorsqu'un message donné n'est plus utilisé et a donc été supprimé des fichiers anglais. Vous pouvez supprimer en toute sécurité le message correspondant des fichiers de langue secondaire.";
$pgv_lang["compare"]			= "Comparer";
$pgv_lang["comparing"]			= "Fichiers de langue comparés";
$pgv_lang["additions"]			= "Ajouts";
$pgv_lang["no_additions"]		= "Aucun ajout";
$pgv_lang["subtractions"]		= "Subtractions";
$pgv_lang["no_subtractions"]		= "Pas de soustractions";
$pgv_lang["config_lang_utility"]	= "Configuration des langues prises en charge";
$pgv_lang["config_lang_utility_help"]	= "~#pgv_lang[config_lang_utility]#~<br /><br />Cette page est utilisée pour contrôler les choix de langue disponibles àvos utilisateurs. Par exemple, vous pouvez configurer les choses de sorte que seuls l'allemand et le français soient disponibles. Cela peut être utile si, par exemple, vous ne pouvez pas communiquer avec vos utilisateurs en hongrois.<br /><br />Vous utilisez également cette page pour modifier certains aspects de PhpGedView qui dépendent de la langue sélectionnée. Par exemple, c'est ici que vous indiquez à PhpGedView comment formater les champs de date et d'heure.<br /><br />Les langues qui sont actives et grisées ne peuvent pas être désactivées car elles sont en cours d'utilisation. Regardez le tableau du bas pour voir où la langue est utilisée. Lorsqu'une langue n'est plus utilisée par le GEDCOM ou l'utilisateur, vous pourrez la désactiver.<br /><br />Toutes vos modifications seront enregistrées dans un nouveau fichier appelé <i>language_settings.php</i> créé dans le dossier <b>#INDEX_DIRECTORY#</b>. Toutes vos modifications ultérieures seront apportées à ce nouveau fichier et PhpGedView utilisera uniquement <u>ce</u> fichier. Vous pouvez revenir aux paramètres de langue par défaut d'origine en supprimant ce fichier.<br /><br />Si vous devez signaler des problèmes avec vos paramètres de langue, veuillez indiquer à l'équipe d'assistance PhpGedView si ce nouveau fichier est présent ou non.";
$pgv_lang["active"]			= "Active";
$pgv_lang["active_help"]		= "~#pgv_lang[active]#~<br /><br />Autorisez les utilisateurs à sélectionner cette langue si l'option <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b> est activée.";
$pgv_lang["edit_settings"]		= "Modifier les paramètres";
$pgv_lang["lang_edit"]			= "Modifier";
$pgv_lang["lang_language"]		= "Langue";
$pgv_lang["export_filename"]		= "Nom du fichier de sortie:";
$pgv_lang["lang_back"]			= "Revenir au menu principal pour éditer et configurer les fichiers de langue";
$pgv_lang["lang_back_admin"]		= "Revenir au menu d'administration";
$pgv_lang["lang_back_manage_gedcoms"]	= "Retour au menu de gestion GEDCOM";
$pgv_lang["lang_name_arabic"]           = "Arabe";
$pgv_lang["lang_name_catalan"]			= "Catalan (valencien)";
$pgv_lang["lang_name_chinese"]			= "Chinois (traditionnel)";
$pgv_lang["lang_name_chinese-cn"]		= "Chinois (simplifié)";
$pgv_lang["lang_name_croatian"]			= "Croate";
$pgv_lang["lang_name_czech"]            = "Tchèque";
$pgv_lang["lang_name_danish"]           = "Danois";
$pgv_lang["lang_name_dutch"]            = "Hollandais";
$pgv_lang["lang_name_english"]          = "Anglais";
$pgv_lang["lang_name_estonian"]         = "Estonien";
$pgv_lang["lang_name_finnish"]          = "Finnois";
$pgv_lang["lang_name_french"]           = "Français";
$pgv_lang["lang_name_german"]           = "Allemand";
$pgv_lang["lang_name_greek"]            = "Grec";
$pgv_lang["lang_name_hebrew"]           = "Hébreu";
$pgv_lang["lang_name_hungarian"]        = "Hongrois";
$pgv_lang["lang_name_indonesian"]		= "Indonésien";
$pgv_lang["lang_name_italian"]          = "Italien";
$pgv_lang["lang_name_lithuanian"]       = "Lituanien";
$pgv_lang["lang_name_norwegian"]        = "Norvégien";
$pgv_lang["lang_name_polish"]           = "Polonais";
$pgv_lang["lang_name_portuguese"]       = "Portugais";
$pgv_lang["lang_name_romanian"]			= "Roumain";
$pgv_lang["lang_name_russian"]          = "Russe";
$pgv_lang["lang_name_serbian-la"]       = "Serbe (alphabet latin)";
$pgv_lang["lang_name_slovak"]           = "Slovaque";
$pgv_lang["lang_name_slovenian"]		= "Slovène";
$pgv_lang["lang_name_spanish"]          = "Espagnol";
$pgv_lang["lang_name_spanish-ar"]       = "Espagnol (sud américain)";
$pgv_lang["lang_name_swedish"]          = "Suédois";
$pgv_lang["lang_name_turkish"]          = "Turc";
$pgv_lang["lang_name_vietnamese"]       = "Vietnamien";
$pgv_lang["lang_name_unknown"]			= "Aucune de ces langues";		// used ONLY in "Find Special Characters"
$pgv_lang["lang_new_language"]          = "Nouvelle langue";
$pgv_lang["original_lang_name"]		= "Nom d'origine de la langue en #D_LANGNAME#";
$pgv_lang["original_lang_name_help"]	= "~Nom original de la langue~<br /><br />Comment cette langue est-elle nommée dans cette langue?<br /><br />L’anglais s’appelle <b>English</b>; L’allemand s’appelle <b>Deutsch</b>; Le néerlandais s'appelle <b>Nederlands</b>; Le tchèque s'appelle <b>Ceština</b>, etc.";
$pgv_lang["lang_shortcut"]		= "Abréviation des fichiers de langue";
$pgv_lang["lang_shortcut_help"]		= "~#pgv_lang[lang_shortcut]#~<br /><br />Ce code définit une abréviation pour le nom de la langue. Cette abréviation fait partie du nom de chacun des fichiers de langue utilisés par PhpGedView. Par exemple, l'abréviation utilisée pour le français est <b>fr</b>, et par conséquent les noms de fichiers pour le français sont <i>admin.<b>fr</b>.php</i>, <i>configure_help.<b>fr</b>.php</i>, <i>countries.<b>fr</b>.php</i>, <i>editor.<b>fr</b>.php</i>, <i>facts.<b>fr</b>.php</i>, <i>help_text.<b>fr</b>.php</i>, et <i>lang.<b>fr</b>.php</i>";
$pgv_lang["lang_langcode"]		= "Codes de détection de langue";
$pgv_lang["lang_langcode_help"]		= "~#pgv_lang[lang_langcode]#~<br /><br />Ces codes permettent à PhpGedView de détecter le paramètre de langue préféré du navigateur utilisé. PhpGedView détermine la langue réellement demandée par le navigateur en faisant correspondre le code de langue du navigateur à cette liste. Les entrées de liste individuelles doivent être séparées par un point-virgule.";
$pgv_lang["lang_filenames"]		= "Fichiers de langue";
$pgv_lang["lang_filenames_help"]		= "~#pgv_lang[lang_filenames]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["flagsfile"]			= "Fichier de drapeau";
$pgv_lang["flagsfile_help"]		= "~#pgv_lang[flagsfile]#~<br /><br />Nom du fichier image du drapeau national pour la langue sélectionnée.<br /><br />Des images pour de nombreux pays sont disponibles sur le site <a href=\"http://w3f.com/gifs/index.html\"><b>The WWWeb Factory</b></a>.<br /><br />Lorsque vous trouvez une image de drapeau que vous aimez, faites un clic droit dessus et enregistrez l'image dans un dossier temporaire. Ensuite, ouvrez l'image enregistrée avec un éditeur d'image approprié (IrfanView est recommandé pour les systèmes Windows), réduisez sa taille de 50x32 pixels, qui est la taille normale utilisée dans PhpGedView, puis enregistrez-la sous forme de fichier GIF dans le <i><b>images/flags</b></i>. Vous pouvez utiliser le nom de votre choix.";
$pgv_lang["text_direction"]		= "Direction du texte";
$pgv_lang["text_direction_help"]	= "~#pgv_lang[text_direction]#~<br /><br />Identifie la direction utilisée pour écrire du texte dans la langue choisie. La plupart des langues sont écrites de gauche à droite. L'arabe et l'hébreu sont des exemples de langues écrites dans la direction opposée (de droite à gauche).";
$pgv_lang["date_format"]			= "Format de date";
$pgv_lang["date_format_help"] = "~#pgv_lang[date_format]#~<br /><br />Ce champ définit le format de date à utiliser par PhpGedView lors de l'affichage des dates de la base de données. Vous pouvez utiliser le format <b>Standard</b> ou <b>Avancé</b>.<ul><li><b>Standard</b><br />Les codes suivants sont utilisés pour représenter différents éléments de la date. Notez que <b>D</b> et <b>M</b> ont des significations différentes dans le format <b>Avancé</b>.<p style=\"padding-left: 25px\"><b>D</b>&nbsp;&nbsp;jour du mois, sans zéros non significatifs; soit 1 à 31<br /><b>M</b>&nbsp;&nbsp;nom du mois; c'est-à-dire janvier, février, etc.<br /><b>Y</b>&nbsp;&nbsp;année complète, par exemple, 1999 ou 44A.C.<br /><b>R</b>&nbsp;&nbsp;Conversion de calendrier. Veuillez consulter la rubrique <b>Conversion de calendrier</b> ci-dessous pour obtenir une description de ce code.</p>Ces codes peuvent être combinés dans n'importe quel ordre, avec des espaces et des signes de ponctuation. Par exemple, supposons que votre GEDCOM contienne la date 20&nbsp;AUG&nbsp;1965.<p style=\"padding-left: 25px\">Un utilisateur <b>anglais</b> peut définir le format sur <b>D&nbsp;M&nbsp;Y</b> pour obtenir <b>20&nbsp;August&nbsp;1965</b>.<br />Un utilisateur <b>américain</b> peut définir le format sur <b>M&nbsp;D,&nbsp;Y</b> pour obtenir <b>August&nbsp;20,&nbsp;1965</b><br />Un utilisateur <b>allemand</b> peut définir le format sur <b>D.&nbsp;M&nbsp;Y</b> pour obtenir <b>20.&nbsp;August&nbsp;1965</b><br />Un utilisateur <b>hongrois</b> peut définir le format sur <b>Y.&nbsp;M&nbsp;D.</b> pour obtenir <b>1965.&nbsp;augusztus&nbsp;20.</b></p><br /></li><li><b>Avancé</b><br />Des options de formatage plus complexes sont disponibles. Si votre format de date inclut une lettre autre que <b>D</b>, <b>M</b>, <b>Y</b>, ou <b>R</b>, il sera supposé pour utiliser le format <b>Avancé</b>.<br /><br />Les codes suivants sont utilisés pour représenter différents éléments de la date. Notez que <b>D</b> et <b>M</b> ont des significations différentes dans le format <b>Standard</b>.<p style=\"padding-left: 25px\"><b>d</b>&nbsp;&nbsp;jour du mois, avec des zéros non significatifs; soit 01 à 31<br /><b>j</b>&nbsp;&nbsp;jour du mois, sans zéros non significatifs; soit 1 à 31<br /><b>S</b>&nbsp;&nbsp;suffixe ordinal pour le numéro du jour; par exemple en anglais, les lettres <b>th</b> dans <b>4th&nbsp;July</b> ou en français les lettres <b>ier</b> dans <b>1ier&nbsp;Janvier</b>.<br /><b>l</b> (minuscule «L»)&nbsp;&nbsp;jour de la semaine; soit lundi, mardi, etc.<br /><b>D</b>&nbsp;&nbsp;jour abrégé de la semaine; soit L, Ma, Me, J, V, S, D<br /><b>N</b>&nbsp;&nbsp;numéro de jour ISO; soit 0 à 6<br /><b>w</b>&nbsp;&nbsp;numéro de jour; soit 1 à 7<br /><b>z</b>&nbsp;&nbsp;jour de l'année; soit 1 à 365 ou 366<br /><b>F</b>&nbsp;&nbsp;nom du mois; soit janvier, février, etc.<br /><b>M</b>&nbsp;&nbsp;mois abrégé, soit jan, fév, etc.<br /><b>m</b>&nbsp;&nbsp;numéro du mois, avec des zéros non significatifs; soit 01 à 12<br /><b>n</b>&nbsp;&nbsp;numéro du mois, sans zéros non significatifs; soit 1 à 12<br /><b>Y</b>&nbsp;&nbsp;année complète, par exemple, 1999 ou 44A.C.<br /><b>y</b>&nbsp;&nbsp;année abrégée. Certains calendriers permettent d'abréger les années. Pour le calendrier juif, c'est l'année sans les milliers. Pour le calendrier grégorien, c'est la même chose que l'année complète.<br /><b>R</b>&nbsp;&nbsp;Conversion de calendrier. Veuillez consulter la rubrique <b>Conversion de calendrier</b> ci-dessous pour obtenir une description de ce code.<br /><b>@&nbsp;A&nbsp;O&nbsp;E</b>&nbsp;&nbsp;format GEDCOM interne</p><p style=\"padding-left: 50px\"><b>@</b>&nbsp;&nbsp;code de calendrier, par exemple @#DGREGORIAN@, @#DHEBREW@, etc.<br /><b>A</b>&nbsp;&nbsp;jour, soit du 01 au 31<br /><b>O</b>&nbsp;&nbsp;mois, toujours en anglais, par ex. JAN, FEB, MAR, etc.<br /><b>E</b>&nbsp;&nbsp;année, par ex. 1776, 1867, 2007, etc.<br /><br />Pour voir les dates non converties, utilisez <b>A&nbsp;O&nbsp;E</b> ou <b>@&nbsp;A&nbsp;O&nbsp;E</b></p><b>Quelques exemples</b>, en utilisant la date 08&nbsp;SEP&nbsp;1965:<p style=\"padding-left: 25px\"><b>d&nbsp;M&nbsp;Y</b> = 08&nbsp;Sep&nbsp;1965<br /><b>D&nbsp;j&nbsp;F&nbsp;Y</b> = Me&nbsp;8&nbsp;Septembre&nbsp;1965<br /><b>j&nbsp;M&nbsp;y</b> = 8&nbsp;Sep&nbsp;65<br /><b>l&nbsp;-&nbsp;d&nbsp;-&nbsp;F&nbsp;-&nbsp;Y</b> = Mercredi&nbsp;-&nbsp;08&nbsp;-&nbsp;Septembre&nbsp;-&nbsp;1965<br /><b>y/m/d</b> = 1965/09/08</p><br /></li></ul>#pgv_lang[date_format_help2]#";
$pgv_lang["date_format_help2"] = "<ul><li><b>Conversion de calendrier</b><br />Le code <b>R</b> est quelque peu inhabituel dans son comportement. Lorsque ce code apparaît au format de date, la date normale sera affichée une seconde fois, mais dans un système de calendrier différent. Les éléments de cette autre date calendaire obéiront aux mêmes règles que ceux de la partie principale de la spécification de format, sauf que la sortie du code de formatage <b>R</b> est placée entre parenthèses pour la distinguer de la date régulière. Les exemples donnés sous le calendrier <b>Révolutionnaire Français</b> le rendront un peu plus clair.<br /><br />Le calendrier alternatif à utiliser pour le code <b>R</b> est déterminé en fonction de la langue actuelle de la page. Lorsque la langue de la page est l'hébreu, le calendrier <b>juif</b> sera utilisé. Lorsque la langue de la page est l'arabe, le calendrier <b>Hijri</b> sera utilisé. Pour toutes les autres langues de page, le calendrier <b>Révolutionnaire français</b> est utilisé.<br /><br />L'action de ce code est similaire au choix du format de calendrier que vous pouvez faire sur la page de configuration de GEDCOM. La différence entre les deux méthodes est que le code <b>R</b>, défini au niveau de la configuration de la langue, ne fonctionne que sur les langues sélectionnées mais sur tous les GEDCOM du site. L'option de calendrier définie au niveau de la configuration GEDCOM fonctionne sur toutes les langues, mais uniquement sur les GEDCOM pour lesquels cette option a été définie.<br /><ul><li>Calendrier <b>Révolutionnaire français</b> &nbsp;&nbsp;&nbsp;Ce calendrier est également appelé calendrier <b>républicain français</b>.<br /><br />Sauf pour une très brève période en mai 1871, ce système de calendrier n'était utilisé qu'en France et seulement entre le 22&nbsp;SEP&nbsp;1792 et le 31&nbsp;DEC&nbsp;1805. En conséquence, le format du calendrier de la Révolution française ne sera applicable que lorsque la date se situe dans cette plage.<br /><br />Deux exemples de formats de date, en supposant que la langue de la page est l'anglais, illustreront l'action du code <b>R</b>:<br /><b>Y.m.d&nbsp;R</b> pourrait produire <b>1805.04.26&nbsp;(XIII.08.06)</b> ou <b>1806.01.01</b>;&nbsp; <b>j&nbsp;F&nbsp;Y&nbsp;R</b> pourrait produire <b>13&nbsp;October&nbsp;1797&nbsp;(22&nbsp;Vendémiaire&nbsp;VI)</b> ou <b>1&nbsp;January&nbsp;1806</b>.</li></ul><br /></li><li><b>Alternatives linguistiques</b><br />Les textes abrégés des codes avancés <b>D</b> et <b>M</b> sont définis dans le fichier <i>languages/lang.xx.php</i>, en utilisant des instructions comme<br /><code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"Su\";<br />\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"April\";</code><br /><br />Ceux-ci peuvent être modifiés en utilisant un fichier <i>languages/extra.xx.php</i> comme décrit dans le texte Wiki et ReadMe pour les ajustements linguistiques, par exemple:<br /><code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"Sun\";<br />\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"Apr\";</code></li><br /><li><b>Localisation</b><br />Des règles de mise en forme spéciales existent pour un certain nombre de langues, en particulier la déclinaison des fins de mois en fonction de la formulation de la date. Ces règles spéciales sont implémentées dans les différents fichiers <i>includes/extras/functions.xx.php</i>.</li></ul>";
$pgv_lang["time_format"]                = "Format de l'heure";
$pgv_lang["time_format_help"]		= "~#pgv_lang[time_format]#~<br /><br />Ce champ définit le format de l'heure à utiliser par PhpGedView.<br /><br />Les symboles que vous pouvez utiliser sont:<br /><b>a</b> - minuscules Ante meridiem et Post meridiem; c'est-à-dire, <b>am</b> ou <b>pm</b><br /><b>A</b> - majuscule Ante meridiem et Post meridiem; c'est-à-dire, <b>AM</b> ou <b>PM</b><br /><b>B</b> - Heure Internet Swatch; c'est-à-dire de <b>000</b> à <b>999</b><br /><b>c</b> - Date ISO 8601, par ex. <b>2004-02-12T15:19:21+00:00</b><br /><b>d</b> - jour du mois, 2 chiffres, commençant par zéro; soit <b>01</b> to <b>31</b><br /><b>D</b> - jour, textuel, trois lettres; par exemple, <b>Lun</b><br /><b>F</b> - mois, textuel, long; par exemple, <b>Janvier</b><br /><b>g</b> - heure, format 12 heures, pas de zéro non significatif; c'est-à-dire, <b>1</b> à <b>12</b><br /><b>G</b> - heure, format 24 heures, pas de zéro non significatif; c'est-à-dire, <b>0</b> à <b>23</b><br /><b>h</b> - heure, format 12 heures, zéro non significatif; c'est-à-dire, <b>01</b> à <b>12</b><br /><b>H</b> - heure, format 24 heures, zéro non significatif; c'est-à-dire, <b>00</b> à <b>23</b><br /><b>i</b> - minutes, zéro non significatif; c'est-à-dire, <b>00</b> à <b>59</b><br /><b>I</b> (majuscule «i») - indicateur d'heure d'été; <b>1</b> si l'heure d'été, <b>0</b> sinon.<br /><b>j</b> - jour du mois, pas de zéro non significatif; c'est à dire, <b>1</b> à <b>31</b><br /><b>l</b> (miniscule «L») - jour de la semaine, textuel, long; par exemple, <b>Vendredi</b><br /><b>L</b> - indicateur d'année bissextile; <b>1</b> s'il s'agit d'une année bissextile, <b>0</b> sinon.<br /><b>m</b> - mois, numérique, zéro non significatif; c'est-à-dire, <b>01</b> à <b>12</b><br /><b>M</b> - mois, textuel, 3 lettres; par exemple, <b>Jan</b><br /><b>n</b> - mois, numérique, pas de zéro non significatif; c'est à dire, <b>1</b> à <b>12</b><br /><b>O</b> (majuscule «o») - différence entre l'heure locale et l'heure de Greenwich (GMT) en heures; par exemple, <b>+0200</b><br /><b>r</b> - Date au format RFC 2822; par exemple, <b>Jeu,&nbsp;21&nbsp;Déc&nbsp;2000&nbsp;16:01:07&nbsp;+0200</b><br /><b>s</b> - secondes, avant zéro; c'est à dire, <b>00</b> à <b>59</b><br /><b>S</b> - suffixe du jour du mois, anglais uniquement, 2 caractères; c'est à dire, <b>st</b>, <b>nd</b>, <b>rd</b> ou <b>th</b>. Fonctionne bien avec <b>j</b><br /><b>t</b> - nombre de jours dans le mois donné; c'est à dire, <b>28</b> à <b>31</b><br /><b>T</b> - réglage du fuseau horaire de cette machine; par exemple, <b>CEST</b>, <b>EST</b>, <b>MDT</b><br /><b>U</b> - secondes depuis le début de l'époque Unix (1&nbsp;Janvier&nbsp;1970&nbsp;00:00:00&nbsp;GMT)<br /><b>w</b> - jour de la semaine, numérique; c'est-à-dire, <b>0</b> (dimanche) à <b>6</b> (samedi)<br /><b>W</b> - Numéro de semaine ISO 8601 de l'année, semaines commençant le lundi; par exemple. <b>42</b> (la 42e semaine de l'année)<br /><b>Y</b> - année, 4 chiffres; par exemple, <b>1999</b><br /><b>y</b> - année, 2 chiffres; par exemple, <b>99</b><br /><b>z</b> - jour de l'année, numérique, pas de zéros non significatifs; c'est-à-dire <b>0</b> (1er janvier) à <b>364</b> (31 décembre si ce n'est pas une année bissextile) ou <b>365</b> (31 décembre en années bissextiles)<br /><b>Z</b> - décalage du fuseau horaire en secondes. Le décalage pour les fuseaux horaires à l'ouest de Greenwich est toujours négatif et pour ceux à l'est de Greenwich, le décalage est toujours positif. C'est-à-dire, <b>-43200</b> à <b>43200</b><br /><br />Vous pouvez modifier l'ordre de ces symboles et ajouter des délimiteurs au format.<br />Par exemple, en allemand, ce champ contient normalement <b>H:i:s</b> pour produire un affichage comme <b>09:01:25</b>.<br />L'anglais définit généralement le format de l'heure comme <b>g:i:sa</b> pour produire un affichage comme <b>9:01:25am</b>.<br /><br />Dans le système de 24 heures, minuit est 00:00. Dans le système de 12 heures, minuit est 12am et midi est 12pm.";
$pgv_lang["week_start"]			= "Jour de départ de la semaine";
$pgv_lang["week_start_help"]		= "~#pgv_lang[week_start]#~<br /><br />Le jour de la semaine qui commence une nouvelle semaine dans cette langue. La plupart des langues commencent la semaine le dimanche, mais certaines commencent le lundi ou d'autres jours.";
$pgv_lang["name_reverse"]		= "Nom en premier";
$pgv_lang["name_reverse_help"]		= "~#pgv_lang[name_reverse]#~<br /><br />Dans certaines langues, le nom de famille doit être affiché en premier au lieu de la valeur par défaut pour l'afficher en dernier. L'activation de cette option affichera d'abord le nom de famille. Le hongrois, le chinois et le japonais sont des exemples où le nom de famille (le nom de famille) est généralement donné en premier.";
$pgv_lang["ltr"]			= "De gauche à droite";
$pgv_lang["rtl"]			= "De droite à gauche";
$pgv_lang["file_does_not_exist"]	= "ERREUR! le fichier n'existe pas...";
$pgv_lang["optional_file_not_exist"]	= "Ce fichier facultatif n'existe pas.";
$pgv_lang["alphabet_upper"]		= "Alphabet majuscule";
$pgv_lang["alphabet_upper_help"]	= "~#pgv_lang[alphabet_upper]#~<br /><br />Lettres de l'alphabet majuscules dans cette langue. Cet alphabet est utilisé lors du tri des listes de noms.";
$pgv_lang["alphabet_lower"]		= "Alphabet minuscule";
$pgv_lang["alphabet_lower_help"]	= "~#pgv_lang[alphabet_lower]#~<br /><br />Lettres minuscules de l'alphabet dans cette langue. Cet alphabet est utilisé lors du tri des listes de noms.";
$pgv_lang["multi_letter_alphabet"]		= "Alphabet à plusieurs lettres";
$pgv_lang["multi_letter_alphabet_help"]	= "~#pgv_lang[multi_letter_alphabet]#~<br /><br />Combinaisons de plusieurs lettres à traiter comme une seule lettre distincte lors du tri des listes de noms et de titres dans cette langue.<br /><br />Certaines langues, le hongrois et le slovaque par exemple, considèrent que certaines combinaisons de lettres sont distinctes lettres à part entière. L'ordre dans lequel vous spécifiez ces combinaisons de lettres détermine l'ordre dans lequel elles sont insérées dans l'alphabet normal pendant le tri. Ceci est important lorsque plusieurs combinaisons de plusieurs lettres ont la même première lettre. À l'exception de <b>ch</b>, ces combinaisons de lettres sont insérées dans l'alphabet normal en fonction de leur première lettre. <b>ch</b> est toujours inséré après <b>h</b>.";
$pgv_lang["multi_letter_equiv"]		= "Équivalents de plusieurs lettres";
$pgv_lang["multi_letter_equiv_help"]	= "~#pgv_lang[multi_letter_equiv]#~<br /><br />Dans certaines langues, plusieurs lettres sont souvent traitées comme équivalentes à une seule lettre lors de la génération de listes de noms.<br /><br />Par exemple, en néerlandais, les noms commençant par <b>IJ</b> sont répertoriés avec les noms commençant par <b>Y</b>. En norvégien, les noms commençant par <b>Aa</b> sont listés par <b>&Aring;</b>. Dans certaines langues, certaines lettres peuvent être écrites avec un ou deux caractères. Par exemple, en slovaque, les deux caractères D et \xC5\xBE peuvent être écrits sous la forme d'un seul caractère \xC7\x85. En spécifiant ici des équivalents, vous pouvez autoriser le regroupement des noms commençant par ces lettres sur les pages de la liste de personnes.<br /><br />Vous devez spécifier une liste d’équivalents séparés par des virgules. Pour prendre en charge les bases de données qui ne reconnaissent pas le codage UTF-8, vous devez spécifier des équivalents en majuscules et en minuscules. Cet exemple montre le format à utiliser.<br /><br />Aa=&Aring;, aa=&aring;";
$pgv_lang["dictionary_sort"]		= "Utiliser les règles du dictionnaire lors du tri";
$pgv_lang["dictionary_sort_help"]	= "~#pgv_lang[dictionary_sort]#~<br /><br />Cette option contrôle la manière dont les caractères avec des signes diacritiques sont traités lors du tri des listes de noms et de titres.<br /><br />Si défini sur <b>#pgv_lang[yes]#</b>, tous les caractères avec des signes diacritiques sont traités comme s'ils n'avaient pas de marques. Les signes diacritiques ne sont pris en compte que lorsque les deux mots considérés sont par ailleurs identiques. Si défini sur <b>#pgv_lang[no]#</b>, toutes les lettres sont distinctes, indépendamment de la présence ou de l'absence de signes diacritiques.";
$pgv_lang["collation"]		= "Séquence de classement de la base de données";
$pgv_lang["collation_help"]	= "~#pgv_lang[collation]#~<br /><br />Si vous utilisez les règles de classement intégrées de la base de données, cette option spécifie la séquence de classement à utiliser pour cette langue. Vous devez vous assurer que votre base de données prend en charge toutes les séquences de classement que vous avez l'intention d'utiliser.<br /><br />L'utilisation du classement de base de données est contrôlée dans les paramètres de configuration du site.";
$pgv_lang["lang_config_write_error"]	= "Erreur lors de l'écriture des paramètres de langue dans le fichier <i>language_settings.php</i>. Veuillez vérifier les autorisations et réessayer.";
$pgv_lang["lang_set_file_read_error"]	= "E R R E U R !!! Impossible de lire <i>language_settings.php</i>!";
$pgv_lang["add_new_language_help"]	= "~#pgv_lang[add_new_language]#~<br /><br />#pgv_lang[add_new_language_desc]#";
$pgv_lang["add_new_language_desc"]	= "Cette routine vous permet d'ajouter une nouvelle langue, précédemment indisponible et totalement non prise en charge à PhpGedView.<br /><br />Vous pouvez configurer les paramètres standard de la nouvelle langue. Ceux-ci incluent le code de détection de langue, le sens de la langue, le début de la semaine pour cette langue, les paramètres d'heure, l'alphabet, etc.<br /><br />Vous obtiendrez plus d'aide sur les paramètres des langues prises en charge par PhpGedView après avoir sélectionné la langue et en cliquant sur le bouton <b>#pgv_lang[add_new_lang_button]#</b>.<br /><br />Une aide supplémentaire est disponible sur la page de configuration pour la langue.";
$pgv_lang["add_new_lang_button"]	= "Ajouter une nouvelle langue";
$pgv_lang["hide_translated"]		= "Cacher traduit";
$pgv_lang["hide_translated_help"]		= "~#pgv_lang[hide_translated]#~<br /><br />Si défini sur <b>#pgv_lang[yes]#</b>, vous ne verrez que les messages du fichier de langue sélectionné qui n'ont pas été traduits. Cela signifie que le nouveau message n'apparaît <u>pas</u> dans le fichier de langue cible.<br /><br />Certains fichiers de langue contiennent du texte anglais pour divers messages non traduits. Cette routine ne peut pas identifier ces éléments non traduits, car ils sont déjà présents dans le fichier cible. L'hypothèse est: «Si le message est présent dans le fichier cible, il doit avoir été traduit.»";
$pgv_lang["lang_file_write_error"]	= "E R R E U R !!! Impossible d'écrire les modifications dans le fichier de langue sélectionné. Veuillez vérifier les autorisations d'écriture sur <b>#lang_filename#</b>";
$pgv_lang["no_open"]	= "E R R E U R !!! Impossible d'ouvrir le fichier <b>#lang_filename#</b>";
$pgv_lang["users_langs"]			= "Langues des utilisateurs";
$pgv_lang["configured_languages"]	= "Langues utilisées";

//-- User Migration Tool messages
$pgv_lang["um_header"] = "Outil de migration des informations utilisateur";
$pgv_lang["um_proceed"] = "Choisissez une option ou cliquez sur le lien ci-dessous pour revenir au menu Administration";
$pgv_lang["um_creating"] = "Création";
$pgv_lang["um_sql_index"] = "Cet outil créera <i>authenticate.php</i> et plusieurs fichiers <i>.dat</i> dans votre dossier Index.<br /><br />Une fois la création réussie, vous pouvez passer en mode Index avec tous les utilisateurs actuels et leurs messages, favoris, actualités et mise en page MyGedview disponibles.<br /><br />Remarque: après être passé en mode Index, vous devrez réimporter vos fichiers GEDCOM.";
$pgv_lang["um_file_create_fail1"] = "La création d'un nouveau fichier a échoué, un fichier avec ce nom existe déjà:";
$pgv_lang["um_file_create_fail2"] = "Impossible de créer";
$pgv_lang["um_file_create_fail3"] = "Vérifiez les droits d'accès sur ce dossier.";
$pgv_lang["um_file_create_succ1"] = "Création du nouveau fichier réussie:";
$pgv_lang["um_file_not_created"] = "Le fichier n'est pas créé.";
$pgv_lang["um_nomsg"] = "Aucun message ne semble être présent dans le système.";
$pgv_lang["um_nofav"] = "Aucun favori ne semble être présent dans le système.";
$pgv_lang["um_nonews"] = "Aucune actualité ne semble être présente dans le système.";
$pgv_lang["um_noblocks"] = "Aucun bloc ne semble être présent dans le système.";
$pgv_lang["um_index_sql"] = "Cet outil importera <i>authenticate.php</i> et d'autres fichiers <i>.dat</i> de votre dossier Index dans votre base de données.";
$pgv_lang["um_noaction"] = "Aucune action n'est requise pour migrer les informations utilisateur vers le mode SQL.<br /><br />Une fois passé en mode SQL, vous devez redémarrer l'<b>#pgv_lang[um_header]#</b> pour importer toutes les données dans la base de données SQL. PhpGedView utilisera les fichiers existants du mode Index.<br /><br /><b>Ne supprimez <u>pas</u> <i>authenticate.php</i> et les fichiers <i>.dat</i> de votre dossier Index lors du changement.</b>";
$pgv_lang["um_import"] = "Importer";
$pgv_lang["um_export"] = "Exporter";
$pgv_lang["um_explain"] = "Cet outil exportera les données utilisateur du mode SQL vers le mode Index ou importera les données utilisateur des fichiers Index dans les tables SQL.<br /><br />Les données utilisateur, les favoris, les définitions de bloc, les messages et les actualités seront à nouveau disponibles après la migration.<br /><br /><b>ATTENTION</b><br />Vous ne pouvez pas utiliser cet outil pour migrer les données utilisateur entre différentes versions de PhpGedView. Assurez-vous que les données proviennent ou sont importées dans la même version de PhpGedView.<br /><br /><b>IMPORT</b><br />Si vous choisissez d'importer les fichiers de données utilisateur à partir du mode Index, toutes les données utilisateur présentes dans les tables de la base de données seront <u>écrasées</u>. Cet outil ne fusionne <u>pas</u> les informations. Une fois que vous avez exécuté l'importation, il n'y a aucun moyen de récupérer les anciennes informations à l'aide de PhpGedView.<br /><br /><b>EXPORT</b><br />Si vous exportez les informations utilisateur de votre base de données SQL vers Fichiers en mode index, cet outil créera <i>authenticate.php</i> et plusieurs fichiers <i>.dat</i> dans votre dossier Index. Si des fichiers portant le même nom sont déjà présents, vous serez invité à indiquer s'ils doivent être écrasés. Après être passé en mode Index, toutes les informations seront disponibles directement.<br /><br /><b>Remarque:</b> Après être passé en mode Index, vous devrez réimporter vos fichiers GEDCOM.";
$pgv_lang["um_tool_help"] = "~#pgv_lang[um_header]#~<br /><br />#pgv_lang[um_explain]#";
$pgv_lang["um_sql_index_help"] = "~Migrer les utilisateurs du mode SQL vers le mode Index~<br /><br />#pgv_lang[um_sql_index]#";
$pgv_lang["um_index_sql_help"] = "~Migrer les utilisateurs du mode Index vers le mode SQL~<br /><br />#pgv_lang[um_index_sql]#";
$pgv_lang["um_imp_users"] = "Importer des utilisateurs";
$pgv_lang["um_imp_blocks"] = "Importer des blocs";
$pgv_lang["um_imp_favorites"] = "Importer des favoris";
$pgv_lang["um_imp_messages"] = "Importer des messages";
$pgv_lang["um_imp_news"] = "Importer des actualités";
$pgv_lang["um_nousers"] = "Fichier <i>authenticate.php</i> introuvable dans votre dossier d'index. La migration est annulée.";
$pgv_lang["um_imp_succ"] = "Importation réussie";
$pgv_lang["um_imp_fail"] = "L'importation a échoué";
$pgv_lang["um_backup"] = "Sauvegarde";
$pgv_lang["um_zip_succ"] = "Fichier ZIP créé avec succès.";
$pgv_lang["um_zip_dl"] = "Télécharger le fichier de sauvegarde ZIP ";
$pgv_lang["um_bu_explain"] = "Cet outil peut faire une sauvegarde de plusieurs types de données dans PhpGedView.<br /><br />Les données que vous choisissez de sauvegarder seront rassemblées dans un fichier ZIP, que vous pouvez télécharger en cliquant sur le lien en bas du page, une fois la sauvegarde effectuée.<br /><br />Le fichier ZIP restera dans votre dossier Index jusqu'à ce que vous le supprimiez manuellement.";
$pgv_lang["um_bu_help"] = "~#pgv_lang[um_backup]#~<br /><br />#pgv_lang[um_bu_explain]#";
$pgv_lang["um_bu_config"] = "Fichier de configuration PhpGedView";
$pgv_lang["um_bu_gedcoms"] = "Fichiers GEDCOM";
$pgv_lang["um_bu_gedsets"] = "Paramètres GEDCOM, fichiers de configuration et de confidentialité";
$pgv_lang["um_bu_logs"] = "Journaux de recherche GEDCOM et fichiers journaux PhpGedView";
$pgv_lang["um_bu_usinfo"] = "Définitions utilisateur, paramètres des blocs, favoris, messages, actualités";
$pgv_lang["um_bu_media"]	= "Fichiers multimédias";
$pgv_lang["um_mk_bu"] = "Faire une sauvegarde";
$pgv_lang["um_nofiles"] = "Aucun fichier trouvé pour la sauvegarde.";
$pgv_lang["um_files_exist"] = "Un ou plusieurs fichiers existent déjà. Voulez-vous les écraser?";
$pgv_lang["um_results"]		= "Résultats";
$pgv_lang["preview_faq_item"] = "Aperçu de tous les FAQ";
$pgv_lang["preview_faq_item_help"] = "~#pgv_lang[preview_faq_item]#~<br /><br />Cette option permet à un utilisateur administrateur d'afficher la page FAQ sans toutes les options de modification et les liens.<br /><br />À l'exception d'un seul lien <b>Modifier</b> au-dessus du premier élément de la FAQ, l'apparence de la FAQ page sera identique à ce qu'un utilisateur ordinaire verrait. Ce lien spécial <b>Modifier</b> restaurera la fonctionnalité complète de modification sur la page FAQ.";
$pgv_lang["restore_faq_edits"] = "Restaurer la fonctionnalité de modification de FAQ";
$pgv_lang["restore_faq_edits_help"] = "~#pgv_lang[restore_faq_edits]#~<br /><br />Cette option restaure la page FAQ à ce qu'un utilisateur administrateur voit normalement, de sorte que les éléments individuels de FAQ puissent être modifiés.";
$pgv_lang["add_faq_item"] = "Ajouter une FAQ";
$pgv_lang["add_faq_item_help"] = "~#pgv_lang[add_faq_item]#~<br /><br />Cette option vous permettra d'ajouter un élément à la page FAQ.";
$pgv_lang["edit_faq_item"] = "Modifier une FAQ";
$pgv_lang["edit_faq_item_help"] = "~#pgv_lang[edit_faq_item]#~<br /><br />Cette option vous permettra de modifier un élément sur la page FAQ.";
$pgv_lang["delete_faq_item"] = "Supprimer une FAQ";
$pgv_lang["delete_faq_item_help"] = "~#pgv_lang[delete_faq_item]#~<br /><br />Cette option vous permettra de supprimer un élément de la page FAQ";
$pgv_lang["moveup_faq_item"] = "Déplacer la FAQ vers le haut";
$pgv_lang["moveup_faq_item_help"] = "~#pgv_lang[moveup_faq_item]#~<br /><br />Cette option vous permettra de déplacer une FAQ vers le haut sur la page FAQ.<br /><br />Chaque fois que vous utilisez cette option, le numéro de position de la FAQ est réduit de un. Vous pouvez obtenir le même effet en modifiant la FAQ en question et en modifiant le champ Position. Lorsque plusieurs FAQ ont le même position, un seul de ces FAQ sera visible.";
$pgv_lang["movedown_faq_item"] = "Déplacer la FAQ vers le bas";
$pgv_lang["movedown_faq_item_help"] = "~#pgv_lang[movedown_faq_item]#~<br /><br />Cette option vous permettra de déplacer la FAQ vers le bas sur la page FAQ.<br /><br />Chaque fois que vous utilisez cette option, le numéro de position de la FAQ est augmenté de un. Vous pouvez obtenir le même effet en modifiant la FAQ en question et en modifiant le champ Position. Lorsque plusieurs FAQ ont le même numéro de position, un seul de ces FAQ sera visible.";
$pgv_lang["add_faq_header_help"] = "~#pgv_lang[add_faq_header]#~<br /><br />Ceci est le titre ou le sujet de la FAQ.<br /><br />Ce que vous entrez ici peut être formaté. Balises HTML telles que &lt;b&gt; et &lt;br /&gt; sont autorisées, tout comme les entités HTML telles que &amp;&amp; et &amp;nbsp;. Balises HTML autres que &lt;br /&gt; ne sont probablement pas très utiles dans le titre de la FAQ et doivent être évités.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["add_faq_body_help"] = "~#pgv_lang[add_faq_body]#~<br /><br />Le texte de l'élément FAQ est saisi ici.<br /><br />Le texte peut être formaté. Balises HTML telles que &lt;b&gt; et &lt;br /&gt; sont autorisées, tout comme les entités HTML telles que &amp;&amp; et &amp;nbsp;.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["add_faq_HTML"] = "Les entités HTML sont un moyen très simple d'ajouter des caractères spéciaux aux titres et au texte de votre FAQ. Vous pouvez utiliser des noms symboliques, des nombres décimaux ou des nombres hexadécimaux. Une liste complète des entités HTML, leur codage et leur représentation par votre navigateur peut être trouvée ici: <a href=\"http://htmlhelp.com/reference/html40/entities/\" target=\"_blank\">Listes d'entités HTML</a><br /><br />À l'occasion, vous devrez peut-être afficher un caractère tilde&nbsp;&nbsp;<b>&#x7E;</b>&nbsp;&nbsp;ou un signe dièse&nbsp;&nbsp;<b>&#x23;</b>&nbsp;&nbsp;dans vos URL ou texte. Ces caractères ont une signification particulière pour le système d'aide PhpGedView et ne peuvent être saisis que sous leur forme hexadécimale ou décimale. De même, les caractères&nbsp;&nbsp;<b>&lt;</b>&nbsp;&nbsp;et&nbsp;&nbsp;<b>&gt;</b>&nbsp;&nbsp;qui entourent généralement les balises HTML doivent être entrés en hexadécimal ou décimal formulaires s'ils doivent être traités comme du texte normal au lieu de signaler une balise HTML.<ul><li><b>&amp;&#x23;35;</b>&nbsp;&nbsp;ou&nbsp;&nbsp;<b>&amp;&#x23;x23;</b>&nbsp;&nbsp;auront pour résultat&nbsp;&nbsp;<b>&#x23;</b></li><li><b>&amp;&#x23;60;</b>&nbsp;&nbsp;ou&nbsp;&nbsp;<b>&amp;&#x23;x3C;</b>&nbsp;&nbsp;auront pour résultat&nbsp;&nbsp;<b>&#x3C;</b></li><li><b>&amp;&#x23;62;</b>&nbsp;&nbsp;ou&nbsp;&nbsp;<b>&amp;&#x23;x3E;</b>&nbsp;&nbsp;auront pour résultat&nbsp;&nbsp;<b>&#x3E;</b></li><li><b>&amp;&#x23;126;</b>&nbsp;&nbsp;ou&nbsp;&nbsp;<b>&amp;&#x23;x7E;</b>&nbsp;&nbsp;auront pour résultat&nbsp;&nbsp;<b>&#x7E;</b></li></ul>Il y a une entité HTML&nbsp;&nbsp;<b>&amp;tilde;</b>&nbsp;&nbsp; mais ce symbole n'est pas interprété comme un tilde s'elle est codé dans des URL.";
$pgv_lang["add_faq_pgvLangRefs"] = "Vous pouvez insérer des références à des entrées dans les fichiers de langue ou à des valeurs de variables globales. Exemples:<ul><li><b>&#x23;pgv_lang[add_to_cart]&#x23;</b>&nbsp;&nbsp;&nbsp;est une référence à la variable de langue \$pgv_lang[\"add_to_cart\"], et s'il devait apparaître dans ce champ, apparaîtrait comme <b>#pgv_lang[add_to_cart]#</b> lorsque la liste des FAQ est affichée dans la langue actuelle.</li><li><b>&#x23;factarray[AFN]&#x23;</b>&nbsp;&nbsp;&nbsp;est une référence au nom du fait \$factarray[\"AFN\"], et s'il devait apparaître dans ce champ, apparaîtrait comme <b>#factarray[AFN]#</b> lorsque la liste des FAQ est affichée dans la langue actuelle.</li><li><b>&#x23;PGV_VERSION&#x23;&nbsp;&#x23;PGV_VERSION_RELEASE&#x23;</b>&nbsp;&nbsp;&nbsp;est une référence au constant PGV_VERSION, un espace et une référence au constant PGV_VERSION_RELEASE, et si elles devaient apparaître dans ce champ, s'afficheraient comme <b>#PGV_VERSION#&nbsp;#PGV_VERSION_RELEASE#</b> lorsque la liste des FAQ est affichée dans la langue actuelle.</li><li><b>&#x23;GLOBALS[GEDCOM]&#x23;</b>&nbsp;&nbsp;&nbsp;est une référence à la variable globale \$GEDCOM, qui est le nom du fichier GEDCOM actuel. S'il devait apparaître dans ce champ, il apparaîtrait comme <b>#GLOBALS[GEDCOM]#</b>.</li><li><b>&#x23;GLOBALS[GEDCOM_TITLE]&#x23;</b>&nbsp;&nbsp;&nbsp;est une référence à la variable globale \$GEDCOM_TITLE, qui est le titre du fichier GEDCOM actuel. S'il devait apparaître dans ce champ, il apparaîtrait comme <b>#GLOBALS[GEDCOM_TITLE]#</b>.</li></ul><br />Cette fonctionnalité est utile lorsque vous souhaitez créer des listes de FAQ différentes pour chaque langue prise en charge par votre site. Vous devez mettre les titres et entrées de votre liste FAQ personnalisée dans les fichiers <i>languages/extra.xx.php</i> (<i>xx</i> est le code pour chaque langue), en utilisant le format suivant:<br /><code>\$pgv_lang[\"faq_title1\"]&nbsp;=&nbsp;\"Ceci est un exemple de titre de FAQ\";<br />\$pgv_lang[\"faq_body1\"]&nbsp;=&nbsp;\"Ceci est un exemple de corps de FAQ.\";</code>";
$pgv_lang["add_faq_order_help"] = "~#pgv_lang[add_faq_order]#~<br /><br />Ce champ contrôle l'ordre dans lequel les FAQ sont affichées.<br /><br />Il n'est pas nécessaire de saisir les numéros de manière séquentielle. Si vous laissez des trous dans le schéma de numérotation, vous pouvez insérer d'autres FAQ ultérieurement. Par exemple, si vous utilisez les nombres 1, 6, 11, 16, vous pouvez insérer ultérieurement des FAQ avec les numéros de séquence manquants. Les nombres négatifs et le zéro sont autorisés et peuvent être utilisés pour insérer des FAQ avant la première.<br /><br />Lorsque plusieurs éléments de la FAQ ont le même numéro de position, un seul de ces éléments sera visible.";
$pgv_lang["add_faq_visibility_help"] = "~#pgv_lang[add_faq_visibility]#~<br /><br />Vous pouvez déterminer si cette FAQ sera visible indépendamment de GEDCOM, ou si elle ne sera visible que par le GEDCOM actuel.<br /><ul><li><b>#pgv_lang[all]#</b>&nbsp;&nbsp;&nbsp;La FAQ apparaîtra dans toutes les listes de FAQ, indépendamment de GEDCOM.</li><li><b>#GLOBALS[GEDCOM]#</b>&nbsp;&nbsp;&nbsp;La FAQ n'apparaîtra que dans la liste FAQ de GEDCOM actuellement active.</li></ul>";
$pgv_lang["index_gedcom_news_adm_help"]		= "Le texte d'actualités GEDCOM permet l'utilisation de <b>balises HTML</b> et <b>entités HTML</b>. Le HTML ne doit pas être utilisé dans les titres d'actualités.<br /><br />Veillez à toujours utiliser les balises de début et de fin. Il peut être utile d'avoir une compréhension du HTML appropriée pour un administrateur de site Web. Ce programme utilise également des <b>feuilles de style en cascade (CSS)</b>. Un CSS différent est implémenté pour chaque thème. Vous pouvez utiliser les classes de ces feuilles de style pour contrôler l'apparence de vos messages.<br /><br />Si vous avez besoin d'aide supplémentaire, le site Web PhpGedView propose quelques exemples d'utilisation de ces balises dans votre bloc actualités GEDCOM.<br /><br />Comme pour la liste des FAQ, les titres d’actualité et le texte d’actualité de GEDCOM permettent des références intégrées aux variables \$pgv_lang, \$factarray et \$GLOBALS pour offrir une flexibilité totale dans la création sensible à la langue actuellement active.<br /><br />La description suivante, tirée du texte d'aide de la liste des FAQ, s'applique également aux actualités de GEDCOM.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["time_limit_help"]			= "~#pgv_lang[time_limit]#~<br /><br />Durée maximale d'exécution de l'importation pour le traitement du fichier GEDCOM.";

// editconfig_gedcom.php Option Filter
$pgv_lang["ged_filter_results"] = "Résultats trouvés";
$pgv_lang["ged_filter_reset"] = "Effacer la recherche";
$pgv_lang["ged_filter_description"] = "Texte de recherche";
$pgv_lang["ged_filter_description_help"] = "~#pgv_lang[ged_filter_description]#~<br /><br />Cette option vous permet de rechercher le texte associé aux options de configuration.<br /><br />À mesure que vous tapez des lettres, la recherche trouvera toutes les options de configuration contenant cette séquence de lettres. La recherche devient plus précise à mesure que vous tapez plus de lettres.";

?>
