<?php
/**
 * Hungarian texts
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2021  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @author PGV Developers
 * @author Hrotkó Gábor <roti@al.pmmf.hu>
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: configure_help.hu.php 7287 2021-02-14 14:41:32Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

//-- CONFIGURE FILE MESSAGES
$pgv_lang["gedcom_conf"]		= "GEDCOM alapok";
$pgv_lang["media_conf"]			= "Multimédia";
$pgv_lang["displ_names_conf"]		= "Nevek";
$pgv_lang["displ_comsurn_conf"] 	= "Gyakori vezetéknevek";
$pgv_lang["editopt_conf"]		= "Szerkesztési opciók";
$pgv_lang["useropt_conf"]		= "Felhasználói opciók";
$pgv_lang["meta_conf"]                  = "META tag-ek beállítási lehetőségei";
$pgv_lang["gedconf_head"]               = "GEDCOM konfiguráció";
$pgv_lang["other_theme"]		= "Egyéb, kérjük, gépelje be";
$pgv_lang["performing_update"]		= "A frissítés folyamatban";
$pgv_lang["config_file_read"]		= "A konfigurációs állomány olvasása.";
$pgv_lang["does_not_exist"]		= "nem létezik";
$pgv_lang["media_drive_letter"]		= "Célszerű, hogy a média-állományok elérési útja ne tartalmazza a meghajtó betűjelét, mivel egyes esetekben így az állomány nem jelenik meg.";
$pgv_lang["db_setup_bad"]		= "Az Ön aktuális adatbázis-beállításai hibásak. Kérjük, ellenőrizze a kapcsolat paramétereit és végezze el újból a beállításokat.";
$pgv_lang["bad_host_user_pass"]		= "A PhpGedView nem tudott kapcsolatot létesíteni az Ön adatbázis kiszolgálójával. Kérjük, ellenőrizze a kiszolgáló, felhasználói név és jelszó beállításait, hogy azok megfelelőek-e.";
$pgv_lang["bad_database_name"]		= "A PhpGedView kapcsolatot létesített az Ön adatbázis kiszolgálójával, de az Ön által megadott felhasználó nem volt megfelelő. Kérjük, ellenőrizze, hogy az adatbázis létezik-e, illetve a megadott felhasználónak megvannak-e a megfelelő jogosultságai.";
$pgv_lang["db"]                         = "Adatbázis";
$pgv_lang["current_gedcoms"]		= "Aktuális GEDCOM-állományok";
$pgv_lang["ged_gedcom"]			= "GEDCOM-állomány";
$pgv_lang["ged_title"]			= "GEDCOM-állomány címe";
$pgv_lang["ged_config"]			= "Konfigurációs állomány";
$pgv_lang["ged_search"]			= "Keresési Naplók állományai";
$pgv_lang["ged_change"]			= "Változások Naplója állományai";
$pgv_lang["ged_privacy"]                = "Bizalmassági állomány";
$pgv_lang["disabled"]			= "Tiltva";
$pgv_lang["mousedown"]			= "Az egérgomb nyomvatartására";
$pgv_lang["mouseover"]			= "Az egér áthúzására";
$pgv_lang["click"]			= "Egérkattintásra";
$pgv_lang["enter_db_pass"]		= "Biztonsági okokból meg kell adnia a #pgv_lang[DBUSER]# és a #pgv_lang[DBPASS]# mielőtt változtatna a konfigurációs adatokban.";
$pgv_lang["server_url_note"]    	= "Ez az Ön PhpGedView oldalának webcíme. Csak abban az esetben változtassa meg ezt a beállítást, ha biztos abban, amit tenni szeretne. A PhpGedView számításai alapján a szerver URL-je: <b>#GUESS_URL#</b>";
$pgv_lang["DBTYPE"]                     = "Az adatbázis típusa";
$pgv_lang["DBTYPE_help"]                = "~#pgv_lang[DBTYPE]#~<br /><br />Az Ön adatbázisa, mely támogatja a PEAR-t.<br /><br />A PhpGedView támogatja a MySQL, PostgreSQL és a SQLite adatbázisokat.<br /><br />";
$pgv_lang["DBHOST"] 			= "Adatbázis szerver";
$pgv_lang["DBHOST_help"] 		= "~#pgv_lang[DBHOST]#~<br /><br />Az Ön adatbázisát működtető számítógép DNS-e vagy IP-címe. Ez a beállítás nem lesz használva ha SQLite adatbázist használ.<br /><br />";
$pgv_lang["DBUSER"] 			= "Az adatbázis felhasználóneve";
$pgv_lang["DBUSER_help"] 		= "~#pgv_lang[DBUSER]#~<br /><br />Az adatbázis felhasználóneve, mely az adatbázisba való bejelentkezéshez szükséges. Ez a beállítás nem lesz használva ha SQLite adatbázist használ.<br /><br />";
$pgv_lang["DBPASS"] 			= "Az adatbázis jelszava";
$pgv_lang["DBPASS_help"] 		= "~#pgv_lang[DBPASS]#~<br /><br />Az adatbázis jelszava, mely #pgv_lang[DBUSER]# mezőben megadott felhasználóhoz tartozik. Ez a beállítás nem lesz használva ha SQLite adatbázist használ.<br /><br />";
$pgv_lang["DBNAME"] 			= "Az adatbázis neve";
$pgv_lang["DBNAME_help"] 		= "~#pgv_lang[DBNAME]#~<br /><br />Az Ön által a PhpGedView-hoz használni kívánt adatbázis a szerveren.<br /><br />A #pgv_lang[DBUSER]# mezőben megadott felhasználónak a következő jogosultságokkal kell rendelkeznie: létrehoz, beszúr, frissít, töröl és kijelöl. Az SQLite-nak egy állomány nevet kell megadni egy olyan mappába ahol a PHP-nek írási joga van mint az index mappa (index/phpgedview.db).<br /><br />";
$pgv_lang["TBLPREFIX_help"] 		= "~#pgv_lang[TBLPREFIX]#~<br /><br />Az előtag, melyet a PhpGedView az adattáblák nevéhez fűz. A mező tartalmának megváltoztatásával Ön több PhpGedView-oldalt üzemeltethet azonos adatbázissal, de eltérő adattáblákkal.<br /><br />";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"] 	= "~#pgv_lang[ALLOW_CHANGE_GEDCOM]#~<br /><br />Ezen változó beállításával engedélyezheti, hogy a látogatók választhassanak  a GEDCOM-állományok között, amennyiben Ön beállította a többszörös GEDCOM-adattáblák környezetét.<br /><br />Ha Ön a <b>Nem</b>-et választja, sem a látogatók sem a bejelentkezett felhasználók nem válthatnak a rendelkezésre álló GEDCOM-állományok között.<br /><br />";
$pgv_lang["upload_path"]		= "Feltöltési útvonal";
$pgv_lang["upload_path_help"]		= "~#pgv_lang[upload_path]#~<br /><br />Ez az útvonal ahol a feltöltendő GEDCOM állomány található.";
$pgv_lang["gedcom_path"]		= "GEDCOM útvonala és neve a szerveren";
$pgv_lang["gedcom_path_help"] 		= "~#pgv_lang[gedcom_path]#~<br /><br />Két lehetőség van hogy egy GEDCOM állományt importáljon a PhpGedView-ba. Ezek a:<ol><li>FTP használata</li><li>PhpGedView -n való feltöltés</li></ol>Amikor már az állomány a szerveren van, használja a <i>#pgv_lang[add_gedcom]#</i> Adja meg az állomány nevét és eléréséi útját a szerveren. Ha az elérési utját nem adja meg akkor a <i>#pgv_lang[INDEX_DIRECTORY]#</i> utvonal lesz használva ami a PhpGedView konfigurációban van beállitva.<br /><br />Amikor a <i>#pgv_lang[upload_gedcom]#</i> funkciót használja akkor keresse meg a kívánt állományt a számítógépén. Ez lehet egy általános GEDCOM állomány vagy egy ZIP állomány amiben a GEDCOM állomány található. A PhpGedView automatikusan kiszedi a ZIP állományból a GEDCOM állományt.<br /><br />Amikor egy állományt feltölt, a nevét és a spórolási helyét megváltoztathatja a szerveren.<br /><br />Bővebb információt a <a href=\"readme.txt\">Readme.txt</a> állományban találhat.<br />";
$pgv_lang["CHARACTER_SET"] 		= "Karakterkészlet-kódolás";
$pgv_lang["CHARACTER_SET_help"] 	= "~#pgv_lang[CHARACTER_SET]#~<br /><br />Az Ön GEDCOM-állományának karakterkészlete. Az alapértelmezett kódolás az UTF-8, mely az oldalak döntő többsége képes kezelni. Amennyiben Ön ibm windows kódolással exportálta GEDCOM-állományát, írjon ide WINDOWS-t.<br /><br />FONTOS: A PHP nem támogatja az UNICODE (UTF-16) kódolást, tehát kérjük, ne állítsa azt be.<br />";
$pgv_lang["LANGUAGE"] 			= "Nyelv";
$pgv_lang["LANGUAGE_help"] 		= "~#pgv_lang[LANGUAGE]#~<br /><br />Kijelöli az oldal alapértelmezett nyelvét.<br /><br />A felhasználók természetesen megváltoztathatják ezt a böngészőjük beállításain keresztül, vagy a lap alján található vezérlőpanel segítségével (ha az <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b> értéke <b>true</b>).<br />";
$pgv_lang["ENABLE_MULTI_LANGUAGE"] 	= "A látogatók nyelvet válthatnak";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"] = "~#pgv_lang[ENABLE_MULTI_LANGUAGE]#~<br /><br />Állítsa <b>igen</b>-re, hogy a felhasználók kiválaszthassák a használni kívánt nyelvet a lap alján lévő lenyíló-ablakból és a böngészőjükben beállított alapértelmezett nyelvet használhassák.<br />";
$pgv_lang["CALENDAR_FORMAT"] 		= "Dátumformátum";
$pgv_lang["CALENDAR_FORMAT_help"] 	= "~#pgv_lang[CALENDAR_FORMAT]#~<br /><br />Lehetővé teszi, hogy Ön beállítsa azt a naptárformátumot, melyet ehhez a GEDCOM-állományhoz szeretne használni.<br /><br />A héber naptár megegyezik a zsidó naptárral, csak héber karaktereket használ.<br /><br />Megjegyzés: A zsidó/héber naptárban használt értékek a gregorián/juliánusz dátumokból számítjuk. Mivel a zsidó naptári nap alkonyatkor kezdődik, ezért minden olyan esemény, mely alkonyattól éjfélig zajlik, egy nappal korábban kerül feltüntetésre. A héber karakterek megjelenítése egyes régebbi böngészőkön problémás lehet, melyek fordítva vagy sehogy sem jelenítik meg azokat.<br />";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"] 		= "Megjeleníti a héber ezreseket";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"] 	= "~#pgv_lang[DISPLAY_JEWISH_THOUSANDS]#~<br /><br />Mutatja az Alafim-ot a héber naptárban.<br /><br />Ha ezt igen-re állítjuk, akkor az 1969-es év így jelenik meg: <span lang=\"he-IL\" dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; , nem-re állítva pedig így jelennek meg az évek <span lang=\"he-IL\" dir='rtl'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;. Ez nincs befolyással a zsidó évek beállítására. Az év 5729-ként jelenik meg, függetlenül ettől a beállítástól.<br /><br />Figyelem: Ez a beállítás hasonló a PHP 5.0 Calendar constant CAL_JEWISH_ADD_ALAFIM.<br />";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]		= "A héber gershayim megjelenítése";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"]	= "~#pgv_lang[DISPLAY_JEWISH_GERESHAYIM]#~<br /><br />Az aposztróf és az idézőjelek használata a héber dátumok megjelenítésénél.<br /><br />Ha ezt igen-re állítjuk, akkor az 1969 február 8. így jelenik meg <span lang='he-IL' dir='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; , míg ezt nem-re állítva így jelenik meg <span lang='he-IL' dir='rtl'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;. Ez a beállítás nincs hatással a zsidó évek megjelenítésére, mivel a zsidó dátumokban megjelenő idézőjelek nem jelennek meg a Latin karakterek használatával.<br /><br />Megjegyzés: Ez a beállítás hasonló a PHP 5.0 CAL_JEWISH_ADD_ALAFIM_GERESH és CAL_JEWISH_ADD_GERESHAYIM naptár konstansához. Ez a beállítás mindkét változóra hatással van.<br />";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"] 	= "Zsidó Ashkenazi kiejtés";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"] = "~#pgv_lang[JEWISH_ASHKENAZ_PRONUNCIATION]#~<br /><br />Használja a zsidó Ashkenazi kiejtéseket.<br /><br />Ha ezt igen-re állítjuk, a Cheshvan és Teves hónapok az Ashkenazi kiejtéssel jelennek meg. Ha ezt nem-re állítjuk, nem változik ezeknek a hónapoknak a megjelenése. Ez csak a zsidó beállításokra van hatással. A héber beállítást használva, a héber ábécét használjuk.<br /><br />";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"] 	= "Az ősfa generációinak száma";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"] 	= "~#pgv_lang[DEFAULT_PEDIGREE_GENERATIONS]#~<br /><br />Megadja a generációk alapértelmezett számát, melyek az ősfán megjelenítésre kerülnek.<br />";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"] 		= "Az ősfa generációinak maximális száma";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"] 	= "~#pgv_lang[MAX_PEDIGREE_GENERATIONS]#~<br /><br />";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"] 	= "Leszármazott generációk maximális száma";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"] 	= "~#pgv_lang[MAX_DESCENDANCY_GENERATIONS]#~<br /><br />Megszabja a leszármazottak grafikonján feltüntethető generációk maximális számát.<br />";
$pgv_lang["USE_RIN"] 				= "RIN# azonosító használata a GEDCOM ID helyett";
$pgv_lang["USE_RIN_help"] 			= "~#pgv_lang[USE_RIN]#~<br /><br />Állítsa <b>Igen</b>-re, ha a RIN-azonosítót kívánja használni a GEDCOM-azonosító helyett, mikor egyéni azonosítót kell megadnia a beállításokhoz, keresésekhez vagy diagrammokhoz. Hasznos beállítás olyan genealógiai programok esetében, melyek nem exportálják a GEDCOM-állományokat külön személyi azonosítóval, hanem állandó RIN-azonosítót használnak.<br />";
$pgv_lang["PEDIGREE_ROOT_ID"] 			= "Az ősfa és a leszármazottak grafikonja esetében alapértelmezett személy";
$pgv_lang["PEDIGREE_ROOT_ID_help"] 		= "~#pgv_lang[PEDIGREE_ROOT_ID]#~<br /><br />Megszabja az ősfa illetve a leszármazottak fája esetében alapértelmezett személy azonosítóját.<br />";
$pgv_lang["GEDCOM_ID_PREFIX"]			= "Személy azonosító előtag";
$pgv_lang["GEDCOM_ID_PREFIX_help"]		= "~#pgv_lang[GEDCOM_ID_PREFIX]#~<br /><br />Amikor egy új személy kerül felvételre a PhpGedView -ba, akkor egy új azonosító generálódik hozzá. A személy azonosító előtagja ez lesz.<br />";
$pgv_lang["SOURCE_ID_PREFIX"]			= "Forrás azonosító előtag";
$pgv_lang["REPO_ID_PREFIX"]			= "Szervezet azonosító előtag";
$pgv_lang["PEDIGREE_FULL_DETAILS"] 		= "A születési és halálozási adatok mutatása az ősfán és a leszármazottak fáján";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"]	 	= "~#pgv_lang[PEDIGREE_FULL_DETAILS]#~<br /><br />Megszabja, hogy a születési és halálozási adatok alapértelmezetten feltüntetésre kerülejenek-e.<br />";
$pgv_lang["PEDIGREE_LAYOUT"]			= "Az ősfa alapértelmezett nézete:";
$pgv_lang["PEDIGREE_LAYOUT_help"]		= "~#pgv_lang[PEDIGREE_LAYOUT]#~<br /><br />Ebben a mezőben adható meg, hogy az ősfa álló vagy fekvő nézetben jöjjön létre.<br />";
$pgv_lang["SHOW_EMPTY_BOXES"] 			= "Üres szövegdobozok feltüntetése az ősfán";
$pgv_lang["SHOW_EMPTY_BOXES_help"]		= "~#pgv_lang[SHOW_EMPTY_BOXES]#~<br /><br />Megszabja, hogy üres cellák feltüntetésre kerüljenek-e az ősfán.<br />";
$pgv_lang["ZOOM_BOXES"]				= "Ráközelítés a cellákra";
$pgv_lang["ZOOM_BOXES_help"]			= "~#pgv_lang[ZOOM_BOXES]#~<br /><br />Lehetővé teszi, hogy a felhasználók ráközelíthessenek a cellákra, hogy így több információt kaphassanak az adott személyről.<br /><br />Állítsa be a <b>#pgv_lang[disabled]#</b> opciót, ha nem kívánja ezt engedélyezni. Válassza az <b>#pgv_lang[mouseover]#</b> opciót, ha az egér áthaladására, illetve a <b>#pgv_lang[click]#</b> opciót ha az egér kattintására kívánja aktiválni ezt a funkciót.<br />";
$pgv_lang["LINK_ICONS"]				= "Felugró hivatkozások a diagrammokon";
$pgv_lang["LINK_ICONS_help"]			= "~#pgv_lang[LINK_ICONS]#~<br /><br />Lehetővé teszi, hogy a felhasználók közvetlenül kiválaszthassanak más diagrammokat, vagy a személy közeli rokonait.<br /><br />Állítsa be a <b>#pgv_lang[disabled]#</b> opciót, ha nem kívánja ezt engedélyezni. Válassza az <b>#pgv_lang[mouseover]#</b> opciót, ha az egér áthaladására, illetve a <b>#pgv_lang[click]#</b> opciót ha az egér kattintására kívánja aktiválni ezt a funkciót.<br />";
$pgv_lang["ABBREVIATE_CHART_LABELS"]		= "Feliratok rövidítése";
$pgv_lang["ABBREVIATE_CHART_LABELS_help"] 	= "~#pgv_lang[ABBREVIATE_CHART_LABELS]#~<br /><br />Itt adható meg, hogy a program rövidítse-e a grafikonokon az olyan feliratokat, mint pl. <b>Született</b>, csak az kezdőbetűt tüntetve fel.<br />";
$pgv_lang["SHOW_PARENTS_AGE"]			= "Szülők kora mutatása a gyerek születésnapja mellet";
$pgv_lang["HIDE_LIVE_PEOPLE"] 			= "Diszkrét adatkezelés engedélyezése";
$pgv_lang["HIDE_LIVE_PEOPLE_help"] 		= "~#pgv_lang[HIDE_LIVE_PEOPLE]#~<br /><br />Ez az opció engedélyezi a diszkrét adatkezelésre vonatkozó beállításokat és elrejti az életben lévő személyek adatait.<br /><br />Élő személynek tekintjük azt, akivel kapcsolatban nincs rögzített esemény \$MAX_ALIVE_AGE évnél korábban, illetve akinek nem született gyermeke \$MAX_ALIVE_AGE évnél régebben.<br />";
$pgv_lang["REQUIRE_AUTHENTICATION"]		= "Felhasználói azonosítás megkövetelése";
$pgv_lang["REQUIRE_AUTHENTICATION_help"] 	= "~#pgv_lang[REQUIRE_AUTHENTICATION]#~<br /><br />Ennek az opciónak az engedélyezésével, a látogatók csak azután tekinthetnek meg bármilyen adatot az oldalon, miután bejelentkeztek.<br />";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"]     	= "A bejelentkező oldal üdvözlő szövege \"Hitelesített módban\"";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_help"]        = "~#pgv_lang[WELCOME_TEXT_AUTH_MODE]#~<br /><br />Itt választhatja ki azt a szöveget, mely a bejelentkező oldalon jelenik meg akkor, ha a <b>Hitelesített mód</b> aktiválva van. Kérjük, próbálja ki, melyik előre definiált szövegváltozat a leginkább megfelelő Önnek. Természetesen megadhat egyéni üdvözlő szöveget is, de ez nem lesz lefordítva más nyelvekre.<br /><br />Az előre definiált változatok a következők:<ul><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT1]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_1]#</div><br /></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT2]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_2]#</div><br /></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT3]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_3]#</div></li></ul>";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"]        = "Szövegváltozat, mely szerint minden felhasználó igényelhet hozzáférést";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"]        = "Szövegváltozat, mely szerint az adminisztrátor dönti el, hogy elfogadja-e a hozzáféréshez benyújtott igényeket";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"]        = "Szövegváltozat, mely szerint kizárólag családtagok igényelhetnek hozzáférést";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"]        = "Az alább begépelt egyéni üdvözlő szöveg kiválasztása";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"]        = "Egyéni üdvözlő szöveg";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_help"]   = "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#~<br /><br />Ha Ön az egyéni üdvözlő szöveg lehetőségét választotta, itt adhatja meg a szöveget. A szöveg azonban NEM kerül lefordításara a  látogatók nyelvére, éppen úgy fejelnik meg, ahogy Ön begépelte.<br /><br />Ha szüksége, HTML-kódot is illeszthet a szövegbe.<br />";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"] 	= "Egyéni üdvözlő szöveg alapértelmezett fejléce";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD_help"] = "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST_HEAD]#~<br /><br />Válassa az általános fejlécmegjelenítésére az üdvözlő szöveghez. Amikor a felhasználók nyelvet változtatnak akkor a fejléc az új nyelven jelenik meg.<br /><br />Ha Ön az igen-t jejöli meg, a fejléc így fog megjelenni:<div class=\"list_value_wrap\">#pgv_lang[welcome_text_cust_head]#</div>";
$pgv_lang["CHECK_CHILD_DATES"] 			= "Gyermekekkel kapcsolatos dátumok ellenőrzése";
$pgv_lang["CHECK_CHILD_DATES_help"] 		= "~#pgv_lang[CHECK_CHILD_DATES]#~<br /><br />Leellenőrzi egy gyermek dátumait, amikor meghatározzuk hogy egy személy elhunyt-e. Régebbi rendszereken és nagyobb GEDCOMoknál ez lelassíthatja az oldal működését.<br />";
$pgv_lang["MAX_ALIVE_AGE"] 			= "Az életkor, mely után az adott személy feltehetően már nem él";
$pgv_lang["MAX_ALIVE_AGE_help"] 		= "~#pgv_lang[MAX_ALIVE_AGE]#~<br /><br />Az évek maximális száma, amit egy személyhez kapcsolódó esemény, vagy gyermekeinek életkora alapján használunk ahhoz hogy meghatározzuk hogy életben van-e.<br />";
$pgv_lang["SHOW_GEDCOM_RECORD"] 		= "A felhasználók láthatják a nyers GEDCOM-rekordot";
$pgv_lang["SHOW_GEDCOM_RECORD_help"] 		= "~#pgv_lang[SHOW_GEDCOM_RECORD]#~<br /><br />Ha Ön ezt az opciót <b>Igen</b>-re állítja, akkor a személyek, források és családok mellett megjelenik egy hivatkozás, mellyel a felhasználók egy felugró ablakban megjeleníthetik a nyers GEDCOM-rekordot.<br />";
$pgv_lang["ALLOW_EDIT_GEDCOM"] 			= "Online szerkesztés engedélyezése";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"] 		= "~#pgv_lang[ALLOW_EDIT_GEDCOM]#~<br /><br />Az aktuális GEDCOM-állományban engedélyezi az online szerkesztés lehetőségét, tehát a szerkesztési jogosultsággal rendelkező felhasználók módosíthatják a GEDCOM-ot.<br />";
$pgv_lang["INDEX_DIRECTORY_help"] 		= "~#pgv_lang[INDEX_DIRECTORY]#~<br /><br />Annak az olvasható és írható könyvtárnak az útvonala, ahol a PhpGedView tárolja az indexfájlokat (a végén a \"/\" jellel).<br /><br />";
$pgv_lang["POSTAL_CODE"]  			= "Postai irányítószám pozíciója";
$pgv_lang["POSTAL_CODE_help"] =		 "~#pgv_lang[POSTAL_CODE]#~<br /><br />Különbözö országok kölönbözöen írják a címeket. Itt be tudja állítani hogy az irántítószám a városnév elött vagy utána legyen.<br />";
$pgv_lang["SHOW_ID_NUMBERS_help"] 		= "~#pgv_lang[SHOW_ID_NUMBERS]#~<br /><br />Mutatja az ID számokat zárójelben a név mögött a táblázatokban.<br />";
$pgv_lang["SHOW_PEDIGREE_PLACES"] 		= "Megmutatja a helységeket a személynél";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"] 		= "~#pgv_lang[SHOW_PEDIGREE_PLACES]#~<br /><br />Mutatja a helységeket a születés és az elhalálozás mellett a családi a és leszármazási táblázatokban.<br />";
$pgv_lang["MULTI_MEDIA"] 			= "Multimédiás megoldások engedélyezése";
$pgv_lang["MULTI_MEDIA_help"] 			= "~#pgv_lang[MULTI_MEDIA]#~<br /><br />A GEDCOM 5.5.1 formátum lehetővé teszi képek, filmek és egyéb multimédiás elemek  behivatkozását a GEDCOM-ba. Ha Ön nem illeszt multimédia elemeket a GEDCOM-állományába, lehetősége van a szolgáltatás kiiktatására, ha <b>Nem</b>-re állítja ezt a mezőt. <br /><br />További információt kaphat a multimédia elemek beillesztéséről a <a href=\"readme.txt\">readme.txt</a> Multimédia fejezetéből.<br />";
$pgv_lang["MEDIA_EXTERNAL"]			= "Hivatkozások megtartása";
$pgv_lang["MEDIA_EXTERNAL_help"]        	= "~#pgv_lang[MEDIA_EXTERNAL]#~<br /><br />Ha egy multimédiás hivatkozás kezdete pl. http://, ftp://, mms://, akkor azt nem változtatjuk meg, ha ezt az opciót <b>igen</b>-re állítja. Például a http://www.myfamily.com/photo/dad.jpg továbbra is  http://www.myfamily.com/photo/dad.jpg marad. Ha viszont <b>nem</b>-re állítja, általános hivatkozásként kezeljük és a médiakönyvtárhoz képest adjuk meg az elérését. Például a http://www.myfamily.com/photo/dad.jpg hivatkozást így alakítjuk át: ./media/dad.jpg.<br />";
$pgv_lang["MEDIA_DIRECTORY"] 			= "Multimédia-elemek könyvtára";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"] 		= "Multimédia könyvtárak szintjeinek kezelése";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"] 	= "~#pgv_lang[MEDIA_DIRECTORY_LEVELS]#~<br /><br />Ha ez az érték 0-ra van állítva, akkor nem veszünk figyelembe egy könyvtárat sem az állomány útvonalában a médiaobjektumhoz. Ha az érték 1, akkor az első könyvtárat használjuk ahol ez a kép van. Ha növeljük ezt a számot, akkor több szülőkönyvtár kerül a keresési útvonalba.  <br />Például: ha egy kép a GEDCOM-ban ezzel a könyvtárral szerepel C:/Documents and Settings/User/My Documents/My Pictures/Genealogy/Surname Line/grandpa.jpg, akkor a 0 értéket megadva ez a könyvtár átalakul erre: ./media/grandpa.jpg.  Az 1-es értékre ez lesz az útvonal ./media/Surname Line/grandpa.jpg, stb. A legtöbb esetben a 0 a megfelelő érték, de lehetséges az hogy több médiaelemnek is ugyan az a neve, és ekkor lehet ezzel a változóval jobban rendszerezni a médiaelemeket, és elkerülni a névütközéseket.<br />";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"] 	= "~#pgv_lang[SHOW_HIGHLIGHT_IMAGES]#~<br /><br />Ha engedélyezve van a multimédia az oldalon, akkor a PhpGedView megmutathat kisképeket egy személy neve mellett a táblázatokban és a szövegdobozokban.<br /><br />A PhpGedView jelenleg az első multimédia objektumot használja erre a célra. Ahol több kép van megadva, ott azt a képet kell az első helyre rendezni, amelyiket erre a célra szeretnénk használni.<br /><br />Lásd a multimédia részt a <a href=\"readme.txt\">readme.txt</a> fájlban, a multimédia elemek beillesztéséről.<br />";
$pgv_lang["USE_THUMBS_MAIN"]    		= "Kisképek használat a személyes oldalakon";
$pgv_lang["USE_THUMBS_MAIN_help"]       	= "~#pgv_lang[USE_THUMBS_MAIN]#~<br /><br />Attól függően, hogy Ön hogyan tárolja a képeit, bizonyos esetekben jobb, ha a személyes oldalakon a kisképek jelennek meg a személyek neve mellett.<br /><br />Ha az eredeti képek túl nagyok, letöltésük hosszú időt vehet igénybe, így a kisképek jól helyettesíthetik őket (ha minőségük megfelelő). Állítsa ezt az elemet <b>igen</b>-re, ha a kisképeket akarja használni, illetve hagyja meg <b>nem</b> beállítást, ha az eredeti felbontású képeket választja.<br />";
$pgv_lang["ENABLE_CLIPPINGS_CART"] 		= "A családfa ágak kosarának engedélyezése";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"] 	= "~#pgv_lang[ENABLE_CLIPPINGS_CART]#~<br /><br />A családfa ágak kosara lehetővé teszi, hogy külön személyeket válasszunk ki, akiknek az adatai ezután egy fájlban letölthetőek, és más családfa programba beimportálhatóak.<br />";
$pgv_lang["HIDE_GEDCOM_ERRORS"] 		= "GEDCOM-hibák elrejtése";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"] 		= "~#pgv_lang[HIDE_GEDCOM_ERRORS]#~<br /><br />Ha ezt beállítjuk <b>igen</b>-re, akkor nem jelennek meg a GEDCOM állomány feldolgozása közben előforduló hibák. A PhpGedView törekszik a GEDCOM 5.5.1-es szabványt betartására, de sok egyéb családfa program tárolhat saját bejegyzéseket az állományban. Lásd a <a href=\"readme.txt\">readme.txt</a> állományt további információért.<br />";
$pgv_lang["WORD_WRAPPED_NOTES"] 		= "Szóközök beillesztése a sortöréseknél";
$pgv_lang["WORD_WRAPPED_NOTES_help"] 		= "~#pgv_lang[WORD_WRAPPED_NOTES]#~<br /><br />Néhány családfa-program a megjegyzések sorait több sorba töri a szavak végén, néhány pedig máshol. Ebből kifolyólag a PhpGedView összekapcsolhat szavakat. A mezőt <b>igen</b>-re állítva, a hosszú sorok töréséhez szóközök kerülnek a GEDCOMban.<br />";
$pgv_lang["SHOW_CONTEXT_HELP"]			= "A Környezetérzékeny segítség mutatása alapértelmezettként";
$pgv_lang["SHOW_CONTEXT_HELP_help"]		= "~#pgv_lang[SHOW_CONTEXT_HELP]#~<br /><br />Ezzel a beállítással, azokon az oldalakon ahol van környezetérzékeny segítség, ott kérdőjelekkel jelezzük ezt.<br />";
$pgv_lang["COMMON_NAMES_THRESHOLD"]     	= "Küszöbérték a Gyakori vezetéknévhez";
$pgv_lang["COMMON_NAMES_THRESHOLD_help"] 	= "~#pgv_lang[COMMON_NAMES_THRESHOLD]#~<br /><br />A vezetéknév előfordulásainak száma ahhoz, hogy Gyakori vezetéknevek között jelenjen meg a Nyitóoldalon.<br />";
$pgv_lang["COMMON_NAMES_ADD"]   		= "Nevek hozzáadása a Gyakori vezetéknevekhez (vesszővel elválasztva)";
$pgv_lang["COMMON_NAMES_ADD_help"]      	= "~#pgv_lang[COMMON_NAMES_ADD]#~<br /><br />Ha egy vezetéknév előfordulása nem éri el a küszöbértéket, nem fog megjelenni a listában. Ugyanakkor hozzáadhatja őket manuálisan. Ha több nevet kíván felvenni a listára, vesszővel válassza el őket egymástól. <b>A vezetéknevek érzékenyek a kis- és nagybetűk közötti különbségre.</b><br />";
$pgv_lang["COMMON_NAMES_REMOVE"]        	= "Nevek eltávolítása a Gyakori vezetéknevek közül (vesszővel elválasztva)";
$pgv_lang["COMMON_NAMES_REMOVE_help"]   	= "~#pgv_lang[COMMON_NAMES_REMOVE]#~<br /><br />Ha Ön bizonyos vezetékneveket el kíván távolítani a listáról anélkül, hogy csökkentenie kelljen a küszöbértéket, akkor itt kell azokat megadnia. Ha több nevet kíván felvenni a listára, vesszővel válassza el őket egymástól. <b>A vezetéknevek érzékenyek a kis- és nagybetűk közötti különbségre.</b><br />";
$pgv_lang["HOME_SITE_URL"] 			= "A fő weboldal URL-je";
$pgv_lang["HOME_SITE_URL_help"] 		= "~#pgv_lang[HOME_SITE_URL]#~<br /><br />Egy webcím, ami az oldal fejlécében szerepel. Itt általában a fő weboldal címét érdemes megadni.<br />";
$pgv_lang["HOME_SITE_TEXT"] 			= "A fő weboldal szövege";
$pgv_lang["HOME_SITE_TEXT_help"] 		= "~#pgv_lang[HOME_SITE_TEXT]#~<br /><br />Az a szöveg, amire kattintva juthatunk a fő weboldalhoz.<br />";
$pgv_lang["CONTACT_EMAIL"] 			= "E-mail cím genealógiai kérdésekhez";
$pgv_lang["CONTACT_EMAIL_help"] 		= "~#pgv_lang[CONTACT_EMAIL]#~<br /><br />Az az email cím, amire a látogatók írhatnak az oldalon levő családfa adatokkal kapcsolatban.<br />";
$pgv_lang["CONTACT_METHOD"]			= "Kapcsolattartási forma";
$pgv_lang["CONTACT_METHOD_help"]		= "~#pgv_lang[CONTACT_METHOD]#~<br /><br />Az a kapcsolattartási forma, amit a látogatók használhatnak a 'kapcsolattartó személlyel' való kommunikációhoz, családfa adatokkal kapcsolatban. Erre a címre kattintva megnyílik a felhasználó email kliense, és rögtön írhat levelet. Az 'üzenés' opcióval a PhpGedView beépített üzenetküldését használhatjuk, email küldése nélkül. Az 'üzenet email-el' opció az alapértelmezett, és itt az üzenet másolatát email-ban is elküldjük. Az 'email-ek tárolás nélkül' opciónál a PhpGedView kezeli az üzenetküldést, és email-ként küldi az üzeneteket, de nem tárolja el azokat. Ha nem jelöljük be az üzenetek küldésének lehetőségét, akkor a látogatók nem tudnak üzenni nekünk.<br />";
$pgv_lang["WEBMASTER_EMAIL"] 			= "E-mail cím a Webmesterhez";
$pgv_lang["WEBMASTER_EMAIL_help"] 		= "~#pgv_lang[WEBMASTER_EMAIL]#~<br /><br />Az az e-mail cím, amire a látogatók a technikai jellegű kérdésekkel fordulhatnak, esetleg hibákat jelezheznek.<br />";
$pgv_lang["SUPPORT_METHOD"]			= "A támogatás formája";
$pgv_lang["SUPPORT_METHOD_help"]		= "~#pgv_lang[SUPPORT_METHOD]#~<br /><br />Az a mód, ahogy a látogatók a 'támogató személlyel' felveszik a kapcsolatot a családfával kapcsolatos kérdésekben. Erre a címre kattintva megnyílik a felhasználó e-mail kliense, és rögtön írhat levelet. Az 'PhpGedView belső üzenet' opcióval a PhpGedView beépített üzenetküldését használhatjuk, e-mail küldése nélkül. Az 'Belső üzenet e-maillel megerősítve' opció az alapértelmezett, és itt az üzenet másolatát e-mailban is elküldjük. Az 'E-mailek tárolás nélkül' opciónál a PhpGedView kezeli az üzenetküldést, és e-mailként küldi az üzeneteket, de nem tárolja el azokat. Ha a 'Nincs kapcsolattartás' opciót jelöljük be, akkor a látogatók nem tudnak üzenni nekünk.<br />";
$pgv_lang["FAVICON"] 				= "Kedvencek ikon";
$pgv_lang["FAVICON_help"] 			= "~#pgv_lang[FAVICON]#~<br /><br />Állítsa be azt az ikon-állományt, melyet meg kíván mutatni, amikor az Ön oldalát felveszik a Kedvencek közé.<br />";
$pgv_lang["THEME_DIR"] 				= "Témák könyvtára";
$pgv_lang["THEME_DIR_help"] 			= "~#pgv_lang[THEME_DIR]#~<br /><br />Az a könyvtár, ahol a PhpGedView a megjelenés témáinak fájljait tárolja.<br /><br />A témákkal egyedi kinézetet adhatunk oldalunknak. Lásd a 'saját témák' részt a <a href=\"readme.txt\">readme.txt</a> fájlban több információért.<br />";
$pgv_lang["TIME_LIMIT"] 			= "PHP időkorlát";
$pgv_lang["TIME_LIMIT_help"] 			= "~#pgv_lang[TIME_LIMIT]#~<br /><br />Az a maximum hossz, amíg a PhpGedView fithat.<br /><br />Az alap érték 1 perc. A GEDCOM fájl méretétől függően, indexek készítéséhez növelheti ezt a számot. Ha 0-ra álítja akkornincs időkorlát.<br /><br />FIGYELEM: 0-ra állítva, vagy túl nagy értékre állítva ezt, a művelet befejezéséig az oldal lefagyhat. Ha 0-át állítunk be, lehetséges hogy soha nem fejeződik be a program futása, amíg a rendszergazda le nem állítja, vagy újra nem indítja a programot a szerveren. Nagy családfákat sok ideig tarthat feldolgozni, így ezt a számot alacsony értéken tartva megakadályozhatjuk hogy valaki leállítsa a webszervert 1000 diagramm készítésével.<br />";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"] 	= "~#pgv_lang[PGV_SESSION_SAVE_PATH]#~<br /><br />Az elérési út, ahol a PhpGedView-munkamenetek állományait kívánja tárolni.<br /><br />Egyes szolgáltatóknál a PHP-beállítások hiányosak, és a munkamenetekre vonatkozó adatokat nem tartják karban az egyes laphívások között. Ez a mező lehetőséget ad az adminisztrátornak, hogy az eredeti beállításokat felülírva lokálisan tárolja a munkamenetekre vonatkozó adatokat (melyhez az ./index/ könyvtár jó választás lehet). Alapértelmezett az üres mező, vagyis a <i>php.ini</i>-ben megadott érték változatlanul hagyása.<br /><br />";
$pgv_lang["SERVER_URL_help"]			= "~#pgv_lang[SERVER_URL]#~<br /><br />Amennyiben Ön https-kapcsolatot, vagy az alapértelmezettől eltérő portot használ, meg kell adnia a szerver URL-jét.<br /><br />";
$pgv_lang["LOGIN_URL"]                  	= "Bejelentkező URL";
$pgv_lang["LOGIN_URL_help"]             	= "~#pgv_lang[LOGIN_URL]#~<br /><br />Csak abban az esetben adjon meg bejelentkező URL-t, ha a bejelentkezés után át kívánja irányítani a felhasználókat egy másik oldalra. Ez a lehetőség igen hasznos például akkor, ha Ön http-ről https-re szeretne váltani a beléptetés után. A <i>login.php</i> teljes elérési útját adja meg it (pl. https://www.yourserver.com/phpgedview/login.php).<br />";
$pgv_lang["PGV_SESSION_TIME_help"] 	= "~#pgv_lang[PGV_SESSION_TIME]#~<br /><br />Az időtartam másodpercben megadva, mely alatt egy PhpGedView-munkamenet aktív, és a felhasználónak nem kell újra bejelentkezni.  Az alapértelmezett érték 2 óra (7200 másodperc).<br /><br />";
$pgv_lang["SHOW_STATS"] 		= "Futtatási statisztika megjelenítése";
$pgv_lang["SHOW_STATS_help"] 		= "~#pgv_lang[SHOW_STATS]#~<br /><br />Minden lap alján feltünteti a futtatási és adatbázis-lekérdezési statisztikát.<br />";
$pgv_lang["SHOW_COUNTER"]		= "Számláló megjelenítése";
$pgv_lang["SHOW_COUNTER_help"]		= "~#pgv_lang[SHOW_COUNTER]#~<br /><br />Látogató-számláló feltüntetése a portál- és a személyhez kötődő oldalon.<br />";
$pgv_lang["USE_REGISTRATION_MODULE_help"]	= "~#pgv_lang[USE_REGISTRATION_MODULE]#~<br /><br />Lehetővé teszi, hogy a látogatók regisztrálják magukat az oldalon.<br /><br />A látogató kapni fog egy e-mailt melyen keresztül megerősíti regisztrációs szándékát. Az aktiváció előtt ezt szándékot az adminisztrátornak is jóvá kell hagyni. <br /><br />";
$pgv_lang["ALLOW_USER_THEMES_help"]	= "~#pgv_lang[ALLOW_USER_THEMES]#~<br /><br />A felhasználók kiválaszthatják a nekik tetsző, egyedi asztal-témát.<br /><br />";
$pgv_lang["PGV_SIMPLE_MAIL_help"] 	= "~#pgv_lang[PGV_SIMPLE_MAIL]#~<br /><br />A külső e-mailek fejléceiben egyaránt megtalálható az e-mail cím és a levél küldőjének a neve. Ugyanakkor egyes levelezőrendszerek nem fogadják el ezt a megoldást. Állítsa <b>igen</b>-re, hogy csak az e-mail cím kerüljön elküldésre.<br /><br />";
$pgv_lang["gedcom_title"]			= "#pgv_lang[ged_title]#";
$pgv_lang["gedcom_title_help"]		= "~#pgv_lang[gedcom_title]#~<br /><br />Adjon meg egy, a GEDCOM-állományra jellemző nevet, melyet az egyes állományok közötti választáskor látnak a felhasználók.<br />";
$pgv_lang["LOGFILE_CREATE"]		= "Napló-állományok archiválása";
$pgv_lang["LOGFILE_CREATE_help"]	= "~#pgv_lang[LOGFILE_CREATE]#~<br /><br />A napló-állományok archiválási gyakorisága.<br /><br />";
$pgv_lang["PGV_MEMORY_LIMIT_help"]	= "~#pgv_lang[PGV_MEMORY_LIMIT]#~<br /><br />A PhpGedView által maximálisan felhasználható memória mérete, melynek  alapértelmezett értéke 64 MB. Sok szolgáltató tiltja ezt a beállítási lehetőséget a PHP-beállításaiban, így a végrehajtott változtatások nem gyakorolnak minden esetben hatást a felhasznált memória méretére.<br /><br />";
$pgv_lang["PGV_STORE_MESSAGES_help"]	= "~#pgv_lang[PGV_STORE_MESSAGES]#~<br /><br />Megszabja, hogy a PhpGedView-n keresztül küldött üzenetek tárolásra kerüljenek-e az adatbázisban. Ha az <b>Igen</b>-t választja, a felhasználók láthatják az üzeneteiket, mikor bejelentkeznek a PhpGedView-be, a <b>Nem</b> esetén az üzeneteket csak e-mailben kapják meg.<br /><br />";
$pgv_lang["ALLOW_THEME_DROPDOWN"]       = "Megjelenítit az asztaltémák közötti választást biztosító legördülő menüt.";
$pgv_lang["ALLOW_THEME_DROPDOWN_help"]  = "~#pgv_lang[ALLOW_THEME_DROPDOWN]#~<br /><br />Biztosítja a felhasználóknak azt a lehetőséget, hogy kiválasszák saját asztaltémájukat egy legördülő menüből (ha ez a lehetőség létezik az adott asztaltémában).<br /><br />Ehhez a lehetőséghez az <b>#pgv_lang[ALLOW_USER_THEMES]#</b> mezőt szintén jóvá kell hagyni.<br /><br />";
$pgv_lang["META_AUTHOR"]                = "\"Szerző\" META tag";
$pgv_lang["META_AUTHOR_help"]   	= "~#pgv_lang[META_AUTHOR]#~<br /><br />A HTML oldal fejlécében lévő <b>szerző</b> META tag-nek ad értéket. Kérjük, hagyja üresen ezt a mezőt, ha GEDCOM-állományhoz megadott kapcsolattartó nevét szeretné itt használni.<br /><br />";
$pgv_lang["META_AUTHOR_descr"]  	= "Kérjük, hagyja üresen ezt a mezőt, ha GEDCOM-állományhoz megadott kapcsolattartó nevét szeretné itt használni. ";
$pgv_lang["META_PUBLISHER"]             = "\"Kiadó\" META tag";
$pgv_lang["META_PUBLISHER_help"]        = "~#pgv_lang[META_PUBLISHER]#~<br /><br />A HTML oldal fejlécében lévő <b>kiadó</b> META tag-nek ad értéket. Kérjük, hagyja üresen ezt a mezőt, ha GEDCOM-állományhoz megadott kapcsolattartó nevét szeretné itt használni.<br /><br />";
$pgv_lang["META_PUBLISHER_descr"]       = "Kérjük, hagyja üresen ezt a mezőt, ha GEDCOM-állományhoz megadott kapcsolattartó nevét szeretné itt használni. ";
$pgv_lang["META_COPYRIGHT"]             = "\"Copyright\" META tag";
$pgv_lang["META_COPYRIGHT_help"]        = "~#pgv_lang[META_COPYRIGHT]#~<br /><br />A HTML oldal fejlécében lévő <b>copyright</b> META tag-nek ad értéket. Kérjük, hagyja üresen ezt a mezőt, ha GEDCOM-állományhoz megadott kapcsolattartó nevét szeretné itt használni. <br />";
$pgv_lang["META_COPYRIGHT_descr"]       = "Kérjük, hagyja üresen ezt a mezőt, ha GEDCOM-állományhoz megadott kapcsolattartó nevét szeretné itt használni. ";
$pgv_lang["META_DESCRIPTION"]           = "\"Leírás\" META tag";
$pgv_lang["META_DESCRIPTION_help"]      = "~#pgv_lang[META_DESCRIPTION]#~<br /><br />A HTML oldal fejlécében lévő <b>leírás</b> META tag-nek ad értéket. Kérjük, hagyja üresen ezt a mezőt, ha az aktuális GEDCOM-állomány címét szeretné itt használni.<br /><br />";
$pgv_lang["META_DESCRIPTION_descr"]     = "Kérjük, hagyja üresen ezt a mezőt, ha az aktuális GEDCOM-állomány címét szeretné it használni.";
$pgv_lang["META_PAGE_TOPIC"]            = "\"Az oldal tárgya\" META tag";
$pgv_lang["META_PAGE_TOPIC_help"]       = "~#pgv_lang[META_PAGE_TOPIC]#~<br /><br />A HTML oldal fejlécében lévő \"az oldal tárgya\" META tag-nek ad értéket. Kérjük, hagyja üresen ezt a mezőt, ha az aktuális GEDCOM-állomány címét szeretné itt használni.<br /><br />";
$pgv_lang["META_PAGE_TOPIC_descr"]      = "Kérjük, hagyja üresen ezt a mezőt, ha az aktuális GEDCOM-állomány címét szeretné itt használni.";
$pgv_lang["META_AUDIENCE"]              = "\"Célközönség\" META tag";
$pgv_lang["META_AUDIENCE_help"] 	= "~#pgv_lang[META_AUDIENCE]#~<br /><br />A HTML oldal fejlécében lévő <b>célközönség</b> META tag-nek ad értéket.<br /><br />";
$pgv_lang["META_PAGE_TYPE"]             = "\"Az oldal típusa\" META tag";
$pgv_lang["META_PAGE_TYPE_help"]        = "~#pgv_lang[META_PAGE_TYPE]#~<br /><br />A HTML oldal fejlécében lévő <b>az oldal típusa</b> META tag-nek ad értéket.<br /><br />";
$pgv_lang["META_ROBOTS"]                = "\"Robotok\" META tag";
$pgv_lang["META_ROBOTS_help"]   	= "~#pgv_lang[META_ROBOTS]#~<br /><br />A HTML oldal fejlécében lévő <b>robotok</b> META tag-nek ad értéket. Számos keresőrobot nem veszi figyelembe ezt az értéket.<br /><br />";
$pgv_lang["META_REVISIT"]               = "\"Keresőrobotok látogatási gyakorisága\" META tag";
$pgv_lang["META_REVISIT_help"]  	= "~#pgv_lang[META_REVISIT]#~<br /><br />A HTML oldal fejlécében lévő <b>látogatási gyakoriság</b> META tag-nek ad értéket. Számos keresőrobot nem veszi figyelembe ezt az értéket.<br /><br />";
$pgv_lang["META_KEYWORDS"]              = "\"Kulcsszavak\" META tag";
$pgv_lang["META_KEYWORDS_help"] 	= "~#pgv_lang[META_KEYWORDS]#~<br /><br />A HTML oldal fejlécében lévő <b>kulcsszavak</b> META tag-nek ad értéket. Számos keresőmotor fogja használni az oldal indexelésében az itt megadott kulcsszavakat. A GEDCOM-statisztika blokkban található leggyakoribb vezetékneveket a program hozzáfűzi azon kifejezésekhez, melyeket Ön itt megad.<br /><br />";
$pgv_lang["META_TITLE"]         	= "A fejléc \"TITLE\" elemének hozzáadása";
$pgv_lang["META_TITLE_help"]    	= "~#pgv_lang[META_TITLE]#~<br /><br />A HTML oldal fejlécében lévő <b>TITLE</b> elemnek ad értéket úgy, hogy az ide írt szöveget az általános cím és a PhpGedView-ra való utalás közé fűzi.<br /><br />";
$pgv_lang["RSS_FORMAT"]				= "RSS formátum";
$pgv_lang["welcome_new_help"]		= "~#pgv_lang[welcome_new]#~#pgv_lang[welcome_new2]#Ez az ablak segítséget nyújt Önnek a konfigurációs folyamat során. Ahogyan belép az egyes mezőkbe, az ablakban mindig az aktuális elemről kap tájékoztatást. Bármikor becsukhatja ezt az ablakot, újbóli megnyitásához kattintson a cellák melletti bármelyik <b>?</b> jelre.<br />";
$pgv_lang["return_editconfig"]		= "Ön bármikor visszatérhet a konfiguráláshoz, ha böngészőjében megnyitja az editconfig.php állományt, vagy az <b>Adminisztráció</b>oldalán rákattint a <b>Beállítások</b> hivatkozásra.<br />";
$pgv_lang["return_editconfig_gedcom"]	= "Ön bármikor visszatérhet a konfiguráláshoz, ha az <b>Aktuális GEDCOM-állományok</b> táblázatból (mely a <b>GEDCOM-kezelés és diszkréciós beállítások</b> oldalon található) kiválasztja a <b>Szerkesztés</b> hivatkozást, illetve a böngészőjében megnyitja az editconfig.php állományt.<br />";
$pgv_lang["save_config"] 		= "Konfiguráció mentése";
$pgv_lang["download_gedconf"]		= "GEDCOM-beállítások letöltése";
$pgv_lang["not_writable"]		= "Az Ön konfigurációs állományát a PHP nem tudja írni. Használja a letöltés gombot a beállítások állományba történő elmentésére, amit később külön feltölthet az oldalra.";
$pgv_lang["upload_to_index"]		= "Az állomány feltöltése az index könyvtárba.";

//-- edit privacy messages
$pgv_lang["edit_privacy"]			= "Diszkréciós beállítások";
$pgv_lang["edit_privacy_title"]			= "A GEDCOM-állomány diszkrét adatkezelési beállításai";
$pgv_lang["save_changed_settings"]		= "Változások mentése";
$pgv_lang["add_new_pp_setting"]			= "Új személy-alapú diszkréciós szabály hozzáadása";
$pgv_lang["add_new_up_setting"]			= "Új felhasználó-alapú diszkréciós szabály hozzáadása";
$pgv_lang["add_new_gf_setting"]			= "Új kifejezés-alapú diszkréciós szabály hozzáadása";
$pgv_lang["add_new_pf_setting"]			= "Új személy- és kifejezés-alapú diszkréciós szabály hozzáadása";
$pgv_lang["file_read_error"]			= "HIBA!!! A diszkrét adatkezelés állománya nem olvasható!";
$pgv_lang["edit_exist_person_privacy_settings"]	= "A létező személy-alapú diszkréciós szabályok szerkesztése";
$pgv_lang["edit_exist_user_privacy_settings"]	= "A létező felhasználó-alapú diszkréciós szabályok szerkesztése";
$pgv_lang["edit_exist_global_facts_settings"]	= "A létező kifejezés-alapú diszkréciós szabályok szerkesztése";
$pgv_lang["edit_exist_person_facts_settings"]	= "A létező személy- és kifejezés-alapú diszkréciós szabályok szerkesztése";
$pgv_lang["general_privacy_help"]		= "#pgv_lang[general_settings]#<br /><br />Ezek a beállítások lesznek az alap beállítások az egyéni családfánál. Ellenőrizze az oldal fejlécében látható címmel, hogy a megfelelő GEDCOMot szerkeszti-e.<br /><br />Ezt azt is jelenti, hogy ha több GEDCOMja van az oldalon, mindegyikhez külön beállítások rendelhetők.<br /><br />Ezeket a beállításokat felülbírálhatja a Diszkréciós Form-al a #pgv_lang[edit_privacy_title]# oldalon.<br />#pgv_lang[more_config_help]#";
$pgv_lang["person_privacy_help"]		= "~#pgv_lang[person_privacy]#~<br /><br />A 'személy-alapú diszkréció' lehetővé teszi adminisztrátornak, hogy bizonyos személyek esetében felülírja a diszkrét adatkezelés általános szabályait. Például egy élő személy csecsemőkorban elhunyt gyermekét elvben minden látogató láthatja, ugyanakkor a szülők adatait továbbra is diszkréten kell kezelni (anélkül, hogy a gyermek adatait eltávolítanánk). Ha a gyermek azonosítója I100 volt, Önnek a következő adatkezelési szabályt kell beállítania: <br /><br />Azonosító: I100<br />Hozzáférhet: 'Csak regisztrált felhasználók'<br /><br />Természetesen ez működik megfordítva is: ha Ön publikussá akarja tenni valakinek az adatait (azonosító: I101), akiról tudja, hogy elhunyt, de nem tudja az elhalálozási adatait, akkor a következőket kell megadnia: <br /><br />Azonosító: I100<br />Hozzáférhet: 'Bármelyik látogató'<br /><br />";
$pgv_lang["user_privacy_help"]			= "~#pgv_lang[user_privacy]#~<br /><br />A 'felhasználó-alapú diszkréció' lehetővé teszi az adminisztrátornak, hogy bizonyos személyek esetében, az egyes felhasználókhoz kapcsolódva felülírja a diszkrét adatkezelés általános szabályait.<br /><br />Tehát ha Ön a 'János' nevű felhasználónak nem szeretné megmutatni az I100-as azonosítójú személy adatait, a következőket kell beállítania: <br /><br />Felhasználó: 'János'<br />Azonosító: I100<br />Hozzáférhető?: 'Rejtett'<br /><br />. Ezek alapján ha az I100-as személy adatait (melyek rejtettek, mert pl. az adott személy életben van) meg szeretné mutatni a 'János' nevű felhasználónak, a következőket állítsa be:<br /><br />Felhasználó: 'János'<br />Azonosító: I100<br />Hozzáférhető?: 'Látható'<br /><br />";
$pgv_lang["global_facts_help"]			= "~#pgv_lang[global_facts]#~<br /><br />A 'kifejezés-alapú diszkrécióval' meghatározhatók azok a genealógiai szakkifejezések, melyeket globálisan el kíván rejteni.<br /><br />A [\"kifejezés neve\"] határozza meg az elrejtendő kifejezést. A [\"választás\"] elemmel választhat maga a kifejezés illetve a kifejezés részletezése között. A [\"hozzáférhet\"] elemmel határozhatja meg azok körét, akik láthatják az adott kifejezést.<br /><br />A \$global_facts tömb feladata, hogy  bizonyos kifejezéseket minden személyre vonatkozóan elrejtsen függetlenül attól, hogy a személyek élnek vagy elhunytak. Alapbeállításként az SSN-kifejezés van elrejtve minden látogató elől, annak elkerülése érdekében, hogy az Ön rokonainak társadalombiztosítási azonosítójával ne követhessenek el visszaélést (melynek az USÁ-ban nagy jelentősége van).<br /> Ha tehát Ön az összes házasságot el kívánja rejteni a látogatók elől, a következőket kell beállítania: <br /><br />Kifejezés neve: '(MARR) - Házasságok'<br />Választás: 'Kifejezés hozzáférhető'<br />Hozzáférhet: 'Csak regisztrált felhasználók'<br /><br />(...)<br /><br />A többi beállítástól eltérően, ez  esetben lehetőség van arra, hogy az adminisztrátorok elől is elrejtsen bizonyos kifejezéseket, mellyel letilthat minden nem kívánt jellemzőt.<br /><br />";
$pgv_lang["person_facts_help"]			= "~#pgv_lang[person_facts]#~<br /><br />A 'személy- és kifejezés-alapú diszkrécióval' meghatározhatók azok a kifejezések, melyeket bizonyos személlyel kapcsolatban Ön el kíván rejteni, valamint az elrejtettség foka is.<br /><br />Az első elem az érintett személy azonosítója, a második a genealógiai szakkifejezés.<br />A [\"választás\"] elemmel választhat maga a kifejezés illetve a kifejezés részletezése között. A [\"hozzáférhet\"] elemmel határozhatja meg azok körét, akik láthatják az adott kifejezést.<br /><br />A \$person_facts tömb a \$global_facts tömbhöz hasonlóan működik, azzal a különbséggel, hogy Ön kijelölheti azt a személyt, akire vonatkozóan akar kifejezéseket elrejteni.<br /><br />";
$pgv_lang["accessible_by"]			= "Hozzáférhet";
$pgv_lang["hide"]				= "Elrejt";
$pgv_lang["show_question"]			= "Hozzáférhető?";
$pgv_lang["user_name"]				= "Felhasználónév";
$pgv_lang["name_of_fact"]			= "Kifejezés neve";
$pgv_lang["choice"]				= "Választás";
$pgv_lang["fact_show"]				= "Kifejezés hozzáférhető";
$pgv_lang["fact_details"]			= "Kifejezés részletezése hozzáférhető";
$pgv_lang["privacy_header"]			= "Belső diszkréciós beállítás szerkesztése";
$pgv_lang["unable_to_find_privacy_indi"]	= "Nem található ilyen azonosítójú személy";
$pgv_lang["save_and_import"]			= "Miután elmentette a GEDCOM-beállításokat, Önnek importálnia kell a GEDCOM-állományt a <b>GEDCOM-állomány importálása</b> gombra kattintva vagy a következő menükön keresztül: <b>Adminisztráció->GEDCOM-állományok kezelése->Import</b>.";
$pgv_lang["SHOW_LIVING_NAMES"]			= "Élő személyek nevéhez hozzáférhet";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]		= "Diszkréció rokonság alapján";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]		= "Rokonsági fok maximális nagysága";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]		= "Házastársi kapcsolatok ellenőrzése";
$pgv_lang["SHOW_DEAD_PEOPLE"]			= "Elhunyt személyekhez hozzáférhet";
$pgv_lang["help_info"]				= "Minden elemről magyarázatot kérhet a piros '?'-re való kattintással.";
$pgv_lang["SHOW_LIVING_NAMES_help"]		= "~#pgv_lang[SHOW_LIVING_NAMES]#~<br /><br />Élő személyek nevének megmutatása.<br /><br />Lehetőséget biztosít arra, hogy az élő személyek nevét bárki láthassa.<br /><br />";
$pgv_lang["SHOW_RESEARCH_ASSISTANT"]			= "Kutatási segéd mutatása";
$pgv_lang["SHOW_RESEARCH_ASSISTANT"]			= "Kutatási segéd mutatása";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]	= "~#pgv_lang[USE_RELATIONSHIP_PRIVACY]#~<br /><br /><Rokoni kapcsolatok diszkrét kezelése.<br /><br />A <b>Nem</b> azt jelenti, hogy az élő személyek adatait az összes a regisztrált felhasználó láthatja.<br />Az <b>Igen</b> azt jelenti, hogy a felhasználók csak azoknak az élő személyeknek a privát adatait láthatják, akikkel rokonságban állnak.<br /><br />";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]	= "~#pgv_lang[MAX_RELATION_PATH_LENGTH]#~<br /><br />A rokonsági fok maximális nagysága.<br /><br />A másodfokú unokatestvérek kezelése.<br /><br />";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]	= "~#pgv_lang[CHECK_MARRIAGE_RELATIONS]#~<br /><br />Házastársi kapcsolatok ellenőrzése.<br /><br />A rokonság ellenőrzése a házastársi kapcsolatok alapján.<br /><br />";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]		= "~#pgv_lang[SHOW_DEAD_PEOPLE]#~<br /><br />Elhunyt személyek megmutatása.<br /><br />";
$pgv_lang["select_privacyfile_button"]		= "Diszkrét adatkezelési állomány kiválasztása";
$pgv_lang["PRIVACY_BY_YEAR"]            	= "Egy esemény diszkréciós szabályozása életkor alapján.";
$pgv_lang["PRIVACY_BY_YEAR_help"]       	= "~#pgv_lang[PRIVACY_BY_YEAR]#~<br /><br /><b>Az esemény diszkréciós szabályozása életkor alapján</b> lehetőséget ad arra, hogy Ön a személyekt adatait életkoruk alapján rejtse el - függetlenül attól, hogy élnek-e vagy már meghaltak. Hazsnálja ezt a lehetőséget a \"AAz életkor, mely után az adott személy feltehetően már nem él\" beállítással. Például ha az utóbbi opciót 100-ra, az előbbit \"igen\"-re állítja, akkor a kevesebb mint 100 éve született személyek adatai bizalmasak lesznek. Így egyben a kevesebb mint 85 éve házasodott és a kevesebb mint 75 éve elhunyt személyek adatai szintén bizalmasnak fognak számítani. Kérjük tartsa szem előtt, hogy ezen beállítás használata csökkenteni fogja a program teljesítményét.<br /><br />";

//-- language edit utility
$pgv_lang["edit_langdiff"]		= "Nyelvi állományok szerkesztése és konfigurációja";
$pgv_lang["bom_check"]          	= "BOM-ellenőrzés a nyelvi állományokban";
$pgv_lang["bom_check_help"]             = "~#pgv_lang[bom_check]#~<br /><br />#pgv_lang[bom_check_desc]#<br />";
$pgv_lang["lang_debug_help"]		= "~#pgv_lang[lang_debug]#~<br /><br />#pgv_lang[lang_debug_desc]#<br />";
$pgv_lang["bom_not_found"]              = "Nem találtunk BOM-ot.";
$pgv_lang["bom_found"]                  = "BOM-ot találtunk: ";
$pgv_lang["edit_lang_utility"]		= "Nyelvi állományok szerkesztése";
$pgv_lang["edit_lang_utility_help"]	= "~#pgv_lang[edit_lang_utility]#~<br /><br />#pgv_lang[edit_lang_utility_desc]#<br />";
$pgv_lang["edit_lang_utility_warning"]	= "FIGYELEM!<br /><br />Ha Ön úgy dönt, hogy a \"<b>#pgv_lang[close_window_without_refresh]#</b>\" gombot használja, a tartalmi változásokat addig nem fogja látni, amíg nem frissíti a lapot. Ezenkívül egyes esetekben így a nyelvi állomány is megsérülhet, ha Ön egy olyan üzenetet szerkeszt, amely eddig nem szerepelt az Ön változatában, vagy amelyet közvetlenül ezelőtt szerkesztett.<br /><br />Tehát ha nem biztos a dolgában, kérjük, hogy ne használja a \"<b>#pgv_lang[close_window_without_refresh]#</b>\" gombot.";
$pgv_lang["language_to_edit"]		= "Szerkesztendő nyelv";
$pgv_lang["file_to_edit"]		= "Szerkesztendő állomány";
$pgv_lang["check"]                      = "Ellenőrzés";
$pgv_lang["lang_save"]			= "Mentés";
$pgv_lang["contents"]			= "Tartalom";
$pgv_lang["listing"]			= "Kilistázva";
$pgv_lang["no_content"]			= "Nincs tartalom";
$pgv_lang["editlang"]			= "Szerkeszt";
$pgv_lang["editlang_help"]		= "~#pgv_lang[editlang]#~<br /><br />Üzenet szerkesztése a következő nyelvi állományban:<br />";
$pgv_lang["savelang"]			= "Mentés";
$pgv_lang["savelang_help"]		= "~#pgv_lang[savelang]#~<br /><br />Szerkesztett szöveg mentése.<br />";
$pgv_lang["original_message"]		= "Eredeti szöveg";
$pgv_lang["message_to_edit"]		= "Szerkesztendő szöveg";
$pgv_lang["changed_message"]		= "A megváltoztatott szöveg";
$pgv_lang["message_empty_warning"]	= "-> Figyelem!!! A(z) [#LANGUAGE_FILE#] állományban ez a változó nem tartalmaz  üzenetet <-";
$pgv_lang["language_to_export"]		= "Exportálandó nyelv";
$pgv_lang["export_lang_utility"]	= "Nyelvi állományok exportálása";
$pgv_lang["export"]			= "Exportálás";
$pgv_lang["export_lang_utility_help"]	= "~#pgv_lang[export_lang_utility]#~<br /><br />#pgv_lang[export_lang_utility_desc]#<br />";
$pgv_lang["export_ok"]			= "A magyarázó szöveg exportálása befejeződött.";
$pgv_lang["compare_lang_utility"]	= "Nyelvi állományokat összehasonlítása";
$pgv_lang["compare_lang_utility_help"]	= "~#pgv_lang[compare_lang_utility]#~<br /><br />#pgv_lang[compare_lang_utility_desc]#<br />";
$pgv_lang["new_language"]		= "Forrás-nyelv";
$pgv_lang["old_language"]		= "Másodlagos-nyelv";
$pgv_lang["compare"]			= "Összevet";
$pgv_lang["comparing"]			= "Az összehasonlított nyelvi állományok";
$pgv_lang["additions"]			= "Bővülések";
$pgv_lang["no_additions"]		= "Nincs bővülés";
$pgv_lang["subtractions"]		= "Hiányok";
$pgv_lang["no_subtractions"]		= "Nincs hiány";
$pgv_lang["config_lang_utility"]	= "A támogatott nyelvek konfigurálása";
$pgv_lang["config_lang_utility_help"]	= "~#pgv_lang[config_lang_utility]#~<br /><br />Ez a modul támogatja Önt a PhpGedView nyelvi beállításainak módosításában.<br /><br />fehívjuk figyelmét arra, hogy amennyiben megváltoztatja a nyelvi beállításokat, egy új állomány (#INDEX_DIRECTORY#lang_settings.php) jön létre az #INDEX_DIRECTORY# könyvtárban. Minden további változtatás ezt az állományt érinti, illetve a PhpGedView is ezt használja.<br />Tehát ha probléma adódik a nyelvi beállításokkal, jelezze, hogy Önnél már ez az új állomány taláható az #INDEX_DIRECTORY# könyvtárban!<br />";
$pgv_lang["active"]			= "Aktív";
$pgv_lang["active_help"]		= "~#pgv_lang[active]#~<br /><br />A felhasználók kiválaszthatják ezt a nyelvet, amennyiben a <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b> engedélyezett.<br />";
$pgv_lang["edit_settings"]		= "Beállítások szerkesztése";
$pgv_lang["lang_edit"]			= "Szerkeszt";
$pgv_lang["lang_language"]		= "Nyelv";
$pgv_lang["export_filename"]		= "A kiexportált adatot tartalmazó fájl neve:";
$pgv_lang["lang_back"]			= "A nyelvi állományok szerkesztéséhez és beállításához lépjen vissza a főmenübe! ";
$pgv_lang["lang_back_admin"]		= "Vissza az Adminisztráció menüjébe";
$pgv_lang["lang_back_manage_gedcoms"]	= "Vissza a GEDCOM-állományok kezelése menüjébe";
$pgv_lang["lang_name_czech"]		= "Cseh";
$pgv_lang["lang_name_chinese"]		= "Kínai";
$pgv_lang["lang_name_danish"]		= "Dán";
$pgv_lang["lang_name_dutch"]		= "Holland";
$pgv_lang["lang_name_english"]		= "Angol";
$pgv_lang["lang_name_finnish"]		= "Finn";
$pgv_lang["lang_name_french"]		= "Francia";
$pgv_lang["lang_name_german"]		= "Német";
$pgv_lang["lang_name_hebrew"]		= "Héber";
$pgv_lang["lang_name_hungarian"]	= "Magyar";
$pgv_lang["lang_name_italian"]		= "Olasz";
$pgv_lang["lang_name_norwegian"]	= "Norvég";
$pgv_lang["lang_name_polish"]		= "Lengyel";
$pgv_lang["lang_name_portuguese"]	= "Portugál";
$pgv_lang["lang_name_russian"]		= "Orosz";
$pgv_lang["lang_name_spanish"]		= "Spanyol";
$pgv_lang["lang_name_spanish-ar"]	= "Latin-amerikai spanyol";
$pgv_lang["lang_name_swedish"]		= "Svéd";
$pgv_lang["lang_name_turkish"]		= "Török";
$pgv_lang["lang_name_greek"]            = "Görög";
$pgv_lang["lang_name_arabic"]           = "Arab";
$pgv_lang["lang_name_lithuanian"]	= "Litván";
$pgv_lang["lang_name_vietnamese"]	= "Vietnám";
$pgv_lang["lang_name_slovak"]		= "Szlovák";
$pgv_lang["lang_new_language"]		= "Új nyelv";
$pgv_lang["original_lang_name"]		= "A nyelv #D_LANGNAME# neve";
$pgv_lang["original_lang_name_help"]	= "Mi a nyelv neve az adott nyelven?<br /><br />Az angol nyelv neve angolul: English<br />A német nyelv neve németül: Deutsch<br />A holland nyelv neve hollandul: Nederlands stb.";
$pgv_lang["lang_shortcut"]		= "Nyelv-specifikus rövidítés";
$pgv_lang["lang_shortcut_help"]		= "~#pgv_lang[lang_shortcut]#~<br /><br />Ez a kód megadja a PhpGedView nyelvi állományaiban használatos nyelv-specifikus rövidítést. Ez rendszerint az első a 'Nyelvi beállítások' kódjai közül (melyek a támogatott nyelvek konfigurálása ablakának következő mezőjében adhatók meg).<br />";
$pgv_lang["lang_langcode"]		= "Nyelvi beállítások kódjai";
$pgv_lang["lang_langcode_help"]		= "~#pgv_lang[lang_langcode]#~<br /><br />Ezen kódok lehetővé teszik, hogy a PhpGedView a böngésző beállításai alapján felismerje az aktuális nyelvet. A kódokat pontosvesszővel kell egymástól elválasztani.<br />";
$pgv_lang["lang_filenames"]		= "Nyelvi állományok";
$pgv_lang["flagsfile"]			= "Nemzeti lobogót ábrázoló kép neve";
$pgv_lang["text_direction"]		= "Szöveg írásának iránya";
$pgv_lang["text_direction_help"]	= "~#pgv_lang[text_direction]#~<br /><br />Megszabja, hogy az adott nyelven milyen irányban írnak.<br /><br />Rendszerint minden nyugati nyelven balról jobbra írják vagy olvassák a szöveget. Ugyanakkor vannak nyelvek, mint pl. az arab vagy a héber, melyen jobbról balra írnak.<br />";
$pgv_lang["date_format"]			= "Dátum formátum";
$pgv_lang["time_format"]		= "Idő-formátum";
$pgv_lang["time_format_help"]		= "~#pgv_lang[time_format]#~<br /><br />Ez a mező definiálja a kiválasztott nyelvhez tartozó dátumformátumot.<br /><br />A változók jelentése a következő:<br />a - kisbetűs délelőtt és délután - 'de' vagy 'du'<br />A - Nagybetűs délelőtt vagy délután - 'DE' vagy 'DU'<br />B - Swatch internet idő - 000-tól 999-ig<br />c - ISO 8601 szabványú dátum (PHP 5-től) - 2004-02-12T15:19:21+00:00<br />d - A hónap napja, 2 számjegy nullákkal kiegészítve - 01-tól 31-ig<br />D - A nap neve kiírva három karakterrel - Mon-tól Sun-ig<br />F - A hónap neve teljesen kiírva, például január vagy március - január-tól december-ig<br />g - Az óra 12-órás formátumban, kezdő nullák nélkül - 1-től 12-ig<br />G - Az óra 24-órás formátumban kezdő nullák nélkül - 0-tól 23-ig<br />h - Az óra 12-órás formátumban kiegészítve kezdő nullákkal - 01-től 12-ig<br />H - Az óra 24-órás formátumban kezdő nullákkal kiegészítve - 00-tól 23-ig<br />i - Percek, kiegészítve kezdő nullákkal - 00-tól 59-ig<br />I - (Nagybetűs i) Whether or not the date is in daylights savings time 1 if Daylight Savings Time, 0 otherwise.<br />j - A hónap napja kezdő nullák nélkül - 1-től 31-ig<br />l - (Kisbetűs 'L') A hét napja teljesen kiírva - Vasárnap-tól Szombat-ig<br />L - Szökőév-e az aktuális - 1 ha igen, egyébként 0.<br />m - A hónap száma kezdő nullákkal kiegészítve - 01-től 12-ig<br />M - A hónap nevének rövídítése három karakterrel - jan-tól dec-ig<br />n - A hónap száma kezdő nullák nélkül - 1-től 12-ig<br />O - A greenwich-i (gmt) időhöz képesti eltolódás órákban, pl.: +0200<br />r - RFC 2822 formátumú dátum, pl.: Csüt, 21 Dec 2000 16:01:07 +0200<br />s - Másodpercek, kezdő nullákkal kiegészítve - 00-tól 59-ig<br />S - A hónap napja angolul rendezett utótaggal, 2 karakterrel [nem tudom van-e értelme] st, nd, rd or th. Jól működik az j-szel<br />t - Az adott hónap napjai száma; azaz <b>28</b> és <b>31</b> között<br />T - Az adott gép időzóna beállítása, pl.: CEST, EST, MDT ...<br />U - Eltelt másodpercek a Unix időszámítástól (Január 1 1970 00:00:00 GMT)<br />w - A hét napja számmal 0 (vasárnap)-tól 6 (szombat)-ig<br />W - ISO-8601 szabvány szerinti hét száma az évnek, úgy hogy a hetek hétfővel kezdődnek (PHP 4.1.0 -tól) l.: 42 (a 42. hete az évnek)<br />Y - A teljes év számjegyekkel kiírva 4 karakterrel, pl.: 1999 vagy 2003<br />y - Az évszám két karakterrel írva pl.: 99 vagy 03<br />z - A nap sorszáma az évben (0-val kezdve) 0-tól 365-ig<br />Z - Időzóna eltolódás másodpercben. Az UTC-től nyugatra levő időzónákban az eltérés mindig negatív, keletre pedig mindig pozitív. -43200-tól 43200-ig<br /><br />Ezeknek a változóknak a sorrendje tetszőlegesen felcserélhető, és elválasztójelek is tehetők közéjük.<br />Például a német dátumot ez a mező így prezentálja: 'H:i:s' , ami pedig így jelenik meg: '09:01:25'.<br />Az angol standard ilyen: 'g:i:sa' ami pedig eztmutatja: '9:01:25am'.<br />";
$pgv_lang["week_start"]			= "A hét kezdőnapja";
$pgv_lang["week_start_help"]		= "~#pgv_lang[week_start]#~<br /><br />A hét kezdőnapja az adot nyelven. A legtöbb nyelvben a hét vasárnappal kezdődik, néhány esetben viszont hétfővel illetve más napokkal.<br />";
$pgv_lang["name_reverse"]		= "Vezetéknév előre";
$pgv_lang["name_reverse_help"]		= "~#pgv_lang[name_reverse]#~<br /><br />Bizonyos nyelveken a vezetéknevet kell először megjeleníteni - szemben az alapértelmezett beállítással. Ön ezen opción keresztül engedélyezheti ezt az írásmódot.<br />";
$pgv_lang["ltr"]			= "Balról jobbra";
$pgv_lang["rtl"]			= "Jobbról balra";
$pgv_lang["file_does_not_exist"]	= "HIBA! Az állomány nem létezik...";
$pgv_lang["alphabet_upper"]		= "Nagybetűs ábécé";
$pgv_lang["alphabet_upper_help"]	= "~#pgv_lang[alphabet_upper]#~<br /><br />Az adott nyelv nagybetűs ábécéje, mely a nagybetűs nevek sorbarendezését segíti a PhpGedView-listákon.<br />";
$pgv_lang["alphabet_lower"]		= "Kisbetűs ábécé";
$pgv_lang["alphabet_lower_help"]	= "~#pgv_lang[alphabet_lower]#~<br /><br />Az adott nyelv kisbetűs ábécéje, mely a kisbetűs nevek sorbarendezését segíti a PhpGedView-listákon.<br />";
$pgv_lang["lang_config_write_error"]	= "Hiba történt a [language_settings.php] állományba való írás során. Kérjük, ellenőrizze a jogosultságokat és próbálja meg még egyszer!";
$pgv_lang["translation_forum"]		= "Ugrás a PhpGedView fordítói fórumához (a SourceForge.net-en)";
$pgv_lang["translation_forum_help"]	= "~#pgv_lang[translation_forum]#~<br /><br />#pgv_lang[translation_forum_desc]#<br />";
$pgv_lang["lang_set_file_read_error"]	= "HIBA!!! A <b>language_settings.php</b> nem olvasható!";
$pgv_lang["add_new_language_help"]	= "~#pgv_lang[add_new_language]#~<br /><br />#pgv_lang[add_new_language_desc]#";
$pgv_lang["add_new_lang_button"]	= "Új nyelv hozzáadása";
$pgv_lang["hide_translated"]		= "Lefordított üzenetek elrejtése";
$pgv_lang["lang_file_write_error"]	= "HIBA!!!<br /><br />A változásokat nem tudtuk rögzíteni a kiválasztott nyelvi állományba!<br />Kérjük, hogy ellenőrizze a(z) (#lang_filename#) írási jogosultságát!";
$pgv_lang["no_open"]    = "HIBA!!!<br /><br />A(z) #lang_filename# állományt nem tudjuk megnyitni!";
$pgv_lang["configured_languages"]	= "Használt nyelvek";

//-- User Migration Tool messages
$pgv_lang["um_header"] 			= "Felhasználói adat migrációs eszköz";
$pgv_lang["um_proceed"] 		= "Végrehajtsuk az exportálást a felhasználói adatállományokból?<br /><br />";
$pgv_lang["um_creating"] 		= "Létrehozás";
$pgv_lang["um_file_create_fail1"] 	= "Az új állományt nem hozható létre, ezen a néven már létezik egy állomány:";
$pgv_lang["um_file_create_fail2"] 	= "Nem hozható létre";
$pgv_lang["um_file_create_fail3"] 	= "Kérjük, ellenőrizze a könyvtár jogosultságait!";
$pgv_lang["um_file_create_succ1"] 	= "Az új állomány sikeresen létrejött:";
$pgv_lang["um_file_not_created"] 	= "Az állomány nem jött létre.";
$pgv_lang["um_nomsg"] 			= "A rendszerben nem tárolunk üzeneteket.";
$pgv_lang["um_nofav"] 			= "A rendszerben nem tárolunk  kedvenceket.";
$pgv_lang["um_nonews"] 			= "A rendszerben nem tárolunk híreket.";
$pgv_lang["um_noblocks"] 		= "A rendszerben nem tárolunk blokkokat.";
$pgv_lang["um_imp_blocks"] 		= "Blokkok importálása";
$pgv_lang["um_imp_messages"] 		= "Üzenetek importálása";
$pgv_lang["um_imp_news"] 		= "Hírek importálása";
$pgv_lang["um_imp_succ"] 		= "Importálás sikeresen történt";
$pgv_lang["um_imp_fail"] 		= "Az importálás sikertelen volt";
$pgv_lang["um_backup"] 			= "Biztonsági mentés";
$pgv_lang["um_bu_help"] 		= "~#pgv_lang[um_backup]#~<br /><br />#pgv_lang[um_bu_explain]#";
$pgv_lang["um_bu_config"] 		= "PhpGedView konfigurációs állománya";
$pgv_lang["um_imp_favorites"] 		= "Kedvencek importálása";
$pgv_lang["um_imp_users"] 		= "Felhasználok importálása";
$pgv_lang["um_export"] 			= "Export";
$pgv_lang["um_tool_help"] 		= "~#pgv_lang[um_header]#~<br /><br />#pgv_lang[um_explain]#";
$pgv_lang["um_import"] 			= "Import";
$pgv_lang["um_bu_gedcoms"] 		= "GEDCOM állományok";
$pgv_lang["um_results"]			= "Eredmények";
$pgv_lang["add_faq_item"] 		= "GYIK elem hozzáadása";
$pgv_lang["edit_faq_item"] 		= "GYIK elem szerkesztése";
$pgv_lang["delete_faq_item"] 		= "GYIK elem törlése";
$pgv_lang["INDI_FACTS_ADD"] 			= "Személyhez tények hozzáadása";
$pgv_lang["INDI_FACTS_ADD_help"]		= "~#pgv_lang[INDI_FACTS_ADD]#~<br /><br />Ez a GEDCOM tények listája amit a felhasználók hozzáadhatnak a személyekhez. A Listát meg lehet változtatni ugy hogy elvesz vagy hozzáad egy tény nevet, még egyedülálló tényeket is, ha szükséges. A tény nevek amik ebben a listában láthatók, nem muszáj a <i>#pgv_lang[INDI_FACTS_UNIQUE]#</i> listában is lennie.<br />";
$pgv_lang["INDI_FACTS_UNIQUE"] 			= "Személy egyedülálló tényei";
$pgv_lang["INDI_FACTS_UNIQUE_help"]		= "~#pgv_lang[INDI_FACTS_UNIQUE]#~<br /><br />Ez a GEDCOM tények listája amit a felhasználók <u>csak egyszer</u> adhatnak hozzá egy személyhez. Például, ha a születés (BIRT) a listában van, a felhasználók nem tudják a listához megint hozzáadni a születés (BIRT) adatot a személyhez. Tények neve ami a listában szerepel nem muszáj a <i>#pgv_lang[INDI_FACTS_ADD]#</i> listában is szerepelnie.<br />";
$pgv_lang["FAM_FACTS_ADD"] 			= "Családhoz tények hozzáadása";
$pgv_lang["FAM_FACTS_ADD_help"]			= "~#pgv_lang[FAM_FACTS_ADD]#~<br /><br />Ez a GEDCOM tények listája amit a felhasználók hozzáadhatnak egy családhoz. A Listát meg lehet változtatni ugy hogy elvesz vagy hozzáad egy tény nevet, még egyedülálló tényeket is, ha szükséges. A tény nevek amik ebben a listában láthatók, nem muszáj a  <i>#pgv_lang[FAM_FACTS_UNIQUE]#</i> listában is lennie.<br />";
$pgv_lang["FAM_FACTS_UNIQUE"] 			= "Család egyedülálló tényei";
$pgv_lang["FAM_FACTS_UNIQUE_help"]		= "~#pgv_lang[FAM_FACTS_UNIQUE]#~<br /><br />Ez a GEDCOM tények listája amit a felhasználók <u>csak egyszer</u> adhatnak hozzá egy családhoz. Például, ha a házasság (MARR) a listában van, a felhasználók nem tudják a listához megint hozzáadni a házasság (MARR) adatot a családhoz. Tények neve ami a listában szerepel nem muszáj a <i>#pgv_lang[FAM_FACTS_ADD]#</i> listában is szerepelnie.<br />";
$pgv_lang["SOUR_FACTS_ADD"] 			= "Forráshoz tények hozzáadása";
$pgv_lang["SOUR_FACTS_ADD_help"]		= "~#pgv_lang[SOUR_FACTS_ADD]#~<br /><br />Ez a GEDCOM tények listája amit a felhasználók hozzáadhatnak egy forráshoz. A Listát meg lehet változtatni ugy hogy elvesz vagy hozzáad egy tény nevet, még egyedülálló tényeket is, ha szükséges. A tény nevek amik ebben a listában láthatók, nem muszáj a <i>#pgv_lang[SOUR_FACTS_UNIQUE]#</i> listában is lennie.<br />";
$pgv_lang["SOUR_FACTS_UNIQUE"] 			= "Forrás egyedülálló tényei";
$pgv_lang["SOUR_FACTS_UNIQUE_help"]		= "~#pgv_lang[SOUR_FACTS_UNIQUE]#~<br /><br />Ez a GEDCOM tények listája amit a felhasználók <u>csak egyszer</u> adhatnak hozzá egy forráshoz. Például, ha a cím (TITL) a listában van, a felhasználók nem tudják a listához megint hozzáadni a cím (TITL) adatot a forráshoz. Tények neve ami a listában szerepel nem muszáj a <i>#pgv_lang[SOUR_FACTS_ADD]#</i> listában is szerepelnie.<br />";
$pgv_lang["REPO_FACTS_ADD"] 			= "Szervezethez tények hozzáadása";
$pgv_lang["REPO_FACTS_ADD_help"]		= "~#pgv_lang[REPO_FACTS_ADD]#~<br /><br />Ez a GEDCOM tények listája amit a felhasználók hozzáadhatnak egy szervezethez. A Listát meg lehet változtatni ugy hogy elvesz vagy hozzáad egy tény nevet, még egyedülálló tényeket is, ha szükséges. A tény nevek amik ebben a listában láthatók, nem muszáj a <i>#pgv_lang[REPO_FACTS_UNIQUE]#</i> listában is lennie.<br />";
$pgv_lang["REPO_FACTS_UNIQUE"] 			= "Szervezet egyedülálló tényei";
$pgv_lang["REPO_FACTS_UNIQUE_help"]		= "~#pgv_lang[REPO_FACTS_UNIQUE]#~<br /><br />Ez a GEDCOM tények listája amit a felhasználók <u>csak egyszer</u> adhatnak hozzá egy szervezethez. Például, ha a név (NAME) a listában van, a felhasználók nem tudják a listához megint hozzáadni a név (NAME) adatot a szervezethez. Tények neve ami a listában szerepel nem muszáj a <i>#pgv_lang[REPO_FACTS_ADD]#</i> listában is szerepelnie.<br />";
$pgv_lang["LANG_SELECTION_help"]		= "~#pgv_lang[LANG_SELECTION]#~<br /><br />Meg tudja változtatni a támogatott nyelveket a PhpGedView -ban, úgy hogy ki- vagy bepipálja a jelölőnégyzeteket. Ez megengedi a felhasználóknak hogy a megadott nyelvekből választhassanak.<br /><br />Ezt ugyan itt el tudja érni: <b>#pgv_lang[enable_disable_lang]#</b> a #pgv_lang[admin]# menüböl, ahol megváltoztatható pl.: nyelvek zászlója, dátum formátum, vagy hogy a vezetéknév mindig elsőként látszódjon.<br />";
$pgv_lang["MEDIA_ID_PREFIX"]		= "Média-elem azonosító előtag";
$pgv_lang["MEDIA_ID_PREFIX_help"]	= "~#pgv_lang[MEDIA_ID_PREFIX]#~<br /><br />Amikor a PhpGedView weboldalán egy új média elemet regisztrálnak akkor egy új azonosítószám generálódik automatikusan. Ez lesz a média azonosító előtagja.<br />";
$pgv_lang["FAM_ID_PREFIX"]		= "Család azonosító előtag";
$pgv_lang["FAM_ID_PREFIX_help"]	= "~#pgv_lang[FAM_ID_PREFIX]#~<br /><br />Amikor a PhpGedView weboldalán egy új családot regisztrálnak akkor egy új azonosítószám generálódik automatikusan. Ez lesz a család azonosító előtagja.<br />";
$pgv_lang["QUICK_REQUIRED_FAMFACTS"]			= "Családok tényei ami mindig szerepeljen a Gyors Frissítés-en";
$pgv_lang["QUICK_REQUIRED_FAMFACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FAMFACTS]#~<br /><br />Ez egy vesszőkkel elválasztott lista a GEDCOM tényeinek ami mindig fel lesz tüntetve a Gyors Frissítése a családnak oldalán, nem tekintve arra hogy már létezik vagy még nem létezik a személy adataiban. Például, ha a házasság (MARR) a listában van, akkor a házasság dátuma és házasság helyszíne mindig a formulában lesz.<br />";
$pgv_lang["QUICK_ADD_FAMFACTS"]			= "Családok tényei ami szerepeljen a Gyors Frissítés-en";
$pgv_lang["QUICK_ADD_FAMFACTS_help"]		= "~#pgv_lang[QUICK_ADD_FAMFACTS]#~<br /><br /><br /><br />Ez egy vesszőkkel elválasztott lista a GEDCOM tényeinek ami fel lesz tüntetve a Gyors Frissítése a családnak oldalán. Csak a listában szerepelt tények láthatóak amiből választani lehet hogy milyen tényt adhat hozzá.<br />";
$pgv_lang["QUICK_REQUIRED_FACTS"]			= "Tények ami mindig szerepeljen a Gyors Frissítés-en";
$pgv_lang["QUICK_REQUIRED_FACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FACTS]#~<br /><br />Ez egy vesszökkel elválasztott lista a GEDCOM tényeiből amik mindig szerepelnek a Gyors Frissítés oldalon, eltekintve hogy már létezik vagy még nem a személy adataiban. Például, ha a születés (BIRT) a listában van, akkor a mező a születési dátum és a helyszíne mindig látszani fog az oldalon.<br />";
$pgv_lang["QUICK_ADD_FACTS"]			= "Tények ami szerepeljen a Gyors Frissítésen";
$pgv_lang["QUICK_ADD_FACTS_help"]		= "~#pgv_lang[QUICK_ADD_FACTS]#~<br /><br />Ez egy vesszőkkel elválasztott lista a GEDCOM tényeiből ami fel lesz tüntetve a Gyors Frissités oldalon. Csak a listában szerepelt tények láthatóak amiből választani lehet hogy milyen tényt adhat hozzá.<br />";
$pgv_lang["AUTO_GENERATE_THUMBS"]			= "Automatikusan generált előnézet képek";
$pgv_lang["AUTO_GENERATE_THUMBS_help"]		= "~#pgv_lang[AUTO_GENERATE_THUMBS]#~<br /><br />A rendszer automatikus generáljon előnézet képeket amelyik fényképnek még nincs. Az ön PHP telepítése lehet hogy nem támogatja ezt a funkciót.<br />";
$pgv_lang["phpinfo_help"]				= "~#pgv_lang[phpinfo]#~<br /><br />Ez az oldal részletes információkat mutat a szerverről ahova a PhpGedView telepítve lett. Konfiguráció részletek a szerver szoftverjéről, ahogy a PHP-hez és a PhpGedView -hoz kapcsolódik, itt tekinthető meg.<br />";
$pgv_lang["config_help_help"]			= "~#pgv_lang[config_help]#~<br /><br />Ez az oldal összefoglalja nagyobb vonalakban a Konfiguráció Segitség -hez tartozó információkat. Az információ megtekinthető a képernyőn vagy elmenthető későbbi használathoz is.<br />";
$pgv_lang["more_help_advice"]			= "<br /><b>Részletes segítség</b><br />Részletes segítség kapható, ha az elem melletti <b>?</b> -re kattint.<br />";
$pgv_lang["THUMBNAIL_WIDTH"]			= "Generált előnézeti képek szélessége";
$pgv_lang["THUMBNAIL_WIDTH_help"]		= "~#pgv_lang[THUMBNAIL_WIDTH]#~<br /><br />Ez a szélesség (pixelben) amit a program használni fog amikor automatikusan elönézeti képeket generál. Az alap beállítás 100.<br />";
$pgv_lang["SHOW_SOURCES"]			= "Források mutatása";
$pgv_lang["SHOW_SOURCES_help"]		= "~#pgv_lang[SHOW_SOURCES]#~<br /><br />Beállítása a bizalmas hozzáférési jogosultságnak az összes Forrásnak. Ha a felhasználónak nincs jogosultsága a Forrásokhoz akkor a Listák menüjéből a Források Listája és a személyek adatainál a Források oldala nem láthatók.<br />";
$pgv_lang["GEDCOM_DEFAULT_TAB"]			= "Alapoldal mutatása a személyek oldalán";
$pgv_lang["GEDCOM_DEFAULT_TAB_help"]	= "~#pgv_lang[GEDCOM_DEFAULT_TAB]#~<br /><br />Ez az opció beállítja hogy melyik oldalt mutassa automatikusan amikor a személyek adatai oldalát látogatják.";
$pgv_lang["index_gedcom_news_adm_help"]		= "A GEDCOM Hírek blokkja lehetővé teszi <b>HTML-kódok</b> használatát.<br />Kérjük, ügyeljen a nyitó- és záróelemek következetes használatára. <br />Ez esetben szükséges lehet a HTML-nyelv megfelelő szintű ismerete. <br /><br />Ez a program emellett <b>stíluslapokat (CSS)</b> is használ, mely az asztaltémáknak megfelelően eltérő.<br />Ön természetesen ezeket a stílusdefiníciókat is használhatja.<br /><br />Ha bővebb információra van szüksége, a PhpGedView weboldalán bemutatunk néhány példát, hogyan használjon stíluslap-elemeket a GEDCOM Hírek blokkjában.<br />";
$pgv_lang["file_to_edit_help"]			= "~#pgv_lang[file_to_edit]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["lang_filenames_help"]		= "~#pgv_lang[lang_filenames]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
?>
