<?php
/**
 * Dutch Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2022  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @package PhpGedView
 * @subpackage Languages
 * @authors Erik Bent, Jans B. Luder, Boudewijn Sjouke, Eduard Wustenveld
 * @version $Id: configure_help.nl.php 7328 2022-01-12 18:30:53Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["google_analytics_help"]			= "~#pgv_lang[google_analytics]#~<br /><br />De #pgv_lang[google_analytics]# service wordt beschreven in dit <a href='https://nl.wikipedia.org/wiki/Google_Analytics' target='_blank' title='Google Analytics'>Wikipedia-artikel</a>.<br /><br />Houd er rekening mee dat als u ervoor kiest om deze service te gebruiken, Google de rechten verwerft op alle gegevens die het verzamelt over bezoekersactiviteit op uw site.";
$pgv_lang["USE_GOOGLE_ANALYTICS_help"]		= "~#pgv_lang[USE_GOOGLE_ANALYTICS]#~<br /><br />Selecteer <b>#pgv_lang[yes]#</b> om het volgen van activiteit op uw site door de #pgv_lang[google_analytics]# service in te schakelen. U moet zich op deze service abonneren voordat u deze optie inschakelt.";
$pgv_lang["PGV_GOOGLE_ANALYTICS_help"]		= "~#pgv_lang[PGV_GOOGLE_ANALYTICS]#~<br /><br /> Voer het accountnummer in dat aan uw site is toegewezen toen u zich abonneerde op de #pgv_lang[google_analytics]# service. Dit accountnummer heeft het formaat <b>UA-xxxxxx-x</b>.";
$pgv_lang["piwik_analytics_help"]			= "~#pgv_lang[piwik_analytics]#~<br /><br />Het open-sourceproject #pgv_lang[piwik_analytics], oorspronkelijk «Piwik» genaamd, wordt <a href='https://matomo.org/' target='_blank' title='Matomo officiële website'>hier</a> in het Engels beschreven.<br /><br />Matomo is een alternatief voor #pgv_lang[google_analytics]# dat veel van de privacyproblemen wegneemt. U kunt de Matomo-applicatie op uw eigen webserver of in uw eigen domein installeren, zodat u volledige controle heeft over de activiteitsgegevens die zijn verzameld.";
$pgv_lang["USE_PIWIK_ANALYTICS_help"]		= "~#pgv_lang[USE_PIWIK_ANALYTICS]#~<br /><br />Selecteer <b>#pgv_lang[yes]#</b> om het volgen van activiteit op uw site door een #pgv_lang[piwik_analytics]# server in te schakelen. Uw PhpGedView-site moet geregistreerd zijn op een Matomo-server.";
$pgv_lang["PGV_PIWIK_URL_help"]				= "~#pgv_lang[PGV_PIWIK_URL]#~<br /><br />Voer de URL in naar een Matomo-server waarop uw PhpGedView-site is geregistreerd.";
$pgv_lang["PGV_PIWIK_SITE_help"]			= "~#pgv_lang[PGV_PIWIK_SITE]#~<br /><br />Voer het sitenummer in dat door de Matomo-server aan uw PhpGedView-site is toegewezen.";
$pgv_lang["clustrmaps_analytics_help"]		= "~#pgv_lang[clustrmaps_analytics]#~<br /><br />#pgv_lang[clustrmaps_analytics]# is een gecombineerde hit-teller, bezoeker-tracker en geografische visualisatietool.<br /><br />Elke pagina bevat een miniatuurkaartafbeelding gegenereerd door #pgv_lang[clustrmaps_analytics]#. Wanneer die afbeelding wordt geladen, wordt een teller op de #pgv_lang[clustrmaps_analytics]#-site opgehoogd. Wanneer de kaart, die zichtbaar is voor al uw bezoekers, wordt bijgewerkt (dagelijks, wekelijks of maandelijks, afhankelijk van uw verkeer), worden de locaties van alle bezoekers van uw pagina weergegeven sinds het begin van een bepaald tijdsinterval.<br /><br />Als je voor de #pgv_lang[clustrmaps_analytics]# service hebt betaald, kun je door op die miniatuurkaart te klikken een grotere wereldkaart weergeven.<br /><br />Meer details zijn in het Engels beschikbaar op de <a href='http://www.clustrmaps.com/' target='_blank' title='#pgv_lang[clustrmaps_analytics]#-site'>#pgv_lang[clustrmaps_analytics]#-site</a>.";
$pgv_lang["USE_CLUSTRMAPS_ANALYTICS_help"]	= "~#pgv_lang[USE_CLUSTRMAPS_ANALYTICS]#~<br /><br />Selecteer <b>#pgv_lang[yes]#</b> om het volgen van activiteit op uw site door een #pgv_lang[clustrmaps_analytics]# server in te schakelen.";
$pgv_lang["PGV_CLUSTRMAPS_SITE_help"]		= "~#pgv_lang[PGV_CLUSTRMAPS_SITE]#~<br /><br />Voer de URL van uw PhpGedView-site in. Deze waarde is voor u ingevuld en u hoeft deze normaal niet te wijzigen.";
$pgv_lang["PGV_CLUSTRMAPS_SERVER_help"]		= "~#pgv_lang[PGV_CLUSTRMAPS_SERVER]#~<br /><br />Voer het servernummer in dat is toegewezen door de #pgv_lang[clustrmaps_analytics]# service toen u uw account activeerde.";

$pgv_lang["SHOW_LIST_PLACES"]	= "Aantal plaatsniveaus dat op lijsten moet worden weergegeven";
$pgv_lang["SHOW_LIST_PLACES_help"]	= "~#pgv_lang[SHOW_LIST_PLACES]#~<br /><br />Dit bepaalt hoeveel van de plaatsinformatie wordt weergegeven in de plaatsvelden op lijsten.<br /><br />Als u de waarde instelt op <b>9</b>, zorgt u ervoor dat alle plaatsinformatie wordt weergegeven. Als u de waarde instelt op <b>0</b> (nul), worden plaatsen volledig verborgen. Als u de waarde instelt op <b>1</b>, wordt het hoogste niveau weergegeven, normaal gesproken het land. Als u dit instelt op <b>2</b>, worden de bovenste twee niveaus weergegeven. Het tweede hoogste niveau, onder het land, is vaak de staat, provincie of territorium. Enz.";

$pgv_lang["new_gedcom_title"]		= "Genealogie van #GEDCOMFILE#";
$pgv_lang["keep_media_help"]		= "~#pgv_lang[keep_media]#~<br /><br />Moeten bestaande mediakoppelingen in de database worden behouden wanneer een vervangende GEDCOM wordt geüpload. De optie <b>#pgv_lang[no]#</b> verwijdert bestaande medialinks uit de database, terwijl de optie <b>#pgv_lang[yes]#</b> ze behoudt.<br /><br />Deze optie is handig wanneer u uw GEDCOM exporteert vanuit PhpGedView naar een offline GEDCOM-onderhoudsprogramma dat de ingesloten mediakoppelingen niet correct verwerkt, en vervolgens de gewijzigde GEDCOM in PhpGedView opnieuw importeert. Onder dergelijke omstandigheden worden de mediabestanden in de GEDCOM die u naar uw offline bewerkingsprogramma hebt geëxporteerd, vernietigd en zou u al uw mediabestanden opnieuw moeten koppelen aan de juiste persoons-, familie- en bronrecords nadat u deze opnieuw hebt geïmporteerd. de GEDCOM in PhpGedView.<br /><br />De <b>#pgv_lang[yes]#</b> optie vertelt PhpGedView om de bestaande medialinks te behouden, zodat je ze niet opnieuw hoeft aan te maken na het importeren de gewijzigde GEDCOM, maar dit vereist dat het offline bewerkingsprogramma altijd dezelfde persoons-, familie- en bronidentificatienummers produceert.<br /><br /><i>Family Tree Maker</i> is een van de bewerkingsprogramma's die <u>niet</u> correct omgaan met media-object-verwijzingen binnen de GEDCOM. <i>Legacy</i>, en vele andere, behandelt deze correct.";
$pgv_lang["USE_MEDIA_VIEWER"]			= "Gebruik media-viewer";
$pgv_lang["USE_MEDIA_VIEWER_help"]		= "~#pgv_lang[USE_MEDIA_VIEWER]#~<br /><br />Als deze optie <b>#pgv_lang[yes]#</b> is, zal het klikken op afbeeldingen de Media Viewer-pagina produceren. Deze pagina toont de details van de afbeelding. Als u voldoende rechten heeft, kunt u deze details ook bewerken.<br /><br />Als deze optie <b>#pgv_lang[no]#</b> is, zal het klikken op afbeeldingen een afbeelding op volledige grootte produceren in een nieuw venster.";
$pgv_lang["USE_MEDIA_FIREWALL"]			= "Gebruik media-firewall";
$pgv_lang["USE_MEDIA_FIREWALL_help"]	= "~#pgv_lang[USE_MEDIA_FIREWALL]#~<br /><br />Zie de Wiki voor een beschrijving van het gebruik van de media-firewall. <a href=\"#PGV_PHPGEDVIEW_WIKI#/en/index.php?title=Media_Firewall\" target=\"_blank\">#PGV_PHPGEDVIEW_WIKI#</a>";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR"]			= "Basismap van de media-firewall";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_help"]	= "~#pgv_lang[MEDIA_FIREWALL_ROOTDIR]#~<br /><br />Map waarin de beveiligde mediamap kan worden gemaakt.  #pgv_lang[MEDIA_FIREWALL_ROOTDIR_note]#";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_note"]	= "Als dit veld leeg is, wordt de map <b>#GLOBALS[INDEX_DIRECTORY]#</b> gebruikt.";
$pgv_lang["MEDIA_FIREWALL_THUMBS"]			= "Bescherm miniaturen van beschermde afbeeldingen";
$pgv_lang["MEDIA_FIREWALL_THUMBS_help"]	= "~#pgv_lang[MEDIA_FIREWALL_THUMBS]#~<br /><br />Als een afbeelding zich in de beschermde Media-map bevindt, moet de miniatuur dan ook worden beschermd?";
$pgv_lang["SHOW_SPIDER_TAGLINE"]		= "Toon de slogan van de zoekmachine";
$pgv_lang["SHOW_SPIDER_TAGLINE_help"]		= "~#pgv_lang[SHOW_SPIDER_TAGLINE]#~<br /><br />Geef op pagina's die voor zoekmachines zijn gegenereerd, als laatste regel de specifieke zoekmachine weer die de pagina heeft gedetecteerd. Als deze optie is ingeschakeld, kan dit Google&reg; AdSense richting tools voor zoekmachineoptimalisatie.";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS_help"] = "~#pgv_lang[SHOW_PRIVATE_RELATIONSHIPS]#~<br /><br />Met deze optie blijven familiebanden in geprivatiseerde archieven behouden. Dit betekent dat u lege «#pgv_lang[private]#» boxen zult zien op de stamboomkaart en op andere kaarten met privépersonen.<br /><br />Deze instelling is standaard uitgeschakeld. Het wordt aanbevolen om in plaats van dit aan te zetten, uw stamboom-stampersoon in uw GEDCOM-configuratie te verwijzen naar een persoon die niet privé is.";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS"]	= "Toon privé-relaties";
$pgv_lang["SYNC_GEDCOM_FILE_help"] 			= "~#pgv_lang[SYNC_GEDCOM_FILE]#~<br /><br />Als u deze waarde instelt op <b>#pgv_lang[yes]#</b>, wordt het GEDCOM-bestand automatisch bijgewerkt wanneer wijzigingen in de database worden geaccepteerd. Dit zorgt ervoor dat het GEDCOM-bestand gesynchroniseerd blijft met de database.<br /><br />Misschien wil je het veranderen in <b>#pgv_lang[no]#</b> om de snelheid van het programma te verbeteren en geheugen te besparen bij het accepteren van wijzigingen.";
$pgv_lang["SYNC_GEDCOM_FILE"]			= "Synchroniseer bewerkingen in het GEDCOM-bestand";
$pgv_lang["SHOW_MULTISITE_SEARCH_help"]	= "~#pgv_lang[SHOW_MULTISITE_SEARCH]#~<br /><br />Met zoeken op meerdere sites kunnen gebruikers zoeken op meerdere PhpGedView-websites die u hebt ingesteld in het beheergedeelte van Sites beheren of waarmee u op afstand bent gelinkt. Deze optie bepaalt of de functie Zoeken op meerdere sites voor iedereen beschikbaar is of alleen voor geauthenticeerde gebruikers.";
$pgv_lang["SHOW_MULTISITE_SEARCH"]		= "Toon zoeken op meerdere sites";
$pgv_lang["SHOW_NO_WATERMARK"]			= "Wie kan afbeeldingen zonder watermerk bekijken?";
$pgv_lang["SHOW_NO_WATERMARK_help"]		= "~#pgv_lang[SHOW_NO_WATERMARK]#~<br /><br />Als de media-firewall is ingeschakeld, zien gebruikers watermerken als ze niet over het hier opgegeven bevoegdheidsniveau beschikken.";
$pgv_lang["WATERMARK_THUMB"]			= "Watermerken toevoegen aan miniaturen?";
$pgv_lang["WATERMARK_THUMB_help"]		= "~#pgv_lang[WATERMARK_THUMB]#~<br /><br />Als de media-firewall is ingeschakeld, moeten miniaturen dan worden voorzien van een watermerk? Uw medialijsten worden sneller geladen als u de miniaturen geen watermerk geeft.";
$pgv_lang["SAVE_WATERMARK_THUMB"]		= "Miniaturen met watermerk op de server opslaan?";
$pgv_lang["SAVE_WATERMARK_THUMB_help"]	= "~#pgv_lang[SAVE_WATERMARK_THUMB]#~<br /><br />Als de media-firewall is ingeschakeld, moeten dan kopieën van miniaturen met watermerk op de server worden opgeslagen naast dezelfde miniaturen zonder watermerken?<br /><br />Indien ingesteld op <b>#pgv_lang[yes]#</b> , zullen medialijsten met miniaturen met een watermerk sneller worden geproduceerd, ten koste van de hogere schijfruimte op de server.";
$pgv_lang["SAVE_WATERMARK_IMAGE"]		= "Afbeeldingen met watermerk op volledige grootte op de server opslaan?";
$pgv_lang["SAVE_WATERMARK_IMAGE_help"]	= "~#pgv_lang[SAVE_WATERMARK_IMAGE]#~<br /><br />Als de media-firewall is ingeschakeld, moeten er dan kopieën van afbeeldingen op volledige grootte met watermerk op de server worden opgeslagen naast dezelfde afbeeldingen zonder watermerken?<br /><br />Indien ingesteld op <b>#pgv_lang[yes]#</b> zullen afbeeldingen met een watermerk op volledige grootte sneller worden geproduceerd ten koste van hogere schijfruimte-eisen op de server.";
$pgv_lang["DB_UTF8_COLLATION"]			= "Gebruik de database om UTF-8-sortering op te geven";
$pgv_lang["DB_UTF8_COLLATION_help"]		= "Bepaalt of PhpGedView de ingebouwde sorteer- en sorteerfaciliteiten van de database moet gebruiken. Het is over het algemeen sneller om de database te gebruiken om gegevens te sorteren en te filteren in plaats van PHP, hoewel niet alle databases / versies deze functie bieden. De sorteervolgorde die voor elke taal wordt gebruikt, wordt ingesteld op de instellingenpagina van die taal.<br /><br /><span class=\"warning\"> BELANGRIJK: Stel deze waarde alleen in op YES als u dit doet VOORDAT de database tabellen worden voor het eerst gemaakt. Als u het selecteert in een bestaande database, kunnen uw gegevens beschadigd raken.</span><br /><br />MySQL en PostgreSQL bieden beide goede ondersteuning voor UTF-8, hoewel niet alle sorteervolgordes beschikbaar zijn in eerdere versies van MySQL . Andere databases bieden weinig of geen ondersteuning voor UTF-8. Als u niet zeker weet of uw database UTF-8 ondersteunt, moet u deze waarde instellen op <b>#pgv_lang[no]#</b>.<br /><br />Deze <a href='https://nl.wikipedia.org/wiki/UTF-8' target='_blank' title='Wikipedia-artikel'><b>Wikipedia-artikel</b></a> bevat uitgebreide informatie en links over UTF-8.";
$pgv_lang["INDI_FACTS_ADD"] 			= "Voeg feiten toe aan persoon";
$pgv_lang["INDI_FACTS_ADD_help"]		= "~#pgv_lang[INDI_FACTS_ADD]#~<br /><br />Dit is de lijst met GEDCOM-feiten die uw gebruikers aan personen kunnen toevoegen. U kunt deze lijst wijzigen door zo nodig feitennamen, zelfs aangepaste namen, te verwijderen of toe te voegen. Feitnamen die in deze lijst voorkomen, mogen niet ook voorkomen in de lijst <i>#pgv_lang[INDI_FACTS_UNIQUE]#</i>.";
$pgv_lang["INDI_FACTS_UNIQUE"] 			= "Unieke persoon Feiten";
$pgv_lang["INDI_FACTS_UNIQUE_help"]		= "~#pgv_lang[INDI_FACTS_UNIQUE]#~<br /><br />Dit is de lijst met GEDCOM-feiten die uw gebruikers slechts <u>één keer</u> aan personen kunnen toevoegen. Als BIRT bijvoorbeeld in deze lijst staat, kunnen gebruikers niet meer dan één BIRT-record aan een persoon toevoegen. Feitennamen die in deze lijst voorkomen, mogen niet ook voorkomen in de <i>#pgv_lang[INDI_FACTS_ADD]#</i> lijst.";
$pgv_lang["INDI_FACTS_QUICK"] 			= "Snelle persoonsfeiten";
$pgv_lang["INDI_FACTS_QUICK_help"]	= "~#pgv_lang[INDI_FACTS_QUICK]#~<br /><br />Dit is de korte lijst met GEDCOM-persoonsfeiten die naast de volledige lijst verschijnt en met een enkele klik kan worden toegevoegd.";
$pgv_lang["FAM_FACTS_ADD"] 			= "Voeg feiten toe aan familie";
$pgv_lang["FAM_FACTS_ADD_help"]		= "~#pgv_lang[FAM_FACTS_ADD]#~<br /><br />Dit is de lijst met GEDCOM-feiten die uw gebruikers aan families kunnen toevoegen. U kunt deze lijst wijzigen door zo nodig feitnamen te verwijderen of toe te voegen, zelfs aangepaste namen. Feitnamen die in deze lijst voorkomen, mogen niet ook voorkomen in de lijst <i>#pgv_lang[FAM_FACTS_UNIQUE]#</i>.";
$pgv_lang["FAM_FACTS_UNIQUE"] 			= "Unieke familiefeiten";
$pgv_lang["FAM_FACTS_UNIQUE_help"]		= "~#pgv_lang[FAM_FACTS_UNIQUE]#~<br /><br />Dit is de lijst met GEDCOM-feiten die uw gebruikers slechts <u>één keer</u> aan families kunnen toevoegen. Als MARR bijvoorbeeld in deze lijst staat, kunnen gebruikers niet meer dan één MARR-record aan een familie toevoegen. Feitennamen die in deze lijst voorkomen, mogen niet ook voorkomen in de <i>#pgv_lang[FAM_FACTS_ADD]#</i> lijst.";
$pgv_lang["FAM_FACTS_QUICK"] 			= "Snelle familiefeiten";
$pgv_lang["FAM_FACTS_QUICK_help"]	= "~#pgv_lang[FAM_FACTS_QUICK]#~<br /><br />Dit is de korte lijst met feiten over de GEDCOM-familie die naast de volledige lijst verschijnt en met een enkele klik kan worden toegevoegd.";
$pgv_lang["SOUR_FACTS_ADD"] 			= "Voeg feiten toe aan bronnen";
$pgv_lang["SOUR_FACTS_ADD_help"]		= "~#pgv_lang[SOUR_FACTS_ADD]#~<br /><br />Dit is de lijst met GEDCOM-feiten die uw gebruikers aan bronnen kunnen toevoegen. U kunt deze lijst wijzigen door zo nodig feitnamen te verwijderen of toe te voegen, zelfs aangepaste namen. Feitnamen die in deze lijst voorkomen, mogen niet ook voorkomen in de lijst <i>#pgv_lang[SOUR_FACTS_UNIQUE]#</i>.";
$pgv_lang["SOUR_FACTS_UNIQUE"] 			= "Unieke bronfeiten";
$pgv_lang["SOUR_FACTS_UNIQUE_help"]		= "~#pgv_lang[SOUR_FACTS_UNIQUE]#~<br /><br />Dit is de lijst met GEDCOM-feiten die uw gebruikers slechts <u>één keer</u> aan bronnen kunnen toevoegen. Als TITL bijvoorbeeld in deze lijst staat, kunnen gebruikers niet meer dan één TITL-record aan een bron toevoegen. Feitnamen die in deze lijst voorkomen, mogen niet ook voorkomen in de lijst <i>#pgv_lang[SOUR_FACTS_ADD]#</i>.";
$pgv_lang["SOUR_FACTS_QUICK"] 			= "Snelle bronfeiten";
$pgv_lang["SOUR_FACTS_QUICK_help"]	= "~#pgv_lang[SOUR_FACTS_QUICK]#~<br /><br />Dit is de korte lijst met GEDCOM-bronfeiten die naast de volledige lijst verschijnt en met een enkele klik kan worden toegevoegd.";
$pgv_lang["REPO_FACTS_ADD"] 			= "Voeg feiten toe aan opslagplaatsen";
$pgv_lang["REPO_FACTS_ADD_help"]		= "~#pgv_lang[REPO_FACTS_ADD]#~<br /><br />Dit is de lijst met GEDCOM-feiten die uw gebruikers aan opslagplaatsen kunnen toevoegen. U kunt deze lijst wijzigen door zo nodig feitnamen te verwijderen of toe te voegen, zelfs aangepaste namen. Feitnamen die in deze lijst voorkomen, mogen niet ook voorkomen in de lijst <i>#pgv_lang[REPO_FACTS_UNIQUE]#</i>.";
$pgv_lang["REPO_FACTS_UNIQUE"] 			= "Unieke opslagplaatsfeiten";
$pgv_lang["REPO_FACTS_UNIQUE_help"]		= "~#pgv_lang[REPO_FACTS_UNIQUE]#~<br /><br />Dit is de lijst met GEDCOM-feiten die uw gebruikers slechts <u>één keer</u> aan opslagplaatsen kunnen toevoegen. Als NAME bijvoorbeeld in deze lijst staat, kunnen gebruikers niet meer dan één NAME-record aan een opslagplaats toevoegen. Feitnamen die in deze lijst voorkomen, mogen niet ook voorkomen in de lijst <i>#pgv_lang[REPO_FACTS_ADD]#</i>.";
$pgv_lang["REPO_FACTS_QUICK"] 			= "Snelle opslagplaatsfeiten";
$pgv_lang["REPO_FACTS_QUICK_help"]	= "~#pgv_lang[REPO_FACTS_QUICK]#~<br /><br />Dit is de korte lijst met GEDCOM-opslagplaatsfeiten die naast de volledige lijst verschijnt en met een enkele klik kan worden toegevoegd.";
$pgv_lang["LANG_SELECTION_help"]		= "~#pgv_lang[LANG_SELECTION]#~<br /><br />U kunt de lijst met talen die door uw PhpGedView-site worden ondersteund, wijzigen door vinkjes toe te voegen of te verwijderen. Dit verandert de taalkeuzes die beschikbaar zijn voor uw gebruikers.<br /><br />U kunt hetzelfde bereiken via de link <b>#pgv_lang[enable_disable_lang]#</b> in het menu #pgv_lang[admin]#, waar u ook dingen kunt wijzigen zoals het vlagpictogram van de taal, de datumnotatie of of de achternaam altijd eerst moet worden afgedrukt.";
$pgv_lang["MEDIA_ID_PREFIX"]		= "Voorvoegsel van media-ID";
$pgv_lang["MEDIA_ID_PREFIX_help"]	= "~#pgv_lang[MEDIA_ID_PREFIX]#~<br /><br />Wanneer een nieuw media-record online wordt toegevoegd in PhpGedView, wordt automatisch een nieuwe ID voor dat medium gegenereerd. De media-ID heeft dit voorvoegsel.";
$pgv_lang["FAM_ID_PREFIX"]		= "Voorvoegsel van familie-ID";
$pgv_lang["FAM_ID_PREFIX_help"]	= "~#pgv_lang[FAM_ID_PREFIX]#~<br /><br />Wanneer een nieuw familierecord online wordt toegevoegd in PhpGedView, wordt automatisch een nieuw ID voor dat gezin gegenereerd. De familie-ID heeft dit voorvoegsel.";
$pgv_lang["QUICK_REQUIRED_FAMFACTS"]			= "Feiten voor gezinnen om altijd te laten zien op het formulier voor snelle updates";
$pgv_lang["QUICK_REQUIRED_FAMFACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FAMFACTS]#~<br /><br />Dit is een lijst met GEDCOM-feiten, gescheiden door komma's, die altijd worden weergegeven op de tabbladen Familie van het formulier Snelle update, ongeacht of ze al in het familiedossier voorkomen. Als MARR bijvoorbeeld in de lijst staat, worden velden voor huwelijksdatum en huwelijksplaats altijd op het formulier weergegeven.";
$pgv_lang["QUICK_ADD_FAMFACTS"]			= "Feiten voor gezinnen om te laten zien op het formulier voor snelle updates";
$pgv_lang["QUICK_ADD_FAMFACTS_help"]		= "~#pgv_lang[QUICK_ADD_FAMFACTS]#~<br /><br />Dit is een lijst met GEDCOM-feiten, gescheiden door komma's, die worden weergegeven op de tabbladen Familie van het formulier Snelle update. Alleen de feiten in deze lijst worden op het formulier getoond of ter selectie ter beschikking gesteld in het gebied waar u nieuwe feiten op het formulier toevoegt.";
$pgv_lang["QUICK_REQUIRED_FACTS"]			= "Feiten die altijd op het formulier voor snelle updates moeten worden weergegeven";
$pgv_lang["QUICK_REQUIRED_FACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FACTS]#~<br /><br />Dit is een lijst met GEDCOM-feiten, gescheiden door komma's, die altijd op het Quick Update-formulier worden weergegeven, ongeacht of ze al in het record van de persoon voorkomen. Als BIRT bijvoorbeeld in de lijst staat, worden velden voor geboortedatum en geboorteplaats altijd op het formulier weergegeven.";
$pgv_lang["QUICK_ADD_FACTS"]			= "Feiten om weer te geven op het formulier Snel bijwerken";
$pgv_lang["QUICK_ADD_FACTS_help"]		= "~#pgv_lang[QUICK_ADD_FACTS]#~<br /><br />Dit is een lijst met GEDCOM-feiten, gescheiden door komma's, die worden weergegeven op het Quick Update-formulier. Alleen de feiten in deze lijst worden op het formulier getoond of ter selectie ter beschikking gesteld in het gebied waar u nieuwe feiten op het formulier toevoegt.";
$pgv_lang["SURNAME_TRADITION_help"] = "~#pgv_lang[SURNAME_TRADITION]#~<br /><br />Wanneer u nieuwe leden aan een gezin toevoegt, kan PhpGedView standaardwaarden voor achternamen leveren op basis van regionaal gebruik.<br /><br /><ul><li>In de <b>vaderlijke</b> traditie delen alle gezinsleden de achternaam van de vader.</li><li>In de <b>Spaanse</b> en <b>Portugese</b> traditie krijgen kinderen van elke ouder een achternaam.</li><li>In de <b>IJslandse</b> traditie krijgen kinderen de voornaam van hun mannelijke ouder als achternaam, met een achtervoegsel dat het geslacht aangeeft.</li><li>In de <b>Poolse</b> traditie delen alle gezinsleden de achternaam van de vader. Bij sommige achternamen geeft het achtervoegsel het geslacht aan. De achtervoegsels <i>ski</i>, <i>cki</i>, en <i>dzki</i> geven mannelijk aan, terwijl de overeenkomstige achtervoegsels <i>ska</i>, <i>cka</i>, en <i>dzka</i> geven vrouw aan.</li></ul>";
$pgv_lang["ADVANCED_NAME_FACTS_help"] = "~#pgv_lang[ADVANCED_NAME_FACTS]#~<br /><br />Dit is een lijst met GEDCOM-feiten, gescheiden door komma's, die worden weergegeven op het formulier voor toevoegen / bewerken van naam. Als u niet-Latijnse alfabetten gebruikt, zoals Hebreeuws, Grieks, Cyrillisch of Arabisch, wilt u misschien tags toevoegen zoals _HEB, ROMN, FONE, enz. Zodat u namen in verschillende alfabetten kunt opslaan.";
$pgv_lang["ADVANCED_PLAC_FACTS_help"] = "~#pgv_lang[ADVANCED_PLAC_FACTS]#~<br /><br />Dit is een lijst met GEDCOM-feiten, gescheiden door komma's, die wordt weergegeven wanneer u plaatsnamen toevoegt of bewerkt. Als u niet-Latijnse alfabetten gebruikt, zoals Hebreeuws, Grieks, Cyrillisch of Arabisch, wilt u misschien tags toevoegen zoals _HEB, ROMN, FONE, enz. Zodat u plaatsnamen in verschillende alfabetten kunt opslaan.";
$pgv_lang["GEONAMES_KEY"]				= "gebruikers-ID in geonames.org";
$pgv_lang["GEONAMES_KEY_help"]			= "~#pgv_lang[GEONAMES_KEY]#~<br /><br />Dit gebruikers-ID is vereist om toegang te krijgen tot de gratis database van geonames.org met geografische namen. Als u geen geldig gebruikers-ID opgeeft, kunt u deze database niet doorzoeken.<br /><br />U kunt een gebruikers-ID voor geonames.org opvragen op het <a href='http://www.geonames.org/login' target='_blank'><b>geonames.org inlogpagina</b></a>.<br /><br />Je ontvangt dan een e-mail met een bevestigingslink en nadat je de e-mail hebt bevestigd, kun je je account inschakelen voor de webservice op <a href='http://www.geonames.org/manageaccount' target='_blank'><b>uw accountpagina</b></a>";
$pgv_lang["GEONAMES_BIAS"]				= "geonames.org landvoorkeur";
$pgv_lang["GEONAMES_BIAS_help"]			= "~#pgv_lang[GEONAMES_BIAS]#~<br /><br />Normaal gesproken presenteert het zoeken in de GeoNames-database de resultaten in alfabetische volgorde, ongeacht het land waarin een plaats zich bevindt. Deze optie geeft aan dat plaatsen in het geselecteerde land bovenaan de resultatenlijst moeten worden vermeld.";
$pgv_lang["GEONAMES_BIAS_no_preference"]= "Geen voorkeur";
$pgv_lang["GEOCODE_KEY"]				= "Google Geocode Server-sleutel";
$pgv_lang["GEOCODE_KEY_help"]			= "~#pgv_lang[GEOCODE_KEY]#~<br /><br />Deze sleutel is vereist om toegang te krijgen tot de gratis Google-database met geografische namen. Als u geen geldige sleutel opgeeft, kunt u deze database niet doorzoeken.<br /><br /> U kunt een sleutel aanvragen via uw <a href='https://developers.google.com/maps/documentation/geocoding/get-api-key' target='_blank'><b>Google Developer Console</b></a>. U kunt deze pagina in een andere taal dan het Engels bekijken door de gewenste taal helemaal onderaan de pagina te kiezen.";
$pgv_lang["AUTO_GENERATE_THUMBS"]			= "Automatisch gegenereerde miniaturen";
$pgv_lang["AUTO_GENERATE_THUMBS_help"]		= "~#pgv_lang[AUTO_GENERATE_THUMBS]#~<br /><br />Moet het systeem automatisch miniaturen genereren voor afbeeldingen die deze niet hebben? Uw PHP-installatie ondersteunt deze functionaliteit mogelijk niet.";
$pgv_lang["phpinfo_help"]				= "~#pgv_lang[phpinfo]#~<br /><br />Deze pagina geeft uitgebreide informatie over de server waarop PhpGedView wordt gehost. Veel configuratiedetails over de serversoftware, in relatie tot PHP en PhpGedView, kunnen worden bekeken.";
$pgv_lang["config_help_help"]			= "~#pgv_lang[config_help]#~<br /><br />Deze pagina verzamelt alle belangrijke onderwerpen van Configuratiehulp op één plek. U kunt de informatie op uw scherm bekijken, of u kunt deze afdrukken voor later gebruik.";
$pgv_lang["more_help_advice"]			= "<b>Meer hulp</b><br />U kunt meer hulp krijgen door op <b>#pgv_lang[qm]#</b> naast items op de pagina te klikken.";
$pgv_lang["THUMBNAIL_WIDTH"]			= "Breedte van gegenereerde miniaturen";
$pgv_lang["THUMBNAIL_WIDTH_help"]		= "~#pgv_lang[THUMBNAIL_WIDTH]#~<br /><br />Dit is de breedte (in pixels) die het programma zal gebruiken bij het automatisch genereren van miniaturen. De standaardinstelling is 100.";
$pgv_lang["USE_SILHOUETTE"]				= "Gebruik silhouetten";
$pgv_lang["USE_SILHOUETTE_help"]		= "~#pgv_lang[USE_SILHOUETTE]#~<br /><br />Gebruik silhouetten als er geen gemarkeerde afbeelding voor die persoon is opgegeven. De gebruikte afbeeldingen zijn specifiek voor het geslacht van de persoon in kwestie.<br /><br /><table><tr><td wrap valign=\"middle\">Deze afbeelding kan worden gebruikt als het geslacht van de persoon onbekend is:</td><td><img src=\"images/silhouette_unknown.gif\" width=\"40\" alt=\"Silhouette image\" title=\"Silhouette image\" /></td></tr></table>";
$pgv_lang["SHOW_SOURCES"]				= "Toon bronnen";
$pgv_lang["SHOW_SOURCES_help"]			= "~#pgv_lang[SHOW_SOURCES]#~<br /><br />Stel het privacytoegangsniveau in voor alle bronnen. Als de gebruiker geen toegang heeft tot Bronnen, wordt de Bronlijst verwijderd uit het menu Lijsten en wordt het tabblad Bronnen niet weergegeven op de pagina <i>#pgv_lang[personal_details]#</i>.";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION_help"]	= "~#pgv_lang[REQUIRE_ADMIN_AUTH_REGISTRATION]#~<br /><br />Als de optie <b>#pgv_lang[USE_REGISTRATION_MODULE]#</b> is ingeschakeld, bepaalt deze instelling of de beheerder de registratie moet goedkeuren.<br /><br />Dit instellen op <b>#pgv_lang[yes]#</b> vereist dat alle nieuwe gebruikers zichzelf eerst verifiëren en vervolgens worden goedgekeurd door een admin voordat ze kunnen inloggen. Met deze instelling op <b>#pgv_lang[no]#</b>, wordt het selectievakje <b>#pgv_lang[verified_by_admin]#</b> automatisch aangevinkt wanneer gebruikers hun account verifiëren, waardoor een onmiddellijke aanmelding daarna mogelijk is zonder admin interventie.";
$pgv_lang["SPLIT_PLACES"]		= "Verdeel plaatsen in de bewerkingsmodus";
$pgv_lang["SPLIT_PLACES_help"]	= "~#pgv_lang[SPLIT_PLACES]#~<br /><br />Stel dit in op <b>#pgv_lang[yes]#</b> om elke plaatsnaam door komma's in subvelden te splitsen voor eenvoudiger bewerken. Voorbeeld :<br /><ol><li>Standaard modus<br /><u>Plaats</u>: Half Moon Bay, San Mateo, California, USA</li><br /><li>Split modus<br /><u>Land</u>: USA<br /><u>Staat</u>: California<br /><u>Provincie</u>: San Mateo<br /><u>Stad</u>: Half Moon Bay</li></ol>";
$pgv_lang["UNDERLINE_NAME_QUOTES"]		= "Onderstreep namen tussen aanhalingstekens";
$pgv_lang["UNDERLINE_NAME_QUOTES_help"]	= "~#pgv_lang[UNDERLINE_NAME_QUOTES]#~<br /><br />Veel programma's plaatsen de voorkeursnaam tussen aanhalingstekens (<b>\"</b>) in de GEDCOM. De gebruikelijke conventie hiervoor is om de voorkeursnaam te onderstrepen. Als u deze optie inschakelt, worden alle namen tussen aanhalingstekens geconverteerd naar &lt;span&gt; met de CSS-klasse \"starredname\".<br /><br />Als de naam in de GEDCOM bijvoorbeeld 1&nbsp;NAME&nbsp;Gustave&nbsp;\"Jean&nbsp;Paul\"&nbsp;Charles&nbsp;/Wilson/ was, zou het inschakelen van deze optie het deel van de naam tussen aanhalingstekens veranderen in lt;span&nbsp;class=\"starredname\"&gt;Jean&nbsp;Paul&lt;/span&gt; voor afdrukdoeleinden. Afhankelijk van andere instellingen zou de browser die naam dan weergeven als <b>Gustave&nbsp;<u>Jean&nbsp;Paul</u>&nbsp;Charles&nbsp;Wilson</b> of <b>Wilson,&nbsp;Gustave&nbsp;<u>Jean&nbsp;Paul</u>&nbsp;Charles</b>";
$pgv_lang["PRIVACY_BY_RESN"]		= "Gebruik GEDCOM (RESN) Privacybeperking";
$pgv_lang["PRIVACY_BY_RESN_help"]	= "~#pgv_lang[PRIVACY_BY_RESN]#~<br /><br />De GEDCOM 5.5.1-specificatie bevat de optie om RESN-tags te gebruiken om privacy-opties in te stellen voor personen en feiten in het GEDCOM-bestand. Door deze optie in te schakelen, wordt het programma verteld om te zoeken naar niveau 1 RESN tags in GEDCOM-records. Niveau 2+ RESN-tags worden automatisch toegepast en worden niet beïnvloed door deze instelling. Merk op dat dit enkele functies van PhpGedView kan vertragen, zoals de personenlijst.";
$pgv_lang["SHOW_LDS_AT_GLANCE"]			= "Toon verordeningscodes van de SLD-kerk in kaartvakken";
$pgv_lang["SHOW_LDS_AT_GLANCE_help"]	= "~#pgv_lang[SHOW_LDS_AT_GLANCE]#~<br /><br />Als u deze optie instelt op <b>#pgv_lang[yes]#</b>, worden statuscodes voor SLD-verordeningen in diagramvakken weergegeven.<ul><li><b>B</b> - Doop</li><li><b>E</b> - Begiftigd</li><li><b>S</b> - Verzegeld aan echtgenoot</li><li><b>P</b> - Verzegeld voor ouders</li></ul>Een persoon die alle verordeningen heeft gedaan, zal <b>BESP</b> achter zijn naam laten afdrukken. Ontbrekende verordeningen worden aangegeven met <b>_</b> in plaats van de bijbehorende lettercode. <b>BE__</b> geeft bijvoorbeeld ontbrekende <b>S</b> en <b>P</b> verordeningen aan.";
$pgv_lang["GEDCOM_DEFAULT_TAB"]			= "Standaardtabblad om te tonen op «Persoonlijke details» pagina";
$pgv_lang["GEDCOM_DEFAULT_TAB_help"]	= "~#pgv_lang[GEDCOM_DEFAULT_TAB]#~<br /><br />Met deze optie kunt u kiezen welk tabblad automatisch wordt geopend op de pagina «Persoonlijke details» wanneer die pagina wordt geopend.";
$pgv_lang["SHOW_MARRIED_NAMES"]			= "Toon gehuwde namen op de personenlijst";
$pgv_lang["SHOW_MARRIED_NAMES_help"]	= "~#pgv_lang[SHOW_MARRIED_NAMES]#~<br /><br />Met deze optie worden de gehuwde namen van vrouwen op de personenlijst weergegeven. Deze optie vereist dat u de gehuwde namen berekent wanneer u het GEDCOM-bestand importeert.";
$pgv_lang["SHOW_QUICK_RESN"]		= "Toon privacyvelden op #pgv_lang[quick_update_title]# formulier";
$pgv_lang["SHOW_QUICK_RESN_help"]		= "~#pgv_lang[SHOW_QUICK_RESN]#~<br /><br />Met deze optie kun je de privacyvelden in- of uitschakelen op het #pgv_lang[quick_update_title]# formulier. Met privacyvelden kan een gebruiker die informatie toevoegt via het formulier, de standaardprivacy overschrijven voor het feit dat hij / zij invoert.";
$pgv_lang["USE_QUICK_UPDATE"]		= "Gebruik #pgv_lang[quick_update_title]# formulier";
$pgv_lang["USE_QUICK_UPDATE_help"]		= "~#pgv_lang[USE_QUICK_UPDATE]#~<br /><br />Deze optie bepaalt de gebruikersrechten die nodig zijn om wijzigingen in te dienen via het #pgv_lang[quick_update_title]# formulier.<br /><br />De keuze <b>#pgv_lang[nobody]#</b> betekent dat dit formulier niet kan worden gebruikt helemaal.";
$pgv_lang["SEARCHLOG_CREATE"]		= "Archief zoeklogbestanden";
$pgv_lang["SEARCHLOG_CREATE_help"]	= "~#pgv_lang[SEARCHLOG_CREATE]#~<br /><br />Hoe vaak moet het programma de zoeklogbestanden archiveren.";
$pgv_lang["CHANGELOG_CREATE"]		= "Archiveer wijzigingslogbestanden";
$pgv_lang["CHANGELOG_CREATE_help"]	= "~#pgv_lang[CHANGELOG_CREATE]#~<br /><br />Hoe vaak moet het programma de wijzigingslogbestanden archiveren.";
$pgv_lang["CHART_BOX_TAGS"]		= "Andere feiten om in grafieken te laten zien";
$pgv_lang["CHART_BOX_TAGS_help"]		= "~#pgv_lang[CHART_BOX_TAGS]#~<br /><br />Dit zou een door komma's of spaties gescheiden lijst met feiten moeten zijn, naast Geboorte en Overlijden, die u in diagramvakken wilt laten verschijnen, zoals de stamboomlijst. Deze lijst vereist dat u feitentags gebruikt zoals gedefinieerd in de GEDCOM 5.5.1-standaard. Als u bijvoorbeeld wilt dat de beroep in de box verschijnt, voegt u «OCCU» toe aan dit veld.";
$pgv_lang["FULL_SOURCES"]		= "Gebruik volledige bronvermeldingen";
$pgv_lang["FULL_SOURCES_help"]		= "~#pgv_lang[FULL_SOURCES]#~<br /><br />Bronvermeldingen kunnen velden bevatten om de kwaliteit van de gegevens (primair, secundair, etc.) vast te leggen en de datum waarop de gebeurtenis in de bron is opgenomen. Als u deze velden niet gebruikt, kunt u ze uitschakelen bij het maken van nieuwe bronvermeldingen.";
$pgv_lang["PREFER_LEVEL2_SOURCES"]		= "Bron type";
$pgv_lang["PREFER_LEVEL2_SOURCES_help"]		= "~#pgv_lang[PREFER_LEVEL2_SOURCES]#~<br /><br />Wanneer u nieuwe naaste familieleden toevoegt, kunt u bronvermeldingen toevoegen aan de records (bijvoorbeeld INDI, FAM) of de feiten (BIRT, MARR, DEAT). Deze optie bepaalt welke selectievakjes standaard zijn aangevinkt.";


//-- CONFIGURE FILE MESSAGES
$pgv_lang["gedcom_conf"]					= "Basisinstellingen";
$pgv_lang["media_conf"]						= "Multimedia";
$pgv_lang["media_general_conf"]				= "Algemeen";
$pgv_lang["media_firewall_conf"]			= "Media Firewall";
$pgv_lang["accpriv_conf"]					= "Toegang en privacy";
$pgv_lang["displ_conf"]						= "Tonen, Opmaak, en Rapporten";
$pgv_lang["displ_names_conf"]				= "Namen";
$pgv_lang["displ_comsurn_conf"]				= "Meest voorkomende achternamen";
$pgv_lang["displ_layout_conf"]				= "Opmaak";
$pgv_lang["displ_hide_conf"]				= "Tonen & verbergen";
$pgv_lang["displ_reports"]					= "Rapporten";
$pgv_lang["editopt_conf"]					= "Opties voor wijzigen";
$pgv_lang["useropt_conf"]					= "Opties voor gebruikers";
$pgv_lang["contact_conf"]					= "Contactinformatie";
$pgv_lang["meta_conf"]						= "Website en META-tags";
$pgv_lang["gedconf_head"]					= "GEDCOM-instellingen";
$pgv_lang["other_theme"]					= "Ander, typ in";
$pgv_lang["performing_update"]				= "Update uitvoeren.";
$pgv_lang["config_file_read"]				= "Lezen instellingenbestand.";
$pgv_lang["does_not_exist"]					= "bestaat niet";
$pgv_lang["media_drive_letter"]				= "In het pad naar de multimediamap kan geen driveletter worden opgenomen. Een foutief multimediapad leidt ertoe, dat multimedia-items niet worden weergegeven.";
$pgv_lang["db_setup_bad"]					= "De huidige databaseconfiguratie is corrupt. Controleer de database-verbindingsparameters en configureer opnieuw.";
$pgv_lang["bad_host_user_pass"]				= "PhpGedView kan geen verbinding maken met uw SQL databaseserver. Controleer de naam van de SQL database machine, de SQL database gebruikersnaam en het SQL database wachtwoord. ";
$pgv_lang["bad_database_name"]				= "PhpGedView kan verbinding maken met de SQL database machine, maar krijgt geen toegang tot de opgegeven database. Controleer de databasenaam, de gebruikersnaam en de toegekende rechten.";
$pgv_lang["db"]								= "Database";
$pgv_lang["current_gedcoms"]				= "Huidige GEDCOM-bestanden";
$pgv_lang["ged_gedcom"]						= "GEDCOM-bestand";
$pgv_lang["ged_title"]						= "GEDCOM-titel";
$pgv_lang["ged_config"]						= "Instellingenbestand";
$pgv_lang["ged_search"]						= "Logbestand Zoeken";
$pgv_lang["ged_change"]						= "ChangeLog bestanden";
$pgv_lang["ged_privacy"]					= "Privacybestand";
$pgv_lang["disabled"]						= "Uitgeschakeld";
$pgv_lang["mouseover"]						= "Door muisaanwijzer erover";
$pgv_lang["mousedown"]						= "Door muisknop ingedrukt";
$pgv_lang["click"]							= "Door muisklik";
$pgv_lang["enter_db_pass"]		= "Om veiligheidsredenen moet u altijd #pgv_lang[DBUSER]# en #pgv_lang[DBPASS]# invoeren wanneer u configuratiewaarden wijzigt.";
$pgv_lang["server_url_note"]	= "Dit zou de URL naar uw PhpGedView-map moeten zijn. U mag deze instelling alleen wijzigen als u zeker weet wat u doet. PhpGedView heeft bepaald dat deze waarde <b>#GUESS_URL#</b> is";

$pgv_lang["DBTYPE"]			= "Databasetype";
$pgv_lang["DBTYPE_help"]		= "~#pgv_lang[DBTYPE]#~<br /><br />Het type database waarmee verbinding moet worden gemaakt.<br /><br />PhpGedView kan elke database gebruiken waarvoor een PDO-stuurprogramma beschikbaar is. U moet ervoor zorgen dat uw php.ini bestand zowel de <b>php_pdo</b> bibliotheek als de juiste driver voor uw database laadt, bijv. <b>php_pdo_mysql</b>.<br /><br />De meeste databases vereisen een gebruikersnaam en wachtwoord. U moet ook de database maken voordat u PhpGedView installeert. SQLite heeft echter geen #pgv_lang[DBHOST]#, #pgv_lang[DBUSER]#, of #pgv_lang[DBPASS]# nodig, maar je moet een bestandspad voor je database instellen in het veld #pgv_lang[DBNAME]#. PhpGedView zal het SQLite-databasebestand voor u maken.";
$pgv_lang["DBHOST"]			= "Databasehost";
$pgv_lang["DBHOST_help"]		= "~#pgv_lang[DBHOST]#~<br /><br />Het DNS- of IP-adres van de computer waarop uw databaseserver wordt gehost. Deze instelling wordt genegeerd als u een SQLite-database gebruikt.";
$pgv_lang["DBPORT"]			= "Databasepoort";
$pgv_lang["DBPORT_help"]		= "~#pgv_lang[DBPORT]#~<br /><br />De TCP-poort die moet worden gebruikt om verbinding te maken met uw databaseserver. Laat deze instelling leeg om de standaardpoort voor uw specifieke type database te gebruiken. Deze instelling wordt genegeerd als u een SQLite-database gebruikt.";
$pgv_lang["DBUSER"]			= "Database gebruikersnaam";
$pgv_lang["DBUSER_help"]		= "~#pgv_lang[DBUSER]#~<br /><br />De database-gebruikersnaam die nodig is om in te loggen op uw database. Deze instelling wordt genegeerd als u een SQLite-database gebruikt.";
$pgv_lang["DBPASS"]			= "Database wachtwoord";
$pgv_lang["DBPASS_help"]		= "~#pgv_lang[DBPASS]#~<br /><br />Het databasewachtwoord voor de gebruiker die u heeft ingevoerd in het veld #pgv_lang[DBUSER]#. Deze instelling wordt genegeerd als u een SQLite-database gebruikt.";
$pgv_lang["DBNAME"]			= "Database naam";
$pgv_lang["DBNAME_help"]		= "~#pgv_lang[DBNAME]#~<br /><br />De database op de server die u PhpGedView wilt laten gebruiken.<br /><br />De gebruikersnaam die u invoert in het veld #pgv_lang[DBUSER]# moet de rechten Maken, Invoegen, Bijwerken, Verwijderen en Selecteren hebben voor deze database. In SQLite moet je dit instellen op een bestandsnaam in een map die schrijfbaar is voor PHP, zoals je Index map (index/phpgedview.db).";
$pgv_lang["TBLPREFIX_help"]		= "~#pgv_lang[TBLPREFIX]#~<br /><br />Een voorvoegsel voor de namen van de tabellen gemaakt door PhpGedView. Door deze waarde te wijzigen, kunt u meerdere PhpGedView-sites instellen om dezelfde fysieke database maar verschillende tabellen te gebruiken. Op dezelfde site zou bijvoorbeeld zowel een «test» als een «productie» -installatie van PhpGedView met volledig onafhankelijke gegevenstabellen kunnen hosten.";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"]	= "~#pgv_lang[ALLOW_CHANGE_GEDCOM]#~<br /><br />Als u een omgeving heeft met meerdere GEDCOM's, stelt u deze waarde in op <b>#pgv_lang[yes]#</b> geeft uw sitebezoekers <u>en</u> gebruikers de mogelijkheid om GEDCOM's te wijzigen. Als u dit instelt op <b>#pgv_lang[no]#</b>, wordt GEDCOM-omschakeling uitgeschakeld voor zowel bezoekers <u>als</u> ingelogde gebruikers.";
$pgv_lang["upload_path"]			= "Upload pad";
$pgv_lang["upload_path_help"]		= "~#pgv_lang[upload_path]#~<br /><br />Dit is het pad waar het GEDCOM-bestand dat u wilt uploaden, kan worden gevonden. Om het pad te selecteren, klikt u op <b>Bladeren</b> en navigeert u naar uw GEDCOM-bestand en klikt u vervolgens op <b>Openen</b>.";
$pgv_lang["gedcom_path"]			= "Pad en naam van GEDCOM op server";
$pgv_lang["gedcom_path_help"]		= "~#pgv_lang[gedcom_path]#~<br /><br />Er zijn twee manieren om uw GEDCOM-bestand in PhpGedView te importeren. Zij zijn:<ol><li>Gebruik een FTP-programma om het bestand naar de server te uploaden</li><li>Upload binnen PhpGedView</li></ol>Als je bestand al op de server bestaat, gebruik je de <i>#pgv_lang[add_gedcom]#</i> procedure en vul je het pad en de naam in van je GEDCOM-bestand zoals ze op de server staan. De naam kan met of zonder extensie zijn. Als er geen extensie wordt gegeven, wordt .ged aangenomen. Het pad is optioneel. Als er geen pad is opgegeven, wordt de waarde van de optie <i>#pgv_lang[INDEX_DIRECTORY]#</i>, zoals ingesteld in je PhpGedView-siteconfiguratie, gebruikt. Houd er rekening mee dat op de meeste servers bestands- en padnamen hoofdlettergevoelig zijn.<br /><br />Wanneer u de <i>#pgv_lang[upload_gedcom]#</i> procedure gebruikt die in PhpGedView is ingebouwd, kunt u de <b>Bladeren</b> om het gewenste bestand op uw lokale computer te zoeken. Dit kan een gewoon GEDCOM-bestand zijn of een ZIP-bestand met het GEDCOM-bestand. PhpGedView zal automatisch het GEDCOM-bestand uit dat ZIP-bestand extraheren en vervolgens gebruiken.<br /><br />Bij het uploaden van een bestand is het mogelijk om een alternatief pad en / of bestandsnaam op te geven om het op de server op te slaan.<br /><br />Zie het <a href=\"readme.txt\">Readme.txt</a> bestand voor meer informatie.";
$pgv_lang["CHARACTER_SET"]		= "Character Set-codering";
$pgv_lang["CHARACTER_SET_help"]		= "~#pgv_lang[CHARACTER_SET]#~<br /><br />Dit is de karakterset van uw GEDCOM-bestand. UTF-8 is de standaardinstelling en zou voor bijna alle sites moeten werken. Als u uw GEDCOM exporteert met behulp van IBM Windows-codering, moet u WINDOWS hier plaatsen.<br /><br />OPMERKING: PhpGedView kan UNICODE (UTF-16) niet ondersteunen omdat de ondersteuning ontbreekt in PHP.";
$pgv_lang["LANGUAGE"]			= "Taal";
$pgv_lang["LANGUAGE_help"]		= "~#pgv_lang[LANGUAGE]#~<br /><br />Wijs de standaardtaal voor de site toe.<br /><br />Wanneer de optie <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b> is ingesteld, kunnen gebruikers deze instelling overschrijven via de voorkeurstaalconfiguratie van hun browser. hun accountpagina, of via links of knoppen op de meeste PhpGedView-pagina's.";
$pgv_lang["ENABLE_MULTI_LANGUAGE"]	= "Sta de gebruiker toe om de taal te veranderen";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"]	= "~#pgv_lang[ENABLE_MULTI_LANGUAGE]#~<br /><br />Stel in op <b>#pgv_lang[yes]#</b> zodat gebruikers de standaardtaal van de site kunnen overschrijven. Ze kunnen dit doen via de voorkeurstaalconfiguratie van hun browser, configuratie-opties op hun accountpagina of via links of knoppen op de meeste PhpGedView-pagina's.";
$pgv_lang["CALENDAR_FORMAT"]		= "Kalenderformaat";
$pgv_lang["CALENDAR_FORMAT_help"]	= "~#pgv_lang[CALENDAR_FORMAT]#~<br /><br />Datums kunnen worden vastgelegd in verschillende kalenders, zoals de Gregoriaanse, Juliaanse of Joodse kalender. Met deze optie kunt u datums converteren naar een gewenste kalender. U kunt bijvoorbeeld Gregoriaans selecteren om Juliaanse en Hebreeuwse datums om te zetten in het Gregoriaans. De geconverteerde datum wordt tussen haakjes weergegeven na de reguliere datum.<br /><br />Datums worden alleen omgerekend als ze geldig zijn voor de kalender. Zo worden alleen datums tussen 22&nbsp;SEP&nbsp;1792 en 31&nbsp;DEC&nbsp;1805 geconverteerd naar de Franse Republikeinse kalender en alleen datums na 15&nbsp;OCT&nbsp;1582 worden omgezet naar de Gregoriaanse kalender.<br /><br />Hebreeuws is hetzelfde als Joods, maar met Hebreeuwse karakters. Arabisch is hetzelfde als Hijri, maar met Arabische karakters.<br /><br />Opmerking: aangezien de joodse en Hijri-kalenderdag bij zonsondergang begint, wordt elke gebeurtenis die plaatsvindt van zonsondergang tot middernacht weergegeven als een dag vóór de correcte datum. De weergave van Hebreeuws en Arabisch kan problematisch zijn in oude browsers, die tekst achterwaarts (van links naar rechts) of helemaal niet kunnen weergeven.";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"]	= "Toon Hebreeuwse duizenden";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"]	= "~#pgv_lang[DISPLAY_JEWISH_THOUSANDS]#~<br /><br />Toon Alafim in Hebreeuwse kalenders.<br /><br />Als u dit instelt op <b>#pgv_lang[yes]#</b>, wordt het jaar 1969 weergegeven als <span lang=\"he-IL\" dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; bij het instellen op <b>#pgv_lang[no]#</b> wordt het jaar weergegeven als <span lang=\"he-IL\" dir='rtl'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;.  Dit heeft geen invloed op de joodse jaarindeling. Het jaar wordt weergegeven als 5729 ongeacht deze instelling.<br /><br />Opmerking: deze instelling is vergelijkbaar met de kalenderconstante CAL_JEWISH_ADD_ALAFIM.";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]		= "Toon Hebreeuws Gershayim";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"]	= "~#pgv_lang[DISPLAY_JEWISH_GERESHAYIM]#~<br /><br />Toon enkele en dubbele aanhalingstekens («'» en «\"») bij het weergeven van Hebreeuwse datums.<br /><br />Als u dit instelt op <b>#pgv_lang[yes]#</b>, wordt 8 februari 1969 weergegeven als <span lang='he-IL' dir='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; als je het instelt op <b>#pgv_lang[no]#</b>, wordt het weergegeven als <span lang='he-IL' dir='rtl'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;.  Dit heeft geen invloed op de joodse jaarinstelling aangezien aanhalingstekens niet worden gebruikt in joodse datums die worden weergegeven met Latijnse tekens.<br /><br />Opmerking: deze instelling is vergelijkbaar met de kalenderconstanten CAL_JEWISH_ADD_ALAFIM_GERESH en CAL_JEWISH_ADD_GERESHAYIM. Deze enkele instelling heeft invloed op beide.";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"]	= "Joodse Ashkenaz uitspraak";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"]	= "~#pgv_lang[JEWISH_ASHKENAZ_PRONUNCIATION]#~<br /><br />Indien ingesteld op <b>#pgv_lang[yes]#</b> zullen de maanden Cheshvan en Teves worden gespeld met Ashkenazi uitspraak. Als je het instelt op <b>#pgv_lang[no]#</b>>, worden de maanden gewijzigd in Hesvan en Tevet. Dit heeft alleen invloed op de Joodse setting. De Hebreeuwse instelling zal altijd het Hebreeuwse alfabet gebruiken.";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"]	= "Aantal stamboomgeneraties";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"]	= "~#pgv_lang[DEFAULT_PEDIGREE_GENERATIONS]#~<br /><br />Stel het standaardaantal generaties in dat moet worden weergegeven in Nakomelingen- en Stamboomgrafieken.";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"]		= "Maximaal aantal stamboomgeneraties";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"]	= "~#pgv_lang[MAX_PEDIGREE_GENERATIONS]#~<br /><br />Stel het maximale aantal generaties in dat moet worden weergegeven in stamboomdiagrammen.";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"]	= "Maximaal aantal nakomelingen generaties";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"]	= "~#pgv_lang[MAX_DESCENDANCY_GENERATIONS]#~<br /><br />Stel het maximale aantal generaties in dat moet worden weergegeven op Nakomelingen grafieken.";
$pgv_lang["SOSA_WIDTH_NORMAL"]		= "Normale breedte van SOSA-nummers";
$pgv_lang["SOSA_WIDTH_NORMAL_help"]	= "~#pgv_lang[SOSA_WIDTH_NORMAL]#~<br /><br />Hoeveel ruimte er moet worden gereserveerd voor SOSA-nummers op kaarten<br /><br /><b>#pgv_lang[variable]#</b> geeft aan dat de breedte niet vast is en dat het afgedrukte SOSA-nummer evenveel ruimte in beslag neemt zoals het nodig heeft. De rest van de grafiek wordt dienovereenkomstig gepositioneerd.";
$pgv_lang["SOSA_WIDTH_WIDE"]		= "Extra breedte van SOSA-nummers";
$pgv_lang["SOSA_WIDTH_WIDE_help"]	= "~#pgv_lang[SOSA_WIDTH_WIDE]#~<br /><br />Hoeveel ruimte moet worden gereserveerd voor SOSA-nummers in de Boekje-weergave van de afstammingstabel<br /><br /><b>#pgv_lang[variable]#</b> geeft aan dat de breedte niet vast is en dat het afgedrukte SOSA-nummer evenveel ruimte in beslag neemt zoals het nodig heeft. De rest van de grafiek wordt dienovereenkomstig gepositioneerd.";
$pgv_lang["USE_RIN"]			= "Gebruik RIN-nummer in plaats van GEDCOM-ID";
$pgv_lang["USE_RIN_help"]		= "~#pgv_lang[USE_RIN]#~<br /><br />Stel in op <b>#pgv_lang[yes]#</b> om het RIN-nummer te gebruiken in plaats van de GEDCOM-ID wanneer gevraagd wordt naar persoons-ID's in configuratiebestanden, gebruikersinstellingen en grafieken. Dit is handig voor genealogieprogramma's die niet consequent GEDCOM's exporteren met dezelfde ID die aan elke persoon is toegewezen, maar altijd hetzelfde RIN gebruiken. ";
$pgv_lang["GENERATE_GUID"]		= "Maak automatisch wereldwijd unieke ID's";
$pgv_lang["GENERATE_GUID_help"]	= "~#pgv_lang[GENERATE_GUID]#~<br /><br /><b>GUID</b> is in deze context een acroniem voor «Globally Unique ID» (wereldwijd unieke ID).<br /><br />GUID's zijn bedoeld om elke persoon te helpen identificeren op een manier die herhaalbaar is, zodat centrale organisaties zoals het centrum voor familiegeschiedenis van de SLD-kerk in Salt Lake City, of zelfs compatibele programma's die op uw eigen server worden uitgevoerd, kunnen bepalen of ze met dezelfde persoon te maken hebben, ongeacht waar de GEDCOM vandaan komt. Het doel van het Family History Center is om een centrale opslagplaats van genealogische gegevens te hebben en deze openbaar te maken via webservices. Dit zal elk programma in staat stellen om toegang te krijgen tot de gegevens en hun gegevens erin bij te werken.<br /><br />Als u niet van plan bent om deze GEDCOM met iemand anders te delen, hoeft u deze GUID's niet door PhpGedView te laten aanmaken; dit doet echter geen andere schade dan het vergroten van uw GEDCOM.";
$pgv_lang["PEDIGREE_ROOT_ID"]		= "Standaardpersoon voor stamboom- en afstammingsgrafieken";
$pgv_lang["PEDIGREE_ROOT_ID_help"]	= "~#pgv_lang[PEDIGREE_ROOT_ID]#~<br /><br />Stel de ID in van de standaardpersoon die moet worden weergegeven in stamboom- en afstammingsgrafieken.";
$pgv_lang["GEDCOM_ID_PREFIX"]		= "Voorvoegsel van persoons-ID";
$pgv_lang["GEDCOM_ID_PREFIX_help"]	= "~#pgv_lang[GEDCOM_ID_PREFIX]#~<br /><br />Wanneer een nieuw persoonsrecord online wordt toegevoegd in PhpGedView, wordt automatisch een nieuw ID voor die persoon gegenereerd. De persoons-ID heeft dit voorvoegsel.";
$pgv_lang["SOURCE_ID_PREFIX"]		= "Voorvoegsel van bron-ID";
$pgv_lang["SOURCE_ID_PREFIX_help"]	= "~#pgv_lang[SOURCE_ID_PREFIX]#~<br /><br />Wanneer een nieuw bronrecord online wordt toegevoegd in PhpGedView, wordt automatisch een nieuw ID voor die bron gegenereerd. De bron-ID heeft dit voorvoegsel.";
$pgv_lang["REPO_ID_PREFIX"]		= "Voorvoegsel van opslagplaats-ID";
$pgv_lang["REPO_ID_PREFIX_help"]	= "~#pgv_lang[REPO_ID_PREFIX]#~<br /><br />Wanneer een nieuw opslagplaats-record online wordt toegevoegd in PhpGedView, wordt automatisch een nieuwe ID voor die opslagplaats gegenereerd. De opslagplaats-ID heeft dit voorvoegsel.";
$pgv_lang["PEDIGREE_FULL_DETAILS"]	= "Toon details over geboorte en overlijden op grafieken";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"]	= "~#pgv_lang[PEDIGREE_FULL_DETAILS]#~<br /><br />Deze optie bepaalt of de geboorte- en overlijdensgegevens van een persoon in grafieken moeten worden weergegeven.";
$pgv_lang["PEDIGREE_SHOW_GENDER"]	= "Toon geslachtspictogram op grafieken";
$pgv_lang["PEDIGREE_SHOW_GENDER_help"]	= "~#pgv_lang[PEDIGREE_SHOW_GENDER]#~<br /><br />Deze optie bepaalt of het geslachtspictogram van de persoon op grafieken moet worden weergegeven.<br /><br />Aangezien het geslacht ook wordt aangegeven door de kleur van het vak, verbergt deze optie het geslacht niet. De optie verwijdert eenvoudig enkele dubbele informatie uit de vak.";
$pgv_lang["PEDIGREE_LAYOUT"]		= "Standaard stamboomdiagram lay-out";
$pgv_lang["PEDIGREE_LAYOUT_help"]	= "~#pgv_lang[PEDIGREE_LAYOUT]#~<br /><br />Deze optie geeft aan of de stamboomkaart in liggende of staande modus moet worden gegenereerd.";
$pgv_lang["SHOW_EMPTY_BOXES"]		= "Toon lege vakken op stamboomdiagrammen";
$pgv_lang["SHOW_EMPTY_BOXES_help"]	= "~#pgv_lang[SHOW_EMPTY_BOXES]#~<br /><br />Deze optie bepaalt of lege vakjes in stamboomlijsten moeten worden weergegeven.";
$pgv_lang["ZOOM_BOXES"]			= "Zoom vakken op grafieken";
$pgv_lang["ZOOM_BOXES_help"]		= "~#pgv_lang[ZOOM_BOXES]#~<br /><br />Hiermee kan een gebruiker vakken op grafieken inzoomen om meer informatie te krijgen.<br /><br />Stel in op <b>#pgv_lang[disabled]#</b> om deze functie uit te schakelen. Stel in op <b> #pgv_lang [mouseover] # </b> om vakken in te zoomen wanneer de gebruiker de muis over het pictogram in het vak beweegt. Stel in op <b>#pgv_lang[click]#</b> om in te zoomen op vakjes wanneer de gebruiker op het pictogram in het vak klikt.";
$pgv_lang["LINK_ICONS"]			= "Toon links op grafieken";
$pgv_lang["LINK_ICONS_help"]		= "~#pgv_lang[LINK_ICONS]#~<br /><br />Hiermee kan de gebruiker links naar andere grafieken en naaste familieleden van de persoon selecteren.<br /><br />Stel in op <b>#pgv_lang[disabled]#</b> om deze functie uit te schakelen. Stel in op <b>#pgv_lang[mouseover]#</b> om de links te laten verschijnen wanneer de gebruiker de muis over het pictogram in het vak beweegt. Stel in op <b>#pgv_lang[click]#</b> om de links te laten verschijnen wanneer de gebruiker op het pictogram in het vak klikt.";
$pgv_lang["ABBREVIATE_CHART_LABELS"]			= "Verkort diagramlabels";
$pgv_lang["ABBREVIATE_CHART_LABELS_help"]		= "~#pgv_lang[ABBREVIATE_CHART_LABELS]#~<br /><br />Deze optie bepaalt of labels zoals <b>Geboorte</b> op grafieken met alleen de eerste letter zoals <b>G</b> moeten worden afgekort.<br /><br />U kunt de afkortingen aanpassen door op te geven waarden overschrijven in het bestand <i>languages/extra.xx.php</i> voor elke taal. Als u bijvoorbeeld <b>*</b> in plaats van <b>N</b> wilt gebruiken om het BIRT-feit in de Franse taal af te korten, moet u de volgende vermelding in de <i>languages/extra.fr.php</i> bestand:<br /><code>\$factAbbrev[\"BIRT\"]&nbsp;=&nbsp;\"*\";</code><br /><br />De lengte van afkortingen die op deze manier worden gespecificeerd, is niet beperkt tot 1 teken.";
$pgv_lang["SHOW_AGE_DIFF"]			= "Datumverschillen weergeven";
$pgv_lang["SHOW_AGE_DIFF_help"]		= "~#pgv_lang[SHOW_AGE_DIFF]#~<br /><br />Deze optie bepaalt of het tabblad Naaste verwanten verschillen moet weergeven tussen geboortedata van echtgenoten, tussen huwelijksdatum en geboortedatum van het eerste kind, en tussen geboortedata van kinderen.";
$pgv_lang["SHOW_PARENTS_AGE"]			= "Toon de leeftijd van de ouders naast de geboortedatum van het kind";
$pgv_lang["SHOW_PARENTS_AGE_help"]		= "~#pgv_lang[SHOW_PARENTS_AGE]#~<br /><br />Deze optie bepaalt of de leeftijd van vader en moeder naast de geboortedatum van het kind in grafieken moet worden weergegeven.";
$pgv_lang["SHOW_RELATIVES_EVENTS"]      = "Toon gebeurtenissen van naaste familieleden op de pagina «Persoonlijke details»";
$pgv_lang["SHOW_RELATIVES_EVENTS_help"] = "~#pgv_lang[SHOW_RELATIVES_EVENTS]#~<br /><br />Geboorten, huwelijken en overlijden van familieleden zijn belangrijke evenementen in iemands leven. Deze optie bepaalt of deze evenementen al dan niet worden weergegeven op het tabblad «Persoonlijke feiten en details» op de pagina «Persoonlijke details».<br /><br />De evenementen die door deze optie worden beïnvloed zijn:<ul><li>Dood van echtgenoot</li><li>Geboorte en dood van kinderen</li><li>Dood van ouders</li><li>Geboorte en dood van broers en zussen</li><li>Dood van grootouders</li><li>Geboorte en dood van broers en zussen van de ouders</li></ul>";
$pgv_lang["EXPAND_RELATIVES_EVENTS"]      = "Vouw automatisch de lijst met evenementen van naaste familieleden uit";
$pgv_lang["EXPAND_RELATIVES_EVENTS_help"] = "~#pgv_lang[EXPAND_RELATIVES_EVENTS]#~<br /><br />Deze optie bepaalt of de lijst <i>Gebeurtenissen van naaste familieleden</i> automatisch moet worden uitgevouwen.";
$pgv_lang["EXPAND_SOURCES"]      = "Breid automatisch bronnen uit";
$pgv_lang["EXPAND_SOURCES_help"] = "~#pgv_lang[EXPAND_SOURCES]#~<br /><br />Deze optie bepaalt of de inhoud van een <i>SOUR</i> record al dan niet automatisch wordt weergegeven op de pagina <i>#pgv_lang[personal_details]#</i>.";
$pgv_lang["EXPAND_NOTES"]      = "Breid automatisch notities uit";
$pgv_lang["EXPAND_NOTES_help"] = "~#pgv_lang[EXPAND_NOTES]#~<br /><br />Deze optie bepaalt of de inhoud van een <i>NOTE</i> record al dan niet automatisch wordt weergegeven op de pagina <i>#pgv_lang[personal_details]#</i>.";
$pgv_lang["SHOW_LEVEL2_NOTES"]      = "Toon alle verwijzingen naar notities en bronnen op de tabbladen Notities en bronnen";
$pgv_lang["SHOW_LEVEL2_NOTES_help"] = "~#pgv_lang[SHOW_LEVEL2_NOTES]#~<br /><br />Deze optie bepaalt of verwijzingen naar notities en bronnen die aan feiten zijn gekoppeld, moeten worden weergegeven op de tabbladen Notities en bronnen van de pagina <i>#pgv_lang[personal_details]#</i>.<br /><br />Gewoonlijk worden de tabbladen Notities en bronnen alleen weergegeven Notities en bronverwijzingen die rechtstreeks aan het databaserecord van de persoon zijn toegevoegd. Dit zijn <i>niveau 1</i> opmerkingen en bronverwijzingen.<br /><br />De optie <b>#pgv_lang[yes]#</b> zorgt ervoor dat deze tabbladen ook aantekeningen en bronverwijzingen tonen die maken deel uit van de verschillende feiten in het databaserecord van de persoon. Dit zijn <i>niveau 2</i> opmerkingen en bronverwijzingen omdat de verschillende feiten zich op niveau 1 bevinden.";
$pgv_lang["HIDE_LIVE_PEOPLE"]		= "Schakel privacy in";
$pgv_lang["HIDE_LIVE_PEOPLE_help"]	= "~#pgv_lang[HIDE_LIVE_PEOPLE]#~<br /><br />Deze optie schakelt alle privacy-instellingen in en verbergt de details van levende mensen.<br /><br />Levende mensen worden gedefinieerd als degenen die geen recentere gebeurtenis hebben dan het aantal jaren dat is opgegeven in de instelling <b>#pgv_lang[MAX_ALIVE_AGE]#</b>, die momenteel <b>#GLOBALS[MAX_ALIVE_AGE]#</b> is. Voor dit doel worden ook geboorten van kinderen als dergelijke gebeurtenissen beschouwd.";
$pgv_lang["REQUIRE_AUTHENTICATION"]	= "Verificatie van bezoekers vereist";
$pgv_lang["REQUIRE_AUTHENTICATION_help"]	= "~#pgv_lang[REQUIRE_AUTHENTICATION]#~<br /><br />Als u deze optie inschakelt, moeten alle bezoekers inloggen voordat ze gegevens op de site kunnen bekijken.";
$pgv_lang["PAGE_AFTER_LOGIN"]		= "Pagina om weer te geven na inloggen";
$pgv_lang["PAGE_AFTER_LOGIN_help"]	= "~#pgv_lang[PAGE_AFTER_LOGIN]#~<br /><br />Welke pagina moeten gebruikers zien nadat ze zijn ingelogd?<br /><br />De keuze die hier wordt gemaakt, bepaalt of een succesvolle login ervoor zorgt dat de welkomstpagina of de MyGedView-pagina verschijnt wanneer de login is gedaan vanaf de pagina #pgv_lang[welcome_page]#.<br /><br />Een login via de link bovenaan elke andere pagina zal de gebruiker naar die pagina terugbrengen.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"]	= "Welkomsttekst op inlogpagina";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE]#~<br /><br />Hier kunt u de tekst kiezen die op het inlogscherm moet verschijnen. U moet bepalen welke voorgedefinieerde tekst het meest geschikt is.<br /><br />U kunt er ook voor kiezen om uw eigen aangepaste welkomsttekst in te voeren, maar de tekst die u invoert, wordt niet vertaald wanneer uw gebruikers van taal veranderen. Als uw aangepaste tekst echter verwijzingen bevat naar taalvariabelen die u kunt definiëren in de verschillende <i>languages/extra.xx.php</i> bestanden, kan uw site vertaalde tekst tonen. Raadpleeg de Help-tekst die is gekoppeld aan het veld <b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#</b> voor meer informatie.<br /><br />De voorgedefinieerde teksten zijn:<ul><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT1]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_1]#</div><br /></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT2]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_2]#</div><br /></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT3]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_3]#</div></li></ul>";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT0"]	= "Geen voorgedefinieerde tekst";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"]	= "Voorgedefinieerde tekst waarin staat dat alle gebruikers een gebruikersaccount kunnen aanvragen";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"]	= "Voorgedefinieerde tekst waarin staat dat de beheerder beslist over elk verzoek om een gebruikersaccount";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"]	= "Voorgedefinieerde tekst waarin staat dat alleen gezinsleden een gebruikersaccount kunnen aanvragen";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"]	= "Kies de door de gebruiker gedefinieerde welkomsttekst die hieronder wordt getypt";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"]	= "Aangepaste welkomsttekst";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#~<br /><br />Als u heeft gekozen voor een aangepaste welkomsttekst, kunt u die tekst hier typen. De tekst wordt NIET vertaald in de taal van de bezoeker, maar wordt precies zo weergegeven als je hem hebt getypt. Als uw aangepaste tekst echter verwijzingen bevat naar taalvariabelen die u kunt definiëren in de verschillende <i>languages/extra.xx.php</i> bestanden, kan uw site vertaalde tekst weergeven.<br /><br />U kan HTML-tags invoegen in uw aangepaste welkomsttekst.<br /><br />De volgende beschrijving, afkomstig uit de Help-tekst voor de FAQ-lijst, is evenzeer van toepassing op de aangepaste welkomsttekst.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"] = "Standaardkop voor aangepaste welkomsttekst";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD_help"] = "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST_HEAD]#~<br /><br />Kies ervoor om een standaardkop weer te geven voor uw aangepaste welkomsttekst. Wanneer uw gebruikers van taal veranderen, zal deze header in de nieuwe taal verschijnen.<br /><br />Indien ingesteld op <b>#pgv_lang[yes]#</b>, ziet de header er als volgt uit:<div class=\"list_value_wrap\">#pgv_lang[welcome_text_cust_head]#</div>";
$pgv_lang["SHOW_REGISTER_CAUTION"]			= "Toon aanvaardbare gebruiksovereenkomst op de pagina «Aanvraag nieuw gebruikers account»";
$pgv_lang["SHOW_REGISTER_CAUTION_help"]		= "~#pgv_lang[SHOW_REGISTER_CAUTION]#~<br /><br />Indien ingesteld op <b>#pgv_lang[yes]#</b>, zal het volgende bericht verschijnen boven de invoervelden op de pagina <i>#pgv_lang[requestaccount]#</i>:<div class=\"list_value_wrap\">#pgv_lang[acceptable_use]#</div>";
$pgv_lang["CHECK_CHILD_DATES"]		= "Controleer de data van kinderen";
$pgv_lang["CHECK_CHILD_DATES_help"]	= "~#pgv_lang[CHECK_CHILD_DATES]#~<br /><br />Controleer de datums van kinderen om te bepalen of een persoon dood is. Op oudere systemen en grote GEDCOM's kan dit de responstijd van uw site vertragen.";
$pgv_lang["MAX_ALIVE_AGE"]		= "Leeftijd om aan te nemen dat een persoon dood is";
$pgv_lang["MAX_ALIVE_AGE_help"]		= "~#pgv_lang[MAX_ALIVE_AGE]#~<br /><br />Als deze persoon andere gebeurtenissen dan Dood, Begrafenis of Crematie heeft die recenter zijn dan dit aantal jaren, wordt hij beschouwd als «levend». De geboortedata van kinderen worden voor dit doel als dergelijke evenementen beschouwd.";
$pgv_lang["SHOW_GEDCOM_RECORD"]		= "Sta gebruikers toe om onbewerkte GEDCOM-records te zien";
$pgv_lang["SHOW_GEDCOM_RECORD_help"]	= "~#pgv_lang[SHOW_GEDCOM_RECORD]#~<br /><br />Als u dit instelt op <b>#pgv_lang[yes]#</b>, worden links naar personen, bronnen en families geplaatst om gebruikers een ander venster te laten openen met de onbewerkte gegevens die rechtstreeks uit het GEDCOM-bestand zijn gehaald.";
$pgv_lang["ALLOW_EDIT_GEDCOM"]		= "Schakel online bewerken in";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"]	= "~#pgv_lang[ALLOW_EDIT_GEDCOM]#~<br /><br />Met deze optie worden online bewerkingsfuncties voor deze database ingeschakeld, zodat gebruikers met bewerkingsrechten gegevens online kunnen bijwerken.";
$pgv_lang["ENABLE_AUTOCOMPLETE"]	= "Schakel automatisch aanvullen in";
$pgv_lang["USE_REFN"]		= "Gebruik het Referentienummer";
$pgv_lang["USE_REFN_help"]	= "~#pgv_lang[USE_REFN]#~<br /><br />Deze optie bepaalt of de #factarray[REFN]# ingevoerd in de details van een <u>nieuwe</u> persoon moet worden gebruikt als het ID-nummer voor die nieuwe persoon.<br /><br />Als deze optie is ingesteld op <b>#pgv_lang[yes]#</b>, moet de ingevoerde #factarray[REFN]# de regels volgen die zijn vastgesteld voor alle ID-nummers, en een persoon met die ID mag niet al bestaan in de database. Als niet aan deze voorwaarden is voldaan, of als deze optie is ingesteld op <b>#pgv_lang[no]#</b>, zal PhpGedView automatisch het volgende beschikbare ID-nummer aan die nieuwe persoon toewijzen.<br /><br />Geldige ID-nummers mogen alleen de letters <b>A</b> tot en met <b>Z</b>, <b>a</b> tot en met <b>z</b>, cijfers <b>0</b> tot en met <b>9</b>, en de speciale symbolen <b>. : -</b> en <b>_</b><br /><br />U moet ook de weergave van de #factarray[REFN]# inschakelen door de invoer <b>REFN</b> toe te voegen aan de configuratie-opties <b>#pgv_lang[INDI_FACTS_UNIQUE]#</b>, <b>#pgv_lang[INDI_FACTS_QUICK]#</b> en <b>#pgv_lang[QUICK_REQUIRED_FACTS]#</b> hieronder.";
$pgv_lang["ENABLE_AUTOCOMPLETE_help"]	= "~#pgv_lang[ENABLE_AUTOCOMPLETE]#~<br /><br />Deze optie bepaalt of automatisch aanvullen actief moet zijn terwijl informatie wordt ingevoerd in bepaalde velden op invoerformulieren. Als deze optie is ingesteld op <b>#pgv_lang[yes]#</b>, worden tekstinvoervelden waarvoor Autocomplete mogelijk is, aangegeven met een verschillend gekleurde achtergrond.<br /><br />Als Autocomplete actief is, PhpGedView zoekt in de database naar mogelijke overeenkomsten op basis van wat u al hebt ingevoerd. Naarmate u meer informatie invoert, wordt de lijst met mogelijke overeenkomsten verfijnd. Als je de gewenste invoer in de lijst met overeenkomsten ziet, kun je de muiscursor naar die regel van de lijst verplaatsen en vervolgens op de linkermuisknop klikken om de invoer te voltooien.<br /><br />De nadelen van Autocomplete zijn dat het vertraagt het programma, brengt aanzienlijke database-activiteit met zich mee en resulteert ook in het verzenden van meer gegevens naar de browser.";
$pgv_lang["EDIT_AUTOCLOSE"]		= "Sluit het bewerkingsvenster automatisch";
$pgv_lang["EDIT_AUTOCLOSE_help"]	= "~#pgv_lang[EDIT_AUTOCLOSE]#~<br /><br />Deze optie bepaalt of het bewerkingsvenster al dan niet automatisch moet worden gesloten na een succesvolle update.";
$pgv_lang["INDEX_DIRECTORY_help"]	= "~#pgv_lang[INDEX_DIRECTORY]#~<br /><br />Het pad naar een leesbare en beschrijfbare map waar PhpGedView indexbestanden zou moeten opslaan (inclusief de afsluitende «/»). PhpGedView vereist niet dat de naam van deze map «index» is. U kunt elke gewenste naam kiezen.<br /><br />Om veiligheidsredenen moet deze map ergens in de bestandsruimte van de server worden geplaatst die niet toegankelijk is vanaf internet. Een voorbeeld van zo'n structuur volgt:<br /><b>PhpGedView:</b> dir1/dir2/dir3/PhpGedView<br /><b>Index:</b> dir1/dir4/dir5/dir6/index<br /><br />Voor het getoonde voorbeeld zou u in dit veld <b>../../dir4/dir5/dir6/index/</b> invoeren.";
$pgv_lang["POSTAL_CODE"]  = "Postal Code position";
$pgv_lang["POSTAL_CODE_help"] = "~#pgv_lang[POSTAL_CODE]#~<br /><br />Verschillende landen gebruiken verschillende manieren om het adres te schrijven. Met deze optie kunt u de postcode voor of achter de plaatsnaam plaatsen.";
$pgv_lang["SUBLIST_TRIGGER_I"]		= "Maximaal aantal achternamen";
$pgv_lang["SUBLIST_TRIGGER_I_help"]	= "~#pgv_lang[SUBLIST_TRIGGER_I]#~<br /><br />Lange lijsten van personen met dezelfde achternaam kunnen opgedeeld worden in kleinere sublijsten op basis van de eerste letter van de voornaam van de persoon.<br /><br />Deze optie bepaalt wanneer een sublijst van achternamen zal voorkomen. Zet deze optie op nul om de sublijst volledig uit te schakelen.";
$pgv_lang["SUBLIST_TRIGGER_F"]		= "Maximaal aantal familienamen";
$pgv_lang["SUBLIST_TRIGGER_F_help"]	= "~#pgv_lang[SUBLIST_TRIGGER_F]#~<br /><br />Lange lijsten van families met dezelfde naam kunnen worden opgedeeld in kleinere sublijsten volgens de eerste letter van de opgegeven naam.<br /><br />Deze optie bepaalt wanneer een sublijst van familienamen zal voorkomen. Zet deze optie op nul om de sublijst volledig uit te schakelen.";
$pgv_lang["SURNAME_LIST_STYLE"]		= "Stijl van achternaamlijst";
$pgv_lang["SURNAME_LIST_STYLE_help"]	= "~#pgv_lang[SURNAME_LIST_STYLE]#~<br /><br />Lijsten met achternamen, zoals ze voorkomen in het #pgv_lang[block_top10]# blok, de #pgv_lang[individual_list]#, en de #pgv_lang[family_list]#, kunnen in verschillende stijlen worden weergegeven.<ul><li><b>#pgv_lang[style2]#</b>&nbsp;&nbsp;&nbsp;In deze stijl worden de achternamen weergegeven in een tabel die kan worden gesorteerd op achternaam of op aantal.</li><li><b>#pgv_lang[style3]#</b>&nbsp;&nbsp;&nbsp;In deze stijl worden de achternamen weergegeven in een lijst en de lettergrootte die voor elke naam wordt gebruikt, is afhankelijk van het aantal keren dat die naam in de database voorkomt. De lijst kan niet worden gesorteerd.</li></ul>";
$pgv_lang["SHOW_ID_NUMBERS_help"]	= "~#pgv_lang[SHOW_ID_NUMBERS]#~<br /><br />Deze optie bepaalt of ID-nummers tussen haakjes moeten worden weergegeven na namen in grafieken en lijsten.";
$pgv_lang["SHOW_LAST_CHANGE"]		= "Datum laatste wijziging op lijsten weergeven";
$pgv_lang["SHOW_LAST_CHANGE_help"]	= "~#pgv_lang[SHOW_LAST_CHANGE]#~<br /><br />Deze optie bepaalt of de laatste wijzigingsdatum al dan niet op lijsten moet worden weergegeven.";
$pgv_lang["SHOW_EST_LIST_DATES"]		= "Toon geschatte data voor geboorte en overlijden";
$pgv_lang["SHOW_EST_LIST_DATES_help"]	= "~#pgv_lang[SHOW_EST_LIST_DATES]#~<br /><br />Deze optie bepaalt of de geschatte datums voor geboorte en overlijden moeten worden weergegeven in plaats van lege velden op persoonslijsten en grafieken voor personen van wie de datums niet bekend zijn.";
$pgv_lang["SHOW_PEDIGREE_PLACES"]	= "Aantal plaatsniveaus dat in persoonsboxen moet worden weergegeven";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"]	= "~#pgv_lang[SHOW_PEDIGREE_PLACES]#~<br /><br />Dit stelt in hoeveel van de plaatsinformatie wordt getoond in de persoonsvakken op grafieken.<br /><br />Als u de waarde instelt op 9, wordt gegarandeerd dat alle plaatsniveaus worden weergegeven. Als u de waarde op 0 instelt, worden plaatsen volledig verborgen. Als u de waarde instelt op 1, wordt het eerste niveau weergegeven, als u dit op 2 instelt, worden de eerste twee niveaus weergegeven, enz.";
$pgv_lang["pageSizeDefault"]			= "Standaard paginaformaat";
$pgv_lang["pageSizeDefault_help"]		= "~#pgv_lang[pageSizeDefault]#~<br /><br />Dit is het standaardpaginaformaat voor alle rapporten. Uw keuze kan worden overschreven in de individueele rapporten.";
$pgv_lang["pageSizeOptions"]			= "Paginaformaten";
$pgv_lang["pageSizeOptions_help"]		= "~#pgv_lang[pageSizeOptions]#~<br /><br />Dit is de lijst met paginaformaten die momenteel door PhpGedView worden ondersteund bij het genereren van rapporten. U kunt deze lijst uitbreiden door andere standaardpaginaformaten toe te voegen, zoals vermeld in de <a href='https://nl.wikipedia.org/wiki/Papierformaat' title='Wikipedia-artikel' target='_blank'><b>Wikipedia-artikel</b></a><br /><ul><li>Het standaardpaginaformaat voor het grootste deel van de wereld is <b>A4</b>, wat overeenkomt met 210 x 297 mm (8,3 x 11,7 duim)</li><li>Het Noord-Amerikaanse standaardpaginaformaat is <b>letter</b>, wat overeenkomt met 216 x 279 mm (8,5 x 11,0 duim)</li><li>Andere beschikbare formaten zijn <b>A3</b>, wat overeenkomt met 297 x 420 mm (11,7 x 16,5 duim)</li><li>en <b>legal</b>, wat overeenkomt met 216 x 356 mm (8,5 x 14,0 duim)</li></ul><br />Voorzichtigheid is geboden bij het toevoegen van andere papierformaten dan die in de ISO «A» lijst; niet alle ISO-standaardmaten zijn getest.";
$pgv_lang["fontsDefault"]				= "Standaardlettertype";
$pgv_lang["fontsDefault_help"]			= "~#pgv_lang[fontsDefault]#~<br /><br />Dit is het standaardlettertype voor alle rapporten. Uw keuze kan worden overschreven in de individueele rapporten.";
$pgv_lang["fontsOptions"]				= "Lettertypen";
$pgv_lang["fontsOptions_help"]			= "~#pgv_lang[fontsOptions]#~<br /><br />Dit is de lijst met lettertypen die momenteel door PhpGedView worden ondersteund bij het genereren van rapporten.<br /><br />U kunt deze lijst indien nodig uitbreiden of inkorten. Voorzichtigheid is geboden bij het uitbreiden van deze lijst; niet alle lettertypen in de <i>includes/tcpdf/fonts</i> bibliotheek zijn getest.";
$pgv_lang["MULTI_MEDIA"]		= "Schakel multimediafuncties in";
$pgv_lang["MULTI_MEDIA_help"]		= "~#pgv_lang[MULTI_MEDIA]#~<br /><br />Met GEDCOM 5.5.1 kunt u afbeeldingen, video's en andere multimedia-objecten aan uw GEDCOM koppelen. Als u geen multimedia-objecten in uw GEDCOM opneemt, kunt u de multimediafuncties uitschakelen door deze waarde in te stellen op <b>#pgv_lang[no]#</b>.<br /><br />Zie de sectie Multimedia in de <a href=\"readme.txt\">readme.txt</a> bestand voor meer informatie over het opnemen van media op uw site.";
$pgv_lang["MEDIA_EXTERNAL"]			= "Houd links";
$pgv_lang["MEDIA_EXTERNAL_help"]	= "~#pgv_lang[MEDIA_EXTERNAL]#~<br /><br />Wanneer een multimediakoppeling wordt gevonden die begint met bijvoorbeeld http://, ftp://, mms:// wordt deze niet gewijzigd als deze is ingesteld op <b>#pgv_lang[yes]#</b>. http://www.myfamily.com/photo/dad.jpg blijft bijvoorbeeld http://www.myfamily.com/photo/dad. Indien ingesteld op <b>#pgv_lang[no]#</b>, wordt de link behandeld als een standaardreferentie en wordt de mediadiepte gebruikt. Bijvoorbeeld: http://www.myfamily.com/photo/dad.jpg wordt gewijzigd in ./media/dad.jpg";
$pgv_lang["MEDIA_DIRECTORY"]		= "Multimediamap";
$pgv_lang["MEDIA_DIRECTORY_help"]	= "~#pgv_lang[MEDIA_DIRECTORY]#~<br /><br />Het pad naar een leesbare en beschrijfbare map waar PhpGedView mediabestanden zou moeten opslaan (inclusief de volgbalk «/»). PhpGedView vereist niet dat de naam van deze map «media» is. U kunt elke gewenste naam kiezen.<br /><br />Hoewel u met de mediafirewall-functie mediabestanden kunt opslaan in een gebied van de bestandsruimte van de server dat niet toegankelijk is vanaf internet, moet de hier genoemde map nog steeds bestaan en moet leesbaar zijn vanaf internet en beschrijfbaar zijn door PhpGedView. Raadpleeg voor meer informatie de configuratie-opties van de media-firewall in de sectie Multimedia van de GEDCOM-configuratiepagina.";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"]	= "Aantal te behouden Multi-Media-mapniveaus";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"]	= "~#pgv_lang[MEDIA_DIRECTORY_LEVELS]#~<br /><br />Een waarde van 0 negeert alle mappen in het bestandspad voor het mediaobject. Bij een waarde van 1 wordt de eerste map met deze afbeelding behouden. Door het aantal te verhogen, wordt het aantal bovenliggende mappen in het pad vergroot.<br /><br />Als u bijvoorbeeld een afbeelding in uw GEDCOM koppelt met een pad zoals <<b>C:\\Documents&nbsp;and&nbsp;Settings\\User\\My&nbsp;Documents\\My&nbsp;Pictures\\Genealogy\\Surname&nbsp;Line\\grandpa.jpg</b>, een waarde van 0 vertaalt dit pad naar <b>./media/grandpa.jpg</b>. Een waarde van 1 vertaalt dit naar <b>./media/Surname&nbsp;Line/grandpa.jpg</b>, enz. De meeste mensen hoeven alleen een 0 te gebruiken. Het is echter mogelijk dat sommige media-objecten in verschillende mappen hebben identieke namen en zouden elkaar overschrijven als deze optie is ingesteld op 0. Instellingen die niet gelijk zijn aan nul stellen u in staat om een zekere organisatie in uw media te behouden en zo naamconflicten te voorkomen.";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"]	= "~#pgv_lang[SHOW_HIGHLIGHT_IMAGES]#~<br /><br />Als u multimedia op uw site heeft ingeschakeld, kunt u PhpGedView een miniatuurafbeelding laten weergeven naast de naam van de persoon in grafieken en vakken.<br /><br />Zie de sectie Multimedia in het <a href=\"readme.txt\">readme.txt</a> bestand voor meer informatie over het opnemen van media op uw site.";
$pgv_lang["USE_THUMBS_MAIN"]	= "Gebruik miniatuur";
$pgv_lang["USE_THUMBS_MAIN_help"]	= "~#pgv_lang[USE_THUMBS_MAIN]#~<br /><br />Deze optie bepaalt of PhpGedView de grote of de kleine afbeelding naar de browser moet sturen wanneer een diagram of de pagina <i>#pgv_lang[personal_details]#</i> een miniatuur vereist.<br /><br />De <b>#pgv_lang[no]#</b> keuze zorgt ervoor dat PhpGedView de grote afbeelding verzendt, terwijl de keuze <b>#pgv_lang[yes]#</b> ervoor zorgt dat de kleine afbeelding wordt verzonden. Elke individuele afbeelding heeft ook de optie «#factarray[_THUM]#» die, indien ingesteld op <b>#pgv_lang[yes]#</b>, ervoor zorgt dat de grote afbeelding wordt verzonden, ongeacht de instelling van de «#pgv_lang[USE_THUMBS_MAIN]#» optie in de GEDCOM-configuratie. U kunt PhpGedView niet dwingen om kleine afbeeldingen te verzenden als de GEDCOM-configuratie specificeert dat altijd grote afbeeldingen moeten worden gebruikt.<br /><br />PhpGedView past de grootte van de verzonden afbeelding niet aan; de browser doet dit volgens de paginaspecificaties die hij ook heeft ontvangen. Dit kan ongewenste gevolgen hebben wanneer de afbeelding die wordt verzonden niet echt een miniatuur is waar PhpGedView een kleine afbeelding naar verwacht. Dit is geen fout: er zijn gevallen waarin het wenselijk kan zijn om een grote afbeelding weer te geven op plaatsen waar men normaal gesproken een afbeelding ter grootte van een miniatuur zou verwachten.<br /><br />U moet de instelling van «#pgv_lang[USE_THUMBS_MAIN]#» optie voor <b>#pgv_lang[no]#</b>. Deze keuze zorgt ervoor dat overmatige hoeveelheden afbeeldingsgerelateerde gegevens naar de browser worden gestuurd, waarna de browser het overschot weggooit. Het laden van pagina's, met name van grafieken met veel afbeeldingen, kan ernstig worden vertraagd.";
$pgv_lang["SHOW_MEDIA_FILENAME"]		= "Toon bestandsnaam in media-viewer";
$pgv_lang["SHOW_MEDIA_FILENAME_help"]	= "~#pgv_lang[SHOW_MEDIA_FILENAME]#~<br /><br />De media-viewer kan de naam weergeven van het mediabestand dat wordt bekeken. Deze optie bepaalt of die bestandsnaam aan gebruikers wordt getoond.<br /><br />Om veiligheidsredenen wil je misschien de bestandsnaam verbergen.";
$pgv_lang["SHOW_MEDIA_DOWNLOAD"]		= "Toon downloadlink in mediaviewer";
$pgv_lang["SHOW_MEDIA_DOWNLOAD_help"]	= "~#pgv_lang[SHOW_MEDIA_DOWNLOAD]#~<br /><br />De media-viewer kan een link tonen die, wanneer erop wordt geklikt, het mediabestand naar de lokale pc zal downloaden.<br /><br />Om veiligheidsredenen wil je de downloadlink misschien verbergen.";
$pgv_lang["ENABLE_CLIPPINGS_CART"]	= "Knipselkar inschakelen";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"]	= "~#pgv_lang[ENABLE_CLIPPINGS_CART]#~<br /><br />De knipselkar stelt gebruikers in staat om mensen toe te voegen aan een tijdelijk bestand dat ze kunnen downloaden in GEDCOM-formaat voor latere import in hun genealogische software.";
$pgv_lang["HIDE_GEDCOM_ERRORS"]		= "Verberg GEDCOM-fouten";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"]	= "~#pgv_lang[HIDE_GEDCOM_ERRORS]#~<br /><br />Als u dit instelt op <b>#pgv_lang[yes]#</b>, worden foutmeldingen geproduceerd door PhpGedView verborgen als het een tag in uw GEDCOM-bestand niet begrijpt. PhpGedView stelt alles in het werk om te voldoen aan de GEDCOM 5.5.1-standaard, maar veel genealogische softwareprogramma's bevatten hun eigen aangepaste tags. Zie het <a href=\"readme.txt\">readme.txt</a> bestand voor meer informatie.";
$pgv_lang["WORD_WRAPPED_NOTES"]		= "Voeg spaties toe waar notities zijn verpakt";
$pgv_lang["WORD_WRAPPED_NOTES_help"]	= "~#pgv_lang[WORD_WRAPPED_NOTES]#~<br /><br />Sommige genealogieprogramma's plaatsen notities op woordgrenzen, terwijl andere notities overal insluiten. Dit kan ervoor zorgen dat PhpGedView woorden samen laat lopen. Als u dit instelt <b>#pgv_lang[yes]#</b>, wordt er een spatie tussen de woorden toegevoegd waar ze in de originele GEDCOM zijn verpakt.";
$pgv_lang["SHOW_CONTEXT_HELP"]		= "Contextuele Help-links weergeven";
$pgv_lang["SHOW_CONTEXT_HELP_help"]	= "~#pgv_lang[SHOW_CONTEXT_HELP]#~<br /><br />Met deze optie worden koppelingen ingeschakeld, aangeduid met vraagtekens, naast items op veel pagina's. Met deze links kunnen gebruikers informatie of hulp over die items krijgen.";
$pgv_lang["DAYS_TO_SHOW_LIMIT"]		= "Daglimiet van aankomende evenementenblok";
$pgv_lang["DAYS_TO_SHOW_LIMIT_help"] = "~#pgv_lang[DAYS_TO_SHOW_LIMIT]#~<br /><br />Voer het maximale aantal dagen in dat moet worden weergegeven in aankomende evenementenblokken. Dit aantal mag niet groter zijn dan 30. Als u een grotere waarde invoert, wordt 30 gebruikt.<br /><br />De waarde die u hier invoert, bepaalt hoe ver PhpGedView vooruit kijkt bij het zoeken naar aankomende evenementen. De resultaten van deze zoekopdracht, die één keer per dag wordt uitgevoerd, worden gekopieerd naar een tijdelijk bestand.<br /><br />Geen blokken met aankomende gebeurtenissen op index- of portaalpagina's kunnen meer dagen opvragen dan deze waarde. Hoe groter u dit maakt, hoe langer het duurt om het dagelijkse database-extract op te bouwen, en hoe langer het duurt om het blok weer te geven, zelfs als u vraagt om een aantal dagen minder weer te geven dan deze instelling.";
$pgv_lang["COMMON_NAMES_THRESHOLD"]	= "Minimumaantal keren dat het een «veelgebruikte achternaam» is";
$pgv_lang["COMMON_NAMES_THRESHOLD_help"]	= "~#pgv_lang[COMMON_NAMES_THRESHOLD]#~<br /><br />Dit is het aantal keren dat een achternaam moet voorkomen voordat deze wordt weergegeven in de veelgebruikte achternaamlijst op de welkomstpagina.";
$pgv_lang["COMMON_NAMES_ADD"]	= "Namen om toe te voegen aan de lijst met veelvoorkomende achternamen";
$pgv_lang["COMMON_NAMES_ADD_help"]	= "~#pgv_lang[COMMON_NAMES_ADD]#~<br /><br />Als het aantal keren dat een bepaalde achternaam voorkomt lager is dan de drempelwaarde, wordt deze niet in de lijst weergegeven. Het kan hier handmatig worden toegevoegd. Als er meer dan één achternaam is ingevoerd, moeten deze worden gescheiden door een komma. <b>Familienamen zijn hoofdlettergevoelig.</b>";
$pgv_lang["COMMON_NAMES_REMOVE"]	= "Namen die uit de lijst met veelvoorkomende achternamen moeten worden verwijderd";
$pgv_lang["COMMON_NAMES_REMOVE_help"]	= "~#pgv_lang[COMMON_NAMES_REMOVE]#~<br /><br />Als u een achternaam uit de veelvoorkomende achternaamlijst wilt verwijderen zonder de drempelwaarde te verhogen, kunt u dat doen door hier de achternaam in te voeren. Als er meer dan één achternaam is ingevoerd, moeten deze worden gescheiden door een komma. <b>Familienamen zijn hoofdlettergevoelig.</b> De achternamen die hier worden ingevoerd, worden ook verwijderd uit de Top-10-lijst op de welkomstpagina.";
$pgv_lang["HOME_SITE_URL"]		= "URL van hoofdwebsite";
$pgv_lang["HOME_SITE_URL_help"]		= "~#pgv_lang[HOME_SITE_URL]#~<br /><br />Elke PhpGedView-pagina bevat een link naar uw hoofdpagina. Het uiterlijk van deze link wordt bepaald door het thema dat wordt gebruikt. U voert hier de daadwerkelijke URL naar uw Home-site in.";
$pgv_lang["HOME_SITE_TEXT"]		= "Tekst van de hoofdwebsite";
$pgv_lang["HOME_SITE_TEXT_help"]	= "~#pgv_lang[HOME_SITE_TEXT]#~<br /><br />De tekst die wordt gebruikt om de link naar uw hoofdpagina te identificeren.";
$pgv_lang["CONTACT_EMAIL"]		= "Contactpersoon voor genealogie";
$pgv_lang["CONTACT_EMAIL_help"]		= "~#pgv_lang[CONTACT_EMAIL]#~<br /><br />De contactpersoon over de genealogische gegevens op deze site.";
$pgv_lang["CONTACT_METHOD"]		= "Contact methode";
$pgv_lang["CONTACT_METHOD_help"]	= "~#pgv_lang[CONTACT_METHOD]#~<br /><br />De methode die moet worden gebruikt om contact op te nemen met de #pgv_lang[CONTACT_EMAIL]# over genealogische vragen.#pgv_lang[CONTACT_METHOD_desc]#";
$pgv_lang["CONTACT_METHOD_desc"] = "<ul><li>De optie <b>#pgv_lang[mailto]#</b> zal een «mailto» -link maken waarop kan worden geklikt om een e-mail te verzenden met de e-mailclient op de pc van de gebruiker.</li><li>De optie <b>#pgv_lang[messaging]#</b> gebruikt een intern berichtensysteem voor PhpGedView en er worden geen e-mails verzonden.</li><li>De optie <b>#pgv_lang[messaging2]#</b> is de standaardoptie. Het zal het PhpGedView-berichtensysteem gebruiken en ook kopieën van de berichten via e-mail verzenden.</li><li>Met de optie <b>#pgv_lang[messaging3]#</b> kan PhpGedView de berichten afhandelen en de berichten als e-mail verzenden, maar de berichten niet intern opslaan. Deze optie is vergelijkbaar met de optie <b>#pgv_lang[mailto]#</b>, behalve dat het bericht wordt verzonden door PhpGedView in plaats van het werkstation van de gebruiker.</li><li>De optie <b>#pgv_lang[no_messaging]#</b> zorgt ervoor dat uw gebruikers geen contact met u kunnen opnemen.</li></ul>";
$pgv_lang["PHPGEDVIEW_EMAIL"]		= "PhpGedView antwoordadres";
$pgv_lang["PHPGEDVIEW_EMAIL_help"]	= "~#pgv_lang[PHPGEDVIEW_EMAIL]#~<br /><br />E-mailadres dat moet worden gebruikt in het veld «Van:» van e-mails die PhpGedView automatisch aanmaakt.<br /><br />PhpGedView kan automatisch e-mails aanmaken om beheerders op de hoogte te stellen van wijzigingen die moeten worden herzien. PhpGedView stuurt ook notificatie-e-mails naar gebruikers die een account hebben aangevraagd.<br /><br />Gewoonlijk is het veld «Van:» van deze automatisch aangemaakte e-mails zoiets als <i>Van: phpgedview-noreply@uwsite</i> om aan te tonen dat er geen reactie op de e-mail vereist is. Om u te beschermen tegen spam of ander e-mailmisbruik, vereisen sommige e-mailsystemen dat het veld «Van:» van elk bericht een geldig e-mailaccount weergeeft en accepteren geen berichten die blijkbaar afkomstig zijn van het account <i>phpgedview-noreply</i>.";
$pgv_lang["WEBMASTER_EMAIL"]		= "Contactpersoon voor ondersteuning";
$pgv_lang["WEBMASTER_EMAIL_help"]	= "~#pgv_lang[WEBMASTER_EMAIL]#~<br /><br />De persoon waarmee contact moet worden opgenomen over technische vragen of fouten die op uw site zijn aangetroffen.";
$pgv_lang["SUPPORT_METHOD"]		= "Ondersteuningsmethode";
$pgv_lang["SUPPORT_METHOD_help"]	= "~#pgv_lang[SUPPORT_METHOD]#~<br /><br />De methode die moet worden gebruikt om contact op te nemen met de #pgv_lang[WEBMASTER_EMAIL]# over technische vragen.#pgv_lang[CONTACT_METHOD_desc]#";
$pgv_lang["SHOW_FACT_ICONS"] 		= "Feitenpictogrammen weergeven";
$pgv_lang["SHOW_FACT_ICONS_help"]	= "~#pgv_lang[SHOW_FACT_ICONS]#~<br /><br />Stel dit in op <b>#pgv_lang[yes]#</b> om pictogrammen weer te geven bij feitnamen op de pagina <i>#pgv_lang[personal_details]#</i>. Pictogrammen worden alleen weergegeven als ze in de map <i>images/facts</i> van het huidige thema staan.";
$pgv_lang["FAVICON"]			= "Favorieten pictogram";
$pgv_lang["FAVICON_help"]		= "~#pgv_lang[FAVICON]#~<br /><br />Wijzig dit zodat het verwijst naar het pictogram dat u in het favorietenmenu van bezoekers wilt weergeven wanneer ze een bladwijzer voor uw site maken.";
$pgv_lang["THEME_DIR"]			= "Themamap";
$pgv_lang["THEME_DIR_help"]		= "~#pgv_lang[THEME_DIR]#~<br /><br />De map waarin uw PhpGedView-themabestanden worden bewaard.<br /><br />U kunt elk van de standaardthema's die bij PhpGedView worden geleverd aanpassen om uw site een unieke look en feel te geven. Zie de sectie Thema-aanpassing van het <a href=\"readme.txt\">readme.txt</a> bestand voor meer informatie.";
$pgv_lang["TIME_LIMIT"]			= "PHP tijdslimiet";
$pgv_lang["TIME_LIMIT_help"]		= "~#pgv_lang[TIME_LIMIT]#~<br /><br />De maximale tijd in seconden dat PhpGedView mag draaien.<br /><br />De standaardwaarde is 1 minuut. Afhankelijk van de grootte van uw GEDCOM-bestand, moet u deze tijdslimiet mogelijk verlengen wanneer u de indexen moet opbouwen. Zet deze waarde op 0 om PHP voor altijd te laten draaien.<br /><br />LET OP: Als je dit op 0 zet of te hoog instelt, kan je site vastlopen op bepaalde besturingssystemen totdat het script is voltooid. Als u het instelt op 0, wordt het mogelijk nooit voltooid totdat een serverbeheerder het proces beëindigt of de server opnieuw start. Een grote stamboomkaart kan erg lang duren; Als u deze waarde zo laag mogelijk laat, zorgt u ervoor dat iemand uw server niet kan laten crashen door een te grote grafiek aan te vragen.";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"]	= "~#pgv_lang[PGV_SESSION_SAVE_PATH]#~<br /><br />Het pad om PhpGedView-sessiebestanden op te slaan.<br /><br />Sommige hosts hebben PHP niet correct geconfigureerd en sessies worden niet onderhouden tussen pagina-aanvragen. Met deze optie kunnen sitebeheerders dat probleem oplossen door bestanden op te slaan in een van hun lokale mappen. De ./index/ map is een goede keuze als u dit moet wijzigen. De standaardinstelling is om het veld leeg te laten, waarbij het pad voor opslaan wordt gebruikt zoals geconfigureerd in <i>php.ini</i>.";
$pgv_lang["SERVER_URL_help"]		= "~#pgv_lang[SERVER_URL]#~<br /><br />Als u https of een andere poort dan de standaardpoort gebruikt, moet u de URL invoeren om hier toegang te krijgen tot uw server.";
$pgv_lang["LOGIN_URL"]			= "Aanmeldings-URL";
$pgv_lang["LOGIN_URL_help"]		= "~#pgv_lang[LOGIN_URL]#~<br /><br />U hoeft alleen een inlog-URL in te voeren als u naar een andere site of locatie wilt omleiden wanneer uw gebruikers inloggen. Dit is erg handig als u van http naar https moet overschakelen wanneer uw gebruikers inloggen. Voeg de volledige URL naar <i>login.php</i> toe. Bijvoorbeeld https://www.uwserver.com/phpgedview/login.php .";
$pgv_lang["PGV_SESSION_TIME_help"]	= "~#pgv_lang[PGV_SESSION_TIME]#~<br /><br />De tijd in seconden dat een PhpGedView-sessie actief blijft voordat een login vereist is. De standaardwaarde is 7200, dat is 2 uur.";
$pgv_lang["SHOW_STATS"]			= "Toon uitvoeringsstatistieken";
$pgv_lang["SHOW_STATS_help"]		= "~#pgv_lang[SHOW_STATS]#~<br /><br />Toon runtimestatistieken en databasequery's onder aan elke pagina.";
$pgv_lang["SHOW_COUNTER"]		= "Toon treffers";
$pgv_lang["SHOW_COUNTER_help"]		= "~#pgv_lang[SHOW_COUNTER]#~<br /><br />Toon treffers tellers op de Portal en <i>#pgv_lang[personal_details]#</i> pagina's.";
$pgv_lang["USE_REGISTRATION_MODULE_help"]	= "~#pgv_lang[USE_REGISTRATION_MODULE]#~<br /><br />Geeft bezoekers de mogelijkheid om zich te registreren voor een account op de site.<br /><br />De bezoeker ontvangt een e-mailbericht met een code om zijn aanvraag voor een account te verifiëren. Na verificatie zal de Administrator de registratie moeten goedkeuren voordat deze actief wordt.";
$pgv_lang["ALLOW_USER_THEMES_help"]	= "~#pgv_lang[ALLOW_USER_THEMES]#~<br /><br />Geeft gebruikers de mogelijkheid om hun eigen thema te selecteren.";
$pgv_lang["PGV_SIMPLE_MAIL_help"] = "~#pgv_lang[PGV_SIMPLE_MAIL]#~<br /><br />In normale mailheaders voor externe mails worden zowel het e-mailadres als de naam gebruikt. Sommige mailsystemen accepteren dit niet. Indien ingesteld op <b>#pgv_lang[yes]#</b>, wordt alleen het e-mailadres gebruikt.";
$pgv_lang["PGV_SMTP_ACTIVE_help"] = "~#pgv_lang[PGV_SMTP_ACTIVE]#~<br /><br />Gebruik SMTP om e-mails te verzenden vanuit PhpGedView.<br /><br />Deze optie vereist toegang tot een SMTP-mailserver. Indien ingesteld op <b>#pgv_lang[no]#</b> zal PhpGedView het e-mailsysteem gebruiken dat in PHP op deze server is ingebouwd.";
$pgv_lang["PGV_SMTP_DEBUG_help"] = "~#pgv_lang[PGV_SMTP_DEBUG]#~<br /><br />Als de optie <b>#pgv_lang[PGV_SMTP_ACTIVE]#</b> is ingesteld op <b>#pgv_lang[yes]#</b>, zal PhpGedView het PHPMailer programma gebruiken om e-mails te versturen. Dit programma geeft foutmeldingen wanneer het problemen tegenkomt bij het verzenden van e-mails.<br /><br />Deze optie, die handig is bij het oplossen van problemen met het verzenden van e-mail, bepaalt de soorten fouten die PHPMailer zal rapporteren. De fouttypen die u kunt selecteren, zijn:<ul><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION0]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION1]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION2]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION3]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION4]#</li></ul>";
$pgv_lang["PGV_SMTP_HOST_help"] = "~#pgv_lang[PGV_SMTP_HOST]#~<br /><br />Dit is de naam van de SMTP-mailserver. Voorbeeld: <b>smtp.foo.bar.com</b>.<br /><br />Configuratiewaarden voor sommige e-mailproviders:<br /><br /><b>Gmail</b><br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_HOST]#:&nbsp;&nbsp;smtp.gmail.com<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_PORT]#:&nbsp;&nbsp;465 of 587<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_SSL]#:&nbsp;&nbsp;SSL<br /><br /><b>Hotmail</b><br />&nbsp;&nbsp;&nbsp#pgv_lang[PGV_SMTP_HOST]#:&nbsp;&nbsp;smtp.live.com<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_PORT]#:&nbsp;&nbsp;25 of 587<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_SSL]#:&nbsp;&nbsp;TLS<br /><br /><b>Yahoo Mail Plus</b> (momenteel een betaalde dienst)<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_HOST]#:&nbsp;&nbsp;smtp.mail.yahoo.com<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_PORT]#:&nbsp;&nbsp;25";
$pgv_lang["PGV_SMTP_HELO_help"] = "~#pgv_lang[PGV_SMTP_HELO]#~<br /><br />Dit is het domeingedeelte van een geldig e-mailadres op de SMTP-server.<br /><br />Als u bijvoorbeeld een e-mailaccount heeft zoals <b>uwnaam@abc.xyz.com</b>, zou je hier <b>abc.xyz.com</b> invoeren.";
$pgv_lang["PGV_SMTP_PORT_help"] = "~#pgv_lang[PGV_SMTP_PORT]#~<br /><br />Het poortnummer dat moet worden gebruikt voor verbindingen met de SMTP-server. Over het algemeen is dit poort <b>25</b>.";
$pgv_lang["PGV_SMTP_AUTH_help"] = "~#pgv_lang[PGV_SMTP_AUTH]#~<br /><br />Gebruik naam- en wachtwoordverificatie om verbinding te maken met de SMTP-server.<br /><br />Sommige SMTP-servers vereisen dat alle verbindingen worden geverifieerd voordat ze uitgaande e-mails accepteren.";
$pgv_lang["PGV_SMTP_AUTH_USER_help"] = "~#pgv_lang[PGV_SMTP_AUTH_USER]#~<br /><br />De gebruikersnaam die vereist is voor authenticatie bij de SMTP-server.";
$pgv_lang["PGV_SMTP_AUTH_PASS_help"] = "~#pgv_lang[PGV_SMTP_AUTH_PASS]#~<br /><br />Het wachtwoord dat vereist is voor authenticatie bij de SMTP-server.";
$pgv_lang["PGV_SMTP_SSL_help"]		 = "~#pgv_lang[PGV_SMTP_SSL]#~<br /><br />Transport Layer Security (TLS) en Secure Sockets Layer (SSL) zijn encryptieprotocollen voor internetgegevens.<br /><br />TLS 1.0, 1.1 en 1.2 zijn gestandaardiseerde ontwikkelingen van SSL 3.0. TLS 1.0 en SSL 3.1 zijn gelijkwaardig. Verder werk aan SSL wordt nu gedaan onder de nieuwe naam, TLS.<br /><br />Als uw SMTP-server het SSL-protocol vereist tijdens het inloggen, moet u de optie <b>SSL</b> selecteren. Als uw SMTP-server het TLS-protocol vereist tijdens het inloggen, moet u de optie <b>TLS</b> selecteren.";
$pgv_lang["PGV_SMTP_FROM_NAME_help"] = "~#pgv_lang[PGV_SMTP_FROM_NAME]#~<br /><br />Typ de te gebruiken naam in het veld «Van:» van e-mails die afkomstig zijn van deze site.<br /><br />Als uw naam bijvoorbeeld <b>John Smith</b> is en u de sitebeheerder voor een site die bekend staat als <b>Jones Genealogy</b>, kunt u iets invoeren als <b>John&nbsp;Smith</b> of <b>Jones&nbsp;Genealogy</b> of zelfs <b>John&nbsp;Smith,&nbsp;Administrator:&nbsp;Jones&nbsp;Genealogy</b>. U kunt alles invoeren wat u maar wilt, maar HTML is niet toegestaan.";
$pgv_lang["gedcom_title"]			= "#pgv_lang[ged_title]#";
$pgv_lang["gedcom_title_help"]		= "~#pgv_lang[gedcom_title]#~<br /><br />Voer een beschrijvende titel in die moet worden weergegeven wanneer gebruikers een keuze maken uit GEDCOM-datasets op uw site.";
$pgv_lang["LOGFILE_CREATE"]		= "Archiveer de logbestanden";
$pgv_lang["LOGFILE_CREATE_help"]	= "~#pgv_lang[LOGFILE_CREATE]#~<br /><br />Hoe vaak moet het programma logbestanden archiveren.";
$pgv_lang["REMINDER_FREQ"] 			= "Frequentie van e-mails ter herinnering «Wijzigingen bekijken»";
$pgv_lang["REMINDER_FREQ_help"]		= "~#pgv_lang[REMINDER_FREQ]#~<br /><br />Deze optie bepaalt hoe vaak de herinneringsmails «Wijzigingen bekijken» worden verzonden. <b>nul</b>: nooit;&nbsp;&nbsp;<b>1</b>: dagelijks;&nbsp;&nbsp;<b>2</b>: elke 2e dag; enz.";
$pgv_lang["PGV_MEMORY_LIMIT_help"]	= "~#pgv_lang[PGV_MEMORY_LIMIT]#~<br /><br />De maximale hoeveelheid geheugen die kan worden gebruikt door PhpGedView-scripts. De standaardwaarde is 64 Mb. Veel hosts schakelen deze optie uit in hun PHP-configuratie; het wijzigen van deze waarde heeft mogelijk geen invloed op de huidige maximale geheugeninstelling.";
$pgv_lang["PGV_STORE_MESSAGES_help"]	= "~#pgv_lang[PGV_STORE_MESSAGES]#~<br /><br />Specificeert of berichten verzonden via PhpGedView kunnen worden opgeslagen in de database. Indien ingesteld op <b>#pgv_lang[yes]#</b>, kunnen gebruikers hun berichten ophalen wanneer ze inloggen op PhpGedView. Indien ingesteld op <b>#pgv_lang[no]#</b> worden berichten alleen per e-mail verzonden.";
$pgv_lang["ALLOW_THEME_DROPDOWN"]		= "Geef het themamenu weer voor themawijzigingen";
$pgv_lang["ALLOW_THEME_DROPDOWN_help"]	= "~#pgv_lang[ALLOW_THEME_DROPDOWN]#~<br /><br />Geeft gebruikers de mogelijkheid om hun eigen thema uit een menu te selecteren.<br /><br />Zelfs als deze optie is ingesteld, is het mogelijk dat het huidige thema niet in een dergelijk menu voorziet. Om effectief te zijn, moet voor deze optie ook de optie <b>#pgv_lang[ALLOW_USER_THEMES]#</b> worden ingesteld.";
$pgv_lang["MAX_VIEW_RATE"]		= "Maximale paginaweergavesnelheid";
$pgv_lang["MAX_VIEW_RATE_help"]	= "~#pgv_lang[MAX_VIEW_RATE]#~<br /><br />Deze optie beperkt de snelheid waarmee een gebruiker pagina's kan bekijken.<br /><br />Als die snelheid wordt overschreden, behandelt PhpGedView de sessie als een hackpoging; de sessie wordt beëindigd met een passend bericht. Deze twee waarden zouden een redelijke limiet moeten stellen aan de hoeveelheid bandbreedte en gedownloade bytes van de server. Deze functie kan worden uitgeschakeld door het tijdsinterval in te stellen op 0.";
$pgv_lang["META_AUTHOR"]		= "META tag: Author (auteur)";
$pgv_lang["META_AUTHOR_help"]	= "~#pgv_lang[META_AUTHOR]#~<br /><br />De waarde die in de metatag Auteur in de HTML-paginakop moet worden geplaatst. #pgv_lang[META_AUTHOR_descr]#";
$pgv_lang["META_AUTHOR_descr"]	= "Laat dit veld leeg om de volledige naam van de #pgv_lang[CONTACT_EMAIL]# te gebruiken.";
$pgv_lang["META_PUBLISHER"]		= "META tag: Publisher (uitgever)";
$pgv_lang["META_PUBLISHER_help"]	= "~#pgv_lang[META_PUBLISHER]#~<br /><br />De waarde die in de metatag uitgever in de HTML-paginakop moet worden geplaatst. #pgv_lang[META_PUBLISHER_descr]#";
$pgv_lang["META_PUBLISHER_descr"]	= "Laat dit veld leeg om de volledige naam van de #pgv_lang[CONTACT_EMAIL]# te gebruiken.";
$pgv_lang["META_COPYRIGHT"]		= "META tag: Copyright (auteursrechten)";
$pgv_lang["META_COPYRIGHT_help"]	= "~#pgv_lang[META_COPYRIGHT]#~<br /><br />De waarde die in de metatag auteursrechten in de HTML-paginakop moet worden geplaatst. #pgv_lang[META_COPYRIGHT_descr]#";
$pgv_lang["META_COPYRIGHT_descr"]	= "Laat dit veld leeg om de volledige naam van de #pgv_lang[CONTACT_EMAIL]# te gebruiken.";
$pgv_lang["META_DESCRIPTION"]		= "META tag: Description (beschrijving)";
$pgv_lang["META_DESCRIPTION_help"]	= "~#pgv_lang[META_DESCRIPTION]#~<br /><br />De waarde die in de metatag beschrijving in de HTML-paginakop moet worden geplaatst. #pgv_lang[META_DESCRIPTION_descr]#";
$pgv_lang["META_DESCRIPTION_descr"]	= "Laat dit veld leeg om de titel van de momenteel actieve database te gebruiken.";
$pgv_lang["META_PAGE_TOPIC"]		= "META tag: Page-topic (onderwerp)";
$pgv_lang["META_PAGE_TOPIC_help"]	= "~#pgv_lang[META_PAGE_TOPIC]#~<br /><br />De waarde die moet worden geplaatst in de metatag onderwerp in de HTML-paginakoptekst. #pgv_lang[META_PAGE_TOPIC_descr]#";
$pgv_lang["META_PAGE_TOPIC_descr"]	= "Laat dit veld leeg om de titel van de momenteel actieve database te gebruiken.";
$pgv_lang["META_AUDIENCE"]		= "META tag: Audience (publiek)";
$pgv_lang["META_AUDIENCE_help"]	= "~#pgv_lang[META_AUDIENCE]#~<br /><br />De waarde die in de metatag publiek in de HTML-paginakop moet worden geplaatst.";
$pgv_lang["META_PAGE_TYPE"]		= "META tag: Page-type (paginatype)";
$pgv_lang["META_PAGE_TYPE_help"]	= "~#pgv_lang[META_PAGE_TYPE]#~<br /><br />De waarde die in de metatag paginatype in de HTML-paginakop moet worden geplaatst.";
$pgv_lang["META_ROBOTS"]		= "META tag: Robots";
$pgv_lang["META_ROBOTS_help"]	= "~#pgv_lang[META_ROBOTS]#~<br /><br />De waarde die in de metatag robots in de HTML-paginakop moet worden geplaatst. Sommige zoekmachines negeren deze waarde.";
$pgv_lang["META_REVISIT"]		= "META tag: Revisit (herzien)";
$pgv_lang["META_REVISIT_help"]	= "~#pgv_lang[META_REVISIT]#~<br /><br />Hoe vaak moeten zoekmachines opnieuw bezoeken? De waarde die in de metatag herzien in de HTML-paginakop moet worden geplaatst. Sommige zoekmachines negeren deze waarde.";
$pgv_lang["META_KEYWORDS"]		= "META tag: Keywords (trefwoorden)";
$pgv_lang["META_KEYWORDS_help"]	= "~#pgv_lang[META_KEYWORDS]#~<br /><br />De waarde die in de metatag trefwoorden in de HTML-paginakop moet worden geplaatst. Sommige zoekmachines zullen de metatag trefwoorden gebruiken om uw pagina te indexeren.<br /><br />De #pgv_lang[common_surnames]# lijst die verschijnt in het #pgv_lang[gedcom_stats]# blok op uw welkomstpagina kan ook worden toegevoegd voor alles wat u hier invoert.";
$pgv_lang["META_TITLE"]		= "Toevoegen aan TITLE-koptag";
$pgv_lang["META_TITLE_help"]	=	"~#pgv_lang[META_TITLE]#~<br /><br />Alles op deze regel wordt toegevoegd aan de TITLE-tag in de HTML-paginakop na de gewone paginatitel en vóór het PhpGedView-tegoed.";

$pgv_lang["ENABLE_RSS"]				= "Schakel RSS in";
$pgv_lang["ENABLE_RSS_help"]		= "~#pgv_lang[ENABLE_RSS]#~<br /><br />Met deze optie kunt u de RSS-functie uitschakelen.<br /><br />Met RSS kunnen gebruikers uw site controleren op wijzigingen in de indexpagina zonder uw site regelmatig te bezoeken. Als te veel gebruikers gebruik maken van deze functie of als de verversingsfrequentie die door deze gebruikers is ingesteld te hoog is, kan RSS te veel bandbreedte of servercapaciteit gebruiken.<br /><br />Deze <a href='https://nl.wikipedia.org/wiki/RSS' target='_blank' title='Wikipedia-artikel'><b>Wikipedia-artikel</b></a> bevat uitgebreide informatie en links over RSS en de verschillende RSS-formaten.";
$pgv_lang["RSS_FORMAT"]				= "RSS Formaat";
$pgv_lang["RSS_FORMAT_help"]		= "~#pgv_lang[RSS_FORMAT]#~<br /><br />Het formaat dat moet worden gebruikt als het standaard feedformaat voor de site. De numerieke achtervoegsels <u>geven niet</u> de versie aan: ze identificeren formaten. RSS 2.0 is bijvoorbeeld niet nieuwer dan RSS 1.0, maar een ander formaat. Feedlezers moeten elk formaat kunnen lezen.<br /><br />Deze <a href='https://nl.wikipedia.org/wiki/RSS' target='_blank' title='Wikipedia-artikel'><b>Wikipedia-artikel</b></a> bevat uitgebreide informatie en links over RSS en de verschillende RSS-formaten.";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE"] = "Controleer of GEDCOM-bestanden kunnen worden gedownload";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE_help"] = "~#pgv_lang[SECURITY_CHECK_GEDCOM_DOWNLOADABLE]#~<br /><br />Om veiligheidsredenen mogen GEDCOM-bestanden zich niet op een locatie bevinden waar ze direct kunnen worden gedownload, waardoor privacycontroles worden omzeild. Als u op deze link klikt, wordt gecontroleerd of uw GEDCOM-bestanden via het netwerk kunnen worden gedownload.<br /><br />Op sommige systemen is bekend dat deze controle erg lang duurt of zelfs niet volledig is. Als dat voor u het geval is, moet u proberen uw browser rechtstreeks op uw GEDCOM te richten om te zien of deze kan worden gedownload.";
$pgv_lang["gedcom_download_secure"]	= "#GEDCOM# kan niet worden gedownload.";

$pgv_lang["welcome_new_help"]		= "~#pgv_lang[welcome_new]#~<br /><br />Aangezien u deze pagina ziet, heeft u PhpGedView met succes op uw server geïnstalleerd en bent u klaar om te beginnen met het configureren naar uw wensen.<br /><br />Deze Help-pagina leidt u door het configuratieproces. Terwijl u verschillende velden invoert, biedt dit venster u hulpinformatie over het veld waarin u zich bevindt. U kunt dit venster sluiten; om het opnieuw te openen klikt u op een van de <b>#pgv_lang[qm]#</b> vraagtekens naast het veldlabel.";
$pgv_lang["return_editconfig"]		= "U kunt op elk moment terugkeren naar deze configuratie door uw browser naar <i>editconfig.php</i> te wijzen of door op de link voor <b>Configuratie </b>op de <b>Beheer PhpGedView</b> pagina te klikken .";
$pgv_lang["return_editconfig_gedcom"]	= "U kunt op elk moment terugkeren naar deze configuratie door op de link <b>Bewerken</b> te klikken in de tabel <b>#pgv_lang[current_gedcoms]#</b> in de <b>#pgv_lang[gedcom_adm_head]#</b> pagina of door uw browser naar <i>editconfig_gedcom.php</i> te wijzen.";
$pgv_lang["save_config"] 		= "Bewaar de configuratie";
$pgv_lang["download_gedconf"]		= "Download de GEDCOM-configuratie.";
$pgv_lang["not_writable"]		= "We hebben vastgesteld dat uw configuratiebestand niet schrijfbaar is voor PHP. U kunt de knop <b>#pgv_lang[download_file]#</b> gebruiken om uw instellingen op te slaan in een bestand dat u handmatig kunt uploaden.";
$pgv_lang["upload_to_index"]		= "Upload het bestand naar uw index map: ";
$pgv_lang["import_sql"]			= "SQL-bestanden zijn gevonden in uw index map. Omdat ze mogelijk afkomstig zijn van de #pgv_lang[um_header]#, hebt u de mogelijkheid om de informatie in uw database te importeren. Wilt u deze bestanden nu in uw database importeren? Alle bestaande gebruikersgerelateerde informatie (gebruikers, nieuws, favorieten, bloklay-outs en berichten) in uw database gaat verloren.<br /><br />Als u ervoor kiest om door te gaan, zal PhpGedView proberen de gegevens te importeren. Als dit niet lukt, wordt u toch gevraagd om het eerste beheerdersaccount aan te maken.";

//-- edit privacy messages
$pgv_lang["edit_privacy"]			= "Privacy bewerken";
$pgv_lang["edit_privacy_title"]			= "Bewerk de GEDCOM-privacyinstellingen";
$pgv_lang["save_changed_settings"]		= "Wijzigingen opslaan";
$pgv_lang["add_new_pp_setting"]			= "Voeg een nieuwe instelling toe voor totale privacy per persoon-ID";
$pgv_lang["add_new_up_setting"]			= "Voeg een nieuwe instelling toe voor privay per gebruikersnaam";
$pgv_lang["add_new_gf_setting"]			= "Voeg een nieuwe instelling toe voor wereldwijde feitenprivacy";
$pgv_lang["add_new_pf_setting"]			= "Voeg een nieuwe instelling toe voor feitenprivacy per persoons-ID";
$pgv_lang["file_read_error"]			= "F O U T !!! Kon het privacybestand niet lezen!";
$pgv_lang["edit_exist_person_privacy_settings"]	= "Bewerk bestaande instellingen van totale privacy per persoon-ID";
$pgv_lang["edit_exist_user_privacy_settings"]	= "Bewerk bestaande instellingen van privacy per gebruikersnaam";
$pgv_lang["edit_exist_global_facts_settings"]	= "Bewerk bestaande instellingen van wereldwijde feitenprivacy";
$pgv_lang["edit_exist_person_facts_settings"]	= "Bewerk bestaande instellingen van feitenprivacy per persoons-ID";
$pgv_lang["general_privacy"]			= "Algemene privacy-instellingen";
$pgv_lang["general_privacy_help"]		= "~#pgv_lang[general_privacy]#~<br /><br />U kunt verschillende privacy-instellingen hebben voor elke GEDCOM op uw PhpGedView-website. Controleer onder de paginatitel of u de juiste GEDCOM aan het bewerken bent.<br /><br />U kunt deze algemene instellingen overschrijven door de andere privacyformulieren op de #pgv_lang[edit_privacy_title]# pagina te gebruiken.<br /><br />#pgv_lang[more_help_advice]#";
$pgv_lang["person_privacy"]				= "Instelling voor totale privacy per persoon-ID";
$pgv_lang["person_privacy_help"]		= "~#pgv_lang[person_privacy]#~<br /><br />Met deze instellingen kunnen beheerders de standaardprivacyinstellingen voor een bepaalde persoon, familie, bron of media-object overschrijven.<br /><br />Stel dat u bijvoorbeeld een kind heeft dat op jonge leeftijd is overleden. Normaal gesproken, omdat het kind dood is, worden de details ervan getoond aan openbare gebruikers. U en alle anderen in uw gezin zijn echter nog steeds privé. U wilt het overlijdensregister van het kind niet verwijderen, maar u wilt de details verbergen en ze privé maken. Als dit kind de ID van I100 had, moet u de volgende privacy-instellingen invoeren:<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I100<br />&nbsp;&nbsp;&nbsp;#pgv_lang[accessible_by]#:&nbsp;&nbsp;#pgv_lang[PRIV_USER]#<br /><br />Dit werkt ook andersom. Als u de gegevens van iemand (ID I101) openbaar wilt maken waarvan u weet dat hij dood is maar geen overlijdensdatum heeft, kunt u het volgende toevoegen:<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I101<br />&nbsp;&nbsp;&nbsp;#pgv_lang[accessible_by]#:&nbsp;&nbsp;#pgv_lang[PRIV_PUBLIC]#";
$pgv_lang["user_privacy"]				= "Instelling voor privacy per gebruikersnaam";
$pgv_lang["user_privacy_help"]			= "~#pgv_lang[user_privacy]#~<br /><br />Deze instellingen geven beheerders de mogelijkheid om standaard privacy-instellingen voor personen in de GEDCOM te overschrijven op basis van gebruikersnaam. Stel dat u niet wilt dat de gebruikersnaam <b>John</b> details van ID I100 in de GEDCOM kan zien, dan kunt u deze als volgt configureren:<br />&nbsp;&nbsp;&nbsp;Gebruikersnaam:&nbsp;&nbsp;John<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I100<br />&nbsp;&nbsp;&nbsp;#pgv_lang[show_question]#:&nbsp;&nbsp;#pgv_lang[hide]#<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;en details voor de opgegeven persoon zouden alleen verborgen zijn voor de gebruikersnaam «John».<br /><br />Om de details van I101 (die normaal gesproken verborgen zou zijn omdat I101 nog in leven is) te tonen aan de gebruikersnaam «John» set:<br />&nbsp;&nbsp;&nbsp;Gebruikersnaam:&nbsp;&nbsp;John<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I101<br />&nbsp;&nbsp;&nbsp;#pgv_lang[show_question]#:&nbsp;&nbsp;#pgv_lang[show]#";
$pgv_lang["global_facts"]				= "Instelling voor wereldwijde feitenprivacy";
$pgv_lang["global_facts_help"]			= "~#pgv_lang[global_facts]#~<br /><br />Deze instellingen definiëren feiten op mondiaal niveau die voor alle personen in de GEDCOM verborgen zouden moeten zijn. Dit is alleen van toepassing op feitenrecords van niveau 1, zoals BIRT of DEAT, die met hun eigen kopteksten verschijnen op het #pgv_lang[personal_facts]# tabblad van de <i>#pgv_lang[personal_details]#</i> pagina.<br /><ul><li>Het element <b>#pgv_lang[name_of_fact]#</b> bepaalt welk feit verborgen moet worden.</li><li>Het element <b>#pgv_lang[choice]#</b> specificeert het feit zelf of gerelateerde details.</li><li>Het element <b>#pgv_lang[accessible_by]#</b> bepaalt op welk toegangsniveau het feit wordt getoond.</li></ul><br />Deze functie is bedoeld om bepaalde feiten, geïdentificeerd door GEDCOM-tags, te verbergen voor alle levende of overleden personen. Standaard is de SSN-tag verborgen voor openbare gebruikers. Dit om te voorkomen dat mensen burgerservicenummers stelen en identiteitsdiefstal plegen van overleden personen. Dit is waarschijnlijk vooral relevant voor de USA.<br /><br />Als je alle huwelijken wilt verbergen voor openbare gebruikers in je GEDCOM, kun je het volgende instellen:<br />&nbsp;&nbsp;&nbsp;#pgv_lang[name_of_fact]#: (MARR) - Huwelijk<br />&nbsp;&nbsp;&nbsp;#pgv_lang[choice]#: #pgv_lang[fact_details]#<br />&nbsp;&nbsp;&nbsp;#pgv_lang[accessible_by]#: #pgv_lang[PRIV_USER]#<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Deze instellingen zouden huwelijken en gerelateerde details verbergen voor bezoekers die niet zijn ingelogd.<br /><br />In tegenstelling tot alle andere instellingen, kun je in <b>#pgv_lang[edit_exist_global_facts_settings]#</b> feiten verbergen, zelfs voor admin gebruikers. Ongewenste feiten worden volledig onderdrukt.";
$pgv_lang["person_facts"]				= "Instelling voor feitenprivacy per persoons-ID";
$pgv_lang["person_facts_help"]			= "~#pgv_lang[person_facts]#~<br /><br />Deze instellingen definiëren feiten die verborgen zijn voor een specifieke persoon, familie of bron en het niveau waarop ze verborgen zijn. Dit is alleen van toepassing op feitenrecords van niveau 1, zoals BIRT of DEAT, die met hun eigen kopteksten verschijnen op de relevante detailpagina van de persoon, het gezin of de bron.<br /><br />Het eerste element is de ID van de persoon, familie of bron. Het tweede element is het feit. Het element <b>#pgv_lang[choice]#</b> specificeert het feit zelf of gerelateerde details. Het element <b>#pgv_lang[accessible_by]#</b> bepaalt op welk toegangsniveau het feit wordt getoond. Niet alle feiten die in de lijst worden weergegeven, zijn van toepassing op alle soorten ID's. Feiten over geboorte en overlijden zijn bijvoorbeeld niet relevant voor bronrecords.<br /><br />Deze lijst is vergelijkbaar met de <b>#pgv_lang[global_facts]#</b> lijst behalve dat je ook de GEDCOM ID specificeert van de persoon voor wie je feiten wilt verbergen. U kunt bijvoorbeeld de huwelijksakte van een bepaalde persoon verbergen.";
$pgv_lang["accessible_by"]					= "Zichtbaar voor?";
$pgv_lang["hide"]							= "Verbergen";
$pgv_lang["show_question"]					= "Zichtbaar?";
$pgv_lang["user_name"]						= "Gebruikersnaam";
$pgv_lang["name_of_fact"]					= "Omschrijving gegevens";
$pgv_lang["choice"]							= "Keuze";
$pgv_lang["fact_show"]						= "Gegeven zichtbaar";
$pgv_lang["fact_details"]					= "Details gegeven zichtbaar";
$pgv_lang["privacy_header"]					= "Wijzig interne privacy instellingen";
$pgv_lang["unable_to_find_privacy_indi"]	= "Kan geen persoon met dit ID vinden";
$pgv_lang["save_and_import"]			= "Nadat u deze GEDCOM-configuratie heeft opgeslagen, moet u de GEDCOM importeren door op de knop <b>GEDCOM importeren</b> te klikken of door naar <b>Administratie --> Beheer GEDCOMs --> Import</b> te gaan";
$pgv_lang["help_info"]				= "U kunt voor elk item hulp krijgen door op het rode <b>#pgv_lang[qm]#</b> klikken naast het label voor elke cel.";
$pgv_lang["SHOW_LIVING_NAMES"]			= "Toon namen van levende mensen";
$pgv_lang["SHOW_LIVING_NAMES_help"]		= "~#pgv_lang[SHOW_LIVING_NAMES]#~<br /><br />Moeten de namen van levende mensen aan het publiek worden getoond?<br /><br />Normaal is deze instelling «#pgv_lang[PRIV_USER]#». Dit dient ter bescherming van de privacy van levende personen in uw database, omdat u kunt bepalen aan wie u algemeen toegang geeft tot uw genealogiegegevens.<br /><br />De instelling «#pgv_lang[PRIV_NONE]#» verhindert het tonen van de namen van levende mensen aan gebruikers die geen beheerdersrechten hebben.";
$pgv_lang["SHOW_RESEARCH_ASSISTANT"]			= "Toon onderzoeksassistent";
$pgv_lang["SHOW_RESEARCH_ASSISTANT_help"]		= "~#pgv_lang[SHOW_RESEARCH_ASSISTANT]#~<br /><br />Welk type gebruiker kan de onderzoeksassistentmodule bekijken als deze is geïnstalleerd?";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]		= "Gebruik relatieprivacy";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]	= "~#pgv_lang[USE_RELATIONSHIP_PRIVACY]#~<br /><br />#pgv_lang[no]#</b betekent dat geauthenticeerde gebruikers de details van alle levende mensen kunnen zien. <b>#pgv_lang[yes]#</b> betekent dat gebruikers alleen de privé-informatie kunnen zien van levende mensen aan wie ze verwant zijn.<br /><br />Deze optie stelt de standaard in voor alle gebruikers die toegang hebben tot deze genealogische database. De beheerder kan deze optie voor individuele gebruikers negeren door de accountgegevens van de gebruiker te bewerken.";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]		= "Maximale lengte van het relatiepad";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]	= "~#pgv_lang[MAX_RELATION_PATH_LENGTH]#~<br /><br />Als de optie <i>#pgv_lang[USE_RELATIONSHIP_PRIVACY]#</i> is ingeschakeld, kunnen ingelogde gebruikers alleen personen zien of bewerken binnen dit aantal relatiestappen.<br /><br />Deze optie stelt in de standaardinstelling voor alle gebruikers die toegang hebben tot deze genealogische database. De beheerder kan deze optie voor individuele gebruikers negeren door de accountgegevens van de gebruiker te bewerken.";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]		= "Controleer huwelijksrelaties";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]	= "~#pgv_lang[CHECK_MARRIAGE_RELATIONS]#~<br /><br />Controleer relaties die verband houden met het huwelijk.";
$pgv_lang["SHOW_DEAD_PEOPLE"]			= "Toon dode mensen";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]		= "~#pgv_lang[SHOW_DEAD_PEOPLE]#~<br /><br />Stel het privacytoegangsniveau in voor alle dode mensen.";
$pgv_lang["select_privacyfile_button"]		= "Selecteer het privacybestand";
$pgv_lang["PRIVACY_BY_YEAR"]		= "Beperk de privacy op basis van de leeftijd van het evenement";
$pgv_lang["PRIVACY_BY_YEAR_help"]	= "~#pgv_lang[PRIVACY_BY_YEAR]#~<br /><br />De instelling <b>#pgv_lang[PRIVACY_BY_YEAR]#</b> verbergt de details van mensen op basis van hoe oud ze waren bij specifieke evenementen, ongeacht of ze dood of levend zijn.<br /><br />Gebruik deze instelling samen met de instelling <b>#pgv_lang[MAX_ALIVE_AGE]#</b>. Als u bijvoorbeeld de leeftijdsinstelling 100 heeft gemaakt en deze optie instelt op <b>#pgv_lang[yes]#</b>, worden alle personen, levend of dood, geboren minder dan 100 jaar geleden ingesteld op privé. Mensen die minder dan 85 jaar geleden getrouwd waren en mensen die minder dan 75 jaar geleden stierven, zouden ook als privé worden aangemerkt. Houd er rekening mee dat het gebruik van deze optie uw prestaties enigszins zal vertragen.";

//-- language edit utility
$pgv_lang["lang_edit_help"]			= "~#pgv_lang[translator_tools]#~<br /><br />Deze pagina is bedoeld voor gebruik door vertalers. U kunt taalbestanden vertalen, vergelijken en exporteren. Er is ook een optie om vertalers te helpen bij het bepalen van de oorsprong van tekst die wordt uitgevoerd door PhpGedView.<br /><br />U kunt de volgende opties en hulpprogramma's gebruiken:";
$pgv_lang["edit_langdiff"]		= "Bewerk en configureer taalbestanden";
$pgv_lang["bom_check"]		= "Byte order mark (BOM) controle";
$pgv_lang["bom_check_help"]		= "~#pgv_lang[bom_check]#~<br /><br />#pgv_lang[bom_check_desc]#";
$pgv_lang["bom_check_desc"]		= "Deze controle analyseert alle taalbestanden voor de BOM (Byte Order Mark). Indien gevonden, wordt de stuklijst uit het betrokken bestand verwijderd. Deze speciale codes kunnen storingen veroorzaken in sommige delen van PhpGedView.";
$pgv_lang["lang_debug"]			= "Help-tekst opsporing";
$pgv_lang["lang_debug_help"]	= "~#pgv_lang[lang_debug]#~<br /><br />#pgv_lang[lang_debug_desc]#";
$pgv_lang["lang_debug_desc"]	= "Als u deze optie inschakelt, worden de namen van de taalvariabelen die in helptekst worden gebruikt, afgedrukt in het pop-upvenster met helptekst. Dit zal vertalers helpen de variabelenaam te bepalen wanneer tekst moet worden aangepast.<br /><br />Deze instelling is alleen geldig tijdens je huidige PhpGedView-sessie.";
$pgv_lang["lang_debug_use"]		= "Gebruik help-tekst opsporing";
$pgv_lang["bom_not_found"]		= "Er is geen BOM gevonden.";
$pgv_lang["bom_found"]			= "BOM is gevonden in ";
$pgv_lang["edit_lang_utility"]		= "Hulpprogramma voor het bewerken van taalbestanden";
$pgv_lang["edit_lang_utility_help"]	= "~#pgv_lang[edit_lang_utility]#~<br /><br />#pgv_lang[edit_lang_utility_desc]#";
$pgv_lang["edit_lang_utility_desc"]	= "U kunt dit hulpprogramma gebruiken om de inhoud van een taalbestand te bewerken door de inhoud van het Engelse te gebruiken.<br /><br />U ziet de inhoud van het originele Engelse taalbestand en de inhoud van hetzelfde bestandstype (er zijn er negen) in de door u gekozen taal. U klikt op de berichttekst die onder de Engelse versie wordt weergegeven. Dit opent een nieuw venster waarin u de tekst kunt wijzigen. U kunt de wijzigingen opslaan of ze verlaten.";
$pgv_lang["edit_lang_utility_warning"]	= "CAUTION!<br /><br />Als u de knop <b>#pgv_lang[close_window_without_refresh]#</b> gebruikt, ziet u uw wijzigingen mogelijk pas op het scherm als u een handmatige pagina opnieuw laadt. Het is mogelijk dat uw taalbestand wordt vernietigd als u een bericht toevoegt dat nog niet in het taalbestand is verschenen of als u gewoon een bericht bewerkt dat u direct eerder heeft bewerkt.<br /><br />Als u dat niet echt doet weet wat je doet, gebruik alstublieft niet de <b>#pgv_lang[close_window_without_refresh]#</b> knop.";
$pgv_lang["language_to_edit"]		= "Taal om te bewerken";
$pgv_lang["language_to_edit_help"]		= "~#pgv_lang[language_to_edit]#~<br /><br />In deze lijst selecteert u de taal waarvan u de berichten wilt bewerken.";
$pgv_lang["file_to_edit"]		= "Taalbestandstype om te bewerken";
$pgv_lang["file_to_edit_help"]			= "~#pgv_lang[file_to_edit]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["lang_file_descriptions"]			= "PhpGedView heeft ondersteuning voor veel verschillende talen geïmplementeerd.  We hebben dit kunnen bereiken door alle tekst, die voor gebruikers zichtbaar kan zijn, volledig gescheiden te houden van het hoofdprogramma.<br />Er is een set van acht bestanden voor elke ondersteunde taal. De diverse teksten zijn, afhankelijk van hun functie, verdeeld over deze acht bestanden. <b>Niet alle taalbestanden hoeven aanwezig te zijn.</b> Als een bepaalde tekst nog niet is vertaald, zal PhpGedView altijd de Engels versie gebruiken.<br /><br />De bestanden in elke talen-set zijn:<br /><ul><li><b><i>admin.xx.php</i></b>&nbsp;&nbsp;Dit bestand bevat termen en uitdrukkingen, die worden gebruikt bij het beheer van PhpGedView en de genealogische databases.</li><br /><li><b><i>configure_help.xx.php</i></b>&nbsp;&nbsp;Dit bestand bevat de Help teksten voor gebruik tijdens de configuratie van PhpGedView.  Deze Help teksten zijn niet bedoeld om te worden bekeken door de gewone gebruikers.</li><br /><li><b><i>countries.xx.php</i></b>&nbsp;&nbsp;Dit is een lijst met de namen van landen. De lijst is genomen van de Web site van de Statistics Division, United Nations Department of Economic and Social Affairs.<br />Dit is de relevante <a href=\"http://unstats.un.org/unsd/methods/m49/m49alpha.htm\" target=\"_blank\"><b>link</b></a> naar de Engelse lijst. De lijst is beschikbaar in het Engels en in het Frans.</li><br /><li><b><i>editor.xx.php</i></b>&nbsp;&nbsp;Dit bestand bevat termen en uitdrukkingen, die worden gebruikt bij het wijzigen van gegevens van de genealogische databases.</li><br /><li><b><i>facts.xx.php</i></b>&nbsp;&nbsp;Dit bestand bevat de tekstuele equivalenten van de GEDCOM Feiten codes, die staan in de GEDCOM 5.5.1 Standaard.<br />Het bevat eveneens extra Feiten codes, die niet in de Standaard staan, maar wel worden gebruikt door diverse genealogie programma's.<br /><br />Een Engelstalige kopie van de <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\"><b>GEDCOM 5.5.1 Standard</b></a> kan worden ge-download als PDF (Portable Document Format).</li><br /><li><b><i>faqlist.xx.php</i></b>&nbsp;&nbsp;FAQ is de afkorting van <b>F</b>requently <b>A</b>sked <b>Q</b>uestions. In de vertaling hebben we gekozen voor VGV: <b>V</b>eel <b>G</b>estelde <b>V</b>ragen.<br /><br />Het faqlist.xx.php bestand bevat een aantal vragen en antwoorden, die zijn verzameld door het PhpGedView ontwikkel team.  Elke VGV heeft twee vermeldingen in dit bestand. De ene vermelding is de VGV koptekst (doorgaans de vraag). De andere is de VGV tekst (doorgaans het antwoord).<br />Vervangingen voor de <b><i>faqlist.xx.php</i></b> bestanden, die regelmatig worden bijgewerkt, kunnen worden gedownload van de PhpGedView home site.<br /><br />De beheerder kan de VGV's in dit bestand gebruiken, of aanpassen, om zijn eigen VGV-lijst te maken, die beter bij zijn site past.</li><br /><li><b><i>help_text.xx.php</i></b>&nbsp;&nbsp;Dit bestand bevat de Help-teksten voor de gewone gebruikers.  Sommige Help onderwerpen zijn t.a.v. de beheerders. Deze zijn verborgen voor gebruikers, die geen beheerdersrechten hebben.</li><br /><li><b><i>lang.xx.php</i></b>&nbsp;&nbsp;Hierin staan de overige teksten en uitdrukkingen, die in het hele programma worden gebruikt.</li></ul><br />PhpGedView ondersteunt ook nog een negende taalbestand: <b><i>extra.xx.php</i></b>.  Dit bestand wordt altijd geladen <b>na</b> alle andere taalbestanden. Zodoende kan de beheerder, middels de taalvariabelen in dit bestand, elke standaard tekst in een geselecteerde taal \"overrulen\". Het kan ook worden gebruikt om voor elke taal een aangepaste titel voor uw site of voor de  genealogische databases te maken.<br /><br />De inhoud van dit extra bestand wordt geheel bepaald door de beheerder. Het bestand zal <b>nooit</b> worden verspreid met de andere taalbestanden, of een versie van PhpGedView. De beheerder zou nooit de standaard taalbestanden moeten wijzigen. Alle lokale wijzigingen moeten worden uitgevoerd in dit extra bestand.";
$pgv_lang["check"]							= "Controleer";
$pgv_lang["lang_save"]						= "Opslaan";
$pgv_lang["contents"]						= "Inhoud";
$pgv_lang["listing"]						= "Lijst";
$pgv_lang["no_content"]						= "Geen inhoud";
$pgv_lang["editlang"]						= "Wijzigen";
$pgv_lang["editlang_help"]		= "~#pgv_lang[editlang]#~<br /><br />Bewerk bericht uit taalbestand.";
$pgv_lang["savelang"]						= "Opslaan";
$pgv_lang["savelang_help"]		= "~#pgv_lang[savelang]#~<br /><br />Bewaar het bewerkte bericht in het taalbestand.";
$pgv_lang["original_message"]		= "Originele bericht";
$pgv_lang["message_to_edit"]		= "Bericht te bewerken";
$pgv_lang["changed_message"]		= "Veranderde inhoud";
$pgv_lang["message_empty_warning"]	= "-&gt; Waarschuwing!!! Dit bericht is leeg in #LANGUAGE_FILE# &lt;-";
$pgv_lang["language_to_export"]		= "Taal te exporteren";
$pgv_lang["language_to_export_help"]		= "~#pgv_lang[language_to_export]#~<br /><br />Uit deze lijst kunt u de taal en de taalbestanden selecteren waarvan u de tekst wilt exporteren.<br /><br /De uitvoer is een HTML-bestand dat u vanuit uw browser kunt afdrukken.";
$pgv_lang["export_lang_utility"]	= "Hulpprogramma voor het exporteren van taalbestanden";
$pgv_lang["export"]			= "Exporteren";
$pgv_lang["export_lang_utility_help"]	= "~#pgv_lang[export_lang_utility]#~<br /><br />#pgv_lang[export_lang_utility_desc]#";
$pgv_lang["export_lang_utility_desc"]	= "U kunt documentatie voor beheerders maken.<br /><br />Deze tool zal een HTML-versie van het geselecteerde taalbestand produceren. U kunt uw browser gebruiken om dit bestand te bekijken, dat is geformatteerd om af te drukken.";
$pgv_lang["export_ok"]			= "De taaltekst is geëxporteerd";
$pgv_lang["compare_lang_utility"]	= "Hulpprogramma voor vergelijking van taalbestanden";
$pgv_lang["compare_lang_utility_help"]	= "~#pgv_lang[compare_lang_utility]#~<br /><br />#pgv_lang[compare_lang_utility_desc]#";
$pgv_lang["compare_lang_utility_desc"]	= "Dit hulpprogramma zal twee sets taalbestanden vergelijken om een lijst te maken van de toevoegingen en aftrekkingen ertussen.<br /><br />De Engelse bestanden moeten worden gebruikt als referentie waaruit alle andere worden geproduceerd.";
$pgv_lang["new_language"]		= "Brontaal";
$pgv_lang["new_language_help"]			= "~#pgv_lang[new_language]#~<br /><br />In deze keuzelijst kunt u de taal selecteren waarvan u de berichten wilt vergelijken met die van een andere taal.<br /><br />Alle wijzigingen en toevoegingen aan taalbestanden worden eerst aangebracht in de <b>Engelse</b> taal bestanden, dus u zou normaal gesproken Engels selecteren als een van de talen om te vergelijken.";
$pgv_lang["old_language"]		= "Secundaire taal";
$pgv_lang["old_language_help"]			= "~#pgv_lang[old_language]#~<br /><br />Uit deze lijst kunt u de taal selecteren die u wilt vergelijken met de taal die is geselecteerd in de <b>#pgv_lang[new_language]#</b>> keuzelijst.<br /><br />Nadat u uw keuze heeft gemaakt, klik op de knop <b>Vergelijken</b> om een lijst te krijgen van alle optellingen en aftrekkingen in alle bestanden van beide talen.<br /><br />Om je geheugen op te frissen:<br /><b>Toevoegingen</b> betekent: het is <u>in</u> het bronbestand, maar <u>niet</u> in het secundaire bestand.<br /><br /><b>Aftrekkingen</b> betekent: Het staat <u>niet</u> in het bronbestand, maar het <u>is </u> in het secundaire bestand. Dit kan gebeuren wanneer een bepaald bericht niet langer wordt gebruikt en daarom uit de Engelse bestanden is verwijderd. U kunt het bijbehorende bericht veilig verwijderen uit de secundaire taalbestanden.";
$pgv_lang["compare"]			= "Vergelijken";
$pgv_lang["comparing"]			= "Taalbestanden die worden vergeleken";
$pgv_lang["additions"]			= "Toevoegingen";
$pgv_lang["no_additions"]		= "Geen toevoegingen";
$pgv_lang["subtractions"]		= "Aftrekkingen";
$pgv_lang["no_subtractions"]		= "Geen aftrekkingen";
$pgv_lang["config_lang_utility"]	= "Configuratie van ondersteunde talen";
$pgv_lang["config_lang_utility_help"]	= "~#pgv_lang[config_lang_utility]#~<br /><br />Deze pagina wordt gebruikt om te bepalen welke taalkeuzes beschikbaar zijn voor uw gebruikers. U kunt bijvoorbeeld dingen zo instellen dat alleen Duits en Frans beschikbaar zijn. Dit kan handig zijn als u bijvoorbeeld niet in het Hongaars met uw gebruikers kunt communiceren.<br /><br />U gebruikt deze pagina ook om bepaalde aspecten van PhpGedView te wijzigen die afhankelijk zijn van de geselecteerde taal. Hier vertel je PhpGedView bijvoorbeeld hoe datum- en tijdvelden moeten worden opgemaakt.<br /><br />De talen die actief en grijs zijn, kunnen niet worden uitgeschakeld omdat ze in gebruik zijn. Kijk naar de onderste tabel om te zien waar de taal wordt gebruikt. Wanneer een taal niet langer wordt gebruikt door de GEDCOM of gebruiker, kunt u deze uitschakelen.<br /><br />Al uw wijzigingen worden opgenomen in een nieuw bestand genaamd <b>lang_settings.php</b gemaakt in de map <b>#INDEX_DIRECTORY#</b>. Al uw verdere wijzigingen zullen in dit nieuwe bestand worden aangebracht en PhpGedView zal alleen <u> dit </u> bestand gebruiken. U kunt terugkeren naar de oorspronkelijke standaard taalinstellingen door dit bestand te verwijderen.<br /><br />Als u problemen met uw taalinstellingen moet melden, laat het PhpGedView-ondersteuningsteam dan weten of dit nieuwe bestand aanwezig is of niet.";
$pgv_lang["active"]			= "Actief";
$pgv_lang["active_help"]		= "~#pgv_lang[active]#~<br /><br />Laat gebruikers deze taal selecteren als de optie <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b> is ingeschakeld.";
$pgv_lang["edit_settings"]		= "Bewerk instellingen";
$pgv_lang["lang_edit"]			= "Bewerk";
$pgv_lang["lang_language"]		= "Taal";
$pgv_lang["export_filename"]		= "Naam van uitvoerbestand:";
$pgv_lang["lang_back"]			= "Keer terug naar het hoofdmenu om taalbestanden te bewerken en te configureren";
$pgv_lang["lang_back_admin"]		= "Keer terug naar het beheermenu";
$pgv_lang["lang_back_manage_gedcoms"]	= "Keer terug naar het GEDCOM-beheermenu";
$pgv_lang["lang_name_arabic"]				= "Arabisch";
$pgv_lang["lang_name_catalan"]				= "Catalaans (Valenciaans)";
$pgv_lang["lang_name_chinese"]				= "Chinees (Traditioneel)";
$pgv_lang["lang_name_chinese-cn"]			= "Chinees (Vereenvoudigd)";
$pgv_lang["lang_name_croatian"]				= "Kroatisch";
$pgv_lang["lang_name_czech"]				= "Tsjechisch";
$pgv_lang["lang_name_danish"]				= "Deens";
$pgv_lang["lang_name_dutch"]				= "Nederlands";
$pgv_lang["lang_name_english"]				= "Engels";
$pgv_lang["lang_name_estonian"]				= "Estlands";
$pgv_lang["lang_name_finnish"]				= "Fins";
$pgv_lang["lang_name_french"]				= "Frans";
$pgv_lang["lang_name_german"]				= "Duits";
$pgv_lang["lang_name_greek"]				= "Grieks";
$pgv_lang["lang_name_hebrew"]				= "Hebreeuws";
$pgv_lang["lang_name_hungarian"]			= "Hongaars";
$pgv_lang["lang_name_indonesian"]			= "Indonesisch";
$pgv_lang["lang_name_italian"]				= "Italiaans";
$pgv_lang["lang_name_lithuanian"]			= "Litouws";
$pgv_lang["lang_name_norwegian"]			= "Noors";
$pgv_lang["lang_name_polish"]				= "Pools";
$pgv_lang["lang_name_portuguese"]			= "Portugees";
$pgv_lang["lang_name_romanian"]				= "Romaans";
$pgv_lang["lang_name_russian"]				= "Russisch";
$pgv_lang["lang_name_serbian-la"]			= "Servisch (Latijns alfabet)";
$pgv_lang["lang_name_slovak"]				= "Slowaaks";
$pgv_lang["lang_name_slovenian"]			= "Sloweens";
$pgv_lang["lang_name_spanish"]				= "Spaans";
$pgv_lang["lang_name_spanish-ar"]			= "Spaans (Latijns-Amerikaans)";
$pgv_lang["lang_name_swedish"]				= "Zweeds";
$pgv_lang["lang_name_turkish"]				= "Turks";
$pgv_lang["lang_name_vietnamese"]			= "Vietnamees";
$pgv_lang["lang_name_unknown"]				= "Geen van deze talen";		// used ONLY in "Find Special Characters"
$pgv_lang["lang_new_language"]				= "Nieuwe taal";
$pgv_lang["original_lang_name"]				= "Originele naam van de taal in het #D_LANGNAME#";
$pgv_lang["original_lang_name_help"]	= "~Originele naam van de taal~<br /><br />Hoe heet deze taal in deze taal?<br /><br />Engels noemt zichzelf <b>English</b>; Duits noemt zichzelf <b>Deutsch</b>; Nederlands noemt zichzelf <b>Nederlands</b>; Tsjech noemt zichzelf <b>Ceština</b>, etc.";
$pgv_lang["lang_shortcut"]		= "Afkorting voor taalbestanden";
$pgv_lang["lang_shortcut_help"]		= "~#pgv_lang[lang_shortcut]#~<br /><br />Deze code definieert een afkorting voor de taalnaam. Deze afkorting maakt deel uit van de naam van elk van de taalbestanden die door PhpGedView worden gebruikt. Bijvoorbeeld, de afkorting die voor frans wordt gebruikt is <b>fr</b>, en bijgevolg zijn de bestandsnamen voor frans <i>admin.<b>fr</b>.php</i>, <i>configure_help.<b>fr</b>.php</i>, <i>countries.<b>fr</b>.php</i>, <i>editor.<b>fr</b>.php</i>, <i>facts.<b>fr</b>.php</i>, <i>help_text.<b>fr</b>.php</i>, en <i>lang.<b>fr</b>.php</i>";
$pgv_lang["lang_langcode"]		= "Taaldetectiecodes";
$pgv_lang["lang_langcode_help"]		= "~#pgv_lang[lang_langcode]#~<br /><br />Met deze codes kan PhpGedView de voorkeurstaalinstelling van de gebruikte browser detecteren. PhpGedView bepaalt de taal die daadwerkelijk door de browser wordt aangevraagd door de taalcode van de browser te vergelijken met deze lijst. Lijstitems moeten worden gescheiden door een puntkomma.";
$pgv_lang["lang_filenames"]		= "Taalbestanden";
$pgv_lang["lang_filenames_help"]		= "~#pgv_lang[lang_filenames]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["flagsfile"]			= "Vlagbestand";
$pgv_lang["flagsfile_help"]		= "~#pgv_lang[flagsfile]#~<br /><br />Naam van het afbeeldingsbestand van de nationale vlag voor de geselecteerde taal.<br /><br />Afbeeldingen voor veel landen zijn beschikbaar via <a href=\"http://w3f.com/gifs/index.html\"><b>The WWWeb Factory</b></a> site.<br /><br />Wanneer u een vlagafbeelding vindt die u bevalt, klikt u er met de rechtermuisknop op en slaat u de afbeelding op in een tijdelijke map. Open vervolgens de opgeslagen afbeelding met een geschikte afbeeldingseditor (IrfanView wordt aanbevolen voor Windows-systemen), verklein de grootte met 50x32 pixels, wat de normale grootte is die wordt gebruikt in PhpGedView, en sla het vervolgens op als een GIF-bestand op de <i><b>images/flags</b></i>. U kunt elke gewenste naam gebruiken.";
$pgv_lang["text_direction"]		= "Tekstrichting";
$pgv_lang["text_direction_help"]	= "~#pgv_lang[text_direction]#~<br /><br />Geeft aan welke richting wordt gebruikt om tekst in de gekozen taal te schrijven. De meeste talen worden van links naar rechts geschreven. Arabisch en Hebreeuws zijn voorbeelden van talen die in de tegenovergestelde richting zijn geschreven (van rechts naar links).";
$pgv_lang["date_format"]					= "Datumformaat";
$pgv_lang["date_format_help"]				= "~#pgv_lang[date_format]#~<br /><br />Verschillende landen hebben verschillende manieren om de datum te tonen. In het Nederlands is dit standaard \"Dag Maand Jaar\", terwijl in het Engels vaak \"Maand Dag Jaar\" wordt gehanteerd.<br /><br />Met deze optie stelt u in, hoe PhpGedView de datum in de gekozen taal toont. Dit betreft zowel datumweergave vanuit PhpGedView als de weergave van datums die in de gegevens voorkomen.<br />U kunt het <b>Standaard</b> of het <b>Geavanceerde</b> formaat gebruiken.<ul><li><b>Standaard</b><br />De volgende codes worden gebruikt om verschillende elementen van een datum te representeren.  Opmerking: <b>D</b> en <b>M</b> hebben een andere betekenis in het <b>Geavanceerde</b> formaat.<p style=\"padding-left: 25px\"><b>D</b>&nbsp;&nbsp;dag v.d. maand, zonder voorafgaande nullen: 1 t/m 31<br /><b>M</b>&nbsp;&nbsp;naam v.d. maand: Januari, Februari, enz.<br /><b>Y</b>&nbsp;&nbsp;volledig geschreven jaar, bijv. 1999 of 44V.C.<br /><b>R</b>&nbsp;&nbsp;Kalender Conversie.  Zie verder het onderwerp: <b>Kalender Conversie</b>, iets naar beneden, voor uitleg van deze code.</p>Deze codes kunnen in elke volgorde worden gecombineerd, compleet met spaties en/of punten.<br />Bijv.: We nemen aan dat uw GEDCOM de datum 20&nbsp;AUG&nbsp;1965 bevat.<p style=\"padding-left: 25px\">Een <b>Nederlandse</b> gebruiker kan het formaat instellen op <b>D&nbsp;M&nbsp;Y</b> en krijgt dan <b>20&nbsp;August&nbsp;1965</b>.<br />Een <b>Amerikaanse</b> gebruiker kan het formaat instellen op <b>M&nbsp;D,&nbsp;Y</b> om dan <b>August&nbsp;20,&nbsp;1965</b> te krijgen<br />Een <b>Duitse</b> gebruiker kan het formaat instellen op <b>D.&nbsp;M&nbsp;Y</b> en krijgt dan <b>20.&nbsp;August&nbsp;1965</b><br />Een <b>Hongaarse</b> gebruiker kan het formaat instellen op <b>Y.&nbsp;M&nbsp;D.</b> en krijgt dan <b>1965.&nbsp;augusztus&nbsp;20.</b></p><br /></li><li><b>Geavanceerd</b><br />Complexere formatteer opties zijn beschikbaar.</b>Als uw datum formaat een andere letter dan <b>D</b>, <b>M</b>, <b>Y</b>, of <b>R</b> bevat, wordt autmatisch het <b>Geavanceerde</b> formaat toegepast.<br /><br />De volgende codes worden gebruikt om verschillende elementen van een datum te representeren.  Opmerking: <b>D</b> en <b>M</b> hebben een andere betekenis in het <b>Standaard</b> formaat.<p style=\"padding-left: 25px\"><b>d</b>&nbsp;&nbsp;dag v.d. maand, met voorafgaande nullen:  01 t/m 31<br /><b>j</b>&nbsp;&nbsp;dag v.d. maand, zonder voorafgaande nullen: 1 t/m 31<br /><b>S</b>&nbsp;&nbsp;rangtelwoord achtervoegsel voor een dag-nummer, bijv., de letters <b>th</b> in <b>4th&nbsp;July</b>.<br /><b>l</b> (kleine «L»)&nbsp;&nbsp;dag v.d. week: Maandag, Dinsdag, enz.<br /><b>D</b>&nbsp;&nbsp;afkorting van de dag v.d. week: M, Di, W, Do, V, Za, Zo<br /><b>N</b>&nbsp;&nbsp;ISO dag nummer: 0 t/m 6<br /><b>w</b>&nbsp;&nbsp;nummeriek dag nummer: 1 t/m 7<br /><b>z</b>&nbsp;&nbsp;dag v.h. jaar: 1 t/m 365 (366)<br /><b>F</b>&nbsp;&nbsp;maand naam: Januari, Februari, enz.<br /><b>M</b>&nbsp;&nbsp;afkorting v.d. maand: Jan, Feb, enz.<br /><b>m</b>&nbsp;&nbsp;maand nummer, met voorafgaande nul: 01 t/m 12<br /><b>n</b>&nbsp;&nbsp;maand nummer, zonder voorafgaande nul: 1 t/m 12<br /><b>Y</b>&nbsp;&nbsp;volledig geschreven jaar, bijv. 1999 of 44V.C.<br /><b>y</b>&nbsp;&nbsp;afkorting van het jaar.  Bij sommige kalenders mag het jaar worden afgekort.  Bij de Joodse kalender is dit het jaar, zonder de duizendtallen.  Bij de Gregoriaanse kalender is dit hetzelfde als het volledige jaar.<br /><b>R</b>&nbsp;&nbsp;Kalender Conversie.  Zie verder het onderwerp: <b>Kalender Conversie</b>, iets naar beneden, voor uitleg van deze code.<br /><b>@&nbsp;A&nbsp;O&nbsp;E</b>&nbsp;&nbsp;intern GEDCOM formaat</p><p style=\"padding-left: 50px\"><b>@</b>&nbsp;&nbsp;kalender code, bijv.: @#DGREGORIAN@, @#DHEBREW@, enz.<br /><b>A</b>&nbsp;&nbsp;da: 01 t/m 31<br /><b>O</b>&nbsp;&nbsp;maand: JAN, FEB, MAR, enz.<br /><b>E</b>&nbsp;&nbsp;jaar: 1776, 1867, 2007, enz.<br /><br />Om de niet-geconverteerde data te zien, gebruik: <b>A&nbsp;O&nbsp;E</b> of <b>@&nbsp;A&nbsp;O&nbsp;E</b></p><b>Enkele voorbeelden</b>, we nemen de datum 08&nbsp;SEP&nbsp;1965:<p style=\"padding-left: 25px\"><b>d&nbsp;M&nbsp;Y</b> = 08&nbsp;Sep&nbsp;1965<br /><b>D&nbsp;j&nbsp;F&nbsp;Y</b> = W&nbsp;8&nbsp;September&nbsp;1965<br /><b>j&nbsp;M&nbsp;y</b> = 8&nbsp;Sep&nbsp;65<br /><b>l&nbsp;-&nbsp;d&nbsp;-&nbsp;F&nbsp;-&nbsp;Y</b> = Woensdag&nbsp;-&nbsp;08&nbsp;-&nbsp;September&nbsp;-&nbsp;1965<br /><b>y/m/d</b> = 1965/09/08</p><br /></li></ul>#pgv_lang[date_format_help2]#";
$pgv_lang["date_format_help2"]				= "<ul><li><b>Kalender Conversie</b><br />De code <b>R</b> is enigszins ongebruikelijk in z'n gedrag.  Als deze code voorkomt in het datum formaat, wordt de gewone datum een 2de keer getoond, maar volgens een ander kalender systeem.<br />De elementen van deze andere kalender volgen dezelfde regels als die van de gewone formaat specificatie, behalve dat de output van de <b>R</b> formaat code is ingesloten door haakjes om het van de reguliere datum te onderscheiden.<br />De voorbeelden, gegeven bij de <b>Franse Revolutionaire</b> kalender, zullen dit iets duidelijker maken.<br /><br />Welke alternatieve kalender wordt toegepast, als de <b>R</b> code wordt gebruikt, is afhankelijk van de huidge taal van de pagina's.  Als de gebruikte taal Hebreeuws is, zal de <b>Joodse</b> kalender worden gebruikt.  Als de huidige taal Arabisch is, zal de <b>Hijri</b> kalender worden gebruikt.  Voor alle overige talen zal de  <b>Franse Revolutionaire</b> kalender worden gebruikt.<br /><br />De actie van de code is gelijk aan de keuze van het kalender formaat, dat u kunt maken op de GEDCOM Instellingen pagina.<br />Het verschil tussen de twee methodes is:<br />De <b>R</b> code, ingesteld op het nivo Taal Instellingen, werkt alleen bij de geselecteerde talen, maar bij alle GEDCOMs op de site.<br />De kalender optie, ingesteld op het nivo GEDCOM Instellingen, werkt bij alle talen, maar alleen bij die GEDCOMs, waarvoor die optie is ingesteld.<br /><ul><li><b>Franse Revolutionaire</b> kalender.&nbsp;&nbsp;Deze kalender wordt ook wel de <b>Franse Republikeinse</b> kalender genoemd.<br /><br />Behalve een zeer korte periode in Mei 1871, was dit kalender systeem allen in gebruik in Frankrijk en dan ook alleen maar tussen 22&nbsp;SEP&nbsp;1792 and 31&nbsp;DEC&nbsp;1805.<br />Als gevolg daarvan is het Franse Revolutionaire kalender-formaat alleen van toepassing indien een datum binnen dat bereik valt.<br /><br />Twee voorbeelden van dit datum formaat, hierbij wordt er vanuit gegaan dat de huidige taal is ingesteld op Nederlands, verduidelijken de actie van de <b>R</b> code:<br /><b>Y.m.d&nbsp;R</b> kan resulteren in <b>1805.04.26&nbsp;(XIII.08.06)</b> of <b>1806.01.01</b><br /> <b>j&nbsp;F&nbsp;Y&nbsp;R</b> kan resulteren in <b>13&nbsp;Oktober&nbsp;1797&nbsp;(22&nbsp;Vendémiaire&nbsp;VI)</b> of <b>1&nbsp;Januari&nbsp;1806</b>.</li></ul><br /></li><li><b>Taal alternatieven</b><br />De afgekorte tekst voor de Geadvanceerde codes <b>D</b> en <b>M</b> zijn ingesteld in het bestand <i>languages/lang.xx.php</i>, door declaraties te gebruiken zoals:<br /><code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"Su\";<br />\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"April\";</code><br /><br />Deze kunnen worden gewijzigd door een <i>languages/extra.xx.php</i> bestand te gebruiken, zoals is omschreven in Wiki en ReadMe tekst voor taalaanpassingen, bijvoorbeeld:<br /><code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"Sun\";<br />\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"Apr\";</code></li><br /><li><b>Lokalisatie</b><br />Voor een aantal talen zijn er speciale formattering regels., in het bijzonder verbuigingen van de maandnamen, afhankelijk hoe de datum wordt uitgesproken.  Deze speciale regels zijn opgenomen in de diverse <i>includes/extras/functions.xx.php</i> bestanden.</li></ul>";
$pgv_lang["time_format"]					= "Tijdformaat";
$pgv_lang["time_format_help"]				= "~#pgv_lang[time_format]#~<br /><br />Dit veld definieert het tijdformaat dat door PhpGedView moet worden gebruikt.<br /><br />Symbolen die u kunt gebruiken zijn:<br /><b>a</b> - kleine letters Ante meridiem en Post meridiem; d.w.z. <b>am</b> of <b>pm</b><br /><b>A</b> - hoofdletters Ante meridiem en Post meridiem; d.w.z. <b>AM</b> of <b>PM</b><br /><b>B</b> - Swatch Internettijd; d.w.z. <b>00</b> tot <b>999</b><br /><b>c</b> - ISO 8601-datum; bijv. <b>2004-02-12T15:19:21+00:00</b><br /><b>d</b> - dag van de maand, 2 cijfers, voorloopnul; d.w.z. <b>01</b> tot <b>31</b><br /><b>D</b> - dag, tekstueel, drie letters; bijv. <b>maa</b><br /><b>F</b> - maand, tekstueel, lang; bijv. <b> januari </b><br /><b>g</b> - uur, 12-uurs formaat, geen voorloopnul; d.w.z. <b>1</b> tot <b>12</b><br /><b>G</b> - uur, 24-uurs indeling, geen voorloopnul; d.w.z. <b>0</b> tot <b>23</b><br /><b>h</b> - uur, 12-uurs formaat, voorloopnul; d.w.z. <b>01</b> tot <b>12</b><br /><b>H</b> - uur, 24-uurs formaat, voorloopnul; d.w.z. <b>00</b> tot <b>23</b><br /><b>i</b> - minuten, voorloopnul; d.w.z. <b>00</b> tot <b>59</b><br /><b>I</b> (groote «i») - zomertijd indicator; <b>1</b> indien zomertijd, <b>0</b> anders.<br /><b>j</b> - dag van de maand, geen voorloopnul; d.w.z. <b>1</b> tot <b>31</b><br /><b>l</b> (kleine «L») - dag van de week, tekstueel, lang; bijv. <b>Vrijdag</b><br /><b>L</b> - schrikkeljaar indicator; <b>1</b> als het een schrikkeljaar is, anders <b>0</b>.<br /><b>m</b> - maand, numeriek, voorloopnul; d.w.z. <b>01</b> tot <b>12</b><br /><b>M</b> - maand, tekstueel, 3 letters; bijv. <b>Jan</b><br /><b>n</b> - maand, numeriek, geen voorloopnul; d.w.z. <b>1</b> tot <b>12</b><br /><b>O</b> (groote «o») - verschil tussen lokale tijd en Greenwich-tijd (GMT) in uren; bijv. <b>+0200</b><br /><b>r</b> - RFC 2822 geformatteerde datum; bijv. <b>don,&nbsp;21&nbsp;dec&nbsp;2000&nbsp;16:01:07&nbsp;+0200</b><br /><b>s</b> - seconden, voorloopnul; d.w.z. <b>00</b> tot en met <b>59</b><br /><b>S</b> - achtervoegsel dag van de maand, alleen Engels, 2 tekens; d.w.z. <b>st</b>, <b>nd</b>, <b>rd</b> of <b>th</b>. Past goed bij <b>j</b><br /><b>t</b> - aantal dagen in de opgegeven maand; d.w.z. <b>28</b> tot <b>31</b><br /><b>T</b> - tijdzone-instelling van deze machine; bijv. <b>CEST</b>, <b>EST</b>, <b>MDT</b><br /><b>U</b> - seconden sinds het begin van de Unix Epoch (1&nbsp;januar&nbsp;1970&nbsp;00:00:00 GMT)<br /><b>w</b> - dag van de week, numeriek; d.w.z. <b>0</b> (zondag) tot <b>6</b> (zaterdag)<br /><b>W</b> - ISO 8601 weeknummer van het jaar, weken beginnend op maandag; bijv. <b>42</b> (de 42e week van het jaar)<br /><b>Y</b> - jaar, 4 cijfers; bijv. <b>1999</b><br /><b>y</b> - jaar, 2 cijfers; bijv. <b>99</b><br /><b>z</b> - dag van het jaar, numeriek, geen voorloopnullen; d.w.z. <b>0</b> (1 jan) tot <b>364</b> (31 dec wanneer geen schrikkeljaar) of <b>365</b> (31 dec in schrikkeljaren)<br /><b>Z</b> - tijdzoneverschil in seconden. De afwijking voor tijdzones ten westen van Greenwich is altijd negatief, en voor tijdzones ten oosten van Greenwich is de afwijking altijd positief. d.w.z. <b>-43200</b> tot <b>43200</b><br /><br />You can change the order of these symbols, and you can add delimiters to the format.<br />In het Duits bevat dit veld bijvoorbeeld normaal bevat <b>H:i:s</b> om een display als <b>09:01:25</b> te produceren.<br />Engels definieert de tijdnotatie meestal als <b>g:i:sa</b> om een display als <b>9:01:25am</b> te produceren.<br /><br />In het 24-uursysteem is middernacht 00:00. In het 12-uursysteem middernacht is 12.00am en middag is 12.00pm.";
$pgv_lang["week_start"]			= "Begindag van de week";
$pgv_lang["week_start_help"]		= "~#pgv_lang[week_start]#~<br /><br />De dag van de week waarop een nieuwe week begint in deze taal. De meeste talen beginnen de week op zondag, maar sommige beginnen op maandag of andere dagen.";
$pgv_lang["name_reverse"]		= "Achternaam eerst";
$pgv_lang["name_reverse_help"]		= "~#pgv_lang[name_reverse]#~<br /><br />In sommige talen moet de achternaam als eerste worden weergegeven in plaats van de standaardnaam om deze als laatste weer te geven. Als u deze optie inschakelt, wordt de achternaam eerst weergegeven. Hongaars, Chinees en Japans zijn voorbeelden waarbij de achternaam (de familienaam) meestal als eerste wordt vermeld.";
$pgv_lang["ltr"]			= "Links naar rechts";
$pgv_lang["rtl"]			= "Rechts naar links";
$pgv_lang["file_does_not_exist"]	= "FOUT! Het bestand bestaat niet...";
$pgv_lang["optional_file_not_exist"]	= "Dit optionele bestand bestaat niet.";
$pgv_lang["alphabet_upper"]		= "Alfabet in hoofdletters";
$pgv_lang["alphabet_upper_help"]	= "~#pgv_lang[alphabet_upper]#~<br /><br />Alfabetletters in hoofdletters in deze taal. Dit alfabet wordt gebruikt bij het sorteren van namenlijsten.";
$pgv_lang["alphabet_lower"]		= "Alfabet in kleine letters";
$pgv_lang["alphabet_lower_help"]	= "~#pgv_lang[alphabet_lower]#~<br /><br />Kleine letters van het alfabet in deze taal. Dit alfabet wordt gebruikt bij het sorteren van namenlijsten.";
$pgv_lang["multi_letter_alphabet"]		= "Alfabet met meerdere letters";
$pgv_lang["multi_letter_alphabet_help"]	= "~#pgv_lang[multi_letter_alphabet]#~<br /><br />Combinaties van meerdere letters die als één afzonderlijke letter moeten worden behandeld bij het sorteren van lijsten met namen en titels in deze taal.<br /><br />Sommige talen, bijvoorbeeld Hongaars en Slowaaks, beschouwen bepaalde combinaties van letters als verschillend letters in hun eigen recht. De volgorde waarin u deze lettercombinaties opgeeft, bepaalt de volgorde waarin ze tijdens het sorteren in het normale alfabet worden ingevoegd. Dit is belangrijk als meerdere combinaties van meerdere letters dezelfde eerste letter hebben. Met uitzondering van <b>ch</b>, worden deze lettercombinaties ingevoegd in het normale alfabet volgens hun eerste letter. <b>ch</b> wordt altijd ingevoegd na <b>h</b>.";
$pgv_lang["multi_letter_equiv"]		= "Meerletterige equivalenten";
$pgv_lang["multi_letter_equiv_help"]	= "~#pgv_lang[multi_letter_equiv]#~<br /><br />In sommige talen worden bij het genereren van namenlijsten vaak meerdere letters behandeld als equivalent aan een enkele letter.<br /><br />In het Nederlands worden namen die beginnen met <b>IJ</b> bijvoorbeeld samen weergegeven met namen die beginnen met <b>Y</b>. In het Noors worden namen die beginnen met <b>Aa</b> weergegeven met <b>&Aring;</b>. In sommige talen zijn er letters die als één of twee tekens kunnen worden geschreven. In het Slowaaks kunnen de twee tekens D en \xC5\xBE bijvoorbeeld worden geschreven als het enkele teken \xC7\x85. Door hier equivalenten op te geven, kunt u toestaan dat namen die met deze letters beginnen, worden gegroepeerd op de persoonslijstpagina's.<br /><br />U moet een door komma's gescheiden lijst van equivalenten specificeren. Om databases te ondersteunen die UTF-8-codering niet herkennen, moet u zowel hoofdletters als kleine letters specificeren. Dit voorbeeld toont het te gebruiken formaat.<br /><br />Aa=&Aring;,aa=&aring;";
$pgv_lang["dictionary_sort"]		= "Gebruik woordenboekregels tijdens het sorteren";
$pgv_lang["dictionary_sort_help"]	= "~#pgv_lang[dictionary_sort]#~<br /><br />Deze optie bepaalt hoe tekens met diakritische tekens worden behandeld bij het sorteren van lijsten met namen en titels.<br /><br />Indien ingesteld op <b>#pgv_lang[yes]#</b>, worden alle tekens met diakritische tekens behandeld alsof ze geen merktekens hadden. Diakritische tekens worden alleen in aanmerking genomen als de twee beschouwde woorden verder identiek zijn. Indien ingesteld op <b>#pgv_lang[no]#</b>, zijn alle letters verschillend, ongeacht de aanwezigheid of afwezigheid van diakritische tekens.";
$pgv_lang["collation"]		= "Volgorde van het sorteren van databases";
$pgv_lang["collation_help"]	= "~#pgv_lang[collation]#~<br /><br />Als u de ingebouwde sorteerregels van de database gebruikt, specificeert deze optie de sorteervolgorde die voor deze taal moet worden gebruikt. U moet ervoor zorgen dat uw database alle sorteervolgordes ondersteunt die u wilt gebruiken.<br /><br />Het gebruik van het sorteren van databases wordt beheerd in de configuratie-instellingen van de site.";
$pgv_lang["lang_config_write_error"]	= "Fout bij het schrijven van taalinstellingen naar het bestand <i>language_settings.php</i>. Controleer de rechten en probeer het opnieuw.";
$pgv_lang["lang_set_file_read_error"]	= "F O U T !!! Kon <i>language_settings.php</i> niet lezen!";
$pgv_lang["add_new_language_help"]	= "~#pgv_lang[add_new_language]#~<br /><br />#pgv_lang[add_new_language_desc]#";
$pgv_lang["add_new_language_desc"]	= "Met deze routine kunt u een nieuwe, voorheen niet beschikbare en volledig niet-ondersteunde taal toevoegen aan PhpGedView.<br /><br />U kunt de standaardinstellingen van de nieuwe taal instellen. Deze omvatten taaldetectiecode, taalrichting, begin van de week voor deze taal, tijdinstellingen, alfabet, etc.<br /><br />U krijgt meer hulp bij de instellingen van talen die door PhpGedView worden ondersteund nadat u de taal hebt geselecteerd en klikken op de <b>#pgv_lang[add_new_lang_button]#</b> knop.<br /><br />Meer hulp is beschikbaar op de Configuratie pagina voor de taal.";
$pgv_lang["add_new_lang_button"]	= "Nieuwe taal toevoegen";
$pgv_lang["hide_translated"]		= "Verberg vertaald";
$pgv_lang["hide_translated_help"]		= "~#pgv_lang[hide_translated]#~<br /><br />Indien ingesteld op <b>#pgv_lang[yes]#</b>, ziet u alleen die berichten van uw geselecteerde taalbestand die niet zijn vertaald. Dit betekent dat het nieuwe bericht <u>niet</u> verschijnt in het doeltaalbestand.<br /><br />Sommige taalbestanden bevatten Engelse tekst voor verschillende niet-vertaalde berichten. Deze routine kan deze onvertaalde items niet identificeren, aangezien ze al aanwezig zijn in het doelbestand. De aanname is: «Als het bericht aanwezig is in het doelbestand, moet het zijn vertaald.»";
$pgv_lang["lang_file_write_error"]	= "F O U T !!! Kan geen wijzigingen naar het geselecteerde taalbestand schrijven. Controleer de schrijfrechten voor <b>#lang_filename#</b>";
$pgv_lang["no_open"]	= "F O U T !!! Kan bestand <b>#lang_filename#</b> niet openen";
$pgv_lang["users_langs"]			= "Gebruikers talen";
$pgv_lang["configured_languages"]	= "Gebruikte talen";

//-- User Migration Tool messages
$pgv_lang["um_header"] = "Hulpprogramma voor migratie van gebruikersinformatie";
$pgv_lang["um_proceed"] = "Kies een optie of klik op de onderstaande link om terug te keren naar het menu Beheer";
$pgv_lang["um_creating"] = "Creëren";
$pgv_lang["um_sql_index"] = "Deze tool zal <i>authenticate.php</i> en verschillende <i>.dat</i> bestanden aanmaken in je index map.<br /><br />Na succesvolle creatie kun je overschakelen naar de Index-modus met alle huidige gebruikers en hun berichten, favorieten, nieuws en MyGedview-lay-out beschikbaar.<br /><br />Opmerking: na het overschakelen naar de Index-modus, moet u uw GEDCOM-bestanden opnieuw importeren.";
$pgv_lang["um_file_create_fail1"] = "Het aanmaken van een nieuw bestand is mislukt, er bestaat al een bestand met die naam:";
$pgv_lang["um_file_create_fail2"] = "Kan niet maken";
$pgv_lang["um_file_create_fail3"] = "Controleer de toegangsrechten op deze map.";
$pgv_lang["um_file_create_succ1"] = "Aanmaak van nieuw bestand geslaagd:";
$pgv_lang["um_file_not_created"] = "Bestand is niet gemaakt.";
$pgv_lang["um_nomsg"] = "Er lijken geen berichten in het systeem aanwezig te zijn.";
$pgv_lang["um_nofav"] = "Er lijken geen favorieten in het systeem aanwezig te zijn.";
$pgv_lang["um_nonews"] = "Er lijkt geen nieuws in het systeem aanwezig te zijn.";
$pgv_lang["um_noblocks"] = "Er lijken geen blokken in het systeem aanwezig te zijn.";
$pgv_lang["um_index_sql"] = "Deze tool importeert <i>authenticate.php</i> en andere <i>.dat</i> bestanden uit je index map in je database.";
$pgv_lang["um_noaction"] = "U hoeft niets te doen om gebruikersinformatie naar de SQL-modus te migreren.<br /><br />Zodra u bent overgeschakeld naar de SQL-modus, moet u de <b>#pgv_lang[um_header]#</b> opnieuw starten om alle gegevens in de SQL-database te importeren. PhpGedView gebruikt bestaande bestanden uit de indexmodus.<br /><br /><b>Verwijder <u>niet</u> <i>authenticate.php</i> en <i>.dat</i> bestanden uit uw indexmap tijdens het schakelen.</b>";
$pgv_lang["um_import"] = "Importeren";
$pgv_lang["um_export"] = "Exporteren";
$pgv_lang["um_explain"] = "Deze tool exporteert gebruikersgegevens van SQL naar Index-modus of importeert gebruikersgegevens uit Index-bestanden in SQL-tabellen.<br /><br />Gebruikersgegevens, favorieten, blokdefinities, berichten en nieuws zullen na migratie weer beschikbaar zijn.<br /><br /><b>LET OP</b><br />U kunt deze tool niet gebruiken om gebruikersgegevens tussen verschillende versies van PhpGedView te migreren. Zorg ervoor dat de gegevens afkomstig zijn van, of zijn geïmporteerd in dezelfde PhpGedView-versie.<br /><br /><b>IMPORTEREN</b><br />Als u ervoor kiest om de gebruikersgegevensbestanden te importeren vanuit de indexmodus, alle gebruikersgegevens die in de databasetabellen aanwezig zijn, worden <u>overschreven</u>. Deze tool voegt de informatie <u>niet</u> samen. Nadat u de import heeft uitgevoerd, is er geen manier om de oude informatie op te halen met PhpGedView.<br /><br /><b>EXPORT</b><br />Als u de gebruikersinformatie uit uw SQL-database exporteert naar Index Mode-bestanden, deze tool zal <i>authenticate.php</i> en verschillende <i>.dat</i> bestanden in uw index map maken. Als er al identieke bestanden aanwezig zijn, wordt u gevraagd of ze moeten worden overschreven. Nadat u bent overgeschakeld naar de Index-modus, is alle informatie direct beschikbaar.<br /><br /><b>Opmerking:</b> Nadat u naar de Index-modus bent overgeschakeld, moet u uw GEDCOM-bestanden opnieuw importeren.";
$pgv_lang["um_tool_help"] = "~#pgv_lang[um_header]#~<br /><br />#pgv_lang[um_explain]#";
$pgv_lang["um_sql_index_help"] = "~Migreer gebruikers van SQL- naar Index-modus~<br /><br />#pgv_lang[um_sql_index]#";
$pgv_lang["um_index_sql_help"] = "~Migreer gebruikers van Index naar SQL-modus~<br /><br />#pgv_lang[um_index_sql]#";
$pgv_lang["um_imp_users"] = "Gebruikers importeren";
$pgv_lang["um_imp_blocks"] = "Blokken importeren";
$pgv_lang["um_imp_favorites"] = "Favorieten importeren";
$pgv_lang["um_imp_messages"] = "Berichten importeren";
$pgv_lang["um_imp_news"] = "Nieuws importeren";
$pgv_lang["um_nousers"] = "Bestand <i>authenticate.php</i> niet gevonden in je index map. De migratie is geannuleerd.";
$pgv_lang["um_imp_succ"] = "Importeren geslaagd";
$pgv_lang["um_imp_fail"] = "Importeren mislukt";
$pgv_lang["um_backup"] = "Back-up";
$pgv_lang["um_zip_succ"] = "ZIP-bestand succesvol aangemaakt.";
$pgv_lang["um_zip_dl"] = "Download een gecomprimeerd back-upbestand ";
$pgv_lang["um_bu_explain"] = "Deze tool kan een back-up maken van verschillende soorten gegevens in PhpGedView.<br /><br />De gegevens die u kiest om een back-up te maken, worden verzameld in een ZIP-bestand, dat u kunt downloaden door op de link onderaan de pagina te klikken. pagina, nadat de back-up succesvol is gemaakt.<br /><br />Het ZIP-bestand blijft in uw indexmap totdat u het handmatig verwijdert.";
$pgv_lang["um_bu_help"] = "~#pgv_lang[um_backup]#~<br /><br />#pgv_lang[um_bu_explain]#";
$pgv_lang["um_bu_config"] = "PhpGedView configuratiebestand";
$pgv_lang["um_bu_gedcoms"] = "GEDCOM-bestanden";
$pgv_lang["um_bu_gedsets"] = "GEDCOM-instellingen, configuratie en privacybestanden";
$pgv_lang["um_bu_logs"] = "Zoeklog bestanden en PhpGedView-log bestanden";
$pgv_lang["um_bu_usinfo"] = "Gebruikersdefinities, blokinstellingen, favorieten, berichten, nieuws";
$pgv_lang["um_bu_media"]	= "Mediabestanden";
$pgv_lang["um_mk_bu"] = "Backup maken";
$pgv_lang["um_nofiles"] = "Geen bestanden gevonden voor back-up.";
$pgv_lang["um_files_exist"] = "Een of meer bestanden bestaan al. Wilt u ze overschrijven?";
$pgv_lang["um_results"]		= "Resultaten";
$pgv_lang["preview_faq_item"] = "Bekijk een voorbeeld van alle veelgestelde vragen";
$pgv_lang["preview_faq_item_help"] = "~#pgv_lang[preview_faq_item]#~<br /><br />Met deze optie kan een admin-gebruiker de pagina met veelgestelde vragen bekijken zonder alle bewerkingsopties en links.<br /><br />Behalve een enkele <b>Bewerken</b> link boven de eerste veelgestelde vragen, het uiterlijk van de pagina met veelgestelde vragen zal identiek zijn aan wat een gewone gebruiker zou zien. Deze speciale <b>Bewerken</b> link herstelt de volledige bewerkingsfunctionaliteit naar de pagina met veelgestelde vragen.";
$pgv_lang["restore_faq_edits"] = "Herstel de functionaliteit voor het bewerken van FAQ";
$pgv_lang["restore_faq_edits_help"] = "~#pgv_lang[restore_faq_edits]#~<br /><br />Deze optie herstelt de FAQ-pagina naar wat een admin-gebruiker normaal ziet, zodat individuele FAQ's kunnen worden bewerkt.";
$pgv_lang["add_faq_item"] = "FAQ toevoegen";
$pgv_lang["add_faq_item_help"] = "~#pgv_lang[add_faq_item]#~<br /><br />Met deze optie kunt u een FAQ toevoegen aan de FAQ-pagina.";
$pgv_lang["edit_faq_item"] = "Bewerk FAQ";
$pgv_lang["edit_faq_item_help"] = "~#pgv_lang[edit_faq_item]#~<br /><br />Met deze optie kun je een FAQ op de FAQ-pagina bewerken.";
$pgv_lang["delete_faq_item"] = "Verwijder FAQ";
$pgv_lang["delete_faq_item_help"] = "~#pgv_lang[delete_faq_item]#~<br /><br />Met deze optie kunt u een FAQ van de FAQ-pagina verwijderen";
$pgv_lang["moveup_faq_item"] = "Verplaats FAQ omhoog";
$pgv_lang["moveup_faq_item_help"] = "~#pgv_lang[moveup_faq_item]#~<br /><br />Met deze optie kunt u een FAQ naar boven verplaatsen op de FAQ-pagina.<br /><br />Elke keer dat u deze optie gebruikt, wordt het positienummer van deze FAQ met één verminderd. U kunt hetzelfde effect bereiken door de betreffende FAQ te bewerken en het veld Positie te wijzigen. Als meer dan één FAQ hetzelfde positienummer heeft, is er maar één zichtbaar.";
$pgv_lang["movedown_faq_item"] = "Verplaats FAQ naar beneden";
$pgv_lang["movedown_faq_item_help"] = "~#pgv_lang[movedown_faq_item]#~<br /><br />Met deze optie kunt u een FAQ naar beneden verplaatsen op de FAQ-pagina.<br /><br />Elke keer dat u deze optie gebruikt, wordt het positienummer van deze FAQ met één verhoogd. U kunt hetzelfde effect bereiken door de betreffende FAQ te bewerken en het veld Positie te wijzigen. Als meer dan één FAQ hetzelfde positienummer heeft, is slechts één hiervan zichtbaar.";
$pgv_lang["add_faq_header_help"] = "~#pgv_lang[add_faq_header]#~<br /><br />Dit is de titel of het onderwerp van de FAQ.<br /><br />Wat u hier invoert, kan worden opgemaakt. HTML-tags zoals &lt;b&gt; en &lt;br /&gt; zijn toegestaan, evenals HTML-entiteiten zoals &amp;amp; en &amp;nbsp;. HTML-tags anders dan &lt;br /&gt; zijn waarschijnlijk niet erg handig in de titel van de FAQ en moeten worden vermeden.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["add_faq_body_help"] = "~#pgv_lang[add_faq_body]#~<br /><br />De tekst van de FAQ wordt hier ingevoerd.<br /><br />De tekst kan worden opgemaakt. HTML-tags zoals &lt;b&gt; en &lt;br /&gt; zijn toegestaan, evenals HTML-entiteiten zoals &amp;amp; en &amp;nbsp;.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["add_faq_HTML"]					= "HTML entiteiten zijn een gemakkelijke manier om speciale karakters aan uw VGV titels en tekst toe te voegen.  U kunt symbolische namen, decimale of hexadecimale getallen, gebruiken.  Een complete lijst met HTML entiteiten, hun codes en hun weergave in een browser kan hier worden gevonden:  <a href=\"http://htmlhelp.com/reference/html40/entities/\" target=\"_blank\">HTML entiteiten lijst.</a><br /><br />In sommige gevallen wilt u wellicht een Tilde karakter&nbsp;&nbsp;<b>&#x7E;</b>&nbsp;&nbsp;of een Nummer Teken&nbsp;&nbsp;<b>&#x23;</b>&nbsp;&nbsp;gebruiken in uw URL's of tekst.  Deze karakters hebben echter een speciale betekenis binnen het PhpGedView Help systeem en kunnen alleen maar worden ingevoerd in hun  hexadecimale of decimale formaat.<br />De&nbsp;&nbsp;<b>&lt;</b>&nbsp;&nbsp;en&nbsp;&nbsp;<b>&gt;</b>&nbsp;&nbsp;karakters, die gebruikelijk HTML tags insluiten, moeten eveneens in hun hexadecimale of decimale formaat worden ingevoerd, zodat ze worden behandeld als normale tekst, i.p.v. te worden herkend als insluiters van een HTML tag. <ul><li><b>&amp;&#x23;35;</b>&nbsp;&nbsp;&nbsp;of&nbsp;&nbsp;<b>&amp;&#x23;x23;</b>&nbsp;&nbsp;resulteert in&nbsp;&nbsp;<b>&#x23;</b></li><li><b>&amp;&#x23;60;</b>&nbsp;&nbsp;&nbsp;of&nbsp;&nbsp;<b>&amp;&#x23;x3C;</b>&nbsp;&nbsp;resulteert in&nbsp;&nbsp;<b>&#x3C;</b></li><li><b>&amp;&#x23;62;</b>&nbsp;&nbsp;&nbsp;of&nbsp;&nbsp;<b>&amp;&#x23;x3E;</b>&nbsp;&nbsp;resulteert in&nbsp;&nbsp;<b>&#x3E;</b></li><li><b>&amp;&#x23;126;</b>&nbsp;of&nbsp;&nbsp;<b>&amp;&#x23;x7E;</b>&nbsp;&nbsp;resulteert in&nbsp;&nbsp;<b>&#x7E;</b></li></ul>Er is een&nbsp;&nbsp;<b>&amp;tilde;</b>&nbsp;&nbsp;HTML entiteit, maar dit symbool wordt niet geïnterpreteerd als een Tilde als het wordt gebruikt in URL's.";
$pgv_lang["add_faq_pgvLangRefs"]			= "U kunt referenties naar variabelen v.d. taalbestanden of waardes van globale variabelen, invoegen.<br />Voorbeelden: <ul><li><b>&#x23;pgv_lang[add_to_cart]&#x23;</b>&nbsp;&nbsp;&nbsp;is een referentie naar de taal variabele \$pgv_lang[\"add_to_cart\"]. Als het in dit veld ingevoerd zou zijn, zou het worden getoond als <b>#pgv_lang[add_to_cart]#</b>, indien de VGV lijst wordt bekeken in de huidige taal.</li><li><b>&#x23;factarray[AFN]&#x23;</b>&nbsp;&nbsp;&nbsp;is een referentie naar de Feiten Naam \$factarray[\"AFN\"]. Als het in dit veld ingevoerd zou zijn, zou het worden getoond als <b>#factarray[AFN]#</b>, indien de VGV lijst wordt bekeken in de huidige taal.</li><li><b>&#x23;GLOBALS[VERSION]&#x23;&nbsp;&#x23;GLOBALS[VERSION_RELEASE]&#x23;</b>&nbsp;&nbsp;&nbsp;is een referentie naar de globale variabele \$VERSION, een spatie, vervolgens een referentie naar de globale variabele \$VERSION_RELEASE. Als ze in dit veld ingevoerd zouden zijn, zouden ze worden getoond als <b>#GLOBALS[VERSION]#&nbsp;#GLOBALS[VERSION_RELEASE]#</b>, indien de VGV lijst wordt bekeken in de huidige taal.</li><li><b>&#x23;GLOBALS[GEDCOM]&#x23;</b>&nbsp;&nbsp;&nbsp;is een referentie naar de globale variabele \$GEDCOM, wat de naam is van het huidige GEDCOM bestand. Als het in dit veld ingevoerd zou zijn, zou het worden getoond als <b>#GLOBALS[GEDCOM]#</b>.</li><li><b>&#x23;GLOBALS[GEDCOM_TITLE]&#x23;</b>&nbsp;&nbsp;&nbsp;is een referentie naar de globale variabele \$GEDCOM_TITLE, welke de titel is van het huidige GEDCOM bestand.  Als het in dit veld ingevoerd zou zijn, zou het worden getoond als <b>#GLOBALS[GEDCOM_TITLE]#</b>.</li></ul><br />Deze eigenschap is zeer bruikabaar als u VGV lijsten wilt maken, die verschillend zijn voor elke taal, die uw site ondersteunt.  U moet dan uw aangepaste VGV titels en teksten opslaan in variabelen in de  <i>languages/extra.xx.php</i> bestanden (<i>xx</i> is de code voor elke taal). U genruikt dan het volgende formaat:<br /><code>\$pgv_lang[\"faq_title1\"]&nbsp;=&nbsp;\"Dit is een voorbeeld VGV titel\";<br />\$pgv_lang[\"faq_body1\"]&nbsp;=&nbsp;\"Dit is een voorbeeld VGV tekst.\";</code>";
$pgv_lang["add_faq_order_help"] = "~#pgv_lang[add_faq_order]#~<br /><br />Dit veld bepaalt de volgorde waarin de veelgestelde vragen worden weergegeven.<br /><br />U hoeft de cijfers niet opeenvolgend in te voeren. Als u gaten laat in het nummeringsschema, kunt u later andere veelgestelde vragen invoegen. Als u bijvoorbeeld de nummers 1, 6, 11, 16 gebruikt, kunt u later veelgestelde vragen met de ontbrekende volgnummers invoegen. Negatieve getallen en nul zijn toegestaan, en kunnen worden gebruikt om FAQ's voor de eerste in te voegen.<br /><br />Als meer dan één FAQ hetzelfde positienummer heeft, is er slechts één zichtbaar.";
$pgv_lang["add_faq_visibility_help"] = "~#pgv_lang[add_faq_visibility]#~<br /><br />U kunt bepalen of deze FAQ zichtbaar zal zijn ongeacht GEDCOM, of dat deze alleen zichtbaar zal zijn voor de huidige GEDCOM.<br /><ul><li><b>#pgv_lang[all]#</b>&nbsp;&nbsp;&nbsp;De FAQ zal in alle FAQ-lijsten verschijnen, ongeacht GEDCOM.</li><li><b>#GLOBALS[GEDCOM]#</b>&nbsp;&nbsp;&nbsp;De FAQ zal alleen verschijnen in de momenteel actieve GEDCOM's FAQ lijst.</li></ul>";
$pgv_lang["index_gedcom_news_adm_help"]		= "De GEDCOM News-tekst maakt het gebruik van <b> HTML-tags </b> en <b> HTML-entiteiten </b> mogelijk. HTML mag niet worden gebruikt in nieuwstitels.<br /><br />Zorg ervoor dat u altijd zowel begin- als eindtags gebruikt. Het kan helpen om een goed begrip te hebben van HTML die geschikt is voor een websitebeheerder. Dit programma maakt ook gebruik van <b>Cascading Style Sheets (CSS)</b>. Voor elk thema wordt een andere CSS geïmplementeerd. U kunt klassen uit deze stylesheets gebruiken om het uiterlijk van uw berichten te regelen.<br /><br />Als u hier meer hulp bij nodig heeft, heeft de PhpGedView-website enkele voorbeelden van hoe u deze tags in uw GEDCOM News-blok kunt gebruiken.<br /><br />Net als bij de lijst met veelgestelde vragen, staan GEDCOM-nieuwstitels en nieuwstekst ingesloten verwijzingen toe naar variabelen \$pgv_lang, \$factarray en \$GLOBALS om volledige flexibiliteit te bieden bij het maken van nieuwsartikelen die zijn gevoelig voor de momenteel actieve taal.<br /><br />De volgende beschrijving, ontleend aan de Help-tekst voor de FAQ-lijst, is eveneens van toepassing op GEDCOM News-artikelen.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["time_limit_help"]			= "~#pgv_lang[time_limit]#~<br /><br />De maximale tijd dat de import mag worden uitgevoerd voor het verwerken van het GEDCOM-bestand.";

// editconfig_gedcom.php Option Filter
$pgv_lang["ged_filter_results"] = "Gevonden resultaten";
$pgv_lang["ged_filter_reset"] = "Verwijder zoek";
$pgv_lang["ged_filter_description"] = "Tekst om naar te zoeken";
$pgv_lang["ged_filter_description_help"] = "~#pgv_lang[ged_filter_description]#~<br /><br />Met deze optie kunt u de tekst zoeken die is gekoppeld aan configuratie-opties.<br /><br />Terwijl u letters typt, vindt de zoekopdracht alle configuratie-opties die die letterreeks bevatten. De zoekopdracht wordt nauwkeuriger naarmate u meer letters typt.";

?>
