<?php
/**
 * Swedish Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2022  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author Patrik Hansson
 * @version $Id: configure_help.sv.php 7328 2022-01-12 18:30:53Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["google_analytics_help"]			= "~#pgv_lang[google_analytics]#~<br /><br />#pgv_lang[google_analytics]# tjänsten beskrivs i denna <a href='https://sv.wikipedia.org/wiki/Google_Analytics' target='_blank' title='Google Analytics'>Wikipedia-artikel</a>Wikipedia-artikel.<br /><br />Observera att om du väljer att använda denna tjänsten förvärvar Google rättigheterna till all information som samlas in om besökarnas aktivitet på din webbplats.";
$pgv_lang["USE_GOOGLE_ANALYTICS_help"]		= "~#pgv_lang[USE_GOOGLE_ANALYTICS]#~<br /><br />Välj <b>#pgv_lang[yes]#</b> för att möjliggöra spårning av aktivitet på din webbplats av #pgv_lang[google_analytics]# tjänsten. Du måste prenumerera på denna tjänsten innan du aktiverar detta alternativet.";
$pgv_lang["PGV_GOOGLE_ANALYTICS_help"]		= "~#pgv_lang[PGV_GOOGLE_ANALYTICS]#~<br /><br />Ange kontonumret som tilldelats din webbplats när du prenumererar på #pgv_lang[google_analytics]# tjänsten. Detta kontonummer har formatet <b>UA-xxxxxx-x</b>.";
$pgv_lang["piwik_analytics_help"]			= "~#pgv_lang[piwik_analytics]#~<br /><br />#pgv_lang[piwik_analytics]# projektet med öppen källkod, ursprungligen kallat «Piwik», beskrivs <a href='https://matomo.org/' target='_blank' title='Matomo officiella webbplats'>här</a>här på engelska.<br /><br /> Matomo är ett val till #pgv_lang[google_analytics]# som eliminerar många av integritetsproblemen. Du kan installera Matomo-applikationen på din egen webbserver eller på din egen domän, vilket säkerställer att du har fullständig kontroll över aktivitetsdata som har samlats in.";
$pgv_lang["USE_PIWIK_ANALYTICS_help"]		= "~#pgv_lang[USE_PIWIK_ANALYTICS]#~<br /><br />Välj <b>#pgv_lang[yes]#</b> för att aktivera spårning av aktivitet på din webbplats av en #pgv_lang[piwik_analytics]# server. Din PhpGedView-webbplats måste vara registrerad på en Matomo-server.";
$pgv_lang["PGV_PIWIK_URL_help"]				= "~#pgv_lang[PGV_PIWIK_URL]#~<br /><br />Ange webbadressen till en Matomo server där din PhpGedView-webbplats är registrerad.";
$pgv_lang["PGV_PIWIK_SITE_help"]			= "~#pgv_lang[PGV_PIWIK_SITE]#~<br /><br />Ange ID-numret som tilldelats din PhpGedView-webbplats av Matomo servern.";
$pgv_lang["clustrmaps_analytics_help"]		= "~#pgv_lang[clustrmaps_analytics]#~<br /><br />#pgv_lang[clustrmaps_analytics]# är ett kombinerat träffräknare, besökarspårare och geografiskt visualiseringsverktyg.<br /><br />Varje sida innehåller en miniatyrbildsbild som genereras av #pgv_lang[clustrmaps_analytics]#. När den bilden laddas ökas en räknare på #pgv_lang[clustrmaps_analytics]#-webbplatsen. När kartan, som är synlig för alla dina besökare, uppdateras (dagligen, vecka eller månad, beroende på din trafik) visar den platsen för alla besökare på din sida sedan början av ett visst tidsintervall.<br /><br />Om du har betalat för #pgv_lang[clustrmaps_analytics]# tjänsten, klickar du på den miniatyrbilden för en större bildkarta.<br /><br />Mer information finns på engelska på <a href='http://www.clustrmaps.com/' target='_blank' title='#pgv_lang[clustrmaps_analytics]# site'>#pgv_lang[clustrmaps_analytics]#-webbplatsen</a>.";
$pgv_lang["USE_CLUSTRMAPS_ANALYTICS_help"]	= "~#pgv_lang[USE_CLUSTRMAPS_ANALYTICS]#~<br /><br />Välj <b>#pgv_lang[yes]#</b> för att aktivera spårning av aktivitet på din webbplats av en #pgv_lang[clustrmaps_analytics]# server.";
$pgv_lang["PGV_CLUSTRMAPS_SITE_help"]		= "~#pgv_lang[PGV_CLUSTRMAPS_SITE]#~<br /><br />Ange webbadressen till din PhpGedView-webbplats. Detta värde har fyllts i för dig och du behöver normalt inte ändra det.";
$pgv_lang["PGV_CLUSTRMAPS_SERVER_help"]		= "~#pgv_lang[PGV_CLUSTRMAPS_SERVER]#~<br /><br />Ange servernumret som tilldelats av #pgv_lang[clustrmaps_analytics]# tjänsten när du aktiverade ditt konto.";

$pgv_lang["SHOW_LIST_PLACES"]	= "Antal platsnivåer som ska visas i listor";
$pgv_lang["SHOW_LIST_PLACES_help"]	= "~#pgv_lang[SHOW_LIST_PLACES]#~<br /><br />Detta avgör hur mycket av platsinformationen som visas i platsfälten i listor.<br /><br />Om du ställer in värdet till <b>9</b> kommer du att se till att all platsinformation visas. Att ställa in värdet till <b>0</b> (noll) döljer platser helt. Om du ställer in värdet på <b>1</b> visas den översta nivån, som normalt är landet. Om du ställer in den på <b>2</b> visas de två översta nivåerna. Den andra översta nivån, under landet, är ofta staten, provinsen eller territoriet. Etc.";

$pgv_lang["new_gedcom_title"]		= "Släktforskning från #GEDCOMFILE#";
$pgv_lang["keep_media_help"]		= "~#pgv_lang[keep_media]#~<br /><br />Skulle befintliga medialänkar behållas i databasen när en GEDCOM-ersättning laddas upp. Val <b>#pgv_lang[no]#</b> tar bort befintliga medialänkar från databasen, medan val <b>#pgv_lang[yes]#</b> behåller dem.<br /><br />Detta val är användbart när du exporterar din GEDCOM från PhpGedView till ett offline GEDCOM-underhållsprogram som inte hanterar inbäddade mediepekare ordentligt och sedan återimporterar det ändrade GEDCOM till PhpGedView. Under sådana omständigheter förstörs mediepekarna i GEDCOM som du exporterade till ditt offline-redigeringsprogram och du måste länka alla dina mediefiler till rätt person-, familj- och källposter efter att du har importerat om GEDCOM till PhpGedView.<br /><br />Val <b>#pgv_lang[yes]#</b> säger till PhpGedView att behålla befintliga medialänkar så att du inte behöver återskapa dem efter att du importerat det ändrade GEDCOM, men detta kräver att redigeringsprogrammet för offline alltid ger samma person-, familj- och källidentifikationsnummer.<br /><br /><i>Family Tree Maker</i> är en av flera av -radieringsprogram som <u>inte</u> hanterar ordentligt medieobjektpekare i GEDCOM. <i>Legacy</i>, bland många andra, hanterar dessa ordentligt.";
$pgv_lang["USE_MEDIA_VIEWER"]			= "Använd medievisaren";
$pgv_lang["USE_MEDIA_VIEWER_help"]		= "~#pgv_lang[USE_MEDIA_VIEWER]#~<br /><br />När detta val är <b>#pgv_lang[yes]#</b> skapas mediaseriersidan genom att klicka på bilder. Denna sida visar detaljerna i bilden. Om du har tillräckliga rättigheter kan du också redigera dessa detaljer.<br /><br />När detta val är <b>#pgv_lang[no]#</b>, klickar du på bilder för att skapa en bild i full storlek i ett nytt fönster.";
$pgv_lang["USE_MEDIA_FIREWALL"]			= "Använd mediebrandvägg";
$pgv_lang["USE_MEDIA_FIREWALL_help"]	= "~#pgv_lang[USE_MEDIA_FIREWALL]#~<br /><br />Se Wiki för en beskrivning av hur du använder mediebrandvägg. <a href=\"#PGV_PHPGEDVIEW_WIKI#/en/index.php?title=Media_Firewall\" target=\"_blank\">#PGV_PHPGEDVIEW_WIKI#</a>";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR"]			= "Rotmapp för mediebrandvägg";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_help"]	= "~#pgv_lang[MEDIA_FIREWALL_ROOTDIR]#~<br /><br />Mapp där den skyddade mediamappen kan skapas.  #pgv_lang[MEDIA_FIREWALL_ROOTDIR_note]#";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_note"]	= "När detta fältet är tomt kommer mappen <b>#GLOBALS[INDEX_DIRECTORY]#</b> att användas.";
$pgv_lang["MEDIA_FIREWALL_THUMBS"]			= "Skydda miniatyrbilder av skyddade bilder";
$pgv_lang["MEDIA_FIREWALL_THUMBS_help"]	= "~#pgv_lang[MEDIA_FIREWALL_THUMBS]#~<br /><br />Om en bild finns i den skyddade mediamappen, ska dess miniatyrbild också skyddas?";
$pgv_lang["SHOW_SPIDER_TAGLINE"]		= "Visa sökmotorns tagline";
$pgv_lang["SHOW_SPIDER_TAGLINE_help"]		= "~#pgv_lang[SHOW_SPIDER_TAGLINE]#~<br /><br />På sidor som genereras för sökmotorer, visa som den sista raden den specifika sökmotor som sidan upptäckte.  Om detta val är aktiverat kan det förspela Google & reg; AdSense mot verktyg för optimering av sökmotorer. ";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS_help"] = "~#pgv_lang[SHOW_PRIVATE_RELATIONSHIPS]#~<br /><br />Detta val behåller familjelänkar i privatiserade register. Det betyder att du kommer att se tomma «#pgv_lang[private]#» rutor på stamtavlan och på andra diagram med privata personer.<br /><br />Denna inställning är inaktiverad som standard. Det rekommenderas istället för att sätta på det här, för att rikta din stamtavla root person i din GEDCOM konfiguration till en person som inte är privat.";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS"]	= "Visa relationer som är privata";
$pgv_lang["SYNC_GEDCOM_FILE_help"] 			= "~#pgv_lang[SYNC_GEDCOM_FILE]#~<br /><br />Om du ställer in detta värde till <b>#pgv_lang[yes]#</b> uppdateras GEDCOM-filen automatiskt när ändringar accepteras i databasen. Detta kommer att hålla GEDCOM-filen synkroniserad med databasen.<br /><br />Du kanske vill vända den till <b>#pgv_lang[no]#</b> för att förbättra programmets hastighet och för att spara minne när du accepterar ändringar.";
$pgv_lang["SYNC_GEDCOM_FILE"]			= "Synkronisera redigeringar i GEDCOM-fil";
$pgv_lang["SHOW_MULTISITE_SEARCH_help"]	= "~#pgv_lang[SHOW_MULTISITE_SEARCH]#~<br /><br />Flersitssökning gör det möjligt för användare att söka på flera PhpGedView-webbplatser som du har konfigurerat i administrationsområdet för hantera webbplatser eller fjärrlänkat till. Detta val styr om sökfunktionen på flera platser är tillgänglig för alla eller endast för autentiserade användare.";
$pgv_lang["SHOW_MULTISITE_SEARCH"]		= "Visa sökning på flera webbplatser";
$pgv_lang["SHOW_NO_WATERMARK"]			= "Vem kan se bilder som inte är vattenmärkta?";
$pgv_lang["SHOW_NO_WATERMARK_help"]		= "~#pgv_lang[SHOW_NO_WATERMARK]#~<br /><br />Om mediebrandväggen är aktiverad kommer användarna att se vattenstämplar om de inte har den behörighetsnivå som anges här.";
$pgv_lang["WATERMARK_THUMB"]			= "Lägga till vattenstämplar i miniatyrer?";
$pgv_lang["WATERMARK_THUMB_help"]		= "~#pgv_lang[WATERMARK_THUMB]#~<br /><br />Om mediebrandväggen är aktiverad, bör miniatyrer vara vattenmärkta? Dina medielistor laddas snabbare om du inte vattenmärker miniatyrerna.";
$pgv_lang["SAVE_WATERMARK_THUMB"]		= "Spara miniatyrbilder med vattenstämpel på servern?";
$pgv_lang["SAVE_WATERMARK_THUMB_help"]	= "~#pgv_lang[SAVE_WATERMARK_THUMB]#~<br /><br />Om mediebrandväggen är aktiverad, ska kopior av vattenmärkta miniatyrer lagras på servern utöver samma miniatyrer utan vattenstämplar?<br /><br />När inställt på <b>#pgv_lang[yes]#</b>, media listor som innehåller vattenmärkta miniatyrer kommer att produceras snabbare på bekostnad av högre serverdiskutrymme.";
$pgv_lang["SAVE_WATERMARK_IMAGE"]		= "Spara vattenstämplade bilder i full storlek på servern?";
$pgv_lang["SAVE_WATERMARK_IMAGE_help"]	= "~#pgv_lang[SAVE_WATERMARK_IMAGE]#~<br /><br />Om mediebrandväggen är aktiverad, ska kopior av vattenstämplade bilder i full storlek lagras på servern utöver samma bilder utan vattenstämplar?<br /><br />När inställt på <b>#pgv_lang[yes]#</b>, kommer vattenstämplade bilder i full storlek att produceras snabbare på bekostnad av högre serverdiskutrymme.";
$pgv_lang["DB_UTF8_COLLATION"]			= "Använd databasen för att tillhandahålla UTF-8-sortering";
$pgv_lang["DB_UTF8_COLLATION_help"]		= "Kontrollerar om PhpGedView ska använda databasens inbyggda sorterings- och sorteringsanläggningar. Det är i allmänhet snabbare att använda databasen för att sortera och filtrera data i stället för PHP, även om inte alla databaser / versioner har denna funktionen. Sorteringssekvensen som används för varje språk ställs in på språkets inställningssida.<br /><br /><span class=\"warning\">VIKTIGT: Du bör bara ställa in detta värde till <b>#pgv_lang[yes]#</b> om du gör det INNAN databastabellerna skapas för första gången. Om du väljer det i en befintlig databas kan dina data skadas.</span><br /><br />MySQL och PostgreSQL erbjuder båda bra stöd för UTF-8, även om inte alla sorteringssekvenser är tillgängliga i tidigare versioner av MySQL. Andra databaser erbjuder lite eller inget stöd för UTF-8. Om du är osäker på din databas stöd för UTF-8 bör du ställa in detta värde till <b>#pgv_lang[no]#</b>.<br /><br />Denna <a href='https://sv.wikipedia.org/wiki/UTF-8' target='_blank' title='Wikipedia-artikel'><b>Wikipedia-artikel</b></a> innehåller omfattande information och länkar om UTF-8.";
$pgv_lang["INDI_FACTS_ADD"] 			= "Lägg till fakta till personer";
$pgv_lang["INDI_FACTS_ADD_help"]		= "~#pgv_lang[INDI_FACTS_ADD]#~<br /><br />Detta är en lista över fakta som användare kan lägga till personer. Du kan ändra denna listan genom att ta bort eller lägga till faktnamn, även anpassade, efter behov. Faktnamn som visas i listan får inte också visas i listan <i>#pgv_lang[INDI_FACTS_UNIQUE]#</i>.";
$pgv_lang["INDI_FACTS_UNIQUE"] 			= "Unika personfakta";
$pgv_lang["INDI_FACTS_UNIQUE_help"]		= "~#pgv_lang[INDI_FACTS_UNIQUE]#~<br /><br />Detta är en lista med fakta som användare bara kan lägga till <u>en gång</u> till personer. Till exempel, om BIRT finns i denna listan kan användare inte lägga till mer än en BIRT-post till en person. Faktnamn som visas i denna listan får inte också visas i listan <i>#pgv_lang[INDI_FACTS_ADD]#</i>.";
$pgv_lang["INDI_FACTS_QUICK"] 			= "Lägg snabbt till fakta till personer";
$pgv_lang["INDI_FACTS_QUICK_help"]	= "~#pgv_lang[INDI_FACTS_QUICK]#~<br /><br />Detta är en kort lista över personfakta som visas bredvid hela listan och kan läggas till med ett enda klick.";
$pgv_lang["FAM_FACTS_ADD"] 			= "Lägg till fakta till familjer";
$pgv_lang["FAM_FACTS_ADD_help"]		= "~#pgv_lang[FAM_FACTS_ADD]#~<br /><br />Detta är en lista med fakta som användare kan lägga till familjer. Du kan ändra denna listan genom att ta bort eller lägga till faktnamn, även anpassade, efter behov. Faktnamn som visas i denna listan får inte också visas i listan <i>#pgv_lang[FAM_FACTS_UNIQUE]#</i>.";
$pgv_lang["FAM_FACTS_UNIQUE"] 			= "Unika familjefakta";
$pgv_lang["FAM_FACTS_UNIQUE_help"]		= "~#pgv_lang[FAM_FACTS_UNIQUE]#~<br /><br />Detta är en lista med fakta som användare bara kan lägga till <u>en gång</u> till familjer. Till exempel, om MARR finns i denna listan kan användare inte lägga till mer än en MARR-post till en familj. Faktnamn som visas i denna listan får inte visas i listan <i>#pgv_lang[FAM_FACTS_ADD]#</i>.";
$pgv_lang["FAM_FACTS_QUICK"] 			= "Lägg snabbt till fakta till familjer";
$pgv_lang["FAM_FACTS_QUICK_help"]	= "~#pgv_lang[FAM_FACTS_QUICK]#~<br /><br />Detta är en kort lista över familjefakta som visas bredvid hela listan och kan läggas till med ett enda klick.";
$pgv_lang["SOUR_FACTS_ADD"] 			= "Lägg till fakta till källor";
$pgv_lang["SOUR_FACTS_ADD_help"]		= "~#pgv_lang[SOUR_FACTS_ADD]#~<br /><br />Detta är en lista med fakta som användare kan lägga till till källor. Du kan ändra denna listan genom att ta bort eller lägga till faktnamn, även anpassade, efter behov. Faktnamn som visas i denna listan får inte visas i listan <i>#pgv_lang[SOUR_FACTS_UNIQUE]#</i>.";
$pgv_lang["SOUR_FACTS_UNIQUE"] 			= "Unika källfakta";
$pgv_lang["SOUR_FACTS_UNIQUE_help"]		= "~#pgv_lang[SOUR_FACTS_UNIQUE]#~<br /><br />Detta är en lista med fakta som användare bara kan lägga till <u>en gång</u> till källorna. Till exempel, om TITL finns i denna listan, kan användare inte lägga till mer än en TITL-post till källa. Faktnamn som visas i denna listan får inte också visas i listan <i>#pgv_lang[SOUR_FACTS_ADD]#</i>.";
$pgv_lang["SOUR_FACTS_QUICK"] 			= "Lägg snabbt till fakta till källor";
$pgv_lang["SOUR_FACTS_QUICK_help"]	= "~#pgv_lang[SOUR_FACTS_QUICK]#~<br /><br />Detta är en kort lista över källfakta som visas bredvid hela listan och kan läggas till med ett enda klick.";
$pgv_lang["REPO_FACTS_ADD"] 			= "Lägg till fakta till förvar";
$pgv_lang["REPO_FACTS_ADD_help"]		= "~#pgv_lang[REPO_FACTS_ADD]#~<br /><br />Detta är en lista med fakta som användare kan lägga till till förvar. Du kan ändra denna listan genom att ta bort eller lägga till faktnamn, även anpassade, efter behov. Faktnamn som visas i denna listan får inte också visas i listan <i>#pgv_lang[REPO_FACTS_UNIQUE]#</i>.";
$pgv_lang["REPO_FACTS_UNIQUE"] 			= "Unika förvaringsfakta";
$pgv_lang["REPO_FACTS_UNIQUE_help"]		= "~#pgv_lang[REPO_FACTS_UNIQUE]#~<br /><br />Detta är en lista med fakta som användarna bara kan lägga till <u>en gång</u> till förvar. Till exempel, om NAME finns i denna listan kan användare inte lägga till mer än en NAME-post i ett förråd. Faktnamn som visas i denna listan får inte också visas i listan <i>#pgv_lang[REPO_FACTS_ADD]#</i>.";
$pgv_lang["REPO_FACTS_QUICK"] 			= "Lägg snabbt till fakta till förvar";
$pgv_lang["REPO_FACTS_QUICK_help"]	= "~#pgv_lang[REPO_FACTS_QUICK]#~<br /><br />Detta är en kort lista över förvarets fakta som visas bredvid hela listan och kan läggas till med ett enda klick.";
$pgv_lang["LANG_SELECTION_help"]		= "~#pgv_lang[LANG_SELECTION]#~<br /><br />Du kan ändra listan över språk som stöds av din PhpGedView-webbplats genom att lägga till eller ta bort kryssmarkeringar efter behov. Detta ändrar de språkval som är tillgängliga för dina användare.<br /><br />Du kan uppnå samma sak via länken <b>#pgv_lang[enable_disable_lang]#</b> på menyn #pgv_lang[admin]#, där du också kan ändra saker som språkets flaggikon, datumformat eller om efternamnet alltid ska skrivas ut först.";
$pgv_lang["MEDIA_ID_PREFIX"]		= "Prefix för Media ID";
$pgv_lang["MEDIA_ID_PREFIX_help"]	= "~#pgv_lang[MEDIA_ID_PREFIX]#~<br /><br />När en ny mediepost läggs till online i PhpGedView genereras ett nytt ID för det mediet automatiskt. ID kommer att ha detta prefix.";
$pgv_lang["FAM_ID_PREFIX"]		= "Prefix för familj ID";
$pgv_lang["FAM_ID_PREFIX_help"]	= "~#pgv_lang[FAM_ID_PREFIX]#~<br /><br />När en ny familjepost läggs till online i PhpGedView genereras ett nytt ID för den familjen automatiskt. ID kommer att ha detta prefix.";
$pgv_lang["QUICK_REQUIRED_FAMFACTS"]			= "Fakta för familjer att alltid visas på snabbuppdateringsformuläret";
$pgv_lang["QUICK_REQUIRED_FAMFACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FAMFACTS]#~<br /><br />Detta är en kommaseparerad lista över fakta som alltid kommer att visas på familjeflikarna i snabbuppdateringsformuläret, oavsett om de redan finns i familjens register. Till exempel, om MARR finns i listan, visas alltid fält för äktenskapsdatum och plats för äktenskap på formuläret.";
$pgv_lang["QUICK_ADD_FAMFACTS"]			= "Fakta för familjer att visa på snabbuppdateringsformuläret";
$pgv_lang["QUICK_ADD_FAMFACTS_help"]		= "~#pgv_lang[QUICK_ADD_FAMFACTS]#~<br /><br />Detta är en kommaseparerad lista över fakta som kommer att visas på familjeflikarna i snabbuppdateringsformuläret. Endast fakta i listan visas på formuläret eller görs tillgängliga för val i det område där du lägger till nya fakta på formuläret.";
$pgv_lang["QUICK_REQUIRED_FACTS"]			= "Fakta som alltid visas på snabbuppdateringsformuläret";
$pgv_lang["QUICK_REQUIRED_FACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FACTS]#~<br /><br />Detta är en kommaseparerad lista över fakta som alltid kommer att visas i snabbuppdateringsformuläret, oavsett om de redan finns i personens register. Till exempel, om BIRT finns i listan, visas alltid fält för födelsedatum och födelseort på formuläret.";
$pgv_lang["QUICK_ADD_FACTS"]			= "Fakta att visa på snabbuppdateringsformuläret";
$pgv_lang["QUICK_ADD_FACTS_help"]		= "~#pgv_lang[QUICK_ADD_FACTS]#~<br /><br />Detta är en kommaseparerad lista med fakta som kommer att visas i snabbuppdateringsformuläret. Endast fakta i listan visas på formuläret eller görs tillgängliga för val i det område där du lägger till nya fakta på formuläret.";
$pgv_lang["SURNAME_TRADITION_help"] = "~#pgv_lang[SURNAME_TRADITION]#~<br /><br />När du lägger till nya medlemmar i en familj kan PhpGedView tillhandahålla standardvärden för efternamn enligt regional anpassning.<br /><br /><ul><li>I <b>faderns</b> tradition delar alla familjemedlemmar faderns efternamn.</li><li>I traditionen <b>spanska</b> och <b>portugisiska</b> får barn ett efternamn från varje förälder.</li><li>I <b>isländsk</b> tradition får barn sin manliga förälders förnamn som efternamn, med ett suffix som betecknar kön.</li><li>I den <b>polska</b> traditionen delar alla familjemedlemmar faderns efternamn. För vissa efternamn anger suffixet kön. Suffixen <i>ski</i>, <i>cki</i>, och <i>dzki</i> anger hane, medan motsvarande suffix <i>ska</i>, <i>cka</i>, och <i>dzka</i> anger kvinnlig.</li></ul>";
$pgv_lang["ADVANCED_NAME_FACTS_help"] = "~#pgv_lang[ADVANCED_NAME_FACTS]#~<br /><br />Detta är en kommaseparerad lista över fakta som kommer att visas i formuläret Lägg till / redigera namn. Om du använder icke-latinska alfabet som hebreiska, grekiska, kyrilliska eller arabiska, kanske du vill lägga till taggar som _HEB, ROMN, FONE, etc. så att du kan lagra namn i flera olika alfabet.";
$pgv_lang["ADVANCED_PLAC_FACTS_help"] = "~#pgv_lang[ADVANCED_PLAC_FACTS]#~<br /><br />Detta är en kommaseparerad lista över fakta som kommer att visas när du lägger till eller redigerar platsnamn. Om du använder alfabet som inte är latin, som hebreiska, grekiska, kyrilliska eller arabiska, kanske du vill lägga till taggar som _HEB, ROMN, FONE, etc. så att du kan lagra platsnamn i flera olika alfabet.";
$pgv_lang["GEONAMES_KEY"]				= "geonames.org Användar ID";
$pgv_lang["GEONAMES_KEY_help"]			= "~#pgv_lang[GEONAMES_KEY]#~<br /><br />Denna användar-ID krävs för att få tillgång till den kostnadsfria databasen geonames.org med geografiska namn. Om du inte anger ett giltigt användar-ID kommer du inte att kunna söka i denna databasen.<br /><br />Du kan begära ett geonames.org användar-ID på <a href='http://www.geonames.org/login' target='_blank'><b>geonames.org inloggningssida</b></a>.<br /><br />Du får då ett mejl med en bekräftelselänk och efter att du har bekräftat e-postmeddelandet kan du aktivera ditt konto för webservice på <a href='http://www.geonames.org/manageaccount' target='_blank'><b>din kontosida</b></a>";
$pgv_lang["GEONAMES_BIAS"]				= "geonames.org landsförskjutning";
$pgv_lang["GEONAMES_BIAS_help"]			= "~#pgv_lang[GEONAMES_BIAS]#~<br /><br />Normalt presenterar databasen i GeoNames sina resultat i alfabetisk ordning utan hänsyn till det land där en plats är belägen. Detta val anger att platser i det valda landet ska rapporteras högst upp i resultatlistan.";
$pgv_lang["GEONAMES_BIAS_no_preference"]= "Ingen preferens";
$pgv_lang["GEOCODE_KEY"]				= "Google Geocode Server-nyckel";
$pgv_lang["GEOCODE_KEY_help"]			= "~#pgv_lang[GEOCODE_KEY]#~<br /><br />Denna nyckel krävs för att få tillgång till den kostnadsfria Google-databasen med geografiska namn. Om du inte anger en giltig nyckel kan du inte söka i denna databasen.<br /><br />Du kan begära en nyckel via din <a href='https://developers.google.com/maps/documentation/geocoding/get-api-key' target='_blank'><b>Google Developer Console</b></a>. Du kan visa denna sidan på ett annat språk än engelska genom att välja önskat språk längst ner på sidan.";
$pgv_lang["AUTO_GENERATE_THUMBS"]			= "Automatiskt genererade miniatyrer";
$pgv_lang["AUTO_GENERATE_THUMBS_help"]		= "~#pgv_lang[AUTO_GENERATE_THUMBS]#~<br /><br />Skulle systemet automatiskt generera miniatyrer för bilder som inte har dem. Din PHP-installation stöder kanske inte denna funktion.";
$pgv_lang["phpinfo_help"]				= "~#pgv_lang[phpinfo]#~<br /><br />Denna sida innehåller omfattande information om servern som PhpGedView är värd för. Många konfigurationsdetaljer om serverns programvara, eftersom det avser PHP och PhpGedView, kan visas.";
$pgv_lang["config_help_help"]			= "~#pgv_lang[config_help]#~<br /><br />Denna sidan samlar alla huvudämnen i konfigurationshjälpen på ett ställe. Du kan visa informationen på skärmen eller skriva ut den för senare användning.";
$pgv_lang["more_help_advice"]			= "<b>Mer hjälp</b><br />Mer hjälp finns genom att klicka på <b>#pgv_lang[qm]#</b> bredvid objekt på sidan.";
$pgv_lang["THUMBNAIL_WIDTH"]			= "Bredden på genererade miniatyrer";
$pgv_lang["THUMBNAIL_WIDTH_help"]		= "~#pgv_lang[THUMBNAIL_WIDTH]#~<br /><br />Detta är den bredd (i pixlar) som programmet kommer att använda när de automatiskt genererar miniatyrer. Standardinställningen är 100.";
$pgv_lang["USE_SILHOUETTE"]				= "Använd silhuetter";
$pgv_lang["USE_SILHOUETTE_help"]		= "~#pgv_lang[USE_SILHOUETTE]#~<br /><br />Använd silhuettbilder när ingen markerad bild för den personen har specificerats. Bilderna som används är specifika för könen hos personen i fråga.<br /><br /><table><tr><td wrap valign=\"middle\">Denna bilden kan användas när personens kön är okänt:</td><td><img src=\"images/silhouette_unknown.gif\" width=\"40\" alt=\"Silhouette image\" title=\"Silhouette image\" /></td></tr></table>";
$pgv_lang["SHOW_SOURCES"]				= "Visa källor";
$pgv_lang["SHOW_SOURCES_help"]			= "~#pgv_lang[SHOW_SOURCES]#~<br /><br />Ställ in åtkomstnivån för sekretess för alla källor. Om användaren inte har tillgång till källor tas källlistan bort från listmenyn och fliken Källor visas inte på sidan <i>#pgv_lang[personal_details]#</i>.";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION_help"]	= "~#pgv_lang[REQUIRE_ADMIN_AUTH_REGISTRATION]#~<br /><br />Om val <b>#pgv_lang[USE_REGISTRATION_MODULE]#</b> är aktiverat styr denna inställning om administratören måste godkänna registreringen.<br /><br />Ställ in detta till <b>#pgv_lang[yes]#</b> kräver att alla nya användare först verifierar sig själva och sedan godkänns av en administratör innan de kan logga in. Med denna inställning på <b>#pgv_lang[no]#</b> kommer kryssrutan <b>#pgv_lang[verified_by_admin]#</b> att markeras automatiskt när användare verifierar sitt konto, vilket möjliggör en omedelbar inloggning efteråt utan adminintervention.";
$pgv_lang["SPLIT_PLACES"]		= "Dela platser i redigeringsläge";
$pgv_lang["SPLIT_PLACES_help"]	= "~#pgv_lang[SPLIT_PLACES]#~<br /><br />Ställ in detta till <b>#pgv_lang[yes]#</b> för att dela upp varje platsnamn med komma i underfält för enklare redigering. Exempel :<br /><ol><li>Standard läge<br /><u>Plats</u>: Half Moon Bay, San Mateo, California, USA</li><br /><li>Delat läge<br /><u>Land</u>: USA<br /><u>Stat</u>: California<br /><u>Grevskap</u>: San Mateo<br /><u>Stad</u>: Half Moon Bay</li></ol>";
$pgv_lang["UNDERLINE_NAME_QUOTES"]		= "Understreck namn i anföringstecken (\")";
$pgv_lang["UNDERLINE_NAME_QUOTES_help"]	= "~#pgv_lang[UNDERLINE_NAME_QUOTES]#~<br /><br />Många program placerar det föredragna förnamnet i citattecken (<b>\"</b>) i GEDCOM. Den vanliga konventionen för detta är att understryka det föredragna förnamnet. Om du aktiverar detta val konverteras alla namn som omges av anföringstecken till &lt;span&gt; med en CSS-klass av \"starredname\".<br /><br />Till exempel om namnet i GEDCOM var 1&nbsp;NAME&nbsp;Gustave&nbsp;\"Jean&nbsp;Paul\"&nbsp;Charles&nbsp;/Wilson/ aktivera detta val skulle ändra den del av namnet som finns i citat till &lt;span&nbsp;class=\"starredname\"&gt;Jean&nbsp;Paul&lt;/span&gt; för utskriftsändamål. Beroende på andra inställningar, visar webbläsaren sedan det namnet som <b>Gustave&nbsp;<u>Jean&nbsp;Paul</u>&nbsp;Charles&nbsp;Wilson</b> eller <b>Wilson,&nbsp;Gustave&nbsp;<u>Jean&nbsp;Paul</u>&nbsp;Charles</b>";
$pgv_lang["PRIVACY_BY_RESN"]		= "Använd GEDCOM (RESN) sekretessbegränsning";
$pgv_lang["PRIVACY_BY_RESN_help"]	= "~#pgv_lang[PRIVACY_BY_RESN]#~<br /><br />GEDCOM 5.5.1-specifikationen inkluderar möjligheten att använda RESN-taggar för att ställa in integritetsalternativ för personer och fakta i GEDCOM-filen. Om du aktiverar detta val ber programmet att leta efter nivå 1 RESN taggar i GEDCOM-poster. Nivå 2+ RESN-taggar tillämpas automatiskt och påverkas inte av denna inställning. Observera att detta kan sakta ner några av funktionerna i PhpGedView, t.ex. personlistan.";
$pgv_lang["SHOW_LDS_AT_GLANCE"]			= "Visa förordningskoder för SDH-kyrkan i kartrutor";
$pgv_lang["SHOW_LDS_AT_GLANCE_help"]	= "~#pgv_lang[SHOW_LDS_AT_GLANCE]#~<br /><br />Om du ställer in detta val till <b>#pgv_lang[yes]#</b> visas statuskoder för SDH-förordningar i diagramrutor.<ul><li><b>B</b> - Dop</li><li><b>E</b> - Begavad</li><li><b>S</b> - Avseglad till make</li><li><b>P</b> - Avseglad till föräldrar</li></ul>En person som har gjort alla förordningar kommer att ha <b>BESP</b> tryckt efter sitt namn. Saknade förordningar anges med <b>_</b> istället för motsvarande bokstavskod. Till exempel anger <b>BE__</b> saknade <b>S</b> och <b>P</b> förordningar.";
$pgv_lang["GEDCOM_DEFAULT_TAB"]			= "Standardflik för att visas på «Personliga detaljer» sida";
$pgv_lang["GEDCOM_DEFAULT_TAB_help"]	= "~#pgv_lang[GEDCOM_DEFAULT_TAB]#~<br /><br />Med detta val kan du välja vilken flik som öppnas automatiskt på sidan «Personliga detaljer» när sidan öppnas.";
$pgv_lang["SHOW_MARRIED_NAMES"]			= "Visa gifta namn på personlistan";
$pgv_lang["SHOW_MARRIED_NAMES_help"]	= "~#pgv_lang[SHOW_MARRIED_NAMES]#~<br /><br />Detta val visar gifta namn på kvinnor på personlistan. Detta val kräver att du beräknar de gifta namnen när du importerar GEDCOM-filen.";
$pgv_lang["SHOW_QUICK_RESN"]		= "Visa sekretessfält på formuläret #pgv_lang[quick_update_title]#";
$pgv_lang["SHOW_QUICK_RESN_help"]		= "~#pgv_lang[SHOW_QUICK_RESN]#~<br /><br />Detta val låter dig aktivera eller inaktivera sekretessfälten i formuläret #pgv_lang[quick_update_title]#. Sekretessfält tillåter en användare som lägger till information genom formuläret att åsidosätta standardintegriteten för det faktum att de anger.";
$pgv_lang["USE_QUICK_UPDATE"]		= "Använd formuläret #pgv_lang[quick_update_title]#";
$pgv_lang["USE_QUICK_UPDATE_help"]		= "~#pgv_lang[USE_QUICK_UPDATE]#~<br /><br />Detta val avgör vilka användarbehörigheter som krävs för att skicka ändringar genom formuläret #pgv_lang[quick_update_title]#.<br /><br />Valet <b>#pgv_lang[nobody]#</b> betyder att detta formuläret inte kan användas alls.";
$pgv_lang["SEARCHLOG_CREATE"]		= "Arkivera sökloggfilerna";
$pgv_lang["SEARCHLOG_CREATE_help"]	= "~#pgv_lang[SEARCHLOG_CREATE]#~<br /><br />Hur ofta ska programmet arkivera sökloggfilerna.";
$pgv_lang["CHANGELOG_CREATE"]		= "Arkivera ändringsloggfilerna";
$pgv_lang["CHANGELOG_CREATE_help"]	= "~#pgv_lang[CHANGELOG_CREATE]#~<br /><br />Hur ofta ska programmet arkivera ändringsloggfilerna.";
$pgv_lang["CHART_BOX_TAGS"]		= "Andra fakta att visa i diagram";
$pgv_lang["CHART_BOX_TAGS_help"]		= "~#pgv_lang[CHART_BOX_TAGS]#~<br /><br />Detta bör vara en komma- eller mellanseparerad lista över fakta, förutom födelse och död, som du vill ska visas i diagramrutor som stamtavla. Denna listan kräver att du använder faktataggar enligt definitionen i GEDCOM 5.5.1-standarden. Om du till exempel vill att yrket ska dyka upp i rutan skulle du lägga till «OCCU» i detta fältet.";
$pgv_lang["FULL_SOURCES"]		= "Använd fullständiga källcitat";
$pgv_lang["FULL_SOURCES_help"]		= "~#pgv_lang[FULL_SOURCES]#~<br /><br />Källcitat kan innehålla fält för att registrera datakvaliteten (primär, sekundär, etc.) och datumet då händelsen registrerades i källan. Om du inte använder dessa fält kan du inaktivera dem när du skapar nya källciteringar.";
$pgv_lang["PREFER_LEVEL2_SOURCES"]		= "Källtyp";
$pgv_lang["PREFER_LEVEL2_SOURCES_help"]		= "~#pgv_lang[PREFER_LEVEL2_SOURCES]#~<br /><br />När du lägger till nya nära släktingar kan du lägga till källcitat i posterna (t.ex. INDI, FAM) eller fakta (BIRT, MARR, DEAT). Detta val styr vilka rutor som är markerade som standard.";


//-- CONFIGURE FILE MESSAGES
$pgv_lang["gedcom_conf"]		= "GEDCOM Grunderna";
$pgv_lang["media_conf"]			= "Multimedia";
$pgv_lang["media_general_conf"]	= "Allmän";
$pgv_lang["media_firewall_conf"]	= "Mediabrandvägg";
$pgv_lang["accpriv_conf"]		= "Tillgång och privatliv";
$pgv_lang["displ_conf"]			= "Display, Layout, och Rapporter";
$pgv_lang["displ_names_conf"]	= "Namn";
$pgv_lang["displ_comsurn_conf"] = "Hyppig efternamn";
$pgv_lang["displ_layout_conf"]	= "Layout";
$pgv_lang["displ_hide_conf"]	= "Dölj och visa";
$pgv_lang["displ_reports"]		= "Rapporter";
$pgv_lang["editopt_conf"]		= "Alternativ för redigering";
$pgv_lang["useropt_conf"]		= "Alternativ för användare";
$pgv_lang["contact_conf"]		= "Kontaktinformation";
$pgv_lang["meta_conf"]			= "Webbplats- och META-tagg inställningar";
$pgv_lang["gedconf_head"]		= "GEDCOM-konfiguration";
$pgv_lang["other_theme"]		= "Annat, skriv in";
$pgv_lang["performing_update"]		= "Utför uppdatering.";
$pgv_lang["config_file_read"]		= "Konfigurationsfil läst.";
$pgv_lang["does_not_exist"]		= "existerar inte";
$pgv_lang["media_drive_letter"]		= "Mediasökvägen bör inte innehålla en enhetsbokstav. Media kanske inte visas.";
$pgv_lang["db_setup_bad"]		= "Den aktuella databaskonfigurationen är dålig. Kontrollera dina databasanslutningsparametrar och konfigurera igen.";
$pgv_lang["bad_host_user_pass"]		= "PhpGedView kunde inte ansluta till databasvärden. Kontrollera värd, användarnamn och lösenord för att se till att de är korrekta.";
$pgv_lang["bad_database_name"]		= "PhpGedView upprättade en anslutning till databasvärden, men kunde inte använda databasen med det namn du angav. Kontrollera att databasen finns och att användarnamnet du angav har rätt behörigheter för databasen.";
$pgv_lang["db"]				= "Databas";
$pgv_lang["current_gedcoms"]		= "Nuvarande GEDCOM";
$pgv_lang["ged_gedcom"]			= "GEDCOM fil";
$pgv_lang["ged_title"]			= "GEDCOM titel";
$pgv_lang["ged_config"]			= "Konfigurationsfil";
$pgv_lang["ged_search"]			= "Sökloggar filer";
$pgv_lang["ged_change"]			= "Ändringsloggar filer";
$pgv_lang["ged_privacy"]		= "Integritetsfil";
$pgv_lang["disabled"]			= "Inaktiverad";
$pgv_lang["mouseover"]					= "Vid musfokus";
$pgv_lang["mousedown"]					= "Vid nedtryckt musknapp";
$pgv_lang["click"]						= "Vid musklick";
$pgv_lang["enter_db_pass"]		= "För säkerhet måste du alltid ange #pgv_lang[DBUSER]# och #pgv_lang[DBPASS]# när du ändrar konfigurationsvärden.";
$pgv_lang["server_url_note"]	= "Detta ska vara webbadressen till din PhpGedView-mapp. Du bör bara ändra denna inställningen om du är säker på att du vet vad du gör. PhpGedView har fastställt att detta värde är <b>#GUESS_URL#</b>";

$pgv_lang["DBTYPE"]			= "Databastyp";
$pgv_lang["DBTYPE_help"]		= "~#pgv_lang[DBTYPE]#~<br /><br />Typ av databas att ansluta.<br /><br />PhpGedView kan använda vilken databas som helst som har en PDO-drivrutin. Du måste se till att din php.ini fil laddar både biblioteket <b>php_pdo</b> och rätt drivrutin för din databas, t.ex. <b>php_pdo_mysql</b>.<br /><br />De flesta databaser kräver ett användarnamn och lösenord. Du måste också skapa databasen innan du installerar PhpGedView. SQLite behöver dock inte #pgv_lang[DBHOST]#, #pgv_lang[DBUSER]#, eller #pgv_lang[DBPASS]#, men du måste ange en filsökväg för din databas i fältet #pgv_lang[DBNAME]#. PhpGedView skapar SQLite-databasfilen åt dig.";
$pgv_lang["DBHOST"]			= "Databas värd";
$pgv_lang["DBHOST_help"]		= "~#pgv_lang[DBHOST]#~<br /><br />DNS- eller IP-adressen till den dator som är värd för databasservern. Denna inställningen ignoreras om du använder en SQLite-databas.";
$pgv_lang["DBPORT"]			= "Databas port";
$pgv_lang["DBPORT_help"]		= "~#pgv_lang[DBPORT]#~<br /><br />TCP-porten som ska användas när du ansluter till databasservern. Lämna denna inställningen tom för att använda standardporten för din specifika typ av databas. Denna inställningen ignoreras om du använder en SQLite-databas.";
$pgv_lang["DBUSER"]			= "Databas användarnamn";
$pgv_lang["DBUSER_help"]		= "~#pgv_lang[DBUSER]#~<br /><br />Databasens användarnamn krävs för att logga in på databasen. Denna inställningen ignoreras om du använder en SQLite-databas.";
$pgv_lang["DBPASS"]			= "Databas lösenord";
$pgv_lang["DBPASS_help"]		= "~#pgv_lang[DBPASS]#~<br /><br />Databasens lösenordet för användaren du angav i fältet #pgv_lang[DBUSER]#. Denna inställningen ignoreras om du använder en SQLite-databas.";
$pgv_lang["DBNAME"]			= "Databas namn";
$pgv_lang["DBNAME_help"]		= "~#pgv_lang[DBNAME]#~<br /><br />Databasen på servern du vill att PhpGedView ska använda.<br /><br />Användarnamnet som du anger i fältet #pgv_lang[DBUSER]# måste ha behörigheterna Skapa, Infoga, Uppdatera, Radera och Välj. I SQLite måste du ställa in detta till ett filnamn i en mapp som kan skrivas av PHP, till exempel din indexmapp (index/phpgedview.db).";
$pgv_lang["TBLPREFIX_help"]		= "~#pgv_lang[TBLPREFIX]#~<br /><br />Ett prefix till namnen på tabellerna skapade av PhpGedView. Genom att ändra detta värde kan du ställa in flera PhpGedView-webbplatser för att använda samma fysiska databas men olika tabeller. Exempelvis kan samma webbplats vara värd för ett «test» såväl som en «produktion» installation av PhpGedView med helt oberoende datatabeller.";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"]	= "~#pgv_lang[ALLOW_CHANGE_GEDCOM]#~<br /><br />Om du har en miljö med flera GEDCOM, kan du ställa in detta värde till <b>#pgv_lang[yes]#</b> att dina webbplatsbesökare <u>och</u> användare kan välja att ändra GEDCOM. Om du ställer in den på <b>#pgv_lang[no]#</b> inaktiveras GEDCOM-växling för både besökare <u>och</u> inloggade användare.";
$pgv_lang["upload_path"]			= "Ladda upp sökväg";
$pgv_lang["upload_path_help"]		= "~#pgv_lang[upload_path]#~<br /><br />Detta är sökvägen där GEDCOM-filen du vill ladda upp finns. För att välja sökväg, klicka på <b>Bläddra</b> och navigera till din GEDCOM-fil och klicka sedan på <b>Öppna</b>.";
$pgv_lang["gedcom_path"]			= "Sökväg och namn på GEDCOM på servern";
$pgv_lang["gedcom_path_help"]		= "~#pgv_lang[gedcom_path]#~<br /><br />Det finns två sätt att importera en GEDCOM-fil till PhpGedView. Dom är:<ol><li>Använd ett FTP-program för att ladda upp filen till servern</li><li>Ladda upp inom PhpGedView</li></ol>När filen redan finns på servern kopplar du in proceduren <i>#pgv_lang[add_gedcom]#</i> och fyller i sökvägen och namnet på GEDCOM-filen när de finns på servern. Namnet kan vara med eller utan tillägg. Om ingen förlängning ges antas .ged antas. Banan är valfri. Om ingen sökväg ges används värdet för val <i>#pgv_lang[INDEX_DIRECTORY]#</i>, som anges i PhpGedView webbplatsens konfiguration. Observera att på de flesta servrar är fil- och sökvägen skiftlägeskänsliga.<br /><br />När du använder <i>#pgv_lang[upload_gedcom]#</i> proceduren inbyggd i PhpGedView kan du använda <b>Bläddra</b> för att hitta önskad fil på den lokala datorn. Detta kan vara en vanlig GEDCOM-fil eller en ZIP-fil som innehåller GEDCOM-filen. PhpGedView extraherar automatiskt och använder sedan GEDCOM-filen i den ZIP-filen.<br /><br />När du laddar upp en fil är det möjligt att ange en val sökväg och / eller filnamn för att spara den under på servern.<br /><br />Se <a href=\"readme.txt\">Readme.txt</a> filen för mer information.";
$pgv_lang["CHARACTER_SET"]		= "Teckenuppsättningen kodning";
$pgv_lang["CHARACTER_SET_help"]		= "~#pgv_lang[CHARACTER_SET]#~<br /><br />Detta är teckenuppsättningen för din GEDCOM-fil. UTF-8 är standard och bör fungera för nästan alla webbplatser. Om du exporterar din GEDCOM med IBM Windows-kodning bör du lägga WINDOWS här.<br /><br />OBS! PhpGedView kan inte stödja UNICODE (UTF-16) eftersom supporten saknas i PHP.";
$pgv_lang["LANGUAGE"]			= "Språk";
$pgv_lang["LANGUAGE_help"]		= "~#pgv_lang[LANGUAGE]#~<br /><br />Tilldela standardspråket för webbplatsen.<br /><br />När val <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b> är inställt kan användare åsidosätta denna inställning genom sin webbläsares önskade språkkonfiguration, konfigurationsalternativ på deras kontosida eller via länkar eller knappar på de flesta PhpGedView-sidor.";
$pgv_lang["ENABLE_MULTI_LANGUAGE"]	= "Låt användaren ändra språk";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"]	= "~#pgv_lang[ENABLE_MULTI_LANGUAGE]#~<br /><br />Ställ in på <b>#pgv_lang[yes]#</b> så att användare kan åsidosätta webbplatsens standardspråk. De kan göra detta via webbläsarens önskade språkkonfiguration, konfigurationsalternativ på deras kontosida eller genom länkar eller knappar på de flesta PhpGedView-sidor.";
$pgv_lang["CALENDAR_FORMAT"]		= "Kalenderformat";
$pgv_lang["CALENDAR_FORMAT_help"]	= "~#pgv_lang[CALENDAR_FORMAT]#~<br /><br />Datum kan spelas in i olika kalendrar som gregorianska, julianska eller judiska kalendern. Med detta val kan du konvertera datum till en önskad kalender. Du kan till exempel välja gregorianska för att konvertera julianska och hebreiska datum till gregorianska. Det konverterade datumet visas inom parentes efter det vanliga datumet.<br /><br />Datum konverteras bara om de är giltiga för kalendern. Till exempel kommer endast datum mellan 22&nbsp;SEP&nbsp;1792 och 31&nbsp;DEC&nbsp;1805 att konverteras till den franska republikanska kalendern och bara datum efter 15&nbsp;OCT&nbsp;1582 kommer att konverteras till den gregorianska kalendern.<br /><br />Hebreiska är samma som judiska, men använder hebreiska tecken. Arabiska är detsamma som Hijri, men med arabiska tecken.<br /><br />Obs: Eftersom den judiska och Hijri-kalenderdagen börjar i skymningen visas alla händelser som äger rum från skymning till midnatt en dag före rätt datum. Visningen av hebreiska och arabiska kan vara problematisk i gamla webbläsare, vilket kan visa text bakåt (från vänster till höger) eller inte alls.";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"]	= "Visa hebreiska tusentals";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"]	= "~#pgv_lang[DISPLAY_JEWISH_THOUSANDS]#~<br /><br />Visa Alafim i hebreiska kalendrar.<br /><br />Om du ställer in detta på <b>#pgv_lang[yes]#</b> visas år 1969 som <span lang=\"he-IL\" dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; medan du ställer in det på <b>#pgv_lang[no]#</b> visas året som <span lang=\"he-IL\" dir='rtl'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;.  Detta har ingen inverkan på den judiskt år. Året visas som 5729 oavsett denna inställning.<br /><br />Obs: Denna inställningen liknar kalenderkonstanten CAL_JEWISH_ADD_ALAFIM.";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]		= "Visa hebreiska Gershayim";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"]	= "~#pgv_lang[DISPLAY_JEWISH_GERESHAYIM]#~<br /><br />Visa enkla och dubbla anföringstecken («'» och «\"») när hebreiska datum visas.<br /><br />Om du ställer in detta till <b>#pgv_lang[yes]#</b> visas den 8 februari 1969 som <span lang='he-IL' dir='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; medan du ställer in den på <b>#pgv_lang[no]#</b> visas den som <span lang='he-IL' dir='rtl'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;.  Detta har ingen inverkan på det judiska året eftersom citattecken inte används i judiska datum som visas med latinska tecken.<br /><br />Obs! Denna inställningen liknar kalenderkonstanterna CAL_JEWISH_ADD_ALAFIM_GERESH och CAL_JEWISH_ADD_GERESHAYIM. Denna inställning påverkar båda.";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"]	= "Judiskt Ashkenaz uttal";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"]	= "~#pgv_lang[JEWISH_ASHKENAZ_PRONUNCIATION]#~<br /><br />När den är inställd på <b>#pgv_lang[yes]#</b> kommer Cheshvan och Teves att stavas med Ashkenazi-uttal. Om du ställer in det på <b>#pgv_lang[no]#</b> ändras månaderna till Hesvan och Tevet. Detta påverkar bara den judiska miljön. Den hebreiska inställningen använder alltid det hebreiska alfabetet.";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"]	= "Antal stamtavla generationer";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"]	= "~#pgv_lang[DEFAULT_PEDIGREE_GENERATIONS]#~<br /><br />Ställ in standardantalet generationer som ska visas i härkomst- och stamtavla.";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"]		= "Maximalt antal stamtavla generationer";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"]	= "~#pgv_lang[MAX_PEDIGREE_GENERATIONS]#~<br /><br />Set the maximum number of generations to display on Pedigree charts.";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"]	= "Maximalt antal efterkommande generationer";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"]	= "~#pgv_lang[MAX_DESCENDANCY_GENERATIONS]#~<br /><br />Ställ in det maximala antalet generationer som ska visas i efterkommande diagram.";
$pgv_lang["SOSA_WIDTH_NORMAL"]		= "Normal bredd på SOSA-nummer";
$pgv_lang["SOSA_WIDTH_NORMAL_help"]	= "~#pgv_lang[SOSA_WIDTH_NORMAL]#~<br /><br />Hur mycket utrymme som ska reserveras för SOSA-nummer i diagram<br /><br /><b>#pgv_lang[variable]#</b> indikerar att bredden inte är fast och det tryckta SOSA-numret tar lika mycket utrymme som den behöver. Resten av diagrammet kommer att placeras därefter.";
$pgv_lang["SOSA_WIDTH_WIDE"]		= "Extra bredd på SOSA-nummer";
$pgv_lang["SOSA_WIDTH_WIDE_help"]	= "~#pgv_lang[SOSA_WIDTH_WIDE]#~<br /><br />Hur mycket utrymme som ska reserveras för SOSA-nummer i broschyrvyn i härkomstdiagrammet<br /><br /><b>#pgv_lang[variable]#</b> indikerar att bredden inte är fast och det tryckta SOSA-numret tar lika mycket utrymme som den behöver. Resten av diagrammet kommer att placeras därefter.";
$pgv_lang["USE_RIN"]			= "Använd RIN-nummer istället för GEDCOM-ID";
$pgv_lang["USE_RIN_help"]		= "~#pgv_lang[USE_RIN]#~<br /><br />Ställ in på <b>#pgv_lang[yes]#</b> för att använda RIN-numret istället för GEDCOM-ID när du blir ombedd att ange person-ID i konfigurationsfiler, användarinställningar och diagram. Detta är användbart för släktforskningsprogram som inte konsekvent exporterar GEDCOM med samma ID som tilldelats varje person men alltid använder samma RIN.";
$pgv_lang["GENERATE_GUID"]		= "Skapa automatiskt globalt unika ID";
$pgv_lang["GENERATE_GUID_help"]	= "~#pgv_lang[GENERATE_GUID]#~<br /><br /><b>GUID</b> i detta sammanhang är en förkortning för «Globalt unikt ID».<br /><br />GUID är avsedda att hjälpa till att identifiera varje person på ett sätt som är repeterbart, så att centrala organisationer som Familjehistoriskt centrum för SDH-kyrkan i Salt Lake City, eller till och med kompatibla program som körs på din egen server, kan avgöra om de har att göra med samma person oavsett var GEDCOM kommer. Målet med Family History Center är att ha ett centralt arkiv med släktforskningsdata och exponera det via webbtjänster. Detta gör det möjligt för alla program att komma åt data och uppdatera deras data inom den.<br /><br />Om du inte tänker dela denna GEDCOM med någon annan behöver du inte låta PhpGedView skapa dessa GUIDer; Om du gör det kommer du inte att skada något annat än att öka storleken på din GEDCOM.";
$pgv_lang["PEDIGREE_ROOT_ID"]		= "Standardperson för stamtavla och efterkommande diagram";
$pgv_lang["PEDIGREE_ROOT_ID_help"]	= "~#pgv_lang[PEDIGREE_ROOT_ID]#~<br /><br />Ställ in ID för standardpersonen som ska visas i stamtavla och efterkommande diagram.";
$pgv_lang["GEDCOM_ID_PREFIX"]		= "Prefix för person-ID";
$pgv_lang["GEDCOM_ID_PREFIX_help"]	= "~#pgv_lang[GEDCOM_ID_PREFIX]#~<br /><br />När en ny personpost läggs till online i PhpGedView skapas ett nytt ID för den personen automatiskt. ID kommer att ha detta prefix.";
$pgv_lang["SOURCE_ID_PREFIX"]		= "Prefix för käll-ID";
$pgv_lang["SOURCE_ID_PREFIX_help"]	= "~#pgv_lang[SOURCE_ID_PREFIX]#~<br /><br />När en ny källpost läggs till online i PhpGedView genereras ett nytt ID för den källan automatiskt. ID kommer att ha detta prefix.";
$pgv_lang["REPO_ID_PREFIX"]		= "Prefix för arkiv-ID";
$pgv_lang["REPO_ID_PREFIX_help"]	= "~#pgv_lang[REPO_ID_PREFIX]#~<br /><br />När en ny arkivpost läggs till online i PhpGedView genereras ett nytt ID för det arkivet automatiskt. ID kommer att ha detta prefix.";
$pgv_lang["PEDIGREE_FULL_DETAILS"]	= "Visa detaljer om födelse och död i diagram";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"]	= "~#pgv_lang[PEDIGREE_FULL_DETAILS]#~<br /><br />Detta val styr huruvida en persons födelse- och dödsinformation ska visas i diagram eller inte.";
$pgv_lang["PEDIGREE_SHOW_GENDER"]	= "Visa könsikon på diagram";
$pgv_lang["PEDIGREE_SHOW_GENDER_help"]	= "~#pgv_lang[PEDIGREE_SHOW_GENDER]#~<br /><br />Detta val styr huruvida personens könsikon ska visas i diagram eller inte.<br /><br />Eftersom könen också indikeras av rutan på färgen, döljer detta val inte kön. Val tar helt enkelt bort dubblettinformation från rutan.";
$pgv_lang["PEDIGREE_LAYOUT"]		= "Standard stamtavla layout";
$pgv_lang["PEDIGREE_LAYOUT_help"]	= "~#pgv_lang[PEDIGREE_LAYOUT]#~<br /><br />Detta val anger om stamtavlan ska genereras i liggande eller stående läge.";
$pgv_lang["SHOW_EMPTY_BOXES"]		= "Visa tomma rutor på stamtavlor";
$pgv_lang["SHOW_EMPTY_BOXES_help"]	= "~#pgv_lang[SHOW_EMPTY_BOXES]#~<br /><br />Detta val styr om tomma rutor ska visas i stamtavla eller inte.";
$pgv_lang["ZOOM_BOXES"]			= "Zooma rutor på diagram";
$pgv_lang["ZOOM_BOXES_help"]		= "~#pgv_lang[ZOOM_BOXES]#~<br /><br />Tillåter en användare att zooma rutor på diagram för att få mer information.<br /><br />Ställ in på <b>#pgv_lang[disabled]#</b> för att inaktivera denna funktionen. Ställ in på <b>#pgv_lang[mouseover]#</b> för att zooma rutor när användaren musar över ikonen i rutan. Ställ in på <b>#pgv_lang[click]#</b> för att zooma rutor när användaren klickar på ikonen i rutan.";
$pgv_lang["LINK_ICONS"]			= "Visa länkar på diagram";
$pgv_lang["LINK_ICONS_help"]		= "~#pgv_lang[LINK_ICONS]#~<br /><br />Låter användaren välja länkar till andra diagram och stänga släktingar till personen.<br /><br />Ställ in på <b>#pgv_lang[disabled]#</b> för att inaktivera denna funktionen. Ställ in på <b>#pgv_lang[mouseover]#</b> för att visa länkarna när användaren musar över ikonen i rutan. Ställ in på <b>#pgv_lang[click]#</b> för att visa länkarna när användaren klickar på ikonen i rutan.";
$pgv_lang["ABBREVIATE_CHART_LABELS"]			= "Förkorta etiketter på diagram";
$pgv_lang["ABBREVIATE_CHART_LABELS_help"]		= "~#pgv_lang[ABBREVIATE_CHART_LABELS]#~<br /><br />Detta val styr huruvida etiketter som <b>Födelse</b> på diagram ska förkortas med bara den första bokstaven som <b>F</b>.<br /><br />Du kan anpassa förkortningarna genom att ange överordnade värden i filen <i>languages/extra.xx.php</i> för varje språk. Om du till exempel vill använda <b>*</b> istället för <b>N</b> för att förkorta BIRT faktumet på det franska språket, bör du lägga till följande inlägg i <i>languages/extra.fr.php</i> fil: <br /><code>\$factAbbrev[\"BIRT\"]&nbsp;=&nbsp;\"*\";</code><br /><br />Längderna på förkortningar som anges på detta sätt är inte begränsade till 1 tecken.";
$pgv_lang["SHOW_AGE_DIFF"]			= "Visa datumskillnader";
$pgv_lang["SHOW_AGE_DIFF_help"]		= "~#pgv_lang[SHOW_AGE_DIFF]#~<br /><br />Detta val styr om fliken Nära Släktingar ska visa skillnader mellan makarnas födelsedatum, mellan äktenskapsdatum och födelsedatum för det första barnet och mellan barns födelsedatum.";
$pgv_lang["SHOW_PARENTS_AGE"]			= "Visa föräldrarnas ålder bredvid barnets födelsedatum";
$pgv_lang["SHOW_PARENTS_AGE_help"]		= "~#pgv_lang[SHOW_PARENTS_AGE]#~<br /><br />Detta val styr om faderns och mammans ålder ska visas bredvid barnets födelsedatum på diagram eller inte.";
$pgv_lang["SHOW_RELATIVES_EVENTS"]      = "Visa händelser för nära släktingar på sidan «Personliga detaljer»";
$pgv_lang["SHOW_RELATIVES_EVENTS_help"] = "~#pgv_lang[SHOW_RELATIVES_EVENTS]#~<br /><br />Födslar, äktenskap och släktingas död är viktiga händelser i ens liv. Detta val styr huruvida dessa händelser ska visas eller inte på fliken «Personliga fakta och detaljer» på sidan «Personliga detaljer».<br /><br />Händelserna som påverkas av detta val är:<ul><li>Makens död</li><li>Barns födelse och död</li><li>Föräldrarnas död</li><li>Syskonas födelse och död</li><li>Farföräldrars död</li><li>Föräldrarnas syskonas födelse och död</li></ul>";
$pgv_lang["EXPAND_RELATIVES_EVENTS"]      = "Expandera automatiskt lista över händelser för nära släktingar";
$pgv_lang["EXPAND_RELATIVES_EVENTS_help"] = "~#pgv_lang[EXPAND_RELATIVES_EVENTS]#~<br /><br />Detta val styr om lista över <i>Händelser för Nära Släktingar</i> automatiskt ska utvidgas eller inte.";
$pgv_lang["EXPAND_SOURCES"]      = "Expandera källorna automatiskt";
$pgv_lang["EXPAND_SOURCES_help"] = "~#pgv_lang[EXPAND_SOURCES]#~<br /><br />Detta val styr om innehållet i en <i>källa</i> post automatiskt ska visas på sidan <i>#pgv_lang[personal_details]#</i>.";
$pgv_lang["EXPAND_NOTES"]      = "Expandera anteckningarna automatiskt";
$pgv_lang["EXPAND_NOTES_help"] = "~#pgv_lang[EXPAND_NOTES]#~<br /><br />Detta val styr om innehållet i en <i>NOTE</i> post automatiskt ska visas på <i>#pgv_lang[personal_details]#</i> sidan.";
$pgv_lang["SHOW_LEVEL2_NOTES"]      = "Visa alla referenser till anteckningar och källor på flikarna anteckningar och källor";
$pgv_lang["SHOW_LEVEL2_NOTES_help"] = "~#pgv_lang[SHOW_LEVEL2_NOTES]#~<br /><br />Detta val styr om referenser till anteckningar och källor som är bifogade fakta ska visas på flikarna anteckningar och källor på sidan <i>#pgv_lang[personal_details]#</i>.<br /><br />Vanligtvis visas flikarna anteckningar och källor bara Anteckningar och källreferenser som bifogas direkt till personens databasregister. Dessa är <i>nivå 1</i> anteckningar och källreferenser.<br /><br />Val <b>#pgv_lang[yes]#</b> gör att dessa flikar också visar anteckningar och källreferenser som ingår i de olika fakta i personens databasregister. Dessa är <i>nivå 2</i> referenser eftersom de olika fakta ligger på nivå 1.";
$pgv_lang["HIDE_LIVE_PEOPLE"]		= "Aktivera sekretess";
$pgv_lang["HIDE_LIVE_PEOPLE_help"]	= "~#pgv_lang[HIDE_LIVE_PEOPLE]#~<br /><br />Detta val aktiverar alla sekretessinställningar och döljer detaljerna om levande människor.<br /><br />Levande människor definieras som de som inte har en händelse på senare tid än det antal år som anges <b>#pgv_lang[MAX_ALIVE_AGE]#</b> inställning, som för närvarande är <b>#GLOBALS[MAX_ALIVE_AGE]#</b>. För detta ändamål anses födelse av barn också vara sådana händelser.";
$pgv_lang["REQUIRE_AUTHENTICATION"]	= "Kräver autentisering av besökare";
$pgv_lang["REQUIRE_AUTHENTICATION_help"]	= "~#pgv_lang[REQUIRE_AUTHENTICATION]#~<br /><br />Om du aktiverar detta val tvingas alla besökare att logga in innan de kan se data på webbplatsen.";
$pgv_lang["PAGE_AFTER_LOGIN"]		= "Sida att visa efter inloggning";
$pgv_lang["PAGE_AFTER_LOGIN_help"]	= "~#pgv_lang[PAGE_AFTER_LOGIN]#~<br /><br />Vilken sida ska användarna se efter att de har loggat in?<br /><br />Valetta avgör om en lyckad inloggning får välkomst- eller MyGedView-sidan att visas när inloggningen görs från #pgv_lang[welcome_page]#.<br /><br />En inloggning som görs från länken högst upp på varannan sida returnerar användaren till den sidan.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"]	= "Välkomsttext på inloggningssidan";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE]#~<br /><br />Här kan du välja text som ska visas på inloggningsskärmen. Du måste bestämma vilken fördefinierad text som är mest lämplig.<br /><br />Du kan också välja att skriva in din egen anpassade välkomsttext, men texten du anger kommer inte att översättas när användarna byter språk. Om din anpassade text innehåller referenser till språkvariabler som du kan definiera på de olika <i>languages/extra.xx.php</i> filerna kan din webbplats dock visa översatt text. Se hjälptexten i fältet <b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#</b> för mer information.<br /><br />De fördefinierade texterna är:<ul><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT1]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_1]#</div><br /></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT2]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_2]#</div><br /></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT3]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_3]#</div></li></ul>";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT0"]	= "Ingen fördefinierad text";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"]	= "Fördefinierad text som anger att alla användare kan begära ett användarkonto";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"]	= "Fördefinierad text som anger att administratören kommer att besluta om varje begäran om ett användarkonto";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"]	= "Fördefinierad text som anger att endast familjemedlemmar kan begära ett användarkonto";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"]	= "Välj användardefinierad välkomsttext skriven nedan";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"]	= "Anpassad välkomsttext";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#~<br /><br />Om du har valt anpassad välkomsttext kan du skriva texten här. Texten kommer INTE att översättas till besökarens språk, men kommer att visas exakt som du skrev den. Om din anpassade text innehåller referenser till språkvariabler som du kan definiera på de olika <i>languages/extra.xx.php</i> filerna kan din webbplats visa översatt text.<br /><br />Du kan infoga HTML-taggar i din anpassade välkomsttext.<br /><br />Följande beskrivning, hämtad från hjälptexten för FAQ listan, är lika tillämplig på den anpassade välkomsttexten.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"] = "Standardbörjan på anpassad välkomsttext";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD_help"] = "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST_HEAD]#~<br /><br />Välj att visa en standardstarttext för din anpassade välkomsttext. När dina användare byter språk kommer denna början att visas på det nya språket.<br /><br />Om den är inställd på <b>#pgv_lang[yes]#</b>, ser början texten ut så här:<div class=\"list_value_wrap\">#pgv_lang[welcome_text_cust_head]#</div>";
$pgv_lang["SHOW_REGISTER_CAUTION"]			= "Visa acceptabelt användningsavtal på sidan «Begär nytt användarkonto»";
$pgv_lang["SHOW_REGISTER_CAUTION_help"]		= "~#pgv_lang[SHOW_REGISTER_CAUTION]#~<br /><br />När den är inställd på <b>#pgv_lang[yes]#</b>, kommer följande meddelande att visas ovanför inmatningsfälten på sidan <i>#pgv_lang[requestaccount]#</i>:<div class=\"list_value_wrap\">#pgv_lang[acceptable_use]#</div>";
$pgv_lang["CHECK_CHILD_DATES"]		= "Kontrollera datum för barn";
$pgv_lang["CHECK_CHILD_DATES_help"]	= "~#pgv_lang[CHECK_CHILD_DATES]#~<br /><br />Kontrollera barns datum när du bestämmer om en person är död. På äldre system och stora GEDCOM kan detta fördröja svarstiden på din webbplats.";
$pgv_lang["MAX_ALIVE_AGE"]		= "Ålder för att anta att en person är död";
$pgv_lang["MAX_ALIVE_AGE_help"]		= "~#pgv_lang[MAX_ALIVE_AGE]#~<br /><br />Om denna person har några andra händelser än död, begravning eller kremering på senare tid än detta antal år anses han vara «vid liv». Barns födelsedatum anses vara sådana händelser för detta ändamål.";
$pgv_lang["SHOW_GEDCOM_RECORD"]		= "Tillåt användare att se råa GEDCOM-poster";
$pgv_lang["SHOW_GEDCOM_RECORD_help"]	= "~#pgv_lang[SHOW_GEDCOM_RECORD]#~<br /><br />Om du ställer in detta till <b>#pgv_lang[yes]#</b> placeras länkar på personer, källor och familjer så att användare kan ta upp ett annat fönster som innehåller rådata som tas direkt ur GEDCOM filen.";
$pgv_lang["ALLOW_EDIT_GEDCOM"]		= "Aktivera redigering online";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"]	= "~#pgv_lang[ALLOW_EDIT_GEDCOM]#~<br /><br />Detta val möjliggör redigeringsfunktioner online för denna databas så att användare med redigeringsbehörigheter kan uppdatera data online.";
$pgv_lang["ENABLE_AUTOCOMPLETE"]	= "Aktivera autoslutförande";
$pgv_lang["ENABLE_AUTOCOMPLETE_help"]	= "~#pgv_lang[ENABLE_AUTOCOMPLETE]#~<br /><br />Detta val avgör om Autoslutför ska vara aktiv medan information matas in i vissa fält på inmatningsformulär. När detta val är inställt på <b>#pgv_lang[yes]#</b> indikeras textinmatningsfält för vilka autoslutförande är möjligt med en annan färgad bakgrund.<br /><br />När autoslutförande är aktivt, PhpGedView kommer att söka i databasen efter möjliga matchningar enligt vad du redan har angett. När du anger mer information förfinas listan över möjliga matchningar. När du ser önskad inmatning i matchningslistan kan du flytta muspekaren till den raden i listan och klicka sedan på vänster musknapp för att slutföra inmatningen.<br /><br />Nackdelarna med Autoslutförande är att det saktar ner programmet, innebär betydande databasaktivitet och resulterar också i att mer data skickas till webbläsaren.";
$pgv_lang["USE_REFN"]		= "Använd Referensnummer";
$pgv_lang["USE_REFN_help"]	= "~#pgv_lang[USE_REFN]#~<br /><br />Det här alternativet avgör om #factarray[REFN]# som anges i detaljerna för en <u>ny</u> person ska användas som ID-nummer för den nya personen.<br /><br />När det här alternativet är inställt på <b>#pgv_lang[yes]#</b>, måste #factarray[REFN]# anges följa reglerna som fastställts för alla ID-nummer, och en person med det ID måste inte redan finnas databas. Om dessa villkor inte är uppfyllda eller om detta alternativ är inställt på <b>#pgv_lang[no]#</b>, tilldelar PhpGedView automatiskt nästa tillgängliga ID-nummer till den nya personen.<br /><br />Giltiga ID-nummer kan endast innehålla bokstäverna <b>A</b> till <b>Z</b>, <b>a</b> till <b>z</b>, siffror <b>0</b> till <b>9</b> och specialsymbolerna <b>. : -</b> och <b>_</b><br /><br />Du måste också aktivera visning av #factarray[REFN]# genom att lägga till posten <b>REFN</b> i konfigurationsalternativen <b>#pgv_lang[INDI_FACTS_UNIQUE]#</b>, <b>#pgv_lang[INDI_FACTS_QUICK]#</b> och <b>#pgv_lang[QUICK_REQUIRED_FACTS]#</b> nedan.";
$pgv_lang["EDIT_AUTOCLOSE"]		= "Stäng redigeringsfönstret automatiskt";
$pgv_lang["EDIT_AUTOCLOSE_help"]	= "~#pgv_lang[EDIT_AUTOCLOSE]#~<br /><br />Detta val styr om Redigera-fönstret ska stängas automatiskt efter en lyckad uppdatering.";
$pgv_lang["INDEX_DIRECTORY_help"]	= "~#pgv_lang[INDEX_DIRECTORY]#~<br /><br />Sökvägen till en läsbar och skrivbar mapp där PhpGedView ska lagra indexfiler (inkludera efterföljande «/»). PhpGedView kräver inte att denna mappens namn ska vara «index». Du kan välja vilket namn du vill.<br /><br />Av säkerhetsskäl bör denna mappen placeras någonstans i serverns filutrymme som inte är tillgänglig från Internet. Ett exempel på en sådan struktur följer:<br /><b>PhpGedView:</b> dir1/dir2/dir3/PhpGedView<br /><b>Index:</b> dir1/dir4/dir5/dir6/index<br /><br />För det visade exemplet anger du <b>../../dir4/dir5/dir6/index/</b> i detta fältet.";
$pgv_lang["POSTAL_CODE"]  = "Postnummer position";
$pgv_lang["POSTAL_CODE_help"] = "~#pgv_lang[POSTAL_CODE]#~<br /><br />Olika länder använder olika sätt att skriva adressen. Detta val gör att du kan placera postnumret antingen före eller efter stadens namn.";
$pgv_lang["SUBLIST_TRIGGER_I"]		= "Maximalt antal efternamn";
$pgv_lang["SUBLIST_TRIGGER_I_help"]	= "~#pgv_lang[SUBLIST_TRIGGER_I]#~<br /><br />Långa listor med personer med samma efternamn kan delas upp i mindre underlistor enligt den första bokstaven i personens förnamn.<br /><br />Detta val avgör när underlistning av efternamn ska ske. För att inaktivera underförteckning helt, ställ in detta val till noll.";
$pgv_lang["SUBLIST_TRIGGER_F"]		= "Maximalt antal familjenamn";
$pgv_lang["SUBLIST_TRIGGER_F_help"]	= "~#pgv_lang[SUBLIST_TRIGGER_F]#~<br /><br />Långa listor med familjer med samma namn kan delas upp i mindre underlistor enligt den första bokstaven i det angivna namnet.<br /><br />Detta val avgör när underlistning av släktnamn ska ske. För att inaktivera underförteckning helt, ställ in detta val till noll.";
$pgv_lang["SURNAME_LIST_STYLE"]		= "Efternamn list stil";
$pgv_lang["SURNAME_LIST_STYLE_help"]	= "~#pgv_lang[SURNAME_LIST_STYLE]#~<br /><br />Listor med efternamn, som de visas i #pgv_lang[block_top10]# block, #pgv_lang[individual_list]# och #pgv_lang[family_list]#, kan visas i olika stilar.<ul><li><b>#pgv_lang[style2]#</b>&nbsp;&nbsp;&nbsp;I denna stilen visas efternamnen i en tabell som kan sorteras antingen efter efternamn eller efter antal.</li><li><b>#pgv_lang[style3]#</b>&nbsp;&nbsp;&nbsp;I denna stilen visas efternamnen i en lista och teckensnittsstorleken som används för varje namn beror på antalet förekomster av det namnet i databasen. Listan kan inte sorteras.</li></ul>";
$pgv_lang["SHOW_ID_NUMBERS_help"]	= "~#pgv_lang[SHOW_ID_NUMBERS]#~<br /><br />Detta val styr om ID-nummer ska visas inom parentes efter namn på diagram och listor.";
$pgv_lang["SHOW_LAST_CHANGE"]		= "Visa datum för senaste ändring";
$pgv_lang["SHOW_LAST_CHANGE_help"]	= "~#pgv_lang[SHOW_LAST_CHANGE]#~<br /><br />Detta val styr om datum för senaste ändring ska visas i listor eller inte.";
$pgv_lang["SHOW_EST_LIST_DATES"]		= "Visa beräknade datum för födelse och död";
$pgv_lang["SHOW_EST_LIST_DATES_help"]	= "~#pgv_lang[SHOW_EST_LIST_DATES]#~<br /><br />Detta val styr huruvida uppskattade datum för födelse och död ska visas eller inte istället för att lämna tomma i personlistor och diagram för personer vars datum inte är kända.";
$pgv_lang["SHOW_PEDIGREE_PLACES"]	= "Antal platsnivåer som ska visas i personlådor";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"]	= "~#pgv_lang[SHOW_PEDIGREE_PLACES]#~<br /><br />Detta ställer in hur mycket av platsinformationen som visas i personrutorna på diagrammen.<br /><br />Att ställa in värdet till 9 garanterar att alla platsnivåer visas. Om du ställer in värdet på 0 döljs platser helt. Om du ställer in värdet på 1 visas den första nivån, om du ställer in den på 2 visas de två första nivåerna etc.";
$pgv_lang["pageSizeDefault"]			= "Standard sidstorlek";
$pgv_lang["pageSizeDefault_help"]		= "~#pgv_lang[pageSizeDefault]#~<br /><br />Detta är standardsidstorleken för alla rapporter. Ditt val kan åsidosättas i de enskilda rapporterna.";
$pgv_lang["pageSizeOptions"]			= "Sidstorlekar";
$pgv_lang["pageSizeOptions_help"]		= "~#pgv_lang[pageSizeOptions]#~<br /><br />Det här är listan över sidstorlekar som för närvarande stöds av PhpGedView när du genererar rapporter. Du kan utöka listan genom att lägga till andra standardstorlekar som anges i <a href='https://sv.wikipedia.org/wiki/Pappersformat' title='Artikel Wikipedia' target='_blank'><b>Artikel Wikipedia</b></a><br /><ul><li>Standard sidstorlek för större delen av världen är <b>A4</b>, vilket motsvarar 210 x 297 mm (8,3 x 11,7 tum.)</li><li>Den nordamerikanska standardsidstorleken är <b>letter</b>, vilket motsvarar 216 x 279 mm (8,5 x 11,0 tum.)</li><li>Andra tillgängliga storlekar finns <b>A3</b>, vilket motsvarar 297 x 420 mm (11,7 x 16,5 tum.)</li><li>och <b>legal</b>, vilket motsvarar 216 x 356 mm (8,5 x 14,0 tum.)</li></ul><br />Var försiktig när du lägger till andra pappersstorlekar än de som finns i ISO «A» listan; inte alla ISO-standardstorlekar har testats.";
$pgv_lang["fontsDefault"]				= "Standardtypsnitt";
$pgv_lang["fontsDefault_help"]			= "~#pgv_lang[fontsDefault]#~<br /><br />Detta är standardtypsnittet för alla rapporter. Ditt val kan åsidosättas i de enskilda rapporterna.";
$pgv_lang["fontsOptions"]				= "Typsnitt";
$pgv_lang["fontsOptions_help"]			= "~#pgv_lang[fontsOptions]#~<br /><br />Det här är listan över typsnitt som för närvarande stöds av PhpGedView när du genererar rapporter.<br /><br />Du kan utöka listan eller förkorta den vid behov. Försiktighet rekommenderas vid utvidgning av listan; inte alla teckensnitt som finns i <i>includes/tcpdf/fonts</i> biblioteket har testats.";
$pgv_lang["MULTI_MEDIA"]		= "Aktivera multimediafunktioner";
$pgv_lang["MULTI_MEDIA_help"]		= "~#pgv_lang[MULTI_MEDIA]#~<br /><br />GEDCOM 5.5.1 låter dig länka bilder, videor och andra multimediaobjekt till din GEDCOM. Om du inte inkluderar multimediaobjekt i din GEDCOM kan du inaktivera multimediefunktionerna genom att ställa in detta värde till <b>#pgv_lang[no]#</b>.<br /><br />Se avsnittet Multimedia i <a href=\"readme.txt\">readme.txt</a> fil för mer information om att inkludera media på din webbplats.";
$pgv_lang["MEDIA_EXTERNAL"]			= "Behåll länkar";
$pgv_lang["MEDIA_EXTERNAL_help"]	= "~#pgv_lang[MEDIA_EXTERNAL]#~<br /><br />När en multimedialänk hittas med till exempel http://, ftp://, mms://  kommer den inte att ändras när den är inställd på <b>#pgv_lang[yes]#</b>. Till exempel kommer http://www.myfamily.com/photo/dad.jpg att förbli http://www.myfamily.com/photo/dad.jpg. När den är inställd på <b>#pgv_lang[no]#</b> hanteras länken som en standardreferens och mediedjupet kommer att användas. Till exempel: http://www.myfamily.com/photo/dad.jpg ändras till ./media/dad.jpg";
$pgv_lang["MEDIA_DIRECTORY"]		= "Multimedia mapp";
$pgv_lang["MEDIA_DIRECTORY_help"]	= "~#pgv_lang[MEDIA_DIRECTORY]#~<br /><br />Sökvägen till en läsbar och skrivbar mapp där PhpGedView ska lagra mediefiler (inkludera efterföljande «/»). PhpGedView kräver inte att denna mappens namn ska vara «media». Du kan välja vilket namn du vill.<br /><br />Även om mediabrandväggsfunktionen låter dig lagra mediefiler i ett område på serverns filutrymme som inte är tillgängligt från Internet, måste mappen här fortfarande vara och måste kunna läsas från Internet och skrivas av PhpGedView. Mer information finns i konfigurationsalternativen för medieväggväggen i avsnittet Multimedia på GEDCOM-konfigurationssidan.";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"]	= "Antal multimediamappnivåer som ska behållas";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"]	= "~#pgv_lang[MEDIA_DIRECTORY_LEVELS]#~<br /><br />Värdet 0 ignorerar alla kataloger i filvägen för medieobjektet. Värdet 1 behåller den första mappen som innehåller denna bilden. Att öka antalet ökar antalet föräldrakataloger som ska behållas i sökvägen.<br /><br />Till exempel om du länkar en bild i din GEDCOM med en sökväg som <b>C:\\Documents&nbsp;and&nbsp;Settings\\User\\My&nbsp;Documents\\My&nbsp;Pictures\\Genealogy\\Surname&nbsp;Line\\grandpa.jpg</b>, värdet 0 översätter denna sökväg till <b>./media/grandpa.jpg</b>. Värdet 1 översätter detta till <b>./media/Surname&nbsp;Line/grandpa.jpg</b>, etc. De flesta behöver bara använda en 0. Det är dock möjligt att vissa medieobjekt hålls i olika kataloger har identiska namn och skulle skriva över varandra när detta val är inställt på 0. Icke-noll inställningar gör att du kan behålla någon organisation i dina media och därigenom förhindra kollisioner med namn.";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"]	= "~#pgv_lang[SHOW_HIGHLIGHT_IMAGES]#~<br /><br />Om du har aktiverat multimedia på din webbplats kan du låta PhpGedView visa en miniatyrbild bredvid personens namn i diagram och rutor.<br /><br />Se avsnittet Multimedia i <a href=\"readme.txt\">readme.txt</a> fil för mer information om att inkludera media på din webbplats.";
$pgv_lang["USE_THUMBS_MAIN"]	= "Använd miniatyrbild";
$pgv_lang["USE_THUMBS_MAIN_help"]	= "~#pgv_lang[USE_THUMBS_MAIN]#~<br /><br />Detta val avgör om PhpGedView ska skicka den stora eller den lilla bilden till webbläsaren när ett diagram eller sidan <i>#pgv_lang[personal_details]#</i> kräver en miniatyrbild.<br /><br /><b>#pgv_lang[no]#</b> val kommer att få PhpGedView att skicka den stora bilden, medan valet <b>#pgv_lang[yes]#</b> kommer att få den lilla bilden att skickas. Varje enskild bild har också val «#factarray[_THUM]#» som, när den är inställd på <b>#pgv_lang[yes]#</b>, kommer att göra att den stora bilden skickas oavsett inställningen för «#pgv_lang[USE_THUMBS_MAIN]#» val i GEDCOM-konfigurationen. Du kan inte tvinga PhpGedView att skicka små bilder när GEDCOM-konfigurationen anger att stora bilder alltid ska användas.<br /><br />PhpGedView ändrar inte storleken på bilden som skickas. webbläsaren gör detta enligt de sidspecifikationer som den också har fått. Detta kan få oönskade konsekvenser när bilden som skickas inte är en miniatyrbild där PhpGedView förväntar sig att skicka en liten bild. Detta är inte ett fel: Det finns tillfällen där det kan vara önskvärt att visa en stor bild på platser där man normalt förväntar sig att se en miniatyrstorlek.<br /><br />Du bör undvika att ställa in «#pgv_lang[USE_THUMBS_MAIN]#» val till <b>#pgv_lang[no]#</b>. Detta val kommer att leda till att stora mängder bildrelaterad data skickas till webbläsaren, bara för att webbläsaren ska kasta överskottet. Sidbelastningar, särskilt av diagram med många bilder, kan sakta ner.";
$pgv_lang["SHOW_MEDIA_FILENAME"]		= "Visa filnamn i medievisaren";
$pgv_lang["SHOW_MEDIA_FILENAME_help"]	= "~#pgv_lang[SHOW_MEDIA_FILENAME]#~<br /><br />Medievisaren kan visa namnet på den mediefil som visas. Detta val avgör om filnamnet ska visas för användarna eller inte.<br /><br />Du kanske vill dölja filnamnet av säkerhetsskäl.";
$pgv_lang["SHOW_MEDIA_DOWNLOAD"]		= "Visa nedladdningslänk i medievisaren";
$pgv_lang["SHOW_MEDIA_DOWNLOAD_help"]	= "~#pgv_lang[SHOW_MEDIA_DOWNLOAD]#~<br /><br />Medievisaren kan visa en länk som, när den klickas, hämtar mediefilen till den lokala datorn.<br /><br />Du kanske vill dölja nedladdningslänken av säkerhetsskäl.";
$pgv_lang["ENABLE_CLIPPINGS_CART"]	= "Aktivera urklippsvagnen";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"]	= "~#pgv_lang[ENABLE_CLIPPINGS_CART]#~<br /><br />Urklippsvagnen tillåter användare att lägga till personer i en tillfällig fil som de kan ladda ner i GEDCOM format för senare import till deras släktforskningsprogram.";
$pgv_lang["HIDE_GEDCOM_ERRORS"]		= "Dölj GEDCOM fel";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"]	= "~#pgv_lang[HIDE_GEDCOM_ERRORS]#~<br /><br />Om du ställer in detta på <b>#pgv_lang[yes]#</b> döljs felmeddelanden som produceras av PhpGedView när det inte förstår en tagg i din GEDCOM-fil. PhpGedView gör allt för att följa GEDCOM 5.5.1-standarden, men många släktforskningsprogram innehåller egna anpassade taggar. Se <a href=\"readme.txt\">readme.txt</a> filen för mer information.";
$pgv_lang["WORD_WRAPPED_NOTES"]		= "Lägg till mellanslag där anteckningar lindades in";
$pgv_lang["WORD_WRAPPED_NOTES_help"]	= "~#pgv_lang[WORD_WRAPPED_NOTES]#~<br /><br />Vissa släktforskningsprogram slår anteckningar vid ordgränser medan andra slår anteckningar var som helst. Detta kan få PhpGedView att köra ord tillsammans. Om du ställer in detta till <b>#pgv_lang[yes]#</b> läggs ett mellanslag mellan ord där de är insvept i original GEDCOM.";
$pgv_lang["SHOW_CONTEXT_HELP"]		= "Visa kontextuella hjälplänkar";
$pgv_lang["SHOW_CONTEXT_HELP_help"]	= "~#pgv_lang[SHOW_CONTEXT_HELP]#~<br /><br />Detta val aktiverar länkar, identifierade med frågetecken, bredvid objekt på många sidor. Dessa länkar tillåter användare att få information eller hjälp om dessa objekt.";
$pgv_lang["DAYS_TO_SHOW_LIMIT"]		= "Daggräns för blocket Kommande händelser";
$pgv_lang["DAYS_TO_SHOW_LIMIT_help"] = "~#pgv_lang[DAYS_TO_SHOW_LIMIT]#~<br /><br />Ange det maximala antalet dagar som ska visas i blocket Kommande händelser. Siffran får inte vara större än 30. Om du anger ett större värde kommer 30 att användas.<br /><br />Värdet du anger här avgör hur långt framåt PhpGedView ser ut när du söker efter kommande evenemang. Resultaten av denna sökningen, som görs en gång dagligen, kopieras till en tillfällig fil.<br /><br />Inga kommande händelser på index eller portalsidor kan begära fler dagar än detta värde. Ju större du gör detta, desto längre tid tar det att bygga det dagliga databasextraktet, och desto längre tid tar det att visa blocket, även när du begär att visa ett antal dagar mindre än denna inställningen.";
$pgv_lang["COMMON_NAMES_THRESHOLD"]	= "Minsta antal händelser som ska vara ett «Frekventa efternamn»";
$pgv_lang["COMMON_NAMES_THRESHOLD_help"]	= "~#pgv_lang[COMMON_NAMES_THRESHOLD]#~<br /><br />Detta är antalet gånger som ett efternamn måste förekomma innan det dyker upp i listan över frekventa efternamn på välkomstsidan.";
$pgv_lang["COMMON_NAMES_ADD"]	= "Namn att lägga till i listan över frekventa efternamn";
$pgv_lang["COMMON_NAMES_ADD_help"]	= "~#pgv_lang[COMMON_NAMES_ADD]#~<br /><br />Om antalet gånger som ett visst efternamn förekommer är lägre än tröskeln, kommer det inte att visas i listan. Det kan läggas till här manuellt. Om mer än ett efternamn anges måste de skiljas åt med ett komma. <b>Efternamn är skiftlägeskänsliga.</b>";
$pgv_lang["COMMON_NAMES_REMOVE"]	= "Namn som ska tas bort från listan över frekventa efternamn";
$pgv_lang["COMMON_NAMES_REMOVE_help"]	= "~#pgv_lang[COMMON_NAMES_REMOVE]#~<br /><br />Om du vill ta bort ett efternamn från listan över frekventa efternamn utan att öka tröskelvärdet kan du göra det genom att ange efternamnet här. Om mer än ett efternamn anges måste de skiljas åt med ett komma. <b>Efternamn är skiftlägeskänsliga.</b> Efternamn som anges här kommer också att tas bort från Topp 10-listan på välkomstsidan.";
$pgv_lang["HOME_SITE_URL"]		= "URL till huvudwebbplats";
$pgv_lang["HOME_SITE_URL_help"]		= "~#pgv_lang[HOME_SITE_URL]#~<br /><br />Varje PhpGedView-sida innehåller en länk till din huvudsida. Utseendet på denna länk styrs av temat som används. Du anger den faktiska webbadressen till din hemsida här.";
$pgv_lang["HOME_SITE_TEXT"]		= "Text på huvudwebbplatsen";
$pgv_lang["HOME_SITE_TEXT_help"]	= "~#pgv_lang[HOME_SITE_TEXT]#~<br /><br />Texten som används för att identifiera länken till din huvudsida.";
$pgv_lang["CONTACT_EMAIL"]		= "Släktforskning kontakt";
$pgv_lang["CONTACT_EMAIL_help"]		= "~#pgv_lang[CONTACT_EMAIL]#~<br /><br />Personen som ska kontaktas om genealogiska uppgifter på denna webbplats.";
$pgv_lang["CONTACT_METHOD"]		= "Kontaktmetod";
$pgv_lang["CONTACT_METHOD_help"]	= "~#pgv_lang[CONTACT_METHOD]#~<br /><br />Metoden som ska användas för att kontakta #pgv_lang[CONTACT_EMAIL]# om släktfrågor.#pgv_lang[CONTACT_METHOD_desc]#";
$pgv_lang["CONTACT_METHOD_desc"] = "<ul><li>Val <b>#pgv_lang[mailto]#</b> skapar en «mailto» länk som kan klickas för att skicka ett e-postmeddelande med e-postklienten på användarens computer.</li><li>Val <b>#pgv_lang[messaging]#</b> använder ett internt meddelandesystem i PhpGedView och inga e-postmeddelanden skickas.</li><li>Val <b>#pgv_lang[messaging2]#</b> är standard. Det kommer att använda PhpGedView-meddelandesystemet och kommer också att skicka kopior av meddelandena via e-post.</li><li>Med val <b>#pgv_lang[messaging3]#</b> kan PhpGedView hantera meddelandena och skickar meddelandena som e-post, men lagrar inte meddelandena internt. Detta val liknar val <b>#pgv_lang[mailto]#</b>, förutom att meddelandet skickas av PhpGedView istället för användarens computer.</li><li>Val <b>#pgv_lang[mailto]#</b> leder till att dina användare inte kan kontakta dig.</li></ul>";
$pgv_lang["PHPGEDVIEW_EMAIL"]		= "Svarsadress för PhpGedView";
$pgv_lang["PHPGEDVIEW_EMAIL_help"]	= "~#pgv_lang[PHPGEDVIEW_EMAIL]#~<br /><br />E-postadress som ska användas i fältet «Från:» för e-postmeddelanden som PhpGedView skapar automatiskt.<br /><br />PhpGedView kan automatiskt skapa e-postmeddelanden för att meddela administratörer om ändringar som behöver granskas. PhpGedView skickar också e-postmeddelanden till användare som har begärt ett konto.<br /><br />Vanligtvis är fältet «Från:» för dessa automatiskt skapade e-postmeddelanden något som <i>Från: phpgedview-noreply@din_webbplats</i> för att visa att inget svar på e-postmeddelandet krävs. För att skydda mot skräppost eller annat e-postmissbruk kräver vissa e-postsystem varje meddelandes fält «Från:» för att återspegla ett giltigt e-postkonto och accepterar inte meddelanden som tydligen kommer från kontot <i>phpgedview-noreply</i>.";
$pgv_lang["WEBMASTER_EMAIL"]		= "Hjälpkontakt";
$pgv_lang["WEBMASTER_EMAIL_help"]	= "~#pgv_lang[WEBMASTER_EMAIL]#~<br /><br />Personen som ska kontaktas om tekniska frågor eller fel på din webbplats.";
$pgv_lang["SUPPORT_METHOD"]		= "Hjälpmetod";
$pgv_lang["SUPPORT_METHOD_help"]	= "~#pgv_lang[SUPPORT_METHOD]#~<br /><br />Metoden som ska användas för att kontakta #pgv_lang[WEBMASTER_EMAIL]# om tekniska frågor.#pgv_lang[CONTACT_METHOD_desc]#";
$pgv_lang["SHOW_FACT_ICONS"] 		= "Visa ikoner för fakta";
$pgv_lang["SHOW_FACT_ICONS_help"]	= "~#pgv_lang[SHOW_FACT_ICONS]#~<br /><br />Ställ in detta på <b>#pgv_lang[yes]#</b> för att visa ikoner nära faktanamn på sidan <i>#pgv_lang[personal_details]#</i>. Faktikoner visas endast om de finns i mappen <i>images/facts</i> för det aktuella temat.";
$pgv_lang["FAVICON"]			= "Favoritikonen";
$pgv_lang["FAVICON_help"]		= "~#pgv_lang[FAVICON]#~<br /><br />Ändra detta för att peka på ikonen du vill visa i besökarnas favoritmeny när de bokmärker din webbplats.";
$pgv_lang["THEME_DIR"]			= "Temamapp";
$pgv_lang["THEME_DIR_help"]		= "~#pgv_lang[THEME_DIR]#~<br /><br />Mappen där dina PhpGedView-temafiler förvaras.<br /><br />Du kan anpassa alla standardteman som kommer med PhpGedView för att ge din webbplats ett unikt utseende. Se avsnittet Temainpassning i <a href=\"readme.txt\">readme.txt</a> filen för mer information.";
$pgv_lang["TIME_LIMIT"]			= "PHP tidsgräns";
$pgv_lang["TIME_LIMIT_help"]		= "~#pgv_lang[TIME_LIMIT]#~<br /><br />Den maximala tiden i sekunder som PhpGedView ska få köras.<br /><br />Standardvärdet är 1 minut. Beroende på storleken på din GEDCOM-fil kan du behöva öka denna tidsgräns när du behöver bygga indexen. Ställ in detta värde till 0 så att PHP kan köras för alltid.<br /><br />FÖRSIKTIGHET: Om du ställer in detta på 0 eller ställer in det för högt kan din webbplats hänga på vissa operativsystem tills skriptet är klart. Att ställa in den på 0 betyder att den kanske aldrig slutar förrän en serveradministratör dödar processen eller startar om servern. Ett stort stamtavla kan ta mycket lång tid att köra; att låta detta värde vara så lågt som möjligt säkerställer att någon inte kan krascha din server genom att begära ett alltför stort diagram.";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"]	= "~#pgv_lang[PGV_SESSION_SAVE_PATH]#~<br /><br />Sökvägen till att lagra PhpGedView-sessionsfiler.<br /><br />Vissa värdar har inte konfigurerat PHP korrekt och sessioner underhålls inte mellan sidförfrågningar. Med detta val kan webbplatsadministratörer lösa problemet genom att spara filer i en av sina lokala kataloger. Mappen ./index/ är ett bra val om du behöver ändra detta. Standard är att lämna fältet tomt, vilket kommer att använda Spara sökvägen som konfigurerad i <i>php.ini</i>.";
$pgv_lang["SERVER_URL_help"]		= "~#pgv_lang[SERVER_URL]#~<br /><br />Om du använder https eller en annan port än standard måste du ange webbadressen för att komma åt din server här.";
$pgv_lang["LOGIN_URL"]			= "Inloggnings-URL";
$pgv_lang["LOGIN_URL_help"]		= "~#pgv_lang[LOGIN_URL]#~<br /><br />Du behöver bara ange en inloggnings-URL om du vill omdirigera till en annan webbplats eller plats när dina användare loggar in. Detta är mycket användbart om du behöver byta från http till https när dina användare loggar in. Inkludera hela webbadressen till <i>login.php</i>. Till exempel https://www.yourserver.com/phpgedview/login.php .";
$pgv_lang["PGV_SESSION_TIME_help"]	= "~#pgv_lang[PGV_SESSION_TIME]#~<br /><br />Tiden i sekunder som en PhpGedView-session förblir aktiv innan du kräver inloggning. Standard är 7200, vilket är 2 timmar.";
$pgv_lang["SHOW_STATS"]			= "Visa processstatistik";
$pgv_lang["SHOW_STATS_help"]		= "~#pgv_lang[SHOW_STATS]#~<br /><br />Visa processstatistik och databasfrågor längst ner på varje sida.";
$pgv_lang["SHOW_COUNTER"]		= "Visa träffräknare";
$pgv_lang["SHOW_COUNTER_help"]		= "~#pgv_lang[SHOW_COUNTER]#~<br /><br />Visa träffräknare på portalen och <i>#pgv_lang[personal_details]#</i> sidor.";
$pgv_lang["USE_REGISTRATION_MODULE_help"]	= "~#pgv_lang[USE_REGISTRATION_MODULE]#~<br /><br />Ger besökare möjlighet att registrera sig för ett konto på webbplatsen.<br /><br />Besökaren får ett e-postmeddelande med en kod för att verifiera sin ansökan om ett konto. Efter verifiering måste administratören godkänna registreringen innan den blir aktiv.";
$pgv_lang["ALLOW_USER_THEMES_help"]	= "~#pgv_lang[ALLOW_USER_THEMES]#~<br /><br />Ger användarna möjlighet att välja sitt eget tema.";
$pgv_lang["PGV_SIMPLE_MAIL_help"] = "~#pgv_lang[PGV_SIMPLE_MAIL]#~<br /><br />I vanliga mail används e-postadressen och namnet. Vissa e-postsystem accepterar inte detta. När den är inställd på <b>#pgv_lang[yes]#</b>, kommer endast e-postadressen att användas.";
$pgv_lang["PGV_SMTP_ACTIVE_help"] = "~#pgv_lang[PGV_SMTP_ACTIVE]#~<br /><br />Använd SMTP för att skicka e-post från PhpGedView.<br /><br />Detta val kräver åtkomst till en SMTP-e-postserver. När den är inställd på <b>#pgv_lang[no]#</b> använder PhpGedView e-postsystemet som är inbyggt i PHP på denna server.";
$pgv_lang["PGV_SMTP_DEBUG_help"] = "~#pgv_lang[PGV_SMTP_DEBUG]#~<br /><br />När alternativet <b>#pgv_lang[PGV_SMTP_ACTIVE]#</b> är inställt på <b>#pgv_lang[yes]#</b> kommer PhpGedView att använda PHPMailer-programmet för att skicka e-post. Det här programmet ger felmeddelanden när det stöter på problem när du försöker skicka e-post.<br /><br />Detta alternativ, som är användbart när du försöker lösa problem med att skicka e-post, avgör vilka typer av fel som PHPMailer kommer att rapportera. Feltyperna du kan välja är:<ul><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION0]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION1]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION2]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION3]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION4]#</li></ul>";
$pgv_lang["PGV_SMTP_HOST_help"] = "~#pgv_lang[PGV_SMTP_HOST]#~<br /><br />Detta är namnet på SMTP-e-postservern. Exempel: <b>smtp.foo.bar.com</b>.<br /><br />Konfigurationsvärden för vissa e-postleverantörer:<br /><br /><b>Gmail</b><br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_HOST]#:&nbsp;&nbsp;smtp.gmail.com<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_PORT]#:&nbsp;&nbsp;465 eller 587<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_SSL]#:&nbsp;&nbsp;SSL<br /><br /><b>Hotmail</b><br />&nbsp;&nbsp;&nbsp#pgv_lang[PGV_SMTP_HOST]#:&nbsp;&nbsp;smtp.live.com<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_PORT]#:&nbsp;&nbsp;25 eller 587<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_SSL]#:&nbsp;&nbsp;TLS<br /><br /><b>Yahoo Mail Plus</b> (för närvarande en betald tjänst)<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_HOST]#:&nbsp;&nbsp;smtp.mail.yahoo.com<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_PORT]#:&nbsp;&nbsp;25";
$pgv_lang["PGV_SMTP_HELO_help"] = "~#pgv_lang[PGV_SMTP_HELO]#~<br /><br />Detta är domändelen av en giltig e-postadress på SMTP-servern.<br /><br />Till exempel om du har ett e-postkonto som <b>ditt_namn@abc.xyz.com</b> skulle du ange <b>abc.xyz.com</b> här.";
$pgv_lang["PGV_SMTP_PORT_help"] = "~#pgv_lang[PGV_SMTP_PORT]#~<br /><br />Portnumret som ska användas för anslutningar till SMTP servern. I allmänhet är detta port <b>25</b>.";
$pgv_lang["PGV_SMTP_AUTH_help"] = "~#pgv_lang[PGV_SMTP_AUTH]#~<br /><br />Använd autentisering av namn och lösenord för att ansluta till SMTP-servern.<br /><br />Vissa SMTP servrar kräver att alla anslutningar verifieras innan de accepterar utgående e-post.";
$pgv_lang["PGV_SMTP_AUTH_USER_help"] = "~#pgv_lang[PGV_SMTP_AUTH_USER]#~<br /><br />Användarnamnet som krävs för autentisering med SMTP servern.";
$pgv_lang["PGV_SMTP_AUTH_PASS_help"] = "~#pgv_lang[PGV_SMTP_AUTH_PASS]#~<br /><br />Lösenordet som krävs för autentisering med SMTP servern.";
$pgv_lang["PGV_SMTP_SSL_help"]		 = "~#pgv_lang[PGV_SMTP_SSL]#~<br /><br />Transport Layer Security (TLS) och Secure Sockets Layer (SSL) är krypteringsprotokoll för internetdata.<br /><br />TLS 1.0, 1.1 och 1.2 är standardiserade utvecklingar av SSL 3.0. TLS 1.0 och SSL 3.1 är likvärdiga. Ytterligare arbete med SSL utförs nu under det nya namnet TLS.<br /><br />Om din SMTP-server kräver SSL-protokollet under inloggningen bör du välja val <b>SSL</b>. Om din SMTP-server kräver TLS-protokollet under inloggningen ska du välja val <b>TLS</b>.";
$pgv_lang["PGV_SMTP_FROM_NAME_help"] = "~#pgv_lang[PGV_SMTP_FROM_NAME]#~<br /><br />Ange namnet som ska användas i fältet «Från:» med e-postmeddelanden som härrör från denna webbplatsen.<br /><br />Till exempel om du heter <b>John Smith</b> och du är webbplatsadministratör för en webbplats som kallas <b>Jones Genealogy</b>, kan du ange något som <b>John&nbsp;Smith</b> eller <b>Jones&nbsp;Genealogy</b> eller till och med <b>John&nbsp;Smith,&nbsp;Administratör:&nbsp;Jones&nbsp;Genealogy</b>. Du kan ange vad du vill, men HTML är inte tillåtet.";
$pgv_lang["gedcom_title"]			= "#pgv_lang[ged_title]#";
$pgv_lang["gedcom_title_help"]		= "~#pgv_lang[gedcom_title]#~<br /><br />Ange en beskrivande titel som ska visas när användare väljer bland GEDCOM datamängder på din webbplats.";
$pgv_lang["LOGFILE_CREATE"]		= "Arkivera loggfilerna";
$pgv_lang["LOGFILE_CREATE_help"]	= "~#pgv_lang[LOGFILE_CREATE]#~<br /><br />Hur ofta ska programmet arkivera loggfilerna.";
$pgv_lang["REMINDER_FREQ"] 			= "Frekvens av e-mail påminnelser «Granskning av ändringar»";
$pgv_lang["REMINDER_FREQ_help"]		= "~#pgv_lang[REMINDER_FREQ]#~<br /><br />Det här alternativet styr hur ofta e-mail påminnelser «Granskning av ändringar» skickas. <b>noll</b>: aldrig;&nbsp;&nbsp;<b>1</b>: dagligen;&nbsp;&nbsp;<b>2</b>: varannan dag; osv.";
$pgv_lang["PGV_MEMORY_LIMIT_help"]	= "~#pgv_lang[PGV_MEMORY_LIMIT]#~<br /><br />Den maximala mängden minne som kan konsumeras av PhpGedView-skript. Standardvärdet är 64 Mb. Många värdar inaktiverar detta val i sin PHP konfiguration. att ändra detta värde kanske inte påverkar den aktuella maximala minnesinställningen.";
$pgv_lang["PGV_STORE_MESSAGES_help"]	= "~#pgv_lang[PGV_STORE_MESSAGES]#~<br /><br />Anger om meddelanden som skickas via PhpGedView kan lagras i databasen. Om den är inställd på <b>#pgv_lang[yes]#</b> kan användare hämta sina meddelanden när de loggar in på PhpGedView. Om inställt på <b>#pgv_lang[no]#</b> kommer meddelanden bara att mailas.";
$pgv_lang["ALLOW_THEME_DROPDOWN"]		= "Visa temamenyn för temändringar";
$pgv_lang["ALLOW_THEME_DROPDOWN_help"]	= "~#pgv_lang[ALLOW_THEME_DROPDOWN]#~<br /><br />Ger användarna möjlighet att välja sitt eget tema från en meny.<br /><br />Även med denna inställningen kanske det aktuella temat inte innehåller någon sådan meny. För att vara effektivt kräver detta val att val <b>#pgv_lang[ALLOW_USER_THEMES]#</b> också är inställt.";
$pgv_lang["MAX_VIEW_RATE"]		= "Maximal sidvisning hastighet";
$pgv_lang["MAX_VIEW_RATE_help"]	= "~#pgv_lang[MAX_VIEW_RATE]#~<br /><br />Detta val begränsar hastigheten med vilken en användare kan visa sidor.<br /><br />Om den hastigheten överskrids behandlar PhpGedView sessionen som ett hackningsförsök. sessionen avslutas med ett lämpligt meddelande. Dessa två värden bör placera en rimlig gräns för mängden bandbredd och nedladdade byte från servern. Denna funktion kan stängas av genom att ställa in tidsintervallet till 0.";
$pgv_lang["META_AUTHOR"]		= "META tag: Author (Författare)";
$pgv_lang["META_AUTHOR_help"]	= "~#pgv_lang[META_AUTHOR]#~<br /><br />Värdet som ska placeras i metataggen författare i HTML sidhuvudet. #pgv_lang[META_AUTHOR_descr]#";
$pgv_lang["META_AUTHOR_descr"]	= "Lämna detta fältet tomt för att använda det fullständiga namnet på #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_PUBLISHER"]		= "META tag: Publisher (Utgivare)";
$pgv_lang["META_PUBLISHER_help"]	= "~#pgv_lang[META_PUBLISHER]#~<br /><br />Värdet som ska placeras i metataggen utgivaren i HTML sidhuvudet. #pgv_lang[META_PUBLISHER_descr]#";
$pgv_lang["META_PUBLISHER_descr"]	= "Lämna detta fältet tomt för att använda det fullständiga namnet på #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_COPYRIGHT"]		= "META tag: Copyright (Upphovsrätt)";
$pgv_lang["META_COPYRIGHT_help"]	= "~#pgv_lang[META_COPYRIGHT]#~<br /><br />Värdet som ska placeras i metataggen upphovsrätt i HTML sidhuvudet. #pgv_lang[META_COPYRIGHT_descr]#";
$pgv_lang["META_COPYRIGHT_descr"]	= "Lämna detta fältet tomt för att använda det fullständiga namnet på #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_DESCRIPTION"]		= "META tag: Description (Beskrivning)";
$pgv_lang["META_DESCRIPTION_help"]	= "~#pgv_lang[META_DESCRIPTION]#~<br /><br />Värdet som ska placeras i metataggen beskrivning i HTML sidhuvudet. #pgv_lang[META_DESCRIPTION_descr]#";
$pgv_lang["META_DESCRIPTION_descr"]	= "Lämna fältet tomt för att använda titeln på den för närvarande aktiva databasen.";
$pgv_lang["META_PAGE_TOPIC"]		= "META tag: Page-topic (Ämne)";
$pgv_lang["META_PAGE_TOPIC_help"]	= "~#pgv_lang[META_PAGE_TOPIC]#~<br /><br />Värdet som ska placeras i metataggen ämne i HTML sidhuvudet. #pgv_lang[META_PAGE_TOPIC_descr]#";
$pgv_lang["META_PAGE_TOPIC_descr"]	= "Lämna fältet tomt för att använda titeln på den för närvarande aktiva databasen.";
$pgv_lang["META_AUDIENCE"]		= "META tag: Audience (Publik)";
$pgv_lang["META_AUDIENCE_help"]	= "~#pgv_lang[META_AUDIENCE]#~<br /><br />Värdet som ska placeras i metataggen publik i HTML sidhuvudet.";
$pgv_lang["META_PAGE_TYPE"]		= "META tag: Page-type (Sidtyp)";
$pgv_lang["META_PAGE_TYPE_help"]	= "~#pgv_lang[META_PAGE_TYPE]#~<br /><br />Värdet som ska placeras i metataggen sidtyp i HTML sidhuvudet.";
$pgv_lang["META_ROBOTS"]		= "META tag: Robots (Robotar)";
$pgv_lang["META_ROBOTS_help"]	= "~#pgv_lang[META_ROBOTS]#~<br /><br />Värdet som ska placeras i metataggen robotar i HTML sidhuvudet.  Vissa sökmotorer ignorerar detta värde.";
$pgv_lang["META_REVISIT"]		= "META tag: Revisit (Återbesök)";
$pgv_lang["META_REVISIT_help"]	= "~#pgv_lang[META_REVISIT]#~<br /><br />Hur ofta bör sökmotorerna besöka igen? Värdet som ska placeras i metataggen återbesök i HTML sidhuvudet.  Vissa sökmotorer ignorerar detta värde.";
$pgv_lang["META_KEYWORDS"]		= "META tag: Keywords (Nyckelord)";
$pgv_lang["META_KEYWORDS_help"]	= "~#pgv_lang[META_KEYWORDS]#~<br /><br />Värdet som ska placeras i metataggen nyckelord i HTML sidhuvudet.  Vissa sökmotorer använder metataggen nyckelord för att indexera din sida.<br /><br />Listan #pgv_lang[common_surnames]# som visas i blocket #pgv_lang[gedcom_stats]# på din välkomstsida kan också läggas till i allt du anger här.";
$pgv_lang["META_TITLE"]		= "Lägg till i TITLE taggen";
$pgv_lang["META_TITLE_help"]	=	"~#pgv_lang[META_TITLE]#~<br /><br />Allt på denna raden läggs till i TITLE taggen i HTML sidhuvudet efter den vanliga sidrubriken och före PhpGedView-krediten.";

$pgv_lang["ENABLE_RSS"]				= "Aktivera RSS";
$pgv_lang["ENABLE_RSS_help"]		= "~#pgv_lang[ENABLE_RSS]#~<br /><br />Med detta val kan du inaktivera RSS-funktionen.<br /><br />RSS låter användare övervaka din webbplats för ändringar av indexsidan utan att besöka din webbplats regelbundet. Om för många användare använder denna funktionen eller om uppdateringsfrekvensen som ställs in av dessa användare är för hög kan RSS använda för mycket bandbredd eller serverkapacitet.<br /><br />Detta <a href='https://sv.wikipedia.org/wiki/RSS' target='_blank' title='Wikipedia-artikel'><b>Wikipedia-artikel</b></a> innehåller omfattande information och länkar om RSS och de olika RSS-formaten.";
$pgv_lang["RSS_FORMAT"]				= "RSS format";
$pgv_lang["RSS_FORMAT_help"]		= "~#pgv_lang[RSS_FORMAT]#~<br /><br />Det format som ska användas som standardflödesformat för webbplatsen. De numeriska suffixen <u>anger inte</u> version: de identifierar format. Till exempel är RSS 2.0 inte nyare än RSS 1.0 utan ett annat format. Flödesläsare ska kunna läsa vilket format som helst.<br /><br />Detta <a href='https://sv.wikipedia.org/wiki/RSS' target='_blank' title='Wikipedia-artikel'><b>Wikipedia-artikel</b></a> innehåller omfattande information och länkar om RSS och de olika RSS-formaten.";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE"] = "Kontrollera om GEDCOM-filer är nedladdningsbara";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE_help"] = "~#pgv_lang[SECURITY_CHECK_GEDCOM_DOWNLOADABLE]#~<br /><br />Av säkerhetsskäl bör GEDCOM-filer inte vara på en plats där de kan laddas ner direkt, vilket kringgår sekretesskontroller. Om du klickar på denna länken kontrolleras om dina GEDCOM-filer kan laddas ner via nätverket.<br /><br />På vissa system har denna kontroll varit känd för att ta väldigt lång tid eller inte ens slutförd. Om så är fallet för dig, bör du försöka rikta din webbläsare direkt mot din GEDCOM för att se om den kan laddas ner.";
$pgv_lang["gedcom_download_secure"]	= "#GEDCOM# kan inte laddas ner.";

$pgv_lang["welcome_new_help"]		= "~#pgv_lang[welcome_new]#~<br /><br />Eftersom du ser denna sidan har du installerat PhpGedView på din server och är redo att börja konfigurera den efter dina behov.<br /><br />Denna hjälpsidan guidar dig genom konfigurationsprocessen. När du anger olika fält kommer detta fönstret att ge dig hjälpinformation om det fält du befinner dig i. Du kan stänga detta fönstret; om du vill öppna den igen klickar du på någon av <b>#pgv_lang[qm]#</b> frågetecken bredvid fältetiketten.";
$pgv_lang["return_editconfig"]		= "Du kan återgå till denna konfigurationen när som helst genom att peka din webbläsare till <i>editconfig.php</i> eller genom att klicka på länken för <b>Konfiguration</b> på sidan <b>PhpGedView Administration</b> .";
$pgv_lang["return_editconfig_gedcom"]	= "Du kan återgå till denna konfigurationen när som helst genom att klicka på länken <b>Redigera</b> i tabellen <b>#pgv_lang[current_gedcoms]#</b> i <b>#pgv_lang[gedcom_adm_head]#</b> sida eller genom att peka i din webbläsare till <i>editconfig_gedcom.php</i>.";
$pgv_lang["save_config"] 		= "Spara konfiguration";
$pgv_lang["download_gedconf"]		= "Ladda ner GEDCOM konfiguration.";
$pgv_lang["not_writable"]		= "Vi har upptäckt att din konfigurationsfil inte kan skrivas av PHP. Du kan använda knappen <b>#pgv_lang[download_file]#</b> för att spara dina inställningar i en fil som du kan ladda upp manuellt.";
$pgv_lang["upload_to_index"]		= "Ladda upp filen till din index mapp: ";
$pgv_lang["import_sql"]			= "SQL-filer har hittats i din indexmapp. Eftersom de kan ha sitt ursprung i #pgv_lang[um_header]# har du möjlighet att importera informationen till din databas. Vill du försöka importera dessa filer till din databas nu? All befintlig användarrelaterad information (användare, nyheter, favoriter, blocklayouter och meddelanden) i din databas kommer att gå förlorad.<br /><br />Om du väljer att fortsätta kommer PhpGedView att försöka importera data. Om detta inte lyckas kommer du att bli ombedd att skapa det första administratörskontot ändå.";

//-- edit privacy messages
$pgv_lang["edit_privacy"]			= "Ändra integritetsinställningar";
$pgv_lang["edit_privacy_title"]			= "Ändra GEDCOM integritetsinställningar";
$pgv_lang["save_changed_settings"]		= "Spara ändringar";
$pgv_lang["add_new_pp_setting"]			= "Lägg till ny inställning av total sekretess efter person-ID";
$pgv_lang["add_new_up_setting"]			= "Lägg till ny inställning av sekretess för användarnamn";
$pgv_lang["add_new_gf_setting"]			= "Lägg till ny inställning av global sekretess av fakta";
$pgv_lang["add_new_pf_setting"]			= "Lägg till ny inställning av fakta sekretess efter person-ID";
$pgv_lang["file_read_error"]			= "F E L !!! Det gick inte att läsa sekretessfilen!";
$pgv_lang["edit_exist_person_privacy_settings"]	= "Ändra existerande inställningar av total sekretess efter person-ID";
$pgv_lang["edit_exist_user_privacy_settings"]	= "Ändra existerande inställningar av sekretess för användarnamn";
$pgv_lang["edit_exist_global_facts_settings"]	= "Ändra existerande inställningar av global sekretess av fakta";
$pgv_lang["edit_exist_person_facts_settings"]	= "Ändra existerande inställningar av fakta sekretess efter person-ID";
$pgv_lang["general_privacy"]			= "Allmäna integritetsinställningar";
$pgv_lang["general_privacy_help"]		= "~#pgv_lang[general_privacy]#~<br /><br />Du kan ha olika sekretessinställningar för varje GEDCOM på din PhpGedView-webbplats. Kontrollera under sidrubriken om du redigerar rätt GEDCOM.<br /><br />Du kan åsidosätta dessa allmänna inställningar genom att använda de andra sekretessformulärerna på sidan #pgv_lang[edit_privacy_title]#.<br /><br />#pgv_lang[more_help_advice]#";
$pgv_lang["person_privacy"]				= "Inställning av total sekretess efter person-ID";
$pgv_lang["person_privacy_help"]		= "~#pgv_lang[person_privacy]#~<br /><br />Dessa inställningar gör det möjligt för administratörer att åsidosätta standardinställningarna för en viss person, familj, källa eller mediaobjekt.<br /><br />Antag att du till exempel har ett barn som dog i spädbarn. Normalt eftersom barnet är dött skulle dess detaljer visas för offentliga användare. Men du och alla andra i din familj är fortfarande privata. Du vill inte ta bort dödsposten för barnet men du vill dölja detaljerna och göra dem privata. Om detta barn hade ID: I100 bör du ange följande sekretessinställningar:<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I100<br />&nbsp;&nbsp;&nbsp;#pgv_lang[accessible_by]#:&nbsp;&nbsp;#pgv_lang[PRIV_USER]#<br /><br />Detta fungerar också på andra sätt. Om du vill offentliggöra detaljerna för någon (ID I101) som du vet är död men inte har ett dödsdatum för kan du lägga till följande:<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I101<br />&nbsp;&nbsp;&nbsp;#pgv_lang[accessible_by]#:&nbsp;&nbsp;#pgv_lang[PRIV_PUBLIC]#";
$pgv_lang["user_privacy"]				= "Inställning av sekretess för användarnamn";
$pgv_lang["user_privacy_help"]			= "~#pgv_lang[user_privacy]#~<br /><br />Dessa inställningar ger administratörer möjlighet att åsidosätta standardinställningar för personuppgifter i personer i GEDCOM baserat på användarnamn. Antag att du inte vill att användarnamnet <b>John</b> ska kunna se några detaljer för ID I100 i GEDCOM, du kan konfigurera:<br />&nbsp;&nbsp;&nbsp;Användarnamn:&nbsp;&nbsp;John<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I100<br />&nbsp;&nbsp;&nbsp;#pgv_lang[show_question]#:&nbsp;&nbsp;#pgv_lang[hide]#<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;och detaljer för den angivna personen döljs endast för användarnamnet «John».<br /><br />För att visa detaljerna i I101 (som vanligtvis skulle döljas eftersom I101 fortfarande lever) till Användarnamn «John» konfigurera:<br />&nbsp;&nbsp;&nbsp;Användarnamn:&nbsp;&nbsp;John<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I101<br />&nbsp;&nbsp;&nbsp;#pgv_lang[show_question]#:&nbsp;&nbsp;#pgv_lang[show]#";
$pgv_lang["global_facts"]				= "Inställning av global sekretess av fakta";
$pgv_lang["global_facts_help"]			= "~#pgv_lang[global_facts]#~<br /><br />Dessa inställningar definierar fakta på global nivå som ska döljas för alla personer i GEDCOM. Detta gäller endast nivå 1 faktaposter som BIRT eller DEAT som kommer att visas med sina egna rubriker på fliken #pgv_lang[personal_facts]# på sidan <i>#pgv_lang[personal_details]#</i>.<br /><ul><li>Elementet <b>#pgv_lang[name_of_fact]#</b> avgör vilket faktum som ska döljas.</li><li>Elementet <b>#pgv_lang[choice]#</b> anger själva fakta eller relaterade detaljer.</li><li>Elementet <b>#pgv_lang[accessible_by]#</b> avgör på vilken åtkomstnivå faktum visas.</li></ul><br />Denna funktionen är avsedd att dölja vissa fakta, identifierade av GEDCOM-taggar, för alla personer som är levande eller döda. Som standard är SSN taggen dold för offentliga användare. Detta för att förhindra att människor stjäl personnummer och begår identitetsstöld av döda personer. Detta är förmodligen mest relevant för USA.<br /><br />Om du vill dölja alla äktenskap från offentliga användare i din GEDCOM kan du konfigurera:<br />&nbsp;&nbsp;&nbsp;#pgv_lang[name_of_fact]#: (MARR) - Äktenskap<br />&nbsp;&nbsp;&nbsp;#pgv_lang[choice]#: #pgv_lang[fact_details]#<br />&nbsp;&nbsp;&nbsp;#pgv_lang[accessible_by]#: #pgv_lang[PRIV_USER]#<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Dessa inställningar skulle dölja äktenskap och relaterade detaljer för besökare som inte är inloggade.<br /><br />Till skillnad från alla andra inställningar, i <b>#pgv_lang[edit_exist_global_facts_settings]#</b> kan du dölja fakta även från administratörer. Oönskade fakta undertrycks fullständigt.";
$pgv_lang["person_facts"]				= "nställning av fakta sekretess efter person-ID";
$pgv_lang["person_facts_help"]			= "~#pgv_lang[person_facts]#~<br /><br />Dessa inställningar definierar fakta som är dolda för en viss person, familj eller källa och på vilken nivå de är dolda. Detta gäller endast faktaposter på nivå 1 som BIRT eller DEAT som kommer att visas med sina egna rubriker på den relevanta informationssidan för personen, familjen eller källan.<br /><br />Det första elementet är ID: för person, familj eller källa. Det andra elementet är faktum. Elementet <b>#pgv_lang[choice]#</b> anger själva fakta eller relaterade detaljer. Elementet <b>#pgv_lang[accessible_by]#</b> avgör på vilken åtkomstnivå faktum visas. Inte alla fakta som visas i listan är tillämpliga på alla typer av ID. Fakta om födelse och död är till exempel inte relevanta för källposter.<br /><br />Denna listan liknar <b>#pgv_lang[global_facts]#</b> listan förutom att du också anger GEDCOM ID av personen du vill dölja fakta för. Du kan till exempel dölja äktenskapsposten för en viss person.";
$pgv_lang["accessible_by"]				= "Visa för?";
$pgv_lang["hide"]						= "Göm";
$pgv_lang["show_question"]				= "Visa?";
$pgv_lang["user_name"]					= "Användarnamn";
$pgv_lang["name_of_fact"]				= "Namn på fakta";
$pgv_lang["choice"]						= "Val";
$pgv_lang["fact_show"]					= "Visa fakta";
$pgv_lang["fact_details"]				= "Visa faktadetaljer";
$pgv_lang["privacy_header"]				= "Ändra integritetsinställningar inuti";
$pgv_lang["unable_to_find_privacy_indi"]= "Kan inte hitta personen med id";
$pgv_lang["save_and_import"]			= "När du har sparat denna GEDCOM-konfiguration måste du importera GEDCOM genom att klicka på knappen <b>Importera GEDCOM</b> eller genom att gå till <b>Administration --> Hantera GEDCOMs --> Importera</b>";
$pgv_lang["help_info"]				= "Du kan få hjälp för varje objekt genom att klicka på den röda <b>#pgv_lang[qm]#</b> bredvid etiketten för varje cell.";
$pgv_lang["SHOW_LIVING_NAMES"]			= "Visa namn på levande människor";
$pgv_lang["SHOW_LIVING_NAMES_help"]		= "~#pgv_lang[SHOW_LIVING_NAMES]#~<br /><br />Ska namnen på levande människor visas för allmänheten?<br /><br />Normalt är denna inställning «#pgv_lang[PRIV_USER]#». Detta tjänar till att skydda privatliv för levande personer i din databas, eftersom du kan bestämma vem du ger allmän tillgång till dina släktforskningsdata.<br /><br />Inställningen «#pgv_lang[PRIV_NONE]#» förhindrar att namnen visas av levande människor till användare som inte har administratörsrättigheter.
";
$pgv_lang["SHOW_RESEARCH_ASSISTANT"]			= "Visa forskningsassistent";
$pgv_lang["SHOW_RESEARCH_ASSISTANT_help"]		= "~#pgv_lang[SHOW_RESEARCH_ASSISTANT]#~<br /><br />Vilken typ av användare kan visa forskningsassistentmodulen om den är installerad?";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]		= "Använd integritet enligt förhållandet";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]	= "~#pgv_lang[USE_RELATIONSHIP_PRIVACY]#~<br /><br /><b>#pgv_lang[no]#</b> betyder att autentiserade användare kan se detaljerna för alla levande människor. <b>#pgv_lang[yes]#</b> betyder att användare bara kan se privat information om levande människor de är relaterade till.<br /><br />Detta val anger standard för alla användare som har tillgång till denna släktforskningsdatabas. Administratören kan åsidosätta detta val för enskilda användare genom att redigera användarens kontouppgifter.";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]		= "Maximal längd för förhållandevägen";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]	= "~#pgv_lang[MAX_RELATION_PATH_LENGTH]#~<br /><br />Om val <i>#pgv_lang[USE_RELATIONSHIP_PRIVACY]#</i> är aktiverat kan inloggade användare bara se eller redigera personer inom detta antal relationssteg.<br /><br />Detta val ställer in standard för alla användare som har tillgång till denna släktforskningsdatabas. Administratören kan åsidosätta detta val för enskilda användare genom att redigera användarens kontouppgifter.";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]		= "Kontrollera förhållanden efter äktenskap";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]	= "~#pgv_lang[CHECK_MARRIAGE_RELATIONS]#~<br /><br />Kontrollera relationer som är relaterade till äktenskapet.";
$pgv_lang["SHOW_DEAD_PEOPLE"]			= "Visa döda människor";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]		= "~#pgv_lang[SHOW_DEAD_PEOPLE]#~<br /><br />Ställ in åtkomstnivån för sekretess för alla döda personer.";
$pgv_lang["select_privacyfile_button"]		= "Välj sekretessfil";
$pgv_lang["PRIVACY_BY_YEAR"]		= "Begränsa integriteten efter händelsens ålder";
$pgv_lang["PRIVACY_BY_YEAR_help"]	= "~#pgv_lang[PRIVACY_BY_YEAR]#~<br /><br />Inställningen <b>#pgv_lang[PRIVACY_BY_YEAR]#</b> döljer detaljerna för personer baserat på hur gamla de var vid specifika händelser oavsett om de är döda eller levande.<br /><br />Använd denna inställningen tillsammans med inställningen <b>#pgv_lang[MAX_ALIVE_AGE]#</b>. Om du till exempel har gjort åldersinställningen 100 och ställt in detta val till <b>#pgv_lang[yes]#</b>, skulle alla personer, levande eller döda, födda för mindre än 100 år sedan, vara privata. Människor som gifte sig för mindre än 85 år sedan och personer som dog för mindre än 75 år sedan skulle också markeras som privata. Observera att användning av detta val kommer att sakta ner din prestation något.";

//-- language edit utility
$pgv_lang["lang_edit_help"]			= "~#pgv_lang[translator_tools]#~<br /><br />Denna sida är avsedd att användas av översättare. Du kan översätta, jämföra och exportera språkfiler. Det finns också ett val för att hjälpa översättare att bestämma ursprunget för texten som matas ut av PhpGedView.<br /><br />Du kan använda följande val och verktyg:";
$pgv_lang["edit_langdiff"]		= "Redigera och konfigurera språkfiler";
$pgv_lang["bom_check"]		= "Kontroll av byteordermärke (BOM)";
$pgv_lang["bom_check_help"]		= "~#pgv_lang[bom_check]#~<br /><br />#pgv_lang[bom_check_desc]#";
$pgv_lang["bom_check_desc"]		= "Denna kontroll analyserar alla språkfiler för BOM (Byte Order Mark). Om den hittas kommer den att ta bort stycklistan från den berörda filen. Dessa specialkoder kan orsaka funktionsstörningar i vissa delar av PhpGedView.";
$pgv_lang["lang_debug"]			= "Hjälptext felsökning";
$pgv_lang["lang_debug_help"]	= "~#pgv_lang[lang_debug]#~<br /><br />#pgv_lang[lang_debug_desc]#";
$pgv_lang["lang_debug_desc"]	= "När du aktiverar detta val kommer namnen på språkvariablerna som används i hjälptexten att skrivas ut i popup-fönstret för hjälptext. Detta hjälper översättare att bestämma variabelnamnet när texten behöver justeras.<br /><br />Denna inställningen gäller endast under din nuvarande PhpGedView-session.";
$pgv_lang["lang_debug_use"]		= "Använd felsökning av hjälptext";
$pgv_lang["bom_not_found"]		= "Ingen BOM har hittats.";
$pgv_lang["bom_found"]			= "BOM har hittats i ";
$pgv_lang["edit_lang_utility"]		= "Språkfil Redigeringsverktyg";
$pgv_lang["edit_lang_utility_help"]	= "~#pgv_lang[edit_lang_utility]#~<br /><br />#pgv_lang[edit_lang_utility_desc]#";
$pgv_lang["edit_lang_utility_desc"]	= "Du kan använda detta verktyget för att redigera innehållet i en språkfil med hjälp av innehållet i den engelska.<br /><br />Du kommer att se innehållet i den ursprungliga engelska språkfilen och innehållet av samma filtyp (det finns nio av dessa) på ditt valda språk. Du klickar på meddelandetexten som visas under den engelska versionen. Detta öppnar ett nytt fönster där du kan ändra texten. Du kan spara ändringarna eller överge dem.";
$pgv_lang["edit_lang_utility_warning"]	= "FÖRSIKTIG!<br /><br />Om du använder knappen <b>#pgv_lang[close_window_without_refresh]#</b> kanske du inte ser dina ändringar på skärmen förrän du gör en manuell omladdning av sidan. Det är möjligt att din språkfil kan förstöras om du lägger till ett meddelande som ännu inte har dykt upp i språkfilen eller om du bara redigerar ett meddelande som du har redigerat direkt innan.<br /><br />Om du inte riktigt vet vad du gör, använd inte knappen <b>#pgv_lang[close_window_without_refresh]#</b>.";
$pgv_lang["language_to_edit"]		= "Språk att redigera";
$pgv_lang["language_to_edit_help"]		= "~#pgv_lang[language_to_edit]#~<br /><br />I denna listan väljer du det språk vars meddelanden du vill redigera.";
$pgv_lang["file_to_edit"]		= "Språk filtyp att redigera";
$pgv_lang["file_to_edit_help"]			= "~#pgv_lang[file_to_edit]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["lang_file_descriptions"]		= "PhpGedView har implementerat stöd för många olika språk. Detta har uppnåtts genom att hålla all text som är synlig för användare i filer helt åtskild från huvudprogrammet. Det finns en uppsättning med åtta filer för varje språk som stöds, och de olika texterna har delats in i en av dessa filer beroende på funktion. <b>Inte alla språkfiler behöver finnas.</b> När en given text ännu inte är tillgänglig i översatt form kommer PhpGedView alltid att använda den engelska versionen.<br /><br />Filerna i varje språkuppsättning är:<br /><ul><li><b><i>admin.xx.php</i></b>&nbsp;&nbsp;Denna filen innehåller termer och vanliga uttryck för användning under administrationen av PhpGedView och genealogiska databaser.</li><br /><li><b><i>configure_help.xx.php</i></b>&nbsp;&nbsp;Denna filen innehåller hjälptexter för användning under konfiguration av PhpGedView. Dessa texter är inte avsedda att ses av vanliga användare.</li><br /><li><b><i>countries.xx.php</i></b>&nbsp;&nbsp;Detta är en lista med landsnamn, hämtade från webbplatsen för statistikavdelningen, FNs ekonomiska och sociala avdelning. Detta är den relevanta <a href=\"http://unstats.un.org/unsd/methods/m49/m49alpha.htm\" target=\"_blank\"><b>länk</b></a> till den engelska listan. Listan finns på antingen engelska eller franska.</li><br /><li><b><i>editor.xx.php</i></b>&nbsp;&nbsp;Denna filen innehåller termer och vanliga uttryck för redigering av poster i genealogiska databaser.</li><br /><li><b><i>facts.xx.php</i></b>&nbsp;&nbsp;Denna filen innehåller textekvivalenterna för GEDCOM-faktakoder som finns i GEDCOM 5.5.1-standarden. Den innehåller också ytterligare faktakoder som inte finns i standarden men som används av olika släktforskningsprogram.<br /><br />En engelsk kopia av <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\"><b>GEDCOM 5.5.1 Standard</b></a> kan laddas ner i PDF (Portable Document Format == bärbart dokumentformat).</li><br /><li><b><i>faqlist.xx.php</i></b>&nbsp;&nbsp;Denna filen är en uppsättning <b>f</b>requently <b>a</b>sked <b>q</b>uestions (Vanliga frågor) som har samlats in av PhpGedView utvecklingsteamet. Varje FAQ har två poster i denna filen. En post är FAQ rubriken (vanligtvis frågan), och den andra är FAQ text (vanligtvis svaret). Ersättningar för <b><i>faqlist.xx.php</i></b> filerna, som uppdateras ofta, kan laddas ner från PhpGedView-webbplatsen.<br /><br />Administratören kan använda Vanliga frågor i denna filen för att skapa en FAQ-lista som är specifik för hans webbplats.</li><br /><li><b><i>help_text.xx.php</i></b>&nbsp;&nbsp;Denna filen innehåller hjälptexter för vanliga användare. Vissa hjälpämnen i denna filen tar upp administratörernas behov och är dolda för användare som inte har administratörsrättigheter.</li><br /><li><b><i>lang.xx.php</i></b>&nbsp;&nbsp;Många termer och vanliga uttryck finns i denna filen.</li></ul><br />PhpGedView stöder också en valfri nionde språkfil, <b><i>extra.xx.php</i></b>. Denna filen laddas alltid efter alla andra och ger ett sätt genom vilket en webbplatsadministratör kan åsidosätta eller ändra vilken standardtext som helst på det valda språket. Den kan också användas för att tillhandahålla en titel för släktforskningsdatabaserna som varierar beroende på det aktuella aktiva språket.<br /><br />Innehållet i denna extra fil är helt upp till webbplatsadministratören; denna filen kommer <b>aldrig</b> att distribueras med någon version av PhpGedView. Administratören bör aldrig göra ändringar i standardspråkfilerna. alla lokala ändringar bör koncentreras till denna valfria filen.";
$pgv_lang["check"]						= "Kontrollera";
$pgv_lang["lang_save"]					= "Spara";
$pgv_lang["contents"]					= "Innehåll";
$pgv_lang["listing"]					= "Visar";
$pgv_lang["no_content"]					= "Inget innehåll";
$pgv_lang["editlang"]					= "Redigera";
$pgv_lang["editlang_help"]				= "~#pgv_lang[editlang]#~<br /><br />Ändra på översättning.";
$pgv_lang["savelang"]					= "Spara";
$pgv_lang["savelang_help"]				= "~#pgv_lang[savelang]#~<br /><br />Spara redigerat meddelande till språkfil.";
$pgv_lang["original_message"]			= "Orginaltext";
$pgv_lang["message_to_edit"]			= "Meddelande att redigera";
$pgv_lang["changed_message"]			= "Ändrat innehåll";
$pgv_lang["message_empty_warning"]		= "-> Varning!!! Detta meddelande är tomt i #LANGUAGE_FILE#<-";
$pgv_lang["language_to_export"]			= "Språk att exportera";
$pgv_lang["language_to_export_help"]		= "~#pgv_lang[language_to_export]#~<br /><br />Från denna listan kan du välja språk och språkfiler vars text du vill exportera.<br /><br />Utdata är en HTML-fil som du kan skriva ut från din webbläsare.";
$pgv_lang["export_lang_utility"]		= "Exportverktyg för språkfiler";
$pgv_lang["export"]						= "Exportera";
$pgv_lang["export_lang_utility_help"]	= "~#pgv_lang[export_lang_utility]#~<br /><br />#pgv_lang[export_lang_utility_desc]#";
$pgv_lang["export_lang_utility_desc"]	= "Du kan skapa dokumentation för administratörer.<br /><br />Detta verktyg producerar en HTML-version av den valda språkfilen. Du kan använda din webbläsare för att titta på denna filen, som är formaterad för utskrift.";
$pgv_lang["export_ok"]			= "Språktexten exporterades";
$pgv_lang["compare_lang_utility"]	= "Verktyg för jämförelse av språkfil";
$pgv_lang["compare_lang_utility_help"]	= "~#pgv_lang[compare_lang_utility]#~<br /><br />#pgv_lang[compare_lang_utility_desc]#";
$pgv_lang["compare_lang_utility_desc"]	= "Detta verktyg jämför två uppsättningar språkfiler för att producera en lista över tillägg och subtraktioner mellan dem.<br /><br />De engelska filerna ska användas som referens som alla andra produceras från.";
$pgv_lang["new_language"]		= "Källspråk";
$pgv_lang["new_language_help"]			= "~#pgv_lang[new_language]#~<br /><br />Från denna listan kan du välja det språk vars meddelanden du vill jämföra med ett annat språk.<br /><br />Alla ändringar och tillägg till språkfiler görs först i <b>engelska</b> språkfilerna, så du skulle normalt välja engelska som ett av språken att jämföra.";
$pgv_lang["old_language"]		= "Sekundärt språk";
$pgv_lang["old_language_help"]			= "~#pgv_lang[old_language]#~<br /><br />Från denna listan kan du välja det språk som du vill jämföra med det valda språket i listan <b>#pgv_lang[new_language]#</b>.<br /><br />När du har gjort ditt val klickar du på knappen <b>Jämför</b> för att få en lista över alla tillägg och subtraktioner i alla filer på båda språken.<br /><br />För att uppdatera ditt minne:<br /><b>Tillägg</b> betyder: Det är <u>i</u> källfilen, men <u>inte</u> i den sekundära filen.<br /><br /><b>Subtraktion</b> betyder: Det är <u>inte</u> i källfilen, men det <u>är</u> i den sekundära filen. Detta kan hända när ett visst meddelande inte längre används och därför togs bort från de engelska filerna. Du kan säkert ta bort motsvarande meddelande från sekundära språkfiler.";
$pgv_lang["compare"]					= "Jämför";
$pgv_lang["comparing"]					= "Språkfiler som jämförs";
$pgv_lang["additions"]					= "Tillägg";
$pgv_lang["no_additions"]				= "Inga Tillägg";
$pgv_lang["subtractions"]				= "Borttagna";
$pgv_lang["no_subtractions"]			= "Inget borttaget";
$pgv_lang["config_lang_utility"]		= "Konfiguration av stödda språk";
$pgv_lang["config_lang_utility_help"]	= "~#pgv_lang[config_lang_utility]#~<br /><br />Denna sidan används för att kontrollera vilka språkval som är tillgängliga för dina användare. Du kan till exempel ställa in saker så att endast svenska och franska är tillgängliga. Detta kan vara användbart om du till exempel inte kan kommunicera med dina användare på ungerska.<br /><br />Du använder också denna sidan för att ändra vissa aspekter av PhpGedView som beror på det valda språket. Här är till exempel var du berättar för PhpGedView hur du formaterar datum- och tidsfält.<br /><br />Språken som är aktiva och nedtonade kan inte inaktiveras eftersom de används. Titta på den nedre tabellen för att se var språket används. När ett språk inte längre används av GEDCOM eller användare kommer du att kunna inaktivera det.<br /><br />Alla dina ändringar kommer att spelas in i en ny fil som heter <b>lang_settings.php</b> skapas i mappen <b>#INDEX_DIRECTORY#</b>. Alla dina ytterligare ändringar kommer att göras i denna nya filen och PhpGedView använder endast <u>den här</u> filen. Du kan återgå till de ursprungliga standardspråkinställningarna genom att radera denna filen.<br /><br />Om du måste rapportera problem med dina språkinställningar, berätta för PhpGedView supportteamet om den nya filen finns eller inte.";
$pgv_lang["active"]			= "Aktiverad";
$pgv_lang["active_help"]		= "~#pgv_lang[active]#~<br /><br />Tillåt användare att välja detta språk om val <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b> är aktiverat.";
$pgv_lang["edit_settings"]				= "Ändra inställningar";
$pgv_lang["lang_edit"]					= "Ändra";
$pgv_lang["lang_language"]				= "Språk";
$pgv_lang["export_filename"]			= "Namn på filen som innehåller den exporterade datan:";
$pgv_lang["lang_back"]					= "Tillbaka till huvudmenyn för editering och konfigurering av språkfiler";
$pgv_lang["lang_back_admin"]			= "Tillbaka till administratörsmenyn";
$pgv_lang["lang_back_manage_gedcoms"]	= "Tillbaka till GEDCOM-administrationsmenyn";
$pgv_lang["lang_name_arabic"]			= "Arabiska";
$pgv_lang["lang_name_catalan"]			= "Katalansk (Valencia)";
$pgv_lang["lang_name_chinese"]			= "Kinesiska (Traditionell)";
$pgv_lang["lang_name_chinese-cn"]		= "Kinesiska (Simpliferad)";
$pgv_lang["lang_name_croatian"]			= "Croatian";
$pgv_lang["lang_name_czech"]			= "Tjeckiska";
$pgv_lang["lang_name_danish"]			= "Danska";
$pgv_lang["lang_name_dutch"]			= "Holländska";
$pgv_lang["lang_name_english"]			= "Engelska";
$pgv_lang["lang_name_estonian"]			= "Estländska";
$pgv_lang["lang_name_finnish"]			= "Finska";
$pgv_lang["lang_name_french"]			= "Franska";
$pgv_lang["lang_name_german"]			= "Tyska";
$pgv_lang["lang_name_greek"]			= "Grekiska";
$pgv_lang["lang_name_hebrew"]			= "Hebreiska";
$pgv_lang["lang_name_hungarian"]		= "Ungerska";
$pgv_lang["lang_name_indonesian"]		= "Indonesiska";
$pgv_lang["lang_name_italian"]			= "Italienska";
$pgv_lang["lang_name_lithuanian"]		= "Litauiska";
$pgv_lang["lang_name_norwegian"]		= "Norska";
$pgv_lang["lang_name_polish"]			= "Polska";
$pgv_lang["lang_name_portuguese"]		= "Portugisiska";
$pgv_lang["lang_name_romanian"]			= "Rumänska";
$pgv_lang["lang_name_russian"]			= "Ryska";
$pgv_lang["lang_name_serbian-la"]		= "Serbiska (Latinska alfabetet)";
$pgv_lang["lang_name_slovak"]			= "Slovakiska";
$pgv_lang["lang_name_slovenian"]		= "Slovenska";
$pgv_lang["lang_name_spanish"]			= "Spanska";
$pgv_lang["lang_name_spanish-ar"]		= "Spanska (Latinamerika)";
$pgv_lang["lang_name_swedish"]			= "Svenska";
$pgv_lang["lang_name_turkish"]			= "Turkiska";
$pgv_lang["lang_name_vietnamese"]		= "Vietnamesiska";
$pgv_lang["lang_name_unknown"]			= "Inget av dessa språk";		// used ONLY in "Find Special Characters"
$pgv_lang["lang_new_language"]			= "Nytt språk";
$pgv_lang["original_lang_name"]			= "Ursprungligt namn på språket i #D_LANGNAME#";
$pgv_lang["original_lang_name_help"]	= "~Ursprungligt namn på språket~<br /><br />Hur heter detta språk på detta språket?<br /><br />Engelska kallar sig <b>English</b>; Tyska kallar sig <b>Deutsch</b>; Nederländska kallar sig <b>Nederlands</b>; Tjeckiska kallar sig <b>Ceština</b>, etc.";
$pgv_lang["lang_shortcut"]		= "Förkortning för språkfiler";
$pgv_lang["lang_shortcut_help"]		= "~#pgv_lang[lang_shortcut]#~<br /><br />Denna kod definierar en förkortning för språknamnet. Denna förkortning utgör en del av namnet på var och en av de språkfiler som används av PhpGedView. Till exempel är förkortningen som används för franska <b>fr</b>, och följaktligen är filnamnen för franska <i>admin.<b>fr</b>.php</i>, <i>configure_help.<b>fr</b>.php</i>, <i>countries.<b>fr</b>.php</i>, <i>editor.<b>fr</b>.php</i>, <i>facts.<b>fr</b>.php</i>, <i>help_text.<b>fr</b>.php</i>, och <i>lang.<b>fr</b>.php</i>";
$pgv_lang["lang_langcode"]		= "Språkdetekteringskoder";
$pgv_lang["lang_langcode_help"]		= "~#pgv_lang[lang_langcode]#~<br /><br />Dessa koder gör det möjligt för PhpGedView att upptäcka inställningen för önskat språk för den webbläsare som används. PhpGedView bestämmer vilket språk som webbläsaren faktiskt begär genom att matcha webbläsarens språkkod mot denna listan. Enskilda listposter måste separeras med semikolon.";
$pgv_lang["lang_filenames"]		= "Språkfiler";
$pgv_lang["lang_filenames_help"]		= "~#pgv_lang[lang_filenames]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["flagsfile"]			= "Flaggfil";
$pgv_lang["flagsfile_help"]		= "~#pgv_lang[flagsfile]#~<br /><br />Namnet på den nationella flaggbildsfilen för det valda språket.<br /><br />Bilder för många länder finns på <a href=\"http://w3f.com/gifs/index.html\"><b>The WWWeb Factory</b></a> webbplatsen.<br /><br />När du hittar en flaggbild du gillar högerklickar du på den och sparar bilden i en tillfällig mapp. Öppna sedan den sparade bilden med en lämplig bildredigerare (IrfanView rekommenderas för Windows-system), minska dess storlek 50x32 pixlar, vilket är den normala storleken som används i PhpGedView och spara den som en GIF-fil till <i><b>images/flags</b></i> mappen. Du kan använda vilket namn du vill.";
$pgv_lang["text_direction"]		= "Textriktning";
$pgv_lang["text_direction_help"]	= "~#pgv_lang[text_direction]#~<br /><br />Identifierar vilken riktning som används för att skriva text på det valda språket. De flesta språk skrivs från vänster till höger. Arabiska och hebreiska är exempel på språk som skrivs i motsatt riktning (höger till vänster).";
$pgv_lang["date_format"]				= "Datumformat";
$pgv_lang["date_format_help"]			= "~#pgv_lang[date_format]#~<br /><br />Detta fältet definierar det datumformat som ska användas av PhpGedView när datum visas från databasen. Du kan använda antingen formatet <b>Standard</b> eller <b>Avancerat</b>.<ul><li><b>Standard</b><br />Följande koder används för att representera olika delar av datumet. Observera att <b>D</b> och <b>M</b> har olika betydelser i formatet <b>Avancerat</b>.<p style=\"padding-left: 25px\"><b>D</b>&nbsp;&nbsp;dag i månaden utan ledande nollor; dvs 1 till 31<br /><b>M</b>&nbsp;&nbsp;månadens namn; dvs. januari, februari etc.<br /><b>Y</b>&nbsp;&nbsp;helår, till exempel 1999 eller 44f.kr.<br /><b>R</b>&nbsp;&nbsp;Kalenderomvandling. Se avsnittet <b>Kalenderomvandling</b> nedan för en beskrivning av denna koden.</p>Dessa koder kan kombineras i valfri ordning, tillsammans med mellanslag och skiljetecken. Antag till exempel att din GEDCOM innehåller datumet 20&nbsp;AUG&nbsp;1965.<p style=\"padding-left: 25px\">En <b>engelsk</b> användare kan ställa in formatet till <b>D&nbsp;M&nbsp;Y</b> att få <b>20&nbsp;August&nbsp;1965</b>.<br />En <b>amerikansk</b> användare kan ställa in formatet till <b>M&nbsp;D,&nbsp;Y</b> att få <b>August&nbsp;20,&nbsp;1965</b><br />En <b>tysk</b> användare kan ställa in formatet på <b>D.&nbsp;M&nbsp;Y</b> att få <b>20.&nbsp;August&nbsp;1965</b><br />En <b>ungersk</b> användare kan ställa in formatet till <b>Y.&nbsp;M&nbsp;D.</b> att få <b>1965.&nbsp;augusztus&nbsp;20.</b></p><br /></li><li><b>Avancerat</b><br />Mer komplexa formateringsalternativ är tillgängliga. Om ditt datumformat innehåller en annan bokstav än <b>D</b>, <b>M</b>, <b>Y</b> eller <b>R</b>, antas det för att använda formatet <b>Avancerat</b>.<br /><br />Följande koder används för att representera olika delar av datumet. Observera att <b>D</b> och <b>M</b> har olika betydelser i formatet <b>Standard</b>.<p style=\"padding-left: 25px\"><b>d</b>&nbsp;&nbsp;dag i månaden, med ledande nollor; dvs 01 till 31<br /><b>j</b>&nbsp;&nbsp;dag i månaden utan ledande nollor; dvs 1 till 31<br /><b>S</b>&nbsp;&nbsp;ordinärt suffix för dagnummer; till exempel på engelska bokstäverna <b>th</b> i <b>4th&nbsp;July</b>.<br /><b>l</b> (gemener «L»)&nbsp;&nbsp;veckodag; dvs. måndag, tisdag etc.<br /><b>D</b>&nbsp;&nbsp;förkortad veckodag; dvs. m, ti, o, to, f, l, s<br /><b>N</b>&nbsp;&nbsp;ISO dagnummer; dvs 0 till 6<br /><b>w</b>&nbsp;&nbsp;dagnummer; dvs 1 till 7<br /><b>z</b>&nbsp;&nbsp;dagen på året; dvs 1 till 365 eller 366<br /><b>F</b>&nbsp;&nbsp;månadens namn; dvs. januari, februari etc.<br /><b>M</b>&nbsp;&nbsp;förkortad månad, dvs. jan, feb, etc.<br /><b>m</b>&nbsp;&nbsp;månadsnummer, med ledande nollor; dvs 01 till 12<br /><b>n</b>&nbsp;&nbsp;månadsnummer, utan ledande nollor; dvs 1 till 12<br /><b>Y</b>&nbsp;&nbsp;helår, till exempel 1999 eller 44f.Kr.<br /><b>y</b>&nbsp;&nbsp;förkortat år. I vissa kalendrar kan år förkortas. För den judiska kalendern är detta året utan tusentals. För den gregorianska kalendern är det samma som hela året.<br /><b>R</b>&nbsp;&nbsp;Kalenderomvandling. Se avsnittet <b>Kalenderomvandling</b> nedan för en beskrivning av denna koden.<br /><b>@&nbsp;A&nbsp;O&nbsp;E</b>&nbsp;&nbsp;internt GEDCOM-format</p><p style=\"padding-left: 50px\"><b>@</b>&nbsp;&nbsp;kalenderkod, t.ex. @#DGREGORIAN@, @#DHEBREW@, etc.<br /><b>A</b>&nbsp;&nbsp;dag, dvs 01 till 31<br /><b>O</b>&nbsp;&nbsp;månad, på engelska, t.ex. JAN, FEB, MAR, etc.<br /><b>E</b>&nbsp;&nbsp;år, t.ex. 1776, 1867, 2007, etc.<br /><br />Använd för att se de okonverterade datumen <b>A&nbsp;O&nbsp;E</b> eller <b>@&nbsp;A&nbsp;O&nbsp;E</b></p><b>Några exempel</b> med datum 08&nbsp;SEP&nbsp;1965:<p style=\"padding-left: 25px\"><b>d&nbsp;M&nbsp;Y</b> = 08&nbsp;sep&nbsp;1965<br /><b>D&nbsp;j&nbsp;F&nbsp;Y</b> = o&nbsp;8&nbsp;september&nbsp;1965<br /><b>j&nbsp;M&nbsp;y</b> = 8&nbsp;sep&nbsp;65<br /><b>l&nbsp;-&nbsp;d&nbsp;-&nbsp;F&nbsp;-&nbsp;Y</b> = onsdag&nbsp;-&nbsp;08&nbsp;-&nbsp;september&nbsp;-&nbsp;1965<br /><b>y/m/d</b> = 1965/09/08</p><br /></li></ul>#pgv_lang[date_format_help2]#";
$pgv_lang["date_format_help2"]			= "<ul><li><b>Kalenderomvandling</b><br /><b>R</b>-koden är något ovanlig i sitt beteende. När denna koden visas i datumformatet visas det normala datumet en andra gång, men i ett annat kalendersystem. Elementen i detta alternativa kalenderdatum kommer att följa samma regler som i huvuddelen av formatspecifikationen, förutom att utdata från <b>R</b> formateringskoden finns inom parentes för att skilja den från det vanliga datumet. Exemplen under <b>Franska revolutionära</b> kalendern kommer att göra detta lite tydligare.<br /><br />Den alternativa kalendern som ska användas för <b>R</b>-koden bestäms enligt det aktuella sidans språk. När sidans språk är hebreiska kommer kalendern <b>judiska</b> att användas. När sidspråket är arabiska kommer kalendern <b>Hijri</b> att användas. För alla andra sidspråk används <b>Franska revolutionära</b> kalendern.<br /><br />Kodens åtgärd liknar valet av kalenderformat som du kan göra på GEDCOM-konfigurationssidan. Skillnaden mellan de två metoderna är att <b>R</b>-koden, som definieras på språkkonfigurationsnivån, fungerar endast på utvalda språk utan över alla GEDCOM på webbplatsen. Kalenderalternativet som ställts in på GEDCOM-konfigurationsnivå fungerar på alla språk men bara på de GEDCOM som det val har ställts in för.<br /><ul><li><b>Franska Revolutionära</b> kalendern&nbsp;&nbsp;&nbsp;Denna kalendern kallas också <b>Franska Republikanska</b> kalendern.<br /><br />Förutom en mycket kort period i maj 1871 var detta kalendersystem endast i bruk i Frankrike och endast mellan 22&nbsp;SEP&nbsp;1792 och 31&nbsp;DEC&nbsp;1805.  Följaktligen kommer det franska revolutionära kalenderformatet endast att tillämpas när datumet ligger inom det intervallet.<br /><br />Två exempel på datumformat, förutsatt att sidans språk är engelska, kommer att illustrera åtgärden för <b>R</b> kod:<br /><b>Y.m.d&nbsp;R</b> kunde producera <b>1805.04.26&nbsp;(XIII.08.06)</b> eller <b>1806.01.01</b>;&nbsp; <b>j&nbsp;F&nbsp;Y&nbsp;R</b> kunde producera <b>13&nbsp;October&nbsp;1797&nbsp;(22&nbsp;Vendémiaire&nbsp;VI)</b> eller <b>1&nbsp;January&nbsp;1806</b>.</li></ul><br /></li><li><b>Språkalternativ</b><br />De förkortade texterna för avancerade koder <b>D</b> och <b>M</b> ställs in i filen <i>languages/lang.xx.php</i> med kommandon som<br /><code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"Su\";<br />\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"April\";</code><br /><br />Dessa kan ändras med hjälp av en <i>languages/extra.xx.php</i>-fil som beskrivs i Wiki- och ReadMe-texten för språkjusteringar, till exempel:<br /><code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"Sun\";<br />\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"Apr\";</code></li><br /><li><b>Lokalisering</b><br />Särskilda formateringsregler finns för ett antal språk, särskilt nedläggning av månadsslut beroende på hur datumet formuleras. Dessa speciella regler implementeras i de olika filerna <i>includes/extras/functions.xx.php</i>.</li></ul>";
$pgv_lang["time_format"]				= "Tidsformat";
$pgv_lang["time_format_help"]			= "~#pgv_lang[time_format]#~<br /><br />Detta fält definierar det tidsformat som ska användas av PhpGedView.<br /><br />Symboler du kan använda är:<br /><b>a</b> - små bokstäver Ante meridiem och Post meridiem; dvs. <b>am</b> eller <b>pm</b><br /><b>A</b> - versaler Ante meridiem och Post meridiem; dvs. <b>AM</b> eller <b>PM</b><br /><b>B</b> - Swatch Internet-tid; dvs. <b>000</b> till <b>999</b><br /><b>c</b> - ISO 8601-datum; t.ex. <b>2004-02-12T15:19:21+00:00</b><br /><b>d</b> - månadsdag, två siffror, ledande noll; dvs. <b>01</b> till <b>31</b><br /><b>D</b> - dag, text, tre bokstäver; t.ex. <b>Mån</b><br /><b>F</b> - månad, text, lång; t.ex. <b>januari</b><br /><b>g</b> - timme, 12-timmarsformat, ingen ledande noll; dvs <b>1</b> till <b>12</b><br /><b>G</b> - timme, 24-timmarsformat, ingen ledande noll; dvs. <b>0</b> till <b>23</b><br /><b>h</b> - timme, 12-timmarsformat, ledande noll; dvs. <b>01</b> till <b>12</b><br /><b>H</b> - timme, 24-timmarsformat, ledande noll; dvs. <b>00</b> till <b>23</b><br /><b>i</b> - minuter, ledande noll; dvs. <b>00</b> till <b>59</b><br /><b>I</b> (versaler «i») - indikator för sommartid; <b>1</b> om sommartid, <b>0</b> annars.<br /><b>j</b> - dag i månaden, ingen ledande noll; dvs. <b>1</b> till <b>31</b><br /><b>l</b> (små «L») - veckodag, textuell, lång; t.ex. <b>Fredag</b><br /><b>L</b> - skottårsindikator; <b>1</b> om det är ett skottår, <b>0</b> annars.<br /><b>m</b> - månad, numerisk, ledande noll; dvs. <b>01</b> till <b>12</b><br /><b>M</b> - månad, text, 3 bokstäver; t.ex. <b>jan</b><br /><b>n</b> - månad, numerisk, ingen ledande noll; dvs <b>1</b> till <b>12</b><br /><b>O</b> (versaler «o») - skillnad mellan lokal och Greenwich-tid (GMT) i timmar; t.ex. <b>+0200</b><br /><b>r</b> - RFC 2822 formaterat datum; t.ex. <b>tor,&nbsp;21&nbsp;dec&nbsp;2000&nbsp;16:01:07&nbsp;+0200</b><br /><b>s</b> - sekunder, ledande noll; dvs. <b> 00 </b> till <b> 59 </b><br /><b>S</b> - suffixets dag i månaden, endast engelska, två tecken; dvs. <b>st</b>, <b>nd</b>, <b>rd</b> eller <b>th</b>. Fungerar bra med <b>j</b><br /><b>t</b> - antal dagar under den givna månaden; dvs. <b>28</b> till <b>31</b><br /><b>T</b> - tidszoninställning för denna maskin; t.ex. <b>CEST</b>, <b>EST</b>, <b>MDT</b><br /><b>U</b> - sekunder sedan starten på Unix Epoch (1&nbsp;januari&nbsp;1970&nbsp;00:00:00 GMT)<br /><b>w</b> - veckodag, numerisk; dvs. <b>0</b> (söndag) till <b>6</b> (lördag)<br /><b>W</b> - ISO 8601 veckans antal år, veckor som börjar på måndag; t.ex. <b>42</b> (den 42: e veckan på året)<br /><b>Y</b> - år, 4 siffror; t.ex. <b>1999</b><br /><b>y</b> - år, två siffror; t.ex. <b>99</b><br /><b>z</b> - dag på året, numeriskt, inga ledande nollor; dvs. <b>0</b> (1 jan) till <b>364</b> (31 dec när det inte är ett skottår) eller <b>365</b> (31 dec om skottår)<br /><b>Z</b> - tidszonsförskjutning i sekunder. Förskjutningen för tidszoner väster om Greenwich är alltid negativ, och för de öster om Greenwich är förskjutningen alltid positiv. dvs. <b>-43200</b> till <b>43200</b><br /><br />Du kan ändra ordningen på dessa symboler och du kan lägga till avgränsare i formatet.<br />Till exempel, på tyska innehåller detta fält normalt <b>H:i:s</b> för att producera <b>09:01:25</b>.<br />Engelska definierar vanligtvis tidsformatet som <b>g:i:sa</b> för att producera <b>9:01:25am</b>.<br /><br />I 24-timmarssystemet är midnatt 00:00. I 12-timmarssystemet midnatt är 12:00am och middag är 12:00pm.";
$pgv_lang["week_start"]			= "Veckans startdag";
$pgv_lang["week_start_help"]		= "~#pgv_lang[week_start]#~<br /><br />Veckodagen som börjar en ny vecka på detta språk. De flesta språk börjar veckan på söndag, men vissa börjar på måndag eller andra dagar.";
$pgv_lang["name_reverse"]		= "Efternamn först";
$pgv_lang["name_reverse_help"]		= "~#pgv_lang[name_reverse]#~<br /><br />På vissa språk ska efternamnet visas först i stället för standard för att visa det sist. Om du aktiverar detta val visas efternamnet först. Ungerska, kinesiska och japanska är exempel där efternamnet (efternamnet) vanligtvis ges först.";
$pgv_lang["ltr"]			= "Vänster till höger";
$pgv_lang["rtl"]			= "Höger till vänster";
$pgv_lang["file_does_not_exist"]	= "FEL! Filen finns inte...";
$pgv_lang["optional_file_not_exist"]	= "Denna valfria fil finns inte.";
$pgv_lang["alphabet_upper"]		= "Alfabetet versaler";
$pgv_lang["alphabet_upper_help"]	= "~#pgv_lang[alphabet_upper]#~<br /><br />Stor bokstäver på detta språk. Detta alfabet används när du sorterar namnlistor.";
$pgv_lang["alphabet_lower"]		= "Alfabetet gemener";
$pgv_lang["alphabet_lower_help"]	= "~#pgv_lang[alphabet_lower]#~<br /><br />Små bokstäver på detta språk. Detta alfabet används när du sorterar namnlistor.";
$pgv_lang["multi_letter_alphabet"]		= "Alfabet med flera bokstäver";
$pgv_lang["multi_letter_alphabet_help"]	= "~#pgv_lang[multi_letter_alphabet]#~<br /><br />Flera bokstavskombinationer som ska behandlas som en enda distinkt bokstav när man sorterar listor med namn och titlar på detta språk.<br /><br />Vissa språk, till exempel ungerska och slovakiska, anser att vissa bokstavskombinationer är olika bokstäver i sig. Ordningen i vilken du anger dessa bokstavskombinationer avgör i vilken ordning de sätts in i det normala alfabetet under sorteringen. Detta är viktigt när flera kombinationer med flera bokstäver har samma första bokstav. Förutom <b> ch </b> infogas dessa bokstavskombinationer i det normala alfabetet enligt deras första bokstav. <b>ch</b> infogas alltid efter <b>h</b>.";
$pgv_lang["multi_letter_equiv"]		= "Flera bokstavsekvivalenter";
$pgv_lang["multi_letter_equiv_help"]	= "~#pgv_lang[multi_letter_equiv]#~<br /><br />På vissa språk behandlas ofta flera bokstäver som likvärdiga med en enda bokstav när man genererar namnlistor.<br /><br />Till exempel, på nederländska listas namn som börjar med <b>IJ</b> tillsammans med namn som börjar på <b>Y</b>. På norska, namn som börjar med <b>Aa</b> listas med <b>&Aring;</b>. På vissa språk finns det bokstäver som kan skrivas som ett tecken eller två. Till exempel på slovakiska kan de två tecknen D och \xC5\xBE skrivas som det enskilda tecknet \xC7\x85. Genom att specificera ekvivalenter här kan du tillåta att namn som börjar med dessa bokstäver grupperas på personlistans sidor.<br /><br />Du bör ange en kommaseparerad lista med motsvarigheter. För att stödja databaser som inte känner igen UTF-8-kodning bör du ange både versaler och gemener. Detta exemplet visar formatet som ska användas.<br /><br />Aa=&Aring;,aa=&aring;";
$pgv_lang["dictionary_sort"]		= "Använd ordbokens regler när du sorterar";
$pgv_lang["dictionary_sort_help"]	= "~#pgv_lang[dictionary_sort]#~<br /><br />Detta val styr hur tecken med diakritiska tecken hanteras vid sortering av namn och titlar.<br /><br />När de är inställda på <b>#pgv_lang[yes]#</b> behandlas alla tecken med diakritiska tecken som om de inte hade några märken. Diakritiska tecken betraktas endast när de två orden som betraktas annars är identiska. När den är inställd på <b>#pgv_lang[no]#</b> är alla bokstäver olika, oavsett om det finns eller inte finns några diakritiska tecken.";
$pgv_lang["collation"]		= "Datasortering sekvens";
$pgv_lang["collation_help"]	= "~#pgv_lang[collation]#~<br /><br />Om du använder databasens inbyggda sorteringsregler anger detta val vilken sorteringssekvens som ska användas för detta språk. Du bör se till att din databas stöder alla sorteringssekvenser du tänker använda.<br /><br />Användningen av databassortering styrs i inställningarna för webbplatsens konfiguration.";
$pgv_lang["lang_config_write_error"]	= "Fel vid skrivning av språkinställningar i filen <i>language_settings.php</i>. Kontrollera behörigheterna och försök igen.";
$pgv_lang["lang_set_file_read_error"]	= "F E L !!! Det gick inte att läsa <b>lang_settings.php</b>!";
$pgv_lang["add_new_language_help"]	= "~#pgv_lang[add_new_language]#~<br /><br />#pgv_lang[add_new_language_desc]#";
$pgv_lang["add_new_language_desc"]	= "Denna rutin låter dig lägga till ett nytt, tidigare otillgängligt och helt språk som inte stöds till PhpGedView.<br /><br />Du kan ställa in standardinställningarna för det nya språket. Dessa inkluderar språkidentifieringskod, språkriktning, veckans början för detta språk, tidsinställningar, alfabet osv.<br /><br />Du får mer hjälp med inställningarna för språk som stöds av PhpGedView efter att du har valt språk och klicka på knappen <b>#pgv_lang[add_new_lang_button]#</b>.<br /><br />Mer hjälp finns på konfigurationssidan för språket.";
$pgv_lang["add_new_lang_button"]	= "Lägg till nytt språk";
$pgv_lang["hide_translated"]		= "Göm översatt";
$pgv_lang["hide_translated_help"]		= "~#pgv_lang[hide_translated]#~<br /><br />Om den är inställd på <b>#pgv_lang[yes]#</b> ser du bara de meddelanden i den valda språkfilen som inte har översatts. Det betyder att det nya meddelandet <u> inte </u> visas i målspråksfilen.<br /><br />Vissa språkfiler innehåller engelsk text för olika icke översatta meddelanden. Denna rutin kan inte identifiera dessa oöversatta objekt, eftersom de redan finns i målfilen. Antagandet är: «Om meddelandet finns i målfilen måste det ha översatts.»";
$pgv_lang["lang_file_write_error"]	= "F E L !!! Det gick inte att skriva ändringar i den valda språkfilen. Kontrollera skrivbehörigheter i <b>#lang_filename#</b>";
$pgv_lang["no_open"]	= "F E L !!! Det går inte att öppna filen <b>#lang_filename#</b>";
$pgv_lang["users_langs"]			= "Användarnas språk";
$pgv_lang["configured_languages"]	= "Använda språk";

//-- User Migration Tool messages
$pgv_lang["um_header"] = "Användarinformation Migrationsverktyg";
$pgv_lang["um_proceed"] = "Välj ett val eller klicka på länken nedan för att återgå till menyn Administration";
$pgv_lang["um_creating"] = "Skapa";
$pgv_lang["um_sql_index"] = "Detta verktyget skapar <i>authenticate.php</i> och flera <i>.dat</i> filer i din indexmapp.<br /><br />Efter framgångsrik skapelse kan du växla till indexläge med alla nuvarande användare och deras meddelanden, favoriter, nyheter och MyGedview-layout tillgängliga.<br /><br />Obs! När du har bytt till indexläge måste du importera dina GEDCOM-filer igen.";
$pgv_lang["um_file_create_fail1"] = "Det gick inte att skapa en ny fil, det finns redan en fil med det namnet:";
$pgv_lang["um_file_create_fail2"] = "Kan inte skapa";
$pgv_lang["um_file_create_fail3"] = "Kontrollera åtkomsträttigheter i denna mappen.";
$pgv_lang["um_file_create_succ1"] = "Skapandet av ny fil lyckades:";
$pgv_lang["um_file_not_created"] = "Filen skapas inte.";
$pgv_lang["um_nomsg"] = "Inga meddelanden verkar finnas i systemet.";
$pgv_lang["um_nofav"] = "Inga favoriter verkar finnas i systemet.";
$pgv_lang["um_nonews"] = "Inga nyheter verkar finnas i systemet.";
$pgv_lang["um_noblocks"] = "Inga block verkar finnas i systemet.";
$pgv_lang["um_index_sql"] = "Detta verktyg importerar <i>authenticate.php</i> och andra <i>.dat</i> filer från din indexmapp till din databas.";
$pgv_lang["um_noaction"] = "Ingen åtgärd krävs för att migrera användarinformation till SQL-läge.<br /><br />När du har bytt till SQL-läge måste du starta om <b>#pgv_lang[um_header]#</b> för att importera all data till SQL-databasen. PhpGedView använder befintliga filer från indexläge.<br /><br /><b>Ta bort <u>inte</u> <i>authenticate.php</i> och <i>.dat</i> filer från din index mapp när du byter.</b>";
$pgv_lang["um_import"] = "Importera";
$pgv_lang["um_export"] = "Exportera";
$pgv_lang["um_explain"] = "Detta verktyg exporterar antingen användardata från SQL till indexläge eller importerar användardata från indexfiler till SQL-tabeller.<br /><br />Användardata, favoriter, blockdefinitioner, meddelanden och nyheter kommer att vara tillgängliga igen efter migreringen.<br /><br /><b>VARNING</b><br />Du kan inte använda detta verktyg för att migrera användardata mellan olika versioner av PhpGedView. Se till att data kommer från eller importeras till samma version av PhpGedView.<br /><br /><b>IMPORT</b><br />Om du väljer att importera användardatafilerna från indexläge, all användardata som finns i databastabellerna kommer att <u>skrivas över</u>. Detta verktyg <u>slår inte</u> samman informationen. När du har kört importen finns det inget sätt att hämta den gamla informationen med PhpGedView.<br /><br /><b>EXPORT</b><br />Om du exporterar användarinformationen från din SQL-databas till Indexlägesfiler, detta verktyget skapar <i>authenticate.php</i> och flera <i>.dat</i> filer i din index mapp. Om identiskt namngivna filer redan finns kommer du att uppmanas om de måste skrivas över. När du har bytt till indexläge kommer all information att finnas tillgänglig direkt.<br /><br /><b>Obs:</b> När du har bytt till indexläge måste du importera dina GEDCOM-filer igen.";
$pgv_lang["um_tool_help"] = "~#pgv_lang[um_header]#~<br /><br />#pgv_lang[um_explain]#";
$pgv_lang["um_sql_index_help"] = "~Migrera användare från SQL till index läge~<br /><br />#pgv_lang[um_sql_index]#";
$pgv_lang["um_index_sql_help"] = "~Migrera användare från index till SQL läge~<br /><br />#pgv_lang[um_index_sql]#";
$pgv_lang["um_imp_users"] = "Importerar användare";
$pgv_lang["um_imp_blocks"] = "Importerar block";
$pgv_lang["um_imp_favorites"] = "Importerar favoriter";
$pgv_lang["um_imp_messages"] = "Importerar meddelanden";
$pgv_lang["um_imp_news"] = "Importerar nyheter";
$pgv_lang["um_nousers"] = "Filen <i> authenticate.php </i> hittades inte i din indexmapp. Migrering avbryts.";
$pgv_lang["um_imp_succ"] = "Importen lyckades";
$pgv_lang["um_imp_fail"] = "Import misslyckades";
$pgv_lang["um_backup"] = "Säkerhetskopiering";
$pgv_lang["um_zip_succ"] = "ZIP filen har skapats.";
$pgv_lang["um_zip_dl"] = "Ladda ner ZIP backup fil ";
$pgv_lang["um_bu_explain"] = "Detta verktyg kan säkerhetskopiera flera typer av data i PhpGedView.<br /><br />De data du väljer att säkerhetskopiera samlas i en ZIP fil som du kan ladda ner genom att klicka på länken längst ner på efter att säkerhetskopieringen har gjorts.<br /><br />ZIP filen kommer att finnas kvar i din indexmapp tills du tar bort den manuellt.";
$pgv_lang["um_bu_help"] = "~#pgv_lang[um_backup]#~<br /><br />#pgv_lang[um_bu_explain]#";
$pgv_lang["um_bu_config"] = "PhpGedView konfigurationsfil";
$pgv_lang["um_bu_gedcoms"] = "GEDCOM filer";
$pgv_lang["um_bu_gedsets"] = "GEDCOM inställningar, konfigurations och sekretess filer";
$pgv_lang["um_bu_logs"] = "Filer med sökloggar och PhpGedView-loggar";
$pgv_lang["um_bu_usinfo"] = "Användardefinitioner, Blockera inställningar, Favoriter, Meddelanden, Nyheter";
$pgv_lang["um_bu_media"]	= "Mediefiler";
$pgv_lang["um_mk_bu"] = "Gör backup";
$pgv_lang["um_nofiles"] = "Inga filer hittades för säkerhetskopiering.";
$pgv_lang["um_files_exist"] = "En eller flera filer finns redan. Vill du skriva över dem?";
$pgv_lang["um_results"]		= "Resultat";
$pgv_lang["preview_faq_item"] = "Förhandsgranska alla FAQ (vanliga frågor)";
$pgv_lang["preview_faq_item_help"] = "~#pgv_lang[preview_faq_item]#~<br /><br />Detta val låter en administratör visa FAQ sidan utan alla redigeringsalternativ och länkar.<br /><br />Förutom en enda <b>Redigera</b> länk ovanför den första FAQ kommer utseendet på FAQ sidan att visas vara identisk med vad en vanlig användare skulle se. Denna speciella länken <b>Redigera</b> återställer fullständig redigeringsfunktionalitet till FAQ sidan.";
$pgv_lang["restore_faq_edits"] = "Återställ redigeringsfunktion för vanliga frågor";
$pgv_lang["restore_faq_edits_help"] = "~#pgv_lang[restore_faq_edits]#~<br /><br />Detta val återställer FAQ-sidan till vad en administratör normalt ser, så att enskilda FAQs kan redigeras.";
$pgv_lang["add_faq_item"] = "Lägg till FAQ (vanliga frågor)";
$pgv_lang["add_faq_item_help"] = "~#pgv_lang[add_faq_item]#~<br /><br />Med detta val kan du lägga till en FAQ på FAQ sidan.";
$pgv_lang["edit_faq_item"] = "Redigera FAQ";
$pgv_lang["edit_faq_item_help"] = "~#pgv_lang[edit_faq_item]#~<br /><br />Med detta val kan du redigera en FAQ på FAQ sidan.";
$pgv_lang["delete_faq_item"] = "Ta bort FAQ";
$pgv_lang["delete_faq_item_help"] = "~#pgv_lang[delete_faq_item]#~<br /><br />Med detta val kan du ta bort en FAQ från FAQ sidan";
$pgv_lang["moveup_faq_item"] = "Flytta FAQ upp";
$pgv_lang["moveup_faq_item_help"] = "~#pgv_lang[moveup_faq_item]#~<br /><br />Med detta val kan du flytta en FAQ uppåt på FAQ-sidan.<br /><br />Varje gång du använder detta val minskas positionsnumret för denna FAQ med en. Du kan uppnå samma effekt genom att redigera frågorna i fråga och ändra Position-fältet. När mer än en FAQ har samma positionsnummer kommer bara en av dessa att visas.";
$pgv_lang["movedown_faq_item"] = "Flytta FAQ ner";
$pgv_lang["movedown_faq_item_help"] = "~#pgv_lang[movedown_faq_item]#~<br /><br />Detta val låter dig flytta en FAQ nedåt på FAQ sidan.<br /><br />Varje gång du använder detta val ökas positionsnumret för denna FAQ med en. Du kan uppnå samma effekt genom att redigera frågorna i fråga och ändra Position-fältet. När mer än en FAQ har samma positionsnummer kommer bara en av dessa att visas.";
$pgv_lang["add_faq_header_help"] = "~#pgv_lang[add_faq_header]#~<br /><br />Detta är titeln eller ämnet för FAQ.<br /><br />Det du anger här kan formateras. HTML-taggar som &lt;b&gt; och &lt;br /&gt; är tillåtna, liksom HTML-enheter som &amp;amp; och &amp;nbsp;. Andra HTML-taggar än &lt;br /&gt; är förmodligen inte särskilt användbara i FAQ-titeln och bör undvikas.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["add_faq_body_help"] = "~#pgv_lang[add_faq_body]#~<br /><br />Texten i FAQ anges här.<br /><br />Texten kan formateras. HTML-taggar som &lt;b&gt; och &lt;br /&gt; är tillåtna, liksom HTML-enheter som &amp;amp; och &amp;nbsp;.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["add_faq_HTML"] = "HTML enheter är ett mycket enkelt sätt att lägga till specialtecken i dina vanliga titlar och text. Du kan använda symboliska namn, decimaltal eller hexadecimaltal. En fullständig lista över HTML enheter, deras kodning och deras representation av din webbläsare finns här: <a href=\"http://htmlhelp.com/reference/html40/entities/\" target=\"_blank\">HTML enhetslistor</a><br /><br />Ibland kan du behöva visa en Tilde-karaktär&nbsp;&nbsp;<b>&#x7E;</b>&nbsp;&nbsp;eller ett nummertecken&nbsp;&nbsp;<b>&#x23;</b>&nbsp;&nbsp;i dina webbadresser eller text. Dessa tecken har en speciell betydelse för PhpGedView-hjälpsystemet och kan endast anges i deras hexadecimala eller decimala form. På samma sätt måste&nbsp;&nbsp;<b>&lt;</b>&nbsp;&nbsp;och&nbsp;&nbsp;<b>&gt;</b>&nbsp;&nbsp;tecken som vanligtvis omsluter HTML taggar anges i deras hexadecimal eller decimal formulär om de ska behandlas som normal text istället för att signalera en HTML tagg.<ul><li><b>&amp;&#x23;35;</b>&nbsp;&nbsp;eller&nbsp;&nbsp;<b>&amp;&#x23;x23;</b>&nbsp;&nbsp;kommer att resultera i&nbsp;&nbsp;<b>&#x23;</b></li><li><b>&amp;&#x23;60;</b>&nbsp;&nbsp;eller&nbsp;&nbsp;<b>&amp;&#x23;x3C;</b>&nbsp;&nbsp;kommer att resultera i&nbsp;&nbsp;<b>&#x3C;</b></li><li><b>&amp;&#x23;62;</b>&nbsp;&nbsp;eller&nbsp;&nbsp;<b>&amp;&#x23;x3E;</b>&nbsp;&nbsp;kommer att resultera i&nbsp;&nbsp;<b>&#x3E;</b></li><li><b>&amp;&#x23;126;</b>&nbsp;&nbsp;eller&nbsp;&nbsp;<b>&amp;&#x23;x7E;</b>&nbsp;&nbsp;kommer att resultera i&nbsp;&nbsp;<b>&#x7E;</b></li></ul>Det finns en&nbsp;&nbsp;<b>&amp;tilde;</b>&nbsp;&nbsp;HTML enhet, men denna symbolen tolkas inte som en Tilde när den kodas i webbadresser.";
$pgv_lang["add_faq_pgvLangRefs"] = "Du kan infoga referenser till poster i språkfilerna eller till värden för globala variabler. Exempel:<ul><li><b>&#x23;pgv_lang[add_to_cart]&#x23;</b>&nbsp;&nbsp;&nbsp;är en hänvisning till språkvariabeln \$pgv_lang[\"add_to_cart\"], och om det skulle visas i detta fältet, skulle visa som <b>#pgv_lang[add_to_cart]#</b> när vanliga frågor-listan visas på det aktuella språket.</li><li><b>&#x23;factarray[AFN]&#x23;</b>&nbsp;&nbsp;&nbsp;är en hänvisning till faktornamnet \$factarray[\"AFN\"], och om det skulle visas i detta fältet, skulle visa som <b>#factarray[AFN]#</b> när vanliga frågor-listan visas på det aktuella språket.</li><li><b>&#x23;PGV_VERSION&#x23;&nbsp;&#x23;PGV_VERSION_RELEASE&#x23;</b>&nbsp;&nbsp;&nbsp;är en hänvisning till konstanten PGV_VERSION, ett mellanslag och en hänvisning till konstanten PGV_VERSION_RELEASE, och om de skulle visas i detta fältet, skulle de visas som <b>#PGV_VERSION#&nbsp;#PGV_VERSION_RELEASE#</b> när vanliga frågor-listan visas på det aktuella språket.</li><li><b>&#x23;GLOBALS[GEDCOM]&#x23;</b>&nbsp;&nbsp;&nbsp;är en referens till den globala variabeln \$GEDCOM, som är namnet på den aktuella GEDCOM-filen. Om det skulle visas i detta fältet skulle det visas som <b>#GLOBALS[GEDCOM]#</b>.</li><li><b>&#x23;GLOBALS[GEDCOM_TITLE]&#x23;</b>&nbsp;&nbsp;&nbsp;är en referens till den globala variabeln \$GEDCOM_TITLE, som är titeln på den aktuella GEDCOM-filen. Om det skulle visas i detta fältet skulle det visas som <b>#GLOBALS[GEDCOM_TITLE]#</b>.</li></ul><br />Denna funktionen är användbar när du vill skapa vanliga frågor-listor som skiljer sig åt för varje språk som din webbplats stöder. Du bör placera dina anpassade vanliga frågor-titlar och poster i <i>languages/extra.xx.php</i> filerna (<i>xx</i> är koden för varje språk) med följande format:<br /><code>\$pgv_lang[\"faq_title1\"]&nbsp;=&nbsp;\"Detta är ett exempel på vanliga frågor\";<br />\$pgv_lang[\"faq_body1\"]&nbsp;=&nbsp;\"Detta är ett exempel på en vanliga frågor-text.\";</code>;";
$pgv_lang["add_faq_order_help"] = "~#pgv_lang[add_faq_order]#~<br /><br />Detta fältet styr i vilken ordning FAQs visas.<br /><br />Du behöver inte ange siffrorna i följd. Om du lämnar hål i numreringsschemat kan du infoga andra vanliga frågor senare. Om du till exempel använder siffrorna 1, 6, 11, 16 kan du senare infoga vanliga frågor med de saknade sekvensnumren. Negativa siffror och noll är tillåtna och kan användas för att infoga vanliga frågor framför den första.<br /><br />När mer än en FAQ har samma positionsnummer kommer bara en av dessa att visas.";
$pgv_lang["add_faq_visibility_help"] = "~#pgv_lang[add_faq_visibility]#~<br /><br />Du kan avgöra om denna FAQ kommer att vara synlig oavsett GEDCOM, eller om den bara kommer att vara synlig för den nuvarande GEDCOM.<br /><ul><li><b>#pgv_lang[all]#</b>&nbsp;&nbsp;&nbsp;FAQ och svar kommer att visas i alla FAQ-listor, oavsett GEDCOM.</li><li><b>#GLOBALS[GEDCOM]#</b>&nbsp;&nbsp;&nbsp;FAQ och svar kommer endast att visas i FAQ listan för den för närvarande aktiva GEDCOM.</li></ul>";
$pgv_lang["index_gedcom_news_adm_help"]		= "GEDCOM News-texten tillåter användning av <b> HTML-taggar </b> och <b> HTML-enheter </b>. HTML ska inte användas i nyhetstitlar.<br /><br />Se till att alltid använda både start- och slutkoder. Det kan hjälpa att ha en förståelse för HTML som är lämplig för en webbplatsadministratör. Detta program använder också <b> Cascading Style Sheets (CSS) </b>. En olika CSS implementeras för varje tema. Du kan använda klasser från dessa formatmallar för att kontrollera utseendet på dina meddelanden.<br /><br />Om du behöver mer hjälp med detta har webbplatsen PhpGedView några exempel på hur du använder dessa taggar i ditt GEDCOM News-block.<br /><br />Som med FAQ-listan tillåter GEDCOM News-titlar och News-text inbäddade referenser till \$pgv_lang, \$factarray och \$GLOBALS variabler för att ge fullständig flexibilitet vid skapandet av nyhetsartiklar känslig för det aktuella aktiva språket.<br /><br />Följande beskrivning, hämtad från hjälptexten för FAQ-listan, är lika tillämplig på GEDCOM News-artiklar.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["time_limit_help"]			= "~#pgv_lang[time_limit]#~<br /><br />Den maximala tiden importen får köras för bearbetning av GEDCOM-filen.";

// editconfig_gedcom.php Option Filter
$pgv_lang["ged_filter_results"] = "Resultat hittade";
$pgv_lang["ged_filter_reset"] = "Rensa sökning";
$pgv_lang["ged_filter_description"] = "Text att söka";
$pgv_lang["ged_filter_description_help"] = "~#pgv_lang[ged_filter_description]#~<br /><br />Med detta val kan du söka i texten som är kopplad till konfigurationsalternativen.<br /><br />När du skriver bokstäver hittar sökningen alla konfigurationsalternativ som innehåller bokstavssekvensen. Sökningen blir mer exakt när du skriver fler bokstäver.";

?>
