<?php
/**
 * Chinese (Traditional) texts
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2019 to 2021  PGV Development Team.  All rights reserved.
 *
 * This program is free software;you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation;either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program;if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * @package PhpGedView
 * @version $Id: configure_help.zh.php 7287 2021-02-14 14:41:32Z canajun2eh $
 * @translation mr_bobwang
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

//-- CONFIGURE FILE MESSAGES
$pgv_lang["configure"] = "網站設置";

//-- edit privacy messages
$pgv_lang["edit_privacy"] = "隱私文件設置";
$pgv_lang["SHOW_LIVING_NAMES"] = "顯示健在人員名單";

//-- language edit utility
$pgv_lang["edit_langdiff"] = "編輯語言文件";
$pgv_lang["edit_lang_utility"] = "語言編輯工具";
$pgv_lang["edit_lang_utility_help"] = "您能使用這項公共事業編輯語言文件的內容由使用內容英國一個。<br />它將列出您原始的英語文件的內容和您選上的語言內容<br />在點擊在您選上的文件消息以後一個新窗口將打開您能改變和保存您選上的語言消息的地方。";
$pgv_lang["language_to_edit"] = "編輯的語言";
$pgv_lang["file_to_edit"] = "編輯的語言文件";
$pgv_lang["check"] = "檢查";
$pgv_lang["lang_save"] = "保存";
$pgv_lang["contents"] = "內容";
$pgv_lang["listing"] = "目錄";
$pgv_lang["no_content"] = "沒有內容";
$pgv_lang["editlang"] = "編輯";
$pgv_lang["editlang_help"] = "~#pgv_lang[editlang]#~<br /><br />編輯語言文件的信息";
$pgv_lang["savelang"] = "保存";
$pgv_lang["cancel"] = "取消";
$pgv_lang["savelang_help"] = "#pgv_lang[savelang]#~<br /><br />保存信息到語言文件。";
$pgv_lang["original_message"] = "原始的消息";
$pgv_lang["message_to_edit"] = "編輯的信息";
$pgv_lang["changed_message"] = "改變後的信息";
$pgv_lang["message_empty_warning"] = "-> 警告!!! 這個信息沒有在#LANGUAGE_FILE#<- 裡面。";
$pgv_lang["language_to_export"] = "導出的語言";
$pgv_lang["export_lang_utility"] = "導出語言文件";
$pgv_lang["export"] = "導出";
$pgv_lang["compare_lang_utility"] = "語言比較";
$pgv_lang["new_language"] = "原語言";
$pgv_lang["compare"] = "比較";
$pgv_lang["comparing"] = "比較的語言文件";
$pgv_lang["config_lang_utility"] = "設置支持的語言";
$pgv_lang["active"] = "工作狀態中";
$pgv_lang["edit_settings"] = "編輯設置";
$pgv_lang["lang_edit"] = "編輯";
$pgv_lang["lang_language"] = "語言";
$pgv_lang["export_filename"] = "導出的文件名:";
$pgv_lang["lang_name_chinese-cn"] = "簡體中文";
$pgv_lang["lang_name_chinese"] = "繁體中文";
$pgv_lang["lang_name_english"] = "英文";
$pgv_lang["lang_new_language"] = "新的語言";
$pgv_lang["lang_langcode"] = "語言的網頁代碼號";
$pgv_lang["lang_filenames"] = "語言文件";
$pgv_lang["flagsfile"] = "國旗文件";
$pgv_lang["text_direction"] = "寫字方向";
$pgv_lang["date_format"] = "年月日格式";
$pgv_lang["time_format"] = "時間格式";
$pgv_lang["week_start"] = "一周的開始日";
$pgv_lang["name_reverse"] = "姓在前";
$pgv_lang["ltr"] = "從左到右";
$pgv_lang["rtl"] = "從右到左";
$pgv_lang["file_does_not_exist"] = "錯誤！文件不存在...";
$pgv_lang["optional_file_not_exist"] = "多選的文件不存在。";
$pgv_lang["multi_letter_alphabet"] = "多字母的單字";
$pgv_lang["dictionary_sort"] = "用字典的格式來排列";
$pgv_lang["add_new_lang_button"] = "增加新語言";
$pgv_lang["hide_translated"] = "不要顯示翻譯過的信息";
$pgv_lang["users_langs"] = "用戶的語言";
$pgv_lang["configured_languages"] = "被用的語言";
$pgv_lang["um_header"] = "用戶轉移工具";
$pgv_lang["um_creating"] = "創建中";
$pgv_lang["um_file_create_fail2"] = "不可以創建";
$pgv_lang["um_import"] = "導入";
$pgv_lang["um_export"] = "導出";
$pgv_lang["um_imp_succ"] = "導入成功";
$pgv_lang["um_imp_fail"] = "導入失敗";
$pgv_lang["um_backup"] = "備份";
$pgv_lang["um_zip_succ"] = "壓縮的文件成果創建";
$pgv_lang["um_zip_dl"] = "下載壓縮的備份文件";
$pgv_lang["um_bu_config"] = "家譜設置文件";
$pgv_lang["um_bu_gedcoms"] = "家譜文件";
$pgv_lang["um_bu_media"] = "多媒體文件";
$pgv_lang["um_mk_bu"] = "創建悲憤";
$pgv_lang["um_results"] = "結果";
$pgv_lang["ged_filter_results"] = "搜索結果";
$pgv_lang["ged_filter_reset"] = "清除搜索";
$pgv_lang["ged_filter_description"] = "搜索選項";

$pgv_lang["new_gedcom_title"] = "家譜來自於[#GEDCOMFILE#] 文件";
$pgv_lang["USE_MEDIA_VIEWER"] = "使用媒體展覽器";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS"] = "顯示個人關係";
$pgv_lang["AUTO_GENERATE_THUMBS"] = "自動生成縮略圖";
$pgv_lang["SHOW_SOURCES"] = "顯示來源";
$pgv_lang["UNDERLINE_NAME_QUOTES"] = "名字底下劃線";
$pgv_lang["gedcom_conf"] = "家譜簡單信息";
$pgv_lang["media_conf"] = "多媒體";
$pgv_lang["media_general_conf"] = "普通";
$pgv_lang["displ_names_conf"] = "名字";
$pgv_lang["displ_layout_conf"] = "格式";
$pgv_lang["contact_conf"] = "聯繫方法";
$pgv_lang["DBUSER"] = "數據庫用戶名";
$pgv_lang["DBNAME"] = "數據庫名稱";
$pgv_lang["upload_path"] = "上載文件夾";
$pgv_lang["LANGUAGE"] = "語言";
$pgv_lang["ENABLE_MULTI_LANGUAGE"] = "允許用戶改變語言";
$pgv_lang["CALENDAR_FORMAT"] = "日曆格式";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"] = "默認顯示幾代人";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"] = "最大幾代人限度";
$pgv_lang["GENERATE_GUID"] = "自動創造新代碼號";
$pgv_lang["GEDCOM_ID_PREFIX"] = "個人的代碼號編碼";
$pgv_lang["SOURCE_ID_PREFIX"] = "來源的代碼號編碼";
$pgv_lang["REPO_ID_PREFIX"] = "文件夾的代碼號編碼";
$pgv_lang["PEDIGREE_FULL_DETAILS"] = "在表中顯示出生和去世日";
$pgv_lang["PEDIGREE_SHOW_GENDER"] = "表中顯示性別標誌";
$pgv_lang["ZOOM_BOXES"] = "表中有放大功能";
$pgv_lang["SHOW_AGE_DIFF"] = "顯示日期差異";
$pgv_lang["HIDE_LIVE_PEOPLE"] = "開啟隱私功能";
$pgv_lang["REQUIRE_AUTHENTICATION"] = "強制用戶登錄";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"] = "登錄頁有歡迎短信";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"] = "自己的歡迎短信";
$pgv_lang["ALLOW_EDIT_GEDCOM"] = "允許在網絡上更改編輯";
$pgv_lang["EDIT_AUTOCLOSE"] = "自動關閉編輯窗口";
$pgv_lang["POSTAL_CODE"] = "郵編號碼位置";
$pgv_lang["SUBLIST_TRIGGER_I"] = "個人中最多姓";
$pgv_lang["SUBLIST_TRIGGER_F"] = "家庭中最多的姓";
$pgv_lang["SURNAME_LIST_STYLE"] = "姓列表的格式";
$pgv_lang["NAME_FROM_GEDCOM"] = "從家鋪文件中讀取姓名";
$pgv_lang["SHOW_LAST_CHANGE"] = "選擇家譜記錄近期改變的日期";
$pgv_lang["google_analytics_help"] = "~#pgv_lang[google_analytics]#~<br /><br />#pgv_lang[google_analytics]#服务在此<a href='http://en.wikipedia.org/wiki/Google_Analytics' target='_blank' title='Google Analytics'>維基百科文章</a>。<br /><br />請注意，如果您選擇使用此服務，Google會獲取其收集的有關訪問者活動的所有數據的權利你的網站。";
$pgv_lang["USE_GOOGLE_ANALYTICS_help"] = "~#pgv_lang[USE_GOOGLE_ANALYTICS]#~<br /><br />選擇<b>#pgv_lang[yes]#</b>以通過#pgv_lang[google_analytics]#服务跟踪您網站上的活動。在啟用此選項之前，必須訂閱此服務。";
$pgv_lang["PGV_GOOGLE_ANALYTICS_help"] = "~#pgv_lang[PGV_GOOGLE_ANALYTICS]#~<br /><br />當您訂閱#pgv_lang[google_analytics]#服务時，輸入分配給您網站的帳號。此帳號的格式為<b>UA-xxxxxx-x</b>。";
$pgv_lang["piwik_analytics_help"] = "~#pgv_lang[piwik_analytics]#~<br /><br />#pgv_lang[piwik_analytics]#開源條目被描述為<a href='https://matomo.org/' target='_blank' title='Matomo官方網站'>這裡</a>。<br /><br />Matomo是#pgv_lang[google_analytics]#的替代品，它消除了許多隱私問題。您可以自己安裝Matomo應用程序網絡服務器或您自己的域，從而確保您可以完全控制已收集的活動數據。";
$pgv_lang["USE_PIWIK_ANALYTICS_help"] = "~#pgv_lang[USE_PIWIK_ANALYTICS]#~<br /><br />選擇<b>#pgv_lang[yes]#</b>以啟用#pgv_lang[piwik_analytics]#服务對您網站上的活動進行跟踪。 PhpGedView站點必須在Matomo服務器上註冊。";
$pgv_lang["PGV_PIWIK_URL_help"] = "~#pgv_lang[PGV_PIWIK_URL]#~<br /><br />輸入註冊網站的Matomo服務器的URL。";
$pgv_lang["PGV_PIWIK_SITE_help"] = "~#pgv_lang[PGV_PIWIK_SITE]#~<br /><br />輸入Matomo服務器分配給PhpGedView站點的數字站點ID。";
$pgv_lang["clustrmaps_analytics_help"] = "~#pgv_lang[clustrmaps_analytics]#~<br /><br />ClustrMaps是一個組合點擊計數器，訪客跟踪器和地理可視化工具。<br /><br />每個頁面都包含由ClustrMaps生成的縮略圖圖像。當該圖像加載時，ClustrMaps網站上的計數器會遞增。當所有訪問者都可以看到的地圖（每日，每週或每月，具體取決於您的流量）時，它會顯示所有訪問者的位置。自特定時間間隔開始以來的頁面。<br /><br />如果您已經為#pgv_lang[clustrmaps_analytics]#服務付費，點擊該縮略圖地圖可以看到更大的世界地圖顯示。<br /><br />更多細節可以在<a href='http://www.clustrmaps.com/' target='_blank' title='ClustrMaps site'>ClustrMaps網站</a>上找到。";
$pgv_lang["USE_CLUSTRMAPS_ANALYTICS_help"] = "~#pgv_lang[USE_CLUSTRMAPS_ANALYTICS]#~<br /><br />選擇<b>#pgv_lang[yes]#</b>以通過#pgv_lang[clustrmaps_analytics]#server跟踪您網站上的活動。";
$pgv_lang["PGV_CLUSTRMAPS_SITE_help"] = "~#pgv_lang[PGV_CLUSTRMAPS_SITE]#~<br /><br />輸入您的網站的網址。這個值已經為您填寫，您通常不需要更改它。";
$pgv_lang["PGV_CLUSTRMAPS_SERVER_help"] = "~#pgv_lang[PGV_CLUSTRMAPS_SERVER]#~<br /><br />當您激活帳戶時，輸入#pgv_lang[clustrmaps_analytics]#服务分配的服務器號碼。";

$pgv_lang["SHOW_LIST_PLACES"] = "將級別顯示在列表中";
$pgv_lang["SHOW_LIST_PLACES_help"] = "~#pgv_lang[SHOW_LIST_PLACES]#~<br /><br />這決定了在列表的放置字段中顯示了多少位置信息。<br /><br />將值設置為<b>9</b>將確保顯示所有地方信息。將值設置為<b>0</b>（零）將完全隱藏地點。將值設置為<b>1</b>將顯示最頂層等級，通常是國家。設置為<b>2</b>將顯示最高的兩個等級。第二個最高等級，低於國家，通常是州，省或領地。等等。 >" ;

$pgv_lang["keep_media_help"] = "~#pgv_lang[keep_media]#~<br /><br />當上傳替代GEDCOM時，現有媒體鏈接是否應保留在數據庫中。<b>否</b>選項將刪除現有的媒體鏈接。數據庫，而<b>是</b>選項保留它們。<br /><br />當您將GEDCOM從PhpGedView導出到不處理嵌入式媒體指針的離線GEDCOM維護程序時，此選項很有用正確，然後重新導入，將GEDCOM更改為PhpGedView。在這種情況下，您導出到離線編輯程序的GEDCOM中的媒體指針會被破壞，您必須重新鏈接所有媒體文件到將GEDCOM重新導入PhpGedView後，正確的人員，家庭和來源記錄。<br /><br /><b>是</b>選項告訴PhpGedView保留現有的媒體鏈接，這樣就不會導入更改後的GEDCOM後必須重新創建它們，但這需要離線編輯程序始終生成山姆e人員，家庭和來源識別號碼。<br /><br /><i>Family Tree Maker</i>是幾個離線編輯程序之一，它們<u>不</u>正確處理媒體GEDCOM中的對象指針。<i>Legacy</i>，以及其他許多人，正確處理這些問題。";
$pgv_lang["USE_MEDIA_VIEWER_help"] = "~#pgv_lang[USE_MEDIA_VIEWER]#~<br /><br />當此選項<b>#pgv_lang[yes]#</b>時，單擊圖像將生成Media Viewer頁面。此頁面顯示詳細信息如果你有足夠的權利，你也可以編輯這些細節。<br /><br />當這個選項是<b>#pgv_lang[no]#</b>時，點擊圖片會產生一個完整的- 在新窗口中顯示大小的圖像。";
$pgv_lang["USE_MEDIA_FIREWALL"] = "使用媒體防火牆";
$pgv_lang["USE_MEDIA_FIREWALL_help"] = "~#pgv_lang[USE_MEDIA_FIREWALL]#~<br /><br />有關如何使用媒體防火牆的說明，請參閱Wiki。<a href=\"#PGV_PHPGEDVIEW_WIKI#/en/index.php?title=Media_Firewall\" target=\"_blank\">#PGV_PHPGEDVIEW_WIKI#</a>";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR"] = "媒體防火牆根目錄";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_help"] = "~#pgv_lang[MEDIA_FIREWALL_ROOTDIR]#~<br /><br />可以在其中創建受保護的媒體目錄的目錄。#pgv_lang[MEDIA_FIREWALL_ROOTDIR_note]#";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_note"] = "當此字段為空時，將使用<b>#GLOBALS[INDEX_DIRECTORY]#</b>目錄。";
$pgv_lang["MEDIA_FIREWALL_THUMBS"] = "保護受保護圖像的縮略圖";
$pgv_lang["MEDIA_FIREWALL_THUMBS_help"] = "~#pgv_lang[MEDIA_FIREWALL_THUMBS]#~<br /><br />當圖像在受保護的媒體目錄中時，它的縮略圖是否也應受到保護？";
$pgv_lang["SHOW_SPIDER_TAGLINE"] = "顯示蜘蛛標語";
$pgv_lang["SHOW_SPIDER_TAGLINE_help"] = "~#pgv_lang[SHOW_SPIDER_TAGLINE]#~<br /><br />在為搜索引擎生成的頁面上，顯示為頁面檢測到的特定搜索引擎的最後一行。如果啟用此選項，則可能會偏向Google&reg;AdSense搜索引擎優化工具。";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS_help"] = "~#pgv_lang[SHOW_PRIVATE_RELATIONSHIPS]#~<br /><br />此選項將保留私有化記錄中的家庭鏈接。這意味著您將在譜系圖表和其他私人圖表上看到空的\"私人\"框這類似於v4.0之前的PhpGedView版本的行為。<br /><br />此設置默認是關閉的。建議不要打開它，將您的GEDCOM配置中的血統根人員指​​向非私人的人。";
$pgv_lang["SYNC_GEDCOM_FILE_help"] = "~#pgv_lang[SYNC_GEDCOM_FILE]#~<br /><br />在過去的PGV版本中，待處理的編輯存儲在GEDCOM文件中，然後將更改的記錄接受到數據庫中。從v4開始。 1個掛起的更改不再存儲在GEDCOM文件中，而是存儲在更改文件中。<br /><br />將此值設置為true將在更改被接受到數據庫時更新GEDCOM文件。這將使GEDCOM文件保持同步與數據庫的更好兼容性。此字段的默認值為on。<br /><br />您可能希望在接受更改時將其關閉以節省內存。";
$pgv_lang["SYNC_GEDCOM_FILE"] = "將編輯同步到GEDCOM文件中";
$pgv_lang["COMMIT_COMMAND_help"] = "~#pgv_lang[COMMIT_COMMAND]#~<br /><br />如果您希望使用CVS等版本控制系統歸檔對GEDCOM文件和配置或隱私設置的更改，請在此處輸入命令。如果您不想使用版本控制系統，則為空白。有效選項為<b>cvs</b>和<b>svn</b>。";
$pgv_lang["COMMIT_COMMAND"] = "版本控制提交命令";
$pgv_lang["SHOW_MULTISITE_SEARCH_help"] = "~#pgv_lang[SHOW_MULTISITE_SEARCH]#~<br /><br />多站點搜索允許用戶搜索您在管理站點管理區域中設置或遠程鏈接到的多個網站。此選項控制是否為Multi現場搜索功能適用於所有人或僅供經過身份驗證的用戶使用。";
$pgv_lang["SHOW_MULTISITE_SEARCH"] = "顯示多站點搜索";
$pgv_lang["SHOW_NO_WATERMARK"] = "誰可以查看非水印圖像？";
$pgv_lang["SHOW_NO_WATERMARK_help"] = "~#pgv_lang[SHOW_NO_WATERMARK]#~<br /><br />如果啟用了媒體防火牆，用戶將看到沒有此處指定的權限級別的水印。" ;
$pgv_lang["WATERMARK_THUMB"] = "為縮略圖添加水印？";
$pgv_lang["WATERMARK_THUMB_help"] = "~#pgv_lang[WATERMARK_THUMB]#~<br /><br />如果啟用了媒體防火牆，是否應為縮略圖添加水印？如果不對縮略圖添加水印，則媒體列表的加載速度會更快。";
$pgv_lang["SAVE_WATERMARK_THUMB"] = "在服務器上存儲帶水印的縮略圖？";
$pgv_lang["SAVE_WATERMARK_THUMB_help"] = "~#pgv_lang[SAVE_WATERMARK_THUMB]#~<br /><br />如果啟用了媒體防火牆，除了沒有水印的相同縮略圖外，是否應該在服務器上存儲帶水印縮略圖的副本？<br /><br />當設置為<b>#pgv_lang[yes]#</b>時，包含水印縮略圖的媒體列表將以更高的服務器磁盤空間要求為代價更快地生成。";
$pgv_lang["SAVE_WATERMARK_IMAGE"] = "在服務器上存儲帶水印的全尺寸圖像？";
$pgv_lang["SAVE_WATERMARK_IMAGE_help"] = "~#pgv_lang[SAVE_WATERMARK_IMAGE]#~<br /><br />如果啟用了媒體防火牆，除了沒有水印的相同圖像外，是否應將水印全尺寸圖像的副本存儲在服務器上？<br /><br />當設置為<b>#pgv_lang[yes]#</b>時，將以更高的服務器磁盤空間要求為代價，更快地生成全尺寸水印圖像。";
$pgv_lang["DB_UTF8_COLLATION"] = "使用數據庫提供UTF-8校對";
$pgv_lang["DB_UTF8_COLLATION_help"] = "控制PhpGedView是否應該使用數據庫的內置排序和整理工具。使用數據庫來排序和過濾數據而不是PHP通常更快，儘管並非所有數據庫/版本都提供此功能。用於每種語言的歸類序列在該語言的設置頁面中設置。<br /><br /><span class=\"warning\">重要說明:如果您在第一次創建數據庫表之前，應該只將此值設置為YES在現有數據庫中選擇它可能會導致數據損壞。</span><br /><br />MySQL和PostgreSQL都提供對UTF-8的良好支持，儘管並非所有的歸類序列都可用於早期版本的MySQL。其他數據庫很少或根本不支持UTF-8。如果您不確定數據庫是否支持UTF-8，您應該將此值設置為<b>否</b>。<br /><br />這個<a href='http://en.wikipedia.org/wiki/UTF-8' target='_blank' title='Wikipedia article'><b>Wikipedia文章</b></a>包含有關UTF-8的綜合信息和鏈接。";
$pgv_lang["INDI_FACTS_ADD"] = "個人添加事件";
$pgv_lang["INDI_FACTS_ADD_help"] = "~#pgv_lang[INDI_FACTS_ADD]#~<br /><br />這是您的用戶可以添加到個人的GEDCOM事件列表。您可以根據需要刪除或添加事件名稱，甚至是自定義名稱來修改此列表此列表中出現的事件名稱也不得出現在<i>#pgv_lang[INDI_FACTS_UNIQUE]#</i>列表中。";
$pgv_lang["INDI_FACTS_UNIQUE"] = "唯一的個人事件";
$pgv_lang["INDI_FACTS_UNIQUE_help"] = "~#pgv_lang[INDI_FACTS_UNIQUE]#~<br /><br />這是GEDCOM事件列表，您的用戶只能將<u>一次</u>添加到個人。例如，如果BIRT在此列表中，用戶將無法向個人添加多個BIRT記錄。此列表中顯示的事件名稱也不得出現在<i>#pgv_lang[INDI_FACTS_ADD]#</i>列表中。";
$pgv_lang["INDI_FACTS_QUICK"] = "快速個人事件";
$pgv_lang["INDI_FACTS_QUICK_help"] = "~#pgv_lang[INDI_FACTS_QUICK]#~<br /><br />這是完整列表旁邊顯示的GEDCOM個人事件的簡短列表，只需點擊一下即可添加。";
$pgv_lang["FAM_FACTS_ADD"] = "家庭添加事件";
$pgv_lang["FAM_FACTS_ADD_help"] = "~#pgv_lang[FAM_FACTS_ADD]#~<br /><br />這是您的用戶可以添加到家庭的GEDCOM事件列表。您可以根據需要刪除或添加事件名稱，甚至是自定義名稱來修改此列表此列表中出現的事件名稱不得出現在<i>#pgv_lang[FAM_FACTS_UNIQUE]#</i>列表中。";
$pgv_lang["FAM_FACTS_UNIQUE"] = "唯一的家庭事件";
$pgv_lang["FAM_FACTS_UNIQUE_help"] = "~#pgv_lang[FAM_FACTS_UNIQUE]#~<br /><br />這是您的用戶只能將<u>一次</u>添加到家庭的GEDCOM事件列表。例如，如果MARR在此列表中，用戶將無法向一個系列添加多個MARR記錄。此列表中顯示的事件名稱也不得出現在<i>#pgv_lang[FAM_FACTS_ADD]#</i>列表中。";
$pgv_lang["FAM_FACTS_QUICK"] = "快速家庭事件";
$pgv_lang["FAM_FACTS_QUICK_help"] = "~#pgv_lang[FAM_FACTS_QUICK]#~<br /><br />這是GEDCOM家族事件的簡短列表，顯示在完整列表旁邊，只需點擊一下即可添加。";
$pgv_lang["SOUR_FACTS_ADD"] = "來源添加事件";
$pgv_lang["SOUR_FACTS_ADD_help"] = "~#pgv_lang[SOUR_FACTS_ADD]#~<br /><br />這是您的用戶可以添加到源的GEDCOM事件列表。您可以通過刪除或添加事件名稱來修改此列表，甚至可以根據需要添加自定義名稱。此列表中出現的事件名稱也不得出現在<i>#pgv_lang[SOUR_FACTS_UNIQUE]#</i>列表中。";
$pgv_lang["SOUR_FACTS_UNIQUE"] = "唯一的來源事件";
$pgv_lang["SOUR_FACTS_UNIQUE_help"] = "~#pgv_lang[SOUR_FACTS_UNIQUE]#~<br /><br />這是GEDCOM事件列表，您的用戶只能將<u>一次</u>添加到源。例如，如果TITL在此列表中，用戶將無法向源添加多個TITL記錄。此列表中顯示的事件名稱也不得出現在<i>#pgv_lang[SOUR_FACTS_ADD]#</i>列表中。";
$pgv_lang["SOUR_FACTS_QUICK"] = "快速消息來源";
$pgv_lang["SOUR_FACTS_QUICK_help"] = "~#pgv_lang[SOUR_FACTS_QUICK]#~<br /><br />這是完整列表旁邊顯示的GEDCOM源事件的簡短列表，只需單擊即可添加。";
$pgv_lang["REPO_FACTS_ADD"] = "存儲庫添加事件";
$pgv_lang["REPO_FACTS_ADD_help"] = "~#pgv_lang[REPO_FACTS_ADD]#~<br /><br />這是您的用戶可以添加到存儲庫的GEDCOM事件列表。您可以根據需要刪除或添加事件名稱，甚至是自定義名稱來修改此列表。此列表中出現的事件名稱也不得出現在<i>#pgv_lang[REPO_FACTS_UNIQUE]#</i>列表中。";
$pgv_lang["REPO_FACTS_UNIQUE"] = "唯一的存儲庫事件";
$pgv_lang["REPO_FACTS_UNIQUE_help"] = "~#pgv_lang[REPO_FACTS_UNIQUE]#~<br /><br />這是您的用戶只能將<u>一次</u>添加到存儲庫的GEDCOM事件列表。例如，如果NAME在此列表中，用戶將無法向存儲庫添加多個NAME記錄。此列表中顯示的事件名稱也不得出現在<i>#pgv_lang[REPO_FACTS_ADD]#</i>列表中。";
$pgv_lang["REPO_FACTS_QUICK"] = "快速存儲庫事件";
$pgv_lang["REPO_FACTS_QUICK_help"] = "~#pgv_lang[REPO_FACTS_QUICK]#~<br /><br />這是完整列表旁邊顯示的GEDCOM存儲庫事件的簡短列表，只需單擊即可添加。";
$pgv_lang["LANG_SELECTION_help"] = "~#pgv_lang[LANG_SELECTION]#~<br /><br />您可以根據需要添加或刪除複選標記來更改網站支持的語言列表。這會更改用戶可用的語言選擇。<br /><br />您可以通過#pgv_lang[admin]#菜單上的<b>#pgv_lang[enable_disable_lang]#</b>鏈接實現相同的功能，您還可以在其中更改語言的標誌圖標，日期格式，或者是否應該首先打印姓氏。";
$pgv_lang["MEDIA_ID_PREFIX"] = "媒體ID前綴";
$pgv_lang["MEDIA_ID_PREFIX_help"] = "~#pgv_lang[MEDIA_ID_PREFIX]#~<br /><br />當在PhpGedView中在線添加新媒體記錄時，將自動生成該媒體的新ID。媒體ID將具有此前綴。";
$pgv_lang["FAM_ID_PREFIX"] = "家庭ID前綴";
$pgv_lang["FAM_ID_PREFIX_help"] = "~#pgv_lang[FAM_ID_PREFIX]#~<br /><br />當在PhpGedView中在線添加新的家庭記錄時，將自動生成該家庭的新ID。家庭ID將具有此前綴。";
$pgv_lang["QUICK_REQUIRED_FAMFACTS"] = "家庭總是在快速更新中顯示的事件";
$pgv_lang["QUICK_REQUIRED_FAMFACTS_help"] = "~#pgv_lang[QUICK_REQUIRED_FAMFACTS]#~<br /><br />這是一個逗號分隔的GEDCOM事件標籤列表，它們將始終顯示在快速更新表單的\"系列\"選項卡上，無論它們是否已存在於系列中例如，如果MARR在列表中，則結婚日期和結婚地點的字段將始終顯示在表單上。";
$pgv_lang["QUICK_ADD_FAMFACTS"] = "家庭在快速更新中展示的事件";
$pgv_lang["QUICK_ADD_FAMFACTS_help"] = "~#pgv_lang[QUICK_ADD_FAMFACTS]#~<br /><br />這是一個逗號分隔的GEDCOM事件標籤列表，將在快速更新表單的\"系列\"選項卡上顯示。只顯示此列表中的事件在表格上或在您在表格上添加新事件的區域中可供選擇。";
$pgv_lang["QUICK_REQUIRED_FACTS"] = "總是在快速更新中顯示的事件";
$pgv_lang["QUICK_REQUIRED_FACTS_help"] = "~#pgv_lang[QUICK_REQUIRED_FACTS]#~<br /><br />這是一個逗號分隔的GEDCOM事件標籤列表，無論它們是否已經存在於個人記錄中，它們將始終顯示在快速更新表格中。例如如果BIRT在列表中，則出生日期和出生地的字段將始終顯示在表單上。";
$pgv_lang["QUICK_ADD_FACTS"] = "在快速更新中顯示的事件";
$pgv_lang["QUICK_ADD_FACTS_help"] = "~#pgv_lang[QUICK_ADD_FACTS]#~<br /><br />這是一個逗號分隔的GEDCOM事件標籤列表，將在快速更新表單上顯示。只有此列表中的事件才會顯示在表格上或在您在表單上添加新事件的區域中可供選擇。";
$pgv_lang["SURNAME_TRADITION_help"] = "~#pgv_lang[SURNAME_TRADITION]#~<br /><br />當您向家庭添加新成員時，PhpGedView可以根據地區習慣為姓氏提供默認值。<br /><br /><ul><li>在<b>Paternal</b>傳統中，所有家庭成員都分享父親的姓氏。</li><li>在<b>西班牙語</b>和<b>葡萄牙語</b>傳統中，孩子們從每個父母那裡得到一個姓氏。</li><li>在<b>冰島語</b>傳統中，孩子們將男性父母的姓名作為姓氏，後綴表示性別。</li><li>在<b>波蘭語</b>傳統中，所有家庭成員都分享父親的姓氏。對於某些姓氏，後綴表示性別。後綴<i>ski</i>，<i>cki</i>，<i>dzki</i>表示男性，而相應的後綴<i>ska</i>，<i>cka</i>和<i>dzka</i>表示女性。</li></ul>";
$pgv_lang["ADVANCED_NAME_FACTS_help"] = "~#pgv_lang[ADVANCED_NAME_FACTS]#~<br /><br />這是一個逗號分隔的GEDCOM事件標籤列表，將在添加/編輯名稱表單中顯示。如果您使用非拉丁字母，如希伯來語，希臘語，西里爾語或阿拉伯語，您可能需要添加標籤，如_HEB，ROMN，FONE等，以便您可以將名稱存儲在幾個不同的字母表中。";
$pgv_lang["ADVANCED_PLAC_FACTS_help"] = "~#pgv_lang[ADVANCED_PLAC_FACTS]#~<br /><br />這是一個逗號分隔的GEDCOM事件標籤列表，將在您添加或編輯地名時顯示。如果您使用非拉丁字母，如希伯來語，希臘語，西里爾語或阿拉伯語，您可能需要添加標籤，如_HEB，ROMN，FONE等，以便您可以將地名存儲在幾個不同的字母表中。";
$pgv_lang["GEONAMES_KEY"] = "geonames.org Userid";
$pgv_lang["GEONAMES_KEY_help"] = "~#pgv_lang[GEONAMES_KEY]#~<br /><br />此用戶ID需要訪問免費的geonames.org地理名稱數據庫。如果您沒有提供有效的用戶ID，您將無法搜索數據庫。<br /><br />您可以在<a href='http://www.geonames.org/login' target='_blank'>geonames.org登錄頁面上請求geonames.org用戶ID</a>。<br /><br />然後您將收到一封帶有確認鏈接的電子郵件，在您確認電子郵件後，您可以在上啟用您的網絡服務帳戶<a href='http://www.geonames.org/manageaccount' target='_ blank'>您的帳戶頁面</a>";
$pgv_lang["GEONAMES_BIAS"] = "geonames.org Country Bias";
$pgv_lang["GEONAMES_BIAS_help"] = "~#pgv_lang[GEONAMES_BIAS]#~<br /><br />通常，GeoNames數據庫搜索按字母順序顯示其結果，而不考慮地點所在的國家/地區。此選項指定位於所選地點的地點國家應該在結果清單的頂部報告。";
$pgv_lang["GEONAMES_BIAS_no_preference"] = "沒有偏好";
$pgv_lang["GEOCODE_KEY"] = "Google地理編碼服務器密鑰";
$pgv_lang["GEOCODE_KEY_help"] = "~#pgv_lang[GEOCODE_KEY]#~<br /><br />訪問免費的地理名稱谷歌數據庫需要此密鑰。如果您沒有提供有效密鑰，您將無法搜索此數據庫。<br /><br />您可以通過<a href='https://developers.google.com/maps/documentation/geocoding/get-api-key' target='_blank'> Google Developer請求密鑰控制台</a>。您可以使用英語以外的其他語言查看此頁面，方法是在頁面底部選擇所需的語言。";
$pgv_lang["AUTO_GENERATE_THUMBS_help"] = "~#pgv_lang[AUTO_GENERATE_THUMBS]#~<br /><br />系統是否應自動為沒有它們的圖像生成縮略圖。您的PHP安裝可能不支持此功能。";
$pgv_lang["phpinfo_help"] = "~#pgv_lang[phpinfo]#~<br /><br />此頁面提供了有關託管PhpGedView的服務器的大量信息。有關服務器軟件的許多配置詳細信息，與PHP和PhpGedView相關，可以是看了。";
$pgv_lang["config_help_help"] = "~#pgv_lang[config_help]#~<br /><br />此頁面將配置幫助的所有主要主題收集到一個位置。您可以在屏幕上查看信息，也可以將其打印出來供以後使用。";
$pgv_lang["more_help_advice"] = "<br /><b>更多幫助</b><br />點擊頁面上條目旁邊的<b>？</b>即可獲得更多幫助。";
$pgv_lang["THUMBNAIL_WIDTH"] = "生成縮略圖的寬度";
$pgv_lang["THUMBNAIL_WIDTH_help"] = "~#pgv_lang[THUMBNAIL_WIDTH]#~<br /><br />這是程序在自動生成縮略圖時將使用的寬度（以像素為單位）。默認設置為100. ";
$pgv_lang["USE_SILHOUETTE"] = "使用輪廓";
$pgv_lang["USE_SILHOUETTE_help"] = "~#pgv_lang[USE_SILHOUETTE]#~<br /><br />當沒有指定該人的突出顯示圖像時使用輪廓圖像。使用的圖像特定於相關人員的性別。<br /><br /><table><tr><td wrap valign=\"middle\">當人的性別未知時，可能會使用此圖像:</td><td><img src=\" images/silhouette_unknown.gif\" width=\"40\" alt =\"剪影圖像\" title=\"剪影圖像\"/></td></tr></table>";
$pgv_lang["SHOW_SOURCES_help"] = "~#pgv_lang[SHOW_SOURCES]#~<br /><br />設置所有來源的隱私訪問級別。如果用戶無權訪問來源，將從列表菜單和來源選項卡中刪除來源列表將不會顯示在個人詳細信息頁面上。";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION_help"] = "~#pgv_lang[REQUIRE_ADMIN_AUTH_REGISTRATION]#~<br /><br />如果選項<b>#pgv_lang[USE_REGISTRATION_MODULE]#</b>已啟用，此設置將控制管理員是否必須批淮註冊。<br /><br />將此設置為<b>是</b>將要求所有新用戶首先驗證自己，然後在他們登錄之前獲得管理員的批淮。在<b>否</b>上進行此設置，當用戶驗證他們的帳戶時，將自動檢查<b>#pgv_lang[verified_by_admin]#</b>複選框，從而允許在沒有管理員干預的情況下立即登錄。";
$pgv_lang["SPLIT_PLACES"] = "在編輯模式下拆分位置";
$pgv_lang["SPLIT_PLACES_help"] = "~#pgv_lang[SPLIT_PLACES]#~<br /><br />將此設置為<b>是</b>將逗號分隔每個地名到子字段中以便於編輯。例如:<br /><ol><li>默認模式<br /><u>地點</u>:美國加利福尼亞州聖馬特奧半月灣<br /><br /></li><li>分裂模式<br /><u>國家</u>:美國<br /><u>州</u>:加州<br /><u>縣</u>:聖馬特奧<br /><u>城市</u>:半月灣</li></ol>";
$pgv_lang["UNDERLINE_NAME_QUOTES_help"] = "~#pgv_lang[UNDERLINE_NAME_QUOTES]#~<br /><br />許多程序會將首選的名稱放在GEDCOM的引號中。通常的慣例是強調給定的首選名稱。選項會將引號括起的任何名稱轉換為&lt;span&gt;，並使用CSS類\"starredname\"。<br /><br />例如，如果GEDCOM中的名稱為1&nbsp;NAME&nbsp;Gustave&nbsp;\"Jean&nbsp;Paul\"&nbsp;Charles&nbsp;/Wilson/啟用此選項會將引號中包含的名稱部分更改為&lt;span&nbsp;class =\"starredname\"&gt;Jean&nbsp;Paul&lt;/span&gt;以進行打印。根據其他設置，瀏覽器會將該名稱顯示為<b>Gustave&nbsp;<u>Jean&nbsp;Paul</u>&nbsp;Charles&nbsp;Wilson</b>或<b>Wilson,&nbsp;Gustave&nbsp;<u>Jean&nbsp;Paul</u> Charles</b>。";
$pgv_lang["PRIVACY_BY_RESN"] = "使用GEDCOM（RESN）隱私限制";
$pgv_lang["PRIVACY_BY_RESN_help"] = "~#pgv_lang[PRIVACY_BY_RESN]#~<br /><br />GEDCOM 5.5.1規範包括使用RESN標籤為GEDCOM文件中的人員和事件設置隱私選項的選項。啟用此選項將告訴程序在GEDCOM記錄中查找1級RESN標籤。級別2+ RESN標籤會自動應用，不會受到此設置的影響。請注意，這可能會降低PhpGedView的某些功能，例如個人列表。<br />";
$pgv_lang["SHOW_LDS_AT_GLANCE"] = "在圖錶框中顯示LDS條例代碼";
$pgv_lang["SHOW_LDS_AT_GLANCE_help"] = "~#pgv_lang[SHOW_LDS_AT_GLANCE]#~<br /><br />將此選項設置為<b>是</b>將在圖錶框中顯示LDS條例的狀態代碼。<ul><li><b>B</b> - 洗禮</li><li><b>E</b> - 賦予</li><li><b>S</b> - 密封配偶</li><li><b> P</b> - 密封給父母</li></ul>完成所有條例的人將在姓名後打印<b>BESP</b>。缺少的條例由<b表示> _</b>代替相應的字母代碼。例如，<b>BE __</b>表示缺少<b>S</b>和<b>P</b>條例。";
$pgv_lang["GEDCOM_DEFAULT_TAB"] = "默認選項卡顯示在個人頁面上";
$pgv_lang["GEDCOM_DEFAULT_TAB_help"] = "~#pgv_lang[GEDCOM_DEFAULT_TAB]#~<br /><br />此選項允許您在訪問該頁面時選擇在個人頁面上自動打開哪個選項卡。";
$pgv_lang["SHOW_MARRIED_NAMES"] = "在個人名單上顯示已婚姓名";
$pgv_lang["SHOW_MARRIED_NAMES_help"] = "~#pgv_lang[SHOW_MARRIED_NAMES]#~<br /><br />此選項將在個人列表中顯示已婚女性的名字。此選項要求您在導入GEDCOM文件時計算已婚姓名。";
$pgv_lang["SHOW_QUICK_RESN"] = "在#pgv_lang[quick_update_title]#上顯示隱私字段";
$pgv_lang["SHOW_QUICK_RESN_help"] = "~#pgv_lang[SHOW_QUICK_RESN]#~<br /><br />此選項允許您打開或關閉#pgv_lang[quick_update_title]#表單上的隱私字段。隱私字段允許通過以下方式添加信息的用戶表格覆蓋他們正在進入的事件的默認隱私。";
$pgv_lang["USE_QUICK_UPDATE"] = "使用表格#pgv_lang[quick_update_title]#";
$pgv_lang["USE_QUICK_UPDATE_help"] = "~#pgv_lang[USE_QUICK_UPDATE]#~<br /><br />此選項確定通過#pgv_lang[quick_update_title]#表單提交更改所需的用戶權限。<br /><br />選擇<b>#pgv_lang[nobody]#</b>表示此表單根本無法使用。";
$pgv_lang["SEARCHLOG_CREATE"] = "歸檔SearchLog文件";
$pgv_lang["SEARCHLOG_CREATE_help"] = "~#pgv_lang[SEARCHLOG_CREATE]#~<br /><br />程序應該多久歸檔一次Searchlog文件。";
$pgv_lang["CHANGELOG_CREATE"] = "存檔ChangeLog文件";
$pgv_lang["CHANGELOG_CREATE_help"] = "~#pgv_lang[CHANGELOG_CREATE]#~<br /><br />程序應該多久存檔一次Changelog文件。";
$pgv_lang["CHART_BOX_TAGS"] = "圖表中顯示的其他事件";
$pgv_lang["CHART_BOX_TAGS_help"] = "~#pgv_lang[CHART_BOX_TAGS]#~<br /><br />這應該是一個逗號或空格分隔的事件列表，除了出生和去世之外，你想要出現在圖表框中，如譜系圖表。此列表要求您使用GEDCOM 5.5.1標淮中定義的事件標籤。例如，如果您希望職業顯示在框中，您可以在此字段中添加\"OCCU\"。";
$pgv_lang["FULL_SOURCES"] = "使用完整的來源引用";
$pgv_lang["FULL_SOURCES_help"] = "~#pgv_lang[FULL_SOURCES]#~<br /><br />來源引用可以包括記錄數據質量的字段（主要，次要等）以及事件在源中記錄的日期。如果你不要使用這些字段，您可以在創建新的源引用時禁用它們。";
$pgv_lang["PREFER_LEVEL2_SOURCES"] = "來源類型";
$pgv_lang["PREFER_LEVEL2_SOURCES_help"] = "~#pgv_lang[PREFER_LEVEL2_SOURCES]#~<br /><br />添加新近親時，可以在記錄中添加源引用（例如INDI，FAM）或事件（BIRT，MARR， DEAT）。控制默認選中的複選框。";
$pgv_lang["media_firewall_conf"] = "媒體防火牆";
$pgv_lang["accpriv_conf"] = "訪問和隱私";
$pgv_lang["displ_conf"] = "顯示和佈局";
$pgv_lang["displ_comsurn_conf"] = "普通姓氏";
$pgv_lang["displ_hide_conf"] = "顯示和隱藏";
$pgv_lang["editopt_conf"] = "編輯選項";
$pgv_lang["useropt_conf"] = "用戶選項";
$pgv_lang["meta_conf"] = "網站和META標籤設置";
$pgv_lang["gedconf_head"] = "GEDCOM配置";
$pgv_lang["other_theme"] = "其他，請輸入";
$pgv_lang["performing_update"] = "執行更新。";
$pgv_lang["config_file_read"] = "配置文件讀取。";
$pgv_lang["does_not_exist"] = "不存在";
$pgv_lang["media_drive_letter"] = "媒體路徑不應包含驅動器號;可能不會顯示媒體。";
$pgv_lang["db_setup_bad"] = "您當前的數據庫配置很糟糕。請檢查您的數據庫連接參數並重新配置。";
$pgv_lang["bad_host_user_pass"] = "PhpGedView無法建立與數據庫主機的連接。檢查主機，用戶名和密碼以確保它們是正確的。";
$pgv_lang["bad_database_name"] = "PhpGedView建立了與數據庫主機的連接，但無法使用您輸入的數據庫。請檢查數據庫是否存在以及您輸入的用戶名是否具有該數據庫的相應權限。";
$pgv_lang["db"] = "數據庫";
$pgv_lang["current_gedcoms"] = "當前的GEDCOM";
$pgv_lang["ged_gedcom"] = "GEDCOM文件";
$pgv_lang["ged_title"] = "GEDCOM標題";
$pgv_lang["ged_config"] = "配置文件";
$pgv_lang["ged_search"] = "SearchLog文件";
$pgv_lang["ged_change"] = "ChangeLog文件";
$pgv_lang["ged_privacy"] = "隱私檔案";
$pgv_lang["disabled"] = "已禁用";
$pgv_lang["mouseover"] = "鼠標懸停";
$pgv_lang["mousedown"] = "鼠标按下";
$pgv_lang["click"] = "鼠標點擊";
$pgv_lang["enter_db_pass"] = "為了安全起見，在更改任何配置值時，必須始終輸入#pgv_lang[DBUSER]#和#pgv_lang[DBPASS]#。";
$pgv_lang["server_url_note"] = "這應該是您的PhpGedView文件夾的URL。如果您確定知道自己在做什麼，則只應更改此設置.PhpGedView已將此值確定為<b>#GUESS_URL#< /b>";

$pgv_lang["DBTYPE"] = "數據庫類型";
$pgv_lang["DBTYPE_help"] = "~#pgv_lang[DBTYPE]#~<br /><br />要連接的數據庫類型。<br /><br />PhpGedView可以使用任何有PDO驅動程序的數據庫。你需要確保你的php.ini文件加載<b>php_pdo</b>庫和數據庫的相應驅動程序，例如<b>php_pdo_mysql</b>。<br /><br />大多數數據庫需要用戶名和密碼你還需要在安裝PhpGedView之前創建數據庫。但是，SQLite不需要#pgv_lang[DBHOST]#，#pgv_lang[DBUSER]#或#pgv_lang[DBPASS]#，但是你需要設置一個文件路徑您的數據庫在#pgv_lang[DBNAME]#字段中.PepGedView將為您創建SQLite數據庫文件。";
$pgv_lang["DBHOST"] = "數據庫主機";
$pgv_lang["DBHOST_help"] = "~#pgv_lang[DBHOST]#~<br /><br />託管數據庫服務器的計算機的DNS或IP地址。如果您使用的是SQLite數據庫，則忽略此設置。";
$pgv_lang["DBPORT"] = "數據庫端口";
$pgv_lang["DBPORT_help"] = "~#pgv_lang[DBPORT]#~<br /><br />連接數據庫服務器時應使用的TCP端口。將此設置留空以使用特定類型數據庫的默認端口。此設置為如果您使用的是SQLite數據庫，則會被忽略。";
$pgv_lang["DBUSER_help"] = "~#pgv_lang[DBUSER]#~<br /><br />登錄數據庫所需的數據庫用戶名。如果您使用的是SQLite數據庫，則忽略此設置。";
$pgv_lang["DBPASS"] = "數據庫密碼";
$pgv_lang["DBPASS_help"] = "~#pgv_lang[DBPASS]#~<br /><br />您在#pgv_lang[DBUSER]#字段中輸入的用戶的數據庫密碼。如果您使用的是SQLite數據庫，則會忽略此設置。";
$pgv_lang["DBNAME_help"] = "~#pgv_lang[DBNAME]#~<br /><br />您希望PhpGedView使用的服務器中的數據庫。<br /><br />您在#pgv_lang[DBUSER]#字段中輸入的用戶名必須擁有此數據庫的創建，插入，更新，刪除和選擇權限。在SQLite中，您需要將其設置為PHP可寫入的目錄中的文件名，例如索引目錄（index/phpgedview.db）。";
$pgv_lang["TBLPREFIX_help"] = "~#pgv_lang[TBLPREFIX]#~<br /><br />前綴為PhpGedView創建的表。通過更改此值，您可以設置多個PhpGedView站點以使用相同的物理數據庫但不同的表。例如，同一個站點可以託管一個測試以及一個帶有完全獨立數據表的PhpGedView的生產安裝。";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"] = "~#pgv_lang[ALLOW_CHANGE_GEDCOM]#~<br /><br />如果您的環境有多個GEDCOM，將此值設置為<b>是</b>可以讓您的網站訪問者<u>和</u>用戶可以選擇更改GEDCOM。將其設置為<b>否</b>禁用GEDCOM切換訪問者<u>和</u>登錄用戶。";
$pgv_lang["upload_path_help"] = "~#pgv_lang[upload_path]#~<br /><br />這是您可以找到要上傳的GEDCOM文件的路徑。要選擇路徑，請單擊<b>瀏覽</b>並導航到您的GEDCOM文件，然後單擊<b>打開</b>。";
$pgv_lang["gedcom_path"] = "服務器上GEDCOM的路徑和名稱";
$pgv_lang["gedcom_path_help"] = "~#pgv_lang[gedcom_path]#~<br /><br />有兩種方法可以將GEDCOM文件導入PhpGedView。它們是:<ol><li>將文件FTP到服務器</li><li>在PhpGedView中上傳</li></ol>當您的文件已存在於服務器上時，您可以使用<i>#pgv_lang[add_gedcom]#</i>過程並填寫GEDCOM文件的路徑和名稱它們存在於服務器上。名稱可以有或沒有擴展名。如果沒有給出擴展名，則會假定.ged。路徑是可選的。如果沒有給出路徑，<i>#pgv_lang[INDEX_DIRECTORY]#</i>的值將使用您在PhpGedView站點配置中設置的選項。請注意，在大多數服務器上，文件和路徑名稱區分大小寫。<br /><br />當您使用時在PhpGedView中內置<i>#pgv_lang[upload_gedcom]#</i>程序，您可以使用<b>瀏覽</b>按鈕在本地計算機上找到所需的文件。这可以是常规GEDCOM文件或包含GEDCOM文件的ZIP文件。PhpGedView會自動提取和然後使用該ZIP文件中包含的GEDCOM文件。<br /><br />上傳文件時，可以指定備用路徑和/或文件名，以便將其保存在服務器上。<br /><br />有關詳細信息，請參閱<a href=\"readme.txt\">readme.txt</a>文件。";
$pgv_lang["CHARACTER_SET"] = "字符集編碼";
$pgv_lang["CHARACTER_SET_help"] = "~#pgv_lang[CHARACTER_SET]#~<br /><br />這是你的GEDCOM文件的字符集.UTF-8是默認的，幾乎適用於所有網站。如果你使用IBM Windows編碼導出你的GEDCOM你應該把WINDOWS放在這裡。<br /><br />注意:PhpGedView不支持UNICODE（UTF-16），因為PHP中缺少支持。";
$pgv_lang["LANGUAGE_help"] = "~#pgv_lang[LANGUAGE]#~<br /><br />分配網站的默認語言。<br /><br />當<b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b>選項是設置，用戶可以通過瀏覽器的首選語言配置，帳戶頁面上的配置選項或大多數PhpGedView頁面上的鏈接或按鈕覆蓋此設置。";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"] = "~#pgv_lang[ENABLE_MULTI_LANGUAGE]#~<br /><br />設置為<b>是</b>以允許用戶覆蓋網站的默認語言。他們可以通過瀏覽器的首選語言配置，配置選項來執行此操作在他們的帳戶頁面上，或通過大多數PhpGedView頁面上的鏈接或按鈕。";
$pgv_lang["CALENDAR_FORMAT_help"] = "~#pgv_lang[CALENDAR_FORMAT]#~<br /><br />日期可以記錄在各種日曆中，例如Gregorian，Julian或猶太人日曆。此選項允許您將日期轉換為首選日曆。例如，您可以選擇格里高利將朱利安和希伯來日期轉換為格里高利。轉換日期顯示在常規日期後的括號中。<br /><br />日期只有在日曆有效時才會被轉換。例如，只有日期在22&nbsp;SEP&nbsp;1792和31&nbsp;DEC&nbsp;1805之間將轉換為法國共和黨日曆，並且只有15月15日後的日期將被轉換為公曆。<br /><br />希伯來語與猶太人，但使用希伯來字符。阿拉伯語與Hijri相同，但使用阿拉伯字符。<br /><br />注意:由於猶太人和Hijri日曆日在黃昏開始，所以從黃昏到午夜發生的任何事件都將顯示在正確日期前一天。希伯來語和阿拉伯語的顯示可能有問題舊瀏覽器中的matic，可以向後顯示文本（從左到右）或根本不顯示本。";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"] = "顯示希伯來語千人";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"] = "~#pgv_lang[DISPLAY_JEWISH_THOUSANDS]#~<br /><br />在希伯來日曆中顯示Alafim。<br /><br />將此設置為<b>是</b>將1969年顯示為<span lang=\"he-IL\" dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;&quot;& #1496;</span>&lrm;設置時它<b>否</b>將年份顯示為<span lang=\"he-IL\" dir='rtl'>&#1514;&#1513;& #1499;&quot;&#1496;</span>&lrm;。這對猶太年設置沒有影響。無論此設置如何，年份都將顯示為5729.<br /><br />注意:此設置類似於PHP 5.0 Calendar常量CAL_JEWISH_ADD_ALAFIM。";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"] = "顯示希伯來語Gershayim";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"] = "~#pgv_lang[DISPLAY_JEWISH_GERESHAYIM]#~<br /><br />顯示希伯來語日期時顯示單引號和雙引號。<br /><br />設置為<b>是</b>將顯示2月8日1969年<span lang='he-IL' dir='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496 ;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;將其設為<b>否</b>時會將其顯示為<span lang='he-IL' dir='rtl'>&#1499 ;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;。這對猶太年設置，因為引號不會用於顯示拉丁字符的猶太日期。<br /><br />注意:此設置類似於PHP 5.0日曆常量CAL_JEWISH_ADD_ALAFIM_GERESH和CAL_JEWISH_ADD_GERESHAYIM。此單一設置會影響兩者。";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"] = "Jewish Ashkenaz發音";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"] = "~#pgv_lang[JEWISH_ASHKENAZ_PRONUNCIATION]#~<br /><br />使用猶太人的Ashkenazi發音。<br /><br />當設置為<b>是</b>時，Cheshvan和Teves的拼寫將與Ashkenazi的發音。將它設置為<b>否</b>將改變Hesvan和Tevet的月份。這只會影響猶太人的設置。希伯來語設置將始終使用希伯來語字母。";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"] = "~#pgv_lang[DEFAULT_PEDIGREE_GENERATIONS]#~<br /><br />設置要在Descendancy和Pedigree圖表上顯示的默認代數。";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"] = "最大譜系世代";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"] = "~#pgv_lang[MAX_PEDIGREE_GENERATIONS]#~<br /><br />設置要在譜系圖表上顯示的最大代數。";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"] = "~#pgv_lang[MAX_DESCENDANCY_GENERATIONS]#~<br /><br />設置在Descendancy圖表上顯示的最大代數。";
$pgv_lang["USE_RIN"] = "使用RIN編號代替GEDCOM ID";
$pgv_lang["USE_RIN_help"] = "~#pgv_lang[USE_RIN]#~<br /><br />當在配置文件，用戶設置和用戶設置中詢問個人ID時，設置為<b>是</b >以使用RIN編號而不是GEDCOM ID這對於那些不能一直導出GEDCOM的家譜程序非常有用，這些GEDCOM具有分配給每個人的相同ID，但總是使用相同的RIN。";
$pgv_lang["GENERATE_GUID_help"] = "~#pgv_lang[GENERATE_GUID]#~<br /><br /><b>GUID</b>在此上下文中是全球唯一ID的首字母縮寫。<br /><br />GUID旨在幫助以可重複的方式識別每個人，以便鹽湖城LDS教會的家庭歷史中心等中央組織，甚至是在您自己的服務器上運行的兼容程序，可以確定他們是否在與同一個人打交道無論GEDCOM源自何處。家族歷史中心的目標是擁有一個中心數據庫系統數據庫並通過網絡服務公開它。這將使任何程序都能訪問數據並更新其中的數據。<br /><br />如果你不打算與其他任何人分享這個GEDCOM，你不需要讓PhpGedView創建這些GUID;但是，除了增加你的GEDCOM的大小之外，這樣做不會有任何傷害。";
$pgv_lang["PEDIGREE_ROOT_ID"] = "譜系和後裔圖表的默認人";
$pgv_lang["PEDIGREE_ROOT_ID_help"] = "~#pgv_lang[PEDIGREE_ROOT_ID]#~<br /><br />設置要在譜系圖和後裔圖表上顯示的默認人的ID。";
$pgv_lang["GEDCOM_ID_PREFIX_help"] = "~#pgv_lang[GEDCOM_ID_PREFIX]#~<br /><br />當在PhpGedView中在線添加新的個人記錄時，將自動生成該個人的新ID。個人ID將具有此前綴。";
$pgv_lang["SOURCE_ID_PREFIX_help"] = "~#pgv_lang[SOURCE_ID_PREFIX]#~<br /><br />當在PhpGedView中在線添加新的源記錄時，將自動生成該源的新ID。源ID將具有此前綴。";
$pgv_lang["REPO_ID_PREFIX_help"] = "~#pgv_lang[REPO_ID_PREFIX]#~<br /><br />當在PhpGedView中在線添加新的存儲庫記錄時，將自動生成該存儲庫的新ID。存儲庫ID將具有此前綴。";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"] = "~#pgv_lang[PEDIGREE_FULL_DETAILS]#~<br /><br />此選項控制是否在圖表上顯示個人的出生和去世詳細信息。";
$pgv_lang["PEDIGREE_SHOW_GENDER_help"] = "~#pgv_lang[PEDIGREE_SHOW_GENDER]#~<br /><br />此選項控制是否在圖表上顯示個人的性別圖標。<br /><br />由於性別也由顏色表示方框中，此選項不會隱藏性別。該選項只是從框中刪除一些重複信息。";
$pgv_lang["PEDIGREE_LAYOUT"] = "默認譜系圖表佈局";
$pgv_lang["PEDIGREE_LAYOUT_help"] = "~#pgv_lang[PEDIGREE_LAYOUT]#~<br /><br />此選項指示是否應以橫向或縱向模式生成譜系圖表。";
$pgv_lang["SHOW_EMPTY_BOXES"] = "在譜系圖表上顯示空白框";
$pgv_lang["SHOW_EMPTY_BOXES_help"] = "~#pgv_lang[SHOW_EMPTY_BOXES]#~<br /><br />此選項控制是否在譜系圖表上顯示空框。";
$pgv_lang["ZOOM_BOXES_help"] = "~#pgv_lang[ZOOM_BOXES]#~<br /><br />允許用戶在圖表上縮放框以獲取更多信息。<br /><br />設置為<b>#pgv_lang[disabled]#</b>禁用此功能。當用戶將鼠標懸停在框中的圖標上時，設置為<b>#pgv_lang[mouseover]#</b>縮放框。設置為<b>#pgv_lang[click]#</b>當用戶點擊框中的圖標時縮放框。";
$pgv_lang["LINK_ICONS"] = "圖表上的PopUp鏈接";
$pgv_lang["LINK_ICONS_help"] = "~#pgv_lang[LINK_ICONS]#~<br /><br />允許用戶選擇指向其他圖表和近親的鏈接。<br /><br />設置為<b>#pgv_lang[disabled]#<b>禁用此功能。當用戶將鼠標懸停在方框中的圖標上時，設置為<b>#pgv_lang[mouseover]#</b>以彈出鏈接。設置為<b>#pgv_lang[click]#</b>在用戶點擊框中的圖標時彈出鏈接。";
$pgv_lang["ABBREVIATE_CHART_LABELS"] = "縮略圖標籤";
$pgv_lang["ABBREVIATE_CHART_LABELS_help"] = "~#pgv_lang[ABBREVIATE_CHART_LABELS]#~<br /><br />此選項控制是否在第一個字母（如<b>B</b）的圖表上縮寫<b>Birth</b>等標籤>。<br /><br />您可以通過在每種語言的<i>languages/extra.xx.php</i>文件中提供覆蓋值來自定義縮寫。例如，如果要使用<b>*</b>而不是<b>N</b>以縮寫法語中的BIRT事件，您應該將以下條目放入<i>languages/extra.fr.php</i>文件中:<br /><br /><code>\$factAbbrev[\"BIRT\"]&nbsp;=&nbsp;\"*\";</code><br /><br />指定此縮寫的長度方式不限於1個字符。";
$pgv_lang["SHOW_AGE_DIFF_help"] = "~#pgv_lang[SHOW_AGE_DIFF]#~<br /><br />此選項控制近親選項卡是否應顯示配偶的出生日期，第一個孩子的結婚日期和出生日期之間以及出生日期之間的差異孩子們。";
$pgv_lang["SHOW_PARENTS_AGE"] = "在孩子的出生日期旁邊顯示父母的年齡";
$pgv_lang["SHOW_PARENTS_AGE_help"] = "~#pgv_lang[SHOW_PARENTS_AGE]#~<br /><br />此選項控制是否在圖表上顯示孩子出生日期旁邊的父親和母親的年齡。";
$pgv_lang["SHOW_RELATIVES_EVENTS"] = "在個人頁面上顯示近親的事件";
$pgv_lang["SHOW_RELATIVES_EVENTS_help"] = "~#pgv_lang[SHOW_RELATIVES_EVENTS]#~<br /><br />親屬的出生，婚姻和去世是一生中的重要事件。這個選項控制是否在<i>個人事件和個人頁面上的詳細信息</i>標籤。<br /><br />受此選項影響的事件包括:<ul><li>配偶去世</li><li>兒童的出生和去世</li><li>父母的去世</li><li>兄弟姐妹的出生和去世</li><li>祖父母的去世</li><li>父母的兄弟姐妹的生死</li></ul>";
$pgv_lang["EXPAND_RELATIVES_EVENTS"] = "自動擴展近親事件清單";
$pgv_lang["EXPAND_RELATIVES_EVENTS_help"] = "~#pgv_lang[EXPAND_RELATIVES_EVENTS]#~<br /><br />此選項控制是否自動展開<i>近親事件</i>列表。";
$pgv_lang["EXPAND_SOURCES"] = "自動擴展來源";
$pgv_lang["EXPAND_SOURCES_help"] = "~#pgv_lang[EXPAND_SOURCES]#~<br /><br />此選項控制是否在個人頁面上自動顯示<i>Source</i>記錄的內容。<br />";
$pgv_lang["EXPAND_NOTES"] = "自動擴展筆記";
$pgv_lang["EXPAND_NOTES_help"] = "~#pgv_lang[EXPAND_NOTES]#~<br /><br />此選項控制是否在個人頁面上自動顯示<i>Note</i>記錄的內容。";
$pgv_lang["SHOW_LEVEL2_NOTES"] = "在Notes和Sources選項卡上顯示所有Notes和Source引用";
$pgv_lang["SHOW_LEVEL2_NOTES_help"] = "~#pgv_lang[SHOW_LEVEL2_NOTES]#~<br /><br />此選項控製附加到Facts的Notes和Source引用是否應顯示在Individual頁面的Notes和Sources選項卡上。<br /><br />通常，Notes和Sources選項卡僅顯示直接附加到個人數據庫記錄的Notes和Source引用。這些是<i>1級</i>Notes和Source引用。<br /><br /><b>#pgv_lang[yes]#</b>選項使這些選項卡還顯示Notes和Source引用，這些引用是個人數據庫記錄中各種Facts的一部分。這些是<i>level 2</i>Notes和來源參考，因為各種事件都在1級。";
$pgv_lang["HIDE_LIVE_PEOPLE_help"] = "~#pgv_lang[HIDE_LIVE_PEOPLE]#~<br /><br />此選項將啟用所有隱私設置並隱藏在世人員的詳細信息。<br /><br />在世人員被定義為不在世的人有一個事件比變量\$MAX_ALIVE_AGE中指定的年數更新。為此，孩子的出生也被認為是這樣的事件。";
$pgv_lang["REQUIRE_AUTHENTICATION_help"] = "~#pgv_lang[REQUIRE_AUTHENTICATION]#~<br /><br />啟用此選項將強制所有訪問者登錄，然後才能查看網站上的任何數據。";
$pgv_lang["PAGE_AFTER_LOGIN"] = "登錄後顯示的頁面";
$pgv_lang["PAGE_AFTER_LOGIN_help"] = "~#pgv_lang[PAGE_AFTER_LOGIN]#~<br /><br />用戶登錄後應該看到哪個頁面？<br /><br />此處的選擇決定了成功登錄是否會導致歡迎或者從#pgv_lang[welcome_page]#登錄時出現MyGedView頁面。<br /><br />從每個其他頁面頂部的鏈接完成登錄將使用戶返回該頁面。";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_help"] = "~#pgv_lang[WELCOME_TEXT_AUTH_MODE]#~<br /><br />在這裡，您可以選擇要在登錄屏幕上顯示的文本。您必須確定哪種預定義文本最合適。<br /><br />您也可以選擇輸入您自己的自定義歡迎文本，但是當您的用戶更改語言時，您輸入的文本將不會被翻譯。但是，如果您的自定义文本包含可以在各种<i>languages/ extra.xx.php</i>文件中定义的语言变量的引用，则您的站点可以显示已翻译的文本。有關詳細信息，請參閱與<b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#</b>字段相關聯的幫助文本。<br /><br />預定義文本為:<ul><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT1]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_1]#</div><br /></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT2]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_2]#</div><br /></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT3]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_3]#</div></li></ul>";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT0"] = "沒有預定義的文字";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"] = "預定義文本，聲明所有用戶都可以請求用戶帳戶";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"] = "規定管理員將根據用戶帳戶的每個請求決定的預定義文本";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"] = "僅定義家庭成員的預定義文本可以請求用戶帳戶";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"] = "選擇下面鍵入的用戶定義的歡迎文本";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_help"] = "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#~<br /><br />如果您選擇了自定義歡迎文本，則可以在此處輸入該文本。文本不會被翻譯成訪問者的語言，但會顯示與您輸入的完全一樣。但是，如果您的自定義文本包含可以在各種<i>languages/extra.xx.php</i>文件中定義的語言變量的引用，則您的站點可以顯示已翻譯的文本。<br /><br />您可以在自定義歡迎文本中插入HTML標記。<br /><br />以下描述取自FAQ列表的幫助文本，同樣適用於自定義歡迎文本。<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"] = "自定義歡迎文本的標淮標題";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD_help"] = "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST_HEAD]#~<br /><br />選擇顯示自定義歡迎文本的標淮標題。當用戶更改語言時，此標題將以新語言顯示。<br /><br />如果設置為<b>是</b>，標題看起來如下:<div class=\"list_value_wrap\">#pgv_lang[welcome_text_cust_head]#</div>";
$pgv_lang["SHOW_REGISTER_CAUTION"] = "在申請新用戶帳戶»頁面上顯示可接受使用協議";
$pgv_lang["SHOW_REGISTER_CAUTION_help"] = "~#pgv_lang[SHOW_REGISTER_注意]#~<br /><br />當設置為<b>#pgv_lang[yes]#</b>時，上的輸入字段上方將顯示以下消息«#pgv_lang[requestaccount]#»页:<div class=\"list_value_wrap\">#pgv_lang[acceptable_use]#</div>";
$pgv_lang["CHECK_CHILD_DATES"] = "檢查孩子日期";
$pgv_lang["CHECK_CHILD_DATES_help"] = "~#pgv_lang[CHECK_CHILD_DATES]#~<br /><br />在確定一個人是否已經去世時檢查孩子的日期。在較舊的系統和大型GEDCOM上，這可能會減慢您網站的響應時間。";
$pgv_lang["MAX_ALIVE_AGE"] = "假定一個人去世的年齡";
$pgv_lang["MAX_ALIVE_AGE_help"] = "~#pgv_lang[MAX_ALIVE_AGE]#~<br /><br />如果這個人除了去世，埋葬或火葬以外的任何事件比這個年數更近，他被認為是活著的。兒童的出生日期被視為此類事件。";
$pgv_lang["SHOW_GEDCOM_RECORD"] = "允許用戶查看原始GEDCOM記錄";
$pgv_lang["SHOW_GEDCOM_RECORD_help"] = "~#pgv_lang[SHOW_GEDCOM_RECORD]#~<br /><br />將此設置為<b>是</b>將在個人，來源和家庭上放置鏈接，讓用戶打開另一個包含原始數據的窗口就在GEDCOM檔案之外。";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"] = "~#pgv_lang[ALLOW_EDIT_GEDCOM]#~<br /><br />此選項為此數據庫啟用在線編輯功能，以便具有編輯權限的用戶可以在線更新數據。";
$pgv_lang["ENABLE_AUTOCOMPLETE"] = "啟用自動完成功能";
$pgv_lang["ENABLE_AUTOCOMPLETE_help"] = "~#pgv_lang[ENABLE_AUTOCOMPLETE]#~<br /><br />此選項確定在輸入表單的某些字段中輸入信息時是否應激活自動完成。當此選項設置為<b>#pgv_lang[yes]#</b>，可以自動完成的文本輸入字段由不同顏色的背景指示。<br /><br />當自動完成處於活動狀態時，PhpGedView將根據您已經擁有的內容在其數據庫中搜索可能的匹配項當您輸入更多信息時，可能的匹配列表會被細化。當您在匹配列表中看到所需的輸入時，您可以將鼠標光標移動到列表的該行，然後單擊鼠標左鍵以完成輸入。<br /><br />自動完成的缺點是它會降低程序速度，導致大量數據庫活動，並導致更多數據被發送到瀏覽器。";
$pgv_lang["EDIT_AUTOCLOSE_help"] = "~#pgv_lang[EDIT_AUTOCLOSE]#~<br /><br />此選項控制是否在成功更新後自動關閉編輯窗口。";
$pgv_lang["INDEX_DIRECTORY_help"] = "~#pgv_lang[INDEX_DIRECTORY]#~<br /><br />PhpGedView應存儲索引文件的可讀寫目錄的路徑（包括尾隨的\"/\"）。PhpGedView不需要此目錄的名稱你可以選擇任何你喜歡的名字。<br /><br />為了安全起見，這個目錄應放在服務器文件空間的某個地方，無法從互聯網上訪問。結構如下:<br /><b>PhpGedView:</b> dir1/dir2/dir3/PhpGedView<br /><b>索引:</b> dir1/dir4/dir5/dir6/index<br /><br />對於顯示的示例，您將在此字段中輸入<b>../../dir4/dir5/dir6/index/</b>。";
$pgv_lang["POSTAL_CODE_help"] = "~#pgv_lang[POSTAL_CODE]#~<br /><br />不同的國家/地區使用不同的方式來編寫地址。此選項可讓您在城市名稱之前或之後放置郵政編碼。";
$pgv_lang["SUBLIST_TRIGGER_I_help"] = "~#pgv_lang[SUBLIST_TRIGGER_I]#~<br /><br />根據個人姓名的第一個字母，可以將具有相同姓氏的長名單分成較小的子列表。<br /><br />此選項確定何時會出現姓氏的子列表。要完全禁用子列表，請將此選項設置為零。";
$pgv_lang["SUBLIST_TRIGGER_F_help"] = "~#pgv_lang[SUBLIST_TRIGGER_F]#~<br /><br />根據給定名字的第一個字母，可以將具有相同名稱的長列表分成較小的子列表。<br /><br />此選項確定何時會出現姓氏的子列表。要完全禁用子列表，請將此選項設置為零。";
$pgv_lang["SURNAME_LIST_STYLE_help"] = "~#pgv_lang[SURNAME_LIST_STYLE]#~<br /><br />姓氏列表，因為它們出現在#pgv_lang[block_top10]#block，#pgv_lang[individual_list]#和#pgv_lang[family_list]#中，可以用不同的風格顯示。<ul><li><b>#pgv_lang[style2]#</b>&nbsp;&nbsp;&nbsp;在這種風格中，姓氏顯示在一個表格中，可以按表格排序姓氏或按計數。</li><li><b>#pgv_lang[style3]#</b>&nbsp;&nbsp;&nbsp;在此樣式中，姓氏顯示在列表中，並且每個姓氏使用的字體大小name取決於數據庫中該名稱的出現次數。該列表不可排序。</li></ul>";
$pgv_lang["SHOW_ID_NUMBERS_help"] = "~#pgv_lang[SHOW_ID_NUMBERS]#~<br /><br />此選項控制是否在圖表和列表上的名稱後面的括號中顯示ID號。";
$pgv_lang["SHOW_LAST_CHANGE_help"] = "~#pgv_lang[SHOW_LAST_CHANGE]#~<br /><br />此選項控制是否在列表上顯示GEDCOM記錄的最後更改日期。";
$pgv_lang["SHOW_EST_LIST_DATES"] = "顯示出生和去世的預計日期";
$pgv_lang["SHOW_EST_LIST_DATES_help"] = "~#pgv_lang[SHOW_EST_LIST_DATES]#~<br /><br />此選項控制是否顯示出生和去世的預計日期，而不是將個別列表和圖表留空，以便日期未知。";
$pgv_lang["SHOW_PEDIGREE_PLACES"] = "放置水平以顯示在人的框中";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"] = "~#pgv_lang[SHOW_PEDIGREE_PLACES]#~<br /><br />這會設置在圖表上的人員框中顯示多少地方信息。<br /><br />將值設置為9將保證顯示所有位置級別。將值設置為0將完全隱藏位置。將值設置為1將顯示第一級別，將其設置為2將顯示前兩個級別，等等。";
$pgv_lang["MULTI_MEDIA"] = "啟用多媒體功能";
$pgv_lang["MULTI_MEDIA_help"] = "~#pgv_lang[MULTI_MEDIA]#~<br /><br />GEDCOM 5.5.1允許您將圖片，視頻和其他多媒體對象鏈接到您的GEDCOM。如果您沒有在GEDCOM中包含多媒體對象，您可以通過將此值設置為<b>否</b>來禁用多媒體功能。<br /><br />請參閱<a href=\"readme.txt\"> readme.txt </a中的多媒體部分>文件，了解有關在您的網站中包含媒體的更多信息。";
$pgv_lang["MEDIA_EXTERNAL"] = "媒體外部鏈接";
$pgv_lang["MEDIA_EXTERNAL_help"] = "~#pgv_lang[MEDIA_EXTERNAL]#~<br /><br />當找到以例如http://，ftp://，mms://開頭的多媒體鏈接時，設置為<時不會更改b>是</b>。例如，http://www.myfamily.com/photo/dad.jpg將保留http://www.myfamily.com/photo/dad.jpg。設置為<b>時否</b>，鏈接將作為標淮參考處理，並將使用媒體深度。例如:http://www.myfamily.com/photo/dad.jpg將更改為./media/dad.jpg";
$pgv_lang["MEDIA_DIRECTORY"] = "MultiMedia目錄";
$pgv_lang["MEDIA_DIRECTORY_help"] = "~#pgv_lang[MEDIA_DIRECTORY]#~<br /><br />PhpGedView應存儲媒體文件的可讀寫目錄的路徑（包括尾隨的\"/\"）。PhpGedView不需要此目錄的名稱您可以選擇任何您喜歡的名稱。<br /><br />即使媒體防火牆功能允許您將媒體文件存儲在無法從Internet訪問的服務器文件空間區域，此處命名的目錄必須仍然存在，並且必須可以從Internet讀取並且可以通過PhpGedView寫入。有關更多信息，請參閱GEDCOM配置頁面的多媒體部分中的媒體防火牆配置選項。";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"] = "保持多媒體目錄級別";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"] = "~#pgv_lang[MEDIA_DIRECTORY_LEVELS]#~<br /><br />值為0將忽略媒體對象文件路徑中的所有目錄。值為1將保留包含此圖像的第一個目錄。增加要保留在路徑中的父目錄的數量。<br /><br />例如，如果您將GEDCOM中的圖像鏈接到之類的路徑<b>C:\\Documents&nbsp;和&nbsp;Settings\\User \\my&nbsp;Documents\\My&nbsp;Pictures\\Genealogy\\Surname&nbsp;Line\\grandpa.jpg</b>，值為0會將此路徑轉換為<b>./media/grandpa.jpg</b> 。值為1會將其轉換為<b>./media/Surname&nbsp;Line/grandpa.jpg</b>等。大多數人只需要使用0.但是，有可能保留一些媒體對象在此選項設置為0時，在不同目錄中具有相同的名稱並相互覆蓋。非零設置允許您在媒體中保留一些組織，從而防止名稱衝突。";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"] = "~#pgv_lang[SHOW_HIGHLIGHT_IMAGES]#~<br /><br />如果您在網站上啟用了多媒體功能，您可以讓PhpGedView在圖表和框中的人名旁邊顯示縮略圖。<br /><br />目前，PhpGedView使用GEDCOM記錄中列出的第一個多媒體對像作為高亮圖像。對於擁有多個圖像的人，您應該安排多媒體對象，使您希望突出顯示的多媒體對象首先出現在任何其他對象之前。<br /><br />有關在您的站點中包含媒體的更多信息，請參閱<a href=\"readme.txt\">readme.txt</a>文件中的多媒體部分。";
$pgv_lang["USE_THUMBS_MAIN"] = "使用縮略圖";
$pgv_lang["USE_THUMBS_MAIN_help"] = "~#pgv_lang[USE_THUMBS_MAIN]#~<br /><br />此選項確定只要圖表或個人詳細信息頁面需要縮略圖，PhpGedView是否應將大圖像或小圖像發送到瀏覽器。<br /><br /><b>#pgv_lang[no]#</b>選項將導致PhpGedView發送大圖像，而<b>#pgv_lang[yes]#</b>選項將導緻小圖像每個單獨的圖像還有&laquo;#factarray[_THUM]#&raquo;選項，當設置為<b>#pgv_lang[yes]#</b>時，將導致無論設置如何都會發送大圖像GEDCOM配置中&laquo;#pgv_lang[USE_THUMBS_MAIN]#&raquo;選項。當GEDCOM配置指定應始終使用大圖像時，不能強制PhpGedView發送小圖像。<br /><br />PhpGedView不會重新調整正在發送的圖像的大小;瀏覽器根據它收到的頁面規範執行此操作。當發送的圖像不是真正的圖像時，這會產生不良後果PhpGedView期望發送小圖像的縮略圖。這不是錯誤:在某些情況下，可能需要在人們通常希望看到縮略圖大小的圖片地方顯示大圖像。<br /><br />您應該避免設置&laquo;#pgv_lang[USE_THUMBS_MAIN]#&RAQUO;選項<b>#pgv_lang[no]#</b>。此選擇將導致過多的圖像相關數據被發送到瀏覽器，只是讓瀏覽器丟棄多餘的數據。頁面加載，尤其是包含許多圖像的圖表，可能會嚴重減慢。";
$pgv_lang["SHOW_MEDIA_FILENAME"] = "在Media Viewer中顯示文件名";
$pgv_lang["SHOW_MEDIA_FILENAME_help"] = "~#pgv_lang[SHOW_MEDIA_FILENAME]#~<br /><br />媒體查看器可以顯示正在查看的媒體文件的名稱。此選項確定是否向用戶顯示該文件名。<br /><br />出於安全原因，您可能希望隱藏文件名。";
$pgv_lang["SHOW_MEDIA_DOWNLOAD"] = "在Media Viewer中顯示下載鏈接";
$pgv_lang["SHOW_MEDIA_DOWNLOAD_help"] = "~#pgv_lang[SHOW_MEDIA_DOWNLOAD]#~<br /><br />媒體查看器可以顯示一個鏈接，單擊此鏈接後，會將媒體文件下載到本地PC。<br /><br />您可能需要出於安全原因隱藏下載鏈接。";
$pgv_lang["ENABLE_CLIPPINGS_CART"] = "啟用Clippings Cart";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"] = "~#pgv_lang[ENABLE_CLIPPINGS_CART]#~<br /><br />剪報購物車允許用戶將人們添加到臨時文件中，他們可以用GEDCOM格式下載這些文件，以便隨後導入他們的家譜軟件。";
$pgv_lang["HIDE_GEDCOM_ERRORS"] = "隱藏GEDCOM錯誤";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"] = "~#pgv_lang[HIDE_GEDCOM_ERRORS]#~<br /><br />將此設置為<b>是</b>將隱藏PhpGedView在您不理解GEDCOM文件中的標記時產生的錯誤消息.PhpGedView make盡力遵守GEDCOM 5.5.1標淮，但許多家譜軟件程序都包含自己的自定義標籤。有關詳細信息，請參閱<a href=\"readme.txt\"> readme.txt</a>文件。";
$pgv_lang["WORD_WRAPPED_NOTES"] = "添加包含備註的空格";
$pgv_lang["WORD_WRAPPED_NOTES_help"] = "~#pgv_lang[WORD_WRAPPED_NOTES]#~<br /><br />一些族譜程序在單詞邊界處包裝註釋，而其他程序包在任何地方註釋。這可能導致PhpGedView一起運行單詞。將此設置為<b>是</b >將在原始GEDCOM中包含的單詞之間添加一個空格。";
$pgv_lang["SHOW_CONTEXT_HELP"] = "顯示上下文<b>？</b>幫助鏈接";
$pgv_lang["SHOW_CONTEXT_HELP_help"] = "~#pgv_lang[SHOW_CONTEXT_HELP]#~<br /><br />此選項將在許多頁面上的條目旁邊啟用由問號標識的鏈接。這些鏈接允許用戶獲取有關這些條目的信息或幫助。 />";
$pgv_lang["DAYS_TO_SHOW_LIMIT"] = "即將舉行的活動日期範圍限制";
$pgv_lang["DAYS_TO_SHOW_LIMIT_help"] = "~#pgv_lang[DAYS_TO_SHOW_LIMIT]#~<br /><br />輸入在即將發生的事件塊中顯示的最大天數。此數字不能大於30.如果輸入較大的值，將使用30。<br /><br />您在此處輸入的值決定了PhpGedView在搜索即將發生的事件時所看到的距離。此搜索的結果每天進行一次，將被複製到臨時文件中。<br /><br />索引頁面或門戶頁面上的任何即將發生的事件塊都可以請求比此值更多的天數。您創建的日期越大，構建每日數據庫提取所需的時間越長，顯示塊所需的時間越長，即使您請求顯示少於此設置的天數。";
$pgv_lang["COMMON_NAMES_THRESHOLD"] = "最少發生的事件是普通姓氏";
$pgv_lang["COMMON_NAMES_THRESHOLD_help"] = "~#pgv_lang[COMMON_NAMES_THRESHOLD]#~<br /><br />這是姓氏在歡迎頁面的Common Surname列表中顯示之前必須出現的次數。";
$pgv_lang["COMMON_NAMES_ADD"] = "要添加到Common Surnames的名稱（以逗號分隔）";
$pgv_lang["COMMON_NAMES_ADD_help"] = "~#pgv_lang[COMMON_NAMES_ADD]#~<br /><br />如果某個姓氏出現的次數低於閾值，它將不會出現在列表中。可以手動添加到此處。如果更多如果輸入了一個姓氏，則必須用逗號分隔。<b>姓氏區分大小寫。</b>";
$pgv_lang["COMMON_NAMES_REMOVE"] = "要從Common Surnames中刪除的名稱（以逗號分隔）";
$pgv_lang["COMMON_NAMES_REMOVE_help"] = "~#pgv_lang[COMMON_NAMES_REMOVE]#~<br /><br />如果你想在不增加閾值的情況下從Common Surname列表中刪除姓氏，你可以在這裡輸入姓氏來做到這一點。如果有多個姓氏輸入時，必須用逗號分隔。<b>姓氏區分大小寫。</b>此處輸入的姓氏也將從歡迎頁面的前10名列表中刪除。";
$pgv_lang["HOME_SITE_URL"] = "主要網站網址";
$pgv_lang["HOME_SITE_URL_help"] = "~#pgv_lang[HOME_SITE_URL]#~<br /><br />每個PhpGedView頁面都包含指向主頁面的鏈接。此鏈接的外觀由所使用的主題控制。您輸入實際的URL到您的主頁網站在這裡。";
$pgv_lang["HOME_SITE_TEXT"] = "主要網站文字";
$pgv_lang["HOME_SITE_TEXT_help"] = "~#pgv_lang[HOME_SITE_TEXT]#~<br /><br />用於標識主頁主頁鏈接的圖例。";
$pgv_lang["CONTACT_EMAIL"] = "家譜聯繫";
$pgv_lang["CONTACT_EMAIL_help"] = "~#pgv_lang[CONTACT_EMAIL]#~<br /><br />有關本網站系譜數據的聯繫人。";
$pgv_lang["CONTACT_METHOD"] = "聯繫方式";
$pgv_lang["CONTACT_METHOD_help"] = "~#pgv_lang[CONTACT_METHOD]#~<br /><br />用於聯繫#pgv_lang[CONTACT_EMAIL]#關於家譜問題的方法。<ul> <li><b>#pgv_lang[mailto]#</b>選項將創建一個mailto鏈接，可以單擊該鏈接以使用用戶PC上的郵件客戶端發送電子郵件。</li><li><b>#pgv_lang[messaging]#</b>選項將使用PhpGedView內部的消息傳遞系統，並且不會發送任何電子郵件。</li><li><b>#pgv_lang[messaging2]#</b>選項是默認選項。它將使用PhpGedView消息系統，也將通過電子郵件發送消息的副本。</li><li><b>#pgv_lang[messaging3]#</b>選項允許PhpGedView處理消息，並將消息作為電子郵件發送，但不會在內部存儲消息。此選項類似於<b>#pgv_lang[mailto]#</b>選項，但消息將由PhpGedView而不是用戶的工作站發送。</li><li><b>#pgv_lang[no_messaging]#</b>此选项会阻止您的用户与您联系。</li></ul>";
$pgv_lang["PHPGEDVIEW_EMAIL"] = "PhpGedView回复地址";
$pgv_lang["PHPGEDVIEW_EMAIL_help"] = "~#pgv_lang[PHPGEDVIEW_EMAIL]#~<br /><br />在PhpGedView自動創建的電子郵件的&laquo;From:&raquo;字段中使用的電子郵件地址。<br /><br />PhpGedView可以自動創建電子郵件，通知管理員需要審核的更改.PhpGedView還會向已請求帳戶的用戶發送通知電子郵件。<br /><br />通常，&laquo;From:&raquo;這些自動創建的電子郵件的字段類似於<i>From:phpgedview-noreply@yoursite</i>，表明不需要回復電子郵件。為了防止垃圾郵件或其他電子郵件濫用，一些電子郵件系統要求每條消息的&laquo;From:&raquo;字段反映有效的電子郵件帳戶，並且不接受明顯來自帳戶<i>phpgedview-noreply</i>的消息。";
$pgv_lang["WEBMASTER_EMAIL"] = "支持聯繫";
$pgv_lang["WEBMASTER_EMAIL_help"] = "~#pgv_lang[WEBMASTER_EMAIL]#~<br /><br />有關您網站上遇到的技術問題或錯誤的聯繫人。";
$pgv_lang["SUPPORT_METHOD"] = "支持方法";
$pgv_lang["SUPPORT_METHOD_help"] = "~#pgv_lang[SUPPORT_METHOD]#~<br /><br />用於聯繫#pgv_lang[WEBMASTER_EMAIL]#關於技術問題的方法。<ul><li><b>#pgv_lang[mailto]#</b>選項將創建一個mailto鏈接，可以單擊該鏈接以使用用戶PC上的郵件客戶端發送電子郵件。</li><li><b>#pgv_lang[messaging]# < /b>選項將使用PhpGedView內部的消息傳遞系統，並且不會發送任何電子郵件。</li><li><b>#pgv_lang[messaging2]#</b>選項是默認選項。它將使用PhpGedView消息系統，也將通過電子郵件發送消息的副本。</li><li><b>#pgv_lang[messaging3]#</b>選項允許PhpGedView處理消息，並將消息作為電子郵件發送，但不會在內部存儲消息。此選項類似於<b>#pgv_lang[mailto]#</b>選項，但消息將由PhpGedView而不是用戶的工作站發送。</li><li><b>#pgv_lang[no_messaging]#</b>此选项会阻止您的用户与您联系</li></ul>";
$pgv_lang["SHOW_FACT_ICONS"] = "顯示事件圖標";
$pgv_lang["SHOW_FACT_ICONS_help"] = "~#pgv_lang[SHOW_FACT_ICONS]#~<br /><br />將此設置為<b>#pgv_lang[yes]#</b>，以在#pgv_lang[personal_facts]#頁面上顯示Fact name附近的圖標。僅當圖標存在於當前主題的<i>images/facts</i>目錄中時，才會顯示圖標。";
$pgv_lang["FAVICON"] = "收藏夾圖標";
$pgv_lang["FAVICON_help"] = "~#pgv_lang[FAVICON]#~<br /><br />將此更改為指向您希望在人們收藏的網站上顯示的圖標。";
$pgv_lang["THEME_DIR"] = "主題目錄";
$pgv_lang["THEME_DIR_help"] = "~#pgv_lang[THEME_DIR]#~<br /><br />保存PhpGedView主題文件的目錄。<br /><br />您可以自定義PhpGedView附帶的任何標淮主題，以便為您提供網站具有唯一的外觀和感覺。有關詳細信息，請參閱<a href=\"readme.txt\">readme.txt</a>文件的主題自定義部分。";
$pgv_lang["TIME_LIMIT"] = "PHP時間限制";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"] = "~#pgv_lang[PGV_SESSION_SAVE_PATH]#~<br /><br />存儲PhpGedView會話文件的路徑。<br /><br />某些主機沒有正確配置PHP，並且不在頁面請求之間維護會話。此選項允許站點管理員通過將文件保存在其中一個本地目錄中來克服該問題。如果需要更改此選項，./index/目錄是一個不錯的選擇。默認情況下將該字段留空，這將使用保存路徑在<i>php.ini</i>中配置。";
$pgv_lang["SERVER_URL_help"] = "~#pgv_lang[SERVER_URL]#~<br /><br />如果您使用https或默認端口以外的端口，則需要輸入URL以訪問您的服務器。";
$pgv_lang["LOGIN_URL"] = "登錄網址";
$pgv_lang["LOGIN_URL_help"] = "~#pgv_lang[LOGIN_URL]#~<br /><br />如果您想在用戶登錄時重定向到其他站點或位置，則只需輸入登錄URL。如果您需要切換，這非常有用當您的用戶登錄時，從http到https。包括<i>login.php</i>的完整URL。例如，https://www.yourserver.com/phpgedview/login.php。";
$pgv_lang["PGV_SESSION_TIME_help"] = "~#pgv_lang[PGV_SESSION_TIME]#~<br /><br />PhpGedView會話在需要登錄前保持活動狀態的時間（以秒為單位）。默認為7200，即2小時。";
$pgv_lang["SHOW_STATS"] = "顯示執行統計數據";
$pgv_lang["SHOW_STATS_help"] = "~#pgv_lang[SHOW_STATS]#~<br /><br />在每個頁面的底部顯示運行時統計信息和數據庫查詢。";
$pgv_lang["SHOW_COUNTER"] = "顯示計數器";
$pgv_lang["SHOW_COUNTER_help"] = "~#pgv_lang[SHOW_COUNTER]#~<br /><br />在Portal和Individual頁面上顯示點擊計數器。";
$pgv_lang["USE_REGISTRATION_MODULE_help"] = "~#pgv_lang[USE_REGISTRATION_MODULE]#~<br /><br />為訪問者提供在網站上註冊帳戶的選項。<br /><br />訪問者將收到一封帶有代碼的電子郵件驗證他的帳戶申請。驗證後，管理員必須在註冊之前批淮註冊。";
$pgv_lang["ALLOW_USER_THEMES_help"] = "~#pgv_lang[ALLOW_USER_THEMES]#~<br /><br />為用戶提供選擇自己主題的選項。";
$pgv_lang["PGV_SIMPLE_MAIL_help"] = "~#pgv_lang[PGV_SIMPLE_MAIL]#~<br /><br />在外部郵件的普通郵件標題中，使用了電子郵件地址和名稱。有些郵件系統不接受此郵件。當設置為<b>時是的</b>，只會使用電子郵件地址。";
$pgv_lang["PGV_SMTP_ACTIVE_help"] = "~#pgv_lang[PGV_SMTP_ACTIVE]#~<br /><br />使用SMTP從PhpGedView發送電子郵件。<br /><br />此選項需要訪問SMTP郵件服務器。設置為<b時>#pgv_lang[no]#</b> PhpGedView將在此服務器上使用PHP內置的電子郵件系統。";
$pgv_lang["PGV_SMTP_HOST_help"] = "~#pgv_lang[PGV_SMTP_HOST]#~<br /><br />這是SMTP郵件服務器的名稱。例如:<b>smtp.foo.bar.com</b>。<br /><br />某些電子郵件提供商的配置值:<br /><br /><b>Gmail<br /></b><br /><b>#pgv_lang[PGV_SMTP_HOST]#:</b>smtp.gmail.com<br /><b>#pgv_lang[PGV_SMTP_PORT]#:</b>465或587<br /><b>#pgv_lang[PGV_SMTP_SSL]#:</b>SSL<br /><br /><b>Hotmail<br /></b><br /><b>#pgv_lang[PGV_SMTP_HOST]#:</b>smtp.live.com<br /><b>#pgv_lang[PGV_SMTP_PORT]#:</b>25或587<br /><b>#pgv_lang[PGV_SMTP_SSL]#:</b>TLS<br /><br /><b>Yahoo Mail Plus（目前是付費服務）</></b><br /><b>#pgv_lang[PGV_SMTP_HOST]#:</b> smtp.mail.yahoo.com<br /><b>#pgv_lang[PGV_SMTP_PORT]#:</b>25";
$pgv_lang["PGV_SMTP_HELO_help"] = "~#pgv_lang[PGV_SMTP_HELO]#~<br /><br />這是SMTP服務器上有效電子郵件地址的域名。<br /><br />例如，如果你有一個e郵箱帳戶，例如<b>yourname@abc.xyz.com</b>，你可以在這裡輸入<b>abc.xyz.com</b>。";
$pgv_lang["PGV_SMTP_PORT_help"] = "~#pgv_lang[PGV_SMTP_PORT]#~<br /><br />用於連接SMTP服務器的端口號。一般來說，這是端口<b>25</b>。";
$pgv_lang["PGV_SMTP_AUTH_help"] = "~#pgv_lang[PGV_SMTP_AUTH]#~<br /><br />使用名稱和密碼身份驗證連接到SMTP服務器。<br /><br />某些SMTP服務器要求所有連接在接受之前進行身份驗證出境電子郵件。";
$pgv_lang["PGV_SMTP_AUTH_USER_help"] = "~#pgv_lang[PGV_SMTP_AUTH_USER]#~<br /><br />使用SMTP服務器進行身份驗證所需的用戶名。";
$pgv_lang["PGV_SMTP_AUTH_PASS_help"] = "~#pgv_lang[PGV_SMTP_AUTH_PASS]#~<br /><br />使用SMTP服務器進行身份驗證所需的密碼。";
$pgv_lang["PGV_SMTP_SSL_help"] = "~#pgv_lang[PGV_SMTP_SSL]#~<br /><br />傳輸層安全性（TLS）和安全套接字層（SSL）是Internet數據加密協議。<br /><br />TLS 1.0,1.1和1.2是SSL 3.0的標淮化開發。TLS 1.0和SSL 3.1是等效的。現在使用新名稱TLS進行SSL的進一步工作。<br /><br />如果您的SMTP服務器在登錄期間需要SSL協議，您應該選擇<b>SSL</b>選項。如果您的SMTP服務器在登錄期間需要TLS協議，則應選擇<b>TLS</b>選項。";
$pgv_lang["PGV_SMTP_FROM_NAME_help"] = "~#pgv_lang[PGV_SMTP_FROM_NAME]#~<br /><br />輸入在本網站發送的電子郵件的&laquo;From:&raquo;字段中使用的名稱。<br /><br />例如，如果您的名字是<b>John Smith</b>並且您是一個名為<b>Jones Genealogy</b>的網站的網站管理員，則可以輸入類似<b>John Smith</b>的內容b>或<b>Jones Genealogy</b>甚至<b>John Smith，管理員:Jones Genealogy</b>。您可以輸入任何您想要的內容，但不允許使用HTML。";
$pgv_lang["gedcom_title"] = "#pgv_lang[ged_title]#";
$pgv_lang["gedcom_title_help"] = "~#pgv_lang[gedcom_title]#~<br /><br />輸入用戶在您網站上的GEDCOM數據集中選擇時要顯示的描述性標題。";
$pgv_lang["LOGFILE_CREATE"] = "歸檔日誌文件";
$pgv_lang["LOGFILE_CREATE_help"] = "~#pgv_lang[LOGFILE_CREATE]#~<br /><br />程序應該多久歸檔一次日誌文件。";
$pgv_lang["PGV_MEMORY_LIMIT_help"] = "~#pgv_lang[PGV_MEMORY_LIMIT]#~<br /><br />PhpGedView腳本可以消耗的最大內存量。默認64為32 Mb。許多主機在PHP配置中禁用此選項;更改此值可能實際上並沒有影響當前的最大內存設置。";
$pgv_lang["PGV_STORE_MESSAGES_help"] = "~#pgv_lang[PGV_STORE_MESSAGES]#~<br /><br />指定通過PhpGedView發送的消息是否可以存儲在數據庫中。如果設置為<b>是</b>，用戶將能夠在何時檢索消息他們登錄PhpGedView。如果設置為<b>否</b>，則只會通過電子郵件發送消息。";
$pgv_lang["ALLOW_THEME_DROPDOWN"] = "顯示主題更改的主題下拉選擇器";
$pgv_lang["ALLOW_THEME_DROPDOWN_help"] = "~#pgv_lang[ALLOW_THEME_DROPDOWN]#~<br /><br />為用戶提供從菜單中選擇自己主題的選項。<br /><br />即使設置了此選項，當前有效的主題也可能不提供這樣的菜單。為了有效，此選項還需要設置<b>#pgv_lang[ALLOW_USER_THEMES]#</b>選項。";
$pgv_lang["MAX_VIEW_RATE"] = "最大頁面瀏覽率";
$pgv_lang["MAX_VIEW_RATE_help"] = "~#pgv_lang[MAX_VIEW_RATE]#~<br /><br />此選項限制用戶查看頁面的速率。<br /><br />如果超過該速率，PhpGedView會將會話視為黑客嘗試;會話將以適當的消息終止。這兩個值應對來自服務器的帶寬和下載字節數量進行合理限制。可以通過將時間間隔設置為0來關閉此功能。" ;
$pgv_lang["META_AUTHOR"] = "META author標籤";
$pgv_lang["META_AUTHOR_help"] = "~#pgv_lang[META_AUTHOR]#~<br /><br />要放置在HTML頁面標題中的作者元標記中的值。將此字段留空以使用#pgv_lang[CONTACT_EMAIL]#的全名。";
$pgv_lang["META_AUTHOR_descr"] = "將此字段留空以使用#pgv_lang[CONTACT_EMAIL]#的全名。";
$pgv_lang["META_PUBLISHER"] = "META publisher標籤";
$pgv_lang["META_PUBLISHER_help"] = "~#pgv_lang[META_PUBLISHER]#~<br /><br />要放置在HTML頁面標題中的Publisher元標記中的值。將此字段留空以使用#pgv_lang[CONTACT_EMAIL]#的全名。";
$pgv_lang["META_PUBLISHER_descr"] = "將此字段留空以使用#pgv_lang[CONTACT_EMAIL]#的全名。";
$pgv_lang["META_COPYRIGHT"] = "META copyright標籤";
$pgv_lang["META_COPYRIGHT_help"] = "~#pgv_lang[META_COPYRIGHT]#~<br /><br />要放置在HTML頁面標題中的版權元標記中的值。將此字段留空以使用#pgv_lang[CONTACT_EMAIL]#的全名。";
$pgv_lang["META_COPYRIGHT_descr"] = "將此字段留空以使用#pgv_lang[CONTACT_EMAIL]#的全名。";
$pgv_lang["META_DESCRIPTION"] = "META description標籤";
$pgv_lang["META_DESCRIPTION_help"] = "~#pgv_lang[META_DESCRIPTION]#~<br /><br />要放置在HTML頁面標題中的描述元標記中的值。將此字段留空以使用當前活動數據庫的標題。";
$pgv_lang["META_DESCRIPTION_descr"] = "將此字段留空以使用當前活動數據庫的標題。";
$pgv_lang["META_PAGE_TOPIC"] = "META page-topic標籤";
$pgv_lang["META_PAGE_TOPIC_help"] = "~#pgv_lang[META_PAGE_TOPIC]#~<br /><br />要放置在HTML頁面標題中的Page-topic元標記中的值。將此字段留空以使用當前活動數據庫的標題。 />";
$pgv_lang["META_PAGE_TOPIC_descr"] = "將此字段留空以使用當前活動數據庫的標題。";
$pgv_lang["META_AUDIENCE"] = "META audience標籤";
$pgv_lang["META_AUDIENCE_help"] = "~#pgv_lang[META_AUDIENCE]#~<br /><br />要放置在HTML頁面標題中的Audience元標記中的值。";
$pgv_lang["META_PAGE_TYPE"] = "META page-type標籤";
$pgv_lang["META_PAGE_TYPE_help"] = "~#pgv_lang[META_PAGE_TYPE]#~<br /><br />要放置在HTML頁面標題中的Page-type元標記中的值。";
$pgv_lang["META_ROBOTS"] = "META robots標籤";
$pgv_lang["META_ROBOTS_help"] = "~#pgv_lang[META_ROBOTS]#~<br /><br />放置在HTML頁面標題中的Robots元標記中的值。一些機器人或網絡爬蟲忽略了這個值。";
$pgv_lang["META_REVISIT"] = "爬蟲應該多久重訪一次META標籤";
$pgv_lang["META_REVISIT_help"] = "~#pgv_lang[META_REVISIT]#~<br /><br />要放在HTML頁面標題中的Revisit元標記中的值。有些網頁抓取工具會忽略此值。";
$pgv_lang["META_KEYWORDS"] = " META關鍵詞";
$pgv_lang["META_KEYWORDS_help"] = "~#pgv_lang[META_KEYWORDS]#~<br /><br />要放置在HTML頁面標題中的關鍵字元標記中的值。有些搜索引擎會使用關鍵字元標記來幫助索引頁面。<br /><br />歡迎頁面上#pgv_lang[gedcom_stats]#塊中顯示的#pgv_lang[common_surnames]#列表也可以添加到您在此處輸入的任何內容。";
$pgv_lang["META_TITLE"] = "添加到TITLE標籤";
$pgv_lang["META_TITLE_help"] ="~#pgv_lang[META_TITLE]#~<br /><br />此行上的任何內容都將添加到常規頁面標題之後和PhpGedView信用之前的HTML頁面標題中的TITLE標記。";

$pgv_lang["ENABLE_RSS"] = "啟用RSS";
$pgv_lang["ENABLE_RSS_help"] = "~#pgv_lang[ENABLE_RSS]#~<br /><br />此選項可讓您禁用RSS功能。<br /><br />RSS允許用戶監控您的網站以更改索引頁面而無需實際訪問如果有太多用戶使用此功能或者這些用戶設置的刷新頻率太高，RSS會佔用過多的帶寬或服務器容量。<br /><br />這<a href='http://en.wikipedia.org/wiki/RSS' target='_blank' title='維基百科文章'><b>維基百科文章</b></a>包含有關RSS和各種RSS的綜合信息和鏈接格式。<br />";
$pgv_lang["RSS_FORMAT"] = "RSS格式";
$pgv_lang["RSS_FORMAT_help"] = "~#pgv_lang[RSS_FORMAT]#~<br /><br />用作網站默認Feed格式的格式。數字後綴<u>不</u>表示版本:它們標識格式。例如，RSS 2.0並不比RSS 1.0更新，但格式不同。Feed閱讀器應該能夠讀取任何格式。<br /><br />這<a href='http://en.wikipedia.org/wiki/RSS' target='_blank' title='維基百科文章'><b>維基百科文章</b></a>包含有關RSS和各種RSS格式的綜合信息和鏈接。" ;
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE"] = "檢查GEDCOM文件是否可下載";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE_help"] = "~#pgv_lang[SECURITY_CHECK_GEDCOM_DOWNLOADABLE]#~<br /><br />出於安全考慮，GEDCOM文件不應該位於可以直接下載的位置，從而繞過隱私檢查。點擊此鏈接將檢查您的GEDCOM文件可以通過網絡下載。<br /><br />在某些系統上，這項檢查已經花了很長時間甚至不完整。如果是這種情況，那麼你應該嘗試指向你的瀏覽器直接在您的GEDCOM上查看是否可以下載。";
$pgv_lang["gedcom_download_secure"] = "#GEDCOM#無法下載。";

$pgv_lang["welcome_new2"] = "<br /><br />由於您看到此頁面，因此您已成功在服務器上安裝了PhpGedView，並淮備開始根據您的要求進行配置。";
$pgv_lang["welcome_new_help"] = "~#pgv_lang[welcome_new]#~#pgv_lang[welcome_new2]#This Help page will guide you through the configuration process. As you enter different fields, this window will provide you with help information about the field you are in. You may close this window; to open it again click on one of the \"?\" question marks next to the field label.";
$pgv_lang["return_editconfig"] = "您可以隨時通過將瀏覽器指向<i>editconfig.php</i>或單擊<b>PhpGedView管理</b>上<b>配置</b>的鏈接返回此配置頁面。";
$pgv_lang["return_editconfig_gedcom"] = "您可以隨時點擊<b>#pgv_lang[gedcom_adm_head]#<上<b>#pgv_lang[current_gedcoms]#</b>表中的<b>編輯</b>鏈接返回此配置/b>頁面或將瀏覽器指向<i>editconfig_gedcom.php</i>。";
$pgv_lang["save_config"] = "Save configuration";
$pgv_lang["download_gedconf"] = "下載GEDCOM配置。";
$pgv_lang["not_writable"] = "我們檢測到您的配置文件不能被PHP寫入。您可以使用<b>#pgv_lang[download_file]#</b>按鈕將設置保存到可以手動上傳的文件中。";
$pgv_lang["upload_to_index"] = "將文件上傳到索引目錄:";
$pgv_lang["import_sql"] = "在您的索引目錄中找到了SQL文件。由於它們可能來自用戶遷移工具，您可以選擇將信息導入數據庫。您是否希望立即將這些文件導入數據庫？所有現有用戶數據庫中相關的信息（用戶，新聞，收藏夾，塊佈局和消息）將丟失。<br /><br />如果您選擇繼續，PhpGedView將嘗試導入數據。如果這不成功，無論如何，你將被要求建立第一個管理員帳戶。";

$pgv_lang["edit_privacy_title"] = "編輯GEDCOM隱私設置";
$pgv_lang["save_changed_settings"] = "保存更改";
$pgv_lang["add_new_pp_setting"] = "為ID添加隱私新設置";
$pgv_lang["add_new_up_setting"] = "為用戶隱私添加新設置";
$pgv_lang["add_new_gf_setting"] = "為全球事件隱私添加新設置";
$pgv_lang["add_new_pf_setting"] = "按ID添加Facts Privacy的新設置";
$pgv_lang["file_read_error"] = "E R R O R !!!無法讀取隱私文件！";
$pgv_lang["edit_exist_person_privacy_settings"] = "按ID編輯隱私的現有設置";
$pgv_lang["edit_exist_user_privacy_settings"] = "編輯用戶隱私的現有設置";
$pgv_lang["edit_exist_global_facts_settings"] = "編輯Global Fact Privacy的現有設置";
$pgv_lang["edit_exist_person_facts_settings"] = "按ID編輯Facts Privacy的現有設置";
$pgv_lang["general_privacy"] = "一般隱私設置";
$pgv_lang["general_privacy_help"] = "~#pgv_lang[general_privacy]#~<br /><br />您可以在網站上為每個GEDCOM設置不同的隱私設置。在頁面標題下檢查您是否正在編輯正確的GEDCOM。<br /><br />您可以使用#pgv_lang[edit_privacy_title]#頁面上的其他隱私表單覆蓋這些常規設置。<br />#pgv_lang[more_help_advice]#";
$pgv_lang["person_privacy"] = "ID的隱私設置";
$pgv_lang["person_privacy_help"] = "~#pgv_lang[person_privacy]#~<br /><br />這些設置允許管理員覆蓋特定個人，家庭，來源或媒體對象的默認隱私設置。<br /><br />例如假設你有一個孩子在嬰儿期去世。通常是因為孩子去世，它的細節會向公眾用戶顯示。但是，你和你家裡的其他人仍然是私人的。你不想刪除去世記錄。孩子，但你想要隱藏細節並將它們設為私人。如果這個孩子的ID為I100，你應該輸入以下隱私設置:<br />ID:I100<br />顯示:僅顯示給經過身份驗證的用戶<br /><br />這也是另一種方式。如果你想公開你知道去世但沒有去世日期的某人（ID I101）的詳細信息，你可以添加以下內容:<br />ID:I101<br />顯示:向公眾展示";
$pgv_lang["user_privacy"] = "用戶隱私設置";
$pgv_lang["user_privacy_help"] = "~#pgv_lang[user_privacy]#~<br /><br />這些設置使管理員能夠根據用戶名覆蓋GEDCOM中個人的默認隱私設置。假設您不希望用戶名<b> John</b>為了能夠在GEDCOM中看到ID I100的任何細節，你可以這樣配置:<br />用戶名:John<br />ID:I100<br />顯示？:\"隱藏\"<br /><br />指定個人的詳細信息僅對用戶名\"John\"隱藏。<br /><br />顯示I101的詳細信息（由於I101通常會被隱藏還活著）用戶名約翰設置:<br /><br />用戶名:John<br />ID:I101<br />顯示？:顯示<br />";
$pgv_lang["global_facts"] = "全球事件隱私設置";
$pgv_lang["global_facts_help"] = "~#pgv_lang[global_facts]#~<br /><br />這些設置在GEDCOM中為所有人隱藏的全局級別定義事件。這僅適用於BIRT或DEAT等1級事件記錄。將在各個頁面的個人事件和詳細信息選項卡上顯示自己的標題。<br /><ul><li><b>#pgv_lang[name_of_fact]#</b>元素確定應隱藏哪個事件。</li><li><b>#pgv_lang[choice]#</b>元素指定事件本身或相關細節。</li><li><b>#pgv_lang[accessible_by]#</b >元件確定顯示事件的訪問級別。</li></ul><br />此功能旨在隱藏GEDCOM標記所標識的所有活著或去世的事件。默認情況下，SSN標記隱藏給公眾用戶。這是為了防止人們竊取社會安全號碼並對死者進行身份盜竊。這可能與美國有關。<br /><br />如果你想隱瞞所有公共婚姻用戶您可以設置的GEDCOM:<br /><br /><b>#pgv_lang[name_of_fact]#</b>（MARR） - 婚姻<br /><b>#pgv_lang[選擇]#</b>\"#pgv_lang[fact_show]#\"<br /><b>#pgv_lang[accessible_by]#</b>\"#pgv_lang[PRIV_USER]#\"<br /><br /><b>#pgv_lang[name_of_fact]#</b>（MARR） - 婚姻<br /><b>#pgv_lang[選擇]#</b>\"#pgv_lang[fact_details]#\"<br /><b>#pgv_lang[accessible_by]#</b>\"#pgv_lang[PRIV_USER]#\"<br /><br />這些設置會隱藏婚姻和相關詳細信息給非管理員。<br /><br />所有其他設置，在<b>#pgv_lang[edit_exist_global_facts_settings]#</b>中，您甚至可以隱藏管理員用戶的事件。不必要的事件被完全壓制。";
$pgv_lang["person_facts"] = "事件隱私設置ID";
$pgv_lang["person_facts_help"] = "~#pgv_lang[person_facts]#~<br /><br />這些設置定義了為特定人員，家庭或來源隱藏的事件以及隱藏它們的級別。這僅適用於1級事件記錄例如BIRT或DEAT，它們將在個人，家庭或來源的相關詳細信息頁面上以自己的標題出現。<br /><br />第一個元素是人，家庭或來源的ID。第二個元素是事件。<b>#pgv_lang[choice]#</b>元素指定事件本身或相關細節。<b>#pgv_lang[accessible_by]#</b>元素確定在什麼訪問級別事件顯示。並非列表中顯示的所有事件都適用於所有類型的ID。例如，出生和去世事件與源記錄無關。<br /><br />\person_facts數組的工作方式與\_global_facts數組除了你還指定了你要隱藏事件的人的GEDCOM ID。例如，你可以隱藏特定人的婚姻記錄。 />";
$pgv_lang["accessible_by"] = "顯示到？";
$pgv_lang["hide"] = "隱藏";
$pgv_lang["show_question"] = "顯示？";
$pgv_lang["user_name"] = "用戶名";
$pgv_lang["name_of_fact"] = "事件名稱";
$pgv_lang["choice"] = "選擇";
$pgv_lang["fact_show"] = "顯示事件";
$pgv_lang["fact_details"] = "顯示事件細節";
$pgv_lang["privacy_header"] = "編輯隱私設置";
$pgv_lang["unable_to_find_privacy_indi"] = "無法找到有id的人";
$pgv_lang["save_and_import"] = "保存此GEDCOM配置後，您需要通過單擊<b>導入GEDCOM</b>按鈕或轉到<b>管理員- >管理GEDCOM->導入</b>導入GEDCOM";
$pgv_lang["help_info"] = "您可以通過點擊每個單元格標籤旁邊的紅色\"？ \"來獲取每個條目的幫助。";
$pgv_lang["SHOW_LIVING_NAMES_help"] = "~#pgv_lang[SHOW_LIVING_NAMES]#~<br /><br />在世百姓的名字應該向公眾展示嗎？";
$pgv_lang["SHOW_RESEARCH_ASSISTANT"] = "展示研究助理";
$pgv_lang["SHOW_RESEARCH_ASSISTANT_help"] = "~#pgv_lang[SHOW_RESEARCH_ASSISTANT]#~<br /><br />如果安裝了Research Assistant模塊，哪種類型的用戶可以查看？";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"] = "使用關係隱私";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"] = "~#pgv_lang[USE_RELATIONSHIP_PRIVACY]#~<br /><br /><b>否</b>表示經過身份驗證的用戶可以查看所有在世人員的詳細信息。<b>是</b>表示用戶可以只看到與他們有關的在世人員的私人信息。<br /><br />此選項為有權訪問此系譜數據庫的所有用戶設置默認值。管理員可以通過編輯用戶的權限為個別用戶覆蓋此選項帳戶詳情。";
$pgv_lang["MAX_RELATION_PATH_LENGTH"] = "最大關係路徑長度";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"] = "~#pgv_lang[MAX_RELATION_PATH_LENGTH]#~<br /><br />如果啟用了<i>#pgv_lang[USE_RELATIONSHIP_PRIVACY]#</i>選項，登錄用戶將只能在此數量的關係步驟中查看或編輯個人。<br /><br />此選項為有權訪問此系譜數據庫的所有用戶設置默認值。管理員可以通過編輯用戶的帳戶詳細信息為單個用戶覆蓋此選項。";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"] = "檢查婚姻關係";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"] = "~#pgv_lang[CHECK_MARRIAGE_RELATIONS]#~<br /><br />檢查與婚姻有關的關係。";
$pgv_lang["SHOW_DEAD_PEOPLE"] = "顯示去世的人";
$pgv_lang["SHOW_DEAD_PEOPLE_help"] = "~#pgv_lang[SHOW_DEAD_PEOPLE]#~<br /><br />為所有死去的人設置隱私訪問級別。";
$pgv_lang["select_privacyfile_button"] = "選擇隱私文件";
$pgv_lang["PRIVACY_BY_YEAR"] = "按在世年齡限制隱私";
$pgv_lang["PRIVACY_BY_YEAR_help"] = "~#pgv_lang[PRIVACY_BY_YEAR]#~<br /><br /><b>#pgv_lang[PRIVACY_BY_YEAR]#</b>設置將隱藏人們的詳細信息，具體取決於他們在特定事件中的年齡，無論他們是死還是活。<br /><br />將此設置與<b>#pgv_lang[MAX_ALIVE_AGE]#</b> 設置一起使用。 例如，如果您將年齡設置為100並將此選項設置為<b>是</b>，那麼100年內出生的所有活著或死亡的人都將設置為私人。結婚小於85年的人和不到75年前死亡的人也會被標記為私人注意請注意，使用此選項會減少數據展現。";

$pgv_lang["lang_edit_help"] = "~#pgv_lang[translator_tools]#~<br /><br />此頁面旨在供翻譯人員使用。您可以翻譯，比較和導出語言文件。還有一個選項可以幫助翻譯人員確定起源由PhpGedView輸出的文本。<br /><br />您可以使用以下選項和實用程序:";
$pgv_lang["bom_check"] = "字節順序標記（BOM）檢查";
$pgv_lang["bom_check_help"] = "~#pgv_lang[bom_check]#~<br /><br />#pgv_lang[bom_check_desc]#";
$pgv_lang["bom_check_desc"] = "此檢查將分析BOM的所有語言文件（字節順序標記）。如果找到，它將從受影響的文件中刪除BOM。這些特殊代碼可能會導致PhpGedView的某些部分出現故障。";
$pgv_lang["lang_debug"] = "幫助文本調試選項";
$pgv_lang["lang_debug_help"] = "~#pgv_lang[lang_debug]#~<br /><br />#pgv_lang[lang_debug_desc]#";
$pgv_lang["lang_debug_desc"] = "當您啟用此選項時，幫助文本中使用的語言變量的名稱將打印在幫助文本彈出窗口中。這將有助於翻譯人員在需要調整文本時確定變量名稱。<br /><br />設置僅在您當前的PhpGedView會話期間有效。";
$pgv_lang["lang_debug_use"] = "使用幫助文本調試選項";
$pgv_lang["bom_not_found"] = "沒有找到BOM。";
$pgv_lang["bom_found"] = "已找到BOM";
$pgv_lang["edit_lang_utility_desc"] = "您可以使用此實用程序通過使用英語文本的內容來編輯語言文件的內容。<br /><br />您將看到原始英語語言文件的內容和相同文件類型的內容（您的所選語言中有9個）。您單擊英文版本下方顯示的消息文本。這將打開一個新窗口，您可以在其中修改文本。您可以保存更改或放棄更改。";
$pgv_lang["edit_lang_utility_warning"] = "小心！<br /><br />如果您使用<b>#pgv_lang[close_window_without_refresh]#</b>按鈕，在您重新加載手冊頁之前，屏幕上可能看不到您的更改。可能是如果您添加一條尚未出現在語言文件中的消息，或者您只是編輯之前直接編輯的消息，您的語言文件可能會被銷毀。<br /><br />如果您真的不知道你是什麼我正在做，請不要使用<b>#pgv_lang[close_window_without_refresh]#</b>按鈕。";
$pgv_lang["language_to_edit_help"] = "~#pgv_lang[language_to_edit]#~<br /><br />在此列錶框中，您可以選擇要編輯其消息的語言。";
$pgv_lang["file_to_edit_help"] = "~#pgv_lang[file_to_edit]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["lang_file_descriptions"] = "PhpGedView已經實現了對許多不同語言的支持。這是通過將文件中用戶可見的所有文本與主程序完全分開來實現的。每種支持的語言都有一組八個文件，各種文本已經存在根據功能分成這些文件中的一個。<b>並非所有語言文件都必須存在。</b>當給定文本尚未翻譯時，PhpGedView將始終使用英文版本。<br /><br />每種語言集中的文件是:<br /><ul><li><b><i>admin.xx.php</i></b>&nbsp;&nbsp;此文件包含術語和在管理PhpGedView和家譜數據庫期間使用的常用表達。<br /><br /></li><li><b><i>configure_help.xx.php</i></b>&nbsp;&nbsp;此文件包含在配置PhpGedView期間使用的幫助文本。普通用戶無法查看幫助文本。<br /><br /></li><li><b><i>countries.xx.php</i></b>&nbsp;&nbsp;這是一個列表國名，取自聯合國經濟和社會事務部統計司網站。這是相關的<a href=\"http://unsta ts.un.org/unsd/methods/m49/m49alpha.htm\" target=\"_blank\"><b>鏈接</b></a>到英文名單。該列表有英文或法文版本。<br /><br /></li><li><b><i>editor.xx.php</i></b>&nbsp;&nbsp;此文件包含在譜係數據庫中編輯條目時使用的術語和通用表達。<br /><br /></li><li><b><i>facts.xx.php</i></b >&nbsp;&nbsp;此文件包含GEDCOM 5.5.1標淮中找到的GEDCOM事件代碼的文本等價物。它還包含標淮中未找到但由各種家譜程序使用的其他事件代碼。<br /><br />的英文副本<a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_ blank\"><b>GEDCOM 5.5.1標淮</b></a>可以PDF格式下載（可移植文檔格式）。<br /><br /></li><li><b><i>faqlist.xx.php</i></b>&nbsp;&nbsp;此文件是<b>f</b>的一組<b>a</b> sked<b>q</b>由PhpGedView開發團隊收集的提示。每個FAQ在此文件中都有兩個條目。一個條目是FAQ標題（通常是問題），另一個是FAQ主體（通常是答案）。經常更新的<b><i>faqlist.xx.php</i></b>文件的替換可以從PhpGedView主站點下載。<br /><br />管理員可以使用此文件中的常見問題解答，用於構建特定於其網站的常見問題列表。<br /><br /></li><li><b><i>help_text.xx.php</i></b >&nbsp;&nbsp;此文件包含普通用戶的幫助文本。此文件中的某些幫助主題可滿足管理員的需求，並且對沒有管理員權限的用戶隱藏。<br /><br /></li><li><b><i>lang.xx.php</i></b>&nbsp;&nbsp;此文件中包含許多術語和常用表達。</li></ul><br />PhpGedView還支持可選的第九語言文件，<b><i>extra.xx.php</i>的</b>。此文件始終在所有其他文件之後加載，並提供一種方法，使站點管理員可以覆蓋或更改所選語言的任何標淮文本。它還可用於為系譜數據庫提供根據當前活動語言而有所不同的標題。<br /><br />此附加文件的內容完全取決於站點管理員;此文件將<b>永遠</b>與任何版本的PhpGedView一起分發。管理員永遠不應該更改標淮語言文件;所有本地更改都應集中在此可選文件中。";
$pgv_lang["language_to_export_help"] = "~#pgv_lang[language_to_export]#~<br /><br />從這個列錶框中，您可以選擇要導出其消息的語言。<br /><br />該例程目前只導出該文件的內容。<i>configure_help.xx.php</i>，<i>help_text.xx.php</i>和<i>lang.xx.php</i>文件。輸出是一個HTML文件，你可以從您的瀏覽器打印。";
$pgv_lang["export_lang_utility_help"] = "~#pgv_lang[export_lang_utility]#~<br /><br />#pgv_lang[export_lang_utility_desc]#";
$pgv_lang["export_lang_utility_desc"] = "您可以為管理員創建文檔。<br /><br />此實用程序將以所選語言生成配置幫助文件的HTML版本。您可以使用瀏覽器查看此文件，該文件已格式化以進行打印。";
$pgv_lang["export_ok"] = "出口幫助信息";
$pgv_lang["compare_lang_utility_help"] = "~#pgv_lang[compare_lang_utility]#~<br /><br />#pgv_lang[compare_lang_utility_desc]#";
$pgv_lang["compare_lang_utility_desc"] = "這個實用程序將比較兩組語言文件，以生成它們之間的加法和減法列表。<br /><br />您還應檢查各種CHANGELOG文件以查看英文版本的更改。英文文件應該是用作所有其他產品的參考。";
$pgv_lang["new_language_help"] = "~#pgv_lang[new_language]#~<br /><br />從此列錶框中，您可以選擇要與其他語言進行比較的語言。<br /><br />所有更改和添加首先將語言文件轉換為<b>英語</b>語言文件，因此您通常會選擇英語作為要比較的語言之一。";
$pgv_lang["old_language"] = "第二個語言";
$pgv_lang["old_language_help"] = "~#pgv_lang[old_language]#~<br /><br />從此列錶框中，您可以選擇要與<b>源</b>列錶框中選擇的語言進行比較的語言。選擇後，單擊<b>比較</b>按鈕，獲取兩種語言的所有四個文件中所有添加和刪除的列表。<br /><br />刷新你的記憶:<br /><b>添加</b>意味著:<u>在</u>源文件中，但<u>不是</u>在輔助文件中。<br /><br /><b>減法</b>表示:源文件中<u>不</u>，但輔助文件中。這可能在給定時發生消息不再使用，因此已從英文文件中刪除。您可以安全地從輔助語言文件中刪除相應的消息。";
$pgv_lang["additions"] = "加法";
$pgv_lang["no_additions"] = "沒有補充";
$pgv_lang["subtractions"] = "減量";
$pgv_lang["no_subtractions"] = "沒有減法";
$pgv_lang["config_lang_utility_help"] = "~#pgv_lang[config_lang_utility]#~<br /><br />此頁面用於控制用戶可以使用的語言選項。例如，您可以進行設置，以便只有德語和法語可用。例如，如果您無法與匈牙利語的用戶通信，則可能很有用。<br /><br />您還可以使用此頁面來改變依賴於所選語言的PhpGedView的某些方面。例如，這裡是告訴PhpGedView如何格式化日期和時間字段的地方。<br /><br />活動和灰顯的語言因為正在使用而無法禁用。請查看下表以查看語言的使用位置。當GEDCOM或用戶不再使用某種語言時，您可以將其禁用。<br /><br />所有更改都將記錄在名為<b>lang_settings.php</b>的新文件中>在<b>#INDEX_DIRECTORY#</b>目錄中創建。您將對此新文件進行所有進一步更改，PhpGedView將僅使用<u>此</u>文件。您可以通过删除此文件来恢复原始默认语言设置。<br /><br />如果您必須報告語言設置題，請告訴PhpGedView支持團隊是否存在此新文件。";
$pgv_lang["active_help"] = "~#pgv_lang[active]#~<br /><br />如果啟用了選項<b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b>，則允許用戶選擇此語言。 ";
$pgv_lang["lang_back"] = "返回主菜單編輯和配置語言文件";
$pgv_lang["lang_back_admin"] = "返回管理員菜單";
$pgv_lang["lang_back_manage_gedcoms"] = "返回GEDCOM管理菜單";
$pgv_lang["lang_name_arabic"] = "阿拉伯";
$pgv_lang["lang_name_catalan"] = "加泰羅尼亞語（瓦倫西亞語）";
$pgv_lang["lang_name_croatian"] = "克羅地亞";
$pgv_lang["lang_name_czech"] = "捷";
$pgv_lang["lang_name_danish"] = "丹麥";
$pgv_lang["lang_name_dutch"] = "荷蘭";
$pgv_lang["lang_name_english (uk)"] = "英語（英國）";
$pgv_lang["lang_name_english (us)"] = "英語（美國）";
$pgv_lang["lang_name_estonian"] = "愛沙尼亞語";
$pgv_lang["lang_name_finnish"] = "芬蘭";
$pgv_lang["lang_name_french"] = "法國";
$pgv_lang["lang_name_german"] = "德語";
$pgv_lang["lang_name_greek"] = "希臘語";
$pgv_lang["lang_name_hebrew"] = "希伯來文";
$pgv_lang["lang_name_hungarian"] = "匈牙利";
$pgv_lang["lang_name_indonesian"] = "印度尼西亞";
$pgv_lang["lang_name_italian"] = "意大利";
$pgv_lang["lang_name_lithuanian"] = "立陶宛";
$pgv_lang["lang_name_norwegian"] = "挪威";
$pgv_lang["lang_name_polish"] = "拋光";
$pgv_lang["lang_name_portuguese"] = "葡萄牙語";
$pgv_lang["lang_name_romanian"] = "羅馬尼亞";
$pgv_lang["lang_name_russian"] = "俄語";
$pgv_lang["lang_name_serbian-la"] = "塞爾維亞語（拉丁字母）";
$pgv_lang["lang_name_slovak"] = "斯洛伐克";
$pgv_lang["lang_name_slovenian"] = "斯洛文尼亞";
$pgv_lang["lang_name_spanish"] = "西班牙";
$pgv_lang["lang_name_spanish-ar"] = "西班牙語（拉丁美洲）";
$pgv_lang["lang_name_swedish"] = "瑞典";
$pgv_lang["lang_name_turkish"] = "土耳其";
$pgv_lang["lang_name_vietnamese"] = "越南";
$pgv_lang["original_lang_name"] = "#D_LANGNAME#中的語言原始名稱";
$pgv_lang["original_lang_name_help"] = "~語言的原始名稱~<br /><br />這種語言如何用這種語言命名？<br /><br />英語稱自己<b>英語</b>;德語稱自己<b>Deutsch</b>;荷蘭人稱自己為<b>Nederlands</b>;捷克語稱自己<b>Ceština</b>等。";
$pgv_lang["lang_shortcut"] = "語言文件的縮寫";
$pgv_lang["lang_shortcut_help"] = "~#pgv_lang[lang_shortcut]#~<br /><br />此代碼定義了語言名稱的縮寫。這個縮寫形成了PhpGedView使用的每個語言文件名稱的一部分。例如，使用的縮寫對於法語是<b>fr</b>，因此法語的文件名是<i>configure_help.<b>fr</b>.php</i>，<i>countries<b>fr</b>.php</i>，<i>facts.<b>fr</b>.php</i>，<i>help_text.<b>fr</b>.php</i>，和<i>lang.<b>fr</b>.php</i>";
$pgv_lang["lang_langcode_help"] = "~#pgv_lang[lang_langcode]#~<br /><br />這些代碼允許PhpGedView檢測正在使用的瀏覽器的首選語言設置.PhpGedView通過匹配瀏覽器的語言代碼來確定瀏覽器實際請求的語言個人列表條目必須用分號分隔。";
$pgv_lang["lang_filenames_help"] = "~#pgv_lang[lang_filenames]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["flagsfile_help"] = "~#pgv_lang[flagsfile]#~<br /><br />所選語言的國旗圖像文件的名稱。<br /><br />許多國家的圖像可從< a href=\"http://w3f.com/gifs/index.html\"><b>WWWeb工廠</b></a>網站。<br /><br />當您找到喜歡的國旗圖片時，請點擊- 單擊它並將圖像保存在臨時文件夾中。接下來，使用合適的圖像編輯器打開保存的圖像（建議Windows系統使用IrfanView），將其大小縮小50x32像素，這是PhpGedView中使用的正常大小，然後將其作為GIF文件保存到<i><b>images/flags</b></i>文件夾。<br /><br />雖然您可以使用任何您想要的名稱，但您應該選擇一致的名稱使用兩個字母的語言快捷方式。例如，克羅地亞語由兩個字母的代碼<i><b>hr</b></i>表示，因此克羅地亞國旗通常被命名為<i><b>hr.gif</b></i>。";
$pgv_lang["text_direction_help"] = "~#pgv_lang[text_direction]#~<br /><br />標識用於以所選語言書寫文本的方向。大多數語言是從左到右書寫的。阿拉伯語和希伯來語是用相反的方向（從右到左）。";
$pgv_lang["date_format_help"] = "~#pgv_lang[date_format]#~<br /><br />此字段定義PhpGedView在顯示數據庫日期時使用的日期格式。您可以使用<b>標淮</b >或<b>高級</b>格式。<ul><li><b>標淮</b><br />以下代碼用於表示日期的不同元素。請注意<b>D</b>和<b>M</b>在<b>高級</b>格式中有不同的含義。<p style=\"padding-left:25px\"><b>D</b>&nbsp;&nbsp;月中的某一天，沒有前導零;即1到31<br /><b>M</b>&nbsp;月份名稱;即1月，2月等。<br /><b>Y</b>&nbsp;&nbsp;全年，例如1999或44B.C.<br /><b>R</b>&nbsp;&nbsp;日曆轉換。請參閱主題<b>日曆轉換</b>以下是對此代碼的描述。</p>這些代碼可以按任何順序組合，還有空格和標點符號。例如，假設您的GEDCOM包含日期20&nbsp;AUG&nbsp;1965。<p style =\"padding-left:25px\"><b>英文</b>用戶可以將格式設置為<b>D&nbsp;M&nbsp;Y</b><b>20&nbsp;8月&nbsp;1965</b>。<br /><b>美國</b>用戶可以將格設置為<b>M&nbsp;D，&nbsp;Y</b>得到<b>8月&nbsp;20，&nbsp;1965</b><br />A<b>德國</b>用戶可以將格式設置為<b>D. &nbsp;M&nbsp;Y</b>獲取<b>20.&nbsp;8月&nbsp;1965</b><br /><b>匈牙利</b>用戶可以將格式設置為<b>Y.&nbsp ;M</b><b>1965年。&nbsp;augusztus&nbsp;20.</b><br />提供更複雜的格式選項。如果您的日期格式包含<b>D</b>，<b>M</b>，<b>Y</b>或<b>R</b>以外的字母，則會假設使用<b>高級</b>格式。<br /><br />以下代碼用於表示日期的不同元素。請注意，<b>D</b>和<b>M</b>在<b>標淮</b>格式中具有不同的含義。 <p style =\"padding-left:25px\"><b> d</b>&nbsp;&nbsp;該月的某天，前導零;即01至31<br /><b>j </b >&nbsp;&nbsp;該月的某一天，沒有前導零;即1至31<br /><b>S</b>&nbsp;&nbsp;日期編號的序數後綴;例如，<b>4月7日</b>中的字母<b></b>。<br /><b>l</b>（小寫字母\"L\"）&nbsp;&nbsp;一周中的天;即星期一，星期二等。<br /><b>D</b>&nbsp;&nbsp;縮短的星期幾;即M，Tu，W，Th，F，Sa，Su<br /><b>N</b>&nbsp;&nbsp ;ISO天數;即0至6<br /><b>w</b>&nbsp;&nbsp;數字日數;即1至7<br /><b>z</b>&nbsp;&nbsp;一年中的某一天;即1至365<br /><b>F</b>&nbsp;月份名稱;即1月，2月等。<br /><b>M</b>&nbsp;&nbsp;縮寫月份，即1月，2月等。<br /><b>m</b>&nbsp;&nbsp;月數字，前導零;即01至12<br /><b>n</b>&nbsp;&nbsp;月號，不帶前導零;即1至12<br /><b>Y</b>&nbsp;&nbsp;全年，例如1999或44B.C.<br /><b>y</b>&nbsp;&nbsp;縮寫年份。一些日曆允許多年縮寫。對於猶太歷，這是沒有數千人的年份。對於公曆，這與全年相同。<br /><b>R</b>&nbsp;&nbsp;日曆轉換。請參閱下面的主題<b>日曆轉換</b>以獲取此代碼的說明。<br /><b>@&nbsp;A&nbsp;O&nbsp;E</b>&nbsp;&nbsp;內部GEDCOM格式</p><p style=\"padding-left:50px\"><b>@ </b>&nbsp;&nbsp;日曆代碼，例如@#DGREGORIAN @，@#DHEBREW @等<br /><b>A</b>&nbsp;&nbsp;day，即01到31<br /><b>O</b>&nbsp;&nbsp;一個月，例如1月，2月，3月等。<br /><b>E</b>&nbsp;&nbsp;年，例如1776年，1867年，2007年等。<br /><br />要查看未轉換的日期，請使用<b>A&nbsp;O&nbsp;E</b>或<b>@&nbsp;A&nbsp;O&nbsp;E </b ></p><b>一些例子</b>，使用日期08&nbsp;SEP&nbsp;1965:<p style=\"padding-left:25px\"><b>d&nbsp;M&nbsp;Y</b> = 08&nbsp;9月&nbsp; 1965<br /><b>D&nbsp;j&nbsp;F&nbsp;Y</b> = W&nbsp;8月&nbsp;9月&nbsp;1965<br /><b>j&nbsp;M&nbsp;y</b> = 8&nbsp ; 9月&nbsp;65<br /><b>l&nbsp; - &nbsp;d&nbsp; - &nbsp;F&nbsp; - &nbsp;Y</b> =星期三&nbsp;&nbsp;08&nbsp; - &nbsp;9月&nbsp; - &nbsp; 1965<br /><b>y/m/d</b> = 1965/09/08 </p><br /></li>#pgv_lang[date_format_help2]#";
$pgv_lang["date_format_help2"] = "<li><b>日曆轉換</b><br /><b>R</b>代碼的行為有點不尋常。當此代碼以日期格式顯示時，正常日期將顯示為第二次，但在不同的日曆系統中。此備用日曆日期的元素將遵循與格式規範的主要部分相同的規則，除了<b>R</b>格式代碼的輸出是括在括號中，以區別於常規日期。<b>法國革命</b>日曆下的例子將使這一點更加清晰。<br /><br />用於<b的備用日曆>R</b>代碼根據當前頁面語言確定。當頁面語言為希伯來語時，將使用<b>猶太</b>日曆。當頁面語言為阿拉伯語時，<b>Hijri</b>將使用日曆。對於所有其他頁面語言，使用<b>法國革命</b>日曆。<br /><br />此代碼的操作類似於日曆格式的選擇ÿ您可以在GEDCOM配置頁面上進行操作。這兩種方法的區別在於，語言配置級別定義的<b>R</b>代碼僅適用於所選語言，但適用於站點上的所有GEDCOM。在GEDCOM配置級別設置的日曆選項適用於所有語言，但僅適用於已設置該選項的GEDCOM。<br /><ul><li><b>法國革命</b>日曆&nbsp;&nbsp;&nbsp;這個日曆也被稱為<b>法國共和黨人</b>日曆。<br /><br />除了1871年5月的一個非常短暫的時期外，這個日曆系統僅在法國使用，僅在22&nbsp;SEP&nbsp;1792年和31&nbsp;DEC&nbsp;1805。因此，法國革命日曆格式僅適用於日期在該範圍內的情況。<br /><br />假設頁面語言為英語，兩種示例日期格式將說明<b>R的行為</b>代碼:<br /><b>Ymd&nbsp;R</b>可以產生<b>1805.04.26&nbsp;（XIII.08.06）</b>或<b>1806.01.01</b> ;&nbsp;<b>j&nbsp;F&nbsp;Y&nbsp;R</b>可以生成<b>13&nbsp;OCT&nbsp;1797&nbsp;(22&nbsp;Vendémiaire&nbsp;VI）</b>或<b>1&nbsp;JAN&nbsp;1806</b>。</li></ul><br /></li><li><b>語言備選方案</b>&nbsp;&nbsp;&nbsp;高級代碼<b>D</b>的縮寫文本和<b>M</b>在文件<i>languages/lang.xx.php</i>使用类似的声明<code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"蘇\";</代碼>&nbsp;&nbsp;和&nbsp;&nbsp;<code>\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"April\";</code><br /><br />这些可以通过使用Wiki和ReadMe文本中描述的<i>languages/extra.xx.php</i>文件进行语言调整来更改，例如：<br /><code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"Sun\" ;<br />\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"Apr\";</code><br /><br /><br /></li><li> <b>本地化</b>&nbsp;&nbsp;&nbsp;針對多種語言存在特殊格式規則，尤其是根據日期的措辭來截斷月份結尾。這些特殊規則在各種<i>includes/extras/functions.xx.php</i>文件中實現。</li></ul>";
$pgv_lang["time_format_help"] = "~#pgv_lang[time_format]#~<br /><br />這個字段定義了PhpGedView使用的時間格式。<br /><br />你可以使用的符號是:<br /><b>a</b> - 小寫Ante meridiem和Post meridiem;即<b>am</b>或<b>pm</b><br /><b>A</b> - 大寫Ante meridiem和Post meridiem ;即<b>AM</b>或<b>PM</b><br /><b>B</b> - Swatch Internet時間;即<b>000</b>至<b>999</b><br /><b>c</b> - ISO 8601日期（在PHP 5中添加）;例如<b>2004-02-12T15:19:21+00:00</b><br /><b>d</b> - 月中的某一天，2位數，前導零;​​即<b>01</b>至<b>31</b><br /><b>D</b> - 天，文字，三個字母;例如<b>星期一</b><br /><b>F</b> - 月，文字，長;例如<b>1月</b><br /><b>g</b> - 小時，12小時格式，沒有前導零;即<b>1</b>到<b>12</b><br /><b>G</b > - 小時，24小時格式，無前導零;即<b>0</b>到<b>23</b><br /><b>h</b> - 小時，12小時格式，前導零;​​即<b>01</b>至<b>12</b><br /><b>H</b> - 小時，24小時格式，前導零;​​即<b>00</b>通過<b>23</b><br /><b>i</b> - 分鐘，領先零;即<b>00</b>至<b>59</b><br /><b>I</b>（大寫\"i\"） - 夏令時指標;如果夏令時<b>1</b>，否則<b>0</b>。<br /><b>j</b> -月中的某天，沒有前導零;即<b>1</b>至<b>31</b><br /><b>l</b>（小寫\"L\"） - 星期幾，文字，長;例如<b>星期五</b><br /><b>L</b> - 閏年指標;<b>1</b>如果是閏年，<b>0</b >否則。<br /><b>m</b> - 月，數字，前導零;即<b>01</b>至<b>12</b><br /><b>M</b> - 月份，文字，3個字母;例如<b>Jan</b><br /><b>n</b> - 月，數字，沒有前導零;即<b>1</b>至<b>12</b><br /><b>O</b>（資本\"o\"） - 本地和格林威治時間（GMT）之間的差異，以小時為單位;例如<b> +0200</b><br /><b>r</b> - RFC 2822格式化日期;例如<b>星期四，&nbsp;21&nbsp;Dec&nbsp;2000nbsp;16:01:07&nbsp;+0200</b><br /><b>s</b> - 秒，領先零;即<b>00</b>至<b>59</b><br /><b>S</b> - 每月的後綴，僅限英文，2個字符;即<b>st</b>，<b>nd</b>，<b>rd</b>或<b>th</b>。適用於<b>j</b><br /><b>t</b> - 給定月份的天數;即<b>28</b>至<b>31</b><br /><b>T</b> - 本機的時區設定;例如<b>CEST</b>，<b>EST</b>，<b>MDT</b><br /><b>U</b> - 自Unix時代開始以來的秒數（1月&nbsp;1&nbsp;1970&nbsp;00:00:00 GMT）<br /><b>w</b> - 星期幾，數字;即<b>0</b>（星期日）至<b>6</b>（星期六）<br /><b>W</b> - ISO-8601星期一年，星期開始星期一;例如<b>42</b>（全年第42週）<br /><b>Y</b> - 年，4位數;例如<b>1999</b><br /><b>y</b> - 年，2位數;例如<b>99</b><br /><b>z</b> - 一年中的某一天，數字，沒有前導零;即<b>0</b>（1月1日）至<b>364</b>（12月31日不是閏年）或<b>365</b>（閏年12月31日）</><b>Z</b> - 以秒為單位的時區偏移量。格林威治以西時區的偏移總是負的，對於格林威治以東的時區偏移總是正的。即<b>-43200</b>至<b>43200</b><br /><br />您可以更改這些符號的順序，並可以為該格式添加分隔符。<br /><例如，在德語中，此字段通常包含<b>H:i:s</b>以生成<b>09:01:25</b>等顯示。英語通常將時間格式定義為<b>g:i:sa</b>以生成<b>上午9:01:25am</b>的顯示。<br /><br />24小時系統，午夜是00:00。在12小時制中，午夜是12:00am，中午是12:00pm。";
$pgv_lang["week_start_help"] = "~#pgv_lang[week_start]#~<br /><br />用這種語言開始新一周的星期幾。大多數語言在星期日開始，但有些語言從星期一或其他日子開始。 ";
$pgv_lang["name_reverse_help"] = "~#pgv_lang[name_reverse]#~<br /><br />在某些語言中，應首先顯示姓氏，而不是默認顯示姓氏。啟用此選項將首先顯示姓氏。匈牙利語，中文和日語通常首先給出姓氏（姓氏）的例子。";
$pgv_lang["alphabet_upper"] = "字母表大寫";
$pgv_lang["alphabet_upper_help"] = "~#pgv_lang[alphabet_upper]#~<br /><br />這種語言的大寫字母。這個字母用於排序名稱列表。";
$pgv_lang["alphabet_lower"] = "字母小寫";
$pgv_lang["alphabet_lower_help"] = "~#pgv_lang[alphabet_lower]#~<br /><br />這種語言的小寫字母。這個字母用於排序名稱列表。";
$pgv_lang["multi_letter_alphabet_help"] = "~#pgv_lang[multi_letter_alphabet]#~<br /><br />在對該語言的名稱和標題列表進行排序時，將被視為單個不同字母的多字母組合。<br /><br />有些語言，例如匈牙利語和斯洛伐克語，認為某些字母組合本身就是不同的字母。指定這些字母組合的順序決定了它們在排序過程中插入正常字母表的順序。這很重要當多個多字母組合具有相同的第一個字母時。除<b>ch</b>外，這些字母組合將根據其首字母插入正常字母。<b>ch</b>始終插入<b>h</b>。";
$pgv_lang["multi_letter_equiv"] = "多字母等價物";
$pgv_lang["multi_letter_equiv_help"] = "~#pgv_lang[multi_letter_equiv]#~<br /><br />在某些語言中，生成名稱列表時，多個字母通常被視為等同於一個字母。<br /><br />例如，荷蘭語，以IJ開頭的名稱與以Y開頭的名稱一起列出。在挪威語中，以AA開頭的名稱與&Aring;一起列出。在某些語言中，有些字母可以寫成一個或兩個字符。例如，斯洛伐克語，兩個字符D和\xC5\xBE可以寫成單個字符\xC7\x85。通過在此指定等價物，您可以允許以這些字母開頭的名稱在各個列表頁面上組合在一起。<br /><br您應該指定以逗號分隔的等效列表。要支持不識別UTF-8編碼的數據庫，您應該同時指定大寫和小寫等效。此示例演示了要使用的格式。<br /><br />AA=&Aring;,aa=&aring;";
$pgv_lang["dictionary_sort_help"] = "~#pgv_lang[dictionary_sort]#~<br /><br />此選項控制在排序名稱和標題列表時如何處理帶變音符號的字符。<br /><br />設置為<b>#時pgv_lang[yes]#</b>，所有帶變音符號的字符都被視為沒有任何標記。只有在考慮的兩個單詞相同時才會考慮變音符號。設置為<b>#pgv_lang[no]#</b>，無論是否存在變音符號，所有字母都是不同的。";
$pgv_lang["collat​​ion"] = "數據庫整理順序";
$pgv_lang["collat​​ion_help"] = "~#pgv_lang[collat​​​​ion]#~<br /><br />如果您使用的是數據庫的內置排序規則，則此選項指定要用於此語言的排序規則序列。您應該確保數據庫支持所有您打算使用的整理順序。<br /><br />數據庫整理的使用在站點配置設置中進行控制。";
$pgv_lang["lang_config_write_error"] = "將語言設置寫入文件<b>lang_settings.php</b>時出錯。請檢查權限，然後重試。";
$pgv_lang["translation_forum"] = "PhpGedView Translations forum on SourceForge";
$pgv_lang["translation_forum_help"] = "~#pgv_lang[translation_forum]#~<br /><br />#pgv_lang[translation_forum_desc]#<br />";
$pgv_lang["translation_forum_desc"] = "這個<a href=\"http://sourceforge.net/forum/forum.php?forum_id=294245\" target=\"_blank\"><b>鏈接</b ></a>開啟了一個新的瀏覽器窗口。您將被重定向到PhpGedView的翻譯論壇，在那裡您可以討論翻譯主題。";
$pgv_lang["lang_set_file_read_error"] = "E R R O R !!!無法讀取<b>lang_settings.php</b>！";
$pgv_lang["add_new_language_help"] = "~#pgv_lang[add_new_language]#~<br /><br />#pgv_lang[add_new_language_desc]#";
$pgv_lang["add_new_language_desc"] = "此例程允許您向PhpGedView添加新的，以前不可用且完全不受支持的語言。<br /><br />您可以設置新語言的標淮設置。這些設置包括語言檢測代碼，語言方向，啟動這週語言，時間設置，字母表等等。<br /><br />選擇語言並單擊<b>#pgv_lang[add_new_lang_button]#<後，您將獲得有關PhpGedView支持的語言設置的更多幫助。 /b>按鈕。<br /><br />語言的配置頁面提供了更多幫助。";
$pgv_lang["hide_translated_help"] = "~#pgv_lang[hide_translated]#~<br /><br />如果設置為<b>是</b>，您將只看到所選語言文件中尚未翻譯的消息。這表示新消息<u>不</u>出現在目標語言文件中。<br /><br />某些語言文件包含各種未翻譯消息的英文文本。此例程無法識別這些未翻譯的條目，因為它們已存在於目標文件。假設是，如果消息存在於目標文件中，則必須已翻譯。";
$pgv_lang["lang_file_write_error"] = "E R R O R !!!<br /><br />無法將更改寫入所選語言文件。請檢查<b>#lang_filename#</b>的寫入權限";
$pgv_lang["no_open"] = "E R R O R !!!<br /><br />無法打開文件<b>#lang_filename#</b>";

//-- User Migration Tool messages
$pgv_lang["um_proceed"] = "選擇一個選項或點擊下面的鏈接返回 管理 菜單";
$pgv_lang["um_sql_index"] = "此工具將在索引目錄中創建<i>authenticate.php</i>和幾個<i>.dat</i>文件。<br /><br />成功創建後，您可以切換到索引模式可以使用所有當前用戶及其消息，收藏夾，新聞和MyGedview佈局。<br /><br />注意:切換到索引模式後，您需要再次導入GEDCOM文件。";
$pgv_lang["um_file_create_fail1"] = "創建新文件失敗，已存在具有該名稱的文件:";
$pgv_lang["um_file_create_fail3"] = "檢查此目錄的訪問權限。";
$pgv_lang["um_file_create_succ1"] = "創建新文件成功:";
$pgv_lang["um_file_not_created"] = "文件未創建。";
$pgv_lang["um_nomsg"] = "系統中似乎沒有消息。";
$pgv_lang["um_nofav"] = "系統中似乎沒有收藏夾。";
$pgv_lang["um_nonews"] = "系統中似乎沒有新聞。";
$pgv_lang["um_noblocks"] = "系統中似乎沒有阻塞。";
$pgv_lang["um_index_sql"] = "此工具會將<i>authenticate.php</i>和其他<i>.dat</i>文件從索引目錄導入數據庫。";
$pgv_lang["um_noaction"] = "將用戶信息遷移到SQL模式不需要執行任何操作。<br /><br />一旦切換到SQL模式，您需要重新啟動用戶遷移工具以將所有數據導入SQL數據庫.PhpGedView將使用來自的現有文件索引模式。<br /><br /><b>從索引目錄中刪除<i>authenticate.php</i>和<i>.dat</i>文件時，<u>不</u>切換。</b>";
$pgv_lang["um_explain"] = "此工具將用戶數據從SQL導出到索引模式，或將用戶數據從索引文件導入SQL表格。<br /><br />用戶數據，收藏夾，塊定義，消息和新聞將在以後再次可用遷移。<br /><br /><b>注意</b><br />您無法使用此工具在不同版本的PhpGedView之間遷移用戶數據。請確保數據來自或導入到相同的PhpGedView版本。<br /><br />进口<br />如果您選擇從索引模式導入用戶數據文件，則數據庫表中存在的所有用戶數據都將是<u>覆蓋</u>。這個工具<u>不</u>合併信息。一旦你運行了導入，就無法使用PhpGedView檢索舊信息。<br /><br /><b>導出</b><br />如果將用戶信息從SQL數據庫導出到索引模式文件，此工具將創建<i>authenticate.php</i>和幾個<i>.dat</i>索引目錄中的文件。如果已經預先命名了相同名稱的文件nt，系統會提示您是否必須覆蓋它們。切換到索引模式後，所有信息都將直接提供。<br /><br /><b>注意:</b>切換到索引模式後，您需要再次導入GEDCOM文件。";
$pgv_lang["um_tool_help"] = "~#pgv_lang[um_header]#~<br /><br />#pgv_lang[um_explain]#";
$pgv_lang["um_sql_index_help"] = "~將用戶從SQL遷移到索引模式~<br />#pgv_lang[um_sql_index]#";
$pgv_lang["um_index_sql_help"] = "~將用戶從索引遷移到SQL模式~<br />#pgv_lang[um_index_sql]#";
$pgv_lang["um_imp_users"] = "導入用戶";
$pgv_lang["um_imp_blocks"] = "導入塊";
$pgv_lang["um_imp_favorites"] = "導入收藏夾";
$pgv_lang["um_imp_messages"] = "導入消息";
$pgv_lang["um_imp_news"] = "導入新聞";
$pgv_lang["um_nousers"] = "在您的索引目錄中找不到 文件<i>authenticate.php</i>。遷移已取消。";
$pgv_lang["um_bu_explain"] = "這個工具可以在PhpGedView中備份幾種數據。<br /><br />您選擇備份的數據將被收集到一個ZIP文件中，您可以通過單擊底部的鏈接下載該文件。備份成功完成後的頁面。<br /><br />ZIP文件將保留在您的索引目錄中，直到您手動刪除它為止。";
$pgv_lang["um_bu_help"] = "~#pgv_lang[um_backup]#~<br /><br />#pgv_lang[um_bu_explain]#";
$pgv_lang["um_bu_gedsets"] = "GEDCOM設置，配置和隱私文件";
$pgv_lang["um_bu_logs"] = "GEDCOM SearchLogs和PhpGedView Logfiles";
$pgv_lang["um_bu_usinfo"] = "用戶定義，阻止設置，收藏夾，消息，新聞";
$pgv_lang["um_nofiles"] = "找不到備份文件。";
$pgv_lang["um_files_exist"] = "一個或多個文件已經存在。你要覆蓋它們嗎？";
$pgv_lang["preview_faq_item"] = "預覽所有常見問題條目";
$pgv_lang["preview_faq_item_help"] = "~#pgv_lang[preview_faq_item]#~<br />此選項允許管理員用戶查看FAQ頁面，而不包含所有編輯選項和鏈接。<br /><br />除了單個<b>編輯</b >鏈接到第一個FAQ條目上方，FAQ頁面的外觀將與普通用戶看到的相同。這個特殊的<b>編輯</b>鏈接將完整的編輯功能恢復到FAQ頁面。";
$pgv_lang["restore_faq_edits"] = "恢復常見問題編輯功能";
$pgv_lang["restore_faq_edits_help"] = "~#pgv_lang[restore_faq_edits]#~<br />此選項將FAQ頁面恢復為管理員用戶通常看到的內容，以便可以編輯各個FAQ條目。";
$pgv_lang["add_faq_item"] = "添加常見問題條目";
$pgv_lang["add_faq_item_help"] = "~#pgv_lang[add_faq_item]#~<br />此選項可讓您將條目添加到常見問題解答頁面。";
$pgv_lang["edit_faq_item"] = "編輯常見問題條目";
$pgv_lang["edit_faq_item_help"] = "~#pgv_lang[edit_faq_item]#~<br />此選項可讓您編輯FAQ頁面上的條目。";
$pgv_lang["delete_faq_item"] = "刪除常見問題條目";
$pgv_lang["delete_faq_item_help"] = "~#pgv_lang[delete_faq_item]#~<br />此選項可讓您從常見問題頁面中刪除條目";
$pgv_lang["moveup_faq_item"] = "移動常見問題條目";
$pgv_lang["moveup_faq_item_help"] = "~#pgv_lang[moveup_faq_item]#~<br />此選項可讓您在常見問題頁面上向上移動條目。<br /><br />每次使用此選項時，此條目的常見問題位置編號為通過編輯有問題的條目並更改常見問題解答位置字段，您可以達到同樣的效果。當多個常見問題解答條目具有相同的位置編號時，只有其中一個條目可見。";
$pgv_lang["movedown_faq_item"] = "移動常見問題解答條目";
$pgv_lang["movedown_faq_item_help"] = "~#pgv_lang[movedown_faq_item]#~<br />此選項可讓您在常見問題解答頁面上向下移動條目。<br /><br />每次使用此選項時，此條目的常見問題位置編號為通過編輯相關條目並更改常見問題解答位置字段，您可以達到相同的效果。當多個常見問題條目具有相同的位置編號時，只有其中一個條目可見。";
$pgv_lang["add_faq_header_help"] = "~#pgv_lang[add_faq_header]#~<br />這是FAQ條目的標題或主題。<br /><br />您輸入的內容可以格式化.HTML標籤，例如&lt;b&gt;和&lt;允許使用br /&gt;以及&amp;amp;和&amp;nbsp;等HTML實體。&lt;br /&gt;以外的HTML標記在FAQ標題中可能不是很有用，應該避免使用。<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["add_faq_body_help"] = "~#pgv_lang[add_faq_body]#~<br />此處輸入FAQ條目的文本。<br /><br />文本可以格式化.HTML標籤，例如&lt;b&gt;和&lt;br /&gt;是允許的，例如&amp;amp;和&amp;nbsp;等HTML實體。<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["add_faq_HTML"] = "HTML實體是一種非常簡單的方法，可以在FAQ標題和文本中添加特殊字符。您可以使用符號名稱，十進制數字或十六進制數字。完整的HTML實體列表，它們的編碼以及瀏覽器的表示形式可以是在此處找到:<a href=\"http://htmlhelp.com/reference/html40/entities/\" target=\"_blank\">HTML實體列表</a><br /><br />，您可能需要顯示一個Tilde字符&nbsp;&nbsp;<b>&#x7E;</b>&nbsp;&nbsp;或一個數字簽名&nbsp;&nbsp;<b>&#x23;</b>&nbsp;&nbsp;在您的网址或文字中。這些字符對PhpGedView幫助系統有特殊含義，只能以十六進製或十進制形式輸入。同樣，&nbsp;&nbsp;<b>&lt;</b>&nbsp;&nbsp;和&nbsp;&nbsp;<b>&gt;</b>&nbsp;&nbsp;通常包含HTML標記的字符必須以十六進製或十進制形式輸入，如果它們被視為普通文本而不是發送HTML標記信號。<ul><li><b>&amp;&#x23;35;</b>&nbsp;&nbsp;或&nbsp;&nbsp;<b>&amp;&#x23;x23;</b>&nbsp;&nbsp;將導致&nbsp;&nbsp;<b>&#x23;</b></li><li><b>&amp;&#x23;60;</b >&nbsp;&nbsp;或&nbsp;&nbsp;<b>&amp;&#x23;x3C;</b>&nbsp;&nbsp;將導致&nbsp;&nbsp;<b>&#x3C;</b></li><li><b>&amp;&#x23;62;</b>&nbsp;&nbsp;或&nbsp;&nbsp;<b>&amp;&#x23;x3E;</b>&nbsp;&nbsp;將導致&nbsp;&nbsp;<b>&#x3E;</b></li><li><b>&amp;&#x23;126;</b>&nbsp;&nbsp;或&nbsp;&nbsp;<b>&amp;&#x23;x7E;</b>&nbsp;&nbsp;將導致&nbsp;&nbsp;<b>&#x7E;</b></li></ul>有一個&nbsp;&nbsp;<b>&amp;tilde;</b>&nbsp;&nbsp;HTML實體，但在URL中編碼時，此符號不會被解釋為Tilde。";
$pgv_lang["add_faq_pgvLangRefs"] = "您可以插入語言文件中的條目或全局變量值的引用。例如:<ul><li><b>&#x23;pgv_lang[add_to_cart]&#x23;</b >&nbsp;&nbsp;&nbsp;;是對語言變量\$pgv_lang[\"add_to_cart\"]的引用，如果它出現在此字段中，當FAQ列表為時，將顯示為<b>#pgv_lang[add_to_cart]#</b>用當前語言查看。</li><li><b>&#x23;factarray[AFN]&#x23;</b>&nbsp;&nbsp;&nbsp;是對事件名稱的引用\$factarray[\"AFN\"]，如果它出現在此字段中，當以當前語言查看FAQ列表時，將顯示為<b>#factarray[AFN]#/b>。</li><li><b>&#x23;PGV_VERSION&#x23;&nbsp;&#x23;PGV_VERSION_RELEASE&#x23;</b>&nbsp;&nbsp;&nbsp;是對常量PGV_VERSION的引用，空格和對常量PGV_VERSION_RELEASE的引用，如果他們要出現在此字段中，當以當前語言查看常見問題列表時，將顯示為<b>#PGV_VERSION#&nbsp;#PGV_VERSION_RELEASE#</b>。</li><li><b>&#x23;GLOBALS[GEDCOM]&#x23;</b>&nbsp;&nbsp;&nbsp;是對全局變量\$GEDCOM引用，它是當前GEDCOM文件的名稱。如果它出現在此字段中，它將顯示為<b>#GLOBALS[GEDCOM]#</b>。</li><li><b>&#x23;GLOBALS[GEDCOM_TITLE]&#x23;</b>&nbsp;&nbsp;&nbsp;是對全局變量\$GEDCOM_TITLE的引用，它是當前GEDCOM文件的標題。如果它出現在此字段中，它將顯示為<b>#GLOBALS[GEDCOM_TITLE]#</b>。</li></ul><br />當您希望創建常見問題列表時，此功能非常有用對於您的網站支持的每種語言，它們都不同。您應該使用以下格式將自定義的常見問題列表標題和條目放入<i>languages/extra.xx.php</i>文件（<i>xx</i>是每種語言的代碼）中:<br />\$pgv_lang[\"faq_title1\"]= \"This is a sample FAQ title\";<br />\$pgv_lang[\"faq_body1\"] = \"This is a sample FAQ body.\";";
$pgv_lang["add_faq_order_help"] = "~#pgv_lang[add_faq_order]#~<br />此字段控制FAQ條目的顯示順序。<br /><br />您不必按順序輸入數字。如果您在編號方案，您可以稍後插入其他條目。例如，如果您使用數字1,6,11,16，您可以稍後插入缺少序列號的條目。允許使用負數和零，並且可以用於插入第一個條目前面的條目。<br /><br />當多個FAQ條目具有相同的位置編號時，只能看到其中一個條目。";
$pgv_lang["add_faq_visibility_help"] = "~#pgv_lang[add_faq_visibility]#~<br />無論GEDCOM如何，您都可以確定此FAQ是否可見，或者只有當前的GEDCOM才能看到它。<br /><ul ><li><b>#pgv_lang[all]#</b>&nbsp;&nbsp;&nbsp;常見問題解答將出現在所有常見問題列表中，無論GEDCOM如何。</li><li><b>#GLOBALS[GEDCOM]#</b>&nbsp;&nbsp;&nbsp;常見問題解答只會出現在當前活躍的GEDCOM常見問題列表中。</li></ul>";
$pgv_lang["index_gedcom_news_adm_help"] = "GEDCOM新聞文本允許使用<b>HTML標記</b>和<b>HTML實體</b>。不應在新聞標題中使用HTML。<br /><br />請務必始終使用開始和結束標籤。可能有助於理解適合網站管理員的HTML。該程序也使用<b>層迭樣式表（CSS）</b>。為每個主題實現不同的CSS您可以使用這些樣式表中的類來控制消息的外觀。<br /><br />如果您需要更多幫助，網站上有一些如何在您的GEDCOM新聞中使用這些標籤的示例與FAQ列表一樣， GEDCOM新聞標題和新聞文本允許嵌入引用\$pgv_lang，\$factarray和\$GLOBALS變量，以便在創建新聞條目時提供完全的靈活性。對當前活動的語言很敏感。<br /><br />以下描述取自常見問題列表的幫助文本，同樣適用於GEDCOM新聞條目。<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["time_limit_help"] = "~#pgv_lang[time_limit]#~<br /><br />允許導入以處理GEDCOM文件的最長時間。";

//editconfig_gedcom.php Option Filter
$pgv_lang["ged_filter_description_help"] = "~#pgv_lang[ged_filter_description]#~<br />此選項允許您搜索與配置選項關聯的文本。<br /><br />當您鍵入字母時，搜索將查找包含該字母序列的所有配置選項當你輸入更多的字母時，搜索變得更加精確。";
?>
