<?php
/**
 * Polish texts
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2022  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @author Łukasz Wileński <wooc@users.sourceforge.net>
 * @author Tomasz Babczyński <tomasz.babczynski@gmail.com>
 * @translations by Google Translate (verified by natives)
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: countries.pl.php 7358 2022-11-11 19:44:16Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$countries["ABW"]="Aruba";
$countries["ACA"]="Akadia";
$countries["AFG"]="Afganistan";
$countries["AGO"]="Angola";
$countries["AIA"]="Anguilla";
$countries["ALA"]="Wyspy Alandzkie";
$countries["ALB"]="Albania";
$countries["AND"]="Andora";
$countries["ANT"]="Antyle Holenderskie";
$countries["ARE"]="Zjednoczone Emiraty Arabskie";
$countries["ARG"]="Argentyna";
$countries["ARM"]="Armenia";
$countries["ASM"]="Samoa Amerykańskie";
$countries["ATA"]="Antarktyda";
$countries["ATF"]="Francuskie Terytoria Południowe";
$countries["ATG"]="Antigua i Barbuda";
$countries["AUS"]="Australia";
$countries["AUT"]="Austria";
$countries["AZE"]="Azerbejdżan";
$countries["AZR"]="Azory";
$countries["BDI"]="Burundi";
$countries["BEL"]="Belgia";
$countries["BEN"]="Benin";
$countries["BFA"]="Burkina Faso";
$countries["BGD"]="Bangladesz";
$countries["BGR"]="Bułgaria";
$countries["BHR"]="Bahrajn";
$countries["BHS"]="Bahamy";
$countries["BIH"]="Bośnia i Hercegowina";
$countries["BLM"]="Saint-Barthélemy";
$countries["BLR"]="Białoruś";
$countries["BLZ"]="Belize";
$countries["BMU"]="Bermudy";
$countries["BOL"]="Boliwia";
$countries["BRA"]="Brazylia";
$countries["BRB"]="Barbados";
$countries["BRN"]="Brunei";
$countries["BTN"]="Bhutan";
$countries["BVT"]="Wyspa Bouveta";
$countries["BWA"]="Botswana";
$countries["BWI"]="Brytyjskie Indie Zachodnie";
$countries["CAF"]="Republika Środkowoafrykańska";
$countries["CAN"]="Kanada";
$countries["CAP"]="Kolonia Przylądkowa";
$countries["CAT"]="Katalonia";
$countries["CCK"]="Wyspy Kokosowe (Keelinga)";
$countries["CHE"]="Szwajcaria";
$countries["CHI"]="Wyspy Normandzkie";
$countries["CHL"]="Chile";
$countries["CHN"]="Chiny";
$countries["CIV"]="Wybrzeże Kości Słoniowej"; //why Côte d'Ivoire?, it is not polish name
$countries["CMR"]="Kamerun";
$countries["COD"]="Demokratyczna Republika Konga (Kinszasa)";
$countries["COG"]="Republika Konga (Brazzaville)";
$countries["COK"]="Wyspy Cooka";
$countries["COL"]="Kolumbia";
$countries["COM"]="Komory";
$countries["CPV"]="Republika Zielonego Przylądka";
$countries["CRI"]="Kostaryka";
$countries["CSK"]="Czechosłowacja";
$countries["CUB"]="Kuba";
$countries["CXR"]="Wyspa Bożego Narodzenia";
$countries["CYM"]="Kajmany";
$countries["CYP"]="Cypr";
$countries["CZE"]="Czechy";
$countries["DEU"]="Niemcy";
$countries["DJI"]="Dżibuti";
$countries["DMA"]="Dominika";
$countries["DNK"]="Dania";
$countries["DOM"]="Dominikana";
$countries["DZA"]="Algieria";
$countries["ECU"]="Ekwador";
$countries["EGY"]="Egipt";
$countries["EIR"]="Eire";
$countries["ENG"]="Anglia";
$countries["ERI"]="Erytrea";
$countries["ESH"]="Sahara Zachodnia";
$countries["ESP"]="Hiszpania";
$countries["EST"]="Estonia";
$countries["ETH"]="Etiopia";
$countries["FIN"]="Finlandia";
$countries["FJI"]="Fidżi";
$countries["FLD"]="Flandry";
$countries["FLK"]="Falklandy (Malwiny)";
$countries["FRA"]="Francja";
$countries["FRO"]="Wyspy Owcze";
$countries["FSM"]="Mikronezja";
$countries["GAB"]="Gabon";
$countries["GBR"]="Wielka Brytania";
$countries["GEO"]="Gruzja";
$countries["GGY"]="Guernsey";
$countries["GHA"]="Ghana";
$countries["GIB"]="Gibraltar";
$countries["GIN"]="Gwinea";
$countries["GLP"]="Gwadelupa";
$countries["GMB"]="Gambia";
$countries["GNB"]="Gwinea Bissau";
$countries["GNQ"]="Gwinea Równikowa";
$countries["GRC"]="Grecja";
$countries["GRD"]="Grenada";
$countries["GRL"]="Grenlandia";
$countries["GTM"]="Gwatemala";
$countries["GUF"]="Gujana Francuska";
$countries["GUM"]="Guam";
$countries["GUY"]="Gujana";
$countries["HKG"]="Hong Kong";
$countries["HMD"]="Wyspy Heard i McDonalda";
$countries["HND"]="Honduras";
$countries["HRV"]="Chorwacja";
$countries["HTI"]="Haiti";
$countries["HUN"]="Węgry";
$countries["IDN"]="Indonezja";
$countries["IMN"]="Wyspa Man";
$countries["IND"]="Indie";
$countries["IOT"]="Brytyjskie Terytorium Oceanu Indyjskiego";
$countries["IRL"]="Irlandia";
$countries["IRN"]="Iran";
$countries["IRQ"]="Irak";
$countries["ISL"]="Islandia";
$countries["ISR"]="Izrael";
$countries["ITA"]="Włochy";
$countries["JAM"]="Jamajka";
$countries["JEY"]="Jersey";
$countries["JOR"]="Jordania";
$countries["JPN"]="Japonia";
$countries["KAZ"]="Kazachstan";
$countries["KEN"]="Kenia";
$countries["KGZ"]="Kirgistan";
$countries["KHM"]="Kambodża";
$countries["KIR"]="Kiribati";
$countries["KNA"]="Saint Christopher i Nevis";
$countries["KOR"]="Korea Południowa";
$countries["KWT"]="Kuwejt";
$countries["LAO"]="Laos";
$countries["LBN"]="Liban";
$countries["LBR"]="Liberia";
$countries["LBY"]="Libia";
$countries["LCA"]="Saint Lucia";
$countries["LIE"]="Liechtenstein";
$countries["LKA"]="Sri Lanka";
$countries["LSO"]="Lesotho";
$countries["LTU"]="Litwa";
$countries["LUX"]="Luksemburg";
$countries["LVA"]="Łotwa";
$countries["MAC"]="Makau";
$countries["MAF"]="Saint-Martin";
$countries["MAR"]="Maroko";
$countries["MCO"]="Monako";
$countries["MDA"]="Mołdawia";
$countries["MDG"]="Madagaskar";
$countries["MDV"]="Malediwy";
$countries["MEX"]="Meksyk";
$countries["MHL"]="Wyspy Marshalla";
$countries["MKD"]="Macedonia";
$countries["MLI"]="Mali";
$countries["MLT"]="Malta";
$countries["MMR"]="Myanmar (Birma)";
$countries["MNE"]="Czarnogóra";
$countries["MNG"]="Mongolia";
$countries["MNP"]="Mariany Północne";
$countries["MOZ"]="Mozambik";
$countries["MRT"]="Mauretania";
$countries["MSR"]="Montserrat";
$countries["MTQ"]="Martynika";
$countries["MUS"]="Mauritius";
$countries["MWI"]="Malawi";
$countries["MYS"]="Malezja";
$countries["MYT"]="Majotta";
$countries["NAM"]="Namibia";
$countries["NCL"]="Nowa Kaledonia";
$countries["NER"]="Niger";
$countries["NFK"]="Wyspa Norfolk";
$countries["NGA"]="Nigeria";
$countries["NIC"]="Nikaragua";
$countries["NIR"]="Irlandia Północna";
$countries["NIU"]="Niue";
$countries["NLD"]="Holandia";
$countries["NOR"]="Norwegia";
$countries["NPL"]="Nepal";
$countries["NRU"]="Nauru";
$countries["NTZ"]="Ziemia niczyja";
$countries["NZL"]="Nowa Zelandia";
$countries["OMN"]="Oman";
$countries["PAK"]="Pakistan";
$countries["PAN"]="Panama";
$countries["PCN"]="Pitcairn";
$countries["PER"]="Peru";
$countries["PHL"]="Filipiny";
$countries["PLW"]="Palau";
$countries["PNG"]="Papua - Nowa Gwinea";
$countries["POL"]="Polska";
$countries["PRI"]="Portoryko";
$countries["PRK"]="Korea Północna";
$countries["PRT"]="Portugalia";
$countries["PRY"]="Paragwaj";
$countries["PSE"]="Palestyna";
$countries["PYF"]="Polinezja Francuska";
$countries["QAT"]="Katar";
$countries["REU"]="Reunion"; //in polish it is just Reunion
$countries["ROU"]="Rumunia";
$countries["RUS"]="Rosja";
$countries["RWA"]="Rwanda";
$countries["SAU"]="Arabia Saudyjska";
$countries["SCG"]="Serbia i Czarnogóra";
$countries["SCT"]="Szkocja";
$countries["SDN"]="Sudan";
$countries["SEA"]="Na morzu";
$countries["SEN"]="Senegal";
$countries["SGP"]="Singapur";
$countries["SGS"]="Georgia Południowa i Sandwich Południowy";
$countries["SHN"]="Święta Helena";
$countries["SIC"]="Sycylia";
$countries["SJM"]="Wyspy Svalbard i Jan Mayen";
$countries["SLB"]="Wyspy Salomona";
$countries["SLE"]="Sierra Leone";
$countries["SLV"]="Salwador";
$countries["SMR"]="San Marino";
$countries["SOM"]="Somalia";
$countries["SPM"]="Saint-Pierre i Miquelon";
$countries["SRB"]="Serbia";
$countries["SSD"]="Południowy Sudan";
$countries["STP"]	= "Świętego Tomasza i Książęca";
$countries["SUN"]="ZSSR";
$countries["SUR"]="Surinam";
$countries["SVK"]="Słowacja";
$countries["SVN"]="Słowenia";
$countries["SWE"]="Szwecja";
$countries["SWZ"]="Suazi";
$countries["SYC"]="Seszele";
$countries["SYR"]="Syria";
$countries["TCA"]="Wyspy Turks i Caicos";
$countries["TCD"]="Czad";
$countries["TGO"]="Togo";
$countries["THA"]="Tajlandia";
$countries["TJK"]="Tadżykistan";
$countries["TKL"]="Tokelau";
$countries["TKM"]="Turkmenistan";
$countries["TLS"]="Timor Wschodni";
$countries["TON"]="Tonga";
$countries["TRN"]="Transylwania";
$countries["TTO"]="Trynidad i Tobago";
$countries["TUN"]="Tunezja";
$countries["TUR"]="Turcja";
$countries["TUV"]="Tuvalu";
$countries["TWN"]="Tajwan";
$countries["TZA"]="Tanzania";
$countries["UGA"]="Uganda";
$countries["UKR"]="Ukraina";
$countries["UMI"]="Dalekie Wyspy Mniejsze Stanów Zjednoczonych";
$countries["URY"]="Urugwaj";
$countries["USA"]="Stany Zjednoczone";
$countries["UZB"]="Uzbekistan";
$countries["VAT"]="Watykan";
$countries["VCT"]="Saint Vincent i Grenadyny";
$countries["VEN"]="Wenezuela";
$countries["VGB"]="Brytyjskie Wyspy Dziewicze";
$countries["VIR"]="Wyspy Dziewicze Stanów Zjednoczonych";
$countries["VNM"]="Wietnam";
$countries["VUT"]="Vanuatu";
$countries["WAF"]="Afryka Zachodnia";
$countries["WLF"]="Wallis i Futuna";
$countries["WLS"]="Walia";
$countries["WSM"]="Samoa";
$countries["YEM"]="Jemen";
$countries["YUG"]="Jugosławia";
$countries["ZAF"]="Republika Południowej Afryki";
$countries["ZAR"]="Zair";
$countries["ZMB"]="Zambia";
$countries["ZWE"]="Zimbabwe";
$countries["???"]="Nieznane";

/*
 * The following table lists alternate names for various Chapman codes.
 * It will be used when country names have to be converted to Chapman codes.
 * You do not have to list all the possibilities in all page languages.  This
 * will be done automatically by the country-to-Chapman conversion routine.
 *
 * Because the list, and its contents, are specific to each language, the
 * Translator Tool won't let you work on the list directly.  The list will
 * have to be updated and amended manually.
 *
 * Suppose Chapman code "XYZ" represents the same country, and that country
 * had the names "Name1", "Name2", "Name3" in its history.  It is now known
 * as "Current name".  You can list the various names like this:
 *
 * $countries["XYZ"]	= "Current name";
 * $altCountryNames["XYZ"]	= "Name1; Name2; Name3";
 *
 * The Chapman-to-country conversion will always use the $countries list of
 * the current page language, no matter what the original country name was.
 *
 */
/* The Polish version of these codes needs to be developed */
$altCountryNames["COD"]		= "Zair";
$altCountryNames["DEU"]		= "Republika Federalna Niemiec (RFN); Niemiecka Republika Demokratyczna (NRD)";
$altCountryNames["FLK"]		= "Falklandy; Malwiny"; //both names are used with similar frequency (but it is already in regular names table)
$altCountryNames["GBR"]		= "Wielka Brytania"; //already in reg. table
$altCountryNames["LKA"]		= "Cejlon";
$altCountryNames["MAC"]		= "Makao";
$altCountryNames["MMR"]		= "Burma";
$altCountryNames["NLD"]		= "Niderlandy"; //old name, now only used in books
$altCountryNames["PLW"]		= "Belau";
$altCountryNames["SUN"]		= "Związek Radziecki; Związek Sowiecki";//some historians insist that Sowiecki but in those days it was Radziecki
$altCountryNames["TLS"]		= "Timor Wschodni"; //no alt name in polish
$altCountryNames["USA"]		= "USA; Stany Zjednoczone Ameryki";
$altCountryNames["VAT"]		= "Stolica Apostolska; Stolica Piotrowa";
$altCountryNames["WSM"]		= "Samoa Zachodnie";

?>
