<?php
/**
 * Russian Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2022  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @translator Eugene Fedorov
 * @translator Natalia Anikeeva
 * @translator Ivan Platonov
 * @version $Id: facts.ru.php 7354 2022-10-27 18:46:54Z canajun2eh $
 */
if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}
// -- Define a fact array to map GEDCOM tags with their Russian values
$factarray["ABBR"] = "Сокращение";
$factarray["ADDR"] = "Адрес";
$factarray["ADR1"] = "Адрес 1";
$factarray["ADR2"] = "Адрес 2";
$factarray["ADOP"] = "Усыновление";
$factarray["AFN"] = "Номер прародителя (положение в генеологическом древе)";
$factarray["AGE"] = "Возраст";
$factarray["AGNC"] = "Учреждение";
$factarray["ALIA"] = "Иначе";
$factarray["ANCE"] = "Предки";
$factarray["ANCI"] = "Предки представляют интерес";
$factarray["ANUL"] = "Признание брака недействительным";
$factarray["ASSO"] = "Знакомые";
$factarray["AUTH"] = "Автор";
$factarray["BAPL"] = "Крещение у мормонов";
$factarray["BAPM"] = "Крещение";
$factarray["BARM"] = "Бар-мицва";
$factarray["BASM"] = "Бас-мицва";
$factarray["BIRT"] = "Рождение";
$factarray["BLES"] = "Благословение";
$factarray["BLOB"] = "Бинарный объект данных";
$factarray["BURI"] = "Захоронение";
$factarray["CALN"] = "Шифр";
$factarray["CAST"] = "Каста или сословие";
$factarray["CAUS"] = "Причина смерти";
$factarray["CEME"]  = "Захоронение";
$factarray["CENS"] = "Перепись";
$factarray["CHAN"] = "Последнее изменение";
$factarray["CHAR"] = "Кодировка";
$factarray["CHIL"] = "Ребенок";
$factarray["CHR"] = "Крещение";
$factarray["CHRA"] = "Крещение взрослого";
$factarray["CITY"] = "Населенный пункт";
$factarray["CONF"] = "Конфирмация";
$factarray["CONL"] = "Конфирмация у мормонов";
$factarray["COPR"] = "Авторские права";
$factarray["CORP"] = "Фирма";
$factarray["CREM"] = "Кремация";
$factarray["CTRY"] = "Страна";
$factarray["DATA"] = "Данные";
$factarray["DATE"] = "Дата";
$factarray["DEAT"] = "Кончина";
$factarray["DESC"] = "Потомки";
$factarray["DESI"] = "Потомки представляют интерес";
$factarray["DEST"] = "Назначение";
$factarray["DIV"] = "Развод";
$factarray["DIVF"] = "Дело о разводе";
$factarray["DSCR"] = "Приметы";
$factarray["EDUC"] = "Образование";
$factarray["EMIG"] = "Эмиграция";
$factarray["ENDL"] = "Ритуал Святых Последних дней";
$factarray["ENGA"] = "Помолвка";
$factarray["EVEN"] = "Событие";
$factarray["FAM"] = "Семья";
$factarray["FAMC"] = "Семья в детстве";
$factarray["FAMF"] = "Семейный файл у мормонов";
$factarray["FAMS"] = "Семья в браке";
$factarray["FCOM"] = "Первое причастие";
$factarray["FILE"] = "Внешний файл";
$factarray["FORM"] = "Формат";
$factarray["GIVN"] = "Имя, отчество (имена)";
$factarray["GRAD"] = "Образование (диплом)";
$factarray["HUSB"] = "Супруг";
$factarray["IDNO"] = "Идентификационный номер";
$factarray["IMMI"] = "Иммиграция";
$factarray["LEGA"] = "Наследник";
$factarray["MARB"] = "Объявление о браке";
$factarray["MARC"] = "Брачный контракт";
$factarray["MARL"] = "Разрешение на брак";
$factarray["MARR"] = "Брак";
$factarray["MARS"] = "Соглашение о браке";
$factarray["MEDI"] = "Тип Медиа";
$factarray["NAME"] = "Фамилия, имя, отчество (имена)";
$factarray["NATI"] = "Национальность";
$factarray["NATU"] = "Натурализация";
$factarray["NCHI"] = "Число детей";
$factarray["NICK"] = "Прозвище";
$factarray["NMR"] = "Число браков";
$factarray["NOTE"] = "Примечание";
$factarray["NPFX"] = "Титул (приставка)";
$factarray["NSFX"] = "Суффикс";
$factarray["OBJE"] = "Объект";
$factarray["OCCU"] = "Род занятий";
$factarray["ORDI"] = "Посвящение у мормонов";
$factarray["ORDN"] = "Посвящение в сан";
$factarray["PAGE"] = "Местонахождение цитаты";
$factarray["PEDI"] = "Восходящее древо";
$factarray["PLAC"] = "Место";
$factarray["PHON"] = "Телефон";
$factarray["POST"] = "Почтовый код";
$factarray["PROB"] = "Утверждение завещания";
$factarray["PROP"] = "Собственность";
$factarray["PUBL"] = "Публикация";
$factarray["QUAY"] = "Качество данных";
$factarray["REPO"] = "Архив";
$factarray["REFN"] = "Ссылка";
$factarray["RELA"] = "Отношение";
$factarray["RELI"] = "Вероисповедание";
$factarray["RESI"] = "Место проживания";
$factarray["RESN"] = "Ограниченный доступ";
$factarray["RETI"] = "Выход на пенсию";
$factarray["RFN"] = "Номер записи в файле";
$factarray["RIN"] = "Индентификационный номер";
$factarray["ROLE"] = "Роль";
$factarray["SEX"] = "Пол";
$factarray["SLGC"] = "Скрепление ребёнка обрядом Святых Последних Дней";
$factarray["SLGS"] = "Скрепление супруга/супруги обрядом Святых Последних Дней";
$factarray["SOUR"] = "Источник";
$factarray["SPFX"] = "Префикс к фамилии";
$factarray["SSN"] = "Номер социального страхования";
$factarray["STAE"] = "Штат";
$factarray["STAT"] = "Статус";
$factarray["SUBM"] = "Податель";
$factarray["SUBN"] = "Подача";
$factarray["SURN"] = "Фамилия";
$factarray["TEMP"] = "Храм мормонов";
$factarray["TEXT"] = "Текст";
$factarray["TIME"] = "Время";
$factarray["TITL"] = "Заглавие";
$factarray["TYPE"] = "Вид";
$factarray["WIFE"] = "Супруга";
$factarray["WILL"] = "Завещание";
$factarray["_EMAIL"] = "Адрес электронной почты (e-mail)";
$factarray["EMAIL"] 	= "Адрес электронной почты (e-mail)";
$factarray["_TODO"] = "К исполнению";
$factarray["_UID"] = "Универсальный идентификатор";
$factarray["_PRIM"]	= "Подсвеченная картинка";
$factarray["_DBID"] 	= "Связанный ID базы данных";

// These facts are used in specific contexts
$factarray["STAT:DATE"] = "Дата изменения статуса";
$factarray["DATA:DATE"] = "Дата появления в оригинальном источнике";

$factarray["NAME:_HEB"]	= "Имя на Иврите";
$factarray["PLAC:_HEB"]	= "Место на Иврите";
$factarray["TITL:_HEB"]	= "Звание на Иврите";
$factarray["NAME:ROMN"]	= "Романизированное имя";
$factarray["PLAC:ROMN"]	= "Романизированное иесто";
$factarray["TITL:ROMN"]	= "Романизированное звание";
$factarray["NAME:FONE"]	= "Фонетическое имя";
$factarray["PLAC:FONE"]	= "Фонетическое место";
$factarray["TITL:FONE"]	= "Фонетическое звание";

$factarray["SHARED_NOTE"]	= "Общая заметка";

//These facts are compounds for the view probabilities and the advanced search pages
$factarray["FAMC:HUSB:SURN"] = "Фамилия Отца";
$factarray["FAMC:WIFE:SURN"] = "Фамилия Матери";
$factarray["FAMC:HUSB:BIRT:PLAC"] = "Место Рождения Отца";
$factarray["FAMC:WIFE:BIRT:PLAC"] = "Место Рождения Матери";
$factarray["FAMC:MARR:PLAC"] = "Место брака родителей";
$factarray["FAMC:HUSB:OCCU"] = "Род занятий отца";
$factarray[":BIRT:PLAC"] = "Место рождения";
$factarray["FAMS:MARR:PLAC"] = "Место брака";
$factarray["FAMS:MARR:DATE"] = "Дата брака";
$factarray["FAMS:SPOUSE:DEAT:PLAC"] = "Место сметри супруга(и)";
$factarray["FAMC:HUSB:GIVN"] = "Имя отца";
$factarray["FAMS:SPOUSE:BIRT:PLAC"] = "Место рождения супруги(а)";
$factarray["FAMC:WIFE:GIVN"] = "Имя матери";
$factarray["FAMC:HUSB:FAMC:HUSB:GIVN"] = "Имя дедушки по отцовской линии";
$factarray["FAMC:WIFE:FAMC:WIFE:GIVN"] = "Имя бабушки по материнской линии";
$factarray["FAMC:WIFE:FAMC:HUSB:GIVN"] = "Имя дедушки по материнской линии";
$factarray["FAMC:HUSB:FAMC:WIFE:GIVN"] = "Имя бабушки по отцовской линии";
$factarray["FAMS:CHIL:BIRT:PLAC"] = "Место рождения ребёнка";
$factarray["FAMS:NOTE"] = "Заметка супруга(и)";
$factarray["FAMS:CENS:DATE"] = "Дата переписи супруга(и)";
$factarray["FAMS:CENS:PLAC"] = "Место переписи супруга(и)";
$factarray["FAMS:DIV:DATE"] = "Дата развода супруга(и)";
$factarray["FAMS:DIV:PLAC"] = "Место развода супруга(и)";
$factarray["FAMS:SLGS:DATE"] = "Дата скрепление супруга/супруги обрядом Святых Последних Дней";
$factarray["FAMS:SLGS:PLAC"] = "Место скрепление супруга/супруги обрядом Святых Последних Дней";
$factarray["FAMS:SLGS:TEMP"] = "Церковь скрепление супруга/супруги обрядом Святых Последних Дней";

// These facts are all colon delimited
$factarray["BIRT:PLAC"] = "Место Рождения";
$factarray["BIRT:DATE"] = "Дата Рождения";
$factarray["BIRT:SOUR"] = "Источник Рождения";
$factarray["DEAT:PLAC"] = "Место Кончины";
$factarray["DEAT:DATE"] = "Дата Кончины";
$factarray["DEAT:SOUR"] = "Источник Кончины";
$factarray["CHR:PLAC"] = "Место Крестин";
$factarray["CHR:DATE"] = "Дата Крестин";
$factarray["CHR:SOUR"] = "Источник Крестин";
$factarray["CONF:PLAC"] = "Место Подтверждения";
$factarray["CONF:DATE"] = "Дата Подтверждения";
$factarray["CONF:SOUR"] = "Источник Подтверждения";
$factarray["BAPM:PLAC"] = "Место Крещения";
$factarray["BAPM:DATE"] = "Дата Крещения";
$factarray["BAPM:SOUR"] = "Источник Крещения";
$factarray["_BRTM:PLAC"] = "Место Брит-Мила";
$factarray["_BRTM:DATE"] = "Дата Брит-Мила";
$factarray["_BRTM:SOUR"] = "Источник Брит-Мила";
$factarray["BARM:PLAC"] = "Место Бар-мицва";
$factarray["BARM:DATE"] = "Дата Бар-мицва";
$factarray["BARM:SOUR"] = "Источник Бар-мицва";
$factarray["BASM:PLAC"] = "Bas Mitzvah Place";
$factarray["BASM:DATE"] = "Bas Mitzvah Date";
$factarray["BASM:SOUR"] = "Bas Mitzvah Source";
$factarray["BURI:PLAC"] = "Место Захоронения";
$factarray["BURI:DATE"] = "Дата Захоронения";
$factarray["BURI:SOUR"] = "Источник Захоронения";
$factarray["FCOM:PLAC"] = "Место Первого Причастия";
$factarray["FCOM:DATE"] = "Дата Первого Причастия";
$factarray["FCOM:SOUR"] = "Источник Первого Причастия";
$factarray["MARB:PLAC"] = "Место Оглашения Брака";
$factarray["MARB:DATE"] = "Дата Оглашения Брака";
$factarray["MARB:SOUR"] = "Источник Оглашения Брака";
$factarray["MARR:PLAC"] = "Место Брака";
$factarray["MARR:DATE"] = "Дата Брака";
$factarray["MARR:SOUR"] = "Источник Брака";
$factarray["ENGA:PLAC"] = "Место Помолвки";
$factarray["ENGA:DATE"] = "Дата Помолвки";
$factarray["ENGA:SOUR"] = "Источник Помолвки";

// These facts are specific to GEDCOM exports from Family Tree Maker
$factarray["_MDCL"]	= "Эпикриз";
$factarray["_DEG"] 	= "Звание, чин";
$factarray["_MILT"] 	= "Военная служба";
$factarray["_SEPR"]	= "В разводе";
$factarray["_DETS"] 	= "Смерть супруга";
$factarray["CITN"] 	= "Гражданство";
$factarray["_FA13"] = "Факт 13";
$factarray["_FA12"] = "Факт 12";
$factarray["_FA11"] = "Факт 11";
$factarray["_FA10"] = "Факт 10";
$factarray["_FA9"] = "Факт 9";
$factarray["_FA8"] = "Факт 8";
$factarray["_FA7"] = "Факт 7";
$factarray["_FA6"] = "Факт 6";
$factarray["_FA5"] = "Факт 5";
$factarray["_FA4"] = "Факт 4";
$factarray["_FA3"] = "Факт 3";
$factarray["_FA2"] = "Факт 2";
$factarray["_FA1"] = "Факт 1";
$factarray["_FREL"] = "Родство по отцовской линии";
$factarray["_MREL"] = "Родство по материнской линии";
$factarray["_MSTAT"]	= "Статус Начала Брака";
$factarray["_MEND"]	= "Статус Окончания Брака";
$factarray["_NAMS"]	= "Тёзка";

// GEDCOM 5.5.1 related facts
$factarray["FAX"] = "ФАКС";
$factarray["FACT"] = "Факт";
$factarray["WWW"] = "Домашняя Страница в Интернете";
$factarray["MAP"] = "Карта";
$factarray["LATI"] = "Широта";
$factarray["LONG"] = "Долгота";
$factarray["FONE"] = "Фонетический";
$factarray["ROMN"] = "Романизированный";

// PAF related facts
$factarray["_NAME"] = "Имя для отправки по почте";
$factarray["URL"] = "Адрес сайта";
$factarray["_URL"] = "Адрес сайта";
$factarray["_HEB"] = "Иврит";
$factarray["_SCBK"] = "Альбом";
$factarray["_TYPE"] = "Тип Медиа";
$factarray["_SSHOW"] = "Слайд Шоу";

// Rootsmagic
$factarray["_SUBQ"]= "Короткая Версия";
$factarray["_BIBL"] = "Библиография";

// Reunion
$factarray["EMAL"]	= "Адрес Электронной Почты";

// Other common customized facts
$factarray["_ADPF"]	= "Усыновлен/удочерена отцом";
$factarray["_ADPM"] 	= "Усыновлен/удочерена матерью";
$factarray["_AKAN"] 	= "Также известен как";
$factarray["_AKA"] = "Иначе";
$factarray["_BRTM"] 	= "Обрезание";
$factarray["_COML"] 	= "Законный брак";
$factarray["_EYEC"] 	= "Цвет глаз";
$factarray["_FNRL"] 	= "Захоронение";
$factarray["_HAIR"] 	= "Цвет волос";
$factarray["_HEIG"] 	= "Рост";
$factarray["_HOL"]  = "Холокоста";
$factarray["_INTE"] 	= "Погребение в фамильном склепе";
$factarray["_MARI"] 	= "Помолвка";
$factarray["_MBON"] 	= "Оглашение вступающих в брак";
$factarray["_MEDC"] 	= "Медицинское состояние";
$factarray["_MILI"] 	= "Военная служба";
$factarray["_NMR"] 	= "Не женат/не замужем";
$factarray["_NLIV"] 	= "Кончина";
$factarray["_NMAR"] 	= "Никогда не состоял(а) в браке";
$factarray["_PRMN"] 	= "Постоянны";
$factarray["_WEIG"] 	= "Вес";
$factarray["_YART"] 	= "Поминание умерших (в еврейской религии)";
$factarray["_MARNM"] = "Имя в браке:";
$factarray["_MARNM_SURN"] = "Фамилия в Браке";
$factarray["_STAT"]	= "Статус Брака";
$factarray["COMM"]	= "Коментарий";

// Aldfaer related facts
$factarray["MARR_CIVIL"] = "Гражданский брак";
$factarray["MARR_RELIGIOUS"] = "Венчание";
$factarray["MARR_PARTNERS"] = "Зарегистрированное партнёрство";
$factarray["MARR_UNKNOWN"] = "Неизвестный тип Брака";

$factarray["_HNM"] = "Имя на Иврите";

// Pseudo-facts for relatives
$factarray["_DEAT_SPOU"] = "Смерть супруга(и)";
$factarray["_BURI_SPOU"] = "Захоронение супруга(и)";
$factarray["_CREM_SPOU"] = "Кремация супруга(и)";

$factarray["_BIRT_CHIL"] = "Рождение ребёнка";
$factarray["_CHR_CHIL"] = "Крещение ребёнка";
$factarray["_BAPM_CHIL"] = "Крещение ребёнка";
$factarray["__BRTM_CHIL"] = "Брит-мила ребенка";
$factarray["_ADOP_CHIL"] = "Усыновление ребёнка";
$factarray["_MARR_CHIL"] = "Брак ребёнка";
$factarray["_MARB_CHIL"] = "Помолвка ребёнка";
$factarray["_DEAT_CHIL"] = "Смерть ребёнка";
$factarray["_BURI_CHIL"] = "Захоронение ребёнка";
$factarray["_CREM_CHIL"] = "Кремация ребёнка";

$factarray["_BIRT_GCHI"] = "Рождение внука/внучки";
$factarray["_CHR_GCHI"] = "Крещение внука/внучки";
$factarray["_BAPM_GCHI"] = "Крещение внука/внучки";
$factarray["__BRTM_GCHI"] = "Брит-мила внука/внучки";
$factarray["_ADOP_GCHI"] = "Усыновление внука/внучки";
$factarray["_MARR_GCHI"] = "Брак внука/внучки";
$factarray["_MARB_GCHI"] = "Помолвка внука/внучки";
$factarray["_DEAT_GCHI"] = "Смерть внука/внучки";
$factarray["_BURI_GCHI"] = "Захоронение внука/внучки";
$factarray["_CREM_GCHI"] = "Кремация внука/внучки";

$factarray["_BIRT_GGCH"] = "Рождение правнука/правнучки";
$factarray["_CHR_GGCH"] = "Крещение правнука/правнучки";
$factarray["_BAPM_GGCH"] = "Крещение правнука/правнучки";
$factarray["__BRTM_GGCH"] = "Брит-мила правнука/правнучки";
$factarray["_ADOP_GGCH"] = "Усыновление правнука/правнучки";
$factarray["_MARR_GGCH"] = "Брак правнука/правнучки";
$factarray["_MARB_GGCH"] = "Помолвка внука/внучки";
$factarray["_DEAT_GGCH"] = "Смерть правнука/правнучки";
$factarray["_BURI_GGCH"] = "Захоронение правнука/правнучки";
$factarray["_CREM_GGCH"] = "Кремация правнука/правнучки";

$factarray["_MARR_FATH"] = "Брак отца";
$factarray["_MARB_FATH"] = "Помолвка отца";
$factarray["_DEAT_FATH"] = "Смерть отца";
$factarray["_BURI_FATH"] = "Захоронение отца";
$factarray["_CREM_FATH"] = "Кремация отца";

$factarray["_MARR_FAMC"] = "Брак родителей";
$factarray["_MARB_FAMC"] = "Помолвка родителей";

$factarray["_MARR_MOTH"] = "Свадьба матери";
$factarray["_MARB_MOTH"] = "Помолвка матери";
$factarray["_DEAT_MOTH"] = "Смерть матери";
$factarray["_BURI_MOTH"] = "Захоронение матери";
$factarray["_CREM_MOTH"] = "Кремация матери";

$factarray["_BIRT_SIBL"] = "Рождение брата или сестры";
$factarray["_CHR_SIBL"] = "Крещение брата или сестры";
$factarray["_BAPM_SIBL"] = "Крещение брата или сестры";
$factarray["__BRTM_SIBL"] = "Брит-мила брата или сестры";
$factarray["_ADOP_SIBL"] = "Усыновление брата или сестры";
$factarray["_MARR_SIBL"] = "Брак брата или сестры";
$factarray["_MARB_SIBL"] = "Помолвка брата или сестры";
$factarray["_DEAT_SIBL"] = "Смерть брата или сестры";
$factarray["_BURI_SIBL"] = "Захоронение брата или сестры";
$factarray["_CREM_SIBL"] = "Кремация брата или сестры";

$factarray["_BIRT_HSIB"] = "Рождение сводного брата или сестры";
$factarray["_CHR_HSIB"] = "Крещение сводного брата или сестры";
$factarray["_BAPM_HSIB"] = "Крещение сводного брата или сестры";
$factarray["__BRTM_HSIB"] = "Брит-мила сводного брата или сестры";
$factarray["_ADOP_HSIB"] = "Усыновление сводного брата или сестры";
$factarray["_MARR_HSIB"] = "Брак сводного брата или сестры";
$factarray["_MARB_HSIB"] = "Помолвка брата/сестры";
$factarray["_DEAT_HSIB"] = "Смерть сводного брата или сестры";
$factarray["_BURI_HSIB"] = "Захоронение сводного брата или сестры";
$factarray["_CREM_HSIB"] = "Кремация сводного брата или сестры";

$factarray["_BIRT_NEPH"] = "Рождение племянника или племянницы";
$factarray["_CHR_NEPH"] = "Крещение племянника или племянницы";
$factarray["_BAPM_NEPH"] = "Крещение племянника или племянницы";
$factarray["__BRTM_NEPH"] = "Брит-мила племянника или племянницы";
$factarray["_ADOP_NEPH"] = "Усыновление племянника или племянницы";
$factarray["_MARR_NEPH"] = "Брак племянника или племянницы";
$factarray["_MARB_NEPH"] = "Помолвка племянника или племянницы";
$factarray["_DEAT_NEPH"] = "Смерть племянника или племянницы";
$factarray["_BURI_NEPH"] = "Захоронение племянника или племянницы";
$factarray["_CREM_NEPH"] = "Кремация племянника или племянницы";

$factarray["_DEAT_GPAR"] = "Смерть бабушки или дедушки";
$factarray["_BURI_GPAR"] = "Захоронение бабушки или дедушки";
$factarray["_CREM_GPAR"] = "Кремация бабушки или дедушки";

$factarray["_DEAT_GGPA"] = "Смерть прародителя";
$factarray["_BURI_GGPA"] = "Захоронение прародителя";
$factarray["_CREM_GGPA"] = "Кремация прародителя";

$factarray["_BIRT_FSIB"] = "Рождение брата или сестры отца";
$factarray["_CHR_FSIB"] = "Крещение брата или сестры отца";
$factarray["_BAPM_FSIB"] = "Крещение брата или сестры отца";
$factarray["__BRTM_FSIB"] = "Брит-мила брата или сестры отца";
$factarray["_ADOP_FSIB"] = "Усыновление брата или сестры отца";
$factarray["_MARR_FSIB"] = "Брак брата или сестры отца";
$factarray["_MARB_FSIB"] = "Помолвка брата или сестры отца";
$factarray["_DEAT_FSIB"] = "Смерть брата или сестры отца";
$factarray["_BURI_FSIB"] = "Захоронение брата или сестры отца";
$factarray["_CREM_FSIB"] = "Кремация брата или сестры отца";

$factarray["_BIRT_MSIB"] = "Рождение брата или сестры матери";
$factarray["_CHR_MSIB"] = "Крещение брата или сестры матери";
$factarray["_BAPM_MSIB"] = "Крещение брата или сестры матери";
$factarray["__BRTM_MSIB"] = "Брит-мила брата или сестры матери";
$factarray["_ADOP_MSIB"] = "Усыновление брата или сестры матери";
$factarray["_MARR_MSIB"] = "Брак брата или сестры матери";
$factarray["_MARB_MSIB"] = "Помолвка брата или сестры отца";
$factarray["_DEAT_MSIB"] = "Смерть брата или сестры матери";
$factarray["_BURI_MSIB"] = "Захоронение брата или сестры матери";
$factarray["_CREM_MSIB"] = "Кремация брата или сестры матери";

$factarray["_BIRT_COUS"] = "Рождение первого двоюродного<br>брата или двоюродной сестры";
$factarray["_CHR_COUS"]  = "Кристины первого двоюродного<br>брата или двоюродной сестры";
$factarray["_BAPM_COUS"] = "Крещение первого двоюродного<br>брата или двоюродной сестры";
$factarray["__BRTM_COUS"] = "Брит-мила первого двоюродного<br>брата или двоюродной сестры";
$factarray["_ADOP_COUS"] = "Усыновление первого двоюродного<br>брата или двоюродной сестры";
$factarray["_MARR_COUS"] = "Свадьба первого двоюродного<br>брата или двоюродной сестры";
$factarray["_MARB_COUS"] = "Помолвка первого двоюродного<br>брата или двоюродной сестры";
$factarray["_DEAT_COUS"] = "Смерть первого двоюродного<br>брата или двоюродной сестры";
$factarray["_BURI_COUS"] = "Захоронение первого двоюродного<br>брата или двоюродной сестры";
$factarray["_CREM_COUS"] = "Кремация первого двоюродного<br>брата или двоюродной сестры";

$factarray["_FAMC_EMIG"] = "Эмиграция родителей";
$factarray["_FAMC_RESI"] = "Резиденция родителей";

//-- PGV Only facts
$factarray["_THUM"]	= "Всегда использовать главную картинку?";
$factarray["_PGVU"]	= " "; // last changed by
$factarray["SERV"] = "Удалённый Сервер";
$factarray["_GEDF"] = "Файл GEDCOM";

$factarray["TRLR"] = "Конец файла";
$factarray["VERS"] = "Версия";
$factarray["CONC"] = "Конкатенация";
$factarray["CONT"] = "Продолжение";
$factarray["HEAD"] = "Заголовок";
$factarray["LANG"] = "Язык";

/*-- Fact abbreviations for use in Chart boxes.
 *		Use these abbreviations in cases where the standard method of using the first
 *		letter of the spelled-out name results in an undesirable abbreviation or where
 *		you want to produce a different result (eg: "x" instead of "M" for "Married").
 *
 *		You can abbreviate any Fact label this way.  The list of abbreviations is
 *		open-ended.
 *
 *		These abbreviations are user-customizable. Just put them into file "extra.xx.php".
 *		The length of these abbreviations is not restricted to 1 letter.
 */

$factAbbrev = array();		// Don't let other languages specify Fact abbreviations for this language

/*-- The following lines have been commented out.  They should serve as examples.

$factAbbrev["BIRT"]		= "B";
$factAbbrev["MARR"]		= "M";
$factAbbrev["DEAT"]		= "D";

 */

?>
