<?php
/**
 * Italian FAQ texts
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2010  PGV Development Team. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @author Marco Renini
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: faqlist.it.php 6987 2010-10-31 14:34:28Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$faqlist["FAQ_000_head"] = "\"FAQ\": HO GIÀ SENTITO QUESTA PAROLA, MA COSA SIGNIFICA?";
$faqlist["FAQ_000_body"] = "<b>FAQ</b> è un acronimo che sta per <b>F</b>requently <b>A</b>sked <b>Q</b>uestions.<br /><br />Le cosiddette FAQ sono semplicemente una lista di domande ricorrenti (con le relative risposte).  La lista di FAQ che stai leggendo ora è stata preparata dal team di sviluppo di PhpGedView, e viene periodicamente aggiornata.";

$faqlist["FAQ_010_head"] = "BENVENUTO ALLE FAQ DELLA GENEALOGIA '#GLOBALS[GEDCOM_TITLE]#'";
$faqlist["FAQ_010_body"] = "Noi membri della famiglia #GLOBALS[GEDCOM_TITLE]# cogliamo l'occasione per dare il benvenuto in questa genealogia a tutti i nostri 'cugini', incoraggiandoli ad unirsi a noi nella ricerca dei nostri antenati e parenti. È un'attività contemporaneamente adorabile ed odiosa, poiché tende ad assorbire una quantità spropositata di tempo, ma alla fine regala anche una soddisfazione enorme. Adesso abbiamo l'opportunità di semplificare il nostro lavoro utilizzando il programma <a href=\"#PGV_PHPGEDVIEW_URL#\" target=\"_blank\">#PGV_PHPGEDVIEW#</a>, uno splendido programma di genealogia open source nato dal talento di programmatore di John Finlay e del suo team di PGV.";

$faqlist["FAQ_015_head"] = "CHE DIFFERENZA C'È TRA QUESTO ALBERO DI PhpGedView E GLI ALTRI ALBERI GENEALOGICI, TESTUALI O DINAMICI?";
$faqlist["FAQ_015_body"] = "Anche gli altri alberi, testuali o dinamici, visualizzano la genealogia in svariati modi, ma nessun altro può essere configurato, modificato o aggiornato direttamente <b>da voi</b>. Solo l'Amministratore del sito può fare le modifiche.<br /><br />PhpGedView invece è un albero interattivo.  Chiunque faccia parte della famiglia può essere autorizzato ad aggiornare, aggiungere o modificare i dati delle persone rappresentate. (Ovviamente, per ottenere questa autorizzazione, è necessario prima registrarsi al sito).";

$faqlist["FAQ_017_head"] = "QUALI SONO LE PRINCIPALI FUNZIONALITÀ DI QUESTO ALBERO GENEALOGICO?";
$faqlist["FAQ_017_body"] = "Con PhpGedView è possibile:<ul><li>Proteggere la privacy delle persone viventi; l'Amministratore decide chi/cosa puoi vedere.</li><li>Visualizzare l'albero in molti modi diversi: con numerosi tipi di grafici, report ed elenchi.</li><li>Costruire l'albero in modo collaborativo; con l'autorizzazione dell'Amministratore, chiunque può partecipare all'aggiornamento dell'albero.</li></ul>";

$faqlist["FAQ_020_head"] = "HO BISOGNO DI UN ACCOUNT PER ENTRARE? SE SI, COME FACCIO A RICHIEDERLO?";
$faqlist["FAQ_020_body"] = "L'approccio è del tipo \"Benvenuto.. sei un cugino?\"<br /><br /><b>NOTA: Nella genealogia #GLOBALS[GEDCOM_TITLE]# NON è NECESSARIA LA REGISTRAZIONE per visualizzare le informazioni principali relative alle persone ormai decedute. Tuttavia, per contribuire alle modifiche o anche solo per vedere i dati delle persone ancora in vita, è necessario registrarsi, in modo da dichiarare la propria identità e la propria relazione di parentela.</b>";
$faqlist["FAQ_020_body2"] = "Gli utenti registrati possono vedere i nomi di tutti gli individui presenti nell'albero, compresi quelli tuttora in vita. Possono inoltre vedere tutti i dettagli degli individui deceduti e di tutti i propri parenti stretti.<br /><br />Gli utenti che non sono collegati ad alcun parente possono vedere solo i nomi degli individui viventi e i dettagli di quelli deceduti.";
$faqlist["FAQ_020_body3"] = "<ol><li>Chi richiede un account dovrebbe di norma essere un parente, prossimo o magari anche distante, di qualcuno già presente nell'albero, o di qualcuno che a buon diritto dovrebbe esservi aggiunto;</li><li>Chi richiede un account dovrebbe essere propenso a consultare il sito e per quanto possibile anche a contribuire alla sua crescita - inizialmente fornendoci informazioni su sé stesso e sulla propria famiglia; più avanti controllando, correggendo ed aumentando quelle accumulate nel nostro database genealogico;</li><li>Chi richiede un account è tenuto a rispettare la privacy di tutte le altre persone viventi descritte nel sito, e, come menzionato sopra, a contribuire condividendo i propri dati personali. Le violazioni di questa norma provocheranno l'immediata revoca dei diritti di accesso e potrebbero anche costituire le premesse per un'azione legale. Prendiamo molto seriamente le questioni legate al possibile furto di identità o abuso di informazioni personali. Per maggiori dettagli, consultate la sezione sottostante riguardante la tutela della Privacy.</li></ol>Se possiedi le caratteristiche per richiedere la registrazione e confermi la tua intenzione di attenerti a queste semplici regole, procedi pure, utilizzando il <b><a target=\"_blank\" href=\"/phpGedView/login_register.php?action=register\">modulo di registrazione</a></b> appositamente predisposto nel sito. Assicurati di compilare anche il riquadro finale, nel quale descrivi la relazione che ti lega alle persone già elencate in questo sito, oltre a dichiarare apertamente l'accettazione delle regole di comportamento sopra descritte.  La tua richiestà verrà vagliata con attenzione e sollecitudine.";
$faqlist["FAQ_020_body4"] = "L'approvazione di ogni nuovo account utente viene fatta manualmente dall'Amministratore del sito.  Può richiedere, normalmente, da qualche minuto a 24 ore.";

$faqlist["FAQ_022_head"] = "PERCHÈ DEVO REGISTRARMI?";
$faqlist["FAQ_022_body"] = "Devi registrarti per dimostrarci di non essere un estraneo, dal momento che chiedi di poter accedere ad informazioni private e personali. Ad esempio, solo gli utenti registrati possono vedere i nomi delle persone viventi. Finché non ti registri, al posto dei nomi delle persone viventi, vedrai una scritta del tipo: \"Informazione Privata\".";

$faqlist["FAQ_025_head"] = "QUANTO TEMPO CI VUOLE PER APPROVARE LA MIA DOMANDA DI REGISTRAZIONE?";
$faqlist["FAQ_025_body"] = "L'approvazione di ogni nuovo account utente viene fatta manualmente dall'Amministratore del sito.  Può richiedere, normalmente, da qualche minuto a 24 ore.";

$faqlist["FAQ_027_head"] = "LA MIA REGISTRAZIONE È STATA APPROVATA DALL'AMMINISTRATORE. ORA VEDO I NOMI DELLE PERSONE VIVENTI, MA NON NE VEDO GLI ALTRI DETTAGLI.";
$faqlist["FAQ_027_body"] = "Per poter accedere anche ai dettagli (ed eventualmente solo dei tuoi parenti più prossimi) devi far parte tu stesso dell'albero. Contatta l'Amministratore via email, spiegandogli esattamente chi sei e in particolare se sei una delle persone già incluse nell'albero genealogico.";

$faqlist["FAQ_030_head"] = "COME FACCIO A INSERIRE I DATI?  DEVO USARE DEI FORMATI SPECIALI?";
$faqlist["FAQ_030_body"] = "Ecco alcuni suggerimenti utili";
$faqlist["FAQ_030_body2"] = " per gli utenti autorizzati a MODIFICARE online i dati.";
$faqlist["FAQ_030_body3"] = "(puoi comunque anche scegliere di comunicare le nuove informazioni via email, l'Amministratore provvederà ad inserirle al tuo posto).";
$faqlist["FAQ_030_HELP"] = "<strong>AIUTO</strong>: Ovunque nel sito è possibile richiamare le pagine di aiuto online, facendo clic sulle apposite icone con il simbolo \"?\", sempre presenti nell'intestazione di tutte le pagine ed in corrispondenza di quasi tutti i link ed i termini chiave. Se hai comunque ancora dei dubbi, mandaci semplicemente una email, e ti aiuteremo.";
$faqlist["FAQ_030_DATES"] = "<strong>DATE</strong>: Per tutte le date, in genealogia, si utilizza un formato standard, chiamato formato GEDCOM v5.5, fatto così: GG MMM AAAA con il mese abbreviato, in inglese (vale a dire che si scrive, ad esempio: 01 JAN 1822 e non 1/1/1822 o 1 Gennaio 1822).  Il sistema è anche in grado di riconoscere e correggere automaticamente alcuni errori, ma non contarci a priori!";
$faqlist["FAQ_030_HDATES"] = "Le <strong>DATE EBRAICHE</strong> devono essere inserite nel formato seguente: @#DHEBREW@ G MMM AAAA (ad es.: @#DHEBREW@ 21 AAV 5705 - i mesi devono essere indicati con le sigle TSH, CSH, KSL, TVT, SHV, ADR, ADS, NSN, IYR, SVN, TMZ, AAV e ELL, secondo il già citato standard GEDCOM v5.5).";
$faqlist["FAQ_030_PLACES"] = "<strong>LUOGHI</strong>: Cerchiamo, ovunque possibile, di inserire l'identificazione completa del luogo, che corrisponde alla seguente sequenza: Comune e/o Frazione, Provincia, Regione, Nazione. La Nazione va preferibilmente identificata mediante la sigla standard GEDCOM di 3 lettere, ad es.: Inghilterra [ENG], Scozia [SCT], Irlanda [IRE], Francia [FRA], Italia [ITA]. In particolare, per gli Stati Uniti, la sequenza corrisponde a: CittÀ e/o MunicipalitÀ, Contea, Stato, Nazione (USA e non US, U.S., o U.S.A.); ad esempio: <i>Indianapolis, Center Twp, Marion Co, Indiana, USA</i>. Gli Stati non vanno abbreviati con la sigla di 2 lettere; Eliminare i punti (.) dai nomi, ad es. inserire <i>Shelbyville, Addison Twp, Shelby Co, Indiana, USA</i>, invece di <i>Shelbyville, Addison Twp., Shelby Co., IN</i> oppure <i>Shelbyville, Addison Township, Shelby County, Indiana, U.S.A.</i>";
$faqlist["FAQ_030_PLACES2"] = "<strong>LUOGHI</strong>: Per i luoghi in America cerchiamo, ovunque possibile, di indicare la descrizione completa: Città e/o Municipalità (Township) in aggiunta alla sigla di 2 lettere dello Stato, concludendo con USA (non US, U.S., o U.S.A.), dopo lo Stato. Per le altre Nazioni, indichiamo la Città e/o Municipalità ed il nome della Nazione. Esempi di formati preferiti sono: <i>Indianapolis, IN, USA</i> e <i>Vilnius, Lithuania</i>.";
$faqlist["FAQ_030_PLACES3"] = "Ci sono due metodi pratici per acquisire l'indicazione di un luogo nel formato corretto:<br /><ul><li>utilizzare la piccola icona a forma di \"mondo\" sempre presente di fianco alla casella di inserimento del Luogo, per ottenere un elenco di luoghi già presenti nel nostro database. Spesso infatti gli eventi si concentrano in certi luoghi (Comuni) ricorrenti, per i quali otteniamo così automaticamente Regione, Provincia, etc. L'elenco viene automaticamente filtrato man mano che si scrive, e basta fare clic su uno dei nomi per inserirlo nella casella vuota, nel formato corretto.</li><li>fare clic sul segno + presente sotto alla casella di inserimento. Appariranno una serie di caselle aggiuntive per i diversi campi della sequenza, in ordine gerarchico: Nazione, Stato/Provincia, Contea, Città (corrispondenti, per l'Europa a: Nazione, Regione, Provincia, Comune). Vicino al campo Nazione è presente una lista a discesa con tutti i nomi delle Nazioni e le rispettive sigle standard di 3 lettere.</li></ul>";
$faqlist["FAQ_030_PLACES4"] = "Ci sono due metodi pratici per acquisire l'indicazione di un luogo nel formato corretto:<br /><ul><li>utilizzare la piccola icona a forma di \"mondo\" sempre presente di fianco alla casella di inserimento del Luogo, per ottenere un elenco di luoghi già presenti nel nostro database. Spesso infatti gli eventi si concentrano in certi luoghi (Comuni) ricorrenti, per i quali otteniamo così automaticamente Regione, Provincia, etc. L'elenco viene automaticamente filtrato man mano che si scrive, e basta fare clic su uno dei nomi per inserirlo nella casella vuota, nel formato corretto.</li><li>Fare clic sul segno + presente sotto alla casella di inserimento. Appariranno una serie di caselle aggiuntive per i diversi campi della sequenza, in ordine gerarchico: Nazione, Stato/Provincia, Contea, Città (corrispondenti, per l'Europa a: Nazione, Regione, Provincia, Comune). Vicino al campo Nazione è presente una lista a discesa con tutti i nomi delle Nazioni e le rispettive sigle standard di 3 lettere, che non utilizziamo.</li></ul>";
$faqlist["FAQ_030_PLACES5"] = "Il campo \"Ebraico\" sotto i dati del \"Luogo\" va utilizzato per inserire un nome in alfabeto Ebraico, in aggiunta a quello in alfabeto Latino.";
$faqlist["FAQ_030_NAMES"] = "<strong>NOMI</strong>: L'inserimento dei nomi, utilizzando l'apposita maschera, è abbastanza intuitivo, grazie anche alla funzione di aiuto online (richiamabile mediante le icone). La casella di inserimento INDI ( = individuo) dovrebbe presentarsi già espansa nei corrispondenti campi del nome. Se non lo fosse, è possibile espanderla facendo clic sul segno + presente a fianco (lo stesso vale per la casella del LUOGO).";
$faqlist["FAQ_030_PREFIX"] = "Usare la casella <u>PREFISSO</u> per inserire titoli onorifici come Dr, Rabb, On, Giud, etc.  Evitare di inserire i titoli \"normali\" come Sig, Sig.ra, Sig.na, Mr, Mrs.";
$faqlist["FAQ_030_GIVN"] = "<u>NOME</u> - I nomi di battesimo sono il nome principale e gli eventuali nomi intermedi/secondari, normalmente assegnati alla nascita."; 
$faqlist["FAQ_030_GIVN1"] = " Se avviene un cambio di nome successivamente alla nascita, questi nomi addizionali possono essere registrati separatamente, dopo l'inserimento della persona nel database.  È anche possibile utilizzare il campo SOPRANNOME.<br /><br />Normalmente, si presume che le persone vengano chiamate col proprio nome principale.  Quando ciò non avviene, è opportuno indicare quale dei diversi nomi è quello preferenziale, facendolo immediatamente seguire da un asterisco.  Ad esempio, <i>Mario Pierino* Rossi</i> indica che questa persona viene solitamente chiamata \"Pierino\".  In questo caso, \"Pierino\" non è un soprannome, ma potrebbe esserci anche quello, ad esempio \"Rino\".";
$faqlist["FAQ_030_GIVN2"] = " Inserire il nome di battesimo con l'iniziale maiuscola, il resto in lettere minuscole";
$faqlist["FAQ_030_SURNAME"] = "Il <u>COGNOME</u> è il nome familiare o finale, a seconda delle culture e tradizioni. Per una persona sposata, è comunque il cognome <u>alla nascita</u>, e non quello eventualmente acquisito a seguito del matrimonio. Vedere anche <i>Cognome coniugale</i>, più avanti. Se avviene un cambio di nome successivamente alla nascita, questi nomi addizionali possono essere registrati separatamente, dopo l'inserimento della persona nel database.  È anche possibile utilizzare il campo SOPRANNOME.";
$faqlist["FAQ_030_SURNAME2"] = " Inserire il cognome con l'iniziale maiuscola, il resto in lettere minuscole";
$faqlist["FAQ_030_SUFFIX"] = "I <u>SUFFISSI</u> del nome sono, ad esempio, Jr, Sr, III, etc.";
$faqlist["FAQ_030_NICKNAME"] = "Il <u>SOPRANNOME</u> è un nome comunemente usato per indicare la persona al posto di quello reale di battesimo; ad es. <i>Pino</i> potrebbe essere il soprannome di Giuseppe \"Pino\" Rossi, etc.";
$faqlist["FAQ_030_HEBNAME"] = "Il <u>NOME EBRAICO</u> è la traduzione Ebraica del nome espresso nell'alfabeto Latino. Non è possibile possdere più di un nome Ebraico. PhpGedView si aspetta che il cognome venga racchiuso entro una coppia di barre. Ad esempio, il nome &#1497;&#1506;&#1511;&#1489; &#1500;&#1493;&#1497; deve essere inserito così: &#1497;&#1506;&#1511;&#1489; /&#1500;&#1493;&#1497;/.";
$faqlist["FAQ_030_AKANAME"] = "Lo <u>PSEUDONIMO</u> è un nome alternativo con cui è conosciuta la persona. Talvolta è il nome di nascita di persone che hanno cambiato nome successivamente nel corso della vita, altre volte può essere un alias, o un nome d'arte. Può anche essere un nome matrimoniale. Il nome inserito in questo campo può essere diverso da quello di battesimo che fa parte del nome principale. PhpGedView si aspetta che il cognome venga racchiuso entro una coppia di barre. Ad esempio, <i>Mario Rossi</i> deve essere inserito così: <i>Mario /Rossi/</i>.";
$faqlist["FAQ_030_AKANAME2"] = " Anche eventuali nomi Ebraici o Yiddish addizionali vanno inseriti come pseudonimi.";
$faqlist["FAQ_030_MARRNAME"] = "I <u>NOMI MATRIMONIALI</u> sono quelli assunti dalle persone a seguito del matrimonio, solitamente acquisendo il cognome del coniuge. Questo campo viene creato automaticamente dal programma ogni volta che si inserisce un nuovo cognome nel campo Cognome Matrimoniale. Ad esempio, <i>Gina Bianchi</i> sposando <i>Mario Rossi</i>, diventa  <i>Gina Rossi</i> solo nel momento in cui si inserisce <i>Rossi</i> nel campo Cognome Matrimoniale.  I nomi matrimoniali non sono riservati solo alle femmine; è possibile inserire un nome matrimoniale per persone di entrambi i sessi.";
$faqlist["FAQ_030_MARRNAME2"] = "I nomi MATRIMONIALI Ebraici prendono il nome \"di battesimo\" dal corrispondente NOME EBRAICO della persona.";
$faqlist["FAQ_030_NAMES2"] = "La funzione <i>Modifica il nome</i>, presente in alcune pagine sotto al nome della persona e nella pagina <i>Fatti e Dettagli personali</i>, permette di modificare tutti i possibili aspetti del nome dell'individuo. La funzione <i>Cancella il nome</i>, anch'essa presente sotto al nome della persona, permette di eliminare solo il nome dalle informazioni presenti nel database, senza modificare nessun altro dato dell'individuo.  È possibile modificare il nome della persona, ed anche aggiungerene altri, facendo clic sulle funzioni <i>Modifica il nome</i> oppure <i>Aggiungi un nuovo nome</i>, presenti nel riquadro <i>Modifica</i>, sottomenu <i>Opzioni per la persona</i>.  Per maggiori dettagli, fare clic sull'icona Aiuto presente a fianco di queste funzioni."; 
$faqlist["FAQ_030_SOURC"] = "<strong>FONTI</strong> e <strong>CITAZIONI</strong>: in genealogia, non è sufficiente dire semplicemente che qualcosa \"è avvenuto, nella tal data\". La verità storica desidera avere delle prove. Anche noi! Cercate di includere qualsiasi informazione in vostro possesso, a titolo di fonte dei dati che state inserendo. Utilizzate le svariate notazioni disponibili per la documentazione delle fonti, ed utilizzate le NOTE in caso di dubbio o per inserire commenti in formato libero. Scrivete più di quanto non vi sembri necessario, potete star certi che non sarà mai troppo. Qualche dubbio? Se c'è qualcosa che non vi è chiaro, non avete che da chiedere, saremo felici di aiutarvi.";
$faqlist["FAQ_030_CHNG"] = "<strong>MODIFICHE</strong> e <strong>AGGIUNTE</strong>: qualsiasi modifica apportata ai dati di una persona o di una famiglia non apparirà sul sito finché non sarà esplicitamente approvata da un Amministratore. Queste attività di revisione vengono condotte frequentemente, ma se desiderate sollecitare un'approvazione in tempi più rapidi, inviateci pure una semplice email. I fatti riguardanti la creazione o la variazione di un nucleo familiare devono essere inseriti mediante i link alle pagine <i>Famiglia genitori/Famiglia prossima</i> (nel riquadro <i>Vedi dettagli per...</i>). È qui che si annotano matrimoni, divorzi, nascite di figli, dati anagrafici della famiglia - qualsiasi fatto o evento che riguardi il nucleo familiare.  Quando si devono aggiungere svariati figli, il modo più comodo consiste nel portarsi sulla pagina della FAMIGLIA relativa a quella coppia marito/moglie, e aggiungere ogni figlio mediante la funzione in fondo alla pagina, 'Aggiungi un bambino a questa famiglia'.  È più veloce che utilizzando la scheda 'Parenti stretti', poiché in quel caso dopo ogni aggiunta si viene riportati alla scheda principale 'Fatti e Dettagli personali', invece che alla scheda 'Parenti stretti'. Domande? Se c'è qualcosa che non hai capito, chiedi pure. Ti forniremo volentieri aiuto, consigli e correzioni, prontamente e gratuitamente.";
$faqlist["FAQ_030_MEDIA"] = "<strong>MEDIA</strong>: siamo felici se aggiungi ai tuoi dati fotografie, Certificati di Nascita, di Morte, Battesimo e Matrimonio - qualsiasi cosa tu abbia a supporto dei tuoi dati. È facile aggiungere file dal tuo hard disk, utilizzando la scheda MEDIA e le due funzioni 'Aggiungi un oggetto multimediale' e 'Collega a un oggetto multimediale esistente'. Anche in questo caso, se hai domande, suggerimenti, o semplicemente desideri ricevere assistenza, scrivic. Puoi anche inviarci le tue immagini digitali via email, e le aggiungeremo noi per te.";
$faqlist["FAQ_030_MEDIA2"] = "Nell'inserimento di nuovi oggetti multimediali, cerca di adottare una buona convenzione per i nomi dai file, che ti garantisca di non creare conflitti e doppioni. Il sistema ti permette di sfogliare il tuo hard disk e caricare l'oggetto prescelto dandogli un nome completamente nuovo (lasciando naturalmente intatto il nome del file originale). Immagina, ad esempio, quanti file chiamati \"Giacomino.jpg\" potrebbero esistere: se ti assicuri di creare dei nomi univoci, potresti finire per sovrascriverne uno già esistente. Vogliamo tenere i nomi dei file sufficientemente corti (max. 35 caratteri), ma sufficientemente descrittivi - qualcosa del tipo: MarioRossi-n1820-I23445.jpg oppure GinaBianchi-I23444-Lapide.jpg. Se hai dei dubbi, chiedici pure un consiglio.";
$faqlist["FAQ_030_NAVIGATE"] = "<strong>NAVIGAZIONE</strong>: a noi piace muoverci nell'albero utilizzando il DIAGRAMMA CIRCOLARE ed i Grafici degli Antenati e dei Discendenti. Provali. Ricordati però che molte funzionalità funzionano pienamente solo dopo che hai creato il tuo record personale, collegato a quelli dei tuoi antenati.";

$faqlist["FAQ_032_head"] = "POSSO INSERIRE/AGGIORNARE/CORREGGERE I DATI DI QUALSIASI PERSONA CONTENUTA NELL'ALBERO?";
$faqlist["FAQ_032_body"] = "Si.<br />Devi però fare parte tu stesso dell'albero, ed essere stato autorizzato dall'Amministratore ad apportare modifiche. L'Amministratore potrebbe anche decidere di consentirti di modificare solo i dati tuoi e dei tuoi parenti più prossimi. In alternativa, puoi anche inviare i dati via email, e lasciare che sia l'Amministratore ad integrarli nel database.";

$faqlist["FAQ_037_head"] = "NON SONO RIUSCITO AD INSERIRE LE MIE MODIFICHE DELL'ALBERO. COSA DEVO FARE?";
$faqlist["FAQ_037_body"] = "Puoi spedire le tue modifiche all'Amministratore<br />scrivi a: #GLOBALS[Webmaster_EMAIL]#";
$faqlist["FAQ_037_body2"] = "Puoi spedire le tue modifiche all'Amministratore<br />scrivi a: #GLOBALS[CONTACT_EMAIL]#";

$faqlist["FAQ_040_head"] = "E LA PRIVACY?";
$faqlist["FAQ_040_body"] = "Noi del sito #GLOBALS[GEDCOM_TITLE]# <b>siamo convinti che la tutela delle informazioni personali sia estremamente importante</b>. Le funzioni a tutela della privaci presenti nel software PhpGedView impongono in modo molto efficace il rispetto di alcune regole di discrezione - innanzitutto il nostro sito impedisce l'accesso ai dettagli delle persone in vita o di quelle alle quali non sei collegato da una relazione di parentela. Per poter vedere i dettagli delle persone viventi devi fare login, utilizzando una password ed il tuo account utente personale. Questo ti associa alla tua posizione all'interno dell'albero genealogico. Il nostro sito, inoltre, utilizza la funzione di \"privacy di parentela\" di PhpGedView. Questa funzionalità consente di limitare la visibilità degli utenti, esponendo ad ognunon di essi solo le informazioni degli individui considerati parenti stretti. Se, dopo aver fatto login, ti capita di vedere che certi individui o certe famiglie risultano marcate come \"Private\", allora significa che è stata attivata questa funzionalità. Se sei convinto che la tua visibilità sia stata limitata in modo eccessivo, non esitare ad inviare una email all'Amministratore, spiegando in modo dettagliato dove sei stato bloccato e perché ritieni di aver diritto a vedere quelle informazioni.";
$faqlist["FAQ_040_body2"] = "Naturalmente, nessun sistema è perfetto, né assolutamente inviolabile, quindi esiste sempre una remota possibilità di accesso non autorizzato ai dati. Noi facciamo tutto il possibile per porre rapidamente rimedio ad ogni problema di privacy. Se ti senti particolarmente preoccupato riguardo a qualche tuo dato personale memorizzato in questo sito, utilizza il link in fondo alla pagina per scrivere all'Amministratore. Lui può rimuovere qualsiasi dettaglio dei tuoi dati dal database (tieni comunque presente che ciò potrebbe anche ridurre le funzionalità per te disponibili nel sito). Leggi anche la FAQ che descrive quali sono le informazioni che vengono memorizzate nel sito.<br /><br /><b>Siamo molto seri riguardo all'abuso, il furto o l'uso scorretto delle informazioni personali, e non esiteremo a perseguire legalmente chi dovesse mettere in atto o tentare il furto d'identità utilizzando dati custoditi all'interno del nostro sito. Ti esortiamo a NON copiare su altri siti dati relativi a individui viventi, in quanto tali siti potrebbero non essere in grado di assicurare un'adeguata protezione della loro privacy, e tu potresti esserne ritenuto direttamente responsabile.</b>"; 

$faqlist["FAQ_050_head"] = "GRAZIE";
$faqlist["FAQ_050_body"] = "La raccolta e la gestione di questo volume di informazioni non sarebbe possibile senza l'aiuto e la collaborazione di tutti i nostri amati parenti. La ricerca genealogica è un gran divertimento ed una meravigliosa esperienza formativa, che permette di espandere la propria conoscenza sia della nostra famiglia che di nozioni generali di geografia e di sociologia. Ci auguriamo che anche a voi piaccia quanto a noi e ci stringiamo a tutti voi nel legame di cooperazione e di amicizia attivato, attraverso il nostro sito #GLOBALS[GEDCOM_TITLE]#, grazie alle funzioni del sistema PhpGedView.<br /><br />Se tutto questo vi piace, aiutateci ad arricchirlo sempre di più, e non esitate ad inviarci una email per richiederci una correzione o un'aggiunta, chiarire un dubbio, o anche solo per dire \"ciao\"!.<br /><br />Grazie ancora.";

?>
