<?php
/**
 * Czech Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2021  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author Jan Hapala
 * @version $Id: help_text.cz.php 7290 2021-02-25 15:16:34Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["add_gedcom_instructions"]	= "Zadejte název pro tento nový GEDCOM soubor. Tento soubor bude uložen do hlavního adresáře: ";
$pgv_lang["help_header"]			= "Další informace o:";
$pgv_lang["privacy_error_help"]			= "~SOUKROMÉ ÚDAJE~<br /><br />Existuje několik možných důvodů, proč se vám zobrazila tato zpráva:<br /><br /><b>1. Informace o žijících osobách v tomto GEDCOMu jsou označeny jako \"Soukromé\".</b><br /> Neregistrovaní návštěvníci nebo návštěvníci, kteří nejsou přihlášeni do systému, si mohou prohlížet pouze osobní údaje zesnulých osob. Je-li to umožněno administrátorem, můžete se zaregistrovat  kliknutím na tlačítko \"Přihlásit se\", pak na odkaz #pgv_lang[requestaccount]#.<br /><br /><b>2. Jste uživatel, který zde má účet se svým uživatelským jménem a heslem...</b><br />Ale zapomněli jste se přihlásit nebo jste nebyli delší dobu aktivní, a tak vám vypršela \"životnost\" session.<br /><br /><b>3. Kvůli nastavení privátnosti</b><br />Osoba, na jejíž jméno jste klikli, požádala admina, aby informace o ní byly nastaveny jako soukromé nebo nebyly zobrazeny vůbec.<br />Privátnost může být nastavena na:<br />a) #pgv_lang[PRIV_USER]#<br />b) #pgv_lang[PRIV_NONE]#<br />c) #pgv_lang[PRIV_HIDE]#<br /><br /><b>4. Mimo \"příbuzenskou vzdálenost\"</b><br />I když jste registrovaným uživatelem <b>a</b> jste přihlášení, může se stát, že se vám zobrazí tato zpráva. A to v případě, že osoba, kterou chcete zobrazit je s vámi příbuzná vzdáleně – vzdáleněji, než je administrátorem nastavena Příbuzenská vzdálenost pro tento GEDCOM.<br />Příklady:<br />Když je Příbuzenská vzdálenost nastavena na <b>1</b>, můžete procházet osobní údaje pouze své nejužší rodiny: otce, matky, bratra, sestry (ale ne partnerů vašich sourozenců a jejich dětí)<br /><br />Když je Příbuzenská vzdálenost nastavena na <b>2</b>, můžete procházet i údaje vaší švagrové a jejích dětí (ale ne partnerů těchto dětí).<br />Čím větší hodnota je nastavena v Příbuzenské vzdálenosti, tím vzdálenější příbuzné uvidíte (jejich osobní údaje).<br /><br />Jestliže se domníváte, že získáte oprávnění vidět určité údaje, kontaktujte prosím administrátora stránek. Odkaz na něj je na každé stránce.";
$pgv_lang["more_help"]				= "<br />Pokud chcete mít k dispozici kontextovou nápovědu, ujistěte se, že je volba <b>#pgv_lang[show_context_help]#</b> zapnutá (v Menu nápovědy), a klikněte na <b>?</b> za předmětem.";
$pgv_lang["more_config_help"]			= "<br /><b>Další nápověda</b><br />Další nápověda je k dispozici z formuláře.<br />Klikněte prosím na <b>?</b> za popisky.";
$pgv_lang["start_admin_help"]			= "+++ Začátek informací navíc pro Admina +++";
$pgv_lang["end_admin_help"]			= "--- Konec informací navíc pro Admina ---";
$pgv_lang["multiple_help"]			= "<span class='center'>--- Toto je obecná nápověda pro více stránek ---</span>";
$pgv_lang["header_general_help"]		= "<div class='name_head center'><b>OBECNÉ INFORMACE</b></div>";
$pgv_lang["best_display_help"]			= "~Vaše obrazovka~<br/>PhpGedView je navrženo pro rozlišení 1024x768 pixelů.<br />Pro správné zobrazení je tedy potřeba, aby vaše rozlišení bylo minimálně 1024x768.<br />Jestliže nastavíte rozlišení na nižší hodnotu (např. 800x600 pix.), budete se muset v okně vodorovně posouvat.";
$pgv_lang["preview_help"]			= "~Tisk~<br />Kliknete-li na odkaz Tiskový režim, budou ze stránky odstraněny všechny položky, které v tišněné podobě překážejí (menu, formulářová políčka, odkazy, otazníčky pro nápovědu apod.).<br />Dole na stránce určené pro tisk uvidíte odkaz Vytisknout. Klikněte na něj a objeví se dialogové okno tisku.<br />Po vytisknutí prostě jen klikněte na odkaz <b>Zpět</b> a objeví se opět stránka v normálním režimu.<br /><br /><b>Poznámka:</b><br />Přestože jsou všechny nadbytečné odkazy v náhledovém režimu odstraněny, na jména v rámečcích lze pořád klikat.";
$pgv_lang["readme_help"]			= "Chcete-li další informace, podívejte se do souboru <a href=\"readme.txt\" target=\"_blank\"><b>Readme.txt</b></a>.";
$pgv_lang["is_user_help"]			= "--- Tento text je stejný jako ten, který bude číst uživatel (nebo návštěvník). ---<br />--- Abychom ušetřili místo, nevytváříme u této položky speciální text pro admina. --";
$pgv_lang["edit_raw_gedcom_help"]	= "~UPRAVIT PŘÍMO GEDCOM~<br /><br />Pokud kliknete na tento odkaz, otevře se nové okno se \"zdrojovým kódem\" GEDCOMu, konkrétně s údaji, jež jsou zobrazeny na této stránce.<br />Tady můžete upravovat přímo samotný GEDCOM soubor. Dbejte na to, abyste údaje zapisovali podle standardu GEDCOM 5.5, protože tyto záznamy se již nebudou kontrolovat.<br />Změněné a/nebo přidané údaje se v PhpGedView zobrazí jako změny, a budou tedy muset být přijaty uživatelem s právem potvrzovat změny.";
$pgv_lang["index_help"]				= "~ÚVODNÍ STRANA~<br /><br />Toto je úvodní strana. Uvádí vás do zvoleného souboru <a href=\"#def_gedcom\">GEDCOM</a>. Na tuto stránku se můžete kdykoliv vrátit kliknutím na Úvodní stránku v horním menu. Je-li na těchto stránkách k dispozici více GEDCOMů, můžete si zvolit GEDCOM z rolovacího menu.<br /><b>Tato stránka s nápovědou obsahuje informace o:</b>(Jelikož je tato stránka první stránkou programu)<ul><li><a href=\"#index_portal\">Úvodní stránce</a><li><a href=\"#header\">Oblasti záhlaví</a><li><a href=\"#menu\">Menu</a><li><a href=\"#header_general\">Všeobecné informace</a><li><a href=\"#def\">Definice</a></ul><br />Verze #VERSION# přináší nový vzhled <a href=\"#def_pgv\">PhpGedView</a>. Menu, počáteční strana a mnoho dalších vlastností je vylepšeno a/nebo přepracováno.";
$pgv_lang["header_help"]			= "<div class='name_head center'><b>OBLAST ZÁHLAVÍ</b></div><br />Záhlaví je horní část stránky a objevuje se na každé stránce.<br />Záhlaví obsahuje užitečné odkazy, které můžete používat pro procházení stránek.<br />Jelikož mohou mít tyto stránky různý vzhled v závislosti na zvoleném <a href=\"#def_theme\">Motivu</a>, záhlaví různých motivů tím mohou být ovlivněna a mohou se lišit.<br /><br /><b>Odkazy, které zde můžete najít, jsou:</b><ul><li><a href=\"#header_search\">Vyhledávácí políčko</a><li><a href=\"#header_lang_select\">Výběr jazyka</a><li><a href=\"#header_user_links\">Uživatelské odkazy</a><li><a href=\"#header_favorites\">Oblíbené</a><li><a href=\"#header_theme\">Změna motivu</a></ul>";
$pgv_lang["header_search_help"]		= "~Oblast záhlaví: Vyhledávací políčko~<br />Toto vyhledávací políčko je sice malé, ale zato možnosti vyhledávání jsou široké.<br />Pro vyhledávání můžete zadat téměř cokoliv. Když kliknete na tlačítko <b>&gt;</b> nebo <b>Hledat</b>, budete přesměrováni na hlavní stránku vyhledávání, kde uvidíte seznam nalezených položek.<br />Podrobnější nápovědu k vyhledávání najdete na hlavní straně vyhledávání.";
$pgv_lang["header_lang_select_help"]= "~Oblast záhlaví: Výběr jazyka~<br />Jedna z nejdůležitějších vlastností tohoto programu je automatické přepnutí do podporovaného jazyka.<br />Někdy se může stát, že se program návštěvníkovi přepne do jiného jazyka, než by si přál (např. kvůli nesprávnému nastavení jazyka v prohlížeči).<br />Návštěvník si ale může změnit jazyk pomocí <b>>Výběru jazyka<</b><br />Výběr jazyka může být zobrazen dvěma odlišnými způsoby:<br />Buď uvidíte klasický rolovací seznam nebo barevnou verzi s národními vlajkami.";
$pgv_lang["header_user_links_help"]	= "~Oblast záhlaví: Uživatelské odkazy~<br />Uživatelské odkazy jsou užitečné odkazy zobrazené v malém bloku vždy na stejném místě na stránce (pokud nebudete měnit motivy)<br />Nebudete-li ještě přihlášeni, uvidíte pouze odkaz <b>Přihlásit se</b>.<br />Když už budete přihlášeni, uvidíte: <b>Přihlášen(a) jako (vaše uživatelské jméno)</b>. Kliknete-li na tento odkaz, dostanete se do svého účtu.<br />Odkaz <b>Odhlásit se</b> je jasný: udělá přesně to.<br />Máte-li práva admina, uvidíte také <b>Admin</b>. Kliknutí na tento odkaz vás přenese přímo na hlavní stránku administrace.";
$pgv_lang["header_favorites_help"]	= "~Oblast záhlaví: Moje oblíbené~<br />V tomto rolovacím seznamu najdete své oblíbené, které jste si vybrali na své osobní vstupní bráně.<br />Kliknutím na jednu z těchto položek se dostanete přímo na stránku s údaji o této osobě.<br />Další nápověda o přidávání Oblíbených je k dispozici na vstupní bráně.";
$pgv_lang["header_theme_help"]		= "~Oblast hlavičky: Změnit motiv~<br />Je-li povoleno administrátorem, zobrazí se rolovací menu s výběrem motivu vzhledu pro tyto stránky. Vyberete-li jeden z motivů, změní se vzhled stránek. Jste-li navíc přihlášeni do systému, změní se také váš uživatelský motiv.";
$pgv_lang["menu_help"]				= "<div class='name_head center'><b>MENU</b></div><br />V záhlaví stránek máme rolovací menu.<br />Pohybem myší přes ikonu menu se vyvolá podmenu, pokud nějaké pro danou položku existuje.<br />Kliknutí na ikonu menu vás přesměruje na stránku, která je první položkou v podmenu.<br /><br /><b>Můžete si vybrat z následujících hlavních položek:</b><ul><li><a href=\"#menu_fam\">#pgv_lang[welcome_page]#</a><br /><li><a href=\"#menu_myged\">Vstupní brána Mygedview</a><br /><li><a href=\"#menu_charts\">Schémata</a><br /><li><a href=\"#menu_lists\">Seznamy</a><br /><li><a href=\"#menu_annical\">Kalendář výročí</a><br /><li><a href=\"#menu_clip\">#pgv_lang[clippings_cart]#</a><br /><li><a href=\"#menu_search\">Hledání</a><br /><li><a href=\"#menu_rslog\">Badatelsý zápisník</a><br /><li><a href=\"#menu_help\">Nápověda</a></ul>";
$pgv_lang["menu_famtree_help"]		= "~Menu úvodní stránky~<br />V menu jsou zařazeny všechny dostupné GEDCOMy. Každý GEDCOM má svou vlastní Úvodní stránku jako je tato.<br />Je-li na těchto stránkách právě jeden GEDCOM, žádné podmenu pod ikonkou Úvodní stránky nenajdete.";
$pgv_lang["menu_myged_help"]		= "~Menu vstupní brány MyGedView~<br />Jste-li přihlášeni, toto menu může obsahovat následující položky:<dl><dt>Vstupní brána MyGedView</dt><dd>vás zavede na vaši vlastní \"úvodní stránku\".</dd><dt>Můj účet</dt><dd>Tady můžete upravovat svá osobní data.</dd><dt>Můj vývod</dt><dd>Pokud jste zvolili pro tento GEDCOM výchozí osobu, tento odkaz vás zavede na stránku s jejím vývodem.</dd><dt>Já</dt><dd>Tento odkaz vás přesměruje na stránku o vaší osobě, kde jsou zobrazena všechna genealogická data o vás a vaší rodině.</dd></dl>";
$pgv_lang["menu_charts_help"]		= "~Menu schémat~<br />Pod touto položkou menu jsou zařazena všechna dostupná schémata:<dl><dt><a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a></dt><dd>Tento odkaz vás zavede na stránku s vývodem pro aktuální GEDCOM. Vývod začíná výchozí osobou GEDCOMu. Pokud jste však přihlášeni, výchozí osobou můžete být vy nebo někdo jiný dle vašeho výběru.</dd><dt><a href=\"?help=help_descendancy.php\">#pgv_lang[descend_chart]#</a></dt><dd>Rozrod je víceméně <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a> v obráceném sledu.<br />Toto srovnání není úplně nejvhodnější, avšak, zatímco vývod zobrazuje všechny předky výchozí osoby, rozrod vám ukáže všechny potomky této (výchozí) osoby.</dd><dt><a href=\"?help=help_timeline.php\">#pgv_lang[timeline_chart]#</a></dt><dd>Časová osa</dt><dd>Zde si můžete prohlédnout události u dané osoby zachycené na časové ose.<br />Je velmi zajímavé porovnávat události dvou či více osob na jedné ose.</dd><dt><a href=\"?help=help_relationship.php\">#pgv_lang[relationship_chart]#</a></dt><dd>Tady můžete najít příbuzenské vztahy nějaké osoby s vámi nebo jinou osobou.</dd><dt><a href=\"?help=help_ancestry.php\">#pgv_lang[ancestry_chart]#</a></dt><dd>Velmi podobné na <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, ale zahrnuje více informací a střídá <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a> zobrazení.</dd><dt><a href=\"?help=help_fanchart.php\">#pgv_lang[fan_chart]#</a></dt><dd>Velmi podobné na <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, ale s větším důrazem na grafickou podobu.</dd></dl>";
$pgv_lang["menu_lists_help"]		= "~Menu seznamů~<br />K dispozici jsou následující seznamy:<dl><dt><a href=\"?help=help_indilist.php\">#pgv_lang[individual_list]#</a></dt><dt><a href=\"?help=help_famlist.php\">#pgv_lang[family_list]#</a></dt><dd>V těchto dvou seznamech můžete procházet abecední seznam lidí z tohoto GEDCOMu.<br />První z nich zobrazí seznam jednotlivců a druhý seznam rodin.</dd><dt><a href=\"?help=help_sourcelist.php\">#pgv_lang[source_list]#</a></dt><dd>Pod touto položkou se skrývá seznam všech pramenů užitých v GEDCOMu.</dd><dt><a href=\"?help=help_placelist.php\">#pgv_lang[place_list]#</a></dt><dd>Tady můžete vyhledávat lidi podle místa. Zobrazí se vám dvousloupcový seznam. Osoby jsou seřazeny vlevo, rodiny vpravo.</dd><dt><a href=\"?help=help_medialist.php\">#pgv_lang[media_list]#</a></dt><dd>Tuto položku uvidíte jedině v případě, že je zapnuta administrátorem.<br />Kliknete-li na ni, zobrazí se vám odkazy na všechny multimediální soubory užité v tomto GEDCOMu.</dd></dl>";
$pgv_lang["menu_annical_help"]		= "~Menu kalendáře výročí~<br />Kalendář výročí zobrazuje události vztahující se k zvolenému datu, měsíci či roku.<dl><dt><a href=\"?help=day_month_help\">#pgv_lang[viewday]#</a></dt><dd>Kliknutím na tuto položku menu se dostanete do Kalendáře výročí, který vám ukáže události pro aktuální den.</dd><dt><a href=\"?help=day_month_help\">#pgv_lang[viewmonth]#</a></dt><dd>Kliknutím na tuto položku menu se dostanete do Kalendáře výročí, který vám ukáže události pro aktuální měsíc.</dd><dt><a href=\"?help=day_month_help\">#pgv_lang[viewyear]#</a></dt><dd>Přes tento odkaz se dostanete do Kalendáře výročí tak, že vám ukáže události pro daný rok.</dd></dl>";
$pgv_lang["menu_clip_help"]			= "~Menu schránky výstřižků~<br />Je-li tato volba zapnuta administrátorem, uvidíte ji v liště menu.<br />Schránka výstřižků vám umožňuje vybrat osoby, rodiny a prameny a uložit si je jako \"ústřižky rodokmenu\" do Schránky výstřižků, kterou si pak můžete stáhnout v podobě souboru GEDCOM 5.5.";
$pgv_lang["menu_search_help"]		= "~Menu hledání~<br />Vyhledávácí stránka, kam se dostanete klinutím na tento odkaz, je mocnější vyhledávací nástroj než odkaz Hledat, který můžete najít v záhlaví.";
$pgv_lang["menu_help_help"]			= "~Menu nápovědy~<br />#pgv_lang[help_help_items]#";
$pgv_lang["index_portal_head_help"]		= "<div class='name_head center'><b>ÚVODNÍ STRANA</b></div>";
$pgv_lang["index_portal_help"]			= "Úvodní stránka se skládá z několika oddělených bloků a je možné ji upravovat. Takže pro každý GEDCOM (tzn. je-li dostupných více GEDCOMů), můžete vidět jinou úvodní stranu.<br /><br /><b>V závislosti na tom, jak administrátor nastavil tento systém můžete na úvodní straně vidět některé z těchto bloků:</b><ul><li><a href=\"#index_welcome\">Úvodní</a><li><a href=\"#index_login\">Přihlašovací</a><li><a href=\"#index_events\">Nadcházející události</a><li><a href=\"#index_onthisday\">Tohoto dne ve vaší historii...</a><li><a href=\"#index_favorites\">Oblíbené GEDCOMu</a><li><a href=\"#index_stats\">Statistika GEDCOMu</a><li><a href=\"#index_common_surnames\">Nejčastější příjmení</a><li><a href=\"#index_media\">Náhodný obrázek</a><li><a href=\"#index_loggedin\">Přihlášení uživatelé</a><li><a href=\"#gedcom_news\">Novinky GEDCOMu</a><li><a href=\"#recent_changes\">Poslední změny</a></ul>";
$pgv_lang["index_welcome_help"]			= "~UVÍTACÍ BLOK~<br />Tento uvítací blok vám ukazuje:<br />Aktuální soubor GEDCOM, datum a čas a (je-li povoleno adminem) <b>Počítadlo přístupů</b>.<br />Toto počítadlo najdete pouze v uvítacím bloku a na stránce s osobními údaji.<br />Počítadlo zaznamenává počet přístupů k těmto stránkám. To znamená: kolikrát byly tyto stránky navštíveny.<br />Počítadlo nekontroluje URL návštěvníka, takže, když někdo stránku po nějakém čase znovu navštíví, bude započítán jako další návštěvník.";
$pgv_lang["index_login_help"]			= "~BLOK PŘIHLÁSIT SE~<br />Ačkoliv je možné se přihlásit téměř na každé stránce tohoto programu, je nejlepší přihlásit se hned na první stránce, neboť máte přístup k dalším informacím.<br />Přihlásíte se vložením <b>uživatelského jména</b> a <b>hesla</b> a kliknutím na tlačítko \"Přihlásit se\".";
$pgv_lang["index_events_help"]			= "~BLOK NADCHÁZEJÍCÍCH UDÁLOSTÍ~<br />V tomto bloku uvidíte události ode dneška do konce měsíce.<br />Jsou to všechny události uložené v GEDCOMu.";
$pgv_lang["index_onthisday_help"]		= "~BLOK \"TENTO DEN VE VAŠÍ HISTORII\"~<br />Tento blok má podobné vlastnosti jako blok Nadcházejících událostí, zde se vám však zobrazí pouze události vážící se k dnešku.";
$pgv_lang["index_favorites_help"]		= "~BLOK OBLÍBENÝCH GEDCOMU~<br />Blok Oblíbených GEDCOMu je víceméně podobný bloku \"Mé oblíbené\" na vstupní bráně MyGedView. Ale v tomto případě může přidávat, mazat a měnit oblíbené pouze administrátor stránek nebo uživatel s právy administrátora.<br />Účelem Oblíbených GEDCOMu je upozornit na osobu či osoby zvlášť důležité.<br />V záhlaví každé strany vašich stránek je k dispozici rolovací seznam \"Oblíbené tohoto GEDCOMu\".<br />Tk budete přesměrováni na stránku s údaji o dané osobě.<br /><br />Rámeček obsahující jméno oblíbené osoby je kvůli úspornosti zobrazen s minimem informací o této osobě. V pravé části rámečku je ikonka lupy, pomocí níž můžete získat nějaké další informace.<br />Kliknete-li na jméno, přesunute se na stránku s údaji o dané osobě.<br />Na pravé straně také najdete menu, které vás může zavést na stránky s dalšími informacemi nebo schématy.";
$pgv_lang["index_stats_help"]			= "~BLOK SE STATISTIKOU GEDCOMU~<br />V tomto bloku vidíte statistické údaje o aktuálním souboru GEDCOM.<br />Chcete-li více informací, můžete poslat zprávu na kontaktní adresu na zápatí stránky.<br />#pgv_lang[index_common_names_help]#";
$pgv_lang["index_common_names_help"]		= "~BLOK S NEJČASTĚJŠÍMI PŘÍJMENÍMI~<br />V tomto bloku jsou zobrazena příjmení, která se v tomto GEDCOMu vyskytují nejčastěji.<br />Minimální četnost výskytu jednoho příjmení potřebnou k tomu, aby příjmení bylo zařazeno mezi nejčastější může nastavit administrátor.<br />(Současné nastavení tohoto limitu je #COMMON_NAMES_THRESHOLD#)<br />Na jména můžete kliknout. Jedním kliknutím na jméno se dostanete na #pgv_lang[individual_list]#, kde získáte další informace o tomto jménu.";
$pgv_lang["index_media_help"]			= "~BLOK S NÁHODNÝM OBRÁZKEM~<br />Program vybere náhodně mediální soubor, který vám ukáže v tomto bloku při návštěvě této stránky.<br />Kliknete-li na tento obrázek nebo jeho název, uvidíte jej v původní velikosti.<br />Pod obrázkem je odkaz na osobu, ke které je obrázek připojen.<br />Kliknutím na toto jméno budete přesměrováni na stránku s údaji o této osobě.";
$pgv_lang["index_loggedin_help"]		= "~BLOK PŘIHLÁŠENÝCH UŽIVATELŮ~<br />V tomto bloku zjistíte, kolik uživatelů je právě teď připojeno.";
$pgv_lang["index_gedcom_news_help"]		= "~BLOK NOVINEK GEDCOMU~<br />Blok Novinek GEDCOMu je něco jako billboard tohoto GEDCOMu.<br />Administrátor sem může umístit důležitá oznámení nebo zajímavé novinky.<br /><br />Máte-li něco zajímavého k zobrazení, kontaktujte prosím administrátora a on vaši zprávu bude moct přidat.";
$pgv_lang["recent_changes_help"]			= "~BLOK POSLEDNÍCH ZMĚN~<br />V tomto bloku se objeví poslední změny, jež byly v GEDCOMu provedeny, jak je v souboru GEDCOM zaznamenáno pomocí tagů CHAN.";
$pgv_lang["help_help"]				= "Samozřejmě, že by bylo skvělé vyrobit program, jehož ovládání by bylo tak jednoduché, že by nepotřeboval vůbec žádné vysvětlivky.<br />Mělo by to být stejně snadné jako četba knihy.<br />Ačkoliv je program poměrně složitý, v uživatelském rozhraní to nepoznáte. Téměř vše se dá použít bez nápovědy.<br />Ale, poněvadž máme hodně návštěvníků a uživatelů, kteří nemají moc zkušeností s prací na počítači nebo na internetu, nabízíme často na určitých místech nápovědu.<br />V menu nápovědy najdete následující položky:";
$pgv_lang["help_page_help"]			= "<dl><dt><b>Nápověda k této stránce</b></dt><dd>Pro všechny stránky je dostupná obecná nápověda.<br />Když jste na nějaké stránce, můžete kliknout na tuto položku v menu a otevře se vám okno s nápovědou informující o položkách, jež najdete na dané stránce.<br />Nápověda ke stránce je většinou stručná.<br />Chcete-li další nápovědu nebo informaci o určité položce na stránce, pak je zde třetí volba menu: \"Kontextová nápověda\".</dd></dl>";
$pgv_lang["help_content_help"]			= "<dl><dt><b>Obsah nápovědy</b></dt><dd>Kliknete-li na tuto položku menu, vyskočí vám pop-up okno s nápovědou, kde uvidíte rejstřík hlavních položek nápovědy.<br />V rejstříku bude v dohledné době více položek, neboť budou zahrnuty i ostatní položky.</dd></dl>";
$pgv_lang["help_qm_help"]			= "<dl><dt><b>Skrýt / Ukázat Kontextovou nápovědu</b></dt><dd>Tato poslední položka menu může být pro vás nejužitečnější. Kliknutí na tuto volbu buď zapne nebo vypne kontextovou nápovědu.<br />Co je to \"Kontextová nápověda\"?<br />Je-li zapnuta, najdete u některých odkazů, tlačítek a políček otazník. Kliknutí na tento <b>?</b> vyvolá malé okénko s nápovědou k danému objektu.<br />Samozřejmě, že když kliknete na \"Skrýt kontextovou nápovědu\", všechny otazníky budou skryty do té doby, než kliknete znovu na \"Zobrazit...\".</dd></dl>";
$pgv_lang["def_help"]				= "<div class='name_head center'><b>DEFINICE</b></div><br />Definice některých výrazů užívaných v této nápovědě:<ul><li><a href=\"#def_gedcom\">GEDCOM</a><br /><li><a href=\"#def_gedcom_date\">Data</a><li><a href=\"#def_pgv\">PhpGedView</a><li><a href=\"#def_portal\">Vstupní brána (portál)</a><li><a href=\"#def_theme\">Motiv</a></ul>";
$pgv_lang["def_portal_help"]			= "~Vstupní brána~<br />Vstupní brána těchto stránek je něco jako vestibul restaurace. Je to místo, kde můžete najít důležité informace jako vysvětlivky, menu atd..";
$pgv_lang["def_gedcom_help"]			= "~Soubor GEDCOM~<br />Soubor GEDCOM je soubor obsahující všechny informace o rodu.<br />Všechny údaje, data, události atd. jsou ukládány v souboru GEDCOM.<br />Pro soubor GEDCOM platí přísná pravidla, protože musí umoňovat předávání dat mezi všemi genealogickými programy nezávisle na platformě či systému.";
$pgv_lang["def_gedcom_date_help"]		= "~Data v souboru GEDCOM~<br />Poněvadž formáty v souborech GEDCOM musí odpovídat mezinárodním pravidlům, je tam i uvedení zápisu data.<br /><br />Ačkoliv políčko pro datum v GEDCOM souboru může obsahovat dokonce jen text, zde je vysvětlení správného zapisování dat:<br />Celé datum se vkládá jako DD MMM YYYY - tj.:<br />01 Mar 1801 nebo 14 Dec 1950<br />Pokud vám část data chybí, můžete ji v zápisu vynechat, jako např.:<br />Mar 1801 nebo 14 Dec<br />Pokud si nejste jistí nebo datum není potvrzené, mohli byste napsat:<br />abt Mar 1801 (abt = kolem)<br />bef 20 Dec 1950 (bef = před)<br />aft 1949 (aft = po)<br />Ujistěte se, že jste zadali tato data a zkratky v angličtině, protože program pak vše přeloží sám do zvoleného jazyka.<br />Navíc program sám musí s daty počítat. Pokud budou data zadána ve špatném formátu, program nebude schopný s nimi správně pracovat.";
$pgv_lang["def_pgv_help"]			= "~PhpGedView~<br />PhpGedView (nebo PGV) je program zobrazující soubory GEDCOM online vytvořený Johnem Finlayem.<br />Jak si můžete všimnout, tento program nevytváří pouhé statické webové stránky, ale je dynamický a je možné jej v mnoha směrech upravovat.<br />John jej začal vyvíjet sám, ale v současnosti na něm pracuje mezinárodní tým vývojářů a překladatelů.<br />Kromě pouhého prohlížení souborů GEDCOM, může dnes uživatel přidávat a upravovat události online.";
$pgv_lang["def_theme_help"]			= "~Motiv~<br />Stránky mohou mít různé \"podoby\", jimž se říká motivy.<br />Administrátor stránek vybírá počáteční motiv.<br />Každý, kdo na tyto stránky vstoupí, spatří stejný vzhled (motiv). Pokud to administrátor umožní v nastavení programu, mohou si přihlášení uživatelé vybrat svůj vlastní motiv.<br />Jestliže si uživatel vybral jiný motiv, uvidí jej hned po přihlášení.";
$pgv_lang["mygedview_portal_help"]		= "~#pgv_lang[mygedview]#~<br />Toto je vaše osobní stránka #pgv_lang[mgv]#.<br />Na této stránce jsou odkazy na vaše osobní data, např. <b>Můj účet, Já</b> (to je stránka s GEDCOM údaji o vaší osobě), <b>Můj vývod</b>.<br />Dále zde můžete mít blok se <b>Zprávami</b>, <b>Deník</b> (jako poznámkový blok) a mnoho dalšího.<br /><br />Rozvržení této stránky je stejné jako u úvodní (uvítací) stránky.<br />Zatímco úvodní strana je spravována pouze administrátorem, tuto stránku si můžete upravit podle svého (vybrat z nabízených bloků pro zobrazení).<br /><br />V úvodním bloku této strany najdete odkaz pro úpravu této stránky.<br /><b>Můžete si vybrat z následujících bloků:<br /><br /></b><ul><li><a href=\"#mygedview_welcome\">Úvodní</a><li><a href=\"#mygedview_customize\">Upravit MyGedView</a><li><a href=\"#mygedview_message\">Zprávy</a><li><a href=\"#mygedview_events\">Nadcházející události</a><li><a href=\"#mygedview_onthisday\">Tohoto dne ve vaší histori...</a><li><a href=\"#mygedview_favorites\">Moje oblíbené</a><li><a href=\"#mygedview_stats\">Statistika GEDCOMu</a><li><a href=\"#mygedview_myjournal\">Můj deník</a><li><a href=\"#mygedview_media\">Náhodný obrázek</a><li><a href=\"#mygedview_loggedin\">Přihlášení uživatelé</a><li><a href=\"#mygedview_recent_changes\">Poslední změny</a></ul>";
$pgv_lang["mygedview_customize_help"]		= "~ÚPRAVA #pgv_lang[mygedview]#~<br />Když jste sem vstoupili poprvé, už jste na této stránce měli nějaké bloky.<br />Chcete-li, můžete si svou vstupní bránu uzpůsobit.<br />Kliknutí na tento odkaz vás přenese do formuláře v pop-up okně, kde budte moci bloky přidat, smazat nebo přesunout.<br />Další nápověda je k dispozici u formuláře.";
$pgv_lang["mygedview_message_help"]		= "~BLOK ZPRÁV~<br />V tomto bloku najdete zprávy, které vám zaslali ostatní uživatelé nebo admin.<br />Samozřejmě můžete i vy sami poslat zprávy ostatním uživatelům nebo adminovi.<br />E-mailový systém PhpGedView je vytvořen tak, aby chránil vaše soukromí. Nemusíte sem zadávat svou e-mailovou adresu a ostatní uživatelé ji tak neuvidí.<br /><br />Chcete-li e-mail zvětšit, klikněte na značku \"+\" vedle e-mailu. Když zaškrtnete políčka vedle zpráv, které chcete smazat, a potom kliknete na tlačítko \"Smazat označené zprávy, odstraníte všechny označené zprávy najednou.";
$pgv_lang["mygedview_favorites_help"]		= "~BLOK MÝCH OBLÍBENÝCH~<br />Moje oblíbené fungují podobně jako  záložky v knize.<br />Předpokládejme, že máte v rodokmenu někoho, jehož záznam si chcete prohlížet pravidelně.<br />Běžte tedy na stránku této osoby a klikněte na odkaz \"Přidat do Mých oblíbených\". U této osoby je teď záložka a je přidána do vašeho seznamu Oblíbených.<br />Ať jste kdekoliv na stránkách, můžete kliknout na jméno z rolovacího seznamu v záhlaví \"Mé oblíbené\".<br />To vás přesměruje na osobní stránku této osoby.<br /><br />Kvůli ušetření místa jsou rámečky zobrazeny s minimem informací. Napravo v rámečku vidíte lupu, pomocí níž můžete získat další informace.<br />Kliknutí na jméno vás přesměruje na osobní stránku této osoby.<br />Na pravé straně uvidíte menu, které vás navede na stránky s dalšími informacemi nebo schématy.";
$pgv_lang["mygedview_myjournal_help"]		= "~BLOK \"MŮJ DENÍK\"~<br />Do tohoto deníku můžete zapisovat poznámky (nebo připomínky) pro vlastní potřebu.<br />Samozřejmě, že poznámka, kterou vložíte, zde bude i při vaší další návštěvě.<br /><br />Tyto poznámky jsou pro ostatní neviditelné.";
$pgv_lang["mygedview_welcome_help"]		= "~UVÍTACÍ BLOK ~<dl><dt>Tento uvítací blok zobrazuje:</dt><dd>- Aktuální GEDCOM soubor</dd><dd>- Datum a čas</dd><dd>- Odkazy na:</dd><dd> - - #pgv_lang[myuserdata]#</dd><dd>- - #pgv_lang[my_pedigree]# (přečtěte si komentář)</dd><dd>- - #pgv_lang[my_indi]# (přečtěte si komentář)</dd><dd>- - #pgv_lang[customize_page]#</dd></dl><b>Komentář</b><br />Odkazy na \"Já\" a \"Můj vývod\" uvidíte jedině tehdy, pokud je v souboru GEDCOM o vás záznam.<br />Takže je možné, že v jednom GEDCOM souboru jste zapsán a uvidíte odkazy \"Já\" a \"Můj vývod\", zatímco v jiném GEDCOMu záznam o vás není a odkazy \"Já\" a \"Můj vývod\" pak nebudou zobrazeny.";
$pgv_lang["help_pedigree.php"]			= "~STRÁNKA S VÝVODEM~<br /><br />Většina uživatelů a návštěvníků bude vědět, co je to vývod, ale přece něco málo o našem vývodu:<br />Vývod je ve skutečnosti výčet všech předků výchozí osoby.<br />Když jste vstoupili na tuto stránku, viděli jste vývod osoby, která byla v rámečku úplně vlevo (když se přihlásíte, můžete si zvolit vlastní výchozí osobu).<br /><br />Takže, \"všichni předci\" znamená otec a matka a jejich rodiče a tak dále.<br />Na těchto stránkách vidíte vývod v grafické podobě.<br />Nemusíte se prodírat stranami textu, abyste zjistili, kde jsou vaši předkové.<br />Všechny osoby jsou na obrazovce zobrazeny v rámečcích.<br /><br />* RÁMEČKY VE VÝVODU<br />Je-li u stránky s vývodem nastaveno zobrazování podrobností, uvidíte jméno osoby, datum narození a úmrtí.<br />Na jméno osoby můžete kliknout a to vás zavede přímo na stránku s osobními údaji.<br />Když je zapnuta volba \"Zobrazit podrobnosti\", jsou v rámečku dvě ikonky.<br /><br />* IKONA VÝVODU<br />Když je zapnuta volba \"Zobrazit podrobnosti\", vidíte uvnitř rámečku ikonku vývodu. V závislosti na nastavení stránek musíte přejet přes ikonu myší, nebo na ni kliknout.<br />Takže, když na ni kliknete, nebo přes ni přejedete myší, objeví se vám malé podmenu.<br />Položka \"Vývod\" a \"Rozrod\" se podobají polložkám v hlavním menu, ale rozdíl je v tom, že v tomto případě bude výchozí osobou schématu osoba , jejíž jméno je v daném rámečku.<br />Dále vidíte \"Rodina s partnerem\". Vidíte jméno partnera následováno jmény dětí.<br />Na všechna jména se dá kliknout.<br /><br />* LUPA<br />Opět v závisloti na nastavení stránek musíte na ikonu buď kliknout, nebo přes ni přejet myší.<br />Lupa zvětší rámeček se jménem, takže se zobrazí některé další podrobnosti.<br />Uvidíte více dat a událostí. Na jména můžete kliknout.<br /><br />* ŠIPKY<br />Nalevo nebo napravo od úplně krajních rámečků můžete vidět šipky.<br />Kliknutím na jednu ze šipek posunete schéma v daném směru.<br /><br />Další nápověda je k dispozici po kliknutí na <b>?</b> za rámečky nebo odkazy na stránce.";
$pgv_lang["show_full_help"]			= "~SKRYTÍ NEBO ZOBRAZENÍ PODROBNOSTI~<br /><br />Touto volbou můžete podrobnosti v políčkách osob buď zobrazit nebo skrýt.<br /> Jestliže necháte podrobnosti skrýt, budete moci na obrazovce zobrazit větší schéma (rodokmen).<br /><br />Pokud zvolíte skrýt podrobnosti můžete si zobrazit skryté informace použitím lupy, je-li v normálním režimu (pohledu) zapnuta.<br />To záleží na tom, jak admin nakonfiguroval tento program.<br />Pokud musíte pro zvětšení rámečku na lupu kliknout, pak doplňující informace získáte také kliknutím na rámeček se jménem.<br />Pokud pro přiblížení stačí najet na ikonku lupy, pak to fungovat naprosto stejně, najedete-li na \"jednoduchý\" rámeček.";
$pgv_lang["talloffset_help"]			= "~FORMÁT ZOBRAZENÍ~<br /><br />Tímto nastavením určujete formát zobrazení.<br /> Změna tohoto nastavení se může hodit, pokud chcete tisknout nebo pokud máte jiný typ obrazovky. Zvolíte-li možnost \"na výšku\", rodokmen bude užší, takže 4-generační schéma v režimu \"na výšku\" by se mělo vejít na jednu stranu. Volba \"na šířku\" zapříčiní zobrazení širšího schématu, které by se mělo vejít na jednu stránku na šířku.";
$pgv_lang["rootid_help"]			= "~NOVÝ STŘEN~<br /><br />Jestliže chcete zobrazit rodokmen s jiným střenem (jinou \"počáteční\" osobou), pak do tohoto políčka můžete napsat ID této osoby.<br /> Pokud neznáte její ID, použijte odkaz <b>>Najít ID<</b>.<br /><br /><b>ČÍSLO ID</b><br />Číslo ID je jednoznačný identifikátor. Bylo vygenerováno programem, ve kterém byl vytvořen tento soubor GEDCOM.";
$pgv_lang["PEDIGREE_GENERATIONS_help"]		= "~POČET GENERACÍ~<br /><br />Tady můžete nastavit počet generací, který se má zobrazit v rodokmenu na jedné stránce.<br />Volba čísla záleží na velikosti vaší obrazovky a pak, jestli si necháváte zobrazovat podrobnosti nebo ne.";
$pgv_lang["login_page_help"]			= "~VSTUPNÍ STRÁNKA~<br /><br />Na této stránce se můžete přihlásit do systému, požádat o nové heslo nebo nový uživatelský účet.";
$pgv_lang["username_help"]			= "~UŽIVATELSKÉ JMÉNO~<br /><br />Do tohoto políčka vepište své uživatelské jméno.<br />Rozlišují se velká a malá písmena!";
$pgv_lang["password_help"]			= "~HESLO~<br /><br />Do tohoto políčka vepište své heslo.<br />Rozlišují se velká a malá písmena!";
$pgv_lang["login_buttons_help"]			= "~VSTUPNÍ TLAČÍTKA~<br /><br />Tady vidíte dvě tlačítka, pomocí nichž se můžete přihlásit do systému.<br />Zvolte možnost podle toho, jak chcete po přihlášení dále pokračovat.<br /><br />* Tlačítko <b>#pgv_lang[login]#</b><br />Jestliže kliknete na toto tlačítko, budete po přihlášení přesměrováni na stránku, ze které jste sem přišli.<br />Takže, když kliknete na \" #pgv_lang[login]# \" a budete právě na stránce s rozrodem, budete po přihlášení přesměrováni zpět na rozrod.<br /><br />* Tlačítko <b>#pgv_lang[mygedview]#</b><br />Pokud máte práva administrátora, můžete kliknout na toto tlačítko a dostanete se na hlavní stránku administrace.";
$pgv_lang["login_buttons_aut_help"]		= "~AUTENTIFIKAČNÍ REŽIM~<br /><br />VSTUPNÍ TLAČÍTKA<br /><br />Zde vidíte dvě tlačítka pro přihlášení do systému.<br />Na výběru tlačítka záleží, jak budete pokračovat.<br /><br />* Tlačítko <b>#pgv_lang[login]#</b><br />Pokud kliknete na toto tlačítko, dostanete se do systému, a to přímo na svou osobní stránku, kde si můžete změnit nastavení, přidat nebo upravit oblíbené, posílat a číst zprávy a tak dále.<br /><br />* Tlačítko <b>#pgv_lang[mygedview]#</b><br />Když kliknete na toto levé tlačítko, dostanete se do systému, a to přímo na svou osobní stránku, kde si můžete upravit své nastavení, přidat nebo upravit oblíbené, posílat a číst zprávy a tak dále.<br /><br />* Tlačítko <b>#pgv_lang[admin]#</b><br />Jestliže máte práva admina, můžete kliknout na toto tlačítko, dostanete se přímo na hlavní stránku administrace.";
$pgv_lang["new_password_help"]			= "~ŽÁDOST O NOVÉ HESLO~<br />Pokud jste zapomněli své heslo, můžete kliknout na tento odkaz pro zažádání o nové heslo.<br />Budete přesměrováni na \"Stránku se žádostí o zaslání hesla\".";
$pgv_lang["new_user_help"]			= "~ŽÁDOST O NOVÝ UŽIVATELSKÝ ÚČET~<br /><br />Jste-li jen návštěvníkem těchto stránek a rádi byste zde měli účet, klikněte na tento odkaz.<br />Budete přesměrováni na \"Stránku registrace\".";
$pgv_lang["mygedview_login_help"]		= "Abyste měli přístup ke vstupní bráně MyGedView, musíte být registrovaným uživatelem tohoto systému.<br /><br />Pomocí vstupní brány MyGedView můžete vytvářet záložky u svých oblíbených osob, vést uživatelský deník, spravovat zprávy, mít přehled o jiných přihlášených uživatelích a lépe poznávat PhpGedView.<br /><br />Pro přihlášení do MyGedView zadejte do políček své uživatelské jméno a heslo.";
$pgv_lang["register_info_01"]		= "Množství dat, které může být veřejně zobrazeno na těchto stránkách, může být omezeno kvůli zákonům o ochraně osobních dat. Většina lidí si nepřeje, aby jejich osobní data byla veřejně dostupná na internetu. Mohlo by jich být zneužito k rozesílání spamu nebo ke krádeži osobnosti.<br /><br />Abyste měli přístup k soukromým údajům, musíte mít na těchto stránkách účet. Pro získání účtu se můžete zaregistrovat poskytnutím požadovaných informací. Potom, co administrátor vaši registraci zkontroluje a schválí, budete se moci přihlásit a zobrazit si soukromá data.<br /><br />Pokud je aktivována vyšší úroveň utajení, budete mít po přihlášení přístup jen k vlastním soukromým datům a soukromým údajům vašich nejbližších příbuzných. Administrátor také může poskytnout přístup k úpravám databáze, takže můžete měnit nebo přidávat informace.<br /><br />POZNÁMKA: Soukromá data obdržíte jedině v případě, že můžete dokázat, že jste blízcí příbuzní osoby v databázi.<br /><br />Jestliže nejste blízcí příbuzní, pravděpodobně nedostanete účet, takže byste si měli vyhnout možným problémům.<br />Pokud potřebujete další radu nebo informaci, prosím kontaktujte webmastera (odkaz dole).";
$pgv_lang["help_descendancy.php"]		= "~STRÁNKA S ROZRODEM~<br /><br />Tato stránka zobrazí potomky osoby.<br />Výchozí osobu tohoto schématu si můžete zvolit přímo na této stránce nebo sem můžete být přesměrováni z jiné stránky kliknutím na odkaz \"Rozrod\".<br />Chcete-li se posunout ve schématu nahoru, klikněte na horní šipku. Budete-li chtít vidět rozrod jiné osoby, klikněte na ikonu schématu v rámečku požadované osoby.";
$pgv_lang["desc_rootid_help"]			= "~NOVÝ STŘEN~<br /><br />Jestliže chcete zobrazit rozrod jiného střena, pak do tohoto políčka můžete zadat ID této osoby.<br /> Pokud neznáte její ID, použijte odkaz Najít ID.";
$pgv_lang["desc_generations_help"]		= "~POČET  GENERACÍ~<br /><br />Tady můžete nastavit počet generací k zobrazení na jedné stránce.<br />Co je nejlepší? To záleží na velikosti vaší obrazovky a pak, jestli máte zapnuto zobrazování podrobností nebo ne.";
$pgv_lang["help_timeline.php"]			= "~STRÁNKA S ČASOVOU OSOU~<br /><br />Na této stránce si můžete nechat zobrazit jednu, dvě či více osob na časové ose.<br />Tímto způsobem si můžete například znázornit stav dvou či více osob v určitý okamžik.<br /><br />Kliknete-li na odkaz Časová osa na jiné stránce, uvidíte jednu osobu na časové ose již hned po načtení stránky.<br />Jestliže jste klikli na položku z menu v záhlaví, pak musíte vepsat do rámečku \"ID\" osoby, s níž chcete začít.";
$pgv_lang["add_person_help"]			= "~PŘIDÁNÍ OSOBY NA ČASOVOU OSU~<br /><br />Na časové ose můžete mít více osob.<br />Do tohoto políčka vložte ID osoby.<br />Jestliže neznáte ID této osoby, můžete kliknout na odkaz \"Najít ID\" za rámečkem.";
$pgv_lang["remove_person_help"]			= "~ODSTRANĚNÍ OSOBY Z OSY~<br /><br />Klikněte na tento odkaz, chcete-li odstranit osobu z časové osy.";
$pgv_lang["show_age_marker_help"]		= "~ZOBRAZENÍ VĚKU~<br /><br />Pokud zaškrtnete toto políčko, uvidíte ukazatel věku, který můžete posouvat po ose.<br />Tento ukazatel věku je dobrý nástroj ke zjištění věku dané osoby v daném čase.<br />Ukazatel věku můžete zapnout nebo vypnout pro kteroukoliv osobu na ose";
$pgv_lang["help_relationship.php"]		= "~STRÁNKA SE SCHÉMATEM VZTAHU~<br /><br />Na této stránce si můžete znázornit příbuzenský vztah mezi dvěma lidmi.<br />Neznamená to, že by tyto osoby museli být přímo pokrevně příbuzné.<br />Nalezen bude jakýkoliv vztah.";
$pgv_lang["relationship_id_help"]		= "~ID čísla 1. a 2. osoby~<br /><br />Pokud jste se sem dostali přes odkaz z jiné stránky (například: kliknutím na odkaz \"Vztah ke mně\"), pak zde uvidíte příbuzenský vztah mezi těmito dvěma osobami.<br />Jinak musíte zadat ID těch dvou osob, jejichž vzájemný příbuzenský vztah chcete zobrazit.<br />Pokud tato ID neznáte, můžete kliknout na odkaz \"Najít ID\"";
$pgv_lang["next_path_help"]			= "~DALŠÍ VZTAHY~<br /><br />Na toto tlačítko můžete kliknout pro nalezení dalšího vztahu mezi těmito dvěma osobami, pokud takový existuje.<br />Předchozí nalezený vztah si můžete opětovně zobrazit kliknutím na odkaz s číslem vztahu.";
$pgv_lang["follow_spouse_help"]			= "~KONTROLA PŘÍBUZENSTVÍ SŇATKEM – ZAŠKRTÁVACÍ POLÍČKO~<br /><br />Je-li toto políčko <b>ne</b>zaškrtnuté, budou se hledat pouze pokrevní příbuzenské vztahy.<br />Je-li zaškrtnuté, budou se hledat i příbuznosti sňatkem. Necháte-li políčko zaškrtnuté, máte větší pravděpodobnost, že najdete více vztahů.";
$pgv_lang["line_up_generations_help"]	= "~VYROVNAT PODLE GENERAČNÍ ÚROVNĚ - ZAŠKRTÁVACÍ POLÍČKO~<br /><br />Je-li toto políčko zaškrtnuté, schéma se vytiskne tak, že potomci postavení na stejné generační úrovni, budou na stránce vodorovně srovnáni. Není-li políčko zaškrtnuto, každá generace se zobrazí na stránce směrem dolů bez ohledu na to, jestli je ve vztahu rodičů nebo dětí.";
$pgv_lang["oldest_top_help"]          = "~ZOBRAZIT NEJSTARŠÍ NAHOŘE - ZAŠKRTÁVACÍ POLÍČKO~<br /><br />Je-li toto políčko zaškrtnuté, budou se schémata tisknout s nejstaršími osobami nahoře.<br />Není-li zaškrtnuto, objeví se nahoře nejmladší lidé.<br /><br />PZN: Tato volba funguje pouze, pokud je zaškrtnuto <i>#pgv_lang[line_up_generations]#</i>.";
$pgv_lang["help_ancestry.php"]		= "~Stránka #pgv_lang[ancestry_chart]#~<br /><br />Přehled předků je velmi podobný na <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, ale obsahuje více informací a střídá <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a> zobrazení.<br /><br />Každý předek je zobrazen s jedinečným číslem, vypočítaným na základě <i>Sosa-Stradonitzova</i> systému :<br /> - sudá čísla pro muže (dítě*2)<br /> - lichá čísla pro ženy (manžel+1) s výjimkou <b>1</b><br /><br />Př.: <b>7</b> je manželka <b>6</b>, matka <b>3</b> a dcera <b>14</b> a <b>15</b>.";
$pgv_lang["box_width_help"]		= "~Šířka rámečku u #pgv_lang[ancestry_chart]#~</b><br /><br />Zde můžete nastavit šířku rámečku od 50% do 300%.<br />Normální hodnota je 100% : každé políčko je široké asi 270 pixelů.";
$pgv_lang["chart_style_help"]			= "~Styl #pgv_lang[chart_style]#~<br /><br /><dl><dt>#pgv_lang[chart_list]#</dt><dd>Svislý strom s rolovatelnými rodinami.</dd><dt>#pgv_lang[chart_booklet]#</dt><dd>Na jedné stránce je zobrazena jedna rodina - rodiče, prarodiče a všechny zaznamenané děti.<br />Jde jednoduše vytisknout a vy jej můžete dát svým příbuzným.</dd></dl>";
$pgv_lang["help_fanchart.php"]		= "~#pgv_lang[fan_chart]# page~<br /><br />Vějířové schéma je velmi podobné na <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, ale s důrazem na grafickou podobu.<br /><br />Výchozí osoba je zobrazena ve středu, její rodiče na první kružnici, prarodiče na druhé atd...<br /><br />Pokud je znám rok narození, sňatku a úmrtí, pak je zobrazen pod jménem.<br /><br />Kliknete-li na jméno ve schématu, získáte nový obraz, na němž bude zvolené jméno ve středu schématu. Poblíž výchozí osoby je šipka se skrytým menu, z něhož budete moci vybrat jako novou výchozí osobu některé z dětí nebo sourozenců výchozí osoby, což můžete udělat také pomocí <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>.";
$pgv_lang["fan_width_help"]		= "~Šířka #pgv_lang[fan_chart]#~</b><br /><br />Tady můžete nastavit šířku vějířového schématu od 50% do 300%.<br />Normální hodnota je 100% : výsledný obrázek má na šířku asi 640 pixelů.";
$pgv_lang["fan_style_help"]			= "~Styl - #pgv_lang[fan_chart]#~<br /><br /><dl><dt>1/2</dt><dd>Obloukový (180°) vějíř</dd><dt>3/4</dt><dd>Tří-čtvrteční (270°) vějíř nebo 'Andělské křídlo'</dd><dt>4/4</dt><dd>Úplný (360°) vějíř</dd></dl>";
$pgv_lang["help_indilist.php"]			= "~STRÁNKA SE SEZNAMEM OSOB~<br /><br />Na této stránce si můžete nechat zobrazit seznam osob.<br /><br />Jména budou zobrazena v abecedním pořadí, příjmení na prvním místě.<br />Výstup seznamu jmen závisí na:<br /><b>1.</b> písmeni, na něž jste klikli v abecedním rejstříku.<br /><b>2.</b> jestli jste klikli na \"Přeskočit\" nebo \"Zobrazit\" seznam příjmení.<br /><br />Jestliže k tomu potřebujete další nápovědu, klikněte prosím na ? za položkami.";
$pgv_lang["alpha_help"]				= "~ABECEDNÍ REJSTŘÍK~<br /><br />Po kliknutí na znak v abecedním rejstříku se vám zobrazí seznam jmen začínajících na písmeno, na něž jste klikli.<br />Na konci rejstříku může být <b>N.N.</b><br />Tato volba je zobrazena v případě, že v GEDCOMu jsou lidé, u nichž nebylo zadáno příjmení nebo nezačíná na žádné písmeno abecedy aktuálního jazyka.<br />Stejně tak neznámou osobu.<br /><br /><b>Pozor</b><br />Je-li příjmení osoby v GEDCOM záznamu zadáno například takto: Nn, NN, Neznám(a), nebo dokonce N.N., pak se jméno této osoby po kliknutí na <b>N.N.</b> <b>ne</b>zobrazí. Tyto osoby najdete pod \"<b>N</b>\" nebo \"<b>U</b>\" (pro příklad v tomto řádku).<br />Je tomu tak proto, že program kontroluje pouze, je-li v GEDCOM záznamu zapsáno příjmení.<br /><br />Na konci abecedního rejstříku vidíte \"<b>VŠECHNY</b>\". Kliknete-li na tento odkaz, zobrazí se vám seznam všech příjmení v GEDCOMu.<br /><br /><b>Scházejí některé znaky?</b><br />Může se stát, že některé znaky budou v rejstříku \"chybět\".<br />Ve skutečnosti však nechybí. Znamená to prostě, že příjmení začínající tímto znakem se v seznamu nevyskytuje.";
$pgv_lang["name_list_help"]			= "~SEZNAM JMEN~<br /><br />Toto políčko zobrazí buď seznam příjmení nebo seznam celých jmen.<br />V obou případech budou všechna příjmení začína znakem, na který jste klikli v abecedním rejstříku. Pokud ovšem nekliknete na \"VŠECHNY\"<br /><br />Jestli uvidíte seznam příjmení nebo celých jmen záleží na stavu odkazu pod tabulkou.";
$pgv_lang["skip_sublist_help"]			= "~PŘESKOČENÍ SEZNAMU PŘÍJMENÍ~<br /><br />Standardní nastavení je takové, že po kliknutí na písmeno dostanete nejdřív seznam příjmení.<br />Jestliže kliknete na tento odkaz, přeskočíte seznam příjmení a uvidíte hned seznam celých jmen.";
$pgv_lang["help_famlist.php"]			= "~STRÁNKA SE SEZNAMEM RODIN~<br /><br />Na této stránce si můžete zobrazit seznam rodin.<br /><br />Jména budou zobrazena v abecedním pořadí, příjmení na prvním místě.<br />Podoba zobrazeného seznamu závisí na:<br /><b>1.</b> písmenu, na které jste klikli v abecedním rejstříku.<br /><b>2.</b> tom, jestli jste klikli na \"Přeskočit\" nebo\"Zobrazit\" seznam příjmení.<br /><br />Můžete hledat jak mužská, tak ženská příjmení. Obojí jsou zahrnuta v seznamu.<br /><br />Potřebujete-li k tomu další nápovědu, klikněte prosím na ? za položkami.";
$pgv_lang["help_family.php"]			= "~STRÁNKA S PODROBNOSTMI O RODINĚ~<br /><br />Tato stránka vám ukáže přehled o rodině, kterou jste si vybrali na předchozí straně.<br />Odshora dolů uvidíte rámečky s těmito jmény:<br />Manžel a jeho rodiče.<br />Manželka a její rodiče<br />a děti.<br /><br />Vzhled a obsah rámečků je stejný jako na stránce s vývodem a rozrodem.<br />Napravo od rámečků se jmény rodičů uvidíte šipku (jsou-li v souboru další předkové). Kliknutím na šipku se posunete o jednu generaci na novou stránku, kde jsou rodiče zobrazeni jako manželé.<br />Po pravé straně <i>v</i> rámečku si můžete všimnout lupy, díky níž můžete získat další informace o daném jednotlivci. Kliknutí na jméno vás přesměruje na stránku s osobními údaji o tomto člověku.<br />Na pravé straně najdete ještě malé menu, které vás odkáže na stránky s dalšími informacemi nebo schématy.<br /><br />V Rodinných informacích jsou zobrazena všechna známá fakta a informace o této rodině jako sňatek, multimediální soubory a poznámky. Kliknutí na místo vás přesměruje na seznam míst, kde uvidíte seznam všech jednotlivců a rodin, které jsou s tímto místem spojeny. Kliknete-li na datum, dostanete se kalendáře, kde si budete moci prohlédnout všechny události, jež se ve vaší historii staly tohoto dne v tomto měsíci. Kliknout můžete také na multimediální objekty; tím se otevře nové okno, v němž si budete moci objekt prohlédnout. Pokud kliknete na odkaz na pramen, zobrazí se na stránce informace o tomto prameni.<br /><br />Pod rámečky se jmény dětí najdete odkaz \"Přidat dítě k této rodině\".<br />Vedle rámečků se jmény dětí uvidíte odkaz \"Informace o rodině\".<br />Máte-li patřičná práva, můžete zde upravovat, mazat a přidávat data a údaje.<br /><br />Na pravé straně obrazovky můžete vidět, je-li zapnuto adminem, tyto ikony a odkazy:<br /><b>Zobrazit přímo záznam GEDCOM</b>, který zobrazí informace v GEDCOM formátu.br /><b>Přidat do Schránky výstřižků</b>, jenž vám umožní uložit si zvolené informace do schránky. Odtud si je pak můžete stáhnout a naimportovat do svého genealogického programu.<br /><b>Zobrazit pár na časové ose</b>, který vás přesměruje na stránku s časovou osou, na níž zobrazí všechny údaje o rodině.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["add_child_help"]			= "~PŘIDÁNÍ DÍTĚTE DO RODINY~<br /><br />Kliknutím na tento odkaz můžete přidat k této rodině dítě.<br />Přidání dítěte je jednoduché: Prostě jen klikněte na odkaz, vyplňte políčka v pop-up okně a je to.";
$pgv_lang["show_fam_gedcom_help"]	= "~ZOBRAZIT ZÁZNAM GEDCOM~<br /><br />Po kliknutí na tento odkaz se informace o rodině (tak, jak je uložena v GEDCOMu) zobrazí v pop-up okně.";
$pgv_lang["add_fam_clip_help"]		= "~PŘIDAT RODINU DO SCHRÁNKY VÝSTŘIŽKŮ~<br /><br />Kliknete-li na tento odkaz, budete moci přidat informace o této rodině (tak, jak je uložena v GEDCOMu) do své Schránky výstřižků. Na další stránce si budete moci vybrat, které údaje konkrétně si budete přát přidat: jen tyto rodiče, nebo také jejich rodiče, nebo také jejich rodiče a/nebo také jejich děti a/nebo všechny potomky.";
$pgv_lang["show_fam_timeline_help"]	= "~ZOBRAZIT PÁR NA ČASOVÉ OSE~<br /><br />Po kliknutí na tento odkaz se dostanete na stránku s časovou osou, kde budou údaje o této rodině zobrazeny v časovém měřítku.";
$pgv_lang["help_sourcelist.php"]		= "~STRÁNKA SE SEZNAMEM PRAMENŮ~<br /><br />Na této stránce je zobrazen seznam pramenů.<br />Narozdíl od stránky s osobami a stránky s rodinami, tady chybí abecední rejstřík. Je to z toho důvodu, že pramen může být osoba, která má samozřejmě křestní jméno a příjmení, anebo to může veřejná databáze nebo instituce atd. atd.<br />To znamená, že je obtížné vymyslet způsob řazení. Názvy pramenů jsou seřazeny v abecedním pořadí tak, jak jsou uloženy v souboru GEDCOM.<br /><br /><b>PRAMENY</b><br />Bez pramenů bychom nemohli vybudovat svou rodopisnou databázi. Každá informace uložená v databázi pochází z nějakého zdroje. Může jím být příbuzný dané osoby, instituce, veřejná databáze apod.<br />Jeden pramen může být spojen s více osobami. Na druhou stranu, jedna osoba může být zase spojena s více prameny. Pro každou událost můžete mít jiný pramen, ať už je to datum narození, profese, sňatek, děti atd. atd.";
$pgv_lang["sourcelist_listbox_help"]		= "~SEZNAM PRAMENŮ~<br /><br />V této tabulce můžete vidět seznam pramenů, jak jsou uloženy v GEDCOMu.<br />Názvy jsou zobrazena v abecedním pořadí.<br /><br />Když kliknete na název ze seznamu, dostanete se na stránku tohoto pramene, kde bude zobrazen seznam osob, které jsou připojeny k tomuto prameni.";
$pgv_lang["help_source.php"]			= "~STRÁNKA S PODROBNOSTMI O PRAMENI~<br /><br />Na této stránce jsou zobrazeny podrobnosti o tomto prameni.<br />Můžete zde najít informace o názvu, autoru, vydání pramene a místě, kde byl vyhledán. Jelikož existuje mnoho typů pramenů, u nekterých z nich může být k dispozici více, u jiných méně údajů.<br /><br />Je-li k prameni připojen multimediální objekt (jako naskenovaný dokument), můžete si tento objekt prohlédnout ve velkém okně kliknutím buď na objekt nebo na název souboru uvedený vedle něj.<br /><br />Po podrobnostech o tomto prameni následuje seznam všech jednotlivců a rodin, kteří jsou k tomuto prameni napojeni. Tak máte možnost získat všechny informace, které byly z daného pramene získány.<br /><br />Je-li to povoleno adminem, budete mít na stránce menu s jedou nebo dvěma ikonami:<br /><b>Zobrazit přímo záznam GEDCOM</b> ukáže údaj v GEDCOM formátu.<br /><b>Přidat do Schránky výstřižků</b>, jež umožňuje ukládat vybrané informace do schránky. Odtud je můžete stáhnout a naimportovat do svého genealogického programu.<br /><br />Další nápověda je k dispozici po kliknutí na <b>?</b>";
$pgv_lang["sources_listbox_help"]		= "~ZÁZNAMY PŘIPOJENÉ K TOMUTO PRAMENI~<br /><br />V této tabulce si můžete prohlédnout seznam jmen osob či rodin připojených k tomuto prameni.<br />Jména jsou zobrazena v abecedním pořadí.<br /><br />Když kliknete na jméno za seznamu, dostanete se na stránku s podrobnými informacemi o jednotlivci či rodině.";
$pgv_lang["show_source_gedcom_help"]		= "~ZOBRAZENÍ GEDCOM ZÁZNAMŮ~<br /><br />Kliknutím na tento odkaz vyvoláte pop-up okno, v němž se vám zobrazí podrobnosti o prameni tak, jak jsou uloženy v GEDCOM souboru.";
$pgv_lang["add_source_clip_help"]		= "~PŘIDÁNÍ PRAMENE DO SCHRÁNKY VÝSTŘIŽKŮ~<br /><br />Kliknutím na tento odkaz můžete přidat pramen, jak je uložen v GEDCOM souboru, do schránky ústřižků.";
$pgv_lang["delete_source_help"]			= "~VYMAZÁNÍ PRAMENE Z GEDCOMu~<br /><br />Kliknutím na tuto volbu, označíte pramen, který se má z GEDCOMu vymazat.<br />Co to znamená?<br />Předpokládejme, že máte dobrý důvod odstranit tento pramen ze svého GEDCOMu. Můžete kliknout na odkaz a vyskočí vám pop-up okno s dotazem, jestli chcete pramen skutečně vymazat nebo jestli chcete příkaz zrušit.<br /><br />Pokud budete pokračovat v odstraňování pramene, za nějakou chvíli vám vyskočí pop-up okno se zprávou, že pramen byl vymazán.<br /><br />Budete-li pokračovat v prohlížení, všimnete si, že pramen je ještě pořád v databázi, stejně jako před vymazáním.<br /><br />To <b>není</b> chyba.<br />Administrátor stránek dostane zprávu, že v GEDCOMu byla provedena změna a že jste odstranili pramen.<br />Administrátor musí vaši změnu přijmout (nebo zamítnout). Není možné tento proces obrátit.<br />V případě nejasností vás administrátor kontaktuje.";
$pgv_lang["help_placelist.php"]			= "~HIERARCHIE MÍST~<br />(nebo též osoby v místech)<br /><br />Tady se můžete podívat, které osoby nebo rodiny jsou spojeny s jakým místem.<br /><br />Je-li mezi osobou nebo rodinou a nějakou událostí v určitém místě nějaké spojení, program vám jej najde.<br /><br />Výsledek je zobrazen ve dvou-sloupcovém seznamu:<br />Jeden sloupec je pro jednotlivce a druhý pro rodiny.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["ppp_default_form_help"]		= "~POŘADÍ MÍST~<br /><br /><b>IMPLICITNÍ POŘADÍ</b><br />To znamená, že v tomto GEDCOM souboru není stanoveno žádné pořadí.<br />V takovém případě je nastaveno implicitní pořadí podle předvolby na této stránce.<br /><br />Kdyby bylo v tomto GEDCOM souboru nalezeno jiné pořadí, bylo by se ukázalo mezi (...) a koncem řádku.";
$pgv_lang["ppp_match_one_help"]			= "~POŘADÍ MÍST~<br /><br />POŘADÍ PODLE GEDCOM<br />Místa jsou v pořadí, které bylo nalezeno v souboru GEDCOM.<br />To má vyšší prioritu než implicitní pořadí, která se naopak použije v případě, že v GEDCOMu žádné pořadí nalezeno není";
$pgv_lang["ppp_numfound_help"]			= "~NALEZENÉ VZTAHY K MÍSTŮM~<br /><br />Zde je zobrazen počet nalezených odpovědí.<br />Pokud ještě pořád vidíte tabulku se seznamem míst, znamená to, že jste dosud nedosáhli nejnižší úrovně.<br />Můžete zvolit zobrazení všech záznamů nalezených u tohoto místa nebo změnit kritéria vyhledávání kliknutím na jiné místo.";
$pgv_lang["ppp_levels_help"]			= "~HIERARCHIE MÍST~<br /><br />Zde jsou zobrazeny úrovně nalezené do tohoto okamžiku.<br />Tabulka ukazující seznam míst je ve skutečnosti podseznamem úrovně úplně nalevo.<br /><br />PŘÍKLAD:<br />(Implicitní) pořadí je: #pgv_lang[default_form]#<br />Jestliže jsme teď na \"horní úrovni\", pak se v tabulce zobrazí všechny země z GEDCOMu.<br />Pokud stávající úroveň ukazuje: \"U.S.A., Horní úroveň\" , pak budou v seznamu zobrazeny všechny státy v U.S.A.<br />atd.<br /><br />Můžete kliknout na úroveň, abyste se dostali zpět o jeden či více kroků.";
$pgv_lang["ppp_placelist_help"]			= "~SEZNAM MÍST~<br /><br />V tomto seznamu vidíte Místa nalezená pod zvoleným místem. Jestliže jste dosud nezvolili žádné místo, pak vidíte seznam všech míst na nejvyšší úrovni (např. zemí nebo států).<br /><br />Názvy míst v seznamu jsou odkazy, na které můžete kliknout.<br />Kliknutí na místo funguje jako filtr. Přenese vás na následující nižší úroveň.";
$pgv_lang["ppp_placelist_help2"]		= "~SEZNAM MÍST~<br /><br />V tomto seznamu můžete vidět místa, jež byla doposud nalezena.<br />Na názvy míst ze seznamu můžete klikat.<br />Kliknutí pracuje jako filtr. Přenese vás na následující nižší úroveň.<br />Seznam jmen se nezobrazí jedině v případě, že jste na nejvyšší úrovni. Na každé jiné úrovni dostanete seznam jednotlivců a/nebo rodin nalezených v daném místě.";
$pgv_lang["ppp_view_records_help"]		= "~ZOBRAZIT VŠECHNY ZÁZNAMY~<br /><br />Kliknete-li na tento odkaz, zobrazí se vám seznam všech jednotlivců a rodin, jež jsou spojeny s tímto místem. Když se dostanete na konec hierarchie míst (např. město), zobrazí se automaticky seznam jmen.";
$pgv_lang["ppp_name_list_help"]			= "~SEZNAM JMEN~<br /><br />Tato tabulka bude obsahovat seznam celých jmen jednotlivců nebo rodin, kteří mají něco společného s tímto místem.<br /><br />Na místa v seznamu můžete kliknout.<br />Když na některý název kliknete, dostanete se na stránku s podrobnostmi o tom jednotlivci nebo rodině.<br /><br />Můžete si také vybrat změnu svého označení – a to kliknutím na místo nahoře na tomto seznamu.";
$pgv_lang["help_medialist.php"]			= "~SEZNAM MULTIMÉDIÍ~<br /><br />Seznam multimediálních souborů zahrnuje všechny multimediální objekty (MMO), které se nachází v tomto GEDCOMu.<br /><br />V políčkách MMO najdete jeho název a jméno osoby nebo rodiny, ke které je tento objekt připojen. Na obojí můžete kliknout.<br /><br />Kliknete-li na jméno osoby nebo rodiny, dostanete se na stránku s osobními údaji nebo stránku o rodině.<br /><br />Kliknutí na název MMO má stejný efekt jako kliknutí na zmenšeninu (náhled) MMO.<br />V závislosti na formátu MMO (*.gif, *.jpg) se MMO otevře v interním PhpGedView-prohlížeči nebo v prohlížeči, jenž je připojen k vašemu internetovém prohlížeči.<br /><br />Kliknete-li na odkaz \"Zobrazit\" vedle osob nebo rodin, dostanete se na stránku s údaji o jednotlivci nebo rodině.";
$pgv_lang["help_uploadmedia.php"]		= "~NAHRÁVÁNÍ MEDIÁLNÍCH SOUBORŮ~<br /><br />Nahrávání souborů je jednoduché, takže zde jen doplňující informace.<br /><br /><b>Zmenšeniny</b><br />Zmenšeniny by měly mít velikost přibližně kolem 100px na šířku.<br />Název souboru musí být stejný jako u originálu (obr. v původní velikosti).<br /><br /><b>Nahrávání</b><br />Originály obrázků budou uloženy automaticky do složky ../media a zmenšeniny do ../media/thumbs/.<br /><br />#pgv_lang[readme_help]#";
$pgv_lang["help_calendar.php"]			= "~#pgv_lang[anniversary_calendar]#~<br /><br /><ul><li><a href=\"#calendar_general\">Základní informace</a><li><a href=\"#calendar_day\">#pgv_lang[day]#</a><li><a href=\"#calendar_month\">#pgv_lang[month]#</a><li><a href=\"#calendar_year\">#pgv_lang[year]#</a><li><a href=\"#calendar_show\">#pgv_lang[show]# / #pgv_lang[showcal]#</a><li><a href=\"#calendar_sex\">#pgv_lang[sex]#</a><li><a href=\"#calendar_event\">Událost</a><li><a href=\"#calendar_button\">Výběr režimu (tlačítka)</a><li><a href=\"#calendar_tip\">Tip</a></ul><br /><a name=\"calendar_general\"></a>Kalendář výročí zobrazuje osoby a rodiny napojené k událostem z určitého dne a/nebo měsíce nebo určitého časového úseku. Používá důmyslný filtrovací systém k tomu, aby vám ukázal správné datum nebo období.<dl><dt><b>Zobrazit <a href=\"#calendar_day\">den</a></b></dt><dd>Tato volba ukazuje události, k nimž došlo v určitý den nezávisle na zvoleném roku. Výstupem bude buď jednoduchý seznam jmen osob nebo rodin, nebo dvousloupcový seznam jednotlivců na jedné a rodin na druhé straně.</dd><dt><b>Zobrazit <a href=\"#calendar_month\">měsíc</a></b></dt><dd>V <b>Kalendáři</b> jsou jména osob i rodin zobrazena v políčkách dnů. Kalendář se zobrazí tak, jak vypadal v roce, který jste zadali do políčka roku. Zobrazeny jsou všechny události z minulosti až po zadaný rok.<br />V kombinaci s volbou \"<a href=\"#calendar_show\">#pgv_lang[recent_events]#</a>\" vám poskytne realistický pohled na to, jak vypadal kalendář vašich předků.</dd><dt><b>Zobrazit <a href=\"#calendar_year\">rok</a></b></dt><dd>Tato volba zobrazí události, jež se staly v určitém roce nebo v rozmezí určitých let. Výstupem bude buď jednoduchý seznam jmen osob nebo rodin, nebo dvousloupcový seznam jednotlivců na jedné a rodin na druhé straně.</dd></dl>Právě zobrazovaný den a měsíc jsou v menu kalendáře zvýrazněny.<br /><br />Na jména a data, která se objeví v seznamu nebo v kalendáři, můžete kliknout.<br />Kliknutím na jméno se přenesete na stránku s údaji o dané osobě či rodině. Kliknete-li na datum, dostanete se do režimu \"Dnes\" (nebo Rok), a tak získáte zobrazení všech událostí tohoto (zvoleného) dne a měsíce.<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_day\"></a> #pgv_lang[annivers_date_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_month\"></a> #pgv_lang[annivers_month_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_year\"></a> #pgv_lang[annivers_year_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_show\"></a> #pgv_lang[annivers_show_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_sex\"></a> #pgv_lang[annivers_sex_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_event\"></a> #pgv_lang[annivers_event_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_button\"></a> #pgv_lang[day_month_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_tip\"></a> #pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"]		= "~VÝBĚR DNE~<br />Výběr data zahrnuje dvě políčka (den a měsíc) a vstupní políčko, do něhož vložíte požadovaný rok.<br /><br />Když vstoupíte na tuto stránku, uvidíte dnešní datum. Když kliknete na tlačítko <b>Zobrazit den</b>, uvidíte všechny osoby spojené s nějakou událostí, která se odehrála toho dne.<br />Když kliknete na tlačítko <b>Zobrazit měsíc</b>, uvidíte všechny osoby spojené s nějakou událostí, která se odehrála v daném měsíci.<br />Které osoby uvidíte, záleží na tom, kterou položku jste zvolili ve výběru <b>Ukázat</b>.<br /><br /><b>TIP</b><br />Předpokládejme, že máme příbuzného narozeného 25. ledna 1875.<br />Upravte výběr data podle tohoto data.<br />Když teď kliknete na jedno z tlačítek pro zobrazení, uvidíte seznam nebo kalendář pro tento den.<br />Všechna stáří, výročí apod. jsou přepočítávány podle data, které jste nastavili.<br />Takže vlastně vidíte úplně stejný kalendář jaký by měl před sebou váš předek ve vzdálené minulosti.";
$pgv_lang["annivers_month_select_help"]		= "~VÝBĚR MĚSÍCE~<br /><br />Prostřední řádek \"Přepínací tabulky\" je <b>Výběr měsíce</b>.<br />Výnam tohoto prvku je stejně jako u \"Výběru dne\" jasný: Vyberete měsíc.<br /><br />A stejně jako u Výběru dne je rozdíl mezi kliknutím na měsíc v \"Režimu den\" a v \"Režimu měsíc\".<br /><br /><b>Režimu den</b>:<br />V tomto režimu, když kliknete na měsíc, se obrazovka znovu načte a zobrazí se seznam dnů v daném měsíci.<br />Veškeré ostatní nastavení jako den, rok a události bude zachováno.<br /><br /><b>Režim měsíc</b>:<br />Máte-li na obrazovce kalendář a kliknete na měsíc v řádku \"Měsíc\", zobrazí se kalendář tohoto nového měsíce.<br /><br />Na konci řádku Měsíc uvidíte <b>\"rychlý odkaz\"</b> na aktuální měsíc.<br />Kliknete-li na tento \"rychlý odkaz\", zobrazí se vám kalendář na tento měsíc bez ohledu na to, jestli jste v režimu Měsíc nebo v režimu Den.";
$pgv_lang["annivers_year_select_help"]		= "~POLÍČKO PRO ROK~<br /><br />Toto políčko slouží pro přepínání roku v kalendáři v \"režimu měsíců\" nebo v seznamu v \"režimu roků\".<br />V \"režimu den\" se změna roku nijak neprojeví, protože jsou zobrazeny události za celý rok.<dl><dt><b>Rozšířené možnosti</b> pro <b>#pgv_lang[viewyear]#:<br />Více roků najednou</b></dt><dd>Můžete hledat více než jeden rok zapsáním do políčka roku::<br />- Př. 1: <b>1992-5</b> pro všechny události od 1992 do 1995.<br />- Př. 2: <b>1972-89</b> pro všechny události od 1972 do 1989.<br />- Př. 3: <b>1610-759</b> pro všechny události od 1610 do 1759.<br />- Př. 4: <b>1880-1905</b> pro všechny události od 1880 do 1905.<br />- Př. 5: <b>880-1105</b> pro všechny události od 880 do 1105.<br /><br />Také můžete vynechat poslední číslici roku pro zobrazení všech událostí za určité desetiletí.<br />- Př.: <b>197</b> pro všechny události od 1970 do 1979.</dd><dt><br /><b>Zkratky</b></dt><dd>Někdy není úplně jasné, kdy přesně se daná událost stala. V těchto případech mohou být k datu přidána slova jako \"po\", \"před\" a \"kolem\". Data jsou v GEDCOMu uložena společně se zkratkou daného termínu. V režimu roku můžete zadávat i hledání těchto termínů s nebo bez přidruženého data. Zde je několik příkladů takových dotazů:<br /><b>abt</b> 1800 (abt = about = KOLEM)<br /><b>bet</b> 1950-1959 (bet = between = MEZI) zadejte: bet 1950 nepo jen: 1950-59<br /><b>bef</b> 1950 (bef = before = PŘED)<br /><b>aft</b> 1900 (aft = after = PO)<br /><br /><b>Poznámka:</b> PhpGedView bude hledat výraz přesně tak, jak jej zadáte. Hledáte-li \"abt 1850\", datum z GEDCOMu jako např. \"abt oct 1850\" <b>nebude</b> zahrnuto ve výsledcích vyhledávání. - Můžete zadat jen zkratku bez roku a získáte seznam všech dat, která tuto zkratku obsahují.</dd></dl>Samotným vepsáním roku nespustíte vyhledávání.<br />Jelikož toto políčko není odkazem, budete po zapsání roku muset kliknout na tlačítko <b>#pgv_lang[viewmonth]#</b> nebo tlačítko <b>#pgv_lang[viewyear]#</b>.";
$pgv_lang["annivers_show_help"]			= "~volba CO UKÁZAT~<br />Když nejste přihlášeni do systému, můžete si vybrat mezi dvěma možnostmi:<br /><br /><b>1. Všichni lidé</b><br />S tímto nastavením budou zobrazeni všichni jednotlivci a rodiny.<br /><br /><b>2. Nedávné události (<100 let)</b><br />S tímto nastavením uvidíte události, které se staly v daném dni/měsíci, avšak jen mladší než 100 let.<br /><br />Existuje ještě třetí možnost. Abyste si ji mohli vybrat, musíte být buď přihlášeni anebo musí admin nastavit systém tak, aby si žijící osoby mohl zobrazit kdokoliv.<br /><br /><b>3. Žijící lidé</b><br />S tímto nastavením budou zobrazeny pouze žijící osoby.<br />Po zvolení jedné z možností se stránka automaticky znovu načte (s novým nastavením).<br />Nastavení dne, měsíce, roku a režimu dne nebo měsíce zůstavá stejné.";
$pgv_lang["annivers_sex_help"]			= "~VÝBĚR POHLAVÍ~<br />Pokud jste přihlášení (nebo pokud admin vypnul privátní nastavení), můžete si vybírat mezi třemi možnostmi:<dl><dt><b>1. Všechny ikony</b></dt><dd>V tomto případě (implicitně) jsou zobrazeny události všech jednotlivců a rodin.</dd><dt><b>2. Ikona - muži</b></dt><dd>Zobrazeny jsou pouze události u mužů. Mužští členové rodin budou zobrazeni s rodinnými událostmi.</dd><dt><b>3. Ikona - ženy</b></dt><dd>Zobrazeny jsou pouze události u žen. V případě rodin jsou rodinné události zobrazeny u žen.</dd></dl>Kliknete-li na některou z voleb, dojde k novému načtení stránky a zobrazí se požadovaná forma.<br />Ostatní nastavení dne, měsíce, roku a událostí a režimu zůstává stejné.";
$pgv_lang["annivers_event_help"]		= "~VÝBĚR UDÁLOSTI~<br />Zde si můžete vybrat, jestli chcete u osob a rodin zobrazit všechny události nebo jen nějakou konkrétní.<br /><br />Když kliknete na některou z voleb, stránka se načte znovu a zobrazí se tak, jak jste požadovali.<br />Ostatní nastavení dne, měsíce, roku a pohlaví a režimu zůstává stejné.";
$pgv_lang["annivers_tip_help"]			= "~TIP~<br />Předpokládejme, že máte v databázi příbuzného, který se narodil 25. ledna 1875.<br />Nastavte toto datum.<br />Když nyní kliknete na jedno ze dvou tlačítek pro zobrazení, uvidíte seznam nebo kalendář pro toto datum.<br />Všechna stáří, výročí, atd. jsou přepočíteny a počítány zpětně podle data, které jste nastavili.<br />Takže, ve skutečnosti, vidíte stejný seznam nebo kalendář jako váš příbuzný v minulosti.";
$pgv_lang["day_month_help"]			= "~TLAČÍTKA ZOBRAZIT DEN / ZOBRAZIT MĚSÍC / ZOBRAZIT ROK~<br /><br />Tlačítko <b>Zobrazit den</b> zobrazí události spojené s datem vybraným z kalendáře. Prohledávají se všechny roky, takže stačí zadat den a měsíc. Změna roku se nijak neprojeví.<br />Seznam můžete omezit výběrem možnosti \"Poslední roky\" nebo, je-li tato možnost k dispozici, \"Žijící lidé\".<br />Věk lidí ze seznamu se vypočítá k aktuálnímu roku.<br /><br />Tlačítko <b>Zobrazit měsíc</b> ukáže tabulku pro daný měsíc a rok. I zde můžete seznam omezit dodatečným kliknutím na \"Žijící lidé\" nebo \"Poslední roky\".<br />Výběr nějakého roku z minulosti v kombinaci s volbou \"Poslední roky\" vám umožní získat realistický obraz toho, jaký kalendář měli na stěně vaši předkové. Věk všech lidí v kalednáři se zobrazí ve vztahu k roku zadaném v příslušném políčku.<br /><br />Tlačítko <b>Zobrazit rok</b> vám ukáže seznam událostí, které se staly během vybraného roku.<br />Opět můžete seznam omezit dodatečným kliknutím na \"Žijící lidé\", je-li tato možnost k dispozici, nebo \"Poslední roky\".<br />Vítanou vlastností programu je, že může zobrazit události i za více let: Prostě jen zapište poslední číslici koncového roku za počáteční rok a pomlčku \"-\" (např.: 1992-4 zajistí zobrazení všech událostí od roku 1992 do 1994, nebo 1976-1984 pro všechny události mezi léty 1976 a 1984 včetně).<br />- Také ovšem můžete vepsat pouze počáteční číslice požadovaných let a zobrazí se všechny události, které se staly v letech začínajících zadanými číslicemi. (např.: 197 pro všechny události mezi léty 1970 a 1979 včetně)<br /><br />Když budete chtít <b>změnit rok</b>, pak <b>musíte</b> zmáčknout jedno z těchto tří tlačítek.<br /><br />Všechno ostatní nastavení zůstává stejné.";
$pgv_lang["help_clippings.php"]			="~Schránka výstřižků~<br />Schránka výstřižků vám umožňuje pořizovat z tohoto rodokmenu \"výstřižky\" a vložit je do jednoduchého GEDCOM souboru ke stažení.<br /><br />* Jak pořídit výstřižky?<br />To je velmi jednoduché. Kdekoliv uvidíte jméno, na které se dá kliknout (osoba, rodina nebo pramen), můžete na toto jméno kliknout a tak se dostat na stránku s údaji o tomto jménu. Na této stránce uvidíte volbu \"Přidat do schránky výstřižků\".<br />Kliknutím na tento odkaz se dostanete na stránku, kde vám bude nabídnuto několik možností stažení.<br /><br />* Jak soubor stáhnout?<br />Jakmile budete mít položky ve schránce, můžete je stáhnout jednoduše kliknutím na odkaz \"Stáhnout\".<br />Pak postupujte podle instrukcí a odkazů.";
$pgv_lang["clip_download_help"]			="~STAŽENÍ VÝSTŘIŽKŮ~<br /><br />Kliknutím na tento odkaz, budete přesměrováni na další stránku.<br />Bude-li více možností, co stáhnout, budou zobrazeny na stránce.<br />Jednoduše postupujte podle pokynů.";
$pgv_lang["empty_cart_help"]			="~VYPRÁZDNĚNÍ SCHRÁNKY VÝSTŘIŽKŮ~<br /><br />Kliknutím na tento odkaz bude vaše schránka výstřižku úplně vyprázdněna.<br /><br />Jestliže nechcete odstranit všechny osoby, rodiny atd ze schránky výstřižků, můžete odstraňovat položku za položkou klikáním na odkaz \"Odstranit\" v rámečcích se jmény. ";
$pgv_lang["show_changes_help"]			="~ZOBRAZENÍ ZMĚN V GEDCOMU~<br /><br />To, že vidíte tuto zprávu, znamená dvě věci:<br /><br />1. Někdo provedl v GEDCOMu změny<br />Záznamy mohly být přidány, smazány nebo změněny.<br /><br />2. Změny dosud nebyly potvrzeny administrátorem.<br />Jakmile budou tyto změny přijaty (nebo zamítnuty), tato zpráva zmizí.<br /><br /><br />Kliknutím na odkaz se můžete podívat na změny, které byly provedeny.<br />Jestliže zjistíte, že nějaká změna není správná, prosím oznamte to adminovi.";
$pgv_lang["help_search.php"]			="~Stránka VYHLEDÁVÁNÍ~<br /><br />Ačkoliv tato stránka vypadá velmi jednoduše, ty dva formuláře na ní obsluhuje výkonný vyhledávací nástroj.<br /><br />Většina genealogických webů vám umožní hledat příjmení (někdy i jméno).<br />Na této stránce můžete hledat prakticky cokoliv.<br /><br />Vyhledávací políčko na levé straně obrazovky je úplně to samé jako v záhlaví stránky.<br /><br />Jestliže hledáte lidi spojené s určitým rokem, vepište prostě rok. Program vám najde všechna spojení.<br /><br />Hledáte snad jméno nebo místo?<br />Tak jej zadejte, buď celé nebo jen část, a program udělá zbytek za vás.<br /><br />Vyhledávací metoda SOUNDEX.<br />Přes vyhledávací políčko na pravé straně můžete vyhledávat jména osob a míst, dokonce i tehdy, když nevíte, jak se píší.<br /><br />Další nápovědu k těmto dvěma políčkům najdete, kliknete-li na <b>?</b> nad políčky.";
$pgv_lang["search_enter_terms_help"]		="~VKLÁDÁNÍ VÝRAZŮ PRO VYHLEDÁVÁNÍ~<br /><br />Do tohoto vyhledávacího políčka můžete zadávat kritéria jako data, křestní jména, příjmení, místa, multimédia atd.<br /><br /><b>Masky</b><br />Masky, jak je asi znáte (jako * nebo ?), nejsou povoleny, ale program sám vyhledává pomocí masek.<br />Co to znamená?<br />Předpokládejme, že jste do políčka zadali následující řetězec: \"<b>Pete</b>\"<br />Výsledek bude (opět předpokládejme, že tato jména jsou v databázi):<br /><b>Pete</b> Smith<br /><b>Pete</b>r Johnes<br />Will <b>Pete</b>rson<br />někdo --narozený 1. ledna 1901 <b>Pete</b>rsburg<br />atd., atd.<br /><br /><b>Data</b><br />Vepsáním roku do vyhledávacího políčka dostanete jména všech osob, které jsou nějak spojeny s tímto rokem.<br />Jestliže napíšete 1950, pak výsledkem budou lidé, kteří se roku 1950 narodili, oženili/vdaly, zemřeli nebo.... jsou jakoukoliv jinou události s tímto rokem spojeni.<br /><br />Jestliže napíšete \"4 Dec\", pak získáte seznam všech lidí spojených s nějakou událostí ze dne 4. prosince jakéhokoliv roku.<br />Ale také osoby, jichž se týkájí události ze dnů 14. či 24. prosince.<br />Jak vidíte, také zde se uplatňují masky, takže je nemusíte psát.<br /><br /><b>Řádná data</b><br />Program hledá data tak, jak jsou uložena v GEDCOM souboru .<br />Takže, pokud chcete hledat nějakou událost 14. prosince, měli byste napsat:<br /><b>14 dec</b><br />, protože toto je formát, v jakém jsou data ukládána do GEDCOM souboru.<br />Ale pokud napíšete \"<b>dec 14</b>\", pak výsledkem bude seznam lidí spojených s nějakou událostí - např. 08 <b>dec</b>ember 18<b>14</b>.Pokud chcete a znáte je, můžete používat také regulární výrazy. Například, když budete chtít najít všechny osoby, které se narodily ve 20. století, mohli byste zadat do vyhledávání 19[0-9][0-9] a dostali byste všechny osoby s daty od 1900 do 1999.<br /><br />Kdybyste potřebovali další nápovědu k tomuto vyhledávacímu systému, prosím dejte nám vědět, abychom ji mohli rozšířit.";
$pgv_lang["soundex_search_help"]		="~HLEDÁNÍ JMÉNA PODLE TOHO JAK (SI MYSLÍTE, ŽE) SE PÍŠE (METODA SOUNDEX)~<br /><br />Metoda SOUNDEX je velmi užitečná.<br />Nejdříve krátké objasnění pojmu Soundex:<br /><br />Soundex vyhledá příjmení, která zní podobně, ale píší se jinak. Soundexový kód začíná prvním písmenem příjmení a po něm následuje tříciferný kód představující první tři ze zbylých souhlásek. U jmen, která nemají dost znaků, se do kódu přidají nuly.<br /><br />V angličtině to znamená:<br />Pokud hledáte jméno \"Smith\", můžete jako výsledek získat také:<br />Smith - Smid - Smit - Schmidt, Smyth, Smithe, Smithee, Schmitt, Smead,  Sneed, Smoote atd.<br /><br />Soundexový kód vás nemusí vůbec zajímat.<br />Prostě jen napište jméno, které hledáte, a program to udělá.<br /><br />Systém Soundex je velmi vhodné použít v tomto případě: znáte jméno, ale nevíte, jak se přesně píše.<br />Může to také pomoci v případě, že ten, kdo jméno vkládal do databáze, udělal chybu.<br />I v takovém případě, za použití systému Soundex, bude možné jméno nalézt.<br /><br />Abyste si na to zvykli, zkuste najít určité jméno, ale napište ho v pozměněné podobě.<br /><br />V tomto soundexovém formuláři stačí zadat jakékoliv jméno.<br />Můžete vyhledávat podle křestního jména, příjmení nebo podle názvu místa.<br />Vyplníte-li více než jedno políčko, jednotlivá kritéria se zřetězí pomocí \"AND\" - tj. budou vyhledány jen ty záznamy, které splňují současně všechny zadané podmínky.<br />Výsledky hledání můžete ovlivnit také zadáním roku nebo rozsahu let. Například: 1950 nebo 19[5-7][0-9], což znamená 1950 až 1979.<br />Výsledkem vyhledávání budou všechny osoby, u nichž je zaznamenána nějaká událost na daném místě v zadaném rozsahu let.";
$pgv_lang["help_individual.php"]		= "~STRÁNKA S ÚDAJI O JEDNOTLIVCÍCH~<br /><br />Na této stránce jsou zobrazeny všechny údaje o dané osobě.<br /><br />Jestliže je v databázi obrázek, uvidíte jej nahoře po levé straně.<br />Vedle obrázku (je-li nějaký), uvidíte jméno osoby.<br />Ke jménům mohou být připojeny prameny a poznámky. Jsou-li k některému ze jmen připojeny poznámky nebo prameny, uvidíte je seřazeny pod příslušným jménem.<br />Člověk může mít také pseudonym. Je-li tomu tak, bude též zobrazen.<br /><br />Máte-li potřebná práva k této osobě, zobrazí se vám také odkazy pro úpravu a vymazání položek, které můžete upravovat.<br /><br />Na této stránce vidíte záložky \"Osobní údaje\", \"Poznámky\", \"Prameny\", \"Média\", \"Blízcí příbuzní\".<br /><br />Pod těmito záložkami najdete veškeré informace uložené v GEDCOMu.<br /><br />Záložka \"Osobní údaje\" vám ukáže údaje a podrobnosti o dané osobě a údaje o jejích manželstvích. Kliknutím na kterékoliv datum vás přepne do Kalendáře výročí s tímto datem, takže se budete moci podívat, jaké další události se ještě k tomuto datu váží. Kliknutí na místo vás přepne do Hierarchie míst, kde uvidíte seznam lidí, v jejichž životě se něco odehrálo na stejném místě. U sňatků a jiných údajů spojených s rodinou se zobrazí také jméno partnera, takže se budete moci podívat i na něj a k dispozici je i odkaz na záznam o rodině.<br /><br />Záložka \"Poznámky\" vám ukáže všechny obecné poznámky připojené k této osobě.<br /><br />Záložka \"Prameny\" vám ukáže všechny prameny vážící se k této osobě. Po kliknutí na název pramene se dostanete na stránku s podrobnými údaji o daném prameni a seznamem lidí, kteří jsou k tomuto prameni napojeni.<br /><br />Pod záložkou \"Média\" se zobrazí seznam všech obrázků a jiných multimediálních souborů připojených k této osobě. Kliknete-li na náhled obrázku, otevře se okno s obrázkem v původní velikosti.<br /><br />Pod záložkou \"Blízcí příbuzní\" jsou seřazeni rodiče, sourozenci, partneři a děti této osoby. Osoby budou zapsány do rámečků podobných schématům, jež jste už viděli.<br /><br />Při pravé straně obrazovky najdete rámeček s odkazy.<br />Mnohé z těchto odkazů jsou také v horním menu. Například, kliknete-li z postranních odkazů na \"Vývod\", dostanete se na stránku s vývodem této osoby. Kdežto, kliknete-li na odkaz \"Vývod\" v horním menu, zobrazí se vám stránka s implicitním vývodem tohoto GEDCOMu.<br /><br />Jeden z odkazů, které by se mohly v seznamu objevit, jestliže byly zapnuty adminem, je odkaz \"Zobrazit přímo záznam GEDCOM\". Tento odkaz vám ukáže přímo samotný GEDCOM kód této osoby.<br /><br />Pokud admin povolil používání Schránky výstřižků, uvidíte také odkaz, který vám umožní přidat si tuto osobu do Schránky výstřižků.<br /><br />Odkaz Vztah ke mně se zobrazí pouze v případě, že jste přihlášeni do systému a bylo vám přiřazeno nějaké číslo z aktuálního GEDCOMu. Po kliknutí na tento odkaz se ocitnete na stránce s vývodem a vy uvidíte, jak jste příbuzní s touto osobou.<br /><br />Další nápověda je k dispozici na stránce – po kliknutí na <b>?</b> za odkazy či položkami.";
$pgv_lang["delete_person_help"]			= "~VYMAZÁNÍ OSOBY Z GEDCOMU~<br /><br />Kliknutím na tuto volbu označíte tuto OSOBU, aby mohla být vymazána z GEDCOMu.<br /><br />Co to znamená?<br />Předpokládejme, že máte dobrý důvod k odstranění této osoby ze svého GEDCOMu. Kliknete na odkaz a zobrazí se vám pop-up okno a budete dotázáni, jestli opravdu chcete akci vykonat, nebo ji ukončit.<br /><br />Budete-li pokračovat v odstraňování osoby, vyskočí vám po chvilce okno se zprávou, že osoba byla vymazána.<br /><br />Když budete pokračovat v prohlížení stránek, všimnete si možná, že osoba je ještě pořád v databázi, že se tedy nic nezměnilo.<br /><br />To <b>není</b> chyba.<br />Administrátor dostane zprávu, že v GEDCOMu byla provedena změna a že jste odstranili tuto osobu.<br />Administrátor může vaši změnu buď přijmout, nebo odmítnout. Jedině pak už tuto změnu nelze vzít zpět.<br />V případě pochybností vás administrátor kontaktuje.";
$pgv_lang["delete_name_help"]			= "~UPRAVENÍ nebo VYMAZÁNÍ JMÉNA Z GEDCOMU~<br /><br /><b>ÚPRAVA JMÉNA</b><br />Po kliknutí na tento odkaz se vám otevře pop-up okno, v němž budete moci upravit jméno osoby.<br />Je to velmi jednoduché, zkrátka jen vepište změny do políček, klikněte na tlačítko a zavřete okno; a je to.<br /><br /><b>VYMAZAT JMÉNO</b><br />Kliknutím na tuto volbu označíte toto jméno, aby bylo vymazáno z GEDCOMu.<br />Mějte na paměti, že vymazání jména je něco úplně jiného než vymazání osoby.<br />Vymazáním jména pouze odstraníte u této osoby jméno. Osoba sama vymazána nebude.<br />Vymažete-li u osoby pseudonym, zůstanou jí ostatní jména.<br />Má-li jen jedno jméno a vy ho vymažete, osoba nebude vymazána, ale bude nadále vedena jako \"Neznám(a)\".<br />Osoba také nebude odpojena od příbuzných, pramenů, poznámek atd.<br /><br />Jak to funguje?<br />Předpokládejme, že máte dobrý důvod k odstranění tohoto jména ze svého GEDCOMu. Kliknete na odkaz a zobrazí se vám pop-up okno a budete dotázáni, jestli opravdu chcete akci vykonat, nebo ji ukončit.<br /><br />Budete-li pokračovat v odstraňování osoby, vyskočí vám po chvilce okno se zprávou, že jméno bylo vymazáno.<br /><br />Když budete pokračovat v prohlížení stránek, všimnete si možná, že jméno je ještě pořád v databázi, že se tedy nic nezměnilo.<br /><br />To <b>není</b> chyba.<br />Administrátor dostane zprávu, že v GEDCOMu byla provedena změna a že jste odstranili toto jméno.<br />Administrátor může vaši změnu buď přijmout, nebo odmítnout. Jedině pak už tuto změnu nelze vzít zpět.<br />V případě pochybností vás administrátor kontaktuje.";
$pgv_lang["add_name_help"]				= "~PŘIDÁNÍ NOVÉHO JMÉNA~<br /><br />Tento odkaz vám umožní přidat této osobě další jméno. Někteří lidé jsou známi pod více jinými jmény či aliasy. Tento odkaz vám umožní přidat jméno, aniž by se změnilo to staré.";
$pgv_lang["add_sibling_help"]			= "~PŘIDÁNÍ BRATRA NEBO SESTRY~<br /><br />Kliknutím na tento odkaz můžete přidat dítě do této rodiny.<br />\"Tato rodina\" je, v tomto případě, otec a matka ústřední osoby této stránky.<br />Takže, mějte na paměti, že přidáváte bratra nebo sestru této osoby.<br />Přidání bratra nebo sestry je jednoduché: Prostě jen klikněte na odkaz, vyplňte políčka v pop)up okně a je to.<br /><br />Potřebujete-li přidat syna či dceru ústřední osoby, posuňte se v okně o něco dolů a klikněte na odkaz  \"Rodina s partnerem\".";
$pgv_lang["add_son_daughter_help"]		= "~PŘIDÁNÍ SYNA ČI DCERY~<br /><br />Kliknutím na tento odkaz můžete přidat dítě k této rodině.<br />\"Tato rodina\" je, v tomto případě, ústřední osoba na této stránce a její partner.<br />Takže mějte na paměti, že se chystáte přidat syna nebo dceru této osoby.<br />Přidání syna nebo dcery je jednoduché: Prostě jen klikněte na odkaz, vyplňte políčka v pop-up okně a je to.<br /><br />Chcete-li přidat bratra nebo sestru ústřední osoby, posuňte se na stránce kousek nahoru a klikněte na odkaz \"Rodina s rodiči\".";
$pgv_lang["link_child_help"]			= "~PŘIPOJENÍ TÉTO OSOBY K EXISTUJÍCÍ RODINĚ COBY DÍTĚ~<br /><br />Kliknutím na tento odkaz můžete tuto osobu připojit jako dítě k existující rodině.<br /><br />Předpokládejme, že rodiče této osoby byli neznámí a vy teď zjistíte, že mají svůj záznam v tomto GEDCOMu.<br /><br />Klikněte jen na odkaz, vložte ID rodiny (neznáte-li ID, můžete použít okno pro vyhledávání) a práce je hotova.";
$pgv_lang["link_husband_help"]			= "~PŘIPOJENÍ TÉTO OSOBY K EXISTUJÍCÍ RODINĚ COBY MANŽELA~<br /><br />Tato položka vám umožní připojit tuto osobu ajko manžela k rodině, která již je zapsána v GEDCOMu. Kliknutím na tento odkaz přidáte tuto osobu k rodině, u níž manžel dosud nebyl znám. Tato osoba zaujme místo té néznámé osoby. Všechny události, informace o manželství a děti zůstanou připojeny k rodině tak, jak jsou.<br /><br />Jen klikněte na tento odkaz, zadejte ID rodiny (neznáte-li ID, můžete jej vyhledat pomocí pop-up okna) a celá operace je hotova. Toto je speciální volba, která by se měla používat jedině v případě, že rodina, k níž chcete osobu připojit, je již v GEDCOMu uložena. Chcete-li přidat novou rodinu, použijte odkaz pro přidání nové manželky.";
$pgv_lang["add_husband_help"]			= "~PŘIDÁNÍ NOVÉHO MANŽELA~<br /><br />Kliknutím na tento odkaz můžete přidat \"nového\" muže a připojit jej k ústřední osobě jako manžela.<br /><br />Klikněte prostě na odkaz. Objeví se pop-up okno, v němž budete moci novou osobu přidat.<br />Vyplňte co nejvíce políček a klikněte na tlačítko \"Uložit\".<br /><br />Toť vše.";
$pgv_lang["link_wife_help"]			= "~PŘIPOJENÍ TÉTO OSOBY K EXISTUJÍCÍ RODINĚ COBY MANŽELKU~<br /><br />Tato položka vám umožní připojit aktuální osobu jako manželku k nějaké rodině, která je již zapsána v GEDCOMu. Toto je speciální volba, která by se měla používat jedině v případě, že rodina, k níž chcete osobu připojit, je již v GEDCOMu uložena. Chcete-li přidat novou rodinu, použijte odkaz pro přidání nového manžela.";
$pgv_lang["add_wife_help"]			= "~PŘIDÁNÍ NOVÉ MANŽELKY~<br /><br />Kliknutím na tento odkaz můžete přidat \"novou\" ženu a připojit ji k ústřední osobě jako novou manželku.<br /><br />Klikněte prostě na odkaz. Objeví se pop-up okno, v němž budete moci novou osobu přidat.<br />Vyplňte co nejvíce políček a klikněte na tlačítko \"Uložit\".<br /><br />Toť vše.";
$pgv_lang["add_new_parent_help"]		= "#pgv_lang[multiple_help]#<br />~PŘIDÁNÍ NOVÉHO OTCE nebo MATKU~<br /><br />V GEDCOMu nepochybně bude mnoho osob, u nichž není uveden otec a/nebo matka.<br /><br />V takovém případě najdete na <b>Stránce s osobními údaji</b>, tabulce <b>Blízcí příbuzní</b>, tabulce <b>Rodina s rodiči</b> odkazy pro přidání <b>nového</b> otce a/nebo matky k dané osobě.<br /><br /><b>POZNÁMKA:</b><br />Mějte prosím na zřeteli, že tyto odkazy slouží pro přidání <b>nového</b> otce a/nebo matkyr.<br />Jestliže již matka nebo otec má v GEDCOMu záznam, pak použijte odkaz: <b>#pgv_lang[link_as_child]#</b>, který najdete na stránce s osobními údaji - pod nejspodnější tabulkou na stránce.";
$pgv_lang["add_facts_help"]			= "~PŘIDÁNÍ NOVÝCH ÚDAJŮ~<br /><br />Tady můžete k osobě (nebo osobám) přidat nové údaje.<br /><br />Nejprve z \"rolovacího seznamu\" vyberte typ údaje, pak klikněte na tlačítko \"Přidat\".<br />V \"rolovacím seznamu\" jsou již všechny údaje, které je možné přidat do souboru GEDCOM.";
$pgv_lang["add_custom_facts_help"]		= "~Přidat vlastní událost~<br />Jestliže jste v seznamu GEDCOM údajů nenašli udaj, který chcete přidat, můžete zadat <b>vlastní udáj</b>.<br />Vložení vlastního údaje je stejně jednoduché jako vložení předdefinovaného údaje.<br />Jediný rozdíl spočívá v tom, že musíte navíc zadat název údaje. To musíte udělat v horním políčku: <b>#pgv_lang[type]#</b>";
$pgv_lang["add_note_help"]			= "~PŘIDÁNÍ NOVÉ POZNÁMKY ~<br /><br />Nápověda k této položce zatím není hotová";
$pgv_lang["add_source_help"]			= "~PŘIDÁNÍ NOVÉ CITACE K PRAMENU~<br /><br />Chcete-li k tomuto údaji přidat nový pramen, můžete kliknout na odkaz.<br />Otevře se pop-up okno a vy budete moci zvolit jeden pramen ze seznamu (Najít ID) a přidat \"Citaci\".<br /><br />V tuto chvíli není možné přidat úplně nový pramen, takže musíte vybrat jeden pramen ze seznamu.<br /><br />Není-li pramen, který chcete upravovat, v seznamu, upozorněte prosím admina (připište údaje o prameni) a on jej přidá do seznamu.<br />Příště tak již bude váš nový pramen zahrnut v seznamu a vy budete jej budete moci upravovat.<br /><br />Pravděpodobně už v některé z příštích verzí PhpGedView bude možné přidávat prameny přímo.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"]			= "~PŘIDÁNÍ NOVÉHO MÉDIA~<br /><br />Možnost přidávat do GEDCOMu multimediální soubory je velice pěkná vlastnost.<br />Ačkoliv tento program vypadá pěkně i bez médií, po přidání obrázků nebo jiných multimediálních souborů k příbuzným to může být jedině lepší.<br /><br /><b>Co byste si měli představit pod tímto pojmem.</b><br />Jak možná víte, existuje neskutečná řada multimediálních formátů. Ačkoliv PhpGedView umí pracovat s většinou z nich, měli byste některé věci uvážit.<br /><br /><b>Formáty</b><br />Obrázky mohou být uloženy do mnoha formátů.<br />např. obrazek.jpg / obrazek.png / obrazek.bmp / obrazek.gif / atd.<br />Všechny obrázky z našeho příkladu budou mít na obrazovce stejnou velikost, avšak budou se podstatně lišit velikostí souboru na disku.<br /><br /><b>Rozlišení</b><br />Rozlišení obrázku je dáno v jednotkách \"dpi\" (body na palec). Můžete to víceméně porovnat s klasickou fotografií a rozdíly mezi 25ASA - 200ASA - 800ASA.<br />Čím vyšší rozlišení, tím lepší kvalita, ale také větší velikost souboru na disku.<br />Normálně stačí na obrázky na internetu 75.<br /><br /><b>Barevná hloubka</b><br />Třetí způsob, jak zmenšit soubor, je snížit počet barev.<br />Počet barev může být různý – od čistě černo-bílé až po true colors a něco mezi tím.<br />Opět si uvědomte, že, čím víc barev použijete, tím věští bude velikost souboru.<br /><br /><b>Proč je důležité, aby byly obrázkové soubory malé?</b><br /><br />Za prvé: Náš webový prostor je omezený.<br />Čím větší budou soubory, tím více diskového prostoru na serveru budeme potřebovat. Čím více místa budeme potřebovat, tím více za to budeme muset platit.<br /><br />Za druhé: doba stahování. Budete-li mít velké soubory, uživatelé (i vy) budou muset dlouho čekat, než se jim stránka se všemi obrázky načte.<br />Každý nemá to štěstí mít kabelové, širokopásmové nebo DSL připojení.<br /><br /><b>Jak můžete nahrát své soubory na server</b><br />Stručně - nemůžete.<br />Z výše zmíněných důvodů nemůžete své soubory nahrát přímo do databáze.<br /><br /><b>Jak tedy?</b><br />Kontaktujte admina, po němž chcete, aby soubory do GEDCOMu přidal. Poradí vám, který formát použít.<br />Budete-li mít obrázky ve správném formátu, budete je moci poslat adminovi na e-mail. Admin zkontroluje formáty a velikosti souborů a nahraje je do adresáře na serveru.<br />Pak budete moci tyto soubory připojit ke svým příbuzným, a to použitím tohoto odkazu";
$pgv_lang["add_facts_general_help"]		= "~Obecné informace o přidávání~<br />Když přidáte k osobě či osobám údaj, poznámku, pramen nebo multimediální soubor, tato operace musí být ještě potvrzena osobou, jíž admin udělil právo potvrzovat změny v databázi.<br />Než se tak stane, změny se na stránce zobrazí v rámečku odlišné barvy a to pouze uživatelům, kteří mají právo tuto databázi upravovat, obyčejným návštěvníkům ne. Až budou změny potvrzeny, rámečky zmizí a data se zobrazí normálně.";
$pgv_lang["edituser_my_account_help"]		="Na této stránce můžete změnit své nastavení a předvolby.<br /><br />Můžete změnit své uživatelské jméno, celé jméno, heslo, jazyk, e-mailovou adresu, motiv (podobu) stránky a upřednostňovanou formu kontaktu.<br /><br />Jediné, co si sami nemůžete změnit, je osobní ID v GEDCOMu.";
$pgv_lang["edituser_username_help"]		="~#pgv_lang[username]#~<br /><br />V tomto políčku můžete změnit své uživatelské jméno.<br />Jestliže se vám již vaše současné uživatelské jméno nelíbí nebo máte jiné důvody k jeho změně, můžete tak učinit v tomto formuláři.<br /><br />V uživatelském jménu se rozezná velikost písmen. To znamená, že \"Jan\" není stejné jako \"jan\" nebo \"JAN\".<br /><br />Měli byste použít <b>pouze</b> znaky z těch abeced, jež jsou podporovány tímto programem (velká a malá písmena), čísla, pomlčku (-) a podtržítko (_).<br /><br /><b>Nepoužívejte</b> interpunkční znaménka, mezery nebo jiné znaky než znaky podporovaných abeced.";
$pgv_lang["edituser_gedcomid_help"]		="~#pgv_lang[gedcomid]#~<br /><br />Toto je vnitřní (GEDCOM) ID, které vás spojuje s vašimi daty v GEDCOMu.<br /><br />Toto ID nemůžete změnit.<br />To nastavuje administrátor stránek.<br />Pokud si myslíte, že toto ID není správné, měli byste kontaktovat administrátora, aby jej změnil.";
$pgv_lang["edituser_rootid_help"]		="~#pgv_lang[rootid]#~<br /><br />Toto je střen všech vašich schémat.<br />Střen je výchozí osoba.<br />Když kliknete (například) na odkaz Vývod, pak uvidíte tohoto střena v rámečku vlevo úplně nahoře.<br />Samozřejmě není nutné, abyste byli střenem vy. Jako výchozí osobu si můžete stanovit jakoukoliv osobu, již máte právo vidět.<br />V některých schématech můžete výchozí osobu měnit, ale tato změna bude platit pouze pro danou stránku.";
$pgv_lang["edituser_password_help"]		="~#pgv_lang[password]#~<br /><br />Je dobré zvyknout si pravidelně měnit heslo.<br />Musíte si uvědomit, že kdokoliv, kdo zná vaše uživatelské jméno a heslo, má přístup k vašim datům.<br />Vytvořte si heslo složené z alespoň 6 znaků. Čím delší, tím lepší. Můžete použít všechny znaky abecedy, číslice a jakékoliv další znaky, které máte na své klávesnici.<br /><b>Poznámka:</b> Je lepší <b>nepoužívat</b> \" (uvozovky) či ' (apostrofy). Možná by to fungovalo, ale to není zaručeno.<br /><br /><b>Nejlepší je kombinace velkých, malých znaků, číslic a dalších znaků</b>. Například: 5Z_q\$P4=r9.<br /><br />Stejně jako uživatelské jméno, tak i heslo je <b>case sensitive</b> (rozlišení velkých/malých písmen). To znamená, že \"Ja5n\" není to samé jako \"ja5n\" nebo \"JA5N\".";
$pgv_lang["edituser_conf_password_help"]	="~#pgv_lang[confirm]#~<br /><br />Jestliže jste si změnili heslo, je třeba jej také potvrdit.<br />Je to z toho důvodu, aby se vyloučily možné chyby při zapisování hesla.<br />Zjistí-li program, že vaše heslo a jeho potvrzení se liší, uvidíte tuto zprávu: <b>#pgv_lang[password_mismatch]#</b>.<br />Obsah obou políček (hesla a potvrzení) bude vymazán a budete muset zadat heslo do obou políček.";
$pgv_lang["edituser_change_lang_help"]		="~#pgv_lang[change_lang]#~<br /><br />Tady můžete nastavit implicitní jazyk pro své stránky.<br />Program je schopný rozpoznat <b>jazykové nastavení</b> vašeho prohlížeče, takže většinou není důvod měnit nastavení tady.<br />Ale, když má například váš prohlížeč nastaven jako implicitní jazyk angličtinu, ale vy chcete zobrazovat stránky v češtině nebo holandštině, pak to můžete zařídit právě zde.";
$pgv_lang["edituser_email_help"]		="~#pgv_lang[emailadress]#~<br /><br />Vaše e-mailová adresa je pro nás samozřejmě důležitá kvůli možnosti vás kontaktovat.<br />Jestliže začnete používat jinou e-mailovou adresu, například při změně poskytovatele, nezapomeňte prosím změnit svou adresu i zde.<br />Možná máte více e-mailových adres a zprávy od nás chcete dostávat na jinou adresu, prosím změnu proveďte zde.";
$pgv_lang["edituser_user_theme_help"]		="~#pgv_lang[user_theme]#~<br /><br />K dispozici máte několik motivů.<br />Motiv je souhrn nastavení vzhledu jednotlivých prvků na stránkách. S každým motivem uvidíte stejná data, ale vzhled bude jiný.<br />Je to podobné, jako byste obrazu dali jiný rám a pověsili jej v jiném pokoji. Obraz se nezměnil, ale díváte se teď na něj úplně jinak.<br />Jen to zkuste. Nastavte si jiný motiv. Prohlédněte si jej a zkuste další. Nakonec nastavte ten, který se vám líbil nejvíce.<br />Kdykoliv se přihlásíte, program vám nastaví vámi předvolený motiv.";
$pgv_lang["edituser_contact_meth_help"]		="~#pgv_lang[user_contact_method]#~<br />Tento systém nabízí další možnosti zasílání zpráv<br />Způsob kontaktu je nastaven administrátorem stránek, takže to nemůžete změnit.<br />Způsob <b>přijímání</b> zpráv si však změnit můžete.<br />V současnosti si můžete vybrat ze čtyř možností.";
$pgv_lang["mail_option1_help"]			="Zvolíte-li tuto možnost, bude se k odesílání zpráv používat vestavěný systém PhpGedView bez použití e-mailu.<br />Tak budete moci dostávat pouze <b>vnitřní zprávy</b> od ostatních uživatelů.<br />Když vám některý z uživatelů pošle z těchto stránek zprávu, najdete ji v bloku zpráv na své stránce MyGedView (pokud jste tento blok ze své stránky neodstranili)";
$pgv_lang["mail_option2_help"]			="Tato volba je stejná jako #pgv_lang[messaging]# s něčím navíc.<br />Kopie zprávy bude navíc poslána na vaši e-mailovou adresu, kterou jste u své účtu zadali.<br />Tento způsob kontaktu je nastaven implicitně.";
$pgv_lang["mail_option3_help"]			="Je-li nastavena tato volba, budete dostávat zprávy pouze na svou e-mailovou adresu.<br />Ostatní uživatelé se s vámi nebudou moci spojit skrz vnitřní systém.";
$pgv_lang["mail_option4_help"]			="Tato volba způsobí, že nebudete dostávat žádné zprávy.";
$pgv_lang["admin_help"]				="Na této stránce jsou všechny odkazy na konfigurační soubory, administrační stránky, dokumentaci a log soubory.<br /><br /><b>Systemový čas</b>, umístěný hned pod titulek stránky, ukazuje čas serveru, na němž jsou vaše stránky umístěny. Čas, který vidíte, je čas otevření nebo obnovení stránky.<br /><br /><b>VAROVÁNÍ</b><br />Pokud vidíte pod systémovým časem varovnou zprávu, znamená to, že do vašeho souboru <b>config.php</b> je stále možné zapisovat!<br />Z <b>bezpečnostních důvodů</b> byste měli po dokončení konfigurace stránek nastavit práva souboru zpět na \"jen pro čtení\".<br />To musíte udělat <b>ručně</b>, neboť PhpGedView to zatím neumí.<br /><br />Kormě voleb Readme, Uživatelský manuál a Log soubory získáte další nápovědu na zvolených stránkách.";
$pgv_lang["useradmin_help"]			="~ADMINISTRACE UŽIVATELŮ~<br /><br />na této stránce můžete administrovat současné uživatele a přidávat nové uživatele.<br /><br /><b>Seznam současných uživatelů</b><br />V této tabulce jsou zobrazeni současní uživatelé, jejich stav a jejich práva.<br />Uživatele můžete <b>mazat</b> nebo <b>upravovat</b>.<br /><br /><b>Přidat nový uživatelský formulář</b><br />Tento formulář je téměř shodný s tím, který znáte z \"Váš účet\".<br />U některých předmětů jsme nevytvářeli speciální nápovědu pro admina. V těchto případech uvidíte následující zprávu:";
$pgv_lang["useradmin_gedcomid_help"]		="~ID V GEDCOMU~<br /><br />Toto ID musí nastavit administrátor.<br />Tím bude ID spojeno s osobou daného uživatele.<br />To také umožní uživateli přístup do svého \"Já\" a \"Můj vývod\".<br /><br />Pro každý GEDCOM, který v tomto programu používáte, můžete nastavit pro uživatele jeho ID.<br />Pokud uživatel není v tomto GEDCOMu, necháte toto políčko prázdné.";
$pgv_lang["useradmin_rootid_help"]		="~VÝCHOZÍ OSOBA VÝVODU~<br /><br />V každém GEDCOM souboru můžete nastavit jako <b>Výchozí osobu</b> některého uživatele.<br />Uživateli se pravděpodobně bude líbit pouštění programu se svým vlastním vývodem, ale není to nutné.<br /><br />Uživatel si toto také nastavení může změnit ve svém účtu.";
$pgv_lang["useradmin_can_admin_help"]		="~ZAŠKRTÁVACÍ POLÍČKO - UŽIVATEL SMÍ ADMINISTROVAT~<br /><br />bude-li toto políčko zaškrtnuto, bude mít uživatel v tomto programu stejná práva jako vy.<dl><dt>Jediné, co on / ona nebude moci provádět je:</dt><dd>Přidávat / Odstraňovat / Upravovat uživatele.</dd><dd>Posílat zprávy všem uživatelům najednou.</dd><dd>Upravovat uvítací zprávy.</dd><dd>Upravovat a konfigurovat jazykové soubory.</dd><dt>Ale také:</dt><dd>Aktualizovat program.</dd><dd>Měnit nastavení.</dd><dd>Aministrovat GEDCOMy.</dd><dd>Měnit nastavení privátnosti.</dd><dt>A nic dalšího, co zde není zmíněno.</dt><dd>Ale ne nastavení vašich stránek - mimo tento program</dd></dl>";
$pgv_lang["useradmin_can_edit_help"]		="~UŽIVATELSKÁ PRÁVA~<br /><br />Ke každému z GEDCOM souborů, dostupných v tomto systému, může mít uživatel určitá práva pro přístup a upravování.<br /><br />Je-li tato položka nastavena na <b>Žádná</b>, znamená to, že uživatel nemá přístup k privátním datům z tohoto GEDCOMu. Je-li tato položka nastavena na <b>Přístup</b>, pak tento uživatel nemá právo upravovat nebo potvrzovat úpravy provedené v databázi, ale má přístup k privátním údajům.<br /><br />Zvolíte-li <b>Úpravy</b>, znamená to, že tento uživatel může upravovat informace v databázi, ale jiný uživatel s právy <b>Potvrzování</b> musí tyto změny potvrdit dříve, než budou definitivně zapsány do databáze a zveřejněny.<br /><br />Nastavení na <b>Potvrzování</b> umožní uživateli upravovat databázi a potvrzovat změny provedené jinými uživateli.<br /><br />Vyberete-li možnost <b>Spravovat GEDCOM</b>, umožníte tak uživateli navíc upravovat konfiguraci a nastavení privátnosti tohoto GEDCOMu.<br /><br />Administrátoři systému mají automaticky práva <b>Spravovat GEDCOM</b>.";
$pgv_lang["useradmin_verified_help"]		="~UŽIVATEL POTVRDIL REGISTRACI~<br /><br /><b>Automatická registrace</b><br />Uživatel může požadovat zavedení nového účtu pomocí modulu <b>automatické registrace</b>.<br />Pokud tak učiní, pak obdrží e-mailem zprávu s odkazem na stránku, kde bude moci svou registraci potvrdit.<br />Pokud tak již učinil, uvidíte zaškrtnuté políčko a budete moci přistoupit k dalšímu kroku: <b>Uživatele povolit adminem</b>.<br />Pokud uživatel registraci nepotvrdil, měli byste se svým povolením počkat.<br /><br /><b>Přidat uživatele ručně</b><br />Pokud použijete formulář k přidání uživatele ručně, uvidíte toto políčko již zaškrtnuté.";
$pgv_lang["useradmin_verbyadmin_help"]		="~POVOLENÍ ADMINEM~<br /><br />Pokud uživatel použil modul automatické registrace a následně potvrdil registraci, pak je váš souhlas posledním krokem před aktivováním účtu.<br /><br />Po tom, co povolíte aktivaci účtu, uživatel obdrží e-mailem zprávu o tom, že jeho účet je aktivní a že se může přihlásit se svým uživatelským jménem a heslem, které použil, když žádal o zavedení účtu.";
$pgv_lang["useradmin_edit_user_help"]		="~AKTUALIZACE UŽIVATELSKÉHO ÚČTU~<br /><br />Tento formulář používá admin k tomu, aby změnil uživatelský účet.<br /><br />Formulář je podobný formuláři \"Přidat uživatele\" nebo \"Můj účet\".";
$pgv_lang["useradmin_visibleonline_help"]		= "~VIDITELNÍ ONLINE~<br /><br />Pokud je toto políčko zaškrtnuté, ostatní přihlášení uživatelé uvidí, jestli jste v daný okamžik online a vy uvidíte, jestli jsou online ostatní. Nechcete-li, aby vás ostatní viděli online, vyškrtněte toto políčko. Ale ani vy nebudete moci zjistit, jestli jsou ostatní uživatelé online.";
$pgv_lang["useradmin_editaccount_help"]			= "~UPRAVOVÁNÍ ÚČTU~<br /><br />Pokud je toto políčko zaškrtnuto, pak dotyčný uivatel bude moci upravovat informace o svém účtu. Není-li políčko zaškrtnuto, pak mu to nebude umožněno. To vám umožní vytvořit jedno uživatelské jméno a heslo pro více uživatelů a přitom nepřipustit, aby kterýkoliv z nich tento účet měnil.";
$pgv_lang["add_upload_gedcom_help"]		="~PŘIDÁVÁNÍ versus NAHRÁVÁNÍ GEDCOMŮ~<dl><dt>Nahrávání GEDCOM souborů</dt><dd>Nahrávání souborů se může provádět online.<br />Soubor můžete nahrát z jakéhokoliv místa, aniž byste museli použít ftp program.</dd><dt>Přidávání GEDCOM souborů</dt><dd>Je-li váš soubor ještě pořád ve vaší GEDCOM složce (na serveru), nemusíte jej znovu nahrávat.<br />Někdy je potřeba použít možnost Přidat místo nahrát - to kvůli velikosti souboru nebo limitům pro uploadování.</dd></dl>Obě procedury (Přidat i Nahrát) se dají provést ve 4 jednoduchých krocích.<br />U obou procedur se liší pouze krok č. 1.";
$pgv_lang["gedcom_configfile_help"]		="~KONFIGURAČNÍ SOUBOR GEDCOMU~<br /><br />V tomto souboru jsou uloženy všechna základní nastavení souboru GEDCOM.<br /><br />Na stránce administrace GEDCOMu je ve sloupci \"Konfigurační soubor\" zobrazena cesta a název konfiguračního souboru.";
$pgv_lang["default_gedcom_help"]		="~IMPLICITNÍ GEDCOM~<br /><br />Máte-li v programu více než 1 GEDCOM, můžete zde nastavit, který GEDCOM bude <b>implicitní</b>.<br /><br />Tj. ten GEDCOM, který se zobrazí všem návštěvníkům, kteří ještě nejsou přihlášení.<br /><br />Uživatelé si mohou ve svém účtu nastavit jako implicitní kterýkoliv GEDCOM v programu.";
$pgv_lang["delete_gedcom_help"]			="~SMAZÁNÍ GEDCOMU~<br /><br />PhpGedView importuje záznamy ze souboru GEDCOM. Když kliknete na <b>Smazat</b>, program smaže ty záznamy, které byly importovány z GEDCOMu.<br />Samotný soubor GEDCOM zůstane ve složce, do níž byl nahrán.<br /><br />Budete-li chtít později s tímto souborem pracovat znovu, nebudete jej muset znovu nahrávat. Místo toho můžete zvolit možnost <b>Přidat GEDCOM</b>.<br /><br />Po kliknutí na Smazat budete svou volbu muset <b>potvrdit</b> v popup okně.";
$pgv_lang["add_gedcom_help"]			="~PŘIDÁNÍ GEDCOMU~<br /><br />Když použijete volbu Přidat GEDCOM, předpokládá se, že váš GEDCOM soubor je již nahrán na serveru - <i>užitím externího programu</i>, například pro <b>ftp</b> nebo <b>síťové</b> spojení.<br />Pokud váš soubor GEDCOM ještě není na serveru, <b>musíte</b> jej před přidáváním nejdřív nahrát.<br /><br />Program vás provede krok po kroku celou procedurou.";
$pgv_lang["add_new_gedcom_help"]		="#pgv_lang[sorry]#<br /><br />#pgv_lang[readme_help]#";
$pgv_lang["download_gedcom_help"]		="~STAŽENÍ GEDCOMU~<br /><br />Ze svých stránek si můžete stáhnout GEDCOM.<br /><br />Na stránce \"Stažení GEDCOMu\", máte možnost změnit kódování z <b>UTF-8</b> na <b>ANSI (ISO 8859-1)</b>.<br />Výběr formátu závisí na tom, v jakém programu pak chcete se souborem pracovat.<br />Nejste-li si jistí, nahlédněte do dokumentace k danému programu.";
$pgv_lang["edit_gedcoms_help"]			="~ADMINISTRACE GEDCOMU~<br /><br />Stránka administrace GEDCOMu je kontrolním centrem administrace vašich <b>současných</b> a <b>nových</b> GEDCOM souborů.<br /><dl><b>SOUČASNÉ GEDCOMY</b><br /><dt>V tabulce <b>Současné GEDCOMy</b> máte následující volby:</dt><dd>Vymazat GEDCOM</dd><dd>Upravit GEDCOM</dd><dl><dt>Upravit privátnost</dt><dd>Upravení privátnosti je také součástí této tabulky, neboť každý GEDCOM má svůj vlastní soubor s nastavením privátnosti.</dd></dl><dd>Nastavit implicitní GEDCOM</dd><dd>Importovat GEDCOM</dd><dd>Stáhnout GEDCOM</dd><dt>jsou tam 3 sloupce s následujícími informacemi:</dt><dd>Soubor GEDCOM</dd><dd>Název GEDCOMu</dd><dd>Konfigurační soubor</dd></dl><dl><b>NOVÉ GEDCOM SOUBORY</b><dt>Na této stránce máte následující možnosti přidání <b>nových</b> a / nebo <b>existujících</b> GEDCOM souborů do systému.</dt><dd>Přidat GEDCOM</dd><dd>Nahrát GEDCOM</dd><dd>Vytvořit nový GEDCOM</dd></dl>#pgv_lang[more_help]#";
$pgv_lang["edit_config_gedcom_help"]		="~KONFIGURACE GEDCOMU~<br /><br />Každý GEDCOM, který v tomto programu používáte, má svůj vlastní <b>konfigurační soubor</b>.<br /><br />V tomto formuláři můžete zvolit základní nastavení jako například: jazyk, formát kalendáře, nastavení e-mailu atd. adt.";
$pgv_lang["import_gedcom_help"]			="~IMPORTOVÁNÍ GEDCOMU~<br /><br />Ve většině případů probíhá importování GEDCOMu v jednom kroku jako například přidávání nebo nahrávání GEDCOMu.<br /><br />Tyto kroky jsou uspořádány v logický sled a musí být dokončeny, aby bylo možné s GEDCOMem pracovat.<br />V případě, že jste tuto proceduru nedokončili, uvidíte <b>varovnou</b> zprávu o tom, že GEDCOM zatím nebyl importován. V takovém případě klikněte na odkaz pro (znovu-)importování GEDCOM souboru.<br /><br /><b>Importování</b><br /><br />Konfigurační nastavení GEDCOMu se re-importováním nezmění.<br />Dosavadní údaje v databázi budou přepsány.";
$pgv_lang["upload_gedcom_help"]			="~NAHRÁNÍ GEDCOMU~<br /><br />Narozdíl od možnosti \"Přidat GEDCOM\", v tomto případě nemusíte mít ještě GEDCOM soubor na serveru.<br /><br />V 1. kroku zvolte jeden GEDCOM soubor uložený na svém (domácím) počítači. Do políčka vepište celou cestu včetně názvu souboru nebo použijte tlačítko <b>Procházet</b>.<br /><br />Na dalších stránkách najdete v průběhu tohoto procesu další nápovědu.";
$pgv_lang["validate_gedcom_help"]		="~VALIDACE GEDCOMU~<br /><br />Validace GEDCOMu, který nahráváte nebo přidáváte, je třetí krok procedury, která má zajistit, že systém s vaším souborem bude umět správně pracovat.<br /><br />Program soubor zkontroluje na správnost užití: datového formátu, formátu míst, znakové sady a dalších položek.<br />Některé z těchto odchylek, programem nalezených, budou automaticky opraveny. Příkladem jsou MacIntoshová zakončení řádků a nesprávný formát míst.<br />V těchto případech uvidíte zprávu o tom, že program změnil data.<br />V případě jiných odchylek se objeví varovná zpráva s návrhem řešení.<br /><br /><b>Volitelné nástroje</b><br />V tuto chvíli jsou k dispozici další dva nástroje:<br /><b>Změnit i ID čísla jednotlivců...</b> a <b>Nástroj přidání médií</b>.<br />Tento poslední nástroj je dostupný jen v režimu <b>MySQL</b>. Pokud máte uložený svůj GEDCOM v režimu <b>Index</b>, tato volba bude skrytá.<br /><br /><b>Další nápověda</b> je k dispozici u formuláře.#pgv_lang[more_help]#";
$pgv_lang["convert_ansi2utf_help"]		="~PŘEVEDENÍ ANSI NA UTF-8~<br /><br />Aby program správně zacházel s vašimi daty, soubory by měly být zapsány v kódování UTF-8.<br /><br />Většina genealogických programů umí GEDCOMy exportovat s tímto kódováním (UTF-8).<br />Jestliže však váš program tuto možnost nenabízí, může to udělat PhpGedView.<br /><br />Když PhpGedview kontroluje nahraný (nebo přidaný) soubor, program zjistí, jestli je soubor zapsaný v ANSI (kódování).";
$pgv_lang["detected_ansi2utf_help"]		="~ROZPOZNÁNO KÓDOVÁNÍ ANSI~<br /><br />Soubor GEDCOM, který právě prochází kontrolou, je zapsaný v kódování ANSI.<br />Je silně doporučeno, aby bylo kódování převedeno na UTF-8.<br /><br />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"]			="~ROZPOZNÁN ŠPATNÝ DATOVÝ FORMÁT:~<br /><b>FORMÁT DATA BUDE ZMĚNĚN</b><br /><br />Standarní datový formát programu PhpGedview a také dle <b>standardů GEDCOM 5.5</b> je: DD MMM YYYY (např.: 01 JAN 2004)<br /><br />Jestliže uvidíte po zkontrolování (validaci) svého GEDCOMu zprávu o tom, že byl rozpoznán špatný datový formát, program převede data do standardního tvaru.<br /><br />Avšak vy máte možnost zvolit zobrazení buď \"<b>den</b> před měsícem\" (DD MMM YYYY), nebo \"<b>měsíc</b> před dnem\" (MMM DD YYYY).<br />Doporučujeme ponechat navržené nastavení na první možnost.";
$pgv_lang["change_indi2id_help"]		="~ZMĚNIT ID OSOBY NA ....~</b><br /><br />Tento nástroj byl navržen pro uživatele, jejichž genealogický program používá při každém exportu jiná GEDCOM ID. Například, když je GEDCOM exportován poprvé, ID osoby je I100, ale při dalším exportu má osoba ID I234. Tyto změny ID čísel značně komplikují administraci PhpGedView, protože podle ID se vytváří odkazy na osoby.<br /><br />Ale většina genealogických programů používá jako jednoznačné identifikátory tagy RIN nebo REFN. Tento nástroj přepíše ID všech osob hodnotami, které určíte. Můžete zvolit mezi RIN nebo REFN.";
$pgv_lang["edit_privacy_help"]			="Na této stránce můžete vybrat nastavení privátnosti pro zvolený GEDCOM (máte-li jich více).<br />Pod titulkem stránky si můžete ověřit, jestli upravujete správný soubor privátnosti.<br />Je tam zobrazeno něco takového: (cesta/nazevvasehogedcomu_priv.php)<br /><br />Potřebujete-li změnit nějaké další nastavení, můžete tak učinit ručně v souboru privátnosti. V9ce se o tom dozvíte na internetových stránkách projektu PhpGedView.";
$pgv_lang["invalid_header_help"]		= "~NEPLATNÁ HLAVIČKA GEDCOM~<br />Soubor GEDCOM musí začínat řádkem 0 HEAD. PhpGedView zjistilo, že váš GEDCOM soubor tímto řádkem nezačíná. Poté, co kliknete na tlačítko Pokračovat, všechny řádky před řádkem 0 HEAD budou z GEDCOMu odstraněny.<br /><br />Tato chyba většinou znamená to, že váš genealogický program nevytvořil správný soubor GEDCOM nebo tento soubor není souborem GEDCOM. Měli byste si ověřit, jestli jste na server přidali správný soubor GEDCOM a jestli začíná řádkem 0 HEAD a končí řádkem 0 TRLR.";
$pgv_lang["macfile_detected_help"]		= "~ROZPOZNÁN SOUBOR PRO MACINSTOSH~<br />PhpGedView zjistilo, že váš soubor GEDCOM byl vytvořen na počítači Macintosh. Soubory pro Macintosh obsahují jiná ukončení řádků (r) než Unix (n) nebo Windows (rn). Funkce PHP, které používá systém PhpGedView, umí pracovat pouze se soubory pro Unix nebo DOS. Když kliknete na tlačítko Pokračovat, váš soubor bude převeden na soubor pro DOS.";
$pgv_lang["cleanup_places_help"]		= "~OPRAVA MÍST~<br />PhpGedView zjistilo že ve vašem souboru GEDCOM jsou místa přiřazena k údajům, kde by podle specifikace neměla být. Takovéto soubory vytváří mnoho genealogických programů, jako např. Family Tree Maker. PhpGedView s těmito soubory umí pracovat, ale některá nesprávně zařazená místa se zobrazí ve vaší hierarchii míst.<br /><br />Například, váš GEDCOM může obsahovat následující záznam<br />1 SSN<br />2 PLAC 123-45-6789<br />Podle specifikace GEDCOM by tento údaj měl být zobrazen jako<br />1 SSN 123-45-6789<br />Jestliže zvolíte Ano, PhpGedView automaticky vyhledá a opraví všechny tyto chyby v zakončení.";
$pgv_lang["empty_lines_detected_help"]	= "~NALEZENY PRÁZDNÉ ŘÁDKY~<br />PhpGedView zjistilo, že ve vašem GEDCOMu jsou prázdné řádky. Tyto řádky mohou způsobit chyby, a proto budou odstraněny ještě před importem GEDCOMu.";
$pgv_lang["help_editconfig.php"]		="~KONFIGURACE PhpGedView~<br /><br />Na této stránce musíte v případě, že jste právě nainstalovali PhpGedView na svůj server a poprvé jej spouštíte, zvolit globální nastavení programu.<br />#pgv_lang[review_readme]#<br /><br />Poněvadž toto nastavení je <b>globální</b>, platí pro celý program a pro všechny GEDCOMy v něm používané.<br />Pro každý GEDCOM si však můžete vytvořit vlastní nastavení.<br />Jelikož se nacházíte na stránce Konfigurace, můžete kliknout na odkaz pro administraci GEDCOMů (hned nad formulářem).<br />Na všech ostatních stránkách najdete tento odkaz v menu, pod ikonou MyGedView.";
$pgv_lang["help_reportengine.php"]	= "~REPORTS~<br />Nástroj pro vytváření zpráv v PhpGedView používá šablony XML pro automatické generování PDF zpráv. Zprávy dostupné ze seznamu, jsou generovány ze zpráv nalezených ve složce \"reports\". Když zvolíte zprávu, jež se má vytvořit, bude požádáni o informace specifické pro daný typ zprávy, např. výchozí osobu nebo rodinu a dotaz na zobrazení fotek. Máte-li vše zoleno, klikněte na tlačítko \"#pgv_lang[view_report]#\" a zpráva se otevře v prohlížeči, nebo klikněte na tlačítko \"#pgv_lang[download_report]#\", chcete-li zprávu rovnou stáhnout na svůj disk.<br /><br />Můžete si vytvořit vlastní typ zprávy tak, že vytvoříte kopii některého ze souborů s XML šablonou a upravíte jej. Tuto novou šablonu pak vložte do složky \"reports\". PhpGedView ji samo najde a zařadí ji do rolovacího menu pro výběr zprávy.";
$pgv_lang["help_contents_head_help"]		= "<b>OBSAH NÁPOVĚDY</b>";
$pgv_lang["help_contents_gedcom_info"]		= "GEDCOM info";
$pgv_lang["help_contents_gedcom_places"]	= "Místa v GEDCOMu";
$pgv_lang["admin_help_contents_head_help"]	= "<b>OBSAH NÁPOVĚDY<br /><br />POLOŽKY ADMINISTRÁTORSKÉ NÁPOVĚDY</b> byly přidány na začátek seznamu.";
$pgv_lang["ah2_help"]				= "_Konfigurace PhpGedView";
$pgv_lang["ah3_help"]				= "_GEDCOM: Přidání x Nahrání";
$pgv_lang["ah4_help"]				= "_GEDCOM: Konfigurační soubor";
$pgv_lang["ah5_help"]				= "_GEDCOM: Implicitní";
$pgv_lang["ah6_help"]				= "_GEDCOM: Smazání";
$pgv_lang["ah7_help"]				= "_GEDCOM: Přidání";
$pgv_lang["ah8_help"]				= "_GEDCOM: Vytvoření nového";
$pgv_lang["ah9_help"]				= "_GEDCOM: Stažení";
$pgv_lang["ah10_help"]				= "_GEDCOM: Stránka administrace";
$pgv_lang["ah11_help"]				= "_GEDCOM: Konfigurování";
$pgv_lang["ah12_help"]				= "_GEDCOM: Importování";
$pgv_lang["ah13_help"]				= "_GEDCOM: Nahrání";
$pgv_lang["ah14_help"]				= "_GEDCOM: Zkontrolování";
$pgv_lang["ah15_help"]				= "_GEDCOM: Převod z ANSI na UTF-8";
$pgv_lang["ah16_help"]				= "_GEDCOM: Nastavení privátnosti";
$pgv_lang["ah17_help"]				= "_Administrace uživatelů";
$pgv_lang["ah18_help"]				= "_Administrace";
$pgv_lang["ah19_help"]				= "_GEDCOM: Nástroj médií";
$pgv_lang["ah20_help"]				= "_GEDCOM: Změna ID osob na .......";
$pgv_lang["ah21_help"]				= "_Jazykové soubory";
?>
