<?php
/**
 * French Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2024  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: help_text.fr.php 7378 2024-11-02 14:25:09Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["useradmin_comment_help"]	= "~#pgv_lang[comment]#~<br /><br />Le texte saisi ici s'affichera lorsque le pointeur de votre souris survolera l'icône Texte dans la liste des utilisateurs. Vous devriez essayer de garder ce texte aussi bref que possible.";
$pgv_lang["useradmin_comment_exp_help"]	= "~#pgv_lang[comment_exp]#~<br /><br />Entrez la date après laquelle l'enregistrement de cet utilisateur doit être traité comme nécessitant une inspection par l'administrateur. Ces enregistrements sont mis en évidence dans la liste des utilisateurs en affichant le nom d'utilisateur en <span class='warning'>rouge</span>.<br /><br />La date doit être saisie en anglais. Exemples&nbsp;: <b>31&nbsp;DEC&nbsp;2020</b> ; <b>31&nbsp;december&nbsp;2020</b> ; <b>2020.12.31</b> ; <b>31-12-2020</b> ; <b>12/31/2020</b> etc.<br /><br />Lorsque le numéro du mois et le numéro du jour sont tous deux compris entre 1 et 12, la ponctuation (tiret ou barre oblique) détermine la signification, avec un tiret <b>-</b> signifiant que le premier chiffre est le jour du mois, tandis qu'une barre oblique <b>/</b> signifie que le premier chiffre est le mois.<br /><br />Si les informations saisies ici n'ont pas de sens pour le programme, «yesterday» sera utilisé et cet enregistrement sera toujours sélectionné pour être mis en surbrillance. «tomorrow» et les textes similaires n'ont pas de sens dans ce contexte et feront en sorte que cette fiche utilisateur ne sera jamais sélectionnée pour être mise en évidence.";
$pgv_lang["file_type_help"]			= "~#pgv_lang[choose_file_type]#~<br /><br />Choisissez le format dans lequel l'exportation de la base de données doit être créée. Votre choix dépend des exigences et des capacités du programme dans lequel vous souhaitez importer le fichier nouvellement téléchargé. Vous pouvez choisir :<br /><ul><li>#pgv_lang[def_gedcom_help]#</li><br /><br /><li>#pgv_lang[def_gramps_help]#</li></ul>";
$pgv_lang["apply_privacy_help"]		= "~#pgv_lang[apply_privacy]#~<br /><br />Lorsque cette option est cochée, le fichier de sortie passera par des vérifications de confidentialité selon l'option sélectionnée. Cela peut entraîner la suppression de certaines informations. Le fichier de sortie ne contiendra que les informations normalement visibles par un utilisateur avec le niveau de privilège indiqué.<br /><br />Si vous ne disposez que des droits #pgv_lang[gedadmin]#, vous ne pouvez pas spécifier que le fichier de sortie doit être privatisé en fonction du niveau de privilège #pgv_lang[siteadmin]#.";
$pgv_lang["convertPath_help"]		= "~#pgv_lang[convertPath]#~<br /><br />Cette option définit un chemin constant à préfixer à tous les chemins multimédias dans le fichier de sortie.<br /><br />Par exemple, si le répertoire multimédia a été configuré pour être \"/media\" et si le fichier multimédia en cours d'exportation a un chemin \"/media/photos/xyz.jpg\" et que vous avez entré \"c:\\mes photos\\ma famille\" dans ce champ, le chemin multimédia résultant sera \"c:\\mes photos\\ma famille/photos/xyz.jpg\".<br /><br />Vous remarquerez dans cet exemple :<ul><li>le nom du répertoire multimédia actuel est supprimé du chemin</li><li>et le chemin résultant n'aura pas de séparateurs de nom de dossier corrects.</li></ul><br />Si vous souhaitez conserver le répertoire multimédia dans les chemins de fichier multimédia du fichier de sortie, vous devrez inclure ce nom dans le champ <b>#pgv_lang[convertPath]#</b>.<br /><br />Vous devez également utiliser l'option <b>#pgv_lang[convertSlashes]#</b> pour vous assurer que les séparateurs de nom de dossier sont cohérents et conforment aux exigences du système d'exploitation récepteur.<br /><br />Les chemins multimédias qui sont en fait des URL ne seront pas modifiés.";
$pgv_lang["convertSlashes_help"]	= "~#pgv_lang[convertSlashes]#~<br /><br />Cette option détermine si les noms de dossier dans la spécification FILE des objets multimédias doivent être séparés par des barres obliques ou par des barres obliques inverses. Votre choix dépend des exigences du système d'exploitation récepteur.<br /><br />Le choix <b>#pgv_lang[forwardSlashes]#</b> convient à la plupart des systèmes d'exploitation autres que Microsoft Windows. Le choix <b>#pgv_lang[backSlashes]#</b> doit être utilisé lorsque le programme de destination s'exécute sur un système Microsoft Windows.<br /><br />Les chemins multimédias qui sont en fait des URL ne seront pas modifiés.";
$pgv_lang["medialist_recursive_help"]   = "~#pgv_lang[medialist_recursive]#~<br /><br />Quand cette option est cochée, la #pgv_lang[multi_title]# recherchera non seulement dans le répertoire sélectionné dans #pgv_lang[filter]#, mais également dans tous ses sous-répertoires. Dans le cas contraire, la recherche s'effectue seulement dans le répertoire sélectionné.<br /><br />Les titres des objets Multimédia trouvés sont ensuite examinés pour déterminer s'il contiennent le texte entré dans le champ #pgv_lang[filter]#.  Le résultat de ces deux actions détermine la liste des objets Multimédia à afficher.";
$pgv_lang["medialist_unlinked_help"]	= "~#pgv_lang[medialist_unlinked]#~<br /><br />Seuls les médias qui ne sont liés à aucun enregistrement GEDCOM seront affichés.";
$pgv_lang["medialist_current_dir_help"]	= "~#pgv_lang[medialist_current_dir]#~<br /><br />Sélectionnez le sous-répertoire multimédia que vous souhaitez afficher.";
$pgv_lang["sortby_help"]				 = "~#pgv_lang[sortby]#~<br /><br />Choisissez l'ordre dans lequel vous souhaitez afficher les objets Multimédia.";
$pgv_lang["help_treenav.php"]   		 = "~#pgv_lang[interactive_tree]#~<br /><br />Utilisez l' #pgv_lang[interactive_tree]# pour visualiser l'arbre familial complet d'une personne dans les deux directions. Cette vue est similaire celle du sablier  dans le sens où elle montre à la fois les ancêtres et les descendants d'une personne racine donnée. Ce diagramme vous offre une vue plus compacte en affichant des boites pour les couples et les familles au liey d'afficher simplement des individus.<br /><ul><li><b>Défilement</b><br />A chaque fois que le pointeur de votre souris se déplace sur une icône de mouvement, vous pouvez cliquer et déplacer l'arbre afin de voir d'autres parties de cet arbre. Tandis que vous déplacez l'arbre les générations futures s'étendent automatiquement jusqu'à ce qu'il n'y ait plus aucune génération à afficher dans cette direction.<br /></li><li><b>Zoom</b><br />Vous pouvez utiliser les icônes qui sont sur la partie gauche de l'arbre pour zoomer dans le sens de l'agrandissement ou de la réduction. Un zoom en réduction vous permettra de voir une plus grande partie de l'arbre sur votre écran. Au fur et à mesure que vous zoomez dans le sens d'une réduction, le texte devient de plus en plus difficile à lire ; quand votre souris passe au-dessus d'une boite, vous obtenez une vue élargie du contenu de cette boite.<br /></li><li><b>Élargir les détails</b><br />En cliquant n'importe quelle boite, vous élargissez la boite et vous obtenez une vue plus détaillée. Lorsque vous utilisez le mode d'expansion, si vous cliquez le nom d'une personne vous ouvrez sa page #pgv_lang[indi_info]#. En cliquant <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> vous redessinez l'arbre avec cette personne en tant que nouvel individu racine. En cliquant <img src='#GLOBALS[PGV_IMAGE_DIR]#/buttons/family.gif' alt='' /> vous êtes redirigé sur la page qui vous donne des détails sur la famille.<br /></li><li><b>Basculer vers les épouses</b><br />L'icône <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/sfamily.gif' width='15px' height='15px' alt='' /> juste en dessous des boutons de zoom vous basculera vers l'affichage de toutes les épouses du côté descendance. Lorsque l'affichage est paramétré pour montrer les épouses multiples, toutes les épouses de cette personne apparaîtront dans la boite. Tous les enfants de cette personne aparaîtront aussi. Quand l'option d'affichage des épouses multiples est sur <b>#pgv_lang[no]#</b>, seule la dernière épouse de cette personne sera affichée.<br /></li><li><b>Arbre large</b><br />L' #pgv_lang[interactive_tree]# est accessible à partir de beaucoup de pages différentes y compris l'onglet Arbre sur la page #pgv_lang[indi_info]# et le bloc Diagrammes sur la page d'accueil. Lorsque l'on affiche l'arbre depuis l'une de ces autres pages, vous aurez également à votre disposition une icône représentant un arbre en-dessous des icônes de zoom. Si vous cliquez <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> vous serez dirigé vers la page #pgv_lang[interactive_tree]#.</li></ul>";

$pgv_lang["move_mediadirs_help"]		 = "~#pgv_lang[move_mediadirs]#~<br /><br />Lorsque le pare-feu (firewall) est activé, les fichiers Multi-Média peuvent être placés dans un répertoire du serveur qui n'est pas accessible à partir d'Internet.<br /><br />Ces boutons vous permettent de déplacer facilement une structure complète de répertoire de média entre les répertoires protégés (qui ne peuvent donc pas être visibles depuis Internet) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> et ceux qui sont normaux <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.";
$pgv_lang["setperms_help"]  			 = "~#pgv_lang[setperms]#~<br /><br />Modifier de façon récursive les permissions des répertoires protégés (qui ne peuvent donc pas être visibles depuis Internet) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> et ceux qui sont normaux <b>#GLOBALS[MEDIA_DIRECTORY]#</b> en leur donnant les droits d'écriture ou de lecture uniquement.";
$pgv_lang["update_CHAN_text"] 			= "Les administrateurs doivent parfois nettoyer et corriger les données soumises par les utilisateurs. Par exemple, ils peuvent avoir besoin de corriger l'emplacement PLA pour inclure le pays. Lorsque les administrateurs effectuent de telles corrections, les informations sur la modification d'origine sont normalement remplacées. Cela n'est peut-être pas souhaitable.<br /><br />Lorsque cette option est choisie lors de la session d'édition ou de correction de l'administrateur, PhpGedView conservera les informations de changement d'origine au lieu de les remplacer par celles de la session en cours.";
$pgv_lang["config_update_CHAN_help"] 	= "~#pgv_lang[no_update_CHAN]#~<br /><br />Cette option contrôle l'état initial de la case «#pgv_lang[no_update_CHAN]#» qui s'affiche sur chaque page où les administrateurs peuvent apporter des modifications ou des corrections à la base de données généalogiques.<br /><br />#pgv_lang[update_CHAN_text]#";
$pgv_lang["no_update_CHAN_help"] 		= "~#pgv_lang[no_update_CHAN]#~<br /><br />#pgv_lang[update_CHAN_text]#";
$pgv_lang["edit_SOUR_EVEN_help"]		 = "~#pgv_lang[source_events]#~<br /><br />Chaque source enregistre des événements spécifiques, généralement pour une période donnée de dates et pour une juridiction. Par exemple les événements consécutifs à un recensement et les événements enregistrés par l'église comme les naissances, les mariages ou les décès.<br /><br />Choisissez les événements qui sont enregistrés par cette source à partir de la liste d'événements proposée. La date doit être saisie dans un format tel que <i>DE 1900 À 1910</i>. La juridiction à saisir est le nom du lieu le plus précis cité dans la source. Par exemple, «Le Mans, Sarthe, Pays de la Loire, France» devrait être utilisé comme source pour les différents événements enregistrés dans la ville du Mans ou par défaut le nom du canton ou département dont dépend le lieu de l'événement.";
$pgv_lang["cache_life_help"]			 = "~#pgv_lang[cache_life]#~<br /><br />Pour améliorer son exécution, ce bloc de la page d'accueil de PhpGedCom est sauvegardé comme fichier antémémoire. Vous pouvez spécifier la périodicité automatique de l'actualisation de ce bloc.<br /><ul><li><b>-1</b> signifie que le fichier antémémoire n'est jamais actualisé automatiquement. Pour obtenir une version actualisée, vous devez supprimer tous les fichiers antémémoire.  Vous pouvez le faire grâce aux options de personnalisation de la page d'accueil.</li><li><b>0</b> (Zéro) signifie que ce bloc n'est jamais enregistré dans un fichier antémémoire, et chaque fois que ce bloc est affiché sur la page d'accueil de PhpGedView, vous visualiserez la dernière version mise à jour. Ce réglage est utilisé automatiquement pour un bloc d'informations qui change régulièrement, comme le bloc #pgv_lang[logged_in_users_block]# et le bloc #pgv_lang[random_media_block]#.</li><li><b>1</b> (Un) signifie qu'une mise à jour du fichier antémémoire de ce bloc est actualisée chaque jour, <b>2</b> signifie qu'une mise à jour du bloc d'infos est réalisée tous les deux jours, <b>7</b> signifie qu'une mise à jour du bloc est réalisée chaque semaine, etc...</li></ul>";
$pgv_lang["clear_cache_help"]   		 = "~#pgv_lang[clear_cache]#~<br /><br />Afin d'améliorer les performances d'affichage, plusieurs blocs d'informations sur la page d'accueil de PhpGedView sont enregistrés comme fichiers antémémoire dans le répertoire index. Les fichiers antémémoire pour la plupart des blocs sont actualisés une fois par jour, mais il se peut que vous souhaitiez obtenir une actualisation manuelle immédiate.<br /><br />Ce bouton vous permet d'actualiser immédiatement les informations affichées et enregistrées dans le dossier temporaire si nécessaire.";
$pgv_lang["import_options_help"]		 = "Vous pouvez sélectionner des options additionelles pour l'importation de ce fichier GEDCOM.";
$pgv_lang["verify_gedcom_help"] 		 = "~#pgv_lang[verify_gedcom]#~<br /><br />Vous pouvez continuer le téléchargement et importation de ce fichier GEDCOM ou les annuler.";
$pgv_lang["add_gedcom_instructions"]	 = "Entrez un nom de fichier pour ce nouveau GEDCOM. Le nouveau fichier GEDCOM sera créé dans le répertoire d'index : #INDEX_DIRECTORY#";
$pgv_lang["random_media_start_slide_help"]= "~#pgv_lang[random_media_start_slide]#~<br /><br />Implique que le diaporama se lance automatiquement au chargement de la page.<br /><br />Le diaporama modifie le contenu du bloc sans chargement préalable des informations depuis le serveur et sans actualisation complète de la page en cours.";
$pgv_lang["random_media_ajax_controls_help"]= "~#pgv_lang[random_media_ajax_controls]#~<br /><br />Vous pouvez utiliser ce réglage pour montrer ou cacher les boutons de commande du diaporama.<br /><br />Ces commandes permettent à l'utilisateur de passer aléatoirement à un autre objet ou de lancer aléatoirement les média comme un diaporama. Le diaporama modifie le contenu du bloc sans chargement préalable des informations depuis le serveur (méthode streaming) et sans actualisation complète de la page en cours.";
$pgv_lang["edit_add_unlinked_source_help"]= "~#pgv_lang[add_unlinked_source]#~<br /><br />Utilisez ce lien pour ajouter une nouvelle source à votre base de données sans lier cette source à une source d'une autre base de données. La nouvelle source apparaîtra dans la liste des sources, mais n'apparaîtra sur aucun diagramme ou ailleurs dans le programme jusqu'à ce qu'elle soit liée à une source.";
$pgv_lang["edit_add_unlinked_note_help"]	= "~#pgv_lang[add_unlinked_note]#~<br /><br />Utilisez ce lien pour ajouter une nouvelle note partagée à votre base de données sans lier la note à un enregistrement. La nouvelle note apparaîtra dans la liste des notes partagées, mais n'apparaîtra sur aucun graphique ni ailleurs dans le programme tant qu'elle ne sera pas liée à une personne, une famille ou un événement.";
$pgv_lang["link_person_id_help"]		 = "~#pgv_lang[label_local_id]#~<br /><br />Dans ce champ vous saisissez l'identifiant (ID GEDCOM) de l'individu avec lequelle vous êtes lié (par exemple I100).";
$pgv_lang["link_gedcom_id_help"]		 = "~#pgv_lang[label_gedcom_id]#~<br /><br />Utilisez cette section pour sélectionner la base de données externe qui contient l'individu auquel vous êtes lié.";
$pgv_lang["link_remote_site_help"]  	 = "~#pgv_lang[label_site]#~<br /><br />Dans cette section vous spécifiez les paramètres exigés pour se connecter au site à distance (serveur/site) et où sont enregistrées les données que vous liez. Vous avez la possibilité de choisir depuis une liste de sites distants connus que vous avez utilisés auparavant, ou de saisir #pgv_lang[label_site_url2]# et #pgv_lang[label_gedcom_id]# pour un nouveau site.<br /><br />Dans le champ <b>#pgv_lang[label_site_url2]#</b>, vous saisissez l'URL pour accèder aux services web qui indiquera à PhpGedView comment accèder aux données sur le site distant. Pour un site web distant PhpGedView, l'URL du fichier WSDL (<b>W</b>eb <b>S</b>ervices <b>D</b>escription fi<b>l</b>e, soit fichier de description des services Web) devrait être similaire à ceci : <u>http://www.remotesite.com/phpGedView/genservice.php?wsdl</u><br /><br />Le champ <b>#pgv_lang[label_gedcom_id]#</b> est utilisé pour saisir l'identifiant de la base de données du site distant requis pour la connexion. Pour les sites web PhpGedView, c'est le nom du fichier GEDCOM.<br /><br />Les champs <b>#pgv_lang[label_username_id]#</b> et <b>#pgv_lang[label_password_id]#</b> sont obligatoires si la base de données les demande.";
$pgv_lang["link_remote_location_help"]  = "~#pgv_lang[label_location]#~<br /><br />Cette option vous permet de choisir si les données que vous liez à cet individu sont sur le même site mais d'une base de données généalogiques différente, ou si les données se trouvent sur un site distant accessible via Internet.<br /><br />Si l'individu est enregistré sur le même site, vous serez invité à sélectionner son identifiant (nom) et son ID (GEDCOM).<br /><br />Dans le cas d'un site distant, vous serez invité à saisir son URL, le nom de la base de données et l'ID (identifiant) de l'individu.";
$pgv_lang["link_remote_rel_help"]   	 = "~#pgv_lang[label_rel_to_current]#~<br /><br />Utilisez cette option pour choisir la relation entre l'individu distant et l'individu enregistré sur votre site.  Par exemple, si vous sélectionnez <i>Père</i>, cela signifie que l'individu enregistré sur le site distant est le père de l'individu enregistré localement.";
$pgv_lang["link_remote_help"]   		 = "~#pgv_lang[link_remote]#~<br /><br />Utilisez ce formulaire pour lier des individus à d'autres individus enregistrés sur d'autres sites ou sur d'autres bases de données généalogiques accessibles depuis votre copie de PhpGedView.<br /><br />Pour ajouter un tel lien, vous devez d'abord choisir le type de lien, ensuite choisir un site déjà référencé dans PhpGedView ou déclarer un nouveau site, et ensuite saisir l'ID sur le site de l'individu que vous souhaitez lier. PhpGedView téléchargera automatiquement les informations depuis le site distant si nécessaire. Les informations téléchargées <u>ne seront pas</u> intégrées à votre base de données généalogiques ; elles resteront à leur emplacement original mais seront affichées dans les différentes pages où les informations sur cet individu distant lié à votre base sont affichées.<br /><br />Reportez-vous au lien de l'aide à côté de chaque élément de la page pour plus d'informations. Vous pouvez également consulter le tutoriel en ligne (en anglais) à l'adressse suivante : <a href=\"#PGV_PHPGEDVIEW_WIKI#/en/index.php?title=How_To:Remote_Link_Individuals_Across_Websites_And_Databases\" target=\"_blank\">#PGV_PHPGEDVIEW_WIKI#</a>.";

//-- Edit Interface
$pgv_lang["edit_REPO_NAME_help"]	= "~#factarray[REPO:NAME]#~<br /><br />Le nom de la bibliothèque, de l'archive ou de tout autre référentiel dans lequel le matériel source est stocké.";
$pgv_lang["edit_REPO_ADDR_help"]	= "~#factarray[REPO:ADDR]#~<br /><br />L'adresse de cette bibliothèque, archive ou autre référentiel. Saisissez l'adresse comme vous l'écririez sur une enveloppe.<br /><br />Laissez ce champ vide si vous ne voulez pas inclure d'adresse.";
$pgv_lang["edit_REPO_PHON_help"]	= "~#factarray[REPO:PHON]#~<br /><br />Le numéro de téléphone de cette bibliothèque, archive ou autre référentiel. Entrez le numéro avec l'indicatif du pays et de la région. Par exemple, un numéro en Allemagne peut être +49 25859 56 76 89 et un numéro aux États-Unis ou au Canada peut être +1 888 555-1212.<br /><br />Laissez ce champ vide si vous ne voulez pas inclure un numéro de téléphone.";
$pgv_lang["edit_REPO_FAX_help"]		= "~#factarray[REPO:FAX]#~<br /><br />Le numéro de FAX de cette bibliothèque, archive ou autre référentiel. Entrez le numéro avec l'indicatif du pays et de la région. Par exemple, un numéro en Allemagne peut être +49 25859 56 76 89 et un numéro aux États-Unis ou au Canada peut être +1 888 555-1212.<br /><br />Laissez ce champ vide si vous ne voulez pas inclure un numéro de FAX.";
$pgv_lang["edit_REPO_EMAIL_help"]	= "~#factarray[REPO:EMAIL]#~<br /><br />L'adresse e-mail de cette bibliothèque, archive ou autre référentiel. Saisissez l'adresse e-mail. Exemple: <b>name@hotmail.com</b><br /><br />Laissez ce champ vide si vous ne voulez pas inclure d'adresse e-mail.";
$pgv_lang["edit_REPO_WWW_help"]		= "~#factarray[REPO:WWW]#~<br /><br />La page d'accueil Internet de cette bibliothèque, archive ou autre référentiel. Saisissez l'adresse de la page d'accueil, y compris http:// ou https://. Exemple: <b>https://www.phpgedview.net/</b><br /><br />Laissez ce champ vide si vous ne voulez pas inclure d'adresse de page d'accueil.";
$pgv_lang["edit_CALN_help"]			= "~#factarray[CALN]#~<br /><br />Une description d'identification ou de référence utilisée pour classer et récupérer des éléments des fonds d'une bibliothèque, d'une archive ou d'un autre référentiel. Les référentiels informels n'ont généralement pas besoin d'utiliser un système #factarray[CALN]#.";
$pgv_lang["edit_REPO_help"]			= "~#factarray[REPO]#~<br /><br />C'est le numéro d'identification de la bibliothèque, de l'archive ou de tout autre dépôt où le matériel source référencé est stocké. Le titre de l'archive actuelle sera affiché sous le numéro d'identification.<br /><br />Vous pouvez changer le numéro d'identification de l'archive où ce matériel source est stocké. Pour supprimer la référence d'archive, laissez ce champ vide. Cette action ne supprime pas l'enregistrement d'archive de la base de données; seule la référence est supprimée.<br /><br />Si vous entrez directement l'ID d'archive souhaité, cet enregistrement d'archive doit déjà exister dans la base de données. Vous pouvez cliquer <b>#pgv_lang[find_repository]#</b> pour rechercher le numéro d'identification d'une archive existante. Cliquez <b>#pgv_lang[create_repository]#</b> si vous devez saisir un nouvel enregistrement d'archive.";
$pgv_lang["edit_PUBL_help"]			= "~#factarray[PUBL]#~<br /><br />Quand et où l'enregistrement a été créé. Pour les œuvres publiées, cela inclut des informations telles que la ville de publication, le nom de l'éditeur et l'année de publication.<br /><br />Pour une œuvre non publiée, il doit inclure la date à laquelle la notice a été créée et le lieu où cela a été créé. Par exemple, le comté et l'État de résidence d'une personne faisant une déclaration de pension ou la ville et l'État de résidence de l'auteur d'une lettre ou d'une histoire familiale privée.";
$pgv_lang["edit_AUTH_help"]			= "~#factarray[AUTH]#~<br /><br />La personne, l'agence ou l'entité qui a créé l'enregistrement. Pour un travail publié, il peut s'agir de l'auteur, du compilateur, du transcripteur, de l'abstracteur ou de l'éditeur. Pour une source non publiée, il peut s'agir d'un individu, d'une agence gouvernementale, d'une organisation religieuse ou privée, etc.";
$pgv_lang["edit_REFN_help"]			= "~#factarray[REFN]#~<br /><br />Ce champ est normalement utilisé pour enregistrer du texte au format libre pour identifier cet enregistrement GEDCOM. Par exemple, il peut s'agir d'un numéro de dossier dans un système automatisé ou manuel, ou d'un numéro de page et de position sur un arbre généalogique.<br /></br />Lorsque la configuration GEDCOM a été définie pour permettre à l'utilisateur de remplacer le numéro d'identification généré automatiquement pour les nouvelles personnes, ce numéro d'identification de remplacement est entré ici. Dans ce cas, le texte doit être conforme aux règles établies pour les numéros d'identification. Les numéros d'identification valides ne peuvent contenir que les lettres <b>A</b> à <b>Z</b>, <b>a</b> à <b>z</b>, les chiffres <b>0</b> à <b>9</b>, et les symboles spéciaux <b>. : -</b> et <b>_</b><br /><br />L'option qui permet d'utiliser le #factarray[REFN]# à la place du numéro d'identification généré automatiquement se trouve dans la configuration GEDCOM, section Options d'édition.";
$pgv_lang["edit_ABBR_help"] 			 = "~#factarray[ABBR]#~<br /><br />Utilisez ce champ pour enregistrer une version abrégée d'un titre. Ce champ est utilisé en combinaison avec le champ titre des sources. Par défaut PGV utilisera en premier le titre et ensuite le titre abrégé.<br /><br />Selon les spécifications de GEDCOM 5.5, «Cette entrée doit fournir un titre court utilisé pour classer et rechercher les enregistrements de la source (pg 62).»<br /><br />Dans PhpGedView le titre abrégé est optionnel, mais dans d'autres programmes généalogiques, il est obligatoire.";
$pgv_lang["edit_ROMN_help"] 			 = "~#factarray[NAME:ROMN]#~<br /><br />#pgv_lang[edit_ROMN_advice]#";
$pgv_lang["edit_ROMN_advice"]			= "Dans de nombreuses cultures, il est commun de porter un nom traditionnel écrit dans la langue traditionnelle et un nom romanisé qui pourra être écrit ou prononcé dans les langues d'origine latine, comme le français ou l'anglais.<br /><br />Si vous préférez utiliser un alphabet différent du latin, comme l'hébreu, le grec, le russe, le chinois ou l'arabe pour saisir le nom dans le champs standards du nom, alors vous pouvez utiliser ce champ pour saisir le nom utilisé en alphabet latin. Les deux versions du nom appairaîtront dans les listes et les diagrammes.<br /><br />Bien que ce champ soit marqué «Romanisé», il n'est pas limité aux caractères latins.  Ceci pourrait être utile avec des noms japonais pour lesquels trois alphabets différents peuvent être utilisés.";
$pgv_lang["edit_ROMN_GIVN_help"]		= "~#pgv_lang[roman_givn]#~<br /><br />#pgv_lang[edit_ROMN_advice]#<br /><br />Dans ce champ, vous devez saisir les prénoms de la personne. A titre d'exemple, dans le nom \"John Robert Finlay\", les prénoms à saisir ici sont \"John Robert\".";
$pgv_lang["edit_ROMN_SURN_help"]		= "~#pgv_lang[roman_surn]#~<br /><br />#pgv_lang[edit_ROMN_advice]#<br /><br />Dans ce champ, vous devez saisir le nom de famille de la personne. A titre d'exemple, dans le nom \"John Robert Finlay\", le nom de famille à saisir ici est \"Finlay\".<br /><br />Les personnes ayant plusieurs noms de famille, communs en Espagne et au Portugal, doivent séparer les noms par une virgule. Cela indique que la personne doit être répertoriée sous chacun des noms. Par exemple, le nom de famille \"Cortes,Vega\" sera répertorié à la fois sous <b>C</b> et <b>V</b>, tandis que le nom \"Cortes Vega\" ne sera répertorié que sous <b>C</b>.";
$pgv_lang["edit__HEB_help"]				= "~#factarray[_HNM]#~<br /><br />#pgv_lang[edit__HEB_advice]#";
$pgv_lang["edit__HEB_advice"]			= "Dans de nombreuses cultures, il est commun de porter un nom traditionnel écrit dans la langue traditionnelle et un nom romanisé qui pourra être écrit ou prononcé dans les langues d'origine latines, comme le français ou l'anglais.<br /><br />Si vous préférez utiliser un alphabet différent du latin, comme l'hébreu, le grec, le russe, le chinois ou l'arabe pour saisir le nom dans le champs standard du nom, alors vous pouvez utiliser ce champs pour saisir le nom utilisé en alphabet latin. Les deux versions du nom appairaîtront dans les listes et les diagrammes.<br /><br />Bien que ce champ soit marqué «Hébreu», il n'est pas limité aux caractères hébreux.";
$pgv_lang["edit__HEB_GIVN_help"]		= "~#pgv_lang[hebrew_givn]#~<br /><br />#pgv_lang[edit__HEB_advice]#<br /><br />Dans ce champ, vous devez saisir les prénoms de la personne. A titre d'exemple, dans le nom \"John Robert Finlay\", les prénoms à saisir ici sont \"John Robert\".";
$pgv_lang["edit__HEB_SURN_help"]		= "~#pgv_lang[hebrew_surn]#~<br /><br />#pgv_lang[edit__HEB_advice]#<br /><br />Dans ce champ, vous devez saisir le nom de famille de la personne. A titre d'exemple, dans le nom \"John Robert Finlay\", le nom de famille à saisir ici est \"Finlay\".<br /><br />Les personnes ayant plusieurs noms de famille, communs en Espagne et au Portugal, doivent séparer les noms par une virgule. Cela indique que la personne doit être répertoriée sous chacun des noms. Par exemple, le nom de famille \"Cortes,Vega\" sera répertorié à la fois sous <b>C</b> et <b>V</b>, tandis que le nom \"Cortes Vega\" ne sera répertorié que sous <b>C</b>.";
$pgv_lang["edit_SEX_help"]				= "#pgv_lang[edit_sex_help]#";
$pgv_lang["edit_NAME_help"]				= "#pgv_lang[edit_name_help]#";
$pgv_lang["edit_add_unlinked_person_help"]= "~#pgv_lang[add_unlinked_person]#~<br /><br />Utilisez ce formulaire pour ajouter une personne isolée.<br /><br />Quand vous ajoutez une personne isolée à votre arbre généalogique, la personne restera isolée tant que vous ne la relierez pas à une autre. Plus tard, vous pourrez lier des personnes ensemble à partir de l'onglet «#pgv_lang[relatives]#» de l'individu.";
$pgv_lang["edit_URL_help"]  			 = "~#factarray[URL]#~<br /><br />Entrez l'adresse URL y compris le sigle http://. Exemple : <b>http://www.phpgedview.net/</b><br /><br />Laissez ce champ vide si vous ne souhaitez pas inclure une adresse URL.";
$pgv_lang["edit_WWW_help"]  			 = "~#factarray[WWW]#~<br /><br />Entrez l'adresse de la page d'accueil Web y compris le sigle http://. Exemple : <b>http://www.phpgedview.net/</b><br /><br />Laissez ce champ vide si vous ne souhaitez pas inclure une adresse Web.";
$pgv_lang["edit_EMAIL_help"]			 = "~#factarray[EMAIL]#~<br /><br />Saisissez l'adresse mail. Exemple : <b>nom@hotmail.com</b><br /><br />Laissez ce champ en blanc si vous ne voulez pas inclure d'adresse mail.";
$pgv_lang["edit_FAX_help"]  			 = "~#factarray[FAX]#~<br /><br />Saisissez le numero de FAX y compris le numéro du pays, et de la zone si il y a lieu. Par exemple, un numéro de FAX en France doit être du type (sans le zero du début) :  +33 491422679 et un numéro aux USA ou au Canada doit être du type : +1 888 555-1212.<br /><br />Laissez ce champ à blanc si vous ne voulez pas inclure de numéro FAX.";
$pgv_lang["edit_PHON_help"] 			 = "~#factarray[PHON]#~<br /><br />Saisissez le numéro de téléphone y compris le numéro du pays, et de la zone si il y a lieu. Par exemple, un numéro de téléphone en France doit être du type (sans le zero du début) :  +33 491422679 et un numéro aux USA ou au Canada doit être du type : +1 888 555-1212.<br /><br />Laissez ce champ en blanc si vous ne voulez pas inclure de numéro de téléphone.";
$pgv_lang["edit_ADDR_help"] 			 = "~#factarray[ADDR]#~<br /><br />Saisissez l'adresse dans le champ exactement comme si vous l'écriviez sur une enveloppe.<br /><br />Laissez ce champ à blanc si vous ne souhaitez pas inclure d'adresse.";
$pgv_lang["edit_GIVN_help"] 			 = "#pgv_lang[edit_given_name_help]#";
$pgv_lang["edit_SPFX_help"]			= "~#factarray[SPFX]#~<br /><br />Entrez ou sélectionnez dans la liste les mots qui précèdent la partie principale du nom de famille. Des exemples de tels mots sont <b>von</b> Braun, <b>van der</b> Kloot, <b>de</b> Graaf, etc.<br /><br />Dans certaines circonstances, un titre de noblesse peut être saisi ici. Par exemple, Peter <b>Freiherr von</b> QuelquePart. La partie «Freiherr» est en fait un titre de noblesse et ne doit pas être répétée comme fait #factarray[TITL]#. Ce qui est saisi ici dépend en grande partie des préférences de la personne en question.";
$pgv_lang["edit_SURN_help"] 			 = "#pgv_lang[edit_surname_help]#";
$pgv_lang["edit__MARNM_help"]   		 = "~#factarray[_MARNM]#~<br /><br />Écrivez le nom de mariage pour cet individu en utilisant les mêmes règles de formatage qui s'appliquent au champ relatif au Nom. Ce champ est facultatif.<br /><br />Par exemple, si Marie Jane Brown a été mariée à John White, vous saisirez (sans guillemets naturellement)<ul><li>Usage américain :&nbsp;&nbsp;«Marie Jane Brown /White/»</li><li>Usage européen :&nbsp;&nbsp;«Marie Jane /White/»</li><li>Usage européen alternatif :&nbsp;&nbsp;«Marie Jane /White-Brown/» ou «Marie Jane /Brown-White/»</li></ul>Vous devriez faire ceci seulement si Marie Brown commençait à s'appeler par le nouveau nom après s'être mariée à John White. Dans quelques endroits, Québec (Canada) par exemple, il est illégal de changer les noms de cette façon.<br /><br />Les hommes changent parfois leur nom après le mariage, le plus souvent sous la forme composée (nom d'époux et de la femme - mise en trait d'union) mais plus occasionnellement en prenant le nom de leur femme.";
$pgv_lang["edit_PEDI_help"] 			 = "~#factarray[PEDI]#~<br /><br />Ce champ décrit la relation entre l'enfant et sa famille. Les différentes possibilités sont les suivantes :<ul><li><b>#pgv_lang[unknown]#</b>&nbsp;&nbsp;&nbsp;La relation entre l'enfant et sa famille ne peut pas être déterminée. Quand cette option est choisie, le champ #factarray[PEDI]# ne sera pas copié dans la base de données.</li><li><b>#factarray[BIRT]#</b>&nbsp;&nbsp;&nbsp;Cette option indique que l'enfant a un lien de naissance avec sa famille.</li><li><b>#pgv_lang[adopted]#</b>&nbsp;&nbsp;&nbsp;Cette option indique que l'enfant a été adopté par sa famille.  Cela <i>n'indique pas</i> qu'il n'y aucun lien de sang entre l'enfant et sa famille ; cela indique que l'enfant a été adopté par la famille quelque temps après la naissance de l'enfant.</li><li><b>#pgv_lang[foster]#</b>&nbsp;&nbsp;&nbsp;Cette option indique que l'enfant est un enfant adoptif de la famille.  Habituellement, il n'y aucun lien de sang entre l'enfant et sa famille.</li><li><b>#pgv_lang[sealing]#</b>&nbsp;&nbsp;&nbsp;L'enfant a été uni à sa famille lors d'une cérémonie <i>d'union</i> SDJ.  Une cérémonie d'union est réalisée lorsque les parents se sont unis l'un à l'autre après la naissance de l'enfant. Les enfants qui sont nés après l'union des parents sont automatiquement unis à la famille.</li></ul>";
$pgv_lang["edit_AGNC_help"] 			 = "~#factarray[AGNC]#~<br /><br />L'organisation, l'institution, la corporation, la personne, ou toute autre entité qui a l'autorité.<br /><br />Par exemple, l'employeur d'une personne, ou une organisation/église qui a la responsabilité de la création ou de l'archivage des enregistrements.";
$pgv_lang["edit_MARR_TYPE_help"]	= "~#factarray[MARR]#:#factarray[TYPE]#~<br /><br />Ce champ décrit le type d’union qui a formé la famille.<ul><li><b>#factarray[MARR_RELIGIOUS]#</b>&nbsp;&nbsp;&nbsp;indique que la cérémonie qui officialisait l'union de deux personnes pour former une famille était célébrée par un prêtre, un évêque, un cardinal, un prédicateur, un rabbin, un chaman ou une personne similaire. La cérémonie n'avait pas nécessairement lieu dans une église, une synagogue, un temple ou un autre lieu consacré. Cela aurait pu se passer à l’extérieur ou dans une maison privée.</li><li><b>#factarray[MARR_CIVIL]#</b>&nbsp;&nbsp;&nbsp;indique que la cérémonie qui officialisait l'union de deux personnes pour former une famille était célébrée par un juge, un magistrat, un maire ou une personne d'autorité similaire qui n'est pas un prêtre, etc. L'autorisation de célébrer de telles cérémonies est généralement accordée par un gouvernement. La cérémonie n'avait pas nécessairement lieu dans une salle d'audience ou un bureau.</li><li><b>#factarray[MARR_PARTNERS]#</b>&nbsp;&nbsp;&nbsp;décrit la relation entre deux personnes qui ne sont pas mariées l'une à l'autre et qui se comportent comme si elles étaient une famille. Elles n'ont <u>pas</u> participé à une cérémonie de mariage célébrée par un prêtre, un évêque, un juge, un maire ou aucune autre personne ayant l'autorité de célébrer des mariages. Elles peuvent avoir fait une déclaration publique selon laquelle elles se considèrent mariées, mais ce n'est pas une obligation.</li><li><b>#factarray[MARR_UNKNOWN]#</b>&nbsp;&nbsp;&nbsp;indique que les détails de l’union entre deux personnes pour former une famille ne sont pas connus.</li></ul>";

$pgv_lang["context_help"]   			 = "Une aide est disponible en cliquant <b>#pgv_lang[qm]#</b> des différents champs de la page.";

$pgv_lang["register_gedcomid_help"] 	 = "~#pgv_lang[gedcomid]#~<br /><br />Chaque personne figurant dans la base est identifiée par un numéro d'ID unique sur ce site. Si vous connaissez le numéro d'ID de votre enregistrement, le saisir ici. Si vous ne le connaissez pas ou ne pouvez pas le trouver à cause des règles de protections sur la vie privée, veuillez laisser assez de renseignements dans le champ commentaires pour aider l'administrateur du site à vous identifier, afin de mettre à jour ce champ avec votre numéro d'ID.";
$pgv_lang["register_comments_help"] 	 = "~#pgv_lang[comments]#~<br /><br />Utilisez ce champ pour dire à l'administrateur du site pourquoi vous souhaitez un compte et en quoi vous êtes concerné par les informations généalogiques présentées sur ce site. Vous pouvez aussi utiliser ce champ pour tout autre commentaire à l'attention de l'administrateur.";
$pgv_lang["utf8_ansi_help"] 			 = "~#pgv_lang[utf8_to_ansi]#~<br /><br />Pour un affichage optimal sur Internet, PhpGedView utilise le codage des caractères en UTF-8. Certains programmes, Family Tree Maker par exemple, ne supportent pas l'importation de fichier GEDCOM encodé en UTF-8. Cocher cette case entrainera la conversion du fichier de l'<b>UTF-8</b> à l'<b>ANSI (ISO 8859-1)</b>.<br /><br />Le format dont vous avez besoin dépend donc du programme que vous utilisez pour ouvrir et importer votre GEDCOM. Si vous avez un doute, consultez la documentation de votre programme.<br /><br />Notez que pour conserver certains caractères spéciaux, vous devez garder le fichier en UTF-8 et le convertir avec la méthode appropriée de votre programme. Consultez votre éditeur ou l'auteur.<br /><br />Cet <a href='https://fr.wikipedia.org/wiki/UTF-8' target='_blank' title='article Wikipédia'><b>article Wikipédia</b></a> contient des informations complètes et des liens sur UTF-8.";
$pgv_lang["remove_tags_help"]   		 = "~#pgv_lang[remove_custom_tags]#~<br /><br />Cochant cette option effacera tous les tags qui peuvent avoir été ajoutés par PhpGedView.<br /><br />Ces tags utilisés par PhpGedView comprennent le tag <b>_PGVU</b> qui identifie l'utilisateur ayant modifié un enregistrement en ligne et le tag <b>_THUM</b> qui indique à PhpGedView que l'image peut être utilisée comme miniature.<br /><br />Ces tags peuvent provoquer des erreurs à l'importation du fichier GEDCOM dans un autre programme de généalogie.";
$pgv_lang["download_zipped_help"]   	 = "~#pgv_lang[zip_files]#~<br /><br />Quand vous cochez cette option, une copie du fichier GEDCOM sera comprimée dans le format ZIP avant le téléchargement. Ceci réduira sa taille considérablement, mais vous devrez employer un logiciel compatible (WINZIP par exemple) pour le décomprimer puis l'utiliser.<br /><br />C'est une option utile pour télécharger des fichiers GEDCOM volumineux. En effet, il y a un risque que le temps de téléchargement d'un fichier non comprimé excède le temps maximum d'exécution alloué par le système, ayant pour résultat un téléchargement incomplet du fichier.  L'option ZIP peut réduire le temps de téléchargement de 75%.";
$pgv_lang["edit_NCHI_help"] 			 = "~#factarray[NCHI]#~<br /><br />Saisissez le nombre d'enfants pour cet individu ou cette famille. Ce champ est facultatif.";
$pgv_lang["edit_TIME_help"] 			 = "~#factarray[TIME]#~<br /><br />Saisissez l'heure de l'événement sous la forme HH:MM. Exemples : 04:50 13:00 20:30.";
$pgv_lang["edit_NOTE_help"] 			 = "~#factarray[NOTE]#~<br /><br />Une note est un texte libre qui s'affichera dans l'onglet Détails.";
$pgv_lang["edit_SHARED_NOTE_help"]		= "~#pgv_lang[shared_note]#~<br /><br />Les notes partagées sont du texte de forme libre et apparaîtront dans la section Détails des Faits de la page.<br /><br />Chaque note partagée peut être liée à plusieurs personnes, familles, sources ou événements.";
$pgv_lang["edit_CEME_help"] 			 = "~#factarray[CEME]#~<br /><br />Saisissez le nom du cimetière où cette personne est enterrée. ";
$pgv_lang["edit_ASSO_help"]			= "~#factarray[ASSO]#~<br /><br />Entrez l'ID GEDCOM de la personne dont vous souhaitez décrire la relation avec la personne actuelle.";
$pgv_lang["edit_RELA_help"]			= "~#factarray[RELA]#~<br /><br />Sélectionnez une #factarray[RELA]# dans la liste. Sélectionner <b>#pgv_lang[godfather]#</b> signifie&nbsp;: <i>La personne identifiée dans le champ #factarray[ASSO]# est le #pgv_lang[godfather]# de la personne actuelle</i>.";
$pgv_lang["show_spouse_help"]   		 = "~#pgv_lang[show_spouses]#~<br /><br />Par défaut, ce diagramme ne présente pas les conjoints pour les descendants, car cela rend celui-ci difficile à lire et à comprendre. Cochez cette option si vous voulez voir figurer les conjoints sur le diagramme.";
$pgv_lang["reorder_families_help"]  	 = "~#pgv_lang[reorder_families]#~<br /><br />Les membres d'une famille sont présentés sur l'onglet #pgv_lang[relatives]# dans l'ordre où ils apparaissent à l'intérieur des enregistrements de la personne dans le fichier GEDCOM. Les familles ne sont pas triées par date de mariage, car celles-ci sont souvent inconnues, alors que <u>l'ordre</u> des mariages l'est.<br /><br />Cette option vous permet de changer l'ordre de présentation des familles dans l'onglet  #pgv_lang[relatives]#.  Si vous souhaitez trier les familles par date de mariage, cette option le fera automatiquement.";
$pgv_lang["autoContinue_help"]  		 = "~#pgv_lang[autoContinue]#~<br /><br />Lorsque PhpGedView détecte que la phase d'import du fichier GEDCOM demande plus de temps qu'autorisé par le paramètre temps limite, il fera apparaître le bouton <b>#pgv_lang[del_proceed]#</b> que vous devrez presser afin de continuer l'import.<br /><br />Lorsque cette option est sélectionnée à <b>#pgv_lang[yes]#</b>, PhpGedView pressera automatiquement le bouton <b>#pgv_lang[del_proceed]#</b>.  Cela vous évitera le travail ennuyeux qui vous oblige à presser ce bouton de manière répétée lorsque vous avez des imports de fichiers GEDCOM volumineux.";
$pgv_lang["firstname_i_help"]   		 = "~#pgv_lang[firstname_alpha_index]#~<br /><br />Le nom de famille que vous avez choisi concerne plus de #GLOBALS[SUBLIST_TRIGGER_I]# individus.<br /><br />Pour vous aider à trouver l'individu que vous souhaitez, la liste a été réduite aux noms commençant par la première lettre du nom que vous avez donné.  Ce sous-index alphabétique fonctionne de la même manière que l'index alphabétique des noms de famille.<ul><li>Cliquez une lettre pour voir tous les prénoms qui commmencent par cette lettre.</li><li>Choisissez <b>#pgv_lang[PN]#</b> pour lister tous les individus avec des prénoms inconnus.</li><li>Le choix <b>#pgv_lang[all]#</b> affichera une liste de tous les individus avec le nom de famille précédement sélectionné.</li></ul>";
$pgv_lang["firstname_f_help"]   		 = "~#pgv_lang[firstname_alpha_index]#~<br /><br />Le nom de famille que vous avez choisi concerne plus de #GLOBALS[SUBLIST_TRIGGER_F]# individus.<br /><br />Pour vous aider à trouver la famille que vous souhaitez, la liste a été réduite aux noms commençant par la première lettre du nom que vous avez donné.  Ce sous-index alphabétique fonctionne de la même manière que l'index alphabétique des noms de famille.<ul><li>Cliquez une lettre pour voir tous les prénoms qui commmencent par cette lettre.</li><li>Choisissez <b>#pgv_lang[PN]#</b> pour lister tous les individus avec des prénoms inconnus.</li><li>Le choix <b>#pgv_lang[all]#</b> affichera une liste de tous les familles avec le nom précédement sélectionné.</li></ul>";
$pgv_lang["edit_TYPE_help"] 			 = "~#factarray[TYPE]#~<br /><br />Le champ #factarray[TYPE]# vous permet de spécifier un évenement particulier. C'est un champ libre dans lequel vous pouvez saisir toute information que vous voulez mémoriser.";
$pgv_lang["edit_TEMP_help"] 			 = "~#factarray[TEMP]#~<br /><br />Pour des ordinations SDJ, ce champ enregistre le nom du temple où il s'est déroulé.";
$pgv_lang["edit_STAT_help"] 			 = "~#factarray[STAT]#~<br /><br />C'est un champ optionnel qui est utilisé principalement pour les ordinations SDJ lorsqu'elles sont effectuées selon le logiciel TempleReady.";
$pgv_lang["edit__PRIM_help"]			 = "~#factarray[_PRIM]#~<br /><br />Utilisez ce champ pour signaler que ce média est le média principal de l'individu auquel il est attaché. L'image principale est celle qui sera utilisée dans les diagrammes et sur la page de l'individu.";
$pgv_lang["edit__THUM_help"]			= "~#factarray[_THUM]#~<br /><br />Cette option vous permet de remplacer la sélection habituelle d'une image miniature.<br /><br />Le GEDCOM a une option de configuration qui spécifie si PhpGedView doit envoyer la grande ou la petite image au navigateur chaque fois que la page actuelle nécessite une miniature. L'option «#factarray[_THUM]#», lorsqu'elle est réglé sur <b>#pgv_lang[yes]#</b>, remplace temporairement le paramètre de l'option de configuration GEDCOM, de sorte que PhpGedView envoie toujours la grande image. Vous ne pouvez pas forcer PhpGedView à envoyer la petite image lorsque la configuration GEDCOM spécifie que les grandes images doivent toujours être utilisées.<br /><br />PhpGedView ne redimensionne pas l'image envoyée ; le navigateur le fait selon les spécifications de page qu'il a également reçues. Cela peut avoir des conséquences indésirables lorsque l'image envoyée n'est pas vraiment une vignette où PhpGedView s'attend à envoyer une petite image. Ce n'est pas une erreur: il y a des occasions où il peut être préférable d'afficher une grande image à des endroits où l'on s'attend normalement à voir une image de la taille d'une vignette.<br /><br />Vous devez éviter de régler l'option «#factarray[_THUM]#» à <b>#pgv_lang[yes]#</b>. Ce choix entraînera l'envoi de quantités excessives de données liées à l'image au navigateur, seulement pour que le navigateur rejette l'excédent. Le chargement des pages, en particulier des graphiques comportant de nombreuses images, peut être considérablement ralenti.";
$pgv_lang["edit_TITL_help"] 			 = "~#factarray[TITL]#~<br /><br />Saisissez un titre pour l'objet que vous mettez à jour. Si c'est un titre pour un objet multimédia, donnez un titre descriptif pour son identification par l'utilisateur.<br /><br />Si vous modifiez les détails d'une personne, utilisez ce champ pour saisir des informations sur la noblesse telles que <i>Sir, Lord, Baron, Comte, Duc, Graf, Freiherr,</i> etc.<br /><br />Les désignations professionnelles telles que <i>Dr., Admiral, Lt.Gen., Rev., Sister,</i> etc. doivent être saisies dans le sous-champ «#factarray[NPFX]#», tandis que les suffixes de nom tels que <i>Jr., Sr., III, IV,</i> etc. et les informations académiques telles que <i>PhD, PEng, FimechE, DVM, MD,</i> etc. appartiennent au sous-champ «#factarray[NSFX]#».";
$pgv_lang["edit_FILE_help"] 			 = "~#factarray[FILE]#~<br /><br />C'est le champ le plus important pour l'enregistrement de l'objet multimédia. Il indique quel est le fichier à utiliser. Vous devez saisir au minimum le nom du fichier. En fonction de vos paramètres, plus d'information à propos de la localisation du fichier peut être utile.<br /><br />Vous pouvez utiliser le lien <b>#pgv_lang[find_media]#</b> pour vous aider à localiser les objets multimédia que vous avez déjà chargés sur le site.<br /><br />#pgv_lang[readme_help]#";
$pgv_lang["edit_FORM_help"] 			 = "~#factarray[FORM]#~<br /><br />C'est un champ optionnel qui peut être utilisé pour renseigner le type de fichier multimédia. Certains programmes généalogiques regardent ce champ pour déterminer comment traiter le fichier. De toute façon, comme les transferts de fichiers média entre systèmes ne sont pas toujours évidents, ce champ n'est pas très important.";
$pgv_lang["generate_thumb_help"]		 = "~#pgv_lang[auto_thumbnail]#~<br /><br />Nous avons détecté que votre système est capable de générer automatiquement des miniatures pour certains type d'images (cela peut être les fichiers BMP, JPG, GIF, et PNG). Les types que votre système gère sont listés à coté de la case à cocher.<br /><br />En cliquant cette case, vous signalez au système que vous chargez des images de ce type et que vous désirez qu'il essaie de générer les miniatures correspondantes. Laissez cette case vide si vous chargez vos propres miniatures.";
$pgv_lang["edit_add_NOTE_help"] 		 = "~#pgv_lang[add_note]#~<br /><br />Cette partie vous permet d'ajouter une note relative à l'évenement que vous mettez à jour. Les notes sont du texte libre, et la note apparaîtra dans la section <b>Faits et détails personnels</b> de la page.";
$pgv_lang["edit_add_SHARED_NOTE_help"]		= "~#pgv_lang[add_shared_note]#~<br />~#pgv_lang[edit_shared_note]#~<br /><br />Les notes partagées, comme les notes ordinaires, sont du texte de forme libre. Contrairement aux notes ordinaires, chaque note partagée peut être liée à plus d'une personne, famille, source ou fait.<br /><br />En cliquant l'icône appropriée, vous pouvez établir un lien vers une note partagée existante ou créer une nouvelle note partagée et en même temps un lien vers elle. Si un lien vers une note partagée existante a déjà été établi, vous pouvez également modifier le contenu de cette note.<br /><ul><li><b>Lien vers une note partagée existante</b><div style=\"padding-left: 20px;\">Si vous connaissez déjà le numéro d'identification de la note partagée souhaitée, vous pouvez saisir ce numéro directement dans le champ.<br /><br />Lorsque vous cliquez <b>#pgv_lang[find_shared_note]#</b>, vous pourrez rechercher le texte de toutes les notes partagées existantes, puis en choisir une. Le numéro d'identification de la note choisie sera automatiquement entré dans le champ.<br /><br />Vous devez cliquer <b>#pgv_lang[add]#</b> pour mettre à jour l'enregistrement d'origine.</div><br /></li><li><b>Créer une nouvelle note partagée</b><div style=\"padding-left: 20px;\">Lorsque vous cliquez <b>#pgv_lang[create_shared_note]#</b>, une nouvelle fenêtre s'ouvre. Vous pouvez saisir le texte de la nouvelle note comme vous le souhaitez. Comme pour les notes ordinaires, vous pouvez saisir des URL.<br /><br />Lorsque vous cliquez <b>#pgv_lang[save]#</b>, vous verrez un message avec le numéro d'identification de la note partagée nouvellement créée. Vous devez cliquer sur ce message pour fermer la fenêtre d'édition et également copier ce nouveau numéro d'identification directement dans le champ Numéro d'identification. Si vous fermez simplement la fenêtre, le numéro d'identification nouvellement créé ne sera pas copié automatiquement.<br /><br />Vous devez cliquer <b>#pgv_lang[add]#</b> pour mettre à jour l'enregistrement d'origine.</div><br /></li><li><b>Modifier une note partagée existante</b><div style=\"padding-left: 20px;\">Lorsque vous cliquez <b>#pgv_lang[edit_shared_note]#</b>, une nouvelle fenêtre s'ouvre. Vous pouvez modifier le texte de la note partagée existante à votre guise. Comme pour les notes ordinaires, vous pouvez saisir des URL.<br /><br />Lorsque vous cliquez <b>#pgv_lang[save]#</b>, le texte de la note partagée est mis à jour. Vous pouvez fermer la fenêtre, puis cliquer à nouveau <b>#pgv_lang[save]#</b>.<br /><br />Lorsque vous modifiez le texte d'une note partagée, votre modification sera reflétée dans tous les emplacements auxquels cette note partagée est actuellement liée. Les nouveaux liens que vous établissez après avoir effectué votre modification utiliseront également le texte mis à jour.</div></li></ul>";
$pgv_lang["edit_add_GEDFact_ASSISTED_help"]	= "~UTILISATION DE L'Assistent GEDFACT~<br /><br />Cliquez \"+\" pour ouvrir la fenêtre de l'assistant GEDFact de la note partagée. Une aide spécifique y sera trouvée.<br /><br />Lorsque vous cliquez <b>#pgv_lang[save]#</b>, l'ID de la note partagée sera collée ici.";
$pgv_lang["edit_add_SOUR_help"] 		 = "~#pgv_lang[add_source]#~<br /><br />Cette section vous permet d'ajouter une source concernant l'événement que vous mettez à jour.<br /><br />Dans le champ «source», Saisissez le numéro de la source si celle-ci existe déjà. Cliquez <b>#pgv_lang[create_source]#</b> si vous désirez créer une nouvelle source. Dans le champ «Page», vous pouvez saisir les références (cote) ou toute autre information permettant de trouver la source. Dans le champ «Texte», vous pouvez saisir la transcription textuelle de la source.";
$pgv_lang["edit_add_ASSO_help"] 		 = "~#pgv_lang[add_asso]#~<br /><br />#pgv_lang[add_asso]# Vous permet d'associer à un événement une personne du site. C'est une des façons d'enregistrer, par exemple, que quelqu'un est le parrain d'une autre personne.";
$pgv_lang["edit_QUAY_help"] 			 = "~#factarray[QUAY]#~<br /><br />Vous aviez l'habitude d'utiliser ce champ pour enregistrer la qualité ou la fiabilité des données trouvées dans cette source. Beaucoup de logiciels de généalogie utilisent un nombre pour ce champ. <b>3</b> peut signifier que les données sont une source principale, <b>2</b> signifie qu'il s'agit d'une source secondaire, <b>1</b> signifie que l'information est incertaine, et <b>0</b> signifie que la source n'est pas fiable.";
$pgv_lang["edit_PAGE_help"]			= "~#factarray[PAGE]#~<br /><br />Dans le champ Détails de la citation, vous saisissez le numéro de page ou d'autres informations qui peuvent aider quelqu'un à trouver les informations dans la source.";
$pgv_lang["edit_TEXT_help"] 			 = "~#factarray[TEXT]#~<br /><br />Dans ce champ, vous pouvez saisir des citations concernant cette source. Ce peut être la transcription textuelle, ou la description de ce qui se trouve dans le document.";
$pgv_lang["edit_SOUR_help"]			= "~#factarray[SOUR]#~<br /><br />C'est le numéro d'identification de la source pour ce fait. Le titre de la source actuelle sera affiché sous le numéro d'identification.<br /><br />Vous pouvez changer le numéro d'identification de l'enregistrement source auquel se réfère la citation de la source de ce fait. Pour supprimer toute la citation, laissez ce champ vide. Cette action ne supprime pas l'enregistrement source de la base de données; seule cette référence est supprimée.<br /><br />Si vous entrez directement l'ID source souhaité, cet enregistrement source doit déjà exister dans la base de données. Vous pouvez cliquer <b>#pgv_lang[find_sourceid]#</b> pour rechercher le numéro d'identification d'un enregistrement source existant. Cliquez <b>#pgv_lang[create_source]#</b> si vous devez saisir un nouvel enregistrement source.";
$pgv_lang["edit_edit_raw_help"] 		 = "~#pgv_lang[edit_raw]#~<br /><br />Cette page vous permet de mettre à jour directement l'enregistrement du fichier GEDCOM. Utilisez cette possibilité avec précaution, car cela nécessite une bonne compréhension de la syntaxe GEDCOM 5.5.1. Pour plus d'information sur le standard GEDCOM 5.5.1, veuillez vous référer à l'aide <b>Fichier GEDCOM</b>.<br /><br />PhpGedView permet de mettre à jour votre fichier GEDCOM au travers des différentes transactions, mais vous pouvez avoir besoin d'intervenir directement sur celui-ci. Ne le faites que quand vous ne pensez pas possible de passer par les possibilités de transactions fournies par PhpGedView. À la mise à jour, la conformité de vos modifications est vérifiée par rapport aux standards de base de la norme GEDCOM, et le label CHAN est mis à jour.";
$pgv_lang["add_from_clipboard_help"]	= "~#pgv_lang[add_from_clipboard]#~<br /><br />PhpGedView vous permet de copier jusqu'à 10 faits, avec tous leurs détails, dans un presse-papiers. Ce presse-papiers est différent du panier de coupures que vous pouvez utiliser pour exporter des parties de votre base de données.<br /><br />Vous pouvez sélectionner l'un des faits dans le presse-papiers et copier le fait sélectionné dans l'enregistrement de l'individu, de la famille, de média, de source ou d'archiv en cours de modification. Cependant, vous ne pouvez pas copier des faits de types d'enregistrement différents. Par exemple, vous ne pouvez pas copier un fait de mariage dans une source ou un enregistrement individuel car le fait de mariage est associé uniquement aux enregistrements de famille.<br /><br />Ceci est très utile lorsque vous saisissez des faits similaires, tels que des faits de recensement, pour de nombreuses personnes ou familles.";
$pgv_lang["edit_PLAC_help"]				= "~#factarray[PLAC]#~<br /><br />Les lieux doivent être saisis selon les normes de généalogie. Dans la généalogie, les lieux sont enregistrés avec les informations les plus spécifiques sur le lieu en premier, puis en remontant jusqu'au lieu le moins spécifique en dernier, en utilisant des virgules pour séparer les différents niveaux de lieu. Le niveau auquel vous enregistrez les informations sur le lieu doit représenter les niveaux de gouvernement ou d'église où sont conservés les registres d'état civil de ce lieu.<br /><br />Par exemple, un lieu comme Salt Lake City serait saisi comme étant \"Salt Lake City, Salt Lake, Utah, USA\".<br /><br />Examinons chaque partie de cet endroit. La première partie, «Salt Lake City», est la ville ou le canton où l'événement s'est produit. Dans certains pays, il peut y avoir des municipalités ou des districts à l'intérieur d'une ville qu'il est important de noter. Dans ce cas, ils devraient venir avant la ville. La partie suivante, «Salt Lake», est le comté. «Utah» est l'état, et «USA» est le pays. Il est important de noter chaque lieu car les registres généalogiques sont conservés par les gouvernements de chaque niveau.<br /><br />Si un niveau du lieu est inconnu, vous devez laisser un espace entre les virgules. Supposons que, dans l'exemple ci-dessus, vous ne connaissiez pas le comté de Salt Lake City. Vous devriez alors l'enregistrer comme ceci: «Salt Lake City, , Utah, USA». Supposons que vous sachiez seulement qu'une personne est née dans l'Utah. Vous devez saisir les informations suivantes: «, , Utah, USA».<br /><br />Vous pouvez utiliser le lien <b>#pgv_lang[find_place]#</b> pour vous aider à trouver des lieux où existent déjà dans la base de données.";
$pgv_lang["edit_LATI_help"]				= "~#factarray[LATI]#~<br /><br />La saisie de coordonnées de latitude et de longitude spécifiques est généralement déconseillée car elle permet l'accès à la cartographie uniquement à partir de la vue de l'élément spécifique. Il vaut mieux gérer les lieux géographiques.<br /><br />Cependant, la saisie de la latitude et de la longitude permet un positionnement plus précis du marqueur.";
$pgv_lang["edit_LONG_help"]				= "~#factarray[LONG]#~<br /><br />La saisie de coordonnées de latitude et de longitude spécifiques est généralement déconseillée car elle permet l'accès à la cartographie uniquement à partir de la vue de l'élément spécifique. Il vaut mieux gérer les lieux géographiques.<br /><br />Cependant, la saisie de la latitude et de la longitude permet un positionnement plus précis du marqueur.";
$pgv_lang["edit_add_parent_help"]   	 = "~Ajout d'une mère ou d'un père~<br /><br />Avec cette page, vous pouvez ajouter une nouvelle personne comme père ou mère de la personne sélectionnée. Saisissez le nom, les informations de naissance et de décès. Si vous ne possédez pas une des informations, laissez le champ correspondant à blanc.<br /><br />Pour ajouter d'autres faits ou événements en sus de la naissance ou du décès, créer d'abord la personne en confirmant la mise à jour. Après, cliquez le nom de la personne apparaissant maintenant sur la page de la Famille ou dans l'onglet #pgv_lang[relatives]# pour voir la page des #pgv_lang[indi_info]# de la personne. À partir de cette page #pgv_lang[indi_info]#, vous pouvez ajouter des informations détaillées.";
$pgv_lang["edit_add_spouse_help"]		= "~Ajout d'un nouveau époux ou une nouvelle femme~<br /><br />Avec cette page, vous pouvez ajouter un nouveau époux ou femme à la personne sélectionnée. Remplissez le nom de la nouvelle personne et les informations de naissance et de décès si elles sont connues. Si vous ne connaissez pas certaines informations, laissez ce champ vide.<br /><br />Pour ajouter d'autres faits en plus de la naissance et du décès, ajoutez d'abord la nouvelle personne à la base de données en enregistrant les modifications. Cliquez ensuite le nom de la personne dans la page Famille mise à jour ou dans l'onglet #pgv_lang[relatives]# pour afficher la page #pgv_lang[indi_info]# de la personne. À partir de la page #pgv_lang[indi_info]#, vous pouvez ajouter des informations plus détaillées.";
$pgv_lang["edit_death_help"]			 = "~#pgv_lang[death]#~<br /><br />Vous pouvez saisir ici les informations de décès. Saisissez en premier la date du décès, au format généalogique (1&nbsp;JAN&nbsp;1908). Vous pouvez cliquer l'icône du calendrier afin de sélectionner une date. Saisissez ensuite le lieu. Vous pouvez utiliser le lien #pgv_lang[find_place]#</b> afin de sélectionner un lieu déjà existant dans la base de données.";
$pgv_lang["edit_birth_help"]			 = "~#pgv_lang[birth]#~<br /><br />Vous pouvez saisir ici les informations de naissance. Saisissez en premier la date de celle-ci, au format généalogique (1&nbsp;JAN&nbsp;1908). Vous pouvez cliquer l'icône du calendrier afin de sélectionner une date. Saisissez ensuite le lieu. Vous pouvez utiliser le lien #pgv_lang[find_place]#</b> afin de sélectionner un lieu déjà existant dans la base de données.";
$pgv_lang["edit_sex_help"]  			 = "~#pgv_lang[sex]#~<br /><br />Choisissez le sexe approprié dans la liste déroulante. Choisissez <b>inconnu</b> si vous n'avez pas l'information.";
$pgv_lang["edit_name_help"] 			 = "~#pgv_lang[name]#~<br /><br />C'est le champ le plus important dans l'enregistrement du nom d'un individu.<br /><br />Ce champ peut être rempli automatiquement en remplissant les champs particuliers qui suivent, (méthode préférable), il est fourni de façon à ce que vous puisssiez saisir ces information selon vos préférences personnelles.<br /><br />Ce champ doit être saisi selon les standards de la norme GEDCOM 5.5.1, avec le nom de famille entouré de «/». Par exemple, le nom «John Robert Finlay Jr.» doit être entré : «John Robert /Finlay/ Jr.».";
$pgv_lang["edit_surname_help"]			= "~#pgv_lang[surname]#~<br /><br />Dans ce champ, vous devez entrer le nom de famille de la personne. Par exemple, dans le nom «John Robert Finlay», le nom de famille qui doit être saisi ici est «Finlay»<br /><br />Les personnes ayant plusieurs noms de famille, communs en Espagne et au Portugal, doivent séparer les noms de famille avec une virgule. Cela indique que la personne doit être répertoriée sous chacun des noms. Par exemple, le nom de famille «Cortes, Vega» sera répertorié sous <b>C</b> et <b>V</b>, tandis que le nom de famille «Cortes Vega» sera uniquement répertorié sous <b>C</b>.";
$pgv_lang["edit_NICK_help"]				= "~#factarray[NICK]#~<br /><br />Dans ce champ, vous devez saisir les surnoms de la personne. Il s’agit d’un champ facultatif.<br /><br />Façons d’ajouter un surnom:<ul><li>Sélectionnez <b>modifier le nom</b> puis entrez le #factarray[NICK]# et enregistrez</li><li>Sélectionnez <b>ajouter un nouveau nom</b> puis entrez le #factarray[NICK]# ET le nom et enregistrez</li><li>Sélectionnez <b>modifier l’enregistrement GEDCOM</b> pour ajouter plusieurs enregistrements [2&nbsp;NICK] subordonnés à l’enregistrement principal [1&nbsp;NAME].</li></ul>";
$pgv_lang["edit_given_name_help"]   	 = "~#pgv_lang[given_name]#~<br /><br />Saisissez dans ce champ le ou les prénoms de la personne. Par exemple, si le nom de la personne est «Jean Pierre Dupont», saisissez «Jean Pierre».";
$pgv_lang["edit_NPFX_help"]			= "~#factarray[NPFX]#~<br /><br />Ce champ facultatif vous permet de saisir un préfixe de nom tel que <i>Dr.</i> ou <i>Adm.</i><br /><br />Les titres de noblesse tels que <i>Sir, Lord, Baron, Comte, Duc, Graf, Freiherr,</i> etc. sont entrés comme un fait «#factarray[TITL]#».";
$pgv_lang["edit_NSFX_help"]			= "~#factarray[NSFX]#~<br /><br />Ce champ facultatif vous permet de saisir un suffixe de nom tel que <i>Jr., Sr., III, IV,</i> etc. et des informations académiques telles que <i>PhD, PEng, FimechE, DVM, MD,</i> etc.";
$pgv_lang["edit_add_child_help"]		 = "~#pgv_lang[add_child]#~<br /><br />Avec cette page, vous pouvez ajouter une nouvelle personne comme enfant de la famille sélectionnée. Saisissez le nom, les informations de naissance et de décès. Si vous ne possédez pas une des informations, laissez le champ correspondant à blanc.<br /><br />Pour ajouter d'autres faits ou événements en sus de la naissance ou du décès, créer d'abord la personne en confirmant la mise à jour. Après, cliquez le nom de la personne apparaissant maintenant sur la page de la Famille ou dans l'onglet #pgv_lang[relatives]# pour voir la page des #pgv_lang[indi_info]# de la personne. À partir de la page #pgv_lang[indi_info]#, vous pouvez ajouter des informations détaillées.";

$pgv_lang["review_changes_help"]		 = "~#pgv_lang[review_changes_block]#~<br /><br />Ce bloc liste tous les enregistrements qui ont été mis à jour en ligne, et qui doivent être vérifiés et acceptés.";
$pgv_lang["quick_update_name_help"] 	 = "~#pgv_lang[update_name]#~<br /><br />Utilisez <b>Modif nom</b> pour mettre à jour le nom de la personne choisie. Vous avez un champ pour le nom propre et un champ pour les prénoms. Par exemple, si la personne s'appelle «Jean Pierre Dupont», saisissez «Jean Pierre» dans le champ <b>Prénom</b> et «Dupont» dans le champ <b>Nom de famille</b>.<br /><br />Remplir ces champs <u>modifiera</u> les noms de la personne, cela n'ajoutera pas de nouveau nom.<br /><br /><i>Note : vous ne devez <u>pas</u> utiliser cette méthode si la modification est due à un nouveau mariage. Dans ce cas, utilisez le champ <b>Ajouter un nouvel époux</b> ci-dessous.</i>";
$pgv_lang["quick_update_fact_help"] 	 = "~#pgv_lang[update_fact]#~<br /><br />Utilisez les champs <b>Modif événement</b> pour ajouter ou pour mettre à jour un événement concernant la personne choisie. Choisissez un événement dans la liste, puis saisissez la date à laquelle cet événement est survenu, en respectant le standard généalogique du format des dates (1&nbsp;JAN&nbsp;1908). Vous pouvez cliquer l'icône du calendrier pour selectionner une date dans celui-ci. saisissez ensuite le lieu de cet événement. Vous pouvez utiliser le lien <b>#pgv_lang[find_place]#</b> pour sélectionner un lieu déjà existant dans la base de données.<br /><br />Comme l'ensemble des champs de cette page, votre information remplacera l'information existante si elle existe, ou créera une nouvelle entrée.";
$pgv_lang["quick_update_address_help"]  = "~#pgv_lang[update_address]#~<br /><br />Utilisez <b>#pgv_lang[update_address]#</b> pour modifier celle-ci, ou le numéro de téléphone, de fax ou le mail de la personne choisie.<br /><br />Comme pour l'ensemble des champs de cette page, votre information remplacera celle existante si elle existe ou créera une nouvelle entrée.";
$pgv_lang["quick_update_spouse_help"]	= "~Ajout d'un nouveau époux ou une nouvelle femme~<br /><br />Utilisez ces champs lorsque vous souhaitez ajouter un nouveau époux ou une nouvelle femme à la personne que vous modifiez. Entrez le nom et les informations de naissance du nouveau conjoint dans les champs, puis entrez la date de leur mariage sous les informations de mariage. Entrez les dates dans le format de date standard pour la généalogie (1 JAN 2004). Vous pouvez cliquer l'icône Calendrier pour vous aider à sélectionner une date. Vous pouvez utiliser le lien <b>#pgv_lang[find_place]#</b> pour sélectionner un lieu qui existe déjà dans la base de données.<br /><br />Ces champs ajouteront uniquement un <i>nouveau</i> partenaire ; ils ne mettront pas à jour les informations d'un ancien. Pour modifier les informations d'une personne déjà enregistrée, fermez cette fenêtre et cliquez le nom de cette personne dans l'onglet #pgv_lang[relatives]#. Cliquez ensuite le menu Modifier l'individu pour modifier les informations.";
$pgv_lang["quick_update_marriage_help"] = "~Modification mariage~<br /><br />Vous pouvez employer ces champs conjointement avec les champs pour ajouter un nouveau conjoint si vous voulez enregistrer un nouveau mariage. Autrement, les données entrées dans ces champs modifieront les informations sur le dernier mariage de la personne. saisissez les dates dans le format généalogique (1&nbsp;JAN&nbsp;1908). Vous pouvez cliquer l'icône du calendrier afin de selectionner une date dans celui-ci. Vous pouver cliquer <b>#pgv_lang[find_place]#</b> afin de sélectionner un lieu déjà existant dans la base de données.";
$pgv_lang["quick_update_child_help"]	 = "~#pgv_lang[add_new_chil]#~<br /><br />Utilisez ces champs afin d'ajouter un nouvel enfant à la personne choisie. saisissez son ou ses prénoms et son sexe. saisissez ensuite le lieu et la date de naissance. saisissez les dates au format généalogique (1&nbsp;JAN&nbsp;1908). Vous pouvez cliquer l'icône du calendrier afin de choisir une date dans celui-ci. Vous pouvez utiliser le lien <b>#pgv_lang[find_place]#</b> pour sélectionner un lieu déjà existant dans le base de données.<br /><br /> Ces champs servent seulement à <u>ajouter</u> un nouvel enfant. Ils ne peuvent mettre à jour un enfant déjà existant. Pour mettre à jour une personne déjà existante dans la base de données, fermez cette fenêtre, cliquez son nom dans l'onglet <b>#pgv_lang[relatives]#</b>. Il s'agira alors de la personne sélectionnée, et vous aurez accès à toutes les modifications la concernant.";
$pgv_lang["index_top10_pageviews_help"] = "~#pgv_lang[top10_pageviews]#~<br /><br />Ce bloc liste les individus, familles ou sources ayant étés le plus vus par les visiteurs. Pour que ce bloc fonctionne, l'administrateur doit avoir activé le compteur de visites.";
$pgv_lang["index_cookiepolicy_help"]	= "~#pgv_lang[block_cookiepolicy]#~<br /><br />Ce bloc affiche la politique de ce site concernant les cookies.";
$pgv_lang["cookiepolicy_link_help"]		= "~#pgv_lang[block_cookiepolicy_link]#~<br /><br />Laissez ce champ vide si vous voulez utiliser le texte standard.<br /><br />Si vous voulez utiliser le texte standard et aussi fournir un lien vers un fichier texte ou une page HTML ou autre qui contient des détails sur la politique de ce site concernant les cookies, vous devez saisir l'URL de cette page dans ce champ.<br /><br />Par exemple, l'entrée <b>http://foo.bar.com/policy/cookies.txt</b> peut vous mener à un fichier en texte simple, <b>http://foo.bar.com/policy/cookies.htm</b> peut décrire un lien à une page formatée en HTML, et <b>http://foo.bar.com/policy/cookies.doc</b> peut vous montrer un document codé en Microsoft Word.";
$pgv_lang["cookiepolicy_link_advice"]	= "Videz ce champ pour utiliser le texte standard.<br /><br />Codez un URL comme <b>http://foo.bar.com/policy/cookies.txt</b> pour lier à une page ou un document qui contient plus de détails sur les politiques de ce site concernant les cookies.";
$pgv_lang["useradmin_user_default_tab_help"]= "~#pgv_lang[user_default_tab]#~<br /><br />Cette option vous permet de spécifier quel est l'onglet ouvert automatiquement lorsque l'utilisateur accède à la page #pgv_lang[indi_info]#. Si il a l'autorisation d'éditer son compte, l'utilisateur peut modifier cette option par la suite.";
$pgv_lang["edituser_user_default_tab_help"]= "~#pgv_lang[user_default_tab]#~<br /><br />Cette option vous permet de spécifier quel est l'onglet ouvert automatiquement lorsque vous ouvrez la page #pgv_lang[indi_info]#.";
$pgv_lang["reorder_children_help"]  	 = "~#pgv_lang[reorder_children]#~<br /><br />Les enfants apparaissent dans la séquence dans lequel ils figurent dans l'enregistrement de la famille. Les enfants ne sont pas triés sur la date de naissance, car souvent celles-ci sont inconnues, alors que <u>la séquence</u> des naissances l'est.<br /><br />Cette option vous permet de changer cette séquence. Si vous voulez trier les enfants sur la date de leur naissance, cliquez le bouton indiqué à ce fin. Vous pouvez aussi faire glisser toute case d'information et la déposer dans la séquence voulu. Lorsque vous déplacez le curseur de la souris sur une zone d'informations, sa forme se transforme en une paire de flèches croisées à deux têtes. Si vous maintenez le bouton gauche de la souris enfoncé avant de déplacer le curseur de la souris, la boîte d'informations suivra le curseur de la souris vers le haut ou vers le bas dans la liste. Au fur et à mesure que la boîte d'information est déplacée, les autres boîtes feront de la place. Lorsque vous relâchez le bouton gauche de la souris, la boîte d'informations prend sa nouvelle place dans la liste.";
$pgv_lang["rss_feed_help"]  			 = "~#pgv_lang[rss_feeds]#~<br /><br />Le flux ATOM/RSS disponible dans PhpGedView permet à n'importe qui de visualiser, en utilisant un agrégateur d'informations approprié, le contenu de votre page d'accueil de votre site sans le visiter. La plupart des agrégateurs notifient les utilisateurs d'une modification de l'information sur votre page d'accueil ou sur une quelconque page surveillée via ATOM/RSS. Ceci permet essentiellement à n'importe qui de suivre votre site PhpGedView sans avoir besoin de le visiter régulièrement.<br /><br />Le bloc de flux est configuré pour adapter le lien aux flux d'information, permettant des flux RSS de type spéficique (la plupart des lecteurs RSS peuvent traiter la plupart des types de flux, aussi le réglage de celui-ci peut habituellement être laissé par défaut), ainsi que le module spécifique que vous souhaiteriez utiliser pour vos flux RSS. Le language du flux d'information et du GEDCOM utilisés seront basés sur sur le language et le GEDCOM actifs dans PhpGedView quand vous sélectionnez le flux.<br /><br />Les types de flux qui peuvent être produits incluent ATOM, RSS 2.0, RSS 1.0, RSS 0.92, HTML et JavaScript. Les quatre premiers types sont destinés à des agrégateurs d'information, alors que le Javascript et le HTML sont censés permettre l'intégration de l'information dans d'autres pages web. Notez que les numéros de version de flux RSS indiquent différents modes de flux et non une version différente.<br /><br />Il y a une option pour choisir le mode d'authentification qui permettra la connexion de l'utilisateur, et permettra à l'utilisateur d'afficher, en utilisant un agrégateur de flux RSS approprié, n'importe quelle information qu'il pourrait visualiser normalement en visitant votre site. L'authentification de base utilise <i>l'authentification HTTP de base</i> pour connecter l'utilisateur. De futures améliorations pourraient permettre  <i>une authentification avec la méthode «digest»</i>.<br /><br />Cet <a href='https://fr.wikipedia.org/wiki/RSS_(file_format)' target='_blank' alt='article de Wikipedia' title='article de Wikipedia'><b>article de Wikipedia</b></a> contient des informations et des liens complets sur RSS et les différents formats de RSS. <i>L'authentification HTTP de base</i> est débattue dans cet <a href='http://en.wikipedia.org/wiki/Basic_authentication_scheme' target='_blank' alt='Wikipedia article' title='Wikipedia article'><b>article de Wikipedia</b></a>, tandis que <i>la méthode d'authentification «Digest»</i> est discutée dans cet article <a href='https://en.wikipedia.org/wiki/Digest_access_authentication' target='_blank' alt='Wikipedia article' title='Wikipedia article'><b>de Wikipedia</b></a>.";
		
$pgv_lang["upload_media_help"]  		 = "~#pgv_lang[upload_media]#~<br /><br />Choisir un fichier sur votre poste. Il sera copié sur le serveur dans le dossier <b>#MEDIA_DIRECTORY#</b> ou un de ses sous-dossiers.<br /><br />Le nom du dossier sera ajouté à <b>#MEDIA_DIRECTORY#</b>. Par exemple, <b>#MEDIA_DIRECTORY#famille</b>. Si le dossier de vignettes n'existe pas, il sera créé automatiquement.";
$pgv_lang["upload_media_folder_help"]   = "~#pgv_lang[folder]#~<br /><br />Votre configuration GEDCOM permet jusqu'à #GLOBALS[MEDIA_DIRECTORY_LEVELS]# niveaux de répertoire au delà du répertoire par défaut <b>#GLOBALS[MEDIA_DIRECTORY]#</b> là où les fichiers média téléchargés sont normalement stockés. Ceci vous permet organiser vos fichiers média, et ainsi vous n'avez pas à vous soucier de maintenir des noms uniques pour chacun des médias stocké.<br /><br />Dans ce champ, vous indiquez le répertoire de destination sur votre serveur où le fichier média doit être téléchargé et stocké.  Soyez attentif à l'utilisation des minuscules ou majuscules quand vous sélectionnez ou saisissez des noms de fichiers ou de dossiers, puisque ces noms sont sensibles aux majuscules/minuscules.<br /><br />Si le nom du répertoire que vous saisissez ici n'existe pas, il sera créé automatiquement. Si vous saisissez plus de sous-dossiers que les #GLOBALS[MEDIA_DIRECTORY_LEVELS]# niveaux de répertoire autorisés par votre configuration GEDCOM, les informations entrées seront tronquées en conséquence.<br /><br />Les vignettes seront téléchargées ou créées dans une structure indentique, commençant par <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.";
$pgv_lang["upload_media_file_help"] 	 = "~#pgv_lang[media_file]#~<br /><br />Dans ce champ vous spécifiez l'emplacement et le nom, sur votre ordinateur local, du fichier média que vous souhaitez télécharger sur le serveur. Vous pouvez utiliser le bouton <b>Parcourir</b> pour rechercher sur votre ordinateur le fichier souhaité.<br /><br />Le fichier téléchargé conservera le même nom sur le serveur et il sera téléchargé vers le répertoire spécifié dans le champ <b>#pgv_lang[folder]#</b>.<br /><br />Si vous ne voyez pas ce champ ou ne pouvez pas le changer, la configuration de votre fichier GEDCOM a été paramétrée pour vous interdire l'ajout de sous-répertoires au-delà du niveau de répertoire par défaut <b>#GLOBALS[MEDIA_DIRECTORY]#</b> où sont normalement stockés les fichiers média.";
$pgv_lang["upload_thumbnail_file_help"] = "~#pgv_lang[thumbnail]#~<br /><br />Dans ce champ vous spécifiez l'emplacement et le nom, sur votre ordinateur local, de la vignette que vous souhaitez télécharger sur le serveur. Vous pouvez utiliser le boutton <b>Parcourir</b> pour rechercher sur votre ordinateur le fichier souhaité.  Quand ce champ est complété, la case à cocher <b>#pgv_lang[auto_thumbnail]#</b> est ignorée.<br /><br />Si le champ <b>#pgv_lang[media_file]#</b> a été complété, le fichier correspondant à votre vignette sera mis à jour et renommé selon le contenu de ce champ, indépendamment du nom indiqué sur votre ordinateur local.  Si ce champ est vide, la vignette téléchargée sera copiée à deux endroits sur le serveur : dans le répertoire indiqué dans le champ <b>#pgv_lang[folder]#</b>, et ensuite dans une structure de dossier identique commençant par <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />Si vous ne voyez pas le champ <b>#pgv_lang[folder]#</b> ou si vous ne pouvez pas le modifier, la configuration de votre fichier GEDCOM a été paramétrée pour vous interdire l'ajout de sous-répertoires au-delà du niveau de répertoire par défaut <b>#GLOBALS[MEDIA_DIRECTORY]#</b> où sont normalement stockés les fichiers média.";


//-- GENERAL
$pgv_lang["help_header"]				 = "Aide sur : ";
$pgv_lang["privacy_error_help"]			= "~Détails privés~<br /><br />Il y a plusieurs raisons possibles à ce message :<br /><ul><li><b>Les informations sur les personnes vivantes sont définies sur «Privée»</b><br />Les visiteurs et les utilisateurs enregistrés qui ne sont pas connectés peuvent voir les informations complètes seulement pour les personnes décédées. Si l’administrateur l’autorise, les visiteurs peuvent créer un compte en cliquant le bouton Connexion, puis le lien #pgv_lang[requestaccount]#.<br /></li><li><b>Vous êtes un utilisateur avec un nom d'utilisateur et un mot de passe...</b><br />Mais vous ne vous êtes pas connecté avec succès ou vous avez été inactif pendant un certain temps et votre session a expiré.<br /></li><li><b>En raison de la confidentialité</b><br />La personne ne veut pas du tout être affichée (masquée) et peut avoir demandé à l'administrateur de la définir sur «Privée». La confidentialité peut être définie sur :<br /><ul><li>#pgv_lang[PRIV_USER]#</li><li>#pgv_lang[PRIV_NONE]#</li><li>#pgv_lang[PRIV_HIDE]#</li></ul></li><li><b>Hors «Chemin de relation»</b><br />Même si vous êtes un utilisateur régulier <u>et</u> êtes connecté, il peut arriver que vous voyiez ce message si la personne que vous essayez de consulter n’est pas liée à vous dans le nombre d’étapes de relation (Longueur du chemin de relation) défini par l'administrateur pour ce GEDCOM.<br /><br />Exemples :<br />Lorsque la longueur du chemin de relation est définie sur <b>1</b>, vous ne pouvez voir que les détails de votre propre famille, père, mère, frère, sœur (mais pas les conjoints et les enfants de votre frère ou sœur)<br /><br />Lorsque le chemin de relation est défini sur <b>2</b>, vous pouvez également voir les détails de la femme de votre frère et de leurs enfants (mais pas les conjoints de leurs enfants).<br /><br />Plus le paramètre de longueur du chemin de relation est élevé, plus vous pouvez voir de parents distants.<br /></li></ul><br />Si vous pensez que vous êtes admissible à voir certains détails cachés, veuillez contacter l'administrateur. Utilisez le lien de contact sur n'importe quelle page.";
$pgv_lang["more_help"]					 = "Pour une aide plus détaillée, vérifier l'option <b>#pgv_lang[show_context_help]#</b> dans le menu <b>#pgv_lang[page_help]#</b>, et suivre les liens <b>#pgv_lang[qm]#</b> de la page.";
$pgv_lang["start_admin_help"]			 = "+++ Début du complément d'informations de l'administrateur +++";
$pgv_lang["end_admin_help"]				 = "--- Fin du complément d'informations de l'administrateur ---";
$pgv_lang["multiple_help"]				 = "<span class='center'>--- Aide commune à plusieurs pages ---</span>";
$pgv_lang["header_general_help"]		 = "<div class='name_head center'><b>INFORMATIONS GÉNÉRALES</b></div>";
$pgv_lang["best_display_help"]			 = "~#pgv_lang[resolution]#~<br /><br />PhpGedView est prévu pour une taille d'écran de 1024x768 pixels. C'est la valeur minimum pour que tout s'affiche correctement.<br /><br />Avec une résolution inférieure, par exemple 800x600, vous devrez souvent utiliser les ascenceurs (scrolling).";
$pgv_lang["preview_help"]				 = "~#pgv_lang[print_preview]#~<br /><br />Cliquer sur <b>#pgv_lang[print_preview]#</b> supprimera les éléments qui ne semblent pas bons sur une page imprimée (menus, zones de saisie, liens supplémentaires, les points d'interrogation pour l'aide contextuelle, etc.)<br /><br />Vous obtiendrez un bouton <b>#pgv_lang[print]#</b> en bas de la page simplifiée ; lorsque vous cliquez sur ce bouton, la boîte de dialogue d'impression de votre système apparaît. Après l'impression, cliquez sur <b>#pgv_lang[cancel_preview]#</b> et l'écran sera reconstruit normalement.<br /><br />Remarque&nbsp;: Bien que cette option supprime de nombreux liens de la page affichée, les liens restants sont toujours actifs.";
$pgv_lang["readme_help"]				 = "<span class='center'>Voir le fichier <a href=\"readme.txt\" target=\"_blank\"><b>Readme.txt</b></a> pour davantage d'informations.</span>";
$pgv_lang["is_user_help"]				 = "--- Texte identique à l'aide visiteur. ---<br />--- Pour économiser d'espace, il n'y a pas de texte spécial administrateur ici. ---";
$pgv_lang["edit_raw_gedcom_help"]		 = "~#pgv_lang[edit_raw]#~<br /><br />En cliquant ce lien, une nouvelle fenêtre s'ouvre permettant la modification de l'enregistrement GEDCOM.<br /><br />Respectez impérativement la syntaxe GEDCOM 5.5.1 car aucun contrôle n'est réalisé. Les modifications effectuées seront soumises à l'approbation de l'administrateur.";
$pgv_lang["RESN_help_title"]			 = "Restrictions d'accès sur un enregistrement";
$pgv_lang["RESN_help"]					 = "~#pgv_lang[RESN_help_title]#t~<br /><br />En plus des règles globales de restrictions d'accès, PhpGedView offre la possibilité d'ajouter des restrictions d'accès en lecture et/ou écriture à certains enregistrements concernant une Famille ou un Individu.<br /><br />Valeurs possibles pour ce champ :<br /><ul><li><b>#pgv_lang[none]#</b><br />Les administrateurs du site ou du fichier GEDCOM, ainsi que les utilisateurs avec privilèges, peuvent modifier l'information. Pour les autres, la lecture est autorisée conformément aux règles de restrictions globales.</li><li><b>#pgv_lang[locked]#</b><br />Ce paramètre n'a aucune influence sur la visibilité des données de fait. Il restreint les droits d'édition aux administrateurs du site et aux administrateurs GEDCOM. Si les informations s'appliquent à l'utilisateur lui-même, il peut également les consulter et, en supposant qu'il dispose des droits d'édition, les modifier.</li><li><b>#pgv_lang[privacy]#</b><br />Les administrateurs du site et les administrateurs GEDCOM peuvent afficher et modifier les informations. Si les informations s'appliquent à l'utilisateur lui-même, il peut également les consulter et, en supposant qu'il dispose des droits d'édition, les modifier. Ils sont cachées à tous les autres utilisateurs quel que soit leur statut de connexion.</li><li><b>#pgv_lang[confidential]#</b><br />Seuls les administrateurs du site et les administrateurs GEDCOM peuvent afficher et modifier les informations. Ils sont cachées à tous les autres utilisateurs quel que soit leur statut de connexion.</li></ul><br /><table><tr><th></th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Admin</th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Prop</th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Autres</th></tr><tr><th></th><th></th><th>L</th><th>M</th><th></th><th>L</th><th>M</th><th></th><th>L</th><th>M</th></tr><tr><td><img src=\"images/RESN_none.gif\" alt=\"\" />&nbsp;#pgv_lang[none]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_locked.gif\" alt=\"\" />&nbsp;#pgv_lang[locked]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /><th></th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_privacy.gif\" alt=\"\" />&nbsp;#pgv_lang[privacy]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_confidential.gif\" alt=\"\" />&nbsp;#pgv_lang[confidential]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr></table><ul><li>L : droit de lire</li><li>M : droit de modifier</li><li><img src=\"images/checked_qm.gif\"/> : droits selon les règles de restrictions globales</li></ul>";
		
		
//-- Pages Help-messages
//-- Index-page
$pgv_lang["index_help"] 				 = "~#pgv_lang[welcome_page]#~<br /><br />Bienvenue à la page d'accueil du fichier <a href=\"#def_gedcom\">GEDCOM</a> sélectionné. À tout moment vous pouvez revenir sur cette page par le bouton <b>#pgv_lang[welcome_page]#</b> du menu principal. Si plusieurs fichiers GEDCOM sont disponibles, faîtes votre choix dans le menu Ici vous trouverez de l'aide sur :<ul><li><a href=\"#index_portal\"><b>#pgv_lang[welcome_page]#</b></a></li><li><a href=\"#header\"><b>#pgv_lang[header]#</b></a></li><li><a href=\"#menu\"><b>Menus</b></a></li><li><a href=\"#header_general\"><b>Informations générales</b></a></li><li><a href=\"#def\"><b>Définitions</b></a></li></ul>";
		
//-- Index-page Header
$pgv_lang["header_help"]				= "<div class='name_head center'><b>#pgv_lang[header]#</b></div><br />En haut de chaque page s'affichent des boutons et liens utilisables à tout moment.<br /><br />La présentation du site étant personnalisable, le bandeau est variable selon le <a href=\"#def_theme\">thème</a> choisi.<br /><br />Voici la liste des liens que vous pourrez y trouver :<ul><li><a href=\"#header_search\"><b>#pgv_lang[search]#</b></a></li><li><a href=\"#header_lang_select\"><b>#pgv_lang[change_lang]#</b></a></li><li><a href=\"#header_user_links\"><b>#pgv_lang[login]#</b></a></li><li><a href=\"#header_favorites\"><b>#pgv_lang[my_favorites]#</b></a></li><li><a href=\"#header_theme\"><b>#pgv_lang[change_theme]#</b></a></li></ul>";
$pgv_lang["header_search_help"]			= "~#pgv_lang[header]# «#pgv_lang[search]#»~<br /><br />Ce champ de recherche est petit mais puissant. Vous pouvez demander à PhpGedView de rechercher presque tout pour vous. Lorsque vous cliquez <b>&gt;</b> ou <b>Rechercher</b>, vous serez lié à la page de recherche pour voir les résultats de votre recherche. Vous trouverez une aide complète sur les options de recherche sur la page de recherche.";
$pgv_lang["header_lang_select_help"]	= "~#pgv_lang[header]# «#pgv_lang[change_lang]#»~<br /><br />L'une des fonctionnalités les plus importantes de PhpGedView est que plusieurs langues sont prises en charge.<br /><br />La langue dans laquelle PhpGedView affiche toutes les pages est déterminée automatiquement en fonction du paramètre Langue préférée du navigateur. Cependant, l'administrateur du site peut avoir limité la disponibilité de certaines langues.<br /><br />Selon la configuration du site, vous pourrez peut-être changer la langue de PhpGedView en sélectionnant une langue plus appropriée dans une liste ou en cliquant une icône de drapeau. Si vous êtes un utilisateur enregistré, vous pouvez configurer PhpGedView pour qu'il passe à votre langue préférée après vous êtes connecté, quel que soit le paramétrage de votre navigateur.";
$pgv_lang["header_user_links_help"] 	 = "~#pgv_lang[header]# «#pgv_lang[login]#»~<br /><br />Cette liste de liens reste présente au même endroit sur toutes les pages (sauf si vous changez le thème).<br />Non connecté, vous voyez uniquement le lien <b>#pgv_lang[login]#</b>.<ul><li><b>Connecté</b>, vous voyez <b>#pgv_lang[logged_in_as]#</b> (votre nom d'utilisateur). Ce lien vous donne l'accès à votre compte.</li><li>Cliquer <b>#pgv_lang[logout]#</b> pour vous déconnecter.</li><li>Si vous avez les droits d'administrateur, le lien <b>#pgv_lang[admin]#</b> s'affiche. Cliquer ce lien pour accéder directement à la page principale d'administration.</li></ul>";
$pgv_lang["header_favorites_help"]  	 = "~#pgv_lang[header]# «#pgv_lang[gedcom_favorites]#»~<br /><br />Cette liste affiche les liens favoris que vous avez sélectionnés. S'y ajoutent les favoris enregistrés pour ce fichier GEDCOM par l'administrateur. Ces liens vous offrent l'accès direct à la page #pgv_lang[indi_info]# de l'individu choisi.<br /><br />Pour savoir comment ajouter un favori, consulter l'aide sur la page <b>#pgv_lang[my_favorites]#</b>.";
$pgv_lang["header_theme_help"]  		 = "~#pgv_lang[header]# «#pgv_lang[change_theme]#»~<br /><br />Si l'administrateur l'autorise, vous pouvez choisir votre thème dans une liste, et modifier ainsi l'affichage du site. Si vous êtes connecté, ce thème sera mémorisé et deviendra votre thème par défaut.";

//-- Index-page Menu
$pgv_lang["menu_help"]					= "<div class='name_head center'><b>MENUS</b></div><br />Les en-têtes de page ont des menus associés à chaque icône de menu.<br /><br />Lorsque vous déplacez le pointeur de votre souris sur une icône, un sous-menu apparaît, s'il en existe un. Lorsque vous cliquez une icône, vous serez redirigé vers le premier élément du sous-menu.<br /><br />Les icônes de menu suivantes sont généralement disponibles :<ul><li><a href=\"#menu_fam\"><b>#pgv_lang[welcome_page]#</b></a></li><li><a href=\"#menu_myged\"><b>#pgv_lang[mygedview]#</b></a></li><li><a href=\"#menu_charts\"><b>#pgv_lang[charts]#</b></a></li><li><a href=\"#menu_lists\"><b>#pgv_lang[lists]#</b></a></li><li><a href=\"#menu_annical\"><b>#pgv_lang[anniversary_calendar]#</b></a></li><li><a href=\"#menu_clip\"><b>#pgv_lang[clippings_cart]#</b></a></li><li><a href=\"#menu_search\"><b>#pgv_lang[search]#</b></a></li><li><a href=\"#menu_help\"><b>#pgv_lang[page_help]#</b></a></li></ul>";
$pgv_lang["menu_famtree_help"]  		 = "~#pgv_lang[welcome_page]#~<br /><br />Tous les fichiers GEDCOM disponibles sur le site sont présentés ici. Chacun ayant sa propre présentation. Quand le site ne présente qu'un seul fichier GEDCOM, ce sous-menu est vide.";
$pgv_lang["menu_myged_help"]			= "~#pgv_lang[mygedview]#~<br /><br />Si vous êtes connecté, ce menu peut présenter les choix suivants :<ul><li><a href=\"?help=index_myged_help\"><b>#pgv_lang[mygedview]#</b></a><br />Vous renvoie sur votre propre #pgv_lang[welcome_page]#.</li><li><a href=\"?help=help_edituser.php\"><b>#pgv_lang[editowndata]#</b></a><br />Pour modifier vos paramètres personnels.</li><li><a href=\"?help=help_pedigree.php\"><b>#pgv_lang[my_pedigree]#</b></a><br />Si vous avez choisi un #pgv_lang[root_person]# pour ce fichier GEDCOM, son #pgv_lang[index_header]# s'affichera</li><li><a href=\"?help=help_individual.php\"><b>#pgv_lang[my_indi]#</b></a><br />Lien vers votre page #pgv_lang[indi_info]#, où se trouvent les données de votre propre famille.</li></ul>";
$pgv_lang["menu_charts_help"]			= "~#pgv_lang[charts]#~<br /><br />Liste des diagrammes disponibles :<ul><li><a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a><br />Cela vous reliera au tableau d'ascendance de ce fichier GEDCOM. Le pedigree commencera par la personne configurée par l'administrateur. Lorsque vous êtes connecté, la personne de départ peut être celle que vous avez configurée dans les préférences de votre compte.</li><li><a href=\"?help=help_descendancy.php\"><b>#pgv_lang[descend_chart]#</b></a><br />Le graphique de descendance est essentiellement un <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a> dans le sens inverse. Cette comparaison n'est pas tout à fait correcte, mais alors que le tableau d'ascendance vous montre tous les ancêtres d'une personne de départ, le tableau de descendance vous montre tous les descendants d'une personne de départ.</li><li><a href=\"?help=help_timeline.php\"><b>#pgv_lang[timeline_chart]#</b></a><br />Ici, vous visualisez les événements d'une personne le long d'une ligne de temps. Il est intéressant de comparer les événements de deux personnes ou plus sur la même ligne de temps.</li><li><a href=\"?help=help_relationship.php\"><b>#pgv_lang[relationship_chart]#</b></a><br />Ici, vous pouvez vérifier la relation d'une personne avec vous-même ou avec une autre personne.</li><li><a href=\"?help=help_ancestry.php\"><b>#pgv_lang[ancestry_chart]#</b></a><br />Ce graphique est très similaire au <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>, mais avec plus de détails et des affichages <a href=\"?help=chart_style_help\"><b>#pgv_lang[chart_style]#</b></a> alternatifs.</li><li><a href=\"?help=help_fanchart.php\"><b>#pgv_lang[fan_chart]#</b></a><br />Ce graphique est très similaire au <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>, mais d'une manière plus graphique.</li></ul>";
$pgv_lang["menu_lists_help"]			= "~#pgv_lang[lists]#~<br /><br />Les choix suivants sont présentés dans ce menu :<ul><li><a href=\"?help=help_indilist.php\"><b>#pgv_lang[individual_list]#</b></a></li><li><a href=\"?help=help_famlist.php\"><b>#pgv_lang[family_list]#</b></a><br />Dans ces deux listes, vous pouvez parcourir les listes alphabétiques d'individus ou de familles dans ce GEDCOM.</li><li><a href=\"?help=help_sourcelist.php\"><b>#pgv_lang[source_list]#</b></a><br />Liste des sources d'informations citées dans ce fichier GEDCOM.</li><li><a href=\"?help=help_placelist.php\"><b>#pgv_lang[place_list]#</b></a><br />Liste par lieux.</li><li><a href=\"?help=help_medialist.php\"><b>#pgv_lang[media_list]#</b></a><br />Vous ne voyez cet élément de menu que s'il est activé par l'administrateur du site. Cela affichera des liens vers tous les fichiers multimédias de ce GEDCOM.</li></ul>";
$pgv_lang["menu_annical_help"]  		 = "~#pgv_lang[anniversary_calendar]#~<br /><br />Affiche les événements ayant eu lieu à une certaine date.<ul><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewday]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewmonth]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewyear]#</b></a><br />Ces éléments de menu vous amèneront au #pgv_lang[anniversary_calendar]# pour afficher une liste de tous les événements pour le jour, le mois ou l'année en cours.</li></ul>";
$pgv_lang["menu_clip_help"]				= "~#pgv_lang[clippings_cart]#~<br /><br />Vous ne verrez cet élément dans la barre de menus que lorsque l'administrateur a activé cette fonctionnalité.<br /><br />Le #pgv_lang[clip_cart]# vous permet de stocker des informations sur les individus, les familles et les sources dans un fichier temporaire qui vous pouvez télécharger plus tard au format GEDCOM 5.5.1.";
$pgv_lang["menu_search_help"]   		 = "~#pgv_lang[search]#~<br /><br />Accès à une page de recherche très puissante.";
$pgv_lang["menu_help_help"] 			 = "~#pgv_lang[page_help]#~<br /><br />#pgv_lang[help_help_items]#";
		
//-- Index-page Portal
$pgv_lang["index_portal_head_help"]		= "<div class='name_head center'><b>#pgv_lang[welcome_page]#</b></div>";
$pgv_lang["index_portal_help"]  		 = "La #pgv_lang[welcome_page]# présente plusieurs blocs séparés, et elle est personnalisable. Ainsi, chaque fichier GEDCOM de ce site peut avoir sa propre #pgv_lang[welcome_page]#. Voici la liste des blocs disponibles :<ul><li><a href=\"#index_welcome\"><b>#pgv_lang[welcome_block]#</b></a></li><li><a href=\"#index_login\"><b>#pgv_lang[login_block]#</b></a></li><li><a href=\"#index_events\"><b>#pgv_lang[upcoming_events_block]#</b></a></li><li><a href=\"#index_onthisday\"><b>#pgv_lang[todays_events_block]#</b></a></li><li><a href=\"#index_charts\"><b>#pgv_lang[charts_block]#</b></a></li><li><a href=\"#index_favorites\"><b>#pgv_lang[gedcom_favorites_block]#</b></a></li><li><a href=\"#index_stats\"><b>#pgv_lang[gedcom_stats_block]#</b></a></li><li><a href=\"#index_common_surnames\"><b>#pgv_lang[block_top10]#</b></a></li><li><a href=\"#index_media\"><b>#pgv_lang[random_media_block]#</b></a></li><li><a href=\"#index_loggedin\"><b>#pgv_lang[logged_in_users_block]#</b></a></li><li><a href=\"#gedcom_news\"><b>#pgv_lang[gedcom_news_block]#</b></a></li><li><a href=\"#recent_changes\"><b>#pgv_lang[recent_changes_block]#</b></a></li></ul>";
$pgv_lang["index_welcome_help"] 		 = "~#pgv_lang[welcome_block]#~<br /><br />Ce bloc affiche le fichier GEDCOM actif, la date, l'heure et, suivant la configuration, le compteur de visites.<br /><br />Le compteur ne fonctionne que sur le #pgv_lang[welcome_block]# et la page #pgv_lang[indi_info]#. Il enregistre le nombre d'accès («hits») à ces pages. Le compteur ne vérifiée pas la provenance des visites, donc chaque visite d'une page depuis <u>n'importe quel</u> emplacement compte comme un autre hit.";
$pgv_lang["index_login_help"]			= "~#pgv_lang[login_block]#~<br /><br />Vous pouvez vous connecter sur presque toutes les pages de ce programme. Vous le ferez généralement sur la première page, car vous ne pouvez accéder aux informations privilégiées que lorsque vous êtes connecté.<br /><br />Vous pouvez vous connecter en tapant votre <b>#pgv_lang[username]#</b> et <b>#pgv_lang[password]#</b> puis en cliquant <b>#pgv_lang[login]#</b>.";
$pgv_lang["index_events_help"]			= "~#pgv_lang[upcoming_events_block]#~<br /><br />Ce bloc vous montre les anniversaires des événements à venir.<br /><br />L'administrateur détermine la longueur d'avance du bloc. Vous pouvez affiner davantage l'affichage des événements à venir dans le bloc grâce à plusieurs options de configuration.<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["todo_help"]  				 = "~#pgv_lang[todo_block]#~<br /><br />Ce bloc vous aide à conserver une trace des tâches <b>_TODO</b> dans la base de données.<br /><br />Pour ajouter des tâches à faire à vos enregistrements, vous pouvez en premier lieu amender la configuration du GEDCOM afin que le fait <b>_TODO</b> apparaisse dans la liste des faits qui peuvent être ajoutés aux enregistrements des individus, familles, sources, et archives. Chacune de ces listes, que vous trouverez dans la section Modifier les options de la configuration du GEDCOM, est indépendante. La séquence des entrées de la liste n'est pas important ; vous pouvez ajouter les nouvelles entrées au début de chacune des listes.";
$pgv_lang["todo_show_other_help"]   	 = "Afficher les tâches assignées aux autres utilisateurs";
$pgv_lang["todo_show_unassigned_help"]  = "Afficher les tâches qui ne sont assignées à aucun utilisateur";
$pgv_lang["todo_show_future_help"]  	 = "Afficher les tâches qui ont une date dans le futur. Sinon seuls les items qui ont une date dans le passé sont affichés. ";
$pgv_lang["yahrzeit_help"]  			 = "~#pgv_lang[yahrzeit_block]#~<br /><br />Ce bloc montre les Yahrzeiten qui vont arriver dans un avenir proche.<br /><br />Les Yahrzeiten (singulier : Yahrzeit) sont les anniversaires du décès d'une personne.  Ces anniversaires sont observés dans la tradition juive ; ils ne sont plus d'usage courant dans d'autres traditions.  «Yahrzeit» peut aussi être épelé «Jahrzeit» ou «Yartzeit».<br /><br />L'administrateur détermine l'apparence de ce bloc. Vous pouvez par la suite améliorer l'affichage de ce bloc en faisant appel aux options de configuration.<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["days_to_show_help"]  		 = "~#pgv_lang[days_to_show]#~<br /><br />Saisissez le nombre de jours à afficher. Ce nombre ne pourra pas excéder <b>#DAYS_TO_SHOW_LIMIT#</b>.  Si vous saisissez une valeur plus grande, la valeur limite sera utilisée.<br /><br />La limite est spécifiée par l'administrateur dans la configuration du GEDCOM, section «Affichage», sous-section «Cacher/Montrer».";
$pgv_lang["random_media_persons_or_all_help"]	= "~#pgv_lang[random_media_persons_or_all]#~<br /><br />Cette option vous permet de déterminer le type de média à visualiser.<br /><br />Quand vous choisissez <b>#pgv_lang[random_media_persons]#</b>, seuls les médias associées à des individus seront visibles. Habituellement, ce sera la photographie d'un individu. Quand vous sélectionnez <b>#pgv_lang[random_media_events]#</b>, seuls les médias associés à des faits ou des événements seront visibles. Cela peut être une image d'un certificat. Quand vous sélectionnez <b>#pgv_lang[all]#</b>, ce bloc montrera tous les types de média.";
$pgv_lang["random_media_filter_help"]   = "~#pgv_lang[filter]#~<br /><br />Vous pouvez restreindre ce que le bloc «Une image au hasard» a le droit d'afficher en fonction du format et du type de média.  Quand vous cochez la case correspondant à votre choix, ce bloc est autorisé à afficher les média correspondant au format ou au type que vous avez sélectionné.<br /><br />Les formats ou les types de média qui existent dans votre base de données mais qui ne figurent pas dans ces listes à cocher, sont supposées avoir leur case déjà cochée. Par exemple, si votre base de données contient des média au format <b><i>pdf</i></b>, ce bloc a l'autorisation d'afficher les média de ce type.  De même, si votre base de données contient des média du type <b><i>special</i></b>, ce bloc a l'autorisation d'afficher les média de ce type.";
$pgv_lang["basic_or_all_help"]  		 = "~#pgv_lang[basic_or_all]#~<br /><br />Cette option vous permet de supprimer quelques événements datés.  Par exemple, #factarray[DIV]#, #factarray[CREM]#, #factarray[GRAD]#, #factarray[BARM]#, #factarray[FCOM]#, etc. devraient systématiquement être datés.<br /><br />Quand vous choisissez <b>#pgv_lang[yes]#</b>, seuls les naissances, les décès, et les mariages seront affichés. Quand vous choisissez <b>#pgv_lang[no]#</b>, tous les événements datés seront affichés.";
$pgv_lang["style_help"] 				 = "~#pgv_lang[style]#~<br /><br />Cette option contrôle comment les informations sont présentées.<br /><br />Quand vous sélectionnez <b>#pgv_lang[style1]#</b>, les informations sont présentées sous la forme de textes, semblables à ce que vous pouvez voir dans les divers diagrammes.  Ce format convient aux blocs qui apparaissent sur le côté droit de la page.<br /><br />Quand vous sélectionnez <b>#pgv_lang[style2]#</b>, les informations sont présentes sous la forme d'un tableau qui convient mieux aux blocs qui sont affichés du côté gauche de la page.";
$pgv_lang["sort_style_help"]			= "~#pgv_lang[sort_style]#~<br /><br />Cette option contrôle la façon dont les informations sont triées.<br /><br />Lorsque vous sélectionnez <b>#pgv_lang[by_alpha]#</b>, les informations sont affichées par ordre alphabétique. Lorsque vous sélectionnez <b>#pgv_lang[by_anniv]#</b>, les informations sont classées par anniversaire, en commençant par les anniversaires les plus récents.";
$pgv_lang["cal_dowload_help"]   		 = "~#pgv_lang[cal_download]#~<br /><br />Cette option contrôle l'affichage du bouton permettant de télécharger le calendrier des événements. Le fichier du calendrier téléchargé peut être importé dans un programme compatible comme Microsoft Outlook, par exemple, générant automatiquement des rappels d'anniversaires par e-mail.<br /><br />Quand le réglage est <b>#pgv_lang[no]#</b>, l'utilisateur connecté ne pourra pas télécharger le calendrier. Quand le réglage est <b>#pgv_lang[yes]#</b>, le bouton de téléchargement est visible. Le bouton est toujours masqué si l'utilisateur n'est pas connecté.";
$pgv_lang["cal_download_user_help"]		= "Si vous êtes connecté, vous pouvez voir l'icône <img src='images/ical.png' alt='' />. Si vous cliquez l'icône, vous téléchargerez les événements sous forme de fichier de calendrier, qui peut être importé dans des programmes compatibles tels que Microsoft Outlook pour, par exemple, générer des rappels automatiques par e-mail des anniversaires.<br /><br />Si vous êtes connecté et que vous ne voyez pas cette icône, l'administrateur a désactivé cette fonctionnalité. Les visiteurs qui ne sont pas connectés ne verront pas cette icône et ne pourront pas télécharger le fichier de calendrier.";
$pgv_lang["index_charts_help"]  		 = "~#pgv_lang[charts_block]#~<br /><br />Ce bloc permet l'affichage d'un arbre généalogique, d'une descendance ou d'un sablier sur la page d'accueil ou la page personnelle Mon portail de l'utilisateur. En raison des limitations d'espace sur la page, les diagrammes ne doivent être affichés que sur la partie gauche de la page.<br /><br />Quand ce bloc est affiché sur la page d'accueil, la personne racine et le type de diagramme affiché sont définis par l'administrateur. Quand ce bloc est affiché sur la page personnelle Mon portail de l'utilisateur, ces options sont définies par l'utilisateur.<br /><br />Le comportement de ces diagrammes est identique à leur comportement quand ils sont affichés depuis les barres de menu. Si vous cliquez la case d'une personne vous obtiendrez des détails supplémentaires sur cette personne.";
$pgv_lang["index_onthisday_help"]   	 = "~#pgv_lang[todays_events_block]#~<br /><br />Ce bloc fonctionne comme le bloc #pgv_lang[upcoming_events_block]#, sauf qu'il affiche les événements d'aujourd'hui.<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["index_favorites_help"]		= "~#pgv_lang[gedcom_favorites_block]#~<br /><br />Ce bloc est sensiblement le même que le bloc #pgv_lang[user_favorites_block]# de la page #pgv_lang[mygedview]#. Contrairement à la configuration de la page du portail, seul l'administrateur ou un utilisateur avec des droits d'administrateur peut modifier la liste des favoris de ce bloc.<br /><br />Le but de ce bloc est d'attirer l'attention du visiteur sur des personnes présentant un intérêt particulier. Les favoris de ce GEDCOM peuvent être sélectionnés dans une liste dans l'en-tête de chaque page.<br /><br />Lorsque vous cliquez l'un des favoris du site, vous serez redirigé vers la page #pgv_lang[indi_info]# de cette personne.";
$pgv_lang["index_add_favorites_help"]   = "~#pgv_lang[add_favorite]#~<br /><br />Ce formulaire vous permet d'ajouter un nouveau favori à votre liste de favoris.<br /><br />Vous devez saisir l'ID de l'individu ou de la famille ou la source que vous voulez enregistrer comme favori, ou vous pouvez saisir un URL et un titre. Le champ Notes est optionnel et peut être utilisé pour décrire le favori.  N'importe quel commentaire écrit dans le champ Notes sera affiché dans le bloc favoris après celui-ci.";
$pgv_lang["index_stats_help"]   		 = "~#pgv_lang[gedcom_stats_block]#~<br /><br />Ce bloc présente quelques chiffres concernant ce fichier GEDCOM. Si vous souhaitez d'autres informations, utilisez le lien <b>Contact</b> en bas de page.";
$pgv_lang["index_common_names_help"]	 = "~#pgv_lang[block_top10]#~<br /><br />Ce bloc affiche la liste des noms de famille les plus fréquents. Leur nombre est déterminé par l'administrateur.<br /><br />En cliquant un nom de la liste, vous afficherez la page <b>#pgv_lang[individual_list]#</b>, qui vous donnera davantage de détails.";
$pgv_lang["index_common_given_names_help"]	= "~#pgv_lang[block_givn_top10]#~<br /><br />Ce bloc listera les prénoms les plus fréquents. Il montre les noms masculins et féminins dans les colonnes. Une troisième colonne apparaîtra lorsqu'il y a des personnes dont le sexe n'est pas connu. <br /><br />L'administrateur détermine combien de noms sont réellement affichés.";
$pgv_lang["index_media_help"]			= "~#pgv_lang[random_media_block]#~<br /><br />Dans ce bloc, PhpGedView choisit au hasard un fichier multimédia à vous montrer à chaque visite sur cette page.<br /><br />Lorsque vous cliquez sur l'image, vous verrez sa version en taille réelle. Sous l'image, vous avez un lien vers la personne associée à l'image. Lorsque vous cliquez sur la légende de l'image, vous verrez l'image sur la page #pgv_lang[media_list]#. Lorsque vous cliquez le nom de la personne, vous serez redirigé vers la page #pgv_lang[indi_info]# de cette personne.";
$pgv_lang["index_loggedin_help"]		= "~#pgv_lang[logged_in_users_block]#~<br /><br />Ce bloc vous montrera les utilisateurs actuellement connectés.<br /><br />Si vous n'êtes pas un administrateur, votre vue des utilisateurs connectés est limitée à ceux qui ont choisi d'être visibles en ligne. Pour que cela fonctionne, vous devez également choisir d'être visible en ligne. Les utilisateurs en ligne qui ne vous sont pas visibles sont considérés comme anonymes.";
$pgv_lang["index_gedcom_news_help"] 	 = "~#pgv_lang[gedcom_news_block]#~<br /><br />Ce bloc fonctionne comme un tableau d'affichage. L'administrateur y affiche des annonces importantes ou des nouveautés intéressantes.<br /><br />Si vous avez quelquechose d'y afficher, vous devez contacter l'administrateur qui peut le faire pour vous.";
$pgv_lang["recent_changes_help"]		 = "~#pgv_lang[recent_changes_block]#~<br /><br />Ce bloc affiche les modifications les plus récentes suivant les marqueurs CHAN du fichier GEDCOM.";
$pgv_lang["gedcom_news_limit_help"] 	 = "Vous pouvez limiter le nombre d'articles affichés, réduisant ainsi la hauteur du bloc des nouvelles du GEDCOM.<br /><br />Cette option détermine si des limites doivent être appliquées ou si la limite du nombre d'articles doit être contrôlée à partir de l'ancienneté de l'article ou le nombre total d'articles.";
$pgv_lang["gedcom_news_flag_help"]  	 = "Saisissez la valeur limite ici.<br /><br />Si vous avez opté pour la limite de l'affichage des articles à partir de leur date de publication, tout article plus vieux que le nombre de jours spécifié sera masqué. Si vous avez opté pour limiter le nombre d'articles selon leur nombre, seulement le nombre d'articles spécifié parmi les plus récents sera affiché.  Les articles restants seront masqués.<br /><br />Zéro ici supprimera toutes limites, affichant tous les articles.";
$pgv_lang["gedcom_news_archive_help"]   = "Afin de réduire la hauteur du bloc «Nouvelles», l'administrateur a caché certains articles. Vous pouvez les visualiser en cliquant <b>#pgv_lang[gedcom_news_archive]#</b>.";
$pgv_lang["index_htmlplus_help"]		= "~#pgv_lang[htmlplus_block_name]#~<br /><br />Ce bloc permet à l'administrateur d'ajouter des informations à la page d'accueil ou à la page du portail. Son objectif est similaire aux blocs #pgv_lang[html_block_name]#, #pgv_lang[gedcom_news_block]#, et #pgv_lang[gedcom_stats_block]#, mais l'administrateur a plus de contrôle sur son apparence.";
$pgv_lang["index_htmlplus_title_help"]  = "~#factarray[TITL]#~<br /><br />Ce champ de texte doit être laissé vide ou alors rempli très succinctement.  S'il est laissé vide, le bloc en HTML avancé sera visualisé sur la page d'accueil ou sur la page du portail comme un bloc de texte simple, comme le bloc en HTML standard.  Quand il y a du texte, le bloc en HTML avancé sera visualisé comme les autres blocs, complet avec une barre de titre pour le bloc contenant le texte que vous avez saisi ici.";
$pgv_lang["index_htmlplus_template_help"]	= "~#pgv_lang[htmlplus_block_templates]#~<br /><br />Pour vous aider à travailler avec ce bloc, nous avons créé plusieurs modèles standards. Quand vous sélectionnez l'un de ces modèles, l'espace de saisie du texte contient une copie que vous pouvez modifier et personnaliser selon les exigences de votre site.";
$pgv_lang["index_htmlplus_content_help"]	= "~#pgv_lang[htmlplus_block_content]#~<br /><br />Contrairement aux blocs #pgv_lang[html_block_name]#, #pgv_lang[gedcom_news_block]#, et #pgv_lang[gedcom_stats_block]# blocks, vous avez un contrôle total sur l'apparence de votre bloc. Vous pouvez utiliser des balises HTML et le bloc utilise les feuilles de style CSS du thème actuellement actif. Des références à des informations de la base de données généalogiques actuellement active peuvent être incluses dans le texte.<br /><br />Les références à la base de données sont signalées dans le texte en insérant des mots-clés dans des symboles <b>&#35;</b> jumelé. Par exemple, <b>&#35;totalFamilies&#35;</b> représente le nombre de familles dans la base de données. À l'occasion, vous souhaiterez peut-être utiliser une référence de base de données comme texte au lieu de sa véritable signification. Pour ce faire, vous devez remplacer les symboles <b>&#35;</b> entourant le mot-clé par leur équivalent symbolique. Par exemple, si votre texte contient <b>&amp;&#35;35;totalFamilies&amp;&#35;35;</b>, il s’imprimera sous la forme <b>&#35;totalFamilies&#35;</b> au lieu de devenir une référence de base de données.<br /><br />Pour un exemple complet de l'utilisation de ce bloc, veuillez examiner le modèle «#pgv_lang[gedcom_stats_block]#» ; trouvé dans le dossier blocks/ ; il utilise la plupart des styles de balises, y compris les liens de langue et de texte d'aide.<br /><br />Le modèle <b>#pgv_lang[htmlplus_block_keyword]#</b> contient un liste de tous les mots-clés.";
$pgv_lang["index_htmlplus_compat_help"] = "~#pgv_lang[htmlplus_block_compat]#~<br /><br />Permet la compatibilité avec des versions plus anciennes des blocs. Quand ils sont vérifiés, les anciens et les nouveaux mots-clés seront reconnus indifféremment.<br /><br />Par exemple, le texte <b>&#35;TOTAL_FAM&#35;</b> sera reconnu comme équivalent de <b>&#35;totalFamilies&#35;</b>, <b>&#35;FIRST_DEATH_PLACE&#35;</b> pour <b>&#35;firstDeathPlace&#35;</b>, <b>&#35;TOP10_BIGFAM&#35;</b> pour <b>&#35;topTenLargestFamily&#35;</b>, etc.<br /><br />À moins que ce ne soit absolument nécessaire, vous ne devriez pas employer le mode compatibilité.";
$pgv_lang["index_htmlplus_gedcom_help"] = "~#pgv_lang[htmlplus_block_gedcom]#~<br /><br />Choisissez la base de données à laquelle sont liés les mots clés.<br /><br />Votre site supporte plusieurs bases de données. Les mots-clés tels que <b>&#35;totalFamilies&#35;</b> se réfèrent uniquement à une seule base de données.  Vous pouvez identifier la base de données qui doit être consultée par tous les mots-clés.  Chaque bloc #pgv_lang[htmlplus_block_name]# ne peut accéder qu'à une seule base de données.";
$pgv_lang["showUnknown_help"]   		 = "~#pgv_lang[showUnknown]#~<br /><br />Montrer ou masquer la liste des noms de famille des personnes dont le sexe est inconnu.<br /><br />Le bloc #pgv_lang[block_givn_top10]# masque toujours la liste des noms de famille quand aucune personne de ce sexe n'existe dans la base de données. Cette option vous permet de masquer la liste des personnes de sexe inconnu même s'il existe de telles personnes dans votre base de données. ";

//-- Index-Page Help
$pgv_lang["help_help"]					= "Bien sûr, il serait idéal de créer un programme si simple et facile à utiliser qu'il ne nécessite aucune explication ; cela devrait être aussi simple que de lire un livre.<br /><br />Bien que PhpGedView soit très compliqué, vous ne devriez pas le remarquer lorsque vous l'utilisez ; presque tout peut être utilisé sans explication. Mais, comme nous pouvons avoir beaucoup de visiteurs et d'utilisateurs qui ne sont pas très expérimentés avec l'utilisation d'un ordinateur ou avec Internet, nous vous offrons de l'aide à certains endroits.<br /><br />Dans le menu Aide, vous trouverez les chapitres suivants :";
$pgv_lang["help_page_help"] 			 = "<ul><li><b>#pgv_lang[help_for_this_page]#</b><br />Il existe un texte d'aide pour chaque page. En cliquant <b>#pgv_lang[page_help]#</b>, vous aurez une aide générale sur la page active.<br />Pour une aide plus détaillée, ou de l'aide  sur un champ, cliquer <b>#pgv_lang[qm]#</b> qui affichera l'aide contextuelle.</li></ul>";
$pgv_lang["help_content_help"]  		 = "<ul><li><b>Sommaire de l'aide</b><br />Ce menu affiche la liste de tous les textes d'aide disponibles.</li></ul>";
$pgv_lang["help_faq_help"]  			 = "<ul><li><b>Liste des FAQ</b><br />#pgv_lang[text_faq_help]#</li></ul>";
$pgv_lang["help_HS_help"]				= "<ul><li><b>#pgv_lang[hs_title]#</b><br />#pgv_lang[hs_intro]#</li></ul>";
$pgv_lang["help_qm_help"]				= "<ul><li><b>#pgv_lang[show_context_help]#</b><br />Ce dernier élément de menu pourrait être le plus utile pour vous. Cliquez sur ce lien pour activer ou désactiver l'«Aide contextuelle».<br /><br />Avec l'aide contextuelle activée, vous pouvez trouver un point d'interrogation ou une icône similaire à côté de certains liens, cases ou boutons. Lorsque vous cliquez sur cette icône, un écran d'aide apparaît. Cet écran d'aide contient des informations sur cet objet.<br /><br />Bien sûr, lorsque vous cliquez «Masquer l'aide contextuelle», tous les points d'interrogation ou icônes disparaissent jusqu'à ce que vous cliquiez «Afficher ....» de nouveau.</li></ul>";

//-- Index-page Definitions
$pgv_lang["def_help"]   				 = "<div class='name_head center'><b>#pgv_lang[definitions]#</b></div><br />Voici quelques explications sur les termes qui sont utilisés dans ce texte d'Aide :<ul><li><a href=\"#def_gedcom\"><b>GEDCOM</b></a><br /></li><li><a href=\"#def_gedcom_date\"><b>Dates</b></a></li><li><a href=\"#def_pdf_format\"><b>fichier au format PDF</b></a></li><li><a href=\"#def_pgv\"><b>PhpGedView</b></a></li><li><a href=\"#def_portal\"><b>Portail</b></a></li><li><a href=\"#def_theme\"><b>Thème</b></a></li></ul>";
$pgv_lang["def_portal_help"]			 = "~Portail~<br /><br />Le portail de ce site est un peu comme l'entrée d'un restaurant ou d'une bibliothèque. C'est le lieu par lequel vous entrez, mais vous pouvez aussi y trouver des informations importantes telles que des explications, des menus, etc.";
$pgv_lang["def_gedcom_help"]			 = "~Fichier GEDCOM~<br /><br />Voici un extrait de l'introduction au standard GEDCOM 5.5.1 :<div class=\"list_value_wrap\">#pgv_lang[quote_gedcom]#</div><br />Version française :<div class=\"list_value_wrap\">GEDCOM a été développé par le département de l'histoire des familles de l'Église de Jésus-Christ des Saints des Derniers Jours (SDJ) afin de fournir un format flexible et uniforme permettant l'échange de données généalogiques informatisées.&nbsp; GEDCOM est l'acronyme de <i><b>GE</b></i>nealogical <i><b>D</b></i>ata <i><b>Com</b></i>munication (communication de données genéalogiques).&nbsp; Son objectif est de faciliter l'échange d'informations généalogiques et le développement d'un éventail important de logiciels inter-operables afin de faciliter le travail des génealogistes, historiens, et autres chercheurs.</div><br />Une <u>copie de travail</u> du standard GEDCOM 5.5.1, auquel PhpGedView adhère, peut être téléchargée au format PDF ici : <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\">GEDCOM 5.5.1 Standard</a> Ce standard n'est disponible qu'en anglais.<br /><br />Le fichier GEDCOM contient toutes les informations sur la famille.&nbsp; Tous les faits, les dates, les événements, etc. sont enregistrés ici.&nbsp; Les fichiers GEDCOM doivent suivre des règles strictes afin de pouvoir être échangés entre beaucoup de programmes différents, indépendamment de la plateforme ou du système d'exploitation utilisé.";
$pgv_lang["def_gedcom_date_help"]		= "~Dates GEDCOM~<br /><br />Bien que le champ de date permette une entrée de forme libre (ce qui signifie que vous pouvez taper ce que vous voulez), il existe certaines règles sur la façon dont les dates doivent être saisies conformément à la norme GEDCOM 5.5.1.<ul><li>Une date complète est saisi sous la forme JJ MMM AAAA. Par exemple,<b>01&nbsp;MAR&nbsp;1801</b> ou <b>14&nbsp;DEC&nbsp;1950</b>.</li><li>S'il vous manque une partie de la date, vous pouvez l'omettre partie. Par exemple : <b>MAR&nbsp;1801</b> ou <b>14&nbsp;DEC</b>.</li><li>Si vous n'êtes pas sûr ou si la date n'est pas confirmée, vous pouvez saisir <b>ABT&nbsp;MAR&nbsp;1801</b> (abt = about = environ), <b>BEF&nbsp;20&nbsp;DEC&nbsp;1950</b> (bef = before = avant), <b>AFT&nbsp;1949</b> (aft = after = après)</li><li>Les plages de dates sont saisies sous la forme <b>FROM&nbsp;MAR&nbsp;1801&nbsp;TO&nbsp;20&nbsp;DEC&nbsp;1810</b> ou comme <b>BET&nbsp;MAR&nbsp;1801&nbsp;AND&nbsp;20&nbsp;DEC&nbsp;1810</b> (bet = between = entre)<br /><br /><b>FROM</b> indique que l'événement décrit s'est produit en continu entre les dates indiquées et est utilisé avec des événements tels que l'emploi. <b>BET</b> indique une seule occurrence de l'événement, parfois entre les dates indiquées et est utilisé avec des événements tels que la naissance.<br /><br />Les dates imprécises, où le jour du mois ou le mois est manquant, sont toujours interprétées comme la première ou la dernière date possible, selon que cette date imprécise survient avant ou après le mot-clé de séparation. Par exemple, <b>FEB&nbsp;1804</b> est interprété comme <b>01&nbsp;FEB&nbsp;1804</b> lorsqu'il survient avant le TO ou AND, et comme <b>29&nbsp;FEB&nbsp;1804</b> lorsqu'elle survient après le TO ou AND.</li></ul><br /><b>Assurez-vous d'entrer les dates et les abréviations en <u>anglais</u>,</b> car le fichier GEDCOM est échangeable et PhpGedView peut traduire correctement toutes les dates et abréviations dans la langue actuellement active. De plus, PhpGedView effectue des calculs en utilisant ces dates. Si des dates incorrectes sont saisies dans les champs de date, PhpGedView ne pourra pas calculer correctement. Vous pouvez cliquer l'icône Calendrier pour vous aider à sélectionner une date.<br /><br />Les abréviations sont les suivantes :<ul><li>JAN = January = janvier</li><li>FEB = February = février</li><li>MAR = March = mars</li><li>APR = April = avril</li><li>MAY = mai</li><li>JUN = June = juin</li><li>JUL = July = juillet</li><li>AUG = August = aoùt</li><li>SEP = September = septembre</li><li>OCT = October = octobre</li><li>NOV = November = novembre</li><li>DEC = December = décembre</li><li>bef = before = avant</li><li>abt = about = environ</li><li>aft = after = après</li></ul>";
$pgv_lang["def_gramps_help"]			 = "~Fichier de base de données XML GRAMPS~<br /><br />Un mot du projet GRAMPS :<div class=\"list_value_wrap\">#pgv_lang[quote_gramps]#</div><br />Version française<div class=\"list_value_wrap\">GRAMPS vous aide à pister votre arbre familial. Il vous permet de stocker, éditer et rechercher des données généalogiques. GRAMPS essaye de fournir toutes les possibilités communes aux autres programmes généalogiques, mais plus important, de vous fournir des fonctions supplémentaires permettant une capacité d'intégration d'informations généalogiques non disponible dans d'autres programmes. C'est la capacité d'Saisissez n'importe quel élément d'information directement dans GRAMPS et de manipuler, réarranger n'importe quels événements dans la base (dans n'importe quel ordre) pour aider l'utilisateur dans ses recherches, dans ses analyses en corrélation avec le potentiel des relations pouvant être définies entre les individus et les événements.</div><br />Une copie du format XML de GRAMPS v1.1.0 <a href=\"http://www.gramps-project.org/xml/1.1.0/\" target=\"_blank\">peut être téléchargé ici</a> dans les formats RELAX NG et DTD.<br /><br />Pour plus d'informations à propos du projet GRAMPS, visitez <a href=\"http://gramps-project.org/\" target=\"_blank\">http://gramps-project.org/</a>";
$pgv_lang["def_pgv_help"]   			 = "~PhpGedView~<br /><br />PhpGedView (ou PGV) ne fait pas que placer des pages statiques sur le Web ; il est dynamique et peut être personnalisé de multiples façons.<br /><br />PhpGedView a été créé par John Finlay dans le but de pouvoir visualiser des fichiers GEDCOM en ligne. John a commencé à développer le programme tout seul. Une équipe internationale de développeurs et de traducteurs l'a rejoint depuis et travaille à l'amélioration du programme. Parmi les fonctions les plus significatives qui ont été ajoutées ou améliorées dans le programme on peut citer son support important de nombreuses langues, et sa capacité à ajouter et modifier des événements en ligne.";
$pgv_lang["def_theme_help"] 			 = "~Thèmes~<br /><br />Ce site peut avoir différentes apparences, appelées «thèmes». L'administrateur du site choisit le thème par défaut, qui sera affiché par toute personne qui se connectera pour la première fois.<br /><br />Quand l'administrateur l'a autorisé, tous les utilisateurs peuvent choisir leur propre thème. PhpGedView se souvient du dernier thème choisi par chaque utilisateur enregistré, afin que cet utilisateur verra affiché ce thème la prochaine fois qu'il se connectera.<br /><br />Les thèmes peuvent être utilisés comme un moyen pour différencier les différentes bases de données qui sont hébergées sur un même site. Chaque base de données peut avoir son propre thème par défaut.";
		
//-- Index-page MyGEDCOM
$pgv_lang["mygedview_portal_help"]  	 = "~#pgv_lang[mygedview]#~<br /><br />C'est votre page #pgv_lang[mgv]# personnelle.<br /><br />Vous pourrez trouver sur cette page des liens pour accéder à vos données personnelles telles que <b>Mon compte</b>, <b>Mon indi</b> (votre page #pgv_lang[indi_info]# individuelle), et <b>Mon ascendance</b>. Vous pouvez avoir des blocs avec des <b>Messages</b>, un <b>Journal</b> et beaucoup d'autres choses.<br /><br />La structure de cette page est similaire à la page d'accueil qui est affichée lorsque vous accédez pour la première fois au site. Tandis que les différentes parties de la page d'accueil sont choisies par l'administrateur du site, vous pouvez choisir quelles sont les parties que vous voulez intégrer sur cette page personnelle. Vous trouverez le lien qui vous permettra de personnaliser la page dans le bloc de bienvenue ou séparément si le bloc de bienvenue n'est pas présent.<br /><br />Vous pouvez choisir parmi les blocs et liens suivants:<ul><li><a href=\"#mygedview_welcome\"><b>#pgv_lang[welcome_block]#</b></a></li><li><a href=\"#mygedview_customize\"><b>Personnaliser «#pgv_lang[mygedview]#»</b></a></li><li><a href=\"#mygedview_message\"><b>#pgv_lang[user_messages_block]#</b></a></li><li><a href=\"#mygedview_events\"><b>#pgv_lang[upcoming_events_block]#</b></a></li><li><a href=\"#mygedview_onthisday\"><b>#pgv_lang[todays_events_block]#</b></a></li><li><a href=\"#mygedview_charts\"><b>#pgv_lang[charts_block]#</b></a></li><li><a href=\"#mygedview_favorites\"><b>#pgv_lang[user_favorites_block]#</b></a></li><li><a href=\"#mygedview_stats\"><b>#pgv_lang[gedcom_stats_block]#</b></a></li><li><a href=\"#mygedview_myjournal\"><b>#pgv_lang[user_news_block]#</b></a></li><li><a href=\"#mygedview_media\"><b>#pgv_lang[random_media_block]#</b></a></li><li><a href=\"#mygedview_loggedin\"><b>#pgv_lang[logged_in_users_block]#</b></a></li><li><a href=\"#recent_changes\"><b>#pgv_lang[recent_changes_block]#</b></a></li></ul>";
$pgv_lang["mygedview_customize_help"]   = "~PERSONNALISER #pgv_lang[mygedview]#~<br /><br />Lorsque vous saisissez sur cette page pour la première fois, vous avez déjà des blocs sur cette page. Si vous le souhaitez, vous pouvez personnaliser cette page qui s'appelle Mon portail.<br /><br />Si vous cliquez sur ce lien vous serez dirigé vers un formulaire sur lequel vous pourrez ajouter, déplacer, ou supprimer des blocs. Des explications supplémentaires sont disponibles sur ce formulaire.";
$pgv_lang["mygedview_message_help"] 	 = "~#pgv_lang[user_messages_block]#~<br /><br />Dans ce bloc vous trouverez les messages qui vous ont été envoyés par les autres utilisateurs ou par l'administrateur du site. Vous pouvez également envoyer des messages aux autres utilisateurs ou à l'administrateur à partir de ce bloc.<br /><br />Le système de mail de PhpGedView a été conçu pour protéger votre vie privée. Vous n'avez pas besoin de laisser votre adresse email ici et les autres utilisateurs ne pourront pas voir votre adresse email.<br /><br />Pour voir la totalité d'un message, cliquez l'objet du message ou <b>+</b> qui se trouve à côté. Vous pouvez supprimer plusieurs messages en cochant les petites boites qui se trouvent à côté de chacun des messages que vous voulez supprimer et en cliquant <b>Supprimer les messages sélectionnés</b>.";
$pgv_lang["mygedview_favorites_help"]   = "~#pgv_lang[user_favorites_block]#~<br /><br />Les favoris sont similaires aux signets.<br /><br />Supposons que vous ayez quelqu'un dans votre arbre familial dont vous voulez consulter l'enregistrement régulièrement. Il vous suffit de vous rendre sur la page #pgv_lang[indi_info]# de cette personne et de sélectionner l'option <b>Ajouter à mes favoris</b> depuis le menu Favoris. Cette personne est maintenant enregistrée dans vos favoris.<br /><br />N'importe où que vous vous trouvez sur le site, vous pouvez cliquer un nom dans le menu «Mes Favoris» qui se trouve dans la barre de menus. Cela vous amènera à la page #pgv_lang[indi_info]# de cette personne.";
$pgv_lang["mygedview_myjournal_help"]   = "~#pgv_lang[user_news_block]#~<br /><br />Vous pouvez utiliser ce journal pour écrire des notes ou des rappels pour votre usage personnel. Quand vous écrivez des notes, elles seront encore présentes lors de votre prochaine visite du site.<br /><br />Ces notes sont privées et ne seront pas visibles par d'autres personnes.";
$pgv_lang["mygedview_welcome_help"] 	 = "~#pgv_lang[welcome_block]#~<br /><br />Le bloc Bienvenue vous affiche:<ul><li>Le fichier GEDCOM courant</li><li>La date et l'heure</li><li>Des liens vers:<ul><li>#pgv_lang[myuserdata]#</li><li>#pgv_lang[my_pedigree]#</li><li>#pgv_lang[my_indi]#</li><li>#pgv_lang[customize_page]#</li></ul></li></ul><br /><b>Note:</b> Vous verrez des liens vers <b>#pgv_lang[my_indi]#</b> et <b>#pgv_lang[my_pedigree]#</b> seulement si vous êtes connu du fichier GEDCOM courant, tandis que dans un autre fichier GEDCOM vous n'avez aucun enregistrement qui vous concerne et donc ces liens ne sont pas affichés.";

//-- Pedigree-page
$pgv_lang["help_pedigree.php"]			= "~LA PAGE PEDIGREE~<br /><br />Un pedigree est une énumération de tous les ancêtres de la personne de départ. Les utilisateurs qui ne sont pas connectés voient le pedigree de la personne de départ (root) choisie par l'administrateur du site. Les utilisateurs connectés peuvent sélectionner leur propre personne (racine) de départ.<br /><br />Dans ce contexte, «Tous les ancêtres» désigne le père et la mère, leurs parents, etc. Le pedigree est affiché graphiquement ; vous n'avez pas à vous battre à travers des pages de texte pour déterminer vos ancêtres.<br /><br />Tous les individus sont affichés dans les cases Nom sur l'écran.<br /><ul><li><b>Boîtes de nom sur le pedigree</b><br />Si la page Pedigree est configurée pour afficher les détails, vous verrez le nom de la personne et les dates de naissance et de décès. Vous pouvez cliquer le nom d'une personne pour accéder directement à la page #pgv_lang[indi_info]# de cette personne.<br /><br />Lorsque <b>Afficher les détails</b> est activée, il y a deux icônes dans le boîte de nom.</li><li><b>Icône d'ascendance dans la zone Nom</b><br />Lorsque l'option <b>Afficher les détails</b> est activée, vous voyez une icône d'ascendance dans la zone Nom. Selon les paramètres du site, vous devez survoler l'icône ou cliquer dessus. Lorsque vous cliquez ou survolez cette icône, un petit sous-menu apparaît.<br /><br />Les éléments <b>#pgv_lang[index_header]#</b> et <b>#pgv_lang[descend_chart]#</b> sont similaires à ceux du menu principal, mais la différence est que la personne de départ est désormais le individu de mentionné dans la zone Nom. Vous voyez également <b>#pgv_lang[as_spouse]#</b>. En dessous, vous voyez le nom du conjoint suivi des noms des enfants. Tous les noms sont cliquables.</li><li><b>Loupe à l'intérieur de la zone Nom</b><br />Selon les paramètres du site, vous devez survoler l'icône ou cliquer dessus. Cela agrandit la zone Nom afin que plus de détails soient affichés. Vous verrez plus de dates et d'événements. Les noms sont cliquables.</li><li><b>Flèches</b><br />À gauche ou à droite des zones de nom les plus à gauche ou à droite, vous pouvez voir des flèches. Lorsque vous cliquez ces flèches, l'affichage de l'écran se déplace dans le sens de la flèche.</li></ul><br />#pgv_lang[context_help]#";
$pgv_lang["show_full_help"]				= "~#pgv_lang[show_details]#~<br /><br />Avec cette option, vous pouvez afficher ou masquer tous les détails dans les zones Nom. Vous pouvez afficher plusieurs cases sur un écran lorsque les détails sont masqués.<br /><br />Lorsque tous les détails sont masqués, l'icône Zoom décrite ci-dessous ne s'affiche pas. Cependant, si l'administrateur a activé la fonction Zoom, la boîte entière agira comme une icône Zoom pour révéler tous les détails sur la personne.<br /><br />Lorsque les détails ne sont pas masqués et que la fonction Zoom, identifiée par une icône en forme de loupe, a été activée par l'administrateur, vous pouvez révéler encore plus de détails sur cette personne. Si vous devez normalement cliquer l'icône Zoom pour zoomer, vous pouvez révéler des détails cachés supplémentaires en cliquant cette icône ici. De même, si vous pouvez zoomer en survolant l'icône Zoom, les détails cachés seront révélés en survolant cette icône ici.<br /><br />Si vous avez cliqué l'icône Zoom pour révéler plus de détails, vous pouvez restaurer la boîte à son niveau de détail normal en cliquant à nouveau l'icône Zoom. Si vous avez révélé plus de détails en déplaçant simplement le pointeur de la souris sur l'icône Zoom, la boîte sera restaurée à son niveau de détail normal lorsque vous éloignerez le pointeur de la souris de l'icône Zoom.";
$pgv_lang["talloffset_help"]			= "~#pgv_lang[portrait]# / #pgv_lang[landscape]#~<br /><br />Avec cette option, vous déterminez l'orientation de la mise en page.<br /><br />La modification de ce paramètre peut être utile si vous souhaitez effectuer une impression d'écran ou si vous avez un autre type d'écran.<ul><li><b>#pgv_lang[portrait]#</b>&nbsp;&nbsp;&nbsp;rendra l'arbre plus grand, de sorte qu'un graphique de 4 générations devrait tenir sur une seule page imprimée verticalement.</li><li><b>#pgv_lang[landscape]#</b>&nbsp;&nbsp;&nbsp;fera un arbre plus large qui devrait s'imprimer sur une seule page imprimée horizontalement.</li><li><b>#pgv_lang[landscape_top]#</b>&nbsp;&nbsp;&nbsp;fait pivoter le graphique, mais pas ses cases, de 90 degrés dans le sens inverse des aiguilles d'une montre, de sorte que la génération la plus ancienne se trouve en haut du graphique.</li><li><b>#pgv_lang[landscape_down]#</b>&nbsp;&nbsp;&nbsp;fait pivoter le graphique, mais pas ses cases, de 90 degrés dans le sens des aiguilles d'une montre, de sorte que la génération la plus ancienne se trouve en bas du graphique.</li></ul>";
$pgv_lang["rootid_help"]				= "~#pgv_lang[rootid]#~<br /><br />Si vous souhaitez afficher un graphique avec une nouvelle personne de départ (racine), l'ID de cette nouvelle personne de départ est saisi ici.<br /><br />Si vous ne connaissez pas l'ID de cette personne, utilisez le lien <b>Rechercher l'ID</b>.<br /><br /><b>NUMÉRO D'IDENTIFICATION</b><br />Les numéros d'identification utilisés dans PhpGedView ne sont <u>pas</u> les numéros d'identification émis par différents gouvernements (permis de conduire ou numéros de passeport, par exemple). Le numéro d'identification auquel il est fait référence ici est simplement un numéro utilisé dans la base de données pour identifier de manière unique chaque individu ; il a été attribué par le programme d'ascendance qui a créé le fichier GEDCOM qui a été importé dans PhpGedView.";
$pgv_lang["PEDIGREE_GENERATIONS_help"]	= "~#pgv_lang[generations]#~<br /><br />Ici, vous pouvez définir le nombre de générations à afficher sur cette page.<br /><br />Le nombre qui vous convient dépend de la taille de votre écran et si vous affichez les détails ou non. Le temps de traitement augmentera à mesure que vous augmentez le nombre de générations.";

//-- LOGIN-page
$pgv_lang["login_page_help"]			 = "~#pgv_lang[login]#~<br /><br />Sur cette page vous pouvez vous connecter, et demander un compte utilisateur ou un nouveau mot de passe.";
$pgv_lang["username_help"]  			 = "~#pgv_lang[username]#~<br /><br />Saisissez ici votre nom d'utilisateur.<br /><br /><b>Respectez les majuscules/minuscules.</b> Cela signifie que <b>MonNom</b> n'est <u>pas</u> identique à <b>monnom</b> ou <b>MONNOM</b>.";
$pgv_lang["password_help"]  			 = "~#pgv_lang[password]#~<br /><br />Saisissez ici votre mot de passe.<br /><br /><b>Respectez les majuscules/minuscules.</b> Cela signifie que <b>MotdePasse</b> n'est <u>pas</u> identique à <b>motdepasse</b> ou <b>MOTDEPASSE</b>.";
$pgv_lang["login_buttons_help"] 		 = "~BOUTON LOGIN~<br /><br />Ici, vous voyez un bouton pour vous connecter au système.<br /><br />Si vous cliquez ce bouton, vous reviendrez à la page sur laquelle vous vous trouviez, mais avec des droits d'accès connectés.<br /><br />Par exemple, si vous cliquez <b>#pgv_lang[login]#</b> lorsque vous étiez sur la page Pedigree, vous reviendrez à cette même page. Si vous cliquez ce bouton alors que vous étiez sur la page d'accueil principale, vous serez redirigé vers la page «#pgv_lang[mygedview]#», où vous pourrez modifier vos paramètres, ajouter ou modifier des favoris, envoyer et lire des messages, etc.";
$pgv_lang["login_buttons_aut_help"] 	 = "~BOUTON LOGIN~<br /><br />Ici, vous voyez un bouton pour vous connecter au système.<br /><br />En cliquant ce bouton, vous serez redirigé vers la page «#pgv_lang[mygedview]#», où vous pourrez modifier vos paramètres, ajouter ou modifier des favoris, envoyer et lire des messages, etc.";
$pgv_lang["new_password_help"]  		 = "~#pgv_lang[requestpassword]#~<br /><br />Si vous avez oublié votre mot de passe, cliquez ce lien.<br /><br />Vous serez redirigé vers le formulaire de «#pgv_lang[lost_pw_reset]#».";
$pgv_lang["new_user_help"]  			 = "~#pgv_lang[requestaccount]#~<br /><br />Si vous êtes un visiteur de ce site et souhaitez demander un compte utilisateur, vous pouvez cliquer ce lien.<br /><br />Selon la façon dont l'administrateur a configuré le site, votre client de messagerie peut être lancé afin que vous puissiez envoyer un e-mail à l'administrateur pour demander un nouvel identifiant de connexion, ou vous pouvez être redirigé vers la page «#pgv_lang[requestaccount]#».";
$pgv_lang["mygedview_login_help"]		= "Pour accéder à la page «#pgv_lang[mygedview]#», vous devez être un utilisateur enregistré sur le système. Sur cette page, vous pouvez ajouter vos personnes préférées à vos favoris, tenir un journal utilisateur, gérer les messages, voir les autres utilisateurs connectés et personnaliser divers aspects des pages PhpGedView.<br /><br />Entrez votre nom d'utilisateur et votre mot de passe dans les champs appropriés pour vous connecter à «#pgv_lang[mygedview]#».";
$pgv_lang["new_user_firstname_help"]	= "~#pgv_lang[firstname]#~<br /><br />Dans cette case, vous devez saisir votre prénom.<br /><br />Nous avons besoin de votre nom et prénom pour déterminer si vous êtes admissible à un compte sur ce site et quels devraient être vos droits. Ces noms seront visibles par les autres membres de la famille et les utilisateurs connectés.";
$pgv_lang["new_user_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br />Dans cette case, vous devez saisir votre nom de famille.<br /><br />Nous avons besoin de votre nom et prénom pour déterminer si vous êtes admissible à un compte sur ce site et quels devraient être vos droits. Ces noms seront visibles par les autres membres de la famille et les utilisateurs connectés.";
$pgv_lang["register_info_01"]			= "~#pgv_lang[requestaccount]#~<br /><br />La quantité de données pouvant être consultées publiquement sur ce site Web peut être limitée en raison de la loi applicable en matière de protection de la vie privée. De nombreuses personnes ne souhaitent pas que leurs données personnelles soient accessibles au public sur Internet. Les données personnelles peuvent être utilisées à des fins de spam ou de vol d'identité.<br /><br />L'accès à ce site est autorisé à tout visiteur disposant d'un compte utilisateur. Une fois que l'administrateur a vérifié et approuvé votre demande de compte, vous pourrez vous connecter.<br /><br />Si la confidentialité des relations a été activée, vous ne pourrez accéder aux informations privées de vos propres proches qu'après vous être connecté. L'administrateur peut également autoriser la modification de la base de données pour certains utilisateurs, afin qu'ils puissent modifier ou ajouter des informations.<br /><br />Si vous avez besoin d'une assistance supplémentaire, veuillez utiliser le lien ci-dessous pour contacter l'administrateur.";
$pgv_lang["register_info_02"]			= "~#pgv_lang[requestaccount]#~<br /><br />La quantité de données pouvant être consultées publiquement sur ce site Web peut être limitée en raison de la loi applicable en matière de protection de la vie privée. De nombreuses personnes ne souhaitent pas que leurs données personnelles soient accessibles au public sur Internet. Les données personnelles peuvent être utilisées à des fins de spam ou de vol d'identité.<br /><br />L'accès à ce site n'est possible qu'aux utilisateurs <u>autorisés</u>. Une fois que l'administrateur a vérifié et approuvé votre demande de compte, vous pourrez vous connecter.<br /><br />Si la confidentialité des relations a été activée, vous ne pourrez accéder aux informations privées de vos propres proches qu'après vous être connecté. L'administrateur peut également autoriser la modification de la base de données pour certains utilisateurs, afin qu'ils puissent modifier ou ajouter des informations.<br /><br />Si vous avez besoin d'une assistance supplémentaire, veuillez utiliser le lien ci-dessous pour contacter l'administrateur.";
$pgv_lang["register_info_03"]			= "~#pgv_lang[requestaccount]#~<br /><br />La quantité de données pouvant être consultées publiquement sur ce site Web peut être limitée en raison de la loi applicable en matière de protection de la vie privée. De nombreuses personnes ne souhaitent pas que leurs données personnelles soient accessibles au public sur Internet. Les données personnelles peuvent être utilisées à des fins de spam ou de vol d'identité.<br /><br />L'accès à ce site est autorisé aux <u>membres de la famille uniquement</u>. Une fois que l'administrateur a vérifié et approuvé votre demande de compte, vous pourrez vous connecter.<br /><br />Si la confidentialité des relations a été activée, vous ne pourrez accéder aux informations privées de vos propres proches qu'après vous être connecté. L'administrateur peut également autoriser la modification de la base de données pour certains utilisateurs, afin qu'ils puissent modifier ou ajouter des informations.<br /><br />Si vous avez besoin d'une assistance supplémentaire, veuillez utiliser le lien ci-dessous pour contacter l'administrateur.";


//-- Descendancy-page
$pgv_lang["help_descendancy.php"]		= "~#pgv_lang[descend_chart]#~<br /><br />Cette page affichera les descendants d'une personne.<br /><br />Vous pouvez choisir une personne de départ (racine) pour ce tableau de descendance ou vous pouvez être lié à cette page en cliquant <b>#pgv_lang[descend_chart]#</b> sur une autre page. Cliquez les icônes fléchées pour naviguer dans cet arbre dans le sens de la flèche. Cliquez l'icône Graphique dans n'importe quelle case Personne pour changer la racine de l'arbre en cette personne.";
$pgv_lang["desc_rootid_help"]			= "#pgv_lang[rootid_help]#";
$pgv_lang["desc_generations_help"]		= "#pgv_lang[PEDIGREE_GENERATIONS_help]#";

//-- Time line-page
$pgv_lang["help_lifespan.php"]  		 = "~#pgv_lang[lifespan_chart]#~<br /><br />Sur ce diagramme vous pouvez afficher un ou plusieurs individus le long d'un axe chronologique horizontal. Ce diagramme vous permet de voir comment les vies de différents individus se suivent ou se juxtaposent.<br /><br />Vous pouvez ajouter individuellement des individus à ce diagramme ou par famille. La liste précédente sera mémorisée au fur et à mesure que vous ajouterez des individus au diagramme. Vous pouvez vider le diagramme à n'importe quel moment avec le bouton <b>Effacer tout</b>.<br /><br />Vous pouvez également ajouter des individus au diagramme en les recherchant par date ou lieux.";
$pgv_lang["lifespan_add_person_help"]   = "#pgv_lang[add_person_help]#<br /><br /><b>Inclure la proche famille</b><br />L'option Inclure la proche famille est cochée par défaut. En laissant cette case cochée, vous visualiserez sur la ligne de temps le père, la mère, l'épouse, les frères et sœurs, ainsi que les enfants des individus qui sont ajoutés à la ligne de temps.  Désélectionnez cette option si vous souhaitez enlever la famille proche.";
$pgv_lang["help_timeline.php"]			= "~#pgv_lang[timeline_chart]#~<br /><br />Sur ce graphique, vous pouvez afficher une ou plusieurs personnes le long d'une chronologie. Vous pouvez, par exemple, visualiser l'état de deux personnes ou plus à un moment donné.<br /><br />Si vous cliquez <b>Chronologie</b> sur une autre page, vous en verrez déjà une personne sur la ligne du temps. Si vous avez cliqué <b>Chronologie</b> dans un en-tête de page, vous devez fournir l'ID de la personne de départ.";
$pgv_lang["add_person_help"]			= "~#pgv_lang[add_another]#~<br /><br />Vous pouvez avoir plusieurs personnes sur la chronologie.<br /><br />Utilisez cette case pour fournir l'identifiant de chaque personne. Si vous ne connaissez pas l'ID de la personne, vous pouvez cliquer <b>Rechercher l'ID</b> à côté de la zone.";
$pgv_lang["remove_person_help"]			= "~#pgv_lang[remove_person]#~<br /><br />Cliquez ce lien pour supprimer la personne de la chronologie.";
$pgv_lang["show_age_marker_help"]		= "~#pgv_lang[show_age]#~<br /><br />Si vous cochez cette case, vous verrez un marqueur Âge.<br /><br />Vous pouvez faire glisser ce marqueur Âge vers le haut ou vers le bas le long de la ligne du temps. Le marqueur d'âge coulissant est un bon outil pour vérifier l'âge d'une personne lors d'un certain événement. Vous pouvez activer ou désactiver le marqueur Âge individuellement pour chaque personne du graphique.";
$pgv_lang["timeline_control_help"]  	 = "~#pgv_lang[timeline_controls]#~<br /><br />~VITESSE~<br />Cliquez le menu déroulant pour changer la vitesse de défilement de l'axe chronologique.<br /><br />~Année de départ~<br />Saisissez l'année de départ de la chronologie.<br /><br />~Année de fin~<br />Saisissez l'année de fin de la chronologie.<br /><br />~Recherche~<br />Cliquez le bouton de recherche pour commencer la recherche d'événements qui se sont produits durant la période définie par les années de début et de fin.";

//-- Relationship-page
$pgv_lang["help_relationship.php"]		= "~#pgv_lang[relationship_chart]#~<br /><br />Sur cette page, vous pouvez afficher la relation entre deux personnes. Ces personnes n'ont pas à être directement liées par la ligne de sang ; toute relation sera trouvée.";
$pgv_lang["relationship_id_help"]		= "~#pgv_lang[id]# :: #pgv_lang[person1]# :: #pgv_lang[person2]#~<br /><br />Si vous êtes passé d'une autre page à celle-ci en cliquant <b>#pgv_lang[relationship_to_me]#</b>, vous verrez ici la relation entre vous et cet autre individu.<br /><br />Si vous êtes arrivé sur cette page via l'entrée de menu <b>Tableau des relations</b> sur n'importe quel en-tête de page, vous devez saisir les numéros d'identification des deux personnes dont vous souhaitez voir la relation. Si vous ne connaissez pas l'identifiant de la personne souhaitée, vous pouvez cliquer «#pgv_lang[find_id]#».";
$pgv_lang["next_path_help"]				= "~#pgv_lang[next_path]#~<br /><br />Vous pouvez cliquer ce bouton pour voir s'il existe un autre chemin de relation entre les deux personnes. Les chemins précédemment trouvés peuvent être affichés à nouveau en cliquant le lien avec le numéro du chemin.";
$pgv_lang["follow_spouse_help"]			= "~#pgv_lang[follow_spouse]#~<br /><br />Si cette case n'est pas cochée, les relations ne sont vérifiées qu'entre parents par le sang. Lorsque cette case est cochée, les relations par mariage sont également vérifiées. Vous trouverez probablement plus de relations en laissant cette case cochée.";
$pgv_lang["line_up_generations_help"]	= "~#pgv_lang[line_up_generations]#~<br /><br />Lorsque cette case est cochée, le diagramme sera imprimé avec les mêmes générations alignées horizontalement sur la page. Lorsqu'elle n'est pas cochée, chaque génération apparaîtra en descendant la page quel que soit le type de relation.";
$pgv_lang["oldest_top_help"]  			= "~#pgv_lang[oldest_top]#~<br /><br />Lorsque cette case est cochée, le graphique sera imprimé avec les personnes les plus âgées en haut. Lorsqu'elle n'est pas cochée, les plus jeunes apparaîtront en haut.<br /><br />Remarque: Cette option ne fonctionne que si <b>#pgv_lang[line_up_generations]#</b> est également cochée.";
		
//-- Ancestry-page
$pgv_lang["help_ancestry.php"]			= "~#pgv_lang[ancestry_chart]# page~<br /><br />La page d'ascendance est très similaire à la page <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, mais avec plus de détails et des affichages alternatifs #pgv_lang[chart_style]#.<br /><br />Chaque ascendance est indiquée avec un numéro unique, calculé selon le système <i>Sosa-Stradonitz</i>:<div style=\"padding-left: 30px;\"><b>Numéros pairs</b> pour les hommes (enfant * 2)<br /><b>Numéros impairs</b> pour les femmes (époux + 1) sauf pour <b>1</b></div><br />Exemple :<br /><div style=\"padding-left: 30px;\">La personne racine est <b>1</b>, quel que soit son sexe.<br />Le père de <b>1</b> est <b>2</b> (<b>1</b> * 2), la mère est <b>3</b> (<b>2</b> + 1).<br />Le père de <b>2</b> est <b>4</b> (<b>2</b> * 2), la mère est <b>5</b> (<b>4</b> + 1).<br />Le père de <b>3</b> est <b>6</b> (<b>3</b> * 2), la mère est <b>7</b> (<b>6</b> + 1).<br />Le père de <b>7</b> est <b>14</b> (<b>7</b> * 2), la mère est <b>15</b> (<b>14</b> + 1).<br />etc.</div>";
$pgv_lang["box_width_help"] 			 = "~#pgv_lang[box_width]#~</b><br /><br />Vous pouvez faire varier la largeur des cases entre 50% et 300%. La valeur initiale est 100% : chaque case fait environ 270 pixels de large.";
$pgv_lang["chart_style_help"]			= "~#pgv_lang[chart_style]#~<br /><br />Deux styles de graphique sont disponibles :<ul><li><b>#pgv_lang[chart_list]#</b>&nbsp;&nbsp;&nbsp;Arbre vertical, avec des familles pliables / extensibles.</li><li><b>#pgv_lang[chart_booklet]#</b>&nbsp;&nbsp;&nbsp;Une famille par page, avec les parents, les grands-parents et tous les enfants enregistrés.<br /><br />Ce format est facile à imprimer pour donner à vos proches.</li></ul>";

//-- Fan chart-page
$pgv_lang["help_fanchart.php"]			= "~#pgv_lang[fan_chart]#~<br /><br />Le diagramme #pgv_lang[fan_chart]# est très similaire au <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, mais d'une manière plus graphique.<br /><br />Le La personne racine est représentée au centre, ses parents sur le premier anneau, les grands-parents sur le deuxième anneau, etc.<br /><br />Les années de naissance et de décès sont imprimées sous le nom lorsqu'elles sont connues.<br /><br />Cliquer un nom sur le graphique ouvrira un menu de liens spécifique à cette personne. Dans ce menu, vous pouvez choisir de centrer le diagramme sur cette personne ou sur l'un de ses proches parents, ou vous pouvez accéder à la page #pgv_lang[indi_info]# de cette personne ou à un autre tableau pour cette personne.";
$pgv_lang["fan_width_help"] 			 = "~#pgv_lang[fan_width]#~</b><br /><br />Vous pouvez faire varier la taille de la roue entre 50% et 300%. La valeur initiale est 100% : l'image de la roue fait environ 640 pixels de large.";
$pgv_lang["fan_style_help"]				= "~#pgv_lang[fan_chart]# style~<br /><br />Cette option contrôle l'apparence du diagramme.<ul><li><b>1/2</b>&nbsp;&nbsp;&nbsp;Demi-roue (180°)</li><li><b>3/4</b>&nbsp;&nbsp;&nbsp;Trois-quarts de roue (270°) ou «Roue du paon»</li><li><b>4/4</b>&nbsp;&nbsp;&nbsp;Roue entière (360°)</li></ul>";

//-- Hourglass chart-page
$pgv_lang["help_hourglass.php"] 		 = "~#pgv_lang[hourglass_chart]#~<br /><br />Le «sablier» présente les ascendants et les descendants de la personne séléctionnée au sein d'un même diagramme. Ce graphe est une combinaison du diagramme «ascendants» et du diagramme «descendants».<br /><br />La personne sélectionnée est au centre de la page, les descendants listés à gauche, les ascendants listés à droite, chaque génération alignée en colonne, partant de la plus récente pour finir à la plus ancienne.<br /><br />S'il y a une flèche vers le bas sur l'écran sous la personne racine, cliquez dessus pour afficher une liste des membres de la famille proche de la personne racine que vous pouvez utiliser pour naviguer vers le bas dans le tableau. La sélection d'un nom dans cette liste rechargera le graphique avec la personne sélectionnée comme nouvelle personne racine.";

//-- Family Book chart-page
$pgv_lang["help_familybook.php"]		 = "~#pgv_lang[familybook_chart]#~<br /><br />Ce diagramme est très semblable au diagramme Sablier. Il montrera les ascendants et les descendants de l'individu sélectionné sur le même diagramme. Il montrera également les descendants de l'individu dans le même format que le diagramme Sablier.<br /><br />L'individu sélectionné est centré au milieu de la page avec ses descendants énumérés à gauche et ses ascendants à sa droite. Dans cette vue, chaque génération est alignée sur la page en commençant par la première génération et en terminant par la dernière.<br /><br />Chaque descendant de l'individu sélectionné deviendra l'individu principal d'un Sablier supplémentaire, affiché sur la même page. Cette procédure d'affichage est répétée jusqu'au nombre indiqué de générations de descendants affiché.";
$pgv_lang["fambook_descent_help"]   	 = "~#pgv_lang[descent_steps]#~<br /><br />Cette valeur détermine le nombre de générations de descendants de l'individu racine qui sera affiché dans le format Sablier.";

//-- Indilist-page
$pgv_lang["help_indilist.php"]  		 = "~Liste des individus~<br /><br />Cette page permet de lister les individus. Les listes sont présentées par nom de famille et par ordre alphabétique.<br /><br />La liste de noms affichée dépend de :<ul><li>La lettre sur laquelle vous avez cliqué dans l'index alphabétique, ou si vous avez cliqué <b>Tous</b>.</li><li>Si vous avez choisi l'option <b>Afficher tous les noms</b> ou <b>Afficher la liste des noms</b> en bas de page.</li></ul>#pgv_lang[context_help]#";
$pgv_lang["alpha_help"] 				 = "~Index alphabétique~<br /><br />Cliquer une des lettres affichera la liste des noms (ou l'ensemble des personnes) dont le nom de famille commence par cette lettre.<br /><br />Si le choix <b>#pgv_lang[NN]#</b> apparait en avant la dernière position de l'index, cela signifie qu'il y a dans la base de données au moins un individu dont le nom de famille n'est pas connu (c.a.d. vide). Les noms de familles inconnus sont souvent remplacés par un <b>#pgv_lang[qm]#</b>, et ces noms seront reconnus comme <b>#pgv_lang[NN]#</b> par PhpGedView.<br /><br /><b>Note :</b> Les noms de famille enregistrés sous la forme, par exemple, <b>Nn</b>, <b>NN</b>, <b>Inconnu</b>, ou <b>N.N.</b> ne figureront <u>pas</u> dans la liste affichée en cliquant <b>#pgv_lang[NN]#</b>. Ils figureront dans les listes affichées en cliquant <b>N</b> ou <b>I</b> puisqu'il s'agit de leur «initiale». PhpGedView ne peut en effet pas prendre en compte toutes les possibilités d'enregistrer un nom inconnu. Il n'existe pas de convention pour cela.<br /><br />À la fin de l'index, vous avez le choix <b>Tous</b>. Lorsque vous cliquez cette case, vous affichez tous les noms de famille de la base de données.<br /><br /><b>Caractères manquants ?</b><br /><br />Si l'index alphabétique est incomplet, cela signifie qu'il n'y a pas dans la base de données de nom de famille commençant par les lettres manquantes.";
$pgv_lang["name_list_help"] 			 = "~Liste des noms~<br /><br />Cette case affiche une liste des noms ou tous les noms (tous les individus) correspondants à l'initiale que vous avez cliquée dans l'index alphabétique, sauf si vous avez cliqué <b>Tous</b>.<br /><br /> L'affichage de la «Liste des nom» ou de «Tous les noms» dépend du statut <b>Afficher tous les noms / Afficher la liste des noms</b> du lien ci-dessous.";
$pgv_lang["skip_sublist_help"]			= "~Sauter la sous-liste~<br /><br />Le réglage standard est que, après avoir cliqué une lettre de l'index alphabétique, vous obtiendrez une sous-liste avec les noms de famille. Si vous cliquez ce lien, toutes les personnes dont le nom de famille porte la lettre initiale actuellement sélectionnée s'affichent immédiatement. Par la suite, la liste des individus s'affichera directement chaque fois que vous cliquez une nouvelle lettre initiale dans la liste alphabétique.<br /><br />Pour inverser cette action, cliquez #pgv_lang[show_surnames]#.";
$pgv_lang["show_marnms_help"]			= "~#pgv_lang[show_marnms]#~<br /><br />Les pages de liste des personnes et des familles peuvent inclure ou exclure les noms de épouxés. Cette option peut être utile lors de la recherche de personnes ou de familles dont vous ne connaissez que le nom d'épouxé. Les noms épouxés ne peuvent être inclus que s'ils existent déjà dans la base de données.<br /><br />Dans la liste des familles, les noms épouxés sont exclues par défaut. Dans la liste des personnes, la valeur par défaut est définie dans la page de configuration GEDCOM.<br /><br />Lorsque vous modifiez cette option, votre sélection sera mémorisée jusqu'à ce que vous vous déconnectiez ou que votre session se termine.";

//-- Families-page
$pgv_lang["help_famlist.php"]   		 = "~Liste des familles~<br /><br />Cette page permet de lister les familles. Les listes sont présentées par nom de famille et par ordre alphabétique.<br /><br />La sélection dépend de :<ul><li>La lettre de l'index sur laquelle vous avez cliqué,</li><li>du choix entre <b>Afficher la liste des noms</b> ou <b>Afficher tous les noms</b> que vous avez fait.</li></ul>Vous pouvez chercher sur le nom d'époux ou de la femme, les deux sont inclus dans les listes.<br /><br />#pgv_lang[context_help]#";
$pgv_lang["help_family.php"]			 = "~Détail de la famille~<br /><br />Cette page vous présente une vue d'ensemble de la famille que vous avez sélectionnée sur une page précédente.<br /><br />De haut en bas, sont présentés l'époux et ses parents, l'épouse et ses parents, les enfants.<br /><br />La disposition et le contenu des boîtes de personne sont les mêmes que les boîtes que vous connaissez déjà des pages d'ascendance et de descendance.<br /><br />À droite des boîtes de parent, vous pouvez voir une flèche s'il existe plus d'ancêtres dans le fichier. Lorsque vous cliquez cette flèche, vous monterez d'une génération pour vous montrer une nouvelle page de famille avec les parents précédents maintenant répertoriés comme époux et femme.<br /><br />Sur le côté droit de la zone de nom, vous pouvez voir une icône Zoom (loupe) sur laquelle vous pouvez cliquer pour révéler plus de détails sur l'individu.Lorsque vous cliquez le nom, vous serez redirigé vers la page #pgv_lang[indi_info]# de cette personne.<br /><br />Vous trouverez également sur le côté droit un petit menu pour vous diriger vers des pages avec des graphiques ou plus informations. Certains de ces éléments de menu ont également des sous-menus qui apparaîtront lorsque le pointeur de votre souris s'approche de l'élément de menu parent.<br /><br />La zone Informations sur le groupe familial affiche tous les faits et informations connus sur cette famille, tels que le mariage, les objets multimédias et les notes. Dans la zone Informations factuelles, cliquer un lieu vous amènera à la liste des lieux, où toutes les autres familles et individus qui sont connectés à ce lieu sont affichés. En cliquant une date, vous passerez au calendrier du jour, qui affichera tous les événements qui se sont produits ce jour-là et ce mois-là dans l'historique. Les objets multimédias peuvent être cliqués ; cela ouvrira une nouvelle fenêtre dans laquelle l'objet est visualisé. Lorsque vous cliquez la légende de l'image, vous verrez l'image sur la page #pgv_lang[media_list]#. Si vous cliquez un lien Source, les détails de cette source seront affichés sur la page Source.<br /><br />Sous les champs de nom des enfants, vous trouverez le lien <b>Ajouter un enfant à cette famille</b>. À côté des champs de nom des enfants, vous voyez le lien <b>Informations sur le groupe familial</b>. Si vous disposez de suffisamment de droits, vous pouvez modifier, supprimer et ajouter des données et des faits ici.<br /><br />Comme dans la page #pgv_lang[indi_info]#, vous verrez un menu en haut à droite de la page. Les choix de ce menu vous mènent à d'autres pages où vous pouvez obtenir des informations sur cette famille ou effectuer d'autres tâches liées à cette famille.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["add_child_help"] 			 = "~Ajouter un enfant à cette famille~<br /><br />Ce lien vous permet d'ajouter un enfant à cette famille.<br /><br />Ajouter un enfant est simple : cliquez le lien, remplissez les champs proposés par le formulaire, puis sauvegardez.";
$pgv_lang["show_fam_gedcom_help"]   	 = "~#pgv_lang[view_gedcom]#~<br /><br />Ce lien vous permet d'afficher l'information sur la famille, telle qu'elle est enregistrée dans le fichier GEDCOM.";
$pgv_lang["add_fam_clip_help"]  		 = "~Ajout famille au panier~<br /><br />Vous pouvez ajouter tout ou partie de cette information familiale à votre #pgv_lang[clip_cart]#. À la prochaine étape vous pourrez choisir avec précision combien d'informations vous souhaitez ajouter :<ul><li>#pgv_lang[just_family]#</li><li>#pgv_lang[parents_and_family]#</li><li>#pgv_lang[parents_and_child]#</li><li>#pgv_lang[parents_desc]#</li></ul>";
$pgv_lang["show_fam_timeline_help"] 	 = "~Montrer les couples sur le diagramme d'échelle de temps~<br /><br />Quand vous cliquez ce lien, vous passez au diagramme échelle de temps, où tous les événements du couple sont affichés sur une échelle de temps chronologique.";

//-- Source list-page
$pgv_lang["help_sourcelist.php"]		 = "~Liste des sources~<br /><br />Cette page affiche la liste des sources figurant dans la base de données.<br /><br />À la différence des pages «Liste des individus» et «Liste des familles», il n'y a pas d'index alphabétique.<br /><br />Une source peut être une personne, une base de données public, une institution, une ressource Internet, etc... À cause de cette diversité, il n'est pas possible de décider d'un ordre de tri qui soit significatif pour l'ensemble des cas. Néanmoins, PhpGedView tri les sources sur le champ <u>«Titre»</u> de l'enregistrement «Source».<br /><br /><b>SOURCES</b><br />Sans sources, nous ne pouvons pas construire notre base de données. Une source peut être liée à plusieurs individus et/ou plusieurs événements. Par exemple, un contrat de mariage, avec les épouxés, les parents présents ou cités, les témoins, constitue une source possible pour l'ensemble de ces individus. De même un individu peut être lié à plusieurs sources pour chaque événement.";
$pgv_lang["sourcelist_listbox_help"]	= "~Liste des sources~<br /><br />Dans cette boîte, vous voyez les noms des sources telles qu'elles sont stockées dans le GEDCOM.<br /><br />Les noms sont affichés par ordre alphabétique. Lorsque vous cliquez un nom dans la liste, vous accédez à la page Source où une liste est affichée. Cette liste vous montre quelles personnes ou familles sont liées à cette source.";

//-- Sources-page
$pgv_lang["help_source.php"]			= "~Détails d'une source~<br /><br />Les détails de la source sont affichés sur cette page. Les sources sont très importantes pour les chercheurs en généalogie et vous permettront de suivre la piste qu'un autre chercheur a utilisé pour trouver les informations.<br /><br />Vous pouvez voir des informations sur le titre de la source, l'auteur, la publication et le référentiel où la source a été recherché. En raison des nombreux types de sources différentes, certaines sources peuvent contenir plus d'informations que d'autres.<br /><br />Si un objet multimédia tel qu'une numérisation d'un document est connecté à la source, vous pouvez afficher cet objet en cliquant l'objet. Lorsque vous cliquez le nom de l'objet, vous verrez l'objet sur la page #pgv_lang[media_list]#.<br /><br />Après les détails de la source, il y a une liste de toutes les personnes et familles qui sont connectées à cette source. Cela vous permet d'identifier tous les éléments qui ont été obtenus à partir de cette source de données.<br /><br />Lorsque l'administrateur a activé ces fonctionnalités, vous aurez une ou deux icônes de menu supplémentaires sur cette page :<ul><li><b>#pgv_lang[view_gedcom]#</b><br />qui affiche les informations au format GEDCOM.</li><li><b>#pgv_lang[add_to_cart]#</b><br />qui vous permet de stocker ces informations dans votre #pgv_lang[clip_cart]# pour un téléchargement et une importation ultérieurs dans votre propre programme de généalogie.</li></ul><br />#pgv_lang[context_help]#";
$pgv_lang["sources_listbox_help"]   	 = "~Autres enregistrements liés à cette source~<br /><br />Liste des individus et des familles qui sont liés à cette source.<br /><br />Les noms sont listés dans l'ordre alphabétique. En cliquant un nom, vous êtes dirigés sur la page de l'individu ou de la famille correspondant.";
$pgv_lang["show_source_gedcom_help"]	 = "~#pgv_lang[view_gedcom]#~<br /><br />Ce lien vous permet de visualiser l'enregistrement du fichier GEDCOM correspondant à cette source.";
$pgv_lang["add_source_clip_help"]   	 = "~#pgv_lang[add_to_cart]#~<br /><br />En cliquant ce lien vous ajoutez l'enregistrement de cette source à votre panier,  pour pouvoir le télécharger et l'importer plus tard dans votre programme de généalogie.";
$pgv_lang["delete_source_help"] 		 = "~#pgv_lang[delete_source]#~<br /><br />Quand vous cliquez cette option, vous marquez cette source «à supprimer» de la base de données.<br /><br />Qu'est que cela signifie ? Supposons que vous ayez une bonne raison pour vouloir supprimer cette source. En cliquant le lien, vous aurez une demande de confirmation de votre suppresssion. En naviguant sur le site, vous pourrez voir que la suppression n'est pas effective et que la source est toujours utilisable.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["no_mistake"]					= "<b>Ce n'est <u>pas</u> une erreur.</b> Comme toute modification demandée dans la base de données, celle-ci doit être validée par un administrateur, qui peut accepter ou refuser la modification. Ce n'est qu'après que l'administrateur a accepté votre modification que la suppression deviendra définitive. Si il y a un doute sur votre demande, un administrateur prendra contact avec vous.";

//-- Persons per Place-page
$pgv_lang["help_placelist.php"]			= "~Hierarchie des lieux~ (personnes par endroit)<br /><br />Cette page vous montrera une hiérarchie des lieux dans le GEDCOM et quels individus ou familles sont connectés à un emplacement.<br /><br />S'il y a un lien entre un individu ou une famille et un événement à un certain endroit, PhpGedView le trouvera.<br /><br />Les résultats sont affichés dans une liste à deux colonnes, une colonne pour les individus et une pour les familles.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["ppp_default_form_help"]  	 = "~Ordre des lieux~<br /><br /><b>ORDRE PAR DEFAUT</b><br />Ceci signifie qu'il n'y a pas de déclaration de hiérarchie des lieux dans le fichier GEDCOM de cette base de données. L'ordre employé est donc l'ordre par défaut.<br /><br />Si un format avait été déclaré dans le fichier GEDCOM, il aurait été présenté ici et utilisé.";
$pgv_lang["ppp_match_one_help"] 		 = "~Ordre des lieux~<br /><br /><b>ORDRE DU GEDCOM</b><br />La hiérarchie des lieux est celle qui a été déclarée dans le fichier GEDCOM. Cette déclaration remplace l'ordre par défaut.";
$pgv_lang["ppp_numfound_help"]  		 = "~Liens trouvés entre lieux~<br /><br />Le nombre de liens trouvés est affiché ici. Si vous trouvez encore une liste avec des lieux sans liens, vous n'avez pas atteint le niveau le plus bas.<br /><br />Vous pouvez choisir de regarder tous les enregistrements liés à ce lieu ou vous pouvez affiner votre recherche en cliquant un autre lieu.";
$pgv_lang["ppp_levels_help"]			= "~Hierarchie des lieux~<br /><br />Cela montre les niveaux qui sont affichés maintenant. La zone de liste des lieux est en fait une sous-liste du niveau le plus à gauche.<br /><br /><b>EXEMPLE :</b><ul><li>L'ordre par défaut est #pgv_lang[default_form]#.</li><li>Si le niveau actuel est «Sommaire», la boîte listera tous les pays de la base de données.</li><li>Si le niveau actuel est «USA, Sommaire», la boîte listera tous les états des USA</li><li>etc.</li></ul><br />Vous pouvez cliquer un niveau pour revenir en arrière d'une ou plusieurs étapes.";
$pgv_lang["ppp_placelist_help"]			= "~Liste des lieux par niveau~<br /><br />Dans cette liste, vous pouvez voir les emplacements trouvés subordonnés à l'emplacement actuel que vous avez choisi. Si vous n'avez pas encore sélectionné de lieu, vous verrez une liste de tous les lieux de premier niveau (par exemple, pays ou états).<br /><br />Les noms des lieux dans la liste sont cliquables ; cliquer un emplacement fonctionne comme un filtre, vous serez amené au niveau suivant.";
$pgv_lang["ppp_placelist_help2"]		 = "~Liste des lieux~<br /><br />Dans cette liste vous pouvez voir les lieux qui ont été trouvés à ce stade de la recherche.<br /><br />Les noms des lieux qui apparaissent dans cette liste sont cliquables ; cliquer un lieu fonctionne comme un filtre, vous serez amené au niveau inférieur.<br /><br /> Seulement quand vous êtes au niveau supérieur, la liste des noms d'invididus ou de familles n'est pas affichée. À tous les niveaux inférieurs de recherche vous obtiendrez la liste des familles et des individus liés à ce lieu.";
$pgv_lang["ppp_view_records_help"]  	 = "~#pgv_lang[view_records_in_place]#~<br /><br />Cliquer ce lien vous affichera une liste complète des individus et des familles qui ont un événement lié à ce lieu. Quand vous arrivez au niveau de la ville ou du village, l'élement «racine» d'un lieu, la liste des noms sera affichée automatiquement.";
$pgv_lang["ppp_name_list_help"] 		 = "~Liste des noms~<br /><br />Cette case affiche une liste complète des individus et des familles liés à ce lieu.<br /><br />Les noms dans cette liste sont cliquables. Quand vous cliquez un nom, vous obtiendrez la page de détails correspondant à ce nom. Quand vous cliquez un lieu en haut de cette liste, vous modifiez le lieu sélectionné.";

//-- Multimedia-page
$pgv_lang["help_medialist.php"] 		 = "~Liste des objets multimédia~<br /><br />Cette page présente la liste des objets Multimédia contenus dans cette base de données.<br /><br />Pour chacun, vous pouvez voir le titre ou le nom de fichier, les noms des individus et/ou des familles qui y sont raccordés, ainsi que les notes le concernant.<br /><br />En cliquant le titre ou la miniature, vous ouvrez le média dans le visualisateur de PhpGedView ou dans celui spécifié dans votre configuration navigateur.<br /><br />Quand vous cliquez le lien individu ou famille, vous ouvrez la page correspondante.";

//-- Upload Media-page
$pgv_lang["help_uploadmedia.php"]   	 = "~Chargement des fichiers multimédia~<br /><br />Charger les fichiers média est simple. Voici ce qu'il faut savoir :<br /><br /><b>Miniatures</b><br />Les miniatures doivent avoir une largeur d'environ 100 px. La miniature <u>doit</u> avoir exactement le même nom que le média principal. Si votre système peut générer les miniatures automatiquement, une information est affichée sur la page de chargement.<br /><br /><b>Chargement</b><br />Les fichiers sont chargés automatiquement dans le répertoire <b>#GLOBALS[MEDIA_DIRECTORY]#</b> pour le média principal, et dans  <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> pour les miniatures.<br /><br />#pgv_lang[readme_help]#";

//-- Anniversaries-page
$pgv_lang["help_calendar.php"]  		 = "~#pgv_lang[anniversary_calendar]#~<br /><br /><ul><li><a href=\"#calendar_general\"><b>Informations générales</b></a></li><li><a href=\"#calendar_day\"><b>#pgv_lang[day]#</b></a></li><li><a href=\"#calendar_month\"><b>#pgv_lang[month]#</b></a></li><li><a href=\"#calendar_year\"><b>#pgv_lang[year]#</b></a></li><li><a href=\"#calendar_show\"><b>#pgv_lang[show]# / #pgv_lang[showcal]#</b></a></li><li><a href=\"#calendar_sex\"><b>#pgv_lang[sex]#</b></a></li><li><a href=\"#calendar_event\"><b>Evènement</b></a></li><li><a href=\"#calendar_button\"><b>Boutons Vue par jour / Vue mensuelle / Vue annuelle</b></a></li><li><a href=\"#calendar_tip\"><b>Tip</b></a></li></ul><br /><a name=\"calendar_general\"></a>Le #pgv_lang[anniversary_calendar]# montre les individus et les familles qui sont liées à un événement à un certain jour ou mois ou pendant une période donnée. Un système avancé de filtrage sélectionne pour vous la bonne date, la bonne période et les événements.<dl><dt><b>Vue <a href=\"#calendar_day\">Jour</a></b></dt><dd>Ceci affiche les événements pour un certain jour, indépendamment de l'année sélectionnée. Le résultat sera une liste simple mentionnant le nom des individus ou des familles, ou une liste sur deux colonnes avec les individus d'un côté et les familles de l'autre.</dd><dt><b>Vue <a href=\"#calendar_month\">Mensuelle</a></b></dt><dd>Dans ce calendrier, les noms d'individus et de familles sont affichés par jour. Le calendrier est affich avec l'année sélectionnée dans la case année. Tous les événements qui se sont produits dans le passé jusqu'à cette année sont affichés.<br /><br />En combinaison avec cette option <a href=\"#calendar_show\"><b>#pgv_lang[recent_events]#</b></a>, vous obtiendrez une vue réaliste du calendrier de vos ascendants.</dd><dt><b>Vue <a href=\"#calendar_year\">Annuelle</a></b></dt><dd>Cette vue affiche les événements survenus pour une année donnée ou pour un nombre d'années donné. Le résultat affiché sera une liste des noms des individus ou des familles, ou une liste sur deux colonnes avec les individus d'un côté et les familles de l'autre.</dd></dl>Le jour et le mois en cours sont mis en surbrillance dans le calendrier.<br /><br />Tous les noms et les dates sont cliquables. Quand vous cliquez un nom, vous obtiendrez la page de détails correspondante. En cliquant une date, vous passerez en mode «Aujourd'hui» ou «Année», ce qui affichera tous les événements pour le jour ou le mois correspondant à la date sélectionnée.<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_day\"></a> #pgv_lang[annivers_date_select_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_month\"></a> #pgv_lang[annivers_month_select_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_year\"></a> #pgv_lang[annivers_year_select_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_show\"></a> #pgv_lang[annivers_show_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_sex\"></a> #pgv_lang[annivers_sex_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_event\"></a> #pgv_lang[annivers_event_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_button\"></a> #pgv_lang[day_month_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_tip\"></a> #pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"]	= "~Sélection du jour~<br /><br />Le niveau le plus fin de la sélection de date est le <b>jour</b>. Sa fonction est évidente, vous sélectionnez un <b>jour</b> du mois.<br /><br />Le résultat d'un clic sur un certain jour varie selon que vous êtes en mode <b>Jour</b> ou <b>Mois</b>.<br /><dl><dt><b>Mode jour</b></dt><dd>Dans ce mode, vous cliquez sur un jour, l'écran s'actualisera et la liste de ce jour s'affichera. Toutes les autres sélections telles que le jour, l'année et les événements resteront inchangées.</dd><dt><b>Mode mois</b></dt><dd>Vous avez le calendrier d'un certain mois à l'écran. Vous cliquez sur un jour et l'écran s'actualisera, mais vous verrez toujours le mois que vous aviez à l'écran auparavant. La raison en est que vous pouvez toujours décider de sélectionner un autre mois, année ou événement avant de cliquer <b>#pgv_lang[viewday]#</b> ou <b>#pgv_lang[viewmonth]#</b>.</dd></dl><br />À la fin de la ligne Jour, vous verrez un <b>Lien rapide</b> avec la date du jour. Cliquez sur ce <b>Lien rapide</b> pour afficher la liste d’aujourd’hui en mode <b>Jour</b>, que vous soyez en mode <b>Mois</b> ou en mode <b>Jour</b>.";
$pgv_lang["annivers_month_select_help"]	= "~Sélection du mois~<br /><br />La ligne du milieu du tableau des sélecteurs est le sélecteur <b>Mois</b>. Sa signification est évidente: vous sélectionnez un <u>mois</u>.<br /><br />Le résultat d'un clic sur un certain mois varie selon que vous êtes en mode <b>Jour</b> ou <b>Mois</b>.<br /><dl><dt><b>Mode jour</b></dt><dd>Dans ce mode, vous cliquez sur un mois, l'écran s'actualisera et la liste de ce mois s'affichera. Toutes les autres sélections telles que le jour, l'année et les événements resteront inchangées.</dd><dt><b>Mode mois</b></dt><dd>Lorsque vous avez le calendrier à l'écran et que vous cliquez sur un mois dans la ligne <b>Mois</b>, le calendrier de ce nouveau mois s'affiche.</dd></dl><br />À la fin de la ligne Mois, vous verrez un <b>Lien rapide</b> avec le mois et l'année d'aujourd'hui. Cliquez sur ce <b>Lien rapide</b> pour afficher la liste du mois en mode <b>Mois</b>, que vous soyez en mode <b>Mois</b> ou en mode <b>Jour</b>.";
$pgv_lang["annivers_year_select_help"]  = "~Saisie année~<br /><br />Cette case vous permet de changer l'année du calendrier.<br /><br /><b>Fonctionnalités avancées</b> pour <b>#pgv_lang[viewyear]#<dl><dt>Plus d'un an :</b></dt><dd>Vous pouvez chercher des dates sur une période recouvrant plusieurs années.<br /><br />Les dates sont inclusives, c'est à dire que la sélection part du 1er janvier de la première année jusqu'au 31 décembre de la dernière année. Par exemple :<br /><br /><b>1992-5</b>&nbsp;&nbsp;&nbsp;pour tous les événements de1992 à 1995.<br /><b>1972-89</b>&nbsp;&nbsp;&nbsp;tous les événements de 1972 à 1989.<br /><b>1610-759</b>&nbsp;&nbsp;&nbsp;tous les événements de 1610 à 1759.<br /><b>1880-1905</b>&nbsp;&nbsp;&nbsp;tous les événements de 1880 à 1905.<br /><b>880-1105</b>&nbsp;&nbsp;&nbsp;tous les événements de 880 à 1105. Pour voir tous les événements d'une décennie ou d'un siècle donné, vous pouvez utiliser <b>#pgv_lang[qm]#</b> à la place des derniers chiffres. Par exemple, <b>197?</b>&nbsp;&nbsp;&nbsp;our tous les événements de 1970 à 1979 ou <b>16??</b>&nbsp;&nbsp;&nbsp;pour tous les événements de 1600 à 1699.</dd></dl>";
$pgv_lang["annivers_show_help"] 		 = "~Montrer les événements de ...~<br /><br />Les options suivantes sont disponibles :<br /><ul><li><b>Toutes les personnes</b><br />Avec cette option, tous les individus et toutes les familles figurant dans la base de données sont affichés.</li><li><b>Evènements récents (&lt; de 100 ans)</b><br />Les événement vieux de plus de 100 ans ne seront pas affichés.</li><li><b>Personnes vivantes seulement</b><br />Sauf si l'administrateur a autorisé à ce que les personnes vivantes soient visibles de tous, vous ne pouvez sélectionner cette option sans être connecté.<br /><br />Avec cette option, seules les personnes vivantes seront sélectionnées.</li></ul>Quand vous cliquez, les événements correspondants à votre sélection sont affichés.<br /><br />Les sélections du jour, du mois et de l'année restent inchangés.";
$pgv_lang["annivers_sex_help"]  		 = "~Sélecteur de sexe~<br /><br />Quand vous êtes connecté ou lorsque l'administrateur n'a pas désactivé l'option de protection des informations privées, vous pouvez sélectionner l'une de ces options :<ul><li><b>Tous</b> icon<br />C'est la valeur par défaut. Les événements de tous les individus et de toutes les familles sont affichés.</li><li><b>Masculin</b> icon<br />Seuls les événements des individus masculins sont affichés. Seuls les membres masculins des familles sont affichés avec les événements de cette famille.</li><li><b>Féminin</b> icon<br />Seuls les événements des individus féminins sont affichés. Seuls les membres féminins des familles sont affichés avec les événements de cette famille.</li></ul>Quand vous cliquez une option, les événements sélectionnés sont affichés.<br /><br />La configuration du jour, du mois et de l'année, tels que les modes <b>Jour</b> ou <b>Mensuelle</b>, demeure inchangée.";
$pgv_lang["annivers_event_help"]		 = "~Sélecteur d'événement~<br /><br />Ici vous choisissez d'afficher tous les événements pour les individus ou les familles affichées ou juste une sélection d'événements. Vous ne pouvez pas sélectionner plus d'une catégorie d'événements.<br /><br />Quand vous cliquez une option, les événements sélectionnés sont affichés.<br /><br />La configuration du jour, du mois et de l'année, tels que les modes <b>Jour</b> ou <b>Mensuelle</b>, demeure inchangée.";
$pgv_lang["annivers_tip_help"]  		 = "~Tip~<br /><br />Ajustez le sélecteur de date sur n'importe quelle date dans le passé.<br /><br />Quand vous cliquez l'un des boutons de vue, vous pourrez afficher une liste ou un calendrier pour cette date.  Tous les âges, anniversaires, etc... ont été recaculés à partir de la date déterminée dans le sélecteur de date. Vous pouvez maintenant voir le calendrier ou une liste que vos ancêtres auraient pu voir il y a des années.";
$pgv_lang["day_month_help"] 			 = "~Boutons vue jour / vue mensuelle / vue annuelle~<br /><br /><ul><li><b>Vue jour</b> montrera les événements de la date choisie dans une liste. Toutes les années sont balayées, ainsi seuls le jour et le mois sont indiqués ici. Changer l'année n'aura aucun effet.  Vous pouvez réduire la liste en choisissant l'option <b>Années récentes</b> ou <b>Individus vivants</b>.<br /><br />L'âge dans la liste sera calculé depuis l'année en cours.</li><li><b>Vue mensuelle</b> affiche un calendrier du mois et de l'année choisis. Ici vous pouvez réduire la liste en choisissant l'option <b>années récentes</b> ou <b>Individus vivants</b>.<br /><br />Vous obtiendrez une impression réaliste du calendrier que vos ancêtres pouvaient regarder chaque matin affiché sur le mur de la cuisine en choisissant une année dans le passé et en la combinant avec <b>Années récentes</b>. Tous les âges sur le calendrier sont affichés en fonction de l'année affichée dans le sélecteur d'année.</li><li><b>Vue annuelle</b> affichera une liste des événements survenus dans l'année sélectionnée.  Ici vous pouvez réduire la liste en choisissant l'option <b>Années récentes</b> ou <b>Individus vivants</b>.<br /><br />Vous pouvez afficher des événements pour une période d'années donnée.  Indiquez simplement l'année de début et l'année de fin de cette période, avec un trait d'union <b>-</b> entre les deux années.  Exemple :<br /><b>1992-4</b> pour afficher tous les événements survenus entre 1992 et 1994<br /><b>1976-1984</b> pour afficher tous les événements survenus entre 1976 et 1984<br /><br />Pour voir tous les événements d'une décennie ou d'un siècle donné, vous pouvez utiliser <b>#pgv_lang[qm]#</b> à la place des derniers chiffres. Par exemple, <b>197?</b> pour tous les événements de 1970 à 1979 ou <b>16??</b> pour tous les événements de 1600 à 1699.</li></ul>Quand vous voulez <b>modifier l'année</b> vous <b>devez</b> cliquer l'un de ces trois boutons.  Tous les autres réglages demeurent inchangés.";
		
//-- Clippings Cart-page
$pgv_lang["help_clippings.php"]			= "~#pgv_lang[clippings_cart]#~<br /><br />L'#pgv_lang[clip_cart]# vous permet de prendre des extraits («coupures») de cet arbre généalogique et de les regrouper dans un seul fichier pour téléchargement et importation ultérieure dans votre propre programme de généalogie. Le fichier téléchargeable est enregistré au format GEDCOM.<br /><ul><li>Comment prendre des coupures ?<br />C'est vraiment simple. Chaque fois que vous voyez un nom cliquable (individu, famille ou source), vous pouvez accéder à la page Détails de ce nom. Là, vous verrez l'option <b>#pgv_lang[add_to_cart]#</b>. Lorsque vous cliquez ce lien, plusieurs options de téléchargement vous seront proposées.</li><li>Comment télécharger ?<br />Une fois que vous avez des articles dans votre panier, vous pouvez les télécharger simplement en cliquant <b>Télécharger maintenant</b>. Suivez les instructions et les liens.</li></ul>";
$pgv_lang["clip_download_help"]			= "~#pgv_lang[download_now]#~<br /><br />Lorsque vous cliquez ce lien, vous serez redirigé vers la page suivante. Si l'une des coupures de presse de votre panier fait référence à des articles multimédias, ces articles seront également affichés sur cette page.<br /><br />Suivez les instructions.";
$pgv_lang["empty_cart_help"]			= "~#pgv_lang[empty_cart]#~<br /><br />Lorsque vous cliquez ce lien, votre #pgv_lang[clip_cart]# sera totalement vidé.<br /><br />Si vous ne voulez pas supprimer toutes les personnes, familles, etc. du #pgv_lang[clip_cart]#, vous peut supprimer des éléments individuellement en cliquant <b>Supprimer</b> dans les zones Nom. Il n'y a <u>aucun</u> dialogue de confirmation lorsque vous cliquez l'un de ces liens ; la suppression demandée a lieu immédiatement.";
$pgv_lang["add_by_id_help"]				= "~Ajouter au panier par id~<br /><br />Cette case vous permet de saisir le numéro d'identification d'une personne afin qu'elle puisse être ajoutée au #pgv_lang[clip_cart]#. Une fois ajouté, des options vous seront proposées pour lier les relations de cette personne à votre #pgv_lang[clip_cart]#.<br /><br />Si vous ne connaissez pas le numéro d'identification, vous pouvez effectuer une recherche par nom en appuyant l'icône Personne à côté du bouton Ajouter.";
$pgv_lang["zip_help"]   				 = "~Contenu du panier au format zip~<br /><br />Sélectionnez cette option pour sauvegarder le contenu de votre panier dans un format compressé (fichier ZIP).  Pour plus d'informations sur le format ZIP, vous pouvez visiter <a href=\"https://fr.wikipedia.org/wiki/ZIP_(format_de_fichier)\" target=\"_blank\">https://fr.wikipedia.org/wiki/ZIP_(format_de_fichier)</a>.";
$pgv_lang["include_media_help"] 		 = "~Inclure des médias~<br /><br />Choisissez cette option pour inclure les fichiers média liés aux enregistrements d'invidus sélectionnés dans votre panier. En choisissant cette option, les fichiers média seront automatiquement zippés pendant le téléchargement.";
$pgv_lang["clip_cart_help"] 			 = "~#pgv_lang[clippings_cart]#~<br /><br />Cette case montre le contenu de votre panier.<ul><li>Les <i>en-têtes</i> de colonnes indiquent le type de données sélectionnées, qui peuvent être des Individus (INDI), des familles (FAM), des Sources (SOUR), un dépôt d'archives (REPO), une note (NOTE), ou un média (OBJE) ; chacun est représenté par sa propre icône.</li><li>La colonne <i>ID</i> affiche le numéro ID pour chaque enregistrement de chaque type d'objets.</li><li>La colonne <i>Nom / Description</i> donne soit le nom de famille ou de l'individu ou une description de l'un ou l'autre.</li></ul>Le bouton de suppression supprimera cet enregistrement du panier. <b>Une confirmation de cette suppression ne vous sera pas demandé.</b>";
		
//-- GEDCOM Edit Utility
$pgv_lang["show_changes_help"]  		 = "~#pgv_lang[review_changes]#~<br /><br />Quand vous voyez ce message, il peut signifier deux choses :<ol><li>Quelqu'un a réalisé des modifications dans le GEDCOM<br />Des enregistrements peuvent avoir été ajoutés, supprimés ou modifiés.</li><li>Les modifications n'ont pas encore été validées par l'administrateur.<br />Une fois que les modifications sont acceptées ou rejetées, vous ne voyez plus ce message.</li></ol>Vous pouvez voir les modifications qui ont été réalisées en cliquant le lien. Si la fiche n'est pas correcte (erreurs de saisie, mauvaises informations), SVP contactez l'administrateur.";

//-- Search-page
$pgv_lang["help_search.php"]			 = "~La page de recherche~<br /><br />Bien que cette page soit très simple d'utilisation, nous avons mis à votre disposition un moteur de recherche particulièrement puissant et complexe. La plupart des logiciels de généalogie vous permettent seulement de faire une recherche sur le nom de l'individu. PhpGedView vous permet de rechercher presque n'importe quoi.<br /><br />La case de recherche sur le côté gauche de l'écran est identique à la case de recherche située en en-tête de chaque page du site.<br /><br />Si vous recherchez des individu en relation avec une année donnée, saisissez simplement l'année. Le programme trouvera tous les liens pour vous.<br /><br />Vous recherchez un nom ou un lieu ?  Saisissez simplement son nom ou le lieu, en entier ou seulement une partie de celui-ci, et PhpGedView fera le reste.<br /><br /><b>Méthode de recherche de Soundex</b><br />Avec la case de recherche du côté droit de l'écran, vous pouvez rechercher des noms d'individus ou de lieux, même si vous n'en connaissez pas l'orthographe précise.<br /><br />Lorsqu'il y a plusieurs bases de données généalogiques sur un même serveur et que l'administrateur a permis la commutation entre elles, votre recherche renverra des résultats pour toutes les bases.<br /><br />Vous trouverez plus d'aide au sujet de ces outils de recherche en cliquant <b>#pgv_lang[qm]#</b> au dessus de chacune des cases.";
$pgv_lang["search_enter_terms_help"]	 = "~#pgv_lang[enter_terms]#~<br /><br />Vous pouvez faire une recherche par date, nom, prénom, lieu, etc.<br /><br /><b>Jokers</b><br />Les jokers (comme * ou ?), ne sont pas autorisés, mais le programme assume automatiquement leur présence.<br /><br />Supposons que vous avez saisi : «<b>Mar</b>» Le résultat donnera :<div style=\"padding-left: 30px;\">Jean-<b>Mar</b>c Durand<br /><b>Mar</b>cel Lebrun<br />Paul <b>Mar</b>tin<br />une personne née à <b>Mar</b>seille<br />etc..</div><br /><b>Dates</b><br />En entrant une date, vous obtiendrez la liste de toutes les personnes liées à cette date.<br /><br /><b>1950</b>, par exemple, vous donnera la liste des personnes, nées en 1950, ou mariées, ou décédées, ou....tout autre événement de 1950.<br /><br />Avec <b>4 Dec</b>, toutes les personnes en rapport avec le 4 décembre de n'importe quelle année. Mais aussi les événements du 14 et du 24 décembre. Encore une fois, les jokers ne sont pas nécessaires.<br /><br /><b>Dates exactes</b><br />Attention, le programme cherche les dates au format interne GEDCOM. Si, par exemple, vous souhaitez rechercher un événement le 14 décembre, vous devez taper <b>14&nbsp;dec</b> car c'est ainsi que la date est stockée dans la base de données.<br /><br />Si vous tapez <b>dec&nbsp;14</b>, le résultat pourrait être une personne connectée à un événement le 08&nbsp;<b>dec</b>ember&nbsp;18<b>14</b>. Encore une fois, les résultats peuvent être surprenants.<br /><br />Vous pouvez utiliser des expressions régulières dans votre recherche si vous les connaissez. Par exemple, si vous vouliez trouver toutes les personnes qui ont des dates dans le 20e siècle, vous pouvez entrer la recherche <b>19[0-9][0-9]</b> et vous obtiendrez tous les personnes avec des dates de 1900 à 1999.<br /><br />#pgv_lang[soundex_search_help]#<br /><br />#pgv_lang[search_replace_help]#<br /><br />Si vous avez besoin de plus d'aide avec ce système de recherche, veuillez nous en informer, afin que nous puissions également étendre ce fichier d'aide.";
$pgv_lang["search_replace_help"]		 = "~#pgv_lang[search_replace]#~<br /><br />Ici vous pouvez rechercher une faute d'orthographe ou toute autre information imprécise et la remplacer avec l'information correcte.<br /><br /><b>Rechercher</b><br />Cet outil effectue la recherche juste comme une <a href=\"help_text.php?help=search_enter_terms_help\">recherche normale</a>.<br /><br /><b>Remplacer</b><br />Tous les termes trouvés à partir de la recherche sont remplacés par le terme de remplacement dans la base de données.<br /><br /><b>Par exemple...</b><br />Supposons que vous ayez mal épelé le nom de votre grand-père Michael. Vous avez accidentellement écrit «Micheal»<br /><br />Vous entrerez <b>Micheal</b> dans la case de recherche, et <b>Michael</b> dans la case de remplacement.<br />Toutes les occurences de «Micheal» seront remplacées par «Michael»<br /><br /><b>Recherche de...</b><br />Choisissez l'étendue de votre recherche. Vous pouvez limiter la recherche aux noms ou aux endroits, ou n'appliquer aucune limite (Rechercher tout).  L'option <i>#pgv_lang[search_place_word]#</i> n'éffectuera la recherche que sur le mot entier dans les champs spécifiés par la recherche. Cela signifie qu'en recherchant <i>UT</i> vous n'obtiendrez que <b>UT</b> et non pas <i>UT</i> dans un autre mot comme Connectic<b>ut</b>.<br /><br />Ne soyez pas inquiet si vous remplaciez accidentellement un mot. Cliquez simplement «Accepter/Rejeter les modifications» en bas de la page pour valider vos modifications ou les rejeter.";
$pgv_lang["soundex_search_help"]		 = "~#pgv_lang[soundex_search]#~<br /><br />Soundex est une méthode de codage des mots selon leur prononciation. Cela permet de rechercher des noms d'individus ou de lieux dans la base de données dont vous ne connaissez pas l'orthographe précise.  PhpGedView supporte deux algorithmes différents, chacun founissant des résultats différents.<ul><li><b>#pgv_lang[search_russell]#</b><br />Cette méthode, brevetée en 1918 par Russel, est très simple et peut-être réalisée à la main.<br /><br />L'algorithme simple n'est pas bien adapté aux noms qui étaient à l'origine dans des langues autres que l'anglais, et même avec des noms anglais les résultats sont très surprenants. Par exemple, une simple recherche Soundex pour <b>Smith</b> retournera pas seulement <b>Smith, Smid, Smit, Schmidt, Smyth, Smithe, Smithee, Schmitt</b>, tous des variations du nom <b>Smith</b>, mais également <b>Smead, Sneed, Smoote, Sammett, Shand,</b> et <b>Snoddy</b>.</li><br /><li><b>#pgv_lang[search_DM]#</b><br />Cette méthode développée en 1985, est plus complexe que la méthode simple et n'est pas réalisable à la main.<br /><br />Une recherche Soundex utilisant cette méthode produira de meilleurs résultats.</li></ul>Pour plus de détails sur ces deux méthodes Soundex, visitez la page : <a href=\"http://www.jewishgen.org/infofiles/soundex.html\" target=_blank><b>Jewish Genealogical Society</b></a>";
$pgv_lang["search_exclude_tags_help"]   = "~#pgv_lang[search_tagfilter]#~<br /><br />Le choix <b>#pgv_lang[search_tagfon]#</b> conduira la fonction de recherche à ignorer les balises (tags) GEDCOM suivantes :<div style=\"padding-left:30px;\"><b>_PGVU</b> - Dernière modification effectuée par<br /><b>CHAN</b> - Date de la dernière modification<br /><b>FILE</b> - #factarray[FILE]#<br /><b>FORM</b> - #factarray[FORM]#<br /><b>TYPE</b> - #factarray[TYPE]#<br /><b>SUBM</b> - #factarray[SUBM]#<br /><b>REFN</b> - #factarray[REFN]#</div><br />En complément de ces balises ignorées éventuellement, la fonction de recherche exclut automatiquement les balises suivantes : <div style=\"padding-left:30px;\"><b>_UID</b> - #factarray[_UID]#<br /><b>RESN</b> - #factarray[RESN]#</div>";
$pgv_lang["search_include_ASSO_help"]   = "~#pgv_lang[search_asso_label]#~<br /><br />Cette option permet à PhpGedView d'afficher toutes les personnes enregistrées comme ayant une association avec cette personne ou cette famille.<br /><br />Exemple : Supposons que la personne <b>A</b> est le parrain de la personne <b>B</b>. Le lien de parenté est enregistrée dans l'enregistrement de la personne <b>B</b> en utilisant une balise ASSO. Aucune balise correspondante n'existe dans l'enregistrement de la personne <b>A</b>.<br /><br />Lorsque cette option est paramétrée à <b>#pgv_lang[yes]#</b> et que la liste des les résultats de la recherche contient <b>B</b>, <b>A</b> sera inclus automatiquement à cause de la présence de la balise ASSO dans l'enregistrement GEDCOM de <b>B</b>. Toutefois, si la liste des les résultats de la recherche contient <b>A</b>, <b>B</b> ne sera pas inclus automatiquement puisqu'il n'y a pas de balise ASSO dans l'enregistrement de la personne <b>A</b>.";

//-- Advanced Search-page
$pgv_lang["advanced_search_help"] = "~#pgv_lang[advanced_search]#~<br /><br />Cette fonction vous permet de rechercher les champs spécifiés des enregistrements de personnes dans votre base de données généalogique.<br /><br />Lorsque vous cliquez sur le bouton <b>#pgv_lang[search]#</b>, tous les champs pour lesquels des valeurs ont été saisies seront examinés et les enregistrements de votre base de données généalogique qui répondent à <u>tous</u> les critères seront renvoyés. Alors que la boîte de dialogue initiale propose certains des champs les plus courants, en bas de la boîte de dialogue, vous pouvez cliquer sur <b>#pgv_lang[more_fields]#</b> pour développer la liste des champs à examiner.<br /><br />~Champs contenant des dates~<br />Les recherches avancées sont basées sur les années. Ainsi, contrairement à la procédure «&nbsp;#pgv_lang[search_general]#&nbsp;» qui peut accepter une date sans année, tous ces champs nécessitent au moins l'année, mais peuvent également accepter des spécifications complètes de jour, de mois et d'année. Par exemple, il n'est pas possible de rechercher quelque chose qui s'est produit en avril de n'importe quelle année.<br /><br />Chaque champ de recherche de date possède également un modificateur, ce qui vous permet de rechercher la date <b>#pgv_lang[exact]#</b> telle que saisie, ou une date relative avec <b>+/-</b> un nombre d'années. En saisissant une année dans le champ de date, puis en choisissant un modificateur, puis en cliquant sur le bouton <b>#pgv_lang[search]#</b>, vous obtiendrez une liste de personnes connectées à cette année ou à cette plage d'années.<br /><br />Si, par exemple, vous saisissez «&nbsp;APR 1950&nbsp;» dans le champ de date de naissance qui contient le modificateur <b>#pgv_lang[exact]#</b>, le résultat sera toutes les personnes dont l'événement s'est produit uniquement en avril 1950. Chaque champ de date recherchera les dates spécifiques à cet événement. L'ajout d'un modificateur <b>+/- 10</b> renverrait les dates comprises entre le 1er avril 1940 et le 31 mars 1960. Les autres modificateurs modifieraient de la même manière les plages d'années de recherche. En saisissant simplement une année, par exemple «&nbsp;1950&nbsp;», la recherche renverra tous les événements de l'année spécifiée.<br /><br /><b>Format de date pour les recherches</b><br />Vous ne pouvez pas utiliser de caractères génériques ni d'expressions régulières dans vos champs de recherche de date. L'ordre du jour, du mois, de l'année et la casse ne sont pas pertinents. «&nbsp;jj MMM aaaa&nbsp;» a la même signification que «&nbsp;aaaa MMM jj&nbsp;». Cependant, si vous souhaitez rechercher un événement le 14 décembre 1926, vous devez le saisir comme «&nbsp;14 DEC 1926&nbsp;» car c'est ainsi que la date est stockée dans la base de données. Pour rechercher une date parmi plusieurs événements (c'est-à-dire naissances, décès, mariages, Bar Mitzvah, scellements LDS, etc.) ou si seul le jour ou le mois est connu, il est préférable d'utiliser la fonction «&nbsp;#pgv_lang[search_general]#&nbsp;».<br /><br />~Champs contenant des noms~<br />Les champs <b>#pgv_lang[given_name]#</b> et <b>#pgv_lang[surname]#</b> permettent de spécifier les différentes parties d'un nom à rechercher. Cela permet de filtrer facilement les noms qui pourraient être à la fois des prénoms ou des noms de famille, par exemple «&nbsp;Terry&nbsp;» ou «&nbsp;Henry&nbsp;».<br /><br />Les champs de noms disposent également d'un modificateur qui permet de distinguer ce qui est saisi de ce qui est recherché. Les modificateurs incluent&nbsp;:<ul><li><b>#pgv_lang[exact]#</b>&nbsp;&nbsp;spécifie une recherche sensible à la casse dans le champ complet pour le texte exact saisi. La recherche est également sensible à tous les caractères intégrés, espacements, etc. Par exemple, si le champ contient un espace mais que l'enregistrement dans la base de données en contient deux à la même position, l'enregistrement ne sera pas trouvé.</li><li><b>#pgv_lang[begins_with]#</b>&nbsp;&nbsp;spécifie une recherche insensible à la casse pour les enregistrements dont un nom commence par ce qui est dans le champ. Si un champ de nom contient plusieurs noms (comme le prénom et le deuxième prénom), la correspondance sera effectuée avec le début de chaque partie du nom séparée par un espace.</li><li><b>#pgv_lang[contains]#</b>&nbsp;&nbsp;spécifie une recherche insensible à la casse pour les enregistrements où les données complètes saisies dans le champ seront recherchées n'importe où dans le texte du nom de l'enregistrement cible. Par exemple, en plaçant un seul espace dans le champ de recherche <b>#pgv_lang[given_name]#</b> avec le modificateur <b>#pgv_lang[contains]#</b>, vous trouverez tous les enregistrements qui doivent avoir un prénom et au moins un deuxième prénom ou une initiale.</li><li><b>#pgv_lang[sounds_like]#</b>&nbsp;&nbsp;spécifie une recherche insensible à la casse pour les enregistrements qui sont similaires à ce qui se trouve dans le champ. Cela vous permet de rechercher dans la base de données des noms et des lieux lorsque vous ne savez pas précisément comment ils sont écrits.</li></ul><br />~Champs sans modificateurs~<br />Les entrées dans les champs sans modificateurs sont des recherches insensibles à la casse. Le texte saisi sera recherché n'importe où dans le texte de l'événement de l'enregistrement cible.";

//-- Individual Information-page
$pgv_lang["help_individual.php"]		 = "~Page #pgv_lang[indi_info]#~<br /><br />Tous les détails d'un individu sont affichés sur cette page.<br /><br />S'il existe une image disponible, vous la verrez sur le côté gauche supérieur. Vous verrez le nom de l'individu à côté de l'image.<br /><br />Les noms peuvent être liés à des notes ou des sources. Si un quelconque de ces noms a des notes ou des sources, vous les verrez énumérées sous les noms auxquels elles sont liées.<br /><br />Un individu peut avoir un AKA (un surnom ou un pseudo sous lequel il est connu par ailleurs). Si c'est le cas, il sera affiché.<br /><br />Si vous y êtes autorisé, vous verrez également pour cet individu <b>Editer</b> et <b>Supprimer</b> à côté de l'individu édité.<br /><br />Sur cette page vous voyez des onglets pour <b>#pgv_lang[personal_facts]#</b>, <b>#pgv_lang[notes]#</b>, <b>#pgv_lang[ssourcess]#</b>, <b>#pgv_lang[media]#</b>, et <b>#pgv_lang[relatives]#</b>.  Ces onglets vous permettent d'accéder à toutes les informations concernant cet individu enregistrées dans la base de données.<ul><li><b>#pgv_lang[personal_facts]#</b>&nbsp;&nbsp;&nbsp;affiche tous les événements et détails à propos de l'individu et tous les événements concernant ses mariages. En cliquant n'importe quelle date dans ce tableau, vous serez transféré à #pgv_lang[anniversary_calendar]# pour cette date, de sorte que vous puissiez voir d'autres événements qui se produit le même jour. En cliquant un des liens, vous serez positionné sur l'arbre généalogique à partir duquel vous pourrez visualiser d'autres individus qui ont ajouté des événements au même endroit. Pour les mariages et les autres événements familiaux, le nom du conjoint de l'individu est affiché de sorte que vous puissiez visualiser le conjoint ainsi que sa famille grâce aux liens existants.</li><li><b>#pgv_lang[notes]#</b>&nbsp;&nbsp;&nbsp;affiche toutes les notes générales relatives à cet individu.</li><li>L'onglet <b>#pgv_lang[ssourcess]#</b>&nbsp;&nbsp;&nbsp;affiche toutes les sources <u>générales</u> pour cet individu. Ces sources <u>ne sont pas</u> liées aux événements de l'individu, ni même aux noms de l'individu : elles sont associées à l'individu lui-même (ID).  En cliquant le titre de la source, vous obtiendrez des informations plus détaillées sur celle-ci ainsi que la liste des autres individus rattachés à cette source.</li><li><b>#pgv_lang[media]#</b>&nbsp;&nbsp;&nbsp;affiche l'ensemble des images ainsi que les autres média rattachés à cet individu. En cliquant la vignette de l'image, une vue plus grande de l'image sera affichée. En cliquant la légende de l'image, l'image sera affichée sur la page #pgv_lang[media_list]#.</li><li><b>#pgv_lang[relatives]#</b>&nbsp;&nbsp;&nbsp;liste les parents, les frères et sœurs et les enfants de l'individu ainsi que les conjoints de l'individu et les enfants qu'il a eu avec ces conjoints. Ces individus sont listés dans une case similaire aux diagrammes que vous avez déjà vues.</li></ul>Du côté droit de l'écran vous trouverez une case avec des liens.  Plusieurs des liens dans la case sont identiques aux liens dans le menu. Par exemple, en cliquant <b>#pgv_lang[pedigree_chart]#</b> situé du côté des liens vous affichera l'arbre des ascendants de cet individu. La différence avec les liens du menu tient au fait qu'en utilisant le menu, <b>#pgv_lang[pedigree_chart]#</b>, vous afficherez le diagramme par défaut des ascendants pour cette base de données.<br /><br />Un des liens qui pourrait apparaître dans cette liste, s'il a été activé par l'administrateur, est le lien <b>#pgv_lang[view_gedcom]#</b>. Ce lien affiche l'enregistrement GEDCOM de cet individu.<br /><br />Si le #pgv_lang[clip_cart]# a été activé par l'administrateur, vous aurez la possibilité d'ajouter cet individu à votre #pgv_lang[clip_cart]#.<br /><br />Le lien <b>#pgv_lang[relationship_to_me]#</b> n'apparaît que si vous êtes connecté et votre identifiant de connexion est lié à votre ID dans le GEDCOM. Ce lien affiche automatiquement votre arbre généalogique et vous montre de quelle manière vous êtes lié ou non à l'individu dont vous consultez la fiche.<br /><br />#pgv_lang[context_help]#";
$pgv_lang["delete_person_help"] 		 = "~#pgv_lang[delete_person]#~<br /><br />Quand vous sélectionnez cette option, vous marquez cet individu afin qu'il soit supprimé de la base de données.<br /><br />Qu'est-ce que cela signifie ? Supposons que vous ayez une bonne raison de supprimer cet individu depuis la base de données. Vous cliquez ce lien. Vous serez invité à confirmer votre demande de suppression. Quand vous poursuivrez votre consultation du site, vous noterez que l'individu est encore visible et peut être utilisé comme si la suppression n'avait pas été confirmée.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["delete_name_help"]   		 = "~Éditer ou supprimer un nom du GEDCOM~<br /><br /><b>ÉDITER UN NOM</b><br />Quand vous cliquez ce lien, une nouvelle fenêtre s'ouvre. Dans cette fenêtre, vous pouvez éditer le nom de l'individu. saisissez uniquement les modifications dans les zones souhaitées et cliquez le bouton de fermeture de la fenêtre ; c'est tout.<br /><br /><b>SUPPRIMER UN NOM</b><br />En cliquant cette option, vous indiquerez que ce nom doit être supprimé de la base de données.  Notez que supprimer le nom est totalement différent de l'opération qui consiste à supprimer l'individu. Supprimer le nom supprime uniquement le nom de l'individu et non l'individu lui-même. Si c'est le pseudo ou le surnom (AKA) que vous souhaitez supprimer, l'individu conservera ses autres noms.  Si c'est <u>uniquement</u> le nom que vous voulez supprimer, l'individu ne sera pas supprimé, mais sera enregistré comme un individu anonyme (No Name - NN), <b>#pgv_lang[NN]#</b>.  L'individu conservera ses liens avec ses parents, les sources, les notes, etc.<br /><br />Comment cela fonctionne-t'il ? Vous serez invité à confirmer votre demande de suppression. Quand vous reprendrez votre visite, vous noterez que le nom est toujours visible et peut être utilisé comme si la suppression n'avait pas été validée.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["add_name_help"]  			 = "~Ajouter un nouveau nom~<br /><br />Ce lien vous permet d'ajouter un autre nom à cet individu.  Quelquefois certains individus sont connus sous leur nom et un alias (surnom).  Ce lien vous permet d'ajouter de nouveaux noms sans changer l'ancien nom.";
$pgv_lang["add_sibling_help"]   		 = "~#pgv_lang[add_sibling]#~<br /><br />Vous pouvez ajouter un enfant à cette famille quand vous cliquez ce lien.  «Famille proche», dans ce cas regroupe le père et la mère de l'individu.<br /><br />Conservez à l'esprit que vous allez ajouter un enfant aux mêmes parents que l'individu sélectionné. Ajouter un frère ou une sœur est très simple : un simple clic sur le lien, compléter le formulaire dans la fenêtre pop-up et c'est tout.<br /><br />Si vous devez ajouter un fils ou une fille à l'individu principal, faites défiler vers le bas le diagramme et cliquez «Ajouter un frère ou une sœur» ou «#pgv_lang[as_spouse]#».";
$pgv_lang["add_son_daughter_help"]  	 = "~#pgv_lang[add_son_daughter]#~<br /><br />Vous pouvez ajouter un enfant à cette famille quand vous cliquez ce lien.  «Famille proche», dans ce cas, est l'individu principal de cet écran ainsi que son conjoint.<br /><br />Conservez à l'esprit que vous allez ajouter un fils ou une fille à cet individu.  Ajouter un fils ou une fille est très simple : cliquez tout simplement le lien, et remplissez le formulaire dans la fenêtre pop-up qui s'affiche ; c'est tout.<br /><br />Si vous devez ajouter un frère ou une sœur à l'individu principal, faites défiler l'écran jusqu'au lien suivant et cliquez «#pgv_lang[as_child]#».";
$pgv_lang["link_child_help"]			 = "~#pgv_lang[link_as_child]#~<br /><br />Vous pouvez lier cet individu comme enfant à une famille déjà créée quand vous cliquez ce lien.<br /><br />Supposez qu'au moment de l'enregistrement de l'invidu, les parents de cet individu semblent inconnus, et que vous découvriez plus tard que les parents étaient déjà enregistrés dans la base de données.<br /><br />Cliquez simplement le lien, saisissez l'ID de la famille, et la tâche est complète. Si vous ne connaissez pas l'ID de la famille, vous pouvez le rechercher.";
$pgv_lang["link_husband_help"]  		 = "~#pgv_lang[link_as_husband]#~<br /><br />Cette option vous permettra de lier l'individu courant en tant que époux à une famille qui est déjà enregistrée dans la base de données. En cliquant ce lien vous pouvez ajouter cet individu à une famille existante, pour laquelle l'époux était inconnu jusqu'alors. Cet individu remplacera l'époux inconnu jusqu'ici. Toutes les informations comme le mariage ou les enfants conserveront leurs liens avec cette famille.<br /><br />En cliquant simplement ce lien, saisissez l'ID de la famille, et vous aurez compléter la tache. C'est une option d'édition avancée qui devrait seulement être employée si la famille que vous liez existe déjà. Si vous souhaitez ajouter une <u>nouvelle</u> famille à cet individu, utilisez le lien <b>#pgv_lang[add_new_wife]#</b>.";
$pgv_lang["add_husband_help"]   		 = "~#pgv_lang[add_new_husb]#~<br /><br />En cliquant ce lien, vous pouvez ajouter un <u>nouvel</u> individu masculin et lier cet individu à l'individu principal en tant que nouveau époux.<br /><br />En cliquant simplement le lien, remplissez le formulaire de la fenêtre pop-up qui s'affiche. Complétez autant que champs que vous pouvez et cliquez <b>Sauvegarder</b>.";
$pgv_lang["link_new_husb_help"] 		 = "~#pgv_lang[link_new_husb]#~<br /><br />Ceci vous permettra de lier un autre individu, qui existe déjà, en tant que nouveau époux à cet individu. Cette opération crééra une nouvelle famille avec l'époux que vous avez choisi. Vous aurez également l'option d'indiquer un mariage pour cette nouvelle famille.";
$pgv_lang["add_opf_child_help"]			= "~#pgv_lang[add_opf_child]#~<br /><br />En cliquant ce lien, vous pouvez ajouter un <u>nouvel</u> enfant à cette personne, créant ainsi une famille monoparentale.<br /><br />Cliquez simplement le lien et vous obtiendrez une fenêtre contextuelle pour ajouter la nouvelle personne. Remplissez autant de cases que possible et cliquez <b>Enregistrer</b>.";
$pgv_lang["link_wife_help"] 			 = "~#pgv_lang[link_as_wife]#~<br /><br />Cette option vous permettra de lier l'individu courant en tant qu'épouse à une famille qui est déjà présente dans la base de données.<br /><br />C'est une option d'édition avancée qui ne doit être utilisée que si la famille que vous voulez lier à cet individu existe déjà.  Si vous voulez ajouter une <u>nouvelle</u> famille à cet individu, utilisez le lien <b>#pgv_lang[add_new_husb]#</b>.";
$pgv_lang["add_wife_help"]  			 = "~#pgv_lang[add_new_wife]#~<br /><br />En cliquant ce lien, vous pouvez ajouter un <u>nouvel</u> individu féminin et lier cet individu à l'individu principal en tant qu'épouse.<br /><br />Cliquez simplement le lien, et vous obtiendrez une fenêtre pop-up pour y ajouter ce nouvel individu. Remplissez le maximum de champs puis cliquez <b>Sauvegarder</b>.";
$pgv_lang["link_new_wife_help"] 		 = "~#pgv_lang[link_new_wife]#~<br /><br />Ceci vous permettra de lier un autre individu, qui existe déjà, en tant que nouvelle épouse de cet individu.  Ceci crééra une nouvelle famille avec l'épouse que vous avez sélectionnée. Vous aurez également la possibilité d'indiquer un mariage pour cette nouvelle famille.";
$pgv_lang["add_new_parent_help"]		 = "#pgv_lang[multiple_help]#<br />~AJOUTER UN NOUVEAU PÈRE ou UNE MÈRE~<br /><br />Il y a certainement beaucoup d'individus sans père ou mère dans le fichier GEDCOM.<br /><br /> Dans ce cas, sur la page <b>#pgv_lang[indi_info]#</b>, sur les onglets <b>#pgv_lang[relatives]#</b>, sur le tableau <b>#pgv_lang[as_child]#</b>, vous trouverez les liens pour ajouter un <u>nouveau</u> père ou une nouvelle mère à un individu.<br /><br />SVP gardez à l'esprit que ces liens ne doivent être utilisés que pour ajouter un <u>nouveau</u> père ou une nouvelle mère. Si le père ou la mère existent déjà dans la base de données, vous devez ajouter le lien <b>#pgv_lang[link_as_child]#</b>, que vous trouverez sur cette page <b>#pgv_lang[indi_info]#</b> après le dernier tableau. N'oubliez pas de faire les recherches nécessaires dans la base de données avant d'ajouter un nouveau père ou une nouvelle mère.";
$pgv_lang["show_fact_sources_help"] 	 = "~#pgv_lang[show_fact_sources]#~<br />~#pgv_lang[show_fact_notes]#~<br /><br />Quand cette option est sélectionnée, vous pouvez voir tous les enregistrements des Sources ou des Notes de cette personne. Quand cette option n'est pas sélectionnée, les enregistrements des Sources ou des Notes qui sont associés à d'autres faits concernant cette personne ne seront pas affichés.";
$pgv_lang["age_differences_help"]   	 = "~#pgv_lang[age_differences]#~<br /><br />Quand cette option est cochée, l'onglet «#pgv_lang[relatives]#» affichera les différences de date comme suit :<ul><li><b>dates de naissance des partenaires.</b><br />Une valeur négative indique que le second partenaire est plus âgé que le premier.</li><li><b>date de mariage et date de naissance du premier enfant.</b><br />Une valeur négative indique que l'enfant est né avant la date de mariage ou alors que la date de mariage ou la date de naissance est erronée.</li><li><b>dates de naissance des frères et soeurs.</b><br />Une valeur négative indique que ou bien l'ordre des enfants est faux ou que l'une des dates de naissance est fausse.</li></ul>";

//-- Add Facts
$pgv_lang["add_facts_help"] 			 = "~Ajouter un nouvel événement~<br /><br />Ici vous pouvez ajouter un nouvel fait à un enregistrement en cours d'édition.<br /><br />Tout d'abord choisissez un fait depuis la liste, puis cliquez <b>Ajouter</b>.  Tous les faits ou événements que vous pourriez ajouter à un individu sont dans cette liste déroulante.";
$pgv_lang["add_custom_facts_help"]  	 = "~Ajouter un fait personnalisé~<br /><br />Si vous ne pouvez ajouter un événement à partir des événements proposés dans la liste, vous pouvez aussi bien ajouter un <b>événement personnalisé</b>.<br /><br />Saisissez un événement personnalisé est aussi simple que d'Saisissez un événement pré-défini. La seule différence réside dans le fait que vous devez nommer cet événement au lieu de le reprendre à partir de la liste. Vous devez le faire dans le champ en en-tête : <b>#pgv_lang[type]#</b>";
$pgv_lang["add_note_help"]  			 = "#pgv_lang[multiple_help]#<br />~AJOUTER UNE NOUVELLE NOTE~<br /><br />Si vous voulez ajouter une note sur cette personne, cliquez ce lien, qui ouvrira une fenêtre dans laquelle vous pouvez saisir ce que vous désirez. Quand vous avez fini votre saisie, cliquez <b>Ajouter</b> pour terminer.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_shared_note_help"]		= "#pgv_lang[multiple_help]#<br />~#pgv_lang[add_shared_note_lbl]#~<br /><br />Lorsque vous cliquez <b>#pgv_lang[add_shared_note]#</b>, une nouvelle fenêtre s'ouvre. Vous pouvez choisir de créer un lien vers une note partagée existante, ou vous pouvez créer une nouvelle note partagée et en même temps créer un lien vers elle.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_source_help"]			 = "#pgv_lang[multiple_help]#<br />~AJOUTER UNE NOUVELLE citation de SOURCE~<br /><br />Ici vous pouvez ajouter une <b>citation</b> de source à cet enregistrement.<br /><br />Cliquez simplement le lien, une fenêtre s'ouvrira, et vous pourrez choisir la source depuis la liste (recherche de l'ID) ou créer une nouvelle citation de source puis l'ajouter.<br /><br />Renseigner les sources est une part importante et fondamentale du travail de généalogie, parce que cela permet à d'autre généalogistes de vérifier l'origine de vos informations.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"]				= "~#pgv_lang[add_media]#~<br /><br />L'ajout de fichiers multimédias (MM) au GEDCOM est une fonctionnalité très intéressante. Bien que ce programme ait déjà une belle apparence sans média, si vous ajoutez des images ou d'autres MM à vos proches, il ne fera que s'améliorer.<br /><br /><b>Ce que vous devez comprendre sur MM.</b><br />Il existe de nombreux formats de MM. Bien que PhpGedView puisse gérer la plupart d'entre eux, il y a quelques éléments à prendre en compte.<br /><ul><li><b>Formats</b><br />Les images peuvent être modifiées et enregistrées dans de nombreux formats. Par exemple, .jpg, .png, .bmp, .gif, etc. Si la même image d'origine a été utilisée pour créer chacun des formats, l'image affichée apparaîtra de la même taille quel que soit le format utilisé. Cependant, la taille des fichiers image stockés dans la base de données varie considérablement. Généralement, les images .jpg sont considérées comme les plus efficaces en termes d'espace de stockage.</li><li><b>Taille de l'image</b><br />Plus l'image d'origine est grande, plus la taille du fichier résultant sera grande. L'image doit tenir sur l'écran sans défilement ; la largeur ou la hauteur maximale ne doit pas dépasser la largeur ou la hauteur de l'écran. PhpGedView est conçu pour les écrans de 1024x768 pixels mais tout cet espace n'est pas disponible pour la visualisation des images ; la taille de l'image doit être définie en conséquence. Pour réduire la taille des fichiers, des images plus petites sont plus souhaitables.</li><li><b>Résolution</b><br />La résolution d'une image est généralement mesurée en «dpi» (points / pouce), mais ceci n'est valable que pour les images imprimées. Lors de l'examen des images affichées à l'écran, la seule façon correcte est d'utiliser le nombre total de points ou de pixels. Une fois imprimée, l'image peut avoir une résolution de 150 à 300 dpi ou plus selon l'imprimante. Les résolutions d'écran sont rarement supérieures à 50 pixels par pouce. Si votre image ne sera jamais imprimée, vous pouvez réduire en toute sécurité sa résolution (et par conséquent sa taille de fichier) sans affecter la qualité de l'image. Si une image basse résolution est imprimée avec un grossissement trop important, sa qualité en souffrira ; il aura un aspect granuleux.</li><li><b>Profondeur de couleur</b><br />Une autre façon de garder un fichier petit est de diminuer le nombre de couleurs que vous utilisez. Le nombre de couleurs peut varier du noir et blanc pur (deux couleurs) aux vraies couleurs (des millions de couleurs) et tout ce qui se trouve entre les deux. Vous pouvez voir que plus les couleurs sont utilisées, plus la taille des fichiers est grande.</li></ul><br /><b>Pourquoi est-il important de conserver une petite taille de fichier ?</b><ul><li>Tout d'abord: notre espace web est limité. Plus les fichiers sont volumineux, plus nous avons besoin d'espace Web sur le serveur. Plus nous avons besoin d'espace, plus nos coûts sont élevés.</li><li>Bande passante. Plus notre serveur doit envoyer de données à l'emplacement distant (votre emplacement), plus nous devons payer. En effet, la capacité de charge de la connexion du serveur à Internet est limitée et le lien doit être partagé (et payé) par toutes les applications exécutées sur le serveur. PhpGedView est l'une des nombreuses applications qui partagent le serveur. Le coût est normalement réparti en fonction de la quantité de données que chaque application envoie et reçoit.</li><li>Temps de téléchargement. Si vous avez des fichiers volumineux, l'utilisateur (vous aussi) devra attendre longtemps le téléchargement de la page à partir du serveur. Tout le monde n'a pas la chance d'avoir une connexion par câble, haut débit ou DSL.</li></ul><br /><b>Comment télécharger votre MM</b><br />Il existe deux façons de télécharger des médias sur le site. Si vous avez beaucoup d'éléments multimédias à télécharger, vous devez contacter l'administrateur du site pour discuter des meilleurs moyens. S'il a été activé par l'administrateur de votre site, vous pouvez utiliser le formulaire Upload Media sous votre menu #pgv_lang[mgv]#. Vous pouvez également utiliser l'option Télécharger sur le formulaire Multimédia pour télécharger des éléments multimédias.";
$pgv_lang["gen_missing_thumbs_help"]	 = "~#pgv_lang[gen_missing_thumbs]#~<br /><br />Cette option génèrera des vignettes pour tous les fichiers qui se trouvent dans la répertoire actif et qui n'ont pas encore de vignette. Cela est beaucoup plus pratique que de cliquer <b>#pgv_lang[gen_thumb]#</b> pour chacun des fichiers concernés.<br /><br />Si vous désirez vérifiez quels sont les fichiers qui doivent avoir des vignettes, vous ne devez pas utiliser cette option. Dans ce dernier cas, il vaut mieux cliquer les liens appropriés <b>#pgv_lang[gen_thumb]#</b>.";
$pgv_lang["add_facts_general_help"] 	 = "~Informations générales sur l'ajout~<br /><br />Quand vous ajoutez un événement, une note, une source ou un fichier multimédia à une personne de la base de données, cet ajout doit être approuvé par un utilisateur en ayant l'autorisation.<br /><br />Tant que ces modifications n'ont pas été approuvées, elles sont identifiées comme «en attente» par une couleur particulière de la bordure. Tous les utilisateurs ayant les autorisations de modifications peuvent voir ces modifications et l'information originale. Les utilisateurs n'ayant pas les droits de modification voient seulement l'information originale. Quand la modification a été acceptée, les bords de couleur disparaissent et seule l'information modifiée est affichée normalement, remplaçant l'ancienne. À partir de là, cette information est visible par tous les utilisateurs.";

//-- Edit user
$pgv_lang["edituser_my_account_help"]   = "Ici vous pouvez modifier votre configuration et vos préférences.<br /><br />Vous pouvez changer votre identifiant, votre nom, votre mot de passe, votre adresse e-mail, vos coordonnées, le thème par défaut du site web, et la méthode pour vous contacter.<br /><br />Vous ne pouvez pas changer l'ID GEDCOM (INDI) enregistré et attaché à votre nom. Cette opération doit être réalisée par l'administrateur";
$pgv_lang["edituser_username_help"] 	 = "~#pgv_lang[username]#~<br /><br />Dans cette case, vous pouvez modifier votre nom d'utilisateur.  Si votre nom d'utilisateur ne vous convient pas ou si vous avez d'autres raisons pour le changer, vous pouvez le faire en utilisant ce formulaire.<br /><br />Le nom d'utilisateur <u>tient compte des majuscules ou des miniscules</u>. Cela signifie que <b>Jean</b> n'est pas identique à <b>jean</b> ou <b>JEAN</b>.<br /><br />Vous devez utiliser <u>uniquement</u> des charactères de l'alphabet que PhpGedView supporte. Vous pouvez employer les lettres majuscules et minuscules avec ou sans marques diacritiques, les nombres, les tiret (-), et le tiret bas (_). N'utilisez <u>pas</u> les signes de ponctuation ou les espaces.";
$pgv_lang["edituser_firstname_help"]	 = "~#pgv_lang[firstname]#~<br /><br />Dans cette case vous pouvez changer votre prénom. C'est le prénom que les autres utilisateurs voient quand vous êtes connecté.<br /><br />Bien que le choix du prénom vous soit entièrement libre, vous devez informer l'administrateur quand vous le modifiez. Si les autres utilisateurs voyaient un utilisateur inconnu en ligne, elles pourraient être inquiètes et se poser des questions. L'administrateur peut le découvrir sans en avoir été informé par vos soins, aussi est-il recommandé de lui éviter une vérification inutile, informez-le après toute modification.";
$pgv_lang["edituser_lastname_help"] 	 = "~#pgv_lang[lastname]#~<br /><br />Dans cette case vuos pouvez changer votre nom. C'est le nom que les autres utilisateurs voient quand vous êtes connecté.<br /><br />Bien que le choix du nom vous soit entièrement libre, vous devez informer l'administrateur quand vous le modifiez.  Si les autres utilisateurs voyaient un utilisateur inconnu en ligne, elles pourraient être inquiètes et se poser des questions.  L'administrateur peut le découvrir sans en avoir té informé par vos soins, aussi est-il recommandé de lui éviter une vérification inutile, informez-le après toute modification.";
$pgv_lang["edituser_gedcomid_help"] 	 = "~#pgv_lang[gedcomid]#~<br /><br />C'est un numéro d'identification qui vous relie à la base de données généalogiques.<br /><br />Vous ne pouvez pas le modifier ; il est défini par l'administrateur. Si vous pensez que ce numéro d'identification (ID) est incorrect, vous devrez contacter l'administrateur pour obtenir sa modification.";
$pgv_lang["edituser_rootid_help"]   	 = "~#pgv_lang[rootid]#~<br /><br />C'est l'individu racine (à l'origine) de votre diagramme.<br /><br />Si, par exemple, vous deviez cliquer le lien correspondant à votre arbre, vous verriez cet individu racine dans la case à l'extrême gauche de l'écran. Cet individu racine ne doit pas être vous ; vous pouvez commencer la construction de votre arbre avec n'importe quel individu (vos grand-parents ou votre tante par exemple), sous réserve que vous ayez les droits pour voir cet individu.<br /><br />Vous pouvez modifier l'individu racine dans la plupart des diagrammes, mais uniquement pour la page en cours.";
$pgv_lang["edituser_password_help"] 	 = "~#pgv_lang[password]#~<br /><br />C'est une bonne habitude de changer de mot de passe régulièrement. Vous devez conserver à l'esprit que n'importe qui connaissant votre nom d'utilisateur et votre mot de passe pourra avoir accès à vos informations personnelles.<br /><br />Définissez un mot de passe à partir de 6 caractères au minimum, plus ce mot de passe sera long, mieux votre compte sera protégé. Vous pouvez employer les lettres majuscules ou minuscules avec ou sans caractères diacritiques, chiffres, tiret (-) ou tiret bas (_). Ne <u>jamais</u> utiliser de signes de ponctuation ou d'espaces. Utilisez une combinaison de lettres majuscules et minuscules, de chiffres ou d'autres caractères. Par exemple : <b>5Z_q\$P4=r9</b>.<br /><br />Comme pour le nom d'utilisateur, le mot de passe respecte les majuscules et minuscules. Ce qui signifie que le mot de passe<b>Motdepasse.Secret!#13</b> n'est pas identique à <b>motdepasse.secret!#13</b> ou <b>MOTDEPASSE.SECRET!#13</b>.";
$pgv_lang["edituser_conf_password_help"]= "~#pgv_lang[confirm]#~<br /><br />Si vous avez modifié votre mot de passe, vous devez le taper une seconde fois pour le confirmer. C'est uniquement pour vérifier que vous n'avez pas fait d'erreur de saisie et que les deux saisies sont identiques.<br /><br />Si la seconde saisie n'est pas identique à la première (contenu identique des deux champs de mot de passe), vous verrez s'afficher un message d'erreur. Vous devrez resaisir le bon mot de passe à nouveau deux fois pour confirmation.";
$pgv_lang["edituser_change_lang_help"]  = "~#pgv_lang[change_lang]#~<br /><br />Ici vous pouvez changer la langue de l'interface de PhpGedview et des messages qui sont affichés.<br /><br />Lors de votre première connexion au site, PhpGedView suppose que vous souhaitez conserver la même langue que celle utilisée dans votre navigateur web. Si cette supposition s'avérerait incorrecte, vous pourriez modifier le choix de la langue ici.  Par exemple, votre navigateur est configuré pour utiliser la langue anglaise, parce que c'est la langue la plus répandue sur le web. Cependant, pour des recherches généalogiques, vous préférez visualiser les informations en Suédois ou en Hébreu. C'est ici que vous pouvez le faire.<br /><br />L'administrateur choisit quelles langues seront disponibles aux utilisateurs. Si votre langue préférée n'est pas dans la liste, vous devrez contacter l'administrateur.<br /><br />SVP souvenez-vous que PhpGedView est un projet collaboratif international dont les membres sont bénévoles. Les experts vont et viennent. En conséquence, l'intégration d'autres langues que l'anglais n'est pas d'aussi bonne qualité qu'elle le devrait.<br /><br />Si vous lisez quelque-chose de mal traduit ou avec des fautes d'orthographe, portez le à la connaissance de l'administrateur. L'administrateur saura contacter l'équipe de développeurs de PhpGedView pour apporter les corrections nécessaires. Participez à l'amélioration de cet outil, offrez une partie de votre temps. Votre aide sera la bienvenue.";
$pgv_lang["edituser_email_help"]		 = "~#pgv_lang[emailadress]#~<br /><br />Une adresse e-mail valide est indispensable pour nous permettre de rester en contact avec vous.<br /><br />Si vous changez d'adresse e-mail, comme cela se produit quand vous changez de fournisseur d'accès Internet, s'il vous plaît, n'oubliez pas de changer votre adresse e-mail ici également. Vous ne recevrez pas de message de confirmation de ce changement d'adresse, mais tous les prochains messages de ce site vous seront envoyés directement à cette nouvelle adresse.";
$pgv_lang["edituser_user_theme_help"]   = "~#pgv_lang[user_theme]#~<br /><br />L'interface de ce site est paramétrable et peut avoir plusieurs «aspects». D'autres programmes nomment ces interfaces des «skins», mais nous utiliserons le terme plus approprié de «thèmes».<br /><br />Chaque thème affiche les mêmes données, seule la présentation de ces données change. C'est comme poser une image dans un cadre différent et dans une autre pièce. L'image ne change pas, seul l'environnement est complètement différent.<br /><br />Essayez l'un des thèmes proposés. Regardez s'il vous convient, essayez en un autre. Conservez celui qui convient le mieux. À chaque connexion, vous retrouverez le thème sélectionné lors de votre dernière visite ; vous n'êtes pas obligé de sélectionner votre thème à chaque nouvelle connexion.";
$pgv_lang["edituser_contact_meth_help"] = "~#pgv_lang[user_contact_method]#~<br /><br />PhpGedView utilise différentes méthodes pour gérer les messages entre utilisateurs. L'administrateur détermine quelle méthode sera la mieux adaptée. Vous avez le choix du mode de messagerie à utiliser pour <u>vous</u> contacter. Selon la configuration du site, certains modes de messagerie ne seront pas accessibles.";
$pgv_lang["mail_option1_help"]  		 = "Avec cette option, la messagerie interne de PhpGedView sera utilisée et aucun e-mail ne vous sera envoyé.<br /><br />Vous recevrez seulement des messages <u>internes</u> des autres utilisateurs. Quand un autre utilisateur vous envoie un message, ce message apparaît dans votre case de réception des messages sur votre page #pgv_lang[mygedview]#.  Si vous avez supprimé ce bloc (cette case) de votre page #pgv_lang[mygedview]#, vous ne verrez plus aucun message. Ils apparaîtront cependant quand vous reconfigurerez votre page #pgv_lang[mygedview]# pour afficher la case de réception des messages.";
$pgv_lang["mail_option2_help"]  		 = "Cette option est similaire à  #pgv_lang[messaging]#, mais avec un ajout.  En plus du message interne, une copie du message vous est adressée directement par e-mail.<br /><br />C'est la méthode de messagerie par défaut et la plus complète.";
$pgv_lang["mail_option3_help"]			= "Avec cette option, vous ne recevrez des e-mails qu'à l'adresse que vous avez configurée sur la page de votre compte. Le système de messagerie interne à PhpGedView ne sera pas du tout utilisé, et il n'y aura jamais de messages dans le bloc Message sur votre page personnelle #pgv_lang[mygedview]#.";
$pgv_lang["mail_option4_help"]			= "Avec cette option, vous ne recevrez aucun message. Même l'administrateur ne pourra pas vous joindre.";

//-- Admin
$pgv_lang["admin_help"] 				 = "Sur cette page vous trouverez les liens vers les pages de configuration, d'administration, de documentation et de connexion.<br /><br /><b>#pgv_lang[system_time]#</b>, juste au-dessous du titre de la page, montre l'heure du serveur sur lequel est hébergé votre site. Ceci signifie que si votre serveur d'hébergement est situé à New York alors que vous vous trouvez en France, l'heure indiquée aura 6 heures de décalage avec votre heure locale, à moins que le serveur ne soit réglé sur l'heure de Greenwich (Greenwich Mean Time - GMT).  L'heure du serveur est affichée lorsque vous ouvrez ou actualisez cette page.<br /><br /><b>ATTENTION</b><br />Quand vous voyez un message d'alerte rouge sous l'heure système, cela signifie que le fichier <i>config.php</i> est toujours modifiable. Une fois la configuration de votre site terminée, vous devez, pour plus de <b>sécurité</b>, modifier les options de ce fichier et n'autoriser que la lecture seule. Vous devez réaliser ces modifications via votre logiciel FTP <u>manuellement</u>, cette manipulation n'étant pas possible depuis PhpGedView.";
		
//-- User Admin
$pgv_lang["useradmin_help"]					= "~#pgv_lang[user_admin]#~<br /><br />Sur cette page vous pouvez administrer les utilisateurs ou en ajouter de nouveaux.<br /><br /><b>#pgv_lang[current_users]#</b><br />Dans ce tableau, les utilisateurs courants, leur statut et leurs droits sont affichés.  Vous pouvez <b>supprimer</b> ou <b>éditer</b> les utilisateurs.<br /><br /><b>#pgv_lang[add_user]#</b><br />Ce formulaire est presque identique à celui que les utilisateurs voient sur leur page <b>#pgv_lang[editowndata]#</b>.<br /><br />Pour différentes rubriques il n'existe pas de texte d'aide spécifique pour l'administrateur. Dans ces cas là vous verrez s'afficher le message suivant :";
$pgv_lang["useradmin_gedcomid_help"]   		= "~#pgv_lang[gedcomid]#~<br /><br />Le #pgv_lang[gedcomid]# identifie chaque utilisateur. Il est spécifié par l'administrateur.<br /><br />Cet ID est utilisé comme ID de connexion et de paramétrage automatique des informations affichées dans plusieurs pages comme par exemple <b>#pgv_lang[my_indi]#</b> et <b>#pgv_lang[my_pedigree]#</b>.<br /><br />Vous pouvez spécifier l'ID GEDCOM des utilisateurs séparément pour chaque GEDCOM. Si un utilisateur n'a pas d'enregistrement le concernant dans le GEDCOM, vous laisserez ce champ vide.";
$pgv_lang["useradmin_rootid_help"] 			= "~#pgv_lang[rootid]#~<br /><br />Pour chaque base de données généalogiques, vous pouvez spécifier un <b>individu racine</b> pour cet utilisateur.<br /><br />Cet individu racine n'est pas nécessairement l'utilisateur lui-même ; il peut être n'importe qui. L'utilisateur désirera sûrement commencer son arbre à partir de lui-même.  Vous le définissez, comme l'individu racine pour différents diagrammes, ici.<br /><br />Si l'utilisateur bénéficie de droits pour modifier son propre compte, il pourra modifier cet individu racine lui-même.";
$pgv_lang["useradmin_can_admin_help"]  		= "~#pgv_lang[can_admin]#~<br /><br />Si cette case est cochée, l'utilisateur aura les mêmes droits que vous.<br /><br />Ces droits incluent :<ul><li>Ajouter/ Supprimer / Editer les utilisateurs</li><li>Messages diffusés à tous les utilisateurs</li><li>Edition des messages sur la page d'accueil</li><li>Edition et configuration de la langue</li><li>Mise à jour de PhpGedView</li><li>Modifications du programme et de la configuration du fichier GEDCOM</li><li>Administration des GEDCOM</li><li>Modification des paramètres utilisateurs</li><li>Et d'autres réglages qui ne sont pas mentionnés ici.</li></ul><br />L'utilisateur <u>ne peut rien</u> modifier sur votre serveur dehors de PhpGedView.";
$pgv_lang["useradmin_sync_gedcom_help"]		= "~#pgv_lang[sync_gedcom]#~<br /><br />Si cette case est cochée et si l'utilisateur a un enregistrement GEDCOM qui lui est associé, son compte d'utilisateur sera automatiquement synchronisé avec les données du GEDCOM le concernant. Ceci signifie que quand les données GEDCOM de l'utilisateur seront modifiées, quelques-unes de ces informations comme l'adresse e-mail ou le nom seront copiées automatiquement dans le compte de l'utilisateur. Quand le compte de l'utilisateur est modifié, les modifications apportées sont copiées également vers l'enregistrement GEDCOM correspondant.";
$pgv_lang["useradmin_can_edit_help"]   		= "~#pgv_lang[can_edit]#~<br /><br />L'utilisateur peut bénéficier de différents types d'accès et de privilèges en fonction des bases généalogiques pour lesquelles il est enregistré.<ul><li><b>#pgv_lang[none]# :</b>&nbsp;&nbsp;&nbsp;L'utilisateur ne peut accéder aux informations confidentielles dans ce GEDCOM.</li><li><b>#pgv_lang[access]# :</b>&nbsp;&nbsp;&nbsp;L'utilisateur ne peut pas éditer ou valider des données dans la base de données mais il peut visualiser les données d'ordre personnel.</li><li><b>#pgv_lang[edit]# :</b>&nbsp;&nbsp;&nbsp;L'utilisateur peut éditer et modifier des données mais ces modifications doivent être validées par un autre utilisateur qui dispose des privilèges <b>#pgv_lang[accept]#</b> avant que celles-ci ne soient enregistrées dans la base de données et accessible au public.</li><li><b>#pgv_lang[accept]# :</b>&nbsp;&nbsp;&nbsp;L'utilisateur peut éditer et modifier des données. Il peut également approuver des changements réalisés par d'autres utilisateurs.</li><li><b>#pgv_lang[admin_gedcom]# :</b>&nbsp;&nbsp;&nbsp;L'utilisateur peut éditer la configuration et les réglages du fichier <u>GEDCOM</u>.</li></ul>Les administrateurs système, identifiés par la case à cocher <b>#pgv_lang[can_admin]#</b>, disposent automatiquement des privilèges <b>#pgv_lang[admin_gedcom]#</b>.";
$pgv_lang["useradmin_verified_help"]   		= "~#pgv_lang[verified]#~<br /><br /><b>Enregistrement d'un compte utilisateur</b><br />Un utilisateur peut solliciter un nouveau compte à l'aide du module <b>de demande d'un compte utilisateur</b>.<br /><br />S'il procède à cette demande, il recevra un e-mail avec un lien lui permettant de vérifier et valider son nouveau compte. Une fois qu'il aura suivi les instructions de validation de son compte dans le e-mail, vous constaterez que cette case est cochée et vous pourrez passer à l'étape suivante, <b>#pgv_lang[verified_by_admin]#</b>. Vous devez attendre que cette case soit cochée pour approuver le nouveau compte.<br /><br /><b>Ajouter un utilisateur manuellement</b><br />Si vous ajoutez un compte utilisateur manuellement, vous constaterez que la case est déjà cochée automatiquement.";
$pgv_lang["useradmin_verbyadmin_help"] 		= "~#pgv_lang[verified_by_admin]#~<br /><br />Si un utilisateur a utilisé le module de demande d'un compte utilisateur et s'est enregistré lui-même, la dernière étape, avant que son compte ne devienne actif, est votre approbation (validation).<br /><br />Une fois que vous aurez approuvé cette demande de compte, l'utilisateur recevra un e-mail. Ce e-mail informera l'utilisateur que son compte a été activé et qu'il peut se connecter en utilisant l'identifiant et le mot de passe saisis lors de son enregistrement.";
$pgv_lang["useradmin_edit_user_help"]  		= "~#pgv_lang[update_user]#~<br /><br />Ce formulaire est utilisé par l'administrateur pour modifier les comptes utilisateurs.<br /><br />Ce formulaire est similaire aux formulaires <b>#pgv_lang[add_user]#</b> et <b>#pgv_lang[update_myaccount]#</b>.";
$pgv_lang["useradmin_visibleonline_help"]	= "~#pgv_lang[visibleonline]#~<br /><br />Cette case à cocher contrôle votre visibilité auprès des autres utilisateurs lorsque vous êtes en ligne. Il contrôle également votre capacité à voir les autres utilisateurs en ligne qui sont configurés pour être visibles. <br /> <br /> Lorsque cette case est décochée, vous serez complètement invisible pour les autres, et vous ne pourrez pas non plus voir d’autres utilisateurs en ligne. utilisateurs. Lorsque cette case est cochée, exactement le contraire est vrai. Vous serez visible pour les autres, et vous pourrez également voir les autres qui sont configurés pour être visibles.";
$pgv_lang["useradmin_editaccount_help"]		= "~#pgv_lang[editaccount]#~<br /><br />Si cette case est cochée, cet utilisateur pourra modifier les informations de son compte. Bien que cela ne soit généralement pas recommandé, vous pouvez créer un seul nom d'utilisateur et mot de passe pour plusieurs utilisateurs. Lorsque cette case n'est pas cochée pour tous les utilisateurs disposant du compte partagé, ils ne peuvent pas modifier les informations du compte et seul un administrateur peut modifier ce compte.";
$pgv_lang["useradmin_relation_priv_help"]	= "~#pgv_lang[user_relationship_priv]#~<br /><br />Si cette case est cochée, les utilisateurs ne peuvent accéder qu'aux individus vivants qui leur sont liés (liens de parenté directe). Ils ne sont en mesure de voir que les proches dans la limite du degré de parenté indiqué par <i>#pgv_lang[user_path_length]#</i>. Vous pouvez avoir besoin d'imposer à tous les utilisateurs ces restrictions d'accès au fichier GEDCOM en activant les options de restriction d'accs dans le GEDCOM.<br /><br />Ces réglages nécessitent que les utilisateurs soient associés à un ID GEDCOM pour être autorisés à voir n'importe quel individu vivant.";
$pgv_lang["useradmin_path_length_help"]		= "~#pgv_lang[user_path_length]#~<br /><br />Si <i>#pgv_lang[user_relationship_priv]#</i> est actif, cet utilisateur ne pourra voir ou éditer que les individus vivants dans le degré de parenté indiqué.";
$pgv_lang["useradmin_auto_accept_help"]		= "~#pgv_lang[user_auto_accept]#~<br /><br />En cochant cette case, vous permettez au système d'accepter automatiquement toutes les modifications réalisées par cet utilisateur.  L'utilisateur doit également bénéficier des mêmes privilèges dans le GEDCOM pour que cette option soit active.";

//-- Manage Sites
$pgv_lang["help_managesites"] 			= "~#pgv_lang[link_manage_servers]#~<br /><br />Sur cette page, vous pouvez ajouter des sites distants et refuser l'accès à partir d'adresses IP spécifiques.<br /><br />Des sites distants peuvent être ajoutés en fournissant le titre du site, l'URL, l'identifiant de la base de données (facultatif), le nom d'utilisateur et le mot de passe de la télécommande service Web.<br /><br />Le refus d'accès IP permanent ou programmé est accompli en fournissant une adresse IP exacte ou toute plage d'adresses IP valide. Par exemple, 212.10.*.* Les sites distants dans les plages d'adresses IP de la liste ne pourront pas accéder à votre site.";
//-- Adding Remote Links
$pgv_lang["help_remotesites"]			= "~#pgv_lang[label_new_server]#~<br /><br />Pour ajouter un site distant, indiquez le titre du site, l'URL du service Web distant, l'ID de la base de données (facultatif), le nom d'utilisateur et le mot de passe. Cliquez Ajouter (+) pour terminer le processus. Si le serveur distant autorise l'authentification anonyme, vous devez laisser le nom d'utilisateur et le mot de passe vides.";
//-- IP Address Banning
$pgv_lang["help_IPv4IPv6"]				= "Les adresses IPv4 se composent de 4 segments séparés par un \".\" (point) et contenant des nombres décimaux allant de zéro à 255, sans zéros au début. Quelques exemples suivent : <b>172.252.19.56</b> , <b>212.10.*.*</b> , <b>212.10.</b> , <b>212.10</b> , <b>212.10..29</b> ou <b>212.10.*.29</b> .  Les segments manquants dans ces exemples seront interprétés comme \"*\" (astérisque). Ce symbole \"*\" signifie <i>correspond à n'importe quel numéro à cette position</i>.<br /><br />Les adresses IPv6 consistent en 8 segments séparés par un \":\" (deux points) et contenant des nombres hexadécimaux à 4 chiffres. Ces nombres ne doivent pas comporter de zéros à gauche et la première séquence de zéros peut être supprimée et remplacée par une paire de symboles \":\" (deux points). Si vous voulez utiliser la fonctionnalité <i>correspond à n'importe quel numéro à cette position</i>, vous devez y insérer explicitement \"*\" (astérisque). Quelques exemples suivent : <b>23:0:cafe::2:1</b> , <b>23:0:cafe::*:1</b> ou <b>23:0:*::*:*</b> . Dans ces exemples, la paire de deux points représente une séquence de 3 nombres, dont chacun est égal à zéro, comme suit : <b>23:0:cafe:0:0:0:*:1</b>.";
$pgv_lang["help_banning"]				= "~#pgv_lang[label_banned_servers]#~<br /><br />Pour interdire certaines adresses IPv4 ou IPv6 d'accéder à votre site, saisissez une adresse IP exacte ou une plage d'adresses IP valides, puis cliquez Ajouter (+).<br /><br />#pgv_lang[help_IPv4IPv6]#";
$pgv_lang["help_timedban"]				= "~#pgv_lang[label_timedban_servers]#~<br /><br />Quand une tentative de piratage est détectée, PhpGedView empêchera automatiquement l'accès depuis cette adresse IP pendant une heure.<br /><br />Vous pouvez ajouter vos propres refus d'accès programmés en saisissant l'adresse IPv4 ou IPv6 à bloquer ainsi que la date et l'heure d'expiration du refus d'accès dans le champ Commentaires. Vous devez utiliser le format correct pour les informations d'expiration. Si les informations d'expiration ne sont pas saisies correctement, le refus d'accès n'expirera pas automatiquement.<br /><br />La date d'expiration doit être introduit dans le format suivant : <b>aaaa.mm.jj@hh:mm</b> . Exemple : <b>2012.12.23@23:59</b> .  Notez l'utilisation de l'horloge de 24 heures.<br /><br />#pgv_lang[help_IPv4IPv6]#";
$pgv_lang["help_manual_search_engines"] = "~#pgv_lang[label_manual_search_engines]#~<br /><br />PhpGedView fournit automatiquement à des moteurs de recherche de plus petits fichiers de données avec peu de liens. Les données sont limitées aux individus et à leur famille proche, sans ajout d'information sur leurs grand-parents ou leurs petits-enfants. De nombreux rapports et des pages de données lourdes comme le calendrier sont en dehors des limites des moteurs de recherche.<br /><br />De nombreux moteurs de recherche populaires tels que Google et Bing seront détectés automatiquement. Si un moteur de recherche n'est pas automatiquement reconnu et que vous souhaitez lui fournir des données à indexer, vous pouvez saisir ici son adresse IPv4 ou IPv6. Si vous souhaitez exclure complètement ce nouveau moteur de recherche, listez-le dans la section <i>#pgv_lang[label_banned_servers]#</i>.<br /><br />Si vous souhaitez voir quelles sont vos données qui sont indéxées par les moteurs de recherche, spécifiez votre propre adresse IP ici.&nbsp; <span class='warning'>ATTENTION&nbsp;:</span>&nbsp; Cela vous <b>exclura</b> de l'interface d'administration et vous devez supprimer l'IP en vous connectant depuis un autre ordinateur ayant une adresse IP différente ou en modifiant manuellement la table de base de données <i>#GLOBALS[TBLPREFIX]#ip_address</i>.<br /><br />#pgv_lang[help_IPv4IPv6]#";

//-- Search_engines.php
$pgv_lang["search_engine_landing_page"] = "~Moteur de recherche détecté~<br /><br />PhpGedView fournit automatiquement à des moteurs de recherche de plus petits fichiers de données avec peu de liens. Les données sont limitées aux individus et à leur famille proche, sans ajout d'information sur leurs grand-parents ou leurs petits-enfants.  De nombreux rapports et des pages de données lourdes comme le calendrier sont en dehors des limites des moteurs de recherche.<br /><br />Les tentatives des moteurs de recherche pour accéder à ces pages aboutissent à montrer ces pages. Si vous voyez ce texte, le logiciel pense que vous êtes un moteur de recherche. Ci-dessous ce trouve la liste des pages qui peuvent être indexées et fournissent des données abrégées aux moteurs.<br /><br />Les utilisateurs qui suivront les liens proposés par les moteurs de recherche jusqu'à ce site, accéderont aux pages complètes et non à cette page.";

//-- G E D C O M
$pgv_lang["add_upload_gedcom_help"] 	 = "~#pgv_lang[add_gedcom]#~<br />~#pgv_lang[upload_gedcom]#~<br /><br /><b>#pgv_lang[upload_gedcom]#</b><br />Le chargement d'un fichier sur le serveur peut se faire directement ici, sans programme de type FTP.<br /><br /><b>#pgv_lang[add_gedcom]#</b><br />Quand un GEDCOM est déjà présent sur le serveur, il suffit de le reconfigurer.<br /><br />Les deux procédures se déroulent très simplement en 4 étapes, seule la première diffère.";
$pgv_lang["gedcom_configfile_help"] 	 = "~Fichier de configuration GEDCOM~<br /><br />C'est le fichier où la configuration de base de données relative à la base de données généalogiques est enregistrée. Il existe un fichier pour chaque base de données.<br /><br />Vous trouverez le chemin et le nom de chaque fichier de configuration dans le tableau <b>#pgv_lang[current_gedcoms]#</b> sur la page <b>#pgv_lang[gedcom_adm_head]#</b>.";
$pgv_lang["default_gedcom_help"]		 = "~GEDCOM par défaut~<br /><br />Si vous avez plusieurs GEDCOM en ligne, vous pouvez en désigner un comme GEDCOM par défaut pour les visiteurs du site ou les utilisateurs non encore connectés.<br /><br />Les utilisateurs autorisés peuvent modifier cette valeur par défaut en changeant les paramètres de leur compte.";
$pgv_lang["delete_gedcom_help"] 		 = "~Supprimer un GEDCOM~<br /><br />PhpGedView crée sa base de données à partir d'un fichier GEDCOM qui a été préalablement téléchargé. Quand vous sélectionnez <b>Supprimer</b>, cette partie de la base de données sera effacée. Vous devez confirmer votre demande de suppression.<br /><br />À moins que vous ne l'ayez délibérement supprimé en dehors de PhpGedView, le fichier original GEDCOM se trouve dans le répertoire dans lequel il a été téléchargé. Si vous souhaitez retravailler avec ce fichier GEDCOM plus tard, vous n'aurez pas à le télécharger à nouveau. Vous pouvez choisir la fonction <b>#pgv_lang[add_gedcom]#</b>.";
$pgv_lang["add_gedcom_help"]			= "~#pgv_lang[add_gedcom]#~<br /><br />Lorsque vous utilisez la fonction <b>#pgv_lang[add_gedcom]#</b>, il est supposé que vous avez déjà téléchargé le fichier GEDCOM sur votre serveur en utilisant un programme ou une méthode <u>externe</u> à PhpGedView, pour exemple, <i>FTP</i> ou <i>connexion réseau</i>. Le fichier que vous souhaitez ajouter peut également avoir été laissé d'une procédure <b>#pgv_lang[upload_gedcom]#</b> précédente.<br /><br />Si le fichier GEDCOM d'entrée n'est pas encore sur votre serveur, vous <u>devez</u> y accéder en premier, avant de pouvoir commencer à ajouter.<br /><br />Au lieu de télécharger un fichier GEDCOM, vous pouvez également télécharger un fichier ZIP contenant le fichier GEDCOM, soit avec PhpGedView, soit en utilisant un programme externe. PhpGedView reconnaîtra automatiquement le fichier ZIP et extraira le fichier GEDCOM et le nom de fichier du fichier ZIP.<br /><br />Si un fichier GEDCOM avec le même nom existe déjà dans PhpGedView, il sera écrasé. Cependant, tous les paramètres GEDCOM définis précédemment seront conservés.<br /><br />Vous êtes guidé pas à pas tout au long de la procédure.";
$pgv_lang["add_new_gedcom_help"]		 = "~#pgv_lang[add_new_gedcom]#~<br /><br />Vous pouvez commencer une nouvelle base de données généalogiques à partir de zéro.<br /><br />Cette procédure implique tout simplement de suivre ces étapes. L'étape 1 est différente de ce que vous connaissez déjà (téléchargement ou ajout). Les autres étapes vous seront familières.<ol><li><b>Nommer le nouveau GEDCOM</b><br />Saisissez le nom du nouveau GEDCOM <u>sans</u> l'extension <b>.ged</b>. Le nouveau fichier sera créé dans le répertoire nommé au-dessus de la case dans laquelle vous saisissez le nom.  Cliquez <b>Ajoutez</b>.</li><li><b>Page de configuration</b><br />Vous connaissez déjà cette page ; vous configurez les nouveaux paramètres de votre nouveau fichier GEDCOM.</li><li><b>Validez</b><br />Vous connaissez également cette page ; le nouveau GEDCOM est validé. Puisqu'il est vide, il sera OK.</li><li><b>Importer des enregistrements</b><br />Puisqu'il n'y aura qu'un seul enregistrement à importer, cette étape sera très rapide.</li></ol>Maintenant vous pouvez vous rendre sur votre arbre généalogique et voir votre premier individu dans le nouveau GEDCOM. Cliquez le nom de l'individu et modifiez-le. Maintenant vous pouvez lier de nouveaux individus à ce premier enregistrement.";
$pgv_lang["download_gedcom_help"]   	 = "~#pgv_lang[download_gedcom]#~<br /><br />À partir de cette page, vous pouvez télécharger votre base de données généalogiques au format GEDCOM. Vous pouvez vouloir importer des données dans un autre programme généalogique, ou partager ces données avec d'autres.<br /><br />#pgv_lang[utf8_ansi_help]#<br /><br />#pgv_lang[remove_tags_help]#<br /><br />#pgv_lang[download_zipped_help]#";
$pgv_lang["edit_gedcoms_help"]  		 = "~#pgv_lang[gedcom_adm_head]#~<br /><br />La page  #pgv_lang[gedcom_adm_head]# est le centre de contrôle pour administrer toutes vos bases de données généalogiques.<br /><br /><b>#pgv_lang[current_gedcoms]#</b><br />En en-tête du tableau <b>#pgv_lang[current_gedcoms]#</b>, vous verrez une barre d'outils avec 4 liens.<ul><li>#pgv_lang[add_gedcom]#</li><li>#pgv_lang[upload_gedcom]#</li><li>#pgv_lang[add_new_gedcom]#</li><li>#pgv_lang[lang_back_admin]#</li></ul><br />Dans le tableau <b>#pgv_lang[current_gedcoms]#</b> chaque base de données généalogiques est listée séparément, et vous disposez des options suivantes pour chacune d'elles :<ul><li>Importer</li><li>Supprimer</li><li>Télécharger</li><li>Configurer</li><li>Restrictions d'accès</li><li>Journal des recherches</li></ul>L'édition des restrictions d'accès apparaît ici parce que chaque GEDCOM a son propre fichier de restrictions d'accès.<br /><br />Chacune des lignes de ce tableau est explicite. PhpGedView peut être configuré pour enregistrer toutes les recherches sur la base de données.  Le journal des recherches peut être analysé à partir des liens sur cette page.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["edit_config_gedcom_help"]	 = "~Configuration GEDCOM~<br /><br />Toutes les bases de données généalogiques utilisées avec PhpGedView ont leur propre <b>fichier de configuration</b>.<br /><br />Dans ce formulaire, vous pouvez configurer de nombreuses options telles que le titre de la base de données, la langue utilisée, le format des calendriers, les options du e-mail, la journalisation des recherches dans la base de données, les balises META en en-tête des pages HTML, l'extraction des noms de famille depuis la liste des noms de famille les plus fréquents, etc.";
$pgv_lang["import_gedcom_help"] 		 = "~Import GEDCOM~<br /><br />Dans la plupart des cas l'importation d'un fichier GEDCOM, déjà créé par un autre programme, est l'une des étapes qui a pour conséquence une modification en bloc de la base de données généalogiques.<br /><br />Ces étapes respectent un ordre logique et doivent être accomplies dans l'ordre indiqué de sorte que la base de données généalogiques soit correctement installée.<br /><br />Si, pour quelques raisons que ce soit, vous ne respectiez pas l'ordre indiqué, un message <u>d'alerte</u> vous indiquera que le GEDCOM n'est pas encore importé. Pour corriger ce problème, cliquez <b>Importation GEDCOM</b> pour importer le fichier.<br /><br />La configuration existante du GEDCOM ne sera pas modifiée quand vous ré-importerez le GEDCOM. Les données existantes seront écrasées lors de l'importation.";
$pgv_lang["upload_gedcom_help"]			= "~#pgv_lang[upload_gedcom]#~<br /><br />Contrairement à la fonction <b>#pgv_lang[add_gedcom]#</b>, le fichier GEDCOM que vous souhaitez ajouter à votre base de données n'a pas besoin d'être sur votre serveur.<br /><br />À l'étape 1, vous sélectionnez un GEDCOM depuis votre ordinateur local. Tapez le chemin complet et le nom du fichier dans la zone de texte ou utilisez le bouton <b> Parcourir </b> sur la page.<br /><br />Vous pouvez également utiliser cette fonction pour télécharger un fichier ZIP contenant le fichier GEDCOM. PhpGedView reconnaîtra le fichier ZIP et extraira automatiquement le fichier et le nom de fichier.<br /><br />Si un fichier GEDCOM avec le même nom existe déjà dans PhpGedView, il sera, après votre confirmation, écrasé. Cependant, tous les paramètres GEDCOM définis précédemment seront conservés.<br /><br />Vous trouverez plus d'aide sur d'autres pages de la procédure.";
$pgv_lang["validate_gedcom_help"]   	 = "~Vérifier le GEDCOM~<br /><br />C'est la troisième étape de la procédure pour ajouter à votre base de données généalogiques un fichier GEDCOM qui a été créé par un autre programme.<br /><br />PhpGedView examinera le fichier en entrée, notamment le format des dates, des lieux, le jeu de caractères utilisé, etc.  Quelques variantes par rapport à la norme GEDCOM 5.5.1, à laquelle PhpGedView adhère, pourront être corrigées automatiquement. Par exemple, la gestion du retour chariot en fin de ligne sur les Macintosh ou le formatage incorrect des noms de lieux.  Quand ces erreurs sont corrigées, un message vous avertira des modifications apportées par votre programme. Concernant d'autres anomalies, vous recevrez un message d'avertissement accompagné d'une solution recommandée.<br /><br /><b>Outils facultatifs</b><br />À ce jour il n'existe qu'un seul outil facultatif : <b>Changer l'ID de l'individu pour...</b>.<br /><br /><b>Aide détaillée</b><br />#pgv_lang[context_help]#";
$pgv_lang["convert_ansi2utf_help"]  	 = "~Convertir du format ANSI vers le format UTF-8~<br /><br />Pour être certain que les informations qui sont importées depuis votre fichier GEDCOM sont traitées correctement, les fichiers sont encodés au format UTF-8.<br /><br />Certains programmes de généalogie plus récents peuvent exporter leurs données dans un GEDCOM encodé en UTF-8. Les anciens programmes n'ont souvent pas cette possibilité. Si votre programme ne vous permet pas d'utiliser cette option, PhpGedView pourra convertir vos fichiers pour vous.<br /><br />Quand PhpGedView valide le fichier en entrée, il détectera son type d'encodage et vous alertera en conséquence.";
$pgv_lang["detected_ansi2utf_help"] 	 = "~Encodage au format ANSI détecté~<br /><br />Le GEDCOM qui vient d'être validé est encodé selon le format de caractères ANSI. Il vous est fortement recommandé de le convertir au format UTF-8.<br /><br />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"] 		 = "~Format erroné de date détecté~<br /><br /><b>LE FORMAT DE DATE SERA CHANGÉ</b><br /><br />Le format de date standard pour PhpGedView qui est également celui qui est recommandé par la norme GEDCOM 5.5.1 : <b>DD&nbsp;MMM&nbsp;YYYY</b> (par exemple, 01&nbsp;JAN&nbsp;2004)<br /><br />Si, après la validation du GEDCOM, vous voyez un message vous alertant que les dates sont mal formatées, PhpGedView convertira les dates comme spécifié par le standard GEDCOM 5.5.1.<br /><br />Vous avez cependant la possibilité de choisir entre «<b>jour</b> avant le mois» (DD&nbsp;MMM&nbsp;YYYY), ou «<b>mois</b> avant le jour» (MMM&nbsp;DD&nbsp;YYYY).<br /><br />Nous vous recommandons d'utiliser le premier format (jour avant mois).";
$pgv_lang["change_indi2id_help"]		 = "~Modifier l'ID d'un individu à ....~<br /><br />Cet outil a été conçu pour les utilisateurs dont les programmes de généalogie utilisent un ID GEDCOM différent lors de l'exportation des individus. Par exemple, lors de la première exportation du GEDCOM, l'ID d'un individu peut être I100 mais lors de l'exportation suivante l'ID du même individu a été modifié en I234. Ces changements d'ID rendent difficile l'administration de PhpGedView car l'ID est le seul élément qui permet d'identifier les individus.<br /><br />La plupart des programmes de généalogie emploient la balise RIN ou REFN pour assigner à chaque individu un identifiant unique qui pourra être utilisé pour référencer l'individu. Cet outil remplace tous les identifiants des individus dans le GEDCOM par l'un des champs RIN ou REFN en fonction de vos préférences.";
$pgv_lang["edit_privacy_help"]  		 = "Sur cette page vous pouvez définir les règles d'accès pour le GEDCOM sélectionné.<br /><br />Vous pouvez vérifier sous le titre de la page que vous éditez le bon fichier des restrictions d'accès. Il est affiché comme suit : (chemin/nomgedcom_priv.php)<br /><br />Si vous avez besoin d'apporter des réglages supplémentaires, vous pouvez réaliser les modifications directement à la main dans le fichier des restrictions d'accès. Vous pourrez en lire plus sur cette opération sur le site web de PhpGedView.";
$pgv_lang["BOM_detected_help"]  		 = "~Une marque d'ordre des octets (BOM) a été détectée~<br /><br />Le fichier GEDCOM que vous importez comporte un code spécial de 3 octets en en-tête. Ce code spécifique est utilisé par certains programmes pour indiquer que le fichier a été enregistré au format de caractères UTF-8.<br /><br />Bien que ce code spécial ne soit pas une erreur, PhpGedView ne fonctionne pas correctement avec les fichiers comportant ce code. Vous devez laisser PhpGedView supprimer ce code.";
$pgv_lang["invalid_header_help"]		 = "~En-tête de GEDCOM invalide~<br /><br />Un fichier GEDCOM doit commencer par <b>0&nbsp;HEAD</b>. PhpGedView détecte si le fichier GEDCOM que vous êtes en train d'importer n'a pas de <b>0&nbsp;HEAD</b> à la première ligne. Quand vous cliquez le bouton de nettoyage de code, toutes les lignes situées avant la première ligne <b>0&nbsp;HEAD</b> seront supprimées.<br /><br />Cette erreur signifie habituellement que le programme que vous aviez l'habitude d'utiliser pour créer votre GEDCOM ne fonctionnait pas correctement. Vous devriez vérifier que vous téléchargez le bon fichier, et qu'il commence bien par la ligne <b>0&nbsp;HEAD</b> et se termine par la ligne <b>0&nbsp;TRLR</b>.";
$pgv_lang["macfile_detected_help"]  	 = "~Fichier au format Macintosh~<br /><br />PhpGedView a détecté que votre fichier GEDCOM a été créé sur un ordinateur Macintosh.<ul><li>Les fichiers Macintosh terminent chaque ligne par un code de contrôle CR. CR est Ctrl + M.</li><li>Les fichiers Unix terminent chaque ligne par un code de contrôle LF. LF est Ctrl + J.</li><li>Windows et DOS utilisent une séquence à deux codes, CR suivi de LF.</li></ul>PhpGedView nécessite que tous les fichiers utilisent des fins de ligne Unix ou DOS. Lorsque vous cliquez le bouton Nettoyage, vos fins de ligne seront converties en conséquence.";
$pgv_lang["cleanup_places_help"]		 = "~Nettoyage des lieux~<br /><br />PhpGedView a détecté que votre fichier GEDCOM utilisait des balises de nom de lieux de manière erronée.<br /><br />De nombreux programmes de généalogie, comme Family Tree Maker, crééront ce type de fichier GEDCOM. PhpGedView fonctionnera avec ces fichiers GEDCOM, mais des lieux invalides seront affichés dans la hiérarchie des noms de lieux.<br /><br />Par exemple, votre GEDCOM contient l'encodage suivant<div style=\"padding-left: 30px;\">1 SSN<br />2 PLAC 123-45-6789<br />1 OCCU<br />2 PLAC Programmeur</div><br />Selon le standard GEDCOM 5.5.1 le lieu devrait s'afficher tel qu'écrit ici :<div style=\"padding-left: 30px;\">1 SSN 123-45-6789<br />1 OCCU Programmeur</div><br />Si vous sélectionnez <b>Oui</b>, PhpGedView corrigera automatiquement ces erreurs d'encodage ou de format.";
$pgv_lang["empty_lines_detected_help"]  = "~Lignes vides détectées~<br /><br />PhpGedView a détecté des lignes vides dans votre fichier d'entrée. Ces lignes peuvent provoquer des erreurs et doivent être supprimées du fichier avant son importation.";

//-- Edit Config
$pgv_lang["help_editconfig.php"]		 = "~Configurer PhpGedView~<br /><br />Sur cette page vous définissez les paramètres globaux de PhpGedView. Vous devez réaliser ces réglages après avoir installé PhpGedView pour la première fois.<br /><br />#pgv_lang[review_readme]#<br /><br />Comme ces réglages sont <b>globaux</b>, ils s'appliquent au programme en entier et aux différentes bases de données généalogiques que vous utilisez avec PhpGedView.<br /><br />Chaque base de données généalogiques dispose également de ses propres options de configuration que vous pouvez régler en cliquant <b>#pgv_lang[admin_gedcoms]#</b> sur cette page.<br /><br />Vous pouvez également accéder aux fonctions #pgv_lang[gedcom_adm_head]# depuis la page principale d'administration, dont le lien se trouve sous l'icône #pgv_lang[mgv]# ou en en-tête de certaines pages. Sur la page d'administration, le lien approprié se nomme <b>#pgv_lang[manage_gedcoms]#</b>.";

//-- merge records
$pgv_lang["help_edit_merge.php"]		 = "~#pgv_lang[merge_records]#~<br /><br />Cette page vous permettra de fusionner deux enregistrements GEDCOM depuis le même fichier GEDCOM.<br /><br />C'est utile pour les personnes qui ont fusionné plusieurs GEDCOM et constatent maintenant que de nombreux individus, familles ou sources sont en double.<br /><br />La page est décomposée en trois étapes.<br /><ol><li>Vous saisissez les deux IDs des deux GEDCOMs.  Les IDs <u>doivent</u> être du même type.  Vous ne pouvez pas fusionner un individu et une famille ou une famille et une source, par exemple.<br />Dans le champ <b>#pgv_lang[merge_to]#</b> saisissez l'ID de l'enregistrement que vous souhaitez définir comme nouvel enregistrement après la fusion complète des deux enregistrements.<br />Dans le champ <b>#pgv_lang[merge_from]#</b> saisissez l'ID du second dont les informations vont être fusionnées dans le #pgv_lang[merge_to]# enregistrement.  Cet enregistrement sera détruit après la fusion.</li><li>Vous choisissez quels faits vous voulez conserver depuis les deux enregistrements quand ils seront fusionnés. Cochez simplement les cases de ceux que vous souhaitez conserver.</li><li>Vous vérifierez le résultat de la fusion, comme n'importe quelle modification réalisée en ligne.</li></ol>Quelqu'un disposant des droits de validation devra valider votre fusion avant que ces changements soient définitifs.";

//-- report engine
$pgv_lang["help_reportengine.php"]		= "~#pgv_lang[reports]#~<br /><br />Les éléments du menu des rapports généreront des fichiers PDF à imprimer.<br /><br />La première étape consiste à choisir un rapport à exécuter. Après avoir sélectionné un rapport à exécuter, il vous sera demandé de fournir des informations spécifiques à ce rapport, telles que la personne ou la famille avec laquelle commencer et si vous souhaitez ou non afficher des photos. Lorsque vous êtes prêt à exécuter le rapport, cliquez <b>#pgv_lang[download_report]#</b> pour télécharger le rapport sur votre ordinateur.<br /><br />#pgv_lang[help_xml_reports]#<br /><br />#pgv_lang[def_pdf_format_help]#<br /><br />#pgv_lang[help_ahnentafel.xml]#<br /><br />#pgv_lang[help_birthlist.xml]#<br /><br />#pgv_lang[help_relativelist.xml]#";
$pgv_lang["def_pdf_format_help"]		 = "~Format de fichier PDF~<br /><br />Le moteur de rapports de PhpGedView produit des fichiers au format PDF (Adobe) téléchargeables.  Les spécifications du format standard GEDCOM 5.5.1, mentionnées ailleurs dans le fichier d'aide sont également téléchargeables au format PDF.  PDF est un acronyme pour <b>P</b>ortable <b>D</b>ocument <b>F</b>ormat.";
$pgv_lang["help_ahnentafel.xml"]		 = "~#pgv_lang[ahnentafel_report]#~<br /><br />C'est un rapport sur l'individu sélectionné et ses ascendants, imprimé au format du livret de famille. Il commence par le premier individu puis continue avec ses parents, grand-parents, etc.<br /><br />Notez que le rapport «ahnentafel» n'est disponible qu'en anglais à ce jour.";
$pgv_lang["help_birthlist.xml"] 		 = "~#pgv_lang[birth_report]#~<br /><br />Avec ce rapport vous pouvez lister tous les individus qui sont nés à une date donnée ou dans un lieu spécifique.";
$pgv_lang["help_relativelist.xml"]  	 = "~#pgv_lang[relatives_report]#~<br /><br />Ce rapport énuméra tous les parents de l'individu sélectionné. Vous pouvez choisir quels parents seront affichés sur le rapport.<ul><li><b>#pgv_lang[child-family]#</b>&nbsp;&nbsp;&nbsp;affichera les individus sélectionnés, ses parents et ses frères et sœurs.</li><li><b>#pgv_lang[spouse-family]#</b>&nbsp;&nbsp;&nbsp;affichera l'individu avec ses conjoints et leurs enfants.</li><li><b>#pgv_lang[direct-ancestors]#</b>&nbsp;&nbsp;&nbsp;affichera l'individu, ses parents, ses grand-parents, ses arrières grand-parents et ainsi de suite jusqu'au haut de l'arbre, énumérant ainsi tous les individus ancêtres en ligne directe de l'individu sélectionné.</li><li><b>#pgv_lang[ancestors]#</b>&nbsp;&nbsp;&nbsp;affichera tous les individus issus de la liste #pgv_lang[direct-ancestors]# mais également en y incluant oncles et tantes, grands-oncles et grandes-tantes, et en conséquence les enfants des ascendants issus du même arbre généalogique. Il n'affichera pas les enfants issus de cousins.</li><li><b>#pgv_lang[descendants]#</b>&nbsp;&nbsp;&nbsp;affichera la liste des descendants (enfants, petits enfants, arrières petits enfants, etc).</li><li><b>#pgv_lang[all]#</b>&nbsp;&nbsp;&nbsp;cette option est une combinaison de #pgv_lang[descendants]# et de #pgv_lang[ancestors]# dans un seul rapport.</li></ul>";
$pgv_lang["help_xml_reports"]   		 = "~Moteur de rapports~<br /><br />Le moteur de rapports de PhpGedView utilise des modèles XML pour générer automatiquement des rapports au format PDF.<br /><br />Les rapports disponibles dans la liste <b>#pgv_lang[select_report]#</b> sont générés à partir de fichiers XML enregistrés dans le répertoire «reports».  Vous pouvez créer vos propres rapports en faisant une copie de n'importe quel modèle XML fourni et en le modifiant. Pour ajouter votre rapport personnalisé, enregistrez-le simplement dans le répertoire «reports» et PhpGedView le détectera automatiquement, le rendant disponible dans la liste.";

//-- Help Contents
$pgv_lang["help_contents_head_help"]	 = "<b>Sommaire de l'aide</b>";
$pgv_lang["help_contents_gedcom_info"]  = "Informations du fichier GEDCOM";
$pgv_lang["help_contents_gedcom_places"]= "Lieux du fichier GEDCOM";

//-- Admin Help Contents Items
$pgv_lang["admin_help_contents_head_help"]= "<b>Sommaire<br /><br /><span class=\"error\"><small>Note : l'aide pour les fonctions <u>administrateur</u> est en début de la liste.</small></span></b>";
// $pgv_lang["ah1_help"]				 = "_Upgrade";
$pgv_lang["ah2_help"]   				 = "_Configurer PhpGedView";
$pgv_lang["ah3_help"]   				 = "_GEDCOM : Ajouter vs Charger";
$pgv_lang["ah4_help"]   				 = "_GEDCOM : Fichier de Configuration";
$pgv_lang["ah5_help"]   				 = "_GEDCOM : Fichier par Défaut";
$pgv_lang["ah6_help"]   				 = "_GEDCOM : Suppression";
$pgv_lang["ah7_help"]   				 = "_GEDCOM : Ajout";
$pgv_lang["ah8_help"]   				 = "_GEDCOM : Création";
$pgv_lang["ah9_help"]   				 = "_GEDCOM : Réception (download)";
$pgv_lang["ah10_help"]  				 = "_GEDCOM : Administration";
$pgv_lang["ah11_help"]  				 = "_GEDCOM : Configuration";
$pgv_lang["ah12_help"]  				 = "_GEDCOM : Import";
$pgv_lang["ah13_help"]  				 = "_GEDCOM : Envoi sur serveur (upload)";
$pgv_lang["ah14_help"]  				 = "_GEDCOM : Validation";
$pgv_lang["ah15_help"]  				 = "_GEDCOM : Conversion ANSI en UTF-8";
$pgv_lang["ah16_help"]  				 = "_GEDCOM : Règles de confidentialité";
$pgv_lang["ah17_help"]  				 = "_Gestion des utilisateurs";
$pgv_lang["ah18_help"]  				 = "_Administration";
$pgv_lang["ah19_help"]  				 = "_GEDCOM : Outils Média";
$pgv_lang["ah20_help"]  				 = "_GEDCOM : Conversion ID en RIN";
$pgv_lang["ah21_help"]  				 = "_Fichiers de langues";
//           22 is in the help_text_vars.php
$pgv_lang["ah23_help"]  				 = "_Configuration des langues supportées";
$pgv_lang["ah24_help"]  				 = "_Migration des informations de l'utilisateur (Index -->> SQL)";
$pgv_lang["ah25_help"]  				 = "_Sauvegarde (backup) de PhpGedView ";
$pgv_lang["ah26_help"]  				 = "_Liste des FAQ: modification";
		
//--Statistics Help
$pgv_lang["help_statisticsplot.php"]	 = "~Graphiques des Statistiques~<br /><br />C'est la page de résultats, qui montre le graphique des statistiques de votre base de données qui a été réalisé à partir des données d'entrée que vous avez communiquées sur la page précédente.";
$pgv_lang["help_statistics.php"]		 = "~Graphiques des Statistiques~<br /><br />Cette page vous permet de définir les critères qui permettront de produire un affichage graphique de différentes statistiques sur votre base de données généalogiques.";
$pgv_lang["stat_help"]  				 = "~Options pour les Graphiques des Statistiques~<br /><br />Un certain nombre de statistiques sous forme graphique peuvent être produites.<br /><br />Sélectionnez les paramètres à partir des menus, puis ajustez ces options dans la deuxième sélection.<br /><br />Les nombres qui sont proposés dépendent des données qui sont disponibles dans votre base de données. Ainsi, des individus dont on ne connaît pas le mois de naissance (par exemple on sait seulement qu'ils sont nés en 1856) ne pourront pas être inclus dans la staistique des naissances par mois.";
$pgv_lang["stat_help_x"]				= "~Options pour les Graphiques des Statistiques~<br />~axe X~<br /><br />Les options suivantes sont disponibles pour l'axe X (horizontal). Chacun sera ensuite présenté selon les options définies pour les axes Y et Z.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_11_mb]#</b>&nbsp;&nbsp;&nbsp;personnes nées chaque mois.<br /><b>#pgv_lang[stat_12_md]#</b>&nbsp;&nbsp;&nbsp;personnes décédées chaque mois.<br /><b>#pgv_lang[stat_13_mm]#</b>&nbsp;&nbsp;&nbsp;mariages survenus chaque mois.<br /><b>#pgv_lang[stat_14_mb1]#</b>&nbsp;&nbsp;&nbsp;le nombre de premiers-nés pour chaque famille par mois.<br /><b>#pgv_lang[stat_15_mm1]#</b>&nbsp;&nbsp;&nbsp;le nombre de premiers mariages par mois.<br /><b>#pgv_lang[stat_16_mmb]#</b>&nbsp;&nbsp;&nbsp;le nombre de mois entre le mariage et la naissance du premier enfant de ce couple.<br /><b>#pgv_lang[stat_17_arb]#</b>&nbsp;&nbsp;&nbsp;l'âge au décès, lié à la période qui comprend l'année de naissance de chaque personne.<br /><b>#pgv_lang[stat_18_ard]#</b>&nbsp;&nbsp;&nbsp;l'âge au décès, lié à la période qui comprend l'année du décès de chaque personne.<br /><b>#pgv_lang[stat_19_arm]#</b>&nbsp;&nbsp;&nbsp;l'âge moyen des individus au moment de leur mariage.<br /><b>#pgv_lang[stat_20_arm1]#</b>&nbsp;&nbsp;&nbsp;l'âge moyen des individus au moment de leur premier mariage.<br /><b>#pgv_lang[stat_21_nok]#</b>&nbsp;&nbsp;&nbsp;taille moyenne des familles.<br /><b>#pgv_lang[stat_1_map]#</b>&nbsp;&nbsp;&nbsp;placement de toutes les personnes ou personnes portant le nom spécifié, par pays.<br /><b>#pgv_lang[stat_2_map]#</b>&nbsp;&nbsp;&nbsp;pays de naissance.<br /><b>#pgv_lang[stat_4_map]#</b>&nbsp;&nbsp;&nbsp;pays de mariage.<br /><b>#pgv_lang[stat_3_map]#</b>&nbsp;&nbsp;&nbsp;pays de la mort.<br /><b>#pgv_lang[stat_9_indi]#</b>&nbsp;&nbsp;&nbsp;diagramme circulaire de personnes avec des sources.<br /><b>#pgv_lang[stat_8_fam]#</b>&nbsp;&nbsp;&nbsp;diagramme circulaire des familles avec sources.</p>";
$pgv_lang["stat_help_y"]				= "~Options pour les Graphiques des Statistiques~<br />~axe Y~<br /><br />Les options suivantes sont disponibles pour l'axe Y (vertical). Ces options modifient la façon dont les rubriques qui figurent sur l'axe X sont affichées.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_201_num]#</b>&nbsp;&nbsp;&nbsp;affiche le nombre de personnes dans chacune des catégories définie par l'axe X.<br /><b>#pgv_lang[stat_202_perc]#</b>&nbsp;&nbsp;&nbsp;calcule et affiche la proportion de chaque rubrique dans les catégories de l'axe X.</p>";
$pgv_lang["stat_help_z"]				 = "~Options pour les Graphiques des Statistiques~<br />~axe Z~<br /><br />Les options suivantes sont disponibles pour l'axe Z. Ces options fournissent une subdivision des categories qui ont été choisies pour l'axe X.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_300_none]#</b>&nbsp;&nbsp;&nbsp;affiche les rubriques sur une seule colonne pour chaque catégorie de l'axe X.<br /><b>#pgv_lang[stat_301_mf]#</b>&nbsp;&nbsp;&nbsp;affiche les rubriques dans 2 colonnes (homme et femme) pour chaque catégorie de l'axe X.<br /><b>#pgv_lang[stat_302_cgp]#</b>&nbsp;&nbsp;&nbsp;affiche les rubriques dans un nombre de colonnes qui dépend des périodes temporelles qui sont choisies dans la section suivante, pour chaque catégorie de l'axe X.</p>";
$pgv_lang["stat_help_gwx"]  			 = "~Options pour les Graphiques des Statistiques~<br />~limites de l'axe X~<br /><br />Sélectionnez l'intervalle d'âge souhaité.<br /><br />Par exemple, <b>#pgv_lang[aft_marr]#</b> décrit l'ensemble suivant de plages de mois : <div style=\"padding-left: 30px;\">avant le mariage<br />du mariage à 8 mois après<br />de 8 à 12<br />de 12 à 15<br />de 15 à 18<br />de 18 à 24<br />de 24 à 48<br />plus de 48 mois après le mariage</div><br />Lorsque vous souhaitez afficher les trimestres, vous devez choisir <b>#pgv_lang[quarters]#</b>.";
$pgv_lang["stat_help_gax"]				= "~Options pour les Graphiques des Statistiques~<br />~limites de l'axe X~<br /><br />Sélectionnez l'intervalle d'âge souhaité.<br /><br />Par exemple, <b>intervalle 10 ans</b> décrit l'ensemble de tranches d'âge suivant :<div style=\"padding-left: 30px;\">moins d'un an<br />un an à 5 ans<br />6 à 10<br />11 à 20<br />21 à 30<br />31 à 40<br />41 à 50<br />51 à 60<br />61 à 70<br />71 à 80<br />81 à 90<br />91 à 100<br />plus de 100 ans</div>";
$pgv_lang["stat_help_gbx"]				= "~Options pour les Graphiques des Statistiques~<br />~limites de l'axe X~<br /><br />Sélectionnez l'intervalle d'âge souhaité.<br /><br />Par exemple, <b>intervalle 2 ans</b> décrit l'ensemble de tranches d'âge suivant :<div style=\"padding-left: 30px;\">moins de 16 ans<br />16 à 18<br />19 à 20<br />21 à 22<br />23 à 24<br />25 à 26<br />27 à 28<br />29 à 30<br />31 à 32<br />33 à 35<br />36 à 40<br />41 à 50<br />plus de 50 ans</div>";
$pgv_lang["stat_help_gcx"]				= "~Options pour les Graphiques des Statistiques~<br />~limites de l'axe X~<br /><br />Sélectionnez l'intervalle de comptage souhaité.<br /><br />Par exemple, <b>intervalle un enfant</b> décrit l'ensemble suivant de plages de comptage enfants :<div style=\"padding-left: 30px;\">sans enfants<br />un enfant<br />deux enfants<br />3, 4, 5, 6, 7, 8, 9, 10 enfants<br />plus de 10 enfants</div>";
$pgv_lang["stat_help_gwz"]				= "~Options pour les graphiques statistiques~<br />~limites de l'axe Z~<br /><br />Sélectionnez l'année de début et l'intervalle souhaités.<br /><br />Par exemple, <b>à partir de 1700 intervalle 50 ans</b> décrit l'ensemble de plages de dates suivant :<div style=\"padding-left: 30px;\">avant 1700<br />1700 à 1749<br />1750 à 1799<br />1800 à 1849<br />1850 à 1899<br />1900 à 1949<br />1950 à 1999<br />2000 ou plus tard</div>";
$pgv_lang["chart_type_help"]			= "~Options pour les Graphiques des Statistiques~<br /><br />Sélectionnez ce que vous voulez voir sur la carte. Vous pouvez choisir :<div style=\"padding-left: 25px\"><b>#pgv_lang[indi_distribution_chart]#</b>&nbsp;&nbsp;&nbsp;indique les pays dans lesquels se trouvent les personnes de cette base de données.<br /><b>#pgv_lang[surname_distribution_chart]#</b>&nbsp;&nbsp;&nbsp;indique les pays dans lesquels le nom de famille spécifié apparaît.</div>";
$pgv_lang["google_chart_surname_help"]	= "~Options pour les Graphiques des Statistiques~<br /><br />Le nombre d'occurrences du nom spécifié sera affiché sur la carte. Si vous laissez ce champ vide, le nom de famille le plus fréquent sera utilisé.";
$pgv_lang["chart_area_help"]			= "~Options pour les graphiques statistiques~<br /><br />Sélectionnez la zone géographique que vous souhaitez voir sur la carte. Vous pouvez choisir :<div style=\"padding-left: 25px\"><b>#pgv_lang[world_chart]#</b>&nbsp;&nbsp;&nbsp;montre tous les continents.<br /><b>#pgv_lang[europe_chart]#</b>&nbsp;&nbsp;&nbsp;montre l'Europe.<br /><b>#pgv_lang[s_america_chart]#</b>&nbsp;&nbsp;&nbsp;montre l'Amérique du Sud.<br /><b>#pgv_lang[asia_chart]#</b>&nbsp;&nbsp;&nbsp;montre l'Asie.<br /><b>#pgv_lang[middle_east_chart]#</b>&nbsp;&nbsp;&nbsp;montre le Moyen-Orient.<br /><b>#pgv_lang[africa_chart]#</b>&nbsp;&nbsp;&nbsp;montre l'Afrique.</div>";

//-- Find Media Help
$pgv_lang["manage_media_help"]  		 = "~#pgv_lang[manage_media]#~<br /><br />Sur cette page vous pouvez facilement gérer vos fichiers média et vos répertoires média.<br /><br />Quand vous créez un nouveau sous-répertoire média, PhpGedView s'assure que la structure des sous-répertoires est maintenue dans le répertoire <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs</b>.  Quand vous téléchargez un nouveau fichier média, PhpGedView peut automatiquement créer la vignette de l'image pour vous.<br /><br />Près de chaque image, dans la liste des média, vous trouverez les options suivantes. Les options actuellement affichées dépendent du statut en cours du média.<ul><li><b>#pgv_lang[edit]#</b>&nbsp;&nbsp;&nbsp;Quand vous validez cette option, vous verrez une page où vous pourrez changer le titre de l'objet média. Si l'objet média n'est pas encore lié à un individu, à une famille ou à une source dans la base de données courante, vous pouvez définir un lien ici.  Vous pouvez renommer le fichier ou même changer son emplacement dans la structure de répertoire <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Si nécessaire, PhpGedView crééra le sous-répertoire requis ou n'importe quelle vignette manquante.</li><li><b>#pgv_lang[edit_raw]#</b>&nbsp;&nbsp;&nbsp;Cette option est seulement disponible si l'administrateur l'a activé.  Vous pouvez voir ou éditer l'enregistrement GEDCOM associé au média. Vous devez être prudent quand vous utilisez cette option.</li><li><b>#pgv_lang[delete_file]#</b>&nbsp;&nbsp;&nbsp;Cette option vous permet d'effacer tous les média de la base de données courante. Les autres bases de données ne seront pas affectées. Si des fichiers média ne sont liés à aucune base de données, le fichier et sa vignette seront supprimés.</li><li><b>#pgv_lang[remove_object]#</b>&nbsp;&nbsp;&nbsp;Cette option vous permet de supprimer tous les fichiers média dans la base de données courante.  Les autres bases de données ne seront pas affectées. Les fichiers média, et les vignettes associées, ne seront pas supprimés.</li><li><b>#pgv_lang[remove_links]#</b>&nbsp;&nbsp;&nbsp;Cette option vous permet de supprimer tous les liens entre les fichiers média et la base de données courante.  Les fichiers ne seront pas supprimés, et les objets média connus dans la base de données seront maintenus. Les autres bases de données ne seront pas affectées.</li><li><b>#pgv_lang[set_link]#</b>&nbsp;&nbsp;&nbsp;Cette option vous permet d'établir des liens entre les fichiers média et les individus, familles, ou sources de la base de données courante. Si nécessaire, PhpGedView générera l'objet média par lequel le fichier média est connu dans la base de données.</li><li><b>#pgv_lang[gen_thumb]#</b>&nbsp;&nbsp;&nbsp;Quand vous sélectionnez cette option, PhpGedView générera les vignettes manquantes.</li></ul>";
$pgv_lang["simple_filter_help"] 		 = "~#pgv_lang[filter]#~<br /><br />Recherche simple à partir des caractères saisis, aucun joker n'est accepté.";
$pgv_lang["show_thumb_help"]			 = "~#pgv_lang[show_thumbnail]#~<br /><br />Les vignettes seront affichées si vous cochez cette case.";
$pgv_lang["find_media_help"]			 = "~#pgv_lang[find_media]#~<br /><br />Ceci vous permet de réaliser une recherche dans la structure des répertoires pour trouver le média que vous voulez lier.";
		
//-- Add / Edit Media Help
$pgv_lang["add_media_linkid"]   		 = "~ID de lien~<br /><br />Chaque objet Multimédia devrait être associé à un ou plusieurs individus, une famille ou une source dans votre base de données.<br /><br />Pour établir un tel lien, vous pouvez saisir ou rechercher l'ID de l'individu, de la famille ou de la source en même temps que vous créez l'objet Multimédia.  Vous pouvez également établir le lien plus tard en éditant les options sur la page de gestion des objets Multimédia, ou en ajoutant des objets Multimédia grâce au lien d'ajout d'un objet Multimédia, disponible sur les pages consacrées aux détails de l'individu, de la famille ou des sources.";
$pgv_lang["upload_server_file_help"]	 = "~#pgv_lang[server_file]#~<br /><br />Le fichier Multimédia que vous avez téléchargé peut, et probablement devrait, porter un nom différent sur le serveur que celui qu'il portait sur votre ordinateur personnel. Ce changement de nom est conseillé car vous aviez donné un nom à votre fichier en local en fonction de vos besoins personnels (signification particulière du nom pour vous), alors qu'une fois enregistré sur le site, le nom du fichier aura perdu toute signification pour les autres utilisateurs de ce site.  Prenez en compte également la possibilité que quelqu'un tente de télécharger différents objets Multimédia tous nommés «grandpapa.jpg».<br /><br />Dans ce champ, vous spécifiez un nouveau nom pour le fichier que vous téléchargez. Le nom que vous saisissez ici sera également utilisé par la vignette, qui peut être téléchargée séparément ou générée automatiquement. Vous n'avez pas besoin de saisir l'extension du fichier (jpg, gif, pdf, doc, etc.)<br /><br />Laissez ce champ vide pour conserver le nom original du fichier que vous téléchargez.";
$pgv_lang["upload_server_folder_help"]  = "~#pgv_lang[server_folder]#~<br /><br />L'administrateur a autorisé #GLOBALS[MEDIA_DIRECTORY_LEVELS]# niveaux de répertoires en dessous du niveau par défaut <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Ceci pour vous aider à organiser vos fichiers Multimédia et réduire le risque de conflits de noms de fichiers.<br /><br />Dans ce champ, vous précisez le répertoire de destination où le fichier Multimédia sera enregistré. Le fichier vignette rattaché, qu'il soit téléchargé séparément ou généré automatiquement, sera enregistré dans un répertoire identique commençant par <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> au lieu de <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.  Vous n'avez pas besoin de saisir la portion <b>#GLOBALS[MEDIA_DIRECTORY]#</b> du nom du répertoire de destination.<br /><br />Si vous n'êtes pas certain de ce que vous devez saisir ici, vous devez contacter l'administrateur du site pour des conseils.";
$pgv_lang["view_server_folder_help"]	 = "~#pgv_lang[server_folder]#~<br /><br />L'administrateur a autorisé jusqu'à #GLOBALS[MEDIA_DIRECTORY_LEVELS]# niveaux de répertoire en dessous du répertoire par défaut <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Cela vous facilite l'organisation des fichiers Multimédia et réduit la possibilité de conflits de noms.<br /><br />Dans ce champ, vous choisissez le répertoire des objets Multimédia dont vous voulez afficher le contenu.  Quand vous choisissez <b>#pgv_lang[all]#</b>, tous les fichiers Multimédia seront affichés automatiquement indépendamment du répertoire dans lequel ils se trouvent. Cela peut produire une liste très longue de fichiers Multimédia.";

//--Repository Help
$pgv_lang["help_repolist.php"]  		 = "~#pgv_lang[repo_list]#~<br /><br />Une liste de dépôts d'archives est affichée sur cette page.<br /><br />Les noms des dépôts sont classés par ordre alphabétique.<br /><br /><b>DÉPÔTS</b><br />Sans archives, nous ne pourrions construire cette base de données. Il existe une source pour chaque information enregistrée dans cette base de données. Un dépôt d'archives peut correspondre à des archives personnelles, familiales, aux archives notariales ou départementales, à celles de la mairie ou appartenir à une institution, une administration gouvernementale, une église, une ressource Internet, etc. Pour obtenir l'accès à une source, en connaître son lieu de dépôt et ses références (cotes), les sources d'archives doivent être renseignées. Toutes les informations permettant d'identifier les sources doivent être enregistrées.<br /><br />Une source peut être liée à plusieurs individus.";
$pgv_lang["help_repo.php"]  			 = "~#pgv_lang[repo_info]#~<br /><br />Les détails de l'archive sont affichés ici. De la même manière que les sources, les archives sont très importants pour les généalogistes.  Grâce à une information précise sur la source et le dépôt d'archives utilisés, vous pouvez suivre pas à pas un autre généalogiste pour trouver ou contrôler les informations que vous cherchez. Vous devez être capable de retrouver les mêmes informations en utilisant à nouveau les mêmes sources.<br /><br />Sur cette page, sont affichées le titre du dépôt d'archives, son adresse, une adresse email et l'adresse Internet d'un site web.<br /><br />Après cette liste détaillée des informations sur le dépôt d'archives, est affichée une liste de toutes les sources liées à ce dépôt. Cette liste vous permet de prendre connaissance de toutes les informations ou archives utilisées à partir d'un centre d'archives.<br /><br />Si cette option a été active par l'administrateur, vous disposerez d'une ou de deux icônes supplémentaires sur cette page (menu) :<ul><li><b>#pgv_lang[view_gedcom]#</b>, qui affiche l'information dans le format GEDCOM.</li><li><b>#pgv_lang[add_to_cart]#</b>, qui vous permet de stocker l'information dans votre #pgv_lang[clip_cart]#. À partir d'ici vous pouvez télécharger l'information dans un fichier au format GEDCOM et l'importer dans votre propre programme de généalogie.</li></ul><br />#pgv_lang[context_help]#";
$pgv_lang["delete_repo_help"]   		 = "~#pgv_lang[delete_repo]#~<br /><br />Quand vous cliquez sur cette option, vous indiquez que ce dépôt d'archives doit être supprimé de la base de données.<br /><br />Qu'est-ce que cela signifie ? Supposons que vous avez de bonnes raisons de supprimer ce dépôt de la base de données. Vous cliquez le lien. Il vous sera demandé de confirmer votre demande de suppression. Si vous poursuivez la consultation du site, vous noterez que le dépôt est toujours visible et peut être utilisé comme s'il n'avait pas été supprimé.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["show_repo_gedcom_help"]  	 = "~#pgv_lang[view_gedcom]#~<br /><br />Quand vous cliquez ce lien, les informations à propos du dépôt d'archives, telles qu'enregistrées dans la base de données, sont affichées dans une fenêtre popup.";
$pgv_lang["add_repository_clip_help"]   = "~#pgv_lang[add_to_cart]#~<br /><br />Quand vous cliquez ce lien, vous pouvez ajouter le dépôt d'archives, tel qu'il est enregistré dans le GEDCOM, à votre #pgv_lang[clip_cart]#.";
$pgv_lang["repolist_listbox_help"]  	 = "~#pgv_lang[repo_list]#~<br /><br />Dans cette case sont affichés les noms des dépôts d'archives tels qu'ils sont enregistrés dans la base de données. Les noms sont affichés dans l'ordre alphabétique.<br /><br />Si vous cliquez un nom dans la liste, la page #pgv_lang[repo_info]# sera affichée et vous pourrez y découvrir la liste des sources d'archives qui sont liées à ce dépôt.";
$pgv_lang["repos_listbox_help"] 		 = "~#pgv_lang[other_repo_records]#~<br /><br />Dans cette case, s'affichent les noms des sources qui sont liées à un dépôt d'archives. Les noms sont affichés par ordre alphabétique.<br /><br />Si vous cliquez un nom dans la liste, vous obtiendrez l'affichage des détails de la source.";

// Index-Edit
$pgv_lang["block_move_up_help"] 		 = "~Déplacer les entrées d'une liste~<br /><br />Utilisez ces boutons pour réorganiser la séquence d'affichage des entrées dans la liste. Les listes seront imprimées dans la séquence dans lequel elles sont affichées.<br /><br />Sélectionnez l'entrée de la liste que vous souhaitez déplacer, puis cliquez l'un des boutons pour l'abaisser ou la remonter.";
$pgv_lang["block_move_right_help"]  	 = "~Déplacer les entrées d'une liste~<br /><br />Utilisez ces boutons pour déplacer une entrée d'une liste vers une autre.<br /><br />Sélectionnez l'entrée à déplacer, puis cliquez le bouton pour déplacer ou copier cette entrée dans la direction de la flèche.  Utilisez les boutons <b>»</b> et <b>«</b> pour déplacer l'entrée sélectionnée de l'extrême gauche vers l'extrême droite de la liste ou vice-versa. Utilisez les boutons <b>&gt;</b> et <b>&lt;</b> pour la déplacer entre la liste #pgv_lang[available_blocks]# et la liste à sa droite ou à sa gauche.<br /><br />Les entrées dans la liste #pgv_lang[available_blocks]# ne changent pas, indépendamment de ce que vous faites avec les boutons #pgv_lang[move_right]# et #pgv_lang[move_left]#.  C'est parce que le même bloc peut apparaître plusieurs fois sur la même page. Le bloc HTML est un bon exemple du pourquoi d'une telle manipulation.";
$pgv_lang["block_default_index"]		 = "~Blocs par défaut de la page #pgv_lang[welcome]#~<br /><br />Quand vous supprimez toutes les entrées des listes #pgv_lang[main_section]# et #pgv_lang[right_section]#, ou quand vous cliquez <b>#pgv_lang[reset_default_blocks]#</b>, le bloc de listes sera organisé comme suit :<br /><br /><span class='center'><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[block_cookiepolicy]#<br />#pgv_lang[gedcom_stats_block]#<br />#pgv_lang[gedcom_news_block]#<br />#pgv_lang[gedcom_favorites_block]#<br />#pgv_lang[review_changes_block]#</td><td>#pgv_lang[gedcom_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[todays_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></span>";
$pgv_lang["block_default_portal"]   	 = "~Bloc par défaut de la page #pgv_lang[mygedview]#~<br /><br />Quand vous supprimez toutes les entrées depuis les listes #pgv_lang[main_section]# et #pgv_lang[right_section]#, ou quand vous cliquez <b>#pgv_lang[reset_default_blocks]#</b>, le bloc de listes sera organisé comme suit :<br /><br /><span class='center'><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[todays_events_block]#<br />#pgv_lang[user_messages_block]#<br />#pgv_lang[user_favorites_block]#<br />&nbsp;</td><td>#pgv_lang[welcome_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[upcoming_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></span>";

// FAQ page
$pgv_lang["help_faq.php"]   			 = "~Questions Fréquemment Posées~<br /><br />#pgv_lang[text_faq_help]#";
$pgv_lang["text_faq_help"]  			 = "La page FAQ (Questions Fréquemment Posées) peut contenir une vue d'ensemble du site ou une liste de questions et de réponses sur son utilisation.<br /><br />Le mode d'utilisation de la page FAQ est du ressort de l'administrateur. L'administrateur du site en contrôle le contenu ainsi que l'organisation.";
		
// Help search
$pgv_lang["hs_title_help"]  			 = "<span class='center'>~#pgv_lang[hs_title]#~</span><br />#pgv_lang[hs_intro]#<br /><br />#pgv_lang[hs_keyword_advice]#<br /><br />#pgv_lang[hs_searchhow_advice]#<br /><br />#pgv_lang[hs_searchin_advice]#";
$pgv_lang["hs_intro"]   				 = "Vous pouvez effectuer des recherches approfondies dans le système d'aide de PhpGedView.  Le dispositif #pgv_lang[hs_title]# vous permet un haut degré de contrôle sur les fonctions de recherche ; vous devriez pouvoir trouver ce que vous recherchez facilement.";
$pgv_lang["hs_keyword_advice"]  		 = "~#pgv_lang[hs_keyword]#~<br /><br />Vous saisissez la phrase ou les mots que vous recherchez.<br /><br />Le système de recherche ne tient pas compte des minuscules et majuscules des termes saisis pour la recherche. Ce qui signifie que si vous avez entré <b>Individu</b>, vous pourrez trouver le texte contenant <b>Individu</b>, <b>individu</b>, ou <b>INDIVIDU</b>.  Vous pourrez obtenir également un résultat contenant <b>individus</b>, etc, étant donné que le mode de recherche s'attache à la recherche d'une chaine de caractères et non de mots.<br /><br />Vous pouvez rechercher plusieurs mots en même temps. Saisissez tous les mots sur lesquels porte votre recherche, séparés par un espace, comme ceci : <b>individu&nbsp;famille&nbsp;enfant</b>.  Quand plus d'un mot est saisi, la signification de ce que vous avez entré est clarifiée dans le champ #pgv_lang[hs_searchhow]#.";
$pgv_lang["hs_searchin_advice"] 		 = "~#pgv_lang[hs_searchin]#~<br /><br />Vous déterminez la portée de votre recherche ici.<br /><br />Les administrateurs ont le choix d'utiliser le mode de recherche utilisateur ou l'aide avancée ou les deux.  Les utilisateurs n'ont pas ce choix ; parce qu'ils n'ont aucun accès à la configuration du site, ils ne peuvent utiliser que le mode de recherche utilisateur (fichier d'aide aux utilisateurs).<br /><br />Les fichiers d'aide contiennent non seulement le texte d'aide mais également certains codes utilisés pour générer des formulaires ou d'autres contenus. Cette option vous permet de contrôler si le fichier d'aide peut être lu en entier ou si uniquement le texte d'aide devrait être analysé.";
$pgv_lang["hs_searchhow_advice"]		 = "~#pgv_lang[hs_searchhow]#~<br /><br />Vous clarifiez le sens de ce que vous avez saisi dans le champ #pgv_lang[hs_keyword]# en sélectionnant l'une des options présentées ici.<br /><br /><dl><dt><b>#pgv_lang[hs_searchany]#</b></dt><dd>Si vous avez saisi <b>individu&nbsp;famille&nbsp;enfant</b>, cette option trouvera le texte d'aide qui contient un des mots énumérés.  L'ordre des mots n'a pas d'importance. Le sens de la recherche est : «Trouvez le texte d'aide contenant les mots <b>individu</b> <u>ou</u> <b>famille</b> <u>ou</u> <b>enfant</b>».</dd><dt><b>#pgv_lang[hs_searchall]#</b></dt><dd>Si vous avez saisi <b>individu&nbsp;famille&nbsp;enfant</b>, cette option trouvera le texte d'aide qui contient tous les mots saisis.  L'ordre des mots n'a pas d'importance. Le sens de la recherche est : «Trouvez le texte d'aide contenant les mots <b>individu</b> <u>et</u> <b>famille</b> <u>et</u> <b>enfant</b>».</dd><dt><b>#pgv_lang[hs_searchsentence]#</b></dt><dd>Si vous avez saisi <b>individu&nbsp;famille&nbsp;enfant</b>, cette option trouvera le texte d'aide contenant tous les mots saisis dans la séquence indiquée.  Le sens de cette recherche est : «Trouvez le texte d'aide contenant les mots <b>individu&nbsp;famille&nbsp;enfant</b> dans cet ordre sans d'autres mots ou caractères entre eux».  Vous ne trouverez probablement pas cette suite de mots dans tout le texte d'aide.</dd></dl><br />Il existe quelques limites à ce type de recherche. Certains caractères spéciaux comme <b>&quot</b> ou <b>&lt</b> ou <b>&gt;</b> etc. sont contenus dans le texte d'aide sous forme informatique et ne seront pas trouvés si ils font partie du texte que vous entrez.  Quelques textes d'aide contiennent un genre spécial d'espace représenté par <b>&amp;nbsp;</b> et vous ne pourrez pas trouver les phrases contenant ce symbole.";

// Directory cleanup tool
$pgv_lang["help_dir_editor.php"]		 = "~#pgv_lang[index_dir_cleanup]#~<br /><br />Cet outil peut aider l'administrateur du site à supprimer les fichiers qui sont présents dans le répertoire Index.<br /><br />Au fur et à mesure de l'utilisation du programme PhpGedView, des fichiers tels que les fichiers de logs, les anciens fichiers GEDCOM, et les anciens fichiers de sauvegarde viennent encombrer le répertoire index.  Puisque beaucoup de ces fichiers sont générés par le programme, ils peuvent être la propriété de l'utilisateur du serveur web. S'ils sont la propriété de l'utilisateur du serveur web, vous pouvez ne pas disposer des droits suffisants pour les supprimer. Cet outil vous permet de supprimer ces fichiers même s'ils sont la propriété de l'utilisateur du serveur web.<br /><br />#pgv_lang[index_dir_cleanup_inst]#";

// Various quotes -- The actual text is in help_text.en.php
//$pgv_lang["quote_gedcom"]						= "";
//$pgv_lang["quote_gramps"]						= "";
?>
