<?php
/**
 * Dutch Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2024  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @package PhpGedView
 * @subpackage Languages
 * @authors Erik Bent, Jans B. Luder, Boudewijn Sjouke, Eduard Wustenveld
 * @version $Id: help_text.nl.php 7378 2024-11-02 14:25:09Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["useradmin_comment_help"]	= "~#pgv_lang[comment]#~<br /><br />De hier ingevoerde tekst wordt weergegeven wanneer uw muisaanwijzer op het tekstpictogram in de gebruikerslijst staat. Probeer deze tekst zo kort mogelijk te houden.";
$pgv_lang["useradmin_comment_exp_help"]	= "~#pgv_lang[comment_exp]#~<br /><br />Voer de datum in waarna het record van deze gebruiker moet worden beschouwd als inspectie door de beheerder. Deze records worden gemarkeerd in de gebruikerslijst door de gebruikersnaam in <span class='warning'>rood</span> weer te geven.<br /><br />De datum moet in het Engels worden ingevoerd. Voorbeelden: <b>31&nbsp;DEC&nbsp;2020</b> ; <b>31&nbsp;december&nbsp;2020</b> ; <b>2020.12.31</b> ; <b>31-12-2020</b> ; <b>12/31/2020</b> enz.<br /><br />Wanneer het maandnummer en het dagnummer beide tussen 1 en 12 liggen, bepaalt de interpunctie (streepje of schuine streep) de betekenis, met een streepje <b>-</b> om aan te geven dat het eerste nummer de dag van de maand is, terwijl een schuine streep <b>/</b> betekent dat het eerste cijfer de maand is.<br /><br />Als de hier ingevoerde informatie geen betekenis heeft voor het programma, wordt «yesterday» gebruikt en deze gebruiker record wordt altijd geselecteerd om te markeren. «tomorrow» en soortgelijke teksten zijn in deze context niet zinvol en zullen ertoe leiden dat dit gebruikersrecord nooit wordt geselecteerd om te markeren.";
$pgv_lang["file_type_help"]					= "~#pgv_lang[choose_file_type]#~<br /><br />Kies het formaat waarin de te exporteren gegevens worden opgeslagen.  Uw keuze zal afhangen van de mogelijkheden en eisen van het programma, waarin u het gedownloade bestand wilt importeren.  U kunt kiezen uit:<br /><ul><li>#pgv_lang[def_gedcom_help]#<br /><br /></li><li>#pgv_lang[def_gramps_help]#</li></ul>";
$pgv_lang["apply_privacy_help"]				= "~#pgv_lang[apply_privacy]#~<br /><br />Als deze optie is aangevinkt, zal het, te exporteren bestand, worden onderworpen aan de privacyregels volgens de geslecteerde optie.  Dit kan er toe leiden dat bepaalde informatie wordt verwijderd.  Het te exporteren bestand kan alleen de gegevens bevatten, die zichtbaar zijn voor een gebruiker met rechten zoals aangegeven.<br /><br />Als u bijvoorbeeld de rechten heeft van een #pgv_lang[gedadmin]#, kunt u niet aangeven dat het te exporteren bestand gegevens mag bevatten volgens de privileges van de #pgv_lang[siteadmin]#.";
$pgv_lang["convertPath_help"]				= "~#pgv_lang[convertPath]#~<br /><br />Deze optie stelt een  constant pad in, dat aan het begin van alle media-paden wordt toegevoegd, in het te exporteren bestand.<br /><br />Bijvoorbeel: als het media-pad, op de server, is ingesteld als \"/media\" en het te exporteren media-bestandand heeft als pad en naam:  \"/media/pictures/xyz.jpg\" en u heeft in het veld ingevuld: <b>\"c:\\mijn afbeeldingen\\mijn familie\"</b> , zal het resultaat van het media-pad zijn: <b>\"c:\\mijn afbeeldingen\\mijn familie/pictures/xyz.jpg\"</b>.<br /><br />Het volgende valt op in dit voorbeeld:<ul><li>De naam van de huidige media map is verwijderd uit het pad.</li><li>Het resulterende pad bevat <b>niet</b> de correcte map-naam separatoren.</li></ul><br />Als u de huidige media-pad namen wilt behouden in het te exporteren bestand, moet u die media-pad namen eveneens invullen in het veld: <b>#pgv_lang[convertPath]#</b>.<br /><br />Omdat de seperatoren niet correct zijn moet u ook de optie <b>#pgv_lang[convertSlashes]#</b> gebruiken. Dit om er zeker van te zijn dat de map-naam separatoren consistent zijn en overeen komen met vereisten van het ontvangende besturingssystem.<br /><br />Media paden die in feite URL's zijn (web adressen) zullen niet worden gewijzigd.";
$pgv_lang["convertSlashes_help"]			= "~#pgv_lang[convertSlashes]#~<br /><br />Deze optie bepaald of de mappen-namen in de BESTANDS-specificatie van de media objecten moet worden gescheiden door slashes (Schuine Streep Voorwaarts) of door backslashes (Schuine Streep Achterwaarts).  Uw keuze hangt af van de eisen van het besturingssysteem, waarop u de bestanden.<br /><br />De keuze <b>#pgv_lang[forwardSlashes]#</b> is van toepassing op de meeste besturingssystemen, behalve Microsoft Windows.  De keuze <b>#pgv_lang[backSlashes]#</b> moet worden gebruikt als het bestemmingsprogramma draait op een Microsoft Windows systeem.<br /><br />Media paden die in feite URL's zijn (web adressen) zullen niet worden gewijzigd.";
$pgv_lang["medialist_recursive_help"]		= "~#pgv_lang[medialist_recursive]#~<br /><br />Als deze optie is geselecteerd, zal #pgv_lang[multi_title]# niet slechts de map, die u koos uit de #pgv_lang[filter]# lijst, maar ook alle submappen doorzoeken.<br />Als deze optie niet is geselecteerd, zal alleen de geselecteerde map worden doorzocht.<br /><br />De titels, van alle gevonden media objecten, worden dan gecontroleerd om te bepalen of ze de tekst bevatten, die is ingevoerd in het #pgv_lang[filter]#.<br />Het resultaat van deze twee acties is bepalend welke multimedia objecten op de lijst worden gezet.";
$pgv_lang["medialist_unlinked_help"]		= "~#pgv_lang[medialist_unlinked]#~<br /><br />Alleen media die niet aan een GEDCOM-record zijn gekoppeld, worden weergegeven.";
$pgv_lang["medialist_current_dir_help"]		= "~#pgv_lang[medialist_current_dir]#~<br /><br />Selecteer de media-submap die u wilt bekijken.";
$pgv_lang["sortby_help"]					= "~#pgv_lang[sortby]#~<br /><br />Selecteer de volgorde waarin u de lijst wilt zien.";
$pgv_lang["help_treenav.php"]				= "~#pgv_lang[interactive_tree]#~<br /><br />Gebruik de #pgv_lang[interactive_tree]# om de hele stamboom van een persoon te bekijken, in beide richtingen.  Dit beeld is ongeveer gelijk aan het #pgv_lang[hourglass_chart]#, dat zowel de voorouders en nakomelingen van een bepaalde startpersoon laat zien.  Dit diagram laat u een compacter beeld zien, door vakken te laten zien voor paren of gezinnen i.p.v. personen.<br /><ul><li><b>Scrollen</b><br />Als de muis-cursor verandert in een ikoontje voor verplaatsen, kunt u op het diagram klikken en deze verslepen om andere gedeelten van de stamboom te laten zien.  Als u de stamboom versleept, worden er meer delen van de stamboom zichtbaar, tot er niet meer generaties in het bestand zitten.<br /></li><li><b>Zoom</b><br />U kunt de ikoontjes, aan de linkerzijde van de stamboom, gebruiken om in- of uit te zoomen.  Door uit te zoomen, kunt u meer delen van de stamboom op het scherm zichtbaar maken. De tekst kan dan echter slecht leesbaar waren; als u met de muisaanwijzer over een vakje, wordt dit vergroot.<br /></li><li><b>Details uitvergroten</b><br />As u op een vakje klik, wordt het vakje vergroot en toont meer details.  Als het vakje vergroot is en u vervolgens op een naam klikt gaat u naar de #pgv_lang[indi_info]# pagina van die persoon.  Door op de  <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> te klikken, wordt de stamboom weer opnieuw getekent, met die persoon als nieuwe startpersoon.  Door op de <img src='#GLOBALS[PGV_IMAGE_DIR]#/buttons/family.gif' alt='' /> te klikken gaat u naar detaisl pagina van het gezin.<br /></li><li><b>Partner Aan - Uit</b><br />De <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/sfamily.gif' width='15px' height='15px' alt='' /> ikoon, onder de  Zoom knoppen, zal het tonen van alle partners aan of uit zetten.  Als het is ingesteld om alle partners te tonen, zullen alle partners van een persoon worden getoond, evenals al diens kinderen. Als het is ingesteld om niet alle partners te tonen, zal alleen de laatste partner van een persoon worden getoond, alsmede de kinderen die ze samen hadden.<br /></li><li><b>Grote stamboom</b><br />De #pgv_lang[interactive_tree]# is beschikbaar vanaf diverse pagina's, inclusief de Boom Tab op de #pgv_lang[indi_info]# pagina en het Diagram blok op de Welkom pagina (indien het daar wordt getoond).  Als u de stamboom vanaf een van die pagina's bekijkt, heeft u eveneens een boom-ikoontje onder de Zoom knoppen.  Als u op de  <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> klikt gaat u naar de #pgv_lang[interactive_tree]# pagina.</li></ul>";

$pgv_lang["move_mediadirs_help"]			= "~#pgv_lang[move_mediadirs]#~<br /><br />Als de Media Firewall is ingeschakeld kunnen Multi-Media bestanden worden opgeslagen in een map, op de server, die niet toegankelijk is vaanaf het Internet.<br /><br />Met deze knoppen kunt u op eenvoudige wijze een complete Media mappen structuur verplaatsen tussen de beschermde (niet web-adresseerbaar) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> en de normale <b>#GLOBALS[MEDIA_DIRECTORY]#</b> mappen.";
$pgv_lang["setperms_help"]					= "~#pgv_lang[setperms]#~<br /><br />Stel de permissies in voor de beschermde (niet web-adresseerbaar) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> en de gewone <b>#GLOBALS[MEDIA_DIRECTORY]#</b> mappen als wereld-beschrijfbaar of alleen lezen.";
$pgv_lang["update_CHAN_text"] 				= "Beheerders moeten soms de door gebruikers ingediende gegevens opschonen en corrigeren. Ze moeten bijvoorbeeld mogelijk de PLAC-locatie corrigeren om het land op te nemen. Wanneer beheerders dergelijke correcties aanbrengen, wordt informatie over de oorspronkelijke wijziging normaal gesproken vervangen. Dit is misschien niet wenselijk.<br /><br />Wanneer deze optie wordt gekozen tijdens de bewerkings- of correctiesessie van de beheerder, zal PhpGedView de oorspronkelijke wijzigingsinformatie behouden in plaats van deze te vervangen door die van de huidige sessie.";
$pgv_lang["config_update_CHAN_help"] 		= "~#pgv_lang[no_update_CHAN]#~<br /><br />Deze optie regelt de beginstatus van het vakje «#pgv_lang[no_update_CHAN]#» dat wordt weergegeven op elke pagina waar beheerders wijzigingen of correcties kunnen aanbrengen in de genealogische database.<br /><br />#pgv_lang[update_CHAN_text]#.";
$pgv_lang["no_update_CHAN_help"] 			= "~#pgv_lang[no_update_CHAN]#~<br /><br />#pgv_lang[update_CHAN_text]#";
$pgv_lang["edit_SOUR_EVEN_help"]			= "~#pgv_lang[source_events]#~<br /><br />Elke bron legt specifieke gebeurtenissen vast, vaak binnen een bepaald tijdsbestek en voor een bepaald rechtsgebied. Voorbeelden zijn:  een volkstelling legt de daarvoor relevante gebeurtenissen vast; kerkelijke registers leggen de gebeurtenissen rond geboorte, doop, huwelijk en dood vast.<br /><br />Selecteer de gebeurtenissen, welke door deze bron zijn vastgelegd, uit de aangeboden gebeurtenissen-lijst. De datum moet worden ingevoerd in een bereik-formaat, zoals <i>VAN 1900 TOT 1910</i>. De plaats jurisdictie is de naam van de laagste jurisdictie die alle lagere plaatsen omvat die in deze bron worden genoemd. Bijvoorbeeld, \"Oneida, Idaho, USA\" zou worden gebruikt als bronrechtsgebied voor evenementen die plaatsvinden in de verschillende steden in Oneida County. \"Idaho, USA\" zou de bron van jurisdictie zijn als de geregistreerde gebeurtenissen niet alleen in Oneida County zouden plaatsvinden, maar ook in andere provincies in Idaho.";
$pgv_lang["cache_life_help"]				= "~#pgv_lang[cache_life]#~<br /><br />Om de prestaties te verbeteren is dit PhpGedCom Welkom Pagina blok opgeslagen als een  cache bestand.  Dat betekent dat deze pagina niet elke keer opnieuw samengesteld moet worden, als deze wordt opgeroepen door een gebruiker/bezoeker. U kunt aangeven hoe vaak het cache bestand van dit blok moet worden ververst.<br /><ul><li><b>-1</b> betekent dat het cache bestand nooit automatisch zal worden ververst.  Om de pagina te vernieuwen, moet u alle cache bestanden verwijderen.  U kunt dit doen op de Welkom Pagina Aanpassen pagina.</li><li><b>0</b> (Nul) betekent dat dit blok nooit wordt opgeslagen in de cache. Elke keer dat de pagina wordt getoond, zal dat een nieuw samengestelde zijn.  Deze instelling wordt automatisch gebruikt voor blokken die regelmatig wijzigen, zoals bijv.:  #pgv_lang[logged_in_users_block]# en de #pgv_lang[random_media_block]# blokken.</li><li><b>1</b> (Een) betekent dat er dagelijks een verse kopie van het dit blok wordt opgeslagen als cache bestand, <b>2</b> betekent dat er elke twee dagen een verse kopie wordt gemaakt, <b>7</b> betekent dat er eens per week een verse kopie wordt gemaakt, enz.</li></ul>";
$pgv_lang["clear_cache_help"]				= "~#pgv_lang[clear_cache]#~<br /><br />Om de prestaties te verbeteren zijn diverse blokken op de  PhpGedView Welkom Pagina  opgeslagen als een  cache bestand in de index-map.  De cache bestanden voor de meeste blokken worden eens per dag ververst. Het zal echter voor kunnen komen dat u de cache bestanden handmatig wilt verversen.<br /><br />Deze knop stelt u in staat om de cache bestanden, indien nodig, te verversen.";
$pgv_lang["import_options_help"]			= "U kunt aanvullende opties kiezen, die gebruikt worden bij het importeren van de GEDCOM.";
$pgv_lang["verify_gedcom_help"]				= "~#pgv_lang[verify_gedcom]#~<br /><br />Hier kiest u of u wilt doorgaan met uploaden en importeren van dit GEDCOM bestand, of dit wilt afbreken.";
$pgv_lang["add_gedcom_instructions"] 		= "Voer een bestandsnaam in voor deze nieuwe GEDCOM.  De nieuwe GEDCOM zal worden gemaakt in de Index map: #INDEX_DIRECTORY#";
$pgv_lang["random_media_start_slide_help"]	= "~#pgv_lang[random_media_start_slide]#~<br /><br />Moet de diavoorstelling automatisch starten wanneer de pagina is geladen?<br /><br />De diavoorstelling wijzigt de inhoud van het blok, zonder informatie van de server te pre-laden en zonder de gehele pagina opnieuw te laden.";
$pgv_lang["random_media_ajax_controls_help"] = "~#pgv_lang[random_media_ajax_controls]#~<br /><br />Gebruik deze instelling om de Diavoorstelling-controls van het Willekeurige Media blok te tonen.<br /><br />Met behulp van deze controls kan de gebruiker naar een ander willekeurig object springen of, willekeurig geselecteerde, media te tonen als een diavoorstelling. De diavoorstelling wijzigt de inhoud van het blok, zonder informatie van de server te pre-laden en zonder de gehele pagina opnieuw te laden.";
$pgv_lang["edit_add_unlinked_source_help"]	= "~#pgv_lang[add_unlinked_source]#~<br /><br />Gebruik deze link om een nieuwe bron aan uw database toe te voegen zonder de bron te koppelen  aan een citaat in een andere kaart. De nieuwe bron wordt opgenomen in de Bronnen lijst, maar zal niet voorkomen op overzichten of elders in het programma, totdat het is gekoppeld aan een citaat van een bron.";
$pgv_lang["edit_add_unlinked_note_help"]	= "~#pgv_lang[add_unlinked_note]#~<br /><br />Gebruik deze link om een nieuwe gedeelde notitie aan uw database toe te voegen, zonder deze aan enige kaart te koppelen. De nieuwe notitite wordt in de Gedeelde Notities lijst opgenomen, maar zal niet voorkomen op overzichten of elders in het programma, totdat het is gekoppeld aan een persoon, gezin of geeurtenis.";
$pgv_lang["link_person_id_help"]			= "~#pgv_lang[label_local_id]#~<br /><br />In dit veld moet u het persoons_ID nnummer invullen (bijv. I654).";
$pgv_lang["link_gedcom_id_help"]			= "~#pgv_lang[label_gedcom_id]#~<br /><br />Gebruik deze sectie om het ID-kenmerk van de andere database, waarin de persoon zich bevindt waaraan u wilt koppelen, in te vullen.";
$pgv_lang["link_remote_site_help"]			= "~#pgv_lang[label_site]#~<br /><br />In deze sectie specificeert u de parameters die nodig zijn om de verbinding te maken met een andere site, waarop de gegevens staan waaraan u gegevens van deze site aan wilt verbinden.<br />U heeft de keus om te kiezen uit een lijst van bekende sites, die u eerder heeft gebruikt, of de #pgv_lang[label_site_url2]# en #pgv_lang[label_gedcom_id]# in te toetsen voor een nieuw adres.<br /><br />In het <b>#pgv_lang[label_site_url2]#</b> veld voert u de URL in om toegang te krijgen tot het \"web services description\" bestand (WDSL) dat PhpGedView vertelt hoe toegang is te verkijgen tot de gegevens op de andere site.  Als de andere site ook een PhpGedView website is, zou de URL naar het WSDL bestand er zo uit kunnen zien: <u>http://www.remotesite.com/phpGedView/genservice.php?wsdl</u><br />(als de install-map van die andere site \"/phpGedView/\" is)<br /><br />Het <b>#pgv_lang[label_gedcom_id]#</b> veld wordt gebruikt om een optionele database identificatie in te vullen, indien een site dat vereist.  Voor PhpGedView sites is dat de naam van het GEDCOM bestand.<br /><br />De <b>#pgv_lang[label_username_id]#</b> en de <b>#pgv_lang[label_password_id]#</b> velden zijn noodzakelijk indien de database dat vereist.";
$pgv_lang["link_remote_location_help"]		= "~#pgv_lang[label_location]#~<br /><br />Bij deze optie kunt u kiezen waar de gegevens, van de persoon waaraan u gaat koppelen, zich bevinden.<br />De gegevens kunnen zich op dezelfde (deze) site bevinden, maar in een andere genealogical database set. Of de data kunnen zich op een andere site, toegankelijk via het Internet, bevinden.<br /><br />Als de persoon op dezelfde site aanwezig is, wordt u gevraagd naar de naam van de dataset.<br /><br />Als de gegevens op een andere site staan, wordt u gevraagd naar de URL, de database naam of indentificatie, gebruikersnaam en wachtwoord voor toegang naar de database.<br /><br />In beide gevallen moet u de ID van persoon, waaraan u linkt, invullen.";
$pgv_lang["link_remote_rel_help"]			= "~#pgv_lang[label_rel_to_current]#~<br /><br />Gebruik deze optie om de relatie te selecteren, die de persoon op de andere site heeft met de persoon op uw site.<br />Bijvoorbeeld: Als u <i>Vader</i> selecteert, betekent het dat de persoon op de andere site de vader is van de persoon aan wie hij op uw site is gekoppeld.";
$pgv_lang["link_remote_help"]				= "~#pgv_lang[link_remote]#~<br /><br />Gebruik dit formulier om personen te koppelen aan andere personen, waarvan de gegevens op een andere site staan of een andere genealogische database die toegankelijk is voor uw exemplaar van PhpGedView.<br /><br />Om een dergelijke link toe te voegen, moet u eerst het relatietype selecteren, vervolgens een site kiezen die al bekend is bij PhpGedView of een nieuwe site definiëren, en vervolgens de site-ID invoeren van de persoon waarnaar u wilt linken. PhpGedView zal dan indien nodig automatisch informatie van de externe site downloaden. De gedownloade informatie wordt <u>niet</u> opgenomen in uw genealogische database; het blijft op de originele site maar wordt opgenomen in de verschillende pagina's waarop deze op afstand gelinkte persoon wordt weergegeven.<br /><br />Voor meer informatie kunt u bij elk onderdeel op het formulier op het vraagteken klikken.  Ook kunt u de online (Engelstalige)  tutorial bekijken voor meer informatie: <a href=\"#PGV_PHPGEDVIEW_WIKI#/en/index.php?title=How_To:Remote_Link_Individuals_Across_Websites_And_Databases\" target=\"_blank\">#PGV_PHPGEDVIEW_WIKI#</a>.";

//-- Edit Interface
$pgv_lang["edit_REPO_NAME_help"]	= "~#factarray[REPO:NAME]#~<br /><br />De naam van de bibliotheek, archief of andere repository waarin bronmateriaal is opgeslagen.";
$pgv_lang["edit_REPO_ADDR_help"]	= "~#factarray[REPO:ADDR]#~<br /><br />Het adres van deze bibliotheek, archief of andere opslagplaats. Voer het adres in zoals u het op een envelop zou schrijven.<br /><br />Laat dit veld leeg als u geen adres wilt opnemen.";
$pgv_lang["edit_REPO_PHON_help"]	= "~#factarray[REPO:PHON]#~<br /><br />Het telefoonnummer van deze bibliotheek, archief of andere opslagplaats. Voer het nummer in, inclusief het land- en netnummer. Een nummer in Duitsland kan bijvoorbeeld +49 25859 56 76 89 zijn en een nummer in de USA of Canada kan +1 888 555-1212 zijn.<br /><br />Laat dit veld leeg als u geen een telefoonnummer.";
$pgv_lang["edit_REPO_FAX_help"]		= "~#factarray[REPO:FAX]#~<br /><br />Het faxnummer van deze bibliotheek, archief of andere opslagplaats. Voer het nummer in, inclusief het land- en netnummer. Een nummer in Duitsland kan bijvoorbeeld +49 25859 56 76 89 zijn en een nummer in de USA of Canada kan +1 888 555-1212 zijn.<br /><br />Laat dit veld leeg als u geen een faxnummer.";
$pgv_lang["edit_REPO_EMAIL_help"]	= "~#factarray[REPO:EMAIL]#~<br /><br />Het e-mailadres van deze bibliotheek, archief of andere opslagplaats. Voer het e-mailadres in. Voorbeeld: <b>name@hotmail.com</b><br /><br />Laat dit veld leeg als u geen e-mailadres wilt opnemen.";
$pgv_lang["edit_REPO_WWW_help"]		= "~#factarray[REPO:WWW]#~<br /><br />De internetstartpagina van deze bibliotheek, archief of andere opslagplaats. Voer het adres van de startpagina in, inclusief het http:// of https://. Voorbeeld: <b>https://www.phpgedview.net/</b><br /><br />Laat dit veld leeg als u geen startpagina-adres wilt toevoegen.";
$pgv_lang["edit_CALN_help"]			= "~#factarray[CALN]#~<br /><br />Een identificatie- of referentiebeschrijving die wordt gebruikt om items op te slaan en op te halen uit de holdings van een bibliotheek, archief of andere opslagplaats. Informele repositories hoeven meestal geen #factarray[CALN]# systeem te gebruiken.";
$pgv_lang["edit_REPO_help"]			= "~#factarray[REPO]#~<br /><br />Dit is het ID-nummer van de bibliotheek, het archief of ander depot waar het bronmateriaal waarnaar wordt verwezen, is opgeslagen. De titel van het huidige archief wordt weergegeven onder het ID-nummer.<br /><br />U kunt het ID-nummer wijzigen van het archief waar dit bronmateriaal is opgeslagen. Maak dit veld leeg om de archiefverwijzing te verwijderen. Deze actie verwijdert het archiefrecord niet uit de database; alleen de verwijzing wordt verwijderd.<br /><br />Als u de gewenste archief-ID rechtstreeks invoert, moet dat archiefrecord al in de database bestaan. U kunt op <b>#pgv_lang[find_repository]#</b> klikken om het ID-nummer van een bestaand archief op te zoeken. Klik op <b>#pgv_lang[create_repository]#</b> als u een nieuw archiefrecord moet invoeren.";
$pgv_lang["edit_PUBL_help"]			= "~#factarray[PUBL]#~<br /><br />Wanneer en waar het record is gemaakt. Voor gepubliceerde werken omvat dit informatie zoals de stad van publicatie, de naam van de uitgever en het jaar van publicatie.<br /><br />Voor een niet-gepubliceerd werk moet het de datum bevatten waarop het record is gemaakt en de plaats waar het was gemaakt. Bijvoorbeeld de provincie en staat van verblijf van een persoon die aangifte doet voor een pensioen of de stad en staat van verblijf van de schrijver van een brief of een privé familiegeschiedenis.";
$pgv_lang["edit_AUTH_help"]			= "~#factarray[AUTH]#~<br /><br />De persoon, instantie of entiteit die de record heeft gemaakt. Voor een gepubliceerd werk kan dit de auteur, samensteller, transcriber, abstractor of redacteur zijn. Voor een niet-gepubliceerde bron kan dit een persoon, een overheidsinstantie, kerkelijke organisatie of particuliere organisatie zijn, enz.";
$pgv_lang["edit_REFN_help"]			= "~#factarray[REFN]#~<br /><br />Dit veld wordt normaal gebruikt om vrije tekst op te nemen om dit GEDCOM-record te identificeren. Het kan bijvoorbeeld een bestandsnummer zijn binnen een geautomatiseerd of handmatig systeem, of het kan een pagina- en positienummer op een stamboomkaart zijn.<br /></br />Als de GEDCOM-configuratie zo is ingesteld dat de gebruiker het automatisch gegenereerde ID-nummer voor nieuwe personen kan overschrijven, wordt dat bovenliggende ID-nummer hier ingevoerd. In dat geval moet de tekst voldoen aan de regels die zijn vastgesteld voor ID-nummers. Geldige ID-nummers mogen alleen de letters <b>A</b> tot en met <b>Z</b>, <b>a</b> tot en met <b>z</b>, cijfers <b>0</b> tot en met <b>9</b>, en de speciale symbolen <b>. : -</b> en <b>_</b><br /><br />De optie die het gebruik van de #factarray[REFN]# mogelijk maakt in plaats van het automatisch gegenereerde ID-nummer is te vinden in de GEDCOM-configuratie, de sectie Opties voor wijzige.";
$pgv_lang["edit_ABBR_help"]					= "~#factarray[ABBR]#~<br /><br />Gebruik dit veld om een afgekorte versie van een titel op te slaan.  Dit veld wordt gebruikt in samenhang met het titelveld bij bronnen.  Standaard zal PGV eerst de titel gebruiken en daarna de titelafkorting.<br /><br />Volgens de GEDCOM 5.5 specificatie, \"deze invoer is er voor om een verkorte titel te hebben voor het sorteren, in- en uitvoeren van gegevens op bronnen-kaarten (pg 62).\"<br /><br />In PhpGedView is de afgekorte titel vrijblijvend, maar in sommige genealogische  programma's is het verplicht deze in te vullen.";
$pgv_lang["edit_ROMN_help"]					= "~#factarray[NAME:ROMN]#~<br /><br />#pgv_lang[edit_ROMN_advice]#";
$pgv_lang["edit_ROMN_advice"]		= "In veel culturen is het gebruikelijk om de traditionele naam te schrijven met de karakters. Vaak is er dan ook een geromaniseerde versie v.d. naam, zoals het gespeld en uitgesproken zou worden in talen, die zijn gebaseerd op het Latijnse alfabet, zoals het Nederlands.<br /><br />Als u het verkiest om een niet-Latijnse alfabet te gebruiken, zoals Grieks, Hebreeuws, Russisch, Arabisch of Chinees om de naam in te voeren in de standaard naam-velden, dan kunt u dit veld gebruiken om dezelfde naam ook in te voeren met het Latijnse alfabet.  Beide versies van de naam zullen worden getoond in lijsten en diagrammen of grafieken.<br /><br />Hoewel de titel van dit veld  \"Geromaniseerde naam\" luidt, is het natuurlijk niet beperkt tot alleen  karakters van het Latijnse alfabet, zoals duidelijk wordt in bovenstaande voorbeelden. Dit kan ook bij uitstek worden gebruikt bij bijv. Japanse namen, waar drie verschillende alfabetten kunnen voorkomen.";
$pgv_lang["edit_ROMN_GIVN_help"]			= "~#pgv_lang[roman_givn]#~<br /><br />#pgv_lang[edit_ROMN_advice]#<br /><br />In dit veld voert u de voornaam, of voornamen, in van de persoon.  Bijvoorbeeld: als de naam \"John Robert Finlay\" is, dan moet in dit veld \"John Robert\" worden ingevoerd.";
$pgv_lang["edit_ROMN_SURN_help"]			= "~#pgv_lang[roman_surn]#~<br /><br />#pgv_lang[edit_ROMN_advice]#<br /><br />In dit veld wordt de achternaam van de persoon ingevuld.  Als, bijvoorbeeld, de naam \"John Robert Finlay\" is, dan is de hier in te voeren achternaam \"Finlay\"<br /><br />Van personen met meervoudige achternamen, zoals vaak voorkomt in bijv.  Spanje en Portugal, kunnen de achternamen worden gescheiden door een komma.  Dat geeft dan aan dat de persoon kan worden gezocht op beide namen.  Bijvoorbeeld: de achternaam \"Cortes,Vega\" kan worden gevonden onder de <b>C</b> en de  <b>V</b>, maar de achternaam \"Cortes Vega\" komt alleen voor onder de <b>C</b>.";
$pgv_lang["edit__HEB_help"]					= "~#factarray[_HNM]#~<br /><br />#pgv_lang[edit__HEB_advice]#";
$pgv_lang["edit__HEB_advice"]		= "In veel culturen is het gebruikelijk om de traditionele naam te schrijven met de karakters. Vaak is er dan ook een geromaniseerde versie v.d. naam, zoals het gespeld en uitgesproken zou worden in talen, die zijn gebaseerd op het Latijnse alfabet, zoals het Nederlands.<br /><br />Als u het verkiest om het Latijnse alfabet te gebruiken om de naam in te voeren in de standaard naam-velden, dan kunt u dit veld gebruiken om dezelfde naam ook in te voeren met een niet-Latijns alfabet, zoals Grieks, Hebreeuws, Russisch, Arabisch of Chinees.  Beide versies van de naam zullen worden getoond in lijsten en diagrammen of grafieken.<br /><br />Hoewel de titel van dit veld  \"Hebreeuws\" luidt, is het natuurlijk niet beperkt tot alleen Hebreeuwse karakters, zoals duidelijk wordt in bovenstaande voorbeelden.";
$pgv_lang["edit__HEB_GIVN_help"]			= "~#pgv_lang[hebrew_givn]#~<br /><br />#pgv_lang[edit__HEB_advice]#<br /><br />In dit veld voert u de voornaam, of voornamen, in van de persoon.  Bijvoorbeeld: als de naam \"John Robert Finlay\" is, dan moet in dit veld \"John Robert\" worden ingevoerd.";
$pgv_lang["edit__HEB_SURN_help"]			= "~#pgv_lang[hebrew_surn]#~<br /><br />#pgv_lang[edit__HEB_advice]#<br /><br />In dit veld wordt de achternaam van de persoon ingevuld.  Als, bijvoorbeeld, de naam \"John Robert Finlay\" is, dan is de hier in te voeren achternaam \"Finlay\"<br /><br />Van personen met meervoudige achternamen, zoals vaak voorkomt in bijv.  Spanje en Portugal, kunnen de achternamen worden gescheiden door een komma.  Dat geeft dan aan dat de persoon kan worden gezocht op beide namen.  Bijvoorbeeld: de achternaam \"Cortes,Vega\" kan worden gevonden onder de <b>C</b> en de  <b>V</b>, maar de achternaam \"Cortes Vega\" komt alleen voor onder de <b>C</b>.";
$pgv_lang["edit_SEX_help"]			= "#pgv_lang[edit_sex_help]#";
$pgv_lang["edit_NAME_help"]			= "#pgv_lang[edit_name_help]#";
$pgv_lang["edit_add_unlinked_person_help"]	= "~#pgv_lang[add_unlinked_person]#~<br /><br />Gebruik deze functie om een niet-gekoppeld persoon toe te voegen.<br /><br />Deze persoon blijft als losse persoon in de genealogie bestaan en is niet verbonden met partner, ouders of kinderen, totdat u de koppeling aanbrengt. Dit kan via het #pgv_lang[relatives]# tabblad op de #pgv_lang[indi_info]# pagina.";
$pgv_lang["edit_URL_help"]					= "~#factarray[URL]#~<br /><br />Voer het URL-adres in, inclusief http: //. Voorbeeld: <b>http://www.phpgedview.net</b><br /><br />Laat dit vak leeg als u geen URL-adres wilt toevoegen.";
$pgv_lang["edit_WWW_help"]					= "~#factarray[WWW]#~<br /><br />Voer het adres van de webpagina in, inclusief http: //. Voorbeeld: <b>http://www.phpgedview.net</b><br /><br />Laat dit vak leeg als u geen Web-URL wilt toevoegen.";
$pgv_lang["edit_EMAIL_help"]				= "~#factarray[EMAIL]#~<br /><br />Voer een e-mailadres in. Voorbeeld: <b>naam@hotmail.com</b>.<br /><br />Laat dit vak leeg als u geen e-mailadres wilt invoeren.";
$pgv_lang["edit_FAX_help"]					= "~#factarray[FAX]#~<br /><br />Voer het faxnummer in, inclusief de land- en regiocode. Een nummer in Nederland kan bijvoorbeeld +31 71 1234567 zijn en een nummer in de USA of Canada kan +1 888 555-1212 zijn.";
$pgv_lang["edit_PHON_help"]					= "~#factarray[PHON]#~<br /><br />Voer het telefoonnummer in, inclusief de land- en regiocode. Een nummer in Nederland kan bijvoorbeeld +31 71 1234567 zijn en een nummer in de USA of Canada kan +1 888 555-1212 zijn.";
$pgv_lang["edit_ADDR_help"]					= "~#factarray[ADDR]#~<br /><br />Voer het adres in, op dezelfde wijze als u het op een envelop zou schrijven.<br /><br />Laat dit vak leeg als u geen adres wilt invoeren.";
$pgv_lang["edit_GIVN_help"]					= "#pgv_lang[edit_given_name_help]#";
$pgv_lang["edit_SPFX_help"]					= "~#factarray[SPFX]#~<br /><br />Hier kunt u een eventueel voorvoegesle invullen, of selecteren uit de lijst.  Voorbeelden van zulke voorvoegsel zijn:  <b>van der</b> Vaart, <b>de</b> Graaf, <b>von</b> Braun, enz.<br /><br />Onder bepaalde omstandigheden kan hier een adellijke titel worden ingevoerd. Bijvoorbeeld Peter <b>Freiherr von</b> Somewhere. Het «Freiherr» gedeelte is eigenlijk een adellijke titel en mag niet worden herhaald als een feit #factarray[TITL]#. Wat hier ingevuld wordt, is grotendeels afhankelijk van de voorkeuren van de persoon in kwestie.";
$pgv_lang["edit_SURN_help"]					= "#pgv_lang[edit_surname_help]#";
$pgv_lang["edit__MARNM_help"]				= "~#factarray[_MARNM]#~<br /><br />Voer hier de \"getrouwde\" naam in voor deze persoon in. Volg hierbij de regels, zoals deze ook getoond worden in het \"Naam\" veld.  Dit veld is optioneel.<br /><br />Bijvoorbeeld: als Grietje Bruin is getrouwd met Jan Blaauw zou u kunnen invoeren (natuurlijk zonder de aanhalingstekens)<ul><li>Amerikaans gebruik:&nbsp;&nbsp;\"Grietje Bruin /Blaauw/\"</li><li>Europees gebruik:&nbsp;&nbsp;\"Grietje /Blaauw/\"</li><li>Alternatief Europees gebruik:&nbsp;&nbsp;\"Grietje /Blaauw-Bruin/\" of \"Grietje /Bruin-Blaauw/\"</li></ul>U zou dit alleen moeten wijzigen als Grietje Bruin zichzelf volgens de nieuwe naam liet aanspreken nadat ze met Jan Blaauw was getrouwd. In sommige plaatsen, Quebec (Canada) bijvoorbeeld, is het onwettig om namen op deze manier te wijzigen.<br /><br />Mannen kunnen tegenwoordig hun achternaam ook aanpassen na een huwelijk.";
$pgv_lang["edit_PEDI_help"]					= "~#factarray[PEDI]#~<br /><br />Dit veld omschrijft de relatie van het kind tot het gezin.  De mogelijke opties zijn:<ul><li><b>#pgv_lang[unknown]#</b>&nbsp;&nbsp;&nbsp;De relatie van het kind tot het gezin kan niet worden vastgesteld.  Als deze optie is geselecteerd, wordt het #factarray[PEDI]# veld niet overgenomen in de database.</li><li><b>#factarray[BIRT]#</b>&nbsp;&nbsp;&nbsp;Deze optie geeft aan dat de relatie van het kind tot het gezin is bepaald door geboorte.</li><li><b>#pgv_lang[adopted]#</b>&nbsp;&nbsp;&nbsp;Deze optie geeft aan dat het kind was geadopteerd door het gezin.  Dit geeft <i>niet</i> aan dat er <i>geen</i> bloedverwantschap is tussen het kind en het gezin; het toont aan dat het kind door het gezin, in kwestie, was geadopteerd enige tijd na de geboorte van het kind.</li><li><b>#pgv_lang[foster]#</b>&nbsp;&nbsp;&nbsp;Deze optie geeft aan dat het kind een pleegkind is van het gezin.  Gewoonlijk is er dan geen sprake van bloedverwantschap tussen het kind en het gezin.</li><li><b>#pgv_lang[sealing]#</b>&nbsp;&nbsp;&nbsp; Het kind is door Zegeling aan het gezin verbonden door een SLD <i>Zegeling</i> ceremonie.  De zegeling van een kind wordt uitgevoerd als de ouder door zegeling aan elkaar waren verbonden na de geboorte van het kind.  Kinderen, die worden geboren na de zegeling van de ouders, zijn automatisch door zegeling verbonden aan het gezin.</li></ul>";
$pgv_lang["edit_AGNC_help"]					= "~#factarray[AGNC]#~<br /><br />Een organisatie, instituut, bedrijf, persoon, of andere entiteit welke een bepaalde autoriteit heeft.<br /><br />Bijvoorbeeld: een werkgever van een persoon, of een kerk die rituelen of andere gebeurtenissen uitvoert, of een organisatie die verantwoordelijk is voor het maken en archiveren van bepaalde registraties.";
$pgv_lang["edit_MARR_TYPE_help"]			= "~#factarray[MARR]#:#factarray[TYPE]#~<br /><br />Dit veld beschrijft het type verbintenis waaruit het gezin is ontstaan.<ul><li><b>#factarray[MARR_RELIGIOUS]#</b>&nbsp;&nbsp;&nbsp;geeft aan dat de ceremonie die de vereniging van twee personen formaliseerde om een gezin te vormen, werd uitgevoerd door een priester, bisschop, kardinaal, predikant, rabbijn, sjamaan of een soortgelijke persoon. De ceremonie vond niet noodzakelijkerwijs plaats in een kerk, synagoge, tempel of andere gewijde plaats. Het had ook buiten of in een privéwoning kunnen plaatsvinden.</li><li><b>#factarray[MARR_CIVIL]#</b>&nbsp;&nbsp;&nbsp;geeft aan dat de ceremonie die de verbintenis van twee personen om een gezin te vormen formaliseerde, werd uitgevoerd door een rechter, magistraat, burgemeester of een soortgelijke persoon met gezag die geen priester enz is. De bevoegdheid om dergelijke ceremonies uit te voeren, wordt gewoonlijk verleend door een overheid. De ceremonie vond niet noodzakelijkerwijs plaats in een rechtszaal of een kantoor.</li><li><b>#factarray[MARR_PARTNERS]#</b>&nbsp;&nbsp;&nbsp;beschrijft de relatie tussen twee personen die niet met elkaar getrouwd zijn, maar zich gedragen alsof ze een familie zijn. Ze hebben <u>niet</u> deelgenomen aan een huwelijksceremonie die is uitgevoerd door een priester, een bisschop, een rechter, een burgemeester of een andere persoon met de bevoegdheid om huwelijken te voltrekken. Ze hebben misschien een openbare verklaring afgelegd dat ze zichzelf als getrouwd beschouwen, maar dat is geen vereiste.</li><li><b>#factarray[MARR_UNKNOWN]#</b>&nbsp;&nbsp;&nbsp;geeft aan dat de details van de verbintenis tussen twee personen om een gezin te vormen, niet bekend zijn.</li></ul>";

$pgv_lang["context_help"]					= "Meer helpinformatie is beschikbaar, click hiervoor op <b>?</b> naast het desbetreffende onderdeel.";

$pgv_lang["register_gedcomid_help"]			= "~#pgv_lang[gedcomid]#~<br /><br />Ieder persoon in een genealogie heeft een uniek identificatienummer, een ID. Als u in de genealogie voorkomt en uw ID kent, kunt u dat hier intypen. Als u het niet kent, of u kunt het niet vinden doordat de toegang is afgeschermd door privacy-instellingen, geeft u dan voldoende informatie in het commentaarvak om u herkenbaar te maken voor de beheerder. Deze zal dat uw ID voor u instellen.";
$pgv_lang["register_comments_help"]			= "~#pgv_lang[comments]#~<br /><br />Dit vak kunt u gebruiken om aan de beheerder de reden aan te geven, waarom u een gebruikersnaam aanvraagt. Geeft u daarbij ook aan hoe uw relatie is tot personen in deze genealogie. Verder kunt u hier uw overige opmerkingen kwijt.";
$pgv_lang["utf8_ansi_help"]					= "~#pgv_lang[utf8_to_ansi]#~<br /><br />Voor het optimaal tonen van de gegevens op Internet gebruikt PhpGedView de UTF-8 tekenset. Sommige genealogieprogramma's ondersteunen deze tekenset niet, als GEDCOM-bestanden worden geïmporteerd. Als u deze keuze aanzet, wordt het bestand van <b>UTF-8</b> naar <b>ANSI (ISO 8859-1)</b> geconverteerd.<br /><br />Welk formaat u nodig heeft hangt af van het programma waar u het GEDCOM-bestand mee wilt bewerken na het downloaden ervan. Raadpleeg indien nodig de handleiding bij het programma.<br /><br />Let erop dat speciale tekens alleen behouden blijven, als u het bestand in UTF-8 formaat download. Als u het bestand naar andere formaten zoals ANSEL moet converteren, dient u hiervoor een ander programma te gebruiken.<br /><br />Dit <a href='https://nl.wikipedia.org/wiki/UTF-8' target='_blank' title='Wikipedia-artikel'><b>Wikipedia-artikel</b></a> bevat uitgebreide informatie en links over UTF-8.";
$pgv_lang["remove_tags_help"]				= "~#pgv_lang[remove_custom_tags]#~<br /><br />Deze optie zorgt ervoor dat speciale PhpGedView-kenmerken worden verwijderd.<br /><br />Dit betreft kenmerken zoals _PGVU, waarmee wordt aangegeven welke gebruiker het laatst iets aan de gegevens heeft gewijzigd, of _THUM, waarmee wordt aangegeven welke afbeelding moet worden gebruikt als miniweergave.<br /><br />In sommige gevallen kunnen de speciale kenmerken foutmeldingen genereren als ze in een genealogieprogramma worden geïmporteerd.";
$pgv_lang["download_zipped_help"]			= "~#pgv_lang[zip_files]#~<br /><br />Als u deze optie kiest, wordt een kopie van het GEDCOM-bestand gecomprimeerd in een ZIP-bestand, voordat het downloaden begint. Dit brengt de omvang ervan aanzienlijk terug, maar u heeft op uw PC een UnZIP-programma nodig (zoals WinZip) om het GEDCOM-bestand weer uit te pakken voor gebruik.<br /><br />Deze optie kunt u met name gebruiken voor grote GEDCOM-bestanden. Het risico bestaat dat deze niet geheel gedownload worden, doordat de maximale uitvoeringstijd van het downloadprogramma wordt overschreden. U heeft dan een incompleet GEDCOM-bestand. Deze optie reduceert de downloadtijd met ongeveer 75%.";
$pgv_lang["edit_NCHI_help"]					= "~#factarray[NCHI]#~<br /><br />Voer het aantal kinderen voor deze persoon of dit gezin in. Invoeren is niet verplicht.<br /><br /> ";
$pgv_lang["edit_TIME_help"]					= "~#factarray[TIME]#~<br /><br />Voer het tijdstip van deze gebeurtenis in. Het geldige formaat is UU:MM. Voorbeelden zijn: 04:50 13:00 20:30.";
$pgv_lang["edit_NOTE_help"]					= "~#factarray[NOTE]#~<br /><br />In notities kunt u vrije stukken tekst opslaan. Deze verschijnen bij de details van de feiten en gebeurtenissen op de pagina.";
$pgv_lang["edit_SHARED_NOTE_help"]			= "~#pgv_lang[shared_note]#~<br /><br />Gedeelde notities zijn, net als gewone notities, vrije vorm (ongestructureerde) tekst. Deze verschijnen bij de details van de feiten en gebeurtenissen op de pagina.<br /><br />In tegenstelling tot gewone notities, kan elke gedeelde notitie worden gekoppeld aan meer dan 1 persoon, gezin, bron of feit.";
$pgv_lang["edit_CEME_help"]					= "~#factarray[CEME]#~<br /><br />Voer de naam van de begraafplaats of andere laatste rustplaats in waar de persoon is begraven.";
$pgv_lang["edit_ASSO_help"]			= "~#factarray[ASSO]#~<br /><br />Voer de GEDCOM-ID in van de persoon wiens relatie met de huidige persoon die u wilt beschrijven.";
$pgv_lang["edit_RELA_help"]			= "~#factarray[RELA]#~<br /><br />Selecteer een #factarray[RELA]# uit de lijst. Als u <b>#pgv_lang[godfather]#</b> selecteert, betekent dit: <i>De persoon die wordt geïdentificeerd in het veld #factarray[ASSO]# is de #pgv_lang[godfather]# van de huidige persoon</i>.";
$pgv_lang["show_spouse_help"]				= "~#pgv_lang[show_spouses]#~<br /><br />Standaard worden in dit overzicht de partners van de personen niet weergegeven, omdat dit het overzicht ingewikkeld maakt. Met deze optie kunt u de partners alsnog laten tonen.";
$pgv_lang["reorder_families_help"]			= "~#pgv_lang[reorder_families]#~<br /><br />De gezinnen op het tabblad \"Verwanten\" worden weergegeven in de volgorde waarin ze in de gegevens van de desbetreffende persoon voorkomen. Dit is van belang, omdat soms niet de huwelijksdata bekend zijn, maar wel de volgorde van huwelijken.<br /><br />Met behulp van deze optie kunt u de volgorde van de gezinnen aanpassen. Daarbij is een speciale knop beschikbaar om de sortering op huwelijksdatum toe te passen, uiteraard indien alle huwelijksdata bekend zijn.";
$pgv_lang["autoContinue_help"]				= "~#pgv_lang[autoContinue]#~<br /><br />Als PhpGedView merkt dat het importeren van de GEDCOM meer tijd nodig heeft dan is toegestaan door de tijdslimiet, zal er een <b>#pgv_lang[del_proceed]#</b> knop getoond worden, waarop u moet klikken om door te gaan met het Importeren.<br /><br />Als deze optie op <b>#pgv_lang[yes]#</b> is gezet, zal PhpGedView automatisch de <b>#pgv_lang[del_proceed]#</b> knop voor u indrukken.  Dit voorkomt het vervelende herhaaldelijk moeten klikken op de knop, bij langdurige  Imports.";
$pgv_lang["firstname_i_help"]				= "~#pgv_lang[firstname_alpha_index]#~<br /><br />De achternaam, die u heeft gekozen, heeft meer dan #GLOBALS[SUBLIST_TRIGGER_I]# personen.<br /><br />Om u de juiste persoon te helpen zoeken, is de lijst verdeeld in kleinere lijsten, op volgorde van de eerste letter van de voornamen van de afzonderlijke personen. Deze alpfabetische sub-index werkt op dezelfde wijze als de alpfabetische index voor achternamen.<ul><li>Klik op een letter om alle voornamen te zien, die met die letter beginnen.</li><li>Kies <b>#pgv_lang[PN]#</b> om alle mensen, waarvan de voornamen niet bekend zijn, te tonen.</li><li>Door <b>#pgv_lang[all]#</b> te kiezen, zal een lijst worden getoond van alle personen met de, eerder gekozen, achternaam.</li></ul>";
$pgv_lang["firstname_f_help"]				= "~#pgv_lang[firstname_alpha_index]#~<br /><br />De gezinsnaam, die u heeft gekozen, heeft meer dan #GLOBALS[SUBLIST_TRIGGER_F]# personen.<br /><br />Om u het juiste gezin te helpen zoeken, is de lijst verdeeld in kleinere lijsten, op volgorde van de eerste letter van de voornamen van de afzonderlijke personen. Deze alpfabetische sub-index werkt op dezelfde wijze als de alpfabetische index voor namen.<ul><li>Klik op een letter om alle voornamen te zien, die met die letter beginnen.</li><li>Kies <b>#pgv_lang[PN]#</b> om alle mensen, waarvan de voornamen niet bekend zijn, te tonen.</li><li>Door <b>#pgv_lang[all]#</b> te kiezen, zal een lijst worden getoond van alle gezinnen met de, eerder gekozen, achternaam.</li></ul>";
$pgv_lang["edit_TYPE_help"]					= "~#factarray[TYPE]#~<br /><br />Het #factarray[TYPE]# invoervak stelt u in staat om een eigen gebeurtenistype in te voeren. U bent vrij om iedere tekst in te vullen, zoals u dat wilt.";
$pgv_lang["edit_TEMP_help"]					= "~#factarray[TEMP]#~<br /><br />Vul hier de tempel in, waar de SLD-verordening heeft plaatsgevonden.";
$pgv_lang["edit_STAT_help"]					= "~#factarray[STAT]#~<br /><br />Dit is een optionele statusaanduiding, die meestal wordt gebruikt voor gegevens over SLD-verordeningen, die door het TempleReady-programma zijn bewerkt.";
$pgv_lang["edit__PRIM_help"]				= "~#factarray[_PRIM]#~<br /><br />Gebruik dit keuzeveld om aan te geven of de afbeelding de geaccentueerde of primaire is, die aan deze persoon is gekoppeld. De geaccentueerde afbeelding wordt gebruikt op overzichten en op de persoonspagina.";
$pgv_lang["edit__THUM_help"]		= "~#factarray[_THUM]#~<br /><br />Met deze optie kun je de gebruikelijke selectie voor een miniatuurafbeelding overschrijven.<br /><br />De GEDCOM heeft een configuratie-optie die specificeert of PhpGedView de grote of de kleine afbeelding naar de browser moet sturen wanneer de huidige pagina een miniatuur vereist. De optie «#factarray[_THUM]#», indien ingesteld op <b>#pgv_lang[yes]#</b>, overschrijft tijdelijk de instelling van de GEDCOM-configuratieoptie, zodat PhpGedView altijd de grote afbeelding zal verzenden. U kunt PhpGedView niet dwingen om de kleine afbeelding te verzenden als de GEDCOM-configuratie specificeert dat altijd grote afbeeldingen moeten worden gebruikt.<br /><br />PhpGedView past de grootte van de verzonden afbeelding niet aan; de browser doet dit volgens de paginaspecificaties die hij ook heeft ontvangen. Dit kan ongewenste gevolgen hebben wanneer de afbeelding die wordt verzonden niet echt een miniatuur is waar PhpGedView een kleine afbeelding verwacht te verzenden. Dit is geen fout: er zijn gevallen waarin het wenselijk kan zijn om een grote afbeelding weer te geven op plaatsen waar men normaal gesproken een afbeelding ter grootte van een miniatuur zou verwachten te zien.<br /><br />U moet voorkomen dat u de optie «#factarray[_THUM]#» instelt op <b>#pgv_lang[yes]#</b>. Deze keuze zorgt ervoor dat overmatige hoeveelheden afbeeldingsgerelateerde gegevens naar de browser worden gestuurd, waarna de browser het overschot weggooit. Het laden van pagina's, met name van grafieken met veel afbeeldingen, kan ernstig worden vertraagd.";
$pgv_lang["edit_TITL_help"]					= "~#factarray[TITL]#~<br /><br />Voer een titel in voor de gegevens die u nu invoert. Als het een titel betreft voor een multimedia-item zorg dan voor een duidelijke omschrijving, waaruit gebruikers kunnen opmaken waar het om gaat.<br /><br />Als u de gegevens van een persoon aan het bewerken bent, gebruikt u dit veld om informatie over de adel in te voeren, zoals <i>Sir, Lord, Baron, Graaf, Hertog, Freiherr,</i> etc.<br /><br />Beroepsaanduidingen zoals <i>Dr., Admiral, Lt.Gen., Rev., Sister,</i> enz. moeten worden ingevoerd in het subveld «#factarray[NPFX]#», terwijl achtervoegsels voor namen zoals <i>Jr., Sr., III, IV,</i> enz. en academische informatie zoals <i>PhD, PEng, FImechE, DVM, MD,</i> enz. horen thuis in het subveld «#factarray[NSFX]#».";
$pgv_lang["edit_FILE_help"]					= "~#factarray[FILE]#~<br /><br />Dit is verreweg het belangrijkste gegeven van het multimedia-object en geeft aan welk bestand gebruikt wordt. Minimaal vult u hier de bestandsnaam in. Afhankelijk van de instellingen is meer informatie over de locatie van het bestand nodig.<br /><br />U kunt de koppeling \"#pgv_lang[find_media]#\" gebruiken om een multimedia-bestand te zoeken, als dat tenminste al is ge-upload naar de website.<br /><br />#pgv_lang[readme_help]#<br /><br /> ";
$pgv_lang["edit_FORM_help"]					= "~#factarray[FORM]#~<br /><br />Hier kunt u invullen welk bestandformaat het multimedia-object heeft, maar het is niet verplicht. Sommige genealogieprogramma's gebruiken het om te bepalen hoe ze met een multimedia-object moeten omgaan. Omdat multimedia-objecten in het algemeen niet gemakkelijk worden overgeheveld tussen computersystemen, is de hier ingevulde waarde van gering belang.";
$pgv_lang["generate_thumb_help"]			= "~#pgv_lang[auto_thumbnail]#~<br /><br />Uw webserver is in staat om automatisch miniweergaves aan te maken van bepaalde soorten afbeeldingen. Dit kunnen ondermeer BMP, JPG, GIF en PNG-bestanden zijn. De soorten die door uw webserver worden ondersteund zijn weergegeven in het keuzevak.<br /><br />Door dit te selecteren, geeft u aan dat u afbeeldingen uploadt en wilt proberen hier automatisch miniweergaves voor aan te maken. Als u zelf miniweergaves wilt aanmaken en in de juiste map plaatsen, selecteert u deze optie niet.";
$pgv_lang["edit_add_NOTE_help"]				= "~#pgv_lang[add_note]#~<br /><br />In deze sectie kunt een notitie toevoegen aan het feit dat u op dit moment aan het wijzigen of toevoegen bent. In notities kunt u een willekeurige tekst plaatsen. De notitie verschijnt bij de detailgegevens van het feit op de pagina.";
$pgv_lang["edit_add_SHARED_NOTE_help"]		= "~#pgv_lang[add_shared_note]#~<br />~#pgv_lang[edit_shared_note]#~<br /><br />Gedeelde notities zijn, net als gewone notities, vrije vorm (ongestructureerde) tekst.  In tegenstelling tot gewone notities, kan elke gedeelde notitie worden gekoppeld aan meer dan 1 persoon, gezin, bron of feit.<br /><br />Door op de juiste ikoon te klikken, kunt u een koppeling maken naar een bestaande gedeelde notitie. Of u kunt dan een nieuwe gedeelde notitie maken en er aan koppelen.  Als er al een koppeling naar een bestaande gedeelde notitie bestaat, kunt u ook de inhoud van die notitie wijzigen.<br /><ul><li><b>Koppelen aan een bestaande gedeelde notitie</b><div style=\"padding-left:20px;\">Als u al het ID-nummer van de gewenste gedeelde notitie weet, kunt u dat nummer direct in het veld invoeren.<br /><br />Als u op de ikoon van de <b>#pgv_lang[find_shared_note]#</b> klikt, kunt u in de tekst van alle bestaande Gedeelde notities zoek en dan een ervan kiezen.  Het ID-nummer van de gekozen notitite wordt automatisch in het veld ingevuld.<br /><br />U moet op de <b>#pgv_lang[add]#</b> knop klikken om de originele kaart bij te werken.</div><br /></li><li><b>Maak een nieuwe gedeelde notitie</b><div style=\"padding-left:20px;\">Als u op de <b>#pgv_lang[create_shared_note]#</b> ikoon klikt, zal een nieuw venster openen.  U kunt dan, desgewenst,de tekst van de nieuwe notitie invoeren.  Zoals ook bij gewone notities kunt u URL's intypen.<br /><br />Als u op de <b>#pgv_lang[save]#</b> knop klikt, ziet u een bericht met het ID nummer van de nieuw gemaakte created gedeelde notitie.  U moet op dit bericht klikken om het Wijzigen venster te sluiten en het nieuwe ID-nummer rechtstreeks naar het ID-nummer veld te kopiëren.  Als u het venster alleen maar sluit, zal het nieuw gemaakte ID-nummer niet automatisch gekopiëerd worden.<br /><br />U moet op de <b>#pgv_lang[add]#</b> knop klikken om de originele kaart bij te werken.</div><br /></li><li><b>Een bestaande gedeelde notitie wijzigen</b><div style=\"padding-left:20px;\">Als u op de <b>#pgv_lang[edit_shared_note]#</b> ikoon klikt, zal een nieuw venster openen.  Desgewenst kunt u de tekst van de bestaande gedeelde notitie wijzigen.  Zoals ook bij gewone notities kunt u URL's intypen.<br /><br />Als u op de <b>#pgv_lang[save]#</b> knop klikt, zal de tekst van de gedeelde notitie worden bijgewerkt.  U kunt het venster sluiten en dan nogmaals op de <b>#pgv_lang[save]#</b> knop klikken.<br /><br />Als u de tekst van een gedeelde notitie wijzigt, zal dat bij alle plaatsen ,waaraan de gedeelde notitie momenteel is gekoppeld, zichtbaar zijn.  Nieuwe koppelingen, die u maakt nadat de wijzigingen zijn aangebracht, zullen ook de bijgewerkte tekst gebruiken.</div></li></ul>";
$pgv_lang["edit_add_GEDFact_ASSISTED_help"]	= "~GEBRUIK van GEDFACT ASSISTENT~<br /><br />Door op de \"+\" te klikken zal het  GEDFact Gedeelde Notitie Assistent venster worden geopend. Specifieke help wordt daar geboden.<br /><br />Als u op  \"Opslaan\" knop klikt, wordt het ID van de Gedeelde Notitie hier geplakt.";
$pgv_lang["edit_add_SOUR_help"]		= "~#pgv_lang[add_source]#~<br /><br />In deze sectie kun je een nieuwe bronvermelding toevoegen aan het feit dat je momenteel aan het bewerken bent.<br /><br />In het veld Bron voer je de ID voor de bron in. Klik op de <b>#pgv_lang[create_source]#</b link als u een nieuwe bron moet invoeren. In het veld Citatiedetails voert u het paginanummer of andere informatie in die iemand kan helpen de informatie in de bron te vinden. In het tekstveld voert u de teksttranscriptie van de bron in.";
$pgv_lang["edit_add_ASSO_help"]				= "~#pgv_lang[add_asso]#~<br /><br />Met #pgv_lang[add_asso]# kunt u een persoon uit uw genealogie relateren aan een feit. Op die manier kunt u bijvoorbeeld aangeven dat een bepaald persoon de peetvader is van een ander persoon.";
$pgv_lang["edit_QUAY_help"]			= "~#factarray[QUAY]#~<br /><br />U zou dit veld gebruiken om de kwaliteit of betrouwbaarheid van de gegevens in deze bron vast te leggen. Veel genealogietoepassingen gebruiken een nummer in het veld. <b>3</b> kan betekenen dat de gegevens een primaire bron zijn, <b>2</b> kan betekenen dat het een secundaire bron is, <b>1</b> kan betekenen dat de informatie twijfelachtig is, en <b>0</b> kan betekenen dat de bron onbetrouwbaar is.";
$pgv_lang["edit_PAGE_help"]					= "~#factarray[PAGE]#~<br /><br />In de detailgegevens van het citaat kunt u bijvoorbeeld een paginanummer opgeven of andere informatie, waardoor de bedoelde informatie gemakkelijk in de bron kan worden teruggevonden.";
$pgv_lang["edit_TEXT_help"]					= "~#factarray[TEXT]#~<br /><br />Hier kunt u specifieke informatie invoeren over deze bronverwijzing. Voorbeelden zijn een transcript (letterlijk overgenomen tekst) uit de bron of een samenvatting of beschrijving ervan.";
$pgv_lang["edit_SOUR_help"]			= "~#factarray[SOUR]#~<br /><br />Dit is het ID-nummer van de bron voor dit feit. De titel van de huidige bron wordt onder het ID-nummer weergegeven.<br /><br />U kunt het ID-nummer wijzigen van het bronrecord waarnaar de bronvermelding van dit feit verwijst. Maak dit veld leeg om het hele citaat te verwijderen. Met deze actie wordt het bronrecord niet uit de database verwijderd; alleen deze referentie wordt verwijderd.<br /><br />Als u het gewenste bron-ID rechtstreeks invoert, moet dat bronrecord al in de database bestaan. U kunt <b>#pgv_lang[find_sourceid]#</b> klikken om het ID-nummer van een bestaand bronrecord op te zoeken. Klik <b>#pgv_lang[create_source]#</b> als u een nieuw bronrecord moet invoeren.";
$pgv_lang["edit_edit_raw_help"]				= "~#pgv_lang[edit_raw]#~<br /><br />Op deze pagina kunt u het onbewerkte GEDCOM-record bewerken. U dient deze pagina met de nodige voorzichtigheid te gebruiken; het vereist een goed begrip van de GEDCOM 5.5.1-standaard. Voor meer informatie over de GEDCOM 5.5.1-standaard, refereer je naar Help-onderwerp <b>GEDCOM-bestand</b>.<br /><br />PhpGedView biedt op vele andere manieren via invulschermen de mogelijkheid om de gegevens aan te passen. Aangeraden wordt altijd deze mogelijkheden te gebruiken, en deze functie alleen in uiterste noodzaak toe te passen. Als u de aangepaste informatie heeft opgeslagen, wordt op een aantal punten gecontroleerd op de juistheid ervan. Ook wordt een CHAN-record aangemaakt (laatste wijziging).";
$pgv_lang["add_from_clipboard_help"]		= "~#pgv_lang[add_from_clipboard]#~<br /><br />Met PhpGedView kunt u maximaal 10 feiten, met al hun details, naar een klembord kopiëren. Dit klembord verschilt van de knipselkar die u kunt gebruiken om delen van uw database te exporteren.<br /><br />U kunt elk van de feiten van het klembord selecteren en het geselecteerde feit kopiëren naar de persoon, familie, media, Bron- of opslagplaatsrecord dat momenteel wordt bewerkt. U kunt echter geen feiten van verschillende recordtypen kopiëren. U kunt bijvoorbeeld een huwelijksfeit niet kopiëren naar een bron of een persoonsrecord, aangezien het huwelijksfeit alleen in verband wordt gebracht met familierecords.<br /><br />Deze mogelijkheid is erg handig als u dezelfde informatie over een feit wilt toevoegen aan meerdere personen.";
$pgv_lang["edit_PLAC_help"]			= "~#factarray[PLAC]#~<br /><br />Plaatsen moeten worden ingevoerd volgens de normen voor genealogie. In genealogie worden plaatsen geregistreerd met de meest specifieke informatie over de plaats eerst en vervolgens naar de minst specifieke plaats als laatste, waarbij komma's worden gebruikt om de verschillende plaatsniveaus te scheiden. Het niveau waarop u de plaatsinformatie vastlegt, moet de niveaus van de overheid of kerk vertegenwoordigen waar essentiële gegevens voor die plaats worden bijgehouden.<br /><br />Een plaats als Salt Lake City wordt bijvoorbeeld ingevoerd als \"Salt Lake City, Salt Lake, Utah, USA\".<br /><br />Laten we elk onderdeel van deze plek eens bekijken. Het eerste deel, \"Salt Lake City\", is de stad of gemeente waar de gebeurtenis plaatsvond. In sommige landen zijn er mogelijk gemeenten of districten in een stad die belangrijk zijn om op te merken. In dat geval moeten ze voor de stad komen. Het volgende deel, \"Salt Lake\", is de provincie. \"Utah\" is de staat en \"USA\" is het land. Het is belangrijk om elke plaats te noteren, omdat genealogische gegevens worden bijgehouden door de regeringen van elk niveau.<br /><br />Als een niveau van de plaats onbekend is, laat dan een spatie tussen de komma's. Stel dat u in het bovenstaande voorbeeld de provincie van Salt Lake City niet kende. U moet het dan als volgt opnemen: \"Salt Lake City, , Utah, USA\". Stel dat u alleen weet dat iemand in Utah is geboren. U voert de informatie als volgt in: \", , Utah, USA\".<br /><br />U kunt de link <b>#pgv_lang[find_place]#</b> gebruiken om plaatsen te vinden die al in de database staan.";
$pgv_lang["edit_LATI_help"]			= "~#factarray[LATI]#~<br /><br />Het invoeren van specifieke lengte- en breedtegraadcoördinaten wordt over het algemeen afgeraden, aangezien het alleen toegang tot kaarten toestaat vanuit de weergave van het specifieke element. Het is beter om de geografische plaatsen te beheren.<br /><br />Door de lengte- en breedtegraad in te voeren, kan de markering echter nauwkeuriger worden geplaatst.";
$pgv_lang["edit_LONG_help"]			= "~#factarray[LONG]#~<br /><br />Het invoeren van specifieke lengte- en breedtegraadcoördinaten wordt over het algemeen afgeraden, aangezien het alleen toegang tot kaarten toestaat vanuit de weergave van het specifieke element. Het is beter om de geografische plaatsen te beheren.<br /><br />Door de lengte- en breedtegraad in te voeren, kan de markering echter nauwkeuriger worden geplaatst.";
$pgv_lang["edit_add_parent_help"]			= "~NIEUWE VADER OF MOEDER TOEVOEGEN~<br /><br />Hiermee kunt u een vader of moeder toevoegen aan de persoon. Vul alle bekende gegevens over naam, geboorte en evt. overlijden in. Nog niet bekende gegevens kunt u later toevoegen.<br /><br />Om andere feiten aan de persoon toe te voegen, dient u eerst de ingevulde gegevens op te slaan. Daarna kunt u op de naam van de persoon klikken en op de persoonspagina, tabblad \"Persoonlijke feiten en details\", nieuwe feiten toevoegen.";
$pgv_lang["edit_add_spouse_help"]			= "~NIEUWE PARTNER TOEVOEGEN~<br /><br />Hiermee kunt u een partner toevoegen aan de geselecteerde persoon. De partner wordt als nieuw persoon in de genealogie opgenomen. Vul de naam, geboortegegevens en eventueel overlijdensgegevens in. Gegevens die nu nog ontbreken kunt u altijd later aanvullen.<br /><br />Om andere feiten aan de persoon toe te voegen, dient u eerst de ingevulde gegevens op te slaan. Daarna kunt u op de naam van de persoon klikken en op de persoonspagina, tabblad \"Persoonlijke feiten en details\", nieuwe feiten toevoegen.";
$pgv_lang["edit_death_help"]				= "~#pgv_lang[death]#~<br /><br />In deze sectie kunt u gegevens over het overlijden toevoegen. Voer eerst de datum in waarop het overlijden plaatsvond. Zorg ervoor dat de datum in het standaard genealogisch formaat wordt ingevoerd, bijvoorbeeld 1&nbsp;JAN&nbsp;2004 of 16&nbsp;MAY&nbsp;1877. U kunt ook de kalender gebruiken om een datum te selecteren: gebruik hiervoor de koppeling naast het datumvak. Voer vervolgens de locatie in waar de persoon is overleden. Gebruik de <b>#pgv_lang[find_place]#</b> koppeling om een reeds bestaande locatie te selecteren.";
$pgv_lang["edit_birth_help"]				= "~#pgv_lang[birth]#~<br /><br />In deze sectie kunt u gegevens over de geboorte toevoegen. Voer eerst de datum in waarop de geboorte plaatsvond. Zorg ervoor dat de datum in het standaard genealogisch formaat wordt ingevoerd, bijvoorbeeld 1&nbsp;JAN&nbsp;2004 of 16&nbsp;MAY&nbsp;1877. U kunt ook de kalender gebruiken om een datum te selecteren: gebruik hiervoor de koppeling naast het datumvak. Voer vervolgens de locatie in waar de persoon is geboren. Gebruik de <b>#pgv_lang[find_place]#</b> koppeling om een reeds bestaande locatie te selecteren.";
$pgv_lang["edit_sex_help"]					= "~#pgv_lang[sex]#~<br /><br />Kies het geslacht van de persoon in de keuzelijst. <b>Onbekend</b> betekent dat het geslacht niet bekend is.";
$pgv_lang["edit_name_help"]			= "~#pgv_lang[name]#~<br /><br />Dit is het belangrijkste veld in het naamrecord van een persoon.<br /><br />Dit veld moet automatisch worden ingevuld zoals de andere velden zijn ingevuld, maar het is bedoeld zodat u de informatie naar uw persoonlijke voorkeur kunt bewerken.<br /><br />De naam in dit veld moet worden ingevoerd volgens de GEDCOM 5.5.1-normen met de achternaam omgeven door schuine strepen \"/\". Als voorbeeld moet de naam \"John Robert Finlay Jr.\" als volgt worden ingevoerd: \"John Robert /Finlay/ Jr.\".";
$pgv_lang["edit_surname_help"]		= "~#pgv_lang[surname]#~<br /><br />In dit veld moet u de achternaam van de persoon invoeren. Als voorbeeld: in de naam \"John Robert Finlay\" is de achternaam die hier moet worden ingevoerd \"Finlay\"<br /><br />Personen met meerdere achternamen, die veel voorkomen in Spanje en Portugal, moeten de achternamen scheiden met een komma. Dit geeft aan dat de persoon onder elk van de namen moet worden vermeld. De achternaam \ \"Cortes,Vega\" wordt bijvoorbeeld vermeld onder zowel <b>C</b> als <b>V</b>, terwijl de achternaam \"Cortes Vega\" alleen wordt vermeld onder <b>C</b>.";
$pgv_lang["edit_NICK_help"]					= "~#factarray[NICK]#~<br /><br />In dit vak kunt u de bij- of roepnaam van een persoon invoeren. Invoer is niet verplicht.<br /><br />Er zijn verschillende manieren om een bij- of roepnaam in te voeren:<ul><li>Selecteer <b>Wijzig naam</b>, vul de roep- of bijnaam in en sla het op.</li><li>Selecteer <b>Nieuwe achternaam toevoegen</b>, vul zowel voor-, achter-, als roep- of bijnaam in en sla het op.</li><li>Selecteer <b>Wijzig GEDCOM-gegevens</b> om meerdere [2 NICK] toe te voegen onder [1 NAME].</li></ul>";
$pgv_lang["edit_given_name_help"]			= "~#pgv_lang[given_name]#~<br /><br />In dit vak kunt u de voornamen van de persoon invullen. Heet de persoon \"Piet de Groot\", dan vult u hier \"Piet\" in.";
$pgv_lang["edit_NPFX_help"]			= "~#factarray[NPFX]#~<br /><br />In dit optionele veld kunt u een naamvoorvoegsel invoeren, zoals <i>Dr.</i> of <i>Adm.</i><br /><br />Adellijke titels zoals <i>Sir, Lord, Baron, Graaf, Hertog, Freiherr,</i> enz. worden ingevoerd als een feit «#factarray[TITL]#».";
$pgv_lang["edit_NSFX_help"]			= "~#factarray[NSFX]#~<br /><br />In dit optionele veld kunt u een naamsuffix invoeren zoals <i>Jr., Sr., III, IV,</i> enz. en academische informatie zoals <i>PhD, PEng, FImechE, DVM, MD,</i> enz.";
$pgv_lang["edit_add_child_help"]	= "~#pgv_lang[add_child]#~<br /><br />Met deze pagina kunt u een nieuw kind toevoegen aan het geselecteerde gezin. Vul de naam van het kind in en de geboorte- en overlijdensinformatie als deze bekend is. Als u bepaalde informatie niet kent, laat deze dan blanco.<br /><br />Om naast geboorte en overlijden nog andere feiten toe te voegen, voegt u eerst het nieuwe kind toe aan de database door de wijzigingen op te slaan. Klik vervolgens op de naam van het kind in de bijgewerkte Familie-pagina of #pgv_lang[relatives]# tabblad om de #pgv_lang[indi_info]# pagina van het kind te bekijken. Vanaf de #pgv_lang[indi_info]# pagina kun je meer gedetailleerde informatie toevoegen.";

$pgv_lang["review_changes_help"]			= "~#pgv_lang[review_changes_block]#~<br /><br />In dit vak worden alle wijzigingen getoond die zijn aangebracht, maar nog niet door een bevoegd beheerder zijn beoordeeld en doorgevoerd.";
$pgv_lang["quick_update_name_help"] = "~#pgv_lang[update_name]#~<br /><br />Gebruik de velden \"#pgv_lang[update_name]#\" om de naam te wijzigen van de persoon die u aan het bewerken bent. Voer in het veld Voornamen de voor- of voornaam van de persoon in. Voer in het veld Achternaam de achternaam of achternaam van de persoon in. Als de naam die u wilt invoeren bijvoorbeeld \"John Robert Finlay\" is, voert u \"John Robert\" in het veld Voornaam in en \"Finlay\" in het veld Achternaam.<br /><br />Het invullen van deze velden <u>verandert</u> de naam van de persoon; het zal geen nieuwe naam toevoegen.<br /><br /><i>Let op: Wijzig de naam niet ten gevolge van een huwelijk, gebruik deze pagina dan om een nieuwe partner in te voeren.</i>";
$pgv_lang["quick_update_fact_help"]			= "~#pgv_lang[update_fact]#~<br /><br />Gebruik de vakken om nieuwe feiten toe te voegen of bestaande feiten aan te passen. Kies eerst een feit uit de keuzelijst. Voer vervolgens de datum in van wanneer het feit plaatsvond. Zorg ervoor dat de datum in het standaard genealogisch formaat wordt ingevoerd, bijvoorbeeld 1&nbsp;JAN&nbsp;2004 of 16&nbsp;MAY&nbsp;1877. U kunt ook de kalender gebruiken om een datum te selecteren: gebruik hiervoor de koppeling naast het datumvak. Voer vervolgens de locatie in waar het feit plaatsvond. Gebruik de <b>#pgv_lang[find_place]#</b> koppeling om een reeds bestaande locatie te selecteren.<br /><br />Als u informatie invoert voor een feit dat al bestaat, dan wordt de oude informatie overschreven met hetgeen u hier invoert.";
$pgv_lang["quick_update_address_help"]		= "~#pgv_lang[update_address]#~<br /><br />Gebruik de vakken <b>#pgv_lang[update_address]#</b> om adres, telefoon en e-mailgegevens van de desbetreffende persoon bij te werken.<br /><br />Als u informatie invoert voor een feit dat al bestaat, dan wordt de oude informatie overschreven met hetgeen u hier invoert.";
$pgv_lang["quick_update_spouse_help"]		= "~NIEUWE PARTNER TOEVOEGEN~<br /><br />Gebruik deze sectie als u een nieuwe partner wilt toevoegen aan de persoon. Voer de naams- en geboorte-informatie in de vakken in en, indien het om een huwelijk gaat, de huwelijksinformatie eronder. Voer datums in volgens de genealogische indeling (1&nbsp;JAN&nbsp;2005 of 16&nbsp;MAY&nbsp;1799). U kunt ook de kalender gebruiken om een datum te selecteren, klik hiervoor op de kalenderafbeelding rechts van het invoervak. U kunt <b>#pgv_lang[find_place]#</b> gebruiken om een reeds eerder in PhpGedView gebruikte locatie te selecteren.<br /><br />U kunt hiermee alleen een <i>nieuwe</i> partner toevoegen. De informatie van bestaande partner wordt niet aangepast. Om die informatie te bewerken, kunt u dit venster sluiten, op de naam van de desbetreffende partner klikken op het tabblad \"Verwanten\". Kies daarna bij de feiten of bij \"opties voor personen\" voor wat u wilt wijzigen.";
$pgv_lang["quick_update_marriage_help"]		= "~HUWELIJK BIJWERKEN~<br /><br />U kunt deze sectie gebruiken in combinatie met \"Nieuwe partner toevoegen\". In dat geval wordt een nieuw huwelijk/gezin toegevoegd. In het andere geval wordt het laatste huwelijk van de persoon aangepast. Voer datums in volgens de genealogische indeling (1&nbsp;JAN&nbsp;2005 of 16&nbsp;MAY&nbsp;1799). U kunt ook de kalender gebruiken om een datum te selecteren, klik hiervoor op de kalenderafbeelding rechts van het invoervak. U kunt <b>#pgv_lang[find_place]#</b> gebruiken om een reeds eerder in PhpGedView gebruikte locatie te selecteren.";
$pgv_lang["quick_update_child_help"]		= "~#pgv_lang[add_new_chil]#~<br /><br />Gebruik deze sectie om een nieuw kind toe te voegen aan de persoon. Voer eerst de namen van het kind in en het geslacht, vervolgens de datum en plaats van geboorte. Voer datums in volgens de genealogische indeling (1&nbsp;JAN&nbsp;2005 of 16&nbsp;MAY&nbsp;1799). U kunt ook de kalender gebruiken om een datum te selecteren, klik hiervoor op de kalenderafbeelding rechts van het invoervak. U kunt <b>#pgv_lang[find_place]#</b> gebruiken om een reeds eerder in PhpGedView gebruikte locatie te selecteren.<br /><br />U kunt hiermee alleen een <i>nieuw</i> kind toevoegen. De informatie van een bestaand kind wordt niet aangepast. Om die informatie te bewerken kunt u dit venster sluiten, op de naam van het desbetreffende kind klikken op het tabblad #pgv_lang[relatives]#. Kies daarna bij de feiten of bij \"opties voor personen\" voor wat u wilt wijzigen.";
$pgv_lang["index_top10_pageviews_help"]		= "~#pgv_lang[top10_pageviews]#~<br /><br />In dit blok staan de personen, families of bronnen die het meest zijn bekeken door bezoekers van deze site. Om dit blok te laten verschijnen, moet de sitebeheerder de itemtreffertellers hebben ingeschakeld.";
$pgv_lang["index_cookiepolicy_help"]		= "~#pgv_lang[block_cookiepolicy]#~<br /><br />Dit blok toont de cookie beleid van deze website.";
$pgv_lang["cookiepolicy_link_help"]			= "~#pgv_lang[block_cookiepolicy_link]#~<br /><br />Laat dit veld leeg als U de standaard tekst wilt gebruiken.<br /><br />Als U de standaard tekst wilt gebruiken en ook een link wilt geven naar een tekstbestand of HTML-pagina die specifieke gegevens bevat over het cookie beleid voor deze site, kunt U de URL naar die pagina hier invoegen.<br /><br />Bijvoorbeeld, <b>http://foo.bar.com/policy/cookies.txt</b> zou kunnen wijzen op een tekstbestand, terwijl <b>http://foo.bar.com/policy/cookies.htm</b> verwijst naar een HTML opgemaakte pagina, en <b>http://foo.bar.com/policy/cookies.doc</b> verwijst naar een document in Microsoft Word formaat.";
$pgv_lang["cookiepolicy_link_advice"]		= "Laat leeg om de standaard tekst te gebruiken.<br /><br />Voer een URL in, zoals, bijvoorbeeld, <b>http://foo.bar.com/policy/cookies.txt</b> om ook wijzen op een pagina die meer informatie over de cookie beleid van uw site bevat.";
$pgv_lang["useradmin_user_default_tab_help"] = "~#pgv_lang[user_default_tab]#~<br /><br />Deze instelling bepaalt welk tabblad standaard wordt getoond als de gebruiker de gegevens van een persoon bekijkt. Als gebruikers hun gebruikersgegevens mogen aanpassen, kunnen ze deze instelling later zelf wijzigen.";
$pgv_lang["edituser_user_default_tab_help"]	= "~#pgv_lang[user_default_tab]#~<br /><br />Deze instelling bepaalt welk tabblad standaard wordt getoond als de gebruiker de gegevens van een persoon bekijkt.";
$pgv_lang["reorder_children_help"]		= "~#pgv_lang[reorder_children]#~<br /><br />Kinderen worden weergegeven in de volgorde waarin ze in het gezinsrecord voorkomen. Kinderen worden niet automatisch op geboortedatum gesorteerd, omdat de geboortedata van sommige kinderen vaak onzeker zijn, maar de volgorde van hun geboorte <u>is</u> bekend.<br /><br />Met deze optie kunt u de volgorde van de kinderen in het gezinsrecord wijzigen. Omdat u de kinderen misschien op hun geboortedatum wilt sorteren, is er een knop waarop u kunt drukken om dit voor u te doen.<br /><br />U kunt ook elk informatievenster slepen en neerzetten om de volgorde van de kinderen te wijzigen. Als u de muiscursor over een informatievak beweegt, verandert de vorm in een paar tweekoppige gekruiste pijlen. Als u de linkermuisknop ingedrukt houdt voordat u de muiscursor verplaatst, volgt het informatievenster de muiscursor omhoog of omlaag in de lijst. Als de informatiebox wordt verplaatst, zullen de andere dozen ruimte maken. Wanneer u de linkermuisknop loslaat, neemt het informatievenster zijn nieuwe plaats in de lijst in.";
$pgv_lang["rss_feed_help"]				= "~#pgv_lang[rss_feeds]#~<br /><br />Met de ATOM / RSS-feed die beschikbaar is in PhpGedView, kan iedereen met behulp van een geschikte feed-aggregator de inhoud van de welkomstpagina van uw site bekijken zonder de site te bezoeken. De meeste aggregators zullen een melding laten verschijnen om de gebruiker te laten weten wanneer er iets is veranderd op een pagina die wordt gecontroleerd. Hierdoor kan in wezen iedereen uw PhpGedView-site volgen zonder deze regelmatig te hoeven bezoeken.<br /><br />Het feedblok wordt gebruikt om de link naar de feed aan te passen, waardoor specifieke feedtypen mogelijk zijn (de meeste lezers kunnen de meeste typen verwerken, dus dit kan meestal op de standaard worden gelaten) en de specifieke module die u in uw feed wilt hebben. De taal van de feed en de gebruikte GEDCOM is gebaseerd op de taal en GEDCOM die actief is in PhpGedView wanneer je de feed selecteert.<br /><br />De soorten feed die kunnen worden gegenereerd, zijn onder meer ATOM, RSS 2.0, RSS 1.0, RSS 0.92, HTML en JavaScript. De eerste vier typen zijn voor feed-aggregators, terwijl JavaScript en HTML bedoeld zijn om opname van de feeds op andere webpagina's mogelijk te maken. Merk op dat de nummers van de RSS-feed verschillende stijlen aangeven, niet een andere versie.<br /><br />Er is een optie om authenticatie te selecteren waarmee de gebruiker inlogt en de gebruiker deze kan bekijken met behulp van een geschikte RSS aggregator, alle informatie die hij normaal zou kunnen zien als hij was ingelogd. Basisverificatie gebruikt <i>Basis HTTP-verificatie</i> om de gebruiker in te loggen. Toekomstige verbeteringen kunnen <i>Digest-verificatie</i> mogelijk maken.<br /><br />Dit <a href='https://nl.wikipedia.org/wiki/Really_Simple_Syndication' target='_blank' alt='Wikipedia-artikel' title='Wikipedia-artikel'><b>Wikipedia-artikel</b></a> bevat uitgebreide informatie en links over RSS en de verschillende RSS-formaten. <i>Basis HTTP-authenticatie</i> wordt besproken, in Engels, in dit <a href='https://en.wikipedia.org/wiki/Basic_authentication_scheme' target='_blank' alt='Wikipedia-artikel' title='Wikipedia-artikel'><b>Wikipedia-artikel</b></a>, terwijl <i>Digest-verificatie</i> wordt besproken, in Engels, in dit <a href='https://en.wikipedia.org/wiki/Digest_access_authentication' target='_blank' alt='Wikipedia-artikel' title='Wikipedia-artikel'><b>Wikipedia-artikel</b></a>.";

$pgv_lang["upload_media_help"]			= "Selecteer de bestanden op uw computer die u naar de server wilt uploaden. Alle bestanden worden geplaatst in de map <b>#MEDIA_DIRECTORY#</b> of een van de submappen.<br /><br />Mapnamen die u specificeert worden toegevoegd aan <b>#MEDIA_DIRECTORY#</b>, bijvoorbeeld <b>#MEDIA_DIRECTORY#fotoos</b>. Als de map voor miniweergaves niet bestaat, wordt deze automatisch aangemaakt.";
$pgv_lang["upload_media_folder_help"]		= "~#pgv_lang[folder]#~<br /><br />Uw GEDCOM configuratie is ingesteld om #GLOBALS[MEDIA_DIRECTORY_LEVELS]# mappen nivo's dieper te gaan dan de standaard <b>#GLOBALS[MEDIA_DIRECTORY]#</b> map, waar ge-uploade media bestanden normaliter worden opgeslagen. Hierdoor kunt u de mediabestanden beter organiseren en u hoeft er minder op te letten dat elk media bestand een unieke naam zou moeten hebben.<br /><br />In dit veld geeft u de bestemmingsmap op uw server op, waar het te uploaden bestand moet worden opgeslagen. Overtuig u ervan dat de benaming hier goed wordt ingevuld. Denk om HOOFD- en kleine letters, aangezien bestands- en mappen namen hoofdlettergevoelig zijn.<br /><br />Als de mapnaam, die u hier invult, niet bestaat, dan wordt die map automatisch aangemaakt. Als u meer mappen nivo's opgeeft dan de ingestelde #GLOBALS[MEDIA_DIRECTORY_LEVELS]# mappen nivo's in de GEDCOM instellingen, dan wordt uw invoer afgekapt tot het toegestane aantal mappen.<br /><br />Miniweergave bestanden worden geupload, of automatisch gemaakt, in dezelde mappenstructuur, beginnend met <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.";
$pgv_lang["upload_media_file_help"]			= "~#pgv_lang[media_file]#~<br /><br />In dit veld geeft u de plaats en naam op, op uw lokale computer, van het mediabestand, dat u naar onze server wilt sturen.  U kunt de <b>Bladeren</b> knop gebruiken om op uw lokale computer het gewenste bestand te zoeken.<br /><br />Het bestand zal dezelfde naam krijgen op onze server. Het zal worden geplaatst in de map, dat is aangegeven in het veld <b>#pgv_lang[folder]#</b>.<br /><br />Als u het <b>#pgv_lang[folder]#</b> veld niet ziet, of anders niet kunt wijzigen, heeft u niet voldoende rechten, of het programma is door de beheerder zodanig ingesteld dat geen mappen buiten de standaard map <b>#GLOBALS[MEDIA_DIRECTORY]#</b>, waar de opgeladen bestanden normaal gesproken worden opgeslagen, zijn toegestaan.  In dat geval wordt het mediabestand geplaatst in de map  <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.";
$pgv_lang["upload_thumbnail_file_help"]		= "~#pgv_lang[thumbnail]#~<br /><br />In dit veld geeft u de plaats en naam op, op uw lokale computer, van het miniweergavebestand, dat u naar onze server wilt sturen.  U kunt de <b>Bladeren</b> knop gebruiken om op uw lokale computer het gewenste bestand te zoeken.  Als dit veld is ingevuld, wordt het <b>#pgv_lang[auto_thumbnail]#</b> keuzevakje niet gebruikt.<br /><br />Als het <b>#pgv_lang[media_file]#</b> veld is ingevuld, wordt uw miniweergavebestand genoemd zolas het veld is ingevuld, ongeacht hoe het bestand op uw lokale computer heet.  Als het veld leeg blijft, wordt een kopie van het miniweergavebestand op twee plaatsen van de servergezet. Een keer in de server map, genoemd in het <b>#pgv_lang[folder]#</b> veld. Een tweede kopie gaat naar een identieke mappenstructuur, beginnend met <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />Als u het <b>#pgv_lang[folder]#</b> veld niet ziet, of anders niet kunt wijzigen, heeft u niet voldoende rechten, of het programma is door de beheerder zodanig ingesteld dat geen mappen buiten de standaard <b>#GLOBALS[MEDIA_DIRECTORY]#</b>, waar de opgeladen bestanden normaal gesproken worden opgeslagen, zijn toegestaan.";


//-- GENERAL
$pgv_lang["help_header"]					= "Informatie over:";
$pgv_lang["privacy_error_help"]				= "~GEGEVENS ZIJN VERBORGEN~<br /><br />Als deze boodschap verschijnt kan dit een aantal oorzaken hebben:<br /><ul><li><b>Informatie van levende personen is verborgen voor bezoekers.</b><br />Bezoekers en geregistreerde gebruikers die niet zijn aangemeld, kunnen alleen volledige informatie zien van overleden personen. Indien toegestaan door de systeembeheerder, kunnen bezoekers zich registreren voor een account door op de knop Inloggen te klikken en vervolgens op de link #pgv_lang[requestaccount]#.</li><li><b>U beschikt over een gebruikersnaam en een wachtwoord......</b><br />Maar u bent niet succesvol ingelogd of u bent een tijdje inactief geweest en uw sessie is verlopen.</li><li><b>Gegevens van deze persoon zijn verborgen.</b><br />De persoon wil helemaal niet getoond worden (verborgen) en heeft mogelijk de admin gevraagd om hem of haar in te stellen op \"Privé\". Privacy kan worden ingesteld op:<ul><li>#pgv_lang[PRIV_USER]#</li><li>#pgv_lang[PRIV_NONE]#</li><li>#pgv_lang[PRIV_HIDE]#</li></ul></li><li><b>Gegevens buiten \"relatiepad\"</b><br />Zelfs als u een gewone gebruiker bent <u> en </u> bent ingelogd, kan het toch gebeuren dat u dit bericht te zien krijgt als de persoon die u probeert te bekijken geen familie van u is binnen het aantal relatiestappen (Relation Path length) ingesteld door de sitebeheerder voor deze GEDCOM.<br /><br />Voorbeelden:<br />Wanneer de lengte van het relatiepad is ingesteld op <b>1</b>, kunt u alleen de details van uw eigen gezin, vader, moeder, broer, zus zien (maar niet de echtgenoten en kinderen van uw broer of zus)<br /><br />Als het relatiepad is ingesteld op <b>2</b>, kun je ook de details van de vrouw van je broer en hun kinderen zien (maar niet de echtgenoten van hun kinderen).<br /><br />Hoe hoger de instelling voor de lengte van het relatiepad, hoe meer verwanten op afstand je kunt zien.</li></ul><br />Als u van mening bent, dat u van te weinig personen details kunt zien, neemt u dan contact op met de beheerder via de koppeling onder in het scherm.";
$pgv_lang["more_help"]						= "Als u meer specifieke helpinformatie wilt hebben, zorg er dan voor dat de <b>#pgv_lang[show_context_help]#</b> (in het Help-menu) aan staat, en klik op een <b>?</b> bij een onderwerp.";
$pgv_lang["start_admin_help"]				= "+++ Start extra informatie voor de beheerder +++";
$pgv_lang["end_admin_help"]					= "+++ Einde extra informatie voor de beheerder +++";
$pgv_lang["multiple_help"]					= "<span class='center'>--- Dit is een algemene helptekst voor meerdere pagina's ---</span>";
$pgv_lang["header_general_help"]			= "<div class='name_head center'><b>ALGEMENE INFORMATIE</b></div>";
$pgv_lang["best_display_help"]				= "~#pgv_lang[resolution]#~<br /><br />PhpGedView is ontworpen voor een beeldschermresolutie van 1024x768. Als u uw PC op minimaal deze waarde heeft ingesteld, wordt alles correct op het scherm getoond.<br /><br />Als u de resolutie op een lagere waarde instelt, zoals 800x600, passen de pagina's niet meer geheel op uw beeldscherm en moet u de horizontale schuifbalk van uw Internet verkenner gebruiken.";
$pgv_lang["preview_help"]					= "~#pgv_lang[print_preview]#~<br /><br />Als u op <b>#pgv_lang[print_preview]#</b> klikt, worden de items verwijderd die er niet goed uitzien op een afgedrukte pagina (menu's, invoervakken, extra links, de vraagtekens voor de contextuele hulp, enz.)<br /><br />U krijgt een knop <b>#pgv_lang[print]#</b> onderaan de vereenvoudigde pagina; wanneer u op deze knop klikt, verschijnt het afdrukvenster van uw systeem. Klik na het afdrukken op <b>#pgv_lang[cancel_preview]#</b> en het scherm wordt normaal opnieuw opgebouwd.<br /><br />Opmerking: hoewel deze optie veel links van de weergegeven pagina verwijdert, zijn de overige links nog steeds actief.";
$pgv_lang["readme_help"]					= "<span class='center'>Zie het bestand <a href=\"readme.txt\" target=\"_blank\"><b>Readme.txt</b></a> voor meer informatie over dit onderwerp.</span>";
$pgv_lang["is_user_help"]					= "--- Deze helptekst is dezelfde als aan gebruikers en bezoekers wordt getoond. ---<br />--- Om ruimte te besparen, is geen aparte tekst voor beheerders beschikbaar. ---";
$pgv_lang["edit_raw_gedcom_help"]	= "~#pgv_lang[edit_raw]#~<br /><br />Wanneer u op deze link klikt, wordt een nieuw venster geopend met de ruwe GEDCOM-gegevens van de details op deze pagina.<br /><br />Hier kunt u de GEDCOM-gegevens rechtstreeks bewerken. Zorg ervoor dat u geldige GEDCOM 5.5.1-gegevens invoert, aangezien er geen verdere geldigheidscontroles zullen worden uitgevoerd. De gewijzigde of toegevoegde gegevens worden in PhpGedView weergegeven als \"wijzigingen\" en moeten worden geaccepteerd door een gebruiker met acceptatierechten.";
$pgv_lang["RESN_help_title"]				= "Beperking toegang tot feiten";
$pgv_lang["RESN_help"]						= "~#pgv_lang[RESN_help_title]#~<br /><br />Naast de normale privacy-instellingen, kunnen in PhpGedView eveneens beperkingen worden aangebracht op het tonen en wijzigen van feiten bij personen en gezinnen. De beperkingen kunnen worden aangebracht door iedereen die de informatie mag wijzigen, tenzij privacy-instellingen of eerder aangebrachte beperkingen dit verhinderen.<br /><br />De volgende waarden kunnen worden toegekend:<br /><ul><li><b>#pgv_lang[none]#</b><br />Site-beheerders, GEDCOM-beheerder en gebruikers met rechten om te wijzigen, kunnen de informatie wijzigen. De informatie is zichtbaar voor zover de door de beheerder ingestelde privacy-instellingen dit toelaten.</li><li><b>#pgv_lang[locked]#</b><br />Deze instelling heeft geen effect op de zichtbaarheid van de informatie, maar beperkt wijzig-rechten tot Site- en GEDCOM-beheerders. Als de informatie betrekking heeft op de gebruiker zelf, kan hij deze zien en, aangenomen dat hij wijzig-rechten heeft, ook aanpassen.</li><li><b>#pgv_lang[privacy]#</b><br />Site-beheerders en GEDCOM-beheerders kunnen de informatie zien en wijzigen. Als de informatie betrekking heeft op de gebruiker zelf, kan hij deze zien en, aangenomen dat hij wijzig-rechten heeft, ook aanpassen. De informatie blijft verborgen voor alle andere (al dan niet aangemelde) gebruikers.</li><li><b>#pgv_lang[confidential]#</b><br />Alleen Site-beheerders en GEDCOM-beheerders kunnen de informatie zien en wijzigen. Het is verborgen voor alle andere (al dan niet aangemelde) gebruikers.</li></ul><br /><table><tr><th></th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Beheerder</th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Eigenaar</th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Anderen</th></tr><tr><th></th><th></th><th>L</th><th>B</th><th></th><th>L</th><th>B</th><th></th><th>L</th><th>B</th></tr><tr><td><img src=\"images/RESN_none.gif\" alt=\"\" />&nbsp;#pgv_lang[none]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_locked.gif\" alt=\"\" />&nbsp;#pgv_lang[locked]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /><th></th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_privacy.gif\" alt=\"\" />&nbsp;#pgv_lang[privacy]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_confidential.gif\" alt=\"\" />&nbsp;#pgv_lang[confidential]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr></table><ul><li>L : kan lezen</li><li>B : kan bewerken</li><li><img src=\"images/checked_qm.gif\" alt=\"\" /> : hangt af van globaale privacy-instellingen</li></ul>";


//-- Pages Help-messages
//-- Index-page
$pgv_lang["index_help"]						= "~#pgv_lang[welcome_page]#~<br /><br />Deze pagina is de startpagina van de geselecteerde genealogie. U kunt hier altijd terugkeren, door te klikken op de knop \"Welkomstpagina\" in de menubalk.<br />Als er op deze site meerdere genealogieën beschikbaar zijn, kunt u er een uit het submenu van de knop \"Welkomstpagina\" kiezen.<br /><br />In deze HELP-informatie treft u, naast een toelichting op deze pagina, ook algemene informatie aan over deze website en het gebruik ervan. Aan de orde komen:<ul><li><a href=\"#index_portal\"><b>#pgv_lang[welcome_page]#</b></a><li><a href=\"#header\"><b>Menubalk</b></a><li><a href=\"#menu\"><b>Menu's</b></a><li><a href=\"#header_general\"><b>Algemene informatie</b></a><li><a href=\"#def\"><b>Definities</b></a></ul><br />Op alle andere pagina's is de help (<b>Help bij deze pagina</b> in het Help-menu) beperkt tot informatie over de desbetreffende pagina.";

//-- Index-page Header
$pgv_lang["header_help"]					= "<div class='name_head center'><b>DE MENUBALK</b></div><br />De menubalk wordt gebruikt om de functies van PhpGedView te benaderen. Afhankelijk van het gekozen website-thema is de menubalk altijd aan de bovenzijde of linkerzijde van het scherm te zien, en kan de knopindeling afwijken van de standaard indeling.<br /><br />In de menubalk vindt u de volgende knoppen/functies:<ul><li><a href=\"#header_search\"><b>#pgv_lang[search]#</b></a></li><li><a href=\"#header_lang_select\"><b>#pgv_lang[change_lang]#</b></a></li><li><a href=\"#header_user_links\"><b>#pgv_lang[login]#</b></a></li><li><a href=\"#header_favorites\"><b>#pgv_lang[my_favorites]#</b></a></li><li><a href=\"#header_theme\"><b>#pgv_lang[change_theme]#</b></a></li></ul>";
$pgv_lang["header_search_help"]			= "~#pgv_lang[header]# «#pgv_lang[search]#»~<br /><br />Dit zoekvak is klein maar krachtig. U kunt PhpGedView bijna alles voor u laten zoeken. Als u op de knop <b>&gt;</b> of <b>Zoeken</b> klikt, wordt u doorgelinkt naar de zoekpagina om de resultaten van uw zoekopdracht te zien. Op de pagina Zoeken vindt u uitgebreide hulp over zoekmogelijkheden.";
$pgv_lang["header_lang_select_help"]	= "~#pgv_lang[header]# «#pgv_lang[change_lang]#»~<br /><br />Een van de belangrijkste kenmerken van PhpGedView is dat meerdere talen worden ondersteund.<br /><br />De taal waarin PhpGedView alle pagina's weergeeft, wordt automatisch bepaald volgens de voorkeurstaalinstelling van de browser. Het is echter mogelijk dat de sitebeheerder de beschikbaarheid van bepaalde talen heeft beperkt.<br /><br />Afhankelijk van de siteconfiguratie kunt u de taal van PhpGedView mogelijk wijzigen door een meer geschikte taal uit een lijst te selecteren of door op een vlagpictogram te klikken. Als u een geregistreerde gebruiker bent, kunt u PhpGedView configureren om over te schakelen naar uw voorkeurstaal nadat u zich heeft aangemeld, ongeacht waar uw browser op is ingesteld.";
$pgv_lang["header_user_links_help"]		= "~#pgv_lang[header]# «#pgv_lang[login]#»~<br /><br />De #pgv_lang[login]# is een klein blok met handige links die op elke pagina op dezelfde plek te vinden zijn. De locatie van deze links is afhankelijk van het thema dat momenteel van kracht is.<br /><br />Als u niet bent ingelogd, ziet u alleen de link <b>#pgv_lang[login]#</b>. Nadat u zich heeft aangemeld, ziet u:<ul><li><b>Ingelogd als (uw gebruikersnaam)</b>. Als u op die link klikt, gaat u naar uw accountpagina.</li><li>Klik op <b>Afmelden</b> om uit te loggen.</li><li>Als u beheerdersrechten heeft, ziet u ook <b>Admin</b>. Als u op deze link klikt, gaat u rechtstreeks naar de hoofdpagina van de administratie.</li></ul>";
$pgv_lang["header_favorites_help"]		= "~#pgv_lang[header]# «#pgv_lang[gedcom_favorites]#»~<br /><br />De favorietenlijst toont de favorieten die u heeft geselecteerd op uw gepersonaliseerde portaalpagina. Het toont ook de favorieten die de sitebeheerder heeft geselecteerd voor de momenteel actieve GEDCOM. Als u op een van de favorieten-items klikt, gaat u rechtstreeks naar de #pgv_lang[indi_info]# pagina van die persoon.<br /><br />Meer helpinformatie over Favorieten is beschikbaar op uw persoonlijke MyGedView pagina.";
$pgv_lang["header_theme_help"]			= "~#pgv_lang[header]# «#pgv_lang[change_theme]#»~<br /><br />Indien ingeschakeld door de sitebeheerder, toont de lijst Thema wijzigen u een lijst met thema's die u kunt gebruiken om de site te bekijken.<br /><br />U kunt het uiterlijk van de site wijzigen door een thema uit de lijst te selecteren. Als u bent aangemeld, wordt ook uw gebruikersthema gewijzigd in het door u gekozen thema, zodat bij de volgende aanmelding automatisch hetzelfde thema wordt geselecteerd.";

//-- Index-page Menu
$pgv_lang["menu_help"]						= "<div class='name_head center'><b>MENU'S</b></div><br />In de menubalk bevinden zich, onder de menuknoppen, submenu's. Als u met uw muisaanwijzer over de menuknoppen gaat, krijgt u het submenu te zien.<br />Als u op een menuknop klikt, kiest u automatisch de eerste menukeuze van het submenu.<br />U vindt u in de menubalk de volgende menu's en koppelingen:<ul><li><a href=\"#menu_fam\"><b>#pgv_lang[welcome_page]#</b></a></li><li><a href=\"#menu_myged\"><b>#pgv_lang[mygedview]#</b></a></li><li><a href=\"#menu_charts\"><b>#pgv_lang[charts]#</b></a></li><li><a href=\"#menu_lists\"><b>#pgv_lang[lists]#</b></a></li><li><a href=\"#menu_annical\"><b>#pgv_lang[anniversary_calendar]#</b></a></li><li><a href=\"#menu_clip\"><b>#pgv_lang[clippings_cart]#</b></a></li><li><a href=\"#menu_search\"><b>#pgv_lang[search]#</b></a></li><li><a href=\"#menu_help\"><b>#pgv_lang[page_help]#</b></a></li></ul>";
$pgv_lang["menu_famtree_help"]			= "~#pgv_lang[welcome_page]#~<br /><br />In dit menu worden alle beschikbare genealogische databases van deze site weergegeven. Elke database heeft zijn eigen aangepaste welkomstpagina, zoals deze. Als er slechts één database op deze site is, is er geen submenu onder het pictogram Welkompagina.";
$pgv_lang["menu_myged_help"]			= "~#pgv_lang[mygedview]#~<br /><br />Als u bent ingelogd, kan dit menu de volgende items bevatten:<ul><li><a href=\"?help=index_myged_help\"><b>#pgv_lang[mygedview]#</b></a><br />Hiermee gaat u naar uw eigen aanpasbare startpagina.</li><li><a href=\"?help=help_edituser.php\"><b>#pgv_lang[editowndata]#</b></a><br />Hier kunt u uw persoonlijke gegevens wijzigen.</li><li><a href=\"?help=help_pedigree.php\"><b>#pgv_lang[my_pedigree]#</b></a><br />Als u een Root-persoon voor deze GEDCOM hebt geselecteerd, gaat u naar de stamboom van die persoon.</li><li><a href=\"?help=help_individual.php\"><b>#pgv_lang[my_indi]#</b></a><br />Deze link brengt u naar uw #pgv_lang[indi_info]# pagina, waar alle genealogische gegevens over uzelf en uw gezin worden weergegeven.</li></ul>";
$pgv_lang["menu_charts_help"]				= "~#pgv_lang[charts]#~<br /><br />In dit menu zijn de volgende overzichten beschikbaar:<ul><li><a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a><br />In dit overzicht worden de voorouders van de startpersoon van de kwartierstaat getoond. Als u bent aangemeld als gebruiker, kunt u de startpersoon zelf instellen, of bent u in sommige gevallen de startpersoon zelf al.</li><li><a href=\"?help=help_descendancy.php\"><b>#pgv_lang[descend_chart]#</b></a><br />Dit overzicht toont de nakomelingen van de startpersoon. Voor de startpersoon geldt hier hetzelfde als bij het item <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a.</li><li><a href=\"?help=help_timeline.php\"><b>#pgv_lang[timeline_chart]#</b></a><br />Met deze functie kunt u een of meer personen aan een tijdlijn toevoegen, waarna de gebeurtenissen van deze personen op een tijdlijn worden getoond..</li><li><a href=\"?help=help_relationship.php\"><b>#pgv_lang[relationship_chart]#</b></a><br />Hiermee kunt u de verwantschap tussen een persoon en uzelf, of een ander persoon, vaststellen.</li><li><a href=\"?help=help_ancestry.php\"><b>#pgv_lang[ancestry_chart]#</b></a><br />Deze lijkt veel op de <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, maar toont meer details en kan bekeken worden in een verschillende <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a>.</li><li><a href=\"?help=help_fanchart.php\"><b>#pgv_lang[fan_chart]#</b></a><br />Deze lijkt veel op de <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, maar toont de gegevens in een meer grafische vorm.</li></ul>";
$pgv_lang["menu_lists_help"]				= "~#pgv_lang[lists]#~<br /><br />De volgende soorten detailgegevens zijn beschikbaar in dit menu:<ul><li><a href=\"?help=help_indilist.php\"><b>#pgv_lang[individual_list]#</b></a></li><li><a href=\"?help=help_famlist.php\"><b>#pgv_lang[family_list]#</b></a><br />In deze twee lijsten kunt u door alfabetische lijsten van individuen of families in deze GEDCOM bladeren.</li><li><a href=\"?help=help_sourcelist.php\"><b>#pgv_lang[source_list]#</b></a><br />Dit geeft een lijst van alle gebruikte bronnen in deze genealogie.</li><li><a href=\"?help=help_placelist.php\"><b>#pgv_lang[place_list]#</b></a><br />Hier kunt u personen en gezinnen zoeken, waarvan een gebeurtenis is gekoppeld aan een bepaalde plaats.</li><li><a href=\"?help=help_medialist.php\"><b>#pgv_lang[media_list]#</b></a><br />Deze optie ziet u alleen als dit door de beheerder is ingeschakeld. Getoond worden alle koppelingen naar multimedia-items in deze genealogie.</li></ul>";
$pgv_lang["menu_annical_help"]				= "~#pgv_lang[anniversary_calendar]#~<br /><br />Met deze functie kunt u zien, welke gebeurtenissen er op een bepaalde dag of in een bepaalde maand of jaar in het verleden hebben plaatsgevonden.<ul><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewday]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewmonth]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewyear]#</b></a><br />Deze menu-items brengen je naar de #pgv_lang[anniversary_calendar]# om een lijst met alle gebeurtenissen voor de huidige dag, maand of jaar weer te geven.</li></ul>";
$pgv_lang["menu_clip_help"]					= "~#pgv_lang[clippings_cart]#~<br /><br />Als deze optie zichtbaar is in de menubalk, is deze door de sitebeheerder ingeschakeld.<br /><br />Met de knipselbak kunt u stukjes uit de genealogie verzamelen in uw knipselbak en ze daarna, in GEDCOM 5.5.1 formaat, naar uw eigen computer downloaden.";
$pgv_lang["menu_search_help"]				= "~#pgv_lang[search]#~<br /><br />Dit menu heeft geen keuzes, maar brengt u meteen naar de zoekpagina van PhpGedView. Dit is dezelfde pagina, als die vanuit het \"Zoeken\"-veld elders op de pagina wordt gebruikt.";
$pgv_lang["menu_help_help"]					= "~#pgv_lang[page_help]#~<br /><br />#pgv_lang[help_help_items]#";

//-- Index-page Portal
$pgv_lang["index_portal_head_help"]			= "<div class='name_head center'><b>WELKOMSTPAGINA</b></div>";
$pgv_lang["index_portal_help"]				= "Deze Welkomstpagina geeft informatie over de gekozen genealogie en bestaat, net als de persoonlijke MyGedView-pagina, uit verschillende vakken. Per genealogie is er een aparte Welkomstpagina, die door de beheerder wordt vervaardigd. De volgende vakken kunnen zichtbaar zijn:<ul><li><a href=\"#index_welcome\"><b>#pgv_lang[welcome_block]#</b></a></li><li><a href=\"#index_login\"><b>#pgv_lang[login_block]#</b></a></li><li><a href=\"#index_events\"><b>#pgv_lang[upcoming_events_block]#</b></a></li><li><a href=\"#index_onthisday\"><b>#pgv_lang[todays_events_block]#</b></a></li><li><a href=\"#index_charts\"><b>#pgv_lang[charts_block]#</b></a></li><li><a href=\"#index_favorites\"><b>#pgv_lang[gedcom_favorites_block]#</b></a></li><li><a href=\"#index_stats\"><b>#pgv_lang[gedcom_stats_block]#</b></a></li><li><a href=\"#index_common_surnames\"><b>#pgv_lang[block_top10]#</b></a></li><li><a href=\"#index_media\"><b>#pgv_lang[random_media_block]#</b></a></li><li><a href=\"#index_loggedin\"><b>#pgv_lang[logged_in_users_block]#</b></a></li><li><a href=\"#gedcom_news\"><b>#pgv_lang[gedcom_news_block]#</b></a></li><li><a href=\"#recent_changes\"><b>#pgv_lang[recent_changes_block]#</b></a></li></ul>";
$pgv_lang["index_welcome_help"]			= "~#pgv_lang[welcome_block]#~<br /><br />Het welkomstblok toont u de huidige databasetitel, de datum en tijd, en, indien ingeschakeld door de beheerder, de trefferteller.<br /><br />De trefferteller is alleen beschikbaar in het welkomstblok en op de #pgv_lang[indi_info]# pagina. De teller telt de \"Treffer\" van deze pagina's. Dat betekent dat het telt hoe vaak deze pagina's worden bezocht. De teller controleert het internetadres van een bezoeker niet; elk bezoek aan een pagina vanaf <u>elke</u> externe locatie telt als een nieuwe treffer.";
$pgv_lang["index_login_help"]				= "~#pgv_lang[login_block]#~<br /><br />U kunt op bijna elke pagina van dit programma inloggen. Meestal doet u dit op de eerste pagina, aangezien u alleen toegang heeft tot geprivilegieerde informatie wanneer u bent ingelogd.<br /><br />U kunt inloggen door uw <b>#pgv_lang[username]#</b> en <b>#pgv_lang[password]#</b> in te typen en vervolgens op de knop <b>#pgv_lang[login]#</b> te klikken.";
$pgv_lang["index_events_help"]			= "~#pgv_lang[upcoming_events_block]#~<br /><br />Dit blok toont je jubilea van evenementen die in de nabije toekomst aankomen.<br /><br />De administrator bepaalt hoe ver het blok vooruit zal kijken. U kunt de weergave van aankomende evenementen in het blok verder verfijnen door middel van verschillende configuratie-opties.<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["todo_help"]						= "~#pgv_lang[todo_block]#~<br /><br />Dit blok helpt u bij te houden welke  <b>_TODO</b> taken in de database no uitstaan.<br /><br />Om Te Doen taken aan uw kaarten toe te voegen, moeten eerst de GEDCOM instellingen worden aangepast, zodat het  <b>_TODO</b> feit in de lijst komt te staan van feiten, die kunnen worden toegevoegd aan de kaarten van personen, gezinnen, families, bronnen en bewaarplaatsen.  Elk van genoemde lijsten, die u kunt vinden in de Opties voor wijzigen sectie van de GEDCOM configuratie, is onafhankelijk.  De volgorde van de lijstinhoud is niet belangrijk; u kunt de nieuwe toevoegingen aan het begin van elke lijst zetten.";
$pgv_lang["todo_show_other_help"]			= "Toon taken, die zijn toegewezen aan andere gebruikers.";
$pgv_lang["todo_show_unassigned_help"]		= "Toon taken, die nog niet aan iemand zijn toegewezen.";
$pgv_lang["todo_show_future_help"]			= "Toon taken die een datum in de toekomst hebben.<br />Anders worden alleen items getoond met een datum in het verleden.";
$pgv_lang["yahrzeit_help"]					= "~#pgv_lang[yahrzeit_block]#~<br /><br />Dit blok toont de Yahrzeiten, welke aanstaande zijn, in de nabije toekomst.<br /><br />Yahrzeiten (enklevoud: Yahrzeit) zijn verjaardagen van het overlijden van een persoon.  Deze verjaardagen komen voor in de Joodse traditie; in andere tradities is dit in onbruik geraakt. «Yahrzeit» kan ook worden gespeld ald «Jahrzeit» of «Yartzeit».<br /><br />De beheerder bepaald hoever vooruit het programma kijkt. Hoe het blok wordt getoond kan ook nog verder worden aangepast.<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["days_to_show_help"]				= "~#pgv_lang[days_to_show]#~<br /><br />Voer het aantal dagen in dat u wilt tonen.  Dit getal kan niet groter zijn dan <b>#DAYS_TO_SHOW_LIMIT#</b>.  Als u een grotere waarde invoert, zal de limiet worden toegepast.<br /><br />De limiet van het te tonen aantal, is ingesteld, door de beheerder, in de  GEDCOM instellingen,  Display en Layout sectie, Verberg &amp; Toon sub-sectie.";
$pgv_lang["random_media_persons_or_all_help"] = "~#pgv_lang[random_media_persons_or_all]#~<br /><br />Met deze optie bepaalt u welk type media wordt getoond.<br /><br />Als u <b>#pgv_lang[random_media_persons]#</b> selecteert, wordt alleen media getoond m.b.t. personen. Vaak zijn de foto's van personen. Als u <b>#pgv_lang[random_media_events]#</b> selecteert, wordt alleen media getoond m.b.t. feiten of gebeurtenissen. Dit kan bijv. een afbeelding van een certificaat zijn. Als u <b>#pgv_lang[all]#</b> selecteert, zal dit blok alle types media tonen.";
$pgv_lang["random_media_filter_help"]		= "~#pgv_lang[filter]#~<br /><br />U kunt beperkingen aanbrengen in de formaten en types media objecten, wat mag worden getoond in het Willekeurige Media blok.  Als een bepaalde checkbox is aangevinkt, is het Willekeurige Media blok toegestaan om media objecten van dat formaat of type te tonen.<br /><br />Formaten of Types code dat in uw database aanwezig zijn, maar niet in deze checkbox lijsten staan, worden verondersteld te mogen worden getoond. Bijvoorbeeld: als uw database Media objecten van het formaat <b><i>pdf</i></b> bevat, is het het Willekeurige Media blok altijd toegestaan deze te tonen.  Op dezelfde wijze is het Willekeurige Media blok altijd toegestaan om Media objecten van het type <b><i>special</i></b> te tonen, als deze bestaan in uw database.";
$pgv_lang["basic_or_all_help"]				= "~#pgv_lang[basic_or_all]#~<br /><br />Deze optie laat u enkele gedateerde gebeurtenissen verbergen.  Bijvoorbeeld: #factarray[DIV]#, #factarray[CREM]#, #factarray[GRAD]#, #factarray[BARM]#, #factarray[FCOM]#, enz. zouden alle gedateerd moeten zijn.<br /><br />Als u <b>Ja</b> selecteerd, worden alleen Geboorten, Sterfgevallen en Huwelijken getoond. Kiest u voor <b>Nee</b>, dan worden alle gedateerde gebeurtenissen getoond.";
$pgv_lang["style_help"]						= "~#pgv_lang[style]#~<br /><br />Met deze optie kunt u instellen hoe de informatie wordt getoond.<br /><br />Als u <b>#pgv_lang[style1]#</b> selecteert, wordt de informatie getoond in tekst formaat, min of meer identiek aan wat u ziet in de diverse Diagram vakken.  Dit formaat lijkt goed in de blokken die aan de rechter zijde van de pagina worden getoond.<br /><br />Als u <b>#pgv_lang[style2]#</b> selecteert, wordt de informatie getoond in tabelvorm. Deze tabelvorm is meer geschikt om te tonen in grotere blokken, zoals deze worden getoond op de linker zijde van de pagina.";
$pgv_lang["sort_style_help"]				= "~#pgv_lang[sort_style]#~<br /><br />Deze optie gebruikt u om aan te geven hoe de informatie moet worden gesorteerd.<br /><br />Als u <b>#pgv_lang[by_alpha]#</b> selecteert, wordt de informatie in alphabetische volgorde getoond. Als <b>#pgv_lang[by_anniv]#</b> is geslecteerd, wordt de informatie gesorteerd op datum, met de meest recente verjaardagen eerst.";
$pgv_lang["cal_dowload_help"]				= "~#pgv_lang[cal_download]#~<br /><br />Met deze optie stelt u in of de knop om de Kalender Gebeurtenissen te downloaden wordt getoond aan ingelogde gebruikers. Het gedownloade kalender bestand kan worden geïmporteerd in compatible programma's zoals Microsoft Outlook. Vervolgens kunt u, bijvoorbeeld,  automatische e-mail- of verjaardags herinneringen laten genereren.<br /><br />Indien ingesteld op <b>#pgv_lang[no]#</b>, kunnen de ingelogde gebruikers het kalender-bestand niet downloaden.  Indien ingesteld op <b>#pgv_lang[yes]#</b>, wordt de Download knop getoond.  Deze knop wordt nooit getoond aan niet-ingelogde gebruikers.</b></b>";
$pgv_lang["cal_download_user_help"]			= "Als u bent ingelogd, kunt u mogelijk aan de onderzijde van de lijst een ikoon <img src='images/ical.png' alt='' /> zien. Als u op hierop klikt, kunt u de lijst downloaden als kalender bestand. Het gedownloade kalender bestand kan worden geïmporteerd in compatible programma's zoals Microsoft Outlook. Vervolgens kunt u, bijvoorbeeld, automatische e-mail- of verjaardags herinneringen laten genereren.<br /><br />Als u dit ikoon niet ziet, kan de beheerder de download-optie hebben uitgeschakeld. Bezoekers, die niet zijn ingelogd, kunnen dit ikoon niet zien en het kalender bestand niet downloaden.";
$pgv_lang["index_charts_help"]				= "~#pgv_lang[charts_block]#~<br /><br />In dit blok kan een kwartierstaat, nakomelingen diagram of zandloper diagram worden getoond op de Welkom pagina of op de MyGedView pagina.  Door ruimtebeperkingen is het beter dit blok alleen aan de linker zijde van de pagina te plaatsen.<br /><br />Als dit blok op de Welkom pagina staat, wordt de startpersoon bepaald door de beheerder.  Indien dit blok door een gebruiker op diens MyGedView pagina is geplaatst, worden de instellingen bepaalt door die gebruiker.<br /><br />Het gedrag van deze diagrammen is identiek aan het gedrag ervan als ze via de menu's worden gestart.  Klik op het vak van een persoon, om meer details van die persoon te zien.";
$pgv_lang["index_onthisday_help"]			= "~#pgv_lang[todays_events_block]#~<br /><br />Dit vak toont een lijst met gebeurtenissen, die op deze dag in het verleden hebben plaatsgevonden. De gebeurtenissen hebben betrekking op personen uit de actieve genealogie.<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["index_favorites_help"]		= "~#pgv_lang[gedcom_favorites_block]#~<br /><br />Dit blok is vrijwel hetzelfde als het #pgv_lang[user_favorites_block]# blok van de #pgv_lang[mygedview]# pagina. In tegenstelling tot de configuratie van de portalpagina, kan alleen de beheerder of een gebruiker met beheerdersrechten de lijst met favorieten in dit blok wijzigen.<br /><br />Het doel van dit blok is om de bezoeker te attenderen op personen van bijzonder belang. De favorieten van deze GEDCOM zijn beschikbaar voor selectie uit een lijst in de koptekst op elke pagina.<br /><br />Wanneer u op een van de vermelde sitefavorieten klikt, wordt u naar de pagina #pgv_lang[indi_info]# van die persoon geleid.";
$pgv_lang["index_add_favorites_help"]		= "~#pgv_lang[add_favorite]#~<br /><br />Met dit formulier kunt u  een nieuw fovoriet item aan uw favorietenlijst toevoegen.<br /><br />U moet een ID van de persoon, het gezin of de bron inullen, die of dat u wilt oplsaan als een favoriet. Ook kunt u een URL en een tietel toevoegen.  Het Notitie veld is optioneel en kan worden gebruikt om uw favoriet te omschrijven.  Alles wat in het Notititie veld is ingevuld zal in het Favorieten blok, na het item, worden getoond.";
$pgv_lang["index_stats_help"]				= "~#pgv_lang[gedcom_stats_block]#~<br /><br />Het vak toont enkele gegevens over het dit bestand, zoals het aantal erin aanwezige personen en de datum waarop het is aangemaakt. Voor meer informatie kunt u contact opnemen met de contactpersoon van deze genealogie (zie onder aan deze pagina).";
$pgv_lang["index_common_names_help"]	= "~#pgv_lang[block_top10]#~<br /><br />In dit blok worden de meest voorkomende achternamen vermeld, met een telling voor elk. Als je op een naam klikt, kom je in de Personenlijst, al gefilterd op de naam waarop je hebt geklikt.<br /><br />De administrator bepaalt hoeveel namen er daadwerkelijk getoond worden.";
$pgv_lang["index_common_given_names_help"]	= "~#pgv_lang[block_givn_top10]#~<br /><br />In dit blok worden de meest voorkomende voornamen weergegeven. Het toont mannelijke en vrouwelijke namen in kolommen. Een derde kolom zal verschijnen als er personen zijn waarvan het geslacht niet bekend is.<br /><br />De administrator bepaalt hoeveel namen er daadwerkelijk getoond worden.";
$pgv_lang["index_media_help"]			= "~#pgv_lang[random_media_block]#~<br /><br />In dit blok kiest PhpGedView willekeurig een mediabestand om u bij elk bezoek aan deze pagina te tonen.<br /><br />Als u op de afbeelding klikt, ziet u de volledige versie ervan. Onder de foto heb je een link naar de persoon die bij de foto hoort.Als je op het fotobijschrift klikt, zie je de foto op de #pgv_lang[media_list]# pagina. Wanneer u op de naam van de persoon klikt, wordt u naar de #pgv_lang[indi_info]# pagina van die persoon geleid.";
$pgv_lang["index_loggedin_help"]		= "~#pgv_lang[logged_in_users_block]#~<br /><br />Dit blok toont u de gebruikers die momenteel zijn aangemeld.<br /><br />Als u geen beheerder bent, is uw weergave van ingelogde gebruikers beperkt tot degenen die ervoor hebben gekozen om zichtbaar te zijn terwijl u online bent. Om dit te laten werken, moet u er ook voor kiezen om zichtbaar te zijn terwijl u online bent. Online gebruikers die voor u onzichtbaar zijn, worden als anoniem geteld.";
$pgv_lang["index_gedcom_news_help"]			= "~#pgv_lang[gedcom_news_block]#~<br /><br />Dit vak is het prikbord van deze genealogie. De beheerder kan daarop belangrijke mededelingen, weetjes en koppelingen naar andere websites plaatsen.<br /><br />Als u zelf een bericht wilt plaatsen, kunt u hiervoor contact opnemen met de beheerder.";
$pgv_lang["recent_changes_help"]			= "~#pgv_lang[recent_changes_block]#~<br /><br />In dit vak worden de recente wijzigingen in deze genealogie getoond. Hiervoor wordt de datum van laatste wijziging in de persoons- en gezinsinformatie gebruikt.";
$pgv_lang["gedcom_news_limit_help"]			= "U kunt het aantal artikelen van het Prikbord-blok beperken. Daarmee reduceert u tevens de lengte van het blok..<br /><br />Deze optie bepaalt of er geen limiet wordt toegepast, of een limiet op basis van leeftijd, of een limiet op basis van het aantal artikelen.";
$pgv_lang["gedcom_news_flag_help"]			= "Voer hier de limiet-waarde in.<br /><br />Als u heeft gekozen voor de optie om de lengte v.h. Prikbordblok te beperken door het aantal artikelelen te beperken, dan is de waarde, die u invult, het aantal artikelen dat getoond zal worden, gesorteerd op leeftijd. De overige artikelen worden verborgen.<br /><br />Indien u een 0 (nul) invoert, is er geen limeit. Alle artikelen zullen worden getoond.";
$pgv_lang["gedcom_news_archive_help"]		= "Om de lenget van het Prikbord blok te beperken, heeft de beheerde enkele artikelen verborgen. Om deze verborgen artikelen zichtbaar te maken, klikt u op de <b>#pgv_lang[gedcom_news_archive]#</b> link.";
$pgv_lang["index_htmlplus_help"]			= "~#pgv_lang[htmlplus_block_name]#~<br /><br />In dit blok kan de beheerder informatie toevoegen aan de Welkomst- of Portal- pagina. Het doel van dit blok is vergelijkbaar met #pgv_lang[html_block_name]#, #pgv_lang[gedcom_news_block]# en #pgv_lang[gedcom_stats_block]# blok, maar de beheerder heeft meer controle en invloed op de manier van presentatie.";
$pgv_lang["index_htmlplus_title_help"]		= "~#factarray[TITL]#~<br /><br />De tekst in dit titelvak wordt ofwel weggelaten of moet kort zijn. Als het titelvak leeg blijft, wordt het Geavanceerd HTML blok, op de Welkomst- of Portal- pagina, weergegeven als een eenvoudig blok, zoals het gewone HTML blok. Als het titelvak wel is ingevuld, wordt het Geavanceerd HTML blok weergegeven zaols alle blokken, compleet met een blok titel balk, met daarin de tekst die u in het titelvak heeft ingevuld.";
$pgv_lang["index_htmlplus_template_help"]	= "~#pgv_lang[htmlplus_block_templates]#~<br /><br />Ter assistentie, als u pas begint te werken met dit blok, hebben we een aantal standard templates gemaakt. Als u een van deze templates selecteert, zal een kopie in het tekstvak worden gezet, dat u dan naar wens kunt aanpassen.";
$pgv_lang["index_htmlplus_content_help"]	= "~#pgv_lang[htmlplus_block_content]#~<br /><br />In tegenstelling tot #pgv_lang[html_block_name]#, #pgv_lang[gedcom_news_block]#, en #pgv_lang[gedcom_stats_block]# blok, heeft u volledige controle over het aanzien van uw blok.  U kunt HTML tags gebruiken. Het blok gebruikt de CSS style sheets van het huidige actieve thema.  Referenties naar informatie in de huidig actieve genealogische database kan eveneens worden ingesloten in de tekst.<br /><br />Database referenties worden in de tekst opgenomen d.m.v. sleutelwoorden, welke zijn ingesloten door <b>&#35;</b> symbolen.  Bijvoorbeeld: <b>&#35;totalFamilies&#35;</b> zal het aantal gezinnen in de database weergeven.  Het zou voor kunnen komen dat u wilt verwijzen naars een database referentie, i.p.v. de inhoud van die referentie te tonen.  Om dat te doen moet u de symbolen <b>&#35;</b>, die het sleutelwoord insluiten, vervangen door hun symbolisch equivalent. Als uw tekst, bijvoorbeeld, <b>&amp;&#35;35;totalFamilies&amp;&#35;35;</b> bevat, zal het worden getoond als <b>&#35;totalFamilies&#35;</b> i.p.v. het tonen van de inhoud van die variabele.<br /><br />Voor een compleet voorbeeld van het genruik van dit blok, kunt u eens kijken naar de &quot;#pgv_lang[gedcom_stats_block]#&quot; template, welke u kunt vinden in de blocks/ map. Het gebruikt vele van de tags-styles, incl. taal- en help-links.<br /><br />De <b>#pgv_lang[htmlplus_block_keyword]#</b> template bevat een volledige lijst met alle ondersteunde sleutelwoorden.";
$pgv_lang["index_htmlplus_compat_help"]		= "~#pgv_lang[htmlplus_block_compat]#~<br /><br />Door dit aan te vinken zal deze versie van dit blok compatible met oudere versies. Als het is aangevinkt, zullen oude en nieuwe sleutelwoorden worden herkend en juist worden geïnterpreteerd.<br /><br />Bijvoorbeeld, de tekst <b>&#35;TOTAL_FAM&#35;</b> zal worden herkend als equivalent van <b>&#35;totalFamilies&#35;</b>, <b>&#35;FIRST_DEATH_PLACE&#35;</b> is gelijk aan <b>&#35;firstDeathPlace&#35;</b>, <b>&#35;TOP10_BIGFAM&#35;</b> is gelijk aan <b>&#35;topTenLargestFamily&#35;</b>, enz.<br /><br />Tenzij het absoluut noodzakelijk is, moet u de Compatibility mode niet gebruiken.";
$pgv_lang["index_htmlplus_gedcom_help"]		= "~#pgv_lang[htmlplus_block_gedcom]#~<br /><br />Selecteer de database, waar de sleutelwoorden naar verwijzen.<br /><br />Uw  site ondersteunt meerdere databases.  Sleutelwoorden zoals: <b>&#35;totalFamilies&#35;</b> kunnen slechts naar één database verwijzen.  U kunt de database aanwijzen dei moet worden gekozen voor het gebruik van zulke sleutelwoorden.  Elk #pgv_lang[htmlplus_block_name]# blok heeft slechts toegang tot één database.";
$pgv_lang["showUnknown_help"]				= "~#pgv_lang[showUnknown]#~<br /><br />Verberg of toon de lijst met namen van personen, waarvan het geslacht niet bekend is.<br /><br />Het #pgv_lang[block_givn_top10]# blok verbergt altijd de lijst met voornamen van personen, waarvan het geslacht niet bekend is, als er in uw database deze personen niet aanwezig zijn. Met deze optie kunt u eveneens deze lijst verbergen, als er wel zulke personen in uw database aanwezig zijn.";

//-- Index-Page Help
$pgv_lang["help_help"]					= "Het zou natuurlijk ideaal zijn om een programma te maken dat zo eenvoudig en gemakkelijk te gebruiken is dat het helemaal geen uitleg nodig heeft; het zou zo simpel moeten zijn als het lezen van een boek.<br /><br />Hoewel PhpGedView erg gecompliceerd is, zou u dat niet moeten opmerken als u het gebruikt; bijna alles kan zonder uitleg worden gebruikt. Maar aangezien we mogelijk veel bezoekers en gebruikers hebben die niet erg ervaren zijn met het gebruik van een computer of met internet, bieden we je op bepaalde plaatsen wat hulp.<br /><br />U vindt de volgende items in het Help-menu:";
$pgv_lang["help_page_help"]				= "<ul><li><b>Help per pagina</b><br />Voor alle pagina's is er een algemene \"Paginahulp\" beschikbaar. U kunt op dit item in het menu klikken om \"Paginahulp\" te krijgen, waar u wordt geïnformeerd over de items op diezelfde pagina.<br /><br />De paginahulp is vaak kort. Als u meer hulp of informatie nodig heeft over een bepaald item op de pagina dan de Page Help biedt, kunt u de functie \"Contextuele Help\" gebruiken.</li></ul>";
$pgv_lang["help_content_help"]			= "<ul><li><b>Inhoudsopgave</b><br />Als u op dit menu-item klikt, krijgt u een Help-pagina met een index van de belangrijkste Help-onderwerpen. De hoeveelheid beschikbare Help-informatie zal toenemen naarmate de tijd het toelaat.</li></ul>";
$pgv_lang["help_faq_help"]					= "<ul><li><b>VGV Lijst</b><br />#pgv_lang[text_faq_help]#</li></ul>";
$pgv_lang["help_HS_help"]					= "<ul><li><b>#pgv_lang[hs_title]#</b><br />#pgv_lang[hs_intro]#</li></ul>";
$pgv_lang["help_qm_help"]					= "<ul><li><b>Toon/verberg contextuele help</b><br />Deze optie zorgt ervoor, dat aan de rechterkant van de meeste koppelingen, keuzemenu's, vakken en invoervelden, een vraagteken zichtbaar wordt. Als u op het \"?\" klikt, krijgt u een extra venster met specifieke informatie over die optie of functie.<br /><br />U kunt deze optie in- en uitschakelen door op deze menuoptie te klikken.</li></ul>";

//-- Index-page Definitions
$pgv_lang["def_help"]						= "<div class='name_head center'><b>#pgv_lang[definitions]#</b></div><br />Hier volgt een beschrijving van enkele begrippen, die op deze website worden gebruikt:<ul><li><a href=\"#def_gedcom\"><b>GEDCOM-bestand</b></a><br /></li><li><a href=\"#def_gedcom_date\"><b>Datumgebruik</b></a></li><li><a href=\"#def_pdf_format\"><b>PDF-bestandsformaat</b></a></li><li><a href=\"#def_pgv\"><b>PhpGedView</b></a></li><li><a href=\"#def_portal\"><b>Portaal</b></a></li><li><a href=\"#def_theme\"><b>Thema's</b></a></li></ul>";
$pgv_lang["def_portal_help"]				= "~PORTAAL~<br /><br />Het portaal van deze site is als de lobby van een restaurant of een openbare bibliotheek. Het is de plek waar je binnenkomt, maar je kunt er ook belangrijke informatie vinden zoals uitleg, menu's etc.";
$pgv_lang["def_gedcom_help"]				= "~GEDCOM-BESTAND~<br /><br />Een GEDCOM-bestand is een bestand, dat genealogische informatie bevat. Deze informatie wordt in het bestand opgeslagen volgens het GEDCOM-formaat. Dit is een algemeen aanvaarde standaard voor het uitwisselen van genealogische informatie en stelt de gebruikers in staat om informatie tussen genealogiepakketten uit te wisselen.<br /><br />Een citaat uit de inleiding van de GEDCOM 5.5 standaard:<div class=\"list_value_wrap\">#pgv_lang[quote_gedcom]#</div><br />Nederlandse versie:<div class=\"list_value_wrap\">De GEDCOM-standaard is ontwikkeld door de kerk van Jezus Christus, Heilige der laatste dagen, om een flexibel en uniform formaat vast te stellen om elektronisch vastgelegde genealogische gegevens uit te wisselen.&nbsp; GEDCOM is een acroniem voor <i><b>GE</b></i>nealogical <i><b>D</b></i>atabase <i><b>C</b></i>ommunication.&nbsp; Het doel is om het delen van genealogische informatie te ondersteunen en daarmee de ontwikkeling van een groot aantal softwareproducten voor genealogen, historici en andere onderzoekers.</div><br />Een exemplaar van de GEDCOM 5.5.1 standaard, waarop PhpGedView is gebaseerd, kunt u in PDF-formaat downloaden van:&nbsp; <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=_blank>GEDCOM 5.5.1 Standard</a><br /><br />Een GEDCOM-bestand bevat alle informatie over personen en gezinnen, zoals feiten, data, gebeurtenissen, etc. Aan de vastlegging van de informatie worden regels gesteld, waardoor de uitwisselbaarheid van de informatie tussen systemen wordt bevorderd.";
$pgv_lang["def_gedcom_date_help"]		= "~DATUMS IN EEN GEDCOM-BESTAND~<br /><br />Hoewel het datumveld vrije invoer toestaat (wat betekent dat u kunt typen wat u maar wilt), zijn er enkele regels over hoe datums moeten worden ingevoerd volgens de GEDCOM 5.5.1-standaard.<ul><li>Een volledige datum wordt ingevoerd in de vorm DD&nbsp;MMM&nbsp;JJJJ. Bijvoorbeeld <b>01&nbsp;MAR&nbsp;1801</b> of <b>14&nbsp;DEC&nbsp;1950</b>.</li><li>Als u een deel van de datum mist, kunt u dat deel weglaten. Bijv. <b>MAR&nbsp;1801</b> of <b>14&nbsp;DEC</b>.</li><li>Als u het niet zeker weet of de datum niet is bevestigd, kon je de volgende in te voeren: <b>ABT&nbsp;MAR&nbsp;1801</b> (abt = ongeveer), <b>BEF&nbsp;20&nbsp;DEC&nbsp;1950</b> (bef = voor), <b>AFT&nbsp;1949</b> (aft = na)</li><li>Datumbereiken worden ingevoerd als <b>FROM&nbsp;MAR&nbsp;1801&nbsp;TO&nbsp;20&nbsp;DEC&nbsp;1810</b> of als <b>BET&nbsp;MAR&nbsp;1801&nbsp;AND&nbsp;20&nbsp;DEC&nbsp;1810</b> (bet = tussen)<br /><br /><b>FROM</b> geeft aan dat de gebeurtenis die wordt beschreven, continu plaatsvond tussen de vermelde datums en wordt gebruikt met gebeurtenissen zoals een dienstverband. <b>BET</b> geeft een enkele voorkomen van de gebeurtenis aan, ergens tussen de vermelde datums en wordt gebruikt bij gebeurtenissen zoals geboorte.<br /><br />Onnauwkeurige datums, waarbij de dag van de maand of de maand ontbreekt, worden altijd geïnterpreteerd als de eerste of de laatst mogelijke datum, afhankelijk van het feit of die onnauwkeurige datum voor of na het scheidingsteken valt. <b>FEB&nbsp;1804</b> wordt bijvoorbeeld geïnterpreteerd als <b>01&nbsp;FEB&nbsp;1804</b> wanneer het voorkomt vóór de TO of AND, en als <b>29&nbsp;FEB&nbsp;1804</b> wanneer het zich voordoet na de TO of AND.</li></ul><br /><b>Zorg ervoor dat u datums en afkortingen in <u>Engels</u> invoert,</b> want dan is het GEDCOM-bestand uitwisselbaar en kan PhpGedView alle datums en afkortingen correct vertalen naar de momenteel actieve taal. Bovendien voert PhpGedView berekeningen uit met behulp van deze datums. Als er onjuiste datums worden ingevoerd in datumvelden, kan PhpGedView niet correct berekenen. U kunt op het kalenderpictogram klikken voor hulp bij het selecteren van een datum.<br /><br />De volgende afkortingen worden gebruikt:<ul><li>JAN = January = januari</li><li>FEB = February = februari</li><li>MAR = March = maart</li><li>APR = April</li><li>MAY = mei</li><li>JUN = June = juni</li><li>JUL = July = juli</li><li>AUG = August = augustus</li><li>SEP = September</li><li>OCT = October = oktober</li><li>NOV = November</li><li>DEC = December</li><li>bef = before = voor</li><li>abt = about = ongeveer</li><li>aft = after = na</li></ul>";
$pgv_lang["def_gramps_help"]				= "~GRAMPS XML Database file~<br /><br />Een citaat van het  GRAMPS Project:<div class=\"list_value_wrap\">#pgv_lang[quote_gramps]#</div><br />Nederlandse versie:<div class=\"list_value_wrap\">GRAMPS helpt u om uw familie stamboom te volgen. Het laat u genealogische gegevens opslaan, wijzigen en onderzoeken. GRAMPS poogt om alle gemeenschappelijke mogelijkheden van andere genealogische programma's aan te bieden.<br />Maar, nog belangrijker,  om een aanvullende mogelijkheid van integratie te bieden, die niet gemeenschappelijk in deze andere programma's aanwezig zijn.<br />Dat is de mogelijkheid om ieder soort gegevens, stukje bij beetje,  direct in GRAMPS in te voeren. Vervolgens is het dan mogelijk om elke/alle data gebeurtenis(sen) in de gehele database te herordenen/mannipuleren (in elke gewenste volgorde). Dit om de gebruiker te assisteren met onderzoek, analyse en correlatie, met de mogelijkheid om eventuele gaten in de verwantschappen te vullen.</div><br />Een kopie van het GRAMPS XML formaat v1.1.0 <a href=\"http://www.gramps-project.org/xml/1.1.0/\" target=\"_blank\"><i>kan hier worden gevonden</i></a> in zowel RELAX NG Schema formaat en DTD formaat.<br /><br />Voor meer informatie over het GRAMPS Project bezoek <a href=\"http://gramps-project.org/\" target=\"_blank\">http://gramps-project.org/</a>";
$pgv_lang["def_pgv_help"]				= "~PhpGedView~<br /><br />PhpGedView (of PGV) plaatst niet alleen statische pagina's op het web; het is dynamisch en kan op vele manieren worden aangepast.<br /><br />PhpGedView is gemaakt door John Finlay om GEDCOM-bestanden online te bekijken. John begon het programma zelf te ontwikkelen. Een internationaal team van ontwikkelaars en vertalers heeft zich inmiddels bij hem gevoegd en werkt aan het verbeteren van het programma. Onder de meer belangrijke functies die aan het programma zijn toegevoegd of verbeterd, zijn de uitgebreide ondersteuning van andere talen dan Engels en de mogelijkheid om online evenementen toe te voegen en te bewerken.";
$pgv_lang["def_theme_help"]				= "~THEMA'S~<br /><br />Deze site kan verschillende \"verschijningen\" hebben, genaamd Thema's. De sitebeheerder kiest een standaardthema, dat iedereen die deze site bezoekt in eerste instantie zal zien.<br /><br />Als de beheerder deze functie heeft ingeschakeld, kunnen alle gebruikers hun eigen thema's selecteren. PhpGedView onthoudt het laatst geselecteerde thema voor elke aangemelde gebruiker, zodat die gebruiker automatisch dat thema ziet de volgende keer dat hij inlogt.<br /><br />Thema's kunnen worden gebruikt om onderscheid te maken tussen verschillende databases op dezelfde site. Elke database kan een ander standaardthema hebben.";

//-- Index-page MyGEDCOM
$pgv_lang["mygedview_portal_help"]			= "~#pgv_lang[mygedview]#~<br /><br />Dit is uw persoonlijke #pgv_lang[mgv]# pagina.<br /><br />Hier vindt u eenvoudige links om toegang te krijgen tot uw persoonlijke gegevens, zoals <b>Mijn account</b>, <b>Mijn Indi</b> (dit is uw pagina #pgv_lang[indi_info]#) en <b>Mijn Stamboom</b>. U kunt blokken hebben met <b>Berichten</b>, een <b>Dagboek</b> (zoals een Kladblok) en nog veel meer.<br /><br />De lay-out van deze pagina is vergelijkbaar met de welkomstpagina die u ziet wanneer u deze site voor het eerst bezoekt. Terwijl de onderdelen van de welkomstpagina worden geselecteerd door de sitebeheerder, kunt u selecteren welke onderdelen u op deze gepersonaliseerde pagina wilt opnemen. U vindt de link om deze pagina aan te passen in het welkomstblok of afzonderlijk wanneer het welkomstblok niet aanwezig is.<br /><br />U kunt kiezen uit de volgende blokken en links:<ul><li><a href=\"#mygedview_welcome\"><b>#pgv_lang[welcome_block]#</b></a></li><li><a href=\"#mygedview_customize\"><b>«#pgv_lang[mygedview]#» indelen</b></a></li><li><a href=\"#mygedview_message\"><b>#pgv_lang[user_messages_block]#</b></a></li><li><a href=\"#mygedview_events\"><b>#pgv_lang[upcoming_events_block]#</b></a></li><li><a href=\"#mygedview_onthisday\"><b>#pgv_lang[todays_events_block]#</b></a></li><li><a href=\"#mygedview_charts\"><b>#pgv_lang[charts_block]#</b></a></li><li><a href=\"#mygedview_favorites\"><b>#pgv_lang[user_favorites_block]#</b></a></li><li><a href=\"#mygedview_stats\"><b>#pgv_lang[gedcom_stats_block]#</b></a></li><li><a href=\"#mygedview_myjournal\"><b>#pgv_lang[user_news_block]#</b></a></li><li><a href=\"#mygedview_media\"><b>#pgv_lang[random_media_block]#</b></a></li><li><a href=\"#mygedview_loggedin\"><b>#pgv_lang[logged_in_users_block]#</b></a></li><li><a href=\"#recent_changes\"><b>#pgv_lang[recent_changes_block]#</b></a></li></ul>";
$pgv_lang["mygedview_customize_help"]		= "~#pgv_lang[mygedview]# INDELEN~<br /><br />Toen je hier voor de eerste keer binnenkwam, had je al een aantal blokken op deze pagina. Als u wilt, kunt u deze portaalpagina aanpassen.<br /><br />Als u op deze link klikt, wordt u naar een formulier geleid waar u blokken kunt toevoegen, verplaatsen of verwijderen. Op dat formulier staat meer uitleg.";
$pgv_lang["mygedview_message_help"]			= "~#pgv_lang[user_messages_block]#~<br /><br />In dit blok vind je de berichten die naar jou zijn gestuurd door andere gebruikers of de admin. Ook u kunt berichten sturen naar andere gebruikers of naar de admin.<br /><br />Het PhpGedView-mailsysteem is ontworpen om uw privacy te beschermen. U hoeft uw e-mailadres hier niet achter te laten en anderen kunnen uw e-mailadres niet zien.<br /><br />Om een bericht uit te vouwen, klikt u op het berichtonderwerp of het symbool \"<b>+</b>\" ernaast. U kunt meerdere berichten verwijderen door de vakjes aan te vinken naast de berichten die u wilt verwijderen en op de knop <b> Geselecteerde berichten verwijderen </b> te klikken.";
$pgv_lang["mygedview_favorites_help"]		= "~#pgv_lang[user_favorites_block]#~<br /><br />Favorieten zijn vergelijkbaar met bladwijzers.<br /><br />Stel dat u iemand in de stamboom heeft wiens record u regelmatig wilt controleren. Ga gewoon naar de pagina #pgv_lang[indi_info]# van de persoon en selecteer de optie <b>Toevoegen aan Mijn favorieten</b> in de lijst met favorieten. Deze persoon is nu gemarkeerd als boek en toegevoegd aan uw lijst met favorieten.<br /><br />Waar u zich ook bevindt op deze site, u kunt op een naam klikken in de lijst \"Mijn favorieten\" in de koptekst. Dit brengt je naar de #pgv_lang[indi_info]# pagina van die persoon.";
$pgv_lang["mygedview_myjournal_help"]		= "~#pgv_lang[user_news_block]#~<br /><br />Voor uw eigen gebruik kunt u notities maken op uw notitieblok. Als u een volgende keer de site bezoekt, kunt u de notities weer bekijken, aanpassen of verwijderen.<br /><br />De notities zijn alleen voor u zelf zichtbaar.";
$pgv_lang["mygedview_welcome_help"]			= "~#pgv_lang[welcome_block]#~<br /><br />In dit vak treft u het volgende aan:<ul><li>Het huidige GEDCOM-bestand</li><li>De datum en tijd</li><li>Links naar:<ul><li>#pgv_lang[myuserdata]#</li><li>#pgv_lang[my_pedigree]#</li><li>#pgv_lang[my_indi]#</li><li>#pgv_lang[customize_page]#</li></ul></li></ul><br /><b>Opmerking:</b><br />U ziet de links naar <b>#pgv_lang[my_indi]#</b> en <b>#pgv_lang[my_pedigree]#</b> alleen als u bekend bent met het huidige GEDCOM-bestand. Mogelijk hebt u een record in één GEDCOM-bestand en ziet deze links, terwijl u in een ander GEDCOM-bestand geen record hebt en bijgevolg zijn deze links niet getoond.";

//-- Pedigree-page
$pgv_lang["help_pedigree.php"]			= "~DE KWARTIERSTAAT~<br /><br />Een stamboom is een opsomming van alle voorouders van de startende persoon. Gebruikers die niet ingelogd zijn, zien de stamboom van de startende (root) persoon gekozen door de sitebeheerder. Ingelogde gebruikers kunnen hun eigen startpersoon (wortel) selecteren.<br /><br />In deze context betekent \"Alle voorouders\" de vader en moeder, hun ouders, enzovoort. De stamboom wordt grafisch weergegeven; u hoeft niet door pagina's tekst te worstelen om uw voorouders te bepalen.<br /><br />Alle personen worden weergegeven in de naamvakken op het scherm.<br /><ul><li><b>Naamvakken op de stamboom</b><br />Als de stamboompagina is ingesteld om details weer te geven, ziet u de naam van de persoon en de geboorte- en overlijdensdatum. U kunt op de naam van een persoon klikken om u rechtstreeks naar de pagina #pgv_lang[indi_info]# van die persoon te brengen.<br /><br />Als <b>Details weergeven</b> is ingeschakeld, staan er twee pictogrammen in het naamvak.</li><li><b>Stamboompictogram in het vak Naam</b><br />Als de optie <b>Details tonen</b> is ingeschakeld, ziet u een stamboompictogram in het vak Naam. Afhankelijk van de site-instellingen moet u de muisaanwijzer over het pictogram bewegen of erop klikken. Wanneer u op dit pictogram klikt of erover beweegt, verschijnt een klein submenu.<br /><br />De items <b>#pgv_lang[index_header]#</b> en <b>#pgv_lang[descend_chart]#</b> lijken op die items in het hoofdmenu, maar het verschil is dat de startende persoon nu de persoon van vermeld in het vak Naam. Je ziet ook <b>#pgv_lang[as_spouse]#</b>.Daaronder zie je de naam van de echtgenoot gevolgd door de namen van de kinderen. Alle namen zijn aanklikbaar.</li><li><b>Vergrootglas in het vak Naam</b><br />Afhankelijk van de site-instellingen moet u de muisaanwijzer over het pictogram bewegen of erop klikken. Dit vergroot het naamvak zodat meer details worden weergegeven. Je zult meer data en evenementen zien. Namen zijn klikbaar.</li><li><b>Pijlen</b><br />Links of rechts van de meest linkse of meest rechtse naamvakken ziet u mogelijk pijlen. Als u op deze pijlen klikt, verschuift de schermweergave in de richting van de pijl.</li></ul><br />#pgv_lang[context_help]#";
$pgv_lang["show_full_help"]				= "~#pgv_lang[show_details]#~<br /><br />Met deze optie kunt u alle details in de naamvakken tonen of verbergen. U kunt meer vakken op één scherm weergeven als de details verborgen zijn.<br /><br />Als alle details verborgen zijn, wordt het hieronder beschreven zoompictogram niet weergegeven. Als de beheerder echter de zoomfunctie heeft ingeschakeld, werkt het hele vak als een zoompictogram om alle details over de persoon te onthullen.<br /><br />Als de details niet verborgen zijn en de zoomfunctie, geïdentificeerd door een vergrootglaspictogram, is ingeschakeld door de beheerder, kunt u nog meer details over die persoon onthullen. Als u normaal gesproken op het zoompictogram moet klikken om in te zoomen, kunt u aanvullende verborgen details onthullen door hier op dat pictogram te klikken. Evenzo, als u kunt inzoomen door over het zoompictogram te bewegen, worden verborgen details onthuld door over dat pictogram hier te bewegen.<br /><br />Als u op het zoompictogram hebt geklikt om meer details weer te geven, kunt u herstellen het vak terug naar het normale detailniveau door nogmaals op het zoompictogram te klikken. Als u meer details hebt onthuld door simpelweg de muisaanwijzer over het zoompictogram te bewegen, wordt het vak hersteld naar het normale detailniveau wanneer u de muisaanwijzer weg beweegt van het zoompictogram.";
$pgv_lang["talloffset_help"]			= "~#pgv_lang[portrait]# / #pgv_lang[landscape]#~<br /><br />Met deze optie bepaalt u de oriëntatie van het scherm.<br /><br />Het wijzigen van deze instelling kan handig zijn als u een zeefdruk wilt maken of als u een ander type scherm heeft.<ul><li><b>#pgv_lang[portrait]#</b>&nbsp;&nbsp;&nbsp;zal de boom groter maken, zodat een 4-generatiekaart moet passen op een enkele pagina die verticaal wordt afgedrukt.</li><li><b>#pgv_lang[landscape]#</b>&nbsp;&nbsp;&nbsp;zal een bredere boom maken die moet worden afgedrukt op een enkele pagina die horizontaal wordt afgedrukt.</li><li><b>#pgv_lang[landscape_top]#</b>&nbsp;&nbsp;&nbsp;roteert de kaart, maar niet de vakken, 90 graden tegen de klok in, zodat de oudste generatie bovenaan de kaart staat.</li><li><b>#pgv_lang[landscape_down]#</b>&nbsp;&nbsp;&nbsp;roteert de kaart, maar niet de vakken, 90 graden met de klok mee, zodat de oudste generatie onder aan de kaart staat.</li></ul>";
$pgv_lang["rootid_help"]				= "~#pgv_lang[rootid]#~<br /><br />Als u een diagram met een nieuwe startende (wortel) persoon wilt weergeven, wordt de ID van die nieuwe startende persoon hier getypt. <br /><br />Als u de ID van die persoon niet weet, gebruikt u de <b>Zoek ID</b> link.<br /><br /><b>ID NUMMER</b><br />De ID-nummers die binnen PhpGedView worden gebruikt, zijn <u>niet</u> de identificatienummers die zijn uitgegeven door verschillende overheden (bijvoorbeeld rijbewijs- of paspoortnummers). Het ID-nummer waarnaar hier wordt verwezen, is gewoon een nummer dat in de database wordt gebruikt om elk individu uniek te identificeren; het werd toegewezen door het voorouderprogramma dat het GEDCOM-bestand creëerde dat in PhpGedView werd geïmporteerd.";
$pgv_lang["PEDIGREE_GENERATIONS_help"]		= "~#pgv_lang[generations]#~<br /><br />Hier kunt u instellen hoeveel generaties op het scherm worden getoond.<br /><br />Wat juist is voor u is afhankelijk van de afmetingen van uw scherm en of u de details van de naamvakken wel of niet laat zien.";

//-- LOGIN-page
$pgv_lang["login_page_help"]				= "~#pgv_lang[login]#~<br /><br />Op deze pagina kunt u zich aanmelden als bestaande gebruiker, een nieuwe gebruikersnaam aanvragen of, als u uw wachtwoord hebt vergeten, deze opnieuw aanvragen.";
$pgv_lang["username_help"]					= "~#pgv_lang[username]#~<br /><br />In dit veld vult u uw gebruikersnaam in.<br /><br /><b>De gebruikersnaam is hoofdlettergevoelig.</b> Dit betekent dat <b>MijnNaam</b> <u>niet</u> hetzelfde is als <b>mijnnaam</b> of <b>MIJNNAAM</b>.";
$pgv_lang["password_help"]					= "~#pgv_lang[password]#~<br /><br />In dit veld vult u uw wachtwoord in.<br /><br /><b>Het wachtwoord is hoofdlettergevoelig.</b> Dit betekent dat <b>MijnWachtwoord</b> <u>niet</u> hetzelfde is als <b>mijnwachtwoord</b> of <b>MIJNWACHTWOORD</b>.";
$pgv_lang["login_buttons_help"]				= "~TOEGANGSKNOP~<br /><br />Hier ziet u een knop om toegang te krijgen tot het systeem.<br /><br />Als u op deze knop klikt, keert u terug naar de pagina waar u zich net bevond, maar met ingelogde toegangsrechten. Als u op deze knop klikt terwijl u zich op de welkomstpagina bevond, wordt u naar de pagina «#pgv_lang[mygedview]#» geleid, waar kunt u uw eigen instellingen en favorieten aanpassen, e-mails ontvangen en versturen, enz.";
$pgv_lang["login_buttons_aut_help"]			= "~TOEGANGSKNOP~<br /><br />Hier ziet u een knop om toegang te krijgen tot het systeem.<br /><br />Als u op deze linker knop klikt, wordt u aangemeld en gaat u direct naar uw persoonlijke «#pgv_lang[mygedview]#» pagina. Hier kunt u uw eigen instellingen en favorieten aanpassen, e-mails ontvangen en versturen, enz.";
$pgv_lang["new_password_help"]				= "~#pgv_lang[requestpassword]#~<br /><br />Als u uw wachtwoord kwijt bent, kunt u via deze koppeling een nieuw wachtwoord aanvragen.<br /><br />U komt dan terecht op de pagina «#pgv_lang[lost_pw_reset]#».";
$pgv_lang["new_user_help"]					= "~#pgv_lang[requestaccount]#~<br /><br />Bent u een bezoeker van deze site en wilt u een gebruikersaccount aanvragen, dan kunt u op deze link klikken.<br /><br />Afhankelijk van hoe de beheerder de site heeft opgezet, kan uw e-mailclient worden gestart zodat u de beheerder een e-mail kunt sturen om een nieuwe gebruikersnaam aan te vragen, of u kunt naar de pagina «#pgv_lang[requestaccount]#» worden geleid.";
$pgv_lang["mygedview_login_help"]			= "Om toegang te verkrijgen tot uw persoonlijke MyGedView pagina, moet u beschikken over een gebruikernaam. Op deze persoonlijke pagina kunt u uw favoriete personen vastleggen, notities maken, boodschappen versturen. zien wie er verder nog aangelogd zijn en uw persoonlijke pagina naar believen indelen met nog meer informatievakken.<br /><br />Type, om naar uw persoonlijke MyGedView pagina te gaan, uw gebruikersnaam en wachtwoord in de vakjes in en klik op <b>#pgv_lang[login]#</b>.";
$pgv_lang["new_user_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />In dit vak moet u uw voornaam invullen.<br /><br />We hebben uw voor- en achternaam nodig om te bepalen of u in aanmerking komt voor een account op deze site en wat uw rechten zouden moeten zijn. Deze namen zijn zichtbaar voor andere ingelogde gezinsleden en gebruikers.";
$pgv_lang["new_user_lastname_help"]			= "~#pgv_lang[lastname]#~<br /><br />In dit vak moet u uw achternaam invullen.<br /><br />We hebben uw voor- en achternaam nodig om te bepalen of u in aanmerking komt voor een account op deze site en wat uw rechten zouden moeten zijn. Deze namen zijn zichtbaar voor andere ingelogde gezinsleden en gebruikers.";
$pgv_lang["register_info_01"]				= "~#pgv_lang[requestaccount]#~<br /><br />De hoeveelheid gegevens, die publiekelijk op deze website kan worden bekeken is beperkt vanwege wettelijke regelingen aangaande de privacy bescherming. Veel mensen willen niet dat persoonlijke gegevens publiekelijk beschikbaar zijn op het internet. Persoonlijke gegevens zouden kunnen worden gebruikt voor het verzenden van spam en, nog erger, identiteits-diefstal.<br /><br />Het zich aanmelden (inloggen) bij deze site is alleen toegestaan aan bezoekers, die een gebruikers-account hebben. Nadat de Beheerder uw account aanvraag heeft gecontroleerd en goedgekeurd, zult u zich aan kunnen melden.<br /><br />Als de Familieband Privacy is geactiveerd, kunt u alleen de persoonlijk informatie inzien van uw directe verwanten. De Beheerder kan ook bepaalde gebruikers toestaan om gegevens in de database te wijzigen, of aan te vullen.<br /><br />Als u meer uitleg, of hulp, nodig heeft, neem dan a.u.b. kontakt op met de Beheerder, via de link onderaan de pagina.";
$pgv_lang["register_info_02"]				= "~#pgv_lang[requestaccount]#~<br /><br />De hoeveelheid gegevens, die publiekelijk op deze website kan worden bekeken is beperkt vanwege wettelijke regelingen aangaande de privacy bescherming. Veel mensen willen niet dat persoonlijke gegevens publiekelijk beschikbaar zijn op het internet. Persoonlijke gegevens zouden kunnen worden gebruikt voor het verzenden van spam en, nog erger, identiteits-diefstal.<br /><br />Het zich aanmelden (inloggen) bij deze site is alleen toegestaan aan <u>geauthoriseerde</u> gebruikers. Nadat de Beheerder uw account aanvraag heeft gecontroleerd en goedgekeurd, zult u zich aan kunnen melden en de persoonlijke gegevens kunnen bekijken.<br /><br />Als de Familieband Privacy is geactiveerd, kunt u alleen de persoonlijk informatie inzien van uw directe verwanten. De Beheerder kan ook bepaalde gebruikers toestaan om gegevens in de database te wijzigen, of aan te vullen.<br /><br />Als u meer uitleg, of hulp, nodig heeft, neem dan a.u.b. kontakt op met de Beheerder, via de link onderaan de pagina.";
$pgv_lang["register_info_03"]				= "~#pgv_lang[requestaccount]#~<br /><br />De hoeveelheid gegevens, die publiekelijk op deze website kan worden bekeken is beperkt vanwege wettelijke regelingen aangaande de privacy bescherming. Veel mensen willen niet dat persoonlijke gegevens publiekelijk beschikbaar zijn op het internet. Persoonlijke gegevens zouden kunnen worden gebruikt voor het verzenden van spam en, nog erger, identiteits-diefstal.<br /><br />Het zich aanmelden (inloggen) bij deze site is alleen toegestaan aan <u>familieleden</u>. Nadat de Beheerder uw account aanvraag heeft gecontroleerd en goedgekeurd, zult u zich aan kunnen melden en de persoonlijke gegevens kunnen bekijken.<br /><br />Als de Familieband Privacy is geactiveerd, kunt u alleen de persoonlijk informatie inzien van uw directe verwanten. De Beheerder kan ook bepaalde gebruikers toestaan om gegevens in de database te wijzigen, of aan te vullen.<br /><br />Als u meer uitleg, of hulp, nodig heeft, neem dan a.u.b. kontakt op met de Beheerder, via de link onderaan de pagina.";


//-- Descendancy-page
$pgv_lang["help_descendancy.php"]		= "~#pgv_lang[descend_chart]#~<br /><br />Deze pagina toont de nakomelingen van een persoon.<br /><br />U kunt een startende (wortel) persoon kiezen voor deze Nakomelingen-grafiek of u kunt naar deze pagina worden doorgelinkt door te klikken op de <b>#pgv_lang[descend_chart]#</b> link op een andere pagina. Klik op pijlpictogrammen om door deze boom in de richting van de pijl te navigeren. Klik op het diagrampictogram in een persoonvenster om de wortel van de stamboom naar die persoon te wijzigen.";
$pgv_lang["desc_rootid_help"]				= "#pgv_lang[rootid_help]#";
$pgv_lang["desc_generations_help"]			= "#pgv_lang[PEDIGREE_GENERATIONS_help]#";

//-- Time line-page
$pgv_lang["help_lifespan.php"]				= "~#pgv_lang[lifespan_chart]#~<br /><br />Op dit grafiek kunt u een persoon, of meerdere personen langs een horizontale tijdlijn laten tonen.  Dit grafiek laat u zien hoe de levens van verschillende peronen elkaar kunnen overlappen.<br /><br />U kunt mensen per persoon aan het grafiek toevoegen, of in gezinsverband, m.b.v. hun ID's.  De vorige lijst wordt bewaard als u meer mensen aan het grafiek toevoegt.  U kunt het grafiek op elk moment wissen door te klikken op de  <b>Wis Grafiek</b> knop.<br /><br />U kunt zelfs mensen toevoegen door te zoeken in een datumbereik of per plaats.";
$pgv_lang["lifespan_add_person_help"]		= "#pgv_lang[add_person_help]#<br /><br /><b>Inclusief Directe Familie</b><br />Inclusief Directe Familie is standaard aangevinkt. Laat dit aangevinkt om ook de vader, moeder, partner, broers, zusters en kinderen te zien van de persoon, die aan Levensduur Grafiek wordt toegevoegd. Verwijder het vinkje als u de directe familie niet mede wilt toevoegen.";
$pgv_lang["help_timeline.php"]				= "~#pgv_lang[timeline_chart]#~<br /><br />Op deze pagina kunt u de gebeurtenissen en feiten van een of meerdere personen langs een tijdlijn zichtbaar maken. Op die manier kunt u bijvoorbeeld de status van twee of meer personen op een bepaald moment tonen.<br /><br />Als u vanaf een andere pagina op de tijdlijn-koppeling klikt, wordt de desbetreffende persoon automatisch op de tijdlijn getoond. Als u de tijdlijn heeft gekozen vanaf het menu, kunt u de persoon aangeven door middel van een ID. Ook kunt u met behulp van <b>Find ID</b> de gewenste persoon opzoeken.";
$pgv_lang["add_person_help"]				= "~#pgv_lang[add_another]#~<br /><br />Op de tijdlijn kunt u de gebeurtenissen van meerdere personen weergeven.<br /><br />Gebruik het veld in het vak om personen toe te voegen. U kunt direct het ID van de persoon intikken. Als u het ID niet kent, kunt u de persoon opzoeken door de koppeling <b>Find ID</b> aan te klikken en dan op (deel van) de naam te zoeken.";
$pgv_lang["remove_person_help"]				= "~#pgv_lang[remove_person]#~<br /><br />Klik op deze koppeling om de persoon en diens gebeurtenissen van de tijdlijn te verwijderen.";
$pgv_lang["show_age_marker_help"]			= "~#pgv_lang[show_age]#~<br /><br />Als u deze optie aanvinkt, verschijnt er een leeftijdsindicator van deze persoon op de tijdlijn.<br /><br />Met behulp van uw linker muisknop kunt u deze indicator naar beneden en naar boven schuiven langs de tijdlijn. De indicator geeft, op het aangegeven punt op de tijdlijn, het jaartal aan en de leeftijd van de desbetreffende persoon op dat moment. Voor elke persoon op de tijdlijn kunt u de leeftijdsindicator aan- of uitzetten.";
$pgv_lang["timeline_control_help"]			= "~#pgv_lang[timeline_controls]#~<br /><br />~SNELHEID~<br />Klik op de  \"drop down\" lijst en kies een waarde om de snelheid, waarmee de tijdbalk zich verplaatst, te wijzigen.<br /><br />~Begin_Jaar~<br />Voer een jaartal in, als beginjaar van de reeks.<br /><br />~Eind_Jaar~<br />Voer een jaartal in, als laatste jaar van de reeks.<br /><br />~Zoeken~<br />Klik op de \"Zoeken\" knop om te beginnen met zoeken naar gebeurtenissen, die voorkwamen tussen de twee jaartallen, die u eerder heeft ingevoerd.";

//-- Relationship-page
$pgv_lang["help_relationship.php"]			= "~#pgv_lang[relationship_chart]#~<br /><br />Op deze pagina kunt u de verwantschap tussen twee personen vaststellen. Het is hierbij niet noodzakelijk, dat de twee personen ook bloedverwanten van elkaar zijn; elke relatie zal worden gevonden.";
$pgv_lang["relationship_id_help"]			= "~#pgv_lang[id]# :: #pgv_lang[person1]# :: #pgv_lang[person2]#~<br /><br />Als u van een andere pagina naar deze bent gesprongen door op de link <b>Relatie tot mij</b> te hebben geklikt, ziet u hier de relatie tussen uzelf en die andere persoon.<br /><br />Als u op deze pagina bent terechtgekomen via het menu-item <b> Relatiediagram </b> in een paginakop, moet u de identificatienummers typen van de twee mensen van wie u de relatie wilt zien. Als u de identificatie van de gewenste persoon niet kent, kunt u op de link <b>Zoek ID</b> klikken.";
$pgv_lang["next_path_help"]					= "~#pgv_lang[next_path]#~<br /><br />Twee personen kunnen een relatie met elkaar hebben via verschillende personen in de stamboom. U kunt deze knop gebruiken om het programma een volgend pad te laten zoeken. De verschillende gevonden paden blijven bewaard en kunnen door middel van de aangegeven koppelingen (\"Toon pad ...\") opgeroepen worden.";
$pgv_lang["follow_spouse_help"]				= "~#pgv_lang[follow_spouse]#~<br /><br />Zonder deze optie worden alleen relaties tussen personen gevonden, die een bloedband hebben. Is deze optie ingeschakeld, dan zoekt het programma ook naar relaties door huwelijk. Hiermee zult u waarschijnlijk meer relatiepaden vinden.";
$pgv_lang["line_up_generations_help"]		= "~#pgv_lang[line_up_generations]#~<br /><br />Als u deze optie aanzet, worden alle zelfde generaties in het overzicht op dezelfde hoogte op de pagina afgedrukt. Staat deze optie uit, dan wordt het overzicht van boven naar beneden afgedrukt, ongeacht of de relatie nu kind-ouder of ouder-kind betreft.";
$pgv_lang["oldest_top_help"]				= "~#pgv_lang[oldest_top]#~<br /><br />Met deze optie kunt u de oudste personen in het overzicht bovenaan laten afdrukken. In het andere geval worden de jongste personen bovenaan getoond.<br /><br />Let op: Deze optie werkt alleen als <i>#pgv_lang[line_up_generations]#</i> is aangevinkt.";

//-- Ancestry-page
$pgv_lang["help_ancestry.php"]				= "~#pgv_lang[ancestry_chart]# - pagina~<br /><br />De pagina Voorouders lijkt veel op de <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, maar toont meer details en heeft een keuze in <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a>.<br /><br />Elke voorouder heeft een uniek nummer volgens het <i>Sosa-Stradonitz</i> systeem :<div style=\"padding-left: 30px;\"><b>Even</b> nummers voor mannen (kind * 2)<br /><b>Oneven</b> nummers voor vrouwen (partner + 1), behalve uiteraard voor nummer <b>1</b></div><br />Voorbeeld:<br /><div style=\"padding-left: 30px;\">De basispersoon is <b>1</b>, ongeacht geslacht.<br />vader van <b>1</b> is <b>2</b> (<b>1</b> * 2), moeder is <b>3</b> (<b>2</b> + 1).<br />vader van <b>2</b> is <b>4</b> (<b>2</b> * 2), moeder is <b>5</b> (<b>4</b> + 1).<br />vader van <b>3</b> is <b>6</b> (<b>3</b> * 2), moeder is <b>7</b> (<b>6</b> + 1).<br />vader van <b>7</b> is <b>14</b> (<b>7</b> * 2), moeder is <b>15</b> (<b>14</b> + 1).<br />enz.</div>";
$pgv_lang["box_width_help"]					= "~#pgv_lang[ancestry_chart]# - vakbreedte~</b><br /><br />Hiermee kun u de breedte van de vakken met persoonsgegevens instellen, van 50% tot 300%. Standaard is 100% hetgeen overeenkomt met een vakbreedte van 270 pixels.";
$pgv_lang["chart_style_help"]			= "~#pgv_lang[chart_style]#~<br /><br />Er zijn twee diagramstijlen beschikbaar:<ul><li><b>#pgv_lang[chart_list]#</b>&nbsp;&nbsp;&nbsp;Verticale boom, met opvouwbare / uitbreidbare families.</li><li><b>#pgv_lang[chart_booklet]#</b>&nbsp;&nbsp;&nbsp;Eén gezin per pagina, met ouders, grootouders en alle geregistreerde kinderen.<br /><br />Dit formaat is gemakkelijk af te drukken om aan uw familieleden te geven.</li></ul>";

//-- Fan chart-page
$pgv_lang["help_fanchart.php"]				= "~#pgv_lang[fan_chart]# - pagina~<br /><br />Het cirkeldiagram lijkt veel op de <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, maar toont de informatie grafisch op een andere wijze.<br /><br />De startpersoon staat in het centrum van het diagram, de ouders in de eerste cirkel, de grootouders in de tweede, enz.<br /><br />Het geboorte- en overlijdensjaar worden, indien bekend, onder de naam van de persoon afgedrukt.<br /><br />Als u op de naam van een persoon klikt, wordt deze de startpersoon in het cirkeldiagram en verschuift daarmee naar het centrum.<br />In het centrum ziet u tevens een pijl, waarmee u een van de kinderen of broers en zusters van de huidige startpersoon, de nieuwe startpersoon kunt maken. Dit werkt hetzelfde als in de <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>.";
$pgv_lang["fan_width_help"]					= "~#pgv_lang[fan_chart]# - omvang~</b><br /><br />De omvang van het cirkeldiagram kunt u instellen van 50% tot 300%. De standaard waarde is 100%, de afbeelding is hiermee ongeveer 640 beeldpunten in breedte.";
$pgv_lang["fan_style_help"]					= "~#pgv_lang[fan_chart]# - stijl~<br /><br />Deze optie regelt hoe het cirkeldiagram wordt getoond.<ul><li><b>1/2</b>&nbsp;&nbsp;&nbsp;Halve  diagram (180&deg;)</li><li><b>3/4</b>&nbsp;&nbsp;&nbsp;Drie-kwart cirkel diagram (270&deg;)</li><li><b>4/4</b>&nbsp;&nbsp;&nbsp;Volledige cirkel diagram (360&deg;)</li></ul>";

//-- Hourglass chart-page
$pgv_lang["help_hourglass.php"]			= "~#pgv_lang[hourglass_chart]#~<br /><br />De zandloperdiagram toont de voorouders en afstammelingen van de geselecteerde hoofdpersoon op dezelfde kaart. Dit diagram is een mix tussen het nakomelingenoverzicht en het stamboomdiagram.<br /><br />De hoofdpersoon staat in het midden van de pagina met links zijn nakomelingen en rechts zijn voorouders. In deze weergave wordt elke generatie over de pagina uitgelijnd, beginnend met de vroegste generatie en eindigend met de laatste.<br /><br />Als er onder de hoofdpersoon een pijl naar beneden op het scherm staat, dan wordt er door erop te klikken een lijst weergegeven met de naaste familieleden van de hoofdpersoon die u kunt gebruiken om door de kaart te navigeren. Als u een naam uit deze lijst selecteert, wordt het diagram opnieuw geladen met de geselecteerde persoon als de nieuwe hoofdpersoon.";

//-- Family Book chart-page
$pgv_lang["help_familybook.php"]			= "~#pgv_lang[familybook_chart]#~<br /><br />Dit diagram is, min of meer, gelijk aan het Zandloperdiagram.  Het toont de voorouders en de nakomelingen van de gekozen startpersoon in hetzelfde diagram.  Het toont eveneens de nakomelingen van de startperoon in eenzelfde Zandloperdiagram, op dezelfde pagina.<br /><br />De startpersoon staat gecentreerd op de pagina, met de nakomelingen links en de voorouders rechts ervan.  In dit overzicht zijn de generaties zo over de pagina verdeeld, dat het start met de vroegste generatie en eindigt met de laatste.<br /><br />Elke nakomeling van de startpersoon wordt zelf de startpersoon van een extra zandloperdiagram op dezelfde pagina.  Dit wordt zovaak herhaald tot er niet meer nakomelingen zijn te tonen, of tot het maximum aantal is bereikt, zoals was ingevuld in het daarvoor bestemde vakje.";
$pgv_lang["fambook_descent_help"]			= "~#pgv_lang[descent_steps]#~<br /><br />Deze waarde bepaalt het aantal generaties nakomeling, van de startpersoon, dat zal worden getoond in het Zandloperdiagram formaat.";

//-- Indilist-page
$pgv_lang["help_indilist.php"]			= "~PERSONEN LIJST PAGINA~<br /><br />Op deze pagina kunt u een lijst met personen weergeven. De namen worden weergegeven met de achternamen eerst en in alfabetische volgorde gesorteerd.<br /><br />De uitvoer van de namenlijst is afhankelijk van:<ul><li>De letter waarop u hebt geklikt in de alfabetische index.</li><li>Of u op \"Overslaan\" of \"Toon\" heeft geklikt op de achternaamlijst.</li></ul>#pgv_lang[context_help]#";
$pgv_lang["alpha_help"]					= "~ALPHABETICAL INDEX~<br /><br />Als u op een letter in de alfabetische index klikt, wordt een lijst weergegeven met de namen die beginnen met de letter waarop u hebt geklikt.<br /><br />Het voorlaatste item in de alfabetische index kan zijn <b>#pgv_lang[NN]#</b>. Dit item is aanwezig als er mensen in de database zijn waarvan de achternaam niet is opgenomen of geen herkenbare letters bevat. Onbekende achternamen worden vaak geregistreerd als <b>#pgv_lang[qm]#</b>, en deze worden herkend als <b>#pgv_lang[NN]#</b>. Dit gebeurt ook als de persoon onbekend is.<br /><br /><b>Notitie:</b><br />Familienamen die zijn ingevoerd als bijvoorbeeld <b>Nn</b>, <b>NN</b>, <b>Onbekend</b> of zelfs <b>N.N.</b> zullen <u>niet</u> te vinden in de <b>#pgv_lang[NN]#</b> lijst. In plaats daarvan vindt u deze personen door op <b>N</b> of <b>O</b> te klikken, omdat dit de beginletters van die namen zijn. PhpGedView kan onmogelijk rekening houden met alle mogelijke manieren om onbekende achternamen in te voeren; hiervoor is geen erkende conventie.<br /><br />Aan het einde van de alfabetische index zie je <b>ALLE</b>. Als u op dit item klikt, ziet u een lijst met alle achternamen in de database.<br /><br /><b>Ontbrekende letters?</b><br />Als uw alfabetische index onvolledig blijkt te zijn, met ontbrekende letters, bevat uw database geen achternamen die met die ontbrekende letter beginnen.";
$pgv_lang["name_list_help"]				= "~NAMENLIJST~<br /><br />In dit vak wordt een lijst met achternaam of een volledige lijst met namen weergegeven. In beide gevallen beginnen alle achternamen met de beginletter waarop u in de alfabetische index heeft geklikt, tenzij u op <b>ALLE</b> hebt geklikt.<br /><br />Of u een achternaamlijst of de volledige naam ziet lijst hangt af van de status van de link <b>Achternaamlijsten overslaan / tonen</b>.";
$pgv_lang["skip_sublist_help"]			= "~SUBLIJST OVERSLAAN~<br /><br />De standaardinstelling is dat u, nadat u op een letter van de alfabetische index heeft geklikt, een sublijst met achternamen krijgt. Als u op deze link klikt, worden alle personen met achternamen die de momenteel geselecteerde beginletter hebben, onmiddellijk weergegeven. Daarna wordt de lijst met personen direct weergegeven wanneer u op een nieuwe beginletter in de alfabetische lijst klikt.<br /><br />Om deze actie ongedaan te maken, klikt u op de #pgv_lang[show_surnames]# link.";
$pgv_lang["show_marnms_help"]				= "~#pgv_lang[show_marnms]#~<br /><br />De pagina's van Personen- en Familielijsten kunnen wel of geen huwelijksnamen bevatten.  Deze optie kan handig zijn als u personen zoekt, waarvan u alleen de huwelijksnaam kent. Huwelijksnamen kunnen alleen worden inbegrepen als ze ook daadwerkelijk bestaan in de database.<br /><br />Voor de Familielijst is de standaard instelling: Niet inbegrepen. Voor de Personenlijst is de standaardwaarde ingesteld op de GEDCOM Instellingen pagina.<br /><br />Als de optie hier wordt gewijzigd, wordt uw selectie bewaard totdat u zich afmeldt of totdat uw sessie eindigt.";

//-- Families-page
$pgv_lang["help_famlist.php"]			= "~FAMILIE LIJST PAGINA~<br /><br />Op deze pagina kunt u een lijst met gezinnen weergeven. De namen worden weergegeven met de achternamen eerst en in alfabetische volgorde gesorteerd.<br /><br />De uitvoer van de namenlijst is afhankelijk van:<ul><li>De letter waarop u hebt geklikt in de alfabetische index.</li><li>Of u op \"Overslaan\" of \"Toon\" heeft geklikt op de achternaamlijst.</li></ul>U kunt zoeken op de achternaam van de echtgenoot of echtgenote; beide zijn opgenomen in de lijst.<br /><br />#pgv_lang[context_help]#";
$pgv_lang["help_family.php"]			= "~FAMILIE DETAILS PAGINA~<br /><br />Op deze pagina vindt u een overzicht van de familie die u op een vorige pagina heeft gekozen.<br /><br />Van boven naar beneden ziet u de vakken Persoonlijke gegevens van de man en zijn ouders, de vrouw en haar ouders, en de kinderen.<br /><br />De lay-out en inhoud van de persoonsboxen zijn dezelfde als de boxen die u al kent van de pagina's Stamboom en Nakomelingen.<br /><br />Rechts van de ouderboxen ziet u mogelijk een pijl als er meer voorouders in het bestand zijn. Als je op die pijl klikt, ga je een generatie omhoog om je een nieuwe gezinspagina te laten zien met de vorige ouders die nu als man en vrouw worden vermeld.<br /><br />Aan de rechterkant in het naamvak ziet u mogelijk een zoompictogram (vergrootglas) waarop u kunt klikken om meer details over het individu te onthullen. Als u op de naam klikt, wordt u naar de #pgv_lang[indi_info]# pagina van die persoon geleid.<br /><br />Ook aan de rechterkant vindt u een klein menu om naar pagina's met grafieken of meer informatie te gaan. Sommige van deze menu-items hebben ook submenu's die verschijnen wanneer uw muisaanwijzer het bovenliggende menu-item nadert.<br /><br />Het familiegroepsinformatie-venster toont alle bekende feiten en informatie over deze familie, zoals huwelijk, multimedia-objecten en aantekeningen. Als u in het vak Feiteninformatie op een plaats klikt, gaat u naar de lijst met plaatsen, waar alle andere families en personen die met die plaats zijn verbonden, worden weergegeven. Als u op een datum klikt, gaat u naar de dagkalender, die alle gebeurtenissen toont die op die dag en maand in de geschiedenis hebben plaatsgevonden. Op multimedia-objecten kan worden geklikt; hierdoor wordt een nieuw venster geopend waarin het object wordt bekeken. Als je op het fotobijschrift klikt, zie je de foto op de #pgv_lang[media_list]# pagina. Als u op een bronlink klikt, worden de details van die bron weergegeven op de bronpagina.<br /><br />Onder de naamvakken van de kinderen vindt u de link <b>Voeg een kind toe aan dit gezin</b>. Naast de naamvakken van de kinderen zie je de link <b>Gezinsgroepinformatie</b>. Als u voldoende rechten heeft, kunt u hier gegevens en feiten bewerken, verwijderen en toevoegen.<br /><br />Net als bij de #pgv_lang[indi_info]# pagina, zie je een menu rechtsboven op de pagina. Invoer in dit menu brengt u naar andere pagina's waar u informatie over dit gezin kunt krijgen of andere taken kunt uitvoeren die verband houden met dit gezin.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["add_child_help"]					= "~KIND TOEVOEGEN AAN DIT GEZIN~<br /><br />Met deze functie kunt u een nieuw persoon als kind toevoegen aan dit gezin.<br /><br />Als u op de koppeling heeft geklikt, krijgt u een nieuw scherm, waarop u zoveel mogelijk gegevens van de persoon dient in te vullen. ";
$pgv_lang["show_fam_gedcom_help"]			= "~#pgv_lang[view_gedcom]#~<br /><br />De informatie over het gezin, zoals deze is opgeslagen in de database, wordt weergegeven wanneer u op deze link klikt. Het display toont ruwe GEDCOM-gegevens.";
$pgv_lang["add_fam_clip_help"]				= "~FAMILIE TOEVOEGEN AAN KNIPSELBAK~<br /><br />U kunt alle of een deel van de informatie van deze familie toevoegen aan uw #pgv_lang[clip_cart]#. Op de volgende pagina kunt u precies kiezen hoeveel informatie u wilt toevoegen:<ul><li>#pgv_lang[just_family]#</li><li>#pgv_lang[parents_and_family]#</li><li>#pgv_lang[parents_and_child]#</li><li>#pgv_lang[parents_desc]#</li></ul>";
$pgv_lang["show_fam_timeline_help"]			= "~TOON PARTNERS OP DE TIJDLIJN~<br /><br />Deze koppeling brengt u op de tijdlijn-pagina, waar de tijdlijn direct met de gegevens van de partners wordt weergegeven.";

//-- Source list-page
$pgv_lang["help_sourcelist.php"]		= "~BRONNENLIJST PAGINA~<br /><br />Op deze pagina wordt een lijst met bronnen weergegeven.<br /><br />In tegenstelling tot de pagina's #pgv_lang[indi_info]# en Familie, is er geen alfabetische index.<br /><br />Een bron kan een persoon zijn, een openbare database, een instelling, een internetbron, enz. Vanwege de volkomen willekeurige aard van genealogische bronnen, is het onmogelijk om een sorteervolgorde te vinden die in alle gevallen zinvol is. PhpGedView <u>wel</u> sorteert de bronnamen echter in alfabetische volgorde.<br /><br /><b>BRONNEN</b><br />Zonder bronnen kunnen we onze database niet opbouwen. Voor elk gegeven in de database is een bron. De bron kan een familielid zijn, een instelling, een openbare database, overheids- of privérecords, een internetbron, enz.<br /><br />Een bron kan aan veel personen worden gekoppeld. Een persoon kan ook aan veel bronnen worden gekoppeld. U kunt voor elke gebeurtenis verschillende bronnen hebben, of het nu gaat om geboortedatum, beroep, huwelijk, kinderen, enz.";
$pgv_lang["sourcelist_listbox_help"]		= "~VAK BRONNENLIJST~<br /><br />In dit vak ziet u de titels van alle bronnen, die in het bestand zijn opgenomen.<br /><br />De lijst is op alfabetische volgorde van titel gesorteerd. Als u op een naam in de lijst klikt, gaat u naar de bronpagina waar een lijst wordt weergegeven. Deze lijst laat zien welke personen of families aan die bron zijn gekoppeld.";

//-- Sources-page
$pgv_lang["help_source.php"]			= "~BRON DETAILS PAGINA~<br /><br />De details van de bron worden op deze pagina weergegeven. Bronnen zijn erg belangrijk voor genealogische onderzoekers en stellen u in staat het spoor te volgen dat een andere onderzoeker heeft gebruikt om de informatie te vinden.<br /><br />U kunt informatie zien over de titel, de auteur, de publicatie van de bron en de opslagplaats waar de bron is opgezocht. Vanwege de vele verschillende soorten bronnen kunnen sommige bronnen meer informatie bevatten dan andere.<br /><br />Als een multimedia-object, zoals een scan van een document, is verbonden met de bron, kunt u dat object bekijken door op het object te klikken. Als je op de objectnaam klikt, zie je het object op de #pgv_lang[media_list]# pagina.<br /><br />Na de brondetails volgt een lijst van alle personen en gezinnen die op deze bron zijn aangesloten. Hiermee kunt u alle items identificeren die uit die gegevensbron zijn verkregen.<br /><br />Als de beheerder deze functies heeft ingeschakeld, heb je een of twee extra menupictogrammen op deze pagina:<ul><li><b>#pgv_lang[view_gedcom]#</b><br />die de informatie in GEDCOM-formaat toont.</li><li><b>#pgv_lang[add_to_cart]#</b><br />waardoor u deze informatie in uw #pgv_lang[clip_cart]# kunt opslaan om later te downloaden en te importeren in uw eigen genealogieprogramma.</li></ul><br />#pgv_lang[context_help]#";
$pgv_lang["sources_listbox_help"]		= "~RECORDS GEKOPPELD AAN DEZE BRON~<br /><br />In deze box zie je de namen van personen en families die met de bron verbonden zijn.<br /><br />De namen worden in alfabetische volgorde weergegeven. Als u op een naam in de lijst klikt, gaat u naar de relevante detailpagina.";
$pgv_lang["show_source_gedcom_help"]		= "~#pgv_lang[view_gedcom]#~<br /><br />Als u op deze koppeling klikt, krijgt u in een nieuw venster de gegevens over de bron te zien, zoals ze in het GEDCOM-bestand zijn opgenomen.";
$pgv_lang["add_source_clip_help"]		= "~#pgv_lang[add_to_cart]#~<br /><br />Als u op deze link klikt, kunt u de broninformatie toevoegen aan uw #pgv_lang[clip_cart]# om deze later te downloaden en te importeren in uw eigen genealogieprogramma.";
$pgv_lang["delete_source_help"]				= "~#pgv_lang[delete_source]#~<br /><br />Door deze optie aan te klikken, markeert u een bron voor verwijdering uit de genealogie.<br /><br />Wat betekent dat nu? Laten we aannemen dat u een goede reden heeft om deze bron uit de genealogie te verwijderen. U klikt op de koppeling. Daarna verschijnt er een venster, waarin u wordt gevraagd of u er zeker van bent, of dat u de bewerking wilt annuleren. De bron zal echter nog steeds zichtbaar en raadpleegbaar zijn.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["no_mistake"]					= "<b>Dit is <u>geen</u> fout.</b> De beheerder heeft een e-mail gekregen, waarin wordt vermeld dat er een wijziging op de genealogie is aangebracht en dat je iets hebt verwijderd. De beheerder kan de wijziging accepteren of ongedaan maken. Pas nadat de beheerder uw wijziging heeft geaccepteerd, wordt de verwijdering daadwerkelijk definitief. Bij twijfel zal de beheerder contact met u opnemen.";

//-- Persons per Place-page
$pgv_lang["help_placelist.php"]				= "~PLAATS HIËRARCHIE~ (of Personen per locatie)~<br /><br />Via dit scherm kunt u personen en gezinnen opzoeken, die een verband hebben met een bepaalde locatie.<br /><br />Wanneer een locatie wordt genoemd in een feit of gebeurtenis van een persoon of gezin, vindt het programma deze voor u.<br /><br />De resultaten worden weergegeven in een lijst met twee kolommen, één kolom voor individuen en één voor gezinnen.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["ppp_default_form_help"]			= "~ORDENING VAN LOCATIES~<br /><br /><b>STANDAARD</b><br />Dit betekent dat er geen plaatscoderingsformaat is opgegeven in dit GEDCOM-bestand en het standaardformaat wordt aangenomen.<br /><br />Als er een ander formaat was gevonden, zou dit zijn weergegeven tussen de <b>(</b> en <b>)</b> aan het einde van de regel.";
$pgv_lang["ppp_match_one_help"]				= "~ORDENING VAN LOCATIES~<br /><br /><b>VOLGENS GEDCOM</b><br />Aangenomen wordt dat de locaties zijn gecodeerd in het plaatsformaat dat expliciet is aangegeven in het GEDCOM-bestand. Dit heft de standaardvolgorde op.";
$pgv_lang["ppp_numfound_help"]				= "~LOCATIEVERBINDINGEN GEVONDEN~<br /><br />Hier wordt het aantal locatieverbindingen getoond dat is gevonden. Als nog steeds een lijst met locaties zichtbaar is, betekent dit dat het laagste niveau nog niet is bereikt.<br /><br />U kunt de bij deze locatie bijbehorende gezinnen en personen zien, door op deze koppeling te klikken. Ook kunt u de zoekopdracht verder verfijnen, door op een locatie te klikken in de lijst.";
$pgv_lang["ppp_levels_help"]				= "~LOCATIE NIVEAUS~<br /><br />Dit laat het aantal niveaus binnen de locatie zien, dat nu wordt getoond. De lijst in het vak is in feite een deellijst van het bovenliggende niveau.<br /><br />VOORBEELD:<ul><li>De standaard volgorde is: #pgv_lang[default_form]#</li><li>Als het huidige niveau het \"Hoogste niveau\" is, dan laat het vak alle landen in het bestand zien.</li><li>Als het huidige niveau \"USA, Hoogste niveau\" is, geeft het vak alle staten in de USA weer.</li><li>etc.</li></ul><br />U kunt op een niveau klikken, om een of meer stappen terug te gaan.";
$pgv_lang["ppp_placelist_help"]				= "~LOCATIE HIËRARCHIE~<br /><br />In deze lijst worden de locaties getoond, die zijn gevonden onder de locatie die u heeft gekozen. Heeft u nog geen locatie gekozen, dan ziet u een lijst met alle locaties op het hoogste niveau.<br /><br />De namen van de locaties in de lijst kunt u aanklikken. Klikken op een locatie werkt als een filter, het brengt u naar een lager niveau.";
$pgv_lang["ppp_placelist_help2"]			= "~LOCATIE LIJST~<br /><br />In deze lijst ziet u de locaties die zijn gevonden.<br /><br />U kunt op de locatienamen klikken, dit brengt u een niveau dieper.<br /><br />Alleen als u zich op het hoogste niveau bevindt, wordt er geen namenlijst weergegeven. Op alle ondergeschikte niveaus krijgt u een lijst met gezinnen en individuen die met die locatie zijn verbonden.";
$pgv_lang["ppp_view_records_help"]			= "~#pgv_lang[view_records_in_place]#~<br /><br />Door op deze koppeling te klikken, gaat u direct naar het overzicht van personen en gezinnen, waarvan een gebeurtenis op deze locatie heeft plaatsgevonden. Als u in het locatieoverzicht op het laagste niveau bent gekomen, krijgt u dit overzicht automatisch te zien.";
$pgv_lang["ppp_name_list_help"]				= "~LOCATIES - NAMENLIJST~<br /><br />In dit vak vindt u een complete lijst van personen en gezinnen, waarvan een feit of gebeurtenis naar deze locatie verwijst.<br /><br />De namen in de lijst zijn aanklikbaar. Als u op een naam klikt, wordt u naar de relevante detailpagina geleid. Wanneer u op een locatie bovenaan deze lijst klikt, wijzigt u uw locatieselectie.";

//-- Multimedia-page
$pgv_lang["help_medialist.php"]			= "~MULTIMEDIALIJST~<br /><br />Deze pagina bevat alle multimedia-objecten (MMO) die in deze database kunnen worden gevonden.<br /><br />Voor elk van de media-items zie je de titel of bestandsnaam van het item, namen van de individuen of families die zijn verbonden naar het item en opmerkingen over het item.<br /><br />Het klikken op de titel of bestandsnaam van het item heeft hetzelfde effect als het klikken op de miniatuur. Het item wordt geopend in de afbeeldingsviewer die is ingebouwd in PhpGedView of in de viewer die is opgegeven in de configuratie van uw browser.<br /><br />Als u op de link \"Bekijken\" naast de persoon of het gezin klikt, wordt u naar de relevante detailpagina geleid.";

//-- Upload Media-page
$pgv_lang["help_uploadmedia.php"]		= "~UPLOADEN MEDIABESTANDEN~<br /><br />Het uploaden van mediabestanden is vrij eenvoudig. Hier is wat aanvullende informatie.<br /><br /><b>Miniaturen</b><br />Miniaturen moeten een grootte hebben van ongeveer 100 px breed. De miniatuur <u>moet</u> dezelfde naam hebben als de volledige versie. Als uw systeem automatisch miniaturen kan genereren, ziet u een melding hiervan op de pagina Media uploaden.<br /><br /><b>Uploaden</b><br />Bestanden worden automatisch geüpload naar de map <b>#GLOBALS[MEDIA_DIRECTORY]#</b>> voor de volledige versie en naar <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> voor de miniaturen.<br /><br />#pgv_lang[readme_help]#";

//-- Anniversaries-page
$pgv_lang["help_calendar.php"]				= "~#pgv_lang[anniversary_calendar]#~<br /><br /><ul><li><a href=\"#calendar_general\"><b>Algemene informatie</b></a></li><li><a href=\"#calendar_day\"><b>#pgv_lang[day]#</b></a></li><li><a href=\"#calendar_month\"><b>#pgv_lang[month]#</b></a></li><li><a href=\"#calendar_year\"><b>#pgv_lang[year]#</b></a></li><li><a href=\"#calendar_show\"><b>#pgv_lang[show]# / #pgv_lang[showcal]#</b></a></li><li><a href=\"#calendar_sex\"><b>#pgv_lang[sex]#</b></a></li><li><a href=\"#calendar_event\"><b>Gebeurtenis</b></a></li><li><a href=\"#calendar_button\"><b>Knoppen Dag / Maand  / Jaar bekijken</b></a></li><li><a href=\"#calendar_tip\"><b>Tip</b></a></li></ul><br /><a name=\"calendar_general\"></a>De #pgv_lang[anniversary_calendar]# toont de gezinnen en personen die zijn gekoppeld aan een gebeurtenis op een bepaalde dag of maand, of in een bepaalde periode. De kalender is dermate geavanceerd, dat de juiste datum of periode met de gewenste gebeurtenissen worden getoond.<dl><dt><b>Toon <a href=\"#calendar_day\">dag</a></b></dt><dd>Dit toont de gebeurtenissen op een bepaalde dag, onafhankelijk van maand en jaar. Er verschijnt een lijst met de namen van gezinnen of personen, of een lijst met in de linkerkolom de personen en in de rechter de gezinnen.</dd><dt><b>Toon <a href=\"#calendar_month\">maand</a></b></dt><dd>In de <b>Kalender</b> zijn zowel de namen van personen als van gezinnen zichtbaar in de dagvakken. De kalender wordt getoond zoals deze was in het jaar dat u in het jaarvak heeft ingevoerd. Alle gebeurtenissen in en voor dat jaar zijn zichtbaar.<br /><br />In combinatie met de optie \"<a href=\"#calendar_show\">#pgv_lang[recent_events]#</a>\" geeft het een realistisch beeld van de maandkalender, zoals deze bij uw voorouders in dat jaar aan de muur hing.</dd><dt><b>Toon <a href=\"#calendar_year\">jaar</a></b></dt><dd>Dit toont de gebeurtenissen in een jaar of een reeks van jaren. Er verschijnt een lijst met de namen van gezinnen of personen, of een lijst met in de linkerkolom de personen en in de rechter de gezinnen.</dd></dl>De datum en maand die op dit moment worden getoond, zijn vetgedrukt in de kalenderbalken.<br /><br />U kunt klikken op de namen en datums die in de lijst staan. Hiermee springt u of naar de detailpagina van het gezin of de persoon, of naar de \"Toon dag\" of \"Toon jaar\" functie van de kalender, waarmee alle gebeurtenissen van de desbetreffende dag of het jaar worden getoond.<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_day\"></a> #pgv_lang[annivers_date_select_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_month\"></a> #pgv_lang[annivers_month_select_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_year\"></a> #pgv_lang[annivers_year_select_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_show\"></a> #pgv_lang[annivers_show_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_sex\"></a> #pgv_lang[annivers_sex_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_event\"></a> #pgv_lang[annivers_event_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_button\"></a> #pgv_lang[day_month_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_tip\"></a> #pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"]	= "~DATUM SELECTIE~<br /><br />De bovenste rij van de Selector-tabel is de <b>Dag</b> selector. De betekenis ervan is duidelijk: u selecteert een <u>dag</u>.<br /><br />Het resultaat van het klikken op een bepaalde dag hangt ervan af of u zich bevindt in <b>Dag</b> modus of in <b>Maand</b> modus.<br /><dl><dt><b>Dag modus</b></dt><dd>In deze modus klikt u op een dag, het scherm wordt vernieuwd en de lijst voor die dag wordt weergegeven.</dd><dt><b>Maand modus</b></dt><dd>Je hebt de kalender van een bepaalde maand op het scherm. Je klikt op een dag en het scherm wordt vernieuwd, maar je ziet nog steeds de maand die je had op het scherm ervoor. De reden hiervoor is dat u nog kunt beslissen om een andere maand, jaar of evenement te selecteren voordat u klikt op knop <b>#pgv_lang[viewday]#</b> of <b>#pgv_lang[viewmonth]#</b>.</dd></dl><br />Aan het einde van de rij Dag ziet u een <b>Snelle Link</b> met de datum van vandaag. Als u op die <b>Snelle Link</b> klikt, wordt de lijst voor vandaag weergegeven in de modus <b>Dag</b>, ongeacht of u zich bevindt in <b>Maand</b> modus of in <b>Dag</b> modus.";
$pgv_lang["annivers_month_select_help"]	= "~MAAND SELECTIE~<br /><br />De middelste rij van de Selector-tabel is de <b>Maand</b> selector. De betekenis ervan is duidelijk: u selecteert een <u>maand</u>.<br /><br />Het resultaat van het klikken op een bepaalde maand hangt ervan af of u zich bevindt in <b>Dag</b> modus of in <b>Maand</b> modus.<br /><dl><dt><b>Dag modus</b></dt><dd>In deze modus klikt u op een maand, het scherm wordt vernieuwd en de lijst voor die maand wordt weergegeven. Alle andere selecties zoals dag, jaar en evenementen blijven ongewijzigd.</dd><dt><b>Maand modus</b></dt><dd>Wanneer u de kalender op het scherm heeft en op een maand klikt in de rij <b>Maand</b>, wordt de kalender voor die nieuwe maand weergegeven.</dd></dl><br />Aan het einde van in de rij Maand ziet u een <b>Snelle Link</b> met de maand en het jaar van vandaag. Als u op die <b>Snelle Link</b> klikt, wordt de lijst voor die maand weergegeven in de modus <b>Maand</b>, ongeacht of u zich bevindt in <b>Maand</b> modus of in <b>Dag</b> modus.";
$pgv_lang["annivers_year_select_help"]	= "~JAAR INVOERVAK~<br /><br />Met dit invoerveld kunt u dat jaar van de kalender wijzigen. Typ een jaar in het vak en druk op <b>Invoeren</b> om de kalender naar dat jaar te wijzigen.<br /><br /><b>Geavanceerde functies</b> voor <b>#pgv_lang[viewyear]#</b><dl><dt><b>Meer dan een jaar</b></dt><dd>U kunt zoeken naar datums in een reeks van jaren.<br /><br />Jaarreeksen zijn <u>inclusief</u>. Dit betekent dat het datumbereik loopt van 1 januari van het eerste jaar van het bereik tot 31 december van het laatst genoemde jaar. Hier zijn een paar voorbeelden van jaarreeksen:<br /><br /><b>1992-5</b>&nbsp;&nbsp;&nbsp;voor alle evenementen van 1992 tot 1995.<br /><b>1972-89</b>&nbsp;&nbsp;&nbsp;voor alle evenementen van 1972 tot 1989.<br /><b>1610-759</b>&nbsp;&nbsp;&nbsp;voor alle evenementen van 1610 tot 1759.<br /><b>1880-1905</b>&nbsp;&nbsp;&nbsp;voor alle evenementen van 1880 tot 1905.<br /><b>880-1105</b>&nbsp;&nbsp;&nbsp;voor alle evenementen van 880 tot 1105.<br /><br />Om alle gebeurtenissen in een bepaald decennium of eeuw te zien, kunt u <b>#pgv_lang[qm]#</b> gebruiken in plaats van de laatste cijfers. Bijvoorbeeld, <b>197?</b>&nbsp;&nbsp;&nbsp;voor alle evenementen van 1970 tot 1979 of<b>16??</b>&nbsp;&nbsp;&nbsp;voor alle evenementen van 1600 tot 1699.<br /><br />Als u een reeks jaren selecteert, verandert de kalender in de jaarweergave.</dd></dl>";
$pgv_lang["annivers_show_help"]			= "~TOON GEBEURTENISSEN VAN ...~<br /><br />De volgende opties zijn beschikbaar:<br /><ul><li><b>Alle personen</b><br />U krijgt alle personen en families te zien.</li><li><b>Recente jaren (&lt; 100 jaar)</b><br />Met deze optie ziet u alle gebeurtenissen voor de gekozen dag of maand, maar er worden geen gebeurtenissen ouder dan 100 jaar getoond.</li><li><b>Levende personen</b><br />Tenzij de beheerder PhpGedView zo heeft geconfigureerd dat levende mensen voor iedereen zichtbaar zijn, is deze optie alleen voor jou beschikbaar nadat je bent ingelogd.<br /><br />Met deze optie worden alleen de gebeurtenissen van levende personen getoond.</li></ul>Als u op een optie klikt, worden de evenementen van uw keuze weergegeven.<br /<br />De instellingen van dag, maand en jaar, evenals <b>Dag</b> of <b>Maand</b> modus, blijven zoals ze waren.";
$pgv_lang["annivers_sex_help"]				= "~SELECTIE GESLACHT~<br /><br />Als u bent aangemeld of als de beheerder de privacyoptie niet heeft ingeschakeld, kunt u een van deze opties selecteren:<ul><li><b>Alle</b> icoon<br />Dit is de standaardoptie. De gebeurtenissen van alle individuen en families worden weergegeven.</li><li><b>Mannelijk</b> icoon<br />Alleen evenementen van mannelijke personen worden weergegeven. Bij Familie-evenementen worden alleen mannelijke gezinsleden weergegeven.</li><li><b>Vrouwelijk</b> icoon<br />Alleen evenementen van vrouwelijke personen worden weergegeven. Bij Familie-evenementen worden alleen vrouwelijke leden van gezinnen weergegeven.</li></ul>Als u een optie heeft aangeklikt wordt het scherm ververst en krijgt u de nieuwe gegevens te zien.<br /<br />De instellingen van dag, maand en jaar, evenals <b>Dag</b> of <b>Maand</b> modus, blijven zoals ze waren.";
$pgv_lang["annivers_event_help"]			= "~SELECTIE GEBEURTENIS~<br /><br />U kunt hier aangeven of u voor de personen en gezinnen alle gebeurtenissen wilt weergegeven, of alleen een specifieke gebeurtenis. U kunt niet meer dan één evenementcategorie selecteren.<br /><br />Als u de keuze heeft gemaakt, ververst het scherm en wordt getoond wat u heeft gekozen.<br /<br />De instellingen van dag, maand en jaar, evenals <b>Dag</b> of <b>Maand</b> modus, blijven zoals ze waren.";
$pgv_lang["annivers_tip_help"]			= "~TIPP~<br /><br />Pas de Datumkiezer aan op een willekeurige datum in het verleden.<br /><br />Als je op een van de Weergaveknoppen klikt, zie je een lijst of kalender voor die datum. Alle leeftijden, jubilea, enz. zijn opnieuw berekend en tellen nu vanaf de datum die u hebt ingesteld in de Datumkiezer. Je ziet nu de kalender of lijst die je voorouder op die datum, jaren geleden, zou hebben gezien.";
$pgv_lang["day_month_help"]				= "~TOON DAG / TOON MAAND / TOON JAAR~<br /><br /><ul><li>Met de knop <b>Toon Dag</b> worden de gebeurtenissen van de gekozen datum in een lijst weergegeven. Alle jaren worden gescand, dus alleen de dag en maand kunnen hier worden ingesteld. Het wijzigen van het jaar heeft geen effect. U kunt de lijst verkleinen door de optie <b>Recente jaren</b> of <b>Levende mensen</b> te kiezen.<br /><br />Leeftijden in de lijst worden berekend op basis van het huidige jaar.</li><li>De knop <b>Toon Maand</b> geeft een kalenderdiagram weer van de gekozen maand en het gekozen jaar. Ook hier kunt u de lijsten verkleinen door de optie <b>Recente jaren</b> of <b>Levende mensen</b> te kiezen.<br /><br />Je krijgt een realistisch beeld van hoe een kalender aan de muur van je voorouders eruit zag door een jaartal in het verleden te kiezen in combinatie met <b>Recente jaren</b>. Alle leeftijden op de kalender worden ten opzichte van het jaar weergegeven in het vak Jaar.</li><li>De knop <b>Toon Jaar</b> toont u een lijst met evenementen van het gekozen jaar. Ook hier kunt u de lijst verkleinen door de optie <b>Recente jaren</b> of <b>Levende mensen</b> te kiezen.<br /><br />U kunt evenementen voor een reeks van jaren laten zien. Typ gewoon het begin- en eindjaar van het bereik, met een streepje <b>-</b> ertussen. Voorbeelden:<br /><b>1992-4</b> voor alle evenementen van 1992 tot 1994<br /><b>1976-1984</b> voor alle evenementen van 1976 tot 1984<br /><br />Om alle gebeurtenissen in een bepaald decennium of eeuw te zien, kunt u <b>#pgv_lang[qm]#</b> gebruiken in plaats van de laatste cijfers. Bijvoorbeeld <b>197?</b> voor alle evenementen van 1970 tot 1979 of <b>16??</b> voor alle evenementen van 1600 tot 1699.</li></ul>Als u het jaar wilt wijzigen, moet u op een van deze drie knoppen drukken. Alle andere instellingen blijven zoals ze waren.";

//-- Clippings Cart-page
$pgv_lang["help_clippings.php"]				= "~#pgv_lang[clippings_cart]#~<br /><br />Met #pgv_lang[clip_cart]# kunt u uittreksels (\"knipsels\") uit deze stamboom nemen en ze bundelen in een enkel bestand om te downloaden en vervolgens te importeren in uw eigen genealogieprogramma. Het downloadbare bestand is opgenomen in GEDCOM-indeling.<br /><ul><li>Hoe verzamelt u de gegevens?<br />Dit is eenvoudig. Als ergens op een pagina u een naam ziet, waarop u kunt klikken (familie, persoon of bron), gaat u naar de detailpagina hiervan. Daar ziet u een optie <b>#pgv_lang[add_to_cart]#</b>. Als u daarop klikt, u kunt kiezen uit een aantal mogelijkheden voor het toevoegen.</li><li>Hoe download u gegevens?<br />Zodra u gegevens in uw knipselbak heeft, kunt u deze downloaden. Klik hiervoor op de koppeling \"Nu downloaden\" en volg de instructies.</li></ul>";
$pgv_lang["clip_download_help"]				= "~#pgv_lang[download_now]#~<br /><br />Als u op deze link klikt, gaat u naar de volgende pagina. Als een van de knipsels in uw knipselbak naar multimedia-items verwijst, worden deze items ook op die pagina weergegeven.<br /><br />Volg gewoon de instructies.";
$pgv_lang["empty_cart_help"]			= "~#pgv_lang[empty_cart]#~<br /><br />Als je op deze link klikt, wordt je #pgv_lang[clip_cart]# volledig geleegd.<br /><br />Als je niet alle personen, families, enz. Uit de #pgv_lang[clip_cart]# wilt verwijderen, kun je kan items afzonderlijk verwijderen door op de link <b>Verwijderen</b> in de naamvakken te klikken. Er is <u>geen</u> bevestigingsvenster wanneer u op een van deze links klikt; de gevraagde verwijdering vindt onmiddellijk plaats.";
$pgv_lang["add_by_id_help"]					= "~STAMBOOMKNIPSEL TOEVOEGEN D.M.V. ID~<br /><br />In dit invoerveld kunt u het ID-nummer van een persoon invoeren, zodat hij kan worden toegevoegd aan de knipselbak. Eenmaal toegevoegd, krijgt u opties aangeboden om de relaties van die persoon te koppelen aan uw knipselbak met knipsels.<br /><br />Als u het ID-nummer van een persoon niet weet, kunt u een zoekopdracht op naam uitvoeren door op het pictogram Persoon naast de knop Toevoegen.";
$pgv_lang["zip_help"]						= "~ZIP KNIPSELS~<br /><br />Selecteer deze optie als u uw knipsels wilt opslaan in een ZIP bestand. Voor meer informatie over ZIP bestanden bezoek <a href=\"https://nl.wikipedia.org/wiki/ZIP_(bestandstype)\" target=\"_blank\">https://nl.wikipedia.org/wiki/ZIP_(bestandstype)</a>.";
$pgv_lang["include_media_help"]				= "~INCLUSIEF MEDIA~<br /><br />Selecteer deze optie om ook de mediabestanden, die zijn verbonden aan de gegevens in uw knipselbak, te downloaden.  Als u deze optie kiest, worden de bestanden automatisch ingepakt in een ZIP bestand, voordat ze kunnen worden gedownload.";
$pgv_lang["clip_cart_help"]					= "~#pgv_lang[clippings_cart]#~<br /><br />Dit vak laat de inhoud zien van uw Knipselbak.<ul><li>De <i>Soort</i> kolom geeft het soort aan van elk knipsel. Dat kunnen Personen zijn (INDI), Gezinnen (FAM), Bronnen (SOUR), Bewaarplaatsen (REPO), Notities (NOTE) en Media (OBJE);  elk wordt weergegeven d.m.v. een eigen ikoon.</li><li>De <i>ID</i> kolom toont het ID nummer van elk item.</li><li>De <i>Naam / Omschrijving</i> kolom toont de naam van een persoon of gezin, dan wel een omschrijving van het betreffende item.</li></ul>Met de Verwijder-knop kunt u het item per regel verwijderen uit de knipselbak.  <b>Er wordt NIET gevraagd om de verwijdering te bevestigen.</b>";

//-- GEDCOM Edit Utility
$pgv_lang["show_changes_help"]				= "~#pgv_lang[review_changes]#~<br /><br />Als u deze koppeling ziet, betekent dit dat:<ol><li>Iemand wijzigingen heeft aangebracht aan het GEDCOM-bestand.<br />Gegevens kunnen zijn gewijzigd, verwijderd of toegevoegd.</li><li>De wijzigingen zijn door de beheerder nog niet geaccepteerd.<br />Zodra de beheerder de wijzigingen heeft geaccepteerd of verworpen, verschijnt deze koppeling niet meer.</li></ol>Door op deze koppeling te klikken, kunt u zien welke wijzigingen zijn aangebracht. Mocht u vinden, dat een wijziging niet correct is, neem dan contact op met de beheerder.";

//-- Search-page
$pgv_lang["help_search.php"]			= "~ZOEKPAGINA~<br /><br />Hoewel deze pagina er heel eenvoudig uitziet, zit er achter de twee formulieren een zeer krachtige en gecompliceerde zoekmachine. Op de meeste genealogische websites kunt u gewoon naar een naam zoeken. Met PhpGedView kun je naar bijna alles zoeken.<br /><br />Het zoekvak aan de linkerkant van het scherm is hetzelfde als het zoekvak in elke paginakop.<br /><br />Als je mensen zoekt in verband met een bepaald jaar, typ dan gewoon het jaar in. Het programma zoekt alle aansluitingen voor je op.<br /><br />Op zoek naar een naam of plaats? Typ gewoon de naam of plaats, volledig of slechts een deel ervan, en PhpGedView doet de rest.<br /><br /><b>Soundex zoekmethode</b><br />Met de zoekvakken aan de rechterkant kunt u zoeken naar namen van personen en plaatsen, ook als u niet precies weet hoe u de naam moet schrijven.<br /><br />Als er verschillende genealogische databases op uw site zijn en de beheerder heeft ingeschakeld om tussen deze databases te wisselen, levert uw zoekopdracht de resultaten voor alle op.<br /><br />U vindt meer hulp over deze twee vakken door op de <b>#pgv_lang[qm]#</b> boven de vakken.";
$pgv_lang["search_enter_terms_help"]	= "~#pgv_lang[enter_terms]#~<br /><br />In dit zoekvak kunt u criteria invoeren zoals datums, voornamen, achternamen, plaatsen, multimedia, enz.<br /><br /><b>Jokertekens</b><br />Jokertekens, zoals u ze waarschijnlijk kent (zoals * of?), zijn niet toegestaan, maar het programma zal automatisch jokertekens aannemen.<br /><br />Stel dat u in het zoekvak het volgende typt: <b>Pete</b>. Het resultaat zou kunnen zijn, ervan uitgaande dat de namen in de database staan:<div style=\"padding-left: 30px;\"><b>Pete</b> Smith<br /><b>Pete</b>r Johnes<br />Will <b>Pete</b>rson<br />iemand - Geboren op 1 januari 1901 <b>Pete</b>rsburg<br />enz.</div><br /><b>Datums</b><br />Als u een jaar in het zoekvak typt, wordt er een lijst weergegeven met personen die op de een of andere manier met dat jaar zijn verbonden.<br /><br />Als u <b>1950</b> typt, is het resultaat alle personen met een gebeurtenis die plaatsvond in 1950. Deze gebeurtenissen kunnen geboorten, overlijden, huwelijken, bar mitswa, HLD verzegelingen, enz. zijn.<br /><br />Als u <b>4 Dec</b> typt, worden alle personen vermeld die verband houden met een evenement dat plaatsvond op 4 december van welk jaar dan ook. Ook personen die verbonden zijn aan een evenement op 14 of 24 december worden vermeld. Zoals u ziet, wordt er altijd van uitgegaan dat jokertekens zijn, dus u hoeft ze niet te typen. Soms kunnen de resultaten verrassend zijn.<br /><br /><b>Juiste datums</b><br />PhpGedView zoekt naar gegevens, zoals deze zijn opgeslagen in het GEDCOM-bestand. Als u bijvoorbeeld wilt zoeken naar een evenement op 14 december, moet u <b>14&nbsp;dec</b> typen, want zo wordt de datum in de database opgeslagen.<br /><br />Als u <b>dec&nbsp;14</b> typt, kan het resultaat een persoon zijn die is verbonden met een evenement op 08&nbsp;<b>dec</b>ember&nbsp;18<b>14</b>. Nogmaals, de resultaten kunnen verrassend zijn.<br /><br />U kunt reguliere expressies gebruiken in uw zoekopdracht als u hiermee bekend bent. Als u bijvoorbeeld alle mensen wilt vinden met datums in de 20e eeuw, kunt u de zoekopdracht <b>19[0-9][0-9]</b> invoeren en krijgt u alle mensen met data uit 1900-1999.<br /><br />#pgv_lang[soundex_search_help]#<br /><br />#pgv_lang[search_replace_help]#<br /><br />Als u meer hulp nodig heeft bij dit zoeksysteem, laat het ons dan weten, zodat we ook dit Help-bestand kunnen verbeteren.";
$pgv_lang["search_replace_help"]			= "~#pgv_lang[search_replace]#~<br /><br />Hier kunt u zoeken naar een schrijffout, of andere onjuiste informatie en deze door de juiste gegevens vervangen.<br /><br /><b>Zoeken</b><br />Deze functie zal gaan zoeken zoals een <a href=\"help_text.php?help=search_enter_terms_help\">gewone zoekopdracht</a>.<br /><br /><b>Vervangen</b><br />Alle voorkomende resultaten van de zoekopdracht zullen worden vervangen door de opgegeven vervangende tekst.<br /><br /><b>Bijvoorbeeld...</b><br />Veronderstel dat u de naam van uw grootvader Johannes verkeerd heeft geschreven. Per ongeluk heeft u 'Johannus' ingetypt.<br /><br />U vult in het Zoekvakje dan <b>Johannus</b> in. Vervolgens vult u <b>Johannes</b> in, in het Vervangen vakje.<br />Elke keer dat \"Johannus\" voorkomt, wordt deze vervangen door \"Johannes\"<br /><br /><b>Zoeken naar...</b><br />Selecteer de omvang van de zoekopdracht.  U kunt de zoekopdracht beperken tot namen of plaatsen, of geen limiet instellen (#pgv_lang[search_record]#).  De <i>#pgv_lang[search_place_word]#</i> optie zal alleen uw zoekterm gaan zoeken als een heel woord. Heeft u <i>Buinen</i> ingevuld en een vinkje gezet bij Locatie, zal alleen <b>Buinen</b> worden gevonden en niet <i>Buinen</i> in andere woorden zoals Nieuw-<b>Buinen</b>.<br /><br />Geen paniek, als per ongeluk iets wordt vervangen, wat niet de bedoeling is. Klik op de <i>#pgv_lang[accept_changes]#</i> link, onderaan de pagina, om de gewenste wijzigingen te accepteren en de ongewenste te ongedaan te maken.";
$pgv_lang["soundex_search_help"]		= "~#pgv_lang[soundex_search]#~<br /><br />Soundex is een methode om woorden te coderen op basis van hun uitspraak. Hiermee kunt u in de database zoeken naar namen en plaatsen als u niet precies weet hoe ze zijn geschreven. PhpGedView ondersteunt twee verschillende Soundex-algoritmen die enorm verschillende resultaten opleveren.<ul><li><b>#pgv_lang[search_russell]#</b><br />Deze methode, gepatenteerd in 1918 door Russell, is heel eenvoudig en kan met de hand worden uitgevoerd.<br /><br />Het eenvoudige algoritme is niet goed geschikt voor namen die oorspronkelijk in andere talen dan Engels waren, en zelfs met Engelse namen de resultaten zijn erg verrassend. Bijvoorbeeld een eenvoudige Soundex-zoekopdracht naar <b>Smith</b> levert bijvoorbeeld niet alleen <b>Smith, Smid, Smit, Schmidt, Smyth, Smithe, Smithee, Schmitt</b> op, die allemaal duidelijk variaties zijn van <b>Smith</b>, maar ook <b>Smead, Sneed, Smoote, Sammett, Shand,</b> en <b>Snoddy</b>.</li><br /><li><b>#pgv_lang[search_DM]#</b><br />Deze methode, ontwikkeld in 1985, is veel complexer dan de eenvoudige methode en is niet gemakkelijk met de hand uit te voeren.<br /><br />Een Soundex-zoekopdracht met deze methode levert veel nauwkeurigere resultaten op.</li></ul>Bezoek deze <a href=\"http://www.jewishgen.org/infofiles/soundex.html\" target=_blank><b>Jewish Genealogical Society</b></a> webpagina voor details over beide Soundex-algoritmen ";
$pgv_lang["search_exclude_tags_help"]		= "~#pgv_lang[search_tagfilter]#~<br /><br />De <b>#pgv_lang[search_tagfon]#</b> keuze zorgt ervoor dat bij de Zoek functie de volgende GEDCOM tags niet worden meegenomen:<div style=\"padding-left:30px;\"><b>_PGVU</b> - Laatste wijziging door<br /><b>CHAN</b> - Datum v.d. laatste wijziging<br /><b>FILE</b> - #factarray[FILE]#<br /><b>FORM</b> - #factarray[FORM]#<br /><b>TYPE</b> - #factarray[TYPE]#<br /><b>SUBM</b> - #factarray[SUBM]#<br /><b>REFN</b> - #factarray[REFN]#</div><br />Behalve de optie om bovenstaande tags niet in de zoekopdracht mee te nemen, worden de volgende tags altijd uitgesloten bij de Zoek functie:<div style=\"padding-left:30px;\"><b>_UID</b> - #factarray[_UID]#<br /><b>RESN</b> - #factarray[RESN]#</div>";
$pgv_lang["search_include_ASSO_help"]		= "~#pgv_lang[search_asso_label]#~<br /><br />Deze optie zorgt ervoor dat PhpGedView alle individuen toont waarvan is geregistreerd dat ze een band hebben met deze persoon of familie. Het omgekeerde is niet mogelijk.<br /><br />Voorbeeld:  Stel persoon <b>A</b> is peetvader van persoon <b>B</b>.  Deze relatie is opgeslagen in het GEDCOM bestand van persoon <b>B</b> d.m.v. van een ASSO tag.  Geen corresponderende tag bestaat in het GEDCOM bestand van persoon <b>A</b>.<br /><br />Als deze optie is aangevinkt, dus <b>#pgv_lang[yes]#</b>, en de Zoek resultaten lijst bevat <b>B</b>, dan zal <b>A</b> ook automatisch worden vermeld door de aanwezigheid van de ASSO tag in het GEDCOM bestand van <b>B</b>.<br />Maar, als de Zoek resultaten lijst <b>A</b> bevat, dan zal <b>B</b> niet automatisch in de lijst worden opgenomen, aangezien er geen corresponderende ASSO tag in het GEDCOM bestand van persoon <b>A</b> is.";

//-- Advanced Search-page
$pgv_lang["advanced_search_help"] = "~#pgv_lang[advanced_search]#~<br /><br />Met deze functie kunt u de opgegeven velden van Persoonsrecords in uw genealogische database doorzoeken.<br /><br />Wanneer u op de knop <b>#pgv_lang[search]#</b> klikt, worden alle velden waarvoor waarden zijn ingevoerd, onderzocht en worden records in uw genealogische database die aan <u>alle</u> criteria voldoen, geretourneerd. Hoewel het eerste dialoogvenster enkele van de meest voorkomende velden bevat, kunt u onderaan het dialoogvenster op <b>#pgv_lang[more_fields]#</b> klikken om de lijst met te onderzoeken velden uit te vouwen.<br /><br />~Velden met datums~<br />Geavanceerde zoekopdrachten zijn gebaseerd op jaren, dus in tegenstelling tot de «#pgv_lang[search_general]#» procedure die een datum zonder jaar kan accepteren, vereisen al deze velden ten minste het jaar, maar kunnen ze ook volledige dag-, maand- en jaarspecificaties accepteren. Het is bijvoorbeeld niet mogelijk om te zoeken naar iets dat in april van een jaar is gebeurd.<br /><br />Elk zoekdatumveldvak heeft ook een modifier, zodat u kunt zoeken naar de <b>#pgv_lang[exact]#</b> datum zoals ingevoerd, of een relatieve datum met <b>+/-</b> een aantal jaren. Als u een jaar in het datumveld typt, vervolgens een modifier kiest en vervolgens op de knop <b>#pgv_lang[search]#</b> klikt, krijgt u een lijst met personen die verbonden zijn met dat jaar of dat jaarbereik.<br /><br />Als u bijvoorbeeld «APR 1950» typt in het geboortedatumveld met de modifier <b>#pgv_lang[exact]#</b>, dan is het resultaat alle personen met een gebeurtenis die alleen in april 1950 heeft plaatsgevonden. Elk datumveld zoekt naar de datums die specifiek zijn voor die gebeurtenis. Door een modifier <b>+/- 10</b> toe te voegen, worden datums tussen 1 april 1940 en 31 maart 1960 geretourneerd. De andere modifiers wijzigen op vergelijkbare wijze de zoekjaarbereiken. Door alleen een jaar in te voeren, bijvoorbeeld «1950», retourneert de zoekopdracht alle gebeurtenissen binnen het opgegeven jaar.<br /><br /><b>Datumnotatie voor zoekopdrachten</b><br />Jokers en reguliere expressies kunnen niet worden gebruikt in uw zoekdatumvelden. De volgorde van dag, maand, jaar en hoofdlettergebruik zijn irrelevant. «dd MMM jjjj» heeft dezelfde betekenis als «jjjj MMM dd». Als u echter wilt zoeken naar een gebeurtenis op 14 december 1926, moet u het typen als «14 DEC 1926», omdat de datum op deze manier in de database wordt opgeslagen. Om te zoeken naar een datum in meerdere gebeurtenissen (bijv. geboorten, overlijdens, huwelijken, Bar Mitzvahs, LDS-verzegelingen, enz.) of als alleen de dag of maand bekend zijn, kunt u beter de functie «#pgv_lang[search_general]#» gebruiken.<br /><br />~Velden met namen~<br />De velden <b>#pgv_lang[given_name]#</b> en <b>#pgv_lang[surname]#</b> kunnen worden gebruikt om de verschillende delen van een naam te specificeren die moeten worden doorzocht. Dit filtert eenvoudig namen die zowel voornamen als achternamen kunnen zijn, bijvoorbeeld «Terry» of «Henry».<br /><br />De namenvelden hebben ook een modifier die helpt bij het kwalificeren van wat er wordt ingevoerd versus waarnaar wordt gezocht. De modifiers omvatten:<ul><li><b>#pgv_lang[exact]#</b>&nbsp;&nbsp;specificeert een hoofdlettergevoelige zoekopdracht van het volledige veld voor de exacte ingevoerde tekst. De zoekopdracht is ook gevoelig voor alle ingesloten tekens, spaties, enz. Als het veld bijvoorbeeld één spatie bevat, maar de record in de database er twee op dezelfde positie heeft, wordt de record niet gevonden.</li><li><b>#pgv_lang[begins_with]#</b>&nbsp;&nbsp;specificeert een hoofdletterongevoelige zoekopdracht voor records waarbij een naam begint met wat er in het veld staat. Als een naamveld meerdere namen bevat (zoals voor- en tweede namen), wordt de match gedaan met het begin van elk deel van de naam dat wordt gescheiden door een spatie.</li><li><b>#pgv_lang[contains]#</b>&nbsp;&nbsp;specificeert een hoofdletterongevoelige zoekopdracht voor records waarbij de volledige ingevoerde gegevens in het veld overal in de naamtekst van de doelrecord worden doorzocht. Als u bijvoorbeeld één spatie in het zoekveld <b>#pgv_lang[given_name]#</b> plaatst met de modifier <b>#pgv_lang[contains]#</b>, worden alle records gevonden die een voornaam en ten minste één tweede naam of initiaal moeten hebben.</li><li><b>#pgv_lang[sounds_like]#</b>&nbsp;&nbsp;specificeert een hoofdletterongevoelige zoekopdracht voor records die lijken op wat er in het veld staat. Hiermee kunt u de database doorzoeken op namen en plaatsen als u niet precies weet hoe ze zijn geschreven.</li></ul><br />~Velden zonder modificatoren~<br />Invoer in velden zonder modifiers zijn hoofdlettergevoelige zoekopdrachten. De ingevoerde tekst wordt overal in de gebeurtenistekst van het doelrecord doorzocht.";

//-- Individual Information-page
$pgv_lang["help_individual.php"]		= "~#pgv_lang[indi_info]# pagina~<br /><br />Alle details van een persoon worden op deze pagina getoond. <br /> <br /> Als er een foto beschikbaar is, zie je deze linksboven. Je ziet de namen van de persoon naast de foto. <br /> <br /> Aan namen kunnen notities en bronnen zijn toegevoegd. Als een van de namen aantekeningen of bronnen heeft, ziet u ze vermeld onder de namen waar ze betrekking op hebben.<br /><br />Een persoon kan een AKA hebben (misschien staat hij bekend onder een andere naam). Als dat het geval is, wordt het weergegeven.<br /><br />Als u bewerkingsrechten voor deze persoon heeft, ziet u ook de links <b>Bewerken</b> en <b>Verwijderen</b> naast de items die u kunt bewerken.<br /><br />Op deze pagina zie je tabbladen voor <b>#pgv_lang[personal_facts]#</b>, <b>#pgv_lang[notes]#</b>, <b>#pgv_lang[ssourcess]#</b>, <b>#pgv_lang[media]#</b>, en <b>#pgv_lang[relatives]#</b>. Deze tabbladen tonen u alle informatie over deze persoon die in de database is opgeslagen.<ul><li><b>#pgv_lang[personal_facts]#</b>&nbsp;&nbsp;&nbsp;zal u de feiten en details over deze persoon en elk feit uit hun huwelijk laten zien. Als u op een datum op dit tabblad klikt, gaat u naar de #pgv_lang[anniversary_calendar]# voor die datum, zodat u andere gebeurtenissen kunt zien die op dezelfde dag hebben plaatsgevonden. Als u op een plaats klikt, gaat u naar de plaatshiërarchie waar u andere mensen kunt zien die gebeurtenissen op dezelfde plaats hebben gehad. Voor huwelijks- en andere familiegerelateerde feiten is de naam van de echtgenoot van de persoon beschikbaar, zodat u de echtgenoot kunt zien en er wordt ook een link naar het gezinsregister verstrekt.</li><li><b>#pgv_lang[notes]#</b>&nbsp;&nbsp;&nbsp;zal u alle algemene opmerkingen over deze persoon laten zien.</li><li><b>#pgv_lang[ssourcess]#</b>&nbsp;&nbsp;&nbsp;zal je alle <u>algemene</u> bronnen voor deze persoon laten zien. Deze bronnen zijn <u>niet</u> gekoppeld aan individuele feiten, zelfs niet de naam van de persoon; ze zijn geassocieerd met de persoon zelf. Als u op de titel van een bron klikt, gaat u naar een meer gedetailleerde pagina met broninformatie waarop andere mensen worden weergegeven die ook aan dezelfde bron zijn gekoppeld.</li><li><b>#pgv_lang[media]#</b>&nbsp;&nbsp;&nbsp;geeft een lijst van alle afbeeldingen en andere media-items die aan deze persoon zijn toegevoegd. Als u op een miniatuur van de afbeelding klikt, wordt een grotere weergave van de afbeelding geopend. Als u op het bijschrift van de afbeelding klikt, wordt de afbeelding op de pagina #pgv_lang[media_list]# weergegeven.  </li><li><b>#pgv_lang[relatives]#</b>&nbsp;&nbsp;&nbsp;vermeldt de ouders en broers en zussen van deze persoon, evenals alle echtgenoten en kinderen die deze persoon heeft gehad. Deze personen worden in vakken weergegeven die lijken op de kaarten die u misschien al hebt gezien.</li></ul>Aan de rechterkant van het scherm vind je een box met links. Veel van de links in het vak zijn hetzelfde als de links in de menu's. Als u bijvoorbeeld op de link <b>#pgv_lang[pedigree_chart]#</b> aan de zijlinks klikt, gaat u naar de stamboomlijst voor deze persoon. Dit is anders dan de menulinks, omdat door op de <b>#pgv_lang[pedigree_chart]#</b> link in het menu te klikken, u teruggaat naar de standaard stamboomlijst voor deze database.<br /><br />Een van de links die in deze lijst kan verschijnen als deze is ingeschakeld door de beheerder, is de link <b>#pgv_lang[view_gedcom]#</b>. Deze link toont u het ruwe GEDCOM-record van deze persoon.<br /><br />Als #pgv_lang[clip_cart]# is ingeschakeld door de sitebeheerder, heb je ook een link waarmee je deze persoon kunt toevoegen aan je #pgv_lang[clip_cart]#.<br /><br />De <b>#pgv_lang[relationship_to_me]#</b> link zal alleen verschijnen als je ingelogd bent en een ID toegewezen hebt gekregen in de GEDCOM. Deze link brengt u naar de stamboomlijst en laat zien hoe u verwant bent met deze persoon.<br /><br />#pgv_lang[context_help]#";
$pgv_lang["delete_person_help"]			= "~#pgv_lang[delete_person]#~<br /><br />Wanneer u op deze optie klikt, markeert u deze persoon om uit de database te worden verwijderd.<br /><br />Wat betekent dat? Stel dat u een goede reden heeft om deze persoon uit de database te verwijderen. U klikt op de link. U wordt gevraagd om uw verwijderingsverzoek te bevestigen. Wanneer u doorgaat met uw bezoek, zult u merken dat de persoon nog steeds zichtbaar is en kan worden gebruikt alsof de verwijdering niet had plaatsgevonden.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["delete_name_help"]			= "~WIJZIG NAAM of VERWIJDER NAAM~<br /><br /><b>WIJZIG NAAM</b><br />Als u op deze link klikt, wordt een ander venster geopend. Daar kunt u de naam van de persoon bewerken. Typ gewoon de wijzigingen in de vakken, klik op de knop en sluit het venster.<br /><br /><b>VERWIJDER NAAM</b><br />Door op deze optie te klikken, markeert u deze naam om uit de database te worden verwijderd. Merk op dat het verwijderen van de naam totaal anders is dan het verwijderen van de persoon. Als u de naam verwijdert, wordt alleen de naam van de persoon verwijderd. De persoon wordt <u>niet</u> verwijderd. Als het een AKA is die u wilt verwijderen, heeft de persoon nog steeds zijn andere namen. Als het de <u>enige</u> naam is die u wilt verwijderen, wordt de persoon nog steeds niet verwijderd, maar wordt deze nu geregistreerd als <b>#pgv_lang[NN]#</b>. De persoon zal ook niet worden losgekoppeld van andere familieleden, bronnen, notities, enz.<br /><br />Hoe werkt het? U wordt gevraagd om uw verwijderingsverzoek te bevestigen. Wanneer u doorgaat met uw bezoek, zult u merken dat de naam nog steeds zichtbaar is en kan worden gebruikt alsof de verwijdering niet heeft plaatsgevonden.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["add_name_help"]					= "~NAAM TOEVOEGEN~<br /><br />Hiermee kunt u extra namen toevoegen aan deze persoon. Als een persoon onder meerdere namen bekend is of bijnamen had, kunt u deze toevoegen zonder de oude naamsgegevens te wijzigen.";
$pgv_lang["add_sibling_help"]				= "~#pgv_lang[add_sibling]#~<br /><br />Met deze functie kunt u een nieuw persoon als broer of zus toevoegen aan dit gezin. \"Dit gezin\" is in dit geval de vader en moeder van de hoofdpersoon van dit scherm.<br /><br />Houd er rekening mee dat u een broer of zus van die persoon gaat toevoegen. Een broer of zus toevoegen is eenvoudig: klik op de link, vul de vakjes in het pop-upscherm in en dat is alles. <br /> <br /> Als je een zoon of dochter van de hoofdpersoon moet toevoegen, scroll dan naar beneden een beetje en klik op de link in \"#pgv_lang[as_spouse]#\".";
$pgv_lang["add_son_daughter_help"]		= "~#pgv_lang[add_son_daughter]#~<br /><br />U kunt een kind aan dit gezin toevoegen door op deze link te klikken. \"Dit gezin\" is in dit geval de hoofdpersoon van dit scherm en zijn of haar echtgenoot.<br /><br />Houd er rekening mee dat u een zoon of dochter van die persoon gaat toevoegen. Een zoon of dochter toevoegen is eenvoudig: klik op de link en vul de vakjes in het nieuwe scherm in.<br /><br />Als je een broer of zus van de hoofdpersoon moet toevoegen, scroll dan een beetje naar boven en klik op de link in \"#pgv_lang[as_child]#\".";
$pgv_lang["link_child_help"]				= "~#pgv_lang[link_as_child]#~<br /><br />Met deze functie kunt u de persoon aan een reeds bestaand gezin toevoegen, als kind.<br /><br />Dit kan voorkomen, als tot op heden de ouders van de persoon onbekend waren, en u nu ontdekt heeft, dat deze in uw bestand reeds voorkwamen.<br /><br />Als u op de koppeling klikt, verschijnt een scherm waarin u de ID van het desbetreffende gezin dient op te geven. Met de zoekfunctie kunt u deze gemakkelijk selecteren.";
$pgv_lang["link_husband_help"]			= "~#pgv_lang[link_as_husband]#~<br /><br />Met dit item kunt u de huidige persoon als echtgenoot koppelen aan een gezin dat al in de database staat. Door op deze link te klikken kunt u deze persoon toevoegen aan een bestaand gezin, waarvan de echtgenoot tot nu toe onbekend was. Deze persoon neemt de plaats in van de voorheen onbekende echtgenoot. Alle evenementen, huwelijksinformatie en kinderen behouden hun bestaande banden met het gezin.<br /><br />Klik gewoon op de link, voer de ID van de familie in en je hebt aan de taak deelgenomen. Dit is een geavanceerde bewerkingsoptie die alleen moet worden gebruikt als de familie waarnaar u wilt linken al bestaat. Als je een <u>nieuwe</u> familie aan deze persoon wilt toevoegen, gebruik dan de <b>#pgv_lang[add_new_wife]#</b> link.";
$pgv_lang["add_husband_help"]				= "~#pgv_lang[add_new_husb]#~<br /><br />Hiermee kunt u een nieuwe persoon toevoegen als partner voor de persoon bovenaan het scherm. U vormt hierdoor een nieuw gezin<br /><br />Als u op de koppeling heeft geklikt, krijgt u een nieuw scherm, waarop u zoveel mogelijk gegevens van de persoon dient in te vullen. ";
$pgv_lang["link_new_husb_help"]				= "~#pgv_lang[link_new_husb]#~<br /><br />Dit stelt u in staat om een bestaand persoon (in dit bestand) aan deze persoon toe te voegen als partner. Hierdoor ontstaat  een nieuwe familie met de, door u geselecteerde partner. Eveneens heeft u de optie om een huwelijk voor deze nieuwe familie te specificeren.";
$pgv_lang["add_opf_child_help"]				= "~#pgv_lang[add_opf_child]#~<br /><br /> Hier kunt u een <u>nieuw</u> kind aan deze persoon toevoegen. U maakt dan een 1-ouder gezin.<br /><br />Door op deze link te klikken krijgt u een pop-up window om de nieuwe persoon toe te voegen.  Vul zo veel mogelijk vakjes in en klik op de <b>Opslaan</b> knop.";
$pgv_lang["link_wife_help"]				= "~#pgv_lang[link_as_wife]#~<br /><br />Met dit item kunt u de huidige persoon als echtgenote koppelen aan een gezin dat al in de database staat.<br /><br />Dit is een geavanceerde bewerkingsoptie die alleen mag worden gebruikt als het gezin waarnaar u wilt linken bestaat al. Als je een <u>nieuwe</u> familie aan deze persoon wilt toevoegen, gebruik dan de <b>#pgv_lang[add_new_husb]#</b> link.";
$pgv_lang["add_wife_help"]				= "~#pgv_lang[add_new_wife]#~<br /><br />Door op deze link te klikken, kunt u een <u>nieuwe</u> vrouwelijke persoon toevoegen en deze persoon aan de hoofdpersoon koppelen als een nieuwe echtgenote.<br /><br />Klik gewoon op de link en u krijgt een nieuw venster om de nieuwe persoon toe te voegen. Vul zoveel mogelijk vakjes in en klik op de knop <b>Opslaan</b>.";
$pgv_lang["link_new_wife_help"]				= "~#pgv_lang[link_new_wife]#~<br /><br />Dit stelt u in staat om een bestaand persoon (in dit bestand) aan deze persoon toe te voegen als partner. Hierdoor ontstaat  een nieuwe familie met de, door u geselecteerde partner. Eveneens heeft u de optie om een huwelijk voor deze nieuwe familie te specificeren.";
$pgv_lang["add_new_parent_help"]			= "#pgv_lang[multiple_help]#<br />~VADER OF MOEDER TOEVOEGEN~<br /><br />Er zijn zeker veel personen in de GEDCOM zonder een record van een vader of moeder.<br /><br />In dat geval, op de <b>#pgv_lang[indi_info]#</b> pagina, tabblad <b>#pgv_lang[relatives]#</b>, tabel <b>#pgv_lang[as_child]#</b>, vindt u links om een <u>nieuwe</u> vader of moeder aan de persoon toe te voegen.<br /><br />Houd er rekening mee dat deze links bedoeld zijn voor het toevoegen van een <u>nieuwe</u> vader of moeder. Als de vader of moeder al een record in deze database heeft, moet u de link <b>#pgv_lang[link_as_child]#</b> gebruiken, die u op die <b>#pgv_lang[indi_info]#</b> pagina onder de laatste tabel.";
$pgv_lang["show_fact_sources_help"]			= "~#pgv_lang[show_fact_sources]#~<br />~#pgv_lang[show_fact_notes]#~<br /><br />Als deze optie is aangevinkt, kunt u alle Bronnen en Notities vermeldingen voor deze persoon zien. Indien niet aangevinkt, zullen Bronnen en Notities vermeldingen, die zijn verbonden met andere feiten voor deze persoon niet worden getoond.";
$pgv_lang["age_differences_help"]			= "~#pgv_lang[age_differences]#~<br /><br />Als deze check-box is aangevinkt, zal de «#pgv_lang[relatives]#» tab de datumverschillen als volgt tonen:<ul><li><b>Geboortedatums van  partners:</b><br />Een negatieve waarde geeft aan dat de tweede partner ouder is dan de eerste.</li><li><b>Huwelijksdatum en geboortedatum van eerste kind:</b><br />Een negatieve waarde geeft aan dat het kind was geboren voor de huwelijksdatum. Het kan dan echter ook mogelijk zijn dat de huwelijksdatum of de geboortedatum onjuist is.</li><li><b>Geboortedatums van broers/zusters:</b><br />Een negatieve waarde geeft aan dat de volgorde van de kinderen verkeerd is, of dat een geboortedatum onjuist is.</li></ul>";

//-- Add Facts
$pgv_lang["add_facts_help"]					= "~NIEUWE FEITEN TOEVOEGEN~<br /><br />Hier kunt u een feit toevoegen aan het record dat wordt bewerkt.<br /><br />Kies eerst een feit uit de lijst en klik vervolgens op de knop <b>Toevoegen</b>. Alle mogelijke feiten die u aan de database kunt toevoegen, staan in die lijst.";
$pgv_lang["add_custom_facts_help"]			= "~SPECIAAL FEIT TOEVOEGEN~<br /><br />Als u het feit dat u wilt toevoegen niet kunt vinden in de lijst met GEDCOM-feiten, kunt u ook een <b>aangepast feit</b> invoeren.<br /><br />Een aangepast feit invoeren is gewoon zo simpel als het invoeren van een van de vooraf gedefinieerde instellingen. Het enige verschil is dat u het feit een naam moet geven in plaats van de naam uit een lijst te kiezen. U moet dit doen in het bovenste veld: <b>#pgv_lang[type]#</b>";
$pgv_lang["add_note_help"]					= "#pgv_lang[multiple_help]#<br />~VOEG NOTITIE TOE~<br /><br />Hiermee kunt u een notitie toevoegen aan de persoon.<br /><br />Als u op de knop klikt, verschijnt een venster waarin u de tekst van de notitie kunt intypen.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_shared_note_help"]			= "#pgv_lang[multiple_help]#<br />~#pgv_lang[add_shared_note_lbl]#~<br /><br />Als u op de <b>#pgv_lang[add_shared_note]#</b> link klikt, zal een nieuw venster worden geopend.  U kunt er voor kiezen om te linken aan een bestaande Gedeelde Notitie, of u kunt een nieuwe Gedeelde Notitie maken en op dat moment er een link aan verbinden.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_source_help"]				= "#pgv_lang[multiple_help]#<br />~VOEG BRONVERMELDING TOE~<br /><br />Hier kunt u een <b> bronvermelding </b> aan dit record toevoegen.<br /><br />Klik gewoon op de link, een venster wordt geopend en u kunt de bron kiezen uit de lijst (Zoek ID) of maak een nieuwe bron aan en voeg vervolgens de bronvermelding toe.<br /><br />Het toevoegen van bronnen is een belangrijk onderdeel van genealogie omdat het andere onderzoekers in staat stelt te verifiëren waar u uw informatie hebt verkregen.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"]				= "~#pgv_lang[add_media]#~<br /><br />Het toevoegen van multimediabestanden (MM) aan de GEDCOM is een erg leuke functie. Hoewel dit programma al een geweldige uitstraling heeft zonder media, wordt het alleen maar beter als je foto's of andere MM toevoegt aan je familieleden.<br /><br /><b>Wat u moet weten over MM.</b><br />Er zijn veel formaten MM. Hoewel PhpGedView de meeste van hen aankan, zijn er enkele dingen die u moet overwegen.<br /><ul><li><b>Formaten</b><br />Afbeeldingen kunnen in veel formaten worden bewerkt en opgeslagen. Bijvoorbeeld .jpg, .png, .bmp, .gif, enz. Als dezelfde originele afbeelding werd gebruikt om elk van de formaten te maken, zal de bekeken afbeelding dezelfde grootte lijken te hebben, ongeacht het formaat dat wordt gebruikt. De afbeeldingsbestanden die in de database zijn opgeslagen, zullen echter aanzienlijk in grootte variëren. Over het algemeen worden .jpg-afbeeldingen beschouwd als de meest efficiënte in termen van opslagruimte.</li><li><b>Afbeeldingsgrootte</b><br />Hoe groter de originele afbeelding, hoe groter de grootte van het resulterende bestand. De afbeelding moet op het scherm passen zonder te scrollen; de maximale breedte of hoogte mag niet meer zijn dan de breedte of hoogte van het scherm. PhpGedView is ontworpen voor schermen van 1024x768 pixels, maar niet al deze ruimte is beschikbaar voor het bekijken van afbeeldingen; de grootte van de afbeelding moet dienovereenkomstig worden ingesteld. Om de bestandsgrootte te verkleinen, zijn kleinere afbeeldingen wenselijker.</li><li><b>Resolutie</b><br />De resolutie van een foto wordt meestal gemeten in \"dpi\" (dots / inch), maar dit geldt alleen voor afgedrukte foto's. Bij het beschouwen van afbeeldingen die op het scherm worden weergegeven, is de enige juiste manier om het totale aantal punten of pixels te gebruiken. Bij het afdrukken kan de afbeelding een resolutie hebben van 150 - 300 dpi of meer, afhankelijk van de printer. Schermresoluties zijn zelden beter dan 50 pixels per inch. Als uw foto nooit zal worden afgedrukt, kunt u de resolutie (en dus de bestandsgrootte) veilig verlagen zonder de fotokwaliteit te beïnvloeden. Als een foto met een lage resolutie wordt afgedrukt met een te sterke vergroting, zal de kwaliteit eronder lijden; het ziet er korrelig uit.</li><li><b>Kleuren diepte</b><br />Een andere manier om een bestand klein te houden, is door het aantal kleuren dat u gebruikt te verminderen. Het aantal kleuren kan verschillen van puur zwart en wit (twee kleuren) tot ware kleuren (miljoenen kleuren) en alles daartussenin. Je kunt zien dat hoe meer kleuren er worden gebruikt, hoe groter de grootte van de bestanden.</li></ul><br /><b>Waarom is het belangrijk om de bestandsgrootte klein te houden?</b><ul><li>Allereerst: uw webruimte is beperkt. Hoe meer grote bestanden er zijn, hoe meer webruimte we nodig hebben op de server. Hoe meer ruimte we nodig hebben, hoe hoger uw kosten.</li><li>Bandbreedte. Hoe meer gegevens onze server naar de externe locatie (uw locatie) moet sturen, hoe meer we moeten betalen. Dit komt doordat de draagcapaciteit van de verbinding van de server met internet beperkt is en de link gedeeld (en betaald) moet worden door alle applicaties die op de server draaien. PhpGedView is een van de vele applicaties die de server delen. De kosten worden normaal gesproken verdeeld op basis van de hoeveelheid gegevens die elke applicatie verzendt en ontvangt.</li><li>Downloadtijd. Als u grote bestanden heeft, zal de gebruiker (ook u) lang moeten wachten totdat de pagina van de server is gedownload. Niet iedereen is gezegend met een kabelverbinding, breedband of DSL.</li></ul><br /><b>Hoe te uploaden uw MM</b><br />Er zijn twee manieren om media naar de site te uploaden. Als u veel media-items wilt uploaden, dient u contact op te nemen met de sitebeheerder om de beste manieren te bespreken. Als het door uw sitebeheerder is ingeschakeld, kunt u het formulier Media uploaden onder uw menu #pgv_lang[mgv]# gebruiken. U kunt ook de optie Uploaden op het Multimedia-formulier gebruiken om media-items te uploaden.";
$pgv_lang["gen_missing_thumbs_help"]		= "~#pgv_lang[gen_missing_thumbs]#~<br /><br />Deze  optie zal miniweergaves genereren van alle afbeeldingen, in de huidige map, die nog geen miniweergave hebben.  Dit is een stuk gemakkelijker dan, elke keer, op de <b>#pgv_lang[gen_thumb]#</b> link te klikken voor zo'n bestand.<br /><br />Als u controle wilt blijven uitoefenen over welke bestanden wel, of geen, miniweergave moeten hebben, kunt u deze optie beter niet gebruiken.  Gebruik dan de toepasselijke <b>#pgv_lang[gen_thumb]#</b> links.";
$pgv_lang["add_facts_general_help"]      = "~Algemene info over toevoegen~<br /><br />Als u een feit, opmerking, bron of multimediabestand aan een record in de database heeft toegevoegd, moet de toevoeging nog worden goedgekeurd door een gebruiker met Accept-rechten.<br /><br />Totdat de wijzigingen zijn geaccepteerd, worden ze aangeduid als \"in behandeling\" door een verschillend gekleurde rand. Alle gebruikers met bewerkingsrechten kunnen deze wijzigingen zien, evenals de originele informatie. Gebruikers die geen bewerkingsrechten hebben, zien alleen de originele informatie. Wanneer de toevoeging is geaccepteerd, verdwijnen de randen en worden de nieuwe gegevens normaal weergegeven, waarbij de oude worden vervangen. Op dat moment zullen gebruikers zonder bewerkingsrechten ook de nieuwe gegevens zien.";

//-- Edit user
$pgv_lang["edituser_my_account_help"]		= "Op deze pagina kunt u uw instellingen en voorkeuren aanpassen.<br /><br />U kunt uw gebruikersnaam, wachtwoord, voorkeurstaal en e-mailadres aanpassen, alsmede de site-opmaak (thema) en de gewenste verzendwijze van berichten.<br /><br />Uw ID in de genealogie geeft aan, aan welke persoon u in de genealogie bent gekoppeld en wordt gebruikt voor beveiligingsdoeleinden. Om deze reden kunt u de instelling niet aanpassen.";
$pgv_lang["edituser_username_help"]			= "~#pgv_lang[username]#~In dit vak kunt u uw gebruikersnaam wijzigen. Als u uw gebruikersnaam niet meer leuk vindt of als u andere redenen heeft om deze te wijzigen, kunt u dit doen met behulp van dit formulier.<br /><br />De gebruikersnaam is <u>hoofdlettergevoelig</u>. Dat betekent dat <b>Piet</b> niet hetzelfde is als <b>piet</b> of <b>PIET</b>.<br /><br />Je moet <u>alleen</u> gebruik tekens uit de alfabetten die PhpGedView ondersteunt. U mag hoofdletters en kleine letters gebruiken met of zonder diakritische tekens, cijfers, streepje (-) en onderstrepingsteken (_). Gebruik <u>geen</u> leestekens of spaties.";
$pgv_lang["edituser_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />In dit vakje kunt u uw voornaam wijzigen.  Dit is de naam die andere (ingelogde) gebruikers zien, als u bent ingelogd.<br /><br />Howel het uw eigen keuze is, wat u in dit vakje invult, zou u de beheerder moeten informeren als u het wijzigt.  Als anderen een onbekende persoon on-line zien, kunnen ze zich afvragen wie het is en gaan informeren. De beheerder kan het natuurlijk ook zelf uitzoeken, als u geen bericht geeft, maar u zou hem dat onnodige werk kunnen besparen.";
$pgv_lang["edituser_lastname_help"]			= "~#pgv_lang[lastname]#~<br /><br />In dit vakje kunt u uw achternaam wijzigen.  Dit is de naam die andere (ingelogde) gebruikers zien, als u bent ingelogd.<br /><br />Howel het uw eigen keuze is, wat u in dit vakje invult, zou u de beheerder moeten informeren als u het wijzigt.  Als anderen een onbekende persoon on-line zien, kunnen ze zich afvragen wie het is en gaan informeren.  De beheerder kan het natuurlijk ook zelf uitzoeken, als u geen bericht geeft, maar u zou hem dat onnodige werk kunnen besparen.";
$pgv_lang["edituser_gedcomid_help"]			= "~#pgv_lang[gedcomid]#~<br /><br />Dit koppelt u aan een persoon in de genealogie en wordt ondermeer gebruikt voor beveiligingsdoeleinden.<br /><br />U kunt deze waarde niet veranderen, omdat hij is ingesteld door de beheerder. Als u denkt dat u aan de verkeerde persoon in de genealogie bent gekoppeld, neemt u dan contact op met de beheerder.";
$pgv_lang["edituser_rootid_help"]			= "~#pgv_lang[rootid]#~<br /><br />Dit is de startpersoon (wortel) van al je grafieken.<br /><br />Als je bijvoorbeeld op de link naar de stamboom zou klikken, zou je deze root-persoon in het meest linkse vak zien. Deze wortelpersoon hoeft u niet te zijn; je kunt met elke persoon beginnen (bijvoorbeeld je grootvader of de tante van je moeder), zolang je de rechten hebt om die persoon te zien.<br /><br />Deze optie verandert de standaard startpersoon voor de meeste grafieken. U kunt de startpersoon wijzigen die feitelijk in veel grafieken wordt gebruikt, maar dat is alleen voor die pagina op dat specifieke moment.";
$pgv_lang["edituser_password_help"]			= "~#pgv_lang[password]#~<br /><br />Het is een goede gewoonte om uw wachtwoord regelmatig te wijzigen. Houd er rekening mee dat iedereen die uw gebruikersnaam en wachtwoord kent, toegang heeft tot uw gegevens.<br /><br />Zorg ervoor dat het wachtwoord minimaal 6 tekens lang is, hoe langer hoe beter. U mag hoofdletters en kleine letters gebruiken met of zonder diakritische tekens, cijfers, streepje (-) en onderstrepingsteken (_). Gebruik <u>geen</u> leestekens of spaties. Gebruik een combinatie van hoofdletters en kleine letters, cijfers en andere tekens. Bijvoorbeeld: b>5Z_q\$P4=r9</b>.<br /><br />Net als de gebruikersnaam is het wachtwoord <u>hoofdlettergevoelig</u>. Dat betekent dat <b>Geheim.Wachtwoord!#13</b> niet hetzelfde is als <b>geheim.wachtwoord!#13</b> of <b>GEHEIM.WACHTWOORD!#13</b>.";
$pgv_lang["edituser_conf_password_help"]	= "~#pgv_lang[confirm]#~<br /><br />Als u uw wachtwoord heeft gewijzigd, moet u dit ook bevestigen. Dit is alleen om er zeker van te zijn dat u geen typefout heeft gemaakt in het wachtwoordveld.<br /><br />Als het wachtwoord en de bevestiging ervan niet identiek zijn, krijgt u een passende foutmelding. U moet zowel het originele wachtwoord als de bevestiging ervan opnieuw typen.";
$pgv_lang["edituser_change_lang_help"]		= "~#pgv_lang[change_lang]#~<br /><br />Hier kunt u de taal wijzigen waarin PhpGedview al zijn pagina's en berichten weergeeft nadat u zich hebt aangemeld.<br /><br />Wanneer u de site voor het eerst bezoekt, gaat PhpGedView ervan uit dat u alles wilt zien in de taal die is geconfigureerd als de voorkeurstaal in uw browser. Als die aanname onjuist is, zou u deze hier negeren. Uw browser kan bijvoorbeeld zijn ingesteld op Engels, omdat dat de meest voorkomende taal op internet is. Voor genealogische doeleinden wilt u echter alles in het Fins of Hebreeuws zien. Hier doe je dat.<br /><br />De beheerder bepaalt welke taalkeuzes voor u beschikbaar zijn. Staat uw voorkeur er niet tussen, neem dan contact op met de beheerder.<br /><br />Onthoud dat PhpGedView in feite een project is dat wordt bemand door een internationaal team van onbetaalde vrijwilligers. Deskundigen komen en gaan. Daarom is ondersteuning voor andere talen dan Engels soms niet zo goed als zou moeten.<br /><br />Als u iets ziet dat niet is vertaald, verkeerd is vertaald of beter kan worden geformuleerd, laat het uw beheerder weten. De beheerder weet hoe hij contact kan opnemen met het PhpGedView-ontwikkelteam om uw zorgen weg te nemen. Sterker nog, doe wat van uw tijd als vrijwilliger. We kunnen de hulp gebruiken.";
$pgv_lang["edituser_email_help"]			= "~#pgv_lang[emailadress]#~<br /><br />Uw juiste e-mailadres is belangrijk voor ons om contact met u te kunnen houden.<br /><br />Als u een nieuw e-mailadres krijgt, zoals gewoonlijk gebeurt wanneer u van internetprovider verandert, vergeet dan niet het adres hier te wijzigen ook. U krijgt geen bevestigingsbericht van deze site wanneer u dit adres wijzigt, maar toekomstige berichten die naar u worden gericht, gaan naar dit nieuwe adres.";
$pgv_lang["edituser_user_theme_help"]		= "~#pgv_lang[user_theme]#~<br /><br />Deze site kan verschillende looks of verschijningsvormen hebben. Andere programma's noemen ze misschien \"skins\", maar hier zijn het \"thema's\".<br /><br />Elk thema geeft dezelfde gegevens weer, maar de presentatie of zelfs de locatie op het scherm kan variëren. Dit is hetzelfde als een foto in een andere lijst plaatsen en deze ook in een andere kamer ophangen. Het beeld verandert niet, maar de manier waarop je ernaar kijkt is totaal anders.<br /><br />Probeer het gewoon eens. Stel het in op een ander thema. Kijk ernaar, probeer een andere. Ga terug naar degene die het beste bij u past. Elke keer dat u inlogt, ziet u het thema dat u het laatst hebt gebruikt; u hoeft niet eens naar deze configuratiepagina te gaan om uw voorkeursthema te wijzigen.";
$pgv_lang["edituser_contact_meth_help"]		= "~#pgv_lang[user_contact_method]#~<br /><br />PhpGedView heeft verschillende contactmethoden. De beheerder bepaalt via welke methode contact met hem wordt opgenomen. U heeft de controle over de methode die moet worden gebruikt om contact met <u>u</u> op te nemen. Afhankelijk van de siteconfiguratie zijn sommige van de vermelde methoden mogelijk niet voor u beschikbaar.";
$pgv_lang["mail_option1_help"]				= "Met deze optie wordt het interne berichtensysteem van PhpGedView gebruikt en worden er geen e-mails verzonden.<br /><br />U ontvangt alleen <u>interne</u> berichten van de andere gebruikers. Wanneer een andere sitegebruiker je een bericht stuurt, zal dat bericht verschijnen in het berichtenblok op je persoonlijke #pgv_lang[mygedview]# pagina. Als je deze blokkering van je #pgv_lang[mygedview]# pagina hebt verwijderd, zul je geen berichten zien. Ze zullen echter verschijnen zodra je de #pgv_lang[mygedview]# pagina configureert om opnieuw het berichtenblok te hebben.";
$pgv_lang["mail_option2_help"]				= "Deze optie is vergelijkbaar met #pgv_lang[messaging]#, met één toevoeging. Als extraatje wordt er ook een kopie van het bericht verzonden naar het e-mailadres dat u op uw accountpagina heeft geconfigureerd.<br /><br />Dit is de standaard contactmethode.";
$pgv_lang["mail_option3_help"]				= "Met deze optie ontvang je alleen e-mailberichten op het adres dat je op je accountpagina hebt geconfigureerd. Het interne berichtensysteem van PhpGedView zal helemaal niet worden gebruikt en er zullen nooit berichten in het berichtenblok op uw persoonlijke #pgv_lang[mygedview]# pagina staan.";
$pgv_lang["mail_option4_help"]				= "Met deze optie ontvang je geen berichten. Zelfs de beheerder kan u niet bereiken.";

//-- Admin
$pgv_lang["admin_help"]						= "Op deze pagina vindt u links naar de configuratiepagina's, administratiepagina's, documentatie en logbestanden.<br /><br /><b>#pgv_lang[system_time]#</b>, net onder de paginatitel, toont de tijd van de server waarop uw site wordt gehost. Dit betekent dat als de server zich in New York bevindt terwijl je in Nederland bent, de weergegeven tijd zes uur korter zal zijn dan je lokale tijd, tenzij de server natuurlijk op Greenwich Mean Time (GMT) draait. De weergegeven tijd is de servertijd waarop u deze pagina opende of vernieuwde.<br /><br /><b>WAARSCHUWING</b><br />Als je een rood waarschuwingsbericht onder de systeemtijd ziet, betekent dit dat je <i>config.php</i> nog steeds beschrijfbaar is. Nadat u uw site heeft geconfigureerd, moet u voor <b>veiligheid</b> de machtigingen van dit bestand terugzetten op alleen-lezen. U moet dit <u>handmatig</u> doen, aangezien PhpGedView dit niet voor u kan doen.";

//-- User Admin
$pgv_lang["useradmin_help"]					= "~#pgv_lang[user_admin]#~<br /><br />Op deze pagina kunt u de huidige gebruikers beheren en nieuwe gebruikers toevoegen.<br /><br /><b>#pgv_lang[current_users]#</b><br />In deze tabel worden de huidige gebruikers, hun status en hun rechten weergegeven. U kunt gebruikers <b>verwijderen</b> of <b>bewerken</b>.<br /><br /><b>#pgv_lang[add_user]#</b><br />Dit formulier is bijna hetzelfde als het formulier dat gebruikers zien op de <b>#pgv_lang[editowndata]#</b> pagina.<br /><br />Voor verschillende onderwerpen hebben we geen speciale Help-tekst gemaakt voor de beheerder. In die gevallen ziet u het volgende bericht:";
$pgv_lang["useradmin_gedcomid_help"]		= "~#pgv_lang[gedcomid]#~<br /><br />De #pgv_lang[gedcomid]# identificeert de gebruiker. Het moet worden ingesteld door de beheerder.<br /><br />Deze ID wordt op verschillende pagina's als ID gebruikt, zoals <b>#pgv_lang[my_indi]#</b> en <b>#pgv_lang[my_pedigree]#</b>.<br /><br />U kunt de GEDCOM-ID van de gebruiker afzonderlijk instellen voor elke GEDCOM. Als een gebruiker geen record in een GEDCOM heeft, laat u dat vak leeg.";
$pgv_lang["useradmin_rootid_help"]			= "~#pgv_lang[rootid]#~<br /><br />Voor elke genealogische database kunt u een <b>startpersoon</b> aanwijzen voor de gebruiker.<br /><br />Deze Root Person hoeft niet de gebruiker zelf te zijn; het kan iedereen zijn. De gebruiker zal de stamboomlijst waarschijnlijk met zichzelf willen starten. U beheert dat, evenals de standaard rootpersoon in andere grafieken, hier.<br /><br />Als de gebruiker bewerkingsrechten heeft voor zijn eigen accountinformatie, kan hij deze instelling zelf wijzigen.";
$pgv_lang["useradmin_can_admin_help"]		= "~#pgv_lang[can_admin]#~<br /><br />Als dit vakje is aangevinkt, heeft de gebruiker dezelfde rechten als jij.<br /><br />Deze rechten omvatten:<ul><li>Gebruikers toevoegen / verwijderen / bewerken</li><li>Zend berichten uit naar alle gebruikers</li><li>Bewerk welkomstberichten</li><li>Bewerk en configureer taalbestanden</li><li>Upgrade PhpGedView</li><li>Wijzig programma- en GEDCOM-configuraties</li><li>Beheer de GEDCOM's</li><li>Wijzig de privacy-instellingen</li><li>En al het andere dat hier niet wordt vermeld.</li></ul><br />De gebruiker <u>kan</u> niets veranderen op uw server buiten PhpGedView.";
$pgv_lang["useradmin_sync_gedcom_help"]		= "~#pgv_lang[sync_gedcom]#~<br /><br />Als dit vakje is aangevinkt en de gebruiker heeft een GEDCOM ID, wordt diens gebruikers account automatisch gesynchoniseerd met GEDCOM data. Dit betekent dat wanneer de GEDCOM gegevens van de gebruiker worden gewijzigd, sommige informatie, zoals email adres en naam, worden gekopieerd naar diens gebruikers account. Wanneer diens gebruikers account wordt gewijzigd, worden overeenkomstige gegevens gekopieerd naar de GEDCOM kaart.";
$pgv_lang["useradmin_can_edit_help"]		= "~#pgv_lang[can_edit]#~<br /><br />De gebruiker kan verschillende toegangs- en bewerkingsrechten hebben voor elke genealogische database in het systeem.<ul><li><b>#pgv_lang[none]#:</b>&nbsp;&nbsp;&nbsp;De gebruiker heeft geen toegang tot de privégegevens in deze GEDCOM.</li><li><b>#pgv_lang[access]#:</b>&nbsp;&nbsp;&nbsp;De gebruiker kan geen gegevens in de database bewerken of accepteren, maar kan de privégegevens wel zien.</li><li><b>#pgv_lang[edit]#:</b>&nbsp;&nbsp;&nbsp;De gebruiker kan waarden bewerken, maar een andere gebruiker met <b>#pgv_lang[accept]#</b> rechten moet de wijzigingen goedkeuren voordat ze aan de database worden toegevoegd en openbaar worden gemaakt.</li><li><b>#pgv_lang[accept]#:</b>&nbsp;&nbsp;&nbsp;De gebruiker kan bewerken. Hij kan ook wijzigingen die door andere gebruikers zijn aangebracht, bewerken en goedkeuren.</li><li><b>#pgv_lang[admin_gedcom]#:</b>&nbsp;&nbsp;&nbsp;De gebruiker kan wijzigingen die door andere gebruikers zijn aangebracht, bewerken en goedkeuren. De gebruiker kan ook de configuratie- en privacy-instellingen voor <u>deze</u> GEDCOM bewerken.</li></ul>Systeembeheerders, geïdentificeerd door het <b>#pgv_lang[can_admin]#</b> vakje, krijgen automatisch <b>#pgv_lang[admin_gedcom]#</b> rechten.";
$pgv_lang["useradmin_verified_help"]		= "~#pgv_lang[verified]#~<br /><br /><b>Zelfregistratie</b><br />Een gebruiker kan een nieuw account aanvragen door middel van de module <b>Zelfregistratie</b>.<br /><br />Wanneer hij dit doet, ontvangt hij een e-mailbericht met een link om zijn aanvraag te verifiëren. Nadat de sollicitant heeft gehandeld volgens de instructies in die e-mail, ziet u dit vakje aangevinkt en kunt u doorgaan met de volgende stap, <b>#pgv_lang[verified_by_admin]#</b>. U moet wachten met uw goedkeuring zolang dit vakje niet is aangevinkt.<br /><br /><b>Voeg gebruiker handmatig toe</b><br />Als u dit formulier gebruikt om handmatig een gebruiker toe te voegen, zult u zien dat dit vakje al is aangevinkt.";
$pgv_lang["useradmin_verbyadmin_help"]		= "~#pgv_lang[verified_by_admin]#~<br /><br />Als een gebruiker de zelfregistratiemodule heeft gebruikt en zichzelf heeft geverifieerd, is de laatste stap, voordat zijn account actief wordt, uw goedkeuring.<br /><br />Nadat u de aanvraag van de gebruiker voor een nieuw account heeft goedgekeurd, ontvangt de gebruiker een e-mailbericht. Het bericht vertelt de gebruiker dat zijn account nu actief is. Hij kan inloggen met de gebruikersnaam en het wachtwoord die hij heeft opgegeven bij het aanvragen van het account.";
$pgv_lang["useradmin_edit_user_help"]		= "~#pgv_lang[update_user]#~<br /><br />Dit formulier wordt door de beheerder gebruikt om het account van een gebruiker te wijzigen.<br /><br />Het formulier lijkt sterk op de <b>#pgv_lang[add_user]#</b> en <b>#pgv_lang[update_myaccount]#</b> formulieren. ";
$pgv_lang["useradmin_visibleonline_help"]	= "~#pgv_lang[visibleonline]#~<br /><br />Dit vak regelt uw zichtbaarheid voor andere gebruikers terwijl u online bent. Het regelt ook uw mogelijkheid om andere online gebruikers te zien die zijn geconfigureerd om zichtbaar te zijn.<br /><br />Als dit vakje niet is aangevinkt, bent u volledig onzichtbaar voor anderen en kunt u ook geen andere online gebruikers zien. gebruikers. Als dit vakje is aangevinkt, is precies het tegenovergestelde waar. U bent zichtbaar voor anderen en u kunt ook anderen zien die zijn geconfigureerd om zichtbaar te zijn.";
$pgv_lang["useradmin_editaccount_help"]		= "~#pgv_lang[editaccount]#~<br /><br />Als dit vakje is aangevinkt, kan deze gebruiker zijn accountgegevens bewerken. Hoewel dit over het algemeen niet wordt aanbevolen, kunt u voor meerdere gebruikers één gebruikersnaam en wachtwoord aanmaken. Als dit vakje niet is aangevinkt voor alle gebruikers met het gedeelde account, kunnen ze de accountinformatie niet bewerken en kan alleen een beheerder dat account wijzigen.";
$pgv_lang["useradmin_relation_priv_help"]	= "~#pgv_lang[user_relationship_priv]#~<br /><br />Als dit vakje is aangevinkt, heeft de gebruiker alleen toegang tot levende mensen met wie ze verwant zijn. Ze kunnen iedereen zien die zich binnen de padlengte van de relatie bevindt die is ingesteld door hun instelling <i>#pgv_lang[user_path_length]#</i>. U kunt relatieprivacy eisen voor al uw gebruikers door de algemene optie in de GEDCOM-privacyinstellingen in te schakelen.<br /><br />Deze instelling vereist dat de gebruiker wordt geassocieerd met een GEDCOM-ID voordat ze levende mensen kunnen zien.";
$pgv_lang["useradmin_path_length_help"]		= "~#pgv_lang[user_path_length]#~<br /><br />Als  <i>#pgv_lang[user_relationship_priv]#</i> is ingeschakeld, zal de gebruiker alleen de gegevens van, nog levende, personen kunnen inzien en wijzigen binnen het, hier opgegeven, aantal relatie-pad stappen.";
$pgv_lang["useradmin_auto_accept_help"]		= "~#pgv_lang[user_auto_accept]#~<br /><br />Door dit vakje aan te vinken, geeft u het programma toestemming om automatisch <b>alle</b> wijzigingen te accepteren, die door deze gebruiker zijn gemaakt. De gebruiker moet eveneens privileges voor de GEDCOM hebben geaccepteerd, om deze instelling in werking te stellen.";

//-- Manage Sites
$pgv_lang["help_managesites"]				= "~#pgv_lang[link_manage_servers]#~<br /><br />Op deze pagina kunt u andere sites toevoegen en IP adressen blokkeren.<br /><br />Andere sites kunnen worden toegevoegd door het opgeven van de titel v.d. site, URL, database id(optioneel), gebruikersnaam en wachtwoord, voor de andere web service.<br /><br />Permanente of getimede weigering van IP-toegang wordt bereikt door een exact IP-adres of een geldig IP-adresbereik op te geven. Bijvoorbeeld 212.10.*.* Externe sites binnen de IP-adresbereiken in de lijst hebben geen toegang tot uw site.";
//-- Adding Remote Links
$pgv_lang["help_remotesites"]			= "~#pgv_lang[label_new_server]#~<br /><br />Om een externe site toe te voegen, geeft u de sitetitel, URL van de externe webservice, database-ID (optioneel) en gebruikersnaam en wachtwoord op. Klik op de knop Toevoegen (+) om het proces te voltooien. Als de externe server anonieme authenticatie toestaat, moet u de gebruikersnaam en het wachtwoord leeg laten.";
//-- IP Address Banning
$pgv_lang["help_IPv4IPv6"]					= "IPv4-adressen bestaan uit 4 segmenten gescheiden door \".\" (punt) en bevatten decimale getallen in het bereik nul tot 255 zonder voorloopnullen. Voorbeelden zijn: <b>172.252.19.56</b> , <b>212.10.*.*</b> , <b>212.10.</b> , <b>212.10</b> , <b>212.10..29</b> of <b>212.10.*.29</b> .  De ontbrekende segmenten in deze voorbeelden worden geïnterpreteerd als \"*\" (sterretje), waarbij dat \"*\" symbool overeenkomt met <i>elk getal in deze positie</i>.<br /><br />IPv6-adressen bestaan uit 8 segmenten gescheiden door \":\" (dubbele punt) en bevatten 4-cijferige hexadecimale nummers. Deze getallen mogen geen voorloopnullen hebben en de eerste reeks nullen kan worden verwijderd en vervangen door een paar \":\" (dubbele punt) symbolen. Als u de functie <i>elk getal in deze positie</i> wilt gebruiken, moet u daar expliciet \"*\" (sterretje) invoegen.  Voorbeelden zijn: <b>23:0:cafe::2:1</b> , <b>23:0:cafe::*:1</b> of <b>23:0:*::*:*</b> .  In deze voorbeelden vertegenwoordigt het paar dubbele punten een reeks van 3 getallen, die elk nul zijn, zoals zo: <b>23:0:cafe:0:0:0:*:1</b>.";
$pgv_lang["help_banning"]					= "~#pgv_lang[label_banned_servers]#~<br /><br />Om de toegang van andere sites of personen via bepaalde IPv4 of IPv6 adressen tot uw web service te blokkeren, kunt u hier voer een exact IP-adres of een geldig IP-adresbereik in en klik op de knop Toevoegen (+).<br /><br />#pgv_lang[help_IPv4IPv6]#";
$pgv_lang["help_timedban"]					= "~#pgv_lang[label_timedban_servers]#~<br /><br />Wanneer een poging tot hacken wordt gedetecteerd, zal PhpGedView automatisch toegang vanaf dat IP-adres voor een uur verhinderen.<br /><br />U kunt uw eigen getimede toegangsweigeringen toevoegen door het IPv4- of IPv6-adres in te voeren dat moet worden geblokkeerd, samen met de datum en tijd van afloop van de weigering van toegang in het veld Opmerkingen. Zorg ervoor dat u de juiste indeling gebruikt voor de verloopinformatie. Als de verloopinformatie niet correct is ingevoerd, vervalt de toegangsweigering niet automatisch.<br /><br />De vervaldatum moet worden ingevoerd in de volgende indeling: <b>jjjj.mm.dd@hh:mm</b>. Bijvoorbeeld, <b>2012.12.23@23:59</b> . Let op het gebruik van de 24-uurs klok.<br /><br />#pgv_lang[help_IPv4IPv6]#";
$pgv_lang["help_manual_search_engines"]		= "~#pgv_lang[label_manual_search_engines]#~<br /><br />PhpGedView stelt automatisch kleinere datbestanden, met minder links, beschikbaar aan zoekmachines.  De data zijn beperkt tot personen en hun directe familie, zonder informatie toe te voegen over grootouders of kleinkinderen. Veel rapporten en andere server-intensieve pagina's zijn verboden toegang voor de zoekmachines.<br /><br />Veel populaire zoekmachines zoals Google en Bing worden automatisch gedetecteerd. Als een zoekmachine niet automatisch wordt herkend en u deze wilt indexeren, kunt u hier het IPv4- of IPv6-adres invoeren. Als u deze nieuwe zoekmachine volledig wilt uitsluiten, geeft u deze op in het sectie <i>#pgv_lang[label_banned_servers]#</i>.<br /><br />Als u wilt zien welke gegevens aan de zoekmachines worden aangeboden, om te indexeren, vul dan uw eigen IP adres hier in.&nbsp; <span class='warning'>WAARSCHUWING:</span>&nbsp; Daarmee wordt u <b>uitgesloten</b> van de beheeders interface.  U kunt uw IP adres alleen verwijderen door in te loggen d.m.v. een andere machine via een ander IP adres, of door de <i>#GLOBALS[TBLPREFIX]#ip_address</i> databasetabel handmatig te bewerken.<br /><br />#pgv_lang[help_IPv4IPv6]#";

//-- Search_engines.php
$pgv_lang["search_engine_landing_page"]		= "~Zoek Machine Gedetecteerd~<br /><br />PhpGedView biedt automatisch kleinere data bestanden, met minder links, aan aan zoekmachines. De data is beperkt tot de persoon en de directe familie, zonder dat informatie over grootouders of kleinkinderen wordt toegevoegd.<br />Veel rapporten-pagina's of pagina's die erg server-intensief zijn, zijn verboden toegang voor zoekmachines.<br /><br />Pogingen van zoekmachines om naar zulke pagina's te gaan hebben als gevolg dat deze pagina wordt getoond. Als u deze tekst ziet, dan denkt de software dat u een zoekmachine bent.<br />Onderstaand is de lijst met pagina's, waarvan zoekmachines-bezoek is toegestaan en de juiste afgekorte data bieden.<br /><br />Echte gebruikers, die links van zoekmachines volgen naar deze site, zullen de volledige pagina's en gegevens zien, maar niet deze pagina.";

//-- G E D C O M
$pgv_lang["add_upload_gedcom_help"]		= "~#pgv_lang[add_gedcom]#~<br />~#pgv_lang[upload_gedcom]#~<br /><br /><b>GEDCOM-bestanden uploaden</b><br />Het uploaden van bestanden kan online worden gedaan. U kunt overal vandaan uploaden zonder dat u een FTP-programma nodig heeft.<br /><br /><b>GEDCOM-bestanden toevoegen</b><br />Als een eerder geüpload bestand nog steeds aanwezig is in uw <b>/index</b> map, kunt u het opnieuw gebruiken zonder te uploaden. Soms moet u, vanwege beperkingen voor de bestands- of uploadgrootte, Toevoegen gebruiken.<br /><br />De procedure voor toevoegen en uploaden kan in vier eenvoudige stappen worden voltooid. In beide procedures is alleen stap 1 anders.";
$pgv_lang["gedcom_configfile_help"]		= "~GEDCOM-CONFIGURATIEBESTAND~<br /><br />Dit is het bestand waarin alle basisinstellingen met betrekking tot de genealogische database zijn opgeslagen. Er is een apart bestand voor elke dergelijke database.<br /><br />U vindt het pad en de naam van elk configuratiebestand in de <b>#pgv_lang[current_gedcoms]#</b> tabel in de <b>#pgv_lang[gedcom_adm_head]#</b> pagina.";
$pgv_lang["default_gedcom_help"]		= "~STANDAARD GEDCOM~<br /><br />Als u meer dan één genealogische database heeft, kunt u hier instellen welke hiervan de standaard zal zijn.<br /><br />Deze standaard wordt getoond aan alle bezoekers en gebruikers die nog niet ingelogd zijn.<br /><br />Gebruikers die hun accountinstellingen kunnen bewerken, kunnen deze standaard overschrijven. In dat geval wordt de voorkeursdatabase van de gebruiker getoond na het inloggen.";
$pgv_lang["delete_gedcom_help"]			= "~VERWIJDER GEDCOM-BESTAND~<br /><br />PhpGedView maakt zijn database aan op basis van een GEDCOM-bestand dat eerder was geüpload. Als u <b> Verwijderen </b> selecteert, wordt dat gedeelte van de database gewist. U moet uw verwijderingsverzoek bevestigen.<br /><br />Tenzij u het opzettelijk buiten PhpGedView hebt verwijderd, blijft het originele GEDCOM-bestand in de map waarin het werd geüpload. Als u later weer met dat GEDCOM-bestand wilt werken, hoeft u het niet opnieuw te uploaden. U kunt de functie <b>#pgv_lang[add_gedcom]#</b> kiezen.";
$pgv_lang["add_gedcom_help"]			= "~#pgv_lang[add_gedcom]#~<br /><br />Wanneer u de functie <b>#pgv_lang[add_gedcom]#</b> gebruikt, wordt aangenomen dat u het GEDCOM-bestand al naar uw server hebt geüpload met een programma of methode <u>extern</u> naar PhpGedView, voor bijvoorbeeld <i>FTP</i> of <i>netwerkverbinding</i>. Het bestand dat u wilt toevoegen, kan ook zijn overgebleven van een eerdere <b>#pgv_lang[upload_gedcom]#</b> procedure.<br /><br />Als het ingevoerde GEDCOM-bestand nog niet op uw server staat, moet u het eerst daar uploaden, voordat u kunt beginnen met Toevoegen.<br /><br />In plaats van een GEDCOM-bestand te uploaden, kunt u ook een ZIP-bestand met het GEDCOM-bestand uploaden, hetzij met PhpGedView, hetzij met behulp van een extern programma. PhpGedView herkent het ZIP-bestand automatisch en haalt het GEDCOM-bestand en de bestandsnaam uit het ZIP-bestand.<br /><br />Als er al een GEDCOM-bestand met dezelfde naam in PhpGedView bestaat, wordt het overschreven. Alle eerder gemaakte GEDCOM-instellingen blijven echter behouden.<br /><br />U wordt stap voor stap door de procedure geleid.";
$pgv_lang["add_new_gedcom_help"]		= "~#pgv_lang[add_new_gedcom]#~<br /><br />U kunt vanaf het begin een nieuwe genealogische database starten.<br /><br />Deze procedure vereist slechts een paar eenvoudige stappen. Stap 1 is anders dan wat je al weet over uploaden en toevoegen. De andere stappen zullen u bekend voorkomen.<ol><li><b>Een naam geven aan de nieuwe GEDCOM</b><br />Typ de naam van de nieuwe GEDCOM <u>zonder</u> de extensie <b>.ged</b>. Het nieuwe bestand wordt gemaakt in de map met de naam boven het vak waarin u de naam invoert. Klik op <b>Toevoegen</b>.</li><li><b>Configuratiepagina</b><br />U kent deze pagina al; u configureert de instellingen voor uw nieuwe GEDCOM-bestand.</li><li><b>Valideer</b><br />U kent deze pagina al; de nieuwe GEDCOM wordt gecontroleerd. Omdat er niets in zit, komt het wel goed.</li><li><b>Records importeren</b><br />Aangezien er maar één record hoeft te worden geïmporteerd, is dit zeer snel klaar.</li></ol>Nu kunt u naar de stamboomlijst gaan om uw eerste persoon in de nieuwe GEDCOM te zien. Klik op de naam van de persoon en begin met bewerken. Daarna kunt u nieuwe personen aan de eerste persoon koppelen.";
$pgv_lang["download_gedcom_help"]		= "~#pgv_lang[download_gedcom]#~<br /><br />Vanaf deze pagina kunt u uw genealogische database downloaden in GEDCOM-formaat. Misschien wilt u de gegevens importeren in een ander genealogisch programma, of wilt u de informatie ervan met anderen delen.<br /><br />#pgv_lang[utf8_ansi_help]#<br /><br />#pgv_lang[remove_tags_help]#<br /><br />#pgv_lang[download_zipped_help]#";
$pgv_lang["edit_gedcoms_help"]			= "~#pgv_lang[gedcom_adm_head]#~<br /><br />De #pgv_lang[gedcom_adm_head]# pagina is het controlecentrum voor het beheer van al uw genealogische databases.<br /><br /><b>#pgv_lang[current_gedcoms]#</b><br />Aan het begin van de tabel <b>#pgv_lang[current_gedcoms]#</b> zie je een actiebalk met vier links.<ul><li>#pgv_lang[add_gedcom]#</li><li>#pgv_lang[upload_gedcom]#</li><li>#pgv_lang[add_new_gedcom]#</li><li>#pgv_lang[lang_back_admin]#</li></ul><br />In de tabel <b>#pgv_lang[current_gedcoms]#</b> wordt elke genealogische database afzonderlijk vermeld, en je hebt de volgende opties voor elk ervan:<ul><li>Importeren</li><li>Verwijderen</li><li>Download</li><li>Bewerk de configuratie</li><li>Privacy bewerken</li><li>SearchLog-bestanden</li></ul>Bewerk privacy verschijnt hier omdat elke GEDCOM zijn eigen privacybestand heeft.<br /><br />Elke regel in deze tabel zou voor zichzelf moeten spreken. PhpGedView kan worden geconfigureerd om alle databasezoekopdrachten te loggen. De SearchLog-bestanden kunnen worden geïnspecteerd via links op deze pagina.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["edit_config_gedcom_help"]	= "~INSTELLEN GEDCOM-BESTAND~<br /><br />Elke genealogische database die met PhpGedView wordt gebruikt, heeft zijn eigen <b>Configuratiebestand</b>.<br /><br />Op dit formulier configureert u vele opties zoals databasetitel, taal, kalenderformaat, e-mailopties, logboekregistratie van database zoekopdrachten, HTML META-headers, verwijdering van achternamen uit de lijst met frequente achternamen van de database, enz.";
$pgv_lang["import_gedcom_help"]				= "~IMPORTEREN GEDCOM-BESTAND~<br /><br />In de meeste gevallen is het importeren van een GEDCOM-bestand een stap in de procedure van toevoegen of uploaden.<br /><br />Deze stappen zijn in een logische volgorde en moeten worden voltooid om met het bestand te kunnen werken.<br /><br />Als u niet de gehele procedure heeft afgewerkt, ziet u een <b>waarschuwing</b>. In dat geval dient u eerst de koppeling aan te klikken om het bestand te importeren.<br /><br />In alle gevallen worden de configuratie-instellingen gehanteerd, die u eerder heeft opgegeven. De huidige informatie uit het GEDCOM-bestand zal, bij her-import, worden overschreven met de nieuwe inhoud.";
$pgv_lang["upload_gedcom_help"]			= "~#pgv_lang[upload_gedcom]#~<br /><br />In tegenstelling tot de functie <b>#pgv_lang[add_gedcom]#</b>, hoeft het GEDCOM-bestand dat u aan uw database wilt toevoegen niet op uw server te staan.<br /><br />In stap 1 selecteert u een GEDCOM-bestand van uw lokale computer. Typ het volledige pad en de bestandsnaam in het tekstvak of gebruik de knop <b>Bladeren</b> op de pagina.<br /><br />Je kunt deze functie ook gebruiken om een ZIP-bestand te uploaden dat het GEDCOM-bestand bevat. PhpGedView zal het ZIP-bestand herkennen en het bestand en de bestandsnaam automatisch uitpakken.<br /><br />Als er al een GEDCOM-bestand met dezelfde naam in PhpGedView bestaat, wordt het, na uw bevestiging, overschreven. Alle eerder gemaakte GEDCOM-instellingen blijven echter behouden.<br /><br />U vindt meer hulp op andere pagina's van de procedure.";
$pgv_lang["validate_gedcom_help"]		= "~VALIDEREN GEDCOM-BESTAND~<br /><br />Dit is de derde stap in de procedure om extern gemaakte GEDCOM-gegevens toe te voegen aan uw genealogische database.<br /><br />PhpGedView controleert het invoerbestand op het juiste gebruik van datumnotatie, plaatsformaat, tekenset, enz. afwijkingen van de GEDCOM 5.5.1 Standaard, waaraan PhpGedView zich houdt, kunnen automatisch worden gecorrigeerd. Voorbeelden zijn Macintosh-regeleinden en onjuist gebruik van het plaatsformaat. Wanneer dit gebeurt, ziet u een bericht dat de gegevens zijn gewijzigd. Bij andere afwijkingen krijgt u een waarschuwingsbericht met een aanbevolen oplossing.<br /><br /><b>Optioneel gereedschap</b><br />Op dit moment is er maar één extra tool: <b>Verander individuele ID in ...</b>.<br /><br /><b>Meer hulp</b><br />#pgv_lang[context_help]#";
$pgv_lang["convert_ansi2utf_help"]		= "~CONVERSIE ANSI NAAR UTF-8~<br /><br />Om ervoor te zorgen dat de informatie in uw ingevoerde GEDCOM-bestanden correct wordt verwerkt en weergegeven, moeten deze bestanden worden gecodeerd in UTF-8. <br /> <br /> Sommige van de modernere genealogieprogramma's kunnen hun gegevens exporteren naar een GEDCOM-bestand in UTF-8-codering. Oudere programma's hebben deze mogelijkheid vaak niet. Als uw programma u deze optie niet biedt, kan PhpGedView het bestand voor u converteren.<br /><br />Wanneer PhpGedView het invoerbestand valideert, zal het de codering van het bestand detecteren en u dienovereenkomstig adviseren.";
$pgv_lang["detected_ansi2utf_help"]			= "~ANSI CODERING GEVONDEN~<br /><br />Het GEDCOM-bestand dat nu wordt gevalideerd, is gecodeerd in ANSI. Het wordt sterk aanbevolen dat het bestand wordt geconverteerd naar UTF-8 codering.<br /><br />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"]				= "~FOUTIEF DATUMFORMAAT GEVONDEN~<br /><br />DATUMFORMAAT WORDT AANGEPAST<br /><br />De GEDCOM 5.5.1 standaard voor het datumformaat is DD&nbsp;MMM&nbsp;YYYY (bijvoorbeeld 01&nbsp;JAN&nbsp;2004). Ook PhpGedView hanteert deze standaard.<br /><br />Als u na de GEDCOM-validatie de bovenstaande melding ziet, kan het programma de datums converteren naar het standaard formaat.<br /><br />U heeft nog de mogelijkheid te kiezen tussen <b>dag voor maand</b> (DD&nbsp;MMM&nbsp;YYYY) en <b>maand voor dag</b> (MMM&nbsp;DD&nbsp;YYYY).<br /><br />Wij raden u aan om voor de standaard (eerste) optie te kiezen.";
$pgv_lang["change_indi2id_help"]		= "~WIJZIG PERSOONS-ID ...~<br /><br />Deze tool is ontworpen voor gebruikers van wie genealogieprogramma's een andere GEDCOM-ID gebruiken voor de personen elke keer dat de GEDCOM wordt geëxporteerd. De eerste keer dat de GEDCOM wordt geëxporteerd, kan de ID van een persoon bijvoorbeeld I100 zijn, maar de volgende keer dat de GEDCOM wordt geëxporteerd, wordt de ID van diezelfde persoon gewijzigd in I234. Deze veranderende ID's maken het moeilijk om PhpGedView te beheren, omdat de ID de manier is waarop naar mensen wordt verwezen.<br /><br />De meeste genealogieprogramma's gebruiken ook de RIN- of REFN-tag om elke persoon een unieke identificatie te geven die kan worden gebruikt om naar het individu te verwijzen. Deze tool zal alle individuele ID's in het GEDCOM-bestand vervangen door het veld (RIN of REFN) dat je specificeert.";
$pgv_lang["edit_privacy_help"]			= "Op deze pagina kunt u alle privacy-instellingen maken voor de geselecteerde GEDCOM.<br /><br />U kunt onder de paginatitel controleren of u het juiste privacybestand aan het bewerken bent. Het wordt als volgt weergegeven: (path/nameofyourgedcom_priv.php)<br /><br />Als u meer instellingen nodig heeft, kunt u handmatig wijzigingen aanbrengen in het privacybestand. U kunt hierover meer lezen op de PhpGedView-website.";
$pgv_lang["BOM_detected_help"]				= "~Byte Order Mark (BOM) gedetecteerd~<br /><br />Het GEDCOM bestand, dat u importeert, heeft een speciale 3-byte code aan het begin. Deze speciale code wordt door sommige programma's gebruikt, om aan te geven dat het bestand is opgenomen met de UTF-8 karakter set.<br /><br />Hoewel deze speciale code niet echt een fout is, zal PhpGedView niet goed werken als het input bestand deze code bevat. U moet PhpGedView deze code laten verwijderen.";
$pgv_lang["invalid_header_help"]			= "~ONGELDIGE GEDCOM KOPREGEL~<br /><br />Een GEDCOM-bestand moet beginnen met regel <b>0&nbsp;HEAD</b>. PhpGedView heeft gedetecteerd dat uw GEDCOM-bestand niet met <b>0&nbsp;HEAD</b> begint. Als u op \"Opschonen\" heeft geklikt, worden alle regels voor <b>0&nbsp;HEAD</b> uit uw GEDCOM-bestand verwijderd.<br /><br />Deze fout betekent meestal dat uw programma geen correct GEDCOM-bestand heeft gemaakt, of dat het bestand geen GEDCOM-bestand is.<br />Controleer of u het juiste bestand heeft ge-upload en of het begint met een <b>0&nbsp;HEAD</b> regel en eindigt met een <b>0&nbsp;TRLR</b> regel.";
$pgv_lang["macfile_detected_help"]		= "~MACINTOSH-BESTAND GEVONDEN~<br /><br />PhpGedView heeft gedetecteerd dat uw GEDCOM-bestand van een Macintosh computer afkomstig is.<ul><li>Macintosh-bestanden eindigen elke regel met een CR controlecode. CR is Ctrl+M.</li><li>Unix-bestanden eindigen elke regel met een LF controlecode. LF is Ctrl+J.</li><li>Windows en DOS gebruiken een reeks van twee codes, CR gevolgd door LF.</li></ul>PhpGedView vereist dat alle bestanden Unix- of DOS-regeleinden gebruiken. Als u op de knop Opschonen klikt, worden uw regeleinden overeenkomstig geconverteerd.";
$pgv_lang["cleanup_places_help"]			= "~OPSCHONEN PLAATSEN~<br /><br />PhpGedView heeft gedetecteerd dat in uw GEDCOM-bestand plaatsnamen voorkomen waar dit niet is toegestaan.<br /><br />Veel genealogieprogramma's, zoals Family Tree Maker, genereren dit soort fouten. PhpGedView kan met deze GEDCOM-bestanden werken, maar in de locatieniveaus worden de plaatsnamen dan niet altijd correct weergegeven.<br /><br />Bijvoorbeeld kunnen in uw bestand de volgende regels voorkomen:<div style=\"padding-left: 30px;\">1 SSN<br />2 PLAC 123-45-6789<br />1 OCCU<br />2 PLAC Computer programmeur</div><br />Volgens de GEDCOM-standaard zou dit moeten zijn:<div style=\"padding-left: 30px;\">1 SSN 123-45-6789<br />1 OCCU Computer programmeur</div><br />Als u op <b>Ja</b> klikt, spoort PhpGedView deze fouten op en corrigeert ze.";
$pgv_lang["empty_lines_detected_help"]		= "~LEGE REGELS GEVONDEN~<br /><br />PhpGedView heeft lege regels gevonden in uw GEDCOM-bestand. Omdat deze regels fouten kunnen veroorzaken worden ze voor import uit het GEDCOM-bestand verwijderd.";

//-- Edit Config
$pgv_lang["help_editconfig.php"]		= "~INSTELLEN PHPGEDVIEW~<br /><br />Op deze pagina configureert u de algemene instellingen voor PhpGedView. U moet dit doen nadat u PhpGedView heeft geïnstalleerd en het voor de eerste keer gebruikt.<br /><br />#pgv_lang[review_readme]#<br /><br />Aangezien deze instellingen <b>globaal</b> zijn, gelden ze voor het hele programma en voor alle genealogische databases die u met PhpGedView gebruikt.<br /><br />Elke genealogische database heeft ook aanvullende configuratie-opties die u instelt door op de <b>#pgv_lang[admin_gedcoms]#</b> link op deze pagina te klikken.<br /><br />Je kunt ook toegang krijgen tot de #pgv_lang[gedcom_adm_head]# functie vanaf de hoofd Admin pagina, waarvan de link te vinden is onder het #pgv_lang[mgv]# icoon of in de koptekst van de meeste pagina's. Op de Admin-pagina heet de relevante link <b>#pgv_lang[manage_gedcoms]#</b>.";

//-- merge records
$pgv_lang["help_edit_merge.php"]			= "~#pgv_lang[merge_records]#~<br /><br />Op deze pagina kunt u de gegevens van twee personen, twee families of twee bronnen samenvoegen.<br /><br />Dit kan noodzakelijk zijn als u twee GEDCOM-bestanden heeft samengevoegd, waar dezelfde personen, families of bronnen in voorkomen.<br /><br />Het samenvoegen gaat in drie stappen.<br /><ol><li>U voert twee GEDCOM-ID's in. De ID's <u>moeten</u> van hetzelfde type zijn. U kunt bijvoorbeeld een persoon en een gezin of een gezin en een bron niet samenvoegen.<br />Voer in het veld <b>#pgv_lang[merge_to]#</b> de ID in van het record waarvan u het nieuwe record wilt zijn. het samenvoegen is voltooid.<br />Voer in het veld <b>#pgv_lang[merge_from]#</b> de ID in van het record waarvan de informatie zal worden samengevoegd in het #pgv_lang[merge_to]# record. Dit record wordt verwijderd na het samenvoegen.</li><li>U selecteert welke feiten u wilt bewaren uit de twee records wanneer ze worden samengevoegd. Klik gewoon op de vakjes naast degene die u wilt behouden.</li><li>U bekijkt de resultaten van de samenvoeging, net als bij alle andere online aangebrachte wijzigingen.</li></ol>Iemand met acceptatierechten zal uw wijzigingen moeten autoriseren om ze permanent te maken.";

//-- report engine
$pgv_lang["help_reportengine.php"]		= "~#pgv_lang[reports]#~<br /><br />De items in het rapportmenu genereren PDF-bestanden om af te drukken.<br /><br />De eerste stap is het kiezen van een rapport om uit te voeren. Nadat u een rapport heeft geselecteerd om uit te voeren, wordt u gevraagd om bepaalde informatie te verstrekken die specifiek is voor dat rapport, zoals met welke persoon of familie u moet beginnen en of u al dan niet foto's wilt laten zien. Als u klaar bent om het rapport uit te voeren, klikt u op de knop <b>#pgv_lang[download_report]#</b> om het rapport naar uw computer te downloaden.<br /><br />#pgv_lang[help_xml_reports]#<br /><br />#pgv_lang[def_pdf_format_help]#<br /><br />#pgv_lang[help_ahnentafel.xml]#<br /><br />#pgv_lang[help_birthlist.xml]#<br /><br />#pgv_lang[help_relativelist.xml]#";
$pgv_lang["def_pdf_format_help"]			= "~PDF BESTANDS FORMAAT~<br /><br />De PhpGedView Rapporten Module produceert te downloaden rapporten in Adobe&reg; PDF formaat.  De GEDCOM 5.5.1 Standaard specificatie, elders in dit Help bestand al genoemd, is eveneens te downloaden als een PDF bestand.  PDF is een afkorting van <b>P</b>ortable <b>D</b>ocument <b>F</b>ormat (draagbaar documentformaat).";
$pgv_lang["help_ahnentafel.xml"]			= "~#pgv_lang[ahnentafel_report]#~<br /><br />Dit is een rapport van de geselecteerde persoon en de voorouders hiervan, geprint in booklet formaat.  Het begint met de gekozen persoon en vervolgt dan met diens ouders, grootouders, enz.<br /><br />Merk op dat het ahnentafel-rapport op dit moment alleen in het Engels beschikbaar is.";
$pgv_lang["help_birthlist.xml"]				= "~#pgv_lang[birth_report]#~<br /><br />Met dit rapport kunt u een lijst maken met alle personen, die zijn geboren in een bepaalde plaats of in een bepaalde tijdsperiode.";
$pgv_lang["help_relativelist.xml"]			= "~#pgv_lang[relatives_report]#~<br /><br />Dit rapport maakt een lijst van alle verwanten van de geselecteerde persoon.  U kunt zelf kiezen welke verwanten van die persoon in het rapport zullen worden getoond.<ul><li><b>#pgv_lang[child-family]#</b>&nbsp;&nbsp;&nbsp;zal de geselecteerde persoon, diens ouders en broers en zusters, laten zien.</li><li><b>#pgv_lang[spouse-family]#</b>&nbsp;&nbsp;&nbsp;zal de persoon tonen, met diens partner en hun kinderen.</li><li><b>#pgv_lang[direct-ancestors]#</b>&nbsp;&nbsp;&nbsp;zal de persoon tonen, diens ouders, grootouders, overgrootouders, enz. Het vervolgt de boom met alle personen die ouders zijn in de directe lijn van de geselecteerde startpersoon.</li><li><b>#pgv_lang[ancestors]#</b>&nbsp;&nbsp;&nbsp;zal alle mensen opsommen van de #pgv_lang[direct-ancestors]# lijst, maar ook inclusief ooms en tantes enz. De lijst bevat dus alle directe voorouders, inclusief alle kinderen van deze voorouders. Het zal echter niet de kinderen van deze kinderen tonen (neven en nichten).</li><li><b>#pgv_lang[descendants]#</b>&nbsp;&nbsp;&nbsp;zal alle nakomelingen van de geselecteerde persoon tonen  (kinderen, kleinkinderen, achterkleinkinderen, enz.).</li><li><b>#pgv_lang[all]#</b>&nbsp;&nbsp;&nbsp;deze optie is een combinatie van #pgv_lang[descendants]# en #pgv_lang[ancestors]# in een enkel rapport.</li></ul>";
$pgv_lang["help_xml_reports"]				= "~Rapporten Module~<br /><br />De PhpGedView Rapporten Module gebruikt XML sjabloon bestanden om rapporten in PDF formaat automatisch te genereren.<br /><br />De rapporten, beschikbaar in de <b>#pgv_lang[select_report]#</b> lijst, worden gemaakt van de rapport-XML bestanden, gevonden in de \"reports\" map.  U kunt uw eigen rapporten genereren door een kopie te maken van een van de beschibare sjablonen en dan de sjabloon XML te wijzigen.  Om uw aangepast rapport toe te voegen, hoeft u het alleen maar in de \"reports\" map te plaatsen en PhpGedView zal het automatisch detecteren en beschikbaar stellen in de lijst.";

//-- Help Contents
$pgv_lang["help_contents_head_help"]		= "<b>HELP INHOUD</b>";
$pgv_lang["help_contents_gedcom_info"]		= "GEDCOM-informatie";
$pgv_lang["help_contents_gedcom_places"]	= "Locaties in het GEDCOM-bestand";

//-- Admin Help Contents Items
$pgv_lang["admin_help_contents_head_help"]	= "<b>INHOUDSOPGAVE HELP<br /><br />HELPONDERWERPEN BEHEERDER</b> toegevoegd aan het begin van de lijst.";
// $pgv_lang["ah1_help"]					= "_Upgrade";
$pgv_lang["ah2_help"]						= "_Instellen PhpGedView";
$pgv_lang["ah3_help"]						= "_GEDCOM: Toevoegen en uploaden";
$pgv_lang["ah4_help"]						= "_GEDCOM: Instellingenbestand";
$pgv_lang["ah5_help"]						= "_GEDCOM: Standaard";
$pgv_lang["ah6_help"]						= "_GEDCOM: Verwijderen";
$pgv_lang["ah7_help"]						= "_GEDCOM: Toevoegen";
$pgv_lang["ah8_help"]						= "_GEDCOM: Nieuwe maken";
$pgv_lang["ah9_help"]						= "_GEDCOM: Downloaden";
$pgv_lang["ah10_help"]						= "_GEDCOM: Beheerpagina";
$pgv_lang["ah11_help"]						= "_GEDCOM: Instellen";
$pgv_lang["ah12_help"]						= "_GEDCOM: Importeren";
$pgv_lang["ah13_help"]						= "_GEDCOM: Uploaden";
$pgv_lang["ah14_help"]						= "_GEDCOM: Valideren";
$pgv_lang["ah15_help"]						= "_GEDCOM: Converteren van ANSI naar UTF-8";
$pgv_lang["ah16_help"]						= "_GEDCOM: Privacy instellingen";
$pgv_lang["ah17_help"]						= "_Gebruikersbeheer";
$pgv_lang["ah18_help"]						= "_Beheer";
$pgv_lang["ah19_help"]						= "_GEDCOM: Toevoegen multimedia";
$pgv_lang["ah20_help"]						= "_GEDCOM: Wijzig persoons-ID";
$pgv_lang["ah21_help"]						= "_Taalbestanden";
//           22 is in the help_text_vars.php
$pgv_lang["ah23_help"]						= "_Instellen ondersteunde talen";
$pgv_lang["ah24_help"]						= "_Migreren gebruikersinformatie (SQL --&gt;&gt; Indexmodus)";
$pgv_lang["ah25_help"]						= "_PhpGedView backup";
$pgv_lang["ah26_help"]						= "_VGV Lijst: Wijzig";

//--Statistics Help
$pgv_lang["help_statisticsplot.php"]		= "~statistieken diagram~<br /><br />Dit is de resultatenpagina met de grafische plot van de statistieken uit uw database, zoals gedefinieerd door de invoer op de vorige pagina.";
$pgv_lang["help_statistics.php"]			= "~statistieken diagram~<br /><br />Op deze pagina kunt u de criteria bepalen voor het grafisch weergeven van verschillende statistieken uit uw database.";
$pgv_lang["stat_help"]						= "~OPTIES VOOR STATISTISCHE diagrammen~<br /><br />Een aantal verschillende diagrammen van statistieken uit het databestand kunnen worden geproduceerd.<br /><br />Selecteer het diagram, pas vervolgens de opties aan n.b.v. de keuzelijsten.<br /><br />De aantallen in elke plot hangen af van de beschikbare gegevens. Bijvoorlbeeld: personen, zonder een aanwezige geboortemaand, (bijv.: alleen maar 1856) kunnen niet worden opgenomen in een diagram van Geboorten per maand.";
$pgv_lang["stat_help_x"]					= "~OPTIES VOOR statistische diagrammen~<br />~X AS~<br /><br />De volgende opties zijn beschikbaar voor de X as (horizontaal). Elk zal dan worden getoond volgens de opties, zoals deze zijn ingesteld voor de Y en Z assen.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_11_mb]#</b>&nbsp;&nbsp;&nbsp;personen, geboren per maand.<br /><b>#pgv_lang[stat_12_md]#</b>&nbsp;&nbsp;&nbsp;personen, overleden per maand.<br /><b>#pgv_lang[stat_13_mm]#</b>&nbsp;&nbsp;&nbsp;huwelijken, die voorkwamen per maand<br /><b>#pgv_lang[stat_14_mb1]#</b>&nbsp;&nbsp;&nbsp;het aantal eerst-geborenen voor elk gezin, per maand.<br /><b>#pgv_lang[stat_15_mm1]#</b>&nbsp;&nbsp;&nbsp;het aantal eerste huwelijken, per maand.<br /><b>#pgv_lang[stat_16_mmb]#</b>&nbsp;&nbsp;&nbsp;het aantal maanden tussen huwelijk en de geboorte van het eerste kind van het paar.<br /><b>#pgv_lang[stat_17_arb]#</b>&nbsp;&nbsp;&nbsp;leeftijd bij overlijden, gerelateerd aan de tijdsperiode, waarin het geboortejaar van elke persoon valt.<br /><b>#pgv_lang[stat_18_ard]#</b>&nbsp;&nbsp;&nbsp;leeftijd bij overlijden, gerelateerd aan de tijdsperiode, waarin het jaar van overlijden valt, van elke persoon.<br /><b>#pgv_lang[stat_19_arm]#</b>&nbsp;&nbsp;&nbsp;de gemiddelde leeftijd van personen, ten tijde van hun huwelijk.<br /><b>#pgv_lang[stat_20_arm1]#</b>&nbsp;&nbsp;&nbsp;de gemiddelde leeftijd van personen, ten tijde van hun eerste huwelijk.<br /><b>#pgv_lang[stat_21_nok]#</b>&nbsp;&nbsp;&nbsp;gemiddelde grootte van de gezinnen.<br /><b>#pgv_lang[stat_1_map]#</b>&nbsp;&nbsp;&nbsp;plaatsin van alle personen of personen met een bepaalde naam, per land.<br /><b>#pgv_lang[stat_2_map]#</b>&nbsp;&nbsp;&nbsp;het aantal geboorten, per land.<br /><b>#pgv_lang[stat_4_map]#</b>&nbsp;&nbsp;&nbsp;het aantal huwelijken, per land.<br /><b>#pgv_lang[stat_3_map]#</b>&nbsp;&nbsp;&nbsp;het aantal sterfgevallen, per land.<br /><b>#pgv_lang[stat_9_indi]#</b>&nbsp;&nbsp;&nbsp;taartdiagram van personen met bronnen.<br /><b>#pgv_lang[stat_8_fam]#</b>&nbsp;&nbsp;&nbsp;taartdiagram van gezinnen met bronnen.</p>";
$pgv_lang["stat_help_y"]					= "~OPTIES VOOR statistische diagrammen~<br />~Y AS~<br /><br />De volgende opties zijn beschikbaar voor de Y as (vertikaal). Deze opties wijzigen de wijze waarop de onderdelen worden getoond langs de X as.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_201_num]#</b>&nbsp;&nbsp;&nbsp;toont het aantal personen van elke categorie, zoals opgegeven voor de X as.<br /><b>#pgv_lang[stat_202_perc]#</b>&nbsp;&nbsp;&nbsp;bereknt en toont de verhoudingen van elk item in de X as categorie.</p>";
$pgv_lang["stat_help_z"]					= "~OPTIES VOOR statistische diagrammen~<br />~Z AS~<br /><br />De volgende opties zijn beschikbaar voor de Z as. Deze opties geven een onderverdeling van de geselecteerde categories langs de X as.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_300_none]#</b>&nbsp;&nbsp;&nbsp;toont de items in een aparte kolom voor elke X as categorie.<br /><b>#pgv_lang[stat_301_mf]#</b>&nbsp;&nbsp;&nbsp;toont de items in 2 kolommen (man en vrouw) voor elke X as categorie.<br /><b>#pgv_lang[stat_302_cgp]#</b>&nbsp;&nbsp;&nbsp;toont de items in een aantal kolommen, gerelateerd aan de tijdperiodes, ingesteld in de volgende sectie, voor elke X as categorie.</p>";
$pgv_lang["stat_help_gwx"]					= "~OPTIES VOOR STATISTISCHE diagrammen~<br />~grenzen voor X-as~<br /><br />Selecteer het gewenste leeftijdsinterval.<br /><br />Bijvoorbeeld, <b>#pgv_lang[aft_marr]#</b> beschrijft de volgende reeks maandbereiken:<div style=\"padding-left:30px;\">voor het huwelijk<br />uit het huwelijk tot 8 maanden daarna<br />van 8 tot 12<br />van 12 tot 15<br />van 15 tot 18<br />van 18 tot 24<br />van 24 tot 48<br />meer dan 48 maanden na het huwelijk</div><br />Als je kwartalen wilt laten zien, moet je kiezen <b>#pgv_lang[quarters]#</b>.";
$pgv_lang["stat_help_gax"]					= "~OPTIES VOOR STATISTISCHE diagrammen~<br />~grenzen voor X-as~<br /><br />Selecteer het gewenste leeftijdsinterval.<br /><br />Bijvoorbeeld, <b>interval 10 jaar</b> beschrijft de volgende reeks leeftijdscategorieën:<div style=\"padding-left:30px;\">jonger dan een jaar<br />een jaar tot 5 jaar<br />6 tot 10<br />11 tot 20<br />21 tot 30<br />31 tot 40<br />41 tot 50<br />51 tot 60<br />61 tot 70<br />71 tot 80<br />81 tot 90<br />91 tot 100<br />ouder dan 100 jaar</div>";
$pgv_lang["stat_help_gbx"]					= "~OPTIES VOOR STATISTISCHE diagrammen~<br />~grenzen voor X-as~<br /><br />Selecteer het gewenste leeftijdsinterval.<br /><br />Bijvoorbeeld, <b>interval 2 jaar</b> beschrijft de volgende reeks leeftijdscategorieën:<div style=\"padding-left:30px;\">jonger dan 16 jaar<br />16 tot 18<br />19 tot 20<br />21 tot 22<br />23 tot 24<br />25 tot 26<br />27 tot 28<br />29 tot 30<br />31 tot 32<br />33 tot 35<br />36 tot 40<br />41 tot 50<br />ouder dan 50 jaar</div>";
$pgv_lang["stat_help_gcx"]					= "~OPTIES VOOR STATISTISCHE diagrammen~<br />~grenzen voor X-as~<br /><br />Selecteer het gewenste telinterval.<br /><br />Bijvoorbeeld, <b>interval één kind</b> beschrijft de volgende reeks bereiken van het aantal kinderen:<div style=\"padding-left:30px;\">zonder kinderen<br />een kind<br />twee kinderen<br />3, 4, 5, 6, 7, 8, 9, 10 kinderen<br />meer dan 10 kinderen</div>";
$pgv_lang["stat_help_gwz"]					= "~OPTIES VOOR STATISTISCHE diagrammen~<br />~grenzen voor Z-as~<br /><br />Selecteer het gewenste startjaar en interval<br /><br />Bijvoorbeeld, <b>vanaf 1700 interval 50 jaar</b> beschrijft de volgende reeks datumbereiken:<div style=\"padding-left:30px;\">vóór 1700<br />1700 tot 1749<br />1750 tot 1799<br />1800 tot 1849<br />1850 tot 1899<br />1900 tot 1949<br />1950 tot 1999<br />2000 of hoger</div>";
$pgv_lang["chart_type_help"]				= "~OPTIES VOOR STATISTISCHE diagrammen~<br /><br />Selecteer wat u op de kaart wilt zien. Je kan kiezen:<div style=\"padding-left: 25px\"><b>#pgv_lang[indi_distribution_chart]#</b>&nbsp;&nbsp;&nbsp;toont de landen waarin personen uit deze database voorkomen.<br /><b>#pgv_lang[surname_distribution_chart]#</b>&nbsp;&nbsp;&nbsp;toont de landen waarin de opgegeven achternaam voorkomt.</div>";
$pgv_lang["google_chart_surname_help"]		= "~OPTIES VOOR STATISTISCHE diagrammen~<br /><br />Het aantal keren dat de opgegeven naam voorkomt, wordt op de kaart weergegeven. Als u dit veld leeg laat, wordt de meest voorkomende achternaam gebruikt.";
$pgv_lang["chart_area_help"]				= "~OPTIES VOOR STATISTISCHE diagrammen~<br /><br />Selecteer het geografische gebied dat u op de kaart wilt zien. Je kan kiezen:<div style=\"padding-left: 25px\"><b>#pgv_lang[world_chart]#</b>&nbsp;&nbsp;&nbsp;toont alle continenten.<br /><b>#pgv_lang[europe_chart]#</b>&nbsp;&nbsp;&nbsp;toont Europa.<br /><b>#pgv_lang[s_america_chart]#</b>&nbsp;&nbsp;&nbsp;toont Zuid-Amerika.<br /><b>#pgv_lang[asia_chart]#</b>&nbsp;&nbsp;&nbsp;toont Azië.<br /><b>#pgv_lang[middle_east_chart]#</b>&nbsp;&nbsp;&nbsp;toont het Midden-Oosten.<br /><b>#pgv_lang[africa_chart]#</b>&nbsp;&nbsp;&nbsp;toont Afrika.</div>";

//-- Find Media Help
$pgv_lang["manage_media_help"]			= "~#pgv_lang[manage_media]#~<br /><br />Op deze pagina kunt u eenvoudig uw mediabestanden en mappen beheren.<br /><br />Wanneer u nieuwe Media submappen aanmaakt, zal PhpGedView ervoor zorgen dat de identieke mapstructuur behouden blijft in de <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs</b> map. Wanneer u nieuwe mediabestanden uploadt, kan PhpGedView automatisch de miniaturen voor u maken.<br /><br />Naast elke afbeelding in de medialijst vindt u de volgende opties. De feitelijk weergegeven opties zijn afhankelijk van de huidige status van het mediabestand.<ul><li><b>#pgv_lang[edit]#</b>&nbsp;&nbsp;&nbsp;Als u op deze optie klikt, ziet u een pagina waar u de titel van het mediaobject kunt wijzigen. Als het Media-object nog niet is gekoppeld aan een persoon, familie of bron in de momenteel actieve database, kunt u deze link hier tot stand brengen. U kunt het bestand hernoemen of zelfs de locatie ervan wijzigen in de mapstructuur <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Indien nodig maakt PhpGedView automatisch de vereiste submappen of ontbrekende miniaturen.</li><li><b>#pgv_lang[edit_raw]#</b>&nbsp;&nbsp;&nbsp;Deze optie is alleen beschikbaar als de beheerder deze heeft ingeschakeld. U kunt de onbewerkte GEDCOM-gegevens die aan dit media-object zijn gekoppeld, bekijken of bewerken. U moet heel voorzichtig zijn wanneer u deze optie gebruikt.</li><li><b>#pgv_lang[delete_file]#</b>&nbsp;&nbsp;&nbsp;Met deze optie kunt u alle kennis van het mediabestand uit de huidige database wissen. Andere databases worden niet beïnvloed. Als dit mediabestand niet in een andere database wordt vermeld, wordt het, en de bijbehorende miniatuur, verwijderd.</li><li><b>#pgv_lang[remove_object]#</b>&nbsp;&nbsp;&nbsp;Met deze optie kunt u alle kennis van het mediabestand uit de huidige database wissen. Andere databases worden niet beïnvloed. Het mediabestand en de bijbehorende miniatuur worden niet verwijderd.</li><li><b>#pgv_lang[remove_links]#</b>&nbsp;&nbsp;&nbsp;Met deze optie kunt u alle links naar het media-object uit de huidige database verwijderen. Het bestand wordt niet verwijderd en het mediaobject waarmee dit bestand bekend is in de huidige database, blijft behouden. Andere databases worden niet beïnvloed.</li><li><b>#pgv_lang[set_link]#</b>&nbsp;&nbsp;&nbsp;Met deze optie kunt u koppelingen tot stand brengen tussen het mediabestand en personen, families of bronnen van de huidige database. Indien nodig zal PhpGedView ook het Media-object creëren waarmee het Mediabestand bekend is bij de database.</li><li><b>#pgv_lang[gen_thumb]#</b>&nbsp;&nbsp;&nbsp;Als u deze optie selecteert, zal PhpGedView de ontbrekende miniatuur maken.</li></ul>";
$pgv_lang["simple_filter_help"]				= "~#pgv_lang[filter]#~<br /><br />Eenvoudig zoekfilter op basis van de ingevoerde letters. Jokertekens (* en ?) kunnen niet worden gebruikt.";
$pgv_lang["show_thumb_help"]				= "~#pgv_lang[show_thumbnail]#~<br /><br />Indien deze keuze wordt ingeschakeld, worden miniweergaves bij de bestandsnamen getoond.";
$pgv_lang["find_media_help"]				= "~#pgv_lang[find_media]#~<br /><br />Hiermee kunt u door de mappenstructuur zoeken om het multimedia-bestand te vinden waarmee u een koppeling wilt maken.";

//-- Add / Edit Media Help
$pgv_lang["add_media_linkid"]				= "~Link ID~<br /><br />Elk media item zou geassocieerd moeten zijn met een of meer personen, gezin, of bronin uw database.<br /><br />Om zo'n link te maken, kunt het  ID van de persoon, gezin, of bron invoeren, of er naar zoeken, op het moment dat u het media item maakt.  U kunt de link echter ook later maken bij de Wijzigen Opties van de  Beheer MultiMedia pagina. Ook heeft u op de Personen, Gezinnen of Bronnen pagina's de mogelijkheid om met  Media Toevoegen dit te doen.";
$pgv_lang["upload_server_file_help"]		= "~#pgv_lang[server_file]#~<br /><br />Het media bestand, dat u gaat uploaden, kan anders heten op onze server, dan op uw lokale computer. Dit is omdat de naam van een lokaal bestand voor u wel duidelijk is, maar voor bezoekers van onze site weinig betekenis heeft.  Denk ook aan de mogelijkheid dat u, en eveneens iemand anders, een bestand probeert te uploaden, die de naam heeft \"Oma.jpg\".<br /><br />In dit veld geeft u de nieuwe naam op van het bestand dat u wilt uploaden.  De naam, die u hier opgeeft, wordt ook gebruikt om het miniweergavebestand te benoemen. Het miniweergavebestand kan apart worden ge-upload, maar ook automatisch worden gegenereerd.  U hoeft de bestandsnaamextensie (jpg, gif, pdf, doc, etc.) niet in te voeren<br /><br />Vul dit veld niet in, om de orginele naam, van het bestand dat u wilt uploaden van uw lokale computer, te behouden.";
$pgv_lang["upload_server_folder_help"] 	= "~#pgv_lang[server_folder]#~<br /><br />De beheerder heeft maximaal #GLOBALS[MEDIA_DIRECTORY_LEVELS]# mapniveaus ingeschakeld onder de standaard <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Dit helpt bij het organiseren van de mediabestanden en vermindert de kans op naambotsingen.<br /><br />In dit veld specificeert u de bestemmingsmap waar het geüploade mediabestand moet worden opgeslagen. Het overeenkomende miniatuurbestand, afzonderlijk geüpload of automatisch gegenereerd, wordt opgeslagen in een vergelijkbare mapstructuur, beginnend bij <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> in plaats van <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. U hoeft het <b>#GLOBALS[MEDIA_DIRECTORY]#</b> gedeelte van de naam van de bestemmingsmap niet in te voeren.<br /><br />Als u niet zeker weet wat u hier moet invoeren, dient u voor advies contact op te nemen met uw sitebeheerder.";
$pgv_lang["view_server_folder_help"]		= "~#pgv_lang[server_folder]#~<br /><br />De beheerder heeft, voor het opslaan van de mediabestanden, tot  #GLOBALS[MEDIA_DIRECTORY_LEVELS]# map-nivo's dieper dan de standaardmap <b>#GLOBALS[MEDIA_DIRECTORY]#</b> ingesteld. Dit helpt om de media bestanden te organiseren en problemen met eventuele gelijknamige bestanden te voorkomen.<br /><br />In dit veld selecteert u de media map, waarvan u de inhoud wilt bekijken. Als u <b>#pgv_lang[all]#</b> selecteert, zullen alle media bestanden worden getoond, ongeacht de map waarin ze zijn opgeslagen.  Hierdoor zou wel een lange lijst met media item kunnen ontstaan.";

//--Repository Help
$pgv_lang["help_repolist.php"]			= "~#pgv_lang[repo_list]#~<br /><br />Op deze pagina wordt een lijst met bewaarplaatsen weergegeven. <br /> <br /> De namen van de bewaarplaatsen zijn in alfabetische volgorde gesorteerd.<br /><br /><b>BEWAARPLAATSEN</b><br />Zonder bewaarplaatsen kunnen we onze database niet bouwen. Er is een bron voor alle informatie die in de database is opgeslagen, en die bron wordt bewaard in een bewaarplaats. Bewaarplaatsen kunnen het persoonlijke archief zijn van een persoon, een instelling, een openbare database, een overheids- of kerkelijke archiefbureau, een internetbron, enz. Om toegang te krijgen tot een bron zullen we willen weten waar en op welke plaats deze is. Alle benodigde informatie om een bron te vinden, moet worden opgeslagen in het bewaarplaats-record.<br /><br />Een bewaarplaats kan aan veel bronnen worden gekoppeld.";
$pgv_lang["help_repo.php"]					= "~DETAILS BEWAARPLAATS~<br /><br />Bewaarplaatsen zijn, samen met bronnen, belangrijk in genealogisch onderzoek omdat ze informatie in een stamboom controleerbaar en reproduceerbaar maken. Op die manier kunnen andere onderzoekers op een verantwoorde manier van de gegevens gebruik maken.<br /><br />Op deze pagina ziet u de detailgegevens van de bewaarplaats zoals adres, e-mailadres, internet pagina en telefoonnummer.<br /><br />Onder de details van de bewaarplaats wordt een lijst met bronnen getoond die verwijzen naar deze bewaarplaats.<br /><br />Als de beheerder van de site dit mogelijk heeft gemaakt, ziet u aan de rechterzijde van het scherm nog twee koppelingen:<ul><li><b>#pgv_lang[view_gedcom]#</b>, waarmee u in een apart venster de gegevens van de bewaarplaats in GEDCOM-formaat kunt zien, en</li><li><b>#pgv_lang[add_to_cart]#</b>, waarmee u de GEDCOM-gegevens van de bron in uw #pgv_lang[clip_cart]# kunt opslaan. Later kunt u ze downloaden naar uw eigen machine en ze daar importeren in uw genealogiepakket.</li></ul><br />#pgv_lang[more_help]#";
$pgv_lang["delete_repo_help"]				= "~#pgv_lang[delete_repo]#~<br /><br />Door deze optie aan te klikken, markeert u een bewaarplaats voor verwijdering uit de genealogie.<br /><br />Wat betekent dat nu? Laten we aannemen dat u een goede reden heeft om deze bewaarplaats uit de genealogie te verwijderen. U klikt op de koppeling. Daarna verschijnt er een venster, waarin u wordt gevraagd of u er zeker van bent, of dat u de bewerking wilt annuleren. De bewaarplaats zal echter nog steeds zichtbaar en raadpleegbaar zijn.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["show_repo_gedcom_help"]			= "~#pgv_lang[view_gedcom]#~<br /><br />Door op deze koppeling te klikken, krijgt u de informatie over deze bewaarplaats in GEDCOM-formaat te zien.";
$pgv_lang["add_repository_clip_help"]		= "~#pgv_lang[add_to_cart]#~<br /><br />Door op deze koppeling te klikken, worden de gegevens van deze bewaarplaats toegevoegd aan de knipselbak.";
$pgv_lang["repolist_listbox_help"]			= "~#pgv_lang[repo_list]#~<br /><br />In dit vak ziet u een overzicht van bewaarplaatsen die voorkomen in deze genealogie. De titels worden weergegeven in alfabetische volgorde.<br /><br />Als u op een bewaarplaats klikt, worden de detailgegevens getoond, evenals een lijst met bronnen die aan de bewaarplaats zijn gekoppeld.";
$pgv_lang["repos_listbox_help"]				= "~#pgv_lang[other_repo_records]#~<br /><br />In dit vak ziet u alle bronnen, die aan deze bewaarplaats zijn gekoppeld. De namen worden in alfabetische volgorde weergegeven.<br /><br />Als u op een bron klikt, krijgt u de details ervan te zien.";

// Index-Edit
$pgv_lang["block_move_up_help"]				= "~Verplaats vakken~<br /><br />Gebruik deze knoppen om de volgorde van de vakken in de lijst aan te passen. De vakken worden weergegeven in de volgorde zoals ze in de lijst staan.<br /><br />Markeer het item dat u wilt verplaatsen en klik vervolgens op een knop om dat item omhoog of omlaag te verplaatsen.";
$pgv_lang["block_move_right_help"]			= "~Verplaats vakken~<br /><br />Gebruik deze knoppen om een vak van een lijst naar een andere te verplaatsen.<br /><br />Markeer het item dat u wilt verplaatsen en klik vervolgens op een knop om dat item in de richting van de pijl te verplaatsen of te kopiëren. Gebruik de <b>»</b> en <b>«</b> knoppen om het vak van meest links naar meest rechts te verplaatsen en vice versa. Gebruik de <b>&gt;</b> en <b>&lt;</b> knoppen om het vak tussen de lijst #pgv_lang[available_blocks]# list en de lijsten links en rechts te verplaatsen.<br /><br />De lijst met #pgv_lang[available_blocks]# wijzigt niet, ongeacht wat u met de #pgv_lang[move_right]# en #pgv_lang[move_left]# knoppen doet. Ze blijven beschikbaar omdat ze meerdere malen op dezelfde pagina kunnen verschijnen. Het HTML-vak is hiervan een goed voorbeeld.";
$pgv_lang["block_default_index"]			= "~Standaard vakken op de #pgv_lang[welcome]#~<br /><br />Als u alle vakken uit de #pgv_lang[main_section]# en #pgv_lang[right_section]# verwijdert, of als u klikt op de <b>#pgv_lang[reset_default_blocks]#</b> knop, dan wordt de vakindeling als volgt ingesteld:<br /><br /><span class='center'><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><td>#pgv_lang[block_cookiepolicy]#<br />#pgv_lang[gedcom_stats_block]#<br />#pgv_lang[gedcom_news_block]#<br />#pgv_lang[gedcom_favorites_block]#<br />#pgv_lang[review_changes_block]#</td><td>#pgv_lang[gedcom_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[todays_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></span>";
$pgv_lang["block_default_portal"]			= "~Standaard vakken op de #pgv_lang[mygedview]# pagina~<br /><br />Als u alle vakken uit de #pgv_lang[main_section]# en de #pgv_lang[right_section]# verwijdert, of op de knop <b>#pgv_lang[reset_default_blocks]#</b> klikt, worden de vaklijsten als volgt ingesteld:<br /><br /><span class='center'><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><td>#pgv_lang[todays_events_block]#<br />#pgv_lang[user_messages_block]#<br />#pgv_lang[user_favorites_block]#<br />&nbsp;</td><td>#pgv_lang[welcome_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[upcoming_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></span>";

// FAQ page
$pgv_lang["help_faq.php"]					= "~Veel Gestelde Vragen~<br /><br />#pgv_lang[text_faq_help]#";
$pgv_lang["text_faq_help"]					= "De VGV (Veel Gestelde Vragen) pagina kan een overzicht, of lijst, met vragen en antwoorden bevatten over het gebruik van deze genealogie site.<br />Vaak zijn er vragen die regelmatig in, min of meer, dezelfde vorm terugkomen.<br /><br />Het gebruik en de inrichting van deze VGV pagina is geheel in handen van de site beheerder. De beheerder bepaalt de inhoud van elk onderwerp en tevens de volgorde, waarin deze worden weergegeven.";

// Help search
$pgv_lang["hs_title_help"]					= "<span class='center'>~#pgv_lang[hs_title]#~</span><br />#pgv_lang[hs_intro]#<br /><br />#pgv_lang[hs_keyword_advice]#<br /><br />#pgv_lang[hs_searchhow_advice]#<br /><br />#pgv_lang[hs_searchin_advice]#";
$pgv_lang["hs_intro"]						= "U kunt het hele PhpGedView's Help systeem doorzoeken.  De #pgv_lang[hs_title]# mogelijkheid geeft u in hoge mate controle over de wijze waarop u kunt zoeken; u kunt gemakkelijk bijna alles vinden wat u zoekt.";
$pgv_lang["hs_keyword_advice"]				= "~#pgv_lang[hs_keyword]#~<br /><br />U voert de woorden, of (gedeelte van) een zin in, die u wilt vinden.<br /><br />Het zoeksysteem is Hoofdletter-ongevoelig. Dat betekent dat het niet uitmaakt of u hoofd- of kleine- letters invoert of zoekt.  Als u zoekt naar  <b>Individual</b>, zult u tekst vinden die het volgende kan bevatten: <b>Individual</b>, <b>individual</b>, of <b>INDIVIDUAL</b>.  Ook tekst, die <b>individuals</b>, bevat, zal worden gevonden, enz. Dit komt omdat meer naar de opeenvolging van letters wordt gekeken, dan naar woorden.<br /><br />U kunt het zoeksysteem naar verschillende woorden in een keer laten zoeken.  Voer de woorden, gescheiden door een spatie, als volgt in: <b>persoon&nbsp;gezin&nbsp;kind</b>.  Als meer dan een woord is ingevoerd, wordt de bedoeling van wat u heeft ingetypt verduidelijkt in het veld #pgv_lang[hs_searchhow]#.";
$pgv_lang["hs_searchin_advice"]				= "~#pgv_lang[hs_searchin]#~<br /><br />U bepaalt hier, waarin moet worden gezocht.<br /><br />Beheerders hebben de keus om te zoeken in Help bestanden voor Gebruikers, of die voor de Configuratie, of beide. Gebruikers hebben die keuze niet. Omdat gebruikers geen toegang hebben tot de configuratie mogelijkheden, kunnen ze alleen  zoeken in de Help bestanden voor gebruikers.<br /><br />De Help bestanden bevatten niet alleen de Help teksten, maar ook zekere tekst strings die bijv. worden gebruikt om invoerformulieren en diverse andere pagina's samen te stellen.  Deze optie laat u bepalen of alleen weer te geven Help teksten moeten worden doorzocht, of het complete Help bestand.";
$pgv_lang["hs_searchhow_advice"]			= "~#pgv_lang[hs_searchhow]#~<br /><br />U verduidelijkt hier hoe er moet worden gezocht naar hetgeen u heeft ingevoerd in het veld \"#pgv_lang[hs_keyword]#\" (als u meer dan een woord heeft ingevoerd), door een van de onderstaande mogelijkheden te kiezen:<br /><dl><dt><b>#pgv_lang[hs_searchany]#</b></dt><dd>Als u heeft ingevoerd: <b>persoon&nbsp;gezin&nbsp;kind</b>, zal deze optie de Help tekst  laten zoeken, die een van deze woorden bevat.  De volgorde van de woorden is niet belangrijk.  De betekenis van de zoekopdracht is: «Vindt Helptekst die het volgende bevat: <b>persoon</b> <u>of</u> <b>gezin</b> <u>of</u> <b>kind</b>».</dd><dt><b>#pgv_lang[hs_searchall]#</b></dt><dd>Als u heeft ingevoerd: <b>persoon&nbsp;gezin&nbsp;kind</b>, zal deze optie de Help tekst laten zoeken, die al deze woorden bevat.  De volgorde van de woorden is niet belangrijk. De betekenis van de zoekopdracht is: «Vindt Helptekst die het volgende bevat: <b>persoon</b> <u>en</u> <b>gezin</b> <u>en</u> <b>kind</b>».</dd><dt><b>#pgv_lang[hs_searchsentence]#</b></dt><dd>Als u heeft ingevoerd: <b>persoon&nbsp;gezin&nbsp;kind</b>, zal deze optie de Help tekst laten zoeken, die al deze woorden bevat, in de volgorde waarin deze woorden zijn ingevoerd.  De betekenis van de zoekopdracht is: «Vindt Helptekst die het volgende bevat: <b>persoon&nbsp;gezin&nbsp;kind</b> in exact die volgorde en geen woorden of letters daartussen».  (Hoogstwaarschijnlijk zult u dit voorbeeld niet in de Helpteksten vinden).</dd></dl><br />Er zijn een paar beperkingen aan deze wijze van zoeken.  Sommige speciale karakters (zoals bijv. <b>&quot; &lt; &gt;</b> etc.) staan wel in de weergegeven helptekst, maar in de database staan ze niet als zodanig vermeld, maar in symbolische vorm. Als u dus tekst invoert die bepaalde speciale tekens bevat, zal de tekst niet worden gevonden. Het is beter deze tekens te vermijden in de zoektekst.  Ook kan Helptekst Spaties bevatten, die in de database zijn opgeslagen als <b>&amp;nbsp;</b> uitdrukkingen waarin zo'n spatie is gebruikt, zult u dan ook niet vinden.";

// Directory cleanup tool
$pgv_lang["help_dir_editor.php"]			= "~#pgv_lang[index_dir_cleanup]#~<br /><br />Dit hulpprogramma kan site beheerders help om bestanden op te ruimen in de Index map.<br /><br />Na verloop van tijd kunnen er steeds meer bestanden, zoals log bestanden, oude GEDCOM bestanden en oude backup bestanden, bij komen in de Index map. Omdat  veel van deze bestanden worden gemaakt door het programma, kunnen ze eigendom zijn van de web server gebruiker.  En zal ze dan eigendom zijn van de web server gebruiker, zou het kunnen zijn dat u ze niet kunt wissen. Dit hulpprogramma kan de bestande wel wissen, ondanks dat ze eigendom kunnen zijn van de web server gebruikers account.<br /><br />#pgv_lang[index_dir_cleanup_inst]#";

// Various quotes -- The actual text is in help_text.en.php
//$pgv_lang["quote_gedcom"]						= "";
//$pgv_lang["quote_gramps"]						= "";
?>
