<?php
/**
 * Portugese Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2024  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author Maurício Menegazzo Rosa
 * @author Anderson Wilson and Clovis Bombardelli
 * @version $Id: help_text.pt.php 7378 2024-11-02 14:25:09Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["useradmin_comment_help"]	= "~#pgv_lang[comment]#~<br /><br />O texto inserido aqui será exibido quando o ponteiro do mouse passar sobre o ícone Texto na lista de usuários. Você deve tentar manter este texto o mais breve possível.";
$pgv_lang["useradmin_comment_exp_help"]	= "~#pgv_lang[comment_exp]#~<br /><br />Insira a data após a qual o registro deste usuário deve ser tratado como exigindo inspeção pelo Administrador. Esses registros são destacados na lista de usuários exibindo o nome do usuário em <span class='warning'>vermelho</span>.<br /><br />A data deve ser inserida em inglês. Exemplos: <b>31&nbsp;DEC&nbsp;2020</b> ; <b>31&nbsp;december&nbsp;2020</b> ; <b>2020.12.31</b> ; <b>31-12-2020</b> ; <b>12/31/2020</b> etc.<br /><br />Quando o número do mês e o número do dia estão no intervalo de 1 a 12, a pontuação (traço ou barra) determina o significado, com um traço <b>-</b> significando que o primeiro número é o dia do mês, enquanto uma barra <b>/</b> significa que o primeiro número é o mês.<br /><br />Se a informação inserida aqui não fizer sentido para o programa, «yesterday» será usado e este registro do usuário sempre será selecionado para destaque. «tomorrow» e textos semelhantes não são significativos neste contexto e farão com que este registro do usuário nunca seja seleccionado para realce.";
$pgv_lang["file_type_help"]						= "~#pgv_lang[choose_file_type]#~<br /><br />Escolha o formato no qual a exportação do banco de dados deve ser criada. Sua escolha depende dos requisitos e recursos do programa para o qual você pretende importar o arquivo recém-baixado. Você pode escolher:<br /><ul><li>#pgv_lang[def_gedcom_help]#</li><br /><br /><li>#pgv_lang[def_gramps_help]#</li></ul>";
$pgv_lang["apply_privacy_help"]					= "~#pgv_lang[apply_privacy]#~<br /><br />Quando esta opção é marcada, o arquivo de saída passará por verificações de privacidade de acordo com a opção selecionada. Isso pode resultar na remoção de certas informações. O arquivo de saída conterá apenas as informações que normalmente são visíveis para um usuário com o nível de privilégio indicado.<br /><br />Se você tiver apenas direitos #pgv_lang[gedadmin]#, não poderá especificar que o arquivo de saída deve ser privatizado de acordo com o nível de privilégio #pgv_lang[siteadmin]#";
$pgv_lang["convertPath_help"]					= "~#pgv_lang[convertPath]#~<br /><br />Esta opção define um caminho constante a ser prefixado para todos os caminhos de mídia no arquivo de saída.<br /><br />Por exemplo, se o diretório de mídia foi configurado para ser \"/media\" e se o arquivo de mídia que está sendo exportado tem um caminho \"/media/fotos/xyz.jpg\" e você inseriu \"c:\\minhas fotos\\minha família\" neste campo, o caminho de mídia resultante será \"c:\\minhas fotos\\minha família/fotos/xyz.jpg\".<br /><br />Você notará neste exemplo:<ul><li>o nome do diretório de mídia atual é retirado do caminho</li><li>e o caminho resultante não terá separadores de nome de pasta corretos.</li></ul><br />Se desejar manter o diretório de mídia nos caminhos de arquivo de mídia do arquivo de saída, você precisará incluir esse nome no campo <b>#pgv_lang[convertPath]#</b>.<br /><br />Você também deve usar a opção <b>#pgv_lang[convertSlashes]#</b> para garantir que os separadores de nome de pasta sejam consistentes e concordem com os requisitos do sistema operacional receptor.<br /><br />Caminhos de mídia que são realmente URL não serão alterados.";
$pgv_lang["convertSlashes_help"]				= "~#pgv_lang[convertSlashes]#~<br /><br />Esta opção determina se os nomes das pastas na especificação FILE de objetos de mídia devem ser separados por barras ou barras invertidas. Sua escolha depende dos requisitos do sistema operacional receptor.<br /><br />A escolha <b>#pgv_lang[forwardSlashes]#</b> é apropriada para a maioria dos sistemas operacionais diferentes do Microsoft Windows. A escolha <b>#pgv_lang[backSlashes]#</b> deve ser usada quando o programa de destino está sendo executado em um sistema Microsoft Windows.<br /><br />Caminhos de mídia que são realmente URL não serão alterados.";
$pgv_lang["medialist_recursive_help"]			= "~#pgv_lang[medialist_recursive]#~<br /><br />Quando esta opção é selecionada, o #pgv_lang[multi_title]# irá pesquisar não apenas o diretório selecionado na lista #pgv_lang[filter]#, mas também todos os seus subdiretórios. Quando esta opção não é selecionada, apenas o diretório selecionado é pesquisado.<br /><br />Os títulos de todos os objetos de mídia encontrados são examinados para determinar se eles contêm o texto inserido no #pgv_lang[filter]#. O resultado dessas duas ações determina os objetos multimídia a serem listados.";
$pgv_lang["medialist_unlinked_help"]			= "~#pgv_lang[medialist_unlinked]#~<br /><br />Apenas mídias que não estejam vinculadas a nenhum registro GEDCOM serão mostradas.";
$pgv_lang["medialist_current_dir_help"]			= "~#pgv_lang[medialist_current_dir]#~<br /><br />Selecione o subdiretório de mídia que deseja visualizar.";
$pgv_lang["sortby_help"]						= "~#pgv_lang[sortby]#~<br /><br />Selecione a ordem em que deseja ver a lista.";
$pgv_lang["help_treenav.php"]					= "~#pgv_lang[interactive_tree]#~<br /><br />Use #pgv_lang[interactive_tree]# para ver toda a árvore genealógica de uma pessoa em ambas as direções. Esta visualização é semelhante à visualização Ampulheta, pois mostra ancestrais e descendentes de uma determinada pessoa raiz. Este gráfico oferece uma visão mais compacta, mostrando caixas para casais ou famílias em vez de apenas pessoas.<br /><ul><li><b>Rolando</b><br />Sempre que o cursor do mouse muda para um ícone Mover, você pode clicar e arrastar a árvore genealógica para ver outras partes da árvore genealógica. Conforme você arrasta a árvore genealógica, as gerações futuras se expandem automaticamente até que não haja mais gerações para ver nessa direção.<br /></li><li><b>Zoom</b><br />Você pode usar os ícones à esquerda da árvore genealógica para aumentar e diminuir o zoom. Diminuir o zoom permitirá que você veja mais da árvore genealógica na tela por vez. Conforme você diminui o zoom, o texto pode se tornar difícil de ler; quando o mouse passa sobre uma caixa, você terá uma visão ampliada do que está dentro dela.<br /></li><li><b>Detalhes de expansão</b><br />Clicar em qualquer caixa irá expandir a caixa e exibir uma visão mais detalhada. No modo expandido, clicar no nome de uma pessoa abrirá sua página #pgv_lang[indi_info]#. Clicar em <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> irá redesenhar a árvore genealógica com essa pessoa como a nova raiz. Clicar em <<img src='#GLOBALS[PGV_IMAGE_DIR]#/buttons/family.gif' alt='' /> levará você para a página de detalhes dessa família.<br /></li><li><b>Alternar cônjuges</b><br />O ícone <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/sfamily.gif' width='15px' height='15px' alt='' /> diretamente abaixo dos botões de Zoom irá alternar a exibição de todos os cônjuges em ou fora do lado da descendência. Quando o visor está definido para mostrar os cônjuges, todos os cônjuges de uma pessoa aparecerão na caixa com eles. Todos os filhos da pessoa também serão mostrados. Quando a opção de mostrar os cônjuges está desativada, apenas o último cônjuge da pessoa e os filhos com ele serão mostrados.<br /></li><li><b>Grande Árvore Genealógica</b><br />O #pgv_lang[interactive_tree]# está disponível em muitas páginas diferentes, incluindo a guia Árvore Genealógica na página #pgv_lang[indi_info]# e o bloco de Gráficos na página de Boas-vindas. Ao visualizar a árvore genealógica de uma dessas outras páginas, você também terá um ícone da Árvore Genealógica sob os ícones de Zoom. Se você clicar em <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> você será levado para a página #pgv_lang[interactive_tree]#.</li></ul>";

$pgv_lang["move_mediadirs_help"]				= "~#pgv_lang[move_mediadirs]#~<br /><br />Quando o Firewall de mídia está habilitado, os arquivos multimídia podem ser armazenados em um diretório de servidor que não é acessível pela Internet.<br /><br />Esses botões permitem que você mova facilmente uma estrutura inteira de diretório de mídia entre os protegidos (não endereçável pela web) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> e os diretórios normais <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. ";
$pgv_lang["setperms_help"]						= "~#pgv_lang[setperms]#~<br /><br />Defina recursivamente as permissões nos diretórios protegidos (não endereçável pela web) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> e os diretórios normais <b>#GLOBALS[MEDIA_DIRECTORY]#</b> para gravável mundialmente ou somente leitura.";
$pgv_lang["update_CHAN_text"] 					= "Às vezes, os administradores precisam limpar e corrigir os dados enviados pelos usuários. Por exemplo, eles podem precisar corrigir o local do PLAC para incluir o país. Quando os Administradores fazem essas correções, as informações sobre a alteração original são normalmente substituídas. Isso pode não ser desejável.<br /><br />Quando esta opção é escolhida durante a sessão de edição ou correção do Administrador, o PhpGedView irá reter as informações originais de Mudança ao invés de substituí-las pelas da sessão atual.";
$pgv_lang["config_update_CHAN_help"] 			= "~#pgv_lang[no_update_CHAN]#~<br /><br />Esta opção controla o estado inicial da caixa «#pgv_lang[no_update_CHAN]#» que é mostrada em todas as páginas onde os Administradores podem fazer alterações ou correções no banco de dados genealógico.<br /><br />#pgv_lang[update_CHAN_text]#";
$pgv_lang["no_update_CHAN_help"] 				= "~#pgv_lang[no_update_CHAN]#~<br /><br />#pgv_lang[update_CHAN_text]#";
$pgv_lang["edit_SOUR_EVEN_help"]				= "~#pgv_lang[source_events]#~<br /><br />Cada fonte registra eventos específicos, geralmente para um determinado intervalo de datas e para uma jurisdição local. Por exemplo, um Censo registra eventos de censo e os registros de igreja registram eventos de nascimento, casamento e morte.<br /><br />Selecione os eventos que são registrados por esta fonte na lista de eventos fornecida. A data deve ser especificada em um formato de intervalo, como <i>FROM 1900 TO 1910</i>. A jurisdição do local é o nome da jurisdição mais baixa que abrange todos os locais de nível inferior mencionados nesta fonte. Por exemplo, \"Oneida, Idaho, USA\" seria usado como um local de jurisdição de origem para eventos que ocorrem em várias cidades dentro do condado de Oneida. \"Idaho, USA\" seria o local de jurisdição de origem se os eventos registrados ocorressem não apenas no condado de Oneida, mas também em outros condados de Idaho.";
$pgv_lang["cache_life_help"]					= "~#pgv_lang[cache_life]#~<br /><br />Para melhorar o desempenho, este bloco da página de boas-vindas do PhpGedCom é salvo como um arquivo de cache. Você pode controlar a frequência com que o arquivo de cache deste bloco é atualizado.<br /><ul><li><b>-1</b> significa que o arquivo de cache nunca é atualizado automaticamente. Para obter uma nova cópia, você precisa excluir todos os arquivos de cache. Você pode fazer isso na página Personalizar página de boas-vindas.</li><li><b>0</b> (Zero) significa que este bloco nunca é armazenado em cache e cada vez que o bloco é exibido na página de boas-vindas do PhpGedView, você vê uma nova cópia. Esta configuração é usada automaticamente para blocos que mudam com frequência, como os blocos #pgv_lang[logged_in_users_block]# e #pgv_lang[random_media_block]#.</li><li><b>1</b> (Um) significa que uma nova cópia do arquivo de cache deste bloco é criada diariamente, <b>2</b> significa que uma nova cópia é criada a cada dois dias, <b>7</b> significa que uma nova cópia é criada semanalmente, etc.</li></ul>";
$pgv_lang["clear_cache_help"]					= "~#pgv_lang[clear_cache]#~<br /><br />A fim de melhorar o desempenho, vários dos blocos na página de boas-vindas do PhpGedView são salvos como arquivos de cache no diretório de índice. Os arquivos de cache para a maioria dos blocos são atualizados uma vez por dia, mas pode haver momentos em que você deseja atualizá-los manualmente.<br /><br />Este botão permite que você atualize os arquivos de cache quando necessário.";
$pgv_lang["import_options_help"] 				= "Você pode escolher opções adicionais a serem usadas ao importar o GEDCOM.";
$pgv_lang["verify_gedcom_help"]					= "~#pgv_lang[verify_gedcom]#~<br /><br />Aqui, você pode optar por continuar com o upload e importação deste arquivo GEDCOM ou por abortar o upload e importação.";
$pgv_lang["add_gedcom_instructions"]			= "Insira um nome de arquivo para este novo GEDCOM. O novo arquivo GEDCOM será criado no diretório Índice: #INDEX_DIRECTORY#";
$pgv_lang["random_media_start_slide_help"]		= "~#pgv_lang[random_media_start_slide]#~<br /><br />A apresentação de slides deve iniciar automaticamente quando a página é carregada.<br /><br />A apresentação de slides altera o conteúdo do bloco sem pré-carregar informações do servidor e sem recarregar a página inteira.";
$pgv_lang["random_media_ajax_controls_help"]	= "~#pgv_lang[random_media_ajax_controls]#~<br /><br />Você pode usar esta configuração para mostrar ou ocultar os controles da apresentação de slides do bloco de Mídia Aleatória.<br /><br />Esses controles permitem que o usuário pule para outro objeto aleatório ou reproduza mídias selecionadas aleatoriamente, como uma apresentação de slides. A apresentação de slides altera o conteúdo do bloco sem pré-carregar informações do servidor e sem recarregar a página inteira.";
$pgv_lang["edit_add_unlinked_source_help"]		= "~#pgv_lang[add_unlinked_source]#~<br /><br />Use este link para adicionar uma nova Fonte ao banco de dados, sem contudo criar uma referência a ela. Enquanto não for referenciada, a nova Fonte somente aparecerá na Lista de Fontes.";
$pgv_lang["edit_add_unlinked_note_help"]		= "~#pgv_lang[add_unlinked_note]#~<br /><br />Use este link para adicionar uma nova nota compartilhada ao seu banco de dados sem vincular a nota a nenhum registro. A nova nota aparecerá na lista de notas compartilhadas, mas não aparecerá em nenhum gráfico ou em qualquer outro o programa até que esteja vinculado a uma pessoa, família ou evento.";
$pgv_lang["link_person_id_help"]				= "~#pgv_lang[label_local_id]#~<br /><br />Este campo deve conter a ID da pessoa referenciada (ex.: I100).";
$pgv_lang["link_gedcom_id_help"]				= "~#pgv_lang[label_gedcom_id]#~<br /><br />Use esta seção para selecionar a identificação alternativa do banco de dados que faça referência a pessoa desejada.";
$pgv_lang["link_remote_site_help"]				= "~#pgv_lang[label_site]#~<br /><br />Nesta seção você especifica os parâmetros necessários à conexão com o Site Remoto que contém os dados referenciados. Você pode selecionar o Site de uma lista de Sites já conhecidos, ou informando um novo em #pgv_lang[label_site_url2]# e #pgv_lang[label_gedcom_id]#.<br /><br />No campo <b>#pgv_lang[label_site_url2]#</b>, informe a URL de acesso ao arquivo com a descrição dos serviços Web (WDSL), utilizado pelo PhpGedView para acessar os dados no Site Remoto. Exemplo da URL: <u>http://www.remotesite.com/phpGedView/genservice.php?wsdl</u><br /><br />O campo <b>#pgv_lang[label_gedcom_id]#</b> é usado, opcionalmente, para informar uma identificação alternativa do banco de dados para Sites Remotos. Para sites PhpGedView, este é o nome do arquivo GEDCOM.<br /><br />Os campos <b>#pgv_lang[label_username_id]#</b> e <b>#pgv_lang[label_password_id]#</b> só precisam ser informados caso o banco de dados assim o peça.";
$pgv_lang["link_remote_location_help"]			= "~#pgv_lang[label_location]#~<br /><br />Neste campo, informe se os dados da pessoa referenciada estão neste mesmo site, porém em outro banco de dados, ou se os dados desta pessoa estão em um Site Remoto.<br /><br />Se no mesmo site, informe a identicação do banco de dados e da pessoa.<br /><br />Para sites remotos é necessário informar a URL, a identicação do banco de dados e da pessoa.";
$pgv_lang["link_remote_rel_help"]				= "~#pgv_lang[label_rel_to_current]#~<br /><br />Use esta opção para definir o relacionamento da pessoa de um site remoto com a pessoa deste site. Exemplo: selecioando <i>Pai</i> significa que a pessoa do site remoto, é pai da pessoa deste site.";
$pgv_lang["link_remote_help"]					= "~#pgv_lang[link_remote]#~<br /><br />Use este formulário para interligar pessoas deste GEDCOM com pessoas em outros GEDCOMs ou de Sites Remotos.<br /><br />Primeiro selecione o tipo de relacionamento, depois selecione ou informe o Site Remoto, depois informe a ID da pessoa relacionada. O PhpGedView buscará automaticamente as informações do Site Remoto quando necessárias. Estas informações <u>não</u> se tornam parte de seu banco de dados genealógico; elas permanecem no site remoto, porém são incorporadas às páginas que fazem referência a esta pessoa remota.<br /><br />Para mais informações, veja a Ajuda específica ao lado de cada campo ou acesse o tutorial em inglês: <a href=\"http://wiki.phpgedview.net/en/index.php/How_to_Remote_Link\" target=\"_blank\">http://wiki.phpgedview.net/en/index.php/How_to_Remote_Link</a>.";

//-- Edit Interface
$pgv_lang["edit_REPO_NAME_help"]	= "~#factarray[REPO:NAME]#~<br /><br />O nome da biblioteca, arquivo ou outro repositório no qual o material de origem está armazenado.";
$pgv_lang["edit_REPO_ADDR_help"]	= "~#factarray[REPO:ADDR]#~<br /><br />O endereço desta biblioteca, arquivo ou outro repositório. Insira o endereço da mesma forma que escreveria em um envelope.<br /><br />Deixe este campo em branco se não quiser incluir um endereço.";
$pgv_lang["edit_REPO_PHON_help"]	= "~#factarray[REPO:PHON]#~<br /><br />O número de telefone desta biblioteca, arquivo ou outro repositório. Digite o número incluindo o país e o código de área. Por exemplo, um número na Alemanha pode ser +49 25859 56 76 89 e um número nos USA ou Canadá pode ser +1 888 555-1212.<br /><br />Deixe este campo em branco se não quiser incluir um número de telefone.";
$pgv_lang["edit_REPO_FAX_help"]		= "~#factarray[REPO:FAX]#~<br /><br />O número de FAX desta biblioteca, arquivo ou outro repositório. Digite o número incluindo o país e o código de área. Por exemplo, um número na Alemanha pode ser +49 25859 56 76 89 e um número nos USA ou Canadá pode ser +1 888 555-1212.<br /><br />Deixe este campo em branco se não quiser incluir um número de FAX.";
$pgv_lang["edit_REPO_EMAIL_help"]	= "~#factarray[REPO:EMAIL]#~<br /><br />O endereço de e-mail desta biblioteca, arquivo ou outro repositório. Digite o endereço de e-mail. Exemplo: <b>name@hotmail.com</b><br /><br />Deixe este campo em branco se não quiser incluir um endereço de e-mail.";
$pgv_lang["edit_REPO_WWW_help"]		= "~#factarray[REPO:WWW]#~<br /><br />A página inicial da Internet desta biblioteca, arquivo ou outro repositório. Digite o endereço da página inicial, incluindo http:// ou https://. Exemplo: <b>https://www.phpgedview.net/</b><br /><br />Deixe este campo em branco se não quiser incluir um endereço de página inicial.";
$pgv_lang["edit_CALN_help"]			= "~#factarray[CALN]#~<br /><br />Uma identificação ou descrição de referência usada para arquivar e recuperar itens dos acervos de uma biblioteca, arquivo ou outro repositório. Repositórios informais geralmente não precisam usar um sistema #factarray[CALN]#.";
$pgv_lang["edit_REPO_help"]			= "~#factarray[REPO]#~<br /><br />Este é o número de identificação da biblioteca, arquivo ou outro depósito onde o material de origem sendo referenciado está armazenado. O título do arquivo atual será mostrado abaixo do número de identificação.<br /><br />Você pode alterar o número de identificação do arquivo onde este material de origem está armazenado. Para remover a referência do arquivo, deixe este campo em branco. Esta ação não remove o registro do arquivo do banco de dados; apenas a referência é removida.<br /><br />Se você inserir o ID do arquivo desejado diretamente, esse registro do arquivo já deve existir no banco de dados. Você pode clicar <b>#pgv_lang[find_repository]#</b> para pesquisar o número de ID de um arquivo existente. Clique <b>#pgv_lang[create_repository]#</b> se precisar inserir um novo registro de arquivo.";
$pgv_lang["edit_PUBL_help"]			= "~#factarray[PUBL]#~<br /><br />Quando e onde o registro foi criado. Para trabalhos publicados, inclui informações como a cidade de publicação, nome da editora e ano de publicação.<br /><br />Para um trabalho não publicado, deve incluir a data em que o registro foi criado e o local onde foi criado. Por exemplo, o condado e o estado de residência de uma pessoa que faz uma declaração de pensão ou a cidade e o estado de residência do redator de uma carta ou um histórico familiar particular.";
$pgv_lang["edit_AUTH_help"]			= "~#factarray[AUTH]#~<br /><br />A pessoa, agência ou entidade que criou o registro. Para um trabalho publicado, pode ser o autor, compilador, transcritor, abstraidor ou editor. Para uma fonte não publicada, pode ser um indivíduo, uma agência governamental, uma organização religiosa ou uma organização privada, etc.";
$pgv_lang["edit_REFN_help"]			= "~#factarray[REFN]#~<br /><br />Este campo é normalmente usado para registrar texto de formato livre para identificar este registro GEDCOM. Por exemplo, pode ser um número de arquivo em um sistema automatizado ou manual, ou pode ser um número de página e posição em um gráfico de linhagem.<br /></br />Quando a configuração GEDCOM for definida para permitir que o usuário substitua o número de ID gerado automaticamente para novas pessoas, esse número de ID de substituição é inserido aqui. Neste caso, o texto deve obedecer às regras estabelecidas para os números de identificação. Os números de ID válidos podem conter apenas as letras <b>A</b> a <b>Z</b>, <b>a</b> a <b>z</b>, dígitos <b>0</b> a <b>9</b> e os símbolos especiais <b>. : -</b> e <b>_</b><br /><br />A opção que permite o uso do #factarray[REFN]# no lugar do número de ID gerado automaticamente é encontrada na configuração GEDCOM, seção Opções de Edição.";
$pgv_lang["edit_ABBR_help"]						= "~#factarray[ABBR]#~<br /><br />Este campo é usado para guardar a forma abreviada de um título. Este campo é utilizado em conjunto com o campo de título das Fontes. O padrão é usar primeiro o título e depois a forma abreviada.<br /><br />De acôrdo com o padrão GEDCOM 5.5, \"esta informação é utilizada como forma abreviada de um título e para ordenação, preenchimento, e acesso aos registros de Fonte (pg 62).\"<br /><br />Para o PhpGedView, a forma abreviada é opcional, mas para outros programas é obrigatório.";
$pgv_lang["edit_ROMN_help"]						= "~#factarray[NAME:ROMN]#~<br /><br />#pgv_lang[edit_ROMN_advice]#";
$pgv_lang["edit_ROMN_advice"]					= "Em muitas culturas, é costume ter um nome tradicional escrito nos caracteres tradicionais e também uma versão romanizada do nome, como seria escrito ou pronunciado em línguas baseadas no alfabeto latino, como o português.<br /><br /> Se preferir usar um alfabeto não latino, como hebraico, grego, russo, chinês ou árabe para inserir o nome nos campos de nome padrão, você pode usar este campo para inserir o mesmo nome usando o alfabeto latino. Ambas as versões do nome aparecerão em listas e gráficos.<br /><br />Embora este campo seja rotulado como \"Romanizado\", ele não se restringe a conter apenas caracteres baseados no alfabeto latino. Isso pode ser útil com nomes japoneses, onde três alfabetos diferentes podem ocorrer.";
$pgv_lang["edit_ROMN_GIVN_help"]				= "~#pgv_lang[roman_givn]#~<br /><br />#pgv_lang[edit_ROMN_advice]#<br /><br />Neste campo você deve inserir os nomes próprios da pessoa. Por exemplo, no nome \"John Robert Finlay\", os nomes dados que devem ser inseridos aqui são \"John Robert\".";
$pgv_lang["edit_ROMN_SURN_help"]				= "~#pgv_lang[roman_surn]#~<br /><br />#pgv_lang[edit_ROMN_advice]#<br /><br />Neste campo você deve inserir o sobrenome da pessoa. Por exemplo, no nome \"John Robert Finlay\", o sobrenome que deve ser inserido aqui é \"Finlay\".<br /><br />Pessoas com vários sobrenomes, comuns na Espanha e em Portugal, devem separar os sobrenomes com uma vírgula. Isso indica que a pessoa deve ser listada em cada um dos nomes. Por exemplo, o sobrenome \"Cortes,Vega\" será listado em <b>C</b> e <b>V</b>, enquanto o sobrenome \"Cortes Vega\" só será listado em <b>C</b>.";
$pgv_lang["edit__HEB_help"]						= "~#factarray[_HNM]#~<br /><br />#pgv_lang[edit__HEB_advice]#";
$pgv_lang["edit__HEB_advice"]					= "Em muitas culturas, é comum ter um nome tradicional escrito com os caracteres tradicionais e também uma versão romanizada do nome, como seria escrito ou pronunciado em idiomas baseados no alfabeto latino, como o inglês.<br /><br />Se preferir usar o alfabeto latino para inserir o nome nos campos de nome padrão, você pode usar este campo para inserir o mesmo nome no alfabeto não latino, como grego, hebraico, russo, árabe ou chinês. Ambas as versões do nome aparecerão em listas e gráficos.<br /><br />Embora este campo seja rotulado como \"Hebraico\", ele não se restringe a conter apenas caracteres hebraicos.";
$pgv_lang["edit__HEB_GIVN_help"]				= "~#pgv_lang[hebrew_givn]#~<br /><br />#pgv_lang[edit__HEB_advice]#<br /><br />Neste campo você deve inserir os nomes próprios da pessoa. Por exemplo, no nome \"John Robert Finlay\", os nomes dados que devem ser inseridos aqui são \"John Robert\".";
$pgv_lang["edit__HEB_SURN_help"]				= "~#pgv_lang[hebrew_surn]#~<br /><br />#pgv_lang[edit__HEB_advice]#<br /><br />Neste campo você deve inserir o sobrenome da pessoa. Por exemplo, no nome \"John Robert Finlay\", o sobrenome que deve ser inserido aqui é \"Finlay\".<br /><br />Pessoas com vários sobrenomes, comuns na Espanha e em Portugal, devem separar os sobrenomes com uma vírgula. Isso indica que a pessoa deve ser listada em cada um dos nomes. Por exemplo, o sobrenome \"Cortes,Vega\" será listado em <b>C</b> e <b>V</b>, enquanto o sobrenome \"Cortes Vega\" só será listado em <b>C</b>.";
$pgv_lang["edit_SEX_help"]						= "#pgv_lang[edit_sex_help]#";
$pgv_lang["edit_NAME_help"]						= "#pgv_lang[edit_name_help]#";
$pgv_lang["edit_add_unlinked_person_help"]		= "~#pgv_lang[add_unlinked_person]#~<br /><br />Use este formulário para adicionar uma pessoa não ligada a nenhuma outra pessoa desta árvore.<br /><br />Posteriormente esta pessoa poderá ser ligada a outras através da ficha #pgv_lang[relatives]# da página #pgv_lang[indi_info]#.";
$pgv_lang["edit_URL_help"]						= "~#factarray[URL]#~<br /><br />Informe o endereço URL incluindo http://. Exemplo: <b>http://www.phpgedview.net/</b><br /><br />Este campo é opcional e pode ser deixado em branco.";
$pgv_lang["edit_WWW_help"]						= "~#factarray[WWW]#~<br /><br />Informe o endereço da página da Web incluindo http://. Exemplo: <b>http://www.phpgedview.net/</b><br /><br />Este campo é opcional e pode ser deixado em branco.";
$pgv_lang["edit_EMAIL_help"]					= "~#factarray[EMAIL]#~<br /><br />Informe o endereço de email. Exemplo: <b>name@hotmail.com</b><br /><br />Este campo é opcional e pode ser deixado em branco.";
$pgv_lang["edit_FAX_help"]						= "~#factarray[FAX]#~<br /><br />Informe o FAX incluindo o DDI e DDD, mas não inclua a operadora. Exemplo: Um fax na cidade do Rio de Janeiro-Brasil seria +55 21 2233-4455 na Alemanha +49 25859 56 76 89 e nos EUA ou Canadá +1 888 555-1212.<br /><br />Este campo é ocpional e pode ser deixado em branco.";
$pgv_lang["edit_PHON_help"]						= "~#factarray[PHON]#~<br /><br />Informe o Telefone incluindo o DDI e DDD, mas não inclua a operadora. Exemplo: Um telefone na cidade do Rio de Janeiro-Brasil seria +55 21 2233-4455 na Alemanha +49 25859 56 76 89 e nos EUA ou Canadá +1 888 555-1212.<br /><br />Este campo é ocpional e pode ser deixado em branco.";
$pgv_lang["edit_ADDR_help"]						= "~#factarray[ADDR]#~<br /><br />Informe o endereço da mesma forma como você escreveria no envelope.<br /><br />Este campo é opcional e pode ser deixado em branco.";
$pgv_lang["edit_GIVN_help"]						= "#pgv_lang[edit_given_name_help]#";
$pgv_lang["edit_SPFX_help"]						= "~#factarray[SPFX]#~<br /><br />Informe ou selecione da lista, as palavras que precedem o sobrenome. Exemplos: <b>von</b> Braun, <b>van der</b> Kloot, <b>de</b> Graaf, etc.<br /><br />Em algumas circunstâncias, um título de nobreza pode ser inserido aqui. Por exemplo, Peter <b>Freiherr von</b> Somewhere. A parte «Freiherr» é na verdade um título de nobreza, e não deve ser repetido como um fato #factarray[TITL]#. O que é inserido aqui depende em grande parte das preferências da pessoa em questão.";
$pgv_lang["edit_SURN_help"]						= "#pgv_lang[edit_surname_help]#";
$pgv_lang["edit__MARNM_help"]					= "~#factarray[_MARNM]#~<br /><br />Digite o nome de casado para esta pessoa, usando as mesmas regras de formatação que se aplicam ao campo Nome. Este campo é opcional.<br /><br />Por exemplo, se Mary Jane Brown se casou com John White, você pode inserir (sem as aspas, é claro)<ul><li>Uso americano:&nbsp;&nbsp;\"Mary Jane Brown /White/\"</li><li>Uso europeu:&nbsp;&nbsp;\"Mary Jane /White/\"</li><li>Uso europeu alternativo:&nbsp;&nbsp;\"Mary Jane /White-Brown/\" ou \"Mary Jane /Brown-White/\"</li></ul>Você só deve fazer isso se Mary Brown começar a se chamar pelo novo nome depois de se casar com John White. Em alguns lugares, como Quebec (Canadá), por exemplo, é ilegal alterar nomes dessa forma.<br /><br />Os homens às vezes mudam de nome após o casamento, na maioria das vezes usando a forma hifenizada, mas ocasionalmente usando o sobrenome da esposa.";
$pgv_lang["edit_PEDI_help"]						= "~#factarray[PEDI]#~<br /><br />Este campo descreve o relacionamento da criança com sua família. As possibilidades são:<ul><li><b>#pgv_lang[unknown]#</b>&nbsp;&nbsp;&nbsp;O relacionamento da criança com sua família não pode ser determinado. Quando esta opção for selecionada, o campo #factarray[PEDI]# não será copiado para o banco de dados.</li><li><b>#factarray[BIRT]#</b>&nbsp;&nbsp;&nbsp;Essa opção indica que a criança é parente de sua família por nascimento.</li><li><b>#pgv_lang[adopted]#</b>&nbsp;&nbsp;&nbsp;Esta opção indica que a criança foi adotada por sua família. Isso <i>não</i> indica que não haja relação de sangue entre a criança e sua família; mostra que a criança foi adotada pela família em questão algum tempo após o nascimento da criança.</li><li><b>#pgv_lang[foster]#</b>&nbsp;&nbsp;&nbsp;Esta opção indica que a criança é uma criança adotiva da família. Normalmente, não há relação de sangue entre a criança e sua família.</li><li><b>#pgv_lang[sealing]#</b>&nbsp;&nbsp;&nbsp;A criança foi selada à família em uma cerimônia de <i>selamento</i> SUD. O selamento de uma criança é realizado quando os pais foram selados um ao outro após o nascimento da criança. Os filhos nascidos após o selamento dos pais são automaticamente selados à família.</li></ul>";
$pgv_lang["edit_AGNC_help"]						= "~#factarray[AGNC]#~<br /><br />A organização, instituição, corporação, pessoa ou outra entidade com autoridade.<br /><br /> Por exemplo, o empregador de uma pessoa, ou uma igreja que administrava ritos ou eventos, ou uma organização responsável pela criação e / ou arquivamento de registros.";
$pgv_lang["edit_MARR_TYPE_help"]				= "~#factarray[MARR]#: #factarray[TYPE]#~<br /><br />Este campo descreve o tipo de união que formou a família.<ul><li><b>#factarray[MARR_RELIGIOUS]#</b>&nbsp;&nbsp;&nbsp;indica que a cerimónia que formalizou a união de duas pessoas para formar uma família foi realizada por um padre, bispo, cardeal, pregador, rabino, xamã ou pessoa semelhante. A cerimónia não ocorreu necessariamente numa igreja, sinagoga, templo ou outro lugar consagrado. Poderia ter ocorrido ao ar livre ou numa casa particular.</li><li><b>#factarray[MARR_CIVIL]#</b>&nbsp;&nbsp;&nbsp;indica que a cerimónia que formalizou a união de duas pessoas para formar uma família foi realizada por um juiz, magistrado, presidente da Câmara ou pessoa semelhante de autoridade que não seja padre, etc. L'autoritat per dur a terme aquestes cerimònies sol ser atorgada per un govern.</li><li><b>#factarray[MARR_PARTNERS]#</b>&nbsp;&nbsp;&nbsp;descreve a relação entre duas pessoas, não casadas, que se comportam como se fossem uma família. <u>Não</u> participaram numa cerimónia de casamento realizada por um padre, um bispo, um juiz, um presidente da câmara ou qualquer outra pessoa com autoridade para realizar casamentos. Podem ter feito uma declaração pública de que se consideram casados, mas isso não é um requisito.</li><li><b>#factarray[MARR_UNKNOWN]#</b>&nbsp;&nbsp;&nbsp;indica que não são conhecidos as informações da união entre duas pessoas para formar uma família.</li></ul>";

$pgv_lang["context_help"]						= "Para mais Ajuda clique em <b>?</b> localizado ao lado dos items de cada página.";

$pgv_lang["register_gedcomid_help"]				= "~#pgv_lang[gedcomid]#~<br /><br />Cada pessoa no banco de dados possui um número de identificação exclusivo neste site. Se você souber o número de identificação para seu próprio registro, insira-o aqui. Se você não sabe o seu número de ID ou não conseguiu localizá-lo devido às configurações de privacidade, forneça informações suficientes no campo Comentários para ajudar o administrador do site a identificar quem você é neste site para que ele possa definir o ID para você.";
$pgv_lang["register_comments_help"]				= "~#pgv_lang[comments]#~<br /><br />Use este campo para informar ao Administrador as razões para seu acesso à árvore e qual seu relacionamento com as pessoas deste site. Pode ser utilizado também para qualquer outro comentário pessoal ao Administrador.";
$pgv_lang["utf8_ansi_help"]						= "~#pgv_lang[utf8_to_ansi]#~<br /><br />PhpGedView utiliza o conjunto de caracteres UTF-8. Alguns programas, tais como o Family Tree Maker, não importam arquivos GEDCOM neste formato. Marcando esta opção,  fará com que o arquivo seja convertido de <b>UTF-8</b> para <b>ANSI (ISO 8859-1)</b>.<br /><br />O formato de que você precisa depende do programa usado para trabalhar com o arquivo GEDCOM baixado. Se você não tiver certeza, consulte a documentação desse programa.<br /><br />Obs.: Para que os caracteres especiais permaneçam inalterados, será necessário manter o formato em UTF-8 e usar alguma ferramenta para converter para o formato de seu programa. Consulte o fabricante de seu programa para esclarecimentos.";
$pgv_lang["remove_tags_help"]					= "~#pgv_lang[remove_custom_tags]#~<br /><br />Marcando esta opção fará com que tags específicas do PhpGedView sejam removidas.<br /><br />Estas tags incluem as tags <b>_PGVU</b> que identifica o usuário que alterou um registro e a tag <b>_THUM</b> que informa qual imagem deve ser usada como Miniatura.<br /><br />Tags especiais podem causar Erros e Avisos no processo de importação do arquivo GEDCOM por outro programa genealógico.";
$pgv_lang["download_zipped_help"]				= "~#pgv_lang[zip_files]#~<br /><br />Ao marcar esta opção, uma cópia do arquivo GEDCOM será compactada em formato ZIP antes de o download começar. Isso reduzirá seu tamanho consideravelmente, mas você precisará usar um programa Unzip compatível (WinZIP, por exemplo) para descompactar o arquivo GEDCOM transmitido antes de usá-lo.<br /><br />Esta é uma opção útil para baixar arquivos GEDCOM grandes. Existe o risco de que o tempo de download do arquivo descompactado exceda o tempo máximo de execução permitido, resultando em arquivos baixados de forma incompleta. A opção ZIP deve reduzir o tempo de download em 75%.";
$pgv_lang["edit_NCHI_help"]						= "~#factarray[NCHI]#~<br /><br />Informe a quantidade de filhos desta pessoa ou família. Este campo é opcional.";
$pgv_lang["edit_TIME_help"]						= "~#factarray[TIME]#~<br /><br />Informe a hora deste evento, no formato 24 horas. Meia-noite é 00:00. Exemplos: 04:50 13:00 20:30.";
$pgv_lang["edit_NOTE_help"]						= "~#factarray[NOTE]#~<br /><br />Notas é um texto livre que é exibido na seção Detalhes do Fato.";
$pgv_lang["edit_SHARED_NOTE_help"]				= "~#pgv_lang[shared_note]#~<br /><br />As notas compartilhadas são um texto de formato livre e aparecerão na seção Detalhes do fato da página.<br /><br /> Cada nota compartilhada pode ser vinculada a mais de uma pessoa, família, fonte ou evento.";
$pgv_lang["edit_CEME_help"]						= "~#factarray[CEME]#~<br /><br />Informe o nome do cemitério ou local onde a pessoa está enterrada.";
$pgv_lang["edit_ASSO_help"]			= "~#factarray[ASSO]#~<br /><br />Digite a ID GEDCOM da pessoa cujo relacionamento com a pessoa atual você deseja descrever.";
$pgv_lang["edit_RELA_help"]			= "~#factarray[RELA]#~<br /><br />Selecione um #factarray[RELA]# na lista. Selecionar <b>#pgv_lang[godfather]#</b> significa: <i>A pessoa identificada no campo #factarray[ASSO]# é o #pgv_lang[godfather]# do indivíduo atual</i>.";
$pgv_lang["show_spouse_help"]					= "~#pgv_lang[show_spouses]#~<br /><br />Exibir cônjuges no gráfico de descendentes é opcional, porque em geral torna o entendimento do gráfico mais difícil. Habilitando esta opção, os cônjuges serão exibidos.";
$pgv_lang["reorder_families_help"]				= "~#pgv_lang[reorder_families]#~<br /><br />As famílias na guia #pgv_lang[relatives]## são exibidas na ordem em que aparecem no registro GEDCOM da pessoa. As famílias não são classificadas pela data do casamento porque muitas vezes as datas do casamento são desconhecidas, mas a ordem dos casamentos <u>é</u> conhecida.<br /><br />Esta opção permitirá que você altere a ordem das famílias em que estão listadas na guia #pgv_lang[relatives]#. Se você quiser classificar as famílias pelas datas de casamento, há um botão que você pode pressionar que fará isso automaticamente para você.";
$pgv_lang["autoContinue_help"]					= "~#pgv_lang[autoContinue]#~<br /><br />Quando PhpGedView detecta que a importação GEDCOM requer mais tempo do que o permitido pelo limite de tempo, ele exibirá um botão <b>#pgv_lang[del_proceed]#</b> que você deve pressionar para continuar a importação.<br /><br />Quando esta opção é configurada para <b>#pgv_lang[yes]#</b>, PhpGedView irá automaticamente pressionar o botão <b>#pgv_lang[del_proceed]#</b> para você. Isso deve aliviar o tédio de ter que pressionar o botão repetidamente para importações demoradas.";
$pgv_lang["firstname_i_help"]					= "~#pgv_lang[firstname_alpha_index]#~<br /><br />O sobrenome que você escolheu tem mais de #GLOBALS[SUBLIST_TRIGGER_I]# pessoas.<br /><br />Para ajudá-lo a encontrar a pessoa que você deseja, a lista foi dividida em listas menores de acordo com a primeira letra do nome da pessoa. Este sub-índice alfabético funciona da mesma forma que o índice alfabético para sobrenomes.<ul><li>Clique em uma letra para ver todos os nomes que começam com essa letra.</li><li>Escolha <b>#pgv_lang[PN]#</b> para listar todas as pessoas com nomes desconhecidos.</li><li>Escolher <b>#pgv_lang[all]#</b> exibirá uma lista de todas as pessoas com o sobrenome previamente escolhido.</li></ul>";
$pgv_lang["firstname_f_help"]					= "~#pgv_lang[firstname_alpha_index]#~<br /><br />O sobrenome que você escolheu tem mais de #GLOBALS[SUBLIST_TRIGGER_F]# pessoas.<br /><br />Para ajudá-lo a encontrar a família que deseja, a lista foi dividida em listas menores de acordo com a primeira letra do nome da pessoa. Este sub-índice alfabético funciona da mesma forma que o índice alfabético de nomes.<ul><li>Clique em uma letra para ver todos os nomes que começam com essa letra.</li><li>Escolha <b>#pgv_lang[PN]#</b> para listar todas as pessoas com nomes desconhecidos.</li><li>Escolher <b>#pgv_lang[all]#</b> exibirá uma lista de todas as famílias com o sobrenome previamente escolhido.</li></ul>";
$pgv_lang["edit_TYPE_help"]						= "~#factarray[TYPE]#~<br /><br />O campo #factarray[TYPE]# é usado para informações adicionais sobre o item. Em geral o campo é de texto livre e permite a entrada de qualquer tipo de informação.";
$pgv_lang["edit_TEMP_help"]						= "~#factarray[TEMP]#~<br /><br />Para ritos religiosos SUD, este campo guarda o Templo onde ocorreu a cerimônia.";
$pgv_lang["edit_STAT_help"]						= "~#factarray[STAT]#~<br /><br />Este campo é opcional e em geral usado para ritos religiosos SUD, enquanto eles percorrem o programa TempleReady.";
$pgv_lang["edit__PRIM_help"]					= "~#factarray[_PRIM]#~<br /><br />Use este campo para informar que esta mídia é a de destaque para esta pessoa. A imagem de destaque é a que é usada nos gráficos en na página da Pessoa.";
$pgv_lang["edit__THUM_help"]					= "~#factarray[_THUM]#~<br /><br />Esta opção permite substituir a seleção usual para uma imagem em miniatura.<br /><br />O GEDCOM tem uma opção de configuração que especifica se PhpGedView deve enviar a imagem grande ou pequena para o navegador sempre que a página atual exigir uma miniatura. A opção «#factarray[_THUM]#», quando configurada para <b>#pgv_lang[yes]#</b>, substitui temporariamente a configuração da opção de configuração GEDCOM, de forma que PhpGedView sempre enviará a imagem grande.Você não pode forçar o PhpGedView a enviar a imagem pequena quando a configuração GEDCOM especifica que imagens grandes sempre devem ser usadas.<br /><br />PhpGedView não redimensiona a imagem que está sendo enviada; o navegador faz isso de acordo com as especificações da página que também recebeu. Isso pode ter consequências indesejáveis quando a imagem enviada não é realmente uma miniatura para a qual o PhpGedView espera enviar uma pequena imagem. Isso não é um erro: Existem ocasiões em que pode ser desejável exibir uma imagem grande em locais onde normalmente se esperaria ver uma imagem em miniatura.<br /><br />Você deve evitar definir a opção «#factarray[_THUM]#» para <b>#pgv_lang[yes]#</b>. Essa escolha fará com que quantidades excessivas de dados relacionados à imagem sejam enviados ao navegador, apenas para que o navegador descarte o excesso. O carregamento de páginas, principalmente de gráficos com muitas imagens, pode ser seriamente retardado.";
$pgv_lang["edit_TITL_help"]						= "~#factarray[TITL]#~<br /><br />Informe o título do item editado. Para mídias, informe um título que descreva o conteúdo da mída para o usuário.<br /><br />Se você estiver editando os detalhes de uma pessoa, use este campo para inserir informações da Nobreza, como <i>Sir, Lord, Barão, Conde, Duque, Graf, Freiherr,</i> etc.<br /><br />Designações profissionais como <i>Dr., Admiral, Lt.Gen., Rev., Sister,</i> etc. devem ser inseridas no subcampo «#factarray[NPFX]#», enquanto sufixos de nome como <i>Jr., Sr., III, IV,</i> etc. e informações acadêmicas como <i>PhD, PEng, FImechE, DVM, MD,</i> etc. pertencem ao subcampo «#factarray[NSFX]#».";
$pgv_lang["edit_FILE_help"]						= "~#factarray[FILE]#~<br /><br />Este é o campo mais importante no registro de objetos multimídia. Indica qual arquivo usar. No mínimo, você precisa inserir o nome do arquivo. Dependendo de suas configurações, mais informações sobre a localização do arquivo podem ser úteis.<br /><br />Use <b>#pgv_lang[find_media]#</b> para ajuda-lo a encontrar a mídia, caso o arquivo já esteja gravado no servidor.<br /><br />#pgv_lang[readme_help]#";
$pgv_lang["edit_FORM_help"]						= "~#factarray[FORM]#~<br /><br />Este campo é opcional. É usado para informar o formato da mídia, que alguns programas se utilizam para saber como tratar a mídia. No entanto, como a mídia não se transfere muito bem entre os sistemas de computador, esse campo não é muito importante.";
$pgv_lang["generate_thumb_help"]				= "~#pgv_lang[auto_thumbnail]#~<br /><br />Seus sistema esta habilitado a gerar miniaturas automaticamente a partir de imagens do tipo BMP, GIF, JPG, e PNG. Os formatos reconhecidos estão listados ao lado da caixa da opção.<br /><br />Marcando esta opção o sistema tentará gerar miniaturas para as imagens enviadas. Caso queira enviar sua própria miniatura, não marque esta opção.";
$pgv_lang["edit_add_NOTE_help"]					= "~#pgv_lang[add_note]#~<br /><br />Esta seção permite a adição de uma nova nota ao fato que está sendo editado. O campo Notas permite texto livre e é exibido na seção Detalhes do Fato.";
$pgv_lang["edit_add_SHARED_NOTE_help"]			= "~#pgv_lang[add_shared_note]#~<br />~#pgv_lang[edit_shared_note]#~<br /><br />As notas compartilhadas, como as notas normais, são textos de formato livre. Ao contrário das notas normais, cada nota compartilhada pode ser vinculada a mais de uma pessoa, família, fonte ou fato.<br /><br />Ao clicar no ícone apropriado, você pode estabelecer um link para uma nota compartilhada existente ou criar uma nova nota compartilhada e, ao mesmo tempo, criar um link para ela. Se um link para uma nota compartilhada existente já tiver sido estabelecido, você também pode editar o conteúdo dessa nota.<br /><ul><li><b>Link para uma nota compartilhada existente</b><div style=\"padding-left: 20px;\">Se você já sabe o número de ID da nota compartilhada desejada, pode inserir esse número diretamente no campo.<br /><br />Ao clicar no ícone <b>#pgv_lang[find_shared_note]#</b>, você poderá pesquisar o texto de todas as notas compartilhadas existentes e escolher uma delas. O número de identificação da nota escolhida será inserido no campo automaticamente.<br /><br />Você deve clicar no botão <b>#pgv_lang[add]#</b> para atualizar o registro original.</div><br /></li><li><b>Criar uma nova nota compartilhada</b><div style=\"padding-left: 20px;\">Ao clicar no ícone <b>#pgv_lang[create_shared_note]#</b>, uma nova janela será aberta. Você pode inserir o texto da nova nota como desejar. Tal como acontece com as notas regulares, você pode inserir o URL.<br /><br />Ao clicar no botão <b>#pgv_lang[save]#</b>, você verá uma mensagem com o número de ID da nota compartilhada recém-criada. Você deve clicar nesta mensagem para fechar a janela de edição e também copiar o novo número de ID diretamente no campo do número de ID. Se você apenas fechar a janela, o número de identificação recém-criado não será copiado automaticamente.<br /><br />Você deve clicar no botão <b>#pgv_lang[add]#</b> para atualizar o registro original.</div><br /></li><li><b>Editar uma nota compartilhada existente</b><div style=\"padding-left: 20px;\">Ao clicar no ícone <b>#pgv_lang[edit_shared_note]#</b>, uma nova janela será aberta. Você pode alterar o texto da nota compartilhada existente como desejar. Tal como acontece com as notas regulares, você pode inserir um URL.<br /><br />Ao clicar no botão <b>#pgv_lang[save]#</b>, o texto da nota compartilhada será atualizado. Você pode fechar a janela e clicar no botão <b>#pgv_lang[save]#</b> novamente.<br /><br />Quando você altera o texto de uma nota compartilhada, sua alteração será refletida em todos os lugares aos quais essa nota compartilhada está vinculada no momento. Os novos links que você estabelecer após ter feito sua alteração também usarão o texto atualizado.</div></li></ul>";
$pgv_lang["edit_add_GEDFact_ASSISTED_help"]		= "~USANDO assistente GEDFACT~<br /><br />Clicar no ícone \"+\" abrirá a janela do Assistente GEDFact Nota Compartilhada. Ajuda específica será encontrada lá.<br /><br />Ao clicar no botão \"Salvar\", o ID da nota compartilhada será colado aqui.";
$pgv_lang["edit_add_SOUR_help"]					= "~#pgv_lang[add_source]#~<br /><br />Esta seção permite adicionar ao fato que está sendo editado, uma citação a uma fonte.<br /><br />No campo Fonte, informe a ID da Fonte. Clique em <b>#pgv_lang[create_source]#</b> para criar uma nova fonte se necessário. No Detalhe da Citação, você pode por exemplo informar a página da Fonte, ou qualquer outra informação que facilite encontra-la na Fonte. O campo Texto é reservado à transcrição parcial da Fonte.";
$pgv_lang["edit_add_ASSO_help"]					= "~#pgv_lang[add_asso]#~<br /><br />#pgv_lang[add_asso]# permite a ligação de um fato a uma pessoa da mesma árvore. Pode ser usado por exemplo para indicar que alguém da árvore é Padrinho de Batismo de outro, ou que determinada pessoa estava presente ao enterro de outra, etc...";
$pgv_lang["edit_QUAY_help"]						= "~#factarray[QUAY]#~<br /><br />Você usaria este campo para registrar a qualidade ou confiabilidade dos dados encontrados nesta fonte. Muitos aplicativos de genealogia usam um número no campo. <b>3</b> pode significar que os dados são uma fonte primária, <b>2</b> pode significar que era uma fonte secundária, <b>1</b> pode significar que a informação é questionável, e <b>0</b> pode significar que a fonte não é confiável.";
$pgv_lang["edit_PAGE_help"]						= "~#factarray[PAGE]#~<br /><br />No campo Detalhes da citação, você deve inserir o número da página ou outra informação que possa ajudar alguém a encontrar a informação na fonte.";
$pgv_lang["edit_TEXT_help"]						= "~#factarray[TEXT]#~<br /><br />Neste campo você deve inserir o texto de citação para esta fonte. Exemplos de dados podem ser uma transcrição do texto da fonte ou uma descrição do que estava na citação.";
$pgv_lang["edit_SOUR_help"]			= "~#factarray[SOUR]#~<br /><br />Este é o número de identificação da fonte deste fato. O título da fonte atual será mostrado abaixo do número do ID.<br /><br />Você pode alterar o número do ID do registro da fonte a que se refere a citação da fonte deste fato. Para remover a citação inteira, deixe este campo em branco. Esta ação não remove o registro de origem do banco de dados; apenas esta referência é removida.<br /><br />Se você inserir o ID de fonte desejado diretamente, esse registro de fonte já deve existir no banco de dados. Você pode clicar <b>#pgv_lang[find_sourceid]#</b> para pesquisar o número de ID de um registro de origem existente. Clique <b>#pgv_lang[create_source]#</b> se precisar inserir um novo registro de origem.";
$pgv_lang["edit_edit_raw_help"]					= "~#pgv_lang[edit_raw]#~<br /><br />Nesta página é possível editar os registros do GEDCOM diretamente. Use este recurso com muito cuidado e somente se você conhece o formato GEDCOM 5.5.1. Para saber mais sobre este o formato, leia o tópico da Ajuda <b>Arquivo GEDCOM</b>.<br /><br />O PhpGedView oferece várias formas para adicionar, alterar e excluir as informações, porém em algumas situações pode ser necessário editar diretamente os registros, mas sempre que possível use os formulários do PHPGedView. Suas alterações passam por uma validação simples para saber se estão de acôrdo com o formato GEDCOM 5.5.1 e em seguida são gravadas e o registro CHAN atualizado.";
$pgv_lang["add_from_clipboard_help"]			= "~#pgv_lang[add_from_clipboard]#~<br /><br />O PhpGedView permite que você copie até 10 fatos, com todos os seus detalhes, para uma prancheta. Esta área de transferência é diferente do Carrinho de Recortes que você pode usar para exportar partes do seu banco de dados.<br /><br />Você pode selecionar qualquer um dos fatos da área de transferência e copiar o fato selecionado para o registro de Pessoa, Família, Mídia, Fonte ou Repositório que está sendo editado no momento. No entanto, você não pode copiar fatos de tipos de registro diferentes. Por exemplo, você não pode copiar um fato de Casamento para um registro de Fonte ou Pessoa, pois o fato de Casamento está associado apenas a registros de Família.<br /><br />Isso é muito útil ao inserir fatos semelhantes, como dados do censo, para muitos indivíduos ou famílias.";
$pgv_lang["edit_PLAC_help"]						= "~#factarray[PLAC]#~<br /><br />Os locais devem ser inseridos de acordo com os padrões de genealogia. Na genealogia, os lugares são registrados com as informações mais específicas sobre o local primeiro e depois avançando para o local menos específico por último, usando vírgulas para separar os diferentes níveis do local. O nível no qual você registra as informações do local deve representar os níveis de governo ou igreja onde os registros vitais para aquele local são mantidos.<br /><br />Por exemplo, um lugar como Salt Lake City seria inserido como \"Salt Lake City, Salt Lake, Utah, USA\".<br /><br />Vamos examinar cada parte deste lugar. A primeira parte, \"Salt Lake City\", é a cidade ou município onde o evento ocorreu. Em alguns países, pode haver municípios ou distritos dentro de uma cidade que é importante observar. Nesse caso, eles devem vir antes da cidade. A próxima parte, \"Salt Lake\", é o condado. \"Utah\" é o estado e \"USA\" é o país. É importante anotar cada local porque os registros genealógicos são mantidos pelos governos de cada nível.<br /><br />Se um nível do local for desconhecido, você deve deixar um espaço entre as vírgulas. Suponha que, no exemplo acima, você não conhecesse o condado de Salt Lake City. Em seguida, você deve gravá-lo assim: \"Salt Lake City, , Utah, USA\". Suponha que você saiba apenas que uma pessoa nasceu em Utah. Você deve inserir as informações como esta: \", , Utah, USA\".<br /><br />Você pode usar o link <b>#pgv_lang[find_place]#</b> para ajudá-lo a encontrar lugares que já existem no banco de dados.";
$pgv_lang["edit_LATI_help"]						= "~#factarray[LATI]#~<br /><br />A inserção de coordenadas específicas de latitude e longitude geralmente é desencorajada, pois permite o acesso ao mapeamento apenas a partir da visualização do elemento específico. É melhor administrar os lugares geográficos.<br /><br />No entanto, inserir a latitude e longitude permite um posicionamento mais preciso do marcador.";
$pgv_lang["edit_LONG_help"]						= "~#factarray[LONG]#~<br /><br />A inserção de coordenadas específicas de latitude e longitude geralmente é desencorajada, pois permite o acesso ao mapeamento apenas a partir da visualização do elemento específico. É melhor administrar os lugares geográficos.<br /><br />No entanto, inserir a latitude e longitude permite um posicionamento mais preciso do marcador.";
$pgv_lang["edit_add_parent_help"]				= "~NOVO PAI OU MÃE~<br /><br />Com esta página você pode adicionar uma nova mãe ou pai para a pessoa selecionada. Preencha o nome da nova pessoa e as informações de nascimento e falecimento, se forem conhecidas. Se você não souber alguma informação, deixe em branco.<br /><br />Para adicionar outros fatos além de nascimento e morte, primeiro adicione a nova pessoa ao banco de dados salvando as alterações. Em seguida, clique no nome da pessoa na página Família atualizada ou na guia #pgv_lang[relatives]# para ver a página #pgv_lang[indi_info]# da pessoa. Na página #pgv_lang[indi_info]# você pode adicionar informações mais detalhadas.";
$pgv_lang["edit_add_spouse_help"]				= "~NOVO MARIDO OU ESPÔSA~<br /><br />Com esta página, você pode adicionar um novo marido ou esposa à pessoa selecionada. Preencha o nome da nova pessoa e as informações de nascimento e falecimento, se forem conhecidas. Se você não souber alguma informação, deixe em branco.<br /><br />Para adicionar outros fatos além de nascimento e morte, primeiro adicione a nova pessoa ao banco de dados salvando as alterações. Em seguida, clique no nome da pessoa na página Família atualizada ou na guia #pgv_lang[relatives]# para ver a página #pgv_lang[indi_info]# da pessoa. Na página #pgv_lang[indi_info]# você pode adicionar informações mais detalhadas.";
$pgv_lang["edit_death_help"]					= "~#pgv_lang[death]#~<br /><br />Informe a data do falecimento utilizando o formato padrão da genealogia (1&nbsp;JAN&nbsp;2004) ou clique no calendário e selecione a data desejada. Em seguida informe o local onde a pessoa faleceu ou use o link <b>#pgv_lang[find_place]#</b> para selecionar um dos locais já cadastrados em seu banco de dados.";
$pgv_lang["edit_birth_help"]					= "~#pgv_lang[birth]#~<br /><br />Informe a data do nasciomento utilizando o formato padrão da genealogia (1&nbsp;JAN&nbsp;2004) ou clique no calendário e selecione a data desejada. Em seguida informe o local onde a pessoa nasceu ou use o link <b>#pgv_lang[find_place]#</b> para selecionar um dos locais já cadastrados em seu banco de dados.";
$pgv_lang["edit_sex_help"]						= "~#pgv_lang[sex]#~<br /><br />Selecione o sexo da pessoa na lista. A opção <b>desconehcido</b> só deve ser usada quando realmente o sexo não for sabido.";
$pgv_lang["edit_name_help"]						= "~#pgv_lang[name]#~<br /><br />Este é o campo mais importante de uma pessoa.<br /><br />Este campo será preenchido automaticamente a medida que os demais campos forem sendo preenchidos, mas depois altere-o como quiser.<br /><br />O nome deve estar de acôrdo com o formato GEDCOM 5.5.1, isto é, o sobrenome deve estar entre barras \"/\". Exemplo, o nome \"John Robert Finlay Jr.\" deve ser infromado como \"John Robert /Finlay/ Jr.\".";
$pgv_lang["edit_surname_help"]					= "~#pgv_lang[surname]#~<br /><br />Informe o sobrenome da pessoa. Exemplo: para o nome \"John Robert Finlay\", o sobrenome informado deve ser \"Finlay\"<br /><br />Pessoas com vários sobrenomes, comuns na Espanha e em Portugal, devem separar os sobrenomes com uma vírgula. Isso indica que a pessoa deve ser listada em cada um dos nomes. Por exemplo, o sobrenome \"Cortes,Vega\" será listado em <b>C</b> e <b>V</b>, enquanto o sobrenome \"Cortes Vega\" somente será listado em <b>C</b>.";
$pgv_lang["edit_NICK_help"]						= "~#factarray[NICK]#~<br /><br />Este campo é opcional e serve para informar o apelido da pessoa.<br /><br />Formas de adicionar um apelido:<ul><li>Selecione <b>Alterar Nome</b> e informe o apelido e salve</li><li>Selecione <b>Adicionar Nome</b> informe o apelido, o nome e salve</li><li>Selececione <b>Editar Registro GEDCOM</b> para adiconar múltiplos registros [2&nbsp;NICK] subordinados ao registro principal [1&nbsp;NAME].</li></ul>";
$pgv_lang["edit_given_name_help"]				= "~#pgv_lang[given_name]#~<br /><br />Informe o nome da pessoa sem o sobrenome. Por exemplo uma pessoa cujo o nome completo é  \"José Marcos da Silva\", você deve informar \"José Marcos\" neste campo";
$pgv_lang["edit_NPFX_help"]			= "~#factarray[NPFX]#~<br /><br />Este campo opcional permite que você insira um prefixo de nome como <i>Dr.</i> ou <i>Adm.</i><br /><br />Títulos de nobreza como <i>Sir, Lord, Barão, Conde, Duque, Graf, Freiherr,</i> etc. são inseridos como um fato «#factarray[TITL]#».";
$pgv_lang["edit_NSFX_help"]			= "~#factarray[NSFX]#~<br /><br />Este campo opcional permite que você insira um sufixo de nome como <i>Jr., Sr., III, IV,</i> etc. e informações acadêmicas como <i>PhD, PEng, FImechE, DVM, MD,</i> etc.";
$pgv_lang["edit_add_child_help"]				= "~#pgv_lang[add_child]#~<br /><br />Com esta página você pode adicionar um novo filho à família selecionada. Preencha o nome da criança e as informações de nascimento e falecimento, se forem conhecidas. Se você não souber alguma informação, deixe em branco.<br /><br />Para adicionar outros fatos além do nascimento e morte, primeiro adicione a nova criança ao banco de dados salvando as alterações. Em seguida, clique no nome da criança na página Família atualizada ou na guia #pgv_lang[relatives]# para ver a página #pgv_lang[indi_info]# da criança. Na página #pgv_lang[indi_info]# você pode adicionar informações mais detalhadas.";

$pgv_lang["review_changes_help"]				= "~#pgv_lang[review_changes_block]#~<br /><br />Este bloco lista todos os registros com alterações pendentes e que precisam ser revisadas.";
$pgv_lang["quick_update_name_help"] 			= "~#pgv_lang[update_name]#~<br /><br />Use os campos \"Atualizar nome\" para alterar o nome da pessoa que você está editando. No campo Nomes fornecidos, digite o nome ou o primeiro nome da pessoa. No campo Sobrenome, digite o sobrenome ou o sobrenome da pessoa. Por exemplo, se o nome que deseja inserir for \"John Robert Finlay\", você deverá inserir \"John Robert\" no campo Nome e \"Finlay\" no campo Sobrenome.<br /><br />O preenchimento desses campos <u>mudará</u> o nome da pessoa; não adicionará um novo nome.<br /><br /><i>Obs.: não use esta opção caso a mudança do nome seja devido a casamento, neste caso primeiro adicione o marido a esta pessoa e depois informe o nome de casada.</i>";
$pgv_lang["quick_update_fact_help"]				= "~#pgv_lang[update_fact]#~<br /><br />Use \"Atualizar Fato\" para alterar ou adicionar informações de um fato acontecido com esta pessoa. Primeiro escolha um fato da lista e depois entre com da data quando ocorreu o fato usando o formato genealógico (1&nbsp;JAN&nbsp;2004) ou use o calendário e selecione a data. Informe o local onde aconteceu ou use o link <b>#pgv_lang[find_place]#</b> para selecionar um local já cadastrado.<br /><br />Estas informações serão adicionadas ou modificarão as já existentes.";
$pgv_lang["quick_update_address_help"]			= "~#pgv_lang[update_address]#~<br /><br />Use <b>#pgv_lang[update_address]#</b> para alterar informações tais como endereço, telefone, fax ou email desta pessoa.<br /><br />Estas informações substituirão as já existentes ou serão acrescentadas dependendo do caso.";
$pgv_lang["quick_update_spouse_help"]			= "~ADICIONAR CÔNJUGE~<br /><br />Use esta opção para adicionar um cônjuge a esta pessoa. Informe nome, a data de nascimento e do casamento, senão souber deixe em branco. Datas devem ser informadas no formato genealógico (1&nbsp;JAN&nbsp;2004) ou clique no calendário e selecione a data. Informe o local do casamento ou use <b>#pgv_lang[find_place]#</b> para selecionar um local já cadastrado.<br /><br />Esta opção apenas adicionará um novo cônjuge, para atualizar a informação do cônjuge anterior clique no nome dele na ficha #pgv_lang[relatives]# e na página dele atualize as informações necessárias.";
$pgv_lang["quick_update_marriage_help"]			= "~ATUALIZAR CASAMENTO~<br /><br />Use estes campos para alterar os dados do casamento ou para adicionar um novo casamento informando um novo cônjuge. Datas devem ser informadas no formato genealógico (1&nbsp;JAN&nbsp;2004) ou clicando no calendário e selecionando a data desejada. Use o link <b>#pgv_lang[find_place]#</b> para selecionar um local cadastrado ou informe-o.";
$pgv_lang["quick_update_child_help"]			= "~#pgv_lang[add_new_chil]#~<br /><br />Use estes campos para adicionar um filho a esta pessoa, informand o nome, sexo, data e local de nascimento. Datas devem ser informadas no formato genealógico (1&nbsp;JAN&nbsp;2004) ou clicando no calendário e selecionando a data desejada. O local pode ser informado ou use the <b>#pgv_lang[find_place]#</b> para selecionar um já cadastrado.<br /><br />Estes campos servem apenas para adicionar um <u>novo</u> filho, para atualizar dados de um filho adicionado anteriormente, feche esta janela e clique no nome do filho na ficha #pgv_lang[relatives]#. Depois clique em Edição Simplificada para atualizar a informação desejada..";
$pgv_lang["index_top10_pageviews_help"]			= "~#pgv_lang[top10_pageviews]#~<br /><br />Este bloco lista as pessoas, famílias, ou fontes mais visitados do site. Este bloco só funcionará se o Administrador habilitou a opção \"Contador de Hit de Itens\".";
$pgv_lang["index_cookiepolicy_help"]			= "~#pgv_lang[block_cookiepolicy]#~<br /><br />Este bloco mostra a política de cookies deste site.";
$pgv_lang["cookiepolicy_link_help"]				= "~#pgv_lang[block_cookiepolicy_link]#~<br /><br />Deixe este campo em branco se você quiser usar o texto padrão.<br /><br />Se você quiser usar o texto padrão e também fornecer um link para um arquivo de texto ou página HTML que contém detalhes sobre a política de cookie específico para o seu site, você pode digitar o URL para essa página aqui.<br /><br />Por exemplo, <b>http://foo.bar.com/policy/cookies.txt</b> pode apontar para um arquivo de texto simples, enquanto <b>http://foo.bar.com/policy/cookies.htm</b> aponta para uma página formatada em HTML, e <b>http://foo.bar.com/policy/cookies.doc</b> aponta para um documento em formato Microsoft Word.";
$pgv_lang["cookiepolicy_link_advice"]			= "Deixe em branco para usar o texto padrão.<br /><br />Digite uma URL, como <b>http://foo.bar.com/policy/cookies.txt</b> para apontar para uma página de política específica do site.";
$pgv_lang["useradmin_user_default_tab_help"]	= "~#pgv_lang[user_default_tab]#~<br /><br />Esta opção permite selecionar a ficha aberta automaticamente ao acessar a página #pgv_lang[indi_info]#. Se for dado ao usuário permissão para alterar sua conta, ele poderá modificar esta opção posteriormente.";
$pgv_lang["edituser_user_default_tab_help"]		= "~#pgv_lang[user_default_tab]#~<br /><br />Esta opção permite selecionar qual ficha é aberta automaticamente quando a página #pgv_lang[indi_info]# é acessada.";
$pgv_lang["reorder_children_help"]				= "~#pgv_lang[reorder_children]#~<br /><br />Os filhos são exibidos na ordem em que aparecem no registro familiar. As crianças não são classificadas automaticamente por data de nascimento porque muitas vezes as datas de nascimento de algumas das crianças são incertas, mas a ordem de nascimento <u>é</u> conhecida.<br /><br />Esta opção permitirá que você altere a ordem dos filhos no registro da família. Como você pode querer classificar os filhos pelas datas de nascimento, há um botão que você pode pressionar para fazer isso por você.<br /><br />Você também pode arrastar e soltar qualquer caixa de informações para alterar a ordem dos filhos. Conforme você move o cursor do mouse sobre uma caixa de informações, sua forma muda para um par de setas cruzadas de duas pontas. Se você pressionar e segurar o botão esquerdo do mouse antes de mover o cursor do mouse, a caixa de informações seguirá o cursor do mouse para cima ou para baixo na lista. À medida que a caixa de informações é movida, as outras caixas vão abrindo espaço. Ao soltar o botão esquerdo do mouse, a caixa de informações assumirá seu novo lugar na lista.";
$pgv_lang["rss_feed_help"]						= "~#pgv_lang[rss_feeds]#~<br /><br />O feed ATOM / RSS disponível no PhpGedView permite que qualquer pessoa visualize, usando um agregador de feed adequado, o conteúdo da página de boas-vindas do seu site sem visitar o site. A maioria dos agregadores exibirá um aviso avisando ao usuário quando algo mudou em uma página que está sendo monitorada. Isso essencialmente permite que qualquer pessoa monitore seu site PhpGedView sem a necessidade de visitá-lo regularmente.<br /><br />O bloco Feed é usado para personalizar o link para o feed, permitindo tipos de feed específicos (a maioria dos leitores pode lidar com a maioria dos tipos, então isso geralmente pode ser deixado no padrão) e o módulo específico que você gostaria em seu feed. O idioma do feed e do GEDCOM utilizado será baseado no idioma e no GEDCOM ativo no PhpGedView quando você selecionar o feed.<br /><br />Os tipos de feed que podem ser gerados incluem ATOM, RSS 2.0, RSS 1.0, RSS 0.92, HTML e JavaScript. Os primeiros quatro tipos são para agregadores de feed, enquanto JavaScript e HTML são destinados a permitir a inclusão de feeds em outras páginas da web. Observe que os números do feed RSS indicam estilos diferentes, não uma versão diferente.<br /><br />Há uma opção para selecionar a autenticação que fará o login do usuário e permitirá que ele veja, usando um agregador RSS adequado, qualquer informação que ele normalmente poderia ver se estivesse conectado. A autenticação básica usa <i>Autenticação HTTP básica</i> para fazer o login do usuário. Aprimoramentos futuros podem permitir a <i>Autenticação Digest</i>.<br /><br />Este <a href='https://pt.wikipedia.org/wiki/RSS' target='_blank' alt='Artigo da Wikipedia' title='Artigo da Wikipedia'><b>Artigo da Wikipedia</b></a> contém informações completas e links sobre RSS e os vários formatos RSS. <i>A autenticação HTTP básica</i> é discutida neste <a href='https://en.wikipedia.org/wiki/Basic_authentication_scheme' target='_blank' alt='artigo da Wikipedia' title='artigo da Wikipedia'><b>artigo da Wikipedia</b></a>, enquanto <i>Autenticação Digest</i> é discutido neste <a href='https://en.wikipedia.org/wiki/Digest_access_authentication' target='_blank' alt='Artigo da Wikipedia' title='Artigo da Wikipedia'><b>Artigo da Wikipedia</b></a>.";

$pgv_lang["upload_media_help"]				= "~#pgv_lang[upload_media]#~<br /><br />Selecione os arquivos de seu computador a serem enviados para o servidor. Todos os arquivos serão gravados na pasta <b>#MEDIA_DIRECTORY#</b> ou em uma de suas sub-pastas.<br /><br />Nomes de pasta especificados serão concatenados com <b>#MEDIA_DIRECTORY#</b>. Exemplo, <b>#MEDIA_DIRECTORY#minhafamilia</b>. A pasta de miniaturas é criada automaticamente caso não exista.";
$pgv_lang["upload_media_folder_help"]			= "~#pgv_lang[folder]#~<br /><br />Sua configuração GEDCOM permite até #GLOBALS[MEDIA_DIRECTORY_LEVELS]# níveis de pasta além do padrão <b>#GLOBALS[MEDIA_DIRECTORY]#</b> onde os arquivos de mídia carregados são normalmente armazenados. Isso permite organizar seus arquivos de mídia e você não precisa se preocupar em manter nomes exclusivos para cada arquivo de mídia.<br /><br />Neste campo, você especifica a pasta de destino em seu servidor onde o arquivo de mídia carregado deve ser armazenado. Certifique-se de prestar atenção ao caso (maiúsculas ou minúsculas) daquilo que você insere ou seleciona aqui, uma vez que os nomes de arquivos e pastas diferenciam maiúsculas de minúsculas.<br /><br />Se o nome da pasta que você inserir aqui não existir, ela será criada automaticamente. Se você inserir mais do que #GLOBALS[MEDIA_DIRECTORY_LEVELS]# níveis de pasta adicionais permitidos por sua configuração GEDCOM, sua entrada será truncada de acordo.<br /><br />As miniaturas serão enviadas ou criadas em uma estrutura de pasta idêntica, começando com <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.";
$pgv_lang["upload_media_file_help"]				= "~#pgv_lang[media_file]#~<br /><br />Neste campo, você especifica a localização e o nome, em seu computador local, do arquivo de mídia que deseja enviar para o servidor. Você pode usar o botão <b>Procurar</b> para pesquisar o arquivo desejado em seu computador local.<br /><br />O arquivo carregado terá o mesmo nome no servidor e será carregado no diretório especificado no campo <b>#pgv_lang[folder]#</b>.<br /><br />Se você não vir o campo <b>#pgv_lang[folder]#</b> ou não puder alterá-lo, você não tem permissões suficientes ou sua configuração GEDCOM foi definida para permitir nenhum nível de diretório além do padrão <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Neste caso, o arquivo de mídia será carregado para o diretório <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.";
$pgv_lang["upload_thumbnail_file_help"]			= "~#pgv_lang[thumbnail]#~<br /><br />Neste campo, você especifica a localização e o nome, em seu computador local, do arquivo de miniatura que deseja enviar para o servidor. Você pode usar o botão <b>Procurar</b> para pesquisar o arquivo desejado em seu computador local. Quando este campo é preenchido, a caixa de seleção <b>#pgv_lang[auto_thumbnail]#</b> é ignorada.<br /><br />Se o campo <b>#pgv_lang[media_file]#</b> tiver sido preenchido, o arquivo de miniaturas carregado será nomeado de acordo com o conteúdo desse campo, independentemente de como é chamado em seu computador local. Se esse campo estiver vazio, o arquivo de miniatura carregado será copiado para dois lugares no servidor, uma vez no diretório do servidor mencionado no campo <b>#pgv_lang[folder]#</b> e, em seguida, novamente em um diretório idêntico estrutura começando com <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />Se você não vir o campo <b>#pgv_lang[folder]#</b> ou não puder alterá-lo, você não tem permissões suficientes ou sua configuração GEDCOM foi definida para permitir nenhum nível de diretório além do padrão <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Neste caso, o arquivo de mídia será carregado para o diretório <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.";


//-- GENERAL
$pgv_lang["help_header"]						= "Informação sobre:";
$pgv_lang["privacy_error_help"]					= "~DETALHES PRIVADOS~<br /><br />Existem vários motivos possíveis para esta mensagem:<br /><ul><li><b>As informações sobre pessoas vivas são definidas como \"Privadas\"</b><br />Visitantes e usuários registrados que não estão logados podem ver as informações completas apenas para pessoas falecidas. Se permitido pelo administrador do sistema, os visitantes podem se registrar para uma conta clicando no botão Login e, em seguida, no link #pgv_lang[requestaccount]#.<br /></li><li><b>Você é um usuário com nome de usuário e senha...</b><br />Mas você não se conectou com sucesso ou ficou inativo por um tempo e sua sessão expirou.<br /></li><li><b>Devido à privacidade</b><br />A pessoa não deseja ser mostrada de forma alguma (Oculto) e pode ter pedido ao administrador para defini-la como \"Privado\". A privacidade pode ser definida para:<br /><ul><li>#pgv_lang[PRIV_USER]#</li><li>#pgv_lang[PRIV_NONE]#</li><li>#pgv_lang[PRIV_HIDE]#</li></ul></li><li><b>Fora de \"Caminho de relação\"</b><br />Mesmo se você for um usuário regular <u>e</u> logado, ainda pode acontecer de você ver esta mensagem se a pessoa que você está tentando ver não estiver relacionada a você dentro do número de etapas de relacionamento (comprimento do caminho de relacionamento ) definido pelo administrador do site para este GEDCOM.<br /><br />Exemplos:<br />Quando o comprimento do caminho de relacionamento é definido como <b>1</b>, você só pode ver os detalhes de sua própria família, pai, mãe, irmão, irmã (mas não os cônjuges e filhos de seu irmão ou irmã)<br /><br />Quando o Caminho de relacionamento é definido como <b>2</b>, você também pode ver os detalhes da esposa de seu irmão e seus filhos (mas não os cônjuges de seus filhos).<br /><br />Quanto mais alta a configuração de comprimento do caminho de relação, mais parentes distantes você pode ver.<br /></li></ul><br />Se você acha que está qualificado para ver alguns detalhes ocultos, entre em contato com o administrador do site. Use o link de contato em qualquer página.";
$pgv_lang["more_help"]							= "A Ajuda ao Contexto está disponível em cada janela; assegure-se de que a opção <b>#pgv_lang[show_context_help]#</b> no Menu de Ajuda está habilitada, e clique na <b>?</b> correspondente ao assunto.";
$pgv_lang["start_admin_help"]					= "+++ Início Info Extra do Admin +++";
$pgv_lang["end_admin_help"]						= "--- Fim Info Extra do Admin ---";
$pgv_lang["multiple_help"]						= "<span class='center'>--- Este é um texto genérico para páginas múltiplas ---</span>";
$pgv_lang["header_general_help"]				= "<div class='name_head center'><b>INFORMAÇÂO GERAL</b></div>";
$pgv_lang["best_display_help"]					= "~#pgv_lang[resolution]#~<br /><br />PhpGedView é projetado para um tamanho de tela de 1024x768 pixels. Este deve ser o tamanho mínimo para que tudo seja exibido corretamente.<br /><br />Se você definir o tamanho para um valor inferior (por exemplo, 800x600), pode ser necessário fazer a rolagem horizontal em algumas páginas.";
$pgv_lang["preview_help"]						= "~#pgv_lang[print_preview]#~<br /><br />Clicar em <b>#pgv_lang[print_preview]#</b> removerá os itens que não ficam bem em uma página impressa (menus, caixas de entrada, links extras, pontos de interrogação para a ajuda contextual, etc.)<br /><br />Você obterá um botão <b>#pgv_lang[print]#</b> na parte inferior da página simplificada; quando você clicar neste botão, a caixa de diálogo de impressão do seu sistema aparecerá. Após a impressão, clique em <b>#pgv_lang[cancel_preview]#</b> e a tela será reconstruída normalmente.<br /><br />Observação: Embora esta opção remova muitos links da página exibida, os links restantes ainda estão ativos.";
$pgv_lang["readme_help"]						= "Leia <a href=\"readme.txt\" target=\"_blank\"><b>Readme.txt</b></a> para mais informações.";
$pgv_lang["is_user_help"]						= "--- Este é o mesmo texto de Ajuda que os visitantes lerão. ---<br />--- Por economia, não há texto especial para o Administrador. ---";
$pgv_lang["edit_raw_gedcom_help"]				= "~#pgv_lang[edit_raw]#~<br /><br />Ao clicar neste link, uma nova janela será aberta contendo os dados GEDCOM brutos dos detalhes desta página.<br /><br />Aqui você pode editar os dados GEDCOM diretamente. Certifique-se de inserir dados GEDCOM 5.5.1 válidos, pois nenhuma outra verificação de validade será realizada. Os dados alterados ou adicionados serão exibidos no PhpGedView como \"Alterações\", e devem ser aceitos por um usuário com direitos de Aceitar.";
$pgv_lang["RESN_help_title"]					= "Definir restrições aos fatos";
$pgv_lang["RESN_help"]							= "~#pgv_lang[RESN_help_title]#~<br /><br />Além das configurações gerais de privacidade, PhpGedView tem a capacidade de definir restrições na visualização e edição de informações de fatos para pessoas e famílias. As restrições podem ser definidas por qualquer pessoa com permissão para editar as informações, a menos que a privacidade ou restrições anteriormente definidas proíbam isso.<br /><br />Os seguintes valores podem ser usados:<br /><ul><li><b>#pgv_lang[none]#</b><br />Os administradores do site, administradores GEDCOM e usuários com direitos de edição podem alterar as informações. As informações dos fatos podem ser visualizadas de acordo com as configurações de privacidade aplicadas pelo administrador.</li><li><b>#pgv_lang[locked]#</b><br />Essa configuração não tem influência na visibilidade dos dados do fato. Ele restringe os direitos de edição aos administradores do site e administradores GEDCOM. Se as informações se aplicarem ao próprio usuário, ele também poderá ver e, se tiver direitos de edição, editá-las.</li><li><b>#pgv_lang[privacy]#</b><br />Os administradores do site e administradores GEDCOM podem visualizar e editar as informações. Se as informações se aplicarem ao próprio usuário, ele também poderá ver e, se tiver direitos de edição, editá-las. Ele ficará oculto para todos os outros usuários, independentemente de seu status de login.</li><li><b>#pgv_lang[confidential]#</b><br />Apenas os administradores do site e administradores GEDCOM podem visualizar e editar as informações. Ele ficará oculto para todos os outros usuários, independentemente de seu status de login.</li></ul><br /><table><tr><th></th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Admin</th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Proprietário</th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Outros</th></tr><tr><th></th><th></th><th>L</th><th>E</th><th></th><th>L</th><th>E</th><th></th><th>L</th><th>E</th></tr><tr><td><img src=\"images/RESN_none.gif\" alt=\"\" />&nbsp;#pgv_lang[none]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_locked.gif\" alt=\"\" />&nbsp;#pgv_lang[locked]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /><th></th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_privacy.gif\" alt=\"\" />&nbsp;#pgv_lang[privacy]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_confidential.gif\" alt=\"\" />&nbsp;#pgv_lang[confidential]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr></table><ul><li>L : pode ler</li><li>E : pode editar</li><li><img src=\"images/checked_qm.gif\" alt=\"\" /> : depende das configurações globais de privacidade</li></ul>";


//-- Pages Help-messages
//-- Index-page
$pgv_lang["index_help"]							= "~#pgv_lang[welcome_page]#~<br /><br />Esta página é a página de boas-vindas. Ele dá as boas-vindas ao arquivo <a href=\"#def_gedcom\">GEDCOM</a> selecionado. Você pode retornar a esta página selecionando Página de boas-vindas no menu superior. Se houver vários GEDCOMs neste site, você pode selecionar um GEDCOM no menu suspenso.<br /><br />Esta página de ajuda contém informações sobre:<ul><li><a href=\"#index_portal\"><b>Página de Bem-Vindo</b></a></li><li><a href=\"#header\"><b>Área do Cabeçalho</b></a></li><li><a href=\"#menu\"><b>Menus</b></a></li><li><a href=\"#header_general\"><b>Informação Geral</b></a></li><li><a href=\"#def\"><b>Definições</b></a></li></ul>";

//-- Index-page Header
$pgv_lang["header_help"]						= "<div class='name_head center'><b>ÁREA DO CABEÇALHO</b></div><br />O cabeçalho é mostrado no topo de cada página. O cabeçalho contém alguns links úteis que você pode usar em todo o site.<br /><br />Uma vez que este site pode ter uma aparência diferente dependendo do <a href=\"#def_theme\">tema</a> selecionado, os cabeçalhos podem ser afetados e os links podem variar.<br /><br />Os links que você pode encontrar são:<ul><li><a href=\"#header_search\"><b>#pgv_lang[search]#</b></a></li><li><a href=\"#header_lang_select\"><b>#pgv_lang[change_lang]#</b></a></li><li><a href=\"#header_user_links\"><b>#pgv_lang[login]#</b></a></li><li><a href=\"#header_favorites\"><b>#pgv_lang[my_favorites]#</b></a></li><li><a href=\"#header_theme\"><b>#pgv_lang[change_theme]#</b></a></li></ul>";
$pgv_lang["header_search_help"]					= "~#pgv_lang[header]# «#pgv_lang[search]#»~<br /><br />Esta caixa de pesquisa é pequena, mas poderosa. Com ela você pode pesquisar por quase qualquer informação da árvore. Informe o que deseja pesquisar e clique o botão <b>&gt;</b> ou <b>Pesquisar</b>, a página com o resultado da pesquisa será exibida e nela você encontrará mais Ajuda sobre as opções de pesquisa.";
$pgv_lang["header_lang_select_help"]			= "~#pgv_lang[header]# «#pgv_lang[change_lang]#»~<br /><br />Uma das características mais importantes do PhpGedView é que vários idiomas são suportados.<br /><br />O idioma no qual PhpGedView exibe todas as páginas é determinado automaticamente de acordo com a configuração de idioma preferencial do navegador. No entanto, o administrador do site pode ter limitado a disponibilidade de determinados idiomas.<br /><br />Dependendo da configuração do site, você pode alterar o idioma do PhpGedView selecionando um idioma mais adequado em uma lista suspensa ou clicando no ícone de uma bandeira. Se você for um usuário registrado, você pode configurar o PhpGedView para mudar para o seu idioma preferido após o login, independentemente de como seu navegador está configurado.";
$pgv_lang["header_user_links_help"]				= "~#pgv_lang[header]# «#pgv_lang[login]#»~<br /><br />Os Links do Usuário são um pequeno bloco com links úteis que podem ser encontrados no mesmo lugar em todas as páginas. A localização desses links varia de acordo com o tema em vigor no momento.<br /><br />Quando não estiver logado, você verá apenas o link <b>Login</b>. Depois de fazer login, você verá:<ul><li><b>Conectado como (seu nome de usuário)</b>. Clicar nesse link o levará para a página da sua conta.</li><li>Clique em <b>Sair</b> para sair.</li><li>Se você tiver direitos de administrador, também verá <b>Admin</b>. Clicar neste link o levará diretamente para a página principal de Administração.</li></ul>";
$pgv_lang["header_favorites_help"]				= "~#pgv_lang[header]# «#pgv_lang[gedcom_favorites]#»~<br /><br />A lista suspensa Favoritos mostra os favoritos que você selecionou na página personalizada do Portal. Também mostra os favoritos que o administrador do site selecionou para o GEDCOM ativo no momento. Clicar em uma das entradas favoritas o levará diretamente para a página #pgv_lang[indi_info]# dessa pessoa.<br /><br />Mais ajuda sobre como adicionar Favoritos está disponível em sua página personalizada do Portal.";
$pgv_lang["header_theme_help"]					= "~#pgv_lang[header]# «#pgv_lang[change_theme]#»~<br /><br />Quando ativada pelo administrador do site, a lista suspensa Alterar Tema mostra uma lista dos temas que você pode usar para visualizar o site.<br /><br />Você pode alterar a aparência do site selecionando um tema na lista suspensa. Se você estiver logado, também mudará seu tema de usuário para aquele que você escolheu, de modo que seu próximo login selecione automaticamente esse mesmo tema.";

//-- Index-page Menu
$pgv_lang["menu_help"]							= "<div class='name_head center'><b>MENUS</b></div><br />No topo das páginas existem menus cujas opções apresentam sub-menus. Para acessar estes sub-menus basta passar o mouse sobre as opções.<br /><br />Se o icone da opção for clicado, será mostrada a página referente a primeira opção do sub-menu.<br /><br />Em geral, as seguintes opções estão disponíveis:<ul><li><a href=\"#menu_fam\"><b>#pgv_lang[welcome_page]#</b></a></li><li><a href=\"#menu_myged\"><b>#pgv_lang[mygedview]#</b></a></li><li><a href=\"#menu_charts\"><b>#pgv_lang[charts]#</b></a></li><li><a href=\"#menu_lists\"><b>#pgv_lang[lists]#</b></a></li><li><a href=\"#menu_annical\"><b>#pgv_lang[anniversary_calendar]#</b></a></li><li><a href=\"#menu_clip\"><b>#pgv_lang[clippings_cart]#</b></a></li><li><a href=\"#menu_search\"><b>#pgv_lang[search]#</b></a></li><li><a href=\"#menu_help\"><b>#pgv_lang[page_help]#</b></a></li></ul>";
$pgv_lang["menu_famtree_help"]					= "~#pgv_lang[welcome_page]#~<br /><br />Todos os bancos de dados genealógicos disponíveis neste site estão listados neste menu. Cada banco de dados tem sua própria página de boas-vindas personalizada, como esta. Se houver apenas um banco de dados neste site, não haverá submenu no ícone da página de boas-vindas.";
$pgv_lang["menu_myged_help"]					= "~#pgv_lang[mygedview]#~<br /><br />Se você se identificou, este menu pode incluir:<ul><li><a href=\"?help=index_myged_help\"><b>#pgv_lang[mygedview]#</b></a><br />Isso o levará à sua própria página inicial personalizável.</li><li><a href=\"?help=help_edituser.php\"><b>#pgv_lang[editowndata]#</b></a><br />Você pode editar seus dados pessoais aqui.</li><li><a href=\"?help=help_pedigree.php\"><b>#pgv_lang[my_pedigree]#</b></a><br />Se você selecionou uma pessoa inicial para este GEDCOM, isso o levará ao Gráfico de Linhagem dessa pessoa.</li><li><a href=\"?help=help_individual.php\"><b>#pgv_lang[my_indi]#</b></a><br />Este link o levará para a página #pgv_lang[indi_info]#, onde todos os dados genealógicos sobre você e sua família são exibidos.</li></ul>";
$pgv_lang["menu_charts_help"]					= "~#pgv_lang[charts]#~<br /><br />Os gráficos disponíveis são:<ul><li><a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a><br />Isso o levará ao gráfico de linhagem deste arquivo GEDCOM. O pedigree começará com a pessoa configurada pelo administrador. Quando você está logado, a pessoa inicial pode ser quem você configurou nas preferências da sua conta.</li><li><a href=\"?help=help_descendancy.php\"><b>#pgv_lang[descend_chart]#</b></a><br />O gráfico de descendência é essencialmente um <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a> na ordem inversa. Esta comparação não é totalmente correta, mas enquanto o gráfico de linhagem mostra todos os ancestrais de uma pessoa inicial, o gráfico de Descendência mostra todos os descendentes de uma pessoa inicial.</li><li><a href=\"?help=help_timeline.php\"><b>#pgv_lang[timeline_chart]#</b></a><br />Aqui você visualiza os eventos de uma pessoa ao longo de uma linha do tempo. É interessante comparar os eventos de duas ou mais pessoas ao longo da mesma linha do tempo.</li><li><a href=\"?help=help_relationship.php\"><b>#pgv_lang[relationship_chart]#</b></a><br />Aqui você pode verificar a relação de uma pessoa consigo mesmo ou com outra pessoa.</li><li><a href=\"?help=help_ancestry.php\"><b>#pgv_lang[ancestry_chart]#</b></a><br />Este gráfico é muito semelhante ao <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>, mas com mais detalhes e alternativas <a href=\"?help=chart_style_help\"><b>#pgv_lang[chart_style]#</b></a> é exibido.</li><li><a href=\"?help=help_fanchart.php\"><b>#pgv_lang[fan_chart]#</b></a><br />Este gráfico é muito semelhante ao <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>, mas de uma forma mais gráfica.</li></ul>";
$pgv_lang["menu_lists_help"]					= "~#pgv_lang[lists]#~<br /><br />As seguintes listas estão disponíveis:<ul><li><a href=\"?help=help_indilist.php\"><b>#pgv_lang[individual_list]#</b></a></li><li><a href=\"?help=help_famlist.php\"><b>#pgv_lang[family_list]#</b></a><br />Nessas duas listas, você pode navegar por listas alfabéticas de pessoas ou famílias neste GEDCOM.</li><li><a href=\"?help=help_sourcelist.php\"><b>#pgv_lang[source_list]#</b></a><br />Este item produz uma lista de todas as fontes utilizadas no GEDCOM.</li><li><a href=\"?help=help_placelist.php\"><b>#pgv_lang[place_list]#</b></a><br />Aqui você pode procurar pessoas por local.</li><li><a href=\"?help=help_medialist.php\"><b>#pgv_lang[media_list]#</b></a><br />Você verá este item de menu apenas se habilitado pelo administrador do site. Isso exibirá links para todos os arquivos multimídia neste GEDCOM.</li></ul>";
$pgv_lang["menu_annical_help"]					= "~#pgv_lang[anniversary_calendar]#~<br /><br />O #pgv_lang[anniversary_calendar]# exibe os eventos em um GEDCOM para uma determinada data, mês ou ano.<ul><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewday]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewmonth]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewyear]#</b></a><br />Esses itens de menu o levarão a #pgv_lang[anniversary_calendar]# para exibir uma lista de todos os eventos do dia, mês ou ano atual.</li></ul>";
$pgv_lang["menu_clip_help"]						= "~#pgv_lang[clippings_cart]#~<br /><br />Você verá este item na barra de menu apenas quando o administrador habilitar este recurso. <br /> <br /> O #pgv_lang[clip_cart]# permite que você armazene informações sobre indivíduos, famílias e fontes em um arquivo temporário que você pode baixar posteriormente no formato GEDCOM 5.5.1.";
$pgv_lang["menu_search_help"]					= "~#pgv_lang[search]#~<br /><br />A Página de Pesquisa é uma versão mais poderosa do que a Caixa de Pesquisa encontrada no topo de cada página.";
$pgv_lang["menu_help_help"]						= "~#pgv_lang[page_help]#~<br /><br />#pgv_lang[help_help_items]#";

//-- Index-page Portal
$pgv_lang["index_portal_head_help"]				= "<div class='name_head center'><b>#pgv_lang[welcome_page]#</b></div>";
$pgv_lang["index_portal_help"]					= "A #pgv_lang[welcome_page]# consiste em vários blocos separados e pode ser personalizada. Em sites que possuem mais de um banco de dados genealógico, você pode ver uma página de boas-vindas diferente para cada um. Dependendo de como o administrador personalizou o site, você pode ver qualquer um dos seguintes blocos na página de boas-vindas:<ul><li><a href=\"#index_welcome\"><b>#pgv_lang[welcome_block]#</b></a></li><li><a href=\"#index_login\"><b>#pgv_lang[login_block]#</b></a></li><li><a href=\"#index_events\"><b>#pgv_lang[upcoming_events_block]#</b></a></li><li><a href=\"#index_onthisday\"><b>#pgv_lang[todays_events_block]#</b></a></li><li><a href=\"#index_charts\"><b>#pgv_lang[charts_block]#</b></a></li><li><a href=\"#index_favorites\"><b>#pgv_lang[gedcom_favorites_block]#</b></a></li><li><a href=\"#index_stats\"><b>#pgv_lang[gedcom_stats_block]#</b></a></li><li><a href=\"#index_common_surnames\"><b>#pgv_lang[block_top10]#</b></a></li><li><a href=\"#index_media\"><b>#pgv_lang[random_media_block]#</b></a></li><li><a href=\"#index_loggedin\"><b>#pgv_lang[logged_in_users_block]#</b></a></li><li><a href=\"#gedcom_news\"><b>#pgv_lang[gedcom_news_block]#</b></a></li><li><a href=\"#recent_changes\"><b>#pgv_lang[recent_changes_block]#</b></a></li></ul>";
$pgv_lang["index_welcome_help"]					= "~#pgv_lang[welcome_block]#~<br /><br />O bloco de boas-vindas mostra o título atual do banco de dados, a data e a hora e, se habilitado pelo administrador, o contador de visitas.<br /><br />O contador de visitas está disponível apenas no bloco de boas-vindas e na página #pgv_lang[indi_info]# page. O contador conta os \"Hits\" dessas páginas. Isso significa que ele conta quantas vezes essas páginas são visitadas. O contador não verifica o endereço de Internet de um visitante; cada visita a uma página de <u>qualquer</u> local remoto conta como outro Hit.";
$pgv_lang["index_login_help"]					= "~#pgv_lang[login_block]#~<br /><br />É possivel identificar-se em quase todas as páginas do site. Normalmente isso é feito na primeira página, pois informações privilegiadas só são exibidas para usuários devidamente identificados.<br /><br />Para identificar-se basta informar seu <b>#pgv_lang[username]#</b>, sua <b>#pgv_lang[password]#</b> e clicar no botão <b>#pgv_lang[login]#</b>.";
$pgv_lang["index_events_help"]					= "~#pgv_lang[upcoming_events_block]#~<br /><br />Este bloco exibe o aniversário de eventos que estão para acontecer.<br /><br />O Administrador determina o número de dias que o bloco antecipará. Através da configuração do bloco, você pode restringir quais eventos serão exibidos no bloco.<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["todo_help"] 							= "~#pgv_lang[todo_block]#~<br /><br />Este bloco ajuda a manter o controle das tarefas <b>_TODO</b> no banco de dados.<br /><br />Para adicionar tarefas A Fazer em seus registros, você pode primeiro precisar alterar a configuração do GEDCOM para que o fato <b> TODO</b> esteja na lista de fatos que podem ser adicionados aos registros de pessoas, famílias, fontes e repositórios. Cada uma dessas listas, que você encontrará na seção Editar opções da configuração GEDCOM, é independente. A ordem das entradas da lista não é importante; você pode adicionar as novas entradas no início de cada lista.";
$pgv_lang["todo_show_other_help"]     			= "Mostrar tarefas atribuídas a outros usuários";
$pgv_lang["todo_show_unassigned_help"]			= "Mostrar tarefas que não são atribuídas a nenhum usuário";
$pgv_lang["todo_show_future_help"]				= "Mostrar tarefas que têm uma data no futuro. Caso contrário, apenas os itens com uma data no passado são mostrados.";
$pgv_lang["yahrzeit_help"]						= "~#pgv_lang[yahrzeit_block]#~<br /><br />Este bloco mostra os Yahrzeiten que surgirão em um futuro próximo.<br /><br />Yahrzeiten (singular: Yahrzeit) são aniversários da morte de uma pessoa. Esses aniversários são observados na tradição judaica; eles não são mais de uso comum em outras tradições. «Yahrzeit» também pode ser escrito «Jahrzeit» ou «Yartzeit».<br /><br />O administrador determina a que distância o bloco ficará. A exibição do bloco do próximo Yahrzeiten pode ser mais refinada por meio das opções de configuração.<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["days_to_show_help"]					= "~#pgv_lang[days_to_show]#~<br /><br />Digite o número de dias para mostrar. Este número não pode ser maior que <b>#DAYS_TO_SHOW_LIMIT#</b>. Se você inserir um valor maior, esse limite será usado.<br /><br />O limite mostrado é definido pelo administrador na configuração GEDCOM, seção Display e Layout, subseção Ocultar &amp; Mostrar.";
$pgv_lang["random_media_persons_or_all_help"] 	= "~#pgv_lang[random_media_persons_or_all]#~<br /><br />Esta opção permite que você determine o tipo de mídia para mostrar.<br /><br />Ao selecionar <b>#pgv_lang[random_media_persons]#</b>, apenas a mídia associada a pessoas será exibida. Normalmente, esta seria a fotografia de uma pessoa. Ao selecionar <b>#pgv_lang[random_media_events]#</b>, apenas a mídia associada a fatos ou eventos será exibida. Pode ser a imagem de um certificado. Ao selecionar <b>#pgv_lang[all]#</b>, este bloco mostrará todos os tipos de mídia.";
$pgv_lang["random_media_filter_help"] 			= "~#pgv_lang[filter]#~<br /><br />Você pode restringir o que o bloco Random Media tem permissão para mostrar de acordo com o formato e tipo de item de mídia. Quando uma determinada caixa de seleção é marcada, o bloco Random Media tem permissão para exibir itens de mídia daquele formato ou tipo.<br /><br />Os códigos de formato ou tipo que existem em seu banco de dados, mas não estão nessas listas de caixas de seleção, têm a caixa de seleção correspondente marcada. Por exemplo, se o seu banco de dados contém objetos de mídia de formato <b><i>pdf</i></b>, o bloco de mídia aleatória sempre tem permissão para exibi-los. Da mesma forma, se seu banco de dados contém objetos de mídia do tipo <b><i>especial</i></b>, o bloco de mídia aleatória sempre tem permissão para exibi-los.";
$pgv_lang["basic_or_all_help"]					= "~#pgv_lang[basic_or_all]#~<br /><br />Esta opção permite eliminar alguns eventos com datas. Por exemplo, #factarray[DIV]#, #factarray[CREM]#, #factarray[GRAD]#, #factarray[BARM]#, #factarray[FCOM]#, etc., todos devem ter datas.<br /><br />Quando você seleciona <b>Sim</b>, apenas nascimentos, mortes e casamentos serão exibidos. Ao selecionar <b>Não</b>, todos os eventos datados serão exibidos.";
$pgv_lang["style_help"]							= "~#pgv_lang[style]#~<br /><br />Esta opção controla como as informações são apresentadas.<br /><br />Quando você seleciona <b>#pgv_lang[style1]#</b>, as informações são mostradas na forma de texto, semelhante ao que você vê nas várias caixas do gráfico. Este formato é adequado para blocos que são impressos no lado direito da página.<br /><br />Quando você seleciona <b>#pgv_lang[style2]#</b>, as informações são mostradas em formato tabular e são mais adequadas para os blocos maiores que são impressos no lado esquerdo da página.";
$pgv_lang["sort_style_help"]					= "~#pgv_lang[sort_style]#~<br /><br />Esta opção controla como as informações são classificadas.<br /><br />Quando você seleciona <b>#pgv_lang[by_alpha]#</b>, as informações são mostradas em ordem alfabética. Quando você seleciona <b>#pgv_lang[by_anniv]#</b>, as informações são ordenadas por aniversário, com os aniversários mais recentes primeiro.";
$pgv_lang["cal_dowload_help"]					= "~#pgv_lang[cal_download]#~<br /><br />Esta opção controla se o botão para baixar eventos do calendário é mostrado para usuários conectados. O arquivo de calendário baixado pode ser importado para programas compatíveis como o Microsoft Outlook para, por exemplo, gerar lembretes automáticos por e-mail de aniversários.<br /><br />Quando você seleciona <b>#pgv_lang[no]#</b>, as informações são mostradas em ordem alfabética. Quando você seleciona <b>#pgv_lang[yes]#</b>, as informações são ordenadas por aniversário, com os aniversários mais recentes primeiro.";
$pgv_lang["cal_download_user_help"]				= "Se você estiver conectado, poderá ver o ícone <img src='images/ical.png' alt='' />. Se você clicar no ícone, irá baixar os eventos como um arquivo de calendário, que pode ser importado para programas compatíveis como o Microsoft Outlook para, por exemplo, gerar lembretes automáticos por e-mail de aniversários.<br /><br />Se você estiver conectado e não vir este ícone, o administrador desativou este recurso. Os visitantes que não estiverem logados não verão este ícone e não podem baixar o arquivo de calendário.";
$pgv_lang["index_charts_help"]					= "~#pgv_lang[charts_block]#~<br /><br />Este bloco permite que um gráfico de linhagem, descendência ou ampulheta apareça na página Bem-vindo ou MyGedView. Devido a limitações de espaço, os gráficos devem ser colocados apenas no lado esquerdo da página.<br /><br />Quando este bloco aparece na página de boas-vindas, a pessoa raiz e o tipo de gráfico a ser exibido são determinados pelo administrador. Quando este bloco aparece na página MyGedView personalizada do usuário, essas opções são determinadas pelo usuário.<br /><br />O comportamento desses gráficos é idêntico ao seu comportamento quando são acessados nos menus. Clique na caixa de uma pessoa para ver mais detalhes sobre ela.";
$pgv_lang["index_onthisday_help"]				= "~#pgv_lang[todays_events_block]#~<br /><br />Este bloco é similar ao bloco #pgv_lang[upcoming_events_block]#, a diferença é que este mostra os eventos de hoje.<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["index_favorites_help"]				= "~#pgv_lang[gedcom_favorites_block]#~<br /><br />Este bloco é muito parecido com o bloco #pgv_lang[user_favorites_block]# da página #pgv_lang[mygedview]#. Ao contrário da configuração da página do Portal, apenas o administrador ou um usuário com direitos de administrador pode alterar a lista de favoritos neste bloco.<br /><br />O objetivo deste bloco é chamar a atenção do visitante para pessoas de interesse especial. Os favoritos deste GEDCOM estão disponíveis para seleção em uma lista suspensa no cabeçalho de cada página.<br /><br />Ao clicar em um dos favoritos do site listado, você será direcionado para a página #pgv_lang[indi_info]# dessa pessoa.";
$pgv_lang["index_add_favorites_help"]			= "~#pgv_lang[add_favorite]#~<br /><br />Este formulário permite adicionar um novo favorito a sua lista de favoritos.<br /><br />Informe a ID da pessoa, da família ou fonte que deseja como favorito, ou informe uma URL e um título. O campo NOTA é opcional, podendo ser usado para descrever o favorito. O texto do campo NOTA será exibido no bloco Favoritos logo após o item.";
$pgv_lang["index_stats_help"]					= "~#pgv_lang[gedcom_stats_block]#~<br /><br />Este bloco exibe estatíticas do arquivo GEDCOM. Se precisar de mais informações envie um email para o contato no final desta página.";
$pgv_lang["index_common_names_help"]			= "~#pgv_lang[block_top10]#~<br /><br />Este bloco irá listar os sobrenomes mais frequentes, com uma contagem para cada um. Se você clicar em um nome, irá levá-lo à lista de pessoas, já filtrada pelo nome que você clicou.<br /><br />O administrador determina quantos nomes são realmente mostrados.";
$pgv_lang["index_common_given_names_help"]		= "~#pgv_lang[block_givn_top10]#~<br /><br />Este bloco listará os nomes próprios que ocorrem com mais frequência. Mostra nomes masculinos e femininos em colunas. Uma terceira coluna aparecerá quando houver pessoas cujo sexo não é conhecido.<br /><br />O administrador determina quantos nomes são realmente mostrados.";
$pgv_lang["index_media_help"]					= "~#pgv_lang[random_media_block]#~<br /><br />Neste bloco, o PhpGedView escolhe aleatoriamente um arquivo de mídia para mostrar a você em cada visita a esta página.<br /><br />Ao clicar na imagem, você verá sua versão em tamanho real. Abaixo da imagem, você tem um link para a pessoa associada à imagem. Ao clicar na legenda da imagem, você a verá na página #pgv_lang[media_list]#. Ao clicar no nome da pessoa, você será direcionado para a página #pgv_lang[indi_info]# dessa pessoa.";
$pgv_lang["index_loggedin_help"]				= "~#pgv_lang[logged_in_users_block]#~<br /><br />Este bloco irá mostrar os usuários atualmente logados.<br /><br />Se você não for um administrador, sua visão dos usuários conectados é restrita àqueles que optaram por ficar visíveis enquanto estiverem online. Para que isso funcione, você também deve optar por estar visível enquanto estiver online. Usuários online invisíveis para você são considerados anônimos.";
$pgv_lang["index_gedcom_news_help"]				= "~#pgv_lang[gedcom_news_block]#~<br /><br />O bloco Notícias é como um quadro de avisos para este GEDCOM. O administrador do site pode colocar anúncios importantes ou mensagens de notícias interessantes aqui.<br /><br />Se você tiver algo interessante para mostrar, entre em contato com o administrador do site; ele pode colocar sua mensagem neste quadro de avisos.";
$pgv_lang["recent_changes_help"]				= "~#pgv_lang[recent_changes_block]#~<br /><br />Este bloco utiliza da tag CHAN do arquivo GEDCOM para exibe as últimas atualizações feitas no site.";
$pgv_lang["gedcom_news_limit_help"]				= "Você pode definir o número máximo de notícias exibidas no bloco de Notícias e com isso reduzir o tamanho do bloco.<br /><br />Esta opção determina se há limite, se o limite é pela idade da notícia ou se é pela qtde de notícias.";
$pgv_lang["gedcom_news_flag_help"]				= "Insira o valor limite aqui.<br /><br />Se você optou por limitar a exibição do artigo de notícias de acordo com a idade, qualquer artigo anterior ao número de dias inserido aqui ficará oculto. Se você optou por limitar a exibição de artigos de notícias por número, apenas o número especificado de artigos recentes, ordenados por idade, será mostrado. Os artigos restantes serão ocultados da visualização.<br /><br />Os zeros inseridos aqui desabilitarão o limite, fazendo com que todos os artigos de notícias sejam exibidos.";
$pgv_lang["gedcom_news_archive_help"]			= "O Administrador escondeu alguns artigos para reduzir o espaço ocupado pelo Bloco de Notícias. Você pode torna-los visíveis clicando no link <b>#pgv_lang[gedcom_news_archive]#</b>.";
$pgv_lang["index_htmlplus_help"]				= "~#pgv_lang[htmlplus_block_name]#~<br /><br />Este bloco permite ao Administrador adicionar informação ao Indice ou ao Portal. Seu uso é similar aos dos blocos de HTML, Notícias e Estatísticas, porém o Administrador tem mais controle sobre a formatação do bloco.";
$pgv_lang["index_htmlplus_title_help"]			= "~#factarray[TITL]#~<br /><br />Este texto deve estar em branco ou muito breve. Quando em branco, o bloco HTML avançado será mostrado na página Índice ou Portal como um bloco simples, assim como o bloco HTML. Quando houver texto, o bloco HTML avançado será exibido como todos os outros blocos, completo com uma barra de título do bloco contendo o texto inserido aqui.";
$pgv_lang["index_htmlplus_template_help"]		= "~#pgv_lang[htmlplus_block_templates]#~<br /><br />Para ajudá-lo a começar com este bloco, criamos vários modelos padrão. Quando você seleciona um desses modelos, a área de texto contém uma cópia que você pode alterar para se adequar aos requisitos do seu site.";
$pgv_lang["index_htmlplus_content_help"]		= "~#pgv_lang[htmlplus_block_content]#~<br /><br />Ao contrário dos blocos #pgv_lang[html_block_name]#, #pgv_lang[gedcom_news_block]#, e #pgv_lang[gedcom_stats_block]#, você tem controle total sobre a aparência do seu bloco. Você pode usar tags HTML, e o bloco usa as folhas de estilo CSS do tema ativo no momento. Referências a informações do banco de dados genealógico atualmente ativo podem ser incluídas no texto.<br /><br />As referências de banco de dados são sinalizadas no texto por palavras-chave entre símbolos <b>&#35;</b> emparelhados. Por exemplo, <b>&#35;totalFamilies&#35;</b> representa o número de famílias no banco de dados. Ocasionalmente, você pode querer usar uma referência de banco de dados como texto em vez de seu verdadeiro significado. Para fazer isso, você precisa substituir os símbolos <b>&#35;</b> que envolvem a palavra-chave por seu equivalente simbólico. Por exemplo, se o seu texto contiver <b>&amp;&#35;35;totalFamilies&amp;&#35;35;</b>, ele será impresso como <b>&#35;totalFamilies&#35;</b> de se tornar uma referência de banco de dados.<br /><br />Para obter um exemplo completo do uso deste bloco, examine o arquivo de modelo &quot;#pgv_lang[gedcom_stats_block]#&quot; encontrado no diretório blocks/, ele usa a maioria dos estilos de tags, incluindo idiomas e links de texto de ajuda.<br /><br />O arquivo de modelo <b>#pgv_lang[htmlplus_block_keyword]#</b> contém uma lista completa de todas as palavras-chave suportadas.";
$pgv_lang["index_htmlplus_compat_help"]			= "~#pgv_lang[htmlplus_block_compat]#~<br /><br />Habilite a compatibilidade com versões mais antigas deste bloco. Quando marcada, as palavras-chave antigas e novas serão reconhecidas e executadas.<br /><br />Por exemplo, o texto <b>&#35;TOTAL_FAM&#35;</b> será reconhecido como equivalente a <b>&#35;totalFamilies&#35;</b>, <b>&#35;FIRST_DEATH_PLACE&#35;</b> equivalente a <b>&#35;firstDeathPlace&#35;</b>, <b>&#35;TOP10_BIGFAM&#35;</b> equivalente a <b>&#35;topTenLargestFamily&#35;</b>, etc.<br /><br />A menos que seja absolutamente necessário, você não deve usar o modo de compatibilidade.";
$pgv_lang["index_htmlplus_gedcom_help"] 		= "~#pgv_lang[htmlplus_block_gedcom]#~<br /><br />Selecione o banco de dados ao qual as palavras-chave se aplicam.<br /><br />Seu site oferece suporte a vários bancos de dados. Palavras-chave como <b>&#35;totalFamilies&#35;</b> só podem se referir a um banco de dados. Você pode identificar o banco de dados que deve ser consultado para todas essas palavras-chave. Cada bloco #pgv_lang[htmlplus_block_name]# pode acessar apenas um banco de dados.";
$pgv_lang["showUnknown_help"]					= "~#pgv_lang[showUnknown]#~<br /><br />Oculte ou mostre a lista de nomes de pessoas de gênero desconhecido.<br /><br />O bloco #pgv_lang[block_givn_top10]# sempre esconde a lista de nomes dados quando nenhuma pessoa desse gênero existe em seu banco de dados. Esta opção permite ocultar a lista de pessoas de gênero desconhecido, mesmo quando existem tais pessoas em seu banco de dados.";

//-- Index-Page Help
$pgv_lang["help_help"]							= "Claro, seria ideal criar um programa tão simples e fácil de usar que não precisasse de nenhuma explicação; deve ser tão simples quanto ler um livro.<br /><br />Embora PhpGedView seja muito complicado, você não deve notar isso ao usá-lo; quase tudo pode ser usado sem explicação. Mas, como podemos ter muitos visitantes e usuários que não têm muita experiência com o uso do computador ou da Internet, oferecemos ajuda em alguns lugares.<br /><br />Você encontrará os seguintes itens no menu Ajuda:";
$pgv_lang["help_page_help"]						= "<ul><li><b>Ajuda com esta página</b><br />Para todas as páginas, existe uma \"Ajuda da página\" geral disponível. Você pode clicar neste item do menu para obter a \"Ajuda da página\", onde será informado sobre os itens daquela mesma página.<br /><br />A Ajuda da página costuma ser breve. Se precisar de mais ajuda ou informações sobre um determinado item na página do que a Ajuda da página fornece, você pode usar o recurso \"Ajuda contextual\".</li></ul>";
$pgv_lang["help_content_help"]					= "<ul><li><b>Conteúdo de ajuda</b><br />Ao clicar neste item de menu, você obterá uma página de Ajuda que exibe um índice dos principais tópicos da Ajuda. A quantidade de informações de Ajuda disponíveis aumentará conforme o tempo permitir.</li></ul>";
$pgv_lang["help_faq_help"]						= "<ul><li><b>Lista de FAQs</b><br />#pgv_lang[text_faq_help]#</li></ul>";
$pgv_lang["help_HS_help"]						= "<ul><li><b>#pgv_lang[hs_title]#</b><br />#pgv_lang[hs_intro]#</li></ul>";
$pgv_lang["help_qm_help"]						= "<ul><li><b>Ocultar / mostrar ajuda contextual</b><br />Este último item do menu pode ser o mais útil para você. Clicar neste link liga ou desliga a \"Ajuda contextual\".<br /><br />Com a Ajuda contextual ativada, você pode encontrar um ponto de interrogação ou ícone semelhante ao lado de alguns links, caixas suspensas ou botões. Ao clicar neste ícone, uma tela de Ajuda aparecerá. Esta tela de Ajuda contém informações sobre aquele objeto.<br /><br />Obviamente, quando você clicar em \"Ocultar Ajuda Contextual\", todos os Pontos de Interrogação ou ícones desaparecerão até que você clique em \"Mostrar ....\" novamente.</li></ul>";

//-- Index-page Definitions
$pgv_lang["def_help"]							= "<div class='name_head center'><b>#pgv_lang[definitions]#</b></div><br />Aqui estão algumas explicações dos termos usados neste texto de Ajuda:<ul><li><a href=\"#def_gedcom\"><b>GEDCOM</b></a><br /></li><li><a href=\"#def_gedcom_date\"><b>Datas</b></a></li><li><a href=\"#def_pdf_format\"><b>Formato de arquivo PDF</b></a></li><li><a href=\"#def_pgv\"><b>PhpGedView</b></a></li><li><a href=\"#def_portal\"><b>Portal</b></a></li><li><a href=\"#def_theme\"><b>Tema</b></a></li></ul>";
$pgv_lang["def_portal_help"]					= "~Portal~<br /><br />O Portal deste site é como o saguão de um restaurante ou biblioteca pública. É o local onde você entra, mas também pode encontrar informações importantes como explicações, menus etc.";
$pgv_lang["def_gedcom_help"]					= "~Arquivo GEDCOM~<br /><br />Uma citação da Introdução ao Padrão GEDCOM 5.5.1 (em inglês):<div class=\"list_value_wrap\">#pgv_lang[quote_gedcom]#</div><br />(Português):<div class=\"list_value_wrap\">O GEDCOM foi desenvolvido pelo Departamento de História da Família de A Igreja de Jesus Cristo dos Santos dos Últimos Dias (Igreja SUD) para fornecer um formato flexível e uniforme para a troca de dados genealógicos computadorizados. &nbsp;GEDCOM é um acrônimo para <i><b>GE</b></i>nealogical <i><b>D</b></i>ata <i><b>Com</b></i>munication (comunicação de dados genealógicos). &nbsp;Seu objetivo é promover o compartilhamento de informações genealógicas e o desenvolvimento de uma ampla gama de produtos de software interoperáveis para auxiliar genealogistas, historiadores e outros pesquisadores.</div><br />Uma cópia do padrão <u>de rascunho</u> GEDCOM 5.5.1, ao qual o PhpGedView adere, pode ser baixada em formato PDF aqui: &nbsp; <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\">Padrão GEDCOM 5.5.1</a> Este padrão está disponível apenas em inglês.<br /><br />O arquivo GEDCOM contém todas as informações sobre a família. Todos os fatos, datas, eventos, etc. são armazenados aqui. Os arquivos GEDCOM devem seguir regras rígidas porque devem ser intercambiáveis entre vários programas, independentemente de plataformas ou sistemas operacionais.";
$pgv_lang["def_gedcom_date_help"]				= "~Datas em um arquivo GEDCOM~<br /><br />Embora o campo de data permita a entrada de forma livre (significando que você pode digitar o que quiser), existem algumas regras sobre como as datas devem ser inseridas de acordo com o padrão GEDCOM 5.5.1. O padrão exige que os nomes dos meses sejam inseridos em inglês.<ul><li>Uma data completa é inserida no formato DD MMM AAAA. Por exemplo, <b>01&nbsp;MAR&nbsp;1801</b> ou <b>14&nbsp;DEC&nbsp;1950</b>.</li><li>Se estiver faltando uma parte da data, você pode omitir isso parte. Por exemplo: <b>MAR&nbsp;1801</b> ou <b>14&nbsp;DEC</b>.</li><li>Se não tiver certeza ou a data não for confirmada, você pode inserir <b>ABT&nbsp;MAR&nbsp;1801</b> (abt = sobre), <b>BEF&nbsp;20&nbsp;DEC&nbsp;1950</b> (bef = antes), <b>AFT&nbsp;1949</b> (aft = depois)</li><li>Os intervalos de datas são inseridos como <b>FROM&nbsp;MAR&nbsp;1801&nbsp;TO&nbsp;20&nbsp;DEC&nbsp;1810</b> ou como <b>BET&nbsp;MAR&nbsp;1801&nbsp;AND&nbsp;20&nbsp;DEC&nbsp;1810</b> (from = de; to = a; bet = entre; and = e)<br /><br /><b>FROM</b> indica que o evento que está sendo descrito aconteceu continuamente entre as datas indicadas e é usado com eventos como emprego. <b>BET</b> indica uma única ocorrência do evento, em algum momento entre as datas indicadas e é usado com eventos como nascimento.<br /><br />Datas imprecisas, em que falta o dia do mês ou mês, são sempre interpretadas como a primeira ou a última data possível, consoante essa data imprecisa ocorra antes ou depois da palavra-chave separadora. Por exemplo, <b>FEB&nbsp;1804</b> é interpretado como <b>01&nbsp;FEB&nbsp;1804</b> quando ocorre antes de TO ou AND e como <b>29&nbsp;FEB&nbsp;1804</b> quando ocorre após o TO ou AND. Em 1804, fevereiro tinha 29 dias.</li></ul><br /><b>Certifique-se de inserir datas e abreviações em <u>Inglês</u>,</b> porque então o arquivo GEDCOM é intercambiável e PhpGedView pode traduzir todas as datas e abreviações corretamente para o idioma ativo no momento. Além disso, PhpGedView faz cálculos usando essas datas. Se datas incorretas forem inseridas nos campos de data, PhpGedView não será capaz de calcular corretamente. Você pode clicar no ícone Calendário para obter ajuda na seleção de uma data.<br /><br />As seguintes abreviações são usadas:<ul><li>JAN = January = Janeiro</li><li>FEB = February = Fevereiro</li><li>MAR = March = Março</li><li>APR = April = Abril</li><li>MAY = Maio</li><li>JUN = June = Junho</li><li>JUL = July = Julho</li><li>AUG = August = Agosto</li><li>SEP = September = Setembro</li><li>OCT = October = Outubro</li><li>NOV = November = Novembro</li><li>DEC = December = Dezembro</li><li>bef = before = antes</li><li>abt = about = sobre</li><li>aft = after = depois</li></ul>";
$pgv_lang["def_gramps_help"]					= "~Arquivo de banco de dados GRAMPS XML~<br /><br />Uma citação em inglês do Projeto GRAMPS:<div class=\"list_value_wrap\">#pgv_lang[quote_gramps]#</div><br />(Português)<div class=\"list_value_wrap\">GRAMPS ajuda você a rastrear sua árvore genealógica. Ele permite que você armazene, edite e pesquise dados genealógicos. O GRAMPS tenta fornecer todos os recursos comuns de outros programas genealógicos, mas, mais importante, fornecer um recurso adicional de integração não comum a esses programas. Esta é a capacidade de inserir quaisquer bits e peças de informação diretamente no GRAMPS e reorganizar / manipular qualquer / todos os eventos de dados em toda a base de dados (em qualquer ordem ou sequência) para auxiliar o usuário a fazer pesquisas, análises e correlação com o potencial de preencher lacunas de relacionamento.</div><br />Uma cópia do formato XML GRAMPS v1.1.0 <a href=\"http://www.gramps-project.org/xml/1.1.0/\" target=\"_blank\">pode ser encontrada aqui</a> no formato RELAX NG Schema e no formato DTD.<br /><br />Para obter mais informações sobre o Projeto GRAMPS, visite <a href=\"http://gramps-project.org/\" target=\"_blank\">http://gramps-project.org/</a>";
$pgv_lang["def_pgv_help"]						= "~PhpGedView~<br /><br />PhpGedView (ou PGV) não apenas coloca páginas estáticas na Web; é dinâmico e pode ser personalizado de várias maneiras.<br /><br />PhpGedView foi criado por John Finlay para visualizar arquivos GEDCOM online. John começou a desenvolver o programa por conta própria. Uma equipe internacional de desenvolvedores e tradutores se juntou a ele e está trabalhando para melhorar o programa. Entre os recursos mais significativos que foram adicionados ou aprimorados no programa estão o amplo suporte a outros idiomas além do inglês e a capacidade de adicionar e editar eventos online.";
$pgv_lang["def_theme_help"]						= "~Tema~<br /><br />Este site pode ter diferentes \"aparências\", chamadas Temas.<br /><br />O administrador do site escolhe um tema padrão, que todos que entrarem neste site verão inicialmente. Quando o administrador habilita esse recurso, todos os usuários podem selecionar seus próprios Temas. O PhpGedView lembra o último tema selecionado para cada usuário conectado, de modo que o usuário verá automaticamente esse tema na próxima vez que fizer login. Os temas podem ser usados como uma forma de distinguir entre bancos de dados diferentes no mesmo site. Cada banco de dados pode ter um tema padrão diferente.";

//-- Index-page MyGEDCOM
$pgv_lang["mygedview_portal_help"]				= "~#pgv_lang[mygedview]#~<br /><br />Esta é a sua página #pgv_lang[mgv]# pessoal.<br /><br />Aqui você encontrará links fáceis para acessar seus dados pessoais, como <b>Minha conta</b>, <b>Meu Indi</b> (esta é sua página #pgv_lang[indi_info]#) e <b>Meu Pedigree</b>. Você pode ter blocos com <b>Mensagens</b>, um <b>Diário</b> (como um Bloco de notas) e muito mais.<br /><br />O layout desta página é semelhante à página de boas-vindas que você vê ao acessar este site pela primeira vez. Enquanto as partes da página de boas-vindas são selecionadas pelo administrador do site, você pode selecionar quais partes incluir nesta página personalizada. Você encontrará o link para personalizar esta página no bloco de Boas-vindas ou separadamente quando o bloco de Boas-vindas não estiver presente.<br /><br />Você pode escolher entre os seguintes blocos e links:<ul><li><a href=\"#mygedview_welcome\"><b>#pgv_lang[welcome_block]#</b></a></li><li><a href=\"#mygedview_customize\"><b>Personalizar «#pgv_lang[mygedview]#»</b></a></li><li><a href=\"#mygedview_message\"><b>#pgv_lang[user_messages_block]#</b></a></li><li><a href=\"#mygedview_events\"><b>#pgv_lang[upcoming_events_block]#</b></a></li><li><a href=\"#mygedview_onthisday\"><b>#pgv_lang[todays_events_block]#</b></a></li><li><a href=\"#mygedview_charts\"><b>#pgv_lang[charts_block]#</b></a></li><li><a href=\"#mygedview_favorites\"><b>#pgv_lang[user_favorites_block]#</b></a></li><li><a href=\"#mygedview_stats\"><b>#pgv_lang[gedcom_stats_block]#</b></a></li><li><a href=\"#mygedview_myjournal\"><b>#pgv_lang[user_news_block]#</b></a></li><li><a href=\"#mygedview_media\"><b>#pgv_lang[random_media_block]#</b></a></li><li><a href=\"#mygedview_loggedin\"><b>#pgv_lang[logged_in_users_block]#</b></a></li><li><a href=\"#recent_changes\"><b>#pgv_lang[recent_changes_block]#</b></a></li></ul>";
$pgv_lang["mygedview_customize_help"]			= "~PERSONALIZAR #pgv_lang[mygedview]#~<br /><br />Ao ver esta página pela primeira vez, já existiam blocos definidos. Caso deseje, você poderá personalizar o Portal do Site.<br /><br />Ao clicar este link, será exibida uma página onde será possível mover, excluir ou adicionar blocos ao Portal. Mais ajuda está disponível nesta página de personalização.";
$pgv_lang["mygedview_message_help"]				= "~#pgv_lang[user_messages_block]#~<br /><br />Neste bloco você encontrará as mensagens enviadas a você por outros usuários ou pelo administrador. Você também pode enviar mensagens para outros usuários ou para o administrador.<br /><br />O sistema de email PhpGedView foi projetado para ajudar a proteger sua privacidade. Você não precisa deixar seu endereço de e-mail aqui e outras pessoas não poderão ver seu endereço de e-mail.<br /><br />Para expandir uma mensagem, clique no assunto da mensagem ou no símbolo \"<b>+</b>\" ao lado dela. Você pode excluir várias mensagens marcando as caixas ao lado das mensagens que deseja excluir e clicando no botão <b>Excluir mensagens selecionadas</b>.";
$pgv_lang["mygedview_favorites_help"]			= "~#pgv_lang[user_favorites_block]#~<br /><br />Os favoritos são semelhantes aos favoritos.<br /><br />Suponha que você tenha alguém na árvore genealógica cujo registro você deseja verificar regularmente. Basta ir à página #pgv_lang[indi_info]# da pessoa e selecionar a opção <b>Adicionar a Meus Favoritos</b> na lista suspensa Favoritos. Esta pessoa agora está marcada no livro e adicionada à sua lista de favoritos.<br /><br />Onde quer que você esteja neste site, você pode clicar em um nome na lista suspensa \"Meus favoritos\" no cabeçalho. Isso o levará para a página #pgv_lang[indi_info]# dessa pessoa.";
$pgv_lang["mygedview_myjournal_help"]			= "~#pgv_lang[user_news_block]#~<br /><br />Você pode usar este diário para escrever notas ou lembretes para seu próprio uso. Quando você fizer tal nota, ela ainda estará lá na próxima vez que você visitar o site.<br /><br />Essas notas são privadas e não estarão visíveis para outras pessoas.";
$pgv_lang["mygedview_welcome_help"]				= "~#pgv_lang[welcome_block]#~<br /><br />O bloco de boas-vindas mostra:<ul><li>O arquivo GEDCOM atual</li><li>A data e hora</li><li>Links para:<ul><li>#pgv_lang[myuserdata]#</li><li>#pgv_lang[my_pedigree]#</li><li>#pgv_lang[my_indi]#</li><li>#pgv_lang[customize_page]#</li></ul></li></ul><br /><b>Nota:</b><br />Você verá os links para <b>#pgv_lang[my_indi]#</b> e <b>#pgv_lang[my_pedigree]#</b> somente se for conhecido pelo arquivo GEDCOM atual, enquanto em outro arquivo GEDCOM você não tem um registro e, conseqüentemente, esses links são não exibido.";

//-- Pedigree-page
$pgv_lang["help_pedigree.php"]					= "~A PÁGINA PEDIGREE~<br /><br />Um pedigree é uma enumeração de todos os ancestrais da pessoa inicial. Os usuários que não estão logados veem o pedigree da pessoa inicial (root) escolhida pelo administrador do site. Os usuários conectados podem selecionar sua própria pessoa inicial (root).<br /><br />Nesse contexto, \"Todos os ancestrais\" significa o pai e a mãe, seus pais e assim por diante. O pedigree é exibido graficamente; você não precisa se esforçar por páginas de texto para determinar seus ancestrais.<br /><br />Todas as pessoas são exibidas nas caixas de nomes na tela.<br /><ul><li><b>Caixas de nome no pedigree</b><br />Se a página de Linhagem estiver configurada para mostrar detalhes, você verá o nome da pessoa e as datas de nascimento e falecimento. Você pode clicar no nome de uma pessoa para ir diretamente para a página #pgv_lang[indi_info]# dessa pessoa.<br /><br />Quando <b>Mostrar detalhes</b> está ativado, há dois ícones dentro da caixa de nome.</li><li><b>Ícone de linhagem dentro da caixa Nome</b><br />Quando a opção <b>Mostrar Detalhes</b> está ativada, você vê um ícone de Linhagem na caixa Nome. Dependendo das configurações do site, você deve passar o mouse sobre o ícone ou clicar nele. Quando você clica ou passa o mouse sobre este ícone, um pequeno submenu aparece.<br /><br />Os itens <b>#pgv_lang[index_header]#</b> e <b>#pgv_lang[descend_chart]#</b> são semelhantes aos itens do menu principal, mas a diferença é que a pessoa inicial agora é o individual ou mencionado na caixa Nome. Você também vê <b>#pgv_lang[as_spouse]#</b>. Abaixo, você vê o nome do cônjuge seguido dos nomes dos filhos. Todos os nomes são clicáveis.</li><li><b>Lupa dentro da caixa Nome</b><br />Dependendo das configurações do site, você deve passar o mouse sobre o ícone ou clicar nele. Isso amplia a caixa Nome para que mais detalhes sejam exibidos. Você verá mais datas e eventos. Os nomes são clicáveis.</li><li><b>Setas</b><br />À esquerda ou à direita das caixas de nome mais à esquerda ou à direita, você pode ver setas. Quando você clica nessas setas, a exibição da tela muda na direção da seta.</li></ul><br />#pgv_lang[context_help]#";
$pgv_lang["show_full_help"]						= "~#pgv_lang[show_details]#~<br /><br />Com esta opção, você pode mostrar ou ocultar todos os detalhes nas caixas Nome. Você pode exibir mais caixas em uma tela quando os detalhes estão ocultos.<br /><br />Quando todos os detalhes estão ocultos, o ícone de zoom descrito abaixo não é mostrado. No entanto, se o administrador habilitou a função Zoom, a caixa inteira funcionará como um ícone de Zoom para revelar todos os detalhes sobre a pessoa.<br /><br />Quando os detalhes não estão ocultos e a função Zoom, identificada por um ícone de lupa, foi habilitada pelo administrador, você pode revelar ainda mais detalhes sobre essa pessoa. Se você normalmente tem que clicar no ícone Zoom para aumentar o zoom, você pode revelar detalhes ocultos adicionais clicando nesse ícone aqui. Da mesma forma, se você puder aumentar o zoom passando o mouse sobre o ícone de Zoom, os detalhes ocultos serão revelados passando o mouse sobre esse ícone aqui.<br /><br />Se você clicou no ícone Zoom para revelar mais detalhes, você pode restaurar a caixa ao seu nível normal de detalhes clicando no ícone Zoom novamente. Se você revelou mais detalhes simplesmente movendo o ponteiro do mouse sobre o ícone Zoom, a caixa será restaurada ao seu nível normal de detalhes quando você mover o ponteiro do mouse para longe do ícone Zoom.";
$pgv_lang["talloffset_help"]					= "~#pgv_lang[portrait]# / #pgv_lang[landscape]#~<br /><br />Com esta opção, você determina a orientação do layout da página.<br /><br />Alterar esta configuração pode ser útil se você quiser fazer uma impressão da tela ou se tiver um tipo diferente de tela.<ul><li><b>#pgv_lang[portrait]#</b>&nbsp;&nbsp;&nbsp;tornará a árvore mais alta, de forma que um gráfico de 4 gerações caiba em uma única página impressa verticalmente.</li><li><b>#pgv_lang[landscape]#</b>&nbsp;&nbsp;&nbsp;criará uma árvore mais ampla que deverá ser impressa em uma única página impressa horizontalmente.</li><li><b>#pgv_lang[landscape_top]#</b>&nbsp;&nbsp;&nbsp;gira o gráfico, mas não suas caixas, em 90 graus no sentido anti-horário, de modo que a geração mais antiga fique no topo do gráfico.</li><li><b>#pgv_lang[landscape_down]#</b>&nbsp;&nbsp;&nbsp;gira o gráfico, mas não suas caixas, em 90 graus no sentido horário, de modo que a geração mais antiga fique na parte inferior do gráfico.</li></ul>";
$pgv_lang["rootid_help"]						= "~#pgv_lang[rootid]#~<br /><br />Se você deseja exibir um gráfico com uma nova pessoa inicial (raiz), o ID dessa nova pessoa inicial é digitado aqui.<br /><br />Se você não souber o ID dessa pessoa, use o link <b>Encontrar ID</b>.<br /><br /><b>NÚMERO DE IDENTIDADE</b><br />Os números de identificação usados no PhpGedView <u>não</u> são os números de identificação emitidos por vários governos (carteira de motorista ou número de passaporte, por exemplo). O número de ID referido aqui é simplesmente um número usado no banco de dados para identificar exclusivamente cada indivíduo; ele foi atribuído pelo programa de ancestralidade que criou o arquivo GEDCOM que foi importado para o PhpGedView.";
$pgv_lang["PEDIGREE_GENERATIONS_help"]			= "~#pgv_lang[generations]#~<br /><br />Aqui você pode definir o número de gerações a serem exibidas nesta página.<br /><br />O número certo para você depende do tamanho da sua tela e se você mostra os detalhes ou não. O tempo de processamento aumentará conforme você aumenta o número de gerações.";

//-- LOGIN-page
$pgv_lang["login_page_help"]					= "~#pgv_lang[login]#~<br /><br />Nesta página você pode fazer o login, solicitar uma nova senha ou solicitar uma nova conta de usuário.";
$pgv_lang["username_help"]						= "~#pgv_lang[username]#~<br /><br />Nesta caixa, você digita seu nome de usuário.<br /><br /><b>O nome de usuário diferencia maiúsculas de minúsculas.</b>  Isso significa que <b>MeuNome</b> <u>não</u> é o mesmo que <b>meunome</b> ou <b>MEUNOME</b>.";
$pgv_lang["password_help"]						= "~#pgv_lang[password]#~<br /><br />Nesta caixa você digita sua senha.<br /><br /><b>A senha é sensível a maiúsculas.</b>  Isso significa que <b>MinhaSenha</b> <u>não</u> é o mesmo que <b>minhasenha</b> ou <b>MINHASENHA</b>.";
$pgv_lang["login_buttons_help"]					= "~BOTÃO CONECTE-SE~<br /><br />Aqui você vê um botão para fazer o login no sistema.<br /><br />Se clicar neste botão, você retornará à página em que acabou de acessar, mas com direitos de acesso logados.<br /><br />Por exemplo, se você clicar em <b>#pgv_lang[login]#</b> quando estiver na página de Linhagem, você retornará a essa mesma página. Se você clicar neste botão quando estiver na página inicial de boas-vindas, será direcionado para a página «#pgv_lang[mygedview]#», onde poderá editar suas configurações, adicionar ou editar favoritos, enviar e ler mensagens, etc.";
$pgv_lang["login_buttons_aut_help"]				= "~BOTÃO CONECTE-SE~<br /><br />Aqui você vê um botão para fazer o login no sistema.<br /><br />Se você clicar neste botão, você estará conectado e irá diretamente para a página «#pgv_lang[mygedview]#», onde poderá editar suas configurações, adicionar ou editar favoritos, enviar e ler mensagens, etc.";
$pgv_lang["new_password_help"]					= "~#pgv_lang[requestpassword]#~<br /><br />Se você esqueceu sua senha, pode clicar neste link para solicitar uma nova senha.<br /><br />Você será direcionado para a página «#pgv_lang[lost_pw_reset]#».";
$pgv_lang["new_user_help"]						= "~#pgv_lang[requestaccount]#~<br /><br />Se você é um visitante deste site e deseja solicitar uma conta de usuário, pode clicar neste link.<br /><br />Dependendo de como o administrador configurou o site, seu cliente de e-mail pode ser iniciado para que você possa enviar um e-mail ao administrador para solicitar uma nova ID de login ou você pode ser levado para a página «#pgv_lang[requestaccount]#».";
$pgv_lang["mygedview_login_help"]				= "Para obter acesso ao «#pgv_lang[mygedview]#», você dever ser um usuário registrado no sistema.<br /><br />No \"Meu Portal\" você pode relacionar suas pessoas favoritas, enviar e receber mensagens, ver outros usuários conectados, etc ...<br /><br />Preencha os campos com seu nome de Usuário e Senha para obter acesso e se Conectar ao portal.";
$pgv_lang["new_user_firstname_help"]			= "~#pgv_lang[firstname]#~<br /><br />Nesta caixa, você deve digitar o seu nome.<br /><br />Precisamos de seu nome e sobrenome para determinar se você se qualifica para uma conta neste site e quais devem ser seus direitos. Esses nomes ficarão visíveis para outros membros da família e usuários conectados.";
$pgv_lang["new_user_lastname_help"]				= "~#pgv_lang[lastname]#~<br /><br />Nesta caixa você deve digitar seu sobrenome.<br /><Precisamos de seu nome e sobrenome para determinar se você se qualifica para uma conta neste site e quais devem ser seus direitos. Esses nomes ficarão visíveis para outros membros da família e usuários conectados.";
$pgv_lang["register_info_01"]					= "~#pgv_lang[requestaccount]#~<br /><br />A quantidade de dados que podem ser visualizados publicamente neste site pode ser limitada devido à legislação aplicável relativa à proteção da privacidade. Muitas pessoas não querem seus dados pessoais disponíveis publicamente na Internet. Os dados pessoais podem ser usados indevidamente para spam ou roubo de identidade.<br /><br />O acesso a este site é permitido a todos os visitantes que possuam uma conta de usuário. Depois que o administrador verificar e aprovar seu aplicativo de conta, você poderá fazer o login.<br /><br />Se a Privacidade de Relacionamento estiver ativada, você só poderá acessar as informações privadas de seus parentes próximos após o login. O administrador também pode permitir a edição do banco de dados para determinados usuários, para que eles possam alterar ou adicionar informações.<br /><br />Se precisar de mais ajuda, use o link abaixo para entrar em contato com o administrador.";
$pgv_lang["register_info_02"]					= "~#pgv_lang[requestaccount]#~<br /><br />A quantidade de dados que podem ser visualizados publicamente neste site pode ser limitada devido à legislação aplicável relativa à proteção da privacidade. Muitas pessoas não querem seus dados pessoais disponíveis publicamente na Internet. Os dados pessoais podem ser usados indevidamente para spam ou roubo de identidade.<br /><br />O acesso a este site é permitido apenas a usuários <u>autorizados</u>. Depois que o administrador verificar e aprovar seu aplicativo de conta, você poderá fazer o login e visualizar os dados privados.<br /><br />Se a Privacidade de Relacionamento estiver ativada, você só poderá acessar as informações privadas de seus parentes próximos após o login. O administrador também pode permitir a edição do banco de dados para determinados usuários, para que eles possam alterar ou adicionar informações.<br /><br />Se precisar de mais ajuda, use o link abaixo para entrar em contato com o administrador.";
$pgv_lang["register_info_03"]					= "~#pgv_lang[requestaccount]#~<br /><br />A quantidade de dados que podem ser visualizados publicamente neste site pode ser limitada devido à legislação aplicável em relação à proteção da privacidade. Muitas pessoas não querem seus dados pessoais disponíveis publicamente na Internet. Os dados pessoais podem ser usados indevidamente para spam ou roubo de identidade.<br /><br />O acesso a este site é permitido apenas a <u>membros da família</u>. Depois que o administrador verificar e aprovar seu aplicativo de conta, você poderá fazer o login e visualizar os dados privados.<br /><br />Se a Privacidade de Relacionamento estiver ativada, você só poderá acessar as informações privadas de seus parentes próximos após o login. O administrador também pode permitir a edição do banco de dados para determinados usuários, para que eles possam alterar ou adicionar informações.<br /><br />Se precisar de mais ajuda, use o link abaixo para entrar em contato com o administrador.";


//-- Descendancy-page
$pgv_lang["help_descendancy.php"]				= "~#pgv_lang[descend_chart]#~<br /><br />Esta página mostrará os descendentes de uma pessoa.<br /><br />Você pode escolher uma pessoa inicial (raiz) para este gráfico de descendência ou pode ser vinculado a esta página clicando no link <b>#pgv_lang[descend_chart]#</b> em outra página. Clique nos ícones de seta para navegar nesta árvore na direção da seta. Clique no ícone Gráfico em qualquer caixa de Pessoa para alterar a raiz da árvore para aquela pessoa.";
$pgv_lang["desc_rootid_help"]					= "#pgv_lang[rootid_help]#";
$pgv_lang["desc_generations_help"]				= "#pgv_lang[PEDIGREE_GENERATIONS_help]#";

//-- Time line-page
$pgv_lang["help_lifespan.php"]					= "~#pgv_lang[lifespan_chart]#~<br /><br />Neste gráfico, você pode exibir uma ou mais pessoas ao longo de uma linha do tempo horizontal. Este gráfico permite que você veja como as vidas de diferentes pessoas se sobrepõem.<br /><br />Você pode adicionar pessoas ao gráfico individualmente ou por grupos familiares por meio de seus IDs. A lista anterior será lembrada conforme você adiciona mais pessoas ao gráfico. Você pode limpar o gráfico a qualquer momento com o botão <b>Limpar Gráfico</b>.<br /><br />Você também pode adicionar pessoas ao gráfico pesquisando por intervalo de datas ou localidade.";
$pgv_lang["lifespan_add_person_help"]			= "#pgv_lang[add_person_help]#<br /><br /><b>Incluir Família Imediata</b><br />Incluir família imediata é marcada por padrão. Deixe marcado para ver o pai, mãe, cônjuge, irmãos e filhos da pessoa que está sendo adicionada à linha do tempo. Desmarque se você deseja omitir a família imediata.";
$pgv_lang["help_timeline.php"]					= "~#pgv_lang[timeline_chart]#~<br /><br />Neste gráfico, você pode exibir uma ou mais pessoas ao longo de uma linha do tempo. Você pode, por exemplo, visualizar o estado de duas ou mais pessoas em um determinado momento.<br /><br />Se você clicar no link <b>Linha do tempo</b> em outra página, já verá uma pessoa na linha do tempo. Se você clicou no item de menu <b>Linha do tempo</b> em um cabeçalho de página, você deve fornecer o ID da pessoa inicial.";
$pgv_lang["add_person_help"]					= "~#pgv_lang[add_another]#~<br /><br />Você pode ter várias pessoas na linha do tempo.<br /><br />Use esta caixa para fornecer a identificação de cada pessoa. Se você não souber o ID da pessoa, pode clicar no link <b>Encontrar ID</b> ao lado da caixa.";
$pgv_lang["remove_person_help"]					= "~#pgv_lang[remove_person]#~<br /><br />Clique neste link para remover a pessoa da linha do tempo.";
$pgv_lang["show_age_marker_help"]				= "~#pgv_lang[show_age]#~<br /><br />Se você marcar esta caixa, verá um marcador de idade.<br /><br />Você pode deslizar este marcador de idade para cima ou para baixo ao longo da linha do tempo. O marcador deslizante de idade é uma boa ferramenta para verificar a idade de uma pessoa em um determinado evento. Você pode ativar ou desativar o marcador de idade separadamente para cada pessoa no gráfico.";
$pgv_lang["timeline_control_help"] 				= "~#pgv_lang[timeline_controls]#~<br /><br />~velocidade~<br />Clique no menu suspenso para alterar a velocidade de rolagem da linha do tempo.<br /><br />~Ano inicial~<br />Insira o ano inicial do intervalo.<br /><br />~ano final~<br />Insira o ano final do intervalo.<br /><br />~Pesquisa~<br />Clique no botão Pesquisar para começar a pesquisar eventos que ocorreram dentro do intervalo identificado pelos campos Ano inicial e Ano final.";

//-- Relationship-page
$pgv_lang["help_relationship.php"]				= "~#pgv_lang[relationship_chart]#~<br /><br />Nesta página, você pode exibir o relacionamento entre duas pessoas quaisquer. Essas pessoas não precisam ser relacionadas diretamente por linha de sangue; qualquer relação será encontrada.";
$pgv_lang["relationship_id_help"]				= "~#pgv_lang[id]# :: #pgv_lang[person1]# :: #pgv_lang[person2]#~<br /><br />Se você saltou de outra página para esta ao clicar no link <b>Relação comigo</b>, verá aqui a relação entre você e essa outra pessoa.<br /><br />Se você chegou a esta página através da entrada do menu <b>Gráfico de relacionamento</b> em qualquer cabeçalho da página, você deve digitar os números identificadores das duas pessoas cujo relacionamento você deseja ver. Se você não souber o identificador da pessoa desejada, pode clicar no link <b>Encontrar ID</b>.";
$pgv_lang["next_path_help"]						= "~#pgv_lang[next_path]#~<br /><br />Você pode clicar neste botão para ver se há outro caminho de relacionamento entre as duas pessoas. Os caminhos encontrados anteriormente podem ser exibidos novamente clicando no link com o número do caminho.";
$pgv_lang["follow_spouse_help"]					= "~#pgv_lang[follow_spouse]#~<br /><br />Com esta caixa de seleção <b>des</b>marcada, os relacionamentos são encontrados apenas entre parentes de sangue. Com esta caixa de seleção marcada, relacionamentos por casamento também são encontrados. Você provavelmente encontrará mais relacionamentos deixando esta caixa marcada.";
$pgv_lang["line_up_generations_help"]			= "~#pgv_lang[line_up_generations]#~<br /><br />Quando esta caixa de seleção está marcada, o gráfico será impresso com as mesmas gerações alinhadas horizontalmente na página. Quando está desmarcada, cada geração aparecerá descendo a página independentemente do tipo de relacionamento.";
$pgv_lang["oldest_top_help"]          			= "~#pgv_lang[oldest_top]#~<br /><br />Quando esta caixa de seleção está marcada, o gráfico será impresso com as pessoas mais velhas no topo. Quando está desmarcada, os mais jovens aparecem no topo.<br /><br />Observação: esta opção funciona apenas se <b>#pgv_lang[line_up_generations]#</b> também estiver marcada.";

//-- Ancestry-page
$pgv_lang["help_ancestry.php"]					= "~#pgv_lang[ancestry_chart]#~<br /><br />A página Ancestrais é muito semelhante a <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, mas com mais detalhes e alternativas <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a> exibe.<br /><br />Cada ancestralidade é mostrada com um número único, calculado de acordo com o sistema <i>Sosa-Stradonitz</i>:<div style=\"padding-left: 30px;\">Números <b>pares</b> para homens (criança * 2)<br />Números <b>ímpares</b> para mulheres (marido + 1) exceto para <b>1</b></div><br />Exemplo:<br /><div style=\"padding-left: 30px;\">A pessoa root é <b>1</b>, independentemente do sexo.<br />pai de <b>1</b> é <b>2</b> (<b>1</b> * 2), mãe é <b>3</b> (<b>2</b> + 1).<br /> pai de <b>2</b> é <b>4</b> (<b>2</b> * 2), mãe é <b>5</b> (<b>4</b> + 1)).<br />pai de <b>3</b> é <b>6</b> (<b>3</b> * 2), mãe é <b>7</b> (<b>6</b> + 1).<br /> pai de <b>7</b> é <b>14</b> (<b>7</b> * 2), mãe é <b>15</b> (<b>14</b> + 1).<br />etc.</div>";
$pgv_lang["box_width_help"]						= "~#pgv_lang[ancestry_chart]# - largura da caixa~<br /><br />Aqui você pode alterar a largura da caixa de 50% para 300%. Em 100%, cada caixa tem cerca de 270 pixels de largura.";
$pgv_lang["chart_style_help"]					= "~#pgv_lang[chart_style]#~<br /><br />Dois estilos de gráfico estão disponíveis:<ul><li><b>#pgv_lang[chart_list]#</b>&nbsp;&nbsp;&nbsp;Árvore vertical, com famílias recolhíveis / expansíveis.</li><li><b>#pgv_lang[chart_booklet]#</b>&nbsp;&nbsp;&nbsp;Uma família por página, com pais, avós e todos os filhos registrados.<br /><br />Este formato é fácil de imprimir para dar aos seus familiares.</li></ul>";

//-- Fan chart-page
$pgv_lang["help_fanchart.php"]					= "~#pgv_lang[fan_chart]#~<br /><br />O Diagrama do Círculo é muito semelhante ao <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, mas de uma forma mais gráfica.<br /><br />A pessoa Raiz é mostrada no centro, seus pais no primeiro anel, avós no segundo toque e assim por diante.<br /><br />Os anos de nascimento e morte são impressos sob o nome, quando conhecidos.<br /><br />Clicar em um nome no gráfico abrirá um menu de links específico para aquela pessoa. Nesse menu, você pode escolher centralizar o diagrama nessa pessoa ou em um de seus parentes próximos, ou pode pular para a página #pgv_lang[indi_info]# dessa pessoa ou para um gráfico diferente para essa pessoa.";
$pgv_lang["fan_width_help"]						= "~#pgv_lang[fan_chart]#~<br /><br />Aqui você pode alterar a largura do diagrama de 50% a 300%. Em 100%, a imagem de saída tem cerca de 640 pixels de largura.";
$pgv_lang["fan_style_help"]						= "~#pgv_lang[fan_chart]# estilo~<br /><br />Esta opção controla a aparência do diagrama.<ul><li><b>1/2</b>&nbsp;&nbsp;&nbsp;Semicírculo 180&deg; diagrama</li><li><b>3/4</b>&nbsp;&nbsp;&nbsp;Três quartos 270&deg; diagrama, às vezes chamado de <i>Asa do anjo</i></li><li><b>4/4</b>&nbsp;&nbsp;&nbsp;Círculo completo 360&deg; diagrama</li></ul>";

//-- Hourglass chart-page
$pgv_lang["help_hourglass.php"]					= "~#pgv_lang[hourglass_chart]#~<br /><br />O gráfico de ampulheta mostrará os ancestrais e descendentes da pessoa raiz selecionada no mesmo gráfico. Este gráfico é uma mistura entre o gráfico de descendência e o gráfico de linhagem.<br /><br />A pessoa raiz é centralizada no meio da página com seus descendentes listados à esquerda e seus ancestrais listados à direita. Nessa visualização, cada geração é alinhada na página, começando com a geração mais antiga e terminando com a mais recente.<br /><br />Se houver uma seta para baixo na tela sob a pessoa raiz, clicar nela exibirá uma lista dos membros próximos da família da pessoa raiz que você pode usar para navegar para baixo no gráfico. Selecionar um nome nesta lista recarregará o gráfico com a pessoa selecionada como a nova pessoa raiz.";

//-- Family Book chart-page
$pgv_lang["help_familybook.php"]				= "~#pgv_lang[familybook_chart]#~<br /><br />Este gráfico é muito semelhante ao gráfico Ampulheta. Ele mostrará os ancestrais e descendentes da pessoa raiz selecionada no mesmo gráfico. Também mostrará os descendentes da pessoa raiz no mesmo formato de Ampulheta.<br /><br />A pessoa raiz é centralizada no meio da página com seus descendentes listados à esquerda e seus ancestrais listados à direita. Nessa visualização, cada geração é alinhada na página, começando com a geração mais antiga e terminando com a mais recente.<br /><br />Cada descendente da pessoa raiz se tornará a pessoa raiz de um gráfico de ampulheta adicional, impresso na mesma página. Este processo se repete até que o número especificado de gerações descendentes seja impresso.";
$pgv_lang["fambook_descent_help"]				= "~#pgv_lang[descent_steps]#~<br /><br />Este valor determina o número de gerações descendentes da pessoa root que serão impressas no formato Ampulheta.";

//-- Indilist-page
$pgv_lang["help_indilist.php"]					= "~lista de pessoas~<br /><br />Nesta página você pode exibir uma lista de pessoas. Os nomes serão exibidos primeiro com os sobrenomes e classificados em ordem alfabética.<br /><br />A lista de nomes depende de:<ul><li>A letra em que você clicou no índice alfabético.</li><li>Se você clicou em \"Ignorar\" ou \"Mostrar\" a Lista de Sobrenome.</li></ul>#pgv_lang[context_help]#";
$pgv_lang["alpha_help"]							= "~ÍNDICE ALFABÉTICO~<br /><br />Clicar em uma letra no índice alfabético exibirá uma lista dos nomes que começam com a letra que você clicou.<br /><br />O penúltimo item no índice alfabético pode ser <b>#pgv_lang[NN]#</b>. Esta entrada estará presente quando houver pessoas na base de dados cujo sobrenome não foi registrado ou não contém nenhuma letra reconhecível. Sobrenomes desconhecidos geralmente são registrados como <b>?</b> e serão reconhecidos como <b>#pgv_lang[NN]#</b>. Isso também acontecerá se a pessoa for desconhecida.<br /><br /><b>Nota:</b><br />Sobrenomes inseridos como, por exemplo, <b>Nn</b>, <b>NN</b>, <b>Desconhecido</b> ou mesmo <b>NN</b> <u>não</u> ser encontrado na lista <b>#pgv_lang[NN]#</b>. Em vez disso, você encontrará essas pessoas clicando em <b>N</b> ou <b>D</b>, pois essas são as letras iniciais desses nomes. PhpGedView não pode ser responsável por todas as maneiras possíveis de inserir sobrenomes desconhecidos; não há convenção reconhecida para isso.<br /><br />No final do índice alfabético, você verá <b>TODOS</b>. Ao clicar neste item, você verá uma lista de todos os sobrenomes do banco de dados.<br /><br /><b>Cartas desaparecidas?</b><br />Se o seu índice alfabético parecer incompleto, com letras faltando, seu banco de dados não contém nenhum sobrenome que comece com essa letra faltando.";
$pgv_lang["name_list_help"]						= "~lista de nomes~<br /><br />Esta caixa exibirá uma lista de sobrenomes ou uma lista completa de nomes. Em ambos os casos, todos os sobrenomes começarão com a letra inicial que você clicou no índice alfabético, a menos que você tenha clicado em <b>TODOS</b>.<br /><br />Se você verá uma lista de sobrenomes ou a lista completa de nomes depende do status do link <b>Ignorar / Mostrar listas de sobrenomes</b>.";
$pgv_lang["skip_sublist_help"]					= "~PULAR SUBLISTA~<br /><br />A configuração padrão é que, depois de clicar em uma letra do índice alfabético, você obterá uma sublista com sobrenomes. Se você clicar neste link, todos os indivíduos com sobrenomes que possuam a letra inicial atualmente selecionada serão exibidos imediatamente. Depois disso, a lista de indivíduos será exibida diretamente sempre que você clicar em uma nova letra inicial na lista Alfabética.<br /><br />Para reverter esta ação, clique no link #pgv_lang[show_surnames]#.";
$pgv_lang["show_marnms_help"]					= "~#pgv_lang[show_marnms]#~<br /><br />As listas de pessoas e famílias podem incluir ou excluir nomes de casados. Esta opção pode ser útil ao pesquisar pessoas ou famílias em que você só conhece o nome de casado. Nomes de casados só podem ser incluídos se já existirem no banco de dados.<br /><br />Na lista de famílias, esse valor padroniza para excluir. Na lista de pessoas, o valor padrão é definido na página de configuração GEDCOM.<br /><br />Ao alterar esta opção, sua escolha será lembrada até que você faça logoff ou a sessão seja encerrada.";

//-- Families-page
$pgv_lang["help_famlist.php"]					= "~lista de familias~<br /><br />Nesta página você pode exibir uma lista de famílias. Os nomes serão exibidos primeiro com os sobrenomes e classificados em ordem alfabética.<br /><br />A saída da lista de nomes depende de:<ul><li>A letra em que você clicou no índice alfabético.</li><li>Se você clicou em \"Ignorar\" ou \"Mostrar\" a Lista de Sobrenome.</li></ul>Você pode pesquisar pelo sobrenome do marido ou da esposa; ambos estão incluídos na lista.<br /><br />#pgv_lang[context_help]#";
$pgv_lang["help_family.php"]					= "~DETALHES DA FAMÍLIA~<br /><br />Esta página irá mostrar uma visão geral da família que você escolheu na página anterior.<br /><br />De cima para baixo, você verá as caixas de detalhes pessoais do marido e seus pais, da esposa e dos pais dela e dos filhos.<br /><br />O conteúdo das caixas de pessoa é o mesmo das caixas que você já conhece nas páginas de Linhagem e Descendência.<br /><br />À direita das caixas dos pais, você verá uma seta se houver mais ancestrais no banco de dados. Ao clicar nessa seta, você avançará uma geração para mostrar uma nova página de família com os pais anteriores agora listados como marido e mulher.<br /><br />No lado direito da caixa de nome, você pode ver um ícone de zoom (lupa), no qual você pode clicar para revelar mais detalhes sobre a pessoa. Ao clicar no nome, você será direcionado para a página #pgv_lang[indi_info]# dessa pessoa.<br /><br />Também no lado direito você encontrará um pequeno menu para levá-lo a páginas com gráficos ou mais informações. Alguns desses itens de menu também possuem submenus que aparecerão quando o ponteiro do mouse se aproximar do item de menu pai.<br /><br />A caixa Informações sobre o grupo familiar mostra todos os fatos e informações conhecidos sobre esta família, como casamento, objetos multimídia e notas. Na caixa Informações do Fato, clicar em um local o levará para a lista de Locais, onde todas as outras famílias e indivíduos que estão conectados a esse local são mostrados. Clicar em uma data irá saltar para o calendário Dia, que mostrará todos os eventos que aconteceram naquele dia e mês no histórico. Objetos multimídia podem ser clicados; isso abrirá uma nova janela na qual o objeto é visualizado. Ao clicar na legenda da imagem, você verá a imagem na página #pgv_lang[media_list]#. Se você clicar em um link de Fonte, os detalhes dessa fonte serão exibidos na página Fonte.<br /><br />Abaixo das caixas de nomes das crianças, você encontra o link <b>Adicionar uma criança a esta família</b>. Ao lado das caixas de nomes das crianças, você vê o link <b>Informações do grupo familiar</b>. Se você tiver direitos suficientes, poderá editar, excluir e adicionar dados e fatos aqui.<br /><br />Tal como acontece com a página #pgv_lang[indi_info]#, você verá um menu no canto superior direito da página. As entradas neste menu levam você a outras páginas onde você pode obter informações sobre esta família ou realizar outras tarefas relacionadas a ela.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["add_child_help"]						= "~ADICIONE UMA CRIANÇA A ESTA FAMÍLIA~<br /><br />Você pode adicionar uma criança a esta família clicando neste link.<br /><br />Adicionar uma criança é simples: basta clicar no link, preencher as caixas na tela pop-up e pronto.";
$pgv_lang["show_fam_gedcom_help"]				= "~#pgv_lang[view_gedcom]#~<br /><br />As informações sobre a família, da forma como estão armazenadas no banco de dados, serão exibidas ao clicar neste link. O display mostrará dados GEDCOM brutos.";
$pgv_lang["add_fam_clip_help"]					= "~ADICIONE FAMÍLIA AO #pgv_lang[clip_cart]#~<br /><br />Você pode adicionar todas ou algumas das informações desta família ao seu #pgv_lang[clip_cart]#. Na próxima página, você pode escolher exatamente quantas informações deseja adicionar:<ul><li>#pgv_lang[just_family]#</li><li>#pgv_lang[parents_and_family]#</li><li>#pgv_lang[parents_and_child]#</li><li>#pgv_lang[parents_desc]#</li></ul>";
$pgv_lang["show_fam_timeline_help"]				= "~MOSTRAR CASAL NA TABELA DO TEMPO~<br /><br />Ao clicar neste link, você saltará para a página Linha do tempo, onde todos os fatos do casal serão exibidos em uma escala de linha do tempo.";

//-- Source list-page
$pgv_lang["help_sourcelist.php"]				= "~LISTA DE FONTES~<br /><br />Uma lista de fontes é exibida nesta página.<br /><br />Ao contrário das páginas #pgv_lang[indi_info]# e Família, não há índice alfabético.<br /><br />Uma fonte pode ser uma pessoa, um banco de dados público, uma instituição, um recurso da Internet, etc. Devido à natureza completamente aleatória das fontes genealógicas, é impossível encontrar uma ordem de classificação que seja significativa em todos os casos. No entanto, PhpGedView classifica os nomes das fontes em ordem alfabética.<br /><br /><b>FONTES</b><br />Sem fontes, não podemos construir nosso banco de dados. Existe uma fonte para cada item de informação no banco de dados. A fonte pode ser um parente, uma instituição, um banco de dados público, registros governamentais ou privados, um recurso da Internet, etc.<br /><br />Uma fonte pode estar vinculada a várias pessoas. Uma pessoa também pode estar vinculada a várias fontes. Você pode ter diferentes fontes para cada evento, seja data de nascimento, profissão, casamento, filhos, etc.";
$pgv_lang["sourcelist_listbox_help"]			= "~LISTA DE FONTES~<br /><br />Nesta caixa você verá os nomes das fontes como estão armazenadas no GEDCOM.<br /><br />Os nomes são exibidos em ordem alfabética. Ao clicar em um nome na lista, você irá para a página Fonte, onde uma lista é exibida. Esta lista mostra quais pessoas ou famílias estão vinculadas a essa fonte.";

//-- Sources-page
$pgv_lang["help_source.php"]					= "~DETALHES DA FONTE~<br /><br />Os detalhes da fonte são exibidos nesta página. As fontes são muito importantes para os pesquisadores genealógicos e permitirão que você siga a trilha que outro pesquisador usou para encontrar as informações.<br /><br />Você pode ver informações sobre o título da fonte, autor, publicação e o repositório onde a fonte foi consultada. Devido aos muitos tipos diferentes de fontes, algumas fontes podem ter mais informações do que outras.<br /><br />Se um objeto de multimídia, como a digitalização de um documento, estiver conectado à fonte, você poderá visualizar esse objeto clicando no objeto. Ao clicar no nome do objeto, você o verá na página #pgv_lang[media_list]#.<br /><br />Seguindo os detalhes da fonte, há uma lista de todas as pessoas e famílias que estão conectadas a esta fonte. Isso permite que você identifique todos os itens obtidos dessa fonte de dados.<br /><br />Quando o administrador habilitar esses recursos, você terá um ou dois ícones de menu adicionais nesta página:<ul><li><b>#pgv_lang[view_gedcom]#</b><br />que mostra as informações no formato GEDCOM.</li><li><b>#pgv_lang[add_to_cart]#</b><br />que permite que você armazene essas informações em seu #pgv_lang[clip_cart]# para download posterior e importação para seu próprio programa de genealogia.</li></ul><br />#pgv_lang[context_help]#";
$pgv_lang["sources_listbox_help"]				= "~REGISTOS LIGADOS A ESTA FONTE~<br /><br />Nesta caixa, você vê os nomes de pessoas e famílias que estão conectadas à fonte.<br /><br />Os nomes são exibidos em ordem alfabética. Ao clicar em um nome na lista, você irá para a página de detalhes relevante.";
$pgv_lang["show_source_gedcom_help"]			= "~#pgv_lang[view_gedcom]#~<br /><br />Ao clicar neste link, os registros da fonte serão exibidos no formato de banco de dados bruto.";
$pgv_lang["add_source_clip_help"]				= "~#pgv_lang[add_to_cart]#~<br /><br />Ao clicar neste link, você pode adicionar as informações da fonte ao seu #pgv_lang[clip_cart]# para download posterior e importação para o seu próprio programa de genealogia.";
$pgv_lang["delete_source_help"]					= "~#pgv_lang[delete_source]#~<br /><br />Ao clicar nesta opção, você marcará esta fonte para ser excluída do banco de dados.<br /><br />O que isso significa? Vamos supor que você tenha um bom motivo para remover essa fonte do banco de dados. Você clica no link. Você será solicitado a confirmar sua solicitação de exclusão. Ao continuar com sua visita, você notará que a fonte ainda está visível e pode ser usada como se a exclusão não tivesse ocorrido.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["no_mistake"]							= "<b>Isso <u>não</u> é um erro.</b>  O administrador receberá uma mensagem informando que uma alteração foi feita no banco de dados e que você deletou algo. O administrador pode aceitar ou rejeitar sua alteração. Somente depois que o administrador aceitar sua alteração, a exclusão realmente se tornará permanente. Se houver alguma dúvida sobre a sua alteração, o administrador entrará em contato com você.";

//-- Persons per Place-page
$pgv_lang["help_placelist.php"]					= "~HIERARQUIA DE LUGARES~ (ou pessoas por lugar)<br /><br />Esta página irá mostrar uma hierarquia dos lugares no GEDCOM e quais pessoas ou famílias estão conectadas a um local.<br /><br />Se houver alguma conexão entre uma pessoa ou família e um evento em um determinado local, O PhpGedView irá encontrá-lo.<br /><br />Os resultados são exibidos em uma lista de duas colunas, uma coluna para pessoas e outra para famílias.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["ppp_default_form_help"]				= "~FORMATO DE LUGARES~<br /><br /><b>ORDEM PADRÃO</b><br />Isso significa que não há formato de codificação de local declarado neste arquivo GEDCOM e o formato padrão é assumido.<br /><br />Se outro formato tivesse sido encontrado, ele teria sido mostrado entre <b>(</b> e <b>)</b> no final da linha.";
$pgv_lang["ppp_match_one_help"]					= "~FORMATO DE LUGARES~<br /><br /><b>ORDEM GEDCOM</b><br />As localizações são consideradas codificadas no formato de local explicitamente declarado no arquivo GEDCOM. Isso anula a ordem padrão.";
$pgv_lang["ppp_numfound_help"]					= "~CONEXÕES DE LOCAIS ENCONTRADAS~<br /><br />O número de correspondências encontradas é exibido aqui. Se você ainda vir uma caixa de listagem com locais que você ainda não atingiu o nível mais baixo.<br /><br />Você pode escolher ver todos os registros conectados a este lugar ou pode refinar sua pesquisa clicando em outro local.";
$pgv_lang["ppp_levels_help"]					= "~NÍVEIS DE LOCALIZAÇÃO~<br /><br />Isso mostra os níveis que são exibidos agora. A caixa de lista que mostra os locais é na verdade uma sublista do nível mais à esquerda.<br /><br />EXEMPLO:<ul><li>A ordem padrão é #pgv_lang[default_form]#.</li><li>Se o nível atual for \"Nível superior\", a caixa listará todos os países no banco de dados.</li><li>Se o nível atual for \"USA, Top Level\", a caixa listará todos os estados nos EUA</li><li>etc.</li></ul><br />Você pode clicar em um nível para voltar uma ou mais etapas.";
$pgv_lang["ppp_placelist_help"]					= "~HIERARQUIA DE LUGARES~<br /><br />Nesta lista, você pode ver os locais encontrados subordinados ao local atual que você escolheu. Se você ainda não selecionou um lugar, verá uma lista de todos os locais de nível superior (por exemplo, países ou estados).<br /><br />Os nomes dos locais na lista são clicáveis; clicar em um local funciona como um filtro, você será levado ao próximo nível abaixo.";
$pgv_lang["ppp_placelist_help2"]				= "~LISTA DE LUGARES~<br /><br />Nesta lista você pode ver os locais que foram encontrados até este estágio.<br /><br />Os nomes dos locais na lista são clicáveis; clicar em um local funciona como um filtro, você será levado para o próximo nível abaixo.<br /><br />Somente quando você estiver no nível superior a lista de nomes não será exibida. Em todos os níveis subordinados, você obterá uma lista de famílias e pessoas conectadas a esse local.";
$pgv_lang["ppp_view_records_help"]				= "~#pgv_lang[view_records_in_place]#~<br /><br />Ao clicar neste link, você verá uma lista de todas as pessoas e famílias que têm eventos ocorrendo neste local. Quando você chegar ao final da hierarquia de um local, que normalmente é uma cidade ou vila, a lista de nomes será exibida automaticamente.";
$pgv_lang["ppp_name_list_help"]					= "~LISTA DE NOMES~<br /><br />Esta caixa exibirá uma lista completa de pessoas e famílias que estão conectadas àquele local.<br /><br /> Os nomes na lista são clicáveis. Ao clicar em um nome, você será levado à página de detalhes relevante. Ao clicar em um local no topo da lista, você altera sua seleção de Local.";

//-- Multimedia-page
$pgv_lang["help_medialist.php"]					= "~LISTA DE OBJETOS MULTIMÍDIA~<br /><br />Esta página lista todos os Objetos Multimídia que podem ser encontrados neste banco de dados.<br /><br />Para cada um dos itens de mídia, você vê o título ou nome do arquivo do item, nomes das pessoas ou famílias conectadas ao item. e notas sobre o item.<br /><br />Clicar no título ou no nome do arquivo do item tem o mesmo efeito que clicar em sua miniatura. O item será aberto no visualizador de imagens embutido no PhpGedView ou no visualizador especificado na configuração do seu navegador.<br /><br />Ao clicar no link \"Visualizar\" ao lado da pessoa ou família, você irá ser levado para a página de detalhes relevante.";

//-- Upload Media-page
$pgv_lang["help_uploadmedia.php"]				= "~CARREGAR ARQUIVOS DE MÍDIA~<br /><br />O upload de arquivos de mídia é bastante simples. Aqui estão algumas informações adicionais.<br /><br /><b>Miniaturas</b><br />As miniaturas devem ter um tamanho em torno de 100px de largura. A miniatura <u>deve</u> ser nomeada de forma idêntica à versão em tamanho real. Se o seu sistema pode gerar miniaturas automaticamente, você verá um aviso para esse efeito na página Carregar mídia.<br /><br /><b>Enviando</b><br />Os arquivos serão carregados automaticamente para o diretório <b>#GLOBALS[MEDIA_DIRECTORY]#</b> para a versão em tamanho real e para <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> para as miniaturas.<br /><br />#pgv_lang[readme_help]#";

//-- Anniversaries-page
$pgv_lang["help_calendar.php"]					= "~#pgv_lang[anniversary_calendar]#~<br /><br /><ul><li><a href=\"#calendar_general\"><b>Informação geral</b></a></li><li><a href=\"#calendar_day\"><b>#pgv_lang[day]#</b></a></li><li><a href=\"#calendar_month\"><b>#pgv_lang[month]#</b></a></li><li><a href=\"#calendar_year\"><b>#pgv_lang[year]#</b></a></li><li><a href=\"#calendar_show\"><b>#pgv_lang[show]# / #pgv_lang[showcal]#</b></a></li><li><a href=\"#calendar_sex\"><b>#pgv_lang[sex]#</b></a></li><li><a href=\"#calendar_event\"><b>Evento</b></a></li><li><a href=\"#calendar_button\"><b>Botões Ver Dia / Ver Mês / Ver Ano</b></a></li><li><a href=\"#calendar_tip\"><b>Adendo</b></a></li></ul><br /><a name=\"calendar_general\"></a>O #pgv_lang[anniversary_calendar]# mostra as pessoas e famílias que estão vinculadas a um evento em um determinado dia ou mês ou durante um determinado período de tempo. Possui um sistema de filtragem avançado para selecionar a data, período e eventos certos para você.<dl><dt><b>Veja o <a href=\"#calendar_day\">dia</a></b></dt><dd>Mostra os eventos de um determinado dia, independente do ano selecionado. A saída será uma única lista com os nomes de pessoas ou famílias, ou uma lista de duas colunas com pessoas de um lado e famílias do outro.</dd><dt><b>Veja o <a href=\"#calendar_month\">mês</a></b></dt><dd>Neste calendário, os nomes das pessoas e famílias são exibidos nas caixas Diárias. O calendário é mostrado como estava no ano que você inseriu na caixa Ano. Todos os eventos que aconteceram no passado até aquele ano são mostrados.<br /><br />Em combinação com a opção <a href=\"#calendar_show\"><b>#pgv_lang[recent_events]#</b></a>, dará uma visão realista de como era o calendário de seus ancestrais.</dd><dt><b>Ver <a href=\"#calendar_year\">ano</a></b></dt><dd>Mostra os eventos em um determinado ano ou durante vários anos. A saída será uma lista com os nomes de pessoas ou famílias, ou uma lista de duas colunas com pessoas de um lado e famílias do outro.</dd></dl>O dia e o mês exibidos atualmente são destacados no menu do calendário.<br /><br />Todos os nomes e datas são clicáveis. Ao clicar em um nome, você será levado à página de detalhes relevante. Clicar em uma data irá pular para o modo \"Hoje\" ou \"Ano\", que exibirá todos os eventos do dia e mês na data clicada.<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_day\"></a> #pgv_lang[annivers_date_select_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_month\"></a> #pgv_lang[annivers_month_select_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_year\"></a> #pgv_lang[annivers_year_select_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_show\"></a> #pgv_lang[annivers_show_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_sex\"></a> #pgv_lang[annivers_sex_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_event\"></a> #pgv_lang[annivers_event_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_button\"></a> #pgv_lang[day_month_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_tip\"></a> #pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"]			= "~SELETOR DE DIA~<br /><br />A linha superior da tabela Seletor é o seletor <b>Dia</b>. Seu significado é óbvio: você seleciona um <u>dia</u>.<br /><br />O resultado de clicar em um dia depende se você está no modo <b>Dia</b> ou <b>Mês</b>.<br /><dl><dt><b>Modo Dia</b></dt><dd>Neste modo, você clica em um dia, a tela é atualizada e a lista desse dia é exibida.</dd><dt><b>Modo Mês</b></dt><dd>Você tem o calendário do mês na tela. Você clica em um dia e a tela é atualizada, mas você ainda verá o mês anterior na tela. A razão para isso é que você ainda pode decidir selecionar outro mês, ano ou evento antes de clicar no botão <b>#pgv_lang[viewday]#</b> ou <b>#pgv_lang[viewmonth]#</b>.</dd></dl><br />No final da linha do dia, você verá um <b>Link rápido</b> com a data de hoje. Clicar nesse <b>Link rápido</b> exibirá a lista de hoje no modo <b>Dia</b>, não importa se você está no modo <b>Mês</b> ou <b>Dia</b>.";
$pgv_lang["annivers_month_select_help"]			= "~SELETOR DE MÊS~<br /><br />A linha do meio da tabela Seletor é o seletor <b>Mês</b>. Seu significado é óbvio: você seleciona um <u>mês</u>.<br /><br />O resultado de clicar no mês depende se você está no modo <b>Dia</b> ou no modo <b>Mês</b>.<br /><dl><dt><b>Modo Dia</b></dt><dd>Neste modo, você clica em um mês, a tela será atualizada e a lista desse mês será exibida. Todas as outras seleções, como dia, ano e eventos, não serão alteradas.</dd><dt><b>Modo Mês</b></dt><dd>Quando você tiver o calendário na tela e clicar em um mês na linha <b>Mês</b>, o calendário para esse novo mês será exibido.</dd></dl><br />No final da linha Mês, você verá um <b>Link rápido</b> com o mês e o ano de hoje. Clicar nesse <b>Link rápido</b> exibirá a lista desse mês no modo <b>Mês</b>, não importa se você está no modo <b>Mês</b> ou <b>Dia</b>.";
$pgv_lang["annivers_year_select_help"]			= "~CAIXA DE ENTRADA DE ANO~<br /><br />Esta caixa de entrada permite alterar esse ano do calendário. Digite um ano na caixa e pressione <b>Enter</b> para alterar o calendário para esse ano.<br /><br /><b>Recursos avançados</b> para <b>#pgv_lang[viewyear]#</b><dl><dt><b>Mais de um ano</b></dt><dd>Você pode pesquisar datas em um intervalo de anos.<br /><br />Os intervalos de anos são <u>inclusivos</u>. Isto significa que o intervalo de datas estende-se desde 1 de janeiro do primeiro ano do intervalo até 31 de dezembro do último ano mencionado. Aqui estão alguns exemplos de intervalos de anos:<br /><br /><b>1992-5</b>&nbsp;&nbsp;&nbsp;para todos os eventos de 1992 a 1995.<br /><b>1972-89</b>&nbsp;&nbsp;&nbsp;para todos os eventos de 1972 a 1989.<br /><b>1610-759</b>&nbsp;&nbsp;&nbsp;para todos os eventos de 1610 a 1759.<br /><b>1880-1905</b>&nbsp;&nbsp;&nbsp;para todos os eventos de 1880 a 1905.<br /><b>880-1105</b>&nbsp;&nbsp;&nbsp;para todos os eventos de 880 a 1105.<br /><br />Para ver todos os eventos em uma determinada década ou século, você pode usar <b>?</b> no lugar dos dígitos finais. Por exemplo, <b>197?</b>&nbsp;&nbsp;&nbsp;para todos os eventos de 1970 a 1979 ou <b>16??</b>&nbsp;&nbsp;&nbsp;para todos os eventos de 1600 a 1699.<br /><br />Selecionar um intervalo de anos mudará o calendário para a visualização do ano.</dd></dl>";
$pgv_lang["annivers_show_help"]					= "~MOSTRAR EVENTOS DE...~<br /><br />As seguintes opções estão disponíveis:<br /><ul><li><b>Todas as pessoas</b><br />Com esta opção, todas as pessoas e famílias são exibidas.</li><li><b>Anos recentes (&lt; 100 anos)</b><br />Com esta opção, você verá todos os eventos do dia ou mês escolhido, mas nenhum evento com mais de 100 anos será mostrado.</li><li><b>Pessoas vivas</b><br />A menos que o administrador tenha configurado o PhpGedView para que as pessoas vivas fiquem visíveis para qualquer pessoa, esta opção só estará disponível para você depois de fazer o login.<br /><br />Com esta opção, apenas os eventos de pessoas vivas serão exibidos.</li></ul>Ao clicar em uma opção, os eventos de sua escolha serão exibidos.<br /><br />As configurações de dia, mês e ano, bem como o modo <b>Dia</b> ou <b>Mês</b>, permanecem como estavam.";
$pgv_lang["annivers_sex_help"]					= "~SELETOR DE GÊNERO~<br /><br />Quando você está logado ou quando o administrador não habilitou a opção Privacidade, você pode selecionar uma destas opções:<ul><li>Ícone <b>Tudo</b><br />Esta é a opção padrão. Os eventos de todas as pessoas e famílias são exibidos.</li><li>Ícone <b>Masculino</b><br />Apenas eventos de pessoas do sexo masculino são exibidos. Apenas membros masculinos de famílias serão exibidos com eventos familiares.</li><li>Ícone <b>Feminino</b><br />Apenas eventos de mulheres são exibidos. Somente membros femininos de famílias serão exibidos com eventos familiares.</li></ul>Ao clicar em uma opção, os eventos de sua escolha serão exibidos.<br /><br />As configurações de dia, mês e ano, bem como o modo <b>Dia</b> ou <b>Mês</b>, permanecem como estavam.";
$pgv_lang["annivers_event_help"]				= "~SELETOR DE EVENTOS~<br /><br />Aqui você escolhe se deseja que todos os eventos para pessoas e famílias sejam exibidos ou apenas um evento selecionado. Você não pode selecionar mais de uma categoria de evento.<br /><br />Ao clicar em uma opção, os eventos de sua escolha serão exibidos.<br /><br />As configurações de dia, mês e ano, bem como o modo <b>Dia</b> ou <b>Mês</b>, permanecem como estavam.";
$pgv_lang["annivers_tip_help"]					= "~DICA~<br /><br />Ajuste o seletor de data para qualquer data no passado.<br /><br />Ao clicar em um dos botões Exibir, você verá uma lista ou calendário para essa data. Todas as idades, aniversários, etc. foram recalculados e agora contam a partir da data que você definiu no seletor de Data. Agora você está vendo o calendário ou lista que seu ancestral teria visto naquela data, anos atrás.";
$pgv_lang["day_month_help"]						= "~BOTÕES VER DIA / VER MÊS / VER ANO~<br /><br /><ul><li>O botão <b>Ver dia</b> exibirá os eventos da data escolhida em uma lista. Todos os anos são digitalizados, portanto, apenas o dia e o mês podem ser definidos aqui. Mudar o ano não terá efeito. Você pode reduzir a lista escolhendo a opção <b>Anos recentes</b> ou <b>Pessoas vivas</b>.<br /><br />As idades na lista serão calculadas a partir do ano atual.</li><li>O botão <b>Ver mês</b> exibirá um diagrama de calendário do mês e ano escolhidos. Também aqui você pode reduzir as listas escolhendo a opção <b>Anos recentes</b> ou <b>Pessoas vivas</b>.<br /><br />Você terá uma impressão realista de como era um calendário na parede de seus ancestrais ao escolher um ano no passado em combinação com <b>Anos recentes</b>. Todas as idades no calendário são mostradas em relação ao ano na caixa Ano.</li><li>O botão <b>Ver ano</b> mostrará uma lista de eventos do ano escolhido. Aqui também você pode reduzir a lista escolhendo a opção <b>Anos recentes</b> ou <b>Pessoas vivas</b>.<br /><br />Você pode mostrar eventos por um intervalo de anos. Basta digitar os anos inicial e final do intervalo, com um travessão <b>-</b> entre eles. Exemplos:<br /><b>1992-4</b> para todos os eventos de 1992 a 1994<br /><b>1976-1984</b> para todos os eventos de 1976 a 1984<br /><br />Para ver todos os eventos em uma determinada década ou século, você pode usar <b>?</b> no lugar dos dígitos finais. Por exemplo, <b>197?</b> para todos os eventos de 1970 a 1979 ou <b>16??</b> para todos os eventos de 1600 a 1699.</li></ul>Quando você quiser <b>mude o ano</b> que você <b>tem</b> para pressionar um desses três botões. Todas as outras configurações permanecem como estavam.";

//-- Clippings Cart-page
$pgv_lang["help_clippings.php"]					= "~#pgv_lang[clippings_cart]#~<br /><br />O #pgv_lang[clip_cart]# permite que voce recorte dados e consolide tudo em um unico arquivo para \"download\". O arquivo de recortes é salvo no formato GEDCOM e pode ser importado por qualquer programa de Genealogia.<br /><ul><li>Como fazer recortes?<br />Em qualquer lugar onde houver um nome \"clicável\" (pessoa, família ou fonte) acesse a página de Detalhes do nome. Nesta página você encontrará a opção <b>#pgv_lang[add_to_cart]# em Outros</b>. Ao clicar esta opção, você verá várias opções para download.</li><li>Como fazer o download?<br />Tão logo você tenha todos os recortes no carrinho, clique o link <b>Fazer Download agora</b> link e siga as instruções</li></ul>";
$pgv_lang["clip_download_help"]					= "~#pgv_lang[download_now]#~<br /><br />Ao clicar neste link, você será levado para a próxima página. Se qualquer um dos cortes de árvore em seu carrinho se referir a itens multimídia, esses itens também serão exibidos nessa página.<br /><br />Basta seguir as instruções.";
$pgv_lang["empty_cart_help"]					= "~#pgv_lang[empty_cart]#~<br /><br />Ao clicar neste link, seu #pgv_lang[clip_cart]# será totalmente esvaziado.<br /><br />Se não quiser remover todas as pessoas, famílias, etc. do #pgv_lang[clip_cart]#, você pode remover os itens individualmente clicando em <b>Remova</b> nas caixas Nome. Não há <u>nenhuma</u> caixa de diálogo de confirmação quando você clica em qualquer um desses links; a exclusão solicitada ocorre imediatamente.";
$pgv_lang["add_by_id_help"]						= "~CARRINHO DE RECORTES: ADICIONE POR ID~<br /><br />Esta caixa de entrada permite inserir o número de identificação de uma pessoa para que ela possa ser adicionada ao Carrinho de Recortes. Depois de adicionado, você terá opções para vincular as relações dessa pessoa ao seu carrinho de recortes.<br /><br />Se você não souber o número de identificação da pessoa, poderá realizar uma pesquisa por nome pressionando o ícone de pessoa ao lado de o botão Adicionar.";
$pgv_lang["zip_help"]							= "~ZIP RECORTES~<br /><br />Selecione esta opção para salvar seus recortes em um arquivo ZIP. Para obter mais informações sobre arquivos ZIP, visite <a href=\"https://pt.wikipedia.org/wiki/ZIP\" target=\"_blank\">https://pt.wikipedia.org/wiki/ZIP</a>.";
$pgv_lang["include_media_help"]					= "~INCLUIR MÍDIA~<br /><br />Selecione esta opção para incluir os arquivos de mídia associados aos registros em seu carrinho de recortes. A escolha dessa opção compactará automaticamente os arquivos durante o download.";
$pgv_lang["clip_cart_help"]						= "~#pgv_lang[clippings_cart]#~<br /><br />Esta caixa mostra o conteúdo do seu carrinho de recortes.<ul><li>A coluna <i>Tipos</i> indica o tipo de cada entrada, que pode ser Pessoa (INDI), Família (FAM), Fonte (SOUR), Repositório (REPO), Nota (NOTE) e Mídia (OBJE) ; cada um é representado por seu próprio ícone.</li><li>A coluna <i>ID</i> mostra o número de ID de cada item daquele tipo específico.</li><li>A coluna <i>Nome / Descrição</i> fornece o nome da família ou pessoa ou uma descrição do item.</li></ul>O botão <b>Remover</b> removerá esse registro do Carrinho de Recortes. <b>A confirmação para remover NÃO é solicitada.</b>";

//-- GEDCOM Edit Utility
$pgv_lang["show_changes_help"]					= "~#pgv_lang[review_changes]#~<br /><br />Quando você vê esta mensagem, isso significa duas coisas:<ol><li>Alguém fez alterações no GEDCOM<br />Os registros podem ter sido adicionados, excluídos ou alterados.</li><li>As alterações ainda não foram aceitas pelo administrador.<br />Assim que as alterações forem aceitas ou rejeitadas, você não verá mais esta mensagem.</li></ol>Você pode ver quais alterações foram feitas ao clicar no link. Se você perceber que uma alteração não está correta, notifique o administrador.";

//-- Search-page
$pgv_lang["help_search.php"]					= "~PÁGINA DE PESQUISA~<br /><br />Embora esta página pareça muito simples, há um mecanismo de pesquisa muito poderoso e complicado por trás dos dois formulários. A maioria dos sites de genealogia permite apenas que você pesquise um nome. PhpGedView permite que você pesquise quase tudo.<br /><br />A caixa Pesquisar à esquerda da tela é igual à caixa Pesquisar no cabeçalho de cada página.<br /><br />Se você estiver procurando por pessoas relacionadas a um determinado ano, basta digitar o ano. O programa encontrará todas as conexões para você.<br /><br />Procurando um nome ou lugar?  Basta digitar o nome ou local, completamente ou apenas parte dele, e o PhpGedView faz o resto.<br /><br /><b>Método de pesquisa Soundex</b><br />Com as caixas de pesquisa à direita, você pode pesquisar nomes de pessoas e lugares, mesmo que não saiba exatamente como escrever o nome.<br /><br />Quando há vários bancos de dados genealógicos em um site e o administrador habilitou a alternância entre eles, sua pesquisa retornará os resultados de todos eles.<br /><br />Você encontrará mais ajuda sobre essas duas caixas clicando em <b>?</b> acima das caixas.";
$pgv_lang["search_enter_terms_help"]			= "~#pgv_lang[enter_terms]#~<br /><br />Nesta caixa de pesquisa você pode inserir critérios como datas, nomes, sobrenomes, lugares, multimídia, etc.<br /><br /><b>Curingas</b><br />Os curingas, como você provavelmente os conhece (como * ou ?), não são permitidos, mas o programa assumirá automaticamente os curingas.<br /><br />Suponha que você digite o seguinte na caixa Pesquisar: <b>Pete</b>. O resultado pode ser, supondo que os nomes estejam no banco de dados:<div style=\"padding-left: 30px;\"><b>Pete</b> Smith<br /><b>Pete</b>r Johnes<br />Will <b>Pete</b>rson<br />alguém - nascido em 01 de janeiro de 1901 <b>Pete</b>rsburg<br />etc.</div><br /><b>Datas</b><br />Digitar um ano na caixa de Pesquisa resultará em uma lista de pessoas que estão de alguma forma conectadas a esse ano.<br /><br />Se você digitar <b>1950</b>, o resultado será todas as pessoas com um evento que ocorreu em 1950. Esses eventos podem ser nascimentos, mortes, casamentos, Bar Mitzvahs, Selamentos SUD, etc.<br /><br />Se você digitar <b>4 DEC</b>, todas as pessoas conectadas a um evento que ocorreu em 4 de dezembro de qualquer ano serão listadas. Pessoas conectadas a um evento em 14 ou 24 de dezembro também serão listadas. Como você pode ver, os curingas são sempre assumidos, então você não precisa digitá-los. Às vezes, os resultados podem ser surpreendentes.<br /><br /><b>Datas adequadas</b><br />O PhpGedView busca os dados, já que estão armazenados no arquivo GEDCOM. Se, por exemplo, você deseja pesquisar um evento em 14 de dezembro, você deve digitar <b>14&nbsp;dec</b> porque é assim que a data é armazenada no banco de dados.<br /><br />Se você digitou <b>dec&nbsp;14</b>, o resultado pode ser uma pessoa conectada a um evento em 08&nbsp;<b>dezembro</b>&nbsp;18<b>14</b>. Novamente, os resultados podem ser surpreendentes.<br /><br />Você pode usar expressões regulares em sua pesquisa se estiver familiarizado com elas. Por exemplo, se você quiser encontrar todas as pessoas que têm datas no século 20, você pode inserir a pesquisa <b>19[0-9][0-9]</b> e obter todos os pessoas com datas de 1900-1999.<br /><br />#pgv_lang[soundex_search_help]#<br /><br />#pgv_lang[search_replace_help]#<br /><br />Se precisar de mais ajuda com isso sistema de pesquisa, avise-nos, para que possamos melhorar este arquivo de Ajuda também.";
$pgv_lang["search_replace_help"]				= "~#pgv_lang[search_replace]#~<br /><br />Aqui, você pode pesquisar um erro ortográfico ou outra informação incorreta e substituí-la pelas informações corretas.<br /><br /><b>Pesquisando</b><br />Este recurso executa a pesquisa como uma <a href=\"help_text.php?help=search_enter_terms_help\">pesquisa normal</a>.<br /><br /><b>Substituindo</b><br />Todas as ocorrências do termo de pesquisa encontradas são substituídas pelo termo de substituição no banco de dados.<br /><br /><b>Por exemplo...</b><br />Suponha que você acidentalmente soletrou seu grande- o nome do vovô Michael. Você inseriu acidentalmente 'Micheal'.<br /><br />Você digitaria <b>Micheal</b> na caixa de pesquisa e <b>Michael</b> na caixa Substituir.<br />Todos instância de \"Micheal\" seria então substituída por \"Michael\".<br /><br /><b>Procurar por...</b><br />Selecione o escopo da pesquisa. Você pode limitar a pesquisa a nomes ou lugares, ou não aplicar nenhum limite (pesquisar tudo). A opção <i>#pgv_lang[search_place_word]#</i> pesquisará apenas o seu termo no campo de lugar como uma palavra inteira. Isso significa que pesquisar por <i>UT</i> corresponderia apenas a <b>UT</b> e não a <i>UT</i> em outras palavras, como Connectic<b>ut</b>.<br /><br />Não se preocupe se você acidentalmente substituir algo onde não deseja. Basta clicar no link \"Aceitar / Rejeitar alterações\" na parte inferior da página para aceitar as alterações desejadas e rejeitar as que não deseja.";
$pgv_lang["soundex_search_help"]				= "~#pgv_lang[soundex_search]#~<br /><br />Soundex é um método de codificação de palavras de acordo com sua pronúncia. Isso permite que você pesquise nomes e lugares no banco de dados quando não sabe exatamente como foram escritos. PhpGedView suporta dois algoritmos Soundex diferentes que produzem resultados muito diferentes.<ul><li><b>#pgv_lang[search_russell]#</b><br />Este método, patenteado em 1918 por Russell, é muito simples e pode ser feito à mão.<br /><br />O algoritmo Simples não é adequado para nomes que estavam originalmente em idiomas diferentes do inglês, e mesmo com nomes em inglês os resultados são muito surpreendentes. Por exemplo, uma pesquisa Simple Soundex por <b>Smith</b> retornará não apenas <b>Smith, Smid, Smit, Schmidt, Smyth, Smithe, Smithee, Schmitt</b>, todos claramente variações de <b>Smith</b>, mas também <b>Smead, Sneed, Smoote, Sammett, Shand</b> e <b>Snoddy</b>.</li><br /><li><b>#pgv_lang[search_DM]#</b><br />Este método, desenvolvido em 1985, é muito mais complexo do que o método Simple e não é facilmente executado à mão.<br /><br />Uma pesquisa Soundex usando este método produz resultados muito mais precisos.</li></ul>Para obter detalhes sobre os dois algoritmos Soundex, visite a href=\"http://www.jewishgen.org/infofiles/soundex.html\" target=_blank><b>Jewish Genealogical Society</b></a>.";
$pgv_lang["search_exclude_tags_help"]			= "~#pgv_lang[search_tagfilter]#~<br /><br />A escolha <b>#pgv_lang[search_tagfon]#</b> fará com que a função de pesquisa ignore as seguintes tags GEDCOM:<div style=\"padding-left: 30px;\"><b>_PGVU</b> - Última alteração por<br /><b>CHAN</b> - Data da última alteração<br /><b>FILE</b> - #factarray[FILE]#<br /><b>FORM</b> - #factarray[FORM]#<br /><b>TYPE</b> - #factarray[TYPE]#<br /><b>SUBM</b> - #factarray[SUBM]#<br /><b>REFN</b> - #factarray[REFN]#</div><br />Além dessas tags opcionalmente excluídas, a função Pesquisar sempre exclui essas tags:<div style=\"padding-left: 30px;\"><b>_UID</b> - #factarray[_UID]#<br /><b>RESN</b> - #factarray[RESN]#</div>";
$pgv_lang["search_include_ASSO_help"]			= "~#pgv_lang[search_asso_label]#~<br /><br />Esta opção faz com que o PhpGedView mostre todas as pessoas que estão registradas como tendo uma relação de associação com a pessoa ou família que foi encontrada como resultado direto da pesquisa. O inverso não é possível.<br /><br />Exemplo: suponha que a pessoa <b>A</b> seja padrinho da pessoa <b>B</b>. Essa relação é registrada no registro GEDCOM da pessoa <b>B</b> por meio de uma etiqueta ASSO. Não existe nenhuma tag correspondente no registro GEDCOM da pessoa <b>A</b>.<br /><br />Quando esta opção é definida como <b>#pgv_lang[yes]#</b> e a lista de resultados da pesquisa inclui <b>B</b>, <b>A</b> será incluído automaticamente devido ao ASSO tag no registro GEDCOM de <b>B</b>. No entanto, se a lista de resultados da Pesquisa incluir <b>A</b>, <b>B</b> não será incluído automaticamente, pois não há tag ASSO correspondente no registro GEDCOM da pessoa <b>A</b>.";

//-- Advanced Search-page
$pgv_lang["advanced_search_help"] = "~#pgv_lang[advanced_search]#~<br /><br />Esta funcionalidade permite pesquisar os campos especificados de registos de pessoas na sua base de dados genealógica.<br /><br />Quando clica no botão <b>#pgv_lang[search]#</b>, todos os campos para os quais os valores foram introduzidos serão examinados e os registos na sua base de dados genealógica que cumpram <u>todos</u> os critérios serão devolvidos. Embora a caixa de diálogo inicial ofereça alguns dos campos mais comuns, na parte inferior da caixa de diálogo pode clicar em <b>#pgv_lang[more_fields]#</b> para expandir a lista de campos a examinar.<br /><br />~Campos contendo datas~<br />As pesquisas avançadas são baseadas em anos, pelo que, ao contrário do procedimento «#pgv_lang[search_general]#» que pode aceitar uma data sem ano, todos estes campos exigem pelo menos o ano, mas também podem aceitar especificações completas de dia, mês e ano . Por exemplo, não é possível pesquisar algo que aconteceu em abril de nenhum ano.<br /><br />Cada caixa de campo de data de pesquisa também tem um modificador, para que possa pesquisar a data <b>#pgv_lang[exact]#</b> tal como foi introduzida ou uma data relativa com <b>+/-</b> um número de anos. Introduzir um ano no campo de data, escolher um modificador e clicar no botão <b>#pgv_lang[search]#</b> resultará numa lista de pessoas que estão ligadas a esse ano ou intervalo de anos.<br /><br />Se, por exemplo, introduzir «APR 1950» no campo da data de nascimento que possui o modificador <b>#pgv_lang[exact]#</b>, o resultado será todas as pessoas com um evento que ocorreu apenas em abril de 1950. Cada campo de data pesquisará as datas específicas desse evento. A adição de um modificador <b>+/- 10</b> devolveria datas entre 1 de abril de 1940 e 31 de março de 1960. Os outros modificadores alterariam de forma semelhante os intervalos de anos de pesquisa. Ao introduzir apenas um ano, por exemplo, «1950», a pesquisa irá devolver todos os eventos do ano especificado.<br /><br /><b>Formato de data para pesquisas</b><br />Nem os caracteres coringa nem as expressões regulares podem ser utilizados nos campos de data de pesquisa. A ordem do dia, o mês, o ano e as maiúsculas são irrelevantes. «dd MMM aaaa» tem o mesmo significado que «aaaa MMM dd». No entanto, se desejar pesquisar um evento no dia 14 de dezembro de 1926, deverá digitá-lo como «14 DEC 1926» porque é assim que a data é guardada na base de dados. Para procurar uma data em vários eventos (ou seja, nascimentos, óbitos, casamentos, Bar Mitzvahs, Selamentos SUD, etc.) ou se apenas o dia ou mês for conhecido, é melhor utilizar a funcionalidade «#pgv_lang[search_general]#».<br /><br />~Campos contendo Nomes~<br />Os campos <b>#pgv_lang[given_name]#</b> e <b>#pgv_lang[surname]#</b> podem ser utilizados para especificar as diferentes partes de um nome a pesquisar. Isto filtra facilmente nomes que podem ser nomes próprios ou apelidos, por exemplo, «Terry» ou «Henry».<br /><br />Os campos de nomes também possuem um modificador que ajuda a qualificar o que é introduzido versus o que é pesquisado. Os modificadores incluem:<ul><li><b>#pgv_lang[exact]#</b>&nbsp;&nbsp;especifica uma pesquisa com distinção entre maiúsculas e minúsculas no campo completo para o texto exato introduzido. A pesquisa é também sensível a todos os caracteres incorporados, espaçamentos, etc.</li><li><b>#pgv_lang[begins_with]#</b>&nbsp;&nbsp;especifica uma pesquisa que não distingue maiúsculas de minúsculas de registos em que qualquer nome começa com o que está no campo. Se um campo de nome contiver vários nomes (como nomes e nomes do meio), a correspondência será feita com o início de cada parte do nome separada por um espaço.</li><li><b>#pgv_lang[contains]#</b>&nbsp;&nbsp;especifica uma pesquisa de registos que não distingue maiúsculas de minúsculas, onde os dados completos introduzidos no campo serão pesquisados em qualquer lugar dentro do texto do nome do registo de destino. Por exemplo, colocar um único espaço no campo de pesquisa <b>#pgv_lang[given_name]#</b> com o modificador <b>#pgv_lang[contains]#</b> irá encontrar todos os registos que devem ter um primeiro nome e pelo menos um nome do meio ou inicial.</li><li><b>#pgv_lang[sounds_like]#</b>&nbsp;&nbsp;especifica uma pesquisa sem distinção entre maiúsculas e minúsculas para registos semelhantes ao que está no campo. Isto permite-lhe pesquisar nomes e lugares na base de dados quando não sabe exatamente como estão escritos.</li></ul><br />~Campos sem modificadores~<br />As entradas em campos sem modificadores são pesquisas que não distinguem maiúsculas de minúsculas. O texto introduzido será pesquisado em qualquer lugar dentro do texto do evento do registo de destino.";

//-- Individual Information-page
$pgv_lang["help_individual.php"]				= "~#pgv_lang[indi_info]#~<br /><br />Todos os detalhes de uma pessoa são exibidos nesta página.<br /><br />Se houver uma foto disponível, você a verá no canto superior esquerdo. Você verá os nomes da pessoa ao lado da imagem.<br /><br />Os nomes podem ter notas e fontes anexadas a eles. Se algum dos nomes tiver notas ou fontes, você os verá listados sob os nomes aos quais se relacionam.<br /><br />Uma pessoa pode ter um AKA (talvez ele seja conhecido por outro nome). Se for esse o caso, ele será exibido.<br /><br />Se você tiver direitos de edição para essa pessoa, também verá os links <b>Editar</b> e <b>Excluir</b> ao lado dos itens que você pode editar.<br /><br />Nesta página, você vê as guias para <b>#pgv_lang[personal_facts]#</b>, <b>#pgv_lang[notes]#</b>, <b>#pgv_lang[ssourcess]#</b>, <b>#pgv_lang[media]#</b>, e <b>#pgv_lang[relatives]#</b>.Essas guias mostram todas as informações sobre esse indivíduo armazenadas no banco de dados.<ul><li><b>#pgv_lang[personal_facts]#</b>&nbsp;&nbsp;&nbsp;mostrará os fatos e detalhes sobre essa pessoa e qualquer fato de seu casamento. Clicar em qualquer data nesta guia o levará ao #pgv_lang[anniversary_calendar]# dessa data, para que você possa ver outros eventos que aconteceram no mesmo dia. Clicar em um lugar o levará para a hierarquia de lugares, onde você pode ver outras pessoas que tiveram eventos no mesmo lugar. Para casamento e outros fatos relacionados à família, o nome do cônjuge da pessoa está disponível para que você possa ver o cônjuge e um link para o registro familiar também é fornecido.</li><li><b>#pgv_lang[notes]#</b>&nbsp;&nbsp;&nbsp;mostrará todas as observações gerais relacionadas a essa pessoa.</li><li><b>#pgv_lang[ssourcess]#</b>&nbsp;&nbsp;&nbsp;mostrará todas as fontes <u>gerais</u> para essa pessoa. Essas fontes <u>não</u> estão vinculadas a fatos individuais, nem mesmo ao nome da pessoa; eles estão associados à própria pessoa. Clicar no título de uma fonte o levará a uma página de Informações da Fonte mais detalhada que exibirá outras pessoas que também estão vinculadas à mesma fonte.</li><li><b>#pgv_lang[media]#</b>&nbsp;&nbsp;&nbsp;listará todas as imagens e outros itens de mídia anexados a essa pessoa. Clicar em uma miniatura da imagem abrirá uma visão ampliada da imagem. Clicar na legenda da imagem mostrará a imagem na página #pgv_lang[media_list]#.</li><li><b>#pgv_lang[relatives]#</b>&nbsp;&nbsp;&nbsp;lista os pais e irmãos dessa pessoa, bem como todos os cônjuges e filhos que essa pessoa teve. Essas pessoas serão listadas em caixas semelhantes aos gráficos que você já deve ter visto.</li></ul>À direita da tela você encontrará uma caixa com links. Muitos dos links na caixa são iguais aos links nos menus. Por exemplo, clicar no link <b>#pgv_lang[pedigree_chart]#</b> nos links laterais levará você ao gráfico de linhagem dessa pessoa. Isso é diferente dos links de menu, porque clicar no link <b>#pgv_lang[pedigree_chart]#</b> no menu o levará de volta ao gráfico de linhagem padrão para este banco de dados.<br /><br />Um dos links que podem aparecer nesta lista se tiver sido habilitado pelo administrador, é o link <b>#pgv_lang[view_gedcom]#</b>. Este link mostrará o registro GEDCOM bruto dessa pessoa.<br /><br />Se o #pgv_lang[clip_cart]# foi habilitado pelo administrador do site, você também terá um link que permitirá que você adicione essa pessoa ao seu #pgv_lang[clip_cart]#.<br /><br />O link <b>#pgv_lang[relationship_to_me]#</b> só aparecerá se você estiver conectado e tiver uma ID atribuída no GEDCOM. Este link o levará ao gráfico de linhagem e mostrará como você se relaciona com essa pessoa.<br /><br />#pgv_lang[context_help]#";
$pgv_lang["delete_person_help"]					= "~#pgv_lang[delete_person]#~<br /><br />Ao clicar nesta opção, você marcará essa pessoa para ser excluída do banco de dados.<br /><br />O que isso significa? Vamos supor que você tenha um bom motivo para remover essa pessoa do banco de dados. Você clica no link. Você será solicitado a confirmar sua solicitação de exclusão. Ao continuar com sua visita, você perceberá que a pessoa ainda está visível e pode ser usado como se a exclusão não tivesse ocorrido.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["delete_name_help"]					= "~EDITAR ou EXCLUIR NOME DO GEDCOM~<br /><br /><b>EDITAR NOME</b><br />Ao clicar neste link, outra janela será aberta. Lá você pode editar o nome da pessoa. Basta digitar as alterações nas caixas e clicar no botão, fechar a janela e pronto.<br /><br /><b>EXCLUIR NOME</b><br />Ao clicar nesta opção, você marcará este nome para ser excluído do banco de dados. Observe que excluir o nome é completamente diferente de excluir a pessoa. Excluir o nome apenas remove o nome da pessoa. A pessoa <u>não</u> será excluída. Se for um AKA que você deseja excluir, a pessoa ainda terá seus outros nomes. Se for o <u>único</u> nome que você deseja remover, a pessoa ainda não será excluída, mas agora será registrada como <b>#pgv_lang[NN]#</b>. A pessoa também não será desconectada de nenhuma outra com parentes, fontes, notas, etc.<br /><br />Como funciona? Você será solicitado a confirmar sua solicitação de exclusão. Ao continuar com sua visita, você notará que o nome ainda está visível e pode ser usado como se a exclusão não tivesse ocorrido.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["add_name_help"]						= "~ADICIONE NOVO NOME~<br /><br />Este link permitirá que você adicione outro nome a essa pessoa. Às vezes, as pessoas são conhecidas por outros nomes ou apelidos. Este link permite adicionar novos nomes a uma pessoa sem alterar o nome antigo.";
$pgv_lang["add_sibling_help"]					= "~#pgv_lang[add_sibling]#~<br /><br />Você pode adicionar uma criança a esta família ao clicar neste link. \"Esta Família\", neste caso, é o pai e a mãe da pessoa principal desta tela.<br /><br />Lembre-se de que você irá adicionar um irmão dessa pessoa. Adicionar um irmão ou irmã é simples: basta clicar no link, preencher as caixas na tela pop-up e pronto.<br /><br />Se você tiver que adicionar um filho ou filha da pessoa principal, role para baixo um pouco e clique no link em \"#pgv_lang[as_spouse]#\".";
$pgv_lang["add_son_daughter_help"]				= "~#pgv_lang[add_son_daughter]#~<br /><br />Você pode adicionar uma criança a esta família ao clicar neste link. \"Esta Família\", neste caso, é a pessoa principal desta tela e seu cônjuge.<br /><br />Lembre-se que você vai adicionar um filho ou filha dessa pessoa. Adicionar um filho ou filha é simples: basta clicar no link, preencher as caixas na tela pop-up e pronto.<br /><br />Se você tiver que adicionar um irmão ou irmã da pessoa principal, role para cima a pouco e clique no link em \"#pgv_lang[as_child]#\".";
$pgv_lang["link_child_help"]					= "~#pgv_lang[link_as_child]#~<br /><br />Você pode vincular essa pessoa como uma criança a uma família existente ao clicar neste link.<br /><br />Suponha que em algum momento os pais da pessoa eram desconhecidos e você descobriu mais tarde que os pais têm um registro em esta base de dados.<br /><br />Basta clicar no link, inserir o ID da família e você terá concluído a tarefa. Se você não souber a identidade da família, pode procurá-la.";
$pgv_lang["link_husband_help"]					= "~#pgv_lang[link_as_husband]#~<br /><br />Este item permitirá que você vincule a pessoa atual como marido a uma família que já está no banco de dados. Ao clicar neste link, você pode adicionar essa pessoa a uma família existente, cujo marido era desconhecido até agora. Essa pessoa vai ocupar o lugar do marido até então desconhecido. Todos os eventos, informações de casamento e filhos manterão seus vínculos existentes com a família.<br /><br />Basta clicar no link, inserir o ID da família e você terá concluído a tarefa. Esta é uma opção de edição avançada que só deve ser usada se a família que você deseja vincular já existir. Se você quiser adicionar uma <u>nova</u> família a essa pessoa, use o link <b>#pgv_lang[add_new_wife]#</b>.";
$pgv_lang["add_husband_help"]					= "~#pgv_lang[add_new_husb]#~<br /><br />Ao clicar neste link, você pode adicionar uma <u>nova</u> pessoa do sexo masculino e vincular essa pessoa à pessoa principal como um novo marido.<br /><br />Basta clicar no link e você receberá um janela pop-up para adicionar a nova pessoa. Preencha o máximo de caixas que puder e clique no botão <b>Salvar</b>.<br /><br />Isso é tudo.";
$pgv_lang["link_new_husb_help"]					= "~#pgv_lang[link_new_husb]#~<br /><br />Isso permitirá que você vincule outra pessoa, que já existe, como um novo marido a essa pessoa. Isso criará uma nova família com o marido que você selecionar. Você também terá a opção de especificar um casamento para esta nova família.";
$pgv_lang["add_opf_child_help"]					= "~#pgv_lang[add_opf_child]#~<br /><br />Ao clicar neste link, você pode adicionar um <u>novo</u> filho a essa pessoa, criando uma família monoparental.<br /><br />Basta clicar no link e você verá uma janela pop-up para adicionar a nova pessoa. Preencha o máximo de caixas que puder e clique no botão <b>Salvar</b>.";
$pgv_lang["link_wife_help"]						= "~#pgv_lang[link_as_wife]#~<br /><br />Este item permitirá que você vincule o indivíduo atual como esposa a uma família que já está no banco de dados.<br /><br />Esta é uma opção de edição avançada que só deve ser usada se a família que você deseja vincular já existe. Se você quiser adicionar uma <u>nova</u> família a essa pessoa, use o link <b>#pgv_lang[add_new_husb]#</b>.";
$pgv_lang["add_wife_help"]						= "~#pgv_lang[add_new_wife]#~<br /><br />Ao clicar neste link, você pode adicionar uma <u>nova</u> mulher e vinculá-la à pessoa principal como uma nova esposa.<br /><br />Basta clicar no link e você receberá um janela pop-up para adicionar a nova pessoa. Preencha o máximo de caixas que puder e clique no botão <b>Salvar</b>.";
$pgv_lang["link_new_wife_help"]					= "~#pgv_lang[link_new_wife]#~<br /><br />Isso permitirá que você vincule outra pessoa, que já existe, como uma nova esposa a essa pessoa. Isso criará uma nova família com a esposa que você selecionar. Você também terá a opção de especificar um casamento para esta nova família.";
$pgv_lang["add_new_parent_help"]				= "#pgv_lang[multiple_help]#<br />~ADICIONE UM NOVO PAI ou MÃE~<br /><br />Certamente há muitas pessoas no GEDCOM sem registro de pai ou mãe.<br /><br />Nesse caso, na página <b>#pgv_lang[indi_info]#</b>, ficha de registro <b>#pgv_lang[relatives]#</b>, tabela <b>#pgv_lang[as_child]#</b>, você encontrará links para adicionar um <u>novo</u> pai ou mãe à pessoa.<br /><br />Lembre-se de que esses links são para adicionar um <u>novo</u> pai ou mãe. Se o pai ou a mãe já tem cadastro nesta base de dados, deve-se utilizar o link <b>#pgv_lang[link_as_child]#</b>, que se encontra naquela página <b>#pgv_lang[indi_info]#</b> abaixo da última tabela.";
$pgv_lang["show_fact_sources_help"]				= "~#pgv_lang[show_fact_sources]#~<br />~#pgv_lang[show_fact_notes]#~<br /><br />Quando esta opção está marcada, você pode ver todos os registros de Fonte ou Nota para esta pessoa. Quando esta opção está desmarcada, os registros de Fonte ou Nota que estão associados a outros fatos para esta pessoa não serão mostrados.";
$pgv_lang["age_differences_help"]				= "~#pgv_lang[age_differences]#~<br /><br />Quando esta caixa de opção está marcada, a guia «#pgv_lang[relatives]#» mostrará as diferenças de data da seguinte forma:<ul><li><b>datas de nascimento dos parceiros.</b><br />Um valor negativo indica que o segundo parceiro é mais velho que o primeiro.</li><li><b>data de casamento e data de nascimento do primeiro filho.</b><br />Um valor negativo aqui indica que a criança nasceu antes da data de casamento ou que a data de nascimento ou de casamento está errada.</li><li><b>datas de nascimento dos irmãos.</b><br />Um valor negativo aqui indica que a ordem dos filhos está errada ou que uma das datas de nascimento está errada.</li></ul>";

//-- Add Facts
$pgv_lang["add_facts_help"]						= "~ADICIONAR NOVOS FATOS~<br /><br />Aqui você pode adicionar um fato ao registro que está sendo editado.<br /><br />Primeiro, escolha um fato na lista suspensa e, a seguir, clique no botão <b>Adicionar</b>. Todos os fatos possíveis que você pode adicionar ao banco de dados estão nessa lista.";
$pgv_lang["add_custom_facts_help"]				= "~Adicionar fato personalizado~<br /><br />Se você não conseguir encontrar o fato de que deseja adicionar à lista de fatos GEDCOM, poderá inserir um <b>fato personalizado</b> também.<br /><br />Inserir um fato personalizado é apenas tão simples quanto entrar em um dos pré-definidos. A única diferença é que você precisa nomear o fato em vez de escolher seu nome em uma lista. Você tem que fazer isso no campo superior: <b>#pgv_lang[type]#</b>";
$pgv_lang["add_note_help"]						= "#pgv_lang[multiple_help]#<br />~ADICIONAR NOVA NOTA~<br /><br />Se você tem uma nota para adicionar a este registro, este é o lugar para fazê-lo.<br /><br />Basta clicar no link, uma janela se abrirá e você poderá digitar sua nota. Ao terminar de digitar, basta clicar no botão abaixo da caixa, fechar a janela.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_shared_note_help"]				= "#pgv_lang[multiple_help]#<br />~#pgv_lang[add_shared_note_lbl]#~<br /><br />Ao clicar no link <b>#pgv_lang[add_shared_note]#</b>, uma nova janela será aberta. Você pode optar por vincular a uma nota compartilhada existente ou pode criar uma nova nota compartilhada e, ao mesmo tempo, criar um link para ela.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_source_help"]					= "#pgv_lang[multiple_help]#<br />~ADICIONAR NOVA CITAÇÃO DE FONTE~<br /><br />Aqui você pode adicionar uma fonte <b>Citação</b> a este registro.<br /><br />Basta clicar no link, uma janela se abrirá e você poderá escolher a fonte na lista (Encontrar ID) ou crie uma nova fonte e depois adicione a Citação.<br /><br />Adicionar fontes é uma parte importante da genealogia porque permite que outros pesquisadores verifiquem onde você obteve suas informações.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"]						= "~#pgv_lang[add_media]#~<br /><br />Adicionar arquivos multimídia ao GEDCOM é um recurso muito interessante. Embora este programa já tenha uma ótima aparência sem mídia, se você adicionar fotos ou outras mídias aos seus parentes, ele só vai melhorar.<br /><br /><b>O que você deve entender sobre multimídia.</b><br />Existem muitos formatos de multimídia. Embora PhpGedView possa lidar com a maioria deles, há algumas coisas a serem consideradas.<br /><ul><li><b>Formatos</b><br />As imagens podem ser editadas e salvas em vários formatos. Por exemplo, .jpg, .png, .bmp, .gif, etc. Se a mesma imagem original foi usada para criar cada um dos formatos, a imagem exibida aparecerá com o mesmo tamanho, independentemente do formato usado. No entanto, os arquivos de imagem armazenados no banco de dados variam consideravelmente em tamanho. Geralmente, as imagens .jpg são consideradas as mais eficientes em termos de espaço de armazenamento.</li><li><b>Tamanho da imagem</b><br />Quanto maior a imagem original, maior será o tamanho do arquivo resultante. A imagem deve caber na tela sem rolar; a largura ou altura máxima não deve ser maior do que a largura ou altura da tela. PhpGedView é projetado para telas de 1024x768 pixels, mas nem todo esse espaço está disponível para visualização de fotos; o tamanho da imagem deve ser definido de acordo. Para reduzir o tamanho dos arquivos, imagens menores são mais desejáveis.</li><li><b>Resolução</b><br />A resolução de uma imagem geralmente é medida em \"dpi\" (dots per inch == pontos / polegada), mas isso é válido apenas para imagens impressas. Ao considerar as imagens mostradas na tela, a única maneira correta é usar o total de pontos ou pixels. Quando impressa, a imagem pode ter uma resolução de 150 a 300 dpi ou mais, dependendo da impressora. As resoluções de tela raramente são melhores do que 50 pixels por polegada. Se a sua foto nunca for impressa, você pode diminuir a resolução (e, conseqüentemente, o tamanho do arquivo) sem afetar a qualidade da foto. Se uma foto de baixa resolução for impressa com uma ampliação muito grande, sua qualidade será prejudicada; terá uma aparência granulada.</li><li><b>Profundidade de cor</b><br />Outra maneira de manter um arquivo pequeno é diminuir o número de cores que você usa. O número de cores pode variar de preto e branco puro (duas cores) a cores verdadeiras (milhões de cores) e qualquer coisa intermediária. Você pode ver que quanto mais cores são usadas, maior o tamanho dos arquivos.</li></ul><br /><b>Por que é importante manter o tamanho do arquivo pequeno?</b><ul><li>Em primeiro lugar: nosso espaço na web é limitado. Quanto mais arquivos grandes houver, mais espaço na web precisamos no servidor. Quanto mais espaço precisarmos, maiores serão nossos custos.</li><li>Largura de banda. Quanto mais dados nosso servidor tiver para enviar para o local remoto (seu local), mais teremos que pagar. Isso ocorre porque a capacidade de suporte da conexão do servidor à Internet é limitada e o link deve ser compartilhado (e pago) por todos os aplicativos em execução no servidor. PhpGedView é um dos muitos aplicativos que compartilham o servidor. O custo é normalmente rateado de acordo com a quantidade de dados que cada aplicativo envia e recebe.</li><li>Tempo de download. Se você tiver arquivos grandes, o usuário (também você) terá que esperar muito para que a página seja baixada do servidor. Nem todo mundo é abençoado com uma conexão a cabo, banda larga ou DSL.</li></ul><br /><b>Como fazer upload de sua multimídia</b><br />Existem duas maneiras de fazer upload de mídia para o site. Se você tiver muitos itens de mídia para carregar, entre em contato com o administrador do site para discutir as melhores maneiras. Se tiver sido habilitado pelo administrador do site, você pode usar o formulário Upload de mídia no menu #pgv_lang[mgv]#. Você também pode usar a opção Upload no formulário Multimídia para fazer upload de itens de mídia.";
$pgv_lang["gen_missing_thumbs_help"]			= "~#pgv_lang[gen_missing_thumbs]#~<br /><br />Esta opção irá gerar miniaturas para todos os arquivos no diretório atual que ainda não tenham uma miniatura. Isso é muito mais conveniente do que clicar no link <b>#pgv_lang[gen_thumb]#</b> para cada um desses arquivos.<br /><br />Se desejar manter o controle sobre quais arquivos devem ter miniaturas correspondentes, você não deve usar esta opção. Em vez disso, clique nos links <b>#pgv_lang[gen_thumb]#</b> apropriados. ";
$pgv_lang["add_facts_general_help"]				= "~Informações gerais sobre como adicionar~<br /><br />Depois de adicionar um fato, nota, fonte ou arquivo multimídia a um registro no banco de dados, a adição ainda precisa ser aprovada por um usuário que tenha direitos de Aceitar.<br /><br />Até que as alterações sejam aceitas , eles são identificados como \"pendentes\" por uma borda de cor diferente. Todos os usuários com direitos Editar podem ver essas alterações, bem como as informações originais. Os usuários que não têm direitos de edição verão apenas as informações originais. Quando a adição for aceita, as bordas desaparecerão e os novos dados serão exibidos normalmente, substituindo os antigos. Nesse momento, os usuários sem direitos de edição também verão os novos dados.";

//-- Edit user
$pgv_lang["edituser_my_account_help"]			= "Aqui você pode alterar suas configurações e preferências.<br /><br />Você pode alterar seu nome de usuário, nome completo, senha, idioma, endereço de e-mail, tema do site e método de contato preferido.<br /><br />Você não pode alterar o ID do registro GEDCOM INDI; isso deve ser feito por um administrador.";
$pgv_lang["edituser_username_help"]				= "~#pgv_lang[username]#~<br /><br />Nesta caixa você pode alterar seu nome de usuário. Se você não gosta mais do seu nome de usuário ou se tem outros motivos para alterá-lo, pode fazer isso usando este formulário.<br /><br />O nome de usuário <u>diferencia maiúsculas de minúsculas</u>. Isso significa que <b>John</b> não é o mesmo que <b>john</b> ou <b>JOHN</b>.<br /><br />Você deve <u>apenas</u> use caracteres dos alfabetos que PhpGedView suporta. Você pode usar letras maiúsculas e minúsculas com ou sem marcas diacríticas, números, traço (-) e sublinhado (_). <u>Não</u> use sinais de pontuação ou espaços.";
$pgv_lang["edituser_firstname_help"]			= "~#pgv_lang[firstname]#~<br /><br />Nesta caixa você pode alterar seu primeiro nome. Este é o nome que os outros usuários veem quando você está logado.<br /><br />Embora a escolha do que inserir neste campo seja sua, você deve informar o administrador ao alterá-lo. Quando outras pessoas veem uma pessoa desconhecida on-line, elas podem se perguntar e fazer perguntas. O administrador pode descobrir sem ter recebido seu aviso, mas você deve salvá-lo desse trabalho desnecessário.";
$pgv_lang["edituser_lastname_help"]				= "~#pgv_lang[lastname]#~<br /><br />Nesta caixa você pode alterar seu sobrenome. Este é o nome que os outros usuários veem quando você está logado.<br /><br />Embora a escolha do que inserir neste campo seja sua, você deve informar o administrador ao alterá-lo. Quando outras pessoas veem uma pessoa desconhecida on-line, elas podem se perguntar e fazer perguntas. O administrador pode descobrir sem ter recebido seu aviso, mas você deve salvá-lo desse trabalho desnecessário.";
$pgv_lang["edituser_gedcomid_help"]				= "~#pgv_lang[gedcomid]#~<br /><br />Este é um número de identificação que liga você aos seus próprios dados no banco de dados.<br /><br />Você não pode alterar este ID; é definido pelo administrador. Se você acha que este ID não está correto, você deve entrar em contato com o administrador para alterá-lo.";
$pgv_lang["edituser_rootid_help"]				= "~#pgv_lang[rootid]#~<br /><br />Esta é a pessoa inicial (Raiz) de todos os seus gráficos.<br /><br />Se, por exemplo, você clicar no link para o Gráfico de Linhagem, verá essa pessoa raiz na caixa mais à esquerda. Essa pessoa raiz não precisa ser você; você pode começar com qualquer pessoa (seu avô ou tia de sua mãe, por exemplo), desde que você tenha o direito de ver essa pessoa.<br /><br />Esta opção altera a pessoa Root padrão para a maioria dos gráficos. Você pode alterar a pessoa Raiz realmente usada em muitos gráficos, mas isso é apenas para aquela página naquele momento específico.";
$pgv_lang["edituser_password_help"]				= "~#pgv_lang[password]#~<br /><br />É uma boa prática alterar sua senha regularmente. Você deve ter em mente que qualquer pessoa que saiba seu nome de usuário e sua senha terá acesso aos seus dados.<br /><br />Faça a senha com pelo menos 6 caracteres, quanto mais longa melhor. Você pode usar letras maiúsculas e minúsculas com ou sem marcas diacríticas, números, traço (-) e sublinhado (_). <u>Não</u> use sinais de pontuação ou espaços. Use uma combinação de maiúsculas e minúsculas, números e outros caracteres. Por exemplo: <b>5Z_q\$P4=r9</b>.<br /><br />Assim como o nome de usuário, a senha <u>diferencia maiúsculas de minúsculas</u>. Isso significa que <b>SenhaSecreta!#13</b> não é o mesmo que <b>senhasecreta!#13</b> ou <b>SENHASECRETA!#13</b>.";
$pgv_lang["edituser_conf_password_help"]		= "~#pgv_lang[confirm]#~<br /><br />Se você alterou sua senha, também precisa confirmá-la. Isso é apenas para garantir que você não cometeu nenhum erro de digitação no campo de senha.<br /><br />Se a senha e sua confirmação não forem idênticas, você receberá uma mensagem de erro adequada. Você terá que redigitar a senha original e sua confirmação.";
$pgv_lang["edituser_change_lang_help"]			= "~#pgv_lang[change_lang]#~<br /><br />Aqui você pode alterar o idioma no qual o PhpGedview exibirá todas as suas páginas e mensagens após você ter feito login.<br /><br />Quando você acessa o site pela primeira vez, o PhpGedView assume que você deseja ver tudo no idioma configurado como o idioma preferido em seu navegador. Se essa suposição estiver incorreta, você a substituirá aqui. Por exemplo, seu navegador pode estar configurado para inglês porque esse é o idioma mais comum na Internet. No entanto, para fins genealógicos, você prefere ver tudo em português ou francês. É aqui que você faz isso.<br /><br />O administrador controla quais opções de idioma estão disponíveis para você. Se sua preferência não estiver listada, você precisa entrar em contato com o administrador.<br /><br />Por favor, lembre-se que PhpGedView é basicamente um projeto composto por uma equipe internacional de voluntários não remunerados. Os especialistas vêm e vão. Consequentemente, o suporte para idiomas diferentes do inglês às vezes não é tão bom quanto deveria.<br /><br />Se você vir algo que não foi traduzido, foi traduzido incorretamente ou poderia ter uma formulação melhor, informe o seu administrador conhecer. O administrador saberá como entrar em contato com a equipe de desenvolvedores do PhpGedView para esclarecer suas dúvidas. Melhor ainda, ofereça parte do seu tempo. Podemos usar a ajuda.";
$pgv_lang["edituser_email_help"]				= "~#pgv_lang[emailadress]#~<br /><br />O seu endereço de e-mail correto é importante para mantermos contato com você.<br /><br />Se você receber um novo endereço de e-mail, como normalmente acontece quando você muda de provedor de Internet, não se esqueça de alterar o endereço aqui também. Você não receberá uma mensagem de confirmação deste site quando alterar este endereço, mas todas as mensagens futuras direcionadas a você irão para este novo endereço.";
$pgv_lang["edituser_user_theme_help"]			= "~#pgv_lang[user_theme]#~<br /><br />Este site pode ter vários looks ou aparências diferentes. Outros programas podem chamá-los de \"skins\", mas aqui estão eles de \"temas\".<br /><br />Cada tema exibirá os mesmos dados, mas sua apresentação ou mesmo sua localização na tela podem variar. É como colocar uma imagem em um quadro diferente e pendurá-la em uma sala diferente também. A imagem não muda, mas a maneira como você a olha é completamente diferente.<br /><br />Experimente. Defina-o para outro tema. Olhe para isso, tente outro. Mude de volta para aquele que mais lhe convier. Sempre que você fizer login, verá o último tema usado; você nem mesmo precisa chegar a esta página de configuração para alterar seu tema preferido.";
$pgv_lang["edituser_contact_meth_help"]			= "~#pgv_lang[user_contact_method]#~<br /><br />PhpGedView possui vários métodos de contato diferentes. O administrador determina qual método será usado para contatá-lo. Você tem controle sobre o método a ser usado para entrar em contato com <u>você</u>. Dependendo da configuração do site, alguns dos métodos listados podem não estar disponíveis para você.";
$pgv_lang["mail_option1_help"]					= "Com esta opção, o sistema de mensagens internas do PhpGedView será usado e nenhum e-mail será enviado.<br /><br />Você receberá apenas mensagens <u>internas</u> de outros usuários. Quando outro usuário do site lhe enviar uma mensagem, essa mensagem aparecerá no bloco Mensagem em sua página #pgv_lang[mygedview]# pessoal. Se você removeu este bloqueio de sua página #pgv_lang[mygedview]#, você não verá nenhuma mensagem. Eles irão, no entanto, aparecer assim que você configurar a página #pgv_lang[mygedview]# para ter novamente o bloco de mensagem.";
$pgv_lang["mail_option2_help"]					= "Essa opção é como #pgv_lang[messaging]#, com uma adição. Como extra, uma cópia da mensagem também será enviada para o endereço de e-mail que você configurou na página da sua Conta.<br /><br />Este é o método de contato padrão.";
$pgv_lang["mail_option3_help"]					= "Com esta opção, você só receberá mensagens de e-mail no endereço que configurou na página da sua conta. O sistema de mensagens interno do PhpGedView não será usado de forma alguma, e nunca haverá nenhuma mensagem no bloco de mensagens em sua página pessoal #pgv_lang[mygedview]#.";
$pgv_lang["mail_option4_help"]					= "Com esta opção, você não receberá nenhuma mensagem. Nem mesmo o administrador conseguirá entrar em contato com você.";

//-- Admin
$pgv_lang["admin_help"]							= "Nesta página você encontrará links para as páginas de configuração, páginas de administração, documentação e arquivos de log.<br /><br /><b>#pgv_lang[system_time]#</b>, logo abaixo do título da página, mostra a hora do servidor no qual seu site está hospedado. Isso significa que se o servidor estiver localizado em Nova York enquanto você estiver na Portugal, o horário mostrado será seis horas a menos que o seu horário local, a menos, é claro, que o servidor esteja funcionando no horário de Greenwich (GMT). A hora mostrada é a hora do servidor quando você abriu ou atualizou esta página.<br /><br /><b>AVISO</b><br />Quando você vir uma mensagem de aviso vermelha sob a hora do sistema, isso significa que seu <i>config.php</i> ainda é gravável. Depois de configurar seu site, você deve, por <b>segurança</b>, definir as permissões deste arquivo de volta para somente leitura. Você tem que fazer isso <u>manualmente</u>, pois PhpGedView não pode fazer isso por você.";

//-- User Admin
$pgv_lang["useradmin_help"]						= "~#pgv_lang[user_admin]#~<br /><br />Nesta página você pode administrar os usuários atuais e adicionar novos usuários.<br /><br /><b>#pgv_lang[current_users]#</b><br />Nesta tabela, os usuários atuais, seus status e direitos são exibidos. Você pode <b>excluir</b> ou <b>editar</b> usuários.<br /><br /><b>#pgv_lang[add_user]#</b><br />Este formulário é quase igual ao que os usuários veem na página <b>#pgv_lang[editowndata]#</b>.<br /><br />Para vários assuntos, não criamos um texto de ajuda especial para o administrador. Nesses casos, você verá a seguinte mensagem:";
$pgv_lang["useradmin_gedcomid_help"]			= "~#pgv_lang[gedcomid]#~<br /><br />O #pgv_lang[gedcomid]# identifica o usuário. Deve ser definido pelo administrador.<br /><br />Este ID é usado como o ID em várias páginas, como <b>#pgv_lang[my_indi]#</b> e <b>#pgv_lang[my_pedigree]#</b>.<br /><br />Você pode definir o ID GEDCOM do usuário separadamente para cada GEDCOM. Se um usuário não possui um registro em um GEDCOM, você deixa essa caixa vazia.";
$pgv_lang["useradmin_rootid_help"]				= "~#pgv_lang[rootid]#~<br /><br />Para cada banco de dados genealógico, você pode designar uma <b>Pessoa Raiz</b> para o usuário.<br /><br />Essa Pessoa Raiz não precisa ser o próprio usuário; pode ser qualquer um. O usuário provavelmente desejará iniciar o gráfico de linhagem com ele mesmo. Você controla isso, assim como a pessoa raiz padrão em outros gráficos, aqui.<br /><br />Se o usuário tiver direitos de edição para as informações de sua própria conta, ele mesmo pode alterar essa configuração.";
$pgv_lang["useradmin_can_admin_help"]			= "~#pgv_lang[can_admin]#~<br /><br />Se esta caixa estiver marcada, o usuário terá os mesmos direitos que você.<br /><br />Esses direitos incluem:<ul><li>Adicionar / Remover / Editar Usuários</li><li>Transmita mensagens para todos os usuários</li><li>Editar mensagens de boas-vindas</li><li>Editar e configurar arquivos de idioma</li><li>Atualizar PhpGedView</li><li>Alterar as configurações do programa e GEDCOM</li><li>Administrar os GEDCOM</li><li>Alterar configurações de privacidade</li><li>E qualquer outra coisa que não seja mencionada aqui.</li></ul><br />O usuário <u>não pode</u> alterar nada em seu servidor fora do PhpGedView.";
$pgv_lang["useradmin_sync_gedcom_help"]			= "~#pgv_lang[sync_gedcom]#~<br /><br />Se esta caixa estiver marcada e o usuário tiver um ID de registro GEDCOM atribuído a ele, suas configurações de conta de usuário serão sincronizadas automaticamente com seus dados GEDCOM. Isso significa que, quando o registro GEDCOM do usuário é editado, algumas informações, como endereço de e-mail e nome, são copiadas para a conta do usuário. Quando a conta do usuário é editada, as informações correspondentes serão copiadas para o registro GEDCOM.";
$pgv_lang["useradmin_can_edit_help"]			= "~#pgv_lang[can_edit]#~<br /><br />O usuário pode ter diferentes privilégios de acesso e edição para cada banco de dados genealógico do sistema.<ul><li><b>#pgv_lang[none]#:</b>&nbsp;&nbsp;&nbsp;O usuário não pode acessar os dados privados neste GEDCOM.</li><li><b>#pgv_lang[access]#:</b>&nbsp;&nbsp;&nbsp;O usuário não pode editar ou aceitar dados no banco de dados, mas pode ver os dados privados.</li><li><b>#pgv_lang[edit]#:</b>&nbsp;&nbsp;&nbsp;O usuário pode editar valores, mas outro usuário com privilégios <b>#pgv_lang[accept]#</b> deve aprovar as alterações antes que sejam adicionadas ao banco de dados e tornadas públicas.</li><li><b>#pgv_lang[accept]#:</b>&nbsp;&nbsp;&nbsp;O usuário pode editar. Ele também pode editar e aprovar alterações feitas por outros usuários.</li><li><b>#pgv_lang[admin_gedcom]#:</b>&nbsp;&nbsp;&nbsp;O usuário edita e aprova as alterações feitas por outros usuários. O usuário também pode editar a configuração e as configurações de privacidade <u>este</u> GEDCOM.</li></ul>Os administradores de sistema, identificados por meio da caixa de seleção <b>#pgv_lang[can_admin]#</b>, recebem automaticamente privilégios <b>#pgv_lang[admin_gedcom]#</b>.";
$pgv_lang["useradmin_verified_help"]			= "~#pgv_lang[verified]#~<br /><br /><b>Autorregistro</b><br />O usuário pode solicitar uma nova conta por meio do módulo de <b>autorregistro</b>.<br /><br />Ao fazer isso, ele receberá um email com um link para verificar sua inscrição. Depois que o candidato seguir as instruções naquele e-mail, você verá esta caixa marcada e poderá prosseguir para a próxima etapa, <b>#pgv_lang[verified_by_admin]#</b>. Você deve aguardar a sua aprovação enquanto esta caixa não estiver marcada.<br /><br /><b>Adicionar usuário manualmente</b><br />Se usar este formulário para adicionar um usuário manualmente, você irá encontre esta caixa já marcada.";
$pgv_lang["useradmin_verbyadmin_help"]			= "~#pgv_lang[verified_by_admin]#~<br /><br />Se um usuário usou o módulo de Autorregistro e verificou a si mesmo, a última etapa, antes de sua conta se tornar ativa, é a sua aprovação.<br /><br />Após ter aprovado o pedido do usuário para uma nova conta, o usuário receberá uma mensagem de e-mail. A mensagem informará ao usuário que sua conta agora está ativa. Ele pode fazer o login com o nome de usuário e a senha que forneceu quando solicitou a conta.";
$pgv_lang["useradmin_edit_user_help"]			= "~#pgv_lang[update_user]#~<br /><br />Este formulário é usado pelo administrador para alterar a conta de um usuário<br /><br />O formulário é muito semelhante aos formulários <b>#pgv_lang[add_user]#</b> e <b>#pgv_lang[update_myaccount]#</b>.";
$pgv_lang["useradmin_visibleonline_help"]		= "~#pgv_lang[visibleonline]#~<br /><br />Esta caixa de seleção controla sua visibilidade para outros usuários enquanto você está online. Ele também controla sua capacidade de ver outros usuários online que estão configurados para serem visíveis.<br /><br />Quando esta caixa estiver desmarcada, você ficará completamente invisível para os outros e também não será capaz de ver outros usuários que estão online. Quando esta caixa está marcada, exatamente o oposto é verdadeiro. Você ficará visível para outras pessoas e também poderá ver outras pessoas que estão configuradas como visíveis.";
$pgv_lang["useradmin_editaccount_help"]			= "~#pgv_lang[editaccount]#~<br /><br />Se esta caixa estiver marcada, este usuário poderá editar as informações de sua conta. Embora isso não seja geralmente recomendado, você pode criar um único nome de usuário e senha para vários usuários. Quando esta caixa está desmarcada para todos os usuários com a conta compartilhada, eles são impedidos de editar as informações da conta e apenas um administrador pode alterar essa conta.";
$pgv_lang["useradmin_relation_priv_help"]		= "~#pgv_lang[user_relationship_priv]#~<br /><br />Se esta caixa estiver marcada, o usuário só terá acesso às pessoas vivas com as quais seja parente. Eles poderão ver qualquer um que esteja dentro do comprimento do caminho de relacionamento definido por sua configuração <i>#pgv_lang[user_path_length]#</i>. Você pode exigir privacidade de relacionamento para todos os seus usuários, ativando a opção global nas configurações de privacidade GEDCOM.<br /><br />Esta configuração requer que o usuário seja associado a um ID GEDCOM antes de poder ver qualquer pessoas vivas.";
$pgv_lang["useradmin_path_length_help"]			= "~#pgv_lang[user_path_length]#~<br /><br />Se a opção <i>#pgv_lang[user_relationship_priv]#</i> estiver habilitada, este usuário só poderá ver ou editar indivíduos vivos dentro deste número de etapas de relacionamento.";
$pgv_lang["useradmin_auto_accept_help"]			= "~#pgv_lang[user_auto_accept]#~<br /><br />Ao marcar esta caixa, você está permitindo que o sistema aceite automaticamente quaisquer alterações de edição feitas por este usuário. O usuário também deve aceitar privilégios no GEDCOM para que essa configuração tenha efeito.";

//-- Manage Sites
$pgv_lang["help_managesites"] 					= "~#pgv_lang[link_manage_servers]#~<br /><br />Nesta página, você pode adicionar sites remotos e negar acesso de endereços IP específicos.<br /><br />Os sites remotos podem ser adicionados fornecendo o título do site, URL, id do banco de dados (opcional), nome de usuário e senha para o remoto serviço da web.<br /><br />A negação de acesso IP permanente ou temporizado é realizada fornecendo um endereço IP exato ou qualquer intervalo de endereço IP válido. Por exemplo, 212.10.*.* Sites remotos dentro dos intervalos de endereços IP da lista não poderão acessar seu site.";
//-- Adding Remote Links
$pgv_lang["help_remotesites"]					= "~#pgv_lang[label_new_server]#~<br /><br />Para adicionar um site remoto, forneça o título do site, URL do serviço web remoto, id do banco de dados (opcional) e nome de usuário e senha. Clique no botão Adicionar (+) para concluir o processo. Se o servidor remoto permitir autenticação anônima, você deve deixar o nome de usuário e a senha em branco.";
//-- IP Address Banning
$pgv_lang["help_IPv4IPv6"]						= "Os endereços IPv4 consistem em 4 segmentos separados por \".\" (Ponto final) e contendo números decimais no intervalo de zero a 255 sem zeros à esquerda. Os exemplos são: b>172.252.19.56</b> , <b>212.10.*.*</b> , <b>212.10.</b> , <b>212.10</b> , <b>212.10..29</b> ou <b>212.10.*.29</b> . Os segmentos ausentes nestes exemplos serão interpretados como \"*\" (asterisco), com o símbolo \"*\" significando <i>corresponder a qualquer número nesta posição</i>.<br /><br />Os endereços IPv6 consistem em 8 segmentos separados por \":\" (dois pontos) e contendo números hexadecimais de 4 dígitos. Esses números não devem ter zeros à esquerda, e a primeira sequência de zeros pode ser removida e substituída por um par de símbolos \":\" (dois pontos). Se você precisa usar o recurso <i>corresponder a qualquer número nesta posição</i>, você precisa inserir explicitamente \"*\" (asterisco) lá. Os exemplos são: <b>23:0:cafe::2:1</b> , <b>23:0:cafe::*:1</b> ou <b>23:0:*::*:*</b> . Nestes exemplos, o par de dois pontos representa uma sequência de 3 números, cada um dos quais é zero, da seguinte forma: <b>23:0:cafe:0:0:0:*:1</b> .";
$pgv_lang["help_banning"]						= "~#pgv_lang[label_banned_servers]#~<br /><br />Para evitar que endereços IPv4 ou IPv6 específicos acessem seu site, digite um endereço IP exato ou um intervalo de endereços IP válido e clique no botão Adicionar (+).<br /><br />#pgv_lang[help_IPv4IPv6]#";
$pgv_lang["help_timedban"]						= "~#pgv_lang[label_timedban_servers]#~<br /><br />Quando uma tentativa de hacking é detectada, o PhpGedView impedirá automaticamente o acesso daquele endereço IP por uma hora.<br /><br />Você pode adicionar suas próprias negações de acesso temporizadas inserindo o endereço IPv4 ou IPv6 a ser bloqueado junto com a data e tempo de expiração da negação de acesso no campo Comentários. Certifique-se de usar o formato correto para as informações de expiração. Se a informação de expiração não for inserida corretamente, a negação de acesso não expirará automaticamente.<br /><br />A expiração deve ser inserida no seguinte formato: <b>aaaa.mm.dd@hh:mm</b>. Por exemplo, <b>2012.12.23@23:59</b>. Observe o uso do relógio de 24 horas.<br /><br />#pgv_lang[help_IPv4IPv6]#";
$pgv_lang["help_manual_search_engines"]			= "~#pgv_lang[label_manual_search_engines]#~<br /><br />PhpGedView fornece automaticamente aos mecanismos de pesquisa arquivos de dados menores com menos links. Os dados são limitados ao indivíduo e família imediata, sem adicionar informações sobre avós ou netos. Muitos relatórios e páginas de uso intensivo do servidor, como o calendário, estão fora dos limites para os mecanismos de pesquisa.<br /><br />Muitos mecanismos de pesquisa populares como o Google e o Bing serão detectados automaticamente. Se um mecanismo de pesquisa não for reconhecido automaticamente e você desejar fornecer dados para indexar, você pode inserir seu endereço IPv4 ou IPv6 aqui. Se você deseja excluir este novo mecanismo de pesquisa completamente, você o lista na seção <i>#pgv_lang[label_banned_servers]#</i>.<br /><br />Se você deseja ver quais dados são fornecidos para pesquisa mecanismos para indexar, liste seu próprio endereço IP aqui.&nbsp; <span class='warning'>AVISO:</span>&nbsp; Isso irá <b>bloquear você</b> da interface do administrador e você deve remover o endereço IP fazendo login em uma máquina diferente com um endereço IP diferente ou editando manualmente o tabela <i>#GLOBALS[TBLPREFIX]#ip_address</i> de banco de dados.<br /><br />#pgv_lang[help_IPv4IPv6]#";

//-- Search_engines.php
$pgv_lang["search_engine_landing_page"]			= "~Motor de pesquisa detectado~<br /><br />PhpGedView fornece automaticamente aos mecanismos de pesquisa arquivos de dados menores com menos links. Os dados são limitados à pessoa e família imediata, sem adicionar informações sobre avós ou netos. Muitos relatórios e páginas com uso intensivo de servidor, como o calendário, estão fora dos limites dos mecanismos de pesquisa.<br /><br />As tentativas dos mecanismos de pesquisa de acessar essas páginas resultam na exibição desta página. Se você estiver vendo este texto, o software acredita que você é um mecanismo de pesquisa. Abaixo está a lista de páginas que podem ser acessadas e fornecerão os dados abreviados.<br /><br />Os usuários reais que seguirem os links dos mecanismos de pesquisa para este site verão as páginas e os dados completos, e não esta página.";

//-- G E D C O M
$pgv_lang["add_upload_gedcom_help"]				= "~#pgv_lang[add_gedcom]#~<br />~#pgv_lang[upload_gedcom]#~<br /><br /><b>Carregando arquivos GEDCOM</b><br />O upload de arquivos pode ser feito online. Você pode fazer upload de qualquer lugar sem precisar de um programa especial.<br /><br /><b>Adicionar arquivos GEDCOM</b><br />Se um arquivo carregado anteriormente ainda estiver presente no diretório <b>/index</b>, você poderá usá-lo novamente sem carregar. Às vezes, devido a limitações de tamanho de arquivo ou upload, você precisa usar Adicionar.<br /><br />O procedimento Adicionar e Carregar pode ser concluído em quatro etapas simples. Em qualquer um dos procedimentos, apenas a Etapa 1 é diferente.";
$pgv_lang["gedcom_configfile_help"]				= "~ARQUIVO DE CONFIGURAÇÃO GEDCOM~<br /><br />Este é o arquivo onde todas as configurações básicas relacionadas ao banco de dados genealógicos são armazenadas. Há um arquivo separado para cada banco de dados.<br /><br />Você encontrará o caminho e o nome de cada arquivo de configuração na tabela <b>#pgv_lang[current_gedcoms]#</b> da página <b>#pgv_lang[gedcom_adm_head]#</b>.";
$pgv_lang["default_gedcom_help"]				= "~PADRÃO GEDCOM~<br /><br />Se você tiver mais de um banco de dados genealógico, você pode definir aqui qual deles será o padrão.<br /><br />Este padrão será mostrado a todos os visitantes e usuários que ainda não se logaram.<br /><br />Os usuários que podem editar suas configurações de conta podem substituir este padrão. Nesse caso, o banco de dados preferido do usuário será mostrado após o login.";
$pgv_lang["delete_gedcom_help"]					= "~EXCLUIR GEDCOM~<br /><br />PhpGedView cria seu banco de dados a partir de um arquivo GEDCOM que foi carregado anteriormente. Ao selecionar <b>Excluir</b>, essa seção do banco de dados será apagada. Você tem que confirmar sua solicitação de exclusão.<br /><br />A menos que você tenha deliberadamente removido fora do PhpGedView, o arquivo GEDCOM original permanecerá no diretório no qual foi carregado. Se mais tarde você quiser trabalhar com aquele arquivo GEDCOM novamente, não será necessário carregá-lo novamente. Você pode escolher a função <b>#pgv_lang[add_gedcom]#</b>.";
$pgv_lang["add_gedcom_help"]					= "~#pgv_lang[add_gedcom]#~<br /><br />Quando você usa a função <b>#pgv_lang[add_gedcom]#</b>, presume-se que você já carregou o arquivo GEDCOM em seu servidor usando um programa ou método <u>externo</u> para PhpGedView, por exemplo, <i>ftp</i> ou <i>conexão de rede</i>. O arquivo que você deseja adicionar também pode ter sobrado de um procedimento <b>#pgv_lang[upload_gedcom]#</b> anterior.<br /><br />Se o arquivo GEDCOM de entrada ainda não estiver em seu servidor, você <u>deve</u> obtê-lo lá primeiro, antes de começar a adicionar.<br /><br />Em vez de enviar um arquivo GEDCOM, você também pode fazer upload de um arquivo ZIP contendo o arquivo GEDCOM, seja com PhpGedView, ou usando um programa externo. PhpGedView reconhecerá o arquivo ZIP automaticamente e extrairá o arquivo GEDCOM e o nome do arquivo do arquivo ZIP.<br /><br />Se um arquivo GEDCOM com o mesmo nome já existir no PhpGedView, ele será sobrescrito. No entanto, todas as configurações GEDCOM feitas anteriormente serão preservadas.<br /><br />Você será guiado passo a passo pelo procedimento.";
$pgv_lang["add_new_gedcom_help"]				= "~#pgv_lang[add_new_gedcom]#~<br /><br />Você pode iniciar um novo banco de dados genealógico do zero.<br /><br />Este procedimento requer apenas algumas etapas simples. A etapa 1 é diferente do que você já conhece sobre upload e adição. As outras etapas serão familiares.<ol><li><b>Nomeando o novo GEDCOM</b><br />Digite o nome do novo GEDCOM <u>sem</u> a extensão <b>.ged</b>. O novo arquivo será criado no diretório nomeado acima da caixa onde você insere o nome. Clique em <b>Adicionar</b>.</li><li><b>Página de configuração</b><br />Você já conhece esta página; você define as configurações para seu novo arquivo GEDCOM.</li><li><b>Validar</b><br />Você já conhece esta página; o novo GEDCOM é verificado. Como não há nada nele, ficará tudo bem.</li><li><b>Importando registros</b><br />Como haverá apenas um registro para importar, isso será concluído muito rapidamente.</li></ol>É isso aí. Agora você pode ir para o gráfico de linhagem para ver sua primeira pessoa no novo GEDCOM. Clique no nome da pessoa e comece a editar. Depois disso, você pode vincular novas pessoas à primeira pessoa.";
$pgv_lang["download_gedcom_help"]				= "~#pgv_lang[download_gedcom]#~<br /><br />Nesta página, você pode baixar seu banco de dados genealógico no formato GEDCOM. Você pode querer importar os dados para outro programa genealógico ou compartilhar suas informações com outras pessoas.<br /><br />#pgv_lang[utf8_ansi_help]#<br /><br />#pgv_lang[remove_tags_help]#<br /><br />#pgv_lang[download_zipped_help]#";
$pgv_lang["edit_gedcoms_help"]					= "~#pgv_lang[gedcom_adm_head]#~<br /><br />A página #pgv_lang[gedcom_adm_head]# é o centro de controle para administrar todos os seus bancos de dados genealógicos.<br /><br /><b>#pgv_lang[current_gedcoms]#</b><br />No topo da tabela #pgv_lang[current_gedcoms]#, você vê uma barra de ação com quatro links.<ul><li>#pgv_lang[add_gedcom]#</li><li>#pgv_lang[upload_gedcom]#</li><li>#pgv_lang[add_new_gedcom]#</li><li>#pgv_lang[lang_back_admin]#</li></ul>Na tabela <b>#pgv_lang[current_gedcoms]#</b>, cada banco de dados genealógico é listado separadamente e você tem as seguintes opções para cada um deles:<ul><li>Importar</li><li>Excluir</li><li>Baixar</li><li>Editar configuração</li><li>Editar privacidade</li><li>Arquivos de log de pesquisa</li></ul>Editar privacidade aparece aqui porque cada GEDCOM tem seu próprio arquivo de privacidade.<br /><br />Cada linha nesta tabela deve ser autoexplicativa. PhpGedView pode ser configurado para registrar todas as pesquisas de banco de dados. Os arquivos de log de pesquisa podem ser inspecionados por meio de links encontrados nesta página.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["edit_config_gedcom_help"]			= "~CONFIGURAR GEDCOM~<br /><br />Cada banco de dados genealógico usado com PhpGedView tem seu próprio <b>arquivo de configuração</b>.<br /><br />Neste formulário você configura várias opções como título do banco de dados, idioma, formato do calendário, opções de email, registro do banco de dados pesquisas, cabeçalhos HTML META, remoção de sobrenomes da lista de sobrenomes frequentes do banco de dados, etc.";
$pgv_lang["import_gedcom_help"]					= "~IMPORTAÇÃO GEDCOM~<br /><br />Na maioria dos casos, a importação de um arquivo GEDCOM criado externamente é uma etapa dos procedimentos que resultam em alterações em massa no banco de dados genealógico.<br /><br />Essas etapas estão em uma seqüência lógica e precisam ser concluídas na ordem prescrita, portanto que o banco de dados genealógico é utilizável.<br /><br />Se, por algum motivo, você não concluiu essas etapas na ordem correta, verá uma mensagem de <u>aviso</u> de que o GEDCOM não ainda importado. Para corrigir o problema, clique no link <b>Importar GEDCOM</b> para importar o arquivo.<br /><br />As configurações existentes do GEDCOM não serão alteradas quando você reimportar um GEDCOM. Os dados existentes serão, entretanto, sobrescritos.";
$pgv_lang["upload_gedcom_help"]					= "~#pgv_lang[upload_gedcom]#~<br /><br />Ao contrário da função <b>#pgv_lang[add_gedcom]#</b>, o arquivo GEDCOM que você deseja adicionar ao seu banco de dados não precisa estar no seu servidor.<br /><br />Na Etapa 1, você seleciona um arquivo GEDCOM do seu computador local. Digite o caminho completo e o nome do arquivo na caixa de texto ou use o botão <b>Procurar</b> na página.<br /><br />Você também pode usar esta função para fazer upload de um arquivo ZIP contendo o arquivo GEDCOM. O PhpGedView reconhecerá o arquivo ZIP e extrairá o arquivo e o nome do arquivo automaticamente.<br /><br />Se um arquivo GEDCOM com o mesmo nome já existir no PhpGedView, ele será, após sua confirmação, sobrescrito. Porém, todas as configurações GEDCOM feitas anteriormente serão preservadas.<br /><br />Você encontrará mais ajuda em outras páginas do procedimento.";
$pgv_lang["validate_gedcom_help"]				= "~VALIDAR GEDCOM~<br /><br />Este é o terceiro passo no procedimento para adicionar dados GEDCOM criados externamente ao seu banco de dados genealógico.<br /><br />O PhpGedView verificará o arquivo de entrada para o uso correto do formato de data, formato de local, conjunto de caracteres, etc. desvios do padrão GEDCOM 5.5.1, ao qual o PhpGedView adere, podem ser corrigidos automaticamente. Exemplos são finais de linha no Macintosh e uso incorreto do formato Place. Quando isso acontecer, você verá uma mensagem de que os dados foram alterados. Para outras anormalidades, você receberá uma mensagem de aviso com uma solução recomendada.<br /><br /><b>Ferramentas opcionais</b><br />No momento, há apenas uma ferramenta adicional: <b>Alterar ID individual para ...</b>.<br /><br /><b>Mais ajuda</b><br />#pgv_lang[context_help]#";
$pgv_lang["convert_ansi2utf_help"]				= "~CONVERTER ANSI PARA UTF-8~<br /><br />Para garantir que as informações em seus arquivos GEDCOM de entrada sejam processadas e exibidas corretamente, esses arquivos devem ser codificados em UTF-8.<br /><br />Alguns dos programas de genealogia mais modernos podem exportar seus dados para um arquivo GEDCOM em Codificação UTF-8. Programas mais antigos geralmente não têm esse recurso. Se o seu programa não oferece esta opção, PhpGedView pode converter o arquivo para você.<br /><br />Quando PhpGedView valida o arquivo de entrada, ele detectará a codificação do arquivo e o avisará de acordo.";
$pgv_lang["detected_ansi2utf_help"]				= "~CODIFICAÇÃO ANSI DETECTADA~<br /><br />O arquivo GEDCOM sendo validado agora está codificado no conjunto de caracteres ANSI. É altamente recomendável converter a codificação do arquivo para UTF-8.<br /><br />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"]					= "~FORMATO DE DATA ERRADO DETECTADO~<br /><br /><b>O FORMATO DA DATA SERÁ ALTERADO</b><br /><br />O formato de data que é padrão para PhpGedView e também de acordo com o padrão GEDCOM 5.5.1 é <b>DD&nbsp;MMM&nbsp;AAAA</b> (e.g. 01&nbsp;JAN&nbsp;2004)<br /><br />Se, após a validação do seu arquivo GEDCOM, você vir uma mensagem de que um formato de data incorreto foi detectado, o PhpGedView converterá as datas formatadas incorretamente conforme prescrito pelo padrão.<br /><br />Você tem, no entanto, a opção de escolher \"<b>dia</b> antes do mês\" (DD&nbsp;MMM&nbsp;AAAA), ou \"<b>mês</b> antes do dia\" (MMM&nbsp;DD&nbsp;AAAA).<br /><br />Recomendamos que você use o primeiro formato (dia antes do mês).";
$pgv_lang["change_indi2id_help"]				= "~ALTERAR ID DA PESSOA PARA ....~<br /><br />Essa ferramenta foi projetada para usuários cujos programas de Genealogia usam um ID GEDCOM diferente para os indivíduos sempre que o GEDCOM é exportado. Por exemplo, na primeira vez que o GEDCOM é exportado, o ID de alguma pessoa pode ser I100, mas na próxima vez que o GEDCOM é exportado, o ID da mesma pessoa é alterado para I234. Essas mudanças de IDs tornam difícil administrar PhpGedView porque o ID é como as pessoas são referenciadas.<br /><br />A maioria dos programas de genealogia também usa a tag RIN ou REFN para dar a cada pessoa um identificador único que pode ser usado para fazer referência ao Individual. Essa ferramenta substituirá todos os IDs de pessoas no arquivo GEDCOM pelo campo (RIN ou REFN) que você especificar.";
$pgv_lang["edit_privacy_help"]					= "Nesta página você pode definir todas as configurações de privacidade para o GEDCOM selecionado.<br /><br />Você pode verificar sob o título da página se está editando o arquivo de privacidade correto. Ele é exibido da seguinte forma: (caminho/nomedoseugedcom_priv.php)<br /><br />Se precisar de mais configurações, você pode fazer alterações no arquivo de privacidade manualmente. Você pode ler mais sobre isso no site PhpGedView.";
$pgv_lang["BOM_detected_help"]					= "~Byte Order Mark (BOM) detectado~<br /><br />O arquivo GEDCOM que você está importando tem um código especial de 3 bytes no início. Este código especial é usado por alguns programas para indicar que o arquivo foi gravado no conjunto de caracteres UTF-8.<br /><br />Embora este código especial não seja realmente um erro, PhpGedView não funcionará corretamente quando a entrada arquivo contém o código. Você deve deixar o PhpGedView remover o código.";
$pgv_lang["invalid_header_help"]				= "~CABEÇALHO GEDCOM INVÁLIDO~<br /><br />Um arquivo GEDCOM deve começar com <b>0&nbsp;HEAD</b>. PhpGedView detectou que o arquivo GEDCOM que você está importando não possui <b>0&nbsp;HEAD</b> como primeira linha. Ao clicar no botão Limpar, todas as linhas antes da primeira linha <b>0&nbsp;HEAD</b> serão removidas.<br /><br />Este erro geralmente significa que o programa que você usou para criar seu GEDCOM não o criou corretamente ou não é um arquivo GEDCOM. Você deve verificar se carregou o arquivo correto e se ele começa com a linha <b>0&nbsp;HEAD</b> e termina com a linha <b>0&nbsp;TRLR</b>.";
$pgv_lang["macfile_detected_help"]				= "~ARQUIVO MACINTOSH DETECTADO~<br /><br />PhpGedView detectou que seu arquivo GEDCOM foi criado em um computador Macintosh.<ul><li>Arquivos Macintosh terminam cada linha com um código de controle CR. CR é Ctrl+M.</li><li>Arquivos Unix terminam cada linha com um código de controle LF. LF é Ctrl+J.</li><li>Windows e DOS usam uma sequência de dois códigos, CR seguido por LF.</li></ul>PhpGedView requer que todos os arquivos usem terminações de linha Unix ou DOS. Quando você clica no botão Limpar, os finais de linha são convertidos de acordo.";
$pgv_lang["cleanup_places_help"]				= "~LIMPAR LOCAIS~<br /><br />PhpGedView detectou que seu arquivo GEDCOM usa lugares nas tags GEDCOM que não deveriam ter lugares.<br /><br />Muitos programas de genealogia, como Family Tree Maker, irão criar este tipo de arquivo GEDCOM. PhpGedView funcionará com esses arquivos GEDCOM, mas alguns lugares inválidos aparecerão em sua hierarquia de locais.<br /><br />Por exemplo, seu GEDCOM pode ter a seguinte codificação<div style=\"padding-left: 30px;\">1 SSN<br />2 PLAC 123-45-6789<br />1 OCCU<br />2 PLAC Programador de Computador</div><br />De acordo com o Padrão GEDCOM 5.5.1 isto deveria realmente ser mostrado como<div style=\"padding-left: 30px;\">1 SSN 123-45-6789<br />1 OCCU Programador de Computador</div><br />Se você selecionar <b>Sim</b>, PhpGedView irá corrigir automaticamente estes erros de codificação.";
$pgv_lang["empty_lines_detected_help"]			= "~LINHAS VAZIAS ENCONTRADAS~<br /><br />PhpGedView encontrou linhas vazias no arquivo de entrada. Estas linhas podem causar êrros e serão removidas do arquivo antes de importa-lo.";

//-- Edit Config
$pgv_lang["help_editconfig.php"]				= "~CONFIGURAR PhpGedView~<br /><br />Nesta página você define as configurações globais para PhpGedView. Você tem que fazer isso após instalar o PhpGedView e executá-lo pela primeira vez.<br /><br />#pgv_lang[review_readme]#<br /><br />Essas configurações são <b>globais</b>; eles são para todo o programa e para todos os bancos de dados genealógicos que você usa com PhpGedView.<br /><br />Cada banco de dados genealógico também tem opções de configuração adicionais que você define após clicar no link <b>#pgv_lang[admin_gedcoms]#</b> nesta página.<br /><br />Você também pode acessar a função #pgv_lang[gedcom_adm_head]# na página principal do Admin, cujo link se encontra sob o ícone #pgv_lang[mgv]# ou no cabeçalho da maioria das páginas. Na página Admin, o link relevante é denominado <b>#pgv_lang[manage_gedcoms]#</b>.";

//-- merge records
$pgv_lang["help_edit_merge.php"]				= "~#pgv_lang[merge_records]#~<br /><br />Esta página permitirá que você mescle dois registros GEDCOM do mesmo arquivo GEDCOM.<br /><br />Isso é útil para pessoas que mesclaram GEDCOMs e agora têm muitas pessoas, famílias e fontes que são iguais.<br /><br />A página consiste em três etapas.<br /><ol><li>Você insere dois IDs GEDCOM. Os IDs <u>devem</u> ser do mesmo tipo. Você não pode fundir uma pessoa e uma família ou família e fonte, por exemplo.<br />No campo <b>#pgv_lang[merge_to]#</b> insira o ID do registro que você deseja que seja o novo registro após a fusão ser concluída.<br />No <b>#pgv_lang[merge_from]#</b campo insira o ID do registro cujas informações serão mescladas no registro #pgv_lang[merge_to]#. Este registro será excluído após a fusão.</li><li>Você seleciona quais fatos deseja manter dos dois registros quando eles são mesclados. Basta clicar nas caixas de seleção ao lado das que deseja manter.</li><li>Você inspeciona os resultados da mesclagem, assim como com todas as outras alterações feitas online.</li></ol>Alguém com direitos Aceitar terá que autorizar suas alterações para torná-las permanentes.";

//-- report engine
$pgv_lang["help_reportengine.php"]				= "~#pgv_lang[reports]#~<br /><br />Os itens no menu de relatórios irão gerar arquivos PDF para impressão.<br /><br />O primeiro passo é escolher um relatório a ser executado. Depois de selecionar um relatório a ser executado, você será solicitado a fornecer algumas informações específicas a esse relatório, como com que pessoa ou família começar e se deve ou não mostrar fotos. Quando estiver pronto para executar o relatório, clique no botão <b>#pgv_lang[download_report]#</b> para baixar o relatório para o seu computador.<br /><br /><br />#pgv_lang[help_xml_reports]#<br />#pgv_lang[def_pdf_format_help]#<br />#pgv_lang[help_ahnentafel.xml]#<br />#pgv_lang[help_birthlist.xml]#<br />#pgv_lang[help_relativelist.xml]#";
$pgv_lang["def_pdf_format_help"]				= "~FORMATO DE ARQUIVO PDF~<br /><br />O PhpGedView Reporting Engine produz relatórios para download em Adobe&reg; Formato PDF. A especificação padrão GEDCOM 5.5.1, mencionada em outras partes deste arquivo de Ajuda, também pode ser baixada como um arquivo PDF. PDF é um acrônimo para <b>P</b>ortable <b>D</b>ocument <b>F</b>ormat (Português: formato de documento portátil).";
$pgv_lang["help_ahnentafel.xml"]				= "~#pgv_lang[ahnentafel_report]#~<br /><br />Este é um relatório da pessoa selecionada e seus ancestrais, impresso em formato de livreto. Começa com a primeira pessoa e depois continua com seus pais, avós, etc.<br /><br />Observe que o relatório ahnentafel está disponível apenas em inglês no momento.";
$pgv_lang["help_birthlist.xml"]					= "~#pgv_lang[birth_report]#~<br /><br />Este relatório lista as pessoas nascidas a uma certa hora ou lugar.";
$pgv_lang["help_relativelist.xml"]				= "~#pgv_lang[relatives_report]#~<br /><br />Este relatório listará todos os parentes da pessoa selecionada. Você pode escolher quais parentes da pessoa mostrar no relatório.<ul><li><b>#pgv_lang[child-family]#</b>&nbsp;&nbsp;&nbsp;mostrará a pessoa selecionada, seus pais e seus irmãos e irmãs.</li><li><b>#pgv_lang[spouse-family]#</b>&nbsp;&nbsp;&nbsp;irá relacionar a pessoa com seus cônjuges e filhos.</li><li><b>#pgv_lang[direct-ancestors]#</b>&nbsp;&nbsp;&nbsp;irá listar a pessoa, seus pais, avós, bisavós e continuar subindo a árvore listando todas as pessoas que são pais na linhagem da pessoa.</li><li><b>#pgv_lang[ancestors]#</b>&nbsp;&nbsp;&nbsp;listará todas as pessoas da lista AAA, mas também incluirá tias e tios e tias-avós e, portanto, incluirá os irmãos de todos os antepassados na árvore genealógica dessa pessoa. Não listará os filhos dos irmãos (primos).</li><li><b>#pgv_lang[descendants]#</b>&nbsp;&nbsp;&nbsp;irá listar todos os descendentes dessa pessoa (filhos, netos, bisnetos, etc.)</li><li><b>#pgv_lang[all]#</b>&nbsp;&nbsp;&nbsp;esta opção é uma combinação do #pgv_lang[descendants]# e do #pgv_lang[ancestors]# em um único relatório.</li></ul>";
$pgv_lang["help_xml_reports"]					= "~Motor de relatórios~<br /><br />O motor de relatório PhpGedView usa arquivos de modelo XML para gerar relatórios PDF automaticamente.<br /><br />Os relatórios disponíveis na lista AAA são gerados a partir dos arquivos XML de relatório encontrados no diretório \"reports\". Você pode criar seus próprios relatórios fazendo uma cópia de qualquer um dos modelos fornecidos e modificando o XML do modelo. Para adicionar seu relatório personalizado, basta colocá-lo no diretório \"reports\" e o PhpGedView irá detectá-lo automaticamente e disponibilizá-lo na lista.";

//-- Help Contents
$pgv_lang["help_contents_head_help"]			= "<b>CONTEÚDO DA AJUDA</b>";
$pgv_lang["help_contents_gedcom_info"]			= "Informação do GEDCOM";
$pgv_lang["help_contents_gedcom_places"]		= "Locais do GEDCOM";

//-- Admin Help Contents Items
$pgv_lang["admin_help_contents_head_help"]		= "<b>CONTEÚDO DA AJUDA<br /><br />ITENS DE AJUDA PARA  ADMINISTRATORES</b> adicionados ao ínicio da lista.";
// $pgv_lang["ah1_help"]						= "_Upgrade";
$pgv_lang["ah2_help"]							= "_Configure o PhpGedView";
$pgv_lang["ah3_help"]							= "_GEDCOM: Adição vs Envio (upload)";
$pgv_lang["ah4_help"]							= "_GEDCOM: arquivo de Configuração";
$pgv_lang["ah5_help"]							= "_GEDCOM: Padrão";
$pgv_lang["ah6_help"]							= "_GEDCOM: Excluir";
$pgv_lang["ah7_help"]							= "_GEDCOM: Adicionar";
$pgv_lang["ah8_help"]							= "_GEDCOM: Criar Novo";
$pgv_lang["ah9_help"]							= "_GEDCOM: Descarregar (download)";
$pgv_lang["ah10_help"]							= "_GEDCOM: Página de Administração";
$pgv_lang["ah11_help"]							= "_GEDCOM: Configure";
$pgv_lang["ah12_help"]							= "_GEDCOM: Importar";
$pgv_lang["ah13_help"]							= "_GEDCOM: Carregar";
$pgv_lang["ah14_help"]							= "_GEDCOM: Validar";
$pgv_lang["ah15_help"]							= "_GEDCOM: Converter ANSI em UTF-8";
$pgv_lang["ah16_help"]							= "_GEDCOM: Configurações de privacidade";
$pgv_lang["ah17_help"]							= "_Administração do usuários";
$pgv_lang["ah18_help"]							= "_Administração";
$pgv_lang["ah19_help"]							= "_GEDCOM: Ferramenta de mídia";
$pgv_lang["ah20_help"]							= "_GEDCOM: Alterar ID da pessoa para ...";
$pgv_lang["ah21_help"]							= "_Ferramentas de tradução";
//           22 is in the help_text_vars.php
$pgv_lang["ah23_help"]							= "_Configure os idiomas suportados";
$pgv_lang["ah24_help"]							= "_Migração de informações do usuário (Index --&gt;&gt; SQL)";
$pgv_lang["ah25_help"]							= "_Backup PhpGedView";
$pgv_lang["ah26_help"]							= "_Lista de FAQ: Editar";

//--Statistics Help
$pgv_lang["help_statisticsplot.php"] 			= "~Gráfico estatístico~<br /><br />Esta é a página de resultados, mostrando o gráfico das estatísticas de seu banco de dados, conforme definido pelas entradas na página anterior.";
$pgv_lang["help_statistics.php"] 				= "~Gráfico estatístico~<br /><br />Esta página permite determinar os critérios para produzir uma exibição gráfica de várias estatísticas de seu banco de dados.";
$pgv_lang["stat_help"]							= "~OPÇÕES PARA GRÁFICOS ESTATÍSTICOS~<br /><br />Vários gráficos diferentes de estatísticas de seu banco de dados podem ser produzidos.<br /><br />Selecione o gráfico e, em seguida, ajuste as opções nas caixas.<br /><br />Os números incluídos em cada gráfico dependem de os dados disponíveis. Por exemplo, indivíduos sem um mês de nascimento (por exemplo, apenas '1856') não podem ser incluídos em um gráfico de nascimentos por mês.";
$pgv_lang["stat_help_x"]						= "~OPÇÕES PARA GRÁFICOS ESTATÍSTICOS~<br />~EIXO X~<br /><br />As seguintes opções estão disponíveis para o eixo X (horizontal). Cada um será então apresentado de acordo com as opções definidas para os eixos Y e Z.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_11_mb]#</b>&nbsp;&nbsp;&nbsp;pessoas nascidas em cada mês.<br /><b>#pgv_lang[stat_12_md]#</b>&nbsp;&nbsp;&nbsp;pessoas que morreram em cada mês.<br /><b>#pgv_lang[stat_13_mm]#</b>&nbsp;&nbsp;&nbsp;casamentos que ocorreram em cada mês.<br /><b>#pgv_lang[stat_14_mb1]#</b>&nbsp;&nbsp;&nbsp;o número de primogênitos para cada família por mês.<br /><b>#pgv_lang[stat_15_mm1]#</b>&nbsp;&nbsp;&nbsp;o número de primeiros casamentos por mês.<br /><b>#pgv_lang[stat_16_mmb]#</b>&nbsp;&nbsp;&nbsp;o número de meses entre o casamento e o nascimento do primeiro filho desse casal.<br /><b>#pgv_lang[stat_17_arb]#</b>&nbsp;&nbsp;&nbsp;amorte, relacionado ao período de tempo que inclui o ano de nascimento de cada pessoa.<br /><b>#pgv_lang[stat_18_ard]#</b>&nbsp;&nbsp;&nbsp;idade na morte, relacionada ao período de tempo que inclui o ano da morte de cada pessoa.<br /><b>#pgv_lang[stat_19_arm]#</b>&nbsp;&nbsp;&nbsp;idade média das pessoas no momento de seus casamentos<br /><b>#pgv_lang[stat_20_arm1]#</b>&nbsp;&nbsp;&nbsp;idade média das pessoas no momento do primeiro casamento.<br /><b>#pgv_lang[stat_21_nok]#</b>&nbsp;&nbsp;&nbsp;tamanhos médios de família.<br /><b>#pgv_lang[stat_1_map]#</b>&nbsp;&nbsp;&nbsp;localização de todas as pessoas ou pessoas com o nome especificado, por país.<br /><b>#pgv_lang[stat_2_map]#</b>&nbsp;&nbsp;&nbsp;país de nascimento.<br /><b>#pgv_lang[stat_4_map]#</b>&nbsp;&nbsp;&nbsp;país de casamento.<br /><b>#pgv_lang[stat_3_map]#</b>&nbsp;&nbsp;&nbsp;país da morte.<br /><b>#pgv_lang[stat_9_indi]#</b>&nbsp;&nbsp;&nbsp;diagrama de círculo de indivíduos com fontes.<br /><b>#pgv_lang[stat_8_fam]#</b>&nbsp;&nbsp;&nbsp;diagrama de círculo de famílias com fontes.</p>";
$pgv_lang["stat_help_y"]						= "~OPÇÕES PARA GRÁFICOS ESTATÍSTICOS~<br />~EIXO Y~<br /><br />As seguintes opções estão disponíveis para o eixo Y (vertical). Essas opções alteram a forma como os itens apresentados no eixo X são exibidos.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_201_num]#</b>&nbsp;&nbsp;&nbsp;exibe o número de pessoas em cada categoria definida pelo eixo X.<br /><b>#pgv_lang[stat_202_perc]#</b>&nbsp;&nbsp;&nbsp;calcula e exibe a proporção de cada item nas categorias do eixo X.</p>";
$pgv_lang["stat_help_z"]						= "~OPÇÕES PARA GRÁFICOS ESTATÍSTICOS~<br />~EIXO Z~<br /><br />As seguintes opções estão disponíveis para o eixo Z. Essas opções fornecem uma subdivisão das categorias selecionadas para o eixo X.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_300_none]#</b>&nbsp;&nbsp;&nbsp;exibe os itens como uma única coluna para cada categoria do eixo X.<br /><b>#pgv_lang[stat_301_mf]#</b>&nbsp;&nbsp;&nbsp;exibe os itens em 2 colunas (masculino e feminino) para cada categoria do eixo X.<br /><b>#pgv_lang[stat_302_cgp]#</b>&nbsp;&nbsp;&nbsp;exibe os itens em várias colunas relacionadas aos períodos de tempo definidos na próxima seção, para cada categoria do eixo X.</p>";
$pgv_lang["stat_help_gwx"]						= "~OPÇÕES PARA GRÁFICOS ESTATÍSTICOS~<br />~limites para o eixo X~<br /><br />Selecione o intervalo de idade desejado.<br /><br />Por exemplo, <b>#pgv_lang[aft_marr]#</b> descreve o seguinte conjunto de intervalos de meses:<div style=\"padding-left: 30px;\">antes do casamento<br />desde o casamento até 8 meses depois<br />de 8 a 12<br />de 12 a 15<br />de 15 a 18<br />de 18 a 24<br />de 24 a 48<br />mais de 48 meses após o casamento</div><br />Quando você deseja mostrar os trimestres, você deve escolher <b>#pgv_lang[quarters]#</b>.";
$pgv_lang["stat_help_gax"]						= "~OPÇÕES PARA GRÁFICOS ESTATÍSTICOS~<br />~limites para o eixo X~<br /><br />Selecione o intervalo de idade desejado.<br /><br />Por exemplo, <b>intervalo de 10 anos</b> descreve o seguinte conjunto de faixas etárias:<div style=\"padding-left: 30px;\">menor de um ano<br />um ano a 5 anos<br />6 a 10<br />11 a 20<br />21 a 30<br />31 a 40<br />41 a 50<br />51 a 60<br />61 a 70<br />71 a 80<br />81 a 90<br />91 a 100<br />mais de 100 anos</div>";
$pgv_lang["stat_help_gbx"]						= "~OPÇÕES PARA GRÁFICOS ESTATÍSTICOS~<br />~limites para o eixo X~<br /><br />Selecione o intervalo de idade desejado.<br /><br />Por exemplo, <b>intervalo de 2 anos</b> descreve o seguinte conjunto de faixas etárias:<div style=\"padding-left: 30px;\">menor de 16 anos<br />16 a 18<br />19 a 20<br />21 a 22<br />23 a 24<br />25 a 26<br />27 a 28<br />29 a 30<br />31 a 32<br />33 a 35<br />36 a 40<br />41 a 50<br />mais de 50 anos</div>";
$pgv_lang["stat_help_gcx"]						= "~OPÇÕES PARA GRÁFICOS ESTATÍSTICOS~<br />~limites para o eixo X~<br /><br />Selecione o intervalo de contagem desejado.<br /><br />Por exemplo, <b>intervalo um filho</b> descreve o seguinte conjunto de intervalos de contagem de filhos:<div style=\"padding-left: 30px;\">sem filhos<br />um filho<br />dois filhos<br />3, 4, 5, 6, 7, 8, 9, 10 filhos<br />mais de 10 filhos</div>";
$pgv_lang["stat_help_gwz"]						= "~OPÇÕES PARA GRÁFICOS ESTATÍSTICOS~<br />~limites para o eixo Z~<br /><br />Selecione o ano de início desejado e o intervalo<br /><br />Por exemplo, <b>de 1700 intervalo 50 anos</b> descreve o seguinte conjunto de intervalos de datas:<div style=\"padding-left: 30px;\">antes de 1700<br />1700 a 1749<br />1750 a 1799<br />1800 a 1849<br />1850 a 1899<br />1900 a 1949<br />1950 a 1999<br />2000 ou mais tarde</div>";
$pgv_lang["chart_type_help"]					= "~OPÇÕES PARA GRÁFICOS ESTATÍSTICOS~<br /><br />Selecione o que você deseja ver no mapa. Você pode escolher:<div style=\"padding-left: 25px\"><b>#pgv_lang[indi_distribution_chart]#</b>&nbsp;&nbsp;&nbsp;mostra os países em que ocorrem as pessoas desta base de dados.<br /><b>#pgv_lang[surname_distribution_chart]#</b>&nbsp;&nbsp;&nbsp;mostra os países nos quais o sobrenome especificado ocorre.</div>";
$pgv_lang["google_chart_surname_help"]			= "~OPÇÕES PARA GRÁFICOS ESTATÍSTICOS~<br /><br />O número de ocorrências do nome especificado será mostrado no mapa. Se você deixar este campo em branco, o sobrenome mais comum será usado.";
$pgv_lang["chart_area_help"]					= "~OPÇÕES PARA GRÁFICOS ESTATÍSTICOS~<br /><br />Selecione a área geográfica que você deseja ver no mapa. Você pode escolher:<div style=\"padding-left: 25px\"><b>#pgv_lang[world_chart]#</b>&nbsp;&nbsp;&nbsp;mostra todos os continentes.<br /><b>#pgv_lang[europe_chart]#</b>&nbsp;&nbsp;&nbsp;mostra a Europa.<br /><b>#pgv_lang[s_america_chart]#</b>&nbsp;&nbsp;&nbsp;mostra a América do Sul.<br /><b>#pgv_lang[asia_chart]#</b>&nbsp;&nbsp;&nbsp;mostra a Ásia.<br /><b>#pgv_lang[middle_east_chart]#</b>&nbsp;&nbsp;&nbsp;mostra o Oriente Médio.<br /><b>#pgv_lang[africa_chart]#</b>&nbsp;&nbsp;&nbsp;mostra a África.</div>";

//-- Find Media Help
$pgv_lang["manage_media_help"]					= "~#pgv_lang[manage_media]#~<br /><br />Nesta página você pode gerenciar facilmente seus arquivos e diretórios de mídia.<br /><br />Quando você cria novos subdiretórios de mídia, PhpGedView irá garantir que a estrutura de diretório idêntica seja mantida dentro do diretório <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs</b>. Quando você carrega novos arquivos de mídia, PhpGedView pode criar automaticamente as miniaturas para você.<br /><br />Ao lado de cada imagem na lista de mídia, você encontrará as seguintes opções. As opções realmente mostradas dependem do status atual do arquivo de mídia.<ul><li><b>#pgv_lang[edit]#</b>&nbsp;&nbsp;&nbsp;Ao clicar nesta opção, você verá uma página onde pode alterar o título do objeto Mídia. Se o objeto Mídia ainda não estiver vinculado a uma pessoa, família ou fonte no banco de dados ativo no momento, você pode estabelecer esse vínculo aqui. Você pode renomear o arquivo ou até mesmo alterar sua localização na estrutura de diretório <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Quando necessário, PhpGedView criará automaticamente os subdiretórios necessários ou quaisquer miniaturas ausentes.</li><li><b>#pgv_lang[edit_raw]#</b>&nbsp;&nbsp;&nbsp;Esta opção está disponível apenas quando o administrador a habilita. Você pode visualizar ou editar os dados GEDCOM brutos associados a este objeto Mídia. Você deve ter muito cuidado ao usar esta opção.</li><li><b>#pgv_lang[delete_file]#</b>&nbsp;&nbsp;&nbsp;Esta opção permite que você apague todo o conhecimento do arquivo de mídia do banco de dados atual. Outros bancos de dados não serão afetados. Se este arquivo de mídia não for mencionado em nenhum outro banco de dados, ele e sua miniatura associada serão excluídos.</li><li><b>#pgv_lang[remove_object]#</b>&nbsp;&nbsp;&nbsp;Esta opção permite que você apague todo o conhecimento do arquivo de mídia do banco de dados atual. Outros bancos de dados não serão afetados. O arquivo de mídia e sua miniatura associada não serão excluídos.</li><li><b>#pgv_lang[remove_links]#</b>&nbsp;&nbsp;&nbsp;Esta opção permite remover todos os links para o objeto de mídia do banco de dados atual. O arquivo não será excluído e o objeto Mídia pelo qual este arquivo é conhecido no banco de dados atual será retido. Outros bancos de dados não serão afetados.</li><li><b>#pgv_lang[set_link]#</b>&nbsp;&nbsp;&nbsp;Esta opção permite estabelecer ligações entre o arquivo de mídia e pessoas, famílias ou fontes do banco de dados atual. Quando necessário, o PhpGedView também criará o objeto Media pelo qual o arquivo Media é conhecido no banco de dados.</li><li><b>#pgv_lang[gen_thumb]#</b>&nbsp;&nbsp;&nbsp;Ao selecionar esta opção, PhpGedView criará a miniatura ausente.</li></ul>";
$pgv_lang["simple_filter_help"]					= "~#pgv_lang[filter]#~<br /><br />Filtro de pesquisa simples, baseado nos caracteres informados, onde curingas não são aceitos.";
$pgv_lang["show_thumb_help"]					= "~#pgv_lang[show_thumbnail]#~<br /><br />Marque esta opção para exibir as Miniaturas.";
$pgv_lang["find_media_help"]					= "~#pgv_lang[find_media]#~<br /><br />Isso permite que você pesquise a estrutura do arquivo para encontrar o item de mídia ao qual deseja vincular.";

//-- Add / Edit Media Help
$pgv_lang["add_media_linkid"]					= "~Link para o ID~<br /><br />Cada item de mídia deve estar associado a uma ou mais pessoas, família ou registros de origem em seu banco de dados.<br /><br /> Para estabelecer esse link, você pode inserir ou pesquisar a identidade da pessoa, família ou ao mesmo tempo em que cria o item de mídia. Você também pode estabelecer o link posteriormente por meio das opções de edição na página Gerenciar Multimídia ou adicionando itens de mídia por meio do link Adicionar Mídia disponível na página de detalhes da Pessoa, Família ou Fonte.";
$pgv_lang["upload_server_file_help"] 			= "~#pgv_lang[server_file]#~<br /><br />O arquivo de mídia que você está enviando pode ter, e provavelmente deveria ser, nomeado de maneira diferente no servidor e no computador local. Isso ocorre porque geralmente o nome do arquivo local tem significado para você, mas é muito menos significativo para outras pessoas que visitam este site. Considere também a possibilidade de que você e outra pessoa tentem enviar arquivos diferentes chamados \"avozinha.jpg\".<br /><br />Neste campo, você especifica o novo nome do arquivo que está enviando. O nome que você inserir aqui também será usado para nomear a miniatura, que pode ser carregada separadamente ou gerada automaticamente. Você não precisa inserir a extensão do nome do arquivo (jpg, gif, pdf, doc, etc.)<br /><br />Deixe este campo em branco para manter o nome original do arquivo que você carregou de seu computador local.";
$pgv_lang["upload_server_folder_help"] 			= "~#pgv_lang[server_folder]#~<br /><br />O administrador habilitou até #GLOBALS[MEDIA_DIRECTORY_LEVELS]# níveis de pasta abaixo do padrão <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Isso ajuda a organizar os arquivos de mídia e reduz a possibilidade de colisões de nomes.<br /><br />Neste campo, você especifica a pasta de destino onde o arquivo de mídia carregado deve ser armazenado. O arquivo de miniatura correspondente, carregado separadamente ou gerado automaticamente, será armazenado em uma estrutura de pasta semelhante começando em <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> em vez de <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Você não precisa inserir a parte <b>#GLOBALS[MEDIA_DIRECTORY]#</b> do nome da pasta de destino.<br /><br />Se você não tiver certeza sobre o que inserir aqui, entre em contato com o administrador do site para obter orientação.";
$pgv_lang["view_server_folder_help"] 			= "~#pgv_lang[server_folder]#~<br /><br />O administrador habilitou até #GLOBALS[MEDIA_DIRECTORY_LEVELS]# níveis de pasta abaixo do padrão <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Isso ajuda a organizar os arquivos de mídia e reduz a possibilidade de colisões de nomes.<br /><br /> Neste campo, você seleciona a pasta de mídia cujo conteúdo deseja visualizar. Quando você seleciona <b>#pgv_lang[all]#</b>, todos os arquivos de mídia são exibidos independentemente da pasta na qual estão armazenados. Isso pode produzir uma lista muito longa de itens de mídia.";

//--Repository Help
$pgv_lang["help_repolist.php"]					= "~#pgv_lang[repo_list]#~<br /><br />Uma lista de repositórios é exibida nesta página.<br /><br />Os nomes dos repositórios são classificados em ordem alfabética.<br /><br /><b>REPOSITÓRIOS</b><br />Sem repositórios, não podemos construir nosso banco de dados. Existe uma fonte para todas as informações armazenadas no banco de dados, e essa fonte é mantida em um repositório. Os repositórios podem ser o arquivo pessoal de uma pessoa, uma instituição, um banco de dados público, um escritório de registros do governo ou da igreja, um recurso da Internet, etc. Para obter acesso a uma fonte, queremos saber onde e em que lugar ela está. Todas as informações necessárias para encontrar uma fonte devem ser armazenadas no registro do Repositório.<br /><br />Um repositório pode ser vinculado a várias fontes.";
$pgv_lang["help_repo.php"]						= "~#pgv_lang[repo_info]#~<br /><br />Os detalhes do Repositório são exibidos aqui. Junto com as fontes, os repositórios são muito importantes para os pesquisadores genealógicos. Com informações precisas de origem e repositório, você pode seguir a trilha que outro pesquisador usou para encontrar as informações. Você deve conseguir encontrar as mesmas informações novamente.<br /><br />Nesta página você pode ver informações sobre o título do Repositório, endereço, e-mail e página da web.<br /><br />Após os detalhes do repositório, será uma lista de todas as fontes que estão vinculadas a este repositório. Isso permite que você veja todas as informações obtidas de um repositório específico.<br /><br />Se habilitado pelo administrador do site, você terá um ou mais dois ícones de menu nesta página:<ul><li><b>#pgv_lang[view_gedcom]#</b>, que mostra as informações em formato GEDCOM.</li><li><b>#pgv_lang[add_to_cart]#</b>, que permite que você armazene essas informações em seu #pgv_lang[clip_cart]#. De lá, você pode baixar as informações em formato de arquivo GEDCOM e importá-las para seu próprio programa de genealogia.</li></ul><br />#pgv_lang[context_help]#";
$pgv_lang["delete_repo_help"]					= "~#pgv_lang[delete_repo]#~<br /><br />Ao clicar nesta opção, você marca este Repositório para ser excluído do banco de dados.<br /><br />O que isso significa? Vamos supor que você tenha um bom motivo para remover este Repositório do banco de dados. Você clica no link. Você será solicitado a confirmar sua solicitação de exclusão. Ao continuar com sua visita, você notará que o Repositório ainda está visível e pode ser usado como se a exclusão não tivesse ocorrido.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["show_repo_gedcom_help"]				= "~#pgv_lang[view_gedcom]#~<br /><br />Ao clicar neste link, as informações sobre o repositório, da forma como está armazenado no banco de dados, serão exibidas em uma janela.";
$pgv_lang["add_repository_clip_help"]			= "~#pgv_lang[add_to_cart]#~<br /><br />Ao clicar neste link, você pode adicionar o repositório, como está armazenado no banco de dados, ao seu #pgv_lang[clip_cart]#.";
$pgv_lang["repolist_listbox_help"]				= "~#pgv_lang[repo_list]#~<br /><br />Nesta caixa você vê os nomes dos repositórios como eles são armazenados no banco de dados. Os nomes são exibidos em ordem alfabética.<br /><br />Ao clicar em um nome no lista, você irá para a página #pgv_lang[repo_info]#, onde verá uma lista das fontes que estão vinculadas a esse repositório.";
$pgv_lang["repos_listbox_help"]					= "~#pgv_lang[other_repo_records]#~<br /><br />Nesta caixa você vê os nomes das fontes que estão vinculadas ao repositório. Os nomes são exibidos em ordem alfabética.<br /><br />Ao clicar em um nome na lista, você irá para a página Detalhes dessa fonte.";

// Index-Edit
$pgv_lang["block_move_up_help"]					= "~Mover entradas da lista~<br /><br />Use esses botões para reorganizar a ordem das entradas na lista. Os blocos serão impressos na ordem em que estão listados.<br /><br />Destaque a entrada a ser movida e clique em um botão para mover essa entrada para cima ou para baixo.";
$pgv_lang["block_move_right_help"]				= "~Mover entradas da lista~<br /><br />Use estes botões para mover uma entrada de uma lista para outra.<br /><br />Destaque a entrada a ser movida e, a seguir, clique em um botão para mover ou copiar essa entrada na direção da seta. Use os botões <b>»</b> e <b>«</b> para mover a entrada destacada da lista mais à esquerda para a mais à direita ou vice-versa. Use os botões <b>&gt;</b> e <b>&lt;</b> para mover a entrada destacada entre a lista #pgv_lang[available_blocks]# e a lista para a direita ou esquerda.<br /><br />As entradas na lista #pgv_lang[available_blocks]# não muda, independentemente do que você faz com os botões #pgv_lang[move_right]# e #pgv_lang[move_left]#. Isso porque o mesmo bloco pode aparecer várias vezes na mesma página. O bloco HTML é um bom exemplo de por que você pode querer fazer isso.";
$pgv_lang["block_default_index"]				= "~Blocos padrão na página #pgv_lang[welcome]#~<br /><br />Quando você remove todas as entradas das listas #pgv_lang[main_section]# e #pgv_lang[right_section]#, ou quando você clica no botão <b>#pgv_lang[reset_default_blocks]#</b>, a lista de bloqueios será configurada da seguinte forma:<br /><br /><span class='center'><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[block_cookiepolicy]#<br />#pgv_lang[gedcom_stats_block]#<br />#pgv_lang[gedcom_news_block]#<br />#pgv_lang[gedcom_favorites_block]#<br />#pgv_lang[review_changes_block]#</td><td>#pgv_lang[gedcom_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[todays_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></span>";
$pgv_lang["block_default_portal"]				= "~Blocos padrão na página #pgv_lang[mygedview]#~<br /><br />Quando você remove todas as entradas das listas #pgv_lang[main_section]# e #pgv_lang[right_section]#, ou quando você clica no botão <b>#pgv_lang[reset_default_blocks]#</b>, a lista de bloqueios será configurada da seguinte forma:<br /><br /><span class='center'><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[todays_events_block]#<br />#pgv_lang[user_messages_block]#<br />#pgv_lang[user_favorites_block]#<br />&nbsp;</td><td>#pgv_lang[welcome_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[upcoming_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></span>";

// FAQ page
$pgv_lang["help_faq.php"]						= "~Perguntas mais Frequentes~<br /><br />#pgv_lang[text_faq_help]#";
$pgv_lang["text_faq_help"]						= "A página de FAQs (Perguntas mais frequentes), contém uma lista de perguntas e respostas sobre o uso deste site genealógico.<br /><br />O Administrador do site é responsável pelo conteúdo e ordenação desta lista.";

// Help search
$pgv_lang["hs_title_help"]						= "<span class='center'>~#pgv_lang[hs_title]#~</span><br />#pgv_lang[hs_intro]#<br /><br />#pgv_lang[hs_keyword_advice]#<br /><br />#pgv_lang[hs_searchhow_advice]#<br /><br />#pgv_lang[hs_searchin_advice]#";
$pgv_lang["hs_intro"]							= "É possível pesquisar a Ajuda do PhpGedView. O recurso #pgv_lang[hs_title]# proporciona um alto grau de controle sobre a forma a pesquisa funciona; você deveria ser capaz de encontrar o que procura facilmente.";
$pgv_lang["hs_keyword_advice"] 					= "~#pgv_lang[hs_keyword]#~<br /><br />Você digita as palavras ou a frase que deseja encontrar.<br /><br />A pesquisa não se preocupa com a capitalização (superior ou inferior) dos termos de pesquisa ou do texto examinado. Isso significa que se você pesquisar <b>Pessoa</b>, encontrará um texto contendo <b>Pessoa</b>, <b>pessoa</b> ou <b>PESSOA</b>. Você também encontrará texto contendo <b>pessoas</b>, etc., uma vez que a pesquisa está procurando sequências de caracteres em vez de palavras.<br /><br />Você pode fazer com que a pesquisa procure várias palavras de uma vez. Digite todas as palavras, separando cada uma delas por um espaço, assim: <b>pessoa&nbsp;família&nbsp;criança</b>. Quando mais de uma palavra é inserida, o significado do que você digitou é esclarecido no campo #pgv_lang[hs_searchhow]#.";
$pgv_lang["hs_searchin_advice"]					= "~#pgv_lang[hs_searchin]#~<br /><br />Você determina o escopo da pesquisa aqui.<br /><br />Os administradores têm a opção de pesquisar a Ajuda do usuário ou a Ajuda de configuração ou ambas. Os usuários não têm essa escolha; porque eles não têm acesso a nenhum recurso de configuração, eles só podem pesquisar o arquivo de Ajuda do usuário.<br /><br />Os arquivos de Ajuda contêm não apenas texto de Ajuda, mas também certas sequências de texto usadas para construir formulários de entrada e outros materiais. Essa opção permite controlar se todo o arquivo de Ajuda deve ser examinado ou se apenas o texto da Ajuda deve ser examinado.";
$pgv_lang["hs_searchhow_advice"]				= "~#pgv_lang[hs_searchhow]#~<br /><br />Você esclarece o significado do que você inseriu no campo AAA selecionando entre as possibilidades apresentadas aqui.<br /><dl><dt><b>#pgv_lang[hs_searchany]#</b></dt><dd>Se você inseriu <b>pessoa&nbsp;família&nbsp;criança</b>, esta opção encontrará o texto de ajuda que contém uma das palavras listadas. A ordem das palavras não importa. O significado da pesquisa é: \"Encontrar texto de ajuda contendo as palavras <b>pessoa</b> <u>ou</u> <b>família</b> <u>ou</u> <b>criança</b>\".</dd><dt><b>#pgv_lang[hs_searchall]#</b></dt><dd>Se você inseriu <b>pessoa&nbsp;família&nbsp;criança</b>, esta opção encontrará o texto de Ajuda que contém todas as palavras listadas. A ordem das palavras não importa. O significado da pesquisa é: \"Encontrar texto de ajuda contendo as palavras <b>pessoa</b> <u>e</u> <b>família</b> <u>e</u> <b>criança</b>\".</dd><dt><b>#pgv_lang[hs_searchsentence]#</b></dt><dd>Se você inseriu <b>pessoa&nbsp;família&nbsp;criança</b>, esta opção encontrará o texto de Ajuda que contém todas as palavras listadas na ordem fornecida. O significado da pesquisa é: \"Encontrar texto de ajuda contendo as palavras <b>pessoa&nbsp;família&nbsp;criança</b> exatamente nessa ordem, sem outras palavras ou caracteres entre elas\".Você provavelmente não encontrará esta frase em particular em nenhum texto de Ajuda.<br /><br />Existem algumas limitações neste tipo de pesquisa. Certos caracteres especiais, como <b>&quot; &lt; &gt;</b> etc. estão contidos no texto da Ajuda em forma simbólica e não serão encontrados se fizerem parte do texto inserido. Alguns textos da Ajuda contêm um tipo especial de caractere de espaço representado por <b>&amp;nbsp;</b> e você não encontrará frases com esse caractere.</dd></dl>";

// Directory cleanup tool
$pgv_lang["help_dir_editor.php"]				= "~#pgv_lang[index_dir_cleanup]#~<br /><br />Esta ferramenta pode ajudar os administradores do site a limpar arquivos no diret?rio Index.<br /><br />Com o tempo, arquivos como arquivos de log, arquivos GEDCOM antigos e arquivos de backup antigos podem ser acumulados no diret?rio Index. Como muitos desses arquivos s?o criados pelo programa, eles podem pertencer ao usu?rio do servidor web. Se eles pertencerem ao usu?rio do servidor da web, talvez voc? n?o consiga exclu?-los. Essa ferramenta permite que voc? exclua esses arquivos, mesmo quando eles pertencem ? conta de usu?rio do servidor web.<br /><br />#pgv_lang[index_dir_cleanup_inst]#";

// Various quotes -- The actual text is in help_text.en.php
//$pgv_lang["quote_gedcom"]						= "";
//$pgv_lang["quote_gramps"]						= "";
?>
