<?php
/**
 * Swedish Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2024  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author Patrik Hansson
 * @version $Id: help_text.sv.php 7378 2024-11-02 14:25:09Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["useradmin_comment_help"]	= "~#pgv_lang[comment]#~<br /><br />Texten som anges här kommer att visas när muspekaren svävar på textikonen i användarlistan. Du bör försöka hålla texten så kort som möjligt.";
$pgv_lang["useradmin_comment_exp_help"]	= "~#pgv_lang[comment_exp]#~<br /><br />Ange det datum efter vilket denna användares post ska behandlas som att det krävs inspektion av administratören. Dessa poster markeras i användarlistan genom att användarnamnet visas i <span class='warning'>rött</span>.<br /><br />Datumet måste anges på engelska. Exempel: <b>31&nbsp;DEC&nbsp;2020</b> ; <b>31&nbsp;december&nbsp;2020</b> ; <b>2020.12.31</b> ; <b>31-12-2020</b> ; <b>12/31/2020</b> etc.<br /><br />När månadsnummer och dagnummer ligger inom intervallet 1 till 12, bestämmer skiljetecken (streck eller snedstreck) betydelsen, med en streck <b>-</b> som betyder att det första numret är dagen i månaden, medan en snedstreck <b>/</b> betyder att det första numret är månaden.<br /><br />Om informationen som anges här är meningslös för programmet kommer «yesterday» att användas och den här användaren post kommer alltid att väljas för markering. «tomorrow» och liknande texter är inte meningsfulla i detta sammanhang och kommer att resultera i att denna användarpost aldrig väljs för att markera.";
$pgv_lang["file_type_help"]			= "~#pgv_lang[choose_file_type]#~<br /><br />Välj det format som databasexporten ska skapas i. Ditt val beror på kraven och funktionerna i programmet som du tänker importera den nyligen nedladdade filen till. Du kan välja:<br /><ul><li>#pgv_lang[def_gedcom_help]#</li><br /><br /><li>#pgv_lang[def_gramps_help]#</li></ul>";
$pgv_lang["apply_privacy_help"]		= "~#pgv_lang[apply_privacy]#~<br /><br />När detta alternativ är markerat passerar utdatafilen sekretesskontroller enligt det valda alternativet. Detta kan leda till att viss information tas bort. Utdatafilen innehåller endast den information som normalt syns för en användare med den angivna behörighetsnivån.<br /><br />Om du bara har #pgv_lang[gedadmin]# rättigheter kan du inte ange att utdatafilen ska privatiseras enligt #pgv_lang[siteadmin]# privilegienivå.";
$pgv_lang["convertPath_help"]		= "~#pgv_lang[convertPath]#~<br /><br />Det här alternativet definierar en konstant sökväg som ska föregås av alla mediasökvägar i utdatafilen.<br /><br />Till exempel, om mediekatalogen har konfigurerats för att vara \"/media\" och om mediefilen som exporteras har en sökväg \"/media/bilder/xyz.jpg\" och du har angett \"c:\\mina bilder\\min familj\" i det här fältet, blir den resulterande mediesökvägen \"c:\\mina bilder\\min familj/bilder/xyz.jpg\".<br /><br />Du kommer att märka i detta exempel:<ul><li>det aktuella mediekatalognamnet tas bort från sökvägen</li><li>och den resulterande sökvägen kommer inte att ha rätt avgränsare för mappnamn.</li></ul><br />Om du vill behålla mediekatalogen i mediefilvägarna för utdatafilen måste du inkludera det namnet i fältet <b>#pgv_lang[convertPath]#</b>.<br /><br />Du bör också använda alternativet <b>#pgv_lang[convertSlashes]#</b> för att säkerställa att mappnamnsavgränsarna är konsekventa och överensstämmer med kraven i det mottagande operativsystemet.<br /><br />Mediavägar som faktiskt är webbadresser ändras inte.";
$pgv_lang["convertSlashes_help"]	= "~#pgv_lang[convertSlashes]#~<br /><br />Det här alternativet avgör om mappnamn i FILE specifikationen för medieobjekt ska separeras med normala snedstreck eller genom snedstreck. Ditt val beror på kraven i det mottagande operativsystemet.<br /><br />Valet <b>#pgv_lang[forwardSlashes]#</b> är lämpligt för de flesta andra operativsystem än Microsoft Windows. Valet <b>#pgv_lang[backSlashes]#</b> ska användas när destinationsprogrammet körs på ett Microsoft Windows-system.<br /><br />Mediavägar som faktiskt är webbadresser ändras inte.";
$pgv_lang["medialist_recursive_help"]	= "~#pgv_lang[medialist_recursive]#~<br /><br />När det här alternativet är valt kommer #pgv_lang[multi_title]# inte bara att söka i den katalog som valts från #pgv_lang[filter]# listan utan även i dess underkataloger. När det här alternativet inte är valt, söks endast den valda katalogen.<br /><br />Titlarna på alla hittade medieobjekt undersöks för att avgöra om de innehåller texten i #pgv_lang[filter]#. Resultatet av dessa två åtgärder avgör vilka multimediaobjekt som ska listas.";
$pgv_lang["medialist_unlinked_help"]	= "~#pgv_lang[medialist_unlinked]#~<br /><br />Endast media som inte är länkade till någon GEDCOM-post visas.";
$pgv_lang["medialist_current_dir_help"]	= "~#pgv_lang[medialist_current_dir]#~<br /><br />Välj den mediekatalog som du vill visa.";
$pgv_lang["sortby_help"]			= "~#pgv_lang[sortby]#~<br /><br />Välj den ordning i vilken du vill se listan.";
$pgv_lang["help_treenav.php"]		= "~#pgv_lang[interactive_tree]#~<br /><br />Använd #pgv_lang[interactive_tree]# för att visa hela personens släktträd i båda riktningarna. Denna uppfattning liknar timglasvyen genom att den visar både förfäder och ättlingar till en given rotperson. Detta diagram ger dig en mer kompakt vy genom att visa rutor för par eller familjer istället för bara enskilda.<br /><ul><li><b>Rulla</b><br />När muspekaren ändras till en Flytta-ikon kan du klicka och dra i trädet för att se andra delar av trädet. När du drar trädet kommer framtida generationer att expandera automatiskt tills det inte finns fler generationer kvar att se i den riktningen.<br /></li><li><b>Zoom</b><br />Du kan använda ikonerna till vänster om trädet för att zooma in och ut. Genom att zooma ut kan du se mer av trädet på skärmen åt gången. När du zoomar ut kan texten bli svår att läsa; när musen svävar över en låda får du en förstorad vy av vad som finns i den.<br /></li><li><b>Expanderande Detaljer</b><br />Genom att klicka på valfri ruta expanderas rutan och visas en mer detaljerad vy. I utökat läge öppnas #pgv_lang[indi_info]# sidan genom att klicka på en persons namn. Om du klickar på <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> ritas trädet om med personen som den nya roten. Om du klickar på <img src='#GLOBALS[PGV_IMAGE_DIR]#/buttons/family.gif' alt='' /> kommer du till familjens detaljerade sida.<br /></li><li><b>Växla makar</b><br />Ikonen <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/sfamily.gif' width='15px' height='15px' alt='' /> direkt under zoomknapparna växlar visningen av alla makar på eller av på avkommansidan. När displayen är inställd på att visa makar kommer alla en persons makar att visas i rutan med dem. Alla personens barn visas också. När alternativet att visa makar är avstängt visas endast personens sista make och barn med denna make.<br /></li><li><b>Stort Familjeträd</b><br />#pgv_lang[interactive_tree]# är tillgänglig från många olika sidor, inklusive fliken Family Tree på sidan #pgv_lang[indi_info]# och diagramblocket på välkomstsidan. När du visar släktträdet från en av dessa andra sidor kommer du också att ha en Family Tree-ikon under zoomikonerna. Om du klickar på <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> kommer du till sidan #pgv_lang[interactive_tree]#.</li></ul>";

$pgv_lang["move_mediadirs_help"]	= "~#pgv_lang[move_mediadirs]#~<br /><br />När Media Firewall är aktiverat kan Multi-Media-filer lagras i en serverkatalog som inte är tillgänglig från Internet.<br /><br />Med dessa knappar kan du enkelt flytta en hel mediekatalogstruktur mellan den skyddade (inte webbadresserbara) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> och den normala <b>#GLOBALS[MEDIA_DIRECTORY]#</b> kataloger.";
$pgv_lang["setperms_help"]			= "~#pgv_lang[setperms]#~<br /><br />Ställ in behörigheterna på det skyddade (inte webbadresserbart) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> och de normala <b>#GLOBALS[MEDIA_DIRECTORY]#</b> katalogerna till antingen världsskrivbar eller skrivskyddad.";
$pgv_lang["update_CHAN_text"] 	= "Administratörer behöver ibland rensa upp och korrigera data som användarna skickar in. Till exempel kan de behöva korrigera PLAC-platsen för att inkludera landet. När administratörer gör sådana korrigeringar ersätts normalt information om den ursprungliga ändringen. Detta kanske inte är önskvärt.<br /><br />När detta alternativ väljs under administratörens redigerings- eller korrigeringssession, kommer PhpGedView att behålla den ursprungliga ändringsinformationen istället för att ersätta den med den för den aktuella sessionen.";
$pgv_lang["config_update_CHAN_help"] 	= "~#pgv_lang[no_update_CHAN]#~<br /><br />Det här alternativet styr starttillståndet för kryssrutan «#pgv_lang[no_update_CHAN]#» som visas på varje sida där administratörer kan göra ändringar eller korrigeringar i den genealogiska databasen.<br /><br />#pgv_lang[update_CHAN_text]#";
$pgv_lang["no_update_CHAN_help"] 	= "~#pgv_lang[no_update_CHAN]#~<br /><br />#pgv_lang[update_CHAN_text]#";
$pgv_lang["edit_SOUR_EVEN_help"]	= "~#pgv_lang[source_events]#~<br /><br />Varje källa beskriver specifika händelser, vanligen för ett speciellt datum intervall för en orts juridiction. T.ex en folkräkning anger folkräkningshändelser och kyrkböcker anger födelse, vigsel och dödshändelser.<br /><br />Välj de händelser som är registrerade av denna källa från listan. Datumen ska anges i intervall format som <i>FRÅN 1900 TILL 1910</i>. Orten anges till den lägsta juridiska nivån för blocket. T.ex anges församling för kyrkböckerna och härad eller rådhusrätt för bouppteckningar eller domböcker.";
$pgv_lang["cache_life_help"]		= "~#pgv_lang[cache_life]#~<br /><br />För att förbättra prestandan sparas PhpGedViews välkomstblocket som en cachefil. Du kan kontrollera hur ofta denna cachefil uppdateras.<br /><ul><li><b>-1</b> betyder att cachefilen aldrig uppdateras automatiskt. För att få en uppdaterad cachefilen måste du radera alla cachefiler. Du kan göra detta via ändra välkomstsidan.</li><li><b>0</b> (noll) betyder att blocket aldrig cachas och varje gång blocket visas på välkomstsidan så ser du en ny kopia. Denna inställning används automatiskt för block som ändras ofta som #pgv_lang[logged_in_users_block]# och #pgv_lang[random_media_block]# blocket.</li><li><b>1</b> (ett) betyder att en ny kopia skapas varje dag, <b>2</b>betyder att en ny kopia skapas varannan dag, <b>7</b> betyder att en ny kopia skapas varje vecka, osv.</li></ul>";
$pgv_lang["clear_cache_help"]		= "~#pgv_lang[clear_cache]#~<br /><br />För att förbättra prestanda sparas flera av blocken på PhpGedView-välkomstsidan som cachefiler i indexkatalogen. Cachefilerna för de flesta block uppdateras en gång varje dag, men det kan finnas tillfällen när du vill uppdatera dem manuellt.<br /><br />Med den här knappen kan du uppdatera cachefilerna vid behov.";
$pgv_lang["import_options_help"] 	= "Du kan välja ytterligare alternativ som ska användas när du importerar GEDCOM.";
$pgv_lang["verify_gedcom_help"]	= "~#pgv_lang[verify_gedcom]#~<br /><br />Här kan du välja att antingen fortsätta eller avbryta uppladdning och import av GEDCOM-filen.";
$pgv_lang["add_gedcom_instructions"]= "Ange ett filnamn för den nya GEDCOM-filen. Den nya GEDCON-filen kommer att skapas i Indexkatalogen: #INDEX_DIRECTORY#";
$pgv_lang["random_media_start_slide_help"]			= "~#pgv_lang[random_media_start_slide]#~<br /><br />Bör bildspelet starta automatiskt när sidan laddas.<br /><br />Bildspelet ändrar blockets innehåll utan att förinstallera information från servern och utan att ladda om hela sidan.";
$pgv_lang["random_media_ajax_controls_help"]	= "~#pgv_lang[random_media_ajax_controls]#~<br /><br />Du kan använda den här inställningen för att visa eller dölja kontrollerna för bildspel för det slumpmässiga medieblocket.<br /><br />Dessa kontroller gör det möjligt för användaren att hoppa till ett annat slumpmässigt objekt eller spela genom slumpmässigt valda media som ett bildspel. Bildspelet ändrar blockets innehåll utan att förinstallera information från servern och utan att ladda om hela sidan.";
$pgv_lang["edit_add_unlinked_source_help"]	= "~#pgv_lang[add_unlinked_source]#~<br /><br />Använd denna länk för att lägga till en ny källa till din databas utan att länka den till ett källsitat i en annan post. Den nya källan kommer att syans i källistan, men kommer inte att synas i några tavlor eller någon annan stans i programmet tills den är länkad till ett källcitat.";
$pgv_lang["edit_add_unlinked_note_help"]	= "~#pgv_lang[add_unlinked_note]#~<br /><br />Använd den här länken för att lägga till en ny delad anteckning till din databas utan att länka anteckningen till någon post. Den nya anteckningen kommer att visas i listan med delade anteckningar, men visas inte i några diagram eller någon annanstans i programmet förrän den är länkad till en person, familj eller händelse.";
$pgv_lang["link_person_id_help"]	= "~#pgv_lang[label_local_id]#~<br /><br />I detta fält skriver du in ID för personen som du länkar till (t.ex. I100).";
$pgv_lang["link_gedcom_id_help"]	= "~#pgv_lang[label_gedcom_id]#~<br /><br />Använd denna sektion för att välja den alternativa databasidentifierare som innehåller personen som du länkar till.";
$pgv_lang["link_remote_site_help"]	= "~#pgv_lang[label_site]#~<br /><br />I denna sektion specificerarar du parametrarna som är nödvändiga för att koppla dig till till den sajten som innehåller den data som du ska länka till. Du har valet att välja från en lista av sajter som användts tidigare eller skriv in #pgv_lang[label_site_url2]# och #pgv_lang[label_gedcom_id]#.<br /><br />In the <b>#pgv_lang[label_site_url2]#</b> fältet skriver du in URLn för att komma åt webaccessservicebeskrivningsfilen(WDSL) som berättar för phpGedView hur man kommer åt data på den andra sajten. För den andra phpGedViewsajten kommer URLn att se ut så här: <u>http://www.remotesite.com/phpGedView/genservice.php?wsdl</u><br /><br /><b>#pgv_lang[label_gedcom_id]#</b> fältet används för att skriva in en valfri databasidentifierare för den andra sajter som kräver en sådan. För PhpGedView-sajter är detta namnet på GEDCOM-filen.<br /><br />Fälten <b>#pgv_lang[label_username_id]#</b> och <b>#pgv_lang[label_password_id]#</b> är nödvändiga om databasen kräver det.";
$pgv_lang["link_remote_location_help"]	= "~#pgv_lang[label_location]#~<br /><br />Detta val låter dig välja om datan för personen som du länkar till ligger på samma sajt men i en annan databas eller om data är på en annan sajt tillgänglig via internet.<br /><br />Om personen är på samma sajt kommer du att behöva ange databasens identifiering och personens ID.<br /><br />För en databas på an annan sajt behöver du ange URL, databasens identifiering och personens ID i den databasen.";
$pgv_lang["link_remote_rel_help"]	= "~#pgv_lang[label_rel_to_current]#~<br /><br />Använd detta val för att välja på vilket sätt personen på en annan sajt är relaterad till personen du länkar honom till på din sajt. T.ex. väljer du <i>Far</i> betyder det att personen på den andra sajten är fader till personen du länkar honom till lokalt.";
$pgv_lang["link_remote_help"]       = "~#pgv_lang[link_remote]#~<br /><br />Använd detta formulär för att länka personer till andra personerantingen ifrån en annan sajt eller en annan genealogisk databas tillgänglig för din kopia av PhpGedView.<br /><br />För att lägga till en sådan länk måste du först välja relationstyp, sedan välja en sajt som redan är känd för PhpGedView eller skapa en ny sajt och sist lägga till den personens ID som du vill lägga till från den sajten. PhpGedView kommer sedan automatiskt att ladda ner den information ifrån den andra sajten som behövs. Den nerladdade informationen kommer <u>inte</u> bli en del av din genealogiska databas den kommer att finnas kvar på den urspungliga sajten men blir införlivade i de olika sidorna var denna person visas.<br /><br />Konsultera hjälplänkarna intill varje element på denna sida för att få mer information om dem. Du kan också kolla den engelska handledning fär mer information: <a href=\"http://www.phpgedview.net/pgvdocs/index.php/HowToRemoteLink\" target=\"_blank\">http://www.phpgedview.net/pgvdocs/index.php/HowToRemoteLink</a>";

//-- Edit Interface
$pgv_lang["edit_REPO_NAME_help"]	= "~#factarray[REPO:NAME]#~<br /><br />Namnet på biblioteket, arkivet eller annan depå där källmaterialet lagras.";
$pgv_lang["edit_REPO_ADDR_help"]	= "~#factarray[REPO:ADDR]#~<br /><br />Adressen till detta bibliotek, arkiv eller annan depå. Ange adressen precis som du skulle skriva den på ett kuvert.<br /><br />Lämna det här fältet tomt om du inte vill inkludera en adress.";
$pgv_lang["edit_REPO_PHON_help"]	= "~#factarray[REPO:PHON]#~<br /><br />Telefonnumret till detta bibliotek, arkiv eller annan depå. Ange numret inklusive land och riktnummer. Till exempel kan ett nummer i Tyskland vara +49 25859 56 76 89 och ett nummer i USA eller Kanada kan vara +1 888 555-1212.<br /><br />Lämna det här fältet tomt om du inte vill inkludera ett telefonnummer.";
$pgv_lang["edit_REPO_FAX_help"]		= "~#factarray[REPO:FAX]#~<br /><br />FAX-numret för detta bibliotek, arkiv eller annan depå. Ange numret inklusive land och riktnummer. Ett nummer i Tyskland kan till exempel vara +49 25859 56 76 89 och ett nummer i USA eller Kanada kan vara +1 888 555-1212.<br /><br />Lämna det här fältet tomt om du inte vill inkludera ett faxnummer.";
$pgv_lang["edit_REPO_EMAIL_help"]	= "~#factarray[REPO:EMAIL]#~<br /><br />E-postadressen till detta bibliotek, arkiv eller annan depå. Ange e-postadressen. Exempel: <b>name@hotmail.com</b><br /><br />Lämna det här fältet tomt om du inte vill inkludera en e-postadress.";
$pgv_lang["edit_REPO_WWW_help"]		= "~#factarray[REPO:WWW]#~<br /><br />Internethemsidan för detta bibliotek, arkiv eller annan depå. Ange hemsidans adress inklusive http:// eller https://. Exempel: <b>https://www.phpgedview.net/</b><br /><br />Lämna det här fältet tomt om du inte vill inkludera en hemsideadress.";
$pgv_lang["edit_CALN_help"]			= "~#factarray[CALN]#~<br /><br />En identifierings- eller referensbeskrivning som används för att arkivera och hämta objekt från innehaven i ett bibliotek, arkiv eller annat arkiv. Informella förråd behöver vanligtvis inte använda ett #factarray[CALN]# system.";
$pgv_lang["edit_REPO_help"]			= "~#factarray[REPO]#~<br /><br />Detta är ID-numret för biblioteket, arkivet eller annan depå där det källmaterial som refereras lagras. Titeln på det aktuella arkivet kommer att visas under ID-numret.<br /><br />Du kan ändra ID-numret på arkivet där källmaterialet lagras. För att ta bort arkivreferensen, gör detta fält tomt. Den här åtgärden tar inte bort arkivposten från databasen; endast referensen tas bort.<br /><br />Om du anger önskat arkiv-ID direkt måste arkivposten redan finnas i databasen. Du kan klicka <b>#pgv_lang[find_repository]#</b> för att slå upp ett befintligt arkivs ID-nummer. Klicka <b>#pgv_lang[create_repository]#</b> om du behöver ange en ny arkivpost.";
$pgv_lang["edit_PUBL_help"]			= "~#factarray[PUBL]#~<br /><br />När och var posten skapades. För publicerade verk inkluderar detta information som publikationsstad, utgivarens namn och publiceringsår.<br /><br />För ett opublicerat verk bör det innehålla datumet då posten skapades och platsen där den var skapad. Till exempel länet och bosättningsstaten för en person som gör en deklaration för pension eller staden och bosättningsorten för skrivaren av ett brev eller en privat familjehistoria.";
$pgv_lang["edit_AUTH_help"]			= "~#factarray[AUTH]#~<br /><br />Personen, byrån eller enheten som skapade posten. För ett publicerat verk kan detta vara författaren, kompilatorn, transkriberaren, abstraktorn eller redaktören. För en opublicerad källa kan detta vara en person, en myndighet, en kyrklig organisation eller en privat organisation etc.";
$pgv_lang["edit_REFN_help"]			= "~#factarray[REFN]#~<br /><br />Det här fältet används normalt för att spela in friformstext för att identifiera denna GEDCOM-post. Det kan till exempel vara ett filnummer i ett automatiserat eller manuellt system, eller så kan det vara ett sid- och positionsnummer i ett stamtavla.<br /></br />När GEDCOM-konfigurationen har ställts in för att tillåta användaren att åsidosätta det automatiskt genererade ID-numret för nya personer, anges detta övergripande ID-nummer här. I det här fallet måste texten överensstämma med reglerna för ID-nummer. Giltiga ID-nummer kan endast innehålla bokstäverna <b>A</b> till <b>Z</b>, <b>a</b> till <b>z</b>, siffror <b>0</b> till <b>9</b> och specialsymbolerna <b>. : -</b> och <b>_</b><br /><br />Alternativet som möjliggör användning av #factarray[REFN]# istället för det automatiskt genererade ID-numret finns i GEDCOM-konfigurationen, avsnittet Alternativ för redigering.";
$pgv_lang["edit_ABBR_help"]			= "~#factarray[ABBR]#~<br /><br />Använd detta fält för att spara en förkortad variant av en titel. Detta fält används i kombination med titelfältet för källor. Som standard kommer PGV att använda först titlen sedan förkortningen.<br /><br />Enligt GEDCOM 5.5 specifikationen, \"detta post är till för att tillhandahålla en kort titel som används vid sortering, insättning och hämtning av poster (pg 62).\"<br /><br />I PhpGedView är fältet valfritt, men i andra program är det ett krav att det används.";
$pgv_lang["edit_ROMN_help"]			= "~#factarray[NAME:ROMN]#~<br /><br />#pgv_lang[edit_ROMN_advice]#";
$pgv_lang["edit_ROMN_advice"]		= "I många kulturer är det vanligt att ha ett traditionellt namn stavat i de traditionella tecknen och också en romaniserad version av namnet eftersom det skulle stavas eller uttalas på språk baserat på det latinska alfabetet, till exempel svenska.<br /><br />Om du föredrar att använda ett alfabet som inte är latin, som hebreiska, grekiska, ryska, kinesiska eller arabiska för att ange namnet i standardnamnfälten, kan du använda det här fältet för att ange samma namn med det latinska alfabetet. Båda versionerna av namnet kommer att visas i listor och diagram.<br /><br />Även om detta fält är märkt \"Romaniserat\", är det inte begränsat till att endast innehålla tecken baserat på det latinska alfabetet. Detta kan vara till nytta med japanska namn, där tre olika alfabet kan förekomma.";
$pgv_lang["edit_ROMN_GIVN_help"]	= "~#pgv_lang[roman_givn]#~<br /><br />#pgv_lang[edit_ROMN_advice]#<br /><br />I det här fältet ska du ange de angivna namnen för personen. Som exempel, i namnet \"John Robert Finlay\" är de förnamn som ska anges här \"John Robert\".";
$pgv_lang["edit_ROMN_SURN_help"]	= "~#pgv_lang[roman_surn]#~<br /><br />#pgv_lang[edit_ROMN_advice]#<br /><br />I det här fältet ska du ange personens efternamn. Som exempel, i namnet \"John Robert Finlay\" är efternamnet som ska anges här \"Finlay\".<br /><br />Personer med flera efternamn, vanliga i Spanien och Portugal, bör separera efternamnen med ett komma. Detta indikerar att personen ska listas under vart och ett av namnen. Till exempel kommer efternamnet \"Cortes,Vega\" att listas under både <b>C</b> och <b>V</b>, medan efternamnet \"Cortes Vega\" bara kommer att listas under <b>C</b>.";
$pgv_lang["edit__HEB_help"]			= "~#factarray[_HNM]#~<br /><br />#pgv_lang[edit__HEB_advice]#";
$pgv_lang["edit__HEB_advice"]		= "I många kulturer är det vanligt att ha ett traditionellt namn stavat i de traditionella tecknen och också en romaniserad version av namnet eftersom det skulle stavas eller uttalas på språk baserat på det latinska alfabetet, till exempel svenska.<br /><br />Om du föredrar att använda det latinska alfabetet för att ange namnet i standardnamnsfälten kan du använda det här fältet för att ange samma namn i det icke-latinska alfabetet som grekiska, hebreiska, ryska, arabiska eller kinesiska. Båda versionerna av namnet kommer att visas i listor och diagram.<br /><br />Även om detta fält är märkt \"hebreiska\", är det inte begränsat till att endast innehålla hebreiska tecken.";
$pgv_lang["edit__HEB_GIVN_help"]	= "~#pgv_lang[hebrew_givn]#~<br /><br />#pgv_lang[edit__HEB_advice]#<br /><br />I det här fältet ska du ange de angivna namnen för personen. Som exempel, i namnet \"John Robert Finlay\" är de förnamn som ska anges här \"John Robert\".";
$pgv_lang["edit__HEB_SURN_help"]	= "~#pgv_lang[hebrew_surn]#~<br /><br />#pgv_lang[edit__HEB_advice]#<br /><br />I det här fältet ska du ange personens efternamn. Som exempel, i namnet \"John Robert Finlay\" är efternamnet som ska anges här \"Finlay\".<br /><br />Personer med flera efternamn, vanliga i Spanien och Portugal, bör separera efternamnen med ett komma. Detta indikerar att personen ska listas under vart och ett av namnen. Till exempel kommer efternamnet \"Cortes,Vega\" att listas under både <b>C</b> och <b>V</b>, medan efternamnet \"Cortes Vega\" bara kommer att listas under <b>C</b>.";
$pgv_lang["edit_SEX_help"]			= "#pgv_lang[edit_sex_help]#";
$pgv_lang["edit_NAME_help"]			= "#pgv_lang[edit_name_help]#";
$pgv_lang["edit_add_unlinked_person_help"]	= "~#pgv_lang[add_unlinked_person]#~<br /><br />Använd detta formulär för att lägga till en olänkad person.<br /><br />När du lägger till en olänkad person till ditt släktträd, personen kommer inte att länkas med någon annan i trädet förrän du länkar ihop dem. Du kan senare länka ihop personer ifrån #pgv_lang[relatives]#-fliken på #pgv_lang[indi_info]#-sidan.";
$pgv_lang["edit_URL_help"]			= "~#factarray[URL]#~<br /><br />Skriv in URL adressen inkludera http://. Exempel: <b>http://www.phpgedview.net/</b><br /><br />Lämna detta fält tomt om du inte vill inkludera en URL.";
$pgv_lang["edit_WWW_help"]			= "~#factarray[WWW]#~<br /><br />Skriv in webbsidans adress inkludera http://. Exempel: <b>http://www.phpgedview.net/</b><br /><br />Lämna detta fält tomt om du inte vill inkludera en webbsidans adress.";
$pgv_lang["edit_EMAIL_help"]		= "~#factarray[EMAIL]#~<br /><br />Skriv in epostadressen. Exempel: <b>namn@hotmail.com</b><br /><br />Lämna detta fält tomt om du inte vill inkludera en epostadressen.";
$pgv_lang["edit_FAX_help"]			= "~#factarray[FAX]#~<br /><br />Skriv in faxnumret inkludera lands och riktnummer. T.ex. ett nummer i Tyskland kan vara +49 25859 56 76 89 och ett nummer i USA eller Kanada +1 888 555-1212.<br /><br />Lämna detta fält tomt om du inte vill inkludera ett faxnummer.";
$pgv_lang["edit_PHON_help"]			= "~#factarray[PHON]#~<br /><br />Skriv in ett telefonnummer inkludera lands och riktnummer. T.ex. ett nummer i tyskland kan vara +49 25859 56 76 89 och ett nummer i USA eller Kanada +1 888 555-1212.<br /><br />Lämna detta fält tomt om du inte vill inkludera ett telefonnummer.";
$pgv_lang["edit_ADDR_help"]			= "~#factarray[ADDR]#~<br /><br />Skriv in adressen i detta fält precis som du skulle göra på ett kuvert.<br /><br />Lämna detta fält tomt om du inte vill inkludera en adress.";
$pgv_lang["edit_GIVN_help"]			= "#pgv_lang[edit_given_name_help]#";
$pgv_lang["edit_SPFX_help"]			= "~#factarray[SPFX]#~<br /><br />Skriv in eller välj från listan ordet som ska föregå huvuddelen av efternamnet. Exempel på sådana ord är <b>von</b> Braun, <b>van der</b> Kloot, <b>de</b> Graaf, etc.<br /><br />Under vissa omständigheter kan en adelstitel anges här. Till exempel Peter <b>Freiherr von</b> Någonstans. «Freiherr» delen är faktiskt en adelstitel och bör inte upprepas som ett faktum #factarray[TITL]#. Vad som skrivs in här är till stor del beroende av personens preferenser.";
$pgv_lang["edit_SURN_help"]			= "#pgv_lang[edit_surname_help]#";
$pgv_lang["edit__MARNM_help"]		= "~#factarray[_MARNM]#~<br /><br />Skriv in vigselnamnet för personen, använd samma formatteringsregler som gäller för namnfältet. Detta fält är valfritt.<br /><br />T.ex. om Mary Jane Brown gifter sig med John White, kan du skriva in (utan citationstecken tecken, så klart)<ul><li>Amerikansk användning:&nbsp;&nbsp;\"Mary Jane Brown /White/\"</li><li>Europeisk användning:&nbsp;&nbsp;\"Mary Jane /White/\"</li><li>Alternativ Europeisk användning:&nbsp;&nbsp;\"Mary Jane /White-Brown/\" eller \"Mary Jane /Brown-White/\"</li></ul>Du ska göra detta endast om Mary Brown börjar använda det nya namnet efter att ha gift sig med John White. På vissa platser t.ex. Quebec (Kanada) är det olagligt att byta namn på detta sätt.<br /><br />Män byter ibland namn efter att ha gift sig, oftast används då dubbelnamnsformen men ibland så byter män namn till Makans efternamn.";
$pgv_lang["edit_PEDI_help"]			= "~#factarray[PEDI]#~<br /><br />Detta fält beskriver barnets förhållande till dess familj. Möjligheterna är:<ul><li><b>#pgv_lang[unknown]#</b>&nbsp;&nbsp;&nbsp;Barnets förhållande till familjen kan inte bestämmas. När detta alternativ är valt kommer fältet #factarray[PEDI]# inte att kopieras till databasen.</li><li><b>#factarray[BIRT]#</b>&nbsp;&nbsp;&nbsp;Detta alternativ indikerar att barnet är släkt med sin familj efter födseln.</li><li><b>#pgv_lang[adopted]#</b>&nbsp;&nbsp;&nbsp;Detta alternativ indikerar att barnet adopterades av sin familj. Detta indikerar <i>inte</i> att det inte finns något blodförhållande mellan barnet och dess familj; det visar att barnet adopterades av familjen i fråga någon gång efter barnets födelse.</li><li><b>#pgv_lang[foster]#</b>&nbsp;&nbsp;&nbsp;Detta alternativ indikerar att barnet är ett fosterbarn i familjen. Vanligtvis finns det inget blodförhållande mellan barnet och dess familj.</li><li><b>#pgv_lang[sealing]#</b>&nbsp;&nbsp;&nbsp;Barnet förseglades till sin familj i en SDH <i>försegling</i> ceremoni. Ett barns försegling utförs när föräldrarna förseglades till varandra efter barnets födelse. Barn födda efter föräldrarnas försegling förseglas automatiskt till familjen.</li></ul>";
$pgv_lang["edit_AGNC_help"]			= "~#factarray[AGNC]#~<br /><br />Organisationen, institutionen, företaget, personen eller någon annan enhet som har auktoritet.<br /><br />Till exempel en arbetsgivare för en person eller en kyrka som administrerar ritualer eller evenemang, eller en organisation som ansvarar för att skapa och / eller eller arkivering av poster.";
$pgv_lang["edit_MARR_TYPE_help"]	= "~#factarray[MARR]#: #factarray[TYPE]#~<br /><br />Detta fält beskriver vilken typ av förening som bildade familjen.<ul><li><b>#factarray[MARR_RELIGIOUS]#</b>&nbsp;&nbsp;&nbsp;indikerar att ceremonin som formaliserade föreningen av två personer för att bilda en familj utfördes av en präst, biskop, kardinal, predikant, rabbin, shaman eller liknande person. Ceremonin ägde inte nödvändigtvis rum i en kyrka, synagoga, tempel eller annan helgad plats. Det kunde ha ägt rum utomhus eller i ett privat hem.</li><li><b>#factarray[MARR_CIVIL]#</b>&nbsp;&nbsp;&nbsp;indikerar att ceremonin som formaliserade föreningen av två personer för att bilda en familj utfördes av en domare, magistrat, borgmästare eller liknande myndighetsperson som inte är präst, etc. Befogenheten att utföra sådana ceremonier beviljas vanligtvis av en regering. Ceremonin ägde inte nödvändigtvis rum i en rättssal eller ett kontor.</li><li><b>#factarray[MARR_PARTNERS]#</b>&nbsp;&nbsp;&nbsp;beskriver förhållandet mellan två personer, som inte är gifta med varandra, som beter sig som om de vore en familj. De har <u>inte</u> deltagit i en vigselceremoni utförd av en präst, en biskop, en domare, en borgmästare eller någon annan person med befogenhet att förrätta vigslar. De kan ha gjort en offentlig förklaring att de anser sig vara gifta, men det är inget krav.</li><li><b>#factarray[MARR_UNKNOWN]#</b>&nbsp;&nbsp;&nbsp;indikerar att detaljerna i föreningen mellan två personer för att bilda en familj inte är kända.</li></ul>";

$pgv_lang["context_help"]			= "Mer hjälp finns tillgänglig genom att klicka på <b>?</b> intill artiklarna på sidorna.";

$pgv_lang["register_gedcomid_help"]	= "~#pgv_lang[gedcomid]#~<br /><br />Alla personer i databasen har ett unikt idnummer på denna sajt. Om du vet ditt idnummer för dig själv, skriv in det här. Om du inte vet ditt idnummer, eller kan inte hitta det beroende på intgritetsinställningar, så var vänlig att ange tillräckligt med infromation i kommentarfältet för att hjälpa administratören att veta vilken person du är på sajten så att de kan sätta idt för dig.";
$pgv_lang["register_comments_help"]	= "~#pgv_lang[comments]#~<br /><br />Använd detta fält för att berätta för administratören varför du begär ett konto och hur ditt släktförhållande är till de på sajten. Du kan också använda detta fält att skriva in andra kommentarer du har till sajtadministratören.";
$pgv_lang["utf8_ansi_help"]		= "~#pgv_lang[utf8_to_ansi]#~<br /><br />För att få bästa möjliga visning på internet använder PhpGedView UTF-8 teckenuppsättning. Vissa program som Family Tree Maker stödjer inte import av GEDCOM-filer kodad i UTF-8. Kryssa i denna ruta så konverteras filen från <b>UTF-8</b> till <b>ANSI (ISO 8859-1)</b>.<br /><br />Vilket format du behöver beror på vilket program du ska använda när du laddat ner GEDCOM-filen. Kontrollera dokumentationen för programmet om du inte är säker.<br /><br />Observera att för att specialtecken ska vara oförändrade måste du behålla filen i UTF-8 och konvertera den till programmets metod för att hantera dessa specialtecken på något annat sätt. Rådgör med programmets tillverkare eller författare.<br /><br />Denna <a href='https://sv.wikipedia.org/wiki/UTF-8' target='_blank' title='Wikipedia-artikel'><b>Wikipedia-artikel</b></a> innehåller omfattande information och länkar om UTF-8.";
$pgv_lang["remove_tags_help"]	= "~#pgv_lang[remove_custom_tags]#~<br /><br />Kryssa i detta val så tas alla PGV specialtaggar bort som har blivit tillagda till posterna.<br /><br />Speciella taggar som används av PhpGedView är <b>_PGVU</b> taggen som visar vilken PGV användare som ändrat poster online och <b>_THUM</b> taggen vilket visar PGV vilken bild som ska användas som miniatyrbild.<br /><br />Specialtaggar kan orsaka fel när man importera den nerladdaded GEDCOM-filen till andra släktforskningsprogram.";
$pgv_lang["download_zipped_help"]	= "~#pgv_lang[zip_files]#~<br /><br />När du väljer denna inställning kommer en kopia av GEDCOM-filen komprimeras till en ZIP-fil innan nerladdningen börjar. Detta kommer att minska filstorleken väsentligt, men du behöver ett kompatibelt upppackningsprogram (WinZip, t.ex.) för att packa upp den nerladdade GEDCOM-filen innan du kan använda den.<br /><br />Detta är ett användbart alternativ för nerladdning av stora GEDCOM-filer. Det finns en risk att nerladdningen av en opackad fil kan överskrida den maximala exekverningstiden, vilket resulterar i ej kompletta filer. Valet av ZIP-packade filer bör minska nerladdningstiden med ca 75%.";
$pgv_lang["edit_NCHI_help"]		= "~#factarray[NCHI]#~<br /><br />Skriv in antal barn för denna person eller familj. Detta är ett frivilligt fält.";
$pgv_lang["edit_TIME_help"]		= "~#factarray[TIME]#~<br /><br />Skriv in tid för denna händelse. Giltigt format är HH:MM. Exempel: 04:50 13:00 20:30.";
$pgv_lang["edit_NOTE_help"]		= "~#factarray[NOTE]#~<br /><br />Anteckningar är ett fritt text fält och kommer att visas i faktadetalj delen av sidan.";
$pgv_lang["edit_SHARED_NOTE_help"]		= "~#pgv_lang[shared_note]#~<br /><br />Delade anteckningar är friformstext och kommer att visas i avsnittet Faktadetaljer på sidan.<br /><br />Varje delad anteckning kan länkas till mer än en person, familj, källa eller händelse.";
$pgv_lang["edit_CEME_help"]		= "~#factarray[CEME]#~<br /><br />Skriv in namnet på kyrkogården eller annan viloplats där personen är begravd.";
$pgv_lang["edit_ASSO_help"]			= "~#factarray[ASSO]#~<br /><br />Ange GEDCOM ID för den person vars förhållandet till den nuvarande personen du vill beskriva.";
$pgv_lang["edit_RELA_help"]			= "~#factarray[RELA]#~<br /><br />Välj en #factarray[RELA]# från listan. Att välja <b>#pgv_lang[godfather]#</b> betyder: <i>Personen som identifieras i fältet #factarray[ASSO]# är #pgv_lang[godfather]# för den aktuella personen</i>.";
$pgv_lang["show_spouse_help"]			= "~#pgv_lang[show_spouses]#~<br /><br />Som standard visar inte denna tavla make/maka för ättlingar eftersom det gör tavlan svårar att läsa och förstå. Om man sätter på detta val så visas make/maka i tavlan.";
$pgv_lang["reorder_families_help"]		= "~#pgv_lang[reorder_families]#~<br /><br />Familjer på #pgv_lang[relatives]#-fliken visas i den ordningen som de finns i personens GEDCOM-post. Många människor frågar sig varför familjerna inte är sorterade efter vigseldatum. Detta beror på att man ofta inte vet vigseldatumet men ofta <u>vet</u> man ordningen för vigslarna.<br /><br />Detta val tillåter att man ändrar ordning på familjerna som de visas på #pgv_lang[relatives]#-fliken. Eftersom du ofta vill sortera familjer efter vigseldatum så finns det en knapp som gör det automatiskt.";
$pgv_lang["autoContinue_help"]			= "~#pgv_lang[autoContinue]#~<br /><br />När PhpGedView upptäcker att GEDCOM-importen kräver mer tid än tidsgränsen tillåter kommer den att visa en knapp <b>#pgv_lang[del_proceed]#</b> som du måste trycka på för att fortsätta importen.<br /><br />När detta alternativ är inställt på <b>#pgv_lang[yes]#</b>, kommer PhpGedView automatiskt att trycka på knappen <b>#pgv_lang[del_proceed]#</b> åt dig. Detta borde lindra tråkigheten att behöva trycka på knappen upprepade gånger för längre import.";
$pgv_lang["firstname_i_help"]		= "~#pgv_lang[firstname_alpha_index]#~<br /><br />Efternamnet du har valt innehåller fler än #GLOBALS[SUBLIST_TRIGGER_I]# presoner.<br /><br />För att hjälpa dig hitta personen du söker har listan blivit uppbruten i mindre listor efter första bokstaven i personens förnamn. Det alfabetiska under-indexet fungerar på samma sätt som för efternamn.<ul><li>Klicka på en bokstav för att se alla förnamn som börjar med denna bokstav.</li><li>Välj <b>#pgv_lang[PN]#</b> för att lista personer med okänt förnamn.</li><li>Välj <b>#pgv_lang[all]#</b> kommer att visa alla personer med det föregående valda efternamnet.</li></ul>.";
$pgv_lang["firstname_f_help"]		= "~#pgv_lang[firstname_alpha_index]#~<br /><br />Efternamnet du har valt innehåller fler än #GLOBALS[SUBLIST_TRIGGER_F]# presoner.<br /><br />För att hjälpa dig hitta familjen du söker har listan blivit uppbruten i mindre listor efter första bokstaven i personens förnamn. Det alfabetiska under-indexet fungerar på samma sätt som för efternamn.<ul><li>Klicka på en bokstav för att se alla förnamn som börjar med denna bokstav.</li><li>Välj <b>#pgv_lang[PN]#</b> för att lista personer med okänt förnamn.</li><li>Välj <b>#pgv_lang[all]#</b> kommer att visa alla personer med det föregående valda efternamnet.</li></ul>";
$pgv_lang["edit_TYPE_help"]		= "~#factarray[TYPE]#~<br /><br />#factarray[TYPE]#-fältet tillåter dig att specificera en specialhändelse. Det är ett fritt fält där du kan skriva in vad du vill spara.";
$pgv_lang["edit_TEMP_help"]		= "~#factarray[TEMP]#~<br /><br />För SDH förordning, detta fält anger vilket tempel förordningen utfördes vid.";
$pgv_lang["edit_STAT_help"]		= "~#factarray[STAT]#~<br /><br />Detta är ett valfritt statusfält och används oftast till SDH förordningar när de körs igenom TempleReady programmet.";
$pgv_lang["edit__PRIM_help"]		= "~#factarray[_PRIM]#~<br /><br />Använd detta fält för att visa att detta mediaartikel är det markerade eller primära artikeln för personen den tillhör. Den primära bilden är den som kommer att användas i tavlor och på ansedeln.";
$pgv_lang["edit__THUM_help"]		= "~#factarray[_THUM]#~<br /><br />Det här alternativet låter dig åsidosätta det vanliga valet för en miniatyrbild.<br /><br />GEDCOM har ett konfigurationsalternativ som anger om PhpGedView ska skicka den stora eller den lilla bilden till webbläsaren när den aktuella sidan kräver en miniatyrbild. Alternativet «#factarray[_THUM]#», när det är inställt på <b>#pgv_lang[yes]#</b>, tillfälligt åsidosätter inställningen för GEDCOM-konfigurationsalternativet, så att PhpGedView alltid skickar den stora bilden. Du kan inte tvinga PhpGedView att skicka den lilla bilden när GEDCOM-konfigurationen anger att stora bilder alltid ska användas.<br /><br />PhpGedView ändrar inte storleken på bilden som skickas. webbläsaren gör detta enligt de sidspecifikationer som den också har fått. Detta kan få oönskade konsekvenser när bilden som skickas inte är en miniatyrbild där PhpGedView förväntar sig att skicka en liten bild. Detta är inte ett fel: Det finns tillfällen där det kan vara önskvärt att visa en stor bild på platser där man normalt förväntar sig att se en miniatyrstorlek.<br /><br />Du bör undvika att ställa in alternativet «#factarray[_THUM]#» till <b>#pgv_lang[yes]#</b>. Detta val kommer att leda till att stora mängder bildrelaterad data skickas till webbläsaren, bara för att webbläsaren ska kasta överskottet. Sidbelastningar, särskilt av diagram med många bilder, kan sakta ner.";
$pgv_lang["edit_TITL_help"]		= "~#factarray[TITL]#~<br /><br />Skriv in en titel för objektet du jobbar med. Om det är en titel för ett multimediaobjekt, skriv då in en beskrivande titel som identifierar objektet för användaren.<br /><br />Om du redigerar en persons uppgifter, använd det här fältet för att ange adelsinformation som <i>Sir, Lord, Baron, Earl, Hertig, Graf, Freiherr,</i> etc.<br /><br />Professionella beteckningar som <i>Dr., Amiral, Lt.Gen., Rev., Sister,</i> etc. ska anges i underfältet «#factarray[NPFX]#», medan namnsuffix som <i>Jr., Sr., III, IV,</i> etc. och akademisk information som <i>PhD, PEng, FImechE, DVM, MD,</i> etc. hör hemma i underfältet «#factarray[NSFX]#».";
$pgv_lang["edit_FILE_help"]		= "~#factarray[FILE]#~<br /><br />Detta är det viktigaste fältet i multimediaobjektposten. Det berättar vilken fil som ska användas. Du måste minst ange filnamnet. Mer information om filens placering kan vara bra beroende på dina inställningar.<br /><br />Du kan använda #pgv_lang[find_media]#-länken för att hitta platsen för mediaobjektet som redan finns uppladdad till sajten.<br /><br />#pgv_lang[readme_help]#";
$pgv_lang["edit_FORM_help"]		= "~#factarray[FORM]#~<br /><br />Detta är ett frivilligt fält som kan användas för att ange filformatet för ett multimediaobjekt. Vissa släktforskningsprogram kan tänkas titta på detta fält för att avgöra hur man ska hantera mediaobjektet. Men eftersom media inte överförs speciellt bra mellan olika datorsystem så är fältet inte speciellt viktigt.";
$pgv_lang["generate_thumb_help"]		= "~#pgv_lang[auto_thumbnail]#~<br /><br />Vi har upptäckt att ditt system har möjlighet att automatiskt kunna generera miniatyrbilder för vissa typer av bilder. PHP kan ha support för BMP, GIF, JPG och PNG bilder. Typerna som dit system stödjer listas i kryssrutorna.<br /><br />Genom att klicka på denna kryssruta så visar du systemet att du laddar upp en bild och att du vill att det ska genereras en miniatyrbild automatiskt för dem. Låt bli att kryssa rutam om du själv vill göra miniatyrbilder.";
$pgv_lang["edit_add_NOTE_help"]		= "~#pgv_lang[add_note]#~<br /><br />Denna sektion låter dig lägga till en ny anteckning till faktan du för tillfället redigerar. Anteckningar är ett fritt textfält och kommer att visas i faktadetaljsektionen för sidan.";
$pgv_lang["edit_add_SHARED_NOTE_help"]		= "~#pgv_lang[add_shared_note]#~<br />~#pgv_lang[edit_shared_note]#~<br /><br />Delade anteckningar, som vanliga anteckningar, är text i fri form. Till skillnad från vanliga anteckningar kan varje delad anteckning länkas till mer än en person, familj, källa eller fakta.<br /><br />Genom att klicka på lämplig ikon kan du skapa en länk till en befintlig delad anteckning eller skapa en ny delad anteckning och samtidigt länka till den. Om en länk till en befintlig delad anteckning redan har upprättats kan du också redigera anteckningsinnehållet.<br /><ul><li><b>Länk till en befintlig delad anteckning</b><div style=\"padding-left: 20px;\">Om du redan känner till ID-numret för önskad delad anteckning kan du ange numret direkt i fältet.<br /><br />När du klickar på ikonen <b>#pgv_lang[find_shared_note]#</b> kan du söka i texten i alla befintliga delade anteckningar och sedan välja en av dem. ID-numret för den valda anteckningen matas in i fältet automatiskt.<br /><br />Du måste klicka på knappen <b>#pgv_lang[add]#</b> för att uppdatera den ursprungliga posten.</div><br /></li><li><b>Skapa en ny delad anteckning</b><div style=\"padding-left: 20px;\">När du klickar på ikonen <b>#pgv_lang[create_shared_note]#</b> öppnas ett nytt fönster. Du kan ange texten i den nya anteckningen som du vill. Som med vanliga anteckningar kan du ange webbadresser.<br /><br />När du klickar på knappen <b>#pgv_lang[save]#</b> ser du ett meddelande med ID-numret för den nyligen skapade delade anteckningen. Du bör klicka på det här meddelandet för att stänga redigeringsfönstret och även kopiera det nya ID-numret direkt till ID-nummerfältet. Om du bara stänger fönstret kommer det nyskapade ID-numret inte att kopieras automatiskt.<br /><br />Du måste klicka på knappen <b>#pgv_lang[add]#</b> för att uppdatera den ursprungliga posten.</div><br /></li><li><b>Redigera en befintlig delad anteckning</b><div style=\"padding-left: 20px;\">När du klickar på ikonen <b>#pgv_lang[edit_shared_note]#</b> öppnas ett nytt fönster. Du kan ändra texten i den befintliga delade anteckningen som du vill. Som med vanliga anteckningar kan du ange webbadresser.<br /><br />När du klickar på knappen <b>#pgv_lang[save]#</b> uppdateras texten i den delade anteckningen. Du kan stänga fönstret och klicka sedan på knappen <b>#pgv_lang[save]#</b> igen.<br /><br />När du ändrar texten i en delad anteckning kommer din ändring att återspeglas på alla platser som den delade anteckningen för närvarande är länkad till. Nya länkar som du skapar efter att du har gjort din ändring kommer också att använda den uppdaterade texten.</div></li></ul>";
$pgv_lang["edit_add_GEDFact_ASSISTED_help"]	= "~ANVÄNDER ASSISTENT GEDFACT~<br /><br />Klicka på ikonen \"+\" för att öppna fönstret GEDFact Shared Note Assistant. Specifik hjälp finns där.<br /><br />När du klickar på knappen \"Spara\" visas ID för den delade anteckningen kommer att klistras in här.";
$pgv_lang["edit_add_SOUR_help"]		= "~#pgv_lang[add_source]#~<br /><br />Denna sektion göra att du kan lägga till nya källcitat till den fakta som du för närvarande redigerar.<br /><br />I källfältet skriver du in ID för källan. Klicka på <b>#pgv_lang[create_source]#</b>-länken om du behöver lägga till en nya källa. I citatdetaljfältet skriver du in sidnummer eller annan information som hjälper till att hitta informationen i källan igen. I textfältet skriver du av källans text.";
$pgv_lang["edit_add_ASSO_help"]		= "~#pgv_lang[add_asso]#~<br /><br />#pgv_lang[add_asso]# gör att du kan länka fakta med en associerad person på denna sajt. Detta är ett sätt att registrera att någon var faddrar till någon.";
$pgv_lang["edit_QUAY_help"]			= "~#factarray[QUAY]#~<br /><br />Du skulle använda detta fält för att registrera kvaliteten eller tillförlitligheten hos de data som finns i den här källan. Många släktforskningsapplikationer använder ett nummer i fältet. <b>3</b> kan betyda att data är en primär källa, <b>2</b> kan betyda att det var en sekundär källa, <b>1</b> kan betyda att informationen är tveksam, och <b>0</b> kan betyda att källan är opålitlig.";
$pgv_lang["edit_PAGE_help"]		= "~#factarray[PAGE]#~<br /><br />I källcitatfältet bör du skriva in sidnummret eller annan information som kan hjälpa för att hitta informationen i källan.";
$pgv_lang["edit_TEXT_help"]		= "~#factarray[TEXT]#~<br /><br />I detta fältet ska du skriva in citattexten från källan. Exempel på datan kan vara avskrifter av texten i källan eller en beskrivning av som stod i citatet.";
$pgv_lang["edit_SOUR_help"]			= "~#factarray[SOUR]#~<br /><br />Det här är källans ID-nummer för denna fakta. Titeln på den aktuella källan kommer att visas under ID-numret.<br /><br />Du kan ändra ID-numret på källposten som detta faktas källcitering hänvisar till. För att ta bort hela citatet, gör detta fält tomt. Den här åtgärden tar inte bort källposten från databasen; endast denna referens tas bort.<br /><br />Om du anger önskat käll-ID direkt måste källposten redan finnas i databasen. Du kan klicka <b>#pgv_lang[find_sourceid]#</b> för att leta upp en befintlig källposts ID-nummer. Klicka <b>#pgv_lang[create_source]#</b> om du behöver ange en ny källpost.";
$pgv_lang["edit_edit_raw_help"]	= "~#pgv_lang[edit_raw]#~<br /><br />Denna sida tillåter dig att redigera den råa GEDCOM-posten. Du bör använda denna sida men försiktighet, det kräver en bra förståelse för GEDCOM 5.5.1 standarden. För mer information om GEDCOM 5.5.1 standarden, läs hjälpen om <b>GEDCOM-fil</b>.<br /><br />PhpGedView erbjuder många sätta att lägga till och redigera information, men det kan finnas tillfällen när du behöver redigera GEDCOM-strukturen. När det är möjligt bör du använda de angivna formulären för att lägga till information, men när det är omöjligt kan du använda det här formuläret. När du skickar formuläret kommer din information att kontrolleras mot standarden och CHAN posten kommer att uppdateras.";
$pgv_lang["add_from_clipboard_help"]	= "~#pgv_lang[add_from_clipboard]#~<br /><br />Med PhpGedView kan du kopiera upp till 10 fakta med alla detaljer till ett urklipp. Detta urklipp skiljer sig från urklippsvagnen som du kan använda för att exportera delar av din databas.<br /><br />Du kan välja någon av fakta från urklipp och kopiera det valda faktumet till den person-, familj-, media-, källkods- eller förvarsposten som för närvarande redigeras. Du kan dock inte kopiera fakta med olika typer av poster. Du kan till exempel inte kopiera ett äktenskapsfakta till en källa eller en personpost eftersom äktenskapsfakta endast är kopplat till familjeposter.<br /><br />Detta är mycket användbart när du anger liknande fakta, som folkräkningsfakta, för många individer eller familjer.";
$pgv_lang["edit_PLAC_help"]			= "~#factarray[PLAC]#~<br /><br />Platser bör anges enligt genealogiska standarder. I släktforskning registreras platser med den mest specifika informationen om platsen först och sedan arbetar de upp till den minst specifika platsen senast, med kommatecken för att separera de olika platsnivåerna. Nivån på vilken du registrerar platsinformationen ska representera nivåerna för regeringen eller kyrkan där viktiga register för den platsen hålls.<br /><br />Till exempel skulle en plats som Salt Lake City anges som \"Salt Lake City, Salt Lake, Utah, USA\".<br /><br />Låt oss undersöka varje del av denna plats. Den första delen, \"Salt Lake City\", är staden eller staden där händelsen inträffade. I vissa länder kan det finnas kommuner eller distrikt i en stad som det är viktigt att notera. I så fall borde de komma inför staden. Nästa del, \"Salt Lake\", är länet. \"Utah\" är staten och \"USA\" är landet. Det är viktigt att notera varje plats eftersom släktregister förvaras av regeringarna på varje nivå.<br /><br />Om en nivå på platsen är okänd bör du lämna ett mellanslag mellan komma. Anta, i exemplet ovan kände du inte länet för Salt Lake City. Du bör sedan spela in det så här: \"Salt Lake City, , Utah, USA\". Antag att du bara vet att en person föddes i Utah. Du anger informationen så här: \", , Utah, USA\".<br /><br />Du kan använda länken <b>#pgv_lang[find_place]#</b> för att hitta platser som redan finns i databasen.";
$pgv_lang["edit_LATI_help"]			= "~#factarray[LATI]#~<br /><br />Inmatning av specifika koordinater för latitud och longitud avskräckas i allmänhet eftersom det endast tillåter mappning av åtkomst från utsikten över det specifika elementet. Det är bättre att hantera de geografiska platserna.<br /><br />Inmatning av latitud och longitud medger dock en mer exakt placering av markören.";
$pgv_lang["edit_LONG_help"]			= "~#factarray[LONG]#~<br /><br />Inmatning av specifika koordinater för latitud och longitud avskräckas i allmänhet eftersom det endast tillåter mappning av åtkomst från utsikten över det specifika elementet. Det är bättre att hantera de geografiska platserna.<br /><br />Inmatning av latitud och longitud medger dock en mer exakt placering av markören.";
$pgv_lang["edit_add_parent_help"]	= "~LÄGG TILL MOR ELLER FAR~<br /><br />På denna sida kan du lägga till en mor eller far till den valda personen. Fyll i den nya personens namn och födelse och dödsdatum om de är kända. Om du inte känner till någon av informationen, lämna fältet tomt.<br /><br />För att lägga till fler fakta förutom födelse och dödsdatum, lägg först till personen till databasen genom att spara ändringarna. Klicka därefter på personens namn på den uppdaterade familje sidan eller #pgv_lang[relatives]#-fliken för att visa personens  #pgv_lang[indi_info]# sida. Från  #pgv_lang[indi_info]# sidan kan du lägga till mer detaljerad information.";
$pgv_lang["edit_add_spouse_help"]	= "~LÄGG TILL MAKE ELLER MAKA~<br /><br />På denna sida kan du lägga till en make eller maka till den valda personen. Fyll i den nya personens namn och födelse och dödsdatum om de är kända. Om du inte känner till någon av informationen, lämna fältet tomt.<br /><br />För att lägga till fler fakta förutom födelse och dödsdatum, lägg först till personen till databasen genom att spara ändringarna. Klicka därefter på personens namn på den uppdaterade familje sidan eller #pgv_lang[relatives]#-fliken för att visa personens  #pgv_lang[indi_info]# sida. Från  #pgv_lang[indi_info]# sidan kan du lägga till mer detaljerad information.";
$pgv_lang["edit_death_help"] = "~#pgv_lang[death]#~<br /><br />Detta fält tillåter att du skriver in dödsinformation. Skriv först in datum när personen dog i genealogiskt standardformat (1&nbsp;JAN&nbsp;2004). Du kan klicka på kalenderikonen för hjälp med att välja datum. Skriv sedan in platsen var personen dog. Du kan använda <b>#pgv_lang[find_place]#</b>-länken för att hitta platser som redan finns i databasen.";
$pgv_lang["edit_birth_help"] = "~#pgv_lang[birth]#~<br /><br />Detta fält tillåter att du skriver in födelseinformation. Skriv först in datum när personen föddes i genealogiskt standardformat (1&nbsp;JAN&nbsp;2004). Du kan klicka på kalenderikonen för hjälp med att välja datum. Skriv sedan in platsen var personen dog. Du kan använda <b>#pgv_lang[find_place]#</b>-länken för att hitta platser som redan finns i databasen.";
$pgv_lang["edit_sex_help"]	= "~#pgv_lang[sex]#~<br /><br />Välj det korrekta könet från rullgardinsmenyn. <b>Okänt</b>-valet visar på att könet inte är känt.";
$pgv_lang["edit_name_help"]	= "~#pgv_lang[name]#~<br /><br />Detta är det viktigaste fältet i personen namnpost.<br /><br />Detta fält ska fyllas i automatiskt medan de andra fälten fylls i, men visas så att du kan redigera inforamtionen enligt dina egna önskemål.<br /><br />Namnet i fältet ska skrivas in enligt GEDCOM 5.5.1 standarden med snedsträck \"/\" före och efter efternamnet. Som ett exempel ska namnet \"John Robert Finlay Jr.\" ska skrivas in som: \"John Robert /Finlay/ Jr.\".";
$pgv_lang["edit_surname_help"]		= "~#pgv_lang[surname]#~<br /><br />I det här fältet ska du ange personens efternamn. Som exempel, i namnet \"John Robert Finlay\" är efternamnet som ska anges här \"Finlay\"<br /><br />Personer med flera efternamn, vanliga i Spanien och Portugal, bör separera efternamnen med ett komma. Detta indikerar att personen ska listas under vart och ett av namnen. Till exempel kommer efternamnet \"Cortes,Vega\" att listas under både <b>C</b> och <b>V</b>, medan efternamnet \"Cortes Vega\" bara kommer att listas under <b>C</b>.";
$pgv_lang["edit_NICK_help"]	= "~#factarray[NICK]#~<br /><br />I detta fältet ska du skriva in alla smeknamn för personen. Detta är ett vafritt fält.<br /><br />Olika sätt att lägga till smeknamn är:<ul><li>Välj <b>Ändra namn</b> skriv in smeknamn och spara sedan</li><li>Välj <b>Lägg till nytt namn</b> Skriv in smeknamn OCH namn spara sedan</li><li>Välj <b>redigera GEDCOM-post</b> för att lägga till multipla [2&nbsp;NICK]-poster under huvudposten [1&nbsp;NAME].</li></ul>";
$pgv_lang["edit_given_name_help"]	= "~#pgv_lang[given_name]#~<br /><br />I detta fält ska personens förnamn skrivas in. Som exempel ska \"John Robert Finlay\"s förnamn skrivas in som \"John Robert\"";
$pgv_lang["edit_NPFX_help"]			= "~#factarray[NPFX]#~<br /><br />Detta valfria fält låter dig ange ett namnprefix som <i>Dr.</i> eller <i>Adm.</i><br /><br />Adelstitlar som <i>Sir, Lord, Baron, Earl, Hertig, Graf, Freiherr,</i> etc. anges som ett faktum «#factarray[TITL]#».";
$pgv_lang["edit_NSFX_help"]			= "~#factarray[NSFX]#~<br /><br />Detta valfria fält låter dig ange ett namnsuffix som <i>Jr., Sr., III, IV,</i> etc. och akademisk information som <i>PhD, PEng, FImechE, DVM, MD,</i> osv.";
$pgv_lang["edit_add_child_help"]	= "~#pgv_lang[add_child]#~<br /><br />På denna sida kan du lägga till barn för den valda familjen. Fyll i barnets namn och födelse och dödsdatum om de är kända. Om du inte känner till någon av informationen, lämna fältet tomt.<br /><br />För att lägga till fler fakta förutom födelse och dödsdatum, lägg först till barnet till databasen genom att spara ändringarna. Klicka därefter på personens namn på den uppdaterade familjesidan eller #pgv_lang[relatives]#-fliken för att visa personens  #pgv_lang[indi_info]# sida. Från  #pgv_lang[indi_info]# sidan kan du lägga till mer detaljerad information.";

$pgv_lang["review_changes_help"]	= "~#pgv_lang[review_changes_block]#~<br /><br />Detta blocket listar alla poster som har ändrats online och som behöver kontrolleras och accepteras för att komma in i databasen.";
$pgv_lang["quick_update_name_help"] = "~#pgv_lang[update_name]#~<br /><br />Använd \"Uppdatera namn\"-fältet för att ändra namn på den person du redigerar. I förnamnsfältet dkriver du in personens förnamn. I Efternamnsfältet skriver du in efternamnet. T.ex. om namnet du vill skriva in är \"John Robert Finlay\" Du skriver du in \"John Robert\" i förnamnsfältet och \"Finlay\" i efternamnsfältet.<br /><br />Om man fyller i dessa fält kommer du att <u>ändra</u> namnet för personen det kommer inte att lägga till ett nytt namn.<br /><br /><i>OBS: Du ska <u>inte</u> använda denna metod om namnet ändras pga ett nytt gifte. Använd istället valet att lägga till ny make/maka nedan.</i>";
$pgv_lang["quick_update_fact_help"] = "~#pgv_lang[update_fact]#~<br /><br />Använd \"Uppdatera fakta\"-fältet för att lägga till ny fakta eller ändra existerande fakta för personen du redigerar. Välj först en fakta från rullgardinsmenyn. Skriv sedan in datum när händelsen ägde rum på det genealogiska standardformatet (1&nbsp;JAN&nbsp;2004). Du kan klicka på kalenderikonen för hjälp att välja datum. Skriv sedan i orten där händelsen inträffade. Du kan använda <b>#pgv_lang[find_place]#</b>-länken för att välja platser som redan finns i databasen.<br /><br />Som med de andra fälten in detta formuläret kommer informationen antingen ersätta den gammla eller skapa ny om det behövs.";
$pgv_lang["quick_update_address_help"] = "~#pgv_lang[update_address]#~<br /><br />Använd <b>#pgv_lang[update_address]#</b> fältet för att ändra adress, telefonnummer eller epostadress för personen du redigera.<br /><br />Som med alla andra fält i detta formuläret kommer din information att ersätta den gammla eller skapa ny om det behövs.";
$pgv_lang["quick_update_spouse_help"] = "~LÄGG TILL MAKE ELLER MAKA~<br /><br />På denna sida kan du lägga till en mor eller far till den personen du redigerar. Fyll i den nya personens namn och födelsedatum och skriv sedan datum för vigseln under vigselinformation. Skriv in datum på det genealogiska standardformatet (1&nbsp;JAN&nbsp;2004). Du kan klicka på kalenderikonen för hjälp att välja datum. Du kan använda <b>#pgv_lang[find_place]#</b>-länken för att välja platser som redan finns i databasen.<br /><br />Dessa fälten kommer bara att lägga till en <i>ny</i> partner, de kommer inte att uppdatera informationen för en gammal. För att redigera informationen för någon som redan finns sparad, stäng detta fönster och klicka på personens namn på #pgv_lang[relatives]#-fliken. Klicka sedan på redigera personmenyn för att redigera informationen.";
$pgv_lang["quick_update_marriage_help"] = "~UPPDATERA VIGSEL~<br /><br />Du kan använda detta fält tillsammans med fälten för att lägga till ny make/maka om du vill spara en ny vigsel. Annars kommer detta fält att ändra informationen i personens senaste vigsel. Skriv in datum på det genealogiska standardformatet (1&nbsp;JAN&nbsp;2004). Du kan klicka på kalenderikonen för hjälp att välja datum. Skriv sedan i orten för vigseln. Du kan använda <b>#pgv_lang[find_place]#</b>-länken för att välja platser som redan finns i databasen.";
$pgv_lang["quick_update_child_help"] = "~#pgv_lang[add_new_chil]#~<br /><br />Använd dessa fält för att lägga till ett nytt barn till personen. Skriv först in barnets namn och välj kön. Skriv sedan in datum och plats var barnet är fött. Skriv in datum på det genealogiska standardformatet (1&nbsp;JAN&nbsp;2004). Du kan klicka på kalenderikonen för hjälp att välja datum. Du kan använda <b>#pgv_lang[find_place]#</b>-länken för att välja platser som redan finns i databasen.<br /><br />Dessa fälten kommer bara att lägga till en <i>nytt</i> barn, de kommer inte att uppdatera informationen för barn som redan är inskrivna. För att redigera informationen för någon som redan finns sparad, stäng detta fönster och klicka på personens namn på #pgv_lang[relatives]#-fliken. Klicka sedan på redigera personmenyn för att redigera informationen.";
$pgv_lang["index_top10_pageviews_help"]		= "~#pgv_lang[top10_pageviews]#~<br /><br />Detta block kommer att lista de mest besökta personer, familjer eller källor av besökare på sajten. För att detta blocket ska visas måste sjatadministratören sätta på träffräknaren.";
$pgv_lang["index_cookiepolicy_help"]		= "~#pgv_lang[block_cookiepolicy]#~<br /><br />Detta block visar cookiepolicyn på denna webbplats.";
$pgv_lang["cookiepolicy_link_help"]			= "~#pgv_lang[block_cookiepolicy_link]#~<br /><br />Lämna fältet tomt om du vill använda standardtexten.<br /><br />Om du vill använda standardtexten och även tillhandahålla en länk till en textfil eller HTML sida som innehåller information om cookiepolicyn som är specifik för din webbplats kan du ange webbadressen till sidan här.<br /><br />Till exempel kan <b>http://foo.bar.com/policy/cookies.txt</b> peka på en vanlig textfil, medan <b>http://foo.bar.com/policy/cookies.htm</b> pekar på en HTML-formaterad sida och <b>http://foo.bar.com/policy/cookies.doc</b> pekar på ett dokument i Microsoft Word-format.";
$pgv_lang["cookiepolicy_link_advice"]		= "Lämna tomt för att använda standardtexten.<br /><br />Ange en webbadress som <b>http://foo.bar.com/policy/cookies.txt</b> för att peka på en webbplatsspecifik policysida.";
$pgv_lang["useradmin_user_default_tab_help"]	= "~#pgv_lang[user_default_tab]#~<br /><br />Denna inställning gör att du kan specificera vilken flik son öppnas automatiskt när du kommer till #pgv_lang[indi_info]# sidan. Om användarna tillåts att redigera sina kontoinställningar kan han ändra denna inställning senare.";
$pgv_lang["edituser_user_default_tab_help"]	= "~#pgv_lang[user_default_tab]#~<br /><br />Denna inställning tillåter dig att specifera vilken flik som är standard när du tittar på ansedeln för en individ.";
$pgv_lang["reorder_children_help"]		= "~#pgv_lang[reorder_children]#~<br /><br />Barn visas i den ordning de visas i familjeposten. Barn sorteras inte automatiskt efter födelsedatum eftersom ofta vissa av barnens födelsedatum är osäkra men ordningen på deras födelse <u>är</u> känd.<br /><br />Med det här alternativet kan du ändra ordningen på barnen inom familjen. Eftersom du kanske vill sortera barnen efter deras födelsedatum finns det en knapp som du kan trycka på för att göra detta åt dig.<br /><br />Du kan också dra och släppa vilken informationsruta som helst för att ändra ordningen på barnen. När du flyttar muspekaren över en informationsruta ändras dess form till ett par dubbelhåriga korsade pilar. Om du håller ned vänster musknapp innan du flyttar muspekaren följer informationsrutan muspekaren uppåt eller nedåt i listan. När informationsrutan flyttas kommer de andra rutorna att göra plats. När du släpper vänster musknapp tar informationsrutan sin nya plats i listan.";
$pgv_lang["rss_feed_help"]				= "~#pgv_lang[rss_feeds]#~<br /><br />ATOM / RSS-flödet tillgängligt i PhpGedView tillåter vem som helst att se innehållet på din webbplats välkomstsida utan att besöka webbplatsen med hjälp av en lämplig foderaggregat. De flesta aggregatorer dyker upp ett meddelande som låter användaren veta när något har ändrats på en sida som övervakas. Detta tillåter i princip vem som helst att övervaka din PhpGedView-webbplats utan att behöva besöka den regelbundet.<br /><br />Matningsblocket används för att anpassa länken till flödet, vilket möjliggör specifika matningstyper (de flesta läsare kan hantera de flesta typer så att detta vanligtvis kan lämnas som standard) och den specifika modul du vill ha i ditt flöde. Matningsspråket och GEDCOM som används kommer att baseras på språket och GEDCOM som är aktivt i PhpGedView när du väljer flödet.<br /><br />De typer av flöden som kan genereras inkluderar ATOM, RSS 2.0, RSS 1.0, RSS 0.92, HTML och JavaScript. De första fyra typerna är avsedda för flödesaggregatörer, medan JavaScript och HTML är avsedda att möjliggöra inkludering av flödena på andra webbsidor. Observera att numren på RSS-flödet indikerar olika stilar, inte en annan version.<br /><br />Det finns ett alternativ att välja autentisering som loggar in användaren och låter användaren se, med hjälp av en lämplig RSS-aggregator, all information som han normalt kan se om den är inloggad. Grundläggande autentisering använder <i>Basic HTTP Authentication</i> för att logga in användaren. Framtida förbättringar kan tillåta <i>Digest Authentication</i>.<br /><br />Denna <a href='https://sv.wikipedia.org/wiki/RSS' target='_blank' alt='Wikipedia artikel' title='Wikipedia artikel'><b>Wikipedia artikel</b></a> innehåller omfattande information och länkar om RSS och olika RSS-format.<i>Basic HTTP Authentication</i> diskuteras i detta <a href='https://en.wikipedia.org/wiki/Basic_authentication_scheme' target='_blank' alt='Wikipedia artikel' title='Wikipedia artikel'><b>Wikipedia artikel</b></a>, medan <i>Digest Authentication</i> diskuteras i detta <a href='https://en.wikipedia.org/wiki/Digest_access_authentication' target='_blank' alt='Wikipedia artikel' title='Wikipedia artikel'><b>Wikipedia artikel</b></a>.";

$pgv_lang["upload_media_help"]	= "~#pgv_lang[upload_media]#~<br /><br />Välj filer från din lokala dator som ska laddas upp till din server. Alla filer kommer att laddas upp till mappen <b>#MEDIA_DIRECTORY#</b> eller til en av dess undermappar.<br /><br />Mappnamnen som du angav kommer att läggas till <b>#MEDIA_DIRECTORY#</b>. T.ex. <b>#MEDIA_DIRECTORY#myfamily</b>. Om miniatyrbildsmappen inte finns kommer den att skapas automatiskt.";
$pgv_lang["upload_media_folder_help"]	= "~#pgv_lang[folder]#~<br /><br />Din GEDCOM-konfiguration tillåter upp till #GLOBALS[MEDIA_DIRECTORY_LEVELS]# mappnivåer utöver standard <b>#GLOBALS[MEDIA_DIRECTORY]#</b> där uppladdade mediefiler normalt lagras.<br /><br />I detta fält specificerar du destinationsmappen på din server var den uppladdad filen ska sparas. Var nogrann och kontrollera små och stora bokstäver för vad du skriver eller väljer här, eftersom fil och mappnamn kan kräva att det är korrekt stavat med små och stora bokstäver.<br /><br />Om mappnamnet du skriver in här inte finns kommer det att skapas. Om du skriver in fler än det tillåtna antalet #GLOBALS[MEDIA_DIRECTORY_LEVELS]# mappnivåer tillåtna, kommer de extra nivåerna att ignoreras.<br /><br />Miniatyrbilder kommer att laddas upp eller skapas i en identisk mappstruktur som startar med <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.";
$pgv_lang["upload_media_file_help"]		= "~#pgv_lang[media_file]#~<br /><br />I detta fält skriver du in platsen och namnet på filen på din lokala dator som du vill ladda upp. Du kan använda <b>Browse</b>-knappen för att söka efter den önskade filen på din lokala dator.<br /><br />Den uppladdade filen kommer att ha samma namn på servern och den kommer att ladda upp i mappen specificerad i <b>#pgv_lang[folder]#</b> fältet. Om du inte ser detta fält kan du inte ändra det, din GEDCOM-konfiguration är satt att inte tillåta några nivåer lägre än <b>#GLOBALS[MEDIA_DIRECTORY]#</b> där uppladdade mediafiler normalt sparas.<br /><br />Du kan lämna detta fält blankt om du vill ladda upp endast en miniatyrbild och vill att den filen också ska användas som huvudbild.";
$pgv_lang["upload_thumbnail_file_help"]	= "~#pgv_lang[thumbnail]#~<br /><br />I detta fält skriver du in platsen och namnet på miniatyrfilen på din lokala dator som du vill ladda upp. Du kan använda <b>Browse</b>-knappen för att söka efter den önskade filen på din lokala dator. När detta fält är ifyllt kommer <b>#pgv_lang[auto_thumbnail]#</b>-kryssrutan att ignoreras.<br /><br />Om fältet <b>#pgv_lang[media_file]#</b> är ifyllt kommer din uppladdade miniatyrfil att namnges efter det som står i fältet utan hänsyn till vad filen heter på din lokala dator. Om fältet lämnas tomt kommer den uppladdade filen att kopieras till två ställen på servern, en kopia till servermappen nämnd in <b>#pgv_lang[folder]#</b>-fältet och sedan en kopia till den identiska mappstrukturen som startar med <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />Om du inte ser <b>#pgv_lang[folder]#</b>-fältet ellre inte kan ändra det, din GEDCOM-konfiguration är satt att inte tillåta några nivåer lägre än <b>#GLOBALS[MEDIA_DIRECTORY]#</b> där uppladdade mediafiler normalt sparas.";


//-- GENERAL
$pgv_lang["help_header"]			= "Information om:";
$pgv_lang["privacy_error_help"]			= "~PRIVAT DETALJER~<br /><br />Det finns flera tänkbara orsaker för detta meddelande:<br /><ul><li><b>Information om levande personer är satt till \"Privata\".</b><br />Oregistrerade besökare och besökare som inte är inloggade kan endast se fullständig information om döda personer. Om Systemadministratören tillåter det, registera dig som användare genom att klicka på \"logga in\"-knappen, sedan på länken #pgv_lang[requestaccount]#.</li><li><b>Du är en beökare med användarnamn och lösenord...</b><br />men du har glömt att logga in eller har varit inaktiv för länge.</li><li><b> Informationen är satt till \"Privat\"</b><br />Personen som du klickade på har bett adminstratören att bli behandlad som \"Privat\" eller att inte synas alls(Dold).<br />Integriteten kan sättas till:<ul><li>#pgv_lang[PRIV_USER]#</li><li>#pgv_lang[PRIV_NONE]#</li><li>#pgv_lang[PRIV_HIDE]#</li></ul></li><li><b>Utanför Släktleden</b><br />Även om du är en registrerad användare <u>och</u> inloggad kan det ändå hända att du ser detta meddeladet.<br />Administratören kan sätta begränsningar på hur avlägsna släktingar man får se.<br /><br />Exempel:<br />När längden på släktskapsförhållande är satt till <b>1</b> kan du endast se detaljer för din egen familj, inte på ingifta eller dina syskons barn.<br /><br />När längden på släktskapsförhållande är satt till <b>2</b> kan du dessutom se din brors fru och deras barn men inte barnens respektive.<br /><br />Ju högre längden är satt ju fler avlägsna släktingar kan du se.</li></ul>Om du tycker att du har rätt att se vissa detaljer bör du kontakta adminstratören eller klicka på \"kontakta\"-länken.";
$pgv_lang["more_help"]				= "Om du vill ha kontext hjälp tillgänglig, kontrollera att <b>#pgv_lang[show_context_help]#</b> är påslagen, och klicka på <b>?</b> efter ämnet.";
$pgv_lang["start_admin_help"]			= "+++ Början av extra administratörsinformation +++";
$pgv_lang["end_admin_help"]			= "--- Slut på extra administratörsinformation ---";
$pgv_lang["multiple_help"]			= "<span class='center'>--- Detta är en generell hjälptext för flera sidor ---</span>";
$pgv_lang["header_general_help"]		= "<div class='name_head center'><b>ALLMÄN INFORMATION</b></div>";
$pgv_lang["best_display_help"]			= "~#pgv_lang[resolution]#~<br /><br />PhpGedView är utvecklad för en skärmupplösning på 1024x768 punkter. Detta bör vara minsta storlek för att allt ska visas korrekt.<br /><br />Om du har en lägre upplösning (t.ex. 800x600 punkter), kommer du behöva scrolla horisontellt.";
$pgv_lang["preview_help"]			= "~#pgv_lang[print_preview]#~<br /><br />Om du klickar på <b>#pgv_lang[print_preview]#</b> tas de objekt som inte ser bra ut på en utskriven sida bort (menyer, inmatningsrutor, extra länkar, frågetecknen för kontexthjälpen, etc.)<br /><br />Du får en knapp <b>#pgv_lang[print]#</b> längst ner på den förenklade sidan; när du klickar på den här knappen visas systemets utskriftsdialogruta. Efter utskrift klickar du på <b>#pgv_lang[cancel_preview]#</b> och skärmen kommer att byggas om normalt.<br /><br />Obs: Även om det här alternativet tar bort många länkar från den visade sidan är de återstående länkarna fortfarande aktiva.";
$pgv_lang["readme_help"]			= "<span class='center'>Se <a href=\"readme.txt\"=\"_blank\"><b>Readme.txt</b></a> för ytterligare information.</span>";
$pgv_lang["is_user_help"]			= "--- Denna hjälptext är samma för administratörer, användare och besökare. ---<br />--- För att spara plats, har vi inte gjort någon speciell administratörstext för denna artikel. ---";
$pgv_lang["edit_raw_gedcom_help"]	= "~#pgv_lang[edit_raw]#~<br /><br />När du klickar på denna länk, ett nytt fönster kommer att öppnas med den råa GEDCOM-datan angånde detaljerna på denna sida.<br /><br />Här kan du redigera GEDCOM-datan direkt. försäkra dig om att du skriver in korrekt GEDCOM 5.5.1 data, eftersom ingen validitetskontroll kommer att göras.<br />Den ändrade eller tillagda datan kommer att visas i PhpGedView som ändringar och måste godkännas av en användare med acceptera rättigheter.";
$pgv_lang["RESN_help_title"]		= "sätta restriktioner på fakta";
$pgv_lang["RESN_help"]				= "~#pgv_lang[RESN_help_title]#~<br /><br />Förutom generalla integritetsinställnignar kan PhpGedView sätta restriktioner för visning och redigering av fakta för personer och familjer. Restriktionerna kan sättas av alla som kan redigera informationen, förutom om integritets eller tidigare satta restriktioner förhindrar detta.<br /><br />Följande värde kan användas:<br /><ul><li><b>#pgv_lang[none]#</b><br/>Sajtadminstratören, GEDCOM-adminstratören och användare som har rättigheter att redigera kan ändra informationen. Faktainformationen kan ses enligt integritetsinställningar satta av administratören.</li><li><b>#pgv_lang[locked]#</b><br />Denna inställning har ingen påverkan på synligheten av datan. Den sätter redigeringsrättighter till sajtadministratörer eller GEDCOM-administratörer. Om informationen berör honom själv kan han också se och om han har redigeringsrättighter, redigera dem.</li><li><b>#pgv_lang[privacy]#</b><br />Den sätter visnings och redigeringsrättighter till sajtadministratörer eller GEDCOM-administratörer. Om informationen berör användaren själv kan han också se och om han har redigeringsrättighter, redigera dem. Den kommer att var dold för alla andra användare oberoende av deras inloggningsstatus.</li><li><b>#pgv_lang[confidential]#</b><br />Den sätter visnings och redigeringsrättighter till sajtadministratörer eller GEDCOM-administratörer. Den kommer att var dold för alla andra användare oberoende av deras inloggningsstatus.</li></ul><br /><table><tr><th></th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Admin</th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Ägare</th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Andra</th></tr><tr><th></th><th></th><th>L</th><th>R</th><th></th><th>L</th><th>R</th><th></th><th>L</th><th>R</th></tr><tr><td><img src=\"images/RESN_none.gif\" alt=\"\" />&nbsp;#pgv_lang[none]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_locked.gif\" alt=\"\" />&nbsp;#pgv_lang[locked]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /><th></th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_privacy.gif\" alt=\"\" />&nbsp;#pgv_lang[privacy]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_confidential.gif\" alt=\"\" />&nbsp;#pgv_lang[confidential]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr></table><ul><li>L : kan läsa</li><li>R : kan redigera</li><li><img src=\"images/checked_qm.gif\"/> : beror på globala integritetsinställningar</li></ul>";


//-- Pages Help-messages
//-- Index-page
$pgv_lang["index_help"]				= "~#pgv_lang[welcome_page]#~<br /><br />Denna sida är välkomstsidan. Den välkomnar dig till den valda <a href=\"#def_gedcom\">GEDCOM</a> filen. Du kan återvända till denna sida genom att välja välkomstsidan i toppmenyn. Om det finns flera GEDCOM-filer på denna sajt, kan du välja en GEDCOM-fil från rullgardinsmenyn.<br /><br />Du kan hitta information om:<ul><li><a href=\"#index_portal\"><b>Välkomstsidan</b></a><li><a href=\"#header\"><b>Rubrikområden</b></a><li><a href=\"#menu\"><b>Menyer</b></a><li><a href=\"#header_general\"><b>Allmän information</b></a><li><a href=\"#def\"><b>Definitioner</b></a></ul><br />Version #VERSION# kommer med ett nytt utseende för <a href=\"#def_pgv\">PhpGedView</a>. Menyer, startsidan och många andra funktioner är förbättrade och/eller omgjorda.";

//-- Index-page Header
$pgv_lang["header_help"]			= "<div class='name_head center'><b>#pgv_lang[header]#</b></div><br />Rubriken är översta delen av sidan och återkommer på alla sidor.<br />Rubriken innehåller värdefulla länkar som du kan använda överallt.<br />Eftersom sajten kan ha olika utseende beroende av det valda <a href=\"#def_theme\">temat</a>, rubriker kan påverkas och länkar kan variera.<br /><br />Länkar som du kanske hittar är:<ul><li><a href=\"#header_search\"><b>#pgv_lang[search]#</b></a></li><li><a href=\"#header_lang_select\"><b>#pgv_lang[change_lang]#</b></a></li><li><a href=\"#header_user_links\"><b>#pgv_lang[login]#</b></a></li><li><a href=\"#header_favorites\"><b>#pgv_lang[my_favorites]#</b></a></li><li><a href=\"#header_theme\"><b>#pgv_lang[change_theme]#</b></a></li></ul>";
$pgv_lang["header_search_help"]			= "~#pgv_lang[header]# «#pgv_lang[search]#»~<br /><br />Denna sökbox är liten men kraftfull. Du kan låta PhpGedView söka efter nästan vad som helst. När du klickar på <b>&gt;</b> eller <b>Sök</b> knappen, kommer du till huvudsidan för sökning, för att där se resultatet av din sökning.<br />Du kommer att hitta utökad hjälp för sökning på huvudsidan för sökning.";
$pgv_lang["header_lang_select_help"]		= "~#pgv_lang[header]# «#pgv_lang[change_lang]#»~<br /><br />En av de viktigaste funktionerna för PhpGedView är flerspråksstödet och att språk ställs in automatiskt för varje besökare efter webläsarens inställning.<br /><br />Ibland kan det hända att bytet inte sker automatiskt på det sätt som besökare förväntar sig (t.ex. genom att det språk man föredrar inte är korrekt inställt in din nätbläddrare). Adminstratören kan vbegränsa tillgången till visa språk.<br /><br />Beroende på sajtkonfigurationen kan du ändra språket i PhpGedView genom att välja ett passande språk från rullgardinsmenyn eller genom att klicka på en flaggikon. Om du är en registrerad användare, kan du konfigurera PhpGedView att byta till ditt önskade språk efter inloggning, oberoende av din webläsares inställning.";
$pgv_lang["header_user_links_help"]		= "~#pgv_lang[header]# «#pgv_lang[login]#»~<br /><br />Användarlänkar är ett litet blocket med användbara länkar, som användare kan hitta på samma ställe överallt på hela sajten (så länge som användaren inte ändrar tema).<br /><br />När man inte har loggat in, syns bara <b>Logga in</b>-länken. När du är inloggad kommer du att se:<ul><li><b>Inloggad som (ditt användarnamn)</b>. Om du klickar på den länken kommer du till ditt konto.</li><li><b>Logga ut</b> är uppenbar: den gör exakt det.</li><li>Om du har administratörsrättighter kommer du också se <b>Admin</b>. Om du klickar på den länken kommer du direkt till Administrationshuvudsidan.</li></ul>";
$pgv_lang["header_favorites_help"]		= "~#pgv_lang[header]# «#pgv_lang[gedcom_favorites]#»~<br /><br />Denna listbox kommer att visa dig dina favoriter som du (kan) har valt på din Personliga portal. Den visar också sajtadminstratörens valda favoriter för den aktiva GEDCOM-filen. Klicka på på en av dina favoriter, kommer att föra dig direkt till #pgv_lang[indi_info]#-sidan för den personen.<br /><br />Mer hjälp för att lägga till favoriter är tillgängliga i den personliga portal.";
$pgv_lang["header_theme_help"]			= "~#pgv_lang[header]# «#pgv_lang[change_theme]#»~<br /><br />När den är aktiverad av webbplatsadministratören visar listan Ändra tema en lista över de teman som du kan använda för att visa webbplatsen.<br /><br />Du kan ändra utseendet på webbplatsen genom att välja ett tema från listan. . Om du är inloggad kommer det också att ändra ditt användartema till det du valt så att din nästa inloggning automatiskt väljer samma tema.";

//-- Index-page Menu
$pgv_lang["menu_help"]				= "<div class='name_head center'><b>MENYER</b></div><br />I sidhuvudena rullgardinsmenyer.<br /><br />Om du rör muspekaren över en menyikon ger dig en undermeny. Klickar du på menyikonen kommer du till sidan för det första valet i menyn.<br /><br />Du kan välja mellan följande huvudmenyer:<ul><li><a href=\"#menu_fam\"><b>#pgv_lang[welcome_page]#</b></a></li><li><a href=\"#menu_myged\"><b>#pgv_lang[mygedview]#</b></a></li><li><a href=\"#menu_charts\"><b>#pgv_lang[charts]#</b></a></li><li><a href=\"#menu_lists\"><b>#pgv_lang[lists]#</b></a></li><li><a href=\"#menu_annical\"><b>#pgv_lang[anniversary_calendar]#</b></a></li><li><a href=\"#menu_clip\"><b>#pgv_lang[clippings_cart]#</b></a></li><li><a href=\"#menu_search\"><b>#pgv_lang[search]#</b></a></li><li><a href=\"#menu_help\"><b>#pgv_lang[page_help]#</b></a></li></ul>";
$pgv_lang["menu_famtree_help"]			= "~#pgv_lang[welcome_page]#~<br /><br />Alla tillgängliga GEDCOM-filer för sajten är listade i denna meny. Alla GEDCOM-filer har sin egen skräddarsydda startsida, som den här. Om det bara finns en GEDCOM-fil på denna sajt så finns det ingen undermeny under välkomstsidans ikon.";
$pgv_lang["menu_myged_help"]			= "~#pgv_lang[mygedview]#~<br /><br />Om du är inloggad, hittar du dessa saker i menyn:<ul><li><b>#pgv_lang[mygedview]#</b><br />Denna för dig till din egen \"startsida\".</li><li><b>#pgv_lang[editowndata]#</b><br />Du kan redigera dina personliga data här.</li><li><b>#pgv_lang[my_pedigree]#</b><br />Om du har valt en startperson för denna GEDCOM, tar detta val dig till antavlan för den personen.</li><li><b>#pgv_lang[my_indi]#</b><br />Denna länk för dig till #pgv_lang[indi_info]#-sidan, där all genealogisk data finns för dig själv och din familj.</li></ul>";
$pgv_lang["menu_charts_help"]			= "~#pgv_lang[charts]#~<br /><br />Alla tillgängliga tavlor är listade i denna meny:<ul><li><a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a><br />Denna länk leder till antavlan för denna filen. Antavlan kommer att starta med probandet i GEDCOM-filen. När du är inloggad däremot kan probandet var du eller någon annan persom du valt.</li><li><a href=\"?help=help_descendancy.php\"><b>#pgv_lang[descend_chart]#</b></a><br />Stamtavlan är mer eller mindre en upp och ner vänd <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>.<br />Jämförelsen är inte riktigt korrekt, medan en antavla visar alla dina anor från en startperson, kommer stamtavlan att visa alla ättlingar efter en startperson.</li><li><a href=\"?help=help_timeline.php\"><b>#pgv_lang[timeline_chart]#</b></a><br />Här visar händelser för en person längs en tidsaxel.</li><li><a href=\"?help=help_relationship.php\"><b>#pgv_lang[relationship_chart]#</b></a><br />Här kan du kontrollera släktskapet mellan en personer med dig själv, eller med en annan person.</li><li><a href=\"?help=help_ancestry.php\"><b>#pgv_lang[ancestry_chart]#</b></a><br />Väldigt lik <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>, men med fler detlajer och alternativ <a href=\"?help=chart_style_help\"><b>#pgv_lang[chart_style]#</b></a> visning.</li><li><a href=\"?help=help_fanchart.php\"><b>#pgv_lang[fan_chart]#</b></a><br />Väldigt lik <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>, men mer grafisk.</li></ul>";
$pgv_lang["menu_lists_help"]			= "~#pgv_lang[lists]#~<br /><br />Följande listor är tillgängliga i denna meny:<ul><li><a href=\"?help=help_indilist.php\"><b>#pgv_lang[individual_list]#</b></a></li><li><a href=\"?help=help_famlist.php\"><b>#pgv_lang[family_list]#</b></a><br />I dessa två listor kan du lista personer eller familjer i denna GEDCOM i alfabetisk ordning.</li><li><a href=\"?help=help_sourcelist.php\"><b>#pgv_lang[source_list]#</b></a><br />Denna lista returnerar alla källor som används i GEDCOM-filen.</li><li><a href=\"?help=help_placelist.php\"><b>#pgv_lang[place_list]#</b></a><br />Här kan du leta efter personer utifrån orter.</li><li><a href=\"?help=help_medialist.php\"><b>#pgv_lang[media_list]#</b></a><br />Du kan endast se denna meny om den är tillgängliggjord av administratören. Den kommer att visa en länk till alla multimediafiler som används i GEDCOM-filen.</li></ul>";
$pgv_lang["menu_annical_help"]			= "~#pgv_lang[anniversary_calendar]#~<br /><br />#pgv_lang[anniversary_calendar]#  visar händelser i en GEDCOM-fil en bestämd dag, månad eller år.<ul><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewday]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewmonth]#</b></li><li></a><a href=\"?help=day_month_help\"><b>#pgv_lang[viewyear]#</b></a><br />Dessa menyval för dig till #pgv_lang[anniversary_calendar]# för att visa alla händelser för den valda dagen, månad eller år.</li></ul>";
$pgv_lang["menu_clip_help"]			= "~#pgv_lang[clippings_cart]#~<br /><br />Om tillgängliggjord av administratören för denna GEDCOM-fil, kommer du att se detta val i menyn.<br /><br />Urklippskorgen tillåter dig att välja personer, familjer och källor och spara dem som familjeträdurklipp i urklippskorgen så att du senare kan ladda ner dem i GEDCOM 5.5.1 format.";
$pgv_lang["menu_search_help"]			= "~#pgv_lang[search]#~<br /><br />Söksidan som du kommer till genom att klicka på denna länk, är den mer kraftfulla storebrodern till söklänken som du ibland kan se i huvudet på sidan.";
$pgv_lang["menu_help_help"]			= "~#pgv_lang[page_help]#~<br /><br />#pgv_lang[help_help_items]#";

//-- Index-page Portal
$pgv_lang["index_portal_head_help"]		= "<div class='name_head center'><b>#pgv_lang[welcome_page]#</b></div>";
$pgv_lang["index_portal_help"]			= "#pgv_lang[welcome_page]# består av flera separata block och kan skräddarsys. Så för varje GEDCOM-fil på sajten, på sajter där det finns mer än en, kan du få se olika välkomstsidan. Beroende på hur administratören har ställt in sajten kan du se följande block på denna välkomstsidan:<ul><li><a href=\"#index_welcome\"><b>#pgv_lang[welcome_block]#</b></a></li><li><a href=\"#index_login\"><b>#pgv_lang[login_block]#</b></a></li><li><a href=\"#index_events\"><b>#pgv_lang[upcoming_events_block]#</b></a></li><li><a href=\"#index_onthisday\"><b>#pgv_lang[todays_events_block]#</b></a></li><li><a href=\"#index_charts\"><b>#pgv_lang[charts_block]#</b></a></li><li><a href=\"#index_favorites\"><b>#pgv_lang[gedcom_favorites_block]#</b></a></li><li><a href=\"#index_stats\"><b>#pgv_lang[gedcom_stats_block]#</b></a></li><li><a href=\"#index_common_surnames\"><b>#pgv_lang[block_top10]#</b></a></li><li><a href=\"#index_media\"><b>#pgv_lang[random_media_block]#</b></a></li><li><a href=\"#index_loggedin\"><b>#pgv_lang[logged_in_users_block]#</b></a></li><li><a href=\"#gedcom_news\"><b>#pgv_lang[gedcom_news_block]#</b></a></li><li><a href=\"#recent_changes\"><b>#pgv_lang[recent_changes_block]#</b></a></li></ul>";
$pgv_lang["index_welcome_help"]			= "~#pgv_lang[welcome_block]#~<br /><br />Välkomstblocket visar aktuell databasrubrik, datum och tid och, om den är aktiverad av admin, Hit Counter.<br /><br />Hit Counter finns bara i välkomstblocket och på #pgv_lang[indi_info]# sida. Räknaren räknar träff på dessa sidor. Det betyder att det räknar hur många gånger dessa sidor besöks. Räknaren kontrollerar inte en besökares internetadress; varje besök på en sida från vilken som helst fjärrplats räknas som ett nytt träff.";
$pgv_lang["index_login_help"]			= "~#pgv_lang[login_block]#~<br /><br />Även om du kan logga in på nästan vilken sida som helst i programmet, vill du oftast logga in på första sidan, eftersom du endast kan komma åt tillåten information när du är inloggad.<br /><br />Du kan logga in genom att skriva ditt <b>#pgv_lang[username]#</b> och <b>#pgv_lang[password]#</b> och klicka på <b>#pgv_lang[login]#</b> knappen.";
$pgv_lang["index_events_help"]			= "~#pgv_lang[upcoming_events_block]#~<br /><br />Detta block visar dig årsdagar för händelser som kommer inom en snar framtid.<br /><br />Administratören bestämmer hur långt framåt blocket kommer att se ut. Du kan ytterligare förfina blockets visning av kommande händelser genom flera konfigurationsalternativ.<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["todo_help"] = "~#pgv_lang[todo_block]#~<br /><br />Detta block hjälper dig att hålla reda på <b>_TODO</b> uppgifter i databasen.<br /><br />För att lägga till Att göra uppgifter till dina poster kan du först behöva ändra GEDCOM-konfigurationen så att faktum <b>_TODO</b> finns i listan över fakta som kan läggas till i register över personer, familjer, källor och arkiv. Var och en av dessa listor, som du hittar i avsnittet Redigera Alternativ i GEDCOM-konfigurationen, är oberoende. Ordningen på listposterna är inte viktig; du kan lägga till de nya posterna i början av varje lista.";
$pgv_lang["todo_show_other_help"]     = "Visa uppgifter som tilldelats andra användare";
$pgv_lang["todo_show_unassigned_help"]= "Visa uppgifter som inte tilldelas någon användare";
$pgv_lang["todo_show_future_help"]= "Visa uppgifter som har ett datum i framtiden. Annars visas bara artiklar med ett datum tidigare.";
$pgv_lang["yahrzeit_help"]			="~#pgv_lang[yahrzeit_block]#~<br /><br />Detta block visar dig Yahrzeiten som kommer upp inom en snar framtid.<br /><br />Yahrzeiten (singularis: Yahrzeit) är årsdagar för en persons död. Dessa årsdagar observeras i den judiska traditionen; de används inte längre i andra traditioner. «Yahrzeit» kan också stavas som «Jahrzeit» eller «Yartzeit».<br /><br />Administratören bestämmer hur långt framåt blocket kommer att se ut. Blockets visning av kommande Yahrzeiten kan förfinas ytterligare genom konfigurationsalternativ.<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["days_to_show_help"]			= "~#pgv_lang[days_to_show]#~<br /><br /> Skriv in det antal dagar som ska visas. Man kan inte ange nummer högre än <b>#DAYS_TO_SHOW_LIMIT#</b>. Om du anger ett högre tal kommer den gränsen att användas.<br /><br />Begränsningen som visas är satt av administratören i GEDCOM-konfigurationen, Visa och Layout sektionen, Dölj & Visa undersektionen.";
$pgv_lang["random_media_persons_or_all_help"] = "~#pgv_lang[random_media_persons_or_all]#~<br /><br />Detta val låter dig välja vilken typ av media som ska visas.<br /><br />När du väljer <b>#pgv_lang[random_media_persons]#</b> kommer endast media associerad med personer att visas. Det äe vanligtvis personens fotografi. När du väljer <b>#pgv_lang[random_media_events]#</b> kommer endast media associerade med fakta eller händelser att visas. Det kan vara en bild av ett certifikat. När du väljer <b>#pgv_lang[all]#</b> kommer all media att visas.";
$pgv_lang["random_media_filter_help"] = "~#pgv_lang[filter]#~<br /><br />Du kan begränsa vad blocket Slumpmässiga Medier får visa enligt formatet och typen av mediaobjekt. När en viss kryssruta är markerad får blocket Slumpmässiga Medier visa medieobjekt av det formatet eller typen.<br /><br />Format- eller typkoder som finns i din databas men som inte finns i dessa kryssrutor antas ha motsvarande kryssruta. Till exempel, om din databas innehåller medieobjekt med formatet <b><i>pdf</i></b>, får blocket Slumpmässiga Medier alltid visa dem. På samma sätt, om din databas innehåller medieobjekt av typen <b><i>special</i></b>, får blocket Slumpmässiga Medier alltid visa dem.";
$pgv_lang["basic_or_all_help"]			= "~#pgv_lang[basic_or_all]#~<br /><br />Denna inställning låter dig tabort visa daterade händelser. T.ex. #factarray[DIV]#, #factarray[CREM]#, #factarray[GRAD]#, #factarray[BARM]#, #factarray[FCOM]#, etc. ska alla vara daterade.<br /><br />När du väljer <b>Ja</b> kommer endast födelse, döds och vigslar att visas. När du väljer <b>Nej</b> kommer alla händelser att visas.";
$pgv_lang["style_help"]					= "~#pgv_lang[style]#~<br /><br />Denna funktion kontrollerar hur informationen presenteras.<br /><br />När du väljer <b>#pgv_lang[style1]#</b>, visas informationen i textformat, liknande det du ser i de olika tavlornas rutor. Detta format är väl lämpat för block som skriver på högersidan av sidan.<br /><br />När du väljer <b>#pgv_lang[style2]#</b>, visas informationen i tabellform och lämpar sig bättre till de stora områdena som visas på vänstersidan av sidan.";
$pgv_lang["sort_style_help"]			= "~#pgv_lang[sort_style]#~<br /><br />Det här alternativet styr hur informationen sorteras.<br /><br />När du väljer <b>#pgv_lang[by_alpha]#</b> visas informationen i alfabetisk ordning. När du väljer <b>#pgv_lang[by_anniv]#</b>, ordnas informationen efter årsdagen, med de senaste jubileerna först.";
$pgv_lang["cal_dowload_help"]			= "~#pgv_lang[cal_download]#~<br /><br />Denna funktion kontrollerar om knappen för nerladdning av kalenderhändelser visas för inloggade användare. Den nerladdad kalenderfilen kan importeras i kompatibla program som Microsoft Outlook för att t.ex. generera automatiska e-postmeddelande för högtidsdagar.<br /><br />När du sätter den till <b>#pgv_lang[no]#</b>, kommer den inloggade användaren inte kunna ladda ner kalenderfilen. När du sätter den till  <b>#pgv_lang[yes]#</b>, visas nerladdningsknappen. Denna knapp visas aldrig för användare som inte är inloggade.";
$pgv_lang["cal_download_user_help"]			= "Om du är inloggad kan du se ikonen <img src='images/ical.png' alt='' />. Om du klickar på ikonen laddar du ner händelserna som en kalenderfil, som kan importeras till kompatibla program som Microsoft Outlook för att till exempel generera automatiska e-postpåminnelser om jubileer.<br /><br />Om du är inloggad och inte ser den här ikonen har administratören inaktiverat den här funktionen. Besökare som inte är inloggade ser inte denna ikon och kan inte ladda ner kalenderfilen.";
$pgv_lang["index_charts_help"]		= "~#pgv_lang[charts_block]#~<br /><br />Detta block gör att en stamtavla, ättling eller timglasstabell kan visas på välkomst- eller MyGedView-sidan. På grund av utrymmesbegränsningar bör diagrammen endast placeras till vänster på sidan.<br /><br />När detta block visas på välkomstsidan bestäms rotpersonen och typen av diagram som ska visas av administratören. När detta block visas på användarens personliga MyGedView-sida bestäms dessa alternativ av användaren.<br /><br />Uppförandet av dessa sjökort är identiskt med deras beteende när de anropas från menyerna. Klicka på rutan för en person för att se mer information om dem.";
$pgv_lang["index_onthisday_help"]		= "~#pgv_lang[todays_events_block]#~<br /><br />Detta blocket har fungerar på samma sätt som blocket #pgv_lang[upcoming_events_block]# det som skiljer är att här visas händelser för i dag.<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["index_favorites_help"]		= "~#pgv_lang[gedcom_favorites_block]#~<br /><br />Detta block är ungefär detsamma som #pgv_lang[user_favorites_block]# block på #pgv_lang[mygedview]# sidan. Med i detta fall, endast administratören, eller en användare med administratörsrättigheter, kan lägga till, ta bort, eller ändra favoriter.<br /><br />Syftet med detta block är att rikta besökarens uppmärksamhet på personer av särskilt intresse. På varje sida i på sajten, är \"Denna GEDCOMs favoriter\" tillgänglig från rullgardinsmenyn i rubrikblocket.<br /><br />Detta kommer att flytta dig till #pgv_lang[indi_info]#-sidan.";
$pgv_lang["index_add_favorites_help"]	= "~#pgv_lang[add_favorite]#~<br /><br />Detta formulär tillåter dig att lägga till ett nytt favoritobjekt till din lista över favoriter.<br /><br />Du måste skriva in antingen ett ID för personen, familjen eller källan som du vill lägga till som favorit elelr så lägger du till en URL och en titel. Anteckningsfältet är valfritt och kan användas för att beskriva favoriten. Det som skrivs in i antevkningsfältet kommer att visas favoritblocket efter objektet.";
$pgv_lang["index_stats_help"]			= "~#pgv_lang[gedcom_stats_block]#~<br /><br />I detta block kommer du att se lite statistik om den nuvarande GEDCOM-filen. Om du vill ha mer information kan du sända ett meddelande till kontakten längst ner på sidan.";
$pgv_lang["index_common_names_help"]	= "~#pgv_lang[block_top10]#~<br /><br />Detta block kommer att lista de vanligaste efternamnen, med ett antal för varje. Om du klickar på ett namn tar det dig till Personlistan, redan filtrerad efter det namn du klickade på.<br /><br />Administratören bestämmer hur många namn som faktiskt ska visas.";
$pgv_lang["index_common_given_names_help"]		= "~#pgv_lang[block_givn_top10]#~<br /><br />Detta block kommer att lista de vanligaste förnamnen. Det visar manliga och kvinnliga namn i kolumner. En tredje kolumn visas när det finns personer vars kön inte är känt.<br /><br />Administratören bestämmer hur många namn som faktiskt ska visas.";
$pgv_lang["index_media_help"]			= "~#pgv_lang[random_media_block]#~<br /><br />I detta blocket väljer PhpGedView slumpmässigt ut en mediafil vid varje besök på denna sida.<br /><br />Klicka på bilden eller på dess namn kommer att ge dig den fullskaliga versionen av bilden. Under bilden finns en länk till personen som har anknytningen till bilden. Klicka på personens namn och du kommer att förflyttas till denna #pgv_lang[indi_info]#-sida.";
$pgv_lang["index_loggedin_help"]		= "~#pgv_lang[logged_in_users_block]#~<br /><br />Detta blocket kommer att visa dig antalet användare som för tillfället är inloggade.<br /><br />Om du inte är administratör är din syn på inloggade användare begränsad till de som har valt att vara synliga medan de är online. För att detta ska fungera måste du också välja att vara synlig medan du är online. Onlineanvändare som är osynliga för dig räknas som anonyma.";
$pgv_lang["index_gedcom_news_help"]		= "~#pgv_lang[gedcom_news_block]#~<br /><br />Nyhetsblocket är som en anslagstavla för denna GEDCOM-fil. Administratören kan lägga upp viktiga meddelande eller intressanta nyheter här.<br /><br />Om du har något intressant att visa, kontakta administratören så kan han lägga upp ditt meddelande på anslagstavlan.";
$pgv_lang["recent_changes_help"]			= "~#pgv_lang[recent_changes_block]#~<br /><br />Detta blocket visar dig de senaste ändringarna som har gjorts i GEDCOM-filen enligt CHAN GEDCOM-taggen.";
$pgv_lang["gedcom_news_limit_help"]		= "Du kan begränsa antalet nyhetsartiklar som visas och därigenom minska höjden för GEDCOM-nyhetsblocket.<br /><br />Detta val bestämmer om det ska finnas någon gräns eller om gränsen ska vara efter ålder för nyheten eller efter antalet artiklar.";
$pgv_lang["gedcom_news_flag_help"]		= "Skriv in det begränsande värdet här.<br /><br />Om du har valt att begränsa visningen av nyheter via ålder, kommer alla artikler äldre än det antalet dagar du skriver in här att gömmas. Om du har valt att begränsa visningen av antalet nyhetsartiklar via antal, kommer endast det antalet som specificeras här, i åldersordning, att visas. De resterande artiklarna kommer att gömmas.<br /><br />Skriver du in nollor här kommer alla artiklar att visas.";
$pgv_lang["gedcom_news_archive_help"]	= "För att minska höjden på nyhetblocket har administratören dolt vissa artiklar, Du kan visa dessa dolda artiklar genom att klicka på <b>#pgv_lang[gedcom_news_archive]#</b>.";
$pgv_lang["index_htmlplus_help"]		= "~#pgv_lang[htmlplus_block_name]#~<br /><br />Detta blocket låter administratören att lägga till information till index eller portalsidan. Meningen med blocket är ungefär detsamma som med HTML, nyheter och GEDOM statistik blocket, men adminsitratören har mer kontroll över dess utseende.";
$pgv_lang["index_htmlplus_title_help"]	= "~#factarray[TITL]#~<br /><br />Denna text ska vara kort eller tom. När den är tom, kommer det avancerade HTML-blocket visas på index eller portal sidan som ett vanligt område. När det finns en text, kommer Avancerade HTML-blocket att visas som alla andra block komplett med rubrik som innehåller texten du skrivit in här.";
$pgv_lang["index_htmlplus_template_help"]	= "~#pgv_lang[htmlplus_block_templates]#~<br /><br />För att hjälpa dig komma igång med det blocket har vi skapat flera standardmallar. När du väljer en av de mallarna kommer textblocket att innehålla en kopia som du kan ändra så att den passar din sajt.";
$pgv_lang["index_htmlplus_content_help"]	= "~#pgv_lang[htmlplus_block_content]#~<br /><br />Till skillnad ifrån HTML, nyheter och GEDCOM-statistikblocket så har du full kontroll över utseendet på detta område. Du kan använda HTML-taggar och blocket använder CSS stilscheman ifrån det aktiva temat. Referenser till infromation i den aktiva databasen kan inkluderas i texten.<br /><br />Databasreferenser signalleras i texten genom att innesluta nyckelord inom par av <b>&#35;</b> symboler. T.ex <b>&#35;TOTAL_FAM&#35;</b> representerar antalet familjer i databasen. Du kanske ibland vill använda en databasreferens som text istället för dess igentliga mening. För att göra det måste du byta ut <b>&#35;</b> symbolerna som finns runt nyckelordet med deras symboliska motsvarighet. T.ex. om din text inehåller <b>&&#35;35;TOTAL_FAM&amp&#35;35;</b> kommer den att skrivas ut som <b>&#35;TOTAL_FAM&#35;</b> istället för att bli en databasreferens.<br /><br />För ett fullständigt exempel på användningen av detta block, vänligen undersök &quot;#pgv_lang[gedcom_stats_block]#&quot; mall som finns i blocks/ mappen använder den de flesta stilar av taggar, inklusive språk- och hjälptextlänkar.<br /><br />Mallen <b>#pgv_lang[htmlplus_block_keyword]#</b> innehåller en fullständig mall lista över alla stödda nyckelord.";
$pgv_lang["index_htmlplus_compat_help"]	= "~#pgv_lang[htmlplus_block_compat]#~<br /><br />Aktivera kompatibilitet med äldre versioner av detta block. När det är markerat kommer både gamla och nya sökord att kännas igen och agera.<br /><br />Till exempel kommer texten <b>&#35;TOTAL_FAM&#35;</b> att kännas igen som likvärdig med <b>&#35;totalFamilies&#35;</b>, <b>&#35;FIRST_DEATH_PLACE&#35;</b> till <b>&#35;firstDeathPlace&#35;</b>, <b>&#35;TOP10_BIGFAM&#35;</b> till <b>&#35;topTenLargestFamily&#35;</b>, etc.<br /><br />Om inte absolut nödvändigt ska du inte använda kompatibilitetsläge.";
$pgv_lang["index_htmlplus_gedcom_help"] = "~#pgv_lang[htmlplus_block_gedcom]#~<br /><br />Välj databasen för vilket nyckelorden avses.<br /><br />Din sajt stöder flera databaser. Nyckelord som <b>&#35;totalFamilies&#35;</b> kan endast referara till en databas. Du kan ange databas för som ska användas för dessa typer av nyckelord. Varje #pgv_lang[htmlplus_block_name]#-blocket kan endast accessa en databas.";
$pgv_lang["showUnknown_help"]	= "~#pgv_lang[showUnknown]#~<br /><br />Dölj eller visa listan med förnamn på personer av okänt kön.<br /><br />Blocket #pgv_lang[block_givn_top10]# döljer alltid listan med förnamn när inga personer av det könet finns i din databas. Detta alternativ låter dig dölja listan över personer av okänt kön även när det finns sådana personer i din databas.";

//-- Index-Page Help
$pgv_lang["help_help"]				= "Det hade förstås varit perfekt att göra ett program som är så enklet att det inte behöver några förklaringar alls. Det skulle vara lika enkelt som att läsa en bok.<br /><br />Även om programmet är ganska komplicerat så märker du inte det i användargrännsnittet. Nästan allt kan användas utan förklaring. Men eftersom vi har många besökare och användare som inte är så erfarna med att använda datorer eller internet så erbjuder vi hjälp lite hjälp på visa ställen.<br /><br />I hjälpmenyn hittar du följande artiklar:";
$pgv_lang["help_page_help"]			= "<ul><li><b>Hjälp med denna sida</b><br />För alla sidor finns det en allmän \"hjälpsida\" tillgänglig. När du är på en sida kan du klicka på denna artikel i menyn kommer du att få upp \"Sidhjälp\" som informera dig om artiklarna du kan hitta på just denna sida.<br /><br />Sidhjälpen är för det mesta kortfattad. Om du behöver mer hjälp, eller information, om en viss artikel på sidan så finns det tredje alternativet på hjälpmenyn: \"Kontextuell hjälp\".</li></ul>";
$pgv_lang["help_content_help"]			= "<ul><li><b>Hjälp innehåll</b><br />Om du klickar på denna meny får du upp hjälpfönstret, som visar ett index över de större hjälpartiklar.<br />Detta index kommer ha fler artiklar, inom en snar framtid, eftersom också de mindre hjälpartiklarna kommer att indexeras.</li></ul>";
$pgv_lang["help_faq_help"]			= "<ul><li><b>FAQ Lista</b><br />#pgv_lang[text_faq_help]#</li></ul>";
$pgv_lang["help_HS_help"]			= "<ul><li><b>#pgv_lang[hs_title]#</b><br />#pgv_lang[hs_intro]#</li></ul>";
$pgv_lang["help_qm_help"]			= "<ul><li><b>Dölj / Visa kontextuell hjälp</b><br />Det här sista menyalternativet kan vara det mest användbara för dig. Om du klickar på den här länken aktiveras eller inaktiveras \"Kontextuell hjälp\".<br /><br />Med kontextuell hjälp aktiverad kan du hitta ett frågetecken eller liknande ikon bredvid vissa länkar, rutor eller knappar. När du klickar på den här ikonen visas en hjälpskärm. Den här hjälpskärmen innehåller information om det objektet.<br /><br />Naturligtvis, när du klickar på \"Dölj kontextuell hjälp\" försvinner alla frågetecken eller ikoner tills du klickar på \"Visa ....\" igen.</li></ul>";

//-- Index-page Definitions
$pgv_lang["def_help"]				= "<div class='name_head center'><b>#pgv_lang[definitions]#</b></div><br />Några definitioner av ord som används i hjälptexterna:<ul><li><a href=\"#def_gedcom\"><b>GEDCOM</b></a><br /></li><li><a href=\"#def_gedcom_date\"><b>Datum</b></a></li><li><a href=\"#def_pdf_format\"><b>PDF file format</b></a></li><li><a href=\"#def_pgv\"><b>PhpGedView</b></a></li><li><a href=\"#def_portal\"><b>Portal</b></a></li><li><a href=\"#def_theme\"><b>Tema</b></a></li></ul>";
$pgv_lang["def_portal_help"]			= "~Portal~<br /><br />Också på denna sida är en portal som en lobby på en resturang. Det är stället där du startar, men du kan också få viktig information som förklaringar, menyer och liknande..";
$pgv_lang["def_gedcom_help"]			= "~GEDCOM-fil~<br /><br />Ett citat från introduktion för GEDCOM 5.5.1 standarden:<div class=\"list_value_wrap\">#pgv_lang[quote_gedcom]#</div><br />Svensk version:<div class=\"list_value_wrap\">GEDCOM är utvecklad av Family History Department inom kyrkan Jesu Kristi Kyrka av Sista Dagars Heliga(SDH) för att erbjuda ett flexibelt, enhetligt format för att utbyta genealogisk data.&nbsp; GEDCOM är en förkortning för <i><b>GE</b></i>nealogical <i><b>D</b></i>ata <i><b>Com</b></i>munication (Genealogisk datakommunikation).&nbsp; Syftet är att gynna utbyte av genealogisk information och utvecklingen av stor variation av sammarbetande mjukvaruprodukter för att hjälpa släktforskare, historiker och andra forskare.</div><br />En kopia av GEDCOM 5.5.1 <u>förslag</u> till standard, vilket PhpGedView följer, kan laddas ner i pdfformat från <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=_blank>GEDCOM 5.5.1 Standard</a> standraden finns endast på engelska.<br /><br />GEDCOM-filen är den fil som innehåller all information om familjen. Alla fakta, datumar, händelser o.s.v. är sparade i GEDCOM-filen. En GEDCOM-fil måste följa strikta regler, eftersom den är utbytbar mellan måna progam, oberoende av platform och/eller system.";
$pgv_lang["def_gedcom_date_help"]		= "~Datum i en GEDCOM-fil~<br /><br />Även om datumfältet tillåter inmatning i fri form (vilket innebär att du kan skriva in vad du vill) finns det några regler om hur datum ska anges enligt GEDCOM 5.5.1-standarden.<ul><li>Ett fullständigt datum anges i formuläret DD&nbsp;MMM&nbsp;ÅÅÅÅ. Till exempel <b>01&nbsp;MAR&nbsp;1801</b> eller <b>14&nbsp;DEC&nbsp;1950</b>.</li><li>Om du saknar en del av datumet kan du utelämna den delen. T.ex. <b>MAR&nbsp;1801</b> eller <b>14&nbsp;DEC</b>.</li><li>Om du är osäker eller om datumet inte bekräftas kan du ange <b>ABT&nbsp;MAR&nbsp;1801</b> (abt = about = ungefär), <b>BEF&nbsp;20&nbsp;DEC&nbsp;1950</b> (bef = before = före), <b>AFT&nbsp;1949</b> (aft = after = efter)</li><li>Datumintervall anges som <b>FROM&nbsp;MAR&nbsp;1801&nbsp;TO&nbsp;20&nbsp;DEC&nbsp;1810</b> eller som <b>BET&nbsp;MAR&nbsp;1801&nbsp;AND&nbsp;20&nbsp;DEC&nbsp;1810</b> (bet = between = mellan)<br /><br /><b>FROM</b> indikerar att händelsen som beskrivs hände kontinuerligt mellan de angivna datumen och används tillsammans med händelser som anställning. <b>BET</b> indikerar en enda förekomst av händelsen någon gång mellan de angivna datumen och används tillsammans med händelser som födelse.<br /><br />Oprecis datum, där dagen i månaden eller månaden saknas, tolkas alltid som det första eller sista möjliga datumet, beroende på om det exakta datumet inträffar före eller efter det separerande nyckelordet. Till exempel tolkas <b>FEB&nbsp;1804</b> som <b>01&nbsp;FEB&nbsp;1804</b> när det inträffar före TO eller AND, och som <b>29&nbsp;FEB&nbsp;1804</b> när det inträffar efter TO eller AND.</li></ul><br /><b>Se till att ange datum och förkortningar på <u>engelska</u>,</b> för då kan GEDCOM-filen bytas ut och PhpGedView kan översätta alla datum och förkortningar ordentligt till det för närvarande aktiva språket. Dessutom gör PhpGedView beräkningar med hjälp av dessa datum. Om felaktiga datum anges i datumfält kan PhpGedView inte beräkna korrekt. Du kan klicka på kalenderikonen för att välja ett datum.<br /><br />Följande förkortningar används:<ul><li>JAN = January = Januari</li><li>FEB = February = Februari</li><li>MAR = March = Mars</li><li>APR = April = Maj</li><li>MAY</li><li>JUN = June = Juni</li><li>JUL = July = Juli</li><li>AUG = August = Augusti</li><li>SEP = September</li><li>OCT = October = Oktober</li><li>NOV = November</li><li>DEC = December</li><li>bef = before = före</li><li>abt = about = ungefär</li><li>aft = after = efter</li></ul>";
$pgv_lang["def_gramps_help"]		= "~GRAMPS XML Databasfil~<br /><br />Ett citat från GRAMPS projektet: <div class=\"list_value_wrap\">#pgv_lang[quote_gramps]#</div><br />Svensk version:<div class=\"list_value_wrap\">GRAMPS hjälper dig att spåra ditt släktträd. Det låter dig lagra, redigera och undersöka släktforskningsdata. GRAMPS försöker tillhandahålla alla de gemensamma funktionerna i andra släktforskningsprogram, men, ännu viktigare, att ge en ytterligare integrationsförmåga som inte är gemensam för dessa program. Detta är förmågan att mata in bitar och bitar av information direkt i GRAMPS och omorganisera / manipulera alla / alla datahändelser i hela databasen (i valfri ordning eller sekvens) för att hjälpa användaren att göra forskning, analys och korrelation med potentialen för att fylla förhållanden luckor.</div><br />En kopia av av GRAMPS XML format v.1.1.0 <a href=\"http://www.gramps-project.org/xml/1.1.0/\" target=\"_blank\">kan hittas här</a> i både RELAX NG schema format och DTD format.<br /><br />För mer information om GRAMPS projektet besök  <a href=\"http://gramps-project.org/\" target=\"_blank\">http://gramps-project.org/</a>";
$pgv_lang["def_pgv_help"]			= "~PhpGedView~<br /><br />PhpGedView (eller PGV) lägger inte bara statiska sidor på webben; det är dynamiskt och kan anpassas på många sätt.<br /><br />PhpGedView skapades av John Finlay för att se GEDCOM-filer online. John började utveckla programmet på egen hand. Ett internationellt team av utvecklare och översättare har sedan gått med i honom och arbetar för att förbättra programmet. Bland de mer viktiga funktioner som har lagts till eller förbättrats i programmet är dess omfattande stöd för andra språk än engelska, och möjligheten att lägga till och redigera händelser på nätet.";
$pgv_lang["def_theme_help"]			= "~Tema~<br /><br />Denna sajt kan några olika utseende, kallade teman. Sajtadministratören väljer ett tema för uppstarten.<br /><br />Alla som kommer till sajten kommer att de samma utseende(tema)på sajten. När administratören satt upp sajten så att inloggade användare kan välja sitt eget tema, kan de själv välja vilket som de tycker ser bäst ut. Om en användare har valt ett eget tema, kommer han/hon ha det utseendet på sajten så snart hon loggat in.<br /><br />Teman kan användas som ett sätt att skilja mellan olika databaser på samma webbplats. Varje databas kan ha olika standardtema.";

//-- Index-page MyGEDCOM
$pgv_lang["mygedview_portal_help"]		= "~#pgv_lang[mygedview]#~<br /><br />Detta är din personliga #pgv_lang[mgv]# sidan.<br /><br />Du kan här hitta snabblänkar till dina personliga data, som <b>Mitt konto, Min person</b> (detta är din ansedel), <b>Min antavla</b>. Dessutom kan du ha block för <b>Meddelande</b>, <b>Anteckningar</b> och många fler.<br /><br />Utseendet på denna sida är detsamma som välkomstsidan. Medan välkomstsidan är ihopsatt av administratören, kan du välja mellan många olika områden, för att bygga sidan som du vill ha den (inom vissa gränser). I välkomstblocket på denna sida hittar du länken för att skräddarsy denna sida.<br /><br />Du kan välja mellan följande block och länkar:<ul><li><a href=\"#mygedview_welcome\"><b>#pgv_lang[welcome_block]#</b></a></li><li><a href=\"#mygedview_customize\"><b>Skräddarsy «#pgv_lang[mygedview]#»</b></a></li><li><a href=\"#mygedview_message\"><b>#pgv_lang[user_messages_block]#</b></a></li><li><a href=\"#mygedview_events\"><b>#pgv_lang[upcoming_events_block]#</b></a></li><li><a href=\"#mygedview_onthisday\"><b>#pgv_lang[todays_events_block]#</b></a></li><li><a href=\"#mygedview_charts\"><b>#pgv_lang[charts_block]#</b></a></li><li><a href=\"#mygedview_favorites\"><b>#pgv_lang[user_favorites_block]#</b></a></li><li><a href=\"#mygedview_stats\"><b>#pgv_lang[gedcom_stats_block]#</b></a></li><li><a href=\"#mygedview_myjournal\"><b>#pgv_lang[user_news_block]#</b></a></li><li><a href=\"#mygedview_media\"><b>#pgv_lang[random_media_block]#</b></a></li><li><a href=\"#mygedview_loggedin\"><b>#pgv_lang[logged_in_users_block]#</b></a></li><li><a href=\"#recent_changes\"><b>#pgv_lang[recent_changes_block]#</b></a></li></ul>";
$pgv_lang["mygedview_customize_help"]		= "~SKRÄDDARSY #pgv_lang[mygedview]#~<br /><br />När du kom hit för första gången, fanns det redan några block på sidan. Om du vill kan du skräddarsy denna portal.<br /><br />Om du klickar på denna länk kommer du till ett formulär i ett nytt fönster, i vilket du kan lägga till, ta bort, eller flytta omkring områdena. Mer hjälp finns i formuläret.";
$pgv_lang["mygedview_message_help"]		= "~#pgv_lang[user_messages_block]#~<br /><br />I detta blocket hittar du meddelandena skickade till dig från andra användare, eller från administratören. Du kan självklart skicka egna meddelanden till andra användare eller administratören.<br /><br />PhpGedViews postsystem är designat för att skydda din integritet. Du behöver inte lämna ut din e-postadress här och andra kommer inte att se din e-postadress.<br /><br />För att expandera ett meddelande klicka på ämnesraden för meddelandet eller \"<b>+</b>\"-tecknet sidan om det. Du kan radera flera meddelande genom att kryssa i rutan sidan om ett meddelande som du vill radera och klicka på \"Radera markerade meddelande\" knappen.";
$pgv_lang["mygedview_favorites_help"]		= "~#pgv_lang[user_favorites_block]#~<br /><br />Mina favorter fungerar som att lägga till bokmärken.<br /><br />Anta du har någon i ditt släktträd, vilkens post du vill kontrollera regelbundet. Då går du bara till den personens #pgv_lang[indi_info]#-sida och klickar på länken <b>Lägg till mina favoriter</b>. Denna person är nu tillagd som bokmärke i dina favoriter listan.<br /><br />Var du än är på sajten, kan du klicka på ett namn i rullgardinsmenyn i huvudet. Detta kommer att flytta dig till #pgv_lang[indi_info]# för denna person.";
$pgv_lang["mygedview_myjournal_help"]		= "~#pgv_lang[user_news_block]#~<br /><br />Du kan använda denna journal att skriva anteckningar (eller påminnelser) för ditt eget bruk. När du gör en anteckning kommer den förstås att vara kvar nästa gång du besöker sidan.<br /><br />Dessa anteckningar kommer inte att vara synliga för andra.";
$pgv_lang["mygedview_welcome_help"]		= "~#pgv_lang[welcome_block]#~<br /><br />Detta välkomstblocket visar dig:<ul><li>Den aktuella GEDCOM-filen.</li><li>Datum och tid</li><li>Länkar till:</li><ul><li>#pgv_lang[myuserdata]#</li><li>#pgv_lang[my_pedigree]#</li><li>#pgv_lang[my_indi]#</li><li>#pgv_lang[customize_page]#</li></ul></ul><br /><b>Anmärkning:</b><br />Du ser bara länkarna till <b>#pgv_lang[my_indi]#</b> och <b>#pgv_lang[my_pedigree]#</b> om du har en känd för den aktuella GEDCOM-filen. Så det kan vara så att i en GEDCOM-fil har du en post och därför ser länkarna medan i en annan ser du inte länkarna.";

//-- Pedigree-page
$pgv_lang["help_pedigree.php"]			= "~ANTAVLANS SIDA~<br /><br />En stamtavla är en uppräkning av alla förfäder till den startande personen. Användare som inte är inloggade ser stamtavlan för den startande (root) person som valts av webbplatsadministratören. Inloggade användare kan välja sin egen startperson (root).<br /><br />I detta sammanhang betyder \"Alla förfäder\" far och mor, deras föräldrar och så vidare. Stamtavlan visas grafiskt; du behöver inte kämpa igenom sidor med text för att avgöra dina förfäder.<br /><br />Alla personer visas i namnrutorna på skärmen.<br /><ul><li><b>Namnboxar i antavlan</b><br />Om antavlan är satt att visa detaljer, kommer du att se personens namn och datumet för födelse och död. Du kan klicka på en persons namn, du blir du förflyttad till personens #pgv_lang[indi_info]#.<br /><br />När <b>visa detljer</b> är på så finns det två ikoner inuti namnboxen.</li><li><b>Antavleikonen inuti namnboxen</b><br />När <b>visa detaljer</b> är på, kan du se en antavleikon inuti namnboxen. Beroende på sajt-inställningar måste du sväva över ikonen eller klicka på den. Så, när du klickar på den eller svävar över den, visar sig en liten undermenyn.<br /><br />Valen <b>#pgv_lang[index_header]#</b> och <b>#pgv_lang[descend_chart]#</b>är lika dem i huvudmenyn, skillnaden är att personen i namnboxen blir startperson. Dessutom ser du <b>#pgv_lang[as_spouse]#</b>. Du ser namnet på maken/an följt av namnet/n på barnen. Alla namnen är klickbara.</li><li><b>Förstoringsglaset inuti namnboxen</b><br />Beroende på sajt-inställningar, måste du sväva över eller klicka på det. Detta förstorar namnboxen, så att fler detaljer visas. Du ser fler händelser och datum. Namnen är klickbara.</li><li><b>Pilarna</b><br />Till vänster eller höger om de yttersta namnboxarna kan du se pilar. Om man klickar på dessa pilar så \"skiftar man\" skärmen i pilens riktning.</li></ul><br />#pgv_lang[context_help]#<br />";
$pgv_lang["show_full_help"]				= "~#pgv_lang[show_details]#~<br /><br />Med det här alternativet kan du antingen visa eller dölja alla detaljer i rutorna Namn. Du kan visa fler rutor på en skärm när detaljerna är dolda.<br /><br />När alla detaljer är dolda visas inte zoomikonen som beskrivs nedan. Men om administratören har aktiverat zoomfunktionen fungerar hela rutan som en zoomikon för att avslöja fullständiga detaljer om personen.<br /><br />När detaljerna inte är dolda och zoomfunktionen, som identifierats med en förstoringsglasikon, har aktiverats av administratören kan du avslöja ännu mer information om den personen. Om du normalt måste klicka på zoomikonen för att zooma in kan du avslöja ytterligare dolda detaljer genom att klicka på ikonen här. På samma sätt, om du kan zooma in genom att sväva över zoomikonen, kommer dolda detaljer att avslöjas genom att sväva över ikonen här.<br /><br />Om du har klickat på zoomikonen för att avslöja fler detaljer kan du återställa rutan till dess normala detaljnivå genom att klicka på zoomikonen igen. Om du har avslöjat fler detaljer genom att helt enkelt flytta muspekaren över zoomikonen återställs rutan till sin normala detaljnivå när du flyttar muspekaren bort från zoomikonen.";
$pgv_lang["talloffset_help"]			= "~#pgv_lang[portrait]# / #pgv_lang[landscape]#~<br /><br />Med det här alternativet bestämmer du sidlayoutens orientering. <br /> <br /> Att ändra denna inställning kan vara användbart om du vill göra en skärmutskrift eller om du har en annan typ av skärm.<ul><li><b>#pgv_lang[portrait]#</b>&nbsp;&nbsp;&nbsp;kommer att göra trädet högre, så att ett 4-generationsdiagram ska passa på en enda sida som skrivs ut vertikalt.</li><li><b>#pgv_lang[landscape]#</b>&nbsp;&nbsp;&nbsp;kommer att skapa ett bredare träd som ska skrivas ut på en enda sida som skrivs ut horisontellt.</li><li><b>#pgv_lang[landscape_top]#</b>&nbsp;&nbsp;&nbsp;roterar diagrammet, men inte dess rutor, med 90 grader moturs så att den äldsta generationen är högst upp i diagrammet.</li><li><b>#pgv_lang[landscape_down]#</b>&nbsp;&nbsp;&nbsp;roterar diagrammet, men inte dess rutor, med 90 grader medurs, så att den äldsta generationen är längst ner i diagrammet.</li></ul>";
$pgv_lang["rootid_help"]			= "~#pgv_lang[rootid]#~<br /><br />Om du vill visa trädet med en ny startperson, då kan du  skriva in den nya personens ID i denna ruta.<br /><br />Om du inte vet personens ID, använd <b>Sök ID</b> länken.<br /><br /><b>IDNUMMER</b><br />ID-numren som används i PhpGedView är <u> inte </u> identifikationsnumren som utfärdats av olika myndigheter (till exempel körkort eller passnummer). ID-numret som hänvisas till här är helt enkelt ett nummer som används i databasen för att identifiera varje individ unikt; det tilldelades av anorsprogrammet som skapade GEDCOM-filen som importerades till PhpGedView.";
$pgv_lang["PEDIGREE_GENERATIONS_help"]		= "~#pgv_lang[generations]#~<br /><br />Här kan ställa in antalet generationer du vill visa på denna sida.<br /><br />Vad som är bra för dig beror på storleken på skärmen och om du har visa detaljer på. Processtiden kommer att öka med antelet generationerna.";

//-- LOGIN-page
$pgv_lang["login_page_help"]		= "~#pgv_lang[login]#~<br /><br />På denna sida kan du logga in, begära ett nytt lösenord eller begära ett nytt användarkonto.";
$pgv_lang["username_help"]			= "~#pgv_lang[username]#~<br /><br />I denna box skriver du ditt användarnamn.<br /><br /><b>Användarnamnet måste skrivas korrekt med stora och små bokstäver.</b> Det betyder att <b>MittNamn</b> är <u>inte</u> samma som <b>mittnamn</b> eller <b>MITTNAMN</b>.";
$pgv_lang["password_help"]			= "~#pgv_lang[password]#~<br /><br />I denna box skriver du in lösenordet.<br /><br /><b>Lösenordet måste skrivas in korrekt med små och stora bokstäver.</b> Det betyder att <b>MittLösenordet</b> är <u>inte</u> samma som <b>mittlösenordet</b> eller <b>MITTLÖSENORDET</b>.";
$pgv_lang["login_buttons_help"]		= "~LOGINKNAPP~<br /><br />Här ser du en knapp för att logga in på systemet.<br /><br />Om du klickar på den här knappen kommer du tillbaka till den sida du just befann dig på, men med inloggade behörigheter.<br /><br />Om du till exempel klickar på <b>#pgv_lang[login]#</b> när du var på stamtavla, kommer du tillbaka till samma sida. Om du klickar på den här knappen när du var på välkomstsidan kommer du till sidan «#pgv_lang[mygedview]#», där du kan redigera dina inställningar, lägga till eller redigera favoriter, skicka och läsa meddelanden etc.";
$pgv_lang["login_buttons_aut_help"]	= "~LOGINKNAPP~<br /><br />Här ser du en knapp för att logga in på systemet.<br /><br />Om du klickar på den här knappen kommer du att vara inloggad och gå direkt till sidan «#pgv_lang[mygedview]#», där du kan redigera dina inställningar, lägga till eller redigera favoriter, skicka och läsa meddelanden etc.";
$pgv_lang["new_password_help"]		= "~#pgv_lang[requestpassword]#~<br /><br />Om du har glömt ditt lösenord kan du klicka på den här länken för att begära ett nytt lösenord.<br /><br />Du kommer till sidan «#pgv_lang[lost_pw_reset]#».";
$pgv_lang["new_user_help"]			= "~#pgv_lang[requestaccount]#~<br /><br />Om du är besökare på denna sida och vill begära att få ett användarkonto ska du klicka på denna länk.<br /><br />Beroende på hur administratören har ställt in webbplatsen kan din e-postklient lanseras så att du kan skicka e-post till administratören för att begära ett nytt inloggnings-ID, eller så kan du föras till sidan «#pgv_lang[requestaccount]#».";
$pgv_lang["mygedview_login_help"]	= "För att kunna besöka «#pgv_lang[mygedview]#» måste du vara en registrerad användare på systemet. Med «#pgv_lang[mygedview]#» kan du sätta bokmärke på dina favorit personer, hålla en användarjournal, hantera meddelande, se andra inloggade användare och skräddarsy din upplevelse av PhpGedView.<br /><br />Skriv in användarnamn och lösenord i fälten, med detta namn loggar du in på min «#pgv_lang[mgv]#».";
$pgv_lang["new_user_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />I denna ruta ska du skriva in ditt förnamn.<br /><br />Vi behöver ditt förnamn och efternamn för att kunna avgöra om du kan få ett konto på denna sajt och vilka rättigheter du bör få. Dessa namn kommer att vara synliga för andra inloggade användare.";
$pgv_lang["new_user_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br />I denna ruta ska du skriva in ditt efternamn.<br /><br />Vi behöver ditt förnamn och efternamn för att kunna avgöra om du kan få ett konto på denna sajt och vilka rättigheter du bör få. Dessa namn kommer att vara synliga för andra inloggade användare.";
$pgv_lang["register_info_01"]		= "~#pgv_lang[requestaccount]#~<br /><br />Mängden data som kan visas offentligt på denna webbplats kan vara begränsad på grund av tillämplig lag om integritetsskydd. Många människor vill inte att deras personuppgifter ska vara offentligt tillgängliga på Internet. Personuppgifter kan missbrukas för skräppost eller identitetsstöld.<br /><br />Tillgång till denna webbplats är tillåten för alla besökare som har ett användarkonto. Efter att administratören har verifierat och godkänt din kontoansökan kan du logga in.<br /><br />Om dessutom finessen relationssäkerhet är aktiverad, kommer du bara att kunna se privat information om dina egna nära släktingar. Administratören kan också ge rättigheter för att ändra och lägga till information i databasen.<br /><br />Om du behöver mer hjälp, använd länken nedan och kontakta administratören.<br /><br /> ";
$pgv_lang["register_info_02"]		= "~#pgv_lang[requestaccount]#~<br /><br />Mängden data som kan visas offentligt på denna webbplats kan vara begränsad på grund av tillämplig lag om integritetsskydd. Många människor vill inte att deras personuppgifter ska vara offentligt tillgängliga på Internet. Personuppgifter kan missbrukas för skräppost eller identitetsstöld.<br /><br />Tillgång till denna sajt är endast tillgänglig för <u>behöriga</u> användare. Efter administratören har verifierat och godkänt din kontoansökan, kan du logga in och för att se privat data.<br /><br />Om dessutom finessen relationssäkerhet är aktiverad, kommer du bara att kunna se privat information om dina egna nära släktingar. Administratören kan också ge rättigheter för att ändra och lägga till information i databasen.<br /><br />Om du behöver mer hjälp, använd länken nedan och kontakta administratören.<br /><br /> ";
$pgv_lang["register_info_03"]		= "~#pgv_lang[requestaccount]#~<br /><br />Mängden data som kan visas offentligt på denna webbplats kan vara begränsad på grund av tillämplig lag om integritetsskydd. Många människor vill inte att deras personuppgifter ska vara offentligt tillgängliga på Internet. Personuppgifter kan missbrukas för skräppost eller identitetsstöld.<br /><br />Tillgång till denna sajt är endast tillgänglig för <u>familjemedlemar</u>. Efter administratören har verifierat och godkänt din kontoansökan, kan du logga in och för att se privat data.<br /><br />Om dessutom finessen relationssäkerhet är aktiverad, kommer du bara att kunna se privat information om dina egna nära släktingar. Administratören kan också ge rättigheter för att ändra och lägga till information i databasen.<br /><br />Om du behöver mer hjälp, använd länken nedan och kontakta administratören.<br /><br /> ";


//-- Descendancy-page
$pgv_lang["help_descendancy.php"]		= "~#pgv_lang[descend_chart]#~<br /><br />Denna sida visar ättlingar till en person.<br /><br />Du kan välja en annan startperson för stamtavlan på denna sida eller du kan länkas till denna sida genom klicka på <b>#pgv_lang[descend_chart]#</b> från en annan sida. Klicka på pilikonerna för att navigera i trädet i pilens riktning. Klicka på tavleikonen i en personruta för att göra denna person till rot i trädet.";
$pgv_lang["desc_rootid_help"]			= "#pgv_lang[rootid_help]#";
$pgv_lang["desc_generations_help"]		= "#pgv_lang[PEDIGREE_GENERATIONS_help]#";

//-- Time line-page
$pgv_lang["help_lifespan.php"]			= "~#pgv_lang[lifespan_chart]#~<br /><br />I denna tavla kan du visa en eller flera personer längs en horizontel tidslinje. Denna tavla låter dig se hur liven för olika personer överlappar.<br /><br />Du kan lägga till personer till tavlan en och en eller som familjegrupp via deras ID. Den tidigare listan koms ihåg medan du lägger till fler personer till tavlan. Du kan rensa tavlan när du vill med <b>Rensa tavla</b>-knappen.<br /><br />Du kan också lägga till personer till tavlan genom att söka via datumblocket eller orter.";
$pgv_lang["lifespan_add_person_help"]			= "#pgv_lang[add_person_help]#<br /><br /><b>Inkludera närstående familj kryssruta</b><br />Inkludera närstående familj är i kryssad som standard. Lämna den i kryssad för att visa föräldrar, make/maka, syskon och barn för personen som läggs till tidslinjen. Tabort krysset om du inte vill att den närstående familjen ska visas.";
$pgv_lang["help_timeline.php"]			= "~#pgv_lang[timeline_chart]#~<br /><br />På denna sida visa en eller flera personer längs en tidslinje. På detta sätt du t.ex. visa statusen för två eller flera personer vid ett visst tillfälle.<br /><br />Om du klickar på <b>Tidslinje</b> länken från en annan sida kommer du se den personen på tidslinjetavlan. Om du klickar på <b>Tidslinjetavlan</b> i menyn, kommer du att behöva skriva in ID på en person att starta med.";
$pgv_lang["add_person_help"]			= "~#pgv_lang[add_another]#~<br /><br />Du kan ange flera personer på tidslinjen.<br /><br />Använd boxen för att fylla en persons ID. Om du inte vet personens ID kan du klicka på <b>Sök ID</b> länken sidan om boxen.";
$pgv_lang["remove_person_help"]			= "~#pgv_lang[remove_person]#~<br /><br />Klicka på denna länk för att ta bort personen från tidslinjen.";
$pgv_lang["show_age_marker_help"]		= "~#pgv_lang[show_age]#~<br /><br />Om du markerar den här rutan ser du en åldersmarkör.<br /><br />Du kan skjuta den här åldersmarkören uppåt eller nedåt längs tidslinjen. Den glidande åldersmarkören är ett trevligt verktyg för att kontrollera åldern på en person vid en viss händelse. Du kan aktivera eller inaktivera åldersmarkören individuellt för varje person i diagrammet.";
$pgv_lang["timeline_control_help"] = "~#pgv_lang[timeline_controls]#~<br/><br/>~HASTIGHET~<br/>Klicka på rullgardinsmenyn för att välja hastigheten som tidslinjen rullar.<br /><br />~Börja år~<br />Skriv in startåret för blocket.<br /><br />~Sluta år~<br />Skriv in slutåret för blocket.<br /><br />~Sök~<br />Klicka på sök-knappen för att börja söka efter händelser som hänt inom blocket du angivit enligt ovan.";

//-- Relationship-page
$pgv_lang["help_relationship.php"]		= "~#pgv_lang[relationship_chart]#~<br /><br />På denna sida kan visa släktskapet mellan två personer. Det betyder inte att dessa personer behöver vara släkt via blodsband. Vilket förhållande som helst kommer att hittas.";
$pgv_lang["relationship_id_help"]		= "~#pgv_lang[id]# :: #pgv_lang[person1]# :: #pgv_lang[person2]#~<br /><br />Om du har hoppat från en annan sida till den här genom att klicka på länken <b>Relation till mig</b> ser du här förhållandet mellan dig själv och den andra personen.<br /><br />Om du kom på den här sidan via menyposten <b>Relationsdiagram</b> på vilken sidhuvud som helst, måste du skriva in identifieringsnumren för de två personer vars förhållande du vill se. Om du inte känner till identifieraren för den önskade personen kan du klicka på länken <b>Sök ID</b>.";
$pgv_lang["next_path_help"]			= "~#pgv_lang[next_path]#~<br /><br />Du kan klicka på denna knapp för att se om det finns ett annat förhållande mellan två personer. Den föregående förhållandet kan visas igen genom att klicka på länken med förhållande numret.";
$pgv_lang["follow_spouse_help"]			= "~#pgv_lang[follow_spouse]#~<br /><br />Med denna kryssruta <b>ej</b> ikryssad, kontrolleras endast förhållandet via blodslinjer. Med kryssrutan ikryssad kontrolleras även förhållande genom vigsel. Du kommer troligen att hitta fler relationer genom att låta rutan vara ikryssad.";
$pgv_lang["line_up_generations_help"]	= "~#pgv_lang[line_up_generations]#~<br /><br />När denna kryssruta är vald kommer tavlan att skrivas ut med samma generationer radad upp horisontellt på denna sida, ej i kryssad kommer varje generationer att visas under varandra på sidan oavsett om det är ett föräldra- eller barn-relationer.";
$pgv_lang["oldest_top_help"]          = "~#pgv_lang[oldest_top]#~<br /><br />Med denna kryssruta vald kommer tavlan att skrivas ut med de äldsta personerna överst annars vissa de yngsta överst.<br /><br />Obs! Detta val fungerar endast om <i>#pgv_lang[line_up_generations]#</i> är vald.";

//-- Ancestry-page
$pgv_lang["help_ancestry.php"]		= "~#pgv_lang[ancestry_chart]# sida~<br /><br />Väldigt likt <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, med fler detaljer och många <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a>.<br /><br />Varje ana visas med ett unikt nummer från <i>Sosa-Stradonitz</i> systemet:<ul><b>Jämna</b> för men (barn * 2)<br /><b>Udda</b> för kvinnor (make + 1) utom för <b>1</b></ul><br />Ex:<br /><ul>rotpersonen är <b>1</b>, oavsett kön.<br />far till <b>1</b> är <b>2</b> (<b>1</b> * 2), moder är <b>3</b> (<b>2</b> + 1).<br />far till <b>2</b> är <b>4</b> (<b>2</b> * 2), moder är <b>5</b> (<b>4</b> + 1).<br />far till <b>3</b> är <b>6</b> (<b>3</b> * 2), moder är <b>7</b> (<b>6</b> + 1).<br />far till <b>7</b> är <b>14</b> (<b>7</b> * 2), moder är <b>15</b> (<b>14</b> + 1).<br />etc.</ul>";
$pgv_lang["box_width_help"]		= "~#pgv_lang[ancestry_chart]# boxvidd~<br /><br />Här kan du ändra vidden av boxen mellan 50% till 300%. Vid 100% är varje box ca 270 pixel bred.";
$pgv_lang["chart_style_help"]			= "~#pgv_lang[chart_style]#~<br /><br />Två tavelstilar är tillgängliga:<ul><li><b>#pgv_lang[chart_list]#</b>&nbsp;&nbsp;&nbsp;Vertikalt träd med familjer som kan döljas eller visas.</li><li><b>#pgv_lang[chart_booklet]#</b>&nbsp;&nbsp;&nbsp;En fammilj per sida, med föräldrar, far/mor-föräldrar och alla kända barn.<br /><br />Lätt att skriva ut och ge till släktingar.</li></ul>";

//-- Fan chart-page
$pgv_lang["help_fanchart.php"]		= "~#pgv_lang[fan_chart]# sida~<br /><br />Väldigt likt <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, fast med en mer grafisk inriktning.<br /><br />Rotpersonen är i centrum, hans föräldrar i den första ringen, far/mor-föräldrar i den andra ringen...<br /><br />Födelseåret och dödsåret skrivs ut om det är känt.<br /><br />Klicka på ett namn i tavlan öppnar en länk till en meny specifik för den personen. Från denna meny kan du välja flytta den personen till centrum av solfjädertavlan eller till en av persons nära släktingar, eller du kan flytta till personens #pgv_lang[indi_info]#-sida eller en annan tavla för personen.";
$pgv_lang["fan_width_help"]		= "~#pgv_lang[fan_width]#~<br /><br />Du kan ändra solfjäderns bredd från 50% till 300%. Standard värde är 100% : resultatbilden är omkring 640 pixel bred.";
$pgv_lang["fan_style_help"]			= "~#pgv_lang[fan_chart]# stil~<br /><br />Detta val kontrollerar utseendet av solfjädern<ul><li><b>1/2</b>&nbsp;&nbsp;&nbsp;Halvcirkelformad fjäder (180 grader)</li><li><b>3/4</b>&nbsp;&nbsp;&nbsp;Trekvartsformad fjäder (270 grader) eller <i>Änglavinge</i></li><li><b>4/4</b>&nbsp;&nbsp;&nbsp;Helt cirkelformad fjäder (360 grader)</li></ul>";

//-- Hourglass chart-page
$pgv_lang["help_hourglass.php"]			= "~#pgv_lang[hourglass_chart]#~<br /><br />Timglastavlan visar både anorna och ättlingarna för den valda rotpersonen i samma tavla. Denna tavla är en sorts mix mellan en antavla och en stamtavla.<br /><br />Rotpersonen är centrerad i mitten på sidan med ättlingar till vänster och anor till höger. I denna vyn är varje generation uppställd så att den startar med den tidigaste generationer och slutar med den senaste.<br /><br />Om där finns en neråtpil på skärmen under rotpersonen, klicka på den och en lista med rotpersonens nära familjemedlemmar som du kan använda för att navigera nedför tavlan. Väljer man ett namn kommer man att ladda om tavlan med den valda personen som rotperson.";

//-- Family Book chart-page
$pgv_lang["help_familybook.php"]	= "~#pgv_lang[familybook_chart]#~<br /><br />Denna tavla är väldigt likt timglastavlan. Den kommer att visa anorna och ättlingarna till den valda startpersonen i samma tavla. Den kommer också att visa ättlingarna till startpersonen i samma timglasstil.<br /><br />Startpersonen är centrerad i mitten på sidan med sina ättlingar till vänster och anorna till höger. I denna vy är varje generation uppradad över sidan med den äldsta generationen först och den yngsta sist.<br /><br />Varje ättling till startpersonen kommer att bli startperson för en ny timglasstavla, utskrivet på samma sida. Denna process upprepas till det angivna antalet generationer har skrivits ut.";
$pgv_lang["fambook_descent_help"]	= "~#pgv_lang[descent_steps]#~<br /><br />Detta valet bestämmer hur många generationer ättlingar till startpersonen som kommer att skrivas ut i timglastavlan.";

//-- Indilist-page
$pgv_lang["help_indilist.php"]			= "~PERSONLISTNINGSSIDAN~<br /><br />På denna sida kan du visa en lista på personer. Namnen kommer att visa efternamn först och sorterad i alfabetisk ordning.<br /><br />Listans utseende beror på:<ul><li>Bokstaven som du klickade på i den alfabetiska listan.</li><li>Beroende på klickade \"Hoppa över\" eller \"Visa\" efternamnslista.</li></ul>#pgv_lang[context_help]#";
$pgv_lang["alpha_help"]				= "~ALFABETISKT INDEX~<br /><br />Klicka på en bokstav i alfabetet kommer att visa en lista med namn som börjar med bokstaven du klickade på.<br /><br />Det näst sista objektet i det alfabetiska indexet kan vara <b>#pgv_lang[NN]#</b>. Denna post kommer att finnas när det finns personer i databasen vars efternamn inte har registrerats eller inte innehåller några igenkännbara bokstäver. Okända efternamn registreras ofta som <b>#pgv_lang[qm]#</b>, och dessa känns igen som <b>#pgv_lang[NN]#</b>. Detta kommer också att hända om personen är okänd.<br /><br /><b>Obs</b><br />Om man i en personens GEDCOM-post är infört som t.ex.: <b>Nn</b>, <b>NN</b>, <b>Okänt</b> eller <b>N.N.</b> kommer den <u>inte</u> att visas om man klickar på <b>#pgv_lang[NN]#</b>. Istället hittar du dessa personer genom att klicka på <b>N</b> eller <b>U</b> eftersom det här är de första bokstäverna i dessa namn. Det är för att programmet kommer bara att kontrollera om det finns en efternamn i personens post i GEDCOM-filen.<br /><br />I slutet på det alfabetiska indexet ser du <b>ALLA</b>. Klicka på denna länk kommer att visa en lista på alla efternamn i GEDCOM-filen.<br /><br /><b>Missade bokstäver?</b><br />Det kan vara så, att en eller flera bokstäver fattas. De fattas inte det betyder bara att det inte finns någon med ett efternamn som börjar på denna bokstav.";
$pgv_lang["name_list_help"]			= "~NAMNLISTA~<br /><br />Denna box kommer antingen att visa en Efternamnslista eller en komplett namnlista. I båda fallen kommer efternamnenslistan att starta med den bokstav du klickat på i alfabetindexen förutom om du klickat på <b>ALL</b><br /><br />Om du kommer att se en efternamnslista eller en komplett lista beror på statusen på <b>Visa/Dölj Efternamnslistan</b>-länken under boxen.";
$pgv_lang["skip_sublist_help"]			= "~HOPPA ÖVER UNDERLISTA~<br /><br />Standardinställningen är att efter att du har klickat på en bokstav i det alfabetiska indexet får du en underlista med efternamn. Om du klickar på den här länken kommer alla personer med efternamn som har den första bokstaven som visas för närvarande att visas omedelbart. Därefter kommer listan över individer att visas direkt när du klickar på en ny första bokstav i den alfabetiska listan.<br /><br />För att vända denna åtgärd, klicka på länken #pgv_lang[show_surnames]#.";
$pgv_lang["show_marnms_help"]			= "~#pgv_lang[show_marnms]#~<br /><br />Sidorna med person- och familjelistor kan antingen inkludera eller utesluta gifta namn. Det här alternativet kan vara till hjälp när du söker efter individer eller familjer där du bara vet det gifta namnet. Gift namn kan endast inkluderas om de redan finns i databasen.<br /><br />I familjelistan är det här värdet som standard att utesluta. I personlistan ställs standardvärdet in på GEDCOM-konfigurationssidan.<br /><br />När du ändrar det här alternativet kommer ditt val att komma ihåg tills du loggar ut eller din session avslutas.";

//-- Families-page
$pgv_lang["help_famlist.php"]			= "~FAMILJESIDAN~<br /><br />På denna sida kan du visa en lista av familjer. Namnen kommer att visas efternamn först och sorterade i bokstavsordning.<br /><br />Utskriften från namnlistan beror på:<ul><li>Bokstaven du klickade på i alfabetet.</li><li>Du klickade på \"Hoppa över\" eller \"Visa\" efternamnslista.</li></ul>Du kan söka efter makens eller makans efternamn, båda finns i listan.<br /><br />#pgv_lang[context_help]#";
$pgv_lang["help_family.php"]			= "~FAMILJDETALJSIDAN~<br /><br />Denna sida kommer att visa en översikt av familjen som du valt på en tidigare sida.<br /><br />Från högst upp till längst ner kommer du att se boxar med maken och hans föräldrar, makan och hennes föräldrar och barnen.<br /><br />Utseendet och innehållet för namnboxarna är det samma som namnboxarna som de redan känner till i antavlan och stamtavlan.<br /><br />Till höger om föräldrarutorna kan du se en pil om det finns fler förfäder i filen. När du klickar på den pilen flyttar du upp en generation för att visa dig en ny familjesida med de tidigare föräldrarna som nu är listade som man och hustru.<br /><br />På höger sida i namnboxen kan du se ett förstoringsglas som ger mer detaljerad information om personen. Klickar man på namnet kommer man till personens detaljsida.<br /><br />Dessutom finns det på höger sida en liten meny som kan ta dig till sidor med mer information eller andra tavlor.<br /><br />Familjegruppens information visar alla kända fakta och information om familjen, som vigsel, multimediaobjekt och anteckningar. För faktainformationen, klickar man på en ort kommer man till ortslistan, där alla andra familjer och personer kopplade till orten visas. Klicka på ett datum och du kommer till dagkalendern, vilket kommer att visa alla händelser som hänt denna dag och månad i det förflutna. Multimediaobjekt kan också klickas på, detta kommer att öppna ett nytt fönster i vilket objektet visas. När du klickar på bildtexten ser du bilden på sidan #pgv_lang[media_list]#. Om du klickar på en käll-länk kommer detaljerna om källan att visas på källsidan.<br /><br />Under namnboxarna för barn(en) hittar du en länk till \"Lägg till ett barn till familjen\". Intill namnboxen för barnen ser du \"familjegruppsinformationen\". Om du har tillräckligt med rättigheter kan du här, ändra, lägga till och ta bort data och fakta.<br /><br />Som med sidan #pgv_lang[indi_info]# ser du en meny längst upp till höger på sidan. Inlägg i den här menyn tar dig till andra sidor där du kan få information om denna familj eller utföra andra uppgifter relaterade till denna familj.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["add_child_help"]			= "~LÄGG TILL BARN TILL DENNA FAMILJ~<br /><br />Genom att klicka på denna länk, kan du lägga till barn till denna familj.<br /><br />Lägga till ett barn är enkelt: Bara klicka på länken, fyll i boxarna i fönstret, det är allt.";
$pgv_lang["show_fam_gedcom_help"]	= "~#pgv_lang[view_gedcom]#~<br /><br />Genom att klicka på denna länk kommer informationen om familjen att visas i ett fönster som den ser ut i GEDCOM-filen.";
$pgv_lang["add_fam_clip_help"]		= "~LÄGG TILL FAMILJ I URKLIPPSKORGEN~<br /><br />Genom att klicka på denna länk kan du lägga till familjeinformationen som den är sparad i GEDCOM-filen till #pgv_lang[clip_cart]#. På nästa sida kan välja exakt vilken information som du vill lägga till:<ul><li>#pgv_lang[just_family]#</li><li>#pgv_lang[parents_and_family]#</li><li>#pgv_lang[parents_and_child]#</li><li>#pgv_lang[parents_desc]#</li></ul>";
$pgv_lang["show_fam_timeline_help"]	= "~VISA PAR PÅ TIDSLINJE~<br /><br />Genom att klicka på denna länk kommer du att hoppa till tidslinjesidan, där alla fakta om paret kommer att visas på tidslinjen.";

//-- Source list-page
$pgv_lang["help_sourcelist.php"]		= "~KÄLLSIDAN~<br /><br />En lista med källor visas på denna sida.<br /><br />Till skillnad från #pgv_lang[indi_info]# och Familjesidor finns det inget alfabetiskt index.<br /><br />En källa kan vara en person, en offentlig databas, en institution, en Internetresurs etc. På grund av släktforskningskällornas helt slumpmässiga natur är det omöjligt att hitta en sorteringsordning som är meningsfull i alla fall. PhpGedView sorterar <u>dock</u> källnamnen i alfabetisk ordning.<br /><br /><b>KÄLLOR</b><br />Utan källor kan vi inte bygga en databas eftersom all information i databasen är en källa. Detta kan vara en släkting ett institut, publik databas etc.<br /><br />En källa kan vara länkad till många personer. Men en person kan också vara länkad till många källor. Du kan ha olika källor för varje händelse, oavsett om det är ett födelsedatum, yrke, vigsel, barn, etc.";
$pgv_lang["sourcelist_listbox_help"]		= "~KÄLLLISTAN~<br /><br />I denna box ser du namnen på källorna, som de är sparade i GEDCOM-filen. Namnen visas i alfabetisk ordning.<br /><br />När du klickar på ett namn i listan kommer du till den källans sida dären lista visas för alla personer och/eller familjer som är länkade till denna källa.";

//-- Sources-page
$pgv_lang["help_source.php"]			= "~KÄLLDETALJSIDAN~<br /><br />På denna sida visas detljerna om källan. Källor är väldigt viktiga för släktforskare och låter dig följa en annan släktforskare spår för att finna informationen.<br /><br />På sidan kan du se information om källans titel, författare, publicering och var källan finns. Eftersom det finns så många typer av källor kan vissa källor visa mer information än andra.<br /><br />Om ett multimediaobjekt (t.ex. ett scannat document) är knutet till en källa kan du se objektet i ett större fönster genom att antingen klicka på objektet eller på filnamnet sidan om det.<br /><br />Efter källdetaljeran visas en lista med namn på personer och familjer som är länkade till källan. Det gör det möjligt att se all information som man fått från samma källa.<br /><br />Om adminstratören satt på möjligheten så finns det ytterligare en eller två menyikoner på denna sidan:<ul><li><b>#pgv_lang[view_gedcom]#</b><br />vilket visar informationen i GEDCOM-format.</li><li><b>#pgv_lang[add_to_cart]#</b><br /> vilket låter dig spara denna information i din #pgv_lang[clip_cart]#. Därifrån kan du sedan ladda ner informationen och importera den till eget släktforskningsprogram.</li></ul><br />#pgv_lang[context_help]#";
$pgv_lang["sources_listbox_help"]		= "~POSTER LÄNKAD TILL DENNA KÄLLA~<br /><br />I denna box visas namnen på personer och familjer som är länkade till denna källa.<br /><br />Namnen visas i alfabetisk ordning. När du klickar på ett namn i listan kommer du till den källans sida dären lista visas för alla personer och/eller familjer som är länkade till denna källa.";
$pgv_lang["show_source_gedcom_help"]		= "~#pgv_lang[view_gedcom]#~<br /><br />Genom att klicka på denna länk kommer informationen om källan, som den är sparad i GEDCOM-filen, visas i ett pop-up fönster.";
$pgv_lang["add_source_clip_help"]		= "~#pgv_lang[add_to_cart]#~<br /><br />Genom att klicka på länken kan du lägga till en källa, som den är sparad i GEDCOM-filen, till din #pgv_lang[clip_cart]# för att senare ladda ner och importera till ditt eget släktforskarprogram.";
$pgv_lang["delete_source_help"]			= "~#pgv_lang[delete_source]#~<br /><br />Genom att klicka på detta val så markeras källan för radering.<br /><br />Vad betyder det? Låt oss anta att du har en god anledning att radera denna källa från GEDCOM-filen. Du klickar på länken och efter det kommer det upp ett pop-up fönster som frågar om du är säker på att du vill radera källan. När du fortsätter ditt besök, kommer du att märka att källan fortfarande syns och går att använda precis som förut.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["no_mistake"]					= "<b>Detta beror <u>inte</u> på något fel.</b> Administratören kommer att få ett meddelande om att en ändring har gjorts på GEDCOM-filen och att du har tagit bort något. Administratören bestämmer sedan om han accepterar din ändring eller inte. Först efter att administratören har godkänt din ändring blir raderingen faktiskt permanent. Om det finns några frågor kommer administratören att kontakta dig.";

//-- Persons per Place-page
$pgv_lang["help_placelist.php"]			= "~ORTSHIERARKI~ (eller personer per ort)<br /><br />På denna sida kommer du se en hierarki av orter från GEDCOM-filen och vilka personer eller familjer som är kopplade till orten.<br /><br />Om det finns en koppling mellan en person eller familj och en händelse på en bestämd ort kommer programmet att hitta det åt dig.<br /><br />Resultater visas i en dubbel lista, en för personer och en för familjer.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["ppp_default_form_help"]		= "~ORDNINGEN FÖR ORTERNA~<br /><br /><b>STANDARDORDNING</b><br />Detta betyder att det inte finns någon speciell ortsordning i GEDCOM-filen. I detta fall används en standardordningen.<br /><br />Om någon annan ordning hittades i GEDCOM-filen, skulle den visats mellan <b>(</b> och <b>)</b> i slutet på raden.";
$pgv_lang["ppp_match_one_help"]			= "~ORDNINGEN FÖR ORTER~<br /><br /><b>GEDCOM</b><br />Orterna antas vara kodade i platsformatet som uttryckligen deklareras i GEDCOM-filen. Detta åsidosätter standardordern.";
$pgv_lang["ppp_numfound_help"]			= "~HITTADE ORTSKOPPLINGAR~<br /><br />Här visas antalet hittade kopplingar. Om du fortfarande ser en lista med orter, betyder det att du inte nått den lägsta nivån ännu.<br /><br />Du kan välja att visa alla poster för orten eller du kan förfina sökningen genom att klicka på en annan ort.";
$pgv_lang["ppp_levels_help"]			= "~ORTSNIVÅER~<br /><br />Detta visar nivåerna som visas nu. Listboxen, som visar orterna, är faktiskt en underlista av den översta vänsta nivån.<br /><br />EXEMPEL:<ul><li>Standard ordningen år:#pgv_lang[default_form]#.</li><li>Om det nuvarande nivån är \"översta nivån\" då kommer boxen visa en lista alla länder i GEDCOM-filen.</li><li>Om den nuvarande nivån visar \"USA, Översta nivån\", kommer boxen att visa alla staterna i USA</li><li>etc.</li></ul><br />Du kan klicka på en nivå för att gå tillbaka ett eller flera steg.";
$pgv_lang["ppp_placelist_help"]			= "~ORTSHIERARKI~<br /><br />I denna lista kan du se orterna som hittats under den nuvarande orten som du valt. Om du inte har valt någon ort, kommer du att se en lista av den översta nivån av orter (t.ex länder eller län).<br /><br />Namnen på platerna går att klicka på. Klicka på en ort fungerar som ett filter. Det gör att du kommer ner en nivå i listan.";
$pgv_lang["ppp_placelist_help2"]		= "~ORTSLISTA~<br /><br />I denna lista kan du se alla platser som har hittats hittills.<br /><br />Namnen på platserna i listan är klickbara. Klickandet på en ort fungerar som ett filter. Det kommer att föra dig en nivå längre ner.<br /><br />När du är på den högsta nivån kommer namnlistan inte visas. På alla andra lägre nivåer kommer du få se en lista på alla personer och/eller familjer som haft samröre med orten.";
$pgv_lang["ppp_view_records_help"]		= "~#pgv_lang[view_records_in_place]#~<br /><br />Klicka på denna länk kommer att visa en lista av alla individer och familjer som har händelser som har inträffat på denna ort. När du kommer till slutet av platslistan t.ex. en by eller stad, kommer namnen att visas automatiskt.";
$pgv_lang["ppp_name_list_help"]			= "~NAMNLISTA~<br /><br />Denna boxen visar en komplett lista på personer och/eller familjer som relaterade på något sätt till orten.<br /><br />Namnen i listan klickbara. När du klickar på ett namn, kommer du till ansedeln för personen eller familjen. Du kan också välja att ändra ditt val genom att klicka på orten överst i listan.";

//-- Multimedia-page
$pgv_lang["help_medialist.php"]			= "~MULTIMEDIA OBJEKTLISTA~<br /><br />Denna sida listar alla multimediaobjekt (MMO) som hittas i denna GEDCOM-fil.<br /><br />För varje mediaartikel ser du titeln eller filnamnet för objektet, namnet på personen eller familjen som är kopplade till MMO-objektet och eventuella anteckningar.<br /><br />Att klicka på artikelns titel eller filnamn har samma effekt som att klicka på dess miniatyrbild. Objektet öppnas i bildvisaren inbyggd i PhpGedView eller i visaren som anges i din webbläsares konfiguration.<br /><br />När du klickar på länken \"Visa\" bredvid personen eller familjen kommer du tas till relevant informationssida.";

//-- Upload Media-page
$pgv_lang["help_uploadmedia.php"]		= "~UPPLADNING AV MEDIAFILER~<br /><br />Ladda upp filer är enkelt, men här kommer lite extra information.<br /><br /><b>Miniatyrbilder</b><br />Miniatyrer ska ha en storlek någonstans runt 100 px bredd. Miniatyren <u>måste</u> namnges identiskt med versionen i full storlek. Om ditt system kan generera miniatyrer automatiskt ser du ett meddelande om detta på sidan Ladda upp media.<br /><br /><b>Uppladdning</b><br />Filer överförs automatiskt till mappen <b>#GLOBALS[MEDIA_DIRECTORY]#</b> för versionen i full storlek och till <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> för miniatyrerna.<br /><br />#pgv_lang[readme_help]#";

//-- Anniversaries-page
$pgv_lang["help_calendar.php"]			= "~#pgv_lang[anniversary_calendar]#~<br /><br /><ul><li><a href=\"#calendar_general\"><b>Generell information</b></a><li><a href=\"#calendar_day\"><b>#pgv_lang[day]#</b></a><li><a href=\"#calendar_month\"><b>#pgv_lang[month]#</b></a><li><a href=\"#calendar_year\"><b>#pgv_lang[year]#</b></a><li><a href=\"#calendar_show\"><b>#pgv_lang[show]# / #pgv_lang[showcal]#</b></a><li><a href=\"#calendar_sex\"><b>#pgv_lang[sex]#</b></a><li><a href=\"#calendar_event\"><b>Händelse</b></a><li><a href=\"#calendar_button\"><b>Knappar för visa dag / månad / år</b></a><li><a href=\"#calendar_tip\"><b>Tips</b></a></ul><br /><a name=\"calendar_general\"></a>Funktionen i jubileumskalendern är att visa personer eller familjer som är kopplade till en händelse en viss dag och/eller månad eller under en viss tid. Den har ett avancerat filter för att välja ut rätt datum eller period och händelser för dig.<dl><dt><b>Visa <a href=\"#calendar_day\">Dagmod</a></b></dt><dd>Denna visar händelser en vissa dag oberoende av det valda året. Resultatet blir antingen en enkel lista med namn på personer eller familjer eller en dubbellista med på ena sidan personer och på andra sidan familjer.</dd><dt><b>Visa <a href=\"#calendar_month\">Månadsmod</a></b></dt><dd>I kalendern visas namnen på både personer och familjer inom boxen. Kalendern visas som den såg ut vid det år du skrev in i årsboxen. Alla händelser som hänt i det förflutna fram till året du angav visas.<br /><br />I kombination med valet <a href=\"#calendar_show\"><b>#pgv_lang[recent_events]#</b></a> ger det en realistisk bild av hur en kalender såg ut för våra anor.</dd><dt><b>Visa <a href=\"#calendar_year\">År</a></b></dt><dd>Detta val visar händelser ett visst år eller under ett antal år. Resultatet blir antingen en enkel lista med namn på personer eller familjer eller en dubbellista med på ena sidan personer och på andra sidan familjer.</dd></dl>I en markerad färg visas den nuvarande dag, månad och vilka händelser som visas.<br /><br />Namnen som visas i listan eller kalendern är klickbara. Klicka på ett namn och du kommer till ansedeln för denna person eller familj, klicka på ett datum kommer att föra dig till \"Idag\"-mod (eller år)som kommer att visa alla händelser för den dag och månad som du klickade på.<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_day\"></a> #pgv_lang[annivers_date_select_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_month\"></a> #pgv_lang[annivers_month_select_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_year\"></a> #pgv_lang[annivers_year_select_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_show\"></a> #pgv_lang[annivers_show_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_sex\"></a> #pgv_lang[annivers_sex_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_event\"></a> #pgv_lang[annivers_event_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_button\"></a> #pgv_lang[day_month_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_tip\"></a> #pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"]		= "~DATUMVÄLJARE~<br /><br />Översta raden av väljartabellen är <b>Dagväljaren</b>. Meningen med den är uppenbar: Du väljer en <u>dag</u>.<br /><br />Resultatet av att klicka på en dag beror på om du är i <b>dagmod</b> eller <b>månadsmod</b>.<br /><dl><dt><b>Dagmod</b>:</dt><dd>I denna mod när du klicka på en dag, kommer skärmen att laddas om och listan för dagen du tryckt visas.</dd><dt><b>Månadsmod</b>:</dt><dd>När du har kalendern för en viss månad på skärmen och klicka på en dag i \"dagraden\" i väljartabellen, skärmen kommer att laddas om, men du kommer fortfarande se månaden du hade innan.<br />Orsaken till detta är att du fortfarande kan välja en annan månad, år eller händelse att visa innan du klickar på <b>#pgv_lang[viewday]#</b> eller <b>#pgv_lang[viewmonth]#</b> knappen.</dd></dl><br />I slutet av dagraden ser du <b>snabblänkar</b> med dagens datum. Klicka på den <b>snabblänken</b> kommer att visa dagen lista, i <b>dagmod</b>, oavsett om du är <b>månadsmod</b> eller <b>dagmod.</b>";
$pgv_lang["annivers_month_select_help"]		= "~MÅNADSVÄLJAREN~<br /><br />Mittenraden i väljartabellen är <b>Månadsväljare</b>. Meningen med den är uppenbar: Du väljer en <u>månad</u>.<br /><br />Resultatet av att klicka på en månad beror på om du är i <b>dagmod</b> eller <b>månadsmod</b>.<br /><dl><dt><b>Dagläget</b>:</dt><dd>I detta läget när du klickat på en månad kommer skärmen att laddas om och listan kommer att visas med datumen för den nya valda månaden.<br />Alla andra inställningar som dag, månad, år och händelser kommer att förbli desamma.</dd><dt><b>Månadsläget</b>:</dt><dd>När du har kalendern i månadsläge på skärmen och klickar på en månad i \"månadsraden\" i väljartabellen, kommer den nya månaden att visas.</dd></dl><br />Vid slutet på månadsraden i väljartabellen kommer du att se <b>snabblänk</b> till den nuvarande månaden. Klicka på <b>snabblänken</b> och den nuvarande månaden kommer att visa, oavsett om du är i månadsläget eller dagläget.";
$pgv_lang["annivers_year_select_help"]	= "~ÅRSBOXEN~<br /><br />Med den här inmatningsrutan kan du ändra kalenderåret. Skriv ett år i rutan och tryck på <b> Enter </b> för att ändra kalendern till det året.<br /><br /><b>Avancerade finesser</b> för <b>#pgv_lang[viewyear]#</b><dl><dt><b>Mer än ett år</b></dt><dd>Du kan söka efter datum inom ett antal år.<br /><br />Årsintervall är <u>inklusive</u>. Detta innebär att datumintervallet sträcker sig från 1 januari det första året av intervallet till 31 december förra året som nämns. Här är några exempel på årskategorier:<br /><br /><b>1992-5</b>&nbsp;&nbsp;&nbsp;för alla händelser 1992 till 1995.<br /><b>1972-89</b>&nbsp;&nbsp;&nbsp;för alla händelser från 1972 till 1989.<br /><b>1610-759</b>&nbsp;&nbsp;&nbsp;för alla händelser från 1610 till 1759.<br /><b>1880-1905</b>&nbsp;&nbsp;&nbsp;för alla händelser från 1880 till 1905.<br /><b>880-1105</b>&nbsp;&nbsp;&nbsp;för alla händelser från 880 till 1105.<br /><br />För att se alla händelser under ett visst decennium eller århundrade kan du använda <b>#pgv_lang[qm]#</b> istället för de sista siffrorna. Till exempel, <b>197?</b>&nbsp;&nbsp;&nbsp;för alla händelser från 1970 till 1979 eller <b>16??</b>&nbsp;&nbsp;&nbsp;för alla händelser från 1600 till 1699.<br /><br />Om du väljer ett årintervall ändras kalendern till årsvyn.</dd></dl>";
$pgv_lang["annivers_show_help"]			= "~VISA HÄNDELSER FÖR ...~<br /><br />När du inte är inloggad kan du välja mellan två val:<ul><li><b>Alla Personer</b><br />Med detta val, alla personer och familjer visas.</li><li><b>Nyligen inträffade händlese (&lt; 100 år)</b><br />Med detta val kommer du att se alla händelser under den valda dagen/månaden, men inte händelser äldre än 100 år.</li><li><b>Levande personer</b><br />När du väljer detta val, visas endast levande personer. För detta måste du antingen vara inloggad eller måste administratören ha satt upp systemet så att alla kan se levande personer.</li></ul>När du klickar på ett val, händelserna kommer att visas beroende ditt val.<br /><br />Inställningar för dag, månad och år, precis som <b>dag</b> eller <b>månad</b>-mod kommer att förbli som de var.";
$pgv_lang["annivers_sex_help"]			= "~VAL AV KÖN~<br /><br />När du är inloggad (eller om administratören har valt bort integritetsinställningar) har du tre val:<ul><li><b>Alla</b> ikonen<br />Med detta val(standard) visas händelser för alla personer och familjer.</li><li><b>Mans</b> ikonen<br />Vid detta val visas endast händelser för manliga personer. Manliga medlemmar i familjer kommer att visas vid familjehändelser.</li><li><b>Kvinno</b> ikonen<br />Vid detta val visas endast händelser för kvinnliga personer. Kvinnliga medlemmar i familjer kommer att visas vid familjehändelser.</li></ul>Om man klickar på ett av valen kommer skärmen att uppdateras och händelserna som du valt kommer att visas.<br /><br />Andra inställningar för dag, månad, år och händelser och mod kommer att förbli som de var.";
$pgv_lang["annivers_event_help"]		= "~HÄNDELSEVÄLJARE~<br /><br />Här väljer du om du vill att alla händleser för personer och familjer ska visas eller bara de händelser du valt. Du kan inte välja mer än en händelsekategori.<br /><br />Klicka på ett val kommer att uppdatera skärmen och de valda händelserna kommer att visas.<br /><br />Andra inställningar som dag, månad, år och händleser och mod kommer att förbli som de var.";
$pgv_lang["annivers_tip_help"]			= "~TIPS~<br /><br />Justera datumväljaren till vilket datum som helst.<br /><br />När du klickar på en av Visa-knapparna ser du en lista eller kalender för det datumet. Alla åldrar, årsdagar etc. har räknats om och räknas nu från det datum som du ställer in i Datumväljaren. Du ser nu kalendern eller listan som din förfader skulle ha sett på det datumet för flera år sedan.";
$pgv_lang["day_month_help"]			= "~VISA DAG / VISA MÅNAD / VISA ÅR KNAPPEN~<br /><br /><ul><li><b>Visa dag</b>-knappen kommer visa händelser av den valda dagen i en lista. Alla år scannas, så endast dag och månad kan sättas. Ändring av året har ingen effekt. Du kan begränsa valen med <b>senaste åren</b> eller <b>levande personer</b>.<br /><br />Årtalen i listan kommer att beräknas från det innevarande året.</li><li><b>Visa månad</b>-knappen kommer att visa en kalender för den valda månaden och året. Även här kan du begränsa valen med <b>senaste åren</b> eller <b>levande personer</b>.<br />Genom att välja ett år i det förflutna i kombination med <b>senaste året</b>, kommer du att få ett realistisk intryck av vad en kalender på väggen hos dina anfäder skulle sätt ut. Alla årtal på kalendern visas relativt till årtalet i årsrutan.</li><li><b>Visa året</b>-knappen kommer att visa dig en lista av händelser för det valda året.<br />Även här kan du begränsa valen med <b>senaste åren</b> eller <b>levande personer</b>.<br /><br />Ett trevlig val är möjligheten att välja händelser från mer än ett år: Skriv bara nummret på det sista året direkt efter det första året med ett <b>-</b> i mellan. Exempel:<br /><b>1992-4</b> för alla händelser från 1992 till 1994<br /><b>1976-1984</b> för alla händleser från 1976 till 1984.<br /><br />För att se alla händelser under ett visst decennium eller århundrade kan du använda <b>#pgv_lang[qm]#</b> istället för de sista siffrorna. Till exempel <b>197?</b> för alla händelser från 1970 till 1979 eller <b>16??</b> för alla händelser från 1600 till 1699.</li></ul>När du vill <b>ändra året</b> du <b>har</b> att trycka på en av dessa tre knappar. Alla andra inställningar förblir som de var.";

//-- Clippings Cart-page
$pgv_lang["help_clippings.php"]			= "~#pgv_lang[clippings_cart]#~<br /><br />#pgv_lang[clip_cart]# låter dig ta utdrag (\"utklipp\") från detta släktträd och sammanställa dem i en enda fil för nedladdning och efterföljande import till ditt eget släktforskningsprogram. Den nedladdningsbara filen är inspelad i GEDCOM-format.<br /><ul><li>Hur tar man urklipp?<br />Det här är väldigt enkelt. När du ser ett klickbart namn (enskild, familj eller källa) kan du gå till sidan Detaljer i det namnet. Där ser du alternativet <b>#pgv_lang[add_to_cart]#</b>. När du klickar på den här länken får du flera alternativ att ladda ner.</li><li>Hur man laddar ner?<br />När du har saker i urklippskorgen, kan du ladda ner dem genom att klicka på länken <b>Ladda ner nu</b>. Följ anvisningarna och länkarna.</li></ul>";
$pgv_lang["clip_download_help"]			="~#pgv_lang[download_now]#~<br /><br />Genom att klicka på denna länk, kommer du att flyttas till nästa sida. Om det finns fler val av vad som ska laddas ner kommer de att visas på denna sida.<br /><br />Följ bara instruktionerna.";
$pgv_lang["empty_cart_help"]			="~#pgv_lang[empty_cart]#~<br /><br />Genom att klicka på denna länk kommer #pgv_lang[clip_cart]# att tömmas helt.<br /><br />Om du inte vill ta bort alla personer, familjer etc. från #pgv_lang[clip_cart]# kan du ta bort dem en och en genom att klicka på <b>Tabort</b> länken i namnboxarna. Det finns <u>ingen</u> konfirmationsdialog när du klickar på någon av dessa länkar, raderingen sker omedelbart.";
$pgv_lang["add_by_id_help"]				= "~Urklippskorg lägg till med ID~<br /><br />Denna box låter dig skriva in en persons ID-nummer så att han kan läggas till i urklippskorgen. Väl tillagd kommer du få frågan om du vill lägga till personens relationer till urklippskorgen.<br /><br />Om du inte vet en persons ID-nummer kan du utföra en sökning via namn genom att trycka på personikonen intill Lägg till knappen.";
$pgv_lang["zip_help"]					= "~ZIP-URKLIPP~<br /><br />Välj detta val för att spara din urklipp i en ZIP-fil. För mer information om ZIP-filer, besök <a href=\"https://sv.wikipedia.org/wiki/Zip\" target=\"_blank\">https://sv.wikipedia.org/wiki/Zip</a>.";
$pgv_lang["include_media_help"]			= "~INKLUDERA MEDIA~<br /><br />Välj detta val för att inkludera mediafiler associerade med poster som finns i din urklippskorg. Om du väljer detta val kommer filerna automatiskt zipas vid nerladdning.";
$pgv_lang["clip_cart_help"]				= "~#pgv_lang[clippings_cart]#~<br /><br />Detta blocket visar dig innehållet i din urklippskorg.<ul><li><i>Typ</i>-kolumnen visar typen för varje post, som kan var Person (INDI), familj (FAM), källa (SOUR), arkiv (REPO), anteckning (NOTE) och media (OBJE) varje är representerad av ssin egen ikon.</li><li><i>ID</i>-kolumnen visar ID-nummret för varje post av den typen.</li><li><i>Namn / beskrivning</i>-kolumnen ger antingen namnet på familjen eller personen eller en beskrivning av posten.</li></ul>Tabort knappen tar bort den psoten från urklippskorgen. <b>Bekräftelse att ta bort krävs INTE.</b>";

//-- GEDCOM Edit Utility
$pgv_lang["show_changes_help"]			="~#pgv_lang[review_changes]#~<br /><br />När du ser detta meddelande, betyder det två saker:<ol><li>Någon har gjort ändringar i GEDCOM-filen<br />Post(er) kan ha lagts till, raderats eller ändrats.</li><li>Ändringarna har inte ännu accepterats av administratören.<br />När ändringarna har accepterats (eller inte blivit accepterad), försvinner detta meddelande.</li></ol>Genom att klicka på länken, kan du se vad för ändringar som gjorts. Meddela administratören om du märker att en ändring inte är korrekt.";

//-- Search-page
$pgv_lang["help_search.php"]			="~SÖKSIDAN~<br /><br />Även om denna sida ser väldigt enkel ut, så bakom de två formulären på sidan finns en väldigt kraftfull sökmotor. De flesta genealogiska sajter låter dig endast söka efter efternamn. På denna sida kan nästan söka efter vad som helst.<br /><br />Sökboxen på vänster sida av skärmen är densamma som i huvudet.<br /><br />Om du letar efter personer med anknytning till ett visst år, skriv bara årtalet. Progammet kommer att hitta alla kopplingar åt dig.<br /><br />Letar du efter ett namn, eller ort? Skriv bara in namnet eller orten, komplett eller bara delar av det och programmet gör resten.<br /><br /><b>SOUNDEX-sökmetod.</b><br />Med sökboxen på höder sida, kan du söka efter namn eller platser även om du inte vet hur de hur de stavas.<br /><br />När det finns flera släktforskningsdatabaser på din webbplats och administratören har aktiverat att växla mellan dem kommer din sökning att returnera resultaten för dem alla.<br /><br />Du får mer hjälp om du söker om dessa två boxar genom att klicka på <b>#pgv_lang[qm]#</b> ovanför boxarna.";
$pgv_lang["search_enter_terms_help"]		="~#pgv_lang[enter_terms]#~<br /><br />I sökboxen kan du skriva in kriterier som datum, förnamn, efternamn, orter, multimedia, etc.<br /><br /><b>Jokertecken</b><br />Vanliga jokertecken (som * eller ?) är inte tillåtna, men programmet använder alltid jokertecken.<br /><br />Antag att du skriver in följande: <b>Pete</b>. Resultatet (namnen måste naturligtvis finnas i databasen) blir:<div style=\"padding-left: 30px;\"><b>Pete</b> Smith<br /><b>Pete</b>r Johnes<br />Will <b>Pete</b>rson<br />Någon född den 01 Januari 1901 i <b>Pete</b>rsburg<br />etc.</div><br /><b>Datum</b><br />Om man skriver in ett år i sökboxen blir resultatet, alla namn på personer som på något sätt har anknytning till detta år.<br /><br />Om du skriver <b>1950</b> blir resultatet alla individer med en händelse som inträffade 1950. Dessa händelser kan vara födslar, dödsfall, äktenskap, bar mitzvahs, SLD-förseglingar etc.<br /><br />Om du skriver <b>4 Dec</b> listas alla personer som är anslutna till en händelse som inträffade den 4 december oavsett år. Personer som är anslutna till ett evenemang den 14 eller 24 december kommer också att listas. Som du ser antas alltid jokertecken, så du behöver inte skriva dem. Ibland kan resultaten vara överraskande.<br /><br /><b>Korrekt datum</b><br />PhpGedView söker efter data, eftersom de lagras i GEDCOM-filen. Om du till exempel vill söka efter ett evenemang den 14 december ska du skriva <b>14&nbsp;dec</b> eftersom det är så datumet lagras i databasen.<br /><br />Om du skulle skriva <b>dec&nbsp;14</b>, resultatet kan bli en person som är kopplad till ett evenemang den 08&nbsp;<b>dec</b>ember&nbsp;18<b>14</b>. Återigen kan resultaten vara överraskande.<br /><br />Du kan också använda reguljära uttryck i din sökning om du är bekant med dem. T.ex om du vill hitta alla personer som har datum i det 1900-talet, kan du skriva <b>19[0-9][0-9]</b> och du kommer att få träff på alla personer med datum från 1900-1999.<br /><br />#pgv_lang[soundex_search_help]#<br /><br />#pgv_lang[search_replace_help]#<br /><br />Om du behöver mer hjälp med detta söksystem, kontakta oss, så att vi kan utöka denna hjälp mer.";
$pgv_lang["search_replace_help"]		= "~#pgv_lang[search_replace]#~<br /><br />Här kan du söka efter en felstavning eller annan felaktig information och ersätta den med korrekt information.<br /><br /><b>Sökning</b><br />Denna funktion gör en sökning precis som <a href=\"help_text.php?help=search_enter_terms_help\">normal sökning</a>.<br /><br /><b>Ersättning</b><br />Alla träffar från sökningen kommer att ersättas med ersättningstermen i databasen.<br /><br /><b>Till exempel...</b><br />Antag att du av misstag stavade fel till farfar Michaels namn. Du skrev av misstag 'Micheal'.<br /><br />Då skriver du <b>Micheal</b> i sökrutan och <b>Michael</b> i ersättningsrutan.<br />Alla träffar för \"Micheal\" kommer då att ersättas med \"Michael\"<br /><br /><b>Sök efter...</b><br />Välj sökningens omfång. Du kan begränsa sökningen till namn eller platser, eller tillämpa ingen gräns (sök i allt). Alternativet <i>#pgv_lang[search_place_word]#</i> söker bara efter din term i platsfältet som ett helt ord. Det betyder att sökning efter <i>UT</i> bara skulle matcha <i>UT</i> och inte <i>UT</i> med andra ord som Connectic<b>ut</b>.<br /><br />Oroa dig inte om du av misstag byter ut något där du inte vill. Klicka bara på länken \"Acceptera / avvisa ändringar\" längst ned på sidan för att acceptera de ändringar du vill ha och avvisa de ändringar du inte vill ha.";
$pgv_lang["soundex_search_help"]		= "~#pgv_lang[soundex_search]#~<br /><br />Soundex är en metod för kodning av ord enligt deras uttal. Detta gör att du kan söka i databasen efter namn och platser när du inte vet exakt hur de skrivs. PhpGedView stöder två olika Soundex-algoritmer som ger mycket olika resultat.<ul><li><b>#pgv_lang[search_russell]#</b><br />Denna metod, patenterad 1918 av Russell, är väldigt enkel och kan göras för hand.<br /><br />Den enkla algoritmen passar inte bra för namn som ursprungligen fanns på andra språk än engelska, och även med engelska namn, resultaten är mycket överraskande. Till exempel en enkel Soundex-sökning efter <b>Smith</b> inte bara att returnera <b>Smith, Smid, Smit, Schmidt, Smyth, Smithe, Smithee, Schmitt</b>, som alla är tydliga variationer av <b>Smith</b>, men också <b>Smead, Sneed, Smoote, Sammett, Shand,</b> och <b>Snoddy</b>.</li><br /><li><b>#pgv_lang[search_DM]#</b><br />Denna metod, som utvecklades 1985, är mycket mer komplex än den enkel metoden och görs inte lätt för hand.</li></ul>För information om båda Soundex-algoritmerna, besök detta <a href=\"http://www.jewishgen.org/infofiles/soundex.html\" target=_blank><b>Jewish Genealogical Society</b></a> webbsida.";
$pgv_lang["search_exclude_tags_help"]	= "~#pgv_lang[search_tagfilter]#~<br /><br />Valet <b>#pgv_lang[search_tagfon]#</b> gör att sökfunktionen ignorerar följande GEDCOM-taggar:<div style=\"padding-left: 30px;\"><b>_PGVU</b> - Senaste ändring gjord av<br /><b>CHAN</b> - Senaste ändringsdatum<br /><b>FILE</b> - #factarray[FILE]#<br /><b>FORM</b> - #factarray[FORM]#<br /><b>TYPE</b> - #factarray[TYPE]#<br /><b>SUBM</b> - #factarray[SUBM]#<br /><b>REFN</b> - #factarray[REFN]#</div><br />Förutom dessa valfria uteslutna taggar utesluter sökfunktionen alltid dessa taggar:<div style=\"padding-left: 30px;\"><b>_UID</b> - #factarray[_UID]#<br /><b>RESN</b> - #factarray[RESN]#</div>";
$pgv_lang["search_include_ASSO_help"]	= "~#pgv_lang[search_asso_label]#~<br /><br />Det här alternativet gör att PhpGedView visar alla individer som har registrerats som en koppling till den här personen eller familjen. Det omvända är inte möjlig.<br /><br />Exempel: Antag att person <b>A</b> är gudfader till person <b>B</b>. Detta förhållande registreras i GEDCOM-posten för person <b>B</b> med hjälp av en ASSO-tagg. Det finns ingen motsvarande tagg i GEDCOM-posten för person <b>A</b>.<br /><br />När detta alternativ är inställt på <b>#pgv_lang[yes]#</b> och sökresultatlistan innehåller <b>B</b>, kommer <b>A</b> att inkluderas automatiskt på grund av ASSO tagg i GEDCOM-posten för <b>B</b>. Men om sökresultatlistan innehåller <b>A</b>, kommer <b>B</b> inte att tas med automatiskt eftersom det inte finns någon matchande ASSO-tagg i GEDCOM-posten för person <b>A</b>.";

//-- Advanced Search-page
$pgv_lang["advanced_search_help"] = "~#pgv_lang[advanced_search]#~<br /><br />Den här funktionen låter dig söka i de angivna fälten för personposter i din genealogiska databas.<br /><br />När du klickar på knappen <b>#pgv_lang[search]#</b> alla fält för vilka värden har angetts kommer att granskas och poster i din genealogiska databas som uppfyller <u>alla</u> kriterier kommer att returneras. Medan den inledande dialogrutan erbjuder några av de vanligaste fälten, längst ner i dialogrutan kan du klicka på <b>#pgv_lang[more_fields]#</b> för att utöka listan över fält som ska undersökas.<br /><br />~Fält som innehåller datum~<br />Avancerade sökningar är baserade på årtal, så till skillnad från proceduren «#pgv_lang[search_general]#» som kan acceptera ett datum utan ett år, kräver alla dessa fält minst året, men kan också acceptera specifikationer för hel dag, månad och år. Det går till exempel inte att söka efter något som hände i april något år.<br /><br />Varje ruta för sökdatumsfält har också en modifierare, så att du kan söka efter <b>#pgv_lang[exact]#</b> datum som angetts, eller ett relativt datum med <b>+/-</b> ett antal år. Att skriva ett år i datumfältet, sedan välja en modifierare och sedan klicka på <b>#pgv_lang[search]#</b> knappen kommer att resultera i en lista över personer som är anslutna till det året eller årsintervallet.<br /><br />Om du till exempel skriver «APR 1950» i födelsedatumfältet som har <b>#pgv_lang[exact]#</b> modifieraren, kommer resultatet att vara alla personer med en händelse som inträffade först i april 1950. Varje datumfält kommer att söka efter datum som är specifika för den händelsen. Att lägga till en <b>+/- 10</b> modifierare skulle returnera datum mellan 1 april 1940 och 31 mars 1960. De andra modifierarna skulle på liknande sätt ändra sökårsintervallen. Genom att bara ange ett år, till exempel «1950», kommer sökningen att returnera alla händelser inom det angivna året.<br /><br /><b>Datumformat för sökningar</b><br />Varken jokertecken eller reguljära uttryck kan användas i dina sökdatumsfält. Ordningen på dag, månad, år och versaler är irrelevanta. «dd MMM åååå» har samma betydelse som «åååå MMM dd». Men om du vill söka efter en händelse den 14 december 1926 bör du skriva in den som «14 DEC 1926» eftersom det är så datumet lagras i databasen. För att söka efter ett datum över flera händelser (t.ex. födslar, dödsfall, äktenskap, Bar Mitzvahs, LDS-förseglingar, etc) eller om bara dagen eller månaden är känd, är det bättre att använda «#pgv_lang[search_general]#» funktionen.<br /><br />~Fält som innehåller namn~<br />Fälten <b>#pgv_lang[given_name]#</b> och <b>#pgv_lang[surname]#</b> kan användas för att ange de olika delarna av ett namn som ska sökas i. Detta filtrerar enkelt bort namn som kan vara både förnamn eller efternamn, till exempel «Terry» eller «Henry».<br /><br />Namnfälten har också en modifierare som hjälper till att kvalificera vad som skrivs in mot vad som söks efter. Modifierarna inkluderar:<ul><li><b>#pgv_lang[exact]#</b>&nbsp;&nbsp;anger en skiftlägeskänslig sökning i hela fältet efter den exakta texten som skrivs in. Sökningen är också känslig för alla inbäddade tecken, mellanrum etc. Om t.ex. fältet innehåller ett mellanslag men posten i databasen har två på samma position, kommer posten inte att hittas.</li><li><b>#pgv_lang[begins_with]#</b>&nbsp;&nbsp;anger en skiftlägesokänslig sökning efter poster där ett namn börjar med det som finns i fältet. Om ett namnfält innehåller flera namn (som för- och mellannamn) kommer matchningen att göras med början av varje del av namnet som är avgränsad med ett mellanslag.</li><li><b>#pgv_lang[contains]#</b>&nbsp;&nbsp;anger en skiftlägeskänslig sökning efter poster där den fullständiga inmatade informationen i fältet kommer att sökas efter var som helst inom målpostens namntext. Om du till exempel lägger ett enstaka mellanslag i sökfältet <b>#pgv_lang[given_name]#</b> med modifieraren <b>#pgv_lang[contains]#</b> hittar du alla poster som måste ha ett förnamn och minst ett mellannamn eller initial.</li><li><b>#pgv_lang[sounds_like]#</b>&nbsp;&nbsp;anger en skiftlägesokänslig sökning efter poster som liknar det som finns i fältet. Detta gör att du kan söka i databasen efter namn och platser när du inte vet exakt hur de är skrivna.</li></ul><br />~Fält utan modifierare~<br />Poster i fält utan modifierare är skiftlägesokänsliga sökningar. Den inmatade texten kommer att sökas efter var som helst inom målpostens händelsetext.";

//-- Individual Information-page
$pgv_lang["help_individual.php"]		= "~#pgv_lang[indi_info]# SIDAN~<br /><br />Alla detaljer om en person visas på denna sida.<br /><br />Om det finns en bild tillgänglig ser du den längst upp till vänster. Du kommer att se namnen på personen bredvid bilden.<br /><br />Namnen kan ha anteckningar och källor kopplade till dem. Om något av namnen har anteckningar eller källor ser du dem listade under namnen de relaterar till.<br /><br />En person kan ha en AKA (kanske är han känd under ett annat namn). Om så är fallet kommer det att visas.<br /><br />Om du har redigeringsrättigheter för den här personen kommer du också att se länkarna <b>Redigera</b> och <b>Ta bort</b> bredvid objekten som du kan redigera.<br /><br />På den här sidan ser du flikblad för <b>#pgv_lang[personal_facts]#</b>, <b>#pgv_lang[notes]#</b>, <b>#pgv_lang[ssourcess]#</b>, <b>#pgv_lang[media]#</b>, och <b>#pgv_lang[relatives]#</b>.Dessa flikar visar dig all information om den personen som lagras i databasen.<ul><li><b>#pgv_lang[personal_facts]#</b>&nbsp;&nbsp;&nbsp;kommer att visa dig fakta och detaljer om den här personen och alla fakta från deras äktenskap. Genom att klicka på ett datum på den här fliken kommer du till #pgv_lang[anniversary_calendar]# för det datumet, så att du kan se andra händelser som hände samma dag. Genom att klicka på en plats kommer du till platshierarkin där du kan se andra personer som hade evenemang på samma plats. För äktenskap och andra familjerelaterade fakta är namnet på personens make tillgänglig så att du kan se makan och en länk till familjeposten ges också.</li><li><b>#pgv_lang[notes]#</b>&nbsp;&nbsp;&nbsp;visar dig allmänna anteckningar som rör den här personen.</li><li><b>#pgv_lang[ssourcess]#</b>&nbsp;&nbsp;&nbsp;visar alla <u>allmänna</u> källor för den här personen. Dessa källor är <u>inte</u> kopplade till enskilda fakta, inte ens personens namn; de är associerade med personen själv. Genom att klicka på källans titel kommer du till en mer detaljerad källinformationssida som visar andra personer som också är länkade till samma källa.</li><li><b>#pgv_lang[media]#</b>&nbsp;&nbsp;&nbsp;kommer att lista alla bilder och andra medieobjekt som är bifogade den här personen. Genom att klicka på en miniatyr av bilden öppnas en större bild av bilden. Genom att klicka på bildtexten visas bilden på #pgv_lang[media_list]# sidan.</li><li><b>#pgv_lang[relatives]#</b>&nbsp;&nbsp;&nbsp;listar denna persons föräldrar och syskon samt alla makar och barn som personen har haft. Dessa personer kommer att listas i rutor som liknar diagrammen som du kanske redan har sett.</li></ul>Till höger om skärmen hittar du en ruta med länkar. Många av länkarna i rutan är desamma som länkarna i menyerna. Om du till exempel klickar på länken <b>#pgv_lang[pedigree_chart]#</b> på sidlänkarna kommer du till stamtavlan för den här personen. Detta skiljer sig från menylänkarna, eftersom att klicka på länken <b>#pgv_lang[pedigree_chart]#</b> i menyn tar dig tillbaka till standardstamtavlan för denna databas.<br /><br />En av länkarna som kan visas i den här listan om den har aktiverats av admin är länken <b>#pgv_lang[view_gedcom]#</b>. Denna länk visar dig den råa GEDCOM-posten för denna person.<br /><br />Om #pgv_lang[clip_cart]# har aktiverats av webbplatsadministratören kommer du också att ha en länk som gör att du kan lägga till den här personen i din #pgv_lang[clip_cart]#.<br /><br />Länken <b>#pgv_lang[relationship_to_me]#</b> visas bara om du är inloggad och har tilldelats ett ID i GEDCOM. Denna länk tar dig till stamtavlan och visar hur du är relaterad till den här personen.<br /><br />#pgv_lang[context_help]#";
$pgv_lang["delete_person_help"]			= "~#pgv_lang[delete_person]#~<br /><br />Genom att klicka på detta val kommer du att markera personen för radering från GEDCOM-filen.<br /><br />Vad betyder detta? Antag att det finns en bra anledning att radera denna person från GEDCOM-filen. Klicka på länken, då får du upp ett fönster som frågar om du är säker på eller om du avbryta. När fortsätter med besöket kommer du att märka att personen fortfarande är synlig och kan fortfarande användas som innan.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["delete_name_help"]			= "~EDITERA ELLER RADERA NAMN FRÅN GEDCOM-FIL~<br /><br /><b>EDITERA NAMN</b><br />Genom att klicka på denna länk, öpnnas ett fönster, som du kan editera namnet på personen. Det är enkelt, bara skriv in ändringarna i rutan, klicka på knappen, och stäng fönstret.<br /><br /><b>RADERA NAMN</b><br /><br />Genom att klicka på detta val kommer du att markera namnet för radering ur GEDCOM-filen. Kom ihåg att radera namnet är helt annerlunda en att radera personen. Radering av namnet tar bara bort namnet från personen. Personen kommer inte att raderas. Om det är ett alias du vill radera så kommer personen ha kvar sitt vanliga namn. Om det är personens ända namn som du vill radera kommer personen ändå inte att bli raderad utan bli kvar som <b>#pgv_lang[NN]#</b>. Personen kommer inte häller att kopplas ifrån alla andra kopplingar som släktingar, källor, anteckningar etc.<br /><br />Hur fungerar detta? Låt oss anta att du har en bra anledning att radera namnet ur GEDCOM-filen. Du klickar på länken och efter detta kommer ett fönster upp med frågan om du är säker eller vill avbryta. När du fortsätter ditt besök på sajten, kommer du att märka att namnet fortfarande syns och kan användas som förut.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["add_name_help"]				= "~LÄGG TILL NYTT NAMN~<br /><br />Denna länk kommer att tillåta dig att lägga till en annat namn till en person. Ibland är personer kända under andra namn och alias. Denna länk tillåter dig att lägga till nya namn till en person utan att ändra det gamla.";
$pgv_lang["add_sibling_help"]			= "~#pgv_lang[add_sibling]#~<br /><br />Genom att klicka på denna länk kan du lägga till en ett barn till denna familj. \"Denna familj\", i detta fall, är fadern eller modern till huvudpersonen för denna sida.<br /><br />Tänk på att du ska lägga till ett syskon till den personen. Att lägga till en bror eller syster är enkelt: Klicka bara på länken och fyll i rutorna.<br /><br />Om du vill lägga till en son eller dotter för huvudpersonen, rull ner fönstret lite och klicka på länken i #pgv_lang[as_spouse]#\".";
$pgv_lang["add_son_daughter_help"]		= "~#pgv_lang[add_son_daughter]#~<br /><br />Genom att klicka på denna länk kan du lägga till en ett barn till denna familj. \"Denna familj\", i detta fall, är huvudpersonen för denna sida och hans/hennes gemål.<br /><br />Tänk på att du ska lägga till en son eller dotter till den personen. Att lägga till en son eller dotter är enkelt: Klicka bara på länken och fyll i rutorna.<br /><br />Om du vill lägga till en broder eller syster för huvudpersonen, rull upp fönstret lite och klicka på länken i \"#pgv_lang[as_child]#\".";
$pgv_lang["link_child_help"]			= "~#pgv_lang[link_as_child]#~<br /><br />Du kan länka den här personen som ett barn till en befintlig familj när du klickar på den här länken.<br /><br />Antag att föräldrarna till personen var okända och du upptäckte senare att föräldrarna har en post i den här databasen.<br /><br />Klicka bara på länken, ange familjens ID och du har tävlat med uppgiften. Om du inte känner till familjens ID kan du söka efter det.";
$pgv_lang["link_husband_help"]			= "~#pgv_lang[link_as_husband]#~<br /><br />Med denna artikel kan du länka den nuvarande individen som man till en familj som redan finns i databasen. Genom att klicka på den här länken kan du lägga till den här personen i en befintlig familj, vars man hittills inte var okänd. Den här personen kommer att ta platsen för den tidigare okända mannen. Alla händelser, äktenskapsinformation och barn behåller sina befintliga länkar till familjen.<br /><br />Klicka bara på länken, ange familjens ID och du har tävlat med uppgiften. Detta är ett avancerat redigeringsalternativ som endast bör användas om familjen du vill länka till redan finns. Om du vill lägga till en <u>ny</u> familj till den här personen använder du länken <b>#pgv_lang[add_new_wife]#</b>.";
$pgv_lang["add_husband_help"]			= "~#pgv_lang[add_new_husb]#~<br /><br />Genom att klicka på den här länken kan du lägga till en <u>ny</u> manlig person och länka denna person till huvudindividen som ny make.<br /><br />Klicka bara på länken så får du en popup-fönster för att lägga till den nya personen. Fyll i så många rutor som möjligt och klicka på knappen <b>Spara</b>.";
$pgv_lang["link_new_husb_help"]			= "~#pgv_lang[link_new_husb]#~<br /><br />Detta gör att du kan länka en annan person som redan existerar som ny make till den här personen. Detta skapar en ny familj med den man du väljer. Du har också möjlighet att ange ett äktenskap för den här nya familjen.";
$pgv_lang["add_opf_child_help"]			= "~#pgv_lang[add_opf_child]#~<br /><br />Genom att klicka på den här länken kan du lägga till ett <u>nytt</u> barn till den här personen och skapa en enföräldersfamilj.<br /><br />Klicka bara på länken så får du ett popup-fönster för att lägga till den nya personen. Fyll i så många rutor som möjligt och klicka på knappen <b> Spara </b>.";
$pgv_lang["link_wife_help"]				= "~#pgv_lang[link_as_wife]#~<br /><br />Med det här objektet kan du länka den nuvarande individen som hustru till en familj som redan finns i databasen.<br /><br />Detta är ett avancerat redigeringsalternativ som endast ska användas om familjen du vill länka till existerar redan. Om du vill lägga till en <u>ny</u> familj till den här personen, använd länken <b>#pgv_lang[add_new_husb]#</b>.";
$pgv_lang["add_wife_help"]				= "~#pgv_lang[add_new_wife]#~<br /><br />Genom att klicka på den här länken kan du lägga till en <u>ny</u> kvinnlig person och länka denna person till huvudindividen som ny fru.<br /><br />Klicka bara på länken så får du en popup-fönster för att lägga till den nya personen. Fyll i så många rutor som möjligt och klicka på knappen <b>Spara</b>.";
$pgv_lang["link_new_wife_help"]			= "~#pgv_lang[link_new_wife]#~<br /><br />Detta gör att du kan länka en annan person, som redan existerar, som ny fru till den här personen. Detta skapar en ny familj med den fru du väljer. Du har också möjlighet att ange ett äktenskap för den här nya familjen.";
$pgv_lang["add_new_parent_help"]		= "#pgv_lang[multiple_help]#<br />~LÄGG TILL NY FADER ELLER MODER~<br /><br />Det finns verkligen många individer i GEDCOM utan att ha en far eller mor.<br /><br />I Så fall på sidan <b>#pgv_lang[indi_info]#</b>, flikblad <b>#pgv_lang[relatives]#</b>, tabell <b>#pgv_lang[as_child]#</b>, du hittar länkar för att lägga till en <u>ny</u> far eller mor till personen.<br /><br />Tänk på att dessa länkar är för att lägga till en <u>ny</u> far eller mor. Om pappan eller mamman redan har en post i den här databasen måste du använda länken <b>#pgv_lang[link_as_child]#</b>, som du hittar på den <b>#pgv_lang[indi_info]#</b> sida under den sista tabellen.";
$pgv_lang["show_fact_sources_help"]		= "~#pgv_lang[show_fact_sources]#~<br />~#pgv_lang[show_fact_notes]#~<br /><br />När det här alternativet är markerat kan du se alla käll- eller anteckningar för den här personen. När det här alternativet inte är markerat visas inte käll- eller notposter som är associerade med andra fakta för den här personen.";
$pgv_lang["age_differences_help"]	= "~#pgv_lang[age_differences]#~<br /><br />När den här kryssrutan är markerad visar fliken «#pgv_lang[relatives]#» datumskillnader enligt följande:<ul><li><b>partners födelsedatum.</b><br />Ett negativt värde indikerar att den andra partnern är äldre än den första.</li><li><b>äktenskapsdatum och födelsedatum för det första barnet.</b><br />Ett negativt värde här indikerar att barnet föddes före äktenskapsdatumet eller att antingen födelsedatumet eller äktenskapsdatumet är fel.</li><li><b>födelsedatum för syskon.</b><br />Ett negativt värde här indikerar att antingen barnens ordning är fel eller att ett av födelsedagen är fel.</li></ul>";

//-- Add Facts
$pgv_lang["add_facts_help"]				= "~LÄGG TILL NY FAKTA~<br /><br />Här kan du lägga till ett faktum i posten som redigeras.<br />Välj först ett faktum från listan och klicka sedan på knappen <b>Lägg till</b>. Alla möjliga fakta som du kan lägga till i databasen finns i listan.";
$pgv_lang["add_custom_facts_help"]		= "~Lägg till egna fakta~<br /><br />Om du inte hittar det fakta du vill lägga till, i listan av GEDCOM-fakta, kan du lägga till <b>egna fakta</b> också.<br /><br />Lägga till ett eget fakta är lika enkelt som att lägga till de fördefinierade fakta. Den ända skillnaden är att du måste namnge faktan också. Du måste göra detta i det översta fältet: <b>#pgv_lang[type]#</b>";
$pgv_lang["add_note_help"]				= "#pgv_lang[multiple_help]#<br />~LÄGG TILL NY ANTECKNING~<br /><br />Om du har en anteckning att lägga till den här posten är det här platsen att göra det.<br /><br />Klicka bara på länken, ett fönster öppnas och du kan skriva din anteckning. När du är klar med att skriva, klicka bara på knappen under rutan och stäng fönstret.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_shared_note_help"]	= "#pgv_lang[multiple_help]#<br />~#pgv_lang[add_shared_note_lbl]#~<br /><br />När du klickar på länken <b>#pgv_lang[add_shared_note]#</b> öppnas ett nytt fönster. Du kan välja att länka till en befintlig delad anteckning, eller så kan du skapa en ny delad anteckning och samtidigt skapa en länk till den.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_source_help"]			= "#pgv_lang[multiple_help]#<br />~LÄGG TILL NY KÄLLA citat~<br /><br />Här kan du lägga till en källa <b>citat</b> till denna post.<br /><br />Klicka bara på länken, ett fönster öppnas och du kan välja källan från listan (Hitta ID) eller skapa en ny källa och lägg sedan till citatet.<br /><br />Att lägga till källor är en viktig del av släktforskningen eftersom det gör det möjligt för andra forskare att verifiera var du fick din information.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"]				= "~#pgv_lang[add_media]#~<br /><br />Att lägga till multimediafiler (MM) till GEDCOM är en mycket trevlig funktion. Även om det här programmet redan har ett snyggt utseende utan media, kommer det bara att bli bättre om du lägger till bilder eller andra MM till dina släktingar.<br /><br /><b>Vad du borde förstå om MM.</b><br />Det finns många format av MM. Även om PhpGedView klarar de flesta av dem, finns det några saker att tänka på.<br /><ul><li><b>Format</b><br />Bilder kan redigeras och sparas i många format. Till exempel, .jpg, .png, .bmp, .gif, etc.  Om samma originalbild användes för att skapa vart och ett av formaten ser den visade bilden ut i samma storlek oavsett vilket format som används. Bildfilerna som lagras i databasen varierar dock avsevärt i storlek. Generellt anses .jpg bilder vara de mest effektiva när det gäller lagringsutrymme.</li><li><b>Bildstorlek</b><br />Ju större originalbilden, desto större blir den resulterande filens storlek. Bilden ska passa på skärmen utan att bläddra; den maximala bredden eller höjden bör inte vara mer än skärmens bredd eller höjd. PhpGedView är utformad för skärmar med 1024x768 pixlar men inte allt detta utrymme är tillgängligt för visning av bilder; bildens storlek bör ställas in i enlighet därmed. För att minska filstorlekar är mindre bilder mer önskvärda.</li><li><b>Upplösning</b><br />Bildens upplösning mäts vanligtvis i \"dpi\" (punkter / tum), men detta gäller endast för tryckta bilder. När du överväger bilder som visas på skärmen är det enda korrekta sättet att använda totala punkter eller pixlar. När den skrivs ut kan bilden ha en upplösning på 150 - 300 dpi eller mer beroende på skrivaren. Skärmupplösningar är sällan bättre än 50 pixlar per tum. Om din bild aldrig kommer att skrivas ut kan du säkert sänka upplösningen (och följaktligen dess filstorlek) utan att påverka bildkvaliteten. Om en bild med låg upplösning skrivs ut med en alltför stor förstoring, kommer dess kvalitet att försämras. det kommer att ha ett kornigt utseende.</li><li><b>Färgdjup</b><br />Ett annat sätt att hålla en fil liten är att minska antalet färger du använder. Antalet färger kan skilja sig från rent svart och vitt (två färger) till sanna färger (miljoner färger) och allt däremellan. Du kan se att ju fler färger som används desto större blir filernas storlek.</li></ul><br /><b>Varför är det viktigt att hålla filstorleken liten?</b><ul><li>Först och främst: Ditt webbutrymme är begränsat. Ju fler stora filer det finns, desto mer webbutrymme behöver vi på servern. Ju mer utrymme vi behöver, desto högre blir dina kostnader.</li><li>Bandbredd. Ju mer data vår server måste skicka till den avlägsna platsen (din plats), desto mer måste vi betala. Detta beror på att bärförmågan för serverns anslutning till Internet är begränsad och länken måste delas (och betalas för) av alla applikationer som körs på servern. PhpGedView är ett av många program som delar servern. Kostnaden fördelas normalt enligt mängden data som varje program skickar och tar emot.</li><li>Nedladdningstid. Om du har stora filer måste användaren (även du) vänta länge tills sidan laddas ner från servern. Inte alla är välsignade med kabelanslutning, bredband eller DSL.</li></ul><br /><b>Hur laddar du upp din MM</b><br />Det finns två sätt att ladda upp media till webbplatsen. Om du har många medieobjekt att ladda upp bör du kontakta webbplatsadministratören för att diskutera de bästa sätten. Om det har aktiverats av din webbplatsadministratör kan du använda formuläret Ladda upp media under menyn #pgv_lang[mgv]#. Du kan också använda uppladdningsalternativet i multimediaformuläret för att ladda upp medieobjekt.";
$pgv_lang["gen_missing_thumbs_help"]	= "~#pgv_lang[gen_missing_thumbs]#~<br /><br />Det här alternativet genererar miniatyrer för alla filer i den aktuella katalogen som inte redan har en miniatyrbild. Det här är mycket bekvämare än att klicka på länken <b>#pgv_lang[gen_thumb]#</b> för varje sådan fil.<br /><br />Om du vill behålla kontrollen över vilka filer som ska ha motsvarande miniatyrer ska du inte använda det här alternativet. Klicka istället på lämpliga <b>#pgv_lang[gen_thumb]#</b>.";
$pgv_lang["add_facts_general_help"]      = "~Generell information om att lägga till~<br /><br />När du har lagt till ett faktum, en anteckning, en källa eller en multimediafil till en post i databasen, måste tillägget fortfarande godkännas av en användare som har Accept-rättigheter.<br /><br />Tills ändringarna har godkänts , de identifieras som \"väntande\" med en annan färgad kant. Alla användare med redigeringsrättigheter kan se dessa ändringar samt den ursprungliga informationen. Användare som inte har redigeringsrättigheter ser bara originalinformationen. När tillägget har accepterats försvinner gränserna och de nya uppgifterna visas normalt och ersätter de gamla. Vid den tiden kommer användare utan redigeringsrättigheter också se de nya uppgifterna.";

//-- Edit user
$pgv_lang["edituser_my_account_help"]		="På denna sida kan du ändra dina inställningar och preferenser.<br /><br />Du kan ändra dit användarnamn, fullständiga namn, lösenord, språk, e-post adress, tema för denna sajt och föredragen kontaktmetod.<br /><br />Det ända sak du inte kan ändra själv är GEDCOM-filens INDI posters ID nummer.";
$pgv_lang["edituser_username_help"]		="~#pgv_lang[username]#~<br /><br />I denna box kan du ändra ditt användarnamn. Om du inte gillar ditt användarnamn längre, eller har andra anledningar att ändra det, kan du göra det genom att använda detta formulär.<br /><br />Användarnamnet är <b>känsligt för stora och små bokstäver</b>. Detta betyder att att \"John\" inte är samma namn som \"john\" eller \"JOHN\".<br /><br />Du bör <u>endast</u> använda tecken från de alfabet som PhpGedView stöder. Du kan använda stora och små bokstäver med eller utan diakritiska tecken, siffror, bindestreck (-) och understrykning (_). Använd <u>inte</u> skiljetecken eller mellanslag.";
$pgv_lang["edituser_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />I denna ruta kan du ändra ditt förnamn. Detta är namnet som andra användare ser när du är inloggad.<br /><br />Även om valet av namn som du skriver i detta fält är ditt så bör du informera administratören när du ändrar det. När andra ser ett okänd person online, kan de undra och ställa frågor. Administratören kan ta reda på det utan att ha fått något meddelande, men du bör spara honom det onödiga arbetet.";
$pgv_lang["edituser_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br />I denna ruta kan du ändra ditt efternamn. Detta är namnet som andra användare ser när du är inloggad.<br /><br />Även om valet av namn som du skriver i detta fält är ditt så bör du informera administratören när du ändrar det. När andra ser ett okänd person online, kan de undra och ställa frågor. Administratören kan ta reda på det utan att ha fått något meddelande, men du bör spara honom det onödiga arbetet.";
$pgv_lang["edituser_gedcomid_help"]		="~#pgv_lang[gedcomid]#~<br /><br />Detta är ett internt (GEDCOM-ID) som länkar dig till din egen data i GEDCOM-filen.<br /><br />Du kan inte ändra detta ID. Denna länk är satt av administratören. Om du tycker att ID inte är korrekt bör du kontakta administratörens för att få det ändrat.";
$pgv_lang["edituser_rootid_help"]			= "~#pgv_lang[rootid]#~<br /><br />Det här är den startande (rot) personen i alla dina diagram.<br /><br />Om du till exempel skulle klicka på länken till stamtavlan, skulle du se denna rotperson i rutan längst till vänster. Denna rotmänniska behöver inte vara du; du kan börja med vilken person som helst (din farfar eller din mors moster, till exempel) så länge du har rätt att se den personen.<br /><br />Det här alternativet ändrar standardrotpersonen för de flesta sjökort. Du kan ändra rotpersonen som faktiskt används i många diagram, men det är bara för den sidan vid den aktuella tiden.";
$pgv_lang["edituser_password_help"]			= "~#pgv_lang[password]#~<br /><br />Det är bra att byta lösenord regelbundet. Du måste komma ihåg att alla som känner till ditt användarnamn och lösenord kommer att ha tillgång till dina data.<br /><br />Gör lösenordet minst sex tecken, ju längre desto bättre. Du kan använda stora och små bokstäver med eller utan diakritiska tecken, siffror, bindestreck (-) och understrykning (_). Använd <u>inte</u> skiljetecken eller mellanslag. Använd en kombination av stora och små bokstäver, siffror och andra tecken. Till exempel: <b>5Z_q\$P4=r9</b>.<br /><br />Liksom användarnamnet är lösenordet <u>skiftlägeskänsligt</u>. Det betyder att <b>Hemligt.Lösenord!#13</b> inte är detsamma som <b>hemligt.lösenord!#13</b> eller <b>HEMLIGT.LÖSENORD!#13</b>.";
$pgv_lang["edituser_conf_password_help"]	= "~#pgv_lang[confirm]#~<br /><br />Om du har ändrat ditt lösenord måste du också bekräfta det. Detta är bara för att se till att du inte gjorde ett skrivfel i lösenordsfältet.<br /><br />Om lösenordet och dess bekräftelse inte är identiska får du ett lämpligt felmeddelande. Du måste skriva in både det ursprungliga lösenordet och dess bekräftelse.";
$pgv_lang["edituser_change_lang_help"]		= "~#pgv_lang[change_lang]#~<br /><br />Här kan du ändra språk på vilket PhpGedview kommer att visa alla sidor och meddelanden när du har loggat in.<br /><br />När du först öppnar webbplatsen antar PhpGedView att du vill se allt på språket som är konfigurerat som önskat språk i din webbläsare. Om antagandet är felaktigt skulle du åsidosätta det här. Till exempel kan din webbläsare vara inställd på engelska eftersom det är det vanligaste språket på Internet. För genealogiska ändamål föredrar du dock att se allt på finska eller hebreiska. Här gör du det.<br /><br />Administratören styr vilka språkval som är tillgängliga för dig. Om din preferens inte är listad måste du kontakta administratören.<br /><br />Kom ihåg att PhpGedView i hög grad är ett projekt bemannat av ett internationellt team av obetalda volontärer. Experter kommer och går. Följaktligen är stöd för andra språk än engelska ibland inte så bra som det borde vara.<br /><br />Om du ser något som inte har översatts, har översatts felaktigt eller kan formuleras bättre, låt din administratör känna till. Administratören kommer att veta hur man kan komma i kontakt med PhpGedView-utvecklargruppen för att få dina problem att ta itu med. Ännu bättre, volontär lite av din tid. Vi kan använda hjälp.";
$pgv_lang["edituser_email_help"]		="~#pgv_lang[emailadress]#~<br /><br />Din e-post adress är förstås viktig för oss så att vi kan hålla kontakt med dig.<br /><br />Om du får en ny mailadress, t.ex när du byter levrantör, var vänlig och glöm inte byta din adress här också. Du har kanske fler en än e-post adress och vill att din meddelande från oss ska komma till en annan e-post adress, ändra här tack.";
$pgv_lang["edituser_user_theme_help"]		= "~#pgv_lang[user_theme]#~<br /><br />Denna webbplats kan ha flera olika utseende eller utseenden. Andra program kan kalla dem \"skins\", men här är de \"teman\".<br /><br />Varje tema visar samma data, men dess presentation eller till och med dess plats på skärmen kan variera. Det här är som att sätta en bild i en annan ram och hänga den också i ett annat rum. Bilden förändras inte, men hur du ser på den är helt annorlunda.<br /><br />Bara prova. Ställ in det på ett annat tema. Titta på det, prova en annan. Byt tillbaka till det som passar dig bäst. När du loggar in ser du temat du senast använde. du behöver inte ens komma till den här konfigurationssidan för att ändra ditt föredragna tema.";
$pgv_lang["edituser_contact_meth_help"]		= "~#pgv_lang[user_contact_method]#~<br /><br />PhpGedView har flera olika kontaktmetoder. Administratören bestämmer vilken metod som ska användas för att kontakta honom. Du har kontroll över metoden som ska användas för att kontakta <u>dig</u>. Beroende på webbplatsens konfiguration kanske vissa av de listade metoderna inte är tillgängliga för dig.";
$pgv_lang["mail_option1_help"]				= "Med det här alternativet används det interna meddelandesystemet PhpGedView och inga e-postmeddelanden kommer att skickas.<br /><br />Du får bara <u>interna</u> meddelanden från de andra användarna. När en annan webbplatsanvändare skickar ett meddelande till dig kommer meddelandet att visas i meddelandeblocket på din personliga #pgv_lang[mygedview]# sida. Om du har tagit bort detta block från sidan #pgv_lang[mygedview]# ser du inga meddelanden. De kommer dock att dyka upp så snart du konfigurerar sidan #pgv_lang[mygedview]# så att den igen har meddelandeblock.";
$pgv_lang["mail_option2_help"]				= "Det här alternativet är som #pgv_lang[messaging]#, med ett tillägg. Som extra kommer en kopia av meddelandet också att skickas till den e-postadress som du konfigurerade på din kontosida.<br /><br />Detta är standardkontaktsmetoden.";
$pgv_lang["mail_option3_help"]				= "Med det här alternativet får du bara e-postmeddelanden till den adress du konfigurerade på din kontosida. Meddelandesystemet internt i PhpGedView kommer inte att användas alls, och det kommer aldrig att finnas några meddelanden i meddelandeblocket på din personliga #pgv_lang[mygedview]# sida.";
$pgv_lang["mail_option4_help"]			="Med denna inställning kommer du inte få några meddelande alls. Inte ens adminisratören kan nå dig.";

//-- Admin
$pgv_lang["admin_help"]						= "På den här sidan hittar du länkar till konfigurationssidor, administrationssidor, dokumentation och loggfiler.<br /><br /><b>#pgv_lang[system_time]#</b>, precis under sidrubriken, visar tiden för servern där din webbplats är värd. Det betyder att om servern finns i New York medan du är i Sverige, kommer den visade tiden att vara sex timmar mindre än din lokala tid, såvida inte, naturligtvis, servern körs på Greenwich Mean Time (GMT). Den visade tiden är servertiden när du öppnade eller uppdaterade den här sidan.<br /><br /><b>VARNING</b><br />När du ser ett rött varningsmeddelande under systemtiden betyder det att din <i>config.php</i> fortfarande är skrivbar. När du har konfigurerat din webbplats bör du, för <b>säkerhet</b>, ställa in behörigheterna för den här filen till skrivskyddad. Du måste göra detta <u>manuellt</u>, eftersom PhpGedView inte kan göra detta åt dig.";

//-- User Admin
$pgv_lang["useradmin_help"]			="~#pgv_lang[user_admin]#~<br /><br />På denna sida kan du administrera de nuvarande användaren och lägg till nya användare.<br /><br /><b>#pgv_lang[current_users]#</b><br />I denna tabell visas de nuvarande användarna, deras status och deras rättigheter. Du kan <b>Radera</b> eller <b>Redigera</b> användare.<br /><br /><b>#pgv_lang[add_user]#</b><br />Detta formulär är nästan det samma som du känner till från <b>#pgv_lang[editowndata]#</b><br /><br />För flera ämnen har vi inte gjort speciella hjälptexter för administratören. I dessa fall kommer du att se följande meddelande:";
$pgv_lang["useradmin_gedcomid_help"]		="~#pgv_lang[gedcomid]#~<br /><br />Detta #pgv_lang[gedcomid]# för användaren måste ställas in av administratören.<br /><br />Detta ID används som ID på flera sidor som <b>#pgv_lang[my_indi]#</b> och <b>#pgv_lang[my_pedigree]#</b><br /><br />För varje GEDCOM som du använder i programmet, kan du sätta GEDCOM-personid för användaren. Om en användare inte har en post i GEDCOM-filen, lämna textrutan tom.";
$pgv_lang["useradmin_rootid_help"]		="~#pgv_lang[rootid]#~<br /><br />För varje GEDCOM-fil i program, du kan sätta en <b>startperson</b> till en användare.<br /><br />Denna rotperson behöver inte vara användaren själv; det kan vara vem som helst. Användaren vill antagligen starta stamtavlan med sig själv. Du styr det, liksom standardrotpersonen i andra diagram, här.<br /><br />Användaren kan ändra denna inställning själv i sitt konto.";
$pgv_lang["useradmin_can_admin_help"]		="~#pgv_lang[can_admin]#~<br /><br />Om denna ruta är ikryssad, har användaren samma rättigheter som du själv i programmet.<br /><br />Dessa rättigheter inkluderar:<ul><li>Lägg till / Radera / Redigera användare.</li><li>Sänd meddelanden till alla användare</li><li>Redigera välkomstmeddelanden</li><li>Redigera och konfigurera språkfiler.</li><li>Uppgradera program.</li><li>Ändra konfiguration.</li><li>Administrera GEDCOM-filer.</li><li>Ändra integritetsinställningar.</li><li>Och allt annat som inte nämns här.</li></ul><br />Användaren <u>kan inte</u> ändra något på din server utanför PhpGedView.";
$pgv_lang["useradmin_sync_gedcom_help"]		= "~#pgv_lang[sync_gedcom]#~<br /><br />Om denna ruta är ikryssad och användaren har ett GEDCOM-id satt för dem, kommer deras användarkonto automatiskt synkroniserat med deras GEDCOM-data. Detta betyder att när användarens GEDCOM-post redigeras kommer viss information som t.ex. epostadress och namn kopieras till användarkontot. När användarkontot redigeras kommer motsvarande information att kopieras till GEDCOM-posten.";
$pgv_lang["useradmin_can_edit_help"]		="~#pgv_lang[can_edit]#~<br /><br />För varje GEDCOM i detta system kan användare ha vissa access och redigeringsrättighter.<ul><li><b>#pgv_lang[none]#:</b>&nbsp;&nbsp;&nbsp;betyder att användaren inte kan komma åt privata fakta.</li><li><b>#pgv_lang[access]#:</b>&nbsp;&nbsp;&nbsp;betyder att användaren inte kan redigera eller lägga till ny data men han kan se den privata faktan.</li><li><b>#pgv_lang[edit]#:</b>&nbsp;&nbsp;&nbsp;Användaren kan redigera värden men en annan användare med <b>#pgv_lang[accept]#</b> behörigheter måste godkänna ändringarna innan de läggs till i databasen och offentliggörs.</li><li><b>#pgv_lang[accept]#:</b>&nbsp;&nbsp;&nbsp;ger användaren möjlighet att redigera och godkänna ändringar gjorda av andra användare.</li><li><b>#pgv_lang[admin_gedcom]#:</b>&nbsp;&nbsp;&nbsp;ger användaren möjlighet att redigera konfiguration och integritetsinställningar för denna GEDCOM.</li></ul><br />Systemadministratörer, identifierade genom kryssrutan <b>#pgv_lang[can_admin]#</b>, ges automatiskt <b>#pgv_lang[admin_gedcom]#</b> behörigheter.";
$pgv_lang["useradmin_verified_help"]		="~#pgv_lang[verified]#~<br /><br /><b>Självregistrering</b><br />En användare kan ansöka om ett nytt konto, genom <b>självregisteringsmodulen</b>.<br /><br />Om han gjorde det, då kommer han att få ett e-postmeddelande med en länk för att verifiera sin ansökan. Om han redan gjort så, kommer du att se kryssrutan ikryssad, och du kan forsätta med nästa steg, <b>#pgv_lang[verified_by_admin]#</b>. Du bör vänta med ditt godkännande så länge den här rutan inte är markerad.<br /><br /><b>Lägg till användare manuellt</b><br />Om du använder formuläret att lägga till användare manuellt, kommer du att se kryssrutorn ikryssade från början.";
$pgv_lang["useradmin_verbyadmin_help"]		="~#pgv_lang[verified_by_admin]#~<br /><br />Om en användare har använt självregistreringmodulen och har verifierat sigsjälv, då är det sista steget, innan kontot blir brukbart, är ditt godkännade.<br /><br />Efter ditt godkännade av ansökan för ditt nya konto, användaren kommer att få ett e-postmeddelande att hans konto är aktiverat och han kan logga in med användarnamn och lösenord, som han använde när han ansökte om sitt konto.";
$pgv_lang["useradmin_edit_user_help"]		="~#pgv_lang[update_user]#~<br /><br />Detta formulär används av administratören för att ändra ett användarkonto.<br /><br />Formuläret är ganska likt formuläret <b>#pgv_lang[add_user]#</b> eller formuläret <b>#pgv_lang[update_myaccount]#</b>.";
$pgv_lang["useradmin_visibleonline_help"]	= "~#pgv_lang[visibleonline]#~<br /><br />Den här rutan styr din synlighet för andra användare medan du är online. Det styr också din förmåga att se andra onlineanvändare som är konfigurerade för att vara synliga.<br /><br />När den här rutan är avmarkerad kommer du att vara helt osynlig för andra och du kommer inte heller kunna se andra onlineanvändare. När den här rutan är markerad är exakt motsatt. Du kommer att vara synlig för andra och du kommer också att kunna se andra som är konfigurerade att vara synliga.";
$pgv_lang["useradmin_editaccount_help"]			= "~#pgv_lang[editaccount]#~<br /><br />Om denna ruta är ikryssad, kommer denna användare att kunna redigera deras kontoinformation. Om denna ruta inte är kryssad, kommer de inte att kunna redigera deras kontoinformation. Detta gör att man kan skapa ett ända användarnamn och lösenord för multipla användare och hindra dem från att redigera deras kontoinformation.";
$pgv_lang["useradmin_relation_priv_help"]		= "~#pgv_lang[user_relationship_priv]#~<br /><br />Om denna ruta är ikryssad, kommer användaren endast få tillgång till de levande personer de är släkt med. De kommer kunna se alla som är inom släktförhållande avståndet satt av <i>#pgv_lang[user_path_length]#</i> inställningen. Du kan kräva släktförhållandeintegritet för alla användare genom att sätta på det globala valet i GEDCOM-ingritetsinställningarna.<br /><br />Denna inställning kräver att användaren associeras med ett GEDCOM-id innan de kan se några levande personerna.";
$pgv_lang["useradmin_path_length_help"]			= "~#pgv_lang[user_path_length]#~<br /><br />Om <i>#pgv_lang[user_relationship_priv]#</i> är igång, kommer denna användare endast at se eller ändra peronerna inom detta antal släktskapssteg.";
$pgv_lang["useradmin_auto_accept_help"]			= "~#pgv_lang[user_auto_accept]#~<br /><br />Genom att kryssa i denna ruta tillåter du systemet att automatiskt acceptera alla ändringar som denna användare gör. Användaren måste ha acceptera privilegier för GEDCOM-filen för att denna inställning ska ha någon effekt.";

//-- Manage Sites
$pgv_lang["help_managesites"] 			= "~#pgv_lang[link_manage_servers]#~<br /><br />På denna sida kan du lägga till andra sajter och förbjuda IP-adresser.<br /><br />Andra sajter kan läggas till genom att ange sajtens titel, URL, databasens id(valfritt), användarnamn och lösenord.<br /><br />Förbjuda IP-adresser görs genom att ange vilken giltig IP-adress blocket som helst. T.ex. 212.10.*.* andra sajter inom detta IP-adressblocket kan inte koplla sig till din webservice. Du kan även förbjuda specifika IP-adresser.";
//-- Adding Remote Links
$pgv_lang["help_remotesites"]			= "~#pgv_lang[label_new_server]#~<br /><br />För att lägga till en annan sajt, ange sajtens rubrik, URL till den andra sajten, databasens id(valfritt) och användarnamn och lösenord. Klicka på Lägg till knappen för att avsluta processen. Om den andra sajten tillåter anonym inloggning ska du lämna användar och lösenordsfälten tomma.";
//-- IP Address Banning
$pgv_lang["help_IPv4IPv6"]				= "IPv4-adresser består av 4 segment separerade av \".\" (Punkt) och innehåller decimaltal i intervallet noll till 255 utan ledande nollor. Några exempel är: <b>172.252.19.56</b> , <b>212.10.*.*</b> , <b>212.10.</b> , <b>212.10</b> , <b>212.10..29</b> eller <b>212.10.*.29</b> . De saknade segmenten i dessa exempel tolkas som \"*\" (stjärna), med den symbolen \"*\" som betyder <i>matcha valfritt nummer i denna position</i>.<br /><br />IPv6-adresser består av 8 segment separerade av \":\" (kolon) och innehåller 4 siffror hexadecimala tal. Dessa siffror bör inte ha ledande nollor, och den första sekvensen av nollor kan avlägsnas och ersättas av ett par symboler \":\" (kolon). Om du behöver använda funktionen <i>matcha valfritt nummer i denna position</i> måste du explicit infoga \"*\" (stjärna) där. Några exempel är: <b>23:0:cafe::2:1</b> , <b>23:0:cafe::*:1</b> eller <b>23:0:*::*:*</b> .  I dessa exempel representerar kolonparet en sekvens av 3 nummer, varav var och en är noll, såhär: <b>23:0:cafe:0:0:0:*:1</b>.";
$pgv_lang["help_banning"]				= "~#pgv_lang[label_banned_servers]#~<br /><br />För att förhindra specifika IPv4- eller IPv6-adresser från att komma åt din webbplats, ange en exakt IP-adress eller ett giltigt IP-adressintervall och klicka på knappen Lägg till (+).<br /><br />#pgv_lang[help_IPv4IPv6]#";
$pgv_lang["help_timedban"]				= "~#pgv_lang[label_timedban_servers]#~<br /><br />När ett hackningsförsök upptäcks kommer PhpGedView automatiskt att förhindra åtkomst från den IP-adressen i en timme.<br /><br />Du kan lägga till din egen tidsbegränsad åtkomstavslag genom att ange IPv4- eller IPv6-adressen som ska blockeras tillsammans med datum och tidpunkt då åtkomstavslaget upphör i kommentarfältet. Var noga med att använda rätt format för utgångsinformationen. Om utlämningsinformationen inte är korrekt inmatad kommer inte åtkomstavslaget automatiskt att gå ut.<br /><br />Utgången ska anges i följande format: <b>åååå.mm.dd@tt:mm</b> . Exempel, <b>2012.12.23@23:59</b> . Observera användningen av 24-timmars klockan.<br /><br />#pgv_lang[help_IPv4IPv6]#";
$pgv_lang["help_manual_search_engines"]				= "~#pgv_lang[label_manual_search_engines]#~<br /><br />PhpGedView ger sökmotorer mindre data filer automatiskt med färre länkar. Datan begränsas till personen och den närmaste familjen, utan att lägga till information om far/mor-föräldar eller barnbarn. Många rapporter och serverintensiva sidor som kalandern är förbjuden mark för sökmotorer.<br /><br />Många populära sökmotorer som Google och Bing kommer att upptäckas automatiskt. Om en sökmotor inte automatiskt identifieras och du vill ge den data till index, kan du ange dess IPv4- eller IPv6-adress här. Om du vill helt och hållet utesluta den här nya sökmotorn, listar du den i avsnittet <i>#pgv_lang[label_banned_servers]#</i>.<br /><br />Om du vill se vad för data som sökmotorer får att indexera, lista din een IP-adress här.&nbsp; <span class='warning'>VARNING:</span>&nbsp; Detta kommer att <b>låsa dig ut</b> i administratörsgränssnittet och du måste ta bort IP-adressen genom att logga in från en annan maskin med en annan IP-adress eller manuellt redigera <i>#GLOBALS[TBLPREFIX]#ip_address</i> databas tabellen.<br /><br />#pgv_lang[help_IPv4IPv6]#";

//-- Search_engines.php
$pgv_lang["search_engine_landing_page"]		= "~Sökmotor upptäckt~<br /><br />PhpGedView ger automatiskt sökmotorer med mindre datafiler med mindre antal länkar. Datan är begränsad till personen och den direkta familjen utan att lägga till information om farföräldrar och barnbarn. Många rapporter och serverintesiva sidor som kalender är förbjudet blocket för sökmotorerna.<br /><br />Försök av sökmotorer att gå till dessa sidor kommer att ge denna sida som resultat. Om du ser denna text så tror programmet att du är en sökmotor. Nedan finns listan av sidor som sökmotorer får lova att besöka och som kommer ge den förkortade versionen.<br /><br />Riktiga användare som följer sökmotorns länkar till din sajt kommer att se den kompletta sidan och inte den förkortade.";

//-- G E D C O M
$pgv_lang["add_upload_gedcom_help"]		= "~#pgv_lang[add_gedcom]#~<br />~#pgv_lang[upload_gedcom]#~<br /><br /><b>Ladda upp GEDCOM-filer</b><br />Ladda upp filer kan göras online. Du kan ladda upp var som helst utan att behöva ett FTP-program.<br /><br /><b>Lägga till GEDCOM-fil</b><br />Om en tidigare uppladdad fil fortfarande finns i mappen <b>/index</b> kan du använda den igen utan att ladda upp den. Ibland, på grund av fil- eller uppladdningsstorleksbegränsningar, måste du använda Lägg till.<br /><br />Tilläggs- och uppladdningsförfarandet kan avslutas i fyra enkla steg. I båda förfarandena är bara steg 1 annorlunda.";
$pgv_lang["gedcom_configfile_help"]		= "~GEDCOM CONFIGURATION FILE~<br /><br />Det här är filen där alla grundinställningar relaterade till den genealogiska databasen lagras. Det finns en separat fil för varje sådan databas.<br /><br />Du hittar sökvägen och namnet på varje konfigurationsfil i tabellen <b>#pgv_lang[current_gedcoms]#</b> på <b>#pgv_lang[gedcom_adm_head]#</b> sida.";
$pgv_lang["default_gedcom_help"]		="~STANDARD-GEDCOM~<br /><br />Om du har mer än en GEDCOM-fil i programmet kan du här ställa in vilken som ska vara <b>standard</b> GEDCOM-fil.<br /><br />Detta kommer att vara den GEDCOM-fil som visas för besökare och användare som inte är inloggade än.<br /><br />Användare som kan redigera sina kontoinställningar kan åsidosätta denna standard. I så fall visas användarens önskade databas efter inloggning.";
$pgv_lang["delete_gedcom_help"]			= "~DELETE GEDCOM~<br /><br />PhpGedView skapar sin databas från en GEDCOM-fil som tidigare laddades upp. När du väljer <b> Ta bort </b> raderas den delen av databasen. Du måste bekräfta din Ta bort begäran.<br /><br />Om du inte medvetet har tagit bort den utanför PhpGedView, kommer den ursprungliga GEDCOM-filen att finnas kvar i den mapp som den överfördes till. Om du senare vill arbeta med den GEDCOM-filen igen behöver du inte ladda upp den igen. Du kan välja funktionen <b>#pgv_lang[add_gedcom]#</b>.";
$pgv_lang["add_gedcom_help"]			= "~#pgv_lang[add_gedcom]#~<br /><br />När du använder funktionen <b>#pgv_lang[add_gedcom]#</b> antas att du redan har laddat upp GEDCOM-filen till din server med ett program eller en metod <u>extern</u> till PhpGedView, för till exempel <i>ftp</i> eller <i>nätverksanslutning</i>. Filen du vill lägga till kan också ha varit kvar från en tidigare <b>#pgv_lang[upload_gedcom]#</b> procedur.<br /><br />Om den inmatade GEDCOM-filen ännu inte finns på din server måste du få den först innan du kan börja lägga till.<br /><br />Istället för att ladda upp en GEDCOM-fil, du kan också ladda upp en ZIP-fil som innehåller GEDCOM-filen, antingen med PhpGedView eller med hjälp av ett externt program. PhpGedView känner igen ZIP-filen automatiskt och extraherar GEDCOM-filen och filnamnet från ZIP-filen.<br /><br />Om det redan finns en GEDCOM-fil med samma namn i PhpGedView skrivs den över. Alla GEDCOM-inställningar som gjorts tidigare kommer dock att bevaras.<br /><br />Du guidas steg för steg genom proceduren.";
$pgv_lang["add_new_gedcom_help"]		= "~#pgv_lang[add_new_gedcom]#~<br /><br />Du kan starta en ny släktforskningsdatabas från grunden. <br /> <br /> Denna procedur kräver bara några få enkla steg. Steg 1 skiljer sig från vad du redan vet om uppladdning och tillägg. De andra stegen kommer att vara bekanta.<ol><li><b>Namngivning av nya GEDCOM</b><br />Skriv namnet på den nya GEDCOM <u>utan</u> tillägget <b>.ged</b>. Den nya filen skapas i mappen ovanför rutan där du anger namnet. Klicka på <b>Lägg till</b>.</li><li><b>Konfigurationssida</b><br />Du känner redan till den här sidan; du konfigurerar inställningarna för din nya GEDCOM-fil.</li><li><b>Bekräfta</b><br />Du känner redan till den här sidan; den nya GEDCOM är markerad. Eftersom det inte finns något i det kommer det att vara ok.</li><li><b>Importera poster</b><br />Eftersom det bara kommer att finnas en post att importera kommer den att avslutas väldigt snabbt.</li></ol>Nu kan du gå till stamtavlan för att se din första person i nya GEDCOM. Klicka på personens namn och börja redigera. Därefter kan du länka nya individer till första personen.";
$pgv_lang["download_gedcom_help"]		="~#pgv_lang[download_gedcom]#~<br /><br />Du har möjligheten att ladda ner en GEDCOM-fil från din sajt. Du vill kanske importera datan till ett annat genealogiska programmet, eller kanske vill du dela information med andra.<br /><br />#pgv_lang[utf8_ansi_help]#<br /><br />#pgv_lang[remove_tags_help]#<br /><br />#pgv_lang[download_zipped_help]#";
$pgv_lang["edit_gedcoms_help"]			="~#pgv_lang[gedcom_adm_head]#~<br /><br />#pgv_lang[gedcom_adm_head]#-sidan är kontrollcenter för administrering av den alla GEDCOM-filer.<br /><br /><b>#pgv_lang[current_gedcoms]#</b><br />I tabellen för <b>#pgv_lang[current_gedcoms]#</b> finns följande val.<ul><li>#pgv_lang[add_gedcom]#</li><li>#pgv_lang[upload_gedcom]#</li><li>#pgv_lang[add_new_gedcom]#</li><li>#pgv_lang[lang_back_admin]#</li></ul>I tabellen för <b>#pgv_lang[current_gedcoms]#</b> listas varje GECOM-fil för sig och har följande val för varje GEDCOM-fil:<ul><li>Import GEDCOM</li><li>Delete GEDCOM</li><li>Download GEDCOM</li><li>Redigera GEDCOM-konfiguration</li><li>Redigera GEDCOM-integritet</li><li>Sökloggfiler</li></ul>Editera integritet är ett val i denna tabell eftersom varje GEDCOM-fil har sin egen integritetsfil.<br /><br />Varje rad i tabellen bör vara självförklarande. PhpGedView kan konfigureras att logga alla databas sökningar. Sökloggsfilerna kan kontrolleras via länkar på denna sida.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["edit_config_gedcom_help"]		="~KONFIGURERA GEDCOM~<br /><br />Varje släktforskningsdatabas som används med PhpGedView har sin egen <b>konfigurationsfil</b>.<br /><br />På det här formuläret konfigurerar du många alternativ som databasens titel, språk, kalenderformat, e-postalternativ, loggning av databasen sökningar, HTML META-rubriker, borttagning av efternamn från databasens lista över frekventa efternamn, etc.";
$pgv_lang["import_gedcom_help"]			="~IMPORTERA GEDCOM-FIL~<br /><br />I de flesta fall är import av en externt skapad GEDCOM-fil ett steg i procedurer som resulterar i massändringar i den genealogiska databasen.<br /><br />Dessa steg är i en logisk sekvens och måste slutföras i föreskriven ordning så att släktforskningsdatabasen är användbar.<br /><br />Om du av någon anledning inte slutförde dessa steg i rätt ordning ser du ett <u>varning</u> meddelande om att GEDCOM inte är ännu importerad. För att åtgärda problemet, klicka på länken <b>Importera GEDCOM</b> för att importera filen.<br /><br />Befintliga GEDCOM-konfigurationsinställningar ändras inte när du importerar en GEDCOM igen. Befintliga data kommer dock att skrivas över.";
$pgv_lang["upload_gedcom_help"]			="~#pgv_lang[upload_gedcom]#~<br /><br />Till skillnad mot <b>#pgv_lang[add_gedcom]#</b>, behöver du inte ha GEDCOM-filen på din server än.<br /><br />I steg 1 väljer du en GEDCOM-fil från din lokala dator. Skriv in den kompletta sökvägen och filnamnet i textboxen, eller använd <b>Browse</b> på sidan.<br /><br />Du kan också använda den här funktionen för att ladda upp en ZIP-fil som innehåller GEDCOM-filen. PhpGedView känner igen ZIP-filen och extraherar filen och filnamnet automatiskt.<br /><br />Om det redan finns en GEDCOM-fil med samma namn i PhpGedView skrivs den över efter din bekräftelse. Alla GEDCOM-inställningar som gjorts tidigare kommer dock att bevaras.<br /><br />Du hittar mer hjälp på de andra sidorna under proceduren.";
$pgv_lang["validate_gedcom_help"]		= "~VALIDERA GEDCOM~<br /><br />Detta är det tredje steget i proceduren för att lägga till externt skapade GEDCOM-data i din släktforskningsdatabas.<br /><br />PhpGedView kontrollerar inmatningsfilen för korrekt användning av datumformat, platsformat, teckenuppsättning etc. Några avvikelser från GEDCOM 5.5.1-standarden, som PhpGedView följer, kan korrigeras automatiskt. Exempel är Macintosh-radslut och felaktig användning av platsformat. När detta händer ser du ett meddelande om att data har ändrats. För andra avvikelser får du ett varningsmeddelande med en rekommenderad lösning.<br /><br /><b>Frivilliga verktyg</b><br />För närvarande finns det bara ytterligare ett verktyg: <b>Ändra person ID till...</b>.<br /><br /><b>Mer hjälp</b><br />#pgv_lang[context_help]#";
$pgv_lang["convert_ansi2utf_help"]		= "~KONVERTERA ANSI TILL UTF-8~<br /><br />För att säkerställa att informationen i dina inmatade GEDCOM-filer bearbetas och visas korrekt, bör dessa filer kodas i UTF-8.<br /><br />Några av de modernare släktforskningsprogrammen kan exportera sina data till en GEDCOM-fil i UTF-8-kodning. Äldre program har ofta inte den här möjligheten. Om ditt program inte erbjuder dig det här alternativet kan PhpGedView konvertera filen åt dig.<br /><br />När PhpGedView validerar inmatningsfilen kommer den att upptäcka filens kodning och ge dig råd om detta.";
$pgv_lang["detected_ansi2utf_help"]		="~ANSI KODNING UPPTÄCKT~<br /><br />GEDCOM-filen som valideras nu är kodad i ANSI. Det rekomderas starkt att filen konverteras till UTF-8.<br /><br />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"]			="~FEL DATUMFORMAT UPPTÄCKT:~<br /><br /><b>DATUMFORMATET KOMMER ATT ÄNDRAS</b><br /><br />Datumformatet som är standard i PhpGedView och också enligt GEDCOM 5.5.1 standarden är: <b>DD&nbsp;MMM&nbsp;YYYY</b> (alltså 01&nbsp;JAN&nbsp;2004)<br /><br />Om du ser, efter att din GEDCOM-fil har blivit validerad, ett meddelande att fel datumformat har upptäckts, kommer programmet att konvertera datumet till standarden.<br /><br />Du har, ändå, möjlighet att välja antingen \"<b>dag</b> före månad\" (DD&nbsp;MMM&nbsp;YYYY), eller \"<b>månad</b> före dag\" (MMM&nbsp;DD&nbsp;YYYY).<br />Vi rekomenderar att du beåller den föreslagna inställningen, alltså det första valet.";
$pgv_lang["change_indi2id_help"]		= "~ÄNDRA PERSONID TILL...~<br /><br />Detta verktyg var designat för personer med släktforskningsprogram som använder olika GEDCOM-id för personer varje gång de exporteras. T.ex. första gången GEDCOM-filen exporteras någon persons id är I100 men nästa gång GEDCOM-filen exporteras får samma person I234. Dessa föränderliga id gör det svårt för administrera PhpGedView eftersom Idna används för att referera till personer.<br /><br />De flesta släktforskningsprogram använder oftast dessutom RIN eller REFN taggen för att ge en person ett unik identifiering för att referera till en person. Detta verktyg ersätter alla personers id i GEDCOM-filen med värdet från vilket annat fält som du anger. Du kan välja RIN eller REFN fältet för att ersätta idna med.";
$pgv_lang["edit_privacy_help"]			= "På den här sidan kan du göra alla sekretessinställningar för den valda GEDCOM.<br /><br />Du kan kontrollera under sidrubriken för att se att du redigerar rätt sekretessfil. Det visas så här: (sökväg/namnpådingedcomfil_priv.php)<br /><br />Om du behöver fler inställningar, då kan du manuellt göra ändringar i integritetsfilen. Du kan läsa mer om detta på PhpGedViews hemsida.";
$pgv_lang["BOM_detected_help"]			= "~Byte Order Mark (BOM) upptäckta~<br /><br />GEDCOM-filen du importerar har en speciel 3-byte kod i början av filen. Denna speciella kod används av vissa program för att indikera att filen är kodad i UTF-8.<br /><br />Även om denna kod inte igentligen är ett fel, kommer PhpGedView inte att fungera ordenligt om filen innhåller denna kod. Du bör låta PhpGedView tabort denna kod.";
$pgv_lang["invalid_header_help"]		= "~FELAKTIG GEDCOM START~<br /><br />En GEDCOM-fil måste starta med raden <b>0&nbsp;HEAD</b>. PhpGedView har upptäckt att din GEDCOM-fil inte startar med raden <b>0&nbsp;HEAD</b>. Efter du tryckt på städnings knappen kommer alla rader före den första <b>0&nbsp;HEAD</b> raden att raderas från din GEDCOM-filen.<br /><br />Detta fel beror oftast på att programmet som användes för att skapa GEDCOM-filen inte gjorde det korrekt eller att filen inte är en GEDCOM-fil. Du bör kontrollera att du har laddat upp rätt GEDCOM-fil och att den startar med <b>0&nbsp;HEAD</b> och slutar med raden <b>0&nbsp;TRLR</b>.";
$pgv_lang["macfile_detected_help"]		= "~MACINTOSHFIL UPPTÄCKT~<br /><br />PhpGedView upptäckte att din GEDCOM-fil skapades på en Macintosh dator.<ul><li>Macintosh-filer avslutar varje rad med en CR-kontrollkod. CR är Ctrl+M.</li><li>Unix-filer avslutar varje rad med en LF-kontrollkod. LF är Ctrl+J.</li><li>Windows och DOS använder en tvåkodssekvens, CR följt av LF.</li></ul>PhpGedView kräver att alla filer använder Unix- eller DOS-radslut. När du klickar på rensningsknappen kommer dina radslut att konverteras i enlighet med detta.";
$pgv_lang["cleanup_places_help"]		= "~RENSA ORTER~<br /><br />PhpGedView har upptäckt att din GEDCOM-fil använder orter vid taggar som inte ska ha orter.<br /><br />Många släktforskningsprogram, som Family Tree Maker, skapar den typ av GEDCOM-fil. PhpGedView kommer att fungera med dessa GEDCOM-filer, men vissa felaktiga orter kommer att visas i din ortshierarki.<br /><br />Som exempel, Din GEDCOM-fil kan ha följande kodning<div style=\"padding-left: 30px;\">1 SSN<br />2 PLAC 123-45-6789<br />1 OCCU<br />2 PLAC Datorprogrammerare</div><br />Enligt GEDCOM-standarden ska detta igentligen visas som<div style=\"padding-left: 30px;\">1 SSN 123-45-6789<br />1 OCCU Datorprogrammerare</div><br />Om du väljer <b>Ja</b>, kommer PhpGedView automatiskt upptäcka och rätta till denna typ av kodningfel.";
$pgv_lang["empty_lines_detected_help"]	= "~TOMMA RADER UPPTÄCKTA~<br /><br />PhpGedView har upptäckt tomma rader i din GEDCOM-fil. Dessa rader kan orsaka fel och kommer att tas bort från GEDCOM-filen innan den importeras.";

//-- Edit Config
$pgv_lang["help_editconfig.php"]		="~KONFIGURERA PhpGedView~<br /><br />På denna sida måste du ställa in de globala inställningarna för programmet, när du precis har installerat PhpGedView på din server, och kör den för första gången.<br /><br />#pgv_lang[review_readme]#<br /><br />Eftersom dessa inställningar är <b>globala</b>, är de för hela programmet och för alla GEDCOM-filer, som du använder i programmet.<br /><br />För varje GEDCOM-fil kan du göra specifika inställningar genom att klicka på <b>#pgv_lang[admin_gedcoms]#</b> länken på denna sida.<br /><br />Du kan också komma till  #pgv_lang[gedcom_adm_head]# funktionen från huvudadministratörssidan, vars länk du hittar i menyn under #pgv_lang[mgv]#-ikonen. På administratörssidan är den relevanta länken<br /><b>#pgv_lang[manage_gedcoms]#.</b>";

//-- merge records
$pgv_lang["help_edit_merge.php"]		= "~#pgv_lang[merge_records]#~<br /><br />Denna sida låter dig slå ihop två GEDCOM-poster i samma GEDCOM-fil.<br /><br />Detta är användbart för personer som har slagit ihop GEDCOM-filer och nu har många personer, familjer ocjh källor som är samma.<br /><br />Sidan betår av tre steg.<br /><ol><li>Du skriver in två GEDCOM-id. IDna <u>måste</u> vara av samma typ. Du kan inte slå ihop en person och en familj eller en familj och en källa t.ex.<br />I <b>#pgv_lang[merge_to]#</b>-fältet skriver du in idt för posten du vill ska vara den nya posten efter ihopslagningen är färdig.<br />I <b>#pgv_lang[merge_from]#</b>-fältet skriver du in id för posten vars information ska flyttas in i #pgv_lang[merge_to]#-posten. Denna poste kommer att raderas efter ihopslagningen.</li><li>Du bestämmer vilka fakta du vill behålla ifrån de två posterna när de slås ihop. Klicka bara i kryssruterna intill de du vill behålla.</li><li>Du kontrollerar resultatet av ihopslagningen precis som alla ändringar gjorda online.</li></ol>Någon med Accepterarättighter måste godkänna ändringarna för att göra dem permanenta.";

//-- report engine
$pgv_lang["help_reportengine.php"]	= "~#pgv_lang[reports]#~<br /><br />Rapportmenyns val kommer att generera PDF-filer för utskrift.<br /><br />Första steget är att välja en rapport att köra. När du valt en rapport att köra kommer du att bli ombedd att ange lite information specifik för rapporten som t.ex. vilken person eller familj att börja med och om bilder ska visas eller inte. När du är redo att köra rapporten, klicka på <b>#pgv_lang[download_report]#</b> knappen för att ladda ner rapporten till din dator.<br /><br />#pgv_lang[help_xml_reports]#<br /><br />#pgv_lang[def_pdf_format_help]#<br /><br />#pgv_lang[help_ahnentafel.xml]#<br /><br />#pgv_lang[help_birthlist.xml]#<br /><br />#pgv_lang[help_relativelist.xml]#";
$pgv_lang["def_pdf_format_help"]	= "~PDF-FILFORMAT~<br /><br />PhpGedViews rapportmotor skapar nerladdningsbara rapporter i Adobe&reg; PDF-format. GEDCOM 5.5.1 standardspecifikation, nämnd på annat ställe i hjälpfilen är också nerladdningsbar som PDF-fil. PDF är en förkortning för <b>P</b>ortable <b>D</b>ocument <b>F</b>ormat (bärbart dokumentformat).";
$pgv_lang["help_ahnentafel.xml"]	= "~#pgv_lang[ahnentafel_report]#~<br /><br />Detta är en rapport om den valda personen och hans anor utskrivna i häftform. Den startar med den valda personen och fortsätter sedan med hans föräldrar, farförädrar, osv.<br /><br />Observera att antavlerapporten är endast tillgänglig på engelska för tillfället.";
$pgv_lang["help_birthlist.xml"]		= "~#pgv_lang[birth_report]#~<br /><br />Med denna rapport kan du lista alla personer som var födda på en bestämd plats eller ort.";
$pgv_lang["help_relativelist.xml"]	= "~#pgv_lang[relatives_report]#~<br /><br />Denna rapport kommer att lista alla släktingar till den valda personen. Du kan välja vilka av personens släktingar som ska visas.<ul><li><b>#pgv_lang[child-family]#</b>&nbsp;&nbsp;&nbsp;kommer att visa den valda personen, hans föräldrar och hans syskon.</li><li><b>#pgv_lang[spouse-family]#</b>&nbsp;&nbsp;&nbsp;kommer att visa de personen med sin make/maka och deras barn.</li><li><b>#pgv_lang[direct-ancestors]#</b>&nbsp;&nbsp;&nbsp;kommer att visa personen, hans föräldrar, far- och morföräldrar osv. så långt bak som det finns registrerade personer.</li><li><b>#pgv_lang[ancestors]#</b>&nbsp;&nbsp;&nbsp;kommer att visa alla personer som #pgv_lang[direct-ancestors]# visar, dessutom kommer alla mor- farbröder, mostrar och fastrar osv. så att alla syskon till alla anfäder i personens anträd visas. Den kommer inte visa barnen till syskonen (kusinen).</li><li><b>#pgv_lang[descendants]#</b>&nbsp;&nbsp;&nbsp;kommer att lista alla personens ättlingar (barn, barnbarn, barnbarnsbarn, etc.).</li><li><b>#pgv_lang[all]#</b>&nbsp;&nbsp;&nbsp;detta är en kombination för #pgv_lang[descendants]# och #pgv_lang[ancestors]# i en enda rapport.</li></ul>";
$pgv_lang["help_xml_reports"]	= "~Rapportmotor~<br /><br />PhpGedViews rapportmotor använder XML-mallfiler för att automatiskt generera PDF-rapporter.<br /><br />Rapporterna som finns tillgängliga i <b>#pgv_lang[select_report]#</b> listan är genererade från rapport-XMLfilerna som finns i \"reports\"-mappen. Du kan skapa egna rapporter genom att göra en kopia av någon av XML-mallarna som finns tillgängliga och modifiera den. För att lägga till din egen rapport, så lägger du den bara i \"reports\"-mappen och PhpGedView kommer automatiskt att hitta den och göra den tillgänglig i menyn.";

//-- Help Contents
$pgv_lang["help_contents_head_help"]		= "<b>HJÄLP INNEHÅLL</b>";
$pgv_lang["help_contents_gedcom_info"]		= "GEDCOM-information";
$pgv_lang["help_contents_gedcom_places"]	= "Orter i GEDCOM-filen";

//-- Admin Help Contents Items
$pgv_lang["admin_help_contents_head_help"]	="<b>HJÄLPINNEHÅLL<br /><br />ADMINISTRATÖRSHJÄLPARTIKLAR</b> tillagda till början av listan.";
// $pgv_lang["ah1_help"]				= "_Upgrade";
$pgv_lang["ah2_help"]				="_Konfigurera PhpGedView";
$pgv_lang["ah3_help"]				="_GEDCOM: Lägg till kontra Ladda upp";
$pgv_lang["ah4_help"]				="_GEDCOM: Konfigurationsfil";
$pgv_lang["ah5_help"]				="_GEDCOM: Standard";
$pgv_lang["ah6_help"]				="_GEDCOM: Radera";
$pgv_lang["ah7_help"]				="_GEDCOM: Lägga till";
$pgv_lang["ah8_help"]				="_GEDCOM: Skapa ny";
$pgv_lang["ah9_help"]				="_GEDCOM: Ladda ner";
$pgv_lang["ah10_help"]				="_GEDCOM: Administratörssida";
$pgv_lang["ah11_help"]				="_GEDCOM: Konfigurera";
$pgv_lang["ah12_help"]				="_GEDCOM: Importera";
$pgv_lang["ah13_help"]				="_GEDCOM: Ladda upp";
$pgv_lang["ah14_help"]				="_GEDCOM: Validera";
$pgv_lang["ah15_help"]				="_GEDCOM: Konvertera ANSI till UTF-8";
$pgv_lang["ah16_help"]				="_GEDCOM: Integritetsinställningar";
$pgv_lang["ah17_help"]				="_Användaradministration";
$pgv_lang["ah18_help"]				="_Administration";
$pgv_lang["ah19_help"]				="_GEDCOM: Mediaverktyg";
$pgv_lang["ah20_help"]				="_GEDCOM: Ändra person-id till .....";
$pgv_lang["ah21_help"]				= "_Översättarverktyg";
//           22 is in the help_text_vars.php
$pgv_lang["ah23_help"]				= "_Konfigurera stödda språk";
$pgv_lang["ah24_help"]				= "_Användarinformation migrering (SQL <<-->> Index)";
$pgv_lang["ah25_help"]				= "_PhpGedView backup";
$pgv_lang["ah26_help"]				= "_FAQ Lista: Redigera";

//--Statistics Help
$pgv_lang["help_statisticsplot.php"] = "~Statistikdiagram~<br /><br />Detta är resultatsidan som visar den grafiska grafen för statistiken från din databas som definierad av ingångarna på föregående sida.";
$pgv_lang["help_statistics.php"] = "~Statistikdiagram~<br /><br />På den här sidan kan du bestämma kriterierna för att skapa en grafisk visning av olika statistik från din databas.";
$pgv_lang["stat_help"]		= "~ALTERNATIV FÖR STATISTIKPLOTTER~<br /><br />Ett antal olika statistikdiagram från din databas kan produceras.<br /><br />Välj diagrammet och justera sedan alternativen från listrutorna.<br /><br />Siffrorna som ingår i varje plot beror på tillgängliga data. Till exempel kan individer utan en födelsemånad (t.ex. bara 1856) inte inkluderas i en födelseplot per månad.";
$pgv_lang["stat_help_x"]		= "~ALTERNATIV FÖR STATISTIKPLOTTER~<br />~X axeln~<br /><br />Följande alternativ är tillgängliga för X-axeln (horisontell). Var och en presenteras sedan enligt alternativen för Y- och Z-axlarna.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_11_mb]#</b>&nbsp;&nbsp;&nbsp;personer födda varje månad.<br /><b>#pgv_lang[stat_12_md]#</b>&nbsp;&nbsp;&nbsp;personer som dog i varje månad.<br /><b>#pgv_lang[stat_13_mm]#</b>&nbsp;&nbsp;&nbsp;äktenskap som inträffade under varje månad.<br /><b>#pgv_lang[stat_14_mb1]#</b>&nbsp;&nbsp;&nbsp;antalet förstfödda för varje familj per månad.<br /><b>#pgv_lang[stat_15_mm1]#</b>&nbsp;&nbsp;&nbsp;antalet första äktenskap per månad.<br /><b>#pgv_lang[stat_16_mmb]#</b>&nbsp;&nbsp;&nbsp;antalet månader mellan äktenskapet och födelsen av det första barnet till det paret.<br /><b>#pgv_lang[stat_17_arb]#</b>&nbsp;&nbsp;&nbsp;ålder vid döden, relaterad till den tidsperiod som inkluderar varje persons födelseår.<br /><b>#pgv_lang[stat_18_ard]#</b>&nbsp;&nbsp;&nbsp;ålder vid död, relaterad till den tidsperiod som inkluderar varje persons dödsår.<br /><b>#pgv_lang[stat_19_arm]#</b>&nbsp;&nbsp;&nbsp;medelåldern för personer vid deras äktenskap.<br /><b>#pgv_lang[stat_20_arm1]#</b>&nbsp;&nbsp;&nbsp;medelåldern för personer vid deras första äktenskap.<br /><b>#pgv_lang[stat_21_nok]#</b>&nbsp;&nbsp;&nbsp;genomsnittliga familjestorlekar.<br /><b>#pgv_lang[stat_1_map]#</b>&nbsp;&nbsp;&nbsp;placering av alla personer eller personer med det angivna namnet, per land.<br /><b>#pgv_lang[stat_2_map]#</b>&nbsp;&nbsp;&nbsp;födelseland.<br /><b>#pgv_lang[stat_4_map]#</b>&nbsp;&nbsp;&nbsp;äktenskapsland.<br /><b>#pgv_lang[stat_3_map]#</b>&nbsp;&nbsp;&nbsp;dödsland.<br /><b>#pgv_lang[stat_9_indi]#</b>&nbsp;&nbsp;&nbsp;cirkeldiagram över personer med källor.<br /><b>#pgv_lang[stat_8_fam]#</b>&nbsp;&nbsp;&nbsp;cirkeldiagram över familjer med källor.</p>";
$pgv_lang["stat_help_y"]		= "~ALTERNATIV FÖR STATISTIKPLOTTER~<br />~Y axeln~<br /><br />Följande alternativ finns för Y-axeln (vertikalt). Dessa alternativ ändrar hur objekten som presenteras på X-axeln visas.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_201_num]#</b>&nbsp;&nbsp;&nbsp;visar antalet personer i varje kategori definierad av X-axeln.<br /><b>#pgv_lang[stat_202_perc]#</b>&nbsp;&nbsp;&nbsp;beräknar och utvärderar andelen av varje artikel i X-axelkategorierna.</p>";
$pgv_lang["stat_help_z"]		= "~ALTERNATIV FÖR STATISTIKPLOTTER~<br />~Z axeln~<br /><br />Följande alternativ är tillgängliga för Z axeln. Dessa alternativ ger en uppdelning av de kategorier som valts för X-axeln.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_300_none]#</b>&nbsp;&nbsp;&nbsp;visar objekten som en enda kolumn för varje X-axelkategori.<br /><b>#pgv_lang[stat_301_mf]#</b>&nbsp;&nbsp;&nbsp;visar objekten i två kolumner (manliga och kvinnliga) för varje X-axelkategori.<br /><b>#pgv_lang[stat_302_cgp]#</b>&nbsp;&nbsp;&nbsp;visar objekten i ett antal kolumner relaterade till de tidsperioder som anges i nästa avsnitt, för varje X-axelkategori.</p>";
$pgv_lang["stat_help_gwx"]		= "~ALTERNATIV FÖR STATISTIKPLOTTER~<br />~gränser för X axeln~<br /><br />Välj önskat åldersintervall.<br /><br />Till exempel <b>#pgv_lang[aft_marr]#</b> beskriver följande uppsättning månadsintervall:<div style=\"padding-left: 30px;\">före äktenskapet<br />från äktenskapet till 8 månader efter<br />från 8 till 12<br />från 12 till 15<br />från 15 till 18<br />från 18 till 24<br />från 24 till 48<br />över 48 månader efter äktenskapet</div><br />När du vill visa kvartal måste du välja <b>#pgv_lang[quarters]#</b>.";
$pgv_lang["stat_help_gax"]		= "~ALTERNATIV FÖR STATISTIKPLOTTER~<br />~gränser för X axeln~<br /><br />Välj önskat åldersintervall.<br /><br />Exempelvis beskriver <b>intervall 10 år</b> följande uppsättning åldersintervall:<div style=\"padding-left: 30px;\">yngre än ett år<br />ett år till 5 år<br />6 till 10<br />11 till 20<br />21 till 30<br />31 till 40<br />41 till 50<br />51 till 60<br />61 till 70<br />71 till 80<br />81 till 90<br />91 till 100<br />äldre än 100 år</div>";
$pgv_lang["stat_help_gbx"]		= "~ALTERNATIV FÖR STATISTIKPLOTTER~<br />~gränser för X axeln~<br /><br />Välj önskat åldersintervall.<br /><br />Till exempel <b>intervall 2 år</b> beskriver följande uppsättning åldersintervall:<div style=\"padding-left: 30px;\">yngre än 16 år<br />16 till 18<br />19 till 20<br />21 till 22<br />23 till 24<br />25 till 26<br />27 till 28<br />29 till 30<br />31 till 32<br />33 till 35<br />36 till 40<br />41 till 50<br />äldre än 50 år</div>";
$pgv_lang["stat_help_gcx"]		= "~ALTERNATIV FÖR STATISTIKPLOTTER~<br />~gränser för X axeln~<br /><br />Välj önskat antalintervall.<br /><br />Exempelvis beskriver <b>intervall ett barn</b> följande uppsättning barnantal:<div style=\"padding-left: 30px;\">utan barn<br />ett barn<br />två barn<br />3, 4, 5, 6, 7, 8, 9, 10 barn<br />mer än 10 barn</div>";
$pgv_lang["stat_help_gwz"]		= "~ALTERNATIV FÖR STATISTIKPLOTTER~<br />~gränser för Z axeln~<br /><br />Välj önskat startår och intervall<br /><br />Till exempel <b>från 1700, intervall 50 år</b> beskriver följande uppsättning datumintervall:<div style=\"padding-left: 30px;\">före 1700<br />1700 till 1749<br />1750 till 1799<br />1800 till 1849<br />1850 till 1899<br />1900 till 1949<br />1950 till 1999<br />2000 eller senare</div>";
$pgv_lang["chart_type_help"]	= "~ALTERNATIV FÖR STATISTIKPLOTTER~<br /><br />Välj vad du vill se i kartdiagrammet. Du kan välja:<div style=\"padding-left: 25px\"><b>#pgv_lang[indi_distribution_chart]#</b>&nbsp;&nbsp;&nbsp;visar de länder där personer från denna databas förekommer.<br /><b>#pgv_lang[surname_distribution_chart]#</b>&nbsp;&nbsp;&nbsp;visar de länder där det angivna efternamnet förekommer.</div>";
$pgv_lang["google_chart_surname_help"]	= "~ALTERNATIV FÖR STATISTIKPLOTTER~<br /><br />Antalet förekomster av det angivna namnet visas på kartan. Om du lämnar fältet tomt används det vanligaste efternamnet.";
$pgv_lang["chart_area_help"]	= "~ALTERNATIV FÖR STATISTIKPLOTTER~<br /><br />Välj det geografiska blocket som du vill se på kartan. Du kan välja:<div style=\"padding-left: 25px\"><b>#pgv_lang[world_chart]#</b>&nbsp;&nbsp;&nbsp;visar alla kontinenter.<br /><b>#pgv_lang[europe_chart]#</b>&nbsp;&nbsp;&nbsp;visar Europa.<br /><b>#pgv_lang[s_america_chart]#</b>&nbsp;&nbsp;&nbsp;visar Sydamerika.<br /><b>#pgv_lang[asia_chart]#</b>&nbsp;&nbsp;&nbsp;visar Asien.<br /><b>#pgv_lang[middle_east_chart]#</b>&nbsp;&nbsp;&nbsp;visar Mellanöstern.<br /><b>#pgv_lang[africa_chart]#</b>&nbsp;&nbsp;&nbsp;visar Afrika.</div>";

//-- Find Media Help
$pgv_lang["manage_media_help"]			= "~#pgv_lang[manage_media]#~<br /><br />På den här sidan kan du enkelt hantera dina mediefiler och mappar.<br /><br />När du skapar nya mediemappar kommer PhpGedView att se till att samma mappstruktur bibehålls inom <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs</b> mapp. När du laddar upp nya mediefiler kan PhpGedView automatiskt skapa miniatyrbilder åt dig.<br /><br />Bredvid varje bild i Media-listan hittar du följande alternativ. De alternativ som faktiskt visas beror på den aktuella statusen för mediefilen.<ul><li><b>#pgv_lang[edit]#</b>&nbsp;&nbsp;&nbsp;När du klickar på det här alternativet ser du en sida där du kan ändra titeln på Media-objektet. Om Media-objektet ännu inte är länkat till en person, familj eller källa i den aktuella aktiva databasen kan du skapa den här länken här. Du kan byta namn på filen eller till och med ändra plats inom mappstrukturen <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Vid behov skapar PhpGedView automatiskt de nödvändiga undermapparna eller alla saknade miniatyrer.</li><li><b>#pgv_lang[edit_raw]#</b>&nbsp;&nbsp;&nbsp;Det här alternativet är endast tillgängligt när administratören har aktiverat det. Du kan visa eller redigera de råa GEDCOM-data som är kopplade till detta Media-objekt. Du bör vara mycket försiktig när du använder det här alternativet.</li><li><b>#pgv_lang[delete_file]#</b>&nbsp;&nbsp;&nbsp;Med det här alternativet kan du radera all kunskap om mediefilen från den aktuella databasen. Andra databaser påverkas inte. Om denna mediefil inte nämns i någon annan databas raderas den och dess tillhörande miniatyrbild.</li><li><b>#pgv_lang[remove_object]#</b>&nbsp;&nbsp;&nbsp;Med det här alternativet kan du radera all kunskap om mediefilen från den aktuella databasen. Andra databaser påverkas inte. Mediefilen och dess tillhörande miniatyrbild raderas inte.</li><li><b>#pgv_lang[remove_links]#</b>&nbsp;&nbsp;&nbsp;Med det här alternativet kan du ta bort alla länkar till medieobjektet från den aktuella databasen. Filen kommer inte att raderas och det Media-objekt som den här filen är känt för i den aktuella databasen kommer att behållas. Andra databaser påverkas inte.</li><li><b>#pgv_lang[set_link]#</b>&nbsp;&nbsp;&nbsp;Med det här alternativet kan du skapa länkar mellan mediefilen och personer, familjer eller källor till den aktuella databasen. Vid behov skapar PhpGedView också det Media-objekt som Media-filen är känd för i databasen.</li><li><b>#pgv_lang[gen_thumb]#</b>&nbsp;&nbsp;&nbsp;När du väljer det här alternativet skapar PhpGedView den saknade miniatyrbilden.</li></ul>";
$pgv_lang["simple_filter_help"]		= "~#pgv_lang[filter]#~<br /><br />Enkelt sökfilter baserad på inskrivna bokstäver, inga jokertecken är tillåtna.";
$pgv_lang["show_thumb_help"]		= "~#pgv_lang[show_thumbnail]#~<br /><br />Miniatyrbilder kommer att visa om du kryssar i denna ruta.";
$pgv_lang["find_media_help"]		= "~#pgv_lang[find_media]#~<br /><br />Detta tillåter dig att söka igenom mediafilsystemet för att hitta mediaartiklar som du vill länka till.";

//-- Add / Edit Media Help
$pgv_lang["add_media_linkid"]		= "~Länk ID~<br /><br />Varje mediaobjekt skall vara associerad med en eller flera personer, familjer ller källori din databas.<br /><br />För att skapa en sådan länk kan du skriva in eller söka efter ett ID för personen, familjen eller källan på samma gång som du skapar mediaobjektet. Du kan också skapa länken senare genom att redigeringsvalet på Hantera media sidan eller genom att lägga till mediaobjekt via Lägg till medialänk som finns på person- familje- eller källsidan.";
$pgv_lang["upload_server_file_help"] = "~#pgv_lang[server_file]#~<br /><br />Mediafilen som du laddar upp kan och bör antagligen få ett annat namn på servern än den har på din lokala dator. Det är för att ofta så har filnamnet mening för dig men är mycket mindre meningsfullt för besökare på din sajt. Tänk också på att det fins en möjlighet att både du och någon annan försöker ladda upp olika filer som heter mormor.jpg.<br /><br />I detta fält specificerar du det nya namnet på filen som laddar upp. Namnet du anger kommer också att användas till namnet på miniatyrbilden, som kan laddas upp separat eller skapas automatiskt. Du behöver inte ange filtypen (jpg, gif, pdf, doc, etc.).<br /><br />Lämna detta fält tomt för att behålla orginalfilnamnet på filen du laddar upp.";
$pgv_lang["upload_server_folder_help"] = "~#pgv_lang[server_folder]#~<br /><br />Administratören är tillåtit upp till #GLOBALS[MEDIA_DIRECTORY_LEVELS]# mappnivåer lägre än standardnivån <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Detta hjälper dig att organisera dina mediafiler och minskar risken för namnkrockar.<br /><br />I detta fält specificerar du destinationsmappen var den uppladdade filen ska hamna. Den matchande miniatyrfilen, antingen uppladdad separat eller automatiskt genererad kommer att sparas in en liknande mappstruktur som startar på <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> istället för <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Du behöver inte skriva in <b>#GLOBALS[MEDIA_DIRECTORY]#</b> delen av destinationmappnamnet.<br /><br />Om du inte är säker på vad du ska skriva här, bör du kontakta sajtadministratören för råd.";
$pgv_lang["view_server_folder_help"] = "~#pgv_lang[server_folder]#~<br /><br />Administratören har aktiverat upp till #GLOBALS[MEDIA_DIRECTORY_LEVELS]# mappnivåer under standard <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Detta hjälper till att organisera mediefilerna och minskar risken för namnkollisioner.<br /><br />I det här fältet väljer du mediamappen vars innehåll du vill visa. När du väljer <b>#pgv_lang[all]#</b> visas alla mediefiler utan hänsyn till mappen där de lagras. Detta kan ge en mycket lång lista med mediaobjekt.";

//--Repository Help
$pgv_lang["help_repolist.php"]		= "~#pgv_lang[repo_list]#~<br /><br />En lista av arkiv visas på denna sida.<br /><br />Namnen på arkivet är sorterad i alfabetisk ordning.<br /><br /><b>ARKIV</b><br />Utan arkiv kan vi inte bygga databasen. Det finns en källa för all information sparad i databasen och den källa förvaras i arkivet. Arkivet kan vara ett personligt arkiv hos en person, en instutition, en publik databas, en statlig eller kyrklig arkiv, en internet källa, etc. För att få access till en källa vill vi veta var och på vilken platd den finns. All nödvändig information för att hitta en källa ska sparas i arkivposten.<br /><br />Ett arkiv kan länkas till många källor.";
$pgv_lang["help_repo.php"]			= "~#pgv_lang[repo_info]#~<br /><br />Detaljerna för arkivet visas här. Tillsammans med källor är arkiven väldigt viktiga för släktforskare. Med korrekta källor och arkivinformation kan du följa spåret efter hur andra forskare hittat informationen. Bör du kunna hitta samma information igen.<br /><br />På denna sida kan du hitta information om arkivtitel, adress, epost och websida.<br /><br />Efter detaljerna om arkivet kommer en lista om alla källor som är kopplade till detta arkiv. Detta låter dig se all information som har hittats i ett specifikt arkiv.<br /><br />Om påslaget av sajtadministratören kommer du att ha en eller två nya menyikonerpå dessa sidor:<ul><li><b>#pgv_lang[view_gedcom]#</b>, vilket visar informationen i GEDCOM-format.</li><li><b>#pgv_lang[add_to_cart]#</b>, vilket låter dig spara informationen i urklippskorgen #pgv_lang[clip_cart]#. Från där kan du ladda ner informationen i GEDCOM-filformatet så att du kann importera det till ditt vanliga släktforskningprogram.</li></ul><br />#pgv_lang[context_help]#";
$pgv_lang["delete_repo_help"]			= "~#pgv_lang[delete_repo]#~<br /><br />När du klickar på detta val markerar du databasen för radering.<br /><br />Vad betyder detta? Antag att du har en bra anledning att radera arkiv från databasen. Klicka på denna länk. Du kommer att tillfråagas om du är säker. När du fortsätter besöket kommer du att märka att arkivet fortfarande syns och kan användas precis som om raderingen inte hänt.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["show_repo_gedcom_help"]	= "~#pgv_lang[view_gedcom]#~<br /><br />När du klickar på denna länk kommer informationen om arkivet, som den är sparad i databasen, att visas i ett popfönster.";
$pgv_lang["add_repository_clip_help"]		= "~#pgv_lang[add_to_cart]#~<br /><br />När du klickar på denna länk kan du lägga till arkivet, som det är sparat i GEDCOM-filen, till din #pgv_lang[clip_cart]#.";
$pgv_lang["repolist_listbox_help"]		= "~#pgv_lang[repo_list]#~<br /><br />I denna box ser du namnen på de arkiv som de är sparade i databasen. Namnen visas i alfabetisk ordning.<br /><br />När du klickar på ett namn i listan kommer du till  #pgv_lang[repo_info]#-sidan där du kommer att se en lista över de källor som är länkade till detta arkiv.";
$pgv_lang["repos_listbox_help"]		= "~#pgv_lang[other_repo_records]#~<br /><br />I denna box kan du se namnet på källor som är länkade till arkivet. Namnen visas i alfabetisk ordning.<br /><br />När du klickar på ett namn i listan, du kommer att flyttas till detaljsidan för källan.";

// Index-Edit
$pgv_lang["block_move_up_help"]		= "~Flytta listposter~<br /><br />Använd denna knapp för att ändra ordningen för posterna i listan. Områdena kommer att skrivas ut i den ordning som de visas.<br /><br />Markera posten som ska flyttas och klicka sedan på kanppen för att flytta posten upp eller ner.";
$pgv_lang["block_move_right_help"]	= "~Flytta listposter~<br /><br />Använd dessa knappar för att flytta en post från en lista till en annan.<br /><br />Markera posten som ska flyttas, klicka sedan på en knapp för att flytta eller kopiera posten i pilens riktning. Använd <b>»</b> och <b>«</b> knapparna för att flytta den markerade posten från längst ut till vänster till den längst ut till höger eller tvärtom. Använd <b>&gt;</b> och <b>&lt;</b> knapparna för att flytta den markerade posten mellan #pgv_lang[available_blocks]#-listan och listan till höger eller vänster om den.<br /><br />Posterna i #pgv_lang[available_blocks]#-listan ändras inte, oavsett vad du gör med #pgv_lang[move_right]# och #pgv_lang[move_left]#-knapparna. Detta är för att samma blocket kan förekomma på flera ställen på samma sida. HTML-blocket är ett bra exempel på varför du skulle vilja ha samma blocket på flera ställen.";
$pgv_lang["block_default_index"]	= "~Standardområdena på #pgv_lang[welcome]#-sidan~<br /><br />När du tar bort all poster från #pgv_lang[main_section]# och #pgv_lang[right_section]# listorna, eller när du klickar på <b>#pgv_lang[reset_default_blocks]#</b>-knappen, kommer områdena att listas enligt följande:<br /><br /><span class='center'><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><td>#pgv_lang[block_cookiepolicy]#<br />#pgv_lang[gedcom_stats_block]#<br />#pgv_lang[gedcom_news_block]#<br />#pgv_lang[gedcom_favorites_block]#<br />#pgv_lang[review_changes_block]#</td><td>#pgv_lang[gedcom_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[todays_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></span>";
$pgv_lang["block_default_portal"]	= "~Standard block på #pgv_lang[mygedview]#-sidan~<br /><br />När du tar bort alla poster från #pgv_lang[main_section]# och #pgv_lang[right_section]# listorna, eller när du klickar på <b>#pgv_lang[reset_default_blocks]#</b>-knappen, kommer områdeslistan att sättas som följer:<br /><br /><span class='center'><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><td>#pgv_lang[todays_events_block]#<br />#pgv_lang[user_messages_block]#<br />#pgv_lang[user_favorites_block]#<br />&nbsp;</td><td>#pgv_lang[welcome_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[upcoming_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></span>";

// FAQ page
$pgv_lang["help_faq.php"] 			= "~Vanliga frågor (FAQ)~<br /><br />#pgv_lang[text_faq_help]#";
$pgv_lang["text_faq_help"] 			= "FAQ-sidan (vanliga frågor) kan innehålla en översikt eller en lista på frågor och svar om användningen av denna släktforskningsajt.<br /><br />Användningen av FAQ-sidan är upp till sajtens administratör. Sajtadministratören kontrollerar innehåll och ordningen som objekten visas på sidan. ";

// Help search
$pgv_lang["hs_title_help"] 			= "<span class='center'>~#pgv_lang[hs_title]#~</span><br />#pgv_lang[hs_intro]#<br /><br />#pgv_lang[hs_keyword_advice]#<br /><br />#pgv_lang[hs_searchhow_advice]#<br /><br />#pgv_lang[hs_searchin_advice]#";
$pgv_lang["hs_intro"]				= "Du kan söka i PhpGedViews hjälpsystem. #pgv_lang[hs_title]# funktionen ger dig en hög grad av kontroll över hur sökfunktionen fungerar, du bör kunna hitta vad du letar efter enkelt.";
$pgv_lang["hs_keyword_advice"] 		= "~#pgv_lang[hs_keyword]#~<br /><br />Du skriver in det ord eller fras du vill hitta.<br /><br />Sökningen tar inte hänsyn till stora eller små bokstäver i sökuttrycket. Det betyder att om du söker efter <b>Person</b> kommer du att hitta text som innehåller <b>Person</b>, <b>person</b> eller <b>PERSON</b>. Du kommer också att hitta texter som innehåller <b>Personer</b> etc, eftersom sökningen letar efter sekvenser av bokstäver inte ord.<br /><br />Du kan låta sökningen leta efter flera ord samtidigt. Skriv in alla ord, separera dem med mellanslag, så här: <b>person&nbsp;familj&nbsp;barn</b>. När mer än ett ord skrivs in är meningen med vad du skrivit in förtydligat i #pgv_lang[hs_searchhow]# fältet.";
$pgv_lang["hs_searchin_advice"]		= "~#pgv_lang[hs_searchin]#~<br /><br />Du bestämmer vad sökningen ska söka i här.<br /><br />Administratörer har möjlighet att söka i användarhjälpen, konfigurationshjälpen eller båda. Användare har inte detta val eftersom de inte har tillgång till konfigurationsinställningarna, de kan bara söka i användarhjälpen.<br /><br />Hjälpfilen innehåller inte bara hjälptext utan också visa textsträngar som används för att bygga fomulär och andra material. Detta val låter dig bestäma om hela hjälpfilen ska genomsökas eller endast hjälptexterna.";
$pgv_lang["hs_searchhow_advice"]	= "~#pgv_lang[hs_searchhow]#~<br /><br />Du förtydligar vad du skrivit in i #pgv_lang[hs_keyword]#-fältet genom att välja ett av möjlighterna som presenteras här.<dl><dt><b>#pgv_lang[hs_searchany]#</b></dt><dd>Om du har valt <b>person&nbsp;familj&nbsp;barn</b>, kommer detta val att hitta hjälptext som innehåller orden listade. Ordningen på orden spelar ingen roll. Betydelsen av sökningen är: \"Hitta hjälptext som innehåller <b>person</b> <u>eller</u> <b>familj</b> <u>eller</u> <b>barn</b>\".</dd><dt><b>#pgv_lang[hs_searchall]#</b></dt><dd>Om du har valt <b>person&nbsp;familj&nbsp;barn</b>, kommer detta val att hitta hjälptext som innehåller alla orden listade. Ordningen på orden spelar ingen roll. Betydelsen av sökningen är: \"Hitta hjälptext som innehåller <b>person</b> <u>och</u> <b>familj</b> <u>och</u> <b>barn</b>\".</dd><dt><b>#pgv_lang[hs_searchsentence]#</b></dt><dd>Om du har valt <b>person&nbsp;familj&nbsp;barn</b>, kommer detta val att hitta hjälptext som innehåller alla orden listade i den specifika ordningen de är inskrivna i. Betydelsen av sökningen är: \"Hitta hjälptext som innehåller <b>person&nbsp;familj&nbsp;barn</b> i exakt denna ordning utan boktäver eller ord imellan\". Du kommer antagligen inte hitta exakt denna mening i någon hjälptext.</dd></dl><br />Det finns några begränsningar för denna typ av sökning. Vissa specialtecken som <b>&quot; &lt; &gt;</b> etc. finns i hjälptexten i symbolisk form och kommer inte hittas om de är en del av söktexten. Vissa hjälptexter innehåller en speciell sorts mellanslag representerad av <b>&amp;nbsp;</b> och du kommer inte hitta fraser som innehåller detta tecken.";

// Directory cleanup tool
$pgv_lang["help_dir_editor.php"]	= "~#pgv_lang[index_dir_cleanup]#~<br /><br />Detta verktyg kan hjälpa sajtadministratörer rensa ut filer från indexmappen.<br /><br />Efterhand kommer filer som logfiler, gamla GEDCOM-filer och gamla backupfiler att samlas i indexmappen. Eftersom många av dessa filer skapas av programmet kan de ägas av en webserveranvändare. Om de ägs av en webserveranvändare är det inte säkert att du kan radera dem. Detta verktyg låter dig radera dessa filer även om de ägs av webserveranvändare.<br /><br />#pgv_lang[index_dir_cleanup_inst]#";

// Various quotes -- The actual text is in help_text.en.php
//$pgv_lang["quote_gedcom"]						= "";
//$pgv_lang["quote_gramps"]						= "";
?>
