<?php
/**
 * Chinese (Simplified) texts
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2019 to 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software;you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation;either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program;if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @version $Id: help_text.zh-cn.php 7371 2024-02-07 01:04:20Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}
$pgv_lang["file_type_help"] = "~#pgv_lang[choose_file_type]#~<br /><br />选择要创建数据库导出的格式。您的选择取决于您要导入新下载的程序的要求和功能您可以选择：<ul><li>#pgv_lang[def_gedcom_help]#</li><li>#pgv_lang[def_gramps_help]#</li></ul>";
$pgv_lang["apply_privacy_help"] = "~#pgv_lang[apply_privacy]#~<br /><br />選中此選項後，輸出文件將根據所選選項通過隱私檢查。這可能會導致刪除某些信息。輸出文件將僅包含具有指示的權限級別的用戶通常可見的信息。<br /><br />如果您只有#pgv_lang[gedadmin]#权限，则无法指定输出文件应根据#pgv_lang[siteadmin]权限级别进行私有化。";
$pgv_lang["convertPath_help"] = "~#pgv_lang[convertPath]#~<br /><br />此选项定义一个常量路径作为输出文件中所有媒体路径的前缀。<br /><br />例如，如果媒体目录已被配置为\"/media\"，如果导出的媒体文件有一个路径\"/media/pictures/xyz.jpg\"，你输入了\"C:\\my pictures\\my family\"进入这个领域，最终的媒体路径将是\"C:\\my pictures\\my family/pictures/xyz.jpg\"。<br /><br />你会注意到这个例子：<ul><li>当前媒体目录名称已从路径</li><li>中删除，并且生成的路径将没有正确的文件夹名称分隔符。</li></ul><br />如果您希望保留在输出文件的媒体文件路径中的媒体目录中，您需要在<b>#pgv_lang[convertPath]#</b>字段中包含该名称。<br /><br />您还应该使用<b>#pgv_lang[convertSlashes]#</b>选项，以确保文件夹名称分隔符一致并符合接收操作系统的要求m。<br /><br />实际URL的媒体路径不会被更改。";
$pgv_lang["convertSlashes_help"] = "~#pgv_lang[convertSlashes]#~<br /><br />此选项确定媒体对象的FILE规范中的文件夹名称是否应该用正斜杠或反斜杠分隔。您的选择取决于接收操作的要求系统。<br /><br />选择<b>#pgv_lang[forwardSlashes]#</b>适用于Microsoft Windows以外的大多数操作系统。选择<b>#pgv_lang[backSlashes]#</b>目标程序在Microsoft Windows系统上运行时应使用><br /><br />实际URL的媒体路径不会更改。";
$pgv_lang["medialist_recursive_help"] = "~#pgv_lang[medialist_recursive]#~<br /><br />选择此选项后，#pgv_lang[multi_title]#将不仅搜索从#pgv_lang[filter]#列表中选择的目录，还搜索其所有子目录。<br /><br />然后检查找到的所有媒体对象的标题，以确定它们是否包含在#pgv_lang[filter ]#中输入的文本。這兩個動作的結果決定了要列出的多媒體對象。";
$pgv_lang["medialist_unlinked_help"] = "~#pgv_lang[medialist_unlinked]#~<br /><br />只会显示未链接到任何GEDCOM记录的媒体。";
$pgv_lang["medialist_current_dir_help"] = "~#pgv_lang[medialist_current_dir]#~<br /><br />选择您要查看的媒体子目录。";
$pgv_lang["sortby_help"] = "~#pgv_lang[sortby]#~<br /><br />选择您希望查看列表的顺序。";
$pgv_lang["help_treenav.php"] = "~#pgv_lang[interactive_tree]#~<br /><br />使用#pgv_lang[interactive_tree]#在兩個方向上查看一個人的整個家譜。這個視圖類似於沙漏視圖，因為它顯示了同一個根人的祖先和後代。這個圖表通過顯示夫妻或家庭而不僅僅是個人的方框，為您提供更緊湊的視圖。<br /><ul><li><b>滾動</b><br />只要您的鼠標光標變為\"移動\"圖標，您就可以單擊並拖動樹以查看樹的其他部分。當您拖動樹時，後代將自動展開，直到沒有更多代可以在該方向上查看。<br /></li><li><b>縮放</b><br />您可以使用樹左側的圖標進行放大和縮小。縮小將允許您查看更多一次在屏幕上的樹。當你縮小時，文字會變得難以閱讀;當你的鼠標懸停在一個盒子上時，你會得到一個放大的視圖。<br /></li><li><b>更多细节</b><br />單擊任何框將展開框並顯示更詳細的視圖。在展开模式下，单击某个人的姓名将打开他们的#pgv_lang[indi_info]#页面。單擊<img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt=''/>將以該人重新繪製樹作為新根。單擊<img src='#GLOBALS[PGV_IMAGE_DIR]#/buttons/family.gif' alt=''/>將帶您進入該家庭的詳細信息頁面。<br /></li><li><b>切換配偶</b><br /><img src='#GLOBALS[PGV_IMAGE_DIR]#/small/sfamily.gif' width='15px' height='15px' alt=''/>圖標直接位於縮放按鈕下方在下降側打開或關閉所有配偶的顯示。當顯示器設置為顯示配偶時，所有人的配偶都將出現在包裝盒中。所有這些人的孩子也將被展示。當顯示配偶的選項關閉時，只會顯示該人的最後配偶和配偶的子女。<br /></li><li><b>大樹</b><br />#pgv_lang[interactive_tree]#可從許多不同的頁面獲得，包括#pgv_lang[indi_info]#頁面上的Tree選項卡和Welcome頁面上的Charts塊。從其他頁面查看樹時，您還將在縮放圖標下方有一個樹圖標。如果您點擊<img src ='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt=''/>，您将进入#pgv_lang[interactive_tree]#页面。</li></ul>";

$pgv_lang["move_mediadirs_help"] = "~#pgv_lang[move_mediadirs]#~<br /><br />启用媒体防火墙后，多媒体文件可以存储在无法从Internet访问的服务器目录中。<br /><br />这些按钮允许您轻松移动受保护（不可通过网络寻址）<b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b>和普通<b>#GLOBALS[之间]的整个媒体目录结构MEDIA_DIRECTORY]#</b>目录。";
$pgv_lang["setperms_help"] = "~#pgv_lang[setperms]#~<br /><br />递归设置受保护（不是网址）<b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b>的权限普通的<b>#GLOBALS[MEDIA_DIRECTORY]#</b>目录是世界可写或只读的。";
$pgv_lang["no_update_CHAN_help"] = "~#pgv_lang[no_update_CHAN]#~<br /><br />管理员有时需要清理和更正用户提交的数据。例如，他们可能需要更正PLAC位置以包含国家/地区。这些更正，通常会替换原始更改的信息。这可能是不可取的。<br /><br />选择此选项后，网站将保留原始的更改信息，而不是将其替换为当前会话的信息。选择此选项后，管理员还可以修改或删除与原始CHAN标记关联的信息。";
$pgv_lang["edit_SOUR_EVEN_help"] = "~#pgv_lang[source_events]#~<br /><br />每個來源記錄特定事件，通常是針對給定的日期範圍和地方管轄區。例如，人口普查記錄人口普查事件和教會記錄記錄出生，婚姻，和去世事件。<br /><br />從提供的事件列表中選擇此源記錄的事件。日期應以範圍格式指定，例如<i>FROM 1900 TO 1910</i>。地方管轄權是包含該來源中所有下級地方的最低管轄區的名稱。例如，\"Oneida, Idaho, USA\"将被用作奥奈达县各镇的事件来源的管辖区。如果记录的事件不仅发生在奥奈达县，而且发生在爱达荷州的其他县，则\"Idaho, USA\"是管辖区。";
$pgv_lang["cache_life_help"] = "~#pgv_lang[cache_life]#~<br /><br />为了提高性能，这个PhpGedCom欢迎页面块保存为缓存文件。您可以控制刷新缓存文件的频率。<br /><br /><ul><li><b>-1</b>表示缓存文件永远不会自动刷新。要获取新的副本，您需要删除所有缓存文件。您可以在自定义欢迎中执行此操作页面。</li><li><b>0</b>（零）表示此块永远不会被缓存，每次在网站欢迎页面上显示该块时，您都会看到一个新的副本。自动用于频繁更改的块，例如#pgv_lang[logged_in_users_block]#和#pgv_lang[random_media_block]#分段。</li><li><b>1</b>（一）表示新鲜每天创建此块缓存文件的副本，<b>2</b>表示每两天创建一个新副本，<b>7</b>表示每周创建一个新副本等。</li></ul>";
$pgv_lang["clear_cache_help"] = "~#pgv_lang[clear_cache]#~<br /><br />为了提高性能，网站欢迎页面上的几个块都被保存为索引目录中的缓存文件。大多数块的缓存文件都刷新了每天一次，但有时您可能需要手动刷新它们。<br /><br />此按钮允许您在必要时刷新缓存文件。";
$pgv_lang["import_options_help"] = "您可以选择在导入GEDCOM时使用的其他选项。";
$pgv_lang["verify_gedcom_help"] = "在这里，您可以选择继续上传和导入此GEDCOM文件，也可以中止上传和导入。";
$pgv_lang["add_gedcom_instructions"] = "输入这个新GEDCOM的文件名。新的GEDCOM文件将在索引目录中创建：#INDEX_DIRECTORY#";
$pgv_lang["random_media_start_slide_help"] = "~#pgv_lang[random_media_start_slide]#~<br /><br />幻灯片显示是否应在页面加载时自动启动。<br /><br />幻灯片改变了块的内容而不从服务器预加载信息并且没有重新加载整个页面。";
$pgv_lang["random_media_ajax_controls_help"] = "~#pgv_lang[random_media_ajax_controls]#~<br /><br />您可以使用此设置来显示或隐藏随机媒体块的幻灯片控件。<br /><br />这些控件允许用户跳转另一个随机对象或通过随机选择的媒体播放，如幻灯片。幻灯片改变了块的内容，无需从服务器预加载信息，也无需重新加载整个页面。";
$pgv_lang["edit_add_unlinked_source_help"] = "~#pgv_lang[add_unlinked_source]#~<br /><br />使用此链接向数据库添加新源，而不将源链接到另一条记录中的源引文。新源将出现在源列表中，但在链接到源引文之前，它不会出现在任何图表或程序中的任何其他位置。";
$pgv_lang["edit_add_unlinked_note_help"] = "~#pgv_lang[add_unlinked_note]#~<br /><br />使用此链接向数据库添加新的共享注释，而不将注释链接到任何记录。<br /><br />新注释将出现在共享笔记列表中，但在链接到个人，家庭或事件之前，不会出现在任何图表或程序中的任何其他位置。";
$pgv_lang["link_person_id_help"] = "~#pgv_lang[label_local_id]#~<br /><br />在此字段中输入您要链接的人的ID（例如I100）。";
$pgv_lang["link_gedcom_id_help"] = "~#pgv_lang[label_gedcom_id]#~<br /><br />使用此部分选择包含您要链接的人的备用数据库标识符。";
$pgv_lang["link_remote_site_help"] = "~#pgv_lang[label_site]#~<br /><br />在本节中，您将指定连接到托管您要链接的数据的远程站点所需的参数。您可以选择从列表中进行选择您之前使用过的已知网站，或输入#pgv_lang[label_site_url2]#和#pgv_lang[label_gedcom_id]#以获取新网站。<br /><br />在<b>#pgv_lang[label_site_url2]#</b>字段，您输入URL以访问Web服务描述文件（WDSL），该文件告诉网站如何访问远程站点上的数据。对于远程网站，WSDL文件的URL将如下所示： u> http://www.remotesite.com/phpGedView/genservice.php?wsdl </u><br /><br /><b>#pgv_lang[label_gedcom_id]#</b>字段用于输入一个可选的数据库标识符，用于需要一个的远程站点。对于网站站点，这是GEDCOM文件的名称。<br /><br /><b>#pgv_lang[label_username_id]#</b>和<b>#pgv_lang[label_password_id]#</b>字段是必需的如果数据库需要它。<br /><br /><i>注意：远程网站站点必须运行4.0或更高版本;早期版本没有此功能。</i>";
$pgv_lang["link_remote_location_help"] = "~#pgv_lang[label_location]#~<br /><br />此选项允许您选择要链接的人的数据是在同一站点上，还是在不同的族谱数据库集中，或者数据是否为在可通过互联网访问的其他网站上。<br /><br />如果此人在同一网站上，则会要求您选择数据集标识符并输入此人的ID。<br /><br />远程站点，将要求您输入其URL，数据库标识符和此人的远程ID。";
$pgv_lang["link_remote_rel_help"] = "~#pgv_lang[label_rel_to_current]#~<br /><br />使用此选项可选择远程人员与您在网站上链接他们的人之间的关系。例如，选择<i>父亲</i>意味着远程站点上的人是您将他们链接到本地​​的人的父亲。";
$pgv_lang["link_remote_help"] = "~#pgv_lang[link_remote]#~<br /><br />使用此表單將人們鏈接到其他網站或您的網站副本可訪問的其他系譜數據庫。<br /><br />添加這樣的鏈接，您必須首先選擇關係類型，然後選擇網站已知的站點或定義一個新站點，然後輸入該站點的您想要鏈接的人的ID。然後網站將自動從該站點下載信息。必要的遠程站點。下載的信息<u>不</u>成為您的家譜數據庫的一部分;它保留在原始站點上，但被合併到顯示此遠程鏈接人員的各個頁面中。<br /><有關該元素的更多信息，請參閱頁面上每個元素旁邊的\"幫助\"鏈接。您還可以查看在線英語教程以獲取更多信息：<a href=\"#PGV_PHPGEDVIEW_WIKI#/en/index.php?title=How_To:Remote_Link_Individuals_Across_Websites_And_Databases\" target=\"_ blank\">#PGV_PHPGEDVIEW_WIKI#</a>。";

//-- Edit Interface
$pgv_lang["edit_ABBR_help"] = "~缩写标题~<br /><br />使用此字段存储标题的缩写版本。此字段与源上的标题字段一起使用。默认情况下，PGV将首先使用标题然后缩写标题。<br /><br />根据GEDCOM 5.5规范，\"此条目是提供用于分类，归档和检索源记录的简短标题（第62页）。\"<br /><br在网站中，缩写标题是可选的，但在其他家谱程序中则是必需的。";
$pgv_lang["edit_ROMN_help"] = "~浪漫的名字~<br /><br />在许多文化中，习惯上有一个传统名称拼写的传统字符，也是一个罗马化版本的名称，因为它将拼写或发音为基于拉丁语的语言字母，如英语。<br /><br />如果您希望使用希腊语，希腊语，俄语，中文或阿拉伯语等非拉丁字母输入标淮名称字段中的名称，那么您可以使用此字段使用拉丁字母输入相同的名称。名称的两个版本都将出现在列表和图表中。<br /><br />虽然此字段标记为\"Romanized\"，但不限于仅包含基于拉丁字母的字符。这可能与日语名称一起使用，其中可能出现三个不同的字母。";
$pgv_lang["edit_ROMN_GIVN_help"] = "#pgv_lang[edit_ROMN_help]#<br /><br />在此字段中，您应该输入该人的给定名称。例如，在名称\"John Robert Finlay\"中，应输入给定的名称这里是\"John Robert\"";
$pgv_lang["edit_ROMN_SURN_help"] = "#pgv_lang[edit_ROMN_help]#<br /><br />在此字段中，您应输入此人的姓氏。例如，在名称\"John Robert Finlay\"中，应输入的姓氏为\"Finlay\"<br /><br />有多个姓氏的个人，在西班牙和葡萄牙很常见，应该用逗号分隔姓氏。这表明该人将被列在每个姓名下。例如，姓氏\"Cortes,Vega\"将列在<b>C</b>和<b>V</b>之下，而姓氏\"Cortes Vega\"只会在<b>C</b>下列出。";
$pgv_lang["edit__HEB_help"] = "~希伯来名称~<br /><br />在许多文化中，习惯上有传统名称拼写的传统名称以及名称的罗马化版本，因为它将以基于拉丁语的语言拼写或发音字母，如英文。<br /><br />如果您更喜欢使用拉丁字母在标淮名称字段中输入名称，那么您可以使用此字段在非拉丁字母表中输入相同的名称，例如希腊语，希伯来语，俄语，阿拉伯语或中文。名称的两个版本都将出现在列表和图表中。<br /><br />虽然此字段标有\"希伯来语\"，但不限于仅包含希伯来字符。";
$pgv_lang["edit__HEB_GIVN_help"] = "#pgv_lang[edit__HEB_help]#<br /><br />在此字段中，您应该输入该人的给定名称。例如，在名称\"John Robert Finlay\"中，应输入给定的名称这里是\"约翰罗伯特\"";
$pgv_lang["edit__HEB_SURN_help"] = "#pgv_lang[edit__HEB_help]#<br /><br />在此字段中，您应输入此人的姓氏。例如，在名称\"John Robert Finlay\"中，应输入的姓氏为\"Finlay\"<br /><br />有多个姓氏的个人，在西班牙和葡萄牙很常见，应该用逗号分隔姓氏。这表明该人将被列在每个姓名下。例如，姓氏\"Cortes,Vega\"将列在<b>C</b>和<b>V</b>之下，而姓氏\"Cortes Vega\"将只列在<b>C下</b>。";
$pgv_lang["edit_SEX_help"] = "#pgv_lang[edit_sex_help]#";
$pgv_lang["edit_NAME_help"] = "#pgv_lang[edit_name_help]#";
$pgv_lang["edit_add_unlinked_person_help"] = "~#pgv_lang[add_unlinked_person]#~<br /><br />使用此表單添加未鏈接的人。<br /><br />當您將未鏈接的人添加到您的家譜中時，此人將不會鏈接到任何其他人，直到您鏈接它們。之后，您可以通过#pgv_lang[indi_info]页面上的#pgv_lang[relatives]#标签将人们链接在一起。";
$pgv_lang["edit_URL_help"] = "~#factarray[URL]#~<br /><br />输入包含http://的URL地址。示例：<b>http://www.phpgedview.net/</b><br /><br />如果您不想包含URL，请将此字段留空。";
$pgv_lang["edit_WWW_help"] = "~#factarray[WWW]#~<br /><br />输入网页主页地址，包括http://。示例：<b>http://www.phpgedview.net/</b><br /><br />如果您不想包含Web主页地址，请将此字段留空。";
$pgv_lang["edit_EMAIL_help"] = "~#factarray[EMAIL]#~<br /><br />输入电子邮件地址。示例：<b>name@hotmail.com</b><br /><br />如果您将此字段留空不想包含电子邮件地址。";
$pgv_lang["edit_FAX_help"] = "~#factarray[传真]#~<br /><br />输入传真号码，包括国家和地区代码。例如，德国的号码可能是+49 25859 56 76 89以及美国或加拿大的号码可能是+1 888 555-1212。​​<br /><br />如果您不想包含传真号码，请将此栏位留空。";
$pgv_lang["edit_PHON_help"] = "~#factarray[PHON]#~<br /><br />输入电话号码，包括国家和地区代码。例如，德国的电话号码可能是+49 25859 56 76 89以及美国或加拿大的电话号码可能是+1 888 555-1212。​​<br /><br />如果您不想包含电话号码，请将此字段留空。";
$pgv_lang["edit_ADDR_help"] = "~#factarray[ADDR]#~<br /><br />在信封上输入地址就像在信封上写一样。<br /><br />如果你不想要这个字段留空包括一个地址。";
$pgv_lang["edit_GIVN_help"] = "#pgv_lang[edit_given_name_help]#";
$pgv_lang["edit_SPFX_help"] = "~姓氏前缀~<br /><br />输入或选择姓氏主要部分之前的单词。例如<b>von</b> Braun，<b>van der</b> Kloot，<b>de</b> Graaf等";
$pgv_lang["edit_SURN_help"] = "#pgv_lang[edit_surname_help]#";
$pgv_lang["edit_NSFX_help"] = "#pgv_lang[edit_suffix_help]#";
$pgv_lang["edit__MARNM_help"] = "~#factarray[_MARNM]#~<br /><br />使用适用于姓名字段的相同格式规则输入此人的已婚姓名。此字段是可选的。<br /><br />例如，如果Mary Jane Brown与John White结婚，您可以输入（当然没有引号）<ul><li>美国用法：&nbsp;&nbsp;\"Mary Jane Brown /White/\"</li><li>欧洲用法：&nbsp;&nbsp;\"Mary Jane /White/\"</li><li>欧洲替代用法：&nbsp;&nbsp;\"Mary Jane /White-Brown/\"或\"Mary Jane /Brown-White/\"</li> </ul>只有在玛丽·布朗与约翰·怀特结婚后才开始以新名称称呼自己时，你应该这样做。例如，在某些地方，例如魁北克省（加拿大），名字是非法的以这种方式改变。<br /><br />男人有时在结婚后改名，通常使用带连字符的形式，但偶尔也会取妻子的姓氏。";
$pgv_lang["edit_PEDI_help"] = "~#factarray[PEDI]#~<br /><br />这个字段描述了孩子与家人的关系。可能性是：<ul><li><b>#pgv_lang[unknown]#</b>&nbsp;&nbsp;&nbsp;无法确定孩子与家人的关系。选择此选项后，#factarray[PEDI]#字段将不会被复制到数据库中。<br /><br /></li><li><b>#factarray[BIRT]#</b>&nbsp;&nbsp;&nbsp;此选项表示孩子出生时与其家庭有关。<br /><br /></li><li><b>#pgv_lang[adopted]#</b>&nbsp;&nbsp;&nbsp;该选项表明该儿童已被其家庭收养。这<i>不</i>表明孩子与其家人之间没有血缘关系;它表明孩子在孩子出生后的某个时间被这个家庭收养。<br /><br /></li><li><b>#pgv_lang[foster]#</b>&nbsp;&nbsp;&nbsp;该选项表明该儿童是该家庭的寄养儿童。通常，孩子与家人之间没有血缘关系。<br /><br /></li><li><b>#pgv_lang[sealing]#</b>&nbsp;&nbsp;&nbsp;这个孩子在LDS<i>册封</i>仪式上被封为家人。在父母在孩子出生后彼此册封时进行儿童册封。父母册封后出生的孩子将自动与家人册封。<br /><br /></li> </ul>";
$pgv_lang["edit_AGNC_help"] = "~#factarray[AGNC]#~<br /><br />有权威的组织，机构，公司，个人或其他实体。<br /><br />例如，一个人的雇主，或管理仪式或活动的教堂，或负责创建和/或存档记录的组织。";

$pgv_lang["context_help"] = "点击页面上条目旁边的<b>？</b>可以获得更多帮助。";

$pgv_lang["register_gedcomid_help"] = "~#pgv_lang[gedcomid]#~<br /><br />数据库中的每个人都有一个唯一的ID号码。如果您知道自己记录的ID号，请在此输入。如果您不在由于隐私设置，我们不知道您的身份证号码或找不到它，请在\"注释\"字段中提供足够的信息，以帮助网站管理员确定您在此网站上的身份，以便他为您设置ID。";
$pgv_lang["register_comments_help"] = "~#pgv_lang[comments]#~<br /><br />使用此字段告诉网站管理员您申请帐户的原因以及您与本网站上显示的家谱有何关联。您也可以使用此字段输入您对网站管理员的任何其他评论。";
$pgv_lang["utf8_ansi_help"] = "~从UTF-8转换为ANSI~<br /><br />为了在Internet上进行最佳显示，网站使用UTF-8字符集。例如，某些程序，例如Family Tree Maker，不支持导入编码的GEDCOM文件在UTF-8中。选中此框会将文件从<b>UTF-8</b>转换为<b>ANSI (ISO-8859-1)</b>。<br /><br />格式您需要的程序取决于您用来处理下载的GEDCOM文件的程序。如果您不确定，请参阅该程序的文档。<br /><br />请注意，要保持特殊字符保持不变，您需要保持文件为UTF-8并将其转换为程序的方法，通过其他方式处理这些特殊字符。请咨询程序的制造商或作者。<br /><br />这<a href='http://en.wikipedia.org/wiki/UTF-8' target='_blank' title='维基百科文章'><b>维基百科文章</b></a>包含有关UTF-8的综合信息和链接。";
$pgv_lang["remove_tags_help"] = "~删除自定义PGV标记~<br /><br />选中此选项将删除可能已被网站添加到记录中的任何自定义标记。<br /><br />网站使用的自定义标记包括<b> _PGVU</b>标记用于标识在线更改记录的用户以及<b>_THUM</b>标记，该标记告诉网站图像应该用作缩略图。<br /><br />自定义将下载的GEDCOM导入另一个家谱应用程序时，标签可能会导致错误。";
$pgv_lang["download_zipped_help"] = "~下载GEDCOM作为ZIP文件~<br /><br />当您选中此选项时，GEDCOM文件的副本将在下载开始前压缩为ZIP格式。这将大大减小其大小，但您需要使用兼容的Unzip程序（例如WinZIP）解压缩传输的GEDCOM文件，然后才能使用它。<br /><br />这是下载大型GEDCOM文件的有用选项。下载的风险很大未压缩文件的时间可能超过允许的最大执行时间，导致文件下载不完整.ZIP选项应将下​​载时间减少75%。";
$pgv_lang["edit_NCHI_help"] = "~#factarray[NCHI]#~<br /><br />输入此个人或家庭的子女数量。这是一个可选字段。";
$pgv_lang["edit_TIME_help"] = "~#factarray[TIME]#~<br /><br />以前导零的24小时格式输入此活动的时间。午夜为00:00。例如：04:50 13:00 20:30。";
$pgv_lang["edit_NOTE_help"] = "~#factarray[注意]#~<br /><br />注释是自由格式的文本，将出现在页面的\"事实详细信息\"部分。";
$pgv_lang["edit_SHARED_NOTE_help"] = "~#pgv_lang[shared_note]#~<br /><br />共享笔记是自由格式文本，将显示在页面的\"事实详细信息\"部分。<br /><br />每个共享笔记都可以链接不止一个人，家庭，来源或事件。";
$pgv_lang["edit_CEME_help"] = "~#factarray[CEME]#~<br /><br />输入埋葬个人的墓地名称或其他安息地点。";
$pgv_lang["edit_ASSO_help"] = "~#factarray[ASSO]#~<br /><br />输入关联的GEDCOM ID。";
$pgv_lang["edit_RELA_help"] = "~#factarray[RELA]#~<br /><br />从列表中选择一个关系名称。选择<b>教父</b>意味着：<i>这位员工是当前个人的教父</i>。";
$pgv_lang["show_spouse_help"] = "~#pgv_lang[show_spouses]#~<br /><br />默认情况下，此图表不显示后代的配偶，因为它会使图表更难阅读和理解。启用此选项将在图表上显示配偶。";
$pgv_lang["reorder_families_help"] = "~#pgv_lang[reorder_families]#~<br /><br />#pgv_lang[親戚]#選項卡上的家庭按其出現在個人GEDCOM記錄中的順序顯示。家庭未按結婚日期排序因為結婚日期通常是未知的，但婚姻的順序<u>是</u>已知。<br /><br />项允许您更改#pgv_lang[relatives]#选项卡中列出的系列的顺序。 如果您想按结婚日期对家庭进行排序，只需按一下按钮即可自动完成。";
$pgv_lang["autoContinue_help"] = "~#pgv_lang[autoContinue]#~<br /><br />当网站检测到GEDCOM导入需要的时间超过时间限制允许的时间时，它将显示<b>#pgv_lang[del_proceed]#</b>按钮必须按才能继续导入。<br /><br />当此选项设置为<b>#pgv_lang[yes]#</b>时，网站将自动按<b>#pgv_lang[del_proceed]#</b>按钮给你。这样可以减轻繁琐的进口时必须反复按下按钮的麻烦。";
$pgv_lang["firstname_i_help"] = "~#pgv_lang[firstname_alpha_index]#~<br /><br />你选择的姓氏超过#GLOBALS[SUBLIST_TRIGGER_I]#个人。<br /><br />为了帮助你找到你想要的人，根据人名的第一个字母将列表分成较小的列表。这个按字母顺序排列的子索引的工作方式与姓氏的字母索引相同。<br /><ul><li>点击一个字母查看全部</li> <li>选择<b>#pgv_lang[NN]#</b>列出所有姓名不明的人。</li><li>选择<b>#pgv_lang[all]#</b>将显示所有具有先前姓氏的人员的列表。</li></ul>因为名称很多，所以此列表可能需要很长时间才能显示出现在你的屏幕上。";
$pgv_lang["firstname_f_help"] = "~#pgv_lang[firstname_alpha_index]#~<br /><br />您选择的姓氏超过#GLOBALS[SUBLIST_TRIGGER_F]#个人。<br /><br />为了帮助您找到您想要的家庭，根据人名的第一个字母将列表分成较小的列表。这个按字母顺序排列的子索引的工作方式与名称的字母索引相同。<br /><ul><li>点击一个字母查看所有以该字母开头的名字。</li><li>选择<b>#pgv_lang[NN]#</b>列出所有姓名不明的人。</li><li>选择<b>#pgv_lang[all]#</b>将显示所有具有先前选择姓氏的家庭的列表。</li></ul>因为名称很多，所以此列表可能需要很长时间出现在你的屏幕上。";
$pgv_lang["edit_TYPE_help"] = "~#factarray[TYPE]#~<br /><br />#factarray[TYPE]#字段用于输入有关该条目的其他信息。在大多数情况下，该字段是完全自由格式的，您可以输入你想要的任何东西。";
$pgv_lang["edit_TEMP_help"] = "~#factarray[TEMP]#~<br /><br />对于LDS法令，这个字段记录了寺庙的执行地点。";
$pgv_lang["edit_STAT_help"] = "~#factarray[STAT]#~<br /><br />这是一个可选的状态字段，主要用于LDS条例，因为它们通过TempleReady程序运行。";
$pgv_lang["edit__PRIM_help"] = "~#factarray[_PRIM]#~<br /><br />使用此字段表示此媒体项是其所附人员的突出显示或主要条目。突出显示的图像是将使用的图像在图表和个人页面上。";
$pgv_lang["edit__THUM_help"] = "~#factarray[_THUM]#~<br /><br />此选项可让您覆盖缩略图图像的常用选项。<br /><br />GEDCOM有一个配置选项，指定是否应发送网站当当前页面需要缩略图时，大图像或小图像到浏览器。&laquo;#factarray[_THUM]#&raquo;选项，当设置为<b>#pgv_lang[yes]#</b>时，会暂时覆盖设置GEDCOM配置选项，以便网站始终发送大图像。当GEDCOM配置指定应始终使用大图像时，不能强制网站发送小图像。<br /><br />网站没有重新调整正在发送的图像的大小;浏览器根据它收到的页面规范执行此操作。当发送的图像不是真正的网站期望发送小图像的缩略图时，这会产生不良后果。这不是错误：有时可能需要显示a在人们通常期望看到缩略图大小的图片的地方的大图像。<br /><br />你应该避免设置&laquo;#factarray[_THUM]#&raquo;选项<b>#pgv_lang[yes]#</b>。此选择将导致过多的图像相关数据被发送到浏览器，只是让浏览器丢弃多余的数据。页面加载，尤其是包含许多图像的图表，可能会严重减慢。";
$pgv_lang["edit_TITL_help"] = "~#factarray[TITL]#~<br /><br />输入您正在编辑的条目的标题。如果这是多媒体条目的标题，请输入一个描述性标题，以便向用户标识该条目。 ";
$pgv_lang["edit_FILE_help"] = "~#factarray[FILE]#~<br /><br />这是多媒体对象记录中最重要的字段。它表示要使用的文件。至少，您需要输入文件的名称。在您的设置上，有关文件位置的更多信息可能会有所帮助。<br /><br />您可以使用<b>#pgv_lang[find_media]#</b>链接来帮助您找到已经存在的媒体条目上传到网站。<br /><br />#pgv_lang[readme_help]#";
$pgv_lang["edit_FORM_help"] = "~#factarray[FORM]#~<br /><br />这是一个可选字段，可用于输入多媒体对象的文件格式。一些家谱程序可能会查看此字段以确定如何处理但是，由于媒体不能很好地跨计算机系统传输，因此这个领域并不是很重要。";
$pgv_lang["generate_thumb_help"] = "~#pgv_lang[auto_thumbnail]#~<br /><br />您的系统可以自动为某些类型的图像生成缩略图。可能支持BMP，GIF，JPG和PNG文件。您的系统支持的类型复选框旁边会列出。<br /><br />单击此复选框，系统会通知系统您正在上传此类图像，并希望它尝试为它们生成缩略图。如果您未选中该复选框想要提供自己的缩略图。";
$pgv_lang["edit_add_NOTE_help"] = "~#pgv_lang[add_note]#~<br /><br />本部分允许您为当前正在编辑的事实添加新注释。注释是自由格式文本，将显示在\"事实详细信息\"部分中。这一页。";
$pgv_lang["edit_add_SHARED_NOTE_help"] = "~#pgv_lang[add_shared_note]#~<br /><br />~#pgv_lang[edit_shared_note]#~<br /><br />共享笔记，如常规笔记，是自由格式文本。与常规笔记不同，每个共享笔记可以链接到多个人，家庭，来源或事实。<br /><br />通过单击相应的图标，您可以建立指向现有共享笔记的链接或创建新的共享笔记和如果已经建立了现有共享笔记的链接，您还可以编辑该笔记的内容。<br /><ul><li><b>链接到现有的共享笔记</b><div style=\"padding-left: 20px;\">如果您已经知道所需共享笔记的ID编号，您可以直接在该字段中输入该编号。<br /><br />当您点击<b>#pgv_lang[find_shared_note]#</b>图标，您将能够搜索所有现有共享笔记的文本，然后选择其中一个。所选笔记的ID号将输入到该字段中自动。<br /><br />你必须点击<b>#pgv_lang[add]#</b>按钮更新原始记录。</div><br /></li><li><b>创建新的共享注释</b><div style=\"padding-left:20px;\">单击<b>#pgv_lang[create_shared_note]#</b>图标时，将打开一个新窗口。您可以根据需要输入新笔记的文本。与常规备注一样，您可以输入URL。<br /><br />当您单击<b>#pgv_lang[save]#</b>按钮时，您将看到一条消息，其中包含新创建的ID号共享笔记。您应该单击此消息以关闭编辑窗口，并将该新ID号直接复制到ID号字段中。如果您只是关闭窗口，则不会自动复制新创建的ID号。<br /><br />您必须单击<b>#pgv_lang[add]#</b>按钮更新原始记录。</div><br /></li><li><b>编辑现有的共享笔记</b><div style=\"padding-left:20px;\">点击<b>#pgv_lang[edit_shared_note]#</b>图标，将打开一个新窗口。您可以根据需要更改现有共享笔记的文本。与常规笔记一样，您可以输入URL。<br /><br />当您单击<b>#pgv_lang[save]#</b>按钮时，将更新共享笔记的文本。您可以关闭窗口，然后再次单击<b>#pgv_lang[save]#</b>按钮。<br /><br />当您更改共享笔记的文本时，您的更改将反映在所有该共享笔记当前链接到的位置。您进行更改后建立的新链接也将使用更新后的文本。</div></li></ul>";
$pgv_lang["edit_add_GEDFact_ASSISTED_help"] = "~使用GEDFACT ASSISTANT~<br /><br />单击\"+\"图标将打开GEDFact Shared Note Assistant窗口。<br />将在那里找到具体的帮助。<br /><br />单击\"保存\"按钮时，将在此处粘贴共享注释的ID。";
$pgv_lang["edit_add_SOUR_help"] = "~#pgv_lang[add_source]#~<br /><br />本部分允许您为当前正在编辑的事实添加新的源引文。<br /><br />在输入的\"源\"字段中输入如果您需要输入新来源，请单击<b>#pgv_lang[create_source]#</b>链接。在\"引文详细信息\"字段中，您可以输入可能有助于找到人的页码或其他信息源中的信息。在文本字段中，您将从源输入文本转录。";
$pgv_lang["edit_add_ASSO_help"] = "~#pgv_lang[add_asso]#~<br /><br />#pgv_lang[add_asso]#允许您将事实与站点中的关联人员链接。这是您可能记录某人是某人的一种方式另一个人的教父。";
$pgv_lang["edit_QUAY_help"] = "~#factarray[QUAY]#~<br /><br />您可以使用此字段记录此来源中的数据的质量或可靠性。许多家谱应用程序使用该字段中的数字。<b>3</b>可能意味着数据是主要来源，<b>2</b>可能意味着它是次要来源，<b>1</b>可能意味着信息有问题，并且<b>0</b>可能意味着来源不可靠。";
$pgv_lang["edit_PAGE_help"] = "~#factarray[PAGE]#~<br /><br />在\"引文详细信息\"字段中，您可以输入可能有助于某人在源中查找信息的页码或其他信息。";
$pgv_lang["edit_TEXT_help"] = "~#factarray[TEXT]#~<br /><br />在这个字段中你可以输入这个来源的引文。数据的例子可能是来源的文本转录，或者是什么的描述在引文中。";
$pgv_lang["edit_SOUR_help"] = "~#factarray[SOUR]#~<br /><br />此字段允许您更改此事实的源引文链接到的源记录。此字段采用源ID。旁边的字段将列出标题当前来源ID。使用<b>#pgv_lang[find_id]#</b>链接查找来源的ID号。要删除整个引文，请将此字段留空。";
$pgv_lang["edit_edit_raw_help"] = "~#pgv_lang[edit_raw]#~<br /><br />此页面允许您编辑原始GEDCOM记录。您应谨慎使用此页面;它需要很好地理解GEDCOM 5.5.1标淮。有关GEDCOM 5.5.1标淮的更多信息，请参阅帮助主题<b>GEDCOM文件</b>。<br /><br />网站提供了许多添加和编辑信息的方法，但有时您可能会想要编辑原始的GEDCOM结构。如果可能，你应该使用提供的表格来添加信息，但是如果不可能，你可以使用这个表格。提交表格后，我们将检查你的信息是否符合标淮和CHAN记录将被更新。";
$pgv_lang["add_from_clipboard_help"] = "~#pgv_lang[add_from_clipboard]#~<br /><br />网站允许您将最多10个事实及其所有细节复制到剪贴板。这个剪贴板与您可以用来导出的剪贴板不同数据库的一部分。<br /><br />您可以从剪贴板中选择任何事实，并将所选事实复制到当前正在编辑的个人，家庭，媒体，来源或存储库记录。但是，您无法复制不同记录类型的事实。例如，您不能将婚姻事实复制到来源或个人记录，因为婚姻事实仅与家庭记录相关。<br /><br />这在输入类似事实时非常有用，例如人口普查事实，对很多个人或家庭而言。";
$pgv_lang["edit_PLAC_help"] = "~#factarray[PLAC]#~<br /><br />地方應根據家譜標淮輸入。在家譜中，地方首先記錄有關該地點的最具體信息，然後進行至少工作特定的地方最後，用逗號分隔不同的地方級別。你記錄地方信息的級別應該代表保存該地方重要記錄的政府或教堂的級別。<br /><br />例如，鹽湖城這樣的地方將被稱為\"Salt Lake City, Salt Lake, Utah, USA\"。<br /><br />讓我們來看看這個地方的每個部分。第一部分，\"Salt Lake City,\"事件發生的城市或鄉鎮。在一些國家，城市內可能有重要的城市或區域。在這種情況下，他們應該來到城市之前。下一部分，\"Salt Lake,\"是縣。\"Utah,\"是一个州，而\"USA\"就是这个国家。重要的是要注意每個地方，因為基因每個級別的政府都保存著邏輯記錄。<br /><br />如果某個地方的水平未知，你應該在逗號之間留一個空格。假設，在上面的例子中，你不知道鹽湖城的縣。你應該記錄下來：\"Salt Lake City, , Utah, USA\"。假設你只知道一個人出生在猶他州。您可以輸入如下信息：\", , Utah, USA\"。<br /><br />您可以使用<b>#pgv_lang[find_place]#</b>鏈接來幫助您查找數據庫中已存在的位置。";
$pgv_lang["edit_LATI_help"] = "~#factarray[LATI]#~<br /><br />通常不鼓励输入特定的纬度和经度坐标，因为它只允许从特定元素的视图进行映射访问。最好管理地理位置。 <br /><br />但是，输入纬度和经度确实可以更精确地控制标记。";
$pgv_lang["edit_LONG_help"] = "~#factarray[LONG]#~<br /><br />通常不鼓励输入特定的纬度和经度坐标，因为它只允许从特定元素的视图进行映射访问。最好管理地理位置。 <br /><br />但是，输入纬度和经度确实可以更精确地控制标记。";
$pgv_lang["edit_add_parent_help"] = "~添加新的母親或父親~<br /><br />通過此頁面，您可以向選定的人添加新的母親或父親。如果已知，請填寫新人的姓名和出生和去世信息。你不知道一些信息，請留空。<br /><br />要添加除生與死之外的其他事實，首先通過保存更改將新人添加到數據庫中。然后在更新的家庭页面或#pgv_lang[relatives]#选项卡中单击此人的姓名，以查看此人的#pgv_lang[indi_info]#页面。在#pgv_lang[indi_info]#页面中，您可以添加更多详细信息。";
$pgv_lang["edit_add_spouse_help"] = "~添加新的丈夫或妻子~<br /><br />通過此頁面，您可以向選定的人添加新的丈夫或妻子。如果已知，請填寫新人的姓名和出生和去世信息。你不知道一些信息留空。<br /><br />要添加除生與死之外的其他事實，首先通過保存更改將新人添加到數據庫中。然后在更新的家庭页面或#pgv_lang[relatives]#选项卡中单击此人的姓名，以查看此人的#pgv_lang[indi_info]#页面。在#pgv_lang[indi_info]#页面中，您可以添加更多详细信息。";
$pgv_lang["edit_death_help"] = "~#pgv_lang[death]#~<br /><br />这个区域允许你输入去世信息。首先输入去世的日期，以家谱的标淮日期格式（1 JAN 2004）。你可以点击在日历图标上帮助选择日期。然后输入该人去世的地方。您可以使用<b>#pgv_lang[find_place]#</b>链接选择数据库中已存在的位置。";
$pgv_lang["edit_birth_help"] = "~#pgv_lang[出生]#~<br /><br />这个区域允许您输入出生信息。首先输入出生日期为家谱的标淮日期格式（1 JAN 2004）。可以单击日历图标以获取帮助选择日期。然后输入人员出生的地方。您可以使用<b>#pgv_lang[find_place]#</b>链接选择数据库中已存在的位置。";
$pgv_lang["edit_sex_help"] = "~#pgv_lang[sex]#~<br /><br />从下拉列表中选择适当的性别。<b>未知</b>选项表示性别未知。";
$pgv_lang["edit_name_help"] = "~#pgv_lang[name]#~<br /><br />这是一个人姓名记录中最重要的字段。<br /><br />当填写其他字段时，该字段应自动填写，但提供的是您可以根据个人喜好编辑信息。<br /><br />此字段中的名称应根据GEDCOM 5.5.1标淮输入，姓氏包含正斜杠\"/\"。例如，名称\"John Robert Finlay Jr.\"应该像这样输入：\"John Robert /Finlay/ Jr.\"。";
$pgv_lang["edit_suffix_help"] = "~#pgv_lang[suffix]#~<br /><br />在这个可选字段中，你应该为人输入名称后缀。名称后缀的例子是\"Sr.\"，\"Jr.\"，和\"III\"。";
$pgv_lang["edit_surname_help"] = "~#pgv_lang[surname]#~<br /><br />在此字段中，您應該輸入該人的姓氏。例如，在名稱\"John Robert Finlay\"中輸入應該輸入的姓氏這裡是\"Finlay\"<br /><br />有多個姓氏的個人，在西班牙和葡萄牙很常見，應該用逗號分隔姓氏。這表明這個人將被列在每個姓名下面。例如，姓氏\"Cortes, Vega\"將列在<b>C</b>和<b>V</b>之下，而姓氏\"Cortes Vega\"只会在<b>C</b>下列出。";
$pgv_lang["edit_NICK_help"] = "~#factarray[NICK]#~<br /><br />在这个字段中你应该为这个人输入任何昵称。<br />这是一个可选字段。<br /><br />添加方法昵称：<ul><li>选择<b>修改名称</b>然后输入昵称并保存</li><li>选择<b>添加新名称</b>然后输入昵称和名称并保存</li><li>选择<b>编辑GEDCOM记录</b>以添加从属于[1&nbsp;NAME]记录的多个[2&nbsp;NICK]记录。</li></ul>";
$pgv_lang["edit_given_name_help"] = "~#pgv_lang[given_name]#~<br /><br />在此字段中，您应输入该人的给定名称。例如，在名称\"John Robert Finlay\"中，应该给出的名称应该是进入这里是\"John Robert\"。";
$pgv_lang["edit_NPFX_help"] = "~名称前缀~<br /><br />此可选字段允许您输入名称前缀，例如\"Dr.\"或\"Adm.\"";
$pgv_lang["edit_add_child_help"] = "~#pgv_lang[add_child]#~<br /><br />使用此頁面，您可以向選定的家庭添加新的孩子。填寫孩子的姓名以及出生和去世信息（如果已知）。你不知道一些信息留空。<br /><br />要添加除生與死之外的其他事實，首先通過保存更改將新孩子添加到數據庫中。然后在更新的系列页面或#pgv_lang[relatives]#选项卡中单击子项名称以查看子项的#pgv_lang[indi_info]#页面。從#pgv_lang[indi_info]#頁面，您可以添加更詳細的信息。";


$pgv_lang["review_changes_help"] = "~取消更改~<br /><br />此块将列出所有已在线更改的记录，但仍需要在数据库中进行审核和接受。";
$pgv_lang["quick_update_name_help"] = "~更新名称~<br /><br />使用\"更新名称\"字段更改您正在编辑的人的姓名。在\"给定姓名\"字段中输入该人的姓名或名字。在\"姓氏\"字段中输入人的姓氏或姓氏。例如，如果您要输入的名称是\"John Robert Finlay\"，那么您将在\"给定名称\"字段中输入\"John Robert\"，在\"姓氏\"字段中输入\"Finlay\" 。<br /><br />填写这些字段将<u>更改</u>该人的姓名;它不会添加新名称。<br /><br /><i>注意：你如果名字由于新婚而改变，则<u>不</u>使用此方法。而是使用选项在下面添加新的丈夫。</i>";
$pgv_lang["quick_update_fact_help"] = "~更新事实~<br /><br />使用\"更新事实\"字段添加新的事实信息或更改您正在编辑的记录的现有事实。首先从下拉列表中选择一个事实然后在家谱的标淮日期格式（1 JAN 2004）中输入该事实发生的日期。您可以单击日历图标以获取帮助选择日期。然后输入发生该事实的位置。您可以使用<b>#pgv_lang[find_place]#</b>链接以选择数据库中已存在的位置。<br /><br />与此表单上的所有其他字段一样，您的信息将替换已存在的字段或者它会根据需要创建新条目。";
$pgv_lang["quick_update_address_help"] = "~更新地址~<br /><br />使用\"更新地址\"字段更改您正在编辑的人的地址，电话号码或电子邮件地址。<br /><br />在此表单上的所有其他字段中，您的信息将替换已存在的字段，或者根据需要创建新条目。";
$pgv_lang["quick_update_spouse_help"] = "~添加新的丈夫或妻子~<br /><br />当您想要为您正在编辑的人添加新的丈夫或妻子时，请使用这些字段。在字段中输入新配偶的姓名和出生信息，然后根据婚姻信息输入他们结婚的日期。以家谱的标淮日期格式输入日期（1 JAN 2004）。您可以点击日历图标以获取帮助选择日期。您可以使用<b>#pgv_lang[find_place]]#</b>链接选择数据库中已存在的地方。<br /><br />这些字段只会添加<i>新</i>合作伙伴;他们不会更新信息要编辑已录制人员的信息，请关闭此窗口并在#pgv_lang[relatives]#选项卡中单击该人员的姓名。然后单击编辑个人菜单以编辑信息。";
$pgv_lang["quick_update_marriage_help"] = "~更新婚姻~<br /><br />如果你想记录新的婚姻，你可以使用这些字段和字段来添加新的丈夫或妻子。否则在这些字段中输入数据将改变有关该人的信息最后一次婚姻。以家谱的标淮日期格式输入日期（1 JAN 2004）。您可以点击日历图标以获取帮助选择日期。您可以使用<b>#pgv_lang[find_place]#</b>链接选择数据库中已存在的位置。";
$pgv_lang["quick_update_child_help"] = "~添加一个新的孩子~<br /><br />使用这些字段为这个人添加一个新的孩子。首先输入孩子的名字并选择性别。然后输入孩子出生的日期和地点。家谱的标淮日期格式的日期（1 JAN 2004）。您可以点击日历图标以获取帮助选择日期。您可以使用<b>#pgv_lang[find_place]#</b>链接选择一个地方已存在于数据库中。<br /><br />这些字段只会添加一个<u>新兴</u>子项。它们不会更新已记录的子项的信息。编辑某人的信息谁已经在数据库中，关闭此窗口并在#pgv_lang[relatives]#选项卡中单击该人的姓名。然后单击编辑个人菜单以编辑信息。";
$pgv_lang["index_top10_pageviews_help"] = "~最常见的条目块~<br /><br />此块将列出本网站访问者已查看的前10个人，家庭或来源。为了显示此块，网站管理员必须拥有启用了条目命中计数器。";
$pgv_lang["index_cookiepolicy_help"] = "~#pgv_lang[block_cookiepolicy]#~<br /><br />此块显示该站点的cookie策略。";
$pgv_lang["cookiepolicy_link_help"] = "~#pgv_lang[block_cookiepolicy_link]#~<br /><br />如果您想使用标淮文本，请将此字段留空。<br /><br />如果您希望使用标淮文本并提供链接到包含特定于您网站的Cookie政策的详细信息的文本文件或HTML页面，您可以在此处输入该网页的网址。<br /><br />例如，<b>http://foo.bar.com/policy/cookies.txt</b>可能指向纯文本文件，而<b>http://foo.bar.com/policy/cookies.htm</b>指向HTML格式页面和<b>http://foo.bar.com/policy/cookies.doc</b>指向Microsoft Word格式的文档。";
$pgv_lang["cookiepolicy_link_advice"] = "留空以使用标淮文本。<br />输入一个URL，例如<b>http://foo.bar.com/policy/cookies.txt</b>，指向特定于站点的策略页面。";
$pgv_lang["useradmin_user_default_tab_help"] = "~USER DEFAULT選項卡設置~<br /><br />此设置允许您指定用户访问#pgv_lang[indi_info]#页面时自动打开的选项卡。如果允許編輯他們的帳戶，用戶可以更改這個設置稍後。";
$pgv_lang["edituser_user_default_tab_help"] = "~USER DEFAULT選項卡設置~<br /><br />此设置允许您指定访问#pgv_lang[indi_info]#页面时自动打开的选项卡。";
$pgv_lang["reorder_children_help"] = "~#pgv_lang[reorder_children]#~<br /><br />孩子们按照他们出现在家庭记录中的顺序显示。孩子不会按出生日期自动分类，因为孩子的出生日期通常是不确定，但他们的出生顺序<u>是</u>已知。<br /><br />此选项将允许您更改家庭记录中的孩子的顺序。因为您可能想要排序孩子们按照他们的出生日期，有一个按钮可以按下来为你做这个。<br /><br />你也可以拖放任何信息框来改变孩子的顺序。当你移动将鼠标光标放在信息框上，其形状将变为一对双头交叉箭头。如果在移动鼠标光标前按住鼠标左键，信息框将在鼠标光标上下移动。列表。当信息框被移动时，其他框将腾出空间。当您释放鼠标左键时，信息盒子将在列表中占据新的位置。";
$pgv_lang["rss_feed_help"] = "~RSS飼料設置~<br /><br />網站中提供的ATOM/RSS提要允許任何人使用合適的飼料聚合器查看您網站歡迎頁面的內容，而無需訪問該網站。大多數聚合器都會彈出通知讓用戶知道被監控頁面上的內容何時發生變化。這實際上允許任何人監控您的網站，而無需定期訪問。<br /><br />Feed塊用於自定義鏈接到Feed，允許特定的Feed類型（大多數讀者可以處理大多數類型，因此通常可以保留默認值），以及您希望在Feed中使用的特定模塊。Feed的語言和使用的GEDCOM將基於選擇Feed時，語言和GEDCOM在網站中處於​​活動狀態。<br /><br />可生成的Feed類型包括ATOM，RSS 2.0，RSS 1.0，RSS 0.92，HTML和JavaScript。前四種類型是對於Feed聚合器，而JavaScript和HTML旨在實現包含其他網頁中的Feed。請注意，RSS提要的編號表示不同的樣式，而不是不同的版本。<br /><br />有一個選項可以選擇將用戶登錄的身份驗證，並允許用戶使用合適的RSS進行查看聚合器，登錄時通常可以查看的任何信息。基本身份驗證使用<i>基本HTTP身份驗證</i>來登錄用戶。未來的增強功能可能允許<i>摘要式身份驗證</i>。<br /><br />這個<a href='http://en.wikipedia.org/wiki/RSS_(file_format)' target='_blank' alt='Wikipedia文章' title='維基百科文章'><b>維基百科文章</b></a>包含有關RSS和各種RSS格式的全面信息和鏈接。<i>基本HTTP身份驗證</i>在<a href='http://en.wikipedia.org/wiki/Basic_authentication_scheme' target='_ blank' alt='維基百科文章' title='維基百科文章'中討論><b>維基百科文章</b></a>，而<i>摘要認證</i>中討論在<a http://en.wikipedia.org/wiki/Digest_access_authentication' target='_ blank' alt='維基百科文章' title='維基百科文章'><b>維基百科文章</b></a>。";


$pgv_lang["upload_media_folder_help"] = "~#pgv_lang[文件夹]#~<br /><br />您的GEDCOM配置最多允许#GLOBALS[MEDIA_DIRECTORY_LEVELS]#目录级别超出默认<b>#GLOBALS[MEDIA_DIRECTORY]#</b>所在的上传媒体通常存储文件。这使您可以组织媒体文件，而不必担心为每个媒体文件维护唯一的名称。<br /><br />在此字段中，您可以指定目标目录要存储上传的媒体文件的服务器。请务必注意您输入的内容（大写或小写）或在此处选择，因为文件和目录名称区分大小写。<br /><br />如果您在此处输入的目录名称不存在，则会自动创建。如果您输入的GEDCOM配置允许的其他#GLOBALS[MEDIA_DIRECTORY_LEVELS]#目录级别超过了您的输入，那么您的输入将被截断。<br /><br />缩略图将以相同的目录结构上传或创建，从<b>#G开始LOBALS[MEDIA_DIRECTORY]#thumbs/</b>。";
$pgv_lang["upload_media_file_help"] = "~#pgv_lang[media_file]#~<br /><br />在此字段中，您可以在本地計算機上指定要上傳到服務器的媒體文件的位置和名稱。您可以使用<b>瀏覽</b>按鈕，在本地計算機上搜索所需的文件。<br /><br />上傳的文件在服務器上將具有相同的名稱，並將上傳到<b中指定的目錄>#pgv_lang[folder]#</b>字段。<br /><br />如果您沒有看到<b>#pgv_lang[folder]#</b>字段或無法更改它，則表示您沒有足夠的權限或您的GEDCOM配置已設置為不允許超出默認<b>#GLOBALS[MEDIA_DIRECTORY]#</b>的目錄級別。在這種情況下，媒體文件將上傳到目錄<b>#GLOBALS[ MEDIA_DIRECTORY]#</b>。";
$pgv_lang["upload_thumbnail_file_help"] = "~#pgv_lang[thumbnail]#~<br /><br />在此字段中，您可以在本地計算機上指定要上傳到服務器的縮略圖文件的位置和名稱。您可以使用<b>瀏覽</b>按鈕在本地計算機上搜索所需的文件。填寫此字段後，將忽略<b>#pgv_lang[auto_thumbnail]#</b>複選框。<br /><br />如果已填寫<b>#pgv_lang[media_file]#</b>字段，則無論在本地計算機上調用的內容如何，​​都將根據該字段的內容命名上傳的縮略圖文件。為空，上傳的縮略圖文件將被複製到服務器上的兩個位置，一旦進入<b>#pgv_lang[folder]#</b>字段中提到的服務器目錄，然後再次進入相同的目錄結構，從<b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>。<br /><br />如果您沒有看到<b>#pgv_lang[folder]#</b>字段或無法更改它，沒有足夠的權限或您的GEDCOM配置已被設置為不允許超出默認<b>#GLOBALS[MEDIA_DIRECTORY]#</b>的目錄級別，其中通常存儲上載的媒體文件。";
//-- GENERAL
$pgv_lang["help_header"] = "相关信息：";
$pgv_lang["privacy_error_help"] = "~私人詳情~<br /><br />此消息可能有以下幾種原因：<br /><br /><ul><li><b>有關生活人士的信息設為\"私人\"</b><br />如果系统管理员允许，访问者可以通过单击“登录”按钮，然后单击#pgv_lang[requestaccount]#链接来注册帐户。<br /></li><li><b>您是擁有用戶名和密碼的用戶...</b><br />但您尚未成功登錄或者您已經登錄暫停了一段時間，你的會話超時了。<br /></li><li><b>由於隱私</b><br />此人根本不想顯示（隱藏）和可能已經要求管理員將他或她設置為\"私人\"。隱私可以設置為：<br /><ol><li>#pgv_lang[PRIV_USER]#</li><li>#pgv_lang[PRIV_NONE]#</li><li>#pgv_lang[PRIV_HIDE]#</li></ol></li><li><b>在关系路径之外</b><br />即使您是常规用户<u>和</u>已登录，如果您尝试查看的人在关系步骤数内与您无关，您仍会看到此消息（關係路徑長度）由本网站管理员为此GEDCOM设置。<br /><br />示例：<當關係路徑長度設置為<b>1</b>時，您只能看到您自己的家庭，父親，母親，兄弟，姐妹（但不是您兄弟或姐妹的配偶和子女）的詳細信息）當關係路徑設置為<b>2</b>時，您還可以查看您兄弟的妻子及其子女（但不是孩子的配偶）的詳細信息。<br /><br />關係路徑長度設置越高，您可以看到的遠程親屬越多。<br /></li></ul><br />如果您認為自己有資格查看某些隱藏的詳細信息，請聯繫網站管理員。使用任何頁面上的聯繫鏈接。";
$pgv_lang["more_help"] = "<br />每个屏幕都提供上下文帮助;请确保\"帮助\"菜单中的<b>#pgv_lang[show_context_help]#</b>选项已打开，然后单击<b>？</b>在主题旁边。";
$pgv_lang["more_config_help"] = "<br /><b>更多帮助</b><br />#pgv_lang[context_help]#";
$pgv_lang["start_admin_help"] = "+++ 启动其他管理员信息 +++";
$pgv_lang["end_admin_help"] = "---结束额外管理信息---";
$pgv_lang["multiple_help"] = "<span class='center'> ---这是多页的一般帮助文字--- </span>";
$pgv_lang["header_general_help"] = "<div class='name_head center'><b>一般信息</b></div>";
$pgv_lang["best_display_help"] = "~你的屏幕~<br /><br />网站的屏幕尺寸为1024x768像素。这应该是让所有东西都能正常显示的最小尺寸。<br /><br />如果你把尺寸设置为较低的值（例如800x600），您可能需要在某些页面上进行水平滚动。";
$pgv_lang["preview_help"] = "~打印~<br /><br />单击打印版本链接将删除打印页面上看起来不太好的条目（菜单，输入框，额外链接，上下文帮助的问号，在页面底部的打印机友好版本中，您将看到页面底部的<b>打印</b>链接。只需单击它，您的打印机对话框就会弹出打印后，只需单击<b>后退</b>链接，屏幕就会正常重建。<br /><br />注意：虽然\"打印机友好版本\"删除了许多链接显示页面，其余链接仍然可以点击。";
$pgv_lang["readme_help"] = "有关详情，请参阅<a href=\"readme.txt\" target=\"_blank\"><b>Readme.txt</b></a>。";
$pgv_lang["is_user_help"] = "---这个帮助文本与网站访问者将阅读的文本相同.---<br />---为了节省空间，我们没有为此条目制作特殊的管理文本.---";
$pgv_lang["edit_raw_gedcom_help"] = "~编辑RAW GEDCOM~<br /><br />当您点击此链接时，将打开一个新窗口，其中包含此页面上详细信息的原始GEDCOM数据。<br /><br />您可以在此编辑GEDCOM数据直接。请务必输入有效的GEDCOM 5.5.1数据，因为不会进行进一步的有效性检查。更改或添加的数据将在网站中显示为\"更改\"，并且必须由用户接受接受权利。";
$pgv_lang["RESN_help_title"] = "设定对事实的限制";
$pgv_lang["RESN_help"] = "~#pgv_lang[RESN_help_title]#~<br /><br />除了一般的隐私设置外，网站还可以为个人和家庭设置查看和编辑事实信息的限制。限制可以由任何人设置。允许编辑信息，除非隐私或以前设置的限制禁止这样做。<br /><br />可以使用以下值：<br /><ul><li><b>#pgv_lang[none]#</b><br />网站管理员，GEDCOM管理员和有权编辑的用户可以更改信息。可以根据管理员应用的隐私设置查看事实信息。</li><li><b>#pgv_lang[locked]#</b><br />此设置对事实数据的可见性没有影响。它限制了对网站管理员和GEDCOM管理员的编辑权限。如果该信息为用户所有，他也可以查看，如果他有编辑权限则可以进行编辑。</li><li><b>#pgv_lang[privacy]#</b><br />网站管理员和GEDCOM管理员可以查看和编辑信息。如果该信息为用户所有，他也可以查看，如果他具有编辑权限，则可以进行编辑。无论是否登录，它都将对其他用户隐藏。</li><li><b>#pgv_lang[confidential]#</b><br />只有网站管理员和GEDCOM管理员才能查看和编辑信息。无论是否登录，它都将对所有其他用户隐藏。</li></ul><br /><table><tr><th></th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">管理员</th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">所有者</th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">其他</th></tr><tr><th></th><th></th><th>R</th><th>W</th><th></th><th>R</th><th>W</th><th></th><th>R</th><th>W</th></tr><tr><td><img src=\"images/RESN_none.gif\" alt=\"\" />&nbsp;#pgv_lang[none]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_locked.gif\" alt=\"\" />&nbsp;#pgv_lang[locked]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /><th></th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_privacy.gif\" alt=\"\" />&nbsp;#pgv_lang[privacy]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_confidential.gif\" alt=\"\" />&nbsp;#pgv_lang[confidential]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr></table><ul><li>R : 可以查看</li><li>W : 可以编辑</li><li><img src=\"images/checked_qm.gif\" alt=\"\"/> : 取决于全球隐私设置</li></ul>";


//-- Pages Help-messages
//-- Index-page
$pgv_lang["index_help"] = "~欢迎页面~<br /><br />此页面是欢迎页面。欢迎您访问所选的<a href=\"#def_gedcom\">GEDCOM</a>文件。您可以返回此页面从顶部菜单中选择欢迎页面。如果此站点上有多个GEDCOM，您可以从下拉菜单中选择一个GEDCOM。<br /><br />此帮助页面包含以下信息：<ul><li><a href=\"#index_portal\"><b>欢迎页面</b></a></li><li><a href=\"#header\"><b>标题区</b></a></li><li><a href=\"#menu\"><b>菜单</b></a></li><li><a href=\"#header_general\"><b>一般信息</b></a></li><li><a href=\"#def\"><b>定义</b></a></li></ul>";

//-- Index-page Header
$pgv_lang["header_help"] = "<div class='name_head center'><b>HEADER AREA</b></div><br />标题显示在每个页面的顶部。标题包含一些有用的链接，您可以在整个页面中使用网站。<br /><br />由于此网站可能具有不同的外观，具体取决于所选的<a href=\"#def_theme\">主题</a>，标题可能会受到影响，链接可能会有所不同。<br /><br />您可能会找到的链接是：<ul><li><a href=\"#header_search\"><b>搜索框</b></a></li><li><a href=\"#header_lang_select\"><b>语言选择器</b></a> </li><li><a href=\"#header_user_links\"><b>用户链接</b></a></li><li><a href=\"#header_favorites\"><b>收藏夹</b></a></li><li><a href=\"#header_theme\"><b>更改主题</b></a></li></ul>";
$pgv_lang["header_search_help"] = "~标题区：搜索框~<br /><br />这个搜索框体积小但功能强大。您可以随时为网站搜索任何内容。当您点击<b>&gt;</b>或<b>搜索</b>按钮，您将链接到\"搜索\"页面以查看搜索结果。您可以在\"搜索\"页面上找到有关搜索选项的大量帮助。";
$pgv_lang["header_lang_select_help"] = "~标题区：语言选择器~<br /><br />网站最重要的功能之一是支持多种语言。<br /><br />网站显示所有页面的语言自动确定根据浏览器的\"首选语言\"设置。但是，站点管理员可能限制了某些语言的可用性。<br /><br />根据站点配置，您可以通过选择一个来更改网站的语言。更合适的语言来自下拉列表或单击标志图标。如果您是注册用户，您可以配置网站在您登录后切换到您的首选语言，无论您的浏览器设置为什么。";
$pgv_lang["header_user_links_help"] = "~标题区域：用户链接~<br />用户链接是一个小块，其中包含有用的链接，可以在每个页面的相同位置找到。这些链接的位置根据当前主题的不同而不同效果。<br /><br />未登录时，您只会看到<b>登录</b>链接。登录后，您会看到：<ul><li><b>已记录以（您的用户名）</b>。点击该链接将转到您的帐户页面。</li><li>点击<b>退出</b>退出。</li><li>如果您拥有管理员权限，您还会看到<b>管理员</b>。点击此链接可直接进入主管理页面。</li></ul>";
$pgv_lang["header_favorites_help"] = "~标题区：收藏夹~<br /><br />收藏夹下拉列表显示您在个性化门户页面上选择的收藏夹。它还显示了网站管理员为当前活动的GEDCOM选择的收藏夹点击其中一个收藏夹条目将直接转到该人的#pgv_lang[indi_info]#页面。<br /><br />有关添加收藏夹的更多帮助，请访问您的个性化门户页面。";
$pgv_lang["header_theme_help"] = "~标题区：更改主题~<br /><br />当网站管理员启用时，\"更改主题\"下拉列表会显示可用于查看网站的主题列表。<br /><br />您可以通过从下拉列表中选择一个主题来更改网站的外观。如果您已登录，它还会将您的用户主题更改为您选择的主题，以便您的下一次登录将自动选择相同的主题。";

//-- Index-page Menu
$pgv_lang["menu_help"] = "<div class='name_head center'><b>MENUS</b></div><br />页眉包含与每个菜单图标相关的下拉菜单。<br /><br />当你将鼠标指针移动到图标上，如果存在子菜单，则会出现子菜单。单击图标时，您将进入子菜单中的第一项。<br /><br />以下菜单图标通常可用：<ul><li><a href=\"#menu_fam\">#pgv_lang[welcome_page]#</a><br /></li><li><a href=\"#menu_myged\#>#pgv_lang[mygedview]#</a><br /></li><li><a href=\"#menu_charts\">#pgv_lang[charts]#</a><br /></li><li><a href=\"#menu_lists\">#pgv_lang[lists]#</a><br /></li><li><a href=\"#menu_annical\">#pgv_lang[anniversary_calendar]#</a><br /></li><li><a href=\"#menu_clip\">#pgv_lang[clippings_cart]#</a><br /></li><li><a href=\"#menu_search\">#pgv_lang[search]#</a><br /></li><li><a href=\"#menu_help\">#pgv_lang[page_help]#</a></li></ul>";
$pgv_lang["menu_famtree_help"] = "~欢迎页面菜单~<br /><br />此菜单中列出了所有本网站的可用家谱数据库。每个数据库都有自己的自定义欢迎页面，如下所示。如果此站点只有一个数据库，欢迎页面图标下没有子菜单。";
$pgv_lang["menu_myged_help"] = "~#pgv_lang[mygedview]#menu~<br /><br />如果您已登录，此菜单可包含以下条目：<ol><li>#pgv_lang[mygedview]#<br />这需要您可以自定义起始页面。</li><li>#pgv_lang[editowndata]#<br />您可以在此处编辑您的个人数据。</li><li>#pgv_lang[my_pedigree]#<br />如果您为此GEDCOM选择了一个Root人员，则会转到该人的谱系图表。</li><li>#pgv_lang[my_indi]#<br />此链接将带您到#pgv_lang[indi_info]#頁面，显示有关您自己和家人的所有家谱数据。</li></ol>";
$pgv_lang["menu_charts_help"] = "~图表菜单~<br /><br />可用的图表是：<ol><li><a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a><br />这会将你链接到这个GEDCOM文件的谱系图表。谱系将从管理员配置的人开始。当你登录时，起始人可以是你配置的任何人您的帐户首选项。</li><li><a href=\"?help=help_descendancy.php\"><b>#pgv_lang[descend_chart]#</b></a><br />Descendancy图表本质上是一个<a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>的相反顺序。这种比较并不完全正确，但在谱系时图表显示了起始人的所有祖先，后裔图表显示了起始人的所有后代。</li><li><a href=\"?help=help_timeline.php\"><b>#pgv_lang[timeline_chart]#</b></a><br />在这里你可以看到一个人沿着时间线的事件。比较两个或更多人的事件是很有趣的。同一时间线。</li><li><a href=\"?help=help_relationship.php\"><b>#pgv_lang[relationship_chart]#</b></a><br />在这里可以检查一个人与你自己或另一个人的关系。</li><li><a href=\"?help=help_ancestry.php\"><b>#pgv_lang[ancestry_chart]#</b></a><br />此图表与<a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>非常相似，但有更多显示详细信息和备用<a href=\"?help=chart_style_help\"><b>#pgv_lang[chart_style]#</b></a>。</li><li><a href=\"？help = help_fanchart.php\"><b>#pgv_lang[fan_chart]#</b></a><br />此图表与<a href=\"?help=help_pedigree.php\">非常相似<b>#pgv_lang[index_header]#</b></a>，但是以更加图形化的方式。</li></ol>";
$pgv_lang["menu_lists_help"] = "~列表菜单~<br /><br />以下列表可用：<ol><li><a href=\"?help=help_indilist.php\"><b>#pgv_lang[individual_list]#</b></a></li><li><a href=\"?help=help_famlist.php\"><b>#pgv_lang[family_list]#</b></a><br />在这两个列表中，您可以浏览此GEDCOM中按字母顺序排列的个人或家庭列表。</li><li><a href=\"?help=help_sourcelist.php\"><b>#pgv_lang[source_list]#</b></a><br />此条目返回GEDCOM中使用的所有来源的列表。</li><li><a href=\"?help=help_placelist.php\"><b>#pgv_lang[place_list]#</b></a><br />在这里，您可以按地方查找人员。将返回两列列表。个人列在左侧，家庭在右侧。</li><li><a href=\"?help=help_medialist.php\"><b>#pgv_lang[media_list]#</b></a><br />只有在启用时才能看到此菜单项网站管理员。这将显示此GEDCOM中所有多媒体文件的链接。</li></ol>";
$pgv_lang["menu_annical_help"] = "~#pgv_lang[周年纪念_日历]#菜单~<br /><br />#pgv_lang[anniversary_calendar]#显示GEDCOM中给定日期，月份或年份的事件。<ol><li><a href=\"？help = day_month_help\"><b>#pgv_lang[viewday]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewmonth]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewyear]#</b></a><br />这些菜单项将带您进入#pgv_lang[anniversary_calendar]#以显示当前日期，月份或年份的所有事件的列表。</li></ol>" ;
$pgv_lang["menu_clip_help"] = "~#pgv_lang[clippings_cart]#菜单~<br /><br />仅当管理员启用此功能时，您才会在菜单栏中看到此条目。<br /><br />#pgv_lang[clip_cart]#允许您将个人，家庭和来源的信息存储在临时文件中，以后可以用GEDCOM 5.5.1格式下载。";
$pgv_lang["menu_search_help"] = "~搜索菜单~<br /><br />搜索页面是一个功能更强大的搜索框，可以在每个页面标题中找到。";
$pgv_lang["menu_help_help"] = "~帮助菜单~<br /><br />#pgv_lang[help_help_items]#";

//-- Index-page Portal
$pgv_lang["index_portal_head_help"] = "<div class='name_head center'><b>欢迎页面</b></div>";
$pgv_lang["index_portal_help"] = "欢迎页面由几个单独的块组成，可以自定义。在具有多个系谱数据库的站点上，您可能会看到每个系列的不同欢迎页面。根据管理员如何自定义站点，您可能会看到任何一个欢迎页面上的以下块：<ul><li><a href=\"#index_welcome\"><b>欢迎</b></a></li><li><a href=\"#index_login\"><b>登录</b></a> </li><li><a href=\"#index_events\"><b>即将举办的活动</b></a></li><li><a href=\"#index_onthisday\"><b>历史记录中的这一天</b></a> </li><li><a href=\"#index_charts\"><b>图表</b></a></li><li><a href=\"#index_favorites\"><b>GEDCOM收藏夹</b></a></li><li><a href=\"#index_stats\"><b>GEDCOM统计</b></a></li><li><a href=\"#index_common_surnames\"><b>最常见的姓氏</b></a></li><li><a href=\"#index_media\"><b>随机媒体</b></a></li><li><a href=\"#index_loggedin\"><b>登录用户</b></a></li><li><a href=\"#gedcom_news\"><b>GEDCOM新闻</b></a></li><li><a href=\"#recent_changes\"><b>最近的变化</b></a></li></ul>";
$pgv_lang["index_welcome_help"] = "~歡迎阻止~<br /><br />歡迎程序段顯示當前數據庫標題，日期和時間，如果由管理員啟用，則顯示命中計數器。<br /><br />命中計數器僅在歡迎塊和#pgv_lang[indi_info]#頁面中可用。計數器計算這些頁面的\"點擊數\"。這意味著它計算訪問這些頁面的次數。計數器不檢查訪問者的互聯網地址;每次從<u>任何</u>遠程位置訪問頁面都算作另一個击中。";
$pgv_lang["index_login_help"] = "~登录块~<br /><br />您几乎可以在此程序的每个页面上登录。您通常会在第一页上登录，因为您只能在登录时访问特权信息。<br /><br />您可以通过键入<b>用户名</b>和<b>密码</b>然后单击\"登录\"按钮进行登录。";
$pgv_lang["index_events_help"] = "~即将到来的事件块~<br /><br />这个块显示了在不久的将来即将发生的事件周年纪念。<br /><br />管理员确定块前面的距离。可以通过几个配置选项进一步细化块的即将发生的事件的显示。<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["todo_help"] = "~&quot;要做&quot;块~<br /><br />這個塊可以幫助你跟踪數據庫中的<b>_TODO</b>任務。<br /><br />加&quot;待办事项&quot;对于您的记录的任务，您可能首先需要修改GEDCOM配置，以便<b>_TODO</b>事实在可以添加到个人，家庭，来源和存储库的记录中的事实列表中。您可以在GEDCOM配置的编辑选项部分找到的每个列表都是独立的。 列表条目的顺序并不重要; 您可以在每个列表的开头添加新条目。";
$pgv_lang["todo_show_other_help"] = "显示\"待办事项\"分配给其他用户的任务";
$pgv_lang["todo_show_unassigned_help"] = "显示\"待办事项\"未分配给任何用户的任务";
$pgv_lang["todo_show_future_help"] = "显示\"待办事宜\"具有未来日期的任务。否则，仅显示过去具有日期的条目。";
$pgv_lang["yahrzeit_help"] = 	"~YAHRZEITEN BLOCK~<br /><br />这个街区向你展示了在不久的将来出现的Yahrzeiten。<br /><br />Yahrzeiten（单数：Yahrzeit）是一个人去世的纪念日。这些纪念日是在犹太传统中观察到的;它们在其他传统中不再常用。 «Yahrzeit»也可以拼写为«Jahrzeit»或«Yartzeit»。<br /><br />管理员确定块前面的距离。即将推出的Yahrzeiten的块显示可以通过配置选项进一步完善。<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["days_to_show_help"] = "~#pgv_lang[days_to_show]#~<br /><br />输入要显示的天数。此数字不能大于<b>#DAYS_TO_SHOW_LIMIT#</b>。如果输入的值越大，将使用限制。<br /><br />显示的限制由管理员在GEDCOM配置，显示和布局部分，隐藏和显示子部分中设置。";
$pgv_lang["random_media_persons_or_all_help"] = "~#pgv_lang[random_media_persons_or_all]#~<br /><br />此选项可让您确定要显示的媒体类型。<br /><br />当您选择<b>#pgv_lang[random_media_persons]#</b>，只显示与人相关的媒体。通常，这将是一个人的照片。当你选择<b>#pgv_lang[random_media_events]#</b>时，只会显示与事实或事件相关的媒体。这可能是证书的图像。当您选择<b>#pgv_lang[all]#</b>时，此块将显示所有类型的媒体。";
$pgv_lang["random_media_filter_help"] = "~#pgv_lang[filter]#~<br /><br />您可以根据媒体项的格式和类型限制允许随机媒体块显示的内容。当选中给定复选框时，随机媒体块允许显示该格式或类型的媒体条目。<br /><br />数据库中存在但不在这些复选框列表中的格式或类型代码被假定为已选中相应的复选框。例如，如果您的数据库包含格式为<b><i>pdf</i></b>的媒体对象，始终允许随机媒体块显示它们。同样，如果您的数据库包含<b><i>类型的媒体对象</i></b>，始终允许随机媒体块显示它们。";
$pgv_lang["basic_or_all_help"] = "~#pgv_lang[basic_or_all]#~<br /><br />这个选项可以让你消除一些过时的事件。例如，#factarray[DIV]#，#factarray[CREM]#，#factarray[GRAD]#，#factarray[BARM]#，#factarray[FCOM]#等都应该注明日期。<br /><br />当你选择<b>是</b>时，只有出生，去世和婚姻将是当您选择<b>否</b>时，将显示所有过时的事件。";
$pgv_lang["style_help"] = "~#pgv_lang[style]#~<br /><br />此選項控制信息的呈現方式。<br /><br />選擇<b>#pgv_lang[style1]#</b>，信息以文本形式顯示，類似於您在各種圖錶框中看到的信息。此格式非常適合在頁面右側打印的塊。<br /><br />选择<b>#pgv_lang[style2]#</b>时，信息以表格格式显示，更适合在页面左侧打印的较大块。";
$pgv_lang["sort_style_help"] = "~#pgv_lang[sort_style]#~<br /><br />此选项控制信息的排序方式。<br /><br />选择<b>#pgv_lang[by_alpha]#</b> ，信息按字母顺序显示。当您选择<b>#pgv_lang[by_anniv]#</b>时，信息按周年排序，最近的周年纪念日排在第一位。";
$pgv_lang["cal_dowload_help"] = "~#pgv_lang[cal_download]#~<br /><br />此选项控制下载日历事件的按钮是否显示给登录用户。下载的日历文件可以导入兼容的程序，如Microsoft Outlook例如，生成周年纪念日的自动电子邮件提醒。<br />当设置为<b>#pgv_lang[no]#</b>时，登录用户将无法下载日历文件。设置为<b>#pgv_lang[yes]#</b>，将显示\"下载\"按钮。当用户未登录时，此按钮不会显示。";
$pgv_lang["cal_download_user_help"] = "如果您已登录，则可能会看到图标<img src='images/ical.png' alt=''/>。如果单击该图标，则会将事件下载为日历文件，可以是导入到兼容的程序（如Microsoft Outlook）中，例如，生成周年纪念日的自动电子邮件提醒。<br /><br />如果您已登录但未看到此图标，则管理员已禁用此功能。未登录的访客将看不到此图标，也无法下载日历文件。";
$pgv_lang["index_charts_help"] = "~#pgv_lang[charts_block]#~<br /><br />此块允许在欢迎或MyGedView页面上显示谱系图，下降图或沙漏图。由于篇幅限制，图表应仅放在页面的左侧。<br /><br />当欢迎页面上显示此块时，管理员会确定要显示的根人员和图表类型。当此块出现在用户的个性化MyGedView上时页面，这些选项由用户决定。<br /><br />这些图表的行为与从菜单调用它们时的行为相同。点击一个人的框以查看有关它们的更多详细信息。";
$pgv_lang["index_onthisday_help"] = "~在这个历史街区的这一天~<br /><br />这个街区类似于\"即将发生的事件\"街区，除了它显示今天的活动。<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["index_favorites_help"] = "~GEDCOM最喜歡的塊~<br /><br />GEDCOM收藏夾塊與#pgv_lang[mygedview]#页面的\"我的收藏夾\"塊大致相同。与门户网站页面配置不同，只有管理员或具有管理员权限的用户才能更改此块中的收藏夹列表。<br /><br />GEDCOM收藏夾塊的目的是吸引訪問者註意特別感興趣的人。這個GEDCOM的最愛可供選擇從每個頁面標題的下拉列表中。<br /><br />當您點擊其中一個列出的網站收藏夾時，您將被帶到該人的#pgv_lang[indi_info]#頁面。";
$pgv_lang["index_add_favorites_help"] = "~添加一个最喜欢的颜色~<br /><br />这个表单允许你添加一个新的喜欢的条目到你的收藏夹列表。<br /><br />你必须输入一个人，家庭，您想要存储为收藏夹的源或源，或者您必须输入URL和标题。注释字段是可选的，可用于描述收藏夹。注释字段中输入的任何内容都将显示在条目后的收藏夹块中。";
$pgv_lang["index_stats_help"] = "~GEDCOM统计区块~<br /><br />在这个区块中，您将看到有关当前GEDCOM文件的一些统计信息。如果您需要的信息多于列出的信息，请向页面底部的联系人发送消息。";
$pgv_lang["index_common_names_help"] = "~十大姓氏~<br /><br />这个区块将列出最常出现的姓氏，每个姓氏都有一个计数。如果你点击一个名字，它会带你到个人名单，已经过滤了您点击的名称。<br /><br />管理员确定实际显示的名称数量。";
$pgv_lang["index_common_given_names_help"] = "~十大名字~<br /><br />这个区块将列出最常出现的给定名称。它在列中显示男性和女性名称。当有人没有性别时，将出现第三列已知。<br /><br />管理员确定实际显示的名称数量。";
$pgv_lang["index_media_help"] = "~随机图片块~<br /><br />在这个块中，网站会随机选择一个媒体文件，以便在每次访问此页面时向您显示。<br /><br />当您点击图片时，您将看到它的全尺寸版本。在图片下方你有一个指向与图片相关联的人的链接。当你点击图片标题时，你会看到#pgv_lang[media_list]#页面上的图片。当你点击这个人的名字，你将被带到那个人的#pgv_lang[indi_info]#页面。";
$pgv_lang["index_loggedin_help"] = "~登录用户块~<br /><br />此块将显示当前登录的用户。<br /><br />如果您不是管理员，则您对登录用户的查看受到限制对于那些选择在线时可见的人来说。为了实现这一点，你必须选择在线时可见。对你来说不可见的在线用户被视为匿名。";
$pgv_lang["index_gedcom_news_help"] = "~GEDCOM新闻块~<br /><br />新闻块就像这个GEDCOM的公告板。网站管理员可以在这里发布重要的公告或有趣的新闻消息。<br /><br />如果你有有趣的东西要显示，请联系网站管理员;他可以把你的消息放在这个公告板上。";
$pgv_lang["recent_changes_help"] = "~最近更换块~<br /><br />这个块显示了CHAN GEDCOM标签记录的GEDCOM的最新变化。";
$pgv_lang["gedcom_news_limit_help"] = "您可以限制显示的新闻文章的数量，从而降低GEDCOM新闻块的高度。<br /><br />此选项确定是否应该应用任何限制或限制是否应根据年龄文章或根据文章的数量。";
$pgv_lang["gedcom_news_flag_help"] = "在此处输入限制值。<br /><br />如果您选择根据年龄限制新闻文章显示，那么任何超过此处输入天数的文章都将被隐藏起来。如果您选择了限制新闻文章按编号显示，只显示按年龄排序的最近文章的指定数量。剩下的文章将被隐藏起来。<br /><br />这里输入的零将禁用限制，导致所有新闻文章都要展示。";
$pgv_lang["gedcom_news_archive_help"] = "为了减少新闻块的高度，管理员隐藏了一些文章。您可以通过单击<b>#pgv_lang[gedcom_news_archive]#</b>链接来显示这些隐藏的文章。";
$pgv_lang["index_htmlplus_help"] = "~#pgv_lang[htmlplus_block_name]#~<br /><br />這個塊允許管理員將信息添加到索引或門戶頁面。其目的类似于#pgv_lang[html_block_name]#，#pgv_lang[gedcom_news_block]#和#pgv_lang[gedcom_stats_block]块，但管理员可以更好地控制其外观。";
$pgv_lang["index_htmlplus_title_help"] = "~#factarray[TITL]#~<br /><br />此文本应为空白或非常简短。空白时，高级HTML块将在索引或门户页面上显示为普通块，就像HTML一样当有文本时，高级HTML块将像所有其他块一样显示，并包含一个块标题栏，其中包含您在此处输入的文本。";
$pgv_lang["index_htmlplus_template_help"] = "~#pgv_lang[htmlplus_block_templates]#~<br /><br />为了帮助您开始使用这个块，我们创建了几个标淮模板。当您选择其中一个模板时，文本区域将包含一个副本然后你可以改变以适应你网站的要求。";
$pgv_lang["index_htmlplus_content_help"] = "~#pgv_lang[htmlplus_block_content]#~<br /><br />与#pgv_lang[html_block_name]#，#pgv_lang[gedcom_news_block]#和＃pgv_lang[gedcom_stats_block]＃块不同，您可以完全控制块的外观。您可以使用HTML标记，该块使用当前活动主题中的CSS样式表。文本中可以包含對當前活動的譜係數據庫中的信息的引用。<br /><br />數據庫引用是通過在關聯的<b>&#35;</b>符號中包含關鍵字在文本中發出信號。例如，&#35;totalFamilies&#35;表示數據庫中的系列數。在某些情況下，您可能希望使用數據庫引用作為文本而不是其真實含義。為此，您需要將符號等效的<b>&#35;</b>符號替換為關鍵字。例如，如果您的文字包含<b>&amp;&#35;35;totalFamilies&amp;&#35;35;</b>，它將打印為<b>&#35;totalFamilies&#35;</b>而不是成为数据库参考。<br /><br />有关使用此块的完整示例，请检查blocks/目录中的&quot;#pgv_lang[gedcom_stats_block]#&quot;模板，它使用大多数样式的标记，包括语言和帮助文本链接。<br /><br /><b>#pgv_lang[htmlplus_block_keyword]#</b>模板包含一個完整的所有支持的關鍵字列表。";
$pgv_lang["index_htmlplus_compat_help"] = "~#pgv_lang[htmlplus_block_compat]#~<br /><br />启用与此版块的旧版本的兼容性。选中后，旧的和新的关键字都将被识别并采取行动。<br /><br />例如，文本<b>&#35;TOTAL_FAM&#35;</b>将被识别为等同于<b>&#35;totalFamilies&#35;</b>，<b>&#35;FIRST_DEATH_PLACE&#35;</b>到<b>&#35;firstDeathPlace&#35;</b>，<b>&#35;TOP10_BIGFAM&#35;</b>到<b>&#35;topTenLargestFamily&#35 ;</b>等<br /><br />除非绝对必要，否则不应使用兼容模式。";
$pgv_lang["index_htmlplus_gedcom_help"] = "~#pgv_lang[htmlplus_block_gedcom]#~<br /><br />选择关键字适用的数据库。<br /><br />您的网站支持多个数据库。关键字如<b>&#35;totalFamilies&#35;</b>只能引用一个数据库。您可以识别要为所有这些关键字查询的数据库。每个#pgv_lang[htmlplus_block_name]#块只能访问一个数据库。";
$pgv_lang["showUnknown_help"] = "~#pgv_lang[showUnknown]#~<br /><br />隐藏或显示未知性别人员的名字列表。<br /><br />#pgv_lang[block_givn_top10]#块总是隐藏当您的数据库中不存在该性别的人时，给定名称列表。此选项允许您隐藏未知性别的人员列表，即使您的数据库中有此类人员也是如此。";

//-- Index-Page Help
$pgv_lang["help_help"] = "当然，创建一个如此简单易用的程序是理想的，它根本不需要任何解释;它应该像读书一样简单。<br /><br />虽然网站是非常复杂，你不应该注意到你使用它;几乎所有东西都可以在没有解释的情况下使用。但是，由于我们可能有很多访问者和用户对使用计算机或互联网不是很有经验，我们在某些地方为您提供一些帮助。<br /><br />您可以在\"帮助\"菜单中找到以下条目：";
$pgv_lang["help_page_help"] = "<dl><dt><b>本页的帮助</b></dt><dd>对于所有页面都有一般的\"页面帮助\"。您可以点击菜单中的这个条目来获取\"页面帮助\"，在那里您将被告知该页面上的条目。<br /><br />页面帮助通常很简短。如果您需要更多关于页面上某个条目的帮助或信息而不是页面帮助提供您可以使用\"上下文帮助\"功能。</dd></dl>";
$pgv_lang["help_content_help"] = "<dl><dt><b>帮助内容</b></dt><dd>当您单击此菜单项时，您将看到一个帮助页面，其中显示主要帮助主题的索引。可用信息将随着时间的推移而增加。</dd></dl>";
$pgv_lang["help_faq_help"] = "<dl><dt><b>常见问题列表</b></dt><dd>#pgv_lang[text_faq_help]#</dd></dl>";
$pgv_lang["help_HS_help"] = "<dl><dt><b>#pgv_lang[hs_title]#</b></dt><dd>#pgv_lang[hs_intro]#</dd></dl的>";
$pgv_lang["help_qm_help"] = "<dl><dt><b>隐藏/显示上下文帮助</b></dt><dd>这最后一个菜单项可能对您最有用。点击此链接可以打开或关闭\"上下文帮助\"。<br /><br />打开上下文帮助后，您可能会在某些链接，下拉框或按钮旁边找到问号或类似图标。当您单击此图标时，帮助屏幕将会出现弹出。此帮助屏幕包含有关该对象的信息。<br /><br />当然，当您单击\"隐藏上下文帮助\"时，所有问号或图标将消失，直到您单击\"显示.. ..\"再次。</dd></dl>";

//-- Index-page Definitions
$pgv_lang["def_help"] = "<div class='name_head center'><b>#pgv_lang[definitions]#</b></div><br />以下是本帮助文本中使用的术语的一些解释：<ul><li><a href=\"#def_gedcom\"><b>GEDCOM</b></a><br /></li><li><a href=\"#def_gedcom_date\"><b>日期</b></a></li><li><a href=\"#def_pdf_format\"><b>PDF文件格式</b></a></li><li><a href=\"#def_pgv\"><b>网站</b></a></li><li><a href=\"#def_portal\"><b>门户网站</b></a></li><li><a href=\"#def_theme\"><b>主题</b></a></li></ul>";
$pgv_lang["def_portal_help"] = "~门户~<br /><br />这个网站的门户就像餐厅或公共图书馆的大厅。这是你进入的地方，但你也可以找到重要的信息，如解释，菜单等。";
$pgv_lang["def_gedcom_help"] = "~GEDCOM文件~<br /><br />GEDCOM 5.5.1標淮簡介：<div class=\"list_value_wrap\"> GEDCOM由耶穌基督教會家族史系開發後期聖徒教會（LDS教會）提供靈活，統一的格式來交換計算機化的家譜數據。GEDCOM是<i><b>GE</b></i>nealogical <i><b>D</b></i>ata <i><b>Com</b></i>munication的首字母缩写。（谱系数据通信）。其目的是促進家譜信息的共享和各種相互作用的發展。可操作的軟件產品，以協助系譜學家，歷史學家和其他研究人員。</div><br />GEDCOM 5.5.1草案规范的副本可以PDF格式下载，PhpGedView符合此标准：<a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\"> GEDCOM 5.5.1標淮</a>本標淮僅適用於英語。<br /><br />GEDCOM文件包含有關家庭的所有信息。所有事實，日期，事件，等等都存儲在這裡。GEDCOM文件必須遵循嚴格的規則，因為它們必須可以在許多程序之間行交換，而不依賴於平台或操作系統。";
$pgv_lang["def_gedcom_date_help"] = "~GEDCOM文件中的日期~<br /><br />虽然日期字段允许自由格式输入（意味着您可以输入任何您想要的内容），但是有一些关于如何根据日期输入日期的规则GEDCOM 5.5.1标淮。<ol><li>以DD MMM YYYY形式输入完整日期。例如，<b>01&nbsp;MAR&nbsp;1801</b>或<b>14&nbsp;DEC&nbsp;1950</b>。</li> <li>如果您错过了部分日期，则可以省略该部分。例如<b>MAR&nbsp;1801</b>或<b>14&nbsp;DEC</b>。</li><li>如果您不确定或未确认日期，您可以输入<b>ABT&nbsp;MAR&nbsp;1801</b>（abt = about），<b>BEF&nbsp;20&nbsp;DEC&nbsp;1950</b>（bef = before），<b>AFT&nbsp;1949</b>（aft = after）</li><li>日期范围输入为<b>FROM&nbsp;MAR&nbsp;1801&nbsp;TO&nbsp;20&nbsp;DEC&nbsp;1810</b>或作为<b>BET&nbsp;MAR&nbsp;1801&nbsp;AND&nbsp;20&nbsp;DEC&nbsp;1810</b>（赌注=之间）<br /><br /><b>FROM</b>表格表明所描述的事件在规定的日期和之间连续发生用于就业等事件。<b>BET</b>表单表示事件的单次出现，有时在所述日期之间，并与出生等事件一起使用。<br /><br />不精确的日期，月份的日期或月份缺失，始终被解释为第一个或最后一个可能的日期，具体取决于该不精确日期是在分离关键字之前还是之后。例如，<b>FEB&nbsp;1804</b>在TO或AND之前被解释为<b>01&nbsp;FEB&nbsp;1804</b>，并且<b>29&nbsp;FEB&nbsp;1804</b>当它发生在TO或AND之后。</li></ol><b>请务必在<u>英语</u>，</b>中输入日期和缩写，因为GEDCOM文件是可以交换的， 网站可以将所有日期和缩写正确翻译成当前活动的语言。此外，网站使用这些日期进行计算。如果在日期字段中输入了不正确的日期，网站将无法正确计算。<br /><br />您可以单击日历图标以获取帮助选择日期。";
$pgv_lang["def_gramps_help"] = "~GRAMPS XML数据库文件~<br /><br />GRAMPS条目引用：<div class=\"list_value_wrap\"> GRAMPS帮助您跟踪您的家谱。它允许您存储，编辑和研究谱系GRAMPS试图提供其他系谱程序的所有通用功能，但更重要的是，提供这些程序不常见的附加集成功能。这是能够将任何信息直接输入GRAMPS和重新排列/操纵整个数据库中的任何/所有数据事件（以任何顺序或顺序），以帮助用户进行研究，分析和与填补关系差距的潜力相关联。</div><br />GRAMPS XML格式v1.1.0 <a href=\"http://www.gramps-project.org/xml/1.1.0/\" target=\"_blank\">可在此处找到</a> RELAX NG Schema格式和DTD格式。<br /><br />有关GRAMPS条目的更多信息，请访问<a href=\"http://gramps-project.org/\" target=\"_ blank\"> ^ h TTP://gramps-project.org/</a>";
$pgv_lang["def_pgv_help"] = "~PhpGedView~<br /><br />网站（或PGV）不只是将静态页面放在Web上;它是动态的，可以通过多种方式进行自定义。<br /><br />网站创建于John Finlay将在线查看GEDCOM文件.John开始自己开发该程序。一个由开发人员和翻译人员组成的国际团队已经加入他并正在努力改进该计划。在该计划中增加或改进的更重要的功能之一它是对英语以外语言的广泛支持，以及在线添加和编辑事件的能力。";
$pgv_lang["def_theme_help"] = "~主题~<br /><br />这个网站可以有不同的\"外观\"，称为主题。<br /><br />网站管理员选择默认主题，进入该网站的每个人最初都会当管理员启用此功能时，所有用户都可以选择自己的主题.PepGedView会记住每个登录用户最后选择的主题，以便该用户下次登录时会自动看到该主题。主题可以是用作区分同一站点上不同数据库的方法。每个数据库都可以有不同的默认主题。";

//-- Index-page MyGEDCOM
$pgv_lang["mygedview_portal_help"] = "~#pgv_lang[mygedview]#~<br /><br />这是您的个人#pgv_lang[mgv]#页面。<br /><br />在这里您可以找到访问您的个人数据的简单链接，例如<b>我的帐户</b>，<b>我的Indi</b>（这是您的#pgv_lang[indi_info]#頁面）和<b>我的谱系</b>。您可以拥有<b的块>消息</b>，<b>期刊</b>（如记事本）等等。<br /><br />此页面的布局类似于您第一次看到的欢迎页面访问此站点。虽然站点管理员选择了欢迎页面的各个部分，但您可以选择要在此个性化页面中包含的部分。您可以在欢迎块中找到自定义此页面的链接，或者在欢迎块是不存在。<br /><br />您可以选择以下块：<ul><li><a href=\"#mygedview_welcome\"><b>欢迎</b></a></li><li><a href=\"#mygedview_customize\"><b>自定义MyGedView</b></a></li><li><a href=\"#mygedview_message\"><b>消息</b></a></li><li><a href=\"#mygedview_events\"><b>即将举行的活动</b></a></li><li><a href=\"#mygedview_onthisday\"><b>历史上的这一天</b></a></li><li><a href=\"#mygedview_charts\"><b>图表</b></a></li><li><a href=\"#mygedview_favorites\"><b>我的收藏</b></a></li><li><a href=\"#mygedview_stats\"><b>GEDCOM统计</b></a></li><li><a href=\"#mygedview_myjournal\"><b>我的日记</b></a></li><li><a href=\"#mygedview_media\"><b>随机媒体</b></a></li><li><a href=\"#mygedview_loggedin\"><b>登录用户</b></a></li><li><a href=\"#mygedview_recent_changes\"><b>最近的更改</b></a></li></ul>";
$pgv_lang["mygedview_customize_help"] = "~CUSTOMIZE#pgv_lang[mygedview]#~<br /><br />当你第一次进入这里时，你已经在这个页面上有了一些块。如果你愿意，你可以自定义这个Portal页面。<br /><br />当您单击此链接时，您将进入可以添加，移动或删除块的表单。该表单中提供了更多说明。";
$pgv_lang["mygedview_message_help"] = "~消息块~<br /><br />在此块中，您将找到其他用户或管理员发送给您的消息。您也可以向其他用户或管理员发送消息。<br /><br 网站邮件系统旨在帮助保护您的隐私。您不必在此处留下您的电子邮件地址，而其他人将无法看到您的电子邮件地址。<br /><br />要扩展邮件，单击邮件主题或旁边的\"<b>+</b>\"符号。您可以通过选中要删除的邮件旁边的框并单击<b>删除所选邮件来删除多封邮件</b>按钮。";
$pgv_lang["mygedview_favorites_help"] = "~我最喜欢的地方~<br /><br />收藏与书签类似。<br /><br />假设您在家谱中有人想要定期查看他们的记录。只要去找人#pgv_lang[indi_info]#頁面并从收藏夹下拉列表中选择<b>添加到我的收藏夹</b>选项。此人现在已经过书签并添加到收藏列表中。<br /><br />无论您在本网站的哪个位置，都可以点击标题中\"我的收藏夹\"下拉列表中的名称。这将带您进入该人的#pgv_lang[indi_info]#页面。";
$pgv_lang["mygedview_myjournal_help"] = "~我的期刊块~<br /><br />您可以使用此期刊编写笔记或提醒供您自己使用。当您做出这样的笔记时，它会在您下次访问该网站时仍然存在。<这些说明是私人的，其他人不会看到。";
$pgv_lang["mygedview_welcome_help"] = "~欢迎阻止~<br /><br />欢迎屏幕显示：<ul><li>当前的GEDCOM文件</li><li>日期和时间</li><li>链接到：<ul> <LI>#pgv_lang[myuserdata]#</li><li>#pgv_lang[my_pedigree]#</li><li>#pgv_lang[my_indi]#</li><li>#pgv_lang[customize_page]#</li></ul></li></ul><br /><b>注意：</b><br />您将看到指向<b>My Indi</b>的链接<b>我的谱系</b>只有当前GEDCOM文件已知时。您可能在一个GEDCOM文件中有记录，因此可以看到<b>My Indi</b>和<b>My Pedigree</b>链接，而在另一个GEDCOM文件中，您没有记录，因此不会显示这些链接。";

//-- Pedigree-page
$pgv_lang["help_pedigree.php"] = "~谱系页面~<br /><br />系谱是起始人的所有祖先的枚举。未登录的用户可以看到网站管理员选择的起始（根）人的血统。在用户可以选择自己的起始（根）人。<br /><br />在这种情况下，\"所有祖先\"是指父亲和母亲，他们的父母等。谱系以图形方式显示;你不必费力地通过文本页面确定你的祖先。<br /><br />所有人都显示在屏幕上的名称框中。<br /><ul><li><b>名称框上谱系</b><br />如果谱系页面设置为显示详细信息，您将看到该人的姓名以及出生和去世日期。您可以点击一个人的姓名直接带您到#pgv_lang[indi_info]#该页面的页面。<br /><br />当<b>显示详细信息</b>打开时，名称框中有两个图标。</li><li><b>名称中的谱系图标框</b><br />选项<b>显示详细信息</b>是o n，您在名称框中看到一个谱系图标。根据站点设置，您必须将鼠标悬停在图标上或单击它。当您单击或将鼠标悬停在该图标上时，会出现一个小子菜单。<br /><br />条目<b>#pgv_lang[index_header]#</b>和<b>#pgv_lang[descend_chart]#</b>类似于主菜单中的那些条目，但区别在于起始人现在是名称框中提到的个人。您还会看到<b>#pgv_lang[as_spouse]#</b>。在下面你会看到配偶的名字，后面跟着孩子的名字。所有名称都是可点击的。</li><li><b>名称框内的放大镜</b><br />根据网站设置，您必须将鼠标悬停在图标上或单击它。这会放大\"名称\"框，以便显示更多详细信息。您将看到更多日期和活动。名称是可点击的。</li><li><b>箭头</b><br />在最左侧或最右侧的名称框的左侧或右侧，您可能会看到箭头。当您单击这些箭头时，屏幕显示将按箭头方向移动。</li></ul><br />#pgv_lang[context_help]#";
$pgv_lang["show_full_help"] = "~隐藏或显示详细信息~<br /><br />使用此选项，您可以在名称框中显示或隐藏所有详细信息。隐藏详细信息时，您可以在一个屏幕上显示更多框。<br /><br />隐藏所有细节后，不显示下面描述的缩放图标。但是，如果管理员启用了缩放功能，整个框将像缩放图标一样显示有关此人的完整详细信息。<br /><br />如果未隐藏细节并且管理员已启用放大镜图标标识的缩放功能，则可以显示有关该人员的更多详细信息。如果您通常必须单击缩放图标以放大，您可以通过点击此图标显示其他隐藏的详细信息。同样，如果您可以通过将鼠标悬停在缩放图标上放大，隐藏的详细信息将通过将鼠标悬停在该图标上来显示。<br /><br />如果您已单击\"缩放\"图标以显示更多详细信息，您可以通过单击将该框恢复为其正常的详细程度再次进入缩放图标。如果您通过简单地将鼠标指针移动到缩放图标上来显示更多细节，则当您将鼠标指针移离缩放图标时，该框将恢复到正常的细节级别。";
$pgv_lang["talloffset_help"] = "~页面布局~<br /><br />使用此选项可以确定页面布局方向。<br /><br />如果要进行丝网印刷或者如果要进行丝网印刷，则更改此设置可能很有用不同类型的屏幕。<ul><li><b>#pgv_lang[portrait]#</b>模式将使树更高，这样4代图表应该适合垂直打印的单页。</li><li><b>#pgv_lang[landscape]#</b>模式将生成一个更宽的树，可以在水平打印的单页上打印。</li><li><b>#pgv_lang[landscape_top]#</b>模式将图表（而不是其框）逆时针旋转90度，以便最老的一代位于图表的顶部。</li> <li><b>#pgv_lang[landscape_down]#</b>模式将图表（而不是其框）顺时针旋转90度，以便最老的一代位于图表的底部。</li></ul>";
$pgv_lang["rootid_help"] = "~新根人~<br /><br />如果你想显示一个新的起始（根）人的图表，那么在这里输入新起始人的ID。<br /><br />如果你不知道那个人的身份证，请使用<b>查找身份证</b>链接。<br /><br /><b>身份证号码</b><br />里面使用的身份证号码网站不是<u>不是</u>各政府颁发的身份证号码（例如驾驶证或护照号码）。这里提到的身份证号码只是数据库中用来唯一识别每个人的号码;它是由创建GEDCOM文件的祖先程序分配，该文件已导入网站。";
$pgv_lang["PEDIGREE_GENERATIONS_help"] = "~生成数量~<br /><br />在这里，您可以设置在此页面上显示的世代数。<br /><br />正确的数字取决于您的屏幕大小以及是否你是否显示细节。随着你增加世代数，处理时间会增加。";

//-- LOGIN-page
$pgv_lang["login_page_help"] = "~登录页面~<br /><br />在此页面上，您可以登录，申请新密码或申请新的用户帐户。";
$pgv_lang["username_help"] = "~用户名~<br /><br />在此框中键入您的用户名。<br /><br /><b>用户名区分大小写。</b>这意味着<b>MyName</b><u>不</u>与<b>myname</b>或<b>MYNAME</b>相同。";
$pgv_lang["password_help"] = "~密码~<br /><br />在此框中输入您的密码。<br /><br /><b>密码区分大小写。</b>这意味着<b>MyPassword</b><u>不</u>与<b>mypassword</b>或<b>MYPASSWORD</b>相同。";
$pgv_lang["login_buttons_help"] = "~登录按钮~<br /><br />在这里您可以看到两个登录系统的按钮。<br /><br />您将被带到或发回的页面取决于您点击后的哪个按钮输入您的用户名和密码。<br /><ul><li><b>#pgv_lang[登录]#</b>按钮<br />如果您单击此按钮，您将返回到您所在的页面只是，但具有登录访问权限。<br /><br />例如，当您在谱系页面时单击<b>#pgv_lang[登录]#</b>，您将返回如果您在主欢迎页面上单击此按钮，您将进入#pgv_lang[mygedview]#页面。</li><li><b>#pgv_lang[admin]#</b>按钮<br />如果您有管理员权限，可以单击此按钮直接进入主管理页面。</li></ul>";
$pgv_lang["login_buttons_aut_help"] = "~认证模式登录按钮~<br /><br />在这里您可以看到两个登录系统的按钮。<br /><br />您将被带到的页面取决于您在键入后单击的按钮用户名和密码。<br /><ul><li><b>#pgv_lang[登录]#</b>按钮<br />如果单击此按钮，您将登录并直接进入#pgv_lang[mygedview]#页面，您可以在其中编辑设置，添加或编辑收藏，发送和阅读邮件等。</li><li><b>#pgv_lang[admin]#</b>按钮<如果您有管理员权限，可以单击此按钮直接进入主管理页面。</li></ul>";
$pgv_lang["new_password_help"] = "~请求新密码~<br /><br />如果您忘记了密码，可以点击此链接申请新密码。<br /><br />您将被带到\"忘记密码\"请求\"页面。";
$pgv_lang["new_user_help"] = "~请求新用户帐户~<br /><br />如果您是本网站的访问者并希望申请用户帐户，您可以点击此链接。<br /><br />您将被带到\"注册\"页面。";
$pgv_lang["mygedview_login_help"] = "为了访问#pgv_lang[mygedview]#页面，您必须是系统上的注册用户。在#pgv_lang[mygedview]#页面上，您可以为喜爱的人添加书签，保留用户日记，管理消息，查看其他登录用户，并自定义网站页面的各个方面。<br /><br />在相应字段中输入您的用户名和密码以登录#pgv_lang[mgv]#。";
$pgv_lang["new_user_firstname_help"] = "~#pgv_lang[firstname]#~<br /><br />在这个框中你必须输入你的名字。<br /><br />我们需要你的名字和姓氏，以确定你是否有资格获得此站点的帐户，以及您的权利。这些名称将对其他已登录的家庭成员和用户可见。";
$pgv_lang["new_user_lastname_help"] = "~#pgv_lang[lastname]#~<br /><br />在这个框中你必须输入你的姓氏。<br /><br />我们需要你的名字和姓氏，以确定你是否有资格获得此站点的帐户，以及您的权利。这些名称将对其他已登录的家庭成员和用户可见。";
$pgv_lang["register_info_01"] = "~请求新的用户帐户~<br /><br />由于适用的隐私保护法律，可以在本网站上公开查看的数据量可能会受到限制。许多人不希望他们的个人数据公开在互联网。个人数据可能被滥用于垃圾邮件或身份盗用。<br /><br />每个拥有用户帐户的访问者都可以访问此网站。管理员验证并批淮您的帐户申请后，您将成为能够登录。<br /><br />如果已激活关系隐私，您将只能在登录后访问您自己的近亲的私人信息。管理员还可以允许某些用户进行数据库编辑，这样他们就可以可以更改或添加信息。<br /><br />如果您需要任何进一步的支持，请使用以下链接与管理员联系。";
$pgv_lang["register_info_02"] = "~请求新的用户帐户~<br /><br />由于适用的隐私保护法律，可以在本网站上公开查看的数据量可能会受到限制。许多人不希望他们的个人数据公开在互联网。个人数据可能被滥用于垃圾邮件或身份盗用。<br /><br />仅允许<u>授权的</u>用户访问此网站。管理员验证并批淮您的帐户申请后，您将能够登录并查看私人数据。<br /><br />如果已激活关系隐私，您将只能在登录后访问您自己的近亲的私人信息。管理员还可以允许数据库为某些用户编辑，以便他们可以更改或添加信息。<br /><br />如果您需要任何进一步的支持，请使用以下链接与管理员联系。";
$pgv_lang["register_info_03"] = "~请求新的用户帐户~<br /><br />由于适用的隐私保护法律，可以在本网站公开查看的数据量可能会受到限制。许多人不希望他们的个人数据公开在互联网。个人数据可能被滥用于垃圾邮件或身份盗用。<br /><br />仅允许<u>家庭成员访问此网站</u>。管理员验证并批淮您的帐户申请后，您将能够登录并查看私人数据。<br /><br />如果已激活关系隐私，您将只能在登录后访问您自己的近亲的私人信息。管理员还可以允许数据库为某些用户编辑，以便他们可以更改或添加信息。<br /><br />如果您需要任何进一步的支持，请使用以下链接与管理员联系。";


//-- Descendancy-page
$pgv_lang["help_descendancy.php"] = "~DESCENDANCY页面~<br /><br />此页面将显示一个人的后代。<br /><br />您可以为此Descendancy图表选择一个起始（根）人员，或者您可以链接通过单击另一页上的<b>#pgv_lang[descend_chart]#</b>链接到此页面。单击箭头图标以箭头方向导航此树。单击任何人员框中的图表图标以更改树的根到那个人。";
$pgv_lang["desc_rootid_help"] = "#pgv_lang[rootid_help]#";
$pgv_lang["desc_generations_help"] = "#pgv_lang[PEDIGREE_GENERATIONS_help]#";

//-- Time line-page
$pgv_lang["help_lifespan.php"] = "~生活图表~<br /><br />在此图表上，您可以沿水平时间线显示一个或多个人。此图表可让您了解不同人的生活是如何重迭的。<br /><br />您可以单独或按家庭组的ID将人员添加到图表中。当您向图表中添加更多人员时，将记住上一个列表。您可以随时使用<b>清除图表</b>清除图表按钮。<br /><br />您还可以通过按日期范围或地点搜索人员来添加人员。";
$pgv_lang["lifespan_add_person_help"] = "#pgv_lang[add_person_help]#~包含即时家庭复选框~<br /><br />默认情况下选中包括直系亲属。请选中此选项以查看被添加到的个人的父亲，母亲，配偶，兄弟姐妹和子女时间表。如果你想省略直系亲属，请取消选中。";
$pgv_lang["help_timeline.php"] = "~时间表图表~<br /><br />在此图表上，您可以在时间轴上显示一个或多个人。例如，您可以在某个时刻可视化两个或更多人的状态。<br /><br />如果您点击其他页面上的<b>时间线</b>链接，您将在时间线上看到一个人。如果您点击了<b>时间线</b>菜单项页眉，你必须提供起始人的身份证。";
$pgv_lang["add_person_help"] = "~添加人员到图表~<br /><br />您可以在时间线上安排几个人。<br /><br />使用此框提供每个人的身份证。如果您不知道身份证对于此人，您可以单击该框旁边的<b>查找ID</b>链接。";
$pgv_lang["remove_person_help"] = "~从图表中删除人员~<br /><br />点击此链接可以从时间线中删除此人。";
$pgv_lang["show_age_marker_help"] = "~显示年龄标记~<br /><br />如果选中此框，您将看到年龄标记。<br /><br />您可以沿时间线向上或向下滑动此年龄标记。滑动年龄标记是检查某个人在某个事件中的年龄的好工具。您可以为图表中的每个人单独启用或禁用年龄标记。";
$pgv_lang["timeline_control_help"] = "~控制生命图表~<br /><br />~快速~<br /><br />点击下拉菜单更改时间轴滚动的速度。<br /><br />~开始年份~<br /><br />输入范围的起始年份。<br /><br />~结束年份~<br /><br />输入范围的结束年份。<br /><br />~搜索~<br /><br />单击\"搜索\"按钮开始搜索在\"开始年份\"和\"结束年度\"字段标识的范围内发生的事件。";

//-- Relationship-page
$pgv_lang["help_relationship.php"] = "~关系页面~<br /><br />在这个页面上你可以显示任何两个人之间的关系。这些人不必直接与血系相关;任何关系都会被找到。";
$pgv_lang["relationship_id_help"] = "~人1和人2的ID~<br /><br />如果您点击<b>与我的关系</b>链接从另一个页面跳到此页面，您将看到这里的关系你和其他人之间的关系。<br /><br />如果你通过任何页眉上的<b>关系图</b>菜单项到达此页面，你必须输入两个人的标识号你希望看到谁的关系。如果你不知道所需人的标识符，你可以点击<b>查找ID</b>链接。";
$pgv_lang["next_path_help"] = "~找到下一个路径~<br /><br />您可以单击此按钮查看两个人之间是否存在另一个关系路径。通过单击带路径编号的链接，可以再次显示以前找到的路径。";
$pgv_lang["follow_spouse_help"] = "~通过婚姻检查关系 - 检查框~<br /><br />选中此复选框<b>联系</b>后，只检查血缘关系之间的关系。选中此复选框后，通过婚姻关系也检查了。你可能会通过选中此框来找到更多关系。";
$pgv_lang["line_up_generations_help"] = "~排队生成 - 检查框~<br /><br />选中此复选框后，图表将打印在页面上水平排列的相同代数。如果未选中，则每一代都将显示无论关系类型如何，都在页面下方。";
$pgv_lang["oldest_top_help"] = "~显示最旧的顶部 - 检查框~<br /><br />选中此复选框后，图表将打印出顶部最老的人。未选中时，最年轻的人将出现在顶部。<注意：此选项仅在<b>#pgv_lang[line_up_generations]#</b>也被选中的情况下有效。";

//-- Ancestry-page
$pgv_lang["help_ancestry.php"] = "~#pgv_lang[ancestry_chart]#页面~<br /><br />祖先页面非常类似于<a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a非常相似>，但有更多詳細信息和替代<a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a>顯示。<br /><br />每個祖先都顯示一個唯一的編號，根據<i>Sosa-Stradonitz</i>系統計算：<div style=\"padding-left: 30px;\"><b>偶數</b>男性數字（孩子* 2）</><b>奇數</b>女性（丈夫+ 1）的數字除<b>1</b></div><br />示例：<br /><div style=\"padding-left: 30px;\">根人不論性別<b>1</b>。<br /><b>1</b>的父親<b>2</b>（<b>1</b> * 2），母親<b>3</b>（<b>2</b> + 1）。<br /><b>2</b>的父親是<b>4</b>（<b>2</b> * 2），母親<b>5</b>（<b>4</b> + 1）。<br /><b>3</b>的父親<b>6</b>（<b>3</b> * 2），母親<b>7</b>（<b>6</b> + 1）。<br /><b>7</b>的父親<b>14</b>（<b>7</b> * 2），母親<b>15</b>（<b> 14</b> + 1）。<br />等。</div>";
$pgv_lang["box_width_help"] = "~#pgv_lang[ancestry_chart]#盒子宽度~<br /><br />在这里你可以将盒子宽度从50%改为300%。在100%时，每个盒子的宽度约为270像素。";
$pgv_lang["chart_style_help"] = "~#pgv_lang[chart_style]#~<br /><br />有两种图表样式可供选择：<ul><li><b>#pgv_lang[chart_list]#</b><br />垂直树，带可折迭/可扩展的家庭。</li><li><b>#pgv_lang[chart_booklet]#</b><br />每页一个家庭，包括父母，祖父母和所有有记录的孩子。<br /><br这种格式很容易打印给你的亲戚。</li></ul>";

//-- Fan chart-page
$pgv_lang["help_fanchart.php"] = "~#pgv_lang[fan_chart]#页面~<br /><br />圆形图非常类似于<a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>，但是以更加图形化的方式。<br /><br />Root人员显示在中心，他的父母在第一个环上，祖父母在第二个环上，等等。<br /><br />已知的生日和去世年份以名称印刷。<br /><br />点击图表上的名称将打开特定于该人的链接菜单。从此菜单中，您可以选择将图表置于中心位置那个人或那个人的近亲之一，或者你可以跳到那个人的#pgv_lang[indi_info]#页面或那个人的不同图表。";
$pgv_lang["fan_width_help"] = "~#pgv_lang[fan_chart]#宽度~<br /><br />在这里，您可以将图表宽度从50%更改为300%。在100%时，输出图像的宽度约为640像素。";
$pgv_lang["fan_style_help"] = "~#pgv_lang[fan_chart]#样式~<br /><br />此选项控制图表的外观。<ul><li><b>1/2</b><br />半圈180&deg;图</li><li><b>3/4</b><br />四分之二270&deg;图表，有时称为<i>天使之翼</i></li><li><b>4/4</b><br />全圆360&deg;图</li></ul>";

//-- Hourglass chart-page
$pgv_lang["help_hourglass.php"] = "~#pgv_lang[hourglass_chart]#~<br /><br />沙漏图表将在同一图表上显示所选根人的祖先和后代。此图表是Descendancy图表和谱系图表之间的混合。<br /><br />根人居中在页面中间，他的后代列在左边，他的祖先在右边列出。在这个视图中，每一代都排在整个页面的最前面生成并以最新结束。<br /><br />如果根人员屏幕下方有一个向下箭头，点击它将显示一个根人员的亲密家庭成员列表，您可以使用向下导航从该列表中选择一个名称将重新加载图表，并将所选人员作为新的根人员。";

//-- Family Book chart-page
$pgv_lang["help_familybook.php"] = "~#pgv_lang[familybook_chart]#~<br /><br />此图表与沙漏图非常相似。它将在同一图表上显示所选根人的祖先和后代。它还将显示后代同一个沙漏格式的根人。<br /><br />根人居中在页面中间，他的后代列在左边，他的祖先列在右边。在这个视图中，每一代从最早的一代开始，以最新一代结束，整个页面排成一行。<br /><br />根人的每个后代将成为另一个沙漏图表的根人，打印在同一页面上。重复，直到打印出指定数量的后代。";
$pgv_lang["fambook_descent_help"] = "~#pgv_lang[descent_steps]#~<br /><br />此值确定将以沙漏格式打印的根人的后代代数。";

//-- Indilist-page
$pgv_lang["help_indilist.php"] = "~个人名单~<br /><br />在此页面上，您可以显示个人名单。名称将首先显示姓氏，并按字母顺序排序。<br /><br />输出名称列表取决于：<ol> <li>您在按字母顺序索引中单击的字母。</li><li>您是否单击了\"跳过\"或\"显示\"姓氏列表。</li></ol>#pgv_lang[context_help]#";
$pgv_lang["alpha_help"] = "~字母索引~<br /><br />單擊按字母順序索引中的字母將顯示以您單擊的字母開頭的名稱列表。<br /><br />第二項到最後一項按字母順序排列的索引可以是<b>#pgv_lang[NN]#</b>。當數據庫中有人沒有記錄姓氏或者不包含任何可識別的字母時，此條目將出現。未知的姓氏通常記錄為<b>？</b>，這些將被識別為<b>#pgv_lang[NN]#</b>。如果此人不明，也會發生這種情況。<br /><br /><b>注意：</b><br />輸入姓氏，例如，<b>Nn</b>，<b>NN</b>，<b>Unknown/b>，甚至<b>N.N.</b>将<u>不</u>在<b>#pgv_lang[NN]#</b>列表中找到。相反，您可以通过单击<b>N</b>或<b>U</b>找到这些人，因为这些是这些名称的首字母。PhpGedView不可能解释输入未知姓氏的所有可能方式; 没有公认的惯例。<br /><br />在按字母顺序排列的索引末尾，您会看到<b>所有</b>。當您單擊此條目時，您將看到數據庫中所有姓氏的列表。<br /><br /><b>缺字母？</b><br />如果您的字母索引似乎不完整，如果缺少字母，您的數據庫中不會包含以缺少字母開頭的任何姓氏。";
$pgv_lang["name_list_help"] = "~姓名列表~<br /><br />此框将显示姓氏列表或完整姓名列表。在这两种情况下，所有姓氏都将以您在按字母顺序排列的索引中单击的首字母开头，除非您单击<b>全部</b>。<br /><br />您是否会看到姓氏列表或完整的名单取决于<b>跳过/显示姓氏列表</b>链接的状态。";
$pgv_lang["skip_sublist_help"] = "~跳过子列表~<br /><br />标淮设置是，在您点击字母索引的字母后，您将获得一个带有姓氏的子列表。如果您点击此链接，所有姓氏的人当前选择的首字母将立即显示。此后，每当您点击按字母顺序列表中的新首字母时，将直接显示个人列表。<br /><br />要撤消此操作，请单击#pgv_lang[show_surnames]#链接。";
$pgv_lang["show_marnms_help"] = "~包括/排除已结婚的名字~<br /><br />个人和家庭列表页面可以包含或排除已婚姓名。在搜索您只知道已婚姓名的个人或家庭时，此选项会很有用。如果名称已存在于数据库中，则只能包含这些名称。<br /><br />在族列表中，此值默认为排除。在单个列表中，默认值在GEDCOM配置页面中设置。<br /><br />当您更改此选项时，您的选择将被记住，直到您注销或会话结束。";

//-- Families-page
$pgv_lang["help_famlist.php"] = "~家庭列表页面~<br /><br />在此页面上，您可以显示家庭列表。姓名将首先显示姓氏，并按字母顺序排序。<br /><br />输出名称列表取决于：<ol><li>您在按字母顺序索引中单击的字母。</li><li>您是否单击了\"跳过\"或\"显示\"姓氏列表。</li></ol>您可以搜索丈夫或妻子的姓氏;两者都包括在列表中。<br /><br />#pgv_lang[context_help]#";
$pgv_lang["help_family.php"] = "~家庭詳情頁面~<br /><br />此頁面將向您顯示您在上一頁選擇的家庭概況。<br /><br />從上到下您將看到個人詳細信息丈夫和他的父母，妻子和父母以及孩子們的盒子。<br /><br />人員盒子的佈局和內容與您從譜系和後裔頁面中已經知道的盒子相同。<br /><br />在父框的右側，如果文件中存在更多祖先，您可能會看到一個箭頭。當您單擊該箭頭時，您將向上移動一代，以顯示一個新的族頁面。以前的父母現在被列為丈夫和妻子。<br /><br />在名稱框的右側，您可以看到一個縮放（放大鏡）圖標，您可以單擊該圖標以顯示有關個人的更多詳細信息。點擊你將被帶到該人的#pgv_lang[indi_info]#頁面的名稱。<br /><br />在右侧，您会看到一个小菜单，可以将您带到包含图表或更多信息的页面。其中一些菜單項也有子菜單，當您的鼠標指針接近父菜單項時會現這些子菜單。<br /><br />家庭組信息框顯示有關此家庭的所有已知事實和信息，例如婚姻，多媒體對象和筆記。在事實信息框中，單擊某個地點將轉到地點列表，其中顯示連接到該地點的所有其他家庭和個人。單擊日期將跳轉到日曆日曆，該日曆將顯示歷史記錄中當天和月份發生的所有事件。可以點擊多媒體對象;這將打開一個用於查看對象的新窗口。當您單擊圖片標題時，您將在#pgv_lang[media_list]#頁面上看到圖片。如果單擊源鏈接，該源的詳細信息將顯示在源頁面上。<br /><br />在子項的名稱框下方，您會找到<b>將子項添加到此族中</b>鏈接。在孩子的名稱框旁邊，您會看到<b>家庭群組信息</b>鏈接。如果您有足夠的權限，可以在此處編輯，刪除和添加數據和事實。<br /><br />與#pgv_lang[indi_info]#頁面一樣，您將看到頁面右上角的菜單。此菜中的條目會將您帶到其他頁面，您可以在其中獲取有關此系列的信息或執行與此系列相關的其他任務。#pgv_lang[more_help]#";
$pgv_lang["add_child_help"] = "~给这个家庭加上孩子~<br /><br />点击此链接即可为这个家庭添加孩子。<br /><br />添加孩子很简单：只需点击链接，填写弹出屏幕中的方框，就是这些。";
$pgv_lang["show_fam_gedcom_help"] = "~显示GEDCOM记录~<br /><br />单击此链接时，将显示有关该系列的信息，因为它存储在数据库中。显示屏将显示原始GEDCOM数据。";
$pgv_lang["add_fam_clip_help"] = "~添加家庭到剪报篮子~<br /><br />您可以将全部或部分家庭信息添加到#pgv_lang[clip_cart]#。在下一页，您可以精确选择要添加的信息量：<ol><li>#pgv_lang[just_family]#</li><li>#pgv_lang[parents_and_family]#</li><li>#pgv_lang[parents_and_child]#</li><li>#pgv_lang[parents_desc]#</li></ol>";
$pgv_lang["show_fam_timeline_help"] = "~显示时间表上的偶像~<br /><br />当您单击此链接时，您将跳转到时间轴页面，其中所有事实将在时间线范围内显示。";

//-- Source list-page
$pgv_lang["help_sourcelist.php"] = "~來源列表頁面~<br /><br />此頁面上顯示了一系列來源。<br /><br />与#pgv_lang[indi_info]#和系列页面不同，没有按字母顺序排列的索引。<br /><br />來源可以是個人，公共數據庫，機構，互聯網資源等。由於家譜來源的完全隨機性，因此無法找到有意義的排序順序。所有情況。但是，網站將源名稱按字母順序排序。<br /><br /><b>來源</b><br />沒有來源我們無法構建我們的數據庫。數據庫中的每個信息項都有一個來源。來源可以是親戚，機構，公共數據庫，政府或私人記錄，互聯網資源等。<br /><br />來源可以是與許多人有聯繫。一個人也可以鏈接到許多來源。每個事件都可以有不同的來源，無論是出生日期，職業，婚姻，子女等。";
$pgv_lang["sourcelist_listbox_help"] = "~来源列表框~<br /><br />在此框中，您可以看到存储在GEDCOM中的来源名称。<br /><br />名称按字母顺序显示。单击列表中的名称，您将转到显示列表的\"源\"页面。此列表显示哪些个人或家庭链接到该源。";

//-- Sources-page
$pgv_lang["help_source.php"] = "~來源詳情頁面~<br /><br />來源的詳細信息顯示在此頁面上。來源對於家譜研究人員非常重要，並且可以讓您跟踪另一位研究人員用來查找信息的踪跡。<br /><br />您可以看到有關源的標題，作者，出版物以及查找源的存儲庫的信息。由於有許多不同類型的源，某些源可能比其他源有更多信息。<br /><br />如果文檔掃描等多媒體對象連接到源，則可以通過單擊對象來查看該對象。单击对象名称时，您将在#pgv_lang[media_list]#页面上看到它。<br /><br />根據源詳細信息，列出了連接到此源的所有個人和家庭。這使您可以識別從該數據源獲得的所有條目。<br /><br />當管理員啟用這些功能時，您將有一個或兩個額外的m此頁面上的enu圖標：<ol><li><b>#pgv_lang[view_gedcom]#</b><br />以GEDCOM格式顯示信息。</li><li><b>#pgv_lang[add_to_cart]#</b><br />這使可以將此信息存儲在#pgv_lang[clip_cart]#中，以便以後下載並導入您自己的家譜程序。</li></ol><br />#pgv_lang[context_help]#";
$pgv_lang["sources_listbox_help"] = "~记录链接到此源~<br /><br />在此框中，您可以看到与源连接的个人和家庭的名称。<br /><br />名称按字母顺序显示。当您单击列表中的名称时，您将转到相关的详细信息页面。";
$pgv_lang["show_source_gedcom_help"] = "~显示GEDCOM记录~<br /><br />当您单击此链接时，源的记录将以原始数据库格式显示。";
$pgv_lang["add_source_clip_help"] = "~添加来源到CLIPPINGS CART~<br /><br />点击此链接后，您可以将源信息添加到#pgv_lang[clip_cart]#中，以便以后下载并导入您自己的家谱程序。";
$pgv_lang["delete_source_help"] = "~从GEDCOM删除源~<br /><br />当您单击此选项时，您将标记此源将从数据库中删除。<br /><br />这是什么意思？<br />假设您有充分的理由从数据库中删除此源。您单击该链接。系统将要求您确认删除请求。如果您决定继续，可能需要一些时间才能看到消息来源删除。<br /><br />当您继续访问时，您会注意到源仍然可见，并且可以像没有发生删除一样使用。<br /><br /><b>这是<u>不</u>错误。</b>站点管理员将收到一条消息，表明已对数据库进行了更改，并且您已删除了源。<br />管理员可以接受或拒绝您的更改。只有在管理员接受您的更改后，才会实际删除<u>不可逆转</u>。如果对您的更改有任何疑问，管理员将与您联系。";

//-- Persons per Place-page
$pgv_lang["help_placelist.php"] = "~地点等级制度~<br /><br />（或每个人的人数）<br /><br />此页面将显示GEDCOM中各个地点的层次结构以及哪些个人或家庭连接到某个位置。<br /><br />如果个人或家庭与某个地点的活动之间存在任何联系，网站会找到它。<br /><br />结果显示在两栏列表中，一栏为个人，一栏为家庭。<br /><br />#pgv_lang[more_help]#";
$pgv_lang["ppp_default_form_help"] = "~位置订单格式~<br /><br /><b>默认订单</b><br />这意味着此GEDCOM文件中没有声明地点编码格式，并且假设采用默认格式。如果找到了另一种格式，它将显示在该行末尾的<b>（</b>和<b>）</b>之间。";
$pgv_lang["ppp_match_one_help"] = "~位置订单格式~<br /><br />GEDCOM订单<br />假定位置以GEDCOM文件中明确声明的位置格式编码。这取代了默认顺序。";
$pgv_lang["ppp_numfound_help"] = "~找到地点连接~<br /><br />此处显示的匹配数量。如果您仍然看到一个列表框，其中包含您尚未达到最低级别的位置。<br /><br />您可以选择查看连接到此地点的所有记录，也可以通过单击其他位置来优化搜索。";
$pgv_lang["ppp_levels_help"] = "~位置等级~<br /><br />这显示了现在显示的等级。显示地点的列表框实际上是最左边一级的子列表。<br /><br />示例：<br />默认顺序为#pgv_lang[default_form]#。<br />如果当前级别为\"顶级\"，则该框将列出数据库中的所有国家/地区。<br />如果当前级别为\" ，顶级\"，该框将列出美国所有州等<br /><br />您可以点击一个级别返回一个或多个步骤。";
$pgv_lang["ppp_placelist_help"] = "~地点等级制度~<br /><br />在此列表中，您可以看到从您选择的当前位置所属的位置。如果您尚未选择某个位置，您将看到所有位置的列表顶级位置（例如国家或州）。<br /><br />列表中位置的名称是可点击的;单击某个位置就像过滤器一样，您将进入下一级别。";
$pgv_lang["ppp_placelist_help2"] = "~PLACE LIST~<br /><br />在此列表中，您可以看到在此阶段找到的位置。<br /><br />列表中位置的名称是可点击的;单击一个位置就像一个过滤器，你将被提升到一个新的水平。<br /><br />只有当你在顶层时才会显示一个名单。在所有下级你会得到一个列表连接到该地点的家庭和个人。";
$pgv_lang["ppp_view_records_help"] = "~查看所有记录~<br /><br />点击此链接将显示所有在此地点发生事件的个人和家庭的列表。当您到达地点层次结束时，通常是城镇或城市，名单将自动显示。";
$pgv_lang["ppp_name_list_help"] = "~姓名列表~<br /><br />此框将显示连接到该位置的个人和家庭的完整列表。<br /><br />列表中的名称是可点击的。单击时一个名称，您将进入相关的详细信息页面。当您单击此列表顶部的位置时，您将更改您的位置选择。";

//-- Multimedia-page
$pgv_lang["help_medialist.php"] = "~多媒​​体对象列表~<br /><br />此页面列出了可在此数据库中找到的所有多媒体对象（MMO）。<br /><br />对于您看到的每个媒体条目条目的标题或文件名，与条目相关的个人或家庭的名称，以及有关条目的注释。<br /><br />单击条目的标题或文件名与单击其缩略图具有相同的效果。条目将在网站内置的图像浏览器中或浏览器配置中指定的查看器中打开。<br /><br />当您点击此人或家人旁边的\"查看\"链接时，您将成为进入相关的详细信息页面。";

//-- Upload Media-page
$pgv_lang["help_uploadmedia.php"] = "~上传媒体文件~<br /><br />上传媒体文件非常简单。这里有一些额外的信息。<br /><br /><b>缩略图</b><br />缩略图应该大小约为100px宽度。缩略图<u>必须</u>与全尺寸版本相同。如果您的系统可以自动生成缩略图，您将在\"上传媒体\"页面上看到相应的通知。<br /><br /><b>上传</b><br />文件将自动上传到<b>#GLOBALS[MEDIA_DIRECTORY]#</b>目录中的全尺寸版本，并且<b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>用于缩略图。<br /><br />#pgv_lang[readme_help]#";

//-- Anniversaries-page
$pgv_lang["help_calendar.php"] = "~#pgv_lang[anniversary_calendar]#~<br /><br /><ul><li><a href=\"#calendar_general\"><b>一般信息</b></a></li><li><a href=\"#calendar_day\"><b>#pgv_lang[day]#</b></a></li><li><a href=\"#calendar_month\"><b>#pgv_lang[月]#</b></a></li><li><a href=\"#calendar_year\"><b>#pgv_lang[year]#</b></a></li><li><a href=\"#calendar_show\"><b>#pgv_lang[show]#/#pgv_lang[showcal]#</b></a></li><li><a href=\"#calendar_sex\"><b>#pgv_lang[sex]#</b></a></li><li><a href=\"#calendar_event\"><b>活動</b></a></li><li><a href=\"#calendar_button\"><b>查看日/查看月/查看年份按鈕</b></a></li><li><a href=\"#calendar_tip\"><b>提示</b></a></li></ul><br /><a name=\"calendar_general\"></a>#pgv_lang[anniversary_calendar]#顯示在特定日期或某個時間段或某段時間內與某個事件相關聯的人員和家庭。它具有一個高級過濾系統，用於選擇正確的日期，期間和適合您的活動。<dl><dt><b>查看<a href=\"#calendar_day\">日</a></b></dt><dd> T他在某一天顯示事件，與所選年份無關。輸出將是包含個人或家庭名稱的單個列表，或者是一側包含個體而另一側包含家庭的兩列列表。</dd><dt><b>查看<a href=\"#calendar_month\">月</a></b></dt><dd>在此日曆中，個人和家庭的名稱顯示在日期框內。日曆顯示為您在年份框中輸入的年份。顯示過去一年中發生的所有事件。<br /><br />結合選項<a href=\"#calendar_show\"><b>#pgv_lang[recent_events]#</b></a>，它將為您的祖先的日曆顯示一個真實的視圖。</dd><dt><b>查看<a href=\"#calendar_year\">年</a></b></dt><dd>顯示某年或某些年份的事件。輸出將是一個包含個人或家庭名稱的列表，或者一列中包含個人而另一側包含家庭的兩列列表。</dd></dl>當前顯示的日期和月份在日曆菜單中突出顯示。<br /><br />所有名稱和日期都是可點擊的。單擊名稱後，您將進入相關的\"詳細信息\"頁面。點擊日期將跳轉到\"今天\"或\"年\"模式，這將顯示點擊日期中日期和月份的所有事件。<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_day\"></a>#pgv_lang[annivers_date_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_month\"></a>#pgv_lang[annivers_month_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_year\"></a>#pgv_lang[annivers_year_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_show\"></a>#pgv_lang[annivers_show_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_sex\"></a>#pgv_lang[annivers_sex_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_event\"></a>#pgv_lang[annivers_event_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_button\"></a>#pgv_lang[day_month_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\" calendar_tip\"></a>#pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"] = "~日选择器~<br /><br />选择器表的第一行是<b>天</b>选择器。它的意思很明顯：你選擇<u>天</u>。<br /><br />點擊某一天的結果取決於您是在<b>日</b>還是在<b>月</b>模式。<br /><dl><dt><b>日模式</b></dt><dd>在此模式下，您點擊一天，屏幕將刷新，並顯示當天的列表。</dd><dt><b>月份模式</b></dt><dd>您在屏幕上顯示某個月的日曆。这样做的原因是，在您单击<b>#pgv_lang[viewday]#</b>或<b>#pgv_lang[viewmonth]#</b>按钮之前，您仍然可以决定选择其他月份，年份或事件。<br /><br />在一天結束時，您將看到帶有今天日期的<b>快速鏈接</b>。点击<b>快速链接</b>将在<b>日</b>模式下显示今天的列表，无论您是在<b>月</b>还是在<b>日</b>模式。</dd></dl>";
$pgv_lang["annivers_month_select_help"] = "~月选择器~<br /><br />選擇器表的中間行是<b>月</b>選擇器。它的含義很明顯：你選擇<u>月</u>。<br /><br />點擊某個月的結果取決於您是在<b>日</b>還是在<b>月</b>模式。<br /><dl><dt><b>日模式</b></dt><dd>在此模式下，您點擊一個月，屏幕將刷新，並顯示該月的列表。所有其他選項，如日，年和事件將保持不變。</dd><dt><b>月份模式</b></dt><dd>當您在屏幕上顯示日曆並點擊<b>月中的一個月</b>行，將顯示該新月的日曆。<br /><br />在月末行中，您將看到<b>快速鏈接</b>與今天的月份和年份。點擊<b>快速鏈接</b>將在<b>月</b>模式下顯示該月的列表，無論您是在<b>月</b>還是在<b>日</b>模式</dd></dl>";
$pgv_lang["annivers_year_select_help"] = "~年份輸入框~<br /><br />此輸入框可讓您更改日曆的年份。在框中鍵入年份，然後按<b>输入</b>將日曆更改為該年份。<br /><br /><b>高級功能</b><b>#pgv_lang[viewyear]#</b><dl><dt><b>超過一年</b></dt><dd>您可以搜索多年的日期。<br /><br />年份範圍<u>包含</u>。這意味著日期範圍從第一年的1月1日開始截至去年12月31日的範圍。以下是一些年範圍的例子：1992年至1995年所有事件的年份範圍：<br /><br /><b>1992-5</b>。<br /><b>1972-89</b>適用於1972年至1989年的所有活動。<br /><b>1610-759</b>適用於所有1610至1759年的活動。<br /><b>1880-1905年</b>從1880年到1905年的所有活動。<br /><b>880-1105</b>所有活動從880到1105.<br /><br />要查看所有活動給定十年或一世紀，您可以使用<b>?</b>代替最終數字。例如，对于从1970年到1979年的所有事件，<b>197?</b>，对于从1600到1699的所有事件，<b>16??</b>。<br /><br />選擇一個年份範圍會將日曆更改為年視圖。</dd></dl>";
$pgv_lang["annivers_show_help"] = "~显示的事件......~<br /><br />以下选项可供选择：<br /><ol><li><b>所有人</b><br />使用此选项，显示所有个人和家庭。</li><li><b>近年（<100岁）</b><br />使用此选项，您将看到所选日期或月份的所有事件，但不会将显示超过100年的事件。</li><li><b>活着的人</b><br />除非管理员已配置网站以便任何人都可以看到活着的人，否则此选项将仅可用登录后给你。<br /><br />使用此选项，只显示活人的事件。</li></ol>当您点击选项时，您选择的事件将显示。<br /><br />日，月和年的设置，以及<b>日</b>或<b>月</b>模式，保持不变。";
$pgv_lang["annivers_sex_help"] = "~GENDER SELECTOR~<br /><br />当您登录或管理员未启用隐私选项时，您可以选择以下选项之一：<ol><li><b>全部</b> icon<br />这是默认选项。显示所有个人和家庭的事件。</li><li><b>男性</b>图标<br />仅显示男性个人的事件。只有男性家庭成员才会参加家庭活动。</li><li><b>女性</b>图标<br />仅显示女性个人的活动。只有女性家庭成员将与家人一起展示事件。</li></ol>当您点击某个选项时，将显示您选择的事件。<br /><br />日，月和年的设置，以及<b>日</b>或<b>月</b>模式，保持原样。";
$pgv_lang["annivers_event_help"] = "~事件选择器~<br /><br />在这里，您可以选择是否要显示个人和家庭的所有活动或仅选择一个活动。您不能选择多个活动类别。<br /><br />点击选项，将显示您选择的事件。<br /><br />日，月和年的设置，以及<b>日</b>或<b>月</b>模式，保持原样。";
$pgv_lang["annivers_tip_help"] = "~提示~<br /><br />将日期选择器调整到过去的任何日期。<br /><br />当您单击其中一个视图按钮时，您将看到该日期的列表或日历所有的年龄，纪念日等都已经重新计算，现在从你在日期选择器中设置的日期开始计算。你现在看到你的祖先在几年前的那个日期会看到的日历或列表。";
$pgv_lang["day_month_help"] = "~查看日/查看月份/查看年份按鈕~<br /><br /><ul><li><b>查看日</b>按鈕將在列表中顯示所選日期的事件。掃描年份，因此只能在此處設置日期和月份。更改年份將無效。您可以通過選擇<b>近年</b>或<b>生活人員</b選項來減少列表> 。<br /><br />列表中的年齡將從當前年份計算。</li><li><b>查看月份</b>按鈕將顯示所選月份的日曆圖表您也可以通過選擇<b>近年</b>或<b>活著的人</b>來減少列表。<br /><br />您將獲得一個真實的印象您祖先的牆上的日曆看起來就像過去選擇一年並結合<b>近年</b>。日曆上的所有年齡都顯示相對於年份框中的年份。</li><li><b>查看年份</b>按鈕將顯示所選年份的事件列表。您也可以通過選擇減少列表選項<b>近年</b>或<b>活著的人</b>。<br /><br />您可以展示多年的活動。只需鍵入範圍的開始和結束年份，並在它們之間用短劃線<b>-</b>。例如：<br /><b>1992-4</b> 1992年至1994年的所有活動<br /><b>1976-1984</b> 1976年至1984年的所有活動<br /><br要查看給定十年或一個世紀內的所有事件，您可以使用<b>?</b>代替最終數字。例如，對於從1970年到1979年的所有事件，<b>197?</b>，對於從1600到1699的所有事件，<b>16??</b>。</li></ul>當你想要<b>更改年份</b>您按下這三個按鈕之一。所有其他設置保持不變。";

//-- Clippings Cart-page
$pgv_lang["help_clippings.php"] = "~家庭树剪裁卡~<br /><br />#pgv_lang[clip_cart]#允许你从这个家谱中提取（\"剪报\"）并将它们捆绑到一个文件中进行下载和随后导入你自己的家谱程序。可下载的文件以GEDCOM格式记录。<br /><ul><li>如何剪报？<br />这很简单。每当你看到一个可点击的名字（个人，您可以转到该名称的详细信息页面。在那里您将看到<b>#pgv_lang[add_to_cart]#</b>选项。当您单击该链接时，您将获得几个下载选项。</li><li>如何下载？<br />购物车中有物品后，只需点击<b>立即下载</b>链接即可下载。按照说明和链接进行操作。</li></ul>";
$pgv_lang["clip_download_help"] = "~下载剪辑~<br /><br />当您点击此链接时，您将进入下一页。如果购物车中的任何剪报涉及多媒体条目，这些条目也将显示在该页面上。<br /><br />只需按照说明操作。";
$pgv_lang["empty_cart_help"] = "~清空剪裁卡~<br /><br />当您点击此链接时，您的#pgv_lang[clip_cart]#将被完全清空。<br /><br />如果您不想删除所有人来自#pgv_lang[clip_cart]#的家庭等，您可以通过单击名称框中的<b>删除</b>链接单独删除条目。当您有<u>否</u>确认对话框时单击这些链接中的任何一个;请求的删除立即发生。";
$pgv_lang["add_by_id_help"] = 	 "~CLIPPINGS CART ADD BY ID~<br /><br />This input box lets you enter an individual's ID number so he can be added to the Clippings Cart.  Once added you'll be offered options to link that individual's relations to your Clippings Cart.<br /><br />If you do not know an individual's ID number, you can perform a search by name by pressing the Person icon next to the Add button.";
$pgv_lang["zip_help"] = "~ZIP CLIPPINGS~<br /><br />选择此选项以将剪辑保存在ZIP文件中。有关ZIP文件的更多信息，请访问<a href=\"http://www.winzip.com\" target=\"_ blank\"> http://www.winzip.com</a>。";
$pgv_lang["include_media_help"] = "~包含媒体~<br /><br />选择此选项可在剪报栏中包含与记录关联的媒体文件。选择此选项将在下载过程中自动压缩文件。";
$pgv_lang["clip_cart_help"] = "~CLIPPINGS CART~<br /><br />此框显示Clippings Cart的内容。<i>Types</i>列表示每个条目的类型，可以是Individual（INDI），Family（ FAM），源（SOUR），存储库（REPO），注释（注释）和媒体（OBJE）;每个都由它自己的图标表示。<i>ID</i>列显示每个条目的ID号。该特定类型。<i>名称/描述</i>列提供家庭或个人的名称，或条目的描述。删除按钮将从剪报购物车中删除该记录。<b>确认不要求删除。</b>";

//-- GEDCOM Edit Utility
$pgv_lang["show_changes_help"] = "~向GEDCOM显示变化~<br /><br />当您看到此消息时，它意味着两件事：<ol><li>有人对GEDCOM进行了更改<br />记录可能已被添加，删除或更改。</li><li>管理员尚未接受更改。<br />一旦更改被接受或拒绝，您将不再看到此消息。</li></ol>您可以看到点击链接时所做的更改。如果您发现更改不正确，请通知管理员。";

//-- Search-page
$pgv_lang["help_search.php"] = "~搜索页面~<br /><br />虽然这个页面看起来非常简单，但这两个表格背后有一个非常强大而复杂的搜索引擎。大多数家谱网站只是让你搜索一个名字.网站可以让你搜索几乎所有内容。<br /><br />屏幕左侧的搜索框与每个页眉中的搜索框相同。<br /><br />如果您正在寻找相关人员到某一年，只需键入年份。该程序将为您找到所有连接。<br /><br />寻找名称或地点？只需输入名称或地点，完全或只是输入一部分和网站完成剩下的工作。<br /><br /><b>Soundex搜索方法</b><br />使用右侧的搜索框，您可以搜索人员和地点的名称，即使您不知道如何写出这个名字。<br /><br />当一个网站上有几个家谱数据库且管理员已经启用它们之间切换时，你的搜索将返回所有这些数据库的结果。<br /><br />您可以通过单击方框上方的<b>？</b>找到有关这两个框的更多帮助。";
$pgv_lang["search_enter_terms_help"] = "輸入搜索條件<br /><br />在此搜索框中，您可以輸入日期，姓名，姓氏，地點，多媒體等條件。<br /><br /><b>通配符</b><br />您不太可能知道通配符（如*或？），但程序會自動採用通配符。<br /><br />假設您在搜索框中輸入以下內容：<b>Pete</b>。結果可能是，假設名稱在數據庫中：<div style=\"padding-left:30px;\">b>Pete</b> Smith<br /><b>Pete</b>r Johnes<br />Will <b>Pete</b>rson<br />某人-1901年1月1日出生<b>Peter</b>rsburg<br />等。</div><br /><b>日期</b><br />在\"搜索\"框中鍵入一年將生成以某種方式與該年相關聯的個人列表。<br /><br />如果您輸入<b>1950</b>，結果將是所有發生在1950年的事件的個人。這些事件可能是出生，死亡，婚姻，成人禮，LDS Sealings等等<br /><br />如果你輸入<b>4 Dec日</b>，將列出與任何一年的12月4日發生的事件有關的所有人員。12月14日或24日與活動有關的人員也將被列入名單。如您所見，始終假設通配符，因此您不必鍵入它們。有時，結果可能會令人驚訝。<br /><br /><b>正確的日期</b><br />網站搜索數據，因為它們存儲在GEDCOM文件中。例如，如果您要在12月14日搜索某個活動，則應鍵入<b>14&nbsp;dec</b>，因為這是日期在數據庫中的存儲方式。<br /><br />如果你打算輸入<b>dec&nbsp;14</b>，結果可能是一個人在08&nbsp;<b>dec</b>ember&nbsp;18<b>14</b>上與一個事件相關聯。同樣，結果可能會令人驚訝。<br /><br />如果您熟悉它們，可以在搜索中使用正則表達式。例如，如果你想找到所有在20世紀都有約會的人，你可以輸入搜索<b>19[0-9][0-9]</b>然後你會得到所有的日期為1900-1999的人。<br /><br />如果您需要有關此搜索系統的更多幫助，請告訴我們，以便我們也可以擴展此幫助文件。<br /><br />#pgv_lang[soundex_search_help]#<br /><br />#pgv_lang[search_replace_help]#";
$pgv_lang["search_replace_help"] = "~#pgv_lang[search_replace]#~<br /><br />在這裡，您可以搜索拼寫錯誤或其他不淮確的信息，並用正確的信息替換。<br /><br /><b>搜索</b><br />此功能執行搜索就像<a href=\"help_text.php?help=search_enter_terms_help\">正常搜索</a>一樣。<br /><br /><b>替換</b><br />所有搜索詞的實例都被數據庫中的替換詞取代。<br /><br /><b>例如......</b><br />假設你不小心拼錯了你的曾祖父邁克爾的名字。你不小心進入了'邁克爾'。<br /><br />你可以在搜索框中輸入<b>Micheal</b>，然後在替換框中輸入<b>Michael</b>。<br />每個\"Micheal\"的實例然後將被\"邁克爾\"取代<br /><br /><b>搜索...</b><br />選擇搜索範圍。您可以將搜索範圍限制為名稱或地點，或者不應用任何限制（搜索所有內容）。<i>#pgv_lang[search_place_word]#</i>選項只會在地點字段中搜索您的術語作為整個單詞。這意味著搜索<i>UT</i>只會匹配<b>UT</b>，而不是<i>UT</i>，而不是其他字樣，例如Connectic<b>ut</b>。<br /><br />如果您不小心更换了您不想要的东西，请不要担心。只需點擊頁面底部的\"接受/拒絕更改\"鏈接即可接受你想要的更改，並拒絕你不想要的更改。<br /><br />如果您需要有關此搜索系統的更多幫助，請告訴我們，以便我們也可以改進此幫助文件。";
$pgv_lang["soundex_search_help"] = "~#pgv_lang[soundex_search]#~<br /><br />Soundex是一種根據發音對單詞進行編碼的方法。當你不確切地知道它們是怎樣的時候，你可以搜索數據庫中的名字和地點。 網站支持兩種不同的Soundex算法，可以產生截然不同的結果。<ul><li><b>基本</b><br />這種方法於1918年由Russell獲得專利，非常簡單，可以手工完成。<br /><br />因為Basic方法保留了名稱的第一個字母作為結果代碼的一部分，所以當你不確定第一個字母時，它不是很有用.Basic算法不太適合於名字最初使用英語以外的語言，即使是英文名稱，結果也非常令人驚訝。例如，基本Soundex搜索<b>Smith</b>不僅會返回<b>Smith，Smid，Smit，Schmidt，Smyth，Smithe，Smithee，Schmitt</b>，所有這些都是<b>Smith</b>的明顯變體，但<b>Smead，Sneed，Smoote，Sammett，Shand，</b>和<b>Snoddy</b>。<br /><br /></li><li><b>Daitch-Mokotoff</b><br />這種方法是在1985年開發的，它比Basic方法複雜得多，並且不容易通過使用此方法的Soundex搜索可以產生更淮確的結果。</li></ul>有關Soundex算法的詳細信息，請訪問<a href=\"http://www.jewishgen.org/infofiles/soundex.html\" target=\"_blank\"><b>猶太家譜學會</b></a>網頁。";
$pgv_lang["search_exclude_tags_help"] = "~#pgv_lang[search_tagfilter]#~<br /><br /><b>#pgv_lang[search_tagfon]#</b>選項將導致搜索功能忽略以下GEDCOM標記：<div style=\"padding-left: 30px;\"><b>_PGVU</b> - 最後更改<br /><b>CHAN</b> - 上次更改日期<br /><b>FILE</b> -#factarray[FILE]#<br /><b>FORM</b> - #factarray[FORM]#<br /><b>TYPE</b> - #factarray[TYPE]#<br /><b>SUBM</b> - #factarray[SUBM]#<br /><b>REFN</b> - #factarray[REFN]#</div><br />除了這些可選的排除標籤外，搜索函數總是排除這些標記：<div style=\"padding-left: 30px;\"><b>_UID</b> - #factarray[_UID]#<br /><b>RESN</b> -#factarray[RESN]#</div>";
$pgv_lang["search_include_ASSO_help"] = "~#pgv_lang[search_asso_label]#~<br /><br />此選項使網站顯示所有被記錄為與作為搜索直接結果的人或家庭有關聯關係的個人。反之，如果發現作為搜索直接結果的人與這些其他人或家庭有關聯關係，則顯示所有人或家庭。<br /><br />示例：假設某人<b>A</b>對人<b> B</b>是顯而易見的。這種關係通過ASSO標籤記錄在人<b>B</b>的GEDCOM記錄中.GEDCOM中不存在相應的標記人員記錄<b>A</b>。<br /><br />此选项设置为<b>#pgv_lang[yes]#</b>且搜索结果列表包含<b>B</b>时，由于其中的ASSO标签，将自动包含<b>A</b> GEDCOM记录<b>B</b>。但是，如果搜索结果列表包含<b>A</b>，当则不会自动包含<b>B</b>，因为人<b>A</b>的GEDCOM记录中没有匹配的ASSO标记。";

//-- Individual Information-page
$pgv_lang["help_individual.php"] = "~#pgv_lang[indi_info]#頁面~<br /><br />此人的所有詳細信息都會顯示在此頁面上。<br /><br />如果有可用的圖片，您將在左上方。你會看到圖片旁邊的人的姓名。<br /><br />姓名可以附加註釋和來源。如果任何名稱有註釋或來源，你會看到他們列出與他們有關的名字。<br /><br />一個人可能有一個AKA（也許他的名字是另一個名字）。如果是這樣的話，它會被顯示出來。<br /><br />如果您擁有此人的修改權限，您還會看到可以編輯的條目旁邊的<b>修改</b>和<b>刪除</b>鏈接。<br /><br />在此頁面上你會看到<b>#pgv_lang[personal_facts]#</b>，<b>#pgv_lang[notes]#</b>，<b>#pgv_lang[ssourcess]#</b>，<b>的標籤頁#pgv_lang[media]#</b>和<b>#pgv_lang[relatives]#</b>。這些標籤頁顯示了存儲在數據庫中的有關此人的所有信息。<br /><ul><li><b>#pgv_lang[personal_facts]#</b>標籤將向您顯示有此人的事實和詳細信息以及他們婚姻中的任何事實。單擊此選項卡上的任何日期將轉到該日期的#pgv_lang[anniversary_calendar]#，以便您可以查看同一天發生的其他事件。單擊某個地點將轉到\"地方層次結構\"，您可以在其中查看在同一地點有活動的其他人。對於婚姻和其他與家庭有關的事實，可以提供配偶的姓名，以便您可以查看配偶，並提供家庭記錄的鏈接。</li><li><b>#pgv_lang[notes]#</b>標籤會顯示與此人相關的任何一般說明。</li><li><b>#pgv_lang[ssourcess]#</b>標籤會顯示所有<u>一般</u>這個人的來源。這些來源<u>不</u>與個人事實有關，甚至與個人姓名無關;他們與個人本身有關。單擊源標題將轉到更詳細的源信息頁面，該頁面將顯示同樣鏈接到同一源的其他人。</li><li><b>#pgv_lang[media]#</b>選項卡將列出附加到此個人的所有圖片和其他媒體條目。單擊圖片的縮圖將打開更大的圖像視圖。點擊圖片標題將在#pgv_lang[media_list]#页面上顯示圖片。</li><li><b>#pgv_lang[relatives]#</b>標籤列出了此人的父母和兄弟姐妹就像這個人所擁有的所有配偶和孩子一樣。這些人將被列在類似於您可能已經看過的圖表的框中。</li></ul>在屏幕右側，您會找到一個帶鏈接的框。框中的許多鏈接與菜單中的鏈接相同。例如，單擊側鏈接上的<b>#pgv_lang[pedigree_chart]#</b>鏈接將轉到此人的譜系圖表。這與菜單鏈接不同，因為單擊菜單中的<b>#pgv_lang[pedigree_chart]#</b>鏈接將返回到此數據庫的默認譜系圖表。<br /><br />如果管理員已啟用此列表中可能出現的鏈接之一是<b>#pgv_lang[view_gedcom]#</b>鏈接。此鏈接將顯示此人的原始GEDCOM記錄。<br /><br />如果站點管理員已啟用#pgv_lang[clip_cart]#，您還將擁有一個鏈接，允許您添加此鏈接#pgv_lang[clip_cart]的人#。<br /><br /><b>#pgv_lang[relationship_to_me]#</b>鏈接僅在您登錄並在GEDCOM中分配了ID後才會顯示。此鏈接將帶您進入譜系圖表並告訴您與此人的關係。<br /><br />#pgv_lang[context_help]#";
$pgv_lang["delete_person_help"] = "~从GEDCOM删除人员~<br /><br />当你点击这个选项时，你会将这个人标记为从数据库中删除。<br /><br />这是什么意思？<br />我们假设您有充分的理由从数据库中删除此人。您单击该链接。系统将要求您确认删除请求。如果您决定继续，可能需要一些时间才能看到个人的消息删除。<br /><br />当你继续访问时，你会注意到这个人仍然可见，可以像没有发生删除一样使用。<br /><br /><b>这是<u>不</u>错误。</b>站点管理员将收到一条消息，表明已对数据库进行了更改，并且您已删除该个人。<br />管理员可以接受或拒绝您的更改。只有在管理员接受您的更改后，才会实际删除<u>不可逆转</u>。如果对您的更改有任何疑问，管理员将与您联系。";
$pgv_lang["delete_name_help"] = "~编辑或删除GEDCOM的姓名~<br /><br /><b>编辑姓名</b><br />当您点击此链接时，将打开另一个窗口。在那里您可以编辑该人的姓名只需在框中键入更改，然后单击按钮，关闭窗口即可。<br /><br /><b>删除名称</b><br />单击此选项，您将标记为要从数据库中删除的名称。请注意，删除名称与删除个人完全不同。删除名称只会删除该人员的名称。该人员将<u>不</u>被删除。如果是你要删除的AKA，这个人还有其他名字。如果你想删除<u>唯一的</u>名字，那么这个人仍然不会被删除，但现在会记录为<b>#pgv_lang[NN]#</b>。此人也不会与亲戚，消息来源，笔记等脱节。<br /><br />它是如何运作的？<br />你会被要求确认你的删除请求。如果你决定继续，可以采取一个li在您看到删除名称的消息之前的时间。<br /><br />当您继续访问时，您会注意到该名称仍然可见，并且可以像没有发生删除一样使用。<br /><br /><b>这是<u>不</u>错误。</b>网站管理员会收到一条消息，说明已对数据库进行了更改，并且您删除了该名称。<br />管理员可以接受或拒绝您的更改。只有在管理员接受您的更改后，才会实际删除<u>不可逆转</u>。如果对您的更改有任何疑问，管理员将与您联系。";
$pgv_lang["add_name_help"] = "~添加新名称~<br /><br />此链接将允许您为此个人添加其他名称。有时人们会被其他名称或别名所知。此链接允许您向人员添加新名称而不更改旧名。";
$pgv_lang["add_sibling_help"] = "~#pgv_lang[add_sibling]#~<br /><br />当您点击此链接时，您可以将一个孩子添加到此家庭。\"此家庭\"，在这种情况下，是校长的父亲和母亲这个屏幕的人。<br /><br />请记住，你要添加一个兄弟姐妹。添加一个兄弟或姐妹很简单：只需点击链接，填写弹出屏幕中的框这就是全部。<br /><br />如果你必须添加一个主要人物的儿子或女儿，向下滚动一点，然后单击\"#pgv_lang[as_spouse]#\"中的链接。";
$pgv_lang["add_son_daughter_help"] = "~#pgv_lang[add_son_daughter]#~<br /><br />当您点击此链接时，您可以将一个孩子添加到此家庭。\"此家庭\"，在这种情况下，是此屏幕的主要人员，他或她的配偶。<br /><br />请记住，你要添加一个儿子或女儿。添加一个儿子或女儿很简单：只需点击链接，填写弹出框中的框屏幕就是这样。<br /><br />如果你必须添加一个主要人物的兄弟或姐妹，请向上滚动一点，然后单击\"#pgv_lang[as_child]#\"中的链接。";
$pgv_lang["link_child_help"] = "~#pgv_lang[link_as_child]#~<br /><br />当您点击此链接时，您可以将此人作为孩子链接到现有家庭。<br /><br />假设父母一次这个人的身份不明，你后来发现父母在这个数据库中有记录。<br /><br />只需点击链接，输入家庭的ID，你就完成了任务。不知道家庭的身份证，你可以搜索它。";
$pgv_lang["link_husband_help"] = "~#pgv_lang[link_as_husband]#~<br /><br />此条目允许您将当前个人作为丈夫链接到已存在于数据库中的家庭。通过单击此链接，您可以将此人添加到一个现存的家庭，到目前为止，丈夫一直不知道。这个人将取代以前不为人知的丈夫。所有事件，婚姻信息和孩子将保持与家庭的现有联系。<br /><br />只需单击链接，输入系列的ID，即可完成任务。这是一个高级编辑选项，只有在您要链接的系列已存在时才能使用。如果要添加<u>新的</u>系列，请使用<b>#pgv_lang[add_new_wife]#</b>链接。";
$pgv_lang["add_husband_help"] = "~#pgv_lang[add_new_husb]#~<br /><br />点击此链接，您可以添加一个<u>新的</u>男性人物，并将此人物作为新丈夫链接到主要个人。<只需单击该链接，您将弹出一个窗口以添加新人。填写尽可能多的框，然后单击<b>保存</b>按钮。<br /><br />就是这样。";
$pgv_lang["link_new_husb_help"] = "~#pgv_lang[link_new_husb]#~<br /><br />这将允许您将已经存在的另一个人与此人的新丈夫联系起来。这将与您选择的丈夫建立一个新的家庭。您还可以选择为这个新家庭指定婚姻。";
$pgv_lang["add_opf_child_help"] = "~#pgv_lang[add_opf_child]#~<br /><br />单击此链接，您可以向此人添加<u>新</u>子项，从而创建一个单亲家庭。<br /><br />只需单击该链接，您将弹出一个窗口来添加新人。尽可能多地填写框并单击<b>保存</b>按钮。<br /><br这就是全部。";
$pgv_lang["link_wife_help"] = "~#pgv_lang[link_as_wife]#~<br /><br />此条目允许您将当前个人作为妻子链接到已存在于数据库中的家庭。<br /><br />这是高级编辑选项，只有在您要链接的系列已经存在时才能使用。如果要为此人添加<u>新</u>系列，请使用<b>#pgv_lang[add_new_husb]#</b>链接。";
$pgv_lang["add_wife_help"] = "~#pgv_lang[add_new_wife]#~<br /><br />点击此链接，您可以添加<u>新</u>女性，并将此人作为新妻子链接到主要人员。<只需单击该链接，您将弹出一个窗口以添加新人。填写尽可能多的框，然后单击<b>保存</b>按钮。<br /><br />就是这样。";
$pgv_lang["link_new_wife_help"] = 	 "~#pgv_lang[link_new_wife]#~<br /><br />This will allow you to link another individual, who already exists, as a new wife to this person.  This will create a new family with the wife you select.  You will also have the option of specifying a marriage for this new family.";
$pgv_lang["add_new_parent_help"] = "#pgv_lang[multiple_help]#<br />~添加新的父親或母親~<br /><br />GEDCOM中肯定有很多人沒有父親或母親的記錄。<br /><br />在這種情況下，在<b>#pgv_lang[indi_info]#</b>頁面，標籤頁<b>#pgv_lang[親屬]#</b>，表<b>#pgv_lang[as_child]#</b>，你會找到為個人添加<u>新</u>父親或母親的鏈接。<br /><br />請記住，這些鏈接用於添加<u>新</u>父親或母親。如果父親或母親已在此數據庫中有記錄，則必須使用鏈接<b>#pgv_lang[link_as_child]#</b>，你可以在最后一张表下方的<b>#pgv_lang[indi_info]#</b>页面找到它。";
$pgv_lang["show_fact_sources_help"] = "~#pgv_lang[show_fact_sources]#~<br /><br />~#pgv_lang[show_fact_notes]#~<br /><br />选中此选项后，您可以看到此人的所有来源或备注记录。如果未选中此选项，则不会显示与此人的其他事实相关联的源或注释记录。";
$pgv_lang["age_differences_help"] = "~#pgv_lang[age_differences]#~<br /><br />选中此选项框后，«#pgv_lang[relatives]#»选项卡将显示日期差异，如下所示：<br /><ul><li>合作伙伴的出生日期。<br />负值表示第二个合作伙伴比第一个合伙人年龄大。<br /><br /></li><li>第一个孩子的结婚日期和出生日期。<这里的负值表示孩子在结婚日期之前出生，或者出生日期或结婚日期是错误的。<br /><br /></li><li>兄弟姐妹的出生日期。<br />这里的负值表示孩子的顺序错误或者其中一个出生日期是错误的。</li></ul>";

//-- Add Facts
$pgv_lang["add_facts_help"] = "~添加新事实~<br /><br />在这里你可以为正在编辑的记录添加一个事实。<br /><br />首先从下拉列表中选择一个事实，然后点击<b>添加</b>按钮。您可以添加到数据库的所有可能事实都在该下拉列表中。";
$pgv_lang["add_custom_facts_help"] = "~添加自定义事实~<br /><br />如果您无法找到想要添加到GEDCOM事实列表中的事实，您也可以输入<b>自定义事实</b>。<br /><br />输入自定义事实就像输入一个预定义的事实一样简单。唯一的区别是你必须命名事实而不是从列表中选择它的名字。你必须这样做这在顶部字段中：<b>#pgv_lang[type]#</b><br />";
$pgv_lang["add_note_help"] = "#pgv_lang[multiple_help]#<br />~添加新的注意事项~<br /><br />如果您有一个注释要添加到此记录中，这是可以这样做的地方。<br /><br />只需点击链接，就会打开一个窗口，你可以输入你的笔记。完成输入后，只需点击框下方的按钮，关闭窗口即可。<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_shared_note_help"] = "#pgv_lang[multiple_help]#<br />~#pgv_lang[add_shared_note_lbl]#~<br /><br />当您点击<b>#pgv_lang[add_shared_note]#</b>链接时，会出现一个新窗口您可以选择链接到现有的共享笔记，也可以创建新的共享笔记，同时创建一个链接。<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_source_help"] = "#pgv_lang[multiple_help]#<br />~添加新来源引用~<br /><br />您可以在此处添加源<b>引用</b>到此记录。<br /><br />只需单击该链接，将打开一个窗口，您可以从列表中选择源（​​查找ID）或创建新源，然后添加引文。<br /><br />添加源是其中的重要部分家谱，因为它允许其他研究人员验证您获取信息的位置。<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"] = "~#pgv_lang[add_media]#~<br /><br />將多媒體文件（MM）添加到GEDCOM是一個非常好的功能。雖然這個程序已經很好看，沒有媒體，如果你添加圖片或其他MM對你的親戚來說，它只會變得更好。<br /><br /><b>你應該對MM有什麼了解。</b><br />MM的格式很多。雖然網站可以處理大部分MM有一些事情要考慮。<br /><ul><li><b>格式</b><br />圖片可以編輯和保存為多種格式。例如，.jpg，.png，.bmp如果使用相同的原始圖片來創建每種格式，無論使用哪種格式，查看的圖像都會顯示相同的大小。但是，存儲在數據庫中的圖像文件會有很大差異。一般來說，.jpg圖像被認為在存儲空間方面效率最高。</li><li><b>圖像尺寸</b><br />原始圖像越大，圖像越大結果文件的大小。圖片應該適合屏幕不滾動;最大寬度或高度不應超過屏幕的寬度或高度。 PhpGedView設計用於1024x768像素的屏幕，但並非所有這些空間都可用於查看圖片;應相應地設置圖片的大小。為了減小文件大小，需要更小的圖片。</li><li><b>分辨率</b><br />圖片的分辨率通常以\"dpi\"（點/英寸）來衡量，但這僅適用於打印的圖片。在考慮屏幕上顯示的圖片時，唯一正確的方法是使用總點數或像素。打印時，根據打印機的不同，圖片的分辨率可能達到150 - 300 dpi或更高。屏幕分辨率很少超過每英寸50像素。如果永遠不會打印圖片，則可以安全地降低其分辨率（以及文件大小），而不會影響圖像質量。如果低分辨率圖像打印放大倍數太大，其質量將受損;它將具有顆粒狀外觀。</li><li><b>顏色深度</b><br />保持文件較小的另一種方法是減少使用的顏色數量。顏色的數量可以從純黑色和白色（兩種顏色）到真實顏色（數百萬種顏色）以及介於兩者之間的任何顏色不同。您可以看到使用的顏色越多，文件的大小就越大。</li></ul><b>為什麼保持文件大小很小很重要？</b><br /><ul><li>首先：我們的網站空間有限。文件越大，我們在服務器上需要的空間就越多。我們需要的空間越多，成本就越高。</li><li>帶寬。我們的服務器發送到遠程位置（您的位置）的數據越多，我們就越需要付費。這是因為服務器與Internet連接的承載能力有限，並且必須由服務器上運行的所有應用程序共享（並支付）鏈接。網站是共享服務器的眾多應用程序之一。成本通常根據每個應用程序發送和接收的數據量進行分配。</li><li>下載時間。如果您有大文件，則用戶（也是您）必須等待很長時間才能從服務器下載頁面。並非所有人都有幸使用有線連接，寬帶或DSL。</li></ul><b>如何上傳您的MM</b><br />有兩種方法可以將媒體上傳到網站。如果您要上傳大量媒體條目，請與網站管理員聯繫，討論最佳方式。如果您的網站管理員已啟用此功能，則可以使用#pgv_lang[mgv]#菜單下的上傳媒體表單。您還可以使用\"多媒體\"表單上的\"上傳\"選項上傳媒體條目。";
$pgv_lang["gen_missing_thumbs_help"] = "~#pgv_lang[gen_missing_thumbs]#~<br /><br />此选项将为当前目录中尚未包含缩略图的所有文件生成缩略图。这比单击<b>#更方便每个此类文件的pgv_lang[gen_thumb]#</b>链接。<br /><br />如果您希望保留对哪些文件应具有相应缩略图的控制权，则不应使用此选项。而是单击相应的<b>#pgv_lang[gen_thumb]#</b>链接。";
$pgv_lang["add_facts_general_help"] = "~关于添加的一般信息~<br /><br />当您将事实，注释，来源或多媒体文件添加到数据库中的记录时，添加仍然必须由具有接受权限的用户批淮。<br /><br />在更改被接受之前，它们被不同颜色的边框标识为\"待定\"。具有编辑权限的所有用户都可以看到这些更改以及原始信息。没有编辑权限只会看到原始信息。当添加已被接受时，边框将消失，新数据将正常显示，取代旧数据。此时，没有编辑权限的用户也将看到新数据。";

//-- Edit user
$pgv_lang["edituser_my_account_help"] = "您可以在这里更改您的设置和偏好。<br /><br />您可以更改您的用户名，全名，密码，语言，电子邮件地址，网站主题和首选联系方式。<br /><br />您无法更改GEDCOM INDI记录ID;这必须由管理员完成。";
$pgv_lang["edituser_username_help"] = "~#pgv_lang[username]#~<br /><br />在此框中，您可以更改您的用户名。如果您不再喜欢您的用户名或有其他理由进行更改，您可以使用此名称表单。<br /><br />用户名<u>区分大小写</u>。这意味着<b>John</b>与<b>john</b>或<b>JOHN</b>不同。<br /><br />你应该只</u>使用网站支持的字母表中的字符。你可以使用大写和小写字母，有或没有变音符号，数字，短划线（ - ）和下划线（_）。<u>不</u>使用标点符号或空格。";
$pgv_lang["edituser_firstname_help"] = "~#pgv_lang[firstname]#~<br /><br />在此框中，您可以更改您的名字。这是其他用户在您登录时看到的名称。<br /><br />虽然您可以选择在此字段中输入的内容，您应该在更改时通知管理员。当其他人在网上看到一个不知名的人时，他们可能会想知道并提出问题。管理员可以在未收到您通知的情况下找到，但是你应该为他节省那些不必要的工作。";
$pgv_lang["edituser_lastname_help"] = "~#pgv_lang[lastname]#~<br /><br />在此框中，您可以更改姓氏。这是其他用户在您登录时看到的名称。<br /><br />虽然您可以选择在此字段中输入的内容，您应该在更改时通知管理员。当其他人在网上看到一个不知名的人时，他们可能会想知道并提出问题。管理员可以在未收到您通知的情况下找到，但是你应该为他节省那些不必要的工作。";
$pgv_lang["edituser_gedcomid_help"] = "~#pgv_lang[gedcomid]#~<br /><br />这是一个识别号码，它将您链接到数据库中您自己的数据。<br /><br />您无法更改此ID;它由以下设置：管理员。如果您认为此ID不正确，您应该联系管理员以更改它。";
$pgv_lang["edituser_rootid_help"] = "~#pgv_lang[rootid]#~<br /><br />这是你所有图表的起始（根）人。<br /><br />例如，如果你点击链接到在谱系中，你会在最左边的方框中看到这个根人。这个根人不一定是你;你可以从任何人（例如你的祖父或你母亲的阿姨）开始，只要你有权看到那个人。<br /><br />这个选项改变了大多数图表的默认Root用户。你可以改变许多图表上实际使用的Root用户，但那只是在那个特定时间用于那个页面。";
$pgv_lang["edituser_password_help"] = "~#pgv_lang[password]#~<br /><br />定期更改密碼是一種很好的做法。您必須記住，知道您的用戶名和密碼的任何人都可以訪問您的數據。密碼長度至少為6個字符，越長越好。您可以使用帶或不帶變音符號，數字，短劃線（-）和下劃線（_）的大寫和小寫字母。 <u>不</u>使用標點符號或空格。使用大寫和小寫，數字和其他字符的組合。例如：<b>5Z_q\$P4=r9</b>。<br /><br />與用戶名一樣，密碼<u>區分大小寫</u>。这意味着<b>Secret.Password!#13</b>與不同<b>secret.password!#13</b>或<b>SECRET.PASSWORD!#13</b>是不同的。";
$pgv_lang["edituser_conf_password_help"] = "~#pgv_lang[确认]#~<br /><br />如果您更改了密码，还需要确认密码。这只是为了确保您没有在密码字段中输入错误。<br /><br />如果密码及其确认信息不相同，您将收到相应的错误消息。您必须重新输入原始密码及其确认信息。";
$pgv_lang["edituser_change_lang_help"] = "~#pgv_lang[change_lang]#~<br /><br />您可以在此处更改网站在您登录后显示其所有页面和消息的语言。<br /><br />当您第一次访问该网站，网站假设您希望在浏览器中查看所有语言中配置为首选语言。如果该假设不正确，您可以在此处覆盖它。例如，您的浏览器可能设置为英语，因为这是互联网上最流行的语言。但是，出于家谱目的，您更愿意看到芬兰语或希伯来语中的所有内容。您可以在此处执行此操作。<br /><br />管理员控制您可以使用的语言选择。您的偏好未列出，您需要联系管理员。<br /><br />请记住，网站是一个由无偿志愿者的国际团队组成的条目。专家来去。因此，支持语言除了英语之外，有时不如它应该是。<br /><br />如果您看到某些内容未被翻译，翻译错误或者措辞更好，请告知您的管理员。管理员将知道如何与网站开发团队取得联系以解决您的问题。更好的是，志愿做一些你的时间。我们可以使用帮助。";
$pgv_lang["edituser_email_help"] = 	 "~#pgv_lang[emailadress]#~<br /><br />Your correct email address is, important to us to keep in touch with you.<br /><br />If you get a new email address, as usually happens when you change your Internet provider, please do not forget to change the address here as well.  You won't get a confirmation message from this site when you change this address, but any future messages directed to you will go this new address.";
$pgv_lang["edituser_user_theme_help"] = "~#pgv_lang[user_theme]#~<br /><br />这个网站可以有几种不同的外观或外观。其他程序可能称它们为\"皮肤\"，但这里它们是\"主题\"。<每个主题都会显示相同的数据，但它的显示甚至在屏幕上的位置可能会有所不同。这就像将图片放入不同的框架并将其挂在不同的房间中一样。不会改变，但你看它的方式是完全不同的。<br /><br />试试吧。把它设置成另一个主题。看看它，尝试另一个。改回适合你的那个无论何时登录，您都会看到上次使用的主题;您甚至无需进入此配置页面来更改您的首选主题。";
$pgv_lang["edituser_contact_meth_help"] = 	 "~#pgv_lang[user_contact_method]#~<br /><br />网站有几种不同的联系方式。 管理员确定将使用哪种方法与他联系。 您可以控制用于联系<u>你</u>的方法。 根据站点配置，您可能无法使用某些列出的方法。";
$pgv_lang["mail_option1_help"] = "使用此选项，将使用网站内部消息系统，不会发送任何电子邮件。<br /><br />您将只收到来自其他用户的<u>内部</u>消息。当另一个站点用户向您发送消息，该消息将显示在您的个人#pgv_lang[mygedview]#页面的消息块中。如果您已从#pgv_lang[mygedview]#页面中删除此块，您将看不到任何消息。他们会，但是，只要您将#pgv_lang[mygedview]#页面配置为再次拥有Message块，就会显示出来。";
$pgv_lang["mail_option2_help"] = "此选项类似于#pgv_lang[messaging]#，只需添加一个。另外，该邮件的副本也将发送到您在\"帐户\"页面上配置的电子邮件地址。<br /><br />这是默认联系方式。";
$pgv_lang["mail_option3_help"] = "使用此选项，您只会收到您在帐户页面上配置的地址的电子邮件。根本不会使用网站内部的消息传递系统，并且您的个人消息块中永远不会有任何消息#pgv_lang[mygedview]#页面。";
$pgv_lang["mail_option4_help"] = "使用此选项，您将不会收到任何消息。即使是管理员也无法联系到您。";

//-- Admin
$pgv_lang["admin_help"] = "在此页面上，您可以找到配置页面，管理页面，文档和日志文件的链接。<br /><br /><b>#pgv_lang[system_time]#</b>，就在页面标题下方，显示托管您网站的服务器的时间。这意味着如果您在法国时服务器位于纽约，则显示的时间将比当地时间少6个小时，当然，除非服务器在格林威治标淮时间（GMT）上运行。显示的时间是您打开或刷新此页面时的服务器时间。<br /><br /><b>警告</b><br />当您看到系统时间下的红色警告消息，表示您的<i>config.php</i>仍然可写。配置完网站后，您应该为<b>安全</b>设置此文件的权限回到只读。你必须手动<u>手动</u>，因为网站不能为你做这个。";

//-- User Admin
$pgv_lang["useradmin_help"] = "~#pgv_lang[user_admin]#~<br /><br />在此页面上，您可以管理当前用户并添加新用户。<br /><br /><b>#pgv_lang[current_users]#</b><br />在此表中显示当前用户，他们的状态和权利。您可以<b>删除</b>或<b>编辑</b>用户。<br /><br /><b>#pgv_lang[add_user]#</b><br />此表单几乎与用户在<b>#pgv_lang[editowndata]#</b>页面上看到的相同。<br /><br />对于多个主题，我们没有为管理员提供特殊的帮助文本。在这些情况下，您将看到以下消息：";
$pgv_lang["useradmin_gedcomid_help"] = "~#pgv_lang[gedcomid]#~<br /><br />#pgv_lang[gedcomid]#与家谱中人员进行关联。必须由管理员设置。<br /><br />此ID用作多个页面上的ID，例如<b>#pgv_lang[my_indi]#</b>和<b>#pgv_lang[my_pedigree]#</b>。<br /><br />您可以设置用户的GEDCOM ID对于每个GEDCOM，如果用户没有GEDCOM中的记录，则将该框留空。";
$pgv_lang["useradmin_rootid_help"] = "~#pgv_lang[rootid]#~<br /><br />对于每个宗谱数据库，您可以为用户指定根人员。<br /><br />此根人員不需要是用戶本身;它可以是任何人。用戶可能想要自己啟動譜系圖表。你可以在这里控制它，以及其他图表上的默认原始人。<br /><br如果用戶擁有自己帳戶信息的編輯權限，他可以自行更改此設置。";
$pgv_lang["useradmin_can_admin_help"] = "~#pgv_lang[can_admin]#复选框~<br /><br />如果选中此框，则用户将拥有与您相同的权限。<dl><dt>这些权利包括：</dt><dd>添加/删除/编辑用户</dd><dd>向所有用户广播消息</dd><dd>编辑欢迎消息</dd><dd>编辑和配置语言文件</dd><dt></dt><dd>升级网站</dd><dd>更改计划和GEDCOM配置</dd><dd>管理GEDCOM</dd><dd>更改隐私设置</dd><dd>等等否则这里没有提到。</dd></dl><br />用户<u>不能</u>在网站之外更改服务器上的任何内容。";
$pgv_lang["useradmin_sync_gedcom_help"] = "~#pgv_lang[sync_gedcom]#复选框~<br /><br />如果选中此框并且用户分配了GEDCOM记录ID，则他们的用户帐户设置将自动与其GEDCOM数据同步。意味着当用户的GEDCOM记录被编辑时，一些信息，如电子邮件地址和名称将被复制到用户的帐户。当用户的帐户被编辑时，相应的信息将被复制到GEDCOM记录。";
$pgv_lang["useradmin_can_edit_help"] = "~#pgv_lang[can_edit]#~<br /><br />用户可以对系统中的每个系谱数据库拥有不同的访问和编辑权限。<ul><li><b>#pgv_lang[none]#：</b>用户无法访问此GEDCOM中的私人数据。</li><li><b>#pgv_lang[access]#：</b>用户无法编辑或接受数据到数据库中，但可以看到私人数据。</li><li><b>#pgv_lang[edit]#：</b>用户可以编辑值，但具有<b>#pgv_lang[accept]#</b>权限的其他用户必须批淮在将它们添加到数据库并公开之前进行更改。</li><li><b>#pgv_lang[accept]#：</b>用户可以编辑。他还可以编辑和批淮其他用户所做的更改。</li><li><b>#pgv_lang[admin_gedcom]#：</b>用户编辑并批淮其他用户所做的更改。用户还可以编辑<u>此</u>的配置和隐私设置GEDCOM。</li></ul>系统管理员通过<b>#pgv_lang[can_admin]#</b>复选框确定，会自动获得<b>#pgv_lang[admin_gedcom]#</b>权限。";
$pgv_lang["useradmin_verified_help"] = "~#pgv_lang[verified]#~<br /><br /><b>自己注册</b><br />用户可以通过<b>自己注册</b申请新帐户>模块。<br /><br />当他这样做时，他会收到一封电子邮件，其中包含验证其申请的链接。申请人按照该电子邮件中的说明操作后，您会看到此复选框，您可以继续下一步，<b>#pgv_lang[verified_by_admin]#</b>。只要未选中此框，您就应该等待批淮。<br /><br /><b>添加用户手动</b><br />如果您使用此表单手动添加用户，您会发现此框已经被选中。";
$pgv_lang["useradmin_verbyadmin_help"] = "~#pgv_lang[verified_by_admin]#~<br /><br />如果用户使用了自助注册模块并且已经验证了自己，那么在他的帐户激活之前的最后一步是您的批淮。<br /><br />在您批淮用户的新帐户申请后，该用户将收到一封电子邮件消息。该消息将告诉用户他的帐户现在处于活动状态。他可以使用他提供的用户名和密码登录他申请了这个帐户。";
$pgv_lang["useradmin_edit_user_help"] = "~#pgv_lang[update_user]#~<br /><br />管理员使用此表单来更改用户的帐户<br /><br />表单非常类似于<b>#pgv_lang[add_user]#</b>和<b>#pgv_lang[update_myaccount]#</b>表单。";
$pgv_lang["useradmin_visibleonline_help"] = "~可见在线~<br /><br />此复选框可控制您在线时对其他用户的可见性。它还可以控制您查看配置为可见的其他在线用户的能力。<br /><br />如果未选中此框，您将完全看不到其他人，并且您也无法看到其他在线用户。选中此框后，情况恰恰相反。其他人也可以看到您，而您也将能够看到其他配置为可见的人。";
$pgv_lang["useradmin_editaccount_help"] = "~编辑帐户信息~<br />如果选中此框，该用户将能够编辑他的帐户信息。虽然通常不建议这样做，但您可以为多个用户创建单个用户名和密码。如果对具有共享帐户的所有用户取消选中此框，则会阻止他们编辑帐户信息，只有管理员才能更改该帐户。";
$pgv_lang["useradmin_relation_priv_help"] = "~#pgv_lang[user_relationship_priv]#~<br /><br />如果选中此框，则只允许用户访问与他们相关的活人。他们将能够看到任何人。关系路径长度由<i>#pgv_lang[user_path_length]#</i>设置。您可以通过启用GEDCOM隐私设置中的全局选项来要求所有用户建立关系隐私。<br /><br />此设置要求用户在能够看到任何生活人员之前与GEDCOM ID相关联。";
$pgv_lang["useradmin_path_length_help"] = "~#pgv_lang[user_path_length]#~<br /><br />如果启用了<i>#pgv_lang[user_relationship_priv]#</i>，该用户将只能看到或编辑此数量的生活个体关系步骤。";
$pgv_lang["useradmin_auto_accept_help"] = "~#pgv_lang[user_auto_accept]#~<br /><br />通过选中此框，您可以让系统自动接受该用户所做的任何编辑更改。用户还必须拥有GEDCOM的接受权限才能此设置生效。";

//-- Manage Sites
$pgv_lang["help_managesites"] = "~#pgv_lang[link_manage_servers]#~<br /><br />在此页面上，您可以添加远程站点并拒绝来自特定IP地址的访问。<br /><br />可以通过提供站点添加远程站点远程Web服务的标题，URL，数据库ID（可选），用户名和密码。<br /><br />永久或定时IP访问拒绝是通过提供确切的IP地址或任何有效的IP地址范围来完成的。例如，212.10.*.*列表中IP地址范围内的远程站点将无法访问您的站点。";
//-- Adding Remote Links
$pgv_lang["help_remotesites"] = "~#pgv_lang[label_new_server]#~<br /><br />要添加远程站点，请提供站点标题，远程Web服务的URL，数据库ID（可选）以及用户名和密码。单击添加（ +）按钮完成该过程。如果远程服务器允许匿名认证，则应将用户名和密码留空。";
//-- IP Address Banning
$pgv_lang["help_IPv4IPv6"] ="IPv4地址由4個段組成，由\".\"分隔，並包含0到255範圍內的十進制數(不帶前導零)。例如：<b>172.252.19.56</b>，<b>212.10.*.*</b>，<b>212.10.</b>，<b>212.10</b>，<b>212.10..29</b>或<b>212.10.*.29</b>。這些示例中缺少的部分將用通配符\"*\"（星號）代替。<br /><br />IPv6地址由8個段組成，用\":\"（冒號）分隔，包含4位十六進制數。這些數字不應該有前導零，第一個零序列可以被刪除並替換為一對\"::\"（冒號）符號。如果需要使用<i>通配符</i>功能，則需要用\"*\"（星號）代替。例如：<b>23:0:cafe::2:1</b>，<b>23:0:cafe::*:1</b>或者<b>23:0:*::*:*</b>。在這些示例中，兩個冒號代表3個都是零的數字序列，例如：<b>23:0:cafe:0:0:0:*:1</b>。";
$pgv_lang["help_banning"] = "~#pgv_lang[label_banned_servers]#~<br /><br />阻止指定的IPv4或IPv6地址訪問您的站點，請輸入準確的IP地址或有效的IP地址範圍，例如IPv4：<b>172.252.13.56</b>或212.10.*.*，IPv6：<b>23:0:cafe::2:1</b>，<b>23:0:cafe::*:1</b>或<b>23:0:*::*:*</b>然後單擊添加（+）按鈕。<br /><br />#pgv_lang[help_IPv4IPv6]#";
$pgv_lang["help_timedban"] = "~#pgv_lang[label_timedban_servers]#~<br /><br />当检测到黑客企图时，网站将自动阻止从该IP地址访问一小时。您可以通过在“注释”字段中输入要阻止的IPv4或IPv6地址以及访问拒绝的到期日期和时间来添加自己的定时访问拒绝。请确保使用正确的到期时间格式。如果未正确输入到期时间信息，则拒绝访问将不会自动到期。<br /><br />应按以下格式输入到期：<b>yyyy.mm.dd@hh:mm</b>。例如，<b>2012.12.23@23:59</b>。注意请使用24小时制。<br /><br />#pgv_lang[help_IPv4IPv6]#";
$pgv_lang["help_manual_search_engines"] = "~#pgv_lang[label_manual_search_engines]#~<br /><br />网站自动为搜索引擎提供具有较少链接的数据文件。这些数据仅限于个人和直系亲属，没有添加有关祖父母或孙子女的信息。许多报表和服务器密集型页面（如日历）都禁止搜索引擎访问。<br /><br />许多流行的搜索引擎如Google和Bing会被自动检测到。如果希望未被自动识别的搜索引擎收录您的网站数据，则可以在此处输入它的IPv4或IPv6地址，提供淮确的IP地址或有效的IP地址范围，例如IPv4：212.10.*.*（IP段）或172.252.13.56（单IP），IPv6：23:0:cafe::*:1或23:0:cafe::2:1，然后单击添加（+）按钮。<br />如果要完全排除此搜索引擎，请将其IP输入到<i>#pgv_lang[label_banned_servers]#</i>区域。如果你想查看哪些数据可以被搜索引擎收录的，请在这里输入你自己的IP地址。<span class='warning'>警告：</span>这会将你锁定在管理界面之外，你必须通过从其他机器登录或手动编辑<i>#GLOBALS[TBLPREFIX]#ip_address</i>数据库表。<br /><br />#pgv_lang[help_IPv4IPv6]#";
//-- Search_engines.php
$pgv_lang["search_engine_landing_page"] = "~检测到搜索引擎~<br /><br /><br /><br />网站会自动为搜索引擎提供较少的数据文件和较少的链接。数据仅限于个人和直系亲属，无需添加有关父母或大孩子的信息。像日历这样的服务器密集型页面对蜘蛛是不受限制的。<br /><br />蜘蛛尝试访问这些页面会导致显示此页面。如果您看到此文本，则软件认为您是搜索引擎蜘蛛。下面是允许蜘蛛网的列表，并提供缩写数据。<br /><br />关注搜索引擎链接到此站点的真实用户将看到完整的页面和数据，而不是这个页面。";

//-- G E D C O M
$pgv_lang["add_upload_gedcom_help"] = "~添加上传GEDCOM~<dl><dt><b>上传GEDCOM文件</b></dt><dd>上传文件可以在线完成。您可以从任何地方上传而无需ftp程序。</dd><dt><b>添加GEDCOM文件</b></dt><dd>如果以前上传的文件仍然存在于您的GEDCOM目录中，您可以再次使用它而无需上传。有时，由于文件或上传大小限制，您需要使用添加。</dd></dl>添加和上传过程可以通过四个简单步骤完成。在任一过程中，只有步骤1不同。";
$pgv_lang["gedcom_configfile_help"] = "~GEDCOM CONFIGURATION FILE~<br /><br />这是存储与家谱数据库相关的所有基本设置的文件。每个这样的数据库都有一个单独的文件。<br /><br />你将在<b>#pgv_lang[gedcom_adm_head]#</b>页面的<b>#pgv_lang[current_gedcoms]#</b>表中找到每个配置文件的路径和名称。";
$pgv_lang["default_gedcom_help"] = "~默认GEDCOM~<br /><br />如果你有一个以上的家谱数据库，你可以在这里设置哪一个是默认的。<br /><br />这个默认值会显示给所有访客和尚未登录的用户。<br /><br />可以编辑其帐户设置的用户可以覆盖此默认设置。在这种情况下，登录后将显示用户首选的数据库。";
$pgv_lang["delete_gedcom_help"] = "~删除GEDCOM~<br /><br />网站从之前上传的GEDCOM文件创建数据库。当您选择<b>删除</b>时，数据库的该部分将被删除。您必须确认您的删除请求。<br /><br />除非您故意在网站外删除它，否则原始的GEDCOM文件将保留在上传的目录中。如果您以后想再次使用该GEDCOM文件，不必再次上传。您可以选择<b>#pgv_lang[add_gedcom]#</b>功能。";
$pgv_lang["add_gedcom_help"] = "~#pgv_lang[add_gedcom]#~<br /><br />當您使用<b>#pgv_lang[add_gedcom]#</b>功能時，假設您已將GEDCOM文件上傳到您的服務器使用程序或方法<u>外部</u>到網站，例如，<i>ftp</i>或<i>網絡連接</i>。您要添加的文件也可能已被遺留來自之前的<b>#pgv_lang[upload_gedcom]#</b>程序。<br /><br />如果輸入的GEDCOM文件尚未在您的服務器上，您<u>必須</u>獲取它首先，在開始添加之前。<br /><br />您也可以使用網站或使用外部程序上傳包含GEDCOM文件的ZIP文件，而不是上傳GEDCOM文件.網站將識別ZIP文件自動生成，並從ZIP文件中提取GEDCOM文件和文件名。<br /><br />如果網站中已經存在同名的GEDCOM文件，它將被覆蓋。但是，之前所有的GEDCOM設置都是將被保留。<br /><br />您将被引导逐步完成该过程。";
$pgv_lang["add_new_gedcom_help"] = "~#pgv_lang[add_new_gedcom]#~<br /><br />你可以从头开始一个新的系谱数据库。<br /><br />这个程序只需要几个简单的步骤。第一步不同于什么你已经知道上传和添加。其他步骤将很熟悉。<ol><li><b>命名新的GEDCOM</b><br />键入新GEDCOM的名称<u>没有</u>扩展名<b>.ged</b>。新文件将在您输入名称的框上方的目录中创建。单击<b>添加</b>。</li><li><b>配置页</b><br />您已经知道此页面;您需要配置新GEDCOM文件的设置。</li><li><b>验证</b><br />您已经知道这个页面;新的GEDCOM已经过检查。因为它没有任何内容，所以没问题。</li><li><b>导入记录</b><br />因为只有一条记录需要导入，这将很快完成。</li></ol>就是这样。现在你可以进入谱系图表，在新的GEDCOM中看到你的第一个人。点击这个人的名字和sta rt编辑。之后，您可以将新个人与第一个人联系起来。";
$pgv_lang["download_gedcom_help"] = "~#pgv_lang[download_gedcom]#~<br /><br />您可以从此页面下载GEDCOM格式的系谱数据库。您可能想将数据导入另一个系谱程序，或者您可能想要分享其信息与他人一起。<br /><br />#pgv_lang[utf8_ansi_help]#<br /><br />#pgv_lang[remove_tags_help]#<br /><br />#pgv_lang[download_zipped_help]#";
$pgv_lang["edit_gedcoms_help"] = "~#pgv_lang[gedcom_adm_head]#~<br /><br />#pgv_lang[gedcom_adm_head]#页面是管理所有家谱数据库的控制中心。<br /><br /><b>#pgv_lang[current_gedcoms]#</b><br />在<b>#pgv_lang[current_gedcoms]#</b>表的开头，您会看到一个包含四个链接的操作栏。<ul> <li>#pgv_lang[add_gedcom]#</li><li>#pgv_lang[upload_gedcom]#</li><li>#pgv_lang[add_new_gedcom]#</li><li>#pgv_lang[lang_back_admin]#</li></ul>在<b>#pgv_lang[current_gedcoms]#</b>表中，每个系谱数据库都单独列出，并且每个系列都有以下选项：<ul><li>导入</li><li>删除</li><li>下载</li><li>编辑配置</li><li>编辑隐私</li><li>SearchLog文件</li></ul>此处显示编辑隐私，因为每个GEDCOM都有它自己的隐私文件。<br /><br />此表中的每一行都应该是不言自明的.网站可以配置为记录所有数据库搜索。可以通过此页面上的链接检查SearchLog文件。<br />#pgv_lang[more_help]#";
$pgv_lang["edit_config_gedcom_help"] = "~配置GEDCOM~<br /><br />每个与网站一起使用的家谱数据库都有自己的<b>配置文件</b>。<br /><br />在这个表单中你可以配置很多选项，比如数据库标题，语言，日历格式，电子邮件选项，数据库搜索记录，HTML META标题，从数据库的频繁姓氏列表中删除姓氏等";
$pgv_lang["import_gedcom_help"] = "~进口GEDCOM~<br /><br />在大多数情况下，导入外部创建的GEDCOM文件是程序中的一步，导致对系谱数据库进行批量更改。<br /><br />这些步骤在一个逻辑顺序，需要按照规定的顺序完成，以便系谱数据库可用。<br /><br />如果由于某种原因，你没有按照正确的顺序完成这些步骤，你会看到一个<u>警告</u>消息说明尚未导入GEDCOM。要解决问题，请单击<b>导入GEDCOM</b>链接导入文件。<br /><br />现有GEDCOM配置设置重新导入GEDCOM时不会改变。但是，现有数据将被覆盖。";
$pgv_lang["upload_gedcom_help"] = "~#pgv_lang[upload_gedcom]#~<br /><br />与<b>#pgv_lang[add_gedcom]#</b>功能不同，您希望添加到数据库的GEDCOM文件不必打开您的服务器。<br /><br />在第1步中，您从本地计算机中选择一个GEDCOM文件。在文本框中键入完整的路径和文件名，或使用页面上的<b>浏览</b>按钮。<br /><br />您还可以使用此功能上传包含GEDCOM文件的ZIP文件.网站将识别ZIP文件并自动提取文件和文件名。<br /><br />如果是在网站中已经存在具有相同名称的GEDCOM文件，在您确认之后，它将被覆盖。但是，之前制作的所有GEDCOM设置都将被保留。<br /><br />您将在其他页面上找到更多帮助。程序。";
$pgv_lang["validate_gedcom_help"] = "~确认GEDCOM~<br /><br />这是将外部创建的GEDCOM数据添加到您的家谱数据库的过程中的第三步。<br /><br />网站将检查输入文件是否正确使用日期格式，地点格式，字符集等等。与网站所遵循的GEDCOM 5.5.1标淮的某些偏差可以自动更正。例如Macintosh行结尾和Place格式的错误使用。当发生这种情况时，你将看到数据已被更改的消息。对于其他异常情况，您将收到一条推荐解决方案的警告消息。<br /><br /><b>可选工具</b><br />此时有只有一个额外的工具：<br /><b>将个人ID更改为......</b>。<br />#pgv_lang[more_config_help]#";
$pgv_lang["convert_ansi2utf_help"] = "~将ANSI转换为UTF-8~<br />为了确保输入GEDCOM文件中的信息得到正确处理和显示，这些文件应以UTF-8编码。<br /><br />一些更现代的族谱程序可以将数据导出为UTF-8编码的GEDCOM文件。较旧的程序通常没有这种功能。如果你的程序没有提供这个选项，网站可以为你转换文件。<br /><br />当网站验证输入文件时，它将检测文件的编码并相应地通知您。";
$pgv_lang["detected_ansi2utf_help"] = "~检测到ANSI编码~<br /><br />现在验证的GEDCOM文件是用ANSI字符集编码的。强烈建议您将文件的编码转换为UTF-8。<br /><br /><br />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"] = "~錯誤日期格式被檢測到~<br /><br /><b>日期格式將被更改</b><br /><br />PhpGedView标准日期格式，也符合GEDCOM 5.5.1标准<b>DD&nbsp;MMM&nbsp;YYYY</b>（例如01&nbsp;JAN&nbsp;2004）<br /><br />如果在您的GEDCOM文件經過驗證後，您會看到錯誤日期的消息格式已被檢測到，網站將轉換標淮規定的格式錯誤的日期。<br /><br />但是，您可以選擇在月份之前選擇\"<b>日</b>\" （DD&nbsp;MMM&nbsp;YYYY），或\"<b>月</b>日前\"（MMM&nbsp;DD&nbsp;YYYY）。<br /><br />我們建議您使用第一種格式（前一天）月）。";
$pgv_lang["change_indi2id_help"] = 	 "~将人员ID更改为....~<br /><br />该工具专为那些每次GEDCOM导出时Genealogy程序为个人使用不同GEDCOM ID的用户而设计。 例如，GEDCOM第一次出口时某人的身份证可能是I100，但下次GEDCOM出口时，同一人的身份证改为I234。 这些不断变化的ID使得管理网站变得很困难，因为ID是人们被引用的方式。<br /><br />大多数家谱程序也使用RIN或REFN标签为每个人提供一个唯一的标识符，可用于引用 个人。 此工具将使用您指定的任何字段（RIN或REFN）替换GEDCOM文件中的所有单个ID。";
$pgv_lang["edit_privacy_help"] = "在此页面上，您可以为选定的GEDCOM进行所有隐私设置。<br /><br />您可以在页面标题下查看是否正在编辑正确的隐私文件。它显示如下:(路径/nameofyourgedcom_priv.php）<br /><br />如果您需要更多设置，可以手动更改隐私文件。您可以在网站上阅读更多相关信息。";
$pgv_lang["BOM_detected_help"] = "~检测到字节顺序标记（BOM）~<br /><br />您导入的GEDCOM文件在开头有一个特殊的3字节代码。某些程序使用此特殊代码表示该文件已被删除以UTF-8字符集录制。<br /><br />虽然这个特殊代码实际上并不是一个错误，但当输入文件包含代码时，网站将无法正常工作。您应该让网站删除代码。";
$pgv_lang["invalid_header_help"] = "~无效的GEDCOM标题~<br /><br />GEDCOM文件必须以<b>0&nbsp;HEAD</b>开头.网站检测到您导入的GEDCOM文件没有<b>0&nbsp;HEAD</b>作为第一行。当您单击清除按钮时，第一个<b>0&nbsp;HEAD</b>行之前的任何行都将被删除。<br /><br />此错误通常意味着该程序您曾经创建的GEDCOM没有正确创建它或它不是GEDCOM文件。您应该检查以确保您上传了正确的文件，并且它以<b>0&nbsp;HEAD</b>行开头以<b>0&nbsp;TRLR</b>行结束。";
$pgv_lang["macfile_detected_help"] = "~檢測到MACINTOSH文件~<br /><br />網站檢測到您的GEDCOM文件是在Macintosh計算機上創建的。<br /><br />Macintosh文件以CR控制代碼結束每一行。CR是Ctrl+M。<br />Unix文件用LF控制代碼結束每一行。LF是Ctrl+J。<br />Windows和DOS使用雙碼序列，CR後跟LF。<br /><br />網站要求所有文件都使用Unix或DOS行結尾。當你點擊清理按鈕時，你的行結尾將被相應地轉換。";
$pgv_lang["cleanup_places_help"] = "~清理地点~<br /><br />网站检测到您的GEDCOM文件使用了不应该有地方的GEDCOM标签上的地方。<br /><br />许多家谱程序，如Family Tree Maker，将创建这种类型的GEDCOM文件.网站将使用这些GEDCOM文件，但是一些无效的地方会显示在你的地方层次结构中。<br /><br />例如，你的GEDCOM可能有以下编码<br />1 SSN<br />2 PLAC 123-45-6789<br />1 OCCU<br />2 PLAC计算机程序员<br /><br />根据GEDCOM 5.5.1标淮，这应该显示为<br />1 SSN 123-45-6789<br />1 OCCU计算机程序员<br /><br />如果选择<b>是</b>，网站将自动纠正这些编码错误。";
$pgv_lang["empty_lines_detected_help"] = "~检测到EMPTY LINES~<br /><br />网站检测到输入文件中有空行。这些行可能会导致错误，并在导入之前从文件中删除。";

//-- Edit Config
$pgv_lang["help_editconfig.php"] = "~配置网站~<br /><br />在此页面上，您可以配置网站的全局设置。您必须在安装网站并首次运行它之后执行此操作。<br /><br />#pgv_lang[review_readme]#由于这些设置是<b>全局</b>，它们适用于整个程序以及与网站一起使用的所有系谱数据库。<br /><br />每个系谱数据库还有其他您在此页面上单击<b>#pgv_lang[admin_gedcoms]#</b>链接后设置的配置选项。<br /><br />您还可以从主管理员访问#pgv_lang[gedcom_adm_head]#功能页面，其链接位于#pgv_lang[mgv]#图标或大多数页面的标题下。在管理员页面上，相关链接称为<b>#pgv_lang[manage_gedcoms]#。</b>";

//-- merge records
$pgv_lang["help_edit_merge.php"] = "~#pgv_lang[merge_records]#~<br /><br />此頁面允許您合併來自同一GEDCOM文件的兩個GEDCOM記錄。<br /><br />這對合併GEDCOM的人有用現在有許多相同的人，家庭和來源。<br /><br />頁麵包含三個步驟。<br /><ol><li>您輸入兩個GEDCOM ID。ID <u>必須</u>屬於同一類型。例如，您不能合併個人和家庭，家庭和來源。<br />在<b>#pgv_lang[merge_to]#</b>字段中輸入合併完成後您希望成為新記錄的記錄的ID。<br />在<b>#pgv_lang[merge_from]#</b>字段中输入其信息将合并到#pgv_lang[merge_to]#记录中的记录的ID。此記錄將在合併後刪除。</li><li>您可以選擇合併時要保留兩條記錄的事實。只需單擊您旁邊的複選框即可。想要保留。</li><li>你檢查合併的結果，就像所有其他的一樣在線更改。</li></ol>有权接受的人必须授权您的更改使其永久化。";

//-- report engine
$pgv_lang["help_reportengine.php"] = "~报告~<br /><br />报告菜单中的条目将生成PDF文件进行打印。<br /><br />第一步是选择要运行的报告。选择报告后要运行，系统会要求您提供特定于该报告的一些信息，例如开始使用哪个个人或家庭以及是否显示照片。当您淮备好运行报告时，请单击<b>#pgv_lang[download_report]#</b>按钮将报告下载到您的计算机。<br /><br />#pgv_lang[help_xml_reports]#<br />#pgv_lang[def_pdf_format_help]#<br />#pgv_lang[help_ahnentafel.xml]#<br />#pgv_lang[help_birthlist.xml]#<br />#pgv_lang[help_relativelist.xml]#";
$pgv_lang["def_pdf_format_help"] = "~PDF文件格式~<br /><br /><br />網站報告引擎以Adobe PDF格式生成可下載的報告。本幫助文件中其他地方提到的GEDCOM5. 5.1標準規範也可以PDF格式下載。PDF是<b>P</b>ortable <b>D</b>ocument <b>F</b>ormat的首字母縮寫。";
$pgv_lang["help_ahnentafel.xml"] = "~#pgv_lang[ahnentafel_report]#~<br /><br />这是所选人和他的祖先的报告，以小册子格式打印。它从第一个人开始，然后继续他或她的父母，盛大 - 父母等。<br /><br />请注意，ahnentafel报告目前仅提供英文版本。";
$pgv_lang["help_birthlist.xml"] = "~#pgv_lang[birth_report]#~<br /><br />通过此报告，您可以列出在特定时间或地点出生的所有人。";
$pgv_lang["help_relativelist.xml"] = "~#pgv_lang[relatives_report]#~<br /><br />此报告将列出所选个人的所有亲属。您可以选择在报告中显示该人的亲属。<ul><li><b>#pgv_lang[child-family]#</b>将显示所选人员，他的父母以及他的兄弟姐妹。</li><li><b>#pgv_lang[spouse-family]#</b>将该人与他或她的配偶及其子女一同列出。</li><li><b>#pgv_lang[direct-ancestors]#</b>将列出该人，他的父母，祖父母，伟大的-grand-parents，并继续向上列出所有在这个人的血统中的父母的人。</li> <li><b>#pgv_lang[ancestors]#</b>将列出所有来自的人#pgv_lang[direct-ancestors]#列表，但也包括阿姨和叔叔以及姨妈和大叔，所以它将包括这个人的家谱中所有祖先的兄弟姐妹。它不会列出的孩子兄弟姐妹（表兄弟）。</li><li><b>#pgv_lang[后代]#</b>将列出这个人的所有内容后代（孩子，孙子，曾孙子等）。</li><li><b>#pgv_lang[all]#</b>此选项是#pgv_lang[descendants]#和的组合单个报告中的#pgv_lang[祖先]#。</li></ul>";
$pgv_lang["help_xml_reports"] = 	 "~报告引擎~<br /><br />网站报告引擎使用XML模板文件自动生成PDF报告。<br /><br /><b>#pgv_lang[select_report]#</b>列表中的报告是从报告中找到的XML文件生成的。\"reports\"目录。您可以通过复制所提供的任何模板并修改模板XML来创建自己的报告。要添加自定义报告，只需将其放在\"reports\"目录中，网站将自动检测它并在<b>#pgv_lang[select_report]#</b>下拉列表中将其显示.";

//-- Help Contents
$pgv_lang["help_contents_head_help"] = "<b>帮助内容</b>";
$pgv_lang["help_contents_gedcom_info"] = "GEDCOM信息";
$pgv_lang["help_contents_gedcom_places"] = "GEDCOM中的地方";

//-- Admin Help Contents Items
$pgv_lang["admin_help_contents_head_help"] = "<b>帮助内容<br /><br />管理员帮助条目</b>已添加到列表的开头。";
//$pgv_lang["ah1_help"] = "_升级";
$pgv_lang["ah2_help"] = "_Configure 网站";
$pgv_lang["ah3_help"] = "_GEDCOM：添加vs上传";
$pgv_lang["ah4_help"] = "_GEDCOM：配置文件";
$pgv_lang["ah5_help"] = "_GEDCOM：默认";
$pgv_lang["ah6_help"] = "_GEDCOM：删除";
$pgv_lang["ah7_help"] = "_GEDCOM：加";
$pgv_lang["ah8_help"] = "_GEDCOM：创造新的";
$pgv_lang["ah9_help"] = "_GEDCOM：下载";
$pgv_lang["ah10_help"] = 	 "_GEDCOM：管理页面";
$pgv_lang["ah11_help"] = 	 "_GEDCOM：组态";
$pgv_lang["ah12_help"] = "_GEDCOM：进口";
$pgv_lang["ah13_help"] = "_GEDCOM：上传";
$pgv_lang["ah14_help"] = "_GEDCOM：验证";
$pgv_lang["ah15_help"] = 	 "_GEDCOM：将ANSI转换为UTF-8";
$pgv_lang["ah16_help"] = "_GEDCOM：隐私设置";
$pgv_lang["ah17_help"] = "_用户管理";
$pgv_lang["ah18_help"] = "_行政";
$pgv_lang["ah19_help"] = "_GEDCOM：媒体工具";
$pgv_lang["ah20_help"] = "_GEDCOM：将个人ID更改为......";
$pgv_lang["ah21_help"] = "_翻译工具";
//          22 is in the help_text_vars.php
$pgv_lang["ah23_help"] = 	 "_配置支持的语言";
$pgv_lang["ah24_help"] = "_用户信息迁移（索引 - &gt;&gt;SQL）";
$pgv_lang["ah25_help"] = "_网站备份";
$pgv_lang["ah26_help"] = "_常见问题清单：编辑";

//--Statistics Help
$pgv_lang["help_statisticsplot.php"] = "~统计图~<br />这是结果页面，显示了数据库中统计信息的图形图，由上一页的输入定义。";
$pgv_lang["help_statistics.php"] = "~统计图~<br /><br />此页面允许您确定从数据库中生成各种统计数据的图形显示的标淮。";
$pgv_lang["stat_help"] = "~统计数据的选项~<br /><br />可以生成数据库中的许多不同的统计图。<br /><br />选择图表，然后从下拉列表中调整选项每个图中包含的数字取决于可用的数据。例如，没有出生月份的个体（例如，只是'1856'）不能包括在按月出生的图表中。";
$pgv_lang["stat_help_x"] = "~統計圖的選項~<br /><br />~X軸~<br />以下選項可用於X軸（水平）。然後將根據設置的選項顯示每個選項。 Y軸和Z軸。<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_11_mb]#</b>&nbsp;&nbsp;每個月出生的人。<br /><b>#pgv_lang[stat_12_md]#</b>&nbsp;&nbsp;每月去世的人。<br /><b>#pgv_lang[stat_13_mm]#</b>&nbsp;&nbsp;每個月發生的婚姻。<br /><b>#pgv_lang[stat_14_mb1]#</b>&nbsp;&nbsp;按月分列的每個家庭的首發人數。<br /><b>#pgv_lang[stat_15_mm1]#</b>&nbsp;&nbsp;每月初婚次數。<br /><b>#pgv_lang[stat_16_mmb]#</b>婚姻与第一个孩子出生之间的月数。<br /><b>#pgv_lang[stat_17_arb]#</b>&nbsp;&nbsp;去世年齡，與包含每個人出生年份的時間段相關。<br /><b>#pgv_lang[stat_18_ard]#</b>&nbsp;&nbsp;去世年齡，與時間有關包括每個人去世年份的內容。<br /><b>#pgv_lang[stat_19_arm]#</b>结婚时个人的平均年龄。<br /><b>#pgv_lang[stat_20_arm1]#</b>&nbsp;&nbsp;第一次婚姻時的個人平均年齡。<br /><b>#pgv_lang[stat_21_nok]#</b>&nbsp;&nbsp;平均家庭人數。<br /><b>#pgv_lang[stat_1_map]#</b>&nbsp;&nbsp;按國家/地區放置具有指定名稱的所有人員或人員。<br /><b>#pgv_lang[stat_2_map]#</b>&nbsp;&nbsp;出生國家。<br /><b>#pgv_lang[stat_4_map]#</b>&nbsp;&nbsp;結婚國家。<br /><b>#pgv_lang[stat_3_map]#</b>&nbsp;&nbsp;去世國家。<br /><b>#pgv_lang[stat_9_indi]</b>&nbsp;&nbsp;來源個人的餅圖。<br /><b>#pgv_lang[stat_8_fam]#</b>&nbsp;&nbsp;帶來源家庭的餅圖。</p>";
$pgv_lang["stat_help_y"] = "~統計圖的選項~<br /><br />~Y軸~<br /><br />以下選項可用於Y軸（垂直）。這些選項改變了條目的呈現方式顯示X軸。<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_201_num]#</b>&nbsp;&nbsp;顯示由X軸定義的每個類別中的個體數量。<br /><b>#pgv_lang[stat_202_perc]#</b>&nbsp;&nbsp;計算並顯示X軸類別中每個條目的比例。</p>";
$pgv_lang["stat_help_z"] = 	 "~OPTIONS FOR STATISTICS PLOTS~<br /><br />~Z AXIS~<br /><br />The following options are available for the Z axis. These options provide a sub-division of the categories selected for the X axis.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_300_none]#</b>&nbsp;&nbsp;displays the items as a single column for each X axis category.<br /><b>#pgv_lang[stat_301_mf]#</b>&nbsp;&nbsp;displays the items in 2 columns (male and female) for each X axis category.<br /><b>#pgv_lang[stat_302_cgp]#</b>&nbsp;&nbsp;displays the items in a number of columns related to the time periods set in the next section, for each X axis category.</p>";
$pgv_lang["stat_help_gwx"] = "~统计图的选项~<br /><br />~X轴的边界~<br /><br />选择所需的年龄间隔。<br /><br />例如，<b>#pgv_lang[aft_marr]#</b>描述了以下一组月份范围：<div style=\"padding-left: 30px;\">婚前<br />从结婚到8个月后<br />从8到12<br />从12到15<br />从15到18<br />从18到24<br />从24到48<br />结婚后48个月</div><br /><br />如果你想展示宿舍，你必须选择：<b>宿舍</b>。";
$pgv_lang["stat_help_gax"] = "~统计图的选项~<br /><br />~X轴的边界~<br /><br />选择所需的年龄间隔。<br /><br />例如，<b>区间10年</b>描述了以下一组年龄范围：<div style=\"padding-left: 30px;\">小于一年<br />一年到5年<br />6到10<br />11到20<br />21到30<br />31到40<br />41到50<br />51到60<br />61到70<br />71到80<br />81至90<br />91至100岁超过100年</div>";
$pgv_lang["stat_help_gbx"] = "~统计图的选项~<br /><br />~X轴的边界~<br /><br />选择所需的年龄间隔。<br /><br />例如，<b>区间2年</b>描述了以下一组年龄范围：<div style=\"padding-left: 30px;\">小于16岁<br />16至18<br />19至20岁> 21至22<br />23至24<br />25至26<br />27至28<br />29至30<br />31至32<br />33至35<br />36至40<br />41至50岁超过50年</div>";
$pgv_lang["stat_help_gcx"] = "~统计图的选项~<br /><br />~X轴的边界~<br /><br />选择所需的计数间隔。<br /><br />例如，<b>区间一个孩子</b>描述了以下一组子计数范围：<div style=\"padding-left: 30px;\">没有孩子<br />一个孩子<br />两个孩子<br />3，4，5，6，7，8，9，10个孩子<br />10个以上的孩子</div>";
$pgv_lang["stat_help_gwz"] = "~统计图的选项~<br /><br />~Z轴的范围~<br /><br />选择所需的起始年份和间隔<br /><br />例如，<b>从1700年间隔50年</b>描述了以下一组日期范围：<div style=\"padding-left: 30px;\">1700之前<br />1700至1749<br />1750至1799<br />1800至1849<br />1850至1899<br />1900至1949<br />1950至1999<br />2000或以后</div>";
$pgv_lang["chart_type_help"] = "~统计图选项~<br /><br />选择你想在地图上看到的内容。你可以选择：<p style=\"padding-left: 25px\"><b>#pgv_lang[indi_distribution_chart]#</b>&nbsp;&nbsp;显示此数据库中的人员所在的国家/地区。<br /><b>#pgv_lang[surname_distribution_chart]#</b>&nbsp;&nbsp;显示指定的国家/地区姓氏发生。</p>";
$pgv_lang["google_chart_surname_help"] = "~统计图的选项~<br /><br />指定名称的出现次数将显示在地图上。如果将此字段留空，将使用最常见的姓氏。";
$pgv_lang["chart_area_help"] = "~统计地图的选项~<br /><br />选择你想在地图上看到的地理区域。你可以选择：<p style=\"padding-left: 25px\"><b>#pgv_lang[world_chart]#</b>&nbsp;&nbsp;显示所有大陆。<br /><b>#pgv_lang[europe_chart]#</b>&nbsp;&nbsp;显示欧洲。<br /><b>#pgv_lang[s_america_chart]#</b>&nbsp;&nbsp;显示南美洲。<br /><b>#pgv_lang[asia_chart]#</b>&nbsp;&nbsp;显示亚洲。<br /><b>#pgv_lang[middle_east_chart]#</b>&nbsp;&nbsp;显示中东。<br /><b>#pgv_lang[africa_chart]#</b>&nbsp;&nbsp;显示非洲。</p>";

//-- Find Media Help
$pgv_lang["manage_media_help"] = "~#pgv_lang[manage_media]#~<br /><br />在此页面上，您可以轻松管理媒体文件和目录。<br /><br />当您创建新的媒体子目录时，网站将确保相同的目录结构在<b>#GLOBALS[MEDIA_DIRECTORY]#thumbs</b>目录中维护。当您上传新的媒体文件时，网站可以自动为您创建缩略图。<br /><br />在每个图像旁边在媒体列表中，您将找到以下选项。实际显示的选项取决于媒体文件的当前状态。<ul><li><b>#pgv_lang[edit]#</b>&nbsp;&nbsp;单击此选项，您将看到一个页面，您可以在其中更改Media对象的标题。如果Media对象尚未链接到当前活动数据库中的个人，家庭或源，则可以建立此链接您可以在<b>#GLOBALS[MEDIA_DIRECTORY]#</b>目录结构中重命名文件甚至更改其位置。必要时，网站会自动cr请填写所需的子目录或任何缺少的缩略图。</li><li><b>#pgv_lang[edit_raw]#</b>&nbsp;&nbsp;此选项仅在管理员启用时才可用。您可以查看或编辑与此Media对象关联的原始GEDCOM数据。使用此选项时应该非常小心。</li><li><b>#pgv_lang[delete_file]#</b>&nbsp;&nbsp;此选项可让您从当前数据库中删除所有媒体文件的知识。其他数据库不会受到影响。如果在任何其他数据库中未提及此媒体文件，则将删除该媒体文件及其关联的缩略图。</li><li><b>#pgv_lang[remove_object]#</b>&nbsp;&nbsp;此选项允许您从当前数据库中删除所有媒体文件的知识。其他数据库不会受到影响。媒体文件及其关联的缩略图不会被删除。</li><li><b>#pgv_lang[remove_links]#</b>&nbsp;&nbsp;此选项可让您删除媒体对象的所有链接当前的数据库。该文件不会被删除，并且将保留当前数据库已知该文件的Media对象。其他数据库不会受到影响。</li><li><b>#pgv_lang[set_link]#</b>&nbsp;&nbsp;此选项可让您在媒体文件与人员，家庭或来源之间建立链接当前数据库。必要时，网站还将创建Media对象，通过该对象可以知道数据库中的媒体文件。</li><li><b>#pgv_lang[gen_thumb]#</b>&nbsp;&nbsp;当您选择此选项时，网站将创建缺少的缩略图。</li></ul>";
$pgv_lang["simple_filter_help"] = "~#pgv_lang[filter]#~<br /><br />简单的搜索过滤器根据输入的字符，不接受任何通配符。";
$pgv_lang["show_thumb_help"] = "~#pgv_lang[show_thumbnail]#~<br /><br />如果勾选此框，将显示缩略图。";
$pgv_lang["new_dir_help"] = "~#pgv_lang[add_directory]#~<br /><br />作为管理员用户，您可以创建所需的目录结构，以保持媒体文件的有序性。从此页面创建目录可确保创建缩略图目录在每个目录中创建一个合适的index.php。<br /><br />点击此链接输入您要创建的目录的名称。";
$pgv_lang["find_media_help"] = "~#pgv_lang[find_media]#~<br /><br />这使您可以搜索文件结构，找到您想要链接的媒体条目。";

//-- Add/Edit Media Help
$pgv_lang["add_media_linkid"] = "~链接ID~<br /><br />每个媒体条目应与数据库中的一个或多个人，家庭或源记录相关联。<br /><br />要建立这样的链接，您可以在创建媒体条目的同时输入或搜索人员，家人或来源的ID。您也可以稍后通过Manage MultiMedia页面上的编辑选项建立链接，或通过添加媒体添加媒体条目个人，家庭或源详细信息页面上提供的链接。";
$pgv_lang["upload_server_file_help"] = "~#pgv_lang[server_file]#~<br /><br />您上传的媒体文件在服务器上的命名方式可能与在本地计算机上的命名方式不同。这是因为通常是本地文件名对你有意义，但对访问本网站的其他人来说意义不大。还要考虑你和其他人都试图上传名为\"granny.jpg\"的不同文件的可能性。<br /><br />在此字段中，您可以指定要上载的文件的新名称。您在此处输入的名称也将用于命名缩略图，可以单独上传或自动生成。您无需输入文件扩展名（jpg，gif，pdf，doc等。）<br /><br />将此字段留空以保留您从本地计算机上传的文件的原始名称。";
$pgv_lang["upload_server_folder_help"] = "~#pgv_lang[server_folder]#~<br /><br />管理员已在默认<b>#GLOBALS[MEDIA_DIRECTORY]#</b>下启用#GLOBALS[MEDIA_DIRECTORY_LEVELS]#文件夹级别。这有助于组织媒体文件并减少名称冲突的可能性。<br /><br />在此字段中，指定应存储上载媒体文件的目标文件夹。匹配的缩略图文件，可单独上传或自动生成，将存储在类似的文件夹结构中，从<b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>开始，而不是<b>#GLOBALS[MEDIA_DIRECTORY]#</b>。您无需输入<b>#GLOBALS[MEDIA_DIRECTORY]#</b>目标文件夹名称的一部分。<br /><br />如果您不确定要在此输入什么内容，请联系您的网站管理员以获取建议。";
$pgv_lang["view_server_folder_help"] = "~#pgv_lang[server_folder]#~<br /><br />管理员已在默认<b>#GLOBALS[MEDIA_DIRECTORY]#</b>下启用#GLOBALS[MEDIA_DIRECTORY_LEVELS]#文件夹级别。这有助于组织媒体文件并减少名称冲突的可能性。<br /><br />在此字段中，您选择要查看其内容的媒体文件夹。当您选择<b>#pgv_lang[all]#</b>，将显示所有媒体文件，而不考虑存储它们的文件夹。这可以产生很长的媒体条目列表。";

//--Repository Help
$pgv_lang["help_repolist.php"] = "~#pgv_lang[repo_list]#~<br /><br />此页面上显示了一个存储库列表。<br /><br />存储库的名称按字母顺序排序。<br /><br /><b>存储库</b><br />如果没有存储库，我们就无法构建我们的数据库。数据库中存储了所有信息的来源，并且该源存储在存储库中。存储库可以是个人存储库。存档一个人，一个机构，一个公共数据库，一个政府或教堂记录办公室，一个互联网资源等。要访问一个来源，我们将想知道它在哪里和在什么地方。所有必要的信息，以找到一个source应存储在Repository记录中。<br /><br />存储库可以链接到许多源。";
$pgv_lang["help_repo.php"] = "~#pgv_lang[repo_info]#~<br /><br />這裡顯示了存儲庫的詳細信息。與源代碼一起，存儲庫對於家譜研究人員非常重要。通過淮確的源和存儲庫信息，您可以跟踪另一位研究人員用來查找信息。您應該能夠再次找到相同的信息。<br /><br />在此頁面上，您可以看到有關存儲庫標題，地址，電子郵件和網頁的信息。<br /><在存儲庫詳細信息之後，將是鏈接到此存儲庫的所有源的列表。這允許您查看從特定存儲庫獲取的所有信息。<br /><br />如果啟用網站管理員，您將在此頁面上顯示一個或兩個菜單圖標：<br /><b>#pgv_lang[view_gedcom]#</b>，以GEDCOM格式顯示信息。<br /><b>#pgv_lang[add_to_cart]#</b>，它允許您將此信息存儲在#pgv_lang[clip_cart]#。从那里，您可以下载GEDCOM文件格式的信息，并将其导入您自己的家谱程序。<br /><br />#pgv_lang[context_help]#";
$pgv_lang["delete_repo_help"] = "~#pgv_lang[delete_repo]#~<br /><br />当您单击此选项时，您将此存储库标记为从数据库中删除。<br /><br />这是什么意思？<br />假设您有充分的理由从数据库中删除此存储库。您单击该链接。系统将要求您确认删除请求。如果您决定继续，可能需要一些时间才能看到存储库的消息删除。<br /><br />当您继续访问时，您会注意到存储库仍然可见，并且可以像没有发生删除一样使用。<br /><br /><b>这是<u>不</u>错误。</b>站点管理员将收到一条消息，表明已对数据库进行了更改，并且您已删除了存储库。<br />管理员可以接受或拒绝您的更改。只有在管理员接受您的更改后，才会实际删除<u>不可逆转</u>。如果对您的更改有任何疑问，管理员将与您联系。";
$pgv_lang["show_repo_gedcom_help"] = "~#pgv_lang[view_gedcom]#~<br /><br />单击此链接时，存储在数据库中的存储库信息将显示在弹出窗口中。";
$pgv_lang["add_repository_clip_help"] = "~#pgv_lang[add_to_cart]#~<br /><br />当您单击此链接时，您可以将存储在GEDCOM中的存储库添加到#pgv_lang[clip_cart]#。";
$pgv_lang["repolist_listbox_help"] = "~#pgv_lang[repo_list]#~<br /><br />在此框中，您可以看到存储库的名称，因为它们存储在数据库中。<br /><br />名称按字母顺序显示。单击列表中的名称后，您将转到#pgv_lang[repo_info]#页面，在该页面中，您将看到链接到该存储库的源列表。";
$pgv_lang["repos_listbox_help"] = "~#pgv_lang[other_repo_records]#~<br /><br />在此框中，您可以看到链接到存储库的源名称。<br /><br />名称按字母顺序显示。<br /><br />当您单击列表中的名称时，您将转到该源的详细信息页面。";

//Index-Edit
$pgv_lang["block_move_up_help"] = "~移动列表条目~<br /><br />使用这些按钮重新排列列表中条目的顺序。这些块将按列出的顺序打印。<br /><br突出显示要移动的条目，然后单击按钮向上或向下移动该条目。";
$pgv_lang["block_move_right_help"] = "~移動列表條目~<br /><br />使用這些按鈕將條目從一個列表移動到另一個列表。<br /><br />突出顯示要移動的條目，然後單擊按鈕移動或按箭頭方向複製該條目。使用<b>&raquo;</b>和<b>&laquo;</b>按鈕將突出顯示的條目從最左側列表移動到最右側列表，反之亦然。<b>&gt;</b>和<b>&lt;</b>按鈕可將#pgv_lang[available_blocks]#列表與列表右側或左側的突出顯示條目移動。<br /><br />無論您使用#pgv_lang[move_right]#和#pgv_lang[move_left]#按鈕執行什麼操作，#pgv_lang[available_blocks]#列表中的條目都不會更改。這是因為同一個塊可以多次出現在同一頁面上。HTML塊就是你可能想要這樣做的一個很好的例子。";
$pgv_lang["block_default_index"] = "~#pgv_lang上的默认块[welcome]#页面~<br /><br />当您从#pgv_lang[main_section]#和#pgv_lang[right_section]#列表中删除所有条目时，或者当您单击<b时>#pgv_lang[reset_default_blocks]#</b>按钮，阻止列表将设置如下：<br /><br /><span class='center'><table border =\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[block_cookiepolicy]#<br />#pgv_lang[gedcom_stats_block]#<br />#pgv_lang[gedcom_news_block]#<br />#pgv_lang[gedcom_favorites_block]#<br />#pgv_lang[review_changes_block]#</td><td>#pgv_lang[gedcom_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[todays_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></span>";
$pgv_lang["block_default_portal"] = "~#pgv_lang上的默认块[mygedview]#页面~<br /><br />当您从#pgv_lang[main_section]#和#pgv_lang[right_section]#列表中删除所有条目时，或者当您单击<b时>#pgv_lang[reset_default_blocks]#</b>按钮，阻止列表将设置如下：<br /><br /><span class='center'><table border =\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[todays_events_block]#<br />#pgv_lang[user_messages_block]#<br />#pgv_lang[user_favorites_block]#<br />&nbsp;</td><td>#pgv_lang[welcome_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[coming_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></span>";

//FAQ page
$pgv_lang["help_faq.php"] = "~常见问题~<br /><br />#pgv_lang[text_faq_help]#";
$pgv_lang["text_faq_help"] = "常见问题解答（常见问题解答）页面可以包含有关使用此系谱网站的概述或问题和答案列表。<br /><br />FAQ页面的用途完全取决于站点管理员。站点管理员控制每个条目的内容以及条目在页面上的显示顺序。";

//Help search
$pgv_lang["hs_title_help"] = "<span class='center'>~#pgv_lang[hs_title]#~</span><br />#pgv_lang[hs_intro]#<br /><br />#pgv_lang[hs_keyword_advice]#<br /><br />#pg_lang[hs_searchhow_advice]#<br /><br />#pgv_lang[hs_searchin_advice]#";
$pgv_lang["hs_intro"] = "你可以搜索网站的帮助系统。#pgv_lang[hs_title]#功能让你可以高度控制搜索功能;你应该能够轻松找到你想要的东西。";
$pgv_lang["hs_keyword_advice"] = "~#pgv_lang[hs_keyword]#~<br /><br />你輸入你想要找到的單詞或短語。<br /><br />搜索不注意案例（上面或下面）搜索術語或正在檢查的文本。这意味着如果您搜索<b>Individual</b>，您将找到包含<b>Individual</b>，<b>individual</b>或<b>INDIVIDUAL</b>的文本。 您还将找到包含<b>individuals</b>等的文本，因为搜索正在查找字符序列而不是单词。<br /><br />您可以讓搜索一次查找幾個單詞。輸入所有單詞，用空格分隔每個單詞，如下所示：<b>individual&nbsp;family&nbsp;child</b>。當輸入多個單詞時，含義您輸入的內容在#pgv_lang[hs_searchhow]#字段中闡明。";
$pgv_lang["hs_searchin_advice"] = "~#pgv_lang[hs_searchin]#~<br /><br />您可以在此确定搜索范围。<br /><br />管理员可以选择搜索用户帮助或配置帮助，或两者都有。没有这个选择;因为他们无法访问任何配置功能，他们只能搜索用户帮助文件。<br /><br />帮助文件不仅包含帮助文本，还包含用于构建输入的某些文本字符串表单和其他材料。此选项可让您控制是否应检查整个帮助文件，或者是否只应查看帮助文本。";
$pgv_lang["hs_searchhow_advice"] = "~#pgv_lang[hs_searchhow]#~<br /><br />您可以通過選擇此處顯示的可能性來澄清您在#pgv_lang[hs_keyword]#字段中輸入內容的含義。<br /><dl><dt><b>#pgv_lang[hs_searchany]#</b></dt><dd>如果您已输入<b>individual&nbsp;family&nbsp;child</b>，此选项将找到包含所列单词之一的帮助文本。单词的顺序无关紧要。搜索的含义是：\“查找帮助文本包含<b>individual</b><u>或</u><b>family</b><u>或</u><b>child</b>\”。</dd><dt><b>#pgv_lang[hs_searchall]#</b></dt><dd>如果你有進入<b>individual&nbsp;family&nbsp;child</b>，此選項會找到包含所有單詞的幫助文字。單詞的順序無關緊要。搜索的含義是：\"查找幫助文字包含<b>individual</b><u>和</u><b>family</b><u>和</u><b>child</b>\"。</dd><dt><b>#pgv_lang[hs_searchsentence]#</b></dt><dd>如果您已輸入<b>individual&nbsp;family&nbsp;child</b>，則s選項將找到包含給定順序中列出的所有詞的幫助文本。搜索的含義是：\"查找包含單詞<b>individual&nbsp;family&nbsp;child</b>的幫助文本，其中沒有其他單詞或字符在\"之間。您可能無法在任何幫助文本中找到此特定短語。<br /><br />此類搜索有一些限制。某些特殊字符，例如<b>&quot; &lt; &gt;</b>等以符號形式包含在幫助文本中，如果它們構成您輸入的文本的一部分，則無法找到。某些幫助文本包含由<b>&amp;nbsp;</b>表示的特殊類型的空格字符，您將找不到包含此字符的短語。</dd></dl>";

//Directory cleanup tool
$pgv_lang["help_dir_editor.php"] = "~#pgv_lang[index_dir_cleanup]#~<br /><br />这个工具可以帮助网站管理员清理索引目录中的文件。<br /><br />随着时间的推移，日志文件，旧GEDCOM等文件文件和旧备份文件可以在索引目录中建立。由于这些文件中有许多是由程序创建的，因此它们可能由Web服务器用户拥有。如果它们归Web服务器用户所有，则可能无法使用删除它们。即使这些文件归Web服务器用户帐户所有，也可以删除这些文件。<br /><br />#pgv_lang[index_dir_cleanup_inst]#";
?>
