<?php
/**
 * Chinese (Traditional) texts
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2019 to 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software;you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation;either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program;if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * @package PhpGedView
 * @version $Id: help_text.zh.php 7371 2024-02-07 01:04:20Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}
$pgv_lang["file_type_help"] = "~#pgv_lang[choose_file_type]#~<br /><br />選擇要創建數據庫導出的格式。您的選擇取決於您要導入新下載的程序的要求和功能您可以選擇：<ul><li>#pgv_lang[def_gedcom_help]#</li><li>#pgv_lang[def_gramps_help]#</li></ul>";
$pgv_lang["apply_privacy_help"] = "~#pgv_lang[apply_privacy]#~<br /><br />選中此選項後，輸出文件將根據所選選項通過隱私檢查。這可能會導致刪除某些信息。輸出文件將僅包含具有指示的權限級別的用戶通常可見的信息。<br /><br />如果您只有#pgv_lang[gedadmin]#权限，则无法指定输出文件应根据#pgv_lang[siteadmin]权限级别进行私有化。";
$pgv_lang["convertPath_help"] = "~#pgv_lang[convertPath]#~<br /><br />此選項定義一個常量路徑作為輸出文件中所有媒體路徑的前綴。<br /><br />例如，如果媒體目錄已被配置為\"/media\"，如果導出的媒體文件有一個路徑\"/media/pictures/xyz.jpg\"，你輸入了\"C:\\my pictures\\my family\"進入這個領域，最終的媒體路徑將是\"C:\\my pictures\\my family/pictures/xyz.jpg\"。<br /><br />你會注意到這個例子：<ul><li>當前媒體目錄名稱已從路徑</li><li>中刪除，並且生成的路徑將沒有正確的文件夾名稱分隔符。</li></ul><br />如果您希望保留在輸出文件的媒體文件路徑中的媒體目錄中，您需要在<b>#pgv_lang[convertPath]#</b>字段中包含該名稱。<br /><br />您還應該使用<b>#pgv_lang[convertSlashes]#</b>選項，以確保文件夾名稱分隔符一致並符合接收操作系統的要求m。<br /><br />實際URL的媒體路徑不會被更改。";
$pgv_lang["convertSlashes_help"] = "~#pgv_lang[convertSlashes]#~<br /><br />此選項確定媒體對象的FILE規範中的文件夾名稱是否應該用正斜杠或反斜杠分隔。您的選擇取決於接收操作的要求系統。<br /><br />選擇<b>#pgv_lang[forwardSlashes]#</b>適用於Microsoft Windows以外的大多數操作系統。選擇<b>#pgv_lang[backSlashes]#</b>目標程序在Microsoft Windows系統上運行時應使用><br /><br />實際URL的媒體路徑不會更改。";
$pgv_lang["medialist_recursive_help"] = "~#pgv_lang[medialist_recursive]#~<br /><br />选择此选项后，#pgv_lang[multi_title]#将不仅搜索从#pgv_lang[filter]#列表中选择的目录，还搜索其所有子目录。<br /><br />然后检查找到的所有媒体对象的标题，以确定它们是否包含在#pgv_lang[filter ]#中输入的文本。這兩個動作的結果決定了要列出的多媒體對象。";
$pgv_lang["medialist_unlinked_help"] = "~#pgv_lang[medialist_unlinked]#~<br /><br />只會顯示未鏈接到任何GEDCOM記錄的媒體。";
$pgv_lang["medialist_current_dir_help"] = "~#pgv_lang[medialist_current_dir]#~<br /><br />選擇您要查看的媒體子目錄。";
$pgv_lang["sortby_help"] = "~#pgv_lang[sortby]#~<br /><br />選擇您希望查看列表的順序。";
$pgv_lang["help_treenav.php"] = "~#pgv_lang[interactive_tree]#~<br /><br />使用#pgv_lang[interactive_tree]#在兩個方向上查看一個人的整個家譜。這個視圖類似於沙漏視圖，因為它顯示了同一個根人的祖先和後代。這個圖表通過顯示夫妻或家庭而不僅僅是個人的方框，為您提供更緊湊的視圖。<br /><ul><li><b>滾動</b><br />只要您的鼠標光標變為\"移動\"圖標，您就可以單擊並拖動樹以查看樹的其他部分。當您拖動樹時，後代將自動展開，直到沒有更多代可以在該方向上查看。<br /></li><li><b>縮放</b><br />您可以使用樹左側的圖標進行放大和縮小。縮小將允許您查看更多一次在屏幕上的樹。當你縮小時，文字會變得難以閱讀;當你的鼠標懸停在一個盒子上時，你會得到一個放大的視圖。<br /></li><li><b>更多细节</b><br />單擊任何框將展開框並顯示更詳細的視圖。在展开模式下，单击某个人的姓名将打开他们的#pgv_lang[indi_info]#页面。單擊<img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt=''/>將以該人重新繪製樹作為新根。單擊<img src='#GLOBALS[PGV_IMAGE_DIR]#/buttons/family.gif' alt=''/>將帶您進入該家庭的詳細信息頁面。<br /></li><li><b>切換配偶</b><br /><img src='#GLOBALS[PGV_IMAGE_DIR]#/small/sfamily.gif' width='15px' height='15px' alt=''/>圖標直接位於縮放按鈕下方在下降側打開或關閉所有配偶的顯示。當顯示器設置為顯示配偶時，所有人的配偶都將出現在包裝盒中。所有這些人的孩子也將被展示。當顯示配偶的選項關閉時，只會顯示該人的最後配偶和配偶的子女。<br /></li><li><b>大樹</b><br />#pgv_lang[interactive_tree]#可從許多不同的頁面獲得，包括#pgv_lang[indi_info]#頁面上的Tree選項卡和Welcome頁面上的Charts塊。從其他頁面查看樹時，您還將在縮放圖標下方有一個樹圖標。如果您點擊<img src ='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt=''/>，您将进入#pgv_lang[interactive_tree]#页面。</li></ul>";

$pgv_lang["move_mediadirs_help"] = "~#pgv_lang[move_mediadirs]#~<br /><br />啟用媒體防火牆後，多媒體文件可以存儲在無法從Internet訪問的服務器目錄中。<br /><br />這些按鈕允許您輕鬆移動受保護（不可通過網絡尋址）<b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b>和普通<b>#GLOBALS[之間]的整個媒體目錄結構MEDIA_DIRECTORY]#</b>目錄。";
$pgv_lang["setperms_help"] = "~#pgv_lang[setperms]#~<br /><br />遞歸設置受保護（不是網址）<b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b>的權限普通的<b>#GLOBALS[MEDIA_DIRECTORY]#</b>目錄是世界可寫或只讀的。";
$pgv_lang["no_update_CHAN_help"] = "~#pgv_lang[no_update_CHAN]#~<br /><br />管理員有時需要清理和更正用戶提交的數據。例如，他們可能需要更正PLAC位置以包含國家/地區。這些更正，通常會替換原始更改的信息。這可能是不可取的。<br /><br />選擇此選項後，網站將保留原始的更改信息，而不是將其替換為當前會話的信息。選擇此選項後，管理員還可以修改或刪除與原始CHAN標記關聯的信息。";
$pgv_lang["edit_SOUR_EVEN_help"] = "~#pgv_lang[source_events]#~<br /><br />每個來源記錄特定事件，通常是針對給定的日期範圍和地方管轄區。例如，人口普查記錄人口普查事件和教會記錄記錄出生，婚姻，和去世事件。<br /><br />從提供的事件列表中選擇此源記錄的事件。日期應以範圍格式指定，例如<i>FROM 1900 TO 1910</i>。地方管轄權是包含該來源中所有下級地方的最低管轄區的名稱。例如，\"Oneida, Idaho, USA\"将被用作奥奈达县各镇的事件来源的管辖区。如果记录的事件不仅发生在奥奈达县，而且发生在爱达荷州的其他县，则\"Idaho, USA\"是管辖区。";
$pgv_lang["cache_life_help"] = "~#pgv_lang[cache_life]#~<br /><br />為了提高性能，這個PhpGedCom歡迎頁面塊保存為緩存文件。您可以控制刷新緩存文件的頻率。<br /><br /><ul><li><b>-1</b>表示緩存文件永遠不會自動刷新。要獲取新的副本，您需要刪除所有緩存文件。您可以在自定義歡迎中執行此操作頁面。</li><li><b>0</b>（零）表示此塊永遠不會被緩存，每次在網站歡迎頁面上顯示該塊時，您都會看到一個新的副本。自動用於頻繁更改的塊，例如#pgv_lang[logged_in_users_block]#和#pgv_lang[random_media_block]#分段。</li><li><b>1</b>（一）表示新鮮每天創建此塊緩存文件的副本，<b>2</b>表示每兩天創建一個新副本，<b>7</b>表示每週創建一個新副本等。</li></ul>";
$pgv_lang["clear_cache_help"] = "~#pgv_lang[clear_cache]#~<br /><br />為了提高性能，網站歡迎頁面上的幾個塊都被保存為索引目錄中的緩存文件。大多數塊的緩存文件都刷新了每天一次，但有時您可能需要手動刷新它們。<br /><br />此按鈕允許您在必要時刷新緩存文件。";
$pgv_lang["import_options_help"] = "您可以選擇在導入GEDCOM時使用的其他選項。";
$pgv_lang["verify_gedcom_help"] = "在這裡，您可以選擇繼續上傳和導入此GEDCOM文件，也可以中止上傳和導入。";
$pgv_lang["add_gedcom_instructions"] = "輸入這個新GEDCOM的文件名。新的GEDCOM文件將在索引目錄中創建：#INDEX_DIRECTORY#";
$pgv_lang["random_media_start_slide_help"] = "~#pgv_lang[random_media_start_slide]#~<br /><br />幻燈片顯示是否應在頁面加載時自動啟動。<br /><br />幻燈片改變了塊的內容而不從服務器預加載信息並且沒有重新加載整個頁面。";
$pgv_lang["random_media_ajax_controls_help"] = "~#pgv_lang[random_media_ajax_controls]#~<br /><br />您可以使用此設置來顯示或隱藏隨機媒體塊的幻燈片控件。<br /><br />這些控件允許用戶跳轉另一個隨機對像或通過隨機選擇的媒體播放，如幻燈片。幻燈片改變了塊的內容，無需從服務器預加載信息，也無需重新加載整個頁面。";
$pgv_lang["edit_add_unlinked_source_help"] = "~#pgv_lang[add_unlinked_source]#~<br /><br />使用此鏈接向數據庫添加新源，而不將源鏈接到另一條記錄中的源引文。新源將出現在源列表中，但在鏈接到源引文之前，它不會出現在任何圖表或程序中的任何其他位置。";
$pgv_lang["edit_add_unlinked_note_help"] = "~#pgv_lang[add_unlinked_note]#~<br /><br />使用此鏈接向數據庫添加新的共享註釋，而不將註釋鏈接到任何記錄。<br /><br />新註釋將出現在共享筆記列表中，但在鏈接到個人，家庭或事件之前，不會出現在任何圖表或程序中的任何其他位置。";
$pgv_lang["link_person_id_help"] = "~#pgv_lang[label_local_id]#~<br /><br />在此字段中輸入您要鏈接的人的ID（例如I100）。";
$pgv_lang["link_gedcom_id_help"] = "~#pgv_lang[label_gedcom_id]#~<br /><br />使用此部分選擇包含您要鏈接的人的備用數據庫標識符。";
$pgv_lang["link_remote_site_help"] = "~#pgv_lang[label_site]#~<br /><br />在本節中，您將指定連接到託管您要鏈接的數據的遠程站點所需的參數。您可以選擇從列表中進行選擇您之前使用過的已知網站，或輸入#pgv_lang[label_site_url2]#和#pgv_lang[label_gedcom_id]#以獲取新網站。<br /><br />在<b>#pgv_lang[label_site_url2]#</b>字段，您輸入URL以訪問Web服務描述文件（WDSL），該文件告訴網站如何訪問遠程站點上的數據。對於遠程網站，WSDL文件的URL將如下所示： u> http://www.remotesite.com/phpGedView/genservice.php?wsdl </u><br /><br /><b>#pgv_lang[label_gedcom_id]#</b>字段用於輸入一個可選的數據庫標識符，用於需要一個的遠程站點。對於網站站點，這是GEDCOM文件的名稱。<br /><br /><b>#pgv_lang[label_username_id]#</b>和<b>#pgv_lang[label_password_id]#</b>字段是必需的如果數據庫需要它。<br /><br /><i>注意：遠程網站站點必須運行4.0或更高版本;早期版本沒有此功能。</i>";
$pgv_lang["link_remote_location_help"] = "~#pgv_lang[label_location]#~<br /><br />此選項允許您選擇要鏈接的人的數據是在同一站點上，還是在不同的族譜數據庫集中，或者數據是否為在可通過互聯網訪問的其他網站上。<br /><br />如果此人在同一網站上，則會要求您選擇數據集標識符並輸入此人的ID。<br /><br />遠程站點，將要求您輸入其URL，數據庫標識符和此人的遠程ID。";
$pgv_lang["link_remote_rel_help"] = "~#pgv_lang[label_rel_to_current]#~<br /><br />使用此選項可選擇遠程人員與您在網站上鍊接他們的人之間的關係。例如，選擇<i>父親</i>意味著遠程站點上的人是您將他們鏈接到本地​​的人的父親。";
$pgv_lang["link_remote_help"] = "~#pgv_lang[link_remote]#~<br /><br />使用此表單將人們鏈接到其他網站或您的網站副本可訪問的其他系譜數據庫。<br /><br />添加這樣的鏈接，您必須首先選擇關係類型，然後選擇網站已知的站點或定義一個新站點，然後輸入該站點的您想要鏈接的人的ID。然後網站將自動從該站點下載信息。必要的遠程站點。下載的信息<u>不</u>成為您的家譜數據庫的一部分;它保留在原始站點上，但被合併到顯示此遠程鏈接人員的各個頁面中。<br /><有關該元素的更多信息，請參閱頁面上每個元素旁邊的\"幫助\"鏈接。您還可以查看在線英語教程以獲取更多信息：<a href=\"#PGV_PHPGEDVIEW_WIKI#/en/index.php?title=How_To:Remote_Link_Individuals_Across_Websites_And_Databases\" target=\"_ blank\">#PGV_PHPGEDVIEW_WIKI#</a>。";

//-- Edit Interface
$pgv_lang["edit_ABBR_help"] = "~縮寫標題~<br /><br />使用此字段存儲標題的縮寫版本。此字段與源上的標題字段一起使用。默認情況下，PGV將首先使用標題然後縮寫標題。<br /><br />根據GEDCOM 5.5規範，\"此條目是提供用於分類，歸檔和檢索源記錄的簡短標題（第62頁）。\"<br /><br />在網站中，縮寫標題是可選的，但在其他家譜程序中則是必需的。";
$pgv_lang["edit_ROMN_help"] = "~浪漫的名字~<br /><br />在許多文化中，習慣上有一個傳統名稱拼寫的傳統字符，也是一個羅馬化版本的名稱，因為它將拼寫或發音為基於拉丁語的語言字母，如英語。<br /><br />如果您希望使用希臘語，希臘語，俄語，中文或阿拉伯語等非拉丁字母輸入標淮名稱字段中的名稱，那麼您可以使用此字段使用拉丁字母輸入相同的名稱。名稱的兩個版本都將出現在列表和圖表中。<br /><br />雖然此字段標記為\"Romanized\"，但不限於僅包含基於拉丁字母的字符。這可能與日語名稱一起使用，其中可能出現三個不同的字母。";
$pgv_lang["edit_ROMN_GIVN_help"] = "#pgv_lang[edit_ROMN_help]#<br /><br />在此字段中，您應該輸入該人的給定名稱。例如，在名稱\"John Robert Finlay\"中，應輸入給定的名稱這裡是\"John Robert\"";
$pgv_lang["edit_ROMN_SURN_help"] = "#pgv_lang[edit_ROMN_help]#<br /><br />在此字段中，您應輸入此人的姓氏。例如，在名稱\"John Robert Finlay\"中，應輸入的姓氏為\"Finlay\"<br /><br />有多個姓氏的個人，在西班牙和葡萄牙很常見，應該用逗號分隔姓氏。這表明該人將被列在每個姓名下。例如，姓氏\"Cortes,Vega\"將列在<b>C</b>和<b>V</b>之下，而姓氏\"Cortes Vega\"只会在<b>C</b>下列出。";
$pgv_lang["edit__HEB_help"] = "~希伯來名稱~<br /><br />在許多文化中，習慣上有傳統名稱拼寫的傳統名稱以及名稱的羅馬化版本，因為它將以基於拉丁語的語言拼寫或發音字母，如英文。<br /><br />如果您更喜歡使用拉丁字母在標淮名稱字段中輸入名稱，那麼您可以使用此字段在非拉丁字母表中輸入相同的名稱，例如希臘語，希伯來語，俄語，阿拉伯語或中文。名稱的兩個版本都將出現在列表和圖表中。<br /><br />雖然此字段標有\"希伯來語\"，但不限於僅包含希伯來字符。";
$pgv_lang["edit__HEB_GIVN_help"] = "#pgv_lang[edit__HEB_help]#<br /><br />在此字段中，您應該輸入該人的給定名稱。例如，在名稱\"John Robert Finlay\"中，應輸入給定的名稱這裡是\"John Robert\"";
$pgv_lang["edit__HEB_SURN_help"] = "#pgv_lang[edit__HEB_help]#<br /><br />在此字段中，您應輸入此人的姓氏。例如，在名稱\"John Robert Finlay\"中，應輸入的姓氏為\"Finlay\"<br /><br />有多個姓氏的個人，在西班牙和葡萄牙很常見，應該用逗號分隔姓氏。這表明該人將被列在每個姓名下。例如，姓氏\"Cortes,Vega\"將列在<b>C</b>和<b>V</b>之下，而姓氏\"Cortes Vega\"只会在<b>C</b>下列出。";
$pgv_lang["edit_SEX_help"] = "#pgv_lang[edit_sex_help]#";
$pgv_lang["edit_NAME_help"] = "#pgv_lang[edit_name_help]#";
$pgv_lang["edit_add_unlinked_person_help"] = "~#pgv_lang[add_unlinked_person]#~<br /><br />使用此表單添加未鏈接的人。<br /><br />當您將未鏈接的人添加到您的家譜中時，此人將不會鏈接到任何其他人，直到您鏈接它們。之后，您可以通过#pgv_lang[indi_info]页面上的#pgv_lang[relatives]#标签将人们链接在一起。";
$pgv_lang["edit_URL_help"] = "~#factarray[URL]#~<br /><br />輸入包含http://的URL地址。示例：<b>http://www.phpgedview.net/</b><br /><br />如果您不想包含URL，請將此字段留空。";
$pgv_lang["edit_WWW_help"] = "~#factarray[WWW]#~<br /><br />輸入網頁主頁地址，包括http://。示例：<b>http://www.phpgedview.net/</b><br /><br />如果您不想包含Web主頁地址，請將此字段留空。";
$pgv_lang["edit_EMAIL_help"] = "~#factarray[EMAIL]#~<br /><br />輸入電子郵件地址。示例：<b>name@hotmail.com</b><br /><br />如果您將此字段留空不想包含電子郵件地址。";
$pgv_lang["edit_FAX_help"] = "~#factarray[傳真]#~<br /><br />輸入傳真號碼，包括國家和地區代碼。例如，德國的號碼可能是+49 25859 56 76 89以及美國或加拿大的號碼可能是+1 888 555-1212。​​​​<br /><br />如果您不想包含傳真號碼，請將此欄位留空。";
$pgv_lang["edit_PHON_help"] = "~#factarray[PHON]#~<br /><br />輸入電話號碼，包括國家和地區代碼。例如，德國的電話號碼可能是+49 25859 56 76 89以及美國或加拿大的電話號碼可能是+1 888 555-1212。​​​​<br /><br />如果您不想包含電話號碼，請將此字段留空。";
$pgv_lang["edit_ADDR_help"] = "~#factarray[ADDR]#~<br /><br />在信封上輸入地址就像在信封上寫一樣。<br /><br />如果你不想要這個字段留空包括一個地址。";
$pgv_lang["edit_GIVN_help"] = "#pgv_lang[edit_given_name_help]#";
$pgv_lang["edit_SPFX_help"] = "~姓氏前綴~<br /><br />輸入或選擇姓氏主要部分之前的單詞。例如<b>von</b> Braun，<b>van der</b> Kloot，<b>de</b> Graaf等";
$pgv_lang["edit_SURN_help"] = "#pgv_lang[edit_surname_help]#";
$pgv_lang["edit_NSFX_help"] = "#pgv_lang[edit_suffix_help]#";
$pgv_lang["edit__MARNM_help"] = "~#factarray[_MARNM]#~<br /><br />使用適用於姓名字段的相同格式規則輸入此人的已婚姓名。此字段是可選的。<br /><br />例如，如果Mary Jane Brown與John White結婚，您可以輸入（當然沒有引號）<ul><li>美國用法：&nbsp;&nbsp;\"Mary Jane Brown /White/\"</li><li>歐洲用法：&nbsp;&nbsp;\"Mary Jane /White/\"</li><li>歐洲替代用法：&nbsp;&nbsp;\"Mary Jane /White-Brown/\"或\"Mary Jane /Brown-White/\"</li> </ul>只有在瑪麗·布朗與約翰·懷特結婚後才開始以新名稱稱呼自己時，你應該這樣做。例如，在某些地方，例如魁北克省（加拿大），名字是非法的以這種方式改變。<br /><br />男人有時在結婚後改名，通常使用帶連字符的形式，但偶爾也會取妻子的姓氏。";
$pgv_lang["edit_PEDI_help"] = "~#factarray[PEDI]#~<br /><br />這個字段描述了孩子與家人的關係。可能性是：<ul><li><b>#pgv_lang[unknown]#</b>&nbsp;&nbsp;&nbsp;無法確定孩子與家人的關係。選擇此選項後，#factarray[PEDI]#字段將不會被複製到數據庫中。<br /><br /></li><li><b>#factarray[BIRT]#</b>&nbsp;&nbsp;&nbsp;此選項表示孩子出生時與其家庭有關。<br /><br /></li><li><b>#pgv_lang[adopted]#</b>&nbsp;&nbsp;&nbsp;該選項表明該兒童已被其家庭收養。這<i>不</i>表明孩子與其家人之間沒有血緣關係;它表明孩子在孩子出生後的某個時間被這個家庭收養。<br /><br /></li><li><b>#pgv_lang[foster]#</b>&nbsp;&nbsp;&nbsp;該選項表明該兒童是該家庭的寄養兒童。通常，孩子與家人之間沒有血緣關係。<br /><br /></li><li><b>#pgv_lang[sealing]#</b>&nbsp;&nbsp;&nbsp;這個孩子在LDS<i>冊封</i>儀式上被封為家人。在父母在孩子出生後此冊封時進行兒童冊封。父母冊封後出生的孩子將自動與家人冊封。<br /><br /></li></ul>";
$pgv_lang["edit_AGNC_help"] = "~#factarray[AGNC]#~<br /><br />有權威的組織，機構，公司，個人或其他實體。<br /><br />例如，一個人的雇主，或管理儀式或活動的教堂，或負責創建和/或存檔記錄的組織。";

$pgv_lang["context_help"] = "點擊頁面上條目旁邊的<b>？</b>可以獲得更多幫助。";

$pgv_lang["register_gedcomid_help"] = "~#pgv_lang[gedcomid]#~<br /><br />數據庫中的每個人都有一個唯一的ID號碼。如果您知道自己記錄的ID號，請在此輸入。如果您不在由於隱私設置，我們不知道您的身份證號碼或找不到它，請在\"註釋\"字段中提供足夠的信息，以幫助網站管理員確定您在此網站上的身份，以便他為您設置ID。";
$pgv_lang["register_comments_help"] = "~#pgv_lang[comments]#~<br /><br />使用此字段告訴網站管理員您申請帳戶的原因以及您與本網站上顯示的家譜有何關聯。您也可以使用此字段輸入您對網站管理員的任何其他評論。";
$pgv_lang["utf8_ansi_help"] = "~從UTF-8轉換為ANSI~<br /><br />為了在Internet上進行最佳顯示，網站使用UTF-8字符集。例如，某些程序，例如Family Tree Maker，不支持導入編碼的GEDCOM文件在UTF-8中。選中此框會將文件從<b>UTF-8</b>轉換為<b>ANSI (ISO-8859-1)</b>。<br /><br />格式您需要的程序取決於您用來處理下載的GEDCOM文件的程序。如果您不確定，請參閱該程序的文檔。<br /><br />請注意，要保持特殊字符保持不變，您需要保持文件為UTF-8並將其轉換為程序的方法，通過其他方式處理這些特殊字符。請諮詢程序的製造商或作者。<br /><br />這<a href='http://en.wikipedia.org/wiki/UTF-8' target='_blank' title='維基百科文章'><b>維基百科文章</b></a>包含有關UTF-8的綜合信息和鏈接。";
$pgv_lang["remove_tags_help"] = "~刪除自定義PGV標記~<br /><br />選中此選項將刪除可能已被網站添加到記錄中的任何自定義標記。<br /><br /> 網站使用的自定義標記包括<b> _PGVU</b>標記用於標識在線更改記錄的用戶以及<b>_THUM</b>標記，該標記告訴網站圖像應該用作縮略圖。<br /><br />自定義將下載的GEDCOM導入另一個家譜應用程序時，標籤可能會導致錯誤。";
$pgv_lang["download_zipped_help"] = "~下載GEDCOM作為ZIP文件~<br /><br />當您選中此選項時，GEDCOM文件的副本將在下載開始前壓縮為ZIP格式。這將大大減小其大小，但您需要使用兼容的Unzip程序（例如WinZIP）解壓縮傳輸的GEDCOM文件，然後才能使用它。<br /><br />這是下載大型GEDCOM文件的有用選項。下載的風險很大未壓縮文件的時間可能超過允許的最大執行時間，導致文件下載不完整.ZIP選項應將下​​載時間減少75%。";
$pgv_lang["edit_NCHI_help"] = "~#factarray[NCHI]#~<br /><br />輸入此個人或家庭的子女數量。這是一個可選字段。";
$pgv_lang["edit_TIME_help"] = "~#factarray[TIME]#~<br /><br />以前導零的24小時格式輸入此活動的時間。午夜為00:00。例如：04:50 13:00 20:30。";
$pgv_lang["edit_NOTE_help"] = "~#factarray[注意]#~<br /><br />註釋是自由格式的文本，將出現在頁面的\"事實詳細信息\"部分。";
$pgv_lang["edit_SHARED_NOTE_help"] = "~#pgv_lang[shared_note]#~<br /><br />共享筆記是自由格式文本，將顯示在頁面的\"事實詳細信息\"部分。<br /><br />每個共享筆記都可以鏈接不止一個人，家庭，來源或事件。";
$pgv_lang["edit_CEME_help"] = "~#factarray[CEME]#~<br /><br />輸入埋葬個人的墓地名稱或其他安息地點。";
$pgv_lang["edit_ASSO_help"] = "~#factarray[ASSO]#~<br /><br />輸入關聯的GEDCOM ID。";
$pgv_lang["edit_RELA_help"] = "~#factarray[RELA]#~<br /><br />從列表中選擇一個關係名稱。選擇<b>教父</b>意味著：<i>這位員工是當前個人的教父</i>。";
$pgv_lang["show_spouse_help"] = "~#pgv_lang[show_spouses]#~<br /><br />默認情況下，此圖表不顯示後代的配偶，因為它會使圖表更難閱讀和理解。啟用此選項將在圖表上顯示配偶。";
$pgv_lang["reorder_families_help"] = "~#pgv_lang[reorder_families]#~<br /><br />#pgv_lang[親戚]#選項卡上的家庭按其出現在個人GEDCOM記錄中的順序顯示。家庭未按結婚日期排序因為結婚日期通常是未知的，但婚姻的順序<u>是</u>已知。<br /><br />项允许您更改#pgv_lang[relatives]#选项卡中列出的系列的顺序。 如果您想按结婚日期对家庭进行排序，只需按一下按钮即可自动完成。";
$pgv_lang["autoContinue_help"] = "~#pgv_lang[autoContinue]#~<br /><br />當網站檢測到GEDCOM導入需要的時間超過時間限制允許的時間時，它將顯示<b>#pgv_lang[del_proceed]#</b>按鈕必須按才能繼續導入。<br /><br />當此選項設置為<b>#pgv_lang[yes]#</b>時，網站將自動按<b>#pgv_lang[del_proceed]#</b>按鈕給你。這樣可以減輕繁瑣的進口時必須反复按下按鈕的麻煩。";
$pgv_lang["firstname_i_help"] = "~#pgv_lang[firstname_alpha_index]#~<br /><br />你選擇的姓氏超過#GLOBALS[SUBLIST_TRIGGER_I]#個人。<br /><br />為了幫助你找到你想要的人，根據人名的第一個字母將列表分成較小的列表。這個按字母順序排列的子索引的工作方式與姓氏的字母索引相同。<br /><ul><li>點擊一個字母查看全部</li> <li>選擇<b>#pgv_lang[NN]#</b>列出所有姓名不明的人。</li><li>選擇<b>#pgv_lang[all]#</b>將顯示所有具有先前姓氏的人員的列表。</li></ul>因為名稱很多，所以此列表可能需要很長時間才能顯示出現在你的屏幕上。";
$pgv_lang["firstname_f_help"] = "~#pgv_lang[firstname_alpha_index]#~<br /><br />您選擇的姓氏超過#GLOBALS[SUBLIST_TRIGGER_F]#個人。<br /><br />為了幫助您找到您想要的家庭，根據人名的第一個字母將列表分成較小的列表。這個按字母順序排列的子索引的工作方式與名稱的字母索引相同。<br /><ul><li>點擊一個字母查看所有以該字母開頭的名字。</li><li>選擇<b>#pgv_lang[NN]#</b>列出所有姓名不明的人。</li><li>選擇<b>#pgv_lang[all]#</b>將顯示所有具有先前選擇姓氏的家庭的列表。</li></ul>因為名稱很多，所以此列表可能需要很長時間出現在你的屏幕上。";
$pgv_lang["edit_TYPE_help"] = "~#factarray[TYPE]#~<br /><br />#factarray[TYPE]#字段用於輸入有關該條目的其他信息。在大多數情況下，該字段是完全自由格式的，您可以輸入你想要的任何東西。";
$pgv_lang["edit_TEMP_help"] = "~#factarray[TEMP]#~<br /><br />對於LDS法令，這個字段記錄了寺廟的執行地點。";
$pgv_lang["edit_STAT_help"] = "~#factarray[STAT]#~<br /><br />這是一個可選的狀態字段，主要用於LDS條例，因為它們通過TempleReady程序運行。";
$pgv_lang["edit__PRIM_help"] = "~#factarray[_PRIM]#~<br /><br />使用此字段表示此媒體項是其所附人員的突出顯示或主要條目。突出顯示的圖像是將使用的圖像在圖表和個人頁面上。";
$pgv_lang["edit__THUM_help"] = "~#factarray[_THUM]#~<br /><br />此選項可讓您覆蓋縮略圖圖像的常用選項。<br /><br />GEDCOM有一個配置選項，指定是否應發送網站噹噹前頁面需要縮略圖時，大圖像或小圖像到瀏覽器。&laquo;#factarray[_THUM]#&raquo;選項，當設置為<b>#pgv_lang[yes]#</b>時，會暫時覆蓋設置GEDCOM配置選項，以便網站始終發送大圖像。當GEDCOM配置指定應始終使用大圖像時，不能強製網站發送小圖像。<br /><br />網站沒有重新調整正在發送的圖像的大小;瀏覽器根據它收到的頁面規範執行此操作。當發送的圖像不是真正的網站期望發送小圖像的縮略圖時，這會產生不良後果。這不是錯誤：有時可能需要顯示a在人們通常期望看到縮略圖大小的圖片的地方的大圖像。<br /><br />你應該避免設置&laquo;#factarray[_THUM]#&raquo;選項<b>#pgv_lang[yes]#</b>。此選擇將導致過多的圖像相關據被發送到瀏覽器，只是讓瀏覽器丟棄多餘的數據。頁面加載，尤其是包含許多圖像的圖表，可能會嚴重減慢。";
$pgv_lang["edit_TITL_help"] = "~#factarray[TITL]#~<br /><br />輸入您正在編輯的條目的標題。如果這是多媒體條目的標題，請輸入一個描述性標題，以便向用戶標識該條目。 ";
$pgv_lang["edit_FILE_help"] = "~#factarray[FILE]#~<br /><br />這是多媒體對象記錄中最重要的字段。它表示要使用的文件。至少，您需要輸入文件的名稱。在您的設置上，有關文件位置的更多信息可能會有​​所幫助。<br /><br />您可以使用<b>#pgv_lang[find_media]#</b>鏈接來幫助您找到已經存在的媒體條目上傳到網站。<br /><br />#pgv_lang[readme_help]#";
$pgv_lang["edit_FORM_help"] = "~#factarray[FORM]#~<br /><br />這是一個可選字段，可用於輸入多媒體對象的文件格式。一些家譜程序可能會查看此字段以確定如何處理但是，由於媒體不能很好地跨計算機系統傳輸，因此這個領域並不是很重要。";
$pgv_lang["generate_thumb_help"] = "~#pgv_lang[auto_thumbnail]#~<br /><br />您的系統可以自動為某些類型的圖像生成縮略圖。可能支持BMP，GIF，JPG和PNG文件。您的系統支持的類型複選框旁邊會列出。<br /><br />單擊此復選框，系統會通知系統您正在上傳此類圖像，並希望它嘗試為它們生成縮略圖。如果您未選中該複選框想要提供自己的縮略圖。";
$pgv_lang["edit_add_NOTE_help"] = "~#pgv_lang[add_note]#~<br /><br />本部分允許您為當前正在編輯的事實添加新註釋。註釋是自由格式文本，將顯示在\"事實詳細信息\"部分中。這一頁。";
$pgv_lang["edit_add_SHARED_NOTE_help"] = "~#pgv_lang[add_shared_note]#~<br /><br />~#pgv_lang[edit_shared_note]#~<br /><br />共享筆記，如常規筆記，是自由格式文本。與常規筆記不同，每個共享筆記可以鏈接到多個人，家庭，來源或事實。<br /><br />通過單擊相應的圖標，您可以建立指向現有共享筆記的鏈接或創建新的共享筆記和如果已經建立了現有共享筆記的鏈接，您還可以編輯該筆記的內容。<br /><ul><li><b>鏈接到現有的共享筆記</b><div style=\"padding-left: 20px;\">如果您已經知道所需共享筆記的ID編號，您可以直接在該字段中輸入該編號。<br /><br />當您點擊<b>#pgv_lang[find_shared_note]#</b>圖標，您將能夠搜索所有現有共享筆記的文本，然後選擇其中一個。所選筆記的ID號將輸入到該字段中自動。<br /><br />你必須點擊<b>#pgv_lang[add]#</b>按鈕更新原始記錄。</div><br /></li><li><b>創建新的共享註釋</b><div style=\"padding-left:20px;\">單擊<b>#pgv_lang[create_shared_note]#</b>圖標時，將打開一個新窗口。您可以根據需要輸入新筆記的文本。與常規備註一樣，您可以輸入URL。<br /><br />當您單擊<b>#pgv_lang[save]#</b>按鈕時，您將看到一條消息，其中包含新創建的ID號共享筆記。您應該單擊此消息以關閉編輯窗口，並將該新ID號直接複製到ID號字段中。如果您只是關閉窗口，則不會自動複製新創建的ID號。<br /><br />您必須單擊<b>#pgv_lang[add]#</b>按鈕更新原始記錄。</div><br /></li><li><b>編輯現有的共享筆記</b><div style=\"padding-left:20px;\">點擊<b>#pgv_lang[edit_shared_note]#</b>圖標，將打開一個新窗口。您可以根據需要更改現有共享筆記的文本。與常規筆記一樣，您可以輸入URL。<br /><br />當您單擊<b>#pgv_lang[save]#</b>按鈕時，將更新共享筆記的文本。您可以關閉窗口，然後再次單擊<b>#pgv_lang[save]#</b>按鈕。<br /><br />當您更改共享筆記的文本時，您的更改將反映在所有該共享筆記當前鏈接到的位置。您進行更改後建立的新鏈接也將使用更新後的文本。</div></li></ul>";
$pgv_lang["edit_add_GEDFact_ASSISTED_help"] = "~使用GEDFACT ASSISTANT~<br /><br />單擊\"+\"圖標將打開GEDFact Shared Note Assistant窗口。<br />將在那裡找到具體的幫助。<br /><br />單擊\"保存\"按鈕時，將在此處粘貼共享註釋的ID。";
$pgv_lang["edit_add_SOUR_help"] = "~#pgv_lang[add_source]#~<br /><br />本部分允許您為當前正在編輯的事實添加新的源引文。<br /><br />在輸入的\"源\"字段中輸入如果您需要輸入新來源，請單擊<b>#pgv_lang[create_source]#</b>鏈接。在\"引文詳細信息\"字段中，您可以輸入可能有助於找到人的頁碼或其他信息源中的信息。在文本字段中，您將從源輸入文本轉錄。";
$pgv_lang["edit_add_ASSO_help"] = "~#pgv_lang[add_asso]#~<br /><br />#pgv_lang[add_asso]#允許您將事實與站點中的關聯人員鏈接。這是您可能記錄某人是某人的一種方式另一個人的教父。";
$pgv_lang["edit_QUAY_help"] = "~#factarray[QUAY]#~<br /><br />您可以使用此字段記錄此來源中的數據的質量或可靠性。許多家譜應用程序使用該字段中的數字。<b>3</b>可能意味著數據是主要來源，<b>2</b>可能意味著它是次要來源，<b>1</b>可能意味著信息有問題，並且<b>0</b>可能意味著來源不可靠。";
$pgv_lang["edit_PAGE_help"] = "~#factarray[PAGE]#~<br /><br />在\"引文詳細信息\"字段中，您可以輸入可能有助於某人在源中查找信息的頁碼或其他信息。";
$pgv_lang["edit_TEXT_help"] = "~#factarray[TEXT]#~<br /><br />在這個字段中你可以輸入這個來源的引文。數據的例子可能是來源的文本轉錄，或者是什麼的描述在引文中。";
$pgv_lang["edit_SOUR_help"] = "~#factarray[SOUR]#~<br /><br />此字段允許您更改此事實的源引文鏈接到的源記錄。此字段採用源ID。旁邊的字段將列出標題當前來源ID。使用<b>#pgv_lang[find_id]#</b>鏈接查找來源的ID號。要刪除整個引文，請將此字段留空。";
$pgv_lang["edit_edit_raw_help"] = "~#pgv_lang[edit_raw]#~<br /><br />此頁面允許您編輯原始GEDCOM記錄。您應謹慎使用此頁面;它需要很好地理解GEDCOM 5.5.1標淮。有關GEDCOM 5.5.1標淮的更多信息，請參閱幫助主題<b>GEDCOM文件</b>。<br /><br />網站提供了許多添加和編輯信息的方法，但有時您可能會想要編輯原始的GEDCOM結構。如果可能，你應該使用提供的表格來添加信息，但是如果不可能，你可以使用這個表格。提交表格後，我們將檢查你的信息是否符合標淮和CHAN記錄將被更新。";
$pgv_lang["add_from_clipboard_help"] = "~#pgv_lang[add_from_clipboard]#~<br /><br />網站允許您將最多10個事實及其所有細節複製到剪貼板。這個剪貼板與您可以用來導出的剪貼板不同數據庫的一部分。<br /><br />您可以從剪貼板中選擇任何事實，並將所選事實複製到當前正在編輯的個人，家庭，媒體，來源或存儲庫記錄。但是，您無法複製不同記錄類型的事實。例如，您不能將婚姻事實複製到來源或個人記錄，因為婚姻事實僅與家庭記錄相關。<br /><br />這在輸入類似事實時非常有用，例如人口普查事實，對很多個人或家庭而言。";
$pgv_lang["edit_PLAC_help"] = "~#factarray[PLAC]#~<br /><br />地方應根據家譜標淮輸入。在家譜中，地方首先記錄有關該地點的最具體信息，然後進行至少工作特定的地方最後，用逗號分隔不同的地方級別。你記錄地方信息的級別應該代表保存該地方重要記錄的政府或教堂的級別。<br /><br />例如，鹽湖城這樣的地方將被稱為\"Salt Lake City, Salt Lake, Utah, USA\"。<br /><br />讓我們來看看這個地方的每個部分。第一部分，\"Salt Lake City,\"事件發生的城市或鄉鎮。在一些國家，城市內可能有重要的城市或區域。在這種情況下，他們應該來到城市之前。下一部分，\"Salt Lake,\"是縣。\"Utah,\"是一个州，而\"USA\"就是这个国家。重要的是要注意每個地方，因為基因每個級別的政府都保存著邏輯記錄。<br /><br />如果某個地方的水平未知，你應該在逗號之間留一個空格。假設，在上面的例子中，你不知道鹽湖城的縣。你應該記錄下來：\"Salt Lake City, , Utah, USA\"。假設你只知道一個人出生在猶他州。您可以輸入如下信息：\", , Utah, USA\"。<br /><br />您可以使用<b>#pgv_lang[find_place]#</b>鏈接來幫助您查找數據庫中已存在的位置。";
$pgv_lang["edit_LATI_help"] = "~#factarray[LATI]#~<br /><br />通常不鼓勵輸入特定的緯度和經度坐標，因為它只允許從特定元素的視圖進行映射訪問。最好管理地理位置。 <br /><br />但是，輸入緯度和經度確實可以更精確地控制標記。";
$pgv_lang["edit_LONG_help"] = "~#factarray[LONG]#~<br /><br />通常不鼓勵輸入特定的緯度和經度坐標，因為它只允許從特定元素的視圖進行映射訪問。最好管理地理位置。 <br /><br />但是，輸入緯度和經度確實可以更精確地控制標記。";
$pgv_lang["edit_add_parent_help"] = "~添加新的母親或父親~<br /><br />通過此頁面，您可以向選定的人添加新的母親或父親。如果已知，請填寫新人的姓名和出生和去世信息。你不知道一些信息，請留空。<br /><br />要添加除生與死之外的其他事實，首先通過保存更改將新人添加到數據庫中。然后在更新的家庭页面或#pgv_lang[relatives]#选项卡中单击此人的姓名，以查看此人的#pgv_lang[indi_info]#页面。在#pgv_lang[indi_info]#页面中，您可以添加更多详细信息。";
$pgv_lang["edit_add_spouse_help"] = "~添加新的丈夫或妻子~<br /><br />通過此頁面，您可以向選定的人添加新的丈夫或妻子。如果已知，請填寫新人的姓名和出生和去世信息。你不知道一些信息留空。<br /><br />要添加除生與死之外的其他事實，首先通過保存更改將新人添加到數據庫中。然后在更新的家庭页面或#pgv_lang[relatives]#选项卡中单击此人的姓名，以查看此人的#pgv_lang[indi_info]#页面。在#pgv_lang[indi_info]#页面中，您可以添加更多详细信息。";
$pgv_lang["edit_death_help"] = "~#pgv_lang[death]#~<br /><br />這個區域允許你輸入去世信息。首先輸入去世的日期，以家譜的標淮日期格式（1 JAN 2004）。你可以點擊在日曆圖標上幫助選擇日期。然後輸入該人去世的地方。您可以使用<b>#pgv_lang[find_place]#</b>鏈接選擇數據庫中已存在的位置。";
$pgv_lang["edit_birth_help"] = "~#pgv_lang[出生]#~<br /><br />這個區域允許您輸入出生信息。首先輸入出生日期為家譜的標淮日期格式（1 JAN 2004）。可以單擊日曆圖標以獲取幫助選擇日期。然後輸入人員出生的地方。您可以使用<b>#pgv_lang[find_place]#</b>鏈接選擇數據庫中已存在的位置。";
$pgv_lang["edit_sex_help"] = "~#pgv_lang[sex]#~<br /><br />從下拉列表中選擇適當的性別。<b>未知</b>選項表示性別未知。";
$pgv_lang["edit_name_help"] = "~#pgv_lang[name]#~<br /><br />這是一個人姓名記錄中最重要的字段。<br /><br />當填寫其他字段時，該字段應自動填寫，但提供的是您可以根據個人喜好編輯信息。<br /><br />此字段中的名稱應根據GEDCOM 5.5.1標淮輸入，姓氏包含正斜杠\"/\"。例如，名稱\"John Robert Finlay Jr.\"應該像這樣輸入：\"John Robert /Finlay/ Jr.\"。";
$pgv_lang["edit_suffix_help"] = "~#pgv_lang[suffix]#~<br /><br />在這個可選字段中，你應該為人輸入名稱後綴。名稱後綴的例子是\"Sr.\"，\"Jr. \"，和\"III\"。";
$pgv_lang["edit_surname_help"] = "~#pgv_lang[surname]#~<br /><br />在此字段中，您應該輸入該人的姓氏。例如，在名稱\"John Robert Finlay\"中輸入應該輸入的姓氏這裡是\"Finlay\"<br /><br />有多個姓氏的個人，在西班牙和葡萄牙很常見，應該用逗號分隔姓氏。這表明這個人將被列在每個姓名下面。例如，姓氏\"Cortes, Vega\"將列在<b>C</b>和<b>V</b>之下，而姓氏\"Cortes Vega\"只会在<b>C</b>下列出。";
$pgv_lang["edit_NICK_help"] = "~#factarray[NICK]#~<br /><br />在這個字段中你應該為這個人輸入任何暱稱。<br />這是一個可選字段。<br /><br />添加方法暱稱：<ul><li>選擇<b>修改名稱</b>然後輸入暱稱並保存</li><li>選擇<b>添加新名稱</b>然後輸入暱稱和名稱並保存</li><li>選擇<b>編輯GEDCOM記錄</b>以添加從屬於[1&nbsp;NAME]記錄的多個[2&nbsp;NICK]記錄。</li></ul>";
$pgv_lang["edit_given_name_help"] = "~#pgv_lang[given_name]#~<br /><br />在此字段中，您應輸入該人的給定名稱。例如，在名稱\"John Robert Finlay\"中，應該給出的名稱應該是進入這裡是\"John Robert\"。";
$pgv_lang["edit_NPFX_help"] = "~名稱前綴~<br /><br />此可選字段允許您輸入名稱前綴，例如\"Dr.\"或\"Adm. \"";
$pgv_lang["edit_add_child_help"] = "~#pgv_lang[add_child]#~<br /><br />使用此頁面，您可以向選定的家庭添加新的孩子。填寫孩子的姓名以及出生和去世信息（如果已知）。你不知道一些信息留空。<br /><br />要添加除生與死之外的其他事實，首先通過保存更改將新孩子添加到數據庫中。然后在更新的系列页面或#pgv_lang[relatives]#选项卡中单击子项名称以查看子项的#pgv_lang[indi_info]#页面。從#pgv_lang[indi_info]#頁面，您可以添加更詳細的信息。";
$pgv_lang["review_changes_help"] = "~取消更改~<br /><br />此塊將列出所有已在線更改的記錄，但仍需要在數據庫中進行審核和接受。";
$pgv_lang["quick_update_name_help"] = "~更新名稱~<br /><br />使用\"更新名稱\"字段更改您正在編輯的人的姓名。在\"給定姓名\"字段中輸入該人的姓名或名字。在\"姓氏\"字段中輸入人的姓氏或姓氏。例如，如果您要輸入的名稱是\"John Robert Finlay\"，那麼您將在\"給定名稱\"字段中輸入\"John Robert\"，在\"姓氏\"字段中輸入\"Finlay\" 。<br /><br />填寫這些字段將<u>更改</u>該人的姓名;它不會添加新名稱。<br /><br /><i>注意：你如果名字由於新婚而改變，則<u>不</u>使用此方法。而是使用選項在下面添加新的丈夫。</i>";
$pgv_lang["quick_update_fact_help"] = "~更新事實~<br /><br />使用\"更新事實\"字段添加新的事實信息或更改您正在編輯的記錄的現有事實。首先從下拉列表中選擇一個事實然後在家譜的標淮日期格式（1 JAN 2004）中輸入該事實發生的日期。您可以單擊日曆圖標以獲取幫助選擇日期。然後輸入發生該事實的位置。您可以使用<b>#pgv_lang[find_place]#</b>鏈接以選擇數據庫中已存在的位置。<br /><br />與此表單上的所有其他字段一樣，您的信息將替換已存在的字段或者它會根據需要創建新條目。";
$pgv_lang["quick_update_address_help"] = "~更新地址~<br /><br />使用\"更新地址\"字段更改您正在編輯的人的地址，電話號碼或電子郵件地址。<br /><br />在此表單上的所有其他字段中，您的信息將替換已存在的字段，或者根據需要創建新條目。";
$pgv_lang["quick_update_spouse_help"] = "~添加新的丈夫或妻子~<br /><br />當您想要為您正在編輯的人添加新的丈夫或妻子時，請使用這些字段。在字段中輸入新配偶的姓名和出生信息，然後根據婚姻信息輸入他們結婚的日期。以家譜的標淮日期格式輸入日期（1 JAN 2004）。您可以點擊日曆圖標以獲取幫助選擇日期。您可以使用<b>#pgv_lang[find_place]]#</b>鏈接選擇數據庫中已存在的地方。<br /><br />這些字段只會添加<i>新</i>合作夥伴;他們不會更新信息要編輯已錄製人員的信息，請關閉此窗口並在#pgv_lang[relatives]#選項卡中單擊該人員的姓名。然後單擊編輯個人菜單以編輯信息。";
$pgv_lang["quick_update_marriage_help"] = "~更新婚姻~<br /><br />如果你想記錄新的婚姻，你可以使用這些字段和字段來添加新的丈夫或妻子。否則在這些字段中輸入數據將改變有關該人的信息最後一次婚姻。以家譜的標淮日期格式輸入日期（1 JAN 2004）。您可以點擊日曆圖標以獲取幫助選擇日期。您可以使用<b>#pgv_lang[find_place]#</b>鏈接選擇數據庫中已存在的位置。";
$pgv_lang["quick_update_child_help"] = "~添加一個新的孩子~<br /><br />使用這些字段為這個人添加一個新的孩子。首先輸入孩子的名字並選擇性別。然後輸入孩子出生的日期和地點。家譜的標淮日期格式的日期（1 JAN 2004）。您可以點擊日曆圖標以獲取幫助選擇日期。您可以使用<b>#pgv_lang[find_place]#</b>鏈接選擇一個地方已存在於數據庫中。<br /><br />這些字段只會添加一個<u>新兴</u>子項。它們不會更新已記錄的子項的信息。編輯某人的信息誰已經在數據庫中，關閉此窗口並在#pgv_lang[relatives]#選項卡中單擊該人的姓名。然後單擊編輯個人菜單以編輯信息。";
$pgv_lang["index_top10_pageviews_help"] = "~最常見的條目塊~<br /><br />此塊將列出本網站訪問者已查看的前10個人，家庭或來源。為了顯示此塊，網站管理員必須擁有啟用了條目命中計數器。";
$pgv_lang["index_cookiepolicy_help"] = "~#pgv_lang[block_cookiepolicy]#~<br /><br />此塊顯示該站點的cookie策略。";
$pgv_lang["cookiepolicy_link_help"] = "~#pgv_lang[block_cookiepolicy_link]#~<br /><br />如果您想使用標淮文本，請將此字段留空。<br /><br />如果您希望使用標淮文本並提供鏈接到包含特定於您網站的Cookie政策的詳細信息的文本文件或HTML頁面，您可以在此處輸入該網頁的網址。<br /><br />例如，<b>http://foo.bar.com/policy/cookies.txt</b>可能指向純文本文件，而<b>http://foo.bar.com/policy/cookies.htm</b>指向HTML格式頁面和<b>http://foo.bar.com/policy/cookies.doc</b>指向Microsoft Word格式的文檔。";
$pgv_lang["cookiepolicy_link_advice"] = "留空以使用標淮文本。<br />輸入一個URL，例如<b>http://foo.bar.com/policy/cookies.txt</b>，指向特定於站點的策略頁面。";
$pgv_lang["useradmin_user_default_tab_help"] = "~USER DEFAULT選項卡設置~<br /><br />此设置允许您指定用户访问#pgv_lang[indi_info]#页面时自动打开的选项卡。如果允許編輯他們的帳戶，用戶可以更改這個設置稍後。";
$pgv_lang["edituser_user_default_tab_help"] = "~USER DEFAULT選項卡設置~<br /><br />此设置允许您指定访问#pgv_lang[indi_info]#页面时自动打开的选项卡。";
$pgv_lang["reorder_children_help"] = "~#pgv_lang[reorder_children]#~<br /><br />孩子們按照他們出現在家庭記錄中的順序顯示。孩子不會按出生日期自動分類，因為孩子的出生日期通常是不確定，但他們的出生順序<u>是</u>已知。<br /><br />此選項將允許您更改家庭記錄中的孩子的順序。因為您可能想要排序孩子們按照他們的出生日期，有一個按鈕可以按下來為你做這個。<br /><br />你也可以拖放任何信息框來改變孩子的順序。當你移動將鼠標光標放在信息框上，其形狀將變為一對雙頭交叉箭頭。如果在移動鼠標光標前按住鼠標左鍵，信息框將在鼠標光標上下移動。列表。當信息框被移動時，其他框將騰出空間。當您釋放鼠標左鍵時，信息盒子將在列表中佔據新的位置。";
$pgv_lang["rss_feed_help"] = "~RSS飼料設置~<br /><br />網站中提供的ATOM/RSS提要允許任何人使用合適的飼料聚合器查看您網站歡迎頁面的內容，而無需訪問該網站。大多數聚合器都會彈出通知讓用戶知道被監控頁面上的內容何時發生變化。這實際上允許任何人監控您的網站，而無需定期訪問。<br /><br />Feed塊用於自定義鏈接到Feed，允許特定的Feed類型（大多數讀者可以處理大多數類型，因此通常可以保留默認值），以及您希望在Feed中使用的特定模塊。Feed的語言和使用的GEDCOM將基於選擇Feed時，語言和GEDCOM在網站中處於​​活動狀態。<br /><br />可生成的Feed類型包括ATOM，RSS 2.0，RSS 1.0，RSS 0.92，HTML和JavaScript。前四種類型是對於Feed聚合器，而JavaScript和HTML旨在實現包含其他網頁中的Feed。請注意，RSS提要的編號表示不同的樣式，而不是不同的版本。<br /><br />有一個選項可以選擇將用戶登錄的身份驗證，並允許用戶使用合適的RSS進行查看聚合器，登錄時通常可以查看的任何信息。基本身份驗證使用<i>基本HTTP身份驗證</i>來登錄用戶。未來的增強功能可能允許<i>摘要式身份驗證</i>。<br /><br />這個<a href='http://en.wikipedia.org/wiki/RSS_(file_format)' target='_blank' alt='Wikipedia文章' title='維基百科文章'><b>維基百科文章</b></a>包含有關RSS和各種RSS格式的全面信息和鏈接。<i>基本HTTP身份驗證</i>在<a href='http://en.wikipedia.org/wiki/Basic_authentication_scheme' target='_ blank' alt='維基百科文章' title='維基百科文章'中討論><b>維基百科文章</b></a>，而<i>摘要認證</i>中討論在<a http://en.wikipedia.org/wiki/Digest_access_authentication' target='_ blank' alt='維基百科文章' title='維基百科文章'><b>維基百科文章</b></a>。";

$pgv_lang["upload_media_folder_help"] = "~#pgv_lang[folder]#~<br /><br />您的GEDCOM配置最多允許#GLOBALS[MEDIA_DIRECTORY_LEVELS]#目錄級別超出默認<b>#GLOBALS[MEDIA_DIRECTORY]#</b>所在的上傳媒體通常存儲文件。這使您可以組織媒體文件，而不必擔心為每個媒體文件維護唯一的名稱。<br /><br />在此字段中，您可以指定目標目錄要存儲上傳的媒體文件的服務器。請務必注意您輸入的內容（大寫或小寫）或在此處選擇，因為文件和目錄名稱區分大小寫。<br /><br />如果您在此處輸入的目錄名稱不存在，則會自動創建。如果您輸入的GEDCOM配置允許的其他#GLOBALS[MEDIA_DIRECTORY_LEVELS]#目錄級別超過了您的輸入，那麼您的輸入將被截斷。<br /><br />縮略圖將以相同的目錄結構上傳或創建，從<b>#G開始LOBALS[MEDIA_DIRECTORY]#thumbs/</b>。";
$pgv_lang["upload_media_file_help"] = "~#pgv_lang[media_file]#~<br /><br />在此字段中，您可以在本地計算機上指定要上傳到服務器的媒體文件的位置和名稱。您可以使用<b>瀏覽</b>按鈕，在本地計算機上搜索所需的文件。<br /><br />上傳的文件在服務器上將具有相同的名稱，並將上傳到<b中指定的目錄>#pgv_lang[folder]#</b>字段。<br /><br />如果您沒有看到<b>#pgv_lang[folder]#</b>字段或無法更改它，則表示您沒有足夠的權限或您的GEDCOM配置已設置為不允許超出默認<b>#GLOBALS[MEDIA_DIRECTORY]#</b>的目錄級別。在這種情況下，媒體文件將上傳到目錄<b>#GLOBALS[ MEDIA_DIRECTORY]#</b>。";
$pgv_lang["upload_thumbnail_file_help"] = "~#pgv_lang[thumbnail]#~<br /><br />在此字段中，您可以在本地計算機上指定要上傳到服務器的縮略圖文件的位置和名稱。您可以使用<b>瀏覽</b>按鈕在本地計算機上搜索所需的文件。填寫此字段後，將忽略<b>#pgv_lang[auto_thumbnail]#</b>複選框。<br /><br />如果已填寫<b>#pgv_lang[media_file]#</b>字段，則無論在本地計算機上調用的內容如何，​​都將根據該字段的內容命名上傳的縮略圖文件。為空，上傳的縮略圖文件將被複製到服務器上的兩個位置，一旦進入<b>#pgv_lang[folder]#</b>字段中提到的服務器目錄，然後再次進入相同的目錄結構，從<b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>。<br /><br />如果您沒有看到<b>#pgv_lang[folder]#</b>字段或無法更改它，沒有足夠的權限或您的GEDCOM配置已被設置為不允許超出默認<b>#GLOBALS[MEDIA_DIRECTORY]#</b>的目錄級別，其中通常存儲上載的媒體文件。";

//-- GENERAL
$pgv_lang["help_header"] = "相關信息：";
$pgv_lang["privacy_error_help"] = "~私人詳情~<br /><br />此消息可能有以下幾種原因：<br /><br /><ul><li><b>有關生活人士的信息設為\"私人\"</b><br />如果系统管理员允许，访问者可以通过单击“登录”按钮，然后单击#pgv_lang[requestaccount]#链接来注册帐户。<br /></li><li><b>您是擁有用戶名和密碼的用戶...</b><br />但您尚未成功登錄或者您已經登錄暫停了一段時間，你的會話超時了。<br /></li><li><b>由於隱私</b><br />此人根本不想顯示（隱藏）和可能已經要求管理員將他或她設置為\"私人\"。隱私可以設置為：<br /><ol><li>#pgv_lang[PRIV_USER]#</li><li>#pgv_lang[PRIV_NONE]#</li><li>#pgv_lang[PRIV_HIDE]#</li></ol></li><li><b>在关系路径之外</b><br />即使您是常规用户<u>和</u>已登录，如果您尝试查看的人在关系步骤数内与您无关，您仍会看到此消息（關係路徑長度）由本网站管理员为此GEDCOM设置。<br /><br />示例：<當關係路徑長度設置為<b>1</b>時，您只能看到您自己的家庭，父親，母親，兄弟，姐妹（但不是您兄弟或姐妹的配偶和子女）的詳細信息）當關係路徑設置為<b>2</b>時，您還可以查看您兄弟的妻子及其子女（但不是孩子的配偶）的詳細信息。<br /><br />關係路徑長度設置越高，您可以看到的遠程親屬越多。<br /></li></ul><br />如果您認為自己有資格查看某些隱藏的詳細信息，請聯繫網站管理員。使用任何頁面上的聯繫鏈接。";
$pgv_lang["more_help"] = "<br />每個屏幕都提供上下文幫助;請確保\"幫助\"菜單中的<b>#pgv_lang[show_context_help]#</b>選項已打開，然後單擊<b>？</b>在主題旁邊。";
$pgv_lang["more_config_help"] = "<br /><b>更多幫助</b><br />#pgv_lang[context_help]#";
$pgv_lang["start_admin_help"] = "+++ 启动其他管理员信息 +++";
$pgv_lang["end_admin_help"] = "---結束額外管理信息---";
$pgv_lang["multiple_help"] = "<span class='center'> ---這是多頁的一般幫助文字--- </span>";
$pgv_lang["header_general_help"] = "<div class='name_head center'><b>一般信息</b></div>";
$pgv_lang["best_display_help"] = "~你的屏幕~<br /><br />網站的屏幕尺寸為1024x768像素。這應該是讓所有東西都能正常顯示的最小尺寸。<br /><br />如果你把尺寸設置為較低的值（例如800x600），您可能需要在某些頁面上進行水平滾動。";
$pgv_lang["preview_help"] = "~打印~<br /><br />單擊打印版本鏈接將刪除打印頁面上看起來不太好的條目（菜單，輸入框，額外鏈接，上下文幫助的問號，在頁面底部的打印機友好版本中，您將看到頁面底部的<b>打印</b>鏈接。只需單擊它，您的打印機對話框就會彈出打印後，只需單擊<b>後退</b>鏈接，屏幕就會正常重建。<br /><br />注意：雖然\"打印機友好版本\"刪除了許多鏈接顯示頁面，其餘鏈接仍然可以點擊。";
$pgv_lang["readme_help"] = "有關詳情，請參閱<a href=\"readme.txt\" target=\"_blank\"><b>Readme.txt</b></a>。";
$pgv_lang["is_user_help"] = "---這個幫助文本與網站訪問者將閱讀的文本相同.---<br />---為了節省空間，我們沒有為此條目製作特殊的管理文本. ---";
$pgv_lang["edit_raw_gedcom_help"] = "~編輯RAW GEDCOM~<br /><br />當您點擊此鏈接時，將打開一個新窗口，其中包含此頁面上詳細信息的原始GEDCOM數據。<br /><br />您可以在此編輯GEDCOM數據直接。請務必輸入有效的GEDCOM 5.5.1數據，因為不會進行進一步的有效性檢查。更改或添加的數據將在網站中顯示為\"更改\"，並且必須由用戶接受接受權利。";
$pgv_lang["RESN_help_title"] = "設定對事實的限制";
$pgv_lang["RESN_help"] = "~#pgv_lang[RESN_help_title]#~<br /><br />除了一般的隱私設置外，網站還可以為個人和家庭設置查看和編輯事實信息的限制。限制可以由任何人設置。允許編輯信息，除非隱私或以前設置的限制禁止這樣做。<br /><br />可以使用以下值：<br /><ul><li><b>#pgv_lang[none]#</b><br />網站管理員，GEDCOM管理員和有權編輯的用戶可以更改信息。可以根據管理員應用的隱私設置查看事實信息。</li><li><b>#pgv_lang[locked]#</b><br />此設置對事實數據的可見性沒有影響。它限制了對網站管理員和GEDCOM管理員的編輯權限。如果該信息為用戶所有，他也可以查看，如果他也有編輯權限，則可以進行編輯。</li><li><b>#pgv_lang[privacy]#</b><br />網站管理員和GEDCOM管理員可以查看和編輯信息。如果該信息為用戶所有，他可以查看，如果假設他也具有編輯權限，則可以對其進行輯。無論是否登錄如何，它都將對其他用戶隱藏。</li><li><b>#pgv_lang[confidential]#</b><br />只有網站管理員和GEDCOM管理員才能查看和編輯信息。無論是否登錄，它都將對其他用戶隱藏。</li></ul><br /><table><tr><th></th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">管理員</th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">所有者</th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">其他</th></tr><tr><th></th><th></th><th>R</th><th>W</th><th></th><th>R</th><th>W</th><th></th><th>R</th><th>W</th></tr><tr><td><img src=\"images/RESN_none.gif\" alt=\"\" />&nbsp;#pgv_lang[none]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_locked.gif\" alt=\"\" />&nbsp;#pgv_lang[locked]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /><th></th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_privacy.gif\" alt=\"\" />&nbsp;#pgv_lang[privacy]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_confidential.gif\" alt=\"\" />&nbsp;#pgv_lang[confidential]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr></table><ul><li>R : 可以查看</li><li>W : 可以编辑</li><li><img src=\"images/checked_qm.gif\" alt=\"\"/> : 取决于全球隐私设置</li></ul>";


//-- Pages Help-messages
//-- Index-page
$pgv_lang["index_help"] = "~歡迎頁面~<br /><br />此頁面是歡迎頁面。歡迎您訪問所選的<a href=\"#def_gedcom\">GEDCOM</a>文件。您可以返回此頁面從頂部菜單中選擇歡迎頁面。如果此站點上有多個GEDCOM，您可以從下拉菜單中選擇一個GEDCOM。<br /><br />此幫助頁麵包含以下信息：<ul><li><a href=\"#index_portal\"><b>歡迎頁面</b></a></li><li><a href=\"#header\"><b>標題區</b></a></li><li><a href=\"#menu\"><b>菜單</b></a></li><li><a href=\"#header_general\"><b>一般信息</b></a></li><li><a href=\"#def\"><b>定義</b></a></li></ul>";

//-- Index-page Header
$pgv_lang["header_help"] = "<div class='name_head center'><b>HEADER AREA</b></div><br />標題顯示在每個頁面的頂部。標題包含一些有用的鏈接，您可以在整個頁面中使用網站。<br /><br />由於此網站可能具有不同的外觀，具體取決於所選的<a href=\"#def_theme\">主題</a>，標題可能會受到影響，鏈接可能會有所不同。<br /><br />您可能會找到的鏈接是：<ul><li><a href=\"#header_search\"><b>搜索框</b></a></li><li><a href=\"#header_lang_select\"><b>語言選擇器</b></a> </li><li><a href=\"#header_user_links\"><b>用戶鏈接</b></a></li><li><a href=\"#header_favorites\"><b>收藏夾</b></a> </li><li><a href=\"#header_theme\"><b>更改主題</b></a></li></ul>";
$pgv_lang["header_search_help"] = "~標題區：搜索框~<br /><br />這個搜索框體積小但功能強大。您可以隨時為網站搜索任何內容。當您點擊<b>&gt;</b>或<b>搜索</b>按鈕，您將鏈接到\"搜索\"頁面以查看搜索結果。您可以在\"搜索\"頁面上找到有關搜索選項的大量幫助。";
$pgv_lang["header_lang_select_help"] = "~標題區：語言選擇器~<br /><br />網站最重要的功能之一是支持多種語言。<br /><br />網站顯示所有頁面的語言自動確定根據瀏覽器的\"首選語言\"設置。但是，站點管理員可能限制了某些語言的可用性。<br /><br />根據站點配置，您可以通過選擇一個來更改網站的語言。更合適的語言來自下拉列表或單擊標誌圖標。如果您是註冊用戶，您可以配置網站在您登錄後切換到您的首選語言，無論您的瀏覽器設置為什麼。";
$pgv_lang["header_user_links_help"] = "~標題區域：用戶鏈接~<br />用戶鏈接是一個小塊，其中包含有用的鏈接，可以在每個頁面的相同位置找到。這些鏈接的位置根據當前主題的不同而不同效果。<br /><br />未登錄時，您只會看到<b>登錄</b>鏈接。登錄後，您會看到：<ul><li><b>已記錄以（您的用戶名）</b>。點擊該鏈接將轉到您的帳戶頁面。</li><li>點擊<b>退出</b>退出。</li><li>如果您擁有管理員權限，您還會看到<b>管理員</b>。點擊此鏈接可直接進入主管理頁面。</li></ul>";
$pgv_lang["header_favorites_help"] = "~標題區：收藏夾~<br /><br />收藏夾下拉列表顯示您在個性化門戶頁面上選擇的收藏夾。它還顯示了網站管理員為當前活動的GEDCOM選擇的收藏夾點擊其中一個收藏夾條目將直接轉到該人的#pgv_lang[indi_info]#頁面。<br /><br />有關添加收藏夾的更多幫助，請訪問您的個性化門戶頁面。";
$pgv_lang["header_theme_help"] = "~標題區：更改主題~<br /><br />當網站管理員啟用時，\"更改主題\"下拉列表會顯示可用於查看網站的主題列表。<br /><br />您可以通過從下拉列表中選擇一個主題來更改網站的外觀。如果您已登錄，它還會將您的用戶主題更改為您選擇的主題，以便您的下一次登錄將自動選擇相同的主題。";

//-- Index-page Menu
$pgv_lang["menu_help"] = "<div class='name_head center'><b>MENUS</b></div><br />頁眉包含與每個菜單圖標相關的下拉菜單。<br /><br />當你將鼠標指針移動到圖標上，如果存在子菜單，則會出現子菜單。單擊圖標時，您將進入子菜單中的第一項。<br /><br />以下菜單圖標通常可用：<ul><li><a href=\"#menu_fam\">#pgv_lang[welcome_page]#</a><br /></li><li><a href=\" #menu_myged\#>#pgv_lang[mygedview]#</a><br /></li><li><a href=\"#menu_charts\">#pgv_lang[charts]#</a><br /></li><li><a href=\"#menu_lists\">#pgv_lang[lists]#</a><br /></li><li><a href=\"#menu_annical\">#pgv_lang[anniversary_calendar]#</a><br /></li><li><a href=\"#menu_clip\">#pgv_lang[clippings_cart]#</a><br /></li><li><a href=\"#menu_search\">#pgv_lang[search]#</a><br /></li><li><a href=\"#menu_help\">#pgv_lang[page_help]#</a></li></ul>";
$pgv_lang["menu_famtree_help"] = "~歡迎頁面菜單~<br /><br />此菜單中列出了所有本網站的可用家譜數據庫。每個數據庫都有自己的自定義歡迎頁面，如下所示。如果此站點只有一個數據庫，歡迎頁面圖標下沒有子菜單。";
$pgv_lang["menu_myged_help"] = "~#pgv_lang[mygedview]#menu~<br /><br />如果您已登錄，此菜單可包含以下條目：<ol><li>#pgv_lang[mygedview]#<br />這需要您可以自定義起始頁面。</li><li>#pgv_lang[editowndata]#<br />您可以在此處編輯您的個人數據。</li><li>#pgv_lang[my_pedigree]#<br />如果您為此GEDCOM選擇了一個Root人員，則會轉到該人的譜系圖表。</li><li>#pgv_lang[my_indi]#<br />此鏈接將帶您到#pgv_lang[indi_info]#頁面，顯示有關您自己和家人的所有家譜數據。</li></ol>";
$pgv_lang["menu_charts_help"] = "~圖表菜單~<br /><br />可用的圖表是：<ol><li><a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a><br />這會將你鏈接到這個GEDCOM文件的譜系圖表。譜係將從管理員配置的人開始。當你登錄時，起始人可以是你配置的任何人您的帳戶首選項。</li><li><a href=\"?help=help_descendancy.php\"><b>#pgv_lang[descend_chart]#</b></a><br />Descendancy圖表本質上是一個<a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>的相反順序。這種比較並不完全正確，但在譜係時圖表顯示了起始人的所有祖先，後裔圖表顯示了起始人的所有後代。</li><li><a href=\"?help=help_timeline.php\"><b>#pgv_lang[timeline_chart]#</b></a><br />在這裡你可以看到一個人沿著時間線的事件。比較兩個或更多人的事件是很有趣的。同一時間線。</li><li><a href=\"?help=help_relationship.php\"><b>#pgv_lang[relationship_chart]#</b></a><br />在這裡可以檢查一個人與你自己或另一個人的關係。</li><li><a href=\"?help=help_ancestry.php\"><b>#pgv_lang[ancestry_chart]#</b></a><br />此圖表與<a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>非常相似，但有更多顯示詳細信息和備用<a href=\"?help=chart_style_help\"><b>#pgv_lang[chart_style]#</b></a>。</li><li><a href=\"?help=help_fanchart.php\"><b>#pgv_lang[fan_chart]#</b></a><br />此圖表與<a href=\"?help=help_pedigree.php\">非常相似<b>#pgv_lang[index_header]#</b></a>，但是以更加圖形化的方式。</li></ol>";
$pgv_lang["menu_lists_help"] = "~列表菜單~<br /><br />以下列表可用：<ol><li><a href=\"?help=help_indilist.php\"><b>#pgv_lang[individual_list]#</b></a></li><li><a href=\"?help=help_famlist.php\"><b>#pgv_lang[family_list]#</b></a><br />在這兩個列表中，您可以瀏覽此GEDCOM中按字母順序排列的個人或家庭列表。</li><li><a href=\"?help=help_sourcelist.php\"><b>#pgv_lang[source_list]#</b></a><br />此條目返回GEDCOM中使用的所有來源的列表。</li><li><a href=\"?help= help_placelist.php\"><b>#pgv_lang[place_list]#</b></a><br />在這裡，您可以按地方查找人員。將返回兩列列表。個人列在左側，家庭在右側。</li><li><a href=\"?help=help_medialist.php\"><b>#pgv_lang[media_list]#</b></a><br />只有在啟用時才能看到此菜單項網站管理員。這將顯示此GEDCOM中所有多媒體文件的鏈接。</li></ol>";
$pgv_lang["menu_annical_help"] = "~#pgv_lang[週年紀念_日曆]#菜單~<br /><br />#pgv_lang[anniversary_calendar]#顯示GEDCOM中給定日期，月份或年份的事件。<ol><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewday]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewmonth]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewyear]#</b></a><br />這些菜單項將帶您進入#pgv_lang[anniversary_calendar]#以顯示當前日期，月份或年份的所有事件的列表。</li></ol>" ;
$pgv_lang["menu_clip_help"] = "~#pgv_lang[clippings_cart]#菜单~<br /><br />僅當管理員啟用此功能時，您才會在菜單欄中看到此條目。<br /><br />#pgv_lang[clip_cart]#允許您將個人，家庭和來源的信息存儲在臨時文件中，以後可以用GEDCOM 5.5.1格式下載。";
$pgv_lang["menu_search_help"] = "~搜索菜單~<br /><br />搜索頁面是一個功能更強大的搜索框，可以在每個頁面標題中找到。";
$pgv_lang["menu_help_help"] = "~幫助菜單~<br /><br />#pgv_lang[help_help_items]#";

//-- Index-page Portal
$pgv_lang["index_portal_head_help"] = "<div class='name_head center'><b>欢迎页面</b></div>";
$pgv_lang["index_portal_help"] = "歡迎頁面由幾個單獨的塊組成，可以自定義。在具有多個系譜數據庫的站點上，您可能會看到每個系列的不同歡迎頁面。根據管理員如何自定義站點，您可能會看到任何一個歡迎頁面上的以下塊：<ul><li><a href=\"#index_welcome\"><b>歡迎</b></a></li><li><a href=\"#index_login\"><b>登錄</b></a> </li><li><a href=\"#index_events\"><b>即將舉辦的活動</b></a></li><li><a href=\"#index_onthisday\"><b>歷史記錄中的這一天</b></a> </li><li><a href=\"#index_charts\"><b>圖表</b></a></li><li><a href=\"#index_favorites\"><b>GEDCOM收藏夾</b></a></li><li><a href=\"#index_stats\"><b>GEDCOM統計</b></a></li><li><a href=\"#index_common_surnames\"><b>最常見的姓氏</b></a></li><li><a href=\"#index_media\"><b>隨機媒體</b></a></li><li><a href=\"#index_loggedin\"><b>登錄用戶</b></a></li><li><a href=\"#gedcom_news\"><b>GEDCOM新聞</b></a></li><li><a href=\"#recent_changes\"><b>最近的變化</b></a></li> </ul>";
$pgv_lang["index_welcome_help"] = "~歡迎阻止~<br /><br />歡迎程序段顯示當前數據庫標題，日期和時間，如果由管理員啟用，則顯示命中計數器。<br /><br />命中計數器僅在歡迎塊和#pgv_lang[indi_info]#頁面中可用。計數器計算這些頁面的\"點擊數\"。這意味著它計算訪問這些頁面的次數。計數器不檢查訪問者的互聯網地址;每次從<u>任何</u>遠程位置訪問頁面都算作另一個击中。";
$pgv_lang["index_login_help"] = "~登錄塊~<br /><br />您幾乎可以在此程序的每個頁面上登錄。您通常會在第一頁上登錄，因為您只能在登錄時訪問特權信息。<br /><br />您可以通過鍵入<b>用戶名</b>和<b>密碼</b>然後單擊\"登錄\"按鈕進行登錄。";
$pgv_lang["index_events_help"] = "~即將到來的事件塊~<br /><br />這個塊顯示了在不久的將來即將發生的事件週年紀念。<br /><br />管理員確定塊前面的距離。可以通過幾個配置選項進一步細化塊的即將發生的事件的顯示。<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["todo_help"] = "~&quot;要做&quot;块~<br /><br />這個塊可以幫助你跟踪數據庫中的<b>_TODO</b>任務。<br /><br />加&quot;待办事项&quot;对于您的记录的任务，您可能首先需要修改GEDCOM配置，以便<b>_TODO</b>事实在可以添加到个人，家庭，来源和存储库的记录中的事实列表中。您可以在GEDCOM配置的编辑选项部分找到的每个列表都是独立的。 列表条目的顺序并不重要; 您可以在每个列表的开头添加新条目。";
$pgv_lang["todo_show_other_help"] = "顯示&quot;待辦事項&quot;分配給其他用戶的任務";
$pgv_lang["todo_show_unassigned_help"] = "顯示&quot;待辦事項&quot;未分配給任何用戶的任務";
$pgv_lang["todo_show_future_help"] = "顯示&quot;待辦事宜&quot;具有未來日期的任務。否則，僅顯示過去具有日期的條目。";
$pgv_lang["yahrzeit_help"] = "~YAHRZEITEN BLOCK~<br /><br />這個街區向你展示了在不久的將來出現的Yahrzeiten。<br /><br />Yahrzeiten（單數：Yahrzeit）是一個人去世的紀念日。這些紀念日是在猶太傳統中觀察到的;它們在其他傳統中不再常用。 «Yahrzeit»也可以拼寫為«Jahrzeit»或«Yartzeit»。<br /><br />管理員確定塊前面的距離。即將推出的Yahrzeiten的塊顯示可以通過配置選項進一步完善。<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["days_to_show_help"] = "~#pgv_lang[days_to_show]#~<br /><br />輸入要顯示的天數。此數字不能大於<b>#DAYS_TO_SHOW_LIMIT#</b>。如果輸入的值越大，將使用限制。<br /><br />顯示的限制由管理員在GEDCOM配置，顯示和佈局部分，隱藏和顯示子部分中設置。";
$pgv_lang["random_media_persons_or_all_help"] = "~#pgv_lang[random_media_persons_or_all]#~<br /><br />此選項可讓您確定要顯示的媒體類型。<br /><br />當您選擇<b>#pgv_lang[random_media_persons]#</b>，只顯示與人相關的媒體。通常，這將是一個人的照片。當你選擇<b>#pgv_lang[random_media_events]#</b>時，只會顯示與事實或事件相關的媒體。這可能是證書的圖像。當您選擇<b>#pgv_lang[all]#</b>時，此塊將顯示所有類型的媒體。";
$pgv_lang["random_media_filter_help"] = "~#pgv_lang[filter]#~<br /><br />您可以根據媒體項的格式和類型限制允許隨機媒體塊顯示的內容。當選中給定複選框時，隨機媒體塊允許顯示該格式或類型的媒體條目。<br /><br />數據庫中存在但不在這些複選框列表中的格式或類型代碼被假定為已選中相應的複選框。例如，如果您的數據庫包含格式為<b><i>pdf</i></b>的媒體對象，始終允許隨機媒體塊顯示它們。同樣，如果您的數據庫包含<b><i>類型的媒體對象</i></b>，始終允許隨機媒體塊顯示它們。";
$pgv_lang["basic_or_all_help"] = "~#pgv_lang[basic_or_all]#~<br /><br />這個選項可以讓你消除一些過時的事件。例如，#factarray[DIV]#，#factarray[CREM]#，#factarray[GRAD]#，#factarray[BARM]#，#factarray[FCOM]#等都應該註明日期。<br /><br />當你選擇<b>是</b>時，只有出生，去世和婚姻將是當您選擇<b>否</b>時，將顯示所有過時的事件。";
$pgv_lang["style_help"] = "~#pgv_lang[style]#~<br /><br />此選項控制信息的呈現方式。<br /><br />選擇<b>#pgv_lang[style1]#</b>，信息以文本形式顯示，類似於您在各種圖錶框中看到的信息。此格式非常適合在頁面右側打印的塊。<br /><br />选择<b>#pgv_lang[style2]#</b>时，信息以表格格式显示，更适合在页面左侧打印的较大块。";
$pgv_lang["sort_style_help"] = "~#pgv_lang[sort_style]#~<br /><br />此選項控制信息的排序方式。<br /><br />選擇<b>#pgv_lang[by_alpha]#</b> ，信息按字母順序顯示。當您選擇<b>#pgv_lang[by_anniv]#</b>時，信息按週年排序，最近的周年紀念日排在第一位。";
$pgv_lang["cal_dowload_help"] = "~#pgv_lang[cal_download]#~<br /><br />此選項控制下載日曆事件的按鈕是否顯示給登錄用戶。下載的日曆文件可以導入兼容的程序，如Microsoft Outlook例如，生成周年紀念日的自動電子郵件提醒。<br />當設置為<b>#pgv_lang[no]#</b>時，登錄用戶將無法下載日曆文件。設置為<b>#pgv_lang[yes]#</b>，將顯示下載按鈕。當用戶未登錄時，此按鈕不會顯示。";
$pgv_lang["cal_download_user_help"] = "如果您已登錄，則可能會看到圖標<img src='images/ical.png' alt=''/>。如果單擊該圖標，則會將事件下載為日曆文件，可以是導入到兼容的程序（如Microsoft Outlook）中，例如，生成周年紀念日的自動電子郵件提醒。<br /><br />如果您已登錄但未看到此圖標，則管理員已禁用此功能。未登錄的訪客將看不到此圖標，也無法下載日曆文件。";
$pgv_lang["index_charts_help"] = "~#pgv_lang[charts_block]#~<br /><br />此塊允許在歡迎或MyGedView頁面上顯示譜系圖，下降圖或沙漏圖。由於篇幅限制，圖表應僅放在頁面的左側。<br /><br />當歡迎頁面上顯示此塊時，管理員會確定要顯示的根人員和圖表類型。當此塊出現在用戶的個性化MyGedView上時頁面，這些選項由用戶決定。<br /><br />這些圖表的行為與從菜單調用它們時的行為相同。點擊一個人的框以查看有關它們的更多詳細信息。";
$pgv_lang["index_onthisday_help"] = "~在這個歷史街區的這一天~<br /><br />這個街區類似於\"即將發生的事件\"街區，除了它顯示今天的活動。<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["index_favorites_help"] = "~GEDCOM最喜歡的塊~<br /><br />GEDCOM收藏夾塊與#pgv_lang[mygedview]#页面的\"我的收藏夾\"塊大致相同。与门户网站页面配置不同，只有管理员或具有管理员权限的用户才能更改此块中的收藏夹列表。<br /><br />GEDCOM收藏夾塊的目的是吸引訪問者註意特別感興趣的人。這個GEDCOM的最愛可供選擇從每個頁面標題的下拉列表中。<br /><br />當您點擊其中一個列出的網站收藏夾時，您將被帶到該人的#pgv_lang[indi_info]#頁面。";
$pgv_lang["index_add_favorites_help"] = "~添加一個最喜歡的顏色~<br /><br />這個表單允許你添加一個新的喜歡的條目到你的收藏夾列表。<br /><br />你必須輸入一個人，家庭，您想要存儲為收藏夾的源或源，或者您必須輸入URL和標題。註釋字段是可選的，可用於描述收藏夾。註釋字段中輸入的任何內容都將顯示在條目後的收藏夾塊中。";
$pgv_lang["index_stats_help"] = "~GEDCOM統計區塊~<br /><br />在這個區塊中，您將看到有關當前GEDCOM文件的一些統計信息。如果您需要的信息多於列出的信息，請向頁面底部的聯繫人發送消息。";
$pgv_lang["index_common_names_help"] = "~十大姓氏~<br /><br />這個區塊將列出最常出現的姓氏，每個姓氏都有一個計數。如果你點擊一個名字，它會帶你到個人名單，已經過濾了您點擊的名稱。<br /><br />管理員確定實際顯示的名稱數量。";
$pgv_lang["index_common_given_names_help"] = "~十大名字~<br /><br />這個區塊將列出最常出現的給定名稱。它在列中顯示男性和女性名稱。當有人沒有性別時，將出現第三列已知。<br /><br />管理員確定實際顯示的名稱數量。";
$pgv_lang["index_media_help"] = "~隨機圖片塊~<br /><br />在這個塊中，網站會隨機選擇一個媒體文件，以便在每次訪問此頁面時向您顯示。<br /><br />當您點擊圖片時，您將看到它的全尺寸版本。在圖片下方你有一個指向與圖片相關聯的人的鏈接。當你點擊圖片標題時，你會看到#pgv_lang[media_list]#頁面上的圖片。當你點擊這個人的名字，你將被帶到那個人的#pgv_lang[indi_info]#頁面。";
$pgv_lang["index_loggedin_help"] = "~登錄用戶塊~<br /><br />此塊將顯示當前登錄的用戶。<br /><br />如果您不是管理員，則您對登錄用戶的查看受到限制對於那些選擇在線時可見的人來說。為了實現這一點，你必須選擇在線時可見。對你來說不可見的在線用戶被視為匿名。";
$pgv_lang["index_gedcom_news_help"] = "~GEDCOM新闻块~<br /><br />新聞塊就像這個GEDCOM的公告板。網站管理員可以在這裡發布重要的公告或有趣的新聞消息。<br /><br />如果你有有趣的東西要顯示，請聯繫網站管理員;他可以把你的消息放在這個公告板上。";
$pgv_lang["recent_changes_help"] = "~最近更換塊~<br /><br />這個塊顯示了CHAN GEDCOM標籤記錄的GEDCOM的最新變化。";
$pgv_lang["gedcom_news_limit_help"] = "您可以限制顯示的新聞文章的數量，從而降低GEDCOM新聞塊的高度。<br /><br />此選項確定是否應該應用任何限製或限制是否應根據年齡文章或根據文章的數量。";
$pgv_lang["gedcom_news_flag_help"] = "在此處輸入限制值。<br /><br />如果您選擇根據年齡限制新聞文章顯示，那麼任何超過此處輸入天數的文章都將被隱藏起來。如果您選擇了限制新聞文章按編號顯示，只顯示按年齡排序的最近文章的指定數量。剩下的文章將被隱藏起來。<br /><br />這裡輸入的零將禁用限制，導致所有新聞文章都要展示。";
$pgv_lang["gedcom_news_archive_help"] = "為了減少新聞塊的高度，管理員隱藏了一些文章。您可以通過單擊<b>#pgv_lang[gedcom_news_archive]#</b>鏈接來顯示這些隱藏的文章。";
$pgv_lang["index_htmlplus_help"] = "~#pgv_lang[htmlplus_block_name]#~<br /><br />這個塊允許管理員將信息添加到索引或門戶頁面。其目的类似于#pgv_lang[html_block_name]#，#pgv_lang[gedcom_news_block]#和#pgv_lang[gedcom_stats_block]块，但管理员可以更好地控制其外观。";
$pgv_lang["index_htmlplus_title_help"] = "~#factarray[TITL]#~<br /><br />此文本應為空白或非常簡短。空白時，高級HTML塊將在索引或門戶頁面上顯示為普通塊，就像HTML一樣當有文本時，高級HTML塊將像所有其他塊一樣顯示，並包含一個塊標題欄，其中包含您在此處輸入的文本。";
$pgv_lang["index_htmlplus_template_help"] = "~#pgv_lang[htmlplus_block_templates]#~<br /><br />為了幫助您開始使用這個塊，我們創建了幾個標淮模板。當您選擇其中一個模板時，文本區域將包含一個副本然後你可以改變以適應你網站的要求。";
$pgv_lang["index_htmlplus_content_help"] = "~#pgv_lang[htmlplus_block_content]#~<br /><br />与#pgv_lang[html_block_name]#，#pgv_lang[gedcom_news_block]#和＃pgv_lang[gedcom_stats_block]＃块不同，您可以完全控制块的外观。您可以使用HTML标记，该块使用当前活动主题中的CSS样式表。文本中可以包含對當前活動的譜係數據庫中的信息的引用。<br /><br />數據庫引用是通過在關聯的<b>&#35;</b>符號中包含關鍵字在文本中發出信號。例如，&#35;totalFamilies&#35;表示數據庫中的系列數。在某些情況下，您可能希望使用數據庫引用作為文本而不是其真實含義。為此，您需要將符號等效的<b>&#35;</b>符號替換為關鍵字。例如，如果您的文字包含<b>&amp;&#35;35;totalFamilies&amp;&#35;35;</b>，它將打印為<b>&#35;totalFamilies&#35;</b>而不是成为数据库参考。<br /><br />有关使用此块的完整示例，请检查blocks/目录中的&quot;#pgv_lang[gedcom_stats_block]#&quot;模板，它使用大多数样式的标记，包括语言和帮助文本链接。<br /><br /><b>#pgv_lang[htmlplus_block_keyword]#</b>模板包含一個完整的所有支持的關鍵字列表。";
$pgv_lang["index_htmlplus_compat_help"] = "~#pgv_lang[htmlplus_block_compat]#~<br /><br />啟用與此版塊的舊版本的兼容性。選中後，舊的和新的關鍵字都將被識別並採取行動。<br /><br />例如，文本<b>&#35;TOTAL_FAM&#35;</b>將被識別為等同於<b>&#35;totalFamilies&#35;</b>，<b>&#35;FIRST_DEATH_PLACE&#35;</b>到<b>&#35;firstDeathPlace&#35;</b>，<b>&#35;TOP10_BIGFAM&#35;</b>到<b>&#35;topTenLargestFamily&#35 ;</b>等<br /><br />除非絕對必要，否則不應使用兼容模式。";
$pgv_lang["index_htmlplus_gedcom_help"] = "~#pgv_lang[htmlplus_block_gedcom]#~<br /><br />選擇關鍵字適用的數據庫。<br /><br />您的網站支持多個數據庫。關鍵字如<b>&#35;totalFamilies&#35;</b>只能引用一個數據庫。您可以識別要為所有這些關鍵字查詢的數據庫。每個#pgv_lang[htmlplus_block_name]#块只能訪問一個數據庫。";
$pgv_lang["showUnknown_help"] = "~#pgv_lang[showUnknown]#~<br /><br />隱藏或顯示未知性別人員的名字列表。<br /><br />#pgv_lang[block_givn_top10]#块總是隱藏當您的數據庫中不存在該性別的人時，給定名稱列表。此選項允許您隱藏未知性別的人員列表，即使您的數據庫中有此類人員也是如此。";

//-- Index-Page Help
$pgv_lang["help_help"] = "當然，創建一個如此簡單易用的程序是理想的，它根本不需要任何解釋;它應該像讀書一樣簡單。<br /><br />雖然網站是非常複雜，你不應該注意到你使用它;幾乎所有東西都可以在沒有解釋的情況下使用。但是，由於我們可能有很多訪問者和用戶對使用計算機或互聯網不是很有經驗，我們在某些​​地方為您提供一些幫助。<br /><br />您可以在\"幫助\"菜單中找到以下條目：";
$pgv_lang["help_page_help"] = "<dl><dt><b>本頁的幫助</b></dt><dd>對於所有頁面都有一般的\"頁面幫助\"。您可以點擊菜單中的這個條目來獲取\"頁面幫助\"，在那裡您將被告知該頁面上的條目。<br /><br />頁面幫助通常很簡短。如果您需要更多關於頁面上某個條目的幫助或信息而不是頁面幫助提供您可以使用\"上下文幫助\"功能。</dd></dl>";
$pgv_lang["help_content_help"] = "<dl><dt><b>幫助內容</b></dt><dd>當您單擊此菜單項時，您將看到一個幫助頁面，其中顯示主要幫助主題的索引。可用信息將隨著時間的推移而增加。</dd></dl>";
$pgv_lang["help_faq_help"] = "<dl><dt><b>常見問題列表</b></dt><dd>#pgv_lang[text_faq_help]#</dd></dl>";
$pgv_lang["help_HS_help"] = "<dl><dt><b>#pgv_lang[hs_title]#</b></dt><dd>#pgv_lang[hs_intro]#</dd></dl>";
$pgv_lang["help_qm_help"] = "<dl><dt><b>隱藏/顯示上下文幫助</b></dt><dd>這最後一個菜單項可能對您最有用。點擊此鏈接可以打開或關閉\"上下文幫助\"。<br /><br />打開上下文幫助後，您可能會在某些鏈接，下拉框或按鈕旁邊找到問號或類似圖標。當您單擊此圖標時，幫助屏幕將會出現彈出。此幫助屏幕包含有關該對象的信息。<br /><br />當然，當您單擊\"隱藏上下文幫助\"時，所有問號或圖標將消失，直到您單擊\"顯示.. ..\"再次。</dd></dl>";

//-- Index-page Definitions
$pgv_lang["def_help"] = "<div class='name_head center'><b>#pgv_lang[definitions]#</b></div><br />以下是本幫助文本中使用的術語的一些解釋：<ul><li><a href=\"#def_gedcom\"><b>GEDCOM</b></a><br /></li><li><a href=\"#def_gedcom_date\"><b>日期</b></a></li><li><a href=\"#def_pdf_format\"><b>PDF文件格式</b></a></li><li><a href=\"#def_pgv\"><b>網站</b></a></li><li><a href=\"#def_portal\"><b>門戶網站</b></a></li><li><a href=\"#def_theme\"><b>主題</b></a></li></ul>";
$pgv_lang["def_portal_help"] = "~門戶~<br /><br />這個網站的門戶就像餐廳或公共圖書館的大廳。這是你進入的地方，但你也可以找到重要的信息，如解釋，菜單等。";
$pgv_lang["def_gedcom_help"] = "~GEDCOM文件~<br /><br />GEDCOM 5.5.1標淮簡介：<div class=\"list_value_wrap\"> GEDCOM由耶穌基督教會家族史系開發後期聖徒教會（LDS教會）提供靈活，統一的格式來交換計算機化的家譜數據。GEDCOM是<i><b>GE</b></i>nealogical <i><b>D</b></i>ata <i><b>Com</b></i>munication的首字母缩写。（谱系数据通信）。其目的是促進家譜信息的共享和各種相互作用的發展。可操作的軟件產品，以協助系譜學家，歷史學家和其他研究人員。</div><br />GEDCOM 5.5.1草案规范的副本可以PDF格式下载，PhpGedView符合此标准：<a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\"> GEDCOM 5.5.1標淮</a>本標淮僅適用於英語。<br /><br />GEDCOM文件包含有關家庭的所有信息。所有事實，日期，事件，等等都存儲在這裡。GEDCOM文件必須遵循嚴格的規則，因為它們必須可以在許多程序之間行交換，而不依賴於平台或操作系統。";
$pgv_lang["def_gedcom_date_help"] = "~GEDCOM文件中的日期~<br /><br />雖然日期字段允許自由格式輸入（意味著您可以輸入任何您想要的內容），但是有一些關於如何根據日期輸入日期的規則GEDCOM 5.5.1標淮。<ol><li>以DD MMM YYYY形式輸入完整日期。例如，<b>01&nbsp;MAR&nbsp;1801</b>或<b>14&nbsp;DEC&nbsp;1950</b>。</li> <li>如果您錯過了部分日期，則可以省略該部分。例如<b>MAR&nbsp;1801</b>或<b>14&nbsp;DEC</b>。</li><li>如果您不確定或未確認日期，您可以輸入<b>ABT&nbsp;MAR&nbsp;1801</b>（abt = about），<b>BEF&nbsp;20&nbsp;DEC&nbsp;1950</b> （bef = before），<b>AFT&nbsp;1949</b>（aft = after）</li><li>日期範圍輸入為<b>FROM&nbsp;MAR&nbsp;1801&nbsp;TO&nbsp;20&nbsp;DEC&nbsp;1810</b>或作為<b>BET&nbsp;MAR&nbsp;1801&nbsp;AND&nbsp;20&nbsp;DEC&nbsp;1810</b>（賭注=之間）<br /><br /><b>FROM</b>表格表明所描述的事件在規定的日期和之間續發生用於就業等事件。<b>BET</b>表單表示事件的單次出現，有時在所述日期之間，並與出生等事件一起使用。<br /><br />不精確的日期，月份的日期或月份缺失，始終被解釋為第一個或最後一個可能的日期，具體取決於該不精確日期是在分離關鍵字之前還是之後。例如，<b>FEB&nbsp;1804</b>在TO或AND之前被解釋為<b>01&nbsp;FEB&nbsp;1804</b>，並且<b>29&nbsp;FEB&nbsp;1804</b>當它發生在TO或AND之後。</li></ol><b>請務必在<u>英語</u>，</b>中輸入日期和縮寫，因為GEDCOM文件是可以交換的， 網站可以將所有日期和縮寫正確翻譯成當前活動的語言。此外，網站使用這些日期進行計算。如果在日期字段中輸入了不正確的日期，網站將無法正確計算。<br /><br />您可以單擊日曆圖標以獲取幫助選擇日期。";
$pgv_lang["def_gramps_help"] = "~GRAMPS XML數據庫文件~<br /><br />GRAMPS條目引用：<div class=\"list_value_wrap\"> GRAMPS幫助您跟踪您的家譜。它允許您存儲，編輯和研究譜系GRAMPS試圖提供其他系譜程序的所有通用功能，但更重要的是，提供這些程序不常見的附加集成功能。這是能夠將任何信息直接輸入GRAMPS和重新排列/操縱整個數據庫中的任何/所有數據事件（以任何順序或順序），以幫助用戶進行研究，分析和與填補關係差距的潛力相關聯。</div><br />GRAMPS XML格式v1.1.0 <a href=\"http ://www.gramps-project.org/xml/1.1.0/\" target=\"_blank\">可在此處找到</a> RELAX NG Schema格式和DTD格式。<br /><br />有關GRAMPS條目的更多信息，請訪問<a href=\"http://gramps-project.org/\" target=\"_ blank\">http://gramps-project.org/</a>";
$pgv_lang["def_pgv_help"] = "~PhpGedView~<br /><br />網站（或PGV）不只是將靜態頁面放在Web上;它是動態的，可以通過多種方式進行自定義。<br /><br />網站創建於John Finlay將在線查看GEDCOM文件.John開始自己開發該程序。一個由開發人員和翻譯人員組成的國際團隊已經加入他並正在努力改進該計劃。在該計劃中增加或改進的更重要的功能之一它是對英語以外語言的廣泛支持，以及在線添加和編輯事件的能力。";
$pgv_lang["def_theme_help"] = "~主題~<br /><br />這個網站可以有不同的\"外觀\"，稱為主題。<br /><br />網站管理員選擇默認主題，進入該網站的每個人最初都會當管理員啟用此功能時，所有用戶都可以選擇自己的主題.PepGedView會記住每個登錄用戶最後選擇的主題，以便該用戶下次登錄時會自動看到該主題。主題可以是用作區分同一站點上不同數據庫的方法。每個數據庫都可以有不同的默認主題。";

//-- Index-page MyGEDCOM
$pgv_lang["mygedview_portal_help"] = "~#pgv_lang[mygedview]#~<br /><br />這是您的個人#pgv_lang[mgv]#页面。<br /><br />在這裡您可以找到訪問您的個人數據的簡單鏈接，例如<b>我的帳戶</b>，<b>我的Indi</b>（這是您的#pgv_lang[indi_info]#頁面）和<b>我的譜系</b>。您可以擁有<b的塊>消息</b>，<b>期刊</b>（如記事本）等等。<br /><br />此頁面的佈局類似於您第一次看到的歡迎頁面訪問此站點。雖然站點管理員選擇了歡迎頁面的各個部分，但您可以選擇要在此個性化頁面中包含的部分。您可以在歡迎塊中找到自定義此頁面的鏈接，或者在歡迎塊是不存在。<br /><br />您可以選擇以下塊：<ul><li><a href=\"#mygedview_welcome\"><b>歡迎</b></a></li><li><a href=\"#mygedview_customize\"><b>自定義MyGedView</b></a></li><li><a href=\"#mygedview_message\"><b>消息</b></a></li><li><a href=\"#mygedview_events\"><b>即將舉行的活動</b></a></li><li><a href=\"#mygedview_onthisday\"><b>歷史上的這一天</b></a></li><li><a href=\"#mygedview_charts\"><b>圖表</b></a></li><li><a href=\"#mygedview_favorites\"><b>我的收藏</b></a></li><li><a href=\"#mygedview_stats\"><b>GEDCOM統計</b></a></li><li><a href=\"#mygedview_myjournal\"><b>我的日記</b></a></li><li><a href=\"#mygedview_media\"><b>隨機媒體</b></a></li><li><a href=\"#mygedview_loggedin\"><b>登錄用戶</b></a></li><li><a href=\"#mygedview_recent_changes\"><b>最近的更改</b></a></li></ul>";
$pgv_lang["mygedview_customize_help"] = "~CUSTOMIZE#pgv_lang[mygedview]#~<br /><br />當你第一次進入這裡時，你已經在這個頁面上有了一些塊。如果你願意，你可以自定義這個门户页面。<br /><br />當您單擊此鏈接時，您將進入可以添加，移動或刪除塊的表單。該表單中提供了更多說明。";
$pgv_lang["mygedview_message_help"] = "~消息塊~<br /><br />在此塊中，您將找到其他用戶或管理員發送給您的消息。您也可以向其他用戶或管理員發送消息。<br /><br 網站郵件系統旨在幫助保護您的隱私。您不必在此處留下您的電子郵件地址，而其他人將無法看到您的電子郵件地址。<br /><br />要擴展郵件，單擊郵件主題或旁邊的\"<b>+</b>\"符號。您可以通過選中要刪除的郵件旁邊的框並單擊<b>刪除所選郵件來刪除多封郵件</b>按鈕。";
$pgv_lang["mygedview_favorites_help"] = "~我最喜歡的地方~<br /><br />收藏與書籤類似。<br /><br />假設您在家譜中有人想要定期查看他們的記錄。只要去找人#pgv_lang[indi_info]#頁面並從收藏夾下拉列表中選擇<b>添加到我的收藏夾</b>選項。此人現在已經過書籤並添加到收藏列表中。<br /><br />無論您在本網站的哪個位置，都可以點擊標題中\"我的收藏夾\"下拉列表中的名稱。這將帶您進入該人的#pgv_lang[indi_info]#頁面。";
$pgv_lang["mygedview_myjournal_help"] = "~我的期刊塊~<br /><br />您可以使用此期刊編寫筆記或提醒供您自己使用。當您做出這樣的筆記時，它會在您下次訪問該網站時仍然存在。<這些說明是私人的，其他人不會看到。";
$pgv_lang["mygedview_welcome_help"] = "~歡迎阻止~<br /><br />歡迎屏幕顯示：<ul><li>當前的GEDCOM文件</li><li>日期和時間</li><li>鏈接到： <ul><li>#pgv_lang[myuserdata]#</li><li>#pgv_lang[my_pedigree]#</li><li>#pgv_lang[my_indi]#</li><li>#pgv_lang[customize_page]#</li></ul></li></ul><br /><b>注意：</b><br />您將看到指向<b>My Indi</b>的鏈接<b>我的譜系</b>只有當前GEDCOM文件已知時。您可能在一個GEDCOM文件中有記錄，因此可以看到<b>My Indi</b>和<b>My Pedigree</b>鏈接，而在另一個GEDCOM文件中，您沒有記錄，因此不會顯示這些鏈接。";

//-- Pedigree-page
$pgv_lang["help_pedigree.php"] = "~谱系页面~<br /><br />系譜是起始人的所有祖先的枚舉。未登錄的用戶可以看到網站管理員選擇的起始（根）人的血統。在用戶可以選擇自己的起始（根）人。<br /><br />在這種情況下，\"所有祖先\"是指父親和母親，他們的父母等。譜係以圖形方式顯示;你不必費力地通過文本頁面確定你的祖先。<br /><br />所有人都顯示在屏幕上的名稱框中。<br /><ul><li><b>名稱框上譜系</b><br />如果譜系頁面設置為顯示詳細信息，您將看到該人的姓名以及出生和去世日期。您可以點擊一個人的姓名直接帶您到#pgv_lang[indi_info]#該頁面的頁面。<br /><br />當<b>顯示詳細信息</b>打開時，名稱框中有兩個圖標。</li><li><b>名稱中的譜系圖標框</b><br />選項<b>顯示詳細信息</b>是on，您在名稱框中看到一個譜系圖標。根據站點設置，您必須將鼠標懸停在圖上或單擊它。當您單擊或將鼠標懸停在該圖標上時，會出現一個小子菜單。<br /><br />條目<b>#pgv_lang[index_header]#</b>和<b>#pgv_lang[descend_chart]#</b>類似於主菜單中的那些條目，但區別在於起始人現在是名稱框中提到的個人。您還會看到<b>#pgv_lang[as_spouse]#</b>。在下面你會看到配偶的名字，後面跟著孩子的名字。所有名稱都是可點擊的。</li><li><b>名稱框內的放大鏡</b><br />根據網站設置，您必須將鼠標懸停在圖標上或單擊它。這會放大名稱框，以便顯示更多詳細信息。您將看到更多日期和活動。名稱是可點擊的。</li><li><b>箭頭</b><br />在最左側或最右側的名稱框的左側或右側，您可能會看到箭頭。當您單擊這些箭頭時，屏幕顯示將按箭頭方向移動。</li></ul><br />#pgv_lang[context_help]#";
$pgv_lang["show_full_help"] = "~隱藏或顯示詳細信息~<br /><br />使用此選項，您可以在名稱框中顯示或隱藏所有詳細信息。隱藏詳細信息時，您可以在一個屏幕上顯示更多框。<br /><br />隱藏所有細節後，不顯示下面描述的縮放圖標。但是，如果管理員啟用了縮放功能，整個框將像縮放圖標一樣顯示有關此人的完整詳細信息。<br /><br />如果未隱藏細節並且管理員已啟用放大鏡圖標標識的縮放功能，則可以顯示有關該人員的更多詳細信息。如果您通常必須單擊縮放圖標以放大，您可以通過點擊此圖標顯示其他隱藏的詳細信息。同樣，如果您可以通過將鼠標懸停在縮放圖標上放大，隱藏的詳細信息將通過將鼠標懸停在該圖標上來顯示。<br /><br />如果您已單擊\"縮放\"圖標以顯示更多詳細信息，您可以通過單擊將該框恢復為其正常的詳細程度再次進入縮放圖標。果您通過簡單地將鼠標指針移動到縮放圖標上來顯示更多細節，則當您將鼠標指針移離縮放圖標時，該框將恢復到正常的細節級別。";
$pgv_lang["talloffset_help"] = "~页面布局~<br /><br />使用此選項可以確定頁面佈局方向。<br /><br />如果要進行絲網印刷或者如果要進行絲網印刷，則更改此設置可能很有用不同類型的屏幕。<ul><li><b>#pgv_lang[portrait]#</b>模式將使樹更高，這樣4代圖表應該適合垂直打印的單頁。</li><li><b>#pgv_lang[landscape]#</b>模式將生成一個更寬的樹，可以在水平打印的單頁上打印。</li><li><b>#pgv_lang[landscape_top]#</b>模式將圖表（而不是其框）逆時針旋轉90度，以便最老的一代位於圖表的頂部。</li> <li><b>#pgv_lang[landscape_down]#</b>模式將圖表（而不是其框）順時針旋轉90度，以便最老的一代位於圖表的底部。</li></ul>";
$pgv_lang["rootid_help"] = "~新根人~<br /><br />如果你想顯示一個新的起始（根）人的圖表，那麼在這裡輸入新起始人的ID。<br /><br />如果你不知道那個人的身份證，請使用<b>查找身份證</b>鏈接。<br /><br /><b>身份證號碼</b><br />裡面使用的身份證號碼網站不是<u>不是</u>各政府頒發的身份證號碼（例如駕駛證或護照號碼）。這裡提到的身份證號碼只是數據庫中用來唯一識別每個人的號碼;它是由創建GEDCOM文件的祖先程序分配，該文件已導入網站。";
$pgv_lang["PEDIGREE_GENERATIONS_help"] = "~生成數量~<br /><br />在這裡，您可以設置在此頁面上顯示的世代數。<br /><br />正確的數字取決於您的屏幕大小以及是否你是否顯示細節。隨著你增加世代數，處理時間會增加。";

//-- LOGIN-page
$pgv_lang["login_page_help"] = "~登錄頁面~<br /><br />在此頁面上，您可以登錄，申請新密碼或申請新的用戶帳戶。";
$pgv_lang["username_help"] = "~用户名~<br /><br />在此框中鍵入您的用戶名。<br /><br /><b>用戶名區分大小寫。</b>這意味著<b>MyName</b><u>不</u>與<b>myname</b>或<b>MYNAME</b>相同。";
$pgv_lang["password_help"] = "~密碼~<br /><br />在此框中輸入您的密碼。<br /><br /><b>密碼區分大小寫。</b>這意味著<b>MyPassword</b><u>不</u>與<b>mypassword</b>或<b>MYPASSWORD</b>相同。";
$pgv_lang["login_buttons_help"] = "~登錄按鈕~<br /><br />在這裡您可以看到兩個登錄系統的按鈕。<br /><br />您將被帶到或發回的頁面取決於您點擊後的哪個按鈕輸入您的用戶名和密碼。<br /><ul><li><b>#pgv_lang[登錄]#</b>按鈕<br />如果您單擊此按鈕，您將返回到您所在的頁面只是，但具有登錄訪問權限。<br /><br />例如，當您在譜系頁面時單擊<b>#pgv_lang[登錄]#</b>，您將返回如果您在主歡迎頁面上單擊此按鈕，您將進入#pgv_lang[mygedview]#页面。</li><li><b>#pgv_lang[admin]#</b>按鈕<br />如果您有管理員權限，可以單擊此按鈕直接進入主管理頁面。</li></ul>";
$pgv_lang["login_buttons_aut_help"] = "~認證模式登錄按鈕~<br /><br />在這裡您可以看到兩個登錄系統的按鈕。<br /><br />您將被帶到的頁面取決於您在鍵入後單擊的按鈕用戶名和密碼。<br /><ul><li><b>#pgv_lang[登錄]#</b>按鈕<br />如果單擊此按鈕，您將登錄並直接進入#pgv_lang[mygedview]#页面，您可以在其中編輯設置，添加或編輯收藏，發送和閱讀郵件等。</li><li><b>#pgv_lang[admin]#</b>按鈕<如果您有管理員權限，可以單擊此按鈕直接進入主管理頁面。</li></ul>";
$pgv_lang["new_password_help"] = "~請求新密碼~<br /><br />如果您忘記了密碼，可以點擊此鏈接申請新密碼。<br /><br />您將被帶到\"忘記密碼請求\"頁面。";
$pgv_lang["new_user_help"] = "~請求新用戶帳戶~<br /><br />如果您是本網站的訪問者並希望申請用戶帳戶，您可以點擊此鏈接。<br /><br />您將被帶到\"註冊\"頁面。";
$pgv_lang["mygedview_login_help"] = "為了訪問#pgv_lang[mygedview]#頁面，您必須是系統上的註冊用戶。在#pgv_lang[mygedview]#頁面上，您可以為喜愛的人添加書籤，保留用戶日記，管理消息，查看其他登錄用戶，並自定義網站頁面的各個方面。<br /><br />在相應字段中輸入您的用戶名和密碼以登錄#pgv_lang[mgv]#。";
$pgv_lang["new_user_firstname_help"] = "~#pgv_lang[firstname]#~<br /><br />在這個框中你必須輸入你的名字。<br /><br />我們需要你的名字和姓氏，以確定你是否有資格獲得此站點的帳戶，以及您的權利。這些名稱將對其他已登錄的家庭成員和用戶可見。";
$pgv_lang["new_user_lastname_help"] = "~#pgv_lang[lastname]#~<br /><br />在這個框中你必須輸入你的姓氏。<br /><br />我們需要你的名字和姓氏，以確定你是否有資格獲得此站點的帳戶，以及您的權利。這些名稱將對其他已登錄的家庭成員和用戶可見。";
$pgv_lang["register_info_01"] = "~請求新的用戶帳戶~<br /><br />由於適用的隱私保護法律，可以在本網站上公開查看的數據量可能會受到限制。許多人不希望他們的個人數據公開在互聯網。個人數據可能被濫用於垃圾郵件或身份盜用。<br /><br />每個擁有用戶帳戶的訪問者都可以訪問此網站。管理員驗證並批淮您的帳戶申請後，您將成為能夠登錄。<br /><br />如果已激活關係隱私，您將只能在登錄後訪問您自己的近親的私人信息。管理員還可以允許某些用戶進行數據庫編輯，這樣他們就可以可以更改或添加信息。<br /><br />如果您需要任何進一步的支持，請使用以下鏈接與管理員聯繫。";
$pgv_lang["register_info_02"] = "~請求新的用戶帳戶~<br /><br />由於適用的隱私保護法律，可以在本網站上公開查看的數據量可能會受到限制。許多人不希望他們的個人數據公開在互聯網。個人數據可能被濫用於垃圾郵件或身份盜用。<br /><br />僅允許<u>授權的</u>用戶訪問此網站。管理員驗證並批淮您的帳戶申請後，您將能夠登錄並查看私人數據。<br /><br />如果已激活關係隱私，您將只能在登錄後訪問您自己的近親的私人信息。管理員還可以允許數據庫為某些用戶編輯，以便他們可以更改或添加信息。<br /><br />如果您需要任何進一步的支持，請使用以下鏈接與管理員聯繫。";
$pgv_lang["register_info_03"] = "~請求新的用戶帳戶~<br /><br />由於適用的隱私保護法律，可以在本網站公開查看的數據量可能會受到限制。許多人不希望他們的個人數據公開在互聯網。個人數據可能被濫用於垃圾郵件或身份盜用。<br /><br />僅允許<u>家庭成員訪問此網站</u>。管理員驗證並批淮您的帳戶申請後，您將能夠登錄並查看私人數據。<br /><br />如果已激活關係隱私，您將只能在登錄後訪問您自己的近親的私人信息。管理員還可以允許數據庫為某些用戶編輯，以便他們可以更改或添加信息。<br /><br />如果您需要任何進一步的支持，請使用以下鏈接與管理員聯繫。";


//-- Descendancy-page
$pgv_lang["help_descendancy.php"] = "~起源頁面~<br /><br />此頁面將顯示一個人的後代。<br /><br />您可以為此Descendancy圖表選擇一個起始（根）人員，或者您可以鏈接通過單擊另一頁上的<b>#pgv_lang[descend_chart]#</b>鏈接到此頁面。單擊箭頭圖標以箭頭方嚮導航此樹。單擊任何人員框中的圖表圖標以更改樹的根到那個人。";
$pgv_lang["desc_rootid_help"] = "#pgv_lang[rootid_help]#";
$pgv_lang["desc_generations_help"] = "#pgv_lang[PEDIGREE_GENERATIONS_help]#";

//-- Time line-page
$pgv_lang["help_lifespan.php"] = "~生活图表~<br /><br />在此圖表上，您可以沿水平時間線顯示一個或多個人。此圖表可讓您了解不同人的生活是如何重迭的。<br /><br />您可以單獨或按家庭組的ID將人員添加到圖表中。當您向圖表中添加更多人員時，將記住上一個列表。您可以隨時使用<b>清除圖表</b>清除圖表按鈕。<br /><br />您還可以通過按日期範圍或地點搜索人員來添加人員。";
$pgv_lang["lifespan_add_person_help"] = "#pgv_lang[add_person_help]#~包含即時家庭複選框~<br /><br />默認情況下選中包括直系親屬。請選中此選項以查看被添加到的個人的父親，母親，配偶，兄弟姐妹和子女時間表。如果你想省略直系親屬，請取消選中。";
$pgv_lang["help_timeline.php"] = "~時間表圖表~<br /><br />在此圖表上，您可以在時間軸上顯示一個或多個人。例如，您可以在某個時刻可視化兩個或更多人的狀態。<br /><br />如果您點擊其他頁面上的<b>時間線</b>鏈接，您將在時間線上看到一個人。如果您點擊了<b>時間線</b>菜單項頁眉，你必須提供起始人的身份證。";
$pgv_lang["add_person_help"] = "~添加人員到圖表~<br /><br />您可以在時間線上安排幾個人。<br /><br />使用此框提供每個人的身份證。如果您不知道身份證對於此人，您可以單擊該框旁邊的<b>查找ID</b>鏈接。";
$pgv_lang["remove_person_help"] = "~從圖表中刪除人員~<br /><br />點擊此鏈接可以從時間線中刪除此人。";
$pgv_lang["show_age_marker_help"] = "~顯示年齡標記~<br /><br />如果選中此框，您將看到年齡標記。<br /><br />您可以沿時間線向上或向下滑動此年齡標記。滑動年齡標記是檢查某個人在某個事件中的年齡的好工具。您可以為圖表中的每個人單獨啟用或禁用年齡標記。";
$pgv_lang["timeline_control_help"] = "~控制生命图表~<br /><br />~快速~<br /><br />點擊下拉菜單更改時間軸滾動的速度。<br /><br />~開始年份~<br /><br />輸入範圍的起始年份。<br /><br />~結束年份~<br /><br />輸入範圍的結束年份。<br /><br />~搜索~<br /><br />單擊\"搜索\"按鈕開始搜索在\"開始年份\"和\"結束年度\"字段標識的範圍內發生的事件。";

//-- Relationship-page
$pgv_lang["help_relationship.php"] = "~關係頁面~<br /><br />在這個頁面上你可以顯示任何兩個人之間的關係。這些人不必直接與血系相關;任何關係都會被找到。";
$pgv_lang["relationship_id_help"] = "~人1和人2的ID~<br /><br />如果您點擊<b>與我的關係</b>鏈接從另一個頁面跳到此頁面，您將看到這裡的關係你和其他人之間的關係。<br /><br />如果你通過任何頁眉上的<b>關係圖</b>菜單項到達此頁面，你必須輸入兩個人的標識號你希望看到誰的關係。如果你不知道所需人的標識符，你可以點擊<b>查找ID</b>鏈接。";
$pgv_lang["next_path_help"] = "~找到下一個路徑~<br /><br />您可以單擊此按鈕查看兩個人之間是否存在另一個關係路徑。通過單擊帶路徑編號的鏈接，可以再次顯示以前找到的路徑。";
$pgv_lang["follow_spouse_help"] = "~通過婚姻檢查關係- 檢查框~<br /><br />選中此復選框<b>聯繫</b>後，只檢查血緣關係之間的關係。選中此復選框後，通過婚姻關係也檢查了。你可能會通過選中此框來找到更多關係。";
$pgv_lang["line_up_generations_help"] = "~排隊生成- 檢查框~<br /><br />選中此復選框後，圖表將打印在頁面上水平排列的相同代數。如果未選中，則每一代都將顯示無論關係類型如何，都在頁面下方。";
$pgv_lang["oldest_top_help"] = "~顯示最舊的頂部- 檢查框~<br /><br />選中此復選框後，圖表將打印出頂部最老的人。未選中時，最年輕的人將出現在頂部。<注意：此選項僅在<b>#pgv_lang[line_up_generations]#</b>也被選中的情況下有效。";

//-- Ancestry-page
$pgv_lang["help_ancestry.php"] = "~#pgv_lang[ancestry_chart]#页面~<br /><br />祖先页面非常类似于<a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a非常相似>，但有更多詳細信息和替代<a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a>顯示。<br /><br />每個祖先都顯示一個唯一的編號，根據<i>Sosa-Stradonitz</i>系統計算：<div style=\"padding-left: 30px;\"><b>偶數</b>男性數字（孩子* 2）</><b>奇數</b>女性（丈夫+ 1）的數字除<b>1</b></div><br />示例：<br /><div style=\"padding-left: 30px;\">根人不論性別<b>1</b>。<br /><b>1</b>的父親<b>2</b>（<b>1</b> * 2），母親<b>3</b>（<b>2</b> + 1）。<br /><b>2</b>的父親是<b>4</b>（<b>2</b> * 2），母親<b>5</b>（<b>4</b> + 1）。<br /><b>3</b>的父親<b>6</b>（<b>3</b> * 2），母親<b>7</b>（<b>6</b> + 1）。<br /><b>7</b>的父親<b>14</b>（<b>7</b> * 2），母親<b>15</b>（<b> 14</b> + 1）。<br />等。</div>";
$pgv_lang["box_width_help"] = "~#pgv_lang[ancestry_chart]#盒子宽度~<br /><br />在這裡你可以將盒子寬度從50%改為300%。在100%時，每個盒子的寬度約為270像素。";
$pgv_lang["chart_style_help"] = "~#pgv_lang[chart_style]#~<br /><br />有兩種圖表樣式可供選擇：<ul><li><b>#pgv_lang[chart_list]#</b><br />垂直樹，帶可折迭/可擴展的家庭。</li><li><b>#pgv_lang[chart_booklet]#</b><br />每頁一個家庭，包括父母，祖父母和所有有記錄的孩子。<br /><br />這種格式很容易打印給你的親戚。</li></ul>";

//-- Fan chart-page
$pgv_lang["help_fanchart.php"] = "~#pgv_lang[fan_chart]#页面~<br /><br />圓形圖非常類似於<a href=\"?help=help_pedigree.php\"># pgv_lang[index_header]#</a>，但是以更加圖形化的方式。<br /><br />首发出现在中心，他的父母在第一個環上，祖父母在第二個環上，等等。<br /><br />已知的生日和去世年份以名稱印刷。<br /><br />點擊圖表上的名稱將打開特定於該人的鏈接菜單。從此菜單中，您可以選擇將圖表置於中心位置那個人或那個人的近親之一，或者你可以跳到那個人的#pgv_lang[indi_info]#頁面或那個人的不同圖表。";
$pgv_lang["fan_width_help"] = "~#pgv_lang[fan_chart]#宽度~<br /><br />在這裡，您可以將圖表寬度從50%更改為300%。在100%時，輸出圖像的寬度約為640像素。";
$pgv_lang["fan_style_help"] = "~#pgv_lang[fan_chart]#样式~<br /><br />此選項控製圖表的外觀。<ul><li><b>1/2</b><br />半圈180&deg;圖</li><li><b>3/4</b><br />四分之二270&deg;圖表，有時稱為<i>天使之翼</i></li><li><b>4/4</b><br />全圓360&deg;圖</li></ul>";

//-- Hourglass chart-page
$pgv_lang["help_hourglass.php"] = "~#pgv_lang[hourglass_chart]#~<br /><br />沙漏圖表將在同一圖表上顯示所選根人的祖先和後代。此圖表是Descendancy圖表和譜系圖表之間的混合。<br /><br />根人居中在頁面中間，他的後代列在左邊，他的祖先在右邊列出。在這個視圖中，每一代都排在整個頁面的最前面生成並以最新結束。<br /><br />如果根人員屏幕下方有一個向下箭頭，點擊它將顯示一個根人員的親密家庭成員列表，您可以使用向下導航從該列表中選擇一個名稱將重新加載圖表，並將所選人員作為新的根人員。";

//-- Family Book chart-page
$pgv_lang["help_familybook.php"] = "~#pgv_lang[familybook_chart]#~<br /><br />此圖表與沙漏圖非常相似。它將在同一圖表上顯示所選根人的祖先和後代。它還將顯示後代同一個沙漏格式的根人。<br /><br />根人居中在頁面中間，他的後代列在左邊，他的祖先列在右邊。在這個視圖中，每一代從最早的一代開始，以最新一代結束，整個頁面排成一行。<br /><br />根人的每個後代將成為另一個沙漏圖表的根人，打印在同一頁面上。重複，直到打印出指定數量的後代。";
$pgv_lang["fambook_descent_help"] = "~#pgv_lang[descent_steps]#~<br /><br />此值確定將以沙漏格式打印的根人的後代代數。";

//-- Indilist-page
$pgv_lang["help_indilist.php"] = "~個人名單~<br /><br />在此頁面上，您可以顯示個人名單。名稱將首先顯示姓氏，並按字母順序排序。<br /><br />輸出名稱列表取決於：<ol> <li>您在按字母順序索引中單擊的字母。</li><li>您是否單擊了\"跳過\"或\"顯示\"姓氏列表。</li></ol>#pgv_lang[context_help]#";
$pgv_lang["alpha_help"] = "~字母索引~<br /><br />單擊按字母順序索引中的字母將顯示以您單擊的字母開頭的名稱列表。<br /><br />第二項到最後一項按字母順序排列的索引可以是<b>#pgv_lang[NN]#</b>。當數據庫中有人沒有記錄姓氏或者不包含任何可識別的字母時，此條目將出現。未知的姓氏通常記錄為<b>？</b>，這些將被識別為<b>#pgv_lang[NN]#</b>。如果此人不明，也會發生這種情況。<br /><br /><b>注意：</b><br />輸入姓氏，例如，<b>Nn</b>，<b>NN</b>，<b>Unknown/b>，甚至<b>N.N.</b>将<u>不</u>在<b>#pgv_lang[NN]#</b>列表中找到。相反，您可以通过单击<b>N</b>或<b>U</b>找到这些人，因为这些是这些名称的首字母。PhpGedView不可能解释输入未知姓氏的所有可能方式; 没有公认的惯例。<br /><br />在按字母顺序排列的索引末尾，您会看到<b>所有</b>。當您單擊此條目時，您將看到數據庫中所有姓氏的列表。<br /><br /><b>缺字母？</b><br />如果您的字母索引似乎不完整，如果缺少字母，您的數據庫中不會包含以缺少字母開頭的任何姓氏。";
$pgv_lang["name_list_help"] = "~姓名列表~<br /><br />此框將顯示姓氏列表或完整姓名列表。在這兩種情況下，所有姓氏都將以您在按字母順序排列的索引中單擊的首字母開頭，除非您單擊<b>全部</b>。<br /><br />您是否會看到姓氏列表或完整的名單取決於<b>跳過/顯示姓氏列表</b>鏈接的狀態。";
$pgv_lang["skip_sublist_help"] = "~跳過子列表~<br /><br />標淮設置是，在您點擊字母索引的字母后，您將獲得一個帶有姓氏的子列表。如果您點擊此鏈接，所有姓氏的人當前選擇的首字母將立即顯示。此後，每當您點擊按字母順序列表中的新首字母時，將直接顯示個人列表。<br /><br />要撤消此操作，請單擊#pgv_lang[show_surnames]#链接。";
$pgv_lang["show_marnms_help"] = "~包括/排除已結婚的名字~<br /><br />個人和家庭列表頁面可以包含或排除已婚姓名。在搜索您只知道已婚姓名的個人或家庭時，此選項會很有用。如果名稱已存在於數據庫中，則只能包含這些名稱。<br /><br />在族列表中，此值默認為排除。在單個列表中，默認值在GEDCOM配置頁面中設置。<br /><br />當您更改此選項時，您的選擇將被記住，直到您註銷或會話結束。";

//-- Families-page
$pgv_lang["help_famlist.php"] = "~家庭列表頁面~<br /><br />在此頁面上，您可以顯示家庭列表。姓名將首先顯示姓氏，並按字母順序排序。<br /><br />輸出名稱列表取決於：<ol><li>您在按字母順序索引中單擊的字母。</li><li>您是否單擊了\"跳過\"或\"顯示\"姓氏列表。</li></ol>您可以搜索丈夫或妻子的姓氏;兩者都包括在列表中。<br /><br />#pgv_lang[context_help]#";
$pgv_lang["help_family.php"] = "~家庭詳情頁面~<br /><br />此頁面將向您顯示您在上一頁選擇的家庭概況。<br /><br />從上到下您將看到個人詳細信息丈夫和他的父母，妻子和父母以及孩子們的盒子。<br /><br />人員盒子的佈局和內容與您從譜系和後裔頁面中已經知道的盒子相同。<br /><br />在父框的右側，如果文件中存在更多祖先，您可能會看到一個箭頭。當您單擊該箭頭時，您將向上移動一代，以顯示一個新的族頁面。以前的父母現在被列為丈夫和妻子。<br /><br />在名稱框的右側，您可以看到一個縮放（放大鏡）圖標，您可以單擊該圖標以顯示有關個人的更多詳細信息。點擊你將被帶到該人的#pgv_lang[indi_info]#頁面的名稱。<br /><br />在右侧，您会看到一个小菜单，可以将您带到包含图表或更多信息的页面。其中一些菜單項也有子菜單，當您的鼠標指針接近父菜單項時會現這些子菜單。<br /><br />家庭組信息框顯示有關此家庭的所有已知事實和信息，例如婚姻，多媒體對象和筆記。在事實信息框中，單擊某個地點將轉到地點列表，其中顯示連接到該地點的所有其他家庭和個人。單擊日期將跳轉到日曆日曆，該日曆將顯示歷史記錄中當天和月份發生的所有事件。可以點擊多媒體對象;這將打開一個用於查看對象的新窗口。當您單擊圖片標題時，您將在#pgv_lang[media_list]#頁面上看到圖片。如果單擊源鏈接，該源的詳細信息將顯示在源頁面上。<br /><br />在子項的名稱框下方，您會找到<b>將子項添加到此族中</b>鏈接。在孩子的名稱框旁邊，您會看到<b>家庭群組信息</b>鏈接。如果您有足夠的權限，可以在此處編輯，刪除和添加數據和事實。<br /><br />與#pgv_lang[indi_info]#頁面一樣，您將看到頁面右上角的菜單。此菜中的條目會將您帶到其他頁面，您可以在其中獲取有關此系列的信息或執行與此系列相關的其他任務。#pgv_lang[more_help]#";
$pgv_lang["add_child_help"] = "~給這個家庭加上孩子~<br /><br />點擊此鏈接即可為這個家庭添加孩子。<br /><br />添加孩子很簡單：只需點擊鏈接，填寫彈出屏幕中的方框，就是這些。";
$pgv_lang["show_fam_gedcom_help"] = "~顯示GEDCOM記錄~<br /><br />單擊此鏈接時，將顯示有關該系列的信息，因為它存儲在數據庫中。顯示屏將顯示原始GEDCOM數據。";
$pgv_lang["add_fam_clip_help"] = "~添加家庭到剪报篮子~<br /><br />您可以將全部或部分家庭信息添加到#pgv_lang[clip_cart]#。在下一頁，您可以精確選擇要添加的信息量：<ol><li>#pgv_lang[just_family]#</li><li>#pgv_lang[parents_and_family]#</li><li>#pgv_lang[parents_and_child]#</li><li>#pgv_lang[parents_desc]#</li></ol>";
$pgv_lang["show_fam_timeline_help"] = "~顯示時間表上的偶像~<br /><br />當您單擊此鏈接時，您將跳轉到時間軸頁面，其中所有事實將在時間線範圍內顯示。";

//-- Source list-page
$pgv_lang["help_sourcelist.php"] = "~來源列表頁面~<br /><br />此頁面上顯示了一系列來源。<br /><br />与#pgv_lang[indi_info]#和系列页面不同，没有按字母顺序排列的索引。<br /><br />來源可以是個人，公共數據庫，機構，互聯網資源等。由於家譜來源的完全隨機性，因此無法找到有意義的排序順序。所有情況。但是，網站將源名稱按字母順序排序。<br /><br /><b>來源</b><br />沒有來源我們無法構建我們的數據庫。數據庫中的每個信息項都有一個來源。來源可以是親戚，機構，公共數據庫，政府或私人記錄，互聯網資源等。<br /><br />來源可以是與許多人有聯繫。一個人也可以鏈接到許多來源。每個事件都可以有不同的來源，無論是出生日期，職業，婚姻，子女等。";
$pgv_lang["sourcelist_listbox_help"] = "~來源列錶框~<br /><br />在此框中，您可以看到存儲在GEDCOM中的來源名稱。<br /><br />名稱按字母順序顯示。單擊列表中的名稱，您將轉到顯示列表的\"源\"頁面。此列表顯示哪些個人或家庭鏈接到該源。";

//-- Sources-page
$pgv_lang["help_source.php"] = "~來源詳情頁面~<br /><br />來源的詳細信息顯示在此頁面上。來源對於家譜研究人員非常重要，並且可以讓您跟踪另一位研究人員用來查找信息的踪跡。<br /><br />您可以看到有關源的標題，作者，出版物以及查找源的存儲庫的信息。由於有許多不同類型的源，某些源可能比其他源有更多信息。<br /><br />如果文檔掃描等多媒體對象連接到源，則可以通過單擊對象來查看該對象。单击对象名称时，您将在#pgv_lang[media_list]#页面上看到它。<br /><br />根據源詳細信息，列出了連接到此源的所有個人和家庭。這使您可以識別從該數據源獲得的所有條目。<br /><br />當管理員啟用這些功能時，您將有一個或兩個額外的m此頁面上的enu圖標：<ol><li><b>#pgv_lang[view_gedcom]#</b><br />以GEDCOM格式顯示信息。</li><li><b>#pgv_lang[add_to_cart]#</b><br />這使可以將此信息存儲在#pgv_lang[clip_cart]#中，以便以後下載並導入您自己的家譜程序。</li></ol><br />#pgv_lang[context_help]#";
$pgv_lang["sources_listbox_help"] = "~記錄鏈接到此源~<br /><br />在此框中，您可以看到與源連接的個人和家庭的名稱。<br /><br />名稱按字母順序顯示。當您單擊列表中的名稱時，您將轉到相關的詳細信息頁面。";
$pgv_lang["show_source_gedcom_help"] = "~顯示GEDCOM記錄~<br /><br />當您單擊此鏈接時，源的記錄將以原始數據庫格式顯示。";
$pgv_lang["add_source_clip_help"] = "~添加源到剪切篮~<br /><br />點擊此鏈接後，您可以將源信息添加到#pgv_lang[clip_cart]#中，以便以後下載並導入您自己的家譜程序。";
$pgv_lang["delete_source_help"] = "~從GEDCOM刪除源~<br /><br />當您單擊此選項時，您將標記此源將從數據庫中刪除。<br /><br />這是什麼意思？<br />假設您有充分的理由從數據庫中刪除此源。您單擊該鏈接。系統將要求您確認刪除請求。如果您決定繼續，可能需要一些時間才能看到消息來源刪除。<br /><br />當您繼續訪問時，您會注意到源仍然可見，並且可以像沒有發生刪除一樣使用。<br /><br /><b>這是<u>不</u>錯誤。</b>站點管理員將收到一條消息，表明已對數據庫進行了更改，並且您已刪除了源。<br />管理員可以接受或拒絕您的更改。只有在管理員接受您的更改後，才會實際刪除<u>不可逆轉</u>。如果對您的更改有任何疑問，管理員將與您聯繫。";

//-- Persons per Place-page  地点等级制度
$pgv_lang["help_placelist.php"] = "~地点等级制度~<br /><br />（或每個人的人數）<br /><br />此頁面將顯示GEDCOM中各個地點的層次結構以及哪些個人或家庭連接到某個位置。<br /><br />如果個人或家庭與某個地點的活動之間存在任何联系，網站會找到它。<br /><br />結果顯示在兩欄列表中，一欄為個人，一欄為家庭。<br /><br />#pgv_lang[more_help]#";
$pgv_lang["ppp_default_form_help"] = "~位置订单格式~<br /><br /><b>默認訂單</b><br />這意味著此GEDCOM文件中沒有聲明地點編碼格式，並且假設採用默認格式。如果找到了另一種格式，它將顯示在該行末尾的<b>（</b>和<b>）</b>之間。";
$pgv_lang["ppp_match_one_help"] = "~位置订单格式~<br /><br />GEDCOM订单<br />假定位置以GEDCOM文件中明確聲明的位置格式編碼。這取代了默認順序。";
$pgv_lang["ppp_numfound_help"] = "~找到地點連接~<br /><br />此處顯示的匹配數量。如果您仍然看到一個列錶框，其中包含您尚未達到最低級別的位置。<br /><br />您可以選擇查看連接到此地點的所有記錄，也可以通過單擊其他位置來優化搜索。";
$pgv_lang["ppp_levels_help"] = "~位置等級~<br /><br />這顯示了現在顯示的等級。顯示地點的列錶框實際上是最左邊一級的子列表。<br /><br />示例：<br />默認順序為#pgv_lang[default_form]#。<br />如果當前級別為\"頂級\"，則該框將列出數據庫中的所有國家/地區。<br />如果當前級別為\" ，頂級\"，該框將列出美國所有州等<br /><br />您可以點擊一個級別返回一個或多個步驟。";
$pgv_lang["ppp_placelist_help"] = "~地点等级制度~<br /><br />在此列表中，您可以看到從您選擇的當前位置所屬的位置。如果您尚未選擇某個位置，您將看到所有位置的列表頂級位置（例如國家或州）。<br /><br />列表中位置的名稱是可點擊的;單擊某個位置就像過濾器一樣，您將進入下一級別。";
$pgv_lang["ppp_placelist_help2"] = "~PLACE LIST~<br /><br />在此列表中，您可以看到在此階段找到的位置。<br /><br />列表中位置的名稱是可點擊的;單擊一個位置就像一個過濾器，你將被提升到一個新的水平。<br /><br />只有當你在頂層時才會顯示一個名單。在所有下級你會得到一個列表連接到該地點的家庭和個人。";
$pgv_lang["ppp_view_records_help"] = "~查看所有記錄~<br /><br />點擊此鏈接將顯示所有在此地點發生事件的個人和家庭的列表。當您到達地點層次結束時，通常是城鎮或城市，名單將自動顯示。";
$pgv_lang["ppp_name_list_help"] = "~姓名列表~<br /><br />此框將顯示連接到該位置的個人和家庭的完整列表。<br /><br />列表中的名稱是可點擊的。單擊時一個名稱，您將進入相關的詳細信息頁面。當您單擊此列表頂部的位置時，您將更改您的位置選擇。";

//-- Multimedia-page
$pgv_lang["help_medialist.php"] = "~多媒​​體對象列表~<br /><br />此頁面列出了可在此數據庫中找到的所有多媒體對象（MMO）。<br /><br />對於您看到的每個媒體條目條目的標題或文件名，與條目相關的個人或家庭的名稱，以及有關條目的註釋。<br /><br />單擊條目的標題或文件名與單擊其縮略圖具有相同的效果。條目將在網站內置的圖像瀏覽器中或瀏覽器配置中指定的查看器中打開。<br /><br />當您點擊此人或家人旁邊的\"查看\"鏈接時，您將成為進入相關的詳細信息頁面。";

//-- Upload Media-page
$pgv_lang["help_uploadmedia.php"] = "~上傳媒體文件~<br /><br />上傳媒體文件非常簡單。這裡有一些額外的信息。<br /><br /><b>縮略圖</b><br />縮略圖應該大小約為100px寬度。縮略圖<u>必須</u>與全尺寸版本相同。如果您的系統可以自動生成縮略圖，您將在\"上傳媒體\"頁面上看到相應的通知。<br /><br /><b>上傳</b><br />文件將自動上傳到<b>#GLOBALS[MEDIA_DIRECTORY]#</b>目錄中的全尺寸版本，並且<b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>用於縮略圖。<br /><br />#pgv_lang[readme_help]#";

//-- Anniversaries-page
$pgv_lang["help_calendar.php"] = "~#pgv_lang[anniversary_calendar]#~<br /><br /><ul><li><a href=\"#calendar_general\"><b>一般信息</b></a></li><li><a href=\"#calendar_day\"><b>#pgv_lang[day]#</b></a></li><li><a href=\"#calendar_month\"><b>#pgv_lang[月]#</b></a></li><li><a href=\"#calendar_year\"><b>#pgv_lang[year]#</b></a></li><li><a href=\"#calendar_show\"><b>#pgv_lang[show]#/#pgv_lang[showcal]#</b></a></li><li><a href=\"#calendar_sex\"><b>#pgv_lang[sex]#</b></a></li><li><a href=\"#calendar_event\"><b>活動</b></a></li><li><a href=\"#calendar_button\"><b>查看日/查看月/查看年份按鈕</b></a></li><li><a href=\"#calendar_tip\"><b>提示</b></a></li></ul><br /><a name=\"calendar_general\"></a>#pgv_lang[anniversary_calendar]#顯示在特定日期或某個時間段或某段時間內與某個事件相關聯的人員和家庭。它具有一個高級過濾系統，用於選擇正確的日期，期間和適合您的活動。<dl><dt><b>查看<a href=\"#calendar_day\">日</a></b></dt><dd> T他在某一天顯示事件，與所選年份無關。輸出將是包含個人或家庭名稱的單個列表，或者是一側包含個體而另一側包含家庭的兩列列表。</dd><dt><b>查看<a href=\"#calendar_month\">月</a></b></dt><dd>在此日曆中，個人和家庭的名稱顯示在日期框內。日曆顯示為您在年份框中輸入的年份。顯示過去一年中發生的所有事件。<br /><br />結合選項<a href=\"#calendar_show\"><b>#pgv_lang[recent_events]#</b></a>，它將為您的祖先的日曆顯示一個真實的視圖。</dd><dt><b>查看<a href=\"#calendar_year\">年</a></b></dt><dd>顯示某年或某些年份的事件。輸出將是一個包含個人或家庭名稱的列表，或者一列中包含個人而另一側包含家庭的兩列列表。</dd></dl>當前顯示的日期和月份在日曆菜單中突出顯示。<br /><br />所有名稱和日期都是可點擊的。單擊名稱後，您將進入相關的\"詳細信息\"頁面。點擊日期將跳轉到\"今天\"或\"年\"模式，這將顯示點擊日期中日期和月份的所有事件。<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_day\"></a>#pgv_lang[annivers_date_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_month\"></a>#pgv_lang[annivers_month_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_year\"></a>#pgv_lang[annivers_year_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_show\"></a>#pgv_lang[annivers_show_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_sex\"></a>#pgv_lang[annivers_sex_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_event\"></a>#pgv_lang[annivers_event_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_button\"></a>#pgv_lang[day_month_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\" calendar_tip\"></a>#pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"] = "~日选择器~<br /><br />选择器表的第一行是<b>天</b>选择器。它的意思很明顯：你選擇<u>天</u>。<br /><br />點擊某一天的結果取決於您是在<b>日</b>還是在<b>月</b>模式。<br /><dl><dt><b>日模式</b></dt><dd>在此模式下，您點擊一天，屏幕將刷新，並顯示當天的列表。</dd><dt><b>月份模式</b></dt><dd>您在屏幕上顯示某個月的日曆。这样做的原因是，在您单击<b>#pgv_lang[viewday]#</b>或<b>#pgv_lang[viewmonth]#</b>按钮之前，您仍然可以决定选择其他月份，年份或事件。<br /><br />在一天結束時，您將看到帶有今天日期的<b>快速鏈接</b>。点击<b>快速链接</b>将在<b>日</b>模式下显示今天的列表，无论您是在<b>月</b>还是在<b>日</b>模式。</dd></dl>";
$pgv_lang["annivers_month_select_help"] = "~月选择器~<br /><br />選擇器表的中間行是<b>月</b>選擇器。它的含義很明顯：你選擇<u>月</u>。<br /><br />點擊某個月的結果取決於您是在<b>日</b>還是在<b>月</b>模式。<br /><dl><dt><b>日模式</b></dt><dd>在此模式下，您點擊一個月，屏幕將刷新，並顯示該月的列表。所有其他選項，如日，年和事件將保持不變。</dd><dt><b>月份模式</b></dt><dd>當您在屏幕上顯示日曆並點擊<b>月中的一個月</b>行，將顯示該新月的日曆。<br /><br />在月末行中，您將看到<b>快速鏈接</b>與今天的月份和年份。點擊<b>快速鏈接</b>將在<b>月</b>模式下顯示該月的列表，無論您是在<b>月</b>還是在<b>日</b>模式</dd></dl>";
$pgv_lang["annivers_year_select_help"] = "~年份輸入框~<br /><br />此輸入框可讓您更改日曆的年份。在框中鍵入年份，然後按<b>输入</b>將日曆更改為該年份。<br /><br /><b>高級功能</b><b>#pgv_lang[viewyear]#</b><dl><dt><b>超過一年</b></dt><dd>您可以搜索多年的日期。<br /><br />年份範圍<u>包含</u>。這意味著日期範圍從第一年的1月1日開始截至去年12月31日的範圍。以下是一些年範圍的例子：1992年至1995年所有事件的年份範圍：<br /><br /><b>1992-5</b>。<br /><b>1972-89</b>適用於1972年至1989年的所有活動。<br /><b>1610-759</b>適用於所有1610至1759年的活動。<br /><b>1880-1905年</b>從1880年到1905年的所有活動。<br /><b>880-1105</b>所有活動從880到1105.<br /><br />要查看所有活動給定十年或一世紀，您可以使用<b>?</b>代替最終數字。例如，对于从1970年到1979年的所有事件，<b>197?</b>，对于从1600到1699的所有事件，<b>16??</b>。<br /><br />選擇一個年份範圍會將日曆更改為年視圖。</dd></dl>";
$pgv_lang["annivers_show_help"] = "~顯示的事件......~<br /><br />以下選項可供選擇：<br /><ol><li><b>所有人</b><br />使用此選項，顯示所有個人和家庭。</li><li><b>近年（&lt;100歲）</b><br />使用此選項，您將看到所選日期或月份的所有事件，但不會將顯示超過100年的事件。</li><li><b>活著的人</b><br />除非管理員已配置網站以便任何人都可以看到活著的人，否則此選項將僅可用登錄後給你。<br /><br />使用此選項，只顯示活人的事件。</li></ol>當您點擊選項時，您選擇的事件將顯示。<br /><br />日，月和年的設置，以及<b>日</b>或<b>月</b>模式，保持不變。";
$pgv_lang["annivers_sex_help"] = "~GENDER SELECTOR~<br /><br />當您登錄或管理員未啟用隱私選項時，您可以選擇以下選項之一：<ol><li><b>全部</b> icon<br />這是默認選項。顯示所有個人和家庭的事件。</li><li><b>男性</b>圖標<br />僅顯示男性個人的事件。只有男性家庭成員才會參加家庭活動。</li><li><b>女性</b>圖標<br />僅顯示女性個人的活動。只有女性家庭成員將與家人一起展示事件。</li></ol>當您點擊某個選項時，將顯示您選擇的事件。<br /><br />日，月和年的設置，以及<b>日</b>或<b>月</b>模式，保持原樣。";
$pgv_lang["annivers_event_help"] = "~事件選擇器~<br /><br />在這裡，您可以選擇是否要顯示個人和家庭的所有活動或僅選擇一個活動。您不能選擇多個活動類別。<br /><br />點擊選項，將顯示您選擇的事件。<br /><br />日，月和年的設置，以及<b>日</b>或<b>月</b>模式，保持原樣。";
$pgv_lang["annivers_tip_help"] = "~提示~<br /><br />將日期選擇器調整到過去的任何日期。<br /><br />當您單擊其中一個視圖按鈕時，您將看到該日期的列表或日曆所有的年齡，紀念日等都已經重新計算，現在從你在日期選擇器中設置的日期開始計算。你現在看到你的祖先在幾年前的那個日期會看到的日曆或列表。";
$pgv_lang["day_month_help"] = "~查看日/查看月份/查看年份按鈕~<br /><br /><ul><li><b>查看日</b>按鈕將在列表中顯示所選日期的事件。掃描年份，因此只能在此處設置日期和月份。更改年份將無效。您可以通過選擇<b>近年</b>或<b>生活人員</b選項來減少列表> 。<br /><br />列表中的年齡將從當前年份計算。</li><li><b>查看月份</b>按鈕將顯示所選月份的日曆圖表您也可以通過選擇<b>近年</b>或<b>活著的人</b>來減少列表。<br /><br />您將獲得一個真實的印象您祖先的牆上的日曆看起來就像過去選擇一年並結合<b>近年</b>。日曆上的所有年齡都顯示相對於年份框中的年份。</li><li><b>查看年份</b>按鈕將顯示所選年份的事件列表。您也可以通過選擇減少列表選項<b>近年</b>或<b>活著的人</b>。<br /><br />您可以展示多年的活動。只需鍵入範圍的開始和結束年份，並在它們之間用短劃線<b>-</b>。例如：<br /><b>1992-4</b> 1992年至1994年的所有活動<br /><b>1976-1984</b> 1976年至1984年的所有活動<br /><br要查看給定十年或一個世紀內的所有事件，您可以使用<b>?</b>代替最終數字。例如，對於從1970年到1979年的所有事件，<b>197?</b>，對於從1600到1699的所有事件，<b>16??</b>。</li></ul>當你想要<b>更改年份</b>您按下這三個按鈕之一。所有其他設置保持不變。";

//-- Clippings Cart-page
$pgv_lang["help_clippings.php"] = "~家庭樹剪裁卡~<br /><br />#pgv_lang[clip_cart]#允許你從這個家譜中提取（\"剪報\"）並將它們捆綁到一個文件中進行下載和隨後導入你自己的家譜程序。可下載的文件以GEDCOM格式記錄。<br /><ul><li>如何剪報？<br />這很簡單。每當你看到一個可點擊的名字（個人，您可以轉到該名稱的詳細信息頁面。在那裡您將看到<b>#pgv_lang[add_to_cart]#</b>選項。當您單擊該鏈接時，您將獲得幾個下載選項。</li><li>如何下載？<br />購物車中有物品後，只需點擊<b>立即下載</b>鏈接即可下載。按照說明和鏈接進行操作。</li></ul>";
$pgv_lang["clip_download_help"] = "~下載剪輯~<br /><br />當您點擊此鏈接時，您將進入下一頁。如果購物車中的任何剪報涉及多媒體條目，這些條目也將顯示在該頁面上。<br /><br />只需按照說明操作。";
$pgv_lang["empty_cart_help"] = "~清空剪裁卡~<br /><br />當您點擊此鏈接時，您的#pgv_lang[clip_cart]#將被完全清空。<br /><br />如果您不想刪除所有人來自#pgv_lang[clip_cart]#的家庭等，您可以通過單擊名稱框中的<b>刪除</b>鏈接單獨刪除條目。當您有<u>否</u>確認對話框時單擊這些鏈接中的任何一個;請求的刪除立即發生。";
$pgv_lang["add_by_id_help"] = "~CLIPPINGS CART ADD BY ID~<br /><br />This input box lets you enter an individual's ID number so he can be added to the Clippings Cart. Once added you'll be offered options to link that individual's relations to your Clippings Cart.<br /><br />If you do not know an individual's ID number, you can perform a search by name by pressing the Person icon next to the Add button.";
$pgv_lang["zip_help"] = "~ZIP CLIPPINGS~<br /><br />選擇此選項以將剪輯保存在ZIP文件中。有關ZIP文件的更多信息，請訪問<a href=\"http ://www.winzip.com\" target=\"_ blank\"> http://www.winzip.com</a>。";
$pgv_lang["include_media_help"] = "~包含媒體~<br /><br />選擇此選項可在剪報欄中包含與記錄關聯的媒體文件。選擇此選項將在下載過程中自動壓縮文件。";
$pgv_lang["clip_cart_help"] = "~CLIPPINGS CART~<br /><br />此框顯示Clippings Cart的內容。<i>Types</i>列表示每個條目的類型，可以是Individual（INDI ），Family（ FAM），源（SOUR），存儲庫（REPO），註釋（註釋）和媒體（OBJE）;每個都由它自己的圖標表示。<i>ID</i>列顯示每個條目的ID號。該特定類型。<i>名稱/描述</i>列提供家庭或個人的名稱，或條目的描述。刪除按鈕將從剪報購物車中刪除該記錄。<b>確認不要求刪除。</b>";

//-- GEDCOM Edit Utility
$pgv_lang["show_changes_help"] = "~向GEDCOM顯示變化~<br /><br />當您看到此消息時，它意味著兩件事：<ol><li>有人對GEDCOM進行了更改<br />記錄可能已被添加，刪除或更改。</li><li>管理員尚未接受更改。<br />一旦更改被接受或拒絕，您將不再看到此消息。</li></ol>您可以看到點擊鏈接時所做的更改。如果您發現更改不正確，請通知管理員。";

//-- Search-page
$pgv_lang["help_search.php"] = "~搜索頁面~<br /><br />雖然這個頁面看起來非常簡單，但這兩個表格背後有一個非常強大而復雜的搜索引擎。大多數家譜網站只是讓你搜索一個名字.網站可以讓你搜索幾乎所有內容。<br /><br />屏幕左側的搜索框與每個頁眉中的搜索框相同。<br /><br />如果您正在尋找相關人員到某一年，只需鍵入年份。該程序將為您找到所有連接。<br /><br />尋找名稱或地點？只需輸入名稱或地點，完全或只是輸入一部分和網站完成剩下的工作。<br /><br /><b>Soundex搜索方法</b><br />使用右側的搜索框，您可以搜索人員和地點的名稱，即使您不知道如何寫出這個名字。<br /><br />當一個網站上有幾個家譜數據庫且管理員已經啟用它們之間切換時，你的搜索將返回所有這些數據庫的結果。<br /><br />您可以通過單擊方框上方的<b>？</b>找到有關這兩個框的多幫助。";
$pgv_lang["search_enter_terms_help"] = "輸入搜索條件<br /><br />在此搜索框中，您可以輸入日期，姓名，姓氏，地點，多媒體等條件。<br /><br /><b>通配符</b><br />您不太可能知道通配符（如*或？），但程序會自動採用通配符。<br /><br />假設您在搜索框中輸入以下內容：<b>Pete</b>。結果可能是，假設名稱在數據庫中：<div style=\"padding-left:30px;\">b>Pete</b> Smith<br /><b>Pete</b>r Johnes<br />Will <b>Pete</b>rson<br />某人-1901年1月1日出生<b>Peter</b>rsburg<br />等。</div><br /><b>日期</b><br />在\"搜索\"框中鍵入一年將生成以某種方式與該年相關聯的個人列表。<br /><br />如果您輸入<b>1950</b>，結果將是所有發生在1950年的事件的個人。這些事件可能是出生，死亡，婚姻，成人禮，LDS Sealings等等<br /><br />如果你輸入<b>4 Dec日</b>，將列出與任何一年的12月4日發生的事件有關的所有人員。12月14日或24日與活動有關的人員也將被列入名單。如您所見，始終假設通配符，因此您不必鍵入它們。有時，結果可能會令人驚訝。<br /><br /><b>正確的日期</b><br />網站搜索數據，因為它們存儲在GEDCOM文件中。例如，如果您要在12月14日搜索某個活動，則應鍵入<b>14&nbsp;dec</b>，因為這是日期在數據庫中的存儲方式。<br /><br />如果你打算輸入<b>dec&nbsp;14</b>，結果可能是一個人在08&nbsp;<b>dec</b>ember&nbsp;18<b>14</b>上與一個事件相關聯。同樣，結果可能會令人驚訝。<br /><br />如果您熟悉它們，可以在搜索中使用正則表達式。例如，如果你想找到所有在20世紀都有約會的人，你可以輸入搜索<b>19[0-9][0-9]</b>然後你會得到所有的日期為1900-1999的人。<br /><br />如果您需要有關此搜索系統的更多幫助，請告訴我們，以便我們也可以擴展此幫助文件。<br /><br />#pgv_lang[soundex_search_help]#<br /><br />#pgv_lang[search_replace_help]#";
$pgv_lang["search_replace_help"] = "~#pgv_lang[search_replace]#~<br /><br />在這裡，您可以搜索拼寫錯誤或其他不淮確的信息，並用正確的信息替換。<br /><br /><b>搜索</b><br />此功能執行搜索就像<a href=\"help_text.php?help=search_enter_terms_help\">正常搜索</a>一樣。<br /><br /><b>替換</b><br />所有搜索詞的實例都被數據庫中的替換詞取代。<br /><br /><b>例如......</b><br />假設你不小心拼錯了你的曾祖父邁克爾的名字。你不小心進入了'邁克爾'。<br /><br />你可以在搜索框中輸入<b>Micheal</b>，然後在替換框中輸入<b>Michael</b>。<br />每個\"Micheal\"的實例然後將被\"邁克爾\"取代<br /><br /><b>搜索...</b><br />選擇搜索範圍。您可以將搜索範圍限制為名稱或地點，或者不應用任何限制（搜索所有內容）。<i>#pgv_lang[search_place_word]#</i>選項只會在地點字段中搜索您的術語作為整個單詞。這意味著搜索<i>UT</i>只會匹配<b>UT</b>，而不是<i>UT</i>，而不是其他字樣，例如Connectic<b>ut</b>。<br /><br />如果您不小心更换了您不想要的东西，请不要担心。只需點擊頁面底部的\"接受/拒絕更改\"鏈接即可接受你想要的更改，並拒絕你不想要的更改。<br /><br />如果您需要有關此搜索系統的更多幫助，請告訴我們，以便我們也可以改進此幫助文件。";
$pgv_lang["soundex_search_help"] = "~#pgv_lang[soundex_search]#~<br /><br />Soundex是一種根據發音對單詞進行編碼的方法。當你不確切地知道它們是怎樣的時候，你可以搜索數據庫中的名字和地點。 網站支持兩種不同的Soundex算法，可以產生截然不同的結果。<ul><li><b>基本</b><br />這種方法於1918年由Russell獲得專利，非常簡單，可以手工完成。<br /><br />因為Basic方法保留了名稱的第一個字母作為結果代碼的一部分，所以當你不確定第一個字母時，它不是很有用.Basic算法不太適合於名字最初使用英語以外的語言，即使是英文名稱，結果也非常令人驚訝。例如，基本Soundex搜索<b>Smith</b>不僅會返回<b>Smith，Smid，Smit，Schmidt，Smyth，Smithe，Smithee，Schmitt</b>，所有這些都是<b>Smith</b>的明顯變體，但<b>Smead，Sneed，Smoote，Sammett，Shand，</b>和<b>Snoddy</b>。<br /><br /></li><li><b>Daitch-Mokotoff</b><br />這種方法是在1985年開發的，它比Basic方法複雜得多，並且不容易通過使用此方法的Soundex搜索可以產生更淮確的結果。</li></ul>有關Soundex算法的詳細信息，請訪問<a href=\"http://www.jewishgen.org/infofiles/soundex.html\" target=\"_blank\"><b>猶太家譜學會</b></a>網頁。";
$pgv_lang["search_exclude_tags_help"] = "~#pgv_lang[search_tagfilter]#~<br /><br /><b>#pgv_lang[search_tagfon]#</b>選項將導致搜索功能忽略以下GEDCOM標記：<div style=\"padding-left: 30px;\"><b>_PGVU</b> - 最後更改<br /><b>CHAN</b> - 上次更改日期<br /><b>FILE</b> -#factarray[FILE]#<br /><b>FORM</b> - #factarray[FORM]#<br /><b>TYPE</b> - #factarray[TYPE]#<br /><b>SUBM</b> - #factarray[SUBM]#<br /><b>REFN</b> - #factarray[REFN]#</div><br />除了這些可選的排除標籤外，搜索函數總是排除這些標記：<div style=\"padding-left: 30px;\"><b>_UID</b> - #factarray[_UID]#<br /><b>RESN</b> -#factarray[RESN]#</div>";
$pgv_lang["search_include_ASSO_help"] = "~#pgv_lang[search_asso_label]#~<br /><br />此選項使網站顯示所有被記錄為與作為搜索直接結果的人或家庭有關聯關係的個人。反之，如果發現作為搜索直接結果的人與這些其他人或家庭有關聯關係，則顯示所有人或家庭。<br /><br />示例：假設某人<b>A</b>對人<b> B</b>是顯而易見的。這種關係通過ASSO標籤記錄在人<b>B</b>的GEDCOM記錄中.GEDCOM中不存在相應的標記人員記錄<b>A</b>。<br /><br />此选项设置为<b>#pgv_lang[yes]#</b>且搜索结果列表包含<b>B</b>时，由于其中的ASSO标签，将自动包含<b>A</b> GEDCOM记录<b>B</b>。但是，如果搜索结果列表包含<b>A</b>，当则不会自动包含<b>B</b>，因为人<b>A</b>的GEDCOM记录中没有匹配的ASSO标记。";

//-- Individual Information-page
$pgv_lang["help_individual.php"] = "~#pgv_lang[indi_info]#頁面~<br /><br />此人的所有詳細信息都會顯示在此頁面上。<br /><br />如果有可用的圖片，您將在左上方。你會看到圖片旁邊的人的姓名。<br /><br />姓名可以附加註釋和來源。如果任何名稱有註釋或來源，你會看到他們列出與他們有關的名字。<br /><br />一個人可能有一個AKA（也許他的名字是另一個名字）。如果是這樣的話，它會被顯示出來。<br /><br />如果您擁有此人的修改權限，您還會看到可以編輯的條目旁邊的<b>修改</b>和<b>刪除</b>鏈接。<br /><br />在此頁面上你會看到<b>#pgv_lang[personal_facts]#</b>，<b>#pgv_lang[notes]#</b>，<b>#pgv_lang[ssourcess]#</b>，<b>的標籤頁#pgv_lang[media]#</b>和<b>#pgv_lang[relatives]#</b>。這些標籤頁顯示了存儲在數據庫中的有關此人的所有信息。<br /><ul><li><b>#pgv_lang[personal_facts]#</b>標籤將向您顯示有此人的事實和詳細信息以及他們婚姻中的任何事實。單擊此選項卡上的任何日期將轉到該日期的#pgv_lang[anniversary_calendar]#，以便您可以查看同一天發生的其他事件。單擊某個地點將轉到\"地方層次結構\"，您可以在其中查看在同一地點有活動的其他人。對於婚姻和其他與家庭有關的事實，可以提供配偶的姓名，以便您可以查看配偶，並提供家庭記錄的鏈接。</li><li><b>#pgv_lang[notes]#</b>標籤會顯示與此人相關的任何一般說明。</li><li><b>#pgv_lang[ssourcess]#</b>標籤會顯示所有<u>一般</u>這個人的來源。這些來源<u>不</u>與個人事實有關，甚至與個人姓名無關;他們與個人本身有關。單擊源標題將轉到更詳細的源信息頁面，該頁面將顯示同樣鏈接到同一源的其他人。</li><li><b>#pgv_lang[media]#</b>選項卡將列出附加到此個人的所有圖片和其他媒體條目。單擊圖片的縮圖將打開更大的圖像視圖。點擊圖片標題將在#pgv_lang[media_list]#页面上顯示圖片。</li><li><b>#pgv_lang[relatives]#</b>標籤列出了此人的父母和兄弟姐妹就像這個人所擁有的所有配偶和孩子一樣。這些人將被列在類似於您可能已經看過的圖表的框中。</li></ul>在屏幕右側，您會找到一個帶鏈接的框。框中的許多鏈接與菜單中的鏈接相同。例如，單擊側鏈接上的<b>#pgv_lang[pedigree_chart]#</b>鏈接將轉到此人的譜系圖表。這與菜單鏈接不同，因為單擊菜單中的<b>#pgv_lang[pedigree_chart]#</b>鏈接將返回到此數據庫的默認譜系圖表。<br /><br />如果管理員已啟用此列表中可能出現的鏈接之一是<b>#pgv_lang[view_gedcom]#</b>鏈接。此鏈接將顯示此人的原始GEDCOM記錄。<br /><br />如果站點管理員已啟用#pgv_lang[clip_cart]#，您還將擁有一個鏈接，允許您添加此鏈接#pgv_lang[clip_cart]的人#。<br /><br /><b>#pgv_lang[relationship_to_me]#</b>鏈接僅在您登錄並在GEDCOM中分配了ID後才會顯示。此鏈接將帶您進入譜系圖表並告訴您與此人的關係。<br /><br />#pgv_lang[context_help]#";
$pgv_lang["delete_person_help"] = "~從GEDCOM刪除人員~<br /><br />當你點擊這個選項時，你會將這個人標記為從數據庫中刪除。<br /><br />這是什麼意思？<br />我們假設您有充分的理由從數據庫中刪除此人。您單擊該鏈接。系統將要求您確認刪除請求。如果您決定繼續，可能需要一些時間才能看到個人的消息刪除。<br /><br />當你繼續訪問時，你會注意到這個人仍然可見，可以像沒有發生刪除一樣使用。<br /><br /><b>這是<u>不</u>錯誤。</b>站點管理員將收到一條消息，表明已對數據庫進行了更改，並且您已刪除該個人。<br />管理員可以接受或拒絕您的更改。只有在管理員接受您的更改後，才會實際刪除<u>不可逆轉</u>。如果對您的更改有任何疑問，管理員將與您聯繫。";
$pgv_lang["delete_name_help"] = "~編輯或刪除GEDCOM的姓名~<br /><br /><b>編輯姓名</b><br />當您點擊此鏈接時，將打開另一個窗口。在那裡您可以編輯該人的姓名只需在框中鍵入更改，然後單擊按鈕，關閉窗口即可。<br /><br /><b>刪除名稱</b><br />單擊此選項，您將標記為要從數據庫中刪除的名稱。請注意，刪除名稱與刪除個人完全不同。刪除名稱只會刪除該人員的名稱。該人員將<u>不</u>被刪除。如果是你要刪除的AKA，這個人還有其他名字。如果你想刪除<u>唯一的</u>名字，那麼這個人仍然不會被刪除，但現在會記錄為<b>#pgv_lang[NN]#</b>。此人也不會與親戚，消息來源，筆記等脫節。<br /><br />它是如何運作的？<br />你會被要求確認你的刪除請求。如果你決定繼續，可以採取一個li在您看到刪除名稱的消息之前的時間。<br /><br />當您繼續訪問時，您會注意到該名仍然可見，並且可以像沒有發生刪除一樣使用。<br /><br /><b>這是<u>不</u>錯誤。</b>網站管理員會收到一條消息，說明已對數據庫進行了更改，並且您刪除了該名稱。<br />管理員可以接受或拒絕您的更改。只有在管理員接受您的更改後，才會實際刪除<u>不可逆轉</u>。如果對您的更改有任何疑問，管理員將與您聯繫。";
$pgv_lang["add_name_help"] = "~添加新名稱~<br /><br />此鏈接將允許您為此個人添加其他名稱。有時人們會被其他名稱或別名所知。此鏈接允許您向人員添加新名稱而不更改舊名。";
$pgv_lang["add_sibling_help"] = "~#pgv_lang[add_sibling]#~<br /><br />當您點擊此鏈接時，您可以將一個孩子添加到此家庭。\"此家庭\"，在這種情況下，是校長的父親和母親這個屏幕的人。<br /><br />請記住，你要添加一個兄弟姐妹。添加一個兄弟或姐妹很簡單：只需點擊鏈接，填寫彈出屏幕中的框這就是全部。<br /><br />如果你必須添加一個主要人物的兒子或女兒，向下滾動一點，然後單擊\"#pgv_lang[as_spouse]#\"中的鏈接。";
$pgv_lang["add_son_daughter_help"] = "~#pgv_lang[add_son_daughter]#~<br /><br />當您點擊此鏈接時，您可以將一個孩子添加到此家庭。\"此家庭\"，在這種情況下，是此屏幕的主要人員，他或她的配偶。<br /><br />請記住，你要添加一個兒子或女兒。添加一個兒子或女兒很簡單：只需點擊鏈接，填寫彈出框中的框屏幕就是這樣。<br /><br />如果你必須添加一個主要人物的兄弟或姐妹，請向上滾動一點，然後單擊\"#pgv_lang[as_child]#\"中的鏈接。";
$pgv_lang["link_child_help"] = "~#pgv_lang[link_as_child]#~<br /><br />當您點擊此鏈接時，您可以將此人作為孩子鏈接到現有家庭。<br /><br />假設父母一次這個人的身份不明，你後來發現父母在這個數據庫中有記錄。<br /><br />只需點擊鏈接，輸入家庭的ID，你就完成了任務。不知道家庭的身份證，你可以搜索它。";
$pgv_lang["link_husband_help"] = "~#pgv_lang[link_as_husband]#~<br /><br />此條目允許您將當前個人作為丈夫鏈接到已存在於數據庫中的家庭。通過單擊此鏈接，您可以將此人添加到一個現存的家庭，到目前為止，丈夫一直不知道。這個人將取代以前不為人知的丈夫。所有事件，婚姻信息和孩子將保持與家庭的現有聯繫。<br /><br />只需單擊鏈接，輸入系列的ID，即可完成任務。這是一個高級編輯選項，只有在您要鏈接的系列已存在時才能使用。如果要添加<u>新的</u>系列，請使用<b>#pgv_lang[add_new_wife]#</b>鏈接。";
$pgv_lang["add_husband_help"] = "~#pgv_lang[add_new_husb]#~<br /><br />點擊此鏈接，您可以添加一個<u>新的</u>男性人物，並將此人物作為新丈夫鏈接到主要個人。<只需單擊該鏈接，您將彈出一個窗口以添加新人。填寫盡可能多的框，然後單擊<b>保存</b>按鈕。<br /><br />就是這樣。";
$pgv_lang["link_new_husb_help"] = "~#pgv_lang[link_new_husb]#~<br /><br />這將允許您將已經存在的另一個人與此人的新丈夫聯繫起來。這將與您選擇的丈夫建立一個新的家庭。您還可以選擇為這個新家庭指定婚姻。";
$pgv_lang["add_opf_child_help"] = "~#pgv_lang[add_opf_child]#~<br /><br />單擊此鏈接，您可以向此人添加<u>新</u>子項，從而創建一個單親家庭。<br /><br />只需單擊該鏈接，您將彈出一個窗口來添加新人。盡可能多地填寫框並單擊<b>保存</b>按鈕。<br /><br />這就是全部。";
$pgv_lang["link_wife_help"] = "~#pgv_lang[link_as_wife]#~<br /><br />此條目允許您將當前個人作為妻子鏈接到已存在於數據庫中的家庭。<br /><br />這是高級編輯選項，只有在您要鏈接的系列已經存在時才能使用。如果要為此人添加<u>新</u>系列，請使用<b>#pgv_lang[add_new_husb]#</b>鏈接。";
$pgv_lang["add_wife_help"] = "~#pgv_lang[add_new_wife]#~<br /><br />點擊此鏈接，您可以添加<u>新</u>女性，並將此人作為新妻子鏈接到主要人員。<只需單擊該鏈接，您將彈出一個窗口以添加新人。填寫盡可能多的框，然後單擊<b>保存</b>按鈕。<br /><br />就是這樣。";
$pgv_lang["link_new_wife_help"] = "~#pgv_lang[link_new_wife]#~<br /><br />This will allow you to link another individual, who already exists, as a new wife to this person. This will create a new family with the wife you select. You will also have the option of specifying a marriage for this new family.";
$pgv_lang["add_new_parent_help"] = "#pgv_lang[multiple_help]#<br />~添加新的父親或母親~<br /><br />GEDCOM中肯定有很多人沒有父親或母親的記錄。<br /><br />在這種情況下，在<b>#pgv_lang[indi_info]#</b>頁面，標籤頁<b>#pgv_lang[親屬]#</b>，表<b>#pgv_lang[as_child]#</b>，你會找到為個人添加<u>新</u>父親或母親的鏈接。<br /><br />請記住，這些鏈接用於添加<u>新</u>父親或母親。如果父親或母親已在此數據庫中有記錄，則必須使用鏈接<b>#pgv_lang[link_as_child]#</b>，你可以在最后一张表下方的<b>#pgv_lang[indi_info]#</b>页面找到它。";
$pgv_lang["show_fact_sources_help"] = "~#pgv_lang[show_fact_sources]#~<br /><br />~#pgv_lang[show_fact_notes]#~<br /><br />選中此選項後，您可以看到此人的所有來源或備註記錄。如果未選中此選項，則不會顯示與此人的其他事實相關聯的源或註釋記錄。";
$pgv_lang["age_differences_help"] = "~#pgv_lang[age_differences]#~<br /><br />選中此選項框後，«#pgv_lang[relatives]#»選項卡將顯示日期差異，如下所示：<br /><ul><li>合作夥伴的出生日期。<br />負值表示第二個合作夥伴比第一個合夥人年齡大。<br /><br /></li><li>第一個孩子的結婚日期和出生日期。<這裡的負值表示孩子在結婚日期之前出生，或者出生日期或結婚日期是錯誤的。<br /><br /></li><li>兄弟姐妹的出生日期。<br />這裡的負值表示孩子的順序錯誤或者其中一個出生日期是錯誤的。</li></ul>";

//-- Add Facts
$pgv_lang["add_facts_help"] = "~添加新事實~<br /><br />在這裡你可以為正在編輯的記錄添加一個事實。<br /><br />首先從下拉列表中選擇一個事實，然後點擊<b>添加</b>按鈕。您可以添加到數據庫的所有可能事實都在該下拉列表中。";
$pgv_lang["add_custom_facts_help"] = "~添加自定義事實~<br /><br />如果您無法找到想要添加到GEDCOM事實列表中的事實，您也可以輸入<b>自定義事實</b>。<br /><br />輸入自定義事實就像輸入一個預定義的事實一樣簡單。唯一的區別是你必須命名事實而不是從列表中選擇它的名字。你必須這樣做這在頂部字段中：<b>#pgv_lang[type]#</b><br />";
$pgv_lang["add_note_help"] = "#pgv_lang[multiple_help]#<br />~添加新的注意事項~<br /><br />如果您有一個註釋要添加到此記錄中，這是可以這樣做的地方。<br /><br />只需點擊鏈接，就會打開一個窗口，你可以輸入你的筆記。完成輸入後，只需點擊框下方的按鈕，關閉窗口即可。<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_shared_note_help"] = "#pgv_lang[multiple_help]#<br />~#pgv_lang[add_shared_note_lbl]#~<br /><br />當您點擊<b>#pgv_lang[add_shared_note]#</b>鏈接時，會出現一個新窗口您可以選擇鏈接到現有的共享筆記，也可以創建新的共享筆記，同時創建一個鏈接。<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_source_help"] = "#pgv_lang[multiple_help]#<br />~添加新來源引用~<br /><br />您可以在此處添加源<b>引用</b>到此記錄。<br /><br />只需單擊該鏈接，將打開一個窗口，您可以從列表中選擇源（​​查找ID）或創建新源，然後添加引文。<br /><br />添加源是其中的重要部分家譜，因為它允許其他研究人員驗證您獲取信息的位置。<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"] = "~#pgv_lang[add_media]#~<br /><br />將多媒體文件（MM）添加到GEDCOM是一個非常好的功能。雖然這個程序已經很好看，沒有媒體，如果你添加圖片或其他MM對你的親戚來說，它只會變得更好。<br /><br /><b>你應該對MM有什麼了解。</b><br />MM的格式很多。雖然網站可以處理大部分MM有一些事情要考慮。<br /><ul><li><b>格式</b><br />圖片可以編輯和保存為多種格式。例如，.jpg，.png，.bmp如果使用相同的原始圖片來創建每種格式，無論使用哪種格式，查看的圖像都會顯示相同的大小。但是，存儲在數據庫中的圖像文件會有很大差異。一般來說，.jpg圖像被認為在存儲空間方面效率最高。</li><li><b>圖像尺寸</b><br />原始圖像越大，圖像越大結果文件的大小。圖片應該適合屏幕不滾動;最大寬度或高度不應超過屏幕的寬度或高度。 PhpGedView設計用於1024x768像素的屏幕，但並非所有這些空間都可用於查看圖片;應相應地設置圖片的大小。為了減小文件大小，需要更小的圖片。</li><li><b>分辨率</b><br />圖片的分辨率通常以\"dpi\"（點/英寸）來衡量，但這僅適用於打印的圖片。在考慮屏幕上顯示的圖片時，唯一正確的方法是使用總點數或像素。打印時，根據打印機的不同，圖片的分辨率可能達到150 - 300 dpi或更高。屏幕分辨率很少超過每英寸50像素。如果永遠不會打印圖片，則可以安全地降低其分辨率（以及文件大小），而不會影響圖像質量。如果低分辨率圖像打印放大倍數太大，其質量將受損;它將具有顆粒狀外觀。</li><li><b>顏色深度</b><br />保持文件較小的另一種方法是減少使用的顏色數量。顏色的數量可以從純黑色和白色（兩種顏色）到真實顏色（數百萬種顏色）以及介於兩者之間的任何顏色不同。您可以看到使用的顏色越多，文件的大小就越大。</li></ul><b>為什麼保持文件大小很小很重要？</b><br /><ul><li>首先：我們的網站空間有限。文件越大，我們在服務器上需要的空間就越多。我們需要的空間越多，成本就越高。</li><li>帶寬。我們的服務器發送到遠程位置（您的位置）的數據越多，我們就越需要付費。這是因為服務器與Internet連接的承載能力有限，並且必須由服務器上運行的所有應用程序共享（並支付）鏈接。網站是共享服務器的眾多應用程序之一。成本通常根據每個應用程序發送和接收的數據量進行分配。</li><li>下載時間。如果您有大文件，則用戶（也是您）必須等待很長時間才能從服務器下載頁面。並非所有人都有幸使用有線連接，寬帶或DSL。</li></ul><b>如何上傳您的MM</b><br />有兩種方法可以將媒體上傳到網站。如果您要上傳大量媒體條目，請與網站管理員聯繫，討論最佳方式。如果您的網站管理員已啟用此功能，則可以使用#pgv_lang[mgv]#菜單下的上傳媒體表單。您還可以使用\"多媒體\"表單上的\"上傳\"選項上傳媒體條目。";
$pgv_lang["gen_missing_thumbs_help"] = "~#pgv_lang[gen_missing_thumbs]#~<br /><br />此選項將為當前目錄中尚未包含縮略圖的所有文件生成縮略圖。這比單擊<b>#更方便每個此類文件的pgv_lang[gen_thumb]#</b>鏈接。<br /><br />如果您希望保留對哪些文件應具有相應縮略圖的控制權，則不應使用此選項。而是單擊相應的<b>#pgv_lang[gen_thumb]#</b>鏈接。";
$pgv_lang["add_facts_general_help"] = "~關於添加的一般信息~<br /><br />當您將事實，註釋，來源或多媒體文件添加到數據庫中的記錄時，添加仍然必須由具有接受權限的用戶批淮。<br /><br />在更改被接受之前，它們被不同顏色的邊框標識為\"待定\"。具有編輯權限的所有用戶都可以看到這些更改以及原始信息。沒有編輯權限只會看到原始信息。當添加已被接受時，邊框將消失，新數據將正常顯示，取代舊數據。此時，沒有編輯權限的用戶也將看到新數據。";

//-- Edit user
$pgv_lang["edituser_my_account_help"] = "您可以在這裡更改您的設置和偏好。<br /><br />您可以更改您的用戶名，全名，密碼，語言，電子郵件地址，網站主題和首選聯繫方式。<br /><br />您無法更改GEDCOM INDI記錄ID;這必須由管理員完成。";
$pgv_lang["edituser_username_help"] = "~#pgv_lang[username]#~<br /><br />在此框中，您可以更改您的用戶名。如果您不再喜歡您的用戶名或有其他理由進行更改，您可以使用此名稱表單。<br /><br />用戶名<u>區分大小寫</u>。這意味著<b>John</b>與<b>john</b>或<b>JOHN</b>不同。<br /><br />你應該只</u>使用網站支持的字母表中的字符。你可以使用大寫和小寫字母，有或沒有變音符號，數字，短劃線（-）和下劃線（_）。<u>不</u>使用標點符號或空格。";
$pgv_lang["edituser_firstname_help"] = "~#pgv_lang[firstname]#~<br /><br />在此框中，您可以更改您的名字。這是其他用戶在您登錄時看到的名稱。<br /><br />雖然您可以選擇在此字段中輸入的內容，您應該在更改時通知管理員。當其他人在網上看到一個不知名的人時，他們可能會想知道並提出問題。管理員可以在未收到您通知的情況下找到，但是你應該為他節省那些不必要的工作。";
$pgv_lang["edituser_lastname_help"] = "~#pgv_lang[lastname]#~<br /><br />在此框中，您可以更改姓氏。這是其他用戶在您登錄時看到的名稱。<br /><br />雖然您可以選擇在此字段中輸入的內容，您應該在更改時通知管理員。當其他人在網上看到一個不知名的人時，他們可能會想知道並提出問題。管理員可以在未收到您通知的情況下找到，但是你應該為他節省那些不必要的工作。";
$pgv_lang["edituser_gedcomid_help"] = "~#pgv_lang[gedcomid]#~<br /><br />這是一個識別號碼，它將您鏈接到數據庫中您自己的數據。<br /><br />您無法更改此ID;它由以下設置：管理員。如果您認為此ID不正確，您應該聯繫管理員以更改它。";
$pgv_lang["edituser_rootid_help"] = "~#pgv_lang[rootid]#~<br /><br />這是你所有圖表的起始（根）人。<br /><br />例如，如果你點擊鏈接到在譜系中，你會在最左邊的方框中看到這個根人。這個根人不一定是你;你可以從任何人（例如你的祖父或你母親的阿姨）開始，只要你有權看到那個人。<br /><br />這個選項改變了大多數圖表的默認Root用戶。你可以改變許多圖表上實際使用的Root用戶，但那隻是在那個特定時間用於那個頁面。";
$pgv_lang["edituser_password_help"] = "~#pgv_lang[password]#~<br /><br />定期更改密碼是一種很好的做法。您必須記住，知道您的用戶名和密碼的任何人都可以訪問您的數據。密碼長度至少為6個字符，越長越好。您可以使用帶或不帶變音符號，數字，短劃線（-）和下劃線（_）的大寫和小寫字母。 <u>不</u>使用標點符號或空格。使用大寫和小寫，數字和其他字符的組合。例如：<b>5Z_q\$P4=r9</b>。<br /><br />與用戶名一樣，密碼<u>區分大小寫</u>。这意味着<b>Secret.Password!#13</b>與不同<b>secret.password!#13</b>或<b>SECRET.PASSWORD!#13</b>是不同的。";
$pgv_lang["edituser_conf_password_help"] = "~#pgv_lang[確認]#~<br /><br />如果您更改了密碼，還需要確認密碼。這只是為了確保您沒有在密碼字段中輸入錯誤。<br /><br />如果密碼及其確認信息不相同，您將收到相應的錯誤消息。您必須重新輸入原始密碼及其確認信息。";
$pgv_lang["edituser_change_lang_help"] = "~#pgv_lang[change_lang]#~<br /><br />您可以在此處更改網站在您登錄後顯示其所有頁面和消息的語言。<br /><br />當您第一次訪問該網站，網站假設您希望在瀏覽器中查看所有語言中配置為首選語言。如果該假設不正確，您可以在此處覆蓋它。例如，您的瀏覽器可能設置為英語，因為這是互聯網上最流行的語言。但是，出於家譜目的，您更願意看到芬蘭語或希伯來語中的所有內容。您可以在此處執行此操作。<br /><br />管理員控制您可以使用的語言選擇。您的偏好未列出，您需要聯繫管理員。<br /><br />請記住，網站是一個由無償志願者的國際團隊組成的條目。專家來去。因此，支持語言除了英語之外，有時不如它應該是。<br /><br />如果您看到某些內容未被翻譯，翻譯錯誤或者措辭更好，請告知您的管理員。管理員將知道如何網站開發團隊取得聯繫以解決您的問題。更好的是，志願做一些你的時間。我們可以使用幫助。";
$pgv_lang["edituser_email_help"] = "~#pgv_lang[emailadress]#~<br /><br />Your correct email address is important to us to keep in touch with you.<br /><br />If you get a new email address, as usually happens when you change your Internet provider, please do not forget to change the address here as well. You won't get a confirmation message from this site when you change this address, but any future messages directed to you will go this new address.";
$pgv_lang["edituser_user_theme_help"] = "~#pgv_lang[user_theme]#~<br /><br />這個網站可以有幾種不同的外觀或外觀。其他程序可能稱它們為\"皮膚\"，但這裡它們是\"主題\"。<每個主題都會顯示相同的數據，但它的顯示甚至在屏幕上的位置可能會有所不同。這就像將圖片放入不同的框架並將其掛在不同的房間中一樣。不會改變，但你看它的方式是完全不同的。<br /><br />試試吧。把它設置成另一個主題。看看它，嘗試另一個。改回適合你的那個無論何時登錄，您都會看到上次使用的主題;您甚至無需進入此配置頁面來更改您的首選主題。";
$pgv_lang["edituser_contact_meth_help"] = "~#pgv_lang[user_contact_method]#~<br /><br />網站有幾種不同的聯繫方式。 管理員確定將使用哪種方法與他聯繫。 您可以控制用於聯繫<u>你</u>的方法。 根據站點配置，您可能無法使用某些列出的方法。";
$pgv_lang["mail_option1_help"] = "使用此選項，將使用網站內部消息系統，不會發送任何電子郵件。<br /><br />您將只收到來自其他用戶的<u>內部</u>消息。當另一個站點用戶向您發送消息，該消息將顯示在您的個人#pgv_lang[mygedview]#页面的消息塊中。如果您已從#pgv_lang[mygedview]#頁面中刪除此塊，您將看不到任何消息。他們會，但是，只要您將#pgv_lang[mygedview]#页面配置為再次擁有Message塊，就會顯示出來。";
$pgv_lang["mail_option2_help"] = "此選項類似於#pgv_lang[messaging]#，只需添加一個。另外，該郵件的副本也將發送到您在帳戶頁面上配置的電子郵件地址。<br /><br />這是默認聯繫方式。";
$pgv_lang["mail_option3_help"] = "使用此選項，您只會收到您在帳戶頁面上配置的地址的電子郵件。根本不會使用網站內部的消息傳遞系統，並且您的個人消息塊中永遠不會有任何消息#pgv_lang[mygedview]#页面。";
$pgv_lang["mail_option4_help"] = "使用此選項，您將不會收到任何消息。即使是管理員也無法聯繫到您。";

//-- Admin
$pgv_lang["admin_help"] = "在此頁面上，您可以找到配置頁面，管理頁面，文檔和日誌文件的鏈接。<br /><br /><b>#pgv_lang[system_time]#</b>，就在頁面標題下方，顯示託管您網站的服務器的時間。這意味著如果您在法國時服務器位於紐約，則顯示的時間將比當地時間少6個小時，當然，除非服務器在格林威治標淮時間（GMT）上運行。顯示的時間是您打開或刷新此頁面時的服務器時間。<br /><br /><b>警告</b><br />當您看到系統時間下的紅色警告消息，表示您的<i>config.php</i>仍然可寫。配置完網站後，您應該為<b>安全</b>設置此文件的權限回到只讀。你必須手動<u>手動</u>，因為網站不能為你做這個。";

//-- User Admin
$pgv_lang["useradmin_help"] = "~#pgv_lang[user_admin]#~<br /><br />在此頁面上，您可以管理當前用戶並添加新用戶。<br /><br /><b>#pgv_lang[current_users]#</b><br />在此表中顯示當前用戶，他們的狀態和權利。您可以<b>刪除</b>或<b>編輯</b>用戶。<br /><br /><b>#pgv_lang[add_user]#</b><br />此表單幾乎與用戶在<b>#pgv_lang[editowndata]#</b>頁面上看到的相同。<br /><br />對於多個主題，我們沒有為管理員提供特殊的幫助文本。在這些情況下，您將看到以下消息：";
$pgv_lang["useradmin_gedcomid_help"] = "~#pgv_lang[gedcomid]#~<br /><br />#pgv_lang[gedcomid]#與家譜中人員進行關聯。必須由管理員設置。<br /><br />此ID用作多個頁面上的ID，例如<b>#pgv_lang[my_indi]#</b>和<b>#pgv_lang[my_pedigree]#</b>。<br /><br />您可以設置用戶的GEDCOM ID對於每個GEDCOM，如果用戶沒有GEDCOM中的記錄，則將該框留空。";
$pgv_lang["useradmin_rootid_help"] = "~#pgv_lang[rootid]#~<br /><br />对于每个宗谱数据库，您可以为用户指定根人员。<br /><br />此根人員不需要是用戶本身;它可以是任何人。用戶可能想要自己啟動譜系圖表。你可以在这里控制它，以及其他图表上的默认原始人。<br /><br如果用戶擁有自己帳戶信息的編輯權限，他可以自行更改此設置。";
$pgv_lang["useradmin_can_admin_help"] = "~#pgv_lang[can_admin]#复选框~<br /><br />如果選中此框，則用戶將擁有與您相同的權限。<dl><dt>這些權利包括：</dt><dd>添加/刪除/編輯用戶</dd><dd>向所有用戶廣播消息</dd><dd>編輯歡迎消息</dd><dd>編輯和配置語言文件</dd><dt></dt><dd>升級網站</dd><dd>更改計劃和GEDCOM配置</dd><dd>管理GEDCOM</dd><dd>更改隱私設置</dd><dd>等等否則這裡沒有提到。</dd></dl><br />用戶<u>不能</u>在網站之外更改服務器上的任何內容。";
$pgv_lang["useradmin_sync_gedcom_help"] = "~#pgv_lang[sync_gedcom]#复选框~<br /><br />如果選中此框並且用戶分配了GEDCOM記錄ID，則他們的用戶帳戶設置將自動與其GEDCOM數據同步。意味著當用戶的GEDCOM記錄被編輯時，一些信息，如電子郵件地址和名稱將被複製到用戶的帳戶。當用戶的帳戶被編輯時，相應的信息將被複製到GEDCOM記錄。";
$pgv_lang["useradmin_can_edit_help"] = "~#pgv_lang[can_edit]#~<br /><br />用戶可以對系統中的每個系譜數據庫擁有不同的訪問和編輯權限。<ul><li><b>#pgv_lang[none]#：</b>用戶無法訪問此GEDCOM中的私人數據。</li><li><b>#pgv_lang[access]#：</b>用戶無法編輯或接受數據到數據庫中，但可以看到私人數據。</li> <li><b>#pgv_lang[edit]#：</b>用戶可以編輯值，但具有<b>#pgv_lang[accept]#</b>權限的其他用戶必須批淮在將它們添加到數據庫並公開之前進行更改。</li><li><b>#pgv_lang[accept]#：</b>用戶可以編輯。他還可以編輯和批淮其他用戶所做的更改。</li><li><b>#pgv_lang[admin_gedcom]#：</b>用戶編輯並批淮其他用戶所做的更改。用戶還可以編輯<u>此</u>的配置和隱私設置GEDCOM。</li></ul>系統管理員通過<b>#pgv_lang[can_admin]#</b>複選框確定，會自動獲得<b>#pgv_lang[admin_gedcom]#</b>權限。";
$pgv_lang["useradmin_verified_help"] = "~#pgv_lang[verified]#~<br /><br /><b>自己註冊</b><br />用戶可以通過<b>自己註冊</b申請新帳戶>模塊。<br /><br />當他這樣做時，他會收到一封電子郵件，其中包含驗證其申請的鏈接。申請人按照該電子郵件中的說明操作後，您會看到此復選框，您可以繼續下一步，<b>#pgv_lang[verified_by_admin]#</b>。只要未選中此框，您就應該等待批淮。<br /><br /><b>添加用戶手動</b><br />如果您使用此表單手動添加用戶，您會發現此框已經被選中。";
$pgv_lang["useradmin_verbyadmin_help"] = "~#pgv_lang[verified_by_admin]#~<br /><br />如果用戶使用了自助註冊模塊並且已經驗證了自己，那麼在他的帳戶激活之前的最後一步是您的批淮。<br /><br />在您批淮用戶的新帳戶申請後，該用戶將收到一封電子郵件消息。該消息將告訴用戶他的帳戶現在處於活動狀態。他可以使用他提供的用戶名和密碼登錄他申請了這個帳戶。";
$pgv_lang["useradmin_edit_user_help"] = "~#pgv_lang[update_user]#~<br /><br />管理員使用此表單來更改用戶的帳戶<br /><br />表單非常類似於<b>#pgv_lang[add_user]#</b>和<b>#pgv_lang[update_myaccount]#</b>表單。";
$pgv_lang["useradmin_visibleonline_help"] = "~可見在線~<br /><br />此復選框可控制您在線時對其他用戶的可見性。它還可以控制您查看配置為可見的其他在線用戶的能力。<br /><br />如果未選中此框，您將完全看不到其他人，並且您也無法看到其他在線用戶。選中此框後，情況恰恰相反。其他人也可以看到您，而您也將能夠看到其他配置為可見的人。";
$pgv_lang["useradmin_editaccount_help"] = "~編輯帳戶信息~<br /><br />如果選中此框，該用戶將能夠編輯他的帳戶信息。雖然通常不建議這樣做，但您可以為多個用戶創建單個用戶名和密碼。如果對具有共享帳戶的所有用戶取消選中此框，則會阻止他們編輯帳戶信息，只有管理員才能更改該帳戶。";
$pgv_lang["useradmin_relation_priv_help"] = "~#pgv_lang[user_relationship_priv]#~<br /><br />如果選中此框，則只允許用戶訪問與他們相關的活人。他們將能夠看到任何人。關係路徑長度由<i>#pgv_lang[user_path_length]#</i>設置。您可以通過啟用GEDCOM隱私設置中的全局選項來要求所有用戶建立關係隱私。<br /><br />此設置要求用戶在能夠看到任何生活人員之前與GEDCOM ID相關聯。";
$pgv_lang["useradmin_path_length_help"] = "~#pgv_lang[user_path_length]#~<br /><br />如果啟用了<i>#pgv_lang[user_relationship_priv]#</i>，該用戶將只能看到或編輯此數量的生活個體關係步驟。";
$pgv_lang["useradmin_auto_accept_help"] = "~#pgv_lang[user_auto_accept]#~<br /><br />通過選中此框，您可以讓系統自動接受該用戶所做的任何編輯更改。用戶還必須擁有GEDCOM的接受權限才能此設置生效。";

//-- Manage Sites
$pgv_lang["help_managesites"] = "~#pgv_lang[link_manage_servers]#~<br /><br />在此頁面上，您可以添加遠程站點並拒絕來自特定IP地址的訪問。<br /><br />可以通過提供站點添加遠程站點遠程Web服務的標題，URL，數據庫ID（可選），用戶名和密碼。<br /><br />永久或定時IP訪問拒絕是通過提供確切的IP地址或任何有效的IP地址範圍來完成的。例如，212.10.*.*列表中IP地址範圍內的遠程站點將無法訪問您的站點。";
//-- Adding Remote Links
$pgv_lang["help_remotesites"] = "~#pgv_lang[label_new_server]#~<br /><br />要添加遠程站點，請提供站點標題，遠程Web服務的URL，數據庫ID（可選）以及用戶名和密碼。單擊添加（ +）按鈕完成該過程。如果遠程服務器允許匿名認證，則應將用戶名和密碼留空。";
//-- IP Address Banning
$pgv_lang["help_IPv4IPv6"] ="IPv4地址由4個段組成，由\".\"分隔，並包含0到255範圍內的十進制數(不帶前導零)。例如：<b>172.252.19.56</b>，<b>212.10.*.*</b>，<b>212.10.</b>，<b>212.10</b>，<b>212.10..29</b>或<b>212.10.*.29</b>。這些示例中缺少的部分將用通配符\"*\"（星號）代替。<br /><br />IPv6地址由8個段組成，用\":\"（冒號）分隔，包含4位十六進制數。這些數字不應該有前導零，第一個零序列可以被刪除並替換為一對\"::\"（冒號）符號。如果需要使用<i>通配符</i>功能，則需要用\"*\"（星號）代替。例如：<b>23:0:cafe::2:1</b>，<b>23:0:cafe::*:1</b>或者<b>23:0:*::*:*</b>。在這些示例中，兩個冒號代表3個都是零的數字序列，例如：<b>23:0:cafe:0:0:0:*:1</b>。";
$pgv_lang["help_banning"] = "~#pgv_lang[label_banned_servers]#~<br /><br />阻止指定的IPv4或IPv6地址訪問您的站點，請輸入準確的IP地址或有效的IP地址範圍，例如IPv4：<b>172.252.13.56</b>或212.10.*.*，IPv6：<b>23:0:cafe::2:1</b>，<b>23:0:cafe::*:1</b>或<b>23:0:*::*:*</b>然後單擊添加（+）按鈕。<br /><br />#pgv_lang[help_IPv4IPv6]#";
$pgv_lang["help_timedban"] = "~#pgv_lang[label_timedban_servers]#~<br /><br />當檢測到黑客企圖時，網站將自動阻止從該IP地址訪問一小時。您可以通過在“註釋”字段中輸入要阻止的IPv4或IPv6地址以及訪問拒絕的到期日期和時間來添加自己的定時訪問拒絕。請確保使用正確的到期時間格式。如果未正確輸入到期時間信息，則拒絕訪問將不會自動到期。<br /><br />應按以下格式輸入到期：<b>yyyy.mm.dd@hh:mm</b>。例如，<b>2012.12.23@23:59</b>。注意請使用24小時制。<br /><br />#pgv_lang[help_IPv4IPv6]#";
$pgv_lang["help_manual_search_engines"] = "~#pgv_lang[label_manual_search_engines]#~<br /><br />網站自動為搜索引擎提供具有較少鏈接的數據文件。這些數據僅限於個人和直系親屬，沒有添加有關祖父母或孫子女的信息。許多報表和服務器密集型頁面（如日曆）都禁止搜索引擎訪問。<br /><br />許多流行的搜索引擎如Google和Bing會被自動檢測到。如果希望未被自動識別的搜索引擎收錄您的網站數據，則可以在此處輸入它的IPv4或IPv6地址，提供淮確的IP地址或有效的IP地址範圍，例如IPv4：212.10.*.*（IP段）或172.252.13.56（單IP），IPv6：23:0:cafe::*:1或23:0:cafe::2:1，然後單擊添加（+）按鈕。<br />如果要完全排除此搜索引擎，請將其IP輸入到<i>#pgv_lang[label_banned_servers]#</i>區域。如果你想查看哪些數據可以被搜索引擎收錄的，請在這裡輸入你自己的IP地址。<span class='warning'>警告：</span>這將你鎖定在管理界面之外，你必須通過從其他機器登錄或手動編輯<i>#GLOBALS[TBLPREFIX]#ip_address</i>數據庫表。<br /><br />#pgv_lang[help_IPv4IPv6]#";

//-- Search_engines.php
$pgv_lang["search_engine_landing_page"] = "~檢測到搜索引擎~<br /><br /><br /><br />網站會自動為搜索引擎提供較少的數據文件和較少的鏈接。數據僅限於個人和直系親屬，無需添加有關父母或大孩子的信息。像日曆這樣的服務器密集型頁面對蜘蛛是不受限制的。<br /><br />蜘蛛嘗試訪問這些頁面會導致顯示此頁面。如果您看到此文本，則軟件認為您是搜索引擎蜘蛛。下面是允許蜘蛛網的列表，並提供縮寫數據。<br /><br />關注搜索引擎鏈接到此站點的真實用戶將看到完整的頁面和數據，而不是這個頁面。";

//-- G E D C O M
$pgv_lang["add_upload_gedcom_help"] = "~添加上傳GEDCOM~<dl><dt><b>上傳GEDCOM文件</b></dt><dd>上傳文件可以在線完成。您可以從任何地方上傳而無需ftp程序。</dd><dt><b>添加GEDCOM文件</b></dt><dd>如果以前上傳的文件仍然存在於您的GEDCOM目錄中，您可以再次使用它而無需上傳。有時，由於文件或上傳大小限制，您需要使用添加。</dd></dl>添加和上傳過程可以通過四個簡單步驟完成。在任一過程中，只有步驟1不同。";
$pgv_lang["gedcom_configfile_help"] = "~GEDCOM CONFIGURATION FILE~<br /><br />這是存儲與家譜數據庫相關的所有基本設置的文件。每個這樣的數據庫都有一個單獨的文件。<br /><br />你將在<b>#pgv_lang[gedcom_adm_head]#</b>頁面的<b>#pgv_lang[current_gedcoms]#</b>表中找到每個配置文件的路徑和名稱。";
$pgv_lang["default_gedcom_help"] = "~默認GEDCOM~<br /><br />如果你有一個以上的家譜數據庫，你可以在這裡設置哪一個是默認的。<br /><br />這個默認值會顯示給所有訪客和尚未登錄的用戶。<br /><br />可以編輯其帳戶設置的用戶可以覆蓋此默認設置。在這種情況下，登錄後將顯示用戶首選的數據庫。";
$pgv_lang["delete_gedcom_help"] = "~刪除GEDCOM~<br /><br />網站從之前上傳的GEDCOM文件創建數據庫。當您選擇<b>刪除</b>時，數據庫的該部分將被刪除。您必須確認您的刪除請求。<br /><br />除非您故意在網站外刪除它，否則原始的GEDCOM文件將保留在上傳的目錄中。如果您以後想再次使用該GEDCOM文件，不必再次上傳。您可以選擇<b>#pgv_lang[add_gedcom]#</b>功能。";
$pgv_lang["add_gedcom_help"] = "~#pgv_lang[add_gedcom]#~<br /><br />當您使用<b>#pgv_lang[add_gedcom]#</b>功能時，假設您已將GEDCOM文件上傳到您的服務器使用程序或方法<u>外部</u>到網站，例如，<i>ftp</i>或<i>網絡連接</i>。您要添加的文件也可能已被遺留來自之前的<b>#pgv_lang[upload_gedcom]#</b>程序。<br /><br />如果輸入的GEDCOM文件尚未在您的服務器上，您<u>必須</u>獲取它首先，在開始添加之前。<br /><br />您也可以使用網站或使用外部程序上傳包含GEDCOM文件的ZIP文件，而不是上傳GEDCOM文件.網站將識別ZIP文件自動生成，並從ZIP文件中提取GEDCOM文件和文件名。<br /><br />如果網站中已經存在同名的GEDCOM文件，它將被覆蓋。但是，之前所有的GEDCOM設置都是將被保留。<br /><br />您将被引导逐步完成该过程。";
$pgv_lang["add_new_gedcom_help"] = "~#pgv_lang[add_new_gedcom]#~<br /><br />你可以從頭開始一個新的系譜數據庫。<br /><br />這個程序只需要幾個簡單的步驟。第一步不同於什麼你已經知道上傳和添加。其他步驟將很熟悉。<ol><li><b>命名新的GEDCOM</b><br />鍵入新GEDCOM的名稱<u>沒有</u>擴展名<b>.ged</b>。新文件將在您輸入名稱的框上方的目錄中創建。單擊<b>添加</b>。</li><li><b>配置頁</b><br />您已經知道此頁面;您需要配置新GEDCOM文件的設置。</li><li><b>驗證</b><br />您已經知道這個頁面;新的GEDCOM已經過檢查。因為它沒有任何內容，所以沒問題。</li><li><b>導入記錄</b><br />因為只有一條記錄需要導入，這將很快完成。</li></ol>就是這樣。現在你可以進入譜系圖表，在新的GEDCOM中看到你的第一個人。點擊這個人的名字和sta rt編輯。之後，您可以將新個人與第一個人聯繫起來。";
$pgv_lang["download_gedcom_help"] = "~#pgv_lang[download_gedcom]#~<br /><br />您可以從此頁面下載GEDCOM格式的系譜數據庫。您可能想將數據導入另一個系譜程序，或者您可能想要分享其信息與他人一起。<br /><br />#pgv_lang[utf8_ansi_help]#<br /><br />#pgv_lang[remove_tags_help]#<br /><br />#pgv_lang[download_zipped_help]#";
$pgv_lang["edit_gedcoms_help"] = "~#pgv_lang[gedcom_adm_head]#~<br /><br />#pgv_lang[gedcom_adm_head]#页面是管理所有家譜數據庫的控制中心。<br /><br /><b>#pgv_lang[current_gedcoms]#</b><br />在<b>#pgv_lang[current_gedcoms]#</b>表的開頭，您會看到一個包含四個鏈接的操作欄。<ul> <li>#pgv_lang[add_gedcom]#</li><li>#pgv_lang[upload_gedcom]#</li><li>#pgv_lang[add_new_gedcom]#</li><li>#pgv_lang[lang_back_admin]#</li></ul>在<b>#pgv_lang[current_gedcoms]#</b>表中，每個系譜數據庫都單獨列出，並且每個系列都有以下選項：<ul><li>導入</li><li>刪除</li><li>下載</li><li>編輯配置</li><li>編輯隱私</li><li>SearchLog文件</li></ul>此處顯示編輯隱私，因為每個GEDCOM都有它自己的隱私文件。<br /><br />此表中的每一行都應該是不言自明的.網站可以配置為記錄所有數據庫搜索。可以通過此頁面上的鏈接檢查SearchLog文件。<br />#pgv_lang[more_help]#";
$pgv_lang["edit_config_gedcom_help"] = "~配置GEDCOM~<br /><br />每個與網站一起使用的家譜數據庫都有自己的<b>配置文件</b>。<br /><br />在這個表單中你可以配置很多選項，比如數據庫標題，語言，日曆格式，電子郵件選項，數據庫搜索記錄，HTML META標題，從數據庫的頻繁姓氏列表中刪除姓氏等";
$pgv_lang["import_gedcom_help"] = "~進口GEDCOM~<br /><br />在大多數情況下，導入外部創建的GEDCOM文件是程序中的一步，導致對系譜數據庫進行批量更改。<br /><br />這些步驟在一個邏輯順序，需要按照規定的順序完成，以便系譜數據庫可用。<br /><br />如果由於某種原因，你沒有按照正確的順序完成這些步驟，你會看到一個<u>警告</u>消息說明尚未導入GEDCOM。要解決問題，請單擊<b>導入GEDCOM</b>鏈接導入文件。<br /><br />現有GEDCOM配置設置重新導入GEDCOM時不會改變。但是，現有數據將被覆蓋。";
$pgv_lang["upload_gedcom_help"] = "~#pgv_lang[upload_gedcom]#~<br /><br />與<b>#pgv_lang[add_gedcom]#</b>功能不同，您希望添加到數據庫的GEDCOM文件不必打開您的服務器。<br /><br />在第1步中，您從本地計算機中選擇一個GEDCOM文件。在文本框中鍵入完整的路徑和文件名，或使用頁面上的<b>瀏覽</b>按鈕。<br /><br />您還可以使用此功能上傳包含GEDCOM文件的ZIP文件.網站將識別ZIP文件並自動提取文件和文件名。<br /><br />如果是在網站中已經存在具有相同名稱的GEDCOM文件，在您確認之後，它將被覆蓋。但是，之前製作的所有GEDCOM設置都將被保留。<br /><br />您將在其他頁面上找到更多幫助。程序。";
$pgv_lang["validate_gedcom_help"] = "~確認GEDCOM~<br /><br />這是將外部創建的GEDCOM數據添加到您的家譜數據庫的過程中的第三步。<br /><br /> 網站將檢查輸入文件是否正確使用日期格式，地點格式，字符集等等。與網站所遵循的GEDCOM 5.5.1標淮的某些偏差可以自動更正。例如Macintosh行結尾和Place格式的錯誤使用。當發生這種情況時，你將看到數據已被更改的消息。對於其他異常情況，您將收到一條推薦解決方案的警告消息。<br /><br /><b>可選工具</b><br />此時有隻有一個額外的工具：<br /><b>將個人ID更改為......</b>。<br />#pgv_lang[more_config_help]#";
$pgv_lang["convert_ansi2utf_help"] = "~將ANSI轉換為UTF-8~<br />為了確保輸入GEDCOM文件中的信息得到正確處理和顯示，這些文件應以UTF-8編碼。<br /><br />一些更現代的族譜程序可以將數據導出為UTF-8編碼的GEDCOM文件。較舊的程序通常沒有這種功能。如果你的程序沒有提供這個選項，網站可以為你轉換文件。<br /><br />當網站驗證輸入文件時，它將檢測文件的編碼並相應地通知您。";
$pgv_lang["detected_ansi2utf_help"] = "~检测到ANSI编码~<br /><br />現在驗證的GEDCOM文件是用ANSI字符集編碼的。強烈建議您將文件的編碼轉換為UTF-8。<br /><br /><br />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"] = "~錯誤日期格式被檢測到~<br /><br /><b>日期格式將被更改</b><br /><br />PhpGedView标准日期格式，也符合GEDCOM 5.5.1标准<b>DD&nbsp;MMM&nbsp;YYYY</b>（例如01&nbsp;JAN&nbsp;2004）<br /><br />如果在您的GEDCOM文件經過驗證後，您會看到錯誤日期的消息格式已被檢測到，網站將轉換標淮規定的格式錯誤的日期。<br /><br />但是，您可以選擇在月份之前選擇\"<b>日</b>\" （DD&nbsp;MMM&nbsp;YYYY），或\"<b>月</b>日前\"（MMM&nbsp;DD&nbsp;YYYY）。<br /><br />我們建議您使用第一種格式（前一天）月）。";
$pgv_lang["change_indi2id_help"] = "~将人员ID更改为....~<br /><br />該工具專為那些每次GEDCOM導出時Genealogy程序為個人使用不同GEDCOM ID的用戶而設計。例如，GEDCOM第一次出口時某人的身份證可能是I100，但下次GEDCOM出口時，同一人的身份證改為I234。 這些不斷變化的ID使得管理網站變得很困難，因為ID是人們被引用的方式。<br /><br />大多數家譜程序也使用RIN或REFN標籤為每個人提供一個唯一的標識符，可用於引用個人。 此工具將使用您指定的任何字段（RIN或REFN）替換GEDCOM文件中的所有單個ID。";
$pgv_lang["edit_privacy_help"] = "在此頁面上，您可以為選定的GEDCOM進行所有隱私設置。<br /><br />您可以在頁面標題下查看是否正在編輯正確的隱私文件。它顯示如下:(路徑/nameofyourgedcom_priv.php）<br /><br />如果您需要更多設置，可以手動更改隱私文件。您可以在網站上閱讀更多相關信息。";
$pgv_lang["BOM_detected_help"] = "~檢測到字節順序標記（BOM）~<br /><br />您導入的GEDCOM文件在開頭有一個特殊的3字節代碼。某些程序使用此特殊代碼表示該文件已被刪除以UTF-8字符集錄製。<br /><br />雖然這個特殊代碼實際上並不是一個錯誤，但當輸入文件包含代碼時，網站將無法正常工作。您應該讓網站刪除代碼。";
$pgv_lang["invalid_header_help"] = "~無效的GEDCOM標題~<br /><br />GEDCOM文件必須以<b>0&nbsp;HEAD</b>開頭.網站檢測到您導入的GEDCOM文件沒有<b> 0&nbsp;HEAD</b>作為第一行。當您單擊清除按鈕時，第一個<b>0&nbsp;HEAD</b>行之前的任何行都將被刪除。<br /><br />此錯誤通常意味著該程序您曾經創建的GEDCOM沒有正確創建它或它不是GEDCOM文件。您應該檢查以確保您上傳了正確的文件，並且它以<b>0&nbsp;HEAD</b>行開頭以<b>0&nbsp;TRLR</b>行結束。";
$pgv_lang["macfile_detected_help"] = "~檢測到MACINTOSH文件~<br /><br />網站檢測到您的GEDCOM文件是在Macintosh計算機上創建的。<br /><br />Macintosh文件以CR控制代碼結束每一行。CR是Ctrl+M。<br />Unix文件用LF控制代碼結束每一行。LF是Ctrl+J。<br />Windows和DOS使用雙碼序列，CR後跟LF。<br /><br />網站要求所有文件都使用Unix或DOS行結尾。當你點擊清理按鈕時，你的行結尾將被相應地轉換。";
$pgv_lang["cleanup_places_help"] = "~清理地點~<br /><br />網站檢測到您的GEDCOM文件使用了不應該有地方的GEDCOM標籤上的地方。<br /><br />許多家譜程序，如Family Tree Maker，將創建這種類型的GEDCOM文件.網站將使用這些GEDCOM文件，但是一些無效的地方會顯示在你的地方層次結構中。<br /><br />例如，你的GEDCOM可能有以下編碼<br />1 SSN<br />2 PLAC 123-45-6789<br />1 OCCU<br />2 PLAC計算機程序員<br /><br />根據GEDCOM 5.5.1標淮，這應該顯示為<br />1 SSN 123-45-6789<br />1 OCCU計算機程序員<br /><br />如果選擇<b>是</b>，網站將自動糾正這些編碼錯誤。";
$pgv_lang["empty_lines_detected_help"] = "~检测到空行~<br /><br />網站檢測到輸入文件中有空行。這些行可能會導致錯誤，並在導入之前從文件中刪除。";

//-- Edit Config
$pgv_lang["help_editconfig.php"] = "~配置網站~<br /><br />在此頁面上，您可以配置網站的全局設置。您必須在安裝網站並首次運行它之後執行此操作。<br /><br />#pgv_lang[review_readme]#由於這些設置是<b>全局</b>，它們適用於整個程序以及與網站一起使用的所有系譜數據庫。<br /><br />每個系譜數據庫還有其他您在此頁面上單擊<b>#pgv_lang[admin_gedcoms]#</b>鏈接後設置的配置選項。<br /><br />您還可以從主管理員訪問#pgv_lang[gedcom_adm_head]#功能頁面，其鏈接位於#pgv_lang[mgv]#圖標或大多數頁面的標題下。在管理員頁面上，相關鏈接稱為<b>#pgv_lang[manage_gedcoms]#。</b>";

//-- merge records
$pgv_lang["help_edit_merge.php"] = "~#pgv_lang[merge_records]#~<br /><br />此頁面允許您合併來自同一GEDCOM文件的兩個GEDCOM記錄。<br /><br />這對合併GEDCOM的人有用現在有許多相同的人，家庭和來源。<br /><br />頁麵包含三個步驟。<br /><ol><li>您輸入兩個GEDCOM ID。ID <u>必須</u>屬於同一類型。例如，您不能合併個人和家庭，家庭和來源。<br />在<b>#pgv_lang[merge_to]#</b>字段中輸入合併完成後您希望成為新記錄的記錄的ID。<br />在<b>#pgv_lang[merge_from]#</b>字段中输入其信息将合并到#pgv_lang[merge_to]#记录中的记录的ID。此記錄將在合併後刪除。</li><li>您可以選擇合併時要保留兩條記錄的事實。只需單擊您旁邊的複選框即可。想要保留。</li><li>你檢查合併的結果，就像所有其他的一樣在線更改。</li></ol>有权接受的人必须授权您的更改使其永久化。";

//-- report engine
$pgv_lang["help_reportengine.php"] = "~報告~<br /><br />報告菜單中的條目將生成PDF文件進行打印。<br /><br />第一步是選擇要運行的報告。選擇報告後要運行，系統會要求您提供特定於該報告的一些信息，例如開始使用哪個個人或家庭以及是否顯示照片。當您淮備好運行報告時，請單擊<b>#pgv_lang[download_report]#</b>按鈕將報告下載到您的計算機。<br /><br />#pgv_lang[help_xml_reports]#<br />#pgv_lang[def_pdf_format_help]#<br />#pgv_lang[help_ahnentafel.xml]#<br />#pgv_lang[help_birthlist.xml]#<br />#pgv_lang[help_relativelist.xml]#";
$pgv_lang["def_pdf_format_help"] = "~PDF文件格式~<br /><br /><br />網站報告引擎以Adobe PDF格式生成可下載的報告。本幫助文件中其他地方提到的GEDCOM5. 5.1標準規範也可以PDF格式下載。PDF是<b>P</b>ortable <b>D</b>ocument <b>F</b>ormat的首字母縮寫。";
$pgv_lang["help_ahnentafel.xml"] = "~#pgv_lang[ahnentafel_report]#~<br /><br />這是所選人和他的祖先的報告，以小冊子格式打印。它從第一個人開始，然後繼續他或她的父母，盛大- 父母等。<br /><br />請注意，ahnentafel報告目前僅提供英文版本。";
$pgv_lang["help_birthlist.xml"] = "~#pgv_lang[birth_report]#~<br /><br />通過此報告，您可以列出在特定時間或地點出生的所有人。";
$pgv_lang["help_relativelist.xml"] = "~#pgv_lang[relatives_report]#~<br /><br />此報告將列出所選個人的所有親屬。您可以選擇在報告中顯示該人的親屬。<ul><li><b>#pgv_lang[child-family]#</b>將顯示所選人員，他的父母以及他的兄弟姐妹。</li><li><b>#pgv_lang[spouse-family]#</b>將該人與他或她的配偶及其子女一同列出。</li><li><b>#pgv_lang[direct-ancestors]#</b>將列出該人，他的父母，祖父母，曾祖父母，並繼續向上列出所有在這個人的血統中的父母的人。</li><li><b>#pgv_lang[ancestors]#</b>將列出所有來自的人#pgv_lang[direct-ancestors]#列表，但也包括阿姨和叔叔以及姨媽和大叔，所以它將包括這個人的家譜中所有祖先的兄弟姐妹。它不會列出的孩子兄弟姐妹（表兄弟）。</li><li><b>#pgv_lang[後代]#</b>將列出這個人的所有內容後代（孩子，孫子，曾孫子等）。</li><li><b>#pgv_lang[all]#</b>此選是#pgv_lang[descendants]#和的組合單個報告中的#pgv_lang[祖先]#。</li></ul>";
$pgv_lang["help_xml_reports"] = "~报告引擎~<br /><br />網站報告引擎使用XML模板文件自動生成PDF報告。<br /><br /><b>#pgv_lang[select_report]#</b>列表中的報告是從報告中找到的XML文件生成的。\"reports\"目錄。您可以通過複製所提供的任何模板並修改模板XML來創建自己的報告。要添加自定義報告，只需將其放在\"reports\"目錄中，網站將自動檢測它並在<b>#pgv_lang[select_report]#</b>下拉列表中將其顯示.";

//-- Help Contents
$pgv_lang["help_contents_head_help"] = "<b>幫助內容</b>";
$pgv_lang["help_contents_gedcom_info"] = "GEDCOM信息";
$pgv_lang["help_contents_gedcom_places"] = "GEDCOM中的地方";

//-- Admin Help Contents Items
$pgv_lang["admin_help_contents_head_help"] = "<b>幫助內容<br /><br />管理員幫助條目</b>已添加到列表的開頭。";
//$pgv_lang["ah1_help"] = "_升級";
$pgv_lang["ah2_help"] = "_Configure 網站";
$pgv_lang["ah3_help"] = "_GEDCOM：添加vs上傳";
$pgv_lang["ah4_help"] = "_GEDCOM：配置文件";
$pgv_lang["ah5_help"] = "_GEDCOM：默認";
$pgv_lang["ah6_help"] = "_GEDCOM：刪除";
$pgv_lang["ah7_help"] = "_GEDCOM：加";
$pgv_lang["ah8_help"] = "_GEDCOM：創造新的";
$pgv_lang["ah9_help"] = "_GEDCOM：下載";
$pgv_lang["ah10_help"] = "_GEDCOM：管理页面";
$pgv_lang["ah11_help"] = "_GEDCOM：组态";
$pgv_lang["ah12_help"] = "_GEDCOM：進口";
$pgv_lang["ah13_help"] = "_GEDCOM：上傳";
$pgv_lang["ah14_help"] = "_GEDCOM：驗證";
$pgv_lang["ah15_help"] = "_GEDCOM：将ANSI转换为UTF-8";
$pgv_lang["ah16_help"] = "_GEDCOM：隱私設置";
$pgv_lang["ah17_help"] = "_用戶管理";
$pgv_lang["ah18_help"] = "_行政";
$pgv_lang["ah19_help"] = "_GEDCOM：媒體工具";
$pgv_lang["ah20_help"] = "_GEDCOM：將個人ID更改為......";
$pgv_lang["ah21_help"] = "_翻译工具";
// 22 is in the help_text_vars.php
$pgv_lang["ah23_help"] = "_配置支持的语言";
$pgv_lang["ah24_help"] = "_用戶信息遷移（索引 - &gt;&gt;SQL）";
$pgv_lang["ah25_help"] = "_網站備份";
$pgv_lang["ah26_help"] = "_常見問題清單：編輯";

//--Statistics Help
$pgv_lang["help_statisticsplot.php"] = "~統計圖~<br />這是結果頁面，顯示了數據庫中統計信息的圖形圖，由上一頁的輸入定義。";
$pgv_lang["help_statistics.php"] = "~統計圖~<br /><br />此頁面允許您確定從數據庫中生成各種統計數據的圖形顯示的標淮。";
$pgv_lang["stat_help"] = "~統計數據的選項~<br /><br />可以生成數據庫中的許多不同的統計圖。<br /><br />選擇圖表，然後從下拉列表中調整選項每個圖中包含的數字取決於可用的數據。例如，沒有出生月份的個體（例如，只是'1856'）不能包括在按月出生的圖表中。";
$pgv_lang["stat_help_x"] = "~統計圖的選項~<br /><br />~X軸~<br />以下選項可用於X軸（水平）。然後將根據設置的選項顯示每個選項。 Y軸和Z軸。<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_11_mb]#</b>&nbsp;&nbsp;每個月出生的人。<br /><b>#pgv_lang[stat_12_md]#</b>&nbsp;&nbsp;每月去世的人。<br /><b>#pgv_lang[stat_13_mm]#</b>&nbsp;&nbsp;每個月發生的婚姻。<br /><b>#pgv_lang[stat_14_mb1]#</b>&nbsp;&nbsp;按月分列的每個家庭的首發人數。<br /><b>#pgv_lang[stat_15_mm1]#</b>&nbsp;&nbsp;每月初婚次數。<br /><b>#pgv_lang[stat_16_mmb]#</b>婚姻与第一个孩子出生之间的月数。<br /><b>#pgv_lang[stat_17_arb]#</b>&nbsp;&nbsp;去世年齡，與包含每個人出生年份的時間段相關。<br /><b>#pgv_lang[stat_18_ard]#</b>&nbsp;&nbsp;去世年齡，與時間有關包括每個人去世年份的內容。<br /><b>#pgv_lang[stat_19_arm]#</b>结婚时个人的平均年龄。<br /><b>#pgv_lang[stat_20_arm1]#</b>&nbsp;&nbsp;第一次婚姻時的個人平均年齡。<br /><b>#pgv_lang[stat_21_nok]#</b>&nbsp;&nbsp;平均家庭人數。<br /><b>#pgv_lang[stat_1_map]#</b>&nbsp;&nbsp;按國家/地區放置具有指定名稱的所有人員或人員。<br /><b>#pgv_lang[stat_2_map]#</b>&nbsp;&nbsp;出生國家。<br /><b>#pgv_lang[stat_4_map]#</b>&nbsp;&nbsp;結婚國家。<br /><b>#pgv_lang[stat_3_map]#</b>&nbsp;&nbsp;去世國家。<br /><b>#pgv_lang[stat_9_indi]</b>&nbsp;&nbsp;來源個人的餅圖。<br /><b>#pgv_lang[stat_8_fam]#</b>&nbsp;&nbsp;帶來源家庭的餅圖。</p>";
$pgv_lang["stat_help_y"] = "~統計圖的選項~<br /><br />~Y軸~<br /><br />以下選項可用於Y軸（垂直）。這些選項改變了條目的呈現方式顯示X軸。<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_201_num]#</b>&nbsp;&nbsp;顯示由X軸定義的每個類別中的個體數量。<br /><b>#pgv_lang[stat_202_perc]#</b>&nbsp;&nbsp;計算並顯示X軸類別中每個條目的比例。</p>";
$pgv_lang["stat_help_z"] = "~OPTIONS FOR STATISTICS PLOTS~<br /><br />~Z AXIS~<br /><br />The following options are available for the Z axis. These options provide a sub-division of the categories selected for the X axis.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_300_none]#</b>&nbsp;&nbsp;displays the items as a single column for each X axis category.<br /><b>#pgv_lang[stat_301_mf]#</b>&nbsp;&nbsp;displays the items in 2 columns (male and female) for each X axis category.<br /><b>#pgv_lang[stat_302_cgp]#</b>&nbsp;&nbsp;displays the items in a number of columns related to the time periods set in the next section, for each X axis category.</p>";
$pgv_lang["stat_help_gwx"] = "~統計圖的選項~<br /><br />~X軸的邊界~<br /><br />選擇所需的年齡間隔。<br /><br />例如，<b>#pgv_lang[aft_marr]#</b>描述了以下一組月份範圍：<div style=\"padding-left: 30px;\">婚前<br />從結婚到8個月後<br />從8到12<br />從12到15<br />從15到18<br />從18到24<br />從24到48<br />結婚後48個月</div><br /><br />如果你想展示宿舍，你必須選擇：<b>宿舍</b>。";
$pgv_lang["stat_help_gax"] = "~統計圖的選項~<br /><br />~X軸的邊界~<br /><br />選擇所需的年齡間隔。<br /><br />例如，<b>區間10年</b>描述了以下一組年齡範圍：<div style=\"padding-left: 30px;\">小於一年<br />一年到5年<br />6到10<br />11到20<br />21到30<br />31到40<br />41到50<br />51到60<br />61到70<br />71到80<br />81至90<br />91至100<br />歲超過100年</div>";
$pgv_lang["stat_help_gbx"] = "~統計圖的選項~<br /><br />~X軸的邊界~<br /><br />選擇所需的年齡間隔。<br /><br />例如，<b>區間2年</b>描述了以下一組年齡範圍：<div style=\"padding-left: 30px;\">小於16歲<br />16至18<br />19至20<br />21至22<br />23至24<br />25至26<br />27至28<br />29至30<br />31至32<br />33至35<br />36至40<br />41至50歲超過50年</div>";
$pgv_lang["stat_help_gcx"] = "~統計圖的選項~<br /><br />~X軸的邊界~<br /><br />選擇所需的計數間隔。<br /><br />例如，<b>區間一個孩子</b>描述了以下一組子計數範圍：<div style=\"padding-left: 30px;\">沒有孩子<br />一個孩子<br />兩個孩子<br />3，4，5，6，7，8，9，10個孩子<br />10個以上的孩子</div>";
$pgv_lang["stat_help_gwz"] = "~統計圖的選項~<br /><br />~Z軸的範圍~<br /><br />選擇所需的起始年份和間隔<br /><br />例如，<b>從1700年間隔50年</b>描述了以下一組日期範圍：<div style=\"padding-left: 30px;\">1700之前<br />1700至1749<br />1750至1799<br />1800至1849<br />1850至1899<br />1900至1949<br />1950至1999<br />2000或以後</div>";
$pgv_lang["chart_type_help"] = "~統計圖選項~<br /><br />選擇你想在地圖上看到的內容。你可以選擇：<p style=\"padding-left: 25px\"><b>#pgv_lang[indi_distribution_chart]#</b>&nbsp;&nbsp;顯示此數據庫中的人員所在的國家/地區。<br /><b>#pgv_lang[surname_distribution_chart]#</b>&nbsp;&nbsp;顯示指定的國家/地區姓氏發生。</p>";
$pgv_lang["google_chart_surname_help"] = "~統計圖的選項~<br /><br />指定名稱的出現次數將顯示在地圖上。如果將此字段留空，將使用最常見的姓氏。";
$pgv_lang["chart_area_help"] = "~統計地圖的選項~<br /><br />選擇你想在地圖上看到的地理區域。你可以選擇：<p style=\"padding-left: 25px \"><b>#pgv_lang[world_chart]#</b>&nbsp;&nbsp;顯示所有大陸。<br /><b>#pgv_lang[europe_chart]#</b>&nbsp;&nbsp;顯示歐洲。<br /><b>#pgv_lang[s_america_chart]#</b>&nbsp;&nbsp;顯示南美洲。<br /><b>#pgv_lang[asia_chart]#</b>&nbsp;&nbsp;顯示亞洲。<br /><b>#pgv_lang[middle_east_chart]#</b>&nbsp;&nbsp;顯示中東。<br /><b>#pgv_lang[africa_chart]#</b>&nbsp;&nbsp;顯示非洲。</p><br /> ";

//-- Find Media Help
$pgv_lang["manage_media_help"] = "~#pgv_lang[manage_media]#~<br /><br />在此頁面上，您可以輕鬆管理媒體文件和目錄。<br /><br />當您創建新的媒體子目錄時，網站將確保相同的目錄結構在<b>#GLOBALS[MEDIA_DIRECTORY]#thumbs</b>目錄中維護。當您上傳新的媒體文件時，網站可以自動為您創建縮略圖。<br /><br />在每個圖像旁邊在媒體列表中，您將找到以下選項。實際顯示的選項取決於媒體文件的當前狀態。<ul><li><b>#pgv_lang[edit]#</b>&nbsp;&nbsp;單擊此選項，您將看到一個頁面，您可以在其中更改媒体对象的標題。如果媒体对象尚未鏈接到當前活動數據庫中的個人，家庭或源，則可以建立此鏈接您可以在<b>#GLOBALS[MEDIA_DIRECTORY]#</b>目錄結構中重命名文件甚至更改其位置。必要時，網站會自動cr請填寫所需的子目錄或任何缺少的縮略圖。</li><li><b>#pgv_lang[edit_raw]#</b>&nbsp;&nbsp;此選項僅在理員啟用時才可用。您可以查看或編輯與此媒体对象關聯的原始GEDCOM數據。使用此選項時應該非常小心。</li><li><b>#pgv_lang[delete_file]#</b> &nbsp;&nbsp;此選項可讓您從當前數據庫中刪除所有媒體文件的知識。其他數據庫不會受到影響。如果在任何其他數據庫中未提及此媒體文件，則將刪除該媒體文件及其關聯的縮略圖。</li><li><b>#pgv_lang[remove_object]#</b>&nbsp;&nbsp;此選項允許您從當前數據庫中刪除所有媒體文件的知識。其他數據庫不會受到影響。媒體文件及其關聯的縮略圖不會被刪除。</li><li><b>#pgv_lang[remove_links]#</b>&nbsp;&nbsp;此選項可讓您刪除媒體對象的所有鏈接當前的數據庫。該文件不會被刪除，並且將保留當前數據庫已知該文件的媒体对象。其他數據庫不會受到影響。</li><li><b>#pgv_lang[set_link]#</b>&nbsp; &nbsp;此選項可讓您在媒體文件與人員，家庭或來源間建立鏈接當前數據庫。必要時，網站還將創建媒体对象，通過該對象可以知道數據庫中的媒體文件。</li><li><b>#pgv_lang[gen_thumb]#</b>&nbsp;&nbsp;當您選擇此選項時，網站將創建缺少的縮略圖。</li></ul>";
$pgv_lang["simple_filter_help"] = "~#pgv_lang[filter]#~<br /><br />簡單的搜索過濾器根據輸入的字符，不接受任何通配符。";
$pgv_lang["show_thumb_help"] = "~#pgv_lang[show_thumbnail]#~<br /><br />如果勾選此框，將顯示縮略圖。";
$pgv_lang["new_dir_help"] = "~#pgv_lang[add_directory]#~<br /><br />作為管理員用戶，您可以創建所需的目錄結構，以保持媒體文件的有序性。從此頁面創建目錄可確保創建縮略圖目錄在每個目錄中創建一個合適的index.php。<br /><br />點擊此鏈接輸入您要創建的目錄的名稱。";
$pgv_lang["find_media_help"] = "~#pgv_lang[find_media]#~<br /><br />這使您可以搜索文件結構，找到您想要鏈接的媒體條目。";

//-- Add/Edit Media Help
$pgv_lang["add_media_linkid"] = "~鏈接ID~<br /><br />每個媒體條目應與數據庫中的一個或多個人，家庭或源記錄相關聯。<br /><br />要建立這樣的鏈接，您可以在創建媒體條目的同時輸入或搜索人員，家人或來源的ID。您也可以稍後通過管理多媒体頁面上的編輯選項建立鏈接，或通過添加媒體添加媒體條目個人，家庭或源詳細信息頁面上提供的鏈接。";
$pgv_lang["upload_server_file_help"] = "~#pgv_lang[server_file]#~<br /><br />您上傳的媒體文件在服務器上的命名方式可能與在本地計算機上的命名方式不同。這是因為通常是本地文件名對你有意義，但對訪問本網站的其他人來說意義不大。還要考慮你和其他人都試圖上傳名為\"granny.jpg\"的不同文件的可能性。<br /><br />在此字段中，您可以指定要上載的文件的新名稱。您在此處輸入的名稱也將用於命名縮略圖，可以單獨上傳或自動生成。您無需輸入文件擴展名（jpg，gif，pdf，doc等。）<br /><br />將此字段留空以保留您從本地計算機上傳的文件的原始名稱。";
$pgv_lang["upload_server_folder_help"] = "~#pgv_lang[server_folder]#~<br /><br />管理員已在默認<b>#GLOBALS[MEDIA_DIRECTORY]#</b>下啟用#GLOBALS[MEDIA_DIRECTORY_LEVELS]#文件夾級別。這有助於組織媒體文件並減少名稱衝突的可能性。<br /><br />在此字段中，指定應存儲上載媒體文件的目標文件夾。匹配的縮略圖文件，可單獨上傳或自動生成，將存儲在類似的文件夾結構中，從<b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>開始，而不是<b>#GLOBALS[MEDIA_DIRECTORY]#</b>。您無需輸入<b>#GLOBALS[MEDIA_DIRECTORY]#</b>目標文件夾名稱的一部分。<br /><br />如果您不確定要在此輸入什麼內容，請聯繫您的網站管理員以獲取建議。";
$pgv_lang["view_server_folder_help"] = "~#pgv_lang[server_folder]#~<br /><br />管理員已在默認<b>#GLOBALS[MEDIA_DIRECTORY]#</b>下啟用#GLOBALS[MEDIA_DIRECTORY_LEVELS]#文件夾級別。這有助於組織媒體文件並減少名稱衝突的可能性。<br /><br />在此字段中，您選擇要查看其內容的媒體文件夾。當您選擇<b>#pgv_lang[all]#</b>，將顯示所有媒體文件，而不考慮存儲它們的文件夾。這可以產生很長的媒體條目列表。";

//--Repository Help
$pgv_lang["help_repolist.php"] = "~#pgv_lang[repo_list]#~<br /><br />此頁面上顯示了一個存儲庫列表。<br /><br />存儲庫的名稱按字母順序排序。<br /><br /><b>存儲庫</b><br />如果沒有存儲庫，我們就無法構建我們的數據庫。數據庫中存儲了所有信息的來源，並且該源存儲在存儲庫中。存儲庫可以是個人存儲庫。存檔一個人，一個機構，一個公共數據庫，一個政府或教堂記錄辦公室，一個互聯網資源等。要訪問一個來源，我們將想知道它在哪里和在什麼地方。所有必要的信息，以找到一個source應存儲在Repository記錄中。<br /><br />存儲庫可以鏈接到許多源。";
$pgv_lang["help_repo.php"] = "~#pgv_lang[repo_info]#~<br /><br />這裡顯示了存儲庫的詳細信息。與源代碼一起，存儲庫對於家譜研究人員非常重要。通過淮確的源和存儲庫信息，您可以跟踪另一位研究人員用來查找信息。您應該能夠再次找到相同的信息。<br /><br />在此頁面上，您可以看到有關存儲庫標題，地址，電子郵件和網頁的信息。<br /><在存儲庫詳細信息之後，將是鏈接到此存儲庫的所有源的列表。這允許您查看從特定存儲庫獲取的所有信息。<br /><br />如果啟用網站管理員，您將在此頁面上顯示一個或兩個菜單圖標：<br /><b>#pgv_lang[view_gedcom]#</b>，以GEDCOM格式顯示信息。<br /><b>#pgv_lang[add_to_cart]#</b>，它允許您將此信息存儲在#pgv_lang[clip_cart]#。从那里，您可以下载GEDCOM文件格式的信息，并将其导入您自己的家谱程序。<br /><br />#pgv_lang[context_help]#";
$pgv_lang["delete_repo_help"] = "~#pgv_lang[delete_repo]#~<br /><br />當您單擊此選項時，您將此存儲庫標記為從數據庫中刪除。<br /><br />這是什麼意思？<br />假設您有充分的理由從數據庫中刪除此存儲庫。您單擊該鏈接。系統將要求您確認刪除請求。如果您決定繼續，可能需要一些時間才能看到存儲庫的消息刪除。<br /><br />當您繼續訪問時，您會注意到存儲庫仍然可見，並且可以像沒有發生刪除一樣使用。<br /><br /><b>這是<u>不</u>錯誤。</b>站點管理員將收到一條消息，表明已對數據庫進行了更改，並且您已刪除了存儲庫。<br />管理員可以接受或拒絕您的更改。只有在管理員接受您的更改後，才會實際刪除<u>不可逆轉</u>。如果對您的更改有任何疑問，管理員將與您聯繫。";
$pgv_lang["show_repo_gedcom_help"] = "~#pgv_lang[view_gedcom]#~<br /><br />單擊此鏈接時，存儲在數據庫中的存儲庫信息將顯示在彈出窗口中。";
$pgv_lang["add_repository_clip_help"] = "~#pgv_lang[add_to_cart]#~<br /><br />當您單擊此鏈接時，您可以將存儲在GEDCOM中的存儲庫添加到#pgv_lang[clip_cart]#。";
$pgv_lang["repolist_listbox_help"] = "~#pgv_lang[repo_list]#~<br /><br />在此框中，您可以看到存儲庫的名稱，因為它們存儲在數據庫中。<br /><br />名稱按字母順序顯示。單擊列表中的名稱後，您將轉到#pgv_lang[repo_info]#頁面，在該頁面中，您將看到鏈接到該存儲庫的源列表。";
$pgv_lang["repos_listbox_help"] = "~#pgv_lang[other_repo_records]#~<br /><br />在此框中，您可以看到鏈接到存儲庫的源名稱。<br /><br />名稱按字母順序顯示。<br /><br />當您單擊列表中的名稱時，您將轉到該源的詳細信息頁面。";

//Index-Edit
$pgv_lang["block_move_up_help"] = "~移動列表條目~<br /><br />使用這些按鈕重新排列列表中條目的順序。這些塊將按列出的順序打印。<br /><br突出顯示要移動的條目，然後單擊按鈕向上或向下移動該條目。";
$pgv_lang["block_move_right_help"] = "~移動列表條目~<br /><br />使用這些按鈕將條目從一個列表移動到另一個列表。<br /><br />突出顯示要移動的條目，然後單擊按鈕移動或按箭頭方向複製該條目。使用<b>&raquo;</b>和<b>&laquo;</b>按鈕將突出顯示的條目從最左側列表移動到最右側列表，反之亦然。<b>&gt;</b>和<b>&lt;</b>按鈕可將#pgv_lang[available_blocks]#列表與列表右側或左側的突出顯示條目移動。<br /><br />無論您使用#pgv_lang[move_right]#和#pgv_lang[move_left]#按鈕執行什麼操作，#pgv_lang[available_blocks]#列表中的條目都不會更改。這是因為同一個塊可以多次出現在同一頁面上。HTML塊就是你可能想要這樣做的一個很好的例子。";
$pgv_lang["block_default_index"] = "~#pgv_lang上的默認塊[welcome]#页面~<br /><br />當您從#pgv_lang[main_section]#和#pgv_lang[right_section]#列表中刪除所有條目時，或者當您單擊<b時>#pgv_lang[reset_default_blocks]#</b>按鈕，阻止列表將設置如下：<br /><br /><span class='center'><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[block_cookiepolicy]#<br />#pgv_lang[gedcom_stats_block]#<br />#pgv_lang[gedcom_news_block]#<br />#pgv_lang[gedcom_favorites_block]#<br />#pgv_lang[review_changes_block]#</td><td>#pgv_lang[gedcom_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[todays_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></span>";
$pgv_lang["block_default_portal"] = "~#pgv_lang上的默認塊[mygedview]#页面~<br /><br />當您從#pgv_lang[main_section]#和#pgv_lang[right_section]#列表中刪除所有條目時，或者當您單擊<b時>#pgv_lang[reset_default_blocks]#</b>按鈕，阻止列表將設置如下：<br /><br /><span class='center'><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[todays_events_block]#<br />#pgv_lang[user_messages_block]#<br />#pgv_lang[user_favorites_block]#<br />&nbsp;</td><td>#pgv_lang[welcome_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[coming_events_block]#<br />#pgv_lang[logged_in_users_block]#</ td></tr></table></span>";

//FAQ page
$pgv_lang["help_faq.php"] = "~常見問題~<br /><br />#pgv_lang[text_faq_help]#";
$pgv_lang["text_faq_help"] = "常見問題解答（常見問題解答）頁面可以包含有關使用此系譜網站的概述或問題和答案列表。<br /><br />FAQ頁面的用途完全取決於站點管理員。站點管理員控制每個條目的內容以及條目在頁面上的顯示順序。";

//Help search
$pgv_lang["hs_title_help"] = "<span class='center'>~#pgv_lang[hs_title]#~</span><br />#pgv_lang[hs_intro]#<br /><br />#pgv_lang[hs_keyword_advice]#<br /><br />#pg_lang[hs_searchhow_advice]#<br /><br />#pgv_lang[hs_searchin_advice]#";
$pgv_lang["hs_intro"] = "你可以搜索網站的幫助系統。#pgv_lang[hs_title]#功能讓你可以高度控制搜索功能;你應該能夠輕鬆找到你想要的東西。";
$pgv_lang["hs_keyword_advice"] = "~#pgv_lang[hs_keyword]#~<br /><br />你輸入你想要找到的單詞或短語。<br /><br />搜索不注意案例（上面或下面）搜索術語或正在檢查的文本。这意味着如果您搜索<b>Individual</b>，您将找到包含<b>Individual</b>，<b>individual</b>或<b>INDIVIDUAL</b>的文本。 您还将找到包含<b>individuals</b>等的文本，因为搜索正在查找字符序列而不是单词。<br /><br />您可以讓搜索一次查找幾個單詞。輸入所有單詞，用空格分隔每個單詞，如下所示：<b>individual&nbsp;family&nbsp;child</b>。當輸入多個單詞時，含義您輸入的內容在#pgv_lang[hs_searchhow]#字段中闡明。";
$pgv_lang["hs_searchin_advice"] = "~#pgv_lang[hs_searchin]#~<br /><br />您可以在此確定搜索範圍。<br /><br />管理員可以選擇搜索用戶幫助或配置幫助，或兩者都有。沒有這個選擇;因為他們無法訪問任何配置功能，他們只能搜索用戶幫助文件。<br /><br />幫助文件不僅包含幫助文本，還包含用於構建輸入的某些文本字符串表單和其他材料。此選項可讓您控制是否應檢查整個幫助文件，或者是否只應查看幫助文本。";
$pgv_lang["hs_searchhow_advice"] = "~#pgv_lang[hs_searchhow]#~<br /><br />您可以通過選擇此處顯示的可能性來澄清您在#pgv_lang[hs_keyword]#字段中輸入內容的含義。<br /><dl><dt><b>#pgv_lang[hs_searchany]#</b></dt><dd>如果您已输入<b>individual&nbsp;family&nbsp;child</b>，此选项将找到包含所列单词之一的帮助文本。单词的顺序无关紧要。搜索的含义是：\“查找帮助文本包含<b>individual</b><u>或</u><b>family</b><u>或</u><b>child</b>\”。</dd><dt><b>#pgv_lang[hs_searchall]#</b></dt><dd>如果你有進入<b>individual&nbsp;family&nbsp;child</b>，此選項會找到包含所有單詞的幫助文字。單詞的順序無關緊要。搜索的含義是：\"查找幫助文字包含<b>individual</b><u>和</u><b>family</b><u>和</u><b>child</b>\"。</dd><dt><b>#pgv_lang[hs_searchsentence]#</b></dt><dd>如果您已輸入<b>individual&nbsp;family&nbsp;child</b>，則s選項將找到包含給定順序中列出的所有詞的幫助文本。搜索的含義是：\"查找包含單詞<b>individual&nbsp;family&nbsp;child</b>的幫助文本，其中沒有其他單詞或字符在\"之間。您可能無法在任何幫助文本中找到此特定短語。<br /><br />此類搜索有一些限制。某些特殊字符，例如<b>&quot; &lt; &gt;</b>等以符號形式包含在幫助文本中，如果它們構成您輸入的文本的一部分，則無法找到。某些幫助文本包含由<b>&amp;nbsp;</b>表示的特殊類型的空格字符，您將找不到包含此字符的短語。</dd></dl>";

//Directory cleanup tool
$pgv_lang["help_dir_editor.php"] = "~#pgv_lang[index_dir_cleanup]#~<br /><br />這個工具可以幫助網站管理員清理索引目錄中的文件。<br /><br />隨著時間的推移，日誌文件，舊GEDCOM等文件文件和舊備份文件可以在索引目錄中建立。由於這些文件中有許多是由程序創建的，因此它們可能由Web服務器用戶擁有。如果它們歸Web服務器用戶所有，則可能無法使用刪除它們。即使這些文件歸Web服務器用戶帳戶所有，也可以刪除這些文件。<br /><br />#pgv_lang[index_dir_cleanup_inst]#";
?>
