<?php
/**
 * Catalan Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2024  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @author Antoni Planas i Vilà
 * @translator Google Translate
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: lang.ca.php 7374 2024-02-13 13:57:05Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["birth_M"]				= "Aniversari de #name#";		// For male persons
$pgv_lang["birth_F"]				= "Aniversari de #name#";		// For female persons
$pgv_lang["born_in_M"]				= "Va néixer #date# a #place#";		// For male persons
$pgv_lang["born_in_F"]				= "Va néixer #date# a #place#";		// For female persons
$pgv_lang["born_on_M"]				= "Va néixer #date#";		// For male persons
$pgv_lang["born_on_F"]				= "Va néixer #date#";		// For female persons
$pgv_lang["death_M"]				= "Aniversari de la mort de #name#";		// For male persons
$pgv_lang["death_F"]				= "Aniversari de la mort de #name#";		// For female persons
$pgv_lang["died_in_M"]				= "Va morir el #date# a #place#";		// For male persons
$pgv_lang["died_in_F"]				= "Va morir el #date# a #place#";		// For female persons
$pgv_lang["died_on_M"]				= "Va morir el #date#";		// For male persons
$pgv_lang["died_on_F"]				= "Va morir el #date#";		// For female persons
$pgv_lang["anniversary_of"]			= "Aniversari de noces de #husband# i #wife#";
$pgv_lang["married_in"]				= "Casat el #date# a #place#";
$pgv_lang["married_on"]				= "Casat el #date#";
$pgv_lang["clustrmaps_locations"]	= "Ubicacions dels visitants d'aquesta pàginae";
$pgv_lang["gedcomid"]				= "ID del registre GEDCOM INDI";
$pgv_lang["sortby"]				= "Seqüència";
$pgv_lang["exact"]				= "Exactament";
$pgv_lang["begins_with"]		= "Comença amb";
$pgv_lang["contains"]			= "Conté";
$pgv_lang["sounds_like"]		= "Sona com";
$pgv_lang["advanced_search"] 	= "Cerca avançada";
$pgv_lang["more_fields"]		= "Afegeix més camps";
$pgv_lang["install_step_8"] 		= "Comenceu";
$pgv_lang["parent_family"]			= "Família amb els pares";
$pgv_lang["step_parent_family"]		= "Família amb el padrastre";
$pgv_lang["immediate_family"]		= "Pròpia família";

$pgv_lang["load_full_tree"]			= "Vegeu aquest arbre en l'arbre interactiu a tota plana";
$pgv_lang["hide_show_spouses"]		= "Mostra o amaga múltiples cònjuges";
$pgv_lang["interactive_tree"]		= "Arbre interactiu";
$pgv_lang["example"]				= "Exemple:";
$pgv_lang["tree"]					= "Arbre";
$pgv_lang["ellipsis"]				= "\xE2\x80\xA6";
$pgv_lang["showUnknown"]			= "Mostra el gènere desconegut";
$pgv_lang["count"]					= "Comptador";
$pgv_lang["age_differences"]		= "Mostra diferències d'edat";
$pgv_lang["multi_site_search"] 		= "Recerca a diversos llocs";
$pgv_lang["switch_lifespan"]		= "Mostra el gràfic de longevitat";
$pgv_lang["switch_timeline"]		= "Mostra l'escala cronològica";
$pgv_lang["differences"]			= "Diferències";
$pgv_lang["charts_block"]			= "Gràfics";
$pgv_lang["charts_block_descr"]		= "El bloc «gràfics» us permet posar-ne a la pàgina d'inici o a la del Portal MyGedView. Podeu configurar el bloc per que n'hi surtin d'avantpassats, descendents o el rellotge de sorra. També us permet escollir la persona arrel del gràfic.";
$pgv_lang["charts_click_box"]		= "Polseu a qualsevol dels caixetins per obtenir més informació sobre aquesta persona.";
$pgv_lang["chart_type"]				= "Tipus de gràfic";
$pgv_lang["changedate1"]			= "Fi del lapse de canvi de dates";
$pgv_lang["changedate2"]			= "Inici del lapse de canvi de dates";
$pgv_lang["search_place_word"]		= "Solament paraules senceres";
$pgv_lang["invalid_search_input"] 	= "Entreu el nom de pila, el cognom o el lloc en relació a l'any";
$pgv_lang["duplicate_username"] 	= "Nom d'usuari «#username#» duplicat. Ja n'hi ha un amb el mateix nom. Escolliu-ne un altre.";
$pgv_lang["usercreate_fail"]		= "L'usuari «#username#» no s'ha pogut afegir al sistema.";
$pgv_lang["cache_life"]				= "Fitxer cau lliure";
$pgv_lang["genealogy"]				= "genealogia";
$pgv_lang["activate"]				= "Activat";
$pgv_lang["deactivate"]				= "Desactivat";
$pgv_lang["play_stop"]				= "Engega / Para";
$pgv_lang["random_media_start_slide"]	= "Engegar la presentació al carregar la pàgina?";
$pgv_lang["random_media_ajax_controls"]	= "Activar els controls de presentació?";
$pgv_lang["description"]			= "Descripció";
$pgv_lang["current_dir"]			= "Directori actual:";
$pgv_lang["SHOW_ID_NUMBERS"]		= "Mostra els números d'ID al costat dels noms";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES"]	= "Mostra imatges als caixetins";
$pgv_lang["view_img_details"]		= "Mostra els detalls de la imatge";
$pgv_lang["server_folder"]			= "Nom del directori al servidor";
$pgv_lang["medialist_recursive"]	= "Mostra els fitxers dels subdirectoris";
$pgv_lang["medialist_unlinked"]		= "Mostra només fitxers multimèdia sense enllaçar";
$pgv_lang["medialist_current_dir"]	= "Subdirectori actual";
$pgv_lang["media_options"]				= "Opcions Multimèdia";
$pgv_lang["confirm_password"]				= "Cal que confirmeu la contrasenya.";
$pgv_lang["enter_email"]				= "Cal que poseu una adreça de correu electrònic.";
$pgv_lang["enter_fullname"] 				= "Cal que poseu el nom de pila i els cognoms.";
$pgv_lang["name"]						= "Nom";
$pgv_lang["names"]					= "Noms";
$pgv_lang["children"]					= "Fills";
$pgv_lang["lchildren"]				= "fills";
$pgv_lang["child"]					= "Fill/a";
$pgv_lang["grandchildren"]			= "néts";
$pgv_lang["family"] 				= "Família";
$pgv_lang["as_child"]					= "Família amb els pares";
$pgv_lang["shared_note_menu"]		= "Opcions de la nota compartida";
$pgv_lang["source_menu"]				= "Opcions per aquesta font";
$pgv_lang["repo_menu"]			= "Opcions per l'Arxiu";
$pgv_lang["other_records"]				= "Registres vinculats a aquesta font";
$pgv_lang["other_repo_records"]			= "Registres vinculats a aquest arxiu";
$pgv_lang["repo_info"]					= "Informació de l'arxiu";
$pgv_lang["enter_terms"]				= "Entreu el terme a cercar";
$pgv_lang["search_asso_label"]			= "Associats";
$pgv_lang["search_asso_text"]				= "Mostra persones/famílies relacionades";
$pgv_lang["search_DM"]					= "Daitch-Mokotoff";
$pgv_lang["search_fams"]				= "Noms de famílies";
$pgv_lang["search_gedcom"]				= "Recerca a les bases de dades";
$pgv_lang["search_geds"]				= "Bases de dades per cercar a";
$pgv_lang["search_indis"]				= "Noms de persones";
$pgv_lang["search_notes"]			= "Notes compartides";
$pgv_lang["search_inrecs"]				= "Cercar per";
$pgv_lang["search_prtall"]				= "Tots els noms";
$pgv_lang["search_prthit"]				= "Noms amb notorietat";
$pgv_lang["results_per_page"]				= "Resultats per pàgina";
$pgv_lang["firstname_search"]				= "Nom";
$pgv_lang["search_prtnames"]				= "Noms de persona a imprimir:";
$pgv_lang["other_searches"]				= "Altres recerques";
$pgv_lang["add_to_cart"]				= "Posa-ho al cistell";
$pgv_lang["view_gedcom"]				= "Mostra el registre GEDCOM";
$pgv_lang["welcome"]					= "Benvingut";
$pgv_lang["son"]						= "Fill";
$pgv_lang["daughter"]					= "Filla";
$pgv_lang["welcome_page"]				= "Inici";
$pgv_lang["editowndata"]				= "El vostre compte";
$pgv_lang["user_admin"] 				= "Administració d'usuaris";
$pgv_lang["manage_media"]				= "Gestió de Multimèdia";
$pgv_lang["search_general"]				= "Recerca general";
$pgv_lang["clipping_privacy"]				= "Algunes entrades potser no s'afegiran per restriccions de privadesa";
$pgv_lang["chart_new"]					= "Arbre genealògic";
$pgv_lang["loading"]					= "Carregant...";
$pgv_lang["clear_chart"]				= "Buida el gràfic";
$pgv_lang["file_information"]				= "Informació del fitxer";
$pgv_lang["choose_file_type"]				= "Escolliu el tipus de fitxer";
$pgv_lang["add_individual_by_id"]			= "Afegiu-hi una persona per llur ID";
$pgv_lang["advanced_options"]				= "Opcions avançades";
$pgv_lang["zip_files"]					= "Fitxer(s) Zip";
$pgv_lang["include_media"]				= "Inclou Multimèdia (comprimeix automàticament els fitxers)";
$pgv_lang["roman_surn"]					= "Cognom Romanitzat";
$pgv_lang["roman_givn"]					= "Noms de pila romanitzats";
$pgv_lang["include"]					= "Inclou:";
$pgv_lang["page_x_of_y"]				= "Pàgina #GLOBALS[currentPage]# de #GLOBALS[lastPage]#";
$pgv_lang["options"]					= "Opcions:";
$pgv_lang["config_update_ok"]				= "S'ha modificat correctament el fitxer de configuració.";
$pgv_lang["page_size"]					= "Mida de pàgina";
$pgv_lang["font"]					= "Font";
$pgv_lang["use_colors"]				= "Utilitza colors";
$pgv_lang["record_not_found"]				= "El registre que heu demanat no s'ha pogut trobar. Pot ésser degut a vincular-lo a una persona incorrecta o per un problema de corrupció del fitxer GEDCOM.";
$pgv_lang["result_page"]				= "Pàgina de resultats";
$pgv_lang["edit_media"]					= "Edita l'ítem multimèdia";
$pgv_lang["wiki_main_page"]				= "Pàgina Principal de Wiki";
$pgv_lang["wiki_users_guide"]				= "Guia Wiki d'Usuaris";
$pgv_lang["wiki_admin_guide"]				= "Guia Wiki d'Administradors";
$pgv_lang["no_search_for"]				= "Cal que us assegureu de seleccionar una opció de recerca.";
$pgv_lang["no_search_site"]				= "Cal assegurar-se de seleccionar al menys un lloc remot.";
$pgv_lang["search_sites"] 				= "Llocs a buscar";
$pgv_lang["site_list"]					= "Lloc: ";
$pgv_lang["site_had"]					= " contenint el següent";
$pgv_lang["label_search_engine_detected"]  	= "S'ha detectat un Motor de Recerca";

$pgv_lang["ex-spouse"] 					= "Ex-Cònjuge";
$pgv_lang["ex-wife"] 					= "Ex-Muller";
$pgv_lang["ex-husband"] 				= "Ex-Marit";
$pgv_lang["noemail"] 					= "Adreces sense correu electrònic";
$pgv_lang["onlyemail"] 					= "Solament adreces amb correu electrònic";
$pgv_lang["maxviews_exceeded"]			= "Heu excedit el temps de visualització de #GLOBALS[MAX_VIEWS]# que és de #GLOBALS[MAX_VIEW_TIME]# segons.";
$pgv_lang["broadcast_not_logged_6mo"]		= "Als usuaris que no hagin accedit durant els darrers 6 mesos";
$pgv_lang["broadcast_never_logged_in"]		= "Als usuaris que no hagin accedit mai";
$pgv_lang["stats_to_show"]				= "Seleccioneu les entrades a mostrar en aquest bloc";
$pgv_lang["stat_avg_age_at_death"]			= "Promig d'edat de defunció";
$pgv_lang["stat_longest_life"]			= "Persona que ha viscut més temps";
$pgv_lang["stat_most_children"]			= "Família amb més mainada";
$pgv_lang["stat_average_children"]			= "Promig de mainada per família";
$pgv_lang["stat_events"]				= "Esdeveniments";
$pgv_lang["stat_media"]					= "Objectes Multimèdia";
$pgv_lang["stat_surnames"]				= "Cognoms";
$pgv_lang["stat_users"]					= "Usuaris";
$pgv_lang["no_family_facts"]				= "No hi ha esdeveniments per a aquesta família.";
$pgv_lang["stat_males"]					= "Homes";
$pgv_lang["stat_females"]				= "Dones";
$pgv_lang["stat_unknown"]			= "Total desconegut";
$pgv_lang["stat_link"]				= "Mostra les estadístiques en forma de gràfic";
$pgv_lang["print_stat_link"]		= "Mostra l'enllaç als gràfics estadistics?";

$pgv_lang["sunday_1st"]					= "Dg";
$pgv_lang["monday_1st"]					= "Dl";
$pgv_lang["tuesday_1st"]				= "Dt";
$pgv_lang["wednesday_1st"]				= "Dm";
$pgv_lang["thursday_1st"]				= "Dj";
$pgv_lang["friday_1st"]					= "Dv";
$pgv_lang["saturday_1st"]				= "Ds";

$pgv_lang["jan_1st"]					= "Gen";
$pgv_lang["feb_1st"]					= "Feb";
$pgv_lang["mar_1st"]					= "Mar";
$pgv_lang["apr_1st"]					= "Abr";
$pgv_lang["may_1st"]					= "Mai";
$pgv_lang["jun_1st"]					= "Jun";
$pgv_lang["jul_1st"]					= "Jul";
$pgv_lang["aug_1st"]					= "Ago";
$pgv_lang["sep_1st"]					= "Set";
$pgv_lang["oct_1st"]					= "Oct";
$pgv_lang["nov_1st"]					= "Nov";
$pgv_lang["dec_1st"]					= "Des";

$pgv_lang["edit_source"]				= "Edita la font";
$pgv_lang["edit_shared_note"]		= "Edita la nota compartida";
$pgv_lang["familybook_chart"]				= "Llibre de Família";
$pgv_lang["family_of"]					= "Família de&nbsp;";
$pgv_lang["descent_steps"]				= "Generacions de descendents";

$pgv_lang["cancel"]					= "Cancel·la";
$pgv_lang["cookie_help"]				= "Aquest lloc fa servir galetes per fer el seguiment de la vostra situació d'accés.<br /><br />No les teniu activades al vostre navegador. Cal que ho feu abans d'accedir. Podeu consultar la documentació d'ajuda del vostre navegador per saber com activar les galetes.";
//new stuff
//Individual
$pgv_lang["indi_is_remote"]				= "La informació d'aquesta persona ha sigut enllaçada des d'un lloc remot.";
$pgv_lang["link_remote"]					= "Enllaceu una persona remota";
//Add Remote Link
$pgv_lang["title_search_link"]  			= "Afegiu un enllaç local";
$pgv_lang["label_site_url2"]				= "URL del Lloc";
//new stuff

$pgv_lang["delete_family_confirm"]			= "Eliminant la família es perdran tots els vincles dels seus membres, però aquests romandran actius i a la base de dades. Segur que voleu suprimir aquesta família?";
$pgv_lang["delete_family"]				= "Elimina la família";
$pgv_lang["add_favorite"]				= "Afegiu un nou favorit";
$pgv_lang["url"]						= "URL";
$pgv_lang["add_fav_enter_note"]			= "Entreu una nota (opcional) sobre aquest favorit";
$pgv_lang["add_fav_or_enter_url"]			= "O<br />Entreu un URL i un títol";
$pgv_lang["add_fav_enter_id"]				= "Entreu un ID de Persona, Família o Font";
$pgv_lang["remove_child"]				= "Suprimeix aquest/a fill/a de la família";
$pgv_lang["link_new_husb"]				= "Afegeix-li un marit emprant algú existent";
$pgv_lang["link_new_wife"]				= "Afegeix-li una muller emprant algú existent";
$pgv_lang["address_labels"]				= "Etiquetes de correu";
$pgv_lang["filter_address"]				= "Mostra adreces que continguin:";
$pgv_lang["address_list"]				= "Llistat d'adreces";
$pgv_lang["index_edit_advice"]			= "Ressalteu un nom de bloc i desprès polseu una de les fletxes per moure el bloc vers la direcció indicada.";
$pgv_lang["changelog"]					= "Canvis a la versió #VERSION#";
$pgv_lang["html_block_descr"]				= "Aquest és un senzill un bloc HTML que podeu posar a la vostra pàgina i entrar-hi qualsevol tipus de missatge.";
$pgv_lang["html_block_sample_part1"]		= "<p class=\"blockhc\"><b>Poseu el títol aquí</b></p><br /><p>Polseu el botó de configurar";
$pgv_lang["html_block_sample_part2"]		= "per canviar el que s'ha imprès aquí.</p>";
$pgv_lang["html_block_name"]				= "HTML";
$pgv_lang["htmlplus_block_name"]			= "HTML avançat";
$pgv_lang["htmlplus_block_descr"]			= "Aquest és un bloc HTML que podeu posar a la vostra pàgina i penjar-hi qualsevol tipus de missatge. Dins del text HTML podeu inserir-hi referències al fitxer GEDCOM.";
$pgv_lang["htmlplus_block_templates"] 		= "Plantilles";
$pgv_lang["htmlplus_block_content"] 		= "Contingut";
$pgv_lang["htmlplus_block_narrative"] 		= "Estil narratiu (solament en Anglès)";
$pgv_lang["htmlplus_block_custom"]			= "Personalitzar";
$pgv_lang["htmlplus_block_keyword"]			= "Exemples de tecles (solament en Anglès)";
$pgv_lang["htmlplus_block_taglist"]			= "Llista d'etiquetes";
$pgv_lang["htmlplus_block_compat"]			= "Mode compatible";
$pgv_lang["htmlplus_block_ui"]		= "Interfície extens";
$pgv_lang["htmlplus_block_current"]			= "Actual";
$pgv_lang["htmlplus_block_default"]			= "Per defecte";
$pgv_lang["htmlplus_block_gedcom"]			= "Arbre genealògic";
$pgv_lang["htmlplus_block_birth"]			= "naixement";
$pgv_lang["htmlplus_block_death"]			= "defunció";
$pgv_lang["htmlplus_block_marrage"]			= "casament";
$pgv_lang["htmlplus_block_adoption"]		= "adopció";
$pgv_lang["htmlplus_block_burial"]			= "enterrament";
$pgv_lang["htmlplus_block_census"]			= "inscrit al registre";
$pgv_lang["num_to_show"]				= "Nombre d'entrades a mostrar";
$pgv_lang["days_to_show"]				= "Nombre de dies a mostrar";
$pgv_lang["before_or_after"]				= "Comptador de llocs abans o desprès del nom?";
$pgv_lang["before"]					= "abans";
$pgv_lang["after"]					= "desprès";
$pgv_lang["config_block"]				= "Configuració";
$pgv_lang["enter_comments"]				= "Feu el favor de descriure la vostra relació (parentiu) amb les dades al camp de Comentaris.";
$pgv_lang["comments"]					= "Comentaris";
$pgv_lang["child-family"]				= "Pares i germans";
$pgv_lang["spouse-family"]				= "Cònjuge i mainada";
$pgv_lang["direct-ancestors"]				= "Avantpassats per línea directa";
$pgv_lang["ancestors"]					= "Avantpassats per línea directa i llurs famílies";
$pgv_lang["descendants"]				= "Descendents";
$pgv_lang["choose_relatives"]				= "Escolliu parents";
$pgv_lang["relatives_report"]				= "Informe de parentiu";
$pgv_lang["total_unknown"]			= "Total desconegut";
$pgv_lang["total_living"]				= "Total de vius";
$pgv_lang["total_dead"]					= "Total de difunts";
$pgv_lang["total_not_born"]				= "Total encara no nats";
$pgv_lang["remove_custom_tags"]			= "Eliminar etiquetes PGV d'usuari? (p.e.: _PGVU, _THUM)";
$pgv_lang["fams_with_surname"]			= "Famílies amb cognom començant per #surname#";
$pgv_lang["support_contact"]				= "Responsable de qüestions tècniques";
$pgv_lang["genealogy_contact"]			= "Responsable de qüestions genealògiques";
$pgv_lang["common_upload_errors"]			= "Aquest error és degut probablement a que el fitxer que heu escollit per pujar excedeix el límit permès pel vostre servidor web. El límit per defecte a PHP és de 2MB. Contacteu amb l'administració del vostre servidor per a demanar-li augmentar el límit al fitxer php.ini file. També teniu l'opció de pujar el fitxer emprant FTP. Feu servir la pàgina <a href=\"uploadgedcom.php?action=add_form\"><b>#pgv_lang[add_gedcom]#</b></a> per a afegir un fitxer GEDCOM que hagueu pujat amb FTP.";
$pgv_lang["max_upload_advice"]		= "Si necessiteu penjar fitxers més grans que el màxim que es mostra aquí, cal ajustar l'opció de configuració <i>upload_max_filesize</i> al fitxer <i>php.ini</i> del servidor. És possible que hàgiu de consultar l'assistència del vostre servidor.";
$pgv_lang["total_memory_usage"]			= "Total memòria emprada:";
$pgv_lang["mothers_family_with"]			= "Família per part de mare amb ";
$pgv_lang["fathers_family_with"]			= "Família per part de pare amb ";
$pgv_lang["family_with"]				= "Família amb";
$pgv_lang["halfsibling"]				= "Germanastre/a";
$pgv_lang["halfbrother"]				= "Germanastre";
$pgv_lang["halfsister"]					= "Germanastra";
$pgv_lang["family_timeline"]				= "Mostra la família a l'escala cronològica";
$pgv_lang["children_timeline"]			= "Mostrar la mainada a l'escala cronològica";
$pgv_lang["other"]					= "Altre";
$pgv_lang["others"]					= "Altres";
$pgv_lang["sort_by_marriage"]				= "Ordena per data de casament";
$pgv_lang["reorder_families"]				= "Reordena famílies";
$pgv_lang["indis_with_surname"]			= "Persones amb cognom començant per #surname#";
$pgv_lang["first_letter_name"]		= "Escolliu una lletra per mostrar les famílies quin nom comenci amb aquesta lletra.";
$pgv_lang["first_letter_sfname"]	= "Trieu una lletra per mostrar les famílies en que un cònjuge tingui un nom de pila que comenci per aquesta lletra.";
$pgv_lang["first_letter_iname"]		= "Escolliu una lletra per mostrar les persones quin cognom comenci per aquesta lletra";
$pgv_lang["first_letter_fname"]			= "Escolliu una lletra per veure les persones quin nom de pila comenci així.";
$pgv_lang["total_names"]				= "Total de noms";
$pgv_lang["total_changes"]			= "Total de canvis";
$pgv_lang["total_links"]			= "Total d'enllaços";
$pgv_lang["top10_pageviews_nohits"]			= "Actualment no hi ha ocurrències per veure.";
$pgv_lang["top10_pageviews_msg"]			= "El comptador cal que l'activar-lo a la configuració del GEDCOM, Secció Mostrar i Disposar, Ocultar i Mostrar grup.";
$pgv_lang["review_changes_descr"]			= "El bloc «canvis pendents» dóna als usuaris amb drets d'edició una llista dels registres que han sigut canviats en línea i que estan pendents de revisió. Aquests canvis poden ésser acceptats o rebutjats.<br /><br />Si aquest bloc és activat, els usuaris amb drets per acceptar-los rebran un correu electrònic un cop al dia notificant-los que hi ha canvis per revisar.";
$pgv_lang["review_changes_block"]			= "Canvis pendents";
$pgv_lang["review_changes_subject"]			= "PhpGedView - Revisa els canvis";
$pgv_lang["review_changes_body"]			= "S'han fet canvis en línea a la base de dades genealògica. Cal revisar-los i acceptar-los abans de que puguin ésser vistos per tots els usuaris. Feu servir l'enllaç de sota per accedir al lloc PhpGedView i entreu-hi per revisar-los.";
$pgv_lang["show_pending"]		= "Mostra els canvis pendents";
$pgv_lang["show_spouses"]				= "Mostrar cònjuges";
$pgv_lang["quick_update_title"] 			= "Modificació ràpida";
$pgv_lang["quick_update_instructions"] 		= "Aquesta pàgina permet modificar ràpidament informació d'una persona. Solament us cal omplir la informació que és nova o que ha canviat respecte de la que hi ha a la base de dades. Un cop desats els canvis caldrà que siguin revisats per un administrador abans que esdevinguin visibles per a tothom.";
$pgv_lang["update_name"] 				= "Modifica el nom";
$pgv_lang["update_fact"] 				= "Modifica un esdeveniment";
$pgv_lang["update_fact_restricted"] 		= "La modificació d'aquest esdeveniment és restringida:";
$pgv_lang["select_fact"] 				= "Seleccioneu un esdeveniment...";
$pgv_lang["update_address"] 				= "Modifica l'adreça";
$pgv_lang["top10_pageviews_descr"]			= "El bloc «Entrades més visitades» mostra els registres més visitats. Necessita que el comptador s'hagi activat a la configuració dels paràmetres GEDCOM.";
$pgv_lang["top10_pageviews"]				= "Entrades més visitades";
$pgv_lang["top10_pageviews_block"]			= "Entrades més visitades";
$pgv_lang["stepparent"]				= "Padrastre";
$pgv_lang["stepdad"]					= "Padrastre";
$pgv_lang["stepmom"]					= "Madrastra";
$pgv_lang["stepsister"]					= "Germanastra";
$pgv_lang["stepbrother"]				= "Germanastre";
$pgv_lang["fams_charts"]				= "Opcions per aquesta família";
$pgv_lang["indis_charts"]				= "Opcions per aquesta persona";
$pgv_lang["none"]					= "Res";
$pgv_lang["facts"]					= "Esdeveniments";
$pgv_lang["locked"]					= "No canviïs res";
$pgv_lang["privacy"]					= "Privadesa";
$pgv_lang["number_sign"]				= "#";

//-- GENERAL HELP MESSAGES
$pgv_lang["qm"]				= "?";
$pgv_lang["qm_ah"]			= "?";
$pgv_lang["page_help"]			= "Ajuda";
$pgv_lang["help_for_this_page"]	= "Ajuda per a aquesta pàgina";
$pgv_lang["help_contents"]		= "Índex d'ajuda";
$pgv_lang["show_context_help"]	= "Mostra l'ajuda contextual";
$pgv_lang["hide_context_help"]	= "Amaga l'ajuda contextual";
$pgv_lang["sorry"]			= "<b> Ho sentim! encara no hi ha text d'ajuda per a aquesta pàgina o entrada</b>";
$pgv_lang["help_not_exist"]		= "<b>Encara no hi ha disponible un text d'ajuda per a aquesta pàgina o entrada</b>";
$pgv_lang["var_not_exist"]		= "<span style=\"font-weight: bold\">La variable del idioma no existeix. Advertiu d'aquest error.</span>";
$pgv_lang["resolution"]			= "Resolució de pantalla";
$pgv_lang["menu"]				= "Menú";
$pgv_lang["header"]			= "Capçalera";
$pgv_lang["imageview"]			= "Visor d'imatges";

//-- CONFIG FILE MESSAGES
$pgv_lang["login_head"] 		= "Accés d'usuaris a PhpGedView";
$pgv_lang["for_support"]		= "Per a qüestions administratives i tècniques adreceu-vos a";
$pgv_lang["for_contact"]		= "Per a qüestions genealògiques adreceu-vos a";
$pgv_lang["for_all_contact"]		= "Per a qüestions tècniques i genealògiques adreceu-vos a";
$pgv_lang["choose_username"]		= "Nom d'usuari desitjat";
$pgv_lang["username"]			= "Nom d'usuari";
$pgv_lang["invalid_username"]		= "El nom d'usuari «#username#» conté caràcters invàlids";
$pgv_lang["firstname"]			= "Nom de pila";
$pgv_lang["lastname"]			= "Cognom";
$pgv_lang["choose_password"]		= "Contrasenya desitjada";
$pgv_lang["password"]			= "Contrasenya";
$pgv_lang["confirm"]			= "Confirmeu la contrasenya";
$pgv_lang["login"]			= "Accés";
$pgv_lang["logout"]			= "Surt";
$pgv_lang["admin"]			= "Administració";
$pgv_lang["logged_in_as"]		= "Heu accedit com a ";
$pgv_lang["my_pedigree"]		= "El vostre arbre";
$pgv_lang["my_indi"]			= "La vostra fitxa";
$pgv_lang["yes"]				= "Si";
$pgv_lang["no"]				= "No";
$pgv_lang["change_theme"]		= "Canvieu la presentació";

//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]		= "Arbre genealògic";
$pgv_lang["gen_ped_chart"]		= "#PEDIGREE_GENERATIONS# Generacions d'avantpassats";
$pgv_lang["generations"]		= "Generacions";
$pgv_lang["view"]				= "Mostra-ho";
$pgv_lang["fam_spouse"]			= "Família amb el cònjuge:";
$pgv_lang["rootid"] 				= "Persona arrel de l'arbre genealògic";
$pgv_lang["root_person"]		= "ID persona arrel";
$pgv_lang["hide_details"]		= "Amaga els detalls";
$pgv_lang["show_details"]		= "Mostra els detalls";
$pgv_lang["zoom_box"]			= "Amplia/redueix";
$pgv_lang["orientation"]		= "Orientació";
$pgv_lang["portrait"]			= "Plantat";
$pgv_lang["landscape"]			= "Apaïsat";
$pgv_lang["landscape_top"]			= "Més antics a la part superior";
$pgv_lang["landscape_down"]			= "Més antics a la part inferior";
$pgv_lang["start_at_parents"]		= "Començant pels seus pares";
$pgv_lang["charts"]			= "Gràfics";
$pgv_lang["lists"]			= "Llistes";
$pgv_lang["box_width"] 			= "Amplada del caixetí";
$pgv_lang["random_surn"]			= "Cognom a l'atzar";
$pgv_lang["generation_number"]		= "Generacions";
$pgv_lang["variable"]				= "Variable";

//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"] 	= "Impossible trobar cap família amb l'ID";
$pgv_lang["unable_to_find_record"]  = "Impossible trobar cap registre amb l'ID";
$pgv_lang["title"]  				= "Títol:";
$pgv_lang["living"]				= "Persona viva";
$pgv_lang["private"]			= "Informació privada";
$pgv_lang["birth"]				= "Naixement";
$pgv_lang["death"]				= "Defunció";
$pgv_lang["descend_chart"]		= "Diagrama de descendents";
$pgv_lang["individual_list"]	= "Persones";
$pgv_lang["family_list"]		= "Famílies";
$pgv_lang["branch_list"]		= "Branques";
$pgv_lang["source_list"]		= "Fonts";
$pgv_lang["shared_note_list"]	= "Notes compartides";
$pgv_lang["place_list"]			= "Llocs";
$pgv_lang["place_list_aft"] 	= "Llocs corresponents a";
$pgv_lang["media_list"] 		= "Multimèdia";
$pgv_lang["repo_list"]			= "Arxius";
$pgv_lang["search"]				= "Cerca";
$pgv_lang["clippings_cart"] 	= "Cistell genealògic";
$pgv_lang["print_preview"]		= "Simplifica pàgina";
$pgv_lang["cancel_preview"]		= "Vista normal";
$pgv_lang["change_lang"]		= "Escolliu l'idioma";
$pgv_lang["language"]			= "Idioma";
$pgv_lang["print"]				= "Imprimeix";
$pgv_lang["total_queries"]		= "Consultes a la Base de Dades: ";
$pgv_lang["total_privacy_checks"]	= "Total comprovacions de privadesa ";
$pgv_lang["back"]				= "Enrere";

//-- INDIVIDUAL FILE MESSAGES
$pgv_lang["aka"]				= "Conegut per";
$pgv_lang["male"]				= "Home";
$pgv_lang["males"]					= "Homes";
$pgv_lang["female"]			= "Dona";
$pgv_lang["females"]				= "Dones";
$pgv_lang["temple"]			= "Temple SUD";
$pgv_lang["temple_code"]		= "Codi Temple SUD:";
$pgv_lang["status"]			= "Estatus";
$pgv_lang["source"]			= "Font";
$pgv_lang["text"]				= "Text de la font:";
$pgv_lang["note"]				= "Nota:";
$pgv_lang["NN"]				= "(Cognom desconegut)";	// Family name
$pgv_lang["PN"]				= "(Nom desconegut)";		// Given name
$pgv_lang["NNPN"]			= "(Nom i cognom desconeguts)";		// Full name
// $pgv_lang["NNhebrew"] 		use value from lang.en.php
// $pgv_lang["PNhebrew"] 		use value from lang.en.php
// $pgv_lang["NNPNhebrew"] 		use value from lang.en.php
// $pgv_lang["NNarabic"] 		use value from lang.en.php
// $pgv_lang["PNarabic"] 		use value from lang.en.php
// $pgv_lang["NNPNarabic"] 		use value from lang.en.php
// $pgv_lang["NNgreek"] 		use value from lang.en.php
// $pgv_lang["PNgreek"] 		use value from lang.en.php
// $pgv_lang["NNPNgreek"] 		use value from lang.en.php
// $pgv_lang["NNrussian"] 		use value from lang.en.php
// $pgv_lang["PNrussian"] 		use value from lang.en.php
// $pgv_lang["NNPNrussian"] 	use value from lang.en.php
// $pgv_lang["NNchinese"] 		use value from lang.en.php
// $pgv_lang["PNchinese"] 		use value from lang.en.php
// $pgv_lang["NNPNchinese"] 	use value from lang.en.php
// $pgv_lang["NNvietnamese"] 	use value from lang.en.php
// $pgv_lang["PNvietnamese"] 	use value from lang.en.php
// $pgv_lang["NNPNvietnamese"] 	use value from lang.en.php
// $pgv_lang["NNthai"] 			use value from lang.en.php
// $pgv_lang["PNthai"] 			use value from lang.en.php
// $pgv_lang["NNPNthai"] 		use value from lang.en.php
$pgv_lang["NNother"]			= "(Cognom desconegut)";	// Family name
$pgv_lang["PNother"]			= "(Nom desconegut)";		// Given name
$pgv_lang["NNPNother"]			= "(Nom i cognom desconeguts)";		// Full name
$pgv_lang["unrecognized_code"]	= "Codi GEDCOM desconegut";
$pgv_lang["unrecognized_code_msg"]	= "Això és un error i caldria arranjar-lo. Si us plau, preneu-ne nota i notifiqueu-ho a";
$pgv_lang["indi_info"]			= "Fitxa personal";
$pgv_lang["pedigree_chart"] 		= "Arbre genealògic";
$pgv_lang["individual"]			= "Persona";
$pgv_lang["as_spouse"]  			= "Família amb el cònjuge";
$pgv_lang["privacy_error"]  		= "Aquesta informació és privada i no pot veure's";
$pgv_lang["more_information"]		= "Per més informació adreceu-vos a";
$pgv_lang["given_name"]				= "Noms de Pila";
$pgv_lang["surname"]			= "Cognom";
$pgv_lang["sex"]				= "Sexe";
$pgv_lang["personal_details"]	= "Dades personals";
$pgv_lang["personal_facts"]	   	= "Dades personals i detalls";
$pgv_lang["type"]				= "Tipus";
$pgv_lang["parents"] 			= "Pares";
$pgv_lang["gparents"]				= "Avis";
$pgv_lang["siblings"]   			= "Germà";
$pgv_lang["father"] 			= "Pare";
$pgv_lang["mother"] 			= "Mare";
$pgv_lang["parent"] 			= "Pare";
$pgv_lang["parent_age"] 			= "Edat del/la pare/mare";
$pgv_lang["father_age"]				= "Edat del pare";
$pgv_lang["mother_age"]				= "Edat de la mare";
$pgv_lang["self"] 					= "Un mateix";
$pgv_lang["relatives"]			= "Parents directes";
$pgv_lang["relatives_events"]		= "Esdeveniments relacionats amb parents directes";
$pgv_lang["historical_facts"]		= "Esdeveniments històrics";
$pgv_lang["partner"] 				= "Parella";
$pgv_lang["spouse"] 				= "Cònjuge";
$pgv_lang["spouses"] 				= "Cònjuges";
$pgv_lang["surnames"]			= "Cognoms";
$pgv_lang["adopted"]			= "Adoptat";
$pgv_lang["foster"]			= "Adoptiu";
$pgv_lang["sealing"]			= "Segellament";
$pgv_lang["challenged"]			= "Recusat";
$pgv_lang["disproved"]			= "Refutat";
$pgv_lang["infant"]			= "Infant";
$pgv_lang["stillborn"]			= "Nat mort";
$pgv_lang["deceased"]			= "Difunt";
$pgv_lang["link_as_wife"]		= "Vincular-la a una família existent com a esposa";
$pgv_lang["no_tab1"]			= "No hi ha Esdeveniments d'aquesta persona.";
$pgv_lang["no_tab2"]			= "No hi ha Notes d'aquesta persona.";
$pgv_lang["no_tab3"]			= "No hi ha Fonts d'aquesta persona.";
$pgv_lang["no_tab4"]			= "No hi ha objectes multimèdia d'aquesta persona.";
$pgv_lang["no_tab5"]			= "No hi ha parents directes d'aquesta persona.";
$pgv_lang["no_tab6"]			= "No hi ha registres de recerca annexats a aquesta persona.";
$pgv_lang["show_fact_sources"]		= "Mostra totes les fonts";
$pgv_lang["show_fact_notes"]		= "Mostra totes les notes";

//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"] 		= "Informació Familiar";
$pgv_lang["family_group_info"]  	= "Informació del Grup Familiar";
$pgv_lang["husband"]				= "Espòs";
$pgv_lang["wife"]				= "Esposa";
$pgv_lang["marriage"]			= "Casament:";
$pgv_lang["lds_sealing"]		= "Segellament SUD:";
$pgv_lang["marriage_license"]		= "Acta matrimonial:";
$pgv_lang["no_children"]		= "Sense mainada enregistrada";
$pgv_lang["known_child"]			= "1 nen";
$pgv_lang["known_children"]			= "nens";
$pgv_lang["childless_family"]		= "Aquesta família no té descendència";
$pgv_lang["parents_timeline"]   	= "Mostra la parella a l'escala cronològica";

//-- CLIPPINGS FILE MESSAGES
$pgv_lang["clip_cart"]  			= "Cistell Genealògic";
$pgv_lang["which_links"]			= "Quins altres enllaços d'aquesta família voleu afegir-hi?";
$pgv_lang["just_family"]		= "Posa-hi únicament aquest registre familiar.";
$pgv_lang["parents_and_family"]	= "Afegeix els pares a aquest registre familiar.";
$pgv_lang["parents_and_child"]	= "Afegeix pares i mainada a aquest registre familiar.";
$pgv_lang["parents_desc"]		= "Afegeix els pares i tots els registres dels descendents a aquest registre familiar.";
$pgv_lang["continue"]			= "Continua afegint";
$pgv_lang["which_p_links"]  		= "Quins altres vincles d'aquesta persona cal posar també al cistell?";
$pgv_lang["just_person"]		= "Posa-hi solament aquesta persona.";
$pgv_lang["person_parents_sibs"]	= "Posa-hi aquesta persona, llurs pares i germans.";
$pgv_lang["person_ancestors"]   	= "Posa-hi aquesta persona i llur línia d'avantpassats directes.";
$pgv_lang["person_ancestor_fams"]	="Posa-hi aquesta persona, llur línia d'avantpassats directes i llurs famílies.";
$pgv_lang["person_spouse"]  		= "Posa-hi aquesta persona, llur cònjuge i mainada.";
$pgv_lang["person_desc"]			= "Posa-hi aquesta persona, llur cònjuge i tots els descendents.";
$pgv_lang["which_s_links"]			= "Quins registres vinculats a aquesta font cal afegir?";
$pgv_lang["just_source"]		= "Posa-hi solament aquesta font.";
$pgv_lang["linked_source"]		= "Posa-hi aquesta font i les famílies/persones amb ella relacionades.";
$pgv_lang["person_private"]		= "Els detalls sobre aquesta persona son privats i no s'inclouran.";
$pgv_lang["family_private"]		= "Els detalls sobre aquesta família son privats i no s'inclouran.";
$pgv_lang["media_private"] 			= "Els detalls d'aquest multimèdia són privats i no s'inclouran.";
$pgv_lang["cart_is_empty"]  		= "El cistell és buit.";
$pgv_lang["id"]				= "ID";
$pgv_lang["ID"]				= "ID";
$pgv_lang["name_description"]   	= "Nom / Descripció";
$pgv_lang["remove"]			= "Elimina";
$pgv_lang["empty_cart"]			= "Buida el cistell";
$pgv_lang["download_now"]		= "Descarrega ara";
$pgv_lang["download_file"]			= "Descarrega el fitxer #GLOBALS[whichFile]#";
$pgv_lang["indi_downloaded_from"]	= "Aquesta persona ha sigut descarregada des de:";
$pgv_lang["family_downloaded_from"]	= "Aquesta família ha sigut descarregada des de:";
$pgv_lang["source_downloaded_from"]	= "Aquesta font prové de:";
$pgv_lang["enter_person_generations"] = "Nombre de generacions:";
$pgv_lang["convertPath"]			= "Converteix el camí multimèdia";
$pgv_lang["convertSlashes"]			= "Converteix els separadors de carpetes multimèdia";
$pgv_lang["forwardSlashes"]			= "Barres inclinades: /";
$pgv_lang["backSlashes"]			= "Barres:  \\";

//-- PLACELIST FILE MESSAGES
$pgv_lang["connections"]		= "lloc/s corresponent/s a";
$pgv_lang["top_level"]			= "Nivell superior";
$pgv_lang["form"]				= "Els llocs es codifiquen així: ";
$pgv_lang["default_form"]   		= "Població, Comtat, Estat/Província, País";
$pgv_lang["default_form_info"]	= "(Per defecte)";
$pgv_lang["unknown"]			= "Desconegut";
$pgv_lang["individuals"]		= "Persones";
$pgv_lang["view_records_in_place"]	= "Mostra tots els registres relacionats amb aquest lloc";
$pgv_lang["place_list2"] 		= "Llistat de llocs";
$pgv_lang["show_place_hierarchy"]	= "Mostra els llocs jeràrquicament";
$pgv_lang["show_place_list"]		= "Mostra tots els llocs en un únic llistat";
$pgv_lang["total_unic_places"]	= "Total llocs únics";

//-- MEDIALIST FILE MESSAGES
$pgv_lang["external_objects"]		= "Objectes externs";
$pgv_lang["multi_title"]			= "Llista d'objectes Multimèdia";
$pgv_lang["media_found"]			= "Objectes Multimèdia";
$pgv_lang["view_person"]		= "Mostra la persona:";
$pgv_lang["view_family"]			= "Mostra la família";
$pgv_lang["view_source"]		= "Mostra la font";
$pgv_lang["view_object"]		= "Mostra l'objecte";
$pgv_lang["first_page"]				= "Primera pàgina";
$pgv_lang["previous_page"]			= "Pàgina anterior";
$pgv_lang["next_page"]				= "Pàgina següent";
$pgv_lang["last_page"]				= "Darrera pàgina";
$pgv_lang["next_image"]			= "Següent imatge";
$pgv_lang["file_not_found"]		= "Fitxer inexistent";
$pgv_lang["medialist_show"] 		= "Veure-ho ";
$pgv_lang["per_page"]			= "objectes multimèdia per pàgina";
$pgv_lang["media_format"]		= "Format multimèdia";
$pgv_lang["image_size"]			= "Mides de l'imatge";
$pgv_lang["media_id"]			= "ID del multimèdia";
$pgv_lang["invalid_id"]			= "En aquest fitxer GEDCOM no hi ha aquest ID.";
$pgv_lang["record_updated"]		= "S'ha modificat correctament el registre #pid#.";
$pgv_lang["record_not_updated"]	= "No pot modificar-se el registre #pid#.";
$pgv_lang["record_removed"]		= "S'ha eliminat correctament el registre #xref# del GEDCOM.";
$pgv_lang["record_not_removed"]	= "No es pot eliminar el registre #xref# del GEDCOM.";
$pgv_lang["record_added"]		= "S'ha afegit correctament el registre #xref# al GEDCOM.";
$pgv_lang["record_not_added"]		= "No es pot afegir el registre #xref# al GEDCOM.";

//-- SEARCH FILE MESSAGES
$pgv_lang["soundex_search"] 		= "Recerca per la forma en la suposeu que s'escriu el nom (fonètica)";
$pgv_lang["sources"]			= "Fonts";
$pgv_lang["shared_notes"]			= "Notes compartides";
$pgv_lang["lastname_search"]		= "Cognom/s";
$pgv_lang["search_place"]		= "Lloc";
$pgv_lang["search_year"]		= "Any";
$pgv_lang["no_results"] 		= "Sense resultats.";
$pgv_lang["search_soundex"]		= "Recerca fonètica";
$pgv_lang["search_replace"]		= "Cerca i substitueix";
$pgv_lang["search_sources"]		= "Fonts";
$pgv_lang["search_shared_notes"]	= "Notes compartides";
$pgv_lang["search_more_chars"]  	= "Cal que entreu més d'un caràcter";
$pgv_lang["search_soundextype"]	= "Tipus de recerca fonètica:";
$pgv_lang["search_russell"]		= "Senzill";
$pgv_lang["search_tagfilter"]		= "Filtre d'exclusió";
$pgv_lang["search_tagfon"]		= "Exclou dades no genealògiques";
$pgv_lang["search_tagfoff"]		= "Desactivat";
$pgv_lang["associate"]			= "associat";
$pgv_lang["search_record"]		= "Registre sencer";
$pgv_lang["search_to"]			= "a";

//-- SOURCELIST FILE MESSAGES
$pgv_lang["titles_found"]		= "Títols";
$pgv_lang["find_source"]		= "Cerca font";

//-- REPOLIST FILE MESSAGES
$pgv_lang["repository"] 			= "Arxiu";
$pgv_lang["repos_found"]		= "Arxius localitzats";
$pgv_lang["find_repository"]		= "Cerca arxius";
$pgv_lang["total_repositories"]	= "Total arxius";
$pgv_lang["confirm_delete_repo"]	= "Segur que voleu suprimir aquest arxiu de la base de dades?";

//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]		= "Informació de la Font";
$pgv_lang["people"] 			= "Persones";
$pgv_lang["families"]			= "Famílies";
$pgv_lang["total_sources"]		= "Total Fonts";

//-- SHARED NOTE FILE MESSAGES
$pgv_lang["shared_note"]				= "Nota compartida";
$pgv_lang["shared_notes_found"]			= "Notes compartides localitzades";
$pgv_lang["find_shared_note"]			= "Cerca una nota compartida";
$pgv_lang["shared_note_info"]			= "Informació de la nota compartida";
$pgv_lang["total_shared_notes"]			= "Total notes compartides";

//-- BUILDINDEX FILE MESSAGES
$pgv_lang["invalid_gedformat"]	= "Format GEDCOM invàlid";
$pgv_lang["exec_time"]			= "Temps d'execució:";
$pgv_lang["changes_present"]		= "Aquest GEDCOM té modificacions pendents de revisar. Si continueu amb la importació, aquestes modificacions seran incorporades a la base de dades immediatament. Cal que reviseu  aquestes modificacions abans de continuar la Importació.";
$pgv_lang["sec"]				= "seg.";

//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$pgv_lang["total_fams"] 		= "Total famílies";
$pgv_lang["total_indis"]		= "Total Persones";
$pgv_lang["notes"]			= "Notes";
$pgv_lang["ssourcess"]			= "Fonts";
$pgv_lang["media"]			= "Multimèdia";
$pgv_lang["name_contains"]		= "El Nom conté:";
$pgv_lang["filter"] 			= "Filtra";
$pgv_lang["apply_filter"]			= "Aplica el filtre";
$pgv_lang["find_individual"]		= "Cerca la Persona";
$pgv_lang["find_familyid"]		= "Cerca la Família";
$pgv_lang["find_sourceid"]		= "Cerca la Font";
$pgv_lang["find_specialchar"]		= "Cerca caràcters especials";
$pgv_lang["magnify"]			= "Augmenta";
$pgv_lang["skip_surnames"]		= "Salta't el llistat de cognoms";
$pgv_lang["show_surnames"]		= "Mostra el llistat de cognoms";
$pgv_lang["skip_marnms"]			= "Exclou els noms de casada";
$pgv_lang["show_marnms"]			= "Inclou els noms de casada";
$pgv_lang["all"]				= "TOT";
$pgv_lang["hidden"]			= "Ocults";
$pgv_lang["confidential"]		= "Confidencial";
$pgv_lang["alpha_index"]		= "Índex alfabètic";
$pgv_lang["name_list"] 			= "Llistat de Noms";
$pgv_lang["firstname_alpha_index"] 	= "Índex alfabètic de Noms de Pila";
$pgv_lang["roots"]		 	= "Arrels";
$pgv_lang["leaves"] 			= "Fulles";
$pgv_lang["widow"] 			= "Vídua";
$pgv_lang["widower"] 			= "Vidu";
$pgv_lang["show_parents"] 			= "Mostra els pares";

//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]				= "Edat";
$pgv_lang["husb_age"]				= "Edat del marit";
$pgv_lang["wife_age"]				= "Edat de la muller";
$pgv_lang["year1"]			= "any";
$pgv_lang["years2"]					= "years";	// 2 anys";
$pgv_lang["years"]			= "anys";
$pgv_lang["month1"]			= "mes";
$pgv_lang["months"]			= "mesos";
$pgv_lang["week1"]					= "setmana";
$pgv_lang["weeks"]					= "setmanes";
$pgv_lang["day1"]				= "dia";
$pgv_lang["days"]				= "dies";
$pgv_lang["after_death"]		="desprès de mort";
$pgv_lang["at_death_day"]  			= "el dia de la defunció";
$pgv_lang["timeline_title"] 		= "Escala cronològica PhpGedView";
$pgv_lang["timeline_chart"] 		= "Escala cronològica";
$pgv_lang["remove_person"]		= "Treu aquesta persona";
$pgv_lang["show_age"]			= "Mostra l'indicador d'edats";
$pgv_lang["add_another"]		= "Afegeix una altra persona al gràfic";
$pgv_lang["find_id"]			= "Cerca la Persona";
$pgv_lang["show"]				= "Mostra";
$pgv_lang["year"]				= "Any:";
$pgv_lang["zoom_in"]			= "Eixampla";
$pgv_lang["zoom_out"]			= "Redueix";
$pgv_lang["timeline_beginYear"] 	= "Començant l'any";
$pgv_lang["timeline_endYear"] 	= "Acabant l'any";
$pgv_lang["timeline_scrollSpeed"] 	= "Velocitat";
$pgv_lang["timeline_controls"] 	= "Controls de longevitat";
$pgv_lang["include_family"] 		= "Inclou-hi familiars directes";
$pgv_lang["lifespan_chart"] 		= "Longevitat";
$pgv_lang["serverTime"]				= "Hora del servidor";
$pgv_lang["localTime"]				= "Hora local";

// calendar conversion options
$pgv_lang["cal_none"] 				= "Sense conversió de calendari";
$pgv_lang["cal_gregorian"]			= "Gregorià";
$pgv_lang["cal_julian"]   			= "Julià";
$pgv_lang["cal_french"]   			= "Francès";
$pgv_lang["cal_jewish"]   			= "Jueu";
$pgv_lang["cal_hebrew"]   			= "Hebreu";
$pgv_lang["cal_jewish_and_gregorian"] = "Jueu i Gregorià";
$pgv_lang["cal_hebrew_and_gregorian"] = "Hebreu i Gregorià";
$pgv_lang["cal_hijri"]				= "Islàmic";
$pgv_lang["cal_arabic"]   			= "Aràbic";

// some religious dates
$pgv_lang["easter"] 	= "Pasqua de Resurrecció";
$pgv_lang["ascension"]  = "L’Ascensió";
$pgv_lang["pentecost"]  = "Pentecosta";
$pgv_lang["assumption"] = "L’Assumpció";
$pgv_lang["all_saints"] = "Tots Sants";
$pgv_lang["christmas"]  = "Nadal";

// am/pm suffixes for 12 hour clocks
$pgv_lang["a.m."] 		= "am";
$pgv_lang["p.m."] 		= "pm";
$pgv_lang["noon"] 		= "m";
$pgv_lang["midn"] 		= "mn";

//-- MONTH NAMES
$pgv_lang["jan"]				= "Gener";
$pgv_lang["feb"]				= "Febrer";
$pgv_lang["mar"]				= "Març";
$pgv_lang["apr"]				= "Abril";
$pgv_lang["may"]				= "Maig";
$pgv_lang["jun"]				= "Juny";
$pgv_lang["jul"]				= "Juliol";
$pgv_lang["aug"]				= "Agost";
$pgv_lang["sep"]				= "Setembre";
$pgv_lang["oct"]				= "Octubre";
$pgv_lang["nov"]				= "Novembre";
$pgv_lang["dec"]				= "Desembre";

// $pgv_lang["vend"]			use value from lang.en.php
// $pgv_lang["brum"]			use value from lang.en.php
// $pgv_lang["frim"]			use value from lang.en.php
// $pgv_lang["nivo"]			use value from lang.en.php
// $pgv_lang["pluv"]			use value from lang.en.php
// $pgv_lang["vent"]			use value from lang.en.php
// $pgv_lang["germ"]			use value from lang.en.php
// $pgv_lang["flor"]			use value from lang.en.php
// $pgv_lang["prai"]			use value from lang.en.php
// $pgv_lang["mess"]			use value from lang.en.php
// $pgv_lang["ther"]			use value from lang.en.php
// $pgv_lang["fruc"]			use value from lang.en.php
// $pgv_lang["comp"]			use value from lang.en.php

// $pgv_lang["tsh"]				use value from lang.en.php
// $pgv_lang["csh"]				use value from lang.en.php
// $pgv_lang["ksl"]				use value from lang.en.php
// $pgv_lang["tvt"]				use value from lang.en.php
// $pgv_lang["shv"]				use value from lang.en.php
// $pgv_lang["adr"]				use value from lang.en.php
// $pgv_lang["adr_leap_year"]	use value from lang.en.php
// $pgv_lang["ads"]				use value from lang.en.php
// $pgv_lang["nsn"]				use value from lang.en.php
// $pgv_lang["iyr"]				use value from lang.en.php
// $pgv_lang["svn"]				use value from lang.en.php
// $pgv_lang["tmz"]				use value from lang.en.php
// $pgv_lang["aav"]				use value from lang.en.php
// $pgv_lang["ell"]				use value from lang.en.php

// $pgv_lang["muhar"]			use value from lang.en.php
// $pgv_lang["safar"]			use value from lang.en.php
// $pgv_lang["rabia"]			use value from lang.en.php
// $pgv_lang["rabit"]			use value from lang.en.php
// $pgv_lang["jumaa"]			use value from lang.en.php
// $pgv_lang["jumat"]			use value from lang.en.php
// $pgv_lang["rajab"]			use value from lang.en.php
// $pgv_lang["shaab"]			use value from lang.en.php
// $pgv_lang["ramad"]			use value from lang.en.php
// $pgv_lang["shaww"]			use value from lang.en.php
// $pgv_lang["dhuaq"]			use value from lang.en.php
// $pgv_lang["dhuah"]			use value from lang.en.php

$pgv_lang["b.c."] 		= "A.C.";

$pgv_lang["abt"]				= "cap el";
$pgv_lang["aft"]				= "desprès de";
$pgv_lang["and"]				= "i";
$pgv_lang["bef"]				= "abans de";
$pgv_lang["bet"]				= "entre";
$pgv_lang["cal"]				= "calculada";
$pgv_lang["est"]				= "estimada";
$pgv_lang["from"]				= "des de";
$pgv_lang["int"]				= "interpretada";
$pgv_lang["to"]					= "a";
$pgv_lang["cir"]				= "circa";
$pgv_lang["apx"]				= "aprox.";

//-- Admin File Messages
$pgv_lang["email_invalid"]		= "Adressa de correu invàlida.";
$pgv_lang["password_mismatch"]	= "Les contrasenyes no coincideixen.";
$pgv_lang["enter_username"] 	= "Us cal posar un nom d'usuari.";
$pgv_lang["enter_password"] 	= "Us cal posar una contrasenya.";
$pgv_lang["save"]				= "Desa";
$pgv_lang["saveandgo"]			= "Desa i ves al nou registre";
$pgv_lang["delete"] 			= "Elimina";
$pgv_lang["edit"]				= "Edita";
$pgv_lang["no_login"]			= "No s'ha pogut validar l'usuari.";
$pgv_lang["basic_realm"]		= "Sistema de validació PhpGedView";
$pgv_lang["basic_auth_failure"]	= "Cal que entreu un nom d'usuari vàlid i la contrasenya per accedir a aquest recurs";
$pgv_lang["basic_auth"]			= "Autenticació bàsica";
$pgv_lang["digest_auth"]		= "Autenticació abreujada";
$pgv_lang["no_auth_needed"]		= "Sense autenticació";
$pgv_lang["file_not_exists"]	= "Fitxer inexistent.";
$pgv_lang["research_assistant"]	= "Assistent de recerca";
$pgv_lang["utf8_to_ansi"]		= "Converteix d'UTF-8 a ANSI (ISO 8859-1)";
$pgv_lang["media_linked"]		= "Aquest objecte multimèdia està vinculat amb el següent:";
$pgv_lang["media_not_linked"]		= "Aquest objecte multimèdia no està vinculat amb cap registre del GEDCOM.";
$pgv_lang["media_dir_1"]			= "Aquest objecte multimèdia és a un servidor extern";
$pgv_lang["media_dir_2"]			= "L'objecte multimèdia és al directori multimèdia estàndard";
$pgv_lang["media_dir_3"]			= "Aquest objecte multimèdia és al directori multimèdia protegit ";
$pgv_lang["thumb_dir_1"]			= "Aquesta imatge en miniatura és a un servidor extern";
$pgv_lang["thumb_dir_2"]			= "Aquesta imatge en miniatura és al directori multimèdia estàndard";
$pgv_lang["thumb_dir_3"]			= "Aquesta imatge en miniatura és al directori multimèdia protegit";
$pgv_lang["moveto_2"]				= "Mou-lo al directori protegit";
$pgv_lang["moveto_3"]				= "Mou-la al directori estàndard";
$pgv_lang["move_standard"]			= "Mou-la a l'estàndard";
$pgv_lang["move_protected"]			= "Mou-la al protegit";
$pgv_lang["move_mediadirs"]			= "Mou els directoris multimèdia";
$pgv_lang["setperms"]				= "Ajusteu permisos multimèdia";
$pgv_lang["setperms_fix"]			= "Esmena els permisos de lectura/escriptura/execució";
$pgv_lang["setperms_success"]		= "S'han ajustat els permisos";
$pgv_lang["setperms_failure"]		= "No s'han ajustat els permisos";
$pgv_lang["setperms_time_exceeded"]	= "S'ha superat el límit de temps d'execució. Torneu-ho a provar en un directori més petit.";
$pgv_lang["move_time_exceeded"]		= "S'ha superat el límit de temps d'execució. Torneu-hi per moure la resta de fitxers.";
$pgv_lang["media_firewall_rootdir_no_exist"]			= "No hi ha el directori arrel Tallafoc Multimèdia que heu demanat. Us cal crear-lo prèviament.";
$pgv_lang["media_firewall_protected_dir_no_exist"]		= "No heu creat el directori multimèdia protegit al directori arrel Tallafoc Multimèdia. Feu-ho i definiu-lo com obert a l'escriptura.";
$pgv_lang["media_firewall_protected_dir_not_writable"]	= "El directori multimèdia protegit al directori arrel Tallafoc Multimèdia no té permisos d'escriptura.";
$pgv_lang["media_firewall_invalid_dir"]	= "Error: el Tallafoc Multimèdia s'ha cridat des d'un directori diferent al multimèdia.";

//-- Relationship chart messages
$pgv_lang["view_fam_nav_details"]	= "Mostra els detalls de...";
$pgv_lang["view_fam_nav_notes"]		= "Veure Notes de ...";
$pgv_lang["view_fam_nav_sources"]	= "Veure Fonts de ...";
$pgv_lang["view_fam_nav_media"]		= "Veure multimèdia de ...";
$pgv_lang["view_fam_nav_album"]		= "Veure àlbum de ...";
$pgv_lang["view_fam_nav_relatives"]	= "Veure parents de ...";
$pgv_lang["view_fam_nav_tree"]		= "Veure l'arbre de ...";
$pgv_lang["view_fam_nav_research"]	= "Veure Recerca per ...";
$pgv_lang["view_fam_nav_map"]		= "Veure Mapa de ...";
$pgv_lang["view_fam_nav_spare"]		= "Veure la informació emmagatzemada de ...";
$pgv_lang["navigator"]				= "Navegador";
$pgv_lang["fam_navigator"]			= "Navegador de famílies";

$pgv_lang["relationship_great"]	= "Gran";
$pgv_lang["relationship_chart"] 	= "Diagrama de parentiu";
$pgv_lang["person1"]			= "Persona 1";
$pgv_lang["person2"]			= "Persona 2";
$pgv_lang["no_link_found"]		= "No s'ha pogut trobar cap altre vincle entre ambdues persones.";
$pgv_lang["no_other_link_found"]	= "No es pot localitzar cap altre vincle entre les dues persones.";
$pgv_lang["sibling"]			= "Germà";
$pgv_lang["follow_spouse"]		= "Cerca vincles polítics.";
$pgv_lang["timeout_error"]		= "Temps d'script esgotat abans de trobar vincles.";
$pgv_lang["grandchild"]			= "Nét/a";
$pgv_lang["grandson"]			= "Nét";
$pgv_lang["granddaughter"]		= "Néta";
$pgv_lang["greatgrandchild"]		= "Besnét/a";
$pgv_lang["greatgrandson"]			= "Besnét";
$pgv_lang["greatgranddaughter"]		= "Besnéta";
$pgv_lang["brother"]			= "Germà";
$pgv_lang["sister"] 			= "Germana";
$pgv_lang["aunt"]				= "Tieta";
$pgv_lang["uncle"]				= "Oncle";
$pgv_lang["niece"]				= "Neboda";
$pgv_lang["nephew"]				= "Nebot";
$pgv_lang["firstcousin"]		= "Cosí/na germà/na";
$pgv_lang["femalecousin"]		= "Cosina";
$pgv_lang["malecousin"]			= "Cosí";
$pgv_lang["relationship_to_me"] 	= "Vincles amb mi";
$pgv_lang["rela_husb"]			= "Vincles amb el marit";
$pgv_lang["rela_wife"]			= "Vincles amb la muller";
$pgv_lang["next_path"]			= "Troba el següent vincle";
$pgv_lang["show_path"]			= "Mostra els vincles";
$pgv_lang["line_up_generations"]	= "Alinea generacions";
$pgv_lang["oldest_top"] 			= "Els més grans primer";

// %1\$s replaced by first person, %2\$s by the relationship and %3\$s by the second person.
$pgv_lang["relationship_male_1_is_the_2_of_3"] 		= "%1\$s és %2\$s de %3\$s.";
$pgv_lang["relationship_female_1_is_the_2_of_3"] 	= "%1\$s és %2\$s de %3\$s.";

$pgv_lang["mother_in_law"]		= "sogra";
$pgv_lang["father_in_law"]		= "sogre";
$pgv_lang["brother_in_law"]		= "cunyat";
$pgv_lang["sister_in_law"]		= "cunyada";
$pgv_lang["brothers_wife"]		= "cunyada"; // brother's wife
$pgv_lang["son_in_law"]			= "gendre";
$pgv_lang["daughter_in_law"]	= "nora";
$pgv_lang["uncle_in_law"]			= "Oncle polític";
$pgv_lang["aunt_in_law"]			= "Tieta política";
$pgv_lang["cousin_in_law"]		= "Cosí/na polític/a";
$pgv_lang["m_cousin_in_law"]	= "Cosí polític";
$pgv_lang["f_cousin_in_law"]	= "Cosina política";
$pgv_lang["step_son"]			= "fillastre";
$pgv_lang["step_daughter"]	  	= "fillastra";

// the bosa_brothers_offspring name is used for fraternal nephews and nieces - the names below can be extended to any number
// of generations just by adding more translations.
// 1st generation
$pgv_lang["bosa_brothers_offspring_2"] 	= "nebot";
$pgv_lang["bosa_brothers_offspring_3"] 	= "neboda";
// 2nd generation
$pgv_lang["bosa_brothers_offspring_4"] 	= "besnebot";
$pgv_lang["bosa_brothers_offspring_5"] 	= "besneboda";
$pgv_lang["bosa_brothers_offspring_6"] 	= "besnebot";
$pgv_lang["bosa_brothers_offspring_7"] 	= "besneboda";
// for the general case of offspring of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_brothers_son"]	  		= "besnebot %2\$dè";
$pgv_lang["n_x_brothers_daughter"] 		= "besneboda %2\$dena";
// the bosa_sisters_offspring name is used for sisters nephews and nieces - the names below can be extended to any number
// of generations just by adding more translations.
// 1st generation
$pgv_lang["bosa_sisters_offspring_2"] 	= "nebot";
$pgv_lang["bosa_sisters_offspring_3"] 	= "neboda";
// 2nd generation
$pgv_lang["bosa_sisters_offspring_4"] 	= "besnebot";
$pgv_lang["bosa_sisters_offspring_5"] 	= "besneboda";
$pgv_lang["bosa_sisters_offspring_6"] 	= "besnebot";
$pgv_lang["bosa_sisters_offspring_7"] 	= "besneboda";
// for the general case of offspring of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_sisters_son"]	  		= "besnebot %2\$dè";
$pgv_lang["n_x_sisters_daughter"] 		= "besneboda %2\$dena";

// the bosa name is used for offspring - the names below can be extended to any number
// of generations just by adding more translations.
// 1st generation
$pgv_lang["bosa_2"] 				= "fill";
$pgv_lang["bosa_3"] 				= "filla";
// 2nd generation
$pgv_lang["bosa_4"] 				= "nét";
$pgv_lang["bosa_5"] 				= "néta";
$pgv_lang["bosa_6"] 				= "nét";
$pgv_lang["bosa_7"] 				= "néta";
// 3rd generation
$pgv_lang["bosa_8"] 			= "besnét";
$pgv_lang["bosa_9"] 			= "besnéta";
$pgv_lang["bosa_10"] 			= "besnét";
$pgv_lang["bosa_11"] 			= "besnéta";
$pgv_lang["bosa_12"] 			= "besnét";
$pgv_lang["bosa_13"] 			= "besnéta";
$pgv_lang["bosa_14"] 			= "besnét";
$pgv_lang["bosa_15"] 			= "besnéta";
// for the general case of offspring of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_grandson_from_son"]	  			= "nét %2\$dè";
$pgv_lang["n_x_granddaughter_from_son"] 		= "néta %2\$dena";
$pgv_lang["n_x_grandson_from_daughter"]	  		= "nét %2\$dè";
$pgv_lang["n_x_granddaughter_from_daughter"] 	= "néta %2\$dena";

// the sosa_uncle name is used for uncles - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and uncles
// 1st generation
$pgv_lang["sosa_uncle_2"] 		= "oncle";
$pgv_lang["sosa_uncle_3"] 		= "oncle";
// 2nd generation
$pgv_lang["sosa_uncle_4"] 		= "besoncle";
$pgv_lang["sosa_uncle_5"] 		= "besoncle";
$pgv_lang["sosa_uncle_6"] 		= "besoncle";
$pgv_lang["sosa_uncle_7"] 		= "besoncle";
// for the general case of uncles of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_uncle"]			= "oncle %1\$dè";
$pgv_lang["n_x_maternal_uncle"]			= "oncle %1\$dè";

// the sosa_aunt name is used for aunts - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and aunts
// 1st generation
$pgv_lang["sosa_aunt_2"] 		= "oncle";
$pgv_lang["sosa_aunt_3"] 		= "oncle";
// 2nd generation
$pgv_lang["sosa_aunt_4"] 		= "bestia";
$pgv_lang["sosa_aunt_5"] 		= "bestia";
$pgv_lang["sosa_aunt_6"] 		= "bestia";
$pgv_lang["sosa_aunt_7"] 		= "bestia";
// for the general case of aunts of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_aunt"]		= "tia %1\$dena";
$pgv_lang["n_x_maternal_aunt"]		= "tia %2\$dena";

// the sosa_uncle name is used for uncles(by marriage) - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and uncles
// 1st generation
$pgv_lang["sosa_uncle_bm_2"] 	= "oncle";
$pgv_lang["sosa_uncle_bm_3"] 	= "oncle";
// 2nd generation
$pgv_lang["sosa_uncle_bm_4"] 	= "besoncle";
$pgv_lang["sosa_uncle_bm_5"] 	= "besoncle";
$pgv_lang["sosa_uncle_bm_6"] 	= "besoncle";
$pgv_lang["sosa_uncle_bm_7"] 	= "besoncle";
// for the general case of uncles of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_uncle_bm"]		= "oncle %1\$dè";
$pgv_lang["n_x_maternal_uncle_bm"]		= "oncle %1\$dè";

// the sosa_aunt name is used for aunts (by marriage)- the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and aunts
// 1st generation
$pgv_lang["sosa_aunt_bm_2"] 	= "oncle";
$pgv_lang["sosa_aunt_bm_3"] 	= "oncle";
// 2nd generation
$pgv_lang["sosa_aunt_bm_4"] 	= "bestia";
$pgv_lang["sosa_aunt_bm_5"] 	= "bestia";
$pgv_lang["sosa_aunt_bm_6"] 	= "bestia";
$pgv_lang["sosa_aunt_bm_7"] 	= "bestia";
// for the general case of aunts of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_aunt_bm"]	= "tia %2\$dena";
$pgv_lang["n_x_maternal_aunt_bm"]	= "tia %2\$dena";

// if a specific cousin relationship cannot be represented in a language translate as "";
$pgv_lang["male_cousin_1"]  		= "cosí germà";
$pgv_lang["male_cousin_2"]  		= "cosí segon";
$pgv_lang["male_cousin_3"]  		= "cosí tercer";
$pgv_lang["male_cousin_4"]  		= "cosí quart";
$pgv_lang["male_cousin_5"]  		= "cosí 5è";
$pgv_lang["male_cousin_6"]  		= "cosí 6è";
$pgv_lang["male_cousin_7"]  		= "cosí 7è";
$pgv_lang["male_cousin_8"]  		= "cosí 8è";
$pgv_lang["male_cousin_9"]  		= "cosí 9è";
$pgv_lang["male_cousin_10"] 		= "cosí 10è";
$pgv_lang["male_cousin_11"] 		= "cosí 11è";
$pgv_lang["male_cousin_12"] 		= "cosí 12è";
$pgv_lang["male_cousin_13"] 		= "cosí 13è";
$pgv_lang["male_cousin_14"] 		= "cosí 14è";
$pgv_lang["male_cousin_15"] 		= "cosí 15è";
$pgv_lang["male_cousin_16"] 		= "cosí 16è";
$pgv_lang["male_cousin_17"] 		= "cosí 17è";
$pgv_lang["male_cousin_18"] 		= "cosí 18è";
$pgv_lang["male_cousin_19"] 		= "cosí 19è";
$pgv_lang["male_cousin_20"] 		= "cosí 20è";
$pgv_lang["male_cousin_n"]  		= "cosí %dè";
$pgv_lang["female_cousin_1"]		= "cosina germana";
$pgv_lang["female_cousin_2"]		= "cosina segona";
$pgv_lang["female_cousin_3"]		= "cosina tercera";
$pgv_lang["female_cousin_4"]		= "cosina quarta";
$pgv_lang["female_cousin_5"]		= "cosina 5ena";
$pgv_lang["female_cousin_6"]		= "cosina 6ena";
$pgv_lang["female_cousin_7"]		= "cosina 7ena";
$pgv_lang["female_cousin_8"]		= "cosina 8ena";
$pgv_lang["female_cousin_9"]		= "cosina 9ena";
$pgv_lang["female_cousin_10"]   	= "cosina 10ena";
$pgv_lang["female_cousin_11"]   	= "cosina 11ena";
$pgv_lang["female_cousin_12"]   	= "cosina 12ena";
$pgv_lang["female_cousin_13"]   	= "cosina 13ena";
$pgv_lang["female_cousin_14"]   	= "cosina 14ena";
$pgv_lang["female_cousin_15"]   	= "cosina 15ena";
$pgv_lang["female_cousin_16"]   	= "cosina 16ena";
$pgv_lang["female_cousin_17"]   	= "cosina 17ena";
$pgv_lang["female_cousin_18"]   	= "cosina 18ena";
$pgv_lang["female_cousin_19"]   	= "cosina 19ena";
$pgv_lang["female_cousin_20"]   	= "cosina 20ena";
$pgv_lang["female_cousin_n"]		= "cosina %dena";

// Only referenced from english specific functions
$pgv_lang["removed_ascending_1"]   	= "";
$pgv_lang["removed_ascending_2"]   	= "";
$pgv_lang["removed_ascending_3"]   	= "";
$pgv_lang["removed_ascending_4"]   	= "";
$pgv_lang["removed_ascending_5"]   	= "";
$pgv_lang["removed_ascending_6"]   	= "";
$pgv_lang["removed_ascending_7"]   	= "";
$pgv_lang["removed_ascending_8"]   	= "";
$pgv_lang["removed_ascending_9"]   	= "";
$pgv_lang["removed_ascending_10"]  	= "";
$pgv_lang["removed_ascending_11"]  	= "";
$pgv_lang["removed_ascending_12"]  	= "";
$pgv_lang["removed_ascending_13"]  	= "";
$pgv_lang["removed_ascending_14"]  	= "";
$pgv_lang["removed_ascending_15"]  	= "";
$pgv_lang["removed_ascending_16"]  	= "";
$pgv_lang["removed_ascending_17"]  	= "";
$pgv_lang["removed_ascending_18"]  	= "";
$pgv_lang["removed_ascending_19"]  	= "";
$pgv_lang["removed_ascending_20"]  	= "";
$pgv_lang["removed_descending_1"]  	= "";
$pgv_lang["removed_descending_2"]  	= "";
$pgv_lang["removed_descending_3"]  	= "";
$pgv_lang["removed_descending_4"]  	= "";
$pgv_lang["removed_descending_5"]  	= "";
$pgv_lang["removed_descending_6"]  	= "";
$pgv_lang["removed_descending_7"]  	= "";
$pgv_lang["removed_descending_8"]  	= "";
$pgv_lang["removed_descending_9"]  	= "";
$pgv_lang["removed_descending_10"] 	= "";
$pgv_lang["removed_descending_11"] 	= "";
$pgv_lang["removed_descending_12"] 	= "";
$pgv_lang["removed_descending_13"] 	= "";
$pgv_lang["removed_descending_14"] 	= "";
$pgv_lang["removed_descending_15"] 	= "";
$pgv_lang["removed_descending_16"] 	= "";
$pgv_lang["removed_descending_17"] 	= "";
$pgv_lang["removed_descending_18"] 	= "";
$pgv_lang["removed_descending_19"] 	= "";
$pgv_lang["removed_descending_20"] 	= "";

//-- GEDCOM edit utility
$pgv_lang["check_delete"]		= "Esteu segur que cal suprimir aquesta dada del Gedcom?";
$pgv_lang["access_denied"]		= "<b>Accés Denegat</b><br />No teniu accés a aquest recurs.";
$pgv_lang["changes_exist"]		= "Aquest GEDCOM ha estat modificat.";
$pgv_lang["find_place"]			= "Cerca un Lloc";
$pgv_lang["close_window"]		= "Tanca la finestra";
$pgv_lang["close_window_without_refresh"] = "Tanca la finestra sense recàrrega";
$pgv_lang["place_contains"]		= "El lloc conté:";
$pgv_lang["add"]					= "Afegeix";
$pgv_lang["custom_event"]   		= "Personalitzat";
$pgv_lang["delete_person"]		= "Suprimeix aquesta persona";
$pgv_lang["confirm_delete_person"]	= "Esteu segur que cal suprimir aquesta persona del fitxer GEDCOM?";
$pgv_lang["find_media"]			= "Cerca multimèdia";
$pgv_lang["set_link"]			= "Enllaça'l";
$pgv_lang["delete_source"]		= "Suprimeix aquesta Font";
$pgv_lang["delete_shared_note"]		= "Elimina la nota compartida";
$pgv_lang["confirm_delete_source"]	= "Esteu segur que cal suprimir aquesta Font del fitxer GEDCOM?";
$pgv_lang["confirm_delete_shared_note"]		= "Segur que voleu eliminar la nota compartida?";
$pgv_lang["find_family"]		= "Cerca la Família";
$pgv_lang["find_fam_list"]		= "Cerca Llistat de Famílies";
$pgv_lang["edit_name"]			= "Edita el Nom";
$pgv_lang["delete_name"]		= "Elimina nom";
$pgv_lang["select_date"]		= "Seleccioneu una data";
$pgv_lang["user_cannot_edit"]		= "Aquest usuari no té permís per editar aquest GEDCOM.";
$pgv_lang["gedcom_editing_disabled"]	= "L'edició d'aquest GEDCOM ha sigut inhabilitada per l'administrador.";
$pgv_lang["privacy_not_granted"]	= "No teniu accés a";
$pgv_lang["privacy_prevented_editing"]	= "Els paràmetres de privadesa no us permeten editar aquest registre.";
$pgv_lang["ged_noshow"]			= "Aquesta pàgina ha estat desactivada per l'administrador del lloc.";

//-- calendar.php messages
$pgv_lang["bdm"]				= "Natalicis, Òbits, Casaments";
$pgv_lang["on_this_day"]			= "En tal dia com avui...";
$pgv_lang["in_this_month"]		= "Aquest mes...";
$pgv_lang["in_this_year"]		= "Enguany...";
$pgv_lang["year_anniversary"]   	= "#year_var# aniversari";
$pgv_lang["year_yahrzeit"]			= "#yahrzeit_date#, #yahrzeit# yahrzeit de #event_date#";
$pgv_lang["today"]			= "Avui";
$pgv_lang["day"]					= "Dia:";
$pgv_lang["month"]			= "Mes:";
$pgv_lang["showcal"]			= "Esdeveniments a mostrar:";
$pgv_lang["anniversary"]		= "Aniversari";
$pgv_lang["anniversary_calendar"] 	= "Calendari d'aniversaris";
$pgv_lang["sunday"]			= "Diumenge";
$pgv_lang["monday"]			= "Dilluns";
$pgv_lang["tuesday"]			= "Dimarts";
$pgv_lang["wednesday"]			= "Dimecres";
$pgv_lang["thursday"]			= "Dijous";
$pgv_lang["friday"]			= "Divendres";
$pgv_lang["saturday"]			= "Dissabte";
$pgv_lang["viewday"]			= "D'un dia";
$pgv_lang["viewmonth"]			= "D'un mes";
$pgv_lang["viewyear"]				= "D'un any";
$pgv_lang["all_people"]			= "Tothom";
$pgv_lang["living_only"]		= "Gent viva";
$pgv_lang["recent_events"]		= "Esdeveniments recents (&lt; 100 anys)";
$pgv_lang["day_not_set"]		= "Dia no localitzat";

//-- user self registration module
$pgv_lang["siteadmin"]			= "Administrador PhpGedView";
$pgv_lang["PGV_program"]		= "Programa PhpGedView";
$pgv_lang["lost_password"]		= "Heu perdut la contrasenya?";
$pgv_lang["requestpassword"]		= "Demana contrasenya";
$pgv_lang["no_account_yet"] 		= "No teniu permís d'accés?";
$pgv_lang["requestaccount"] 		= "Demana permís d'accés";
$pgv_lang["emailadress"]		= "Adreça de correu electrònic";
$pgv_lang["mandatory"] 			= "Els camps senyalats amb * són obligatoris.";
$pgv_lang["mail01_line01"]		= "Hola #user_fullname# ...";
$pgv_lang["mail01_line02"]		= "Heu sol·licitat accés a #PGV_SERVER_NAME##PGV_SCRIPT_PATH#. La vostra adreça de correu electrònic és «#user_email#».";
$pgv_lang["mail01_line03"]		= "A l'enllaç de sota es mostra informació sobre aquesta petició.";
$pgv_lang["mail01_line04"]		= "Polseu a l'enllaç de sota i empleneu els camps que s'hi demanen per a confirmar la vostra comanda i l'adreça de correu electrònic.";
$pgv_lang["mail01_line05"]		= "Si us interessa, simplement esborreu aquest missatge.";
$pgv_lang["mail01_line06"]		= "No rebreu cap altre missatge d'aquest lloc. Si no ho confirmeu en el termini de set dies, el compte serà anul·lat.";
$pgv_lang["mail01_subject"]		= "El vostre registre a #PGV_SERVER_NAME##PGV_SCRIPT_PATH#";

$pgv_lang["mail02_line01"]		= "Hola Administrador ...";
$pgv_lang["mail02_line02"]		= "Un possible nou usuari ha demanat l'alta a #PGV_SERVER_NAME##PGV_SCRIPT_PATH#.";
$pgv_lang["mail02_line03"]		= "L'usuari ha rebut un correu electrònic amb les dades per a confirmar el seu permís.";
$pgv_lang["mail02_line04"]		= "Sereu informat per correu electrònic quan aquest possible usuari s'hagi auto-confirmat.  Llavors caldrà que completeu el procés activant-lo.  El nou usuari no disposarà d'accés mentre no li doneu permís.";
$pgv_lang["mail02_line04a"]		= "Sereu informat per correu electrònic quan aquest possible usuari s'hagi auto-confirmat.  Desprès de la verificació, l'usuari podrà disposarà d'accés sense que us calgui fer res.";
$pgv_lang["mail02_subject"]		= "Nou registre a #PGV_SERVER_NAME##PGV_SCRIPT_PATH#";

$pgv_lang["hashcode"]			= "Codi de Verificació:";
$pgv_lang["thankyou"]			= "Hola #user_fullname# ...<br />Gràcies per enregistrar-vos";
$pgv_lang["pls_note06"] 		= "Ara rebreu un correu electrònic de confirmació a l'adreça <b>#user_email#</b>. Us caldrà confirmar la vostra petició seguint les instruccions del correu electrònic. Si no ho feu, passada una setmana la petició serà automàticament rebutjada i us caldria tornar a demanar-la.<br /><br />Desprès de seguir les instruccions del correu electrònic de confirmació, caldrà que l'administrador autoritzi la comanda abans de poder accedir planament.<br /><br />Per accedir a aquest lloc cal conèixer el nom d'usuari i la contrasenya.";
$pgv_lang["pls_note06a"] 		= "Ara rebreu un correu electrònic de confirmació a l'adreça <b>#user_email#</b>. Us caldrà confirmar la vostra petició seguint les instruccions del correu electrònic. Si no ho feu, passada una setmana la petició ser automàticament rebutjada i us caldria tornar a demanar-la.<br /><br />Desprès de seguir les instruccions del correu electrònic, tindreu lliure accés.  Per a fer-ho cal conèixer el nom d'usuari i la contrasenya";

$pgv_lang["registernew"]		= "Confirmació de permís";
$pgv_lang["user_verify"]		= "Verificació d'usuari";
$pgv_lang["send"]				= "Envia";

$pgv_lang["pls_note07"] 		= "~#pgv_lang[user_verify]#~<br /><br />Per verificar la vostra petició, escriviu el nom d'usuari, la contrasenya i el codi de verificació que heu rebut per correu electrònic.";
$pgv_lang["pls_note08"] 		= "S'han comprovat les dades de l'usuari #user_name#.";

$pgv_lang["mail03_line01"]		= "Hola Administrador ...";
$pgv_lang["mail03_line02"]		= "L'usuari #newuser[username]# (#newuser[fullname]#) ha verificat les seves dades de registre.";
$pgv_lang["mail03_line03"]		= "Polseu l'enllaç de sota per accedir-hi.  Us cal editar l'usuari per activar-lo i que disposi d'accés.";
$pgv_lang["mail03_line03a"]		= "No cal que feus res, ara l'usuari ja disposa de permís d'accés.";
$pgv_lang["mail03_subject"] 		= "Nou usuari a #PGV_SERVER_NAME##PGV_SCRIPT_PATH#";

$pgv_lang["pls_note09"] 		= "Heu confirmat la petició d'enregistrar-vos.";
$pgv_lang["pls_note10"] 		= "Se'n ha informat l'Administrador. Tan aviat com us doni permís per accedir, podreu fer-ho amb el vostre nom d'usuari i contrasenya.";
$pgv_lang["pls_note10a"]		= "Ara podeu accedir amb el vostre nom d'usuari i la contrasenya.";
$pgv_lang["data_incorrect"] 		= "Dades incorrectes, torneu-hi.";
$pgv_lang["user_not_found"] 		= "No és possible verificar la informació que heu entrat.  Torneu-ho a provar o contacteu amb l'Administrador del lloc per a més informació.";

$pgv_lang["lost_pw_reset"]		= "Renoveu la contrasenya perduda";
$pgv_lang["pls_note11"] 		= "Per renovar la contrasenya, entreu el nom d'usuari.<br /><br />Us respondrem enviant un correu electrònic a l'adreça enregistrada al vostre compte.  Aquest correu electrònic contindrà un URL i un codi de confirmació del vostre compte. Quan visiteu la URL, podreu canviar la contrasenya i accedir a aquest lloc. Per qüestions de seguretat no heu de lliurar aquest codi a ningú.<br /><br />Si us cal ajuda de l'administrador, empreu l'enllaç de sota.";

$pgv_lang["mail04_line01"]		= "Hola #user_fullname# ...";
$pgv_lang["mail04_line02"]		= "S'ha demanat una nova contrasenya per al vostre usuari.";
$pgv_lang["mail04_line03"]		= "Recomanació:";
$pgv_lang["mail04_line04"]		= "Polseu a l'enllaç de sota o enganxeu-lo al vostre navegador, entrant amb la nova contrasenya i canvia-la immediatament per mantenir assegurada la integritat de les vostres dades.";
$pgv_lang["mail04_line05"]		= "Un cop dins, seleccioneu l'enllaç «#pgv_lang[editowndata]#» sota el menú «#pgv_lang[mygedview]#» i escriviu al camp corresponent la vostra nova contrasenya.";
$pgv_lang["mail04_subject"] 	= "Nova contrasenya a #PGV_SERVER_NAME##PGV_SCRIPT_PATH#";

$pgv_lang["pwreqinfo"]			= "Hola...<br /><br />S'ha enviat un correu electrònic amb la vostra nova contrasenya a <b>#user[email]#</b>).<br /><br />Reviseu el vostre correu: heu de rebre el nostre missatge aviat.<br /><br />Recomanació:<br />Us caldrà accedir a aquest lloc amb la nova contrasenya tant aviat com us sigui possible i canvia-la per mantenir les vostres dades segures.";

$pgv_lang["myuserdata"]			= "Dades de registre";
$pgv_lang["user_theme"]			= "Presentació escollida";
$pgv_lang["mgv"]				= "MyGedView";
$pgv_lang["mygedview"]			= "Portal MyGedView";
$pgv_lang["passwordlength"]		= "La contrasenya ha de tenir com a mínim 6 caràcters.";
$pgv_lang["welcome_text_auth_mode_1"]	= "<span class='center'><b>Benvingut a aquest lloc web de genealogia</b></span><br />L'accés és permès a qualsevol usuari enregistrat.<br /><br />Si ja disposeu d'autorització, accediu per aquesta pàgina. Si no, podeu demanar-la polsant a l'enllaç apropiat de sota.<br /><br />Un cop verificada la vostra comanda, l'administrador del lloc us activarà el registre.  Rebreu un correu electrònic quan la hagi estat aprovada.";
$pgv_lang["welcome_text_auth_mode_2"]	= "<span class='center'><b>Benvingut a aquest lloc web de genealogia</b></span><br />L'accés és permès solament a usuaris <u>autoritzats</u>.<br /><br />Si ja disposeu d'autorització podeu accedir per aquesta pàgina. Si no, podeu demanar-la polsant a l'enllaç apropiat d'aquí sota.<br /><br />Un cop verificada la vostra informació l'administrador pot autoritzar-ho o no.  Rebreu un correu electrònic quan la comanda hagi estat aprovada.";
$pgv_lang["welcome_text_auth_mode_3"]	= "<span class='center'><b>Benvingut a aquest lloc web de genealogia</b></span><br />L'accés és permès solament a <u>membres de la família</u>.<br /><br />Si ja disposeu d'autorització podeu accedir per aquesta pàgina. Si no, podeu demanar-la polsant a l'enllaç apropiat d'aquí sota.<br /><br />Un cop verificada la vostra informació l'administrador pot autoritzar-ho o no.  Rebreu un correu electrònic quan la comanda hagi estat aprovada.";
$pgv_lang["welcome_text_cust_head"] 	= "<span class='center'><b>Benvingut a aquest lloc web de genealogia</b></span><br />L'accés és limitat a usuaris que disposin de registre i contrasenya.";
$pgv_lang["acceptable_use"]			= "<div class=\"largeError\">Advertiment:</div><div class=\"error\">Emplenant i lliurant aquest formulari, us comprometeu a:<ul><li>protegir la privadesa de la gent viva detallada en aquest lloc</li><li>i, en el requadre inferior, explicar-nos quina relació o parentiu teniu amb les persones que hi apareixen, o fornir-nos informació d'alguna d'elles.</li></ul></div>";


//-- mygedview page
$pgv_lang["upcoming_events"]		= "Propers aniversaris";
$pgv_lang["living_or_all"]		= "Mostrar solament esdeveniments relatius a persones vives?";
$pgv_lang["basic_or_all"]		= "Mostrar solament Naixements, Òbits i Casaments?";
$pgv_lang["style"]			= "Estil de presentació";
$pgv_lang["style1"]			= "Text";
$pgv_lang["style2"]			= "Diagrama";
$pgv_lang["style3"]					= "Núvol d'etiquetes";
$pgv_lang["sort_style"]				= "Estil d'ordenació";
$pgv_lang["by_anniv"]				= "Per aniversari";
$pgv_lang["by_alpha"]				= "Alfabètic";
$pgv_lang["cal_download"]		= "Permetre descarregar el calendari d'esdeveniments?";
$pgv_lang["no_events_living"]		= "No hi ha esdeveniments per persones vives pels propers #pgv_lang[global_num1]# dies.";
$pgv_lang["no_events_living1"]	= "No hi ha esdeveniments per persones vives per demà.";
$pgv_lang["no_events_all"]		= "No hi ha esdeveniments pels propers #pgv_lang[global_num1]# dies.";
$pgv_lang["no_events_all1"]		= "No hi ha esdeveniments per demà.";
$pgv_lang["no_events_privacy"]	= "Hi ha esdeveniments pels propers #pgv_lang[global_num1]# dies, però les restriccions per privadesa no us deixen veure'ls.";
$pgv_lang["no_events_privacy1"]	= "Hi ha esdeveniments per demà, però les restriccions per privadesa no us deixen veure'ls.";
$pgv_lang["more_events_privacy"]	= "Hi ha més esdeveniments pels propers #pgv_lang[global_num1]# dies, però les restriccions per privadesa no us deixen veure'ls.";
$pgv_lang["more_events_privacy1"]	= "Hi ha més esdeveniments per demà però les restriccions per privadesa no us deixen veure'ls.";
$pgv_lang["none_today_living"]	= "No hi ha esdeveniments de persones vives per avui.";
$pgv_lang["none_today_all"]		= "No hi ha esdeveniments per avui.";
$pgv_lang["none_today_privacy"]	= "Hi ha esdeveniments per avui, però les restriccions per privadesa no us deixen veure'ls.";
$pgv_lang["more_today_privacy"]	= "Hi ha més esdeveniments per avui, però les restriccions per privadesa no us deixen veure'ls.";
$pgv_lang["chat"]				= "Xat";
$pgv_lang["users_logged_in"]		= "Visitants";
$pgv_lang["anon_user"]			= "1 usuari anònim";
$pgv_lang["anon_users"]			= "#pgv_lang[global_num1]# usuaris anònims";
$pgv_lang["login_user"]			= "1 usuari amb accés";
$pgv_lang["login_users"]		= "#pgv_lang[global_num1]# usuaris amb accés";
$pgv_lang["no_login_users"]		= "Ni usuaris amb accés ni anònims";
$pgv_lang["message"]			= "Envieu un missatge";
$pgv_lang["my_messages"]		= "Els meus missatges";
$pgv_lang["date_created"]		= "Data de tramesa:";
$pgv_lang["message_from"]		= "Correu electrònic:";
$pgv_lang["message_from_name"]	= "Remitent:";
$pgv_lang["message_to"] 		= "Missatge a:";
$pgv_lang["message_subject"]		= "Títol:";
$pgv_lang["message_body"]		= "Text:";
$pgv_lang["no_to_user"] 		= "No hi ha destinatari. No puc continuar.";
$pgv_lang["provide_email"]		= "Doneu la vostra adreça de correu electrònic perquè puguem respondre-us.  La vostra adreça no serà utilitzada per a res més que per aquest fi.";
$pgv_lang["reply"]			= "Resposta";
$pgv_lang["message_deleted"]		= "Missatge esborrat";
$pgv_lang["message_sent"]		= "Missatge enviat a #TO_USER#";
$pgv_lang["message_failed"]		= "Missatge no s'ha pogut enviar";
$pgv_lang["message_error"]		= "Error PHPMailer: ";
$pgv_lang["message_invalid_from"]	= "L'adreça del remitent no vàlid: &laquo;#email#&raquo;";
$pgv_lang["message_invalid_to"]		= "L'adreça del destinatari no vàlid: &laquo;#email#&raquo;";
$pgv_lang["message_illegal_chars"]	= "Caràcters il·legals a l'adreça &laquo;#email#&raquo;";
$pgv_lang["message_bad_format"]		= "L'adreça &laquo;#email#&raquo; no té el format correcte";
$pgv_lang["message_no_MX"]			= "El domini de l'adreça &laquo;#email#&raquo no existeix o no té un registre MX";
$pgv_lang["reset"]			= "Neteja";
$pgv_lang["site_default"]		= "Per defecte la del lloc";
$pgv_lang["mygedview_desc"] 		= "El vostre portal MyGedView us permet tenir ex-libris de familiars preferits, estar al corrent d'aniversaris i col·laborar amb altres usuaris.";
$pgv_lang["no_messages"]		= "No hi ha correu pendent.";
$pgv_lang["clicking_ok"]		= "Quan polseu SI, s'obrirà una nova finestra i podreu contactar amb #user[fullname]#";
$pgv_lang["favorites"]			= "Favorits";
$pgv_lang["my_favorites"]		= "Els meus favorits";
$pgv_lang["no_favorites"]		= "No teniu favorits seleccionats.<br /><br />Per afegir una persona, una família o una font als vostres favorits, polseu a l'enllaç <b>#pgv_lang[add_favorite]#</b> i apareixerà un camp on hi podeu entrar o cercar números d'ID. Per comptes de números d'ID també podeu entrar una adreces URL amb el seu títol.";
$pgv_lang["add_to_my_favorites"]	= "Afegeix-ho als meus favorits";
$pgv_lang["gedcom_favorites"]		= "Favorits d'aquest GEDCOM";
$pgv_lang["no_gedcom_favorites"]	= "No hi ha persones seleccionades a Favorits. L'Administrador pot afegir-ne per veure-les al començament.";
$pgv_lang["confirm_fav_remove"]	= "Esteu segur que cal eliminar aquesta entrada dels vostres Favorits?";
$pgv_lang["invalid_email"]		= "Entreu una adreça de correu electrònic vàlida.";
$pgv_lang["enter_subject"]		= "Entreu el títol del missatge.";
$pgv_lang["enter_body"]			= "Entreu quelcom de text abans d'enviar-ho.";
$pgv_lang["confirm_message_delete"]	= "Esteu segur que cal suprimir aquest missatge?  No hi ha marxa enrere.";
$pgv_lang["message_email1"]		= "Missatge enviat al vostre compte d'usuari PhpGedView per part de ";
$pgv_lang["message_email2"]		= "Missatge enviat al compte d'Usuari PhpGedView:";
$pgv_lang["message_email3"]		= "Missatge enviat a l'Administrador PhpGedView:";
$pgv_lang["viewing_url"]		= "Missatge redactat des d'aquesta pàgina: ";
$pgv_lang["random_picture"]		= "Fitxer a l'atzar";
$pgv_lang["message_instructions"]	= "<b>Atenció!</b> La informació privada de persones vives solament pot lliurar-se a familiars i amics.  Sereu interrogat sobre els vostres vincles de parentiu abans de rebre dades privades.  Algunes informacions sobre persones difuntes també poden resultat privades.  En aquest cas, és degut a que no hi ha informació coneguda d'aquesta persona per a determinar si és o no viva i probablement no tenim cap altra informació sobre ella.<br /><br />Abans de fer la consulta, verifiqueu que esteu demanant per la persona correcta comprovant dates, llocs i parents.  Si feu canvis a les dades genealògiques, inclogueu les fonts d'on les heu tretes.";
$pgv_lang["sending_to"]			= "Aquest missatge s'enviarà a #TO_USER#";
$pgv_lang["preferred_lang"]	 	= "Aquest usuari prefereix rebrer el correu en #USERLANG#";
$pgv_lang["gedcom_created_using"]	= "Fitxer GEDCOM generat amb <b>#CREATED_SOFTWARE# #CREATED_VERSION#</b>";
$pgv_lang["gedcom_created_on"]	= "Creat el <b>#CREATED_DATE#</b>";
$pgv_lang["gedcom_created_on2"] 	= " el <b>#CREATED_DATE#</b>";
$pgv_lang["gedcom_stats"]		= "Estadístiques GEDCOM";
$pgv_lang["stat_individuals"]		= "Persones";
$pgv_lang["stat_families"]		= "Famílies";
$pgv_lang["stat_sources"]		= "Fonts";
$pgv_lang["stat_other"]			= "Registres Diversos";
$pgv_lang["stat_earliest_birth"] 	= "Natalici més antic";
$pgv_lang["stat_latest_birth"] 	= "Natalici més antic";
$pgv_lang["stat_earliest_death"] 	= "Defunció més antiga";
$pgv_lang["stat_latest_death"] 	= "Defunció més recent";
$pgv_lang["customize_page"]		= "Personalitzeu el Portal MyGedView";
$pgv_lang["customize_gedcom_page"]	= "Personalitzeu la Pàgina d'Inici";
$pgv_lang["upcoming_events_block"]	= "Propers aniversaris";
$pgv_lang["upcoming_events_descr"]	= "El bloc «Propers aniversaris» mostra esdeveniments que es commemoraran properament. Podeu configurar el nivells de detalls que us interessa veure-hi i l'administrador el marge de dies.";
$pgv_lang["todays_events_block"]	= "En tal dia";
$pgv_lang["todays_events_descr"]	= "El bloc «En tal dia» mostra esdeveniments que commemorem avui. Podeu configurar el nivell de detall que us interessa veure-hi.";
$pgv_lang["todo_block"] = "Tasques «pendents»";
$pgv_lang["todo_descr"] = "El bloc «tasques pendents» és un llistat de tots els esdeveniments pendents _TODO a la base de dades.";
$pgv_lang["todo_show_other"] 	= "Mostra tasques d'altres usuaris";
$pgv_lang["todo_show_unassigned"]= "Mostra tasques d'assignar";
$pgv_lang["todo_show_future"]	= "Mostra tasques futures";
$pgv_lang["todo_nothing"]		= "No hi han «tasques pendents»";
$pgv_lang["yahrzeit_block"]			= "Yahrzeiten";
$pgv_lang["yahrzeit_descr"]			= "El bloc «Yahrzeiten» mostra els aniversaris de defunció a commemorar properament. Podeu configurar els període a veure's i l'administrador el marge màxim de dies.";
$pgv_lang["logged_in_users_block"]		= "Visitants";
$pgv_lang["logged_in_users_descr"]		= "El bloc «Visitants» mostra un llistat en temps real dels usuaris que estan visitant el lloc web.";
$pgv_lang["user_messages_block"]		= "Bústia";
$pgv_lang["user_messages_descr"]		= "El bloc «Bústia» mostra una llista dels missatges que han sigut enviats a l'usuari actiu.";
$pgv_lang["user_favorites_block"]		= "Favorits";
$pgv_lang["user_favorites_descr"]		= "El bloc «Favorits» mostra una llista amb les persones de la base de dades, senyalades com a favorites per l'usuari, a fi de poder-hi accedir fàcilment.";
$pgv_lang["welcome_block"]			= "Pàgina d'inici";
$pgv_lang["welcome_descr"]			= "El bloc «Pàgina d'inici» mostra l'hora i data actuals, enllaços per a modificar el registre o per accedir a l'arbre genealògic i per personalitzar la pàgina MyGedView.";
$pgv_lang["random_media_block"] 		= "A l'atzar";
$pgv_lang["random_media_descr"]		= "El bloc «A l'atzar» selecciona i mostra aleatòriament una foto o un altre fitxer de la base de dades activa.<br /><br />L'administrador determina si el bloc mostra fitxers associats a persones o a esdeveniments.";
$pgv_lang["random_media_persons_or_all"]	= "Mostrar solament persones, esdeveniments o tot?";
$pgv_lang["random_media_persons"]		= "Persones";
$pgv_lang["random_media_events"]		= "Esdeveniments";
$pgv_lang["gedcom_block"]			= "Inici a GEDCOM";
$pgv_lang["gedcom_descr"]			= "El bloc «Inici a GEDCOM» treballa de forma semblant al d'Inici d'Usuari. Dóna la benvinguda al lloc, mostra el nom de la base de dades activa i l'hora i data actuals.";
$pgv_lang["gedcom_favorites_block"] 	= "Favorits del GEDCOM";
$pgv_lang["gedcom_favorites_descr"]		= "El bloc «Favorits del GEDCOM» permet a l'Administrador la possibilitat de seleccionar persones de la base de dades perquè la seva informació sigui fàcilment accessible a tothom. Aquesta és una forma de ressaltar aquelles persones rellevants en la història de la família.";
$pgv_lang["gedcom_stats_block"] 		= "Estadístiques GEDCOM";
$pgv_lang["gedcom_stats_descr"]		= "El bloc «Estadístiques GEDCOM» mostra al visitant informació bàsica sobre el fitxer GEDCOM com per exemple com i quan s'ha generat i el nombre de persones que conté.<br /><br />Disposa també d'una llista dels cognoms més habituals. Podeu configurar-lo per a que no us els mostri o treure'n i posar-n'hi. També podeu fixar-hi el llindars.";
$pgv_lang["gedcom_stats_show_surnames"]	= "Mostrar els cognoms més comuns?";
$pgv_lang["portal_config_instructions"]	= "~#pgv_lang[customize_page]#~<br />~#pgv_lang[customize_gedcom_page]#~<br /><br />Aquí podeu personalitzar la pàgina situant els blocs de la forma que vulgueu.<br /><br />La pàgina es divideix en dues seccions <b>Principal</b> i <b>Dreta</b>. La secció <b>Principal</b> apareix allargassada i sota el títol de pàgina.  La secció <b>Dreta</b> comença a la dreta del títol i baixa per la banda dreta de la pàgina.<br /><br />Cada secció té el seu propi llistat de blocs que es mostrarà a la pàgina en l'ordre que hi hagi al llistat. Podeu afegir, treure i reordenar els blocs com us plagui.<br /><br />Quan un dels blocs es buit, la resta de blocs es desplaça prenent tot l'ample de la pàgina.";
$pgv_lang["login_block"]			= "Accés";
$pgv_lang["login_descr"]			= "El bloc «Accés» permet entrar el Nom d'Usuari i la Contrasenya per a l'accés d'usuaris.";
$pgv_lang["theme_select_block"] 		= "Selector de presentació";
$pgv_lang["theme_select_descr"] 		= "El bloc «Selector de presentació» de presentació us permet triar el que us plagui quan aquesta facilitat és activada.";
$pgv_lang["block_top10_title"]		= "Cognoms freqüents";
$pgv_lang["block_top10"]			= "Cognoms freqüents";
$pgv_lang["block_top10_descr"]		= "El bloc «Cognoms freqüents» mostra una taula amb els cognoms més comuns de la base de dades.  El nombre actual de cognoms mostrat és configurable. Podeu configurar el GEDCOM per treure noms de la llista.";
$pgv_lang["block_cookiepolicy"]			= "Política de cookies";
$pgv_lang["block_cookiepolicy_title"]	= "Política de cookies";
$pgv_lang["block_cookiepolicy_descr"]	= "El bloc «Política de cookies» mostra la política de cookies d’aquest lloc, tal com exigeix la Llei de cookies de la UE.";
$pgv_lang["block_cookiepolicy_body"]	= "<span class='warning'>Aquest avís és requerit per la Llei de cookies de la UE.</span><br />Aquest lloc web fa tot el possible per no utilitzar cookies i ho fa només quan sigui tècnicament necessari. Cap informació personal, ni tan sols el vostre identificador d’usuari o contrasenya, s’emmagatzema a les cookies creades per aquest lloc.<br /><br />Per motius tècnics aliens al control d’aquest lloc, aquestes cookies no s’eliminen quan finalitzeu la sessió amb aquest lloc. Tot i això, se suprimeixen immediatament quan finalitza el navegador.";
$pgv_lang["block_cookiepolicy_body_extlink"]	= "<span class='warning'>Aquest avís és requerit per la Llei de cookies de la UE.</span><br />Aquest lloc web fa tot el possible per no utilitzar cookies i ho fa només quan sigui tècnicament necessari. Cap informació personal, ni tan sols el vostre identificador d’usuari o contrasenya, s’emmagatzema a les cookies creades per aquest lloc. Per obtenir més informació sobre la política de cookies d’aquest lloc web, seguiu <a href='<link>' target='_blank' title='Política de cookies específica del lloc'>aquest enllaç</a>.<br /><br />Per motius tècnics aliens al control d’aquest lloc, aquestes cookies no s’eliminen quan finalitzeu la sessió amb aquest lloc. Tot i això, se suprimeixen immediatament quan finalitza el navegador.";
$pgv_lang["block_cookiepolicy_link"]			= "Enllaç a la pàgina de la política de cookies link";
$pgv_lang["block_givn_top10_title"]		= "Noms de pila freqüents";
$pgv_lang["block_givn_top10"]			= "Noms de pila freqüents";
$pgv_lang["block_givn_top10_descr"]		= "El bloc «Noms de pila freqüents» mostra una taula amb dels noms de pila més freqüents de la base de dades. El nombre de noms de pila a mostrar en aquest bloc és configurable.";

$pgv_lang["gedcom_news_block"]		= "Notícies GEDCOM";
$pgv_lang["gedcom_news_descr"]		= "El bloc «Notícies GEDCOM» mostra al visitant noves versions o notícies inserides per l'administrador.<br /><br />És el lloc adequat  per anunciar-hi modificacions rellevants de la base de dades, trobades familiars, naixements...";
$pgv_lang["gedcom_news_limit"]		= "Límit de visualització per:";
$pgv_lang["gedcom_news_limit_nolimit"]	= "Sense límit";
$pgv_lang["gedcom_news_limit_date"]		= "Antiguitat de l'ítem";
$pgv_lang["gedcom_news_limit_count"]	= "Nombre d'entrades";
$pgv_lang["gedcom_news_flag"]			= "Límit:";
$pgv_lang["gedcom_news_published"]	= "Publicat : ";
$pgv_lang["gedcom_news_archive"] 		= "Veure l'arxiu";
$pgv_lang["user_news_block"]			= "Agenda";
$pgv_lang["user_news_descr"]			= "El bloc «Agenda» permet a l'usuari guardar notes o portar una agenda o dietari en línea.";
$pgv_lang["my_journal"] 			= "La meva Agenda";
$pgv_lang["no_journal"] 			= "A l'Agenda no hi ha cap entrada.";
$pgv_lang["confirm_journal_delete"] 	= "Esteu segur que cal suprimir aquesta entrada de l'Agenda?";
$pgv_lang["add_journal"]			= "Afegiu una nova entrada a l'Agenda";
$pgv_lang["gedcom_news"]			= "Notícies";
$pgv_lang["confirm_news_delete"]		= "Segur que cal suprimir aquesta Notícia?";
$pgv_lang["add_news"]				= "Afegiu una Notícia";
$pgv_lang["no_news"]				= "No s'hi ha entrada cap Notícia.";
$pgv_lang["edit_news"]				= "Afegiu/Editeu una entrada a Notícies";
$pgv_lang["enter_title"]			= "Entreu el títol.";
$pgv_lang["enter_text"] 			= "Entreu el text de la Notícia.";
$pgv_lang["news_saved"] 			= "S'ha desat correctament la Notícia.";
$pgv_lang["article_text"]			= "Entreu el text:";
$pgv_lang["main_section"]			= "Blocs de la Secció Principal";
$pgv_lang["right_section"]			= "Blocs de la Secció Dreta";
$pgv_lang["available_blocks"]			= "Blocs disponibles";
$pgv_lang["move_up"]				= "Mou amunt";
$pgv_lang["move_down"]				= "Mou avall";
$pgv_lang["move_right"] 			= "Mou a la dreta";
$pgv_lang["move_left"]				= "Mou a l'esquerra";
$pgv_lang["broadcast_all"]			= "A tots els usuaris";
$pgv_lang["hit_count"]				= "Compta-visites:";
$pgv_lang["phpgedview_message"] 		= "Missatge PhpGedView";
$pgv_lang["common_surnames"]			= "Cognoms més habituals";
$pgv_lang["default_news_title"] 		= "Benvingut a la vostra Genealogia!";
$pgv_lang["default_news_text"]		= "La informació genealògica d'aquest lloc és presentada mitjançant <a href=\"http://www.phpgedview.net/\" target=\"_blank\">PhpGedView #VERSION#</a>. Aquesta és la pàgina d'inici i visió general.<br /><br />Per a accedir a les dades, escolliu un dels gràfics del menú, aneu a la llista de persones o cerqueu un nom o lloc.<br /><br />Si teniu algun dubte, polseu sobre el menú d'ajuda i obtindreu informació de com accedir i gestionar tots els seus recursos.<br /><br />Gràcies per visitar-nos!";
$pgv_lang["reset_default_blocks"]		= "Restaura els blocs per defecte";
$pgv_lang["recent_changes"] 			= "Canvis recents";
$pgv_lang["recent_changes_block"]		= "Canvis recents";
$pgv_lang["recent_changes_descr"]		= "El bloc «Canvis recents» llista els canvis que s'han fet a la base de dades el darrer mes per tenir-vos-en al corrent. Els canvis es detecten automàticament emprant l'etiqueta CHAN definida a l'estàndard GEDCOM.";
$pgv_lang["recent_changes_none"]		= "<b>No hi ha canvis d'ençà els darrers #pgv_lang[global_num1]# dies.</b>";
$pgv_lang["recent_changes_some"]		= "<b>Canvis fets els darrers #pgv_lang[global_num1]# dies</b>";
$pgv_lang["show_empty_block"]			= "Cal amagar aquest bloc quan és buit?";
$pgv_lang["hide_block_warn"]			= "Si amagueu un bloc buit no podreu canviar-ne la configuració fins que no torni a ésser visible perquè torna a haver-hi quelcom.";
$pgv_lang["delete_selected_messages"]	= "Esborra els missatges seleccionats";
$pgv_lang["use_blocks_for_default"]		= "Voleu emprar aquest blocs com configuració per defecte per a tots els usuaris?";
$pgv_lang["block_not_configure"]		=	"Aquest bloc no és configurable.";

//-- validate GEDCOM
$pgv_lang["add_media_tool"] 			= "Utilitat d'addició de multimèdia";

//-- hourglass chart
$pgv_lang["hourglass_chart"]			= "Rellotge de sorra";

//-- report engine
$pgv_lang["choose_report"]			= "Escolliu la llista a confeccionar";
$pgv_lang["enter_report_values"]		= "Entreu els paràmetres de l'informe";
$pgv_lang["selected_report"]			= "Informe seleccionat";
$pgv_lang["select_report"]			= "Escolliu l'informe";
$pgv_lang["download_report"]			= "Confecciona l'informe";
$pgv_lang["reports"]				= "Informes";
$pgv_lang["pdf_reports"]			= "Llistes PDF";
$pgv_lang["html_reports"]			= "Llistes HTML";

//-- Ahnentafel report
$pgv_lang["ahnentafel_report"]		= "Informe per generacions";
$pgv_lang["ahnentafel_generation"]		= "Generació ";
$pgv_lang["ahnentafel_pronoun_m"]		= " ";
$pgv_lang["ahnentafel_pronoun_f"]		= " ";
$pgv_lang["ahnentafel_born_m"]		= "Nat";
$pgv_lang["ahnentafel_born_f"]		= "Nada";
$pgv_lang["ahnentafel_christened_m"]	= "batejat";
$pgv_lang["ahnentafel_christened_f"] 	= "batejada";
$pgv_lang["ahnentafel_married_m"]		= "Casat amb";
$pgv_lang["ahnentafel_married_f"]		= "Casada amb";
$pgv_lang["ahnentafel_married_post"]= "&nbsp;";
$pgv_lang["ahnentafel_died_m"]		= "mort";
$pgv_lang["ahnentafel_died_f"]		= "morta";
$pgv_lang["ahnentafel_cremated_m"]	= "incinerat";		// male
$pgv_lang["ahnentafel_cremated_f"]	= "incinerada";		// female
$pgv_lang["ahnentafel_buried_m"]		= "enterrat";
$pgv_lang["ahnentafel_buried_f"]		= "enterrada";
$pgv_lang["ahnentafel_place"]			= " a ";
$pgv_lang["ahnentafel_no_details"]		= " però en desconeixem més detalls";
$pgv_lang["ahnentafel_on"]			= " ";

//-- Changes report
$pgv_lang["changes_report"]			= "Informe de canvis";
$pgv_lang["changes_pending_tot"]	= "Total canvis pendents:";
$pgv_lang["changes_accepted_tot"]	= "Total canvis acceptats:";

//-- Descendancy report
$pgv_lang["descend_report"]		= "Informe de Descendents";
$pgv_lang["son_of"]					= "fill de";
$pgv_lang["daughter_of"]			= "filla de";
$pgv_lang["child_of"]				= "fill/a de";
$pgv_lang["children_of"]			= "Mainada de";
$pgv_lang["descendancy_pronoun_m"]	= "Ell";
$pgv_lang["descendancy_pronoun_f"]	= "Ella";

$pgv_lang["family_group_report"]	= "Informe de Grups Familiars";
$pgv_lang["page"]				= "Pàgina";
$pgv_lang["of"] 				= "de";
$pgv_lang["enter_famid"]		= "Entreu l'ID de la Família";
$pgv_lang["show_sources"]		= "Mostra fonts?";
$pgv_lang["show_notes"] 		= "Mostra notes?";
$pgv_lang["show_abbr_notes"] 		= "Mostra notes abreujades?";
$pgv_lang["show_photos"]		= "Amb fotografies?";
$pgv_lang["relatives_report_ext"]	= "Llista de parentiu ampliada";
$pgv_lang["with"]				= "amb";
$pgv_lang["on"]				= "el";
$pgv_lang["in"]				= "el";
$pgv_lang["individual_report"]	= "Informe personal";
$pgv_lang["individual_with_rela_report"]		= "Informe de parents de primer grau";
$pgv_lang["enter_pid"]			= "Entreu l'ID de la persona";
$pgv_lang["generated_by"]		= "Generat per";
$pgv_lang["birth_report"]		= "Llista de natalicis i llocs";
$pgv_lang["birthplace"]			= "La llista de llocs cont&eacute";
$pgv_lang["birthdate1"]			= "Data de naixement inicial";
$pgv_lang["birthdate2"]			= "Data de naixement final";
$pgv_lang["death_report"]		= "Llista d'òbits i llocs";
$pgv_lang["deathplace"]			= "La llista de llocs de defunció conté";
$pgv_lang["deathdate1"]			= "Data de defunció inicial";
$pgv_lang["deathdate2"]			= "Data de defunció final";
$pgv_lang["marr_report"]		= "Dates de casament i llocs";
$pgv_lang["marrplace"]			= "El lloc de casament conté:";
$pgv_lang["marrdate1"]			= "Data de casament inicial";
$pgv_lang["marrdate2"]			= "Data de casament final";
$pgv_lang["sort_by"]			= "Ordena-ho per";
$pgv_lang["cemetery_report"]		= "Informe de cementiri";
$pgv_lang["burialplace"]			= "El lloc d'enterrament conté";
$pgv_lang["fact_sources_report"]	= "Fonts de fets";
$pgv_lang["missing_facts_report"]	= "Fets de familiars que falten";
$pgv_lang["sources_to_events"]		= "Fonts dels fets";

$pgv_lang["cleanup"]			= "Neteja-ho";

//-- CONFIGURE (extra) messages for programs patriarch and statistics
$pgv_lang["statistics"] 		= "Estadístiques";
$pgv_lang["show_stats_charts"]		= "Mostra gràfiques estadístiques";
$pgv_lang["decade_birth"]			= "Dècada de naixement";
$pgv_lang["decade_death"]			= "Dècada de defunció";
$pgv_lang["decade_marriage"]		= "Dècada de matrimoni";
$pgv_lang["avg_age"]				= "Mitjana d'edat";

//-- Merge Records
$pgv_lang["merge_same"] 		= "Els registres no son dels mateix tipus. No es poden barrejar registres que no siguin del mateix tipus.";
$pgv_lang["merge_step1"]		= "Barrejant, pas 1 de 3";
$pgv_lang["merge_step2"]		= "Barrejant, pas 2 de 3";
$pgv_lang["merge_step3"]		= "Barrejant, pas 3 de 3";
$pgv_lang["select_gedcom_records"]	= "Escolliu dos registres GEDCOM per barrejar. Han d'ésser del mateix tipus.";
$pgv_lang["merge_to"]			= "Barreja cap a l'ID:";
$pgv_lang["merge_from"] 		= "Barreja des de l'ID:";
$pgv_lang["merge_facts_same"]		= "Els següents esdeveniments son exactament iguals a ambdós registres i es barrejaran automàticament.";
$pgv_lang["no_matches_found"]		= "No s'han trobat els esdeveniments cercats";
$pgv_lang["unmatching_facts"]		= "Els següents esdeveniments no casen. Seleccioneu la informació que voleu mantenir.";
$pgv_lang["record"] 			= "Registre";
$pgv_lang["adding"] 			= "Afegint";
$pgv_lang["updating_linked"]		= "Modificant el registre enllaçat";
$pgv_lang["merge_more"] 		= "Barreja més registres.";
$pgv_lang["same_ids"]			= "Heu entrat el mateix ID. No es poden barrejar els mateixos registres entre sí.";
$pgv_lang["updated_favorites"] 			= "Favorits actualitzats.";

//-- ANCESTRY FILE MESSAGES
$pgv_lang["ancestry_chart"] 		= "Diagrama d'avantpassats";
$pgv_lang["gen_ancestry_chart"]	= "Gràfic de #PEDIGREE_GENERATIONS# generacions d'avantpassats";
$pgv_lang["chart_style"]		= "Estil de gràfic";
$pgv_lang["chart_list"]			= "Llista";
$pgv_lang["chart_booklet"]   	= "Fulletó";
$pgv_lang["show_cousins"]		= "Veure els cosins";
// 1st generation
$pgv_lang["sosa_2"] 	= "Pare";
$pgv_lang["sosa_3"] 	= "Mare";
// 2nd generation
$pgv_lang["sosa_4"] 	= "Avi";
$pgv_lang["sosa_5"] 	= "Àvia";
$pgv_lang["sosa_6"] 	= "Avi";
$pgv_lang["sosa_7"] 	= "Àvia";
// 3rd generation
$pgv_lang["sosa_8"] 	= "Besavi";
$pgv_lang["sosa_9"] 	= "Besàvia";
$pgv_lang["sosa_10"]	= "Besavi";
$pgv_lang["sosa_11"]	= "Besàvia";
$pgv_lang["sosa_12"]	= "Besavi";
$pgv_lang["sosa_13"]	= "Besàvia";
$pgv_lang["sosa_14"]	= "Besavi";
$pgv_lang["sosa_15"]	= "Besàvia";
// 4th generation
$pgv_lang["sosa_16"]	= "Rebesavi";
$pgv_lang["sosa_17"]	= "Rebesàvia";
$pgv_lang["sosa_18"]	= "Rebesavi";
$pgv_lang["sosa_19"]	= "Rebesàvia";
$pgv_lang["sosa_20"]	= "Rebesavi";
$pgv_lang["sosa_21"]	= "Rebesàvia";
$pgv_lang["sosa_22"]	= "Rebesavi";
$pgv_lang["sosa_23"]	= "Rebesàvia";
$pgv_lang["sosa_24"]	= "Rebesavi";
$pgv_lang["sosa_25"]	= "Rebesàvia";
$pgv_lang["sosa_26"]	= "Rebesavi";
$pgv_lang["sosa_27"]	= "Rebesàvia";
$pgv_lang["sosa_28"]	= "Rebesavi";
$pgv_lang["sosa_29"]	= "Rebesàvia";
$pgv_lang["sosa_30"]	= "Rebesavi";
$pgv_lang["sosa_31"]	= "Rebesàvia";

// for the general case of ancestors of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["sosa_paternal_male_n_generations"]	= "Avi %2\$dè";
$pgv_lang["sosa_paternal_female_n_generations"]	= "Àvia %2\$dena";
$pgv_lang["sosa_maternal_male_n_generations"]	= "Avi %2\$dè";
$pgv_lang["sosa_maternal_female_n_generations"]	= "Àvia %2\$dena";

//-- FAN CHART
$pgv_lang["compact_chart"]		= "Gràfic compacte";
$pgv_lang["fan_chart"]			= "Diagrama de cercle";
$pgv_lang["gen_fan_chart"]  		= "Diagrama de Cercle de #PEDIGREE_GENERATIONS# generacions";
$pgv_lang["fan_width"]			= "Amplada";
$pgv_lang["gd_library"]			= "Problema de configuració del servidor PHP: cal la llibreria GD 2.x per emprar funcions d'imatge.";
$pgv_lang["gd_freetype"]		= "Problema de configuració del servidor PHP: cal la llibreria FreeType per emprar fonts TrueType.";
$pgv_lang["gd_helplink"]		= "http://www.php.net/gd";
$pgv_lang["fontfile_error"]		= "Fitxer de fonts no localitzat al servidor PHP";
$pgv_lang["fanchart_IE"]		= "Aquesta imatge 'Fanchart' no pot imprimir-la directament el vostre navegador. Polseu el botó dret, deseu-la i llavors imprimiu-la.";

//-- RSS Feed
$pgv_lang["rss_descr"]			= "Notícies i enllaços del lloc #GLOBALS[GEDCOM_TITLE]#";
$pgv_lang["rss_logo_descr"]		= "Fil creat per PhpGedView";
$pgv_lang["rss_feeds"]			= "Fil RSS";
$pgv_lang["no_feed_title"]		= "Fil no disponible";
$pgv_lang["no_feed"]			= "No hi ha fil RSS disponible per a aquest lloc PhpGedView";
$pgv_lang["feed_login"]			= "Si esteu enregistrat en aquest lloc PhpGedView, podeu <a href=\"#AUTH_URL#\">entrar</a> al servidor emprant Autenticació Bàsica HTTP per veure-hi informació privada.";
$pgv_lang["authenticated_feed"]	= "Fil Autenticat";

//-- ASSOciates RELAtionship
// After any change in the following list, please check $assokeys in edit_interface.php
$pgv_lang["attendant"] 			= "Vigilant";
$pgv_lang["attending"] 			= "Assistent";
$pgv_lang["best_man"] 			= "Padrí de boda";
$pgv_lang["bridesmaid"] 		= "Dama d'honor";
$pgv_lang["buyer"] 			= "Comprador";
$pgv_lang["circumciser"] 		= "Circumcisor";
$pgv_lang["civil_registrar"] 		= "Registrador civil";
$pgv_lang["employee"] = "Empleat";
$pgv_lang["employer"] = "Empresari";
$pgv_lang["foster_child"] = "Fill adoptiu";
$pgv_lang["foster_father"] = "Pare adoptiu";
$pgv_lang["foster_mother"] = "Mare adoptiva";
$pgv_lang["friend"] 			= "Amic/ga";
$pgv_lang["godfather"] 			= "Padrí";
$pgv_lang["godmother"] 			= "Padrina";
$pgv_lang["godparent"] 			= "Padrí/na";
$pgv_lang["godson"]		= "Fillol";
$pgv_lang["goddaughter"] = "Fillola";
$pgv_lang["godchild"]	= "Fillol/a";
$pgv_lang["guardian"]	= "Tutor";
$pgv_lang["informant"] 			= "Informant";
$pgv_lang["lodger"] 			= "Hoste";
$pgv_lang["nanny"] = "Mainadera";
$pgv_lang["nurse"] 			= "Infermera";
$pgv_lang["owner"] = "Propietari";
$pgv_lang["priest"] 			= "Sacerdot";
$pgv_lang["rabbi"] 			= "Rabí";
$pgv_lang["registry_officer"] 	= "Oficial del Registre";
$pgv_lang["seller"] 			= "Venedor";
$pgv_lang["servant"] 			= "Criat/da";
$pgv_lang["slave"] = "Esclau";
$pgv_lang["twin"] 			= "Bessó/na";
$pgv_lang["twin_brother"] 		= "Germà bessó";
$pgv_lang["twin_sister"] 		= "Germana bessona";
$pgv_lang["ward"] = "Tutor";
$pgv_lang["witness"] 			= "Testimoni";

//-- statistics utility
$pgv_lang["stat_create"]		= "Feu el vostre propi gràfic";
$pgv_lang["statutci"]			= "impossible crear l'índex";
$pgv_lang["statnnames"] 			= "Nombre de persones";
$pgv_lang["statnfam"]   			= "Nombre de famílies";
$pgv_lang["statnmale"]  			= "Nombre d'homes";
$pgv_lang["statnfemale"]			= "Nombre de dones";
$pgv_lang["with_sources"]		= "Amb fonts";
$pgv_lang["without_sources"]	= "Sense fonts";
$pgv_lang["stat_sindi"]			= "Persones amb fonts";
$pgv_lang["stat_sfam"]			= "Famílies amb fonts";
$pgv_lang["statvars"]			= "Ompliu les següents variables pel gràfic";
$pgv_lang["statlxa"]			= "Escolliu el tipus de gràfic:";
$pgv_lang["statlya"]			= "Resultats:";
$pgv_lang["statlza"]			= "Categories:";
$pgv_lang["map_type"]			= "Tipus de mapa";
$pgv_lang["stat_1_map"]			= "Distribució de persones";
$pgv_lang["stat_2_map"]			= "Per país de naixement";
$pgv_lang["stat_3_map"]			= "Per país de defunció";
$pgv_lang["stat_4_map"]			= "Per país de casament";
$pgv_lang["stat_5_birth"]		= "Naixements per centúries";
$pgv_lang["stat_6_death"]		= "Defuncions per centúries";
$pgv_lang["stat_7_marr"]		= "Casaments per centúries";
$pgv_lang["stat_7_div"]			= "Divorcis per centúries";
$pgv_lang["stat_8_fam"]			= "Famílies amb fonts";
$pgv_lang["stat_9_indi"]		= "Persones amb fonts";
$pgv_lang["stat_10_none"]		= "cap";
$pgv_lang["stat_11_mb"]			= "Mes de naixement";
$pgv_lang["stat_12_md"]			= "Mes de defunció";
$pgv_lang["stat_13_mm"]			= "Mes de casament";
$pgv_lang["stat_14_mb1"]		= "Mes de naixement del primer fill/a en una relació";
$pgv_lang["stat_15_mm1"]		= "Mes del primer casament";
$pgv_lang["stat_16_mmb"]		= "Mesos entre el casament i el primer fill";
$pgv_lang["stat_17_arb"]		= "Any de naixement";
$pgv_lang["stat_18_ard"]		= "Edat a la mort";
$pgv_lang["stat_18_aard"]		= "Edat mitjana a la mort";
$pgv_lang["stat_19_arm"]		= "Edat en el matrimoni";
$pgv_lang["stat_19_aarm"]		= "Edat mitjana en el matrimoni";
$pgv_lang["stat_20_arm1"]		= "Edat al primer matrimoni";
$pgv_lang["stat_21_nok"]		= "Nombre de fills";
$pgv_lang["stat_22_fwok"]		= "Nombre de famílies sense fills";
$pgv_lang["stat_200_none"]		= "tot (o en blanc)";
$pgv_lang["stat_201_num"]		= "nombre absolut";
$pgv_lang["stat_202_perc"]		= "percentatge";
$pgv_lang["stat_300_none"]		= "cap";
$pgv_lang["stat_301_mf"]		= "homes/dones";
$pgv_lang["stat_302_cgp"]		= "períodes de dates";
$pgv_lang["century"]			= "centúria";
$pgv_lang["stat_age"]			= "Edat";
$pgv_lang["no_date_fam"]		= "desconegut";
$pgv_lang["statar_xgp"]			= "límits per períodes:";
$pgv_lang["statar_xgl"]			= "límits per edats:";
$pgv_lang["statar_xgm"]			= "límits per mesos:";
$pgv_lang["statar_xga"]			= "límits per números:";
$pgv_lang["statar_zgp"]			= "límits per períodes de dades:";
$pgv_lang["less"]				= "menys de";
$pgv_lang["over"]				= "més de";
$pgv_lang["interval"]			= "interval";
$pgv_lang["aft_marr"]			= "mesos després del matrimoni";
$pgv_lang["bef_marr"]			= "mesos abans i després del matrimoni";
$pgv_lang["quarters"]			= "trimestres després del matrimoni";
$pgv_lang["half_year"]			= "mig any després del matrimoni";
$pgv_lang["one_child"]			= "interval d'un fill";
$pgv_lang["two_children"]		= "interval de dos fills";
$pgv_lang["statreset"]			= "restaura";
$pgv_lang["statsubmit"]			= "mostra el gràfic";
$pgv_lang["stat_largest_families"] = "Famílies més nombroses";

$pgv_lang["stat_own_charts"]		= "Gràfics a la carta";
$pgv_lang["statnliving"]			= "Total vius";
$pgv_lang["statndead"]				= "Total difunts";
$pgv_lang["stat_births"]			= "Total naixements";
$pgv_lang["stat_marriages"]			= "Total casaments";
$pgv_lang["stat_divorces"]			= "Total divorcis";
$pgv_lang["stat_deaths"]			= "Total defuncions";
$pgv_lang["stat_first_birth"]		= "Naixement més antic";
$pgv_lang["stat_first_marriage"]	= "Casament més antic";
$pgv_lang["stat_first_divorce"]		= "Divorci més antic";
$pgv_lang["stat_first_death"]		= "Defunció més antiga";
$pgv_lang["stat_last_birth"]		= "Darrer neixement";
$pgv_lang["stat_last_marriage"]		= "Darrer casament";
$pgv_lang["stat_last_divorce"]		= "Darrer divorci";
$pgv_lang["stat_last_death"]		= "Darrera defunció";
$pgv_lang["stat_lifespan"]			= "Longevitat";
$pgv_lang["stat_lived_longest"]		= "Edat més avança de defunció";
$pgv_lang["stat_live_longest"]		= "Persones vives de més edat";
$pgv_lang["stat_marr_age"]			= "Durada del matrimoni";
$pgv_lang["stat_long_marr_age"]		= "Matrimoni més durador";
$pgv_lang["stat_short_marr_age"]	= "Matrimoni menys durador";
$pgv_lang["stat_youngest_male"]		= "Home més jove";
$pgv_lang["stat_youngest_female"]	= "Dona més jove";
$pgv_lang["stat_oldest_male"]		= "Home de més edat";
$pgv_lang["stat_oldest_female"]		= "Dona de més edat";
$pgv_lang["stat_childbirth_age"]	= "Edat al naixement de la mainada";
$pgv_lang["stat_youngest_father"]	= "Pare més jove";
$pgv_lang["stat_youngest_mother"]	= "Mare més jove";
$pgv_lang["stat_oldest_father"]		= "Pare de més edat";
$pgv_lang["stat_oldest_mother"]		= "Mare de més edat";
$pgv_lang["stat_children_in_fam"]	= "Mainada per família";
$pgv_lang["stat_largest_gfamilies"]	= "Famílies amb major nombre de néts";
$pgv_lang["stat_age_difference"]	= "Diferència d'edat";
$pgv_lang["stat_age_siblings"]		= "Diferència d'edat entre germans";
$pgv_lang["stat_top_age_siblings"]	= "Màxima diferència d'edat entre germans";
$pgv_lang["stat_age_mf_spouse"]		= "Marits majors que la muller";
$pgv_lang["stat_age_fm_spouse"]		= "Mullers majors que el marit";
$pgv_lang["stat_names"]				= "Noms";
$pgv_lang["statnsurnames"]			= "Total cognoms";
$pgv_lang["statngivennames"]		= "Total noms de pila";
$pgv_lang["top_surnames"]			= "Cognoms més comuns";
$pgv_lang["top_givennames"]			= "Noms de pila més comuns";
$pgv_lang["events"]					= "Esdeveniments";
$pgv_lang["stat_records"]			= "Registres";
$pgv_lang["stat_notes"]				= "Notes";
$pgv_lang["stat_first_event"]		= "Esdeveniment més antic";
$pgv_lang["stat_last_event"]		= "Esdeveniment més recent";
$pgv_lang["stat_places"]			= "Llocs";
$pgv_lang["stat_birth_places"]		= "Llocs de naixement";
$pgv_lang["stat_marriage_places"]	= "Llocs de casament";
$pgv_lang["stat_death_places"]		= "Llocs de defunció";
$pgv_lang["stat_countries"]			= "Esdeveniments per països";

//-- statisticsplot utility
$pgv_lang["statistiek_list"]		= "Gràfic estadístic";
$pgv_lang["stpl"]			 	= "...";
$pgv_lang["stplinfo"]			= "informació gràfica:";
$pgv_lang["stpltype"]			= "tipus:";
$pgv_lang["stplnoim"]			= " no implementat:";
$pgv_lang["stplmf"]			= "per sexe";
$pgv_lang["stplipot"]			= " per període de temps";
$pgv_lang["stplmonth"]			= "mes";
$pgv_lang["stplnumbers"]		= "números per una família";
$pgv_lang["stplnuch"]			= "fills";
$pgv_lang["stplage"]			= "edat";
$pgv_lang["stplperc"]			= "percentatge";
$pgv_lang["stplnumof"]			= "Totals ";
$pgv_lang["stplmarrbirth"]		= "Mesos entre casament i naixement del primer fill/a";
$pgv_lang["indi_distribution_chart"]	= "Gràfic de distribució de persones";
$pgv_lang["surname_distribution_chart"]	= "Gràfic de distribuició de cognoms";
$pgv_lang["g_chart_high"]		= "Població més alta";
$pgv_lang["g_chart_low"]		= "Població més baixa";
$pgv_lang["g_chart_nobody"]		= "Ningú";
$pgv_lang["area_chart"]			= "Zona geogràfica";
$pgv_lang["europe_chart"]		= "Europa";
$pgv_lang["s_america_chart"]	= "Amèrica del Sud";
$pgv_lang["asia_chart"]			= "Asia";
$pgv_lang["middle_east_chart"]	= "Orient Mitjà";
$pgv_lang["africa_chart"]		= "Àfrica";
$pgv_lang["world_chart"]		= "Món";

//-- alive in year
$pgv_lang["alive_in_year"]		= "Vius l'any";
$pgv_lang["is_alive_in"]		= "és viu el #YEAR#";
$pgv_lang["alive"]			= "Vius ";
$pgv_lang["dead"]				= "Difunts ";
$pgv_lang["maybe"]			= "Potser ";
$pgv_lang["both_alive"]			= "Ambdós vius ";
$pgv_lang["both_dead"]			= "Ambdós difunts ";

//-- Help system
$pgv_lang["definitions"]		= "Definicions";

//-- Index_edit
$pgv_lang["block_desc"]			= "Descripció dels blocs";
$pgv_lang["click_here"]			= "Polseu aquí per continuar";
$pgv_lang["click_here_help"]		= "~#pgv_lang[click_here]#~<br /><br />Polseu aquest botó per desar els canvis.<br /><br />Retornareu a la pàgina #pgv_lang[welcome]# o a #pgv_lang[mygedview]#, però no veureu els canvis. Us cal emprar la funció Actualitza del navegador per veure'ls correctament.";
$pgv_lang["block_summaries"]		= "~#pgv_lang[block_desc]#~<br /><br />Heus aquí una breu descripció de cada un dels blocs que podeu posar a la pàgina #pgv_lang[welcome]# o a la #pgv_lang[mygedview]# .<br /><br /><table border='1' width='95%'><tr><td class='list_value'><b>#pgv_lang[name]#</b></td><td class='list_value'><b>#pgv_lang[description]#</b></td></tr>#GLOBALS[blockSummaries]#</table>";

//-- Find page
$pgv_lang["total_places"]		= "Llocs trobats:";
$pgv_lang["media_contains"]		= "Fitxers Multimèdia:";
$pgv_lang["repo_contains"]		= "L'arxiu conté:";
$pgv_lang["shared_note_contains"]	= "Contingut de la nota compartida:";
$pgv_lang["source_contains"]		= "La font conté:";
$pgv_lang["display_all"]		= "Veure-ho tot";

// FAQ Page
$pgv_lang["add_faq_header"] 			= "Capçalera de preguntes més freqüents";
$pgv_lang["add_faq_body"] 			= "Cos de preguntes més freqüents";
$pgv_lang["add_faq_order"] 			= "Posició de preguntes més freqüents";
$pgv_lang["add_faq_visibility"] = "Visibilitat de preguntes més freqüents";
$pgv_lang["no_faq_items"] 			= "La llista de preguntes més freqüents és buida.";
$pgv_lang["position_item"] 			= "Posició de l'ítem";
$pgv_lang["faq_list"] 				= "Llistat de PMF (Preguntes Més Freqüents)";
$pgv_lang["confirm_faq_delete"] 		= "Esteu segur que cal suprimir aquesta entrada de PMF?";
$pgv_lang["preview"] 				= "Vista prèvia";
$pgv_lang["no_id"] 				= "No s'ha especificat cap ID de preguntes més freqüents!";

// Help search
$pgv_lang["hs_title"] 				= "Cerca text d'ajuda";
$pgv_lang["hs_search"] 				= "Cerca";
$pgv_lang["hs_close"] 				= "Tanca la finestra";
$pgv_lang["hs_results"] 			= "Resultats trobats:";
$pgv_lang["hs_keyword"] 			= "Cerca per";
$pgv_lang["hs_searchin"]			= "Cerca a";
$pgv_lang["hs_searchuser"]			= "Ajuda d'usuari";
$pgv_lang["hs_searchmodules"]	= "Mòduls d'ajuda";
$pgv_lang["hs_searchconfig"]			= "Ajuda per l'Administrador";
$pgv_lang["hs_searchhow"]			= "Tipus de recerca";
$pgv_lang["hs_searchall"]			= "Amb totes les paraules";
$pgv_lang["hs_searchany"]			= "Alguna paraula";
$pgv_lang["hs_searchsentence"]		= "Frase exacta";
$pgv_lang["hs_intruehelp"]			= "Text d'ajuda solament";
$pgv_lang["hs_inallhelp"]			= "Tot el text";

// Media import
$pgv_lang["choose"] = "Escolliu:";
$pgv_lang["account_information"] 		= "Informació del compte";

//-- Media item "TYPE" sub-field
$pgv_lang["TYPE__audio"] 			= "So";
$pgv_lang["TYPE__book"] 			= "Llibre";
$pgv_lang["TYPE__card"] 			= "Tarja";
$pgv_lang["TYPE__certificate"] 		= "Certificat";
$pgv_lang["TYPE__coat"] = "Escut d'Armes";
$pgv_lang["TYPE__document"] 			= "Document";
$pgv_lang["TYPE__electronic"] 		= "Electrònic";
$pgv_lang["TYPE__fiche"] 			= "Microfitxa";
$pgv_lang["TYPE__film"] 			= "Microfilm";
$pgv_lang["TYPE__magazine"]			= "Revista";
$pgv_lang["TYPE__manuscript"] 		= "Manuscrit";
$pgv_lang["TYPE__map"] 				= "Mapa";
$pgv_lang["TYPE__newspaper"] 			= "Diari";
$pgv_lang["TYPE__photo"] 			= "Fotografia";
$pgv_lang["TYPE__tombstone"] 			= "Làpida";
$pgv_lang["TYPE__video"] 			= "Vídeo";
$pgv_lang["TYPE__painting"] = "Pintura";
$pgv_lang["TYPE__other"] = "Un altre";

//-- Other media suff
$pgv_lang["view_slideshow"] 			= "Veure-ho com a pas de diapositives";
$pgv_lang["download_image"]			= "Mostra el fitxer";
$pgv_lang["no_media"]				= "No s'ha localitzat multimèdia";
$pgv_lang["media_privacy"]			= "Les restriccions de privadesa no us permeten veure aquest ítem";
$pgv_lang["relations_heading"]		= "La imatge fa referència a:";
$pgv_lang["file_size"]				= "Mida del fitxer";
$pgv_lang["img_size"]				= "Mida de la imatge";
$pgv_lang["media_broken"]			= "Aquest fitxer multimèdia és partit i no pot ser marca d'aigua";
$pgv_lang["unknown_mime"]			= "Error del tallafoc multimèdia: &gt;Tipus Mime desconegut&lt; pel fitxer";

//-- Modules
$pgv_lang["module_error_unknown_action_v2"] 	= "Acció desconeguda: [action].";
$pgv_lang["module_error_unknown_type"] 		= "Tipus de mòdul desconegut.";

//-- sortable tables buttons
$pgv_lang["button_alive_in_year"] 		= "Mostra persones vives l'any indicat.";
$pgv_lang["button_BIRT_Y100"] 		= "Mostra persones nascudes els darrers 100 anys.";
$pgv_lang["button_BIRT_YES"] 			= "Mostra persones nascudes fa més de 100 anys.";
$pgv_lang["button_DEAT_H"] 			= "Mostra parelles on solament l'home hagi mort.";
$pgv_lang["button_DEAT_N"] 			= "Mostra gent que sigui viva o parelles que ambdós siguin vius.";
$pgv_lang["button_DEAT_W"] 			= "Mostra parelles on solament la dona hagi mort.";
$pgv_lang["button_DEAT_Y"] 			= "Mostra gent que hagi mort o parelles que ambdós hagin mort.";
$pgv_lang["button_DEAT_Y100"] 		= "Mostra gent morta els darrers 100 anys.";
$pgv_lang["button_DEAT_YES"] 			= "Mostra gent morta fe més de 100 anys.";
$pgv_lang["button_MARR_DIV"] 			= "Mostra parelles separades/divorciades.";
$pgv_lang["button_MARR_U"] 			= "Mostra parelles amb data de casament desconeguda.";
$pgv_lang["button_MARR_Y100"] 		= "Mostra parelles casades els darrers 100 anys.";
$pgv_lang["button_MARR_YES"] 			= "Mostra parelles casades fa més de 100 anys.";
$pgv_lang["button_reset"] 			= "Restaura els paràmetres de la llista per defecte.";
$pgv_lang["button_SEX_F"] 			= "Mostra solament dones.";
$pgv_lang["button_SEX_M"] 			= "Mostra solament homes.";
$pgv_lang["button_SEX_U"] 			= "Mostra solament persones de les que es desconeix el sexe.";
$pgv_lang["button_TREE_L"] 			= "Mostra «fulles»; parelles o persones. Son persones vives però sense mainada registrada a la base de dades.";
$pgv_lang["button_TREE_R"] 			= "Mostra «caps de llinatges»; parelles o persones. Aquestes persones poden anomenar-se també «patriarques». Son persones sense pares enregistrats a la base de dades.";
$pgv_lang["sort_column"] 			= "Ordena per aquesta columna.";
?>
