<?php
/**
 * Czech Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2024  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author Jan Hapala, Josef Pavlík
 * @translator Google Translate
 * @version $Id: lang.cz.php 7374 2024-02-13 13:57:05Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["birth_M"]				= "Narozeniny #name#a";		// For male persons
$pgv_lang["birth_F"]				= "Narozeniny #name#a";		// For female persons
$pgv_lang["born_in_M"]				= "Narodil se #date# v #place#";		// For male persons
$pgv_lang["born_in_F"]				= "Narodila se #date# v #place#";		// For female persons
$pgv_lang["born_on_M"]				= "Narodil se #date#";		// For male persons
$pgv_lang["born_on_F"]				= "Narodila se #date#";		// For female persons
$pgv_lang["death_M"]				= "Výročí smrti #name#a";		// For male persons
$pgv_lang["death_F"]				= "Výročí smrti #name#a";		// For female persons
$pgv_lang["died_in_M"]				= "Zemřel #date# v #place#";		// For male persons
$pgv_lang["died_in_F"]				= "Zemřela #date# v #place#";		// For female persons
$pgv_lang["died_on_M"]				= "Zemřel #date#";		// For male persons
$pgv_lang["died_on_F"]				= "Zemřela #date#";		// For female persons
$pgv_lang["anniversary_of"]			= "Svatební výročí #husband# a #wife#";
$pgv_lang["married_in"]				= "Oženil se #date# v #place#";
$pgv_lang["married_on"]				= "Oženil se #date#";
$pgv_lang["clustrmaps_locations"]	= "Umístění návštěvníků této stránky";
$pgv_lang["gedcomid"]			= "ID osoby";
$pgv_lang["sortby"]					= "Pořadí";
$pgv_lang["exact"]					= "Přesně";
$pgv_lang["begins_with"]			= "Začíná na";
$pgv_lang["contains"]				= "Obsahuje";
$pgv_lang["sounds_like"]			= "Zní jako";
$pgv_lang["advanced_search"] 		= "Pokročilé vyhledávání";
$pgv_lang["more_fields"]			= "Přidat další položky";
$pgv_lang["install_step_8"] 		= "Začít";
$pgv_lang["parent_family"]			= "Rodina rodičů";
$pgv_lang["step_parent_family"]		= "Rodina nevlastní rodič";
$pgv_lang["immediate_family"]		= "Nejbližší rodina";

$pgv_lang["load_full_tree"]			= "Ukázat tento strom jako interaktivní strom na plnou obrazovku";
$pgv_lang["hide_show_spouses"]		= "Ukázat nebo skrýt vícenásobné partneři";
$pgv_lang["interactive_tree"]		= "Interaktivní strom";
$pgv_lang["example"]				= "Příklad:";
$pgv_lang["tree"]					= "Strom";
$pgv_lang["ellipsis"]				= "\xE2\x80\xA6";
$pgv_lang["showUnknown"]			= "Ukázat neznámé pohlaví";
$pgv_lang["count"]					= "Počet";
$pgv_lang["age_differences"]		= "Ukázat rozdíl věku";
$pgv_lang["multi_site_search"] 		= "Multi Site vyhledávání";
$pgv_lang["switch_lifespan"]		= "Ukázat Životnost graf";
$pgv_lang["switch_timeline"]		= "Ukázat Časová osa";
$pgv_lang["differences"]			= "Rozdíly";
$pgv_lang["charts_block"]			= "Blok grafů";
$pgv_lang["charts_block_descr"]		= "Blok grafů umožňuje umístit graf na Welcome nebo Uvítací stránce portálu. Můžete nastavit blok pro zobrazení an předky, potomky, nebo přesýpací hodiny výhled. Můžete si také vybrat kořenový osobu pro graf.";
$pgv_lang["charts_click_box"]		= "Klikněte na některý z boxů získat další informace o této osobě.";
$pgv_lang["chart_type"]				= "Typ grafu";
$pgv_lang["changedate1"]			= "Ukončení rozsah dat změn";
$pgv_lang["changedate2"]			= "Spuštění rozsah dat změn";
$pgv_lang["search_place_word"]		= "Pouze celá slova";
$pgv_lang["invalid_search_input"] 	= "Prosím zadejte k roku ještě jméno, příjmení nebo místo.";
$pgv_lang["duplicate_username"]		= "Toto uživatelské jméno již existuje. Prosím, vraťte se zpět a vyberte jiné uživatelské jméno.";
$pgv_lang["cache_life"]				= "Život cache souboru";
$pgv_lang["genealogy"]				= "genealogie";
$pgv_lang["activate"]				= "Aktivovat";
$pgv_lang["deactivate"]				= "Deaktivovat";
$pgv_lang["play"]					= "Hrát";
$pgv_lang["stop"]					= "Ustat";
$pgv_lang["random_media_start_slide"]	= "Začněte prezentaci na načtení stránky?";
$pgv_lang["random_media_ajax_controls"]	= "Zobrazit prezentace kontroly?";
$pgv_lang["description"]			= "Popis";
$pgv_lang["current_dir"]			= "Aktuální adresář";
$pgv_lang["SHOW_ID_NUMBERS"]		= "Zobrazit vedle jmen ID";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES"]	= "Zobrazit zvýrazněné obrázky v políčkách lidí";
$pgv_lang["view_img_details"]		= "Zobrazit detaily obrazu";
$pgv_lang["server_folder"]			= "Název složky na serveru";
$pgv_lang["medialist_recursive"]	= "Seznam souborů v podadresářích";
$pgv_lang["media_options"]			= "Možnosti média";
$pgv_lang["confirm_password"]		= "Musíte potvrdit heslo.";
$pgv_lang["enter_email"]		= "Musíte zadat e-mailovou adresu.";
$pgv_lang["enter_fullname"]		= "Musíte vložit celé jméno.";
$pgv_lang["name"]			= "Jméno";
$pgv_lang["names"]					= "Jména";
$pgv_lang["children"]			= "Děti";
$pgv_lang["lchildren"]				= "děti";
$pgv_lang["child"]			= "Dítě";
$pgv_lang["grandchildren"]			= "vnoučata";
$pgv_lang["family"]			= "Rodina";
$pgv_lang["as_child"]			= "Rodina s rodiči";
$pgv_lang["shared_note_menu"]		= "Možnosti pro sdílené poznámky";
$pgv_lang["source_menu"]			= "Možnosti pro zdroj";
$pgv_lang["repo_menu"]				= "Možnosti pro repozitáři";
$pgv_lang["other_records"]			= "Záznamy, které se připojují k tomuto zdroj:";
$pgv_lang["other_repo_records"]		= "Záznamy, které se připojují k tomuto repozitáře:";
$pgv_lang["repo_info"]				= "Informace o tomto repozitáře";
$pgv_lang["enter_terms"]			= "Vložte výraz, který se má vyhledat:";
$pgv_lang["search_asso_label"]		= "Přidruží";
$pgv_lang["search_asso_text"]		= "Zobrazit související osoby / rodiny";
$pgv_lang["search_DM"]				= "Daitch-Mokotoff";
$pgv_lang["search_fams"]			= "Rodiny";
$pgv_lang["search_gedcom"]			= "Hledání v souboru GEDCOM";
$pgv_lang["search_geds"]			= "Databáze pro vyhledávání";
$pgv_lang["search_indis"]			= "osoby";
$pgv_lang["search_notes"]			= "Sdílené poznámky";
$pgv_lang["search_inrecs"]			= "Hledat";
$pgv_lang["search_prtall"]			= "Všechna jména";
$pgv_lang["search_prthit"]			= "Jména s hity";
$pgv_lang["results_per_page"]		= "Výsledků na stránku";
$pgv_lang["firstname_search"]			= "Jméno";
$pgv_lang["search_prtnames"]		= "Jména osob<br />k tisku:";
$pgv_lang["other_searches"]			= "Ostatní vyhledávání";
$pgv_lang["add_to_cart"]		= "Přidat do schránky výstřižků";
$pgv_lang["view_gedcom"]		= "Zobrazit GEDCOM záznam";
$pgv_lang["welcome"]			= "Vítejte";
$pgv_lang["son"]			= "Syn";
$pgv_lang["daughter"]			= "Dcera";
$pgv_lang["welcome_page"]	= "Úvodní stránka";
$pgv_lang["editowndata"]		= "Můj účet";
$pgv_lang["user_admin"]			= "Správa uživatelů";
$pgv_lang["manage_media"]			= "Správa multi-médií";
$pgv_lang["search_general"]			= "Obecné vyhledávání";
$pgv_lang["clipping_privacy"]		= "Některé položky nemohly být přidány kvůli privacy";
$pgv_lang["chart_new"]				= "Rodokmen graf";
$pgv_lang["loading"]				= "Nakládání...";
$pgv_lang["clear_chart"]			= "Vymazat graf";
$pgv_lang["file_information"]		= "Informace o souboru";
$pgv_lang["choose_file_type"]		= "Typ souboru";
$pgv_lang["add_individual_by_id"]	= "Přidat osoby podle ID";
$pgv_lang["advanced_options"]		= "Rozšířené možnosti";
$pgv_lang["zip_files"]				= "Zip soubor(y)";
$pgv_lang["include_media"]			= "Zahrnout média (automaticky zipy soubory)";
$pgv_lang["roman_surn"]				= "Příjmení v latinkou";
$pgv_lang["roman_givn"]				= "Křestní jména v latinkou";
$pgv_lang["include"]			= "Zahrnuto:";
$pgv_lang["page_x_of_y"]			= "Stránka #GLOBALS[currentPage]# ze #GLOBALS[lastPage]#";
$pgv_lang["options"]			= "Volby:";
$pgv_lang["config_update_ok"]		= "Konfigurační soubor byl úspěšně aktualizován.";
$pgv_lang["page_size"]				= "Velikost stránky";
$pgv_lang["font"]					= "Font";
$pgv_lang["use_colors"]				= "Používat barvy";
$pgv_lang["record_not_found"]		= "Nepodařilo se najít požadovaný záznam GEDCOM. Mohlo by to být způsobeno napojením na neexistující osobu nebo poškozeným souborem GEDCOM.";
$pgv_lang["result_page"]			= "Výsledná stránka";
$pgv_lang["edit_media"]				= "Upravit média bod (#GLOBALS[pid]#)";
$pgv_lang["wiki_main_page"]			= "Wiki hlavní stránka";
$pgv_lang["wiki_users_guide"]		= "Wiki příručka uživatelská";
$pgv_lang["wiki_admin_guide"]		= "Wiki příručka administrátora";
$pgv_lang["no_search_for"]			= "Ujistěte se, že vybrat možnost vyhledávání.";
$pgv_lang["no_search_site"]			= "Ujistěte se, že vybrat alespoň jednu vzdálené webové místo.";
$pgv_lang["search_sites"] 			= "Weby společnosti pro vyhledávání";
$pgv_lang["site_list"]				= "Webové stránky:";
$pgv_lang["site_had"]				= "obsahoval následující";
$pgv_lang["label_search_engine_detected"]  = "Hledat stroj detekována";

$pgv_lang["ex-spouse"] = "Bývalý partner";
$pgv_lang["ex-wife"] = "Bývalá manželka";
$pgv_lang["ex-husband"] = "Bývalý manžel";
$pgv_lang["noemail"] 				= "Adresy bez e-mailu";
$pgv_lang["onlyemail"] 				= "Pouze adres e-mailu";
$pgv_lang["maxviews_exceeded"]		= "Povolené zobrazení stránky sazba #GLOBALS[MAX_VIEWS]# na #GLOBALS[MAX_VIEW_TIME]# sekundy překročen.";
$pgv_lang["broadcast_not_logged_6mo"]	= "Poslat zprávu uživatelům, kteří nejsou přihlášeni v po dobu 6 měsíců";
$pgv_lang["broadcast_never_logged_in"]	= "Poslat zprávu uživatelům, kteří nikdy přihlášené";
$pgv_lang["stats_to_show"]			= "Vyberte statistiky pro zobrazení v tomto bloku";
$pgv_lang["stat_avg_age_at_death"]	= "Průměrný věk úmrtí";
$pgv_lang["stat_longest_life"]		= "Osoba, která žila nejdéle";
$pgv_lang["stat_most_children"]		= "Rodina s nejvyšším počtem dětí";
$pgv_lang["stat_average_children"]	= "Průměrný počet dětí v rodině";
$pgv_lang["stat_events"]			= "Celkový počet událostí";
$pgv_lang["stat_media"]				= "Počet objektů typu média";
$pgv_lang["stat_surnames"]			= "Počet příjmení";
$pgv_lang["stat_users"]				= "Počet uživatelů";
$pgv_lang["no_family_facts"]		= "Nejsou žádná fakta pro tuto rodinu.";
$pgv_lang["stat_males"]				= "Muži";
$pgv_lang["stat_females"]			= "Ženy";
$pgv_lang["stat_unknown"]			= "Neznámé";
$pgv_lang["stat_link"]				= "Ukázat statistiky ve formě grafů";
$pgv_lang["print_stat_link"]		= "Ukázat napojení na statistiky?";

$pgv_lang["sunday_1st"]				= "Ne";
$pgv_lang["monday_1st"]				= "Po";
$pgv_lang["tuesday_1st"]			= "Út";
$pgv_lang["wednesday_1st"]			= "St";
$pgv_lang["thursday_1st"]			= "Čt";
$pgv_lang["friday_1st"]				= "Pá";
$pgv_lang["saturday_1st"]			= "So";

$pgv_lang["jan_1st"]				= "Led";
$pgv_lang["feb_1st"]				= "Úno";
$pgv_lang["mar_1st"]				= "Bře";
$pgv_lang["apr_1st"]				= "Dub";
$pgv_lang["may_1st"]				= "Kvě";
$pgv_lang["jun_1st"]				= "Červn";
$pgv_lang["jul_1st"]				= "Červc";
$pgv_lang["aug_1st"]				= "Srp";
$pgv_lang["sep_1st"]				= "Zář";
$pgv_lang["oct_1st"]				= "Říj";
$pgv_lang["nov_1st"]				= "Lis";
$pgv_lang["dec_1st"]				= "Pro";

$pgv_lang["edit_source"]			= "Upravit zdroj";
$pgv_lang["edit_shared_note"]		= "Upravit sdílenou poznámku";
$pgv_lang["familybook_chart"]		= "Rodina sešit graf";
$pgv_lang["family_of"]				= "Rodina&nbsp;";
$pgv_lang["descent_steps"]			= "Klesání kroky";

$pgv_lang["cancel"]			= "Zrušit";
$pgv_lang["cookie_help"]			= "Tato stránka používá cookies ke sledování vašeho stavu přihlášení.<br /><br />Cookies nezdají být povoleny ve vašem prohlížeči. Musíte povolit soubory cookie pro tento web, než budete moci přihlásit. Můžete poradit prohlížeče nápovědy dokumentaci informace o povolení cookies.";
//new stuff
//Individual
$pgv_lang["indi_is_remote"]			= "Informace o této osobě byla spojena ze vzdáleného webu.";
$pgv_lang["link_remote"]            = "Připojit vzdálenou osobu";
//Add Remote Link
$pgv_lang["title_search_link"]      = "Přidat místní link";
$pgv_lang["label_site_url2"]        = "URL webové stránky";
//new stuff

$pgv_lang["delete_family_confirm"]	= "Odstranění rodinu bude odpojit všechny osoby od sebe, ale bude nechat osoby v místě. Jste si jisti, že chcete smazat tuto rodinu?";
$pgv_lang["delete_family"]			= "Zrušit rodinu";
$pgv_lang["add_favorite"]			= "Přidat nový oblíbené";
$pgv_lang["url"]					= "URL";
$pgv_lang["add_fav_enter_note"]		= "Zadejte volitelnou poznámku o tuto oblíbenou";
$pgv_lang["add_fav_or_enter_url"]	= "NEBO<br />\nURL a název";
$pgv_lang["add_fav_enter_id"]		= "Zadejte ID osoba, rodina, nebo zdroj";
$pgv_lang["next_email_sent"]		= "Další e-mail se upomínka zaslána po";
$pgv_lang["last_email_sent"]		= "Poslední e-mail byla zaslána upomínka k ";
$pgv_lang["remove_child"]			= "Odebrat toto dítě z rodiny";
$pgv_lang["link_new_husb"]			= "Přidat manžela pomocí existujícího osobu";
$pgv_lang["link_new_wife"]			= "Přidat manželku pomocí existujícího osoba";
$pgv_lang["address_labels"]			= "Etikety s adresami";
$pgv_lang["filter_address"]			= "Zobrazit adresy, které obsahují:";
$pgv_lang["address_list"]			= "Seznam adres";
$pgv_lang["index_edit_advice"]		= "Zvýrazněte název bloku a poté klikněte na jednu z šipek ikon přesunout tento zvýrazněný blok v naznačeném směru.";
$pgv_lang["changelog"]				= "Změny ve verzi #VERSION#";
$pgv_lang["html_block_descr"]		= "To je jednoduchý HTML blok, který můžete umístit na své stránky přidat nějaký druh zprávy, možná budete chtít.";
$pgv_lang["html_block_sample_part1"]	= "<p class=\"blockhc\"><b>Dejte si titul tady</b></p><br /><p>Klepněte na tlačítko Konfigurovat";
$pgv_lang["html_block_sample_part2"]	= "změnit to, co se vytiskne zde.";
$pgv_lang["html_block_name"]		= "HTML";
$pgv_lang["htmlplus_block_name"]	= "Zdokonalený HTML";
$pgv_lang["htmlplus_block_descr"]	= "Toto je HTML blok, který můžete umístit na své stránky přidat nějaký druh zprávy, možná budete chtít. Můžete vložit odkazy na informace z vašeho GEDCOM do HTML textu.";
$pgv_lang["htmlplus_block_templates"] = "šablony";
$pgv_lang["htmlplus_block_content"] = "obsah";
$pgv_lang["htmlplus_block_narrative"] = "Narativní styl (pouze v angličtině)";
$pgv_lang["htmlplus_block_custom"]	= "Zhotovený na zakázku";
$pgv_lang["htmlplus_block_keyword"]	= "Klíčové slovo příklady (pouze v angličtině)";
$pgv_lang["htmlplus_block_taglist"]	= "Seznam tagů";
$pgv_lang["htmlplus_block_compat"]	= "Kompatibilní režim";
$pgv_lang["htmlplus_block_ui"]		= "Rozšířené rozhraní";
$pgv_lang["htmlplus_block_current"]	= "stávající";
$pgv_lang["htmlplus_block_default"]	= "standardní";
$pgv_lang["htmlplus_block_gedcom"]	= "Strom rodiny";
$pgv_lang["htmlplus_block_birth"]	= "narození";
$pgv_lang["htmlplus_block_death"]	= "úmrtí";
$pgv_lang["htmlplus_block_marrage"]	= "sňatek";
$pgv_lang["htmlplus_block_adoption"]= "adopce";
$pgv_lang["htmlplus_block_burial"]	= "pohřeb";
$pgv_lang["htmlplus_block_census"]	= "sčítání lidu";
$pgv_lang["num_to_show"]			= "Počet položek na zobrazení";
$pgv_lang["days_to_show"]			= "Počet dní na zobrazení";
$pgv_lang["before_or_after"]		= "Umístěte počty před nebo za jménem?";
$pgv_lang["before"]					= "před";
$pgv_lang["after"]					= "po";
$pgv_lang["config_block"]			= "Konfigurace";
$pgv_lang["enter_comments"]			= "Prosím zadejte svůj vztah k údajům v poli Komentář.";
$pgv_lang["comments"]				= "Komentář";
$pgv_lang["child-family"]			= "Rodiče a sourozenci";
$pgv_lang["spouse-family"]			= "Partneři a děti";
$pgv_lang["direct-ancestors"]		= "Přímí předci";
$pgv_lang["ancestors"]				= "Přímí předci a jejich rodiny";
$pgv_lang["descendants"]			= "Potomci";
$pgv_lang["choose_relatives"]		= "Vybrat příbuzné";
$pgv_lang["relatives_report"]		= "Výpis příbuzných";
$pgv_lang["total_unknown"]			= "Neznámý";
$pgv_lang["total_living"]			= "Žijící";
$pgv_lang["total_dead"]				= "Nežijící";
$pgv_lang["total_not_born"]			= "Narozený mrtvý";
$pgv_lang["remove_custom_tags"]		= "Vypustit privátní PGV tagy? (např. _PGVU, _THUM)";
$pgv_lang["fams_with_surname"]		= "Rodiny s příjmením #surname#";
$pgv_lang["support_contact"]		= "Kontakt pro technickou pomoc";
$pgv_lang["genealogy_contact"]		= "Kontakt pro genealogii";
$pgv_lang["common_upload_errors"]	= "Tato chyba pravděpodobně znamená, že soubor, který se snažil nahrát překročila limit stanovený svého hostitele. Výchozí limit je v PHP 2 MB Můžete se obrátit na svého hostitele Podpora skupinu nechat zvýšit limit v souboru php.ini, nebo můžete nahrát soubor pomocí FTP. Pomocí <a href=\"uploadgedcom.php?action=add_form\"><b>Přidat GEDCOM</b></a>, přidat GEDCOM soubor, který jste nahráli pomocí FTP.";
$pgv_lang["total_memory_usage"]		= "Spotřeba paměti:";
$pgv_lang["mothers_family_with"]	= "Matčina rodina s ";
$pgv_lang["fathers_family_with"]	= "Otcova rodina s ";
$pgv_lang["family_with"]		= "Rodina s";
$pgv_lang["halfsibling"]			= "nevlastní sourozenec";
$pgv_lang["halfbrother"]			= "Nevlastní bratr";
$pgv_lang["halfsister"]				= "Nevlastní sestra";
$pgv_lang["family_timeline"]		= "Ukázat rodinu na časové ose";
$pgv_lang["children_timeline"]		= "Ukázat děti na časové ose";
$pgv_lang["other"]					= "Ostatní";
$pgv_lang["others"]					= "Ostatní";
$pgv_lang["sort_by_marriage"]		= "Seřadit podle data sňatku";
$pgv_lang["reorder_families"]		= "Přeskupit rodiny";
$pgv_lang["indis_with_surname"]		= "Osoby s příjmením #surname#";
$pgv_lang["first_letter_name"]		= "Vyberte písmeno pro zobrazení rodin jejichž jména začínají tímto písmenem.";
$pgv_lang["first_letter_sfname"]	= "Vyberte písmeno pro zobrazení rodin, kde vlastní jméno partner začíná tímto písmenem.|";
$pgv_lang["first_letter_iname"]		= "Vyberte písmeno pro zobrazení osob jejichž příjmení začíná tímto písmenem.";
$pgv_lang["first_letter_fname"]		= "Vyberte písmeno pro zobrazení osob jejichž jméno začíná tímto písmenem.";
$pgv_lang["total_names"]			= "Celkově jména";
$pgv_lang["total_changes"]			= "Celkově změn";
$pgv_lang["total_links"]			= "Celkově napojení";
$pgv_lang["top10_pageviews_nohits"]	= "Momentálně zde nejsou žádné hity, které ukazují.";
$pgv_lang["top10_pageviews_msg"]	= "Hit čítače musí být povoleno v GEDCOM konfiguraci, #pgv_lang[displ_conf]# oddílu, #pgv_lang[displ_hide_conf]# skupinu.";
$pgv_lang["review_changes_descr"]	= "Až do změny blok se bude dát uživatelům s právy Upravit seznam záznamů, které byly změněny on-line, a že je třeba ještě přezkoumat a potvrzuji. Tyto změny jsou projednávány přijetí nebo odmítnutí. Pokud tento blok je povolen, budou uživatelé s právy Akceptovat obdržíte e-mail, jakmile denně oznámením, že změny je třeba přezkoumat.";
$pgv_lang["review_changes_block"]	= "Nevyřízené změny";
$pgv_lang["review_changes_email"]	= "Vyšlete připomenutí e-maily?";
$pgv_lang["review_changes_email_freq"]	= "Frekvence připomenutí e-mailů (dny)";
$pgv_lang["review_changes_subject"]	= "PhpGedView - recenze změny";
$pgv_lang["review_changes_body"]	= "On-line změny byly provedeny na genealogické databáze. Tyto změny musí být přezkoumány a potvrzuji před tím, než se zobrazí všem uživatelům. Prosím, použijte adresu URL níže do tohoto PhpGedView stránky a přihlaste se přezkoumat změny.";
$pgv_lang["show_pending"]		= "Zobrazit nevyřízené změny";
$pgv_lang["show_spouses"]		= "Ukázat partneři";
$pgv_lang["quick_update_title"] = "Rychlé aktualizace";
$pgv_lang["quick_update_instructions"] = "Tato stránka vám umožní rychle aktualizovat informace o jednotlivce. Jediné, co potřebujete, aby vyplnit informace, které jsou nové nebo které se změnilo od toho, co je v současné době v databázi. Poté, co se změny byly předloženy mají být přezkoumány správce před tím, než se stanou viditelné pro všechny.";
$pgv_lang["update_name"] = "Aktualizace jméno";
$pgv_lang["update_fact"] = "Aktualizace fakt";
$pgv_lang["update_fact_restricted"] = "Aktualizace této fakt je omezen:";
$pgv_lang["select_fact"] = "Vyberte si fakt...";
$pgv_lang["update_address"] = "Aktualizace adresa";
$pgv_lang["top10_pageviews_descr"]	= "Tento blok se zobrazí 10 záznamy, které byly prohlédli nejvíce. Tento blok vyžaduje, aby Hit Čítače být aktivována v nastavení konfigurace GEDCOM.";
$pgv_lang["top10_pageviews"]		= "Nejsledovanější položky";
$pgv_lang["top10_pageviews_block"]		= "Nejsledovanější položky";
$pgv_lang["stepparent"]				= "Nevlastní rodič";
$pgv_lang["stepdad"]				= "Nevlastní otec";
$pgv_lang["stepmom"]				= "Nevlastní matka";
$pgv_lang["stepsister"]				= "Nevlastní sestra";
$pgv_lang["stepbrother"]			= "Nevlastní bratr";
$pgv_lang["fams_charts"]			= "Možnosti pro rodinu";
$pgv_lang["indis_charts"]			= "Možnosti pro osoby";
$pgv_lang["none"]				= "Žádná";
$pgv_lang["facts"]					= "Fakta";
$pgv_lang["locked"]					= "Neměňte";
$pgv_lang["privacy"]				= "soukromí";
$pgv_lang["number_sign"]			= "#";

//-- GENERAL HELP MESSAGES
$pgv_lang["qm"]				= "?";
$pgv_lang["qm_ah"]			= "?";
$pgv_lang["page_help"]			= "Nápověda";
$pgv_lang["help_for_this_page"]		= "Nápověda k této stránce";
$pgv_lang["help_contents"]		= "Obsah nápovědy";
$pgv_lang["show_context_help"]		= "Zobrazit kontextovou nápovědu";
$pgv_lang["hide_context_help"]		= "Skrýt kontextovou nápovědu";
$pgv_lang["sorry"]			= "<b>Nápověda k této stránce či položce ještě bohužel nebyla dokončena</b>";
$pgv_lang["help_not_exist"]		= "<b>Nápověda k této stránce či položce zatím není k dispozici</b>";
$pgv_lang["var_not_exist"]			= "<span style=\"font-weight: bold\">Jazyk proměnná neexistuje. Prosím oznamte to, jak to je chyba.</span>";
$pgv_lang["resolution"]			= "Rozlišení obrazovky";
$pgv_lang["menu"]			= "Menu";
$pgv_lang["header"]			= "Záhlaví";
$pgv_lang["imageview"]			= "Prohlížeč obrázků";

//-- CONFIG FILE MESSAGES
$pgv_lang["login_head"]			= "Přihlášení uživatele PhpGedView";
$pgv_lang["for_support"]		= "Pro technickou podporu a další informace kontaktujte";
$pgv_lang["for_contact"]		= "S dotazy k rodokmenu se obracejte na";
$pgv_lang["for_all_contact"]		= "Pro technickou podporu nebo s dotazy k rodokmenu prosím kontaktujte";
$pgv_lang["choose_username"]		= "Požadované Uživatelské jméno";
$pgv_lang["username"]			= "Uživatelské jméno";
$pgv_lang["invalid_username"]		= "Uživatelské jméno obsahuje neplatné znaky";
$pgv_lang["firstname"]				= "Jméno";
$pgv_lang["lastname"]				= "Příjmení";
$pgv_lang["choose_password"]		= "Jaké chcete heslo";
$pgv_lang["password"]			= "Heslo";
$pgv_lang["confirm"]			= "Potvrzení hesla";
$pgv_lang["login"]			= "Přihlásit se";
$pgv_lang["logout"]			= "Odhlásit se";
$pgv_lang["admin"]			= "Správce";
$pgv_lang["logged_in_as"]		= "Přihlášen jako ";
$pgv_lang["my_pedigree"]		= "Můj vývod";
$pgv_lang["my_indi"]			= "Můj osobní záznam";
$pgv_lang["yes"]			= "Ano";
$pgv_lang["no"]				= "Ne";
$pgv_lang["change_theme"]		= "Změna motivu";

//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]	= "Vývod";
$pgv_lang["gen_ped_chart"]	= "#PEDIGREE_GENERATIONS# - generační schéma";
$pgv_lang["generations"]	= "Počet generací";
$pgv_lang["view"]		= "Zobrazit";
$pgv_lang["fam_spouse"]		= "Rodina s partner";
$pgv_lang["rootid"]			= "Střen (proband) vývodu";
$pgv_lang["root_person"]	= "ID výchozí osoby";
$pgv_lang["hide_details"]	= "Skrýt podrobnosti";
$pgv_lang["show_details"]	= "Ukázat podrobnosti";
$pgv_lang["zoom_box"]		= "Zvětšení/zmenšení tohoto rámečku.";
$pgv_lang["orientation"]			= "Orientace";
$pgv_lang["portrait"]		= "Na výšku";
$pgv_lang["landscape"]		= "Na šířku";
$pgv_lang["landscape_top"]			= "Nejstarší nahoře";
$pgv_lang["landscape_down"]			= "Nejstarší dole";
$pgv_lang["start_at_parents"]	= "Začít u rodičů";
$pgv_lang["charts"]		= "Schémata";
$pgv_lang["lists"]		= "Seznamy";
$pgv_lang["box_width"] 				= "Šířka rámečku";
$pgv_lang["random_surn"]			= "Náhodné příjmení";
$pgv_lang["generation_number"]		= "Generace";

//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"]	= "Není možné nalézt rodinu s id";
$pgv_lang["unable_to_find_record"]	= "Není možné nalézt záznam s id";
$pgv_lang["title"]			= "Nadpis";
$pgv_lang["living"]			= "Žijící osoba";
$pgv_lang["private"]			= "Soukromé";
$pgv_lang["birth"]			= "Narození:";
$pgv_lang["death"]			= "Úmrtí:";
$pgv_lang["descend_chart"]		= "Rozrod";
$pgv_lang["individual_list"]		= "Osoby";
$pgv_lang["family_list"]		= "Rodiny";
$pgv_lang["branch_list"]			= "Větve";
$pgv_lang["source_list"]		= "Zdroje";
$pgv_lang["shared_note_list"]		= "Sdílené poznámky";
$pgv_lang["place_list"]			= "Hierarchie míst";
$pgv_lang["place_list_aft"] 		= "Hierarchie míst podle";
$pgv_lang["media_list"]			= "Seznam multimédií";
$pgv_lang["repo_list"]				= "Repozitářů";
$pgv_lang["search"]			= "Hledat";
$pgv_lang["clippings_cart"]		= "Schránka výstřižků";
$pgv_lang["print_preview"]		= "Tiskový režim";
$pgv_lang["cancel_preview"]		= "Zpět do normálního zobrazení";
$pgv_lang["change_lang"]		= "Změnit jazyk";
$pgv_lang["print"]			= "Vytisknout";
$pgv_lang["total_queries"]		= "Celkový počet dotazů na databázi: ";
$pgv_lang["total_privacy_checks"]	= "Úplných kontrol privátnosti celkem:";
$pgv_lang["back"]			= "Zpět";

//-- INDIVIDUAL FILE MESSAGES
$pgv_lang["aka"]			= "alias";
$pgv_lang["male"]			= "Muž";
$pgv_lang["males"]					= "Muži";
$pgv_lang["female"]			= "Žena";
$pgv_lang["females"]				= "Ženy";
$pgv_lang["temple"]			= "Chrám CJKSPD";
$pgv_lang["temple_code"]		= "Kód Chrámu CJKSPD:";
$pgv_lang["status"]			= "Stav";
$pgv_lang["source"]			= "Zdroj";
$pgv_lang["text"]			= "Zdrojový text:";
$pgv_lang["note"]			= "Poznámka";
$pgv_lang["NN"]				= "(Příjmení neznámé)";
$pgv_lang["PN"]				= "(Jméno neznámé)";
$pgv_lang["NNPN"]			= "(Jméno a příjmení neznámé)";
// $pgv_lang["NNhebrew"] 		use value from lang.en.php
// $pgv_lang["PNhebrew"] 		use value from lang.en.php
// $pgv_lang["NNPNhebrew"] 		use value from lang.en.php
// $pgv_lang["NNarabic"] 		use value from lang.en.php
// $pgv_lang["PNarabic"] 		use value from lang.en.php
// $pgv_lang["NNPNarabic"] 		use value from lang.en.php
// $pgv_lang["NNgreek"] 		use value from lang.en.php
// $pgv_lang["PNgreek"] 		use value from lang.en.php
// $pgv_lang["NNPNgreek"] 		use value from lang.en.php
// $pgv_lang["NNrussian"] 		use value from lang.en.php
// $pgv_lang["PNrussian"] 		use value from lang.en.php
// $pgv_lang["NNPNrussian"] 	use value from lang.en.php
// $pgv_lang["NNchinese"] 		use value from lang.en.php
// $pgv_lang["PNchinese"] 		use value from lang.en.php
// $pgv_lang["NNPNchinese"] 	use value from lang.en.php
// $pgv_lang["NNvietnamese"] 	use value from lang.en.php
// $pgv_lang["PNvietnamese"] 	use value from lang.en.php
// $pgv_lang["NNPNvietnamese"] 	use value from lang.en.php
// $pgv_lang["NNthai"] 			use value from lang.en.php
// $pgv_lang["PNthai"] 			use value from lang.en.php
// $pgv_lang["NNPNthai"] 		use value from lang.en.php
$pgv_lang["NNother"]			= "(Příjmení neznámé)";
$pgv_lang["PNother"]			= "(Jméno neznámé)";
$pgv_lang["NNPNother"]			= "(Jméno a příjmení neznámé)";
$pgv_lang["unrecognized_code"]		= "Nebyl rozpoznán GEDCOM kód";
$pgv_lang["unrecognized_code_msg"]	= "Došlo k chybě. Rádi bychom ji opravili. Prosím informujte nás o tomto problému na ";
$pgv_lang["indi_info"]			= "Informace o osobě";
$pgv_lang["pedigree_chart"]		= "Vývod";
$pgv_lang["individual"]				= "Osoba";
$pgv_lang["as_spouse"]			= "Rodina s partner";
$pgv_lang["privacy_error"]		= "Podrobnosti o této osobě jsou soukromé.";
$pgv_lang["more_information"]		= "Pro další informace kontaktujte";
$pgv_lang["given_name"]			= "Křestní jméno:";
$pgv_lang["surname"]			= "Příjmení:";
$pgv_lang["suffix"]			= "Suffix:";
$pgv_lang["sex"]			= "Pohlaví";
$pgv_lang["personal_facts"]		= "Osobní údaje a podrobnosti";
$pgv_lang["type"]			= "Typ";
$pgv_lang["parents"] 			= "Rodiče:";
$pgv_lang["gparents"]				= "Prarodiče";
$pgv_lang["siblings"] 			= "Sourozenci";
$pgv_lang["father"] 			= "Otec";
$pgv_lang["mother"] 			= "Matka";
$pgv_lang["parent"] 				= "Rodič";
$pgv_lang["parent_age"] 			= "Věk rodiče";
$pgv_lang["father_age"]				= "Věk otce";
$pgv_lang["mother_age"]				= "Věk matky";
$pgv_lang["self"] 					= "Já";
$pgv_lang["relatives"]			= "Blízcí příbuzní";
$pgv_lang["relatives_events"]		= "Události blízkých příbuzných";
$pgv_lang["historical_facts"]		= "Historická fakta";
$pgv_lang["partner"] 				= "Partner";
$pgv_lang["spouse"]			= "Partner";
$pgv_lang["spouses"] 				= "Partneři";
$pgv_lang["surnames"]			= "Příjmení";
$pgv_lang["adopted"]			= "Adoptován";
$pgv_lang["foster"]			= "Pěstoun";
$pgv_lang["sealing"]			= "Sealing (náb.)";
$pgv_lang["challenged"]				= "Vyžádaný";
$pgv_lang["disproved"]				= "Vyvrácený";
$pgv_lang["infant"]					= "Dětský";
$pgv_lang["stillborn"]				= "Narozený mrtvý";
$pgv_lang["deceased"]				= "Zemřelý";
$pgv_lang["link_as_wife"]			= "Napojit tuto osobu na existující rodinu jako manželku";
$pgv_lang["no_tab1"]				= "K této osobě nejsou dostupné žádné údaje.";
$pgv_lang["no_tab2"]				= "K této osobě nejsou žádné poznámky.";
$pgv_lang["no_tab3"]				= "K této osobě nejsou žádné citace pramenů.";
$pgv_lang["no_tab4"]				= "K této osobě nejsou k dispozici žádné obrázky.";
$pgv_lang["no_tab5"]				= "K této osobě nejsou dostupní žádní blízcí příbuzní.";
$pgv_lang["no_tab6"]				= "Nejsou k dispozici žádné výzkumy přihlásí připojuje k této osobě.";
$pgv_lang["show_fact_sources"]		= "Ukázat všechny zdroje";
$pgv_lang["show_fact_notes"]		= "Ukázat všechny poznámky";

//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"]		= "Informace o rodině";
$pgv_lang["family_group_info"]		= "Informace o rodině (manželství)";
$pgv_lang["husband"]			= "Manžel";
$pgv_lang["wife"]			= "Manželka";
$pgv_lang["marriage"]			= "Sňatek:";
$pgv_lang["lds_sealing"]		= "Sealing CJKSPD:";
$pgv_lang["marriage_license"]		= "Povolení k sňatku:";
$pgv_lang["no_children"]		= "Žádné zaznamenané děti";
$pgv_lang["known_child"]			= "1 dítě";
$pgv_lang["known_children"]			= "dětí";
$pgv_lang["childless_family"]		= "Tato rodina je bezdětná";
$pgv_lang["parents_timeline"]		= "Ukázat pár na<br />časové ose";

//-- CLIPPINGS FILE MESSAGES
$pgv_lang["clip_cart"]			= "Schránka výstřižků";
$pgv_lang["which_links"]		= "Které vztahy z této rodiny byste ještě rádi přidali?";
$pgv_lang["just_family"]		= "Přidat jen tento rodinný záznam.";
$pgv_lang["parents_and_family"]		= "Přidat rodiče s tímto rodinným záznamem.";
$pgv_lang["parents_and_child"]		= "Přidat záznamy rodičů a dětí s tímto rodinným záznamem.";
$pgv_lang["parents_desc"]		= "Přidat všechny záznamy rodičů a všech potomků s tímto rodinným záznamem.";
$pgv_lang["continue"]			= "Pokračovat v přidávání";
$pgv_lang["which_p_links"]		= "Které vztahy této osoby byste chtěli také přidat?";
$pgv_lang["just_person"]		= "Přidat jen tuto osobu.";
$pgv_lang["person_parents_sibs"]	= "Přidat tuto osobu, její rodiče a sourozence.";
$pgv_lang["person_ancestors"]		= "Přidat tuto osobu a její předky v přímé linii.";
$pgv_lang["person_ancestor_fams"]	= "Přidat tuto osobu, její předky v přímé linii a jejich rodiny.";
$pgv_lang["person_spouse"]		= "Přidat tuto osobu, jejího partner a děti.";
$pgv_lang["person_desc"]		= "Přidat tuto osobu, jejího partner a všechny potomky.";
$pgv_lang["which_s_links"]			= "Záznamy, které souvisí s touto zdroje by měly být přidány?";
$pgv_lang["just_source"]			= "Přidat pouze tento zdroj.";
$pgv_lang["linked_source"]			= "Přidat tento zdroj i rodiny nebo osoby k němu napojené.";
$pgv_lang["person_private"]		= "Podrobnosti o této osobě jsou soukromé. Osobní údaje nebudou zahrnuty.";
$pgv_lang["family_private"]		= "Podrobnosti o této rodině jsou soukromé. Rodinné údaje nebudou zahrnuty.";
$pgv_lang["media_private"] 			= "Podrobnosti o tomto médiu jsou soukromé. Mediální údaje nebudou zahrnuty.";
$pgv_lang["download"]			= "Pro stáhnutí souborů klikněte pravým tlačítkem (na Macu control-click) na odkazy dole a označte &quot;Uložit cíl jako&quot;.";
$pgv_lang["cart_is_empty"]		= "Vaše Schránka výstřižků je prázdná.";
$pgv_lang["id"]				= "ID";
$pgv_lang["ID"]				= "ID";
$pgv_lang["name_description"]		= "Jméno / Popis";
$pgv_lang["remove"]			= "Odstranit";
$pgv_lang["empty_cart"]			= "Vyprázdnit schránku";
$pgv_lang["download_now"]		= "Stáhnout";
$pgv_lang["download_file"]	= "Stáhnout soubor";
$pgv_lang["indi_downloaded_from"]	= "Tato osoba byla stažena z:";
$pgv_lang["family_downloaded_from"]	= "Tato rodina byla stažena z:";
$pgv_lang["source_downloaded_from"]	= "Tento zdroj byl stažen z:";
$pgv_lang["enter_person_generations"] = "Počet generací";
$pgv_lang["convertPath"]			= "Převod médií cestu k";
$pgv_lang["convertSlashes"]			= "Převést mediální složky odlučovače na";
$pgv_lang["forwardSlashes"]			= "Normální lomítka : /";
$pgv_lang["backSlashes"]			= "Zpětná lomítka : \\";

//-- PLACELIST FILE MESSAGES
$pgv_lang["connections"]			= "nalezených souvislostí v místech";
$pgv_lang["top_level"]				= "Horní úroveň";
$pgv_lang["form"]				= "Místa jsou zapsána ve tvaru: ";
$pgv_lang["default_form"]			= "město, kraj, stát, země";
$pgv_lang["default_form_info"]			= "(Standard)";
$pgv_lang["unknown"]				= "Neznám";
$pgv_lang["individuals"]			= "Osoby";
$pgv_lang["view_records_in_place"]	= "Zobrazit všechny záznamy spojené s tímto místem";
$pgv_lang["place_list2"] 			= "Seznam míst";
$pgv_lang["show_place_hierarchy"]	= "Zobrazit místa hierarchicky";
$pgv_lang["show_place_list"]		= "Zobrazit všechna místa ze seznamu.";
$pgv_lang["total_unic_places"]		= "Unikátních míst celkem";

//-- MEDIALIST FILE MESSAGES
$pgv_lang["external_objects"]		= "Externí objekty";
$pgv_lang["multi_title"]			= "Seznam multimediálních souborů";
$pgv_lang["media_found"]			= "nalezených mediálních souborů.";
$pgv_lang["view_person"]			= "Zobrazit osobu";
$pgv_lang["view_family"]			= "Zobrazit rodinu";
$pgv_lang["view_source"]			= "Zobrazit zdroj";
$pgv_lang["view_object"]			= "Zobrazit objekt";
$pgv_lang["first_page"]				= "První strana";
$pgv_lang["previous_page"]			= "Předchozí strana";
$pgv_lang["next_page"]				= "Další strana";
$pgv_lang["last_page"]				= "Poslední strana";
$pgv_lang["next_image"]				= "Další obrázek";
$pgv_lang["file_not_found"]			= "Soubor nebyl nalezen.";
$pgv_lang["medialist_show"] 		= "Zobrazit";
$pgv_lang["per_page"]				= "medilních objektů na stránku";
$pgv_lang["media_format"]			= "Formát médií";
$pgv_lang["image_size"]				= "Velikosti obrázku";
$pgv_lang["media_id"]				= "ID médií";
$pgv_lang["invalid_id"]				= "Žádný takový ID existuje v tomto souboru GEDCOM.";
$pgv_lang["record_updated"]			= "Záznam #pid# úspěšně aktualizován.";
$pgv_lang["record_not_updated"]		= "Záznam #pid# nelze aktualizovat.";
$pgv_lang["record_removed"]			= "Záznam #xref# úspěšně odstraněna z GEDCOM.";
$pgv_lang["record_not_removed"]		= "Záznam #xref# nemohly být odstraněny z GEDCOM.";
$pgv_lang["record_added"]			= "Záznam #xref# úspěšně přidán do GEDCOM.";
$pgv_lang["record_not_added"]		= "Záznam #xref# nemohl být přidán do GEDCOM.";

//-- SEARCH FILE MESSAGES
$pgv_lang["soundex_search"]			= "Nebo zkuste zadat jméno tak, jak si myslíte, že se píše (metoda Soundex):";
$pgv_lang["sources"]				= "Zdroje";
$pgv_lang["shared_notes"]			= "Sdílené poznámky";
$pgv_lang["lastname_search"]			= "Příjmení: ";
$pgv_lang["search_place"]			= "Místo: ";
$pgv_lang["search_year"]			= "Rok: ";
$pgv_lang["no_results"]				= "Nenalezen odpovídající záznam.";
$pgv_lang["search_soundex"]			= "Sdílené Soundex";
$pgv_lang["search_replace"]			= "Najít a nahradit";
$pgv_lang["search_sources"]			= "Sdílené Zdroje";
$pgv_lang["search_shared_notes"]	= "Sdílené poznámky";
$pgv_lang["search_more_chars"]      = "Zadejte, prosím, víc než jeden znak";
$pgv_lang["search_soundextype"]		= "Typ Soundex:";
$pgv_lang["search_russell"]			= "Základní";
$pgv_lang["search_tagfilter"]		= "Vyloučit filtr";
$pgv_lang["search_tagfon"]			= "Vyloučit nějaký non-genealogických informací";
$pgv_lang["search_tagfoff"]			= "Ne";
$pgv_lang["associate"]				= "společník";
$pgv_lang["search_record"]			= "Celý záznam";
$pgv_lang["search_to"]				= "na";

//-- SOURCELIST FILE MESSAGES
$pgv_lang["titles_found"]			= "Tituly";
$pgv_lang["find_source"]			= "Najít zdroj";

//-- REPOLIST FILE MESSAGES
$pgv_lang["repository"] 			= "Repozitáře";
$pgv_lang["repos_found"]			= "Repozitáře nalezeno";
$pgv_lang["find_repository"]		= "Najít repozitáře";
$pgv_lang["total_repositories"]		= "Celkem repozitáře";
$pgv_lang["confirm_delete_repo"]	= "Jste si jisti, že chcete smazat tuto repozitáře?";

//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]			= "Informace o zdroji";
$pgv_lang["people"]				= "Lidé";
$pgv_lang["families"]				= "Rodiny";
$pgv_lang["total_sources"]			= "Zdroje celkem";

//-- SHARED NOTE FILE MESSAGES
$pgv_lang["shared_note"]				= "Sdílená poznámka";
$pgv_lang["shared_notes_found"]			= "Sdílených poznámek bylo nalezeno";
$pgv_lang["find_shared_note"]			= "Najít sdílenou poznámku";
$pgv_lang["shared_note_info"]			= "Informace ze sdílené poznámky";
$pgv_lang["total_shared_notes"]			= "Sdílených poznámek celkem";

//-- BUILDINDEX FILE MESSAGES
$pgv_lang["invalid_gedformat"]	= "Neplatný formát (neodpovídá standardu GEDCOM 5.5)";
$pgv_lang["exec_time"]				= "Celkový čas:";
$pgv_lang["unable_to_create_index"]		= "Není možné vytvořit soubor index. Ujistěte se, že máte práva zápisu do složky PhpGedView. Stávající nastavení práv můžete obnovit po zapsání souborů.";
$pgv_lang["changes_present"]		= "Aktuální GEDCOM obsahuje změny čekající na posouzení. Pokud budete pokračovat tento import, budou tyto nevyřízené změny musí být zlikvidován. Měli byste zkontrolovat čekající změny před pokračováním v importu.";
$pgv_lang["sec"]				= "s";

//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$pgv_lang["total_fams"]				= "Všechny rodiny";
$pgv_lang["total_indis"]			= "Všechny osoby";
$pgv_lang["notes"]				= "Poznámky";
$pgv_lang["ssourcess"]				= "Zdroje";
$pgv_lang["media"]				= "Média";
$pgv_lang["name_contains"]			= "Jméno obsahuje:";
$pgv_lang["filter"]				= "Filtr";
$pgv_lang["apply_filter"]			= "Použít filtr";
$pgv_lang["find_individual"]			= "Najít ID osoby";
$pgv_lang["find_familyid"]			= "Najít ID rodiny";
$pgv_lang["find_sourceid"]			= "Najít ID zdroje";
$pgv_lang["find_specialchar"]		= "Najít speciální znaky";
$pgv_lang["magnify"]				= "Zvětšit";
$pgv_lang["skip_surnames"]			= "Přeskočit seznamy příjmení";
$pgv_lang["show_surnames"]			= "Ukázat seznamy příjmení";
$pgv_lang["skip_marnms"]			= "Vyloučit příjmení po sňatku";
$pgv_lang["show_marnms"]			= "Zařadit příjmení po sňatku";
$pgv_lang["all"]				= "VŠECHNY";
$pgv_lang["hidden"]					= "Skryto";
$pgv_lang["confidential"]			= "Důvěrné";
$pgv_lang["alpha_index"]			= "Abecední pořadí";
$pgv_lang["name_list"] 				= "Seznam jmen";
$pgv_lang["firstname_alpha_index"] 	= "Jméno abecední rejstřík";
$pgv_lang["roots"]		 			= "Kořeny";
$pgv_lang["leaves"] 				= "Listy";
$pgv_lang["widow"] 					= "Vdova";
$pgv_lang["widower"] 				= "Vdovec";
$pgv_lang["show_parents"] 			= "Ukázat rodiče";

//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]				= "Věk";
$pgv_lang["husb_age"]				= "Věk manžela";
$pgv_lang["wife_age"]				= "Věk manželky";
$pgv_lang["year1"]					= "rok";
$pgv_lang["years2"]					= "let";	// For Polish 2,3,4 or 22,23,24 or 32,33,34 etc.
$pgv_lang["years"]					= "let";
$pgv_lang["month1"]					= "měsíc";
$pgv_lang["months"]					= "měsíců";
$pgv_lang["week1"]					= "týden";
$pgv_lang["weeks"]					= "týdnů";
$pgv_lang["day1"]					= "den";
$pgv_lang["days"]					= "dní";
$pgv_lang["after_death"]        	= "po úmrtí";
$pgv_lang["at_death_day"]      		= "ke dni úmrtí";
$pgv_lang["timeline_title"]			= "Časová osa PhpGedView";
$pgv_lang["timeline_chart"]			= "Časová osa";
$pgv_lang["remove_person"]			= "Odstranit osobu";
$pgv_lang["show_age"]				= "Zobrazit ukazatel věku";
$pgv_lang["add_another"]			= "Přidat na osu další osobu:<br />ID osoby:";
$pgv_lang["find_id"]				= "Najít ID";
$pgv_lang["show"]				= "Ukázat";
$pgv_lang["year"]				= "Rok:";
$pgv_lang["zoom_in"]				= "Zvětšit";
$pgv_lang["zoom_out"]				= "Zmenšit";
$pgv_lang["timeline_beginYear"] = "Počáteční rok";
$pgv_lang["timeline_endYear"] = "Koncový rok";
$pgv_lang["timeline_scrollSpeed"] = "Rychlost";
$pgv_lang["timeline_controls"] = "Ovládání časové osy";
$pgv_lang["include_family"] = "Zahrnout nejbližší rodinu";
$pgv_lang["lifespan_chart"] = "Životnost graf";

// calendar conversion options
$pgv_lang["cal_none"]                 = "Nepřepočítávat kalendář";
$pgv_lang["cal_gregorian"]            = "Gregoriánský";
$pgv_lang["cal_julian"]               = "Juliánský";
$pgv_lang["cal_french"]               = "Francouzský";
$pgv_lang["cal_jewish"]               = "Židovský";
$pgv_lang["cal_hebrew"]               = "Hebrejský";
$pgv_lang["cal_jewish_and_gregorian"] = "Židovský a gregoriánský";
$pgv_lang["cal_hebrew_and_gregorian"] = "Hebrejský a gregoriánský";
$pgv_lang["cal_hijri"]                = "Muslimský (Hijri)";
$pgv_lang["cal_arabic"]               = "Arabský";

// some religious dates
$pgv_lang["easter"]     = "Velikonoce";
$pgv_lang["ascension"]  = "Nanebevstoupení";
$pgv_lang["pentecost"]  = "Svatodušní neděle";
$pgv_lang["assumption"] = "Svátek Nanebevzetí Marie (15. srpna)";
$pgv_lang["all_saints"] = "Svátech všech svatých (2. listopadu)";
$pgv_lang["christmas"]  = "Vánoce";

// am/pm suffixes for 12 hour clocks
$pgv_lang["a.m."]         = "dopoledne";
$pgv_lang["p.m."]         = "odpoledne";
$pgv_lang["noon"]         = "poledne";
$pgv_lang["midn"]         = "půlnoc";

//-- MONTH NAMES
$pgv_lang["jan"]			= "leden";
$pgv_lang["feb"]			= "únor";
$pgv_lang["mar"]			= "březen";
$pgv_lang["apr"]			= "duben";
$pgv_lang["may"]			= "květen";
$pgv_lang["jun"]			= "červen";
$pgv_lang["jul"]			= "červenec";
$pgv_lang["aug"]			= "srpen";
$pgv_lang["sep"]			= "září";
$pgv_lang["oct"]			= "říjen";
$pgv_lang["nov"]			= "listopad";
$pgv_lang["dec"]			= "prosinec";

// $pgv_lang["vend"]			use value from lang.en.php
// $pgv_lang["brum"]			use value from lang.en.php
// $pgv_lang["frim"]			use value from lang.en.php
// $pgv_lang["nivo"]			use value from lang.en.php
// $pgv_lang["pluv"]			use value from lang.en.php
// $pgv_lang["vent"]			use value from lang.en.php
// $pgv_lang["germ"]			use value from lang.en.php
// $pgv_lang["flor"]			use value from lang.en.php
// $pgv_lang["prai"]			use value from lang.en.php
// $pgv_lang["mess"]			use value from lang.en.php
// $pgv_lang["ther"]			use value from lang.en.php
// $pgv_lang["fruc"]			use value from lang.en.php
// $pgv_lang["comp"]			use value from lang.en.php;

// $pgv_lang["tsh"]				use value from lang.en.php
// $pgv_lang["csh"]				use value from lang.en.php
// $pgv_lang["ksl"]				use value from lang.en.php
// $pgv_lang["tvt"]				use value from lang.en.php
// $pgv_lang["shv"]				use value from lang.en.php
// $pgv_lang["adr"]				use value from lang.en.php
// $pgv_lang["adr_leap_year"]	use value from lang.en.php
// $pgv_lang["ads"]				use value from lang.en.php
// $pgv_lang["nsn"]				use value from lang.en.php
// $pgv_lang["iyr"]				use value from lang.en.php
// $pgv_lang["svn"]				use value from lang.en.php
// $pgv_lang["tmz"]				use value from lang.en.php
// $pgv_lang["aav"]				use value from lang.en.php
// $pgv_lang["ell"]				use value from lang.en.php

// $pgv_lang["muhar"]			use value from lang.en.php
// $pgv_lang["safar"]			use value from lang.en.php
// $pgv_lang["rabia"]			use value from lang.en.php
// $pgv_lang["rabit"]			use value from lang.en.php
// $pgv_lang["jumaa"]			use value from lang.en.php
// $pgv_lang["jumat"]			use value from lang.en.php
// $pgv_lang["rajab"]			use value from lang.en.php
// $pgv_lang["shaab"]			use value from lang.en.php
// $pgv_lang["ramad"]			use value from lang.en.php
// $pgv_lang["shaww"]			use value from lang.en.php
// $pgv_lang["dhuaq"]			use value from lang.en.php
// $pgv_lang["dhuah"]			use value from lang.en.php

$pgv_lang["b.c."]         = "př.n.l.";

$pgv_lang["abt"]			= "kolem";
$pgv_lang["aft"]			= "po";
$pgv_lang["and"]			= "a";
$pgv_lang["bef"]			= "před";
$pgv_lang["bet"]			= "mezi";
$pgv_lang["cal"]			= "odhadnuto";
$pgv_lang["est"]			= "přibližně";
$pgv_lang["from"]			= "od";
$pgv_lang["int"]			= "interpretováno";
$pgv_lang["to"]				= "do";
$pgv_lang["cir"]			= "asi";
$pgv_lang["apx"]			= "přibl.";

//-- Admin File Messages
$pgv_lang["password_mismatch"]		= "Hesla se neshodují.";
$pgv_lang["enter_username"]		= "Musíte vložit uživatelské jméno.";
$pgv_lang["enter_password"]		= "Musíte vložit heslo.";
$pgv_lang["save"]			= "Uložit";
$pgv_lang["saveandgo"]		= "Uložit a jít na nový záznam";
$pgv_lang["delete"]			= "Smazat";
$pgv_lang["edit"]			= "Úpravy";
$pgv_lang["no_login"]			= "Není možné ověřit uživatele.";
$pgv_lang["basic_realm"]			= "Systém autentizace PhpGedView";
$pgv_lang["basic_auth_failure"]		= "Musíte zadat platné přihlašovací jméno a heslo pro přístup k tomuto prostředky";
$pgv_lang["basic_auth"]				= "Základní autentifikace";
$pgv_lang["digest_auth"]				= "Přehled autentizace"; //not used in code yet
$pgv_lang["no_auth_needed"]			= "Žádný autentizace";
$pgv_lang["file_not_exists"]	= "Soubor, jehož název jste zadali, neexistuje.";
$pgv_lang["research_assistant"]		= "Odborný pracovník";
$pgv_lang["utf8_to_ansi"]		= "Chcete změnit kódování v tomto GEDCOM souboru z UTF-8 na ANSI (ISO-8859-1)?";
$pgv_lang["media_linked"]			= "Tento objekt média souvisí s následujícím:";
$pgv_lang["media_not_linked"]		= "Tento objekt méda není spojen s žádnou záznam GEDCOM.";
$pgv_lang["media_dir_1"]			= "Tento objekt média se nachází na externím serveru";
$pgv_lang["media_dir_2"]			= "Tento objekt média je ve standardním adresáři médií";
$pgv_lang["media_dir_3"]			= "Tento objekt média je ve chráněném adresáři médií";
$pgv_lang["thumb_dir_1"]			= "Tato miniatura se nachází na externím serveru";
$pgv_lang["thumb_dir_2"]			= "Tento miniatura je ve standardním adresáři médií";
$pgv_lang["thumb_dir_3"]			= "Tento miniatura je ve chráněném adresáři médií";
$pgv_lang["moveto_2"]				= "Přesunout do chráněné adresáře";
$pgv_lang["moveto_3"]				= "Přesunout do standardního adresáře";
$pgv_lang["move_standard"]			= "Přesunout do standardního";
$pgv_lang["move_protected"]			= "Přesunout do chráněné";
$pgv_lang["move_mediadirs"]			= "Přesun adresáře médií";
$pgv_lang["setperms"]				= "Nastavení oprávnění médií";
$pgv_lang["setperms_fix"]			= "Opravit oprávnění čtení/zápis/execute";
$pgv_lang["setperms_success"]		= "Oprávnění nastavena";
$pgv_lang["setperms_failure"]		= "Oprávnění není nastavena";
$pgv_lang["setperms_time_exceeded"]	= "Doba provádění byl dosažen limit. Zkuste příkaz znovu na menší adresáře.";
$pgv_lang["move_time_exceeded"]		= "Doba provádění byl dosažen limit. Zkuste příkaz znovu přesunout zbytek souborů.";
$pgv_lang["media_firewall_rootdir_no_exist"]			= "Firewall média kořenový adresář který požadujete neexistuje. Musíte ji vytvořit první ..";
$pgv_lang["media_firewall_protected_dir_no_exist"]		= "Chráněný multimediální adresář nelze vytvořit v kořenovém adresáři Firewall Média. Prosím vytvořte tento adresář a dělat to svět-zapisovatelný.";
$pgv_lang["media_firewall_protected_dir_not_writable"]	= "Chráněný multimediální adresář v kořenovém adresáři Firewall Média není světová zapisovat.";
$pgv_lang["media_firewall_invalid_dir"]	= "Chyba: Firewall Média byla vypuštěna z jiného adresáře, než je adresář médií.";

//-- Relationship chart messages
$pgv_lang["view_fam_nav_details"]	= "Zobrazit podrobnosti pro ...";
$pgv_lang["view_fam_nav_notes"]		= "Zobrazit poznámky pro ...";
$pgv_lang["view_fam_nav_sources"]	= "Zobrazit zdroje pro ...";
$pgv_lang["view_fam_nav_media"]		= "Zobrazit média pro ...";
$pgv_lang["view_fam_nav_album"]		= "Zobrazit album pro ...";
$pgv_lang["view_fam_nav_relatives"]	= "Zobrazit příbuzní pro ...";
$pgv_lang["view_fam_nav_tree"]		= "Zobrazit rodokmen pro ...";
$pgv_lang["view_fam_nav_research"]	= "Zobrazit výzkum pro ...";
$pgv_lang["view_fam_nav_map"]		= "Zobrazit mapu pro ...";
$pgv_lang["view_fam_nav_spare"]		= "Zobrazit náhradních informace pro ...";
$pgv_lang["navigator"]				= "Navigátor";
$pgv_lang["fam_navigator"]			= "Navigátor rodina";

$pgv_lang["relationship_great"]		= "Pra";
$pgv_lang["relationship_chart"]		= "Schéma vztahů";
$pgv_lang["person1"]			= "Osoba 1";
$pgv_lang["person2"]			= "Osoba 2";
$pgv_lang["no_link_found"]		= "Mezi těmito dvěma osobami nebyl nalezen žádný  vztah.";
$pgv_lang["no_other_link_found"]	= "Mezi těmito dvěma osobami nebyl nalezen žádný další vztah.";
$pgv_lang["sibling"]			= "Sourozenec";
$pgv_lang["follow_spouse"]		= "Zkontrolovat příbuzenství sňatkem";
$pgv_lang["timeout_error"]		= "Vykonávání skriptu bylo ukončeno před dokončením vyhledávání.";
$pgv_lang["grandchild"]				= "Vnouče";
$pgv_lang["grandson"]				= "Vnuk";
$pgv_lang["granddaughter"]			= "Vnučka";
$pgv_lang["greatgrandchild"]		= "Pravnouče";
$pgv_lang["greatgrandson"]			= "Pravnuk";
$pgv_lang["greatgranddaughter"]		= "Pravnučka";
$pgv_lang["brother"]			= "Bratr";
$pgv_lang["sister"]			= "Sestra";
$pgv_lang["aunt"]					= "Teta";
$pgv_lang["uncle"]				= "Strýc";
$pgv_lang["nephew"]				= "Synovec";
$pgv_lang["niece"]				= "Neteř";
$pgv_lang["firstcousin"]			= "Bratranec/sestřenice";
$pgv_lang["femalecousin"]			= "Sestřenice";
$pgv_lang["malecousin"]				= "Bratranec";
$pgv_lang["relationship_to_me"]		= "Vztah ke mně";
$pgv_lang["rela_husb"]				= "Vztah k manželovi";
$pgv_lang["rela_wife"]				= "Vztah k manželce";
$pgv_lang["next_path"]			= "Najít další vztah";
$pgv_lang["show_path"]			= "Ukázat vztah";
$pgv_lang["line_up_generations"]	= "Vyrovnat podle generační úrovně";
$pgv_lang["oldest_top"]             = "Zobrazit nejstarší nahoře";

// %1\$s replaced by first person, %2\$s by the relationship and %3\$s by the second person.
$pgv_lang["relationship_male_1_is_the_2_of_3"] = "%1\$s je %2\$s %3\$s.";
$pgv_lang["relationship_female_1_is_the_2_of_3"] = "%1\$s je %2\$s %3\$s.";

$pgv_lang["mother_in_law"]		= "Tchýně";
$pgv_lang["father_in_law"]		= "Tchán";
$pgv_lang["brother_in_law"]		= "Švagr";
$pgv_lang["sister_in_law"]		= "Švagrová";
$pgv_lang["brothers_wife"]		= "Švagrová"; // brother's wife
$pgv_lang["son_in_law"]			= "Zeť";
$pgv_lang["daughter_in_law"]	= "Snacha";
$pgv_lang["uncle_in_law"]		= "Strýc";
$pgv_lang["aunt_in_law"]		= "Teta";
$pgv_lang["cousin_in_law"]		= "Bratranec";
$pgv_lang["m_cousin_in_law"]	= "Bratránek";
$pgv_lang["f_cousin_in_law"]	= "Sestřenice";
$pgv_lang["step_son"]			= "nevlastní syn";
$pgv_lang["step_daughter"]		= "nevlastní dcera";

// the bosa_brothers_offspring name is used for fraternal nephews and nieces - the names below can be extended to any number
// of generations just by adding more translations.
// 1st generation
$pgv_lang["bosa_brothers_offspring_2"]				= "synovec";             // brother's son
$pgv_lang["bosa_brothers_offspring_3"]				= "neteř";              // brother's daughter
// 2nd generation
$pgv_lang["bosa_brothers_offspring_4"]				= "prasynovec";       // brother's son's son
$pgv_lang["bosa_brothers_offspring_5"]				= "praneteř";        // brother's son's daughter
$pgv_lang["bosa_brothers_offspring_6"]				= "prasynovec";       // brother's daughter's son
$pgv_lang["bosa_brothers_offspring_7"]				= "praneteř";        // brother's daughter's daughter
// for the general case of offspring of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_brothers_son"]	  = "%2\$d x prasynovec";
$pgv_lang["n_x_brothers_daughter"] = "%2\$d x praneteř";
// the bosa_sisters_offspring name is used for sisters nephews and nieces - the names below can be extended to any number
// of generations just by adding more translations.
// 1st generation
$pgv_lang["bosa_sisters_offspring_2"]				= "synovec";             // sister's son
$pgv_lang["bosa_sisters_offspring_3"]				= "neteř";              // sister's daughter
// 2nd generation
$pgv_lang["bosa_sisters_offspring_4"]				= "prasynovec";       // sister's son's son
$pgv_lang["bosa_sisters_offspring_5"]				= "praneteř";        // sister's son's daughter
$pgv_lang["bosa_sisters_offspring_6"]				= "prasynovec";       // sister's daughter's son
$pgv_lang["bosa_sisters_offspring_7"]				= "praneteř";        // sister's daughter's daughter
// for the general case of offspring of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_sisters_son"]	  = "%2\$d x prasynovec";
$pgv_lang["n_x_sisters_daughter"] = "%2\$d x praneteř";

// the bosa name is used for offspring - the names below can be extended to any number
// of generations just by adding more translations.
// 1st generation
$pgv_lang["bosa_2"] 				= "syn";                   // son
$pgv_lang["bosa_3"] 				= "dcera";              // daughter
// 2nd generation
$pgv_lang["bosa_4"] 				= "vnuk";              // son's son
$pgv_lang["bosa_5"] 				= "vnučka";         // son's daughter
$pgv_lang["bosa_6"] 				= "vnuk";              // daughter's son
$pgv_lang["bosa_7"] 				= "vnučka";         // daughter's daughter
// 3rd generation
$pgv_lang["bosa_8"] 				= "pravnuk";        // son's son's son
$pgv_lang["bosa_9"] 				= "pravnučka";   // son's son's daughter
$pgv_lang["bosa_10"] 				= "pravnuk";		   // son's daughter's son
$pgv_lang["bosa_11"] 				= "pravnučka";   // son's daughter's daughter
$pgv_lang["bosa_12"] 				= "pravnuk";        // daughter's son's son
$pgv_lang["bosa_13"] 				= "pravnučka";   // daughter's son's daughter
$pgv_lang["bosa_14"] 				= "pravnuk";		   // daughter's daughter's son
$pgv_lang["bosa_15"] 				= "pravnučka";   // daughter's daughter's daughter
// for the general case of offspring of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_grandson_from_son"]	  = "%3\$d x pravnuk";
$pgv_lang["n_x_granddaughter_from_son"] = "%3\$d x pravnučka";
$pgv_lang["n_x_grandson_from_daughter"]	  = "%3\$d x pravnuk";
$pgv_lang["n_x_granddaughter_from_daughter"] = "%3\$d x pravnučka";

// the sosa_uncle name is used for uncles - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and uncles
// 1st generation
$pgv_lang["sosa_uncle_2"] 				= "strýc";            // father's brother
$pgv_lang["sosa_uncle_3"] 				= "strýc";            // mother's brother
// 2nd generation
$pgv_lang["sosa_uncle_4"] 				= "prastrýc";      // fathers's father's brother
$pgv_lang["sosa_uncle_5"] 				= "prastrýc";      // father's mother's brother
$pgv_lang["sosa_uncle_6"] 				= "prastrýc";      // mother's father's brother
$pgv_lang["sosa_uncle_7"] 				= "prastrýc";      // mother's mother's brother
// for the general case of uncles of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_uncle"]		= "%2\$d x prastrýc";
$pgv_lang["n_x_maternal_uncle"]	    = "%2\$d x prastrýc";

// the sosa_aunt name is used for aunts - the names below can be extended to any number
// of generations just by adding more translations.
// to allow for language variations we specify different relationships for paternal and maternal
// aunts and aunts
// 1st generation
$pgv_lang["sosa_aunt_2"] 				= "teta";            // father's sister
$pgv_lang["sosa_aunt_3"] 				= "teta";            // mother's sister
// 2nd generation
$pgv_lang["sosa_aunt_4"] 				= "prateta";      // fathers's father's sister
$pgv_lang["sosa_aunt_5"] 				= "prateta";      // father's mother's sister
$pgv_lang["sosa_aunt_6"] 				= "prateta";      // mother's father's sister
$pgv_lang["sosa_aunt_7"] 				= "prateta";      // mother's mother's sister
// for the general case of aunts of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_aunt"]		= "%2\$d x prateta";
$pgv_lang["n_x_maternal_aunt"]	    = "%2\$d x prateta";

// the sosa_uncle name is used for uncles(by marriage) - the names below can be extended to any number
// of generations just by adding more translations.
// to allow for language variations we specify different relationships for paternal and maternal
// aunts and uncles
// 1st generation
$pgv_lang["sosa_uncle_bm_2"] 				= "strýc";            // father's brother
$pgv_lang["sosa_uncle_bm_3"] 				= "strýc";            // mother's brother
// 2nd generation
$pgv_lang["sosa_uncle_bm_4"] 				= "prastrýc";      // fathers's father's brother
$pgv_lang["sosa_uncle_bm_5"] 				= "prastrýc";      // father's mother's brother
$pgv_lang["sosa_uncle_bm_6"] 				= "prastrýc";      // mother's father's brother
$pgv_lang["sosa_uncle_bm_7"] 				= "prastrýc";      // mother's mother's brother
// for the general case of uncles of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_uncle_bm"]		= "%2\$d x prastrýc";
$pgv_lang["n_x_maternal_uncle_bm"]	    = "%2\$d x prastrýc";

// the sosa_aunt name is used for aunts (by marriage)- the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and aunts
// 1st generation
$pgv_lang["sosa_aunt_bm_2"] 				= "teta";            // father's sister
$pgv_lang["sosa_aunt_bm_3"] 				= "teta";            // mother's sister
// 2nd generation
$pgv_lang["sosa_aunt_bm_4"] 				= "prateta";      // fathers's father's sister
$pgv_lang["sosa_aunt_bm_5"] 				= "prateta";      // father's mother's sister
$pgv_lang["sosa_aunt_bm_6"] 				= "prateta";      // mother's father's sister
$pgv_lang["sosa_aunt_bm_7"] 				= "prateta";      // mother's mother's sister
// for the general case of aunts of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_aunt_bm"]		= "%2\$d x prateta";
$pgv_lang["n_x_maternal_aunt_bm"]	    = "%2\$d x prateta";

// if a specific cousin relationship cannot be represented in a language translate as "";
$pgv_lang["male_cousin_1"]              = "bratranec";
$pgv_lang["male_cousin_2"]              = "2x bratranec";
$pgv_lang["male_cousin_3"]              = "3x bratranec";
$pgv_lang["male_cousin_4"]              = "4x bratranec";
$pgv_lang["male_cousin_5"]              = "5x bratranec";
$pgv_lang["male_cousin_6"]              = "6x bratranec";
$pgv_lang["male_cousin_7"]              = "7x bratranec";
$pgv_lang["male_cousin_8"]              = "8x bratranec";
$pgv_lang["male_cousin_9"]              = "9x bratranec";
$pgv_lang["male_cousin_10"]             = "10x bratranec";
$pgv_lang["male_cousin_11"]             = "11x bratranec";
$pgv_lang["male_cousin_12"]             = "12x bratranec";
$pgv_lang["male_cousin_13"]             = "13x bratranec";
$pgv_lang["male_cousin_14"]             = "14x bratranec";
$pgv_lang["male_cousin_15"]             = "15x bratranec";
$pgv_lang["male_cousin_16"]             = "16x bratranec";
$pgv_lang["male_cousin_17"]             = "17x bratranec";
$pgv_lang["male_cousin_18"]             = "18x bratranec";
$pgv_lang["male_cousin_19"]             = "19x bratranec";
$pgv_lang["male_cousin_20"]             = "20x bratranec";
$pgv_lang["male_cousin_n"]              = "%d x bratranec";
$pgv_lang["female_cousin_1"]            = "bratranec";
$pgv_lang["female_cousin_2"]            = "2x bratranec";
$pgv_lang["female_cousin_3"]            = "3x bratranec";
$pgv_lang["female_cousin_4"]            = "4x bratranec";
$pgv_lang["female_cousin_5"]            = "5x bratranec";
$pgv_lang["female_cousin_6"]            = "6x bratranec";
$pgv_lang["female_cousin_7"]            = "7x bratranec";
$pgv_lang["female_cousin_8"]            = "8x bratranec";
$pgv_lang["female_cousin_9"]            = "9x bratranec";
$pgv_lang["female_cousin_10"]           = "10x bratranec";
$pgv_lang["female_cousin_11"]           = "11x bratranec";
$pgv_lang["female_cousin_12"]           = "12x bratranec";
$pgv_lang["female_cousin_13"]           = "13x bratranec";
$pgv_lang["female_cousin_14"]           = "14x bratranec";
$pgv_lang["female_cousin_15"]           = "15x bratranec";
$pgv_lang["female_cousin_16"]           = "16x bratranec";
$pgv_lang["female_cousin_17"]           = "17x bratranec";
$pgv_lang["female_cousin_18"]           = "18x bratranec";
$pgv_lang["female_cousin_19"]           = "19x bratranec";
$pgv_lang["female_cousin_20"]           = "20x bratranec";
$pgv_lang["female_cousin_n"]            = "%d x bratranec";

// Only referenced from english specific functions
$pgv_lang["removed_ascending_1"]   = " po odstraněny vzestupně";
$pgv_lang["removed_ascending_2"]   = " dvakrát odstraněny vzestupně";
$pgv_lang["removed_ascending_3"]   = " třikrát odstraněny vzestupně";
$pgv_lang["removed_ascending_4"]   = " čtyřikrát odstraněny vzestupně";
$pgv_lang["removed_ascending_5"]   = " pětkrát odstraněny vzestupně";
$pgv_lang["removed_ascending_6"]   = " šestkrát odstraněny vzestupně";
$pgv_lang["removed_ascending_7"]   = " sedmkrát odstraněny vzestupně";
$pgv_lang["removed_ascending_8"]   = " osmkrát odstraněny vzestupně";
$pgv_lang["removed_ascending_9"]   = " devětkrát odstraněny vzestupně";
$pgv_lang["removed_ascending_10"]  = " desetkrát odstraněny vzestupně";
$pgv_lang["removed_ascending_11"]  = " jedenáctkrát odstraněny vzestupně";
$pgv_lang["removed_ascending_12"]  = " dvanáctkrát odstraněny vzestupně";
$pgv_lang["removed_ascending_13"]  = " třináctkrát odstraněny vzestupně";
$pgv_lang["removed_ascending_14"]  = " čtrnáctkrát odstraněny vzestupně";
$pgv_lang["removed_ascending_15"]  = " patnáctkrát odstraněny vzestupně";
$pgv_lang["removed_ascending_16"]  = " šestnáctkrát odstraněny vzestupně";
$pgv_lang["removed_ascending_17"]  = " sedmnáctkrát odstraněny vzestupně";
$pgv_lang["removed_ascending_18"]  = " osmnáctkrát odstraněny vzestupně";
$pgv_lang["removed_ascending_19"]  = " devatenáctkrát odstraněny vzestupně";
$pgv_lang["removed_ascending_20"]  = " dvacetkrát odstraněny vzestupně";
$pgv_lang["removed_descending_1"]   = " po odstraněny sestupně";
$pgv_lang["removed_descending_2"]   = " dvakrát odstraněny sestupně";
$pgv_lang["removed_descending_3"]   = " třikrát odstraněny sestupně";
$pgv_lang["removed_descending_4"]   = " čtyřikrát odstraněny sestupně";
$pgv_lang["removed_descending_5"]   = " pětkrát odstraněny sestupně";
$pgv_lang["removed_descending_6"]   = " šestkrát odstraněny sestupně";
$pgv_lang["removed_descending_7"]   = " sedmkrát odstraněny sestupně";
$pgv_lang["removed_descending_8"]   = " osmkrát odstraněny sestupně";
$pgv_lang["removed_descending_9"]   = " devětkrát odstraněny sestupně";
$pgv_lang["removed_descending_10"]  = " desetkrát odstraněny sestupně";
$pgv_lang["removed_descending_11"]  = " jedenáctkrát odstraněny sestupně";
$pgv_lang["removed_descending_12"]  = " dvanáctkrát odstraněny sestupně";
$pgv_lang["removed_descending_13"]  = " třináctkrát odstraněny sestupně";
$pgv_lang["removed_descending_14"]  = " čtrnáctkrát odstraněny sestupně";
$pgv_lang["removed_descending_15"]  = " patnáctkrát odstraněny sestupně";
$pgv_lang["removed_descending_16"]  = " šestnáctkrát odstraněny sestupně";
$pgv_lang["removed_descending_17"]  = " sedmnáctkrát odstraněny sestupně";
$pgv_lang["removed_descending_18"]  = " osmnáctkrát odstraněny sestupně";
$pgv_lang["removed_descending_19"]  = " devatenáctkrát odstraněny sestupně";
$pgv_lang["removed_descending_20"]  = " dvacetkrát odstraněny sestupně";

//-- GEDCOM edit utility
$pgv_lang["check_delete"]		= "Jste si jisti, že chcete smazat tento údaj?";
$pgv_lang["access_denied"]		= "<b>Přístup odepřen</b><br />Nemáte přístup k tomuto prostředky.";
$pgv_lang["changes_exist"]		= "V tomto GEDCOM souboru byly provedeny změny.";
$pgv_lang["find_place"]			= "Najít místo";
$pgv_lang["close_window"]		= "Zavřít okno";
$pgv_lang["close_window_without_refresh"] = "Zavřít okno bez opětovného načtení";
$pgv_lang["place_contains"]		= "Místo obsahuje:";
$pgv_lang["add"]			= "Přidat";
$pgv_lang["custom_event"]		= "Vlastní událost";
$pgv_lang["delete_person"]		= "Smazat tuto osobu";
$pgv_lang["confirm_delete_person"]	= "Jste si jistí, že chcete vymazat tuto osobu z GEDCOM souboru?";
$pgv_lang["find_media"]			= "Najít média";
$pgv_lang["set_link"]			= "Nastavit odkaz";
$pgv_lang["delete_source"]		= "Smazat tento zdroj";
$pgv_lang["delete_shared_note"]		= "Smazat sdílenou poznámku";
$pgv_lang["confirm_delete_source"]	= "Jste si jistí, že chcete vymazat tento zdroj z GEDCOM souboru?";
$pgv_lang["confirm_delete_shared_note"]		= "Jste si jistí, že chcete smazat tuto sdílenou poznámku?";
$pgv_lang["find_family"]		= "Najít rodinu";
$pgv_lang["find_fam_list"]		= "Sestavit seznam rodin";
$pgv_lang["edit_name"]			= "Upravit jméno";
$pgv_lang["delete_name"]		= "Smazat jméno";
$pgv_lang["select_date"]		= "Vybrat datum";
$pgv_lang["user_cannot_edit"]		= "Tento uživatel nemůže upravovat tento GEDCOM.";
$pgv_lang["gedcom_editing_disabled"]	= "Upravování tohoto GEDCOMu bylo zakázáno administrátorem systému.";
$pgv_lang["privacy_not_granted"]	= "Nemáte přístup k";
$pgv_lang["privacy_prevented_editing"]	= "Nastavení privátnosti vám neumožňuje upravovat tento záznam.";
$pgv_lang["ged_noshow"]				= "Tato stránka byla skryta administrátorem.";

//-- calendar.php messages
$pgv_lang["bdm"]					= "Narození, Úmrtí, Sňatky";
$pgv_lang["on_this_day"]		= "Tohoto dne ve vaší historii...";
$pgv_lang["in_this_month"]		= "V tomto měsíci ve vaší historii...";
$pgv_lang["in_this_year"]		= "Tohoto roku ve vaší historii...";
$pgv_lang["year_anniversary"]		= "#year_var# výročí";
$pgv_lang["today"]			= "Dnes";
$pgv_lang["day"]			= "Den:";
$pgv_lang["month"]			= "Měsíc";
$pgv_lang["showcal"]			= "Události k zobrazení:";
$pgv_lang["anniversary"]			= "Výročí";
$pgv_lang["anniversary_calendar"]	= "Kalendář výročí";
$pgv_lang["sunday"]			= "neděle";
$pgv_lang["monday"]			= "pondělí";
$pgv_lang["tuesday"]			= "úterý";
$pgv_lang["wednesday"]			= "středa";
$pgv_lang["thursday"]			= "čtvrtek";
$pgv_lang["friday"]			= "pátek";
$pgv_lang["saturday"]			= "sobota";
$pgv_lang["viewday"]			= "Zobrazit den";
$pgv_lang["viewmonth"]			= "Zobrazit měsíc";
$pgv_lang["viewyear"]			= "Zobrazit rok";
$pgv_lang["all_people"]			= "Všichni lidé";
$pgv_lang["living_only"]		= "Žijící lidé";
$pgv_lang["recent_events"]		= "Nedávné události (&lt; 100 let)";
$pgv_lang["day_not_set"]			= "Datum nezadáno";

//-- user self registration module
$pgv_lang["lost_password"]		= "Zapomněli jste své heslo?";
$pgv_lang["requestpassword"]	= "Zažádat o nové heslo";
$pgv_lang["no_account_yet"]		= "Ještě nemáte svůj účet?";
$pgv_lang["requestaccount"]		= "Zažádat o nový uživatelský účet";
$pgv_lang["emailadress"]		= "E-mailová adresa";
$pgv_lang["mandatory"] 			= "Položky označené hvězdičkou jsou povinné";
$pgv_lang["mail01_line01"]		= "Nazdar #user_fullname# ...";
$pgv_lang["mail01_line02"]		= "Z adresy ( #PGV_SERVER_NAME##PGV_SCRIPT_PATH# ) byl vyslán požadavek na přihlášení pod vaší e-mailovou adresou ( #user_email# ).";
$pgv_lang["mail01_line03"]		= "Byla použita následující data.";
$pgv_lang["mail01_line04"]		= "Prosím klikněte na odkaz dole a vyplňte požadovaná data pro ověření vašeho účtu a vaší e-mailové adresy.";
$pgv_lang["mail01_line05"]		= "Kdybyste tato data nevyžadovali, můžete tuto zprávu klidně smazat.";
$pgv_lang["mail01_line06"]		= "Žádný další e-mail z tohoto systému již nedostanete, protože účet bude do sedmi dnů bez ověření smazán.";
$pgv_lang["mail01_subject"]		= "Vaše registrace na #PGV_SERVER_NAME##PGV_SCRIPT_PATH#";

$pgv_lang["mail02_line01"]		= "Nazdar administrátore ...";
$pgv_lang["mail02_line02"]		= "Nový uživatel se zaregistroval na ( #PGV_SERVER_NAME##PGV_SCRIPT_PATH# ).";
$pgv_lang["mail02_line03"]		= "Uživatel obdržel e-mail s daty nezbytnými k ověření svého účtu.";
$pgv_lang["mail02_line04"]		= "Jakmile se uživatel dokončí toto ověřování, budete e-mailem informováni, abyste uživateli dali práva k přihlášení na vaše stránky.";
$pgv_lang["mail02_line04a"]		= "Budete informováni e-mailem, pokud toto potenciální uživatel potvrdil svou žádost. Po tomto, bude uživatel moci přihlásit bez zásahu z vaší strany.";
$pgv_lang["mail02_subject"]		= "Nová registrace na #PGV_SERVER_NAME##PGV_SCRIPT_PATH#";

$pgv_lang["hashcode"]			= "Ověřovací kód:";
$pgv_lang["thankyou"]			= "Nazdar #user_fullname# ...<br />Díky za registraci.";
$pgv_lang["pls_note06"]			= "Nyní na e-mail ( #user_email# ) obdržíte potvrzení. Tento e-mail použijte k aktivování svého účtu; jestliže se vám nepodaří aktivovat svůj účet do sedmi dní, bude vymazán (pak se můžete znovu pokusit zaregistrovat). Abyste se mohli přihlásit na tyto stránky, budete potřebovat znát své přihlašovací jméno a heslo.";
$pgv_lang["pls_note06a"] 		= "Nyní se poslat potvrzovací e-mail na adresu <b>#user_email#</b>. Musíte svůj účet ověřit požadavek následujících pokynů v potvrzovacím e-mailu. Pokud nechcete potvrdit svůj účet žádost do sedmi dnů, bude vaše žádost bude zamítnuta automaticky. Budete muset použít znovu.<br /><br />Poté, co jste postupovali podle pokynů v potvrzovacím e-mailu, můžete se přihlásit. Chcete-li se přihlásit k tomuto webu, budete potřebovat znát své uživatelské jméno a heslo.<br /><br />";

$pgv_lang["registernew"]		= "Potvrzení nového účtu";
$pgv_lang["user_verify"]		= "Ověření uživatele";
$pgv_lang["send"]				= "Odeslat";

$pgv_lang["pls_note07"]			= "Prosím vepište své uživatelské jméno, heslo a ověřovací kód, který jste obdrželi z tohoto systému, pro ověření vaší žádosti o účet.";
$pgv_lang["pls_note08"]			= "Data pro uživatele #user_name# byla zkontrolována.";

$pgv_lang["mail03_line01"]		= "Nazdar administrátore ...";
$pgv_lang["mail03_line02"]		= "#newuser[username]# ( #newuser[fullname]# ) zkontroloval registrační data.";
$pgv_lang["mail03_line03"]		= "Pro přihlášení a úpravu uživatele a povolení k přihlášení na vaše stránky prosím klikněte na odkaz dole.";
$pgv_lang["mail03_line03a"]			= "Nemusíte nic dělat, uživatel se teď může přihlásit.";
$pgv_lang["mail03_subject"]		= "Nové ověření na #PGV_SERVER_NAME##PGV_SCRIPT_PATH#";

$pgv_lang["pls_note09"]			= "Byli jste identifikováni jako registrovaný uživatel.";
$pgv_lang["pls_note10"]			= "Administrátor byl upozorněn.<br />Jakmile vám dám povolení k přihlášení, budete se moci přihlásit zadáním svého uživatelského jména a hesla.";
$pgv_lang["pls_note10a"]			= "Teď se můžete přihlásit vaším uživatelským jménem a heslem.";
$pgv_lang["data_incorrect"]		= "Data nebyla správná!<br />Prosím zkuste to znovu!";
$pgv_lang["user_not_found"]		= "Nebylo možné ověřit data, která jste vložili.  Prosím vraťte se zpět a zkuste to znovu.";

$pgv_lang["lost_pw_reset"]		= "Zapomenuté heslo";
$pgv_lang["pls_note11"]			= "Chcete-li, aby vaše heslo bylo smazáno, pošlete nám uživatelské jméno a e-mailovou adresu svého uživatelského účtu. <br /><br />Pošleme vám e-mailem odkaz na stránku, která obsahuje zakódované heslo pro váš účet. Navštívíte-li tuto URL, budete mít možnost změnit si heslo a přihlásit se do tohoto systému. Z bezpečnostních důvodů byste měli toto heslo uchovat v tajnosti (neměli by jej znát ani administrátoři těchto stránek; nebudeme se na něj ptát).<br /><br />Jestliže budete požadovat pomoc administrátora, prosím kontaktujte administrátora stránek.";

$pgv_lang["mail04_line01"]		= "Nazdar #user_fullname# ...";
$pgv_lang["mail04_line02"]		= "Bylo zažádáno o nové heslo pro vaše uživatelské jméno!";
$pgv_lang["mail04_line03"]		= "Doporučení:";
$pgv_lang["mail04_line04"]		= "Teď prosím klikněte na odkaz dole, přihlaste se s novým heslem a ihned si ho změňte, abyste uchovali svá data v tajnosti.";
$pgv_lang["mail04_line05"]			= "Potom, co se přihlásíte, zvolte  «#pgv_lang[editowndata]#» pod menu  «#pgv_lang[mygedview]#» a vyplňte pole «heslo» abyste změnili vaše heslo.";
$pgv_lang["mail04_subject"]		= "Nové heslo na #PGV_SERVER_NAME##PGV_SCRIPT_PATH#";

$pgv_lang["pwreqinfo"]			= "Nazdar...<br /><br />Na adresu (#user[email]#) byl zaslán e-mail s novým heslem.<br /><br />Prosím zkontrolujte svou e-mailovou schránku, zprávu byste měli obdržet během několika minut.<br /><br />Doporučení:<br /><br />Potom, co zažádáte o e-mail, měli byste se na tyto stránky přihlásit se svým novým heslem a změnit si jej, abyste uchovali svá data v tajnosti.";

$pgv_lang["myuserdata"]			= "Můj účet";
$pgv_lang["user_theme"]			= "Můj motiv";
$pgv_lang["mgv"]			= "MyGedView";
$pgv_lang["mygedview"]			= "Vstupní brána MyGedView";
$pgv_lang["passwordlength"]		= "Heslo musí obsahovat alespoň 6 znaků.";
$pgv_lang["welcome_text_auth_mode_1"]	=	"<span class='center'><b>VÍTEJTE NA TĚCHTO RODOPISNÝCH STRÁNKÁCH</b></span><br /><br />Přístup na tyto stránky je povolen všem návštěvníkům, kteří zde mají zřízený účet.<br />Jestliže zde již máte svůj účet, můžete se na této stránce přihlásit.<br /><br />Pokud ještě účet nemáte, můžete o něj požádat kliknutím na příslušný odkaz na této stránce.<br />Po ověření zadaných údajů vám administrátor účet zpřístupní.<br />Oznámení o zpřístupnění obdržíte e-mailem.";
$pgv_lang["welcome_text_auth_mode_2"]	=	"<span class='center'><b>VÍTEJTE NA TĚCHTO RODOPISNÝCH STRÁNKÁCH</b></span><br /><br />Přístup na tyto stránky je umožněn pouze <b>přihlášeným</b> uživatelům.<br />Jestliže zde již máte svůj účet, můžete se na této stránce přihlásit.<br /><br />Pokud ještě účet nemáte, můžete o něj požádat kliknutím na příslušný odkaz na této stránce.<br />Po ověření zadaných údajů administrátor vaši žádost buď přijme, nebo odmítne.<br />Oznámení o přijetí své žádosti obdržíte e-mailem.";
$pgv_lang["welcome_text_auth_mode_3"]	=	"<span class='center'><b>VÍTEJTE NA TĚCHTO RODOPISNÝCH STRÁNKÁCH</b></span><br /><br />Přístup na tyto stránky je povolen pouze <b>členům rodiny</b>.<br />Jestliže zde již máte svůj účet, můžete se na této stránce přihlásit.<br /><br />Pokud ještě účet nemáte, můžete o něj požádat kliknutím na příslušný odkaz na této stránce.<br />Po ověření zadaných údajů administrátor vaši žádost buď přijme, nebo odmítne.<br />Oznámení o přijetí své žádosti obdržíte e-mailem.";
$pgv_lang["welcome_text_cust_head"]		=	"<span class='center'><b>VÍTEJTE NA TĚCHTO RODOPISNÝCH STRÁNKÁCH</b></span><br /><br />Přístup na tyto stránky je umožněn pouze uživatelům, kteří zde mají zřízený svůj uživatelský účet s heslem.<br />";
$pgv_lang["acceptable_use"]			= "<div class=\"largeError\">Upozornění:</div><div class=\"error\">Vyplněním a odesláním tohoto formuláře, souhlasíte:<ul><li>se chránit soukromí živých lidí uvedených na našich stránkách;</li><li>a do textového pole níže vysvětlit, kterému se vztahují, nebo nám poskytnout informace o někoho, kdo by měl být uveden na naše stránky.</li></ul></div>";


//-- mygedview page
$pgv_lang["upcoming_events"]		= "Nadcházející události";
$pgv_lang["living_or_all"]			= "Zobrazit pouze události z živých osob?";
$pgv_lang["basic_or_all"]			= "Ukázat pouze Narození, Úmrtí a Sňatky?";
$pgv_lang["style"]					= "Styl prezentace";
$pgv_lang["style1"]					= "Seznam";
$pgv_lang["style2"]					= "Tabukla";
$pgv_lang["style3"]					= "Tagcloud";
$pgv_lang["sort_style"]				= "Seřazení";
$pgv_lang["by_anniv"]				= "Podle výročí";
$pgv_lang["by_alpha"]				= "Abecedně";
$pgv_lang["cal_download"]			= "Povolit stahování událostí kalendáře?";
$pgv_lang["no_events_living"]		= "Žádné události pro žijících osob existují pro příštích #pgv_lang[global_num1]# dní.";
$pgv_lang["no_events_living1"]		= "Pro zítřek není žádná událost týkající se žijících osob.";
$pgv_lang["no_events_all"]			= "Žádné události existují pro příštích #pgv_lang[global_num1]# dní.";
$pgv_lang["no_events_all1"]			= "Pro zítřek není žádná událost.";
$pgv_lang["no_events_privacy"]		= "Události existují pro příštích #pgv_lang[global_num1]# dní, ale privátnosti omezení zabránit vidět je.";
$pgv_lang["no_events_privacy1"]		= "Události existují pro zítřek, ale privátnosti omezení zabránit vidět je.";
$pgv_lang["more_events_privacy"]	= "<br />Další akce existují pro příštích #pgv_lang[global_num1]# dní, ale privátnosti omezení zabránit vidět je.";
$pgv_lang["more_events_privacy1"]	= "<br />Další akce existují pro zítřek, ale privátnosti omezení zabránit vidět je.";
$pgv_lang["none_today_living"]		= "Pro dnešek nejsou žádné události týkající se žijících osob.";
$pgv_lang["none_today_all"]			= "Pro dnešek nejsou žádné události.";
$pgv_lang["none_today_privacy"]		= "Události existují pro dnešek, ale privátnosti omezení zabránit vidět je.";
$pgv_lang["more_today_privacy"]		= "<br />Další akce existují dnes, ale privátnosti omezení zabránit vidět je.";
$pgv_lang["chat"]			= "Chat";
$pgv_lang["users_logged_in"]		= "Přihlášení uživatelé";
$pgv_lang["anon_user"]				= "1 anonymní přihlášení uživatele";
$pgv_lang["anon_users"]				= "#pgv_lang[global_num1]# anonymní přihlášené uživatele";
$pgv_lang["login_user"]				= "1 přihlášené uživatele";
$pgv_lang["login_users"]			= "#pgv_lang[global_num1]# přihlášené uživatele";
$pgv_lang["no_login_users"]			= "Žádný přihlášené a ne anonymní uživatelé";
$pgv_lang["message"]			= "Poslat zprávu";
$pgv_lang["my_messages"]		= "Moje zprávy";
$pgv_lang["date_created"]		= "Data byla zaslána:";
$pgv_lang["message_from"]		= "Emailová adresa";
$pgv_lang["message_from_name"]		= "Vaše jméno:";
$pgv_lang["message_to"]			= "Adresát:";
$pgv_lang["message_subject"]		= "Předmět:";
$pgv_lang["message_body"]		= "Text:";
$pgv_lang["no_to_user"]			= "Nezadali jste příjemce zprávy.  Není možné pokračovat.";
$pgv_lang["provide_email"]		= "Prosím zadejte svou e-mailovou adresu, abychom vás případně mohli kontaktovat.  Pokud nám neposkytnete svou e-mailovou adresu, nebudeme vám moci odpovědět.  Vaše e-mailová adresa nebude užita k žádným jiným účelům než k odpovědi na váš dotaz.";
$pgv_lang["reply"]			= "Odpovědět";
$pgv_lang["message_deleted"]		= "Zpráva byla smazána";
$pgv_lang["message_sent"]		= "Zpráva byla odeslána #TO_USER#";
$pgv_lang["message_failed"]		= "Zpráva nemohla být odeslána";
$pgv_lang["message_error"]		= "Chyba PHPMailer: ";
$pgv_lang["message_invalid_from"]	= "Neplatná adresa odesílatele: &lt;#email#&gt;";
$pgv_lang["message_invalid_to"]		= "Neplatná adresa příjemce: &lt;#email#&gt;";
$pgv_lang["reset"]			= "Reset";
$pgv_lang["site_default"]		= "Domácí stránka";
$pgv_lang["mygedview_desc"]		= "Vaše stránka MyGedView vám umožňuje uchovávat záložky svých přátel, sledovat nadcházející události a spolupracovat s ostatními uživateli PhpGedView.";
$pgv_lang["no_messages"]		= "Nemáte žádné příchozí zprávy.";
$pgv_lang["clicking_ok"]		= "Kliknete-li na OK, otevře se další okno, kde budete moci kontaktovat #user[fullname]#";
$pgv_lang["favorites"]				= "Oblíbené";
$pgv_lang["my_favorites"]		= "Moje oblíbené";
$pgv_lang["no_favorites"]		= "Nevybrali jste žádné oblíbené.<br /><br />Chcete-li přidat osobu, rodinu, nebo zdroj do oblíbených, klikněte na odkaz <b>#pgv_lang[add_favorite]#</b> odhalit některá pole, kde můžete zadat nebo vyhledat identifikační číslo. Namísto identifikačního čísla, můžete zadat adresu URL a titul.";
$pgv_lang["add_to_my_favorites"]	= "Přidat do mých oblíbených";
$pgv_lang["gedcom_favorites"]		= "Oblíbené u tohoto GEDCOMu";
$pgv_lang["no_gedcom_favorites"]	= "V tuto chvíli nejsou označeny žádné oblíbené. Admin může nastavit zobrazení oblíbených při startu.";
$pgv_lang["confirm_fav_remove"]		= "Jste si jisti, že chcete odstranit tuto položku z vašich oblíbených?";
$pgv_lang["invalid_email"]		= "Prosím zadejte platnou e-mailovou adresu.";
$pgv_lang["enter_subject"]		= "Prosím zadejte předmět zprávy.";
$pgv_lang["enter_body"]			= "Prosím zadejte text zprávy před jejím odesláním.";
$pgv_lang["confirm_message_delete"]	= "Jste si jistí, že chcete smazat tuto zprávu?  Nebude možné ji později získat zpět.";
$pgv_lang["message_email1"]		= "Tato zpráva byla zaslána na váš PhpGedView uživatelský účet z ";
$pgv_lang["message_email2"]		= "Tuto zprávu jste poslali na PhpGedView uživatelský účet:";
$pgv_lang["message_email3"]		= "Tuto zprávu jste poslali administrátorovi PhpGedView:";
$pgv_lang["viewing_url"]		= "Tato zpráva byla poslána během zobrazování následující url: ";
$pgv_lang["messaging2_help"]		= "Jestliže jste odeslali tuto zprávu, obdržíte její kopii na svou e-mailovou adresu, kterou jste uvedli při registraci.";
$pgv_lang["random_picture"]		= "Náhodný obrázek";
$pgv_lang["message_instructions"]	= "<b>Prosím pozor:</b> Soukromé informace žijících osob budou poskytnuta pouze rodinným příbuzným a blízkým přátelům. Předtím, než obdržíte jakákoliv soukromá data, budete požádáni o ověření vašeho vztahu.  Někdy mohou být soukromé povahy i data zemřelých osob.  Jestliže je to tento případ, pak je to z toho důvodu, že není dost známých informací o této osobě, aby bylo možné rozhodnout, jestli žije nebo ne, a pak tedy ani žádné další informace o této informace nemáme.<br /><br />Před vznesením dotazu na nějakou, prosím zkontrolujte u ní data, místa a blízké příbuzné, abyste si byli jistí, že se tážete na tu správnou osobu.  Jestliže provádíte změny v genealogických datech, prosím uveďte zdroje, ze kterých jste čerpali.<br /><br />";
$pgv_lang["sending_to"]			= "Tato zpráva bude odeslána na #TO_USER#";
$pgv_lang["preferred_lang"]	 	= "Tento uživatel upřednostňuje příjem zpráv přes #USERLANG#";
$pgv_lang["gedcom_created_using"]	= "Tento GEDCOM byl vytvořen v programu <b>#SOFTWARE# #VERSION#</b>";
$pgv_lang["gedcom_created_on"]		= "Tento GEDCOM byl vytvořen na <b>#DATE#</b>.";
$pgv_lang["gedcom_created_on2"]	= " na <b>#DATE#</b>.";
$pgv_lang["gedcom_stats"]		= "Statistika GEDCOMu";
$pgv_lang["stat_individuals"]		= "Osoby";
$pgv_lang["stat_families"]		= "Rodiny";
$pgv_lang["stat_sources"]		= "Zdroje";
$pgv_lang["stat_other"]			= "Ostatních záznamů";
$pgv_lang["stat_earliest_birth"] 	= "Rok nejstaršího narození";
$pgv_lang["stat_latest_birth"] 	= "Rok posledního narození";
$pgv_lang["stat_earliest_death"] 	= "Rok nejstaršího úmrtí";
$pgv_lang["stat_latest_death"] 	= "Rok posledního úmrtí";
$pgv_lang["customize_page"]		= "Upravit vstupní bránu MyGedView";
$pgv_lang["customize_gedcom_page"]	= "Upravit úvodní stránku tohoto GEDCOMu";
$pgv_lang["upcoming_events_block"]	= "Blok nadcházejících událostí";
$pgv_lang["upcoming_events_descr"]	= "V bloku nadcházejících událostí je zobrazen seznam událostí z momentálně prohlíženého GEDCOMu, jejichž výročí si připomeneme během příštích 30 dní.  Přes uživatelskou stránku MyGedView se v bloku zobrazí jen živí lidé.  Přes vstupní bránu GEDCOMu se zobrazí všichni lidé.";
$pgv_lang["todays_events_block"]	= "Blok pro dnešní den";
$pgv_lang["todays_events_descr"]	= "Tohoto dne ve vaší historii... V bloku bude zobrazen seznam událostí z momentálně prohlíženého GEDCOMu, které se staly tohoto dne.  Pokud nejsou nalezeny žádné události, blok se neukáže.  Přes uživatelskou stránku MyGedView se v bloku zobrazí jen seznam žijících lidí.  Přes vstupní bránu GEDCOMu se zobrazí všichni lidé.";
$pgv_lang["todo_block"] = "Úkoly &quot;zajímavosti&quot;";
$pgv_lang["todo_descr"] = "Úkoly zajímavosti blok zobrazuje všechny zbývající _TODO skutečnosti v databázi.";
$pgv_lang["todo_show_other"]     = "Zobrazit úlohy ostatních uživatelů";
$pgv_lang["todo_show_unassigned"]= "Zobrazit nepřiřazené úkoly";
$pgv_lang["todo_show_future"]    = "Zobrazit budoucí úkoly";
$pgv_lang["todo_nothing"]        = "Nejsou k dispozici žádné úkoly &quot;zajímavostt&quot;.";
$pgv_lang["yahrzeit_block"]			= "Připravované Yahrzeiten";
$pgv_lang["yahrzeit_descr"]			= "Blok Připravované Yahrzeiten zobrazuje výročí úmrtí dat, které nastanou v blízké budoucnosti. Můžete nakonfigurovat zobrazenou období, a správce může nastavit, jak daleko do budoucnosti je tento blok bude vypadat.";
$pgv_lang["logged_in_users_block"]	= "Přihlášeni uživatelé";
$pgv_lang["logged_in_users_descr"]	= "Kliknutím na tento odkaz zjistíte, kteří uživatelé jsou právě teď přihlášeni.";
$pgv_lang["user_messages_block"]	= "Blok zpráv";
$pgv_lang["user_messages_descr"]	= "V bloku zpráv je zobrazen seznam zpráv, které byly poslány aktivnímu uživateli.";
$pgv_lang["user_favorites_block"]	= "Blok uživatelských Oblíbených";
$pgv_lang["user_favorites_descr"]	= "V bloku uživatelských Oblíbených se uživateli zobrazí seznam oblíbených osob v tomto systému, takže se k nim může snadněji dostat.";
$pgv_lang["welcome_block"]		= "Uvítací blok uživatele";
$pgv_lang["welcome_descr"]		= "Uvítací blok uživatele ukazuje uživateli nynější datum a čas, odkazy pro úpravu jeho účtu nebo pro zobrazení vlastního vývodu a odkaz pro úpravu vstupní brány.";
$pgv_lang["random_media_block"]		= "Blok náhodného média";
$pgv_lang["random_media_descr"]		= "Blok náhodného média náhodně vybere obrázek nebo jinou mediální položku v právě prohlíženém GEDCOMu a zobrazí ji uživateli.";
$pgv_lang["random_media_persons_or_all"]	= "Ukázat pouze osoby, události nebo všechno?";
$pgv_lang["random_media_persons"]	= "Osoby";
$pgv_lang["random_media_events"]	= "Události";
$pgv_lang["gedcom_block"]		= "Uvítací blok GEDCOM";
$pgv_lang["gedcom_descr"]		= "Uvítací blok GEDCOM funguje stejně jako uvítací blok uživatele – vítá návštěvníka stránek a zobrazuje nadpis právě prohlíženého GEDCOMu a nynější datum a čas.";
$pgv_lang["gedcom_favorites_block"]	= "Blok Oblíbených GEDCOMu";
$pgv_lang["gedcom_favorites_descr"]	= "Blok Oblíbených GEDCOMu umožňuje administrátorovi stránek vybrat své oblíbené osoby, aby k nim měli návštěvníci snazší přístup.  Je to možnost, jak zvýraznit osoby, které jsou v historii vašeho rodu důležité.";
$pgv_lang["gedcom_stats_block"]		= "Blok statistiky GEDCOMu";
$pgv_lang["gedcom_stats_descr"]		= "Blok statistiky GEDCOMu ukazuje návštěvníkovi základní informace o GEDCOM souboru, jako například čas vytvoření nebo počet osob v souboru.";
$pgv_lang["gedcom_stats_show_surnames"]	= "Zobrazit společné příjmení?";
$pgv_lang["portal_config_instructions"]	= "~#pgv_lang[customize_page]#~<br />~#pgv_lang[customize_gedcom_page]#~<br /><br />Můžete přizpůsobit stránku umístěním bloků na stránce tak, že je chcete mít.<br /><br />Stránka je rozdělena na <b>Hlavní</b> a <b>Pravý</b> sekcí. <b>Hlavní</b> část bloky se objeví větší a pod titulek stránky. <b>Právo</b> část začíná na pravé straně názvu a jde se po pravé straně na stránce.<br /><br />Každá sekce má svůj vlastní seznam bloků, které budou vytištěny na stránce v pořadí, v jakém jsou uvedeny. Můžete přidat, odebrat, změnit pořadí a bloky jak se vám zlíbí.<br /><br />Když se jeden z bloků seznamů je prázdný, zbývající bloky zabírají celou šířku stránky.<br /><br />";
$pgv_lang["login_block"]		= "Přihlašovací blok";
$pgv_lang["login_descr"]		= "Přihlašovací blok zobrazuje uživatelům uživatelské jméno a heslo k přihlášení.";
$pgv_lang["theme_select_block"] 	= "Blok pro výběr motivu";
$pgv_lang["theme_select_descr"] 	= "Blok pro výběr motivu se zobrazuje, i když není změna motivu povolena.";
$pgv_lang["block_top10_title"]		= "Nejčastější příjmení";
$pgv_lang["block_top10"]			= "Blok příjmení Top-10";
$pgv_lang["block_top10_descr"]		= "V tomto bloku vidíte tabulku 10 nejužívanějších příjmení v této databázi.";
$pgv_lang["block_givn_top10_title"]		= "10 NEJ vlastních jmen";
$pgv_lang["block_givn_top10"]			= "10 NEJ vlastních jmen";
$pgv_lang["block_givn_top10_descr"]		= "Tento blok zobrazuje tabulku s 10 nejčastějších křestních jménech v databázi. Skutečný počet uvedených názvů uvedené v tomto bloku je konfigurovatelný.";

$pgv_lang["gedcom_news_block"]		= "Blok novinek GEDCOMu";
$pgv_lang["gedcom_news_descr"]		= "Blok novinek GEDCOMu návštěvníkům ukazuje zprávy a články přidané adminem.  Tady je vhodné například upozorňovat na aktualizované GEDCOM soubory nebo oznamovat rodinná setkání.";
$pgv_lang["gedcom_news_limit"]		= "Omezte zobrazení podle:";
$pgv_lang["gedcom_news_limit_nolimit"]	= "Žádné omezení";
$pgv_lang["gedcom_news_limit_date"]		= "Věk položky";
$pgv_lang["gedcom_news_limit_count"]	= "Počet položek";
$pgv_lang["gedcom_news_flag"]		= "Omezení:";
$pgv_lang["gedcom_news_archive"] 	= "Zobrazit archiv";
$pgv_lang["user_news_block"]		= "Uživatelský deník";
$pgv_lang["user_news_descr"]		= "Uživatelský deník umožňuje uživatelům uchovávat poznámky nebo deník online.";
$pgv_lang["my_journal"]			= "Můj deník";
$pgv_lang["no_journal"]			= "Nevytvořili jste v deníku žádné položky.";
$pgv_lang["confirm_journal_delete"]	= "Opravdu chcete vymazat tuto položku z deníku?";
$pgv_lang["add_journal"]		= "Přidat do deníku nový záznam";
$pgv_lang["gedcom_news"]		= "Novinky";
$pgv_lang["confirm_news_delete"]	= "Opravdu chcete z Novinek vymazat tuto položku?";
$pgv_lang["add_news"]			= "Přidat nový článek";
$pgv_lang["no_news"]			= "Žádné články, novinky nebyly dodány.";
$pgv_lang["edit_news"]			= "Přidat/Upravit záznam v Deníku/Novinkách";
$pgv_lang["enter_title"]		= "Vložte prosím nadpis.";
$pgv_lang["enter_text"]			= "Vložte prosím text tohoto záznamu.";
$pgv_lang["news_saved"]			= "Příspěvek do Novinek/Deníku byl úspěšně uložen.";
$pgv_lang["article_text"]		= "Vložte text:";
$pgv_lang["main_section"]		= "Bloky hlavního oddílu";
$pgv_lang["right_section"]		= "Bloky pravého oddílu";
$pgv_lang["available_blocks"]		= "Dostupné bloky";
$pgv_lang["move_up"]			= "Posunout nahoru";
$pgv_lang["move_down"]			= "Posunout dolů";
$pgv_lang["move_right"]			= "Přesunout doprava";
$pgv_lang["move_left"]			= "Přesunout doleva";
$pgv_lang["broadcast_all"]		= "Rozeslat všem uživatelům";
$pgv_lang["hit_count"]			= "Počet přístupů:";
$pgv_lang["phpgedview_message"]	= "Zpráva PhpGedView";
$pgv_lang["common_surnames"]	= "Nejčastější příjmení";
$pgv_lang["default_news_title"]		= "Vítejte ve svém rodokmenu";
$pgv_lang["default_news_text"]		= "Výstup tohoto rodokmenu je zpracován pomocí <a href=\"http://www.phpgedview.net/\" target=\"_blank\">PhpGedView 3</a>.  Tato stránka nabízí úvod a přehled k tomuto rodopisu.  Pro vstup do rodokmenu vyberte z menu jedno ze schémat, seznam osob nebo vyhledávání jména či místa.<br /><br />V případě potíží s používáním tohoto systému, klikněte na nápovědu a dozvíte se, jak pracovat se stránkou, na níž se právě nacházíte.<br /><br />Děkujeme, že jste tyto stránky navštívili.";
$pgv_lang["reset_default_blocks"]	= "Obnovit původní bloky";
$pgv_lang["recent_changes"]		= "Poslední změny";
$pgv_lang["recent_changes_block"]	= "Blok posledních změn";
$pgv_lang["recent_changes_descr"]	= "V Bloku posledních změn se zobrazí všechny změny, jež byly v GEDCOMu provedeny během posledního měsíce. Tento blok vám pomůže sledovat tyto změny. Změny se rozpoznávají podle tagu CHAN.";
$pgv_lang["recent_changes_none"]	= "<b>Tam byly žádné změny během posledních #pgv_lang[global_num1]# dnů.</b><br />";
$pgv_lang["recent_changes_some"]	= "<b>Změny provedené v posledních #pgv_lang[global_num1]# dnů</b><br />";
$pgv_lang["show_empty_block"]		= "Pokud by tento blok bude skrytá, když je prázdná?";
$pgv_lang["hide_block_warn"]		= "Pokud skrýt prázdný blok, nebudete moci změnit jeho konfiguraci, až se stane viditelné již je prázdný.";
$pgv_lang["delete_selected_messages"]	= "Smazat vybrané zprávy";
$pgv_lang["use_blocks_for_default"]	= "Použít tyto bloky jako implicitní nastavení bloků pro všechny uživatele?";
$pgv_lang["block_not_configure"]	=	"Tento blok není možné konfigurovat.";

//-- validate GEDCOM
$pgv_lang["add_media_tool"]		= "Nástroj pro přidání médií";

//-- hourglass chart
$pgv_lang["hourglass_chart"]	= "Schéma přesýpacích hodin";

//-- report engine
$pgv_lang["choose_report"]		= "Vybrat zprávu, jež se má vytvořit";
$pgv_lang["enter_report_values"]	= "Zadat kritéria pro zprávu";
$pgv_lang["selected_report"]		= "Vybraná zpráva";
$pgv_lang["select_report"]		= "Vybrat zprávu";
$pgv_lang["download_report"]			= "Stáhnout zprávu";
$pgv_lang["reports"]				= "Zprávy";
$pgv_lang["pdf_reports"]			= "Zprávy v PDF";
$pgv_lang["html_reports"]			= "Zprávy v HTML";

//-- Ahnentafel report
$pgv_lang["ahnentafel_report"]		= "Seznam předků";
$pgv_lang["ahnentafel_generation"]	= "Generace";
$pgv_lang["ahnentafel_pronoun_m"]	= "On ";
$pgv_lang["ahnentafel_pronoun_f"]	= "Ona ";
$pgv_lang["ahnentafel_born_m"]		= "byl narozen";			// male
$pgv_lang["ahnentafel_born_f"]		= "byla narozena";			// female
$pgv_lang["ahnentafel_christened_m"] = "byl pokřtěn";			// male
$pgv_lang["ahnentafel_christened_f"] = "byla pokřtěna";		// female
$pgv_lang["ahnentafel_married_m"]	= "byl ženatý";			// male
$pgv_lang["ahnentafel_married_f"]	= "byla vdaná";			// female
$pgv_lang["ahnentafel_married_post"]= "&nbsp";
$pgv_lang["ahnentafel_died_m"]		= "zemřel";				// male
$pgv_lang["ahnentafel_died_f"]		= "zemřela";				// female
$pgv_lang["ahnentafel_cremated_m"]	= "byl zpopelněn";			// male
$pgv_lang["ahnentafel_cremated_f"]	= "byla zpopelněna";		// female
$pgv_lang["ahnentafel_buried_m"]	= "byl pohřben";			// male
$pgv_lang["ahnentafel_buried_f"]	= "byla pohřbena";			// female
$pgv_lang["ahnentafel_place"]		= " v ";					// place name follows this
$pgv_lang["ahnentafel_no_details"]	= " ale podrobnosti nejsou známy";
$pgv_lang["ahnentafel_on"]			= " ";

//-- Changes report
$pgv_lang["changes_report"]			= "Změny Zpráva";
$pgv_lang["changes_pending_tot"]	= "Celkem nevyřízené změny:";
$pgv_lang["changes_accepted_tot"]	= "Celkem přijaté změny:";

//-- Descendancy report
$pgv_lang["descend_report"]			= "Rozrod Zpráva";
$pgv_lang["son_of"]					= "syn";
$pgv_lang["daughter_of"]			= "dcera";
$pgv_lang["child_of"]				= "dítě ";
$pgv_lang["children_of"]			= "děti ";
$pgv_lang["descendancy_pronoun_m"]	= "On ";
$pgv_lang["descendancy_pronoun_f"]	= "Ona ";

$pgv_lang["family_group_report"]	= "Zpráva o rodině";
$pgv_lang["page"]					= "Strana";
$pgv_lang["of"] 					= "z";
$pgv_lang["enter_famid"]			= "Zadejte ID rodiny";
$pgv_lang["show_sources"]			= "Zobrazit zdroje?";
$pgv_lang["show_notes"] 			= "Zobrazit poznámky?";
$pgv_lang["show_abbr_notes"] 		= "Zobrazit zkrácené poznámky?";
$pgv_lang["show_photos"]			= "Zobrazit fotky?";
$pgv_lang["relatives_report_ext"]	= "Rozšířený Zpráva o Příbuznými";
$pgv_lang["with"]					= "s";
$pgv_lang["on"]						= "dne";			// for precise dates
$pgv_lang["in"]						= "v";			// for imprecise dates
$pgv_lang["individual_report"]		= "Zpráva o Osobě";
$pgv_lang["individual_with_rela_report"]		= "Zpráva o Blízkých Příbuzných";
$pgv_lang["enter_pid"]				= "Zadat ID osoby";
$pgv_lang["generated_by"]			= "Vytvořeno v";
$pgv_lang["birth_report"]			= "Zpráva o Datu a Místě Narození";
$pgv_lang["birthplace"]				= "Místo narození obsahuje";
$pgv_lang["birthdate1"]				= "Rozsah data narození začíná";
$pgv_lang["birthdate2"]				= "Rozsah data narození končí";
$pgv_lang["death_report"]			= "Zpráva o úmrtí datum a místo";
$pgv_lang["deathplace"]				= "Místo úmrtí obsahuje";
$pgv_lang["deathdate1"]				= "Rozsah data úmrtí začíná";
$pgv_lang["deathdate2"]				= "Rozsah data úmrtí končí";
$pgv_lang["marr_report"]			= "Zpráva o Manželství Datum a Místo";
$pgv_lang["marrplace"]				= "Místo manželství obsahuje";
$pgv_lang["marrdate1"]				= "Rozsah data manželství začíná";
$pgv_lang["marrdate2"]				= "Rozsah data manželství končí";
$pgv_lang["sort_by"]				= "Seřazeno podle";
$pgv_lang["cemetery_report"]		= "Zpráva o Hřbitovy";
$pgv_lang["burialplace"]			= "Místo pohřbení obsahuje";
$pgv_lang["fact_sources_report"]	= "Zdroje Fakta";
$pgv_lang["missing_facts_report"]	= "Chybějící údaje o příbuzných";
$pgv_lang["sources_to_events"]		= "Zdroje k událostem";

$pgv_lang["cleanup"]			= "Opravit";

//-- CONFIGURE (extra) messages for programs patriarch and statistics
$pgv_lang["statistics"]			= "Statistika";
$pgv_lang["show_stats_charts"]		= "Zobrazit statistiky grafy";
$pgv_lang["decade_birth"]			= "Desetiletí narození";
$pgv_lang["decade_death"]			= "Desetiletí úmrtí";
$pgv_lang["decade_marriage"]		= "Desetiletí manželství";
$pgv_lang["avg_age"]				= "Průměrný věk";

//-- Merge Records
$pgv_lang["merge_same"] 			= "Záznamy nejsou stejného typu. Nelze sloučit záznamy, které nejsou stejného typu.";
$pgv_lang["merge_step1"]			= "Sloučit Krok 1 ze 3";
$pgv_lang["merge_step2"]			= "Sloučit Krok 2 ze 3";
$pgv_lang["merge_step3"]			= "Sloučit Krok 3 ze 3";
$pgv_lang["select_gedcom_records"]	= "Vyberte dva GEDCOM záznamy sloučit. Tyto záznamy musí být stejného typu.";
$pgv_lang["merge_to"]				= "Sloučení Do ID:";
$pgv_lang["merge_from"] 			= "Sloučení Z ID:";
$pgv_lang["merge_facts_same"]		= "Následující fakta byly přesně stejný v obou záznamech a budou sloučeny automaticky.";
$pgv_lang["no_matches_found"]		= "Nebyly nalezeny žádné odpovídající fakta nalezeny";
$pgv_lang["unmatching_facts"]		= "Následující fakta neodpovídají. Vyberte informace, které chcete zachovat.";
$pgv_lang["record"] 				= "Záznam";
$pgv_lang["adding"] 				= "Vkládání";
$pgv_lang["updating_linked"]		= "Aktualizace propojený záznamu";
$pgv_lang["merge_more"] 			= "Sloučit více záznamů.";
$pgv_lang["same_ids"]				= "Zadali jste stejné ID. Nemůžete sloučit stejné záznamy.";
$pgv_lang["updated_favorites"] 			= "Oblíbených aktualizováno.";

//-- ANCESTRY FILE MESSAGES
$pgv_lang["ancestry_chart"] 		= "Přehled předků";
$pgv_lang["gen_ancestry_chart"]		= "Přehled předků do #PEDIGREE_GENERATIONS#. pokolení";
$pgv_lang["chart_style"]			= "Styl schématu";
$pgv_lang["chart_list"]				= "Seznam";
$pgv_lang["chart_booklet"]   		= "Kniha";
$pgv_lang["show_cousins"]			= "Zobrazit bratrance";
// 1st generation
$pgv_lang["sosa_2"] 				= "Otec";
$pgv_lang["sosa_3"] 				= "Matka";
// 2nd generation
$pgv_lang["sosa_4"] 				= "Děd";
$pgv_lang["sosa_5"] 				= "Bába";
$pgv_lang["sosa_6"] 				= "Děd";
$pgv_lang["sosa_7"] 				= "Bába";
// 3rd generation
$pgv_lang["sosa_8"] 				= "Pra-děd";
$pgv_lang["sosa_9"] 				= "Pra-bába";
$pgv_lang["sosa_10"]				= "Pra-děd";
$pgv_lang["sosa_11"]				= "Pra-bába";
$pgv_lang["sosa_12"]				= "Pra-děd";
$pgv_lang["sosa_13"]				= "Pra-bába";
$pgv_lang["sosa_14"]				= "Pra-děd";
$pgv_lang["sosa_15"]				= "Pra-bába";
// 4th generation
##$pgv_lang["sosa_16"]				= "Great-great-grandfather";
##$pgv_lang["sosa_17"]				= "Great-great-grandmother";
##$pgv_lang["sosa_18"]				= "Great-great-grandfather";
##$pgv_lang["sosa_19"]				= "Great-great-grandmother";
##$pgv_lang["sosa_20"]				= "Great-great-grandfather";
##$pgv_lang["sosa_21"]				= "Great-great-grandmother";
##$pgv_lang["sosa_22"]				= "Great-great-grandfather";
##$pgv_lang["sosa_23"]				= "Great-great-grandmother";
##$pgv_lang["sosa_24"]				= "Great-great-grandfather";
##$pgv_lang["sosa_25"]				= "Great-great-grandmother";
##$pgv_lang["sosa_26"]				= "Great-great-grandfather";
##$pgv_lang["sosa_27"]				= "Great-great-grandmother";
##$pgv_lang["sosa_28"]				= "Great-great-grandfather";
##$pgv_lang["sosa_29"]				= "Great-great-grandmother";
##$pgv_lang["sosa_30"]				= "Great-great-grandfather";
##$pgv_lang["sosa_31"]				= "Great-great-grandmother";
$pgv_lang["sosa_16"]				= "Pra-pra-děd";
$pgv_lang["sosa_17"]				= "Pra-pra-bába";
$pgv_lang["sosa_18"]				= "Pra-pra-děd";
$pgv_lang["sosa_19"]				= "Pra-pra-bába";
$pgv_lang["sosa_20"]				= "Pra-pra-děd";
$pgv_lang["sosa_21"]				= "Pra-pra-bába";
$pgv_lang["sosa_22"]				= "Pra-pra-děd";
$pgv_lang["sosa_23"]				= "Pra-pra-bába";
$pgv_lang["sosa_24"]				= "Pra-pra-děd";
$pgv_lang["sosa_25"]				= "Pra-pra-bába";
$pgv_lang["sosa_26"]				= "Pra-pra-děd";
$pgv_lang["sosa_27"]				= "Pra-pra-bába";
$pgv_lang["sosa_28"]				= "Pra-pra-děd";
$pgv_lang["sosa_29"]				= "Pra-pra-bába";
$pgv_lang["sosa_30"]				= "Pra-pra-děd";
$pgv_lang["sosa_31"]				= "Pra-pra-bába";
// 5th generation
$pgv_lang["sosa_32"]			   = "Pra-pra-pra-děd";
$pgv_lang["sosa_33"]			   = "Pra-pra-pra-bába";
$pgv_lang["sosa_34"]			   = "Pra-pra-pra-děd";
$pgv_lang["sosa_35"]			   = "Pra-pra-pra-bába";
$pgv_lang["sosa_36"]			   = "Pra-pra-pra-děd";
$pgv_lang["sosa_37"]			   = "Pra-pra-pra-bába";
$pgv_lang["sosa_38"]			   = "Pra-pra-pra-děd";
$pgv_lang["sosa_39"]			   = "Pra-pra-pra-bába";
$pgv_lang["sosa_40"]			   = "Pra-pra-pra-děd";
$pgv_lang["sosa_41"]			   = "Pra-pra-pra-bába";
$pgv_lang["sosa_42"]			   = "Pra-pra-pra-děd";
$pgv_lang["sosa_43"]			   = "Pra-pra-pra-bába";
$pgv_lang["sosa_44"]			   = "Pra-pra-pra-děd";
$pgv_lang["sosa_45"]			   = "Pra-pra-pra-bába";
$pgv_lang["sosa_46"]			   = "Pra-pra-pra-děd";
$pgv_lang["sosa_47"]			   = "Pra-pra-pra-bába";
$pgv_lang["sosa_48"]			   = "Pra-pra-pra-děd";
$pgv_lang["sosa_49"]			   = "Pra-pra-pra-bába";
$pgv_lang["sosa_50"]			   = "Pra-pra-pra-děd";
$pgv_lang["sosa_51"]			   = "Pra-pra-pra-bába";
$pgv_lang["sosa_52"]			   = "Pra-pra-pra-děd";
$pgv_lang["sosa_53"]			   = "Pra-pra-pra-bába";
$pgv_lang["sosa_54"]			   = "Pra-pra-pra-děd";
$pgv_lang["sosa_55"]			   = "Pra-pra-pra-bába";
$pgv_lang["sosa_56"]			   = "Pra-pra-pra-děd";
$pgv_lang["sosa_57"]			   = "Pra-pra-pra-bába";
$pgv_lang["sosa_58"]			   = "Pra-pra-pra-děd";
$pgv_lang["sosa_59"]			   = "Pra-pra-pra-bába";
$pgv_lang["sosa_60"]			   = "Pra-pra-pra-děd";
$pgv_lang["sosa_61"]			   = "Pra-pra-pra-bába";
$pgv_lang["sosa_62"]			   = "Pra-pra-pra-děd";
$pgv_lang["sosa_63"]			   = "Pra-pra-pra-bába";

// for the general case of ancestors of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["sosa_paternal_male_n_generations"]	= "%3\$d x otcovský praděd";
$pgv_lang["sosa_paternal_female_n_generations"]	= "%3\$d x otcovský prabába";
$pgv_lang["sosa_maternal_male_n_generations"]	= "%3\$d x mateřský praděd";
$pgv_lang["sosa_maternal_female_n_generations"]	= "%3\$d x mateřský prabába";

//-- FAN CHART
$pgv_lang["compact_chart"]			= "Kompaktní Graf";
$pgv_lang["fan_chart"]				= "Vějířové schéma";
$pgv_lang["gen_fan_chart"]  		= "#PEDIGREE_GENERATIONS# - generační vějířové schéma";
$pgv_lang["fan_width"]				= "Šířka vějíře";
$pgv_lang["gd_library"]				= "Špatná konfigurace PHP serveru: pro práci s obrázky je třeba knihovna GD 2.x.";
$pgv_lang["gd_freetype"]			= "Špatná konfigurace PHP serveru: Pro práci s TrueType fonty je potřeba knihovna Freetype.";
$pgv_lang["gd_helplink"]			= "http://www.php.net/gd";
$pgv_lang["fontfile_error"]			= "Soubor s tímto fontem nebyl na PHP serveru nalezen.";
$pgv_lang["fanchart_IE"]			= "Tento Vějířové schéma obrázek nelze vytisknout přímo ve vašem prohlížeči. Použijte klepněte pravým tlačítkem myši a pak uložit a vytisknout.";

//-- RSS Feed
$pgv_lang["rss_descr"]				= "Novinky a odkazy ze stránky #GEDCOM_TITLE#";
$pgv_lang["rss_logo_descr"]			= "Materiál vytvořilo PhpGedView";
$pgv_lang["rss_feeds"]				= "RSS kanály";
$pgv_lang["no_feed_title"]			= "Kanály není k dispozici";
$pgv_lang["no_feed"]				= "Neexistuje žádné RSS kanál pro tento PhpGedView stránky";
$pgv_lang["feed_login"]				= "Pokud máte účet na této stránce PhpGedView, můžete <a href=\"#AUTH_URL#\">se přihlásit</a> k serveru pomocí základní ověřování HTTP zobrazit soukromé informace.";
$pgv_lang["authenticated_feed"]		= "Ověřený Kanál";

//-- ASSOciates RELAtionship
// After any change in the following list, please check $assokeys in edit_interface.php
$pgv_lang["attendant"] = "Hlídač";
$pgv_lang["attending"] = "Navštěvující";
$pgv_lang["best_man"] = "Družba";
$pgv_lang["bridesmaid"] = "Družička";
$pgv_lang["buyer"] = "Kupec";
$pgv_lang["circumciser"] = "Circumciser";
$pgv_lang["civil_registrar"] = "Občanský soudní kanceláře";
$pgv_lang["employee"] = "Zaměstnanec";
$pgv_lang["employer"] = "Zaměstnavatel";
$pgv_lang["foster_child"] = "Živitní dítě";
$pgv_lang["foster_father"] = "Živitní otec";
$pgv_lang["foster_mother"] = "Živitní matka";
$pgv_lang["friend"] = "Známý";
$pgv_lang["godfather"] = "Kmotr";
$pgv_lang["godmother"] = "Kmotra";
$pgv_lang["godparent"] = "Kmotru";
$pgv_lang["godson"]		= "Kmotřenec";
$pgv_lang["goddaughter"] = "Kmotřenka";
$pgv_lang["godchild"]	= "Kmotřenec";
$pgv_lang["guardian"]	= "Poručník";
$pgv_lang["informant"] = "Informátor";
$pgv_lang["lodger"] = "Podnájemník";
$pgv_lang["nanny"] = "Chůva";
$pgv_lang["nurse"] = "Ošetřovatelka";
$pgv_lang["owner"] = "Vlastník";
$pgv_lang["priest"] = "Kněz";
$pgv_lang["rabbi"] = "Rabín";
$pgv_lang["registry_officer"] = "Úředník Rejstříku";
$pgv_lang["seller"] = "Prodavač";
$pgv_lang["servant"] = "Sluha";
$pgv_lang["slave"] = "Otrok";
$pgv_lang["twin"] = "Dvojče";
$pgv_lang["twin_brother"] = "Bratr dvojče";
$pgv_lang["twin_sister"] = "Sestra dvojče";
$pgv_lang["ward"] = "Schovanec";
$pgv_lang["witness"] = "Svědek";

//-- statistics utility
$pgv_lang["stat_create"]		= "Vytvořte si vlastní graf";
$pgv_lang["statutci"]			= "schopen vytvořit index";
$pgv_lang["statnnames"]			= "Celkem osoby";
$pgv_lang["statnfam"]			= "Celkem rodiny";
$pgv_lang["statnmale"]			= "Celkem muži";
$pgv_lang["statnfemale"]		= "Celkem ženy";
$pgv_lang["with_sources"]		= "Se zdroji";
$pgv_lang["without_sources"]	= "bez zdrojů";
$pgv_lang["stat_sindi"]			= "Občané se zdroji";
$pgv_lang["stat_sfam"]			= "Rodiny se zdroji";
$pgv_lang["statvars"]			= "Vyplňte následující parametry pro graf";
$pgv_lang["statlxa"]			= "Vyberte typ grafu:";
$pgv_lang["statlya"]			= "výsledky:";
$pgv_lang["statlza"]			= "Kategorií:";
$pgv_lang["map_type"]			= "Typ mapy:";
$pgv_lang["stat_1_map"]			= "Rozdělení osob";
$pgv_lang["stat_2_map"]			= "Narození podle země";
$pgv_lang["stat_3_map"]			= "Úmrtí podle země";
$pgv_lang["stat_4_map"]			= "Manželství podle země";
$pgv_lang["stat_5_birth"]		= "Narození podle století";
$pgv_lang["stat_6_death"]		= "Úmrtí podle století";
$pgv_lang["stat_7_marr"]		= "Sňatky podle století";
$pgv_lang["stat_7_div"]			= "Rozvody podle století";
$pgv_lang["stat_8_fam"]			= "Rodiny se zdroji";
$pgv_lang["stat_9_indi"]		= "Osoby se zdroji";
$pgv_lang["stat_10_none"]		= "žádný";
$pgv_lang["stat_11_mb"]			= "Měsíc narození";
$pgv_lang["stat_12_md"]			= "Měsíc úmrtí";
$pgv_lang["stat_13_mm"]			= "Měsíc manželství";
$pgv_lang["stat_14_mb1"]		= "Měsíc narození prvního dítěte v vztahu";
$pgv_lang["stat_15_mm1"]		= "Měsíc prvního manželství";
$pgv_lang["stat_16_mmb"]		= "Měsíců mezi manželství a první dítě";
$pgv_lang["stat_17_arb"]		= "Věk v porovnání s rokem narození";
$pgv_lang["stat_18_ard"]		= "Věk v porovnání s rokem úmrtí";
$pgv_lang["stat_18_aard"]		= "Průměrný věk v porovnání s století úmrtí";
$pgv_lang["stat_19_arm"]		= "Věk v roce sňatku";
$pgv_lang["stat_19_aarm"]		= "Průměrný věk v století manželství";
$pgv_lang["stat_20_arm1"]		= "Věk v roce prvního manželství";
$pgv_lang["stat_21_nok"]		= "Počet dětí";
$pgv_lang["stat_22_fwok"]		= "Počet bezdětných rodin";
$pgv_lang["stat_200_none"]		= "všechno (nebo prázdné)";
$pgv_lang["stat_201_num"]		= "počty";
$pgv_lang["stat_202_perc"]		= "procenta";
$pgv_lang["stat_300_none"]		= "nic";
$pgv_lang["stat_301_mf"]		= "pohlaví";
$pgv_lang["stat_302_cgp"]		= "Datum intervaly";
$pgv_lang["century"]			= "století";
$pgv_lang["stat_age"]			= "Věk";
$pgv_lang["no_date_fam"]		= "neznámý";
$pgv_lang["statar_xgp"]			= "Hranice pro intervalech:";
$pgv_lang["statar_xgl"]			= "Hranice pro věky:";
$pgv_lang["statar_xgm"]			= "Hranice pro měsíce:";
$pgv_lang["statar_xga"]			= "Hranice pro čísla:";
$pgv_lang["statar_zgp"]			= "Hranice pro data intervalech:";
$pgv_lang["less"]				= "méně než";
$pgv_lang["over"]				= "více než";
$pgv_lang["interval"]			= "interval";
$pgv_lang["aft_marr"]			= "měsíců po sňatku";
$pgv_lang["bef_marr"]			= "měsíců před a po sňatku";
$pgv_lang["quarters"]			= "čtvrtletí po sňatku";
$pgv_lang["half_year"]			= "půlroků po sňatku";
$pgv_lang["one_child"]			= "interval jedno dítě";
$pgv_lang["two_children"]		= "interval dvě děti";
$pgv_lang["statreset"]			= "přesázet";
$pgv_lang["statsubmit"]			= "zobrazit graf";
$pgv_lang["stat_largest_families"] = "Největší rodiny";

$pgv_lang["stat_own_charts"]		= "Vlastní grafy";
$pgv_lang["statnliving"]			= "Celkově žijících";
$pgv_lang["statndead"]				= "Celkově úmrtí";
$pgv_lang["stat_births"]			= "Celkově narození";
$pgv_lang["stat_marriages"]			= "Celkově sňatků";
$pgv_lang["stat_divorces"]			= "Celkově rozvodů";
$pgv_lang["stat_deaths"]			= "Celkově úmrtí";
$pgv_lang["stat_first_birth"]		= "Nejstarší narození";
$pgv_lang["stat_first_marriage"]	= "Nejstarší sňatek";
$pgv_lang["stat_first_divorce"]		= "Nejstarší rozvod";
$pgv_lang["stat_first_death"]		= "Nejstarší úmrtí";
$pgv_lang["stat_last_birth"]		= "Poslední narození";
$pgv_lang["stat_last_marriage"]		= "Poslední sňatek";
$pgv_lang["stat_last_divorce"]		= "Poslední rozvod";
$pgv_lang["stat_last_death"]		= "Poslední úmrtí";
$pgv_lang["stat_lifespan"]			= "Délka života";
$pgv_lang["stat_lived_longest"]		= "Nejvyšší věk úmrtí";
$pgv_lang["stat_live_longest"]		= "Nejstarší žijící";
$pgv_lang["stat_marr_age"]			= "Trvání manželství";
$pgv_lang["stat_long_marr_age"]		= "Nejdelší manželství";
$pgv_lang["stat_short_marr_age"]	= "Nejkratší manželství";
$pgv_lang["stat_youngest_male"]		= "Nejmladší muž";
$pgv_lang["stat_youngest_female"]	= "Nejmladší žena";
$pgv_lang["stat_oldest_male"]		= "Nejstarší muž";
$pgv_lang["stat_oldest_female"]		= "Nejstarší žena";
$pgv_lang["stat_childbirth_age"]	= "Věk při narození dítěte";
$pgv_lang["stat_youngest_father"]	= "Nejmladší otec";
$pgv_lang["stat_youngest_mother"]	= "Nejmladší matka";
$pgv_lang["stat_oldest_father"]		= "Nejstarší otec";
$pgv_lang["stat_oldest_mother"]		= "Nejstarší matka";
$pgv_lang["stat_children_in_fam"]	= "Dětí v rodině";
$pgv_lang["stat_largest_gfamilies"]	= "Nejširší rodiny";
$pgv_lang["stat_age_difference"]	= "Rozdíl věku";
$pgv_lang["stat_age_siblings"]		= "Rozdíl věku mezi sourozenci ";
$pgv_lang["stat_top_age_siblings"]	= "Nejvyšší rozdíl věku mezi sourozenci";
$pgv_lang["stat_age_mf_spouse"]		= "Rozdíl věku mezi manželem a manželkou";
$pgv_lang["stat_age_fm_spouse"]		= "Rozdíl věku mezi manželkou a manželem";
$pgv_lang["stat_names"]				= "Jména";
$pgv_lang["statnsurnames"]			= "Celkově příjmení";
$pgv_lang["statngivennames"]		= "Celkově vlastních jmen";
$pgv_lang["top_surnames"]			= "NEJ příjmení";
$pgv_lang["top_givennames"]			= "NEJ vlastních jmen";
$pgv_lang["events"]					= "Události";
$pgv_lang["stat_records"]			= "Záznamy";
$pgv_lang["stat_notes"]				= "Poznámky";
$pgv_lang["stat_first_event"]		= "První událost";
$pgv_lang["stat_last_event"]		= "Poslední událost";
$pgv_lang["stat_places"]			= "Místa";
$pgv_lang["stat_birth_places"]		= "Místa narození";
$pgv_lang["stat_marriage_places"]	= "Místa sňatků";
$pgv_lang["stat_death_places"]		= "Místa úmrtí";
$pgv_lang["stat_countries"]			= "Události ve státech";

//-- statisticsplot utility
$pgv_lang["statistiek_list"]	= "Statistika graf";
$pgv_lang["stpl"]				= "...";
$pgv_lang["stplinfo"]			= "kreslení informace:";
$pgv_lang["stpltype"]			= "typ:";
$pgv_lang["stplnoim"]			= "není implementováno:";
$pgv_lang["stplmf"]				= "na pohlaví";
$pgv_lang["stplipot"]			= "na časový úsek";
$pgv_lang["stplmonth"]			= "měsíc";
$pgv_lang["stplnumbers"]		= "čísla";
$pgv_lang["stplnuch"]			= "děti";
$pgv_lang["stplage"]			= "věk";
$pgv_lang["stplperc"]			= "procento";
$pgv_lang["stplnumof"]			= "Počty";
$pgv_lang["stplmarrbirth"]		= "Měsíců mezi sňatkem a narozením prvního dítěte";
$pgv_lang["indi_distribution_chart"]	= "Graf rozložení osob";
$pgv_lang["surname_distribution_chart"]	= "Graf distribuce příjmení";
$pgv_lang["g_chart_high"]		= "Nejvyšší populace";
$pgv_lang["g_chart_low"]		= "Nejnižší populace";
$pgv_lang["g_chart_nobody"]		= "Nikdo vůbec";
$pgv_lang["area_chart"]			= "Zeměpisná oblast";
$pgv_lang["europe_chart"]		= "Evropa";
$pgv_lang["s_america_chart"]	= "Jižní Amerika";
$pgv_lang["asia_chart"]			= "Asie";
$pgv_lang["middle_east_chart"]	= "Střední Východ";
$pgv_lang["africa_chart"]		= "Afrika";
$pgv_lang["world_chart"]		= "Svět";

//-- alive in year
$pgv_lang["alive_in_year"]			= "Živý v roce";
$pgv_lang["is_alive_in"]			= "Je živý v roce #YEAR#";
$pgv_lang["alive"]					= "Živý ";
$pgv_lang["dead"]					= "Mrtvý ";
$pgv_lang["maybe"]					= "Možná";
$pgv_lang["both_alive"]				= "Oba živí ";
$pgv_lang["both_dead"]				= "Oba mrtví ";

//-- Help system
$pgv_lang["definitions"]			= "Definice";

//-- Index_edit
$pgv_lang["block_desc"]				= "Popisy Bloků";
$pgv_lang["click_here"]				= "Klikni sem pro pokračování";
$pgv_lang["click_here_help"]		= "~#pgv_lang[click_here]#~<br /><br />Klikněte na toto tlačítko pro uložení změn.<br /><br />Ty budou vráceny do straně #pgv_lang[welcome]# nebo #pgv_lang[mygedview]#, ale vaše změny nemusí být zobrazeny. Možná budete muset použít Strana znovu načíst funkci vašem prohlížeči pro zobrazení změny správně.";
$pgv_lang["block_summaries"]		= "~#pgv_lang[block_desc]#~<br /><br />Zde je krátký popis každého bloku lze umístit na straně #pgv_lang[welcome]# nebo #pgv_lang[mygedview]#.<br /><br /><table border='1' width='95%'><tr><td class='list_value'><b>#pgv_lang[name]#</b></td><td class='list_value'><b>#pgv_lang[description]#</b></td></tr>#GLOBALS[blockSummaries]#</table>";

//-- Find page
$pgv_lang["total_places"]			= "Místa nalezeno";
$pgv_lang["media_contains"]			= "Média obsahuje:";
$pgv_lang["repo_contains"]			= "Repozitář obsahuje:";
$pgv_lang["shared_note_contains"]	= "Společná poznámka obsahuje:";
$pgv_lang["source_contains"]		= "Zdroj obsahuje";
$pgv_lang["display_all"]			= "Zobrazit všechny";

// FAQ Page
$pgv_lang["add_faq_header"] = "Název Časté otázky";
$pgv_lang["add_faq_body"] = "Tělo Časté otázky";
$pgv_lang["add_faq_order"] = "Pozice Časté otázky";
$pgv_lang["add_faq_visibility"] = "Viditelnost Časté otázky";
$pgv_lang["no_faq_items"] = "Seznam Časté otázky je prázdný";
$pgv_lang["position_item"] = "Pozice položka";
$pgv_lang["faq_list"] = "Seznam Časté otázky";
$pgv_lang["confirm_faq_delete"] = "Jste si jisti, že chcete smazat tuto položku Časté otázky?";
$pgv_lang["preview"] =  "Předpremiéra";
$pgv_lang["no_id"] = "Žádné ID Časté otázky nebyl zadán !";

// Help search
$pgv_lang["hs_title"]			= "Hledat textu nápovědy";
$pgv_lang["hs_search"]			= "Hledat";
$pgv_lang["hs_close"]			= "Zavřít okno";
$pgv_lang["hs_results"]			= "Nalezené výsledky:";
$pgv_lang["hs_keyword"]			= "Hledat";
$pgv_lang["hs_searchin"]		= "Hledat ve";
$pgv_lang["hs_searchuser"]		= "Nápověda pro uživatele";
$pgv_lang["hs_searchmodules"]	= "Nápověda k modulům";
$pgv_lang["hs_searchconfig"]	= "Nápověda pro administrátory";
$pgv_lang["hs_searchhow"]		= "Typ hledání";
$pgv_lang["hs_searchall"]		= "Všechna slova";
$pgv_lang["hs_searchany"]		= "Každé slovo";
$pgv_lang["hs_searchsentence"]	= "Přesná fráze";
$pgv_lang["hs_intruehelp"]		= "Pouze text nápovědy";
$pgv_lang["hs_inallhelp"]		= "Celý text";

// Media import
$pgv_lang["choose"] = "Vyberte:";
$pgv_lang["account_information"] = "Informace o účtu";

//-- Media item "TYPE" sub-field
$pgv_lang["TYPE__audio"] = "Audio";
$pgv_lang["TYPE__book"] = "Svazeček";
$pgv_lang["TYPE__card"] = "Karta";
$pgv_lang["TYPE__certificate"] = "Certifikát";
$pgv_lang["TYPE__coat"] = "Erb";
$pgv_lang["TYPE__document"] = "Dokument";
$pgv_lang["TYPE__electronic"] = "Elektronický";
$pgv_lang["TYPE__fiche"] = "Mikrofiše";
$pgv_lang["TYPE__film"] = "Mikrofilm";
$pgv_lang["TYPE__magazine"] = "Časopis";
$pgv_lang["TYPE__manuscript"] = "Rukopis";
$pgv_lang["TYPE__map"] = "Mapa";
$pgv_lang["TYPE__newspaper"] = "Noviny";
$pgv_lang["TYPE__photo"] = "Fotografie";
$pgv_lang["TYPE__tombstone"] = "Náhrobek";
$pgv_lang["TYPE__video"] = "Video";
$pgv_lang["TYPE__painting"] = "Malování";
$pgv_lang["TYPE__other"] = "Ostatní";

//-- Other media suff
$pgv_lang["view_slideshow"]			= "Zobrazit jako prezentaci";
$pgv_lang["download_image"]			= "Stáhnout soubor";
$pgv_lang["no_media"]				= "Žádné média nalezeno";
$pgv_lang["media_privacy"]			= "Soukromí omezení zabránit zobrazení této položky";
$pgv_lang["relations_heading"]		= "Obrázek se týká:";
$pgv_lang["file_size"]				= "Velikost souboru";
$pgv_lang["img_size"]				= "Velikost obrázku";
$pgv_lang["media_broken"]			= "Tento mediální soubor je poškozen a nelze vodotiskem";
$pgv_lang["unknown_mime"]			= "Chyba Média Firewall: >Neznámý Typ Mime< pro tento soubor";

//-- Modules
$pgv_lang["module_error_unknown_action_v2"] = "Neznámý Akce: [action].";
$pgv_lang["module_error_unknown_type"] = "Neznámý Typ Modulu";

//-- sortable tables buttons
$pgv_lang["button_alive_in_year"] = "Ukázat osoby, které žily v zadaném roce.";
$pgv_lang["button_BIRT_Y100"] = "Ukázat osoby narozené během posledních 100 let.";
$pgv_lang["button_BIRT_YES"] = "Ukázat osoby narozené před více než 100 lety.";
$pgv_lang["button_DEAT_H"] = "Ukázat páry, kde zemřel pouze manžel.";
$pgv_lang["button_DEAT_N"] = "Ukázat osoby, které žijí nebo páry, kde žijí oba manželé.";
$pgv_lang["button_DEAT_W"] = "Ukázat páry, kde zemřela pouze manželka.";
$pgv_lang["button_DEAT_Y"] = "Ukázat osoby, které zemřely nebo páry, kde oba partneři zemřeli.";
$pgv_lang["button_DEAT_Y100"] = "Ukázat osoby, které zemřely během posledních 100 let.";
$pgv_lang["button_DEAT_YES"] = "Ukázat osoby, které zemřely před více než 100 lety.";
$pgv_lang["button_MARR_DIV"] = "Ukázat rozvedené páry.";
$pgv_lang["button_MARR_U"] = "Ukázat páry s neznámým datem sňatku.";
$pgv_lang["button_MARR_Y100"] = "Ukázat páry které se vzaly během posledních 100 let.";
$pgv_lang["button_MARR_YES"] = "Ukázat páry, které se vzaly před více než 100 lety.";
$pgv_lang["button_reset"] = "Obnovit výchozí v seznamu";
$pgv_lang["button_SEX_F"] = "Ukázat pouze ženy.";
$pgv_lang["button_SEX_M"] = "Ukázat pouze muže.";
$pgv_lang["button_SEX_U"] = "Ukázat pouze osoby, jejichž pohlaví je neznámé.";
$pgv_lang["button_TREE_L"] = "Zobrazit «opustí» páry nebo jednotlivce. Jsou jedinci, kteří jsou naživu, ale nemají žádné děti zaznamenané v databázi.";
$pgv_lang["button_TREE_R"] = "Zobrazit «kořeny» páry nebo jednotlivce. Tito lidé mohou být také nazývány «patriarchové». Jsou jedinci, kteří nemají žádné rodiče zaznamenané v databázi.";
$pgv_lang["sort_column"] = "Seřadit podle tohoto sloupce.";
?>
