<?php
/**
 * Lithuanian Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2024  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author Arturas Sleinius
 * @translator Google Translate
 * @version $Id: lang.lt.php 7374 2024-02-13 13:57:05Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["birth_M"]				= "#name#o gimtadienis";		// For male persons
$pgv_lang["birth_F"]				= "#name#o gimtadienis";		// For female persons
$pgv_lang["born_in_M"]				= "Jis gimė #date# #place#";		// For male persons
$pgv_lang["born_in_F"]				= "Ji gimė #date# #place#";		// For female persons
$pgv_lang["born_on_M"]				= "Jis gimė #date#";		// For male persons
$pgv_lang["born_on_F"]				= "Ji gimė #date#";		// For female persons
$pgv_lang["death_M"]				= "#name# mirties jubiliejus";		// For male persons
$pgv_lang["death_F"]				= "#name# mirties jubiliejus";		// For female persons
$pgv_lang["died_in_M"]				= "Mirė #date# #place#";		// For male persons
$pgv_lang["died_in_F"]				= "Mirė #date# #place#";		// For female persons
$pgv_lang["died_on_M"]				= "Mirė #date#";		// For male persons
$pgv_lang["died_on_F"]				= "Mirė #date#";		// For female persons
$pgv_lang["anniversary_of"]			= "#husband# ir #wife# vestuvių jubiliejus";
$pgv_lang["married_in"]				= "Vedęs #date# #place#";
$pgv_lang["married_on"]				= "Vedęs #date#";
$pgv_lang["clustrmaps_locations"]	= "Vietos šio puslapio lankytojų";
$pgv_lang["duplicate_username"] 	= "Pasikartojantis vardas. Naudotojas tokiu vardu jau egzistuoja. Pasirinkite kita naudotojo varda.";
$pgv_lang["none"]					= "Nieko";
$pgv_lang["family"] 				= "Šeima";
$pgv_lang["invalid_search_input"] 	= "Prie metu dar  iveskite  varda, pavarde ar \n\t vieta";
$pgv_lang["multi_site_search"] 		= "Keleto svetainiu paieška";

//-- GENERAL HELP MESSAGES
$pgv_lang["date_of_entry"]				= "Orginalaus šaltinius irašo data";
$pgv_lang["password"]				= "Slaptažodis";
$pgv_lang["confirm"]				= "Patvirtinkite slaptažodi";
$pgv_lang["login"]					= "Pasisveikinti";
$pgv_lang["login_aut"]				= "Taisyti naudotoja";
$pgv_lang["logout"] 				= "Atsisveikinti";
$pgv_lang["admin"]					= "Administruoti";
$pgv_lang["logged_in_as"]			= "Pasisveikines ";
$pgv_lang["my_pedigree"]			= "Mano kilme";
$pgv_lang["my_indi"]				= "Mano asmeninis irašas";
$pgv_lang["yes"]					= "Taip";
$pgv_lang["no"] 					= "Ne";
$pgv_lang["no_support"] 			= "Mes nustateme, kad Jusu naršykle nepalaiko standartu, naudojamu sitame PhpGedView puslapyje. Daugumos naršykliu naujesnes versijos palaiko šiuos standartus. Prašom atnaujinti savo naršykle naujesne.";
$pgv_lang["change_theme"]			= "Pakeisti tema";
$pgv_lang["index_header"]			= "Kilmes medis";
$pgv_lang["gen_ped_chart"]			= "#PEDIGREE_GENERATIONS#  Kartu kilmes diagrama";
$pgv_lang["generations"]			= "Kartos";
$pgv_lang["view"]					= "Rodyti";
$pgv_lang["fam_spouse"] 			= "Šeima su sutuoktiniu";
$pgv_lang["root_person"]			= "Šakninio asmens ID";
$pgv_lang["show_details"]			= "Rodyti detales";
$pgv_lang["start_at_parents"]		= "Pradeti kaip tevai";
$pgv_lang["zoom_box"]				= "Padidinti/sumažinti ši bloka.";
$pgv_lang["portrait"]				= "Vertikaliai";
$pgv_lang["landscape"]				= "Horizontaliai";
$pgv_lang["hide_details"]			= "Paslepti detales";
$pgv_lang["lists"]					= "Sarašai";
$pgv_lang["charts"] 				= "Diagramos";
$pgv_lang["welcome_page"]			= "Pirminis puslapis";
$pgv_lang["max_generation"] 		= "Didžiausias kilmes kartu skaicius yra #PEDIGREE_GENERATIONS#.";
$pgv_lang["min_generation"] 		= "Mažiausias kilmes kartu skaicius yra 3.";
$pgv_lang["box_width"] 				= "Dežutes plotis";
$pgv_lang["unable_to_find_family"]	= "Nerandu šeimos su ID";
$pgv_lang["unable_to_find_indi"]	= "Nerandu asmens su ID";
$pgv_lang["unable_to_find_record"]	= "Nerandu irašo su ID";
$pgv_lang["unable_to_find_source"]	= "Nerandu šaltinio su ID";
$pgv_lang["unable_to_find_repo"]	= "Nerandu saugyklos su ID";
$pgv_lang["repo_name"]				= "Saugyklos vardas:";
$pgv_lang["address"]				= "Adresas:";
$pgv_lang["phone"]					= "Telefonas:";
$pgv_lang["source_name"]			= "Šaltinio vardas:";
$pgv_lang["title"]					= "Antrašte";
$pgv_lang["author"] 				= "Autorius:";
$pgv_lang["publication"]			= "Straipsnis:";
$pgv_lang["living"] 				= "Gyvi";
$pgv_lang["private"]				= "Privati";
$pgv_lang["birth"]					= "Gime:";
$pgv_lang["death"]					= "Mire:";
$pgv_lang["descend_chart"]			= "Palikuoniu diagrama";
$pgv_lang["individual_list"]		= "Asmenu sarašas";
$pgv_lang["family_list"]			= "Šeimu sarašas";
$pgv_lang["source_list"]			= "Šaltiniu sarašas";
$pgv_lang["place_list"] 			= "Vietoviu hierarchija";
$pgv_lang["place_list_aft"] 		= "Vietoviu herarchija po ";
$pgv_lang["media_list"] 			= "Multimedia sarašas";
$pgv_lang["search"] 				= "Paieška";
$pgv_lang["search_soundex"]			= "Soundex paieška";
$pgv_lang["search_prtall"]			= "Visi vardai";
$pgv_lang["search_more_chars"]      = "Prašome suvesti viena ar daugiau simboliu";
$pgv_lang["search_sources"]			= "Šalitiniu";
$pgv_lang["search_indis"]			= "Asmenu";
$pgv_lang["search_inrecs"]			= "Ieškoti";
$pgv_lang["search_fams"]			= "Šeimos";
$pgv_lang["clippings_cart"] 		= "Šeimos medžio iškarpu krepšelis";
$pgv_lang["not_an_array"]			= "Nera masyve";
$pgv_lang["search_general"]			= "Bendra paieška";
$pgv_lang["print_preview"]			= "Versija spausdinimui";
$pgv_lang["cancel_preview"] 		= "Atgal i normalia peržiura";
$pgv_lang["change_lang"]			= "Pakeisti kalba";
$pgv_lang["print"]					= "Spausdinti";
$pgv_lang["total_queries"]			= "Iš viso duomenu bazes užklausu:";
$pgv_lang["back"]					= "Atgal";
$pgv_lang["privacy_list_indi_error"]= "Saugumo sumetimais vienas ar keletas asmenu yra nerodomi.";
$pgv_lang["privacy_list_fam_error"] = "Saugumo sumetimais viena ar keletas šeimu yra nerodomos.";
$pgv_lang["aka"]					= "Dar žinomi kaip";
$pgv_lang["privacy_list_fam_error"] = "Saugumo sumetimais vienas ar keletas šeimu yra nerodomos.";
$pgv_lang["female"] 				= "Moteris";
$pgv_lang["temple"] 				= "Mormonu šventove";
$pgv_lang["temple_code"]			= "Mormonu šventoves kodas:";
$pgv_lang["status"] 				= "Padetis";
$pgv_lang["source"] 				= "Šaltinis";
$pgv_lang["citation"]				= "Citata:";
$pgv_lang["text"]					= "Šaltinio tekstas:";
$pgv_lang["note"]					= "Pastaba";
$pgv_lang["NN"] 			= "(Pavardė nežinoma)";
$pgv_lang["PN"] 			= "(Vardas nežinomas)";
$pgv_lang["NNPN"] 			= "(Vardas ir pavardė nežinomi)";
// $pgv_lang["NNhebrew"] 		use value from lang.en.php
// $pgv_lang["PNhebrew"] 		use value from lang.en.php
// $pgv_lang["NNPNhebrew"] 		use value from lang.en.php
// $pgv_lang["NNarabic"] 		use value from lang.en.php
// $pgv_lang["PNarabic"] 		use value from lang.en.php
// $pgv_lang["NNPNarabic"] 		use value from lang.en.php
// $pgv_lang["NNgreek"] 		use value from lang.en.php
// $pgv_lang["PNgreek"] 		use value from lang.en.php
// $pgv_lang["NNPNgreek"] 		use value from lang.en.php
// $pgv_lang["NNrussian"] 		use value from lang.en.php
// $pgv_lang["PNrussian"] 		use value from lang.en.php
// $pgv_lang["NNPNrussian"] 	use value from lang.en.php
// $pgv_lang["NNchinese"] 		use value from lang.en.php
// $pgv_lang["PNchinese"] 		use value from lang.en.php
// $pgv_lang["NNPNchinese"] 	use value from lang.en.php
// $pgv_lang["NNvietnamese"] 	use value from lang.en.php
// $pgv_lang["PNvietnamese"] 	use value from lang.en.php
// $pgv_lang["NNPNvietnamese"] 	use value from lang.en.php
// $pgv_lang["NNthai"] 			use value from lang.en.php
// $pgv_lang["PNthai"] 			use value from lang.en.php
// $pgv_lang["NNPNthai"] 		use value from lang.en.php
$pgv_lang["NNother"] 			= "(Pavardė nežinoma)";
$pgv_lang["PNother"] 			= "(Vardas nežinomas)";
$pgv_lang["NNPNother"] 			= "(Vardas ir pavardė nežinomi)";
$pgv_lang["unrecognized_code"]		= "Neatpažintas GEDCOM kodas";
$pgv_lang["unrecognized_code_msg"]	= "Cia yra klaida ir mes noretumeme ja ištaisyti. Gal galetu Informuoti apie šia klaida gauti";
$pgv_lang["indi_info"]				= "Asmenine informacija";
$pgv_lang["male"]					= "Vyras";
$pgv_lang["pedigree_chart"] 		= "Kilmes diagrama";
$pgv_lang["individual"]				= "Asmuo";
$pgv_lang["desc_chart2"]			= "Palikuoniu diagrama";
$pgv_lang["family_with"]			= "Šeima su";
$pgv_lang["as_spouse"]				= "Šeima su sutuoktiniu";
$pgv_lang["add_to_cart"]			= "Prideti i iškarpu krepšeli";
$pgv_lang["still_living_error"] 	= "Šis asmuo dar gyvenas arba neturi irašu apie gimimo ar mirties datas. Visos gyvu žmoniu detales  nera visiems prieinamos. <br/> Daugiau informacijos gali suteikti ";
$pgv_lang["privacy_error"]			= "Informacija apie ši asmeni yra privati. <br/>";
$pgv_lang["as_child"]				= "Šeima su tevais";
$pgv_lang["view_gedcom"]			= "Žiureti GEDCOM iraša";
$pgv_lang["more_information"]		= "Daugiau informacijos gali suteikti  ";
$pgv_lang["surname"]				= "Pavarde:";
$pgv_lang["suffix"] 				= "Priesaga:";
$pgv_lang["object_note"]			= "Pastabos apie objekta:";
$pgv_lang["name"]					= "Vardas";
$pgv_lang["given_name"] 			= "Suteiktas vardas:";
$pgv_lang["sex"]					= "Lytis";
$pgv_lang["personal_facts"] 		= "Asmeniniai faktai ir detales";
$pgv_lang["type"]					= "Tipas";
$pgv_lang["place_description"]		= "Vietove/Aprašymas";
$pgv_lang["parents"]				= "Tevai:";
$pgv_lang["siblings"]				= "Broliai ir seserys";
$pgv_lang["mother"] 				= "Motina";
$pgv_lang["parent"] 				= "Vienas iš tevu";
$pgv_lang["relatives_events"]		= "Artimu giminaiciu ivykiai";
$pgv_lang["relatives"]				= "Artimi gimines";
$pgv_lang["father"] 				= "Tevas";
$pgv_lang["child"]					= "Vaikas";
$pgv_lang["spouse"] 				= "Sutuoktinis";
$pgv_lang["surnames"]				= "Pavardes";
$pgv_lang["adopted"]				= "Ivaikinti";
$pgv_lang["foster"] 				= "Globoti";
$pgv_lang["sealing"]				= "Sealing";
$pgv_lang["disproved"]				= "Paneigimas";
$pgv_lang["link_as"]				= "Susieti ši asmeni su esama šeima kaip";
$pgv_lang["no_tab1"]				= "Nera detalesnes informacijos apie ši asmeni.";
$pgv_lang["no_tab2"]				= "Apie ši asmeni nera pastabu.";
$pgv_lang["no_tab3"]				= "Šis asmuo neturi šaltiniu citatu.";
$pgv_lang["no_tab4"]				= "Šis asmuo neturi media objektu.";
$pgv_lang["no_tab5"]				= "Šis asmuo neturi artimu giminaiciu.";
$pgv_lang["no_tab6"]				= "Šis asmuo neturi tyrimo irašu.";
$pgv_lang["no_tab4"]				= "Šis asmuo neturi media opbjektu.";
$pgv_lang["family_info"]			= "Informacija apie šeima";
$pgv_lang["family_group_info"]		= "Šeimos grupes informacija";
$pgv_lang["husband"]				= "Vyras";
$pgv_lang["wife"]					= "Žmona";
$pgv_lang["marriage"]				= "Santuoka:";
$pgv_lang["lds_sealing"]			= "Murmonu sealing:";
$pgv_lang["marriage_license"]		= "Santuokos liudijimas:";
$pgv_lang["media_object"]			= "Multimedia objektas";
$pgv_lang["clip_cart"]				= "Iškarpu krepšelis";
$pgv_lang["item_with_id"]			= "Irašai su ID";
$pgv_lang["family_private"] 		= "Detali informacija apie šia šeima yra privati, todel šeimos detali informacija nebus itraukta.";
$pgv_lang["person_private"] 		= "Detali informacija apie ši asmeni yra privati, todel asmenines detales nebus itrauktos.";
$pgv_lang["person_living"]			= "Šis asmuo gyvena, todel asmenines detales nebus itrauktos.";
$pgv_lang["unable_to_open"] 		= "Negaliu atidaryti Iškarpu direktorijos irašymo teisemis";
$pgv_lang["cart_is_empty"]			= "Jusu iškarpu krepšelis yra tušcias.";
$pgv_lang["remove"] 				= "Išmesti";
$pgv_lang["empty_cart"] 			= "Tušcias krepšys";
$pgv_lang["connections"]			= "Rastos susijusios vietoves.";
$pgv_lang["download_now"]			= "Parsisiusti dabar";
$pgv_lang["indi_downloaded_from"]	= "Šis asmuo buvo užsaugotas iš:";
$pgv_lang["family_downloaded_from"] = "Ši šeima buvo užsaugota iš:";
$pgv_lang["source_downloaded_from"] = "Šis šaltinis buvo užsaugotas iš:";
$pgv_lang["top_level"]				= "Aukšciausias lygmuo";
$pgv_lang["name_description"]		= "Vardas / Apibrežimas";
$pgv_lang["error_already"]			= "jau yra Ju iškarpu krepšelyje";
$pgv_lang["just_family"]			= "Prideti tik šeimos iraša.";
$pgv_lang["children"]				= "Vaikai";
$pgv_lang["number_children"]		= "Vaiku skaicius:";
$pgv_lang["no_children"]			= "Nera irašu apie vaikus";
$pgv_lang["parents_timeline"]		= "Rodyti pora laiko tekmes diagramoje";
$pgv_lang["default_form_info"]		= "(nutylimas)";
$pgv_lang["show_place_hierarchy"]	= "Rodyti vietoves herarchine tvarka";
$pgv_lang["default_form"]			= "Miestas, rajonas, šalis";
$pgv_lang["unknown"]				= "nežinoma";
$pgv_lang["individuals"]			= "Asmenys";
$pgv_lang["view_records_in_place"]	= "Rodyti visus irašus rastus šioje vietoveje.";
$pgv_lang["place_list2"] 			= "Vietoviu sarašas";
$pgv_lang["show_place_list"]		= "Rodyti visas vietoves saraše";
$pgv_lang["total_unic_places"]		= "Iš viso skirtingu vietoviu";
$pgv_lang["multi_title"]			= "Multimedia objektu sarašas";
$pgv_lang["media_found"]			= "Rasti multimedia objektai";
$pgv_lang["view_object"]			= "Žiureti objektus";
$pgv_lang["view_person"]			= "Informacija apie asmeni";
$pgv_lang["view_family"]			= "Informacija apie šeima";
$pgv_lang["titles_found"]			= "Antraštes";
$pgv_lang["delete_directory"]		= "Ištrinti kataloga";
$pgv_lang["view_source"]			= "Informacija apie šaltini";
$pgv_lang["first_page"]				= "Pirmas puslapis";
$pgv_lang["previous_page"]			= "Ankstesnis puslapis";
$pgv_lang["next_page"]				= "Kitas puslapis";
$pgv_lang["last_page"]				= "Paskutinis puslapis";
$pgv_lang["search_type"]			= "Paieškos tipas";
$pgv_lang["search_options"]			= "Paieškos parametrai";
$pgv_lang["per_page"]				= "media objektu viename puslapyje";
$pgv_lang["search_gedcom"]			= "Ieškoti GEDCOM failus";
$pgv_lang["enter_terms"]			= "Iveskite paieškos salygas";
$pgv_lang["soundex_search"] 		= "- Arba ieškoti pagal tai, kai jus galvojate vardas yra rašomas (Soundex):";
$pgv_lang["sources"]				= "Šaltiniai";
$pgv_lang["firstname_search"]		= "Vardas";
$pgv_lang["lastname_search"]		= "Pavarde";
$pgv_lang["search_year"]			= "Metai";
$pgv_lang["no_results"] 			= "Nieko nerasta.";
$pgv_lang["sources_found"]			= "Rasta šaltiniu";
$pgv_lang["find_source"]			= "Rasti šaltini";
$pgv_lang["total_repositories"]		= "Iš viso saugyklu";
$pgv_lang["source_info"]			= "Informacija apie šaltini";
$pgv_lang["other_records"]			= "Irašai, kurie susieti su šiuo šaltiniu:";
$pgv_lang["other_records"]			= "Irašai, kurie susieti su šiuo šaltiniu:|";
$pgv_lang["other_records"]			= "Irašau, kurie susieti su šiuo šaltiniu:";
$pgv_lang["total_sources"]			= "Iš viso šaltiniu";
$pgv_lang["building_index"] 		= "Kuriami indeksu sarašai";
$pgv_lang["invalid_gedformat"]		= "Blogas GEDCOM 5.5 formatas";
$pgv_lang["detected_change"]		= "PhpGedView ptiko pakeitima Jusu <b>GEDCOM#</b>. Prieš tesiant indeksu failai turi buti perkurti.";
$pgv_lang["importing_records"]		= "Ikeliame irašus i duomenu baze";
$pgv_lang["exec_time"]				= "Vykdymo laikas:";
$pgv_lang["tables_exist"]			= "PhpGedView lentutes šioje DB jau egzistuoja";
$pgv_lang["notes_sources_media"]	= "Pastabos, Šaltiniai ir Media";
$pgv_lang["paste_person"]			= "Iterpti asmeni";
$pgv_lang["person_list"]			= "Asmenu sarašas:";
$pgv_lang["starts_with"]			= "Prasideda:";
$pgv_lang["path_to_gedcom"] 		= "Iveskite kelia iki Jusu GEDCOM failo:";
$pgv_lang["import_multiple"]		= "Ikelti ir dirbti su keliais GEDCOM failais (gimines medžiais)";
$pgv_lang["year1"]					= "metai";
$pgv_lang["month1"]					= "menuo";
$pgv_lang["day1"]					= "diena";
$pgv_lang["years"]					= "metai";
$pgv_lang["months"]					= "menesiai";
$pgv_lang["days"]					= "dienos";
$pgv_lang["drop_tables"]			= "Išmesti esamas lentutes";
$pgv_lang["source_complete"]		= "Šaltiniu indekso failo atnaujinimas baigtas.";
$pgv_lang["family_complete"]		= "Šeimu indekso failo atnaujinimas baigtas.";
$pgv_lang["indi_complete"]			= "Asmenu indekso failo atnaujinimas baigtas.";
$pgv_lang["you_may"]				= "Jus galite:";
$pgv_lang["sec"]					= "sek.";
$pgv_lang["dateconvert"]			= "datos perskaiciavimo irankis";
$pgv_lang["index_complete"] 		= "Indeksavimas baigtas.";
$pgv_lang["name_contains"]			= "Varde yra:";
$pgv_lang["total_fams"] 			= "Iš viso šeimu";
$pgv_lang["total_indis"]			= "Iš viso asmenu";
$pgv_lang["notes"]					= "Pastabos";
$pgv_lang["ssourcess"]				= "Šaltiniai";
$pgv_lang["magnify"]				= "Padidinti";
$pgv_lang["show_surnames"]			= "Rodyti pavardžiu sarašus";
$pgv_lang["hidden"]					= "Paslepta";
$pgv_lang["skip_surnames"]			= "Praleisti pavardžiu sarašus";
$pgv_lang["all"]					= "VISI";
$pgv_lang["age"]					= "Amžius";
$pgv_lang["timeline_title"] 		= "PhpGedView laiko tekme";
$pgv_lang["find_repository"]		= "Rasti saugykla";
$pgv_lang["repos_found"]			= "Rastos saugyklos";
$pgv_lang["families"]				= "Šeimos";
$pgv_lang["people"] 				= "Žmones";
$pgv_lang["repo_info"]				= "Informacija apie saugykla";
$pgv_lang["repo_list"]				= "Saugyklu sarašas";
$pgv_lang["search_place"]			= "Vieta";
$pgv_lang["search_gedcom"]			= "Ieškoti GEDCOM failuose";
$pgv_lang["medialist_show"] 		= "Rodyti";
$pgv_lang["file_not_found"] 		= "Failas nerastas.";
$pgv_lang["next"]					= "Tolesnis >";
$pgv_lang["remove_person"]			= "Išmesti asmeni";
$pgv_lang["show_age"]				= "Rodyti amžiaus skirtuka";
$pgv_lang["add_another"]			= "I diagrama ideti kita asmeni: <br /> Asmens ID:";
$pgv_lang["timeline_chart"] 		= "Laiko tekmes diagrma";
$pgv_lang["find_id"]				= "Surasti ID";
$pgv_lang["year"]					= "Metai:";
$pgv_lang["zoom_out"]				= "Sumažinti";
$pgv_lang["zoom_in"]				= "Padidinti";
$pgv_lang["show"]					= "Rodyti";
$pgv_lang["jan"]					= "Sausio";
$pgv_lang["feb"]					= "Vasario";
$pgv_lang["mar"]					= "Kovo";
$pgv_lang["apr"]					= "Balandžio";
$pgv_lang["may"]					= "Gegužes";
$pgv_lang["jun"]					= "Birželio";
$pgv_lang["jul"]					= "Liepos";
$pgv_lang["aug"]					= "Rugpjucio";
$pgv_lang["sep"]					= "Rugsejo";
$pgv_lang["oct"]					= "Spalio";
$pgv_lang["user_admin"] 			= "Naudotoju administravimas";
$pgv_lang["int"]					= "interpretuota";
$pgv_lang["nov"]					= "Lapkricio";
$pgv_lang["dec"]					= "Gruodžio";
$pgv_lang["to"] 					= "iki";
$pgv_lang["from"]					= "nuo";
$pgv_lang["abt"]					= "apie";
$pgv_lang["est"]					= "ivertinta";
$pgv_lang["cal"]					= "apskaiciuota";
$pgv_lang["aft"]					= "po";
$pgv_lang["rebuild_indexes"]		= "Perkurti indeksus";
$pgv_lang["and"]					= "ir";
$pgv_lang["bet"]					= "tarp";
$pgv_lang["confirm_password"]		= "Turite patvirtinti slaptažodi.";
$pgv_lang["enter_password"] 		= "Turite ivesti slaptažodi.";
$pgv_lang["enter_fullname"] 		= "Turite ivesti pilna varda.";
$pgv_lang["enter_username"] 		= "Turite ivesti naudotojo varda.";
$pgv_lang["password_mismatch"]		= "Slaptažodžiai nesutampa.";
$pgv_lang["cancel_upload"]			= "Nutraukti nusiuntima";
$pgv_lang["step4"]					= "Žingsnis 4 iš 4:";
$pgv_lang["step3"]					= "Žingsnis 3 iš 4:";
$pgv_lang["step1"]					= "Žingsnis 1 iš 4:";
$pgv_lang["bef"]					= "prieš";
$pgv_lang["apx"]					= "apytikriai";
$pgv_lang["no_login"]				= "Negalejau autorizuoti naudotojo";
$pgv_lang["upgrade"]				= "Atnaujinti PhpGedView";
$pgv_lang["upload_help"]			= "Norimus nusiusti failus pažymekite lokaliam kompiuteryje. Šie failai bus nusiusti i direktorija:";
$pgv_lang["file_not_exists"]		= "Ivesto vardo nera.";
$pgv_lang["file_not_present"]		= "Byla neegzistuoja.";
$pgv_lang["enter_filename"] 		= "Reikia butinai ivesti GEDCOM failo varda.";
$pgv_lang["user_info"]				= "Mano naudotojo informacija";
$pgv_lang["cir"]					= "apie";
$pgv_lang["save"]					= "Saugoti";
$pgv_lang["delete"] 				= "Ištrinti";
$pgv_lang["edit"]					= "Taisyti";
$pgv_lang["relationship_chart"] 	= "Ryšiu diagrama";
$pgv_lang["person1"]				= "Asmuo 1";
$pgv_lang["person2"]				= "Asmuo 2";
$pgv_lang["no_link_found"]			= "Ryšys tarp dvieju asmenu nenustatytas arba yra kitoks nei cia tikrinama. ";
$pgv_lang["follow_spouse"]			= "Tikrinti santuokini ryši";
$pgv_lang["timeout_error"]			= "Progama per ilgai ieško ryšio todel jos veikimas nutraukiamas";
$pgv_lang["son"]					= "Sunus";
$pgv_lang["daughter"]				= "Dukra";
$pgv_lang["brother"]				= "Brolis";
$pgv_lang["sister"] 				= "Sesuo";
$pgv_lang["relationship_to_me"] 	= "Ryšys su manimi";
$pgv_lang["rela_husb"]				= "Ryšys su vyru";
$pgv_lang["rela_wife"]				= "Ryšys su žmona";
$pgv_lang["next_path"]				= "Surasti kita ryši";
$pgv_lang["show_path"]				= "Surasti ryši";
$pgv_lang["line_up_generations"]	= "Išlygiuoti ta pacia karta";
$pgv_lang["oldest_top"]             = "Seniausia rodyti viršuje";
$pgv_lang["add"]					= "Prideti";
$pgv_lang["delete_person"]			= "Ištrinti ši asmeni";
$pgv_lang["bdm"]					= "Gimimai, Mirtys, Santuokos";
$pgv_lang["user_cannot_edit"]		= "Šis naudotojas negali koreguoti šio GEDCOM (gimines medžio).";
$pgv_lang["gedcom_editing_disabled"]	= "Šio GEDCOM (gimines medžio) taisymas yra administratoriaus uždraustas.";
$pgv_lang["privacy_not_granted"]	= "Jus neturite priejimo prie";
$pgv_lang["select_date"]			= "Pasirinkite data";
$pgv_lang["saturday"]				= "Šeštadienis";
$pgv_lang["friday"] 				= "Penktadienis";
$pgv_lang["thursday"]				= "Ketvirtadienis";
$pgv_lang["wednesday"]				= "Treciadienis";
$pgv_lang["tuesday"]				= "Antradienis";
$pgv_lang["monday"] 				= "Pirmadienis";
$pgv_lang["sunday"] 				= "Sekmadienis";
$pgv_lang["anniversary_calendar"]	= "Sukakciu kalendorius";
$pgv_lang["month"]					= "Menuo:";
$pgv_lang["day"]					= "Diena:";
$pgv_lang["today"]					= "Šiandien";
$pgv_lang["year_error"] 			= "Atsiprašome, bet datos iki 1970 nera palaikomos.";
$pgv_lang["mail01_line01"]			= "Sveiki #user_fullname# ...";
$pgv_lang["mail01_line02"]			= "Serveryje ( #PGV_SERVER_NAME##PGV_SCRIPT_PATH# )  gauta užklausa sukurti naudotoja su Jusu elektroniniu adresu ( #user_email# ).";
$pgv_lang["mail01_line04"]			= "Tam kad patvirtinti naudotoja varda ir elektronini adresa, prašom eiti pagal šia nuoroda ir užpildyti  pageidaujamus duomenis.";
$pgv_lang["mail01_line03"]			= "Informacija apie užklausa yra žemiau esancioje nuorodoje.";
$pgv_lang["mail01_line06"]			= "Jus negausite daugiau jokiu laišku iš šio puslapio, nes prašymas sukurti naudotoja yra ištrinamas po septyniu dienu.";
$pgv_lang["mail01_subject"] 		= "Jusu prisijungimas prie #PGV_SERVER_NAME##PGV_SCRIPT_PATH#|";
$pgv_lang["mail01_line05"]			= "Jei Jus neprašete prisijungimo vardo, tai galite tik ištrinti ši laiška.";
$pgv_lang["pls_note06a"] 			= "Mes pasiusime patvirtinimo laiška adresu ( #user_email# ). Jums reikes patvirtinti naudotojo užklausima pagal instrukcijas, esancias tame laiške. Jei per 7 dienas nepatvirtinsite naudotojo, jusu prašymas bus automatiškai atmestas. Jums reikes pildyti viska iš naujo. .<br /><br /> Po to, kai naudojantis instrukcijomis patvirtinsite save, Jus galesite prisijungti. Norint prisijungti prie puslapio reikia žinoti naudotojo varda ir slaptažodi.<br /><br /><br />";
$pgv_lang["pls_note06"] 			= "Mes pasiusime patvirtinimo laiška adresu ( #user_email# ). Jums reikes patvirtinti naudotojo užklausima pagal instrukcijas, esancias tame laiške. Jei per 7 dienas nepatvirtinsite naudotojo, jusu prašymas bus automatiškai atmestas. Jums reikes pildyti viska iš naujo. .<br /><br /> Po to, kai naudojantis instrukcijomis patvirtinsite save, administratorius dar tures patvirinti Jusu nora tapti naudotoju prieš tai, kol galesite prisijungti.<br /><br /> Norint prisijungti prie puslapio reikia žinoti naudotojo varda ir slaptažodi.<br /><br /><br />";
$pgv_lang["user_verify"]			= "Naudotojo patvirtinimas";
$pgv_lang["registernew"]			= "Naujo naudotojo patvirtinimas";
$pgv_lang["mail02_line04a"]			= "Jus elektroniniu laisku busite informuotas  kai b9simas naudotojas patvirtins save. Po patvirtinimo vartotojas gales prisijungti  be jokiu  pastangu iš Jusu puses.";
$pgv_lang["mail02_line04"]			= "Jus busite informuotas elektroniniu laišku kai busimas naudotojas patvirtins save. Tada Jus galesite testi vartotojo aktyvavima. Naujas naudotojas negales prisijungti kol Jus neaktyvuosite naudotojo.";
$pgv_lang["thankyou"]				= "Sveiki #user_fullname# ...<br /> Aciu už registravimasi";
$pgv_lang["mail02_subject"] 		= "Nauja registracija #PGV_SERVER_NAME##PGV_SCRIPT_PATH#|";
$pgv_lang["mail02_line02"]			= "Busimas naudotojas užregistravo save ( #PGV_SERVER_NAME##PGV_SCRIPT_PATH# ).";
$pgv_lang["mail02_line03"]			= "Naudotojas gavo elektronini laiška su visa informacija, reikalinga patvirtinti jo prisijungimo vardui.";
$pgv_lang["hashcode"]				= "Patvirtinimo kodas:";
$pgv_lang["mail02_line01"]			= "Sveikas Administratoriau ...";
$pgv_lang["mandatory"] 			= "Laukai pažymeti  su *  yra privalomi.";
$pgv_lang["pls_note04"] 			= "Laukai, pažymeti *, yra privalomi.";
$pgv_lang["emailadress"]			= "Elektroninis adresas";
$pgv_lang["pls_note03"] 			= "Prieš aktyvuojant vartotoja, šitas elektroninis adresas bus patikrintas. Jis nebus vaizduojamas puslapyje. Nurodyti adresu bus nusiusta žinute su Jusu  prisijungimo duomenimis.";
$pgv_lang["pls_note02"] 			= "Pastaba: Slaptažodyje gali buti  raides, skaiciai, bei kiti spec. simboliai.";
$pgv_lang["min6chars"]				= "Slaptažodis mažiausiai turi tureti 6 simbolius";
$pgv_lang["pls_note01"] 			= "Pastaba: Sistema skiria didžiasias ir mažasiais raides!";
$pgv_lang["day_not_set"]			= "Nenustatyta diena";
$pgv_lang["delete_name"]			= "Ištrinti varda";
$pgv_lang["edit_name"]				= "Taisyti varda";
$pgv_lang["find_fam_list"]			= "Šeimos radimo sarašas";
$pgv_lang["find_family"]			= "Surasti Šeima";
$pgv_lang["confirm_delete_source"]	= "Ar Jus isitikines, kad iš šito GEDCOM failo norite ištrinti ši šaltini?";
$pgv_lang["delete_source"]			= "Ištrinti ši šaltini";
$pgv_lang["in_this_year"]			= "Šiais metais Jusu istorijoje...";
$pgv_lang["year_anniversary"]		= "#year_var#  metu sukaktis";
$pgv_lang["in_this_month"]			= "Ši menesi Jusu istorijoje...";
$pgv_lang["on_this_day"]			= "Šia diena Jusu istorijoje ...";
$pgv_lang["viewday"]				= "Žiureti diena";
$pgv_lang["viewmonth"]				= "Žiureti menesi";
$pgv_lang["viewyear"]				= "Žiureti metus";
$pgv_lang["all_people"] 			= "Visi asmenys";
$pgv_lang["living_only"]			= "Gyvi žmones";
$pgv_lang["lost_password"]			= "Pamiršote slaptažodi?";
$pgv_lang["mail04_line02"]			= "Jusu naudotojo vardui buvo naujo slaptažodžio užklausimas.";
$pgv_lang["pwreqinfo"]				= "Sveiki...<br /><br /><br /> Elektroninis laiškas pasiustas adresu #user[email]#).<br /><br /> Patikrinkite savo pašta; jums netrukus turi buti nusiustas laiškas.<br /><br /> Rekomendacija: <br /><br />Prisijunkite su nauju slaptažodžiu, ir, noredami garantuoti sauguma,  nedelsiant ji pakeiskite.";
$pgv_lang["mail04_line04"]			= "Paspauskite ant nuorodos arba nukopijuokite ja i interneto naršykle. Prisijunkite su nauju slaptažodžiu, ir, noredami garantuoti sauguma,  nedelsiant ji pakeiskite.";
$pgv_lang["mail04_subject"] 		= "Duomenu užklausa serveryje #PGV_SERVER_NAME##PGV_SCRIPT_PATH#";
$pgv_lang["mail04_line05"]			= "Prisijungus  pasirinkite '#pgv_lang[myuserdata]#'nuoroda iš  '#pgv_lang[mygedview]#'  meniu ir  slaptažodžiui pakeisti užpildykite slaptažodžio laukus.";
$pgv_lang["mail04_line03"]			= "Rekomendacija:";
$pgv_lang["datachanged"]			= "Naudotojo duomenys buvo pakeisti";
$pgv_lang["mail03_line02"]			= "Naudotojas #newuser[username]# ( #newuser[fullname]# ) patvirtino savo registracijos duomenis.";
$pgv_lang["mail03_line03a"]			= "Jums nereikia imtis jokiu veiksmu; naudotojas gali prisijungti.";
$pgv_lang["mail03_subject"] 		= "Naujas patvirtinimas  severyje #PGV_SERVER_NAME##PGV_SCRIPT_PATH#";
$pgv_lang["datachanged_name"]		= "Jums gali reiketi persisveikinti  nauju naudotoja vardu.";
$pgv_lang["user_theme"] 			= "Mano tema";
$pgv_lang["todays_events_descr"]	= "Šia diena Jusu istorijoje .... blokas rodo ivykiu jubiliejus šiai dienai. Jus galite keisti kiek detaliu yra rodoma.";
$pgv_lang["pls_note08"] 			= "Naudotojo #user_name#  duomenys buvo patikrinti.";
$pgv_lang["passwordlength"] 		= "Slaptažodis turi tureti bent 6 simbolius.";
$pgv_lang["pls_note11"] 			= "Norint pakeisti slaptažodi, iveskite savo naudotojo varda.<br /><br /> Mes atsiusime elektronini laiška  adresu, kuris bus nurodytas tam naudotojui. Laiške bus nuoroda ir  patvirtinimo kodas Jusu  naudotojo vardui. Kei aplankysite nuorodoje esanti puslapi, galesite pakeisti slaptažodi ir prisijungti prie puslapio. Sauguno sumetimais neturetumete  niekam duoti patvirtinimo kodo.<br /><br /> Jei reikia pagalbos iš administratoriaus, naudokite žemiau esancia nuoroda.";
$pgv_lang["lost_pw_reset"]			= "Pamesto slaptažodžio užkausa";
$pgv_lang["user_not_found"] 		= "Negalima patvirtinti informacijos, kuria suvedete.  Bandykite dar karta arba, jei norite daugiau informacijos, susisiekite su puslapio administratoriumi.";
$pgv_lang["data_incorrect"] 		= "Suvesti blogi duomenys, bandykite dar karta.";
$pgv_lang["pls_note10a"]			= "Dabar galite prisijungti naudodami naudotojo varda ir slaptažodi.";
$pgv_lang["pls_note10"] 			= "Administratorius buvo informuotas. Kai tik jis suteiks teises prisijungti, Jus galesite prisijungti  naudodami savo naudotojo varda ir slaptažodi.";
$pgv_lang["pls_note09"] 			= "Jus patvirtinote savo nora tapti registruotu naudotoju.";
$pgv_lang["mail03_line01"]			= "Sveikas Administratoriau...";
$pgv_lang["savedata"]				= "Išsaugoti pakeistus duomenis";
$pgv_lang["mail04_line01"]			= "Sveiki #user_fullname# ...";
$pgv_lang["enter_email"]			= "Jus turite nurodyti elektronino pašto adresa.";
$pgv_lang["pls_note07"] 			= "Savo prisijungimo vardui patvirtiniti , suveskite naudotojo varda, slaptažodi ir elektroniniu paštu gauta patvirtinimo koda.";
$pgv_lang["message_deleted"]		= "Pranešimas išrintas";
$pgv_lang["message_sent"]		= "Pranešimas išsiustas #TO_USER#";
$pgv_lang["message_failed"]		= "Pranešimo negalejo buti išsiustas";
$pgv_lang["message_error"]		= "PHPMailer klaida: ";
$pgv_lang["message_invalid_from"]	= "Neteisingas siuntejo adresas: &lt;#email#&gt;";
$pgv_lang["message_invalid_to"]		= "Neteisingas gavejo adresas: &lt;#email#&gt;";
$pgv_lang["reply"]					= "Atsakyti";
$pgv_lang["no_events_living"]		= "Artimiausias #pgv_lang[global_num1]# dienas nera gyvenanciu žmoniu ivykiu.";
$pgv_lang["basic_or_all"]			= "Rodyti tik Giminus, Mirtis ir  Santuokas?";
$pgv_lang["living_or_all"]			= "Rodyti tik gyvu žmoniu duomenis?";
$pgv_lang["message_subject"]		= "Antrašte:";
$pgv_lang["message_body"]			= "Tekstas:";
$pgv_lang["message_from_name"]		= "Jusu vardas:";
$pgv_lang["message_to"] 			= "Pranešimo gavejas:";
$pgv_lang["message_to"] 			= "Pranešimas kam:";
$pgv_lang["requestpassword"]		= "Naujo slaptažodžio sukurimas";
$pgv_lang["sibling"]				= "Brolis, sesuo";
$pgv_lang["no_account_yet"] 		= "Neturite pasisveikinimo vardo?";
$pgv_lang["requestaccount"] 		= "Naujo naudotojo sukurimas";
$pgv_lang["no_login_users"]			= "Neprisijunges ir ne anoniminis naudotojas";
$pgv_lang["send"]					= "Siusti";
$pgv_lang["editowndata"]			= "Mano prisijungimo naudotojo informacija";
$pgv_lang["myuserdata"] 			= "Mano prisijungimo infromacija";
$pgv_lang["mgv"]					= "Mano MyGedView";
$pgv_lang["mygedview"]				= "Mano MyGedView puslapis";
$pgv_lang["welcome_text_auth_mode_1"]	= "<span class='center'><b>Sveiki atvyke i  Genealogijos puslapi</b></span><br />Priejimas prie šio puslapio yra galimas visu, kurie turi naudotojo varda.<br /><br />Jei turite naudotojo varda, tai galite jungtis prie šio puslapio. Jei ne, tai galite užsakyti naudotojo varda nuspaude atitinkama nuoroda žemiau. <br /><br />Patiktines Jusu duomenis puslapio administratorius leis naudotis šiuo naudotojo vardu. Apie Jusu naudotojo vardo aktyvavima Jus busite informuotas elektroniniu paštu.";
$pgv_lang["welcome_text_auth_mode_2"]	= "<span class='center'><b>Sveiki atvyke i  Genealogijos puslapi</b></span><br />Priejimas prie šio puslapio yra galimas tik <u>autorizuotu</u> naudotoju<br /><br />Jei turite naudotojo varda, tai galite jungtis prie šio puslapio. Jei ne, tai galite užsakyti naudotojo varda nuspaude atitinkama nuoroda žemiau. <br /><br />Patiktines Jusu duomenis puslapio administratorius leis naudotis šiuo naudotojo vardu arba ne. Apie Jusu naudotojo vardo aktyvavima Jus busite informuotas elektroniniu paštu.";
$pgv_lang["welcome_text_auth_mode_3"]	= "<span class='center'><b>Sveiki atvyke i  Genealogijos puslapi</b></span><br />Priejimas prie šio puslapio yra galimas tik <u>šeimos nariu</u>.<br /><br />Jei turite naudotojo varda, tai galite jungtis prie šio puslapio. Jei ne, tai galite užsakyti naudotojo varda nuspaude atitinkama nuoroda žemiau. <br /><br />Patiktines Jusu duomenis puslapio administratorius leis naudotis šiuo naudotojo vardu arba ne. Apie Jusu naudotojo vardo aktyvavima Jus busite informuotas elektroniniu paštu.";
$pgv_lang["todays_events_block"]	= "Šia diena blokas";
$pgv_lang["user_messages_block"]	= "Naudotojo žinutes";
$pgv_lang["logged_in_users_block"]	= "Pasisveikine naudotojai";
$pgv_lang["random_media_persons_or_all"]	= "Rodyti tik asmenis, ivykius ar viska";
$pgv_lang["random_media_persons"]	= "Asmenys";
$pgv_lang["random_media_events"]	= "%vykiai";
$pgv_lang["gedcom_stats_block"] 	= "GEDCOM statistika";
$pgv_lang["login_descr"]			= "Prisijungimo blokas priima naudotojo varda ir slaptažodi jungiantis.";
$pgv_lang["login_block"]			= "Prisijungimo blokas";
$pgv_lang["theme_select_block"] 	= "Temu pasirinkimo blokas";
$pgv_lang["block_top10_title"]		= "10 dažniausiai turimos pavardes";
$pgv_lang["block_top10"]			= "10 Dažniausiai naudojamu  pavardžiu blokas";
$pgv_lang["gedcom_news_block"]		= "GEDCOM naujienu blokas";
$pgv_lang["user_news_block"]		= "Naudotojo žurnalo blokas";
$pgv_lang["add_journal"]			= "Prideti nauja žurnalo iraša";
$pgv_lang["no_journal"] 			= "Jus nesukurete jokiu žurnalo irašu.";
$pgv_lang["my_journal"] 			= "Mano žurnalas";
$pgv_lang["todays_events_block"]	= "\"Šia diena\" blokas";
$pgv_lang["welcome_text_cust_head"] 	= "<span class='center'><b>Sveiki atvyke i  Genealogijos puslapi</b></span><br />Priejimas prie šio puslapio yra galimas visu, kurie  priejimui turi naudotojo varda ir slaptažodi .<br />";
$pgv_lang["upcoming_events"]		= "Busimi ivykiai";
$pgv_lang["no_events_privacy1"]		= "Rytojui ivykiu yra, bet slaptumo apribojimai neleidžia ju pamatyti.";
$pgv_lang["none_today_privacy"]		= "Šiandienai ivykiai yra, bet slaptumo apribojimai neleidžia ju pamatyti.";
$pgv_lang["none_today_living"]		= "Šiandienai gyvu žmoniu  ivykiu nera.";
$pgv_lang["none_today_all"]			= "Šiandienai ivykiu nera.";
$pgv_lang["no_events_all1"]			= "Rytojui ivykiu nera.";
$pgv_lang["no_events_living1"]		= "Nera gyvu žmoniu ivykiu rytojui.";
$pgv_lang["no_events_all"]			= "Nera ivykiu artimiausiom #pgv_lang[global_num1]# dienom.";
$pgv_lang["no_events_all"]			= "Nera  ivykiu atrimiausiom #pgv_lang[global_num1]# dienom.";
$pgv_lang["users_logged_in"]		= "Prisijunge naudotojai";
$pgv_lang["anon_users"]				= "Pasisveikine #pgv_lang[global_num1]# anoniminiai naudotojai";
$pgv_lang["anon_user"]				= "Pasisveikines  1 anoniminis naudotojas";
$pgv_lang["login_users"]			= "Pasisveikine #pgv_lang[global_num1]#  naudotojai";
$pgv_lang["login_user"]				= "Pasisveikines 1 naudotojas";
$pgv_lang["inc_privacy"]			= "Saugumo failai";
$pgv_lang["move_left"]				= "I kaire";
$pgv_lang["add_right_block"]		= "Prideti bloka i dešini pasirinkima ...";
$pgv_lang["add_main_block"] 		= "Prideti bloka i pagrindini pasirinkima...";
$pgv_lang["move_right"] 			= "I dešine";
$pgv_lang["latest"] 				= "Jus turite naujausia PhpGedView versija.";
$pgv_lang["upgrade_help"]			= "Padekite man";
$pgv_lang["new_variable"]			= "Rastas naujas kintamasis:";
$pgv_lang["config_open_error"]		= "Atidarant nustatymu faila ivyko klaida.";
$pgv_lang["config_update_ok"]		= "Nustatymu failas atnaujintas sekmingai.";
$pgv_lang["stats_to_show"]			= "Pasirinkti kokius duomenis rodyti šiame bloke";
$pgv_lang["broadcast_never_logged_in"]	= "Siusti pranešimus vartotojams, kurie niekada nebuvo prisijunge";
$pgv_lang["broadcast_not_logged_6mo"]	= "Siusti pranešimus vartotojams, kurie neprisijunge 6 menesius";
$pgv_lang["onlyemail"] 				= "Tiktai adresu su elektroniniu adresu";
$pgv_lang["noemail"] 				= "Adresai be elektroninio adreso";
$pgv_lang["source_menu"]			= "Šaltinio parametrai";
$pgv_lang["cancel"]					= "Atšaukti";
$pgv_lang["edit_source"]			= "Koreguoti Šaltini";
$pgv_lang["saturday_1st"]				= "Š";
$pgv_lang["friday_1st"]					= "Pn";
$pgv_lang["thursday_1st"]				= "K";
$pgv_lang["wednesday_1st"]				= "T";
$pgv_lang["tuesday_1st"]				= "A";
$pgv_lang["monday_1st"]					= "P";
$pgv_lang["sunday_1st"]					= "S";
$pgv_lang["ex-husband"] = "Ex-Vyras";
$pgv_lang["ex-wife"] = "Ex-žmona";
$pgv_lang["ex-spouse"] = "ex-sutuoktinis";
$pgv_lang["error_exists_server"]    = "Svetaine jau egzistuoja.";
$pgv_lang["error_url"]              = "Svetaine turi tureti URL/IP.";
$pgv_lang["label_ban_view_links"]   = "Žiureti nuorodas i šita uždrausta svetaine";
$pgv_lang["error_delete_server"]    = "Ištrynimui Jums reikia pasirinkti svetaine.";
$pgv_lang["error_view_connections"] = "Peržiurai Jums reikia pasirinkti svetaine.";
$pgv_lang["stat_average_children"]	= "Vidutinis vaiku skaicius šeimoje";
$pgv_lang["stat_most_children"]		= "Šeima su daugiausiai vaiku";
$pgv_lang["stat_longest_life"]		= "Ilgiausiai gyvenes asmuo";
$pgv_lang["stat_avg_age_at_death"]	= "Vidutine gyvenimo trukme";
$pgv_lang["stat_users"]				= "Iš viso naudotoju";
$pgv_lang["family_of"]				= "Šeima asmens&nbsp;";
$pgv_lang["stat_users"]				= "Iš viso vardu";
$pgv_lang["stat_surnames"]			= "Iš viso pavardžiu";
$pgv_lang["stat_events"]			= "Iš viso ivykiu";
$pgv_lang["familybook_chart"]		= "Šeimos Knygos diagrama";
$pgv_lang["address_labels"]			= "Adresu žymes";
$pgv_lang["filter_address"]			= "Rodyti adresus , kurie savyje turi:";
$pgv_lang["address_list"]			= "Adresu sarašas";
$pgv_lang["add_favorite"]			= "Prideti nauja megstamiausia";
$pgv_lang["preferred_lang"] 		= "Šis naudotojas pageidauja gauti pranešimus #USERLANG#";
$pgv_lang["sending_to"] 			= "Šis pranešimas bus išsiustas naudotojui #TO_USER#";
$pgv_lang["label_merge_options"]    = "Suliejimo parametrai";
$pgv_lang["site_list"]				= "Svetaine:";
$pgv_lang["label_ask_first"]        = "Paklausti pirmiausia manes";
$pgv_lang["label_accept_changes"]   = "Priimti visus pakeitimus";
$pgv_lang["advanced_search"]		= "Išplestine svetaines paieška";
$pgv_lang["search_sites_discription"] = "Ieškoti žinomas svetaines";
$pgv_lang["search_sites"] 			= "Kuriose svetainese ieškoti";
$pgv_lang["other_searches"]			= "Kitos paieškos";
$pgv_lang["wiki_admin_guide"]			= "Wiki Administratoriaus vadovas";
$pgv_lang["wiki_users_guide"]			= "Wiki Naudojojo  Vadovas";
$pgv_lang["wiki_main_page"]				= "Wiki pagrindinis puslapis";
$pgv_lang["page_size"]					= "Puslapio dydis";
$pgv_lang["descend_report"]				= "Palikuoniu ataskaita";
$pgv_lang["server_folder"]				= "Direktorija serveryje";
$pgv_lang["server_file"]				= "Bylos vardas serveryje";
$pgv_lang["config_uptodate"]		= "Jusu nustatymu failas yra naujausios versijos.";
$pgv_lang["inc_backup"] 			= "Padaryti atsargine kopija";
$pgv_lang["privacy_open_error"] 	= "Atidarant faila [#PRIVACY_MODULE#] buvo klaida.";
$pgv_lang["privacy_write_error"]	= "KLAIDA!!! Negalima irašyti i  [#PRIVACY_MODULE#]. <br/> Isitikinkite , kad failas turi irašymo (write) teises. <br/> Teises gali buti atstatytos po to kai saugumo failas yra irašytas.";
$pgv_lang["privacy_update_ok"]		= "Saugumo failas: [#PRIVACY_MODULE#]  atnaujintas sekmingai.";
$pgv_lang["privacy_uptodate"]		= "Jusu [#PRIVACY_MODULE#]  yra naujausios versijos.";
$pgv_lang["heading_privacy"]		= "Saugumo failai:";
$pgv_lang["heading_phpgedview"] 	= "PhpGedView failai:";
$pgv_lang["heading_language"]		= "Kalbos failai:";
$pgv_lang["heading_index"]			= "Indeksu failai:";
$pgv_lang["heading_image"]			= "Paveikslu failai:";
$pgv_lang["heading_theme"]			= "Temos failai:";
$pgv_lang["heading_docs"]			= "Žinynai:";
$pgv_lang["copied_success"] 		= "nukopijuotas sekmingai.";
$pgv_lang["backup_copied_success"]	= "archyvines kopijos failas sukurtas sekmingai.";
$pgv_lang["inc_docs"]				= "Žinynai";
$pgv_lang["inc_themes"] 			= "Temos";
$pgv_lang["inc_index"]				= "Indeksu failai";
$pgv_lang["inc_config"] 			= "Nustatymu failas";
$pgv_lang["upgrade_download"]		= "Užsaugoti:";
$pgv_lang["current_version"]		= "Dabartine stabili versija:";
$pgv_lang["use_version"]			= "Jus naudojate versija:";
$pgv_lang["delete_selected_messages"]	= "Ištrnti pažymetus pranešimus";
$pgv_lang["no_upgrade"] 			= "Nera failu, kuriuos reiktu atnaujinti.";
$pgv_lang["default_news_title"] 	= "Sveiki atvyke i Jusu genealogijos medi";
$pgv_lang["recent_changes_block"]	= "Naujausiu pakeitimu blokas";
$pgv_lang["recent_changes"] 		= "Naujausi pakeitimai";
$pgv_lang["common_surnames"]		= "Dažniausiai pasitaikancios pavardes";
$pgv_lang["move_down"]				= "Žemyn";
$pgv_lang["move_up"]				= "I viršu";
$pgv_lang["message"]				= "išsiusti pranešima";
$pgv_lang["my_messages"]			= "Pranešmai man";
$pgv_lang["date_created"]			= "Siuntimo data:";
$pgv_lang["message_from"]			= "Elektroninio pašto adresas:";
$pgv_lang["mygedview_desc"] 		= "Jusu MyGedView puslapis leidžia užsaugoti nuorodas i norimus žmones, sekti ivykius ir bendrauti su kitais sistemos PhpGedView naudotojais.";
$pgv_lang["no_messages"]			= "Jums nera pranešimu.";
$pgv_lang["my_favorites"]			= "Mano megistamiausi";
$pgv_lang["no_favorites"]			= "Jus nepasirinkote jokiu megstamiausiu asmenu.  Noredami prideti asmeni i megstamiausiu saraša suraskite  norima asmeni ir nuspauskite <B> Prideti i megstamiausius </B> arba naudokite cia esanti ID lauka ir iveskite ID tiesiai.";
$pgv_lang["add_to_my_favorites"]	= "Prideti i megstamiausius ";
$pgv_lang["message_email3"] 		= "PgpGedView administratoriui Jus pasiuntete tokia žinute:";
$pgv_lang["enter_body"] 			= "Prieš siunciant laiška, prašome ivesti tekstini pranešima.";
$pgv_lang["enter_subject"]			= "Prašome ivesti laiško antrašte.";
$pgv_lang["invalid_email"]			= "Suveskite egzistuojanti elektronini adresa.";
$pgv_lang["gedcom_favorites"]		= "Šio GEDCOM megstamiausi";
$pgv_lang["no_gedcom_favorites"]	= "Šiuo metu pasirinku megstamiausiu nera. Administratorius gali prideti i megstamiausiu saraša, kuris bus rodomas paleidžiant programa.";
$pgv_lang["random_picture"] 		= "Atsitiktine nuotrauka";
$pgv_lang["gedcom_created_using"]	= "Šis GEDCOM (gimines medis) buvo sukurtas naudojant   <b>#SOFTWARE# #VERSION#</b>.";
$pgv_lang["gedcom_created_on"]		= "Šis GEDCOM (gimines medis) buvo sukurtas <b>#DATE#</b>";
$pgv_lang["gedcom_created_on2"] 	= "Sukurimo data <b>#DATE#</b>";
$pgv_lang["gedcom_stats"]			= "GEDCOM Statistika";
$pgv_lang["stat_individuals"]		= "Asmenu,";
$pgv_lang["stat_latest_birth"] 	= "Jauniausio asmens gimimo metai";
$pgv_lang["stat_latest_death"] 	= "Veliausi mirties metai";
$pgv_lang["stat_earliest_death"] 	= "Anksciausi mirties metai";
$pgv_lang["stat_earliest_birth"] 	= "Vyriausio asmens  gimimo  metai";
$pgv_lang["stat_families"]			= "Šeimu, ";
$pgv_lang["stat_other"] 			= "Kitu irašu";
$pgv_lang["customize_page"] 		= "Tinkinti MyGedView puslapi";
$pgv_lang["upcoming_events_block"]	= "Busimi ivykiai";
$pgv_lang["right_section"]			= "Dešinysis pasirinkimu blokas";
$pgv_lang["available_blocks"]		= "Galimi blokai";
$pgv_lang["main_section"]			= "Pagrindinis pasirinkimu blokas";
$pgv_lang["customize_gedcom_page"]	= "Tinkinti šita GEDCOM pagrindini puslapi";
$pgv_lang["gedcom_news"]			= "Naujienos";
$pgv_lang["confirm_news_delete"]	= "Ar Jus isitikines, kad norite ištrinti šita naujienu iraša?";
$pgv_lang["add_news"]				= "Prideti naujiena";
$pgv_lang["no_news"]				= "Kol kas nera ivesta jokiu naujienu.";
$pgv_lang["enter_title"]			= "Iveskite antrašte.";
$pgv_lang["broadcast_all"]			= "Išplatinti visiems naudotojams";
$pgv_lang["hit_count"]				= "Lankymo skaitiklis:";
$pgv_lang["phpgedview_message"] 	= "PhpGedView pranešimas";
$pgv_lang["order"]					= "Eiliškumas";
$pgv_lang["extension"]				= "Pletinys";
$pgv_lang["add_media_tool"] 		= "Irankis media prideti";
$pgv_lang["upgrade_completed"]		= "Atnaujinimas sekmingas";
$pgv_lang["adds_completed"] 		= "Media sekmingai pridetas i GEDCOM faila.";
$pgv_lang["hourglass_chart"]		= "Smelio lakrodžio diagrama";
$pgv_lang["choose_report"]			= "Pasirinkite raporta vykdymui";
$pgv_lang["enter_report_values"]	= "Iveskite raporto reikšmes";
$pgv_lang["selected_report"]		= "Pasirinktas raportas";
$pgv_lang["run_report"] 			= "Žiureti raporta";
$pgv_lang["select_report"]			= "Išsirinkti raprota";
$pgv_lang["download_report"]		= "Parsisiusti raporta";
$pgv_lang["reports"]				= "Raprotai";
$pgv_lang["pdf_reports"]			= "PDF raprotai";
$pgv_lang["html_reports"]			= "HTML raprotai";
$pgv_lang["family_group_report"]	= "Šeimos grupes raportas";
$pgv_lang["of"] 					= "iš";
$pgv_lang["enter_famid"]			= "Iveskite šeimos ID";
$pgv_lang["show_sources"]			= "Rodyti šaltinius?";
$pgv_lang["show_notes"] 			= "Rodyti pastabas?";
$pgv_lang["show_abbr_notes"] 		= "Rodyti sutrumpintus pastabas?";
$pgv_lang["relatives_report_ext"]	= "Išplestas giminaiciu raportas";
$pgv_lang["relatives_report_ext"]	= "Išplestas giminaiciu raportas";
$pgv_lang["show_photos"]			= "Rodyti nuotraukas?";
$pgv_lang["individual_report"]		= "Asmens raportas";
$pgv_lang["enter_pid"]				= "Iveskite asmens ID";
$pgv_lang["individual_list_report"]	= "Asmenu sarašo raprotas";
$pgv_lang["generated_by"]			= "Generuotojas";
$pgv_lang["page"]					= "Puslapis";
$pgv_lang["marrdate2"]				= "Santuokos datos intervalo pabaiga";
$pgv_lang["marrdate1"]				= "Santuokos datos intervalo pradžia";
$pgv_lang["marrplace"]				= "Santuokos vietove savyje turi";
$pgv_lang["marr_report"]			= "Santuokos datos ir vietos ataskaita";
$pgv_lang["deathdate2"]				= "Mirties datos intervalo pabaiga";
$pgv_lang["deathdate1"]				= "Mirties datos intervalo pradžia";
$pgv_lang["deathplace"]				= "Mirties vietoveje yra";
$pgv_lang["death_report"]			= "Mirties datos ir vietos ataskaita";
$pgv_lang["birth_report"]			= "Gimimo datos ir vietos raportas";
$pgv_lang["birthplace"]				= "Gimimo data savyje turi";
$pgv_lang["birthdate1"]				= "Gimimo datos srities pradžia";
$pgv_lang["birthdate2"]				= "Gimimo datos srities pabaiga";
$pgv_lang["sort_by"]				= "Rušiuoti pagal";
$pgv_lang["cleanup"]				= "Išvalymas";
$pgv_lang["dynasty_list"]			= "Šeimu apžvalga";
$pgv_lang["excel_create"]			= "bus sukurtas faile:";
$pgv_lang["patriarch_list"] 		= "Tevu sarašas";
$pgv_lang["unmatching_facts"]		= "Sekantys faktai nesutampa. Pasirinkite informacija, kuria norite palikti.";
$pgv_lang["statistics"] 			= "Statistika";
$pgv_lang["merge_same"] 			= "Irašai nera to paties tipo. Negalima sujungti irašu, kurie nera to paties tipo.";
$pgv_lang["merge_step1"]			= "Sujungimo 1 žingsnis iš 3";
$pgv_lang["merge_step2"]			= "Sujungimo 2 žingsnis iš 3";
$pgv_lang["merge_step3"]			= "Sujungimo 3 žingsnis iš 3";
$pgv_lang["gen_ancestry_chart"]		= "#PEDIGREE_GENERATIONS#  kartu proteviu diagrama";
$pgv_lang["select_gedcom_records"]	= "Pasirinkite du GEDCOM iirašus sujungimui. Irašai turi butu to paties tipo.";
$pgv_lang["merge_to"]				= "Sujungti iki ID:";
$pgv_lang["merge_from"] 			= "Sujungti nuo ID:";
$pgv_lang["merge_facts_same"]		= "Sekantys faktai yra vienodi abejuose irašuose, todel bus automatiškai sujungti.";
$pgv_lang["no_matches_found"]		= "Tenkinanciu salyga faktu nerasta";
$pgv_lang["record"] 				= "Irašas";
$pgv_lang["adding"] 				= "Pridejimas";
$pgv_lang["updating_linked"]		= "Atnaujinamas susijes irašas";
$pgv_lang["ancestry_chart"] 		= "Kilmes diagrama";
$pgv_lang["chart_style"]			= "Diagramos stilius";
$pgv_lang["chart_booklet"]   	= "Skrajute";
$pgv_lang["chart_list"]			= "Sarašas";
$pgv_lang["ancestry_booklet"]   	= "Kilmes brošiura";
$pgv_lang["show_cousins"]			= "Rodyti giminaicius";
$pgv_lang["sosa_2"] 				= "Tevas";
$pgv_lang["sosa_3"] 				= "Motina";
$pgv_lang["sosa_4"] 				= "Senelis";
$pgv_lang["sosa_5"] 				= "Senele";
$pgv_lang["sosa_6"] 				= "Senelis";
$pgv_lang["sosa_7"] 				= "Senele";
$pgv_lang["sosa_9"] 				= "Prosenele";
$pgv_lang["sosa_10"]				= "Prosenelis";
$pgv_lang["sosa_11"]				= "Prosenele";
$pgv_lang["sosa_12"]				= "Prosenelis";
$pgv_lang["sosa_13"]				= "Prosenele";
$pgv_lang["sosa_14"]				= "Prosenelis";
$pgv_lang["sosa_15"]				= "Prosenele";
$pgv_lang["sosa_16"]				= "Proprosenelis";
$pgv_lang["sosa_17"]				= "Proprosenele";
$pgv_lang["sosa_18"]				= "Proprosenelis";
$pgv_lang["sosa_19"]				= "Proprosenele";
$pgv_lang["sosa_20"]				= "Proprosenelis";
$pgv_lang["sosa_21"]				= "Proprosenele";
$pgv_lang["sosa_22"]				= "Proprosenelis";
$pgv_lang["sosa_23"]				= "Proprosenele";
$pgv_lang["sosa_24"]				= "Proprosenelis";
$pgv_lang["sosa_25"]				= "Proprosenele";
$pgv_lang["sosa_26"]				= "Proprosenelis";
$pgv_lang["sosa_27"]				= "Proprosenele";
$pgv_lang["sosa_28"]				= "Proprosenelis";
$pgv_lang["sosa_29"]				= "Proprosenele";
$pgv_lang["sosa_30"]				= "Proprosenelis";
$pgv_lang["sosa_31"]				= "Proprosenele";
$pgv_lang["sosa_48"]			   = "Proproprosenelis";
$pgv_lang["sosa_49"]			   = "Proproprosenele";
$pgv_lang["sosa_51"]			   = "Proproprosenele";
$pgv_lang["sosa_53"]			   = "Proproprosenele";
$pgv_lang["sosa_55"]			   = "Proproprosenele";
$pgv_lang["sosa_53"]			   = "Proproprosenele";
$pgv_lang["sosa_57"]			   = "Proproprosenele";
$pgv_lang["sosa_59"]			   = "Proproprosenele";
$pgv_lang["sosa_61"]			   = "Proproprosenele";
$pgv_lang["sosa_50"]			   = "Proproprosenelis";
$pgv_lang["sosa_63"]			   = "Proproprosenele";
$pgv_lang["compact_chart"]			= "Suspausta diagrama";
$pgv_lang["sosa_52"]			   = "Proproprosenelis";
$pgv_lang["sosa_54"]			   = "Proproprosenelis";
$pgv_lang["sosa_54"]			   = "Proproprosenelis";
$pgv_lang["sosa_56"]			   = "Proproprosenelis";
$pgv_lang["sosa_58"]			   = "Proproprosenelis";
$pgv_lang["sosa_60"]			   = "Proproprosenelis";
$pgv_lang["sosa_60"]			   = "Proproprosenelis";
$pgv_lang["sosa_62"]			   = "Proproprosenelis";
$pgv_lang["sosa_48"]			   = "Proproprosenelis";
$pgv_lang["sosa_46"]			   = "Proproprosenelis";
$pgv_lang["sosa_47"]			   = "Proproprosenele";
$pgv_lang["sosa_44"]			   = "Proproprosenelis";
$pgv_lang["sosa_45"]			   = "Proproprosenele";
$pgv_lang["sosa_44"]			   = "Proproprosenelis";
$pgv_lang["sosa_42"]			   = "Proproprosenelis";
$pgv_lang["sosa_43"]			   = "Proproprosenele";
$pgv_lang["sosa_40"]			   = "Proproprosenelis";
$pgv_lang["sosa_41"]			   = "Proproprosenele";
$pgv_lang["sosa_38"]			   = "Proproprosenelis";
$pgv_lang["sosa_39"]			   = "Proproprosenele";
$pgv_lang["sosa_39"]			   = "Proproprosenele";
$pgv_lang["sosa_38"]			   = "Proproprosenelis";
$pgv_lang["sosa_38"]			   = "Proproprosenelis";
$pgv_lang["sosa_33"]			   = "Proproprosenele";
$pgv_lang["sosa_36"]			   = "Proproprosenelis";
$pgv_lang["sosa_37"]			   = "Proproprosenele";
$pgv_lang["sosa_36"]			   = "Proproprosenelis";
$pgv_lang["sosa_34"]			   = "Proproprosenelis";
$pgv_lang["sosa_35"]			   = "Proproprosenele";
$pgv_lang["sosa_32"]			   = "Proproprosenelis";
$pgv_lang["fan_chart"]				= "Ventilitoriaus diagrama";
$pgv_lang["gd_freetype"]			= "PHP serverio konfiguravimo klaida: reikalingu FreeType biblioteku  TrueType fontu naudojimui nera.";
$pgv_lang["gd_library"]				= "PHP serverio konfiguravimo klaida: reikalingu GD 2.x biblioteku vaizdo apdorojimui nera";
$pgv_lang["gd_library"]				= "PHP serverio konfiguravimo kalida: reikalingu GD 2.x  biblioteku vaizdo apradojimui nera.";
$pgv_lang["fontfile_error"]			= "Fontu failas PHP serveryje nerastas";
$pgv_lang["rss_descr"]				= "Naujienos ir nuorodos iš #GEDCOM_TITLE# puslapio";
$pgv_lang["fontfile_error"]			= "Fonu failas PHP serveryje  nerastas ";
$pgv_lang["friend"] = "Draugas";
$pgv_lang["godfather"] = "Krikštatevis";
$pgv_lang["godmother"] = "Krikštamote";
$pgv_lang["godparent"] = "Krikštateviai";
$pgv_lang["lodger"] = "Nuominikas";
$pgv_lang["nurse"] = "Aukle";
$pgv_lang["priest"] = "Dvasininkas";
$pgv_lang["rabbi"] = "Rabinas";
$pgv_lang["servant"] = "Tarnas";
$pgv_lang["twin"] = "Dvyniai";
$pgv_lang["twin_brother"] = "Dvyniai broliai";
$pgv_lang["twin_sister"] = "Dvynes seserys";
$pgv_lang["witness"] = "Liudininkas";
$pgv_lang["statutci"]			= "negaliu sukurti indekso";
$pgv_lang["statnnames"]                = "iš viso vardu =";
$pgv_lang["statnfam"]                  = "iš viso šeimu =";
$pgv_lang["statnmale"]                 = "iš viso vyru =";
$pgv_lang["statnfemale"]               = "iš viso moteru =";
$pgv_lang["stat_11_mb"]			 = "Gimimo menuo";
$pgv_lang["stat_12_md"]			 = "Mirties menuo";
$pgv_lang["stat_13_mm"]			 = "Santuokos menuo";
$pgv_lang["stat_16_mmb"]		= "Menesiu skaicius tarp vestuviu ir pirmo vaiko.";
$pgv_lang["stat_19_arm"]			 = "amžius vestuviu metais.";
$pgv_lang["stat_20_arm1"]			 = "amžius pirmuju vestuviu metais.";
$pgv_lang["stat_21_nok"]			 = "vaiku skaicius.";
$pgv_lang["stat_201_num"]			 = "skaiciai";
$pgv_lang["stat_202_perc"]			 = "procentais";
$pgv_lang["stat_301_mf"]			 = "vyrai/moterys";
$pgv_lang["statreset"]			 = "iš naujo";
$pgv_lang["statsubmit"]			 = "parodyti brežini";
$pgv_lang["stplGDno"]			 = "PHP4 neturi Grafinio atvaizdavimo bibliotekos (Graphics Display Library). Pagalba turi suteikti sistemos administratorius ";
$pgv_lang["stpljpgraphno"]		= "JPgraph modulio direktorijoje  <i>phpgedview/jpgraph/</i> nera. Prašom pasiimti ji iš http://www.aditus.nu/jpgraph/jpdownload.php<br />  <h3>Prieš tai suinstaliuokite  JPgraph i diraktorija <i>phpgedview/jpgraph/</i></h3><br />";
$pgv_lang["stplinfo"]			 = "Braižymo informacija:";
$pgv_lang["stplnoim"]			 = "Neidiegta:";
$pgv_lang["stpltype"]			 = "tipas:";
$pgv_lang["stplmf"]			 = "/vyrai-moterys";
$pgv_lang["stplipot"]			 = "/per laiko tarpa";
$pgv_lang["stplmonth"]			 = "menuo";
$pgv_lang["stplnumbers"]		 = "skaiciai šeimai";
$pgv_lang["stplage"]			 = "amžius";
$pgv_lang["stplperc"]			 = "procentas";
$pgv_lang["alive_in_year"]			= "Yra gyvi metais ...";
$pgv_lang["is_alive_in"]			= "Gyvi #YEAR# metais";
$pgv_lang["alive"]					= "Gyvi";
$pgv_lang["informant"] = "Informatorius";
$pgv_lang["dead"]					= "Mire";
$pgv_lang["maybe"]					= "Galbut";
$pgv_lang["add_directory"]			= "Prideti direktorija";
$pgv_lang["image_size"]				= "Paveiksliuko išmatavimai --";
$pgv_lang["manage_media"]			= "Tvarkyti media";
$pgv_lang["media_id"]			= "Media ID";
$pgv_lang["invalid_id"]			= "Toks ID šitame GEDCOM faile neegzistuoja.";
$pgv_lang["definitions"]		= "Apibrežimas";
$pgv_lang["click_here"]				= "Noredami testi spauskite cia";
$pgv_lang["lastname"]				= "Pavarde";
$pgv_lang["firstname"]				= "Vardas";
$pgv_lang["total_places"]			= "Rastos vietoves";
$pgv_lang["media_contains"]			= "Audio/video byla turi:";
$pgv_lang["repo_contains"]			= "Saugykla turi:";
$pgv_lang["source_contains"]		= "Šaltinis turi:";
$pgv_lang["htmlplus_block_narrative"] = "Pasakojamasis stilius (tik anglu kalba)";
$pgv_lang["htmlplus_block_content"] = "Turinys";
$pgv_lang["after"]					= "po";
$pgv_lang["before"]					= "Prieš";
$pgv_lang["before_or_after"]		= "Skaitliukas prieš ar po vardo?";
$pgv_lang["htmlplus_block_templates"] = "Šablonai";
$pgv_lang["display_all"]			= "Rodyti viska";
$pgv_lang["faq_list"] = "DUK sarašas";
$pgv_lang["confirm_faq_delete"] = "Ar isitikines, kad norite ištrinti DUK iraša";
$pgv_lang["preview"] =  "Peržiura";
$pgv_lang["hs_search"] 			= "Ieškoti";
$pgv_lang["hs_close"] 			= "Uždaryti langa";
$pgv_lang["hs_results"] 		= "Rasta rezultatu:";
$pgv_lang["hs_searchuser"]		= "Pagalba naudotojui";
$pgv_lang["hs_searchconfig"]	= "Pagalba administratoriui";
$pgv_lang["hs_searchhow"]		= "Paieškos tipas";
$pgv_lang["hs_searchall"]		= "Visi žodžiai";
$pgv_lang["hs_searchany"]		= "Bet kuris žodis";
$pgv_lang["hs_searchsentence"]	= "Tiksli fraze";
$pgv_lang["hs_intruehelp"]		= "Tik pagalbos tekstas";
$pgv_lang["hs_inallhelp"]		= "Visas tekstas";
$pgv_lang["choose"] = "Paririnkite:";
$pgv_lang["TYPE__audio"] = "Audio";
$pgv_lang["TYPE__book"] = "Knyga";
$pgv_lang["TYPE__certificate"] = "Sertifikatas";
$pgv_lang["TYPE__document"] = "Dokumentas";
$pgv_lang["TYPE__electronic"] = "Elektroninis formatas";
$pgv_lang["TYPE__magazine"] = "Žurnalas";
$pgv_lang["TYPE__newspaper"] = "Laikraštis";
$pgv_lang["TYPE__map"] = "Žemelapis";
$pgv_lang["TYPE__manuscript"] = "Rankraštis";
$pgv_lang["TYPE__video"] = "Vaizdas";
$pgv_lang["TYPE__photo"] = "Nuotraukos";
$pgv_lang["sosa_8"] 				= "Prosenelis";
$pgv_lang["ancestry_list"]			= "Kilmes sarašas";
$pgv_lang["stat_sources"]			= "Šaltiniu, ";
$pgv_lang["welcome"]				= "Sveiki";
$pgv_lang["login_head"] 			= "PhpGedView naudotojo vardas";
$pgv_lang["error_title"]			= "KLAIDA: Negaliu atidaryti GEDCOM failo";
$pgv_lang["for_support"]			= "Už technini palaikima ir informacijos teikima atsakingas";
$pgv_lang["for_contact"]			= "Už pagalba genealogijos klausimais atsakingas";
$pgv_lang["for_all_contact"]		= "Už technine pagalba ir genealogine informacija atsakingas ";
$pgv_lang["build_title"]			= "Kuriami index failai";
$pgv_lang["build_error"]			= "GEDCOM failas buvo atnaujintas.";
$pgv_lang["please_wait"]			= "Palaukite kol Index failai yra perkuriami.";
$pgv_lang["username"]				= "Naudotojo vardas";
$pgv_lang["invalid_username"]		= "Naudotojo varde yra neleistinu simboliu";
$pgv_lang["fullname"]				= "Pilnas vardas";
$pgv_lang["changelog"]				= "Versijos #VERSION# Pasikeitimai";
$pgv_lang["html_block_descr"]		= "Cia yra paprastas HTML blokas, kuri Jus galite padeti i savo puslapi ir prideti bet koki pranešima.";
$pgv_lang["html_block_name"]		= "HTML blokas";
$pgv_lang["num_to_show"]			= "Kiek irašu rodyti";
$pgv_lang["days_to_show"]			= "Kiek dienu rodyti";
$pgv_lang["config_block"]			= "Konfiguruoti bloka";
$pgv_lang["pls_note12"]				= "Ši lauka naudokite aprašyti  kodel jums reikia prisijungimo vardo prie šios informacijos ir kaip Jus esate giminystes ryšiais susije su šiais genealogine informacija.";
$pgv_lang["enter_comments"]			= "Nurodykite savo ryši su duomenimis  Komentaru lauke";
$pgv_lang["comments"]				= "Komentarai";
$pgv_lang["child-family"]			= "Tevai,  broliai, seserys";
$pgv_lang["spouse-family"]			= "Sutuoktinis ir vaikai";
$pgv_lang["direct-ancestors"]		= "Tiesioginiai proteviai";
$pgv_lang["ancestors"]				= "Tiesioginiai proteviai ir ju šeimos";
$pgv_lang["descendants"]			= "Palikuonys";
$pgv_lang["choose_relatives"]		= "Pasirinkite giminaicius";
$pgv_lang["relatives_report"]		= "Giminaiciu raportas";
$pgv_lang["total_not_born"]			= "Iš viso dar negimusiu";
$pgv_lang["total_dead"]				= "Iš viso mirusiu";
$pgv_lang["total_living"]			= "Iš viso gyvu";
$pgv_lang["fams_with_surname"]		= "Šeimos su pavarde #surname# ";
$pgv_lang["support_contact"]		= "Už technine pagalba atsakingas ";
$pgv_lang["continue_import"]		= "Testi vietoviu ikelima";
$pgv_lang["importing_places"]		= "Ikeliami vietoviu irašai";
$pgv_lang["common_upload_errors"]	= "Ši klaida tikriausiai reiškia, kad failas kuri Jus bandete nusiusti viršija serverio nustatytas ribas. Pagal nutylejima PHP leidžia tik 2Mb. Galite susisiekti su  Jusu serverio palaikimo komanda ir paprašyti padidinti ribas php.ini faile arba nusiusti faila naudojant FTP. Nusiuntus faila naudojant FTP, naudokite <a href=\"uploadgedcom.php?action=add_form\"><b>Prideti GEDCOM</b></a>  puslapi.";
$pgv_lang["total_memory_usage"]		= "Iš viso naudojama atminties:";
$pgv_lang["fathers_family_with"]	= "Tevo šeima su";
$pgv_lang["halfsister"]				= "Isesere";
$pgv_lang["family_timeline"]		= "Parodyti šeima laiko lenteleje";
$pgv_lang["other"]					= "Kita";
$pgv_lang["sort_by_marriage"]		= "Rušiuoti pagal vestuviu data";
$pgv_lang["reorder_families"]		= "Pertvarkyti šeimas";
$pgv_lang["indis_with_surname"]		= "Asmenys su pavarde  #surname#|";
$pgv_lang["first_letter_fname"]		= "Išsirinkite raide ir bus parodyti asmenys kuriu pavarde prasideda ta raide.";
$pgv_lang["marr_name_import_instr"]	= "Jei norite , kad programa tikrintu ir moteru pavardes po santuokos, nuspauskite žemaiu esanti mygtuka. Tai leis ieškoti ir tureti sarašuose moteris pagal ju pavardes po santuokos.";
$pgv_lang["total_names"]			= "Iš viso vardu";
$pgv_lang["upload_file"]			= "Padeti failus iš Jusu kompiuterio";
$pgv_lang["top10_pageviews_nohits"]	= "Šiuo metu nera apsilankymu, kuriuos butu galima parodyti.";
$pgv_lang["top10_pageviews_msg"]	= "kad šis blokas veiktu skaitliukas turi buti ijungtas GEDCOM konfiguracijoje.";
$pgv_lang["review_changes_block"]	= "Pataisymai laukiantys sprendimu";
$pgv_lang["review_changes_subject"]	= "PhpGedView - peržiureti pakeitimus";
$pgv_lang["review_changes_body"]	= "Gimines medžio informacijoje yra padaryti pakeitimai. Šie pakeitimai turi buti peržiureti ir patvirtinti. Tik tada jie bus matomi visiems naudotojams. Prašom naudoti žemiau esancia nuoroda, prisijungti prie sistemos ir peržiureti pakeitimus.";
$pgv_lang["show_spouses"]		= "Parodyti sutuoktinius";
$pgv_lang["quick_update_title"] = "Greitas atnaujinimas";
$pgv_lang["quick_update_instructions"] = "Šis puslapis leidžia greitai atnaujinti  informacija apie asmeni.  Jums reikia tik atnaujinti informacija kuri yra nauja arba pasikeitusi nuo dabar esancios. Po to kai pakeitimai bus padaryti, jie dar tures buti peržiureti administratoriaus. Tik po to jie bus matomi visiems.";
$pgv_lang["update_fact"] = "Atnaujinti fakta";
$pgv_lang["update_fact_restricted"] = "Šio fakto atnaujinimas apribotas:";
$pgv_lang["update_photo"] = "Atnaujinti nuotrauka";
$pgv_lang["select_fact"] = "Pasirinkite fakta...";
$pgv_lang["top10_pageviews_descr"]	= "Šis blokas parodo 10 labiausiai lankomu irašu. Tai reikalauja  ijungti apsilankymu skaitliuka GEDCOM konfiguracijos nustatymuose.";
$pgv_lang["top10_pageviews"]		= "Labiausiai žiurimi irašai";
$pgv_lang["top10_pageviews_block"]		= "Dažniausiai lankomu irašu blokas";
$pgv_lang["stepdad"]				= "Patevis";
$pgv_lang["stepmom"]				= "Pamote";
$pgv_lang["stepsister"]				= "Isesere";
$pgv_lang["stepbrother"]			= "Ibrolis";
$pgv_lang["fams_charts"]			= "Pasirinkimai šeimai";
$pgv_lang["indis_charts"]			= "Pasirinkimai asmeniui";
$pgv_lang["edit_indi"] 				= "Taisyti asmeni";
$pgv_lang["locked"]					= "Nekeisti";
$pgv_lang["privacy"]				= "slaptumas";
$pgv_lang["help_for_this_page"] 	= "Pagalba šiame puslapyje";
$pgv_lang["help_contents"]			= "Pagalbos turinys";
$pgv_lang["show_context_help"]		= "Rodyti kontekstine pagalba";
$pgv_lang["hide_context_help"]		= "Paslepti kontekstine pagalba";
$pgv_lang["sorry"]					= "<b>Atleiskite, bet pagalbos tekstas šiam puslapiui arba irašui kol kas dar neegzistuoja. </b>";
$pgv_lang["help_not_exist"] 		= "<b>Pagalbos tekstas šiam puslapiui arba irašui kol kas dar neegzistuoja. </b>";
$pgv_lang["var_not_exist"]			= "<span style=font-weight: bold>Nera tokios kalbos kintamojo. Informuokite tai kaip klaida.</span>";
$pgv_lang["resolution"] 			= "Ekrano raiška";
$pgv_lang["menu"]					= "Meniu";
$pgv_lang["header"] 				= "Antrašte";
$pgv_lang["imageview"]				= "Paveikslu peržiura";
$pgv_lang["page_help"]				= "Pagalba";
$pgv_lang["update_address"] = "Atnaujinti adresa";
$pgv_lang["update_name"] = "Atnaujinti varda";
$pgv_lang["children_timeline"]		= "Parodyti vaikus laiko lenteleje";
$pgv_lang["halfbrother"]			= "Ibrolis";
$pgv_lang["mothers_family_with"]	= "Motinos šeima su ";
$pgv_lang["genealogy_contact"]		= "Gimines medžio kontaktinis asmuo";
$pgv_lang["ahnentafel_report"]		= "Proteviu raportas";
$pgv_lang["options"]				= "Parinktys:";
?>
