<?php
/**
 * Portugese Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2024  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author José Monteiro
 * @website http://existologoescrevo.blogspot.com/
 * @e-mail jalberto@bluewin.ch
 * @translator Google Translate
 * @version $Id: lang.pt.php 7374 2024-02-13 13:57:05Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["birth_M"]					= "Aniversário de #name#";		// For male persons
$pgv_lang["birth_F"]					= "Aniversário de #name#";		// For female persons
$pgv_lang["born_in_M"]					= "Nascido em #date# em #place#";		// For male persons
$pgv_lang["born_in_F"]					= "Nascido em #date# em #place#";		// For female persons
$pgv_lang["born_on_M"]					= "Nascido em #date#";		// For male persons
$pgv_lang["born_on_F"]					= "Nascido em #date#";		// For female persons
$pgv_lang["death_M"]					= "Aniversário da morte de #name#";		// For male persons
$pgv_lang["death_F"]					= "Aniversário da morte de #name#";		// For female persons
$pgv_lang["died_in_M"]					= "Morreu em #date# em #place#";		// For male persons
$pgv_lang["died_in_F"]					= "Morreu em #date# em #place#";		// For female persons
$pgv_lang["died_on_M"]					= "Morreu em #date#";		// For male persons
$pgv_lang["died_on_F"]					= "Morreu em #date#";		// For female persons
$pgv_lang["anniversary_of"]				= "Aniversário de casamento de #husband# e #wife#";
$pgv_lang["married_in"]					= "Casado em #date# em #place#";
$pgv_lang["married_on"]					= "Casado em #date#";
$pgv_lang["clustrmaps_locations"]		= "Localização dos visitantes a esta página";
$pgv_lang["gedcomid"]					= "Identificação na Árvore Genealógica";
$pgv_lang["sortby"]						= "Ordem";
$pgv_lang["exact"]						= "Exato";
$pgv_lang["begins_with"]				= "Começa com";
$pgv_lang["contains"]					= "Contém";
$pgv_lang["sounds_like"]				= "Soa como";
$pgv_lang["advanced_search"]			= "Pesquisa avançada de site";
$pgv_lang["more_fields"]				= "Adicionar mais campos";
$pgv_lang["install_step_8"] 			= "Começar";
$pgv_lang["parent_family"]				= "Família pais";
$pgv_lang["step_parent_family"]			= "Família co-pais";
$pgv_lang["immediate_family"]			= "Família imediata";

$pgv_lang["load_full_tree"]				= "Ver esta árvore na árvore interativa de página inteira";
$pgv_lang["hide_show_spouses"]			= "Mostrar ou ocultar múltiplos cônjuges";
$pgv_lang["interactive_tree"]			= "Árvore interativa";
$pgv_lang["example"]					= "Exemplo:";
$pgv_lang["tree"]						= "Árvore";
$pgv_lang["ellipsis"]					= "\xE2\x80\xA6";
$pgv_lang["showUnknown"]				= "Mostrar gênero desconhecido";
$pgv_lang["count"]						= "Contagem";
$pgv_lang["age_differences"]			= "Mostrar diferença entre datas";
$pgv_lang["multi_site_search"]			= "Pesquisa Multi-Site";
$pgv_lang["switch_lifespan"]			= "Mostrar gráfico de tempo de vida";
$pgv_lang["switch_timeline"]			= "Mostrar gráfico de cronologia";
$pgv_lang["differences"]				= "Diferenças";
$pgv_lang["charts_block"]				= "Gráficos";
$pgv_lang["charts_block_descr"]			= "O bloco «Gráficos» permite que você coloque um gráfico sobre o página Bem-vindo ou o Meu Portal.  Você pode configurar o bloco para mostrar um ver ancestrais, descendentes ou ampulheta.  Você também pode escolher a pessoa de raiz para o gráfico.";
$pgv_lang["charts_click_box"]			= "Clique em qualquer uma das caixas para obter mais informações sobre essa pessoa.";
$pgv_lang["chart_type"]					= "Tipo de Gráfico";
$pgv_lang["changedate1"]				= "Intervalo final de datas mudança";
$pgv_lang["changedate2"]				= "Intervalo começando de datas mudança";
$pgv_lang["search_place_word"]			= "Apenas palavras inteiras";
$pgv_lang["invalid_search_input"]		= "Favor informar um Nome, Sobrenome ou Local. Opcionalmente informe o Ano";
$pgv_lang["duplicate_username"]			= "Nome de Membro «#username#» duplicado.  Já existe um Membro com este nome. Por favor escolha outro nome de Membro.";
$pgv_lang["usercreate_fail"]			= "O usuário «#username#» não pôde ser adicionado ao sistema.";
$pgv_lang["cache_life"]					= "Vida de arquivo Cache";
$pgv_lang["genealogy"]					= "Genealogia";
$pgv_lang["activate"]					= "Ativar";
$pgv_lang["deactivate"]					= "Desativar";
$pgv_lang["play_stop"]					= "Começar / Terminar";
$pgv_lang["random_media_start_slide"]	= "Iniciar apresentação de diapositivos no carregamento da página?";
$pgv_lang["random_media_ajax_controls"]	= "Mostrar controles da apresentação de diapositivos?";
$pgv_lang["description"]				= "Descrição";
$pgv_lang["current_dir"]				= "Pasta Atual";
$pgv_lang["SHOW_ID_NUMBERS"]			= "Exibir números de ID ao lado dos nomes";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES"]		= "Exibir imagens de destaque na página de pessoas";
$pgv_lang["view_img_details"]			= "Ver detalhes da imagem";
$pgv_lang["server_folder"]				= "Nome da pasta no servidor";
$pgv_lang["medialist_recursive"]		= "Catalogar os arquivos em subdiretórios";
$pgv_lang["medialist_unlinked"]			= "Mostrar apenas mídia desvinculada";
$pgv_lang["medialist_current_dir"]		= "Subdiretório atual";
$pgv_lang["media_options"]				= "Opções de mídia";
$pgv_lang["confirm_password"]			= "Confirme sua senha.";
$pgv_lang["enter_email"]				= "Informer seu e-mail.";
$pgv_lang["enter_fullname"]				= "Informe o nome completo.";
$pgv_lang["name"]						= "Nome";
$pgv_lang["names"]						= "Nomes";
$pgv_lang["children"]					= "Filhos";
$pgv_lang["lchildren"]					= "filhos";
$pgv_lang["child"]						= "Filho";
$pgv_lang["grandchildren"]				= "Netos";
$pgv_lang["family"]						= "Família";
$pgv_lang["as_child"]					= "Família com Pais";
$pgv_lang["shared_note_menu"]			= "Opções para nota partilhada";
$pgv_lang["source_menu"]				= "Opções para fonte";
$pgv_lang["repo_menu"]					= "Opções para repositório";
$pgv_lang["other_records"]				= "Outros registos relacionados a esta fonte";
$pgv_lang["other_repo_records"]			= "Registos ligados a esta Reposição";
$pgv_lang["repo_info"]					= "Informação da Reposição";
$pgv_lang["enter_terms"]				= "Informe os Argumentos da Pesquisa";
$pgv_lang["search_asso_label"]			= "Testemunhas";
$pgv_lang["search_asso_text"]			= "Exibir pessoas/famílias relacionadas";
$pgv_lang["search_DM"]					= "Daitch-Mokotoff";
$pgv_lang["search_fams"]				= "Famílias";
$pgv_lang["search_gedcom"]				= "Pesquisar arquivos GEDCOM";
$pgv_lang["search_geds"]				= "Pesquisar nos seguintes GEDCOMS";
$pgv_lang["search_indis"]				= "Pessoas";
$pgv_lang["search_notes"]				= "Notas partilhadas";
$pgv_lang["search_inrecs"]				= "Pesquisar por";
$pgv_lang["search_prtall"]				= "Todos os nomes";
$pgv_lang["search_prthit"]				= "Nomes com hit";
$pgv_lang["results_per_page"]			= "Resultados por página";
$pgv_lang["firstname_search"]			= "Nome";
$pgv_lang["search_prtnames"]			= "Nome das pessoas a serem impressas:";
$pgv_lang["other_searches"]				= "Outras Pesquisas";
$pgv_lang["add_to_cart"]				= "Adicionar ao Carrinho de Recortes";
$pgv_lang["view_gedcom"]				= "Exibir registro GEDCOM";
$pgv_lang["welcome"]					= "Bem-Vindo";
$pgv_lang["son"]						= "Filho";
$pgv_lang["daughter"]					= "Filha";
$pgv_lang["welcome_page"]				= "Página Inicial";
$pgv_lang["editowndata"]				= "Minha Conta";
$pgv_lang["user_admin"]					= "Gerenciar Membros";
$pgv_lang["manage_media"]				= "Gerenciar Mídias";
$pgv_lang["search_general"]				= "Pesquisa Normal";
$pgv_lang["clipping_privacy"]			= "Alguns itens não podem ser adicionados devido a restrições de privacidade";
$pgv_lang["chart_new"]					= "Gráfico Árvore de Família";
$pgv_lang["loading"]					= "Carregamento...";
$pgv_lang["clear_chart"]				= "Remover gráfico";
$pgv_lang["file_information"]			= "Informação sobre o arquivo";
$pgv_lang["choose_file_type"]			= "Tipo de Arquivo";
$pgv_lang["add_individual_by_id"]		= "Adicionar pessoa pelo ID";
$pgv_lang["advanced_options"]			= "Opções avançadas";
$pgv_lang["zip_files"]					= "Compactar (zip) os Arquivos";
$pgv_lang["include_media"]				= "Incluir mídia (compacta automaticamente)";
$pgv_lang["roman_surn"]					= "Sobrenome romanizado";
$pgv_lang["roman_givn"]					= "Nomes romanizados";
$pgv_lang["include"]					= "Incluir:";
$pgv_lang["page_x_of_y"]				= "Página #GLOBALS[currentPage]# de #GLOBALS[lastPage]#";
$pgv_lang["options"]					= "Opções:";
$pgv_lang["config_update_ok"]			= "Arquivo de configuração atualizado com sucesso.";
$pgv_lang["page_size"]					= "Tamanho da Página";
$pgv_lang["font"]						= "Tipo";
$pgv_lang["use_colors"]					= "Usar cores";
$pgv_lang["record_not_found"]			= "O registro GEDCOM solicitado não foi encontrado. A causa provável é de uma ligação com uma pessoa inexistente ou por um arquivo GEDCOM corrompido.";
$pgv_lang["result_page"]				= "Página de Resultado";
$pgv_lang["edit_media"]					= "Editar Mídia";
$pgv_lang["wiki_main_page"]				= "Página principal do Wiki";
$pgv_lang["wiki_users_guide"]			= "Guia do Wiki para Membros";
$pgv_lang["wiki_admin_guide"]			= "Guia Wiki para Administradores";
$pgv_lang["no_search_for"]				= "Assegure-se de marcar uma opção para a pesquisa.";
$pgv_lang["no_search_site"]				= "Selecione pelo menos um site remoto.";
$pgv_lang["search_sites"]				= "Sites onde pesquisar";
$pgv_lang["site_list"]					= "Site:";
$pgv_lang["site_had"]					= "contendo o seguinte:";
$pgv_lang["label_search_engine_detected"]	= "Detetado Robô de Pesquisa";

$pgv_lang["ex-spouse"]					= "Ex-Cônjuge";
$pgv_lang["ex-wife"]					= "Ex-Esposa";
$pgv_lang["ex-husband"]					= "Ex-Marido";
$pgv_lang["noemail"]					= "Endereços sem emails";
$pgv_lang["onlyemail"]					= "Somente endereços com emails";
$pgv_lang["maxviews_exceeded"]			= "Máximo de visualizações da página excedido, tente mais tarde.";
$pgv_lang["broadcast_not_logged_6mo"]	= "Enviar mensagem aos Membros que não acessam o site a 6 mêses";
$pgv_lang["broadcast_never_logged_in"]	= "Enviar mensagem aos Membros que nunca acessaram o site.";
$pgv_lang["stats_to_show"]				= "Escolha a estatística a ser mostrada neste bloco";
$pgv_lang["stat_avg_age_at_death"]		= "Média De Vida";
$pgv_lang["stat_longest_life"]			= "Pessoa Que Mais Viveu";
$pgv_lang["stat_most_children"]			= "Família Com Mais Filhos";
$pgv_lang["stat_average_children"]		= "Média de Filhos Por Família";
$pgv_lang["stat_events"]				= "Total de Eventos";
$pgv_lang["stat_media"]					= "Mídias";
$pgv_lang["stat_surnames"]				= "Sobrenomes";
$pgv_lang["stat_users"]					= "Total de Membros";
$pgv_lang["no_family_facts"]			= "Não a fatos para esta família.";
$pgv_lang["stat_males"]					= "Homens";
$pgv_lang["stat_females"]				= "Fêmeas";
$pgv_lang["stat_unknown"]				= "Desconhecido";
$pgv_lang["stat_link"]					= "Ver estatísticas como gráficos";
$pgv_lang["print_stat_link"]			= "Mostrar ligação para gráficos estatísticos?";

$pgv_lang["sunday_1st"]					= "Dom";
$pgv_lang["monday_1st"]					= "Seg";
$pgv_lang["tuesday_1st"]				= "Ter";
$pgv_lang["wednesday_1st"]				= "Qua";
$pgv_lang["thursday_1st"]				= "Qui";
$pgv_lang["friday_1st"]					= "Sex";
$pgv_lang["saturday_1st"]				= "Sab";

$pgv_lang["jan_1st"]					= "Jan";
$pgv_lang["feb_1st"]					= "Fev";
$pgv_lang["mar_1st"]					= "Mar";
$pgv_lang["apr_1st"]					= "Abr";
$pgv_lang["may_1st"]					= "Mai";
$pgv_lang["jun_1st"]					= "Jun";
$pgv_lang["jul_1st"]					= "Jul";
$pgv_lang["aug_1st"]					= "Ago";
$pgv_lang["sep_1st"]					= "Set";
$pgv_lang["oct_1st"]					= "Out";
$pgv_lang["nov_1st"]					= "Nov";
$pgv_lang["dec_1st"]					= "Dez";

$pgv_lang["edit_source"]				= "Editar fonte";
$pgv_lang["edit_shared_note"]			= "Editar nota partilhada";
$pgv_lang["familybook_chart"]			= "Álbum de família";
$pgv_lang["family_of"]					= "Família de&nbsp;";
$pgv_lang["descent_steps"]				= "Máximo de quebras";

$pgv_lang["cancel"]						= "Cancelar";
$pgv_lang["cookie_help"]				= "Este site faz uso de cookies para seu correto funcionamento.<br /><br />Aparentemente o uso de Cookies está desabilitado em seu Navegador. Consulte a Ajuda de seu Navegador e habilite o uso de cookies.";
//new stuff
//Individual
$pgv_lang["indi_is_remote"]				= "A informação desta pessoa está ligada a um site remoto.";
$pgv_lang["link_remote"]				= "Ligar a uma pessoa remota";
//Add Remote Link
$pgv_lang["title_search_link"]			= "Adicionar Ligação Local";
$pgv_lang["label_site_url2"]			= "Endereço do Site";
//new stuff

$pgv_lang["delete_family_confirm"]		= "Excluir a família desvinculará todos os indivíduos uns dos outros, mas os deixará no lugar. Tem certeza de que deseja excluir esta família?";
$pgv_lang["delete_family"]				= "Excluir Família";
$pgv_lang["add_favorite"]				= "Adicionar Favorito";
$pgv_lang["url"]						= "URL";
$pgv_lang["add_fav_enter_note"]			= "Observação deste favorito - opcional";
$pgv_lang["add_fav_or_enter_url"]		= "OU<br />informe uma URL e um título";
$pgv_lang["add_fav_enter_id"]			= "Informe a ID da Pessoa, Família ou Fonte";
$pgv_lang["remove_child"]				= "Remover este filho da Família";
$pgv_lang["link_new_husb"]				= "Adicionar um marido a partir de uma pessoa da árvore";
$pgv_lang["link_new_wife"]				= "Adicionar uma esposa a partir de uma pessoa da árvore";
$pgv_lang["address_labels"]				= "Etiquetas de Endereço";
$pgv_lang["filter_address"]				= "Exibir endereços contendo:";
$pgv_lang["address_list"]				= "Lista de Endereços";
$pgv_lang["index_edit_advice"]			= "Clique em uma das setas para mover o Bloco selecionado na direção desejada.";
$pgv_lang["changelog"]					= "Modificações na Versão #VERSION#";
$pgv_lang["html_block_descr"]			= "O bloco de HTML simples, permite que você inclua uma mensagem qualquer na sua página.";
$pgv_lang["html_block_sample_part1"]	= "<p class=\"blockhc\"><b>Informe o título aqui</b></p><br /><p>Clique o botão configurar";
$pgv_lang["html_block_sample_part2"]	= "para alterar o que está impresso aqui.</p>";
$pgv_lang["html_block_name"]			= "HTML";
$pgv_lang["htmlplus_block_name"]		= "HTML Avançado";
$pgv_lang["htmlplus_block_descr"]		= "Este é um bloco de HTML, que permite incluir qualquer mensagem em sua página. A mensagem pode conter informações extraidas diretamente do GEDCOM.";
$pgv_lang["htmlplus_block_templates"]	= "Modelos";
$pgv_lang["htmlplus_block_content"]		= "Conteúdo";
$pgv_lang["htmlplus_block_narrative"]	= "Tipo narrativa (só em inglês)";
$pgv_lang["htmlplus_block_custom"]		= "Personalizado";
$pgv_lang["htmlplus_block_keyword"]		= "Exemplos de palavras-chave (Apenas Inglês)";
$pgv_lang["htmlplus_block_taglist"]		= "Catálogo de Tags";
$pgv_lang["htmlplus_block_compat"]		= "Modo de compatibilidade";
$pgv_lang["htmlplus_block_ui"]			= "Interface estendida";
$pgv_lang["htmlplus_block_current"]		= "Atual";
$pgv_lang["htmlplus_block_default"]		= "Padrão";
$pgv_lang["htmlplus_block_gedcom"]		= "Árvore Genealógica";
$pgv_lang["htmlplus_block_birth"]		= "Nascimento";
$pgv_lang["htmlplus_block_death"]		= "Morte";
$pgv_lang["htmlplus_block_marrage"]		= "Casamento";
$pgv_lang["htmlplus_block_adoption"]	= "Adoção";
$pgv_lang["htmlplus_block_burial"]		= "Sepultamento";
$pgv_lang["htmlplus_block_census"]		= "Censo adicionada";
$pgv_lang["num_to_show"]				= "Número de itens exibidos";
$pgv_lang["days_to_show"]				= "Número de dias exibidos";
$pgv_lang["before_or_after"]			= "Contadores, antes ou depois do nome?";
$pgv_lang["before"]						= "antes";
$pgv_lang["after"]						= "depois";
$pgv_lang["config_block"]				= "Configurar";
$pgv_lang["enter_comments"]				= "Por favor, em Comentários, informe seu relacionamento com a árvore.";
$pgv_lang["comments"]					= "Comentários";
$pgv_lang["child-family"]				= "Pais e Parentes";
$pgv_lang["spouse-family"]				= "Cônjuge e filhos";
$pgv_lang["direct-ancestors"]			= "Ancestrais diretos";
$pgv_lang["ancestors"]					= "Ancestrais diretos e suas famílias";
$pgv_lang["descendants"]				= "Descendentes";
$pgv_lang["choose_relatives"]			= "Escolha os parentes";
$pgv_lang["relatives_report"]			= "Relatório de Parentes";
$pgv_lang["total_unknown"]				= "Desconhecido";
$pgv_lang["total_living"]				= "Vivos";
$pgv_lang["total_dead"]					= "Mortos";
$pgv_lang["total_not_born"]				= "Natimorto";
$pgv_lang["remove_custom_tags"]			= "Remover tags específicas do PGV? (ex. _PGVU, _THUM)";
$pgv_lang["fams_with_surname"]			= "Famílias com o sobrenome #surname#";
$pgv_lang["support_contact"]			= "Contato para ajuda técnica";
$pgv_lang["genealogy_contact"]			= "Contato para ajuda genealógica";
$pgv_lang["common_upload_errors"]		= "Este êrro indica que o arquivo enviado excedeu o tamanho máximo permitido pelo provedor do site. O limite padrão do PHP é de 2MB. Peça ao suporte de seu provedor para aumentar este limite no arquivo php.ini, ou tente enviar o arquivo por FTP. Use a página <a href=\"uploadgedcom.php?action=add_form\"><b>#pgv_lang[add_gedcom]#</b></a> para processar o arquivo GEDCOM enviado por FTP.";
$pgv_lang["max_upload_advice"]			= "Se você precisar enviar arquivos maiores que o máximo mostrado aqui, a opção de configuração <i>upload_max_filesize</i> no arquivo <i>php.ini</i> no servidor deve ser ajustada. Pode ser necessário consultar o suporte do servidor.";
$pgv_lang["total_memory_usage"]			= "Total de Memória Utilizada:";
$pgv_lang["mothers_family_with"]		= "Família Materna com ";
$pgv_lang["fathers_family_with"]		= "Família Paterna com ";
$pgv_lang["family_with"]				= "Família com ";
$pgv_lang["halfsibling"]				= "Meio-Irmão";
$pgv_lang["halfbrother"]				= "Meio-Irmão";
$pgv_lang["halfsister"]					= "Meia-Irmã";
$pgv_lang["family_timeline"]			= "Exibir a família no gráfico Cronológico";
$pgv_lang["children_timeline"]			= "Exibir filhos no gráfico Cronológico";
$pgv_lang["other"]						= "Outros";
$pgv_lang["others"]						= "Outros";
$pgv_lang["sort_by_marriage"]			= "Ordenar pela data de casamento";
$pgv_lang["reorder_families"]			= "Reordenar Famílias";
$pgv_lang["indis_with_surname"]			= "Pessoas com o sobrenome #surname#";
$pgv_lang["first_letter_name"]			= "Escolher um carta para mostram famílias cujas nome começa com essa letra.";
$pgv_lang["first_letter_sfname"]		= "Escolha uma letra para mostrar as famílias em que um cônjuge tem um nome dado que se inicia com essa letra.";
$pgv_lang["first_letter_iname"]			= "Escolha uma letra para mostrar indivíduos cujo sobrenome começa com essa letra.";
$pgv_lang["first_letter_fname"]			= "Escolha a letra inicial do nome das pessoas a serem exibidas.";
$pgv_lang["total_names"]				= "Total de Nomes";
$pgv_lang["total_changes"]				= "Mudanças totais";
$pgv_lang["total_links"]				= "Ligações totais";
$pgv_lang["top10_pageviews_nohits"]		= "Não há hits para exibir";
$pgv_lang["top10_pageviews_msg"]		= "Contadores de hit devem ser habilitados na configuração da GEDCOM, nas seções Exibição e Formatação, nos grupos Esconder e Exibir.";
$pgv_lang["review_changes_descr"]		= "O bloco «Alterações Pendentes» permite aos Membros, com permissão de Edição Imediata, de rever a lista de registos com as alterações pendentes. Estas alterações precisam ser aceitas ou rejeitadas.<br /><br />Caso este bloco seja habilitado, Membros com permissão de Edição Imediata, receberão um email uma vez ao dia para lembra-los das pendências.";
$pgv_lang["review_changes_block"]		= "Alterações Pendentes";
$pgv_lang["review_changes_subject"]		= "PhpGedView - Revisar alterações ";
$pgv_lang["review_changes_body"]		= "Foram feitas alterações no banco de dados genealógico. Estas alterações precisam ser revisadas antes que sejam exibidas para todos os Membros. Use a URL abaixo para acessar o site e revisar as alterações.";
$pgv_lang["show_pending"]				= "Mostrar alterações pendentes";
$pgv_lang["show_spouses"]				= "Exibir cônjuges";
$pgv_lang["quick_update_title"]			= "Edição Simplificada";
$pgv_lang["quick_update_instructions"]	= "Está página permite que você atualize rapidamente informações de uma pessoa. As alterações efetuadas, serão revisadas pelo administrador do site e somente após a aceitação destas é que os demais Membros poderão ver suas alterações.";
$pgv_lang["update_name"]				= "Atualizar Nome";
$pgv_lang["update_fact"]				= "Atualizar o Fato";
$pgv_lang["update_fact_restricted"]		= "Atualização deste fato é restrito:";
$pgv_lang["select_fact"]				= "Selecione um fato...";
$pgv_lang["update_address"]				= "Atualizar o Endereço";
$pgv_lang["top10_pageviews_descr"]		= "O bloco «Os mais visitados» mostrará os registros mais visualizados. Este bloco requer, que a opção Contadores de Acesso, localizada na configuração da GEDCOM, esteja habilitada.";
$pgv_lang["top10_pageviews"]			= "Os mais visitados";
$pgv_lang["top10_pageviews_block"]		= "Os mais visitados";
$pgv_lang["stepparent"]					= "Co-pai/co-mãe";
$pgv_lang["stepdad"]					= "Co-pai";
$pgv_lang["stepmom"]					= "Co-mãe";
$pgv_lang["stepsister"]					= "Co-irmã";
$pgv_lang["stepbrother"]				= "Co-irmão";
$pgv_lang["fams_charts"]				= "Opções para esta família";
$pgv_lang["indis_charts"]				= "Opções para esta pessoa";
$pgv_lang["none"]						= "Nenhum";
$pgv_lang["facts"]						= "Fatos";
$pgv_lang["locked"]						= "Não alterar";
$pgv_lang["privacy"]					= "Privacidade";
$pgv_lang["number_sign"]				= "#";

//-- GENERAL HELP MESSAGES
$pgv_lang["qm"]							= "?";
$pgv_lang["qm_ah"]						= "?";
$pgv_lang["page_help"]					= "Ajuda";
$pgv_lang["help_for_this_page"]			= "Ajuda desta página";
$pgv_lang["help_contents"]				= "Índice da Ajuda";
$pgv_lang["show_context_help"]			= "Exibir link de Ajuda";
$pgv_lang["hide_context_help"]			= "Não exibir link de Ajuda";
$pgv_lang["sorry"]						= "<b>Desculpe, mas ainda não há texto de ajuda para esta página ou ítem</b>";
$pgv_lang["help_not_exist"]				= "<b>Não há texto de Ajuda para esta página ou ítem</b>";
$pgv_lang["var_not_exist"]				= "<span style=\"font-weight: bold\">Não existe a variável neste idioma. Por favor comunique o erro.</span>";
$pgv_lang["resolution"]					= "Resolução de tela";
$pgv_lang["menu"]						= "Menu";
$pgv_lang["header"]						= "Cabeçalho";
$pgv_lang["imageview"]					= "Visualizador de Imagens";

//-- CONFIG FILE MESSAGES
$pgv_lang["login_head"]					= "Identificação de Membro";
$pgv_lang["for_support"]				= "Para Suporte Técnico e Informações entre em contato com";
$pgv_lang["for_contact"]				= "Para Ajuda sobre questões Genealógicas entre em contato com";
$pgv_lang["for_all_contact"]			= "Para suporte técnico ou questões Genealógicas, por favor entre em contato com";
$pgv_lang["choose_username"]			= "Nome Membro desejado";
$pgv_lang["username"]					= "Membro";
$pgv_lang["invalid_username"]			= "Nome do membro «#username#» contém caracteres inválidos";
$pgv_lang["firstname"]					= "Nome";
$pgv_lang["lastname"]					= "Sobrenome";
$pgv_lang["choose_password"]			= "Senha desejada";
$pgv_lang["password"]					= "Senha";
$pgv_lang["confirm"]					= "Confirme a Senha";
$pgv_lang["login"]						= "Conectar";
$pgv_lang["logout"]						= "Desconectar";
$pgv_lang["admin"]						= "Administração";
$pgv_lang["logged_in_as"]				= "Conectado como ";
$pgv_lang["my_pedigree"]				= "Minha Árvore";
$pgv_lang["my_indi"]					= "Meus Dados";
$pgv_lang["yes"]						= "Sim";
$pgv_lang["no"]							= "Não";
$pgv_lang["change_theme"]				= "Temas";

//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]				= "Árvore Genealógica";
$pgv_lang["gen_ped_chart"]				= "#PEDIGREE_GENERATIONS# Gerações";
$pgv_lang["generations"]				= "Gerações";
$pgv_lang["view"]						= "Exibir";
$pgv_lang["fam_spouse"]					= "Família com cônjuge:";
$pgv_lang["rootid"]						= "Pessoa raiz da Árvore Genealógica";
$pgv_lang["root_person"]				= "ID Raiz";
$pgv_lang["hide_details"]				= "Esconder Detalhes";
$pgv_lang["show_details"]				= "Exibir Detalhes";
$pgv_lang["zoom_box"]					= "Zoom +/- nesta caixa";
$pgv_lang["orientation"]				= "Orientação da página";
$pgv_lang["portrait"]					= "Retrato";
$pgv_lang["landscape"]					= "Paisagem";
$pgv_lang["landscape_top"]				= "Mais antigo no alto";
$pgv_lang["landscape_down"]				= "Mais antigo no fundo";
$pgv_lang["start_at_parents"]			= "Iniciar nos Pais";
$pgv_lang["charts"]						= "Gráficos";
$pgv_lang["lists"]						= "Listas";
$pgv_lang["box_width"]					= "Largura";
$pgv_lang["random_surn"]				= "Sobrenome aleatória";
$pgv_lang["generation_number"]			= "Gerações";
$pgv_lang["variable"]					= "Variável";

//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"]		= "Incapaz de localizar família com este ID";
$pgv_lang["unable_to_find_record"]		= "Incapaz de localizar registro com este ID";
$pgv_lang["title"]						= "Título";
$pgv_lang["living"]						= "Vivo";
$pgv_lang["private"]					= "Privado";
$pgv_lang["birth"]						= "Nascimento";
$pgv_lang["death"]						= "Falecimento";
$pgv_lang["descend_chart"]				= "Gráfico de descendência";
$pgv_lang["individual_list"]			= "Pessoas";
$pgv_lang["family_list"]				= "Famílias";
$pgv_lang["branch_list"]				= "Ramos";
$pgv_lang["source_list"]				= "Fontes";
$pgv_lang["shared_note_list"]			= "Notas partilhadas";
$pgv_lang["place_list"]					= "Locais";
$pgv_lang["place_list_aft"]				= "Locais abaixo de";
$pgv_lang["media_list"]					= "Mídias";
$pgv_lang["repo_list"]					= "Reposição";
$pgv_lang["search"]						= "Pesquisar";
$pgv_lang["clippings_cart"]				= "Extração de Dados";
$pgv_lang["print_preview"]				= "Simplificar página";
$pgv_lang["cancel_preview"]				= "Visualização normal";
$pgv_lang["change_lang"]				= "Trocar o Idioma";
$pgv_lang["language"]					= "Idioma";
$pgv_lang["print"]						= "Imprimir";
$pgv_lang["total_queries"]				= "Nº de consultas ao Banco de Dados: ";
$pgv_lang["total_privacy_checks"]		= "Nº de verificações de privacidade:";
$pgv_lang["back"]						= "Voltar";

//-- INDIVIDUAL FILE MESSAGES
$pgv_lang["aka"]						= "AKA('s) Também conhecido(s) como";
$pgv_lang["male"]						= "Homem";
$pgv_lang["males"]						= "Homens";
$pgv_lang["female"]						= "Fêmea";
$pgv_lang["females"]					= "Fêmeas";
$pgv_lang["temple"]						= "Templo SUD";
$pgv_lang["temple_code"]				= "Código de Templo SUD:";
$pgv_lang["status"]						= "Status";
$pgv_lang["source"]						= "Fonte";
$pgv_lang["text"]						= "Texto da Fonte:";
$pgv_lang["note"]						= "Nota";
$pgv_lang["NN"]							= "(Sobrenome desconhecido)";		// Family name
$pgv_lang["PN"]							= "(Nome desconhecido)";		// Given name
$pgv_lang["NNPN"]						= "(Nome e sobrenome desconhecidos)";		// Name
// $pgv_lang["NNhebrew"] 		use value from lang.en.php
// $pgv_lang["PNhebrew"] 		use value from lang.en.php
// $pgv_lang["NNPNhebrew"] 		use value from lang.en.php
// $pgv_lang["NNarabic"] 		use value from lang.en.php
// $pgv_lang["PNarabic"] 		use value from lang.en.php
// $pgv_lang["NNPNarabic"] 		use value from lang.en.php
// $pgv_lang["NNgreek"] 		use value from lang.en.php
// $pgv_lang["PNgreek"] 		use value from lang.en.php
// $pgv_lang["NNPNgreek"] 		use value from lang.en.php
// $pgv_lang["NNrussian"] 		use value from lang.en.php
// $pgv_lang["PNrussian"] 		use value from lang.en.php
// $pgv_lang["NNPNrussian"] 	use value from lang.en.php
// $pgv_lang["NNchinese"] 		use value from lang.en.php
// $pgv_lang["PNchinese"] 		use value from lang.en.php
// $pgv_lang["NNPNchinese"] 	use value from lang.en.php
// $pgv_lang["NNvietnamese"] 	use value from lang.en.php
// $pgv_lang["PNvietnamese"] 	use value from lang.en.php
// $pgv_lang["NNPNvietnamese"] 	use value from lang.en.php
// $pgv_lang["NNthai"] 			use value from lang.en.php
// $pgv_lang["PNthai"] 			use value from lang.en.php
// $pgv_lang["NNPNthai"] 		use value from lang.en.php
$pgv_lang["NN"]							= "(Sobrenome desconhecido)";		// Family name
$pgv_lang["PN"]							= "(Nome desconhecido)";		// Given name
$pgv_lang["NNPN"]						= "(Nome e sobrenome desconhecidos)";		// Name
$pgv_lang["unrecognized_code"]			= "Código GEDCOM Desconhecido";
$pgv_lang["unrecognized_code_msg"]		= "Isto é um erro, e nós gostaríamos de corrigí-lo. Por favor, informe esse erro para";
$pgv_lang["indi_info"]					= "Informação Pessoal";
$pgv_lang["pedigree_chart"]				= "Árvore Genealógica";
$pgv_lang["individual"]					= "Pessoa";
$pgv_lang["as_spouse"]					= "Família com Cônjuge";
$pgv_lang["privacy_error"]				= "Os detalhes desta pessoa são privados.";
$pgv_lang["more_information"]			= "Para maiores informações entre em contato com";
$pgv_lang["given_name"]					= "Prenome";
$pgv_lang["surname"]					= "Sobrenome";
$pgv_lang["sex"]						= "Sexo";
$pgv_lang["personal_details"]			= "Detalhes Pessoais";
$pgv_lang["personal_facts"]				= "Dados Pessoais e Detalhes";
$pgv_lang["type"]						= "Tipo";
$pgv_lang["parents"]					= "Pais";
$pgv_lang["gparents"]					= "Avós";
$pgv_lang["siblings"]					= "Irmãos";
$pgv_lang["father"]						= "Pai";
$pgv_lang["mother"]						= "Mãe";
$pgv_lang["parent"]						= "Pais";
$pgv_lang["parent_age"] 				= "Idade dos pais";
$pgv_lang["father_age"]					= "Idade do pai";
$pgv_lang["mother_age"]					= "Idade da mãe";
$pgv_lang["self"] 						= "Eu";
$pgv_lang["relatives"]					= "Parentes Próximos";
$pgv_lang["relatives_events"]			= "Eventos de parentes próximos";
$pgv_lang["historical_facts"]			= "Fatos históricos";
$pgv_lang["partner"] 					= "Consorte";
$pgv_lang["spouse"]						= "Cônjuge";
$pgv_lang["spouses"] 					= "Cônjuges";
$pgv_lang["surnames"]					= "Sobrenomes";
$pgv_lang["adopted"]					= "Adotado";
$pgv_lang["foster"]						= "Adotivo";
$pgv_lang["sealing"]					= "Selagem SUD";
$pgv_lang["challenged"]					= "Desafiado";
$pgv_lang["disproved"]					= "Refutado";
$pgv_lang["infant"]						= "Criança";
$pgv_lang["stillborn"]					= "Natimorto";
$pgv_lang["deceased"]					= "Falecido";
$pgv_lang["link_as_wife"]				= "Ligar esta pessoa como a Esposa de uma Família da árvore";
$pgv_lang["no_tab1"]					= "Não há nenhum Fato para essa pessoa.";
$pgv_lang["no_tab2"]					= "Não há nenhuma Nota para essa pessoa.";
$pgv_lang["no_tab3"]					= "Não há nenhuma Fonte para essa pessoa.";
$pgv_lang["no_tab4"]					= "Não há nenhuma Mídia para essa pessoa.";
$pgv_lang["no_tab5"]					= "Não há nenhum Parente Próximo para essa pessoa.";
$pgv_lang["no_tab6"]					= "Não há log de pesquisa para esta pessoa.";
$pgv_lang["show_fact_sources"]			= "Mostrar todas as fontes";
$pgv_lang["show_fact_notes"]			= "Mostrar todas as notas";

//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"]				= "Informações da Família";
$pgv_lang["family_group_info"]			= "Informações do Grupo Familiar";
$pgv_lang["husband"]					= "Marido";
$pgv_lang["wife"]						= "Esposa";
$pgv_lang["marriage"]					= "Casamento:";
$pgv_lang["lds_sealing"]				= "Selagem SUD:";
$pgv_lang["marriage_license"]			= "Licença Matrimonial:";
$pgv_lang["no_children"]				= "Sem Filhos";
$pgv_lang["known_child"]				= "1 filho";
$pgv_lang["known_children"]				= "filhos";
$pgv_lang["childless_family"]			= "Esta família não deixou descendentes";
$pgv_lang["parents_timeline"]			= "Exibir casal no gráfico Linha do Tempo";

//-- CLIPPINGS FILE MESSAGES
$pgv_lang["clip_cart"]					= "Carrinho de Recortes";
$pgv_lang["which_links"]				= "Quais os links desta família que você gostaria de adicionar?";
$pgv_lang["just_family"]				= "Adicione somente este registro desta família.";
$pgv_lang["parents_and_family"]			= "Adicione os registos dos pais desta família.";
$pgv_lang["parents_and_child"]			= "Adicione os registos dos pais e filhos desta família.";
$pgv_lang["parents_desc"]				= "Adicione os registos dos pais e todos descendentes desta família.";
$pgv_lang["continue"]					= "Continue Adicionando";
$pgv_lang["which_p_links"]				= "Quais links desta pessoa você deseja adicionar?";
$pgv_lang["just_person"]				= "Somente esta pessoa.";
$pgv_lang["person_parents_sibs"]		= "Adiciona esta pessoa, seus pais e irmãos.";
$pgv_lang["person_ancestors"]			= "Adicione esta pessoa e seus ancestrais diretos.";
$pgv_lang["person_ancestor_fams"]		= "Adiciona esta pessoa, seus ancestrais diretos e suas famílias.";
$pgv_lang["person_spouse"]				= "Adiciona esta pessoa, seu cônjuge e filhos.";
$pgv_lang["person_desc"]				= "Adiciona esta pessoa, seu cônjuge e todos os registros de descendentes.";
$pgv_lang["which_s_links"]				= "Que registos ligados a esta fonte devem ser adicionados?";
$pgv_lang["just_source"]				= "Adicionar apenas desta fonte.";
$pgv_lang["linked_source"]				= "Adicionar esta fonte e as famílias/pessoas ligadas a ele.";
$pgv_lang["person_private"]				= "Detalhes sobre esta pessoa são privados. Detalhes pessoais não serão incluídos.";
$pgv_lang["family_private"]				= "Detalhes sobre esta Família são privados. Detalhes de Família não serão Incluídos.";
$pgv_lang["media_private"] 				= "Detalhes sobre essa mídia são privados. Detalhes de mídia não serão incluídos.";
$pgv_lang["cart_is_empty"]				= "Seu carrinho de recortes está vazio.";
$pgv_lang["id"]							= "ID";
$pgv_lang["ID"]							= "ID";
$pgv_lang["name_description"]			= "Nome / Descrição";
$pgv_lang["remove"]						= "Remover";
$pgv_lang["empty_cart"]					= "Esvaziar o carrinho";
$pgv_lang["download_now"]				= "Fazer Download agora";
$pgv_lang["download_file"]				= "Download o arquivo #GLOBALS[whichFile]#";
$pgv_lang["indi_downloaded_from"]		= "Download desta Pessoa feito de:";
$pgv_lang["family_downloaded_from"]		= "Download desta Família feito de:";
$pgv_lang["source_downloaded_from"]		= "Download desta Fonte feito de:";
$pgv_lang["enter_person_generations"] 	= "Número de gerações:";
$pgv_lang["convertPath"]				= "Converter caminho da mídia";
$pgv_lang["convertSlashes"]				= "Converter separadores de pasta de mídia";
$pgv_lang["forwardSlashes"]				= "Barras : /";
$pgv_lang["backSlashes"]				= "Contrabarras : \\";

//-- PLACELIST FILE MESSAGES
$pgv_lang["connections"]				= "locais encontrados";
$pgv_lang["top_level"]					= "Países";
$pgv_lang["form"]						= "Locais são classificados da seguinte forma: ";
$pgv_lang["default_form"]				= "Cidade, Estado, País";
$pgv_lang["default_form_info"]			= "(Padrão)";
$pgv_lang["unknown"]					= "Desconhecido";
$pgv_lang["individuals"]				= "Pessoas";
$pgv_lang["view_records_in_place"]		= "Exibir os registos deste Local";
$pgv_lang["place_list2"]				= "Lista de Locais";
$pgv_lang["show_place_hierarchy"]		= "Exibir Hierarquia dos Locais";
$pgv_lang["show_place_list"]			= "Exibir lista de todos os Locais";
$pgv_lang["total_unic_places"]			= "Total Locais";

//-- MEDIALIST FILE MESSAGES
$pgv_lang["external_objects"]			= "Objetos externos";
$pgv_lang["multi_title"]				= "Titulo da Mídia";
$pgv_lang["media_found"]				= "Mídias encontradas";
$pgv_lang["view_person"]				= "Exibir a Pessoa";
$pgv_lang["view_family"]				= "Exibir a Família";
$pgv_lang["view_source"]				= "Exibir a Fonte";
$pgv_lang["view_object"]				= "Exibir Objeto";
$pgv_lang["first_page"]					= "Primeira página";
$pgv_lang["previous_page"]				= "Anterior página";
$pgv_lang["next_page"]					= "Próxima página";
$pgv_lang["last_page"]					= "Última página";
$pgv_lang["next_image"]					= "Imagem seguinte";
$pgv_lang["file_not_found"]				= "Arquivo não encontrado.";
$pgv_lang["medialist_show"]				= "Exibir";
$pgv_lang["per_page"]					= "mídia por página";
$pgv_lang["media_format"]				= "Formato da Mídia";
$pgv_lang["image_size"]					= "Dimensão da Imagem";
$pgv_lang["media_id"]					= "ID da Mídia";
$pgv_lang["invalid_id"]					= "Esta ID não existe neste GEDCOM.";
$pgv_lang["record_updated"]				= "Registro #pid# atualizado com sucesso.";
$pgv_lang["record_not_updated"]			= "Não foi possível atualizar o registro #pid#.";
$pgv_lang["record_removed"]				= "Registro #xref# foi excluído deste GEDCOM.";
$pgv_lang["record_not_removed"]			= "Não foi possível excluir o registro #xref# do GEDCOM.";
$pgv_lang["record_added"]				= "Registro #xref# adicionado com sucesso ao GEDCOM.";
$pgv_lang["record_not_added"]			= "Registro #xref# não pôde ser adicionado ao GEDCOM.";

//-- SEARCH FILE MESSAGES
$pgv_lang["soundex_search"]				= "Pesquisa Fonética de Nomes";
$pgv_lang["sources"]					= "Fontes";
$pgv_lang["shared_notes"]				= "Notas partilhadas";
$pgv_lang["lastname_search"]			= "Sobrenome";
$pgv_lang["search_place"]				= "Local";
$pgv_lang["search_year"]				= "Ano";
$pgv_lang["no_results"]					= "Nenhum resultado encontrado.";
$pgv_lang["search_soundex"]				= "Pesquisa Fonética";
$pgv_lang["search_replace"]				= "Pesquisar e Substituir";
$pgv_lang["search_sources"]				= "Fontes";
$pgv_lang["search_shared_notes"]		= "Notas partilhadas";
$pgv_lang["search_more_chars"]			= "Informe mais de carácter";
$pgv_lang["search_soundextype"]			= "Tipo fonético:";
$pgv_lang["search_russell"]				= "Simple";
$pgv_lang["search_tagfilter"]			= "Excluir Filtro";
$pgv_lang["search_tagfon"]				= "Excluir dados não genealógicos";
$pgv_lang["search_tagfoff"]				= "Desligado";
$pgv_lang["associate"]					= "testemunha";
$pgv_lang["search_record"]				= "Registro completo";
$pgv_lang["search_to"]					= "até";

//-- SOURCELIST FILE MESSAGES
$pgv_lang["titles_found"]				= "Títulos";
$pgv_lang["find_source"]				= "Procurar pela Fonte";

//-- REPOLIST FILE MESSAGES
$pgv_lang["repository"] 				= "Repositório";
$pgv_lang["repos_found"]				= "Reposições encontradas";
$pgv_lang["find_repository"]			= "Procurar por Reposição";
$pgv_lang["total_repositories"]			= "Total de Reposições";
$pgv_lang["confirm_delete_repo"]		= "Confirma a exclusão desta Reposição?";

//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]				= "Informações da Fonte";
$pgv_lang["people"]						= "Pessoas";
$pgv_lang["families"]					= "Famílias";
$pgv_lang["total_sources"]				= "Total de Fontes";

//-- SHARED NOTE FILE MESSAGES
$pgv_lang["shared_note"]				= "Nota partilhada";
$pgv_lang["shared_notes_found"]			= "Notas partilhadas encontrados";
$pgv_lang["find_shared_note"]			= "Buscar nota partilhada";
$pgv_lang["shared_note_info"]			= "Informações sobre nota partilhada";
$pgv_lang["total_shared_notes"]			= "Total de notas partilhadas";

//-- BUILDINDEX FILE MESSAGES
$pgv_lang["invalid_gedformat"]			= "Formato de arquivo GEDCOM 5.5 inválido";
$pgv_lang["exec_time"]					= "Tempo total de execução";
$pgv_lang["changes_present"]			= "Esta árvore (GEDCOM) tem alterações pendentes, que serão aceitas automaticamente, caso a importação prossiga. Revise as alterações pendentes antes de continuar com a importação.";
$pgv_lang["sec"]						= "seg.";

//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$pgv_lang["total_fams"]					= "Total Famílias";
$pgv_lang["total_indis"]				= "Total Pessoas";
$pgv_lang["notes"]						= "Notas";
$pgv_lang["ssourcess"]					= "Fontes";
$pgv_lang["media"]						= "Mídia";
$pgv_lang["name_contains"]				= "Nome Contendo:";
$pgv_lang["filter"]						= "Pesquisar";
$pgv_lang["apply_filter"]				= "Aplicar filtro";
$pgv_lang["find_individual"]			= "Procurar ID de Pessoa";
$pgv_lang["find_familyid"]				= "Procurar ID de Família";
$pgv_lang["find_sourceid"]				= "Procurar ID de Fonte";
$pgv_lang["find_specialchar"]			= "Procura por Caracteres Especiais";
$pgv_lang["magnify"]					= "Ampliar";
$pgv_lang["skip_surnames"]				= "Mostre Lista de Pessoas";
$pgv_lang["show_surnames"]				= "Exibir Lista de Sobrenomes";
$pgv_lang["skip_marnms"]				= "Excluir nomes de casados";
$pgv_lang["show_marnms"]				= "Incluir nomes de casados";
$pgv_lang["all"]						= "TODOS";
$pgv_lang["hidden"]						= "Secreto";
$pgv_lang["confidential"]				= "Confidencial";
$pgv_lang["alpha_index"]				= "Índice Alfabético";
$pgv_lang["name_list"]					= "Lista de Nomes";
$pgv_lang["firstname_alpha_index"]		= "Índice Alfabético de Nomes";
$pgv_lang["roots"]		 				= "Raízes";
$pgv_lang["leaves"] 					= "Folhas";
$pgv_lang["widow"] 						= "Viúva";
$pgv_lang["widower"] 					= "Viúvo";
$pgv_lang["show_parents"] 				= "Mostrar pais";

//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]						= "Idade";
$pgv_lang["husb_age"]					= "Idade do marido";
$pgv_lang["wife_age"]					= "Idade da mulher";
$pgv_lang["year1"]						= "ano";
$pgv_lang["years2"]						= "anos";	// For Polish 2,3,4 or 22,23,24 or 32,33,34 etc.
$pgv_lang["years"]						= "anos";
$pgv_lang["month1"]						= "mês";
$pgv_lang["months"]						= "meses";
$pgv_lang["week1"]						= "semana";
$pgv_lang["weeks"]						= "semanas";
$pgv_lang["day1"]						= "dia";
$pgv_lang["days"]						= "dias";
$pgv_lang["after_death"]				= "após morte";
$pgv_lang["at_death_day"]  				= "na data da morte";
$pgv_lang["timeline_title"]				= "Linha do Tempo";
$pgv_lang["timeline_chart"]				= "Linha do Tempo";
$pgv_lang["remove_person"]				= "Remover Pessoa";
$pgv_lang["show_age"]					= "Exibir Marcador de Idade";
$pgv_lang["add_another"]				= "Adicione uma outra pessoa ao gráfico";
$pgv_lang["find_id"]					= "Procurar ID";
$pgv_lang["show"]						= "Exibir";
$pgv_lang["year"]						= "Ano:";
$pgv_lang["zoom_in"]					= "Mais Zoom";
$pgv_lang["zoom_out"]					= "Menos Zoom";
$pgv_lang["timeline_beginYear"] 		= "Ano de Início";
$pgv_lang["timeline_endYear"] 			= "Ano de Término";
$pgv_lang["timeline_scrollSpeed"] 		= "Velocidade";
$pgv_lang["timeline_controls"] 			= "Controles da cronologia";
$pgv_lang["include_family"] 			= "Incluem família imediata";
$pgv_lang["lifespan_chart"] 			= "Gráfico tempo de vida";
$pgv_lang["serverTime"]					= "Hora do servidor";
$pgv_lang["localTime"]					= "Horário local";

// calendar conversion options
$pgv_lang["cal_none"] 					= "Nenhuma conversão calendário";
$pgv_lang["cal_gregorian"]				= "Gregoriano";
$pgv_lang["cal_julian"]					= "Juliano";
$pgv_lang["cal_french"]					= "Francês";
$pgv_lang["cal_jewish"]					= "Judeu";
$pgv_lang["cal_hebrew"]					= "Hebreu";
$pgv_lang["cal_jewish_and_gregorian"]	= "Judeu e Gregoriano";
$pgv_lang["cal_hebrew_and_gregorian"]	= "Hebreu e Gregoriano";
$pgv_lang["cal_hijri"]					= "Hijri";
$pgv_lang["cal_arabic"]   				= "Árabe";

// some religious dates
$pgv_lang["easter"] 					= "Páscoa";
$pgv_lang["ascension"]  				= "Ascensão";
$pgv_lang["pentecost"]  				= "Pentecostes";
$pgv_lang["assumption"] 				= "Assunção";
$pgv_lang["all_saints"] 				= "Todos os Santos";
$pgv_lang["christmas"]  				= "Natal";

// am/pm suffixes for 12 hour clocks
$pgv_lang["a.m."] 						= "am";
$pgv_lang["p.m."] 						= "pm";
$pgv_lang["noon"] 						= "m";
$pgv_lang["midn"] 						= "mn";

//-- MONTH NAMES
$pgv_lang["jan"]						= "Janeiro";
$pgv_lang["feb"]						= "Fevereiro";
$pgv_lang["mar"]						= "Março";
$pgv_lang["apr"]						= "Abril";
$pgv_lang["may"]						= "Maio";
$pgv_lang["jun"]						= "Junho";
$pgv_lang["jul"]						= "Julho";
$pgv_lang["aug"]						= "Agosto";
$pgv_lang["sep"]						= "Setembro";
$pgv_lang["oct"]						= "Outubro";
$pgv_lang["nov"]						= "Novembro";
$pgv_lang["dec"]						= "Dezembro";

// $pgv_lang["vend"]			use value from lang.en.php
// $pgv_lang["brum"]			use value from lang.en.php
// $pgv_lang["frim"]			use value from lang.en.php
// $pgv_lang["nivo"]			use value from lang.en.php
// $pgv_lang["pluv"]			use value from lang.en.php
// $pgv_lang["vent"]			use value from lang.en.php
// $pgv_lang["germ"]			use value from lang.en.php
// $pgv_lang["flor"]			use value from lang.en.php
// $pgv_lang["prai"]			use value from lang.en.php
// $pgv_lang["mess"]			use value from lang.en.php
// $pgv_lang["ther"]			use value from lang.en.php
// $pgv_lang["fruc"]			use value from lang.en.php
// $pgv_lang["comp"]			use value from lang.en.php

// $pgv_lang["tsh"]				use value from lang.en.php
// $pgv_lang["csh"]				use value from lang.en.php
// $pgv_lang["ksl"]				use value from lang.en.php
// $pgv_lang["tvt"]				use value from lang.en.php
// $pgv_lang["shv"]				use value from lang.en.php
// $pgv_lang["adr"]				use value from lang.en.php
// $pgv_lang["adr_leap_year"]	use value from lang.en.php
// $pgv_lang["ads"]				use value from lang.en.php
// $pgv_lang["nsn"]				use value from lang.en.php
// $pgv_lang["iyr"]				use value from lang.en.php
// $pgv_lang["svn"]				use value from lang.en.php
// $pgv_lang["tmz"]				use value from lang.en.php
// $pgv_lang["aav"]				use value from lang.en.php
// $pgv_lang["ell"]				use value from lang.en.php

// $pgv_lang["muhar"]			use value from lang.en.php
// $pgv_lang["safar"]			use value from lang.en.php
// $pgv_lang["rabia"]			use value from lang.en.php
// $pgv_lang["rabit"]			use value from lang.en.php
// $pgv_lang["jumaa"]			use value from lang.en.php
// $pgv_lang["jumat"]			use value from lang.en.php
// $pgv_lang["rajab"]			use value from lang.en.php
// $pgv_lang["shaab"]			use value from lang.en.php
// $pgv_lang["ramad"]			use value from lang.en.php
// $pgv_lang["shaww"]			use value from lang.en.php
// $pgv_lang["dhuaq"]			use value from lang.en.php
// $pgv_lang["dhuah"]			use value from lang.en.php

$pgv_lang["b.c."] 						= "aC";

$pgv_lang["abt"]						= "ao redor de";
$pgv_lang["aft"]						= "após";
$pgv_lang["and"]						= "e";
$pgv_lang["bef"]						= "antes de";
$pgv_lang["bet"]						= "entre";
$pgv_lang["cal"]						= "calculado";
$pgv_lang["est"]						= "estimado em";
$pgv_lang["from"]						= "de";
$pgv_lang["int"]						= "interpretado";
$pgv_lang["to"]							= "até";
$pgv_lang["cir"]						= "aproximadamente";
$pgv_lang["apx"]						= "aprox.";

//-- Admin File Messages
$pgv_lang["email_invalid"]				= "Endereço de email invalido.";
$pgv_lang["password_mismatch"]			= "Senhas não conferem.";
$pgv_lang["enter_username"]				= "Informe o nome do Membro.";
$pgv_lang["enter_password"]				= "Informe sua senha.";
$pgv_lang["save"]						= "Gravar";
$pgv_lang["saveandgo"]					= "Salvar e ir para novo recorde";
$pgv_lang["delete"]						= "Excluir";
$pgv_lang["edit"]						= "Editar";
$pgv_lang["no_login"]					= "Incapaz de autenticar o Membro.";
$pgv_lang["basic_realm"]				= "Sistema de Autenticação do PhpGedView";
$pgv_lang["basic_auth_failure"]			= "Para aceder este recurso é necessário indentificar-se, informando Membro/senha.";
$pgv_lang["basic_auth"]					= "Autenticação Básica";
$pgv_lang["digest_auth"]				= "Autenticação Digest";
$pgv_lang["no_auth_needed"]				= "Não usar Autenticação";
$pgv_lang["file_not_exists"]			= "O nome do arquivo informado não existe.";
$pgv_lang["research_assistant"]			= "Assistente de Pesquisa";
$pgv_lang["utf8_to_ansi"]				= "Converter do UTF-8 para ANSI (ISO 8859-1)";
$pgv_lang["media_linked"]				= "Esta Mídia esta ligada a:";
$pgv_lang["media_not_linked"]			= "Esta Mídia não está ligada a nenhum registro da árvore (GEDCOM).";
$pgv_lang["media_dir_1"]				= "Este objeto de mídia está localizado em um servidor externo";
$pgv_lang["media_dir_2"]				= "Este objeto de mídia está no diretório padrão de mídia";
$pgv_lang["media_dir_3"]				= "Este objeto de mídia está no diretório protegido de mídia";
$pgv_lang["thumb_dir_1"]				= "A miniatura está localizada em um servidor externo";
$pgv_lang["thumb_dir_2"]				= "A miniatura está no diretório padrão de mídia";
$pgv_lang["thumb_dir_3"]				= "A miniatura está no diretório protegido de mídia";
$pgv_lang["moveto_2"]					= "Mova para o diretório protegido";
$pgv_lang["moveto_3"]					= "Mova para o diretório padrão";
$pgv_lang["move_standard"]				= "Move ao padrão";
$pgv_lang["move_protected"]				= "Mover para protegido";
$pgv_lang["move_mediadirs"]				= "Mover diretórios mídia";
$pgv_lang["setperms"]					= "Definir permissões mídia";
$pgv_lang["setperms_fix"]				= "Corretas permissões de leitura/gravação/execução";
$pgv_lang["setperms_success"]			= "Permissões foram definidas";
$pgv_lang["setperms_failure"]			= "Permissões não foram definidas";
$pgv_lang["setperms_time_exceeded"]		= "O limite de tempo de execução foi alcançado. Tente o comando novamente em menor diretório.";
$pgv_lang["move_time_exceeded"]			= "O limite de tempo de execução foi alcançado. Tente o comando novamente para mover o resto dos arquivos.";
$pgv_lang["media_firewall_rootdir_no_exist"]			= "O diretório raiz do firewall de mídia que você solicitou não existe. Você deve criá-lo primeiro.";
$pgv_lang["media_firewall_protected_dir_no_exist"]		= "O diretório protegido não poderia ser criado no diretório raiz do firewall de mídia. Por favor, crie este diretório e torná-lo globalmente graváveis.";
$pgv_lang["media_firewall_protected_dir_not_writable"]	= "O diretório protegido no diretório raiz do firewall de mídia não é gravável mundo. ";
$pgv_lang["media_firewall_invalid_dir"]	= "Erro: O Firewall de mídia foi lançada a partir de um diretório diferente do diretório de mídia.";

//-- Relationship chart messages
$pgv_lang["view_fam_nav_details"]		= "Ver Detalhes para ...";
$pgv_lang["view_fam_nav_notes"]			= "Ver Notas para ...";
$pgv_lang["view_fam_nav_sources"]		= "Ver Fontes para ...";
$pgv_lang["view_fam_nav_media"]			= "Ver Mídia para ...";
$pgv_lang["view_fam_nav_album"]			= "Ver Álbum para ...";
$pgv_lang["view_fam_nav_relatives"]		= "Ver Parentes de ...";
$pgv_lang["view_fam_nav_tree"]			= "Ver Árvore para ...";
$pgv_lang["view_fam_nav_research"]		= "Ver Pesquisa para ...";
$pgv_lang["view_fam_nav_map"]			= "Ver Mapa para ...";
$pgv_lang["view_fam_nav_spare"]			= "Ver Informação de reposição para ...";
$pgv_lang["navigator"]					= "Navegador";
$pgv_lang["fam_navigator"]				= "Navegador da família";

$pgv_lang["relationship_great"]			= "Bis";
$pgv_lang["relationship_chart"]			= "Relacionamentos";
$pgv_lang["person1"]					= "Pessoa 1";
$pgv_lang["person2"]					= "Pessoa 2";
$pgv_lang["no_link_found"]				= "Nenhum relacionamento entre estas duas pessoas foi localizado.";
$pgv_lang["no_other_link_found"]		= "Nenhum outro relacionamento entre estas duas pessoas foi localizado.";
$pgv_lang["sibling"]					= "Irmãos";
$pgv_lang["follow_spouse"]				= "Verificar relacionamentos por casamento";
$pgv_lang["timeout_error"]				= "O tempo destinado à pesquisa encerrou antes de encontrar um relacionamento.";
$pgv_lang["grandchild"]					= "Neto";
$pgv_lang["grandson"]					= "Neto";
$pgv_lang["granddaughter"]				= "Neta";
$pgv_lang["greatgrandchild"]			= "Bisneto/bisneta";
$pgv_lang["greatgrandson"]				= "Bisneto";
$pgv_lang["greatgranddaughter"]			= "Bisneta";
$pgv_lang["brother"]					= "Irmão";
$pgv_lang["sister"]						= "Irmã";
$pgv_lang["aunt"]						= "Tia";
$pgv_lang["uncle"]						= "Tio";
$pgv_lang["nephew"]						= "Sobrinho";
$pgv_lang["niece"]						= "Sobrinha";
$pgv_lang["firstcousin"]				= "Primo";
$pgv_lang["femalecousin"]				= "Prima";
$pgv_lang["malecousin"]					= "Primo";
$pgv_lang["relationship_to_me"]			= "Relacionamento Comigo";
$pgv_lang["rela_husb"]					= "Relação com o marido";
$pgv_lang["rela_wife"]					= "Relação com a esposa";
$pgv_lang["next_path"]					= "Localizar novo caminho ";
$pgv_lang["show_path"]					= "Exibir caminho";
$pgv_lang["line_up_generations"]		= "Alinhar as mesmas generações";
$pgv_lang["oldest_top"]					= "Exibir mais velho no topo";

// %1\$s replaced by first person, %2\$s by the relationship and %3\$s by the second person.
$pgv_lang["relationship_male_1_is_the_2_of_3"] = "%1\$s é o %2\$s de %3\$s.";
$pgv_lang["relationship_female_1_is_the_2_of_3"] = "%1\$s é o %2\$s de %3\$s.";

$pgv_lang["mother_in_law"]				= "Sogra";
$pgv_lang["father_in_law"]				= "Sogro";
$pgv_lang["brother_in_law"]				= "Cunhado";
$pgv_lang["sister_in_law"]				= "Cunhada";
$pgv_lang["brothers_wife"]				= "Cunhada"; // brother's wife
$pgv_lang["son_in_law"]					= "genro";
$pgv_lang["daughter_in_law"]			= "nora";
$pgv_lang["uncle_in_law"]				= "Tio-de-lei";
$pgv_lang["aunt_in_law"]				= "Tia-de-lei";
$pgv_lang["cousin_in_law"]				= "Primo-de-lei";
$pgv_lang["m_cousin_in_law"]			= "Primo-de-lei";
$pgv_lang["f_cousin_in_law"]			= "Prima-de-lei";
$pgv_lang["step_son"]					= "Co-filho";
$pgv_lang["step_daughter"]				= "Co-filha";

// the bosa_brothers_offspring name is used for fraternal nephews and nieces - the names below can be extended to any number
// of generations just by adding more translations.
// 1st generation
$pgv_lang["bosa_brothers_offspring_2"]	= "sobrinho";            // brother's son
$pgv_lang["bosa_brothers_offspring_3"]	= "sobrinha";            // brother's daughter
// 2nd generation
$pgv_lang["bosa_brothers_offspring_4"]	= "sobrinho";       // brother's son's son
$pgv_lang["bosa_brothers_offspring_5"]	= "sobrinha";        // brother's son's daughter
$pgv_lang["bosa_brothers_offspring_6"]	= "sobrinho";       // brother's daughter's son
$pgv_lang["bosa_brothers_offspring_7"]	= "sobrinha";        // brother's daughter's daughter
// for the general case of offspring of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_brothers_son"]	  		= "%2\$d x sobrinho";
$pgv_lang["n_x_brothers_daughter"] 		= "%2\$d x sobrinha";
// the bosa_sisters_offspring name is used for sisters nephews and nieces - the names below can be extended to any number
// of generations just by adding more translations.
// 1st generation
$pgv_lang["bosa_sisters_offspring_2"]	= "sobrinho";             // sister's son
$pgv_lang["bosa_sisters_offspring_3"]	= "sobrinha";             // sister's daughter
// 2nd generation
$pgv_lang["bosa_sisters_offspring_4"]	= "sobrinho";       // sister's son's son
$pgv_lang["bosa_sisters_offspring_5"]	= "sobrinha";        // sister's son's daughter
$pgv_lang["bosa_sisters_offspring_6"]	= "sobrinho";       // sister's daughter's son
$pgv_lang["bosa_sisters_offspring_7"]	= "sobrinha";        // sister's daughter's daughter
// for the general case of offspring of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_sisters_son"]	  		= "%2\$d x sobrinho";
$pgv_lang["n_x_sisters_daughter"] 		= "%2\$d x sobrinha";

// the bosa name is used for offspring - the names below can be extended to any number
// of generations just by adding more translations.
// 1st generation
$pgv_lang["bosa_2"] 					= "filho";		// son
$pgv_lang["bosa_3"] 					= "filha";		// daughter
// 2nd generation
$pgv_lang["bosa_4"] 					= "neto";		// son's son
$pgv_lang["bosa_5"] 					= "neta";		// son's daughter
$pgv_lang["bosa_6"] 					= "neto";		// daughter's son
$pgv_lang["bosa_7"] 					= "neta";		// daughter's daughter
// 3rd generation
$pgv_lang["bosa_8"] 					= "bis-neto";   // son's son's son
$pgv_lang["bosa_9"] 					= "bis-neta";   // son's son's daughter
$pgv_lang["bosa_10"] 					= "bis-neto";	// son's daughters son
$pgv_lang["bosa_11"] 					= "bis-neta";   // son's daughters daughter
$pgv_lang["bosa_12"] 					= "bis-neto";   // daughter's son's son
$pgv_lang["bosa_13"] 					= "bis-neta";   // daughter's son's daughter
$pgv_lang["bosa_14"] 					= "bis-neto";   // daughter's daughters son
$pgv_lang["bosa_15"] 					= "bis-neta";   // daughter's daughters daughter
// for the general case of offspring of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_grandson_from_son"]				= "%3\$d x bis-neto";
$pgv_lang["n_x_granddaughter_from_son"]			= "%3\$d x bis-neta";
$pgv_lang["n_x_grandson_from_daughter"]			= "%3\$d x bis-neto";
$pgv_lang["n_x_granddaughter_from_daughter"]	= "%3\$d x bis-neta";

// the sosa_uncle name is used for uncles - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and uncles
// 1st generation
$pgv_lang["sosa_uncle_2"] 				= "tio";		// fathers brother
$pgv_lang["sosa_uncle_3"] 				= "tio";		// mothers brother
// 2nd generation
$pgv_lang["sosa_uncle_4"] 				= "tio-avô";	// fathers's fathers brother
$pgv_lang["sosa_uncle_5"] 				= "tio-avô";	// fathers mothers brother
$pgv_lang["sosa_uncle_6"] 				= "tio-avô";	// mothers fathers brother
$pgv_lang["sosa_uncle_7"] 				= "tio-avô";	// mothers mothers brother
// for the general case of uncles of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_uncle"]			= "%2\$d x tio-avô";
$pgv_lang["n_x_maternal_uncle"]			= "%2\$d x tio-avô";

// the sosa_aunt name is used for aunts - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and aunts
// 1st generation
$pgv_lang["sosa_aunt_2"] 				= "tia";		// fathers sister
$pgv_lang["sosa_aunt_3"] 				= "tia";		// mothers sister
// 2nd generation
$pgv_lang["sosa_aunt_4"] 				= "tia-avó";	// fathers's fathers sister
$pgv_lang["sosa_aunt_5"] 				= "tia-avó";	// fathers mothers sister
$pgv_lang["sosa_aunt_6"] 				= "tia-avó";	// mothers fathers sister
$pgv_lang["sosa_aunt_7"] 				= "tia-avó";	// mothers mothers sister
// for the general case of aunts of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_aunt"]			= "%2\$d x tia-avó";
$pgv_lang["n_x_maternal_aunt"]			= "%2\$d x tia-avó";

// the sosa_uncle name is used for uncles(by marriage) - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and uncles
// 1st generation
$pgv_lang["sosa_uncle_bm_2"]			= "tio";		// fathers brother
$pgv_lang["sosa_uncle_bm_3"]			= "tio";		// mothers brother
// 2nd generation
$pgv_lang["sosa_uncle_bm_4"]			= "tio-avô";	// fathers's fathers brother
$pgv_lang["sosa_uncle_bm_5"]			= "tio-avô";	// fathers mothers brother
$pgv_lang["sosa_uncle_bm_6"]			= "tio-avô";	// mothers fathers brother
$pgv_lang["sosa_uncle_bm_7"]			= "tio-avô";	// mothers mothers brother
// for the general case of uncles of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_uncle_bm"]		= "%2\$d x tio-avô";
$pgv_lang["n_x_maternal_uncle_bm"]		= "%2\$d x tio-avô";

// the sosa_aunt name is used for aunts (by marriage)- the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and aunts
// 1st generation
$pgv_lang["sosa_aunt_bm_2"]				= "tia";		// fathers sister
$pgv_lang["sosa_aunt_bm_3"]				= "tia";		// mothers sister
// 2nd generation
$pgv_lang["sosa_aunt_bm_4"]				= "tia-avó";	// fathers's fathers sister
$pgv_lang["sosa_aunt_bm_5"]				= "tia-avó";	// fathers mothers sister
$pgv_lang["sosa_aunt_bm_6"]				= "tia-avó";	// mothers fathers sister
$pgv_lang["sosa_aunt_bm_7"]				= "tia-avó";	// mothers mothers sister
// for the general case of aunts of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_aunt_bm"]		= "%2\$d x tia-avó";
$pgv_lang["n_x_maternal_aunt_bm"]		= "%2\$d x tia-avó";

// if a specific cousin relationship cannot be represented in a language translate as "";
$pgv_lang["male_cousin_1"]				= "primo";
$pgv_lang["male_cousin_2"]				= "primo do 2º gravi";
$pgv_lang["male_cousin_3"]				= "primo do 3º gravi";
$pgv_lang["male_cousin_4"]				= "primo do 4º gravi";
$pgv_lang["male_cousin_5"]				= "primo do 5º gravi";
$pgv_lang["male_cousin_6"]				= "primo do 6º gravi";
$pgv_lang["male_cousin_7"]				= "primo do 7º gravi";
$pgv_lang["male_cousin_8"]				= "primo do 8º gravi";
$pgv_lang["male_cousin_9"]				= "primo do 9º gravi";
$pgv_lang["male_cousin_10"]				= "primo do 10º gravi";
$pgv_lang["male_cousin_11"]				= "primo do 11º gravi";
$pgv_lang["male_cousin_12"]				= "primo do 12º gravi";
$pgv_lang["male_cousin_13"]				= "primo do 13º gravi";
$pgv_lang["male_cousin_14"]				= "primo do 14º gravi";
$pgv_lang["male_cousin_15"]				= "primo do 15º gravi";
$pgv_lang["male_cousin_16"]				= "primo do 16º gravi";
$pgv_lang["male_cousin_17"]				= "primo do 17º gravi";
$pgv_lang["male_cousin_18"]				= "primo do 18º gravi";
$pgv_lang["male_cousin_19"]				= "primo do 19º gravi";
$pgv_lang["male_cousin_20"]				= "primo do 20º gravi";
$pgv_lang["male_cousin_n"]				= "primo do %dº gravi";
$pgv_lang["female_cousin_1"]			= "prima";
$pgv_lang["female_cousin_2"]			= "prima do 2º gravi";
$pgv_lang["female_cousin_3"]			= "prima do 3º gravi";
$pgv_lang["female_cousin_4"]			= "prima do 4º gravi";
$pgv_lang["female_cousin_5"]			= "prima do 5º gravi";
$pgv_lang["female_cousin_6"]			= "prima do 6º gravi";
$pgv_lang["female_cousin_7"]			= "prima do 7º gravi";
$pgv_lang["female_cousin_8"]			= "prima do 8º gravi";
$pgv_lang["female_cousin_9"]			= "prima do 9º gravi";
$pgv_lang["female_cousin_10"]			= "prima do 10º gravi";
$pgv_lang["female_cousin_11"]			= "prima do 11º gravi";
$pgv_lang["female_cousin_12"]			= "prima do 12º gravi";
$pgv_lang["female_cousin_13"]			= "prima do 13º gravi";
$pgv_lang["female_cousin_14"]			= "prima do 14º gravi";
$pgv_lang["female_cousin_15"]			= "prima do 15º gravi";
$pgv_lang["female_cousin_16"]			= "prima do 16º gravi";
$pgv_lang["female_cousin_17"]			= "prima do 17º gravi";
$pgv_lang["female_cousin_18"]			= "prima do 18º gravi";
$pgv_lang["female_cousin_19"]			= "prima do 19º gravi";
$pgv_lang["female_cousin_20"]			= "prima do 20º gravi";
$pgv_lang["female_cousin_n"]			= "prima do %dº gravi";

// Only referenced from english specific functions
$pgv_lang["removed_ascending_1"]		= "";
$pgv_lang["removed_ascending_2"]		= "";
$pgv_lang["removed_ascending_3"]		= "";
$pgv_lang["removed_ascending_4"]		= "";
$pgv_lang["removed_ascending_5"]		= "";
$pgv_lang["removed_ascending_6"]		= "";
$pgv_lang["removed_ascending_7"]		= "";
$pgv_lang["removed_ascending_8"]		= "";
$pgv_lang["removed_ascending_9"]		= "";
$pgv_lang["removed_ascending_10"]		= "";
$pgv_lang["removed_ascending_11"]		= "";
$pgv_lang["removed_ascending_12"]		= "";
$pgv_lang["removed_ascending_13"]		= "";
$pgv_lang["removed_ascending_14"]		= "";
$pgv_lang["removed_ascending_15"]		= "";
$pgv_lang["removed_ascending_16"]		= "";
$pgv_lang["removed_ascending_17"]		= "";
$pgv_lang["removed_ascending_18"]		= "";
$pgv_lang["removed_ascending_19"]		= "";
$pgv_lang["removed_ascending_20"]		= "";
$pgv_lang["removed_descending_1"]		= "";
$pgv_lang["removed_descending_2"]		= "";
$pgv_lang["removed_descending_3"]		= "";
$pgv_lang["removed_descending_4"]		= "";
$pgv_lang["removed_descending_5"]		= "";
$pgv_lang["removed_descending_6"]		= "";
$pgv_lang["removed_descending_7"]		= "";
$pgv_lang["removed_descending_8"]		= "";
$pgv_lang["removed_descending_9"]		= "";
$pgv_lang["removed_descending_10"]		= "";
$pgv_lang["removed_descending_11"]		= "";
$pgv_lang["removed_descending_12"]		= "";
$pgv_lang["removed_descending_13"]		= "";
$pgv_lang["removed_descending_14"]		= "";
$pgv_lang["removed_descending_15"]		= "";
$pgv_lang["removed_descending_16"]		= "";
$pgv_lang["removed_descending_17"]		= "";
$pgv_lang["removed_descending_18"]		= "";
$pgv_lang["removed_descending_19"]		= "";
$pgv_lang["removed_descending_20"]		= "";

//-- GEDCOM edit utility
$pgv_lang["check_delete"]				= "Confirma a exclusão deste fato do arquivo GEDCOM?";
$pgv_lang["access_denied"]				= "<b>Acesso Negado</b><br />Você não tem acesso a este recurso.";
$pgv_lang["changes_exist"]				= "Foram feitas alterações neste arquivo GEDCOM.";
$pgv_lang["find_place"]					= "Procurar Local";
$pgv_lang["close_window"]				= "Fechar Janela";
$pgv_lang["close_window_without_refresh"]	= "Fechar Janela sem Recarregar";
$pgv_lang["place_contains"]				= "Locais contendo:";
$pgv_lang["add"]						= "Adicionar";
$pgv_lang["custom_event"]				= "Configurar Evento";
$pgv_lang["delete_person"]				= "Excluir esta Pessoa";
$pgv_lang["confirm_delete_person"]		= "Confirma exclusão desta pessoa do arquivo GEDCOM?";
$pgv_lang["find_media"]					= "Localizar Mídia";
$pgv_lang["set_link"]					= "Preparar Link";
$pgv_lang["delete_source"]				= "Excluir esta Fonte";
$pgv_lang["delete_shared_note"]			= "Apagar esta nota partilhada";
$pgv_lang["confirm_delete_source"]		= "Confirma exclusão desta fonte do arquivo GEDCOM?";
$pgv_lang["confirm_delete_shared_note"]	= "Tem certeza de que quer apagar esta nota partilhada?";
$pgv_lang["find_family"]				= "Pesquisar Família";
$pgv_lang["find_fam_list"]				= "Pesquisar lista de Famílias";
$pgv_lang["edit_name"]					= "Alterar Nome";
$pgv_lang["delete_name"]				= "Excluir Nome";
$pgv_lang["select_date"]				= "Selecionar uma data";
$pgv_lang["user_cannot_edit"]			= "Este Membro não tem permissão para edição do GEDCOM.";
$pgv_lang["gedcom_editing_disabled"]	= "Edição deste GEDCOM foi desabilitada pelo administrador do sistema.";
$pgv_lang["privacy_not_granted"]		= "Você não tem acesso para";
$pgv_lang["privacy_prevented_editing"]	= "As configurações de privacidade impedem você de alterar esse registro.";
$pgv_lang["ged_noshow"]					= "Esta página foi desabiltada pelo administrador.";

//-- calendar.php messages
$pgv_lang["bdm"]						= "Nascimentos, Falecimentos e Casamentos";
$pgv_lang["on_this_day"]				= "Este Dia em nossa História ...";
$pgv_lang["in_this_month"]				= "Este Mês em nossa História ...";
$pgv_lang["in_this_year"]				= "Este Ano em nossa História ...";
$pgv_lang["year_anniversary"]			= "#year_var# anos";
$pgv_lang["year_yahrzeit"]				= "#yahrzeit_date#, #yahrzeit# yahrzeit de #event_date#";
$pgv_lang["today"]						= "Hoje";
$pgv_lang["day"]						= "Dia:";
$pgv_lang["month"]						= "Mês:";
$pgv_lang["showcal"]					= "Exibir Eventos de:";
$pgv_lang["anniversary"]				= "Aniversário";
$pgv_lang["anniversary_calendar"]		= "Calendário";
$pgv_lang["sunday"]						= "Domingo";
$pgv_lang["monday"]						= "Segunda";
$pgv_lang["tuesday"]					= "Terça";
$pgv_lang["wednesday"]					= "Quarta";
$pgv_lang["thursday"]					= "Quinta";
$pgv_lang["friday"]						= "Sexta";
$pgv_lang["saturday"]					= "Sábado";
$pgv_lang["viewday"]					= "Exibir Dia";
$pgv_lang["viewmonth"]					= "Exibir Mês";
$pgv_lang["viewyear"]					= "Exibir Ano";
$pgv_lang["all_people"]					= "Todas as Pessoas";
$pgv_lang["living_only"]				= "Pessoas Vivas";
$pgv_lang["recent_events"]				= "Eventos Recentes (&lt; 100 anos)";
$pgv_lang["day_not_set"]				= "Dia não configurado";

//-- user self registration module
$pgv_lang["siteadmin"]					= "Admistrador PhpGedView";
$pgv_lang["PGV_program"]				= "Programa PhpGedView";
$pgv_lang["lost_password"]				= "Perdeu sua senha?";
$pgv_lang["requestpassword"]			= "Solicitação de cadastramento de nova senha";
$pgv_lang["no_account_yet"]				= "Ainda não é um Membro cadastrado?";
$pgv_lang["requestaccount"]				= "Solicite permissão para fazer login";
$pgv_lang["emailadress"]				= "E-mail";
$pgv_lang["mandatory"]					= "Campos com * são obrigatórios.";
$pgv_lang["mail01_line01"]				= "Olá #user_fullname# ...";
$pgv_lang["mail01_line02"]				= "Um pedido de cadastramento de conta feito em #PGV_SERVER_NAME##PGV_SCRIPT_PATH# está utilizando seu endereço de E-mail «#user_email#».";
$pgv_lang["mail01_line03"]				= "Os seguintes dados estão sendo usuados.";
$pgv_lang["mail01_line04"]				= "Por favor clique no link abaixo e preencha o formulário para validar sua Conta e endereço de E-mail.";
$pgv_lang["mail01_line05"]				= "Ignore esta mensagem caso você não tenha solicitado esse cadastramento.";
$pgv_lang["mail01_line06"]				= "Você não receberá mais nenhum outro E-mail deste site. Contas não validadas em até 7 dias, são eliminadas automaticamente.";
$pgv_lang["mail01_subject"]				= "Seu registro em #PGV_SERVER_NAME##PGV_SCRIPT_PATH#";

$pgv_lang["mail02_line01"]				= "Olá Administrador ...";
$pgv_lang["mail02_line02"]				= "Existe um registro de novo Membro em #PGV_SERVER_NAME##PGV_SCRIPT_PATH#.";
$pgv_lang["mail02_line03"]				= "O Membro recebeu um e-mail com os dados necessários para confirmar sua conta.";
$pgv_lang["mail02_line04"]				= "Tão logo o Membro faça a validação da conta você será informado por e-mail. O novo Membro só conseguirá acessar o site, após você ativar a conta dele.";
$pgv_lang["mail02_line04a"]				= "Você será informado por email quando este Membro confirmar sua adesão ao site. Após a adesão, o Membro poderá se conectar sem necessitar de sua intervenção.";
$pgv_lang["mail02_subject"]				= "Novo registro em #PGV_SERVER_NAME##PGV_SCRIPT_PATH#";

$pgv_lang["hashcode"]					= "Código de validação";
$pgv_lang["thankyou"]					= "Olá #user_fullname# ...<br />Obrigado por seu registro";
$pgv_lang["pls_note06"]					= "Agora enviaremos um e-mail de confirmação para o endereço <b>#user_email#</b>. Você deve verificar sua solicitação de conta seguindo as instruções no e-mail de confirmação. Se você não confirmar sua solicitação de conta em sete dias, sua inscrição será rejeitada automaticamente. Você terá que se inscrever novamente.<br /><br />Depois de seguir as instruções no e-mail de confirmação, o administrador ainda precisa aprovar sua solicitação antes que sua conta possa ser usada.<br /><br />Para faça login neste site, você precisará saber seu nome de usuário e senha.";
$pgv_lang["pls_note06a"]				= "Agora enviaremos um e-mail de confirmação para o endereço <b>#user_email#</b>. Você deve verificar sua solicitação de conta seguindo as instruções no e-mail de confirmação. Se você não confirmar sua solicitação de conta em sete dias, sua inscrição será rejeitada automaticamente. Você terá que se inscrever novamente.<br /><br />Depois de seguir as instruções no e-mail de confirmação, você pode fazer o login. Para acessar este site, você precisará saber seu nome de usuário e senha.";

$pgv_lang["registernew"]				= "Confirmação de nova conta";
$pgv_lang["user_verify"]				= "Validação de Membro";
$pgv_lang["send"]						= "Enviar";

$pgv_lang["pls_note07"]					= "Por favor, digite nome de Membro, Senha e Código de validação para receber deste sistema, por E-mail, a validação de seu cadastramento.";
$pgv_lang["pls_note08"]					= "Os dados do Membro <b>#user_name#</b> foram validados.";

$pgv_lang["mail03_line01"]				= "Olá Administrador ...";
$pgv_lang["mail03_line02"]				= "#newuser[username]# (#newuser[fullname]#) verificou os dados de registro.";
$pgv_lang["mail03_line03"]				= "Por favor, clique no link abaixo para conectar ao seu site e verificar os dados do Membro para permitir-lhe acesso ao seu site.";
$pgv_lang["mail03_line03a"]				= "Conta ativada, o Membro já pode acessar o site.";
$pgv_lang["mail03_subject"]				= "Nova verificação em #PGV_SERVER_NAME##PGV_SCRIPT_PATH#";

$pgv_lang["pls_note09"]					= "Você foi identificado como um Membro registrado.";
$pgv_lang["pls_note10"]					= "O Administrador será informado e tão logo ele dê permissão, você poderá acessar o site usando seu nome de Membro e senha.";
$pgv_lang["pls_note10a"]				= "Sua conta foi desbloqueada, informe Nome de Membro/Senha e entre no site.";
$pgv_lang["data_incorrect"]				= "Dados incorretos. Por favor tente novamente.";
$pgv_lang["user_not_found"]				= "Não foi possível verificar as informações.  Por favor retorne e tente novamente.";

$pgv_lang["lost_pw_reset"]				= "Solicitação de cadastramento de nova senha";
$pgv_lang["pls_note11"]					= "Para redefinir sua senha, digite seu nome de usuário.<br /><br />Responderemos enviando um e-mail para o endereço cadastrado em sua conta. O e-mail conterá um URL e um código de confirmação para sua conta. Ao visitar este URL, você pode alterar sua senha e fazer o login neste site. Por razões de segurança, você não deve fornecer este código de confirmação a ninguém.<br /><br />Se você precisar de ajuda do administrador do site, use o link de contato abaixo.";

$pgv_lang["mail04_line01"]				= "Olá #user_fullname# ...";
$pgv_lang["mail04_line02"]				= "Uma nova senha foi solicitada para o seu nome de Membro.";
$pgv_lang["mail04_line03"]				= "Recomendações:";
$pgv_lang["mail04_line04"]				= "Agora clique no link abaixo, conecte com sua nova senha e altere-a para manter segura a integridade de seus dados.";
$pgv_lang["mail04_line05"]				= "Após identificar-se, clique em «#pgv_lang[myuserdata]#» da opção de menu «#pgv_lang[mygedview]#» e altere sua senha.";
$pgv_lang["mail04_subject"]				= "Nova senha de #PGV_SERVER_NAME##PGV_SCRIPT_PATH#";

$pgv_lang["pwreqinfo"]					= "Olá ...<br /><br />Um e-mail foi enviado para seu endereço <b>#user[email]#</b> contendo a nova senha.<br /><br />Verifique no seu programa de e-mails o recebimento do mesmo.<br /><br />Recomendação:<br />Após receber o e-mail, acesse o site utilizando a nova senha e altere-a para manter segura a integridade de seus dados.";

$pgv_lang["myuserdata"]					= "Minha Conta";
$pgv_lang["user_theme"]					= "Meu Tema";
$pgv_lang["mgv"]						= "Meu Portal";
$pgv_lang["mygedview"]					= "Meu Portal";
$pgv_lang["passwordlength"]				= "Senha precisa conter ao menos 6 caracteres.";
$pgv_lang["welcome_text_auth_mode_1"]	= "<span class='center'><b>Bem-vindo a este site da Genealogia</b></span><br />O acesso a este site é permitido a qualquer visitante, desde que tenha uma conta.<br /><br />Se já tem uma conta, basta identificar-se, caso contrário clique no link apropriado nesta página e solicite a sua.<br /><br />Sua solicitação será enviada ao Administrador que ativará sua conta e lhe enviará um email instruindo-o de como acessar o site.";
$pgv_lang["welcome_text_auth_mode_2"]	= "<span class='center'><b>Bem-vindo a este site da Genealogia</b></span><br />O acesso a este site é permitido apenas a usuários <u>autorizados</u>.<br /><br />Se você tiver uma conta de usuário, poderá fazer o login nesta página. Se você não tiver uma conta de usuário, poderá solicitar uma clicando no link apropriado abaixo.<br /><br />Após verificar suas informações, o administrador irá aprovar ou recusar a inscrição de sua conta. Você receberá uma mensagem de e-mail quando sua inscrição for aprovada.";
$pgv_lang["welcome_text_auth_mode_3"]	= "<span class='center'><b>Bem-vindo a este site da Genealogia</b></span><br />O acesso a este site é permitido apenas a <u>membros da família</u>.<br /><br />Se você tiver uma conta de usuário, poderá fazer o login nesta página. Se você não tem uma conta de usuário, pode se inscrever para obter uma clicando no link apropriado abaixo.<br /><br />Depois de verificar as informações fornecidas, o administrador irá aprovar ou recusar sua solicitação de uma conta. Você receberá um e-mail quando sua solicitação for aprovada.";
$pgv_lang["welcome_text_cust_head"]		= "<span class='center'><b>Bem-vindo a este site da Genealogia</b></span><br /><br />O acesso é permitido a todos que tenham uma conta.";
$pgv_lang["acceptable_use"]				= "<div class=\"largeError\">Aviso:</div><div class=\"error\">Ao preencher e enviar este formulário, você concorda:<ul><li>em proteger a privacidade das pessoas que vivem listados em nosso site;</li><li>e na caixa de texto abaixo, para explicar a quem você está relacionado, ou para nos fornecer informações sobre alguém que deve estar listada em nosso site.</li></ul></div>";


//-- mygedview page
$pgv_lang["upcoming_events"]			= "Próximos Eventos";
$pgv_lang["living_or_all"]				= "Exibir somente eventos dos Vivos.";
$pgv_lang["basic_or_all"]				= "Exibir apenas Nascimentos, Falecimentos e Casamentos?";
$pgv_lang["style"]						= "Estilo de apresentação";
$pgv_lang["style1"]						= "Lista";
$pgv_lang["style2"]						= "Tabela";
$pgv_lang["style3"]						= "Nuvem";
$pgv_lang["sort_style"]					= "Estilo de Ordenar";
$pgv_lang["by_anniv"]					= "Pelo aniversário";
$pgv_lang["by_alpha"]					= "Alfabeticamente";
$pgv_lang["cal_download"]				= "Permitir download eventos do calendário?";
$pgv_lang["no_events_living"]			= "Não há eventos de pessoas vivas para os próximos #pgv_lang[global_num1]# dias.";
$pgv_lang["no_events_living1"]			= "Para amanhã, não há eventos com pessoas vivas.";
$pgv_lang["no_events_all"]				= "Não eventos cadastrados para os próximos #pgv_lang[global_num1]# dias.";
$pgv_lang["no_events_all1"]				= "Para amanhã não eventos cadastrados.";
$pgv_lang["no_events_privacy"]			= "Apesar de haver eventos para os próximos #pgv_lang[global_num1]# dias, por uma questão de privacidade você não pode ve-los.";
$pgv_lang["no_events_privacy1"]			= "Há eventos para amanhã, mas por uma questão de privacidade você não pode ve-los.";
$pgv_lang["more_events_privacy"]		= "Existem mais eventos para os próximos #pgv_lang[global_num1]# dias, mas por uma questão de privacidade você não pode ve-los.";
$pgv_lang["more_events_privacy1"]		= "Ha mais eventos para amanhã, mas por uma questão de privacidade você não pode ve-los.";
$pgv_lang["none_today_living"]			= "No dia de hoje, não há eventos com pessoas vivas.";
$pgv_lang["none_today_all"]				= "Não há eventos para o dia de hoje.";
$pgv_lang["none_today_privacy"]			= "Há eventos na data de hoje, mas por uma questão de privacidade você nãopode ve-los.";
$pgv_lang["more_today_privacy"]			= "Há mais eventos no dia de hoje, mas por uma questão de privacidade você não pode ve-los.";
$pgv_lang["chat"]						= "Bate-papo";
$pgv_lang["users_logged_in"]			= "Membros Conectados";
$pgv_lang["anon_user"]					= "1 Membro anônimo conectado";
$pgv_lang["anon_users"]					= "#pgv_lang[global_num1]# Membros anônimos conectados";
$pgv_lang["login_user"]					= "1 Membro conectado";
$pgv_lang["login_users"]				= "#pgv_lang[global_num1]# Membros conectados";
$pgv_lang["no_login_users"]				= "Nenhum Membro conectado";
$pgv_lang["message"]					= "Enviar Mensagem";
$pgv_lang["my_messages"]				= "Minhas Mensagens";
$pgv_lang["date_created"]				= "Data";
$pgv_lang["message_from"]				= "E-mail:";
$pgv_lang["message_from_name"]			= "Remetente:";
$pgv_lang["message_to"]					= "Para:";
$pgv_lang["message_subject"]			= "Assunto:";
$pgv_lang["message_body"]				= "Corpo:";
$pgv_lang["no_to_user"]					= "Nenhum recipiente de Membro foi fornecido.  Impossível continuar.";
$pgv_lang["provide_email"]				= "Favor fornecer seu endereço de e-mail de forma que possamos responder sua mensagem.  Seu endereço de e-mail <b>não</b> será usado para outros fins a não ser para responder sua mensagem.";
$pgv_lang["reply"]						= "Responder";
$pgv_lang["message_deleted"]			= "Mensagem excluida";
$pgv_lang["message_sent"] 				= "Mensagem enviada para #TO_USER#";
$pgv_lang["message_failed"] 			= "Não foi possível enviar a mensagem";
$pgv_lang["message_error"] 				= "Erro PHPMailer: ";
$pgv_lang["message_invalid_from"] 		= "Endereço do remetente inválido: &laquo;#email#&raquo;";
$pgv_lang["message_invalid_to"] 		= "Endereço do destinatário inválido: &laquo;#email#&raquo;";
$pgv_lang["message_illegal_chars"]		= "Caracteres ilegais no endereço &laquo;#email#&raquo;";
$pgv_lang["message_bad_format"]			= "O endereço &laquo;#email#&raquo; não está formatado corretamente";
$pgv_lang["message_no_MX"]				= "O domínio do endereço &laquo;#email#&raquo; não existe ou não possui registro MX";
$pgv_lang["reset"]						= "Restaurar";
$pgv_lang["site_default"]				= "Padrão do Site";
$pgv_lang["mygedview_desc"]				= "A página Meu Portal permite que você faça favoritos de suas pessoas favoritas, veja os próximos eventos e colabore com outros Membros.";
$pgv_lang["no_messages"]				= "Não há novas mensagens.";
$pgv_lang["clicking_ok"]				= "Clicando OK, será aberta uma outra janela onde você poderá contatar<br />#user[fullname]# ";
$pgv_lang["favorites"]					= "Favoritos";
$pgv_lang["my_favorites"]				= "Meus Favoritos";
$pgv_lang["no_favorites"]				= "Não há favoritos. Para adicionar uma pessoa ao <b>Meus Favoritos</b>, procure os detalhes da Pessoa que você deseja adicionar e clique em <b>#pgv_lang[add_favorite]#</b ou use a caixa abaixo para adicioná-lo pelo seu ID (ex: I21), ou informe uma URL e um título.";
$pgv_lang["add_to_my_favorites"]		= "Adicione aos Meus Favoritos";
$pgv_lang["gedcom_favorites"]			= "Favoritos do Site";
$pgv_lang["no_gedcom_favorites"]		= "Até este momento não existe nenhum Favorito selecionado.  O Administrador pode adicionar Favoritos que serão exibidos na inicialização.";
$pgv_lang["confirm_fav_remove"]			= "Tem certeza que deseja remover este item de Meus Favoritos?";
$pgv_lang["invalid_email"]				= "Por favor informe um e-mail válido.";
$pgv_lang["enter_subject"]				= "Por favor informe o Assunto da mensagem.";
$pgv_lang["enter_body"]					= "Por favor, informe algum texto antes de enviar.";
$pgv_lang["confirm_message_delete"]		= "Confirma a exclusão destas mensagens? Isto não poderá ser desfeito.";
$pgv_lang["message_email1"]				= "Esta mensagem foi enviada por ";
$pgv_lang["message_email2"]				= "Mensagem enviada para:";
$pgv_lang["message_email3"]				= "Mensagem enviada para o Administrador:";
$pgv_lang["viewing_url"]				= "Esta mensagem foi enviada quando navegava pelo seguinte endereço: ";
$pgv_lang["random_picture"]				= "Imagem Aleatória";
$pgv_lang["message_instructions"]		= "<b>Importante:</b> Informações privadas de pessoas vivas somente serão fornecidas aos parentes e amigos próximos.  Será solicitado confirmação de seu parentesco antes de você receber qualquer dado privado. Ocasionalmente informações de pessoas já falecidas podem ser privadas. Se esse for o caso, é porquê não há informação suficiente a respeito da pessoa que permita determinar se a mesma está viva ou não e nós provavelmente não temos mais informações sobre essa pessoa.<br /><br />Antecipadamente, por favor, verifique se o que está pesquisando sobre a pessoa está correto, verificando datas, locais e parentesco.  Se você está enviando alterações sobre dados de genealogia, por favor informe as fontes de onde obteve os dados.";
$pgv_lang["sending_to"]					= "Esta mensagem será enviada para #TO_USER#";
$pgv_lang["preferred_lang"]				= "Este Membro prefere receber mensagens em #USERLANG#";
$pgv_lang["gedcom_created_using"]		= "Este arquivo GEDCOM foi criado usando <b>#CREATED_SOFTWARE# #CREATED_VERSION#</b>.";
$pgv_lang["gedcom_created_on"]			= "Este arquivo GEDCOM foi criado em <b>#CREATED_DATE#</b>.";
$pgv_lang["gedcom_created_on2"]			= " em <b>#CREATED_DATE#</b>";
$pgv_lang["gedcom_stats"]				= "Dados Estatísticos";
$pgv_lang["stat_individuals"]			= "Pessoas";
$pgv_lang["stat_families"]				= "Famílias";
$pgv_lang["stat_sources"]				= "Fontes";
$pgv_lang["stat_other"]					= "Outros registros";
$pgv_lang["stat_earliest_birth"]		= "Pessoa Mais Antiga";
$pgv_lang["stat_latest_birth"]			= "Pessoa Mais Nova";
$pgv_lang["stat_earliest_death"]		= "Primeiro Falecimento";
$pgv_lang["stat_latest_death"]			= "Último Falecimento";
$pgv_lang["customize_page"]				= "Configurar Meu Portal";
$pgv_lang["customize_gedcom_page"]		= "Configurar esta Página Inicial";
$pgv_lang["upcoming_events_block"]		= "Próximos Eventos";
$pgv_lang["upcoming_events_descr"]		= "O bloco «Próximos Eventos» mostra aniversários de eventos que ocorrerão em um futuro próximo. Você pode configurar a quantidade de detalhes mostrados, e o administrador pode configurar o quão longe no futuro este bloco aparecerá.";
$pgv_lang["todays_events_block"]		= "Este dia";
$pgv_lang["todays_events_descr"]		= "O bloco «Este dia» mostra aniversários de eventos para hoje. Você pode configurar a quantidade de detalhes mostrados.";
$pgv_lang["todo_block"]					= "Tarefas para fazer";
$pgv_lang["todo_descr"]					= "O bloco «Tarefas para fazer» listas de todos os fatos incompletos _TODO no banco de dados.";
$pgv_lang["todo_show_other"] 			= "Mostrar tarefas de outros Membros";
$pgv_lang["todo_show_unassigned"]		= "Mostrar tarefas não atribuídos";
$pgv_lang["todo_show_future"]			= "Mostrar tarefas futuras";
$pgv_lang["todo_nothing"]				= "Não existem tarefas para fazer.";
$pgv_lang["yahrzeit_block"]				= "Yahrzeiten";
$pgv_lang["yahrzeit_descr"]				= "O bloco «Yahrzeiten» mostra aniversários de datas morte que irá ocorrer no futuro próximo. Você pode configurar o período indicado, eo administrador pode configurar o quão longe no futuro, este bloco vai olhar.";
$pgv_lang["logged_in_users_block"]		= "Membros Conectados";
$pgv_lang["logged_in_users_descr"]		= "O bloco «Membros Conectados» exibe a lista dos Membros que estão conectados.";
$pgv_lang["user_messages_block"]		= "Minhas Mensagens";
$pgv_lang["user_messages_descr"]		= "O bloco «Minhas Mensagens» exibe a lista das mensagens que foram enviadas ao Membro.";
$pgv_lang["user_favorites_block"]		= "Meus Favoritos";
$pgv_lang["user_favorites_descr"]		= "O bloco «Meus Favoritos» exibe a lista de favoritos do Membro no sistema. Isto permite um fácil acesso aos mesmos.";
$pgv_lang["welcome_block"]				= "Bem-Vindo";
$pgv_lang["welcome_descr"]				= "O bloco «Bem-Vindo» exibe o nome do Membro, data e hora corrente, bem como links que permitem acessar rapidamente a sua conta, seus dados, sua árvore genealógica e link para customizar a página <b>Meu Portal</b>.";
$pgv_lang["random_media_block"]			= "Imagem Aleatória";
$pgv_lang["random_media_descr"]			= "O bloco «Imagem Aleatória» exibe aleatoriamente uma foto ou outra mídia do banco de dados.";
$pgv_lang["random_media_persons_or_all"]	= "Exibir apenas pessoas, eventos ou tudo?";
$pgv_lang["random_media_persons"]		= "Pessoas";
$pgv_lang["random_media_events"]		= "Eventos";
$pgv_lang["gedcom_block"]				= "Bem-Vindo GEDCOM";
$pgv_lang["gedcom_descr"]				= "O bloco «Bem-Vindo GEDCOM» funciona da mesma forma que o o bloco 'Bem-Vindo - Membro'. Exibe o titulo do arquivo de genealogia, bem como a data e hora corrente.";
$pgv_lang["gedcom_favorites_block"]		= "Favoritos GEDCOM";
$pgv_lang["gedcom_favorites_descr"]		= "O bloco «Favoritos GEDCOM» permite ao administrador a  capacidade de selecionar suas pessoas favoritas do banco de dados de forma que os visitantes possam facilmente encontrá-los. Esta é uma forma de evidenciar as pessoas que são importantes em sua história.";
$pgv_lang["gedcom_stats_block"]			= "Dados Estatísticos";
$pgv_lang["gedcom_stats_descr"]			= "O bloco «Dados Estatísticos» exibe ao visitante algumas informações básicas sobre do banco de dados como por exemplo quando foi criado e quantas pessoas estão cadastradas no mesmo e sobrenomes mais comuns.";
$pgv_lang["gedcom_stats_show_surnames"]		= "Exibir Sobrenomes mais comuns?";
$pgv_lang["portal_config_instructions"]		= "~#pgv_lang[customize_page]#~<br />~#pgv_lang[customize_gedcom_page]#~<br /><br />Você pode personalizar a página posicionando os blocos na página da maneira que quiser.<br /><br />A página é dividida nas seções <b>Principal</b> e <b>Direita</b>. Os blocos da seção <b>Principal</b> aparecem maiores e sob o título da página. A seção <b>Direita</b> começa à direita do título e desce no lado direito da página.<br /><br />Cada seção tem sua própria lista de blocos que serão impressos na página na ordem em que estão listados. Você pode adicionar, remover e reordenar os blocos como quiser.<br /><br />Quando uma das listas de blocos estiver vazia, os blocos restantes ocuparão toda a largura da página.";
$pgv_lang["login_block"]				= "Conectar";
$pgv_lang["login_descr"]				= "O bloco «Conectar» solicita Nome e Senha para os Membros conectaram-se ao site.";
$pgv_lang["theme_select_block"]			= "Seleção de Temas";
$pgv_lang["theme_select_descr"]			= "O bloco «Seleção de Temas» permite selecionar outro tema para o site.";
$pgv_lang["block_top10_title"]			= "Sobrenomes mais frequentes";
$pgv_lang["block_top10"]				= "Sobrenomes mais frequentes";
$pgv_lang["block_top10_descr"]			= "O bloco «Sobrenomes mais frequentes» mostra uma tabela com os sobrenomes mais frequentes do banco de dados.";
$pgv_lang["block_cookiepolicy"]			= "Política de cookies";
$pgv_lang["block_cookiepolicy_title"]	= "Política de cookies";
$pgv_lang["block_cookiepolicy_descr"]	= "O bloco «Política de cookies» mostra a política de cookies deste site,como exigido pela lei de cookies da UE.";
$pgv_lang["block_cookiepolicy_body"]	= "<span class='warning'>O lei de cookies da UE exige que nota.</span><br />Este site se esforça para usar cookies apenas se não houver outra possibilidade. Cookies deste site nunca armazenar informações pessoais ou nome de usuário e senha.<br /><br />Por razões técnicas fora do controlo deste site, esses cookies não são apagados quando você encerrar a sessão com este site. No entanto, eles são apagados imediatamente quando o navegador encerra.";
$pgv_lang["block_cookiepolicy_body_extlink"]	= "<span class='warning'>O lei de cookies da UE exige que nota.</span><br />Este site se esforça para usar cookies apenas se não houver outra possibilidade. Cookies deste site nunca armazenar informações pessoais ou nome de usuário e senha. Mais detalhes sobre a política de cookies deste site, você pode obter através <a href='<link>' target='_blank' title='Política de cookies no site'>deste link</a>.<br /><br />Por razões técnicas fora do controlo deste site, esses cookies não são apagados quando você encerrar a sessão com este site. No entanto, eles são apagados imediatamente quando o navegador encerra.";
$pgv_lang["block_cookiepolicy_link"]	= "Link para a página política de cookies";
$pgv_lang["block_givn_top10_title"]		= "Nomes mais frequentes";
$pgv_lang["block_givn_top10"]			= "Nomes mais frequentes";
$pgv_lang["block_givn_top10_descr"]		= "O bloco «Nomes mais frequentes» mostra os mais frequentes nomes no banco de dados. O número real de nomes mostrados neste bloco é configurável.";

$pgv_lang["gedcom_news_block"]			= "Notícias";
$pgv_lang["gedcom_news_descr"]			= "O bloco «Notícias» mostra os comunicados de notícias do visitante ou artigos publicados por um usuário administrador.<br /><br />Este é um bom lugar para anunciar uma atualização significativa do banco de dados, uma reunião familiar ou o nascimento de uma criança.";
$pgv_lang["gedcom_news_limit"]			= "Limitar a exibição por:";
$pgv_lang["gedcom_news_limit_nolimit"]	= "Sem Limite";
$pgv_lang["gedcom_news_limit_date"]		= "Idade do Item";
$pgv_lang["gedcom_news_limit_count"]	= "Número de Itens";
$pgv_lang["gedcom_news_flag"]			= "Limite:";
$pgv_lang["gedcom_news_published"]		= "Publicado : ";
$pgv_lang["gedcom_news_archive"]		= "Exibir arquivo";
$pgv_lang["user_news_block"]			= "Minhas Notícias";
$pgv_lang["user_news_descr"]			= "O bloco «Minhas Notícias» permite ao Membro a manutenção de notícias ou um Jornal on-line.";
$pgv_lang["my_journal"]					= "Meu Diário";
$pgv_lang["no_journal"]					= "Diário vazio.";
$pgv_lang["confirm_journal_delete"]		= "Confirma a exclusão desta informação do Diário?";
$pgv_lang["add_journal"]				= "Adicionar informação ao Diário";
$pgv_lang["gedcom_news"]				= "Notícias";
$pgv_lang["confirm_news_delete"]		= "Conforma exclusão desta Notícia?";
$pgv_lang["add_news"]					= "Adicionar Notícia";
$pgv_lang["no_news"]					= "Não há novos artigos.";
$pgv_lang["edit_news"]					= "Adicionar/Editar Notícias ou Diário";
$pgv_lang["enter_title"]				= "Favor informar um título.";
$pgv_lang["enter_text"]					= "Digite um texto para essa Notícia ou Diário.";
$pgv_lang["news_saved"]					= "Notícia/Jornal salvo com sucesso.";
$pgv_lang["article_text"]				= "Texto";
$pgv_lang["main_section"]				= "Blocos da seção Principal";
$pgv_lang["right_section"]				= "Blocos da seção Auxiliar";
$pgv_lang["available_blocks"]			= "Blocos Disponíveis";
$pgv_lang["move_up"]					= "Subir";
$pgv_lang["move_down"]					= "Baixar";
$pgv_lang["move_right"]					= "Mover para Direita";
$pgv_lang["move_left"]					= "Mover para Esquerda";
$pgv_lang["broadcast_all"]				= "Enviar para todos os Membros";
$pgv_lang["hit_count"]					= "Nº de Visitas:";
$pgv_lang["phpgedview_message"]			= "Mensagem PhpGedView";
$pgv_lang["common_surnames"]			= "Sobrenomes Mais Comuns";
$pgv_lang["default_news_title"]			= "Bem-vindo à sua Árvore Genealógica ";
$pgv_lang["default_news_text"]			= "As informações de genealogia deste website são produzidas  por <a href=\"http://www.phpgedview.net/\" target=\"_blank\">PhpGedView</a>.  Esta página fornece uma introdução e visão geral desta genealogia.<br /><br />Para explorar as informações do site você pode escolher um dos gráficos a partir do menu de <b>Gráficos</b>, mostrar <b>Listas</b> de pessoas, famílias, locais, mídias ou também <b>Pesquisar</b> um nome ou local.<br /><br />Se tiver dúvida ao usar o site, clicando no menu de <b>Ajuda</b> você receberá informações de como usar a página que está sendo visualizada no momento.<br /><br />Obrigado por visitar este site.";
$pgv_lang["reset_default_blocks"]		= "Restaurar padrão de Blocos";
$pgv_lang["recent_changes"]				= "Últimas Atualizações";
$pgv_lang["recent_changes_block"]		= "Últimas Atualizações";
$pgv_lang["recent_changes_descr"]		= "O bloco «Últimas Atualizações» mostrará uma lista das últimas atualizações que foram efetuadas no banco de dados no último mês.  Este bloco pode ajudá-lo a ficar em dia com as mudanças do site.  As mudanças se baseiam na expressão CHAN.";
$pgv_lang["recent_changes_none"]		= "<b>Não há alterações a pelo menos #pgv_lang[global_num1]# dias.</b>";
$pgv_lang["recent_changes_some"]		= "<b>Alterações feitas nos últimos #pgv_lang[global_num1]# dias</b>";
$pgv_lang["show_empty_block"]			= "Este bloco não deverá ser exibido se estiver vazio?";
$pgv_lang["hide_block_warn"]			= "Se um bloco não é exibido quando está vazio, então ele só poderá ser configurado se não estiver vazio.";
$pgv_lang["delete_selected_messages"]	= "Excluir Mensagens Selecionadas";
$pgv_lang["use_blocks_for_default"]		= "Usar esses blocos como padrão de configuração para todos os Membros?";
$pgv_lang["block_not_configure"]		= "Este bloco não pode ser configurado.";

//-- validate GEDCOM
$pgv_lang["add_media_tool"]				= "Ferramenta para adicionar Mídia";

//-- hourglass chart
$pgv_lang["hourglass_chart"]			= "Gráfico Ampulheta";

//-- report engine
$pgv_lang["choose_report"]				= "Escolha o Relatório a executar";
$pgv_lang["enter_report_values"]		= "Informe os dados do Relatório";
$pgv_lang["selected_report"]			= "Relatório selecionado";
$pgv_lang["select_report"]				= "Selecione Relatório";
$pgv_lang["download_report"]			= "Salvar Relatório";
$pgv_lang["reports"]					= "Relatórios";
$pgv_lang["pdf_reports"]				= "Relatórios PDF";
$pgv_lang["html_reports"]				= "Relatórios HTML";

//-- Ahnentafel report
$pgv_lang["ahnentafel_report"]			= "Relatório Ahnentafel";
$pgv_lang["ahnentafel_generation"]		= "Geração";
$pgv_lang["ahnentafel_pronoun_m"]		= "Ele ";
$pgv_lang["ahnentafel_pronoun_f"]		= "Ela ";
$pgv_lang["ahnentafel_born_m"]			= "nasceu";
$pgv_lang["ahnentafel_born_f"]			= "nasceu";
$pgv_lang["ahnentafel_christened_m"]	= "foi critianizado";
$pgv_lang["ahnentafel_christened_f"]	= "foi cristianizada";
$pgv_lang["ahnentafel_married_m"]		= "casou";
$pgv_lang["ahnentafel_married_f"]		= "casou";
$pgv_lang["ahnentafel_married_post"]	= "&nbsp;";
$pgv_lang["ahnentafel_died_m"]			= "faleceu";
$pgv_lang["ahnentafel_died_f"]			= "faleceu";
$pgv_lang["ahnentafel_cremated_m"]		= "foi cremado";		// male
$pgv_lang["ahnentafel_cremated_f"]		= "foi cremado";		// female
$pgv_lang["ahnentafel_buried_m"]		= "foi sepultado";
$pgv_lang["ahnentafel_buried_f"]		= "foi sepultada";
$pgv_lang["ahnentafel_place"]			= " em ";
$pgv_lang["ahnentafel_no_details"]		= " porém os detalhes são desconhecidos";
$pgv_lang["ahnentafel_on"]				= " ";

//-- Changes report
$pgv_lang["changes_report"]				= "Relatório das alterações";
$pgv_lang["changes_pending_tot"]		= "Total alterações pendentes: ";
$pgv_lang["changes_accepted_tot"]		= "Total alterações concluídas: ";

//-- Descendancy report
$pgv_lang["descend_report"]				= "Relatório de Descendentes";
$pgv_lang["son_of"]						= "filho de";
$pgv_lang["daughter_of"]				= "filha de";
$pgv_lang["child_of"]					= "Filho de ";
$pgv_lang["children_of"]				= "Filhos de ";
$pgv_lang["descendancy_pronoun_m"]		= "Ele ";
$pgv_lang["descendancy_pronoun_f"]		= "Ela ";

$pgv_lang["family_group_report"]		= "Relatório de Grupo Familiar";
$pgv_lang["page"]						= "Página";
$pgv_lang["of"]							= "de";
$pgv_lang["enter_famid"]				= "Informe ID da Família";
$pgv_lang["show_sources"]				= "Exibir fontes?";
$pgv_lang["show_notes"]					= "Exibir notas?";
$pgv_lang["show_abbr_notes"]			= "Exibir notas abreviadas?";
$pgv_lang["show_photos"]				= "Exibir fotos?";
$pgv_lang["relatives_report_ext"]		= "Relatório de Parentes (expandido)";
$pgv_lang["with"]						= "com";
$pgv_lang["on"]							= "em";
$pgv_lang["in"]							= "em";
$pgv_lang["individual_report"]			= "Relatório de Pessoa";
$pgv_lang["individual_with_rela_report"]	= "Relatório de Parentes próximos";
$pgv_lang["enter_pid"]					= "Informe ID da Pessoa";
$pgv_lang["generated_by"]				= "Gerado por";
$pgv_lang["birth_report"]				= "Relatório Data e Local de Nascimento";
$pgv_lang["birthplace"]					= "Local de Nascimento contendo";
$pgv_lang["birthdate1"]					= "Data de Nascimento inicial";
$pgv_lang["birthdate2"]					= "Data de Nascimento final";
$pgv_lang["death_report"]				= "Relatório de Data de Falecimento e Lugar";
$pgv_lang["deathplace"]					= "Lugar do Falecimento contendo";
$pgv_lang["deathdate1"]					= "Data do Falecimento Inicial";
$pgv_lang["deathdate2"]					= "Data do Falecimento Final";
$pgv_lang["marr_report"]				= "Relatório de Data de Casamento e Lugar";
$pgv_lang["marrplace"]					= "Lugar do Casamento contendo";
$pgv_lang["marrdate1"]					= "Data de Casamento Inicial";
$pgv_lang["marrdate2"]					= "Data de Casamento Final";
$pgv_lang["sort_by"]					= "Classificado por";
$pgv_lang["cemetery_report"]			= "Relatório de Cemitérios";
$pgv_lang["burialplace"]				= "Coloque o enterro contém";
$pgv_lang["fact_sources_report"]		= "Fontes de fato";
$pgv_lang["missing_facts_report"]		= "Fatos falta de parentes";
$pgv_lang["sources_to_events"]			= "Fontes para os eventos";

$pgv_lang["cleanup"]					= "Limpar";

//-- CONFIGURE (extra) messages for programs patriarch and statistics
$pgv_lang["statistics"]					= "Estatísticas";
$pgv_lang["show_stats_charts"]			= "Mostrar gráficos de estatísticas";
$pgv_lang["decade_birth"]				= "Década de nascimento";
$pgv_lang["decade_death"]				= "Década da morte";
$pgv_lang["decade_marriage"]			= "Década de casamento";
$pgv_lang["avg_age"]					= "Idade média";

//-- Merge Records
$pgv_lang["merge_same"]					= "Registros não são do mesmo tipo.  Não é possível consolidar registros que não sejam do mesmo tipo.";
$pgv_lang["merge_step1"]				= "Consolidação Passo 1 de 3";
$pgv_lang["merge_step2"]				= "Consolidação Passo 2 de 3";
$pgv_lang["merge_step3"]				= "Consolidação Passo 3 de 3";
$pgv_lang["select_gedcom_records"]		= "Selecionar 2 registros GEDCOM para consolidação.  Registros devem ser do mesmo tipo.";
$pgv_lang["merge_to"]					= "Consolidar para ID:";
$pgv_lang["merge_from"]					= "Consolidar de ID:";
$pgv_lang["merge_facts_same"]			= "Os fatos seguintes são exatamente os mesmos em ambos registros e serão automaticamente consolidados";
$pgv_lang["no_matches_found"]			= "Não encontrada nenhuma combinação de fatos";
$pgv_lang["unmatching_facts"]			= "Os seguintes fatos são conflitantes. Selecione qual deles deve ser mantido.";
$pgv_lang["record"]						= "Registro";
$pgv_lang["adding"]						= "Adicionando";
$pgv_lang["updating_linked"]			= "Atualizando registro combinado";
$pgv_lang["merge_more"]					= "Consolidar mais registros.";
$pgv_lang["same_ids"]					= "Você informou os mesmos IDs. Consolidação funciona somente com IDs diferentes.";
$pgv_lang["updated_favorites"] 			= "Favoritos atualizados.";

//-- ANCESTRY FILE MESSAGES
$pgv_lang["ancestry_chart"]				= "Gráfico Ancestrais";
$pgv_lang["gen_ancestry_chart"]			= "#PEDIGREE_GENERATIONS# Gerações de Ancestrais";
$pgv_lang["chart_style"]				= "Tipo de gráfico";
$pgv_lang["chart_list"]					= "Estilo Lista";
$pgv_lang["chart_booklet"]				= "Estilo Livreto";
$pgv_lang["show_cousins"]				= "Exibir Primos";
// 1st generation
$pgv_lang["sosa_2"]						= "Pai";
$pgv_lang["sosa_3"]						= "Mãe";
// 2nd generation
$pgv_lang["sosa_4"]						= "Avô";
$pgv_lang["sosa_5"]						= "Avó";
$pgv_lang["sosa_6"]						= "Avô";
$pgv_lang["sosa_7"]						= "Avó";
// 3rd generation
$pgv_lang["sosa_8"]						= "Bisavô";
$pgv_lang["sosa_9"]						= "Bisavó";
$pgv_lang["sosa_10"]					= "Bisavô";
$pgv_lang["sosa_11"]					= "Bisavó";
$pgv_lang["sosa_12"]					= "Bisavô";
$pgv_lang["sosa_13"]					= "Bisavó";
$pgv_lang["sosa_14"]					= "Bisavô";
$pgv_lang["sosa_15"]					= "Bisavó";
// 4th generation
$pgv_lang["sosa_16"]					= "Trisavô";
$pgv_lang["sosa_17"]					= "Trisavó";
$pgv_lang["sosa_18"]					= "Trisavô";
$pgv_lang["sosa_19"]					= "Trisavó";
$pgv_lang["sosa_20"]					= "Trisavô";
$pgv_lang["sosa_21"]					= "Trisavó";
$pgv_lang["sosa_22"]					= "Trisavô";
$pgv_lang["sosa_23"]					= "Trisavó";
$pgv_lang["sosa_24"]					= "Trisavô";
$pgv_lang["sosa_25"]					= "Trisavó";
$pgv_lang["sosa_26"]					= "Trisavô";
$pgv_lang["sosa_27"]					= "Trisavó";
$pgv_lang["sosa_28"]					= "Trisavô";
$pgv_lang["sosa_29"]					= "Trisavó";
$pgv_lang["sosa_30"]					= "Trisavô";
$pgv_lang["sosa_31"]					= "Trisavó";

// for the general case of ancestors of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["sosa_paternal_male_n_generations"]	= "%3\$d x bisavô paterno";
$pgv_lang["sosa_paternal_female_n_generations"]	= "%3\$d x bisavó paterna";
$pgv_lang["sosa_maternal_male_n_generations"]	= "%3\$d x bisavô materno";
$pgv_lang["sosa_maternal_female_n_generations"]	= "%3\$d x bisavó materna";

//-- FAN CHART
$pgv_lang["compact_chart"]				= "Gráfico Resumo";
$pgv_lang["fan_chart"]					= "Gráfico Círculo";
$pgv_lang["gen_fan_chart"]				= "Exibir até #PEDIGREE_GENERATIONS# gerações no gráfico";
$pgv_lang["fan_width"]					= "Largura";
$pgv_lang["gd_library"]					= "Servidor PHP desconfigurado: Biblioteca GD requirida para uso de funções de imagem.";
$pgv_lang["gd_freetype"]				= "Servidor PHP desconfigurado: Biblioteca Freetype requirida para fontes TrueType.";
$pgv_lang["gd_helplink"]				= "http://www.php.net/gd";
$pgv_lang["fontfile_error"]				= "Arquivo de Fonte não encontrada no servidor PHP";
$pgv_lang["fanchart_IE"]				= "A imagem do gráfico em Leque não pode ser impressa por seu navegador. Clique com o botão direito do mouse para salva-lo em seu computador e em seguida imprima-o.";

//-- RSS Feed
$pgv_lang["rss_descr"]					= "Notícias e links do site #GLOBALS[GEDCOM_TITLE]#";
$pgv_lang["rss_logo_descr"]				= "Alimentação criado por PhpGedView";
$pgv_lang["rss_feeds"]					= "Alimentação da RSS";
$pgv_lang["no_feed_title"]				= "Alimentador indisponível";
$pgv_lang["no_feed"]					= "Não há RSS disponível para este site PhpGedView";
$pgv_lang["feed_login"]					= "Caso tenha uma conta para este site <a href=\"#AUTH_URL#\">identifique-se</a> usando a Autenticação Básica do HTTP e acesse as informações restritas.";
$pgv_lang["authenticated_feed"]			= "Alimentação autenticado";

//-- ASSOciates RELAtionship
// After any change in the following list, please check $assokeys in edit_interface.php
$pgv_lang["attendant"]					= "Atendente";
$pgv_lang["attending"]					= "Atendendo";
$pgv_lang["best_man"]					= "Padrinho de Casamento";
$pgv_lang["bridesmaid"]					= "Dama de Honra";
$pgv_lang["buyer"]						= "Comprador";
$pgv_lang["circumciser"]				= "Circuncisador";
$pgv_lang["civil_registrar"]			= "Registro Civil";
$pgv_lang["employee"]					= "Trabalhador";
$pgv_lang["employer"]					= "Patrão";
$pgv_lang["foster_child"]				= "Filho de Criação";
$pgv_lang["foster_father"]				= "Pai de Criação";
$pgv_lang["foster_mother"]				= "Mãe de Criação";
$pgv_lang["friend"]						= "Amigo";
$pgv_lang["godfather"]					= "Padrinho";
$pgv_lang["godmother"]					= "Madrinha";
$pgv_lang["godparent"]					= "Padrinhos";
$pgv_lang["godson"]						= "Afilhado";
$pgv_lang["goddaughter"]				= "Afilhada";
$pgv_lang["godchild"]					= "Afilhado/Afilhada";
$pgv_lang["guardian"]					= "Curador";
$pgv_lang["informant"]					= "Informante";
$pgv_lang["lodger"]						= "Inquilino";
$pgv_lang["nanny"]						= "Ama de crianças";
$pgv_lang["nurse"]						= "Enfermeira";
$pgv_lang["owner"]						= "Dono";
$pgv_lang["priest"]						= "Padre";
$pgv_lang["rabbi"]						= "Rabino";
$pgv_lang["registry_officer"]			= "Agente de Registro";
$pgv_lang["seller"]						= "Vendedor";
$pgv_lang["servant"]					= "Empregado";
$pgv_lang["slave"]						= "Escravo";
$pgv_lang["twin"]						= "Gêmeo";
$pgv_lang["twin_brother"]				= "Irmão gêmeo";
$pgv_lang["twin_sister"]				= "Irmã gêmea";
$pgv_lang["ward"]						= "Custódia";
$pgv_lang["witness"]					= "Testemunha";

//-- statistics utility
$pgv_lang["stat_create"]				= "Crie seu próprio gráfico";
$pgv_lang["statutci"]					= "não foi possível criar o índice";
$pgv_lang["statnnames"]					= "Número de nomes";
$pgv_lang["statnfam"]					= "Número de famílias";
$pgv_lang["statnmale"]					= "pessoas masculinas";
$pgv_lang["statnfemale"]				= "pessoas femininas";
$pgv_lang["with_sources"]				= "Com fontes";
$pgv_lang["without_sources"]			= "Sem fontes";
$pgv_lang["stat_sindi"]					= "Indivíduos com fontes";
$pgv_lang["stat_sfam"]					= "Famílias com fontes";
$pgv_lang["statvars"]					= "Preencha as seguintes variáveis para o gráfico";
$pgv_lang["statlxa"]					= "Selecione o tipo de gráfico:";
$pgv_lang["statlya"]					= "resultados:";
$pgv_lang["statlza"]					= "Categorias:";
$pgv_lang["map_type"]					= "Tipo de mapa";
$pgv_lang["stat_1_map"]					= "Distribuição de indivíduos";
$pgv_lang["stat_2_map"]					= "Nascimento com o país";
$pgv_lang["stat_3_map"]					= "Morte com o país";
$pgv_lang["stat_4_map"]					= "Casamento com o país";
$pgv_lang["stat_5_birth"]				= "Nascimentos em século";
$pgv_lang["stat_6_death"]				= "Mortes em século";
$pgv_lang["stat_7_marr"]				= "Casamentos em século";
$pgv_lang["stat_7_div"]					= "Divórcios em século";
$pgv_lang["stat_8_fam"]					= "Famílias com fontes";
$pgv_lang["stat_9_indi"]				= "Indivíduos com fontes";
$pgv_lang["stat_10_none"]				= "nenhum";
$pgv_lang["stat_11_mb"]					= "Mês do nascimento";
$pgv_lang["stat_12_md"]					= "Mês do falecimento";
$pgv_lang["stat_13_mm"]					= "Mês do casamento";
$pgv_lang["stat_14_mb1"]				= "Mês do nascimento do primeiro filho do casal";
$pgv_lang["stat_15_mm1"]				= "Mês do primeiro casamento";
$pgv_lang["stat_16_mmb"]				= "Mêses do casamento ao nascimento do primeiro filho";
$pgv_lang["stat_17_arb"]				= "Ano de nascimento";
$pgv_lang["stat_18_ard"]				= "Idade na morte";
$pgv_lang["stat_18_aard"]				= "Idade média na morte";
$pgv_lang["stat_19_arm"]				= "Idade no casamento";
$pgv_lang["stat_19_aarm"]				= "Idade média no casamento";
$pgv_lang["stat_20_arm1"]				= "Idade no primeiro casamento";
$pgv_lang["stat_21_nok"]				= "Número de filhos";
$pgv_lang["stat_22_fwok"]				= "Número de famílias sem filhos";
$pgv_lang["stat_200_none"]				= "todos (ou em branco)";
$pgv_lang["stat_201_num"]				= "números";
$pgv_lang["stat_202_perc"]				= "percentual";
$pgv_lang["stat_300_none"]				= "nenhum";
$pgv_lang["stat_301_mf"]				= "sexo";
$pgv_lang["stat_302_cgp"]				= "períodos de data";
$pgv_lang["century"]					= "Século";
$pgv_lang["stat_age"]					= "Idade";
$pgv_lang["no_date_fam"]				= "desconhecido";
$pgv_lang["statar_xgp"]					= "limites para os períodos:";
$pgv_lang["statar_xgl"]					= "limites para os idades:";
$pgv_lang["statar_xgm"]					= "limites para o mês:";
$pgv_lang["statar_xga"]					= "limites para os números:";
$pgv_lang["statar_zgp"]					= "limites para os períodos de data:";
$pgv_lang["less"]						= "menor que";
$pgv_lang["over"]						= "mais de";
$pgv_lang["interval"]					= "intervalo";
$pgv_lang["aft_marr"]					= "meses após casamento";
$pgv_lang["bef_marr"]					= "meses antes e depois do casamento";
$pgv_lang["quarters"]					= "trimestres após casamento";
$pgv_lang["half_year"]					= "semestre após casamento";
$pgv_lang["one_child"]					= "intervalo de um filho";
$pgv_lang["two_children"]				= "intervalo de dois filhos";
$pgv_lang["statreset"]					= "desfazer";
$pgv_lang["statsubmit"]					= "Exibir a plotagem";
$pgv_lang["stat_largest_families"]		= "Maiores famílias";

$pgv_lang["stat_own_charts"]			= "Próprios gráficos";
$pgv_lang["statnliving"]				= "Total de vida";
$pgv_lang["statndead"]					= "Total mortos";
$pgv_lang["stat_births"]				= "Total nascimentos";
$pgv_lang["stat_marriages"]				= "Total casamentos";
$pgv_lang["stat_divorces"]				= "Total divórcios";
$pgv_lang["stat_deaths"]				= "Total mortes";
$pgv_lang["stat_first_birth"]			= "Mais antiga nascimento";
$pgv_lang["stat_first_marriage"]		= "Mais antiga casamento";
$pgv_lang["stat_first_divorce"]			= "Mais antiga divórcio";
$pgv_lang["stat_first_death"]			= "Mais antiga morte";
$pgv_lang["stat_last_birth"]			= "Mais recente nascimento";
$pgv_lang["stat_last_marriage"]			= "Mais recente casamento";
$pgv_lang["stat_last_divorce"]			= "Mais recente divórcio";
$pgv_lang["stat_last_death"]			= "Mais recente morte";
$pgv_lang["stat_lifespan"]				= "Tempo de vida";
$pgv_lang["stat_lived_longest"]			= "Idade superior a morte";
$pgv_lang["stat_live_longest"]			= "Mais idosos que vivem";
$pgv_lang["stat_marr_age"]				= "Duração do casamento";
$pgv_lang["stat_long_marr_age"]			= "Mais longo casamento";
$pgv_lang["stat_short_marr_age"]		= "Mais curto casamento";
$pgv_lang["stat_youngest_male"]			= "Mais jovem masculino";
$pgv_lang["stat_youngest_female"]		= "Mais jovem feminina";
$pgv_lang["stat_oldest_male"]			= "Mais velho masculino";
$pgv_lang["stat_oldest_female"]			= "Mais velho feminina";
$pgv_lang["stat_childbirth_age"]		= "Idade no nascimento do filho";
$pgv_lang["stat_youngest_father"]		= "Mais jovem pai";
$pgv_lang["stat_youngest_mother"]		= "Mais jovem mãe";
$pgv_lang["stat_oldest_father"]			= "Mais velho pai";
$pgv_lang["stat_oldest_mother"]			= "Mais velha mãe";
$pgv_lang["stat_children_in_fam"]		= "Filhos em família";
$pgv_lang["stat_largest_gfamilies"]		= "Grandes avó-famílias";
$pgv_lang["stat_age_difference"]		= "Diferença de idade";
$pgv_lang["stat_age_siblings"]			= "Idade entre irmãos";
$pgv_lang["stat_top_age_siblings"]		= "Idade superior entre irmãos";
$pgv_lang["stat_age_mf_spouse"]			= "Idade entre marido e mulher";
$pgv_lang["stat_age_fm_spouse"]			= "Idade entre mulher e marido";
$pgv_lang["stat_names"]					= "Nomes";
$pgv_lang["statnsurnames"]				= "Total sobrenomes";
$pgv_lang["statngivennames"]			= "Total nomes dados";
$pgv_lang["top_surnames"]				= "Sobrenomes mais freqüentes";
$pgv_lang["top_givennames"]				= "Nomes dados mais freqüentes";
$pgv_lang["events"]						= "Eventos";
$pgv_lang["stat_records"]				= "Registros";
$pgv_lang["stat_notes"]					= "Notas";
$pgv_lang["stat_first_event"]			= "Primeiro evento";
$pgv_lang["stat_last_event"]			= "Último evento";
$pgv_lang["stat_places"]				= "Lugares";
$pgv_lang["stat_birth_places"]			= "Lugares de nascimento";
$pgv_lang["stat_marriage_places"]		= "Lugares o casamento";
$pgv_lang["stat_death_places"]			= "Lugares a morte";
$pgv_lang["stat_countries"]				= "Eventos em países";

//-- statisticsplot utility
$pgv_lang["statistiek_list"]			= "Grafico das Estatísticas";
$pgv_lang["stpl"]						= "...";
$pgv_lang["stplinfo"]					= "informação para plotagem";
$pgv_lang["stpltype"]					= "tipo:";
$pgv_lang["stplnoim"]					= " não implementado:";
$pgv_lang["stplmf"]						= " por sexo";
$pgv_lang["stplipot"]					= " por período de tempo";
$pgv_lang["stplmonth"]					= "mês";
$pgv_lang["stplnumbers"]				= "números de uma família";
$pgv_lang["stplnuch"]					= "filhos";
$pgv_lang["stplage"]					= "idade";
$pgv_lang["stplperc"]					= "percentual";
$pgv_lang["stplnumof"]					= "número ";
$pgv_lang["stplmarrbirth"]				= "Meses do casamento ao nascimento do primeiro filho";
$pgv_lang["indi_distribution_chart"]	= "Gráfico de distribuição dos indivíduos";
$pgv_lang["surname_distribution_chart"]	= "Gráfico de distribuição de sobrenomes";
$pgv_lang["g_chart_high"]				= "Mais populosa";
$pgv_lang["g_chart_low"]				= "Mais baixo população";
$pgv_lang["g_chart_nobody"]				= "Ninguém em todos os";
$pgv_lang["area_chart"]					= "Área geográfica";
$pgv_lang["europe_chart"]				= "Europa";
$pgv_lang["s_america_chart"]			= "Ámérica do Sul";
$pgv_lang["asia_chart"]					= "Ásia";
$pgv_lang["middle_east_chart"]			= "Oriente Médio";
$pgv_lang["africa_chart"]				= "África";
$pgv_lang["world_chart"]				= "Globo";

//-- alive in year
$pgv_lang["alive_in_year"]				= "Pessoas Vivas";
$pgv_lang["is_alive_in"]				= "Vivo em #YEAR#";
$pgv_lang["alive"]						= "Vivo ";
$pgv_lang["dead"]						= "Falecido ";
$pgv_lang["maybe"]						= "Talvez ";
$pgv_lang["both_alive"]					= "Dois vivos ";
$pgv_lang["both_dead"]					= "Dois mortos ";

//-- Help system
$pgv_lang["definitions"]				= "Definições";

//-- Index_edit
$pgv_lang["block_desc"]					= "Descrição dos Blocos";
$pgv_lang["click_here"]					= "Clique aqui para continuar";
$pgv_lang["click_here_help"]			= "~#pgv_lang[click_here]#~<br /><br />Clique neste botão para salvar as alterações.<br /><br />Ao retornar para a página #pgv_lang[welcome]# ou para #pgv_lang[mygedview]#, caso não veja suas alterações, clique no botão Atualizar de seu Navegador (Browser).";
$pgv_lang["block_summaries"]			= "~#pgv_lang[block_desc]#~<br /><br />Descrição sucinta de cada bloco que você pode colocar em #pgv_lang[welcome]# ou na página #pgv_lang[mygedview]#.<br /><br /><table border='1' width='95%'><tr><td class='list_value'><b>#pgv_lang[name]#</b></td><td class='list_value'><b>#pgv_lang[description]#</b></td></tr>#GLOBALS[blockSummaries]#</table>";

//-- Find page
$pgv_lang["total_places"]				= "Lugares encontrados";
$pgv_lang["media_contains"]				= "Mídia contém:";
$pgv_lang["repo_contains"]				= "Reposição contém:";
$pgv_lang["shared_note_contains"]		= "Nota partilhada contém:";
$pgv_lang["source_contains"]			= "Fonte contém:";
$pgv_lang["display_all"]				= "Exibir tudo";

// FAQ Page
$pgv_lang["add_faq_header"]				= "Cabeçalho da FAQ";
$pgv_lang["add_faq_body"]				= "Corpo da FAQ";
$pgv_lang["add_faq_order"]				= "Posição da FAQ";
$pgv_lang["add_faq_visibility"] 		= "Visibilidade de FAQ";
$pgv_lang["no_faq_items"]				= "A lista de FAQ está vazia!";
$pgv_lang["position_item"]				= "Posição do item";
$pgv_lang["faq_list"]					= "Lista de FAQs";
$pgv_lang["confirm_faq_delete"]			= "Confirma exclusão desta FAQ?";
$pgv_lang["preview"]					= "Prévia";
$pgv_lang["no_id"]						= "Informe a ID da FAQ!";

// Help search
$pgv_lang["hs_title"]					= "Procurar texto de Ajuda";
$pgv_lang["hs_search"]					= "Pesquisa";
$pgv_lang["hs_close"]					= "Fechar a janela";
$pgv_lang["hs_results"]					= "Resultados encontrados:";
$pgv_lang["hs_keyword"]					= "Pesquisar por";
$pgv_lang["hs_searchin"]				= "Pesquisar em";
$pgv_lang["hs_searchuser"]				= "Ajuda do Membro";
$pgv_lang["hs_searchmodules"]			= "Ajuda em módulos";
$pgv_lang["hs_searchconfig"]			= "Ajuda do administrador";
$pgv_lang["hs_searchhow"]				= "Tipo de pesquisa";
$pgv_lang["hs_searchall"]				= "Todas as palavras";
$pgv_lang["hs_searchany"]				= "Qualquer palavra";
$pgv_lang["hs_searchsentence"]			= "Frase exata";
$pgv_lang["hs_intruehelp"]				= "Somente texto de ajuda";
$pgv_lang["hs_inallhelp"]				= "Texto completo";

// Media import
$pgv_lang["choose"]						= "Escolha:";
$pgv_lang["account_information"]		= "Informação da Conta";

//-- Media item "TYPE" sub-field
$pgv_lang["TYPE__audio"]				= "Áudio";
$pgv_lang["TYPE__book"]					= "Livro";
$pgv_lang["TYPE__card"]					= "Cartão";
$pgv_lang["TYPE__certificate"]			= "Certificado";
$pgv_lang["TYPE__coat"]					= "Escudo de armas";
$pgv_lang["TYPE__document"]				= "Documento";
$pgv_lang["TYPE__electronic"]			= "Eletrônico";
$pgv_lang["TYPE__fiche"]				= "Microficha";
$pgv_lang["TYPE__film"]					= "Microfilme";
$pgv_lang["TYPE__magazine"]				= "Revista";
$pgv_lang["TYPE__manuscript"]			= "Manuscrito";
$pgv_lang["TYPE__map"]					= "Mapa";
$pgv_lang["TYPE__newspaper"]			= "Jornal";
$pgv_lang["TYPE__photo"]				= "Foto";
$pgv_lang["TYPE__tombstone"]			= "Lápide";
$pgv_lang["TYPE__video"]				= "Vídeo";
$pgv_lang["TYPE__painting"] 			= "Pintura";
$pgv_lang["TYPE__other"] 				= "Outro";

//-- Other media suff
$pgv_lang["view_slideshow"]				= "Ver como apresentação de diapositivos";
$pgv_lang["download_image"]				= "Baixar de arquivos";
$pgv_lang["no_media"]					= "Mídia não encontrado";
$pgv_lang["media_privacy"]				= "Restrições de privacidade impedi-lo de ver este item mídia";
$pgv_lang["relations_heading"]			= "A imagem se relaciona com:";
$pgv_lang["file_size"]					= "Tamanho do arquivo";
$pgv_lang["img_size"]					= "Tamanho da imagem";
$pgv_lang["media_broken"]				= "Este arquivo de mídia está quebrado e não pode ser marca d'água";
$pgv_lang["unknown_mime"]				= "Erro de mídia Firewall: &gt;Tipo Mime desconhecido&lt; para o arquivo";

//-- Modules
$pgv_lang["module_error_unknown_action_v2"] = "Ação desconhecida: [action].";
$pgv_lang["module_error_unknown_type"]		= "Tipo de módulo desconhecido.";

//-- sortable tables buttons
$pgv_lang["button_alive_in_year"] 		= "Mostrar pessoas vivos no ano indicado.";
$pgv_lang["button_BIRT_Y100"] 			= "Mostrar pessoas nascidas nos últimos 100 anos.";
$pgv_lang["button_BIRT_YES"]			= "Mostrar pessoas nascidas mais de 100 anos atrás.";
$pgv_lang["button_DEAT_H"]				= "Mostrar casais que apenas o parceiro masculino é falecido.";
$pgv_lang["button_DEAT_N"]				= "Mostrar pessoas que estão vivos ou casais onde ambos os parceiros estão vivos.";
$pgv_lang["button_DEAT_W"]				= "Mostrar casais que apenas o parceiro feminina é falecida.";
$pgv_lang["button_DEAT_Y"]				= "Mostrar pessoas que estão mortas ou casais onde ambos os parceiros estão falecidos.";
$pgv_lang["button_DEAT_Y100"]			= "Mostrar pessoas que morreram nos últimos 100 anos.";
$pgv_lang["button_DEAT_YES"]			= "Mostrar pessoas que morreram mais de 100 anos atrás.";
$pgv_lang["button_MARR_DIV"]			= "Mostrar casais divorciados.";
$pgv_lang["button_MARR_U"]				= "Mostrar casais com data de casamento desconhecido.";
$pgv_lang["button_MARR_Y100"]			= "Mostrar casais que se casaram nos últimos 100 anos.";
$pgv_lang["button_MARR_YES"]			= "Mostrar casais que se casaram mais de 100 anos atrás.";
$pgv_lang["button_reset"]				= "Redefinir aos padrões de lista.";
$pgv_lang["button_SEX_F"]				= "Mostrar só fêmeas.";
$pgv_lang["button_SEX_M"]				= "Mostrar só homens.";
$pgv_lang["button_SEX_U"]				= "Mostrar apenas as pessoas de quem o sexo não é conhecido.";
$pgv_lang["button_TREE_L"]				= "Mostrar casais ou indivíduos «folhas».  Estes são indivíduos que estão vivos, mas não têm filhos registrados no banco de dados.";
$pgv_lang["button_TREE_R"]				= "Mostrar casais ou indivíduos «raízes».  Essas pessoas também podem ser chamados «patriarcas».  São indivíduos que não têm pais registrados no banco de dados.";
$pgv_lang["sort_column"]				= "Ordenar por esta coluna.";
?>
