<?php
/**
 * Russian Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2024  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @translator Eugene Fedorov
 * @translator Natalia Anikeeva
 * @translator Ivan Platonov
 * @translator Google Translate
 * @version $Id: lang.ru.php 7374 2024-02-13 13:57:05Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["birth_M"]				= "День рождения #name#а";		// For male persons
$pgv_lang["birth_F"]				= "День рождения #name#а";		// For female persons
$pgv_lang["born_in_M"]				= "Родился #date# года в #place#";		// For male persons
$pgv_lang["born_in_F"]				= "Родилась #date# года в #place#";		// For female persons
$pgv_lang["born_on_M"]				= "Родился #date#";		// For male persons
$pgv_lang["born_on_F"]				= "Родилась #date#";		// For female persons
$pgv_lang["death_M"]				= "Годовщина смерти #name#";		// For male persons
$pgv_lang["death_F"]				= "Годовщина смерти #name#";		// For female persons
$pgv_lang["died_in_M"]				= "Умер #date# года в #place#";		// For male persons
$pgv_lang["died_in_F"]				= "Умерла #date# года в #place#";		// For female persons
$pgv_lang["died_on_M"]				= "Умер #date#";		// For male persons
$pgv_lang["died_on_F"]				= "Умерла #date#";		// For female persons
$pgv_lang["anniversary_of"]			= "Свадебная годовщина #husband# и #wife#";
$pgv_lang["married_in"]				= "Женат #date# в #place#";
$pgv_lang["married_on"]				= "Женат #date#";
$pgv_lang["clustrmaps_locations"]	= "Расположение посетителей на этой странице";
$pgv_lang["gedcomid"]           = "ID запись индивидуума GEDCOM";
$pgv_lang["sortby"]             = "Последовательность";
$pgv_lang["exact"]			= "Точно";
$pgv_lang["begins_with"]		= "Начинается с";
$pgv_lang["contains"]			= "Содержит";
$pgv_lang["sounds_like"]		= "Звучит как";
$pgv_lang["advanced_search"]		= "Расширенный поиск";
$pgv_lang["more_fields"]		= "Добавить ещё поля";
$pgv_lang["install_step_8"] 		= "Начать";
$pgv_lang["parent_family"]		= "Семья родителей";
$pgv_lang["step_parent_family"]		= "Сводная семья";
$pgv_lang["immediate_family"]           = "Ближайшие родственники";

$pgv_lang["load_full_tree"]			= "вывести это дерево на всю страницу";
$pgv_lang["hide_show_spouses"]		= "Показать или спрятать нескольких супругов";
$pgv_lang["interactive_tree"]		= "Интерактивное дерево";
$pgv_lang["example"]			= "Пример:";
$pgv_lang["tree"]			= "Дерево";

$pgv_lang["showUnknown"]		= "Показать неизвестный пол";
$pgv_lang["count"]			= "Посчитать";
$pgv_lang["age_differences"]		= "Показать разницу дат";
$pgv_lang["multi_site_search"] 		= "Множественный поиск по сайту";
$pgv_lang["switch_lifespan"]		= "Показать временную диаграмму";
$pgv_lang["switch_timeline"]		= "Показать временную диаграмму";
$pgv_lang["differences"]		= "Отличия";
$pgv_lang["charts_block"]		= "Блок диаграмм";
$pgv_lang["charts_block_descr"]		= "Блок диаграмм позволяет вам вставить диаграмму на первую страницу или на страницу портала MyGedView. Вы можете настроить блок для показа предков, потомков или вид песочных часов.  Вы так же можете выбрать основную персону для диаграммы.";
$pgv_lang["charts_click_box"]		= "Кликните на любой из квадратов, чтобы получить больше информации об этой персоне.";
$pgv_lang["chart_type"]			= "Тип диаграммы";
$pgv_lang["changedate1"]			= "Окончание диапазона изменения дат";
$pgv_lang["changedate2"]			= "Начало диапазона изменения дат";
$pgv_lang["search_place_word"] = "Только слово целиком";
$pgv_lang["invalid_search_input"] 	= "Пожалуйста укажите имя, фамилию или место в дополнение к году";
$pgv_lang["duplicate_username"]		= "Пользователь с таким именем уже существует. Выберете другое имя пользователя.";
$pgv_lang["cache_life"]			= "Срок жизни кеша";
$pgv_lang["genealogy"]			= "генеалогия";
$pgv_lang["activate"]			= "Активировать";
$pgv_lang["deactivate"]			= "Дезактивировать";
$pgv_lang["play"]			= "Играть";
$pgv_lang["stop"]			= "Стоп";
$pgv_lang["random_media_start_slide"]	= "Запустить слайд шоу при загрузке страницы?";
$pgv_lang["random_media_ajax_controls"]	= "Показать управление слайд шоу?";
$pgv_lang["description"]		= "Описание";
$pgv_lang["current_dir"]		= "Текущая директория";
$pgv_lang["SHOW_ID_NUMBERS"]		= "Показать ID-номера имен:";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES"]	= "Показывать подсвечивающиеся картинки в квадратах людей";
$pgv_lang["view_img_details"]		= "Показать детали картинки";
$pgv_lang["server_folder"]		= "Имя папки на сервере";
$pgv_lang["medialist_recursive"]	= "Показывать файлы в подкаталогах";
$pgv_lang["media_options"]		= "Опции медиа";
$pgv_lang["confirm_password"]		= "Вы должны ввести пароль ещё раз.";
$pgv_lang["enter_email"]		= "Введите адрес электронной почты.";
$pgv_lang["enter_fullname"]		= "Вы должны ввести имя и фамилию.";
$pgv_lang["name"]			= "Имя";
$pgv_lang["names"]			= "Имена";
$pgv_lang["children"]			= "Дети";
$pgv_lang["lchildren"]			= "дети";
$pgv_lang["child"]			= "Ребенок";
$pgv_lang["grandchildren"]		= "внуки";
$pgv_lang["family"]			= "Семья";
$pgv_lang["as_child"]			= "-я семья<br />в детстве";
$pgv_lang["shared_note_menu"]		= "Опции для общего напоминания";
$pgv_lang["source_menu"]		= "Опции для источника";
$pgv_lang["repo_menu"]			= "Опции для хранилища";
$pgv_lang["other_records"]		= "Записи, ссылающиеся на это хранилище:";
$pgv_lang["other_repo_records"]		= "Другие записи, ссылающиеся на это хранилище:";
$pgv_lang["repo_info"]			= "Информация о хранилище";
$pgv_lang["enter_terms"]		= "Введите ключевое слово для поиска:";
$pgv_lang["search_asso_label"]		= "Коллеги";
$pgv_lang["search_asso_text"]		= "Показать связанных лиц/семей";
$pgv_lang["search_DM"]			= "Дэйч-Мокотофф";
$pgv_lang["search_fams"]		= "Семьи";
$pgv_lang["search_gedcom"]		= "Поиск в базе данных";
$pgv_lang["search_geds"]		= "Базы данных для поиска в ";
$pgv_lang["search_indis"]		= "Люди";
$pgv_lang["search_notes"]		= "Общие заметки";
$pgv_lang["search_inrecs"]		= "Искать";
$pgv_lang["search_prtall"]		= "Все имена";
$pgv_lang["search_prthit"]		= "Имена с хитом";
$pgv_lang["results_per_page"]		= "Результатов на страницу";
$pgv_lang["firstname_search"]		= "Имя";
$pgv_lang["search_prtnames"]		= "Имя индивидуала'<br />для печати:";
$pgv_lang["other_searches"]		= "Другие варианты поиска";
$pgv_lang["add_to_cart"]		= "Вырезать<br />Под-древо";
$pgv_lang["view_gedcom"]		= "Запись в<br />формате GEDCOM";
$pgv_lang["welcome"]			= "Добро пожаловать";
$pgv_lang["son"]			= "Сын";
$pgv_lang["daughter"]			= "Дочь";
$pgv_lang["welcome_page"]		= "Стартовая страница";
$pgv_lang["editowndata"]		= "Мои данные";
$pgv_lang["user_admin"]			= "Управление пользователями";
$pgv_lang["manage_media"]		= "Управление файлами мультимедиа";
$pgv_lang["search_general"]		= "Общий поиск";
$pgv_lang["clipping_privacy"]		= "Некоторые пункты не могут быть добавлены из-за персональных ограничений";
$pgv_lang["chart_new"]			= "Диаграмма Семейного Дерева";
$pgv_lang["loading"]			= "Загружается...";
$pgv_lang["clear_chart"]		= "Очистить диаграмму";
$pgv_lang["file_information"]		= "Информация о файле";
$pgv_lang["choose_file_type"]		= "Тип Файла";
$pgv_lang["add_individual_by_id"]	= "Добавить индивидуала по ID";
$pgv_lang["advanced_options"]		= "Расширенные опции";
$pgv_lang["zip_files"]			= "Zip-файл(ы)";
$pgv_lang["include_media"]		= "Включить медиа (автоматически архивировать файлы)";
$pgv_lang["roman_surn"]			= "Фамилия в транслитерации";
$pgv_lang["roman_givn"]			= "Имена в транслитерации";
$pgv_lang["include"]			= "Добавить:";
$pgv_lang["page_x_of_y"]		= "Страница #GLOBALS[currentPage]# из #GLOBALS[lastPage]#";
$pgv_lang["options"]			= "Опции:";
$pgv_lang["config_update_ok"]		= "Файл конфигурации успешно обновлён.";
$pgv_lang["page_size"]			= "Размер страницы";
$pgv_lang["font"]			= "Шрифт";
$pgv_lang["use_colors"]			= "Использовать цвета";
$pgv_lang["record_not_found"]		= "Запрашиваемая запись GEDCOMне может быть найдена. Причиной этому может быть связь с несуществующей персоной или испоченным файлом GEDCOM.";
$pgv_lang["result_page"]		= "Страница результата";
$pgv_lang["edit_media"]			= "Редактирование медиа-файла (#GLOBALS[pid]#)";
$pgv_lang["wiki_main_page"]		= "Главная страница Wiki";
$pgv_lang["wiki_users_guide"]		= "Инструкция пользователя";
$pgv_lang["wiki_admin_guide"]		= "Инструкция администратора";
$pgv_lang["no_search_for"]		= "Убедитесь, что выбрали опции для поиска.";
$pgv_lang["no_search_site"]		= "Убедитесь, что выбрали по крайней мере один удалённый сайт.";
$pgv_lang["search_sites"] 		= "Сайты для поиска";
$pgv_lang["site_list"]			= "Сайт: ";
$pgv_lang["site_had"]			= " содержит следующее";
$pgv_lang["label_search_engine_detected"]  = "Обнаружен поисковый запрос";

$pgv_lang["ex-spouse"]			= "Бывший(ая) супруг(а)";
$pgv_lang["ex-wife"]			= "Бывшая жена";
$pgv_lang["ex-husband"]			= "Бывший муж";
$pgv_lang["noemail"] 			= "Адреса без электронной почты";
$pgv_lang["onlyemail"] 			= "Только адреса с электронной почтой";
$pgv_lang["maxviews_exceeded"]		= "Превышено максимальное количество #GLOBALS[MAX_VIEWS]# просмотров за  #GLOBALS[MAX_VIEW_TIME]# секунд.";
$pgv_lang["broadcast_not_logged_6mo"]	= "Отправить сообщение пользователям, которые отсутствовали на сайте более 6 месяцев";
$pgv_lang["broadcast_never_logged_in"]	= "Отправить сообщение пользователям, которые никогда не присутствовали на сайте";
$pgv_lang["stats_to_show"]		= "Выбрать статистику для показа в этом блоке";
$pgv_lang["stat_avg_age_at_death"]      = "Средняя продолжительность жизни";
$pgv_lang["stat_longest_life"]          = "Долгожитель";
$pgv_lang["stat_most_children"]         = "Самая многодетная семья";
$pgv_lang["stat_average_children"]      = "Среднее количество детей на семью";
$pgv_lang["stat_events"]		= "Всего событий";
$pgv_lang["stat_media"]			= "Фото и видео файлов";
$pgv_lang["stat_surnames"]		= "Количество фамилий";
$pgv_lang["stat_users"]			= "Количество пользователей";
$pgv_lang["no_family_facts"]		= "Нет фактов для этой семьи.";
$pgv_lang["stat_males"]			= "Мужчин";
$pgv_lang["stat_females"]		= "Женщин";
$pgv_lang["stat_unknown"]		= "Неизвестных";
$pgv_lang["stat_link"]			= "Посмотреть статистику в графиках";
$pgv_lang["print_stat_link"]		= "Показать связь со статистической диаграммой?";

$pgv_lang["sunday_1st"]			= "Вс";
$pgv_lang["monday_1st"]			= "Пн";
$pgv_lang["tuesday_1st"]		= "Вт";
$pgv_lang["wednesday_1st"]		= "Ср";
$pgv_lang["thursday_1st"]		= "Чт";
$pgv_lang["friday_1st"]			= "Пт";
$pgv_lang["saturday_1st"]		= "Сб";

$pgv_lang["jan_1st"]			= "Янв";
$pgv_lang["feb_1st"]			= "Фев";
$pgv_lang["mar_1st"]			= "Мар";
$pgv_lang["apr_1st"]			= "Апр";
$pgv_lang["may_1st"]			= "Май";
$pgv_lang["jun_1st"]			= "Июнь";
$pgv_lang["jul_1st"]			= "Июль";
$pgv_lang["aug_1st"]			= "Авг";
$pgv_lang["sep_1st"]			= "Сен";
$pgv_lang["oct_1st"]			= "Окт";
$pgv_lang["nov_1st"]			= "Ноя";
$pgv_lang["dec_1st"]			= "Дек";

$pgv_lang["edit_source"]		= "Редактировать источник";
$pgv_lang["edit_shared_note"]		= "Редактировать общую заметку";
$pgv_lang["familybook_chart"]		= "Диаграмма ближайших родственников";
$pgv_lang["family_of"]			= "Семь&nbsp;";
$pgv_lang["descent_steps"]		= "Шаги вниз";

$pgv_lang["cancel"]			= "Прервать";
$pgv_lang["cookie_help"]		= "Этот сайт использует технологию Сookie для определения статуса вашей активности на сайте.<br /><br />Похоже, что ваш интернет-обозреватель их не поддерживает.";
//new stuff
//Individual
$pgv_lang["indi_is_remote"]		= "Информация об этом индивидуале связана с удалённым сайтом.";
$pgv_lang["link_remote"]		= "Связать удалённую персону";
//Add Remote Link
$pgv_lang["title_search_link"]		= "Добавить локальную связь";
$pgv_lang["label_site_url2"]		= "Адрес сайта";
//new stuff

$pgv_lang["delete_family_confirm"]	= "Удаление семьи развяжет всех индивидуалов друг от друга, но не оставит их в базе данных. Вы уверены, что хотите удалить эту семью?";
$pgv_lang["delete_family"]		= "Удалить семью";
$pgv_lang["add_favorite"]		= "Добавить нового фаворита";
$pgv_lang["url"]			= "URL";
$pgv_lang["add_fav_enter_note"]		= "Ввести описание об этом фаворите";
$pgv_lang["add_fav_or_enter_url"]	= "или<br />введите URL и заголовок";
$pgv_lang["add_fav_enter_id"]		= "Введите персону, семью или ID источника";
$pgv_lang["next_email_sent"]		= "Следующее напоминание по электронной почте будет выслано после ";
$pgv_lang["last_email_sent"]		= "Последнее напоминание по электронной почте было выслано ";
$pgv_lang["remove_child"]		= "Удалить этого ребёнка из семьи";
$pgv_lang["link_new_husb"]		= "Добавить мужа из существующих в базе данных персон";
$pgv_lang["link_new_wife"]		= "Добавить жену из существующих в базе данных персон";
$pgv_lang["address_labels"]		= "Адреса";
$pgv_lang["filter_address"]		= "Показать адреса, содержащие следующее:";
$pgv_lang["address_list"]		= "Список адресов";
$pgv_lang["index_edit_advice"]		= "Выделите имя блока, затем кликните одну из стрелок, чтобы переместить выделенный блок в выбранном направлении.";
$pgv_lang["changelog"]			= "Изменения версии #VERSION#";
$pgv_lang["html_block_descr"]		= "Это простой HTML блок, который можно вставить на вашу страницу, чтобы добавить любое сообщение, которое вы хотите.";
$pgv_lang["html_block_sample_part1"]	= "<p class=\"blockhc\"><b>Введите здесь ваш заголовок</b></p><br /><p>Кликните кнопку настройки";
$pgv_lang["html_block_sample_part2"]	= "чтобы изменить то, что здесь напечатано.</p>";
$pgv_lang["html_block_name"]		= "HTML";
$pgv_lang["htmlplus_block_name"]	= "Расширенный HTML";
$pgv_lang["htmlplus_block_descr"]	= "Это HTML блок, который можно вставить на вашу страницу, чтобы добавить любое сообщение, которое вы хотите. Вы можете вставить ссылки на информацию с вашей GEDCOM в текст HTML.";
$pgv_lang["htmlplus_block_templates"]	= "Шаблоны";
$pgv_lang["htmlplus_block_content"]	= "Содержимое";
$pgv_lang["htmlplus_block_narrative"] = "Стиль повествования (Только на английском)";
$pgv_lang["htmlplus_block_custom"]	= "Обычный";
$pgv_lang["htmlplus_block_keyword"]	= "Примеры ключевых слов (Только на английском)";
$pgv_lang["htmlplus_block_taglist"]	= "Список признаков";
$pgv_lang["htmlplus_block_compat"]	= "Режим совместимости";
$pgv_lang["htmlplus_block_ui"]		= "Расширенный интерфейс";
$pgv_lang["htmlplus_block_current"]	= "Текущий";
$pgv_lang["htmlplus_block_default"]	= "По умолчанию";
$pgv_lang["htmlplus_block_gedcom"]	= "Семейное дерево";
$pgv_lang["htmlplus_block_birth"]	= "рождение";
$pgv_lang["htmlplus_block_death"]	= "смерть";
$pgv_lang["htmlplus_block_marrage"]	= "брак";
$pgv_lang["htmlplus_block_adoption"]= "усыновление";
$pgv_lang["htmlplus_block_burial"]	= "похороны";
$pgv_lang["htmlplus_block_census"]	= "добавлена перепись";
$pgv_lang["num_to_show"]		= "Количество пунктов для показа";
$pgv_lang["days_to_show"]		= "Количество дней для показа";
$pgv_lang["before_or_after"]		= "Место рассчитать до или после имени?";
$pgv_lang["before"]			= "до";
$pgv_lang["after"]			= "после";
$pgv_lang["config_block"]		= "Настроить";
$pgv_lang["enter_comments"]		= "Пожалуйста введите вашу связь с датой в поле Комментариев.";
$pgv_lang["comments"]			= "Комментарии";
$pgv_lang["child-family"]		= "Родители и сибсы";
$pgv_lang["spouse-family"]		= "Супруг(а) и дети";
$pgv_lang["direct-ancestors"]		= "Прямая линия предков";
$pgv_lang["ancestors"]			= "Прямая линия предков и их семей";
$pgv_lang["descendants"]		= "Потомки";
$pgv_lang["choose_relatives"]		= "Выбрать родственников";
$pgv_lang["relatives_report"]		= "Отчёт по родственникам";
$pgv_lang["total_unknown"]		= "Неизвестных";
$pgv_lang["total_living"]		= "Живущих";
$pgv_lang["total_dead"]			= "Умерших";
$pgv_lang["total_not_born"]		= "Мертворожденных";
$pgv_lang["remove_custom_tags"]		= "Удалить собственные PGV включения? (к примеру _PGVU, _THUM)";
$pgv_lang["cookie_login_help"]		= "Этот сайт запомнил вас с прошлого входа. Это позволяет вам получить доступ к личной информации и другой, основанной на пользовательский опциях, но в случае редактирования или администрирования сайта, вы должны войти снова для предотвращения атак из вне.";
$pgv_lang["remember_me"]		= "Запомнить меня на этом компьютере?";
$pgv_lang["fams_with_surname"]		= "Семьи с фамилией #surname#";
$pgv_lang["support_contact"]		= "Контакт технической помощи";
$pgv_lang["genealogy_contact"]		= "Контакт по Генеалогии";
$pgv_lang["common_upload_errors"]	= "Эта ошибка возможно означает, что вы пытаетесь загрузить файл, размер которого превышает ограничение на максимальный объем файла. Стандартное ограничение для загрузки в PHP - 2MB. Вы можете связаться с администратором сервиса для увеличения лимита загрузки в файле php.ini или Вы можете загрузить файл через FTP. Воспользуйтесь страницей <a href=\"uploadgedcom.php?action=add_form\"><b>Add GEDCOM</b></a> для добавления файла GEDCOM, который вы загрузили при помощи FTP.";
$pgv_lang["total_memory_usage"]		= "Всего используемой памяти:";
$pgv_lang["mothers_family_with"]	= "Семья матери с ";
$pgv_lang["fathers_family_with"]	= "Семья отца с ";
$pgv_lang["family_with"]		= "Семья и";
$pgv_lang["halfsibling"]		= "Сводный сибс";
$pgv_lang["halfbrother"]		= "Сводный брат";
$pgv_lang["halfsister"]			= "Сводная сестра";
$pgv_lang["family_timeline"]		= "Показать семью на временной диаграмме";
$pgv_lang["children_timeline"]		= "Показать детей на временной диаграмме";
$pgv_lang["other"]			= "Другой";
$pgv_lang["others"]			= "Другие";
$pgv_lang["sort_by_marriage"]		= "Сортировать по дате брака";
$pgv_lang["reorder_families"]		= "Перестроить семьи";
$pgv_lang["indis_with_surname"]		= "Индивидуалы с фамилией #surname#";
$pgv_lang["first_letter_name"]		= "Выберите букву, чтобы отобразить семьи, у которых имя начинается с этой буквы.";
$pgv_lang["first_letter_sfname"]	= "Выберите букву, чтобы отобразить семьи, у которых супруг(а) имеет имя, начинающееся с этой буквы.";
$pgv_lang["first_letter_iname"]		= "Выберите букву, чтобы отобразить те семьи, у которых фамилия начинается с этой буквы.";
$pgv_lang["first_letter_fname"]		= "Выберите букву, чтобы отобразить индивидуалов, у которых имя начинается с этой буквы.";
$pgv_lang["total_names"]		= "Всего имён";
$pgv_lang["total_changes"]		= "Всего изменений";
$pgv_lang["total_links"]		= "Всего ссылок";
$pgv_lang["top10_pageviews_nohits"]	= "На сегодняшний момент нет хитов для просмотра.";
$pgv_lang["top10_pageviews_msg"]	= "Счётчик хитов должен быть включен в конфигурации GEDCOM, в разделе отображения и расположения, в группе отобразить и скрыть.";
$pgv_lang["review_changes_descr"]	= "Блок со списком изменений даёт возможность пользователям, у которых есть права редактирования файла GEDCOM, просмотреть изменения, внесённые на сайте и всё ещё нуждающиеся в просмотре и применении. Эти изменения ожидают применения или отклонения.<br /><br />Если этот блок активирован, то пользователи с правами применения изменений получат письмо по электронной почте раз в день, напоминающее о том, что им необходимо просмотреть изменения.";
$pgv_lang["review_changes_block"]	= "Ожидание изменений";
$pgv_lang["review_changes_email"]	= "Отправить напоминание по электронной почте?";
$pgv_lang["review_changes_email_freq"]	= "Частота напоминаний по электронной почте (дней)";
$pgv_lang["review_changes_subject"]	= "PhpGedView - Просмотреть изменения";
$pgv_lang["review_changes_body"]	= "Произведены изменения генеалогической базы данных на сайте. Эти изменения необходимо просмотреть и принять перед тем, чтобы все пользователи смогли увидеть эти изменения. Пожалуйста используйте ссылку ниже, чтобы войти на сайт и просмотреть изменения.";
$pgv_lang["show_pending"]		= "Отобразить ожидаемые изменения";
$pgv_lang["show_spouses"]		= "Показать супругов";
$pgv_lang["quick_update_title"]		= "Быстрое обновление";
$pgv_lang["quick_update_instructions"]	= "Эта страница позволяет вам быстро изменить информацию об индивидуале. Вам только необходимо заполнить новую или обновлённую информацию по отношению к уже имеющейся в базе данных. После ваших изменений, администратор должен просмотреть обновления, перед тем как они станут видимы всем пользователям.";
$pgv_lang["update_name"]		= "Обновить имя";
$pgv_lang["update_fact"]		= "Обновить факт";
$pgv_lang["update_fact_restricted"]	= "Обновить, если этот факт запрещённый:";
$pgv_lang["select_fact"]		= "Выбрать факт...";
$pgv_lang["update_address"]		= "Обновить адрес";
$pgv_lang["top10_pageviews_descr"]	= "Этот блок отображает 10 самых просматриваемых записей. Этот блок требует включение счётчика хитов в конфигурации GEDCOM.";
$pgv_lang["top10_pageviews"]		= "Наиболее просматриваемые пункты";
$pgv_lang["top10_pageviews_block"]	= "Наиболее просматриваемые пункты";
$pgv_lang["stepparent"]			= "Сводные родители";
$pgv_lang["stepdad"]			= "Отчим";
$pgv_lang["stepmom"]			= "Мачеха";
$pgv_lang["stepsister"]			= "Сводная сестра";
$pgv_lang["stepbrother"]		= "Сводный брат";
$pgv_lang["fams_charts"]		= "Опции семьи";
$pgv_lang["indis_charts"]		= "Опции индивидуума";
$pgv_lang["none"]			= "Нет";
$pgv_lang["facts"]			= "Факты";
$pgv_lang["locked"]			= "Не изменять";
$pgv_lang["privacy"]			= "Частная";
$pgv_lang["number_sign"]		= "№";

//-- GENERAL HELP MESSAGES
$pgv_lang["qm"]				= "?";
$pgv_lang["qm_ah"]				= "?";
$pgv_lang["page_help"]			= "Помощник";
$pgv_lang["help_for_this_page"]		= "Помощь по этой странице";
$pgv_lang["help_contents"]		= "Контекстная помощь";
$pgv_lang["show_context_help"]		= "Показать контекстную помощь";
$pgv_lang["hide_context_help"]		= "Спрятать контекстную помощь";
$pgv_lang["sorry"]			= "<b>Извините, текст помощи об этой странице или объекте пока еще не закончен.</b>";
$pgv_lang["help_not_exist"]		= "<b>Текст помощи об этой странице или объекте пока не готов.</b>";
$pgv_lang["var_not_exist"]		= "<span style=\"font-weight: bold\">Языковая переменная не определена. Пожалуйста напишите администратору об этой ошибке.</span>";
$pgv_lang["resolution"]			= "Разрешение экрана";
$pgv_lang["menu"]				= "Меню";
$pgv_lang["header"]				= "Заголовок";
$pgv_lang["imageview"]			= "Обозреватель изображений";

//-- CONFIG FILE MESSAGES
$pgv_lang["login_head"]			= "PhpGedView Вход Пользователя";
$pgv_lang["for_support"]		= "За помощью и информацией просьба обращаться по адресу";
$pgv_lang["for_contact"]		= "С вопросами по генеалогии (база данных) обращаться по адресу";
$pgv_lang["for_all_contact"]		= "С вопросами по базе данных и по сайту обращаться по адресу";
$pgv_lang["choose_username"]		= "Выберите желаемое имя пользователя";
$pgv_lang["username"]			= "Имя пользователя:";
$pgv_lang["invalid_username"]		= "Имя пользователя имеет недопустимые символы.";
$pgv_lang["firstname"]			= "Имя";
$pgv_lang["lastname"]			= "Фамилия";
$pgv_lang["choose_password"]		= "Желаемый пароль";
$pgv_lang["password"]			= "Пароль:";
$pgv_lang["confirm"]			= "Подтверждение пароля";
$pgv_lang["login"]			= "Вход в программу";
$pgv_lang["logout"]			= "Выход из программы";
$pgv_lang["admin"]			= "Администрирование";
$pgv_lang["logged_in_as"]		= "Вы зарегистрированы как";
$pgv_lang["my_pedigree"]		= "Мое восходящее дерево";
$pgv_lang["my_indi"]			= "Я";
$pgv_lang["yes"]			= "Да";
$pgv_lang["no"]				= "Нет";
$pgv_lang["change_theme"]		= "Изменить тему";

//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]		= "Восходящее Древо";
$pgv_lang["gen_ped_chart"]		= "Восходящее Древо из \$PEDIGREE_GENERATIONS поколений";
$pgv_lang["generations"]		= "Поколения:";
$pgv_lang["view"]			= "Показать";
$pgv_lang["fam_spouse"]			= "Семья с супругом:";
$pgv_lang["rootid"] 			= "Самая ранняя персона диаграммы родословной";
$pgv_lang["root_person"]		= "Начинать с персоны под номером ID:";
$pgv_lang["hide_details"]		= "Спрятать детали";
$pgv_lang["show_details"]		= "Показать детали";
$pgv_lang["zoom_box"]			= "Более расширенные/менее расширенные данные.";
$pgv_lang["orientation"]		= "Ориентация";
$pgv_lang["portrait"]			= "Вертикально";
$pgv_lang["landscape"]			= "Горизонтально";
$pgv_lang["landscape_top"]		= "Старший на верх";
$pgv_lang["landscape_down"]		= "Старший вниз";
$pgv_lang["start_at_parents"]		= "Идти на родителей";
$pgv_lang["charts"]			= "Чертежи";
$pgv_lang["lists"]			= "Списки";
$pgv_lang["box_width"] 			= "Ширина рамки";
$pgv_lang["random_surn"]		= "Хаотическая фамилия";
$pgv_lang["generation_number"]		= "Поколений";

//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"]	= "Невозможно найти Семью под номером ID:";
$pgv_lang["unable_to_find_record"]	= "Невозможно найти Запись под номером ID:";
$pgv_lang["title"]			= "Заголовок:";
$pgv_lang["living"]			= "Сведения недоступны";
$pgv_lang["private"]			= "Личные сведения (priv&eacute);";
$pgv_lang["birth"]			= "Рождение: ";
$pgv_lang["death"]			= "Кончина: ";
$pgv_lang["descend_chart"]		= "Нисходящее Древо";
$pgv_lang["individual_list"]		= "Список лиц";
$pgv_lang["family_list"]		= "Список семей";
$pgv_lang["branch_list"]		= "Ветви";
$pgv_lang["source_list"]		= "Список источников";
$pgv_lang["shared_note_list"]		= "Общие заметки";
$pgv_lang["place_list"]			= "Список мест";
$pgv_lang["place_list_aft"] 		= "Разместите иерархию после";
$pgv_lang["media_list"]			= "Список фото/аудио/видео";
$pgv_lang["repo_list"]			= "Хранилище";
$pgv_lang["search"]			= "Поиск";
$pgv_lang["clippings_cart"]		= "Вырезать под-древо";
$pgv_lang["print_preview"]		= "Просмотр для печати";
$pgv_lang["cancel_preview"]		= "Назад к нормальному виду";
$pgv_lang["change_lang"]		= "Изменить язык";
$pgv_lang["print"]			= "Печатать";
$pgv_lang["total_queries"]		= "Количество вопросов по базе данных:";
$pgv_lang["total_privacy_checks"]	= "Полная проверка доступа:";
$pgv_lang["back"]			= "Назад";

//-- INDIVUDUAL FILE MESSAGES
$pgv_lang["aka"]			= "Прозвище";
$pgv_lang["male"]			= "Муж.";
$pgv_lang["males"]			= "Мужчин";
$pgv_lang["female"]			= "Жен.";
$pgv_lang["females"]			= "Женщин";
$pgv_lang["temple"]			= "Храм мормонов";
$pgv_lang["temple_code"]		= "Код Храма мормонов:";
$pgv_lang["status"]			= "Статус";
$pgv_lang["source"]			= "Источник:";
$pgv_lang["text"]			= "Текст:<br />";
$pgv_lang["note"]			= "Примечание:";
$pgv_lang["NN"] 			= "(Фамилия неизвестна)";
$pgv_lang["PN"] 			= "(Имя неизвестно)";
$pgv_lang["NNPN"] 			= "(Фамилия и имя неизвестны)";
// $pgv_lang["NNhebrew"] 		use value from lang.en.php
// $pgv_lang["PNhebrew"] 		use value from lang.en.php
// $pgv_lang["NNPNhebrew"] 		use value from lang.en.php
// $pgv_lang["NNarabic"] 		use value from lang.en.php
// $pgv_lang["PNarabic"] 		use value from lang.en.php
// $pgv_lang["NNPNarabic"] 		use value from lang.en.php
// $pgv_lang["NNgreek"] 		use value from lang.en.php
// $pgv_lang["PNgreek"] 		use value from lang.en.php
// $pgv_lang["NNPNgreek"] 		use value from lang.en.php
// $pgv_lang["NNrussian"] 		use value from lang.en.php
// $pgv_lang["PNrussian"] 		use value from lang.en.php
// $pgv_lang["NNPNrussian"] 	use value from lang.en.php
// $pgv_lang["NNchinese"] 		use value from lang.en.php
// $pgv_lang["PNchinese"] 		use value from lang.en.php
// $pgv_lang["NNPNchinese"] 	use value from lang.en.php
// $pgv_lang["NNvietnamese"] 	use value from lang.en.php
// $pgv_lang["PNvietnamese"] 	use value from lang.en.php
// $pgv_lang["NNPNvietnamese"] 	use value from lang.en.php
// $pgv_lang["NNthai"] 			use value from lang.en.php
// $pgv_lang["PNthai"] 			use value from lang.en.php
// $pgv_lang["NNPNthai"] 		use value from lang.en.php
$pgv_lang["NNother"] 		= "(Фамилия неизвестна)";
$pgv_lang["PNother"] 		= "(Имя неизвестно)";
$pgv_lang["NNPNother"] 		= "(Фамилия и имя неизвестны)";
$pgv_lang["unrecognized_code"]		= "Неопознанный тэг GEDCOM";
$pgv_lang["unrecognized_code_msg"]	= "Ошибка, надо бы ее исправить. Пожалуйста, сообщите об ошибке";
$pgv_lang["indi_info"]			= "Персональные сведения";
$pgv_lang["pedigree_chart"]		= "Восходящее<br />Древо";
$pgv_lang["individual"]			= "Индивидуал";
$pgv_lang["as_spouse"]			= "-я семья<br />в браке";
$pgv_lang["privacy_error"]	    	= "Детальные сведения об этой персоне являются личными";
$pgv_lang["more_information"]		= "Более полную информацию получить здесь";
$pgv_lang["given_name"]			= "Имя, отчество (имена):";
$pgv_lang["surname"]			= "Фамилия:";
$pgv_lang["suffix"]			= "Суффикс:";
$pgv_lang["sex"]			= "Пол:";
$pgv_lang["personal_facts"]		= "Подробности биографии";
$pgv_lang["type"]			= "Тип";
$pgv_lang["parents"] 			= "Родители:";
$pgv_lang["gparents"]			= "Дедушки/бабушки";
$pgv_lang["siblings"] 			= "Братья/сестры";
$pgv_lang["father"] 			= "Отец";
$pgv_lang["mother"] 			= "Мать";
$pgv_lang["parent"] 			= "Родитель";
$pgv_lang["parent_age"] 		= "Возраст родителя";
$pgv_lang["father_age"]			= "Возраст отца";
$pgv_lang["mother_age"]			= "Возраст матери";
$pgv_lang["self"] 			= "Я";
$pgv_lang["relatives"]			= "Родство";
$pgv_lang["relatives_events"]		= "События близких родственников";
$pgv_lang["historical_facts"]		= "Исторические факты";
$pgv_lang["partner"]			= "Партнёр";
$pgv_lang["spouse"]			= "Супруг(а)";
$pgv_lang["spouses"] 			= "Супруги";
$pgv_lang["surnames"]			= "Фамилии";
$pgv_lang["adopted"]			= "Усыновлен/удочерена";
$pgv_lang["foster"]			= "Приемный (не родной по крови)";
$pgv_lang["sealing"]			= "Закреплено документом";
$pgv_lang["challenged"]			= "Оспоренный";
$pgv_lang["disproved"]			= "Опровергнут";
$pgv_lang["infant"]			= "Младенец";
$pgv_lang["stillborn"]			= "Мертворожденный";
$pgv_lang["deceased"]			= "Умерший";
$pgv_lang["link_as_wife"]		= "Связать эту персону к существующей семье в качестве жены";
$pgv_lang["no_tab1"]			= "Для этой персоны нет фактов.";
$pgv_lang["no_tab2"]			= "Для этой персоны нет заметок.";
$pgv_lang["no_tab3"]			= "Для этой персоны нет источников цитирования.";
$pgv_lang["no_tab4"]			= "Для этой персоны нет медиа-объектов.";
$pgv_lang["no_tab5"]			= "Нет закрытых родственных отношений для этой персоны.";
$pgv_lang["no_tab6"]			= "Никаких исследовательских записей не присоединено к персоне.";
$pgv_lang["show_fact_sources"]		= "Показать все источники";
$pgv_lang["show_fact_notes"]		= "Показать все заметки";

//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"]		= "Сведения о семье";
$pgv_lang["family_group_info"]		= "Сведения о семье";
$pgv_lang["husband"]			= "Супруг:";
$pgv_lang["wife"]			= "Супруга:";
$pgv_lang["marriage"]			= "Брак:";
$pgv_lang["lds_sealing"]		= "Печать мормонов:";
$pgv_lang["marriage_license"]		= "Разрешение на брак:";
$pgv_lang["no_children"]		= "Нет детей";
$pgv_lang["known_child"]		= "1 ребёнок";
$pgv_lang["known_children"]		= "дети";
$pgv_lang["childless_family"]		= "Эта семья осталась бездетной";
$pgv_lang["parents_timeline"]		= "Показать супругов<br />на временной оси";

//-- CLIPPINGS FILE MESSAGES
$pgv_lang["clip_cart"]			= "Вырезание Под-древа";
$pgv_lang["which_links"]		= "Каких родственников этой семьи Вы желали бы добавить?";
$pgv_lang["just_family"]		= "Добавить запись лишь об этой семье.";
$pgv_lang["parents_and_family"]		= "Добавить записи о родителях вместе с записью об этой семье.";
$pgv_lang["parents_and_child"]		= "Добавить записи о родителях и детях вместе с записью об этой семье.";
$pgv_lang["parents_desc"]		= "Добавить записи о родителях и всех потомках вместе с записью об этой семье.";
$pgv_lang["continue"]			= "Продолжить добавление";
$pgv_lang["which_p_links"]		= "Каких родственников этого лица Вы желали бы добавить?";
$pgv_lang["just_person"]		= "Добавить запись лишь об этом лице.";
$pgv_lang["person_parents_sibs"]	= "Добавить записи об этом лице, его родителях, братьях и сестрах.";
$pgv_lang["person_ancestors"]		= "Добавить записи об этом лице и о всех его прямых предках.";
$pgv_lang["person_ancestor_fams"]	= "Добавить записи об этом лице, о всех его прямых предках и об их семьях.";
$pgv_lang["person_spouse"]		= "Добавить записи об этом лице, его супруге и детях.";
$pgv_lang["person_desc"]		= "Добавить записи об этом лице, его супруге и всех потомках.";
$pgv_lang["which_s_links"]		= "Какие из записей от этого источника необходимо добавить?";
$pgv_lang["just_source"]		= "Просто добавить этот источник.";
$pgv_lang["linked_source"]		= "Добавить этот источник и семьи/людей, связанные с этим.";
$pgv_lang["person_private"]		= "Детальные данные об этом лице являются личными. <br />Персональные сведения не доступны и включены не будут.";
$pgv_lang["family_private"]		= "Детальные данные об этой семье являются личными. Персональные сведения об этой семье недоступны и включены не будут.";
$pgv_lang["media_private"] 		= "Детали этого медиа скрыты от посторонних глаз. Медиа детали не будут включены.";
$pgv_lang["download"]			= "Щелкните правой кнопкой мыши на нижеследующую ссылку и выберите &quot;Сохранить как&quot; для загрузки файла.";
$pgv_lang["cart_is_empty"]		= "Ваша корзина пуста.";
$pgv_lang["id"]				= "Идентификационный номер";
$pgv_lang["ID"]				= "Идентификационный номер";
$pgv_lang["name_description"]		= "Название / Описание";
$pgv_lang["remove"]			= "Убрать";
$pgv_lang["empty_cart"]			= "Освободить корзину";
$pgv_lang["download_now"]		= "Загрузить файл";
$pgv_lang["download_file"]		= "Загрузить файл #GLOBALS[whichFile]#";
$pgv_lang["indi_downloaded_from"]	= "Данные об этом лице загружены из:";
$pgv_lang["family_downloaded_from"]	= "Данные об этой семье загружены из:";
$pgv_lang["source_downloaded_from"]	= "Источник этой информации загружен из:";
$pgv_lang["enter_person_generations"]	= "Число поколений:";
$pgv_lang["convertPath"]		= "Поменять путь до медиа на";
$pgv_lang["convertSlashes"]		= "Поменять разделители папок медиа на";
$pgv_lang["forwardSlashes"]		= "Косая черта : /";
$pgv_lang["backSlashes"]		= "Обратная косая черта : \\";

//-- PLACELIST FILE MESSAGES
$pgv_lang["connections"]		= "Географическая связь найдена<br />посмотреть результаты";
$pgv_lang["top_level"]			= "Верхний уровень";
$pgv_lang["form"]			= "Географические названия стоят в следующем порядке: ";
$pgv_lang["default_form"]		= "населенный пункт, уезд/район(уездн./рай. центр), губерния/область(губ./обл. центр)/штат, страна";
$pgv_lang["default_form_info"]		= "(стандарт)";
$pgv_lang["unknown"]			= "Неизвестно";
$pgv_lang["individuals"]		= "Список лиц";
$pgv_lang["view_records_in_place"]	= "Посмотреть список всех лиц, проживавших тут";
$pgv_lang["place_list2"] 			= "Список мест";
$pgv_lang["show_place_hierarchy"]	= "Показать иерархию мест";
$pgv_lang["show_place_list"]		= "Показать все места в виде списка.";
$pgv_lang["total_unic_places"]		= "Полностью уникальные места";

//-- MEDIALIST FILE MESSAGES
$pgv_lang["external_objects"]		= "Внешние объекты";
$pgv_lang["multi_title"]		= "Список фото/аудио/видео объектов";
$pgv_lang["media_found"]		= "фото/аудио/видео объекты найдены";
$pgv_lang["view_person"]		= "Смотреть сведения о лице";
$pgv_lang["view_family"]		= "Смотреть сведения о семье";
$pgv_lang["view_source"]		= "Смотреть источник";
$pgv_lang["view_object"]		= "Посмотреть объекты";
$pgv_lang["first_page"]				= "Первая страница";
$pgv_lang["previous_page"]			= "Предыдущая страница";
$pgv_lang["next_page"]				= "Следущая страница";
$pgv_lang["last_page"]				= "Последняя страница";
$pgv_lang["next_image"]			= "Следующая картинка";
$pgv_lang["file_not_found"]		= "Файл не найден.";
$pgv_lang["medialist_show"] 		= "Показать";
$pgv_lang["per_page"]			= "медиа-объектов на странице";
$pgv_lang["media_format"]		= "Формат медиа";
$pgv_lang["image_size"]			= "Размеры картинки";
$pgv_lang["media_id"]			= "ID медиа файла";
$pgv_lang["invalid_id"]			= "Такого ID не найдено в файле GEDCOM.";
$pgv_lang["record_updated"]		= "Запись #pid# успешно обновлена.";
$pgv_lang["record_not_updated"]		= "Запись #pid# не может быть обновлена.";
$pgv_lang["record_removed"]		= "Запись #xref# успешно удалена из GEDCOM.";
$pgv_lang["record_not_removed"]		= "Запись #xref# не может быть удалена из GEDCOM.";
$pgv_lang["record_added"]		= "Запись #xref# успешно добавлена в GEDCOM.";
$pgv_lang["record_not_added"]		= "Запись #xref# не может быть добавлена в GEDCOM.";

//-- SEARCH FILE MESSAGES
$pgv_lang["soundex_search"]		= "Фонетический поиск по фамилии (Soundex):";
$pgv_lang["sources"]			= "Источники";
$pgv_lang["shared_notes"]		= "Общие заметки";
$pgv_lang["lastname_search"]		= "Фамилия:";
$pgv_lang["search_place"]		= "Место:";
$pgv_lang["search_year"]		= "Год:";
$pgv_lang["no_results"]			= "Информация по запросу не найдена";
$pgv_lang["search_soundex"]		= "Созвучный поиск";
$pgv_lang["search_replace"]		= "Найти и заменить";
$pgv_lang["search_sources"]		= "Источники";
$pgv_lang["search_shared_notes"]	= "Общие заметки";
$pgv_lang["search_more_chars"]		= "Пожалуйста введите более одного символа";
$pgv_lang["search_soundextype"]		= "Созвучный тип:";
$pgv_lang["search_russell"]		= "Основной";
$pgv_lang["search_tagfilter"]		= "Исключить фильтр";
$pgv_lang["search_tagfon"]		= "Исключить некоторую не генеалогическую информацию";
$pgv_lang["search_tagfoff"]		= "Выключить";
$pgv_lang["associate"]			= "ассоциировать";
$pgv_lang["search_record"]		= "Вся запись";
$pgv_lang["search_to"]			= "в";

//-- SOURCELIST FILE MESSAGES
$pgv_lang["titles_found"]		= "Заголовки";
$pgv_lang["find_source"]		= "Найти источник";

//-- REPOLIST FILE MESSAGES
$pgv_lang["repository"] 		= "Хранилище";
$pgv_lang["repos_found"]		= "Найдены хранилища";
$pgv_lang["find_repository"]		= "Поискать хранилища";
$pgv_lang["total_repositories"]		= "Всего хранилищей";
$pgv_lang["confirm_delete_repo"]	= "Вы уверены, что хотите удалить данное хранилище?";

//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]		= "Информация по источнику";
$pgv_lang["people"]			= "ЛИЦА";
$pgv_lang["families"]			= "СЕМЬИ";
$pgv_lang["total_sources"]		= "Общие источники";

//-- SHARED NOTE FILE MESSAGES
$pgv_lang["shared_note"]		= "Общая заметка";
$pgv_lang["shared_notes_found"]		= "Найдена общая заметка";
$pgv_lang["find_shared_note"]		= "Найти общую заметку";
$pgv_lang["shared_note_info"]		= "Информация об общей заметке";
$pgv_lang["total_shared_notes"]		= "Всего общих заметок";

//-- BUILDINDEX FILE MESSAGES
$pgv_lang["invalid_gedformat"]		= "Неправильный формат GEDCOM";
$pgv_lang["exec_time"]			= "Общее время исполнения:";
$pgv_lang["unable_to_create_index"]	= "Невозможно создать индексный файл. Задайте разрешение на запись для оглавления PhpGedViewDirectory. Запрет может быть восстановлен после записи индексных файлов.";
$pgv_lang["changes_present"]		= "Необходимо просмотреть изменения GEDCOM. Если вы продолжите импорт, то эти изменения не зачтутся. Вам необходимо просмотреть изменения перед импортом.";
$pgv_lang["sec"]				= "сек.";

//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$pgv_lang["total_fams"]			= "семей всего";
$pgv_lang["total_indis"]		= "лиц всего";
$pgv_lang["notes"]			= "Заметки";
$pgv_lang["ssourcess"]			= "Источники";
$pgv_lang["media"]			= "Медиа";
$pgv_lang["name_contains"]		= "Имя состоит из:";
$pgv_lang["filter"]			= "Фильтр";
$pgv_lang["apply_filter"]		= "Применить фильтр";
$pgv_lang["find_individual"]		= "Искать лицо с номером ID";
$pgv_lang["find_familyid"]		= "Найти Id семьи";
$pgv_lang["find_sourceid"]		= "Найти ID источника";
$pgv_lang["find_specialchar"]		= "Найти специальные символы";
$pgv_lang["magnify"]			= "Увеличить";
$pgv_lang["skip_surnames"]		= "Пропустить лист списка фамилий";
$pgv_lang["show_surnames"]		= "Показать список фамилий";
$pgv_lang["skip_marnms"]		= "Исключить имена после брака";
$pgv_lang["show_marnms"]		= "Включить имена после брака";
$pgv_lang["all"]			= "ВСЕ";
$pgv_lang["hidden"]			= "Скрытый";
$pgv_lang["confidential"]		= "Конфиденциально";
$pgv_lang["alpha_index"]		= "Индекс по алфавиту";
$pgv_lang["name_list"] 			= "Список имён";
$pgv_lang["firstname_alpha_index"] 	= "Алфавитный индекс по имени";
$pgv_lang["roots"]		 	= "Корни";
$pgv_lang["leaves"] 			= "Листья";
$pgv_lang["widow"] 			= "Вдова";
$pgv_lang["widower"] 			= "Вдовец";
$pgv_lang["show_parents"] 		= "Показать родителей";

//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]			= "Возраст: ";
$pgv_lang["husb_age"]			= "Возраст мужа";
$pgv_lang["wife_age"]			= "Возраст жены";
$pgv_lang["year1"]			= "год";
$pgv_lang["years2"]			= "лет";      // For Polish 2,3,4 or 22,23,24 or 32,33,34 etc.
$pgv_lang["years"]			= "лет";
$pgv_lang["month1"]			= "месяц";
$pgv_lang["months"]			= "месяцев";
$pgv_lang["week1"]			= "неделя";
$pgv_lang["weeks"]			= "недель";
$pgv_lang["day1"]			= "день";
$pgv_lang["days"]			= "дней";
$pgv_lang["after_death"]        	= "после смерти";
$pgv_lang["at_death_day"]      		= "в день смерти";
$pgv_lang["timeline_title"]		= "Временная ось PhpGedView";
$pgv_lang["timeline_chart"]		= "Временная ось";
$pgv_lang["remove_person"]		= "Удалить персону";
$pgv_lang["show_age"]			= "Включить указатель возраста";
$pgv_lang["add_another"]		= "Добавить еще одно лицо<br />Идентификационный номер:";
$pgv_lang["find_id"]			= "Найти идент. номер";
$pgv_lang["show"]			= "Показать";
$pgv_lang["year"]			= "Год: ";
$pgv_lang["zoom_in"]			= "Расширить информацию<br />";
$pgv_lang["zoom_out"]			= "Сжать информацию";
$pgv_lang["timeline_beginYear"]		= "Начало года";
$pgv_lang["timeline_endYear"]		= "Конец года";
$pgv_lang["timeline_scrollSpeed"]	= "Скорость";
$pgv_lang["timeline_controls"]		= "Управление временной линией";
$pgv_lang["include_family"]		= "Включить близких родственников";
$pgv_lang["lifespan_chart"]		= "Временная диаграмма";

// calendar conversion options
$pgv_lang["cal_none"]                 = "Без конвертации календаря";
$pgv_lang["cal_gregorian"]            = "Григорианский";
$pgv_lang["cal_julian"]               = "Юлианский";
$pgv_lang["cal_french"]               = "Французский";
$pgv_lang["cal_jewish"]               = "Еврейский";
$pgv_lang["cal_hebrew"]               = "Иврит (древнееврейский)";
$pgv_lang["cal_jewish_and_gregorian"] = "Еврейский и Григорианский";
$pgv_lang["cal_hebrew_and_gregorian"] = "Иврит и Григорианский";
$pgv_lang["cal_hijri"]                = "Хиджре";
$pgv_lang["cal_arabic"]               = "Арабский";

// some religious dates
$pgv_lang["easter"]     		= "Пасха";
$pgv_lang["ascension"]  		= "Вознесение";
$pgv_lang["pentecost"]  		= "Пятидесятница";
$pgv_lang["assumption"] 		= "Успение";
$pgv_lang["all_saints"] 		= "Всех святых";
$pgv_lang["christmas"]  		= "Рождество";

// am/pm suffixes for 12 hour clocks
$pgv_lang["a.m."]         		= "до полудня";
$pgv_lang["p.m."]        		= "после полудня";
$pgv_lang["noon"]         		= "полдень";
$pgv_lang["midn"]         		= "полночь";

//-- MONTH NAMES
$pgv_lang["jan"]    			= "январь";
$pgv_lang["feb"]			= "февраль";
$pgv_lang["mar"]			= "март";
$pgv_lang["apr"]			= "апрель";
$pgv_lang["may"]			= "май";
$pgv_lang["jun"]			= "июнь";
$pgv_lang["jul"]			= "июль";
$pgv_lang["aug"]			= "август";
$pgv_lang["sep"]			= "сентябрь";
$pgv_lang["oct"]			= "октябрь";
$pgv_lang["nov"]			= "ноябрь";
$pgv_lang["dec"]			= "декабрь";

// $pgv_lang["vend"]			use value from lang.en.php
// $pgv_lang["brum"]			use value from lang.en.php
// $pgv_lang["frim"]			use value from lang.en.php
// $pgv_lang["nivo"]			use value from lang.en.php
// $pgv_lang["pluv"]			use value from lang.en.php
// $pgv_lang["vent"]			use value from lang.en.php
// $pgv_lang["germ"]			use value from lang.en.php
// $pgv_lang["flor"]			use value from lang.en.php
// $pgv_lang["prai"]			use value from lang.en.php
// $pgv_lang["mess"]			use value from lang.en.php
// $pgv_lang["ther"]			use value from lang.en.php
// $pgv_lang["fruc"]			use value from lang.en.php
// $pgv_lang["comp"]			use value from lang.en.php

// $pgv_lang["tsh"]				use value from lang.en.php
// $pgv_lang["csh"]				use value from lang.en.php
// $pgv_lang["ksl"]				use value from lang.en.php
// $pgv_lang["tvt"]				use value from lang.en.php
// $pgv_lang["shv"]				use value from lang.en.php
// $pgv_lang["adr"]				use value from lang.en.php
// $pgv_lang["adr_leap_year"]	use value from lang.en.php
// $pgv_lang["ads"]				use value from lang.en.php
// $pgv_lang["nsn"]				use value from lang.en.php
// $pgv_lang["iyr"]				use value from lang.en.php
// $pgv_lang["svn"]				use value from lang.en.php
// $pgv_lang["tmz"]				use value from lang.en.php
// $pgv_lang["aav"]				use value from lang.en.php
// $pgv_lang["ell"]				use value from lang.en.php

// $pgv_lang["muhar"]			use value from lang.en.php
// $pgv_lang["safar"]			use value from lang.en.php
// $pgv_lang["rabia"]			use value from lang.en.php
// $pgv_lang["rabit"]			use value from lang.en.php
// $pgv_lang["jumaa"]			use value from lang.en.php
// $pgv_lang["jumat"]			use value from lang.en.php
// $pgv_lang["rajab"]			use value from lang.en.php
// $pgv_lang["shaab"]			use value from lang.en.php
// $pgv_lang["ramad"]			use value from lang.en.php
// $pgv_lang["shaww"]			use value from lang.en.php
// $pgv_lang["dhuaq"]			use value from lang.en.php
// $pgv_lang["dhuah"]			use value from lang.en.php

$pgv_lang["b.c."]         = "До Рождества Христова";

$pgv_lang["abt"]			= "приблизительно";
$pgv_lang["aft"]			= "после";
$pgv_lang["and"]			= "и";
$pgv_lang["bef"]			= "до";
$pgv_lang["bet"]			= "между";
$pgv_lang["cal"]			= "сосчитано";
$pgv_lang["est"]			= "предположительно определено";
$pgv_lang["from"]			= "от";
$pgv_lang["int"]			= "производный";
$pgv_lang["to"]				= "до";
$pgv_lang["cir"]			= "приблизительно";
$pgv_lang["apx"]			= "примерно";

//-- Admin File Messages
$pgv_lang["password_mismatch"]		= "Разные пароли.";
$pgv_lang["enter_username"]		= "Введите имя пользователя.";
$pgv_lang["enter_password"]		= "Введите пароль.";
$pgv_lang["save"]			= "Сохранить";
$pgv_lang["saveandgo"]			= "Сохранить и перейти на новую запись";
$pgv_lang["delete"]			= "Удалить";
$pgv_lang["edit"]			= "Внести изменения";
$pgv_lang["no_login"]			= "Пользователь не прошел авторизацию.";
$pgv_lang["basic_realm"]		= "Система аутентификации PhpGedView";
$pgv_lang["basic_auth_failure"]		= "Вы должны ввести существующий ID и пароль, чтобы войти в этот ресурс";
$pgv_lang["basic_auth"]			= "Основная аутентификация";
$pgv_lang["digest_auth"]		= "Digest Authentication"; //not used in code yet
$pgv_lang["no_auth_needed"]		= "Аутентификация не требуется";
$pgv_lang["file_not_exists"]		= "Файл с указанным именем не существует.";
$pgv_lang["research_assistant"]		= "Поисковый помощник";
$pgv_lang["utf8_to_ansi"]		= "Преобразовать файл GEDCOM из UTF-8 на ANSI (ISO-8859-1)?";
$pgv_lang["media_linked"]		= "Этот медиа объект связан со следующим:";
$pgv_lang["media_not_linked"]		= "Этот медиа объект не связан ни с одной запись GEDCOM.";
$pgv_lang["media_dir_1"]		= "Этот медиа объект расположен на внешнем сервере";
$pgv_lang["media_dir_2"]		= "Этот медиа объект находится в стандартной директории";
$pgv_lang["media_dir_3"]		= "Этот медиа объект расположен в защищённой директории";
$pgv_lang["thumb_dir_1"]		= "Эта иконка расположена на внешнем сервере";
$pgv_lang["thumb_dir_2"]		= "Эта иконка находится в стандартной директории";
$pgv_lang["thumb_dir_3"]		= "Эта иконка расположена в защищённой директории";
$pgv_lang["moveto_2"]			= "Переместить в защищённую директорию";
$pgv_lang["moveto_3"]			= "Переместить в стандартную директорию";
$pgv_lang["move_standard"]		= "Переместить в стандартную";
$pgv_lang["move_protected"]		= "Переместить в защищённую";
$pgv_lang["move_mediadirs"]		= "Переместить медиа директории";
$pgv_lang["setperms"]			= "Установить разрешения медиа";
$pgv_lang["setperms_fix"]		= "Скорректировать разрешения чтения/изменения/выполнения";
$pgv_lang["setperms_success"]		= "Разрешения установлены";
$pgv_lang["setperms_failure"]		= "Разрешения не установлены";
$pgv_lang["setperms_time_exceeded"]	= "Превышено время выполнения команды. Попробуйте команду снова на меньшей директории.";
$pgv_lang["move_time_exceeded"]		= "Превышено время выполнения команды. Попробуйте эту команду снова, чтобы переместить все файлы.";
$pgv_lang["media_firewall_rootdir_no_exist"]		= "Корневая директория медиа файервола, которую вы запрашиваете не существует. Вы должны сперва её создать.";
$pgv_lang["media_firewall_protected_dir_no_exist"]	= "Защищённая директория медия не может быть создана в корневой директории файервола. Пожалуйста создайте здесь директорию и сделайте её разрешённой всем для записи.";
$pgv_lang["media_firewall_protected_dir_not_writable"]	= "Защищённая директория медиа в корневой директории файервола  не позволяет в неё записывать. ";
$pgv_lang["media_firewall_invalid_dir"]	= "Ошибка: Медиа файервол запущен с директории, не имеющего ничего общего с медиа директорией.";

//-- Relationship chart messages
$pgv_lang["view_fam_nav_details"]       = "Посмотреть детали ...";
$pgv_lang["view_fam_nav_notes"]         = "Посмотреть записки ...";
$pgv_lang["view_fam_nav_sources"]       = "Посмотреть источники ...";
$pgv_lang["view_fam_nav_media"]         = "Посмотреть медиа файлы ...";
$pgv_lang["view_fam_nav_album"]         = "Посмотреть альбом ...";
$pgv_lang["view_fam_nav_relatives"]     = "Посмотреть родственников ...";
$pgv_lang["view_fam_nav_tree"]          = "Посмотреть дерево ...";
$pgv_lang["view_fam_nav_research"]      = "Посмотреть изыскания ...";
$pgv_lang["view_fam_nav_map"]           = "Посмотреть карту ...";
$pgv_lang["view_fam_nav_spare"]         = "Посмотреть дополнительную информацию ...";
$pgv_lang["navigator"]			= "Навигатор";
$pgv_lang["fam_navigator"]		= "Family Navigator";

$pgv_lang["relationship_great"]		= "Пра";
$pgv_lang["relationship_chart"]		= "Родство";
$pgv_lang["person1"]			= "Лицо 1";
$pgv_lang["person2"]			= "Лицо 2";
$pgv_lang["no_link_found"]		= "Родство между двумя персонами не найдено.";
$pgv_lang["no_other_link_found"]	= "Никакой другой связи между двумя индивидуалами не найдено.";
$pgv_lang["sibling"]			= "Брат/сестра";
$pgv_lang["follow_spouse"]		= "Контролируй родство по браку";
$pgv_lang["timeout_error"]		= "Определить максимальное время поиска для нахождения родственных отношений.";
$pgv_lang["grandchild"]			= "Внук/Внучка";
$pgv_lang["grandson"]			= "Внук";
$pgv_lang["granddaughter"]		= "Внучка";
$pgv_lang["greatgrandchild"]		= "Правнук/Правнучка";
$pgv_lang["greatgrandson"]		= "Правнук";
$pgv_lang["greatgranddaughter"]		= "Правнучка";
$pgv_lang["brother"]			= "Брат";
$pgv_lang["sister"]			= "Сестра";
$pgv_lang["aunt"]			= "Тётя";
$pgv_lang["uncle"]			= "Дядя";
$pgv_lang["nephew"]			= "Племянник";
$pgv_lang["niece"]			= "Племянница";
$pgv_lang["firstcousin"]		= "Двоюродный брат/Двоюродная сестра";
$pgv_lang["femalecousin"]		= "Двоюродная сестра";
$pgv_lang["malecousin"]			= "Двоюродный брат";
$pgv_lang["relationship_to_me"]		= "Родственная связь со мной";
$pgv_lang["rela_husb"]			= "Отношение к мужу";
$pgv_lang["rela_wife"]			= "Отношение в жене";
$pgv_lang["next_path"]			= "Искать следующую ветвь";
$pgv_lang["show_path"]			= "Показать ветвь";
$pgv_lang["line_up_generations"]	= "Выстроить в линию одинаковые поколения.";
$pgv_lang["oldest_top"]            	= "Показать самого старшего главу семьи";

// %1\$s replaced by first person, %2\$s by the relationship and %3\$s by the second person.
$pgv_lang["relationship_male_1_is_the_2_of_3"] = "%1\$s is the %2\$s of %3\$s.";
$pgv_lang["relationship_female_1_is_the_2_of_3"] = "%1\$s is the %2\$s of %3\$s.";

$pgv_lang["mother_in_law"]		= "Тёща";
$pgv_lang["father_in_law"]		= "Тесть";
$pgv_lang["brother_in_law"]		= "Шурин";
$pgv_lang["sister_in_law"]		= "Заловка";
$pgv_lang["brothers_wife"]		= "Невестка"; // brother's wife
$pgv_lang["son_in_law"]			= "Зять";
$pgv_lang["daughter_in_law"]		= "Невестка";
$pgv_lang["uncle_in_law"]		= "Дядя";
$pgv_lang["aunt_in_law"]		= "Тётя";
$pgv_lang["cousin_in_law"]		= "Двоюродный брат супруга(-и)";
$pgv_lang["m_cousin_in_law"]    	= "Двоюродный брат супруга";
$pgv_lang["f_cousin_in_law"]    	= "Братаниха";
$pgv_lang["step_son"]			= "пасынок";
$pgv_lang["step_daughter"]		= "падчерица";

// the bosa_brothers_offspring name is used for fraternal nephews and nieces - the names below can be extended to any number
// of generations just by adding more translations.
// 1st generation
$pgv_lang["bosa_brothers_offspring_2"]				= "племянник";             // brother's son
$pgv_lang["bosa_brothers_offspring_3"]				= "племянница";              // brother's daughter
// 2nd generation
$pgv_lang["bosa_brothers_offspring_4"]				= "внучатый племянник";       // brother's son's son
$pgv_lang["bosa_brothers_offspring_5"]				= "внучатая племянница";        // brother's son's daughter
$pgv_lang["bosa_brothers_offspring_6"]				= "внучатый племянник";       // brother's daughter's son
$pgv_lang["bosa_brothers_offspring_7"]				= "внучатая племянница";        // brother's daughter's daughter
// for the general case of offspring of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_brothers_son"]	  = "%2\$d x great nephew";
$pgv_lang["n_x_brothers_daughter"] = "%2\$d x great niece";
// the bosa_sisters_offspring name is used for sisters nephews and nieces - the names below can be extended to any number
// of generations just by adding more translations.
// 1st generation
$pgv_lang["bosa_sisters_offspring_2"]				= "племянник";             // sister's son
$pgv_lang["bosa_sisters_offspring_3"]				= "племянница";              // sister's daughter
// 2nd generation
$pgv_lang["bosa_sisters_offspring_4"]				= "внучатая племянник";       // sister's son's son
$pgv_lang["bosa_sisters_offspring_5"]				= "внучатая племянница";        // sister's son's daughter
$pgv_lang["bosa_sisters_offspring_6"]				= "внучатая племянник";       // sister's daughter's son
$pgv_lang["bosa_sisters_offspring_7"]				= "внучатая племянница";        // sister's daughter's daughter
// for the general case of offspring of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_sisters_son"]	  = "%2\$d x внучатая племянник";
$pgv_lang["n_x_sisters_daughter"] = "%2\$d x внучатая племянница";

// the bosa name is used for offspring - the names below can be extended to any number
// of generations just by adding more translations.
// 1st generation
$pgv_lang["bosa_2"] 				= "сын";                   // son
$pgv_lang["bosa_3"] 				= "дочь";              // daughter
// 2nd generation
$pgv_lang["bosa_4"] 				= "внук";              // son's son
$pgv_lang["bosa_5"] 				= "внучка";         // son's daughter
$pgv_lang["bosa_6"] 				= "внук";              // daughter's son
$pgv_lang["bosa_7"] 				= "внучка";         // daughter's daughter
// 3rd generation
$pgv_lang["bosa_8"] 				= "правнук";        // son's son's son
$pgv_lang["bosa_9"] 				= "правнучка";   // son's son's daughter
$pgv_lang["bosa_10"] 				= "правнук";		   // son's daughter's son
$pgv_lang["bosa_11"] 				= "правнучка";   // son's daughter's daughter
$pgv_lang["bosa_12"] 				= "правнук";        // daughter's son's son
$pgv_lang["bosa_13"] 				= "правнучка";   // daughter's son's daughter
$pgv_lang["bosa_14"] 				= "правнук";		   // daughter's daughter's son
$pgv_lang["bosa_15"] 				= "правнучка";   // daughter's daughter's daughter
// for the general case of offspring of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_grandson_from_son"]	  = "%3\$d x правнук";
$pgv_lang["n_x_granddaughter_from_son"] = "%3\$d x правнучка";
$pgv_lang["n_x_grandson_from_daughter"]	  = "%3\$d x правнук";
$pgv_lang["n_x_granddaughter_from_daughter"] = "%3\$d x правнучка";

// the sosa_uncle name is used for uncles - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and uncles
// 1st generation
$pgv_lang["sosa_uncle_2"]			= "дядя";            // father's brother
$pgv_lang["sosa_uncle_3"]			= "дядя";            // mother's brother
// 2nd generation
$pgv_lang["sosa_uncle_4"] 			= "дядя";      // fathers's father's brother
$pgv_lang["sosa_uncle_5"] 			= "дядя";      // father's mother's brother
$pgv_lang["sosa_uncle_6"] 			= "дядя";      // mother's father's brother
$pgv_lang["sosa_uncle_7"] 			= "дядя";      // mother's mother's brother
// for the general case of uncles of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_uncle"]		= "%2\$d x дядя";
$pgv_lang["n_x_maternal_uncle"]	    = "%2\$d x дядя";

// the sosa_aunt name is used for aunts - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and aunts
// 1st generation
$pgv_lang["sosa_aunt_2"]			= "тётя";            // father's sisteri
$pgv_lang["sosa_aunt_3"]			= "тётя";            // mother's sister
// 2nd generation
$pgv_lang["sosa_aunt_4"] 			= "тётя";      // fathers's father's sister
$pgv_lang["sosa_aunt_5"] 			= "тётя";      // father's mother's sister
$pgv_lang["sosa_aunt_6"] 			= "тётя";      // mother's father's sister
$pgv_lang["sosa_aunt_7"] 			= "тётя";      // mother's mother's sister
// for the general case of aunts of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_aunt"]			= "%2\$d x тётя";
$pgv_lang["n_x_maternal_aunt"]			= "%2\$d x тётя";

// the sosa_uncle name is used for uncles(by marriage) - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and uncles
// 1st generation
$pgv_lang["sosa_uncle_bm_2"] 				= "дядя";            // father's brother
$pgv_lang["sosa_uncle_bm_3"] 				= "дядя";            // mother's brother
// 2nd generation
$pgv_lang["sosa_uncle_bm_4"] 				= "дядя";      // fathers's father's brother
$pgv_lang["sosa_uncle_bm_5"] 				= "дядя";      // father's mother's brother
$pgv_lang["sosa_uncle_bm_6"] 				= "дядя";      // mother's father's brother
$pgv_lang["sosa_uncle_bm_7"] 				= "дядя";      // mother's mother's brother
// for the general case of uncles of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_uncle_bm"]		= "%2\$d x дядя";
$pgv_lang["n_x_maternal_uncle_bm"]	    = "%2\$d x дядя";

// the sosa_aunt name is used for aunts (by marriage)- the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and aunts
// 1st generation
$pgv_lang["sosa_aunt_bm_2"] 				= "тётя";            // father's sister
$pgv_lang["sosa_aunt_bm_3"] 				= "тётя";            // mother's sister
// 2nd generation
$pgv_lang["sosa_aunt_bm_4"] 				= "тётя";      // fathers's father's sister
$pgv_lang["sosa_aunt_bm_5"] 				= "тётя";      // father's mother's sister
$pgv_lang["sosa_aunt_bm_6"] 				= "тётя";      // mother's father's sister
$pgv_lang["sosa_aunt_bm_7"] 				= "тётя";      // mother's mother's sister
// for the general case of aunts of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_aunt_bm"]		= "%2\$d x тётя";
$pgv_lang["n_x_maternal_aunt_bm"]	    = "%2\$d x тётя";

// if a specific cousin relationship cannot be represented in a language translate as "";
$pgv_lang["male_cousin_1"]              = "first cousin";
$pgv_lang["male_cousin_2"]              = "second cousin";
$pgv_lang["male_cousin_3"]              = "third cousin";
$pgv_lang["male_cousin_4"]              = "fourth cousin";
$pgv_lang["male_cousin_5"]              = "fifth cousin";
$pgv_lang["male_cousin_6"]              = "sixth cousin";
$pgv_lang["male_cousin_7"]              = "seventh cousin";
$pgv_lang["male_cousin_8"]              = "eighth cousin";
$pgv_lang["male_cousin_9"]              = "ninth cousin";
$pgv_lang["male_cousin_10"]             = "tenth cousin";
$pgv_lang["male_cousin_11"]             = "eleventh cousin";
$pgv_lang["male_cousin_12"]             = "twelfth cousin";
$pgv_lang["male_cousin_13"]             = "thirteenth cousin";
$pgv_lang["male_cousin_14"]             = "fourteenth cousin";
$pgv_lang["male_cousin_15"]             = "fifteenth cousin";
$pgv_lang["male_cousin_16"]             = "sixteenth cousin";
$pgv_lang["male_cousin_17"]             = "seventeenth cousin";
$pgv_lang["male_cousin_18"]             = "eighteenth cousin";
$pgv_lang["male_cousin_19"]             = "nineteenth cousin";
$pgv_lang["male_cousin_20"]             = "twentieth cousin";
$pgv_lang["male_cousin_n"]              = "%d x cousin";
$pgv_lang["female_cousin_1"]            = "first cousin";
$pgv_lang["female_cousin_2"]            = "second cousin";
$pgv_lang["female_cousin_3"]            = "third cousin";
$pgv_lang["female_cousin_4"]            = "fourth cousin";
$pgv_lang["female_cousin_5"]            = "fifth cousin";
$pgv_lang["female_cousin_6"]            = "sixth cousin";
$pgv_lang["female_cousin_7"]            = "seventh cousin";
$pgv_lang["female_cousin_8"]            = "eighth cousin";
$pgv_lang["female_cousin_9"]            = "ninth cousin";
$pgv_lang["female_cousin_10"]           = "tenth cousin";
$pgv_lang["female_cousin_11"]           = "eleventh cousin";
$pgv_lang["female_cousin_12"]           = "twelfth cousin";
$pgv_lang["female_cousin_13"]           = "thirteenth cousin";
$pgv_lang["female_cousin_14"]           = "fourteenth cousin";
$pgv_lang["female_cousin_15"]           = "fifteenth cousin";
$pgv_lang["female_cousin_16"]           = "sixteenth cousin";
$pgv_lang["female_cousin_17"]           = "seventeenth cousin";
$pgv_lang["female_cousin_18"]           = "eighteenth cousin";
$pgv_lang["female_cousin_19"]           = "nineteenth cousin";
$pgv_lang["female_cousin_20"]           = "twentieth cousin";
$pgv_lang["female_cousin_n"]            = "%d x cousin";

// Only referenced from english specific functions
$pgv_lang["removed_ascending_1"]   = " once removed ascending";
$pgv_lang["removed_ascending_2"]   = " twice removed ascending";
$pgv_lang["removed_ascending_3"]   = " three times removed ascending";
$pgv_lang["removed_ascending_4"]   = " four times removed ascending";
$pgv_lang["removed_ascending_5"]   = " five times removed ascending";
$pgv_lang["removed_ascending_6"]   = " six times removed ascending";
$pgv_lang["removed_ascending_7"]   = " seven times removed ascending";
$pgv_lang["removed_ascending_8"]   = " eight times removed ascending";
$pgv_lang["removed_ascending_9"]   = " nine times removed ascending";
$pgv_lang["removed_ascending_10"]  = " ten times removed ascending";
$pgv_lang["removed_ascending_11"]  = " eleven times removed ascending";
$pgv_lang["removed_ascending_12"]  = " twelve times removed ascending";
$pgv_lang["removed_ascending_13"]  = " thirteen times removed ascending";
$pgv_lang["removed_ascending_14"]  = " fourteen times removed ascending";
$pgv_lang["removed_ascending_15"]  = " fifteen times removed ascending";
$pgv_lang["removed_ascending_16"]  = " sixteen times removed ascending";
$pgv_lang["removed_ascending_17"]  = " seventeen times removed ascending";
$pgv_lang["removed_ascending_18"]  = " eighteen times removed ascending";
$pgv_lang["removed_ascending_19"]  = " nineteen times removed ascending";
$pgv_lang["removed_ascending_20"]  = " twenty times removed ascending";
$pgv_lang["removed_descending_1"]  = " once removed descending";
$pgv_lang["removed_descending_2"]  = " twice removed descending";
$pgv_lang["removed_descending_3"]  = " three times removed descending";
$pgv_lang["removed_descending_4"]  = " four times removed descending";
$pgv_lang["removed_descending_5"]  = " five times removed descending";
$pgv_lang["removed_descending_6"]  = " six times removed descending";
$pgv_lang["removed_descending_7"]  = " seven times removed descending";
$pgv_lang["removed_descending_8"]  = " eight times removed descending";
$pgv_lang["removed_descending_9"]  = " nine times removed descending";
$pgv_lang["removed_descending_10"] = " ten times removed descending";
$pgv_lang["removed_descending_11"] = " eleven times removed descending";
$pgv_lang["removed_descending_12"] = " twelve times removed descending";
$pgv_lang["removed_descending_13"] = " thirteen times removed descending";
$pgv_lang["removed_descending_14"] = " fourteen times removed descending";
$pgv_lang["removed_descending_15"] = " fifteen times removed descending";
$pgv_lang["removed_descending_16"] = " sixteen times removed descending";
$pgv_lang["removed_descending_17"] = " seventeen times removed descending";
$pgv_lang["removed_descending_18"] = " eighteen times removed descending";
$pgv_lang["removed_descending_19"] = " nineteen times removed descending";
$pgv_lang["removed_descending_20"] = " twenty times removed descending";

//-- GEDCOM edit utility
$pgv_lang["check_delete"]		= "Вы уверены что этот факт GEDCOM хотите удалить?";
$pgv_lang["access_denied"]		= "Доступ отклонен. </b><br />У Вас нет доступа к этому источнику.";
$pgv_lang["changes_exist"]		= "Файл GEDCOM изменен.";
$pgv_lang["find_place"]			= "Искать место";
$pgv_lang["close_window"]		= "Закрыть окно";
$pgv_lang["close_window_without_refresh"]	= "Закрыть окно без сохранения изменений";
$pgv_lang["place_contains"]		= "Место состоит из:";
$pgv_lang["add"]			= "Добавить";
$pgv_lang["custom_event"]		= "Нестандартное событие";
$pgv_lang["delete_person"]		= "Удалить это лицо";
$pgv_lang["confirm_delete_person"]	= "Вы уверены что хотите удалить эту персону из GEDCOM файла?";
$pgv_lang["find_media"]			= "Искать фото/аудио/видио";
$pgv_lang["set_link"]			= "Присоединить";
$pgv_lang["delete_source"]		= "Удалить этот источник";
$pgv_lang["delete_shared_note"]		= "Удалить эту общую заметку";
$pgv_lang["confirm_delete_source"]	= "Вы уверены что хотите удалить этот источник из GEDCOM файла?";
$pgv_lang["confirm_delete_shared_note"]	= "Вы уверены что хотите удалить эту общую заметку?";
$pgv_lang["find_family"]		= "Искать семью";
$pgv_lang["find_fam_list"]		= "Найти список семей";
$pgv_lang["edit_name"]			= "Изменить имя";
$pgv_lang["delete_name"]		= "Удалить имя";
$pgv_lang["select_date"]		= "Выбрать дату";
$pgv_lang["user_cannot_edit"]		= "Пользователь с таким именем не может редактировать этот GEDCOM файл.";
$pgv_lang["ged_noshow"]			= "Эта страница отключена администратором сайта.";

//-- calendar.php messages
$pgv_lang["bdm"]			= "Рождение, кончина, брак";
$pgv_lang["on_this_day"]		= "В этот день, в прошлом...";
$pgv_lang["in_this_month"]		= "В этом месяце, в прошлом...";
$pgv_lang["in_this_year"]		= "В этом году, в Вашей истории...";
$pgv_lang["year_anniversary"]		= "#year_var# года/лет назад";
$pgv_lang["today"]				= "Сегодня";
$pgv_lang["day"]			= "День:";
$pgv_lang["month"]			= "Месяц:";
$pgv_lang["showcal"]			= "Показать события:";
$pgv_lang["anniversary"]		= "Юбилей";
$pgv_lang["anniversary_calendar"] 	= "Календарь событий";
$pgv_lang["sunday"]			= "Воскресенье";
$pgv_lang["monday"]			= "Понедельник";
$pgv_lang["tuesday"]			= "Вторник";
$pgv_lang["wednesday"]			= "Среда";
$pgv_lang["thursday"]			= "Четверг";
$pgv_lang["friday"]			= "Пятница";
$pgv_lang["saturday"]			= "Суббота";
$pgv_lang["viewday"]			= "Показать день";
$pgv_lang["viewmonth"]			= "Показать месяц";
$pgv_lang["viewyear"]			= "Показать год";
$pgv_lang["all_people"]			= "Все лица";
$pgv_lang["living_only"]		= "Живущие ныне лица";
$pgv_lang["recent_events"]		= "Последние события (< 100 лет)";
$pgv_lang["day_not_set"]		= "День не установлен";

//-- user self registration module
$pgv_lang["lost_password"]		= "Потеряли пароль?";
$pgv_lang["requestpassword"]		= "Запрос нового пароля";
$pgv_lang["no_account_yet"]		= "Вы еще не являетесь пользователем?";
$pgv_lang["requestaccount"]		= "Запрос на регистрацию нового пользователя";
$pgv_lang["emailadress"]		= "Адрес электронной почты (e-mail):";
$pgv_lang["mandatory"] 			= "Поля, отмеченные * необходимо заполнить.";
$pgv_lang["mail01_line01"]		= "Здравствуйте, #user_fullname# ...";
$pgv_lang["mail01_line02"]		= "На сервер ( #PGV_SERVER_NAME##PGV_SCRIPT_PATH# ) пришел запрос на регистрацию с Вашим эл.адресом ( #user_email# ).";
$pgv_lang["mail01_line03"]		= "Используются следующие данные.";
$pgv_lang["mail01_line04"]		= "Кликните по нижестоящей кнопочке и введите данные для проверки соответствия Вашего имя пользователя и эл.адреса (e-mail).";
$pgv_lang["mail01_line05"]		= "Если Вы эти данные не запрашивали, то удалите это сообщение.";
$pgv_lang["mail01_line06"]		= "Вы не получите больше сообщений, т.к. Ваше имя пользователя не прошло подтверждения и было удалено через 7 дней.";
$pgv_lang["mail01_subject"]		= "Ваша регистрация на #PGV_SERVER_NAME##PGV_SCRIPT_PATH#";

$pgv_lang["mail02_line01"]		= "Здравствуйте администратор...";
$pgv_lang["mail02_line02"]		= "Новый пользователь сделал запрос имя пользователя на ( #PGV_SERVER_NAME##PGV_SCRIPT_PATH# ).";
$pgv_lang["mail02_line03"]		= "Этот пользователь получил e-mail с информацией, необходимой для контроля.";
$pgv_lang["mail02_line04"]		= "Вы получите сообщение как только пользователь пошлет данные для проверки. После этого Вы можете дать пользователю разрешение на вход на сайт.";
$pgv_lang["mail02_line04a"]		= "Вы будете проинформированы по электронной почте, когда этот перспективный пользователь подтвердит свой запрос. После этого пользователь сможет авторизоваться на сайте, без всяких действий с Вашей стороны.";
$pgv_lang["mail02_subject"]		= "Сделан запрос на ( #PGV_SERVER_NAME##PGV_SCRIPT_PATH# ) для регистрации с Вашим эл.адресом ( #user_email# ).";

$pgv_lang["hashcode"]			= "Контрольный код:";
$pgv_lang["thankyou"]			= "Здравствуйте,  #user_fullname#...<br /> Спасибо за Ваше обращение на наш сайт";
$pgv_lang["pls_note06"]			= "Вы получите подтверждающее письмо на Ваш эл.адрес (#user_email#). С данными из этого письма, Вы можете активизировать свое имя пользователя. Если Вы это не сделаете, по истечению семи дней Ваш запрос будет ликвидирован. Вы этом случае Вы можете имя пользователя запросить вторично. Для регистрации на этом сайте Вы должны иметь имя пользователя и пароль.";
$pgv_lang["pls_note06a"] 		= "Мы отправили подтверждающее сообщение на адрес <b>#user_email#</b>. Вы должны подтвердить свой аккаунт, следуя инструкциям в подтверждении по электронной почте. Если вы не подтвердите свой запрос в течение семи дней, ваша заявка будет отклонена автоматически. Вам прийдётся регистрироваться снова.<br /><br />После того как вы проследуете инструкциям в подтверждение по электронной почте, вы можете залогиниться на сайте.  Для входа на сайт, вам необходимо знать ваше имя пользователя и пароль.<br /><br />";

$pgv_lang["registernew"]		= "Подтверждение нового пользователя";
$pgv_lang["user_verify"]		= "Проверка пользователя";
$pgv_lang["send"]			= "Отправить";

$pgv_lang["pls_note07"]			= "Введите Ваше имя пользователя, пароль и контрольный код, который Вы получили в эл.письме.";
$pgv_lang["pls_note08"]			= "Данные пользователя #user_name# проверены.";

$pgv_lang["mail03_line01"]		= "Здравствуйте, администратор...";
$pgv_lang["mail03_line02"]		= "Регистрационные данные #newuser[username]# ( #newuser[fullname]# ) сличены.";
$pgv_lang["mail03_line03"]		= "Кликните по нижестоящей кнопочке, зайдите на сайт и дайте разрешение на регистрацию пользователя.";
$pgv_lang["mail03_line03a"]		= "Вам не нужно предпринимать никаких действий, пользователь может войти.";
$pgv_lang["mail03_subject"]		= "Новый контроль на #PGV_SERVER_NAME##PGV_SCRIPT_PATH#";

$pgv_lang["pls_note09"]			= "Вы известны как зарегистрированный пользователь.";
$pgv_lang["pls_note10"]			= "Администратор информирован. Как только он разрешит, Вы можете войти в программу, введя имя пользователя и пароль.";
$pgv_lang["pls_note10a"]		= "Теперь вы можете войти с вашим именем пользователя и паролем.";
$pgv_lang["data_incorrect"]		= "Данные не корректны! <br /> Попробуйте еще раз!";
$pgv_lang["user_not_found"]		= "Пользователь не найден!";

$pgv_lang["lost_pw_reset"]		= "Запросите новый пароль";
$pgv_lang["pls_note11"]			= "Если Вы потеряете свой пароль, это вызовет ряд трудностей. В первую очередь это проблема защиты данных. Если он попадет в руки к кому-нибудь, то он может получитьдоступ к запретным данным. В случае потери пароля, пошлите эл.письмо с Вашим именем пользователя для запроса нового пароля. Далее кликните по #pgv_lang[lost_pw_reset]#-knop.<br /><br /> Если имя пользователя и эл.адрес корректы, то Вы получите на свой эл.адрес сообщение с кодом. Введя этот код, Вы можете ввести новый пароль. Позаботьтесь чтобы письмо было защищено от посторонних глаз. Если Вы не помните, какой эл.адрес Вы указывали на нашем сайте, Вы можете ввести несколько своих эл.адресов. Сообщение с кодом будет послано Вам только в случае правильной комбинации имя пользователя и эл.адреса. Если у Вас есть проблемы, то Вы можете обратиться к администратору этого сайта.";

$pgv_lang["mail04_line01"]		= "Здравствуйте, #user_fullname#...";
$pgv_lang["mail04_line02"]		= "Для Вашего имя пользователя сделан запрос на новый пароль!";
$pgv_lang["mail04_line03"]		= "Совет:";
$pgv_lang["mail04_line04"]		= "Кликните по нижестоящей кнопке, введите новый пароль и вносите изменения далее.";
$pgv_lang["mail04_line05"]		= "После того, как вы вошли, выберите ссылку «#pgv_lang[editowndata]#» в меню «#pgv_lang[mygedview]#» и заполните поля для смены вашего пароля.";
$pgv_lang["mail04_subject"]		= "Запрос данных на #PGV_SERVER_NAME##PGV_SCRIPT_PATH#";

$pgv_lang["pwreqinfo"]			= "Здравствуйте...<br /><br />Новый пароль послан по эл.почте на (#user[email]#).<br /><br />Через несколько минут вы получите его на свой почтовый ящик.<br /><br />Совет: После получения эл.письма, зайдите на сайт со своим именем пользователя и новым паролем и затем измените свой пароль.";

$pgv_lang["myuserdata"]			= "Мои данные";
$pgv_lang["user_theme"]			= "Мое оформление сайта";
$pgv_lang["mgv"]				= "Моя страница";
$pgv_lang["mygedview"]			= "Моя страница";
$pgv_lang["passwordlength"]		= "Пароль должен быть минимум 6 символов";
$pgv_lang["welcome_text_auth_mode_1"]	=	"<span class='center'><b>ДОБРО ПОЖАЛОВАТЬ НА ЭТОТ ГЕНЕАЛОГИЧЕСКИЙ САЙТ</b></span><br /><br />Доступ к данным сайта разрешен посетителям, которые зарегистрированы тут и имеюют свою учетную запись. <br />Если Вы зарегистрированы, пожалуйста войдите на сайт на этой странице.<br /><br />Если Вы не зарегистрированы, то можете послать запрос на регистрацию перейдя по соответствующей ссылке на этой странице.<br />После того как администратор проверит Вашу информацию, он создаст для Вас учетную запись и отправит Вам письмо (email) для активации этой учетной записи.";
$pgv_lang["welcome_text_auth_mode_2"]	=	"<span class='center'><b>ДОБРО ПОЖАЛОВАТЬ НА ЭТОТ ГЕНЕАЛОГИЧЕСКИЙ САЙТ</b></span><br /><br />Доступ к данным сайта разрешен посетителям, которые зарегистрированы и <b>авторизованы</b> тут. <br />Если Вы зарегистрированы, пожалуйста войдите на сайт на этой странице.<br /><br />Если Вы тут не зарегистрированы, то можете послать запрос на регистрацию перейдя по соответствующей ссылке на этой странице.<br />После того как администратор проверит Вашу информацию, он создаст для Вас учетную запись и отправит Вам письмо (email) для активации этой учетной записи.";
$pgv_lang["welcome_text_auth_mode_3"]	=	"<span class='center'><b>ДОБРО ПОЖАЛОВАТЬ НА ЭТОТ ГЕНЕАЛОГИЧЕСКИЙ САЙТ</b></span><br /><br />Доступ к данным сайта разрешен только <b>членам семьи</b>. <br />Если Вы зарегистрированы, пожалуйста войдите на сайт на этой странице.<br /><br />Если Вы тут не зарегистрированы, то можете послать запрос на регистрацию перейдя по соответствующей ссылке на этой странице.<br />После того как администратор проверит Вашу информацию, он создаст для Вас учетную запись и отправит Вам письмо (email) для активации этой учетной записи.";
$pgv_lang["welcome_text_cust_head"]		=	"<span class='center'><b>ДОБРО ПОЖАЛОВАТЬ НА ЭТОТ ГЕНЕАЛОГИЧЕСКИЙ САЙТ</b></span><br /><br />Доступ к данным сайта разрешен только зарегистрированным пользователям, имеющим учетную запись и пароль.";
$pgv_lang["acceptable_use"]			= "<div class=\"largeError\">Notice:</div><div class=\"error\">Заполнив эту форму, вы соглашаетесь:<ul><li>защищать частную жизнь живущих людей, отображающихся на этом сайте;</li><li>и в текстовое поле ниже, чтобы объяснить, с кем вы связаны, или предоставить нам информацию о тех, кто должен быть указан на нашем сайте.</li></ul></div>";


//-- mygedview page
$pgv_lang["upcoming_events"]		= "Скоро...";
$pgv_lang["living_or_all"]		= "Показать события живущих людей?";
$pgv_lang["basic_or_all"]		= "Показать только рождение, кончину и брак?";
$pgv_lang["style"]			= "Стиль презентации";
$pgv_lang["style1"]			= "Список";
$pgv_lang["style2"]			= "Таблица";
$pgv_lang["style3"]			= "Облако тэгов";
$pgv_lang["sort_style"]			= "Сортированный стиль";
$pgv_lang["by_anniv"]			= "По юбилеям";
$pgv_lang["by_alpha"]			= "По алфавиту";
$pgv_lang["cal_download"]		= "Позволять загружать календарь событий?";
$pgv_lang["no_events_living"]		= "Нет событий у живущих людей на следующие #pgv_lang[global_num1]# дней.";
$pgv_lang["no_events_living1"]		= "Нет событий у живущих людей на завтра.";
$pgv_lang["no_events_all"]		= "Нет событий на следующие #pgv_lang[global_num1]# дней.";
$pgv_lang["no_events_all1"]		= "Нет событий на завтра.";
$pgv_lang["no_events_privacy"]		= "Есть события на следующие #pgv_lang[global_num1]# дней, но ограничения личной жизни запрещает вам на них посмотреть.";
$pgv_lang["no_events_privacy1"]		= "Есть события на завтра, но ограничения личной жизни запрещает вам на них посмотреть.";
$pgv_lang["more_events_privacy"]	= "<br />Есть ещё события на следующие #pgv_lang[global_num1]# дней, но ограничения личной жизни запрещает вам на них посмотреть.";
$pgv_lang["more_events_privacy1"]	= "<br />Есть ещё события на завтра, но ограничения личной жизни запрещает вам на них посмотреть.";
$pgv_lang["none_today_living"]		= "На сегодня нет событий у живущих людей.";
$pgv_lang["none_today_all"]		= "Сегодня событий нет.";
$pgv_lang["none_today_privacy"]		= "Есть события на сегодня, но ограничения личной жизни запрещает вам на них посмотреть.";
$pgv_lang["more_today_privacy"]		= "<br />Есть ещё события сегодня, но ограничения личной жизни запрещает вам на них посмотреть.";
$pgv_lang["chat"]			= "Чат (сhat)";
$pgv_lang["users_logged_in"]		= "Пользователи, работающие сейчас на сайте";
$pgv_lang["anon_user"]                          = "1 анонимный пользователь, работающий на сайте";
$pgv_lang["anon_users"]                         = "#pgv_lang[global_num1]# анонимных пользователея, работающие на сайте";
$pgv_lang["login_user"]                         = "1 работающий на сайте пользователь";
$pgv_lang["login_users"]                        = "#pgv_lang[global_num1]# работающих на сайте пользователя";
$pgv_lang["no_login_users"]                     = "No logged-in and no anonymous users";
$pgv_lang["message"]			= "Послать сообщение";
$pgv_lang["my_messages"]		= "Мои сообщения";
$pgv_lang["date_created"]		= "Дата послания:";
$pgv_lang["message_from"]		= "Эл.адрес (e-mail):";
$pgv_lang["message_from_name"]		= "Ваше имя:";
$pgv_lang["message_to"]			= "Сообщение для:";
$pgv_lang["message_subject"]		= "Тема:";
$pgv_lang["message_body"]		= "содержание:";
$pgv_lang["no_to_user"]			= "Нет адреса получателя.";
$pgv_lang["provide_email"]		= "Сообщите эл.адрес, на который Вы хотите получить ответ на Ваше письмо. Без указания эл.адреса мы не ответим на Ваше сообщение. ";
$pgv_lang["reply"]			= "Ответ";
$pgv_lang["message_deleted"]		= "Сообщение удалено";
$pgv_lang["message_sent"]		= "Сообщение отправлено на #TO_USER#";
$pgv_lang["message_failed"]		= "Не удалось отправить сообщение";
$pgv_lang["message_error"]		= "Ошибка PHPMailer: ";
$pgv_lang["message_invalid_from"]	= "Недопустимый адрес отправителя: &lt;#email#&gt;";
$pgv_lang["message_invalid_to"]		= "Недопустимый адрес получателя: &lt;#email#&gt;";
$pgv_lang["reset"]			= "Восстановление";
$pgv_lang["site_default"]		= "Стандартный сайт";
$pgv_lang["mygedview_desc"]		= "На Вашей личной страничке MyGedView Вы можете указать свои приоритетные персоны, посмотреть события, которые произойдут в скором времени и работать с другими пользователями PhpGedView этого сайта.";
$pgv_lang["no_messages"]		= "У Вас нет непрочитанных сообщений";
$pgv_lang["clicking_ok"]		= "Если Вы кликните по \"OK\", откроется окно для контакта с  ";
$pgv_lang["favorites"]                          = "Фавориты";
$pgv_lang["my_favorites"]		= "Мои фавориты";
$pgv_lang["no_favorites"]		= "У Вас нет выбранных фаворитов. Вы можете добавить персону в свои фавориты следующим образом: Найдите подробности биографии персоны и кликните по \"Добавить в фавориты\". Если Вы знаете ID номер персоны, то Вы просто можете ввести ID в нижестоящее поле ввода.";
$pgv_lang["add_to_my_favorites"] 	= "Добавить в мои фавориты";
$pgv_lang["gedcom_favorites"]		= "Фавориты этого GEDCOM";
$pgv_lang["no_gedcom_favorites"]	= "На данный момент фавориты не выбраны. Администратор может добавить фаворитов, чтобы они отображались на стартовой странице.";
$pgv_lang["confirm_fav_remove"]		= "Вы уверены что хотите удалить это лицо из своих фаворитов?";
$pgv_lang["invalid_email"]		= "Ошибка в эл.адресе (e-mail). Введите правильный адрес.";
$pgv_lang["enter_subject"]		= "Введите тему сообщения";
$pgv_lang["enter_body"]			= "Введите текст сообщения";
$pgv_lang["confirm_message_delete"]	= "Вы уверены что хотите удалить сообщение? Восстановление невозможно.";
$pgv_lang["message_email1"]		= "Слудующее сообщение послано Вашему пользователю PhpGedView:";
$pgv_lang["message_email2"]		= "Вы послали следующее сообщение пользователю PhpGedView:";
$pgv_lang["message_email3"]		= "Вы послали следующее сообщение администратору PhpGedView:";
$pgv_lang["viewing_url"]		= "Сообщение послано со следующего URL:";
$pgv_lang["messaging2_help"]		= "Если Ваше сообщение послано, то Вы получите копию на эл.адрес, который Вы указали. ";
$pgv_lang["random_picture"]		= "Произвольное изображение";
$pgv_lang["message_instructions"]	= "<b>Внимание:</b>Конфидициальная информация о ныне живущих лицах предоставляется только родственным и другим авторизированным лицам. Прежде чем получить конфидициальную информацию, будет проверено Ваше родство с этим лицом. Иногда информация об уже умершем также является конфидициальной. Это помогает предотвратить недоразумения если установлено не точно, действительно ли этот человек является умершим. Может быть также возможным что об этой персоне нет больше информации. <br /><br /> Прежде чем задавать запрос, проконтролируйте даты, географию и членов семьи чтобы убедиться что вы выбрали дейтсвительно ту персону, которая Вам нужна. Если Вы предоставляете информацию по генеологии, укажите источник получения этой информации.";
$pgv_lang["sending_to"]			= "Это сообщение будет отправлено #TO_USER#";
$pgv_lang["preferred_lang"]	 	= "Этот пользователь предпочитает получать сообщения на языке #USERLANG#";
$pgv_lang["gedcom_created_using"]	= "Эта GEDCOM база данных была создана с помощью <b>#SOFTWARE# #VERSION#</b>";
$pgv_lang["gedcom_created_on"]		= "Эта GEDCOM база данных была создана <b>#DATE#</b>";
$pgv_lang["gedcom_created_on2"]		= "от <b>#DATE#</b>";
$pgv_lang["gedcom_stats"]		= "GEDCOM Статистика";
$pgv_lang["stat_individuals"]		= "Персон";
$pgv_lang["stat_families"]		= "Семей";
$pgv_lang["stat_sources"]		= "Источников";
$pgv_lang["stat_other"]			= "Других записей";
$pgv_lang["stat_earliest_birth"]        = "Самый ранний год рождения";
$pgv_lang["stat_latest_birth"]  	= "Последний год рождения";
$pgv_lang["stat_earliest_death"]        = "Самый ранний год смерти";
$pgv_lang["stat_latest_death"]  	= "Последний год смерти";
$pgv_lang["customize_page"]		= "Настроить Мой GedView";
$pgv_lang["customize_gedcom_page"]	= "Настроить Стартовую Страницу";
$pgv_lang["upcoming_events_block"]	= "Блок Наступающих Событий";
$pgv_lang["upcoming_events_descr"]	= "Блок Наступающих Событий отображает список событий текущей GEDCOM базы данных, которые произойдут в следующие 30 дней. Для зарегистрированных пользователей этот блок отображает только живущих людей, для остальных - всех.";
$pgv_lang["todays_events_block"]	= "Блок этого дня";
$pgv_lang["todays_events_descr"]	= "Бок этого дня в Вашей истории... Блок отображает список событий текущей GEDCOM базы данных, которые произошли в этот день. Если таких событий нет, то блок не отображается. Для зарегистрированных пользователей этот блок отображает только живущих людей, для остальных - всех.";
$pgv_lang["todo_block"] 		= "&quot;Задачи&quot;";
$pgv_lang["todo_descr"] 		= "Блок задачи показывает все выдающиеся факты задач в базе данных.";
$pgv_lang["todo_show_other"]     	= "Показать задачи других пользователей";
$pgv_lang["todo_show_unassigned"]	= "Показать не назначенные задачи";
$pgv_lang["todo_show_future"]    	= "Показать задачи будущего";
$pgv_lang["todo_nothing"]        	= "Нет задач.";
$pgv_lang["yahrzeit_block"]		= "Upcoming Yahrzeiten";
$pgv_lang["yahrzeit_descr"]		= "The Upcoming Yahrzeiten block shows anniversaries of death dates that will occur in the near future.  You can configure the period shown, and the Administrator can configure how far into the future this block will look.";
$pgv_lang["logged_in_users_block"]	= "Блок активных пользователей";
$pgv_lang["logged_in_users_descr"]	= "Блок активных пользователей показывает список пользователей, которые находятся на сайте в данный момент.";
$pgv_lang["user_messages_block"]	= "Блок сообщений";
$pgv_lang["user_messages_descr"]	= "Блок сообщений отображает список сообщений присланных активному пользователю.";
$pgv_lang["user_favorites_block"]	= "Блок фаворитов";
$pgv_lang["user_favorites_descr"]	= "Блок фаворитов отображает список персон, выбранных активным пользователем в качестве фаворитов для быстрого доступа к ним. ";
$pgv_lang["welcome_block"]		= "Блок приветствия пользователя";
$pgv_lang["welcome_descr"]		= "Блок приветствия пользователя отображает текущую дату, время, ссылку для изменения настроек, учетной записи и ссылку для быстрого перехода к собственному генеалогическому дереву.";
$pgv_lang["random_media_block"]		= "Блок случайного Медиа-объекта";
$pgv_lang["random_media_descr"]		= "Блок случайного Медиа-объекта случайно выбирает фотографию или другой медиа-объект из текущей GEDCOM базы данных и показывает его пользователю.";
$pgv_lang["random_media_persons_or_all"]= "Показать только персоны, события или все?";
$pgv_lang["random_media_persons"]	= "Персоны";
$pgv_lang["random_media_events"]	= "События";
$pgv_lang["gedcom_block"]		= "Блок GEDCOM приветствия";
$pgv_lang["gedcom_descr"]		= "Блок GEDCOM приветствия работает так же как Блок приветствия пользователя, приветствую посетителей сайта и отображая заголовок текущей GEDCOM базы данных, текущую дату и время.";
$pgv_lang["gedcom_favorites_block"]	= "Блок GEDCOM фаворитов";
$pgv_lang["gedcom_favorites_descr"]	= "Блок GEDCOM фаворитов позволяет администратору сайта выбрать некоторых персон из текущей GEDCOM базы данных так, чтобы посетители сайта могли быстро перейти к описанию этих персон. Это способ выделить наиболее важных людей в истории семьи.";
$pgv_lang["gedcom_stats_block"]		= "Блок GEDCOM статистики";
$pgv_lang["gedcom_stats_descr"]		= "Блок GEDCOM статистики отображает посетителем некоторую основную ищвормацию об текущей GEDCOM базе данных, такую как дату ее создания или количество персон в ней.";
$pgv_lang["gedcom_stats_show_surnames"]	= "Показать общие фамилии?";
$pgv_lang["portal_config_instructions"]	= "~#pgv_lang[customize_page]#~<br />~#pgv_lang[customize_gedcom_page]#~<br /><br />Здесь Вы можете настроить свою страницу этого сайта, а именно указать какие блоки и где именно Вы хотите расположить. Станица сайта делится на две секции 'Основную' и 'Правую'. 'Основная' секция отображает большие блоки под заголовком и вниз. 'Правая' секция отображает небольшие блоки в правой части страницы. Каждая секция имеет свой список блоков, которые будут выведены на странице в указанном порядке. Вы можете добавить, удалить или пересортировать блоки в секциях.";
$pgv_lang["login_block"]		= "Блок входа";
$pgv_lang["login_descr"]		= "Блок входа выводит поля для ввода имени и пароля пользователя.";
$pgv_lang["theme_select_block"] 	= "Блок выбора темы";
$pgv_lang["theme_select_descr"] 	= "Блок выбора темы отображает механизм выбора темы, даже если изменение темы запрещено.";
$pgv_lang["block_top10_title"]		= "Наиболее общие фамилии";
$pgv_lang["block_top10"]		= "Блок 10 лучших фамилий";
$pgv_lang["block_top10_descr"]		= "Этот блок показывает таблицу 10 фамилий, которые наиболее часто встречаются в  базе данных.";
$pgv_lang["block_givn_top10_title"]	= "Топ 10 имён";
$pgv_lang["block_givn_top10"]		= "Топ 10 имён";
$pgv_lang["block_givn_top10_descr"]	= "Этот блок показывает таблицу с 10 наиболее распространёнными именами вбазе данных. Актуальное количество показываемых имён конфигурируется.";

$pgv_lang["gedcom_news_block"]		= "Блок новостей GEDCOM";
$pgv_lang["gedcom_news_descr"]		= "Блок новостей GEDCOM отображает посетителям новости о новых версиях или статьи добавленные администратором. Новости хорошее место анонсировать обновление данных или воссоединение семьи.";
$pgv_lang["gedcom_news_limit"]		= "Ограничить отображение:";
$pgv_lang["gedcom_news_limit_nolimit"]	= "Нет ограничений";
$pgv_lang["gedcom_news_limit_date"]	= "Возраст пунктов";
$pgv_lang["gedcom_news_limit_count"]	= "Количество пунктов";
$pgv_lang["gedcom_news_flag"]		= "Ограничение:";
$pgv_lang["gedcom_news_archive"] 	= "Посмотреть архив";
$pgv_lang["user_news_block"]		= "Блок дневника пользователя";
$pgv_lang["user_news_descr"]		= "Блок дневника пользователя позволяет пользователю сохранять заметки и вести свой дневник в режиме on-line.";
$pgv_lang["my_journal"]			= "Мой дневник";
$pgv_lang["no_journal"]			= "У Вас не создано ни одной заметки для дневника.";
$pgv_lang["confirm_journal_delete"]	= "Вы уверены что хотите удалить эту заметку из дневника?";
$pgv_lang["add_journal"]		= "Добавить новую заметку в дневник";
$pgv_lang["gedcom_news"]		= "Новости";
$pgv_lang["confirm_news_delete"]	= "Вы уверены что хотите удалить эту новость?";
$pgv_lang["add_news"]			= "Добавить новость";
$pgv_lang["no_news"]			= "Нет новостей";
$pgv_lang["edit_news"]			= "Добавить/Удалить заметку для Дневника/Новостей";
$pgv_lang["enter_title"]		= "Пожалуйста введите заголовок.";
$pgv_lang["enter_text"]			= "Пожалуста введите какой-нибудь текст для этой заметки в Дневник или Новости.";
$pgv_lang["news_saved"]			= "Заметка для Дневника/Новостей успешно сохранена.";
$pgv_lang["article_text"]		= "Текст:";
$pgv_lang["main_section"]		= "Блоки основной секции";
$pgv_lang["right_section"]		= "Блоки правой секции";
$pgv_lang["available_blocks"]		= "Доступных блоков";
$pgv_lang["move_up"]			= "Вверх";
$pgv_lang["move_down"]			= "Вниз";
$pgv_lang["move_right"]			= "Вправо";
$pgv_lang["move_left"]			= "Влево";
$pgv_lang["broadcast_all"]		= "Сообщение для всех пользователей";
$pgv_lang["hit_count"]			= "Счетчик посещений";
$pgv_lang["phpgedview_message"]		= "PhpGedView сообщение";
$pgv_lang["common_surnames"]		= "Наиболее общие фамилии";
$pgv_lang["default_news_title"]		= "Добро пожаловать в Вашу Генеалогию";
$pgv_lang["default_news_text"]		= "Генеалогическая информация на этом сайте создана и отображается посредством <a href=\"http://www.phpgedview.net/\" target=\"_blank\">PhpGedView</a>. Эта страница представляет краткое описание этой генеалогической информации. Для просмотра данных выбирите чертеж/дерево в меню чертежей или перейдите к искомой персоне поиском по имении или месту проживания. <br /><br />Если Вы имеете сложности при работе с сайтом, нажмите на меню помощи и получите подсказку по работе с текущей страницей.<br /><br />Спасибо, за визит.";
$pgv_lang["reset_default_blocks"]	= "Установить набор блоков по умолчанию";
$pgv_lang["recent_changes"]		= "Последние изменения";
$pgv_lang["recent_changes_block"]	= "Блок последних изменений";
$pgv_lang["recent_changes_descr"]	= "Блок последних изменений отображает список изменений сделанных в GEDCOM базе данных за последний месяц. Этот блок поможет Вам быть в курсе поледних изменений.";
$pgv_lang["recent_changes_none"]	= "<b>Здесь не было изменений уже #pgv_lang[global_num1]# дней.</b><br />";
$pgv_lang["recent_changes_some"]	= "<b>Изменения были в течении последних #pgv_lang[global_num1]# дней</b><br />";
$pgv_lang["show_empty_block"]		= "Должен ли это блок быть невидимым, если нечего показывать?";
$pgv_lang["hide_block_warn"]		= "Если вы сделаете блок невидимым, то вы не сможете поменять эту настройку до тех пор, пока в ней что-то не появится.";
$pgv_lang["delete_selected_messages"]	= "Удалить выбранные сообщения";
$pgv_lang["use_blocks_for_default"]	= "Использовать эти блоки по умолчанию для всех пользователей?";
$pgv_lang["block_not_configure"]	= "Этот блок не может быть сконфигурирован.";

//-- validate GEDCOM
$pgv_lang["add_media_tool"]		= "Добавить Медиа-инструмент";

//-- hourglass chart
$pgv_lang["hourglass_chart"]		= "Двунаправленное дерево";

//-- report engine
$pgv_lang["choose_report"]		= "Выбирите отчет для запуска";
$pgv_lang["enter_report_values"]	= "Введите значения отчета";
$pgv_lang["selected_report"]		= "Выбранный отчет";
$pgv_lang["select_report"]		= "Выбрать отчет";
$pgv_lang["download_report"]		= "Скачать отчет";
$pgv_lang["reports"]			= "Отчеты";
$pgv_lang["pdf_reports"]		= "PDF Отчеты";
$pgv_lang["html_reports"]		= "HTML Отчеты";

//-- Ahnentafel report
$pgv_lang["ahnentafel_report"]		=  "Родословный отчёт";
$pgv_lang["ahnentafel_generation"]	= "Поколение ";
$pgv_lang["ahnentafel_pronoun_m"]	= "Он ";
$pgv_lang["ahnentafel_pronoun_f"]	= "Она ";
$pgv_lang["ahnentafel_born_m"]		= "был рождён";			// male
$pgv_lang["ahnentafel_born_f"]		= "была рождена";			// female
$pgv_lang["ahnentafel_christened_m"] 	= "был крещён";	// male
$pgv_lang["ahnentafel_christened_f"] 	= "была крещена";	// female
$pgv_lang["ahnentafel_married_m"]	= "женился";			// male
$pgv_lang["ahnentafel_married_f"]	= "вышла замуж";			// female
$pgv_lang["ahnentafel_married_post"]	= "&nbsp;";
$pgv_lang["ahnentafel_died_m"]		= "умер";				// male
$pgv_lang["ahnentafel_died_f"]		= "умерла";				// female
$pgv_lang["ahnentafel_cremated_m"]	= "был кремирован";		// male
$pgv_lang["ahnentafel_cremated_f"]	= "была кремирована";		// female
$pgv_lang["ahnentafel_buried_m"]	= "был погребён";			// male
$pgv_lang["ahnentafel_buried_f"]	= "была погребена";			// female
$pgv_lang["ahnentafel_place"]		= " в ";				// place name follows this
$pgv_lang["ahnentafel_no_details"]	= " но детали неизвестны";
$pgv_lang["ahnentafel_on"]			= " ";

//-- Changes report
$pgv_lang["changes_report"]		= "Сообщение об изменениях";
$pgv_lang["changes_pending_tot"]	= "Всего ожидаемых изменений: ";
$pgv_lang["changes_accepted_tot"]	= "Всего принятых изменений: ";

//-- Descendancy report
$pgv_lang["descend_report"]		= "Нисходящий отчёт";
$pgv_lang["son_of"]			= "сын";
$pgv_lang["daughter_of"]		= "дочь";
$pgv_lang["child_of"]			= "Ребёнок ";
$pgv_lang["children_of"]		= "Дети ";
$pgv_lang["descendancy_pronoun_m"]	= "Он ";
$pgv_lang["descendancy_pronoun_f"]	= "Она ";

$pgv_lang["family_group_report"]	= "Групповой отчет семьи";
$pgv_lang["page"]			= "Страница";
$pgv_lang["of"] 			= " ";
$pgv_lang["enter_famid"]		= "Введити ID семьи";
$pgv_lang["show_sources"]		= "Показать источники?";
$pgv_lang["show_notes"] 		= "Показать заметки?";
$pgv_lang["show_abbr_notes"] 		= "Показать сокращенные заметки?";
$pgv_lang["show_photos"]		= "Показать фотографии?";
$pgv_lang["relatives_report_ext"]	= "Расширенный отчёт по родственникам";
$pgv_lang["with"]			= "с";
$pgv_lang["on"]				= "на";			// for precise dates
$pgv_lang["in"]				= "в";
$pgv_lang["individual_report"]		= "Персональный отчет";
$pgv_lang["individual_with_rela_report"]= "Отчёт по близким родственникам";
$pgv_lang["enter_pid"]			= "Введите ID персоны";
$pgv_lang["generated_by"]		= "Сгенерировано ";
$pgv_lang["birth_report"]		= "Отчет дня и места рождения";
$pgv_lang["birthplace"]			= "Место рождения включает";
$pgv_lang["birthdate1"]			= "Начало линии дней рождения";
$pgv_lang["birthdate2"]			= "Конец линии дней рождения";
$pgv_lang["death_report"]		= "Отчёт по датам и местам смерти";
$pgv_lang["deathplace"]			= "Место смерти содержит";
$pgv_lang["deathdate1"]			= "Начало даты смерти";
$pgv_lang["deathdate2"]			= "Окончание даты смерти";
$pgv_lang["marr_report"]		= "Отчёт по датам и местам свадеб";
$pgv_lang["marrplace"]			= "Место брака содержит";
$pgv_lang["marrdate1"]			= "Начало даты брака";
$pgv_lang["marrdate2"]			= "Окончание даты брака";
$pgv_lang["sort_by"]			= "Сортировать по";
$pgv_lang["cemetery_report"]            = "Отчёт захоронений";

$pgv_lang["burialplace"]		= "Место захоронения содержит";
$pgv_lang["fact_sources_report"]	= "Источники фактов";
$pgv_lang["missing_facts_report"]	= "Потерянные родственные факты";
$pgv_lang["sources_to_events"]		= "Источники в события";

$pgv_lang["cleanup"]			= "Чистка";

//-- CONFIGURE (extra) messages for programs patriarch and statistics
$pgv_lang["statistics"]			= "Статистика";
$pgv_lang["show_stats_charts"]		= "Показать статистические отчёты";
$pgv_lang["decade_birth"]		= "Декада рождения";
$pgv_lang["decade_death"]		= "Декада смерти";
$pgv_lang["decade_marriage"]		= "Декада брака";
$pgv_lang["avg_age"]			= "Средний возраст";

//-- Merge Records
$pgv_lang["merge_same"] 		= "Записи разных типов. Невозможно объеденить записи разных типов.";
$pgv_lang["merge_step1"]		= "Объединение шаг 1 из 3";
$pgv_lang["merge_step2"]		= "Объединение шаг 2 из 3";
$pgv_lang["merge_step3"]		= "Объединение шаг 3 из 3";
$pgv_lang["select_gedcom_records"]	= "Выберите 2 GEDCOM записи для объединения. Записи должны быть одного типа.";
$pgv_lang["merge_to"]			= "Слить (объеденить) в ID:";
$pgv_lang["merge_from"] 		= "Слить (объеденить) из ID:";
$pgv_lang["merge_facts_same"]		= "Следующие факты абсолютно одинаковы в двух записях и будут автоматически объеденины.";
$pgv_lang["no_matches_found"]		= "Не найдено совпадающих фактов";
$pgv_lang["unmatching_facts"]		= "Следующие факты не совпадают. Выберите информацию, которую хотите оставить.";
$pgv_lang["record"] 			= "Запись";
$pgv_lang["adding"] 			= "Добавление";
$pgv_lang["updating_linked"]		= "Обновление связанных записей";
$pgv_lang["merge_more"] 		= "Объеденить больше записей.";
$pgv_lang["same_ids"]			= "Вы ввели такой же ID. Вы не можете объеденить одинаковые записи.";
$pgv_lang["updated_favorites"] 		= "фавориты обновлены.";

//-- ANCESTRY FILE MESSAGES
$pgv_lang["ancestry_chart"] 		= "Восходящее дерево";
$pgv_lang["gen_ancestry_chart"]		= "#PEDIGREE_GENERATIONS# Воcходящее дерево поколений";
$pgv_lang["chart_style"]		= "Стиль дерева";
$pgv_lang["chart_list"]			= "Список";
$pgv_lang["chart_booklet"]   		= "Буклет";
$pgv_lang["show_cousins"]		= "Показать двоюродных братьев/сестёр";
// 1st generation
$pgv_lang["sosa_2"] 				= "Отец";
$pgv_lang["sosa_3"] 				= "Мать";
// 2nd generation
$pgv_lang["sosa_4"]                             = "Дедушка";
$pgv_lang["sosa_5"]                             = "Бабушка";
$pgv_lang["sosa_6"]                             = "Дедушка";
$pgv_lang["sosa_7"]                             = "Бабушка";
// 3rd generation
$pgv_lang["sosa_8"] 				= "Прадедушка";
$pgv_lang["sosa_9"] 				= "Прабабушка";
$pgv_lang["sosa_10"]				= "Прадедушка";
$pgv_lang["sosa_11"]				= "Прабабушка";
$pgv_lang["sosa_12"]				= "Прадедушка";
$pgv_lang["sosa_13"]				= "Прабабушка";
$pgv_lang["sosa_14"]				= "Прадедушка";
$pgv_lang["sosa_15"]				= "Прабабушка";
// 4th generation
$pgv_lang["sosa_16"]				= "Прапрадедушка";
$pgv_lang["sosa_17"]				= "Прапрабабушка";
$pgv_lang["sosa_18"]				= "Прапрадедушка";
$pgv_lang["sosa_19"]				= "Прапрабабушка";
$pgv_lang["sosa_20"]				= "Прапрадедушка";
$pgv_lang["sosa_21"]				= "Прапрабабушка";
$pgv_lang["sosa_22"]				= "Прапрадедушка";
$pgv_lang["sosa_23"]				= "Прапрабабушка";
$pgv_lang["sosa_24"]				= "Прапрадедушка";
$pgv_lang["sosa_25"]				= "Прапрабабушка";
$pgv_lang["sosa_26"]				= "Прапрадедушка";
$pgv_lang["sosa_27"]				= "Прапрабабушка";
$pgv_lang["sosa_28"]				= "Прапрадедушка";
$pgv_lang["sosa_29"]				= "Прапрабабушка";
$pgv_lang["sosa_30"]				= "Прапрадедушка";
$pgv_lang["sosa_31"]				= "Прапрабабушка";

// for the general case of ancestors of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["sosa_paternal_male_n_generations"]	= "%3\$d x paternal great grandfather";
$pgv_lang["sosa_paternal_female_n_generations"]	= "%3\$d x paternal great grandmother";
$pgv_lang["sosa_maternal_male_n_generations"]	= "%3\$d x maternal great grandfather";
$pgv_lang["sosa_maternal_female_n_generations"]	= "%3\$d x maternal great grandmother";

//-- FAN CHART
$pgv_lang["compact_chart"]			= "Компактная диаграма";
$pgv_lang["fan_chart"]				= "Круговая диаграмма";
$pgv_lang["gen_fan_chart"]			= "#PEDIGREE_GENERATIONS# Веерное дерево поколений";
$pgv_lang["fan_width"]				= "Ширина веера";
$pgv_lang["gd_library"]				= "Ошибка конфигурации PHP сервера: требуется GD библиотека для использования функций работы с изображением.";
$pgv_lang["gd_freetype"]			= "Ошибка конфигурации PHP сервера: требуется Freetype библиотека для использования функций работы с TrueType шрифтами.";
$pgv_lang["gd_helplink"]			= "http://www.php.net/gd";
$pgv_lang["fontfile_error"]			= "Файл с шрифтами не найден на PHP сервере";
$pgv_lang["fanchart_IE"]			= "Эта картинка круговой диаграммы не может быть напечатана напрямую из вашего браузера. Используйте правую кнопку мыши для сохранения и печати.";

//-- RSS Feed
$pgv_lang["rss_descr"]				= "Новости и ссылки с сайта #GEDCOM_TITLE#";
$pgv_lang["rss_logo_descr"]			= "Создано на базе PhpGedView";
$pgv_lang["rss_feeds"]				= "RSS канал";
$pgv_lang["no_feed_title"]			= "Канал не доступен";
$pgv_lang["no_feed"]				= "Нет доступных RSS каналов на этом сайте PhpGedView";
$pgv_lang["feed_login"]				= "Если у вас есть аккаунт на этом PhpGedView сайте, , то вы можете  <a href=\"#AUTH_URL#\">залогиниться</a> на сервере используя простую аутентификацию HTTP, чтобы просмотреть приватную информацию.";
$pgv_lang["authenticated_feed"]			= "Аутентифицированный канал";

//-- ASSOciates RELAtionship
// After any change in the following list, please check $assokeys in edit_interface.php
$pgv_lang["attendant"]			= "Посетитель";
$pgv_lang["attending"]			= "Посещение";
$pgv_lang["best_man"]			= "Лучший человек";
$pgv_lang["bridesmaid"]			= "Подружка невесты";
$pgv_lang["buyer"]			= "Покупатель";
$pgv_lang["circumciser"]		= "Совершающий обрезание";
$pgv_lang["civil_registrar"]		= "ЗАГС";
$pgv_lang["employee"]			= "Сотрудник";
$pgv_lang["employer"]			= "Работодатель";
$pgv_lang["foster_child"]		= "Приёмный ребёнок";
$pgv_lang["foster_father"]		= "Приёмный отец";
$pgv_lang["foster_mother"]		= "Приёмная мать";
$pgv_lang["friend"]			= "Друг";
$pgv_lang["godfather"]			= "Крёстный отец";
$pgv_lang["godmother"]			= "Крёстная мать";
$pgv_lang["godparent"]			= "Крёстные родители";
$pgv_lang["godson"]			= "Крестник";
$pgv_lang["goddaughter"]		= "Крестница";
$pgv_lang["godchild"]			= "Крестник";
$pgv_lang["guardian"]			= "Опекун";
$pgv_lang["informant"]			= "Осведомитель";
$pgv_lang["lodger"]			= "Квартирант";
$pgv_lang["nanny"]			= "Няня";
$pgv_lang["nurse"]			= "Медсестра";
$pgv_lang["owner"]			= "Владелец";
$pgv_lang["priest"]			= "Священник";
$pgv_lang["rabbi"]			= "Раввин";
$pgv_lang["registry_officer"]		= "Registry Officer";
$pgv_lang["seller"]			= "Продавец";
$pgv_lang["servant"]			= "Слуга";
$pgv_lang["slave"]			= "Раб";
$pgv_lang["twin"]			= "Близнец";
$pgv_lang["twin_brother"]		= "Брат близнец";
$pgv_lang["twin_sister"]		= "Сестра близнец";
$pgv_lang["ward"]			= "Палата";
$pgv_lang["witness"]			= "Свидетель";

//-- statistics utility
$pgv_lang["stat_create"]		= "Создать свою собственную диаграмму";
$pgv_lang["statutci"]			= "невозможно проиндексовать";
$pgv_lang["statnnames"]			= "Всего индивидуалов";
$pgv_lang["statnfam"]			= "Всего семей";
$pgv_lang["statnmale"]			= "Всего мужчин";
$pgv_lang["statnfemale"]		= "Всего женщин";
$pgv_lang["with_sources"]		= "С источниками";
$pgv_lang["without_sources"]		= "Без источников";
$pgv_lang["stat_sindi"]			= "Индивидуалы с источником";
$pgv_lang["stat_sfam"]			= "Семьи с источниками";
$pgv_lang["statvars"]			= "Заполните следующие параметры для отрисовки";
$pgv_lang["statlxa"]			= "Выберите тип диаграммы:";
$pgv_lang["statlya"]			= "результаты:";
$pgv_lang["statlza"]			= "Категории:";
$pgv_lang["map_type"]			= "Тип карты";
$pgv_lang["stat_1_map"]			= "Индивидуальное распределение";
$pgv_lang["stat_2_map"]			= "Рождение по странам";
$pgv_lang["stat_3_map"]			= "Кончина по странам";
$pgv_lang["stat_4_map"]			= "брак по странам";
$pgv_lang["stat_5_birth"]		= "Рождения по столетиям";
$pgv_lang["stat_6_death"]		= "Кончина по столетиям";
$pgv_lang["stat_7_marr"]		= "Браки по столетиям";
$pgv_lang["stat_7_div"]			= "Разводы по столетиям";
$pgv_lang["stat_8_fam"]			= "Семьи с источниками";
$pgv_lang["stat_9_indi"]		= "Индивидуалы с источниками";
$pgv_lang["stat_10_none"]		= "нут";
$pgv_lang["stat_11_mb"]			= "Месяц рождения";
$pgv_lang["stat_12_md"]			= "Месяц смерти";
$pgv_lang["stat_13_mm"]			= "Месяц брака";
$pgv_lang["stat_14_mb1"]		= "Месяц рождения первого ребёнка в отношении";
$pgv_lang["stat_15_mm1"]		= "Месяц первого брака";
$pgv_lang["stat_16_mmb"]		= "Месяцев между браком и рождением первого ребёнка";
$pgv_lang["stat_17_arb"]		= "Возраст, связанный с годом рождения";
$pgv_lang["stat_18_ard"]		= "Возраст, связанный с годом смерти";
$pgv_lang["stat_18_aard"]		= "Средний возраст, связанный со столетием кончины";
$pgv_lang["stat_19_arm"]		= "Возраст в годах на дату брака";
$pgv_lang["stat_19_aarm"]		= "Средний возраст брака в столетии";
$pgv_lang["stat_20_arm1"]		= "Возраст в годах первого брака";
$pgv_lang["stat_21_nok"]		= "Часло детей";
$pgv_lang["stat_22_fwok"]		= "Число семей без детей";
$pgv_lang["stat_200_none"]		= "все (или пусто)";
$pgv_lang["stat_201_num"]		= "числа";
$pgv_lang["stat_202_perc"]		= "проценты";
$pgv_lang["stat_300_none"]		= "нет";
$pgv_lang["stat_301_mf"]		= "пол";
$pgv_lang["stat_302_cgp"]		= "периоды дат";
$pgv_lang["century"]			= "век";
$pgv_lang["stat_age"]			= "Возраст";
$pgv_lang["no_date_fam"]		= "неизвестно";
$pgv_lang["statar_xgp"]			= "границы периодов:";
$pgv_lang["statar_xgl"]			= "границы возрастов:";
$pgv_lang["statar_xgm"]			= "границы месцев:";
$pgv_lang["statar_xga"]			= "границы чисел:";
$pgv_lang["statar_zgp"]			= "границы периодов дат:";
$pgv_lang["less"]			= "менее чем";
$pgv_lang["over"]			= "более";
$pgv_lang["interval"]			= "интервал";
$pgv_lang["aft_marr"]			= "месяцев после вступления в брак";
$pgv_lang["bef_marr"]			= "месяцев до и после вступления в брак";
$pgv_lang["quarters"]			= "четвертей после вступления в брак";
$pgv_lang["half_year"]			= "полугодий после вступления в брак";
$pgv_lang["one_child"]			= "интервал одного ребёнка";
$pgv_lang["two_children"]		= "интервал двое детей";
$pgv_lang["statreset"]			= "перезапуск";
$pgv_lang["statsubmit"]			= "показать рисунок";
$pgv_lang["stat_largest_families"]	= "Самые большие семьи";

$pgv_lang["stat_own_charts"]		= "Свои диаграммы";
$pgv_lang["statnliving"]		= "Всего живущих";
$pgv_lang["statndead"]			= "Всего умерших";
$pgv_lang["stat_births"]		= "Всего рождений";
$pgv_lang["stat_marriages"]		= "Всего браков";
$pgv_lang["stat_divorces"]		= "Всего разводов";
$pgv_lang["stat_deaths"]		= "Всего умерших";
$pgv_lang["stat_first_birth"]		= "Старейшее рождение";
$pgv_lang["stat_first_marriage"]	= "Старейший брак";
$pgv_lang["stat_first_divorce"]		= "Старейший развод";
$pgv_lang["stat_first_death"]		= "Старейшая кончина";
$pgv_lang["stat_last_birth"]		= "Последнее рождение";
$pgv_lang["stat_last_marriage"]		= "Последний брак";
$pgv_lang["stat_last_divorce"]		= "Последний развод";
$pgv_lang["stat_last_death"]		= "Последняя кончина";
$pgv_lang["stat_lifespan"]		= "Продолжительность жизни";
$pgv_lang["stat_lived_longest"]		= "Максимальный возраст смерти";
$pgv_lang["stat_live_longest"]		= "Старожил";
$pgv_lang["stat_marr_age"]		= "Продолжительность брака";
$pgv_lang["stat_long_marr_age"]		= "Самый длинный брак";
$pgv_lang["stat_short_marr_age"]	= "Самый короткий брак";
$pgv_lang["stat_youngest_male"]		= "Младший мужчина";
$pgv_lang["stat_youngest_female"]	= "Младшая женщина";
$pgv_lang["stat_oldest_male"]		= "Старший мужчина";
$pgv_lang["stat_oldest_female"]		= "Старшая женщина";
$pgv_lang["stat_childbirth_age"]	= "Возраст при рождении ребёнка";
$pgv_lang["stat_youngest_father"]	= "Самый молодой отец";
$pgv_lang["stat_youngest_mother"]	= "Самая молодая мать";
$pgv_lang["stat_oldest_father"]		= "Самый старший отец";
$pgv_lang["stat_oldest_mother"]		= "Самая старшая мать";
$pgv_lang["stat_children_in_fam"]	= "Дети в семье";
$pgv_lang["stat_largest_gfamilies"]	= "Самая большая семья";
$pgv_lang["stat_age_difference"]	= "Разница в возрасте";
$pgv_lang["stat_age_siblings"]		= "Разница в возрасте между братьями и сёстрами";
$pgv_lang["stat_top_age_siblings"]	= "Максимальная разница в возрасте между братьями и сёстрами";
$pgv_lang["stat_age_mf_spouse"]		= "Разница в возрасте между мужем и женой";
$pgv_lang["stat_age_fm_spouse"]		= "Разница в возрасте между женой и мужем";
$pgv_lang["stat_names"]			= "Имена";
$pgv_lang["statnsurnames"]		= "Всего фамилий";
$pgv_lang["statngivennames"]		= "Всего имён";
$pgv_lang["top_surnames"]		= "Максимальное количество фамилий";
$pgv_lang["top_givennames"]		= "Максимальное количество имён";
$pgv_lang["events"]			= "События";
$pgv_lang["stat_records"]		= "Записи";
$pgv_lang["stat_notes"]			= "Заметки";
$pgv_lang["stat_first_event"]		= "Первое событие";
$pgv_lang["stat_last_event"]		= "Последнее событие";
$pgv_lang["stat_places"]		= "Места";
$pgv_lang["stat_birth_places"]		= "Места рождения";
$pgv_lang["stat_marriage_places"]	= "Места брака";
$pgv_lang["stat_death_places"]		= "Места смерти";
$pgv_lang["stat_countries"]		= "События в странах";

//-- statisticsplot utility
$pgv_lang["statistiek_list"]		= "График статистики";
$pgv_lang["stpl"]			= "...";
$pgv_lang["stplinfo"]			= "графическая информация:";
$pgv_lang["stpltype"]			= "тип:";
$pgv_lang["stplnoim"]			= " не применимо:";
$pgv_lang["stplmf"]				= " на пол";
$pgv_lang["stplipot"]			= " на временной период";
$pgv_lang["stplmonth"]			= "месяц";
$pgv_lang["stplnumbers"]		= "числа";
$pgv_lang["stplnuch"]			= "дети";
$pgv_lang["stplage"]			= "возраст";
$pgv_lang["stplperc"]			= "проценты";
$pgv_lang["stplnumof"]			= "Количество ";
$pgv_lang["stplmarrbirth"]		= "Месяцев между браком и рождением первого ребёнка";
$pgv_lang["indi_distribution_chart"]	= "Индивидуальный график распределения";
$pgv_lang["surname_distribution_chart"]	= "Фамильный график распределения";
$pgv_lang["g_chart_high"]		= "Самая высокая численность населения";
$pgv_lang["g_chart_low"]		= "Самая низкая численность населения";
$pgv_lang["g_chart_nobody"]		= "Никого";
$pgv_lang["area_chart"]			= "Географическая зона";
$pgv_lang["europe_chart"]		= "Европа";
$pgv_lang["s_america_chart"]		= "Южная Америка";
$pgv_lang["asia_chart"]			= "Азия";
$pgv_lang["middle_east_chart"]		= "Ближний Восток";
$pgv_lang["africa_chart"]		= "Африка";
$pgv_lang["world_chart"]		= "Мир";

//-- alive in year
$pgv_lang["alive_in_year"]		= "Живых в году";
$pgv_lang["is_alive_in"]		= "Живые в #YEAR#";
$pgv_lang["alive"]			= "Живой ";
$pgv_lang["dead"]			= "Умерший ";
$pgv_lang["maybe"]			= "Возможно ";
$pgv_lang["both_alive"]			= "Оба живы ";
$pgv_lang["both_dead"]			= "Оба мертвы ";

//-- Help system
$pgv_lang["definitions"]		= "Определения";

//-- Index_edit
$pgv_lang["block_desc"]			= "Описание блока";
$pgv_lang["click_here"]			= "Кликните здесь, чтобы продолжить";
$pgv_lang["click_here_help"]		= "~#pgv_lang[click_here]#~<br /><br />Кликните эту кнопку, чтобы сохранить ваши изменения.<br /><br />Вы будете возвращены на страницу #pgv_lang[welcome]# или #pgv_lang[mygedview]#, но ваши изменения возможно не отобразятся. Вероятно вам нужно будет обновить страницу вашего браузера, чтобы увидеть изменения.";
$pgv_lang["block_summaries"]		= "~#pgv_lang[block_desc]#~<br /><br />Здесь отображено короткое описание к блокам, которые вы можете добваить на страницу #pgv_lang[welcome]# или #pgv_lang[mygedview]#.<br /><br /><table border='1' width='95%'><tr><td class='list_value'><b>#pgv_lang[name]#</b></td><td class='list_value'><b>#pgv_lang[description]#</b></td></tr>#GLOBALS[blockSummaries]#</table>";

//-- Find page
$pgv_lang["total_places"]		= "Мест найдено";
$pgv_lang["media_contains"]		= "Медиа содержит:";
$pgv_lang["repo_contains"]		= "Репозитарий содержит:";
$pgv_lang["shared_note_contains"]	= "Общая заметка содержит:";
$pgv_lang["source_contains"]		= "Источник содержит:";
$pgv_lang["display_all"]		= "Отобразить все";

// FAQ Page
$pgv_lang["add_faq_header"]		= "Заголовок ЧАВО";
$pgv_lang["add_faq_body"]		= "Тело ЧАВО";
$pgv_lang["add_faq_order"]		= "Положение ЧАВО";
$pgv_lang["add_faq_visibility"]		= "Видимость ЧАВО";
$pgv_lang["no_faq_items"]		= "Список ЧАВО пуст.";
$pgv_lang["position_item"]		= "Положение пункта";
$pgv_lang["faq_list"]			= "Список ЧАВО";
$pgv_lang["confirm_faq_delete"]		= "Вы уверены, что хотите удалить этот ЧАВО?";
$pgv_lang["preview"]			=  "Предпросмотр";
$pgv_lang["no_id"]			= "Ну выбран пункт ID ЧАВО !";

// Help search
$pgv_lang["hs_title"]			= "Текст помощи поиска";
$pgv_lang["hs_search"]			= "Искать";
$pgv_lang["hs_close"]			= "Закрыть окно";
$pgv_lang["hs_results"]			= "Найден результат:";
$pgv_lang["hs_keyword"]			= "Что будем искать";
$pgv_lang["hs_searchin"]		= "Где будем искать";
$pgv_lang["hs_searchuser"]		= "Помощь пользователя";
$pgv_lang["hs_searchmodules"]		= "Помощь по модулям";
$pgv_lang["hs_searchconfig"]		= "Помощь администратора";
$pgv_lang["hs_searchhow"]		= "Тип поиска";
$pgv_lang["hs_searchall"]		= "Все слова";
$pgv_lang["hs_searchany"]		= "Любое слово";
$pgv_lang["hs_searchsentence"]		= "Точная фраза";
$pgv_lang["hs_intruehelp"]		= "Только текст помощи";
$pgv_lang["hs_inallhelp"]		= "Весь текс";

// Media import
$pgv_lang["choose"]			= "Выбрать: ";
$pgv_lang["account_information"]	= "Информация об учётной записи";

//-- Media item "TYPE" sub-field
$pgv_lang["TYPE__audio"]		= "Аудио";
$pgv_lang["TYPE__book"]			= "Книга";
$pgv_lang["TYPE__card"]			= "Карточка";
$pgv_lang["TYPE__certificate"]		= "Сертификат";
$pgv_lang["TYPE__coat"]			= "Герб";
$pgv_lang["TYPE__document"]		= "Документ";
$pgv_lang["TYPE__electronic"]		= "Электронно";
$pgv_lang["TYPE__fiche"]		= "Микрофиша";
$pgv_lang["TYPE__film"]			= "Микрофильм";
$pgv_lang["TYPE__magazine"]		= "Журнал";
$pgv_lang["TYPE__manuscript"]		= "Манускрипт";
$pgv_lang["TYPE__map"]			= "Карта";
$pgv_lang["TYPE__newspaper"]		= "Газета";
$pgv_lang["TYPE__photo"]		= "Фото";
$pgv_lang["TYPE__tombstone"]		= "Надгробная плита";
$pgv_lang["TYPE__video"]		= "Видео";
$pgv_lang["TYPE__painting"]		= "Картина";
$pgv_lang["TYPE__other"]		= "Другое";

//-- Other media suff
$pgv_lang["view_slideshow"]		= "Посмотреть слайдшоу";
$pgv_lang["download_image"]		= "Загрузить файл";
$pgv_lang["no_media"]			= "Медиа не найдено";
$pgv_lang["media_privacy"]		= "Ограничения частной жизни запрещает вам просматривать этот пункт";
$pgv_lang["relations_heading"]		= "Картинка относится к:";
$pgv_lang["file_size"]			= "Размер файла";
$pgv_lang["img_size"]			= "Размер картинки";
$pgv_lang["media_broken"]		= "Этот медиа файл испорчен и не может быть отмаркирован водяным знаком";
$pgv_lang["unknown_mime"]		= "Ошибка медиа файервола: >Неизвестный тип файла<";

//-- Modules
$pgv_lang["module_error_unknown_action_v2"]	= "Неизвестное действие: [действие].";
$pgv_lang["module_error_unknown_type"]		= "Неизвестный тип модуля.";

//-- sortable tables buttons
$pgv_lang["button_alive_in_year"]	= "Показать живущих людей в выбраном году.";
$pgv_lang["button_BIRT_Y100"]		= "Показать людей, рождённых за последние 100 лет.";
$pgv_lang["button_BIRT_YES"]		= "Показать людей, рождённых более 100 лет назад.";
$pgv_lang["button_DEAT_H"]		= "Показать пары, где только партнер-мужчина мертв.";
$pgv_lang["button_DEAT_N"]		= "Показать людей, которые живы или пары, где оба партнера являются живыми.";
$pgv_lang["button_DEAT_W"]		= "Показать пары, где только партнер-женщина мертва.";
$pgv_lang["button_DEAT_Y"]		= "Показать людей, которые мертвы или пары, где оба партнера умерших.";
$pgv_lang["button_DEAT_Y100"]		= "Показать людей, умерщих за последние 100 лет.";
$pgv_lang["button_DEAT_YES"]		= "Показать людей, умерших более 100 лет назад.";
$pgv_lang["button_MARR_DIV"]		= "Показать разведённые пары.";
$pgv_lang["button_MARR_U"]		= "Показать пары с неизвестной датой брака.";
$pgv_lang["button_MARR_Y100"]		= "Показать пары, которые женаты в течение последних 100 лет.";
$pgv_lang["button_MARR_YES"]		= "Показать пары, которые женаты более 100 лет назад.";
$pgv_lang["button_reset"]		= "Сбрость список по умолчанию.";
$pgv_lang["button_SEX_F"]		= "Показать только женщин.";
$pgv_lang["button_SEX_M"]		= "Показать только мужчин.";
$pgv_lang["button_SEX_U"]		= "Показать только персон, пол которых неизвестен.";
$pgv_lang["button_TREE_L"]		= "Показать «листья» пар или отдельных лиц. Это люди, которые живы, но не имеют детей, записанных в базу данных.";
$pgv_lang["button_TREE_R"]		= "Показать «Корни» пар или отдельных лиц. Эти люди могут быть названы «патриархами». Они являются ЛЮДЬМИ, которые не имеют родителей, записанных в базу данных.";
$pgv_lang["sort_column"]		= "Сортировать по этой колонке.";




$pgv_lang["ancestry_list"]			= "Список предков";
$pgv_lang["ancestry_booklet"]   	= "Буклет предков";

$pg_lang["link_as"]			= "\"Привязать\" эту персону к существующей семье как:";
$pgv_lang["error_title"]		= "ОШИБКА: Невозможно открыть файл GEDCOM";
$pgv_lang["build_title"]		= "Создание индексных файлов";
$pgv_lang["build_error"]		= "Обнаружен новый файл GEDCOM.";
$pgv_lang["please_wait"]		= "Индексные файлы должны быть обновлены, просьба подождать.";
$pgv_lang["choose_gedcom"]		= "Выберите файл GEDCOM";
$pgv_lang["login_aut"]			= "Мои данные";
$pgv_lang["no_support"]			= "Ваша версия программ Интернета не достаточна для требований PhpGedView. Большенство современных версий удовлетворяют этим требованиям. Мы советуем Вам установить более новую версию программ Интернета.";
$pgv_lang["max_generation"]		= "Максимальное количество поколений равно #PEDIGREE_GENERATIONS#.";
$pgv_lang["min_generation"]		= "Минимальное количество поколений равно 3.";
$pgv_lang["unable_to_find_indi"]	= "Невозможно найти Лицо под номером ID:";
$pgv_lang["unable_to_find_source"]	= "Невозможно найти Источник под номером ID:";
$pgv_lang["unable_to_find_repo"]	= "Невозможно найти Архив под номером ID:";
$pgv_lang["repo_name"]			= "Название архива:";
$pgv_lang["address"]			= "Адрес:";
$pgv_lang["phone"]			= "Телефон:";
$pgv_lang["source_name"]		= "Название источника:";
$pgv_lang["author"]			= "Автор:";
$pgv_lang["publication"]		= "Публикация:";
$pgv_lang["call_number"]		= "Шифр:";
$pgv_lang["not_an_array"]		= "Нет таблицы";
$pgv_lang["privacy_list_indi_error"]	= "В соответствии с правами доступа, одна или несколько персон скрыты.";
$pgv_lang["privacy_list_fam_error"]	= "В соответствии с правами доступа, одна или несколько семей скрыты.";
$pgv_lang["citation"]			= "Цитата:";
$pgv_lang["desc_chart2"]		= "Нисходящее<br />Древо";
$pgv_lang["still_living_error"]		= "Сведения о ныне живущих недоступны.<br />За дополнительной информацией просьба обращаться по адресу";
$pgv_lang["object_note"]		= "Примечание к объекту:";
$pgv_lang["place_description"]		= "Место / Описание";
$pgv_lang["media_object"]	= "Фото/аудио/видео объект:";
$pgv_lang["no_children"]	= "Сведений о детях нет";
$pgv_lang["clip_explaination"]		= "Данный инструмент позволяет вырезать &quot;Под-древа&quot; из Генеалогического Древа данной семьи и соединять их в единый файл формата GEDCOM для последующей загрузки на свой компьютер.<br /><br />";
$pgv_lang["item_with_id"]		= "Элемент под номером ID:";
$pgv_lang["error_already"]		= "уже находится в Вашей корзине.";
$pgv_lang["unable_to_open"]		= "Невозможно открыть каталог Под-древ на запись";
$pgv_lang["person_living"]		= "Это лицо - современник(ца). Персональные сведения о ныне живущих недоступны и включены не будут.";
$pgv_lang["media_files"]		= "Фото/аудио/видео файлы, на которые ссылается этот файл GEDCOM";
$pgv_lang["gedcom_form_info"]			= "(согласно файла GEDCOM)";
$pgv_lang["search_results"]		= "Результаты поиска";
$pgv_lang["lastname_empty"]		= "Укажите фамилию:";
$pgv_lang["soundex_results"]		= "Вполне вероятно что следующие мультимедийные результаты являются важными.";
$pgv_lang["sources_found"]		= "Источники найдены";
$pgv_lang["building_indi"]		= "Создание индексных файлов лиц и семей";
$pgv_lang["building_index"]		= "Создание индексных файлов";
$pgv_lang["importing_records"]		= "Добавить записи в базу данных";
$pgv_lang["detected_change"]		= "Программа PhpGedView обнаружила изменения в файле GEDCOM \$GEDCOM. Индексные файлы должны быть обновлены.";
$pgv_lang["flushing"]			= "Стирание оглавления";
$pgv_lang["indi_complete"]		= "Создание индексного файла Лиц завершено.";
$pgv_lang["family_complete"]		= "Создание индексного файла Семей завершено.";
$pgv_lang["source_complete"]		= "Создание индексного файла Источников завершено.";
$pgv_lang["tables_exist"]		= "PhpGedView таблицы уже находятся в базе данных";
$pgv_lang["you_may"]			= "Вы можете:";
$pgv_lang["drop_tables"]		= "Расширить существующие таблицы";
$pgv_lang["import_multiple"]		= "работать с несколькими GEDCOMs файлами";
$pgv_lang["explain_options"]		= "Если Вы будете работать с новым GEDCOM файлом, то вся информация в таблицах будет замещена этим GEDCOM файлом. <br />Если вы будете работать с несколькими GEDCOM файлами, то PhpGedView будет удалять все данные, которые имеют такие же имена GEDCOM файлов. Это действие делает возможным иметь несколько GEDCOM файлов в одних и тех же таблицах и просто заменять данные в таблицах. ";
$pgv_lang["path_to_gedcom"]		= "Укажите путь, где находится Ваш GEDCOM файл:";
$pgv_lang["gedcom_title"]		= "Дайте описание Вашего GEDCOM файла:";
$pgv_lang["index_complete"]		= "Индексация завершена.";
$pgv_lang["updating_is_dead"]		= "Изменить информацию о кончине для персоны INDI";
$pgv_lang["tools_readme"]			= "Более полная информация находится в файле #README.TXT#, путь \"tools-section\".";

$pgv_lang["xreftorin"]				= "Преобразовать XREF ID' в RIN номер";
$pgv_lang["dateconvert"]			= "Программа преобразования данных";
$pgv_lang["addmedia"]				= "Ввести медиа-инструменты (фото/аудио/видио)";
$pgv_lang["run_tools"]				= "Вы хотите экспортировать следующие программы до того как импортируете GEDCOM файл:";
$pgv_lang["updating_family_names"]	= "Доработать фамилии для FAM";
$pgv_lang["processed_for"]		= "Файл обработан для";
$pgv_lang["starts_with"]		= "Начинается на:";
$pgv_lang["person_list"]		= "Список лиц:";
$pgv_lang["paste_person"]		= "Добавить лицо";
$pgv_lang["notes_sources_media"]	= "Примечания, источники и мульмедия (фото/аудио/видео)";







$pgv_lang["rebuild_indexes"]		= "Индексировать заново";
$pgv_lang["import_gedcom"]		= "Импортировать этот файл GEDCOM";
$pgv_lang["enter_gedcomid"]		= "Вы должны ввести GEDCOM ID.";
$pgv_lang["user_info"]			= "Информация о пользователях";

$pgv_lang["enter_filename"]		= "Ввести имя GEDCOM файла.";
$pgv_lang["file_exists"]		= "GEDCOM файл с таким именем уже существует. Выбирете другое имя или откорректируйте старый файл.";
$pgv_lang["new_gedcom_title"]		= "Генеология из [#GEDCOMFILE#] файла";
$pgv_lang["upload_help"]		= "Выбирете файл, находящийся на локальном жестком диске, который Вы хотите послать на сервер. Этот файл перезапишет существующий GEDCOM файл. После этого файл будет автоматически заново проиндексирован в:";
$pgv_lang["add_gedcom_instructions"]	= "Присвойте имя новому GEDCOM файлу. Этот файл будет перемещен в Index-папку.";
$pgv_lang["research_log"]		= "Архив Log-файлов";
$pgv_lang["user_manual"]		= "Руководство пользователя PhpGedView";
$pgv_lang["upgrade"]			= "Перейти на более новую версию PhpGedView";
$pgv_lang["step5"]				= "Шаг 5 из 5:";
$pgv_lang["step4"]				= "Шаг 4 из 5:";
$pgv_lang["cancel_upload"]			= "Отменить выгрузку";
$pgv_lang["step3"]				= "Шаг 3 из 5:";
$pgv_lang["step1"]				= "Шаг 1 из 5:";

$pgv_lang["step5"]				= "Шаг 5 из 5";


$pgv_lang["now_import"]			= "Кликните здесь если хотите импортировать записи из GEDCOM в PhpGedView";


$pgv_lang["year_error"]			= "Извините, даты ранее 1970 года не поддерживаются.";
$pgv_lang["register_info_01"]		= "Сведения этого сайта не полностью доступны для публичного просмотра. <br /><br /> Это соответствует закону по защите личных прав. Многие люди не желают чтобы сведения о них были доступны для публичного просмотра, т.к. они могут быть использованы в целях злоупотребления полученной информации или в коммерческих целях. <br /><br /> Для того, чтобы Вы смогли посмотреть расширенные сведения, Вы должны зарегистрироваться на нашем сайте. Тогда администратор сможет проконтролировать Ваши личные данные. В случае если у вас существуют родственные связи с каким-либо лицом, информация о котором находится в файле, то после регистрации у Вас будет доступ к информации по Вашиму прямому родству. Администратор может предоставить Вам доступ к данным файла, после того, как Вы введете Ваше личные данные. <br /><br /> Примечание: Доступ к информации, запрещенной для просмотра Вы можете получить только если Вас связывает близкое родство с лицом, информация о котором находится в файле. <br /><br /
> В остальных случаях мы просим Вас не тратить время и силы на получение разрешения на просмотр информации. Если Вам необходимо более подробное разъяснение, кликните по нижестоящей кнопочке для контакта с администратором. <br /><br />";
$pgv_lang["pls_note01"]			= "Внимание: система различает заглавные и строчные буквы!";
$pgv_lang["min6chars"]			= "Пароль должен содержать минимум 6 символов";
$pgv_lang["pls_note02"]			= "Внимание: Пароль может содержать только буквы и цифры. Использование знаков препинания недопустимо.";
$pgv_lang["pls_note03"]			= "Пользователь будет активизирован после проверки эл.адреса. Это не будет показано на сайте. На этот эл.адрес Вы получите сообщение, в котором будет находиться необходимая для регистрации информация.";

$pgv_lang["pls_note04"]			= "Поля со звездочкой * должны быть заполнены";
$pgv_lang["pls_note05"]			= "Вы получите подтверждение на эл.адрес, который вы указали. С данными из этого письма Вы можете активизировать Ваше имя пользователя. Если Вы это не сделаете в течение 7 дней, то Ваш запрос будет удален. Запрос всегда можно подать заново. Для полного доступа на этот сайт, Вы должны иметь имя пользователя и пароль. Вы должны указать на этом сайте Ваш действующий эл.адрес, на который Вы будете получать данные пользователя.<br /><br /> Если у Вас существуют проблемы с запросом имя пользователя для этого сайте, обратитесь к администратору сайта.";
$pgv_lang["pls_note04"]			= "Поля со звездочкой должны быть заполнены.";
$pgv_lang["pls_note03"]			= "Пользователь будет активизирован после проверки этого эл.адреса. Это не будет показано на сайте. Вы получите сообщение на эл.адрес, в котором будет необходимая для регистрации информация.";

$pgv_lang["savedata"]			= "Сохранить измененные данные";
$pgv_lang["datachanged"]		= "Данные пользователя изменены!";
$pgv_lang["datachanged_name"]		= "Войдите в программу заново с новым именем пользователя";


$pgv_lang["portal"]			= "Портал";

$pgv_lang["add_main_block"]		= "Добавить блок в основную секцию...";
$pgv_lang["add_right_block"]		= "Добавить блок в правую секцию";

$pgv_lang["upgrade_util"]		= "Программа выгрузки";
$pgv_lang["no_upgrade"]			= "Нет файлов для работы.";
$pgv_lang["use_version"]		= "Вы используете версию:";
$pgv_lang["current_version"]		= "Действующая в настоящем стабильная версия:";
$pgv_lang["upgrade_download"]		= "Загрузка:";
$pgv_lang["upgrade_tar"]		= "TAR";
$pgv_lang["upgrade_zip"]		= "ZIP";
$pgv_lang["latest"]			= "Вы работаете с последней действующей версией PhpGedView.";
$pgv_lang["location"]			= "Место нахождения файлов новой версии:";


$pgv_lang["inc_phpgedview"]		= "PhpGedView";
$pgv_lang["inc_config"]			= "Файл конфигурации";
$pgv_lang["inc_researchlog"]		= "Архив Log-файлов";
$pgv_lang["inc_index"]			= "Индексные файлы";
$pgv_lang["inc_themes"]			= "Темы";
$pgv_lang["inc_docs"]			= "Инструкции";
$pgv_lang["inc_privacy"]		= "Персональный(ые) файл(ы)";
$pgv_lang["inc_backup"]			= "Сделать архивную копию";
$pgv_lang["upgrade_help"]		= "Помощник (по выгрузке)";
$pgv_lang["cannot_read"]		= "Нечитаемый файл:";
$pgv_lang["not_configured"]		= "Ваш PhpGedView еще не конфигурирован.";
$pgv_lang["location_upgrade"]		= "Укажите место расположения файлов для обновления версии.";
$pgv_lang["cannot_read"]		= "Нечитаемф";
$pgv_lang["new_variable"]		= "Найдена новая переменная:";
$pgv_lang["config_open_error"] 		= "Ошибка при открытии файла конфигурации.";

$pgv_lang["config_uptodate"]		= "Ваш файл конфигурации доработан.";
$pgv_lang["processing"]			= "Идет обработка...";
$pgv_lang["privacy_open_error"] 	= "Ошибка при открытии файла [#PRIVACY_MODULE#].";
$pgv_lang["privacy_write_error"] 	= "Ошибка!!! Запись в [#PRIVACY_MODULE#] невозможна. <br /> Убедитесь что у Вас установлены полномочия на запись в этот файл. Установить эти полномочия возможнл в личном (персональном) файле.";
$pgv_lang["privacy_update_ok"]		= "Личный файл [#PRIVACY_MODULE#] доработан.";
$pgv_lang["privacy_uptodate"]		= "Ваш [#PRIVACY_MODULE#] файл доработан.";
$pgv_lang["heading_privacy"]		= "Личные файл(ы):";
$pgv_lang["heading_phpgedview"]		= "PhpGedView-файлы";
$pgv_lang["heading_image"]		= "Файлы мультимедиа (фото/аудио/видио):";
$pgv_lang["heading_index"]		= "Индексные файлы:";
$pgv_lang["heading_language"]		= "Файлы языков:";
$pgv_lang["heading_theme"]		= "Файлы тем:";
$pgv_lang["heading_docs"]		= "Руководство:";
$pgv_lang["heading_researchlog"]	= "Log-файлы (архив, статистика):";
$pgv_lang["heading_researchloglang"]	= "Языковые log-файлы (архив, статистика):";
$pgv_lang["heading_language"]		= "Файлы языков";
$pgv_lang["copied_success"]		= "Копирование удачно завершено";
$pgv_lang["backup_copied_success"]	= "Архивное копирование завершена успешно.";
$pgv_lang["process_error"]		= "Проблема с этой страницей. Более новая версия не найдена.";
$pgv_lang["upgrade_completed"]		= "Обновление успешно завершено";
$pgv_lang["start_using_upgrad"]		= "Нажмите сюда, чтобы начать использовать версию";
$pgv_lang["changed_mac"]		= "Обнуружены окончания строк в стиле Макинтош. Замените окончания строк состоящие только из ВВОДа на ВВОД и ПЕРЕВОД КАРЕТКИ.";
$pgv_lang["changed_places"]		= "Обнаружен неправильный формат географических названий. Исправьте записи географический названий в соответствии со спецификацией GEDCOM 5.5. Пример из Ваших GEDCOM данных:";
$pgv_lang["optional_tools"]		= "Вы можете выбрать для запуска следующие необязательные инструменты перед импортированием.";
$pgv_lang["optional"]			= "Необязательные Инструменты";
$pgv_lang["launch_media_tool"]		= "Нажмите здесь чтобы запустить Добавление Медиа-инструмента.";
$pgv_lang["add_media_descr"]		= "Этот инструмент будет добавлять медиа OBJE ярлыки к GEDCOM данным. Выбирите это окно когда закончите добавлять медиа-объект.";
$pgv_lang["extension"]			= "Расширение";
$pgv_lang["order"]			= "Порядок";
$pgv_lang["add_media_button"]		= "Добавить Медиа-объект";
$pgv_lang["media_table_created"]	= "Таблица <i>Медиа-объектов</i> успешно обновлена.";
$pgv_lang["click_to_add_media"]		= "Нажмите здесь, чтобы добавить Медиа-объект к GEDCOM данным #GEDCOM#.";
$pgv_lang["adds_completed"]		= "Медиа-объект успешно добавлен в GEDCOM файл.";
$pgv_lang["run_report"]			= "Посмотреть отчет";
$pgv_lang["individual_list_report"]	= "Персональный отчет списком";
$pgv_lang["dynasty_list"]		= "Обзор семей";
$pgv_lang["make_slklist"]		= "Создать список EXCEL (SLK) ";
$pgv_lang["excel_list"]			= "Вывод в EXCEL (slk) формате следующих файлов (сначало используется список основателей):";
$pgv_lang["excel_tab"]			= "tabblad:";
$pgv_lang["excel_create"]		= "будет создано в файле:";
$pgv_lang["patriarch_list"]		= "Список основателей";
$pgv_lang["slk_list"]			= "EXCEL SLK список";
$pgv_lang["fan_chart"]				= "Веерное дерево";
$pgv_lang["pedigree_map"]     = "Родословная на карте";
?>
