<?php
/**
 * Media Link Assistant Control module for phpGedView
 *
 * Media Link information about an individual
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2022  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Census Assistant
 * @version $Id: media_query_3a.php 7354 2022-10-27 18:46:54Z canajun2eh $
 */

$iid2		= safe_GET('iid');

print_header($pgv_lang["link_media"], false);

$record=GedcomRecord::getInstance($iid2);
$headjs="";
if ($record) {
	if ($record->getType()=='FAM') {
		$idrecord=Family::getInstance($iid2);
		if ($idrecord->getHusbId()) {
			$headjs=$idrecord->getHusbId();
		}else{
			$headjs=$idrecord->getWifeId();
		}
	}
	?>
	<script language="JavaScript" type="text/javascript">
	function insertId() {
		if (window.opener.document.getElementById('addlinkQueue')) {
			// alert('Please move this alert window and examine the contents of the pop-up window, then click OK')
			window.opener.insertRowToTable("<?php echo $record->getXref(); ?>", "<?php echo htmlSpecialChars($record->getFullName()); ?>", "<?php echo $headjs;?>");
			window.close();
		}
	}
	</script>
	<?php

} else {
	?>
	<script language="JavaScript" type="text/javascript">
	function insertId() {
		window.opener.alert('<?php echo strtoupper($iid2); ?> - <?php echo $pgv_lang["id_not_valid"] ?>');
		window.close();
	}
	</script>
	<?php
}
?>

<script language="JavaScript" type="text/javascript">
 window.onLoad = insertId();
</script>
