<?php
/**
 * Research Assistant Guide
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Research_Assistant
 * @version $Id: ra_guide.php 7379 2024-11-20 13:22:30Z canajun2eh $
 * Douglas Terry - this file generates an old Research Assistant dashboard - I think 
 *   this whole file could be removed, but first remove duplicate functions and dangerous
 *   functions.  Default menu has My Tasks, Add Task, View Folders and Add Folder	 so
 *   consider them duplicates to remove.  Complete A Task is dangerous as can't see the
 *   current state, too easy to accidently hit wrong one as no way to back out of complete
 *   current, so also removing this.  Manage Sources contains Sources List (on main menu)
 *   and Add an unlinked source which is on the admin menu so remove both of these.
 *   Analyze People just takes you to the individuals Research Assistant submenu so
 *   duplication of effort so comment this out.  Analyze Database / viewing probablities
 *   is a more academic function so moved to bottom of actions as expect no one to use it.
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

require_once PGV_ROOT.'modules/research_assistant/forms/ra_form.php';

/**
 * Edit Folder class for the editfolder form
 * 
 * @uses ra_form
 */
class ra_guide extends ra_form {

	/**
	 * Show the main Research Assistance form to the user
	 * This will currently provide only the three functions: Search External Web Sources (ie Auto_Search)
	 * Analyze Database (ie View Probabilities) and Configure RA Privacy rights (ie Configure Privacy)
	 * The Configure Privacy is a restricted function so limited to PGV administrators only
	 * 
	 * @return object
	 */
	function display_form()
	{
		global $SHOW_RESEARCH_ASSISTANT, $SHOW_VIEW_PROBABILITIES, $SHOW_AUTO_GEN_TASK;
		global $TEXT_DIRECTION, $PGV_IMAGE_DIR, $PGV_IMAGES;
		// Obtain the global vars needed
		global $pgv_lang, $factarray;
		$out = '';
		$out .= (new ra_functions)->print_menu()."</table>";
		ob_start();

		// Note that the rest of this file is a mix of Javascript and PHP
		?>
		<script language="JavaScript" type="text/javascript">
		<!--
		var pastefield;
		function paste_id(value) {
			pastefield.value=value;
		}
		//-->
		</script>
		<div align="center">
		<table class="list_table" align="center" border="0" width=66% ><tr>
		<th colspan="4" align="right" class="topbottombar">
		<h2>
		<?php  print $pgv_lang["research_assistant"]; ?>
		</h2>
		</th>
		</tr>
		</table>
		<div id="guide_tabbar" <?php if($TEXT_DIRECTION=="rtl") echo ' align="right"'; else echo ' align="left"';?> style="width: 65%; margin-left: 25px;">
			<div id="guide_research" name="<?php print $pgv_lang["ra_manage_research"];?>" class="indent" >
				<fieldset>
					<legend> <?php print print_help_link("ra_auto_search_help", "qm", '', false, true).$pgv_lang["ra_auto_search_text"]; ?></legend>
					<form name="selector" action="" method="post" onsubmit="return false;">
					<?php print $pgv_lang["ra_pid_search_for"]; ?><br />
					<input type="text" name="aspid" id="aspid" size="5" onchange="search_selector(this.value);"/><?php print_findindi_link("aspid",""); ?>
					<select name="cbosite" onchange="search_selector(document.getElementById('aspid').value);">
					<option value=""><?php print $pgv_lang["ra_choose_search_site"];?></option>
					<?php print (new ra_functions)->autoSearchFormOptions(); ?>
					</select> 
					</form>
					<div id="searchdiv"></div>
				</fieldset>
<!-- // Currently the Generate tasks function isn't handling _TODO items correctly, so temporarily disable it
		<?php if ((PGV_USER_ACCESS_LEVEL<= $SHOW_AUTO_GEN_TASK)) {   ?>
				<fieldset>
					<legend> <?php print print_help_link("ra_GenerateTasks_help", "qm", '', false, true).$pgv_lang["ra_gen_tasks"]; ?></legend>
					<?php print $pgv_lang["ra_auto_gen_inst"]; ?><br />
					<a href="module.php?mod=research_assistant&amp;action=genTasks">
					<img src="modules/research_assistant/images/add_task.gif" alt="<?php print $pgv_lang["ra_gen_tasks"]; ?>" border="0"></img> 
					<?php print $pgv_lang["ra_gen_tasks"]; ?></a><br />
				</fieldset>
		<?php }  ?>
-->
			</div>
			<div id="guide_analyze" name="<?php print $pgv_lang['ra_analyze_data'];?>" class="indent" >

			<!-- View Probabilities if have the privilege -->
		<?php if ((PGV_USER_ACCESS_LEVEL<= $SHOW_VIEW_PROBABILITIES)) {   ?>
				<fieldset>
					<legend> <?php print print_help_link("ra_ViewProb_help", "qm", '', false, true).$pgv_lang["ra_analyze_database"];?></legend>
						<a href="module.php?mod=research_assistant&amp;action=viewProbabilities">
						<img src="modules/research_assistant/images/view_inferences.gif" alt="<?php print $pgv_lang["ra_view_probabilities"]; ?>" border="0"></img>
					<?php print $pgv_lang["ra_view_probabilities"]; ?></a>
				</fieldset>
		<?php }  ?>

			<!-- Configure Privacy if have the privilege -->
		<?php if (PGV_USER_IS_ADMIN) {  ?>
				<fieldset>
					<legend> <?php print print_help_link("ra_configure_privacy_help", "qm", '', false, true).$pgv_lang["ra_configure_privacy"]; ?></legend>
					<a href="module.php?mod=research_assistant&amp;action=configurePrivacy">
					<img src="modules/research_assistant/images/admin.gif" alt="<?php print $pgv_lang["ra_configure_privacy"]; ?>" border="0"></img>
					<?php print $pgv_lang["ra_configure_privacy"]; ?></a><br />
				</fieldset>
		<?php }  ?>
			</div>
		</div>
		</div>
		<?php
		$out .= ob_get_contents();
		ob_end_clean();
		return $out;
	}
 }
?>
