<?php
/**
 * Catalan language Help file for PhpGedView Research Assistant module
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Research_Assistant
 * @version $Id: help_text.ca.php 7377 2024-10-18 13:50:13Z canajun2eh $
 *
 * The companion file to this is lang.ca.php, which contains most of the brief texts.
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

//-- Miscellaneous advisories and instructions
$pgv_lang["ra_auto_gen_inst"]		= "Alguns programes us permeten introduir tasques de recerca com a elements TODO a la vostra base de dades genealògica. Aquesta opció cercarà a la vostra base de dades genealògica i convertirà automàticament cada element TODO en una tasca de recerca.";
$pgv_lang["ra_mytasks_block_descr"]		= "El bloc «#pgv_lang[ra_my_tasks]#» mostra les tasques de l'usuari actual. Es pot configurar per mostrar tasques completades o per mostrar tasques que actualment no estan assignades.";

//-- RA HELP MESSAGES
// - Variables with *_help are the actual help texts. *_words are useful text blocks that can be used multiple times in different help texts 

$pgv_lang["ra_organizetasks_words"]		= "~Com organitzar les tasques~<br /><br />Les tasques s'organitzen en carpetes. Com a mínim ha d'existir una carpeta abans que es pugui crear cap tasca.<br /><br />Podeu crear i organitzar les vostres carpetes com vulgueu. Probablement voldreu organitzar les vostres carpetes en línia com si organitzeu còpies en paper de la vostra recerca. Molts investigadors organitzen les seves carpetes per línia familiar, cognom o ubicacions geogràfiques.";
$pgv_lang["ra_whataretasks_words"]		= "~Què són les tasques?~<br /><br />El mòdul #pgv_lang[ra_RA_name]# es centra en la tasca de recerca. Una tasca d'investigació és similar a un ítem TODO i fa un seguiment d'una tasca d'investigació genealògica concreta que s'ha de fer. Un exemple de títol de la tasca pot ser «Troba l'expedient de naixement de Joe», mentre que els detalls de la descripció indicarien «Troba l'expedient de naixement de Joe als registres de naixement del comtat d'Ottawa».<br /><br />Les tasques es poden assignar a usuaris específics. En assignar tasques als usuaris, tothom sap en quina recerca ha de treballar i qui està treballant en altres tasques d'investigació.<br /><br />Les tasques també poden incloure accions contra material d'origen o relacionades amb una o més persones de les vostres dades. Amb el mòdul #pgv_lang[ra_RA_name]# instal·lat, veureu una secció «#pgv_lang[ra_RA_name]#» a cada pàgina «#pgv_lang[personal_facts]#» i també una secció Tasques a cada pàgina de dades d'origen.<br /><br />Les tasques es creen a l'estat <b>#pgv_lang[ra_incomplete]#</b>, la qual cosa indica que el treball està en curs. Totes les tasques s'han d'assignar a un usuari que pugui editar i actualitzar els registres amb les troballes. Un cop feta tota la feina, la tasca s'ha d'enviar com a <b>#pgv_lang[ra_complete]#</b>. Això l'eliminarà de les llistes de tasques visibles activament (és a dir, #pgv_lang[ra_incomplete]#). Mitjançant el menú «#pgv_lang[ra_my_tasks]#», cada usuari pot veure les seves tasques assignades, tant #pgv_lang[ra_incomplete]# com #pgv_lang[ra_complete]#.<br /><br />Cada tasca té una secció de comentaris on es poden discutir sobre les dades i la investigació o els possibles resultats. Això permet que la tasca es mantingui orientada a objectius mentre els comentaris estan orientats al progrés i als resultats.";
$pgv_lang["ra_sortcol_words"]		= "Aquesta columna es pot ordenar fent clic a la capçalera de la columna.";
$pgv_lang["ra_folder_words"]			= "Les carpetes són una eina de gestió de tasques que permet agrupar tasques. Les carpetes es poden contenir dins d'altres carpetes. Si hi ha una carpeta principal, es mostrarà a la part esquerra dels menús de dalt. Si aquesta àrea està en blanc, aquestes carpetes es troben al nivell superior.";
$pgv_lang["ra_view_task_words"]		= "Les tasques són maneres de gestionar tasques pendents o accions de recerca per fer-ne un seguiment. La tasca es resumeix pel seu títol, mentre que el camp de descripció defineix més detalls sobre el que es requereix. De vegades, el seguiment de la resolució també es pot incloure al camp de descripció. A sota de la taula «#pgv_lang[ra_Task_View]#» hi ha una taula «#pgv_lang[ra_comments]#» que es pot utilitzar per fer un seguiment del progrés i per descriure les resolucions de tasques.";
$pgv_lang["ra_special_char_words"]		= "De vegades, és possible que el vostre text hagi de mostrar símbols que tinguin significats especials per al navegador o per a PhpGedView, a part de ser text normal. Quan aquests símbols han d'aparèixer al vostre text, heu d'introduir-los en un format que indiqui que són text sense significat especial.<ul><li><b>&amp;</b>&nbsp;&nbsp;Aquest símbol indica l'inici d'una entitat HTML. Per indicar que aquest símbol és text normal, podeu assegurar-vos que sempre vagi seguit d'un espai, o bé introduir-lo al seu formulari d'Entitat HTML <b>&amp;amp;</b></li><li><b>&#35;</b>&nbsp;&nbsp;Aquest símbol s'utilitza al sistema d'ajuda de PhpGedView. Per indicar que aquest símbol és text normal, podeu assegurar-vos que sempre vagi seguit d'un espai, o bé introduir-lo en la seva forma numèrica <b>&amp;&#35;35;</b></li><li><b>&#126;</b>&nbsp;&nbsp;Aquest símbol s'utilitza al sistema d'ajuda de PhpGedView. Per indicar que aquest símbol és text normal, podeu assegurar-vos que sempre va seguit d'un espai o bé introduir-lo en la seva forma numèrica <b>&amp;&#35;126;</b></li><li><b>&#92;</b>&nbsp;&nbsp;Aquest símbol és interpretat pel navegador com a significat que el símbol que segueix és text. Per indicar que aquest símbol és text normal, n'has d'introduir dos <b>&#92;&#92;</b> o pots introduir-lo en la seva forma numèrica <b>&amp;&#35;92; </b></li><li><b>&lt;</b>&nbsp;&nbsp;Aquest símbol és interpretat pel navegador per indicar l'inici d'una etiqueta HTML. Per indicar que aquest símbol és text normal, heu d'introduir-lo al seu formulari d'Entitat HTML <b>&amp;lt;</b></li><li><b>&gt;</b>&nbsp;&nbsp;Aquest símbol és interpretat pel navegador per indicar el final d'una etiqueta HTML. Per indicar que aquest símbol és text normal, heu d'introduir-lo al seu formulari d'Entitat HTML <b>&amp;gt;</b></li></ul>Podeu crear llistes d'elements en una descripció. Si voleu acabar les llistes numerades o amb vinyetes, comenceu a introduir aquests elements de la llista amb <b>&lt;ul&gt;</b> per a una llista amb vinyetes o <b>&lt;ol&gt;</b> per a una llista numerada.<br /><br />Cada element de la llista hauria de començar per <b>&lt;li&gt;</b> i acabar amb <b>&lt;/li&gt;</b>. L'últim element de la llista s'ha d'acabar com tots els altres i ha d'anar seguit de <b>&lt;/ul&gt;</b> per tancar la llista amb vinyetes o <b>&lt;/ol&gt;</b> per tancar la llista numerada.<br /><br />Les notes anteriors sobre la introducció dels símbols «Menys que» <b>&lt;</b> i «Superior a» <b>&gt;</b>, que solen incloure etiquetes HTML, ja que el text no s'aplica, ja que en aquest cas realment cal introduir etiquetes HTML.";
$pgv_lang["ra_add_task_words"]		= "Abans que es pugui crear cap tasca, <u>heu</u> d'haver establert una carpeta per contenir aquesta tasca.<br /><br />Les tasques són maneres de gestionar tasques pendents o accions de recerca per fer-ne un seguiment. Aquestes tasques es resumeixen pels seus títols i utilitzen els camps de descripció per definir amb més detall el que es requereix. Les tasques també poden tenir algun material d'origen per investigar, de manera que es pot adjuntar, i si hi ha una o més persones amb les quals està associada aquesta tasca, també s'haurien d'adjuntar a aquesta nova tasca.";


$pgv_lang["ra_mytasks_help"]			= "<ul>~#pgv_lang[ra_my_tasks]#~<br /><br />La llista «#pgv_lang[ra_my_tasks]#» mostra les tasques de recerca de l'usuari actual. Per defecte, la llista de tasques mostra tasques obertes o incompletes per a l'usuari actual. Això es pot configurar per mostrar, addicionalment, les tasques completades i per mostrar les tasques que actualment no estan assignades. Aleshores, la taula resultant es pot utilitzar per veure ràpidament les tasques de recerca a gestionar.<ul><li>Quan feu clic a un <b>#pgv_lang[ra_title]#</b>, se us dirigirà a un «#pgv_lang[ra_Task_View]#» per obtenir més detalls sobre la tasca específica.</li><li>#pgv_lang[ra_Start_Date]# indica quan va ser originalment la tasca. creat.</li><li>Quan feu clic a <b>#pgv_lang[ra_edit]#</b> al final de la fila de cada tasca, se us dirigirà a la vista «#pgv_lang[ra_edit_task]#» per a aquesta tasca per actualitzar-la o completar-la.</li></ul></ul>";
$pgv_lang["ra_missing_info_help"]		= "<ul>~#pgv_lang[ra_missing_info]#~<br /><br />Aquesta àrea mostra la possible informació que falta sobre el registre d'una persona. Per exemple, això podria incloure una font de naixement desapareguda o el fet que la persona estigués viva durant un conflicte militar però no té una entrada militar. El #pgv_lang[ra_RA_name]# inspeccionarà el registre de la base de dades genealògic de la persona per detectar possibles dades que falten i produirà una llista de possibles tasques de seguiment que es poden crear.<br /><br />Abans que es pugui crear qualsevol tasca que falti, heu de <u>hau</u> d'haver establert una carpeta per contenir les tasques.<br /><br />La taula presenta una llista de tasques noves potencials que es podrien crear o tasques generades anteriorment per visualitzar.<ul><li>Per crear una tasca per fer un seguiment d'alguna informació que falta, marqueu la casella de selecció que hi ha al costat. Quan s'hagin seleccionat totes les tasques desitjades i s'hagi escollit una carpeta per agrupar aquestes tasques noves, feu clic a <b>#pgv_lang[ra_AddTask]#</b> per crear tasques per als elements que falten.</li><li>Tasques existents. mostrarà <b>#pgv_lang[ra_view]#</b> en lloc d'una casella de selecció que, quan feu clic, us portarà directament a veure aquesta tasca.</li></ul>#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_person_task_list_help"]		= "<ul>~#pgv_lang[ra_task_list]#~<br /><br />La taula que es mostra és una llista de tasques de recerca associades al registre d'aquesta persona. Només es mostren les tasques no marcades com a completades. Es podrien haver creat manualment o generat mitjançant la taula «#pgv_lang[ra_missing_info]#», però cada tasca té aquesta persona associada.<br /><br />Feu clic al títol de la tasca per veure'n més detalls.</br>Feu clic al botó <b>#pgv_lang[ra_task_entry]#</b> a la part inferior de la taula per crear manualment una tasca nova enllaçada amb el registre d'aquesta persona.<br /><br />#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_sources_task_list_help"]		= "<ul>~#pgv_lang[ra_task_list]#~<br /><br />Aquesta és una llista de totes les tasques associades amb aquesta font. Només es mostren les tasques no marcades com a completades. El missatge «#pgv_lang[ra_no_sour_tasks]#» apareixerà quan cap tasca tingui aquesta font enllaçada. Quan hi hagi una tasca associada, feu clic al títol de la tasca per iniciar la pàgina «#pgv_lang[ra_view_task]#» per obtenir-ne més detalls.<br /><br /><b>Nota</b>: no es poden crear tasques noves a l'entrada «#pgv_lang[ra_source]#». Utilitzeu la funció <b>#pgv_lang[ra_AddTask]#</b> si cal específicament per a una font que no estigui enllaçada a una persona.<br /><br />#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_view_tasklist_help"]		= "<ul>~#pgv_lang[ra_Task_View]#~<br /><br />#pgv_lang[ra_view_task_words]#<br /><br />Aquesta taula és una llista de tasques. Les columnes inclouen:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Un títol resum de la tasca. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Aquesta és una descripció detallada de la tasca necessària per a la investigació o accions de seguiment. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_Start_Date]#</b>&nbsp;&nbsp;Aquesta és la data de creació de la tasca. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_completed]#</b>&nbsp;&nbsp;Això indica si s'ha completat o no una tasca. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_assigned]#</b>&nbsp;&nbsp;Aquesta entrada indica qui és el propietari d'una tasca de recerca. Aquesta columna no es mostra a la vista «#pgv_lang[ra_my_tasks]#» ja que sou el propietari de totes aquestes tasques.</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Si sou el propietari d'aquesta tasca o teniu drets d'administració, aquesta entrada conté un <u>enllaç</u> que us portarà a editar la tasca; en cas contrari, estarà en blanc.</li><li><b>#pgv_lang[ra_delete]#</b>&nbsp;&nbsp;Si sou el propietari d'aquesta tasca o teniu drets d'administració, aquesta entrada conté un <u>enllaç</u> que us portarà a suprimir la tasca, en cas contrari estarà en blanc.</li><li><b>#pgv_lang[ra_complete]#</b>&nbsp;&nbsp;Si sou el propietari d'aquesta tasca o teniu drets d'administració, aquesta entrada conté un <u>enllaç</u> que us portarà a tancar immediatament una tasca si actualment no s'ha completat, en cas contrari aquest camp estarà en blanc. Aquesta columna només es mostrarà a la vista «#pgv_lang[ra_my_tasks]#» ja que sou el propietari de totes aquestes tasques.</li></ul>#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_task_view_help"]		= "<ul>~#pgv_lang[ra_view_task]#~<br /><br />#pgv_lang[ra_view_task_words]#<br /><br />Aquesta taula resumeix una tasca específica.<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Aquest és el títol de la tasca.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;Aquesta és la carpeta on s'agrupa la tasca.</li><li><b>#pgv_lang[ra_assigned]#</b>&nbsp;&nbsp;Aquest és el investigador a qui està assignada la tasca actualment.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Aquesta és la descripció detallada de la tasca necessària per a la investigació o accions de seguiment.</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Qualsevol font necessària per a la investigació o accions per al seguiment de la tasca.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Aquesta és una llista de persones de l'arbre genealògic que estan associats a la tasca. Aquest camp pot contenir diverses entrades. Només es mostren les persones de l'arbre genealògic.</li></ul><br />Si sou el propietari assignat de la tasca o teniu drets d'administració, es presentarà un botó i podeu fer clic a <b>#pgv_lang[ra_edit_task]#</b> per editar els detalls de la tasca.</ul>";
$pgv_lang["ra_add_task_help"]		= "<ul>~#pgv_lang[ra_add_new_task]#~<br /><br />#pgv_lang[ra_add_task_words]#<br /><br />Els camps del formulari inclouen:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Això ha de contenir un breu resum, normalment de menys de 30 caràcters, de la tasca que esteu afegint.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;Seleccioneu la carpeta on voleu gestionar la vostra tasca nova. Només es mostren les carpetes existents. Si voleu assignar aquesta tasca nova a una carpeta nova, primer heu d'utilitzar la funció <b>#pgv_lang[ra_add_folder]#</b> del menú principal #pgv_lang[ra_RA_name]#.</li><li><b>#pgv_lang[ra_assign_task]#</b>&nbsp;&nbsp;Seleccioneu de la llista d'usuaris amb permisos d'edició algú que pugui ser propietari o actualitzar la tasca i els registres associats a ella. En general, aquest camp no hauria de quedar mai en blanc (#pgv_lang[ra_mytasks_unassigned]#).</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Introduïu una descripció detallada de la tasca que voleu afegir.<br /><br />#pgv_lang[ra_special_char_words]#</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Adjunteu qualsevol font que tingueu per a la tasca. Aquest camp pot contenir diverses entrades.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Seleccioneu totes les persones associades amb aquesta tasca. Aquest camp pot contenir diverses entrades, però només es poden seleccionar i mostrar persones de la vostra base de dades genealògica.</li></ul><br />Quan es crea una tasca nova, es pot desar fent clic al botó <b>#pgv_lang[ra_submit]#</b>, que la mantindrà oberta i en l'estat #pgv_lang[ra_incomplete]# per a més actualitzacions. La tasca es pot desar i marcar com a #pgv_lang[ra_complete]# alhora fent clic al botó <b>#pgv_lang[ra_save_and_complete]#</b>.</ul>";
$pgv_lang["ra_edit_task_help"]		= "<ul>~#pgv_lang[ra_edit_task]#~<br /><br />#pgv_lang[ra_add_task_words]#<br /><br />Els camps del formulari inclouen:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Això ha de contenir el títol o resum de la tasca que esteu editant.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;En aquest camp podeu seleccionar la carpeta on voleu gestionar la vostra tasca nova.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Introduïu una descripció detallada de la tasca que voleu afegir.<br /><br />#pgv_lang[ra_special_char_words]#</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Adjunteu qualsevol font que tingueu per a la tasca. Aquest camp pot contenir diverses entrades.</li>li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Seleccioneu totes les persones associades amb aquesta tasca. Aquest camp pot contenir diverses entrades, però només es poden seleccionar persones de la vostra base de dades genealògica i mostrar-les en aquest camp.</li></ul><br />Després de modificar una tasca existent, es pot enviar per a futures actualitzacions fent clic al botó <b>#pgv_lang[ra_save]#</b>. La tasca també es pot desar i marcar com a #pgv_lang[ra_completed]# (no s'esperen actualitzacions futures), fent clic al botó <b>#pgv_lang[ra_save_and_complete]#</b>.</ul>";
$pgv_lang["ra_comments_help"]		= "<ul>~#pgv_lang[ra_comments]#~<br /><br />Això contindrà qualsevol comentari relacionat amb una tasca de recerca.<br /><br />Quan a la secció «#pgv_lang[ra_RA_name]#» d'una persona, aquests comentaris estan enllaçats amb el registre específic d'aquesta persona i només són visibles aquí. Si es mostra un comentari a sota d'una tasca, aquest comentari és específic per a aquesta tasca. En cada cas hi pot haver múltiples comentaris independents. Cadascun es pot editar o suprimir de manera independent amb el comentari més recent que es mostra sempre a la part superior.<br /><br />Feu clic a <b>#pgv_lang[ra_add_new_comment]#</b> per afegir comentaris nous a aquesta llista.<br /><br /><span class='warning'>Si, mentre editeu una tasca, n'afegiu una nova comentar abans de desar la tasca editada, es perdran els canvis de tasca no desats.</span></ul>";
$pgv_lang["ra_folder_view_help"]		= "<ul>~#pgv_lang[ra_Folder_View]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Aquesta és una llista de carpetes i descripcions del seu ús.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;Aquesta columna conté els noms de totes les carpetes d'aquest nivell que han creat. En seleccionar el nom de la carpeta, se us desplaçarà a una pantalla nova que mostra les subcarpetes i totes les tasques associades amb aquesta carpeta. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Aquesta columna conté una descripció més detallada de l'ús d'aquestes carpetes. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Aquesta columna té un <u>enllaç</u> per permetre editar el nom i la descripció de la carpeta o jerarquia.</li></ul><br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_add_folder_help"]		= "<ul>~#pgv_lang[ra_Add_folder]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Aquest formulari admet la creació d'una carpeta nova, la seva descripció d'ús i la jerarquia d'altres carpetes a les quals s'ajusta aquesta carpeta.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;El títol resumeix l'ús de la carpeta que esteu afegint.</li><li><b>#pgv_lang[ra_Parent_Folder]#</b>&nbsp;&nbsp;Podeu especificar si la carpeta es troba al nivell més alt o arrel. (#pgv_lang[ra_No_Parent]#) o com a subcarpeta d'una altra carpeta.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Aquesta és la descripció detallada de la carpeta. esteu afegint.</li></ul>Si feu clic al botó <b>#pgv_lang[ra_add]#</b>, s'enviarà la informació per crear una carpeta nova. Si feu clic al botó <b>#pgv_lang[ra_reset]#</b>, es descartarà qualsevol canvi al camp de descripció.<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_edit_folder_help"]		= "<ul>~#pgv_lang[ra_Edit_folder]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Aquest formulari admet l'edició d'una carpeta existent, la seva descripció d'ús i la jerarquia d'altres carpetes a les quals s'ajusta aquesta carpeta.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;El title resumeix l'ús de la carpeta que esteu afegint.</li><li><b>#pgv_lang[ra_Parent_Folder]#</b>&nbsp;&nbsp;Podeu especificar si la carpeta es troba al nivell més alt (# pgv_lang[ra_No_Parent]#) o com a subcarpeta d'una altra carpeta.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Aquesta és la descripció detallada de la carpeta que ets afegint.</li></ul><br />El botó <b>#pgv_lang[ra_add]#</b> enviarà la informació per crear una carpeta nova. El botó <b>#pgv_lang[ra_reset]#</b> descartarà els canvis fets al camp de descripció des de l'última desació. Quan una carpeta està buida, apareixerà el botó <b>#pgv_lang[ra_delete]#</b> per permetre eliminar aquesta carpeta de la jerarquia de carpetes, en cas contrari se us advertirà que no es permet la supressió amb tasques encara presents.<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_auto_search_help"]		= "<ul>~#pgv_lang[ra_auto_search_text]#~<br /><br />En funció de la persona escollida, aquesta funció extreurà automàticament diverses informacions vitals i fetes de la vostra base de dades genealògica i us permetrà determinar quina d'elles passareu al motor de cerca d'un lloc web de genealogia extern. Es poden triar diversos llocs, com ara Ancestry, FamilySearch, Findagrave i més. Els resultats d'aquestes cerques es poden utilitzar per afegir o actualitzar informació a la vostra base de dades genealògica.<br /><br />Quan a la secció «#pgv_lang[ra_RA_name]#» de la pàgina «#pgv_lang[personal_facts]#» d'una persona, la cerca es basarà en aquesta persona. Si s'inicia des dels menús principals #pgv_lang[ra_RA_name]#, primer s'ha de triar una persona fent clic a la icona de persona per seleccionar-la o introduint el número d'identificació de la persona al camp.<br /><br />Trieu de la llista el nom del lloc de genealogia que voleu consultar. Se us mostrarà una llista d'informació que es pot seleccionar. Indiqueu amb marques al costat de cada element (nom, data de naixement o defunció, etc.) els elements que es passaran al motor de cerca escollit després de fer clic al botó <b>#pgv_lang[ra_autosearch_search]#</b>. El cercador del lloc web extern es posa en marxa en una pàgina nova. Utilitzeu la funció de gestió #pgv_lang[ra_task_list]# per identificar troballes addicionals per fer un seguiment.<br /><br />Tingueu en compte que els motors de cerca estan en constant evolució, de manera que un cop en un lloc de genealogia, les capacitats natives d'aquest lloc poden oferir més criteris de cerca que es poden actualitzar per enriquir la vostra recerca.</ul>";
$pgv_lang["ra_ViewProb_help"]		= "<ul>~#pgv_lang[ra_analyze_database]#~<br /><br />Aquesta pàgina analitza les dades de la vostra base de dades genealògica i mostra les correlacions entre diferents elements de dades.<br /><br />Per exemple, podria haver-hi una correlació del 95% que el cognom d'un registre local sigui el mateix que el cognom. al registre del pare. Això significaria que el 95% de les persones d'aquesta base de dades genealògica comparteixen el mateix cognom que el seu pare. En aquesta versió del mòdul #pgv_lang[ra_RA_name]#, aquests càlculs s'utilitzen per ajudar a identificar la informació que falta als registres d'una persona. No s'utilitzen en altres àrees del programa; només es proporcionen com a ajuda per a la vostra recerca.</ul>";
$pgv_lang["ra_GenerateTasks_help"]		= "<ul>~#pgv_lang[ra_gen_tasks]#~<br /><br />Alguns programes genealògics permeten introduir tasques de recerca com a elements TODO a la seva base de dades. En exportar aquesta informació genealògica a altres programes, exportaran els registres de la base de dades a un fitxer formatat segons la recomanació de GEDCOM. El programari PhpGedView utilitza el fitxer amb format GEDCOM com a entrada, de manera que aquests elements TODO s'incrusten a les vostres dades. Aquesta opció cercarà la vostra base de dades genealògica i convertirà automàticament tots els elements TODO importats en tasques de recerca.<br /><br />Si feu clic al botó <b>#pgv_lang[ra_generate]#</b> a la part inferior del formulari, es crearà una llista de tasques potencials a partir dels elements TODO importats. D'aquesta llista podeu seleccionar elements per generar tasques.<ul><li><b>#pgv_lang[ra_generate]#</b>&nbsp;&nbsp;Marqueu cada tasca per generar i després generar-la.</li><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Els primers 30 caràcters de la descripció de la tasca es convertiran en el nom de la tasca. Podeu canviar-ho o corregir-ho quan editeu la tasca.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;La descripció que es donarà a la tasca, copiada del text complet de l'element TODO a la vostra base de dades genealògica. Podeu canviar-ho o corregir-ho quan editeu la tasca.</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Feu clic a l'enllaç per editar aquesta tasca.</li><li><b>#pgv_lang[ra_SelectFolder]#</b>&nbsp;&nbsp;Seleccioneu la carpeta on posar les tasques generades.</li><li><b>#pgv_lang[ra_done]#</b>&nbsp;&nbsp;et redirigeix a la pàgina #pgv_lang[ra_Folder_View]#.</li></ul></ul>";
$pgv_lang["ra_EditGenerateTasks_help"]	= "<ul>~#pgv_lang[ra_Edit_Gen_Task]#~<br /><br />Aquest formulari us permet editar les tasques que s'han creat a partir d'elements TODO a la vostra base de dades genealògica.<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Per seleccionar la persona amb qui associar-vos la tasca.</li><li><b>#pgv_lang[ra_source]#</b>&nbsp;&nbsp;Feu clic a l'enllaç per seleccionar la font amb la qual voleu associar la tasca.</li><li><b>#pgv_lang[ra_save]#</b>&nbsp;&nbsp;Desa tots els canvis i et redirigeix a la pàgina #pgv_lang[ra_gen_tasks]#.</li><li><b>#pgv_lang[ra_cancel]#</b>&nbsp;&nbsp;Descarta tots els teus canvis i et redirigeix a la pagina #pgv_lang[ra_gen_tasks]#.</li></ul></ul>";
$pgv_lang["ra_configure_privacy_help"]		= "<ul>~#pgv_lang[ra_configure_privacy]#~<br /><br />Com a administrador del vostre lloc PhpGedView, teniu la possibilitat de controlar la visibilitat de les diferents funcionalitats del mòdul #pgv_lang[ra_RA_name]#. Aquest diàleg presenta els blocs funcionals disponibles i us demana que seleccioneu la visibilitat escollint els controls d'accés per a cadascun.<ul><li><b>#pgv_lang[PRIV_PUBLIC]#</b>&nbsp;&nbsp;El bloc funcional especificat està disponible per a tothom.</li><li><b>#pgv_lang[PRIV_USER]#</b>&nbsp;&nbsp;El bloc funcional especificat només està disponible per als usuaris autenticats.</li><li><b>#pgv_lang[PRIV_NONE]#</b>&nbsp;&nbsp;El bloc funcional especificat només està disponible per als usuaris amb drets d'administrador.</li><li><b>#pgv_lang[PRIV_HIDE]#</b>&nbsp;&nbsp;El bloc funcional especificat no està disponible per a ningú.</li></ul></ul>";
?>
