<?php
/**
 * German language Help file for PhpGedView Research Assistant module
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Research_Assistant
 * @version $Id: help_text.de.php 7377 2024-10-18 13:50:13Z canajun2eh $
 *
 * The companion file to this is lang.de.php, which contains most of the brief texts.
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

//-- Miscellaneous advisories and instructions
$pgv_lang["ra_auto_gen_inst"]		= "Einige Programme ermöglichen es Ihnen, Forschungsaufgaben als TODO-Elemente in Ihre genealogische Datenbank einzugeben. Mit dieser Option wird Ihre genealogische Datenbank durchsucht und jedes TODO-Element automatisch in eine Forschungsaufgabe umgewandelt.";
$pgv_lang["ra_mytasks_block_descr"]		= "Der Block »#pgv_lang[ra_my_tasks]#« zeigt Aufgaben für den aktuellen Benutzer. Er kann so konfiguriert werden, dass erledigte Aufgaben oder Aufgaben gezeigt werden, die derzeit nicht zugewiesen sind.";

//-- RA HELP MESSAGES
// - Variables with *_help are the actual help texts. *_words are useful text blocks that can be used multiple times in different help texts 

$pgv_lang["ra_organizetasks_words"]		= "~So organisieren Sie Aufgaben~<br /><br />Aufgaben werden in Ordnern organisiert. Es muss mindestens ein Ordner vorhanden sein, bevor Aufgaben erstellt werden können.<br /><br />Sie können Ihre Ordner beliebig erstellen und organisieren. Sie möchten Ihre Online-Ordner wahrscheinlich genauso organisieren, wie Sie Papierkopien Ihrer Forschungsarbeit organisieren. Viele Forscher organisieren ihre Ordner nach Familienlinie, Nachnamen oder geografischen Standorten.";
$pgv_lang["ra_whataretasks_words"]		= "~Was sind Aufgaben?~<br /><br />Das Modul #pgv_lang[ra_RA_name]# ist auf die Forschungsaufgabe ausgerichtet. Eine Forschungsaufgabe ist einem TODO-Element ähnlich und verfolgt eine bestimmte genealogische Forschungsaufgabe, die erledigt werden muss. Ein Beispiel für einen Aufgabentitel könnte »Joes Geburtsurkunde finden« sein, während die Einzelheiten in der Beschreibung lauten würden: »Joes Geburtsurkunde in den Geburtsurkunden des Ottawa County finden«.<br /><br />Aufgaben können bestimmten Benutzern zugewiesen werden. Durch die Zuweisung von Aufgaben an Benutzer weiß jeder, an welcher Recherche er arbeiten soll und wer an anderen Rechercheaufgaben arbeitet.<br /><br />Aufgaben können auch Aktionen gegen Quellmaterial oder in Bezug auf eine oder mehrere Personen in Ihren Daten umfassen. Wenn das Modul #pgv_lang[ra_RA_name]# installiert ist, sehen Sie auf jeder »#pgv_lang[personal_facts]#« Seite einen Abschnitt »#pgv_lang[ra_RA_name]#« und auf jeder Seite mit Quelldaten auch einen Abschnitt »Aufgaben«.<br /><br />Aufgaben werden im Status <b>#pgv_lang[ra_incomplete]#</b> erstellt, was darauf hinweist, dass die Arbeit daran im Gange oder in Bearbeitung ist. Alle Aufgaben sollten einem Benutzer zugewiesen werden, der die Datensätze mit den Ergebnissen bearbeiten und aktualisieren kann. Sobald die gesamte Arbeit erledigt ist, sollte die Aufgabe als <b>#pgv_lang[ra_complete]#</b> übermittelt werden. Dadurch wird sie aus den aktiv sichtbaren (d. h. #pgv_lang[ra_incomplete]#) Aufgabenlisten entfernt. Über das Menü »#pgv_lang[ra_my_tasks]#« kann jeder Benutzer seine zugewiesenen Aufgaben sehen, sowohl #pgv_lang[ra_incomplete]# als auch #pgv_lang[ra_complete]#.<br /><br />Jede Aufgabe verfügt über einen Kommentarbereich, in dem Diskussionen zu den Daten und der Forschung oder möglichen Ergebnissen stattfinden können. Dadurch bleibt die Aufgabe zielorientiert, während die Kommentare auf Fortschritt und Ergebnisse ausgerichtet sind.";
$pgv_lang["ra_sortcol_words"]		= "Diese Spalte kann durch Klicken auf der Spaltenüberschrift sortiert werden.";
$pgv_lang["ra_folder_words"]			= "Ordner sind ein Tool zur Aufgabenverwaltung, mit dem Aufgaben gruppiert werden können. Ordner können in anderen Ordnern eingebettet sein. Wenn es einen übergeordneten Ordner gibt, wird dieser auf der linken Seite der Menüs oben gezeigt. Wenn dieser Bereich leer ist, befinden sich diese Ordner auf der obersten Ebene.";
$pgv_lang["ra_view_task_words"]		= "Aufgaben sind Möglichkeiten, Forschungsaufgaben oder Folgemaßnahmen zu verwalten. Die Aufgabe wird durch ihren Titel zusammengefasst, während das Beschreibungsfeld genauere Angaben zu den Anforderungen enthält. Manchmal kann das Beschreibungsfeld auch die Folgemaßnahmen für die Lösung enthalten. Unter der Tabelle »#pgv_lang[ra_Task_View]#« befindet sich eine »#pgv_lang[ra_comments]#« Tabelle, die zum Verfolgen des Fortschritts und zum Beschreiben der Aufgabenlösungen verwendet werden kann.";
$pgv_lang["ra_special_char_words"]		= "Gelegentlich muss Ihr Text Symbole enthalten, die für den Browser oder PhpGedView eine besondere Bedeutung haben und nicht normaler Text sind. Wenn solche Symbole in Ihrem Text vorkommen müssen, müssen Sie sie in einem Format eingeben, das andeutet, dass es sich um Text ohne besondere Bedeutung handelt.<ul><li><b>&amp;</b>&nbsp;&nbsp;Dieses Symbol kennzeichnet den Beginn einer HTML-Entität. Um anzuzeigen, dass es sich bei diesem Symbol um normalen Text handelt, können Sie entweder sicherstellen, dass ihm immer ein Leerzeichen folgt, oder Sie können es in seiner HTML-Entitätsform eingeben <b>&amp;amp;</b></li><li><b>&#35;</b>&nbsp;&nbsp;Dieses Symbol wird im Hilfesystem von PhpGedView verwendet. Um anzuzeigen, dass es sich bei diesem Symbol um normalen Text handelt, können Sie entweder sicherstellen, dass ihm immer ein Leerzeichen folgt, oder Sie können es in seiner numerischen Form eingeben <b>&amp;&#35;35;</b></li><li><b>&#126;</b>&nbsp;&nbsp;Dieses Symbol wird im Hilfesystem von PhpGedView verwendet. Um anzuzeigen, dass es sich bei diesem Symbol um normalen Text handelt, können Sie entweder sicherstellen, dass immer ein Leerzeichen folgt, oder Sie können es in seiner numerischen Form eingeben <b>&amp;&#35;126;</b></li><li><b>&#92;</b>&nbsp;&nbsp;Dieses Symbol wird vom Browser so interpretiert, dass das folgende Symbol Text ist. Um anzuzeigen, dass es sich bei diesem Symbol um normalen Text handelt, müssen Sie zwei davon eingeben <b>&#92;&#92;</b> oder Sie können es in seiner numerischen Form eingeben <b>&amp;&#35;92;</b></li><li><b>&lt;</b>&nbsp;&nbsp;Dieses Symbol wird vom Browser so interpretiert, dass es den Anfang eines HTML-Tags anzeigt. Um anzuzeigen, dass es sich bei diesem Symbol um normalen Text handelt, müssen Sie es in seiner HTML-Entity-Form eingeben <b>&amp;lt;</b></li><li><b>&gt;</b>&nbsp;&nbsp;Dieses Symbol wird vom Browser so interpretiert, dass es das Ende eines HTML-Tags anzeigt. Um anzuzeigen, dass es sich bei diesem Symbol um normalen Text handelt, müssen Sie es in seiner HTML-Entity-Form eingeben <b>&amp;gt;</b></li></ul>Sie können in der Beschreibung Listen mit Elementen erstellen. Wenn Sie nummerierte oder Aufzählungslisten erstellen möchten, beginnen Sie die Eingabe dieser Listenelemente mit <b>&lt;ul&gt;</b> für eine Aufzählungsliste oder <b>&lt;ol&gt;</b> für eine nummerierte Liste.<br /><br />Jedes Listenelement sollte mit <b>&lt;li&gt;</b> beginnen und mit <b>&lt;/li&gt;</b> enden. Das letzte Listenelement sollte wie alle anderen beendet werden und von <b>&lt;/ul&gt;</b> gefolgt werden, um die Aufzählungsliste zu schließen, oder von <b>&lt;/ol&gt;</b>, um die nummerierte Liste zu schließen.<br /><br />Die vorangegangenen Hinweise zur Eingabe von »Kleiner-als« <b>&lt;</b> und »Größer-als« <b>&gt;</b> Symbolen, die normalerweise HTML-Tags einschließen, als Text gelten nicht, da Sie in diesem Fall tatsächlich HTML-Tags eingeben müssen.";
$pgv_lang["ra_add_task_words"]		= "Bevor Aufgaben erstellt werden können, <u>müssen</u> Sie einen Ordner eingerichtet haben, der diese Aufgabe enthält.<br /><br />Aufgaben sind Möglichkeiten, Forschungsaufgaben oder Folgemaßnahmen zu verwalten. Diese Aufgaben werden anhand ihrer Titel zusammengefasst und verwenden die Beschreibungsfelder, um genauer zu definieren, was erforderlich ist. Aufgaben können auch Quellenmaterial enthalten, das recherchiert werden muss. Dieses kann angehängt werden. Wenn diese Aufgabe einer oder mehreren Personen zugeordnet ist, sollten diese ebenfalls an diese neue Aufgabe angehängt werden.";


$pgv_lang["ra_mytasks_help"]			= "<ul>~#pgv_lang[ra_my_tasks]#~<br /><br />Die »#pgv_lang[ra_my_tasks]#« Liste zeigt Forschungsaufgaben für den aktuellen Benutzer. Standardmäßig zeigt die Aufgabenliste offene oder nicht erledigte Aufgaben für den aktuellen Benutzer an. Dies kann so konfiguriert werden, dass zusätzlich erledigte Aufgaben und Aufgaben angezeigt werden, die nicht zugewiesen sind. Die resultierende Tabelle kann dann verwendet werden, um schnell einen Blick auf die zu verwaltenden Forschungsaufgaben zu werfen.<ul><li>Wenn Sie auf <b>#pgv_lang[ra_title]#</b> klicken, gelangen Sie zu »#pgv_lang[ra_Task_View]#«, wo Sie weitere Einzelheiten zu der jeweiligen Aufgabe finden.</li><li>#pgv_lang[ra_Start_Date]# gibt an, wann die Aufgabe ursprünglich erstellt wurde.</li><li>Wenn Sie am Ende der Zeile jeder Aufgabe auf <b>#pgv_lang[ra_edit]#</b> klicken, gelangen Sie zur Ansicht »#pgv_lang[ra_edit_task]#» für diese jeweilige Aufgabe, um sie zu aktualisieren oder abzuschließen.</li></ul></ul>";
$pgv_lang["ra_missing_info_help"]		= "<ul>~#pgv_lang[ra_missing_info]#~<br /><br />In diesem Bereich werden möglicherweise fehlende Informationen zum Datensatz einer Person angezeigt. Dies könnte beispielsweise eine fehlende Geburtsquelle oder die Tatsache sein, dass die Person während eines militärischen Konflikts am Leben war, aber ein militärischer Eintrag fehlt. Das Modul #pgv_lang[ra_RA_name]# überprüft den genealogischen Datenbankeintrag der Person auf möglicherweise fehlende Informationen und erstellt eine Liste möglicher Folgeaufgaben, die erstellt werden können.<br /><br />Bevor fehlende Aufgaben erstellt werden können, <u>müssen</u> Sie einen Ordner zum Speichern der Aufgaben eingerichtet haben.<br /><br />Die Tabelle enthält eine Liste potenzieller neuer Aufgaben, die erstellt werden könnten, oder zuvor generierter Aufgaben zur Anzeige.<ul><li>Um eine Aufgabe zum Verfolgen fehlender Informationen zu erstellen, aktivieren Sie das Kästchen daneben. Wenn alle gewünschten Aufgaben gewählt und ein Ordner zum Gruppieren dieser neuen Aufgaben gewählt sind, klicken Sie auf <b>#pgv_lang[ra_AddTask]#</b>, um Aufgaben für die fehlenden Elemente zu erstellen.</li><li>Bei vorhandenen Aufgaben wird <b>#pgv_lang[ra_view]#</b> anstelle eines Kästchens gezeigt. Wenn Sie darauf klicken, werden Sie direkt zur Anzeige dieser Aufgabe weitergeleitet.</li></ul>#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_person_task_list_help"]		= "<ul>~#pgv_lang[ra_task_list]#~<br /><br />Die Tabelle ist eine Liste der Forschungsaufgaben, die mit dem Datensatz dieser Person verknüpft sind. Es werden nur Aufgaben gezeigt, die nicht als erledigt markiert sind. Sie können manuell erstellt oder mithilfe der Tabelle »#pgv_lang[ra_missing_info]#« generiert worden sein, aber jeder Aufgabe ist diese Person zugeordnet.<br /><br />Klicken Sie auf den Titel der Aufgabe, um weitere Einzelheiten dazu anzuzeigen.</br>Klicken Sie unten in der Tabelle den Button <b>#pgv_lang[ra_task_entry]#</b>, um manuell eine neue Aufgabe zu erstellen, die mit dem Datensatz dieser Person verknüpft ist.<br /><br />#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_sources_task_list_help"]		= "<ul>~#pgv_lang[ra_task_list]#~<br /><br />Dies ist eine Liste aller Aufgaben, die mit dieser Quelle verknüpft sind. Es werden nur Aufgaben gezeigt, die nicht als erledigt markiert sind. Die Meldung »#pgv_lang[ra_no_sour_tasks]#« wird gezeigt, wenn keine Aufgaben mit dieser Quelle verknüpft sind. Wenn eine Aufgabe verknüpft ist, klicken Sie auf den Titel der Aufgabe, um die Seite »#pgv_lang[ra_view_task]#« mit weiteren Einzelheiten dazu aufzurufen.<br /><br /><b>Hinweis</b>: Neue Aufgaben können innerhalb des Eintrags «#pgv_lang[ra_source]#» nicht erstellt werden. Nutzen Sie bei Bedarf speziell für eine Quelle, die nicht mit einer Person verknüpft ist, die Funktion <b>#pgv_lang[ra_AddTask]#</b>.<br /><br />#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_view_tasklist_help"]		= "<ul>~#pgv_lang[ra_Task_View]#~<br /><br />#pgv_lang[ra_view_task_words]#<br /><br />Diese Tabelle ist eine Aufgabenliste. Die Spalten enthalten:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Ein zusammenfassender Titel für die Aufgabe. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Dies ist eine detaillierte Beschreibung der Aufgabe, die für die Recherche oder Folgemaßnahmen erforderlich sind. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_Start_Date]#</b>&nbsp;&nbsp;Dies ist das Erstellungsdatum der Aufgabe. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_completed]#</b>&nbsp;&nbsp;Dies gibt an, ob eine Aufgabe erledigt ist oder nicht. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_assigned]#</b>&nbsp;&nbsp;Dieser Eintrag gibt an, wem eine Forschungsaufgabe gehört. Diese Spalte wird in der Ansicht »#pgv_lang[ra_my_tasks]#« nicht gezeigt, da Sie der Eigentümer aller dieser Aufgaben sind.</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Wenn Sie der Eigentümer dieser Aufgabe sind oder Administratorrechte haben, enthält dieser Eintrag einen <u>Link</u> , über den Sie die Aufgabe bearbeiten können, andernfalls ist er leer.</li><li><b>#pgv_lang[ra_delete]#</b>&nbsp;&nbsp;Wenn Sie der Eigentümer dieser Aufgabe sind oder Administratorrechte haben, enthält dieser Eintrag einen <u>Link</u> , über den Sie die Aufgabe löschen können, andernfalls ist er leer.</li><li><b>#pgv_lang[ra_complete]#</b>&nbsp;&nbsp;Wenn Sie der Eigentümer dieser Aufgabe sind oder über Administratorrechte verfügen, enthält dieser Eintrag einen <u>Link</u> , über den Sie eine Aufgabe sofort schließen können, wenn sie derzeit nicht erledigt ist. Andernfalls ist dieses Feld leer. Diese Spalte wird nur in der Ansicht »#pgv_lang[ra_my_tasks]#« gezeigt, da Sie der Eigentümer aller dieser Aufgaben sind.</li></ul>#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_task_view_help"]		= "<ul>~#pgv_lang[ra_view_task]#~<br /><br />#pgv_lang[ra_view_task_words]#<br /><br />Diese Tabelle fasst eine bestimmte Aufgabe zusammen.<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Dies ist der Titel der Aufgabe.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;Dies ist der Ordner, in dem die Aufgabe gruppiert ist.</li><li><b>#pgv_lang[ra_assigned]#</b>&nbsp;&nbsp;Dies ist der Forscher, dem die Aufgabe derzeit zugewiesen ist.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Dies ist die detaillierte Beschreibung der Aufgabe, die für die Recherche oder Folgemaßnahmen erforderlich sind.</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Alle für die Recherche benötigten Quellen oder Maßnahmen zur Nachverfolgung der Aufgabe.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Dies ist eine Liste von Personen aus dem Stammbaum, die mit der Aufgabe in Verbindung stehen. Dieses Feld kann mehrere Einträge enthalten. Es werden nur Personen im Stammbaum angezeigt.Alle für die Recherche benötigten Quellen oder Maßnahmen zur Nachverfolgung der Aufgabe.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Dies ist eine Liste von Personen aus dem Stammbaum, die mit der Aufgabe in Verbindung stehen. Dieses Feld kann mehrere Einträge enthalten. Es werden nur Personen im Stammbaum gezeigt.</li></ul><br />Wenn Sie der zugewiesene Eigentümer der Aufgabe sind oder über Administratorrechte verfügen, wird ein Button gezeigt und Sie können auf <b>#pgv_lang[ra_edit_task]#</b> klicken, um die Details der Aufgabe zu bearbeiten.</ul>";
$pgv_lang["ra_add_task_help"]		= "<ul>~#pgv_lang[ra_add_new_task]#~<br /><br />#pgv_lang[ra_add_task_words]#<br /><br />Die Felder des Formulars umfassen:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Dies sollte eine kurze Zusammenfassung der Aufgabe enthalten, die Sie hinzufügen, normalerweise weniger als 30 Zeichen lang.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;Wählen Sie den Ordner, in dem Sie Ihre neue Aufgabe verwalten möchten. Es werden nur vorhandene Ordner gezeigt. Wenn Sie diese neue Aufgabe einem neuen Ordner zuweisen möchten, müssen Sie zuerst die Funktion <b>#pgv_lang[ra_add_folder]#</b> aus dem #pgv_lang[ra_RA_name]# Hauptmenü verwenden.</li><li><b>#pgv_lang[ra_assign_task]#</b>&nbsp;&nbsp;Wählen Sie aus der Liste der Benutzer mit Bearbeitungsberechtigung jemanden, der die Aufgabe und alle damit verbundenen Datensätze besitzen oder aktualisieren kann. Im Allgemeinen sollte dieses Feld nie leer sein (#pgv_lang[ra_mytasks_unassigned]#).</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Geben Sie eine detaillierte Beschreibung der Aufgabe ein, die Sie hinzufügen möchten.<br /><br />#pgv_lang[ra_special_char_words]#</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Fügen Sie alle Quellen an, die Sie für die Aufgabe haben. Dieses Feld kann mehrere Einträge enthalten.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Wählen Sie alle Personen, die mit dieser Aufgabe in Zusammenhang stehen. Dieses Feld kann mehrere Einträge enthalten, es können jedoch nur Personen aus Ihrer genealogischen Datenbank gewählt und in diesem Feld gezeigt werden.</li></ul><br />Beim Erstellen einer neuen Aufgabe kann diese durch Klicken des <b>#pgv_lang[ra_submit]#</b> Buttons gespeichert werden. Dadurch bleibt sie für weitere Aktualisierungen geöffnet und im Status #pgv_lang[ra_incomplete]#. Die Aufgabe kann gespeichert und gleichzeitig als #pgv_lang[ra_complete]# markiert werden, indem Sie den <b>#pgv_lang[ra_save_and_complete]#</b> Button klicken.</ul>";
$pgv_lang["ra_edit_task_help"]		= "<ul>~#pgv_lang[ra_edit_task]#~<br /><br />#pgv_lang[ra_add_task_words]#<br /><br />Die Felder des Formulars umfassen:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Dies sollte den Titel oder die Zusammenfassung der Aufgabe enthalten, die Sie bearbeiten.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;In diesem Feld können Sie den Ordner wählen, in dem Sie Ihre neue Aufgabe verwalten möchten.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Geben Sie eine detaillierte Beschreibung der Aufgabe ein, die Sie hinzufügen möchten.<br /><br />#pgv_lang[ra_special_char_words]#</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Fügen Sie alle Quellen an, die Sie für die Aufgabe haben. Dieses Feld kann mehrere Einträge enthalten.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Wählen Sie alle Personen, die mit dieser Aufgabe in Zusammenhang stehen. Dieses Feld kann mehrere Einträge enthalten, aber es können nur Personen aus Ihrer genealogischen Datenbank gewählt und in diesem Feld gezeigt werden.</li></ul><br />Nachdem Sie eine bestehende Aufgabe geändert haben, können Sie sie für zukünftige Aktualisierungen übermitteln, indem Sie den <b>#pgv_lang[ra_save]#</b> Button klicken. Die Aufgabe kann auch gespeichert und als #pgv_lang[ra_completed]# markiert werden (es werden keine zukünftigen Aktualisierungen erwartet), indem Sie den <b>#pgv_lang[ra_save_and_complete]#</b> Button klicken.</ul>";
$pgv_lang["ra_comments_help"]		= "<ul>~#pgv_lang[ra_comments]#~<br /><br />Dies enthält alle Kommentare zu einer Forschungsaufgabe.<br /><br />Wenn Sie sich im Abschnitt »#pgv_lang[ra_RA_name]#« einer Person befinden, sind diese Kommentare mit dem spezifischen Datensatz dieser Person verknüpft und nur hier sichtbar. Wenn ein Kommentar unter einer Aufgabe gezeigt wird, ist dieser Kommentar spezifisch für diese Aufgabe. In jedem Fall können mehrere unabhängige Kommentare vorhanden sein. Jeder kann unabhängig bearbeitet oder gelöscht werden, wobei der neueste Kommentar immer oben angezeigt wird.<br /><br />Klicken Sie <b>#pgv_lang[ra_add_new_comment]#</b>, um dieser Liste neue Kommentare hinzuzufügen.<br /><br /><span class='warning'>Wenn Sie beim Bearbeiten einer Aufgabe einen neuen Kommentar hinzufügen, bevor Sie die bearbeitete Aufgabe speichern, gehen alle nicht gespeicherten Aufgabenänderungen verloren.</span></ul>";
$pgv_lang["ra_folder_view_help"]		= "<ul>~#pgv_lang[ra_Folder_View]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Dies ist eine Liste von Ordnern und Beschreibungen ihrer Verwendung.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;Diese Spalte enthält die Namen aller Ordner auf dieser Ebene, die Sie erstellt haben. Wenn Sie einen Ordnernamen wählen, gelangen Sie zu einer neuen Anzeige, in der alle Unterordner und alle mit diesem Ordner verknüpften Aufgaben gezeigt werden. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Diese Spalte enthält eine detailliertere Beschreibung der Verwendung dieser Ordner. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Diese Spalte enthält einen <u>Link</u> , der das Bearbeiten des Namens, der Beschreibung oder der Hierarchie des Ordners ermöglicht.</li></ul><br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_add_folder_help"]		= "<ul>~#pgv_lang[ra_Add_folder]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Dieses Formular unterstützt die Erstellung eines neuen Ordners, seine Verwendungsbeschreibung und die Hierarchie anderer Ordner, in die dieser Ordner passt.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;Der Titel fasst die Verwendung des Ordners zusammen, den Sie hinzufügen.</li><li><b>#pgv_lang[ra_Parent_Folder]#</b>&nbsp;&nbsp;Sie können angeben, ob sich der Ordner auf der höchsten oder Stammebene (#pgv_lang[ra_No_Parent]#) oder als Unterordner eines anderen Ordners befindet.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Dies ist die ausführliche Beschreibung des Ordners, den Sie hinzufügen.</li></ul>Durch Klicken des <b>#pgv_lang[ra_add]#</b> Buttons werden die Informationen zum Erstellen eines neuen Ordners übermittelt. Durch Klicken des <b>#pgv_lang[ra_reset]#</b> Buttons werden alle Änderungen im Beschreibungsfeld verworfen.<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_edit_folder_help"]		= "<ul>~#pgv_lang[ra_Edit_folder]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Dieses Formular unterstützt das Bearbeiten eines vorhandenen Ordners, seiner Verwendungsbeschreibung und der Hierarchie anderer Ordner, in die dieser Ordner passt.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;Der Titel fasst die Verwendung des Ordners zusammen, den Sie hinzufügen.</li><li><b>#pgv_lang[ra_Parent_Folder]#</b>&nbsp;&nbsp;Sie können angeben, ob sich der Ordner entweder auf der obersten Ebene (#pgv_lang[ra_No_Parent]#) oder als Unterordner eines anderen Ordners befindet.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Dies ist die detaillierte Beschreibung des Ordners, den Sie hinzufügen.</li></ul><br />Mit dem <b>#pgv_lang[ra_add]#</b> Button werden die Informationen zum Erstellen eines neuen Ordners übermittelt. Mit dem <b>#pgv_lang[ra_reset]#</b> Button werden alle Änderungen im Beschreibungsfeld verworfen, die seit dem letzten Speichern vorgenommen wurden. Wenn ein Ordner leer ist, wird der <b>#pgv_lang[ra_delete]#</b> Button gezeigt, mit dem Sie diesen Ordner aus der Ordnerhierarchie entfernen können. Andernfalls werden Sie gewarnt, dass das Löschen nicht zulässig ist, wenn noch Aufgaben darin vorhanden sind.<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_auto_search_help"]		= "<ul>~#pgv_lang[ra_auto_search_text]#~<br /><br />Basierend auf der ausgewählten Person extrahiert diese Funktion automatisch verschiedene Personen- und Sachinformationen aus Ihrer genealogischen Datenbank und ermöglicht Ihnen zu bestimmen, welche davon an die Suchmaschine einer externen Genealogie-Website weitergegeben werden sollen. Sie können verschiedene Websites auswählen, darunter Ancestry, FamilySearch, Findagrave und mehr. Die Ergebnisse dieser Suchvorgänge können verwendet werden, um Informationen in Ihrer genealogischen Datenbank hinzuzufügen oder zu aktualisieren.<br /><br />Im Abschnitt »#pgv_lang[ra_RA_name]#« der Seite »#pgv_lang[personal_facts]#« einer Person wird die Suche auf dieser Person basieren. Wenn die Suche über die Hauptmenüs des #pgv_lang[ra_RA_name]# gestartet wird, muss zuerst eine Person gewählt werden, indem Sie auf das Personensymbol klicken, um eine Person zu wählen, oder indem Sie die Identifikationsnummer der Person in das Feld eingeben.<br /><br />Wählen Sie aus der Liste den Namen der Genealogie-Site, die Sie abfragen möchten. Ihnen wird eine Liste mit Informationen gezeigt, die Sie wählen können. Markieren Sie mit Häkchen neben jedem Eintrag (Name, Geburts- oder Sterbedatum usw.), welche Einträge an die gewählte Suchmaschine weitergeleitet werden, nachdem Sie den <b>#pgv_lang[ra_autosearch_search]#</b> Button geklickt haben. Die Suchmaschine der externen Website wird auf einer neuen Seite gestartet. Verwenden Sie die Verwaltungsfunktion #pgv_lang[ra_task_list]# um weitere Ergebnisse für die Nachverfolgung zu identifizieren.<br /><br />Bitte beachten Sie, dass Suchmaschinen sich ständig weiterentwickeln. Wenn Sie sich also auf einer Genealogie-Site befinden, bieten die dort vorhandenen nativen Funktionen möglicherweise weitere Suchkriterien, die aktualisiert werden können, um Ihre Recherche zu bereichern.</ul>";
$pgv_lang["ra_ViewProb_help"]		= "<ul>~#pgv_lang[ra_analyze_database]#~<br /><br />Diese Seite analysiert die Daten in Ihrer genealogischen Datenbank und zeigt die Korrelationen zwischen verschiedenen Datenelementen.<br /><br />Beispielsweise könnte eine 95-prozentige Korrelation bestehen, dass der Nachname in einem lokalen Datensatz mit dem Nachnamen im Datensatz des Vaters übereinstimmt. Dies würde bedeuten, dass 95% der Personen in dieser genealogischen Datenbank denselben Nachnamen wie ihr Vater haben. In dieser Version des #pgv_lang[ra_RA_name]# Moduls werden diese Berechnungen verwendet, um fehlende Informationen in den Datensätzen einer Person zu identifizieren. Sie werden in anderen Bereichen des Programms nicht verwendet; sie dienen Ihnen nur als Hilfe für Ihre Recherche.</ul>";
$pgv_lang["ra_GenerateTasks_help"]		= "<ul>~#pgv_lang[ra_gen_tasks]#~<br /><br />Einige genealogische Programme ermöglichen es Ihnen, Forschungsaufgaben als TODO-Elemente in ihre Datenbank einzugeben. Wenn sie diese genealogischen Informationen in andere Programme exportieren, exportieren diese die Datenbankeinträge in eine Datei, die gemäß der GEDCOM-Empfehlung formatiert ist. Die PhpGedView-Software verwendet die GEDCOM-formatierte Datei als Eingabe, sodass diese TODO-Elemente in Ihre Daten eingebettet sind. Diese Option durchsucht Ihre genealogische Datenbank und wandelt alle importierten TODO-Elemente automatisch in Forschungsaufgaben um.<br /><br />Wenn Sie unten im Formular den <b>#pgv_lang[ra_generate]#</b> Button klicken, wird aus den importierten TODO-Elementen eine Liste potenzieller Aufgaben erstellt. Aus dieser Liste können Sie Elemente wählen, aus denen Aufgaben generiert werden sollen.<ul><li><b>#pgv_lang[ra_generate]#</b>&nbsp;&nbsp;Markieren Sie jede zu generierende Aufgabe und generieren Sie dann diese Aufgabe.</li><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Die ersten 30 Zeichen der Aufgabenbeschreibung werden zum Namen der Aufgabe. Sie können dies ändern oder korrigieren, wenn Sie die Aufgabe bearbeiten.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Die Beschreibung der Aufgabe wird aus dem vollständigen Text des TODO-Elements in Ihrer genealogischen Datenbank kopiert. Sie können diese Beschreibung ändern oder korrigieren, wenn Sie die Aufgabe bearbeiten.</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Klicken Sie den Link, um die Aufgabe zu bearbeiten.</li><li><b>#pgv_lang[ra_SelectFolder]#</b>&nbsp;&nbsp;Wählen Sie den Ordner, in den die generierten Aufgaben gruppiert werden sollen.</li><li><b>#pgv_lang[ra_done]#</b>&nbsp;&nbsp;leitet Sie zur Seite #pgv_lang[ra_Folder_View]# weiter.</li></ul></ul>";
$pgv_lang["ra_EditGenerateTasks_help"]	= "<ul>~#pgv_lang[ra_Edit_Gen_Task]#~<br /><br />Mit diesem Formular können Sie die Aufgaben bearbeiten, die aus TODO-Elementen in Ihrer genealogischen Datenbank erstellt wurden.<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;So wählen Sie die Person, der die Aufgabe zugeordnet werden soll.</li><li><b>#pgv_lang[ra_source]#</b>&nbsp;&nbsp;Klicken Sie auf Link, um die Quelle zu wählen, der die Aufgabe zugeordnet werden soll.</li><li><b>#pgv_lang[ra_save]#</b>&nbsp;&nbsp;Speichert alle Ihre Änderungen und leitet Sie auf die Seite #pgv_lang[ra_gen_tasks]# weiter.</li><li><b>#pgv_lang[ra_cancel]#</b>&nbsp;&nbsp;Verwirft alle Ihre Änderungen und leitet Sie auf die Seite #pgv_lang[ra_gen_tasks]# weiter.</li></ul></ul>";
$pgv_lang["ra_configure_privacy_help"]		= "<ul>~#pgv_lang[ra_configure_privacy]#~<br /><br />Als Administrator Ihrer PhpGedView-Site haben Sie die Möglichkeit, die Sichtbarkeit verschiedener Funktionen des Moduls #pgv_lang[ra_RA_name]# zu steuern. In diesem Dialog werden die verfügbaren Funktionsblöcke angezeigt und Sie werden aufgefordert, die Sichtbarkeit durch Auswahl der Zugriffskontrollen für jeden Block festzulegen.<ul><li><b>#pgv_lang[PRIV_PUBLIC]#</b>&nbsp;&nbsp;Der angegebene Funktionsblock steht jedem zur Verfügung.</li><li><b>#pgv_lang[PRIV_USER]#</b>&nbsp;&nbsp;Der angegebene Funktionsblock ist nur für authentifizierte Benutzer verfügbar.</li><li><b>#pgv_lang[PRIV_NONE]#</b>&nbsp;&nbsp;Der angegebene Funktionsblock ist nur für Benutzer mit Administratorrechten verfügbar.</li><li><b>#pgv_lang[PRIV_HIDE]#</b>&nbsp;&nbsp;Der angegebene Funktionsblock steht niemandem zur Verfügung.</li></ul></ul>";
?>
