<?php
/**
 * English language Help file for PhpGedView Research Assistant module
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Research_Assistant
 * @version $Id: help_text.en.php 7377 2024-10-18 13:50:13Z canajun2eh $
 *
 * The companion file to this is lang.en.php, which contains most of the brief texts.
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

//-- Miscellaneous advisories and instructions
$pgv_lang["ra_auto_gen_inst"]		= "Some programs allow you to enter research tasks as TODO items in your genealogical database. This option will search through your genealogical database and automatically convert each TODO item into a research task.";
$pgv_lang["ra_mytasks_block_descr"]		= "The «#pgv_lang[ra_my_tasks]#» block shows tasks for the current user. It can be configured to show completed tasks or to show tasks that are currently unassigned.";

//-- RA HELP MESSAGES
// - Variables with *_help are the actual help texts. *_words are useful text blocks that can be used multiple times in different help texts 

$pgv_lang["ra_organizetasks_words"]		= "~How to Organize Tasks~<br /><br />Tasks are organized into folders. At least one folder must exist before any tasks can be created.<br /><br />You may create and organize your folders however you like. You will probably want to organize your online folders like you organize hard copies of your research. Many researchers organize their folders by family line, surname, or geographic locations.";
$pgv_lang["ra_whataretasks_words"]		= "~What are Tasks?~<br /><br />The #pgv_lang[ra_RA_name]# module is centered on the research Task. A research Task is similar to a TODO item and tracks a particular genealogical research assignment that needs to be done. An example task title may be, «Find Joe's Birth record», while the specifics in the description would indicate «Find Joe's birth record in the Ottawa county Birth Records».<br /><br />Tasks may be assigned to specific users. By assigning tasks to users everyone knows what research they should be working on, and who is working on other research tasks.<br /><br />Tasks may also include actions against source material or related to one or more persons in your data. With the #pgv_lang[ra_RA_name]# module installed, you will see a «#pgv_lang[ra_RA_name]#» section on each «#pgv_lang[personal_facts]#» page and also a Tasks section on each Source data page.<br /><br />Tasks are created in the <b>#pgv_lang[ra_incomplete]#</b> state, indicating the work on it is ongoing. All Tasks should be assigned to a user that can edit and update the records with the findings. Once all the work is done, the Task should be submitted as <b>#pgv_lang[ra_complete]#</b>. This will remove it from the actively visible (i.e. #pgv_lang[ra_incomplete]#) task lists. By using the «#pgv_lang[ra_my_tasks]#» menu each user can see their assigned tasks, both #pgv_lang[ra_incomplete]# and #pgv_lang[ra_complete]#.<br /><br />Each task has a comments section where discussions regarding the data and research or possible outcomes can occur. This allows the task to remain goal oriented while the comments are progress and results oriented.";
$pgv_lang["ra_sortcol_words"]		= "This column can be sorted by clicking the column header.";
$pgv_lang["ra_folder_words"]			= "Folders are a task management tool that permits grouping of tasks together. Folders can be contained within other folders. If there is a parent folder it will be displayed on the left side of the menus above. If that area is blank, these folders are at the topmost level.";
$pgv_lang["ra_view_task_words"]		= "Tasks are ways to manage research to-dos or actions for follow-up. The task is summarized by its title, while the description field defines more detail about what is required. Sometimes the follow-up for the resolution may also be included in the description field. Below the «#pgv_lang[ra_Task_View]#» table there is a «#pgv_lang[ra_comments]#» table that may be used for tracking progress and for describing task resolutions.";
$pgv_lang["ra_special_char_words"]		= "On occasion, your text may need to show symbols that have special meanings to the browser or to PhpGedView, other than being ordinary text. When such symbols must occur in your text, you need to enter them in a format that indicates that they are text without special meaning.<ul><li><b>&amp;</b>&nbsp;&nbsp;This symbol signals the start of an HTML Entity. To indicate that this symbol is ordinary text, you can either ensure that it is always followed by a space, or you can enter it in its HTML Entity form <b>&amp;amp;</b></li><li><b>&#35;</b>&nbsp;&nbsp;This symbol is used in the Help system of PhpGedView. To indicate that this symbol is ordinary text, you can either ensure that it is always followed by a space, or you can enter it in its numeric form <b>&amp;&#35;35;</b></li><li><b>&#126;</b>&nbsp;&nbsp;This symbol is used in the Help system of PhpGedView. To indicate that this symbol is ordinary text, you can either ensure that it is always followed by a space, or you can enter it in its numeric form <b>&amp;&#35;126;</b></li><li><b>&#92;</b>&nbsp;&nbsp;This symbol is interpreted by the Browser to mean that the symbol that follows is text. To indicate that this symbol is ordinary text, you must enter two of them <b>&#92;&#92;</b> or you can enter it in its numeric form <b>&amp;&#35;92;</b></li><li><b>&lt;</b>&nbsp;&nbsp;This symbol is interpreted by the browser to indicate the start of an HTML tag. To indicate that this symbol is ordinary text, you must enter it in its HTML Entity form <b>&amp;lt;</b></li><li><b>&gt;</b>&nbsp;&nbsp;This symbol is interpreted by the browser to indicate the end of an HTML tag. To indicate that this symbol is ordinary text, you must enter it in its HTML Entity form <b>&amp;gt;</b></li></ul>You can create lists of items in a description. If you want to ceate numbered or bulleted lists, begin your input of these list items with <b>&lt;ul&gt;</b> for a bulleted list or <b>&lt;ol&gt;</b> for a numbered list.<br /><br />Each list item should begin with <b>&lt;li&gt;</b> and end with <b>&lt;/li&gt;</b>. The last list item should be terminated like all the others and should be followed by <b>&lt;/ul&gt;</b> to close the bulleted list or <b>&lt;/ol&gt;</b> to close the numbered list.<br /><br />The preceding notes about entering the symbols «Less-Than» <b>&lt;</b> and «Greater-Than» <b>&gt;</b>, that usually enclose HTML tags, as text do not apply since in this case you actually need to enter HTML tags.";
$pgv_lang["ra_add_task_words"]		= "Before any tasks can be created, you <u>must</u> have established a folder to contain that task.<br /><br />Tasks are ways to manage research to-dos or actions for follow-up. These tasks are summarized by their titles and use the description fields to define in more detail what is required. Tasks may also have some source material to be researched so this can be attached, and if there are one or more persons with whom this task is associated they should also be attached to this new task.";


$pgv_lang["ra_mytasks_help"]			= "<ul>~#pgv_lang[ra_my_tasks]#~<br /><br />The «#pgv_lang[ra_my_tasks]#» list shows research tasks for the current user. By default the task list shows open or incomplete tasks for the current user. This can be configured to additionally show completed tasks and to show tasks that are currently unassigned. The resulting table can then be used to quickly look at the research tasks to be managed.<ul><li>When you click on a <b>#pgv_lang[ra_title]#</b> you will be taken to a «#pgv_lang[ra_Task_View]#» for more details on the specific task.</li><li>#pgv_lang[ra_Start_Date]# indicates when the task was originally created.</li><li>When you click on <b>#pgv_lang[ra_edit]#</b> at the end of each task's row, you will be taken to the «#pgv_lang[ra_edit_task]#» view for that specific task to update or complete it.</li></ul></ul>";
$pgv_lang["ra_missing_info_help"]		= "<ul>~#pgv_lang[ra_missing_info]#~<br /><br />This area shows potential missing information about a person's record. For instance, this could include a missing birth source or the fact that the person was alive during a military conflict but is missing a military entry. The #pgv_lang[ra_RA_name]# module will inspect the person's genealogical database record for possible missing information and produce a list of potential follow-up tasks which can be created.<br /><br />Before any missing tasks can be created, you <u>must</u> have established a folder to contain the tasks.<br /><br />The table presents a list of potential new tasks that could be created or previously generated tasks to view.<ul><li>To create a task to track some missing information, select the checkbox beside it. When all desired tasks have been selected and a folder for grouping these new tasks has been chosen, click <b>#pgv_lang[ra_AddTask]#</b> to create tasks for the missing items.</li><li>Existing tasks will show <b>#pgv_lang[ra_view]#</b> instead of a checkbox which, when clicked, will take you directly to view that task.</li></ul>#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_person_task_list_help"]		= "<ul>~#pgv_lang[ra_task_list]#~<br /><br />The table shown is a list of research tasks that are associated with this person's record. Only tasks not marked as completed are shown. They could have been created manually or generated by using the «#pgv_lang[ra_missing_info]#» table, but each Task has this person associated with it.<br /><br />Click on the task's title to see further details about it.</br>Click the button <b>#pgv_lang[ra_task_entry]#</b> at the bottom of the table to manually create a new task linked to this person's record.<br /><br />#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_sources_task_list_help"]		= "<ul>~#pgv_lang[ra_task_list]#~<br /><br />This is a list of all tasks that are associated with this source. Only tasks not marked as completed are shown. The message «#pgv_lang[ra_no_sour_tasks]#» will appear when no tasks have this source linked. When there is an associated task, click on the task's title to launch the «#pgv_lang[ra_view_task]#» page for further details about it.<br /><br /><b>Note</b>: New tasks cannot be created within the «#pgv_lang[ra_source]#» entry. Use the <b>#pgv_lang[ra_AddTask]#</b> function if needed specifically for a source that is not linked to a person.<br /><br />#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_view_tasklist_help"]		= "<ul>~#pgv_lang[ra_Task_View]#~<br /><br />#pgv_lang[ra_view_task_words]#<br /><br />This table is a list of tasks. The columns include:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;A summary title for the task. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;This is a detailed description of the task needed for research or actions for follow-up. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_Start_Date]#</b>&nbsp;&nbsp;This is the creation date of the task. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_completed]#</b>&nbsp;&nbsp;This indicates whether or not a task is completed. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_assigned]#</b>&nbsp;&nbsp;This entry indicates who owns a research task. This column is not shown in the «#pgv_lang[ra_my_tasks]#» view as you are the owner of all these tasks.</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;If you are the owner of this task or have administration rights, this entry contains a <u>link</u> which will take you to edit the task, otherwise it will be blank.</li><li><b>#pgv_lang[ra_delete]#</b>&nbsp;&nbsp;If you are the owner of this task or have administration rights, this entry contains a <u>link</u> which will take you to delete the task, otherwise it will be blank.</li><li><b>#pgv_lang[ra_complete]#</b>&nbsp;&nbsp;If you are the owner of this task or have administration rights, this entry contains a <u>link</u> which will take you to immediately close a task if it is not currently complete, otherwise this field will be blank. This column will only be shown in the «#pgv_lang[ra_my_tasks]#» view as you are the owner of all these tasks.</li></ul>#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_task_view_help"]		= "<ul>~#pgv_lang[ra_view_task]#~<br /><br />#pgv_lang[ra_view_task_words]#<br /><br />This table summarizes one specific task.<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;This is the title of the task.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;This is the folder into which the task is grouped.</li><li><b>#pgv_lang[ra_assigned]#</b>&nbsp;&nbsp;This is the researcher to whom the task is currently assigned.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;This is the detailed description of the task needed for research or actions for follow-up.</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Any sources needed for research or actions for follow-up for the task.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;This is a list of persons from the family tree who are associated with the task. This field can contain multiple entries. Only persons in the family tree are shown.</li></ul><br />If you are the assigned owner of the task or have administration rights then a button will be presented and you can click <b>#pgv_lang[ra_edit_task]#</b> to edit the details of the task.</ul>";
$pgv_lang["ra_add_task_help"]		= "<ul>~#pgv_lang[ra_add_new_task]#~<br /><br />#pgv_lang[ra_add_task_words]#<br /><br />The form's fields include:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;This should contain a short summary, typically less than 30 characters in length, of the task that you are adding.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;Select the folder in which you want to manage your new task. Only existing folders are shown. If you want to assign this new task to a new folder you must use the <b>#pgv_lang[ra_add_folder]#</b> function from the main #pgv_lang[ra_RA_name]# menu first.</li><li><b>#pgv_lang[ra_assign_task]#</b>&nbsp;&nbsp;Select from the list of users with Edit permissions someone who can own or update the task and any records associated with it. In general, this field should never be blank (#pgv_lang[ra_mytasks_unassigned]#).</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Enter a detailed description of the task you want to add.<br /><br />#pgv_lang[ra_special_char_words]#</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Attach any sources that you have for the task. This field can contain multiple entries.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Select all persons associated with the new task. This field can contain multiple entries, but only persons in your genealogical database are selectable and can be shown in this field.</li></ul><br />When creating a new task, it can be saved by clicking the <b>#pgv_lang[ra_submit]#</b> button, which will keep it open and in the #pgv_lang[ra_incomplete]# state for further updates. The task can be saved and marked as #pgv_lang[ra_complete]# at the same time by clicking the <b>#pgv_lang[ra_save_and_complete]#</b> button.</ul>";
$pgv_lang["ra_edit_task_help"]		= "<ul>~#pgv_lang[ra_edit_task]#~<br /><br />#pgv_lang[ra_add_task_words]#<br /><br />The form's fields include:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;This should contain the title or summary of the task that you are editing.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;In this field you can select the folder in which you want to manage your new task.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Enter a detailed description of the task you want to add.<br /><br />#pgv_lang[ra_special_char_words]#</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Attach any sources that you have for the task. This field can contain multiple entries.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Select all people associated with this task. This field can contain multiple entries, but only persons from your genealogical database can be selected and shown in this field.</li></ul><br />After modifying an existing task, it can be submitted for future updates by clicking the <b>#pgv_lang[ra_save]#</b> button. The task can be also be saved and marked as #pgv_lang[ra_completed]# (no future updates are expected), by clicking the <b>#pgv_lang[ra_save_and_complete]#</b> button.</ul>";
$pgv_lang["ra_comments_help"]		= "<ul>~#pgv_lang[ra_comments]#~<br /><br />This will contain any comments related to a research task.<br /><br />When in the «#pgv_lang[ra_RA_name]#» section for a person, these comments are linked to the specific record of this person and visible only here. If a comment is shown beneath a task, that comment is specific to that task. In each case there can be multiple independent comments. Each can be independently edited or deleted with the most recent comment always displayed at the top.<br /><br />Click <b>#pgv_lang[ra_add_new_comment]#</b> to add any new comments to this list.<br /><br /><span class='warning'>If, while editing a task, you add a new comment before saving your edited task, any unsaved task changes will be lost.</span></ul>";
$pgv_lang["ra_folder_view_help"]		= "<ul>~#pgv_lang[ra_Folder_View]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />This is a list of folders and descriptions of their use.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;This column contains the names of all of the folders at this level that you have created. By selecting the folder name, you will be navigated to a new display showing any sub-folders and all tasks associated with this folder. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;This column contains a more detailed description of the use of these folders. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;This column has a <u>link</u> to permit editing the folder's name, description or hierarchy.</li></ul><br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_add_folder_help"]		= "<ul>~#pgv_lang[ra_Add_folder]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />This form supports the creation of a new folder, its description of use, and the hierarchy of other folders into which this folder fits.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;The title summarizes the use of the folder that you are adding.</li><li><b>#pgv_lang[ra_Parent_Folder]#</b>&nbsp;&nbsp;You can specify whether the folder is at the highest or root level (#pgv_lang[ra_No_Parent]#) or as a sub-folder to another folder.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;This is the detailed description of the folder you are adding.</li></ul>Clicking the <b>#pgv_lang[ra_add]#</b> button will submit the information to create a new folder. Clicking the <b>#pgv_lang[ra_reset]#</b> button will discard any changes to the description field.<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_edit_folder_help"]		= "<ul>~#pgv_lang[ra_Edit_folder]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />This form supports the editing of an existing folder, its description of use and the hierarchy of other folders into which this folder fits.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;The title summarizes the use of the folder that you are adding.</li><li><b>#pgv_lang[ra_Parent_Folder]#</b>&nbsp;&nbsp;You can specify whether the folder is either at the highest level (#pgv_lang[ra_No_Parent]#) or as a sub-folder to another folder.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;This is the detailed description of the folder you are adding.</li></ul><br />The <b>#pgv_lang[ra_add]#</b> button will submit the information to create a new folder. The <b>#pgv_lang[ra_reset]#</b> button will discard any changes in the description field made since last saved. When a folder is empty, the <b>#pgv_lang[ra_delete]#</b> button will appear to permit removing this folder from the folder hierarchy, otherwise you will be warned that deleting is not allowed with tasks still present in it.<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_auto_search_help"]		= "<ul>~#pgv_lang[ra_auto_search_text]#~<br /><br />Based on the person chosen, this feature will automatically extract various vital and fact informations from your genealogical database and allow you to determine which of these to pass to an external genealogy website's search engine. Various sites can be chosen, including Ancestry, FamilySearch, Findagrave and more. The results of these searches can be used to add or update information in your genealogical database.<br /><br />When in the «#pgv_lang[ra_RA_name]#» section of a person's «#pgv_lang[personal_facts]#» page, the search will be based on that person. If launched from the main #pgv_lang[ra_RA_name]# menus, a person must first be chosen by clicking the person icon to select a person or entering the person's identification number into the field.<br /><br />Choose from the list the name of the genealogy site you wish to query. You will be shown a list of informations that can be selected. Indicate by tick marks beside each item (name, birth or death date, etc) the items that will be passed to the chosen search engine after the <b>#pgv_lang[ra_autosearch_search]#</b> button has been clicked. The external website's search engine is launched in a new page. Use the «#pgv_lang[ra_task_list]#» management facility to identify additional findings for follow up.<br /><br />Please note that search engines are constantly evolving so once on a genealogy site, the native capabilities there may offer more search criteria that can be updated to enrich your research.</ul>";
$pgv_lang["ra_ViewProb_help"]		= "<ul>~#pgv_lang[ra_analyze_database]#~<br /><br />This page analyzes the data within in your genealogical database and shows the correlations between different data elements.<br /><br />For example, there could be a 95% correlation that the surname in a local record is the same as the surname in the father's record. This would mean that 95% of the people in this genealogical database share the same surname as their father. In this version of the #pgv_lang[ra_RA_name]# module, these calculations are being used to help identify missing information for a person's records. They are not used in other areas of the program; they are only provided as a help to you in your research.</ul>";
$pgv_lang["ra_GenerateTasks_help"]		= "<ul>~#pgv_lang[ra_gen_tasks]#~<br /><br />Some genealogical programs allow you to enter research tasks as TODO items in their database. When exporting this genealogical information to other programs they will export the database records into a file formatted according to the GEDCOM recommendation. The PhpGedView software uses the GEDCOM formatted file as input, so these TODO items are embedded in your data. This option will search your genealogical database and automatically convert all imported TODO items into research tasks.<br /><br />Clicking the <b>#pgv_lang[ra_generate]#</b> button at the bottom of the form will create a list of potential tasks from the imported TODO items. From this list you can select items to generate tasks.<ul><li><b>#pgv_lang[ra_generate]#</b>&nbsp;&nbsp;Mark each task to generate and then generate that task.</li><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;The first 30 characters of the task description will become the Task's name. You can change or correct this when you edit the task.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;The description the task will be given, copied from the complete text of the TODO item in your genealogical database. You can change or correct this when you edit the task.</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Click the link to edit that task.</li><li><b>#pgv_lang[ra_SelectFolder]#</b>&nbsp;&nbsp;Select the folder into which to put the generated tasks.</li><li><b>#pgv_lang[ra_done]#</b>&nbsp;&nbsp;redirects you to the «#pgv_lang[ra_Folder_View]#» page.</li></ul></ul>";
$pgv_lang["ra_EditGenerateTasks_help"]	= "<ul>~#pgv_lang[ra_Edit_Gen_Task]#~<br /><br />This form allows you to edit the tasks that were created from TODO items in your genealogical database.<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;To select the person with whom to associate the task.</li><li><b>#pgv_lang[ra_source]#</b>&nbsp;&nbsp;Click the link to select the source with which to associate the task.</li><li><b>#pgv_lang[ra_save]#</b>&nbsp;&nbsp;Saves all your changes and redirects you to the «#pgv_lang[ra_gen_tasks]#» page.</li><li><b>#pgv_lang[ra_cancel]#</b>&nbsp;&nbsp;Discards all your changes and redirects you to the «#pgv_lang[ra_gen_tasks]#» page.</li></ul></ul>";
$pgv_lang["ra_configure_privacy_help"]		= "<ul>~#pgv_lang[ra_configure_privacy]#~<br /><br />As the administrator of your PhpGedView site, you have the ability to control the visibility of different functionalities of the #pgv_lang[ra_RA_name]# module. This dialog presents the available functional blocks and asks you to select the visibility by choosing access controls for each.<ul><li><b>#pgv_lang[PRIV_PUBLIC]#</b>&nbsp;&nbsp;The specified functional block is available to everyone.</li><li><b>#pgv_lang[PRIV_USER]#</b>&nbsp;&nbsp;The specified functional block is available only to authenticated users.</li><li><b>#pgv_lang[PRIV_NONE]#</b>&nbsp;&nbsp;The specified functional block is available only to users with Admin rights.</li><li><b>#pgv_lang[PRIV_HIDE]#</b>&nbsp;&nbsp;The specified functional block is not available to anyone.</li></ul></ul>";
?>
