<?php
/**
 * Dutch language Help file for PhpGedView Research Assistant module
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Research_Assistant
 * @version $Id: help_text.nl.php 7377 2024-10-18 13:50:13Z canajun2eh $
 *
 * The companion file to this is lang.nl.php, which contains most of the brief texts.
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

//-- Miscellaneous advisories and instructions
$pgv_lang["ra_auto_gen_inst"]		= "Sommige programma's laten u onderzoekstaken invoeren als TODO-elementen in uw genealogische database. Deze optie doorzoekt uw genealogische database en converteert automatisch elk TODO-element naar een onderzoekstaak.";
$pgv_lang["ra_mytasks_block_descr"]		= "Het blok «#pgv_lang[ra_my_tasks]#» toont taken voor de huidige gebruiker. Het kan worden geconfigureerd om voltooide taken te tonen of om taken te tonen die momenteel niet zijn toegewezen.";

//-- RA HELP MESSAGES
// - Variables with *_help are the actual help texts. *_words are useful text blocks that can be used multiple times in different help texts 

$pgv_lang["ra_organizetasks_words"]		= "~Hoe u taken organiseert~<br /><br />Taken worden georganiseerd in mappen. Er moet ten minste één map bestaan voordat er taken kunnen worden gemaakt.<br /><br />U kunt uw mappen maken en organiseren zoals u wilt. U zult uw online mappen waarschijnlijk willen organiseren zoals u papieren exemplaren van uw onderzoek organiseert. Veel onderzoekers organiseren hun mappen op familielijn, achternaam of geografische locaties.";
$pgv_lang["ra_whataretasks_words"]		= "~Wat zijn taken?~<br /><br />De #pgv_lang[ra_RA_name]#» module is gecentreerd op de onderzoekstaak. Een onderzoekstaak is vergelijkbaar met een TODO-element en volgt een specifieke genealogische onderzoeksopdracht die moet worden uitgevoerd. Een voorbeeld van een taaktitel kan zijn, «Vind Joe's geboorteakte», terwijl de details in de beschrijving zouden aangeven «Vind Joe's geboorteakte in de geboorteaktes van de county Ottawa».<br /><br />Taken kunnen worden toegewezen aan specifieke gebruikers. Door taken toe te wijzen aan gebruikers weet iedereen aan welk onderzoek ze moeten werken en wie er aan andere onderzoekstaken werkt.<br /><br />Taken kunnen ook acties bevatten tegen bronmateriaal of gerelateerd aan een of meer personen in uw gegevens. Met de #pgv_lang[ra_RA_name]# module geïnstalleerd, ziet u een «#pgv_lang[ra_RA_name]#» sectie op elke «#pgv_lang[personal_facts]#» pagina en ook een Taken sectie op elke Brongegevens pagina.<br /><br />Taken worden gemaakt in de status <b>#pgv_lang[ra_incomplete]#</b>, wat aangeeft dat het werk eraan gaande is. Alle taken moeten worden toegewezen aan een gebruiker die de records kan bewerken en bijwerken met de bevindingen. Zodra al het werk is voltooid, moet de taak worden ingediend als <b>#pgv_lang[ra_complete]#</b>. Dit zal het verwijderen uit de actief zichtbare (i.e. #pgv_lang[ra_incomplete]#) takenlijsten. Door het «#pgv_lang[ra_my_tasks]#» menu te gebruiken kan elke gebruiker zijn toegewezen taken zien, zowel #pgv_lang[ra_incomplete]# als #pgv_lang[ra_complete]#.<br /><br />Elke taak heeft een commentaarsectie waar discussies over de data en het onderzoek of mogelijke uitkomsten kunnen plaatsvinden. Hierdoor kan de taak doelgericht blijven terwijl de commentaren gericht zijn op voortgang en resultaten.";
$pgv_lang["ra_sortcol_words"]		= "U kunt deze kolom sorteren door op de kolomkop te klikken.";
$pgv_lang["ra_folder_words"]			= "Mappen zijn een taakbeheertool waarmee u taken kunt groeperen. Mappen kunnen in andere mappen worden geplaatst. Als er een bovenliggende map is, wordt deze weergegeven aan de linkerkant van de menu's hierboven. Als dat gebied leeg is, staan deze mappen op het hoogste niveau.";
$pgv_lang["ra_view_task_words"]		= "Taken zijn manieren om onderzoekstaken of acties voor follow-up te beheren. De taak wordt samengevat door de titel, terwijl het beschrijvingsveld meer details definieert over wat er vereist is. Soms kan de follow-up voor de oplossing ook in het beschrijvingsveld worden opgenomen. Onder de tabel «#pgv_lang[ra_Task_View]#» staat een «#pgv_lang[ra_comments]#» tabel die kan worden gebruikt om de voortgang bij te houden en om taakoplossingen te beschrijven.";
$pgv_lang["ra_special_char_words"]		= "Soms moet uw tekst symbolen weergeven die een speciale betekenis hebben voor de browser of voor PhpGedView, anders dan gewone tekst. Wanneer dergelijke symbolen in uw tekst moeten voorkomen, moet u ze invoeren in een formaat dat aangeeft dat het tekst is zonder speciale betekenis.<ul><li><b>&amp;</b>&nbsp;&nbsp;Dit symbool geeft het begin van een HTML-entiteit aan. Om aan te geven dat dit symbool gewone tekst is, kunt u ervoor zorgen dat het altijd wordt gevolgd door een spatie, of u kunt het invoeren in de HTML-entiteitsvorm <b>&amp;amp;</b></li><li><b>&#35;</b>&nbsp;&nbsp;Dit symbool wordt gebruikt in het Help-systeem van PhpGedView. Om aan te geven dat dit symbool gewone tekst is, kunt u ervoor zorgen dat het altijd wordt gevolgd door een spatie, of u kunt het invoeren in de numerieke vorm <b>&amp;&#35;35;</b></li><li><b>&#126;</b>&nbsp;&nbsp;Dit symbool wordt gebruikt in het Help-systeem van PhpGedView. Om aan te geven dat dit symbool gewone tekst is, kunt u ervoor zorgen dat het altijd wordt gevolgd door een spatie, of u kunt het invoeren in de numerieke vorm <b>&amp;&#35;126;</b></li><li><b>&#92;</b>&nbsp;&nbsp;Dit symbool wordt door de browser geïnterpreteerd als dat het symbool dat volgt tekst is. Om aan te geven dat dit symbool gewone tekst is, moet u er twee invoeren <b>&#92;&#92;</b> of u kunt het invoeren in de numerieke vorm <b>&amp;&#35;92;</b></li><li><b>&lt;</b>&nbsp;&nbsp;Dit symbool wordt door de browser geïnterpreteerd om het begin van een HTML-tag aan te geven. Om aan te geven dat dit symbool gewone tekst is, moet u het invoeren in de HTML-entiteitsvorm <b>&amp;lt;</b></li><li><b>&gt;</b>&nbsp;&nbsp;Dit symbool wordt door de browser geïnterpreteerd om het einde van een HTML-tag aan te geven. Om aan te geven dat dit symbool gewone tekst is, moet u het invoeren in de HTML-entiteitsvorm <b>&amp;gt;</b></li></ul>U kunt lijsten met items in een beschrijving maken. Als u genummerde of opsommingstekenlijsten wilt maken, begint u uw invoer van deze lijstitems met <b>&lt;ul&gt;</b> voor een opsommingstekenlijst of <b>&lt;ol&gt;</b> voor een genummerde lijst.<br /><br />Elk lijstitem moet beginnen met <b>&lt;li&gt;</b> en eindigen met <b>&lt;/li&gt;</b>. Het laatste item in de lijst moet worden afgesloten zoals alle andere items en moet worden gevolgd door <b>&lt;/ul&gt;</b> om de lijst met opsommingstekens te sluiten of <b>&lt;/ol&gt;</b> om de genummerde lijst te sluiten.<br /><br />De voorgaande opmerkingen over het invoeren van «Kleiner-dan» <b>&lt;</b> en «Groter-dan» <b>&gt;</b> symbolen, die normaal gesproken HTML-tags omsluiten, als tekst, zijn niet van toepassing omdat u in dat geval daadwerkelijk HTML-tags moet invoeren.";
$pgv_lang["ra_add_task_words"]		= "Voordat u taken kunt aanmaken, moet u eerst een map voor die taak hebben aangemaakt.<br /><br />Taken zijn manieren om onderzoekstaken of acties voor follow-up te beheren. Deze taken worden samengevat door hun titels en gebruiken de beschrijvingsvelden om gedetailleerder te definiëren wat er nodig is. Taken kunnen ook wat bronmateriaal hebben dat moet worden onderzocht, zodat dit kan worden bijgevoegd, en als er een of meer personen zijn met wie deze taak is geassocieerd, moeten deze ook aan deze nieuwe taak worden toegevoegd.";


$pgv_lang["ra_mytasks_help"]			= "<ul>~#pgv_lang[ra_my_tasks]#~<br /><br />De lijst «#pgv_lang[ra_my_tasks]#» toont onderzoekstaken voor de huidige gebruiker. Standaard toont de takenlijst open of onvoltooide taken voor de huidige gebruiker. Dit kan worden geconfigureerd om ook voltooide taken te tonen en om taken te tonen die momenteel niet zijn toegewezen. De resulterende tabel kan vervolgens worden gebruikt om snel te kijken naar de onderzoekstaken die moeten worden beheerd.<ul><li>Wanneer u op <b>#pgv_lang[ra_title]#</b> klikt, wordt u naar «#pgv_lang[ra_Task_View]#» geleid voor meer details over de specifieke taak.</li><li>#pgv_lang[ra_Start_Date]# geeft aan wanneer de taak oorspronkelijk is gemaakt.</li><li>Wanneer u op <b>#pgv_lang[ra_edit]#</b> klikt aan het einde van de rij van elke taak, wordt u naar de weergave «#pgv_lang[ra_edit_task]#» geleid voor die specifieke taak om deze bij te werken of te voltooien.</li></ul></ul>";
$pgv_lang["ra_missing_info_help"]		= "<ul>~#pgv_lang[ra_missing_info]#~<br /><br />Dit gebied toont mogelijk ontbrekende informatie over het dossier van een persoon. Dit kan bijvoorbeeld een ontbrekende geboortebron zijn of het feit dat de persoon in leven was tijdens een militair conflict, maar een militaire vermelding mist. De #pgv_lang[ra_RA_name]# zal het genealogische databaserecord van de persoon inspecteren op mogelijk ontbrekende informatie en een lijst met mogelijke vervolgtaken produceren die kunnen worden gemaakt.<br /><br />Voordat er ontbrekende taken kunnen worden aangemaakt, <u>moet</u> u een map hebben aangemaakt waarin de taken worden opgeslagen.<br /><br />De tabel bevat een lijst met potentiële nieuwe taken die kunnen worden aangemaakt of eerder gegenereerde taken die u kunt bekijken.<ul><li>Om een taak te maken om ontbrekende informatie bij te houden, selecteert u het vakje ernaast. Wanneer alle gewenste taken zijn geselecteerd en een map is gekozen om deze nieuwe taken te groeperen, klikt u <b>#pgv_lang[ra_AddTask]#</b> om taken te maken voor de ontbrekende items.</li><li>Bestaande taken tonen <b>#pgv_lang[ra_view]#</b> in plaats van een vakje dat, wanneer u erop klikt, u direct naar de weergave van die taak brengt.</li></ul>#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_person_task_list_help"]		= "<ul>~#pgv_lang[ra_task_list]#~<br /><br />De getoonde tabel is een lijst met onderzoekstaken die gekoppeld zijn aan het record van deze persoon. Alleen taken die niet als voltooid zijn gemarkeerd, worden getoond. Ze kunnen handmatig zijn gemaakt of gegenereerd met behulp van de tabel «#pgv_lang[ra_missing_info]#», maar elke taak heeft deze persoon eraan gekoppeld.<br /><br />Klik op de titel van de taak om meer details te bekijken.</br>Klik de knop <b>#pgv_lang[ra_task_entry]#</b> onderaan de tabel om handmatig een nieuwe taak te maken die aan de record van deze persoon is gekoppeld.<br /><br />#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_sources_task_list_help"]		= "<ul>~#pgv_lang[ra_task_list]#~<br /><br />This is a list of all tasks that are associated with this source. Only tasks not marked as completed are shown. The message «#pgv_lang[ra_no_sour_tasks]#» will appear when no tasks have this source linked. When there is an associated task, click on the task's title to launch the «#pgv_lang[ra_view_task]#» page for further details about it.<br /><br /><b>Opmerking</b>: Nieuwe taken kunnen niet worden gemaakt binnen de «#pgv_lang[ra_source]#» invoer. Gebruik de functie <b>#pgv_lang[ra_AddTask]#</b> indien nodig specifiek voor een bron die niet aan een persoon is gekoppeld.<br /><br />#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_view_tasklist_help"]		= "<ul>~#pgv_lang[ra_Task_View]#~<br /><br />#pgv_lang[ra_view_task_words]#<br /><br />Deze tabel is een lijst met taken. De kolommen omvatten:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Een samenvattende titel voor de taak. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Dit is een gedetailleerde beschrijving van de taak die nodig is voor onderzoek of acties voor follow-up. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_Start_Date]#</b>&nbsp;&nbsp;Dit is de aanmaakdatum van de taak. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_completed]#</b>&nbsp;&nbsp;Dit geeft aan of een taak is voltooid. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_assigned]#</b>&nbsp;&nbsp;Deze invoer geeft aan wie de eigenaar is van een onderzoekstaak. Deze kolom wordt niet weergegeven in de weergave «#pgv_lang[ra_my_tasks]#», omdat u de eigenaar bent van al deze taken.</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Als u de eigenaar bent van deze taak of beheerdersrechten hebt, bevat deze invoer een <u>link</u> waarmee u de taak kunt bewerken. Anders blijft deze leeg.</li><li><b>#pgv_lang[ra_delete]#</b>&nbsp;&nbsp;Als u de eigenaar bent van deze taak of beheerdersrechten hebt, bevat deze invoer een <u>link</u> waarmee u de taak kunt verwijderen. Anders blijft deze leeg.</li><li><b>#pgv_lang[ra_complete]#</b>&nbsp;&nbsp;Als u de eigenaar bent van deze taak of beheerdersrechten hebt, bevat deze invoer een <u>link</u> waarmee u een taak direct kunt sluiten als deze nog niet is voltooid. Anders is dit veld leeg. Deze kolom wordt alleen weergegeven in de weergave «#pgv_lang[ra_my_tasks]#», omdat u de eigenaar bent van al deze taken.</li></ul>#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_task_view_help"]		= "<ul>~#pgv_lang[ra_view_task]#~<br /><br />#pgv_lang[ra_view_task_words]#<br /><br />Deze tabel vat één specifieke taak samen.<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Dit is de titel van de taak.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;Dit is de map waarin de taak is gegroepeerd.</li><li><b>#pgv_lang[ra_assigned]#</b>&nbsp;&nbsp;Dit is de onderzoeker aan wie de taak momenteel is toegewezen.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Dit is de gedetailleerde beschrijving van de taak die nodig is voor onderzoek of acties voor follow-up.</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Alle bronnen die nodig zijn voor onderzoek of acties voor follow-up voor de taak.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Dit is een lijst met personen uit de stamboom die aan de taak zijn gekoppeld. Dit veld kan meerdere vermeldingen bevatten. Alleen personen in de stamboom worden weergegeven.</li></ul><br />Als u de toegewezen eigenaar van de taak bent of beheerdersrechten hebt, wordt er een knop weergegeven waarop u <b>#pgv_lang[ra_edit_task]#</b> kunt klikken om de details van de taak te bewerken.</ul>";
$pgv_lang["ra_add_task_help"]		= "<ul>~#pgv_lang[ra_add_new_task]#~<br /><br />#pgv_lang[ra_add_task_words]#<br /><br />De velden van het formulier omvatten:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Dit moet een korte samenvatting bevatten, meestal minder dan 30 tekens lang, van de taak die u toevoegt.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;Selecteer de map waarin u uw nieuwe taak wilt beheren. Alleen bestaande mappen worden weergegeven. Als u deze nieuwe taak aan een nieuwe map wilt toewijzen, moet u eerst de functie <b>#pgv_lang[ra_add_folder]#</b> in het hoofdmenu #pgv_lang[ra_RA_name]# gebruiken.</li><li><b>#pgv_lang[ra_assign_task]#</b>&nbsp;&nbsp;Selecteer uit de lijst met gebruikers met bewerkingsrechten iemand die eigenaar is van de taak en alle records die eraan gekoppeld zijn, of deze kan bijwerken. Over het algemeen mag dit veld nooit leeg zijn (#pgv_lang[ra_mytasks_unassigned]#).</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Voer een gedetailleerde beschrijving in van de taak die u wilt toevoegen.<br /><br />#pgv_lang[ra_special_char_words]#</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Voeg alle bronnen toe die u voor de taak hebt. Dit veld kan meerdere vermeldingen bevatten.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Selecteer alle personen die aan deze taak zijn gekoppeld. Dit veld kan meerdere items bevatten, maar alleen personen uit uw genealogische database kunnen in dit veld worden geselecteerd en weergegeven.</li></ul><br />Bij het aanmaken van een nieuwe taak kan deze worden opgeslagen door op <b>#pgv_lang[ra_submit]#</b> te klikken. Deze houdt de taak open en in de status #pgv_lang[ra_incomplete]# voor verdere updates. De taak kan worden opgeslagen en tegelijkertijd worden gemarkeerd als #pgv_lang[ra_complete]# door op <b>#pgv_lang[ra_save_and_complete]#</b> te klikken.</ul>";
$pgv_lang["ra_edit_task_help"]		= "<ul>~#pgv_lang[ra_edit_task]#~<br /><br />#pgv_lang[ra_add_task_words]#<br /><br />De velden van het formulier omvatten:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Dit moet de titel of samenvatting bevatten van de taak die u bewerkt.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;In dit veld kunt u de map selecteren waarin u uw nieuwe taak wilt beheren.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Voer een gedetailleerde beschrijving in van de taak die u wilt toevoegen.<br /><br />#pgv_lang[ra_special_char_words]#</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Voeg alle bronnen toe die u voor de taak hebt. Dit veld kan meerdere vermeldingen bevatten.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Selecteer alle personen die aan deze taak zijn gekoppeld. Dit veld kan meerdere vermeldingen bevatten, maar alleen personen kunnen uit uw genealogische database worden geselecteerd en in dit veld worden weergegeven.</li></ul><br />Nadat u een bestaande taak hebt gewijzigd, kunt u deze indienen voor toekomstige updates door op <b>#pgv_lang[ra_save]#</b> te klikken. De taak kan ook worden opgeslagen en gemarkeerd als #pgv_lang[ra_completed]# (er worden geen toekomstige updates verwacht) door op <b>#pgv_lang[ra_save_and_complete]#</b> te klikken.</ul>";
$pgv_lang["ra_comments_help"]		= "<ul>~#pgv_lang[ra_comments]#~<br /><br />Dit bevat alle opmerkingen die betrekking hebben op een onderzoekstaak.<br /><br />Wanneer u zich in de sectie «#pgv_lang[ra_RA_name]#» voor een persoon bevindt, worden deze opmerkingen gekoppeld aan het specifieke record van deze persoon en zijn ze alleen hier zichtbaar. Als een opmerking onder een taak wordt weergegeven, is die opmerking specifiek voor die taak. In elk geval kunnen er meerdere onafhankelijke opmerkingen zijn. Elk kan onafhankelijk worden bewerkt of verwijderd, waarbij de meest recente opmerking altijd bovenaan wordt weergegeven.<br /><br />Klik op <b>#pgv_lang[ra_add_new_comment]#</b> om nieuwe opmerkingen aan deze lijst toe te voegen.<br /><br /><span class='warning'>Als u tijdens het bewerken van een taak een nieuwe opmerking toevoegt voordat u de bewerkte taak opslaat, gaan alle niet-opgeslagen taakwijzigingen verloren.</span></ul>";
$pgv_lang["ra_folder_view_help"]		= "<ul>~#pgv_lang[ra_Folder_View]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Dit is een lijst met mappen en beschrijvingen van hun gebruik.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;Deze kolom bevat de namen van alle mappen op dit niveau die u hebt gemaakt. Door de mapnaam te selecteren, wordt u naar een nieuw scherm geleid met alle submappen en alle taken die aan deze map zijn gekoppeld. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Deze kolom bevat een meer gedetailleerde beschrijving van het gebruik van deze mappen. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Deze kolom bevat een <u>link</u> waarmee u de naam, beschrijving of hiërarchie van de map kunt bewerken.</li></ul><br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_add_folder_help"]		= "<ul>~#pgv_lang[ra_Add_folder]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Dit formulier ondersteunt het maken van een nieuwe map, de beschrijving van het gebruik ervan en de hiërarchie van andere mappen waarin deze map past.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;De titel vat het gebruik samen van de map die u toevoegt.</li><li><b>#pgv_lang[ra_Parent_Folder]#</b>&nbsp;&nbsp;U kunt opgeven of de map zich op het hoogste niveau of rootniveau (#pgv_lang[ra_No_Parent]#) bevindt of als een submap van een andere map.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Dit is de gedetailleerde beschrijving van de map die u toevoegt.</li></ul>Als u <b>#pgv_lang[ra_add]#</b> klikt, worden de gegevens verzonden om een nieuwe map te maken. Als u <b>#pgv_lang[ra_reset]#</b> klikt, worden alle wijzigingen in het beschrijvingsveld genegeerd.<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_edit_folder_help"]		= "<ul>~#pgv_lang[ra_Edit_folder]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Dit formulier ondersteunt het bewerken van een bestaande map, de beschrijving van het gebruik en de hiërarchie van andere mappen waarin deze map past.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;De titel vat het gebruik samen van de map die u toevoegt.</li><li><b>#pgv_lang[ra_Parent_Folder]#</b>&nbsp;&nbsp;U kunt opgeven of de map zich op het hoogste niveau (#pgv_lang[ra_No_Parent]#) bevindt of als een submap van een andere map.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Dit is de gedetailleerde beschrijving van de map die u toevoegt.</li></ul><br />De knop <b>#pgv_lang[ra_add]#</b> verzendt de informatie om een nieuwe map te maken. De knop <b>#pgv_lang[ra_reset]#</b> verwijdert alle wijzigingen in het beschrijvingsveld die zijn aangebracht sinds de laatste keer dat de map is opgeslagen. Wanneer een map leeg is, verschijnt de knop <b>#pgv_lang[ra_delete]#</b> om deze map uit de maphiërarchie te verwijderen. Anders wordt u gewaarschuwd dat verwijderen niet is toegestaan als er nog taken in aanwezig zijn.<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_auto_search_help"]		= "<ul>~#pgv_lang[ra_auto_search_text]#~<br /><br />Afhankelijk van de gekozen persoon zal deze functie automatisch verschillende vitale en feitelijke informatie uit uw genealogische database halen en u laten bepalen welke hiervan u wilt doorgeven aan de zoekmachine van een externe genealogische website. Er kunnen verschillende sites worden gekozen, waaronder Ancestry, FamilySearch, Findagrave en meer. De resultaten van deze zoekopdrachten kunnen worden gebruikt om informatie toe te voegen of bij te werken in uw genealogische database.<br /><br />Wanneer u zich in de sectie «#pgv_lang[ra_RA_name]#» van de pagina «#pgv_lang[personal_facts]#» van een persoon bevindt, wordt de zoekopdracht gebaseerd op die persoon. Als u deze start vanuit de hoofdmenu's van #pgv_lang[ra_RA_name]#, moet u eerst een persoon kiezen door op het persoonspictogram te klikken om een persoon te selecteren of door de identificatienummer van de persoon in het veld in te voeren.<br /><br />Kies uit de lijst de naam van de genealogische site die u wilt raadplegen. U krijgt een lijst met informatie te zien die u kunt selecteren. Geef met vinkjes naast elk item (naam, geboorte- of sterfdatum, enz.) de items aan die worden doorgegeven aan de gekozen zoekmachine nadat op de knop <b>#pgv_lang[ra_autosearch_search]#</b> is geklikt. De zoekmachine van de externe website wordt op een nieuwe pagina gestart. Gebruik de beheerfunctie #pgv_lang[ra_task_list]# om aanvullende bevindingen voor follow-up te identificeren.<br /><br />Houd er rekening mee dat zoekmachines voortdurend evolueren. Wanneer u zich op een genealogiesite bevindt, bieden de ingebouwde functies mogelijk meer zoekcriteria die u kunt bijwerken om uw onderzoek te verrijken.</ul>";
$pgv_lang["ra_ViewProb_help"]		= "<ul>~#pgv_lang[ra_analyze_database]#~<br /><br />Deze pagina analyseert de gegevens in uw genealogische database en toont de correlaties tussen verschillende data-elementen.<br /><br />Er kan bijvoorbeeld een correlatie van 95% zijn dat de achternaam in een lokaal record hetzelfde is als de achternaam in het record van de vader. Dit zou betekenen dat 95% van de mensen in deze genealogische database dezelfde achternaam heeft als hun vader. In deze versie van de #pgv_lang[ra_RA_name]# module worden deze berekeningen gebruikt om ontbrekende informatie voor de records van een persoon te identificeren. Ze worden niet gebruikt in andere delen van het programma; ze worden alleen verstrekt als hulp bij uw onderzoek.</ul>";
$pgv_lang["ra_GenerateTasks_help"]		= "<ul>~#pgv_lang[ra_gen_tasks]#~<br /><br />Sommige genealogische programma's staan u toe om onderzoekstaken in te voeren als TODO elementen in hun database. Wanneer u deze genealogische informatie naar andere programma's exporteert, exporteren ze de databaserecords naar een bestand dat is geformatteerd volgens de GEDCOM aanbeveling. De PhpGedView-software gebruikt het GEDCOM geformatteerde bestand als invoer, dus deze TODO elementen worden in uw gegevens opgenomen. Deze optie doorzoekt uw genealogische database en converteert automatisch alle geïmporteerde TODO elementen naar onderzoekstaken.<br /><br />Als u op <b>#pgv_lang[ra_generate]#</b> onder aan het formulier klikt, wordt een lijst met potentiële taken gemaakt van de geïmporteerde TODO elementen. Uit deze lijst kunt u elementen selecteren om taken te genereren.<ul><li><b>#pgv_lang[ra_generate]#</b>&nbsp;&nbsp;Markeer elke taak om te genereren en genereer vervolgens die taak.</li><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;De eerste 30 tekens van de taakbeschrijving worden de naam van de taak. U kunt dit wijzigen of corrigeren wanneer u de taak bewerkt.<li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;De beschrijving die de taak krijgt, gekopieerd uit de volledige tekst van het TODO-item in uw genealogische database. U kunt dit wijzigen of corrigeren wanneer u de taak bewerkt.</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Klik de link om de taak te bewerken.</li><li><b>#pgv_lang[ra_SelectFolder]#</b>&nbsp;&nbsp;Selecteer de map waarin u de gegenereerde taken wilt plaatsen.</li><li><b>#pgv_lang[ra_done]#</b>&nbsp;&nbsp;verwijst u door naar de pagina #pgv_lang[ra_Folder_View]#.</li></ul></ul>";
$pgv_lang["ra_EditGenerateTasks_help"]	= "<ul>~#pgv_lang[ra_Edit_Gen_Task]#~<br /><br />Met dit formulier kunt u de taken bewerken die zijn gemaakt op basis van TODO elementen in uw genealogische database.<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Om de persoon te selecteren waaraan u de taak wilt koppelen.</li><li><b>#pgv_lang[ra_source]#</b>&nbsp;&nbsp;Klik op de koppeling om de bron te selecteren waaraan u de taak wilt koppelen.</li><li><b>#pgv_lang[ra_save]#</b>&nbsp;&nbsp;Hiermee slaat u al uw wijzigingen op en wordt u doorgestuurd naar de pagina #pgv_lang[ra_gen_tasks]#.</li><li><b>#pgv_lang[ra_cancel]#</b>&nbsp;&nbsp;Hiermee verwijdert u al uw wijzigingen en wordt u doorgestuurd naar de pagina #pgv_lang[ra_gen_tasks]#.</li></ul></ul>";
$pgv_lang["ra_configure_privacy_help"]		= "<ul>~#pgv_lang[ra_configure_privacy]#~<br /><br />Als beheerder van uw PhpGedView-site hebt u de mogelijkheid om de zichtbaarheid van verschillende functionaliteiten van de #pgv_lang[ra_RA_name]# module te beheren. Deze dialoog presenteert de beschikbare functionele blokken en vraagt u om de zichtbaarheid te selecteren door toegangscontroles voor elk blok te kiezen.<ul><li><b>#pgv_lang[PRIV_PUBLIC]#</b>&nbsp;&nbsp;Het opgegeven functionele blok is voor iedereen beschikbaar.</li><li><b>#pgv_lang[PRIV_USER]#</b>&nbsp;&nbsp;Het opgegeven functionele blok is alleen beschikbaar voor geverifieerde gebruikers.</li><li><b>#pgv_lang[PRIV_NONE]#</b>&nbsp;&nbsp;Het opgegeven functionele blok is alleen beschikbaar voor gebruikers met beheerdersrechten.</li><li><b>#pgv_lang[PRIV_HIDE]#</b>&nbsp;&nbsp;Het opgegeven functionele blok is voor niemand beschikbaar.</li></ul></ul>";
?>
