<?php
/**
 * Portuguese language Help file for PhpGedView Research Assistant module
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Research_Assistant
 * @version $Id: help_text.pt.php 7377 2024-10-18 13:50:13Z canajun2eh $
 *
 * The companion file to this is lang.pt.php, which contains most of the brief texts.
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

//-- Miscellaneous advisories and instructions
$pgv_lang["ra_auto_gen_inst"]		= "Alguns programas permitem-lhe introduzir tarefas de pesquisa como itens TODO na sua base de dados genealógica. Esta opção irá pesquisar a sua base de dados genealógica e converter automaticamente cada item TODO numa tarefa de pesquisa.";
$pgv_lang["ra_mytasks_block_descr"]		= "O bloco «#pgv_lang[ra_my_tasks]#» mostra as tarefas ao utilizador atual. Pode ser configurado para mostrar tarefas concluídas ou tarefas que não estão atualmente atribuídas.";

//-- RA HELP MESSAGES
// - Variables with *_help are the actual help texts. *_words are useful text blocks that can be used multiple times in different help texts 

$pgv_lang["ra_organizetasks_words"]		= "~Como organizar tarefas~<br /><br />As tarefas estão organizadas em pastas. Pelo menos uma pasta deve existir antes de qualquer tarefa poder ser criada.<br /><br />Pode criar e organizar as suas pastas como desejar. Provavelmente, irá querer organizar as suas pastas online da mesma forma que organiza cópias impressas da sua pesquisa. Muitos investigadores organizam as suas pastas por linhagem familiar, apelido ou localização geográfica.";
$pgv_lang["ra_whataretasks_words"]		= "~O que são tarefas?~<br /><br />O módulo #pgv_lang[ra_RA_name]# está centrado na tarefa de pesquisa. Uma tarefa de pesquisa é semelhante a um item TODO e acompanha uma tarefa específica de pesquisa genealógica que precisa de ser realizada. Um exemplo de um título de tarefa pode ser «Encontrar o registo de nascimento de Joe», enquanto os detalhes na descrição indicariam «Encontrar o registo de nascimento de Joe nos registos de nascimento do condado de Ottawa».<br /><br />As tarefas podem ser atribuídas a utilizadores específicos. Ao atribuir tarefas aos utilizadores, todos sabem em que pesquisa devem trabalhar e quem está a trabalhar noutras tarefas de pesquisa.<br /><br />As tarefas podem também incluir ações contra o material de origem ou relacionadas com uma ou mais pessoas em os seus dados. Com o módulo #pgv_lang[ra_RA_name]# instalado, verá uma secção «#pgv_lang[ra_RA_name]#» em cada página «#pgv_lang[personal_facts]#» e também uma secção Tarefas em cada página de dados de origem.<br /><br />As tarefas são criadas no estado <b>#pgv_lang[ra_incomplete]#</b>, indicando que o trabalho sobre as mesmas está em curso. Todas as tarefas devem ser atribuídas a um utilizador que possa editar e atualizar os registos com as descobertas. Depois de todo o trabalho estar concluído, a tarefa deverá ser enviada como <b>#pgv_lang[ra_complete]#</b>. Isto irá removê-lo das listas de tarefas ativamente visíveis (ou seja, #pgv_lang[ra_incomplete]#). Ao utilizar o menu «#pgv_lang[ra_my_tasks]#», cada utilizador pode ver as tarefas atribuídas, tanto #pgv_lang[ra_incomplete]# como #pgv_lang[ra_complete]#.<br /><br />Cada tarefa tem uma secção de comentários onde podem ocorrer discussões sobre os dados e pesquisas ou possíveis resultados. Isto permite que a tarefa permaneça orientada para os objetivos enquanto os comentários são orientados para o progresso e para os resultados.";
$pgv_lang["ra_sortcol_words"]		= "Esta coluna pode ser ordenada clicando no cabeçalho da coluna.";
$pgv_lang["ra_folder_words"]			= "As pastas são uma ferramenta de gestão de tarefas que permite agrupar tarefas. As pastas podem estar contidas noutras pastas. Se existir uma pasta pai, esta será apresentada no lado esquerdo dos menus acima. Se esta área estiver em branco, estas pastas estarão no nível mais elevado.";
$pgv_lang["ra_view_task_words"]		= "As tarefas são formas de gerir tarefas ou ações de pesquisa para acompanhamento. A tarefa é resumida pelo seu título, enquanto o campo de descrição define mais detalhes sobre o que é necessário. Por vezes, o acompanhamento da resolução também pode ser incluído no campo de descrição. Abaixo da tabela «#pgv_lang[ra_Task_View]#» existe uma tabela «#pgv_lang[ra_comments]#» que pode ser utilizada para monitorizar o progresso e descrever as resoluções das tarefas.";
$pgv_lang["ra_special_char_words"]		= "Ocasionalmente, o seu texto pode necessitar de mostrar símbolos que tenham significados especiais para o browser ou para o PhpGedView, para além de ser texto comum. Quando tais símbolos devem ocorrer no seu texto, precisa de os inserir num formato que indique que são textos sem significado especial.<ul><li><b>&amp;</b>&nbsp;&nbsp;Este símbolo sinaliza o início de uma entidade HTML. Para indicar que este símbolo é um texto comum, pode garantir que é sempre seguido por um espaço ou inseri-lo no seu formato de entidade HTML <b>&amp;amp;</b></li><li><b>&#35;</b>&nbsp;&nbsp;Este símbolo é utilizado no sistema de Ajuda do PhpGedView. Para indicar que este símbolo é um texto comum, pode garantir que é sempre seguido de um espaço ou inseri-lo na sua forma numérica <b>&amp;&#35;35;</b></li><li ><b>&#126;</b>&nbsp;&nbsp;Este símbolo é utilizado no sistema de Ajuda do PhpGedView. Para indicar que este símbolo é um texto comum, pode garantir que é sempre seguido de um espaço ou inseri-lo na sua forma numérica <b>&amp;&#35;126;</b></li><li><b>&#92;</b>&nbsp;&nbsp;Este símbolo é interpretado pelo browser como significando que o símbolo seguinte é texto. Para indicar que este símbolo é um texto comum, deve introduzir dois deles <b>&#92;&#92;</b> ou pode introduzi-lo na sua forma numérica <b>&amp;&#35;92; </b></li><li><b>&lt;</b>&nbsp;&nbsp;Este símbolo é interpretado pelo browser para indicar o início de uma etiqueta HTML. Para indicar que este símbolo é um texto comum, deve inseri-lo no seu formato de entidade HTML <b>&amp;lt;</b></li><li><b>&gt;</b> Este O símbolo é interpretado pelo browser para indicar o fim de uma etiqueta HTML. Para indicar que este símbolo é um texto comum, deve inseri-lo no seu formulário HTML Entity <b>&amp;gt;</b></li></ul>Pode criar listas de itens numa descrição. Se pretender criar listas numeradas ou com marcadores, comece a inserir estes itens da lista com <b>&lt;ul&gt;</b> para obter uma lista com marcadores ou <b>&lt;ol&gt;</b> para uma lista numerada.<br /><br />Cada item da lista deve começar por <b>&lt;li&gt;</b> e termine com <b>&lt;/li&gt;</b>. O último item da lista deve ser terminado como todos os outros e deve ser seguido de <b>&lt;/ul&gt;</b> para fechar a lista com marcadores ou <b>&lt;/ol&gt;</b> para fechar a lista numerada.<br /><br />As notas anteriores sobre como inserir os símbolos «Menos que» <b>&lt;</b> e «Superior a» <b>&gt;</b>, que geralmente incluem tags HTML, pois o texto não se aplica, pois neste caso é realmente necessário inserir tags HTML.";
$pgv_lang["ra_add_task_words"]		= "Antes de qualquer tarefa poder ser criada, <u>deve</u> ter estabelecido uma pasta para conter essa tarefa.<br /><br />As tarefas são formas de gerir tarefas de pesquisa ou ações para acompanhamento. Estas tarefas são resumidas pelos seus títulos e utilizam os campos de descrição para definir com mais detalhe o que é necessário. As tarefas podem também ter algum material de origem a ser pesquisado para que possa ser anexado, e se houver uma ou mais pessoas a quem esta tarefa está associada, também terão de ser anexadas a esta nova tarefa.";


$pgv_lang["ra_mytasks_help"]			= "<ul>~#pgv_lang[ra_my_tasks]#~<br /><br />A lista «#pgv_lang[ra_my_tasks]#» mostra as tarefas de pesquisa para o utilizador atual. Por predefinição, a lista de tarefas mostra as tarefas abertas ou incompletas para o utilizador atual. Isto pode ser configurado para mostrar adicionalmente as tarefas concluídas e as tarefas que não estão atualmente atribuídas. A tabela resultante pode então ser utilizada para examinar rapidamente as tarefas de pesquisa a gerir.<ul><li>Ao clicar em <b>#pgv_lang[ra_title]#</b> será direcionado para «#pgv_lang[ra_Task_View]#» para obter mais detalhes sobre a tarefa específica.</li><li>#pgv_lang[ra_Start_Date]# indica quando a tarefa foi originalmente criada.</li><li>Ao clicar em <b>#pgv_lang[ra_edit]#</b> no final da linha de cada tarefa, será levado para a vista «#pgv_lang[ra_edit_task]#» dessa tarefa específica para a atualizar ou completar.</li></ul></ul>";
$pgv_lang["ra_missing_info_help"]		= "<ul>~#pgv_lang[ra_missing_info]#~<br /><br />Esta área mostra possíveis informações em falta sobre o registo de uma pessoa. Por exemplo, isto pode incluir a falta de uma fonte de nascimento ou o facto de a pessoa estar viva durante um conflito militar, mas não ter uma entrada militar. O #pgv_lang[ra_RA_name]# inspecionará o registo da base de dados genealógica da pessoa em busca de possíveis informações em falta e produzirá uma lista de possíveis tarefas de acompanhamento que podem ser criadas.<br /><br />Antes de qualquer tarefa em falta possa ser criada, <u>deve</u> ter estabelecido uma pasta para conter as tarefas.<br /><br />A tabela apresenta uma lista de possíveis novas tarefas que podem ser criadas ou geradas anteriormente tarefas para visualizar.<ul><li>Para criar uma tarefa para rastrear algumas informações em falta, marque a caixa de seleção junto da mesma. Quando todas as tarefas pretendidas tiverem sido selecionadas e tiver sido escolhida uma pasta para agrupar estas novas tarefas, clique em <b>#pgv_lang[ra_AddTask]#</b> para criar tarefas para os itens em falta.</li><li>As tarefas existentes mostrarão <b>#pgv_lang[ra_view]#</b> em vez de uma caixa de selecção que, quando clicada, o levará directamente para visualizar essa tarefa.</li></ul>#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_person_task_list_help"]		= "<ul>~#pgv_lang[ra_task_list]#~<br /><br />A tabela apresentada é uma lista de tarefas de pesquisa associadas ao registo dessa pessoa. Apenas as tarefas não marcadas como concluídas são mostradas. Podem ter sido criados manualmente ou gerados usando a tabela «#pgv_lang[ra_missing_info]#», mas cada tarefa tem essa pessoa associada.<br /><br />Clique no título da tarefa para ver mais detalhes sobre a mesma.</br>Clique no botão <b>#pgv_lang[ra_task_entry]#</b> na parte inferior da tabela para criar manualmente uma nova tarefa ligada ao registo desta pessoa.<br /><br />#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_sources_task_list_help"]		= "<ul>~#pgv_lang[ra_task_list]#~<br /><br />Esta é uma lista de todas as tarefas associadas a esta fonte. Apenas as tarefas não marcadas como concluídas são mostradas. A mensagem «#pgv_lang[ra_no_sour_tasks]#» aparecerá quando nenhuma tarefa tiver esta fonte ligada. Quando existe uma tarefa associada, clique no título da tarefa para abrir a página «#pgv_lang[ra_view_task]#» para obter mais detalhes sobre a mesma.<br /><br /><b>Nota</b>: Não podem ser criadas novas tarefas na entrada «#pgv_lang[ra_source]#». Utilize a função <b>#pgv_lang[ra_AddTask]#</b> se necessário especificamente para uma fonte que não esteja ligada a uma pessoa.<br /><br />#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_view_tasklist_help"]		= "<ul>~#pgv_lang[ra_Task_View]#~<br /><br />#pgv_lang[ra_view_task_words]#<br /><br />Esta tabela é uma lista de tarefas. As colunas incluem:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Um título resumido para a tarefa. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Esta é uma descrição detalhada da tarefa necessária para a pesquisa ou ações de acompanhamento. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_Start_Date]#</b>&nbsp;&nbsp;Esta é a data de criação da tarefa. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_completed]#</b>&nbsp;&nbsp;Isto indica se uma tarefa foi concluída ou não. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_assigned]#</b>&nbsp;&nbsp;Esta entrada indica quem é o proprietário de uma tarefa de pesquisa. This column is not shown in the «#pgv_lang[ra_my_tasks]#» view as you are the owner of all these tasks.</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;If you are the owner of this task or have administration rights, this entry contains a <u>link</u> which will take you to edit the task, otherwise it will be blank.</li><li><b>#pgv_lang[ra_delete]#</b>&nbsp;&nbsp;If you are the owner of this task or have administration rights, this entry contains a <u>link</u> which will take you to delete the task, otherwise it will be em branco.</li><li><b>#pgv_lang[ra_complete]#</b>&nbsp;&nbsp;Se for o proprietário desta tarefa ou tiver direitos de administração, esta entrada contém um <u>link</u> que o levará a fechar imediatamente uma tarefa se esta não estiver concluída, caso contrário este campo ficará em branco. Esta coluna só será mostrada na vista «#pgv_lang[ra_my_tasks]#» pois é o proprietário de todas estas tarefas.</li></ul>#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_task_view_help"]		= "<ul>~#pgv_lang[ra_view_task]#~<br /><br />#pgv_lang[ra_view_task_words]#<br /><br />Esta tabela resume uma tarefa específica. <ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Este é o título da tarefa.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;Esta é a pasta na qual a tarefa está agrupada.</li><li><b>#pgv_lang[ra_assigned]#</b>&nbsp;&nbsp;Este é o investigador ao qual a tarefa está atualmente atribuída.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Esta é a descrição detalhada da tarefa necessária para a pesquisa ou ações de acompanhamento.</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Quaisquer fontes necessárias para pesquisas ou ações de acompanhamento da tarefa.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Esta é uma lista de pessoas da árvore genealógica que estão associadas à tarefa este campo pode conter diversas entradas. Apenas as pessoas na árvore genealógica são mostradas.</li></ul><br />Se for o proprietário designado da tarefa ou tiver direitos de administração, será apresentado um botão e poderá clicar em <b>#pgv_lang[ra_edit_task]#</b> para editar os detalhes da tarefa.</ul>";
$pgv_lang["ra_add_task_help"]		= "<ul>~#pgv_lang[ra_add_new_task]#~<br /><br />#pgv_lang[ra_add_task_words]#<br /><br />Os campos do formulário incluem:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Este deve conter um breve resumo, normalmente com menos de 30 caracteres, da tarefa que está a adicionar.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;Selecione a pasta na qual pretende gerir a sua nova tarefa. Apenas as pastas existentes são mostradas. Se pretender atribuir esta nova tarefa a uma nova pasta, deve primeiro utilizar a função <b>#pgv_lang[ra_add_folder]#</b> do menu principal #pgv_lang[ra_RA_name]#.</li><li><b>#pgv_lang[ra_assign_task]#</b>&nbsp;&nbsp;Selecione na lista de utilizadores com permissões de edição alguém que possa possuir ou atualizar a tarefa e quaisquer registos a ela associados. Em geral, este campo nunca deve ficar em branco (#pgv_lang[ra_mytasks_unassigned]#).</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Introduza uma descrição detalhada da tarefa que pretende adicionar.<br /><br />#pgv_lang[ra_special_char_words]#</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;todas as fontes que tiver para a tarefa. Este campo pode conter diversas entradas.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Selecione todas as pessoas associadas a esta tarefa. Este campo pode conter múltiplas entradas, mas apenas as pessoas da sua base de dados genealógica podem ser selecionadas e mostradas neste campo.</li></ul><br />Ao criar uma nova tarefa, esta pode ser guardada clicando no botão <b>Botão#pgv_lang[ra_submit]#</b>, que o manterá aberto e no estado #pgv_lang[ra_incomplete]# para futuras atualizações. A tarefa pode ser guardada e marcada como #pgv_lang[ra_complete]# ao mesmo tempo, clicando no botão <b>#pgv_lang[ra_save_and_complete]#</b>.</ul>";
$pgv_lang["ra_edit_task_help"]		= "<ul>~#pgv_lang[ra_edit_task]#~<br /><br />#pgv_lang[ra_add_task_words]#<br /><br />Os campos do formulário incluem:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Deve conter o título ou resumo da tarefa que está a editar.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;Neste campo pode selecionar a pasta na qual pretende gerir a sua nova tarefa.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Introduza uma descrição detalhada da tarefa que pretende adicionar.<br /><br />#pgv_lang[ra_special_char_words]#</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Anexe todas as fontes que tiver para a tarefa. Este campo pode conter várias entradas.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Selecione todas as pessoas associadas a esta tarefa. Este campo pode conter múltiplas entradas, mas apenas as pessoas podem ser selecionadas da sua base de dados genealógica e mostradas neste campo.</li></ul><br />Após modificar uma tarefa existente, esta pode ser enviada para futuras atualizações clicando no botão <b>#pgv_lang[ra_save]#</b>. A tarefa também pode ser guardada e marcada como #pgv_lang[ra_completed]# (não é esperada nenhuma atualização futura), clicando no botão <b>#pgv_lang[ra_save_and_complete]#</b>.</ul>";
$pgv_lang["ra_comments_help"]		= "<ul>~#pgv_lang[ra_comments]#~<br /><br />Conterá quaisquer comentários relacionados com uma tarefa de pesquisa.<br /><br />Quando estiver na secção «#pgv_lang[ra_RA_name]#» de uma pessoa, esses comentários serão ligados ao registo específico dessa pessoa e apenas visíveis aqui. Se for apresentado um comentário abaixo de uma tarefa, esse comentário será específico dessa tarefa. Em cada caso, podem existir vários comentários independentes. Cada um pode ser editado ou eliminado de forma independente, sendo o comentário mais recente sempre apresentado na parte superior.<br /><br />Clique em <b>#pgv_lang[ra_add_new_comment]#</b> para adicionar novos comentários a esta lista.<br /><br /><span class='warning'>Se, durante a edição de uma tarefa, adicionar um novo comentar antes de guardar a sua tarefa editada, quaisquer alterações de tarefas não guardadas serão perdidas.</span></ul>";
$pgv_lang["ra_folder_view_help"]		= "<ul>~#pgv_lang[ra_Folder_View]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Esta é uma lista de pastas e descrições da sua utilização. <ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;Esta coluna contém os nomes de todas as pastas deste nível que criou. Ao selecionar o nome da pasta, será direcionado para um novo ecrã mostrando todas as subpastas e todas as tarefas associadas a esta pasta. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Esta coluna contém uma descrição mais detalhada da utilização destas pastas. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Esta coluna possui um <u>link</u> para permitir a edição do nome, descrição ou hierarquia da pasta.</li></ul><br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_add_folder_help"]		= "<ul>~#pgv_lang[ra_Add_folder]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Este formulário suporta a criação de uma nova pasta, a sua descrição de utilização e a hierarquia de outras pastas nas quais esta pasta se insere. <ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;O título resume a utilização da pasta que está a adicionar.</li><li><b>#pgv_lang[ra_Parent_Folder]#</b>&nbsp;&nbsp;Pode especificar se a pasta está no nível mais alto ou raiz (#pgv_lang[ra_No_Parent]#) ou como uma subpasta de outra pasta.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Esta é a descrição detalhada da pasta que está a adicionar.</li></ul>Clicar no botão <b>#pgv_lang[ra_add]#</b> enviará a informação para criar uma nova pasta. Clicar no botão <b>#pgv_lang[ra_reset]#</b> irá descartar quaisquer alterações no campo de descrição.<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_edit_folder_help"]		= "<ul>~#pgv_lang[ra_Edit_folder]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Este formulário suporta a edição de uma pasta existente, a sua descrição de utilização e a hierarquia de outras pastas nas quais esta pasta se insere. <ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;O title resume a utilização da pasta que está a adicionar.</li><li><b>#pgv_lang[ra_Parent_Folder]#</b>&nbsp;&nbsp;Pode especificar se a pasta está no nível mais elevado (#pgv_lang[ra_No_Parent]#) ou como uma subpasta de outra pasta.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Esta é a descrição detalhada da pasta que está a adicionar.</li></ul><br />O botão <b>#pgv_lang[ra_add]#</b> enviará a informação para criar uma nova pasta. O botão <b>#pgv_lang[ra_reset]#</b> irá descartar quaisquer alterações no campo de descrição efetuadas desde o último guardar. Quando uma pasta estiver vazia, irá aparecer o botão <b>#pgv_lang[ra_delete]#</b> para permitir a remoção desta pasta da hierarquia de pastas, caso contrário será avisado que a eliminação não é permitida com tarefas ainda presentes na mesma.<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_auto_search_help"]		= "<ul>~#pgv_lang[ra_auto_search_text]#~<br /><br />Com base na pessoa escolhida, esta funcionalidade extrairá automaticamente várias informações vitais e factuais da sua base de dados genealógica e permitir-lhe-á determinar quais delas passar para um motor de busca de um site genealógico externo. Podem ser escolhidos vários sites, incluindo Ancestry, FamilySearch, Findagrave e muito mais. Os resultados destas pesquisas podem ser utilizados para adicionar ou atualizar informações na sua base de dados genealógica.<br /><br />Quando estiver na secção «#pgv_lang[ra_RA_name]#» da página «#pgv_lang[personal_facts]#» de uma pessoa, a pesquisa será baseada nessa pessoa. Se for iniciado a partir dos menus principais #pgv_lang[ra_RA_name]#, uma pessoa deve ser primeiro escolhida clicando no ícone da pessoa para selecionar uma pessoa ou introduzindo o número de identificação da pessoa no campo.<br /><br />Escolha na lista o nome do site de genealogia que pretende consultar. Verá uma lista de informações que podem ser selecionadas. Indique por meio de marcas ao lado de cada item (nome, data de nascimento ou falecimento, etc) os itens que serão repassados ao motor de busca escolhido após o botão <b>#pgv_lang[ra_autosearch_search]#</b> ter sido clicado. O motor de busca do site externo é lançado numa nova página. Utilize a funcionalidade de gestão #pgv_lang[ra_task_list]# para identificar descobertas adicionais para acompanhamento.<br /><br />Note que os motores de pesquisa estão em constante evolução, pelo que, uma vez num site de genealogia, os recursos nativos podem oferecer mais critérios de pesquisa que podem ser atualizados para enriquecer a sua pesquisa.</ul>";
$pgv_lang["ra_ViewProb_help"]		= "<ul>~#pgv_lang[ra_analyze_database]#~<br /><br />Esta página analisa os dados da sua base de dados genealógica e mostra as correlações entre diferentes elementos de dados.<br /><br />Por exemplo, pode haver uma correlação de 95% de que o apelido num registo local é igual ao apelido. Isto significaria que 95% das pessoas nesta base de dados genealógica partilham o mesmo apelido do pai. Nesta versão do módulo #pgv_lang[ra_RA_name]#, estes cálculos estão a ser utilizados para ajudar a identificar informações em falta nos registos de uma pessoa. Não são utilizados noutras áreas do programa; são fornecidos apenas como uma ajuda na sua pesquisa.</ul>";
$pgv_lang["ra_GenerateTasks_help"]		= "<ul>~#pgv_lang[ra_gen_tasks]#~<br /><br />Alguns programas genealógicos permitem inserir tarefas de pesquisa como itens TODO na sua base de dados. Ao exportar esta informação genealógica para outros programas exportarão os registos da base de dados para um ficheiro formatado de acordo com a recomendação do GEDCOM. O software PhpGedView utiliza o ficheiro formatado GEDCOM como entrada, pelo que estes itens TODO são incorporados nos seus dados. Esta opção irá pesquisar a sua base de dados genealógica e converter automaticamente todos os itens TODO importados em tarefas de pesquisa.<br /><br />Clicar no botão <b>#pgv_lang[ra_generate]#</b> na parte inferior do formulário criará uma lista de potenciais tarefas do artigos TODO importados. Nesta lista pode selecionar itens para gerar tarefas.<ul><li><b>#pgv_lang[ra_generate]#</b>&nbsp;&nbsp;Marque cada tarefa a gerar e depois gere essa tarefa.</li><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Os primeiros 30 caracteres da descrição da tarefa passarão a ser o nome da tarefa. Pode alterar ou corrigir isto ao editar a tarefa.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;A descrição que a tarefa irá receber, copiada do texto completo da tarefa o item TODO na sua base de dados genealógico. Pode alterar ou corrigir isto ao editar a tarefa.</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Clique na ligação para editar esta tarefa.</li><li><b>#pgv_lang[ra_SelectFolder]#</b>&nbsp;&nbsp;Selecione a pasta na qual colocar as tarefas geradas.</li><li><b>#pgv_lang[ra_done]#</b>&nbsp;&nbsp;redirecciona-o para a página #pgv_lang[ra_Folder_View]#.</li></ul></ul>";
$pgv_lang["ra_EditGenerateTasks_help"]	= "<ul>~#pgv_lang[ra_Edit_Gen_Task]#~<br /><br />Este formulário permite editar as tarefas que foram criadas a partir de itens TODO na sua base de dados genealógica. <ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Para selecionar a pessoa com quem se associar a tarefa.</li><li><b>#pgv_lang[ra_source]#</b>&nbsp;&nbsp;Clique na ligação para selecionar a fonte à qual pretende associar a tarefa.</li><li><b>#pgv_lang[ra_save]#</b>&nbsp;&nbsp;Guarda todas as suas alterações e redirecciona-o para a página #pgv_lang[ra_gen_tasks]#.</li><li><b>#pgv_lang[ra_cancel]#</b>&nbsp;&nbsp;Descarta todas as suas alterações e redirecciona-o para a página #pgv_lang[ra_gen_tasks]#.</li></ul></ul>";
$pgv_lang["ra_configure_privacy_help"]		= "<ul>~#pgv_lang[ra_configure_privacy]#~<br /><br />Como administrador do seu website PhpGedView, tem a capacidade de controlar a visibilidade de diferentes funcionalidades do módulo #pgv_lang[ra_RA_name]#. Esta caixa de diálogo apresenta os blocos funcionais disponíveis e solicita que selecione a visibilidade, escolhendo os controlos de acesso para cada um.<ul><li><b>#pgv_lang[PRIV_PUBLIC]#</b>&nbsp;&nbsp;O bloco funcional especificado está disponível para todos.</li><li><b>#pgv_lang[PRIV_USER]#</b>&nbsp;&nbsp;O bloco funcional especificado está apenas disponível para utilizadores autenticados.</li><li><b>#pgv_lang[PRIV_NONE]#</b>&nbsp;&nbsp;O bloco funcional especificado está apenas disponível para utilizadores com direitos de administrador.</li><li><b>#pgv_lang[PRIV_HIDE]#</b>&nbsp;&nbsp;O bloco funcional especificado não está disponível para ninguém.</li></ul></ul>";
?>
