<?php
/**
 * Danish language file for PhpGedView Research Assistant module
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Research_Assistant
 * @version $Id: lang.da.php 7377 2024-10-18 13:50:13Z canajun2eh $
 *
 * The companion file to this is help_text.da.php, which contains most of the lengthy texts.
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

// -- To avoid having references to $pgv_lang["whatever"], copy the definitions from the original PGV language files to our own
$pgv_lang["ra_view"]			= "Se";
$pgv_lang["ra_description"]			= "Beskrivelse";
$pgv_lang["ra_source"]			= "Kilde";
$pgv_lang["ra_sources"]			= "Kilde";
$pgv_lang["ra_people"]			= "Personer";
$pgv_lang["ra_comments"]			= "Kommentarer";
$pgv_lang["ra_edit"]			= "Rediger";
$pgv_lang["ra_save"]			= "Gem";
$pgv_lang["ra_cancel"]			= "Annuller";
$pgv_lang["ra_delete"]			= "Slet";
$pgv_lang["ra_no"]				= "Nej";
$pgv_lang["ra_yes"]				= "Ja";
$pgv_lang["ra_ellipsis"]			= "\xE2\x80\xA6";
$pgv_lang["ra_add"]			= "Tilføje";
$pgv_lang["ra_close_window"]		= "Luk vinduet";
$pgv_lang["ra_config_block"]			= "Tilpasse";
$pgv_lang["ra_page"]			= "Side";
$pgv_lang["ra_reset"]			= "Nulstil";
$pgv_lang["ra_title"]			= "Titel";
$pgv_lang["ra_add_media"]			= "Tilføj et nyt medieelement";
$pgv_lang["ra_choose_search_site"]		= "Vælg et søgewebsted";
$pgv_lang["ra_pid_search_for"]		= "Om hvem vil du søge på eksterne slægtsforskningssider for information?";
$pgv_lang["ra_manage_research"]		= "Administrer forskning";
$pgv_lang["ra_analyze_database"]		= "Analyser database";
$pgv_lang["ra_analyze_data"]			= "Analyser mine data";
$pgv_lang["ra_missing_info"] 			= "Manglende information";
$pgv_lang["ra_auto_search_text"]		= "Søg i eksterne webkilder";
$pgv_lang["ra_task_list"]			= "Opgaver";
$pgv_lang["ra_next"]			= "Næste";
$pgv_lang["ra_DataCorrelations"]		= "Datakorrelationer";

/*
 *		Special handling of colons that either precede text in RTL languages or follow text in LTR languages
 *		Depending on the active language, either one of the following two variables must contain that colon symbol,
 *		and the other must be empty. To use this, you should code something like
 *			$output = "{$pgv_lang['ra-colon_rtl']}{$text}{$pgv_lang['ra-colon_ltr']}";
 *		or
 *			$output = $pgv_lang["ra-colon_rtl"].$text.$pgv_lang["ra-colon_ltr"];
 */
$pgv_lang["ra_colon_rtl"]			= "";		// Use this to put that colon to the left of text in RTL languages
$pgv_lang["ra_colon_ltr"]			= ":";		// Use this to put that colon to the right of text in LTR languages

// -- MENU ITEM MESSAGES
$pgv_lang["ra_my_tasks"]			= "Mine opgaver";
$pgv_lang["ra_add_task"]			= "Tilføj opgave";
$pgv_lang["ra_view_folders"]			= "Se mapper";
$pgv_lang["ra_view_probabilities"]		= "Se sandsynligheder";
$pgv_lang["ra_up_folder"]			= "Højere";
$pgv_lang["ra_edit_folder"]			= "Tilføj eller rediger mappe";
$pgv_lang["ra_Add_folder"]			= "Tilføj mappe";
$pgv_lang["ra_Edit_folder"]			= "Rediger mappe";
$pgv_lang["ra_gen_tasks"]			= "Skabe automatisk opgaver";
$pgv_lang["ra_generate"]			= "Skabe";

// -- RA GENERAL MESSAGES
$pgv_lang["ra_RA_name"]				= "Forskningsassistent";
$pgv_lang["ra_edit_task"]			= "Rediger opgave";
$pgv_lang["ra_completed"]			= "Fuldstændig";
$pgv_lang["ra_complete"]			= "Fuldstændig";
$pgv_lang["ra_incomplete"]			= "Ufuldstændig";
$pgv_lang["ra_created"]			= "Oprettet";
$pgv_lang["ra_details"]			= "Detaljer";
$pgv_lang["ra_result"]			= "Resultatet";
$pgv_lang["ra_okay"]			= "Okay";
$pgv_lang["ra_editform"]			= "Rediger formulardata";
$pgv_lang["ra_FilterBy"]			= "Filtra per";
$pgv_lang["ra_Recalculate"]			= "Genberegn";
$pgv_lang["ra_LocalData"]			= "Lokale data";
$pgv_lang["ra_RelatedRecord"]		= "Relateret optegnelse";
$pgv_lang["ra_RelatedData"]			= "Relaterede data";
$pgv_lang["ra_Fields"]			= "Antal felter";
$pgv_lang["ra_FieldName"]			= "Feltnavn";
$pgv_lang["ra_InputType"]			= "Input type";
$pgv_lang["ra_FormBuilder"]			= "Formularbygger";
$pgv_lang["ra_FormName"]			= "Indtast formularens navn";
$pgv_lang["ra_MultiplePeople"]		= "Gælder formularen for flere personer?";
$pgv_lang["ra_FormDescription"]		= "Indtast en beskrivelse af formularen";
$pgv_lang["ra_FormGeneration"]		= "Formularoprettelse færdig!";
$pgv_lang["ra_CustomField"]			= "Brugerdefineret feltnavn";
$pgv_lang["ra_txt"]				= "Tekst";
$pgv_lang["ra_checkbox"]			= "Afkrydsningsfelt";
$pgv_lang["ra_radiobutton"]			= "Radioknap";
$pgv_lang["ra_EnterResults"]			= "Indtast resultater";
$pgv_lang["ra_generate_tasks"]		= "Opret opgaver fra TODO";
$pgv_lang["ra_SelectFolder"]			= "Vælg mappe";
$pgv_lang["ra_done"]			= "Færdig";
$pgv_lang["ra_LocalPercent"]			= "Lokal procentdel";
$pgv_lang["ra_GlobalPercent"]		= "Global procentdel";
$pgv_lang["ra_Average"]			= "Gennemsnit";
$pgv_lang["ra_NoData"]			= "Ingen data!";
$pgv_lang["ra_NotEnoughData"]		= "Ikke nok data!";
$pgv_lang["ra_IncompleteDate"]	= "Ufuldstændig dato <i>(%INF_FACT%)</i>";
$pgv_lang["ra_InferIndvBirthPlac"]		= "Der er en %PERCENT% chance for, at fødestedet er&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvDeathPlac"]		= "Der er en %PERCENT% chance for, at dødsstedet er&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvSurn"]			= "Der er en %PERCENT% chance for, at efternavnet er&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvMarriagePlace"]	= "Der er en %PERCENT% chance for, at vielsesstedet er&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvGivn"]			= "Der er en %PERCENT% chance for, at det givne navn er&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_All"]				= "Alle";
$pgv_lang["ra_More"]			= "Mere";
$pgv_lang["ra_ThereIsChance"]		= "Mulige kilder kan omfatte";
$pgv_lang["ra_TheMostLikely"]		= "Det mest sandsynlige sted for denne kilde er&nbsp;<i>%INF_FACT%</i>";

// -- RA_FOLDER MESSAGES
$pgv_lang["ra_Folder"]			= "Folder";
$pgv_lang["ra_Edit_Gen_Task"]		= "Rediger genereret opgave";
$pgv_lang["ra_Start_Date"]			= "Startdato";
$pgv_lang["ra_Folder_View"]			= "Mappevisning";
$pgv_lang["ra_Task_View"]			= "Opgavevisning";
$pgv_lang["ra_page_header"]			= $pgv_lang["ra_RA_name"]." Mapper";
$pgv_lang["ra_no_folder_name"]		= "Feltet Mappenavn skal udfyldes.";
$pgv_lang["ra_add_folder"]			= "Tilføj mappe";
$pgv_lang["ra_Folder_Name"]			= "Mappenavn";
$pgv_lang["ra_Parent_Folder"]		= "Forældremappe";
$pgv_lang["ra_No_Parent"]			= "Ingen forældremappe";
$pgv_lang["ra_Folder_names_must_be_unique"]	= "Mappenavne skal være unikke.";
$pgv_lang["ra_folder_submitted"]		= "Din mappe er blevet indsendt";
$pgv_lang["ra_folder_problem"]		= "Der har været et problem med at tilføje din mappe, prøv venligst igen";

// -- RA_TAB MISSING INFO BUTTON
$pgv_lang["ra_task_entry"]			= "Opret ny opgave";

//-- ERROR MESSAGES
$pgv_lang["ra_no_folder"]			= "Der findes ingen mappe. Opret en ny mappe først.";

//-- RA_VIEWTASK MESSAGES
$pgv_lang["ra_view_task"]			= "Se opgave";
$pgv_lang["ra_no_indi_tasks"]		= "Ingen opgaver er knyttet til denne person";
$pgv_lang["ra_no_sour_tasks"]		= "Ingen opgaver er knyttet til denne kilde";
$pgv_lang["ra_assigned"]			= "Tildelt";

//-- RA_ADDTASK MESSAGES
$pgv_lang["ra_add_new_task"]		= "Tilføj ny opgave";
$pgv_lang["ra_submit"]			= "Indsend";
$pgv_lang["ra_save_and_complete"]		= "Gem og fuldfør";
$pgv_lang["ra_assign_task"]			= "Tildel opgave";
$pgv_lang["ra_AddTask"]			= "Tilføj opgave";

//-- RA_COMMENT MESSAGES
$pgv_lang["ra_comment_body"]		= "Kommentar";
$pgv_lang["ra_add_new_comment"]		= "Tilføj ny kommentar";
$pgv_lang["ra_edit_comment"]		= "Rediger kommentar";
$pgv_lang["ra_comment_success"]		= "Din kommentar blev tilføjet.";
$pgv_lang["ra_comment_delete_check"]	= "Er du sikker på, at du vil slette denne kommentar?";

//-- RA_CONFIGURE PRIVACY MESSAGES
$pgv_lang["ra_configure_privacy"]		= "Konfigurer privatliv";
$pgv_lang["ra_show_my_tasks"]		= "Vis «Mine opgaver»";
$pgv_lang["ra_show_add_task"]		= "Vis «Tilføj opgave»";
$pgv_lang["ra_show_auto_gen_task"]		= "Vis «Auto Generer opgave»";
$pgv_lang["ra_show_view_folders"]		= "Vis «Vis mapper»";
$pgv_lang["ra_show_add_folder"]		= "Vis «Tilføj mappe»";
$pgv_lang["ra_show_add_unlinked_source"]	= "Vis «Tilføj ikke-linket kilde»";
$pgv_lang["ra_show_view_probabilities"]	= "Vis «Vis sandsynligheder»";

//-- Census Forms
$pgv_lang["ra_rows"]			= "Antal rækker";
$pgv_lang["ra_state"]			= "Staten";
$pgv_lang["ra_call/url"]			= "Katalognummer eller URL";
$pgv_lang["ra_enumDate"]			= "Optællingsdato";
$pgv_lang["ra_county"]			= "Amt";
$pgv_lang["ra_city"]			= "By";
$pgv_lang["ra_complete_title"]		= "Fuldfør en opgave";
$pgv_lang["ra_select_form"]			= "Vælg Form";
$pgv_lang["ra_choose_form_label"]		= "Vælg fælles forskningsform";
$pgv_lang["ra_book"]			= "Bog";
$pgv_lang["ra_folio"]			= "Folio";
$pgv_lang["ra_uk_county"]			= "Amt";
$pgv_lang["ra_uk_boro"]			= "By eller bydel";
$pgv_lang["ra_uk_place"]			= "Placere";

$pgv_lang["ra_AssIndiFacts"]			= "Tilknyt Personfakta";
$pgv_lang["ra_AssFamFacts"]			= "Tilknyt Familiefakta";
$pgv_lang["ra_facts"]			= "Fakta";
$pgv_lang["ra_fact"]			= "Faktum";
$pgv_lang["ra_remove"]			= "fjerne";
$pgv_lang["ra_inferred_facts"]		= "Udledte fakta";
$pgv_lang["ra_person"]			= "Person";
$pgv_lang["ra_reason"]			= "Årsag";
$pgv_lang["ra_success"]			= "Succes!";

$pgv_lang["ra_registration_number"]		= "Registreringsnummer";
$pgv_lang["ra_serial_number"]		= "Serienummer";
$pgv_lang["ra_number"]			= "Nummer";
$pgv_lang["ra_order_number"]		= "Ordrenummer";

//-- MY TASK BLOCK
$pgv_lang["ra_mytasks_block"]		= $pgv_lang["ra_RA_name"];
$pgv_lang["ra_mytasks_edit"]			= "Redigere";
$pgv_lang["ra_mytasks_unassigned"]		= "Ikke tildelt";
$pgv_lang["ra_mytask_show_tasks"]		= "Vis ikke-tildelte opgaver?";
$pgv_lang["ra_mytask_show_completed"]	= "Vis udførte opgaver?";

//-- Auto Search Assistant 
$pgv_lang["ra_autosearch_surname"]		= "Efternavn";
$pgv_lang["ra_autosearch_givenname"]		= "Fornavne";
$pgv_lang["ra_autosearch_fullname"]		= "Navn";
$pgv_lang["ra_autosearch_firstname"]		= "Fornavn";
$pgv_lang["ra_autosearch_middlename"]	= "Mellemnavne";
$pgv_lang["ra_autosearch_byear"]		= "Fødselsår";
$pgv_lang["ra_autosearch_bloc"]		= "Fødested";
$pgv_lang["ra_autosearch_myear"]		= "Ægteskabs år";
$pgv_lang["ra_autosearch_mloc"]		= "Ægteskabssted";
$pgv_lang["ra_autosearch_dyear"]		= "Dødsår";
$pgv_lang["ra_autosearch_dloc"]		= "Dødssted";
$pgv_lang["ra_autosearch_gender"]		= "Køn";
$pgv_lang["ra_autosearch_ssurname"]		= "Ægtefælles efternavn";
$pgv_lang["ra_autosearch_sgivennames"]	= "Ægtefællens fornavne";
$pgv_lang["ra_autosearch_sfullname"]		= "Ægtefælles navn";
$pgv_lang["ra_autosearch_fsurname"]		= "Fars efternavn";
$pgv_lang["ra_autosearch_fgivennames"]	= "Fars fornavne";
$pgv_lang["ra_autosearch_ffullname"]		= "Fars navn";
$pgv_lang["ra_autosearch_msurname"]		= "Mors efternavn";
$pgv_lang["ra_autosearch_mgivennames"]	= "Mors fornavne";
$pgv_lang["ra_autosearch_mfullname"]		= "Mors navn";
$pgv_lang["ra_autosearch_country"]		= "Land";
$pgv_lang["ra_autosearch_cemetery"]		= "Kirkegård";
$pgv_lang["ra_autosearch_plugin_name"]	= "";
$pgv_lang["ra_autosearch_plugin"]		= "#pgv_lang[ra_autosearch_plugin_name]# Plug-in";
$pgv_lang["ra_autosearch_search"]		= "Søge";
$pgv_lang["ra_autosearch_keywords"]		= "Nøgleord";

//Folder deletion error messages
$pgv_lang["ra_has_tasks"]			= "Mappen indeholder opgaver og kan ikke slettes";
$pgv_lang["ra_has_folders"]			= "Mappen indeholder mapper og kan ikke slettes";
?>
