<?php
/**
 * Spanish language file for PhpGedView Research Assistant module
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Research_Assistant
 * @version $Id: lang.es.php 7377 2024-10-18 13:50:13Z canajun2eh $
 *
 * The companion file to this is help_text.es.php, which contains most of the lengthy texts.
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

// -- To avoid having references to $pgv_lang["whatever"], copy the definitions from the original PGV language files to our own
$pgv_lang["ra_view"]			= "Ver";
$pgv_lang["ra_description"]			= "Descripción";
$pgv_lang["ra_source"]			= "Fuente";
$pgv_lang["ra_sources"]			= "Fuentes";
$pgv_lang["ra_people"]			= "Personas";
$pgv_lang["ra_comments"]			= "Comentarios";
$pgv_lang["ra_edit"]			= "Editar";
$pgv_lang["ra_save"]			= "Guardar";
$pgv_lang["ra_cancel"]			= "Cancelar";
$pgv_lang["ra_delete"]			= "Eliminar";
$pgv_lang["ra_no"]				= "No";
$pgv_lang["ra_yes"]				= "Sí";
$pgv_lang["ra_ellipsis"]			= "\xE2\x80\xA6";
$pgv_lang["ra_add"]			= "Agregar";
$pgv_lang["ra_close_window"]		= "Cerrar ventana";
$pgv_lang["ra_config_block"]			= "Personalizar";
$pgv_lang["ra_page"]			= "Página";
$pgv_lang["ra_reset"]			= "Restablecer";
$pgv_lang["ra_title"]			= "Título";
$pgv_lang["ra_add_media"]			= "Agregar un nuevo elemento multimedia";
$pgv_lang["ra_choose_search_site"]		= "Elija un sitio de búsqueda";
$pgv_lang["ra_pid_search_for"]		= "¿Acerca de quién desea buscar información en sitios externos de genealogía?";
$pgv_lang["ra_manage_research"]		= "Gestionar la investigación";
$pgv_lang["ra_analyze_database"]		= "Analizar base de datos";
$pgv_lang["ra_analyze_data"]			= "Analizar mis datos";
$pgv_lang["ra_missing_info"] 			= "Información faltante";
$pgv_lang["ra_auto_search_text"]		= "Búsqueda en fuentes web externas";
$pgv_lang["ra_task_list"]			= "Tareas";
$pgv_lang["ra_next"]			= "Siguiente";
$pgv_lang["ra_DataCorrelations"]		= "Correlaciones de datos";

/*
 *		Special handling of colons that either precede text in RTL languages or follow text in LTR languages
 *		Depending on the active language, either one of the following two variables must contain that colon symbol,
 *		and the other must be empty. To use this, you should code something like
 *			$output = "{$pgv_lang['ra-colon_rtl']}{$text}{$pgv_lang['ra-colon_ltr']}";
 *		or
 *			$output = $pgv_lang["ra-colon_rtl"].$text.$pgv_lang["ra-colon_ltr"];
 */
$pgv_lang["ra_colon_rtl"]			= "";		// Use this to put that colon to the left of text in RTL languages
$pgv_lang["ra_colon_ltr"]			= ":";		// Use this to put that colon to the right of text in LTR languages

// -- MENU ITEM MESSAGES
$pgv_lang["ra_my_tasks"]			= "Mis tareas";
$pgv_lang["ra_add_task"]			= "Agregar tarea";
$pgv_lang["ra_view_folders"]			= "Ver carpetas";
$pgv_lang["ra_view_probabilities"]		= "Ver probabilidades";
$pgv_lang["ra_up_folder"]			= "Más alto";
$pgv_lang["ra_edit_folder"]			= "Agregar o editar carpeta";
$pgv_lang["ra_Add_folder"]			= "Agregar carpeta";
$pgv_lang["ra_Edit_folder"]			= "Editar carpeta";
$pgv_lang["ra_gen_tasks"]			= "Crear tareas automáticamente";
$pgv_lang["ra_generate"]			= "Crear";

// -- RA GENERAL MESSAGES
$pgv_lang["ra_RA_name"]				= "Asistente de Investigación";
$pgv_lang["ra_edit_task"]			= "Editar tarea";
$pgv_lang["ra_completed"]			= "Completa";
$pgv_lang["ra_complete"]			= "Completa";
$pgv_lang["ra_incomplete"]			= "Incompleta";
$pgv_lang["ra_created"]			= "Creada";
$pgv_lang["ra_details"]			= "Detalles";
$pgv_lang["ra_result"]			= "Resultado";
$pgv_lang["ra_okay"]			= "Bueno";
$pgv_lang["ra_editform"]			= "Editar datos del formulario";
$pgv_lang["ra_FilterBy"]			= "Filtrar por";
$pgv_lang["ra_Recalculate"]			= "Recalcular";
$pgv_lang["ra_LocalData"]			= "Datos locales";
$pgv_lang["ra_RelatedRecord"]		= "Registro relacionado";
$pgv_lang["ra_RelatedData"]			= "Datos relacionados";
$pgv_lang["ra_Fields"]			= "Número de campos";
$pgv_lang["ra_FieldName"]			= "Nombre del campo";
$pgv_lang["ra_InputType"]			= "Tipo de entrada";
$pgv_lang["ra_FormBuilder"]			= "Constructor de formularios";
$pgv_lang["ra_FormName"]			= "Introduzca el nombre del formulario";
$pgv_lang["ra_MultiplePeople"]		= "¿El formulario se aplica a varias personas?";
$pgv_lang["ra_FormDescription"]		= "Introduzca una descripción del formulario";
$pgv_lang["ra_FormGeneration"]		= "Creación de formulario completa!";
$pgv_lang["ra_CustomField"]			= "Nombre de campo personalizado";
$pgv_lang["ra_txt"]				= "Texto";
$pgv_lang["ra_checkbox"]			= "Casilla";
$pgv_lang["ra_radiobutton"]			= "Botón de radio";
$pgv_lang["ra_EnterResults"]			= "Introducir resultados";
$pgv_lang["ra_generate_tasks"]		= "Crear tareas desde TODO";
$pgv_lang["ra_SelectFolder"]			= "Seleccionar carpeta";
$pgv_lang["ra_done"]			= "Hecho";
$pgv_lang["ra_LocalPercent"]			= "Porcentaje local";
$pgv_lang["ra_GlobalPercent"]		= "Porcentaje global";
$pgv_lang["ra_Average"]			= "Promedio";
$pgv_lang["ra_NoData"]			= "¡Sin datos!";
$pgv_lang["ra_NotEnoughData"]		= "¡No hay suficientes datos!";
$pgv_lang["ra_IncompleteDate"]	= "Fecha incompleta <i>(%INF_FACT%)</i>";
$pgv_lang["ra_InferIndvBirthPlac"]		= "Hay un %PERCENT% de posibilidades de que el lugar de nacimiento sea&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvDeathPlac"]		= "Hay un %PERCENT% de posibilidades de que el lugar de la muerte sea&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvSurn"]			= "Hay un %PERCENT% de posibilidades de que el apellido sea&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvMarriagePlace"]	= "Hay un %PERCENT% de posibilidades de que el lugar del matrimonio sea&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvGivn"]			= "Hay un %PERCENT% de posibilidades de que el nombre dado sea&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_All"]				= "Toda";
$pgv_lang["ra_More"]			= "Más";
$pgv_lang["ra_ThereIsChance"]		= "Las posibles fuentes pueden incluir";
$pgv_lang["ra_TheMostLikely"]		= "El lugar más probable para esta fuente es&nbsp;<i>%INF_FACT%</i>";

// -- RA_FOLDER MESSAGES
$pgv_lang["ra_Folder"]			= "Carpeta";
$pgv_lang["ra_Edit_Gen_Task"]		= "Editar tarea generada";
$pgv_lang["ra_Start_Date"]			= "Fecha de inicio";
$pgv_lang["ra_Folder_View"]			= "Vista de carpeta";
$pgv_lang["ra_Task_View"]			= "Vista de tareas";
$pgv_lang["ra_page_header"]			= "Carpetas ".$pgv_lang["ra_RA_name"];
$pgv_lang["ra_no_folder_name"]		= "El campo de nombre de la carpeta debe completarse.";
$pgv_lang["ra_add_folder"]			= "Agregar carpeta";
$pgv_lang["ra_Folder_Name"]			= "Nombre de la carpeta";
$pgv_lang["ra_Parent_Folder"]		= "Carpeta principal";
$pgv_lang["ra_No_Parent"]			= "Sin carpeta principal";
$pgv_lang["ra_Folder_names_must_be_unique"]	= "Los nombres de las carpetas deben ser únicos.";
$pgv_lang["ra_folder_submitted"]		= "Su carpeta ha sido enviada";
$pgv_lang["ra_folder_problem"]		= "Hubo un problema al agregar su carpeta, inténtelo nuevamente";

// -- RA_TAB MISSING INFO BUTTON
$pgv_lang["ra_task_entry"]			= "Crear nueva tarea";

//-- ERROR MESSAGES
$pgv_lang["ra_no_folder"]			= "No existe ninguna carpeta. Primero crea una nueva carpeta.";

//-- RA_VIEWTASK MESSAGES
$pgv_lang["ra_view_task"]			= "Ver tarea";
$pgv_lang["ra_no_indi_tasks"]		= "No hay tareas asociadas a esta persona";
$pgv_lang["ra_no_sour_tasks"]		= "No hay tareas asociadas a esta fuente";
$pgv_lang["ra_assigned"]			= "Asignado";

//-- RA_ADDTASK MESSAGES
$pgv_lang["ra_add_new_task"]		= "Agregar nueva tarea";
$pgv_lang["ra_submit"]			= "Entregar";
$pgv_lang["ra_save_and_complete"]		= "Guardar y completar";
$pgv_lang["ra_assign_task"]			= "Asignar tarea";
$pgv_lang["ra_AddTask"]			= "Agregar tarea";

//-- RA_COMMENT MESSAGES
$pgv_lang["ra_comment_body"]		= "Comentario";
$pgv_lang["ra_add_new_comment"]		= "Añadir nuevo comentario";
$pgv_lang["ra_edit_comment"]		= "Editar comentario";
$pgv_lang["ra_comment_success"]		= "Su comentario fue añadido exitosamente.";
$pgv_lang["ra_comment_delete_check"]	= "¿Estás seguro que deseas eliminar este comentario?";

//-- RA_CONFIGURE PRIVACY MESSAGES
$pgv_lang["ra_configure_privacy"]		= "Configurar la privacidad";
$pgv_lang["ra_show_my_tasks"]		= "Mostrar «Mis tareas»";
$pgv_lang["ra_show_add_task"]		= "Mostrar «Añadir tarea»";
$pgv_lang["ra_show_auto_gen_task"]		= "Mostrar «Autogenerar tarea»";
$pgv_lang["ra_show_view_folders"]		= "Mostrar «Ver carpetas»";
$pgv_lang["ra_show_add_folder"]		= "Mostrar «Añadir carpeta»";
$pgv_lang["ra_show_add_unlinked_source"]	= "Mostrar «Añadir fuente no vinculada»";
$pgv_lang["ra_show_view_probabilities"]	= "Mostrar «Ver probabilidades»";

//-- Census Forms
$pgv_lang["ra_rows"]			= "Número de filas";
$pgv_lang["ra_state"]			= "Estado";
$pgv_lang["ra_call/url"]			= "Número de catálogo o URL";
$pgv_lang["ra_enumDate"]			= "Fecha de enumeración";
$pgv_lang["ra_county"]			= "Condado";
$pgv_lang["ra_city"]			= "Ciudad";
$pgv_lang["ra_complete_title"]		= "Completar una tarea";
$pgv_lang["ra_select_form"]			= "Elija Formulario";
$pgv_lang["ra_choose_form_label"]		= "Elija formulario de investigación conjunta";
$pgv_lang["ra_book"]			= "Libro";
$pgv_lang["ra_folio"]			= "fol";
$pgv_lang["ra_uk_county"]			= "Condado";
$pgv_lang["ra_uk_boro"]			= "Ciudad o Municipio";
$pgv_lang["ra_uk_place"]			= "Lugar";

$pgv_lang["ra_AssIndiFacts"]			= "Asocie Hechos sobre la persona";
$pgv_lang["ra_AssFamFacts"]			= "Asocie Hechos sobre la familia";
$pgv_lang["ra_facts"]			= "Hechos";
$pgv_lang["ra_fact"]			= "Hecho";
$pgv_lang["ra_remove"]			= "eliminar";
$pgv_lang["ra_inferred_facts"]		= "Hechos inferidos";
$pgv_lang["ra_person"]			= "Persona";
$pgv_lang["ra_reason"]			= "Razón";
$pgv_lang["ra_success"]			= "¡Éxito!";

$pgv_lang["ra_registration_number"]		= "Número de registro";
$pgv_lang["ra_serial_number"]		= "Número de serie";
$pgv_lang["ra_number"]			= "Número";
$pgv_lang["ra_order_number"]		= "Número de pedido";

//-- MY TASK BLOCK
$pgv_lang["ra_mytasks_block"]		= $pgv_lang["ra_RA_name"];
$pgv_lang["ra_mytasks_edit"]			= "Editar";
$pgv_lang["ra_mytasks_unassigned"]		= "No asignada";
$pgv_lang["ra_mytask_show_tasks"]		= "¿Mostrar tareas no asignadas?";
$pgv_lang["ra_mytask_show_completed"]	= "¿Mostrar tareas completadas?";

//-- Auto Search Assistant 
$pgv_lang["ra_autosearch_surname"]		= "Apellido";
$pgv_lang["ra_autosearch_givenname"]		= "Nombres dados";
$pgv_lang["ra_autosearch_fullname"]		= "Nombre";
$pgv_lang["ra_autosearch_firstname"]		= "Nombre de pila";
$pgv_lang["ra_autosearch_middlename"]	= "Segundos nombres";
$pgv_lang["ra_autosearch_byear"]		= "Año de nacimiento";
$pgv_lang["ra_autosearch_bloc"]		= "Lugar de nacimiento";
$pgv_lang["ra_autosearch_myear"]		= "Año de matrimonio";
$pgv_lang["ra_autosearch_mloc"]		= "Lugar de matrimonio";
$pgv_lang["ra_autosearch_dyear"]		= "Año de muerte";
$pgv_lang["ra_autosearch_dloc"]		= "Lugar de muerte";
$pgv_lang["ra_autosearch_gender"]		= "Género";
$pgv_lang["ra_autosearch_ssurname"]		= "Apellido del cónyuge";
$pgv_lang["ra_autosearch_sgivennames"]	= "Nombres de pila del cónyuge";
$pgv_lang["ra_autosearch_sfullname"]		= "Nombre del cónyuge";
$pgv_lang["ra_autosearch_fsurname"]		= "Apellido del padre";
$pgv_lang["ra_autosearch_fgivennames"]	= "Nombres de pila del padre";
$pgv_lang["ra_autosearch_ffullname"]		= "Nombre del padre";
$pgv_lang["ra_autosearch_msurname"]		= "Apellido de la madre";
$pgv_lang["ra_autosearch_mgivennames"]	= "Nombres de pila de la madre";
$pgv_lang["ra_autosearch_mfullname"]		= "Nombre de la madre";
$pgv_lang["ra_autosearch_country"]		= "País";
$pgv_lang["ra_autosearch_cemetery"]		= "Cementerio";
$pgv_lang["ra_autosearch_plugin_name"]	= "";
$pgv_lang["ra_autosearch_plugin"]		= "#pgv_lang[ra_autosearch_plugin_name]# Complemento";
$pgv_lang["ra_autosearch_search"]		= "Buscar";
$pgv_lang["ra_autosearch_keywords"]		= "Palabras clave";

//Folder deletion error messages
$pgv_lang["ra_has_tasks"]			= "La carpeta contiene tareas y no se puede eliminar";
$pgv_lang["ra_has_folders"]			= "La carpeta contiene carpetas y no se puede eliminar.";
?>
