<?php
/**
 * Italian language file for PhpGedView Research Assistant module
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Research_Assistant
 * @version $Id: lang.it.php 7377 2024-10-18 13:50:13Z canajun2eh $
 *
 * The companion file to this is help_text.it.php, which contains most of the lengthy texts.
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

// -- To avoid having references to $pgv_lang["whatever"], copy the definitions from the original PGV language files to our own
$pgv_lang["ra_view"]			= "Vedere";
$pgv_lang["ra_description"]			= "Descrizione";
$pgv_lang["ra_source"]			= "Fonte";
$pgv_lang["ra_sources"]			= "Fonti";
$pgv_lang["ra_people"]			= "Persone";
$pgv_lang["ra_comments"]			= "Commenti";
$pgv_lang["ra_edit"]			= "Modifica";
$pgv_lang["ra_save"]			= "Salva";
$pgv_lang["ra_cancel"]			= "Annulla";
$pgv_lang["ra_delete"]			= "Elimina";
$pgv_lang["ra_no"]				= "No";
$pgv_lang["ra_yes"]				= "Sì";
$pgv_lang["ra_ellipsis"]			= "\xE2\x80\xA6";
$pgv_lang["ra_add"]			= "Aggiungere";
$pgv_lang["ra_close_window"]		= "Chiudi finestra";
$pgv_lang["ra_config_block"]			= "Regolare";
$pgv_lang["ra_page"]			= "Pagina";
$pgv_lang["ra_reset"]			= "Ripristina";
$pgv_lang["ra_title"]			= "Titolo";
$pgv_lang["ra_add_media"]			= "Aggiungi un nuovo elemento multimediale";
$pgv_lang["ra_choose_search_site"]		= "Scegli un sito di ricerca";
$pgv_lang["ra_pid_search_for"]		= "Su chi vuoi cercare informazioni nei siti genealogici esterni?";
$pgv_lang["ra_manage_research"]		= "Gestire la ricerca";
$pgv_lang["ra_analyze_database"]		= "Analizza database";
$pgv_lang["ra_analyze_data"]			= "Analizza i miei dati";
$pgv_lang["ra_missing_info"] 			= "Informazioni mancanti";
$pgv_lang["ra_auto_search_text"]		= "Cerca in fonti Web esterne";
$pgv_lang["ra_task_list"]			= "Compiti";
$pgv_lang["ra_next"]			= "Successiva";
$pgv_lang["ra_DataCorrelations"]		= "Correlazioni dei dati";

/*
 *		Special handling of colons that either precede text in RTL languages or follow text in LTR languages
 *		Depending on the active language, either one of the following two variables must contain that colon symbol,
 *		and the other must be empty. To use this, you should code something like
 *			$output = "{$pgv_lang['ra-colon_rtl']}{$text}{$pgv_lang['ra-colon_ltr']}";
 *		or
 *			$output = $pgv_lang["ra-colon_rtl"].$text.$pgv_lang["ra-colon_ltr"];
 */
$pgv_lang["ra_colon_rtl"]			= "";		// Use this to put that colon to the left of text in RTL languages
$pgv_lang["ra_colon_ltr"]			= ":";		// Use this to put that colon to the right of text in LTR languages

// -- MENU ITEM MESSAGES
$pgv_lang["ra_my_tasks"]			= "Miei compiti";
$pgv_lang["ra_add_task"]			= "Aggiungi attività";
$pgv_lang["ra_view_folders"]			= "Visualizza cartelle";
$pgv_lang["ra_view_probabilities"]		= "Visualizza probabilità";
$pgv_lang["ra_up_folder"]			= "Più alto";
$pgv_lang["ra_edit_folder"]			= "Aggiungi o modifica cartella";
$pgv_lang["ra_Add_folder"]			= "Aggiungi cartella";
$pgv_lang["ra_Edit_folder"]			= "Modifica cartella";
$pgv_lang["ra_gen_tasks"]			= "Crea automaticamente attività";
$pgv_lang["ra_generate"]			= "Creare";

// -- RA GENERAL MESSAGES
$pgv_lang["ra_RA_name"]				= "Assistente di Ricerca";
$pgv_lang["ra_edit_task"]			= "Modifica attività";
$pgv_lang["ra_completed"]			= "Completo";
$pgv_lang["ra_complete"]			= "Completo";
$pgv_lang["ra_incomplete"]			= "Incompleto";
$pgv_lang["ra_created"]			= "Creata";
$pgv_lang["ra_details"]			= "Dettagli";
$pgv_lang["ra_result"]			= "Risultato";
$pgv_lang["ra_okay"]			= "Va bene";
$pgv_lang["ra_editform"]			= "Modifica dati modulo";
$pgv_lang["ra_FilterBy"]			= "Filtra per";
$pgv_lang["ra_Recalculate"]			= "Ricalcola";
$pgv_lang["ra_LocalData"]			= "Dati locali";
$pgv_lang["ra_RelatedRecord"]		= "Record correlati";
$pgv_lang["ra_RelatedData"]			= "Related Data";
$pgv_lang["ra_Fields"]			= "Numero di campi";
$pgv_lang["ra_FieldName"]			= "Nome del campo";
$pgv_lang["ra_InputType"]			= "Tipo di input";
$pgv_lang["ra_FormBuilder"]			= "Costruttore di moduli";
$pgv_lang["ra_FormName"]			= "Inserisci il nome del modulo";
$pgv_lang["ra_MultiplePeople"]		= "Il modulo è valido per più persone?";
$pgv_lang["ra_FormDescription"]		= "Inserisci una descrizione del modulo";
$pgv_lang["ra_FormGeneration"]		= "Creazione del modulo completata!";
$pgv_lang["ra_CustomField"]			= "Nome campo personalizzato";
$pgv_lang["ra_txt"]				= "Testo";
$pgv_lang["ra_checkbox"]			= "Casella";
$pgv_lang["ra_radiobutton"]			= "Pulsante di scelta";
$pgv_lang["ra_EnterResults"]			= "Inserisci i risultati";
$pgv_lang["ra_generate_tasks"]		= "Crea attività da TODO";
$pgv_lang["ra_SelectFolder"]			= "Scegli cartella";
$pgv_lang["ra_done"]			= "Fatto";
$pgv_lang["ra_LocalPercent"]			= "Percentuale locale";
$pgv_lang["ra_GlobalPercent"]		= "Percentuale globale";
$pgv_lang["ra_Average"]			= "Media";
$pgv_lang["ra_NoData"]			= "Nessun dato!";
$pgv_lang["ra_NotEnoughData"]		= "Dati insufficienti!";
$pgv_lang["ra_IncompleteDate"]	= "Data incompleta <i>(%INF_FACT%)</i>";
$pgv_lang["ra_InferIndvBirthPlac"]		= "C'è una probabilità del %PERCENT% che il luogo di nascita sia&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvDeathPlac"]		= "C'è una probabilità del %PERCENT% che il luogo del decesso sia&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvSurn"]			= "C'è una probabilità del %PERCENT% che il cognome sia&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvMarriagePlace"]	= "C'è una probabilità del %PERCENT% che il luogo del matrimonio sia&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvGivn"]			= "C'è una probabilità del %PERCENT% che il nome dato sia&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_All"]				= "Tutto";
$pgv_lang["ra_More"]			= "Di più";
$pgv_lang["ra_ThereIsChance"]		= "Le possibili fonti possono includere";
$pgv_lang["ra_TheMostLikely"]		= "Il posto più probabile per questa fonte è&nbsp;<i>%INF_FACT%</i>";

// -- RA_FOLDER MESSAGES
$pgv_lang["ra_Folder"]			= "Cartella";
$pgv_lang["ra_Edit_Gen_Task"]		= "Modifica attività generata";
$pgv_lang["ra_Start_Date"]			= "Data di inizio";
$pgv_lang["ra_Folder_View"]			= "Visualizzazione cartella";
$pgv_lang["ra_Task_View"]			= "Visualizzazione attività";
$pgv_lang["ra_page_header"]			= "Cartelle ".$pgv_lang["ra_RA_name"];
$pgv_lang["ra_no_folder_name"]		= "Il campo Nome cartella deve essere compilato.";
$pgv_lang["ra_add_folder"]			= "Aggiungi cartella";
$pgv_lang["ra_Folder_Name"]			= "Nome cartella";
$pgv_lang["ra_Parent_Folder"]		= "Cartella padre";
$pgv_lang["ra_No_Parent"]			= "Nessuna cartella padre";
$pgv_lang["ra_Folder_names_must_be_unique"]	= "I nomi delle cartelle devono essere univoci.";
$pgv_lang["ra_folder_submitted"]		= "La tua cartella è stata inviata";
$pgv_lang["ra_folder_problem"]		= "Si è verificato un problema con l'aggiunta della cartella, riprova.";

// -- RA_TAB MISSING INFO BUTTON
$pgv_lang["ra_task_entry"]			= "Crea nuova attività";

//-- ERROR MESSAGES
$pgv_lang["ra_no_folder"]			= "Non esiste alcuna cartella. Crea prima una nuova cartella.";

//-- RA_VIEWTASK MESSAGES
$pgv_lang["ra_view_task"]			= "Visualizza attività";
$pgv_lang["ra_no_indi_tasks"]		= "Nessun compito è associato a questa persona";
$pgv_lang["ra_no_sour_tasks"]		= "Nessun compito è associato a questa fonte";
$pgv_lang["ra_assigned"]			= "Assegnato";

//-- RA_ADDTASK MESSAGES
$pgv_lang["ra_add_new_task"]		= "Aggiungi nuova attività";
$pgv_lang["ra_submit"]			= "Invia";
$pgv_lang["ra_save_and_complete"]		= "Salva e completa";
$pgv_lang["ra_assign_task"]			= "Assegna attività";
$pgv_lang["ra_AddTask"]			= "Aggiungi attività";

//-- RA_COMMENT MESSAGES
$pgv_lang["ra_comment_body"]		= "Commento";
$pgv_lang["ra_add_new_comment"]		= "Aggiungi nuovo commento";
$pgv_lang["ra_edit_comment"]		= "Modifica commento";
$pgv_lang["ra_comment_success"]		= "Il tuo commento è stato aggiunto con successo.";
$pgv_lang["ra_comment_delete_check"]	= "Sei sicuro di voler eliminare questo commento?";

//-- RA_CONFIGURE PRIVACY MESSAGES
$pgv_lang["ra_configure_privacy"]		= "Configura la privacy";
$pgv_lang["ra_show_my_tasks"]		= "Mostra «Miei compiti»";
$pgv_lang["ra_show_add_task"]		= "Mostra «Aggiungi attività»";
$pgv_lang["ra_show_auto_gen_task"]		= "Mostra «Generazione automatica attività»";
$pgv_lang["ra_show_view_folders"]		= "Mostra «Visualizza cartelle»";
$pgv_lang["ra_show_add_folder"]		= "Mostra «Aggiungi cartella»";
$pgv_lang["ra_show_add_unlinked_source"]	= "Mostra «Aggiungi origine non collegata»";
$pgv_lang["ra_show_view_probabilities"]	= "Mostra «Visualizza probabilità»";

//-- Census Forms
$pgv_lang["ra_rows"]			= "Numero di righe";
$pgv_lang["ra_state"]			= "Stato";
$pgv_lang["ra_call/url"]			= "Numero di catalogo o URL";
$pgv_lang["ra_enumDate"]			= "Data di enumerazione";
$pgv_lang["ra_county"]			= "Contea";
$pgv_lang["ra_city"]			= "Città";
$pgv_lang["ra_complete_title"]		= "Completa un'attività";
$pgv_lang["ra_select_form"]			= "Scegli il modulo";
$pgv_lang["ra_choose_form_label"]		= "Seleziona il modulo di ricerca congiunta";
$pgv_lang["ra_book"]			= "Libro";
$pgv_lang["ra_folio"]			= "Foglio";
$pgv_lang["ra_uk_county"]			= "Contea";
$pgv_lang["ra_uk_boro"]			= "Città o borgo";
$pgv_lang["ra_uk_place"]			= "Posto";

$pgv_lang["ra_AssIndiFacts"]			= "Associare i fatti della persona";
$pgv_lang["ra_AssFamFacts"]			= "Associare i fatti familiari";
$pgv_lang["ra_facts"]			= "Fatti";
$pgv_lang["ra_fact"]			= "Fatto";
$pgv_lang["ra_remove"]			= "eliminare";
$pgv_lang["ra_inferred_facts"]		= "Fatti dedotti";
$pgv_lang["ra_person"]			= "Persona";
$pgv_lang["ra_reason"]			= "Motivo";
$pgv_lang["ra_success"]			= "Successo!";

$pgv_lang["ra_registration_number"]		= "Numero di registrazione";
$pgv_lang["ra_serial_number"]		= "Numero di serie";
$pgv_lang["ra_number"]			= "Numero";
$pgv_lang["ra_order_number"]		= "Numero dell'ordine";

//-- MY TASK BLOCK
$pgv_lang["ra_mytasks_block"]		= $pgv_lang["ra_RA_name"];
$pgv_lang["ra_mytasks_edit"]			= "Modificare";
$pgv_lang["ra_mytasks_unassigned"]		= "Non assegnato";
$pgv_lang["ra_mytask_show_tasks"]		= "Mostrare le attività non assegnate?";
$pgv_lang["ra_mytask_show_completed"]	= "Mostrare le attività completate?";

//-- Auto Search Assistant 
$pgv_lang["ra_autosearch_surname"]		= "Cognome";
$pgv_lang["ra_autosearch_givenname"]		= "Nomi di battesimo";
$pgv_lang["ra_autosearch_fullname"]		= "Nome";
$pgv_lang["ra_autosearch_firstname"]		= "Nome di battesimo";
$pgv_lang["ra_autosearch_middlename"]	= "Nomi di mezzo";
$pgv_lang["ra_autosearch_byear"]		= "Anno di nascita";
$pgv_lang["ra_autosearch_bloc"]		= "Luogo di nascita";
$pgv_lang["ra_autosearch_myear"]		= "Anno del matrimonio";
$pgv_lang["ra_autosearch_mloc"]		= "Luogo del matrimonio";
$pgv_lang["ra_autosearch_dyear"]		= "Anno della morte";
$pgv_lang["ra_autosearch_dloc"]		= "Luogo della morte";
$pgv_lang["ra_autosearch_gender"]		= "Genere";
$pgv_lang["ra_autosearch_ssurname"]		= "Cognome del coniuge";
$pgv_lang["ra_autosearch_sgivennames"]	= "Nomi dati del coniuge";
$pgv_lang["ra_autosearch_sfullname"]		= "Nome del coniuge";
$pgv_lang["ra_autosearch_fsurname"]		= "Cognome del padre";
$pgv_lang["ra_autosearch_fgivennames"]	= "Nomi dati dal padre";
$pgv_lang["ra_autosearch_ffullname"]		= "Nome del padre";
$pgv_lang["ra_autosearch_msurname"]		= "Cognome della madre";
$pgv_lang["ra_autosearch_mgivennames"]	= "Nomi dati della madre";
$pgv_lang["ra_autosearch_mfullname"]		= "Nome della madre";
$pgv_lang["ra_autosearch_country"]		= "Paese";
$pgv_lang["ra_autosearch_cemetery"]		= "Cimitero";
$pgv_lang["ra_autosearch_plugin_name"]	= "";
$pgv_lang["ra_autosearch_plugin"]		= "#pgv_lang[ra_autosearch_plugin_name]# Plug-in";
$pgv_lang["ra_autosearch_search"]		= "Cercare";
$pgv_lang["ra_autosearch_keywords"]		= "Parole chiave";

//Folder deletion error messages
$pgv_lang["ra_has_tasks"]			= "La cartella contiene attività e non può essere eliminata";
$pgv_lang["ra_has_folders"]			= "La cartella contiene cartelle e non può essere eliminata";
?>
