<?php
/**
 * Polish language file for PhpGedView Research Assistant module
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Research_Assistant
 * @version $Id: lang.pl.php 7377 2024-10-18 13:50:13Z canajun2eh $
 *
 * The companion file to this is help_text.pl.php, which contains most of the lengthy texts.
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

// -- To avoid having references to $pgv_lang["whatever"], copy the definitions from the original PGV language files to our own
$pgv_lang["ra_view"]			= "Widzieć";
$pgv_lang["ra_description"]			= "Opis";
$pgv_lang["ra_source"]			= "Źródło";
$pgv_lang["ra_sources"]			= "Źródła";
$pgv_lang["ra_people"]			= "Osoby";
$pgv_lang["ra_comments"]			= "Uwagi";
$pgv_lang["ra_edit"]			= "Edytuj";
$pgv_lang["ra_save"]			= "Zapisz";
$pgv_lang["ra_cancel"]			= "Anuluj";
$pgv_lang["ra_delete"]			= "Usuń";
$pgv_lang["ra_no"]				= "Nie";
$pgv_lang["ra_yes"]				= "Tak";
$pgv_lang["ra_ellipsis"]			= "\xE2\x80\xA6";
$pgv_lang["ra_add"]			= "Dodać";
$pgv_lang["ra_close_window"]		= "Zamknij okno";
$pgv_lang["ra_config_block"]			= "Regulować";
$pgv_lang["ra_page"]			= "Strona";
$pgv_lang["ra_reset"]			= "Przywróć";
$pgv_lang["ra_title"]			= "Tytuł";
$pgv_lang["ra_add_media"]			= "Dodaj nowy element multimedialny";
$pgv_lang["ra_choose_search_site"]		= "Wybierz witrynę wyszukiwania";
$pgv_lang["ra_pid_search_for"]		= "O kim chcesz szukać informacji w zewnętrznych serwisach genealogicznych?";
$pgv_lang["ra_manage_research"]		= "Zarządzaj badaniami";
$pgv_lang["ra_analyze_database"]		= "Analizuj bazę danych";
$pgv_lang["ra_analyze_data"]			= "Analizuj moje dane";
$pgv_lang["ra_missing_info"] 			= "Brakujące informacje";
$pgv_lang["ra_auto_search_text"]		= "Szukaj w zewnętrznych źródłach internetowych";
$pgv_lang["ra_task_list"]			= "Zadania";
$pgv_lang["ra_next"]			= "Następny";
$pgv_lang["ra_DataCorrelations"]		= "Korelacje danych";

/*
 *		Special handling of colons that either precede text in RTL languages or follow text in LTR languages
 *		Depending on the active language, either one of the following two variables must contain that colon symbol,
 *		and the other must be empty. To use this, you should code something like
 *			$output = "{$pgv_lang['ra-colon_rtl']}{$text}{$pgv_lang['ra-colon_ltr']}";
 *		or
 *			$output = $pgv_lang["ra-colon_rtl"].$text.$pgv_lang["ra-colon_ltr"];
 */
$pgv_lang["ra_colon_rtl"]			= "";		// Use this to put that colon to the left of text in RTL languages
$pgv_lang["ra_colon_ltr"]			= ":";		// Use this to put that colon to the right of text in LTR languages

// -- MENU ITEM MESSAGES
$pgv_lang["ra_my_tasks"]			= "Moje zadania";
$pgv_lang["ra_add_task"]			= "Dodaj zadanie";
$pgv_lang["ra_view_folders"]			= "Wyświetl foldery";
$pgv_lang["ra_view_probabilities"]		= "Wyświetl prawdopodobieństwa";
$pgv_lang["ra_up_folder"]			= "Wyższy";
$pgv_lang["ra_edit_folder"]			= "Dodaj lub edytuj folder";
$pgv_lang["ra_Add_folder"]			= "Dodaj folder";
$pgv_lang["ra_Edit_folder"]			= "Edytuj folder";
$pgv_lang["ra_gen_tasks"]			= "Automatyczne tworzenie zadań";
$pgv_lang["ra_generate"]			= "Tworzyć";

// -- RA GENERAL MESSAGES
$pgv_lang["ra_RA_name"]				= "Asystent Badawczy";
$pgv_lang["ra_edit_task"]			= "Edytuj zadanie";
$pgv_lang["ra_completed"]			= "Kompletne";
$pgv_lang["ra_complete"]			= "Kompletne";
$pgv_lang["ra_incomplete"]			= "Niekompletne";
$pgv_lang["ra_created"]			= "Utworzone";
$pgv_lang["ra_details"]			= "Bliższe dane";
$pgv_lang["ra_result"]			= "Wynik";
$pgv_lang["ra_okay"]			= "Dobra";
$pgv_lang["ra_editform"]			= "Edytuj dane formularza";
$pgv_lang["ra_FilterBy"]			= "Filtruj według";
$pgv_lang["ra_Recalculate"]			= "Przelicz";
$pgv_lang["ra_LocalData"]			= "Dane lokalne";
$pgv_lang["ra_RelatedRecord"]		= "Powiązany rekord";
$pgv_lang["ra_RelatedData"]			= "Powiązane dane";
$pgv_lang["ra_Fields"]			= "Liczba pól";
$pgv_lang["ra_FieldName"]			= "Nazwa pola";
$pgv_lang["ra_InputType"]			= "Typ wejścia";
$pgv_lang["ra_FormBuilder"]			= "Kreator formularzy";
$pgv_lang["ra_FormName"]			= "Wprowadź nazwę formularza";
$pgv_lang["ra_MultiplePeople"]		= "Czy formularz dotyczy więcej niż jednej osoby?";
$pgv_lang["ra_FormDescription"]		= "Wprowadź opis formularza";
$pgv_lang["ra_FormGeneration"]		= "Utworzenie formularza ukończone!";
$pgv_lang["ra_CustomField"]			= "Spersonalizowana nazwa pola";
$pgv_lang["ra_txt"]				= "Tekst";
$pgv_lang["ra_checkbox"]			= "Pole wyboru";
$pgv_lang["ra_radiobutton"]			= "Przycisk radiowy";
$pgv_lang["ra_EnterResults"]			= "Wprowadź wyniki";
$pgv_lang["ra_generate_tasks"]		= "Utwórz zadania z TODO";
$pgv_lang["ra_SelectFolder"]			= "Wybierz folder";
$pgv_lang["ra_done"]			= "Zrobione";
$pgv_lang["ra_LocalPercent"]			= "Lokalny procent";
$pgv_lang["ra_GlobalPercent"]		= "Globalny procent";
$pgv_lang["ra_Average"]			= "Przeciętny";
$pgv_lang["ra_NoData"]			= "Brak danych!";
$pgv_lang["ra_NotEnoughData"]		= "Za mało danych!";
$pgv_lang["ra_IncompleteDate"]	= "Niekompletna data <i>(%INF_FACT%)</i>";
$pgv_lang["ra_InferIndvBirthPlac"]		= "Istnieje %PERCENT% szans, że miejsce urodzenia jest&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvDeathPlac"]		= "Istnieje %PERCENT% szans, że miejsce śmierci jest&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvSurn"]			= "Istnieje %PERCENT% szans, że nazwisko jest&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvMarriagePlace"]	= "Istnieje %PERCENT% szans, że miejsce zawarcia związku małżeńskiego jest&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvGivn"]			= "Istnieje %PERCENT% szans, że podane imię jest:&nbsp<i>%INF_FACT%</i>";
$pgv_lang["ra_All"]				= "Wszystko";
$pgv_lang["ra_More"]			= "Więcej";
$pgv_lang["ra_ThereIsChance"]		= "Możliwe źródła mogą obejmować";
$pgv_lang["ra_TheMostLikely"]		= "Najbardziej prawdopodobnym miejscem tego źródła jest&nbsp;<i>%INF_FACT%</i>";

// -- RA_FOLDER MESSAGES
$pgv_lang["ra_Folder"]			= "Falcówka";
$pgv_lang["ra_Edit_Gen_Task"]		= "Edytuj wygenerowane zadanie";
$pgv_lang["ra_Start_Date"]			= "Data rozpoczęcia";
$pgv_lang["ra_Folder_View"]			= "Widok folderu";
$pgv_lang["ra_Task_View"]			= "Widok zadania";
$pgv_lang["ra_page_header"]			= $pgv_lang["ra_RA_name"]." Foldery";
$pgv_lang["ra_no_folder_name"]		= "Pole nazwy folderu musi być wypełnione.";
$pgv_lang["ra_add_folder"]			= "Dodaj folder";
$pgv_lang["ra_Folder_Name"]			= "Nazwa folderu";
$pgv_lang["ra_Parent_Folder"]		= "Folder nadrzędny";
$pgv_lang["ra_No_Parent"]			= "Brak folderu nadrzędnego";
$pgv_lang["ra_Folder_names_must_be_unique"]	= "Nazwy folderów muszą być unikalne.";
$pgv_lang["ra_folder_submitted"]		= "Twój folder został przesłany";
$pgv_lang["ra_folder_problem"]		= "Wystąpił problem z dodaniem folderu. Spróbuj ponownie.";

// -- RA_TAB MISSING INFO BUTTON
$pgv_lang["ra_task_entry"]			= "Utwórz nowe zadanie";

//-- ERROR MESSAGES
$pgv_lang["ra_no_folder"]			= "Folder nie istnieje. Najpierw utwórz nowy folder.";

//-- RA_VIEWTASK MESSAGES
$pgv_lang["ra_view_task"]			= "Wyświetl zadanie";
$pgv_lang["ra_no_indi_tasks"]		= "Z tą osobą nie są powiązane żadne zadania";
$pgv_lang["ra_no_sour_tasks"]		= "Z tym źródłem nie są powiązane żadne zadania";
$pgv_lang["ra_assigned"]			= "Przydzielony";

//-- RA_ADDTASK MESSAGES
$pgv_lang["ra_add_new_task"]		= "Dodaj nowe zadanie";
$pgv_lang["ra_submit"]			= "Składać";
$pgv_lang["ra_save_and_complete"]		= "Zapisz i zakończ";
$pgv_lang["ra_assign_task"]			= "Przypisz zadanie";
$pgv_lang["ra_AddTask"]			= "Dodaj zadanie";

//-- RA_COMMENT MESSAGES
$pgv_lang["ra_comment_body"]		= "Komentarz";
$pgv_lang["ra_add_new_comment"]		= "Dodaj nowy komentarz";
$pgv_lang["ra_edit_comment"]		= "Edytuj komentarz";
$pgv_lang["ra_comment_success"]		= "Twój komentarz został pomyślnie dodany.";
$pgv_lang["ra_comment_delete_check"]	= "Czy na pewno chcesz usunąć ten komentarz?";

//-- RA_CONFIGURE PRIVACY MESSAGES
$pgv_lang["ra_configure_privacy"]		= "Konfigurowanie prywatności";
$pgv_lang["ra_show_my_tasks"]		= "Pokaż «Moje zadania»";
$pgv_lang["ra_show_add_task"]		= "Pokaż «Dodaj zadanie»";
$pgv_lang["ra_show_auto_gen_task"]		= "Pokaż «Automatyczne generowanie zadania»";
$pgv_lang["ra_show_view_folders"]		= "Pokaż «Zobacz foldery»";
$pgv_lang["ra_show_add_folder"]		= "Pokaż «Dodaj folder»";
$pgv_lang["ra_show_add_unlinked_source"]	= "Pokaż «Dodaj niepowiązane źródło»";
$pgv_lang["ra_show_view_probabilities"]	= "Pokaż «Wyświetl prawdopodobieństwa»";

//-- Census Forms
$pgv_lang["ra_rows"]			= "Liczba rzędów";
$pgv_lang["ra_state"]			= "Stan";
$pgv_lang["ra_call/url"]			= "Numer katalogowy lub adres URL";
$pgv_lang["ra_enumDate"]			= "Data wyliczenia";
$pgv_lang["ra_county"]			= "Hrabstwo";
$pgv_lang["ra_city"]			= "Miasto";
$pgv_lang["ra_complete_title"]		= "Wykonaj zadanie";
$pgv_lang["ra_select_form"]			= "Wybierz formularz";
$pgv_lang["ra_choose_form_label"]		= "Wybierz formę wspólnych badań";
$pgv_lang["ra_book"]			= "Książka";
$pgv_lang["ra_folio"]			= "Folio";
$pgv_lang["ra_uk_county"]			= "Hrabstwo";
$pgv_lang["ra_uk_boro"]			= "Miasto lub dzielnica";
$pgv_lang["ra_uk_place"]			= "Miejsce";

$pgv_lang["ra_AssIndiFacts"]			= "Powiązanie faktów osobowych";
$pgv_lang["ra_AssFamFacts"]			= "Powiązanie faktów rodzinnych";
$pgv_lang["ra_facts"]			= "Fakty";
$pgv_lang["ra_fact"]			= "Fakt";
$pgv_lang["ra_remove"]			= "usunąć";
$pgv_lang["ra_inferred_facts"]		= "Wnioskowane fakty";
$pgv_lang["ra_person"]			= "Osoba";
$pgv_lang["ra_reason"]			= "Powód";
$pgv_lang["ra_success"]			= "Sukces!";

$pgv_lang["ra_registration_number"]		= "Numer rejestracyjny";
$pgv_lang["ra_serial_number"]		= "Numer seryjny";
$pgv_lang["ra_number"]			= "Numer";
$pgv_lang["ra_order_number"]		= "Numer zamówienia";

//-- MY TASK BLOCK
$pgv_lang["ra_mytasks_block"]		= $pgv_lang["ra_RA_name"];
$pgv_lang["ra_mytasks_edit"]			= "Redagować";
$pgv_lang["ra_mytasks_unassigned"]		= "Nieprzypisane";
$pgv_lang["ra_mytask_show_tasks"]		= "Pokazać nieprzypisane zadania?";
$pgv_lang["ra_mytask_show_completed"]	= "Pokazać ukończone zadania?";

//-- Auto Search Assistant 
$pgv_lang["ra_autosearch_surname"]		= "Nazwisko";
$pgv_lang["ra_autosearch_givenname"]		= "Imiona";
$pgv_lang["ra_autosearch_fullname"]		= "Nazwa";
$pgv_lang["ra_autosearch_firstname"]		= "Imię";
$pgv_lang["ra_autosearch_middlename"]	= "Drugie imiona";
$pgv_lang["ra_autosearch_byear"]		= "Rok urodzenia";
$pgv_lang["ra_autosearch_bloc"]		= "Miejsce urodzenia";
$pgv_lang["ra_autosearch_myear"]		= "Rok ślubu";
$pgv_lang["ra_autosearch_mloc"]		= "Miejsce ślubu";
$pgv_lang["ra_autosearch_dyear"]		= "Rok śmierci";
$pgv_lang["ra_autosearch_dloc"]		= "Miejsce śmierci";
$pgv_lang["ra_autosearch_gender"]		= "Płeć";
$pgv_lang["ra_autosearch_ssurname"]		= "Nazwisko małżonka";
$pgv_lang["ra_autosearch_sgivennames"]	= "Imiona małżonka";
$pgv_lang["ra_autosearch_sfullname"]		= "Imię małżonkae";
$pgv_lang["ra_autosearch_fsurname"]		= "Nazwisko ojca";
$pgv_lang["ra_autosearch_fgivennames"]	= "Imię ojcas";
$pgv_lang["ra_autosearch_ffullname"]		= "Imię ojca";
$pgv_lang["ra_autosearch_msurname"]		= "Nazwisko matki";
$pgv_lang["ra_autosearch_mgivennames"]	= "Imiona matki";
$pgv_lang["ra_autosearch_mfullname"]		= "Imię matki";
$pgv_lang["ra_autosearch_country"]		= "Kraj";
$pgv_lang["ra_autosearch_cemetery"]		= "Cmentarz";
$pgv_lang["ra_autosearch_plugin_name"]	= "";
$pgv_lang["ra_autosearch_plugin"]		= "#pgv_lang[ra_autosearch_plugin_name]# Wtyczka";
$pgv_lang["ra_autosearch_search"]		= "Szukaj";
$pgv_lang["ra_autosearch_keywords"]		= "Słowa kluczowe";

//Folder deletion error messages
$pgv_lang["ra_has_tasks"]			= "Folder zawiera zadania i nie można go usunąć";
$pgv_lang["ra_has_folders"]			= "Folder zawiera foldery i nie można go usunąć";
?>
