<?php
/**
 * Portuguese language file for PhpGedView Research Assistant module
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Research_Assistant
 * @version $Id: lang.pt.php 7377 2024-10-18 13:50:13Z canajun2eh $
 *
 * The companion file to this is help_text.pt.php, which contains most of the lengthy texts.
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

// -- To avoid having references to $pgv_lang["whatever"], copy the definitions from the original PGV language files to our own
$pgv_lang["ra_view"]			= "Ver";
$pgv_lang["ra_description"]			= "Descrição";
$pgv_lang["ra_source"]			= "Fonte";
$pgv_lang["ra_sources"]			= "Fontes";
$pgv_lang["ra_people"]			= "Pessoas";
$pgv_lang["ra_comments"]			= "Comentários";
$pgv_lang["ra_edit"]			= "Editar";
$pgv_lang["ra_save"]			= "Guarde";
$pgv_lang["ra_cancel"]			= "Cancelar";
$pgv_lang["ra_delete"]			= "Apagar";
$pgv_lang["ra_no"]				= "Não";
$pgv_lang["ra_yes"]				= "Sim";
$pgv_lang["ra_ellipsis"]			= "\xE2\x80\xA6";
$pgv_lang["ra_add"]			= "Adicionar";
$pgv_lang["ra_close_window"]		= "Fechar janela";
$pgv_lang["ra_config_block"]			= "Ajustar";
$pgv_lang["ra_page"]			= "Página";
$pgv_lang["ra_reset"]			= "Repor";
$pgv_lang["ra_title"]			= "Título";
$pgv_lang["ra_add_media"]			= "Adicione um novo item de média";
$pgv_lang["ra_choose_search_site"]		= "Escolha um site de pesquisa";
$pgv_lang["ra_pid_search_for"]		= "Sobre quem pretende pesquisar informações em sites externos de genealogia?";
$pgv_lang["ra_manage_research"]		= "Gerir pesquisa";
$pgv_lang["ra_analyze_database"]		= "Analisar base de dados";
$pgv_lang["ra_analyze_data"]			= "Analise meus dados";
$pgv_lang["ra_missing_info"] 			= "Informações ausentes";
$pgv_lang["ra_auto_search_text"]		= "Pesquisar em fontes externas da Webb";
$pgv_lang["ra_task_list"]			= "Tarefas";
$pgv_lang["ra_next"]			= "Próxima";
$pgv_lang["ra_DataCorrelations"]		= "Correlações de dados";

/*
 *		Special handling of colons that either precede text in RTL languages or follow text in LTR languages
 *		Depending on the active language, either one of the following two variables must contain that colon symbol,
 *		and the other must be empty. To use this, you should code something like
 *			$output = "{$pgv_lang['ra-colon_rtl']}{$text}{$pgv_lang['ra-colon_ltr']}";
 *		or
 *			$output = $pgv_lang["ra-colon_rtl"].$text.$pgv_lang["ra-colon_ltr"];
 */
$pgv_lang["ra_colon_rtl"]			= "";		// Use this to put that colon to the left of text in RTL languages
$pgv_lang["ra_colon_ltr"]			= ":";		// Use this to put that colon to the right of text in LTR languages

// -- MENU ITEM MESSAGES
$pgv_lang["ra_my_tasks"]			= "Minhas tarefas";
$pgv_lang["ra_add_task"]			= "Adicionar tarefa";
$pgv_lang["ra_view_folders"]			= "Ver pastas";
$pgv_lang["ra_view_probabilities"]		= "Ver probabilidades";
$pgv_lang["ra_up_folder"]			= "Mais alto";
$pgv_lang["ra_edit_folder"]			= "Adicionar ou editar pasta";
$pgv_lang["ra_Add_folder"]			= "Adicionar pasta";
$pgv_lang["ra_Edit_folder"]			= "Editar pasta";
$pgv_lang["ra_gen_tasks"]			= "Criar tarefas automaticamente";
$pgv_lang["ra_generate"]			= "Criar";

// -- RA GENERAL MESSAGES
$pgv_lang["ra_RA_name"]				= "Assistente de Investigação";
$pgv_lang["ra_edit_task"]			= "Editar tarefa";
$pgv_lang["ra_completed"]			= "Completa";
$pgv_lang["ra_complete"]			= "Completa";
$pgv_lang["ra_incomplete"]			= "Incompleta";
$pgv_lang["ra_created"]			= "Criada";
$pgv_lang["ra_details"]			= "Detalhes";
$pgv_lang["ra_result"]			= "Resultado";
$pgv_lang["ra_okay"]			= "Ok";
$pgv_lang["ra_editform"]			= "Editar dados do formulário";
$pgv_lang["ra_FilterBy"]			= "Filtrar por";
$pgv_lang["ra_Recalculate"]			= "Recalcular";
$pgv_lang["ra_LocalData"]			= "Dados locais";
$pgv_lang["ra_RelatedRecord"]		= "Registo relacionado";
$pgv_lang["ra_RelatedData"]			= "Dados relacionados";
$pgv_lang["ra_Fields"]			= "Número de campos";
$pgv_lang["ra_FieldName"]			= "Nome do campo";
$pgv_lang["ra_InputType"]			= "Tipo de entrada";
$pgv_lang["ra_FormBuilder"]			= "Construtor de formulários";
$pgv_lang["ra_FormName"]			= "Introduza o nome do formulário";
$pgv_lang["ra_MultiplePeople"]		= "O formulário aplica-se a várias pessoas?";
$pgv_lang["ra_FormDescription"]		= "Introduza uma descrição do formulário";
$pgv_lang["ra_FormGeneration"]		= "Criação de formulário concluída!";
$pgv_lang["ra_CustomField"]			= "Nome do campo personalizado";
$pgv_lang["ra_txt"]				= "Texto";
$pgv_lang["ra_checkbox"]			= "Caixa";
$pgv_lang["ra_radiobutton"]			= "Botão de opção";
$pgv_lang["ra_EnterResults"]			= "Insira os resultados";
$pgv_lang["ra_generate_tasks"]		= "Crie tarefas de TODO";
$pgv_lang["ra_SelectFolder"]			= "Escolha a pasta";
$pgv_lang["ra_done"]			= "Concluído";
$pgv_lang["ra_LocalPercent"]			= "Percentagem local";
$pgv_lang["ra_GlobalPercent"]		= "Percentagem global";
$pgv_lang["ra_Average"]			= "Média";
$pgv_lang["ra_NoData"]			= "Sem dados!";
$pgv_lang["ra_NotEnoughData"]		= "Dados insuficientes!";
$pgv_lang["ra_IncompleteDate"]	= "Data incompleta <i>(%INF_FACT%)</i>";
$pgv_lang["ra_InferIndvBirthPlac"]		= "Existe uma probabilidade de %PERCENT% de que o local de nascimento seja&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvDeathPlac"]		= "Existe uma probabilidade de %PERCENT% de que o local da morte seja&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvSurn"]			= "Existe uma probabilidade de %PERCENT% de que o apelido seja&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvMarriagePlace"]	= "Existe uma probabilidade de %PERCENT% de que o local do casamento seja&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvGivn"]			= "Existe uma probabilidade de %PERCENT% de que o nome fornecido seja&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_All"]				= "Tudo";
$pgv_lang["ra_More"]			= "Mais";
$pgv_lang["ra_ThereIsChance"]		= "Possíveis fontes podem incluir";
$pgv_lang["ra_TheMostLikely"]		= "O local mais provável para esta fonte é&nbsp;<i>%INF_FACT%</i>";

// -- RA_FOLDER MESSAGES
$pgv_lang["ra_Folder"]			= "Pasta";
$pgv_lang["ra_Edit_Gen_Task"]		= "Editar tarefa gerada";
$pgv_lang["ra_Start_Date"]			= "Data de início";
$pgv_lang["ra_Folder_View"]			= "Visualização de pasta";
$pgv_lang["ra_Task_View"]			= "Visualização de tarefas";
$pgv_lang["ra_page_header"]			= "Pastas ".$pgv_lang["ra_RA_name"];
$pgv_lang["ra_no_folder_name"]		= "O campo do nome da pasta deve ser preenchido.";
$pgv_lang["ra_add_folder"]			= "Adicionar pasta";
$pgv_lang["ra_Folder_Name"]			= "Nome da pasta";
$pgv_lang["ra_Parent_Folder"]		= "Pasta pai";
$pgv_lang["ra_No_Parent"]			= "Nenhuma pasta pai";
$pgv_lang["ra_Folder_names_must_be_unique"]	= "Os nomes das pastas devem ser únicos.";
$pgv_lang["ra_folder_submitted"]		= "A sua pasta foi enviada";
$pgv_lang["ra_folder_problem"]		= "Ocorreu um problema ao adicionar a sua pasta. Por favor tente novamente";

// -- RA_TAB MISSING INFO BUTTON
$pgv_lang["ra_task_entry"]			= "Criar nova tarefa";

//-- ERROR MESSAGES
$pgv_lang["ra_no_folder"]			= "Nenhuma pasta existe. Crie primeiro uma nova pasta.";

//-- RA_VIEWTASK MESSAGES
$pgv_lang["ra_view_task"]			= "Ver tarefa";
$pgv_lang["ra_no_indi_tasks"]		= "Nenhuma tarefa está associada a esta pessoa";
$pgv_lang["ra_no_sour_tasks"]		= "Nenhuma tarefa está associada a esta fonte";
$pgv_lang["ra_assigned"]			= "Atribuído";

//-- RA_ADDTASK MESSAGES
$pgv_lang["ra_add_new_task"]		= "Adicionar nova tarefa";
$pgv_lang["ra_submit"]			= "Submeter";
$pgv_lang["ra_save_and_complete"]		= "Guardar e concluir";
$pgv_lang["ra_assign_task"]			= "Atribuir tarefa";
$pgv_lang["ra_AddTask"]			= "Adicionar tarefa";

//-- RA_COMMENT MESSAGES
$pgv_lang["ra_comment_body"]		= "Comentário";
$pgv_lang["ra_add_new_comment"]		= "Adicionar novo comentário";
$pgv_lang["ra_edit_comment"]		= "Editar comentário";
$pgv_lang["ra_comment_success"]		= "O seu comentário foi adicionado com sucesso.";
$pgv_lang["ra_comment_delete_check"]	= "Tem a certeza que deseja eliminar este comentário?";

//-- RA_CONFIGURE PRIVACY MESSAGES
$pgv_lang["ra_configure_privacy"]		= "Configurar a privacidade";
$pgv_lang["ra_show_my_tasks"]		= "Mostrar «Minhas tarefas»";
$pgv_lang["ra_show_add_task"]		= "Mostrar «Adicionar Tarefa»";
$pgv_lang["ra_show_auto_gen_task"]		= "Mostrar «Gerar tarefa automaticamente»";
$pgv_lang["ra_show_view_folders"]		= "Mostrar «Ver pastas»";
$pgv_lang["ra_show_add_folder"]		= "Mostrar «Adicionar pasta»";
$pgv_lang["ra_show_add_unlinked_source"]	= "Mostrar «Adicionar fonte não ligada»";
$pgv_lang["ra_show_view_probabilities"]	= "Mostrar «Ver Probabilidades»";

//-- Census Forms
$pgv_lang["ra_rows"]			= "Número de linhas";
$pgv_lang["ra_state"]			= "Estado";
$pgv_lang["ra_call/url"]			= "Número de catálogo ou URL";
$pgv_lang["ra_enumDate"]			= "Data de Enumeração";
$pgv_lang["ra_county"]			= "Condado";
$pgv_lang["ra_city"]			= "Cidade";
$pgv_lang["ra_complete_title"]		= "Conclua uma tarefa";
$pgv_lang["ra_select_form"]			= "Escolha o formulário";
$pgv_lang["ra_choose_form_label"]		= "Selecione o formulário de inquérito conjunto";
$pgv_lang["ra_book"]			= "Livro";
$pgv_lang["ra_folio"]			= "Fólio";
$pgv_lang["ra_uk_county"]			= "Condado";
$pgv_lang["ra_uk_boro"]			= "Cidade ou bairro";
$pgv_lang["ra_uk_place"]			= "Local";

$pgv_lang["ra_AssIndiFacts"]			= "Associe factos pessoais";
$pgv_lang["ra_AssFamFacts"]			= "Associe factos da família";
$pgv_lang["ra_facts"]			= "Factos";
$pgv_lang["ra_fact"]			= "Facto";
$pgv_lang["ra_remove"]			= "remova";
$pgv_lang["ra_inferred_facts"]		= "Fatos inferidos";
$pgv_lang["ra_person"]			= "Pessoa";
$pgv_lang["ra_reason"]			= "Razão";
$pgv_lang["ra_success"]			= "Sucesso!";

$pgv_lang["ra_registration_number"]		= "Número de registo";
$pgv_lang["ra_serial_number"]		= "Número de série";
$pgv_lang["ra_number"]			= "Número";
$pgv_lang["ra_order_number"]		= "Número do pedido";

//-- MY TASK BLOCK
$pgv_lang["ra_mytasks_block"]		= $pgv_lang["ra_RA_name"];
$pgv_lang["ra_mytasks_edit"]			= "Editar";
$pgv_lang["ra_mytasks_unassigned"]		= "Não atribuído";
$pgv_lang["ra_mytask_show_tasks"]		= "Mostrar tarefas não atribuídas?";
$pgv_lang["ra_mytask_show_completed"]	= "Mostrar tarefas concluídas?";

//-- Auto Search Assistant 
$pgv_lang["ra_autosearch_surname"]		= "Alcunha";
$pgv_lang["ra_autosearch_givenname"]		= "Recebem nomes";
$pgv_lang["ra_autosearch_fullname"]		= "Nome";
$pgv_lang["ra_autosearch_firstname"]		= "Nome próprio";
$pgv_lang["ra_autosearch_middlename"]	= "Nomes do meio";
$pgv_lang["ra_autosearch_byear"]		= "Ano de nascimento";
$pgv_lang["ra_autosearch_bloc"]		= "Local de nascimento";
$pgv_lang["ra_autosearch_myear"]		= "Ano de casamento";
$pgv_lang["ra_autosearch_mloc"]		= "Lugar de casamento";
$pgv_lang["ra_autosearch_dyear"]		= "Ano da morte";
$pgv_lang["ra_autosearch_dloc"]		= "Lugar da morte";
$pgv_lang["ra_autosearch_gender"]		= "Género";
$pgv_lang["ra_autosearch_ssurname"]		= "Apelido do cônjuge";
$pgv_lang["ra_autosearch_sgivennames"]	= "Nomes próprios do cônjuge";
$pgv_lang["ra_autosearch_sfullname"]		= "Nome do cônjuge";
$pgv_lang["ra_autosearch_fsurname"]		= "Apelido do pai";
$pgv_lang["ra_autosearch_fgivennames"]	= "Nomes próprios do pai";
$pgv_lang["ra_autosearch_ffullname"]		= "Nome do pai";
$pgv_lang["ra_autosearch_msurname"]		= "Apelido da mãe";
$pgv_lang["ra_autosearch_mgivennames"]	= "Nomes próprios da mãe";
$pgv_lang["ra_autosearch_mfullname"]		= "Nome da mãe";
$pgv_lang["ra_autosearch_country"]		= "País";
$pgv_lang["ra_autosearch_cemetery"]		= "Cemitério";
$pgv_lang["ra_autosearch_plugin_name"]	= "";
$pgv_lang["ra_autosearch_plugin"]		= "#pgv_lang[ra_autosearch_plugin_name]# Plug-in";
$pgv_lang["ra_autosearch_search"]		= "Pesquisa";
$pgv_lang["ra_autosearch_keywords"]		= "Palavras-chave";

//Folder deletion error messages
$pgv_lang["ra_has_tasks"]			= "A pasta contém tarefas e não pode ser eliminada";
$pgv_lang["ra_has_folders"]			= "A pasta contém pastas e não pode ser eliminada";
?>
