<?php
/**
 * Swedish language file for PhpGedView Research Assistant module
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Research_Assistant
 * @version $Id: lang.sv.php 7377 2024-10-18 13:50:13Z canajun2eh $
 *
 * The companion file to this is help_text.sv.php, which contains most of the lengthy texts.
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

// -- To avoid having references to $pgv_lang["whatever"], copy the definitions from the original PGV language files to our own
$pgv_lang["ra_view"]			= "Se";
$pgv_lang["ra_description"]			= "Beskrivning";
$pgv_lang["ra_source"]			= "Källa";
$pgv_lang["ra_sources"]			= "Källor";
$pgv_lang["ra_people"]			= "Personer";
$pgv_lang["ra_comments"]			= "Kommentarer";
$pgv_lang["ra_edit"]			= "Redigera";
$pgv_lang["ra_save"]			= "Spara";
$pgv_lang["ra_cancel"]			= "Avbryt";
$pgv_lang["ra_delete"]			= "Eliminera";
$pgv_lang["ra_no"]				= "Nej";
$pgv_lang["ra_yes"]				= "Ja";
$pgv_lang["ra_ellipsis"]			= "\xE2\x80\xA6";
$pgv_lang["ra_add"]			= "Tillägga";
$pgv_lang["ra_close_window"]		= "Stäng fönstret";
$pgv_lang["ra_config_block"]			= "Justera";
$pgv_lang["ra_page"]			= "Página";
$pgv_lang["ra_reset"]			= "Återställ";
$pgv_lang["ra_title"]			= "Titel";
$pgv_lang["ra_add_media"]			= "Lägg till ett nytt mediaobjekt";
$pgv_lang["ra_choose_search_site"]		= "Välj en sökwebbplats";
$pgv_lang["ra_pid_search_for"]		= "Om vem vill du söka på externa släktforskningssajter för information?";
$pgv_lang["ra_manage_research"]		= "Hantera forskning";
$pgv_lang["ra_analyze_database"]		= "Analysera databasen";
$pgv_lang["ra_analyze_data"]			= "Analysera mina data";
$pgv_lang["ra_missing_info"] 			= "Saknar information";
$pgv_lang["ra_auto_search_text"]		= "Sök i externa webbkällor";
$pgv_lang["ra_task_list"]			= "Uppgifter";
$pgv_lang["ra_next"]			= "Nästa";
$pgv_lang["ra_DataCorrelations"]		= "Datakorrelationer";

/*
 *		Special handling of colons that either precede text in RTL languages or follow text in LTR languages
 *		Depending on the active language, either one of the following two variables must contain that colon symbol,
 *		and the other must be empty. To use this, you should code something like
 *			$output = "{$pgv_lang['ra-colon_rtl']}{$text}{$pgv_lang['ra-colon_ltr']}";
 *		or
 *			$output = $pgv_lang["ra-colon_rtl"].$text.$pgv_lang["ra-colon_ltr"];
 */
$pgv_lang["ra_colon_rtl"]			= "";		// Use this to put that colon to the left of text in RTL languages
$pgv_lang["ra_colon_ltr"]			= ":";		// Use this to put that colon to the right of text in LTR languages

// -- MENU ITEM MESSAGES
$pgv_lang["ra_my_tasks"]			= "Mina uppgifter";
$pgv_lang["ra_add_task"]			= "Lägg till uppgift";
$pgv_lang["ra_view_folders"]			= "Visa mappar";
$pgv_lang["ra_view_probabilities"]		= "Visa sannolikheter";
$pgv_lang["ra_up_folder"]			= "Högre";
$pgv_lang["ra_edit_folder"]			= "Lägg till eller redigera mapp";
$pgv_lang["ra_Add_folder"]			= "Lägg till mapp";
$pgv_lang["ra_Edit_folder"]			= "Redigera mapp";
$pgv_lang["ra_gen_tasks"]			= "Skapa uppgifter automatiskt";
$pgv_lang["ra_generate"]			= "Skapa";

// -- RA GENERAL MESSAGES
$pgv_lang["ra_RA_name"]				= "Forskningsassistent";
$pgv_lang["ra_edit_task"]			= "Redigera uppgift";
$pgv_lang["ra_completed"]			= "Fullständig";
$pgv_lang["ra_complete"]			= "Fullständig";
$pgv_lang["ra_incomplete"]			= "Ofullständig";
$pgv_lang["ra_created"]			= "Skapats";
$pgv_lang["ra_details"]			= "Detaljer";
$pgv_lang["ra_result"]			= "Resultatet";
$pgv_lang["ra_okay"]			= "Okej";
$pgv_lang["ra_editform"]			= "Redigera formulärdata";
$pgv_lang["ra_FilterBy"]			= "Filtrera efter";
$pgv_lang["ra_Recalculate"]			= "Omräkna";
$pgv_lang["ra_LocalData"]			= "Lokala data";
$pgv_lang["ra_RelatedRecord"]		= "Relaterad post";
$pgv_lang["ra_RelatedData"]			= "Relaterade data";
$pgv_lang["ra_Fields"]			= "Antal fält";
$pgv_lang["ra_FieldName"]			= "Fältnamn";
$pgv_lang["ra_InputType"]			= "Ingångstyp";
$pgv_lang["ra_FormBuilder"]			= "Formkonstruktör";
$pgv_lang["ra_FormName"]			= "Ange formulärets namn";
$pgv_lang["ra_MultiplePeople"]		= "Gäller formuläret flera personer?";
$pgv_lang["ra_FormDescription"]		= "Ange en beskrivning av formuläret";
$pgv_lang["ra_FormGeneration"]		= "Skapandet av formulär är klart!";
$pgv_lang["ra_CustomField"]			= "Personligt fältnamn";
$pgv_lang["ra_txt"]				= "Text";
$pgv_lang["ra_checkbox"]			= "Kryssrutan";
$pgv_lang["ra_radiobutton"]			= "Radioknapp";
$pgv_lang["ra_EnterResults"]			= "Ange resultat";
$pgv_lang["ra_generate_tasks"]		= "Skapa uppgifter från TODO";
$pgv_lang["ra_SelectFolder"]			= "Välj mapp";
$pgv_lang["ra_done"]			= "Gjort";
$pgv_lang["ra_LocalPercent"]			= "Lokal procent";
$pgv_lang["ra_GlobalPercent"]		= "Global procent";
$pgv_lang["ra_Average"]			= "Genomsnitt";
$pgv_lang["ra_NoData"]			= "Inga data!";
$pgv_lang["ra_NotEnoughData"]		= "Inte tillräckligt med data!";
$pgv_lang["ra_IncompleteDate"]	= "Ofullständigt datum <i>(%INF_FACT%)</i>";
$pgv_lang["ra_InferIndvBirthPlac"]		= "Det finns en %PERCENT% chans att födelseorten är&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvDeathPlac"]		= "Det finns en %PERCENT% chans att dödsplatsen är&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvSurn"]			= "Det finns en %PERCENT% chans att efternamnet är&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvMarriagePlace"]	= "Det finns en %PERCENT% chans att äktenskapsplatsen&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvGivn"]			= "Det finns en %PERCENT% chans att förnamnet är&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_All"]				= "Alla";
$pgv_lang["ra_More"]			= "Mer";
$pgv_lang["ra_ThereIsChance"]		= "Möjliga källor kan inkludera";
$pgv_lang["ra_TheMostLikely"]		= "Den mest troliga platsen för denna källa är&nbsp;<i>%INF_FACT%</i>";

// -- RA_FOLDER MESSAGES
$pgv_lang["ra_Folder"]			= "Mapp";
$pgv_lang["ra_Edit_Gen_Task"]		= "Redigera genererad uppgift";
$pgv_lang["ra_Start_Date"]			= "Startdatum";
$pgv_lang["ra_Folder_View"]			= "Mappvy";
$pgv_lang["ra_Task_View"]			= "Uppgiftsvy";
$pgv_lang["ra_page_header"]			= $pgv_lang["ra_RA_name"]." Mappar";
$pgv_lang["ra_no_folder_name"]		= "Fältet för mappnamn måste fyllas i.";
$pgv_lang["ra_add_folder"]			= "Lägg till mapp";
$pgv_lang["ra_Folder_Name"]			= "Mappnamn";
$pgv_lang["ra_Parent_Folder"]		= "Överordnad mapp";
$pgv_lang["ra_No_Parent"]			= "Ingen överordnad mapp";
$pgv_lang["ra_Folder_names_must_be_unique"]	= "Mappnamn måste vara unika.";
$pgv_lang["ra_folder_submitted"]		= "Din mapp har skickats";
$pgv_lang["ra_folder_problem"]		= "Det har uppstått problem med att lägga till din mapp, försök igen";

// -- RA_TAB MISSING INFO BUTTON
$pgv_lang["ra_task_entry"]			= "Skapa ny uppgift";

//-- ERROR MESSAGES
$pgv_lang["ra_no_folder"]			= "Det finns ingen mapp. Skapa en ny mapp först.";

//-- RA_VIEWTASK MESSAGES
$pgv_lang["ra_view_task"]			= "Visa uppgift";
$pgv_lang["ra_no_indi_tasks"]		= "Inga uppgifter är kopplade till denna person";
$pgv_lang["ra_no_sour_tasks"]		= "Inga uppgifter är kopplade till den här källan";
$pgv_lang["ra_assigned"]			= "Tilldelad";

//-- RA_ADDTASK MESSAGES
$pgv_lang["ra_add_new_task"]		= "Lägg till ny uppgift";
$pgv_lang["ra_submit"]			= "Överlämna";
$pgv_lang["ra_save_and_complete"]		= "Spara och slutför";
$pgv_lang["ra_assign_task"]			= "Tilldela uppgift";
$pgv_lang["ra_AddTask"]			= "Lägg till uppgift";

//-- RA_COMMENT MESSAGES
$pgv_lang["ra_comment_body"]		= "Kommentar";
$pgv_lang["ra_add_new_comment"]		= "Lägg till ny kommentar";
$pgv_lang["ra_edit_comment"]		= "Redigera kommentar";
$pgv_lang["ra_comment_success"]		= "Din kommentar har lagts till.";
$pgv_lang["ra_comment_delete_check"]	= "Är du säker på att du vill ta bort den här kommentaren?";

//-- RA_CONFIGURE PRIVACY MESSAGES
$pgv_lang["ra_configure_privacy"]		= "Konfigurera Privatliv";
$pgv_lang["ra_show_my_tasks"]		= "Visa «Mina uppgifter»";
$pgv_lang["ra_show_add_task"]		= "Visa «Lägg till uppgift»";
$pgv_lang["ra_show_auto_gen_task"]		= "Visa «Autogenerera uppgift»";
$pgv_lang["ra_show_view_folders"]		= "Visa «Visa mappar»";
$pgv_lang["ra_show_add_folder"]		= "Visa «Lägg till mapp»";
$pgv_lang["ra_show_add_unlinked_source"]	= "Visa «Lägg till olänkad källa»";
$pgv_lang["ra_show_view_probabilities"]	= "Visa «Visa sannolikheter»";

//-- Census Forms
$pgv_lang["ra_rows"]			= "Antal rader";
$pgv_lang["ra_state"]			= "Staten";
$pgv_lang["ra_call/url"]			= "Katalognummer eller URL";
$pgv_lang["ra_enumDate"]			= "Uppräkningsdatum";
$pgv_lang["ra_county"]			= "Grevskap";
$pgv_lang["ra_city"]			= "Stad";
$pgv_lang["ra_complete_title"]		= "Slutför en uppgift";
$pgv_lang["ra_select_form"]			= "Välj Form";
$pgv_lang["ra_choose_form_label"]		= "Välj gemensam forskningsform";
$pgv_lang["ra_book"]			= "Boka";
$pgv_lang["ra_folio"]			= "Folio";
$pgv_lang["ra_uk_county"]			= "Grevskap";
$pgv_lang["ra_uk_boro"]			= "Stad eller stadsdel";
$pgv_lang["ra_uk_place"]			= "Plats";

$pgv_lang["ra_AssIndiFacts"]			= "Associera personfakta";
$pgv_lang["ra_AssFamFacts"]			= "Associera familjefakta";
$pgv_lang["ra_facts"]			= "Fakta";
$pgv_lang["ra_fact"]			= "Faktum";
$pgv_lang["ra_remove"]			= "ta bort";
$pgv_lang["ra_inferred_facts"]		= "Antagna fakta";
$pgv_lang["ra_person"]			= "Person";
$pgv_lang["ra_reason"]			= "Resonera";
$pgv_lang["ra_success"]			= "Framgång!";

$pgv_lang["ra_registration_number"]		= "Registreringsnummer";
$pgv_lang["ra_serial_number"]		= "Serienummer";
$pgv_lang["ra_number"]			= "Nummer";
$pgv_lang["ra_order_number"]		= "Ordernummer";

//-- MY TASK BLOCK
$pgv_lang["ra_mytasks_block"]		= $pgv_lang["ra_RA_name"];
$pgv_lang["ra_mytasks_edit"]			= "Redigera";
$pgv_lang["ra_mytasks_unassigned"]		= "Otilldelad";
$pgv_lang["ra_mytask_show_tasks"]		= "Visa otilldelade uppgifter?";
$pgv_lang["ra_mytask_show_completed"]	= "Visa utförda uppgifter?";

//-- Auto Search Assistant 
$pgv_lang["ra_autosearch_surname"]		= "Efternamn";
$pgv_lang["ra_autosearch_givenname"]		= "Förnamn";
$pgv_lang["ra_autosearch_fullname"]		= "Namn";
$pgv_lang["ra_autosearch_firstname"]		= "Förnamn";
$pgv_lang["ra_autosearch_middlename"]	= "Mellannamn";
$pgv_lang["ra_autosearch_byear"]		= "Födelseår";
$pgv_lang["ra_autosearch_bloc"]		= "Födelseplats";
$pgv_lang["ra_autosearch_myear"]		= "Äktenskapsår";
$pgv_lang["ra_autosearch_mloc"]		= "Äktenskapsplats";
$pgv_lang["ra_autosearch_dyear"]		= "Dödsår";
$pgv_lang["ra_autosearch_dloc"]		= "Dödsplats";
$pgv_lang["ra_autosearch_gender"]		= "Kön";
$pgv_lang["ra_autosearch_ssurname"]		= "Makans efternamn";
$pgv_lang["ra_autosearch_sgivennames"]	= "Makans förnamn";
$pgv_lang["ra_autosearch_sfullname"]		= "Makans namn";
$pgv_lang["ra_autosearch_fsurname"]		= "Faderns efternamn";
$pgv_lang["ra_autosearch_fgivennames"]	= "Faderns förnamn";
$pgv_lang["ra_autosearch_ffullname"]		= "Faders namn";
$pgv_lang["ra_autosearch_msurname"]		= "Moderns efternamn";
$pgv_lang["ra_autosearch_mgivennames"]	= "Moderns förnamn";
$pgv_lang["ra_autosearch_mfullname"]		= "Moderns namn";
$pgv_lang["ra_autosearch_country"]		= "Land";
$pgv_lang["ra_autosearch_cemetery"]		= "Kyrkogård";
$pgv_lang["ra_autosearch_plugin_name"]	= "";
$pgv_lang["ra_autosearch_plugin"]		= "#pgv_lang[ra_autosearch_plugin_name]# Plug-in";
$pgv_lang["ra_autosearch_search"]		= "Söka";
$pgv_lang["ra_autosearch_keywords"]		= "Nyckelord";

//Folder deletion error messages
$pgv_lang["ra_has_tasks"]			= "Mappen innehåller uppgifter och kan inte tas bort";
$pgv_lang["ra_has_folders"]			= "Mappen innehåller mappar och kan inte tas bort";
?>
