<?php
/**
 * Search Plug-in for www.ellisislandrecords.org
 *	Original URL: 'http://www.ellisislandrecords.org/search/passSearch.asp?byear_list=2&'
 *	Original Parameters: 'fname'='givenname' (ie given first name), 'lname'='last_name' (ie given last name),
 *		'birth'='byear' (ie birth year)
 *		'gen_list'='gender' (ie Gender of the person)
 *
 *	New URL: 'https://heritage.statueofliberty.org/full-passenger-search'
 *****   site does not support URL parameters so this is not an actively supported site to search
 * 
 *	New Parameters: 
 *	Unused Parameters: 
 *
 * Copyright (C) 2002 to 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @version $Id: ellisisland.php 7377 2024-10-18 13:50:13Z canajun2eh $
 * @package PhpGedView
 * @subpackage Research Assistant
 *
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

require_once PGV_ROOT.'modules/research_assistant/search_plugin/base_autosearch.php';

class AutoSearch extends Base_AutoSearch {
	function __construct() {
		parent::__construct(
			// Name of this file, without the extension.
			// NB must also define this in $pgv_lang["autosearch_plugin_name_XXXX"]
			basename(__FILE__, '.php'),
			// Plug-in name displayed 
			"EllisIslandRecords.org",  // basename(__FILE__, '.php'),
			// Search engine URL, ending in "?" or "&"
			'https://heritage.statueofliberty.org/full-passenger-search?',
			// Form method: GET or POST
			'GET',
			// Array keys are field names for the URL.
			// Array values are:
			//  function = defined in Base_AutoSearch and $pgv_lang["autosearch_XXXX"]
			//  extra    = extra html to add to the checkbox
			array(
				'initital_name'   =>array('function'=>'surname',   'extra'=>'checked="checked"'),
				'last_name'   =>array('function'=>'givenname', 'extra'=>'checked="checked"'),
				'birth_year_from'   =>array('function'=>'byear',     'extra'=>'checked="checked"')
			)
		);
	}
}

?>
