<?php
/**
 * Search Plug-in for www.familysearch.org
 *	Original URL: 'http://www.familysearch.org/Eng/search/ancestorsearchresults.asp?event_index=1&date_range=2&'
 *	Original Parameters: 'first_name'='givenname' (ie given first name), 'gsln'='last_name' (ie given last name),
 *		'event_index=1&from_date'='byear' (ie birth year), 'extra'=>'id="fs1" onchange="document.getElementById(\'fs2\').checked=false;document.getElementById(\'fs3\').checked=false;"
 *		'event_index=2&from_date'='myear' (ie married year), 'extra'=>'id="fs2" onchange="document.getElementById(\'fs1\').checked=false;document.getElementById(\'fs3\').checked=false;"
 *		'event_index=3&from_date'='dyear' (ie death year), 'extra'=>'id="fs3" onchange="document.getElementById(\'fs1\').checked=false;document.getElementById(\'fs2\').checked=false;"
 *		'fathers_first_name' ='fgivennames' (ie fathers first name),
 *		'fathers_last_name'='fsurname' (ie fathers last name),
 *		'mothers_first_name'='mgivennames' (ie mothers first name),
 *		'mothers_last_name'='msurname' (ie mothers last name),
 *		'spouses_first_name'='sgivennames' (ie spouses first name),
 *		'spouses_last_name'='ssurname' (ie spouses last name)
 *
 *	New URL: 'https://www.familysearch.org/search/record/results?'
 *	New Parameters: 'q.givenName'='givenname' (ie first name '+' middle name),
 *		'q.surname'='surname' (ie last name),
 *		'q.birthLikeDate.from'='byear' (ie birth year),
 *		'q.birthLikePlace'='bloc' (ie birth location),
 *		'q.marriageLikeDate.from'='myear' (ie marriage year),
 *		'q.marriageLikePlace'='mloc' (ie marriage location),
 *		'q.deathLikeDate.from'='dyear' (ie death year),
 *		'q.deathLikePlace'='dloc' (ie death location),
 *		'q.fatherGivenName' ='fgivennames' (ie fathers first name),
 *		'q.fatherSurname'='fsurname' (ie fathers last name),
 *		'q.motherGivenName'='mgivennames' (ie mothers first name),
 *		'q.motherSurname'='msurname' (ie mothers last name),
 *		'q.spouseGivenName'='sgivennames' (ie spouses first name),
 *		'q.spouseSurname'='ssurname' (ie spouses last name)
 *	Unused Parameters: 
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @version $Id: familysearch.php 7377 2024-10-18 13:50:13Z canajun2eh $
 * @package PhpGedView
 * @subpackage Research Assistant
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

require_once PGV_ROOT.'modules/research_assistant/search_plugin/base_autosearch.php';

class AutoSearch extends Base_AutoSearch {
	function __construct() {
		parent::__construct(
			// Name of this file, without the extension.
			// NB must also define this in $pgv_lang["autosearch_plugin_name_XXXX"]
			basename(__FILE__, '.php'),
			// Plug-in name displayed 
			"FamilySearch.org",  // basename(__FILE__, '.php'),
			// Search engine URL, ending in "?" or "&"
			'https://www.familysearch.org/search/record/results?',
			// Form method: GET or POST
			'GET',
			// Array keys are field names for the URL.
			// Array values are:
			//  function = defined in Base_AutoSearch and $pgv_lang["autosearch_XXXX"]
			//  extra    = extra html to add to the checkbox
			array(
				'q.givenName'=>array('function'=>'givenname', 'extra'=>'checked="checked"'),
				'q.surname'=>array('function'=>'surname', 'extra'=>'checked="checked"'),
				'q.birthLikeDate.from'=>array('function'=>'byear', 'extra'=>'checked="checked"'),
				'q.birthLikePlace'=>array('function'=>'bloc', 'extra'=>'checked="checked"'),
				'q.marriageLikeDate.from'=>array('function'=>'myear'),
				'q.marriageLikePlace'=>array('function'=>'mloc'),
				'q.deathLikeDate.from'=>array('function'=>'dyear'),
				'q.deathLikePlace'=>array('function'=>'dloc'),
				'q.fatherGivenName'=>array('function'=>'fgivennames'),
				'q.fatherSurname'=>array('function'=>'fsurname' ),
				'q.motherGivenName'=>array('function'=>'mgivennames'),
				'q.motherSurname'=>array('function'=>'msurname'   ),
				'q.spouseGivenName'=>array('function'=>'sgivennames'),
				'q.spouseSurname'=>array('function'=>'ssurname' )
			)
		);
	}
}

?>
